import{s as jt,n as bt,o as ut}from"../chunks/scheduler.39a43cde.js";import{S as It,i as Zt,g as M,s as a,r as o,A as Ct,h as i,f as t,c as n,j as Tt,u as y,x as p,k as ht,y as Gt,a as s,v as m,d as J,t as w,w as r}from"../chunks/index.23ec2204.js";import{D as Bt,C as U}from"../chunks/DocNotebookDropdown.21a75b74.js";import{H as d,E as ft}from"../chunks/EditOnGithub.f2d09226.js";function gt(Yl){let c,Be,Ce,fe,T,ge,h,We,j,_l='<em>Authored by: <a href="https://github.com/AkiRusProd" rel="nofollow">Rustam Akimov</a></em>',ve,b,El="This notebook shows how to use Stable Diffusion to interpolate between images.  Image interpolation using Stable Diffusion is the process of creating intermediate images that smoothly transition from one given image to another, using a generative model based on diffusion.",Xe,u,Hl="Here are some various use cases for image interpolation with Stable Diffusion:",Ve,I,Sl="<li>Data Augmentation: Stable Diffusion can augment training data for machine learning models by generating synthetic images that lie between existing data points. This can improve the generalization and robustness of machine learning models, especially in tasks like image generation, classification or object detection.</li> <li>Product Design and Prototyping: Stable Diffusion can aid in product design by generating variations of product designs or prototypes with subtle differences. This can be useful for exploring design alternatives, conducting user studies, or visualizing design iterations before committing to physical prototypes.</li> <li>Content Generation for Media Production: In media production, such as film and video editing, Stable Diffusion can be used to generate intermediate frames between key frames, enabling smoother transitions and enhancing visual storytelling. This can save time and resources compared to manual frame-by-frame editing.</li>",ke,Z,Ql="In the context of image interpolation, Stable Diffusion models are often used to navigate through a high-dimensional latent space. Each dimension represents a specific feature that has been learned by the model. By walking through this latent space and interpolating between different latent representations of images, the model is able to generate a sequence of intermediate images which show a smooth transition between the original images. There are two types of latents in stable diffusion: prompt latents and image latents.",Re,C,xl="Latent space walking involves moving through a latent space along a path defined by two or more points (representing images). By carefully selecting these points and the path between them, it is possible to control the features of the generated images, such as style, content, and other visual aspects.",Ae,G,zl="In this Notebook, we will explore examples of image interpolation using Stable Diffusion and demonstrate how latent space walking can be implemented and utilized to create smooth transitions between images. We’ll provide code snippets and visualizations that illustrate this process in action, allowing for a deeper understanding of how generative models can manipulate and morph image representations in meaningful ways.",Ye,B,Nl="First, let’s install all the required modules.",_e,f,Ee,g,Fl="Import modules",He,W,Se,v,$l="Let’s check if CUDA is available.",Qe,X,xe,V,Dl=`These settings are used to optimize the performance of PyTorch models on CUDA-enabled GPUs, especially when using mixed precision training or inference, which can be beneficial in terms of speed and memory usage.<br/>
Source: <a href="https://huggingface.co/docs/diffusers/optimization/fp16#memory-efficient-attention" rel="nofollow">https://huggingface.co/docs/diffusers/optimization/fp16#memory-efficient-attention</a>`,ze,k,Ne,R,Fe,A,Ll='The <a href="https://huggingface.co/runwayml/stable-diffusion-v1-5" rel="nofollow"><code>runwayml/stable-diffusion-v1-5</code></a> model and the <a href="https://huggingface.co/docs/diffusers/en/api/schedulers/lms_discrete" rel="nofollow"><code>LMSDiscreteScheduler</code></a> scheduler were chosen to generate images. Despite being an older technology, it continues to enjoy popularity due to its fast performance, minimal memory requirements, and the availability of numerous community fine-tuned models built on top of SD1.5. However, you are free to experiment with other models and schedulers to compare the results.',$e,Y,De,_,ql="These methods are designed to reduce the memory consumed by the GPU. If you have enough VRAM, you can skip this cell.",Le,E,Kl=`More detailed information can be found here: <a href="https://huggingface.co/docs/diffusers/en/optimization/opt_overview" rel="nofollow">https://huggingface.co/docs/diffusers/en/optimization/opt_overview</a><br/>
In particular, information about the following methods can be found here: <a href="https://huggingface.co/docs/diffusers/optimization/memory" rel="nofollow">https://huggingface.co/docs/diffusers/optimization/memory</a>`,qe,H,Ke,S,Pl="The <code>display_images</code> function converts a list of image arrays into a GIF, saves it to a specified path and returns the GIF object for display. It names the GIF file using the current time and handles any errors by printing them out.",Pe,Q,Oe,x,el,z,Ol="<li><code>seed</code>: This variable is used to set a specific random seed for reproducibility.</li> <li><code>generator</code>: This is set to a PyTorch random number generator object if a seed is provided, otherwise it is None. It ensures that the operations using it have reproducible outcomes.</li> <li><code>guidance_scale</code>: This parameter controls the extent to which the model should follow the prompt in text-to-image generation tasks, with higher values leading to stronger adherence to the prompt.</li> <li><code>num_inference_steps</code>: This specifies the number of steps the model takes to generate an image. More steps can lead to a higher quality image but take longer to generate.</li> <li><code>num_interpolation_steps</code>: This determines the number of steps used when interpolating between two points in the latent space, affecting the smoothness of transitions in generated       animations.</li> <li><code>height</code>: The height of the generated images in pixels.</li> <li><code>width</code>: The width of the generated images in pixels.</li> <li><code>save_path</code>: The file system path where the generated gifs will be saved.</li>",ll,N,tl,F,sl,$,et="In this example, interpolation between positive and negative prompt embeddings allows exploration of space between two conceptual points defined by prompts, potentially leading to variety of images blending characteristics dictated by prompts gradually. In this case, interpolation involves adding scaled deltas to original embeddings, creating a series of new embeddings that will be used later to generate images with smooth transitions between different states based on the original prompt.",al,D,lt='<img src="https://huggingface.co/datasets/huggingface/cookbook-images/resolve/main/sd_interpolation_1.gif" alt="Example 1"/>',nl,L,tt="First of all, we need to tokenize and obtain embeddings for both positive and negative text prompts. The positive prompt guides the image generation towards the desired characteristics, while the negative prompt steers it away from unwanted features.",Ml,q,il,K,st="Now let’s look at the code part that generates a random initial vector using a normal distribution that is structured to match the dimensions expected by the diffusion model (UNet). This allows for the reproducibility of the results by optionally using a random number generator. After creating the initial vector, the code performs a series of interpolations between the two embeddings (positive and negative prompts), by incrementally adding a small step size for each iteration. The results are stored in a list named “walked_embeddings”.",pl,P,ol,O,at="Finally, let’s generate a series of images based on interpolated embeddings and then displaying these images. We’ll iterate over an array of embeddings, using each to generate an image with specified characteristics like height, width, and other parameters relevant to image generation. Then we’ll collect these images into a list. Once generation is complete we’ll call the <code>display_image</code> function to save and display these images as GIF at a given save path.",yl,ee,ml,le,Jl,te,nt="Unlike the first example, in this one, we are performing interpolation between the two embeddings of the diffusion model itself, not the prompts. Please note that in this case, we use the slerp function for interpolation. However, there is nothing stopping us from adding a constant value to one embedding instead.",wl,se,Mt='<img src="https://huggingface.co/datasets/huggingface/cookbook-images/resolve/main/sd_interpolation_2.gif" alt="Example 2"/>',rl,ae,it="The function presented below stands for Spherical Linear Interpolation. It is a method of interpolation on the surface of a sphere. This function is commonly used in computer graphics to animate rotations in a smooth manner and can also be used to interpolate between high-dimensional data points in machine learning, such as latent vectors used in generative models.",Ul,ne,pt=`The source is from Andrej Karpathy’s gist: <a href="https://gist.github.com/karpathy/00103b0037c5aaea32fe1da1af553355" rel="nofollow">https://gist.github.com/karpathy/00103b0037c5aaea32fe1da1af553355</a>.<br/>
A more detailed explanation of this method can be found at: <a href="https://en.wikipedia.org/wiki/Slerp" rel="nofollow">https://en.wikipedia.org/wiki/Slerp</a>.`,cl,Me,dl,ie,Tl,pe,hl,oe,ot="In contrast to the first example, where we moved away from a single prompt, in this example, we will be interpolating between any number of prompts. To do so, we will take consecutive pairs of prompts and create smooth transitions between them. Then, we will combine the interpolations of these consecutive pairs, and instruct the model to generate images based on them. For interpolation we will use the slerp function, as in the second example.",jl,ye,yt='<img src="https://huggingface.co/datasets/huggingface/cookbook-images/resolve/main/sd_interpolation_3.gif" alt="Example 3"/>',bl,me,mt="Once again, let’s tokenize and obtain embeddings but this time for multiple positive and negative text prompts.",ul,Je,Il,we,Jt="As stated earlier, we will take consecutive pairs of prompts and create smooth transitions between them with <code>slerp</code> function.",Zl,re,Cl,Ue,wt="Finally, we need to generate images based on the embeddings.",Gl,ce,Bl,de,fl,Te,rt='This example was taken from: <a href="https://keras.io/examples/generative/random_walks_with_stable_diffusion/" rel="nofollow">https://keras.io/examples/generative/random_walks_with_stable_diffusion/</a>',gl,he,Ut="Let’s imagine that we have two noise components, which we’ll call x and y. We start by moving from 0 to 2π and at each step we add the cosine of x and the sine of y to the result. Using this approach, at the end of our movement we end up with the same noise values ​​that we started with. This means that vectors end up turning into themselves, ending our movement.",Wl,je,ct='<img src="https://huggingface.co/datasets/huggingface/cookbook-images/resolve/main/sd_interpolation_4.gif" alt="Example 4"/>',vl,be,Xl,ue,Vl,Ie,dt="Moving forward, you can explore various parameters such as guidance scale, seed, and number of interpolation steps to observe how they affect the generated images. Additionally, consider trying out different prompts and schedulers to further enhance your results. Another valuable step would be to implement linear interpolation (<code>linspace</code>) instead of spherical linear interpolation (<code>slerp</code>) and compare the results to gain deeper insights into the interpolation process.",kl,Ze,Rl,Ge,Al;return T=new Bt({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/cookbook/blob/enterprise-dev-spaces-recipe/notebooks/en/stable_diffusion_interpolation.ipynb"}]}}),h=new d({props:{title:"Images Interpolation with Stable Diffusion",local:"images-interpolation-with-stable-diffusion",headingTag:"h2"}}),f=new U({props:{code:"IXBpcCUyMGluc3RhbGwlMjAtcSUyMGRpZmZ1c2VycyUyMHRyYW5zZm9ybWVycyUyMHhmb3JtZXJzJTIwYWNjZWxlcmF0ZSUwQSFwaXAlMjBpbnN0YWxsJTIwLXElMjBudW1weSUyMHNjaXB5JTIwZnRmeSUyMFBpbGxvdw==",highlighted:`!pip install -q diffusers transformers xformers accelerate
!pip install -q numpy scipy ftfy Pillow`,wrap:!1}}),W=new U({props:{code:"aW1wb3J0JTIwdG9yY2glMEFpbXBvcnQlMjBudW1weSUyMGFzJTIwbnAlMEFpbXBvcnQlMjBvcyUwQSUwQWltcG9ydCUyMHRpbWUlMEElMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFmcm9tJTIwSVB5dGhvbiUyMGltcG9ydCUyMGRpc3BsYXklMjBhcyUyMElQZGlzcGxheSUwQWZyb20lMjB0cWRtLmF1dG8lMjBpbXBvcnQlMjB0cWRtJTBBJTBBZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTBBZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMCglMEElMjAlMjAlMjAlMjBERElNU2NoZWR1bGVyJTJDJTBBJTIwJTIwJTIwJTIwUE5ETVNjaGVkdWxlciUyQyUwQSUyMCUyMCUyMCUyMExNU0Rpc2NyZXRlU2NoZWR1bGVyJTJDJTBBJTIwJTIwJTIwJTIwRFBNU29sdmVyTXVsdGlzdGVwU2NoZWR1bGVyJTJDJTBBJTIwJTIwJTIwJTIwRXVsZXJBbmNlc3RyYWxEaXNjcmV0ZVNjaGVkdWxlciUyQyUwQSUyMCUyMCUyMCUyMEV1bGVyRGlzY3JldGVTY2hlZHVsZXIlMkMlMEEpJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMGxvZ2dpbmclMEElMEFsb2dnaW5nLnNldF92ZXJib3NpdHlfZXJyb3IoKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">import</span> os

<span class="hljs-keyword">import</span> time

<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">from</span> IPython <span class="hljs-keyword">import</span> display <span class="hljs-keyword">as</span> IPdisplay
<span class="hljs-keyword">from</span> tqdm.auto <span class="hljs-keyword">import</span> tqdm

<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> (
    DDIMScheduler,
    PNDMScheduler,
    LMSDiscreteScheduler,
    DPMSolverMultistepScheduler,
    EulerAncestralDiscreteScheduler,
    EulerDiscreteScheduler,
)
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> logging

logging.set_verbosity_error()`,wrap:!1}}),X=new U({props:{code:"cHJpbnQodG9yY2guY3VkYS5pc19hdmFpbGFibGUoKSklMEElMEFkZXZpY2UlMjAlM0QlMjB0b3JjaC5kZXZpY2UoJTIyY3VkYSUyMiklMjBpZiUyMHRvcmNoLmN1ZGEuaXNfYXZhaWxhYmxlKCklMjBlbHNlJTIwdG9yY2guZGV2aWNlKCUyMmNwdSUyMik=",highlighted:`<span class="hljs-built_in">print</span>(torch.cuda.is_available())

device = torch.device(<span class="hljs-string">&quot;cuda&quot;</span>) <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> torch.device(<span class="hljs-string">&quot;cpu&quot;</span>)`,wrap:!1}}),k=new U({props:{code:"dG9yY2guYmFja2VuZHMuY3Vkbm4uYmVuY2htYXJrJTIwJTNEJTIwVHJ1ZSUwQXRvcmNoLmJhY2tlbmRzLmN1ZGEubWF0bXVsLmFsbG93X3RmMzIlMjAlM0QlMjBUcnVl",highlighted:`torch.backends.cudnn.benchmark = <span class="hljs-literal">True</span>
torch.backends.cuda.matmul.allow_tf32 = <span class="hljs-literal">True</span>`,wrap:!1}}),R=new d({props:{title:"Model",local:"model",headingTag:"h3"}}),Y=new U({props:{code:"bW9kZWxfbmFtZV9vcl9wYXRoJTIwJTNEJTIwJTIycnVud2F5bWwlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMEElMEFzY2hlZHVsZXIlMjAlM0QlMjBMTVNEaXNjcmV0ZVNjaGVkdWxlciglMEElMjAlMjAlMjAlMjBiZXRhX3N0YXJ0JTNEMC4wMDA4NSUyQyUyMGJldGFfZW5kJTNEMC4wMTIlMkMlMjBiZXRhX3NjaGVkdWxlJTNEJTIyc2NhbGVkX2xpbmVhciUyMiUyQyUyMG51bV90cmFpbl90aW1lc3RlcHMlM0QxMDAwJTBBKSUwQSUwQSUwQXBpcGUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwbW9kZWxfbmFtZV9vcl9wYXRoJTJDJTBBJTIwJTIwJTIwJTIwc2NoZWR1bGVyJTNEc2NoZWR1bGVyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDMyJTJDJTBBKS50byhkZXZpY2UpJTBBJTBBJTIzJTIwRGlzYWJsZSUyMGltYWdlJTIwZ2VuZXJhdGlvbiUyMHByb2dyZXNzJTIwYmFyJTJDJTIwd2UnbGwlMjBkaXNwbGF5JTIwb3VyJTIwb3duJTBBcGlwZS5zZXRfcHJvZ3Jlc3NfYmFyX2NvbmZpZyhkaXNhYmxlJTNEVHJ1ZSk=",highlighted:`model_name_or_path = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>

scheduler = LMSDiscreteScheduler(
    beta_start=<span class="hljs-number">0.00085</span>, beta_end=<span class="hljs-number">0.012</span>, beta_schedule=<span class="hljs-string">&quot;scaled_linear&quot;</span>, num_train_timesteps=<span class="hljs-number">1000</span>
)


pipe = StableDiffusionPipeline.from_pretrained(
    model_name_or_path,
    scheduler=scheduler,
    torch_dtype=torch.float32,
).to(device)

<span class="hljs-comment"># Disable image generation progress bar, we&#x27;ll display our own</span>
pipe.set_progress_bar_config(disable=<span class="hljs-literal">True</span>)`,wrap:!1}}),H=new U({props:{code:"JTIzJTIwT2ZmbG9hZGluZyUyMHRoZSUyMHdlaWdodHMlMjB0byUyMHRoZSUyMENQVSUyMGFuZCUyMG9ubHklMjBsb2FkaW5nJTIwdGhlbSUyMG9uJTIwdGhlJTIwR1BVJTIwY2FuJTIwcmVkdWNlJTIwbWVtb3J5JTIwY29uc3VtcHRpb24lMjB0byUyMGxlc3MlMjB0aGFuJTIwM0dCLiUwQXBpcGUuZW5hYmxlX21vZGVsX2NwdV9vZmZsb2FkKCklMEElMEElMjMlMjBUaWdodGVyJTIwb3JkZXJpbmclMjBvZiUyMG1lbW9yeSUyMHRlbnNvcnMuJTBBcGlwZS51bmV0LnRvKG1lbW9yeV9mb3JtYXQlM0R0b3JjaC5jaGFubmVsc19sYXN0KSUwQSUwQSUyMyUyMERlY29kaW5nJTIwbGFyZ2UlMjBiYXRjaGVzJTIwb2YlMjBpbWFnZXMlMjB3aXRoJTIwbGltaXRlZCUyMFZSQU0lMjBvciUyMGJhdGNoZXMlMjB3aXRoJTIwMzIlMjBpbWFnZXMlMjBvciUyMG1vcmUlMjBieSUyMGRlY29kaW5nJTIwdGhlJTIwYmF0Y2hlcyUyMG9mJTIwbGF0ZW50cyUyMG9uZSUyMGltYWdlJTIwYXQlMjBhJTIwdGltZS4lMEFwaXBlLmVuYWJsZV92YWVfc2xpY2luZygpJTBBJTBBJTIzJTIwU3BsaXR0aW5nJTIwdGhlJTIwaW1hZ2UlMjBpbnRvJTIwb3ZlcmxhcHBpbmclMjB0aWxlcyUyQyUyMGRlY29kaW5nJTIwdGhlJTIwdGlsZXMlMkMlMjBhbmQlMjB0aGVuJTIwYmxlbmRpbmclMjB0aGUlMjBvdXRwdXRzJTIwdG9nZXRoZXIlMjB0byUyMGNvbXBvc2UlMjB0aGUlMjBmaW5hbCUyMGltYWdlLiUwQXBpcGUuZW5hYmxlX3ZhZV90aWxpbmcoKSUwQSUwQSUyMyUyMFVzaW5nJTIwRmxhc2glMjBBdHRlbnRpb24lM0IlMjBJZiUyMHlvdSUyMGhhdmUlMjBQeVRvcmNoJTIwJTNFJTNEJTIwMi4wJTIwaW5zdGFsbGVkJTJDJTIweW91JTIwc2hvdWxkJTIwbm90JTIwZXhwZWN0JTIwYSUyMHNwZWVkLXVwJTIwZm9yJTIwaW5mZXJlbmNlJTIwd2hlbiUyMGVuYWJsaW5nJTIweGZvcm1lcnMuJTBBcGlwZS5lbmFibGVfeGZvcm1lcnNfbWVtb3J5X2VmZmljaWVudF9hdHRlbnRpb24oKQ==",highlighted:`<span class="hljs-comment"># Offloading the weights to the CPU and only loading them on the GPU can reduce memory consumption to less than 3GB.</span>
pipe.enable_model_cpu_offload()

<span class="hljs-comment"># Tighter ordering of memory tensors.</span>
pipe.unet.to(memory_format=torch.channels_last)

<span class="hljs-comment"># Decoding large batches of images with limited VRAM or batches with 32 images or more by decoding the batches of latents one image at a time.</span>
pipe.enable_vae_slicing()

<span class="hljs-comment"># Splitting the image into overlapping tiles, decoding the tiles, and then blending the outputs together to compose the final image.</span>
pipe.enable_vae_tiling()

<span class="hljs-comment"># Using Flash Attention; If you have PyTorch &gt;= 2.0 installed, you should not expect a speed-up for inference when enabling xformers.</span>
pipe.enable_xformers_memory_efficient_attention()`,wrap:!1}}),Q=new U({props:{code:"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",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">display_images</span>(<span class="hljs-params">images, save_path</span>):
    <span class="hljs-keyword">try</span>:
        <span class="hljs-comment"># Convert each image in the &#x27;images&#x27; list from an array to an Image object.</span>
        images = [Image.fromarray(np.array(image[<span class="hljs-number">0</span>], dtype=np.uint8)) <span class="hljs-keyword">for</span> image <span class="hljs-keyword">in</span> images]

        <span class="hljs-comment"># Generate a file name based on the current time, replacing colons with hyphens</span>
        <span class="hljs-comment"># to ensure the filename is valid for file systems that don&#x27;t allow colons.</span>
        filename = time.strftime(<span class="hljs-string">&quot;%H:%M:%S&quot;</span>, time.localtime()).replace(<span class="hljs-string">&quot;:&quot;</span>, <span class="hljs-string">&quot;-&quot;</span>)
        <span class="hljs-comment"># Save the first image in the list as a GIF file at the &#x27;save_path&#x27; location.</span>
        <span class="hljs-comment"># The rest of the images in the list are added as subsequent frames to the GIF.</span>
        <span class="hljs-comment"># The GIF will play each frame for 100 milliseconds and will loop indefinitely.</span>
        images[<span class="hljs-number">0</span>].save(
            <span class="hljs-string">f&quot;<span class="hljs-subst">{save_path}</span>/<span class="hljs-subst">{filename}</span>.gif&quot;</span>,
            save_all=<span class="hljs-literal">True</span>,
            append_images=images[<span class="hljs-number">1</span>:],
            duration=<span class="hljs-number">100</span>,
            loop=<span class="hljs-number">0</span>,
        )
    <span class="hljs-keyword">except</span> Exception <span class="hljs-keyword">as</span> e:
        <span class="hljs-comment"># If there is an error during the process, print the exception message.</span>
        <span class="hljs-built_in">print</span>(e)

    <span class="hljs-comment"># Return the saved GIF as an IPython display object so it can be displayed in a notebook.</span>
    <span class="hljs-keyword">return</span> IPdisplay.Image(<span class="hljs-string">f&quot;<span class="hljs-subst">{save_path}</span>/<span class="hljs-subst">{filename}</span>.gif&quot;</span>)`,wrap:!1}}),x=new d({props:{title:"Generation parameters",local:"generation-parameters",headingTag:"h3"}}),N=new U({props:{code:"JTIzJTIwVGhlJTIwc2VlZCUyMGlzJTIwc2V0JTIwdG8lMjAlMjJOb25lJTIyJTJDJTIwYmVjYXVzZSUyMHdlJTIwd2FudCUyMGRpZmZlcmVudCUyMHJlc3VsdHMlMjBlYWNoJTIwdGltZSUyMHdlJTIwcnVuJTIwdGhlJTIwZ2VuZXJhdGlvbi4lMEFzZWVkJTIwJTNEJTIwTm9uZSUwQSUwQWlmJTIwc2VlZCUyMGlzJTIwbm90JTIwTm9uZSUzQSUwQSUyMCUyMCUyMCUyMGdlbmVyYXRvciUyMCUzRCUyMHRvcmNoLm1hbnVhbF9zZWVkKHNlZWQpJTBBZWxzZSUzQSUwQSUyMCUyMCUyMCUyMGdlbmVyYXRvciUyMCUzRCUyME5vbmUlMEElMEElMjMlMjBUaGUlMjBndWlkYW5jZSUyMHNjYWxlJTIwaXMlMjBzZXQlMjB0byUyMGl0cyUyMG5vcm1hbCUyMHJhbmdlJTIwKDclMjAtJTIwMTApLiUwQWd1aWRhbmNlX3NjYWxlJTIwJTNEJTIwOCUwQSUwQSUyMyUyMFRoZSUyMG51bWJlciUyMG9mJTIwaW5mZXJlbmNlJTIwc3RlcHMlMjB3YXMlMjBjaG9zZW4lMjBlbXBpcmljYWxseSUyMHRvJTIwZ2VuZXJhdGUlMjBhbiUyMGFjY2VwdGFibGUlMjBwaWN0dXJlJTIwd2l0aGluJTIwYW4lMjBhY2NlcHRhYmxlJTIwdGltZS4lMEFudW1faW5mZXJlbmNlX3N0ZXBzJTIwJTNEJTIwMTUlMEElMEElMjMlMjBUaGUlMjBoaWdoZXIlMjB5b3UlMjBzZXQlMjB0aGlzJTIwdmFsdWUlMkMlMjB0aGUlMjBzbW9vdGhlciUyMHRoZSUyMGludGVycG9sYXRpb25zJTIwd2lsbCUyMGJlLiUyMEhvd2V2ZXIlMkMlMjB0aGUlMjBnZW5lcmF0aW9uJTIwdGltZSUyMHdpbGwlMjBpbmNyZWFzZS4lMjBUaGlzJTIwdmFsdWUlMjB3YXMlMjBjaG9zZW4lMjBlbXBpcmljYWxseS4lMEFudW1faW50ZXJwb2xhdGlvbl9zdGVwcyUyMCUzRCUyMDMwJTBBJTBBJTIzJTIwSSUyMHdvdWxkJTIwbm90JTIwcmVjb21tZW5kJTIwbGVzcyUyMHRoYW4lMjA1MTIlMjBvbiUyMGVpdGhlciUyMGRpbWVuc2lvbi4lMjBUaGlzJTIwaXMlMjBiZWNhdXNlJTIwdGhpcyUyMG1vZGVsJTIwd2FzJTIwdHJhaW5lZCUyMG9uJTIwNTEyeDUxMiUyMGltYWdlJTIwcmVzb2x1dGlvbi4lMEFoZWlnaHQlMjAlM0QlMjA1MTIlMEF3aWR0aCUyMCUzRCUyMDUxMiUwQSUwQSUyMyUyMFRoZSUyMHBhdGglMjB3aGVyZSUyMHRoZSUyMGdlbmVyYXRlZCUyMEdJRnMlMjB3aWxsJTIwYmUlMjBzYXZlZCUwQXNhdmVfcGF0aCUyMCUzRCUyMCUyMiUyRm91dHB1dCUyMiUwQSUwQWlmJTIwbm90JTIwb3MucGF0aC5leGlzdHMoc2F2ZV9wYXRoKSUzQSUwQSUyMCUyMCUyMCUyMG9zLm1ha2VkaXJzKHNhdmVfcGF0aCk=",highlighted:`<span class="hljs-comment"># The seed is set to &quot;None&quot;, because we want different results each time we run the generation.</span>
seed = <span class="hljs-literal">None</span>

<span class="hljs-keyword">if</span> seed <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>:
    generator = torch.manual_seed(seed)
<span class="hljs-keyword">else</span>:
    generator = <span class="hljs-literal">None</span>

<span class="hljs-comment"># The guidance scale is set to its normal range (7 - 10).</span>
guidance_scale = <span class="hljs-number">8</span>

<span class="hljs-comment"># The number of inference steps was chosen empirically to generate an acceptable picture within an acceptable time.</span>
num_inference_steps = <span class="hljs-number">15</span>

<span class="hljs-comment"># The higher you set this value, the smoother the interpolations will be. However, the generation time will increase. This value was chosen empirically.</span>
num_interpolation_steps = <span class="hljs-number">30</span>

<span class="hljs-comment"># I would not recommend less than 512 on either dimension. This is because this model was trained on 512x512 image resolution.</span>
height = <span class="hljs-number">512</span>
width = <span class="hljs-number">512</span>

<span class="hljs-comment"># The path where the generated GIFs will be saved</span>
save_path = <span class="hljs-string">&quot;/output&quot;</span>

<span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> os.path.exists(save_path):
    os.makedirs(save_path)`,wrap:!1}}),F=new d({props:{title:"Example 1: Prompt interpolation",local:"example-1-prompt-interpolation",headingTag:"h3"}}),q=new U({props:{code:"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",highlighted:`<span class="hljs-comment"># The text prompt that describes the desired output image.</span>
prompt = <span class="hljs-string">&quot;Epic shot of Sweden, ultra detailed lake with an ren dear, nostalgic vintage, ultra cozy and inviting, wonderful light atmosphere, fairy, little photorealistic, digital painting, sharp focus, ultra cozy and inviting, wish to be there. very detailed, arty, should rank high on youtube for a dream trip.&quot;</span>
<span class="hljs-comment"># A negative prompt that can be used to steer the generation away from certain features; here, it is empty.</span>
negative_prompt = <span class="hljs-string">&quot;poorly drawn,cartoon, 2d, disfigured, bad art, deformed, poorly drawn, extra limbs, close up, b&amp;w, weird colors, blurry&quot;</span>

<span class="hljs-comment"># The step size for the interpolation in the latent space.</span>
step_size = <span class="hljs-number">0.001</span>

<span class="hljs-comment"># Tokenizing and encoding the prompt into embeddings.</span>
prompt_tokens = pipe.tokenizer(
    prompt,
    padding=<span class="hljs-string">&quot;max_length&quot;</span>,
    max_length=pipe.tokenizer.model_max_length,
    truncation=<span class="hljs-literal">True</span>,
    return_tensors=<span class="hljs-string">&quot;pt&quot;</span>,
)
prompt_embeds = pipe.text_encoder(prompt_tokens.input_ids.to(device))[<span class="hljs-number">0</span>]


<span class="hljs-comment"># Tokenizing and encoding the negative prompt into embeddings.</span>
<span class="hljs-keyword">if</span> negative_prompt <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span>:
    negative_prompt = [<span class="hljs-string">&quot;&quot;</span>]

negative_prompt_tokens = pipe.tokenizer(
    negative_prompt,
    padding=<span class="hljs-string">&quot;max_length&quot;</span>,
    max_length=pipe.tokenizer.model_max_length,
    truncation=<span class="hljs-literal">True</span>,
    return_tensors=<span class="hljs-string">&quot;pt&quot;</span>,
)
negative_prompt_embeds = pipe.text_encoder(negative_prompt_tokens.input_ids.to(device))[<span class="hljs-number">0</span>]`,wrap:!1}}),P=new U({props:{code:"JTIzJTIwR2VuZXJhdGluZyUyMGluaXRpYWwlMjBsYXRlbnQlMjB2ZWN0b3JzJTIwZnJvbSUyMGElMjByYW5kb20lMjBub3JtYWwlMjBkaXN0cmlidXRpb24lMkMlMjB3aXRoJTIwdGhlJTIwb3B0aW9uJTIwdG8lMjB1c2UlMjBhJTIwZ2VuZXJhdG9yJTIwZm9yJTIwcmVwcm9kdWNpYmlsaXR5LiUwQWxhdGVudHMlMjAlM0QlMjB0b3JjaC5yYW5kbiglMEElMjAlMjAlMjAlMjAoMSUyQyUyMHBpcGUudW5ldC5jb25maWcuaW5fY2hhbm5lbHMlMkMlMjBoZWlnaHQlMjAlMkYlMkYlMjA4JTJDJTIwd2lkdGglMjAlMkYlMkYlMjA4KSUyQyUwQSUyMCUyMCUyMCUyMGdlbmVyYXRvciUzRGdlbmVyYXRvciUyQyUwQSklMEElMEF3YWxrZWRfZW1iZWRkaW5ncyUyMCUzRCUyMCU1QiU1RCUwQSUwQSUyMyUyMEludGVycG9sYXRpbmclMjBiZXR3ZWVuJTIwZW1iZWRkaW5ncyUyMGZvciUyMHRoZSUyMGdpdmVuJTIwbnVtYmVyJTIwb2YlMjBpbnRlcnBvbGF0aW9uJTIwc3RlcHMuJTBBZm9yJTIwaSUyMGluJTIwcmFuZ2UobnVtX2ludGVycG9sYXRpb25fc3RlcHMpJTNBJTBBJTIwJTIwJTIwJTIwd2Fsa2VkX2VtYmVkZGluZ3MuYXBwZW5kKCU1QnByb21wdF9lbWJlZHMlMjAlMkIlMjBzdGVwX3NpemUlMjAqJTIwaSUyQyUyMG5lZ2F0aXZlX3Byb21wdF9lbWJlZHMlMjAlMkIlMjBzdGVwX3NpemUlMjAqJTIwaSU1RCk=",highlighted:`<span class="hljs-comment"># Generating initial latent vectors from a random normal distribution, with the option to use a generator for reproducibility.</span>
latents = torch.randn(
    (<span class="hljs-number">1</span>, pipe.unet.config.in_channels, height // <span class="hljs-number">8</span>, width // <span class="hljs-number">8</span>),
    generator=generator,
)

walked_embeddings = []

<span class="hljs-comment"># Interpolating between embeddings for the given number of interpolation steps.</span>
<span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(num_interpolation_steps):
    walked_embeddings.append([prompt_embeds + step_size * i, negative_prompt_embeds + step_size * i])`,wrap:!1}}),ee=new U({props:{code:"JTIzJTIwR2VuZXJhdGluZyUyMGltYWdlcyUyMHVzaW5nJTIwdGhlJTIwaW50ZXJwb2xhdGVkJTIwZW1iZWRkaW5ncy4lMEFpbWFnZXMlMjAlM0QlMjAlNUIlNUQlMEFmb3IlMjBsYXRlbnQlMjBpbiUyMHRxZG0od2Fsa2VkX2VtYmVkZGluZ3MpJTNBJTBBJTIwJTIwJTIwJTIwaW1hZ2VzLmFwcGVuZCglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwaXBlKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGhlaWdodCUzRGhlaWdodCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHdpZHRoJTNEd2lkdGglMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBudW1faW1hZ2VzX3Blcl9wcm9tcHQlM0QxJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJvbXB0X2VtYmVkcyUzRGxhdGVudCU1QjAlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBuZWdhdGl2ZV9wcm9tcHRfZW1iZWRzJTNEbGF0ZW50JTVCMSU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0RudW1faW5mZXJlbmNlX3N0ZXBzJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZ3VpZGFuY2Vfc2NhbGUlM0RndWlkYW5jZV9zY2FsZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGdlbmVyYXRvciUzRGdlbmVyYXRvciUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxhdGVudHMlM0RsYXRlbnRzJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKS5pbWFnZXMlMEElMjAlMjAlMjAlMjApJTBBJTBBJTIzJTIwRGlzcGxheSUyMG9mJTIwc2F2ZWQlMjBnZW5lcmF0ZWQlMjBpbWFnZXMuJTBBZGlzcGxheV9pbWFnZXMoaW1hZ2VzJTJDJTIwc2F2ZV9wYXRoKQ==",highlighted:`<span class="hljs-comment"># Generating images using the interpolated embeddings.</span>
images = []
<span class="hljs-keyword">for</span> latent <span class="hljs-keyword">in</span> tqdm(walked_embeddings):
    images.append(
        pipe(
            height=height,
            width=width,
            num_images_per_prompt=<span class="hljs-number">1</span>,
            prompt_embeds=latent[<span class="hljs-number">0</span>],
            negative_prompt_embeds=latent[<span class="hljs-number">1</span>],
            num_inference_steps=num_inference_steps,
            guidance_scale=guidance_scale,
            generator=generator,
            latents=latents,
        ).images
    )

<span class="hljs-comment"># Display of saved generated images.</span>
display_images(images, save_path)`,wrap:!1}}),le=new d({props:{title:"Example 2: Diffusion latents interpolation for a single prompt",local:"example-2-diffusion-latents-interpolation-for-a-single-prompt",headingTag:"h3"}}),Me=new U({props:{code:"ZGVmJTIwc2xlcnAodjAlMkMlMjB2MSUyQyUyMG51bSUyQyUyMHQwJTNEMCUyQyUyMHQxJTNEMSklM0ElMEElMjAlMjAlMjAlMjB2MCUyMCUzRCUyMHYwLmRldGFjaCgpLmNwdSgpLm51bXB5KCklMEElMjAlMjAlMjAlMjB2MSUyMCUzRCUyMHYxLmRldGFjaCgpLmNwdSgpLm51bXB5KCklMEElMEElMjAlMjAlMjAlMjBkZWYlMjBpbnRlcnBvbGF0aW9uKHQlMkMlMjB2MCUyQyUyMHYxJTJDJTIwRE9UX1RIUkVTSE9MRCUzRDAuOTk5NSklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjIlMjIlMjJoZWxwZXIlMjBmdW5jdGlvbiUyMHRvJTIwc3BoZXJpY2FsbHklMjBpbnRlcnBvbGF0ZSUyMHR3byUyMGFycmF5cyUyMHYxJTIwdjIlMjIlMjIlMjIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBkb3QlMjAlM0QlMjBucC5zdW0odjAlMjAqJTIwdjElMjAlMkYlMjAobnAubGluYWxnLm5vcm0odjApJTIwKiUyMG5wLmxpbmFsZy5ub3JtKHYxKSkpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjBucC5hYnMoZG90KSUyMCUzRSUyMERPVF9USFJFU0hPTEQlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB2MiUyMCUzRCUyMCgxJTIwLSUyMHQpJTIwKiUyMHYwJTIwJTJCJTIwdCUyMColMjB2MSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGVsc2UlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB0aGV0YV8wJTIwJTNEJTIwbnAuYXJjY29zKGRvdCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzaW5fdGhldGFfMCUyMCUzRCUyMG5wLnNpbih0aGV0YV8wKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRoZXRhX3QlMjAlM0QlMjB0aGV0YV8wJTIwKiUyMHQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzaW5fdGhldGFfdCUyMCUzRCUyMG5wLnNpbih0aGV0YV90KSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHMwJTIwJTNEJTIwbnAuc2luKHRoZXRhXzAlMjAtJTIwdGhldGFfdCklMjAlMkYlMjBzaW5fdGhldGFfMCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHMxJTIwJTNEJTIwc2luX3RoZXRhX3QlMjAlMkYlMjBzaW5fdGhldGFfMCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHYyJTIwJTNEJTIwczAlMjAqJTIwdjAlMjAlMkIlMjBzMSUyMColMjB2MSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMHYyJTBBJTBBJTIwJTIwJTIwJTIwdCUyMCUzRCUyMG5wLmxpbnNwYWNlKHQwJTJDJTIwdDElMkMlMjBudW0pJTBBJTBBJTIwJTIwJTIwJTIwdjMlMjAlM0QlMjB0b3JjaC50ZW5zb3IobnAuYXJyYXkoJTVCaW50ZXJwb2xhdGlvbih0JTVCaSU1RCUyQyUyMHYwJTJDJTIwdjEpJTIwZm9yJTIwaSUyMGluJTIwcmFuZ2UobnVtKSU1RCkpJTBBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwdjM=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">slerp</span>(<span class="hljs-params">v0, v1, num, t0=<span class="hljs-number">0</span>, t1=<span class="hljs-number">1</span></span>):
    v0 = v0.detach().cpu().numpy()
    v1 = v1.detach().cpu().numpy()

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">interpolation</span>(<span class="hljs-params">t, v0, v1, DOT_THRESHOLD=<span class="hljs-number">0.9995</span></span>):
        <span class="hljs-string">&quot;&quot;&quot;helper function to spherically interpolate two arrays v1 v2&quot;&quot;&quot;</span>
        dot = np.<span class="hljs-built_in">sum</span>(v0 * v1 / (np.linalg.norm(v0) * np.linalg.norm(v1)))
        <span class="hljs-keyword">if</span> np.<span class="hljs-built_in">abs</span>(dot) &gt; DOT_THRESHOLD:
            v2 = (<span class="hljs-number">1</span> - t) * v0 + t * v1
        <span class="hljs-keyword">else</span>:
            theta_0 = np.arccos(dot)
            sin_theta_0 = np.sin(theta_0)
            theta_t = theta_0 * t
            sin_theta_t = np.sin(theta_t)
            s0 = np.sin(theta_0 - theta_t) / sin_theta_0
            s1 = sin_theta_t / sin_theta_0
            v2 = s0 * v0 + s1 * v1
        <span class="hljs-keyword">return</span> v2

    t = np.linspace(t0, t1, num)

    v3 = torch.tensor(np.array([interpolation(t[i], v0, v1) <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(num)]))

    <span class="hljs-keyword">return</span> v3`,wrap:!1}}),ie=new U({props:{code:"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",highlighted:`<span class="hljs-comment"># The text prompt that describes the desired output image.</span>
prompt = (
    <span class="hljs-string">&quot;Sci-fi digital painting of an alien landscape with otherworldly plants, strange creatures, and distant planets.&quot;</span>
)
<span class="hljs-comment"># A negative prompt that can be used to steer the generation away from certain features.</span>
negative_prompt = <span class="hljs-string">&quot;poorly drawn,cartoon, 3d, disfigured, bad art, deformed, poorly drawn, extra limbs, close up, b&amp;w, weird colors, blurry&quot;</span>

<span class="hljs-comment"># Generating initial latent vectors from a random normal distribution. In this example two latent vectors are generated, which will serve as start and end points for the interpolation.</span>
<span class="hljs-comment"># These vectors are shaped to fit the input requirements of the diffusion model&#x27;s U-Net architecture.</span>
latents = torch.randn(
    (<span class="hljs-number">2</span>, pipe.unet.config.in_channels, height // <span class="hljs-number">8</span>, width // <span class="hljs-number">8</span>),
    generator=generator,
)

<span class="hljs-comment"># Getting our latent embeddings</span>
interpolated_latents = slerp(latents[<span class="hljs-number">0</span>], latents[<span class="hljs-number">1</span>], num_interpolation_steps)

<span class="hljs-comment"># Generating images using the interpolated embeddings.</span>
images = []
<span class="hljs-keyword">for</span> latent_vector <span class="hljs-keyword">in</span> tqdm(interpolated_latents):
    images.append(
        pipe(
            prompt,
            height=height,
            width=width,
            negative_prompt=negative_prompt,
            num_images_per_prompt=<span class="hljs-number">1</span>,
            num_inference_steps=num_inference_steps,
            guidance_scale=guidance_scale,
            generator=generator,
            latents=latent_vector[<span class="hljs-literal">None</span>, ...],
        ).images
    )

<span class="hljs-comment"># Display of saved generated images.</span>
display_images(images, save_path)`,wrap:!1}}),pe=new d({props:{title:"Example 3: Interpolation between multiple prompts",local:"example-3-interpolation-between-multiple-prompts",headingTag:"h3"}}),Je=new U({props:{code:"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",highlighted:`<span class="hljs-comment"># Text prompts that describes the desired output image.</span>
prompts = [
    <span class="hljs-string">&quot;A cute dog in a beautiful field of lavander colorful flowers everywhere, perfect lighting, leica summicron 35mm f2.0, kodak portra 400, film grain&quot;</span>,
    <span class="hljs-string">&quot;A cute cat in a beautiful field of lavander colorful flowers everywhere, perfect lighting, leica summicron 35mm f2.0, kodak portra 400, film grain&quot;</span>,
]
<span class="hljs-comment"># Negative prompts that can be used to steer the generation away from certain features.</span>
negative_prompts = [
    <span class="hljs-string">&quot;poorly drawn,cartoon, 2d, sketch, cartoon, drawing, anime, disfigured, bad art, deformed, poorly drawn, extra limbs, close up, b&amp;w, weird colors, blurry&quot;</span>,
    <span class="hljs-string">&quot;poorly drawn,cartoon, 2d, sketch, cartoon, drawing, anime, disfigured, bad art, deformed, poorly drawn, extra limbs, close up, b&amp;w, weird colors, blurry&quot;</span>,
]

<span class="hljs-comment"># <span class="hljs-doctag">NOTE:</span> The number of prompts must match the number of negative prompts</span>

batch_size = <span class="hljs-built_in">len</span>(prompts)

<span class="hljs-comment"># Tokenizing and encoding prompts into embeddings.</span>
prompts_tokens = pipe.tokenizer(
    prompts,
    padding=<span class="hljs-string">&quot;max_length&quot;</span>,
    max_length=pipe.tokenizer.model_max_length,
    truncation=<span class="hljs-literal">True</span>,
    return_tensors=<span class="hljs-string">&quot;pt&quot;</span>,
)
prompts_embeds = pipe.text_encoder(prompts_tokens.input_ids.to(device))[<span class="hljs-number">0</span>]

<span class="hljs-comment"># Tokenizing and encoding negative prompts into embeddings.</span>
<span class="hljs-keyword">if</span> negative_prompts <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span>:
    negative_prompts = [<span class="hljs-string">&quot;&quot;</span>] * batch_size

negative_prompts_tokens = pipe.tokenizer(
    negative_prompts,
    padding=<span class="hljs-string">&quot;max_length&quot;</span>,
    max_length=pipe.tokenizer.model_max_length,
    truncation=<span class="hljs-literal">True</span>,
    return_tensors=<span class="hljs-string">&quot;pt&quot;</span>,
)
negative_prompts_embeds = pipe.text_encoder(negative_prompts_tokens.input_ids.to(device))[<span class="hljs-number">0</span>]`,wrap:!1}}),re=new U({props:{code:"JTIzJTIwR2VuZXJhdGluZyUyMGluaXRpYWwlMjBVLU5ldCUyMGxhdGVudCUyMHZlY3RvcnMlMjBmcm9tJTIwYSUyMHJhbmRvbSUyMG5vcm1hbCUyMGRpc3RyaWJ1dGlvbi4lMEFsYXRlbnRzJTIwJTNEJTIwdG9yY2gucmFuZG4oJTBBJTIwJTIwJTIwJTIwKDElMkMlMjBwaXBlLnVuZXQuY29uZmlnLmluX2NoYW5uZWxzJTJDJTIwaGVpZ2h0JTIwJTJGJTJGJTIwOCUyQyUyMHdpZHRoJTIwJTJGJTJGJTIwOCklMkMlMEElMjAlMjAlMjAlMjBnZW5lcmF0b3IlM0RnZW5lcmF0b3IlMkMlMEEpJTBBJTBBJTIzJTIwSW50ZXJwb2xhdGluZyUyMGJldHdlZW4lMjBlbWJlZGRpbmdzJTIwcGFpcnMlMjBmb3IlMjB0aGUlMjBnaXZlbiUyMG51bWJlciUyMG9mJTIwaW50ZXJwb2xhdGlvbiUyMHN0ZXBzLiUwQWludGVycG9sYXRlZF9wcm9tcHRfZW1iZWRzJTIwJTNEJTIwJTVCJTVEJTBBaW50ZXJwb2xhdGVkX25lZ2F0aXZlX3Byb21wdHNfZW1iZWRzJTIwJTNEJTIwJTVCJTVEJTBBZm9yJTIwaSUyMGluJTIwcmFuZ2UoYmF0Y2hfc2l6ZSUyMC0lMjAxKSUzQSUwQSUyMCUyMCUyMCUyMGludGVycG9sYXRlZF9wcm9tcHRfZW1iZWRzLmFwcGVuZChzbGVycChwcm9tcHRzX2VtYmVkcyU1QmklNUQlMkMlMjBwcm9tcHRzX2VtYmVkcyU1QmklMjAlMkIlMjAxJTVEJTJDJTIwbnVtX2ludGVycG9sYXRpb25fc3RlcHMpKSUwQSUyMCUyMCUyMCUyMGludGVycG9sYXRlZF9uZWdhdGl2ZV9wcm9tcHRzX2VtYmVkcy5hcHBlbmQoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2xlcnAoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbmVnYXRpdmVfcHJvbXB0c19lbWJlZHMlNUJpJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbmVnYXRpdmVfcHJvbXB0c19lbWJlZHMlNUJpJTIwJTJCJTIwMSU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG51bV9pbnRlcnBvbGF0aW9uX3N0ZXBzJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUwQSUyMCUyMCUyMCUyMCklMEElMEFpbnRlcnBvbGF0ZWRfcHJvbXB0X2VtYmVkcyUyMCUzRCUyMHRvcmNoLmNhdChpbnRlcnBvbGF0ZWRfcHJvbXB0X2VtYmVkcyUyQyUyMGRpbSUzRDApLnRvKGRldmljZSklMEElMEFpbnRlcnBvbGF0ZWRfbmVnYXRpdmVfcHJvbXB0c19lbWJlZHMlMjAlM0QlMjB0b3JjaC5jYXQoaW50ZXJwb2xhdGVkX25lZ2F0aXZlX3Byb21wdHNfZW1iZWRzJTJDJTIwZGltJTNEMCkudG8oZGV2aWNlKQ==",highlighted:`<span class="hljs-comment"># Generating initial U-Net latent vectors from a random normal distribution.</span>
latents = torch.randn(
    (<span class="hljs-number">1</span>, pipe.unet.config.in_channels, height // <span class="hljs-number">8</span>, width // <span class="hljs-number">8</span>),
    generator=generator,
)

<span class="hljs-comment"># Interpolating between embeddings pairs for the given number of interpolation steps.</span>
interpolated_prompt_embeds = []
interpolated_negative_prompts_embeds = []
<span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(batch_size - <span class="hljs-number">1</span>):
    interpolated_prompt_embeds.append(slerp(prompts_embeds[i], prompts_embeds[i + <span class="hljs-number">1</span>], num_interpolation_steps))
    interpolated_negative_prompts_embeds.append(
        slerp(
            negative_prompts_embeds[i],
            negative_prompts_embeds[i + <span class="hljs-number">1</span>],
            num_interpolation_steps,
        )
    )

interpolated_prompt_embeds = torch.cat(interpolated_prompt_embeds, dim=<span class="hljs-number">0</span>).to(device)

interpolated_negative_prompts_embeds = torch.cat(interpolated_negative_prompts_embeds, dim=<span class="hljs-number">0</span>).to(device)`,wrap:!1}}),ce=new U({props:{code:"JTIzJTIwR2VuZXJhdGluZyUyMGltYWdlcyUyMHVzaW5nJTIwdGhlJTIwaW50ZXJwb2xhdGVkJTIwZW1iZWRkaW5ncy4lMEFpbWFnZXMlMjAlM0QlMjAlNUIlNUQlMEFmb3IlMjBwcm9tcHRfZW1iZWRzJTJDJTIwbmVnYXRpdmVfcHJvbXB0X2VtYmVkcyUyMGluJTIwdHFkbSglMEElMjAlMjAlMjAlMjB6aXAoaW50ZXJwb2xhdGVkX3Byb21wdF9lbWJlZHMlMkMlMjBpbnRlcnBvbGF0ZWRfbmVnYXRpdmVfcHJvbXB0c19lbWJlZHMpJTJDJTBBJTIwJTIwJTIwJTIwdG90YWwlM0RsZW4oaW50ZXJwb2xhdGVkX3Byb21wdF9lbWJlZHMpJTJDJTBBKSUzQSUwQSUyMCUyMCUyMCUyMGltYWdlcy5hcHBlbmQoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcGlwZSglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBoZWlnaHQlM0RoZWlnaHQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB3aWR0aCUzRHdpZHRoJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbnVtX2ltYWdlc19wZXJfcHJvbXB0JTNEMSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHByb21wdF9lbWJlZHMlM0Rwcm9tcHRfZW1iZWRzJTVCTm9uZSUyQyUyMC4uLiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG5lZ2F0aXZlX3Byb21wdF9lbWJlZHMlM0RuZWdhdGl2ZV9wcm9tcHRfZW1iZWRzJTVCTm9uZSUyQyUyMC4uLiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0RudW1faW5mZXJlbmNlX3N0ZXBzJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZ3VpZGFuY2Vfc2NhbGUlM0RndWlkYW5jZV9zY2FsZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGdlbmVyYXRvciUzRGdlbmVyYXRvciUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxhdGVudHMlM0RsYXRlbnRzJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKS5pbWFnZXMlMEElMjAlMjAlMjAlMjApJTBBJTBBJTIzJTIwRGlzcGxheSUyMG9mJTIwc2F2ZWQlMjBnZW5lcmF0ZWQlMjBpbWFnZXMuJTBBZGlzcGxheV9pbWFnZXMoaW1hZ2VzJTJDJTIwc2F2ZV9wYXRoKQ==",highlighted:`<span class="hljs-comment"># Generating images using the interpolated embeddings.</span>
images = []
<span class="hljs-keyword">for</span> prompt_embeds, negative_prompt_embeds <span class="hljs-keyword">in</span> tqdm(
    <span class="hljs-built_in">zip</span>(interpolated_prompt_embeds, interpolated_negative_prompts_embeds),
    total=<span class="hljs-built_in">len</span>(interpolated_prompt_embeds),
):
    images.append(
        pipe(
            height=height,
            width=width,
            num_images_per_prompt=<span class="hljs-number">1</span>,
            prompt_embeds=prompt_embeds[<span class="hljs-literal">None</span>, ...],
            negative_prompt_embeds=negative_prompt_embeds[<span class="hljs-literal">None</span>, ...],
            num_inference_steps=num_inference_steps,
            guidance_scale=guidance_scale,
            generator=generator,
            latents=latents,
        ).images
    )

<span class="hljs-comment"># Display of saved generated images.</span>
display_images(images, save_path)`,wrap:!1}}),de=new d({props:{title:"Example 4: Circular walk through the diffusion latent space for a single prompt",local:"example-4-circular-walk-through-the-diffusion-latent-space-for-a-single-prompt",headingTag:"h3"}}),be=new U({props:{code:"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",highlighted:`<span class="hljs-comment"># The text prompt that describes the desired output image.</span>
prompt = <span class="hljs-string">&quot;Beautiful sea sunset, warm light, Aivazovsky style&quot;</span>
<span class="hljs-comment"># A negative prompt that can be used to steer the generation away from certain features</span>
negative_prompt = <span class="hljs-string">&quot;picture frames&quot;</span>

<span class="hljs-comment"># Generating initial latent vectors from a random normal distribution to create a loop interpolation between them.</span>
latents = torch.randn(
    (<span class="hljs-number">2</span>, <span class="hljs-number">1</span>, pipe.unet.config.in_channels, height // <span class="hljs-number">8</span>, width // <span class="hljs-number">8</span>),
    generator=generator,
)


<span class="hljs-comment"># Calculation of looped embeddings</span>
walk_noise_x = latents[<span class="hljs-number">0</span>].to(device)
walk_noise_y = latents[<span class="hljs-number">1</span>].to(device)

<span class="hljs-comment"># Walking on a trigonometric circle</span>
walk_scale_x = torch.cos(torch.linspace(<span class="hljs-number">0</span>, <span class="hljs-number">2</span>, num_interpolation_steps) * np.pi).to(device)
walk_scale_y = torch.sin(torch.linspace(<span class="hljs-number">0</span>, <span class="hljs-number">2</span>, num_interpolation_steps) * np.pi).to(device)

<span class="hljs-comment"># Applying interpolation to noise</span>
noise_x = torch.tensordot(walk_scale_x, walk_noise_x, dims=<span class="hljs-number">0</span>)
noise_y = torch.tensordot(walk_scale_y, walk_noise_y, dims=<span class="hljs-number">0</span>)

circular_latents = noise_x + noise_y

<span class="hljs-comment"># Generating images using the interpolated embeddings.</span>
images = []
<span class="hljs-keyword">for</span> latent_vector <span class="hljs-keyword">in</span> tqdm(circular_latents):
    images.append(
        pipe(
            prompt,
            height=height,
            width=width,
            negative_prompt=negative_prompt,
            num_images_per_prompt=<span class="hljs-number">1</span>,
            num_inference_steps=num_inference_steps,
            guidance_scale=guidance_scale,
            generator=generator,
            latents=latent_vector,
        ).images
    )

<span class="hljs-comment"># Display of saved generated images.</span>
display_images(images, save_path)`,wrap:!1}}),ue=new d({props:{title:"Next Steps",local:"next-steps",headingTag:"h2"}}),Ze=new ft({props:{source:"https://github.com/huggingface/cookbook/blob/main/notebooks/en/stable_diffusion_interpolation.md"}}),{c(){c=M("meta"),Be=a(),Ce=M("p"),fe=a(),o(T.$$.fragment),ge=a(),o(h.$$.fragment),We=a(),j=M("p"),j.innerHTML=_l,ve=a(),b=M("p"),b.textContent=El,Xe=a(),u=M("p"),u.textContent=Hl,Ve=a(),I=M("ul"),I.innerHTML=Sl,ke=a(),Z=M("p"),Z.textContent=Ql,Re=a(),C=M("p"),C.textContent=xl,Ae=a(),G=M("p"),G.textContent=zl,Ye=a(),B=M("p"),B.textContent=Nl,_e=a(),o(f.$$.fragment),Ee=a(),g=M("p"),g.textContent=Fl,He=a(),o(W.$$.fragment),Se=a(),v=M("p"),v.textContent=$l,Qe=a(),o(X.$$.fragment),xe=a(),V=M("p"),V.innerHTML=Dl,ze=a(),o(k.$$.fragment),Ne=a(),o(R.$$.fragment),Fe=a(),A=M("p"),A.innerHTML=Ll,$e=a(),o(Y.$$.fragment),De=a(),_=M("p"),_.textContent=ql,Le=a(),E=M("p"),E.innerHTML=Kl,qe=a(),o(H.$$.fragment),Ke=a(),S=M("p"),S.innerHTML=Pl,Pe=a(),o(Q.$$.fragment),Oe=a(),o(x.$$.fragment),el=a(),z=M("ul"),z.innerHTML=Ol,ll=a(),o(N.$$.fragment),tl=a(),o(F.$$.fragment),sl=a(),$=M("p"),$.textContent=et,al=a(),D=M("p"),D.innerHTML=lt,nl=a(),L=M("p"),L.textContent=tt,Ml=a(),o(q.$$.fragment),il=a(),K=M("p"),K.textContent=st,pl=a(),o(P.$$.fragment),ol=a(),O=M("p"),O.innerHTML=at,yl=a(),o(ee.$$.fragment),ml=a(),o(le.$$.fragment),Jl=a(),te=M("p"),te.textContent=nt,wl=a(),se=M("p"),se.innerHTML=Mt,rl=a(),ae=M("p"),ae.textContent=it,Ul=a(),ne=M("p"),ne.innerHTML=pt,cl=a(),o(Me.$$.fragment),dl=a(),o(ie.$$.fragment),Tl=a(),o(pe.$$.fragment),hl=a(),oe=M("p"),oe.textContent=ot,jl=a(),ye=M("p"),ye.innerHTML=yt,bl=a(),me=M("p"),me.textContent=mt,ul=a(),o(Je.$$.fragment),Il=a(),we=M("p"),we.innerHTML=Jt,Zl=a(),o(re.$$.fragment),Cl=a(),Ue=M("p"),Ue.textContent=wt,Gl=a(),o(ce.$$.fragment),Bl=a(),o(de.$$.fragment),fl=a(),Te=M("p"),Te.innerHTML=rt,gl=a(),he=M("p"),he.textContent=Ut,Wl=a(),je=M("p"),je.innerHTML=ct,vl=a(),o(be.$$.fragment),Xl=a(),o(ue.$$.fragment),Vl=a(),Ie=M("p"),Ie.innerHTML=dt,kl=a(),o(Ze.$$.fragment),Rl=a(),Ge=M("p"),this.h()},l(e){const l=Ct("svelte-u9bgzb",document.head);c=i(l,"META",{name:!0,content:!0}),l.forEach(t),Be=n(e),Ce=i(e,"P",{}),Tt(Ce).forEach(t),fe=n(e),y(T.$$.fragment,e),ge=n(e),y(h.$$.fragment,e),We=n(e),j=i(e,"P",{"data-svelte-h":!0}),p(j)!=="svelte-xo5wq0"&&(j.innerHTML=_l),ve=n(e),b=i(e,"P",{"data-svelte-h":!0}),p(b)!=="svelte-13o2aov"&&(b.textContent=El),Xe=n(e),u=i(e,"P",{"data-svelte-h":!0}),p(u)!=="svelte-ubo7tx"&&(u.textContent=Hl),Ve=n(e),I=i(e,"UL",{"data-svelte-h":!0}),p(I)!=="svelte-he0og3"&&(I.innerHTML=Sl),ke=n(e),Z=i(e,"P",{"data-svelte-h":!0}),p(Z)!=="svelte-1pybxoa"&&(Z.textContent=Ql),Re=n(e),C=i(e,"P",{"data-svelte-h":!0}),p(C)!=="svelte-axm9ar"&&(C.textContent=xl),Ae=n(e),G=i(e,"P",{"data-svelte-h":!0}),p(G)!=="svelte-16porze"&&(G.textContent=zl),Ye=n(e),B=i(e,"P",{"data-svelte-h":!0}),p(B)!=="svelte-13zokni"&&(B.textContent=Nl),_e=n(e),y(f.$$.fragment,e),Ee=n(e),g=i(e,"P",{"data-svelte-h":!0}),p(g)!=="svelte-1tw65d0"&&(g.textContent=Fl),He=n(e),y(W.$$.fragment,e),Se=n(e),v=i(e,"P",{"data-svelte-h":!0}),p(v)!=="svelte-1hwxkpg"&&(v.textContent=$l),Qe=n(e),y(X.$$.fragment,e),xe=n(e),V=i(e,"P",{"data-svelte-h":!0}),p(V)!=="svelte-157lcra"&&(V.innerHTML=Dl),ze=n(e),y(k.$$.fragment,e),Ne=n(e),y(R.$$.fragment,e),Fe=n(e),A=i(e,"P",{"data-svelte-h":!0}),p(A)!=="svelte-1xuhc40"&&(A.innerHTML=Ll),$e=n(e),y(Y.$$.fragment,e),De=n(e),_=i(e,"P",{"data-svelte-h":!0}),p(_)!=="svelte-ule0bd"&&(_.textContent=ql),Le=n(e),E=i(e,"P",{"data-svelte-h":!0}),p(E)!=="svelte-1cnpf90"&&(E.innerHTML=Kl),qe=n(e),y(H.$$.fragment,e),Ke=n(e),S=i(e,"P",{"data-svelte-h":!0}),p(S)!=="svelte-1x293fi"&&(S.innerHTML=Pl),Pe=n(e),y(Q.$$.fragment,e),Oe=n(e),y(x.$$.fragment,e),el=n(e),z=i(e,"UL",{"data-svelte-h":!0}),p(z)!=="svelte-avta92"&&(z.innerHTML=Ol),ll=n(e),y(N.$$.fragment,e),tl=n(e),y(F.$$.fragment,e),sl=n(e),$=i(e,"P",{"data-svelte-h":!0}),p($)!=="svelte-t1vj9q"&&($.textContent=et),al=n(e),D=i(e,"P",{"data-svelte-h":!0}),p(D)!=="svelte-1x05mg4"&&(D.innerHTML=lt),nl=n(e),L=i(e,"P",{"data-svelte-h":!0}),p(L)!=="svelte-19kzzzg"&&(L.textContent=tt),Ml=n(e),y(q.$$.fragment,e),il=n(e),K=i(e,"P",{"data-svelte-h":!0}),p(K)!=="svelte-szx5hm"&&(K.textContent=st),pl=n(e),y(P.$$.fragment,e),ol=n(e),O=i(e,"P",{"data-svelte-h":!0}),p(O)!=="svelte-1oqz59z"&&(O.innerHTML=at),yl=n(e),y(ee.$$.fragment,e),ml=n(e),y(le.$$.fragment,e),Jl=n(e),te=i(e,"P",{"data-svelte-h":!0}),p(te)!=="svelte-1y6nb0t"&&(te.textContent=nt),wl=n(e),se=i(e,"P",{"data-svelte-h":!0}),p(se)!=="svelte-zqtywg"&&(se.innerHTML=Mt),rl=n(e),ae=i(e,"P",{"data-svelte-h":!0}),p(ae)!=="svelte-1it4256"&&(ae.textContent=it),Ul=n(e),ne=i(e,"P",{"data-svelte-h":!0}),p(ne)!=="svelte-1winyti"&&(ne.innerHTML=pt),cl=n(e),y(Me.$$.fragment,e),dl=n(e),y(ie.$$.fragment,e),Tl=n(e),y(pe.$$.fragment,e),hl=n(e),oe=i(e,"P",{"data-svelte-h":!0}),p(oe)!=="svelte-15a2nb7"&&(oe.textContent=ot),jl=n(e),ye=i(e,"P",{"data-svelte-h":!0}),p(ye)!=="svelte-1uv5js0"&&(ye.innerHTML=yt),bl=n(e),me=i(e,"P",{"data-svelte-h":!0}),p(me)!=="svelte-u335b5"&&(me.textContent=mt),ul=n(e),y(Je.$$.fragment,e),Il=n(e),we=i(e,"P",{"data-svelte-h":!0}),p(we)!=="svelte-1rpvl23"&&(we.innerHTML=Jt),Zl=n(e),y(re.$$.fragment,e),Cl=n(e),Ue=i(e,"P",{"data-svelte-h":!0}),p(Ue)!=="svelte-1sxcfxg"&&(Ue.textContent=wt),Gl=n(e),y(ce.$$.fragment,e),Bl=n(e),y(de.$$.fragment,e),fl=n(e),Te=i(e,"P",{"data-svelte-h":!0}),p(Te)!=="svelte-pjhh7v"&&(Te.innerHTML=rt),gl=n(e),he=i(e,"P",{"data-svelte-h":!0}),p(he)!=="svelte-1v4hr5x"&&(he.textContent=Ut),Wl=n(e),je=i(e,"P",{"data-svelte-h":!0}),p(je)!=="svelte-1h51p8s"&&(je.innerHTML=ct),vl=n(e),y(be.$$.fragment,e),Xl=n(e),y(ue.$$.fragment,e),Vl=n(e),Ie=i(e,"P",{"data-svelte-h":!0}),p(Ie)!=="svelte-a25mhu"&&(Ie.innerHTML=dt),kl=n(e),y(Ze.$$.fragment,e),Rl=n(e),Ge=i(e,"P",{}),Tt(Ge).forEach(t),this.h()},h(){ht(c,"name","hf:doc:metadata"),ht(c,"content",Wt)},m(e,l){Gt(document.head,c),s(e,Be,l),s(e,Ce,l),s(e,fe,l),m(T,e,l),s(e,ge,l),m(h,e,l),s(e,We,l),s(e,j,l),s(e,ve,l),s(e,b,l),s(e,Xe,l),s(e,u,l),s(e,Ve,l),s(e,I,l),s(e,ke,l),s(e,Z,l),s(e,Re,l),s(e,C,l),s(e,Ae,l),s(e,G,l),s(e,Ye,l),s(e,B,l),s(e,_e,l),m(f,e,l),s(e,Ee,l),s(e,g,l),s(e,He,l),m(W,e,l),s(e,Se,l),s(e,v,l),s(e,Qe,l),m(X,e,l),s(e,xe,l),s(e,V,l),s(e,ze,l),m(k,e,l),s(e,Ne,l),m(R,e,l),s(e,Fe,l),s(e,A,l),s(e,$e,l),m(Y,e,l),s(e,De,l),s(e,_,l),s(e,Le,l),s(e,E,l),s(e,qe,l),m(H,e,l),s(e,Ke,l),s(e,S,l),s(e,Pe,l),m(Q,e,l),s(e,Oe,l),m(x,e,l),s(e,el,l),s(e,z,l),s(e,ll,l),m(N,e,l),s(e,tl,l),m(F,e,l),s(e,sl,l),s(e,$,l),s(e,al,l),s(e,D,l),s(e,nl,l),s(e,L,l),s(e,Ml,l),m(q,e,l),s(e,il,l),s(e,K,l),s(e,pl,l),m(P,e,l),s(e,ol,l),s(e,O,l),s(e,yl,l),m(ee,e,l),s(e,ml,l),m(le,e,l),s(e,Jl,l),s(e,te,l),s(e,wl,l),s(e,se,l),s(e,rl,l),s(e,ae,l),s(e,Ul,l),s(e,ne,l),s(e,cl,l),m(Me,e,l),s(e,dl,l),m(ie,e,l),s(e,Tl,l),m(pe,e,l),s(e,hl,l),s(e,oe,l),s(e,jl,l),s(e,ye,l),s(e,bl,l),s(e,me,l),s(e,ul,l),m(Je,e,l),s(e,Il,l),s(e,we,l),s(e,Zl,l),m(re,e,l),s(e,Cl,l),s(e,Ue,l),s(e,Gl,l),m(ce,e,l),s(e,Bl,l),m(de,e,l),s(e,fl,l),s(e,Te,l),s(e,gl,l),s(e,he,l),s(e,Wl,l),s(e,je,l),s(e,vl,l),m(be,e,l),s(e,Xl,l),m(ue,e,l),s(e,Vl,l),s(e,Ie,l),s(e,kl,l),m(Ze,e,l),s(e,Rl,l),s(e,Ge,l),Al=!0},p:bt,i(e){Al||(J(T.$$.fragment,e),J(h.$$.fragment,e),J(f.$$.fragment,e),J(W.$$.fragment,e),J(X.$$.fragment,e),J(k.$$.fragment,e),J(R.$$.fragment,e),J(Y.$$.fragment,e),J(H.$$.fragment,e),J(Q.$$.fragment,e),J(x.$$.fragment,e),J(N.$$.fragment,e),J(F.$$.fragment,e),J(q.$$.fragment,e),J(P.$$.fragment,e),J(ee.$$.fragment,e),J(le.$$.fragment,e),J(Me.$$.fragment,e),J(ie.$$.fragment,e),J(pe.$$.fragment,e),J(Je.$$.fragment,e),J(re.$$.fragment,e),J(ce.$$.fragment,e),J(de.$$.fragment,e),J(be.$$.fragment,e),J(ue.$$.fragment,e),J(Ze.$$.fragment,e),Al=!0)},o(e){w(T.$$.fragment,e),w(h.$$.fragment,e),w(f.$$.fragment,e),w(W.$$.fragment,e),w(X.$$.fragment,e),w(k.$$.fragment,e),w(R.$$.fragment,e),w(Y.$$.fragment,e),w(H.$$.fragment,e),w(Q.$$.fragment,e),w(x.$$.fragment,e),w(N.$$.fragment,e),w(F.$$.fragment,e),w(q.$$.fragment,e),w(P.$$.fragment,e),w(ee.$$.fragment,e),w(le.$$.fragment,e),w(Me.$$.fragment,e),w(ie.$$.fragment,e),w(pe.$$.fragment,e),w(Je.$$.fragment,e),w(re.$$.fragment,e),w(ce.$$.fragment,e),w(de.$$.fragment,e),w(be.$$.fragment,e),w(ue.$$.fragment,e),w(Ze.$$.fragment,e),Al=!1},d(e){e&&(t(Be),t(Ce),t(fe),t(ge),t(We),t(j),t(ve),t(b),t(Xe),t(u),t(Ve),t(I),t(ke),t(Z),t(Re),t(C),t(Ae),t(G),t(Ye),t(B),t(_e),t(Ee),t(g),t(He),t(Se),t(v),t(Qe),t(xe),t(V),t(ze),t(Ne),t(Fe),t(A),t($e),t(De),t(_),t(Le),t(E),t(qe),t(Ke),t(S),t(Pe),t(Oe),t(el),t(z),t(ll),t(tl),t(sl),t($),t(al),t(D),t(nl),t(L),t(Ml),t(il),t(K),t(pl),t(ol),t(O),t(yl),t(ml),t(Jl),t(te),t(wl),t(se),t(rl),t(ae),t(Ul),t(ne),t(cl),t(dl),t(Tl),t(hl),t(oe),t(jl),t(ye),t(bl),t(me),t(ul),t(Il),t(we),t(Zl),t(Cl),t(Ue),t(Gl),t(Bl),t(fl),t(Te),t(gl),t(he),t(Wl),t(je),t(vl),t(Xl),t(Vl),t(Ie),t(kl),t(Rl),t(Ge)),t(c),r(T,e),r(h,e),r(f,e),r(W,e),r(X,e),r(k,e),r(R,e),r(Y,e),r(H,e),r(Q,e),r(x,e),r(N,e),r(F,e),r(q,e),r(P,e),r(ee,e),r(le,e),r(Me,e),r(ie,e),r(pe,e),r(Je,e),r(re,e),r(ce,e),r(de,e),r(be,e),r(ue,e),r(Ze,e)}}}const Wt='{"title":"Images Interpolation with Stable Diffusion","local":"images-interpolation-with-stable-diffusion","sections":[{"title":"Model","local":"model","sections":[],"depth":3},{"title":"Generation parameters","local":"generation-parameters","sections":[],"depth":3},{"title":"Example 1: Prompt interpolation","local":"example-1-prompt-interpolation","sections":[],"depth":3},{"title":"Example 2: Diffusion latents interpolation for a single prompt","local":"example-2-diffusion-latents-interpolation-for-a-single-prompt","sections":[],"depth":3},{"title":"Example 3: Interpolation between multiple prompts","local":"example-3-interpolation-between-multiple-prompts","sections":[],"depth":3},{"title":"Example 4: Circular walk through the diffusion latent space for a single prompt","local":"example-4-circular-walk-through-the-diffusion-latent-space-for-a-single-prompt","sections":[],"depth":3}],"depth":2}';function vt(Yl){return ut(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class At extends It{constructor(c){super(),Zt(this,c,vt,gt,jt,{})}}export{At as component};
