import{s as jt,o as It,n as Fe}from"../chunks/scheduler.8c3d61f6.js";import{S as Ut,i as Ct,g as r,s as o,r as h,A as Gt,h as l,f as n,c as a,j as ue,u as f,x as d,k as ge,y as T,a as i,v as u,d as g,t as _,w as x}from"../chunks/index.da70eac4.js";import{T as it}from"../chunks/Tip.1d9b8c37.js";import{D as ot}from"../chunks/Docstring.6b390b9a.js";import{C as pe}from"../chunks/CodeBlock.00a903b3.js";import{E as kt}from"../chunks/ExampleCodeBlock.db12be95.js";import{H as at,E as Bt}from"../chunks/EditOnGithub.1e64e623.js";function Zt(A){let s,b='Make sure to check out the Schedulers <a href="../../using-diffusers/schedulers.md">guide</a> to learn how to explore the tradeoff between scheduler speed and quality, and see the <a href="../../using-diffusers/loading.md#reuse-a-pipeline">reuse components across pipelines</a> section to learn how to efficiently load the same components into multiple pipelines.';return{c(){s=r("p"),s.innerHTML=b},l(p){s=l(p,"P",{"data-svelte-h":!0}),d(s)!=="svelte-w7r39y"&&(s.innerHTML=b)},m(p,m){i(p,s,m)},p:Fe,d(p){p&&n(s)}}}function Lt(A){let s,b="Notice that while initializing <code>pipe</code>, you’re setting <code>text_encoder</code> to <code>None</code> so that it’s not loaded.";return{c(){s=r("p"),s.innerHTML=b},l(p){s=l(p,"P",{"data-svelte-h":!0}),d(s)!=="svelte-1of5pjk"&&(s.innerHTML=b)},m(p,m){i(p,s,m)},p:Fe,d(p){p&&n(s)}}}function Xt(A){let s,b="Text embeddings computed in 8-bit can impact the quality of the generated images because of the information loss in the representation space caused by the reduced precision. It’s recommended to compare the outputs with and without 8-bit.";return{c(){s=r("p"),s.textContent=b},l(p){s=l(p,"P",{"data-svelte-h":!0}),d(s)!=="svelte-1rutysd"&&(s.textContent=b)},m(p,m){i(p,s,m)},p:Fe,d(p){p&&n(s)}}}function Et(A){let s,b="Examples:",p,m,v;return m=new pe({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwUGl4QXJ0QWxwaGFQaXBlbGluZSUwQSUwQSUyMyUyMFlvdSUyMGNhbiUyMHJlcGxhY2UlMjB0aGUlMjBjaGVja3BvaW50JTIwaWQlMjB3aXRoJTIwJTIyUGl4QXJ0LWFscGhhJTJGUGl4QXJ0LVhMLTItNTEyeDUxMiUyMiUyMHRvby4lMEFwaXBlJTIwJTNEJTIwUGl4QXJ0QWxwaGFQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyUGl4QXJ0LWFscGhhJTJGUGl4QXJ0LVhMLTItMTAyNC1NUyUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiklMEElMjMlMjBFbmFibGUlMjBtZW1vcnklMjBvcHRpbWl6YXRpb25zLiUwQXBpcGUuZW5hYmxlX21vZGVsX2NwdV9vZmZsb2FkKCklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJBJTIwc21hbGwlMjBjYWN0dXMlMjB3aXRoJTIwYSUyMGhhcHB5JTIwZmFjZSUyMGluJTIwdGhlJTIwU2FoYXJhJTIwZGVzZXJ0LiUyMiUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQpLmltYWdlcyU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> PixArtAlphaPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># You can replace the checkpoint id with &quot;PixArt-alpha/PixArt-XL-2-512x512&quot; too.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = PixArtAlphaPipeline.from_pretrained(<span class="hljs-string">&quot;PixArt-alpha/PixArt-XL-2-1024-MS&quot;</span>, torch_dtype=torch.float16)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Enable memory optimizations.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.enable_model_cpu_offload()

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;A small cactus with a happy face in the Sahara desert.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(prompt).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){s=r("p"),s.textContent=b,p=o(),h(m.$$.fragment)},l(c){s=l(c,"P",{"data-svelte-h":!0}),d(s)!=="svelte-kvfsh7"&&(s.textContent=b),p=a(c),f(m.$$.fragment,c)},m(c,y){i(c,s,y),i(c,p,y),u(m,c,y),v=!0},p:Fe,i(c){v||(g(m.$$.fragment,c),v=!0)},o(c){_(m.$$.fragment,c),v=!1},d(c){c&&(n(s),n(p)),x(m,c)}}}function Ht(A){let s,b,p,m,v,c,y,st='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/pixart/header_collage.png"/>',_e,G,rt='<a href="https://huggingface.co/papers/2310.00426" rel="nofollow">PixArt-α: Fast Training of Diffusion Transformer for Photorealistic Text-to-Image Synthesis</a> is Junsong Chen, Jincheng Yu, Chongjian Ge, Lewei Yao, Enze Xie, Yue Wu, Zhongdao Wang, James Kwok, Ping Luo, Huchuan Lu, and Zhenguo Li.',xe,k,lt="The abstract from the paper is:",be,B,pt="<em>The most advanced text-to-image (T2I) models require significant training costs (e.g., millions of GPU hours), seriously hindering the fundamental innovation for the AIGC community while increasing CO2 emissions. This paper introduces PIXART-α, a Transformer-based T2I diffusion model whose image generation quality is competitive with state-of-the-art image generators (e.g., Imagen, SDXL, and even Midjourney), reaching near-commercial application standards. Additionally, it supports high-resolution image synthesis up to 1024px resolution with low training cost, as shown in Figure 1 and 2. To achieve this goal, three core designs are proposed: (1) Training strategy decomposition: We devise three distinct training steps that separately optimize pixel dependency, text-image alignment, and image aesthetic quality; (2) Efficient T2I Transformer: We incorporate cross-attention modules into Diffusion Transformer (DiT) to inject text conditions and streamline the computation-intensive class-condition branch; (3) High-informative data: We emphasize the significance of concept density in text-image pairs and leverage a large Vision-Language model to auto-label dense pseudo-captions to assist text-image alignment learning. As a result, PIXART-α’s training speed markedly surpasses existing large-scale T2I models, e.g., PIXART-α only takes 10.8% of Stable Diffusion v1.5’s training time (675 vs. 6,250 A100 GPU days), saving nearly $300,000 ($26,000 vs. $320,000) and reducing 90% CO2 emissions. Moreover, compared with a larger SOTA model, RAPHAEL, our training cost is merely 1%. Extensive experiments demonstrate that PIXART-α excels in image quality, artistry, and semantic control. We hope PIXART-α will provide new insights to the AIGC community and startups to accelerate building their own high-quality yet low-cost generative models from scratch.</em>",we,Z,dt='You can find the original codebase at <a href="https://github.com/PixArt-alpha/PixArt-alpha" rel="nofollow">PixArt-alpha/PixArt-alpha</a> and all the available checkpoints at <a href="https://huggingface.co/PixArt-alpha" rel="nofollow">PixArt-alpha</a>.',Te,L,ct="Some notes about this pipeline:",Me,X,mt='<li>It uses a Transformer backbone (instead of a UNet) for denoising. As such it has a similar architecture as <a href="./dit">DiT</a>.</li> <li>It was trained using text conditions computed from T5. This aspect makes the pipeline better at following complex text prompts with intricate details.</li> <li>It is good at producing high-resolution images at different aspect ratios. To get the best results, the authors recommend some size brackets which can be found <a href="https://github.com/PixArt-alpha/PixArt-alpha/blob/08fbbd281ec96866109bdd2cdb75f2f58fb17610/diffusion/data/datasets/utils.py" rel="nofollow">here</a>.</li> <li>It rivals the quality of state-of-the-art text-to-image generation systems (as of this writing) such as Stable Diffusion XL, Imagen, and DALL-E 2, while being more efficient than them.</li>',ve,J,ye,E,Ae,H,ht='Run the <a href="/docs/diffusers/pr_7926/en/api/pipelines/pixart#diffusers.PixArtAlphaPipeline">PixArtAlphaPipeline</a> with under 8GB GPU VRAM by loading the text encoder in 8-bit precision. Let’s walk through a full-fledged example.',Pe,W,ft='First, install the <a href="https://github.com/TimDettmers/bitsandbytes" rel="nofollow">bitsandbytes</a> library:',$e,R,Je,V,ut="Then load the text encoder in 8-bit:",je,Q,Ie,N,gt="Now, use the <code>pipe</code> to encode a prompt:",Ue,q,Ce,S,_t="Since text embeddings have been computed, remove the <code>text_encoder</code> and <code>pipe</code> from the memory, and free up some GPU VRAM:",Ge,Y,ke,F,xt="Then compute the latents with the prompt embeddings as inputs:",Be,D,Ze,j,Le,z,bt="Once the latents are computed, pass it off to the VAE to decode into a real image:",Xe,O,Ee,K,wt='By deleting components you aren’t using and flushing the GPU VRAM, you should be able to run <a href="/docs/diffusers/pr_7926/en/api/pipelines/pixart#diffusers.PixArtAlphaPipeline">PixArtAlphaPipeline</a> with under 8GB GPU VRAM.',He,ee,Tt='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/pixart/8bits_cat.png"/>',We,te,Mt='If you want a report of your memory-usage, run this <a href="https://gist.github.com/sayakpaul/3ae0f847001d342af27018a96f467e4e" rel="nofollow">script</a>.',Re,I,Ve,ne,vt="While loading the <code>text_encoder</code>, you set <code>load_in_8bit</code> to <code>True</code>. You could also specify <code>load_in_4bit</code> to bring your memory requirements down even further to under 7GB.",Qe,ie,Ne,w,oe,De,de,yt="Pipeline for text-to-image generation using PixArt-Alpha.",ze,ce,At=`This model inherits from <a href="/docs/diffusers/pr_7926/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods the
library implements for all the pipelines (such as downloading or saving, running on a particular device, etc.)`,Oe,P,ae,Ke,me,Pt="Function invoked when calling the pipeline for generation.",et,U,tt,C,se,nt,he,$t="Encodes the prompt into text encoder hidden states.",qe,re,Se,fe,Ye;return v=new at({props:{title:"PixArt-α",local:"pixart-α",headingTag:"h1"}}),J=new it({props:{$$slots:{default:[Zt]},$$scope:{ctx:A}}}),E=new at({props:{title:"Inference with under 8GB GPU VRAM",local:"inference-with-under-8gb-gpu-vram",headingTag:"h2"}}),R=new pe({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1VJTIwYml0c2FuZGJ5dGVz",highlighted:"pip install -U bitsandbytes",wrap:!1}}),Q=new pe({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFQ1RW5jb2Rlck1vZGVsJTBBZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFBpeEFydEFscGhhUGlwZWxpbmUlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQXRleHRfZW5jb2RlciUyMCUzRCUyMFQ1RW5jb2Rlck1vZGVsLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJQaXhBcnQtYWxwaGElMkZQaXhBcnQtWEwtMi0xMDI0LU1TJTIyJTJDJTBBJTIwJTIwJTIwJTIwc3ViZm9sZGVyJTNEJTIydGV4dF9lbmNvZGVyJTIyJTJDJTBBJTIwJTIwJTIwJTIwbG9hZF9pbl84Yml0JTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMGRldmljZV9tYXAlM0QlMjJhdXRvJTIyJTJDJTBBJTBBKSUwQXBpcGUlMjAlM0QlMjBQaXhBcnRBbHBoYVBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJQaXhBcnQtYWxwaGElMkZQaXhBcnQtWEwtMi0xMDI0LU1TJTIyJTJDJTBBJTIwJTIwJTIwJTIwdGV4dF9lbmNvZGVyJTNEdGV4dF9lbmNvZGVyJTJDJTBBJTIwJTIwJTIwJTIwdHJhbnNmb3JtZXIlM0ROb25lJTJDJTBBJTIwJTIwJTIwJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIlMEEp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> T5EncoderModel
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> PixArtAlphaPipeline
<span class="hljs-keyword">import</span> torch

text_encoder = T5EncoderModel.from_pretrained(
    <span class="hljs-string">&quot;PixArt-alpha/PixArt-XL-2-1024-MS&quot;</span>,
    subfolder=<span class="hljs-string">&quot;text_encoder&quot;</span>,
    load_in_8bit=<span class="hljs-literal">True</span>,
    device_map=<span class="hljs-string">&quot;auto&quot;</span>,

)
pipe = PixArtAlphaPipeline.from_pretrained(
    <span class="hljs-string">&quot;PixArt-alpha/PixArt-XL-2-1024-MS&quot;</span>,
    text_encoder=text_encoder,
    transformer=<span class="hljs-literal">None</span>,
    device_map=<span class="hljs-string">&quot;auto&quot;</span>
)`,wrap:!1}}),q=new pe({props:{code:"d2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMHByb21wdCUyMCUzRCUyMCUyMmN1dGUlMjBjYXQlMjIlMEElMjAlMjAlMjAlMjBwcm9tcHRfZW1iZWRzJTJDJTIwcHJvbXB0X2F0dGVudGlvbl9tYXNrJTJDJTIwbmVnYXRpdmVfZW1iZWRzJTJDJTIwbmVnYXRpdmVfcHJvbXB0X2F0dGVudGlvbl9tYXNrJTIwJTNEJTIwcGlwZS5lbmNvZGVfcHJvbXB0KHByb21wdCk=",highlighted:`<span class="hljs-keyword">with</span> torch.no_grad():
    prompt = <span class="hljs-string">&quot;cute cat&quot;</span>
    prompt_embeds, prompt_attention_mask, negative_embeds, negative_prompt_attention_mask = pipe.encode_prompt(prompt)`,wrap:!1}}),Y=new pe({props:{code:"aW1wb3J0JTIwZ2MlMEElMEFkZWYlMjBmbHVzaCgpJTNBJTBBJTIwJTIwJTIwJTIwZ2MuY29sbGVjdCgpJTBBJTIwJTIwJTIwJTIwdG9yY2guY3VkYS5lbXB0eV9jYWNoZSgpJTBBJTBBZGVsJTIwdGV4dF9lbmNvZGVyJTBBZGVsJTIwcGlwZSUwQWZsdXNoKCk=",highlighted:`<span class="hljs-keyword">import</span> gc

<span class="hljs-keyword">def</span> <span class="hljs-title function_">flush</span>():
    gc.collect()
    torch.cuda.empty_cache()

<span class="hljs-keyword">del</span> text_encoder
<span class="hljs-keyword">del</span> pipe
flush()`,wrap:!1}}),D=new pe({props:{code:"cGlwZSUyMCUzRCUyMFBpeEFydEFscGhhUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMlBpeEFydC1hbHBoYSUyRlBpeEFydC1YTC0yLTEwMjQtTVMlMjIlMkMlMEElMjAlMjAlMjAlMjB0ZXh0X2VuY29kZXIlM0ROb25lJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBKS50byglMjJjdWRhJTIyKSUwQSUwQWxhdGVudHMlMjAlM0QlMjBwaXBlKCUwQSUyMCUyMCUyMCUyMG5lZ2F0aXZlX3Byb21wdCUzRE5vbmUlMkMlMEElMjAlMjAlMjAlMjBwcm9tcHRfZW1iZWRzJTNEcHJvbXB0X2VtYmVkcyUyQyUwQSUyMCUyMCUyMCUyMG5lZ2F0aXZlX3Byb21wdF9lbWJlZHMlM0RuZWdhdGl2ZV9lbWJlZHMlMkMlMEElMjAlMjAlMjAlMjBwcm9tcHRfYXR0ZW50aW9uX21hc2slM0Rwcm9tcHRfYXR0ZW50aW9uX21hc2slMkMlMEElMjAlMjAlMjAlMjBuZWdhdGl2ZV9wcm9tcHRfYXR0ZW50aW9uX21hc2slM0RuZWdhdGl2ZV9wcm9tcHRfYXR0ZW50aW9uX21hc2slMkMlMEElMjAlMjAlMjAlMjBudW1faW1hZ2VzX3Blcl9wcm9tcHQlM0QxJTJDJTBBJTIwJTIwJTIwJTIwb3V0cHV0X3R5cGUlM0QlMjJsYXRlbnQlMjIlMkMlMEEpLmltYWdlcyUwQSUwQWRlbCUyMHBpcGUudHJhbnNmb3JtZXIlMEFmbHVzaCgp",highlighted:`pipe = PixArtAlphaPipeline.from_pretrained(
    <span class="hljs-string">&quot;PixArt-alpha/PixArt-XL-2-1024-MS&quot;</span>,
    text_encoder=<span class="hljs-literal">None</span>,
    torch_dtype=torch.float16,
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

latents = pipe(
    negative_prompt=<span class="hljs-literal">None</span>,
    prompt_embeds=prompt_embeds,
    negative_prompt_embeds=negative_embeds,
    prompt_attention_mask=prompt_attention_mask,
    negative_prompt_attention_mask=negative_prompt_attention_mask,
    num_images_per_prompt=<span class="hljs-number">1</span>,
    output_type=<span class="hljs-string">&quot;latent&quot;</span>,
).images

<span class="hljs-keyword">del</span> pipe.transformer
flush()`,wrap:!1}}),j=new it({props:{$$slots:{default:[Lt]},$$scope:{ctx:A}}}),O=new pe({props:{code:"d2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMGltYWdlJTIwJTNEJTIwcGlwZS52YWUuZGVjb2RlKGxhdGVudHMlMjAlMkYlMjBwaXBlLnZhZS5jb25maWcuc2NhbGluZ19mYWN0b3IlMkMlMjByZXR1cm5fZGljdCUzREZhbHNlKSU1QjAlNUQlMEFpbWFnZSUyMCUzRCUyMHBpcGUuaW1hZ2VfcHJvY2Vzc29yLnBvc3Rwcm9jZXNzKGltYWdlJTJDJTIwb3V0cHV0X3R5cGUlM0QlMjJwaWwlMjIpJTVCMCU1RCUwQWltYWdlLnNhdmUoJTIyY2F0LnBuZyUyMik=",highlighted:`<span class="hljs-keyword">with</span> torch.no_grad():
    image = pipe.vae.decode(latents / pipe.vae.config.scaling_factor, return_dict=<span class="hljs-literal">False</span>)[<span class="hljs-number">0</span>]
image = pipe.image_processor.postprocess(image, output_type=<span class="hljs-string">&quot;pil&quot;</span>)[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;cat.png&quot;</span>)`,wrap:!1}}),I=new it({props:{warning:!0,$$slots:{default:[Xt]},$$scope:{ctx:A}}}),ie=new at({props:{title:"PixArtAlphaPipeline",local:"diffusers.PixArtAlphaPipeline",headingTag:"h2"}}),oe=new ot({props:{name:"class diffusers.PixArtAlphaPipeline",anchor:"diffusers.PixArtAlphaPipeline",parameters:[{name:"tokenizer",val:": T5Tokenizer"},{name:"text_encoder",val:": T5EncoderModel"},{name:"vae",val:": AutoencoderKL"},{name:"transformer",val:": PixArtTransformer2DModel"},{name:"scheduler",val:": DPMSolverMultistepScheduler"}],parametersDescription:[{anchor:"diffusers.PixArtAlphaPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/pr_7926/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.PixArtAlphaPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>T5EncoderModel</code>) &#x2014;
Frozen text-encoder. PixArt-Alpha uses
<a href="https://huggingface.co/docs/transformers/model_doc/t5#transformers.T5EncoderModel" rel="nofollow">T5</a>, specifically the
<a href="https://huggingface.co/PixArt-alpha/PixArt-alpha/tree/main/t5-v1_1-xxl" rel="nofollow">t5-v1_1-xxl</a> variant.`,name:"text_encoder"},{anchor:"diffusers.PixArtAlphaPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>T5Tokenizer</code>) &#x2014;
Tokenizer of class
<a href="https://huggingface.co/docs/transformers/model_doc/t5#transformers.T5Tokenizer" rel="nofollow">T5Tokenizer</a>.`,name:"tokenizer"},{anchor:"diffusers.PixArtAlphaPipeline.transformer",description:`<strong>transformer</strong> (<a href="/docs/diffusers/pr_7926/en/api/models/pixart_transformer2d#diffusers.PixArtTransformer2DModel">PixArtTransformer2DModel</a>) &#x2014;
A text conditioned <code>PixArtTransformer2DModel</code> to denoise the encoded image latents.`,name:"transformer"},{anchor:"diffusers.PixArtAlphaPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/pr_7926/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a>) &#x2014;
A scheduler to be used in combination with <code>transformer</code> to denoise the encoded image latents.`,name:"scheduler"}],source:"https://github.com/huggingface/diffusers/blob/vr_7926/src/diffusers/pipelines/pixart_alpha/pipeline_pixart_alpha.py#L232"}}),ae=new ot({props:{name:"__call__",anchor:"diffusers.PixArtAlphaPipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"negative_prompt",val:": str = ''"},{name:"num_inference_steps",val:": int = 20"},{name:"timesteps",val:": typing.List[int] = None"},{name:"sigmas",val:": typing.List[float] = None"},{name:"guidance_scale",val:": float = 4.5"},{name:"num_images_per_prompt",val:": typing.Optional[int] = 1"},{name:"height",val:": typing.Optional[int] = None"},{name:"width",val:": typing.Optional[int] = None"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"output_type",val:": typing.Optional[str] = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"callback",val:": typing.Optional[typing.Callable[[int, int, torch.Tensor], NoneType]] = None"},{name:"callback_steps",val:": int = 1"},{name:"clean_caption",val:": bool = True"},{name:"use_resolution_binning",val:": bool = True"},{name:"max_sequence_length",val:": int = 120"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.PixArtAlphaPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide the image generation. If not defined, one has to pass <code>prompt_embeds</code>.
instead.`,name:"prompt"},{anchor:"diffusers.PixArtAlphaPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.PixArtAlphaPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 100) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.PixArtAlphaPipeline.__call__.timesteps",description:`<strong>timesteps</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Custom timesteps to use for the denoising process with schedulers which support a <code>timesteps</code> argument
in their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is
passed will be used. Must be in descending order.`,name:"timesteps"},{anchor:"diffusers.PixArtAlphaPipeline.__call__.sigmas",description:`<strong>sigmas</strong> (<code>List[float]</code>, <em>optional</em>) &#x2014;
Custom sigmas to use for the denoising process with schedulers which support a <code>sigmas</code> argument in
their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is passed
will be used.`,name:"sigmas"},{anchor:"diffusers.PixArtAlphaPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 4.5) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.PixArtAlphaPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.PixArtAlphaPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to self.unet.config.sample_size) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.PixArtAlphaPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to self.unet.config.sample_size) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"diffusers.PixArtAlphaPipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) in the DDIM paper: <a href="https://arxiv.org/abs/2010.02502" rel="nofollow">https://arxiv.org/abs/2010.02502</a>. Only applies to
<a href="/docs/diffusers/pr_7926/en/api/schedulers/ddim#diffusers.DDIMScheduler">schedulers.DDIMScheduler</a>, will be ignored for others.`,name:"eta"},{anchor:"diffusers.PixArtAlphaPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.PixArtAlphaPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.PixArtAlphaPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.PixArtAlphaPipeline.__call__.prompt_attention_mask",description:"<strong>prompt_attention_mask</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014; Pre-generated attention mask for text embeddings.",name:"prompt_attention_mask"},{anchor:"diffusers.PixArtAlphaPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. For PixArt-Alpha this negative prompt should be &quot;&quot;. If not
provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.PixArtAlphaPipeline.__call__.negative_prompt_attention_mask",description:`<strong>negative_prompt_attention_mask</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated attention mask for negative text embeddings.`,name:"negative_prompt_attention_mask"},{anchor:"diffusers.PixArtAlphaPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between
<a href="https://pillow.readthedocs.io/en/stable/" rel="nofollow">PIL</a>: <code>PIL.Image.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.PixArtAlphaPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>~pipelines.stable_diffusion.IFPipelineOutput</code> instead of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.PixArtAlphaPipeline.__call__.callback",description:`<strong>callback</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that will be called every <code>callback_steps</code> steps during inference. The function will be
called with the following arguments: <code>callback(step: int, timestep: int, latents: torch.Tensor)</code>.`,name:"callback"},{anchor:"diffusers.PixArtAlphaPipeline.__call__.callback_steps",description:`<strong>callback_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The frequency at which the <code>callback</code> function will be called. If not specified, the callback will be
called at every step.`,name:"callback_steps"},{anchor:"diffusers.PixArtAlphaPipeline.__call__.clean_caption",description:`<strong>clean_caption</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to clean the caption before creating embeddings. Requires <code>beautifulsoup4</code> and <code>ftfy</code> to
be installed. If the dependencies are not installed, the embeddings will be created from the raw
prompt.`,name:"clean_caption"},{anchor:"diffusers.PixArtAlphaPipeline.__call__.use_resolution_binning",description:`<strong>use_resolution_binning</strong> (<code>bool</code> defaults to <code>True</code>) &#x2014;
If set to <code>True</code>, the requested height and width are first mapped to the closest resolutions using
<code>ASPECT_RATIO_1024_BIN</code>. After the produced latents are decoded into images, they are resized back to
the requested resolution. Useful for generating non-square images.`,name:"use_resolution_binning"},{anchor:"diffusers.PixArtAlphaPipeline.__call__.max_sequence_length",description:"<strong>max_sequence_length</strong> (<code>int</code> defaults to 120) &#x2014; Maximum sequence length to use with the <code>prompt</code>.",name:"max_sequence_length"}],source:"https://github.com/huggingface/diffusers/blob/vr_7926/src/diffusers/pipelines/pixart_alpha/pipeline_pixart_alpha.py#L682",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <a
  href="/docs/diffusers/pr_7926/en/api/pipelines/latent_diffusion#diffusers.ImagePipelineOutput"
>ImagePipelineOutput</a> is returned, otherwise a <code>tuple</code> is
returned where the first element is a list with the generated images</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/pr_7926/en/api/pipelines/latent_diffusion#diffusers.ImagePipelineOutput"
>ImagePipelineOutput</a> or <code>tuple</code></p>
`}}),U=new kt({props:{anchor:"diffusers.PixArtAlphaPipeline.__call__.example",$$slots:{default:[Et]},$$scope:{ctx:A}}}),se=new ot({props:{name:"encode_prompt",anchor:"diffusers.PixArtAlphaPipeline.encode_prompt",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]]"},{name:"do_classifier_free_guidance",val:": bool = True"},{name:"negative_prompt",val:": str = ''"},{name:"num_images_per_prompt",val:": int = 1"},{name:"device",val:": typing.Optional[torch.device] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"clean_caption",val:": bool = False"},{name:"max_sequence_length",val:": int = 120"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.PixArtAlphaPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded`,name:"prompt"},{anchor:"diffusers.PixArtAlphaPipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt not to guide the image generation. If not defined, one has to pass <code>negative_prompt_embeds</code>
instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is less than <code>1</code>). For
PixArt-Alpha, this should be &quot;&quot;.`,name:"negative_prompt"},{anchor:"diffusers.PixArtAlphaPipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
whether to use classifier free guidance or not`,name:"do_classifier_free_guidance"},{anchor:"diffusers.PixArtAlphaPipeline.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
number of images that should be generated per prompt`,name:"num_images_per_prompt"},{anchor:"diffusers.PixArtAlphaPipeline.encode_prompt.device",description:`<strong>device</strong> &#x2014; (<code>torch.device</code>, <em>optional</em>):
torch device to place the resulting embeddings on`,name:"device"},{anchor:"diffusers.PixArtAlphaPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.PixArtAlphaPipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. For PixArt-Alpha, it&#x2019;s should be the embeddings of the &quot;&quot;
string.`,name:"negative_prompt_embeds"},{anchor:"diffusers.PixArtAlphaPipeline.encode_prompt.clean_caption",description:`<strong>clean_caption</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
If <code>True</code>, the function will preprocess and clean the provided caption before encoding.`,name:"clean_caption"},{anchor:"diffusers.PixArtAlphaPipeline.encode_prompt.max_sequence_length",description:"<strong>max_sequence_length</strong> (<code>int</code>, defaults to 120) &#x2014; Maximum sequence length to use for the prompt.",name:"max_sequence_length"}],source:"https://github.com/huggingface/diffusers/blob/vr_7926/src/diffusers/pipelines/pixart_alpha/pipeline_pixart_alpha.py#L292"}}),re=new Bt({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/api/pipelines/pixart.md"}}),{c(){s=r("meta"),b=o(),p=r("p"),m=o(),h(v.$$.fragment),c=o(),y=r("p"),y.innerHTML=st,_e=o(),G=r("p"),G.innerHTML=rt,xe=o(),k=r("p"),k.textContent=lt,be=o(),B=r("p"),B.innerHTML=pt,we=o(),Z=r("p"),Z.innerHTML=dt,Te=o(),L=r("p"),L.textContent=ct,Me=o(),X=r("ul"),X.innerHTML=mt,ve=o(),h(J.$$.fragment),ye=o(),h(E.$$.fragment),Ae=o(),H=r("p"),H.innerHTML=ht,Pe=o(),W=r("p"),W.innerHTML=ft,$e=o(),h(R.$$.fragment),Je=o(),V=r("p"),V.textContent=ut,je=o(),h(Q.$$.fragment),Ie=o(),N=r("p"),N.innerHTML=gt,Ue=o(),h(q.$$.fragment),Ce=o(),S=r("p"),S.innerHTML=_t,Ge=o(),h(Y.$$.fragment),ke=o(),F=r("p"),F.textContent=xt,Be=o(),h(D.$$.fragment),Ze=o(),h(j.$$.fragment),Le=o(),z=r("p"),z.textContent=bt,Xe=o(),h(O.$$.fragment),Ee=o(),K=r("p"),K.innerHTML=wt,He=o(),ee=r("p"),ee.innerHTML=Tt,We=o(),te=r("p"),te.innerHTML=Mt,Re=o(),h(I.$$.fragment),Ve=o(),ne=r("p"),ne.innerHTML=vt,Qe=o(),h(ie.$$.fragment),Ne=o(),w=r("div"),h(oe.$$.fragment),De=o(),de=r("p"),de.textContent=yt,ze=o(),ce=r("p"),ce.innerHTML=At,Oe=o(),P=r("div"),h(ae.$$.fragment),Ke=o(),me=r("p"),me.textContent=Pt,et=o(),h(U.$$.fragment),tt=o(),C=r("div"),h(se.$$.fragment),nt=o(),he=r("p"),he.textContent=$t,qe=o(),h(re.$$.fragment),Se=o(),fe=r("p"),this.h()},l(e){const t=Gt("svelte-u9bgzb",document.head);s=l(t,"META",{name:!0,content:!0}),t.forEach(n),b=a(e),p=l(e,"P",{}),ue(p).forEach(n),m=a(e),f(v.$$.fragment,e),c=a(e),y=l(e,"P",{"data-svelte-h":!0}),d(y)!=="svelte-v8u40f"&&(y.innerHTML=st),_e=a(e),G=l(e,"P",{"data-svelte-h":!0}),d(G)!=="svelte-9ej743"&&(G.innerHTML=rt),xe=a(e),k=l(e,"P",{"data-svelte-h":!0}),d(k)!=="svelte-1cwsb16"&&(k.textContent=lt),be=a(e),B=l(e,"P",{"data-svelte-h":!0}),d(B)!=="svelte-1ddr7a0"&&(B.innerHTML=pt),we=a(e),Z=l(e,"P",{"data-svelte-h":!0}),d(Z)!=="svelte-1c7kadv"&&(Z.innerHTML=dt),Te=a(e),L=l(e,"P",{"data-svelte-h":!0}),d(L)!=="svelte-v1sn1g"&&(L.textContent=ct),Me=a(e),X=l(e,"UL",{"data-svelte-h":!0}),d(X)!=="svelte-1o0jwg8"&&(X.innerHTML=mt),ve=a(e),f(J.$$.fragment,e),ye=a(e),f(E.$$.fragment,e),Ae=a(e),H=l(e,"P",{"data-svelte-h":!0}),d(H)!=="svelte-d1fxxv"&&(H.innerHTML=ht),Pe=a(e),W=l(e,"P",{"data-svelte-h":!0}),d(W)!=="svelte-c2h3fb"&&(W.innerHTML=ft),$e=a(e),f(R.$$.fragment,e),Je=a(e),V=l(e,"P",{"data-svelte-h":!0}),d(V)!=="svelte-5r7318"&&(V.textContent=ut),je=a(e),f(Q.$$.fragment,e),Ie=a(e),N=l(e,"P",{"data-svelte-h":!0}),d(N)!=="svelte-rj1jgt"&&(N.innerHTML=gt),Ue=a(e),f(q.$$.fragment,e),Ce=a(e),S=l(e,"P",{"data-svelte-h":!0}),d(S)!=="svelte-1ux3xow"&&(S.innerHTML=_t),Ge=a(e),f(Y.$$.fragment,e),ke=a(e),F=l(e,"P",{"data-svelte-h":!0}),d(F)!=="svelte-w3d4de"&&(F.textContent=xt),Be=a(e),f(D.$$.fragment,e),Ze=a(e),f(j.$$.fragment,e),Le=a(e),z=l(e,"P",{"data-svelte-h":!0}),d(z)!=="svelte-1yf7wfg"&&(z.textContent=bt),Xe=a(e),f(O.$$.fragment,e),Ee=a(e),K=l(e,"P",{"data-svelte-h":!0}),d(K)!=="svelte-17n5mg"&&(K.innerHTML=wt),He=a(e),ee=l(e,"P",{"data-svelte-h":!0}),d(ee)!=="svelte-1g55ccf"&&(ee.innerHTML=Tt),We=a(e),te=l(e,"P",{"data-svelte-h":!0}),d(te)!=="svelte-11lvu0m"&&(te.innerHTML=Mt),Re=a(e),f(I.$$.fragment,e),Ve=a(e),ne=l(e,"P",{"data-svelte-h":!0}),d(ne)!=="svelte-1i82z60"&&(ne.innerHTML=vt),Qe=a(e),f(ie.$$.fragment,e),Ne=a(e),w=l(e,"DIV",{class:!0});var M=ue(w);f(oe.$$.fragment,M),De=a(M),de=l(M,"P",{"data-svelte-h":!0}),d(de)!=="svelte-31ka93"&&(de.textContent=yt),ze=a(M),ce=l(M,"P",{"data-svelte-h":!0}),d(ce)!=="svelte-1uvphy3"&&(ce.innerHTML=At),Oe=a(M),P=l(M,"DIV",{class:!0});var $=ue(P);f(ae.$$.fragment,$),Ke=a($),me=l($,"P",{"data-svelte-h":!0}),d(me)!=="svelte-v78lg8"&&(me.textContent=Pt),et=a($),f(U.$$.fragment,$),$.forEach(n),tt=a(M),C=l(M,"DIV",{class:!0});var le=ue(C);f(se.$$.fragment,le),nt=a(le),he=l(le,"P",{"data-svelte-h":!0}),d(he)!=="svelte-16q0ax1"&&(he.textContent=$t),le.forEach(n),M.forEach(n),qe=a(e),f(re.$$.fragment,e),Se=a(e),fe=l(e,"P",{}),ue(fe).forEach(n),this.h()},h(){ge(s,"name","hf:doc:metadata"),ge(s,"content",Wt),ge(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),ge(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),ge(w,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){T(document.head,s),i(e,b,t),i(e,p,t),i(e,m,t),u(v,e,t),i(e,c,t),i(e,y,t),i(e,_e,t),i(e,G,t),i(e,xe,t),i(e,k,t),i(e,be,t),i(e,B,t),i(e,we,t),i(e,Z,t),i(e,Te,t),i(e,L,t),i(e,Me,t),i(e,X,t),i(e,ve,t),u(J,e,t),i(e,ye,t),u(E,e,t),i(e,Ae,t),i(e,H,t),i(e,Pe,t),i(e,W,t),i(e,$e,t),u(R,e,t),i(e,Je,t),i(e,V,t),i(e,je,t),u(Q,e,t),i(e,Ie,t),i(e,N,t),i(e,Ue,t),u(q,e,t),i(e,Ce,t),i(e,S,t),i(e,Ge,t),u(Y,e,t),i(e,ke,t),i(e,F,t),i(e,Be,t),u(D,e,t),i(e,Ze,t),u(j,e,t),i(e,Le,t),i(e,z,t),i(e,Xe,t),u(O,e,t),i(e,Ee,t),i(e,K,t),i(e,He,t),i(e,ee,t),i(e,We,t),i(e,te,t),i(e,Re,t),u(I,e,t),i(e,Ve,t),i(e,ne,t),i(e,Qe,t),u(ie,e,t),i(e,Ne,t),i(e,w,t),u(oe,w,null),T(w,De),T(w,de),T(w,ze),T(w,ce),T(w,Oe),T(w,P),u(ae,P,null),T(P,Ke),T(P,me),T(P,et),u(U,P,null),T(w,tt),T(w,C),u(se,C,null),T(C,nt),T(C,he),i(e,qe,t),u(re,e,t),i(e,Se,t),i(e,fe,t),Ye=!0},p(e,[t]){const M={};t&2&&(M.$$scope={dirty:t,ctx:e}),J.$set(M);const $={};t&2&&($.$$scope={dirty:t,ctx:e}),j.$set($);const le={};t&2&&(le.$$scope={dirty:t,ctx:e}),I.$set(le);const Jt={};t&2&&(Jt.$$scope={dirty:t,ctx:e}),U.$set(Jt)},i(e){Ye||(g(v.$$.fragment,e),g(J.$$.fragment,e),g(E.$$.fragment,e),g(R.$$.fragment,e),g(Q.$$.fragment,e),g(q.$$.fragment,e),g(Y.$$.fragment,e),g(D.$$.fragment,e),g(j.$$.fragment,e),g(O.$$.fragment,e),g(I.$$.fragment,e),g(ie.$$.fragment,e),g(oe.$$.fragment,e),g(ae.$$.fragment,e),g(U.$$.fragment,e),g(se.$$.fragment,e),g(re.$$.fragment,e),Ye=!0)},o(e){_(v.$$.fragment,e),_(J.$$.fragment,e),_(E.$$.fragment,e),_(R.$$.fragment,e),_(Q.$$.fragment,e),_(q.$$.fragment,e),_(Y.$$.fragment,e),_(D.$$.fragment,e),_(j.$$.fragment,e),_(O.$$.fragment,e),_(I.$$.fragment,e),_(ie.$$.fragment,e),_(oe.$$.fragment,e),_(ae.$$.fragment,e),_(U.$$.fragment,e),_(se.$$.fragment,e),_(re.$$.fragment,e),Ye=!1},d(e){e&&(n(b),n(p),n(m),n(c),n(y),n(_e),n(G),n(xe),n(k),n(be),n(B),n(we),n(Z),n(Te),n(L),n(Me),n(X),n(ve),n(ye),n(Ae),n(H),n(Pe),n(W),n($e),n(Je),n(V),n(je),n(Ie),n(N),n(Ue),n(Ce),n(S),n(Ge),n(ke),n(F),n(Be),n(Ze),n(Le),n(z),n(Xe),n(Ee),n(K),n(He),n(ee),n(We),n(te),n(Re),n(Ve),n(ne),n(Qe),n(Ne),n(w),n(qe),n(Se),n(fe)),n(s),x(v,e),x(J,e),x(E,e),x(R,e),x(Q,e),x(q,e),x(Y,e),x(D,e),x(j,e),x(O,e),x(I,e),x(ie,e),x(oe),x(ae),x(U),x(se),x(re,e)}}}const Wt='{"title":"PixArt-α","local":"pixart-α","sections":[{"title":"Inference with under 8GB GPU VRAM","local":"inference-with-under-8gb-gpu-vram","sections":[],"depth":2},{"title":"PixArtAlphaPipeline","local":"diffusers.PixArtAlphaPipeline","sections":[],"depth":2}],"depth":1}';function Rt(A){return It(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Dt extends Ut{constructor(s){super(),Ct(this,s,Rt,Ht,jt,{})}}export{Dt as component};
