import{s as Il,n as Cl,o as Zl}from"../chunks/scheduler.65852ee5.js";import{S as Bl,i as vl,g as o,s as n,r,A as Gl,h as i,f as l,c as a,j as gl,u as p,x as M,k as fl,y as Wl,a as s,v as y,d as c,t as u,w as m}from"../chunks/index.aa74147d.js";import{D as kl,C as w}from"../chunks/DocNotebookDropdown.479f4286.js";import{H as J,E as Al}from"../chunks/EditOnGithub.4eda6a96.js";function Rl(St){let j,Be,Ce,ve,h,Ge,T,We,U,Qt='<em>Authored by: <a href="https://huggingface.co/m-ric" rel="nofollow">Aymeric Roucher</a></em>',ke,d,Et='This notebook demonstrates how you can use <a href="https://huggingface.co/docs/transformers/en/agents" rel="nofollow"><strong>Transformers Agents</strong></a> to build awesome <strong>agents</strong>!',Ae,b,Xt="What are <strong>agents</strong>? Agents are systems that are powered by an LLM and enable the LLM (with careful prompting and output parsing) to use specific <em>tools</em> to solve problems.",Re,g,qt='These <em>tools</em> are basically functions that the LLM couldn’t perform well by itself: for instance for a text-generation LLM like <a href="https://huggingface.co/meta-llama/Meta-Llama-3-70B-Instruct" rel="nofollow">Llama-3-70B</a>, this could be an image generation tool, a web search tool, a calculator…',_e,f,xt='What is <strong>Transformers Agents</strong>? it’s an extension of our <code>transformers</code> library that provides building blocks to build your own agents! Learn more about it in the <a href="https://huggingface.co/docs/transformers/en/agents" rel="nofollow">documentation</a>.',Ve,I,Yt="Let’s see how to use it, and which use cases it can solve.",Ne,C,Ht="We install transformers agents from source since it has not been released as of writing, but later this week when it gets release you can simply install it with <code>pip install transformers[agents]</code>.",$e,Z,Se,B,Qe,v,Ee,G,zt="For this use case, we want to show an agent that browses the web and is able to generate image.",Xe,W,Ft="To build it, we simply need to have two tools ready: image generation and web search.",qe,k,Lt="<li>For image generation, we load a tool from the Hub that uses the HF Inference API (Serverless) to generate images using Stable Diffusion.</li> <li>For the web search, we load a LangChain tool.</li>",xe,A,Ye,R,He,_,ze,V,Pt='<img src="https://huggingface.co/datasets/huggingface/cookbook-images/resolve/main/agents_db5.png" alt="Image of an Aston Martin DB5"/>',Fe,N,Le,$,Kt="Quick definition: Retrieval-Augmented-Generation (RAG) is <strong><em>“using an LLM to answer a user query, but basing the answer on information retrieved from a knowledge base”.</em></strong>",Pe,S,Dt="This method has many advantages over using a vanilla or fine-tuned LLM: to name a few, it allows to ground the answer on true facts and reduce confabulations, it allows to provide the LLM with domain-specific knowledge, and it allows fine-grained control of access to information from the knowledge base.",Ke,Q,Ot="<li><p>Now let’s say we want to perform RAG, but with the additional constraint that some parameters must be dynamically generated. For example, depending on the user query we could want to restrict the search to specific subsets of the knowledge base, or we could want to adjust the number of documents retrieved. The difficulty is: <strong>how to dynamically adjust these parameters based on the user query?</strong></p></li> <li><p>A frequent failure case of RAG is when the retrieval based on the user query does not return any relevant supporting documents. <strong>Is there a way to iterate by re-calling the retriever with a modified query in case the previous results were not relevant?</strong></p></li>",De,E,el="🔧 Well, we can solve the points above in a simple way: we will <strong>give our agent control over the retriever’s parameters!</strong>",Oe,X,tl="➡️ Let’s show how to do this. We first load a knowledge base on which we want to perform RAG: this dataset is a compilation of the documentation pages for many <code>huggingface</code> packages, stored as markdown.",et,q,tt,x,ll="Now we prepare the knowledge base by processing the dataset and storing it into a vector database to be used by the retriever. We are going to use LangChain, since it features excellent utilities for vector databases:",lt,Y,st,H,sl="Now that we have the database ready, let’s build a RAG system that answers user queries based on it!",nt,z,nl="We want our system to select only from the most relevant sources of information, depending on the query.",at,F,al="Our documentation pages come from the following sources:",ot,L,it,P,ol=`['evaluate', 'course', 'deep-rl-class', 'peft', 'hf-endpoints-documentation', 'blog', 'gradio', 'datasets', 'datasets-server', 'transformers', 'optimum', 'hub-docs', 'pytorch-image-models', 'diffusers']
`,Mt,K,rt,D,pt,O,il="To share your tool to the Hub, first copy-paste the code in the RetrieverTool definition cell to a new file named for instance <code>retriever.py</code>.",yt,ee,Ml="When the tool is loaded from a separate file, you can then push it to the Hub using the code below (make sure to login with a <code>write</code> access token)",ct,te,ut,le,mt,se,wt,ne,rl=`Final output:
https://github.com/huggingface/diffusers/blob/main/examples/text_to_image/train_text_to_image_lora.py
`,jt,ae,pl="What happened here? First, the agent launched the retriever with specific sources in mind (<code>[&#39;transformers&#39;, &#39;blog&#39;]</code>).",Jt,oe,yl=`But this retrieval did not yield enough results ⇒ no problem! The agent could iterate on previous results, so it just re-ran its retrieval with less restrictive search parameters.
Thus the research was successful!`,ht,ie,cl="Note that <strong>using an LLM agent</strong> that calls a retriever as a tool and can dynamically modify the query and other retrieval parameters <strong>is a more general formulation of RAG</strong>, which also covers many RAG improvement techniques like iterative query refinement.",Tt,Me,Ut,re,ul="Since the ReactCodeAgent has a built-in Python code interpreter, we can use it to debug our faulty Python script!",dt,pe,bt,ye,ml="As you can see, the agent tried the given code, gets an error, analyses the error, corrects the code and returns it after veryfing that it works!",gt,ce,wl="And the final code is the corrected code:",ft,ue,It,me,jl=`list=[0, 1, 2]

for i in range(4):
    print(list(i))
`,Ct,we,Zt,je,Jl=`It’s really easy to set up your own LLM engine:
it only needs a <code>__call__</code> method with these criteria:`,Bt,Je,hl='<li>Takes as input a list of messages in <a href="https://huggingface.co/docs/transformers/main/en/chat_templating#introduction" rel="nofollow">ChatML format</a> and outputs the answer.</li> <li>Accepts a <code>stop_sequences</code> arguments to pass sequences on which generation stops.</li> <li>Depending on which kind of message roles your LLM accepts, you may also need to convert some message roles.</li>',vt,he,Gt,Te,Wt,Ue,Tl=`my_list = [0, 1, 2]  # Renamed the list to avoid using the built-in name

for i in range(len(my_list)):  # Changed the range to be within the length of the list
    print(my_list[i])  # Corrected the list access syntax
`,kt,de,At,be,Ul="The use cases above should give you a glimpse into the possibilities of our Agents framework!",Rt,ge,dl='For more advanced usage, read the <a href="https://huggingface.co/docs/transformers/en/transformers_agents" rel="nofollow">documentation</a>, and <a href="https://github.com/aymeric-roucher/agent_reasoning_benchmark/blob/main/benchmark_gaia.ipynb" rel="nofollow">this experiment</a> that allowed us to build our own agent based on Llama-3-70B that beats many GPT-4 agents on the very difficult <a href="https://huggingface.co/spaces/gaia-benchmark/leaderboard" rel="nofollow">GAIA Leaderboard</a>!',_t,fe,bl="All feedback is welcome, it will help us improve the framework! 🚀",Vt,Ie,Nt,Ze,$t;return h=new kl({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/cookbook/blob/haystack-fix-rendering/notebooks/en/agents.ipynb"}]}}),T=new J({props:{title:"Build an agent with tool-calling superpowers 🦸 using Transformers Agents",local:"build-an-agent-with-tool-calling-superpowers--using-transformers-agents",headingTag:"h1"}}),Z=new w({props:{code:"IXBpcCUyMGluc3RhbGwlMjAlMjJnaXQlMkJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZodWdnaW5nZmFjZSUyRnRyYW5zZm9ybWVycy5naXQlMjNlZ2clM0R0cmFuc2Zvcm1lcnMlNUJhZ2VudHMlNUQlMjI=",highlighted:'!pip install <span class="hljs-string">&quot;git+https://github.com/huggingface/transformers.git#egg=transformers[agents]&quot;</span>',wrap:!1}}),B=new w({props:{code:"IXBpcCUyMGluc3RhbGwlMjBkYXRhc2V0cyUyMGxhbmdjaGFpbiUyMHNlbnRlbmNlLXRyYW5zZm9ybWVycyUyMGZhaXNzLWNwdSUyMHNlcnBhcGklMjBnb29nbGUtc2VhcmNoLXJlc3VsdHMlMjBvcGVuYWklMjBsYW5nY2hhaW4tY29tbXVuaXR5JTIwLXE=",highlighted:"!pip install datasets langchain sentence-transformers faiss-cpu serpapi google-search-results openai langchain-community -q",wrap:!1}}),v=new J({props:{title:"1. 🏞️ Multimodal + 🌐 Web-browsing assistant",local:"1--multimodal---web-browsing-assistant",headingTag:"h2"}}),A=new w({props:{code:"aW1wb3J0JTIwb3MlMEElMEFvcy5lbnZpcm9uJTVCJTIyU0VSUEFQSV9BUElfS0VZJTIyJTVEJTIwJTNEJTIwJTIyJTIy",highlighted:`<span class="hljs-keyword">import</span> os

os.environ[<span class="hljs-string">&quot;SERPAPI_API_KEY&quot;</span>] = <span class="hljs-string">&quot;&quot;</span>`,wrap:!1}}),R=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBJTBBbm90ZWJvb2tfbG9naW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login

notebook_login()`,wrap:!1}}),_=new w({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRvb2wlMkMlMjBsb2FkX3Rvb2wlMkMlMjBSZWFjdENvZGVBZ2VudCUyQyUyMEhmRW5naW5lJTBBJTBBJTIzJTIwSW1wb3J0JTIwdG9vbCUyMGZyb20lMjBIdWIlMEFpbWFnZV9nZW5lcmF0aW9uX3Rvb2wlMjAlM0QlMjBsb2FkX3Rvb2woJTIybS1yaWMlMkZ0ZXh0LXRvLWltYWdlJTIyKSUwQSUwQSUyMyUyMEltcG9ydCUyMHRvb2wlMjBmcm9tJTIwTGFuZ0NoYWluJTBBZnJvbSUyMGxhbmdjaGFpbi5hZ2VudHMlMjBpbXBvcnQlMjBsb2FkX3Rvb2xzJTBBJTBBc2VhcmNoX3Rvb2wlMjAlM0QlMjBUb29sLmZyb21fbGFuZ2NoYWluKGxvYWRfdG9vbHMoJTVCJTIyc2VycGFwaSUyMiU1RCklNUIwJTVEKSUwQSUwQSUwQWxsbV9lbmdpbmUlMjAlM0QlMjBIZkVuZ2luZSglMjJtZXRhLWxsYW1hJTJGTWV0YS1MbGFtYS0zLTcwQi1JbnN0cnVjdCUyMiklMEElMjMlMjBJbml0aWFsaXplJTIwdGhlJTIwYWdlbnQlMjB3aXRoJTIwYm90aCUyMHRvb2xzJTBBYWdlbnQlMjAlM0QlMjBSZWFjdENvZGVBZ2VudCh0b29scyUzRCU1QmltYWdlX2dlbmVyYXRpb25fdG9vbCUyQyUyMHNlYXJjaF90b29sJTVEJTJDJTIwbGxtX2VuZ2luZSUzRGxsbV9lbmdpbmUpJTBBJTBBJTIzJTIwUnVuJTIwaXQhJTBBcmVzdWx0JTIwJTNEJTIwYWdlbnQucnVuKCUwQSUyMCUyMCUyMCUyMCUyMkdlbmVyYXRlJTIwbWUlMjBhJTIwcGhvdG8lMjBvZiUyMHRoZSUyMGNhciUyMHRoYXQlMjBKYW1lcyUyMGJvbmQlMjBkcm92ZSUyMGluJTIwdGhlJTIwbGF0ZXN0JTIwbW92aWUuJTIyJTJDJTBBKSUwQXJlc3VsdA==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Tool, load_tool, ReactCodeAgent, HfEngine

<span class="hljs-comment"># Import tool from Hub</span>
image_generation_tool = load_tool(<span class="hljs-string">&quot;m-ric/text-to-image&quot;</span>)

<span class="hljs-comment"># Import tool from LangChain</span>
<span class="hljs-keyword">from</span> langchain.agents <span class="hljs-keyword">import</span> load_tools

search_tool = Tool.from_langchain(load_tools([<span class="hljs-string">&quot;serpapi&quot;</span>])[<span class="hljs-number">0</span>])


llm_engine = HfEngine(<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-70B-Instruct&quot;</span>)
<span class="hljs-comment"># Initialize the agent with both tools</span>
agent = ReactCodeAgent(tools=[image_generation_tool, search_tool], llm_engine=llm_engine)

<span class="hljs-comment"># Run it!</span>
result = agent.run(
    <span class="hljs-string">&quot;Generate me a photo of the car that James bond drove in the latest movie.&quot;</span>,
)
result`,wrap:!1}}),N=new J({props:{title:"2. 📚💬 RAG with Iterative query refinement & Source selection",local:"2--rag-with-iterative-query-refinement--source-selection",headingTag:"h2"}}),q=new w({props:{code:"aW1wb3J0JTIwZGF0YXNldHMlMEElMEFrbm93bGVkZ2VfYmFzZSUyMCUzRCUyMGRhdGFzZXRzLmxvYWRfZGF0YXNldCglMjJtLXJpYyUyRmh1Z2dpbmdmYWNlX2RvYyUyMiUyQyUyMHNwbGl0JTNEJTIydHJhaW4lMjIp",highlighted:`<span class="hljs-keyword">import</span> datasets

knowledge_base = datasets.load_dataset(<span class="hljs-string">&quot;m-ric/huggingface_doc&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)`,wrap:!1}}),Y=new w({props:{code:"ZnJvbSUyMGxhbmdjaGFpbi5kb2NzdG9yZS5kb2N1bWVudCUyMGltcG9ydCUyMERvY3VtZW50JTBBZnJvbSUyMGxhbmdjaGFpbi50ZXh0X3NwbGl0dGVyJTIwaW1wb3J0JTIwUmVjdXJzaXZlQ2hhcmFjdGVyVGV4dFNwbGl0dGVyJTBBZnJvbSUyMGxhbmdjaGFpbi52ZWN0b3JzdG9yZXMlMjBpbXBvcnQlMjBGQUlTUyUwQWZyb20lMjBsYW5nY2hhaW5fY29tbXVuaXR5LmVtYmVkZGluZ3MlMjBpbXBvcnQlMjBIdWdnaW5nRmFjZUVtYmVkZGluZ3MlMEElMEFzb3VyY2VfZG9jcyUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMERvY3VtZW50KHBhZ2VfY29udGVudCUzRGRvYyU1QiUyMnRleHQlMjIlNUQlMkMlMjBtZXRhZGF0YSUzRCU3QiUyMnNvdXJjZSUyMiUzQSUyMGRvYyU1QiUyMnNvdXJjZSUyMiU1RC5zcGxpdCglMjIlMkYlMjIpJTVCMSU1RCU3RCklMjBmb3IlMjBkb2MlMjBpbiUyMGtub3dsZWRnZV9iYXNlJTBBJTVEJTBBJTBBZG9jc19wcm9jZXNzZWQlMjAlM0QlMjBSZWN1cnNpdmVDaGFyYWN0ZXJUZXh0U3BsaXR0ZXIoY2h1bmtfc2l6ZSUzRDUwMCkuc3BsaXRfZG9jdW1lbnRzKHNvdXJjZV9kb2NzKSU1QiUzQTEwMDAlNUQlMEElMEFlbWJlZGRpbmdfbW9kZWwlMjAlM0QlMjBIdWdnaW5nRmFjZUVtYmVkZGluZ3MobW9kZWxfbmFtZSUzRCUyMnRoZW5scGVyJTJGZ3RlLXNtYWxsJTIyKSUwQXZlY3RvcmRiJTIwJTNEJTIwRkFJU1MuZnJvbV9kb2N1bWVudHMoZG9jdW1lbnRzJTNEZG9jc19wcm9jZXNzZWQlMkMlMjBlbWJlZGRpbmclM0RlbWJlZGRpbmdfbW9kZWwp",highlighted:`<span class="hljs-keyword">from</span> langchain.docstore.document <span class="hljs-keyword">import</span> Document
<span class="hljs-keyword">from</span> langchain.text_splitter <span class="hljs-keyword">import</span> RecursiveCharacterTextSplitter
<span class="hljs-keyword">from</span> langchain.vectorstores <span class="hljs-keyword">import</span> FAISS
<span class="hljs-keyword">from</span> langchain_community.embeddings <span class="hljs-keyword">import</span> HuggingFaceEmbeddings

source_docs = [
    Document(page_content=doc[<span class="hljs-string">&quot;text&quot;</span>], metadata={<span class="hljs-string">&quot;source&quot;</span>: doc[<span class="hljs-string">&quot;source&quot;</span>].split(<span class="hljs-string">&quot;/&quot;</span>)[<span class="hljs-number">1</span>]}) <span class="hljs-keyword">for</span> doc <span class="hljs-keyword">in</span> knowledge_base
]

docs_processed = RecursiveCharacterTextSplitter(chunk_size=<span class="hljs-number">500</span>).split_documents(source_docs)[:<span class="hljs-number">1000</span>]

embedding_model = HuggingFaceEmbeddings(model_name=<span class="hljs-string">&quot;thenlper/gte-small&quot;</span>)
vectordb = FAISS.from_documents(documents=docs_processed, embedding=embedding_model)`,wrap:!1}}),L=new w({props:{code:"YWxsX3NvdXJjZXMlMjAlM0QlMjBsaXN0KHNldCglNUJkb2MubWV0YWRhdGElNUIlMjJzb3VyY2UlMjIlNUQlMjBmb3IlMjBkb2MlMjBpbiUyMGRvY3NfcHJvY2Vzc2VkJTVEKSklMEFwcmludChhbGxfc291cmNlcyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>all_sources = <span class="hljs-built_in">list</span>(<span class="hljs-built_in">set</span>([doc.metadata[<span class="hljs-string">&quot;source&quot;</span>] <span class="hljs-keyword">for</span> doc <span class="hljs-keyword">in</span> docs_processed]))
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(all_sources)`,wrap:!1}}),K=new w({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> json
<span class="hljs-keyword">from</span> transformers.agents <span class="hljs-keyword">import</span> Tool
<span class="hljs-keyword">from</span> langchain_core.vectorstores <span class="hljs-keyword">import</span> VectorStore


<span class="hljs-keyword">class</span> <span class="hljs-title class_">RetrieverTool</span>(<span class="hljs-title class_ inherited__">Tool</span>):
    name = <span class="hljs-string">&quot;retriever&quot;</span>
    description = (
        <span class="hljs-string">&quot;Retrieves some documents from the knowledge base that have the closest embeddings to the input query.&quot;</span>
    )
    inputs = {
        <span class="hljs-string">&quot;query&quot;</span>: {
            <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>,
            <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;The query to perform. This should be semantically close to your target documents. Use the affirmative form rather than a question.&quot;</span>,
        },
        <span class="hljs-string">&quot;source&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;&quot;</span>},
        <span class="hljs-string">&quot;number_of_documents&quot;</span>: {
            <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>,
            <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;the number of documents to retrieve. Stay under 10 to avoid drowning in docs&quot;</span>,
        },
    }
    output_type = <span class="hljs-string">&quot;text&quot;</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, vectordb: VectorStore, all_sources: <span class="hljs-built_in">str</span>, **kwargs</span>):
        <span class="hljs-built_in">super</span>().__init__(**kwargs)
        self.vectordb = vectordb
        self.inputs[<span class="hljs-string">&quot;source&quot;</span>][
            <span class="hljs-string">&quot;description&quot;</span>
        ] = <span class="hljs-string">f&quot;The source of the documents to search, as a str representation of a list. Possible values in the list are: <span class="hljs-subst">{all_sources}</span>. If this argument is not provided, all sources will be searched.&quot;</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, query: <span class="hljs-built_in">str</span>, source: <span class="hljs-built_in">str</span> = <span class="hljs-literal">None</span>, number_of_documents=<span class="hljs-number">7</span></span>) -&gt; <span class="hljs-built_in">str</span>:
        <span class="hljs-keyword">assert</span> <span class="hljs-built_in">isinstance</span>(query, <span class="hljs-built_in">str</span>), <span class="hljs-string">&quot;Your search query must be a string&quot;</span>
        number_of_documents = <span class="hljs-built_in">int</span>(number_of_documents)

        <span class="hljs-keyword">if</span> source:
            <span class="hljs-keyword">if</span> <span class="hljs-built_in">isinstance</span>(source, <span class="hljs-built_in">str</span>) <span class="hljs-keyword">and</span> <span class="hljs-string">&quot;[&quot;</span> <span class="hljs-keyword">not</span> <span class="hljs-keyword">in</span> <span class="hljs-built_in">str</span>(source):  <span class="hljs-comment"># if the source is not representing a list</span>
                source = [source]
            source = json.loads(<span class="hljs-built_in">str</span>(source).replace(<span class="hljs-string">&quot;&#x27;&quot;</span>, <span class="hljs-string">&#x27;&quot;&#x27;</span>))

        docs = self.vectordb.similarity_search(
            query,
            <span class="hljs-built_in">filter</span>=({<span class="hljs-string">&quot;source&quot;</span>: source} <span class="hljs-keyword">if</span> source <span class="hljs-keyword">else</span> <span class="hljs-literal">None</span>),
            k=number_of_documents,
        )

        <span class="hljs-keyword">if</span> <span class="hljs-built_in">len</span>(docs) == <span class="hljs-number">0</span>:
            <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;No documents found with this filtering. Try removing the source filter.&quot;</span>
        <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;Retrieved documents:\\n\\n&quot;</span> + <span class="hljs-string">&quot;\\n===Document===\\n&quot;</span>.join([doc.page_content <span class="hljs-keyword">for</span> doc <span class="hljs-keyword">in</span> docs])`,wrap:!1}}),D=new J({props:{title:"Optional: Share your Retriever tool to Hub",local:"optional-share-your-retriever-tool-to-hub",headingTag:"h3"}}),te=new w({props:{code:"c2hhcmVfdG9faHViJTIwJTNEJTIwRmFsc2UlMEElMEFpZiUyMHNoYXJlX3RvX2h1YiUzQSUwQSUyMCUyMCUyMCUyMGZyb20lMjBodWdnaW5nZmFjZV9odWIlMjBpbXBvcnQlMjBsb2dpbiUwQSUyMCUyMCUyMCUyMGZyb20lMjByZXRyaWV2ZXIlMjBpbXBvcnQlMjBSZXRyaWV2ZXJUb29sJTBBJTBBJTIwJTIwJTIwJTIwbG9naW4oJTIyeW91cl90b2tlbiUyMiklMEElMEElMjAlMjAlMjAlMjB0b29sJTIwJTNEJTIwUmV0cmlldmVyVG9vbCh2ZWN0b3JkYiUyQyUyMGFsbF9zb3VyY2VzKSUwQSUwQSUyMCUyMCUyMCUyMHRvb2wucHVzaF90b19odWIocmVwb19pZCUzRCUyMm0tcmljJTJGcmV0cmlldmVyLXRvb2wlMjIp",highlighted:`share_to_hub = <span class="hljs-literal">False</span>

<span class="hljs-keyword">if</span> share_to_hub:
    <span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> login
    <span class="hljs-keyword">from</span> retriever <span class="hljs-keyword">import</span> RetrieverTool

    login(<span class="hljs-string">&quot;your_token&quot;</span>)

    tool = RetrieverTool(vectordb, all_sources)

    tool.push_to_hub(repo_id=<span class="hljs-string">&quot;m-ric/retriever-tool&quot;</span>)`,wrap:!1}}),le=new J({props:{title:"Run the agent!",local:"run-the-agent",headingTag:"h3"}}),se=new w({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycy5hZ2VudHMlMjBpbXBvcnQlMjBIZkVuZ2luZSUyQyUyMFJlYWN0SnNvbkFnZW50JTJDJTIwbG9hZF90b29sJTBBJTBBbGxtX2VuZ2luZSUyMCUzRCUyMEhmRW5naW5lKCUyMm1ldGEtbGxhbWElMkZNZXRhLUxsYW1hLTMtNzBCLUluc3RydWN0JTIyKSUwQSUwQXJldHJpZXZlcl90b29sJTIwJTNEJTIwbG9hZF90b29sKCUyMm0tcmljJTJGcmV0cmlldmVyLXRvb2wlMjIlMkMlMjB2ZWN0b3JkYiUzRHZlY3RvcmRiJTJDJTIwYWxsX3NvdXJjZXMlM0RhbGxfc291cmNlcyklMEFhZ2VudCUyMCUzRCUyMFJlYWN0SnNvbkFnZW50KHRvb2xzJTNEJTVCcmV0cmlldmVyX3Rvb2wlNUQlMkMlMjBsbG1fZW5naW5lJTNEbGxtX2VuZ2luZSUyQyUyMHZlcmJvc2UlM0QwKSUwQSUwQWFnZW50X291dHB1dCUyMCUzRCUyMGFnZW50LnJ1biglMjJQbGVhc2UlMjBzaG93JTIwbWUlMjBhJTIwTE9SQSUyMGZpbmV0dW5pbmclMjBzY3JpcHQlMjIpJTBBJTBBcHJpbnQoJTIyRmluYWwlMjBvdXRwdXQlM0ElMjIpJTBBcHJpbnQoYWdlbnRfb3V0cHV0KQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers.agents <span class="hljs-keyword">import</span> HfEngine, ReactJsonAgent, load_tool

<span class="hljs-meta">&gt;&gt;&gt; </span>llm_engine = HfEngine(<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-70B-Instruct&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>retriever_tool = load_tool(<span class="hljs-string">&quot;m-ric/retriever-tool&quot;</span>, vectordb=vectordb, all_sources=all_sources)
<span class="hljs-meta">&gt;&gt;&gt; </span>agent = ReactJsonAgent(tools=[retriever_tool], llm_engine=llm_engine, verbose=<span class="hljs-number">0</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>agent_output = agent.run(<span class="hljs-string">&quot;Please show me a LORA finetuning script&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Final output:&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(agent_output)`,wrap:!1}}),Me=new J({props:{title:"3. 💻 Debug Python code",local:"3--debug-python-code",headingTag:"h2"}}),pe=new w({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFJlYWN0Q29kZUFnZW50JTBBJTBBYWdlbnQlMjAlM0QlMjBSZWFjdENvZGVBZ2VudCh0b29scyUzRCU1QiU1RCklMEElMEFjb2RlJTIwJTNEJTIwJTIyJTIyJTIyJTBBbGlzdCUzRCU1QjAlMkMlMjAxJTJDJTIwMiU1RCUwQSUwQWZvciUyMGklMjBpbiUyMHJhbmdlKDQpJTNBJTBBJTIwJTIwJTIwJTIwcHJpbnQobGlzdChpKSklMEElMjIlMjIlMjIlMEElMEFmaW5hbF9hbnN3ZXIlMjAlM0QlMjBhZ2VudC5ydW4oJTBBJTIwJTIwJTIwJTIwJTIySSUyMGhhdmUlMjBzb21lJTIwY29kZSUyMHRoYXQlMjBjcmVhdGVzJTIwYSUyMGJ1ZyUzQSUyMHBsZWFzZSUyMGRlYnVnJTIwaXQlMjBhbmQlMjByZXR1cm4lMjB0aGUlMjBmaW5hbCUyMGNvZGUlMjIlMkMlMEElMjAlMjAlMjAlMjBjb2RlJTNEY29kZSUyQyUwQSk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> ReactCodeAgent

agent = ReactCodeAgent(tools=[])

code = <span class="hljs-string">&quot;&quot;&quot;
list=[0, 1, 2]

for i in range(4):
    print(list(i))
&quot;&quot;&quot;</span>

final_answer = agent.run(
    <span class="hljs-string">&quot;I have some code that creates a bug: please debug it and return the final code&quot;</span>,
    code=code,
)`,wrap:!1}}),ue=new w({props:{code:"cHJpbnQoZmluYWxfYW5zd2VyKQ==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(final_answer)',wrap:!1}}),we=new J({props:{title:"4. Create your own LLM engine (OpenAI)",local:"4-create-your-own-llm-engine-openai",headingTag:"h2"}}),he=new w({props:{code:"aW1wb3J0JTIwb3MlMEFmcm9tJTIwb3BlbmFpJTIwaW1wb3J0JTIwT3BlbkFJJTBBZnJvbSUyMHRyYW5zZm9ybWVycy5hZ2VudHMubGxtX2VuZ2luZSUyMGltcG9ydCUyME1lc3NhZ2VSb2xlJTJDJTIwZ2V0X2NsZWFuX21lc3NhZ2VfbGlzdCUwQSUwQW9wZW5haV9yb2xlX2NvbnZlcnNpb25zJTIwJTNEJTIwJTdCJTBBJTIwJTIwJTIwJTIwTWVzc2FnZVJvbGUuVE9PTF9SRVNQT05TRSUzQSUyMCUyMnVzZXIlMjIlMkMlMEElN0QlMEElMEElMEFjbGFzcyUyME9wZW5BSUVuZ2luZSUzQSUwQSUyMCUyMCUyMCUyMGRlZiUyMF9faW5pdF9fKHNlbGYlMkMlMjBtb2RlbF9uYW1lJTNEJTIyZ3B0LTRvLTIwMjQtMDUtMTMlMjIpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5tb2RlbF9uYW1lJTIwJTNEJTIwbW9kZWxfbmFtZSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYuY2xpZW50JTIwJTNEJTIwT3BlbkFJKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGFwaV9rZXklM0Rvcy5nZXRlbnYoJTIyT1BFTkFJX0FQSV9LRVklMjIpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUwQSUwQSUyMCUyMCUyMCUyMGRlZiUyMF9fY2FsbF9fKHNlbGYlMkMlMjBtZXNzYWdlcyUyQyUyMHN0b3Bfc2VxdWVuY2VzJTNEJTVCJTVEKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMEdldCUyMGNsZWFuJTIwbWVzc2FnZSUyMGxpc3QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtZXNzYWdlcyUyMCUzRCUyMGdldF9jbGVhbl9tZXNzYWdlX2xpc3QobWVzc2FnZXMlMkMlMjByb2xlX2NvbnZlcnNpb25zJTNEb3BlbmFpX3JvbGVfY29udmVyc2lvbnMpJTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwR2V0JTIwTExNJTIwb3V0cHV0JTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmVzcG9uc2UlMjAlM0QlMjBzZWxmLmNsaWVudC5jaGF0LmNvbXBsZXRpb25zLmNyZWF0ZSglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtb2RlbCUzRHNlbGYubW9kZWxfbmFtZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG1lc3NhZ2VzJTNEbWVzc2FnZXMlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzdG9wJTNEc3RvcF9zZXF1ZW5jZXMlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwcmVzcG9uc2UuY2hvaWNlcyU1QjAlNUQubWVzc2FnZS5jb250ZW50JTBBJTBBJTBBb3BlbmFpX2VuZ2luZSUyMCUzRCUyME9wZW5BSUVuZ2luZSgpJTBBYWdlbnQlMjAlM0QlMjBSZWFjdENvZGVBZ2VudChsbG1fZW5naW5lJTNEb3BlbmFpX2VuZ2luZSUyQyUyMHRvb2xzJTNEJTVCJTVEKSUwQSUwQWNvZGUlMjAlM0QlMjAlMjIlMjIlMjIlMEFsaXN0JTNEJTVCMCUyQyUyMDElMkMlMjAyJTVEJTBBJTBBZm9yJTIwaSUyMGluJTIwcmFuZ2UoNCklM0ElMEElMjAlMjAlMjAlMjBwcmludChsaXN0KGkpKSUwQSUyMiUyMiUyMiUwQSUwQWZpbmFsX2Fuc3dlciUyMCUzRCUyMGFnZW50LnJ1biglMEElMjAlMjAlMjAlMjAlMjJJJTIwaGF2ZSUyMHNvbWUlMjBjb2RlJTIwdGhhdCUyMGNyZWF0ZXMlMjBhJTIwYnVnJTNBJTIwcGxlYXNlJTIwZGVidWclMjBpdCUyMGFuZCUyMHJldHVybiUyMHRoZSUyMGZpbmFsJTIwY29kZSUyMiUyQyUwQSUyMCUyMCUyMCUyMGNvZGUlM0Rjb2RlJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">from</span> openai <span class="hljs-keyword">import</span> OpenAI
<span class="hljs-keyword">from</span> transformers.agents.llm_engine <span class="hljs-keyword">import</span> MessageRole, get_clean_message_list

openai_role_conversions = {
    MessageRole.TOOL_RESPONSE: <span class="hljs-string">&quot;user&quot;</span>,
}


<span class="hljs-keyword">class</span> <span class="hljs-title class_">OpenAIEngine</span>:
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, model_name=<span class="hljs-string">&quot;gpt-4o-2024-05-13&quot;</span></span>):
        self.model_name = model_name
        self.client = OpenAI(
            api_key=os.getenv(<span class="hljs-string">&quot;OPENAI_API_KEY&quot;</span>),
        )

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__call__</span>(<span class="hljs-params">self, messages, stop_sequences=[]</span>):
        <span class="hljs-comment"># Get clean message list</span>
        messages = get_clean_message_list(messages, role_conversions=openai_role_conversions)

        <span class="hljs-comment"># Get LLM output</span>
        response = self.client.chat.completions.create(
            model=self.model_name,
            messages=messages,
            stop=stop_sequences,
        )
        <span class="hljs-keyword">return</span> response.choices[<span class="hljs-number">0</span>].message.content


openai_engine = OpenAIEngine()
agent = ReactCodeAgent(llm_engine=openai_engine, tools=[])

code = <span class="hljs-string">&quot;&quot;&quot;
list=[0, 1, 2]

for i in range(4):
    print(list(i))
&quot;&quot;&quot;</span>

final_answer = agent.run(
    <span class="hljs-string">&quot;I have some code that creates a bug: please debug it and return the final code&quot;</span>,
    code=code,
)`,wrap:!1}}),Te=new w({props:{code:"cHJpbnQoZmluYWxfYW5zd2VyKQ==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(final_answer)',wrap:!1}}),de=new J({props:{title:"➡️ Conclusion",local:"-conclusion",headingTag:"h2"}}),Ie=new Al({props:{source:"https://github.com/huggingface/cookbook/blob/main/notebooks/en/agents.md"}}),{c(){j=o("meta"),Be=n(),Ce=o("p"),ve=n(),r(h.$$.fragment),Ge=n(),r(T.$$.fragment),We=n(),U=o("p"),U.innerHTML=Qt,ke=n(),d=o("p"),d.innerHTML=Et,Ae=n(),b=o("p"),b.innerHTML=Xt,Re=n(),g=o("p"),g.innerHTML=qt,_e=n(),f=o("p"),f.innerHTML=xt,Ve=n(),I=o("p"),I.textContent=Yt,Ne=n(),C=o("p"),C.innerHTML=Ht,$e=n(),r(Z.$$.fragment),Se=n(),r(B.$$.fragment),Qe=n(),r(v.$$.fragment),Ee=n(),G=o("p"),G.textContent=zt,Xe=n(),W=o("p"),W.textContent=Ft,qe=n(),k=o("ul"),k.innerHTML=Lt,xe=n(),r(A.$$.fragment),Ye=n(),r(R.$$.fragment),He=n(),r(_.$$.fragment),ze=n(),V=o("p"),V.innerHTML=Pt,Fe=n(),r(N.$$.fragment),Le=n(),$=o("p"),$.innerHTML=Kt,Pe=n(),S=o("p"),S.textContent=Dt,Ke=n(),Q=o("ul"),Q.innerHTML=Ot,De=n(),E=o("p"),E.innerHTML=el,Oe=n(),X=o("p"),X.innerHTML=tl,et=n(),r(q.$$.fragment),tt=n(),x=o("p"),x.textContent=ll,lt=n(),r(Y.$$.fragment),st=n(),H=o("p"),H.textContent=sl,nt=n(),z=o("p"),z.textContent=nl,at=n(),F=o("p"),F.textContent=al,ot=n(),r(L.$$.fragment),it=n(),P=o("pre"),P.textContent=ol,Mt=n(),r(K.$$.fragment),rt=n(),r(D.$$.fragment),pt=n(),O=o("p"),O.innerHTML=il,yt=n(),ee=o("p"),ee.innerHTML=Ml,ct=n(),r(te.$$.fragment),ut=n(),r(le.$$.fragment),mt=n(),r(se.$$.fragment),wt=n(),ne=o("pre"),ne.textContent=rl,jt=n(),ae=o("p"),ae.innerHTML=pl,Jt=n(),oe=o("p"),oe.textContent=yl,ht=n(),ie=o("p"),ie.innerHTML=cl,Tt=n(),r(Me.$$.fragment),Ut=n(),re=o("p"),re.textContent=ul,dt=n(),r(pe.$$.fragment),bt=n(),ye=o("p"),ye.textContent=ml,gt=n(),ce=o("p"),ce.textContent=wl,ft=n(),r(ue.$$.fragment),It=n(),me=o("pre"),me.textContent=jl,Ct=n(),r(we.$$.fragment),Zt=n(),je=o("p"),je.innerHTML=Jl,Bt=n(),Je=o("ol"),Je.innerHTML=hl,vt=n(),r(he.$$.fragment),Gt=n(),r(Te.$$.fragment),Wt=n(),Ue=o("pre"),Ue.textContent=Tl,kt=n(),r(de.$$.fragment),At=n(),be=o("p"),be.textContent=Ul,Rt=n(),ge=o("p"),ge.innerHTML=dl,_t=n(),fe=o("p"),fe.textContent=bl,Vt=n(),r(Ie.$$.fragment),Nt=n(),Ze=o("p"),this.h()},l(e){const t=Gl("svelte-u9bgzb",document.head);j=i(t,"META",{name:!0,content:!0}),t.forEach(l),Be=a(e),Ce=i(e,"P",{}),gl(Ce).forEach(l),ve=a(e),p(h.$$.fragment,e),Ge=a(e),p(T.$$.fragment,e),We=a(e),U=i(e,"P",{"data-svelte-h":!0}),M(U)!=="svelte-1xlqnsv"&&(U.innerHTML=Qt),ke=a(e),d=i(e,"P",{"data-svelte-h":!0}),M(d)!=="svelte-qt5igr"&&(d.innerHTML=Et),Ae=a(e),b=i(e,"P",{"data-svelte-h":!0}),M(b)!=="svelte-1mh34dv"&&(b.innerHTML=Xt),Re=a(e),g=i(e,"P",{"data-svelte-h":!0}),M(g)!=="svelte-mmy9qo"&&(g.innerHTML=qt),_e=a(e),f=i(e,"P",{"data-svelte-h":!0}),M(f)!=="svelte-176yg59"&&(f.innerHTML=xt),Ve=a(e),I=i(e,"P",{"data-svelte-h":!0}),M(I)!=="svelte-fc6q9b"&&(I.textContent=Yt),Ne=a(e),C=i(e,"P",{"data-svelte-h":!0}),M(C)!=="svelte-psgh4s"&&(C.innerHTML=Ht),$e=a(e),p(Z.$$.fragment,e),Se=a(e),p(B.$$.fragment,e),Qe=a(e),p(v.$$.fragment,e),Ee=a(e),G=i(e,"P",{"data-svelte-h":!0}),M(G)!=="svelte-1354tpb"&&(G.textContent=zt),Xe=a(e),W=i(e,"P",{"data-svelte-h":!0}),M(W)!=="svelte-1yb5yrl"&&(W.textContent=Ft),qe=a(e),k=i(e,"UL",{"data-svelte-h":!0}),M(k)!=="svelte-1dqrk95"&&(k.innerHTML=Lt),xe=a(e),p(A.$$.fragment,e),Ye=a(e),p(R.$$.fragment,e),He=a(e),p(_.$$.fragment,e),ze=a(e),V=i(e,"P",{"data-svelte-h":!0}),M(V)!=="svelte-1hg95q8"&&(V.innerHTML=Pt),Fe=a(e),p(N.$$.fragment,e),Le=a(e),$=i(e,"P",{"data-svelte-h":!0}),M($)!=="svelte-1wknlb6"&&($.innerHTML=Kt),Pe=a(e),S=i(e,"P",{"data-svelte-h":!0}),M(S)!=="svelte-19h5931"&&(S.textContent=Dt),Ke=a(e),Q=i(e,"UL",{"data-svelte-h":!0}),M(Q)!=="svelte-5uub6"&&(Q.innerHTML=Ot),De=a(e),E=i(e,"P",{"data-svelte-h":!0}),M(E)!=="svelte-1kfx2et"&&(E.innerHTML=el),Oe=a(e),X=i(e,"P",{"data-svelte-h":!0}),M(X)!=="svelte-1qw64fs"&&(X.innerHTML=tl),et=a(e),p(q.$$.fragment,e),tt=a(e),x=i(e,"P",{"data-svelte-h":!0}),M(x)!=="svelte-jy4i2f"&&(x.textContent=ll),lt=a(e),p(Y.$$.fragment,e),st=a(e),H=i(e,"P",{"data-svelte-h":!0}),M(H)!=="svelte-5pp8py"&&(H.textContent=sl),nt=a(e),z=i(e,"P",{"data-svelte-h":!0}),M(z)!=="svelte-1cx88lu"&&(z.textContent=nl),at=a(e),F=i(e,"P",{"data-svelte-h":!0}),M(F)!=="svelte-1vgfwws"&&(F.textContent=al),ot=a(e),p(L.$$.fragment,e),it=a(e),P=i(e,"PRE",{"data-svelte-h":!0}),M(P)!=="svelte-87x3d8"&&(P.textContent=ol),Mt=a(e),p(K.$$.fragment,e),rt=a(e),p(D.$$.fragment,e),pt=a(e),O=i(e,"P",{"data-svelte-h":!0}),M(O)!=="svelte-19hckuz"&&(O.innerHTML=il),yt=a(e),ee=i(e,"P",{"data-svelte-h":!0}),M(ee)!=="svelte-1wpkyax"&&(ee.innerHTML=Ml),ct=a(e),p(te.$$.fragment,e),ut=a(e),p(le.$$.fragment,e),mt=a(e),p(se.$$.fragment,e),wt=a(e),ne=i(e,"PRE",{"data-svelte-h":!0}),M(ne)!=="svelte-l44zt6"&&(ne.textContent=rl),jt=a(e),ae=i(e,"P",{"data-svelte-h":!0}),M(ae)!=="svelte-6d9ubm"&&(ae.innerHTML=pl),Jt=a(e),oe=i(e,"P",{"data-svelte-h":!0}),M(oe)!=="svelte-ud3g55"&&(oe.textContent=yl),ht=a(e),ie=i(e,"P",{"data-svelte-h":!0}),M(ie)!=="svelte-3qqlok"&&(ie.innerHTML=cl),Tt=a(e),p(Me.$$.fragment,e),Ut=a(e),re=i(e,"P",{"data-svelte-h":!0}),M(re)!=="svelte-5kn15r"&&(re.textContent=ul),dt=a(e),p(pe.$$.fragment,e),bt=a(e),ye=i(e,"P",{"data-svelte-h":!0}),M(ye)!=="svelte-168ebuv"&&(ye.textContent=ml),gt=a(e),ce=i(e,"P",{"data-svelte-h":!0}),M(ce)!=="svelte-vscncs"&&(ce.textContent=wl),ft=a(e),p(ue.$$.fragment,e),It=a(e),me=i(e,"PRE",{"data-svelte-h":!0}),M(me)!=="svelte-1t45l4d"&&(me.textContent=jl),Ct=a(e),p(we.$$.fragment,e),Zt=a(e),je=i(e,"P",{"data-svelte-h":!0}),M(je)!=="svelte-6gn5q5"&&(je.innerHTML=Jl),Bt=a(e),Je=i(e,"OL",{"data-svelte-h":!0}),M(Je)!=="svelte-1o7lqh"&&(Je.innerHTML=hl),vt=a(e),p(he.$$.fragment,e),Gt=a(e),p(Te.$$.fragment,e),Wt=a(e),Ue=i(e,"PRE",{"data-svelte-h":!0}),M(Ue)!=="svelte-tgqz6q"&&(Ue.textContent=Tl),kt=a(e),p(de.$$.fragment,e),At=a(e),be=i(e,"P",{"data-svelte-h":!0}),M(be)!=="svelte-hpfue3"&&(be.textContent=Ul),Rt=a(e),ge=i(e,"P",{"data-svelte-h":!0}),M(ge)!=="svelte-1nxb7v"&&(ge.innerHTML=dl),_t=a(e),fe=i(e,"P",{"data-svelte-h":!0}),M(fe)!=="svelte-1ctcozl"&&(fe.textContent=bl),Vt=a(e),p(Ie.$$.fragment,e),Nt=a(e),Ze=i(e,"P",{}),gl(Ze).forEach(l),this.h()},h(){fl(j,"name","hf:doc:metadata"),fl(j,"content",_l)},m(e,t){Wl(document.head,j),s(e,Be,t),s(e,Ce,t),s(e,ve,t),y(h,e,t),s(e,Ge,t),y(T,e,t),s(e,We,t),s(e,U,t),s(e,ke,t),s(e,d,t),s(e,Ae,t),s(e,b,t),s(e,Re,t),s(e,g,t),s(e,_e,t),s(e,f,t),s(e,Ve,t),s(e,I,t),s(e,Ne,t),s(e,C,t),s(e,$e,t),y(Z,e,t),s(e,Se,t),y(B,e,t),s(e,Qe,t),y(v,e,t),s(e,Ee,t),s(e,G,t),s(e,Xe,t),s(e,W,t),s(e,qe,t),s(e,k,t),s(e,xe,t),y(A,e,t),s(e,Ye,t),y(R,e,t),s(e,He,t),y(_,e,t),s(e,ze,t),s(e,V,t),s(e,Fe,t),y(N,e,t),s(e,Le,t),s(e,$,t),s(e,Pe,t),s(e,S,t),s(e,Ke,t),s(e,Q,t),s(e,De,t),s(e,E,t),s(e,Oe,t),s(e,X,t),s(e,et,t),y(q,e,t),s(e,tt,t),s(e,x,t),s(e,lt,t),y(Y,e,t),s(e,st,t),s(e,H,t),s(e,nt,t),s(e,z,t),s(e,at,t),s(e,F,t),s(e,ot,t),y(L,e,t),s(e,it,t),s(e,P,t),s(e,Mt,t),y(K,e,t),s(e,rt,t),y(D,e,t),s(e,pt,t),s(e,O,t),s(e,yt,t),s(e,ee,t),s(e,ct,t),y(te,e,t),s(e,ut,t),y(le,e,t),s(e,mt,t),y(se,e,t),s(e,wt,t),s(e,ne,t),s(e,jt,t),s(e,ae,t),s(e,Jt,t),s(e,oe,t),s(e,ht,t),s(e,ie,t),s(e,Tt,t),y(Me,e,t),s(e,Ut,t),s(e,re,t),s(e,dt,t),y(pe,e,t),s(e,bt,t),s(e,ye,t),s(e,gt,t),s(e,ce,t),s(e,ft,t),y(ue,e,t),s(e,It,t),s(e,me,t),s(e,Ct,t),y(we,e,t),s(e,Zt,t),s(e,je,t),s(e,Bt,t),s(e,Je,t),s(e,vt,t),y(he,e,t),s(e,Gt,t),y(Te,e,t),s(e,Wt,t),s(e,Ue,t),s(e,kt,t),y(de,e,t),s(e,At,t),s(e,be,t),s(e,Rt,t),s(e,ge,t),s(e,_t,t),s(e,fe,t),s(e,Vt,t),y(Ie,e,t),s(e,Nt,t),s(e,Ze,t),$t=!0},p:Cl,i(e){$t||(c(h.$$.fragment,e),c(T.$$.fragment,e),c(Z.$$.fragment,e),c(B.$$.fragment,e),c(v.$$.fragment,e),c(A.$$.fragment,e),c(R.$$.fragment,e),c(_.$$.fragment,e),c(N.$$.fragment,e),c(q.$$.fragment,e),c(Y.$$.fragment,e),c(L.$$.fragment,e),c(K.$$.fragment,e),c(D.$$.fragment,e),c(te.$$.fragment,e),c(le.$$.fragment,e),c(se.$$.fragment,e),c(Me.$$.fragment,e),c(pe.$$.fragment,e),c(ue.$$.fragment,e),c(we.$$.fragment,e),c(he.$$.fragment,e),c(Te.$$.fragment,e),c(de.$$.fragment,e),c(Ie.$$.fragment,e),$t=!0)},o(e){u(h.$$.fragment,e),u(T.$$.fragment,e),u(Z.$$.fragment,e),u(B.$$.fragment,e),u(v.$$.fragment,e),u(A.$$.fragment,e),u(R.$$.fragment,e),u(_.$$.fragment,e),u(N.$$.fragment,e),u(q.$$.fragment,e),u(Y.$$.fragment,e),u(L.$$.fragment,e),u(K.$$.fragment,e),u(D.$$.fragment,e),u(te.$$.fragment,e),u(le.$$.fragment,e),u(se.$$.fragment,e),u(Me.$$.fragment,e),u(pe.$$.fragment,e),u(ue.$$.fragment,e),u(we.$$.fragment,e),u(he.$$.fragment,e),u(Te.$$.fragment,e),u(de.$$.fragment,e),u(Ie.$$.fragment,e),$t=!1},d(e){e&&(l(Be),l(Ce),l(ve),l(Ge),l(We),l(U),l(ke),l(d),l(Ae),l(b),l(Re),l(g),l(_e),l(f),l(Ve),l(I),l(Ne),l(C),l($e),l(Se),l(Qe),l(Ee),l(G),l(Xe),l(W),l(qe),l(k),l(xe),l(Ye),l(He),l(ze),l(V),l(Fe),l(Le),l($),l(Pe),l(S),l(Ke),l(Q),l(De),l(E),l(Oe),l(X),l(et),l(tt),l(x),l(lt),l(st),l(H),l(nt),l(z),l(at),l(F),l(ot),l(it),l(P),l(Mt),l(rt),l(pt),l(O),l(yt),l(ee),l(ct),l(ut),l(mt),l(wt),l(ne),l(jt),l(ae),l(Jt),l(oe),l(ht),l(ie),l(Tt),l(Ut),l(re),l(dt),l(bt),l(ye),l(gt),l(ce),l(ft),l(It),l(me),l(Ct),l(Zt),l(je),l(Bt),l(Je),l(vt),l(Gt),l(Wt),l(Ue),l(kt),l(At),l(be),l(Rt),l(ge),l(_t),l(fe),l(Vt),l(Nt),l(Ze)),l(j),m(h,e),m(T,e),m(Z,e),m(B,e),m(v,e),m(A,e),m(R,e),m(_,e),m(N,e),m(q,e),m(Y,e),m(L,e),m(K,e),m(D,e),m(te,e),m(le,e),m(se,e),m(Me,e),m(pe,e),m(ue,e),m(we,e),m(he,e),m(Te,e),m(de,e),m(Ie,e)}}}const _l='{"title":"Build an agent with tool-calling superpowers 🦸 using Transformers Agents","local":"build-an-agent-with-tool-calling-superpowers--using-transformers-agents","sections":[{"title":"1. 🏞️ Multimodal + 🌐 Web-browsing assistant","local":"1--multimodal---web-browsing-assistant","sections":[],"depth":2},{"title":"2. 📚💬 RAG with Iterative query refinement & Source selection","local":"2--rag-with-iterative-query-refinement--source-selection","sections":[{"title":"Optional: Share your Retriever tool to Hub","local":"optional-share-your-retriever-tool-to-hub","sections":[],"depth":3},{"title":"Run the agent!","local":"run-the-agent","sections":[],"depth":3}],"depth":2},{"title":"3. 💻 Debug Python code","local":"3--debug-python-code","sections":[],"depth":2},{"title":"4. Create your own LLM engine (OpenAI)","local":"4-create-your-own-llm-engine-openai","sections":[],"depth":2},{"title":"➡️ Conclusion","local":"-conclusion","sections":[],"depth":2}],"depth":1}';function Vl(St){return Zl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class El extends Bl{constructor(j){super(),vl(this,j,Vl,Rl,Il,{})}}export{El as component};
