import{s as ua,o as ba,n as Yl}from"../chunks/scheduler.8c3d61f6.js";import{S as ga,i as Ia,g as p,s as t,r as c,A as fa,h as M,f as a,c as n,j as da,u as m,x as o,k as Gs,y as Ca,a as e,v as j,d as y,t as r,w as h}from"../chunks/index.589a98e8.js";import{T as Rl}from"../chunks/Tip.42aa8582.js";import{C as J}from"../chunks/CodeBlock.36627b28.js";import{D as Aa}from"../chunks/DocNotebookDropdown.108e4998.js";import{H as Bs,E as Ba}from"../chunks/EditOnGithub.e5a8d9cb.js";function Za(d){let i,T='💡 This training tutorial is based on the <a href="https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers/training_example.ipynb" rel="nofollow">Training with 🧨 Diffusers</a> notebook. For additional details and context about diffusion models like how they work, check out the notebook!';return{c(){i=p("p"),i.innerHTML=T},l(w){i=M(w,"P",{"data-svelte-h":!0}),o(i)!=="svelte-mrih6e"&&(i.innerHTML=T)},m(w,U){e(w,i,U)},p:Yl,d(w){w&&a(i)}}}function Ga(d){let i,T='💡 You can find additional datasets from the <a href="https://huggingface.co/huggan" rel="nofollow">HugGan Community Event</a> or you can use your own dataset by creating a local <a href="https://huggingface.co/docs/datasets/image_dataset#imagefolder" rel="nofollow"><code>ImageFolder</code></a>. Set <code>config.dataset_name</code> to the repository id of the dataset if it is from the HugGan Community Event, or <code>imagefolder</code> if you’re using your own images.';return{c(){i=p("p"),i.innerHTML=T},l(w){i=M(w,"P",{"data-svelte-h":!0}),o(i)!=="svelte-1617s30"&&(i.innerHTML=T)},m(w,U){e(w,i,U)},p:Yl,d(w){w&&a(i)}}}function Xa(d){let i,T="💡 The training loop below may look intimidating and long, but it’ll be worth it later when you launch your training in just one line of code! If you can’t wait and want to start generating images, feel free to copy and run the code below. You can always come back and examine the training loop more closely later, like when you’re waiting for your model to finish training. 🤗";return{c(){i=p("p"),i.textContent=T},l(w){i=M(w,"P",{"data-svelte-h":!0}),o(i)!=="svelte-dstut0"&&(i.textContent=T)},m(w,U){e(w,i,U)},p:Yl,d(w){w&&a(i)}}}function Wa(d){let i,T,w,U,A,Xs,B,Ws,Z,zl='Unconditional image generation is a popular application of diffusion models that generates images that look like those in the dataset used for training. Typically, the best results are obtained from finetuning a pretrained model on a specific dataset. You can find many of these checkpoints on the <a href="https://huggingface.co/search/full-text?q=unconditional-image-generation&amp;type=model" rel="nofollow">Hub</a>, but if you can’t find one you like, you can always train your own!',ks,G,Ql='This tutorial will teach you how to train a <a href="/docs/diffusers/pr_8376/en/api/models/unet2d#diffusers.UNet2DModel">UNet2DModel</a> from scratch on a subset of the <a href="https://huggingface.co/datasets/huggan/smithsonian_butterflies_subset" rel="nofollow">Smithsonian Butterflies</a> dataset to generate your own 🦋 butterflies 🦋.',_s,u,vs,X,El='Before you begin, make sure you have 🤗 Datasets installed to load and preprocess image datasets, and 🤗 Accelerate, to simplify training on any number of GPUs. The following command will also install <a href="https://www.tensorflow.org/tensorboard" rel="nofollow">TensorBoard</a> to visualize training metrics (you can also use <a href="https://docs.wandb.ai/" rel="nofollow">Weights &amp; Biases</a> to track your training).',Vs,W,Ns,k,Fl='We encourage you to share your model with the community, and in order to do that, you’ll need to login to your Hugging Face account (create one <a href="https://hf.co/join" rel="nofollow">here</a> if you don’t already have one!). You can login from a notebook and enter your token when prompted. Make sure your token has the write role.',$s,_,Rs,v,Hl="Or login in from the terminal:",Ys,V,zs,N,Sl='Since the model checkpoints are quite large, install <a href="https://git-lfs.com/" rel="nofollow">Git-LFS</a> to version these large files:',Qs,$,Es,R,Fs,Y,xl="For convenience, create a <code>TrainingConfig</code> class containing the training hyperparameters (feel free to adjust them):",Hs,z,Ss,Q,xs,E,Dl='You can easily load the <a href="https://huggingface.co/datasets/huggan/smithsonian_butterflies_subset" rel="nofollow">Smithsonian Butterflies</a> dataset with the 🤗 Datasets library:',Ds,F,qs,b,Ls,H,ql='🤗 Datasets uses the <a href="https://huggingface.co/docs/datasets/main/en/package_reference/main_classes#datasets.Image" rel="nofollow">Image</a> feature to automatically decode the image data and load it as a <a href="https://pillow.readthedocs.io/en/stable/reference/Image.html" rel="nofollow"><code>PIL.Image</code></a> which we can visualize:',Ks,S,Ps,g,Ll='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/butterflies_ds.png"/>',Os,x,Kl="The images are all different sizes though, so you’ll need to preprocess them first:",sl,D,Pl="<li><code>Resize</code> changes the image size to the one defined in <code>config.image_size</code>.</li> <li><code>RandomHorizontalFlip</code> augments the dataset by randomly mirroring the images.</li> <li><code>Normalize</code> is important to rescale the pixel values into a [-1, 1] range, which is what the model expects.</li>",ll,q,al,L,Ol='Use 🤗 Datasets’ <a href="https://huggingface.co/docs/datasets/main/en/package_reference/main_classes#datasets.Dataset.set_transform" rel="nofollow">set_transform</a> method to apply the <code>preprocess</code> function on the fly during training:',el,K,tl,P,sa='Feel free to visualize the images again to confirm that they’ve been resized. Now you’re ready to wrap the dataset in a <a href="https://pytorch.org/docs/stable/data#torch.utils.data.DataLoader" rel="nofollow">DataLoader</a> for training!',nl,O,pl,ss,Ml,ls,la='Pretrained models in 🧨 Diffusers are easily created from their model class with the parameters you want. For example, to create a <a href="/docs/diffusers/pr_8376/en/api/models/unet2d#diffusers.UNet2DModel">UNet2DModel</a>:',il,as,ol,es,aa="It is often a good idea to quickly check the sample image shape matches the model output shape:",cl,ts,ml,ns,ea="Great! Next, you’ll need a scheduler to add some noise to the image.",jl,ps,yl,Ms,ta="The scheduler behaves differently depending on whether you’re using the model for training or inference. During inference, the scheduler generates image from the noise. During training, the scheduler takes a model output - or a sample - from a specific point in the diffusion process and applies noise to the image according to a <em>noise schedule</em> and an <em>update rule</em>.",rl,is,na='Let’s take a look at the <a href="/docs/diffusers/pr_8376/en/api/schedulers/ddpm#diffusers.DDPMScheduler">DDPMScheduler</a> and use the <code>add_noise</code> method to add some random noise to the <code>sample_image</code> from before:',hl,os,wl,I,pa='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/noisy_butterfly.png"/>',Jl,cs,Ma="The training objective of the model is to predict the noise added to the image. The loss at this step can be calculated by:",Tl,ms,Ul,js,dl,ys,ia="By now, you have most of the pieces to start training the model and all that’s left is putting everything together.",ul,rs,oa="First, you’ll need an optimizer and a learning rate scheduler:",bl,hs,gl,ws,ca='Then, you’ll need a way to evaluate the model. For evaluation, you can use the <a href="/docs/diffusers/pr_8376/en/api/pipelines/ddpm#diffusers.DDPMPipeline">DDPMPipeline</a> to generate a batch of sample images and save it as a grid:',Il,Js,fl,Ts,ma="Now you can wrap all these components together in a training loop with 🤗 Accelerate for easy TensorBoard logging, gradient accumulation, and mixed precision training. To upload the model to the Hub, write a function to get your repository name and information and then push it to the Hub.",Cl,f,Al,Us,Bl,ds,ja='Phew, that was quite a bit of code! But you’re finally ready to launch the training with 🤗 Accelerate’s <a href="https://huggingface.co/docs/accelerate/main/en/package_reference/launchers#accelerate.notebook_launcher" rel="nofollow">notebook_launcher</a> function. Pass the function the training loop, all the training arguments, and the number of processes (you can change this value to the number of GPUs available to you) to use for training:',Zl,us,Gl,bs,ya="Once training is complete, take a look at the final 🦋 images 🦋 generated by your diffusion model!",Xl,gs,Wl,C,ra='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/butterflies_final.png"/>',kl,Is,_l,fs,ha='Unconditional image generation is one example of a task that can be trained. You can explore other tasks and training techniques by visiting the <a href="../training/overview">🧨 Diffusers Training Examples</a> page. Here are some examples of what you can learn:',vl,Cs,wa='<li><a href="../training/text_inversion">Textual Inversion</a>, an algorithm that teaches a model a specific visual concept and integrates it into the generated image.</li> <li><a href="../training/dreambooth">DreamBooth</a>, a technique for generating personalized images of a subject given several input images of the subject.</li> <li><a href="../training/text2image">Guide</a> to finetuning a Stable Diffusion model on your own dataset.</li> <li><a href="../training/lora">Guide</a> to using LoRA, a memory-efficient technique for finetuning really large models faster.</li>',Vl,As,Nl,Zs,$l;return A=new Aa({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/basic_training.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/basic_training.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/basic_training.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/basic_training.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/basic_training.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/basic_training.ipynb"}]}}),B=new Bs({props:{title:"Train a diffusion model",local:"train-a-diffusion-model",headingTag:"h1"}}),u=new Rl({props:{$$slots:{default:[Za]},$$scope:{ctx:d}}}),W=new J({props:{code:"JTIzJTIwdW5jb21tZW50JTIwdG8lMjBpbnN0YWxsJTIwdGhlJTIwbmVjZXNzYXJ5JTIwbGlicmFyaWVzJTIwaW4lMjBDb2xhYiUwQSUyMyFwaXAlMjBpbnN0YWxsJTIwZGlmZnVzZXJzJTVCdHJhaW5pbmclNUQ=",highlighted:`<span class="hljs-comment"># uncomment to install the necessary libraries in Colab</span>
<span class="hljs-comment">#!pip install diffusers[training]</span>`,wrap:!1}}),_=new J({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBJTBBbm90ZWJvb2tfbG9naW4oKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login

<span class="hljs-meta">&gt;&gt;&gt; </span>notebook_login()`,wrap:!1}}),V=new J({props:{code:"aHVnZ2luZ2ZhY2UtY2xpJTIwbG9naW4=",highlighted:"huggingface-cli login",wrap:!1}}),$=new J({props:{code:"IXN1ZG8lMjBhcHQlMjAtcXElMjBpbnN0YWxsJTIwZ2l0LWxmcyUwQSFnaXQlMjBjb25maWclMjAtLWdsb2JhbCUyMGNyZWRlbnRpYWwuaGVscGVyJTIwc3RvcmU=",highlighted:`!sudo apt -qq install git-lfs
!git config --global credential.helper store`,wrap:!1}}),R=new Bs({props:{title:"Training configuration",local:"training-configuration",headingTag:"h2"}}),z=new J({props:{code:"ZnJvbSUyMGRhdGFjbGFzc2VzJTIwaW1wb3J0JTIwZGF0YWNsYXNzJTBBJTBBJTQwZGF0YWNsYXNzJTBBY2xhc3MlMjBUcmFpbmluZ0NvbmZpZyUzQSUwQSUyMCUyMCUyMCUyMGltYWdlX3NpemUlMjAlM0QlMjAxMjglMjAlMjAlMjMlMjB0aGUlMjBnZW5lcmF0ZWQlMjBpbWFnZSUyMHJlc29sdXRpb24lMEElMjAlMjAlMjAlMjB0cmFpbl9iYXRjaF9zaXplJTIwJTNEJTIwMTYlMEElMjAlMjAlMjAlMjBldmFsX2JhdGNoX3NpemUlMjAlM0QlMjAxNiUyMCUyMCUyMyUyMGhvdyUyMG1hbnklMjBpbWFnZXMlMjB0byUyMHNhbXBsZSUyMGR1cmluZyUyMGV2YWx1YXRpb24lMEElMjAlMjAlMjAlMjBudW1fZXBvY2hzJTIwJTNEJTIwNTAlMEElMjAlMjAlMjAlMjBncmFkaWVudF9hY2N1bXVsYXRpb25fc3RlcHMlMjAlM0QlMjAxJTBBJTIwJTIwJTIwJTIwbGVhcm5pbmdfcmF0ZSUyMCUzRCUyMDFlLTQlMEElMjAlMjAlMjAlMjBscl93YXJtdXBfc3RlcHMlMjAlM0QlMjA1MDAlMEElMjAlMjAlMjAlMjBzYXZlX2ltYWdlX2Vwb2NocyUyMCUzRCUyMDEwJTBBJTIwJTIwJTIwJTIwc2F2ZV9tb2RlbF9lcG9jaHMlMjAlM0QlMjAzMCUwQSUyMCUyMCUyMCUyMG1peGVkX3ByZWNpc2lvbiUyMCUzRCUyMCUyMmZwMTYlMjIlMjAlMjAlMjMlMjAlNjBubyU2MCUyMGZvciUyMGZsb2F0MzIlMkMlMjAlNjBmcDE2JTYwJTIwZm9yJTIwYXV0b21hdGljJTIwbWl4ZWQlMjBwcmVjaXNpb24lMEElMjAlMjAlMjAlMjBvdXRwdXRfZGlyJTIwJTNEJTIwJTIyZGRwbS1idXR0ZXJmbGllcy0xMjglMjIlMjAlMjAlMjMlMjB0aGUlMjBtb2RlbCUyMG5hbWUlMjBsb2NhbGx5JTIwYW5kJTIwb24lMjB0aGUlMjBIRiUyMEh1YiUwQSUwQSUyMCUyMCUyMCUyMHB1c2hfdG9faHViJTIwJTNEJTIwVHJ1ZSUyMCUyMCUyMyUyMHdoZXRoZXIlMjB0byUyMHVwbG9hZCUyMHRoZSUyMHNhdmVkJTIwbW9kZWwlMjB0byUyMHRoZSUyMEhGJTIwSHViJTBBJTIwJTIwJTIwJTIwaHViX21vZGVsX2lkJTIwJTNEJTIwJTIyJTNDeW91ci11c2VybmFtZSUzRSUyRiUzQ215LWF3ZXNvbWUtbW9kZWwlM0UlMjIlMjAlMjAlMjMlMjB0aGUlMjBuYW1lJTIwb2YlMjB0aGUlMjByZXBvc2l0b3J5JTIwdG8lMjBjcmVhdGUlMjBvbiUyMHRoZSUyMEhGJTIwSHViJTBBJTIwJTIwJTIwJTIwaHViX3ByaXZhdGVfcmVwbyUyMCUzRCUyMEZhbHNlJTBBJTIwJTIwJTIwJTIwb3ZlcndyaXRlX291dHB1dF9kaXIlMjAlM0QlMjBUcnVlJTIwJTIwJTIzJTIwb3ZlcndyaXRlJTIwdGhlJTIwb2xkJTIwbW9kZWwlMjB3aGVuJTIwcmUtcnVubmluZyUyMHRoZSUyMG5vdGVib29rJTBBJTIwJTIwJTIwJTIwc2VlZCUyMCUzRCUyMDAlMEElMEElMEFjb25maWclMjAlM0QlMjBUcmFpbmluZ0NvbmZpZygp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> dataclasses <span class="hljs-keyword">import</span> dataclass

<span class="hljs-meta">&gt;&gt;&gt; </span>@dataclass
<span class="hljs-meta">... </span><span class="hljs-keyword">class</span> <span class="hljs-title class_">TrainingConfig</span>:
<span class="hljs-meta">... </span>    image_size = <span class="hljs-number">128</span>  <span class="hljs-comment"># the generated image resolution</span>
<span class="hljs-meta">... </span>    train_batch_size = <span class="hljs-number">16</span>
<span class="hljs-meta">... </span>    eval_batch_size = <span class="hljs-number">16</span>  <span class="hljs-comment"># how many images to sample during evaluation</span>
<span class="hljs-meta">... </span>    num_epochs = <span class="hljs-number">50</span>
<span class="hljs-meta">... </span>    gradient_accumulation_steps = <span class="hljs-number">1</span>
<span class="hljs-meta">... </span>    learning_rate = <span class="hljs-number">1e-4</span>
<span class="hljs-meta">... </span>    lr_warmup_steps = <span class="hljs-number">500</span>
<span class="hljs-meta">... </span>    save_image_epochs = <span class="hljs-number">10</span>
<span class="hljs-meta">... </span>    save_model_epochs = <span class="hljs-number">30</span>
<span class="hljs-meta">... </span>    mixed_precision = <span class="hljs-string">&quot;fp16&quot;</span>  <span class="hljs-comment"># \`no\` for float32, \`fp16\` for automatic mixed precision</span>
<span class="hljs-meta">... </span>    output_dir = <span class="hljs-string">&quot;ddpm-butterflies-128&quot;</span>  <span class="hljs-comment"># the model name locally and on the HF Hub</span>

<span class="hljs-meta">... </span>    push_to_hub = <span class="hljs-literal">True</span>  <span class="hljs-comment"># whether to upload the saved model to the HF Hub</span>
<span class="hljs-meta">... </span>    hub_model_id = <span class="hljs-string">&quot;&lt;your-username&gt;/&lt;my-awesome-model&gt;&quot;</span>  <span class="hljs-comment"># the name of the repository to create on the HF Hub</span>
<span class="hljs-meta">... </span>    hub_private_repo = <span class="hljs-literal">False</span>
<span class="hljs-meta">... </span>    overwrite_output_dir = <span class="hljs-literal">True</span>  <span class="hljs-comment"># overwrite the old model when re-running the notebook</span>
<span class="hljs-meta">... </span>    seed = <span class="hljs-number">0</span>


<span class="hljs-meta">&gt;&gt;&gt; </span>config = TrainingConfig()`,wrap:!1}}),Q=new Bs({props:{title:"Load the dataset",local:"load-the-dataset",headingTag:"h2"}}),F=new J({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBY29uZmlnLmRhdGFzZXRfbmFtZSUyMCUzRCUyMCUyMmh1Z2dhbiUyRnNtaXRoc29uaWFuX2J1dHRlcmZsaWVzX3N1YnNldCUyMiUwQWRhdGFzZXQlMjAlM0QlMjBsb2FkX2RhdGFzZXQoY29uZmlnLmRhdGFzZXRfbmFtZSUyQyUyMHNwbGl0JTNEJTIydHJhaW4lMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>config.dataset_name = <span class="hljs-string">&quot;huggan/smithsonian_butterflies_subset&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(config.dataset_name, split=<span class="hljs-string">&quot;train&quot;</span>)`,wrap:!1}}),b=new Rl({props:{$$slots:{default:[Ga]},$$scope:{ctx:d}}}),S=new J({props:{code:"aW1wb3J0JTIwbWF0cGxvdGxpYi5weXBsb3QlMjBhcyUyMHBsdCUwQSUwQWZpZyUyQyUyMGF4cyUyMCUzRCUyMHBsdC5zdWJwbG90cygxJTJDJTIwNCUyQyUyMGZpZ3NpemUlM0QoMTYlMkMlMjA0KSklMEFmb3IlMjBpJTJDJTIwaW1hZ2UlMjBpbiUyMGVudW1lcmF0ZShkYXRhc2V0JTVCJTNBNCU1RCU1QiUyMmltYWdlJTIyJTVEKSUzQSUwQSUyMCUyMCUyMCUyMGF4cyU1QmklNUQuaW1zaG93KGltYWdlKSUwQSUyMCUyMCUyMCUyMGF4cyU1QmklNUQuc2V0X2F4aXNfb2ZmKCklMEFmaWcuc2hvdygp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> matplotlib.pyplot <span class="hljs-keyword">as</span> plt

<span class="hljs-meta">&gt;&gt;&gt; </span>fig, axs = plt.subplots(<span class="hljs-number">1</span>, <span class="hljs-number">4</span>, figsize=(<span class="hljs-number">16</span>, <span class="hljs-number">4</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i, image <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(dataset[:<span class="hljs-number">4</span>][<span class="hljs-string">&quot;image&quot;</span>]):
<span class="hljs-meta">... </span>    axs[i].imshow(image)
<span class="hljs-meta">... </span>    axs[i].set_axis_off()
<span class="hljs-meta">&gt;&gt;&gt; </span>fig.show()`,wrap:!1}}),q=new J({props:{code:"ZnJvbSUyMHRvcmNodmlzaW9uJTIwaW1wb3J0JTIwdHJhbnNmb3JtcyUwQSUwQXByZXByb2Nlc3MlMjAlM0QlMjB0cmFuc2Zvcm1zLkNvbXBvc2UoJTBBJTIwJTIwJTIwJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdHJhbnNmb3Jtcy5SZXNpemUoKGNvbmZpZy5pbWFnZV9zaXplJTJDJTIwY29uZmlnLmltYWdlX3NpemUpKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRyYW5zZm9ybXMuUmFuZG9tSG9yaXpvbnRhbEZsaXAoKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRyYW5zZm9ybXMuVG9UZW5zb3IoKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRyYW5zZm9ybXMuTm9ybWFsaXplKCU1QjAuNSU1RCUyQyUyMCU1QjAuNSU1RCklMkMlMEElMjAlMjAlMjAlMjAlNUQlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> torchvision <span class="hljs-keyword">import</span> transforms

<span class="hljs-meta">&gt;&gt;&gt; </span>preprocess = transforms.Compose(
<span class="hljs-meta">... </span>    [
<span class="hljs-meta">... </span>        transforms.Resize((config.image_size, config.image_size)),
<span class="hljs-meta">... </span>        transforms.RandomHorizontalFlip(),
<span class="hljs-meta">... </span>        transforms.ToTensor(),
<span class="hljs-meta">... </span>        transforms.Normalize([<span class="hljs-number">0.5</span>], [<span class="hljs-number">0.5</span>]),
<span class="hljs-meta">... </span>    ]
<span class="hljs-meta">... </span>)`,wrap:!1}}),K=new J({props:{code:"ZGVmJTIwdHJhbnNmb3JtKGV4YW1wbGVzKSUzQSUwQSUyMCUyMCUyMCUyMGltYWdlcyUyMCUzRCUyMCU1QnByZXByb2Nlc3MoaW1hZ2UuY29udmVydCglMjJSR0IlMjIpKSUyMGZvciUyMGltYWdlJTIwaW4lMjBleGFtcGxlcyU1QiUyMmltYWdlJTIyJTVEJTVEJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTdCJTIyaW1hZ2VzJTIyJTNBJTIwaW1hZ2VzJTdEJTBBJTBBJTBBZGF0YXNldC5zZXRfdHJhbnNmb3JtKHRyYW5zZm9ybSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">transform</span>(<span class="hljs-params">examples</span>):
<span class="hljs-meta">... </span>    images = [preprocess(image.convert(<span class="hljs-string">&quot;RGB&quot;</span>)) <span class="hljs-keyword">for</span> image <span class="hljs-keyword">in</span> examples[<span class="hljs-string">&quot;image&quot;</span>]]
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;images&quot;</span>: images}


<span class="hljs-meta">&gt;&gt;&gt; </span>dataset.set_transform(transform)`,wrap:!1}}),O=new J({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEF0cmFpbl9kYXRhbG9hZGVyJTIwJTNEJTIwdG9yY2gudXRpbHMuZGF0YS5EYXRhTG9hZGVyKGRhdGFzZXQlMkMlMjBiYXRjaF9zaXplJTNEY29uZmlnLnRyYWluX2JhdGNoX3NpemUlMkMlMjBzaHVmZmxlJTNEVHJ1ZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>train_dataloader = torch.utils.data.DataLoader(dataset, batch_size=config.train_batch_size, shuffle=<span class="hljs-literal">True</span>)`,wrap:!1}}),ss=new Bs({props:{title:"Create a UNet2DModel",local:"create-a-unet2dmodel",headingTag:"h2"}}),as=new J({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> UNet2DModel

<span class="hljs-meta">&gt;&gt;&gt; </span>model = UNet2DModel(
<span class="hljs-meta">... </span>    sample_size=config.image_size,  <span class="hljs-comment"># the target image resolution</span>
<span class="hljs-meta">... </span>    in_channels=<span class="hljs-number">3</span>,  <span class="hljs-comment"># the number of input channels, 3 for RGB images</span>
<span class="hljs-meta">... </span>    out_channels=<span class="hljs-number">3</span>,  <span class="hljs-comment"># the number of output channels</span>
<span class="hljs-meta">... </span>    layers_per_block=<span class="hljs-number">2</span>,  <span class="hljs-comment"># how many ResNet layers to use per UNet block</span>
<span class="hljs-meta">... </span>    block_out_channels=(<span class="hljs-number">128</span>, <span class="hljs-number">128</span>, <span class="hljs-number">256</span>, <span class="hljs-number">256</span>, <span class="hljs-number">512</span>, <span class="hljs-number">512</span>),  <span class="hljs-comment"># the number of output channels for each UNet block</span>
<span class="hljs-meta">... </span>    down_block_types=(
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;DownBlock2D&quot;</span>,  <span class="hljs-comment"># a regular ResNet downsampling block</span>
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;DownBlock2D&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;DownBlock2D&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;DownBlock2D&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;AttnDownBlock2D&quot;</span>,  <span class="hljs-comment"># a ResNet downsampling block with spatial self-attention</span>
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;DownBlock2D&quot;</span>,
<span class="hljs-meta">... </span>    ),
<span class="hljs-meta">... </span>    up_block_types=(
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;UpBlock2D&quot;</span>,  <span class="hljs-comment"># a regular ResNet upsampling block</span>
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;AttnUpBlock2D&quot;</span>,  <span class="hljs-comment"># a ResNet upsampling block with spatial self-attention</span>
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;UpBlock2D&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;UpBlock2D&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;UpBlock2D&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;UpBlock2D&quot;</span>,
<span class="hljs-meta">... </span>    ),
<span class="hljs-meta">... </span>)`,wrap:!1}}),ts=new J({props:{code:"c2FtcGxlX2ltYWdlJTIwJTNEJTIwZGF0YXNldCU1QjAlNUQlNUIlMjJpbWFnZXMlMjIlNUQudW5zcXVlZXplKDApJTBBcHJpbnQoJTIySW5wdXQlMjBzaGFwZSUzQSUyMiUyQyUyMHNhbXBsZV9pbWFnZS5zaGFwZSklMEElMEFwcmludCglMjJPdXRwdXQlMjBzaGFwZSUzQSUyMiUyQyUyMG1vZGVsKHNhbXBsZV9pbWFnZSUyQyUyMHRpbWVzdGVwJTNEMCkuc2FtcGxlLnNoYXBlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>sample_image = dataset[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;images&quot;</span>].unsqueeze(<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Input shape:&quot;</span>, sample_image.shape)
Input shape: torch.Size([<span class="hljs-number">1</span>, <span class="hljs-number">3</span>, <span class="hljs-number">128</span>, <span class="hljs-number">128</span>])

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Output shape:&quot;</span>, model(sample_image, timestep=<span class="hljs-number">0</span>).sample.shape)
Output shape: torch.Size([<span class="hljs-number">1</span>, <span class="hljs-number">3</span>, <span class="hljs-number">128</span>, <span class="hljs-number">128</span>])`,wrap:!1}}),ps=new Bs({props:{title:"Create a scheduler",local:"create-a-scheduler",headingTag:"h2"}}),os=new J({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRERQTVNjaGVkdWxlciUwQSUwQW5vaXNlX3NjaGVkdWxlciUyMCUzRCUyMEREUE1TY2hlZHVsZXIobnVtX3RyYWluX3RpbWVzdGVwcyUzRDEwMDApJTBBbm9pc2UlMjAlM0QlMjB0b3JjaC5yYW5kbihzYW1wbGVfaW1hZ2Uuc2hhcGUpJTBBdGltZXN0ZXBzJTIwJTNEJTIwdG9yY2guTG9uZ1RlbnNvciglNUI1MCU1RCklMEFub2lzeV9pbWFnZSUyMCUzRCUyMG5vaXNlX3NjaGVkdWxlci5hZGRfbm9pc2Uoc2FtcGxlX2ltYWdlJTJDJTIwbm9pc2UlMkMlMjB0aW1lc3RlcHMpJTBBJTBBSW1hZ2UuZnJvbWFycmF5KCgobm9pc3lfaW1hZ2UucGVybXV0ZSgwJTJDJTIwMiUyQyUyMDMlMkMlMjAxKSUyMCUyQiUyMDEuMCklMjAqJTIwMTI3LjUpLnR5cGUodG9yY2gudWludDgpLm51bXB5KCklNUIwJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DDPMScheduler

<span class="hljs-meta">&gt;&gt;&gt; </span>noise_scheduler = DDPMScheduler(num_train_timesteps=<span class="hljs-number">1000</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>noise = torch.randn(sample_image.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span>timesteps = torch.LongTensor([<span class="hljs-number">50</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>noisy_image = noise_scheduler.add_noise(sample_image, noise, timesteps)

<span class="hljs-meta">&gt;&gt;&gt; </span>Image.fromarray(((noisy_image.permute(<span class="hljs-number">0</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">1</span>) + <span class="hljs-number">1.0</span>) * <span class="hljs-number">127.5</span>).<span class="hljs-built_in">type</span>(torch.uint8).numpy()[<span class="hljs-number">0</span>])`,wrap:!1}}),ms=new J({props:{code:"aW1wb3J0JTIwdG9yY2gubm4uZnVuY3Rpb25hbCUyMGFzJTIwRiUwQSUwQW5vaXNlX3ByZWQlMjAlM0QlMjBtb2RlbChub2lzeV9pbWFnZSUyQyUyMHRpbWVzdGVwcykuc2FtcGxlJTBBbG9zcyUyMCUzRCUyMEYubXNlX2xvc3Mobm9pc2VfcHJlZCUyQyUyMG5vaXNlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch.nn.functional <span class="hljs-keyword">as</span> F

<span class="hljs-meta">&gt;&gt;&gt; </span>noise_pred = model(noisy_image, timesteps).sample
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = F.mse_loss(noise_pred, noise)`,wrap:!1}}),js=new Bs({props:{title:"Train the model",local:"train-the-model",headingTag:"h2"}}),hs=new J({props:{code:"ZnJvbSUyMGRpZmZ1c2Vycy5vcHRpbWl6YXRpb24lMjBpbXBvcnQlMjBnZXRfY29zaW5lX3NjaGVkdWxlX3dpdGhfd2FybXVwJTBBJTBBb3B0aW1pemVyJTIwJTNEJTIwdG9yY2gub3B0aW0uQWRhbVcobW9kZWwucGFyYW1ldGVycygpJTJDJTIwbHIlM0Rjb25maWcubGVhcm5pbmdfcmF0ZSklMEFscl9zY2hlZHVsZXIlMjAlM0QlMjBnZXRfY29zaW5lX3NjaGVkdWxlX3dpdGhfd2FybXVwKCUwQSUyMCUyMCUyMCUyMG9wdGltaXplciUzRG9wdGltaXplciUyQyUwQSUyMCUyMCUyMCUyMG51bV93YXJtdXBfc3RlcHMlM0Rjb25maWcubHJfd2FybXVwX3N0ZXBzJTJDJTBBJTIwJTIwJTIwJTIwbnVtX3RyYWluaW5nX3N0ZXBzJTNEKGxlbih0cmFpbl9kYXRhbG9hZGVyKSUyMColMjBjb25maWcubnVtX2Vwb2NocyklMkMlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.optimization <span class="hljs-keyword">import</span> get_cosine_schedule_with_warmup

<span class="hljs-meta">&gt;&gt;&gt; </span>optimizer = torch.optim.AdamW(model.parameters(), lr=config.learning_rate)
<span class="hljs-meta">&gt;&gt;&gt; </span>lr_scheduler = get_cosine_schedule_with_warmup(
<span class="hljs-meta">... </span>    optimizer=optimizer,
<span class="hljs-meta">... </span>    num_warmup_steps=config.lr_warmup_steps,
<span class="hljs-meta">... </span>    num_training_steps=(<span class="hljs-built_in">len</span>(train_dataloader) * config.num_epochs),
<span class="hljs-meta">... </span>)`,wrap:!1}}),Js=new J({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEREUE1QaXBlbGluZSUwQWZyb20lMjBkaWZmdXNlcnMudXRpbHMlMjBpbXBvcnQlMjBtYWtlX2ltYWdlX2dyaWQlMEFpbXBvcnQlMjBvcyUwQSUwQWRlZiUyMGV2YWx1YXRlKGNvbmZpZyUyQyUyMGVwb2NoJTJDJTIwcGlwZWxpbmUpJTNBJTBBJTIwJTIwJTIwJTIwJTIzJTIwU2FtcGxlJTIwc29tZSUyMGltYWdlcyUyMGZyb20lMjByYW5kb20lMjBub2lzZSUyMCh0aGlzJTIwaXMlMjB0aGUlMjBiYWNrd2FyZCUyMGRpZmZ1c2lvbiUyMHByb2Nlc3MpLiUwQSUyMCUyMCUyMCUyMCUyMyUyMFRoZSUyMGRlZmF1bHQlMjBwaXBlbGluZSUyMG91dHB1dCUyMHR5cGUlMjBpcyUyMCU2MExpc3QlNUJQSUwuSW1hZ2UlNUQlNjAlMEElMjAlMjAlMjAlMjBpbWFnZXMlMjAlM0QlMjBwaXBlbGluZSglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBiYXRjaF9zaXplJTNEY29uZmlnLmV2YWxfYmF0Y2hfc2l6ZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGdlbmVyYXRvciUzRHRvcmNoLkdlbmVyYXRvcihkZXZpY2UlM0QnY3B1JykubWFudWFsX3NlZWQoY29uZmlnLnNlZWQpJTJDJTIwJTIzJTIwVXNlJTIwYSUyMHNlcGFyYXRlJTIwdG9yY2glMjBnZW5lcmF0b3IlMjB0byUyMGF2b2lkJTIwcmV3aW5kaW5nJTIwdGhlJTIwcmFuZG9tJTIwc3RhdGUlMjBvZiUyMHRoZSUyMG1haW4lMjB0cmFpbmluZyUyMGxvb3AlMEElMjAlMjAlMjAlMjApLmltYWdlcyUwQSUwQSUyMCUyMCUyMCUyMCUyMyUyME1ha2UlMjBhJTIwZ3JpZCUyMG91dCUyMG9mJTIwdGhlJTIwaW1hZ2VzJTBBJTIwJTIwJTIwJTIwaW1hZ2VfZ3JpZCUyMCUzRCUyMG1ha2VfaW1hZ2VfZ3JpZChpbWFnZXMlMkMlMjByb3dzJTNENCUyQyUyMGNvbHMlM0Q0KSUwQSUwQSUyMCUyMCUyMCUyMCUyMyUyMFNhdmUlMjB0aGUlMjBpbWFnZXMlMEElMjAlMjAlMjAlMjB0ZXN0X2RpciUyMCUzRCUyMG9zLnBhdGguam9pbihjb25maWcub3V0cHV0X2RpciUyQyUyMCUyMnNhbXBsZXMlMjIpJTBBJTIwJTIwJTIwJTIwb3MubWFrZWRpcnModGVzdF9kaXIlMkMlMjBleGlzdF9vayUzRFRydWUpJTBBJTIwJTIwJTIwJTIwaW1hZ2VfZ3JpZC5zYXZlKGYlMjIlN0J0ZXN0X2RpciU3RCUyRiU3QmVwb2NoJTNBMDRkJTdELnBuZyUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DDPMPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> make_image_grid
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> os

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">evaluate</span>(<span class="hljs-params">config, epoch, pipeline</span>):
<span class="hljs-meta">... </span>    <span class="hljs-comment"># Sample some images from random noise (this is the backward diffusion process).</span>
<span class="hljs-meta">... </span>    <span class="hljs-comment"># The default pipeline output type is \`List[PIL.Image]\`</span>
<span class="hljs-meta">... </span>    images = pipeline(
<span class="hljs-meta">... </span>        batch_size=config.eval_batch_size,
<span class="hljs-meta">... </span>        generator=torch.Generator(device=<span class="hljs-string">&#x27;cpu&#x27;</span>).manual_seed(config.seed), <span class="hljs-comment"># Use a separate torch generator to avoid rewinding the random state of the main training loop</span>
<span class="hljs-meta">... </span>    ).images

<span class="hljs-meta">... </span>    <span class="hljs-comment"># Make a grid out of the images</span>
<span class="hljs-meta">... </span>    image_grid = make_image_grid(images, rows=<span class="hljs-number">4</span>, cols=<span class="hljs-number">4</span>)

<span class="hljs-meta">... </span>    <span class="hljs-comment"># Save the images</span>
<span class="hljs-meta">... </span>    test_dir = os.path.join(config.output_dir, <span class="hljs-string">&quot;samples&quot;</span>)
<span class="hljs-meta">... </span>    os.makedirs(test_dir, exist_ok=<span class="hljs-literal">True</span>)
<span class="hljs-meta">... </span>    image_grid.save(<span class="hljs-string">f&quot;<span class="hljs-subst">{test_dir}</span>/<span class="hljs-subst">{epoch:04d}</span>.png&quot;</span>)`,wrap:!1}}),f=new Rl({props:{$$slots:{default:[Xa]},$$scope:{ctx:d}}}),Us=new J({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> Accelerator
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> create_repo, upload_folder
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> tqdm.auto <span class="hljs-keyword">import</span> tqdm
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> pathlib <span class="hljs-keyword">import</span> Path
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> os

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">train_loop</span>(<span class="hljs-params">config, model, noise_scheduler, optimizer, train_dataloader, lr_scheduler</span>):
<span class="hljs-meta">... </span>    <span class="hljs-comment"># Initialize accelerator and tensorboard logging</span>
<span class="hljs-meta">... </span>    accelerator = Accelerator(
<span class="hljs-meta">... </span>        mixed_precision=config.mixed_precision,
<span class="hljs-meta">... </span>        gradient_accumulation_steps=config.gradient_accumulation_steps,
<span class="hljs-meta">... </span>        log_with=<span class="hljs-string">&quot;tensorboard&quot;</span>,
<span class="hljs-meta">... </span>        project_dir=os.path.join(config.output_dir, <span class="hljs-string">&quot;logs&quot;</span>),
<span class="hljs-meta">... </span>    )
<span class="hljs-meta">... </span>    <span class="hljs-keyword">if</span> accelerator.is_main_process:
<span class="hljs-meta">... </span>        <span class="hljs-keyword">if</span> config.output_dir <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>:
<span class="hljs-meta">... </span>            os.makedirs(config.output_dir, exist_ok=<span class="hljs-literal">True</span>)
<span class="hljs-meta">... </span>        <span class="hljs-keyword">if</span> config.push_to_hub:
<span class="hljs-meta">... </span>            repo_id = create_repo(
<span class="hljs-meta">... </span>                repo_id=config.hub_model_id <span class="hljs-keyword">or</span> Path(config.output_dir).name, exist_ok=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>            ).repo_id
<span class="hljs-meta">... </span>        accelerator.init_trackers(<span class="hljs-string">&quot;train_example&quot;</span>)

<span class="hljs-meta">... </span>    <span class="hljs-comment"># Prepare everything</span>
<span class="hljs-meta">... </span>    <span class="hljs-comment"># There is no specific order to remember, you just need to unpack the</span>
<span class="hljs-meta">... </span>    <span class="hljs-comment"># objects in the same order you gave them to the prepare method.</span>
<span class="hljs-meta">... </span>    model, optimizer, train_dataloader, lr_scheduler = accelerator.prepare(
<span class="hljs-meta">... </span>        model, optimizer, train_dataloader, lr_scheduler
<span class="hljs-meta">... </span>    )

<span class="hljs-meta">... </span>    global_step = <span class="hljs-number">0</span>

<span class="hljs-meta">... </span>    <span class="hljs-comment"># Now you train the model</span>
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> epoch <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(config.num_epochs):
<span class="hljs-meta">... </span>        progress_bar = tqdm(total=<span class="hljs-built_in">len</span>(train_dataloader), disable=<span class="hljs-keyword">not</span> accelerator.is_local_main_process)
<span class="hljs-meta">... </span>        progress_bar.set_description(<span class="hljs-string">f&quot;Epoch <span class="hljs-subst">{epoch}</span>&quot;</span>)

<span class="hljs-meta">... </span>        <span class="hljs-keyword">for</span> step, batch <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(train_dataloader):
<span class="hljs-meta">... </span>            clean_images = batch[<span class="hljs-string">&quot;images&quot;</span>]
<span class="hljs-meta">... </span>            <span class="hljs-comment"># Sample noise to add to the images</span>
<span class="hljs-meta">... </span>            noise = torch.randn(clean_images.shape, device=clean_images.device)
<span class="hljs-meta">... </span>            bs = clean_images.shape[<span class="hljs-number">0</span>]

<span class="hljs-meta">... </span>            <span class="hljs-comment"># Sample a random timestep for each image</span>
<span class="hljs-meta">... </span>            timesteps = torch.randint(
<span class="hljs-meta">... </span>                <span class="hljs-number">0</span>, noise_scheduler.config.num_train_timesteps, (bs,), device=clean_images.device,
<span class="hljs-meta">... </span>                dtype=torch.int64
<span class="hljs-meta">... </span>            )

<span class="hljs-meta">... </span>            <span class="hljs-comment"># Add noise to the clean images according to the noise magnitude at each timestep</span>
<span class="hljs-meta">... </span>            <span class="hljs-comment"># (this is the forward diffusion process)</span>
<span class="hljs-meta">... </span>            noisy_images = noise_scheduler.add_noise(clean_images, noise, timesteps)

<span class="hljs-meta">... </span>            <span class="hljs-keyword">with</span> accelerator.accumulate(model):
<span class="hljs-meta">... </span>                <span class="hljs-comment"># Predict the noise residual</span>
<span class="hljs-meta">... </span>                noise_pred = model(noisy_images, timesteps, return_dict=<span class="hljs-literal">False</span>)[<span class="hljs-number">0</span>]
<span class="hljs-meta">... </span>                loss = F.mse_loss(noise_pred, noise)
<span class="hljs-meta">... </span>                accelerator.backward(loss)

<span class="hljs-meta">... </span>                accelerator.clip_grad_norm_(model.parameters(), <span class="hljs-number">1.0</span>)
<span class="hljs-meta">... </span>                optimizer.step()
<span class="hljs-meta">... </span>                lr_scheduler.step()
<span class="hljs-meta">... </span>                optimizer.zero_grad()

<span class="hljs-meta">... </span>            progress_bar.update(<span class="hljs-number">1</span>)
<span class="hljs-meta">... </span>            logs = {<span class="hljs-string">&quot;loss&quot;</span>: loss.detach().item(), <span class="hljs-string">&quot;lr&quot;</span>: lr_scheduler.get_last_lr()[<span class="hljs-number">0</span>], <span class="hljs-string">&quot;step&quot;</span>: global_step}
<span class="hljs-meta">... </span>            progress_bar.set_postfix(**logs)
<span class="hljs-meta">... </span>            accelerator.log(logs, step=global_step)
<span class="hljs-meta">... </span>            global_step += <span class="hljs-number">1</span>

<span class="hljs-meta">... </span>        <span class="hljs-comment"># After each epoch you optionally sample some demo images with evaluate() and save the model</span>
<span class="hljs-meta">... </span>        <span class="hljs-keyword">if</span> accelerator.is_main_process:
<span class="hljs-meta">... </span>            pipeline = DDPMPipeline(unet=accelerator.unwrap_model(model), scheduler=noise_scheduler)

<span class="hljs-meta">... </span>            <span class="hljs-keyword">if</span> (epoch + <span class="hljs-number">1</span>) % config.save_image_epochs == <span class="hljs-number">0</span> <span class="hljs-keyword">or</span> epoch == config.num_epochs - <span class="hljs-number">1</span>:
<span class="hljs-meta">... </span>                evaluate(config, epoch, pipeline)

<span class="hljs-meta">... </span>            <span class="hljs-keyword">if</span> (epoch + <span class="hljs-number">1</span>) % config.save_model_epochs == <span class="hljs-number">0</span> <span class="hljs-keyword">or</span> epoch == config.num_epochs - <span class="hljs-number">1</span>:
<span class="hljs-meta">... </span>                <span class="hljs-keyword">if</span> config.push_to_hub:
<span class="hljs-meta">... </span>                    upload_folder(
<span class="hljs-meta">... </span>                        repo_id=repo_id,
<span class="hljs-meta">... </span>                        folder_path=config.output_dir,
<span class="hljs-meta">... </span>                        commit_message=<span class="hljs-string">f&quot;Epoch <span class="hljs-subst">{epoch}</span>&quot;</span>,
<span class="hljs-meta">... </span>                        ignore_patterns=[<span class="hljs-string">&quot;step_*&quot;</span>, <span class="hljs-string">&quot;epoch_*&quot;</span>],
<span class="hljs-meta">... </span>                    )
<span class="hljs-meta">... </span>                <span class="hljs-keyword">else</span>:
<span class="hljs-meta">... </span>                    pipeline.save_pretrained(config.output_dir)`,wrap:!1}}),us=new J({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBub3RlYm9va19sYXVuY2hlciUwQSUwQWFyZ3MlMjAlM0QlMjAoY29uZmlnJTJDJTIwbW9kZWwlMkMlMjBub2lzZV9zY2hlZHVsZXIlMkMlMjBvcHRpbWl6ZXIlMkMlMjB0cmFpbl9kYXRhbG9hZGVyJTJDJTIwbHJfc2NoZWR1bGVyKSUwQSUwQW5vdGVib29rX2xhdW5jaGVyKHRyYWluX2xvb3AlMkMlMjBhcmdzJTJDJTIwbnVtX3Byb2Nlc3NlcyUzRDEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> notebook_launcher

<span class="hljs-meta">&gt;&gt;&gt; </span>args = (config, model, noise_scheduler, optimizer, train_dataloader, lr_scheduler)

<span class="hljs-meta">&gt;&gt;&gt; </span>notebook_launcher(train_loop, args, num_processes=<span class="hljs-number">1</span>)`,wrap:!1}}),gs=new J({props:{code:"aW1wb3J0JTIwZ2xvYiUwQSUwQXNhbXBsZV9pbWFnZXMlMjAlM0QlMjBzb3J0ZWQoZ2xvYi5nbG9iKGYlMjIlN0Jjb25maWcub3V0cHV0X2RpciU3RCUyRnNhbXBsZXMlMkYqLnBuZyUyMikpJTBBSW1hZ2Uub3BlbihzYW1wbGVfaW1hZ2VzJTVCLTElNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> glob

<span class="hljs-meta">&gt;&gt;&gt; </span>sample_images = <span class="hljs-built_in">sorted</span>(glob.glob(<span class="hljs-string">f&quot;<span class="hljs-subst">{config.output_dir}</span>/samples/*.png&quot;</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span>Image.<span class="hljs-built_in">open</span>(sample_images[-<span class="hljs-number">1</span>])`,wrap:!1}}),Is=new Bs({props:{title:"Next steps",local:"next-steps",headingTag:"h2"}}),As=new Ba({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/tutorials/basic_training.md"}}),{c(){i=p("meta"),T=t(),w=p("p"),U=t(),c(A.$$.fragment),Xs=t(),c(B.$$.fragment),Ws=t(),Z=p("p"),Z.innerHTML=zl,ks=t(),G=p("p"),G.innerHTML=Ql,_s=t(),c(u.$$.fragment),vs=t(),X=p("p"),X.innerHTML=El,Vs=t(),c(W.$$.fragment),Ns=t(),k=p("p"),k.innerHTML=Fl,$s=t(),c(_.$$.fragment),Rs=t(),v=p("p"),v.textContent=Hl,Ys=t(),c(V.$$.fragment),zs=t(),N=p("p"),N.innerHTML=Sl,Qs=t(),c($.$$.fragment),Es=t(),c(R.$$.fragment),Fs=t(),Y=p("p"),Y.innerHTML=xl,Hs=t(),c(z.$$.fragment),Ss=t(),c(Q.$$.fragment),xs=t(),E=p("p"),E.innerHTML=Dl,Ds=t(),c(F.$$.fragment),qs=t(),c(b.$$.fragment),Ls=t(),H=p("p"),H.innerHTML=ql,Ks=t(),c(S.$$.fragment),Ps=t(),g=p("div"),g.innerHTML=Ll,Os=t(),x=p("p"),x.textContent=Kl,sl=t(),D=p("ul"),D.innerHTML=Pl,ll=t(),c(q.$$.fragment),al=t(),L=p("p"),L.innerHTML=Ol,el=t(),c(K.$$.fragment),tl=t(),P=p("p"),P.innerHTML=sa,nl=t(),c(O.$$.fragment),pl=t(),c(ss.$$.fragment),Ml=t(),ls=p("p"),ls.innerHTML=la,il=t(),c(as.$$.fragment),ol=t(),es=p("p"),es.textContent=aa,cl=t(),c(ts.$$.fragment),ml=t(),ns=p("p"),ns.textContent=ea,jl=t(),c(ps.$$.fragment),yl=t(),Ms=p("p"),Ms.innerHTML=ta,rl=t(),is=p("p"),is.innerHTML=na,hl=t(),c(os.$$.fragment),wl=t(),I=p("div"),I.innerHTML=pa,Jl=t(),cs=p("p"),cs.textContent=Ma,Tl=t(),c(ms.$$.fragment),Ul=t(),c(js.$$.fragment),dl=t(),ys=p("p"),ys.textContent=ia,ul=t(),rs=p("p"),rs.textContent=oa,bl=t(),c(hs.$$.fragment),gl=t(),ws=p("p"),ws.innerHTML=ca,Il=t(),c(Js.$$.fragment),fl=t(),Ts=p("p"),Ts.textContent=ma,Cl=t(),c(f.$$.fragment),Al=t(),c(Us.$$.fragment),Bl=t(),ds=p("p"),ds.innerHTML=ja,Zl=t(),c(us.$$.fragment),Gl=t(),bs=p("p"),bs.textContent=ya,Xl=t(),c(gs.$$.fragment),Wl=t(),C=p("div"),C.innerHTML=ra,kl=t(),c(Is.$$.fragment),_l=t(),fs=p("p"),fs.innerHTML=ha,vl=t(),Cs=p("ul"),Cs.innerHTML=wa,Vl=t(),c(As.$$.fragment),Nl=t(),Zs=p("p"),this.h()},l(s){const l=fa("svelte-u9bgzb",document.head);i=M(l,"META",{name:!0,content:!0}),l.forEach(a),T=n(s),w=M(s,"P",{}),da(w).forEach(a),U=n(s),m(A.$$.fragment,s),Xs=n(s),m(B.$$.fragment,s),Ws=n(s),Z=M(s,"P",{"data-svelte-h":!0}),o(Z)!=="svelte-tdss46"&&(Z.innerHTML=zl),ks=n(s),G=M(s,"P",{"data-svelte-h":!0}),o(G)!=="svelte-vnd4w8"&&(G.innerHTML=Ql),_s=n(s),m(u.$$.fragment,s),vs=n(s),X=M(s,"P",{"data-svelte-h":!0}),o(X)!=="svelte-x3q6hl"&&(X.innerHTML=El),Vs=n(s),m(W.$$.fragment,s),Ns=n(s),k=M(s,"P",{"data-svelte-h":!0}),o(k)!=="svelte-1c8cv44"&&(k.innerHTML=Fl),$s=n(s),m(_.$$.fragment,s),Rs=n(s),v=M(s,"P",{"data-svelte-h":!0}),o(v)!=="svelte-17henro"&&(v.textContent=Hl),Ys=n(s),m(V.$$.fragment,s),zs=n(s),N=M(s,"P",{"data-svelte-h":!0}),o(N)!=="svelte-sz5qnh"&&(N.innerHTML=Sl),Qs=n(s),m($.$$.fragment,s),Es=n(s),m(R.$$.fragment,s),Fs=n(s),Y=M(s,"P",{"data-svelte-h":!0}),o(Y)!=="svelte-1otxl74"&&(Y.innerHTML=xl),Hs=n(s),m(z.$$.fragment,s),Ss=n(s),m(Q.$$.fragment,s),xs=n(s),E=M(s,"P",{"data-svelte-h":!0}),o(E)!=="svelte-1wj8hyv"&&(E.innerHTML=Dl),Ds=n(s),m(F.$$.fragment,s),qs=n(s),m(b.$$.fragment,s),Ls=n(s),H=M(s,"P",{"data-svelte-h":!0}),o(H)!=="svelte-1bh16eq"&&(H.innerHTML=ql),Ks=n(s),m(S.$$.fragment,s),Ps=n(s),g=M(s,"DIV",{class:!0,"data-svelte-h":!0}),o(g)!=="svelte-1wjbouq"&&(g.innerHTML=Ll),Os=n(s),x=M(s,"P",{"data-svelte-h":!0}),o(x)!=="svelte-19lli6v"&&(x.textContent=Kl),sl=n(s),D=M(s,"UL",{"data-svelte-h":!0}),o(D)!=="svelte-8oirkq"&&(D.innerHTML=Pl),ll=n(s),m(q.$$.fragment,s),al=n(s),L=M(s,"P",{"data-svelte-h":!0}),o(L)!=="svelte-a1cdro"&&(L.innerHTML=Ol),el=n(s),m(K.$$.fragment,s),tl=n(s),P=M(s,"P",{"data-svelte-h":!0}),o(P)!=="svelte-1abv18u"&&(P.innerHTML=sa),nl=n(s),m(O.$$.fragment,s),pl=n(s),m(ss.$$.fragment,s),Ml=n(s),ls=M(s,"P",{"data-svelte-h":!0}),o(ls)!=="svelte-1ov1o95"&&(ls.innerHTML=la),il=n(s),m(as.$$.fragment,s),ol=n(s),es=M(s,"P",{"data-svelte-h":!0}),o(es)!=="svelte-ahjyed"&&(es.textContent=aa),cl=n(s),m(ts.$$.fragment,s),ml=n(s),ns=M(s,"P",{"data-svelte-h":!0}),o(ns)!=="svelte-1hkhok8"&&(ns.textContent=ea),jl=n(s),m(ps.$$.fragment,s),yl=n(s),Ms=M(s,"P",{"data-svelte-h":!0}),o(Ms)!=="svelte-31qoa1"&&(Ms.innerHTML=ta),rl=n(s),is=M(s,"P",{"data-svelte-h":!0}),o(is)!=="svelte-1f7exst"&&(is.innerHTML=na),hl=n(s),m(os.$$.fragment,s),wl=n(s),I=M(s,"DIV",{class:!0,"data-svelte-h":!0}),o(I)!=="svelte-qcxk5"&&(I.innerHTML=pa),Jl=n(s),cs=M(s,"P",{"data-svelte-h":!0}),o(cs)!=="svelte-1pekxga"&&(cs.textContent=Ma),Tl=n(s),m(ms.$$.fragment,s),Ul=n(s),m(js.$$.fragment,s),dl=n(s),ys=M(s,"P",{"data-svelte-h":!0}),o(ys)!=="svelte-rpu9md"&&(ys.textContent=ia),ul=n(s),rs=M(s,"P",{"data-svelte-h":!0}),o(rs)!=="svelte-11y5cd5"&&(rs.textContent=oa),bl=n(s),m(hs.$$.fragment,s),gl=n(s),ws=M(s,"P",{"data-svelte-h":!0}),o(ws)!=="svelte-cd2o2j"&&(ws.innerHTML=ca),Il=n(s),m(Js.$$.fragment,s),fl=n(s),Ts=M(s,"P",{"data-svelte-h":!0}),o(Ts)!=="svelte-13pvon6"&&(Ts.textContent=ma),Cl=n(s),m(f.$$.fragment,s),Al=n(s),m(Us.$$.fragment,s),Bl=n(s),ds=M(s,"P",{"data-svelte-h":!0}),o(ds)!=="svelte-1f597mr"&&(ds.innerHTML=ja),Zl=n(s),m(us.$$.fragment,s),Gl=n(s),bs=M(s,"P",{"data-svelte-h":!0}),o(bs)!=="svelte-nz3dg5"&&(bs.textContent=ya),Xl=n(s),m(gs.$$.fragment,s),Wl=n(s),C=M(s,"DIV",{class:!0,"data-svelte-h":!0}),o(C)!=="svelte-tzqtub"&&(C.innerHTML=ra),kl=n(s),m(Is.$$.fragment,s),_l=n(s),fs=M(s,"P",{"data-svelte-h":!0}),o(fs)!=="svelte-zg9981"&&(fs.innerHTML=ha),vl=n(s),Cs=M(s,"UL",{"data-svelte-h":!0}),o(Cs)!=="svelte-cndhdw"&&(Cs.innerHTML=wa),Vl=n(s),m(As.$$.fragment,s),Nl=n(s),Zs=M(s,"P",{}),da(Zs).forEach(a),this.h()},h(){Gs(i,"name","hf:doc:metadata"),Gs(i,"content",ka),Gs(g,"class","flex justify-center"),Gs(I,"class","flex justify-center"),Gs(C,"class","flex justify-center")},m(s,l){Ca(document.head,i),e(s,T,l),e(s,w,l),e(s,U,l),j(A,s,l),e(s,Xs,l),j(B,s,l),e(s,Ws,l),e(s,Z,l),e(s,ks,l),e(s,G,l),e(s,_s,l),j(u,s,l),e(s,vs,l),e(s,X,l),e(s,Vs,l),j(W,s,l),e(s,Ns,l),e(s,k,l),e(s,$s,l),j(_,s,l),e(s,Rs,l),e(s,v,l),e(s,Ys,l),j(V,s,l),e(s,zs,l),e(s,N,l),e(s,Qs,l),j($,s,l),e(s,Es,l),j(R,s,l),e(s,Fs,l),e(s,Y,l),e(s,Hs,l),j(z,s,l),e(s,Ss,l),j(Q,s,l),e(s,xs,l),e(s,E,l),e(s,Ds,l),j(F,s,l),e(s,qs,l),j(b,s,l),e(s,Ls,l),e(s,H,l),e(s,Ks,l),j(S,s,l),e(s,Ps,l),e(s,g,l),e(s,Os,l),e(s,x,l),e(s,sl,l),e(s,D,l),e(s,ll,l),j(q,s,l),e(s,al,l),e(s,L,l),e(s,el,l),j(K,s,l),e(s,tl,l),e(s,P,l),e(s,nl,l),j(O,s,l),e(s,pl,l),j(ss,s,l),e(s,Ml,l),e(s,ls,l),e(s,il,l),j(as,s,l),e(s,ol,l),e(s,es,l),e(s,cl,l),j(ts,s,l),e(s,ml,l),e(s,ns,l),e(s,jl,l),j(ps,s,l),e(s,yl,l),e(s,Ms,l),e(s,rl,l),e(s,is,l),e(s,hl,l),j(os,s,l),e(s,wl,l),e(s,I,l),e(s,Jl,l),e(s,cs,l),e(s,Tl,l),j(ms,s,l),e(s,Ul,l),j(js,s,l),e(s,dl,l),e(s,ys,l),e(s,ul,l),e(s,rs,l),e(s,bl,l),j(hs,s,l),e(s,gl,l),e(s,ws,l),e(s,Il,l),j(Js,s,l),e(s,fl,l),e(s,Ts,l),e(s,Cl,l),j(f,s,l),e(s,Al,l),j(Us,s,l),e(s,Bl,l),e(s,ds,l),e(s,Zl,l),j(us,s,l),e(s,Gl,l),e(s,bs,l),e(s,Xl,l),j(gs,s,l),e(s,Wl,l),e(s,C,l),e(s,kl,l),j(Is,s,l),e(s,_l,l),e(s,fs,l),e(s,vl,l),e(s,Cs,l),e(s,Vl,l),j(As,s,l),e(s,Nl,l),e(s,Zs,l),$l=!0},p(s,[l]){const Ja={};l&2&&(Ja.$$scope={dirty:l,ctx:s}),u.$set(Ja);const Ta={};l&2&&(Ta.$$scope={dirty:l,ctx:s}),b.$set(Ta);const Ua={};l&2&&(Ua.$$scope={dirty:l,ctx:s}),f.$set(Ua)},i(s){$l||(y(A.$$.fragment,s),y(B.$$.fragment,s),y(u.$$.fragment,s),y(W.$$.fragment,s),y(_.$$.fragment,s),y(V.$$.fragment,s),y($.$$.fragment,s),y(R.$$.fragment,s),y(z.$$.fragment,s),y(Q.$$.fragment,s),y(F.$$.fragment,s),y(b.$$.fragment,s),y(S.$$.fragment,s),y(q.$$.fragment,s),y(K.$$.fragment,s),y(O.$$.fragment,s),y(ss.$$.fragment,s),y(as.$$.fragment,s),y(ts.$$.fragment,s),y(ps.$$.fragment,s),y(os.$$.fragment,s),y(ms.$$.fragment,s),y(js.$$.fragment,s),y(hs.$$.fragment,s),y(Js.$$.fragment,s),y(f.$$.fragment,s),y(Us.$$.fragment,s),y(us.$$.fragment,s),y(gs.$$.fragment,s),y(Is.$$.fragment,s),y(As.$$.fragment,s),$l=!0)},o(s){r(A.$$.fragment,s),r(B.$$.fragment,s),r(u.$$.fragment,s),r(W.$$.fragment,s),r(_.$$.fragment,s),r(V.$$.fragment,s),r($.$$.fragment,s),r(R.$$.fragment,s),r(z.$$.fragment,s),r(Q.$$.fragment,s),r(F.$$.fragment,s),r(b.$$.fragment,s),r(S.$$.fragment,s),r(q.$$.fragment,s),r(K.$$.fragment,s),r(O.$$.fragment,s),r(ss.$$.fragment,s),r(as.$$.fragment,s),r(ts.$$.fragment,s),r(ps.$$.fragment,s),r(os.$$.fragment,s),r(ms.$$.fragment,s),r(js.$$.fragment,s),r(hs.$$.fragment,s),r(Js.$$.fragment,s),r(f.$$.fragment,s),r(Us.$$.fragment,s),r(us.$$.fragment,s),r(gs.$$.fragment,s),r(Is.$$.fragment,s),r(As.$$.fragment,s),$l=!1},d(s){s&&(a(T),a(w),a(U),a(Xs),a(Ws),a(Z),a(ks),a(G),a(_s),a(vs),a(X),a(Vs),a(Ns),a(k),a($s),a(Rs),a(v),a(Ys),a(zs),a(N),a(Qs),a(Es),a(Fs),a(Y),a(Hs),a(Ss),a(xs),a(E),a(Ds),a(qs),a(Ls),a(H),a(Ks),a(Ps),a(g),a(Os),a(x),a(sl),a(D),a(ll),a(al),a(L),a(el),a(tl),a(P),a(nl),a(pl),a(Ml),a(ls),a(il),a(ol),a(es),a(cl),a(ml),a(ns),a(jl),a(yl),a(Ms),a(rl),a(is),a(hl),a(wl),a(I),a(Jl),a(cs),a(Tl),a(Ul),a(dl),a(ys),a(ul),a(rs),a(bl),a(gl),a(ws),a(Il),a(fl),a(Ts),a(Cl),a(Al),a(Bl),a(ds),a(Zl),a(Gl),a(bs),a(Xl),a(Wl),a(C),a(kl),a(_l),a(fs),a(vl),a(Cs),a(Vl),a(Nl),a(Zs)),a(i),h(A,s),h(B,s),h(u,s),h(W,s),h(_,s),h(V,s),h($,s),h(R,s),h(z,s),h(Q,s),h(F,s),h(b,s),h(S,s),h(q,s),h(K,s),h(O,s),h(ss,s),h(as,s),h(ts,s),h(ps,s),h(os,s),h(ms,s),h(js,s),h(hs,s),h(Js,s),h(f,s),h(Us,s),h(us,s),h(gs,s),h(Is,s),h(As,s)}}}const ka='{"title":"Train a diffusion model","local":"train-a-diffusion-model","sections":[{"title":"Training configuration","local":"training-configuration","sections":[],"depth":2},{"title":"Load the dataset","local":"load-the-dataset","sections":[],"depth":2},{"title":"Create a UNet2DModel","local":"create-a-unet2dmodel","sections":[],"depth":2},{"title":"Create a scheduler","local":"create-a-scheduler","sections":[],"depth":2},{"title":"Train the model","local":"train-the-model","sections":[],"depth":2},{"title":"Next steps","local":"next-steps","sections":[],"depth":2}],"depth":1}';function _a(d){return ba(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class za extends ga{constructor(i){super(),Ia(this,i,_a,Wa,ua,{})}}export{za as component};
