import{s as Ke,o as De,n as Pe}from"../chunks/scheduler.37c15a92.js";import{S as Oe,i as sl,g as o,s as n,r as w,m as Us,A as el,h as p,f as l,c as a,j as Je,u as m,x as i,n as fs,k as Ts,y as bs,a as t,v as d,d as M,t as y,w as j}from"../chunks/index.2bf4358c.js";import{T as Ye}from"../chunks/Tip.363c041f.js";import{C as v}from"../chunks/CodeBlock.4e987730.js";import{H as C}from"../chunks/Heading.8ada512a.js";import{E as ll}from"../chunks/getInferenceSnippets.d4d07d1e.js";function tl(js){let c,u,U="ce *notebook*",J;return{c(){c=Us("Vous pouvez suivre le code dans "),u=o("a"),u.textContent=U,J=Us(" que vous pouvez exécuter avec Google Colab."),this.h()},l(r){c=fs(r,"Vous pouvez suivre le code dans "),u=p(r,"A",{href:!0,target:!0,"data-svelte-h":!0}),i(u)!=="svelte-1sx67bs"&&(u.textContent=U),J=fs(r," que vous pouvez exécuter avec Google Colab."),this.h()},h(){Ts(u,"href","https://huggingface.co/agents-course/notebooks/blob/main/unit2/llama-index/workflows.ipynb"),Ts(u,"target","_blank")},m(r,T){t(r,c,T),t(r,u,T),t(r,J,T)},p:Pe,d(r){r&&(l(c),l(u),l(J))}}}function nl(js){let c,u,U="la documentation LlamaIndex",J;return{c(){c=Us("Il y a quelques nuances plus complexes aux *workflows*, que vous pouvez apprendre dans "),u=o("a"),u.textContent=U,J=Us("."),this.h()},l(r){c=fs(r,"Il y a quelques nuances plus complexes aux *workflows*, que vous pouvez apprendre dans "),u=p(r,"A",{href:!0,"data-svelte-h":!0}),i(u)!=="svelte-15s9yx0"&&(u.textContent=U),J=fs(r,"."),this.h()},h(){Ts(u,"href","https://docs.llamaindex.ai/en/stable/understanding/workflows/")},m(r,T){t(r,c,T),t(r,u,T),t(r,J,T)},p:Pe,d(r){r&&(l(c),l(u),l(J))}}}function al(js){let c,u,U,J,r,T,k,Te="Un <em>workflow</em> dans LlamaIndex fournit un moyen structuré d’organiser votre code en étapes séquentielles et gérables.",Is,B,Ue=`Un tel <em>workflow</em> est créé en définissant des <code>Steps</code> qui sont déclenchés par des <code>Events</code>, et qui émettent eux-mêmes des <code>Events</code> pour déclencher d’autres étapes.
Jetons un coup d’œil à Alfred montrant un <em>workflow</em> LlamaIndex pour une tâche <em>RAG</em>.`,vs,g,fe='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit2/llama-index/workflows.png" alt="Workflow Schematic"/>',Cs,G,he="<strong>Les <em>workflows</em> offrent plusieurs avantages clés :</strong>",ks,Z,be="<li>Organisation claire du code en étapes discrètes</li> <li>Architecture événementielle pour un flux de contrôle flexible</li> <li>Communication <em>type-safe</em> entre les étapes</li> <li>Gestion d’état intégrée</li> <li>Support pour des interactions d’agents simples et complexes</li>",Bs,_,Ie="Comme vous l’avez peut-être deviné, <strong>les <em>workflows</em> trouvent un excellent équilibre entre l’autonomie des agents tout en maintenant le contrôle sur le <em>workflow</em> global.</strong>",gs,$,ve="Alors, apprenons à créer un <em>workflow</em> nous-mêmes !",Gs,x,Zs,b,_s,E,$s,f,Js,Ce="Installer le package *Workflow*",ye,V,ke="section sur le *LlamaHub*",je,W,xs,H,Be=`Nous pouvons créer un <em>workflow</em> en une seule étape en définissant une classe qui hérite de <code>Workflow</code> et en décorant vos fonctions avec <code>@step</code>.
Nous devrons également ajouter <code>StartEvent</code> et <code>StopEvent</code>, qui sont des événements spéciaux utilisés pour indiquer le début et la fin du <em>workflow</em>.`,Es,Q,Vs,q,ge="Comme vous pouvez le voir, nous pouvons maintenant exécuter le <em>workflow</em> en appelant <code>w.run()</code>.",Ws,S,Hs,A,Ge=`Pour connecter plusieurs étapes, nous <strong>créons des événements personnalisés qui transportent des données entre les étapes.</strong>
Pour ce faire, nous devons ajouter un <code>Event</code> qui est passé entre les étapes et transfère la sortie de la première étape vers la deuxième étape.`,Qs,F,qs,X,Ze="L’indication de type est importante ici, car elle garantit que le <em>workflow</em> est exécuté correctement. Compliquons un peu les choses !",Ss,R,As,z,_e="L’indication de type est la partie la plus puissante des <em>workflows</em> car elle nous permet de créer des branches, des boucles et des jointures pour faciliter des <em>workflows</em> plus complexes.",Fs,N,$e=`Montrons un exemple de <strong>création d’une boucle</strong> en utilisant l’opérateur union <code>|</code>.
Dans l’exemple ci-dessous, nous voyons que le <code>LoopEvent</code> est pris en entrée pour l’étape et peut également être retourné en sortie.`,Xs,L,Rs,Y,zs,P,xe="Nous pouvons également dessiner des <em>workflows</em>. Utilisons la fonction <code>draw_all_possible_flows</code> pour dessiner le <em>workflow</em>. Cela stocke le <em>workflow</em> dans un fichier <em>HTML</em>.",Ns,K,Ls,D,Ee='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit2/llama-index/workflow-draw.png" alt="workflow drawing"/>',Ys,O,Ve="Il y a une dernière astuce cool que nous couvrirons dans le cours, qui est la capacité d’ajouter de l’état au <em>workflow</em>.",Ps,ss,Ks,es,We=`La gestion d’état est utile quand vous voulez garder une trace de l’état du <em>workflow</em>, pour que chaque étape ait accès au même état.
Nous pouvons faire cela en utilisant l’indication de type <code>Context</code> au-dessus d’un paramètre dans la fonction d’étape.`,Ds,ls,Os,ts,He="Parfait ! Maintenant vous savez comment créer des <em>workflows</em> de base dans LlamaIndex !",se,I,ee,ns,Qe="Cependant, il y a une autre façon de créer des <em>workflows</em>, qui repose sur la classe <code>AgentWorkflow</code>. Jetons un coup d’œil à comment nous pouvons utiliser cela pour créer un <em>workflow</em> multi-agents.",le,as,te,os,qe=`Au lieu de la création manuelle de <em>workflows</em>, nous pouvons utiliser la <strong>classe <code>AgentWorkflow</code> pour créer un <em>workflow</em> multi-agents</strong>.
L’<code>AgentWorkflow</code> utilise des <em>Workflow Agents</em> pour vous permettre de créer un système d’un ou plusieurs agents qui peuvent collaborer et se passer des tâches entre eux basées sur leurs capacités spécialisées.
Cela permet de construire des systèmes d’agents complexes où différents agents gèrent différents aspects d’une tâche.
Au lieu d’importer des classes de <code>llama_index.core.agent</code>, nous importerons les classes d’agents de <code>llama_index.core.agent.workflow</code>.
Un agent doit être désigné comme l’agent racine dans le constructeur <code>AgentWorkflow</code>.
Quand un message utilisateur arrive, il est d’abord routé vers l’agent racine.`,ne,ps,Se="Chaque agent peut ensuite :",ae,is,Ae="<li>Gérer la demande directement en utilisant leurs <em>tools</em></li> <li>Passer le relais à un autre agent mieux adapté à la tâche</li> <li>Retourner une réponse à l’utilisateur</li>",oe,rs,Fe="Voyons comment créer un <em>workflow</em> multi-agents.",pe,us,ie,cs,Xe=`Les <em>tools</em> d’agents peuvent également modifier l’état du <em>workflow</em> que nous avons mentionné plus tôt. Avant de commencer le <em>workflow</em>, nous pouvons fournir un dictionnaire d’état initial qui sera disponible pour tous les agents.
L’état est stocké dans la clé d’état du contexte du <em>workflow</em>. Il sera injecté dans le <em>state_prompt</em> qui augmente chaque nouveau message utilisateur.`,re,ws,Re="Injectons un compteur pour compter les appels de fonctions en modifiant l’exemple précédent :",ue,ms,ce,ds,ze="Félicitations ! Vous avez maintenant maîtrisé les bases des <em>Agents</em> dans LlamaIndex ! 🎉",we,Ms,Ne="Continuons avec un dernier quiz pour solidifier vos connaissances ! 🚀",me,ys,de,hs,Me;return r=new C({props:{title:"Créer des workflows agentiques dans LlamaIndex",local:"créer-des-workflows-agentiques-dans-llamaindex",headingTag:"h1"}}),x=new C({props:{title:"Créer des Workflows",local:"créer-des-workflows",headingTag:"h2"}}),b=new Ye({props:{$$slots:{default:[tl]},$$scope:{ctx:js}}}),E=new C({props:{title:"Création de Workflow de base",local:"création-de-workflow-de-base",headingTag:"h3"}}),W=new v({props:{code:"cGlwJTIwaW5zdGFsbCUyMGxsYW1hLWluZGV4LXV0aWxzLXdvcmtmbG93",highlighted:"pip install llama-index-utils-workflow",wrap:!1}}),Q=new v({props:{code:"ZnJvbSUyMGxsYW1hX2luZGV4LmNvcmUud29ya2Zsb3clMjBpbXBvcnQlMjBTdGFydEV2ZW50JTJDJTIwU3RvcEV2ZW50JTJDJTIwV29ya2Zsb3clMkMlMjBzdGVwJTBBJTBBY2xhc3MlMjBNeVdvcmtmbG93KFdvcmtmbG93KSUzQSUwQSUyMCUyMCUyMCUyMCU0MHN0ZXAlMEElMjAlMjAlMjAlMjBhc3luYyUyMGRlZiUyMG15X3N0ZXAoc2VsZiUyQyUyMGV2JTNBJTIwU3RhcnRFdmVudCklMjAtJTNFJTIwU3RvcEV2ZW50JTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwZG8lMjBzb21ldGhpbmclMjBoZXJlJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwU3RvcEV2ZW50KHJlc3VsdCUzRCUyMkhlbGxvJTJDJTIwd29ybGQhJTIyKSUwQSUwQSUwQXclMjAlM0QlMjBNeVdvcmtmbG93KHRpbWVvdXQlM0QxMCUyQyUyMHZlcmJvc2UlM0RGYWxzZSklMEFyZXN1bHQlMjAlM0QlMjBhd2FpdCUyMHcucnVuKCk=",highlighted:`<span class="hljs-keyword">from</span> llama_index.core.workflow <span class="hljs-keyword">import</span> StartEvent, StopEvent, Workflow, step

<span class="hljs-keyword">class</span> <span class="hljs-title class_">MyWorkflow</span>(<span class="hljs-title class_ inherited__">Workflow</span>):
<span class="hljs-meta">    @step</span>
    <span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">my_step</span>(<span class="hljs-params">self, ev: StartEvent</span>) -&gt; StopEvent:
        <span class="hljs-comment"># do something here</span>
        <span class="hljs-keyword">return</span> StopEvent(result=<span class="hljs-string">&quot;Hello, world!&quot;</span>)


w = MyWorkflow(timeout=<span class="hljs-number">10</span>, verbose=<span class="hljs-literal">False</span>)
result = <span class="hljs-keyword">await</span> w.run()`,wrap:!1}}),S=new C({props:{title:"Connecter plusieurs étapes",local:"connecter-plusieurs-étapes",headingTag:"h3"}}),F=new v({props:{code:"ZnJvbSUyMGxsYW1hX2luZGV4LmNvcmUud29ya2Zsb3clMjBpbXBvcnQlMjBFdmVudCUwQSUwQWNsYXNzJTIwUHJvY2Vzc2luZ0V2ZW50KEV2ZW50KSUzQSUwQSUyMCUyMCUyMCUyMGludGVybWVkaWF0ZV9yZXN1bHQlM0ElMjBzdHIlMEElMEFjbGFzcyUyME11bHRpU3RlcFdvcmtmbG93KFdvcmtmbG93KSUzQSUwQSUyMCUyMCUyMCUyMCU0MHN0ZXAlMEElMjAlMjAlMjAlMjBhc3luYyUyMGRlZiUyMHN0ZXBfb25lKHNlbGYlMkMlMjBldiUzQSUyMFN0YXJ0RXZlbnQpJTIwLSUzRSUyMFByb2Nlc3NpbmdFdmVudCUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMFByb2Nlc3MlMjBpbml0aWFsJTIwZGF0YSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMFByb2Nlc3NpbmdFdmVudChpbnRlcm1lZGlhdGVfcmVzdWx0JTNEJTIyU3RlcCUyMDElMjBjb21wbGV0ZSUyMiklMEElMEElMjAlMjAlMjAlMjAlNDBzdGVwJTBBJTIwJTIwJTIwJTIwYXN5bmMlMjBkZWYlMjBzdGVwX3R3byhzZWxmJTJDJTIwZXYlM0ElMjBQcm9jZXNzaW5nRXZlbnQpJTIwLSUzRSUyMFN0b3BFdmVudCUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMFVzZSUyMHRoZSUyMGludGVybWVkaWF0ZSUyMHJlc3VsdCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGZpbmFsX3Jlc3VsdCUyMCUzRCUyMGYlMjJGaW5pc2hlZCUyMHByb2Nlc3NpbmclM0ElMjAlN0Jldi5pbnRlcm1lZGlhdGVfcmVzdWx0JTdEJTIyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwU3RvcEV2ZW50KHJlc3VsdCUzRGZpbmFsX3Jlc3VsdCklMEElMEF3JTIwJTNEJTIwTXVsdGlTdGVwV29ya2Zsb3codGltZW91dCUzRDEwJTJDJTIwdmVyYm9zZSUzREZhbHNlKSUwQXJlc3VsdCUyMCUzRCUyMGF3YWl0JTIwdy5ydW4oKSUwQXJlc3VsdA==",highlighted:`<span class="hljs-keyword">from</span> llama_index.core.workflow <span class="hljs-keyword">import</span> Event

<span class="hljs-keyword">class</span> <span class="hljs-title class_">ProcessingEvent</span>(<span class="hljs-title class_ inherited__">Event</span>):
    intermediate_result: <span class="hljs-built_in">str</span>

<span class="hljs-keyword">class</span> <span class="hljs-title class_">MultiStepWorkflow</span>(<span class="hljs-title class_ inherited__">Workflow</span>):
<span class="hljs-meta">    @step</span>
    <span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">step_one</span>(<span class="hljs-params">self, ev: StartEvent</span>) -&gt; ProcessingEvent:
        <span class="hljs-comment"># Process initial data</span>
        <span class="hljs-keyword">return</span> ProcessingEvent(intermediate_result=<span class="hljs-string">&quot;Step 1 complete&quot;</span>)

<span class="hljs-meta">    @step</span>
    <span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">step_two</span>(<span class="hljs-params">self, ev: ProcessingEvent</span>) -&gt; StopEvent:
        <span class="hljs-comment"># Use the intermediate result</span>
        final_result = <span class="hljs-string">f&quot;Finished processing: <span class="hljs-subst">{ev.intermediate_result}</span>&quot;</span>
        <span class="hljs-keyword">return</span> StopEvent(result=final_result)

w = MultiStepWorkflow(timeout=<span class="hljs-number">10</span>, verbose=<span class="hljs-literal">False</span>)
result = <span class="hljs-keyword">await</span> w.run()
result`,wrap:!1}}),R=new C({props:{title:"Boucles et branches",local:"boucles-et-branches",headingTag:"h3"}}),L=new v({props:{code:"ZnJvbSUyMGxsYW1hX2luZGV4LmNvcmUud29ya2Zsb3clMjBpbXBvcnQlMjBFdmVudCUwQWltcG9ydCUyMHJhbmRvbSUwQSUwQSUwQWNsYXNzJTIwUHJvY2Vzc2luZ0V2ZW50KEV2ZW50KSUzQSUwQSUyMCUyMCUyMCUyMGludGVybWVkaWF0ZV9yZXN1bHQlM0ElMjBzdHIlMEElMEElMEFjbGFzcyUyMExvb3BFdmVudChFdmVudCklM0ElMEElMjAlMjAlMjAlMjBsb29wX291dHB1dCUzQSUyMHN0ciUwQSUwQSUwQWNsYXNzJTIwTXVsdGlTdGVwV29ya2Zsb3coV29ya2Zsb3cpJTNBJTBBJTIwJTIwJTIwJTIwJTQwc3RlcCUwQSUyMCUyMCUyMCUyMGFzeW5jJTIwZGVmJTIwc3RlcF9vbmUoc2VsZiUyQyUyMGV2JTNBJTIwU3RhcnRFdmVudCUyMCU3QyUyMExvb3BFdmVudCklMjAtJTNFJTIwUHJvY2Vzc2luZ0V2ZW50JTIwJTdDJTIwTG9vcEV2ZW50JTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjByYW5kb20ucmFuZGludCgwJTJDJTIwMSklMjAlM0QlM0QlMjAwJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJpbnQoJTIyQmFkJTIwdGhpbmclMjBoYXBwZW5lZCUyMiklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjBMb29wRXZlbnQobG9vcF9vdXRwdXQlM0QlMjJCYWNrJTIwdG8lMjBzdGVwJTIwb25lLiUyMiklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBlbHNlJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJpbnQoJTIyR29vZCUyMHRoaW5nJTIwaGFwcGVuZWQlMjIpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwUHJvY2Vzc2luZ0V2ZW50KGludGVybWVkaWF0ZV9yZXN1bHQlM0QlMjJGaXJzdCUyMHN0ZXAlMjBjb21wbGV0ZS4lMjIpJTBBJTBBJTIwJTIwJTIwJTIwJTQwc3RlcCUwQSUyMCUyMCUyMCUyMGFzeW5jJTIwZGVmJTIwc3RlcF90d28oc2VsZiUyQyUyMGV2JTNBJTIwUHJvY2Vzc2luZ0V2ZW50KSUyMC0lM0UlMjBTdG9wRXZlbnQlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBVc2UlMjB0aGUlMjBpbnRlcm1lZGlhdGUlMjByZXN1bHQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmaW5hbF9yZXN1bHQlMjAlM0QlMjBmJTIyRmluaXNoZWQlMjBwcm9jZXNzaW5nJTNBJTIwJTdCZXYuaW50ZXJtZWRpYXRlX3Jlc3VsdCU3RCUyMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMFN0b3BFdmVudChyZXN1bHQlM0RmaW5hbF9yZXN1bHQpJTBBJTBBJTBBdyUyMCUzRCUyME11bHRpU3RlcFdvcmtmbG93KHZlcmJvc2UlM0RGYWxzZSklMEFyZXN1bHQlMjAlM0QlMjBhd2FpdCUyMHcucnVuKCklMEFyZXN1bHQ=",highlighted:`<span class="hljs-keyword">from</span> llama_index.core.workflow <span class="hljs-keyword">import</span> Event
<span class="hljs-keyword">import</span> random


<span class="hljs-keyword">class</span> <span class="hljs-title class_">ProcessingEvent</span>(<span class="hljs-title class_ inherited__">Event</span>):
    intermediate_result: <span class="hljs-built_in">str</span>


<span class="hljs-keyword">class</span> <span class="hljs-title class_">LoopEvent</span>(<span class="hljs-title class_ inherited__">Event</span>):
    loop_output: <span class="hljs-built_in">str</span>


<span class="hljs-keyword">class</span> <span class="hljs-title class_">MultiStepWorkflow</span>(<span class="hljs-title class_ inherited__">Workflow</span>):
<span class="hljs-meta">    @step</span>
    <span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">step_one</span>(<span class="hljs-params">self, ev: StartEvent | LoopEvent</span>) -&gt; ProcessingEvent | LoopEvent:
        <span class="hljs-keyword">if</span> random.randint(<span class="hljs-number">0</span>, <span class="hljs-number">1</span>) == <span class="hljs-number">0</span>:
            <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Bad thing happened&quot;</span>)
            <span class="hljs-keyword">return</span> LoopEvent(loop_output=<span class="hljs-string">&quot;Back to step one.&quot;</span>)
        <span class="hljs-keyword">else</span>:
            <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Good thing happened&quot;</span>)
            <span class="hljs-keyword">return</span> ProcessingEvent(intermediate_result=<span class="hljs-string">&quot;First step complete.&quot;</span>)

<span class="hljs-meta">    @step</span>
    <span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">step_two</span>(<span class="hljs-params">self, ev: ProcessingEvent</span>) -&gt; StopEvent:
        <span class="hljs-comment"># Use the intermediate result</span>
        final_result = <span class="hljs-string">f&quot;Finished processing: <span class="hljs-subst">{ev.intermediate_result}</span>&quot;</span>
        <span class="hljs-keyword">return</span> StopEvent(result=final_result)


w = MultiStepWorkflow(verbose=<span class="hljs-literal">False</span>)
result = <span class="hljs-keyword">await</span> w.run()
result`,wrap:!1}}),Y=new C({props:{title:"Dessiner des Workflows",local:"dessiner-des-workflows",headingTag:"h3"}}),K=new v({props:{code:"ZnJvbSUyMGxsYW1hX2luZGV4LnV0aWxzLndvcmtmbG93JTIwaW1wb3J0JTIwZHJhd19hbGxfcG9zc2libGVfZmxvd3MlMEElMEF3JTIwJTNEJTIwLi4uJTIwJTIzJTIwYXMlMjBkZWZpbmVkJTIwaW4lMjB0aGUlMjBwcmV2aW91cyUyMHNlY3Rpb24lMEFkcmF3X2FsbF9wb3NzaWJsZV9mbG93cyh3JTJDJTIwJTIyZmxvdy5odG1sJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> llama_index.utils.workflow <span class="hljs-keyword">import</span> draw_all_possible_flows

w = ... <span class="hljs-comment"># as defined in the previous section</span>
draw_all_possible_flows(w, <span class="hljs-string">&quot;flow.html&quot;</span>)`,wrap:!1}}),ss=new C({props:{title:"Gestion d’état",local:"gestion-détat",headingTag:"h3"}}),ls=new v({props:{code:"ZnJvbSUyMGxsYW1hX2luZGV4LmNvcmUud29ya2Zsb3clMjBpbXBvcnQlMjBDb250ZXh0JTJDJTIwU3RhcnRFdmVudCUyQyUyMFN0b3BFdmVudCUwQSUwQSUwQSU0MHN0ZXAlMEFhc3luYyUyMGRlZiUyMHF1ZXJ5KHNlbGYlMkMlMjBjdHglM0ElMjBDb250ZXh0JTJDJTIwZXYlM0ElMjBTdGFydEV2ZW50KSUyMC0lM0UlMjBTdG9wRXZlbnQlM0ElMEElMjAlMjAlMjAlMjAlMjMlMjBzdG9yZSUyMHF1ZXJ5JTIwaW4lMjB0aGUlMjBjb250ZXh0JTBBJTIwJTIwJTIwJTIwYXdhaXQlMjBjdHguc3RvcmUuc2V0KCUyMnF1ZXJ5JTIyJTJDJTIwJTIyV2hhdCUyMGlzJTIwdGhlJTIwY2FwaXRhbCUyMG9mJTIwRnJhbmNlJTNGJTIyKSUwQSUwQSUyMCUyMCUyMCUyMCUyMyUyMGRvJTIwc29tZXRoaW5nJTIwd2l0aCUyMGNvbnRleHQlMjBhbmQlMjBldmVudCUwQSUyMCUyMCUyMCUyMHZhbCUyMCUzRCUyMC4uLiUwQSUwQSUyMCUyMCUyMCUyMCUyMyUyMHJldHJpZXZlJTIwcXVlcnklMjBmcm9tJTIwdGhlJTIwY29udGV4dCUwQSUyMCUyMCUyMCUyMHF1ZXJ5JTIwJTNEJTIwYXdhaXQlMjBjdHguc3RvcmUuZ2V0KCUyMnF1ZXJ5JTIyKSUwQSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMFN0b3BFdmVudChyZXN1bHQlM0R2YWwp",highlighted:`<span class="hljs-keyword">from</span> llama_index.core.workflow <span class="hljs-keyword">import</span> Context, StartEvent, StopEvent


<span class="hljs-meta">@step</span>
<span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">query</span>(<span class="hljs-params">self, ctx: Context, ev: StartEvent</span>) -&gt; StopEvent:
    <span class="hljs-comment"># store query in the context</span>
    <span class="hljs-keyword">await</span> ctx.store.<span class="hljs-built_in">set</span>(<span class="hljs-string">&quot;query&quot;</span>, <span class="hljs-string">&quot;What is the capital of France?&quot;</span>)

    <span class="hljs-comment"># do something with context and event</span>
    val = ...

    <span class="hljs-comment"># retrieve query from the context</span>
    query = <span class="hljs-keyword">await</span> ctx.store.get(<span class="hljs-string">&quot;query&quot;</span>)

    <span class="hljs-keyword">return</span> StopEvent(result=val)`,wrap:!1}}),I=new Ye({props:{$$slots:{default:[nl]},$$scope:{ctx:js}}}),as=new C({props:{title:"Automatiser les workflows avec des Multi-Agent Workflows",local:"automatiser-les-workflows-avec-des-multi-agent-workflows",headingTag:"h2"}}),us=new v({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> llama_index.core.agent.workflow <span class="hljs-keyword">import</span> AgentWorkflow, ReActAgent
<span class="hljs-keyword">from</span> llama_index.llms.huggingface_api <span class="hljs-keyword">import</span> HuggingFaceInferenceAPI

<span class="hljs-comment"># Define some tools</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">add</span>(<span class="hljs-params">a: <span class="hljs-built_in">int</span>, b: <span class="hljs-built_in">int</span></span>) -&gt; <span class="hljs-built_in">int</span>:
    <span class="hljs-string">&quot;&quot;&quot;Add two numbers.&quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> a + b

<span class="hljs-keyword">def</span> <span class="hljs-title function_">multiply</span>(<span class="hljs-params">a: <span class="hljs-built_in">int</span>, b: <span class="hljs-built_in">int</span></span>) -&gt; <span class="hljs-built_in">int</span>:
    <span class="hljs-string">&quot;&quot;&quot;Multiply two numbers.&quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> a * b

llm = HuggingFaceInferenceAPI(model_name=<span class="hljs-string">&quot;Qwen/Qwen2.5-Coder-32B-Instruct&quot;</span>)

<span class="hljs-comment"># we can pass functions directly without FunctionTool -- the fn/docstring are parsed for the name/description</span>
multiply_agent = ReActAgent(
    name=<span class="hljs-string">&quot;multiply_agent&quot;</span>,
    description=<span class="hljs-string">&quot;Is able to multiply two integers&quot;</span>,
    system_prompt=<span class="hljs-string">&quot;A helpful assistant that can use a tool to multiply numbers.&quot;</span>,
    tools=[multiply],
    llm=llm,
)

addition_agent = ReActAgent(
    name=<span class="hljs-string">&quot;add_agent&quot;</span>,
    description=<span class="hljs-string">&quot;Is able to add two integers&quot;</span>,
    system_prompt=<span class="hljs-string">&quot;A helpful assistant that can use a tool to add numbers.&quot;</span>,
    tools=[add],
    llm=llm,
)

<span class="hljs-comment"># Create the workflow</span>
workflow = AgentWorkflow(
    agents=[multiply_agent, addition_agent],
    root_agent=<span class="hljs-string">&quot;multiply_agent&quot;</span>,
)

<span class="hljs-comment"># Run the system</span>
response = <span class="hljs-keyword">await</span> workflow.run(user_msg=<span class="hljs-string">&quot;Can you add 5 and 3?&quot;</span>)`,wrap:!1}}),ms=new v({props:{code:"JTBBJTBBJTBBJTBBJTBBJTBBJTBB",highlighted:`<span class="hljs-keyword">from</span> llama_index.core.workflow <span class="hljs-keyword">import</span> Context

<span class="hljs-comment"># Define some tools</span>
<span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">add</span>(<span class="hljs-params">ctx: Context, a: <span class="hljs-built_in">int</span>, b: <span class="hljs-built_in">int</span></span>) -&gt; <span class="hljs-built_in">int</span>:
    <span class="hljs-string">&quot;&quot;&quot;Add two numbers.&quot;&quot;&quot;</span>
    <span class="hljs-comment"># update our count</span>
    cur_state = <span class="hljs-keyword">await</span> ctx.store.get(<span class="hljs-string">&quot;state&quot;</span>)
    cur_state[<span class="hljs-string">&quot;num_fn_calls&quot;</span>] += <span class="hljs-number">1</span>
    <span class="hljs-keyword">await</span> ctx.store.<span class="hljs-built_in">set</span>(<span class="hljs-string">&quot;state&quot;</span>, cur_state)

    <span class="hljs-keyword">return</span> a + b

<span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">multiply</span>(<span class="hljs-params">ctx: Context, a: <span class="hljs-built_in">int</span>, b: <span class="hljs-built_in">int</span></span>) -&gt; <span class="hljs-built_in">int</span>:
    <span class="hljs-string">&quot;&quot;&quot;Multiply two numbers.&quot;&quot;&quot;</span>
    <span class="hljs-comment"># update our count</span>
    cur_state = <span class="hljs-keyword">await</span> ctx.store.get(<span class="hljs-string">&quot;state&quot;</span>)
    cur_state[<span class="hljs-string">&quot;num_fn_calls&quot;</span>] += <span class="hljs-number">1</span>
    <span class="hljs-keyword">await</span> ctx.store.<span class="hljs-built_in">set</span>(<span class="hljs-string">&quot;state&quot;</span>, cur_state)

    <span class="hljs-keyword">return</span> a * b

...

workflow = AgentWorkflow(
    agents=[multiply_agent, addition_agent],
    root_agent=<span class="hljs-string">&quot;multiply_agent&quot;</span>,
    initial_state={<span class="hljs-string">&quot;num_fn_calls&quot;</span>: <span class="hljs-number">0</span>},
    state_prompt=<span class="hljs-string">&quot;Current state: {state}. User message: {msg}&quot;</span>,
)

<span class="hljs-comment"># run the workflow with context</span>
ctx = Context(workflow)
response = <span class="hljs-keyword">await</span> workflow.run(user_msg=<span class="hljs-string">&quot;Can you add 5 and 3?&quot;</span>, ctx=ctx)

<span class="hljs-comment"># pull out and inspect the state</span>
state = <span class="hljs-keyword">await</span> ctx.store.get(<span class="hljs-string">&quot;state&quot;</span>)
<span class="hljs-built_in">print</span>(state[<span class="hljs-string">&quot;num_fn_calls&quot;</span>])`,wrap:!1}}),ys=new ll({props:{source:"https://github.com/huggingface/agents-course/blob/main/units/fr/unit2/llama-index/workflows.mdx"}}),{c(){c=o("meta"),u=n(),U=o("p"),J=n(),w(r.$$.fragment),T=n(),k=o("p"),k.innerHTML=Te,Is=n(),B=o("p"),B.innerHTML=Ue,vs=n(),g=o("p"),g.innerHTML=fe,Cs=n(),G=o("p"),G.innerHTML=he,ks=n(),Z=o("ul"),Z.innerHTML=be,Bs=n(),_=o("p"),_.innerHTML=Ie,gs=n(),$=o("p"),$.innerHTML=ve,Gs=n(),w(x.$$.fragment),Zs=n(),w(b.$$.fragment),_s=n(),w(E.$$.fragment),$s=n(),f=o("details"),Js=o("summary"),Js.textContent=Ce,ye=Us(`
Comme introduit dans la `),V=o("a"),V.textContent=ke,je=Us(`, nous pouvons installer le package *Workflow* avec la commande suivante :

	`),w(W.$$.fragment),xs=n(),H=o("p"),H.innerHTML=Be,Es=n(),w(Q.$$.fragment),Vs=n(),q=o("p"),q.innerHTML=ge,Ws=n(),w(S.$$.fragment),Hs=n(),A=o("p"),A.innerHTML=Ge,Qs=n(),w(F.$$.fragment),qs=n(),X=o("p"),X.innerHTML=Ze,Ss=n(),w(R.$$.fragment),As=n(),z=o("p"),z.innerHTML=_e,Fs=n(),N=o("p"),N.innerHTML=$e,Xs=n(),w(L.$$.fragment),Rs=n(),w(Y.$$.fragment),zs=n(),P=o("p"),P.innerHTML=xe,Ns=n(),w(K.$$.fragment),Ls=n(),D=o("p"),D.innerHTML=Ee,Ys=n(),O=o("p"),O.innerHTML=Ve,Ps=n(),w(ss.$$.fragment),Ks=n(),es=o("p"),es.innerHTML=We,Ds=n(),w(ls.$$.fragment),Os=n(),ts=o("p"),ts.innerHTML=He,se=n(),w(I.$$.fragment),ee=n(),ns=o("p"),ns.innerHTML=Qe,le=n(),w(as.$$.fragment),te=n(),os=o("p"),os.innerHTML=qe,ne=n(),ps=o("p"),ps.textContent=Se,ae=n(),is=o("ul"),is.innerHTML=Ae,oe=n(),rs=o("p"),rs.innerHTML=Fe,pe=n(),w(us.$$.fragment),ie=n(),cs=o("p"),cs.innerHTML=Xe,re=n(),ws=o("p"),ws.textContent=Re,ue=n(),w(ms.$$.fragment),ce=n(),ds=o("p"),ds.innerHTML=ze,we=n(),Ms=o("p"),Ms.textContent=Ne,me=n(),w(ys.$$.fragment),de=n(),hs=o("p"),this.h()},l(s){const e=el("svelte-u9bgzb",document.head);c=p(e,"META",{name:!0,content:!0}),e.forEach(l),u=a(s),U=p(s,"P",{}),Je(U).forEach(l),J=a(s),m(r.$$.fragment,s),T=a(s),k=p(s,"P",{"data-svelte-h":!0}),i(k)!=="svelte-5cgz8d"&&(k.innerHTML=Te),Is=a(s),B=p(s,"P",{"data-svelte-h":!0}),i(B)!=="svelte-18q7d4v"&&(B.innerHTML=Ue),vs=a(s),g=p(s,"P",{"data-svelte-h":!0}),i(g)!=="svelte-whmuha"&&(g.innerHTML=fe),Cs=a(s),G=p(s,"P",{"data-svelte-h":!0}),i(G)!=="svelte-klkse7"&&(G.innerHTML=he),ks=a(s),Z=p(s,"UL",{"data-svelte-h":!0}),i(Z)!=="svelte-1xmwb5a"&&(Z.innerHTML=be),Bs=a(s),_=p(s,"P",{"data-svelte-h":!0}),i(_)!=="svelte-1w1c494"&&(_.innerHTML=Ie),gs=a(s),$=p(s,"P",{"data-svelte-h":!0}),i($)!=="svelte-1b9bk90"&&($.innerHTML=ve),Gs=a(s),m(x.$$.fragment,s),Zs=a(s),m(b.$$.fragment,s),_s=a(s),m(E.$$.fragment,s),$s=a(s),f=p(s,"DETAILS",{});var h=Je(f);Js=p(h,"SUMMARY",{"data-svelte-h":!0}),i(Js)!=="svelte-14hi2wi"&&(Js.textContent=Ce),ye=fs(h,`
Comme introduit dans la `),V=p(h,"A",{href:!0,"data-svelte-h":!0}),i(V)!=="svelte-8reyae"&&(V.textContent=ke),je=fs(h,`, nous pouvons installer le package *Workflow* avec la commande suivante :

	`),m(W.$$.fragment,h),h.forEach(l),xs=a(s),H=p(s,"P",{"data-svelte-h":!0}),i(H)!=="svelte-1sl0sod"&&(H.innerHTML=Be),Es=a(s),m(Q.$$.fragment,s),Vs=a(s),q=p(s,"P",{"data-svelte-h":!0}),i(q)!=="svelte-931ze4"&&(q.innerHTML=ge),Ws=a(s),m(S.$$.fragment,s),Hs=a(s),A=p(s,"P",{"data-svelte-h":!0}),i(A)!=="svelte-12kywcz"&&(A.innerHTML=Ge),Qs=a(s),m(F.$$.fragment,s),qs=a(s),X=p(s,"P",{"data-svelte-h":!0}),i(X)!=="svelte-qgro0z"&&(X.innerHTML=Ze),Ss=a(s),m(R.$$.fragment,s),As=a(s),z=p(s,"P",{"data-svelte-h":!0}),i(z)!=="svelte-szxamf"&&(z.innerHTML=_e),Fs=a(s),N=p(s,"P",{"data-svelte-h":!0}),i(N)!=="svelte-1lfwgtw"&&(N.innerHTML=$e),Xs=a(s),m(L.$$.fragment,s),Rs=a(s),m(Y.$$.fragment,s),zs=a(s),P=p(s,"P",{"data-svelte-h":!0}),i(P)!=="svelte-nbppl7"&&(P.innerHTML=xe),Ns=a(s),m(K.$$.fragment,s),Ls=a(s),D=p(s,"P",{"data-svelte-h":!0}),i(D)!=="svelte-1j5vf43"&&(D.innerHTML=Ee),Ys=a(s),O=p(s,"P",{"data-svelte-h":!0}),i(O)!=="svelte-1j9ku4g"&&(O.innerHTML=Ve),Ps=a(s),m(ss.$$.fragment,s),Ks=a(s),es=p(s,"P",{"data-svelte-h":!0}),i(es)!=="svelte-1e7y3ck"&&(es.innerHTML=We),Ds=a(s),m(ls.$$.fragment,s),Os=a(s),ts=p(s,"P",{"data-svelte-h":!0}),i(ts)!=="svelte-dlbiw8"&&(ts.innerHTML=He),se=a(s),m(I.$$.fragment,s),ee=a(s),ns=p(s,"P",{"data-svelte-h":!0}),i(ns)!=="svelte-qiy9vi"&&(ns.innerHTML=Qe),le=a(s),m(as.$$.fragment,s),te=a(s),os=p(s,"P",{"data-svelte-h":!0}),i(os)!=="svelte-lpmh0e"&&(os.innerHTML=qe),ne=a(s),ps=p(s,"P",{"data-svelte-h":!0}),i(ps)!=="svelte-gkja97"&&(ps.textContent=Se),ae=a(s),is=p(s,"UL",{"data-svelte-h":!0}),i(is)!=="svelte-39di98"&&(is.innerHTML=Ae),oe=a(s),rs=p(s,"P",{"data-svelte-h":!0}),i(rs)!=="svelte-j3rou5"&&(rs.innerHTML=Fe),pe=a(s),m(us.$$.fragment,s),ie=a(s),cs=p(s,"P",{"data-svelte-h":!0}),i(cs)!=="svelte-3vdsqs"&&(cs.innerHTML=Xe),re=a(s),ws=p(s,"P",{"data-svelte-h":!0}),i(ws)!=="svelte-bbhsjt"&&(ws.textContent=Re),ue=a(s),m(ms.$$.fragment,s),ce=a(s),ds=p(s,"P",{"data-svelte-h":!0}),i(ds)!=="svelte-1kp0sqe"&&(ds.innerHTML=ze),we=a(s),Ms=p(s,"P",{"data-svelte-h":!0}),i(Ms)!=="svelte-rfxun4"&&(Ms.textContent=Ne),me=a(s),m(ys.$$.fragment,s),de=a(s),hs=p(s,"P",{}),Je(hs).forEach(l),this.h()},h(){Ts(c,"name","hf:doc:metadata"),Ts(c,"content",ol),Ts(V,"href","./llama-hub")},m(s,e){bs(document.head,c),t(s,u,e),t(s,U,e),t(s,J,e),d(r,s,e),t(s,T,e),t(s,k,e),t(s,Is,e),t(s,B,e),t(s,vs,e),t(s,g,e),t(s,Cs,e),t(s,G,e),t(s,ks,e),t(s,Z,e),t(s,Bs,e),t(s,_,e),t(s,gs,e),t(s,$,e),t(s,Gs,e),d(x,s,e),t(s,Zs,e),d(b,s,e),t(s,_s,e),d(E,s,e),t(s,$s,e),t(s,f,e),bs(f,Js),bs(f,ye),bs(f,V),bs(f,je),d(W,f,null),t(s,xs,e),t(s,H,e),t(s,Es,e),d(Q,s,e),t(s,Vs,e),t(s,q,e),t(s,Ws,e),d(S,s,e),t(s,Hs,e),t(s,A,e),t(s,Qs,e),d(F,s,e),t(s,qs,e),t(s,X,e),t(s,Ss,e),d(R,s,e),t(s,As,e),t(s,z,e),t(s,Fs,e),t(s,N,e),t(s,Xs,e),d(L,s,e),t(s,Rs,e),d(Y,s,e),t(s,zs,e),t(s,P,e),t(s,Ns,e),d(K,s,e),t(s,Ls,e),t(s,D,e),t(s,Ys,e),t(s,O,e),t(s,Ps,e),d(ss,s,e),t(s,Ks,e),t(s,es,e),t(s,Ds,e),d(ls,s,e),t(s,Os,e),t(s,ts,e),t(s,se,e),d(I,s,e),t(s,ee,e),t(s,ns,e),t(s,le,e),d(as,s,e),t(s,te,e),t(s,os,e),t(s,ne,e),t(s,ps,e),t(s,ae,e),t(s,is,e),t(s,oe,e),t(s,rs,e),t(s,pe,e),d(us,s,e),t(s,ie,e),t(s,cs,e),t(s,re,e),t(s,ws,e),t(s,ue,e),d(ms,s,e),t(s,ce,e),t(s,ds,e),t(s,we,e),t(s,Ms,e),t(s,me,e),d(ys,s,e),t(s,de,e),t(s,hs,e),Me=!0},p(s,[e]){const h={};e&2&&(h.$$scope={dirty:e,ctx:s}),b.$set(h);const Le={};e&2&&(Le.$$scope={dirty:e,ctx:s}),I.$set(Le)},i(s){Me||(M(r.$$.fragment,s),M(x.$$.fragment,s),M(b.$$.fragment,s),M(E.$$.fragment,s),M(W.$$.fragment,s),M(Q.$$.fragment,s),M(S.$$.fragment,s),M(F.$$.fragment,s),M(R.$$.fragment,s),M(L.$$.fragment,s),M(Y.$$.fragment,s),M(K.$$.fragment,s),M(ss.$$.fragment,s),M(ls.$$.fragment,s),M(I.$$.fragment,s),M(as.$$.fragment,s),M(us.$$.fragment,s),M(ms.$$.fragment,s),M(ys.$$.fragment,s),Me=!0)},o(s){y(r.$$.fragment,s),y(x.$$.fragment,s),y(b.$$.fragment,s),y(E.$$.fragment,s),y(W.$$.fragment,s),y(Q.$$.fragment,s),y(S.$$.fragment,s),y(F.$$.fragment,s),y(R.$$.fragment,s),y(L.$$.fragment,s),y(Y.$$.fragment,s),y(K.$$.fragment,s),y(ss.$$.fragment,s),y(ls.$$.fragment,s),y(I.$$.fragment,s),y(as.$$.fragment,s),y(us.$$.fragment,s),y(ms.$$.fragment,s),y(ys.$$.fragment,s),Me=!1},d(s){s&&(l(u),l(U),l(J),l(T),l(k),l(Is),l(B),l(vs),l(g),l(Cs),l(G),l(ks),l(Z),l(Bs),l(_),l(gs),l($),l(Gs),l(Zs),l(_s),l($s),l(f),l(xs),l(H),l(Es),l(Vs),l(q),l(Ws),l(Hs),l(A),l(Qs),l(qs),l(X),l(Ss),l(As),l(z),l(Fs),l(N),l(Xs),l(Rs),l(zs),l(P),l(Ns),l(Ls),l(D),l(Ys),l(O),l(Ps),l(Ks),l(es),l(Ds),l(Os),l(ts),l(se),l(ee),l(ns),l(le),l(te),l(os),l(ne),l(ps),l(ae),l(is),l(oe),l(rs),l(pe),l(ie),l(cs),l(re),l(ws),l(ue),l(ce),l(ds),l(we),l(Ms),l(me),l(de),l(hs)),l(c),j(r,s),j(x,s),j(b,s),j(E,s),j(W),j(Q,s),j(S,s),j(F,s),j(R,s),j(L,s),j(Y,s),j(K,s),j(ss,s),j(ls,s),j(I,s),j(as,s),j(us,s),j(ms,s),j(ys,s)}}}const ol='{"title":"Créer des workflows agentiques dans LlamaIndex","local":"créer-des-workflows-agentiques-dans-llamaindex","sections":[{"title":"Créer des Workflows","local":"créer-des-workflows","sections":[{"title":"Création de Workflow de base","local":"création-de-workflow-de-base","sections":[],"depth":3},{"title":"Connecter plusieurs étapes","local":"connecter-plusieurs-étapes","sections":[],"depth":3},{"title":"Boucles et branches","local":"boucles-et-branches","sections":[],"depth":3},{"title":"Dessiner des Workflows","local":"dessiner-des-workflows","sections":[],"depth":3},{"title":"Gestion d’état","local":"gestion-détat","sections":[],"depth":3}],"depth":2},{"title":"Automatiser les workflows avec des Multi-Agent Workflows","local":"automatiser-les-workflows-avec-des-multi-agent-workflows","sections":[],"depth":2}],"depth":1}';function pl(js){return De(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class dl extends Oe{constructor(c){super(),sl(this,c,pl,al,Ke,{})}}export{dl as component};
