import{s as zl,o as Ql,n as Sl}from"../chunks/scheduler.8c3d61f6.js";import{S as Yl,i as Fl,g as a,s as i,r as o,A as Dl,h as r,f as l,c as n,j as Nl,u,x as p,k as w,y as Pl,a as s,v as f,d as m,t as c,w as d}from"../chunks/index.589a98e8.js";import{T as Ll}from"../chunks/Tip.42aa8582.js";import{C as M}from"../chunks/CodeBlock.36627b28.js";import{D as El}from"../chunks/DocNotebookDropdown.108e4998.js";import{H as W,E as Al}from"../chunks/EditOnGithub.e5a8d9cb.js";function ql(Be){let h,b='💡 If you don’t have access to a GPU, you can use one for free from a GPU provider like <a href="https://colab.research.google.com/" rel="nofollow">Colab</a>!';return{c(){h=a("p"),h.innerHTML=b},l(y){h=r(y,"P",{"data-svelte-h":!0}),p(h)!=="svelte-5o248f"&&(h.innerHTML=b)},m(y,g){s(y,h,g)},p:Sl,d(y){y&&l(h)}}}function Kl(Be){let h,b="💡 We strongly suggest always running your pipelines in <code>float16</code>, and so far, we’ve rarely seen any degradation in output quality.";return{c(){h=a("p"),h.innerHTML=b},l(y){h=r(y,"P",{"data-svelte-h":!0}),p(h)!=="svelte-1i2b108"&&(h.innerHTML=b)},m(y,g){s(y,h,g)},p:Sl,d(y){y&&l(h)}}}function Ol(Be){let h,b,y,g,k,xe,V,Re,I,Ot='Getting the <a href="/docs/diffusers/pr_8498/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> to generate images in a certain style or include what you want can be tricky. Often times, you have to run the <a href="/docs/diffusers/pr_8498/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> several times before you end up with an image you’re happy with. But generating something out of nothing is a computationally intensive process, especially if you’re running inference over and over again.',Ne,H,el="This is why it’s important to get the most <em>computational</em> (speed) and <em>memory</em> (GPU vRAM) efficiency from the pipeline to reduce the time between inference cycles so you can iterate faster.",Le,C,tl='This tutorial walks you through how to generate faster and better with the <a href="/docs/diffusers/pr_8498/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>.',Se,B,ll='Begin by loading the <a href="https://huggingface.co/runwayml/stable-diffusion-v1-5" rel="nofollow"><code>runwayml/stable-diffusion-v1-5</code></a> model:',ze,X,Qe,x,sl="The example prompt you’ll use is a portrait of an old warrior chief, but feel free to use your own prompt:",Ye,R,Fe,N,De,J,Pe,L,il="One of the simplest ways to speed up inference is to place the pipeline on a GPU the same way you would with any PyTorch module:",Ee,S,Ae,z,nl='To make sure you can use the same image and improve on it, use a <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>Generator</code></a> and set a seed for <a href="./using-diffusers/reusing_seeds">reproducibility</a>:',qe,Q,Ke,Y,al="Now you can generate an image:",Oe,F,et,T,rl='<img src="https://huggingface.co/datasets/diffusers/docs-images/resolve/main/stable_diffusion_101/sd_101_1.png"/>',tt,D,pl='This process took ~30 seconds on a T4 GPU (it might be faster if your allocated GPU is better than a T4). By default, the <a href="/docs/diffusers/pr_8498/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> runs inference with full <code>float32</code> precision for 50 inference steps. You can speed this up by switching to a lower precision like <code>float16</code> or running fewer inference steps.',lt,P,ol="Let’s start by loading the model in <code>float16</code> and generate an image:",st,E,it,U,ul='<img src="https://huggingface.co/datasets/diffusers/docs-images/resolve/main/stable_diffusion_101/sd_101_2.png"/>',nt,A,fl="This time, it only took ~11 seconds to generate the image, which is almost 3x faster than before!",at,Z,rt,q,ml='Another option is to reduce the number of inference steps. Choosing a more efficient scheduler could help decrease the number of steps without sacrificing output quality. You can find which schedulers are compatible with the current model in the <a href="/docs/diffusers/pr_8498/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> by calling the <code>compatibles</code> method:',pt,K,ot,O,cl='The Stable Diffusion model uses the <a href="/docs/diffusers/pr_8498/en/api/schedulers/pndm#diffusers.PNDMScheduler">PNDMScheduler</a> by default which usually requires ~50 inference steps, but more performant schedulers like <a href="/docs/diffusers/pr_8498/en/api/schedulers/multistep_dpm_solver#diffusers.DPMSolverMultistepScheduler">DPMSolverMultistepScheduler</a>, require only ~20 or 25 inference steps. Use the <a href="/docs/diffusers/pr_8498/en/api/configuration#diffusers.ConfigMixin.from_config">from_config()</a> method to load a new scheduler:',ut,ee,ft,te,dl="Now set the <code>num_inference_steps</code> to 20:",mt,le,ct,v,hl='<img src="https://huggingface.co/datasets/diffusers/docs-images/resolve/main/stable_diffusion_101/sd_101_3.png"/>',dt,se,yl="Great, you’ve managed to cut the inference time to just 4 seconds! ⚡️",ht,ie,yt,ne,Ml="The other key to improving pipeline performance is consuming less memory, which indirectly implies more speed, since you’re often trying to maximize the number of images generated per second. The easiest way to see how many images you can generate at once is to try out different batch sizes until you get an <code>OutOfMemoryError</code> (OOM).",Mt,ae,bl="Create a function that’ll generate a batch of images from a list of prompts and <code>Generators</code>. Make sure to assign each <code>Generator</code> a seed so you can reuse it if it produces a good result.",bt,re,wt,pe,wl="Start with <code>batch_size=4</code> and see how much memory you’ve consumed:",gt,oe,Jt,ue,gl='Unless you have a GPU with more vRAM, the code above probably returned an <code>OOM</code> error! Most of the memory is taken up by the cross-attention layers. Instead of running this operation in a batch, you can run it sequentially to save a significant amount of memory. All you have to do is configure the pipeline to use the <a href="/docs/diffusers/pr_8498/en/api/pipelines/overview#diffusers.DiffusionPipeline.enable_attention_slicing">enable_attention_slicing()</a> function:',Tt,fe,Ut,me,Jl="Now try increasing the <code>batch_size</code> to 8!",Zt,ce,vt,j,Tl='<img src="https://huggingface.co/datasets/diffusers/docs-images/resolve/main/stable_diffusion_101/sd_101_5.png"/>',jt,de,Ul="Whereas before you couldn’t even generate a batch of 4 images, now you can generate a batch of 8 images at ~3.5 seconds per image! This is probably the fastest you can go on a T4 GPU without sacrificing quality.",$t,he,Gt,ye,Zl="In the last two sections, you learned how to optimize the speed of your pipeline by using <code>fp16</code>, reducing the number of inference steps by using a more performant scheduler, and enabling attention slicing to reduce memory consumption. Now you’re going to focus on how to improve the quality of generated images.",_t,Me,Wt,be,vl='The most obvious step is to use better checkpoints. The Stable Diffusion model is a good starting point, and since its official launch, several improved versions have also been released. However, using a newer version doesn’t automatically mean you’ll get better results. You’ll still have to experiment with different checkpoints yourself, and do a little research (such as using <a href="https://minimaxir.com/2022/11/stable-diffusion-negative-prompt/" rel="nofollow">negative prompts</a>) to get the best results.',kt,we,jl='As the field grows, there are more and more high-quality checkpoints finetuned to produce certain styles. Try exploring the <a href="https://huggingface.co/models?library=diffusers&amp;sort=downloads" rel="nofollow">Hub</a> and <a href="https://huggingface.co/spaces/huggingface-projects/diffusers-gallery" rel="nofollow">Diffusers Gallery</a> to find one you’re interested in!',Vt,ge,It,Je,$l='You can also try replacing the current pipeline components with a newer version. Let’s try loading the latest <a href="https://huggingface.co/stabilityai/stable-diffusion-2-1/tree/main/vae" rel="nofollow">autoencoder</a> from Stability AI into the pipeline, and generate some images:',Ht,Te,Ct,$,Gl='<img src="https://huggingface.co/datasets/diffusers/docs-images/resolve/main/stable_diffusion_101/sd_101_6.png"/>',Bt,Ue,Xt,Ze,_l="The text prompt you use to generate an image is super important, so much so that it is called <em>prompt engineering</em>. Some considerations to keep during prompt engineering are:",xt,ve,Wl="<li>How is the image or similar images of the one I want to generate stored on the internet?</li> <li>What additional detail can I give that steers the model towards the style I want?</li>",Rt,je,kl="With this in mind, let’s improve the prompt to include color and higher quality details:",Nt,$e,Lt,Ge,Vl="Generate a batch of images with the new prompt:",St,_e,zt,G,Il='<img src="https://huggingface.co/datasets/diffusers/docs-images/resolve/main/stable_diffusion_101/sd_101_7.png"/>',Qt,We,Hl="Pretty impressive! Let’s tweak the second image - corresponding to the <code>Generator</code> with a seed of <code>1</code> - a bit more by adding some text about the age of the subject:",Yt,ke,Ft,_,Cl='<img src="https://huggingface.co/datasets/diffusers/docs-images/resolve/main/stable_diffusion_101/sd_101_8.png"/>',Dt,Ve,Pt,Ie,Bl='In this tutorial, you learned how to optimize a <a href="/docs/diffusers/pr_8498/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> for computational and memory efficiency as well as improving the quality of generated outputs. If you’re interested in making your pipeline even faster, take a look at the following resources:',Et,He,Xl='<li>Learn how <a href="./optimization/torch2.0">PyTorch 2.0</a> and <a href="https://pytorch.org/docs/stable/generated/torch.compile.html" rel="nofollow"><code>torch.compile</code></a> can yield 5 - 300% faster inference speed. On an A100 GPU, inference can be up to 50% faster!</li> <li>If you can’t use PyTorch 2, we recommend you install <a href="./optimization/xformers">xFormers</a>. Its memory-efficient attention mechanism works great with PyTorch 1.13.1 for faster speed and reduced memory consumption.</li> <li>Other optimization techniques, such as model offloading, are covered in <a href="./optimization/fp16">this guide</a>.</li>',At,Ce,qt,Xe,Kt;return k=new W({props:{title:"Effective and efficient diffusion",local:"effective-and-efficient-diffusion",headingTag:"h1"}}),V=new El({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/stable_diffusion.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/stable_diffusion.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/stable_diffusion.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/stable_diffusion.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/stable_diffusion.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/stable_diffusion.ipynb"}]}}),X=new M({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUwQXBpcGVsaW5lJTIwJTNEJTIwRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2lkJTJDJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSk=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

model_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
pipeline = DiffusionPipeline.from_pretrained(model_id, use_safetensors=<span class="hljs-literal">True</span>)`,wrap:!1}}),R=new M({props:{code:"cHJvbXB0JTIwJTNEJTIwJTIycG9ydHJhaXQlMjBwaG90byUyMG9mJTIwYSUyMG9sZCUyMHdhcnJpb3IlMjBjaGllZiUyMg==",highlighted:'prompt = <span class="hljs-string">&quot;portrait photo of a old warrior chief&quot;</span>',wrap:!1}}),N=new W({props:{title:"Speed",local:"speed",headingTag:"h2"}}),J=new Ll({props:{$$slots:{default:[ql]},$$scope:{ctx:Be}}}),S=new M({props:{code:"cGlwZWxpbmUlMjAlM0QlMjBwaXBlbGluZS50byglMjJjdWRhJTIyKQ==",highlighted:'pipeline = pipeline.to(<span class="hljs-string">&quot;cuda&quot;</span>)',wrap:!1}}),Q=new M({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEFnZW5lcmF0b3IlMjAlM0QlMjB0b3JjaC5HZW5lcmF0b3IoJTIyY3VkYSUyMikubWFudWFsX3NlZWQoMCk=",highlighted:`<span class="hljs-keyword">import</span> torch

generator = torch.Generator(<span class="hljs-string">&quot;cuda&quot;</span>).manual_seed(<span class="hljs-number">0</span>)`,wrap:!1}}),F=new M({props:{code:"aW1hZ2UlMjAlM0QlMjBwaXBlbGluZShwcm9tcHQlMkMlMjBnZW5lcmF0b3IlM0RnZW5lcmF0b3IpLmltYWdlcyU1QjAlNUQlMEFpbWFnZQ==",highlighted:`image = pipeline(prompt, generator=generator).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),E=new M({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEFwaXBlbGluZSUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUpJTBBcGlwZWxpbmUlMjAlM0QlMjBwaXBlbGluZS50byglMjJjdWRhJTIyKSUwQWdlbmVyYXRvciUyMCUzRCUyMHRvcmNoLkdlbmVyYXRvciglMjJjdWRhJTIyKS5tYW51YWxfc2VlZCgwKSUwQWltYWdlJTIwJTNEJTIwcGlwZWxpbmUocHJvbXB0JTJDJTIwZ2VuZXJhdG9yJTNEZ2VuZXJhdG9yKS5pbWFnZXMlNUIwJTVEJTBBaW1hZ2U=",highlighted:`<span class="hljs-keyword">import</span> torch

pipeline = DiffusionPipeline.from_pretrained(model_id, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>)
pipeline = pipeline.to(<span class="hljs-string">&quot;cuda&quot;</span>)
generator = torch.Generator(<span class="hljs-string">&quot;cuda&quot;</span>).manual_seed(<span class="hljs-number">0</span>)
image = pipeline(prompt, generator=generator).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),Z=new Ll({props:{$$slots:{default:[Kl]},$$scope:{ctx:Be}}}),K=new M({props:{code:"cGlwZWxpbmUuc2NoZWR1bGVyLmNvbXBhdGlibGVzJTBBJTVCJTBBJTIwJTIwJTIwJTIwZGlmZnVzZXJzLnNjaGVkdWxlcnMuc2NoZWR1bGluZ19sbXNfZGlzY3JldGUuTE1TRGlzY3JldGVTY2hlZHVsZXIlMkMlMEElMjAlMjAlMjAlMjBkaWZmdXNlcnMuc2NoZWR1bGVycy5zY2hlZHVsaW5nX3VuaXBjX211bHRpc3RlcC5VbmlQQ011bHRpc3RlcFNjaGVkdWxlciUyQyUwQSUyMCUyMCUyMCUyMGRpZmZ1c2Vycy5zY2hlZHVsZXJzLnNjaGVkdWxpbmdfa19kcG1fMl9kaXNjcmV0ZS5LRFBNMkRpc2NyZXRlU2NoZWR1bGVyJTJDJTBBJTIwJTIwJTIwJTIwZGlmZnVzZXJzLnNjaGVkdWxlcnMuc2NoZWR1bGluZ19kZWlzX211bHRpc3RlcC5ERUlTTXVsdGlzdGVwU2NoZWR1bGVyJTJDJTBBJTIwJTIwJTIwJTIwZGlmZnVzZXJzLnNjaGVkdWxlcnMuc2NoZWR1bGluZ19ldWxlcl9kaXNjcmV0ZS5FdWxlckRpc2NyZXRlU2NoZWR1bGVyJTJDJTBBJTIwJTIwJTIwJTIwZGlmZnVzZXJzLnNjaGVkdWxlcnMuc2NoZWR1bGluZ19kcG1zb2x2ZXJfbXVsdGlzdGVwLkRQTVNvbHZlck11bHRpc3RlcFNjaGVkdWxlciUyQyUwQSUyMCUyMCUyMCUyMGRpZmZ1c2Vycy5zY2hlZHVsZXJzLnNjaGVkdWxpbmdfZGRwbS5ERFBNU2NoZWR1bGVyJTJDJTBBJTIwJTIwJTIwJTIwZGlmZnVzZXJzLnNjaGVkdWxlcnMuc2NoZWR1bGluZ19kcG1zb2x2ZXJfc2luZ2xlc3RlcC5EUE1Tb2x2ZXJTaW5nbGVzdGVwU2NoZWR1bGVyJTJDJTBBJTIwJTIwJTIwJTIwZGlmZnVzZXJzLnNjaGVkdWxlcnMuc2NoZWR1bGluZ19rX2RwbV8yX2FuY2VzdHJhbF9kaXNjcmV0ZS5LRFBNMkFuY2VzdHJhbERpc2NyZXRlU2NoZWR1bGVyJTJDJTBBJTIwJTIwJTIwJTIwZGlmZnVzZXJzLnV0aWxzLmR1bW15X3RvcmNoX2FuZF90b3JjaHNkZV9vYmplY3RzLkRQTVNvbHZlclNERVNjaGVkdWxlciUyQyUwQSUyMCUyMCUyMCUyMGRpZmZ1c2Vycy5zY2hlZHVsZXJzLnNjaGVkdWxpbmdfaGV1bl9kaXNjcmV0ZS5IZXVuRGlzY3JldGVTY2hlZHVsZXIlMkMlMEElMjAlMjAlMjAlMjBkaWZmdXNlcnMuc2NoZWR1bGVycy5zY2hlZHVsaW5nX3BuZG0uUE5ETVNjaGVkdWxlciUyQyUwQSUyMCUyMCUyMCUyMGRpZmZ1c2Vycy5zY2hlZHVsZXJzLnNjaGVkdWxpbmdfZXVsZXJfYW5jZXN0cmFsX2Rpc2NyZXRlLkV1bGVyQW5jZXN0cmFsRGlzY3JldGVTY2hlZHVsZXIlMkMlMEElMjAlMjAlMjAlMjBkaWZmdXNlcnMuc2NoZWR1bGVycy5zY2hlZHVsaW5nX2RkaW0uRERJTVNjaGVkdWxlciUyQyUwQSU1RA==",highlighted:`pipeline.scheduler.compatibles
[
    diffusers.schedulers.scheduling_lms_discrete.LMSDiscreteScheduler,
    diffusers.schedulers.scheduling_unipc_multistep.UniPCMultistepScheduler,
    diffusers.schedulers.scheduling_k_dpm_2_discrete.KDPM2DiscreteScheduler,
    diffusers.schedulers.scheduling_deis_multistep.DEISMultistepScheduler,
    diffusers.schedulers.scheduling_euler_discrete.EulerDiscreteScheduler,
    diffusers.schedulers.scheduling_dpmsolver_multistep.DPMSolverMultistepScheduler,
    diffusers.schedulers.scheduling_ddpm.DDPMScheduler,
    diffusers.schedulers.scheduling_dpmsolver_singlestep.DPMSolverSinglestepScheduler,
    diffusers.schedulers.scheduling_k_dpm_2_ancestral_discrete.KDPM2AncestralDiscreteScheduler,
    diffusers.utils.dummy_torch_and_torchsde_objects.DPMSolverSDEScheduler,
    diffusers.schedulers.scheduling_heun_discrete.HeunDiscreteScheduler,
    diffusers.schedulers.scheduling_pndm.PNDMScheduler,
    diffusers.schedulers.scheduling_euler_ancestral_discrete.EulerAncestralDiscreteScheduler,
    diffusers.schedulers.scheduling_ddim.DDIMScheduler,
]`,wrap:!1}}),ee=new M({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERQTVNvbHZlck11bHRpc3RlcFNjaGVkdWxlciUwQSUwQXBpcGVsaW5lLnNjaGVkdWxlciUyMCUzRCUyMERQTVNvbHZlck11bHRpc3RlcFNjaGVkdWxlci5mcm9tX2NvbmZpZyhwaXBlbGluZS5zY2hlZHVsZXIuY29uZmlnKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DPMSolverMultistepScheduler

pipeline.scheduler = DPMSolverMultistepScheduler.from_config(pipeline.scheduler.config)`,wrap:!1}}),le=new M({props:{code:"Z2VuZXJhdG9yJTIwJTNEJTIwdG9yY2guR2VuZXJhdG9yKCUyMmN1ZGElMjIpLm1hbnVhbF9zZWVkKDApJTBBaW1hZ2UlMjAlM0QlMjBwaXBlbGluZShwcm9tcHQlMkMlMjBnZW5lcmF0b3IlM0RnZW5lcmF0b3IlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNEMjApLmltYWdlcyU1QjAlNUQlMEFpbWFnZQ==",highlighted:`generator = torch.Generator(<span class="hljs-string">&quot;cuda&quot;</span>).manual_seed(<span class="hljs-number">0</span>)
image = pipeline(prompt, generator=generator, num_inference_steps=<span class="hljs-number">20</span>).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),ie=new W({props:{title:"Memory",local:"memory",headingTag:"h2"}}),re=new M({props:{code:"ZGVmJTIwZ2V0X2lucHV0cyhiYXRjaF9zaXplJTNEMSklM0ElMEElMjAlMjAlMjAlMjBnZW5lcmF0b3IlMjAlM0QlMjAlNUJ0b3JjaC5HZW5lcmF0b3IoJTIyY3VkYSUyMikubWFudWFsX3NlZWQoaSklMjBmb3IlMjBpJTIwaW4lMjByYW5nZShiYXRjaF9zaXplKSU1RCUwQSUyMCUyMCUyMCUyMHByb21wdHMlMjAlM0QlMjBiYXRjaF9zaXplJTIwKiUyMCU1QnByb21wdCU1RCUwQSUyMCUyMCUyMCUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlMjAlM0QlMjAyMCUwQSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMCU3QiUyMnByb21wdCUyMiUzQSUyMHByb21wdHMlMkMlMjAlMjJnZW5lcmF0b3IlMjIlM0ElMjBnZW5lcmF0b3IlMkMlMjAlMjJudW1faW5mZXJlbmNlX3N0ZXBzJTIyJTNBJTIwbnVtX2luZmVyZW5jZV9zdGVwcyU3RA==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_inputs</span>(<span class="hljs-params">batch_size=<span class="hljs-number">1</span></span>):
    generator = [torch.Generator(<span class="hljs-string">&quot;cuda&quot;</span>).manual_seed(i) <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(batch_size)]
    prompts = batch_size * [prompt]
    num_inference_steps = <span class="hljs-number">20</span>

    <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;prompt&quot;</span>: prompts, <span class="hljs-string">&quot;generator&quot;</span>: generator, <span class="hljs-string">&quot;num_inference_steps&quot;</span>: num_inference_steps}`,wrap:!1}}),oe=new M({props:{code:"ZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMG1ha2VfaW1hZ2VfZ3JpZCUwQSUwQWltYWdlcyUyMCUzRCUyMHBpcGVsaW5lKCoqZ2V0X2lucHV0cyhiYXRjaF9zaXplJTNENCkpLmltYWdlcyUwQW1ha2VfaW1hZ2VfZ3JpZChpbWFnZXMlMkMlMjAyJTJDJTIwMik=",highlighted:`<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> make_image_grid

images = pipeline(**get_inputs(batch_size=<span class="hljs-number">4</span>)).images
make_image_grid(images, <span class="hljs-number">2</span>, <span class="hljs-number">2</span>)`,wrap:!1}}),fe=new M({props:{code:"cGlwZWxpbmUuZW5hYmxlX2F0dGVudGlvbl9zbGljaW5nKCk=",highlighted:"pipeline.enable_attention_slicing()",wrap:!1}}),ce=new M({props:{code:"aW1hZ2VzJTIwJTNEJTIwcGlwZWxpbmUoKipnZXRfaW5wdXRzKGJhdGNoX3NpemUlM0Q4KSkuaW1hZ2VzJTBBbWFrZV9pbWFnZV9ncmlkKGltYWdlcyUyQyUyMHJvd3MlM0QyJTJDJTIwY29scyUzRDQp",highlighted:`images = pipeline(**get_inputs(batch_size=<span class="hljs-number">8</span>)).images
make_image_grid(images, rows=<span class="hljs-number">2</span>, cols=<span class="hljs-number">4</span>)`,wrap:!1}}),he=new W({props:{title:"Quality",local:"quality",headingTag:"h2"}}),Me=new W({props:{title:"Better checkpoints",local:"better-checkpoints",headingTag:"h3"}}),ge=new W({props:{title:"Better pipeline components",local:"better-pipeline-components",headingTag:"h3"}}),Te=new M({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9lbmNvZGVyS0wlMEElMEF2YWUlMjAlM0QlMjBBdXRvZW5jb2RlcktMLmZyb21fcHJldHJhaW5lZCglMjJzdGFiaWxpdHlhaSUyRnNkLXZhZS1mdC1tc2UlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYpLnRvKCUyMmN1ZGElMjIpJTBBcGlwZWxpbmUudmFlJTIwJTNEJTIwdmFlJTBBaW1hZ2VzJTIwJTNEJTIwcGlwZWxpbmUoKipnZXRfaW5wdXRzKGJhdGNoX3NpemUlM0Q4KSkuaW1hZ2VzJTBBbWFrZV9pbWFnZV9ncmlkKGltYWdlcyUyQyUyMHJvd3MlM0QyJTJDJTIwY29scyUzRDQp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoencoderKL

vae = AutoencoderKL.from_pretrained(<span class="hljs-string">&quot;stabilityai/sd-vae-ft-mse&quot;</span>, torch_dtype=torch.float16).to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipeline.vae = vae
images = pipeline(**get_inputs(batch_size=<span class="hljs-number">8</span>)).images
make_image_grid(images, rows=<span class="hljs-number">2</span>, cols=<span class="hljs-number">4</span>)`,wrap:!1}}),Ue=new W({props:{title:"Better prompt engineering",local:"better-prompt-engineering",headingTag:"h3"}}),$e=new M({props:{code:"cHJvbXB0JTIwJTJCJTNEJTIwJTIyJTJDJTIwdHJpYmFsJTIwcGFudGhlciUyMG1ha2UlMjB1cCUyQyUyMGJsdWUlMjBvbiUyMHJlZCUyQyUyMHNpZGUlMjBwcm9maWxlJTJDJTIwbG9va2luZyUyMGF3YXklMkMlMjBzZXJpb3VzJTIwZXllcyUyMiUwQXByb21wdCUyMCUyQiUzRCUyMCUyMiUyMDUwbW0lMjBwb3J0cmFpdCUyMHBob3RvZ3JhcGh5JTJDJTIwaGFyZCUyMHJpbSUyMGxpZ2h0aW5nJTIwcGhvdG9ncmFwaHktLWJldGElMjAtLWFyJTIwMiUzQTMlMjAlMjAtLWJldGElMjAtLXVwYmV0YSUyMg==",highlighted:`prompt += <span class="hljs-string">&quot;, tribal panther make up, blue on red, side profile, looking away, serious eyes&quot;</span>
prompt += <span class="hljs-string">&quot; 50mm portrait photography, hard rim lighting photography--beta --ar 2:3  --beta --upbeta&quot;</span>`,wrap:!1}}),_e=new M({props:{code:"aW1hZ2VzJTIwJTNEJTIwcGlwZWxpbmUoKipnZXRfaW5wdXRzKGJhdGNoX3NpemUlM0Q4KSkuaW1hZ2VzJTBBbWFrZV9pbWFnZV9ncmlkKGltYWdlcyUyQyUyMHJvd3MlM0QyJTJDJTIwY29scyUzRDQp",highlighted:`images = pipeline(**get_inputs(batch_size=<span class="hljs-number">8</span>)).images
make_image_grid(images, rows=<span class="hljs-number">2</span>, cols=<span class="hljs-number">4</span>)`,wrap:!1}}),ke=new M({props:{code:"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",highlighted:`prompts = [
    <span class="hljs-string">&quot;portrait photo of the oldest warrior chief, tribal panther make up, blue on red, side profile, looking away, serious eyes 50mm portrait photography, hard rim lighting photography--beta --ar 2:3  --beta --upbeta&quot;</span>,
    <span class="hljs-string">&quot;portrait photo of a old warrior chief, tribal panther make up, blue on red, side profile, looking away, serious eyes 50mm portrait photography, hard rim lighting photography--beta --ar 2:3  --beta --upbeta&quot;</span>,
    <span class="hljs-string">&quot;portrait photo of a warrior chief, tribal panther make up, blue on red, side profile, looking away, serious eyes 50mm portrait photography, hard rim lighting photography--beta --ar 2:3  --beta --upbeta&quot;</span>,
    <span class="hljs-string">&quot;portrait photo of a young warrior chief, tribal panther make up, blue on red, side profile, looking away, serious eyes 50mm portrait photography, hard rim lighting photography--beta --ar 2:3  --beta --upbeta&quot;</span>,
]

generator = [torch.Generator(<span class="hljs-string">&quot;cuda&quot;</span>).manual_seed(<span class="hljs-number">1</span>) <span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-built_in">len</span>(prompts))]
images = pipeline(prompt=prompts, generator=generator, num_inference_steps=<span class="hljs-number">25</span>).images
make_image_grid(images, <span class="hljs-number">2</span>, <span class="hljs-number">2</span>)`,wrap:!1}}),Ve=new W({props:{title:"Next steps",local:"next-steps",headingTag:"h2"}}),Ce=new Al({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/stable_diffusion.md"}}),{c(){h=a("meta"),b=i(),y=a("p"),g=i(),o(k.$$.fragment),xe=i(),o(V.$$.fragment),Re=i(),I=a("p"),I.innerHTML=Ot,Ne=i(),H=a("p"),H.innerHTML=el,Le=i(),C=a("p"),C.innerHTML=tl,Se=i(),B=a("p"),B.innerHTML=ll,ze=i(),o(X.$$.fragment),Qe=i(),x=a("p"),x.textContent=sl,Ye=i(),o(R.$$.fragment),Fe=i(),o(N.$$.fragment),De=i(),o(J.$$.fragment),Pe=i(),L=a("p"),L.textContent=il,Ee=i(),o(S.$$.fragment),Ae=i(),z=a("p"),z.innerHTML=nl,qe=i(),o(Q.$$.fragment),Ke=i(),Y=a("p"),Y.textContent=al,Oe=i(),o(F.$$.fragment),et=i(),T=a("div"),T.innerHTML=rl,tt=i(),D=a("p"),D.innerHTML=pl,lt=i(),P=a("p"),P.innerHTML=ol,st=i(),o(E.$$.fragment),it=i(),U=a("div"),U.innerHTML=ul,nt=i(),A=a("p"),A.textContent=fl,at=i(),o(Z.$$.fragment),rt=i(),q=a("p"),q.innerHTML=ml,pt=i(),o(K.$$.fragment),ot=i(),O=a("p"),O.innerHTML=cl,ut=i(),o(ee.$$.fragment),ft=i(),te=a("p"),te.innerHTML=dl,mt=i(),o(le.$$.fragment),ct=i(),v=a("div"),v.innerHTML=hl,dt=i(),se=a("p"),se.textContent=yl,ht=i(),o(ie.$$.fragment),yt=i(),ne=a("p"),ne.innerHTML=Ml,Mt=i(),ae=a("p"),ae.innerHTML=bl,bt=i(),o(re.$$.fragment),wt=i(),pe=a("p"),pe.innerHTML=wl,gt=i(),o(oe.$$.fragment),Jt=i(),ue=a("p"),ue.innerHTML=gl,Tt=i(),o(fe.$$.fragment),Ut=i(),me=a("p"),me.innerHTML=Jl,Zt=i(),o(ce.$$.fragment),vt=i(),j=a("div"),j.innerHTML=Tl,jt=i(),de=a("p"),de.textContent=Ul,$t=i(),o(he.$$.fragment),Gt=i(),ye=a("p"),ye.innerHTML=Zl,_t=i(),o(Me.$$.fragment),Wt=i(),be=a("p"),be.innerHTML=vl,kt=i(),we=a("p"),we.innerHTML=jl,Vt=i(),o(ge.$$.fragment),It=i(),Je=a("p"),Je.innerHTML=$l,Ht=i(),o(Te.$$.fragment),Ct=i(),$=a("div"),$.innerHTML=Gl,Bt=i(),o(Ue.$$.fragment),Xt=i(),Ze=a("p"),Ze.innerHTML=_l,xt=i(),ve=a("ul"),ve.innerHTML=Wl,Rt=i(),je=a("p"),je.textContent=kl,Nt=i(),o($e.$$.fragment),Lt=i(),Ge=a("p"),Ge.textContent=Vl,St=i(),o(_e.$$.fragment),zt=i(),G=a("div"),G.innerHTML=Il,Qt=i(),We=a("p"),We.innerHTML=Hl,Yt=i(),o(ke.$$.fragment),Ft=i(),_=a("div"),_.innerHTML=Cl,Dt=i(),o(Ve.$$.fragment),Pt=i(),Ie=a("p"),Ie.innerHTML=Bl,Et=i(),He=a("ul"),He.innerHTML=Xl,At=i(),o(Ce.$$.fragment),qt=i(),Xe=a("p"),this.h()},l(e){const t=Dl("svelte-u9bgzb",document.head);h=r(t,"META",{name:!0,content:!0}),t.forEach(l),b=n(e),y=r(e,"P",{}),Nl(y).forEach(l),g=n(e),u(k.$$.fragment,e),xe=n(e),u(V.$$.fragment,e),Re=n(e),I=r(e,"P",{"data-svelte-h":!0}),p(I)!=="svelte-1xpa1fd"&&(I.innerHTML=Ot),Ne=n(e),H=r(e,"P",{"data-svelte-h":!0}),p(H)!=="svelte-1s9blmo"&&(H.innerHTML=el),Le=n(e),C=r(e,"P",{"data-svelte-h":!0}),p(C)!=="svelte-1tyxcee"&&(C.innerHTML=tl),Se=n(e),B=r(e,"P",{"data-svelte-h":!0}),p(B)!=="svelte-rvt2dy"&&(B.innerHTML=ll),ze=n(e),u(X.$$.fragment,e),Qe=n(e),x=r(e,"P",{"data-svelte-h":!0}),p(x)!=="svelte-10ouxny"&&(x.textContent=sl),Ye=n(e),u(R.$$.fragment,e),Fe=n(e),u(N.$$.fragment,e),De=n(e),u(J.$$.fragment,e),Pe=n(e),L=r(e,"P",{"data-svelte-h":!0}),p(L)!=="svelte-kanimh"&&(L.textContent=il),Ee=n(e),u(S.$$.fragment,e),Ae=n(e),z=r(e,"P",{"data-svelte-h":!0}),p(z)!=="svelte-1vr43ia"&&(z.innerHTML=nl),qe=n(e),u(Q.$$.fragment,e),Ke=n(e),Y=r(e,"P",{"data-svelte-h":!0}),p(Y)!=="svelte-fvhhns"&&(Y.textContent=al),Oe=n(e),u(F.$$.fragment,e),et=n(e),T=r(e,"DIV",{class:!0,"data-svelte-h":!0}),p(T)!=="svelte-1of5nwm"&&(T.innerHTML=rl),tt=n(e),D=r(e,"P",{"data-svelte-h":!0}),p(D)!=="svelte-1e54itl"&&(D.innerHTML=pl),lt=n(e),P=r(e,"P",{"data-svelte-h":!0}),p(P)!=="svelte-11ahf9b"&&(P.innerHTML=ol),st=n(e),u(E.$$.fragment,e),it=n(e),U=r(e,"DIV",{class:!0,"data-svelte-h":!0}),p(U)!=="svelte-1why3l7"&&(U.innerHTML=ul),nt=n(e),A=r(e,"P",{"data-svelte-h":!0}),p(A)!=="svelte-19ensh2"&&(A.textContent=fl),at=n(e),u(Z.$$.fragment,e),rt=n(e),q=r(e,"P",{"data-svelte-h":!0}),p(q)!=="svelte-buf1dg"&&(q.innerHTML=ml),pt=n(e),u(K.$$.fragment,e),ot=n(e),O=r(e,"P",{"data-svelte-h":!0}),p(O)!=="svelte-1i9wi52"&&(O.innerHTML=cl),ut=n(e),u(ee.$$.fragment,e),ft=n(e),te=r(e,"P",{"data-svelte-h":!0}),p(te)!=="svelte-cj4zg7"&&(te.innerHTML=dl),mt=n(e),u(le.$$.fragment,e),ct=n(e),v=r(e,"DIV",{class:!0,"data-svelte-h":!0}),p(v)!=="svelte-19w49w4"&&(v.innerHTML=hl),dt=n(e),se=r(e,"P",{"data-svelte-h":!0}),p(se)!=="svelte-t554e8"&&(se.textContent=yl),ht=n(e),u(ie.$$.fragment,e),yt=n(e),ne=r(e,"P",{"data-svelte-h":!0}),p(ne)!=="svelte-xwat8v"&&(ne.innerHTML=Ml),Mt=n(e),ae=r(e,"P",{"data-svelte-h":!0}),p(ae)!=="svelte-ubghtf"&&(ae.innerHTML=bl),bt=n(e),u(re.$$.fragment,e),wt=n(e),pe=r(e,"P",{"data-svelte-h":!0}),p(pe)!=="svelte-136nem1"&&(pe.innerHTML=wl),gt=n(e),u(oe.$$.fragment,e),Jt=n(e),ue=r(e,"P",{"data-svelte-h":!0}),p(ue)!=="svelte-1p5n6p2"&&(ue.innerHTML=gl),Tt=n(e),u(fe.$$.fragment,e),Ut=n(e),me=r(e,"P",{"data-svelte-h":!0}),p(me)!=="svelte-1kyeye"&&(me.innerHTML=Jl),Zt=n(e),u(ce.$$.fragment,e),vt=n(e),j=r(e,"DIV",{class:!0,"data-svelte-h":!0}),p(j)!=="svelte-vxa9bu"&&(j.innerHTML=Tl),jt=n(e),de=r(e,"P",{"data-svelte-h":!0}),p(de)!=="svelte-8y2h2l"&&(de.textContent=Ul),$t=n(e),u(he.$$.fragment,e),Gt=n(e),ye=r(e,"P",{"data-svelte-h":!0}),p(ye)!=="svelte-nie66e"&&(ye.innerHTML=Zl),_t=n(e),u(Me.$$.fragment,e),Wt=n(e),be=r(e,"P",{"data-svelte-h":!0}),p(be)!=="svelte-n6uci0"&&(be.innerHTML=vl),kt=n(e),we=r(e,"P",{"data-svelte-h":!0}),p(we)!=="svelte-1m9vwtz"&&(we.innerHTML=jl),Vt=n(e),u(ge.$$.fragment,e),It=n(e),Je=r(e,"P",{"data-svelte-h":!0}),p(Je)!=="svelte-ss65n0"&&(Je.innerHTML=$l),Ht=n(e),u(Te.$$.fragment,e),Ct=n(e),$=r(e,"DIV",{class:!0,"data-svelte-h":!0}),p($)!=="svelte-610rhb"&&($.innerHTML=Gl),Bt=n(e),u(Ue.$$.fragment,e),Xt=n(e),Ze=r(e,"P",{"data-svelte-h":!0}),p(Ze)!=="svelte-1cdb512"&&(Ze.innerHTML=_l),xt=n(e),ve=r(e,"UL",{"data-svelte-h":!0}),p(ve)!=="svelte-o0cjrb"&&(ve.innerHTML=Wl),Rt=n(e),je=r(e,"P",{"data-svelte-h":!0}),p(je)!=="svelte-dljusi"&&(je.textContent=kl),Nt=n(e),u($e.$$.fragment,e),Lt=n(e),Ge=r(e,"P",{"data-svelte-h":!0}),p(Ge)!=="svelte-11z4mci"&&(Ge.textContent=Vl),St=n(e),u(_e.$$.fragment,e),zt=n(e),G=r(e,"DIV",{class:!0,"data-svelte-h":!0}),p(G)!=="svelte-n1o5lk"&&(G.innerHTML=Il),Qt=n(e),We=r(e,"P",{"data-svelte-h":!0}),p(We)!=="svelte-fmxgeo"&&(We.innerHTML=Hl),Yt=n(e),u(ke.$$.fragment,e),Ft=n(e),_=r(e,"DIV",{class:!0,"data-svelte-h":!0}),p(_)!=="svelte-1lkw2bx"&&(_.innerHTML=Cl),Dt=n(e),u(Ve.$$.fragment,e),Pt=n(e),Ie=r(e,"P",{"data-svelte-h":!0}),p(Ie)!=="svelte-lv8pxq"&&(Ie.innerHTML=Bl),Et=n(e),He=r(e,"UL",{"data-svelte-h":!0}),p(He)!=="svelte-1vrqfkr"&&(He.innerHTML=Xl),At=n(e),u(Ce.$$.fragment,e),qt=n(e),Xe=r(e,"P",{}),Nl(Xe).forEach(l),this.h()},h(){w(h,"name","hf:doc:metadata"),w(h,"content",es),w(T,"class","flex justify-center"),w(U,"class","flex justify-center"),w(v,"class","flex justify-center"),w(j,"class","flex justify-center"),w($,"class","flex justify-center"),w(G,"class","flex justify-center"),w(_,"class","flex justify-center")},m(e,t){Pl(document.head,h),s(e,b,t),s(e,y,t),s(e,g,t),f(k,e,t),s(e,xe,t),f(V,e,t),s(e,Re,t),s(e,I,t),s(e,Ne,t),s(e,H,t),s(e,Le,t),s(e,C,t),s(e,Se,t),s(e,B,t),s(e,ze,t),f(X,e,t),s(e,Qe,t),s(e,x,t),s(e,Ye,t),f(R,e,t),s(e,Fe,t),f(N,e,t),s(e,De,t),f(J,e,t),s(e,Pe,t),s(e,L,t),s(e,Ee,t),f(S,e,t),s(e,Ae,t),s(e,z,t),s(e,qe,t),f(Q,e,t),s(e,Ke,t),s(e,Y,t),s(e,Oe,t),f(F,e,t),s(e,et,t),s(e,T,t),s(e,tt,t),s(e,D,t),s(e,lt,t),s(e,P,t),s(e,st,t),f(E,e,t),s(e,it,t),s(e,U,t),s(e,nt,t),s(e,A,t),s(e,at,t),f(Z,e,t),s(e,rt,t),s(e,q,t),s(e,pt,t),f(K,e,t),s(e,ot,t),s(e,O,t),s(e,ut,t),f(ee,e,t),s(e,ft,t),s(e,te,t),s(e,mt,t),f(le,e,t),s(e,ct,t),s(e,v,t),s(e,dt,t),s(e,se,t),s(e,ht,t),f(ie,e,t),s(e,yt,t),s(e,ne,t),s(e,Mt,t),s(e,ae,t),s(e,bt,t),f(re,e,t),s(e,wt,t),s(e,pe,t),s(e,gt,t),f(oe,e,t),s(e,Jt,t),s(e,ue,t),s(e,Tt,t),f(fe,e,t),s(e,Ut,t),s(e,me,t),s(e,Zt,t),f(ce,e,t),s(e,vt,t),s(e,j,t),s(e,jt,t),s(e,de,t),s(e,$t,t),f(he,e,t),s(e,Gt,t),s(e,ye,t),s(e,_t,t),f(Me,e,t),s(e,Wt,t),s(e,be,t),s(e,kt,t),s(e,we,t),s(e,Vt,t),f(ge,e,t),s(e,It,t),s(e,Je,t),s(e,Ht,t),f(Te,e,t),s(e,Ct,t),s(e,$,t),s(e,Bt,t),f(Ue,e,t),s(e,Xt,t),s(e,Ze,t),s(e,xt,t),s(e,ve,t),s(e,Rt,t),s(e,je,t),s(e,Nt,t),f($e,e,t),s(e,Lt,t),s(e,Ge,t),s(e,St,t),f(_e,e,t),s(e,zt,t),s(e,G,t),s(e,Qt,t),s(e,We,t),s(e,Yt,t),f(ke,e,t),s(e,Ft,t),s(e,_,t),s(e,Dt,t),f(Ve,e,t),s(e,Pt,t),s(e,Ie,t),s(e,Et,t),s(e,He,t),s(e,At,t),f(Ce,e,t),s(e,qt,t),s(e,Xe,t),Kt=!0},p(e,[t]){const xl={};t&2&&(xl.$$scope={dirty:t,ctx:e}),J.$set(xl);const Rl={};t&2&&(Rl.$$scope={dirty:t,ctx:e}),Z.$set(Rl)},i(e){Kt||(m(k.$$.fragment,e),m(V.$$.fragment,e),m(X.$$.fragment,e),m(R.$$.fragment,e),m(N.$$.fragment,e),m(J.$$.fragment,e),m(S.$$.fragment,e),m(Q.$$.fragment,e),m(F.$$.fragment,e),m(E.$$.fragment,e),m(Z.$$.fragment,e),m(K.$$.fragment,e),m(ee.$$.fragment,e),m(le.$$.fragment,e),m(ie.$$.fragment,e),m(re.$$.fragment,e),m(oe.$$.fragment,e),m(fe.$$.fragment,e),m(ce.$$.fragment,e),m(he.$$.fragment,e),m(Me.$$.fragment,e),m(ge.$$.fragment,e),m(Te.$$.fragment,e),m(Ue.$$.fragment,e),m($e.$$.fragment,e),m(_e.$$.fragment,e),m(ke.$$.fragment,e),m(Ve.$$.fragment,e),m(Ce.$$.fragment,e),Kt=!0)},o(e){c(k.$$.fragment,e),c(V.$$.fragment,e),c(X.$$.fragment,e),c(R.$$.fragment,e),c(N.$$.fragment,e),c(J.$$.fragment,e),c(S.$$.fragment,e),c(Q.$$.fragment,e),c(F.$$.fragment,e),c(E.$$.fragment,e),c(Z.$$.fragment,e),c(K.$$.fragment,e),c(ee.$$.fragment,e),c(le.$$.fragment,e),c(ie.$$.fragment,e),c(re.$$.fragment,e),c(oe.$$.fragment,e),c(fe.$$.fragment,e),c(ce.$$.fragment,e),c(he.$$.fragment,e),c(Me.$$.fragment,e),c(ge.$$.fragment,e),c(Te.$$.fragment,e),c(Ue.$$.fragment,e),c($e.$$.fragment,e),c(_e.$$.fragment,e),c(ke.$$.fragment,e),c(Ve.$$.fragment,e),c(Ce.$$.fragment,e),Kt=!1},d(e){e&&(l(b),l(y),l(g),l(xe),l(Re),l(I),l(Ne),l(H),l(Le),l(C),l(Se),l(B),l(ze),l(Qe),l(x),l(Ye),l(Fe),l(De),l(Pe),l(L),l(Ee),l(Ae),l(z),l(qe),l(Ke),l(Y),l(Oe),l(et),l(T),l(tt),l(D),l(lt),l(P),l(st),l(it),l(U),l(nt),l(A),l(at),l(rt),l(q),l(pt),l(ot),l(O),l(ut),l(ft),l(te),l(mt),l(ct),l(v),l(dt),l(se),l(ht),l(yt),l(ne),l(Mt),l(ae),l(bt),l(wt),l(pe),l(gt),l(Jt),l(ue),l(Tt),l(Ut),l(me),l(Zt),l(vt),l(j),l(jt),l(de),l($t),l(Gt),l(ye),l(_t),l(Wt),l(be),l(kt),l(we),l(Vt),l(It),l(Je),l(Ht),l(Ct),l($),l(Bt),l(Xt),l(Ze),l(xt),l(ve),l(Rt),l(je),l(Nt),l(Lt),l(Ge),l(St),l(zt),l(G),l(Qt),l(We),l(Yt),l(Ft),l(_),l(Dt),l(Pt),l(Ie),l(Et),l(He),l(At),l(qt),l(Xe)),l(h),d(k,e),d(V,e),d(X,e),d(R,e),d(N,e),d(J,e),d(S,e),d(Q,e),d(F,e),d(E,e),d(Z,e),d(K,e),d(ee,e),d(le,e),d(ie,e),d(re,e),d(oe,e),d(fe,e),d(ce,e),d(he,e),d(Me,e),d(ge,e),d(Te,e),d(Ue,e),d($e,e),d(_e,e),d(ke,e),d(Ve,e),d(Ce,e)}}}const es='{"title":"Effective and efficient diffusion","local":"effective-and-efficient-diffusion","sections":[{"title":"Speed","local":"speed","sections":[],"depth":2},{"title":"Memory","local":"memory","sections":[],"depth":2},{"title":"Quality","local":"quality","sections":[{"title":"Better checkpoints","local":"better-checkpoints","sections":[],"depth":3},{"title":"Better pipeline components","local":"better-pipeline-components","sections":[],"depth":3},{"title":"Better prompt engineering","local":"better-prompt-engineering","sections":[],"depth":3}],"depth":2},{"title":"Next steps","local":"next-steps","sections":[],"depth":2}],"depth":1}';function ts(Be){return Ql(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ps extends Yl{constructor(h){super(),Fl(this,h,ts,Ol,zl,{})}}export{ps as component};
