import{s as Et,o as Pt,n as Qt}from"../chunks/scheduler.8c3d61f6.js";import{S as Lt,i as Ft,g as m,s,r as a,A as Ht,h as f,f as n,c as i,j as ve,u as l,x as h,k as je,y as x,a as o,v as r,d as p,t as d,w as c}from"../chunks/index.589a98e8.js";import{T as qt}from"../chunks/Tip.42aa8582.js";import{D as Jt}from"../chunks/Docstring.27406313.js";import{C as w}from"../chunks/CodeBlock.36627b28.js";import{E as At}from"../chunks/ExampleCodeBlock.3dc467a7.js";import{H as b,E as Ot}from"../chunks/EditOnGithub.e5a8d9cb.js";function Kt(Te){let u,J="The SD3 pipeline uses three text encoders to generate an image. Model offloading is necessary in order for it to run on most commodity hardware. Please use the <code>torch.float16</code> data type for additional memory savings.";return{c(){u=m("p"),u.innerHTML=J},l(_){u=f(_,"P",{"data-svelte-h":!0}),h(u)!=="svelte-1abcova"&&(u.innerHTML=J)},m(_,y){o(_,u,y)},p:Qt,d(_){_&&n(u)}}}function en(Te){let u,J="Examples:",_,y,M;return y=new w({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uM1BpcGVsaW5lJTBBJTBBcGlwZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvbjNQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLTMtbWVkaXVtLWRpZmZ1c2VycyUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUwQSklMEFwaXBlLnRvKCUyMmN1ZGElMjIpJTBBcHJvbXB0JTIwJTNEJTIwJTIyQSUyMGNhdCUyMGhvbGRpbmclMjBhJTIwc2lnbiUyMHRoYXQlMjBzYXlzJTIwaGVsbG8lMjB3b3JsZCUyMiUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQpLmltYWdlcyU1QjAlNUQlMEFpbWFnZS5zYXZlKCUyMnNkMy5wbmclMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusion3Pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = StableDiffusion3Pipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;stabilityai/stable-diffusion-3-medium-diffusers&quot;</span>, torch_dtype=torch.float16
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;A cat holding a sign that says hello world&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(prompt).images[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>image.save(<span class="hljs-string">&quot;sd3.png&quot;</span>)`,wrap:!1}}),{c(){u=m("p"),u.textContent=J,_=s(),a(y.$$.fragment)},l(g){u=f(g,"P",{"data-svelte-h":!0}),h(u)!=="svelte-kvfsh7"&&(u.textContent=J),_=i(g),l(y.$$.fragment,g)},m(g,T){o(g,u,T),o(g,_,T),r(y,g,T),M=!0},p:Qt,i(g){M||(p(y.$$.fragment,g),M=!0)},o(g){d(y.$$.fragment,g),M=!1},d(g){g&&(n(u),n(_)),c(y,g)}}}function tn(Te){let u,J,_,y,M,g,T,Zt='Stable Diffusion 3 (SD3) was proposed in <a href="https://arxiv.org/pdf/2403.03206.pdf" rel="nofollow">Scaling Rectified Flow Transformers for High-Resolution Image Synthesis</a> by Patrick Esser, Sumith Kulal, Andreas Blattmann, Rahim Entezari, Jonas Muller, Harry Saini, Yam Levi, Dominik Lorenz, Axel Sauer, Frederic Boesel, Dustin Podell, Tim Dockhorn, Zion English, Kyle Lacey, Alex Goodwin, Yannik Marek, and Robin Rombach.',$e,W,vt="The abstract from the paper is:",Ce,k,jt="<em>Diffusion models create data from noise by inverting the forward paths of data towards noise and have emerged as a powerful generative modeling technique for high-dimensional, perceptual data such as images and videos. Rectified flow is a recent generative model formulation that connects data and noise in a straight line. Despite its better theoretical properties and conceptual simplicity, it is not yet decisively established as standard practice. In this work, we improve existing noise sampling techniques for training rectified flow models by biasing them towards perceptually relevant scales. Through a large-scale study, we demonstrate the superior performance of this approach compared to established diffusion formulations for high-resolution text-to-image synthesis. Additionally, we present a novel transformer-based architecture for text-to-image generation that uses separate weights for the two modalities and enables a bidirectional flow of information between image and text tokens, improving text comprehension typography, and human preference ratings. We demonstrate that this architecture follows predictable scaling trends and correlates lower validation loss to improved text-to-image synthesis as measured by various metrics and human evaluations.</em>",xe,B,We,G,$t='<em>As the model is gated, before using it with diffusers you first need to go to the <a href="https://huggingface.co/stabilityai/stable-diffusion-3-medium-diffusers" rel="nofollow">Stable Diffusion 3 Medium Hugging Face page</a>, fill in the form and accept the gate. Once you are in, you need to login so that your system knows you’ve accepted the gate.</em>',ke,S,Ct="Use the command below to log in:",Be,I,Ge,$,Se,R,Ie,z,Re,X,xt="SD3 uses three text encoders, one if which is the very large T5-XXL model. This makes it challenging to run the model on GPUs with less than 24GB of VRAM, even when using <code>fp16</code> precision. The following section outlines a few memory optimizations in Diffusers that make it easier to run SD3 on low resource hardware.",ze,N,Xe,V,Wt="The most basic memory optimization available in Diffusers allows you to offload the components of the model to CPU during inference in order to save memory, while seeing a slight increase in inference latency. Model offloading will only move a model component onto the GPU when it needs to be executed, while keeping the remaining components on the CPU.",Ne,Y,Ve,D,Ye,Q,kt="Removing the memory-intensive 4.7B parameter T5-XXL text encoder during inference can significantly decrease the memory requirements for SD3 with only a slight loss in performance.",De,E,Qe,P,Ee,L,Bt="We can leverage the <code>bitsandbytes</code> library to load and quantize the T5-XXL text encoder to 8-bit precision. This allows you to keep using all three text encoders while only slightly impacting performance.",Pe,F,Gt="First install the <code>bitsandbytes</code> library.",Le,H,Fe,q,St="Then load the T5-XXL model using the <code>BitsAndBytesConfig</code>.",He,A,qe,O,It='You can find the end-to-end script <a href="https://gist.github.com/sayakpaul/82acb5976509851f2db1a83456e504f1" rel="nofollow">here</a>.',Ae,K,Oe,ee,Ke,te,Rt="Using compiled components in the SD3 pipeline can speed up inference by as much as 4X. The following code snippet demonstrates how to compile the Transformer and VAE components of the SD3 pipeline.",et,ne,tt,oe,zt='Check out the full script <a href="https://gist.github.com/sayakpaul/508d89d7aad4f454900813da5d42ca97" rel="nofollow">here</a>.',nt,se,ot,ie,Xt='Tiny AutoEncoder for Stable Diffusion (TAESD3) is a tiny distilled version of Stable Diffusion 3’s VAE by <a href="https://github.com/madebyollin/taesd" rel="nofollow">Ollin Boer Bohan</a> that can decode <a href="/docs/diffusers/pr_8324/en/api/pipelines/stable_diffusion/stable_diffusion_3#diffusers.StableDiffusion3Pipeline">StableDiffusion3Pipeline</a> latents almost instantly.',st,ae,Nt="To use with Stable Diffusion 3:",it,le,at,re,lt,pe,Vt="The <code>SD3Transformer2DModel</code> and <code>StableDiffusion3Pipeline</code> classes support loading the original checkpoints via the <code>from_single_file</code> method. This method allows you to load the original checkpoint files that were used to train the models.",rt,de,pt,ce,dt,me,ct,fe,mt,ue,ft,he,ut,ge,ht,_e,gt,U,be,Mt,Z,ye,wt,Ue,Yt="Function invoked when calling the pipeline for generation.",Tt,C,Ut,Je,Me,_t,we,bt,Ze,yt;return M=new b({props:{title:"Stable Diffusion 3",local:"stable-diffusion-3",headingTag:"h1"}}),B=new b({props:{title:"Usage Example",local:"usage-example",headingTag:"h2"}}),I=new w({props:{code:"aHVnZ2luZ2ZhY2UtY2xpJTIwbG9naW4=",highlighted:"huggingface-cli login",wrap:!1}}),$=new qt({props:{$$slots:{default:[Kt]},$$scope:{ctx:Te}}}),R=new w({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uM1BpcGVsaW5lJTBBJTBBcGlwZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvbjNQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLTMtbWVkaXVtLWRpZmZ1c2VycyUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiklMEFwaXBlLnRvKCUyMmN1ZGElMjIpJTBBJTBBaW1hZ2UlMjAlM0QlMjBwaXBlKCUwQSUyMCUyMCUyMCUyMHByb21wdCUzRCUyMmElMjBwaG90byUyMG9mJTIwYSUyMGNhdCUyMGhvbGRpbmclMjBhJTIwc2lnbiUyMHRoYXQlMjBzYXlzJTIwaGVsbG8lMjB3b3JsZCUyMiUyQyUwQSUyMCUyMCUyMCUyMG5lZ2F0aXZlX3Byb21wdCUzRCUyMiUyMiUyQyUwQSUyMCUyMCUyMCUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0QyOCUyQyUwQSUyMCUyMCUyMCUyMGhlaWdodCUzRDEwMjQlMkMlMEElMjAlMjAlMjAlMjB3aWR0aCUzRDEwMjQlMkMlMEElMjAlMjAlMjAlMjBndWlkYW5jZV9zY2FsZSUzRDcuMCUyQyUwQSkuaW1hZ2VzJTVCMCU1RCUwQSUwQWltYWdlLnNhdmUoJTIyc2QzX2hlbGxvX3dvcmxkLnBuZyUyMik=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusion3Pipeline

pipe = StableDiffusion3Pipeline.from_pretrained(<span class="hljs-string">&quot;stabilityai/stable-diffusion-3-medium-diffusers&quot;</span>, torch_dtype=torch.float16)
pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

image = pipe(
    prompt=<span class="hljs-string">&quot;a photo of a cat holding a sign that says hello world&quot;</span>,
    negative_prompt=<span class="hljs-string">&quot;&quot;</span>,
    num_inference_steps=<span class="hljs-number">28</span>,
    height=<span class="hljs-number">1024</span>,
    width=<span class="hljs-number">1024</span>,
    guidance_scale=<span class="hljs-number">7.0</span>,
).images[<span class="hljs-number">0</span>]

image.save(<span class="hljs-string">&quot;sd3_hello_world.png&quot;</span>)`,wrap:!1}}),z=new b({props:{title:"Memory Optimisations for SD3",local:"memory-optimisations-for-sd3",headingTag:"h2"}}),N=new b({props:{title:"Running Inference with Model Offloading",local:"running-inference-with-model-offloading",headingTag:"h3"}}),Y=new w({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uM1BpcGVsaW5lJTBBJTBBcGlwZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvbjNQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLTMtbWVkaXVtLWRpZmZ1c2VycyUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiklMEFwaXBlLmVuYWJsZV9tb2RlbF9jcHVfb2ZmbG9hZCgpJTBBJTBBaW1hZ2UlMjAlM0QlMjBwaXBlKCUwQSUyMCUyMCUyMCUyMHByb21wdCUzRCUyMmElMjBwaG90byUyMG9mJTIwYSUyMGNhdCUyMGhvbGRpbmclMjBhJTIwc2lnbiUyMHRoYXQlMjBzYXlzJTIwaGVsbG8lMjB3b3JsZCUyMiUyQyUwQSUyMCUyMCUyMCUyMG5lZ2F0aXZlX3Byb21wdCUzRCUyMiUyMiUyQyUwQSUyMCUyMCUyMCUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0QyOCUyQyUwQSUyMCUyMCUyMCUyMGhlaWdodCUzRDEwMjQlMkMlMEElMjAlMjAlMjAlMjB3aWR0aCUzRDEwMjQlMkMlMEElMjAlMjAlMjAlMjBndWlkYW5jZV9zY2FsZSUzRDcuMCUyQyUwQSkuaW1hZ2VzJTVCMCU1RCUwQSUwQWltYWdlLnNhdmUoJTIyc2QzX2hlbGxvX3dvcmxkLnBuZyUyMik=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusion3Pipeline

pipe = StableDiffusion3Pipeline.from_pretrained(<span class="hljs-string">&quot;stabilityai/stable-diffusion-3-medium-diffusers&quot;</span>, torch_dtype=torch.float16)
pipe.enable_model_cpu_offload()

image = pipe(
    prompt=<span class="hljs-string">&quot;a photo of a cat holding a sign that says hello world&quot;</span>,
    negative_prompt=<span class="hljs-string">&quot;&quot;</span>,
    num_inference_steps=<span class="hljs-number">28</span>,
    height=<span class="hljs-number">1024</span>,
    width=<span class="hljs-number">1024</span>,
    guidance_scale=<span class="hljs-number">7.0</span>,
).images[<span class="hljs-number">0</span>]

image.save(<span class="hljs-string">&quot;sd3_hello_world.png&quot;</span>)`,wrap:!1}}),D=new b({props:{title:"Dropping the T5 Text Encoder during Inference",local:"dropping-the-t5-text-encoder-during-inference",headingTag:"h3"}}),E=new w({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uM1BpcGVsaW5lJTBBJTBBcGlwZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvbjNQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLTMtbWVkaXVtLWRpZmZ1c2VycyUyMiUyQyUwQSUyMCUyMCUyMCUyMHRleHRfZW5jb2Rlcl8zJTNETm9uZSUyQyUwQSUyMCUyMCUyMCUyMHRva2VuaXplcl8zJTNETm9uZSUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUwQSklMEFwaXBlLnRvKCUyMmN1ZGElMjIpJTBBJTBBaW1hZ2UlMjAlM0QlMjBwaXBlKCUwQSUyMCUyMCUyMCUyMHByb21wdCUzRCUyMmElMjBwaG90byUyMG9mJTIwYSUyMGNhdCUyMGhvbGRpbmclMjBhJTIwc2lnbiUyMHRoYXQlMjBzYXlzJTIwaGVsbG8lMjB3b3JsZCUyMiUyQyUwQSUyMCUyMCUyMCUyMG5lZ2F0aXZlX3Byb21wdCUzRCUyMiUyMiUyQyUwQSUyMCUyMCUyMCUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0QyOCUyQyUwQSUyMCUyMCUyMCUyMGhlaWdodCUzRDEwMjQlMkMlMEElMjAlMjAlMjAlMjB3aWR0aCUzRDEwMjQlMkMlMEElMjAlMjAlMjAlMjBndWlkYW5jZV9zY2FsZSUzRDcuMCUyQyUwQSkuaW1hZ2VzJTVCMCU1RCUwQSUwQWltYWdlLnNhdmUoJTIyc2QzX2hlbGxvX3dvcmxkLW5vLVQ1LnBuZyUyMik=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusion3Pipeline

pipe = StableDiffusion3Pipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-3-medium-diffusers&quot;</span>,
    text_encoder_3=<span class="hljs-literal">None</span>,
    tokenizer_3=<span class="hljs-literal">None</span>,
    torch_dtype=torch.float16
)
pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

image = pipe(
    prompt=<span class="hljs-string">&quot;a photo of a cat holding a sign that says hello world&quot;</span>,
    negative_prompt=<span class="hljs-string">&quot;&quot;</span>,
    num_inference_steps=<span class="hljs-number">28</span>,
    height=<span class="hljs-number">1024</span>,
    width=<span class="hljs-number">1024</span>,
    guidance_scale=<span class="hljs-number">7.0</span>,
).images[<span class="hljs-number">0</span>]

image.save(<span class="hljs-string">&quot;sd3_hello_world-no-T5.png&quot;</span>)`,wrap:!1}}),P=new b({props:{title:"Using a Quantized Version of the T5 Text Encoder",local:"using-a-quantized-version-of-the-t5-text-encoder",headingTag:"h3"}}),H=new w({props:{code:"cGlwJTIwaW5zdGFsbCUyMGJpdHNhbmRieXRlcw==",highlighted:"pip install bitsandbytes",wrap:!1}}),A=new w({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uM1BpcGVsaW5lJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFQ1RW5jb2Rlck1vZGVsJTJDJTIwQml0c0FuZEJ5dGVzQ29uZmlnJTBBJTBBcXVhbnRpemF0aW9uX2NvbmZpZyUyMCUzRCUyMEJpdHNBbmRCeXRlc0NvbmZpZyhsb2FkX2luXzhiaXQlM0RUcnVlKSUwQSUwQW1vZGVsX2lkJTIwJTNEJTIwJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLTMtbWVkaXVtLWRpZmZ1c2VycyUyMiUwQXRleHRfZW5jb2RlciUyMCUzRCUyMFQ1RW5jb2Rlck1vZGVsLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjBtb2RlbF9pZCUyQyUwQSUyMCUyMCUyMCUyMHN1YmZvbGRlciUzRCUyMnRleHRfZW5jb2Rlcl8zJTIyJTJDJTBBJTIwJTIwJTIwJTIwcXVhbnRpemF0aW9uX2NvbmZpZyUzRHF1YW50aXphdGlvbl9jb25maWclMkMlMEEpJTBBcGlwZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvbjNQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwbW9kZWxfaWQlMkMlMEElMjAlMjAlMjAlMjB0ZXh0X2VuY29kZXJfMyUzRHRleHRfZW5jb2RlciUyQyUwQSUyMCUyMCUyMCUyMGRldmljZV9tYXAlM0QlMjJiYWxhbmNlZCUyMiUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUwQSklMEElMEFpbWFnZSUyMCUzRCUyMHBpcGUoJTBBJTIwJTIwJTIwJTIwcHJvbXB0JTNEJTIyYSUyMHBob3RvJTIwb2YlMjBhJTIwY2F0JTIwaG9sZGluZyUyMGElMjBzaWduJTIwdGhhdCUyMHNheXMlMjBoZWxsbyUyMHdvcmxkJTIyJTJDJTBBJTIwJTIwJTIwJTIwbmVnYXRpdmVfcHJvbXB0JTNEJTIyJTIyJTJDJTBBJTIwJTIwJTIwJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDI4JTJDJTBBJTIwJTIwJTIwJTIwaGVpZ2h0JTNEMTAyNCUyQyUwQSUyMCUyMCUyMCUyMHdpZHRoJTNEMTAyNCUyQyUwQSUyMCUyMCUyMCUyMGd1aWRhbmNlX3NjYWxlJTNENy4wJTJDJTBBKS5pbWFnZXMlNUIwJTVEJTBBJTBBaW1hZ2Uuc2F2ZSglMjJzZDNfaGVsbG9fd29ybGQtOGJpdC1UNS5wbmclMjIp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusion3Pipeline
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> T5EncoderModel, BitsAndBytesConfig

quantization_config = BitsAndBytesConfig(load_in_8bit=<span class="hljs-literal">True</span>)

model_id = <span class="hljs-string">&quot;stabilityai/stable-diffusion-3-medium-diffusers&quot;</span>
text_encoder = T5EncoderModel.from_pretrained(
    model_id,
    subfolder=<span class="hljs-string">&quot;text_encoder_3&quot;</span>,
    quantization_config=quantization_config,
)
pipe = StableDiffusion3Pipeline.from_pretrained(
    model_id,
    text_encoder_3=text_encoder,
    device_map=<span class="hljs-string">&quot;balanced&quot;</span>,
    torch_dtype=torch.float16
)

image = pipe(
    prompt=<span class="hljs-string">&quot;a photo of a cat holding a sign that says hello world&quot;</span>,
    negative_prompt=<span class="hljs-string">&quot;&quot;</span>,
    num_inference_steps=<span class="hljs-number">28</span>,
    height=<span class="hljs-number">1024</span>,
    width=<span class="hljs-number">1024</span>,
    guidance_scale=<span class="hljs-number">7.0</span>,
).images[<span class="hljs-number">0</span>]

image.save(<span class="hljs-string">&quot;sd3_hello_world-8bit-T5.png&quot;</span>)`,wrap:!1}}),K=new b({props:{title:"Performance Optimizations for SD3",local:"performance-optimizations-for-sd3",headingTag:"h2"}}),ee=new b({props:{title:"Using Torch Compile to Speed Up Inference",local:"using-torch-compile-to-speed-up-inference",headingTag:"h3"}}),ne=new w({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uM1BpcGVsaW5lJTBBJTBBdG9yY2guc2V0X2Zsb2F0MzJfbWF0bXVsX3ByZWNpc2lvbiglMjJoaWdoJTIyKSUwQSUwQXRvcmNoLl9pbmR1Y3Rvci5jb25maWcuY29udl8xeDFfYXNfbW0lMjAlM0QlMjBUcnVlJTBBdG9yY2guX2luZHVjdG9yLmNvbmZpZy5jb29yZGluYXRlX2Rlc2NlbnRfdHVuaW5nJTIwJTNEJTIwVHJ1ZSUwQXRvcmNoLl9pbmR1Y3Rvci5jb25maWcuZXBpbG9ndWVfZnVzaW9uJTIwJTNEJTIwRmFsc2UlMEF0b3JjaC5faW5kdWN0b3IuY29uZmlnLmNvb3JkaW5hdGVfZGVzY2VudF9jaGVja19hbGxfZGlyZWN0aW9ucyUyMCUzRCUyMFRydWUlMEElMEFwaXBlJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uM1BpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24tMy1tZWRpdW0tZGlmZnVzZXJzJTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTBBKS50byglMjJjdWRhJTIyKSUwQXBpcGUuc2V0X3Byb2dyZXNzX2Jhcl9jb25maWcoZGlzYWJsZSUzRFRydWUpJTBBJTBBcGlwZS50cmFuc2Zvcm1lci50byhtZW1vcnlfZm9ybWF0JTNEdG9yY2guY2hhbm5lbHNfbGFzdCklMEFwaXBlLnZhZS50byhtZW1vcnlfZm9ybWF0JTNEdG9yY2guY2hhbm5lbHNfbGFzdCklMEElMEFwaXBlLnRyYW5zZm9ybWVyJTIwJTNEJTIwdG9yY2guY29tcGlsZShwaXBlLnRyYW5zZm9ybWVyJTJDJTIwbW9kZSUzRCUyMm1heC1hdXRvdHVuZSUyMiUyQyUyMGZ1bGxncmFwaCUzRFRydWUpJTBBcGlwZS52YWUuZGVjb2RlJTIwJTNEJTIwdG9yY2guY29tcGlsZShwaXBlLnZhZS5kZWNvZGUlMkMlMjBtb2RlJTNEJTIybWF4LWF1dG90dW5lJTIyJTJDJTIwZnVsbGdyYXBoJTNEVHJ1ZSklMEElMEElMjMlMjBXYXJtJTIwVXAlMEFwcm9tcHQlMjAlM0QlMjAlMjJhJTIwcGhvdG8lMjBvZiUyMGElMjBjYXQlMjBob2xkaW5nJTIwYSUyMHNpZ24lMjB0aGF0JTIwc2F5cyUyMGhlbGxvJTIwd29ybGQlMjIlMEFmb3IlMjBfJTIwaW4lMjByYW5nZSgzKSUzQSUwQSUyMCUyMCUyMCUyMF8lMjAlM0QlMjBwaXBlKHByb21wdCUzRHByb21wdCUyQyUyMGdlbmVyYXRvciUzRHRvcmNoLm1hbnVhbF9zZWVkKDEpKSUwQSUwQSUyMyUyMFJ1biUyMEluZmVyZW5jZSUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQlM0Rwcm9tcHQlMkMlMjBnZW5lcmF0b3IlM0R0b3JjaC5tYW51YWxfc2VlZCgxKSkuaW1hZ2VzJTVCMCU1RCUwQWltYWdlLnNhdmUoJTIyc2QzX2hlbGxvX3dvcmxkLnBuZyUyMik=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusion3Pipeline

torch.set_float32_matmul_precision(<span class="hljs-string">&quot;high&quot;</span>)

torch._inductor.config.conv_1x1_as_mm = <span class="hljs-literal">True</span>
torch._inductor.config.coordinate_descent_tuning = <span class="hljs-literal">True</span>
torch._inductor.config.epilogue_fusion = <span class="hljs-literal">False</span>
torch._inductor.config.coordinate_descent_check_all_directions = <span class="hljs-literal">True</span>

pipe = StableDiffusion3Pipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-3-medium-diffusers&quot;</span>,
    torch_dtype=torch.float16
).to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipe.set_progress_bar_config(disable=<span class="hljs-literal">True</span>)

pipe.transformer.to(memory_format=torch.channels_last)
pipe.vae.to(memory_format=torch.channels_last)

pipe.transformer = torch.<span class="hljs-built_in">compile</span>(pipe.transformer, mode=<span class="hljs-string">&quot;max-autotune&quot;</span>, fullgraph=<span class="hljs-literal">True</span>)
pipe.vae.decode = torch.<span class="hljs-built_in">compile</span>(pipe.vae.decode, mode=<span class="hljs-string">&quot;max-autotune&quot;</span>, fullgraph=<span class="hljs-literal">True</span>)

<span class="hljs-comment"># Warm Up</span>
prompt = <span class="hljs-string">&quot;a photo of a cat holding a sign that says hello world&quot;</span>
<span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">3</span>):
    _ = pipe(prompt=prompt, generator=torch.manual_seed(<span class="hljs-number">1</span>))

<span class="hljs-comment"># Run Inference</span>
image = pipe(prompt=prompt, generator=torch.manual_seed(<span class="hljs-number">1</span>)).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;sd3_hello_world.png&quot;</span>)`,wrap:!1}}),se=new b({props:{title:"Tiny AutoEncoder for Stable Diffusion 3",local:"tiny-autoencoder-for-stable-diffusion-3",headingTag:"h2"}}),le=new w({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uM1BpcGVsaW5lJTJDJTIwQXV0b2VuY29kZXJUaW55JTBBJTBBcGlwZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvbjNQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLTMtbWVkaXVtLWRpZmZ1c2VycyUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUwQSklMEFwaXBlLnZhZSUyMCUzRCUyMEF1dG9lbmNvZGVyVGlueS5mcm9tX3ByZXRyYWluZWQoJTIybWFkZWJ5b2xsaW4lMkZ0YWVzZDMlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYpJTBBcGlwZSUyMCUzRCUyMHBpcGUudG8oJTIyY3VkYSUyMiklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJzbGljZSUyMG9mJTIwZGVsaWNpb3VzJTIwTmV3JTIwWW9yay1zdHlsZSUyMGJlcnJ5JTIwY2hlZXNlY2FrZSUyMiUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNEMjUpLmltYWdlcyU1QjAlNUQlMEFpbWFnZS5zYXZlKCUyMmNoZWVzZWNha2UucG5nJTIyKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusion3Pipeline, AutoencoderTiny

pipe = StableDiffusion3Pipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-3-medium-diffusers&quot;</span>, torch_dtype=torch.float16
)
pipe.vae = AutoencoderTiny.from_pretrained(<span class="hljs-string">&quot;madebyollin/taesd3&quot;</span>, torch_dtype=torch.float16)
pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

prompt = <span class="hljs-string">&quot;slice of delicious New York-style berry cheesecake&quot;</span>
image = pipe(prompt, num_inference_steps=<span class="hljs-number">25</span>).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;cheesecake.png&quot;</span>)`,wrap:!1}}),re=new b({props:{title:"Loading the original checkpoints via from_single_file",local:"loading-the-original-checkpoints-via-fromsinglefile",headingTag:"h2"}}),de=new b({props:{title:"Loading the original checkpoints for the SD3Transformer2DModel",local:"loading-the-original-checkpoints-for-the-sd3transformer2dmodel",headingTag:"h2"}}),ce=new w({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFNEM1RyYW5zZm9ybWVyMkRNb2RlbCUwQSUwQW1vZGVsJTIwJTNEJTIwU0QzVHJhbnNmb3JtZXIyRE1vZGVsLmZyb21fc2luZ2xlX2ZpbGUoJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRnN0YWJpbGl0eWFpJTJGc3RhYmxlLWRpZmZ1c2lvbi0zLW1lZGl1bSUyRmJsb2IlMkZtYWluJTJGc2QzX21lZGl1bS5zYWZldGVuc29ycyUyMik=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> SD3Transformer2DModel

model = SD3Transformer2DModel.from_single_file(<span class="hljs-string">&quot;https://huggingface.co/stabilityai/stable-diffusion-3-medium/blob/main/sd3_medium.safetensors&quot;</span>)`,wrap:!1}}),me=new b({props:{title:"Loading the single checkpoint for the StableDiffusion3Pipeline",local:"loading-the-single-checkpoint-for-the-stablediffusion3pipeline",headingTag:"h2"}}),fe=new b({props:{title:"Loading the single file checkpoint without T5",local:"loading-the-single-file-checkpoint-without-t5",headingTag:"h3"}}),ue=new w({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uM1BpcGVsaW5lJTBBJTBBcGlwZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvbjNQaXBlbGluZS5mcm9tX3NpbmdsZV9maWxlKCUwQSUyMCUyMCUyMCUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24tMy1tZWRpdW0lMkZibG9iJTJGbWFpbiUyRnNkM19tZWRpdW1faW5jbF9jbGlwcy5zYWZldGVuc29ycyUyMiUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUwQSUyMCUyMCUyMCUyMHRleHRfZW5jb2Rlcl8zJTNETm9uZSUwQSklMEFwaXBlLmVuYWJsZV9tb2RlbF9jcHVfb2ZmbG9hZCgpJTBBJTBBaW1hZ2UlMjAlM0QlMjBwaXBlKCUyMmElMjBwaWN0dXJlJTIwb2YlMjBhJTIwY2F0JTIwaG9sZGluZyUyMGElMjBzaWduJTIwdGhhdCUyMHNheXMlMjBoZWxsbyUyMHdvcmxkJTIyKS5pbWFnZXMlNUIwJTVEJTBBaW1hZ2Uuc2F2ZSgnc2QzLXNpbmdsZS1maWxlLnBuZycp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusion3Pipeline

pipe = StableDiffusion3Pipeline.from_single_file(
    <span class="hljs-string">&quot;https://huggingface.co/stabilityai/stable-diffusion-3-medium/blob/main/sd3_medium_incl_clips.safetensors&quot;</span>,
    torch_dtype=torch.float16,
    text_encoder_3=<span class="hljs-literal">None</span>
)
pipe.enable_model_cpu_offload()

image = pipe(<span class="hljs-string">&quot;a picture of a cat holding a sign that says hello world&quot;</span>).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&#x27;sd3-single-file.png&#x27;</span>)`,wrap:!1}}),he=new b({props:{title:"Loading the single file checkpoint without T5",local:"loading-the-single-file-checkpoint-without-t5",headingTag:"h3"}}),ge=new w({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uM1BpcGVsaW5lJTBBJTBBcGlwZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvbjNQaXBlbGluZS5mcm9tX3NpbmdsZV9maWxlKCUwQSUyMCUyMCUyMCUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24tMy1tZWRpdW0lMkZibG9iJTJGbWFpbiUyRnNkM19tZWRpdW1faW5jbF9jbGlwc190NXh4bGZwOC5zYWZldGVuc29ycyUyMiUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUwQSklMEFwaXBlLmVuYWJsZV9tb2RlbF9jcHVfb2ZmbG9hZCgpJTBBJTBBaW1hZ2UlMjAlM0QlMjBwaXBlKCUyMmElMjBwaWN0dXJlJTIwb2YlMjBhJTIwY2F0JTIwaG9sZGluZyUyMGElMjBzaWduJTIwdGhhdCUyMHNheXMlMjBoZWxsbyUyMHdvcmxkJTIyKS5pbWFnZXMlNUIwJTVEJTBBaW1hZ2Uuc2F2ZSgnc2QzLXNpbmdsZS1maWxlLXQ1LWZwOC5wbmcnKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusion3Pipeline

pipe = StableDiffusion3Pipeline.from_single_file(
    <span class="hljs-string">&quot;https://huggingface.co/stabilityai/stable-diffusion-3-medium/blob/main/sd3_medium_incl_clips_t5xxlfp8.safetensors&quot;</span>,
    torch_dtype=torch.float16,
)
pipe.enable_model_cpu_offload()

image = pipe(<span class="hljs-string">&quot;a picture of a cat holding a sign that says hello world&quot;</span>).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&#x27;sd3-single-file-t5-fp8.png&#x27;</span>)`,wrap:!1}}),_e=new b({props:{title:"StableDiffusion3Pipeline",local:"diffusers.StableDiffusion3Pipeline",headingTag:"h2"}}),be=new Jt({props:{name:"class diffusers.StableDiffusion3Pipeline",anchor:"diffusers.StableDiffusion3Pipeline",parameters:[{name:"transformer",val:": SD3Transformer2DModel"},{name:"scheduler",val:": FlowMatchEulerDiscreteScheduler"},{name:"vae",val:": AutoencoderKL"},{name:"text_encoder",val:": CLIPTextModelWithProjection"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"text_encoder_2",val:": CLIPTextModelWithProjection"},{name:"tokenizer_2",val:": CLIPTokenizer"},{name:"text_encoder_3",val:": T5EncoderModel"},{name:"tokenizer_3",val:": T5TokenizerFast"}],parametersDescription:[{anchor:"diffusers.StableDiffusion3Pipeline.transformer",description:`<strong>transformer</strong> (<a href="/docs/diffusers/pr_8324/en/api/models/sd3_transformer2d#diffusers.SD3Transformer2DModel">SD3Transformer2DModel</a>) &#x2014;
Conditional Transformer (MMDiT) architecture to denoise the encoded image latents.`,name:"transformer"},{anchor:"diffusers.StableDiffusion3Pipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/pr_8324/en/api/schedulers/flow_match_euler_discrete#diffusers.FlowMatchEulerDiscreteScheduler">FlowMatchEulerDiscreteScheduler</a>) &#x2014;
A scheduler to be used in combination with <code>transformer</code> to denoise the encoded image latents.`,name:"scheduler"},{anchor:"diffusers.StableDiffusion3Pipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/pr_8324/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.StableDiffusion3Pipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>CLIPTextModelWithProjection</code>) &#x2014;
<a href="https://huggingface.co/docs/transformers/model_doc/clip#transformers.CLIPTextModelWithProjection" rel="nofollow">CLIP</a>,
specifically the <a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a> variant,
with an additional added projection layer that is initialized with a diagonal matrix with the <code>hidden_size</code>
as its dimension.`,name:"text_encoder"},{anchor:"diffusers.StableDiffusion3Pipeline.text_encoder_2",description:`<strong>text_encoder_2</strong> (<code>CLIPTextModelWithProjection</code>) &#x2014;
<a href="https://huggingface.co/docs/transformers/model_doc/clip#transformers.CLIPTextModelWithProjection" rel="nofollow">CLIP</a>,
specifically the
<a href="https://huggingface.co/laion/CLIP-ViT-bigG-14-laion2B-39B-b160k" rel="nofollow">laion/CLIP-ViT-bigG-14-laion2B-39B-b160k</a>
variant.`,name:"text_encoder_2"},{anchor:"diffusers.StableDiffusion3Pipeline.text_encoder_3",description:`<strong>text_encoder_3</strong> (<code>T5EncoderModel</code>) &#x2014;
Frozen text-encoder. Stable Diffusion 3 uses
<a href="https://huggingface.co/docs/transformers/model_doc/t5#transformers.T5EncoderModel" rel="nofollow">T5</a>, specifically the
<a href="https://huggingface.co/google/t5-v1_1-xxl" rel="nofollow">t5-v1_1-xxl</a> variant.`,name:"text_encoder_3"},{anchor:"diffusers.StableDiffusion3Pipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>CLIPTokenizer</code>) &#x2014;
Tokenizer of class
<a href="https://huggingface.co/docs/transformers/v4.21.0/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>.`,name:"tokenizer"},{anchor:"diffusers.StableDiffusion3Pipeline.tokenizer_2",description:`<strong>tokenizer_2</strong> (<code>CLIPTokenizer</code>) &#x2014;
Second Tokenizer of class
<a href="https://huggingface.co/docs/transformers/v4.21.0/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>.`,name:"tokenizer_2"},{anchor:"diffusers.StableDiffusion3Pipeline.tokenizer_3",description:`<strong>tokenizer_3</strong> (<code>T5TokenizerFast</code>) &#x2014;
Tokenizer of class
<a href="https://huggingface.co/docs/transformers/model_doc/t5#transformers.T5Tokenizer" rel="nofollow">T5Tokenizer</a>.`,name:"tokenizer_3"}],source:"https://github.com/huggingface/diffusers/blob/vr_8324/src/diffusers/pipelines/stable_diffusion_3/pipeline_stable_diffusion_3.py#L128"}}),ye=new Jt({props:{name:"__call__",anchor:"diffusers.StableDiffusion3Pipeline.__call__",parameters:[{name:"prompt",val:": Union = None"},{name:"prompt_2",val:": Union = None"},{name:"prompt_3",val:": Union = None"},{name:"height",val:": Optional = None"},{name:"width",val:": Optional = None"},{name:"num_inference_steps",val:": int = 28"},{name:"timesteps",val:": List = None"},{name:"guidance_scale",val:": float = 7.0"},{name:"negative_prompt",val:": Union = None"},{name:"negative_prompt_2",val:": Union = None"},{name:"negative_prompt_3",val:": Union = None"},{name:"num_images_per_prompt",val:": Optional = 1"},{name:"generator",val:": Union = None"},{name:"latents",val:": Optional = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"pooled_prompt_embeds",val:": Optional = None"},{name:"negative_pooled_prompt_embeds",val:": Optional = None"},{name:"output_type",val:": Optional = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"joint_attention_kwargs",val:": Optional = None"},{name:"clip_skip",val:": Optional = None"},{name:"callback_on_step_end",val:": Optional = None"},{name:"callback_on_step_end_tensor_inputs",val:": List = ['latents']"},{name:"max_sequence_length",val:": int = 256"}],parametersDescription:[{anchor:"diffusers.StableDiffusion3Pipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide the image generation. If not defined, one has to pass <code>prompt_embeds</code>.
instead.`,name:"prompt"},{anchor:"diffusers.StableDiffusion3Pipeline.__call__.prompt_2",description:`<strong>prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to be sent to <code>tokenizer_2</code> and <code>text_encoder_2</code>. If not defined, <code>prompt</code> is
will be used instead`,name:"prompt_2"},{anchor:"diffusers.StableDiffusion3Pipeline.__call__.prompt_3",description:`<strong>prompt_3</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to be sent to <code>tokenizer_3</code> and <code>text_encoder_3</code>. If not defined, <code>prompt</code> is
will be used instead`,name:"prompt_3"},{anchor:"diffusers.StableDiffusion3Pipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to self.unet.config.sample_size * self.vae_scale_factor) &#x2014;
The height in pixels of the generated image. This is set to 1024 by default for the best results.`,name:"height"},{anchor:"diffusers.StableDiffusion3Pipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to self.unet.config.sample_size * self.vae_scale_factor) &#x2014;
The width in pixels of the generated image. This is set to 1024 by default for the best results.`,name:"width"},{anchor:"diffusers.StableDiffusion3Pipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.StableDiffusion3Pipeline.__call__.timesteps",description:`<strong>timesteps</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Custom timesteps to use for the denoising process with schedulers which support a <code>timesteps</code> argument
in their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is
passed will be used. Must be in descending order.`,name:"timesteps"},{anchor:"diffusers.StableDiffusion3Pipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 5.0) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.StableDiffusion3Pipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.StableDiffusion3Pipeline.__call__.negative_prompt_2",description:`<strong>negative_prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation to be sent to <code>tokenizer_2</code> and
<code>text_encoder_2</code>. If not defined, <code>negative_prompt</code> is used instead`,name:"negative_prompt_2"},{anchor:"diffusers.StableDiffusion3Pipeline.__call__.negative_prompt_3",description:`<strong>negative_prompt_3</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation to be sent to <code>tokenizer_3</code> and
<code>text_encoder_3</code>. If not defined, <code>negative_prompt</code> is used instead`,name:"negative_prompt_3"},{anchor:"diffusers.StableDiffusion3Pipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.StableDiffusion3Pipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.StableDiffusion3Pipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.StableDiffusion3Pipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.StableDiffusion3Pipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.StableDiffusion3Pipeline.__call__.pooled_prompt_embeds",description:`<strong>pooled_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting.
If not provided, pooled text embeddings will be generated from <code>prompt</code> input argument.`,name:"pooled_prompt_embeds"},{anchor:"diffusers.StableDiffusion3Pipeline.__call__.negative_pooled_prompt_embeds",description:`<strong>negative_pooled_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, pooled negative_prompt_embeds will be generated from <code>negative_prompt</code>
input argument.`,name:"negative_pooled_prompt_embeds"},{anchor:"diffusers.StableDiffusion3Pipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between
<a href="https://pillow.readthedocs.io/en/stable/" rel="nofollow">PIL</a>: <code>PIL.Image.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.StableDiffusion3Pipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>~pipelines.stable_diffusion_xl.StableDiffusionXLPipelineOutput</code> instead
of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.StableDiffusion3Pipeline.__call__.joint_attention_kwargs",description:`<strong>joint_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined under
<code>self.processor</code> in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow">diffusers.models.attention_processor</a>.`,name:"joint_attention_kwargs"},{anchor:"diffusers.StableDiffusion3Pipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a list of all tensors as specified by
<code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.StableDiffusion3Pipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"},{anchor:"diffusers.StableDiffusion3Pipeline.__call__.max_sequence_length",description:"<strong>max_sequence_length</strong> (<code>int</code> defaults to 256) &#x2014; Maximum sequence length to use with the <code>prompt</code>.",name:"max_sequence_length"}],source:"https://github.com/huggingface/diffusers/blob/vr_8324/src/diffusers/pipelines/stable_diffusion_3/pipeline_stable_diffusion_3.py#L628",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.stable_diffusion_xl.StableDiffusionXLPipelineOutput</code> if <code>return_dict</code> is True, otherwise a
<code>tuple</code>. When returning a tuple, the first element is a list with the generated images.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.stable_diffusion_xl.StableDiffusionXLPipelineOutput</code> or <code>tuple</code></p>
`}}),C=new At({props:{anchor:"diffusers.StableDiffusion3Pipeline.__call__.example",$$slots:{default:[en]},$$scope:{ctx:Te}}}),Me=new Jt({props:{name:"encode_prompt",anchor:"diffusers.StableDiffusion3Pipeline.encode_prompt",parameters:[{name:"prompt",val:": Union"},{name:"prompt_2",val:": Union"},{name:"prompt_3",val:": Union"},{name:"device",val:": Optional = None"},{name:"num_images_per_prompt",val:": int = 1"},{name:"do_classifier_free_guidance",val:": bool = True"},{name:"negative_prompt",val:": Union = None"},{name:"negative_prompt_2",val:": Union = None"},{name:"negative_prompt_3",val:": Union = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"pooled_prompt_embeds",val:": Optional = None"},{name:"negative_pooled_prompt_embeds",val:": Optional = None"},{name:"clip_skip",val:": Optional = None"},{name:"max_sequence_length",val:": int = 256"}],parametersDescription:[{anchor:"diffusers.StableDiffusion3Pipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded`,name:"prompt"},{anchor:"diffusers.StableDiffusion3Pipeline.encode_prompt.prompt_2",description:`<strong>prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to be sent to the <code>tokenizer_2</code> and <code>text_encoder_2</code>. If not defined, <code>prompt</code> is
used in all text-encoders`,name:"prompt_2"},{anchor:"diffusers.StableDiffusion3Pipeline.encode_prompt.prompt_3",description:`<strong>prompt_3</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to be sent to the <code>tokenizer_3</code> and <code>text_encoder_3</code>. If not defined, <code>prompt</code> is
used in all text-encoders
device &#x2014; (<code>torch.device</code>):
torch device`,name:"prompt_3"},{anchor:"diffusers.StableDiffusion3Pipeline.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>) &#x2014;
number of images that should be generated per prompt`,name:"num_images_per_prompt"},{anchor:"diffusers.StableDiffusion3Pipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>) &#x2014;
whether to use classifier free guidance or not`,name:"do_classifier_free_guidance"},{anchor:"diffusers.StableDiffusion3Pipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.StableDiffusion3Pipeline.encode_prompt.negative_prompt_2",description:`<strong>negative_prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation to be sent to <code>tokenizer_2</code> and
<code>text_encoder_2</code>. If not defined, <code>negative_prompt</code> is used in all the text-encoders.`,name:"negative_prompt_2"},{anchor:"diffusers.StableDiffusion3Pipeline.encode_prompt.negative_prompt_2",description:`<strong>negative_prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation to be sent to <code>tokenizer_3</code> and
<code>text_encoder_3</code>. If not defined, <code>negative_prompt</code> is used in both text-encoders`,name:"negative_prompt_2"},{anchor:"diffusers.StableDiffusion3Pipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.StableDiffusion3Pipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.StableDiffusion3Pipeline.encode_prompt.pooled_prompt_embeds",description:`<strong>pooled_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting.
If not provided, pooled text embeddings will be generated from <code>prompt</code> input argument.`,name:"pooled_prompt_embeds"},{anchor:"diffusers.StableDiffusion3Pipeline.encode_prompt.negative_pooled_prompt_embeds",description:`<strong>negative_pooled_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, pooled negative_prompt_embeds will be generated from <code>negative_prompt</code>
input argument.`,name:"negative_pooled_prompt_embeds"},{anchor:"diffusers.StableDiffusion3Pipeline.encode_prompt.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"}],source:"https://github.com/huggingface/diffusers/blob/vr_8324/src/diffusers/pipelines/stable_diffusion_3/pipeline_stable_diffusion_3.py#L311"}}),we=new Ot({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/api/pipelines/stable_diffusion/stable_diffusion_3.md"}}),{c(){u=m("meta"),J=s(),_=m("p"),y=s(),a(M.$$.fragment),g=s(),T=m("p"),T.innerHTML=Zt,$e=s(),W=m("p"),W.textContent=vt,Ce=s(),k=m("p"),k.innerHTML=jt,xe=s(),a(B.$$.fragment),We=s(),G=m("p"),G.innerHTML=$t,ke=s(),S=m("p"),S.textContent=Ct,Be=s(),a(I.$$.fragment),Ge=s(),a($.$$.fragment),Se=s(),a(R.$$.fragment),Ie=s(),a(z.$$.fragment),Re=s(),X=m("p"),X.innerHTML=xt,ze=s(),a(N.$$.fragment),Xe=s(),V=m("p"),V.textContent=Wt,Ne=s(),a(Y.$$.fragment),Ve=s(),a(D.$$.fragment),Ye=s(),Q=m("p"),Q.textContent=kt,De=s(),a(E.$$.fragment),Qe=s(),a(P.$$.fragment),Ee=s(),L=m("p"),L.innerHTML=Bt,Pe=s(),F=m("p"),F.innerHTML=Gt,Le=s(),a(H.$$.fragment),Fe=s(),q=m("p"),q.innerHTML=St,He=s(),a(A.$$.fragment),qe=s(),O=m("p"),O.innerHTML=It,Ae=s(),a(K.$$.fragment),Oe=s(),a(ee.$$.fragment),Ke=s(),te=m("p"),te.textContent=Rt,et=s(),a(ne.$$.fragment),tt=s(),oe=m("p"),oe.innerHTML=zt,nt=s(),a(se.$$.fragment),ot=s(),ie=m("p"),ie.innerHTML=Xt,st=s(),ae=m("p"),ae.textContent=Nt,it=s(),a(le.$$.fragment),at=s(),a(re.$$.fragment),lt=s(),pe=m("p"),pe.innerHTML=Vt,rt=s(),a(de.$$.fragment),pt=s(),a(ce.$$.fragment),dt=s(),a(me.$$.fragment),ct=s(),a(fe.$$.fragment),mt=s(),a(ue.$$.fragment),ft=s(),a(he.$$.fragment),ut=s(),a(ge.$$.fragment),ht=s(),a(_e.$$.fragment),gt=s(),U=m("div"),a(be.$$.fragment),Mt=s(),Z=m("div"),a(ye.$$.fragment),wt=s(),Ue=m("p"),Ue.textContent=Yt,Tt=s(),a(C.$$.fragment),Ut=s(),Je=m("div"),a(Me.$$.fragment),_t=s(),a(we.$$.fragment),bt=s(),Ze=m("p"),this.h()},l(e){const t=Ht("svelte-u9bgzb",document.head);u=f(t,"META",{name:!0,content:!0}),t.forEach(n),J=i(e),_=f(e,"P",{}),ve(_).forEach(n),y=i(e),l(M.$$.fragment,e),g=i(e),T=f(e,"P",{"data-svelte-h":!0}),h(T)!=="svelte-3c386r"&&(T.innerHTML=Zt),$e=i(e),W=f(e,"P",{"data-svelte-h":!0}),h(W)!=="svelte-1cwsb16"&&(W.textContent=vt),Ce=i(e),k=f(e,"P",{"data-svelte-h":!0}),h(k)!=="svelte-vkvbjo"&&(k.innerHTML=jt),xe=i(e),l(B.$$.fragment,e),We=i(e),G=f(e,"P",{"data-svelte-h":!0}),h(G)!=="svelte-mtsbjp"&&(G.innerHTML=$t),ke=i(e),S=f(e,"P",{"data-svelte-h":!0}),h(S)!=="svelte-12sg8l0"&&(S.textContent=Ct),Be=i(e),l(I.$$.fragment,e),Ge=i(e),l($.$$.fragment,e),Se=i(e),l(R.$$.fragment,e),Ie=i(e),l(z.$$.fragment,e),Re=i(e),X=f(e,"P",{"data-svelte-h":!0}),h(X)!=="svelte-1ovwj93"&&(X.innerHTML=xt),ze=i(e),l(N.$$.fragment,e),Xe=i(e),V=f(e,"P",{"data-svelte-h":!0}),h(V)!=="svelte-uyrglw"&&(V.textContent=Wt),Ne=i(e),l(Y.$$.fragment,e),Ve=i(e),l(D.$$.fragment,e),Ye=i(e),Q=f(e,"P",{"data-svelte-h":!0}),h(Q)!=="svelte-k4awn"&&(Q.textContent=kt),De=i(e),l(E.$$.fragment,e),Qe=i(e),l(P.$$.fragment,e),Ee=i(e),L=f(e,"P",{"data-svelte-h":!0}),h(L)!=="svelte-vcvc4f"&&(L.innerHTML=Bt),Pe=i(e),F=f(e,"P",{"data-svelte-h":!0}),h(F)!=="svelte-1t2mxsa"&&(F.innerHTML=Gt),Le=i(e),l(H.$$.fragment,e),Fe=i(e),q=f(e,"P",{"data-svelte-h":!0}),h(q)!=="svelte-1pykif5"&&(q.innerHTML=St),He=i(e),l(A.$$.fragment,e),qe=i(e),O=f(e,"P",{"data-svelte-h":!0}),h(O)!=="svelte-bsz29z"&&(O.innerHTML=It),Ae=i(e),l(K.$$.fragment,e),Oe=i(e),l(ee.$$.fragment,e),Ke=i(e),te=f(e,"P",{"data-svelte-h":!0}),h(te)!=="svelte-x56fi6"&&(te.textContent=Rt),et=i(e),l(ne.$$.fragment,e),tt=i(e),oe=f(e,"P",{"data-svelte-h":!0}),h(oe)!=="svelte-d39h5a"&&(oe.innerHTML=zt),nt=i(e),l(se.$$.fragment,e),ot=i(e),ie=f(e,"P",{"data-svelte-h":!0}),h(ie)!=="svelte-qpezj7"&&(ie.innerHTML=Xt),st=i(e),ae=f(e,"P",{"data-svelte-h":!0}),h(ae)!=="svelte-cj7nlj"&&(ae.textContent=Nt),it=i(e),l(le.$$.fragment,e),at=i(e),l(re.$$.fragment,e),lt=i(e),pe=f(e,"P",{"data-svelte-h":!0}),h(pe)!=="svelte-1pvw0yz"&&(pe.innerHTML=Vt),rt=i(e),l(de.$$.fragment,e),pt=i(e),l(ce.$$.fragment,e),dt=i(e),l(me.$$.fragment,e),ct=i(e),l(fe.$$.fragment,e),mt=i(e),l(ue.$$.fragment,e),ft=i(e),l(he.$$.fragment,e),ut=i(e),l(ge.$$.fragment,e),ht=i(e),l(_e.$$.fragment,e),gt=i(e),U=f(e,"DIV",{class:!0});var v=ve(U);l(be.$$.fragment,v),Mt=i(v),Z=f(v,"DIV",{class:!0});var j=ve(Z);l(ye.$$.fragment,j),wt=i(j),Ue=f(j,"P",{"data-svelte-h":!0}),h(Ue)!=="svelte-v78lg8"&&(Ue.textContent=Yt),Tt=i(j),l(C.$$.fragment,j),j.forEach(n),Ut=i(v),Je=f(v,"DIV",{class:!0});var Dt=ve(Je);l(Me.$$.fragment,Dt),Dt.forEach(n),v.forEach(n),_t=i(e),l(we.$$.fragment,e),bt=i(e),Ze=f(e,"P",{}),ve(Ze).forEach(n),this.h()},h(){je(u,"name","hf:doc:metadata"),je(u,"content",nn),je(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),je(Je,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),je(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){x(document.head,u),o(e,J,t),o(e,_,t),o(e,y,t),r(M,e,t),o(e,g,t),o(e,T,t),o(e,$e,t),o(e,W,t),o(e,Ce,t),o(e,k,t),o(e,xe,t),r(B,e,t),o(e,We,t),o(e,G,t),o(e,ke,t),o(e,S,t),o(e,Be,t),r(I,e,t),o(e,Ge,t),r($,e,t),o(e,Se,t),r(R,e,t),o(e,Ie,t),r(z,e,t),o(e,Re,t),o(e,X,t),o(e,ze,t),r(N,e,t),o(e,Xe,t),o(e,V,t),o(e,Ne,t),r(Y,e,t),o(e,Ve,t),r(D,e,t),o(e,Ye,t),o(e,Q,t),o(e,De,t),r(E,e,t),o(e,Qe,t),r(P,e,t),o(e,Ee,t),o(e,L,t),o(e,Pe,t),o(e,F,t),o(e,Le,t),r(H,e,t),o(e,Fe,t),o(e,q,t),o(e,He,t),r(A,e,t),o(e,qe,t),o(e,O,t),o(e,Ae,t),r(K,e,t),o(e,Oe,t),r(ee,e,t),o(e,Ke,t),o(e,te,t),o(e,et,t),r(ne,e,t),o(e,tt,t),o(e,oe,t),o(e,nt,t),r(se,e,t),o(e,ot,t),o(e,ie,t),o(e,st,t),o(e,ae,t),o(e,it,t),r(le,e,t),o(e,at,t),r(re,e,t),o(e,lt,t),o(e,pe,t),o(e,rt,t),r(de,e,t),o(e,pt,t),r(ce,e,t),o(e,dt,t),r(me,e,t),o(e,ct,t),r(fe,e,t),o(e,mt,t),r(ue,e,t),o(e,ft,t),r(he,e,t),o(e,ut,t),r(ge,e,t),o(e,ht,t),r(_e,e,t),o(e,gt,t),o(e,U,t),r(be,U,null),x(U,Mt),x(U,Z),r(ye,Z,null),x(Z,wt),x(Z,Ue),x(Z,Tt),r(C,Z,null),x(U,Ut),x(U,Je),r(Me,Je,null),o(e,_t,t),r(we,e,t),o(e,bt,t),o(e,Ze,t),yt=!0},p(e,[t]){const v={};t&2&&(v.$$scope={dirty:t,ctx:e}),$.$set(v);const j={};t&2&&(j.$$scope={dirty:t,ctx:e}),C.$set(j)},i(e){yt||(p(M.$$.fragment,e),p(B.$$.fragment,e),p(I.$$.fragment,e),p($.$$.fragment,e),p(R.$$.fragment,e),p(z.$$.fragment,e),p(N.$$.fragment,e),p(Y.$$.fragment,e),p(D.$$.fragment,e),p(E.$$.fragment,e),p(P.$$.fragment,e),p(H.$$.fragment,e),p(A.$$.fragment,e),p(K.$$.fragment,e),p(ee.$$.fragment,e),p(ne.$$.fragment,e),p(se.$$.fragment,e),p(le.$$.fragment,e),p(re.$$.fragment,e),p(de.$$.fragment,e),p(ce.$$.fragment,e),p(me.$$.fragment,e),p(fe.$$.fragment,e),p(ue.$$.fragment,e),p(he.$$.fragment,e),p(ge.$$.fragment,e),p(_e.$$.fragment,e),p(be.$$.fragment,e),p(ye.$$.fragment,e),p(C.$$.fragment,e),p(Me.$$.fragment,e),p(we.$$.fragment,e),yt=!0)},o(e){d(M.$$.fragment,e),d(B.$$.fragment,e),d(I.$$.fragment,e),d($.$$.fragment,e),d(R.$$.fragment,e),d(z.$$.fragment,e),d(N.$$.fragment,e),d(Y.$$.fragment,e),d(D.$$.fragment,e),d(E.$$.fragment,e),d(P.$$.fragment,e),d(H.$$.fragment,e),d(A.$$.fragment,e),d(K.$$.fragment,e),d(ee.$$.fragment,e),d(ne.$$.fragment,e),d(se.$$.fragment,e),d(le.$$.fragment,e),d(re.$$.fragment,e),d(de.$$.fragment,e),d(ce.$$.fragment,e),d(me.$$.fragment,e),d(fe.$$.fragment,e),d(ue.$$.fragment,e),d(he.$$.fragment,e),d(ge.$$.fragment,e),d(_e.$$.fragment,e),d(be.$$.fragment,e),d(ye.$$.fragment,e),d(C.$$.fragment,e),d(Me.$$.fragment,e),d(we.$$.fragment,e),yt=!1},d(e){e&&(n(J),n(_),n(y),n(g),n(T),n($e),n(W),n(Ce),n(k),n(xe),n(We),n(G),n(ke),n(S),n(Be),n(Ge),n(Se),n(Ie),n(Re),n(X),n(ze),n(Xe),n(V),n(Ne),n(Ve),n(Ye),n(Q),n(De),n(Qe),n(Ee),n(L),n(Pe),n(F),n(Le),n(Fe),n(q),n(He),n(qe),n(O),n(Ae),n(Oe),n(Ke),n(te),n(et),n(tt),n(oe),n(nt),n(ot),n(ie),n(st),n(ae),n(it),n(at),n(lt),n(pe),n(rt),n(pt),n(dt),n(ct),n(mt),n(ft),n(ut),n(ht),n(gt),n(U),n(_t),n(bt),n(Ze)),n(u),c(M,e),c(B,e),c(I,e),c($,e),c(R,e),c(z,e),c(N,e),c(Y,e),c(D,e),c(E,e),c(P,e),c(H,e),c(A,e),c(K,e),c(ee,e),c(ne,e),c(se,e),c(le,e),c(re,e),c(de,e),c(ce,e),c(me,e),c(fe,e),c(ue,e),c(he,e),c(ge,e),c(_e,e),c(be),c(ye),c(C),c(Me),c(we,e)}}}const nn='{"title":"Stable Diffusion 3","local":"stable-diffusion-3","sections":[{"title":"Usage Example","local":"usage-example","sections":[],"depth":2},{"title":"Memory Optimisations for SD3","local":"memory-optimisations-for-sd3","sections":[{"title":"Running Inference with Model Offloading","local":"running-inference-with-model-offloading","sections":[],"depth":3},{"title":"Dropping the T5 Text Encoder during Inference","local":"dropping-the-t5-text-encoder-during-inference","sections":[],"depth":3},{"title":"Using a Quantized Version of the T5 Text Encoder","local":"using-a-quantized-version-of-the-t5-text-encoder","sections":[],"depth":3}],"depth":2},{"title":"Performance Optimizations for SD3","local":"performance-optimizations-for-sd3","sections":[{"title":"Using Torch Compile to Speed Up Inference","local":"using-torch-compile-to-speed-up-inference","sections":[],"depth":3}],"depth":2},{"title":"Tiny AutoEncoder for Stable Diffusion 3","local":"tiny-autoencoder-for-stable-diffusion-3","sections":[],"depth":2},{"title":"Loading the original checkpoints via from_single_file","local":"loading-the-original-checkpoints-via-fromsinglefile","sections":[],"depth":2},{"title":"Loading the original checkpoints for the SD3Transformer2DModel","local":"loading-the-original-checkpoints-for-the-sd3transformer2dmodel","sections":[],"depth":2},{"title":"Loading the single checkpoint for the StableDiffusion3Pipeline","local":"loading-the-single-checkpoint-for-the-stablediffusion3pipeline","sections":[{"title":"Loading the single file checkpoint without T5","local":"loading-the-single-file-checkpoint-without-t5","sections":[],"depth":3},{"title":"Loading the single file checkpoint without T5","local":"loading-the-single-file-checkpoint-without-t5","sections":[],"depth":3}],"depth":2},{"title":"StableDiffusion3Pipeline","local":"diffusers.StableDiffusion3Pipeline","sections":[],"depth":2}],"depth":1}';function on(Te){return Pt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class mn extends Lt{constructor(u){super(),Ft(this,u,on,tn,Et,{})}}export{mn as component};
