import{s as Lo,o as Uo,n as se}from"../chunks/scheduler.25b97de1.js";import{S as Vo,i as Ao,g as c,s as n,r as f,A as Eo,h as m,f as r,c as a,j as M,u as h,x as T,k as $,y as l,a as i,v as u,d as g,t as _,w as v}from"../chunks/index.d9030fc9.js";import{T as Ct}from"../chunks/Tip.baa67368.js";import{D as j}from"../chunks/Docstring.e257edda.js";import{C as jt}from"../chunks/CodeBlock.e6cd0d95.js";import{E as Ft}from"../chunks/ExampleCodeBlock.20db4b6e.js";import{H as Z,E as No}from"../chunks/EditOnGithub.91d95064.js";function Zo(y){let o,b=`This model is in maintenance mode only, we don’t accept any new PRs changing its code.
If you run into any issues running this model, please reinstall the last version that supported this model: v4.40.2.
You can do so by running the following command: <code>pip install -U transformers==4.40.2</code>.`;return{c(){o=c("p"),o.innerHTML=b},l(d){o=m(d,"P",{"data-svelte-h":!0}),T(o)!=="svelte-1sq0hrb"&&(o.innerHTML=b)},m(d,p){i(d,o,p)},p:se,d(d){d&&r(o)}}}function Bo(y){let o,b="Example:",d,p,x;return p=new jt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFR2bHRDb25maWclMkMlMjBUdmx0TW9kZWwlMEElMEElMjMlMjAlMjMlMjBJbml0aWFsaXppbmclMjBhJTIwVFZMVCUyMFppbmVuZ1RhbmclMkZ0dmx0LWJhc2UlMjBzdHlsZSUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwVHZsdENvbmZpZygpJTBBJTBBJTIzJTIwJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyMG1vZGVsJTIwKHdpdGglMjByYW5kb20lMjB3ZWlnaHRzKSUyMGZyb20lMjB0aGUlMjBaaW5lbmdUYW5nJTJGdHZsdC1iYXNlJTIwc3R5bGUlMjBjb25maWd1cmF0aW9uJTBBbW9kZWwlMjAlM0QlMjBUdmx0TW9kZWwoY29uZmlndXJhdGlvbiklMEElMEElMjMlMjBBY2Nlc3NpbmclMjB0aGUlMjBtb2RlbCUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwbW9kZWwuY29uZmln",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TvltConfig, TvltModel

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># # Initializing a TVLT ZinengTang/tvlt-base style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = TvltConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># # Initializing a model (with random weights) from the ZinengTang/tvlt-base style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TvltModel(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){o=c("p"),o.textContent=b,d=n(),f(p.$$.fragment)},l(s){o=m(s,"P",{"data-svelte-h":!0}),T(o)!=="svelte-11lpom8"&&(o.textContent=b),d=a(s),h(p.$$.fragment,s)},m(s,w){i(s,o,w),i(s,d,w),u(p,s,w),x=!0},p:se,i(s){x||(g(p.$$.fragment,s),x=!0)},o(s){_(p.$$.fragment,s),x=!1},d(s){s&&(r(o),r(d)),v(p,s)}}}function Ho(y){let o,b=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){o=c("p"),o.innerHTML=b},l(d){o=m(d,"P",{"data-svelte-h":!0}),T(o)!=="svelte-fincs2"&&(o.innerHTML=b)},m(d,p){i(d,o,p)},p:se,d(d){d&&r(o)}}}function qo(y){let o,b="Examples:",d,p,x;return p=new jt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFR2bHRQcm9jZXNzb3IlMkMlMjBUdmx0TW9kZWwlMEFpbXBvcnQlMjBudW1weSUyMGFzJTIwbnAlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQW51bV9mcmFtZXMlMjAlM0QlMjA4JTBBaW1hZ2VzJTIwJTNEJTIwbGlzdChucC5yYW5kb20ucmFuZG4obnVtX2ZyYW1lcyUyQyUyMDMlMkMlMjAyMjQlMkMlMjAyMjQpKSUwQWF1ZGlvJTIwJTNEJTIwbGlzdChucC5yYW5kb20ucmFuZG4oMTAwMDApKSUwQSUwQXByb2Nlc3NvciUyMCUzRCUyMFR2bHRQcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMlppbmVuZ1RhbmclMkZ0dmx0LWJhc2UlMjIpJTBBbW9kZWwlMjAlM0QlMjBUdmx0TW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMlppbmVuZ1RhbmclMkZ0dmx0LWJhc2UlMjIpJTBBJTBBaW5wdXRfZGljdCUyMCUzRCUyMHByb2Nlc3NvcihpbWFnZXMlMkMlMjBhdWRpbyUyQyUyMHNhbXBsaW5nX3JhdGUlM0Q0NDEwMCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRfZGljdCklMEFsb3NzJTIwJTNEJTIwb3V0cHV0cy5sb3Nz",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TvltProcessor, TvltModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>num_frames = <span class="hljs-number">8</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>images = <span class="hljs-built_in">list</span>(np.random.randn(num_frames, <span class="hljs-number">3</span>, <span class="hljs-number">224</span>, <span class="hljs-number">224</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span>audio = <span class="hljs-built_in">list</span>(np.random.randn(<span class="hljs-number">10000</span>))

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = TvltProcessor.from_pretrained(<span class="hljs-string">&quot;ZinengTang/tvlt-base&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TvltModel.from_pretrained(<span class="hljs-string">&quot;ZinengTang/tvlt-base&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>input_dict = processor(images, audio, sampling_rate=<span class="hljs-number">44100</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**input_dict)
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = outputs.loss`,wrap:!1}}),{c(){o=c("p"),o.textContent=b,d=n(),f(p.$$.fragment)},l(s){o=m(s,"P",{"data-svelte-h":!0}),T(o)!=="svelte-kvfsh7"&&(o.textContent=b),d=a(s),h(p.$$.fragment,s)},m(s,w){i(s,o,w),i(s,d,w),u(p,s,w),x=!0},p:se,i(s){x||(g(p.$$.fragment,s),x=!0)},o(s){_(p.$$.fragment,s),x=!1},d(s){s&&(r(o),r(d)),v(p,s)}}}function Ro(y){let o,b=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){o=c("p"),o.innerHTML=b},l(d){o=m(d,"P",{"data-svelte-h":!0}),T(o)!=="svelte-fincs2"&&(o.innerHTML=b)},m(d,p){i(d,o,p)},p:se,d(d){d&&r(o)}}}function So(y){let o,b="Examples:",d,p,x;return p=new jt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFR2bHRQcm9jZXNzb3IlMkMlMjBUdmx0Rm9yUHJlVHJhaW5pbmclMEFpbXBvcnQlMjBudW1weSUyMGFzJTIwbnAlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQW51bV9mcmFtZXMlMjAlM0QlMjA4JTBBaW1hZ2VzJTIwJTNEJTIwbGlzdChucC5yYW5kb20ucmFuZG4obnVtX2ZyYW1lcyUyQyUyMDMlMkMlMjAyMjQlMkMlMjAyMjQpKSUwQWltYWdlc19taXhlZCUyMCUzRCUyMGxpc3QobnAucmFuZG9tLnJhbmRuKG51bV9mcmFtZXMlMkMlMjAzJTJDJTIwMjI0JTJDJTIwMjI0KSklMEFhdWRpbyUyMCUzRCUyMGxpc3QobnAucmFuZG9tLnJhbmRuKDEwMDAwKSklMEFwcm9jZXNzb3IlMjAlM0QlMjBUdmx0UHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJaaW5lbmdUYW5nJTJGdHZsdC1iYXNlJTIyKSUwQW1vZGVsJTIwJTNEJTIwVHZsdEZvclByZVRyYWluaW5nLmZyb21fcHJldHJhaW5lZCglMjJaaW5lbmdUYW5nJTJGdHZsdC1iYXNlJTIyKSUwQWlucHV0X2RpY3QlMjAlM0QlMjBwcm9jZXNzb3IoJTBBJTIwJTIwJTIwJTIwaW1hZ2VzJTJDJTIwYXVkaW8lMkMlMjBpbWFnZXNfbWl4ZWQlMkMlMjBzYW1wbGluZ19yYXRlJTNENDQxMDAlMkMlMjBtYXNrX3BpeGVsJTNEVHJ1ZSUyQyUyMG1hc2tfYXVkaW8lM0RUcnVlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiUwQSklMEElMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dF9kaWN0KSUwQWxvc3MlMjAlM0QlMjBvdXRwdXRzLmxvc3M=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TvltProcessor, TvltForPreTraining
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>num_frames = <span class="hljs-number">8</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>images = <span class="hljs-built_in">list</span>(np.random.randn(num_frames, <span class="hljs-number">3</span>, <span class="hljs-number">224</span>, <span class="hljs-number">224</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span>images_mixed = <span class="hljs-built_in">list</span>(np.random.randn(num_frames, <span class="hljs-number">3</span>, <span class="hljs-number">224</span>, <span class="hljs-number">224</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span>audio = <span class="hljs-built_in">list</span>(np.random.randn(<span class="hljs-number">10000</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span>processor = TvltProcessor.from_pretrained(<span class="hljs-string">&quot;ZinengTang/tvlt-base&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TvltForPreTraining.from_pretrained(<span class="hljs-string">&quot;ZinengTang/tvlt-base&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>input_dict = processor(
<span class="hljs-meta">... </span>    images, audio, images_mixed, sampling_rate=<span class="hljs-number">44100</span>, mask_pixel=<span class="hljs-literal">True</span>, mask_audio=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**input_dict)
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = outputs.loss`,wrap:!1}}),{c(){o=c("p"),o.textContent=b,d=n(),f(p.$$.fragment)},l(s){o=m(s,"P",{"data-svelte-h":!0}),T(o)!=="svelte-kvfsh7"&&(o.textContent=b),d=a(s),h(p.$$.fragment,s)},m(s,w){i(s,o,w),i(s,d,w),u(p,s,w),x=!0},p:se,i(s){x||(g(p.$$.fragment,s),x=!0)},o(s){_(p.$$.fragment,s),x=!1},d(s){s&&(r(o),r(d)),v(p,s)}}}function Do(y){let o,b=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){o=c("p"),o.innerHTML=b},l(d){o=m(d,"P",{"data-svelte-h":!0}),T(o)!=="svelte-fincs2"&&(o.innerHTML=b)},m(d,p){i(d,o,p)},p:se,d(d){d&&r(o)}}}function Go(y){let o,b="Examples:",d,p,x;return p=new jt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFR2bHRQcm9jZXNzb3IlMkMlMjBUdmx0Rm9yQXVkaW9WaXN1YWxDbGFzc2lmaWNhdGlvbiUwQWltcG9ydCUyMG51bXB5JTIwYXMlMjBucCUwQWltcG9ydCUyMHRvcmNoJTBBJTBBbnVtX2ZyYW1lcyUyMCUzRCUyMDglMEFpbWFnZXMlMjAlM0QlMjBsaXN0KG5wLnJhbmRvbS5yYW5kbihudW1fZnJhbWVzJTJDJTIwMyUyQyUyMDIyNCUyQyUyMDIyNCkpJTBBYXVkaW8lMjAlM0QlMjBsaXN0KG5wLnJhbmRvbS5yYW5kbigxMDAwMCkpJTBBcHJvY2Vzc29yJTIwJTNEJTIwVHZsdFByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyWmluZW5nVGFuZyUyRnR2bHQtYmFzZSUyMiklMEFtb2RlbCUyMCUzRCUyMFR2bHRGb3JBdWRpb1Zpc3VhbENsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJaaW5lbmdUYW5nJTJGdHZsdC1iYXNlJTIyKSUwQWlucHV0X2RpY3QlMjAlM0QlMjBwcm9jZXNzb3IoaW1hZ2VzJTJDJTIwYXVkaW8lMkMlMjBzYW1wbGluZ19yYXRlJTNENDQxMDAlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0X2RpY3QpJTBBbG9zcyUyMCUzRCUyMG91dHB1dHMubG9zcw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TvltProcessor, TvltForAudioVisualClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>num_frames = <span class="hljs-number">8</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>images = <span class="hljs-built_in">list</span>(np.random.randn(num_frames, <span class="hljs-number">3</span>, <span class="hljs-number">224</span>, <span class="hljs-number">224</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span>audio = <span class="hljs-built_in">list</span>(np.random.randn(<span class="hljs-number">10000</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span>processor = TvltProcessor.from_pretrained(<span class="hljs-string">&quot;ZinengTang/tvlt-base&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TvltForAudioVisualClassification.from_pretrained(<span class="hljs-string">&quot;ZinengTang/tvlt-base&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>input_dict = processor(images, audio, sampling_rate=<span class="hljs-number">44100</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**input_dict)
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = outputs.loss`,wrap:!1}}),{c(){o=c("p"),o.textContent=b,d=n(),f(p.$$.fragment)},l(s){o=m(s,"P",{"data-svelte-h":!0}),T(o)!=="svelte-kvfsh7"&&(o.textContent=b),d=a(s),h(p.$$.fragment,s)},m(s,w){i(s,o,w),i(s,d,w),u(p,s,w),x=!0},p:se,i(s){x||(g(p.$$.fragment,s),x=!0)},o(s){_(p.$$.fragment,s),x=!1},d(s){s&&(r(o),r(d)),v(p,s)}}}function Xo(y){let o,b,d,p,x,s,w,rt,ne,st,ae,co=`The TVLT model was proposed in <a href="https://arxiv.org/abs/2209.14156" rel="nofollow">TVLT: Textless Vision-Language Transformer</a>
by Zineng Tang, Jaemin Cho, Yixin Nie, Mohit Bansal (the first three authors contributed equally). The Textless Vision-Language Transformer (TVLT) is a model that uses raw visual and audio inputs for vision-and-language representation learning, without using text-specific modules such as tokenization or automatic speech recognition (ASR). It can perform various audiovisual and vision-language tasks like retrieval, question answering, etc.`,nt,le,mo="The abstract from the paper is the following:",at,ie,po="<em>In this work, we present the Textless Vision-Language Transformer (TVLT), where homogeneous transformer blocks take raw visual and audio inputs for vision-and-language representation learning with minimal modality-specific design, and do not use text-specific modules such as tokenization or automatic speech recognition (ASR). TVLT is trained by reconstructing masked patches of continuous video frames and audio spectrograms (masked autoencoding) and contrastive modeling to align video and audio. TVLT attains performance comparable to its text-based counterpart on various multimodal tasks, such as visual question answering, image retrieval, video retrieval, and multimodal sentiment analysis, with 28x faster inference speed and only 1/3 of the parameters. Our findings suggest the possibility of learning compact and efficient visual-linguistic representations from low-level visual and audio signals without assuming the prior existence of text.</em>",lt,H,fo='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/model_doc/tvlt_architecture.png" alt="drawing" width="600"/>',it,de,ho='TVLT architecture. Taken from the <a href="[https://arxiv.org/abs/2102.03334](https://arxiv.org/abs/2209.14156)">original paper</a>.',dt,ce,uo='The original code can be found <a href="https://github.com/zinengtang/TVLT" rel="nofollow">here</a>. This model was contributed by <a href="https://huggingface.co/ZinengTang" rel="nofollow">Zineng Tang</a>.',ct,me,mt,pe,go=`<li>TVLT is a model that takes both <code>pixel_values</code> and <code>audio_values</code> as input. One can use <a href="/docs/transformers/pr_28847/en/model_doc/tvlt#transformers.TvltProcessor">TvltProcessor</a> to prepare data for the model.
This processor wraps an image processor (for the image/video modality) and an audio feature extractor (for the audio modality) into one.</li> <li>TVLT is trained with images/videos and audios of various sizes: the authors resize and crop the input images/videos to 224 and limit the length of audio spectrogram to 2048. To make batching of videos and audios possible, the authors use a <code>pixel_mask</code> that indicates which pixels are real/padding and <code>audio_mask</code> that indicates which audio values are real/padding.</li> <li>The design of TVLT is very similar to that of a standard Vision Transformer (ViT) and masked autoencoder (MAE) as in <a href="vitmae">ViTMAE</a>. The difference is that the model includes embedding layers for the audio modality.</li> <li>The PyTorch version of this model is only available in torch 1.10 and higher.</li>`,pt,fe,ft,P,he,It,Ve,_o=`This is the configuration class to store the configuration of a <a href="/docs/transformers/pr_28847/en/model_doc/tvlt#transformers.TvltModel">TvltModel</a>. It is used to instantiate a TVLT
model according to the specified arguments, defining the model architecture. Instantiating a configuration with the
defaults will yield a similar configuration to that of the TVLT
<a href="https://huggingface.co/ZinengTang/tvlt-base" rel="nofollow">ZinengTang/tvlt-base</a> architecture.`,Wt,Ae,vo=`Configuration objects inherit from <a href="/docs/transformers/pr_28847/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/pr_28847/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,Jt,q,ht,ue,ut,k,ge,Lt,Ee,To="Constructs a TVLT processor which wraps a TVLT image processor and TVLT feature extractor into a single processor.",Ut,Ne,bo=`<a href="/docs/transformers/pr_28847/en/model_doc/tvlt#transformers.TvltProcessor">TvltProcessor</a> offers all the functionalities of <a href="/docs/transformers/pr_28847/en/model_doc/tvlt#transformers.TvltImageProcessor">TvltImageProcessor</a> and <a href="/docs/transformers/pr_28847/en/model_doc/tvlt#transformers.TvltFeatureExtractor">TvltFeatureExtractor</a>. See the
docstring of <a href="/docs/transformers/pr_28847/en/model_doc/tvlt#transformers.TvltProcessor.__call__"><strong>call</strong>()</a> for more information.`,Vt,R,_e,At,Ze,xo=`Forwards the <code>images</code> argument to TvltImageProcessor’s <a href="/docs/transformers/pr_28847/en/model_doc/tvlt#transformers.TvltImageProcessor.preprocess">preprocess()</a> and the <code>audio</code>
argument to TvltFeatureExtractor’s <a href="/docs/transformers/pr_28847/en/model_doc/tvlt#transformers.TvltFeatureExtractor.__call__"><strong>call</strong>()</a>. Please refer to the docstring of the
above two methods for more information.`,gt,ve,_t,z,Te,Et,Be,wo="Constructs a TVLT image processor.",Nt,He,yo="This processor can be used to prepare either videos or images for the model by converting images to 1-frame videos.",Zt,S,be,Bt,qe,$o="Preprocess an videos or image or batch of videos or images.",vt,xe,Tt,C,we,Ht,Re,Mo="Constructs a TVLT audio feature extractor. This feature extractor can be used to prepare audios for the model.",qt,Se,Po=`This feature extractor inherits from <a href="/docs/transformers/pr_28847/en/main_classes/feature_extractor#transformers.FeatureExtractionMixin">FeatureExtractionMixin</a> which contains most of the main methods. Users
should refer to this superclass for more information regarding those methods.`,Rt,D,ye,St,De,ko="Main method to prepare one or several audio(s) for the model.",bt,$e,xt,L,Me,Dt,Ge,zo=`The bare TVLT Model transformer outputting raw hidden-states without any specific head on top.
This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass. Use it
as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,Gt,I,Pe,Xt,Xe,Co='The <a href="/docs/transformers/pr_28847/en/model_doc/tvlt#transformers.TvltModel">TvltModel</a> forward method, overrides the <code>__call__</code> special method.',Qt,G,Yt,X,wt,ke,yt,U,ze,Ot,Qe,Fo=`The TVLT Model transformer with the decoder on top for self-supervised pre-training.
This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass. Use it
as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,Kt,W,Ce,eo,Ye,jo='The <a href="/docs/transformers/pr_28847/en/model_doc/tvlt#transformers.TvltForPreTraining">TvltForPreTraining</a> forward method, overrides the <code>__call__</code> special method.',to,Q,oo,Y,$t,Fe,Mt,F,je,ro,Oe,Io=`Tvlt Model transformer with a classifier head on top (an MLP on top of the final hidden state of the [CLS] token)
for audiovisual classification tasks, e.g. CMU-MOSEI Sentiment Analysis and Audio to Video Retrieval.`,so,Ke,Wo=`This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass. Use it
as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,no,J,Ie,ao,et,Jo='The <a href="/docs/transformers/pr_28847/en/model_doc/tvlt#transformers.TvltForAudioVisualClassification">TvltForAudioVisualClassification</a> forward method, overrides the <code>__call__</code> special method.',lo,O,io,K,Pt,We,kt,ot,zt;return x=new Z({props:{title:"TVLT",local:"tvlt",headingTag:"h1"}}),w=new Ct({props:{warning:!0,$$slots:{default:[Zo]},$$scope:{ctx:y}}}),ne=new Z({props:{title:"Overview",local:"overview",headingTag:"h2"}}),me=new Z({props:{title:"Usage tips",local:"usage-tips",headingTag:"h2"}}),fe=new Z({props:{title:"TvltConfig",local:"transformers.TvltConfig",headingTag:"h2"}}),he=new j({props:{name:"class transformers.TvltConfig",anchor:"transformers.TvltConfig",parameters:[{name:"image_size",val:" = 224"},{name:"spectrogram_length",val:" = 2048"},{name:"frequency_length",val:" = 128"},{name:"image_patch_size",val:" = [16, 16]"},{name:"audio_patch_size",val:" = [16, 16]"},{name:"num_image_channels",val:" = 3"},{name:"num_audio_channels",val:" = 1"},{name:"num_frames",val:" = 8"},{name:"hidden_size",val:" = 768"},{name:"num_hidden_layers",val:" = 12"},{name:"num_attention_heads",val:" = 12"},{name:"intermediate_size",val:" = 3072"},{name:"hidden_act",val:" = 'gelu'"},{name:"hidden_dropout_prob",val:" = 0.0"},{name:"attention_probs_dropout_prob",val:" = 0.0"},{name:"initializer_range",val:" = 0.02"},{name:"layer_norm_eps",val:" = 1e-06"},{name:"qkv_bias",val:" = True"},{name:"use_mean_pooling",val:" = False"},{name:"decoder_num_attention_heads",val:" = 16"},{name:"decoder_hidden_size",val:" = 512"},{name:"decoder_num_hidden_layers",val:" = 8"},{name:"decoder_intermediate_size",val:" = 2048"},{name:"pixel_mask_ratio",val:" = 0.75"},{name:"audio_mask_ratio",val:" = 0.15"},{name:"audio_mask_type",val:" = 'frame-level'"},{name:"task_matching",val:" = True"},{name:"task_mae",val:" = True"},{name:"loss_type",val:" = 'classification'"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TvltConfig.image_size",description:`<strong>image_size</strong> (<code>int</code>, <em>optional</em>, defaults to 224) &#x2014;
The size (resolution) of each image.`,name:"image_size"},{anchor:"transformers.TvltConfig.spectrogram_length",description:`<strong>spectrogram_length</strong> (<code>int</code>, <em>optional</em>, defaults to 2048) &#x2014;
The time length of each audio spectrogram.`,name:"spectrogram_length"},{anchor:"transformers.TvltConfig.frequency_length",description:`<strong>frequency_length</strong> (<code>int</code>, <em>optional</em>, defaults to 128) &#x2014;
The frequency length of audio spectrogram.`,name:"frequency_length"},{anchor:"transformers.TvltConfig.image_patch_size",description:`<strong>image_patch_size</strong> (<code>List[int]</code>, <em>optional</em>, defaults to <code>[16, 16]</code>) &#x2014;
The size (resolution) of each image patch.`,name:"image_patch_size"},{anchor:"transformers.TvltConfig.audio_patch_size",description:`<strong>audio_patch_size</strong> (<code>List[int]</code>, <em>optional</em>, defaults to <code>[16, 16]</code>) &#x2014;
The size (resolution) of each audio patch.`,name:"audio_patch_size"},{anchor:"transformers.TvltConfig.num_image_channels",description:`<strong>num_image_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 3) &#x2014;
The number of input image channels.`,name:"num_image_channels"},{anchor:"transformers.TvltConfig.num_audio_channels",description:`<strong>num_audio_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of input audio channels.`,name:"num_audio_channels"},{anchor:"transformers.TvltConfig.num_frames",description:`<strong>num_frames</strong> (<code>int</code>, <em>optional</em>, defaults to 8) &#x2014;
The maximum number of frames for an input video.`,name:"num_frames"},{anchor:"transformers.TvltConfig.hidden_size",description:`<strong>hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 768) &#x2014;
Dimensionality of the encoder layers and the pooler layer.`,name:"hidden_size"},{anchor:"transformers.TvltConfig.num_hidden_layers",description:`<strong>num_hidden_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014;
Number of hidden layers in the Transformer encoder.`,name:"num_hidden_layers"},{anchor:"transformers.TvltConfig.num_attention_heads",description:`<strong>num_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014;
Number of attention heads for each attention layer in the Transformer encoder.`,name:"num_attention_heads"},{anchor:"transformers.TvltConfig.intermediate_size",description:`<strong>intermediate_size</strong> (<code>int</code>, <em>optional</em>, defaults to 3072) &#x2014;
Dimensionality of the &#x201C;intermediate&#x201D; (i.e., feed-forward) layer in the Transformer encoder.`,name:"intermediate_size"},{anchor:"transformers.TvltConfig.hidden_act",description:`<strong>hidden_act</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to <code>&quot;gelu&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the encoder and pooler. If string, <code>&quot;gelu&quot;</code>,
<code>&quot;relu&quot;</code>, <code>&quot;selu&quot;</code> and <code>&quot;gelu_new&quot;</code> are supported.`,name:"hidden_act"},{anchor:"transformers.TvltConfig.hidden_dropout_prob",description:`<strong>hidden_dropout_prob</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout probability for all fully connected layers in the embeddings, encoder, and pooler.`,name:"hidden_dropout_prob"},{anchor:"transformers.TvltConfig.attention_probs_dropout_prob",description:`<strong>attention_probs_dropout_prob</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout ratio for the attention probabilities.`,name:"attention_probs_dropout_prob"},{anchor:"transformers.TvltConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.TvltConfig.layer_norm_eps",description:`<strong>layer_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-06) &#x2014;
The epsilon used by the layer normalization layers.`,name:"layer_norm_eps"},{anchor:"transformers.TvltConfig.qkv_bias",description:`<strong>qkv_bias</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to add a bias to the queries, keys and values.`,name:"qkv_bias"},{anchor:"transformers.TvltConfig.use_mean_pooling",description:`<strong>use_mean_pooling</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to mean pool the final hidden states instead of using the final hidden state of the [CLS] token.`,name:"use_mean_pooling"},{anchor:"transformers.TvltConfig.decoder_num_attention_heads",description:`<strong>decoder_num_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 16) &#x2014;
Number of attention heads for each attention layer in the decoder.`,name:"decoder_num_attention_heads"},{anchor:"transformers.TvltConfig.decoder_hidden_size",description:`<strong>decoder_hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
Dimensionality of the decoder.`,name:"decoder_hidden_size"},{anchor:"transformers.TvltConfig.decoder_num_hidden_layers",description:`<strong>decoder_num_hidden_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 8) &#x2014;
Number of hidden layers in the decoder.`,name:"decoder_num_hidden_layers"},{anchor:"transformers.TvltConfig.decoder_intermediate_size",description:`<strong>decoder_intermediate_size</strong> (<code>int</code>, <em>optional</em>, defaults to 2048) &#x2014;
Dimensionality of the &#x201C;intermediate&#x201D; (i.e., feed-forward) layer in the decoder.`,name:"decoder_intermediate_size"},{anchor:"transformers.TvltConfig.pixel_mask_ratio",description:`<strong>pixel_mask_ratio</strong> (<code>float</code>, <em>optional</em>, defaults to 0.75) &#x2014;
Image patch masking ratio.`,name:"pixel_mask_ratio"},{anchor:"transformers.TvltConfig.audio_mask_ratio",description:`<strong>audio_mask_ratio</strong> (<code>float</code>, <em>optional</em>, defaults to 0.15) &#x2014;
Audio patch masking ratio.`,name:"audio_mask_ratio"},{anchor:"transformers.TvltConfig.audio_mask_type",description:`<strong>audio_mask_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;frame-level&quot;</code>) &#x2014;
Audio patch masking type, choose between &#x201C;frame-level&#x201D; and &#x201C;patch-level&#x201D;.`,name:"audio_mask_type"},{anchor:"transformers.TvltConfig.task_matching",description:`<strong>task_matching</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to use vision audio matching task in pretraining.`,name:"task_matching"},{anchor:"transformers.TvltConfig.task_mae",description:`<strong>task_mae</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to use the masked auto-encoder (MAE) in pretraining.`,name:"task_mae"},{anchor:"transformers.TvltConfig.loss_type",description:`<strong>loss_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;classification&quot;</code>) &#x2014;
Loss types including regression and classification.`,name:"loss_type"}],source:"https://github.com/huggingface/transformers/blob/vr_28847/src/transformers/models/deprecated/tvlt/configuration_tvlt.py#L24"}}),q=new Ft({props:{anchor:"transformers.TvltConfig.example",$$slots:{default:[Bo]},$$scope:{ctx:y}}}),ue=new Z({props:{title:"TvltProcessor",local:"transformers.TvltProcessor",headingTag:"h2"}}),ge=new j({props:{name:"class transformers.TvltProcessor",anchor:"transformers.TvltProcessor",parameters:[{name:"image_processor",val:""},{name:"feature_extractor",val:""}],parametersDescription:[{anchor:"transformers.TvltProcessor.image_processor",description:`<strong>image_processor</strong> (<code>TvltImageProcessor</code>) &#x2014;
An instance of <a href="/docs/transformers/pr_28847/en/model_doc/tvlt#transformers.TvltImageProcessor">TvltImageProcessor</a>. The image processor is a required input.`,name:"image_processor"},{anchor:"transformers.TvltProcessor.feature_extractor",description:`<strong>feature_extractor</strong> (<code>TvltFeatureExtractor</code>) &#x2014;
An instance of <a href="/docs/transformers/pr_28847/en/model_doc/tvlt#transformers.TvltFeatureExtractor">TvltFeatureExtractor</a>. The feature extractor is a required input.`,name:"feature_extractor"}],source:"https://github.com/huggingface/transformers/blob/vr_28847/src/transformers/models/deprecated/tvlt/processing_tvlt.py#L22"}}),_e=new j({props:{name:"__call__",anchor:"transformers.TvltProcessor.__call__",parameters:[{name:"images",val:" = None"},{name:"audio",val:" = None"},{name:"images_mixed",val:" = None"},{name:"sampling_rate",val:" = None"},{name:"mask_audio",val:" = False"},{name:"mask_pixel",val:" = False"},{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/vr_28847/src/transformers/models/deprecated/tvlt/processing_tvlt.py#L46"}}),ve=new Z({props:{title:"TvltImageProcessor",local:"transformers.TvltImageProcessor",headingTag:"h2"}}),Te=new j({props:{name:"class transformers.TvltImageProcessor",anchor:"transformers.TvltImageProcessor",parameters:[{name:"do_resize",val:": bool = True"},{name:"size",val:": Dict = None"},{name:"patch_size",val:": List = [16, 16]"},{name:"num_frames",val:": int = 8"},{name:"resample",val:": Resampling = <Resampling.BILINEAR: 2>"},{name:"do_center_crop",val:": bool = True"},{name:"crop_size",val:": Dict = None"},{name:"do_rescale",val:": bool = True"},{name:"rescale_factor",val:": Union = 0.00392156862745098"},{name:"do_normalize",val:": bool = True"},{name:"image_mean",val:": Union = [0.5, 0.5, 0.5]"},{name:"image_std",val:": Union = [0.5, 0.5, 0.5]"},{name:"init_mask_generator",val:" = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TvltImageProcessor.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to resize the image&#x2019;s (height, width) dimensions to the specified <code>size</code>. Can be overridden by the
<code>do_resize</code> parameter in the <code>preprocess</code> method.`,name:"do_resize"},{anchor:"transformers.TvltImageProcessor.size",description:`<strong>size</strong> (<code>Dict[str, int]</code> <em>optional</em>, defaults to <code>{&quot;shortest_edge&quot; -- 224}</code>):
Size of the output image after resizing. The shortest edge of the image will be resized to
<code>size[&quot;shortest_edge&quot;]</code> while maintaining the aspect ratio of the original image. Can be overriden by
<code>size</code> in the <code>preprocess</code> method.`,name:"size"},{anchor:"transformers.TvltImageProcessor.patch_size",description:`<strong>patch_size</strong> (<code>List[int]</code> <em>optional</em>, defaults to [16,16]) &#x2014;
The patch size of image patch embedding.`,name:"patch_size"},{anchor:"transformers.TvltImageProcessor.num_frames",description:`<strong>num_frames</strong> (<code>int</code> <em>optional</em>, defaults to 8) &#x2014;
The maximum number of video frames.`,name:"num_frames"},{anchor:"transformers.TvltImageProcessor.resample",description:`<strong>resample</strong> (<code>PILImageResampling</code>, <em>optional</em>, defaults to <code>PILImageResampling.BILINEAR</code>) &#x2014;
Resampling filter to use if resizing the image. Can be overridden by the <code>resample</code> parameter in the
<code>preprocess</code> method.`,name:"resample"},{anchor:"transformers.TvltImageProcessor.do_center_crop",description:`<strong>do_center_crop</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to center crop the image to the specified <code>crop_size</code>. Can be overridden by the <code>do_center_crop</code>
parameter in the <code>preprocess</code> method.`,name:"do_center_crop"},{anchor:"transformers.TvltImageProcessor.crop_size",description:`<strong>crop_size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to <code>{&quot;height&quot; -- 224, &quot;width&quot;: 224}</code>):
Size of the image after applying the center crop. Can be overridden by the <code>crop_size</code> parameter in the
<code>preprocess</code> method.`,name:"crop_size"},{anchor:"transformers.TvltImageProcessor.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to rescale the image by the specified scale <code>rescale_factor</code>. Can be overridden by the <code>do_rescale</code>
parameter in the <code>preprocess</code> method.`,name:"do_rescale"},{anchor:"transformers.TvltImageProcessor.rescale_factor",description:`<strong>rescale_factor</strong> (<code>int</code> or <code>float</code>, <em>optional</em>, defaults to 1/255) &#x2014;
Defines the scale factor to use if rescaling the image. Can be overridden by the <code>rescale_factor</code> parameter
in the <code>preprocess</code> method.`,name:"rescale_factor"},{anchor:"transformers.TvltImageProcessor.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to normalize the image. Can be overridden by the <code>do_normalize</code> parameter in the <code>preprocess</code>
method.`,name:"do_normalize"},{anchor:"transformers.TvltImageProcessor.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>IMAGENET_STANDARD_MEAN</code>) &#x2014;
Mean to use if normalizing the image. This is a float or list of floats the length of the number of
channels in the image. Can be overridden by the <code>image_mean</code> parameter in the <code>preprocess</code> method.`,name:"image_mean"},{anchor:"transformers.TvltImageProcessor.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>IMAGENET_STANDARD_STD</code>) &#x2014;
Standard deviation to use if normalizing the image. This is a float or list of floats the length of the
number of channels in the image. Can be overridden by the <code>image_std</code> parameter in the <code>preprocess</code> method.`,name:"image_std"}],source:"https://github.com/huggingface/transformers/blob/vr_28847/src/transformers/models/deprecated/tvlt/image_processing_tvlt.py#L70"}}),be=new j({props:{name:"preprocess",anchor:"transformers.TvltImageProcessor.preprocess",parameters:[{name:"videos",val:": Union"},{name:"do_resize",val:": bool = None"},{name:"size",val:": Dict = None"},{name:"patch_size",val:": List = None"},{name:"num_frames",val:": int = None"},{name:"resample",val:": Resampling = None"},{name:"do_center_crop",val:": bool = None"},{name:"crop_size",val:": Dict = None"},{name:"do_rescale",val:": bool = None"},{name:"rescale_factor",val:": float = None"},{name:"do_normalize",val:": bool = None"},{name:"image_mean",val:": Union = None"},{name:"image_std",val:": Union = None"},{name:"is_mixed",val:": bool = False"},{name:"return_tensors",val:": Union = None"},{name:"data_format",val:": ChannelDimension = <ChannelDimension.FIRST: 'channels_first'>"},{name:"input_data_format",val:": Union = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TvltImageProcessor.preprocess.videos",description:`<strong>videos</strong> (<code>ImageInput</code>) &#x2014;
Images or videos to preprocess. Expects a single or batch of frames with pixel values ranging from 0 to
255. If passing in frames with pixel values between 0 and 1, set <code>do_rescale=False</code>.`,name:"videos"},{anchor:"transformers.TvltImageProcessor.preprocess.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_resize</code>) &#x2014;
Whether to resize the image.`,name:"do_resize"},{anchor:"transformers.TvltImageProcessor.preprocess.size",description:`<strong>size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to <code>self.size</code>) &#x2014;
Size of the image after applying resize.`,name:"size"},{anchor:"transformers.TvltImageProcessor.preprocess.patch_size",description:`<strong>patch_size</strong> (<code>List[int]</code> <em>optional</em>, defaults to self.patch_size) &#x2014;
The patch size of image patch embedding.`,name:"patch_size"},{anchor:"transformers.TvltImageProcessor.preprocess.num_frames",description:`<strong>num_frames</strong> (<code>int</code> <em>optional</em>, defaults to self.num_frames) &#x2014;
The maximum number of video frames.`,name:"num_frames"},{anchor:"transformers.TvltImageProcessor.preprocess.resample",description:`<strong>resample</strong> (<code>PILImageResampling</code>, <em>optional</em>, defaults to <code>self.resample</code>) &#x2014;
Resampling filter to use if resizing the image. This can be one of the enum <code>PILImageResampling</code>, Only
has an effect if <code>do_resize</code> is set to <code>True</code>.`,name:"resample"},{anchor:"transformers.TvltImageProcessor.preprocess.do_center_crop",description:`<strong>do_center_crop</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_centre_crop</code>) &#x2014;
Whether to centre crop the image.`,name:"do_center_crop"},{anchor:"transformers.TvltImageProcessor.preprocess.crop_size",description:`<strong>crop_size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to <code>self.crop_size</code>) &#x2014;
Size of the image after applying the centre crop.`,name:"crop_size"},{anchor:"transformers.TvltImageProcessor.preprocess.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_rescale</code>) &#x2014;
Whether to rescale the image values between [0 - 1].`,name:"do_rescale"},{anchor:"transformers.TvltImageProcessor.preprocess.rescale_factor",description:`<strong>rescale_factor</strong> (<code>float</code>, <em>optional</em>, defaults to <code>self.rescale_factor</code>) &#x2014;
Rescale factor to rescale the image by if <code>do_rescale</code> is set to <code>True</code>.`,name:"rescale_factor"},{anchor:"transformers.TvltImageProcessor.preprocess.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_normalize</code>) &#x2014;
Whether to normalize the image.`,name:"do_normalize"},{anchor:"transformers.TvltImageProcessor.preprocess.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_mean</code>) &#x2014;
Image mean.`,name:"image_mean"},{anchor:"transformers.TvltImageProcessor.preprocess.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_std</code>) &#x2014;
Image standard deviation.`,name:"image_std"},{anchor:"transformers.TvltImageProcessor.preprocess.is_mixed",description:`<strong>is_mixed</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If the input video has negative samples.`,name:"is_mixed"},{anchor:"transformers.TvltImageProcessor.preprocess.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <code>TensorType</code>, <em>optional</em>) &#x2014;
The type of tensors to return. Can be one of:<ul>
<li>Unset: Return a list of <code>np.ndarray</code>.</li>
<li><code>TensorType.TENSORFLOW</code> or <code>&apos;tf&apos;</code>: Return a batch of type <code>tf.Tensor</code>.</li>
<li><code>TensorType.PYTORCH</code> or <code>&apos;pt&apos;</code>: Return a batch of type <code>torch.Tensor</code>.</li>
<li><code>TensorType.NUMPY</code> or <code>&apos;np&apos;</code>: Return a batch of type <code>np.ndarray</code>.</li>
<li><code>TensorType.JAX</code> or <code>&apos;jax&apos;</code>: Return a batch of type <code>jax.numpy.ndarray</code>.</li>
</ul>`,name:"return_tensors"},{anchor:"transformers.TvltImageProcessor.preprocess.data_format",description:`<strong>data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>, defaults to <code>ChannelDimension.FIRST</code>) &#x2014;
The channel dimension format for the output image. Can be one of:<ul>
<li><code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li>Unset: Use the inferred channel dimension format of the input image.</li>
</ul>`,name:"data_format"},{anchor:"transformers.TvltImageProcessor.preprocess.input_data_format",description:`<strong>input_data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>) &#x2014;
The channel dimension format for the input image. If unset, the channel dimension format is inferred
from the input image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li><code>&quot;none&quot;</code> or <code>ChannelDimension.NONE</code>: image in (height, width) format.</li>
</ul>`,name:"input_data_format"}],source:"https://github.com/huggingface/transformers/blob/vr_28847/src/transformers/models/deprecated/tvlt/image_processing_tvlt.py#L277",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/pr_28847/en/main_classes/image_processor#transformers.BatchFeature"
>BatchFeature</a> with the following fields:</p>
<ul>
<li>
<p><strong>pixel_values</strong> — Pixel values to be fed to a model, of shape (batch_size, num_channels, height,
width).</p>
</li>
<li>
<p><strong>pixel_mask</strong> — Pixel masks to be fed to a model, of shape (batch_size, num_pixel_patches).</p>
</li>
<li>
<p><strong>pixel_values_mixed</strong> — Pixel values with both postive or negative to be fed to a model, of shape
(batch_size, num_channels, height, width).</p>
</li>
<li>
<p><strong>pixel_mask_mixed</strong> — Pixel masks with both postive or negative to be fed to a model, of shape
(batch_size, num_pixel_patches).</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/pr_28847/en/main_classes/image_processor#transformers.BatchFeature"
>BatchFeature</a></p>
`}}),xe=new Z({props:{title:"TvltFeatureExtractor",local:"transformers.TvltFeatureExtractor",headingTag:"h2"}}),we=new j({props:{name:"class transformers.TvltFeatureExtractor",anchor:"transformers.TvltFeatureExtractor",parameters:[{name:"spectrogram_length",val:" = 2048"},{name:"num_channels",val:" = 1"},{name:"patch_size",val:" = [16, 16]"},{name:"feature_size",val:" = 128"},{name:"sampling_rate",val:" = 44100"},{name:"hop_length_to_sampling_rate",val:" = 86"},{name:"n_fft",val:" = 2048"},{name:"padding_value",val:" = 0.0"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TvltFeatureExtractor.spectrogram_length",description:`<strong>spectrogram_length</strong> (<code>Dict[str, int]</code> <em>optional</em>, defaults to 2048) &#x2014;
The time length of each audio spectrogram.`,name:"spectrogram_length"},{anchor:"transformers.TvltFeatureExtractor.num_channels",description:`<strong>num_channels</strong> (<code>int</code> <em>optional</em>, defaults to 1) &#x2014;
Number of audio channels.`,name:"num_channels"},{anchor:"transformers.TvltFeatureExtractor.patch_size",description:`<strong>patch_size</strong> (<code>List[int]</code> <em>optional</em>, defaults to <code>[16, 16]</code>) &#x2014;
The patch size of audio patch embedding.`,name:"patch_size"},{anchor:"transformers.TvltFeatureExtractor.feature_size",description:`<strong>feature_size</strong> (<code>int</code>, <em>optional</em>, defaults to 128) &#x2014;
The frequency length of audio spectrogram.`,name:"feature_size"},{anchor:"transformers.TvltFeatureExtractor.sampling_rate",description:`<strong>sampling_rate</strong> (<code>int</code>, <em>optional</em>, defaults to 44100) &#x2014;
The sampling rate at which the audio files should be digitalized expressed in Hertz (Hz).`,name:"sampling_rate"},{anchor:"transformers.TvltFeatureExtractor.hop_length_to_sampling_rate",description:`<strong>hop_length_to_sampling_rate</strong> (<code>int</code>, <em>optional</em>, defaults to 86) &#x2014;
Hop length is length of the overlaping windows for the STFT used to obtain the Mel Frequency coefficients.
For example, with sampling rate 44100, the hop length is 512, with 44100 / 512 = 86`,name:"hop_length_to_sampling_rate"},{anchor:"transformers.TvltFeatureExtractor.n_fft",description:`<strong>n_fft</strong> (<code>int</code>, <em>optional</em>, defaults to 2048) &#x2014;
Size of the Fourier transform.`,name:"n_fft"},{anchor:"transformers.TvltFeatureExtractor.padding_value",description:`<strong>padding_value</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Padding value used to pad the audio. Should correspond to silences.`,name:"padding_value"}],source:"https://github.com/huggingface/transformers/blob/vr_28847/src/transformers/models/deprecated/tvlt/feature_extraction_tvlt.py#L30"}}),ye=new j({props:{name:"__call__",anchor:"transformers.TvltFeatureExtractor.__call__",parameters:[{name:"raw_speech",val:": Union"},{name:"return_tensors",val:": Union = None"},{name:"return_attention_mask",val:": Optional = True"},{name:"sampling_rate",val:": Optional = None"},{name:"resample",val:": bool = False"},{name:"mask_audio",val:": bool = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TvltFeatureExtractor.__call__.raw_speech",description:`<strong>raw_speech</strong> (<code>np.ndarray</code>, <code>List[float]</code>, <code>List[np.ndarray]</code>, <code>List[List[float]]</code>) &#x2014;
The sequence or batch of sequences to be padded. Each sequence can be a numpy array, a list of float
values, a list of numpy arrays or a list of list of float values. Must be mono channel audio, not
stereo, i.e. single float per timestep.`,name:"raw_speech"},{anchor:"transformers.TvltFeatureExtractor.__call__.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <a href="/docs/transformers/pr_28847/en/internal/file_utils#transformers.TensorType">TensorType</a>, <em>optional</em>) &#x2014;
If set, will return tensors instead of list of python integers. Acceptable values are:</p>
<ul>
<li><code>&apos;pt&apos;</code>: Return PyTorch <code>torch.Tensor</code> objects.</li>
<li><code>&apos;np&apos;</code>: Return Numpy <code>np.ndarray</code> objects.</li>
</ul>`,name:"return_tensors"},{anchor:"transformers.TvltFeatureExtractor.__call__.return_attention_mask",description:`<strong>return_attention_mask</strong> (<code>bool</code>, <em>optional</em>, default to <code>True</code>) &#x2014;
Whether to return the attention mask. If left to the default, will return the attention mask according
to the specific feature_extractor&#x2019;s default. <a href="../glossary#attention-mask">What are attention masks?</a></p>
<div class="course-tip  bg-gradient-to-br dark:bg-gradient-to-r before:border-green-500 dark:before:border-green-800 from-green-50 dark:from-gray-900 to-white dark:to-gray-950 border border-green-50 text-green-700 dark:text-gray-400">
						
<p>For TvltTransformer models, <code>attention_mask</code> should alwys be passed for batched inference, to avoid
subtle bugs.</p>

					</div>`,name:"return_attention_mask"},{anchor:"transformers.TvltFeatureExtractor.__call__.sampling_rate",description:`<strong>sampling_rate</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The sampling rate at which the <code>raw_speech</code> input was sampled. It is strongly recommended to pass
<code>sampling_rate</code> at the forward call to prevent silent errors and allow automatic speech recognition
pipeline. Current model supports sampling rate 16000 and 44100.`,name:"sampling_rate"},{anchor:"transformers.TvltFeatureExtractor.__call__.resample",description:`<strong>resample</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
If the sampling rate is not matched, resample the input audio to match.`,name:"resample"},{anchor:"transformers.TvltFeatureExtractor.__call__.mask_audio",description:`<strong>mask_audio</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to mask input audio for MAE task.`,name:"mask_audio"}],source:"https://github.com/huggingface/transformers/blob/vr_28847/src/transformers/models/deprecated/tvlt/feature_extraction_tvlt.py#L116",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/pr_28847/en/main_classes/image_processor#transformers.BatchFeature"
>BatchFeature</a> with the following fields:</p>
<ul>
<li>
<p><strong>audio_values</strong> — Audio values to be fed to a model, of shape (batch_size, num_channels, height,
width).</p>
</li>
<li>
<p><strong>audio_mask</strong> — Audio masks to be fed to a model, of shape (batch_size, num_audio_patches).</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/pr_28847/en/main_classes/image_processor#transformers.BatchFeature"
>BatchFeature</a></p>
`}}),$e=new Z({props:{title:"TvltModel",local:"transformers.TvltModel",headingTag:"h2"}}),Me=new j({props:{name:"class transformers.TvltModel",anchor:"transformers.TvltModel",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.TvltModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/pr_28847/en/model_doc/tvlt#transformers.TvltConfig">TvltConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/pr_28847/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/vr_28847/src/transformers/models/deprecated/tvlt/modeling_tvlt.py#L657"}}),Pe=new j({props:{name:"forward",anchor:"transformers.TvltModel.forward",parameters:[{name:"pixel_values",val:": FloatTensor"},{name:"audio_values",val:": FloatTensor"},{name:"pixel_mask",val:": Optional = None"},{name:"audio_mask",val:": Optional = None"},{name:"mask_pixel",val:": bool = False"},{name:"mask_audio",val:": bool = False"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"return_dict",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.TvltModel.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_frames, num_channels, height, width)</code>) &#x2014;
Pixel values. Pixel values can be obtained using <a href="/docs/transformers/pr_28847/en/model_doc/tvlt#transformers.TvltProcessor">TvltProcessor</a>. See <a href="/docs/transformers/pr_28847/en/model_doc/tvlt#transformers.TvltProcessor.__call__">TvltProcessor.<strong>call</strong>()</a> for
details.`,name:"pixel_values"},{anchor:"transformers.TvltModel.forward.audio_values",description:`<strong>audio_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Audio values. Audio values can be obtained using <a href="/docs/transformers/pr_28847/en/model_doc/tvlt#transformers.TvltProcessor">TvltProcessor</a>. See <a href="/docs/transformers/pr_28847/en/model_doc/tvlt#transformers.TvltProcessor.__call__">TvltProcessor.<strong>call</strong>()</a> for
details.`,name:"audio_values"},{anchor:"transformers.TvltModel.forward.pixel_mask",description:`<strong>pixel_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_pixel_patches)</code>) &#x2014;
Pixel masks. Pixel masks can be obtained using <a href="/docs/transformers/pr_28847/en/model_doc/tvlt#transformers.TvltProcessor">TvltProcessor</a>. See <a href="/docs/transformers/pr_28847/en/model_doc/tvlt#transformers.TvltProcessor.__call__">TvltProcessor.<strong>call</strong>()</a> for
details.`,name:"pixel_mask"},{anchor:"transformers.TvltModel.forward.audio_mask",description:`<strong>audio_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_audio_patches)</code>) &#x2014;
Audio masks. Audio masks can be obtained using <a href="/docs/transformers/pr_28847/en/model_doc/tvlt#transformers.TvltProcessor">TvltProcessor</a>. See <a href="/docs/transformers/pr_28847/en/model_doc/tvlt#transformers.TvltProcessor.__call__">TvltProcessor.<strong>call</strong>()</a> for
details.`,name:"audio_mask"},{anchor:"transformers.TvltModel.forward.pixel_values_mixed",description:`<strong>pixel_values_mixed</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_frames, num_channels, height, width)</code>) &#x2014;
Pixel values that mix positive and negative samples in Tvlt vision-audio matching. Pixel values mixed can
be obtained using <a href="/docs/transformers/pr_28847/en/model_doc/tvlt#transformers.TvltProcessor">TvltProcessor</a>. See <a href="/docs/transformers/pr_28847/en/model_doc/tvlt#transformers.TvltProcessor.__call__">TvltProcessor.<strong>call</strong>()</a> for details.`,name:"pixel_values_mixed"},{anchor:"transformers.TvltModel.forward.pixel_mask_mixed",description:`<strong>pixel_mask_mixed</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel masks of pixel_values_mixed. Pixel masks mixed can be obtained using <a href="/docs/transformers/pr_28847/en/model_doc/tvlt#transformers.TvltProcessor">TvltProcessor</a>. See
<a href="/docs/transformers/pr_28847/en/model_doc/tvlt#transformers.TvltProcessor.__call__">TvltProcessor.<strong>call</strong>()</a> for details.`,name:"pixel_mask_mixed"},{anchor:"transformers.TvltModel.forward.mask_pixel",description:`<strong>mask_pixel</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to mask pixel for MAE tasks. Only set to True in TvltForPreTraining.`,name:"mask_pixel"},{anchor:"transformers.TvltModel.forward.mask_audio",description:`<strong>mask_audio</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to mask audio for MAE tasks. Only set to True in TvltForPreTraining.`,name:"mask_audio"},{anchor:"transformers.TvltModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.TvltModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.TvltModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/pr_28847/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/vr_28847/src/transformers/models/deprecated/tvlt/modeling_tvlt.py#L691",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.models.deprecated.tvlt.modeling_tvlt.TvltModelOutput</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/pr_28847/en/model_doc/tvlt#transformers.TvltConfig"
>TvltConfig</a>) and inputs.</p>
<ul>
<li><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the model.</li>
<li><strong>last_pixel_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, pixel_sequence_length, hidden_size)</code>) — Pixel sequence of hidden-states at the output of the last layer of the model.</li>
<li><strong>last_audio_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, audio_sequence_length, hidden_size)</code>) — Audio sequence of hidden-states at the output of the last layer of the model.</li>
<li><strong>pixel_label_masks</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, pixel_patch_length)</code>) — Tensor indicating which pixel patches are masked (1) and which are not (0).</li>
<li><strong>audio_label_masks</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, audio_patch_length)</code>) — Tensor indicating which audio patches are masked (1) and which are not (0).</li>
<li><strong>pixel_ids_restore</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, pixel_patch_length)</code>) — Tensor containing the ids permutation of pixel masking.</li>
<li><strong>audio_ids_restore</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, audio_patch_length)</code>) — Tensor containing the ids permutation of audio masking.</li>
<li><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings and one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the model at the output of each layer
plus the initial embedding outputs.</li>
<li><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights after the attention softmax, used to compute the weighted average in
the self-attention heads.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.models.deprecated.tvlt.modeling_tvlt.TvltModelOutput</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),G=new Ct({props:{$$slots:{default:[Ho]},$$scope:{ctx:y}}}),X=new Ft({props:{anchor:"transformers.TvltModel.forward.example",$$slots:{default:[qo]},$$scope:{ctx:y}}}),ke=new Z({props:{title:"TvltForPreTraining",local:"transformers.TvltForPreTraining",headingTag:"h2"}}),ze=new j({props:{name:"class transformers.TvltForPreTraining",anchor:"transformers.TvltForPreTraining",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.TvltForPreTraining.config",description:`<strong>config</strong> (<a href="/docs/transformers/pr_28847/en/model_doc/tvlt#transformers.TvltConfig">TvltConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/pr_28847/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/vr_28847/src/transformers/models/deprecated/tvlt/modeling_tvlt.py#L882"}}),Ce=new j({props:{name:"forward",anchor:"transformers.TvltForPreTraining.forward",parameters:[{name:"pixel_values",val:": FloatTensor"},{name:"audio_values",val:": FloatTensor"},{name:"pixel_mask",val:": Optional = None"},{name:"audio_mask",val:": Optional = None"},{name:"labels",val:": Optional = None"},{name:"pixel_values_mixed",val:": Optional = None"},{name:"pixel_mask_mixed",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"return_dict",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.TvltForPreTraining.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_frames, num_channels, height, width)</code>) &#x2014;
Pixel values. Pixel values can be obtained using <a href="/docs/transformers/pr_28847/en/model_doc/tvlt#transformers.TvltProcessor">TvltProcessor</a>. See <a href="/docs/transformers/pr_28847/en/model_doc/tvlt#transformers.TvltProcessor.__call__">TvltProcessor.<strong>call</strong>()</a> for
details.`,name:"pixel_values"},{anchor:"transformers.TvltForPreTraining.forward.audio_values",description:`<strong>audio_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Audio values. Audio values can be obtained using <a href="/docs/transformers/pr_28847/en/model_doc/tvlt#transformers.TvltProcessor">TvltProcessor</a>. See <a href="/docs/transformers/pr_28847/en/model_doc/tvlt#transformers.TvltProcessor.__call__">TvltProcessor.<strong>call</strong>()</a> for
details.`,name:"audio_values"},{anchor:"transformers.TvltForPreTraining.forward.pixel_mask",description:`<strong>pixel_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_pixel_patches)</code>) &#x2014;
Pixel masks. Pixel masks can be obtained using <a href="/docs/transformers/pr_28847/en/model_doc/tvlt#transformers.TvltProcessor">TvltProcessor</a>. See <a href="/docs/transformers/pr_28847/en/model_doc/tvlt#transformers.TvltProcessor.__call__">TvltProcessor.<strong>call</strong>()</a> for
details.`,name:"pixel_mask"},{anchor:"transformers.TvltForPreTraining.forward.audio_mask",description:`<strong>audio_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_audio_patches)</code>) &#x2014;
Audio masks. Audio masks can be obtained using <a href="/docs/transformers/pr_28847/en/model_doc/tvlt#transformers.TvltProcessor">TvltProcessor</a>. See <a href="/docs/transformers/pr_28847/en/model_doc/tvlt#transformers.TvltProcessor.__call__">TvltProcessor.<strong>call</strong>()</a> for
details.`,name:"audio_mask"},{anchor:"transformers.TvltForPreTraining.forward.pixel_values_mixed",description:`<strong>pixel_values_mixed</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_frames, num_channels, height, width)</code>) &#x2014;
Pixel values that mix positive and negative samples in Tvlt vision-audio matching. Pixel values mixed can
be obtained using <a href="/docs/transformers/pr_28847/en/model_doc/tvlt#transformers.TvltProcessor">TvltProcessor</a>. See <a href="/docs/transformers/pr_28847/en/model_doc/tvlt#transformers.TvltProcessor.__call__">TvltProcessor.<strong>call</strong>()</a> for details.`,name:"pixel_values_mixed"},{anchor:"transformers.TvltForPreTraining.forward.pixel_mask_mixed",description:`<strong>pixel_mask_mixed</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel masks of pixel_values_mixed. Pixel masks mixed can be obtained using <a href="/docs/transformers/pr_28847/en/model_doc/tvlt#transformers.TvltProcessor">TvltProcessor</a>. See
<a href="/docs/transformers/pr_28847/en/model_doc/tvlt#transformers.TvltProcessor.__call__">TvltProcessor.<strong>call</strong>()</a> for details.`,name:"pixel_mask_mixed"},{anchor:"transformers.TvltForPreTraining.forward.mask_pixel",description:`<strong>mask_pixel</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to mask pixel for MAE tasks. Only set to True in TvltForPreTraining.`,name:"mask_pixel"},{anchor:"transformers.TvltForPreTraining.forward.mask_audio",description:`<strong>mask_audio</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to mask audio for MAE tasks. Only set to True in TvltForPreTraining.`,name:"mask_audio"},{anchor:"transformers.TvltForPreTraining.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.TvltForPreTraining.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.TvltForPreTraining.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/pr_28847/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.TvltForPreTraining.forward.pixel_values_mixed",description:`<strong>pixel_values_mixed</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_frames, num_channels, height, width)</code>) &#x2014;
Pixel values that mix positive and negative samples in Tvlt vision-audio matching. Audio values can be
obtained using <a href="/docs/transformers/pr_28847/en/model_doc/tvlt#transformers.TvltProcessor">TvltProcessor</a>. See <a href="/docs/transformers/pr_28847/en/model_doc/tvlt#transformers.TvltProcessor.__call__">TvltProcessor.<strong>call</strong>()</a> for details.`,name:"pixel_values_mixed"},{anchor:"transformers.TvltForPreTraining.forward.pixel_mask_mixed",description:`<strong>pixel_mask_mixed</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel masks of pixel_values_mixed. Pixel values mixed can be obtained using <a href="/docs/transformers/pr_28847/en/model_doc/tvlt#transformers.TvltProcessor">TvltProcessor</a>. See
<a href="/docs/transformers/pr_28847/en/model_doc/tvlt#transformers.TvltProcessor.__call__">TvltProcessor.<strong>call</strong>()</a> for details.`,name:"pixel_mask_mixed"},{anchor:"transformers.TvltForPreTraining.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, num_labels)</code>, <em>optional</em>) &#x2014;
Labels for computing the vision audio matching loss. Indices should be in <code>[0, 1]</code>. num_labels has to be 1.`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/vr_28847/src/transformers/models/deprecated/tvlt/modeling_tvlt.py#L1019",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.models.deprecated.tvlt.modeling_tvlt.TvltForPreTrainingOutput</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/pr_28847/en/model_doc/tvlt#transformers.TvltConfig"
>TvltConfig</a>) and inputs.</p>
<ul>
<li><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>) — Pixel reconstruction loss.</li>
<li><strong>matching_logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, 1)</code>) — Matching objective logits.</li>
<li><strong>pixel_logits</strong> (<code>torch.FloatTensor</code> of shape
<code>(batch_size, pixel_patch_length, image_patch_size ** 3 * pixel_num_channels)</code>): Pixel reconstruction
logits.</li>
<li><strong>audio_logits</strong> (<code>torch.FloatTensor</code> of shape
<code>(batch_size, audio_patch_length, image_patch_size[0] * image_patch_size[1])</code>): Audio reconstruction
logits.</li>
<li><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings and one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the model at the output of each layer
plus the initial embedding outputs.</li>
<li><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights after the attention softmax, used to compute the weighted average in
the self-attention heads.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.models.deprecated.tvlt.modeling_tvlt.TvltForPreTrainingOutput</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),Q=new Ct({props:{$$slots:{default:[Ro]},$$scope:{ctx:y}}}),Y=new Ft({props:{anchor:"transformers.TvltForPreTraining.forward.example",$$slots:{default:[So]},$$scope:{ctx:y}}}),Fe=new Z({props:{title:"TvltForAudioVisualClassification",local:"transformers.TvltForAudioVisualClassification",headingTag:"h2"}}),je=new j({props:{name:"class transformers.TvltForAudioVisualClassification",anchor:"transformers.TvltForAudioVisualClassification",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.TvltForAudioVisualClassification.config",description:`<strong>config</strong> (<a href="/docs/transformers/pr_28847/en/model_doc/tvlt#transformers.TvltConfig">TvltConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/pr_28847/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/vr_28847/src/transformers/models/deprecated/tvlt/modeling_tvlt.py#L1195"}}),Ie=new j({props:{name:"forward",anchor:"transformers.TvltForAudioVisualClassification.forward",parameters:[{name:"pixel_values",val:": FloatTensor"},{name:"audio_values",val:": FloatTensor"},{name:"pixel_mask",val:": Optional = None"},{name:"audio_mask",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"return_dict",val:": Optional = None"},{name:"labels",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.TvltForAudioVisualClassification.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_frames, num_channels, height, width)</code>) &#x2014;
Pixel values. Pixel values can be obtained using <a href="/docs/transformers/pr_28847/en/model_doc/tvlt#transformers.TvltProcessor">TvltProcessor</a>. See <a href="/docs/transformers/pr_28847/en/model_doc/tvlt#transformers.TvltProcessor.__call__">TvltProcessor.<strong>call</strong>()</a> for
details.`,name:"pixel_values"},{anchor:"transformers.TvltForAudioVisualClassification.forward.audio_values",description:`<strong>audio_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Audio values. Audio values can be obtained using <a href="/docs/transformers/pr_28847/en/model_doc/tvlt#transformers.TvltProcessor">TvltProcessor</a>. See <a href="/docs/transformers/pr_28847/en/model_doc/tvlt#transformers.TvltProcessor.__call__">TvltProcessor.<strong>call</strong>()</a> for
details.`,name:"audio_values"},{anchor:"transformers.TvltForAudioVisualClassification.forward.pixel_mask",description:`<strong>pixel_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_pixel_patches)</code>) &#x2014;
Pixel masks. Pixel masks can be obtained using <a href="/docs/transformers/pr_28847/en/model_doc/tvlt#transformers.TvltProcessor">TvltProcessor</a>. See <a href="/docs/transformers/pr_28847/en/model_doc/tvlt#transformers.TvltProcessor.__call__">TvltProcessor.<strong>call</strong>()</a> for
details.`,name:"pixel_mask"},{anchor:"transformers.TvltForAudioVisualClassification.forward.audio_mask",description:`<strong>audio_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_audio_patches)</code>) &#x2014;
Audio masks. Audio masks can be obtained using <a href="/docs/transformers/pr_28847/en/model_doc/tvlt#transformers.TvltProcessor">TvltProcessor</a>. See <a href="/docs/transformers/pr_28847/en/model_doc/tvlt#transformers.TvltProcessor.__call__">TvltProcessor.<strong>call</strong>()</a> for
details.`,name:"audio_mask"},{anchor:"transformers.TvltForAudioVisualClassification.forward.pixel_values_mixed",description:`<strong>pixel_values_mixed</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_frames, num_channels, height, width)</code>) &#x2014;
Pixel values that mix positive and negative samples in Tvlt vision-audio matching. Pixel values mixed can
be obtained using <a href="/docs/transformers/pr_28847/en/model_doc/tvlt#transformers.TvltProcessor">TvltProcessor</a>. See <a href="/docs/transformers/pr_28847/en/model_doc/tvlt#transformers.TvltProcessor.__call__">TvltProcessor.<strong>call</strong>()</a> for details.`,name:"pixel_values_mixed"},{anchor:"transformers.TvltForAudioVisualClassification.forward.pixel_mask_mixed",description:`<strong>pixel_mask_mixed</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel masks of pixel_values_mixed. Pixel masks mixed can be obtained using <a href="/docs/transformers/pr_28847/en/model_doc/tvlt#transformers.TvltProcessor">TvltProcessor</a>. See
<a href="/docs/transformers/pr_28847/en/model_doc/tvlt#transformers.TvltProcessor.__call__">TvltProcessor.<strong>call</strong>()</a> for details.`,name:"pixel_mask_mixed"},{anchor:"transformers.TvltForAudioVisualClassification.forward.mask_pixel",description:`<strong>mask_pixel</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to mask pixel for MAE tasks. Only set to True in TvltForPreTraining.`,name:"mask_pixel"},{anchor:"transformers.TvltForAudioVisualClassification.forward.mask_audio",description:`<strong>mask_audio</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to mask audio for MAE tasks. Only set to True in TvltForPreTraining.`,name:"mask_audio"},{anchor:"transformers.TvltForAudioVisualClassification.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.TvltForAudioVisualClassification.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.TvltForAudioVisualClassification.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/pr_28847/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.TvltForAudioVisualClassification.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, num_labels)</code>, <em>optional</em>) &#x2014;
Labels for computing the audiovisual loss. Indices should be in <code>[0, ..., num_classes-1]</code> where num_classes
refers to the number of classes in audiovisual tasks.`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/vr_28847/src/transformers/models/deprecated/tvlt/modeling_tvlt.py#L1220",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/pr_28847/en/main_classes/output#transformers.modeling_outputs.SequenceClassifierOutput"
>transformers.modeling_outputs.SequenceClassifierOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/pr_28847/en/model_doc/tvlt#transformers.TvltConfig"
>TvltConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Classification (or regression if config.num_labels==1) loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.num_labels)</code>) — Classification (or regression if config.num_labels==1) scores (before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/pr_28847/en/main_classes/output#transformers.modeling_outputs.SequenceClassifierOutput"
>transformers.modeling_outputs.SequenceClassifierOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),O=new Ct({props:{$$slots:{default:[Do]},$$scope:{ctx:y}}}),K=new Ft({props:{anchor:"transformers.TvltForAudioVisualClassification.forward.example",$$slots:{default:[Go]},$$scope:{ctx:y}}}),We=new No({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/tvlt.md"}}),{c(){o=c("meta"),b=n(),d=c("p"),p=n(),f(x.$$.fragment),s=n(),f(w.$$.fragment),rt=n(),f(ne.$$.fragment),st=n(),ae=c("p"),ae.innerHTML=co,nt=n(),le=c("p"),le.textContent=mo,at=n(),ie=c("p"),ie.innerHTML=po,lt=n(),H=c("p"),H.innerHTML=fo,it=n(),de=c("small"),de.innerHTML=ho,dt=n(),ce=c("p"),ce.innerHTML=uo,ct=n(),f(me.$$.fragment),mt=n(),pe=c("ul"),pe.innerHTML=go,pt=n(),f(fe.$$.fragment),ft=n(),P=c("div"),f(he.$$.fragment),It=n(),Ve=c("p"),Ve.innerHTML=_o,Wt=n(),Ae=c("p"),Ae.innerHTML=vo,Jt=n(),f(q.$$.fragment),ht=n(),f(ue.$$.fragment),ut=n(),k=c("div"),f(ge.$$.fragment),Lt=n(),Ee=c("p"),Ee.textContent=To,Ut=n(),Ne=c("p"),Ne.innerHTML=bo,Vt=n(),R=c("div"),f(_e.$$.fragment),At=n(),Ze=c("p"),Ze.innerHTML=xo,gt=n(),f(ve.$$.fragment),_t=n(),z=c("div"),f(Te.$$.fragment),Et=n(),Be=c("p"),Be.textContent=wo,Nt=n(),He=c("p"),He.textContent=yo,Zt=n(),S=c("div"),f(be.$$.fragment),Bt=n(),qe=c("p"),qe.textContent=$o,vt=n(),f(xe.$$.fragment),Tt=n(),C=c("div"),f(we.$$.fragment),Ht=n(),Re=c("p"),Re.textContent=Mo,qt=n(),Se=c("p"),Se.innerHTML=Po,Rt=n(),D=c("div"),f(ye.$$.fragment),St=n(),De=c("p"),De.textContent=ko,bt=n(),f($e.$$.fragment),xt=n(),L=c("div"),f(Me.$$.fragment),Dt=n(),Ge=c("p"),Ge.innerHTML=zo,Gt=n(),I=c("div"),f(Pe.$$.fragment),Xt=n(),Xe=c("p"),Xe.innerHTML=Co,Qt=n(),f(G.$$.fragment),Yt=n(),f(X.$$.fragment),wt=n(),f(ke.$$.fragment),yt=n(),U=c("div"),f(ze.$$.fragment),Ot=n(),Qe=c("p"),Qe.innerHTML=Fo,Kt=n(),W=c("div"),f(Ce.$$.fragment),eo=n(),Ye=c("p"),Ye.innerHTML=jo,to=n(),f(Q.$$.fragment),oo=n(),f(Y.$$.fragment),$t=n(),f(Fe.$$.fragment),Mt=n(),F=c("div"),f(je.$$.fragment),ro=n(),Oe=c("p"),Oe.textContent=Io,so=n(),Ke=c("p"),Ke.innerHTML=Wo,no=n(),J=c("div"),f(Ie.$$.fragment),ao=n(),et=c("p"),et.innerHTML=Jo,lo=n(),f(O.$$.fragment),io=n(),f(K.$$.fragment),Pt=n(),f(We.$$.fragment),kt=n(),ot=c("p"),this.h()},l(e){const t=Eo("svelte-u9bgzb",document.head);o=m(t,"META",{name:!0,content:!0}),t.forEach(r),b=a(e),d=m(e,"P",{}),M(d).forEach(r),p=a(e),h(x.$$.fragment,e),s=a(e),h(w.$$.fragment,e),rt=a(e),h(ne.$$.fragment,e),st=a(e),ae=m(e,"P",{"data-svelte-h":!0}),T(ae)!=="svelte-1j6pnqq"&&(ae.innerHTML=co),nt=a(e),le=m(e,"P",{"data-svelte-h":!0}),T(le)!=="svelte-vfdo9a"&&(le.textContent=mo),at=a(e),ie=m(e,"P",{"data-svelte-h":!0}),T(ie)!=="svelte-ljwzyy"&&(ie.innerHTML=po),lt=a(e),H=m(e,"P",{align:!0,"data-svelte-h":!0}),T(H)!=="svelte-ed08bp"&&(H.innerHTML=fo),it=a(e),de=m(e,"SMALL",{"data-svelte-h":!0}),T(de)!=="svelte-wspkwq"&&(de.innerHTML=ho),dt=a(e),ce=m(e,"P",{"data-svelte-h":!0}),T(ce)!=="svelte-1l9k3o8"&&(ce.innerHTML=uo),ct=a(e),h(me.$$.fragment,e),mt=a(e),pe=m(e,"UL",{"data-svelte-h":!0}),T(pe)!=="svelte-1duzeay"&&(pe.innerHTML=go),pt=a(e),h(fe.$$.fragment,e),ft=a(e),P=m(e,"DIV",{class:!0});var V=M(P);h(he.$$.fragment,V),It=a(V),Ve=m(V,"P",{"data-svelte-h":!0}),T(Ve)!=="svelte-4mbz26"&&(Ve.innerHTML=_o),Wt=a(V),Ae=m(V,"P",{"data-svelte-h":!0}),T(Ae)!=="svelte-1g3rejj"&&(Ae.innerHTML=vo),Jt=a(V),h(q.$$.fragment,V),V.forEach(r),ht=a(e),h(ue.$$.fragment,e),ut=a(e),k=m(e,"DIV",{class:!0});var A=M(k);h(ge.$$.fragment,A),Lt=a(A),Ee=m(A,"P",{"data-svelte-h":!0}),T(Ee)!=="svelte-8bsxll"&&(Ee.textContent=To),Ut=a(A),Ne=m(A,"P",{"data-svelte-h":!0}),T(Ne)!=="svelte-1glso8c"&&(Ne.innerHTML=bo),Vt=a(A),R=m(A,"DIV",{class:!0});var Je=M(R);h(_e.$$.fragment,Je),At=a(Je),Ze=m(Je,"P",{"data-svelte-h":!0}),T(Ze)!=="svelte-1b7dpfe"&&(Ze.innerHTML=xo),Je.forEach(r),A.forEach(r),gt=a(e),h(ve.$$.fragment,e),_t=a(e),z=m(e,"DIV",{class:!0});var E=M(z);h(Te.$$.fragment,E),Et=a(E),Be=m(E,"P",{"data-svelte-h":!0}),T(Be)!=="svelte-65bl5u"&&(Be.textContent=wo),Nt=a(E),He=m(E,"P",{"data-svelte-h":!0}),T(He)!=="svelte-ei0q9"&&(He.textContent=yo),Zt=a(E),S=m(E,"DIV",{class:!0});var Le=M(S);h(be.$$.fragment,Le),Bt=a(Le),qe=m(Le,"P",{"data-svelte-h":!0}),T(qe)!=="svelte-13oa8s2"&&(qe.textContent=$o),Le.forEach(r),E.forEach(r),vt=a(e),h(xe.$$.fragment,e),Tt=a(e),C=m(e,"DIV",{class:!0});var N=M(C);h(we.$$.fragment,N),Ht=a(N),Re=m(N,"P",{"data-svelte-h":!0}),T(Re)!=="svelte-qe6aof"&&(Re.textContent=Mo),qt=a(N),Se=m(N,"P",{"data-svelte-h":!0}),T(Se)!=="svelte-17z09fk"&&(Se.innerHTML=Po),Rt=a(N),D=m(N,"DIV",{class:!0});var Ue=M(D);h(ye.$$.fragment,Ue),St=a(Ue),De=m(Ue,"P",{"data-svelte-h":!0}),T(De)!=="svelte-17x37gq"&&(De.textContent=ko),Ue.forEach(r),N.forEach(r),bt=a(e),h($e.$$.fragment,e),xt=a(e),L=m(e,"DIV",{class:!0});var B=M(L);h(Me.$$.fragment,B),Dt=a(B),Ge=m(B,"P",{"data-svelte-h":!0}),T(Ge)!=="svelte-1ikd8n"&&(Ge.innerHTML=zo),Gt=a(B),I=m(B,"DIV",{class:!0});var ee=M(I);h(Pe.$$.fragment,ee),Xt=a(ee),Xe=m(ee,"P",{"data-svelte-h":!0}),T(Xe)!=="svelte-ll2f2o"&&(Xe.innerHTML=Co),Qt=a(ee),h(G.$$.fragment,ee),Yt=a(ee),h(X.$$.fragment,ee),ee.forEach(r),B.forEach(r),wt=a(e),h(ke.$$.fragment,e),yt=a(e),U=m(e,"DIV",{class:!0});var tt=M(U);h(ze.$$.fragment,tt),Ot=a(tt),Qe=m(tt,"P",{"data-svelte-h":!0}),T(Qe)!=="svelte-vodnrg"&&(Qe.innerHTML=Fo),Kt=a(tt),W=m(tt,"DIV",{class:!0});var te=M(W);h(Ce.$$.fragment,te),eo=a(te),Ye=m(te,"P",{"data-svelte-h":!0}),T(Ye)!=="svelte-14qebo8"&&(Ye.innerHTML=jo),to=a(te),h(Q.$$.fragment,te),oo=a(te),h(Y.$$.fragment,te),te.forEach(r),tt.forEach(r),$t=a(e),h(Fe.$$.fragment,e),Mt=a(e),F=m(e,"DIV",{class:!0});var oe=M(F);h(je.$$.fragment,oe),ro=a(oe),Oe=m(oe,"P",{"data-svelte-h":!0}),T(Oe)!=="svelte-7shntb"&&(Oe.textContent=Io),so=a(oe),Ke=m(oe,"P",{"data-svelte-h":!0}),T(Ke)!=="svelte-1gjh92c"&&(Ke.innerHTML=Wo),no=a(oe),J=m(oe,"DIV",{class:!0});var re=M(J);h(Ie.$$.fragment,re),ao=a(re),et=m(re,"P",{"data-svelte-h":!0}),T(et)!=="svelte-yc1y7e"&&(et.innerHTML=Jo),lo=a(re),h(O.$$.fragment,re),io=a(re),h(K.$$.fragment,re),re.forEach(r),oe.forEach(r),Pt=a(e),h(We.$$.fragment,e),kt=a(e),ot=m(e,"P",{}),M(ot).forEach(r),this.h()},h(){$(o,"name","hf:doc:metadata"),$(o,"content",Qo),$(H,"align","center"),$(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){l(document.head,o),i(e,b,t),i(e,d,t),i(e,p,t),u(x,e,t),i(e,s,t),u(w,e,t),i(e,rt,t),u(ne,e,t),i(e,st,t),i(e,ae,t),i(e,nt,t),i(e,le,t),i(e,at,t),i(e,ie,t),i(e,lt,t),i(e,H,t),i(e,it,t),i(e,de,t),i(e,dt,t),i(e,ce,t),i(e,ct,t),u(me,e,t),i(e,mt,t),i(e,pe,t),i(e,pt,t),u(fe,e,t),i(e,ft,t),i(e,P,t),u(he,P,null),l(P,It),l(P,Ve),l(P,Wt),l(P,Ae),l(P,Jt),u(q,P,null),i(e,ht,t),u(ue,e,t),i(e,ut,t),i(e,k,t),u(ge,k,null),l(k,Lt),l(k,Ee),l(k,Ut),l(k,Ne),l(k,Vt),l(k,R),u(_e,R,null),l(R,At),l(R,Ze),i(e,gt,t),u(ve,e,t),i(e,_t,t),i(e,z,t),u(Te,z,null),l(z,Et),l(z,Be),l(z,Nt),l(z,He),l(z,Zt),l(z,S),u(be,S,null),l(S,Bt),l(S,qe),i(e,vt,t),u(xe,e,t),i(e,Tt,t),i(e,C,t),u(we,C,null),l(C,Ht),l(C,Re),l(C,qt),l(C,Se),l(C,Rt),l(C,D),u(ye,D,null),l(D,St),l(D,De),i(e,bt,t),u($e,e,t),i(e,xt,t),i(e,L,t),u(Me,L,null),l(L,Dt),l(L,Ge),l(L,Gt),l(L,I),u(Pe,I,null),l(I,Xt),l(I,Xe),l(I,Qt),u(G,I,null),l(I,Yt),u(X,I,null),i(e,wt,t),u(ke,e,t),i(e,yt,t),i(e,U,t),u(ze,U,null),l(U,Ot),l(U,Qe),l(U,Kt),l(U,W),u(Ce,W,null),l(W,eo),l(W,Ye),l(W,to),u(Q,W,null),l(W,oo),u(Y,W,null),i(e,$t,t),u(Fe,e,t),i(e,Mt,t),i(e,F,t),u(je,F,null),l(F,ro),l(F,Oe),l(F,so),l(F,Ke),l(F,no),l(F,J),u(Ie,J,null),l(J,ao),l(J,et),l(J,lo),u(O,J,null),l(J,io),u(K,J,null),i(e,Pt,t),u(We,e,t),i(e,kt,t),i(e,ot,t),zt=!0},p(e,[t]){const V={};t&2&&(V.$$scope={dirty:t,ctx:e}),w.$set(V);const A={};t&2&&(A.$$scope={dirty:t,ctx:e}),q.$set(A);const Je={};t&2&&(Je.$$scope={dirty:t,ctx:e}),G.$set(Je);const E={};t&2&&(E.$$scope={dirty:t,ctx:e}),X.$set(E);const Le={};t&2&&(Le.$$scope={dirty:t,ctx:e}),Q.$set(Le);const N={};t&2&&(N.$$scope={dirty:t,ctx:e}),Y.$set(N);const Ue={};t&2&&(Ue.$$scope={dirty:t,ctx:e}),O.$set(Ue);const B={};t&2&&(B.$$scope={dirty:t,ctx:e}),K.$set(B)},i(e){zt||(g(x.$$.fragment,e),g(w.$$.fragment,e),g(ne.$$.fragment,e),g(me.$$.fragment,e),g(fe.$$.fragment,e),g(he.$$.fragment,e),g(q.$$.fragment,e),g(ue.$$.fragment,e),g(ge.$$.fragment,e),g(_e.$$.fragment,e),g(ve.$$.fragment,e),g(Te.$$.fragment,e),g(be.$$.fragment,e),g(xe.$$.fragment,e),g(we.$$.fragment,e),g(ye.$$.fragment,e),g($e.$$.fragment,e),g(Me.$$.fragment,e),g(Pe.$$.fragment,e),g(G.$$.fragment,e),g(X.$$.fragment,e),g(ke.$$.fragment,e),g(ze.$$.fragment,e),g(Ce.$$.fragment,e),g(Q.$$.fragment,e),g(Y.$$.fragment,e),g(Fe.$$.fragment,e),g(je.$$.fragment,e),g(Ie.$$.fragment,e),g(O.$$.fragment,e),g(K.$$.fragment,e),g(We.$$.fragment,e),zt=!0)},o(e){_(x.$$.fragment,e),_(w.$$.fragment,e),_(ne.$$.fragment,e),_(me.$$.fragment,e),_(fe.$$.fragment,e),_(he.$$.fragment,e),_(q.$$.fragment,e),_(ue.$$.fragment,e),_(ge.$$.fragment,e),_(_e.$$.fragment,e),_(ve.$$.fragment,e),_(Te.$$.fragment,e),_(be.$$.fragment,e),_(xe.$$.fragment,e),_(we.$$.fragment,e),_(ye.$$.fragment,e),_($e.$$.fragment,e),_(Me.$$.fragment,e),_(Pe.$$.fragment,e),_(G.$$.fragment,e),_(X.$$.fragment,e),_(ke.$$.fragment,e),_(ze.$$.fragment,e),_(Ce.$$.fragment,e),_(Q.$$.fragment,e),_(Y.$$.fragment,e),_(Fe.$$.fragment,e),_(je.$$.fragment,e),_(Ie.$$.fragment,e),_(O.$$.fragment,e),_(K.$$.fragment,e),_(We.$$.fragment,e),zt=!1},d(e){e&&(r(b),r(d),r(p),r(s),r(rt),r(st),r(ae),r(nt),r(le),r(at),r(ie),r(lt),r(H),r(it),r(de),r(dt),r(ce),r(ct),r(mt),r(pe),r(pt),r(ft),r(P),r(ht),r(ut),r(k),r(gt),r(_t),r(z),r(vt),r(Tt),r(C),r(bt),r(xt),r(L),r(wt),r(yt),r(U),r($t),r(Mt),r(F),r(Pt),r(kt),r(ot)),r(o),v(x,e),v(w,e),v(ne,e),v(me,e),v(fe,e),v(he),v(q),v(ue,e),v(ge),v(_e),v(ve,e),v(Te),v(be),v(xe,e),v(we),v(ye),v($e,e),v(Me),v(Pe),v(G),v(X),v(ke,e),v(ze),v(Ce),v(Q),v(Y),v(Fe,e),v(je),v(Ie),v(O),v(K),v(We,e)}}}const Qo='{"title":"TVLT","local":"tvlt","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Usage tips","local":"usage-tips","sections":[],"depth":2},{"title":"TvltConfig","local":"transformers.TvltConfig","sections":[],"depth":2},{"title":"TvltProcessor","local":"transformers.TvltProcessor","sections":[],"depth":2},{"title":"TvltImageProcessor","local":"transformers.TvltImageProcessor","sections":[],"depth":2},{"title":"TvltFeatureExtractor","local":"transformers.TvltFeatureExtractor","sections":[],"depth":2},{"title":"TvltModel","local":"transformers.TvltModel","sections":[],"depth":2},{"title":"TvltForPreTraining","local":"transformers.TvltForPreTraining","sections":[],"depth":2},{"title":"TvltForAudioVisualClassification","local":"transformers.TvltForAudioVisualClassification","sections":[],"depth":2}],"depth":1}';function Yo(y){return Uo(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class nr extends Vo{constructor(o){super(),Ao(this,o,Yo,Xo,Lo,{})}}export{nr as component};
