import{s as Ae,f as He,o as Je,n as Ie}from"../chunks/scheduler.f6319a2a.js";import{S as je,i as Ue,g as i,s as o,r as f,A as Ge,h as a,f as n,c as s,j as Pe,u as d,x as r,k as Yt,y as Se,a as l,v as c,d as g,t as w,w as y}from"../chunks/index.85aa684c.js";import{T as We}from"../chunks/Tip.3d397a88.js";import{C as qe}from"../chunks/CodeBlock.97b48fd2.js";import{H as it,E as Be}from"../chunks/EditOnGithub.006048dd.js";function Ee(at){let u,v="AI Agents are <strong>programs where LLM outputs control the workflow</strong>.";return{c(){u=i("p"),u.innerHTML=v},l(p){u=a(p,"P",{"data-svelte-h":!0}),r(u)!=="svelte-1w9gkhf"&&(u.innerHTML=v)},m(p,lt){l(p,u,lt)},p:Ie,d(p){p&&n(u)}}}function Re(at){let u,v,p,lt,x,rt,b,ut,M,Zt="Any efficient system using AI will need to provide LLMs some kind of access to the real world: for instance the possibility to call a search tool to get external information, or to act on certain programs in order to solve a task. In other words, LLMs should have <strong><em>agency</em></strong>. Agentic programs are the gateway to the outside world for LLMs.",pt,m,mt,C,Qt="Any system leveraging LLMs will integrate the LLM outputs into code. The influence of the LLM’s input on the code workflow is the level of agency of LLMs in the system.",ht,L,Dt="Note that with this definition, “agent” is not a discrete, 0 or 1 definition: instead, “agency” evolves on a continuous spectrum, as you give more or less power to the LLM on your workflow.",ft,_,Kt="See in the table below how agency can vary across systems:",dt,$,te="<thead><tr><th>Agency Level</th> <th>Description</th> <th>How that’s called</th> <th>Example Pattern</th></tr></thead> <tbody><tr><td>☆☆☆</td> <td>LLM output has no impact on program flow</td> <td>Simple Processor</td> <td><code>process_llm_output(llm_response)</code></td></tr> <tr><td>★☆☆</td> <td>LLM output determines an if/else switch</td> <td>Router</td> <td><code>if llm_decision(): path_a() else: path_b()</code></td></tr> <tr><td>★★☆</td> <td>LLM output determines function execution</td> <td>Tool Caller</td> <td><code>run_function(llm_chosen_tool, llm_chosen_args)</code></td></tr> <tr><td>★★★</td> <td>LLM output controls iteration and program continuation</td> <td>Multi-step Agent</td> <td><code>while llm_should_continue(): execute_next_step()</code></td></tr> <tr><td>★★★</td> <td>One agentic workflow can start another agentic workflow</td> <td>Multi-Agent</td> <td><code>if llm_trigger(): execute_agent()</code></td></tr></tbody>",ct,k,ee="The multi-step agent has this code structure:",gt,T,wt,P,ne="This agentic system runs in a loop, executing a new action at each step (the action can involve calling some pre-determined <em>tools</em> that are just functions), until its observations make it apparent that a satisfactory state has been reached to solve the given task. Here’s an example of how a multi-step agent can solve a simple math question:",yt,h,le='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/Agent_ManimCE.gif"/>',vt,A,xt,H,oe=`Agents are useful when you need an LLM to determine the workflow of an app. But they’re often overkill. The question is: do I really need flexibility in the workflow to efficiently solve the task at hand?
If the pre-determined workflow falls short too often, that means you need more flexibility.
Let’s take an example: say you’re making an app that handles customer requests on a surfing trip website.`,bt,J,se="You could know in advance that the requests will belong to either of 2 buckets (based on user choice), and you have a predefined workflow for each of these 2 cases.",Mt,I,ie="<li>Want some knowledge on the trips? ⇒ give them access to a search bar to search your knowledge base</li> <li>Wants to talk to sales? ⇒ let them type in a contact form.</li>",Ct,j,ae="If that deterministic workflow fits all queries, by all means just code everything! This will give you a 100% reliable system with no risk of error introduced by letting unpredictable LLMs meddle in your workflow. For the sake of simplicity and robustness, it’s advised to regularize towards not using any agentic behaviour.",Lt,U,re="But what if the workflow can’t be determined that well in advance?",_t,G,ue="For instance, a user wants to ask : <code>&quot;I can come on Monday, but I forgot my passport so risk being delayed to Wednesday, is it possible to take me and my stuff to surf on Tuesday morning, with a cancellation insurance?&quot;</code> This question hinges on many factors, and probably none of the predetermined criteria above will suffice for this request.",$t,S,pe="If the pre-determined workflow falls short too often, that means you need more flexibility.",kt,W,me="That is where an agentic setup helps.",Tt,q,he="In the above example, you could just make a multi-step agent that has access to a weather API for weather forecasts, Google Maps API to compute travel distance, an employee availability dashboard and a RAG system on your knowledge base.",Pt,B,fe="Until recently, computer programs were restricted to pre-determined workflows, trying to handle complexity by piling up  if/else switches. They focused on extremely narrow tasks, like “compute the sum of these numbers” or “find the shortest path in this graph”. But actually, most real-life tasks, like our trip example above, do not fit in pre-determined workflows. Agentic systems open up the vast world of real-world tasks to programs!",At,E,Ht,R,de="For some low-level agentic use cases, like chains or routers, you can write all the code yourself. You’ll be much better that way, since it will let you control and understand your system better.",Jt,N,ce="But once you start going for more complicated behaviours like letting an LLM call a function (that’s “tool calling”) or letting an LLM run a while loop (“multi-step agent”), some abstractions become necessary:",It,V,ge="<li>for tool calling, you need to parse the agent’s output, so this output needs a predefined format like “Thought: I should call tool ‘get_weather’. Action: get_weather(Paris).”, that you parse with a predefined function, and system prompt given to the LLM should notify it about this format.</li> <li>for a multi-step agent where the LLM output determines the loop, you need to give a different prompt to the LLM based on what happened in the last loop iteration: so you need some kind of memory.</li>",jt,z,we="See? With these two examples, we already found the need for a few items to help us:",Ut,O,ye="<li>Of course, an LLM that acts as the engine powering the system</li> <li>A list of tools that the agent can access</li> <li>A parser that extracts tool calls from the LLM output</li> <li>A system prompt synced with the parser</li> <li>A memory</li>",Gt,X,ve="But wait, since we give room to LLMs in decisions, surely they will make mistakes: so we need error logging and retry mechanisms.",St,F,xe="All these elements need tight coupling to make a well-functioning system. That’s why we decided we needed to make basic building blocks to make all this stuff work together.",Wt,Y,qt,Z,be="In a multi-step agent, at each step, the LLM can write an action, in the form of some calls to external tools. A common format (used by Anthropic, OpenAI, and many others) for writing these actions is generally different shades of “writing actions as a JSON of tools names and arguments to use, which you then parse to know which tool to execute and with which arguments”.",Bt,Q,Me='<a href="https://huggingface.co/papers/2402.01030" rel="nofollow">Multiple</a> <a href="https://huggingface.co/papers/2411.01747" rel="nofollow">research</a> <a href="https://huggingface.co/papers/2401.00812" rel="nofollow">papers</a> have shown that having the tool calling LLMs in code is much better.',Et,D,Ce="The reason for this simply that <em>we crafted our code languages specifically to be the best possible way to express actions performed by a computer</em>. If JSON snippets were a better expression, JSON would be the top programming language and programming would be hell on earth.",Rt,K,Le='The figure below, taken from <a href="https://huggingface.co/papers/2402.01030" rel="nofollow">Executable Code Actions Elicit Better LLM Agents</a>, illustrate some advantages of writing actions in code:',Nt,ot,_e,Vt,tt,$e="Writing actions in code rather than JSON-like snippets provides better:",zt,et,ke="<li><strong>Composability:</strong> could you nest JSON actions within each other, or define a set of JSON actions to re-use later, the same way you could just define a python function?</li> <li><strong>Object management:</strong> how do you store the output of an action like <code>generate_image</code> in JSON?</li> <li><strong>Generality:</strong> code is built to express simply anything you can have a computer do.</li> <li><strong>Representation in LLM training data:</strong> plenty of quality code actions is already included in LLMs’ training data which means they’re already trained for this!</li>",Ot,nt,Xt,st,Ft;return x=new it({props:{title:"Introduction to Agents",local:"introduction-to-agents",headingTag:"h1"}}),b=new it({props:{title:"🤔 What are agents?",local:"-what-are-agents",headingTag:"h2"}}),m=new We({props:{warning:!1,$$slots:{default:[Ee]},$$scope:{ctx:at}}}),T=new qe({props:{code:"bWVtb3J5JTIwJTNEJTIwJTVCdXNlcl9kZWZpbmVkX3Rhc2slNUQlMEF3aGlsZSUyMGxsbV9zaG91bGRfY29udGludWUobWVtb3J5KSUzQSUyMCUyMyUyMHRoaXMlMjBsb29wJTIwaXMlMjB0aGUlMjBtdWx0aS1zdGVwJTIwcGFydCUwQSUyMCUyMCUyMCUyMGFjdGlvbiUyMCUzRCUyMGxsbV9nZXRfbmV4dF9hY3Rpb24obWVtb3J5KSUyMCUyMyUyMHRoaXMlMjBpcyUyMHRoZSUyMHRvb2wtY2FsbGluZyUyMHBhcnQlMEElMjAlMjAlMjAlMjBvYnNlcnZhdGlvbnMlMjAlM0QlMjBleGVjdXRlX2FjdGlvbihhY3Rpb24pJTBBJTIwJTIwJTIwJTIwbWVtb3J5JTIwJTJCJTNEJTIwJTVCYWN0aW9uJTJDJTIwb2JzZXJ2YXRpb25zJTVE",highlighted:`memory = [user_defined_task]
<span class="hljs-keyword">while</span> llm_should_continue(memory): <span class="hljs-comment"># this loop is the multi-step part</span>
    action = llm_get_next_action(memory) <span class="hljs-comment"># this is the tool-calling part</span>
    observations = execute_action(action)
    memory += [action, observations]`,wrap:!1}}),A=new it({props:{title:"✅ When to use agents / ⛔ when to avoid them",local:"-when-to-use-agents---when-to-avoid-them",headingTag:"h2"}}),E=new it({props:{title:"Why smolagents ?",local:"why-smolagents-",headingTag:"h2"}}),Y=new it({props:{title:"Code agents",local:"code-agents",headingTag:"h2"}}),nt=new Be({props:{source:"https://github.com/huggingface/smolagents/blob/main/docs/source/en/conceptual_guides/intro_agents.md"}}),{c(){u=i("meta"),v=o(),p=i("p"),lt=o(),f(x.$$.fragment),rt=o(),f(b.$$.fragment),ut=o(),M=i("p"),M.innerHTML=Zt,pt=o(),f(m.$$.fragment),mt=o(),C=i("p"),C.textContent=Qt,ht=o(),L=i("p"),L.textContent=Dt,ft=o(),_=i("p"),_.textContent=Kt,dt=o(),$=i("table"),$.innerHTML=te,ct=o(),k=i("p"),k.textContent=ee,gt=o(),f(T.$$.fragment),wt=o(),P=i("p"),P.innerHTML=ne,yt=o(),h=i("div"),h.innerHTML=le,vt=o(),f(A.$$.fragment),xt=o(),H=i("p"),H.textContent=oe,bt=o(),J=i("p"),J.textContent=se,Mt=o(),I=i("ol"),I.innerHTML=ie,Ct=o(),j=i("p"),j.textContent=ae,Lt=o(),U=i("p"),U.textContent=re,_t=o(),G=i("p"),G.innerHTML=ue,$t=o(),S=i("p"),S.textContent=pe,kt=o(),W=i("p"),W.textContent=me,Tt=o(),q=i("p"),q.textContent=he,Pt=o(),B=i("p"),B.textContent=fe,At=o(),f(E.$$.fragment),Ht=o(),R=i("p"),R.textContent=de,Jt=o(),N=i("p"),N.textContent=ce,It=o(),V=i("ul"),V.innerHTML=ge,jt=o(),z=i("p"),z.textContent=we,Ut=o(),O=i("ul"),O.innerHTML=ye,Gt=o(),X=i("p"),X.textContent=ve,St=o(),F=i("p"),F.textContent=xe,Wt=o(),f(Y.$$.fragment),qt=o(),Z=i("p"),Z.textContent=be,Bt=o(),Q=i("p"),Q.innerHTML=Me,Et=o(),D=i("p"),D.innerHTML=Ce,Rt=o(),K=i("p"),K.innerHTML=Le,Nt=o(),ot=i("img"),Vt=o(),tt=i("p"),tt.textContent=$e,zt=o(),et=i("ul"),et.innerHTML=ke,Ot=o(),f(nt.$$.fragment),Xt=o(),st=i("p"),this.h()},l(t){const e=Ge("svelte-u9bgzb",document.head);u=a(e,"META",{name:!0,content:!0}),e.forEach(n),v=s(t),p=a(t,"P",{}),Pe(p).forEach(n),lt=s(t),d(x.$$.fragment,t),rt=s(t),d(b.$$.fragment,t),ut=s(t),M=a(t,"P",{"data-svelte-h":!0}),r(M)!=="svelte-t8xwkl"&&(M.innerHTML=Zt),pt=s(t),d(m.$$.fragment,t),mt=s(t),C=a(t,"P",{"data-svelte-h":!0}),r(C)!=="svelte-hvpo8l"&&(C.textContent=Qt),ht=s(t),L=a(t,"P",{"data-svelte-h":!0}),r(L)!=="svelte-1ocrk28"&&(L.textContent=Dt),ft=s(t),_=a(t,"P",{"data-svelte-h":!0}),r(_)!=="svelte-15ep98q"&&(_.textContent=Kt),dt=s(t),$=a(t,"TABLE",{"data-svelte-h":!0}),r($)!=="svelte-15ffjce"&&($.innerHTML=te),ct=s(t),k=a(t,"P",{"data-svelte-h":!0}),r(k)!=="svelte-1xdd6c8"&&(k.textContent=ee),gt=s(t),d(T.$$.fragment,t),wt=s(t),P=a(t,"P",{"data-svelte-h":!0}),r(P)!=="svelte-1n725h4"&&(P.innerHTML=ne),yt=s(t),h=a(t,"DIV",{class:!0,"data-svelte-h":!0}),r(h)!=="svelte-znws87"&&(h.innerHTML=le),vt=s(t),d(A.$$.fragment,t),xt=s(t),H=a(t,"P",{"data-svelte-h":!0}),r(H)!=="svelte-1vnvz56"&&(H.textContent=oe),bt=s(t),J=a(t,"P",{"data-svelte-h":!0}),r(J)!=="svelte-16gbieh"&&(J.textContent=se),Mt=s(t),I=a(t,"OL",{"data-svelte-h":!0}),r(I)!=="svelte-1v0rus5"&&(I.innerHTML=ie),Ct=s(t),j=a(t,"P",{"data-svelte-h":!0}),r(j)!=="svelte-d38gnh"&&(j.textContent=ae),Lt=s(t),U=a(t,"P",{"data-svelte-h":!0}),r(U)!=="svelte-16wqlg"&&(U.textContent=re),_t=s(t),G=a(t,"P",{"data-svelte-h":!0}),r(G)!=="svelte-1t7nvsc"&&(G.innerHTML=ue),$t=s(t),S=a(t,"P",{"data-svelte-h":!0}),r(S)!=="svelte-j2eqzu"&&(S.textContent=pe),kt=s(t),W=a(t,"P",{"data-svelte-h":!0}),r(W)!=="svelte-lqbq6n"&&(W.textContent=me),Tt=s(t),q=a(t,"P",{"data-svelte-h":!0}),r(q)!=="svelte-eus48c"&&(q.textContent=he),Pt=s(t),B=a(t,"P",{"data-svelte-h":!0}),r(B)!=="svelte-4d8m3z"&&(B.textContent=fe),At=s(t),d(E.$$.fragment,t),Ht=s(t),R=a(t,"P",{"data-svelte-h":!0}),r(R)!=="svelte-1o6p1sy"&&(R.textContent=de),Jt=s(t),N=a(t,"P",{"data-svelte-h":!0}),r(N)!=="svelte-olr701"&&(N.textContent=ce),It=s(t),V=a(t,"UL",{"data-svelte-h":!0}),r(V)!=="svelte-x1gf7j"&&(V.innerHTML=ge),jt=s(t),z=a(t,"P",{"data-svelte-h":!0}),r(z)!=="svelte-19q6xk9"&&(z.textContent=we),Ut=s(t),O=a(t,"UL",{"data-svelte-h":!0}),r(O)!=="svelte-oysp1q"&&(O.innerHTML=ye),Gt=s(t),X=a(t,"P",{"data-svelte-h":!0}),r(X)!=="svelte-95dd5s"&&(X.textContent=ve),St=s(t),F=a(t,"P",{"data-svelte-h":!0}),r(F)!=="svelte-19mjig0"&&(F.textContent=xe),Wt=s(t),d(Y.$$.fragment,t),qt=s(t),Z=a(t,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-1i79ci0"&&(Z.textContent=be),Bt=s(t),Q=a(t,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-rrucvh"&&(Q.innerHTML=Me),Et=s(t),D=a(t,"P",{"data-svelte-h":!0}),r(D)!=="svelte-16g1ft7"&&(D.innerHTML=Ce),Rt=s(t),K=a(t,"P",{"data-svelte-h":!0}),r(K)!=="svelte-1ngky2"&&(K.innerHTML=Le),Nt=s(t),ot=a(t,"IMG",{src:!0}),Vt=s(t),tt=a(t,"P",{"data-svelte-h":!0}),r(tt)!=="svelte-18lekkw"&&(tt.textContent=$e),zt=s(t),et=a(t,"UL",{"data-svelte-h":!0}),r(et)!=="svelte-kg4c8z"&&(et.innerHTML=ke),Ot=s(t),d(nt.$$.fragment,t),Xt=s(t),st=a(t,"P",{}),Pe(st).forEach(n),this.h()},h(){Yt(u,"name","hf:doc:metadata"),Yt(u,"content",Ne),Yt(h,"class","flex justify-center"),He(ot.src,_e="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/code_vs_json_actions.png")||Yt(ot,"src",_e)},m(t,e){Se(document.head,u),l(t,v,e),l(t,p,e),l(t,lt,e),c(x,t,e),l(t,rt,e),c(b,t,e),l(t,ut,e),l(t,M,e),l(t,pt,e),c(m,t,e),l(t,mt,e),l(t,C,e),l(t,ht,e),l(t,L,e),l(t,ft,e),l(t,_,e),l(t,dt,e),l(t,$,e),l(t,ct,e),l(t,k,e),l(t,gt,e),c(T,t,e),l(t,wt,e),l(t,P,e),l(t,yt,e),l(t,h,e),l(t,vt,e),c(A,t,e),l(t,xt,e),l(t,H,e),l(t,bt,e),l(t,J,e),l(t,Mt,e),l(t,I,e),l(t,Ct,e),l(t,j,e),l(t,Lt,e),l(t,U,e),l(t,_t,e),l(t,G,e),l(t,$t,e),l(t,S,e),l(t,kt,e),l(t,W,e),l(t,Tt,e),l(t,q,e),l(t,Pt,e),l(t,B,e),l(t,At,e),c(E,t,e),l(t,Ht,e),l(t,R,e),l(t,Jt,e),l(t,N,e),l(t,It,e),l(t,V,e),l(t,jt,e),l(t,z,e),l(t,Ut,e),l(t,O,e),l(t,Gt,e),l(t,X,e),l(t,St,e),l(t,F,e),l(t,Wt,e),c(Y,t,e),l(t,qt,e),l(t,Z,e),l(t,Bt,e),l(t,Q,e),l(t,Et,e),l(t,D,e),l(t,Rt,e),l(t,K,e),l(t,Nt,e),l(t,ot,e),l(t,Vt,e),l(t,tt,e),l(t,zt,e),l(t,et,e),l(t,Ot,e),c(nt,t,e),l(t,Xt,e),l(t,st,e),Ft=!0},p(t,[e]){const Te={};e&2&&(Te.$$scope={dirty:e,ctx:t}),m.$set(Te)},i(t){Ft||(g(x.$$.fragment,t),g(b.$$.fragment,t),g(m.$$.fragment,t),g(T.$$.fragment,t),g(A.$$.fragment,t),g(E.$$.fragment,t),g(Y.$$.fragment,t),g(nt.$$.fragment,t),Ft=!0)},o(t){w(x.$$.fragment,t),w(b.$$.fragment,t),w(m.$$.fragment,t),w(T.$$.fragment,t),w(A.$$.fragment,t),w(E.$$.fragment,t),w(Y.$$.fragment,t),w(nt.$$.fragment,t),Ft=!1},d(t){t&&(n(v),n(p),n(lt),n(rt),n(ut),n(M),n(pt),n(mt),n(C),n(ht),n(L),n(ft),n(_),n(dt),n($),n(ct),n(k),n(gt),n(wt),n(P),n(yt),n(h),n(vt),n(xt),n(H),n(bt),n(J),n(Mt),n(I),n(Ct),n(j),n(Lt),n(U),n(_t),n(G),n($t),n(S),n(kt),n(W),n(Tt),n(q),n(Pt),n(B),n(At),n(Ht),n(R),n(Jt),n(N),n(It),n(V),n(jt),n(z),n(Ut),n(O),n(Gt),n(X),n(St),n(F),n(Wt),n(qt),n(Z),n(Bt),n(Q),n(Et),n(D),n(Rt),n(K),n(Nt),n(ot),n(Vt),n(tt),n(zt),n(et),n(Ot),n(Xt),n(st)),n(u),y(x,t),y(b,t),y(m,t),y(T,t),y(A,t),y(E,t),y(Y,t),y(nt,t)}}}const Ne='{"title":"Introduction to Agents","local":"introduction-to-agents","sections":[{"title":"🤔 What are agents?","local":"-what-are-agents","sections":[],"depth":2},{"title":"✅ When to use agents / ⛔ when to avoid them","local":"-when-to-use-agents---when-to-avoid-them","sections":[],"depth":2},{"title":"Why smolagents ?","local":"why-smolagents-","sections":[],"depth":2},{"title":"Code agents","local":"code-agents","sections":[],"depth":2}],"depth":1}';function Ve(at){return Je(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ze extends je{constructor(u){super(),Ue(this,u,Ve,Re,Ae,{})}}export{Ze as component};
