import{s as Vw,o as Rw,n as Lf}from"../chunks/scheduler.25b97de1.js";import{S as Nw,i as zw,g as a,s as n,r,A as Ww,h as p,f as s,c as i,j as Bw,u as d,x as o,k as Xw,y as Lw,a as l,v as f,d as m,t as u,w as c}from"../chunks/index.d9030fc9.js";import{T as Wf}from"../chunks/Tip.baa67368.js";import{C as w}from"../chunks/CodeBlock.e6cd0d95.js";import{H as M,E as Sw}from"../chunks/EditOnGithub.91d95064.js";function Qw(J){let h,T="This plugin doesn’t work with <code>-n</code> flag from <code>pytest-xdist</code>.";return{c(){h=a("p"),h.innerHTML=T},l(y){h=p(y,"P",{"data-svelte-h":!0}),o(h)!=="svelte-1p59ipz"&&(h.innerHTML=T)},m(y,$){l(y,h,$)},p:Lf,d(y){y&&s(h)}}}function Fw(J){let h,T="There is another plugin <code>pytest-repeat</code>, but it doesn’t work with <code>unittest</code>.";return{c(){h=a("p"),h.innerHTML=T},l(y){h=p(y,"P",{"data-svelte-h":!0}),o(h)!=="svelte-huhi42"&&(h.innerHTML=T)},m(y,$){l(y,h,$)},p:Lf,d(y){y&&s(h)}}}function Ew(J){let h,T=`In order to run the equivalent of <code>rm -r</code> safely, only subdirs of the project repository checkout are allowed if
an explicit <code>tmp_dir</code> is used, so that by mistake no <code>/tmp</code> or similar important part of the filesystem will
get nuked. i.e. please always pass paths that start with <code>./</code>.`;return{c(){h=a("p"),h.innerHTML=T},l(y){h=p(y,"P",{"data-svelte-h":!0}),o(h)!=="svelte-1fj8gae"&&(h.innerHTML=T)},m(y,$){l(y,h,$)},p:Lf,d(y){y&&s(h)}}}function Pw(J){let h,T=`Each test can register multiple temporary directories and they all will get auto-removed, unless requested
otherwise.`;return{c(){h=a("p"),h.textContent=T},l(y){h=p(y,"P",{"data-svelte-h":!0}),o(h)!=="svelte-1r50p82"&&(h.textContent=T)},m(y,$){l(y,h,$)},p:Lf,d(y){y&&s(h)}}}function Aw(J){let h,T,y,$,g,ki,U,Sf="Let’s take a look at how 🤗 Transformers models are tested and how you can write new tests and improve the existing ones.",Zi,x,Qf="There are 2 test suites in the repository:",Hi,_,Ff="<li><code>tests</code> — tests for the general API</li> <li><code>examples</code> — tests primarily for various applications that aren’t part of the API</li>",Gi,I,Bi,k,Ef=`<li><p>Once a PR is submitted it gets tested with 9 CircleCi jobs. Every new commit to that PR gets retested. These jobs
are defined in this <a href="https://github.com/huggingface/transformers/tree/main/.circleci/config.yml" rel="nofollow">config file</a>, so that if needed you can reproduce the same
environment on your machine.</p> <p>These CI jobs don’t run <code>@slow</code> tests.</p></li> <li><p>There are 3 jobs run by <a href="https://github.com/huggingface/transformers/actions" rel="nofollow">github actions</a>:</p> <ul><li><p><a href="https://github.com/huggingface/transformers/tree/main/.github/workflows/github-torch-hub.yml" rel="nofollow">torch hub integration</a>: checks whether torch hub
integration works.</p></li> <li><p><a href="https://github.com/huggingface/transformers/tree/main/.github/workflows/self-push.yml" rel="nofollow">self-hosted (push)</a>: runs fast tests on GPU only on commits on
<code>main</code>. It only runs if a commit on <code>main</code> has updated the code in one of the following folders: <code>src</code>,
<code>tests</code>, <code>.github</code> (to prevent running on added model cards, notebooks, etc.)</p></li> <li><p><a href="https://github.com/huggingface/transformers/tree/main/.github/workflows/self-scheduled.yml" rel="nofollow">self-hosted runner</a>: runs normal and slow tests on GPU in
<code>tests</code> and <code>examples</code>:</p></li></ul></li>`,Xi,Z,Vi,H,Pf='The results can be observed <a href="https://github.com/huggingface/transformers/actions" rel="nofollow">here</a>.',Ri,G,Ni,B,zi,X,Af=`This document goes into many details of how tests can be run. If after reading everything, you need even more details
you will find them <a href="https://docs.pytest.org/en/latest/usage.html" rel="nofollow">here</a>.`,Wi,V,Yf="Here are some most useful ways of running tests.",Li,R,qf="Run all:",Si,N,Qi,z,Kf="or:",Fi,W,Ei,L,Df="Note that the latter is defined as:",Pi,S,Ai,Q,Of="which tells pytest to:",Yi,F,em="<li>run as many test processes as they are CPU cores (which could be too many if you don’t have a ton of RAM!)</li> <li>ensure that all tests from the same file will be run by the same test process</li> <li>do not capture output</li> <li>run in verbose mode</li>",qi,E,Ki,P,tm="All tests of the test suite:",Di,A,Oi,Y,sm="All tests of a given test file:",ea,q,ta,K,sa,D,lm="To run an individual test module:",la,O,na,ee,ia,te,nm=`Since unittest is used inside most of the tests, to run specific subtests you need to know the name of the unittest
class containing those tests. For example, it could be:`,aa,se,pa,le,im="Here:",oa,ne,am="<li><code>tests/test_optimization.py</code> - the file with tests</li> <li><code>OptimizationTest</code> - the name of the class</li> <li><code>test_adam_w</code> - the name of the specific test function</li>",ra,ie,pm="If the file contains multiple classes, you can choose to run only tests of a given class. For example:",da,ae,fa,pe,om="will run all the tests inside that class.",ma,oe,rm="As mentioned earlier you can see what tests are contained inside the <code>OptimizationTest</code> class by running:",ua,re,ca,de,dm="You can run tests by keyword expressions.",wa,fe,fm="To run only tests whose name contains <code>adam</code>:",ha,me,ya,ue,mm=`Logical <code>and</code> and <code>or</code> can be used to indicate whether all keywords should match or either. <code>not</code> can be used to
negate.`,Ma,ce,um="To run all tests except those whose name contains <code>adam</code>:",Ta,we,$a,he,cm="And you can combine the two patterns in one:",Ja,ye,ba,Me,wm="For example to run both <code>test_adafactor</code> and <code>test_adam_w</code> you can use:",Ca,Te,ja,$e,hm="Note that we use <code>or</code> here, since we want either of the keywords to match to include both.",va,Je,ym="If you want to include only tests that include both patterns, <code>and</code> is to be used:",ga,be,Ua,Ce,xa,je,Mm="Sometimes you need to run <code>accelerate</code> tests on your models. For that you can just add <code>-m accelerate_tests</code> to your command, if let’s say you want to run these tests on <code>OPT</code> run:",_a,ve,Ia,ge,ka,Ue,Tm=`In order to test whether the documentation examples are correct, you should check that the <code>doctests</code> are passing.
As an example, let’s use <a href="https://github.com/huggingface/transformers/blob/main/src/transformers/models/whisper/modeling_whisper.py#L1017-L1035" rel="nofollow"><code>WhisperModel.forward</code>’s docstring</a>:`,Za,xe,Ha,_e,$m="Just run the following line to automatically test every docstring example in the desired file:",Ga,Ie,Ba,ke,Jm="If the file has a markdown extention, you should add the <code>--doctest-glob=&quot;*.md&quot;</code> argument.",Xa,Ze,Va,He,bm=`You can run the tests related to the unstaged files or the current branch (according to Git) by using <a href="https://github.com/anapaulagomes/pytest-picked" rel="nofollow">pytest-picked</a>. This is a great way of quickly testing your changes didn’t break
anything, since it won’t run the tests related to files you didn’t touch.`,Ra,Ge,Na,Be,za,Xe,Cm="All tests will be run from files and folders which are modified, but not yet committed.",Wa,Ve,La,Re,jm=`<a href="https://github.com/pytest-dev/pytest-xdist" rel="nofollow">pytest-xdist</a> provides a very useful feature of detecting all failed
tests, and then waiting for you to modify files and continuously re-rerun those failing tests until they pass while you
fix them. So that you don’t need to re start pytest after you made the fix. This is repeated until all tests pass after
which again a full run is performed.`,Sa,Ne,Qa,ze,vm="To enter the mode: <code>pytest -f</code> or <code>pytest --looponfail</code>",Fa,We,gm=`File changes are detected by looking at <code>looponfailroots</code> root directories and all of their contents (recursively).
If the default for this value does not work for you, you can change it in your project by setting a configuration
option in <code>setup.cfg</code>:`,Ea,Le,Pa,Se,Um="or <code>pytest.ini</code>/<code>tox.ini</code> files:",Aa,Qe,Ya,Fe,xm=`This would lead to only looking for file changes in the respective directories, specified relatively to the ini-file’s
directory.`,qa,Ee,_m='<a href="https://github.com/joeyespo/pytest-watch" rel="nofollow">pytest-watch</a> is an alternative implementation of this functionality.',Ka,Pe,Da,Ae,Im=`If you want to run all test modules, except a few you can exclude them by giving an explicit list of tests to run. For
example, to run all except <code>test_modeling_*.py</code> tests:`,Oa,Ye,ep,qe,tp,Ke,km="CI builds and when isolation is important (against speed), cache should be cleared:",sp,De,lp,Oe,np,et,Zm=`As mentioned earlier <code>make test</code> runs tests in parallel via <code>pytest-xdist</code> plugin (<code>-n X</code> argument, e.g. <code>-n 2</code>
to run 2 parallel jobs).`,ip,tt,Hm=`<code>pytest-xdist</code>’s <code>--dist=</code> option allows one to control how the tests are grouped. <code>--dist=loadfile</code> puts the
tests located in one file onto the same process.`,ap,st,Gm=`Since the order of executed tests is different and unpredictable, if running the test suite with <code>pytest-xdist</code>
produces failures (meaning we have some undetected coupled tests), use <a href="https://github.com/ESSS/pytest-replay" rel="nofollow">pytest-replay</a> to replay the tests in the same order, which should help with then somehow
reducing that failing sequence to a minimum.`,pp,lt,op,nt,Bm=`It’s good to repeat the tests several times, in sequence, randomly, or in sets, to detect any potential
inter-dependency and state-related bugs (tear down). And the straightforward multiple repetition is just good to detect
some problems that get uncovered by randomness of DL.`,rp,it,dp,at,Xm='<li><a href="https://github.com/dropbox/pytest-flakefinder" rel="nofollow">pytest-flakefinder</a>:</li>',fp,pt,mp,ot,Vm="And then run every test multiple times (50 by default):",up,rt,cp,b,wp,C,hp,dt,yp,ft,Mp,mt,Rm=`Important: the presence of <code>pytest-random-order</code> will automatically randomize tests, no configuration change or
command line options is required.`,Tp,ut,Nm=`As explained earlier this allows detection of coupled tests - where one test’s state affects the state of another. When
<code>pytest-random-order</code> is installed it will print the random seed it used for that session, e.g:`,$p,ct,Jp,wt,zm="So that if the given particular sequence fails, you can reproduce it by adding that exact seed, e.g.:",bp,ht,Cp,yt,Wm=`It will only reproduce the exact order if you use the exact same list of tests (or no list at all). Once you start to
manually narrowing down the list you can no longer rely on the seed, but have to list them manually in the exact order
they failed and tell pytest to not randomize them instead using <code>--random-order-bucket=none</code>, e.g.:`,jp,Mt,vp,Tt,Lm="To disable the shuffling for all tests:",gp,$t,Up,Jt,Sm=`By default <code>--random-order-bucket=module</code> is implied, which will shuffle the files on the module levels. It can also
shuffle on <code>class</code>, <code>package</code>, <code>global</code> and <code>none</code> levels. For the complete details please see its
<a href="https://github.com/jbasko/pytest-random-order" rel="nofollow">documentation</a>.`,xp,bt,Qm=`Another randomization alternative is: <a href="https://github.com/pytest-dev/pytest-randomly" rel="nofollow"><code>pytest-randomly</code></a>. This
module has a very similar functionality/interface, but it doesn’t have the bucket modes available in
<code>pytest-random-order</code>. It has the same problem of imposing itself once installed.`,_p,Ct,Ip,jt,kp,vt,Fm=`<a href="https://github.com/Frozenball/pytest-sugar" rel="nofollow">pytest-sugar</a> is a plugin that improves the look-n-feel, adds a
progressbar, and show tests that fail and the assert instantly. It gets activated automatically upon installation.`,Zp,gt,Hp,Ut,Em="To run tests without it, run:",Gp,xt,Bp,_t,Pm="or uninstall it.",Xp,It,Vp,kt,Am="For a single or a group of tests via <code>pytest</code> (after <code>pip install pytest-pspec</code>):",Rp,Zt,Np,Ht,zp,Gt,Ym=`<a href="https://github.com/pytest-dev/pytest-instafail" rel="nofollow">pytest-instafail</a> shows failures and errors instantly instead of
waiting until the end of test session.`,Wp,Bt,Lp,Xt,Sp,Vt,Qp,Rt,qm="On a GPU-enabled setup, to test in CPU-only mode add <code>CUDA_VISIBLE_DEVICES=&quot;&quot;</code>:",Fp,Nt,Ep,zt,Km=`or if you have multiple gpus, you can specify which one is to be used by <code>pytest</code>. For example, to use only the
second gpu if you have gpus <code>0</code> and <code>1</code>, you can run:`,Pp,Wt,Ap,Lt,Dm="This is handy when you want to run different tasks on different GPUs.",Yp,St,Om=`Some tests must be run on CPU-only, others on either CPU or GPU or TPU, yet others on multiple-GPUs. The following skip
decorators are used to set the requirements of tests CPU/GPU/TPU-wise:`,qp,Qt,eu="<li><code>require_torch</code> - this test will run only under torch</li> <li><code>require_torch_gpu</code> - as <code>require_torch</code> plus requires at least 1 GPU</li> <li><code>require_torch_multi_gpu</code> - as <code>require_torch</code> plus requires at least 2 GPUs</li> <li><code>require_torch_non_multi_gpu</code> - as <code>require_torch</code> plus requires 0 or 1 GPUs</li> <li><code>require_torch_up_to_2_gpus</code> - as <code>require_torch</code> plus requires 0 or 1 or 2 GPUs</li> <li><code>require_torch_xla</code> - as <code>require_torch</code> plus requires at least 1 TPU</li>",Kp,Ft,tu="Let’s depict the GPU requirements in the following table:",Dp,Et,su="<thead><tr><th>n gpus</th> <th>decorator</th></tr></thead> <tbody><tr><td><code>&gt;= 0</code></td> <td><code>@require_torch</code></td></tr> <tr><td><code>&gt;= 1</code></td> <td><code>@require_torch_gpu</code></td></tr> <tr><td><code>&gt;= 2</code></td> <td><code>@require_torch_multi_gpu</code></td></tr> <tr><td><code>&lt; 2</code></td> <td><code>@require_torch_non_multi_gpu</code></td></tr> <tr><td><code>&lt; 3</code></td> <td><code>@require_torch_up_to_2_gpus</code></td></tr></tbody>",Op,Pt,lu="For example, here is a test that must be run only when there are 2 or more GPUs available and pytorch is installed:",eo,At,to,Yt,nu="If a test requires <code>tensorflow</code> use the <code>require_tf</code> decorator. For example:",so,qt,lo,Kt,iu=`These decorators can be stacked. For example, if a test is slow and requires at least one GPU under pytorch, here is
how to set it up:`,no,Dt,io,Ot,au=`Some decorators like <code>@parametrized</code> rewrite test names, therefore <code>@require_*</code> skip decorators have to be listed
last for them to work correctly. Here is an example of the correct usage:`,ao,es,po,ts,pu=`This order problem doesn’t exist with <code>@pytest.mark.parametrize</code>, you can put it first or last and it will still
work. But it only works with non-unittests.`,oo,ss,ou="Inside tests:",ro,ls,ru="<li>How many GPUs are available:</li>",fo,ns,mo,is,uo,as,du="To run the test suite on a specific torch device add <code>TRANSFORMERS_TEST_DEVICE=&quot;$device&quot;</code> where <code>$device</code> is the target backend. For example, to test on CPU only:",co,ps,wo,os,fu="This variable is useful for testing custom or less common PyTorch backends such as <code>mps</code>, <code>xpu</code> or <code>npu</code>. It can also be used to achieve the same effect as <code>CUDA_VISIBLE_DEVICES</code> by targeting specific GPUs or testing in CPU-only mode.",ho,rs,mu="Certain devices will require an additional import after importing <code>torch</code> for the first time. This can be specified using the environment variable <code>TRANSFORMERS_TEST_BACKEND</code>:",yo,ds,Mo,fs,uu="Alternative backends may also require the replacement of device-specific functions. For example <code>torch.cuda.manual_seed</code> may need to be replaced with a device-specific seed setter like <code>torch.npu.manual_seed</code> or <code>torch.xpu.manual_seed</code> to correctly set a random seed on the device. To specify a new backend with backend-specific device functions when running the test suite, create a Python device specification file <code>spec.py</code> in the format:",To,ms,$o,us,cu="This format also allows for specification of any additional imports required. To use this file to replace equivalent methods in the test suite, set the environment variable <code>TRANSFORMERS_TEST_DEVICE_SPEC</code> to the path of the spec file, e.g. <code>TRANSFORMERS_TEST_DEVICE_SPEC=spec.py</code>.",Jo,cs,wu="Currently, only <code>MANUAL_SEED_FN</code>, <code>EMPTY_CACHE_FN</code> and <code>DEVICE_COUNT_FN</code> are supported for device-specific dispatch.",bo,ws,hu="### Distributed training",Co,hs,yu=`<code>pytest</code> can’t deal with distributed training directly. If this is attempted - the sub-processes don’t do the right
thing and end up thinking they are <code>pytest</code> and start running the test suite in loops. It works, however, if one
spawns a normal process that then spawns off multiple workers and manages the IO pipes.`,jo,ys,Mu="Here are some tests that use it:",vo,Ms,Tu='<li><a href="https://github.com/huggingface/transformers/tree/main/tests/trainer/test_trainer_distributed.py" rel="nofollow">test_trainer_distributed.py</a></li> <li><a href="https://github.com/huggingface/transformers/tree/main/tests/deepspeed/test_deepspeed.py" rel="nofollow">test_deepspeed.py</a></li>',go,Ts,$u="To jump right into the execution point, search for the <code>execute_subprocess_async</code> call in those tests.",Uo,$s,Ju="You will need at least 2 GPUs to see these tests in action:",xo,Js,_o,bs,bu="### Output capture",Io,Cs,Cu=`During test execution any output sent to <code>stdout</code> and <code>stderr</code> is captured. If a test or a setup method fails, its
according captured output will usually be shown along with the failure traceback.`,ko,js,ju="To disable output capturing and to get the <code>stdout</code> and <code>stderr</code> normally, use <code>-s</code> or <code>--capture=no</code>:",Zo,vs,Ho,gs,vu="To send test results to JUnit format output:",Go,Us,Bo,xs,gu="### Color control",Xo,_s,Uu="To have no color (e.g., yellow on white background is not readable):",Vo,Is,Ro,ks,xu="### Sending test report to online pastebin service",No,Zs,_u="Creating a URL for each test failure:",zo,Hs,Wo,Gs,Iu=`This will submit test run information to a remote Paste service and provide a URL for each failure. You may select
tests as usual or add for example -x if you only want to send one particular failure.`,Lo,Bs,ku="Creating a URL for a whole test session log:",So,Xs,Qo,Vs,Zu="## Writing tests",Fo,Rs,Hu=`🤗 transformers tests are based on <code>unittest</code>, but run by <code>pytest</code>, so most of the time features from both systems
can be used.`,Eo,Ns,Gu=`You can read <a href="https://docs.pytest.org/en/stable/unittest.html" rel="nofollow">here</a> which features are supported, but the important
thing to remember is that most <code>pytest</code> fixtures don’t work. Neither parametrization, but we use the module
<code>parameterized</code> that works in a similar way.`,Po,zs,Bu="### Parametrization",Ao,Ws,Xu=`Often, there is a need to run the same test multiple times, but with different arguments. It could be done from within
the test, but then there is no way of running that test for just one set of arguments.`,Yo,Ls,qo,Ss,Vu=`Now, by default this test will be run 3 times, each time with the last 3 arguments of <code>test_floor</code> being assigned the
corresponding arguments in the parameter list.`,Ko,Qs,Ru="and you could run just the <code>negative</code> and <code>integer</code> sets of params with:",Do,Fs,Oo,Es,Nu="or all but <code>negative</code> sub-tests, with:",er,Ps,tr,As,zu=`Besides using the <code>-k</code> filter that was just mentioned, you can find out the exact name of each sub-test and run any
or all of them using their exact names.`,sr,Ys,lr,qs,Wu="and it will list:",nr,Ks,ir,Ds,Lu="So now you can run just 2 specific sub-tests:",ar,Os,pr,el,Su=`The module <a href="https://pypi.org/project/parameterized/" rel="nofollow">parameterized</a> which is already in the developer dependencies
of <code>transformers</code> works for both: <code>unittests</code> and <code>pytest</code> tests.`,or,tl,Qu=`If, however, the test is not a <code>unittest</code>, you may use <code>pytest.mark.parametrize</code> (or you may see it being used in
some existing tests, mostly under <code>examples</code>).`,rr,sl,Fu="Here is the same example, this time using <code>pytest</code>’s <code>parametrize</code> marker:",dr,ll,fr,nl,Eu=`Same as with <code>parameterized</code>, with <code>pytest.mark.parametrize</code> you can have a fine control over which sub-tests are
run, if the <code>-k</code> filter doesn’t do the job. Except, this parametrization function creates a slightly different set of
names for the sub-tests. Here is what they look like:`,mr,il,ur,al,Pu="and it will list:",cr,pl,wr,ol,Au="So now you can run just the specific test:",hr,rl,yr,dl,Yu="as in the previous example.",Mr,fl,qu="### Files and directories",Tr,ml,Ku=`In tests often we need to know where things are relative to the current test file, and it’s not trivial since the test
could be invoked from more than one directory or could reside in sub-directories with different depths. A helper class
<code>transformers.test_utils.TestCasePlus</code> solves this problem by sorting out all the basic paths and provides easy
accessors to them:`,$r,ul,Du="<li><p><code>pathlib</code> objects (all fully resolved):</p> <ul><li><code>test_file_path</code> - the current test file path, i.e. <code>__file__</code></li> <li><code>test_file_dir</code> - the directory containing the current test file</li> <li><code>tests_dir</code> - the directory of the <code>tests</code> test suite</li> <li><code>examples_dir</code> - the directory of the <code>examples</code> test suite</li> <li><code>repo_root_dir</code> - the directory of the repository</li> <li><code>src_dir</code> - the directory of <code>src</code> (i.e. where the <code>transformers</code> sub-dir resides)</li></ul></li> <li><p>stringified paths---same as above but these return paths as strings, rather than <code>pathlib</code> objects:</p> <ul><li><code>test_file_path_str</code></li> <li><code>test_file_dir_str</code></li> <li><code>tests_dir_str</code></li> <li><code>examples_dir_str</code></li> <li><code>repo_root_dir_str</code></li> <li><code>src_dir_str</code></li></ul></li>",Jr,cl,Ou=`To start using those all you need is to make sure that the test resides in a subclass of
<code>transformers.test_utils.TestCasePlus</code>. For example:`,br,wl,Cr,hl,ec=`If you don’t need to manipulate paths via <code>pathlib</code> or you just need a path as a string, you can always invoked
<code>str()</code> on the <code>pathlib</code> object or use the accessors ending with <code>_str</code>. For example:`,jr,yl,vr,Ml,tc="### Temporary files and directories",gr,Tl,sc=`Using unique temporary files and directories are essential for parallel test running, so that the tests won’t overwrite
each other’s data. Also we want to get the temporary files and directories removed at the end of each test that created
them. Therefore, using packages like <code>tempfile</code>, which address these needs is essential.`,Ur,$l,lc=`However, when debugging tests, you need to be able to see what goes into the temporary file or directory and you want
to know it’s exact path and not having it randomized on every test re-run.`,xr,Jl,nc=`A helper class <code>transformers.test_utils.TestCasePlus</code> is best used for such purposes. It’s a sub-class of
<code>unittest.TestCase</code>, so we can easily inherit from it in the test modules.`,_r,bl,ic="Here is an example of its usage:",Ir,Cl,kr,jl,ac="This code creates a unique temporary directory, and sets <code>tmp_dir</code> to its location.",Zr,vl,pc="<li>Create a unique temporary dir:</li>",Hr,gl,Gr,Ul,oc=`<code>tmp_dir</code> will contain the path to the created temporary dir. It will be automatically removed at the end of the
test.`,Br,xl,rc="<li>Create a temporary dir of my choice, ensure it’s empty before the test starts and don’t empty it after the test.</li>",Xr,_l,Vr,Il,dc=`This is useful for debug when you want to monitor a specific directory and want to make sure the previous tests didn’t
leave any data in there.`,Rr,kl,fc=`<li><p>You can override the default behavior by directly overriding the <code>before</code> and <code>after</code> args, leading to one of the
following behaviors:</p> <ul><li><code>before=True</code>: the temporary dir will always be cleared at the beginning of the test.</li> <li><code>before=False</code>: if the temporary dir already existed, any existing files will remain there.</li> <li><code>after=True</code>: the temporary dir will always be deleted at the end of the test.</li> <li><code>after=False</code>: the temporary dir will always be left intact at the end of the test.</li></ul></li>`,Nr,j,zr,v,Wr,Zl,mc="### Temporary sys.path override",Lr,Hl,uc=`If you need to temporary override <code>sys.path</code> to import from another test for example, you can use the
<code>ExtendSysPath</code> context manager. Example:`,Sr,Gl,Qr,Bl,cc="### Skipping tests",Fr,Xl,wc=`This is useful when a bug is found and a new test is written, yet the bug is not fixed yet. In order to be able to
commit it to the main repository we need make sure it’s skipped during <code>make test</code>.`,Er,Vl,hc="Methods:",Pr,Rl,yc=`<li><p>A <strong>skip</strong> means that you expect your test to pass only if some conditions are met, otherwise pytest should skip
running the test altogether. Common examples are skipping windows-only tests on non-windows platforms, or skipping
tests that depend on an external resource which is not available at the moment (for example a database).</p></li> <li><p>A <strong>xfail</strong> means that you expect a test to fail for some reason. A common example is a test for a feature not yet
implemented, or a bug not yet fixed. When a test passes despite being expected to fail (marked with
pytest.mark.xfail), it’s an xpass and will be reported in the test summary.</p></li>`,Ar,Nl,Mc=`One of the important differences between the two is that <code>skip</code> doesn’t run the test, and <code>xfail</code> does. So if the
code that’s buggy causes some bad state that will affect other tests, do not use <code>xfail</code>.`,Yr,zl,Tc="#### Implementation",qr,Wl,$c="<li>Here is how to skip whole test unconditionally:</li>",Kr,Ll,Dr,Sl,Jc="or via pytest:",Or,Ql,ed,Fl,bc="or the <code>xfail</code> way:",td,El,sd,Pl,Cc="Here’s how to skip a test based on internal checks within the test:",ld,Al,nd,Yl,jc="or the whole module:",id,ql,ad,Kl,vc="or the <code>xfail</code> way:",pd,Dl,od,Ol,gc="<li>Here is how to skip all tests in a module if some import is missing:</li>",rd,en,dd,tn,Uc="<li>Skip a test based on a condition:</li>",fd,sn,md,ln,xc="or:",ud,nn,cd,an,_c="or skip the whole module:",wd,pn,hd,on,Ic='More details, example and ways are <a href="https://docs.pytest.org/en/latest/skipping.html" rel="nofollow">here</a>.',yd,rn,kc="### Slow tests",Md,dn,Zc=`The library of tests is ever-growing, and some of the tests take minutes to run, therefore we can’t afford waiting for
an hour for the test suite to complete on CI. Therefore, with some exceptions for essential tests, slow tests should be
marked as in the example below:`,Td,fn,$d,mn,Hc="Once a test is marked as <code>@slow</code>, to run such tests set <code>RUN_SLOW=1</code> env var, e.g.:",Jd,un,bd,cn,Gc=`Some decorators like <code>@parameterized</code> rewrite test names, therefore <code>@slow</code> and the rest of the skip decorators
<code>@require_*</code> have to be listed last for them to work correctly. Here is an example of the correct usage:`,Cd,wn,jd,hn,Bc=`As explained at the beginning of this document, slow tests get to run on a scheduled basis, rather than in PRs CI
checks. So it’s possible that some problems will be missed during a PR submission and get merged. Such problems will
get caught during the next scheduled CI job. But it also means that it’s important to run the slow tests on your
machine before submitting the PR.`,vd,yn,Xc="Here is a rough decision making mechanism for choosing which tests should be marked as slow:",gd,Mn,Vc=`If the test is focused on one of the library’s internal components (e.g., modeling files, tokenization files,
pipelines), then we should run that test in the non-slow test suite. If it’s focused on an other aspect of the library,
such as the documentation or the examples, then we should run these tests in the slow test suite. And then, to refine
this approach we should have exceptions:`,Ud,Tn,Rc=`<li>All tests that need to download a heavy set of weights or a dataset that is larger than ~50MB (e.g., model or
tokenizer integration tests, pipeline integration tests) should be set to slow. If you’re adding a new model, you
should create and upload to the hub a tiny version of it (with random weights) for integration tests. This is
discussed in the following paragraphs.</li> <li>All tests that need to do a training not specifically optimized to be fast should be set to slow.</li> <li>We can introduce exceptions if some of these should-be-non-slow tests are excruciatingly slow, and set them to
<code>@slow</code>. Auto-modeling tests, which save and load large files to disk, are a good example of tests that are marked
as <code>@slow</code>.</li> <li>If a test completes under 1 second on CI (including downloads if any) then it should be a normal test regardless.</li>`,xd,$n,Nc=`Collectively, all the non-slow tests need to cover entirely the different internals, while remaining fast. For example,
a significant coverage can be achieved by testing with specially created tiny models with random weights. Such models
have the very minimal number of layers (e.g., 2), vocab size (e.g., 1000), etc. Then the <code>@slow</code> tests can use large
slow models to do qualitative testing. To see the use of these simply look for <em>tiny</em> models with:`,_d,Jn,Id,bn,zc=`Here is a an example of a <a href="https://github.com/huggingface/transformers/tree/main/scripts/fsmt/fsmt-make-tiny-model.py" rel="nofollow">script</a> that created the tiny model
<a href="https://huggingface.co/stas/tiny-wmt19-en-de" rel="nofollow">stas/tiny-wmt19-en-de</a>. You can easily adjust it to your specific
model’s architecture.`,kd,Cn,Wc=`It’s easy to measure the run-time incorrectly if for example there is an overheard of downloading a huge model, but if
you test it locally the downloaded files would be cached and thus the download time not measured. Hence check the
execution speed report in CI logs instead (the output of <code>pytest --durations=0 tests</code>).`,Zd,jn,Lc=`That report is also useful to find slow outliers that aren’t marked as such, or which need to be re-written to be fast.
If you notice that the test suite starts getting slow on CI, the top listing of this report will show the slowest
tests.`,Hd,vn,Sc="### Testing the stdout/stderr output",Gd,gn,Qc=`In order to test functions that write to <code>stdout</code> and/or <code>stderr</code>, the test can access those streams using the
<code>pytest</code>’s <a href="https://docs.pytest.org/en/latest/capture.html" rel="nofollow">capsys system</a>. Here is how this is accomplished:`,Bd,Un,Xd,xn,Fc=`And, of course, most of the time, <code>stderr</code> will come as a part of an exception, so try/except has to be used in such
a case:`,Vd,_n,Rd,In,Ec="Another approach to capturing stdout is via <code>contextlib.redirect_stdout</code>:",Nd,kn,zd,Zn,Pc=`An important potential issue with capturing stdout is that it may contain <code>\\r</code> characters that in normal <code>print</code>
reset everything that has been printed so far. There is no problem with <code>pytest</code>, but with <code>pytest -s</code> these
characters get included in the buffer, so to be able to have the test run with and without <code>-s</code>, you have to make an
extra cleanup to the captured output, using <code>re.sub(r&#39;~.*\\r&#39;, &#39;&#39;, buf, 0, re.M)</code>.`,Wd,Hn,Ac=`But, then we have a helper context manager wrapper to automatically take care of it all, regardless of whether it has
some <code>\\r</code>’s in it or not, so it’s a simple:`,Ld,Gn,Sd,Bn,Yc="Here is a full test example:",Qd,Xn,Fd,Vn,qc="If you’d like to capture <code>stderr</code> use the <code>CaptureStderr</code> class instead:",Ed,Rn,Pd,Nn,Kc="If you need to capture both streams at once, use the parent <code>CaptureStd</code> class:",Ad,zn,Yd,Wn,Dc=`Also, to aid debugging test issues, by default these context managers automatically replay the captured streams on exit
from the context.`,qd,Ln,Oc="### Capturing logger stream",Kd,Sn,ew="If you need to validate the output of a logger, you can use <code>CaptureLogger</code>:",Dd,Qn,Od,Fn,tw="### Testing with environment variables",ef,En,sw=`If you want to test the impact of environment variables for a specific test you can use a helper decorator
<code>transformers.testing_utils.mockenv</code>`,tf,Pn,sf,An,lw=`At times an external program needs to be called, which requires setting <code>PYTHONPATH</code> in <code>os.environ</code> to include
multiple local paths. A helper class <code>transformers.test_utils.TestCasePlus</code> comes to help:`,lf,Yn,nf,qn,nw=`Depending on whether the test file was under the <code>tests</code> test suite or <code>examples</code> it’ll correctly set up
<code>env[PYTHONPATH]</code> to include one of these two directories, and also the <code>src</code> directory to ensure the testing is
done against the current repo, and finally with whatever <code>env[PYTHONPATH]</code> was already set to before the test was
called if anything.`,af,Kn,iw="This helper method creates a copy of the <code>os.environ</code> object, so the original remains intact.",pf,Dn,aw="### Getting reproducible results",of,On,pw=`In some situations you may want to remove randomness for your tests. To get identical reproducible results set, you
will need to fix the seed:`,rf,ei,df,ti,ow="### Debugging tests",ff,si,rw="To start a debugger at the point of the warning, do this:",mf,li,uf,ni,dw="## Working with github actions workflows",cf,ii,fw="To trigger a self-push workflow CI job, you must:",wf,ai,mw=`<li>Create a new branch on <code>transformers</code> origin (not a fork!).</li> <li>The branch name has to start with either <code>ci_</code> or <code>ci-</code> (<code>main</code> triggers it too, but we can’t do PRs on
<code>main</code>). It also gets triggered only for specific paths - you can find the up-to-date definition in case it
changed since this document has been written <a href="https://github.com/huggingface/transformers/blob/main/.github/workflows/self-push.yml" rel="nofollow">here</a> under <em>push:</em></li> <li>Create a PR from this branch.</li> <li>Then you can see the job appear <a href="https://github.com/huggingface/transformers/actions/workflows/self-push.yml" rel="nofollow">here</a>. It may not run right away if there
is a backlog.</li>`,hf,pi,uw="## Testing Experimental CI Features",yf,oi,cw=`Testing CI features can be potentially problematic as it can interfere with the normal CI functioning. Therefore if a
new CI feature is to be added, it should be done as following.`,Mf,ri,ww=`<li>Create a new dedicated job that tests what needs to be tested</li> <li>The new job must always succeed so that it gives us a green ✓ (details below).</li> <li>Let it run for some days to see that a variety of different PR types get to run on it (user fork branches,
non-forked branches, branches originating from github.com UI direct file edit, various forced pushes, etc. - there
are so many) while monitoring the experimental job’s logs (not the overall job green as it’s purposefully always
green)</li> <li>When it’s clear that everything is solid, then merge the new changes into existing jobs.</li>`,Tf,di,hw="That way experiments on CI functionality itself won’t interfere with the normal workflow.",$f,fi,yw="Now how can we make the job always succeed while the new CI feature is being developed?",Jf,mi,Mw=`Some CIs, like TravisCI support ignore-step-failure and will report the overall job as successful, but CircleCI and
Github Actions as of this writing don’t support that.`,bf,ui,Tw="So the following workaround can be used:",Cf,ci,$w="<li><code>set +euo pipefail</code> at the beginning of the run command to suppress most potential failures in the bash script.</li> <li>the last command must be a success: <code>echo &quot;done&quot;</code> or just <code>true</code> will do</li>",jf,wi,Jw="Here is an example:",vf,hi,gf,yi,bw="For simple commands you could also do:",Uf,Mi,xf,Ti,Cw=`Of course, once satisfied with the results, integrate the experimental step or job with the rest of the normal jobs,
while removing <code>set +euo pipefail</code> or any other things you may have added to ensure that the experimental job doesn’t
interfere with the normal CI functioning.`,_f,$i,jw=`This whole process would have been much easier if we only could set something like <code>allow-failure</code> for the
experimental step, and let it fail without impacting the overall status of PRs. But as mentioned earlier CircleCI and
Github Actions don’t support it at the moment.`,If,Ji,vw="You can vote for this feature and see where it is at these CI-specific threads:",kf,bi,gw='<li><a href="https://github.com/actions/toolkit/issues/399" rel="nofollow">Github Actions:</a></li> <li><a href="https://ideas.circleci.com/ideas/CCI-I-344" rel="nofollow">CircleCI:</a></li>',Zf,Ci,Uw="## DeepSpeed integration",Hf,ji,xw="For a PR that involves the DeepSpeed integration, keep in mind our CircleCI PR CI setup doesn’t have GPUs. Tests requiring GPUs are run on a different CI nightly. This means if you get a passing CI report in your PR, it doesn’t mean the DeepSpeed tests pass.",Gf,vi,_w="To run DeepSpeed tests:",Bf,gi,Xf,Ui,Iw="Any changes to the modeling or PyTorch examples code requires running the model zoo tests as well.",Vf,xi,Rf,_i,Nf,Ii,zf;return g=new M({props:{title:"Testing",local:"testing",headingTag:"h1"}}),I=new M({props:{title:"How transformers are tested",local:"how-transformers-are-tested",headingTag:"h2"}}),Z=new w({props:{code:"UlVOX1NMT1clM0QxJTIwcHl0ZXN0JTIwdGVzdHMlMkYlMEFSVU5fU0xPVyUzRDElMjBweXRlc3QlMjBleGFtcGxlcyUyRg==",highlighted:`RUN_SLOW=1 pytest tests/
RUN_SLOW=1 pytest examples/`,wrap:!1}}),G=new M({props:{title:"Running tests",local:"running-tests",headingTag:"h2"}}),B=new M({props:{title:"Choosing which tests to run",local:"choosing-which-tests-to-run",headingTag:"h3"}}),N=new w({props:{code:"cHl0ZXN0",highlighted:"pytest",wrap:!1}}),W=new w({props:{code:"bWFrZSUyMHRlc3Q=",highlighted:'make <span class="hljs-built_in">test</span>',wrap:!1}}),S=new w({props:{code:"cHl0aG9uJTIwLW0lMjBweXRlc3QlMjAtbiUyMGF1dG8lMjAtLWRpc3QlM0Rsb2FkZmlsZSUyMC1zJTIwLXYlMjAuJTJGdGVzdHMlMkY=",highlighted:"python -m pytest -n auto --dist=loadfile -s -v ./tests/",wrap:!1}}),E=new M({props:{title:"Getting the list of all tests",local:"getting-the-list-of-all-tests",headingTag:"h3"}}),A=new w({props:{code:"cHl0ZXN0JTIwLS1jb2xsZWN0LW9ubHklMjAtcQ==",highlighted:"pytest --collect-only -q",wrap:!1}}),q=new w({props:{code:"cHl0ZXN0JTIwdGVzdHMlMkZ0ZXN0X29wdGltaXphdGlvbi5weSUyMC0tY29sbGVjdC1vbmx5JTIwLXE=",highlighted:"pytest tests/test_optimization.py --collect-only -q",wrap:!1}}),K=new M({props:{title:"Run a specific test module",local:"run-a-specific-test-module",headingTag:"h3"}}),O=new w({props:{code:"cHl0ZXN0JTIwdGVzdHMlMkZ1dGlscyUyRnRlc3RfbG9nZ2luZy5weQ==",highlighted:"pytest tests/utils/test_logging.py",wrap:!1}}),ee=new M({props:{title:"Run specific tests",local:"run-specific-tests",headingTag:"h3"}}),se=new w({props:{code:"cHl0ZXN0JTIwdGVzdHMlMkZ0ZXN0X29wdGltaXphdGlvbi5weSUzQSUzQU9wdGltaXphdGlvblRlc3QlM0ElM0F0ZXN0X2FkYW1fdw==",highlighted:"pytest tests/test_optimization.py::OptimizationTest::test_adam_w",wrap:!1}}),ae=new w({props:{code:"cHl0ZXN0JTIwdGVzdHMlMkZ0ZXN0X29wdGltaXphdGlvbi5weSUzQSUzQU9wdGltaXphdGlvblRlc3Q=",highlighted:"pytest tests/test_optimization.py::OptimizationTest",wrap:!1}}),re=new w({props:{code:"cHl0ZXN0JTIwdGVzdHMlMkZ0ZXN0X29wdGltaXphdGlvbi5weSUzQSUzQU9wdGltaXphdGlvblRlc3QlMjAtLWNvbGxlY3Qtb25seSUyMC1x",highlighted:"pytest tests/test_optimization.py::OptimizationTest --collect-only -q",wrap:!1}}),me=new w({props:{code:"cHl0ZXN0JTIwLWslMjBhZGFtJTIwdGVzdHMlMkZ0ZXN0X29wdGltaXphdGlvbi5weQ==",highlighted:"pytest -k adam tests/test_optimization.py",wrap:!1}}),we=new w({props:{code:"cHl0ZXN0JTIwLWslMjAlMjJub3QlMjBhZGFtJTIyJTIwdGVzdHMlMkZ0ZXN0X29wdGltaXphdGlvbi5weQ==",highlighted:'pytest -k <span class="hljs-string">&quot;not adam&quot;</span> tests/test_optimization.py',wrap:!1}}),ye=new w({props:{code:"cHl0ZXN0JTIwLWslMjAlMjJhZGElMjBhbmQlMjBub3QlMjBhZGFtJTIyJTIwdGVzdHMlMkZ0ZXN0X29wdGltaXphdGlvbi5weQ==",highlighted:'pytest -k <span class="hljs-string">&quot;ada and not adam&quot;</span> tests/test_optimization.py',wrap:!1}}),Te=new w({props:{code:"cHl0ZXN0JTIwLWslMjAlMjJ0ZXN0X2FkYWZhY3RvciUyMG9yJTIwdGVzdF9hZGFtX3clMjIlMjB0ZXN0cyUyRnRlc3Rfb3B0aW1pemF0aW9uLnB5",highlighted:'pytest -k <span class="hljs-string">&quot;test_adafactor or test_adam_w&quot;</span> tests/test_optimization.py',wrap:!1}}),be=new w({props:{code:"cHl0ZXN0JTIwLWslMjAlMjJ0ZXN0JTIwYW5kJTIwYWRhJTIyJTIwdGVzdHMlMkZ0ZXN0X29wdGltaXphdGlvbi5weQ==",highlighted:'pytest -k <span class="hljs-string">&quot;test and ada&quot;</span> tests/test_optimization.py',wrap:!1}}),Ce=new M({props:{title:"Run accelerate tests",local:"run-accelerate-tests",headingTag:"h3"}}),ve=new w({props:{code:"UlVOX1NMT1clM0QxJTIwcHl0ZXN0JTIwLW0lMjBhY2NlbGVyYXRlX3Rlc3RzJTIwdGVzdHMlMkZtb2RlbHMlMkZvcHQlMkZ0ZXN0X21vZGVsaW5nX29wdC5weSUyMA==",highlighted:"RUN_SLOW=1 pytest -m accelerate_tests tests/models/opt/test_modeling_opt.py ",wrap:!1}}),ge=new M({props:{title:"Run documentation tests",local:"run-documentation-tests",headingTag:"h3"}}),xe=new w({props:{code:"ciUyMiUyMiUyMiUwQVJldHVybnMlM0ElMEElMEFFeGFtcGxlJTNBJTBBJTIwJTIwJTIwJTIwJTYwJTYwJTYwcHl0aG9uJTBBJTIwJTIwJTIwJTIwJTNFJTNFJTNFJTIwaW1wb3J0JTIwdG9yY2glMEElMjAlMjAlMjAlMjAlM0UlM0UlM0UlMjBmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwV2hpc3Blck1vZGVsJTJDJTIwV2hpc3BlckZlYXR1cmVFeHRyYWN0b3IlMEElMjAlMjAlMjAlMjAlM0UlM0UlM0UlMjBmcm9tJTIwZGF0YXNldHMlMjBpbXBvcnQlMjBsb2FkX2RhdGFzZXQlMEElMEElMjAlMjAlMjAlMjAlM0UlM0UlM0UlMjBtb2RlbCUyMCUzRCUyMFdoaXNwZXJNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIyb3BlbmFpJTJGd2hpc3Blci1iYXNlJTIyKSUwQSUyMCUyMCUyMCUyMCUzRSUzRSUzRSUyMGZlYXR1cmVfZXh0cmFjdG9yJTIwJTNEJTIwV2hpc3BlckZlYXR1cmVFeHRyYWN0b3IuZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5haSUyRndoaXNwZXItYmFzZSUyMiklMEElMjAlMjAlMjAlMjAlM0UlM0UlM0UlMjBkcyUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJoZi1pbnRlcm5hbC10ZXN0aW5nJTJGbGlicmlzcGVlY2hfYXNyX2R1bW15JTIyJTJDJTIwJTIyY2xlYW4lMjIlMkMlMjBzcGxpdCUzRCUyMnZhbGlkYXRpb24lMjIpJTBBJTIwJTIwJTIwJTIwJTNFJTNFJTNFJTIwaW5wdXRzJTIwJTNEJTIwZmVhdHVyZV9leHRyYWN0b3IoZHMlNUIwJTVEJTVCJTIyYXVkaW8lMjIlNUQlNUIlMjJhcnJheSUyMiU1RCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTIwJTIwJTIwJTIwJTNFJTNFJTNFJTIwaW5wdXRfZmVhdHVyZXMlMjAlM0QlMjBpbnB1dHMuaW5wdXRfZmVhdHVyZXMlMEElMjAlMjAlMjAlMjAlM0UlM0UlM0UlMjBkZWNvZGVyX2lucHV0X2lkcyUyMCUzRCUyMHRvcmNoLnRlbnNvciglNUIlNUIxJTJDJTIwMSU1RCU1RCklMjAqJTIwbW9kZWwuY29uZmlnLmRlY29kZXJfc3RhcnRfdG9rZW5faWQlMEElMjAlMjAlMjAlMjAlM0UlM0UlM0UlMjBsYXN0X2hpZGRlbl9zdGF0ZSUyMCUzRCUyMG1vZGVsKGlucHV0X2ZlYXR1cmVzJTJDJTIwZGVjb2Rlcl9pbnB1dF9pZHMlM0RkZWNvZGVyX2lucHV0X2lkcykubGFzdF9oaWRkZW5fc3RhdGUlMEElMjAlMjAlMjAlMjAlM0UlM0UlM0UlMjBsaXN0KGxhc3RfaGlkZGVuX3N0YXRlLnNoYXBlKSUwQSUyMCUyMCUyMCUyMCU1QjElMkMlMjAyJTJDJTIwNTEyJTVEJTBBJTIwJTIwJTIwJTIwJTYwJTYwJTYwJTIyJTIyJTIyJTBB",highlighted:`<span class="hljs-string">r&quot;&quot;&quot;
Returns:

Example:
    \`\`\`python
    &gt;&gt;&gt; import torch
    &gt;&gt;&gt; from transformers import WhisperModel, WhisperFeatureExtractor
    &gt;&gt;&gt; from datasets import load_dataset

    &gt;&gt;&gt; model = WhisperModel.from_pretrained(&quot;openai/whisper-base&quot;)
    &gt;&gt;&gt; feature_extractor = WhisperFeatureExtractor.from_pretrained(&quot;openai/whisper-base&quot;)
    &gt;&gt;&gt; ds = load_dataset(&quot;hf-internal-testing/librispeech_asr_dummy&quot;, &quot;clean&quot;, split=&quot;validation&quot;)
    &gt;&gt;&gt; inputs = feature_extractor(ds[0][&quot;audio&quot;][&quot;array&quot;], return_tensors=&quot;pt&quot;)
    &gt;&gt;&gt; input_features = inputs.input_features
    &gt;&gt;&gt; decoder_input_ids = torch.tensor([[1, 1]]) * model.config.decoder_start_token_id
    &gt;&gt;&gt; last_hidden_state = model(input_features, decoder_input_ids=decoder_input_ids).last_hidden_state
    &gt;&gt;&gt; list(last_hidden_state.shape)
    [1, 2, 512]
    \`\`\`&quot;&quot;&quot;</span>
`,wrap:!1}}),Ie=new w({props:{code:"cHl0ZXN0JTIwLS1kb2N0ZXN0LW1vZHVsZXMlMjAlM0NwYXRoX3RvX2ZpbGVfb3JfZGlyJTNF",highlighted:"pytest --doctest-modules &lt;path_to_file_or_dir&gt;",wrap:!1}}),Ze=new M({props:{title:"Run only modified tests",local:"run-only-modified-tests",headingTag:"h3"}}),Ge=new w({props:{code:"cGlwJTIwaW5zdGFsbCUyMHB5dGVzdC1waWNrZWQ=",highlighted:"pip install pytest-picked",wrap:!1}}),Be=new w({props:{code:"cHl0ZXN0JTIwLS1waWNrZWQ=",highlighted:"pytest --picked",wrap:!1}}),Ve=new M({props:{title:"Automatically rerun failed tests on source modification",local:"automatically-rerun-failed-tests-on-source-modification",headingTag:"h3"}}),Ne=new w({props:{code:"cGlwJTIwaW5zdGFsbCUyMHB5dGVzdC14ZGlzdA==",highlighted:"pip install pytest-xdist",wrap:!1}}),Le=new w({props:{code:"JTVCdG9vbCUzQXB5dGVzdCU1RCUwQWxvb3BvbmZhaWxyb290cyUyMCUzRCUyMHRyYW5zZm9ybWVycyUyMHRlc3Rz",highlighted:`<span class="hljs-section">[tool:pytest]</span>
<span class="hljs-attr">looponfailroots</span> = transformers tests`,wrap:!1}}),Qe=new w({props:{code:"JTVCcHl0ZXN0JTVEJTBBbG9vcG9uZmFpbHJvb3RzJTIwJTNEJTIwdHJhbnNmb3JtZXJzJTIwdGVzdHM=",highlighted:`<span class="hljs-section">[pytest]</span>
<span class="hljs-attr">looponfailroots</span> = transformers tests`,wrap:!1}}),Pe=new M({props:{title:"Skip a test module",local:"skip-a-test-module",headingTag:"h3"}}),Ye=new w({props:{code:"cHl0ZXN0JTIwKmxzJTIwLTElMjB0ZXN0cyUyRipweSUyMCU3QyUyMGdyZXAlMjAtdiUyMHRlc3RfbW9kZWxpbmcq",highlighted:'pytest *<span class="hljs-built_in">ls</span> -1 tests/*py | grep -v test_modeling*',wrap:!1}}),qe=new M({props:{title:"Clearing state",local:"clearing-state",headingTag:"h3"}}),De=new w({props:{code:"cHl0ZXN0JTIwLS1jYWNoZS1jbGVhciUyMHRlc3Rz",highlighted:"pytest --cache-clear tests",wrap:!1}}),Oe=new M({props:{title:"Running tests in parallel",local:"running-tests-in-parallel",headingTag:"h3"}}),lt=new M({props:{title:"Test order and repetition",local:"test-order-and-repetition",headingTag:"h3"}}),it=new M({props:{title:"Repeat tests",local:"repeat-tests",headingTag:"h4"}}),pt=new w({props:{code:"cGlwJTIwaW5zdGFsbCUyMHB5dGVzdC1mbGFrZWZpbmRlcg==",highlighted:"pip install pytest-flakefinder",wrap:!1}}),rt=new w({props:{code:"cHl0ZXN0JTIwLS1mbGFrZS1maW5kZXIlMjAtLWZsYWtlLXJ1bnMlM0Q1JTIwdGVzdHMlMkZ0ZXN0X2ZhaWxpbmdfdGVzdC5weQ==",highlighted:"pytest --flake-finder --flake-runs=5 tests/test_failing_test.py",wrap:!1}}),b=new Wf({props:{$$slots:{default:[Qw]},$$scope:{ctx:J}}}),C=new Wf({props:{$$slots:{default:[Fw]},$$scope:{ctx:J}}}),dt=new M({props:{title:"Run tests in a random order",local:"run-tests-in-a-random-order",headingTag:"h4"}}),ft=new w({props:{code:"cGlwJTIwaW5zdGFsbCUyMHB5dGVzdC1yYW5kb20tb3JkZXI=",highlighted:"pip install pytest-random-order",wrap:!1}}),ct=new w({props:{code:"cHl0ZXN0JTIwdGVzdHMlMEElNUIuLi4lNUQlMEFVc2luZyUyMC0tcmFuZG9tLW9yZGVyLWJ1Y2tldCUzRG1vZHVsZSUwQVVzaW5nJTIwLS1yYW5kb20tb3JkZXItc2VlZCUzRDU3MzY2Mw==",highlighted:`pytest tests
[...]
Using --random-order-bucket=module
Using --random-order-seed=573663`,wrap:!1}}),ht=new w({props:{code:"cHl0ZXN0JTIwLS1yYW5kb20tb3JkZXItc2VlZCUzRDU3MzY2MyUwQSU1Qi4uLiU1RCUwQVVzaW5nJTIwLS1yYW5kb20tb3JkZXItYnVja2V0JTNEbW9kdWxlJTBBVXNpbmclMjAtLXJhbmRvbS1vcmRlci1zZWVkJTNENTczNjYz",highlighted:`pytest --random-order-seed=573663
[...]
Using --random-order-bucket=module
Using --random-order-seed=573663`,wrap:!1}}),Mt=new w({props:{code:"cHl0ZXN0JTIwLS1yYW5kb20tb3JkZXItYnVja2V0JTNEbm9uZSUyMHRlc3RzJTJGdGVzdF9hLnB5JTIwdGVzdHMlMkZ0ZXN0X2MucHklMjB0ZXN0cyUyRnRlc3RfYi5weQ==",highlighted:"pytest --random-order-bucket=none tests/test_a.py tests/test_c.py tests/test_b.py",wrap:!1}}),$t=new w({props:{code:"cHl0ZXN0JTIwLS1yYW5kb20tb3JkZXItYnVja2V0JTNEbm9uZQ==",highlighted:"pytest --random-order-bucket=none",wrap:!1}}),Ct=new M({props:{title:"Look and feel variations",local:"look-and-feel-variations",headingTag:"h3"}}),jt=new M({props:{title:"pytest-sugar",local:"pytest-sugar",headingTag:"h4"}}),gt=new w({props:{code:"cGlwJTIwaW5zdGFsbCUyMHB5dGVzdC1zdWdhcg==",highlighted:"pip install pytest-sugar",wrap:!1}}),xt=new w({props:{code:"cHl0ZXN0JTIwLXAlMjBubyUzQXN1Z2Fy",highlighted:"pytest -p no:sugar",wrap:!1}}),It=new M({props:{title:"Report each sub-test name and its progress",local:"report-each-sub-test-name-and-its-progress",headingTag:"h4"}}),Zt=new w({props:{code:"cHl0ZXN0JTIwLS1wc3BlYyUyMHRlc3RzJTJGdGVzdF9vcHRpbWl6YXRpb24ucHk=",highlighted:"pytest --pspec tests/test_optimization.py",wrap:!1}}),Ht=new M({props:{title:"Instantly shows failed tests",local:"instantly-shows-failed-tests",headingTag:"h4"}}),Bt=new w({props:{code:"cGlwJTIwaW5zdGFsbCUyMHB5dGVzdC1pbnN0YWZhaWw=",highlighted:"pip install pytest-instafail",wrap:!1}}),Xt=new w({props:{code:"cHl0ZXN0JTIwLS1pbnN0YWZhaWw=",highlighted:"pytest --instafail",wrap:!1}}),Vt=new M({props:{title:"To GPU or not to GPU",local:"to-gpu-or-not-to-gpu",headingTag:"h3"}}),Nt=new w({props:{code:"Q1VEQV9WSVNJQkxFX0RFVklDRVMlM0QlMjIlMjIlMjBweXRlc3QlMjB0ZXN0cyUyRnV0aWxzJTJGdGVzdF9sb2dnaW5nLnB5",highlighted:'CUDA_VISIBLE_DEVICES=<span class="hljs-string">&quot;&quot;</span> pytest tests/utils/test_logging.py',wrap:!1}}),Wt=new w({props:{code:"Q1VEQV9WSVNJQkxFX0RFVklDRVMlM0QlMjIxJTIyJTIwcHl0ZXN0JTIwdGVzdHMlMkZ1dGlscyUyRnRlc3RfbG9nZ2luZy5weQ==",highlighted:'CUDA_VISIBLE_DEVICES=<span class="hljs-string">&quot;1&quot;</span> pytest tests/utils/test_logging.py',wrap:!1}}),At=new w({props:{code:"JTQwcmVxdWlyZV90b3JjaF9tdWx0aV9ncHUlMEFkZWYlMjB0ZXN0X2V4YW1wbGVfd2l0aF9tdWx0aV9ncHUoKSUzQQ==",highlighted:`<span class="hljs-meta">@require_torch_multi_gpu</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">test_example_with_multi_gpu</span>():`,wrap:!1}}),qt=new w({props:{code:"JTQwcmVxdWlyZV90ZiUwQWRlZiUyMHRlc3RfdGZfdGhpbmdfd2l0aF90ZW5zb3JmbG93KCklM0E=",highlighted:`<span class="hljs-meta">@require_tf</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">test_tf_thing_with_tensorflow</span>():`,wrap:!1}}),Dt=new w({props:{code:"JTQwcmVxdWlyZV90b3JjaF9ncHUlMEElNDBzbG93JTBBZGVmJTIwdGVzdF9leGFtcGxlX3Nsb3dfb25fZ3B1KCklM0E=",highlighted:`<span class="hljs-meta">@require_torch_gpu</span>
<span class="hljs-meta">@slow</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">test_example_slow_on_gpu</span>():`,wrap:!1}}),es=new w({props:{code:"JTQwcGFyYW1ldGVyaXplZC5leHBhbmQoLi4uKSUwQSU0MHJlcXVpcmVfdG9yY2hfbXVsdGlfZ3B1JTBBZGVmJTIwdGVzdF9pbnRlZ3JhdGlvbl9mb28oKSUzQQ==",highlighted:`<span class="hljs-meta">@parameterized.expand(<span class="hljs-params">...</span>)</span>
<span class="hljs-meta">@require_torch_multi_gpu</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">test_integration_foo</span>():`,wrap:!1}}),ns=new w({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycy50ZXN0aW5nX3V0aWxzJTIwaW1wb3J0JTIwZ2V0X2dwdV9jb3VudCUwQSUwQW5fZ3B1JTIwJTNEJTIwZ2V0X2dwdV9jb3VudCgpJTIwJTIwJTIzJTIwd29ya3MlMjB3aXRoJTIwdG9yY2glMjBhbmQlMjB0Zg==",highlighted:`<span class="hljs-keyword">from</span> transformers.testing_utils <span class="hljs-keyword">import</span> get_gpu_count

n_gpu = get_gpu_count()  <span class="hljs-comment"># works with torch and tf</span>`,wrap:!1}}),is=new M({props:{title:"Testing with a specific PyTorch backend or device",local:"testing-with-a-specific-pytorch-backend-or-device",headingTag:"h3"}}),ps=new w({props:{code:"VFJBTlNGT1JNRVJTX1RFU1RfREVWSUNFJTNEJTIyY3B1JTIyJTIwcHl0ZXN0JTIwdGVzdHMlMkZ1dGlscyUyRnRlc3RfbG9nZ2luZy5weQ==",highlighted:'TRANSFORMERS_TEST_DEVICE=<span class="hljs-string">&quot;cpu&quot;</span> pytest tests/utils/test_logging.py',wrap:!1}}),ds=new w({props:{code:"VFJBTlNGT1JNRVJTX1RFU1RfQkFDS0VORCUzRCUyMnRvcmNoX25wdSUyMiUyMHB5dGVzdCUyMHRlc3RzJTJGdXRpbHMlMkZ0ZXN0X2xvZ2dpbmcucHk=",highlighted:'TRANSFORMERS_TEST_BACKEND=<span class="hljs-string">&quot;torch_npu&quot;</span> pytest tests/utils/test_logging.py',wrap:!1}}),ms=new w({props:{code:"aW1wb3J0JTIwdG9yY2glMEFpbXBvcnQlMjB0b3JjaF9ucHUlMjAlMjMlMjBmb3IlMjB4cHUlMkMlMjByZXBsYWNlJTIwaXQlMjB3aXRoJTIwJTYwaW1wb3J0JTIwaW50ZWxfZXh0ZW5zaW9uX2Zvcl9weXRvcmNoJTYwJTBBJTIzJTIwISElMjBGdXJ0aGVyJTIwYWRkaXRpb25hbCUyMGltcG9ydHMlMjBjYW4lMjBiZSUyMGFkZGVkJTIwaGVyZSUyMCEhJTBBJTBBJTIzJTIwU3BlY2lmeSUyMHRoZSUyMGRldmljZSUyMG5hbWUlMjAoZWcuJTIwJ2N1ZGEnJTJDJTIwJ2NwdSclMkMlMjAnbnB1JyUyQyUyMCd4cHUnJTJDJTIwJ21wcycpJTBBREVWSUNFX05BTUUlMjAlM0QlMjAnbnB1JyUwQSUwQSUyMyUyMFNwZWNpZnklMjBkZXZpY2Utc3BlY2lmaWMlMjBiYWNrZW5kcyUyMHRvJTIwZGlzcGF0Y2glMjB0by4lMEElMjMlMjBJZiUyMG5vdCUyMHNwZWNpZmllZCUyQyUyMHdpbGwlMjBmYWxsYmFjayUyMHRvJTIwJ2RlZmF1bHQnJTIwaW4lMjAndGVzdGluZ191dGlscy5weSU2MCUwQU1BTlVBTF9TRUVEX0ZOJTIwJTNEJTIwdG9yY2gubnB1Lm1hbnVhbF9zZWVkJTBBRU1QVFlfQ0FDSEVfRk4lMjAlM0QlMjB0b3JjaC5ucHUuZW1wdHlfY2FjaGUlMEFERVZJQ0VfQ09VTlRfRk4lMjAlM0QlMjB0b3JjaC5ucHUuZGV2aWNlX2NvdW50",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> torch_npu <span class="hljs-comment"># for xpu, replace it with \`import intel_extension_for_pytorch\`</span>
<span class="hljs-comment"># !! Further additional imports can be added here !!</span>

<span class="hljs-comment"># Specify the device name (eg. &#x27;cuda&#x27;, &#x27;cpu&#x27;, &#x27;npu&#x27;, &#x27;xpu&#x27;, &#x27;mps&#x27;)</span>
DEVICE_NAME = <span class="hljs-string">&#x27;npu&#x27;</span>

<span class="hljs-comment"># Specify device-specific backends to dispatch to.</span>
<span class="hljs-comment"># If not specified, will fallback to &#x27;default&#x27; in &#x27;testing_utils.py\`</span>
MANUAL_SEED_FN = torch.npu.manual_seed
EMPTY_CACHE_FN = torch.npu.empty_cache
DEVICE_COUNT_FN = torch.npu.device_count`,wrap:!1}}),Js=new w({props:{code:"Q1VEQV9WSVNJQkxFX0RFVklDRVMlM0QwJTJDMSUyMFJVTl9TTE9XJTNEMSUyMHB5dGVzdCUyMC1zdiUyMHRlc3RzJTJGdGVzdF90cmFpbmVyX2Rpc3RyaWJ1dGVkLnB5",highlighted:"CUDA_VISIBLE_DEVICES=0,1 RUN_SLOW=1 pytest -sv tests/test_trainer_distributed.py",wrap:!1}}),vs=new w({props:{code:"cHl0ZXN0JTIwLXMlMjB0ZXN0cyUyRnV0aWxzJTJGdGVzdF9sb2dnaW5nLnB5",highlighted:"pytest -s tests/utils/test_logging.py",wrap:!1}}),Us=new w({props:{code:"cHl0ZXN0JTIwdGVzdHMlMjAtLWp1bml0eG1sJTNEcmVzdWx0LnhtbA==",highlighted:"pytest tests --junitxml=result.xml",wrap:!1}}),Is=new w({props:{code:"cHl0ZXN0JTIwLS1jb2xvciUzRG5vJTIwdGVzdHMlMkZ1dGlscyUyRnRlc3RfbG9nZ2luZy5weQ==",highlighted:"pytest --color=no tests/utils/test_logging.py",wrap:!1}}),Hs=new w({props:{code:"cHl0ZXN0JTIwLS1wYXN0ZWJpbiUzRGZhaWxlZCUyMHRlc3RzJTJGdXRpbHMlMkZ0ZXN0X2xvZ2dpbmcucHk=",highlighted:"pytest --pastebin=failed tests/utils/test_logging.py",wrap:!1}}),Xs=new w({props:{code:"cHl0ZXN0JTIwLS1wYXN0ZWJpbiUzRGFsbCUyMHRlc3RzJTJGdXRpbHMlMkZ0ZXN0X2xvZ2dpbmcucHk=",highlighted:"pytest --pastebin=all tests/utils/test_logging.py",wrap:!1}}),Ls=new w({props:{code:"JTIzJTIwdGVzdF90aGlzMS5weSUwQWltcG9ydCUyMHVuaXR0ZXN0JTBBZnJvbSUyMHBhcmFtZXRlcml6ZWQlMjBpbXBvcnQlMjBwYXJhbWV0ZXJpemVkJTBBJTBBJTBBY2xhc3MlMjBUZXN0TWF0aFVuaXRUZXN0KHVuaXR0ZXN0LlRlc3RDYXNlKSUzQSUwQSUyMCUyMCUyMCUyMCU0MHBhcmFtZXRlcml6ZWQuZXhwYW5kKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCglMjJuZWdhdGl2ZSUyMiUyQyUyMC0xLjUlMkMlMjAtMi4wKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCglMjJpbnRlZ2VyJTIyJTJDJTIwMSUyQyUyMDEuMCklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAoJTIybGFyZ2UlMjBmcmFjdGlvbiUyMiUyQyUyMDEuNiUyQyUyMDEpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVEJTBBJTIwJTIwJTIwJTIwKSUwQSUyMCUyMCUyMCUyMGRlZiUyMHRlc3RfZmxvb3Ioc2VsZiUyQyUyMG5hbWUlMkMlMjBpbnB1dCUyQyUyMGV4cGVjdGVkKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGFzc2VydF9lcXVhbChtYXRoLmZsb29yKGlucHV0KSUyQyUyMGV4cGVjdGVkKQ==",highlighted:`<span class="hljs-comment"># test_this1.py</span>
<span class="hljs-keyword">import</span> unittest
<span class="hljs-keyword">from</span> parameterized <span class="hljs-keyword">import</span> parameterized


<span class="hljs-keyword">class</span> <span class="hljs-title class_">TestMathUnitTest</span>(unittest.TestCase):
<span class="hljs-meta">    @parameterized.expand(<span class="hljs-params">
        [
            (<span class="hljs-params"><span class="hljs-string">&quot;negative&quot;</span>, -<span class="hljs-number">1.5</span>, -<span class="hljs-number">2.0</span></span>),
            (<span class="hljs-params"><span class="hljs-string">&quot;integer&quot;</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1.0</span></span>),
            (<span class="hljs-params"><span class="hljs-string">&quot;large fraction&quot;</span>, <span class="hljs-number">1.6</span>, <span class="hljs-number">1</span></span>),
        ]
    </span>)</span>
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">test_floor</span>(<span class="hljs-params">self, name, <span class="hljs-built_in">input</span>, expected</span>):
        assert_equal(math.floor(<span class="hljs-built_in">input</span>), expected)`,wrap:!1}}),Fs=new w({props:{code:"cHl0ZXN0JTIwLWslMjAlMjJuZWdhdGl2ZSUyMGFuZCUyMGludGVnZXIlMjIlMjB0ZXN0cyUyRnRlc3RfbXl0ZXN0LnB5",highlighted:'pytest -k <span class="hljs-string">&quot;negative and integer&quot;</span> tests/test_mytest.py',wrap:!1}}),Ps=new w({props:{code:"cHl0ZXN0JTIwLWslMjAlMjJub3QlMjBuZWdhdGl2ZSUyMiUyMHRlc3RzJTJGdGVzdF9teXRlc3QucHk=",highlighted:'pytest -k <span class="hljs-string">&quot;not negative&quot;</span> tests/test_mytest.py',wrap:!1}}),Ys=new w({props:{code:"cHl0ZXN0JTIwdGVzdF90aGlzMS5weSUyMC0tY29sbGVjdC1vbmx5JTIwLXE=",highlighted:"pytest test_this1.py --collect-only -q",wrap:!1}}),Ks=new w({props:{code:"dGVzdF90aGlzMS5weSUzQSUzQVRlc3RNYXRoVW5pdFRlc3QlM0ElM0F0ZXN0X2Zsb29yXzBfbmVnYXRpdmUlMEF0ZXN0X3RoaXMxLnB5JTNBJTNBVGVzdE1hdGhVbml0VGVzdCUzQSUzQXRlc3RfZmxvb3JfMV9pbnRlZ2VyJTBBdGVzdF90aGlzMS5weSUzQSUzQVRlc3RNYXRoVW5pdFRlc3QlM0ElM0F0ZXN0X2Zsb29yXzJfbGFyZ2VfZnJhY3Rpb24=",highlighted:`test_this1.py::TestMathUnitTest::test_floor_0_negative
test_this1.py::TestMathUnitTest::test_floor_1_integer
test_this1.py::TestMathUnitTest::test_floor_2_large_fraction`,wrap:!1}}),Os=new w({props:{code:"cHl0ZXN0JTIwdGVzdF90aGlzMS5weSUzQSUzQVRlc3RNYXRoVW5pdFRlc3QlM0ElM0F0ZXN0X2Zsb29yXzBfbmVnYXRpdmUlMjAlMjB0ZXN0X3RoaXMxLnB5JTNBJTNBVGVzdE1hdGhVbml0VGVzdCUzQSUzQXRlc3RfZmxvb3JfMV9pbnRlZ2Vy",highlighted:"pytest test_this1.py::TestMathUnitTest::test_floor_0_negative  test_this1.py::TestMathUnitTest::test_floor_1_integer",wrap:!1}}),ll=new w({props:{code:"JTIzJTIwdGVzdF90aGlzMi5weSUwQWltcG9ydCUyMHB5dGVzdCUwQSUwQSUwQSU0MHB5dGVzdC5tYXJrLnBhcmFtZXRyaXplKCUwQSUyMCUyMCUyMCUyMCUyMm5hbWUlMkMlMjBpbnB1dCUyQyUyMGV4cGVjdGVkJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKCUyMm5lZ2F0aXZlJTIyJTJDJTIwLTEuNSUyQyUyMC0yLjApJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKCUyMmludGVnZXIlMjIlMkMlMjAxJTJDJTIwMS4wKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCglMjJsYXJnZSUyMGZyYWN0aW9uJTIyJTJDJTIwMS42JTJDJTIwMSklMkMlMEElMjAlMjAlMjAlMjAlNUQlMkMlMEEpJTBBZGVmJTIwdGVzdF9mbG9vcihuYW1lJTJDJTIwaW5wdXQlMkMlMjBleHBlY3RlZCklM0ElMEElMjAlMjAlMjAlMjBhc3NlcnRfZXF1YWwobWF0aC5mbG9vcihpbnB1dCklMkMlMjBleHBlY3RlZCk=",highlighted:`<span class="hljs-comment"># test_this2.py</span>
<span class="hljs-keyword">import</span> pytest


<span class="hljs-meta">@pytest.mark.parametrize(<span class="hljs-params">
    <span class="hljs-string">&quot;name, input, expected&quot;</span>,
    [
        (<span class="hljs-params"><span class="hljs-string">&quot;negative&quot;</span>, -<span class="hljs-number">1.5</span>, -<span class="hljs-number">2.0</span></span>),
        (<span class="hljs-params"><span class="hljs-string">&quot;integer&quot;</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1.0</span></span>),
        (<span class="hljs-params"><span class="hljs-string">&quot;large fraction&quot;</span>, <span class="hljs-number">1.6</span>, <span class="hljs-number">1</span></span>),
    ],
</span>)</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">test_floor</span>(<span class="hljs-params">name, <span class="hljs-built_in">input</span>, expected</span>):
    assert_equal(math.floor(<span class="hljs-built_in">input</span>), expected)`,wrap:!1}}),il=new w({props:{code:"cHl0ZXN0JTIwdGVzdF90aGlzMi5weSUyMC0tY29sbGVjdC1vbmx5JTIwLXE=",highlighted:"pytest test_this2.py --collect-only -q",wrap:!1}}),pl=new w({props:{code:"dGVzdF90aGlzMi5weSUzQSUzQXRlc3RfZmxvb3IlNUJpbnRlZ2VyLTEtMS4wJTVEJTBBdGVzdF90aGlzMi5weSUzQSUzQXRlc3RfZmxvb3IlNUJuZWdhdGl2ZS0tMS41LS0yLjAlNUQlMEF0ZXN0X3RoaXMyLnB5JTNBJTNBdGVzdF9mbG9vciU1QmxhcmdlJTIwZnJhY3Rpb24tMS42LTElNUQ=",highlighted:`test_this2.py::test_floor[integer-1-1.0]
test_this2.py::test_floor[negative--1.5--2.0]
test_this2.py::test_floor[large fraction-1.6-1]`,wrap:!1}}),rl=new w({props:{code:"cHl0ZXN0JTIwdGVzdF90aGlzMi5weSUzQSUzQXRlc3RfZmxvb3IlNUJuZWdhdGl2ZS0tMS41LS0yLjAlNUQlMjB0ZXN0X3RoaXMyLnB5JTNBJTNBdGVzdF9mbG9vciU1QmludGVnZXItMS0xLjAlNUQ=",highlighted:"pytest test_this2.py::test_floor[negative--1.5--2.0] test_this2.py::test_floor[integer-1-1.0]",wrap:!1}}),wl=new w({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycy50ZXN0aW5nX3V0aWxzJTIwaW1wb3J0JTIwVGVzdENhc2VQbHVzJTBBJTBBJTBBY2xhc3MlMjBQYXRoRXhhbXBsZVRlc3QoVGVzdENhc2VQbHVzKSUzQSUwQSUyMCUyMCUyMCUyMGRlZiUyMHRlc3Rfc29tZXRoaW5nX2ludm9sdmluZ19sb2NhbF9sb2NhdGlvbnMoc2VsZiklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBkYXRhX2RpciUyMCUzRCUyMHNlbGYudGVzdHNfZGlyJTIwJTJGJTIwJTIyZml4dHVyZXMlMkZ0ZXN0c19zYW1wbGVzJTJGd210X2VuX3JvJTIy",highlighted:`<span class="hljs-keyword">from</span> transformers.testing_utils <span class="hljs-keyword">import</span> TestCasePlus


<span class="hljs-keyword">class</span> <span class="hljs-title class_">PathExampleTest</span>(<span class="hljs-title class_ inherited__">TestCasePlus</span>):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">test_something_involving_local_locations</span>(<span class="hljs-params">self</span>):
        data_dir = self.tests_dir / <span class="hljs-string">&quot;fixtures/tests_samples/wmt_en_ro&quot;</span>`,wrap:!1}}),yl=new w({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycy50ZXN0aW5nX3V0aWxzJTIwaW1wb3J0JTIwVGVzdENhc2VQbHVzJTBBJTBBJTBBY2xhc3MlMjBQYXRoRXhhbXBsZVRlc3QoVGVzdENhc2VQbHVzKSUzQSUwQSUyMCUyMCUyMCUyMGRlZiUyMHRlc3Rfc29tZXRoaW5nX2ludm9sdmluZ19zdHJpbmdpZmllZF9sb2NhdGlvbnMoc2VsZiklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBleGFtcGxlc19kaXIlMjAlM0QlMjBzZWxmLmV4YW1wbGVzX2Rpcl9zdHI=",highlighted:`<span class="hljs-keyword">from</span> transformers.testing_utils <span class="hljs-keyword">import</span> TestCasePlus


<span class="hljs-keyword">class</span> <span class="hljs-title class_">PathExampleTest</span>(<span class="hljs-title class_ inherited__">TestCasePlus</span>):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">test_something_involving_stringified_locations</span>(<span class="hljs-params">self</span>):
        examples_dir = self.examples_dir_str`,wrap:!1}}),Cl=new w({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycy50ZXN0aW5nX3V0aWxzJTIwaW1wb3J0JTIwVGVzdENhc2VQbHVzJTBBJTBBJTBBY2xhc3MlMjBFeGFtcGxlc1Rlc3RzKFRlc3RDYXNlUGx1cyklM0ElMEElMjAlMjAlMjAlMjBkZWYlMjB0ZXN0X3doYXRldmVyKHNlbGYpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdG1wX2RpciUyMCUzRCUyMHNlbGYuZ2V0X2F1dG9fcmVtb3ZlX3RtcF9kaXIoKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers.testing_utils <span class="hljs-keyword">import</span> TestCasePlus


<span class="hljs-keyword">class</span> <span class="hljs-title class_">ExamplesTests</span>(<span class="hljs-title class_ inherited__">TestCasePlus</span>):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">test_whatever</span>(<span class="hljs-params">self</span>):
        tmp_dir = self.get_auto_remove_tmp_dir()`,wrap:!1}}),gl=new w({props:{code:"ZGVmJTIwdGVzdF93aGF0ZXZlcihzZWxmKSUzQSUwQSUyMCUyMCUyMCUyMHRtcF9kaXIlMjAlM0QlMjBzZWxmLmdldF9hdXRvX3JlbW92ZV90bXBfZGlyKCk=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">test_whatever</span>(<span class="hljs-params">self</span>):
    tmp_dir = self.get_auto_remove_tmp_dir()`,wrap:!1}}),_l=new w({props:{code:"ZGVmJTIwdGVzdF93aGF0ZXZlcihzZWxmKSUzQSUwQSUyMCUyMCUyMCUyMHRtcF9kaXIlMjAlM0QlMjBzZWxmLmdldF9hdXRvX3JlbW92ZV90bXBfZGlyKCUyMi4lMkZ4eHglMjIp",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">test_whatever</span>(<span class="hljs-params">self</span>):
    tmp_dir = self.get_auto_remove_tmp_dir(<span class="hljs-string">&quot;./xxx&quot;</span>)`,wrap:!1}}),j=new Wf({props:{$$slots:{default:[Ew]},$$scope:{ctx:J}}}),v=new Wf({props:{$$slots:{default:[Pw]},$$scope:{ctx:J}}}),Gl=new w({props:{code:"aW1wb3J0JTIwb3MlMEFmcm9tJTIwdHJhbnNmb3JtZXJzLnRlc3RpbmdfdXRpbHMlMjBpbXBvcnQlMjBFeHRlbmRTeXNQYXRoJTBBJTBBYmluZGlyJTIwJTNEJTIwb3MucGF0aC5hYnNwYXRoKG9zLnBhdGguZGlybmFtZShfX2ZpbGVfXykpJTBBd2l0aCUyMEV4dGVuZFN5c1BhdGgoZiUyMiU3QmJpbmRpciU3RCUyRi4uJTIyKSUzQSUwQSUyMCUyMCUyMCUyMGZyb20lMjB0ZXN0X3RyYWluZXIlMjBpbXBvcnQlMjBUcmFpbmVySW50ZWdyYXRpb25Db21tb24lMjAlMjAlMjMlMjBub3Fh",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">from</span> transformers.testing_utils <span class="hljs-keyword">import</span> ExtendSysPath

bindir = os.path.abspath(os.path.dirname(__file__))
<span class="hljs-keyword">with</span> ExtendSysPath(<span class="hljs-string">f&quot;<span class="hljs-subst">{bindir}</span>/..&quot;</span>):
    <span class="hljs-keyword">from</span> test_trainer <span class="hljs-keyword">import</span> TrainerIntegrationCommon  <span class="hljs-comment"># noqa</span>`,wrap:!1}}),Ll=new w({props:{code:"JTQwdW5pdHRlc3Quc2tpcCglMjJ0aGlzJTIwYnVnJTIwbmVlZHMlMjB0byUyMGJlJTIwZml4ZWQlMjIpJTBBZGVmJTIwdGVzdF9mZWF0dXJlX3goKSUzQQ==",highlighted:`<span class="hljs-meta">@unittest.skip(<span class="hljs-params"><span class="hljs-string">&quot;this bug needs to be fixed&quot;</span></span>)</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">test_feature_x</span>():`,wrap:!1}}),Ql=new w({props:{code:"JTQwcHl0ZXN0Lm1hcmsuc2tpcChyZWFzb24lM0QlMjJ0aGlzJTIwYnVnJTIwbmVlZHMlMjB0byUyMGJlJTIwZml4ZWQlMjIp",highlighted:'<span class="hljs-meta">@pytest.mark.skip(<span class="hljs-params">reason=<span class="hljs-string">&quot;this bug needs to be fixed&quot;</span></span>)</span>',wrap:!1}}),El=new w({props:{code:"JTQwcHl0ZXN0Lm1hcmsueGZhaWwlMEFkZWYlMjB0ZXN0X2ZlYXR1cmVfeCgpJTNB",highlighted:`<span class="hljs-meta">@pytest.mark.xfail</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">test_feature_x</span>():`,wrap:!1}}),Al=new w({props:{code:"ZGVmJTIwdGVzdF9mZWF0dXJlX3goKSUzQSUwQSUyMCUyMCUyMCUyMGlmJTIwbm90JTIwaGFzX3NvbWV0aGluZygpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHl0ZXN0LnNraXAoJTIydW5zdXBwb3J0ZWQlMjBjb25maWd1cmF0aW9uJTIyKQ==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">test_feature_x</span>():
    <span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> has_something():
        pytest.skip(<span class="hljs-string">&quot;unsupported configuration&quot;</span>)`,wrap:!1}}),ql=new w({props:{code:"aW1wb3J0JTIwcHl0ZXN0JTBBJTBBaWYlMjBub3QlMjBweXRlc3QuY29uZmlnLmdldG9wdGlvbiglMjItLWN1c3RvbS1mbGFnJTIyKSUzQSUwQSUyMCUyMCUyMCUyMHB5dGVzdC5za2lwKCUyMi0tY3VzdG9tLWZsYWclMjBpcyUyMG1pc3NpbmclMkMlMjBza2lwcGluZyUyMHRlc3RzJTIyJTJDJTIwYWxsb3dfbW9kdWxlX2xldmVsJTNEVHJ1ZSk=",highlighted:`<span class="hljs-keyword">import</span> pytest

<span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> pytest.config.getoption(<span class="hljs-string">&quot;--custom-flag&quot;</span>):
    pytest.skip(<span class="hljs-string">&quot;--custom-flag is missing, skipping tests&quot;</span>, allow_module_level=<span class="hljs-literal">True</span>)`,wrap:!1}}),Dl=new w({props:{code:"ZGVmJTIwdGVzdF9mZWF0dXJlX3goKSUzQSUwQSUyMCUyMCUyMCUyMHB5dGVzdC54ZmFpbCglMjJleHBlY3RlZCUyMHRvJTIwZmFpbCUyMHVudGlsJTIwYnVnJTIwWFlaJTIwaXMlMjBmaXhlZCUyMik=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">test_feature_x</span>():
    pytest.xfail(<span class="hljs-string">&quot;expected to fail until bug XYZ is fixed&quot;</span>)`,wrap:!1}}),en=new w({props:{code:"ZG9jdXRpbHMlMjAlM0QlMjBweXRlc3QuaW1wb3J0b3Jza2lwKCUyMmRvY3V0aWxzJTIyJTJDJTIwbWludmVyc2lvbiUzRCUyMjAuMyUyMik=",highlighted:'docutils = pytest.importorskip(<span class="hljs-string">&quot;docutils&quot;</span>, minversion=<span class="hljs-string">&quot;0.3&quot;</span>)',wrap:!1}}),sn=new w({props:{code:"JTQwcHl0ZXN0Lm1hcmsuc2tpcGlmKHN5cy52ZXJzaW9uX2luZm8lMjAlM0MlMjAoMyUyQzYpJTJDJTIwcmVhc29uJTNEJTIycmVxdWlyZXMlMjBweXRob24zLjYlMjBvciUyMGhpZ2hlciUyMiklMEFkZWYlMjB0ZXN0X2ZlYXR1cmVfeCgpJTNB",highlighted:`<span class="hljs-meta">@pytest.mark.skipif(<span class="hljs-params">sys.version_info &lt; (<span class="hljs-params"><span class="hljs-number">3</span>,<span class="hljs-number">6</span></span>), reason=<span class="hljs-string">&quot;requires python3.6 or higher&quot;</span></span>)</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">test_feature_x</span>():`,wrap:!1}}),nn=new w({props:{code:"JTQwdW5pdHRlc3Quc2tpcElmKHRvcmNoX2RldmljZSUyMCUzRCUzRCUyMCUyMmNwdSUyMiUyQyUyMCUyMkNhbid0JTIwZG8lMjBoYWxmJTIwcHJlY2lzaW9uJTIyKSUwQWRlZiUyMHRlc3RfZmVhdHVyZV94KCklM0E=",highlighted:`<span class="hljs-meta">@unittest.skipIf(<span class="hljs-params">torch_device == <span class="hljs-string">&quot;cpu&quot;</span>, <span class="hljs-string">&quot;Can&#x27;t do half precision&quot;</span></span>)</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">test_feature_x</span>():`,wrap:!1}}),pn=new w({props:{code:"JTQwcHl0ZXN0Lm1hcmsuc2tpcGlmKHN5cy5wbGF0Zm9ybSUyMCUzRCUzRCUyMCd3aW4zMiclMkMlMjByZWFzb24lM0QlMjJkb2VzJTIwbm90JTIwcnVuJTIwb24lMjB3aW5kb3dzJTIyKSUwQWNsYXNzJTIwVGVzdENsYXNzKCklM0ElMEElMjAlMjAlMjAlMjBkZWYlMjB0ZXN0X2ZlYXR1cmVfeChzZWxmKSUzQQ==",highlighted:`<span class="hljs-meta">@pytest.mark.skipif(<span class="hljs-params">sys.platform == <span class="hljs-string">&#x27;win32&#x27;</span>, reason=<span class="hljs-string">&quot;does not run on windows&quot;</span></span>)</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">TestClass</span>():
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">test_feature_x</span>(<span class="hljs-params">self</span>):`,wrap:!1}}),fn=new w({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycy50ZXN0aW5nX3V0aWxzJTIwaW1wb3J0JTIwc2xvdyUwQSU0MHNsb3clMEFkZWYlMjB0ZXN0X2ludGVncmF0aW9uX2ZvbygpJTNB",highlighted:`<span class="hljs-keyword">from</span> transformers.testing_utils <span class="hljs-keyword">import</span> slow
<span class="hljs-meta">@slow</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">test_integration_foo</span>():`,wrap:!1}}),un=new w({props:{code:"UlVOX1NMT1clM0QxJTIwcHl0ZXN0JTIwdGVzdHM=",highlighted:"RUN_SLOW=1 pytest tests",wrap:!1}}),wn=new w({props:{code:"JTQwcGFyYW1ldGVyaXplZC5leHBhbmQoLi4uKSUwQSU0MHNsb3clMEFkZWYlMjB0ZXN0X2ludGVncmF0aW9uX2ZvbygpJTNB",highlighted:`<span class="hljs-meta">@parameterized.expand(<span class="hljs-params">...</span>)</span>
<span class="hljs-meta">@slow</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">test_integration_foo</span>():`,wrap:!1}}),Jn=new w({props:{code:"Z3JlcCUyMHRpbnklMjB0ZXN0cyUyMGV4YW1wbGVz",highlighted:"grep tiny tests examples",wrap:!1}}),Un=new w({props:{code:"aW1wb3J0JTIwc3lzJTBBJTBBJTBBZGVmJTIwcHJpbnRfdG9fc3Rkb3V0KHMpJTNBJTBBJTIwJTIwJTIwJTIwcHJpbnQocyklMEElMEElMEFkZWYlMjBwcmludF90b19zdGRlcnIocyklM0ElMEElMjAlMjAlMjAlMjBzeXMuc3RkZXJyLndyaXRlKHMpJTBBJTBBJTBBZGVmJTIwdGVzdF9yZXN1bHRfYW5kX3N0ZG91dChjYXBzeXMpJTNBJTBBJTIwJTIwJTIwJTIwbXNnJTIwJTNEJTIwJTIySGVsbG8lMjIlMEElMjAlMjAlMjAlMjBwcmludF90b19zdGRvdXQobXNnKSUwQSUyMCUyMCUyMCUyMHByaW50X3RvX3N0ZGVycihtc2cpJTBBJTIwJTIwJTIwJTIwb3V0JTJDJTIwZXJyJTIwJTNEJTIwY2Fwc3lzLnJlYWRvdXRlcnIoKSUyMCUyMCUyMyUyMGNvbnN1bWUlMjB0aGUlMjBjYXB0dXJlZCUyMG91dHB1dCUyMHN0cmVhbXMlMEElMjAlMjAlMjAlMjAlMjMlMjBvcHRpb25hbCUzQSUyMGlmJTIweW91JTIwd2FudCUyMHRvJTIwcmVwbGF5JTIwdGhlJTIwY29uc3VtZWQlMjBzdHJlYW1zJTNBJTBBJTIwJTIwJTIwJTIwc3lzLnN0ZG91dC53cml0ZShvdXQpJTBBJTIwJTIwJTIwJTIwc3lzLnN0ZGVyci53cml0ZShlcnIpJTBBJTIwJTIwJTIwJTIwJTIzJTIwdGVzdCUzQSUwQSUyMCUyMCUyMCUyMGFzc2VydCUyMG1zZyUyMGluJTIwb3V0JTBBJTIwJTIwJTIwJTIwYXNzZXJ0JTIwbXNnJTIwaW4lMjBlcnI=",highlighted:`<span class="hljs-keyword">import</span> sys


<span class="hljs-keyword">def</span> <span class="hljs-title function_">print_to_stdout</span>(<span class="hljs-params">s</span>):
    <span class="hljs-built_in">print</span>(s)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">print_to_stderr</span>(<span class="hljs-params">s</span>):
    sys.stderr.write(s)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">test_result_and_stdout</span>(<span class="hljs-params">capsys</span>):
    msg = <span class="hljs-string">&quot;Hello&quot;</span>
    print_to_stdout(msg)
    print_to_stderr(msg)
    out, err = capsys.readouterr()  <span class="hljs-comment"># consume the captured output streams</span>
    <span class="hljs-comment"># optional: if you want to replay the consumed streams:</span>
    sys.stdout.write(out)
    sys.stderr.write(err)
    <span class="hljs-comment"># test:</span>
    <span class="hljs-keyword">assert</span> msg <span class="hljs-keyword">in</span> out
    <span class="hljs-keyword">assert</span> msg <span class="hljs-keyword">in</span> err`,wrap:!1}}),_n=new w({props:{code:"ZGVmJTIwcmFpc2VfZXhjZXB0aW9uKG1zZyklM0ElMEElMjAlMjAlMjAlMjByYWlzZSUyMFZhbHVlRXJyb3IobXNnKSUwQSUwQSUwQWRlZiUyMHRlc3Rfc29tZXRoaW5nX2V4Y2VwdGlvbigpJTNBJTBBJTIwJTIwJTIwJTIwbXNnJTIwJTNEJTIwJTIyTm90JTIwYSUyMGdvb2QlMjB2YWx1ZSUyMiUwQSUyMCUyMCUyMCUyMGVycm9yJTIwJTNEJTIwJTIyJTIyJTBBJTIwJTIwJTIwJTIwdHJ5JTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmFpc2VfZXhjZXB0aW9uKG1zZyklMEElMjAlMjAlMjAlMjBleGNlcHQlMjBFeGNlcHRpb24lMjBhcyUyMGUlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBlcnJvciUyMCUzRCUyMHN0cihlKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGFzc2VydCUyMG1zZyUyMGluJTIwZXJyb3IlMkMlMjBmJTIyJTdCbXNnJTdEJTIwaXMlMjBpbiUyMHRoZSUyMGV4Y2VwdGlvbiUzQSU1Q24lN0JlcnJvciU3RCUyMg==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">raise_exception</span>(<span class="hljs-params">msg</span>):
    <span class="hljs-keyword">raise</span> ValueError(msg)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">test_something_exception</span>():
    msg = <span class="hljs-string">&quot;Not a good value&quot;</span>
    error = <span class="hljs-string">&quot;&quot;</span>
    <span class="hljs-keyword">try</span>:
        raise_exception(msg)
    <span class="hljs-keyword">except</span> Exception <span class="hljs-keyword">as</span> e:
        error = <span class="hljs-built_in">str</span>(e)
        <span class="hljs-keyword">assert</span> msg <span class="hljs-keyword">in</span> error, <span class="hljs-string">f&quot;<span class="hljs-subst">{msg}</span> is in the exception:\\n<span class="hljs-subst">{error}</span>&quot;</span>`,wrap:!1}}),kn=new w({props:{code:"ZnJvbSUyMGlvJTIwaW1wb3J0JTIwU3RyaW5nSU8lMEFmcm9tJTIwY29udGV4dGxpYiUyMGltcG9ydCUyMHJlZGlyZWN0X3N0ZG91dCUwQSUwQSUwQWRlZiUyMHByaW50X3RvX3N0ZG91dChzKSUzQSUwQSUyMCUyMCUyMCUyMHByaW50KHMpJTBBJTBBJTBBZGVmJTIwdGVzdF9yZXN1bHRfYW5kX3N0ZG91dCgpJTNBJTBBJTIwJTIwJTIwJTIwbXNnJTIwJTNEJTIwJTIySGVsbG8lMjIlMEElMjAlMjAlMjAlMjBidWZmZXIlMjAlM0QlMjBTdHJpbmdJTygpJTBBJTIwJTIwJTIwJTIwd2l0aCUyMHJlZGlyZWN0X3N0ZG91dChidWZmZXIpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJpbnRfdG9fc3Rkb3V0KG1zZyklMEElMjAlMjAlMjAlMjBvdXQlMjAlM0QlMjBidWZmZXIuZ2V0dmFsdWUoKSUwQSUyMCUyMCUyMCUyMCUyMyUyMG9wdGlvbmFsJTNBJTIwaWYlMjB5b3UlMjB3YW50JTIwdG8lMjByZXBsYXklMjB0aGUlMjBjb25zdW1lZCUyMHN0cmVhbXMlM0ElMEElMjAlMjAlMjAlMjBzeXMuc3Rkb3V0LndyaXRlKG91dCklMEElMjAlMjAlMjAlMjAlMjMlMjB0ZXN0JTNBJTBBJTIwJTIwJTIwJTIwYXNzZXJ0JTIwbXNnJTIwaW4lMjBvdXQ=",highlighted:`<span class="hljs-keyword">from</span> io <span class="hljs-keyword">import</span> StringIO
<span class="hljs-keyword">from</span> contextlib <span class="hljs-keyword">import</span> redirect_stdout


<span class="hljs-keyword">def</span> <span class="hljs-title function_">print_to_stdout</span>(<span class="hljs-params">s</span>):
    <span class="hljs-built_in">print</span>(s)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">test_result_and_stdout</span>():
    msg = <span class="hljs-string">&quot;Hello&quot;</span>
    buffer = StringIO()
    <span class="hljs-keyword">with</span> redirect_stdout(buffer):
        print_to_stdout(msg)
    out = buffer.getvalue()
    <span class="hljs-comment"># optional: if you want to replay the consumed streams:</span>
    sys.stdout.write(out)
    <span class="hljs-comment"># test:</span>
    <span class="hljs-keyword">assert</span> msg <span class="hljs-keyword">in</span> out`,wrap:!1}}),Gn=new w({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycy50ZXN0aW5nX3V0aWxzJTIwaW1wb3J0JTIwQ2FwdHVyZVN0ZG91dCUwQSUwQXdpdGglMjBDYXB0dXJlU3Rkb3V0KCklMjBhcyUyMGNzJTNBJTBBJTIwJTIwJTIwJTIwZnVuY3Rpb25fdGhhdF93cml0ZXNfdG9fc3Rkb3V0KCklMEFwcmludChjcy5vdXQp",highlighted:`<span class="hljs-keyword">from</span> transformers.testing_utils <span class="hljs-keyword">import</span> CaptureStdout

<span class="hljs-keyword">with</span> CaptureStdout() <span class="hljs-keyword">as</span> cs:
    function_that_writes_to_stdout()
<span class="hljs-built_in">print</span>(cs.out)`,wrap:!1}}),Xn=new w({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycy50ZXN0aW5nX3V0aWxzJTIwaW1wb3J0JTIwQ2FwdHVyZVN0ZG91dCUwQSUwQW1zZyUyMCUzRCUyMCUyMlNlY3JldCUyMG1lc3NhZ2UlNUNyJTIyJTBBZmluYWwlMjAlM0QlMjAlMjJIZWxsbyUyMFdvcmxkJTIyJTBBd2l0aCUyMENhcHR1cmVTdGRvdXQoKSUyMGFzJTIwY3MlM0ElMEElMjAlMjAlMjAlMjBwcmludChtc2clMjAlMkIlMjBmaW5hbCklMEFhc3NlcnQlMjBjcy5vdXQlMjAlM0QlM0QlMjBmaW5hbCUyMCUyQiUyMCUyMiU1Q24lMjIlMkMlMjBmJTIyY2FwdHVyZWQlM0ElMjAlN0Jjcy5vdXQlN0QlMkMlMjBleHBlY3RpbmclMjAlN0JmaW5hbCU3RCUyMg==",highlighted:`<span class="hljs-keyword">from</span> transformers.testing_utils <span class="hljs-keyword">import</span> CaptureStdout

msg = <span class="hljs-string">&quot;Secret message\\r&quot;</span>
final = <span class="hljs-string">&quot;Hello World&quot;</span>
<span class="hljs-keyword">with</span> CaptureStdout() <span class="hljs-keyword">as</span> cs:
    <span class="hljs-built_in">print</span>(msg + final)
<span class="hljs-keyword">assert</span> cs.out == final + <span class="hljs-string">&quot;\\n&quot;</span>, <span class="hljs-string">f&quot;captured: <span class="hljs-subst">{cs.out}</span>, expecting <span class="hljs-subst">{final}</span>&quot;</span>`,wrap:!1}}),Rn=new w({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycy50ZXN0aW5nX3V0aWxzJTIwaW1wb3J0JTIwQ2FwdHVyZVN0ZGVyciUwQSUwQXdpdGglMjBDYXB0dXJlU3RkZXJyKCklMjBhcyUyMGNzJTNBJTBBJTIwJTIwJTIwJTIwZnVuY3Rpb25fdGhhdF93cml0ZXNfdG9fc3RkZXJyKCklMEFwcmludChjcy5lcnIp",highlighted:`<span class="hljs-keyword">from</span> transformers.testing_utils <span class="hljs-keyword">import</span> CaptureStderr

<span class="hljs-keyword">with</span> CaptureStderr() <span class="hljs-keyword">as</span> cs:
    function_that_writes_to_stderr()
<span class="hljs-built_in">print</span>(cs.err)`,wrap:!1}}),zn=new w({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycy50ZXN0aW5nX3V0aWxzJTIwaW1wb3J0JTIwQ2FwdHVyZVN0ZCUwQSUwQXdpdGglMjBDYXB0dXJlU3RkKCklMjBhcyUyMGNzJTNBJTBBJTIwJTIwJTIwJTIwZnVuY3Rpb25fdGhhdF93cml0ZXNfdG9fc3Rkb3V0X2FuZF9zdGRlcnIoKSUwQXByaW50KGNzLmVyciUyQyUyMGNzLm91dCk=",highlighted:`<span class="hljs-keyword">from</span> transformers.testing_utils <span class="hljs-keyword">import</span> CaptureStd

<span class="hljs-keyword">with</span> CaptureStd() <span class="hljs-keyword">as</span> cs:
    function_that_writes_to_stdout_and_stderr()
<span class="hljs-built_in">print</span>(cs.err, cs.out)`,wrap:!1}}),Qn=new w({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMGxvZ2dpbmclMEFmcm9tJTIwdHJhbnNmb3JtZXJzLnRlc3RpbmdfdXRpbHMlMjBpbXBvcnQlMjBDYXB0dXJlTG9nZ2VyJTBBJTBBbXNnJTIwJTNEJTIwJTIyVGVzdGluZyUyMDElMkMlMjAyJTJDJTIwMyUyMiUwQWxvZ2dpbmcuc2V0X3ZlcmJvc2l0eV9pbmZvKCklMEFsb2dnZXIlMjAlM0QlMjBsb2dnaW5nLmdldF9sb2dnZXIoJTIydHJhbnNmb3JtZXJzLm1vZGVscy5iYXJ0LnRva2VuaXphdGlvbl9iYXJ0JTIyKSUwQXdpdGglMjBDYXB0dXJlTG9nZ2VyKGxvZ2dlciklMjBhcyUyMGNsJTNBJTBBJTIwJTIwJTIwJTIwbG9nZ2VyLmluZm8obXNnKSUwQWFzc2VydCUyMGNsLm91dCUyQyUyMG1zZyUyMCUyQiUyMCUyMiU1Q24lMjI=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> logging
<span class="hljs-keyword">from</span> transformers.testing_utils <span class="hljs-keyword">import</span> CaptureLogger

msg = <span class="hljs-string">&quot;Testing 1, 2, 3&quot;</span>
logging.set_verbosity_info()
logger = logging.get_logger(<span class="hljs-string">&quot;transformers.models.bart.tokenization_bart&quot;</span>)
<span class="hljs-keyword">with</span> CaptureLogger(logger) <span class="hljs-keyword">as</span> cl:
    logger.info(msg)
<span class="hljs-keyword">assert</span> cl.out, msg + <span class="hljs-string">&quot;\\n&quot;</span>`,wrap:!1}}),Pn=new w({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycy50ZXN0aW5nX3V0aWxzJTIwaW1wb3J0JTIwbW9ja2VudiUwQSUwQSUwQWNsYXNzJTIwSGZBcmd1bWVudFBhcnNlclRlc3QodW5pdHRlc3QuVGVzdENhc2UpJTNBJTBBJTIwJTIwJTIwJTIwJTQwbW9ja2VudihUUkFOU0ZPUk1FUlNfVkVSQk9TSVRZJTNEJTIyZXJyb3IlMjIpJTBBJTIwJTIwJTIwJTIwZGVmJTIwdGVzdF9lbnZfb3ZlcnJpZGUoc2VsZiklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBlbnZfbGV2ZWxfc3RyJTIwJTNEJTIwb3MuZ2V0ZW52KCUyMlRSQU5TRk9STUVSU19WRVJCT1NJVFklMjIlMkMlMjBOb25lKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers.testing_utils <span class="hljs-keyword">import</span> mockenv


<span class="hljs-keyword">class</span> <span class="hljs-title class_">HfArgumentParserTest</span>(unittest.TestCase):
<span class="hljs-meta">    @mockenv(<span class="hljs-params">TRANSFORMERS_VERBOSITY=<span class="hljs-string">&quot;error&quot;</span></span>)</span>
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">test_env_override</span>(<span class="hljs-params">self</span>):
        env_level_str = os.getenv(<span class="hljs-string">&quot;TRANSFORMERS_VERBOSITY&quot;</span>, <span class="hljs-literal">None</span>)`,wrap:!1}}),Yn=new w({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycy50ZXN0aW5nX3V0aWxzJTIwaW1wb3J0JTIwVGVzdENhc2VQbHVzJTBBJTBBJTBBY2xhc3MlMjBFbnZFeGFtcGxlVGVzdChUZXN0Q2FzZVBsdXMpJTNBJTBBJTIwJTIwJTIwJTIwZGVmJTIwdGVzdF9leHRlcm5hbF9wcm9nKHNlbGYpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZW52JTIwJTNEJTIwc2VsZi5nZXRfZW52KCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBub3clMjBjYWxsJTIwdGhlJTIwZXh0ZXJuYWwlMjBwcm9ncmFtJTJDJTIwcGFzc2luZyUyMCU2MGVudiU2MCUyMHRvJTIwaXQ=",highlighted:`<span class="hljs-keyword">from</span> transformers.testing_utils <span class="hljs-keyword">import</span> TestCasePlus


<span class="hljs-keyword">class</span> <span class="hljs-title class_">EnvExampleTest</span>(<span class="hljs-title class_ inherited__">TestCasePlus</span>):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">test_external_prog</span>(<span class="hljs-params">self</span>):
        env = self.get_env()
        <span class="hljs-comment"># now call the external program, passing \`env\` to it</span>`,wrap:!1}}),ei=new w({props:{code:"c2VlZCUyMCUzRCUyMDQyJTBBJTBBJTIzJTIwcHl0aG9uJTIwUk5HJTBBaW1wb3J0JTIwcmFuZG9tJTBBJTBBcmFuZG9tLnNlZWQoc2VlZCklMEElMEElMjMlMjBweXRvcmNoJTIwUk5HcyUwQWltcG9ydCUyMHRvcmNoJTBBJTBBdG9yY2gubWFudWFsX3NlZWQoc2VlZCklMEF0b3JjaC5iYWNrZW5kcy5jdWRubi5kZXRlcm1pbmlzdGljJTIwJTNEJTIwVHJ1ZSUwQWlmJTIwdG9yY2guY3VkYS5pc19hdmFpbGFibGUoKSUzQSUwQSUyMCUyMCUyMCUyMHRvcmNoLmN1ZGEubWFudWFsX3NlZWRfYWxsKHNlZWQpJTBBJTBBJTIzJTIwbnVtcHklMjBSTkclMEFpbXBvcnQlMjBudW1weSUyMGFzJTIwbnAlMEElMEFucC5yYW5kb20uc2VlZChzZWVkKSUwQSUwQSUyMyUyMHRmJTIwUk5HJTBBdGYucmFuZG9tLnNldF9zZWVkKHNlZWQp",highlighted:`seed = <span class="hljs-number">42</span>

<span class="hljs-comment"># python RNG</span>
<span class="hljs-keyword">import</span> random

random.seed(seed)

<span class="hljs-comment"># pytorch RNGs</span>
<span class="hljs-keyword">import</span> torch

torch.manual_seed(seed)
torch.backends.cudnn.deterministic = <span class="hljs-literal">True</span>
<span class="hljs-keyword">if</span> torch.cuda.is_available():
    torch.cuda.manual_seed_all(seed)

<span class="hljs-comment"># numpy RNG</span>
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

np.random.seed(seed)

<span class="hljs-comment"># tf RNG</span>
tf.random.set_seed(seed)`,wrap:!1}}),li=new w({props:{code:"cHl0ZXN0JTIwdGVzdHMlMkZ1dGlscyUyRnRlc3RfbG9nZ2luZy5weSUyMC1XJTIwZXJyb3IlM0ElM0FVc2VyV2FybmluZyUyMC0tcGRi",highlighted:"pytest tests/utils/test_logging.py -W error::UserWarning --pdb",wrap:!1}}),hi=new w({props:{code:"LSUyMHJ1biUzQSUwQSUyMCUyMCUyMCUyMG5hbWUlM0ElMjBydW4lMjBDSSUyMGV4cGVyaW1lbnQlMEElMjAlMjAlMjAlMjBjb21tYW5kJTNBJTIwJTdDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2V0JTIwJTJCZXVvJTIwcGlwZWZhaWwlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBlY2hvJTIwJTIyc2V0dGluZyUyMHJ1bi1hbGwtZGVzcGl0ZS1hbnktZXJyb3JzLW1vZGUlMjIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB0aGlzX2NvbW1hbmRfd2lsbF9mYWlsJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZWNobyUyMCUyMmJ1dCUyMGJhc2glMjBjb250aW51ZXMlMjB0byUyMHJ1biUyMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMGVtdWxhdGUlMjBhbm90aGVyJTIwZmFpbHVyZSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGZhbHNlJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwYnV0JTIwdGhlJTIwbGFzdCUyMGNvbW1hbmQlMjBtdXN0JTIwYmUlMjBhJTIwc3VjY2VzcyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGVjaG8lMjAlMjJkdXJpbmclMjBleHBlcmltZW50JTIwZG8lMjBub3QlMjByZW1vdmUlM0ElMjByZXBvcnRpbmclMjBzdWNjZXNzJTIwdG8lMjBDSSUyQyUyMGV2ZW4lMjBpZiUyMHRoZXJlJTIwd2VyZSUyMGZhaWx1cmVzJTIy",highlighted:`<span class="hljs-bullet">-</span> <span class="hljs-attr">run:</span>
    <span class="hljs-attr">name:</span> <span class="hljs-string">run</span> <span class="hljs-string">CI</span> <span class="hljs-string">experiment</span>
    <span class="hljs-attr">command:</span> <span class="hljs-string">|
        set +euo pipefail
        echo &quot;setting run-all-despite-any-errors-mode&quot;
        this_command_will_fail
        echo &quot;but bash continues to run&quot;
        # emulate another failure
        false
        # but the last command must be a success
        echo &quot;during experiment do not remove: reporting success to CI, even if there were failures&quot;</span>`,wrap:!1}}),Mi=new w({props:{code:"Y21kX3RoYXRfbWF5X2ZhaWwlMjAlN0MlN0MlMjB0cnVl",highlighted:'cmd_that_may_fail || <span class="hljs-literal">true</span>',wrap:!1}}),gi=new w({props:{code:"UlVOX1NMT1clM0QxJTIwcHl0ZXN0JTIwdGVzdHMlMkZkZWVwc3BlZWQlMkZ0ZXN0X2RlZXBzcGVlZC5weQ==",highlighted:"RUN_SLOW=1 pytest tests/deepspeed/test_deepspeed.py",wrap:!1}}),xi=new w({props:{code:"UlVOX1NMT1clM0QxJTIwcHl0ZXN0JTIwdGVzdHMlMkZkZWVwc3BlZWQ=",highlighted:"RUN_SLOW=1 pytest tests/deepspeed",wrap:!1}}),_i=new Sw({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/testing.md"}}),{c(){h=a("meta"),T=n(),y=a("p"),$=n(),r(g.$$.fragment),ki=n(),U=a("p"),U.textContent=Sf,Zi=n(),x=a("p"),x.textContent=Qf,Hi=n(),_=a("ol"),_.innerHTML=Ff,Gi=n(),r(I.$$.fragment),Bi=n(),k=a("ol"),k.innerHTML=Ef,Xi=n(),r(Z.$$.fragment),Vi=n(),H=a("p"),H.innerHTML=Pf,Ri=n(),r(G.$$.fragment),Ni=n(),r(B.$$.fragment),zi=n(),X=a("p"),X.innerHTML=Af,Wi=n(),V=a("p"),V.textContent=Yf,Li=n(),R=a("p"),R.textContent=qf,Si=n(),r(N.$$.fragment),Qi=n(),z=a("p"),z.textContent=Kf,Fi=n(),r(W.$$.fragment),Ei=n(),L=a("p"),L.textContent=Df,Pi=n(),r(S.$$.fragment),Ai=n(),Q=a("p"),Q.textContent=Of,Yi=n(),F=a("ul"),F.innerHTML=em,qi=n(),r(E.$$.fragment),Ki=n(),P=a("p"),P.textContent=tm,Di=n(),r(A.$$.fragment),Oi=n(),Y=a("p"),Y.textContent=sm,ea=n(),r(q.$$.fragment),ta=n(),r(K.$$.fragment),sa=n(),D=a("p"),D.textContent=lm,la=n(),r(O.$$.fragment),na=n(),r(ee.$$.fragment),ia=n(),te=a("p"),te.textContent=nm,aa=n(),r(se.$$.fragment),pa=n(),le=a("p"),le.textContent=im,oa=n(),ne=a("ul"),ne.innerHTML=am,ra=n(),ie=a("p"),ie.textContent=pm,da=n(),r(ae.$$.fragment),fa=n(),pe=a("p"),pe.textContent=om,ma=n(),oe=a("p"),oe.innerHTML=rm,ua=n(),r(re.$$.fragment),ca=n(),de=a("p"),de.textContent=dm,wa=n(),fe=a("p"),fe.innerHTML=fm,ha=n(),r(me.$$.fragment),ya=n(),ue=a("p"),ue.innerHTML=mm,Ma=n(),ce=a("p"),ce.innerHTML=um,Ta=n(),r(we.$$.fragment),$a=n(),he=a("p"),he.textContent=cm,Ja=n(),r(ye.$$.fragment),ba=n(),Me=a("p"),Me.innerHTML=wm,Ca=n(),r(Te.$$.fragment),ja=n(),$e=a("p"),$e.innerHTML=hm,va=n(),Je=a("p"),Je.innerHTML=ym,ga=n(),r(be.$$.fragment),Ua=n(),r(Ce.$$.fragment),xa=n(),je=a("p"),je.innerHTML=Mm,_a=n(),r(ve.$$.fragment),Ia=n(),r(ge.$$.fragment),ka=n(),Ue=a("p"),Ue.innerHTML=Tm,Za=n(),r(xe.$$.fragment),Ha=n(),_e=a("p"),_e.textContent=$m,Ga=n(),r(Ie.$$.fragment),Ba=n(),ke=a("p"),ke.innerHTML=Jm,Xa=n(),r(Ze.$$.fragment),Va=n(),He=a("p"),He.innerHTML=bm,Ra=n(),r(Ge.$$.fragment),Na=n(),r(Be.$$.fragment),za=n(),Xe=a("p"),Xe.textContent=Cm,Wa=n(),r(Ve.$$.fragment),La=n(),Re=a("p"),Re.innerHTML=jm,Sa=n(),r(Ne.$$.fragment),Qa=n(),ze=a("p"),ze.innerHTML=vm,Fa=n(),We=a("p"),We.innerHTML=gm,Ea=n(),r(Le.$$.fragment),Pa=n(),Se=a("p"),Se.innerHTML=Um,Aa=n(),r(Qe.$$.fragment),Ya=n(),Fe=a("p"),Fe.textContent=xm,qa=n(),Ee=a("p"),Ee.innerHTML=_m,Ka=n(),r(Pe.$$.fragment),Da=n(),Ae=a("p"),Ae.innerHTML=Im,Oa=n(),r(Ye.$$.fragment),ep=n(),r(qe.$$.fragment),tp=n(),Ke=a("p"),Ke.textContent=km,sp=n(),r(De.$$.fragment),lp=n(),r(Oe.$$.fragment),np=n(),et=a("p"),et.innerHTML=Zm,ip=n(),tt=a("p"),tt.innerHTML=Hm,ap=n(),st=a("p"),st.innerHTML=Gm,pp=n(),r(lt.$$.fragment),op=n(),nt=a("p"),nt.textContent=Bm,rp=n(),r(it.$$.fragment),dp=n(),at=a("ul"),at.innerHTML=Xm,fp=n(),r(pt.$$.fragment),mp=n(),ot=a("p"),ot.textContent=Vm,up=n(),r(rt.$$.fragment),cp=n(),r(b.$$.fragment),wp=n(),r(C.$$.fragment),hp=n(),r(dt.$$.fragment),yp=n(),r(ft.$$.fragment),Mp=n(),mt=a("p"),mt.innerHTML=Rm,Tp=n(),ut=a("p"),ut.innerHTML=Nm,$p=n(),r(ct.$$.fragment),Jp=n(),wt=a("p"),wt.textContent=zm,bp=n(),r(ht.$$.fragment),Cp=n(),yt=a("p"),yt.innerHTML=Wm,jp=n(),r(Mt.$$.fragment),vp=n(),Tt=a("p"),Tt.textContent=Lm,gp=n(),r($t.$$.fragment),Up=n(),Jt=a("p"),Jt.innerHTML=Sm,xp=n(),bt=a("p"),bt.innerHTML=Qm,_p=n(),r(Ct.$$.fragment),Ip=n(),r(jt.$$.fragment),kp=n(),vt=a("p"),vt.innerHTML=Fm,Zp=n(),r(gt.$$.fragment),Hp=n(),Ut=a("p"),Ut.textContent=Em,Gp=n(),r(xt.$$.fragment),Bp=n(),_t=a("p"),_t.textContent=Pm,Xp=n(),r(It.$$.fragment),Vp=n(),kt=a("p"),kt.innerHTML=Am,Rp=n(),r(Zt.$$.fragment),Np=n(),r(Ht.$$.fragment),zp=n(),Gt=a("p"),Gt.innerHTML=Ym,Wp=n(),r(Bt.$$.fragment),Lp=n(),r(Xt.$$.fragment),Sp=n(),r(Vt.$$.fragment),Qp=n(),Rt=a("p"),Rt.innerHTML=qm,Fp=n(),r(Nt.$$.fragment),Ep=n(),zt=a("p"),zt.innerHTML=Km,Pp=n(),r(Wt.$$.fragment),Ap=n(),Lt=a("p"),Lt.textContent=Dm,Yp=n(),St=a("p"),St.textContent=Om,qp=n(),Qt=a("ul"),Qt.innerHTML=eu,Kp=n(),Ft=a("p"),Ft.textContent=tu,Dp=n(),Et=a("table"),Et.innerHTML=su,Op=n(),Pt=a("p"),Pt.textContent=lu,eo=n(),r(At.$$.fragment),to=n(),Yt=a("p"),Yt.innerHTML=nu,so=n(),r(qt.$$.fragment),lo=n(),Kt=a("p"),Kt.textContent=iu,no=n(),r(Dt.$$.fragment),io=n(),Ot=a("p"),Ot.innerHTML=au,ao=n(),r(es.$$.fragment),po=n(),ts=a("p"),ts.innerHTML=pu,oo=n(),ss=a("p"),ss.textContent=ou,ro=n(),ls=a("ul"),ls.innerHTML=ru,fo=n(),r(ns.$$.fragment),mo=n(),r(is.$$.fragment),uo=n(),as=a("p"),as.innerHTML=du,co=n(),r(ps.$$.fragment),wo=n(),os=a("p"),os.innerHTML=fu,ho=n(),rs=a("p"),rs.innerHTML=mu,yo=n(),r(ds.$$.fragment),Mo=n(),fs=a("p"),fs.innerHTML=uu,To=n(),r(ms.$$.fragment),$o=n(),us=a("p"),us.innerHTML=cu,Jo=n(),cs=a("p"),cs.innerHTML=wu,bo=n(),ws=a("p"),ws.textContent=hu,Co=n(),hs=a("p"),hs.innerHTML=yu,jo=n(),ys=a("p"),ys.textContent=Mu,vo=n(),Ms=a("ul"),Ms.innerHTML=Tu,go=n(),Ts=a("p"),Ts.innerHTML=$u,Uo=n(),$s=a("p"),$s.textContent=Ju,xo=n(),r(Js.$$.fragment),_o=n(),bs=a("p"),bs.textContent=bu,Io=n(),Cs=a("p"),Cs.innerHTML=Cu,ko=n(),js=a("p"),js.innerHTML=ju,Zo=n(),r(vs.$$.fragment),Ho=n(),gs=a("p"),gs.textContent=vu,Go=n(),r(Us.$$.fragment),Bo=n(),xs=a("p"),xs.textContent=gu,Xo=n(),_s=a("p"),_s.textContent=Uu,Vo=n(),r(Is.$$.fragment),Ro=n(),ks=a("p"),ks.textContent=xu,No=n(),Zs=a("p"),Zs.textContent=_u,zo=n(),r(Hs.$$.fragment),Wo=n(),Gs=a("p"),Gs.textContent=Iu,Lo=n(),Bs=a("p"),Bs.textContent=ku,So=n(),r(Xs.$$.fragment),Qo=n(),Vs=a("p"),Vs.textContent=Zu,Fo=n(),Rs=a("p"),Rs.innerHTML=Hu,Eo=n(),Ns=a("p"),Ns.innerHTML=Gu,Po=n(),zs=a("p"),zs.textContent=Bu,Ao=n(),Ws=a("p"),Ws.textContent=Xu,Yo=n(),r(Ls.$$.fragment),qo=n(),Ss=a("p"),Ss.innerHTML=Vu,Ko=n(),Qs=a("p"),Qs.innerHTML=Ru,Do=n(),r(Fs.$$.fragment),Oo=n(),Es=a("p"),Es.innerHTML=Nu,er=n(),r(Ps.$$.fragment),tr=n(),As=a("p"),As.innerHTML=zu,sr=n(),r(Ys.$$.fragment),lr=n(),qs=a("p"),qs.textContent=Wu,nr=n(),r(Ks.$$.fragment),ir=n(),Ds=a("p"),Ds.textContent=Lu,ar=n(),r(Os.$$.fragment),pr=n(),el=a("p"),el.innerHTML=Su,or=n(),tl=a("p"),tl.innerHTML=Qu,rr=n(),sl=a("p"),sl.innerHTML=Fu,dr=n(),r(ll.$$.fragment),fr=n(),nl=a("p"),nl.innerHTML=Eu,mr=n(),r(il.$$.fragment),ur=n(),al=a("p"),al.textContent=Pu,cr=n(),r(pl.$$.fragment),wr=n(),ol=a("p"),ol.textContent=Au,hr=n(),r(rl.$$.fragment),yr=n(),dl=a("p"),dl.textContent=Yu,Mr=n(),fl=a("p"),fl.textContent=qu,Tr=n(),ml=a("p"),ml.innerHTML=Ku,$r=n(),ul=a("ul"),ul.innerHTML=Du,Jr=n(),cl=a("p"),cl.innerHTML=Ou,br=n(),r(wl.$$.fragment),Cr=n(),hl=a("p"),hl.innerHTML=ec,jr=n(),r(yl.$$.fragment),vr=n(),Ml=a("p"),Ml.textContent=tc,gr=n(),Tl=a("p"),Tl.innerHTML=sc,Ur=n(),$l=a("p"),$l.textContent=lc,xr=n(),Jl=a("p"),Jl.innerHTML=nc,_r=n(),bl=a("p"),bl.textContent=ic,Ir=n(),r(Cl.$$.fragment),kr=n(),jl=a("p"),jl.innerHTML=ac,Zr=n(),vl=a("ul"),vl.innerHTML=pc,Hr=n(),r(gl.$$.fragment),Gr=n(),Ul=a("p"),Ul.innerHTML=oc,Br=n(),xl=a("ul"),xl.innerHTML=rc,Xr=n(),r(_l.$$.fragment),Vr=n(),Il=a("p"),Il.textContent=dc,Rr=n(),kl=a("ul"),kl.innerHTML=fc,Nr=n(),r(j.$$.fragment),zr=n(),r(v.$$.fragment),Wr=n(),Zl=a("p"),Zl.textContent=mc,Lr=n(),Hl=a("p"),Hl.innerHTML=uc,Sr=n(),r(Gl.$$.fragment),Qr=n(),Bl=a("p"),Bl.textContent=cc,Fr=n(),Xl=a("p"),Xl.innerHTML=wc,Er=n(),Vl=a("p"),Vl.textContent=hc,Pr=n(),Rl=a("ul"),Rl.innerHTML=yc,Ar=n(),Nl=a("p"),Nl.innerHTML=Mc,Yr=n(),zl=a("p"),zl.textContent=Tc,qr=n(),Wl=a("ul"),Wl.innerHTML=$c,Kr=n(),r(Ll.$$.fragment),Dr=n(),Sl=a("p"),Sl.textContent=Jc,Or=n(),r(Ql.$$.fragment),ed=n(),Fl=a("p"),Fl.innerHTML=bc,td=n(),r(El.$$.fragment),sd=n(),Pl=a("p"),Pl.textContent=Cc,ld=n(),r(Al.$$.fragment),nd=n(),Yl=a("p"),Yl.textContent=jc,id=n(),r(ql.$$.fragment),ad=n(),Kl=a("p"),Kl.innerHTML=vc,pd=n(),r(Dl.$$.fragment),od=n(),Ol=a("ul"),Ol.innerHTML=gc,rd=n(),r(en.$$.fragment),dd=n(),tn=a("ul"),tn.innerHTML=Uc,fd=n(),r(sn.$$.fragment),md=n(),ln=a("p"),ln.textContent=xc,ud=n(),r(nn.$$.fragment),cd=n(),an=a("p"),an.textContent=_c,wd=n(),r(pn.$$.fragment),hd=n(),on=a("p"),on.innerHTML=Ic,yd=n(),rn=a("p"),rn.textContent=kc,Md=n(),dn=a("p"),dn.textContent=Zc,Td=n(),r(fn.$$.fragment),$d=n(),mn=a("p"),mn.innerHTML=Hc,Jd=n(),r(un.$$.fragment),bd=n(),cn=a("p"),cn.innerHTML=Gc,Cd=n(),r(wn.$$.fragment),jd=n(),hn=a("p"),hn.textContent=Bc,vd=n(),yn=a("p"),yn.textContent=Xc,gd=n(),Mn=a("p"),Mn.textContent=Vc,Ud=n(),Tn=a("ul"),Tn.innerHTML=Rc,xd=n(),$n=a("p"),$n.innerHTML=Nc,_d=n(),r(Jn.$$.fragment),Id=n(),bn=a("p"),bn.innerHTML=zc,kd=n(),Cn=a("p"),Cn.innerHTML=Wc,Zd=n(),jn=a("p"),jn.textContent=Lc,Hd=n(),vn=a("p"),vn.textContent=Sc,Gd=n(),gn=a("p"),gn.innerHTML=Qc,Bd=n(),r(Un.$$.fragment),Xd=n(),xn=a("p"),xn.innerHTML=Fc,Vd=n(),r(_n.$$.fragment),Rd=n(),In=a("p"),In.innerHTML=Ec,Nd=n(),r(kn.$$.fragment),zd=n(),Zn=a("p"),Zn.innerHTML=Pc,Wd=n(),Hn=a("p"),Hn.innerHTML=Ac,Ld=n(),r(Gn.$$.fragment),Sd=n(),Bn=a("p"),Bn.textContent=Yc,Qd=n(),r(Xn.$$.fragment),Fd=n(),Vn=a("p"),Vn.innerHTML=qc,Ed=n(),r(Rn.$$.fragment),Pd=n(),Nn=a("p"),Nn.innerHTML=Kc,Ad=n(),r(zn.$$.fragment),Yd=n(),Wn=a("p"),Wn.textContent=Dc,qd=n(),Ln=a("p"),Ln.textContent=Oc,Kd=n(),Sn=a("p"),Sn.innerHTML=ew,Dd=n(),r(Qn.$$.fragment),Od=n(),Fn=a("p"),Fn.textContent=tw,ef=n(),En=a("p"),En.innerHTML=sw,tf=n(),r(Pn.$$.fragment),sf=n(),An=a("p"),An.innerHTML=lw,lf=n(),r(Yn.$$.fragment),nf=n(),qn=a("p"),qn.innerHTML=nw,af=n(),Kn=a("p"),Kn.innerHTML=iw,pf=n(),Dn=a("p"),Dn.textContent=aw,of=n(),On=a("p"),On.textContent=pw,rf=n(),r(ei.$$.fragment),df=n(),ti=a("p"),ti.textContent=ow,ff=n(),si=a("p"),si.textContent=rw,mf=n(),r(li.$$.fragment),uf=n(),ni=a("p"),ni.textContent=dw,cf=n(),ii=a("p"),ii.textContent=fw,wf=n(),ai=a("ol"),ai.innerHTML=mw,hf=n(),pi=a("p"),pi.textContent=uw,yf=n(),oi=a("p"),oi.textContent=cw,Mf=n(),ri=a("ol"),ri.innerHTML=ww,Tf=n(),di=a("p"),di.textContent=hw,$f=n(),fi=a("p"),fi.textContent=yw,Jf=n(),mi=a("p"),mi.textContent=Mw,bf=n(),ui=a("p"),ui.textContent=Tw,Cf=n(),ci=a("ol"),ci.innerHTML=$w,jf=n(),wi=a("p"),wi.textContent=Jw,vf=n(),r(hi.$$.fragment),gf=n(),yi=a("p"),yi.textContent=bw,Uf=n(),r(Mi.$$.fragment),xf=n(),Ti=a("p"),Ti.innerHTML=Cw,_f=n(),$i=a("p"),$i.innerHTML=jw,If=n(),Ji=a("p"),Ji.textContent=vw,kf=n(),bi=a("ul"),bi.innerHTML=gw,Zf=n(),Ci=a("p"),Ci.textContent=Uw,Hf=n(),ji=a("p"),ji.textContent=xw,Gf=n(),vi=a("p"),vi.textContent=_w,Bf=n(),r(gi.$$.fragment),Xf=n(),Ui=a("p"),Ui.textContent=Iw,Vf=n(),r(xi.$$.fragment),Rf=n(),r(_i.$$.fragment),Nf=n(),Ii=a("p"),this.h()},l(e){const t=Ww("svelte-u9bgzb",document.head);h=p(t,"META",{name:!0,content:!0}),t.forEach(s),T=i(e),y=p(e,"P",{}),Bw(y).forEach(s),$=i(e),d(g.$$.fragment,e),ki=i(e),U=p(e,"P",{"data-svelte-h":!0}),o(U)!=="svelte-1bfeznz"&&(U.textContent=Sf),Zi=i(e),x=p(e,"P",{"data-svelte-h":!0}),o(x)!=="svelte-1468g91"&&(x.textContent=Qf),Hi=i(e),_=p(e,"OL",{"data-svelte-h":!0}),o(_)!=="svelte-u97aul"&&(_.innerHTML=Ff),Gi=i(e),d(I.$$.fragment,e),Bi=i(e),k=p(e,"OL",{"data-svelte-h":!0}),o(k)!=="svelte-1xjbri2"&&(k.innerHTML=Ef),Xi=i(e),d(Z.$$.fragment,e),Vi=i(e),H=p(e,"P",{"data-svelte-h":!0}),o(H)!=="svelte-labrlq"&&(H.innerHTML=Pf),Ri=i(e),d(G.$$.fragment,e),Ni=i(e),d(B.$$.fragment,e),zi=i(e),X=p(e,"P",{"data-svelte-h":!0}),o(X)!=="svelte-iw7kd9"&&(X.innerHTML=Af),Wi=i(e),V=p(e,"P",{"data-svelte-h":!0}),o(V)!=="svelte-19u85g2"&&(V.textContent=Yf),Li=i(e),R=p(e,"P",{"data-svelte-h":!0}),o(R)!=="svelte-1cr0co4"&&(R.textContent=qf),Si=i(e),d(N.$$.fragment,e),Qi=i(e),z=p(e,"P",{"data-svelte-h":!0}),o(z)!=="svelte-ylttvt"&&(z.textContent=Kf),Fi=i(e),d(W.$$.fragment,e),Ei=i(e),L=p(e,"P",{"data-svelte-h":!0}),o(L)!=="svelte-1y7ruil"&&(L.textContent=Df),Pi=i(e),d(S.$$.fragment,e),Ai=i(e),Q=p(e,"P",{"data-svelte-h":!0}),o(Q)!=="svelte-w4pavv"&&(Q.textContent=Of),Yi=i(e),F=p(e,"UL",{"data-svelte-h":!0}),o(F)!=="svelte-1if6plt"&&(F.innerHTML=em),qi=i(e),d(E.$$.fragment,e),Ki=i(e),P=p(e,"P",{"data-svelte-h":!0}),o(P)!=="svelte-1lo9z46"&&(P.textContent=tm),Di=i(e),d(A.$$.fragment,e),Oi=i(e),Y=p(e,"P",{"data-svelte-h":!0}),o(Y)!=="svelte-1d4pkjf"&&(Y.textContent=sm),ea=i(e),d(q.$$.fragment,e),ta=i(e),d(K.$$.fragment,e),sa=i(e),D=p(e,"P",{"data-svelte-h":!0}),o(D)!=="svelte-5hfpb0"&&(D.textContent=lm),la=i(e),d(O.$$.fragment,e),na=i(e),d(ee.$$.fragment,e),ia=i(e),te=p(e,"P",{"data-svelte-h":!0}),o(te)!=="svelte-c0whf"&&(te.textContent=nm),aa=i(e),d(se.$$.fragment,e),pa=i(e),le=p(e,"P",{"data-svelte-h":!0}),o(le)!=="svelte-epkwoc"&&(le.textContent=im),oa=i(e),ne=p(e,"UL",{"data-svelte-h":!0}),o(ne)!=="svelte-danjdv"&&(ne.innerHTML=am),ra=i(e),ie=p(e,"P",{"data-svelte-h":!0}),o(ie)!=="svelte-1gfp00k"&&(ie.textContent=pm),da=i(e),d(ae.$$.fragment,e),fa=i(e),pe=p(e,"P",{"data-svelte-h":!0}),o(pe)!=="svelte-1sjtmkd"&&(pe.textContent=om),ma=i(e),oe=p(e,"P",{"data-svelte-h":!0}),o(oe)!=="svelte-191iwzc"&&(oe.innerHTML=rm),ua=i(e),d(re.$$.fragment,e),ca=i(e),de=p(e,"P",{"data-svelte-h":!0}),o(de)!=="svelte-1xohq9w"&&(de.textContent=dm),wa=i(e),fe=p(e,"P",{"data-svelte-h":!0}),o(fe)!=="svelte-17y24cx"&&(fe.innerHTML=fm),ha=i(e),d(me.$$.fragment,e),ya=i(e),ue=p(e,"P",{"data-svelte-h":!0}),o(ue)!=="svelte-wm70a5"&&(ue.innerHTML=mm),Ma=i(e),ce=p(e,"P",{"data-svelte-h":!0}),o(ce)!=="svelte-1qcofvk"&&(ce.innerHTML=um),Ta=i(e),d(we.$$.fragment,e),$a=i(e),he=p(e,"P",{"data-svelte-h":!0}),o(he)!=="svelte-1v2kf44"&&(he.textContent=cm),Ja=i(e),d(ye.$$.fragment,e),ba=i(e),Me=p(e,"P",{"data-svelte-h":!0}),o(Me)!=="svelte-xpmdqr"&&(Me.innerHTML=wm),Ca=i(e),d(Te.$$.fragment,e),ja=i(e),$e=p(e,"P",{"data-svelte-h":!0}),o($e)!=="svelte-ya3osx"&&($e.innerHTML=hm),va=i(e),Je=p(e,"P",{"data-svelte-h":!0}),o(Je)!=="svelte-1t5el5c"&&(Je.innerHTML=ym),ga=i(e),d(be.$$.fragment,e),Ua=i(e),d(Ce.$$.fragment,e),xa=i(e),je=p(e,"P",{"data-svelte-h":!0}),o(je)!=="svelte-1h9dnrx"&&(je.innerHTML=Mm),_a=i(e),d(ve.$$.fragment,e),Ia=i(e),d(ge.$$.fragment,e),ka=i(e),Ue=p(e,"P",{"data-svelte-h":!0}),o(Ue)!=="svelte-1v7cinx"&&(Ue.innerHTML=Tm),Za=i(e),d(xe.$$.fragment,e),Ha=i(e),_e=p(e,"P",{"data-svelte-h":!0}),o(_e)!=="svelte-2y6u4r"&&(_e.textContent=$m),Ga=i(e),d(Ie.$$.fragment,e),Ba=i(e),ke=p(e,"P",{"data-svelte-h":!0}),o(ke)!=="svelte-179dx63"&&(ke.innerHTML=Jm),Xa=i(e),d(Ze.$$.fragment,e),Va=i(e),He=p(e,"P",{"data-svelte-h":!0}),o(He)!=="svelte-unvzuu"&&(He.innerHTML=bm),Ra=i(e),d(Ge.$$.fragment,e),Na=i(e),d(Be.$$.fragment,e),za=i(e),Xe=p(e,"P",{"data-svelte-h":!0}),o(Xe)!=="svelte-15u7bp5"&&(Xe.textContent=Cm),Wa=i(e),d(Ve.$$.fragment,e),La=i(e),Re=p(e,"P",{"data-svelte-h":!0}),o(Re)!=="svelte-vt8irn"&&(Re.innerHTML=jm),Sa=i(e),d(Ne.$$.fragment,e),Qa=i(e),ze=p(e,"P",{"data-svelte-h":!0}),o(ze)!=="svelte-6ajs78"&&(ze.innerHTML=vm),Fa=i(e),We=p(e,"P",{"data-svelte-h":!0}),o(We)!=="svelte-gj7k8m"&&(We.innerHTML=gm),Ea=i(e),d(Le.$$.fragment,e),Pa=i(e),Se=p(e,"P",{"data-svelte-h":!0}),o(Se)!=="svelte-159ynhd"&&(Se.innerHTML=Um),Aa=i(e),d(Qe.$$.fragment,e),Ya=i(e),Fe=p(e,"P",{"data-svelte-h":!0}),o(Fe)!=="svelte-1ee4njf"&&(Fe.textContent=xm),qa=i(e),Ee=p(e,"P",{"data-svelte-h":!0}),o(Ee)!=="svelte-1ax2n5m"&&(Ee.innerHTML=_m),Ka=i(e),d(Pe.$$.fragment,e),Da=i(e),Ae=p(e,"P",{"data-svelte-h":!0}),o(Ae)!=="svelte-avos7q"&&(Ae.innerHTML=Im),Oa=i(e),d(Ye.$$.fragment,e),ep=i(e),d(qe.$$.fragment,e),tp=i(e),Ke=p(e,"P",{"data-svelte-h":!0}),o(Ke)!=="svelte-stzunx"&&(Ke.textContent=km),sp=i(e),d(De.$$.fragment,e),lp=i(e),d(Oe.$$.fragment,e),np=i(e),et=p(e,"P",{"data-svelte-h":!0}),o(et)!=="svelte-1pmvtt0"&&(et.innerHTML=Zm),ip=i(e),tt=p(e,"P",{"data-svelte-h":!0}),o(tt)!=="svelte-1nsqbht"&&(tt.innerHTML=Hm),ap=i(e),st=p(e,"P",{"data-svelte-h":!0}),o(st)!=="svelte-1m3hksa"&&(st.innerHTML=Gm),pp=i(e),d(lt.$$.fragment,e),op=i(e),nt=p(e,"P",{"data-svelte-h":!0}),o(nt)!=="svelte-15ioki4"&&(nt.textContent=Bm),rp=i(e),d(it.$$.fragment,e),dp=i(e),at=p(e,"UL",{"data-svelte-h":!0}),o(at)!=="svelte-1mmgi4h"&&(at.innerHTML=Xm),fp=i(e),d(pt.$$.fragment,e),mp=i(e),ot=p(e,"P",{"data-svelte-h":!0}),o(ot)!=="svelte-18b9tpg"&&(ot.textContent=Vm),up=i(e),d(rt.$$.fragment,e),cp=i(e),d(b.$$.fragment,e),wp=i(e),d(C.$$.fragment,e),hp=i(e),d(dt.$$.fragment,e),yp=i(e),d(ft.$$.fragment,e),Mp=i(e),mt=p(e,"P",{"data-svelte-h":!0}),o(mt)!=="svelte-f8h5dv"&&(mt.innerHTML=Rm),Tp=i(e),ut=p(e,"P",{"data-svelte-h":!0}),o(ut)!=="svelte-7bnqvo"&&(ut.innerHTML=Nm),$p=i(e),d(ct.$$.fragment,e),Jp=i(e),wt=p(e,"P",{"data-svelte-h":!0}),o(wt)!=="svelte-fmmfnt"&&(wt.textContent=zm),bp=i(e),d(ht.$$.fragment,e),Cp=i(e),yt=p(e,"P",{"data-svelte-h":!0}),o(yt)!=="svelte-13ddfrq"&&(yt.innerHTML=Wm),jp=i(e),d(Mt.$$.fragment,e),vp=i(e),Tt=p(e,"P",{"data-svelte-h":!0}),o(Tt)!=="svelte-1wfinax"&&(Tt.textContent=Lm),gp=i(e),d($t.$$.fragment,e),Up=i(e),Jt=p(e,"P",{"data-svelte-h":!0}),o(Jt)!=="svelte-1ur3h1j"&&(Jt.innerHTML=Sm),xp=i(e),bt=p(e,"P",{"data-svelte-h":!0}),o(bt)!=="svelte-joumxu"&&(bt.innerHTML=Qm),_p=i(e),d(Ct.$$.fragment,e),Ip=i(e),d(jt.$$.fragment,e),kp=i(e),vt=p(e,"P",{"data-svelte-h":!0}),o(vt)!=="svelte-1l9hk1w"&&(vt.innerHTML=Fm),Zp=i(e),d(gt.$$.fragment,e),Hp=i(e),Ut=p(e,"P",{"data-svelte-h":!0}),o(Ut)!=="svelte-imfw4r"&&(Ut.textContent=Em),Gp=i(e),d(xt.$$.fragment,e),Bp=i(e),_t=p(e,"P",{"data-svelte-h":!0}),o(_t)!=="svelte-14pjrdm"&&(_t.textContent=Pm),Xp=i(e),d(It.$$.fragment,e),Vp=i(e),kt=p(e,"P",{"data-svelte-h":!0}),o(kt)!=="svelte-umw6ao"&&(kt.innerHTML=Am),Rp=i(e),d(Zt.$$.fragment,e),Np=i(e),d(Ht.$$.fragment,e),zp=i(e),Gt=p(e,"P",{"data-svelte-h":!0}),o(Gt)!=="svelte-1yhn8j7"&&(Gt.innerHTML=Ym),Wp=i(e),d(Bt.$$.fragment,e),Lp=i(e),d(Xt.$$.fragment,e),Sp=i(e),d(Vt.$$.fragment,e),Qp=i(e),Rt=p(e,"P",{"data-svelte-h":!0}),o(Rt)!=="svelte-1rob2zs"&&(Rt.innerHTML=qm),Fp=i(e),d(Nt.$$.fragment,e),Ep=i(e),zt=p(e,"P",{"data-svelte-h":!0}),o(zt)!=="svelte-1udju7w"&&(zt.innerHTML=Km),Pp=i(e),d(Wt.$$.fragment,e),Ap=i(e),Lt=p(e,"P",{"data-svelte-h":!0}),o(Lt)!=="svelte-1ws7l6h"&&(Lt.textContent=Dm),Yp=i(e),St=p(e,"P",{"data-svelte-h":!0}),o(St)!=="svelte-9ls328"&&(St.textContent=Om),qp=i(e),Qt=p(e,"UL",{"data-svelte-h":!0}),o(Qt)!=="svelte-1y3o981"&&(Qt.innerHTML=eu),Kp=i(e),Ft=p(e,"P",{"data-svelte-h":!0}),o(Ft)!=="svelte-utz14"&&(Ft.textContent=tu),Dp=i(e),Et=p(e,"TABLE",{"data-svelte-h":!0}),o(Et)!=="svelte-anw2cl"&&(Et.innerHTML=su),Op=i(e),Pt=p(e,"P",{"data-svelte-h":!0}),o(Pt)!=="svelte-f7k590"&&(Pt.textContent=lu),eo=i(e),d(At.$$.fragment,e),to=i(e),Yt=p(e,"P",{"data-svelte-h":!0}),o(Yt)!=="svelte-1h8vitx"&&(Yt.innerHTML=nu),so=i(e),d(qt.$$.fragment,e),lo=i(e),Kt=p(e,"P",{"data-svelte-h":!0}),o(Kt)!=="svelte-ffnm4q"&&(Kt.textContent=iu),no=i(e),d(Dt.$$.fragment,e),io=i(e),Ot=p(e,"P",{"data-svelte-h":!0}),o(Ot)!=="svelte-353xix"&&(Ot.innerHTML=au),ao=i(e),d(es.$$.fragment,e),po=i(e),ts=p(e,"P",{"data-svelte-h":!0}),o(ts)!=="svelte-v3nbmf"&&(ts.innerHTML=pu),oo=i(e),ss=p(e,"P",{"data-svelte-h":!0}),o(ss)!=="svelte-u2pw3h"&&(ss.textContent=ou),ro=i(e),ls=p(e,"UL",{"data-svelte-h":!0}),o(ls)!=="svelte-3jen5c"&&(ls.innerHTML=ru),fo=i(e),d(ns.$$.fragment,e),mo=i(e),d(is.$$.fragment,e),uo=i(e),as=p(e,"P",{"data-svelte-h":!0}),o(as)!=="svelte-db62h"&&(as.innerHTML=du),co=i(e),d(ps.$$.fragment,e),wo=i(e),os=p(e,"P",{"data-svelte-h":!0}),o(os)!=="svelte-d9enng"&&(os.innerHTML=fu),ho=i(e),rs=p(e,"P",{"data-svelte-h":!0}),o(rs)!=="svelte-178tu9q"&&(rs.innerHTML=mu),yo=i(e),d(ds.$$.fragment,e),Mo=i(e),fs=p(e,"P",{"data-svelte-h":!0}),o(fs)!=="svelte-xiji8b"&&(fs.innerHTML=uu),To=i(e),d(ms.$$.fragment,e),$o=i(e),us=p(e,"P",{"data-svelte-h":!0}),o(us)!=="svelte-9y3zhl"&&(us.innerHTML=cu),Jo=i(e),cs=p(e,"P",{"data-svelte-h":!0}),o(cs)!=="svelte-l1wddx"&&(cs.innerHTML=wu),bo=i(e),ws=p(e,"P",{"data-svelte-h":!0}),o(ws)!=="svelte-bnz0cy"&&(ws.textContent=hu),Co=i(e),hs=p(e,"P",{"data-svelte-h":!0}),o(hs)!=="svelte-12mggyp"&&(hs.innerHTML=yu),jo=i(e),ys=p(e,"P",{"data-svelte-h":!0}),o(ys)!=="svelte-4caaxc"&&(ys.textContent=Mu),vo=i(e),Ms=p(e,"UL",{"data-svelte-h":!0}),o(Ms)!=="svelte-m5pydi"&&(Ms.innerHTML=Tu),go=i(e),Ts=p(e,"P",{"data-svelte-h":!0}),o(Ts)!=="svelte-qqwmn6"&&(Ts.innerHTML=$u),Uo=i(e),$s=p(e,"P",{"data-svelte-h":!0}),o($s)!=="svelte-qc147d"&&($s.textContent=Ju),xo=i(e),d(Js.$$.fragment,e),_o=i(e),bs=p(e,"P",{"data-svelte-h":!0}),o(bs)!=="svelte-16l1xew"&&(bs.textContent=bu),Io=i(e),Cs=p(e,"P",{"data-svelte-h":!0}),o(Cs)!=="svelte-1bsvp4y"&&(Cs.innerHTML=Cu),ko=i(e),js=p(e,"P",{"data-svelte-h":!0}),o(js)!=="svelte-1gq9tao"&&(js.innerHTML=ju),Zo=i(e),d(vs.$$.fragment,e),Ho=i(e),gs=p(e,"P",{"data-svelte-h":!0}),o(gs)!=="svelte-euahrc"&&(gs.textContent=vu),Go=i(e),d(Us.$$.fragment,e),Bo=i(e),xs=p(e,"P",{"data-svelte-h":!0}),o(xs)!=="svelte-1he1ruf"&&(xs.textContent=gu),Xo=i(e),_s=p(e,"P",{"data-svelte-h":!0}),o(_s)!=="svelte-dng90j"&&(_s.textContent=Uu),Vo=i(e),d(Is.$$.fragment,e),Ro=i(e),ks=p(e,"P",{"data-svelte-h":!0}),o(ks)!=="svelte-3xzrf8"&&(ks.textContent=xu),No=i(e),Zs=p(e,"P",{"data-svelte-h":!0}),o(Zs)!=="svelte-1w4eg93"&&(Zs.textContent=_u),zo=i(e),d(Hs.$$.fragment,e),Wo=i(e),Gs=p(e,"P",{"data-svelte-h":!0}),o(Gs)!=="svelte-weqhq8"&&(Gs.textContent=Iu),Lo=i(e),Bs=p(e,"P",{"data-svelte-h":!0}),o(Bs)!=="svelte-bpmeeu"&&(Bs.textContent=ku),So=i(e),d(Xs.$$.fragment,e),Qo=i(e),Vs=p(e,"P",{"data-svelte-h":!0}),o(Vs)!=="svelte-1xxcasd"&&(Vs.textContent=Zu),Fo=i(e),Rs=p(e,"P",{"data-svelte-h":!0}),o(Rs)!=="svelte-eorfz6"&&(Rs.innerHTML=Hu),Eo=i(e),Ns=p(e,"P",{"data-svelte-h":!0}),o(Ns)!=="svelte-1ygwz5h"&&(Ns.innerHTML=Gu),Po=i(e),zs=p(e,"P",{"data-svelte-h":!0}),o(zs)!=="svelte-1hpvz7r"&&(zs.textContent=Bu),Ao=i(e),Ws=p(e,"P",{"data-svelte-h":!0}),o(Ws)!=="svelte-snf8ke"&&(Ws.textContent=Xu),Yo=i(e),d(Ls.$$.fragment,e),qo=i(e),Ss=p(e,"P",{"data-svelte-h":!0}),o(Ss)!=="svelte-1737hyy"&&(Ss.innerHTML=Vu),Ko=i(e),Qs=p(e,"P",{"data-svelte-h":!0}),o(Qs)!=="svelte-1oufrw1"&&(Qs.innerHTML=Ru),Do=i(e),d(Fs.$$.fragment,e),Oo=i(e),Es=p(e,"P",{"data-svelte-h":!0}),o(Es)!=="svelte-1tl0nx7"&&(Es.innerHTML=Nu),er=i(e),d(Ps.$$.fragment,e),tr=i(e),As=p(e,"P",{"data-svelte-h":!0}),o(As)!=="svelte-19gvkao"&&(As.innerHTML=zu),sr=i(e),d(Ys.$$.fragment,e),lr=i(e),qs=p(e,"P",{"data-svelte-h":!0}),o(qs)!=="svelte-4rsktk"&&(qs.textContent=Wu),nr=i(e),d(Ks.$$.fragment,e),ir=i(e),Ds=p(e,"P",{"data-svelte-h":!0}),o(Ds)!=="svelte-6ynunq"&&(Ds.textContent=Lu),ar=i(e),d(Os.$$.fragment,e),pr=i(e),el=p(e,"P",{"data-svelte-h":!0}),o(el)!=="svelte-1pfiycl"&&(el.innerHTML=Su),or=i(e),tl=p(e,"P",{"data-svelte-h":!0}),o(tl)!=="svelte-1ygobi4"&&(tl.innerHTML=Qu),rr=i(e),sl=p(e,"P",{"data-svelte-h":!0}),o(sl)!=="svelte-qhi9ux"&&(sl.innerHTML=Fu),dr=i(e),d(ll.$$.fragment,e),fr=i(e),nl=p(e,"P",{"data-svelte-h":!0}),o(nl)!=="svelte-e797ol"&&(nl.innerHTML=Eu),mr=i(e),d(il.$$.fragment,e),ur=i(e),al=p(e,"P",{"data-svelte-h":!0}),o(al)!=="svelte-4rsktk"&&(al.textContent=Pu),cr=i(e),d(pl.$$.fragment,e),wr=i(e),ol=p(e,"P",{"data-svelte-h":!0}),o(ol)!=="svelte-1pp8dat"&&(ol.textContent=Au),hr=i(e),d(rl.$$.fragment,e),yr=i(e),dl=p(e,"P",{"data-svelte-h":!0}),o(dl)!=="svelte-wcwikf"&&(dl.textContent=Yu),Mr=i(e),fl=p(e,"P",{"data-svelte-h":!0}),o(fl)!=="svelte-137pcnc"&&(fl.textContent=qu),Tr=i(e),ml=p(e,"P",{"data-svelte-h":!0}),o(ml)!=="svelte-ggv3l3"&&(ml.innerHTML=Ku),$r=i(e),ul=p(e,"UL",{"data-svelte-h":!0}),o(ul)!=="svelte-jurlci"&&(ul.innerHTML=Du),Jr=i(e),cl=p(e,"P",{"data-svelte-h":!0}),o(cl)!=="svelte-91az3w"&&(cl.innerHTML=Ou),br=i(e),d(wl.$$.fragment,e),Cr=i(e),hl=p(e,"P",{"data-svelte-h":!0}),o(hl)!=="svelte-rjyeyp"&&(hl.innerHTML=ec),jr=i(e),d(yl.$$.fragment,e),vr=i(e),Ml=p(e,"P",{"data-svelte-h":!0}),o(Ml)!=="svelte-qiw9vv"&&(Ml.textContent=tc),gr=i(e),Tl=p(e,"P",{"data-svelte-h":!0}),o(Tl)!=="svelte-1vmbsy3"&&(Tl.innerHTML=sc),Ur=i(e),$l=p(e,"P",{"data-svelte-h":!0}),o($l)!=="svelte-1nqxzoj"&&($l.textContent=lc),xr=i(e),Jl=p(e,"P",{"data-svelte-h":!0}),o(Jl)!=="svelte-1lx14g9"&&(Jl.innerHTML=nc),_r=i(e),bl=p(e,"P",{"data-svelte-h":!0}),o(bl)!=="svelte-ga57nj"&&(bl.textContent=ic),Ir=i(e),d(Cl.$$.fragment,e),kr=i(e),jl=p(e,"P",{"data-svelte-h":!0}),o(jl)!=="svelte-1flfm4w"&&(jl.innerHTML=ac),Zr=i(e),vl=p(e,"UL",{"data-svelte-h":!0}),o(vl)!=="svelte-1rvelqv"&&(vl.innerHTML=pc),Hr=i(e),d(gl.$$.fragment,e),Gr=i(e),Ul=p(e,"P",{"data-svelte-h":!0}),o(Ul)!=="svelte-1vcgtp4"&&(Ul.innerHTML=oc),Br=i(e),xl=p(e,"UL",{"data-svelte-h":!0}),o(xl)!=="svelte-1v175v7"&&(xl.innerHTML=rc),Xr=i(e),d(_l.$$.fragment,e),Vr=i(e),Il=p(e,"P",{"data-svelte-h":!0}),o(Il)!=="svelte-pk8usg"&&(Il.textContent=dc),Rr=i(e),kl=p(e,"UL",{"data-svelte-h":!0}),o(kl)!=="svelte-17enf76"&&(kl.innerHTML=fc),Nr=i(e),d(j.$$.fragment,e),zr=i(e),d(v.$$.fragment,e),Wr=i(e),Zl=p(e,"P",{"data-svelte-h":!0}),o(Zl)!=="svelte-pyrqv8"&&(Zl.textContent=mc),Lr=i(e),Hl=p(e,"P",{"data-svelte-h":!0}),o(Hl)!=="svelte-1blmp1h"&&(Hl.innerHTML=uc),Sr=i(e),d(Gl.$$.fragment,e),Qr=i(e),Bl=p(e,"P",{"data-svelte-h":!0}),o(Bl)!=="svelte-jgjzej"&&(Bl.textContent=cc),Fr=i(e),Xl=p(e,"P",{"data-svelte-h":!0}),o(Xl)!=="svelte-dlsjg1"&&(Xl.innerHTML=wc),Er=i(e),Vl=p(e,"P",{"data-svelte-h":!0}),o(Vl)!=="svelte-14pqgk8"&&(Vl.textContent=hc),Pr=i(e),Rl=p(e,"UL",{"data-svelte-h":!0}),o(Rl)!=="svelte-y68pnm"&&(Rl.innerHTML=yc),Ar=i(e),Nl=p(e,"P",{"data-svelte-h":!0}),o(Nl)!=="svelte-1c4q1t0"&&(Nl.innerHTML=Mc),Yr=i(e),zl=p(e,"P",{"data-svelte-h":!0}),o(zl)!=="svelte-11v40xi"&&(zl.textContent=Tc),qr=i(e),Wl=p(e,"UL",{"data-svelte-h":!0}),o(Wl)!=="svelte-1hhtdwa"&&(Wl.innerHTML=$c),Kr=i(e),d(Ll.$$.fragment,e),Dr=i(e),Sl=p(e,"P",{"data-svelte-h":!0}),o(Sl)!=="svelte-15p8ism"&&(Sl.textContent=Jc),Or=i(e),d(Ql.$$.fragment,e),ed=i(e),Fl=p(e,"P",{"data-svelte-h":!0}),o(Fl)!=="svelte-td5r6o"&&(Fl.innerHTML=bc),td=i(e),d(El.$$.fragment,e),sd=i(e),Pl=p(e,"P",{"data-svelte-h":!0}),o(Pl)!=="svelte-11quoxt"&&(Pl.textContent=Cc),ld=i(e),d(Al.$$.fragment,e),nd=i(e),Yl=p(e,"P",{"data-svelte-h":!0}),o(Yl)!=="svelte-1hcnf1h"&&(Yl.textContent=jc),id=i(e),d(ql.$$.fragment,e),ad=i(e),Kl=p(e,"P",{"data-svelte-h":!0}),o(Kl)!=="svelte-td5r6o"&&(Kl.innerHTML=vc),pd=i(e),d(Dl.$$.fragment,e),od=i(e),Ol=p(e,"UL",{"data-svelte-h":!0}),o(Ol)!=="svelte-15o6zb5"&&(Ol.innerHTML=gc),rd=i(e),d(en.$$.fragment,e),dd=i(e),tn=p(e,"UL",{"data-svelte-h":!0}),o(tn)!=="svelte-e2w3rp"&&(tn.innerHTML=Uc),fd=i(e),d(sn.$$.fragment,e),md=i(e),ln=p(e,"P",{"data-svelte-h":!0}),o(ln)!=="svelte-ylttvt"&&(ln.textContent=xc),ud=i(e),d(nn.$$.fragment,e),cd=i(e),an=p(e,"P",{"data-svelte-h":!0}),o(an)!=="svelte-1uqdrdi"&&(an.textContent=_c),wd=i(e),d(pn.$$.fragment,e),hd=i(e),on=p(e,"P",{"data-svelte-h":!0}),o(on)!=="svelte-mlyx41"&&(on.innerHTML=Ic),yd=i(e),rn=p(e,"P",{"data-svelte-h":!0}),o(rn)!=="svelte-xe0gmh"&&(rn.textContent=kc),Md=i(e),dn=p(e,"P",{"data-svelte-h":!0}),o(dn)!=="svelte-1hy2jf0"&&(dn.textContent=Zc),Td=i(e),d(fn.$$.fragment,e),$d=i(e),mn=p(e,"P",{"data-svelte-h":!0}),o(mn)!=="svelte-1szno4g"&&(mn.innerHTML=Hc),Jd=i(e),d(un.$$.fragment,e),bd=i(e),cn=p(e,"P",{"data-svelte-h":!0}),o(cn)!=="svelte-1apnezy"&&(cn.innerHTML=Gc),Cd=i(e),d(wn.$$.fragment,e),jd=i(e),hn=p(e,"P",{"data-svelte-h":!0}),o(hn)!=="svelte-rf3maz"&&(hn.textContent=Bc),vd=i(e),yn=p(e,"P",{"data-svelte-h":!0}),o(yn)!=="svelte-1tipejs"&&(yn.textContent=Xc),gd=i(e),Mn=p(e,"P",{"data-svelte-h":!0}),o(Mn)!=="svelte-7rit7z"&&(Mn.textContent=Vc),Ud=i(e),Tn=p(e,"UL",{"data-svelte-h":!0}),o(Tn)!=="svelte-1kul420"&&(Tn.innerHTML=Rc),xd=i(e),$n=p(e,"P",{"data-svelte-h":!0}),o($n)!=="svelte-zoj47i"&&($n.innerHTML=Nc),_d=i(e),d(Jn.$$.fragment,e),Id=i(e),bn=p(e,"P",{"data-svelte-h":!0}),o(bn)!=="svelte-ubpbuc"&&(bn.innerHTML=zc),kd=i(e),Cn=p(e,"P",{"data-svelte-h":!0}),o(Cn)!=="svelte-94izzk"&&(Cn.innerHTML=Wc),Zd=i(e),jn=p(e,"P",{"data-svelte-h":!0}),o(jn)!=="svelte-14cphpq"&&(jn.textContent=Lc),Hd=i(e),vn=p(e,"P",{"data-svelte-h":!0}),o(vn)!=="svelte-10brhcd"&&(vn.textContent=Sc),Gd=i(e),gn=p(e,"P",{"data-svelte-h":!0}),o(gn)!=="svelte-lkbhi"&&(gn.innerHTML=Qc),Bd=i(e),d(Un.$$.fragment,e),Xd=i(e),xn=p(e,"P",{"data-svelte-h":!0}),o(xn)!=="svelte-y7erom"&&(xn.innerHTML=Fc),Vd=i(e),d(_n.$$.fragment,e),Rd=i(e),In=p(e,"P",{"data-svelte-h":!0}),o(In)!=="svelte-1hn7f4z"&&(In.innerHTML=Ec),Nd=i(e),d(kn.$$.fragment,e),zd=i(e),Zn=p(e,"P",{"data-svelte-h":!0}),o(Zn)!=="svelte-1apzdyq"&&(Zn.innerHTML=Pc),Wd=i(e),Hn=p(e,"P",{"data-svelte-h":!0}),o(Hn)!=="svelte-1uzq8t5"&&(Hn.innerHTML=Ac),Ld=i(e),d(Gn.$$.fragment,e),Sd=i(e),Bn=p(e,"P",{"data-svelte-h":!0}),o(Bn)!=="svelte-zun07a"&&(Bn.textContent=Yc),Qd=i(e),d(Xn.$$.fragment,e),Fd=i(e),Vn=p(e,"P",{"data-svelte-h":!0}),o(Vn)!=="svelte-ovlbpn"&&(Vn.innerHTML=qc),Ed=i(e),d(Rn.$$.fragment,e),Pd=i(e),Nn=p(e,"P",{"data-svelte-h":!0}),o(Nn)!=="svelte-1tcp04v"&&(Nn.innerHTML=Kc),Ad=i(e),d(zn.$$.fragment,e),Yd=i(e),Wn=p(e,"P",{"data-svelte-h":!0}),o(Wn)!=="svelte-9q1cwt"&&(Wn.textContent=Dc),qd=i(e),Ln=p(e,"P",{"data-svelte-h":!0}),o(Ln)!=="svelte-1apeang"&&(Ln.textContent=Oc),Kd=i(e),Sn=p(e,"P",{"data-svelte-h":!0}),o(Sn)!=="svelte-vnemvg"&&(Sn.innerHTML=ew),Dd=i(e),d(Qn.$$.fragment,e),Od=i(e),Fn=p(e,"P",{"data-svelte-h":!0}),o(Fn)!=="svelte-a840wh"&&(Fn.textContent=tw),ef=i(e),En=p(e,"P",{"data-svelte-h":!0}),o(En)!=="svelte-kw5cnh"&&(En.innerHTML=sw),tf=i(e),d(Pn.$$.fragment,e),sf=i(e),An=p(e,"P",{"data-svelte-h":!0}),o(An)!=="svelte-147mt1i"&&(An.innerHTML=lw),lf=i(e),d(Yn.$$.fragment,e),nf=i(e),qn=p(e,"P",{"data-svelte-h":!0}),o(qn)!=="svelte-1ppwycl"&&(qn.innerHTML=nw),af=i(e),Kn=p(e,"P",{"data-svelte-h":!0}),o(Kn)!=="svelte-1wla2hx"&&(Kn.innerHTML=iw),pf=i(e),Dn=p(e,"P",{"data-svelte-h":!0}),o(Dn)!=="svelte-ac2p83"&&(Dn.textContent=aw),of=i(e),On=p(e,"P",{"data-svelte-h":!0}),o(On)!=="svelte-85vvld"&&(On.textContent=pw),rf=i(e),d(ei.$$.fragment,e),df=i(e),ti=p(e,"P",{"data-svelte-h":!0}),o(ti)!=="svelte-1bdxwdk"&&(ti.textContent=ow),ff=i(e),si=p(e,"P",{"data-svelte-h":!0}),o(si)!=="svelte-10j78ug"&&(si.textContent=rw),mf=i(e),d(li.$$.fragment,e),uf=i(e),ni=p(e,"P",{"data-svelte-h":!0}),o(ni)!=="svelte-59tyud"&&(ni.textContent=dw),cf=i(e),ii=p(e,"P",{"data-svelte-h":!0}),o(ii)!=="svelte-1i5zdaf"&&(ii.textContent=fw),wf=i(e),ai=p(e,"OL",{"data-svelte-h":!0}),o(ai)!=="svelte-16qtrad"&&(ai.innerHTML=mw),hf=i(e),pi=p(e,"P",{"data-svelte-h":!0}),o(pi)!=="svelte-1mawq0n"&&(pi.textContent=uw),yf=i(e),oi=p(e,"P",{"data-svelte-h":!0}),o(oi)!=="svelte-bmnf8q"&&(oi.textContent=cw),Mf=i(e),ri=p(e,"OL",{"data-svelte-h":!0}),o(ri)!=="svelte-gem8u9"&&(ri.innerHTML=ww),Tf=i(e),di=p(e,"P",{"data-svelte-h":!0}),o(di)!=="svelte-gr2fu5"&&(di.textContent=hw),$f=i(e),fi=p(e,"P",{"data-svelte-h":!0}),o(fi)!=="svelte-1wcop4v"&&(fi.textContent=yw),Jf=i(e),mi=p(e,"P",{"data-svelte-h":!0}),o(mi)!=="svelte-45u4zb"&&(mi.textContent=Mw),bf=i(e),ui=p(e,"P",{"data-svelte-h":!0}),o(ui)!=="svelte-puvloo"&&(ui.textContent=Tw),Cf=i(e),ci=p(e,"OL",{"data-svelte-h":!0}),o(ci)!=="svelte-8lbm08"&&(ci.innerHTML=$w),jf=i(e),wi=p(e,"P",{"data-svelte-h":!0}),o(wi)!=="svelte-1240csr"&&(wi.textContent=Jw),vf=i(e),d(hi.$$.fragment,e),gf=i(e),yi=p(e,"P",{"data-svelte-h":!0}),o(yi)!=="svelte-7dixon"&&(yi.textContent=bw),Uf=i(e),d(Mi.$$.fragment,e),xf=i(e),Ti=p(e,"P",{"data-svelte-h":!0}),o(Ti)!=="svelte-hcmust"&&(Ti.innerHTML=Cw),_f=i(e),$i=p(e,"P",{"data-svelte-h":!0}),o($i)!=="svelte-61pj3v"&&($i.innerHTML=jw),If=i(e),Ji=p(e,"P",{"data-svelte-h":!0}),o(Ji)!=="svelte-ty6adq"&&(Ji.textContent=vw),kf=i(e),bi=p(e,"UL",{"data-svelte-h":!0}),o(bi)!=="svelte-ikwit4"&&(bi.innerHTML=gw),Zf=i(e),Ci=p(e,"P",{"data-svelte-h":!0}),o(Ci)!=="svelte-1xmlzcb"&&(Ci.textContent=Uw),Hf=i(e),ji=p(e,"P",{"data-svelte-h":!0}),o(ji)!=="svelte-dysj7y"&&(ji.textContent=xw),Gf=i(e),vi=p(e,"P",{"data-svelte-h":!0}),o(vi)!=="svelte-i82w3a"&&(vi.textContent=_w),Bf=i(e),d(gi.$$.fragment,e),Xf=i(e),Ui=p(e,"P",{"data-svelte-h":!0}),o(Ui)!=="svelte-1awjoc2"&&(Ui.textContent=Iw),Vf=i(e),d(xi.$$.fragment,e),Rf=i(e),d(_i.$$.fragment,e),Nf=i(e),Ii=p(e,"P",{}),Bw(Ii).forEach(s),this.h()},h(){Xw(h,"name","hf:doc:metadata"),Xw(h,"content",Yw)},m(e,t){Lw(document.head,h),l(e,T,t),l(e,y,t),l(e,$,t),f(g,e,t),l(e,ki,t),l(e,U,t),l(e,Zi,t),l(e,x,t),l(e,Hi,t),l(e,_,t),l(e,Gi,t),f(I,e,t),l(e,Bi,t),l(e,k,t),l(e,Xi,t),f(Z,e,t),l(e,Vi,t),l(e,H,t),l(e,Ri,t),f(G,e,t),l(e,Ni,t),f(B,e,t),l(e,zi,t),l(e,X,t),l(e,Wi,t),l(e,V,t),l(e,Li,t),l(e,R,t),l(e,Si,t),f(N,e,t),l(e,Qi,t),l(e,z,t),l(e,Fi,t),f(W,e,t),l(e,Ei,t),l(e,L,t),l(e,Pi,t),f(S,e,t),l(e,Ai,t),l(e,Q,t),l(e,Yi,t),l(e,F,t),l(e,qi,t),f(E,e,t),l(e,Ki,t),l(e,P,t),l(e,Di,t),f(A,e,t),l(e,Oi,t),l(e,Y,t),l(e,ea,t),f(q,e,t),l(e,ta,t),f(K,e,t),l(e,sa,t),l(e,D,t),l(e,la,t),f(O,e,t),l(e,na,t),f(ee,e,t),l(e,ia,t),l(e,te,t),l(e,aa,t),f(se,e,t),l(e,pa,t),l(e,le,t),l(e,oa,t),l(e,ne,t),l(e,ra,t),l(e,ie,t),l(e,da,t),f(ae,e,t),l(e,fa,t),l(e,pe,t),l(e,ma,t),l(e,oe,t),l(e,ua,t),f(re,e,t),l(e,ca,t),l(e,de,t),l(e,wa,t),l(e,fe,t),l(e,ha,t),f(me,e,t),l(e,ya,t),l(e,ue,t),l(e,Ma,t),l(e,ce,t),l(e,Ta,t),f(we,e,t),l(e,$a,t),l(e,he,t),l(e,Ja,t),f(ye,e,t),l(e,ba,t),l(e,Me,t),l(e,Ca,t),f(Te,e,t),l(e,ja,t),l(e,$e,t),l(e,va,t),l(e,Je,t),l(e,ga,t),f(be,e,t),l(e,Ua,t),f(Ce,e,t),l(e,xa,t),l(e,je,t),l(e,_a,t),f(ve,e,t),l(e,Ia,t),f(ge,e,t),l(e,ka,t),l(e,Ue,t),l(e,Za,t),f(xe,e,t),l(e,Ha,t),l(e,_e,t),l(e,Ga,t),f(Ie,e,t),l(e,Ba,t),l(e,ke,t),l(e,Xa,t),f(Ze,e,t),l(e,Va,t),l(e,He,t),l(e,Ra,t),f(Ge,e,t),l(e,Na,t),f(Be,e,t),l(e,za,t),l(e,Xe,t),l(e,Wa,t),f(Ve,e,t),l(e,La,t),l(e,Re,t),l(e,Sa,t),f(Ne,e,t),l(e,Qa,t),l(e,ze,t),l(e,Fa,t),l(e,We,t),l(e,Ea,t),f(Le,e,t),l(e,Pa,t),l(e,Se,t),l(e,Aa,t),f(Qe,e,t),l(e,Ya,t),l(e,Fe,t),l(e,qa,t),l(e,Ee,t),l(e,Ka,t),f(Pe,e,t),l(e,Da,t),l(e,Ae,t),l(e,Oa,t),f(Ye,e,t),l(e,ep,t),f(qe,e,t),l(e,tp,t),l(e,Ke,t),l(e,sp,t),f(De,e,t),l(e,lp,t),f(Oe,e,t),l(e,np,t),l(e,et,t),l(e,ip,t),l(e,tt,t),l(e,ap,t),l(e,st,t),l(e,pp,t),f(lt,e,t),l(e,op,t),l(e,nt,t),l(e,rp,t),f(it,e,t),l(e,dp,t),l(e,at,t),l(e,fp,t),f(pt,e,t),l(e,mp,t),l(e,ot,t),l(e,up,t),f(rt,e,t),l(e,cp,t),f(b,e,t),l(e,wp,t),f(C,e,t),l(e,hp,t),f(dt,e,t),l(e,yp,t),f(ft,e,t),l(e,Mp,t),l(e,mt,t),l(e,Tp,t),l(e,ut,t),l(e,$p,t),f(ct,e,t),l(e,Jp,t),l(e,wt,t),l(e,bp,t),f(ht,e,t),l(e,Cp,t),l(e,yt,t),l(e,jp,t),f(Mt,e,t),l(e,vp,t),l(e,Tt,t),l(e,gp,t),f($t,e,t),l(e,Up,t),l(e,Jt,t),l(e,xp,t),l(e,bt,t),l(e,_p,t),f(Ct,e,t),l(e,Ip,t),f(jt,e,t),l(e,kp,t),l(e,vt,t),l(e,Zp,t),f(gt,e,t),l(e,Hp,t),l(e,Ut,t),l(e,Gp,t),f(xt,e,t),l(e,Bp,t),l(e,_t,t),l(e,Xp,t),f(It,e,t),l(e,Vp,t),l(e,kt,t),l(e,Rp,t),f(Zt,e,t),l(e,Np,t),f(Ht,e,t),l(e,zp,t),l(e,Gt,t),l(e,Wp,t),f(Bt,e,t),l(e,Lp,t),f(Xt,e,t),l(e,Sp,t),f(Vt,e,t),l(e,Qp,t),l(e,Rt,t),l(e,Fp,t),f(Nt,e,t),l(e,Ep,t),l(e,zt,t),l(e,Pp,t),f(Wt,e,t),l(e,Ap,t),l(e,Lt,t),l(e,Yp,t),l(e,St,t),l(e,qp,t),l(e,Qt,t),l(e,Kp,t),l(e,Ft,t),l(e,Dp,t),l(e,Et,t),l(e,Op,t),l(e,Pt,t),l(e,eo,t),f(At,e,t),l(e,to,t),l(e,Yt,t),l(e,so,t),f(qt,e,t),l(e,lo,t),l(e,Kt,t),l(e,no,t),f(Dt,e,t),l(e,io,t),l(e,Ot,t),l(e,ao,t),f(es,e,t),l(e,po,t),l(e,ts,t),l(e,oo,t),l(e,ss,t),l(e,ro,t),l(e,ls,t),l(e,fo,t),f(ns,e,t),l(e,mo,t),f(is,e,t),l(e,uo,t),l(e,as,t),l(e,co,t),f(ps,e,t),l(e,wo,t),l(e,os,t),l(e,ho,t),l(e,rs,t),l(e,yo,t),f(ds,e,t),l(e,Mo,t),l(e,fs,t),l(e,To,t),f(ms,e,t),l(e,$o,t),l(e,us,t),l(e,Jo,t),l(e,cs,t),l(e,bo,t),l(e,ws,t),l(e,Co,t),l(e,hs,t),l(e,jo,t),l(e,ys,t),l(e,vo,t),l(e,Ms,t),l(e,go,t),l(e,Ts,t),l(e,Uo,t),l(e,$s,t),l(e,xo,t),f(Js,e,t),l(e,_o,t),l(e,bs,t),l(e,Io,t),l(e,Cs,t),l(e,ko,t),l(e,js,t),l(e,Zo,t),f(vs,e,t),l(e,Ho,t),l(e,gs,t),l(e,Go,t),f(Us,e,t),l(e,Bo,t),l(e,xs,t),l(e,Xo,t),l(e,_s,t),l(e,Vo,t),f(Is,e,t),l(e,Ro,t),l(e,ks,t),l(e,No,t),l(e,Zs,t),l(e,zo,t),f(Hs,e,t),l(e,Wo,t),l(e,Gs,t),l(e,Lo,t),l(e,Bs,t),l(e,So,t),f(Xs,e,t),l(e,Qo,t),l(e,Vs,t),l(e,Fo,t),l(e,Rs,t),l(e,Eo,t),l(e,Ns,t),l(e,Po,t),l(e,zs,t),l(e,Ao,t),l(e,Ws,t),l(e,Yo,t),f(Ls,e,t),l(e,qo,t),l(e,Ss,t),l(e,Ko,t),l(e,Qs,t),l(e,Do,t),f(Fs,e,t),l(e,Oo,t),l(e,Es,t),l(e,er,t),f(Ps,e,t),l(e,tr,t),l(e,As,t),l(e,sr,t),f(Ys,e,t),l(e,lr,t),l(e,qs,t),l(e,nr,t),f(Ks,e,t),l(e,ir,t),l(e,Ds,t),l(e,ar,t),f(Os,e,t),l(e,pr,t),l(e,el,t),l(e,or,t),l(e,tl,t),l(e,rr,t),l(e,sl,t),l(e,dr,t),f(ll,e,t),l(e,fr,t),l(e,nl,t),l(e,mr,t),f(il,e,t),l(e,ur,t),l(e,al,t),l(e,cr,t),f(pl,e,t),l(e,wr,t),l(e,ol,t),l(e,hr,t),f(rl,e,t),l(e,yr,t),l(e,dl,t),l(e,Mr,t),l(e,fl,t),l(e,Tr,t),l(e,ml,t),l(e,$r,t),l(e,ul,t),l(e,Jr,t),l(e,cl,t),l(e,br,t),f(wl,e,t),l(e,Cr,t),l(e,hl,t),l(e,jr,t),f(yl,e,t),l(e,vr,t),l(e,Ml,t),l(e,gr,t),l(e,Tl,t),l(e,Ur,t),l(e,$l,t),l(e,xr,t),l(e,Jl,t),l(e,_r,t),l(e,bl,t),l(e,Ir,t),f(Cl,e,t),l(e,kr,t),l(e,jl,t),l(e,Zr,t),l(e,vl,t),l(e,Hr,t),f(gl,e,t),l(e,Gr,t),l(e,Ul,t),l(e,Br,t),l(e,xl,t),l(e,Xr,t),f(_l,e,t),l(e,Vr,t),l(e,Il,t),l(e,Rr,t),l(e,kl,t),l(e,Nr,t),f(j,e,t),l(e,zr,t),f(v,e,t),l(e,Wr,t),l(e,Zl,t),l(e,Lr,t),l(e,Hl,t),l(e,Sr,t),f(Gl,e,t),l(e,Qr,t),l(e,Bl,t),l(e,Fr,t),l(e,Xl,t),l(e,Er,t),l(e,Vl,t),l(e,Pr,t),l(e,Rl,t),l(e,Ar,t),l(e,Nl,t),l(e,Yr,t),l(e,zl,t),l(e,qr,t),l(e,Wl,t),l(e,Kr,t),f(Ll,e,t),l(e,Dr,t),l(e,Sl,t),l(e,Or,t),f(Ql,e,t),l(e,ed,t),l(e,Fl,t),l(e,td,t),f(El,e,t),l(e,sd,t),l(e,Pl,t),l(e,ld,t),f(Al,e,t),l(e,nd,t),l(e,Yl,t),l(e,id,t),f(ql,e,t),l(e,ad,t),l(e,Kl,t),l(e,pd,t),f(Dl,e,t),l(e,od,t),l(e,Ol,t),l(e,rd,t),f(en,e,t),l(e,dd,t),l(e,tn,t),l(e,fd,t),f(sn,e,t),l(e,md,t),l(e,ln,t),l(e,ud,t),f(nn,e,t),l(e,cd,t),l(e,an,t),l(e,wd,t),f(pn,e,t),l(e,hd,t),l(e,on,t),l(e,yd,t),l(e,rn,t),l(e,Md,t),l(e,dn,t),l(e,Td,t),f(fn,e,t),l(e,$d,t),l(e,mn,t),l(e,Jd,t),f(un,e,t),l(e,bd,t),l(e,cn,t),l(e,Cd,t),f(wn,e,t),l(e,jd,t),l(e,hn,t),l(e,vd,t),l(e,yn,t),l(e,gd,t),l(e,Mn,t),l(e,Ud,t),l(e,Tn,t),l(e,xd,t),l(e,$n,t),l(e,_d,t),f(Jn,e,t),l(e,Id,t),l(e,bn,t),l(e,kd,t),l(e,Cn,t),l(e,Zd,t),l(e,jn,t),l(e,Hd,t),l(e,vn,t),l(e,Gd,t),l(e,gn,t),l(e,Bd,t),f(Un,e,t),l(e,Xd,t),l(e,xn,t),l(e,Vd,t),f(_n,e,t),l(e,Rd,t),l(e,In,t),l(e,Nd,t),f(kn,e,t),l(e,zd,t),l(e,Zn,t),l(e,Wd,t),l(e,Hn,t),l(e,Ld,t),f(Gn,e,t),l(e,Sd,t),l(e,Bn,t),l(e,Qd,t),f(Xn,e,t),l(e,Fd,t),l(e,Vn,t),l(e,Ed,t),f(Rn,e,t),l(e,Pd,t),l(e,Nn,t),l(e,Ad,t),f(zn,e,t),l(e,Yd,t),l(e,Wn,t),l(e,qd,t),l(e,Ln,t),l(e,Kd,t),l(e,Sn,t),l(e,Dd,t),f(Qn,e,t),l(e,Od,t),l(e,Fn,t),l(e,ef,t),l(e,En,t),l(e,tf,t),f(Pn,e,t),l(e,sf,t),l(e,An,t),l(e,lf,t),f(Yn,e,t),l(e,nf,t),l(e,qn,t),l(e,af,t),l(e,Kn,t),l(e,pf,t),l(e,Dn,t),l(e,of,t),l(e,On,t),l(e,rf,t),f(ei,e,t),l(e,df,t),l(e,ti,t),l(e,ff,t),l(e,si,t),l(e,mf,t),f(li,e,t),l(e,uf,t),l(e,ni,t),l(e,cf,t),l(e,ii,t),l(e,wf,t),l(e,ai,t),l(e,hf,t),l(e,pi,t),l(e,yf,t),l(e,oi,t),l(e,Mf,t),l(e,ri,t),l(e,Tf,t),l(e,di,t),l(e,$f,t),l(e,fi,t),l(e,Jf,t),l(e,mi,t),l(e,bf,t),l(e,ui,t),l(e,Cf,t),l(e,ci,t),l(e,jf,t),l(e,wi,t),l(e,vf,t),f(hi,e,t),l(e,gf,t),l(e,yi,t),l(e,Uf,t),f(Mi,e,t),l(e,xf,t),l(e,Ti,t),l(e,_f,t),l(e,$i,t),l(e,If,t),l(e,Ji,t),l(e,kf,t),l(e,bi,t),l(e,Zf,t),l(e,Ci,t),l(e,Hf,t),l(e,ji,t),l(e,Gf,t),l(e,vi,t),l(e,Bf,t),f(gi,e,t),l(e,Xf,t),l(e,Ui,t),l(e,Vf,t),f(xi,e,t),l(e,Rf,t),f(_i,e,t),l(e,Nf,t),l(e,Ii,t),zf=!0},p(e,[t]){const kw={};t&2&&(kw.$$scope={dirty:t,ctx:e}),b.$set(kw);const Zw={};t&2&&(Zw.$$scope={dirty:t,ctx:e}),C.$set(Zw);const Hw={};t&2&&(Hw.$$scope={dirty:t,ctx:e}),j.$set(Hw);const Gw={};t&2&&(Gw.$$scope={dirty:t,ctx:e}),v.$set(Gw)},i(e){zf||(m(g.$$.fragment,e),m(I.$$.fragment,e),m(Z.$$.fragment,e),m(G.$$.fragment,e),m(B.$$.fragment,e),m(N.$$.fragment,e),m(W.$$.fragment,e),m(S.$$.fragment,e),m(E.$$.fragment,e),m(A.$$.fragment,e),m(q.$$.fragment,e),m(K.$$.fragment,e),m(O.$$.fragment,e),m(ee.$$.fragment,e),m(se.$$.fragment,e),m(ae.$$.fragment,e),m(re.$$.fragment,e),m(me.$$.fragment,e),m(we.$$.fragment,e),m(ye.$$.fragment,e),m(Te.$$.fragment,e),m(be.$$.fragment,e),m(Ce.$$.fragment,e),m(ve.$$.fragment,e),m(ge.$$.fragment,e),m(xe.$$.fragment,e),m(Ie.$$.fragment,e),m(Ze.$$.fragment,e),m(Ge.$$.fragment,e),m(Be.$$.fragment,e),m(Ve.$$.fragment,e),m(Ne.$$.fragment,e),m(Le.$$.fragment,e),m(Qe.$$.fragment,e),m(Pe.$$.fragment,e),m(Ye.$$.fragment,e),m(qe.$$.fragment,e),m(De.$$.fragment,e),m(Oe.$$.fragment,e),m(lt.$$.fragment,e),m(it.$$.fragment,e),m(pt.$$.fragment,e),m(rt.$$.fragment,e),m(b.$$.fragment,e),m(C.$$.fragment,e),m(dt.$$.fragment,e),m(ft.$$.fragment,e),m(ct.$$.fragment,e),m(ht.$$.fragment,e),m(Mt.$$.fragment,e),m($t.$$.fragment,e),m(Ct.$$.fragment,e),m(jt.$$.fragment,e),m(gt.$$.fragment,e),m(xt.$$.fragment,e),m(It.$$.fragment,e),m(Zt.$$.fragment,e),m(Ht.$$.fragment,e),m(Bt.$$.fragment,e),m(Xt.$$.fragment,e),m(Vt.$$.fragment,e),m(Nt.$$.fragment,e),m(Wt.$$.fragment,e),m(At.$$.fragment,e),m(qt.$$.fragment,e),m(Dt.$$.fragment,e),m(es.$$.fragment,e),m(ns.$$.fragment,e),m(is.$$.fragment,e),m(ps.$$.fragment,e),m(ds.$$.fragment,e),m(ms.$$.fragment,e),m(Js.$$.fragment,e),m(vs.$$.fragment,e),m(Us.$$.fragment,e),m(Is.$$.fragment,e),m(Hs.$$.fragment,e),m(Xs.$$.fragment,e),m(Ls.$$.fragment,e),m(Fs.$$.fragment,e),m(Ps.$$.fragment,e),m(Ys.$$.fragment,e),m(Ks.$$.fragment,e),m(Os.$$.fragment,e),m(ll.$$.fragment,e),m(il.$$.fragment,e),m(pl.$$.fragment,e),m(rl.$$.fragment,e),m(wl.$$.fragment,e),m(yl.$$.fragment,e),m(Cl.$$.fragment,e),m(gl.$$.fragment,e),m(_l.$$.fragment,e),m(j.$$.fragment,e),m(v.$$.fragment,e),m(Gl.$$.fragment,e),m(Ll.$$.fragment,e),m(Ql.$$.fragment,e),m(El.$$.fragment,e),m(Al.$$.fragment,e),m(ql.$$.fragment,e),m(Dl.$$.fragment,e),m(en.$$.fragment,e),m(sn.$$.fragment,e),m(nn.$$.fragment,e),m(pn.$$.fragment,e),m(fn.$$.fragment,e),m(un.$$.fragment,e),m(wn.$$.fragment,e),m(Jn.$$.fragment,e),m(Un.$$.fragment,e),m(_n.$$.fragment,e),m(kn.$$.fragment,e),m(Gn.$$.fragment,e),m(Xn.$$.fragment,e),m(Rn.$$.fragment,e),m(zn.$$.fragment,e),m(Qn.$$.fragment,e),m(Pn.$$.fragment,e),m(Yn.$$.fragment,e),m(ei.$$.fragment,e),m(li.$$.fragment,e),m(hi.$$.fragment,e),m(Mi.$$.fragment,e),m(gi.$$.fragment,e),m(xi.$$.fragment,e),m(_i.$$.fragment,e),zf=!0)},o(e){u(g.$$.fragment,e),u(I.$$.fragment,e),u(Z.$$.fragment,e),u(G.$$.fragment,e),u(B.$$.fragment,e),u(N.$$.fragment,e),u(W.$$.fragment,e),u(S.$$.fragment,e),u(E.$$.fragment,e),u(A.$$.fragment,e),u(q.$$.fragment,e),u(K.$$.fragment,e),u(O.$$.fragment,e),u(ee.$$.fragment,e),u(se.$$.fragment,e),u(ae.$$.fragment,e),u(re.$$.fragment,e),u(me.$$.fragment,e),u(we.$$.fragment,e),u(ye.$$.fragment,e),u(Te.$$.fragment,e),u(be.$$.fragment,e),u(Ce.$$.fragment,e),u(ve.$$.fragment,e),u(ge.$$.fragment,e),u(xe.$$.fragment,e),u(Ie.$$.fragment,e),u(Ze.$$.fragment,e),u(Ge.$$.fragment,e),u(Be.$$.fragment,e),u(Ve.$$.fragment,e),u(Ne.$$.fragment,e),u(Le.$$.fragment,e),u(Qe.$$.fragment,e),u(Pe.$$.fragment,e),u(Ye.$$.fragment,e),u(qe.$$.fragment,e),u(De.$$.fragment,e),u(Oe.$$.fragment,e),u(lt.$$.fragment,e),u(it.$$.fragment,e),u(pt.$$.fragment,e),u(rt.$$.fragment,e),u(b.$$.fragment,e),u(C.$$.fragment,e),u(dt.$$.fragment,e),u(ft.$$.fragment,e),u(ct.$$.fragment,e),u(ht.$$.fragment,e),u(Mt.$$.fragment,e),u($t.$$.fragment,e),u(Ct.$$.fragment,e),u(jt.$$.fragment,e),u(gt.$$.fragment,e),u(xt.$$.fragment,e),u(It.$$.fragment,e),u(Zt.$$.fragment,e),u(Ht.$$.fragment,e),u(Bt.$$.fragment,e),u(Xt.$$.fragment,e),u(Vt.$$.fragment,e),u(Nt.$$.fragment,e),u(Wt.$$.fragment,e),u(At.$$.fragment,e),u(qt.$$.fragment,e),u(Dt.$$.fragment,e),u(es.$$.fragment,e),u(ns.$$.fragment,e),u(is.$$.fragment,e),u(ps.$$.fragment,e),u(ds.$$.fragment,e),u(ms.$$.fragment,e),u(Js.$$.fragment,e),u(vs.$$.fragment,e),u(Us.$$.fragment,e),u(Is.$$.fragment,e),u(Hs.$$.fragment,e),u(Xs.$$.fragment,e),u(Ls.$$.fragment,e),u(Fs.$$.fragment,e),u(Ps.$$.fragment,e),u(Ys.$$.fragment,e),u(Ks.$$.fragment,e),u(Os.$$.fragment,e),u(ll.$$.fragment,e),u(il.$$.fragment,e),u(pl.$$.fragment,e),u(rl.$$.fragment,e),u(wl.$$.fragment,e),u(yl.$$.fragment,e),u(Cl.$$.fragment,e),u(gl.$$.fragment,e),u(_l.$$.fragment,e),u(j.$$.fragment,e),u(v.$$.fragment,e),u(Gl.$$.fragment,e),u(Ll.$$.fragment,e),u(Ql.$$.fragment,e),u(El.$$.fragment,e),u(Al.$$.fragment,e),u(ql.$$.fragment,e),u(Dl.$$.fragment,e),u(en.$$.fragment,e),u(sn.$$.fragment,e),u(nn.$$.fragment,e),u(pn.$$.fragment,e),u(fn.$$.fragment,e),u(un.$$.fragment,e),u(wn.$$.fragment,e),u(Jn.$$.fragment,e),u(Un.$$.fragment,e),u(_n.$$.fragment,e),u(kn.$$.fragment,e),u(Gn.$$.fragment,e),u(Xn.$$.fragment,e),u(Rn.$$.fragment,e),u(zn.$$.fragment,e),u(Qn.$$.fragment,e),u(Pn.$$.fragment,e),u(Yn.$$.fragment,e),u(ei.$$.fragment,e),u(li.$$.fragment,e),u(hi.$$.fragment,e),u(Mi.$$.fragment,e),u(gi.$$.fragment,e),u(xi.$$.fragment,e),u(_i.$$.fragment,e),zf=!1},d(e){e&&(s(T),s(y),s($),s(ki),s(U),s(Zi),s(x),s(Hi),s(_),s(Gi),s(Bi),s(k),s(Xi),s(Vi),s(H),s(Ri),s(Ni),s(zi),s(X),s(Wi),s(V),s(Li),s(R),s(Si),s(Qi),s(z),s(Fi),s(Ei),s(L),s(Pi),s(Ai),s(Q),s(Yi),s(F),s(qi),s(Ki),s(P),s(Di),s(Oi),s(Y),s(ea),s(ta),s(sa),s(D),s(la),s(na),s(ia),s(te),s(aa),s(pa),s(le),s(oa),s(ne),s(ra),s(ie),s(da),s(fa),s(pe),s(ma),s(oe),s(ua),s(ca),s(de),s(wa),s(fe),s(ha),s(ya),s(ue),s(Ma),s(ce),s(Ta),s($a),s(he),s(Ja),s(ba),s(Me),s(Ca),s(ja),s($e),s(va),s(Je),s(ga),s(Ua),s(xa),s(je),s(_a),s(Ia),s(ka),s(Ue),s(Za),s(Ha),s(_e),s(Ga),s(Ba),s(ke),s(Xa),s(Va),s(He),s(Ra),s(Na),s(za),s(Xe),s(Wa),s(La),s(Re),s(Sa),s(Qa),s(ze),s(Fa),s(We),s(Ea),s(Pa),s(Se),s(Aa),s(Ya),s(Fe),s(qa),s(Ee),s(Ka),s(Da),s(Ae),s(Oa),s(ep),s(tp),s(Ke),s(sp),s(lp),s(np),s(et),s(ip),s(tt),s(ap),s(st),s(pp),s(op),s(nt),s(rp),s(dp),s(at),s(fp),s(mp),s(ot),s(up),s(cp),s(wp),s(hp),s(yp),s(Mp),s(mt),s(Tp),s(ut),s($p),s(Jp),s(wt),s(bp),s(Cp),s(yt),s(jp),s(vp),s(Tt),s(gp),s(Up),s(Jt),s(xp),s(bt),s(_p),s(Ip),s(kp),s(vt),s(Zp),s(Hp),s(Ut),s(Gp),s(Bp),s(_t),s(Xp),s(Vp),s(kt),s(Rp),s(Np),s(zp),s(Gt),s(Wp),s(Lp),s(Sp),s(Qp),s(Rt),s(Fp),s(Ep),s(zt),s(Pp),s(Ap),s(Lt),s(Yp),s(St),s(qp),s(Qt),s(Kp),s(Ft),s(Dp),s(Et),s(Op),s(Pt),s(eo),s(to),s(Yt),s(so),s(lo),s(Kt),s(no),s(io),s(Ot),s(ao),s(po),s(ts),s(oo),s(ss),s(ro),s(ls),s(fo),s(mo),s(uo),s(as),s(co),s(wo),s(os),s(ho),s(rs),s(yo),s(Mo),s(fs),s(To),s($o),s(us),s(Jo),s(cs),s(bo),s(ws),s(Co),s(hs),s(jo),s(ys),s(vo),s(Ms),s(go),s(Ts),s(Uo),s($s),s(xo),s(_o),s(bs),s(Io),s(Cs),s(ko),s(js),s(Zo),s(Ho),s(gs),s(Go),s(Bo),s(xs),s(Xo),s(_s),s(Vo),s(Ro),s(ks),s(No),s(Zs),s(zo),s(Wo),s(Gs),s(Lo),s(Bs),s(So),s(Qo),s(Vs),s(Fo),s(Rs),s(Eo),s(Ns),s(Po),s(zs),s(Ao),s(Ws),s(Yo),s(qo),s(Ss),s(Ko),s(Qs),s(Do),s(Oo),s(Es),s(er),s(tr),s(As),s(sr),s(lr),s(qs),s(nr),s(ir),s(Ds),s(ar),s(pr),s(el),s(or),s(tl),s(rr),s(sl),s(dr),s(fr),s(nl),s(mr),s(ur),s(al),s(cr),s(wr),s(ol),s(hr),s(yr),s(dl),s(Mr),s(fl),s(Tr),s(ml),s($r),s(ul),s(Jr),s(cl),s(br),s(Cr),s(hl),s(jr),s(vr),s(Ml),s(gr),s(Tl),s(Ur),s($l),s(xr),s(Jl),s(_r),s(bl),s(Ir),s(kr),s(jl),s(Zr),s(vl),s(Hr),s(Gr),s(Ul),s(Br),s(xl),s(Xr),s(Vr),s(Il),s(Rr),s(kl),s(Nr),s(zr),s(Wr),s(Zl),s(Lr),s(Hl),s(Sr),s(Qr),s(Bl),s(Fr),s(Xl),s(Er),s(Vl),s(Pr),s(Rl),s(Ar),s(Nl),s(Yr),s(zl),s(qr),s(Wl),s(Kr),s(Dr),s(Sl),s(Or),s(ed),s(Fl),s(td),s(sd),s(Pl),s(ld),s(nd),s(Yl),s(id),s(ad),s(Kl),s(pd),s(od),s(Ol),s(rd),s(dd),s(tn),s(fd),s(md),s(ln),s(ud),s(cd),s(an),s(wd),s(hd),s(on),s(yd),s(rn),s(Md),s(dn),s(Td),s($d),s(mn),s(Jd),s(bd),s(cn),s(Cd),s(jd),s(hn),s(vd),s(yn),s(gd),s(Mn),s(Ud),s(Tn),s(xd),s($n),s(_d),s(Id),s(bn),s(kd),s(Cn),s(Zd),s(jn),s(Hd),s(vn),s(Gd),s(gn),s(Bd),s(Xd),s(xn),s(Vd),s(Rd),s(In),s(Nd),s(zd),s(Zn),s(Wd),s(Hn),s(Ld),s(Sd),s(Bn),s(Qd),s(Fd),s(Vn),s(Ed),s(Pd),s(Nn),s(Ad),s(Yd),s(Wn),s(qd),s(Ln),s(Kd),s(Sn),s(Dd),s(Od),s(Fn),s(ef),s(En),s(tf),s(sf),s(An),s(lf),s(nf),s(qn),s(af),s(Kn),s(pf),s(Dn),s(of),s(On),s(rf),s(df),s(ti),s(ff),s(si),s(mf),s(uf),s(ni),s(cf),s(ii),s(wf),s(ai),s(hf),s(pi),s(yf),s(oi),s(Mf),s(ri),s(Tf),s(di),s($f),s(fi),s(Jf),s(mi),s(bf),s(ui),s(Cf),s(ci),s(jf),s(wi),s(vf),s(gf),s(yi),s(Uf),s(xf),s(Ti),s(_f),s($i),s(If),s(Ji),s(kf),s(bi),s(Zf),s(Ci),s(Hf),s(ji),s(Gf),s(vi),s(Bf),s(Xf),s(Ui),s(Vf),s(Rf),s(Nf),s(Ii)),s(h),c(g,e),c(I,e),c(Z,e),c(G,e),c(B,e),c(N,e),c(W,e),c(S,e),c(E,e),c(A,e),c(q,e),c(K,e),c(O,e),c(ee,e),c(se,e),c(ae,e),c(re,e),c(me,e),c(we,e),c(ye,e),c(Te,e),c(be,e),c(Ce,e),c(ve,e),c(ge,e),c(xe,e),c(Ie,e),c(Ze,e),c(Ge,e),c(Be,e),c(Ve,e),c(Ne,e),c(Le,e),c(Qe,e),c(Pe,e),c(Ye,e),c(qe,e),c(De,e),c(Oe,e),c(lt,e),c(it,e),c(pt,e),c(rt,e),c(b,e),c(C,e),c(dt,e),c(ft,e),c(ct,e),c(ht,e),c(Mt,e),c($t,e),c(Ct,e),c(jt,e),c(gt,e),c(xt,e),c(It,e),c(Zt,e),c(Ht,e),c(Bt,e),c(Xt,e),c(Vt,e),c(Nt,e),c(Wt,e),c(At,e),c(qt,e),c(Dt,e),c(es,e),c(ns,e),c(is,e),c(ps,e),c(ds,e),c(ms,e),c(Js,e),c(vs,e),c(Us,e),c(Is,e),c(Hs,e),c(Xs,e),c(Ls,e),c(Fs,e),c(Ps,e),c(Ys,e),c(Ks,e),c(Os,e),c(ll,e),c(il,e),c(pl,e),c(rl,e),c(wl,e),c(yl,e),c(Cl,e),c(gl,e),c(_l,e),c(j,e),c(v,e),c(Gl,e),c(Ll,e),c(Ql,e),c(El,e),c(Al,e),c(ql,e),c(Dl,e),c(en,e),c(sn,e),c(nn,e),c(pn,e),c(fn,e),c(un,e),c(wn,e),c(Jn,e),c(Un,e),c(_n,e),c(kn,e),c(Gn,e),c(Xn,e),c(Rn,e),c(zn,e),c(Qn,e),c(Pn,e),c(Yn,e),c(ei,e),c(li,e),c(hi,e),c(Mi,e),c(gi,e),c(xi,e),c(_i,e)}}}const Yw='{"title":"Testing","local":"testing","sections":[{"title":"How transformers are tested","local":"how-transformers-are-tested","sections":[],"depth":2},{"title":"Running tests","local":"running-tests","sections":[{"title":"Choosing which tests to run","local":"choosing-which-tests-to-run","sections":[],"depth":3},{"title":"Getting the list of all tests","local":"getting-the-list-of-all-tests","sections":[],"depth":3},{"title":"Run a specific test module","local":"run-a-specific-test-module","sections":[],"depth":3},{"title":"Run specific tests","local":"run-specific-tests","sections":[],"depth":3},{"title":"Run accelerate tests","local":"run-accelerate-tests","sections":[],"depth":3},{"title":"Run documentation tests","local":"run-documentation-tests","sections":[],"depth":3},{"title":"Run only modified tests","local":"run-only-modified-tests","sections":[],"depth":3},{"title":"Automatically rerun failed tests on source modification","local":"automatically-rerun-failed-tests-on-source-modification","sections":[],"depth":3},{"title":"Skip a test module","local":"skip-a-test-module","sections":[],"depth":3},{"title":"Clearing state","local":"clearing-state","sections":[],"depth":3},{"title":"Running tests in parallel","local":"running-tests-in-parallel","sections":[],"depth":3},{"title":"Test order and repetition","local":"test-order-and-repetition","sections":[{"title":"Repeat tests","local":"repeat-tests","sections":[],"depth":4},{"title":"Run tests in a random order","local":"run-tests-in-a-random-order","sections":[],"depth":4}],"depth":3},{"title":"Look and feel variations","local":"look-and-feel-variations","sections":[{"title":"pytest-sugar","local":"pytest-sugar","sections":[],"depth":4},{"title":"Report each sub-test name and its progress","local":"report-each-sub-test-name-and-its-progress","sections":[],"depth":4},{"title":"Instantly shows failed tests","local":"instantly-shows-failed-tests","sections":[],"depth":4}],"depth":3},{"title":"To GPU or not to GPU","local":"to-gpu-or-not-to-gpu","sections":[],"depth":3},{"title":"Testing with a specific PyTorch backend or device","local":"testing-with-a-specific-pytorch-backend-or-device","sections":[],"depth":3}],"depth":2}],"depth":1}';function qw(J){return Rw(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class sh extends Nw{constructor(h){super(),zw(this,h,qw,Aw,Vw,{})}}export{sh as component};
