import{s as ne,f as Me,n as ie,o as oe}from"../chunks/scheduler.389d799c.js";import{S as pe,i as re,g as M,s as a,r as o,A as ye,h as i,f as l,c as n,j as Ft,u as p,x as m,k as U,y as ce,a as s,v as r,d as y,t as c,w as j}from"../chunks/index.8f81d18f.js";import{C as u}from"../chunks/CodeBlock.c0898180.js";import{H as O,E as je}from"../chunks/index.d407e2cc.js";function me(Vt){let h,lt,tt,st,J,at,b,Ht="The get started guide will show you how to quickly use Hugging Face on Amazon SageMaker with the SDK. Learn how to fine-tune and deploy a pretrained 🤗 Transformers model on SageMaker for a binary text classification task.",nt,d,vt,Mt,f,St='📓 Open the <a href="https://github.com/huggingface/notebooks/blob/main/sagemaker/01_getting_started_pytorch/sagemaker-notebook.ipynb" rel="nofollow">sagemaker-notebook.ipynb file</a> to follow along!',it,g,ot,w,qt='Get started by installing the necessary Hugging Face libraries and SageMaker. You will also need to install <a href="https://pytorch.org/get-started/locally/" rel="nofollow">PyTorch</a> if you don’t already have it installed. If you run this example in SageMaker Studio, it is already installed in the notebook kernel!',pt,T,rt,C,Et='If you want to run this example in <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/studio.html" rel="nofollow">SageMaker Studio</a>, upgrade <a href="https://ipywidgets.readthedocs.io/en/latest/" rel="nofollow">ipywidgets</a> for the 🤗 Datasets library and restart the kernel:',yt,k,ct,A,xt='Next, you should set up your environment: a SageMaker session and an S3 bucket. The S3 bucket will store data, models, and logs. You will need access to an <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-roles.html" rel="nofollow">IAM execution role</a> with the required permissions.',jt,I,Qt='If you are planning on using SageMaker in a local environment, you need to provide the <code>role</code> yourself. Learn more about how to set this up <a href="https://huggingface.co/docs/sagemaker/train#installation-and-setup" rel="nofollow">here</a>.',mt,Z,Lt="⚠️ The execution role is only available when you run a notebook within SageMaker. If you try to run <code>get_execution_role</code> in a notebook not on SageMaker, you will get a region error.",dt,$,ut,B,ht,X,Pt='The 🤗 Datasets library makes it easy to download and preprocess a dataset for training. Download and tokenize the <a href="https://huggingface.co/datasets/imdb" rel="nofollow">IMDb</a> dataset:',Ut,W,Jt,_,bt,G,Dt='Next, upload the preprocessed dataset to your S3 session bucket with 🤗 Datasets S3 <a href="https://huggingface.co/docs/datasets/filesystems.html" rel="nofollow">filesystem</a> implementation:',ft,z,gt,Y,wt,R,Kt="Create a Hugging Face Estimator to handle end-to-end SageMaker training and deployment. The most important parameters to pay attention to are:",Tt,N,Ot='<li><code>entry_point</code> refers to the fine-tuning script which you can find in <a href="https://github.com/huggingface/notebooks/blob/main/sagemaker/01_getting_started_pytorch/scripts/train.py" rel="nofollow">train.py file</a>.</li> <li><code>instance_type</code> refers to the SageMaker instance that will be launched. Take a look <a href="https://aws.amazon.com/sagemaker/pricing/" rel="nofollow">here</a> for a complete list of instance types.</li> <li><code>hyperparameters</code> refers to the training hyperparameters the model will be fine-tuned with.</li>',Ct,F,kt,V,te="Begin training with one line of code:",At,H,It,v,Zt,S,ee="Once the training job is complete, deploy your fine-tuned model by calling <code>deploy()</code> with the number of instances and instance type:",$t,q,Bt,E,le="Call <code>predict()</code> on your data:",Xt,x,Wt,Q,se="After running your request, delete the endpoint:",_t,L,Gt,P,zt,D,ae="Congratulations, you’ve just fine-tuned and deployed a pretrained 🤗 Transformers model on SageMaker for binary text classification! 🎉",Yt,K,Rt,et,Nt;return J=new O({props:{title:"Train and deploy a Hugging Face model on Amazon SageMaker with the SDK",local:"train-and-deploy-a-hugging-face-model-on-amazon-sagemaker-with-the-sdk",headingTag:"h1"}}),g=new O({props:{title:"Installation and setup",local:"installation-and-setup",headingTag:"h2"}}),T=new u({props:{code:"cGlwJTIwaW5zdGFsbCUyMCUyMnNhZ2VtYWtlciUzRSUzRDIuMTQwLjAlMjIlMjAlMjJ0cmFuc2Zvcm1lcnMlM0QlM0Q0LjI2LjElMjIlMjAlMjJkYXRhc2V0cyU1QnMzJTVEJTNEJTNEMi4xMC4xJTIyJTIwLS11cGdyYWRl",highlighted:'pip install <span class="hljs-string">&quot;sagemaker&gt;=2.140.0&quot;</span> <span class="hljs-string">&quot;transformers==4.26.1&quot;</span> <span class="hljs-string">&quot;datasets[s3]==2.10.1&quot;</span> --upgrade',wrap:!1}}),k=new u({props:{code:"JTI1JTI1Y2FwdHVyZSUwQWltcG9ydCUyMElQeXRob24lMEEhY29uZGElMjBpbnN0YWxsJTIwLWMlMjBjb25kYS1mb3JnZSUyMGlweXdpZGdldHMlMjAteSUwQUlQeXRob24uQXBwbGljYXRpb24uaW5zdGFuY2UoKS5rZXJuZWwuZG9fc2h1dGRvd24oVHJ1ZSk=",highlighted:`%%capture
<span class="hljs-keyword">import</span> IPython
!conda install -c conda-forge ipywidgets -y
IPython.Application.instance().kernel.do_shutdown(<span class="hljs-literal">True</span>)`,wrap:!1}}),$=new u({props:{code:"aW1wb3J0JTIwc2FnZW1ha2VyJTBBJTBBc2VzcyUyMCUzRCUyMHNhZ2VtYWtlci5TZXNzaW9uKCklMEFzYWdlbWFrZXJfc2Vzc2lvbl9idWNrZXQlMjAlM0QlMjBOb25lJTBBaWYlMjBzYWdlbWFrZXJfc2Vzc2lvbl9idWNrZXQlMjBpcyUyME5vbmUlMjBhbmQlMjBzZXNzJTIwaXMlMjBub3QlMjBOb25lJTNBJTBBJTIwJTIwJTIwJTIwc2FnZW1ha2VyX3Nlc3Npb25fYnVja2V0JTIwJTNEJTIwc2Vzcy5kZWZhdWx0X2J1Y2tldCgpJTBBJTBBcm9sZSUyMCUzRCUyMHNhZ2VtYWtlci5nZXRfZXhlY3V0aW9uX3JvbGUoKSUwQXNlc3MlMjAlM0QlMjBzYWdlbWFrZXIuU2Vzc2lvbihkZWZhdWx0X2J1Y2tldCUzRHNhZ2VtYWtlcl9zZXNzaW9uX2J1Y2tldCk=",highlighted:`<span class="hljs-keyword">import</span> sagemaker

sess = sagemaker.Session()
sagemaker_session_bucket = <span class="hljs-literal">None</span>
<span class="hljs-keyword">if</span> sagemaker_session_bucket <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span> <span class="hljs-keyword">and</span> sess <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>:
    sagemaker_session_bucket = sess.default_bucket()

role = sagemaker.get_execution_role()
sess = sagemaker.Session(default_bucket=sagemaker_session_bucket)`,wrap:!1}}),B=new O({props:{title:"Preprocess",local:"preprocess",headingTag:"h2"}}),W=new u({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEElMEElMjMlMjBsb2FkJTIwZGF0YXNldCUwQXRyYWluX2RhdGFzZXQlMkMlMjB0ZXN0X2RhdGFzZXQlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyaW1kYiUyMiUyQyUyMHNwbGl0JTNEJTVCJTIydHJhaW4lMjIlMkMlMjAlMjJ0ZXN0JTIyJTVEKSUwQSUwQSUyMyUyMGxvYWQlMjB0b2tlbml6ZXIlMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJkaXN0aWxiZXJ0JTJGZGlzdGlsYmVydC1iYXNlLXVuY2FzZWQlMjIpJTBBJTBBJTIzJTIwY3JlYXRlJTIwdG9rZW5pemF0aW9uJTIwZnVuY3Rpb24lMEFkZWYlMjB0b2tlbml6ZShiYXRjaCklM0ElMEElMjAlMjAlMjAlMjByZXR1cm4lMjB0b2tlbml6ZXIoYmF0Y2glNUIlMjJ0ZXh0JTIyJTVEJTJDJTIwcGFkZGluZyUzRCUyMm1heF9sZW5ndGglMjIlMkMlMjB0cnVuY2F0aW9uJTNEVHJ1ZSklMEElMEElMjMlMjB0b2tlbml6ZSUyMHRyYWluJTIwYW5kJTIwdGVzdCUyMGRhdGFzZXRzJTBBdHJhaW5fZGF0YXNldCUyMCUzRCUyMHRyYWluX2RhdGFzZXQubWFwKHRva2VuaXplJTJDJTIwYmF0Y2hlZCUzRFRydWUpJTBBdGVzdF9kYXRhc2V0JTIwJTNEJTIwdGVzdF9kYXRhc2V0Lm1hcCh0b2tlbml6ZSUyQyUyMGJhdGNoZWQlM0RUcnVlKSUwQSUwQSUyMyUyMHNldCUyMGRhdGFzZXQlMjBmb3JtYXQlMjBmb3IlMjBQeVRvcmNoJTBBdHJhaW5fZGF0YXNldCUyMCUzRCUyMCUyMHRyYWluX2RhdGFzZXQucmVuYW1lX2NvbHVtbiglMjJsYWJlbCUyMiUyQyUyMCUyMmxhYmVscyUyMiklMEF0cmFpbl9kYXRhc2V0LnNldF9mb3JtYXQoJTIydG9yY2glMjIlMkMlMjBjb2x1bW5zJTNEJTVCJTIyaW5wdXRfaWRzJTIyJTJDJTIwJTIyYXR0ZW50aW9uX21hc2slMjIlMkMlMjAlMjJsYWJlbHMlMjIlNUQpJTBBdGVzdF9kYXRhc2V0JTIwJTNEJTIwdGVzdF9kYXRhc2V0LnJlbmFtZV9jb2x1bW4oJTIybGFiZWwlMjIlMkMlMjAlMjJsYWJlbHMlMjIpJTBBdGVzdF9kYXRhc2V0LnNldF9mb3JtYXQoJTIydG9yY2glMjIlMkMlMjBjb2x1bW5zJTNEJTVCJTIyaW5wdXRfaWRzJTIyJTJDJTIwJTIyYXR0ZW50aW9uX21hc2slMjIlMkMlMjAlMjJsYWJlbHMlMjIlNUQp",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer

<span class="hljs-comment"># load dataset</span>
train_dataset, test_dataset = load_dataset(<span class="hljs-string">&quot;imdb&quot;</span>, split=[<span class="hljs-string">&quot;train&quot;</span>, <span class="hljs-string">&quot;test&quot;</span>])

<span class="hljs-comment"># load tokenizer</span>
tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;distilbert/distilbert-base-uncased&quot;</span>)

<span class="hljs-comment"># create tokenization function</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">tokenize</span>(<span class="hljs-params">batch</span>):
    <span class="hljs-keyword">return</span> tokenizer(batch[<span class="hljs-string">&quot;text&quot;</span>], padding=<span class="hljs-string">&quot;max_length&quot;</span>, truncation=<span class="hljs-literal">True</span>)

<span class="hljs-comment"># tokenize train and test datasets</span>
train_dataset = train_dataset.<span class="hljs-built_in">map</span>(tokenize, batched=<span class="hljs-literal">True</span>)
test_dataset = test_dataset.<span class="hljs-built_in">map</span>(tokenize, batched=<span class="hljs-literal">True</span>)

<span class="hljs-comment"># set dataset format for PyTorch</span>
train_dataset =  train_dataset.rename_column(<span class="hljs-string">&quot;label&quot;</span>, <span class="hljs-string">&quot;labels&quot;</span>)
train_dataset.set_format(<span class="hljs-string">&quot;torch&quot;</span>, columns=[<span class="hljs-string">&quot;input_ids&quot;</span>, <span class="hljs-string">&quot;attention_mask&quot;</span>, <span class="hljs-string">&quot;labels&quot;</span>])
test_dataset = test_dataset.rename_column(<span class="hljs-string">&quot;label&quot;</span>, <span class="hljs-string">&quot;labels&quot;</span>)
test_dataset.set_format(<span class="hljs-string">&quot;torch&quot;</span>, columns=[<span class="hljs-string">&quot;input_ids&quot;</span>, <span class="hljs-string">&quot;attention_mask&quot;</span>, <span class="hljs-string">&quot;labels&quot;</span>])`,wrap:!1}}),_=new O({props:{title:"Upload dataset to S3 bucket",local:"upload-dataset-to-s3-bucket",headingTag:"h2"}}),z=new u({props:{code:"JTIzJTIwc2F2ZSUyMHRyYWluX2RhdGFzZXQlMjB0byUyMHMzJTBBdHJhaW5pbmdfaW5wdXRfcGF0aCUyMCUzRCUyMGYnczMlM0ElMkYlMkYlN0JzZXNzLmRlZmF1bHRfYnVja2V0KCklN0QlMkYlN0JzM19wcmVmaXglN0QlMkZ0cmFpbiclMEF0cmFpbl9kYXRhc2V0LnNhdmVfdG9fZGlzayh0cmFpbmluZ19pbnB1dF9wYXRoKSUwQSUwQSUyMyUyMHNhdmUlMjB0ZXN0X2RhdGFzZXQlMjB0byUyMHMzJTBBdGVzdF9pbnB1dF9wYXRoJTIwJTNEJTIwZidzMyUzQSUyRiUyRiU3QnNlc3MuZGVmYXVsdF9idWNrZXQoKSU3RCUyRiU3QnMzX3ByZWZpeCU3RCUyRnRlc3QnJTBBdGVzdF9kYXRhc2V0LnNhdmVfdG9fZGlzayh0ZXN0X2lucHV0X3BhdGgp",highlighted:`<span class="hljs-comment"># save train_dataset to s3</span>
training_input_path = <span class="hljs-string">f&#x27;s3://<span class="hljs-subst">{sess.default_bucket()}</span>/<span class="hljs-subst">{s3_prefix}</span>/train&#x27;</span>
train_dataset.save_to_disk(training_input_path)

<span class="hljs-comment"># save test_dataset to s3</span>
test_input_path = <span class="hljs-string">f&#x27;s3://<span class="hljs-subst">{sess.default_bucket()}</span>/<span class="hljs-subst">{s3_prefix}</span>/test&#x27;</span>
test_dataset.save_to_disk(test_input_path)`,wrap:!1}}),Y=new O({props:{title:"Start a training job",local:"start-a-training-job",headingTag:"h2"}}),F=new u({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> sagemaker.huggingface <span class="hljs-keyword">import</span> HuggingFace

hyperparameters={
    <span class="hljs-string">&quot;epochs&quot;</span>: <span class="hljs-number">1</span>,                                       <span class="hljs-comment"># number of training epochs</span>
    <span class="hljs-string">&quot;train_batch_size&quot;</span>: <span class="hljs-number">32</span>,                            <span class="hljs-comment"># training batch size</span>
    <span class="hljs-string">&quot;model_name&quot;</span>:<span class="hljs-string">&quot;distilbert/distilbert-base-uncased&quot;</span>  <span class="hljs-comment"># name of pretrained model</span>
}

huggingface_estimator = HuggingFace(
    entry_point=<span class="hljs-string">&quot;train.py&quot;</span>,                 <span class="hljs-comment"># fine-tuning script to use in training job</span>
    source_dir=<span class="hljs-string">&quot;./scripts&quot;</span>,                 <span class="hljs-comment"># directory where fine-tuning script is stored</span>
    instance_type=<span class="hljs-string">&quot;ml.p3.2xlarge&quot;</span>,          <span class="hljs-comment"># instance type</span>
    instance_count=<span class="hljs-number">1</span>,                       <span class="hljs-comment"># number of instances</span>
    role=role,                              <span class="hljs-comment"># IAM role used in training job to access AWS resources (S3)</span>
    transformers_version=<span class="hljs-string">&quot;4.36&quot;</span>,             <span class="hljs-comment"># Transformers version</span>
    pytorch_version=<span class="hljs-string">&quot;2.1.0&quot;</span>,                  <span class="hljs-comment"># PyTorch version</span>
    py_version=<span class="hljs-string">&quot;py310&quot;</span>,                      <span class="hljs-comment"># Python version</span>
    hyperparameters=hyperparameters         <span class="hljs-comment"># hyperparameters to use in training job</span>
)`,wrap:!1}}),H=new u({props:{code:"aHVnZ2luZ2ZhY2VfZXN0aW1hdG9yLmZpdCglN0IlMjJ0cmFpbiUyMiUzQSUyMHRyYWluaW5nX2lucHV0X3BhdGglMkMlMjAlMjJ0ZXN0JTIyJTNBJTIwdGVzdF9pbnB1dF9wYXRoJTdEKQ==",highlighted:'huggingface_estimator.fit({<span class="hljs-string">&quot;train&quot;</span>: training_input_path, <span class="hljs-string">&quot;test&quot;</span>: test_input_path})',wrap:!1}}),v=new O({props:{title:"Deploy model",local:"deploy-model",headingTag:"h2"}}),q=new u({props:{code:"cHJlZGljdG9yJTIwJTNEJTIwaHVnZ2luZ2ZhY2VfZXN0aW1hdG9yLmRlcGxveShpbml0aWFsX2luc3RhbmNlX2NvdW50JTNEMSUyQyUyMm1sLmc0ZG4ueGxhcmdlJTIyKQ==",highlighted:'predictor = huggingface_estimator.deploy(initial_instance_count=<span class="hljs-number">1</span>,<span class="hljs-string">&quot;ml.g4dn.xlarge&quot;</span>)',wrap:!1}}),x=new u({props:{code:"c2VudGltZW50X2lucHV0JTIwJTNEJTIwJTdCJTIyaW5wdXRzJTIyJTNBJTIwJTIySXQlMjBmZWVscyUyMGxpa2UlMjBhJTIwY3VydGFpbiUyMGNsb3NpbmcuLi50aGVyZSUyMHdhcyUyMGFuJTIwZWxlZ2FuY2UlMjBpbiUyMHRoZSUyMHdheSUyMHRoZXklMjBtb3ZlZCUyMHRvd2FyZCUyMGNvbmNsdXNpb24uJTIwTm8lMjBmYW4lMjBpcyUyMGdvaW5nJTIwdG8lMjB3YXRjaCUyMGFuZCUyMGZlZWwlMjBzaG9ydC1jaGFuZ2VkLiUyMiU3RCUwQSUwQXByZWRpY3Rvci5wcmVkaWN0KHNlbnRpbWVudF9pbnB1dCk=",highlighted:`sentiment_input = {<span class="hljs-string">&quot;inputs&quot;</span>: <span class="hljs-string">&quot;It feels like a curtain closing...there was an elegance in the way they moved toward conclusion. No fan is going to watch and feel short-changed.&quot;</span>}

predictor.predict(sentiment_input)`,wrap:!1}}),L=new u({props:{code:"cHJlZGljdG9yLmRlbGV0ZV9lbmRwb2ludCgp",highlighted:"predictor.delete_endpoint()",wrap:!1}}),P=new O({props:{title:"What’s next?",local:"whats-next",headingTag:"h2"}}),K=new je({props:{source:"https://github.com/huggingface/hub-docs/blob/main/docs/sagemaker/source/tutorials/sagemaker-sdk/sagemaker-sdk-quickstart.md"}}),{c(){h=M("meta"),lt=a(),tt=M("p"),st=a(),o(J.$$.fragment),at=a(),b=M("p"),b.textContent=Ht,nt=a(),d=M("iframe"),Mt=a(),f=M("p"),f.innerHTML=St,it=a(),o(g.$$.fragment),ot=a(),w=M("p"),w.innerHTML=qt,pt=a(),o(T.$$.fragment),rt=a(),C=M("p"),C.innerHTML=Et,yt=a(),o(k.$$.fragment),ct=a(),A=M("p"),A.innerHTML=xt,jt=a(),I=M("p"),I.innerHTML=Qt,mt=a(),Z=M("p"),Z.innerHTML=Lt,dt=a(),o($.$$.fragment),ut=a(),o(B.$$.fragment),ht=a(),X=M("p"),X.innerHTML=Pt,Ut=a(),o(W.$$.fragment),Jt=a(),o(_.$$.fragment),bt=a(),G=M("p"),G.innerHTML=Dt,ft=a(),o(z.$$.fragment),gt=a(),o(Y.$$.fragment),wt=a(),R=M("p"),R.textContent=Kt,Tt=a(),N=M("ul"),N.innerHTML=Ot,Ct=a(),o(F.$$.fragment),kt=a(),V=M("p"),V.textContent=te,At=a(),o(H.$$.fragment),It=a(),o(v.$$.fragment),Zt=a(),S=M("p"),S.innerHTML=ee,$t=a(),o(q.$$.fragment),Bt=a(),E=M("p"),E.innerHTML=le,Xt=a(),o(x.$$.fragment),Wt=a(),Q=M("p"),Q.textContent=se,_t=a(),o(L.$$.fragment),Gt=a(),o(P.$$.fragment),zt=a(),D=M("p"),D.textContent=ae,Yt=a(),o(K.$$.fragment),Rt=a(),et=M("p"),this.h()},l(t){const e=ye("svelte-u9bgzb",document.head);h=i(e,"META",{name:!0,content:!0}),e.forEach(l),lt=n(t),tt=i(t,"P",{}),Ft(tt).forEach(l),st=n(t),p(J.$$.fragment,t),at=n(t),b=i(t,"P",{"data-svelte-h":!0}),m(b)!=="svelte-w5bkwl"&&(b.textContent=Ht),nt=n(t),d=i(t,"IFRAME",{width:!0,height:!0,src:!0,title:!0,frameborder:!0,allow:!0}),Ft(d).forEach(l),Mt=n(t),f=i(t,"P",{"data-svelte-h":!0}),m(f)!=="svelte-mi6lna"&&(f.innerHTML=St),it=n(t),p(g.$$.fragment,t),ot=n(t),w=i(t,"P",{"data-svelte-h":!0}),m(w)!=="svelte-198besl"&&(w.innerHTML=qt),pt=n(t),p(T.$$.fragment,t),rt=n(t),C=i(t,"P",{"data-svelte-h":!0}),m(C)!=="svelte-yozy2b"&&(C.innerHTML=Et),yt=n(t),p(k.$$.fragment,t),ct=n(t),A=i(t,"P",{"data-svelte-h":!0}),m(A)!=="svelte-1sllt2f"&&(A.innerHTML=xt),jt=n(t),I=i(t,"P",{"data-svelte-h":!0}),m(I)!=="svelte-tg9h77"&&(I.innerHTML=Qt),mt=n(t),Z=i(t,"P",{"data-svelte-h":!0}),m(Z)!=="svelte-y9vgbx"&&(Z.innerHTML=Lt),dt=n(t),p($.$$.fragment,t),ut=n(t),p(B.$$.fragment,t),ht=n(t),X=i(t,"P",{"data-svelte-h":!0}),m(X)!=="svelte-b8daui"&&(X.innerHTML=Pt),Ut=n(t),p(W.$$.fragment,t),Jt=n(t),p(_.$$.fragment,t),bt=n(t),G=i(t,"P",{"data-svelte-h":!0}),m(G)!=="svelte-nm384r"&&(G.innerHTML=Dt),ft=n(t),p(z.$$.fragment,t),gt=n(t),p(Y.$$.fragment,t),wt=n(t),R=i(t,"P",{"data-svelte-h":!0}),m(R)!=="svelte-16p4w97"&&(R.textContent=Kt),Tt=n(t),N=i(t,"UL",{"data-svelte-h":!0}),m(N)!=="svelte-1bnefx4"&&(N.innerHTML=Ot),Ct=n(t),p(F.$$.fragment,t),kt=n(t),V=i(t,"P",{"data-svelte-h":!0}),m(V)!=="svelte-b865q9"&&(V.textContent=te),At=n(t),p(H.$$.fragment,t),It=n(t),p(v.$$.fragment,t),Zt=n(t),S=i(t,"P",{"data-svelte-h":!0}),m(S)!=="svelte-twh61n"&&(S.innerHTML=ee),$t=n(t),p(q.$$.fragment,t),Bt=n(t),E=i(t,"P",{"data-svelte-h":!0}),m(E)!=="svelte-19s4ndj"&&(E.innerHTML=le),Xt=n(t),p(x.$$.fragment,t),Wt=n(t),Q=i(t,"P",{"data-svelte-h":!0}),m(Q)!=="svelte-l180zc"&&(Q.textContent=se),_t=n(t),p(L.$$.fragment,t),Gt=n(t),p(P.$$.fragment,t),zt=n(t),D=i(t,"P",{"data-svelte-h":!0}),m(D)!=="svelte-g7jk9r"&&(D.textContent=ae),Yt=n(t),p(K.$$.fragment,t),Rt=n(t),et=i(t,"P",{}),Ft(et).forEach(l),this.h()},h(){U(h,"name","hf:doc:metadata"),U(h,"content",de),U(d,"width","560"),U(d,"height","315"),Me(d.src,vt="https://www.youtube.com/embed/pYqjCzoyWyo")||U(d,"src",vt),U(d,"title","YouTube video player"),U(d,"frameborder","0"),U(d,"allow","accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture"),d.allowFullscreen=""},m(t,e){ce(document.head,h),s(t,lt,e),s(t,tt,e),s(t,st,e),r(J,t,e),s(t,at,e),s(t,b,e),s(t,nt,e),s(t,d,e),s(t,Mt,e),s(t,f,e),s(t,it,e),r(g,t,e),s(t,ot,e),s(t,w,e),s(t,pt,e),r(T,t,e),s(t,rt,e),s(t,C,e),s(t,yt,e),r(k,t,e),s(t,ct,e),s(t,A,e),s(t,jt,e),s(t,I,e),s(t,mt,e),s(t,Z,e),s(t,dt,e),r($,t,e),s(t,ut,e),r(B,t,e),s(t,ht,e),s(t,X,e),s(t,Ut,e),r(W,t,e),s(t,Jt,e),r(_,t,e),s(t,bt,e),s(t,G,e),s(t,ft,e),r(z,t,e),s(t,gt,e),r(Y,t,e),s(t,wt,e),s(t,R,e),s(t,Tt,e),s(t,N,e),s(t,Ct,e),r(F,t,e),s(t,kt,e),s(t,V,e),s(t,At,e),r(H,t,e),s(t,It,e),r(v,t,e),s(t,Zt,e),s(t,S,e),s(t,$t,e),r(q,t,e),s(t,Bt,e),s(t,E,e),s(t,Xt,e),r(x,t,e),s(t,Wt,e),s(t,Q,e),s(t,_t,e),r(L,t,e),s(t,Gt,e),r(P,t,e),s(t,zt,e),s(t,D,e),s(t,Yt,e),r(K,t,e),s(t,Rt,e),s(t,et,e),Nt=!0},p:ie,i(t){Nt||(y(J.$$.fragment,t),y(g.$$.fragment,t),y(T.$$.fragment,t),y(k.$$.fragment,t),y($.$$.fragment,t),y(B.$$.fragment,t),y(W.$$.fragment,t),y(_.$$.fragment,t),y(z.$$.fragment,t),y(Y.$$.fragment,t),y(F.$$.fragment,t),y(H.$$.fragment,t),y(v.$$.fragment,t),y(q.$$.fragment,t),y(x.$$.fragment,t),y(L.$$.fragment,t),y(P.$$.fragment,t),y(K.$$.fragment,t),Nt=!0)},o(t){c(J.$$.fragment,t),c(g.$$.fragment,t),c(T.$$.fragment,t),c(k.$$.fragment,t),c($.$$.fragment,t),c(B.$$.fragment,t),c(W.$$.fragment,t),c(_.$$.fragment,t),c(z.$$.fragment,t),c(Y.$$.fragment,t),c(F.$$.fragment,t),c(H.$$.fragment,t),c(v.$$.fragment,t),c(q.$$.fragment,t),c(x.$$.fragment,t),c(L.$$.fragment,t),c(P.$$.fragment,t),c(K.$$.fragment,t),Nt=!1},d(t){t&&(l(lt),l(tt),l(st),l(at),l(b),l(nt),l(d),l(Mt),l(f),l(it),l(ot),l(w),l(pt),l(rt),l(C),l(yt),l(ct),l(A),l(jt),l(I),l(mt),l(Z),l(dt),l(ut),l(ht),l(X),l(Ut),l(Jt),l(bt),l(G),l(ft),l(gt),l(wt),l(R),l(Tt),l(N),l(Ct),l(kt),l(V),l(At),l(It),l(Zt),l(S),l($t),l(Bt),l(E),l(Xt),l(Wt),l(Q),l(_t),l(Gt),l(zt),l(D),l(Yt),l(Rt),l(et)),l(h),j(J,t),j(g,t),j(T,t),j(k,t),j($,t),j(B,t),j(W,t),j(_,t),j(z,t),j(Y,t),j(F,t),j(H,t),j(v,t),j(q,t),j(x,t),j(L,t),j(P,t),j(K,t)}}}const de='{"title":"Train and deploy a Hugging Face model on Amazon SageMaker with the SDK","local":"train-and-deploy-a-hugging-face-model-on-amazon-sagemaker-with-the-sdk","sections":[{"title":"Installation and setup","local":"installation-and-setup","sections":[],"depth":2},{"title":"Preprocess","local":"preprocess","sections":[],"depth":2},{"title":"Upload dataset to S3 bucket","local":"upload-dataset-to-s3-bucket","sections":[],"depth":2},{"title":"Start a training job","local":"start-a-training-job","sections":[],"depth":2},{"title":"Deploy model","local":"deploy-model","sections":[],"depth":2},{"title":"What’s next?","local":"whats-next","sections":[],"depth":2}],"depth":1}';function ue(Vt){return oe(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class fe extends pe{constructor(h){super(),re(this,h,ue,me,ne,{})}}export{fe as component};
