import{s as kt,n as bt,o as It}from"../chunks/scheduler.389d799c.js";import{S as $t,i as Bt,g as i,s,r as p,A as St,h as o,f as a,c as n,j as Ct,u as m,x as r,k as Tt,y as vt,a as l,v as u,d as M,t as y,w as d}from"../chunks/index.8f81d18f.js";import{C as mt}from"../chunks/CodeBlock.c0898180.js";import{H as E,E as qt}from"../chunks/index.d407e2cc.js";function Wt(ut){let c,x,A,_,g,H,U,F,w,Mt='Amazon SageMaker JumpStart lets you deploy the most-popular open Hugging Face models with one click—inside your own AWS account. JumpStart offers a curated <a href="https://aws.amazon.com/sagemaker-ai/jumpstart/getting-started/?sagemaker-jumpstart-cards.sort-by=item.additionalFields.model-name&amp;sagemaker-jumpstart-cards.sort-order=asc&amp;awsf.sagemaker-jumpstart-filter-product-type=*all&amp;awsf.sagemaker-jumpstart-filter-text=*all&amp;awsf.sagemaker-jumpstart-filter-vision=*all&amp;awsf.sagemaker-jumpstart-filter-tabular=*all&amp;awsf.sagemaker-jumpstart-filter-audio-tasks=*all&amp;awsf.sagemaker-jumpstart-filter-multimodal=*all&amp;awsf.sagemaker-jumpstart-filter-RL=*all&amp;awsm.page-sagemaker-jumpstart-cards=1&amp;sagemaker-jumpstart-cards.q=qwen&amp;sagemaker-jumpstart-cards.q_operator=AND" rel="nofollow">selection</a> of model checkpoints for various tasks, including text generation, embeddings, vision, audio, and more. Most models are deployed using the official <a href="https://huggingface.co/docs/sagemaker/main/en/dlcs/introduction" rel="nofollow">Hugging Face Deep Learning Containers</a> with a sensible default instance type, so you can move from idea to production in minutes.',V,h,yt='In this quickstart guide, we will deploy <a href="https://huggingface.co/Qwen/Qwen2.5-14B-Instruct" rel="nofollow">Qwen/Qwen2.5-14B-Instruct</a>.',X,f,R,J,dt='<thead><tr><th></th> <th>Requirement</th></tr></thead> <tbody><tr><td>AWS account with SageMaker enabled</td> <td>An AWS account that will contain all your AWS resources.</td></tr> <tr><td>An IAM role to access SageMaker AI</td> <td>Learn more about how IAM works with SageMaker AI in this <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/security-iam.html" rel="nofollow">guide</a>.</td></tr> <tr><td>SageMaker Studio domain and user profile</td> <td>We recommend using SageMaker Studio for straightforward deployment and inference. Follow this <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/onboard-quick-start.html" rel="nofollow">guide</a>.</td></tr> <tr><td>Service quotas</td> <td>Most LLMs need GPU instances (e.g. ml.g5). Verify you have quota for ml.g5.24xlarge or <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/canvas-requesting-quota-increases.html" rel="nofollow">request it</a>.</td></tr></tbody>',Y,j,z,C,ct="Let’s explain how you would deploy a Hugging Face model to SageMaker browsing through the Jumpstart catalog:",L,T,gt="<li>Open SageMaker → JumpStart.</li> <li>Filter “Hugging Face” or search for your model (e.g. Qwen2.5-14B).</li> <li>Click Deploy → (optional) adjust instance size / count → Deploy.</li> <li>Wait until Endpoints shows In service.</li> <li>Copy the Endpoint name (or ARN) for later use.</li>",P,k,Ut="Alternatively, you can also browse through the Hugging Face Model Hub:",D,b,wt="<li>Open the model page → Click Deploy → SageMaker → Jumpstart tab if model is available.</li> <li>Copy the code snippet and use it from a SageMaker Notebook instance.</li>",O,I,K,$,ht="The endpoint creation can take several minutes, depending on the size of the model.",tt,B,et,S,ft="If you deployed through the console, you need to grab the endpoint ARN and reuse in your code.",at,v,lt,q,Jt="The endpoint support the Open AI API specification.",st,W,nt,Q,jt="To avoid incurring unnecessary costs, when you’re done, delete the SageMaker endpoints in the Deployments → Endpoints console or using the following code snippets:",it,Z,ot,N,rt,G,pt;return g=new E({props:{title:"Quickstart - Deploy Hugging Face Models with SageMaker Jumpstart",local:"quickstart---deploy-hugging-face-models-with-sagemaker-jumpstart",headingTag:"h1"}}),U=new E({props:{title:"Why use SageMaker JumpStart for Hugging Face models?",local:"why-use-sagemaker-jumpstart-for-hugging-face-models",headingTag:"h2"}}),f=new E({props:{title:"1. Prerequisites",local:"1-prerequisites",headingTag:"h2"}}),j=new E({props:{title:"2· Endpoint deployment",local:"2-endpoint-deployment",headingTag:"h2"}}),I=new mt({props:{code:"JTIzJTIwU2FnZU1ha2VyJTIwSnVtcFN0YXJ0JTIwcHJvdmlkZXMlMjBBUElzJTIwYXMlMjBwYXJ0JTIwb2YlMjBTYWdlTWFrZXIlMjBTREslMjB0aGF0JTIwYWxsb3clMjB5b3UlMjB0byUyMGRlcGxveSUyMGFuZCUyMGZpbmUtdHVuZSUyMG1vZGVscyUyMGluJTIwbmV0d29yayUyMGlzb2xhdGlvbiUyMHVzaW5nJTIwc2NyaXB0cyUyMHRoYXQlMjBTYWdlTWFrZXIlMjBtYWludGFpbnMuJTBBJTBBZnJvbSUyMHNhZ2VtYWtlci5qdW1wc3RhcnQubW9kZWwlMjBpbXBvcnQlMjBKdW1wU3RhcnRNb2RlbCUwQSUwQSUwQW1vZGVsJTIwJTNEJTIwSnVtcFN0YXJ0TW9kZWwobW9kZWxfaWQlM0QlMjJodWdnaW5nZmFjZS1sbG0tcXdlbjItNS0xNGItaW5zdHJ1Y3QlMjIpJTBBZXhhbXBsZV9wYXlsb2FkcyUyMCUzRCUyMG1vZGVsLnJldHJpZXZlX2FsbF9leGFtcGxlcygpJTBBJTBBcHJlZGljdG9yJTIwJTNEJTIwbW9kZWwuZGVwbG95KCklMEElMEFmb3IlMjBwYXlsb2FkJTIwaW4lMjBleGFtcGxlX3BheWxvYWRzJTNBJTBBJTIwJTIwJTIwJTIwcmVzcG9uc2UlMjAlM0QlMjBwcmVkaWN0b3IucHJlZGljdChwYXlsb2FkLmJvZHkpJTBBJTIwJTIwJTIwJTIwcHJpbnQoJTIySW5wdXQlM0ElNUNuJTIyJTJDJTIwcGF5bG9hZC5ib2R5JTVCcGF5bG9hZC5wcm9tcHRfa2V5JTVEKSUwQSUyMCUyMCUyMCUyMHByaW50KCUyMk91dHB1dCUzQSU1Q24lMjIlMkMlMjByZXNwb25zZSU1QjAlNUQlNUIlMjJnZW5lcmF0ZWRfdGV4dCUyMiU1RCUyQyUyMCUyMiU1Q24lNUNuJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTVDbiUyMik=",highlighted:`<span class="hljs-comment"># SageMaker JumpStart provides APIs as part of SageMaker SDK that allow you to deploy and fine-tune models in network isolation using scripts that SageMaker maintains.</span>

<span class="hljs-keyword">from</span> sagemaker.jumpstart.model <span class="hljs-keyword">import</span> JumpStartModel


model = JumpStartModel(model_id=<span class="hljs-string">&quot;huggingface-llm-qwen2-5-14b-instruct&quot;</span>)
example_payloads = model.retrieve_all_examples()

predictor = model.deploy()

<span class="hljs-keyword">for</span> payload <span class="hljs-keyword">in</span> example_payloads:
    response = predictor.predict(payload.body)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Input:\\n&quot;</span>, payload.body[payload.prompt_key])
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Output:\\n&quot;</span>, response[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;generated_text&quot;</span>], <span class="hljs-string">&quot;\\n\\n===============\\n&quot;</span>)`,wrap:!1}}),B=new E({props:{title:"3. Test interactively",local:"3-test-interactively",headingTag:"h2"}}),v=new mt({props:{code:"ZnJvbSUyMHNhZ2VtYWtlci5wcmVkaWN0b3IlMjBpbXBvcnQlMjByZXRyaWV2ZV9kZWZhdWx0JTBBZW5kcG9pbnRfbmFtZSUyMCUzRCUyMCUyMk1ZJTIwRU5EUE9JTlQlMjBOQU1FJTIyJTBBcHJlZGljdG9yJTIwJTNEJTIwcmV0cmlldmVfZGVmYXVsdChlbmRwb2ludF9uYW1lKSUwQXBheWxvYWQlMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjJtZXNzYWdlcyUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnJvbGUlMjIlM0ElMjAlMjJzeXN0ZW0lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyWW91JTIwYXJlJTIwYSUyMHBhc3Npb25hdGUlMjBkYXRhJTIwc2NpZW50aXN0LiUyMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMndoYXQlMjBpcyUyMG1hY2hpbmUlMjBsZWFybmluZyUzRiUyMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCUyMCUyMCU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMm1heF90b2tlbnMlMjIlM0ElMjAyMDQ4JTJDJTBBJTIwJTIwJTIwJTIwJTIydGVtcGVyYXR1cmUlMjIlM0ElMjAwLjclMkMlMEElMjAlMjAlMjAlMjAlMjJ0b3BfcCUyMiUzQSUyMDAuOSUyQyUwQSUyMCUyMCUyMCUyMCUyMnN0cmVhbSUyMiUzQSUyMEZhbHNlJTBBJTdEJTBBJTBBcmVzcG9uc2UlMjAlM0QlMjBwcmVkaWN0b3IucHJlZGljdChwYXlsb2FkKSUwQXByaW50KHJlc3BvbnNlKQ==",highlighted:`<span class="hljs-keyword">from</span> sagemaker.predictor <span class="hljs-keyword">import</span> retrieve_default
endpoint_name = <span class="hljs-string">&quot;MY ENDPOINT NAME&quot;</span>
predictor = retrieve_default(endpoint_name)
payload = {
    <span class="hljs-string">&quot;messages&quot;</span>: [
        {
            <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>,
            <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;You are a passionate data scientist.&quot;</span>
        },
        {
            <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
            <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;what is machine learning?&quot;</span>
        }
    ],
    <span class="hljs-string">&quot;max_tokens&quot;</span>: <span class="hljs-number">2048</span>,
    <span class="hljs-string">&quot;temperature&quot;</span>: <span class="hljs-number">0.7</span>,
    <span class="hljs-string">&quot;top_p&quot;</span>: <span class="hljs-number">0.9</span>,
    <span class="hljs-string">&quot;stream&quot;</span>: <span class="hljs-literal">False</span>
}

response = predictor.predict(payload)
<span class="hljs-built_in">print</span>(response)`,wrap:!1}}),W=new E({props:{title:"4. Clean‑up",local:"4-cleanup",headingTag:"h2"}}),Z=new mt({props:{code:"cHJlZGljdG9yLmRlbGV0ZV9tb2RlbCgpJTBBcHJlZGljdG9yLmRlbGV0ZV9lbmRwb2ludCgp",highlighted:`predictor.delete_model()
predictor.delete_endpoint()`,wrap:!1}}),N=new qt({props:{source:"https://github.com/huggingface/hub-docs/blob/main/docs/sagemaker/source/tutorials/jumpstart/jumpstart-quickstart.md"}}),{c(){c=i("meta"),x=s(),A=i("p"),_=s(),p(g.$$.fragment),H=s(),p(U.$$.fragment),F=s(),w=i("p"),w.innerHTML=Mt,V=s(),h=i("p"),h.innerHTML=yt,X=s(),p(f.$$.fragment),R=s(),J=i("table"),J.innerHTML=dt,Y=s(),p(j.$$.fragment),z=s(),C=i("p"),C.textContent=ct,L=s(),T=i("ol"),T.innerHTML=gt,P=s(),k=i("p"),k.textContent=Ut,D=s(),b=i("ol"),b.innerHTML=wt,O=s(),p(I.$$.fragment),K=s(),$=i("p"),$.textContent=ht,tt=s(),p(B.$$.fragment),et=s(),S=i("p"),S.textContent=ft,at=s(),p(v.$$.fragment),lt=s(),q=i("p"),q.textContent=Jt,st=s(),p(W.$$.fragment),nt=s(),Q=i("p"),Q.textContent=jt,it=s(),p(Z.$$.fragment),ot=s(),p(N.$$.fragment),rt=s(),G=i("p"),this.h()},l(t){const e=St("svelte-u9bgzb",document.head);c=o(e,"META",{name:!0,content:!0}),e.forEach(a),x=n(t),A=o(t,"P",{}),Ct(A).forEach(a),_=n(t),m(g.$$.fragment,t),H=n(t),m(U.$$.fragment,t),F=n(t),w=o(t,"P",{"data-svelte-h":!0}),r(w)!=="svelte-c323bq"&&(w.innerHTML=Mt),V=n(t),h=o(t,"P",{"data-svelte-h":!0}),r(h)!=="svelte-glhkwk"&&(h.innerHTML=yt),X=n(t),m(f.$$.fragment,t),R=n(t),J=o(t,"TABLE",{"data-svelte-h":!0}),r(J)!=="svelte-19ewxn1"&&(J.innerHTML=dt),Y=n(t),m(j.$$.fragment,t),z=n(t),C=o(t,"P",{"data-svelte-h":!0}),r(C)!=="svelte-el0n8y"&&(C.textContent=ct),L=n(t),T=o(t,"OL",{"data-svelte-h":!0}),r(T)!=="svelte-7ng80t"&&(T.innerHTML=gt),P=n(t),k=o(t,"P",{"data-svelte-h":!0}),r(k)!=="svelte-1lzsyqk"&&(k.textContent=Ut),D=n(t),b=o(t,"OL",{"data-svelte-h":!0}),r(b)!=="svelte-vh08fk"&&(b.innerHTML=wt),O=n(t),m(I.$$.fragment,t),K=n(t),$=o(t,"P",{"data-svelte-h":!0}),r($)!=="svelte-knhstf"&&($.textContent=ht),tt=n(t),m(B.$$.fragment,t),et=n(t),S=o(t,"P",{"data-svelte-h":!0}),r(S)!=="svelte-v65zqa"&&(S.textContent=ft),at=n(t),m(v.$$.fragment,t),lt=n(t),q=o(t,"P",{"data-svelte-h":!0}),r(q)!=="svelte-r63eq3"&&(q.textContent=Jt),st=n(t),m(W.$$.fragment,t),nt=n(t),Q=o(t,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-t814jl"&&(Q.textContent=jt),it=n(t),m(Z.$$.fragment,t),ot=n(t),m(N.$$.fragment,t),rt=n(t),G=o(t,"P",{}),Ct(G).forEach(a),this.h()},h(){Tt(c,"name","hf:doc:metadata"),Tt(c,"content",Qt)},m(t,e){vt(document.head,c),l(t,x,e),l(t,A,e),l(t,_,e),u(g,t,e),l(t,H,e),u(U,t,e),l(t,F,e),l(t,w,e),l(t,V,e),l(t,h,e),l(t,X,e),u(f,t,e),l(t,R,e),l(t,J,e),l(t,Y,e),u(j,t,e),l(t,z,e),l(t,C,e),l(t,L,e),l(t,T,e),l(t,P,e),l(t,k,e),l(t,D,e),l(t,b,e),l(t,O,e),u(I,t,e),l(t,K,e),l(t,$,e),l(t,tt,e),u(B,t,e),l(t,et,e),l(t,S,e),l(t,at,e),u(v,t,e),l(t,lt,e),l(t,q,e),l(t,st,e),u(W,t,e),l(t,nt,e),l(t,Q,e),l(t,it,e),u(Z,t,e),l(t,ot,e),u(N,t,e),l(t,rt,e),l(t,G,e),pt=!0},p:bt,i(t){pt||(M(g.$$.fragment,t),M(U.$$.fragment,t),M(f.$$.fragment,t),M(j.$$.fragment,t),M(I.$$.fragment,t),M(B.$$.fragment,t),M(v.$$.fragment,t),M(W.$$.fragment,t),M(Z.$$.fragment,t),M(N.$$.fragment,t),pt=!0)},o(t){y(g.$$.fragment,t),y(U.$$.fragment,t),y(f.$$.fragment,t),y(j.$$.fragment,t),y(I.$$.fragment,t),y(B.$$.fragment,t),y(v.$$.fragment,t),y(W.$$.fragment,t),y(Z.$$.fragment,t),y(N.$$.fragment,t),pt=!1},d(t){t&&(a(x),a(A),a(_),a(H),a(F),a(w),a(V),a(h),a(X),a(R),a(J),a(Y),a(z),a(C),a(L),a(T),a(P),a(k),a(D),a(b),a(O),a(K),a($),a(tt),a(et),a(S),a(at),a(lt),a(q),a(st),a(nt),a(Q),a(it),a(ot),a(rt),a(G)),a(c),d(g,t),d(U,t),d(f,t),d(j,t),d(I,t),d(B,t),d(v,t),d(W,t),d(Z,t),d(N,t)}}}const Qt='{"title":"Quickstart - Deploy Hugging Face Models with SageMaker Jumpstart","local":"quickstart---deploy-hugging-face-models-with-sagemaker-jumpstart","sections":[{"title":"Why use SageMaker JumpStart for Hugging Face models?","local":"why-use-sagemaker-jumpstart-for-hugging-face-models","sections":[],"depth":2},{"title":"1. Prerequisites","local":"1-prerequisites","sections":[],"depth":2},{"title":"2· Endpoint deployment","local":"2-endpoint-deployment","sections":[],"depth":2},{"title":"3. Test interactively","local":"3-test-interactively","sections":[],"depth":2},{"title":"4. Clean‑up","local":"4-cleanup","sections":[],"depth":2}],"depth":1}';function Zt(ut){return It(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class xt extends $t{constructor(c){super(),Bt(this,c,Zt,Wt,kt,{})}}export{xt as component};
