import{s as NJ,n as GJ,o as gJ}from"../chunks/scheduler.f6b352c8.js";import{S as RJ,i as EJ,g as T,s as M,r as e,A as WJ,h as i,f as a,c as t,j as fJ,u as J,x as c,k as vJ,y as QJ,a as n,v as y,d as p,t as j,w as o}from"../chunks/index.b90df637.js";import{C as U}from"../chunks/CodeBlock.e5718f9d.js";import{H as w,E as XJ}from"../chunks/getInferenceSnippets.5896acf0.js";function VJ(ee){let r,Va,Qa,Ya,I,ka,m,Je="This tutorial will teach you how to use RobotProcessor, a powerful pipeline system for preprocessing robot observations and postprocessing actions. You’ll learn how to create modular, composable data transformations that make your robot learning pipelines more maintainable and reproducible.",za,d,ye="<strong>You’ll learn:</strong>",Sa,u,pe="<li>What RobotProcessor is and why it’s better than alternatives</li> <li>How to create and compose processor steps</li> <li>How to save, load, and share your processors</li> <li>Advanced features for debugging and customization</li>",Fa,b,_a,h,je="Before diving into code, let’s understand the real problems RobotProcessor solves. If you’ve worked with robots and learned policies, you’ve likely encountered these challenges:",qa,C,Ha,A,oe="Your environment might output observations with keys like <code>&quot;rgb_camera_front&quot;</code> and <code>&quot;joint_positions&quot;</code>, but your pre-trained policy expects <code>&quot;observation.images.wrist&quot;</code> and <code>&quot;observation.state&quot;</code>. You need to rename these keys consistently across your pipeline.",$a,B,xa,Z,Te="Your robot’s camera captures 1920x1080 RGB images, but your policy was trained on 224x224 cropped images focusing on the workspace. You need to:",Da,f,ie="<li>Crop out the relevant workspace area</li> <li>Resize to the expected dimensions</li> <li>Convert from uint8 [0,255] to float32 [0,1]</li> <li>Ensure the right channel ordering (HWC vs CHW)</li> <li>Move everything to GPU efficiently</li>",La,v,Pa,N,ce="Your policy outputs desired end-effector positions in Cartesian space, but your robot expects joint angles. You need to:",Ka,G,we="<li>Apply inverse kinematics to convert positions to joint angles</li> <li>Handle singularities and out-of-reach positions</li> <li>Smooth the resulting trajectories to avoid jerky movements</li> <li>Clip values to respect joint limits</li>",Oa,g,ln,R,Ue="Your environment provides joint positions, but your policy also needs velocities and accelerations. You need to:",sn,E,re="<li>Calculate velocities from position differences</li> <li>Maintain a buffer of past states</li> <li>Handle episode boundaries correctly</li>",an,W,nn,Q,Ie="You want to deploy the same policy on different robots with varying:",Mn,X,me="<li>Camera setups (different resolutions, positions)</li> <li>Joint configurations (6-DOF vs 7-DOF arms)</li> <li>Control frequencies (10Hz vs 30Hz)</li> <li>Safety limits and workspace boundaries</li>",tn,V,en,Y,de="During data collection, you need to:",Jn,k,ue="<li>Record raw sensor data for dataset creation</li> <li>Apply the same preprocessing as during deployment</li> <li>Ensure reproducibility across different operators</li> <li>Share preprocessing configurations with collaborators</li>",yn,z,be="RobotProcessor solves all these problems by providing a modular, composable system where each transformation is a separate, shareable component. Let’s see how.",pn,S,jn,F,he="If you’ve worked with robot learning before, you’ve likely written preprocessing code like this:",on,_,Tn,q,Ce="This approach has several problems:",cn,H,Ae="<li><strong>Mixed concerns</strong>: Image processing, tensor conversion, device management all in one function</li> <li><strong>Hard to test</strong>: Can’t test image processing separately from state processing</li> <li><strong>Device management scattered</strong>: Easy to forget <code>.to(device)</code> calls</li> <li><strong>No standardized format</strong>: Each project reinvents the wheel</li> <li><strong>Difficult to share</strong>: Can’t easily reuse this preprocessing in other projects</li>",wn,$,Be="RobotProcessor solves these issues by providing a declarative pipeline approach where each transformation is a separate, testable, shareable component.",Un,x,rn,D,Ze="RobotProcessor works with two data formats:",In,L,mn,P,fe="An <code>EnvTransition</code> is a 7-tuple that represents a complete transition in the environment:",dn,K,un,O,bn,ll,ve="This is the format used by LeRobot datasets and replay buffers:",hn,sl,Cn,al,An,nl,Ne="RobotProcessor automatically handles both formats:",Bn,Ml,Zn,tl,fn,el,Ge="Instead of using magic numbers to access tuple elements, use the <code>TransitionIndex</code> enum:",vn,Jl,Nn,yl,Gn,pl,ge="RobotProcessor uses these default conversion functions:",gn,jl,Rn,ol,En,Tl,Re="You can customize how RobotProcessor converts between formats:",Wn,il,Qn,cl,Xn,wl,Ee="The <code>to_output</code> function determines what format is returned when you call the processor with a batch dictionary. Sometimes you want to output <code>EnvTransition</code> tuples even when you input batch dictionaries:",Vn,Ul,Yn,rl,kn,Il,We="This is particularly useful for environment interaction where you want consistent tuple output:",zn,ml,Sn,dl,Fn,ul,Qe="<strong>Use EnvTransition tuple output when:</strong>",_n,bl,Xe="<li>Environment interaction and real-time control</li> <li>You need to access individual transition components frequently</li> <li>Performance is critical (avoids dictionary creation overhead)</li> <li>Working with gym environments that expect tuple format</li>",qn,hl,Ve="<strong>Use batch dictionary output when:</strong>",Hn,Cl,Ye="<li>Training with LeRobot datasets</li> <li>Working with DataLoaders and batched processing</li> <li>Interfacing with existing LeRobot training code</li> <li>You need the standardized “next.*” key format</li>",$n,Al,xn,Bl,Dn,Zl,ke="The default conversion uses “next.*” prefixes because this matches the standard format used by LeRobot datasets and follows the convention that rewards, done flags, and truncated flags are the result of taking an action (i.e., they come from the “next” state):",Ln,fl,Pn,vl,Kn,Nl,ze="Let’s create a processor that properly handles image and state preprocessing:",On,Gl,lM,gl,sM,Rl,Se="RobotProcessor seamlessly works with LeRobot’s batch dictionary format:",aM,El,nM,Wl,MM,Ql,Fe="RobotProcessor works great with replay buffers for online learning:",tM,Xl,eM,Vl,JM,Yl,_e="A processor step must follow certain conventions. Let’s create a complete example that shows all required and optional methods:",yM,kl,pM,zl,jM,Sl,qe="These two methods serve different purposes and it’s crucial to use them correctly:",oM,Fl,TM,_l,iM,ql,He="The <code>complementary_data</code> field is perfect for passing information between steps without polluting the info dictionary:",cM,Hl,wM,$l,UM,xl,$e="One of the most powerful features of RobotProcessor is the ability to override step configurations when loading from saved checkpoints. This is particularly useful for handling non-serializable objects like environment instances, database connections, or hardware interfaces that can’t be saved to JSON.",rM,Dl,IM,Ll,xe="Imagine you have a processor step that needs a live gym environment:",mM,Pl,dM,Kl,De="If you try to save and load this processor normally, the <code>env</code> parameter will be lost because it can’t be serialized to JSON.",uM,Ol,bM,ls,Le="The <code>overrides</code> parameter in <code>from_pretrained()</code> allows you to provide non-serializable objects when loading:",hM,ss,CM,as,AM,ns,Pe="The <code>overrides</code> parameter is a dictionary where:",BM,Ms,Ke="<li><strong>Keys</strong> are step identifiers (class names for unregistered steps, registry names for registered steps)</li> <li><strong>Values</strong> are dictionaries of parameter overrides that get merged with saved configurations</li>",ZM,ts,fM,es,Oe="The loading process:",vM,Js,lJ="<li>Load saved configuration from JSON</li> <li>For each step, check if overrides exist for that step</li> <li>Merge override parameters with saved parameters (overrides take precedence)</li> <li>Instantiate the step with merged configuration</li> <li>Load any saved tensor state</li>",NM,ys,GM,ps,gM,js,RM,os,EM,Ts,WM,is,QM,cs,XM,ws,VM,Us,sJ="The override system uses exact string matching:",YM,rs,kM,Is,aJ="Use the registry name (the string passed to <code>@ProcessorStepRegistry.register()</code>):",zM,ms,SM,ds,FM,us,nJ="Use the exact class name:",_M,bs,qM,hs,HM,Cs,MJ="The override system provides helpful error messages:",$M,As,xM,Bs,DM,Zs,LM,fs,PM,vs,KM,Ns,tJ="When you have multiple steps of the same class, all instances get the same override:",OM,Gs,lt,gs,eJ="To override steps individually, use different classes or register with different names:",st,Rs,at,Es,nt,Ws,Mt,Qs,JJ="When creating steps that need non-serializable objects, design them with overrides in mind:",tt,Xs,et,Vs,Jt,Ys,yJ="Register steps with descriptive names to make overrides clearer:",yt,ks,pt,zs,jt,Ss,pJ="Include clear documentation about what overrides are needed:",ot,Fs,Tt,_s,it,qs,jJ="Create configuration helpers for different deployment environments:",ct,Hs,wt,$s,Ut,xs,oJ="Overrides work seamlessly with Hugging Face Hub sharing:",rt,Ds,It,Ls,TJ="This enables sharing of preprocessing logic while allowing each user to provide their own environment-specific dependencies.",mt,Ps,dt,Ks,iJ="Here’s a complete example showing proper device management and all features:",ut,Os,bt,la,ht,sa,cJ="Let’s see how RobotProcessor elegantly solves the scenarios we discussed earlier:",Ct,aa,At,na,wJ="When your environment and policy speak different “languages”:",Bt,Ma,Zt,ta,ft,ea,UJ="When you need to crop and resize images to focus on the manipulation workspace:",vt,Ja,Nt,ya,Gt,pa,rJ="Now you can compose these steps into robot-specific pipelines:",gt,ja,Rt,oa,IJ="The beauty of this approach is that:",Et,Ta,mJ="<li><strong>Each transformation is tested independently</strong> - The IK solver can be validated separately from image cropping</li> <li><strong>Configurations are shareable</strong> - Other labs can use your exact preprocessing setup</li> <li><strong>Pipelines are composable</strong> - Mix and match steps for different robots</li> <li><strong>Everything is version controlled</strong> - Use Hub revisions to track changes</li>",Wt,ia,Qt,ca,Xt,wa,Vt,Ua,Yt,ra,kt,Ia,zt,ma,St,da,Ft,ua,_t,ba,qt,ha,dJ="Here’s how to use RobotProcessor in a real robot control loop, showing both tuple and batch formats:",Ht,Ca,$t,Aa,xt,Ba,uJ="Use the full power of <code>RobotProcessor</code> for debugging:",Dt,Za,Lt,fa,Pt,va,bJ="RobotProcessor provides a powerful, modular approach to data preprocessing in robotics:",Kt,Na,hJ="<li><strong>Dual format support</strong>: Works seamlessly with both EnvTransition tuples and batch dictionaries</li> <li><strong>Automatic format conversion</strong>: Converts between tuple and batch formats as needed</li> <li><strong>LeRobot integration</strong>: Native support for LeRobotDataset and ReplayBuffer formats</li> <li><strong>Clear separation of concerns</strong>: Each transformation is a separate, testable unit</li> <li><strong>Proper state management</strong>: Clear distinction between config (JSON) and state (tensors)</li> <li><strong>Device-aware</strong>: Seamless GPU/CPU transfers with <code>.to(device)</code></li> <li><strong>Inter-step communication</strong>: Use <code>complementary_data</code> for passing information</li> <li><strong>Easy sharing</strong>: Push to Hugging Face Hub for reproducibility</li> <li><strong>Type safety</strong>: Use <code>TransitionIndex</code> instead of magic numbers</li> <li><strong>Debugging tools</strong>: Step through transformations and add monitoring hooks</li> <li><strong>Flexible conversion</strong>: Customize <code>to_transition</code> and <code>to_output</code> functions for specific needs</li>",Ot,Ga,CJ="Key advantages of the dual format approach:",le,ga,AJ="<li><strong>Environment interaction</strong>: Use tuple format for real-time robot control</li> <li><strong>Training/evaluation</strong>: Use batch format for dataset processing and model training</li> <li><strong>Seamless integration</strong>: Same processor works with both formats automatically</li> <li><strong>Backward compatibility</strong>: Existing code using either format continues to work</li> <li><strong>Output format control</strong>: Use <code>to_output</code> to control return format regardless of input format</li> <li><strong>Performance optimization</strong>: Avoid unnecessary format conversions during time-critical operations</li>",se,Ra,BJ="By following these patterns, your preprocessing code becomes more maintainable, shareable, and robust while being compatible with the entire LeRobot ecosystem.",ae,Ea,ZJ='For the full API reference, see the <a href="/api/processor">RobotProcessor API documentation</a>.',ne,Wa,Me,Xa,te;return I=new w({props:{title:"RobotProcessor: The Art of Processing Robot Data",local:"robotprocessor-the-art-of-processing-robot-data",headingTag:"h1"}}),b=new w({props:{title:"Real-World Scenarios: When You Need RobotProcessor",local:"real-world-scenarios-when-you-need-robotprocessor",headingTag:"h2"}}),C=new w({props:{title:"Observation Key Mismatches",local:"observation-key-mismatches",headingTag:"h3"}}),B=new w({props:{title:"Image Preprocessing Requirements",local:"image-preprocessing-requirements",headingTag:"h3"}}),v=new w({props:{title:"Coordinate System Transformations",local:"coordinate-system-transformations",headingTag:"h3"}}),g=new w({props:{title:"State Augmentation",local:"state-augmentation",headingTag:"h3"}}),W=new w({props:{title:"Multi-Robot Deployment",local:"multi-robot-deployment",headingTag:"h3"}}),V=new w({props:{title:"Data Collection and Training",local:"data-collection-and-training",headingTag:"h3"}}),S=new w({props:{title:"Why RobotProcessor?",local:"why-robotprocessor",headingTag:"h2"}}),_=new U({props:{code:"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",highlighted:`<span class="hljs-comment"># Traditional procedural approach - hard to maintain and share</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">preprocess_observation</span>(<span class="hljs-params">obs, device=<span class="hljs-string">&#x27;cuda&#x27;</span></span>):
    processed_obs = {}

    <span class="hljs-comment"># Process images</span>
    <span class="hljs-keyword">if</span> <span class="hljs-string">&quot;pixels&quot;</span> <span class="hljs-keyword">in</span> obs:
        <span class="hljs-keyword">for</span> cam_name, img <span class="hljs-keyword">in</span> obs[<span class="hljs-string">&quot;pixels&quot;</span>].items():
            <span class="hljs-comment"># Convert uint8 [0, 255] to float32 [0, 1]</span>
            img = img.astype(np.float32) / <span class="hljs-number">255.0</span>
            <span class="hljs-comment"># Convert from HWC to CHW format</span>
            img = np.transpose(img, (<span class="hljs-number">2</span>, <span class="hljs-number">0</span>, <span class="hljs-number">1</span>))
            <span class="hljs-comment"># Add batch dimension</span>
            img = np.expand_dims(img, axis=<span class="hljs-number">0</span>)
            <span class="hljs-comment"># Convert to torch and move to device</span>
            img = torch.from_numpy(img).to(device)
            <span class="hljs-comment"># Pad to standard size</span>
            <span class="hljs-keyword">if</span> img.shape[-<span class="hljs-number">2</span>:] != (<span class="hljs-number">224</span>, <span class="hljs-number">224</span>):
                img = F.pad(img, (<span class="hljs-number">0</span>, <span class="hljs-number">224</span> - img.shape[-<span class="hljs-number">1</span>], <span class="hljs-number">0</span>, <span class="hljs-number">224</span> - img.shape[-<span class="hljs-number">2</span>]))
            processed_obs[<span class="hljs-string">f&quot;observation.images.<span class="hljs-subst">{cam_name}</span>&quot;</span>] = img

    <span class="hljs-comment"># Process state</span>
    <span class="hljs-keyword">if</span> <span class="hljs-string">&quot;agent_pos&quot;</span> <span class="hljs-keyword">in</span> obs:
        state = torch.from_numpy(obs[<span class="hljs-string">&quot;agent_pos&quot;</span>]).<span class="hljs-built_in">float</span>()
        state = state.unsqueeze(<span class="hljs-number">0</span>).to(device)
        processed_obs[<span class="hljs-string">&quot;observation.state&quot;</span>] = state

    <span class="hljs-keyword">return</span> processed_obs`,wrap:!1}}),x=new w({props:{title:"Understanding EnvTransition and Batch Format",local:"understanding-envtransition-and-batch-format",headingTag:"h2"}}),L=new w({props:{title:"1. EnvTransition Tuple Format",local:"1-envtransition-tuple-format",headingTag:"h3"}}),K=new U({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> lerobot.processor.pipeline <span class="hljs-keyword">import</span> TransitionIndex

<span class="hljs-comment"># EnvTransition structure:</span>
<span class="hljs-comment"># (observation, action, reward, done, truncated, info, complementary_data)</span>
transition = (
    {<span class="hljs-string">&quot;observation.image&quot;</span>: ..., <span class="hljs-string">&quot;observation.state&quot;</span>: ...},  <span class="hljs-comment"># observation at time t</span>
    [<span class="hljs-number">0.1</span>, -<span class="hljs-number">0.2</span>, <span class="hljs-number">0.3</span>],                                      <span class="hljs-comment"># action taken at time t</span>
    <span class="hljs-number">1.0</span>,                                                   <span class="hljs-comment"># reward received</span>
    <span class="hljs-literal">False</span>,                                                 <span class="hljs-comment"># episode done flag</span>
    <span class="hljs-literal">False</span>,                                                 <span class="hljs-comment"># episode truncated flag</span>
    {<span class="hljs-string">&quot;success&quot;</span>: <span class="hljs-literal">True</span>},                                     <span class="hljs-comment"># additional info from environment</span>
    {<span class="hljs-string">&quot;step_idx&quot;</span>: <span class="hljs-number">42</span>}                                       <span class="hljs-comment"># complementary_data for inter-step communication</span>
)`,wrap:!1}}),O=new w({props:{title:"2. Batch Dictionary Format",local:"2-batch-dictionary-format",headingTag:"h3"}}),sl=new U({props:{code:"JTIzJTIwQmF0Y2glMjBkaWN0aW9uYXJ5JTIwZm9ybWF0JTIwKHVzZWQlMjBieSUyMExlUm9ib3REYXRhc2V0JTJDJTIwUmVwbGF5QnVmZmVyKSUwQWJhdGNoJTIwJTNEJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIyb2JzZXJ2YXRpb24uaW1hZ2UlMjIlM0ElMjB0b3JjaC50ZW5zb3IoLi4uKSUyQyUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMEltYWdlJTIwb2JzZXJ2YXRpb25zJTBBJTIwJTIwJTIwJTIwJTIyb2JzZXJ2YXRpb24uc3RhdGUlMjIlM0ElMjB0b3JjaC50ZW5zb3IoLi4uKSUyQyUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMFN0YXRlJTIwb2JzZXJ2YXRpb25zJTBBJTIwJTIwJTIwJTIwJTIyYWN0aW9uJTIyJTNBJTIwdG9yY2gudGVuc29yKC4uLiklMkMlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBBY3Rpb25zJTBBJTIwJTIwJTIwJTIwJTIybmV4dC5yZXdhcmQlMjIlM0ElMjB0b3JjaC50ZW5zb3IoLi4uKSUyQyUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMFJld2FyZHMlMEElMjAlMjAlMjAlMjAlMjJuZXh0LmRvbmUlMjIlM0ElMjB0b3JjaC50ZW5zb3IoLi4uKSUyQyUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMERvbmUlMjBmbGFncyUwQSUyMCUyMCUyMCUyMCUyMm5leHQudHJ1bmNhdGVkJTIyJTNBJTIwdG9yY2gudGVuc29yKC4uLiklMkMlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBUcnVuY2F0ZWQlMjBmbGFncyUwQSUyMCUyMCUyMCUyMCUyMmluZm8lMjIlM0ElMjAlN0IuLi4lN0QlMkMlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBJbmZvJTIwZGljdGlvbmFyeSUwQSUyMCUyMCUyMCUyMCUyMyUyMEFkZGl0aW9uYWwlMjBrZXlzJTIwYXJlJTIwcHJlc2VydmVkJTIwYnV0JTIwaWdub3JlZCUyMGR1cmluZyUyMGNvbnZlcnNpb24lMEElN0Q=",highlighted:`<span class="hljs-comment"># Batch dictionary format (used by LeRobotDataset, ReplayBuffer)</span>
batch = {
    <span class="hljs-string">&quot;observation.image&quot;</span>: torch.tensor(...),      <span class="hljs-comment"># Image observations</span>
    <span class="hljs-string">&quot;observation.state&quot;</span>: torch.tensor(...),      <span class="hljs-comment"># State observations</span>
    <span class="hljs-string">&quot;action&quot;</span>: torch.tensor(...),                 <span class="hljs-comment"># Actions</span>
    <span class="hljs-string">&quot;next.reward&quot;</span>: torch.tensor(...),            <span class="hljs-comment"># Rewards</span>
    <span class="hljs-string">&quot;next.done&quot;</span>: torch.tensor(...),              <span class="hljs-comment"># Done flags</span>
    <span class="hljs-string">&quot;next.truncated&quot;</span>: torch.tensor(...),         <span class="hljs-comment"># Truncated flags</span>
    <span class="hljs-string">&quot;info&quot;</span>: {...},                               <span class="hljs-comment"># Info dictionary</span>
    <span class="hljs-comment"># Additional keys are preserved but ignored during conversion</span>
}`,wrap:!1}}),al=new w({props:{title:"Automatic Format Conversion",local:"automatic-format-conversion",headingTag:"h3"}}),Ml=new U({props:{code:"ZnJvbSUyMGxlcm9ib3QucHJvY2Vzc29yLnBpcGVsaW5lJTIwaW1wb3J0JTIwUm9ib3RQcm9jZXNzb3IlMEFmcm9tJTIwbGVyb2JvdC5wcm9jZXNzb3Iub2JzZXJ2YXRpb25fcHJvY2Vzc29yJTIwaW1wb3J0JTIwSW1hZ2VQcm9jZXNzb3IlMEElMEFwcm9jZXNzb3IlMjAlM0QlMjBSb2JvdFByb2Nlc3NvciglNUJJbWFnZVByb2Nlc3NvcigpJTVEKSUwQSUwQSUyMyUyMFdvcmtzJTIwd2l0aCUyMEVudlRyYW5zaXRpb24lMjB0dXBsZXMlMEF0cmFuc2l0aW9uJTIwJTNEJTIwKCU3QiUyMnBpeGVscyUyMiUzQSUyMGltYWdlX2FycmF5JTdEJTJDJTIwTm9uZSUyQyUyMDAuMCUyQyUyMEZhbHNlJTJDJTIwRmFsc2UlMkMlMjAlN0IlN0QlMkMlMjAlN0IlN0QpJTBBcHJvY2Vzc2VkX3RyYW5zaXRpb24lMjAlM0QlMjBwcm9jZXNzb3IodHJhbnNpdGlvbiklMjAlMjAlMjMlMjBSZXR1cm5zJTIwRW52VHJhbnNpdGlvbiUyMHR1cGxlJTBBJTBBJTIzJTIwQWxzbyUyMHdvcmtzJTIwd2l0aCUyMGJhdGNoJTIwZGljdGlvbmFyaWVzJTBBYmF0Y2glMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjJvYnNlcnZhdGlvbi5waXhlbHMlMjIlM0ElMjBpbWFnZV90ZW5zb3IlMkMlMEElMjAlMjAlMjAlMjAlMjJhY3Rpb24lMjIlM0ElMjBhY3Rpb25fdGVuc29yJTJDJTBBJTIwJTIwJTIwJTIwJTIybmV4dC5yZXdhcmQlMjIlM0ElMjByZXdhcmRfdGVuc29yJTJDJTBBJTIwJTIwJTIwJTIwJTIybmV4dC5kb25lJTIyJTNBJTIwZG9uZV90ZW5zb3IlMkMlMEElMjAlMjAlMjAlMjAlMjJuZXh0LnRydW5jYXRlZCUyMiUzQSUyMHRydW5jYXRlZF90ZW5zb3IlMkMlMEElMjAlMjAlMjAlMjAlMjJpbmZvJTIyJTNBJTIwaW5mb19kaWN0JTBBJTdEJTBBcHJvY2Vzc2VkX2JhdGNoJTIwJTNEJTIwcHJvY2Vzc29yKGJhdGNoKSUyMCUyMCUyMyUyMFJldHVybnMlMjBiYXRjaCUyMGRpY3Rpb25hcnk=",highlighted:`<span class="hljs-keyword">from</span> lerobot.processor.pipeline <span class="hljs-keyword">import</span> RobotProcessor
<span class="hljs-keyword">from</span> lerobot.processor.observation_processor <span class="hljs-keyword">import</span> ImageProcessor

processor = RobotProcessor([ImageProcessor()])

<span class="hljs-comment"># Works with EnvTransition tuples</span>
transition = ({<span class="hljs-string">&quot;pixels&quot;</span>: image_array}, <span class="hljs-literal">None</span>, <span class="hljs-number">0.0</span>, <span class="hljs-literal">False</span>, <span class="hljs-literal">False</span>, {}, {})
processed_transition = processor(transition)  <span class="hljs-comment"># Returns EnvTransition tuple</span>

<span class="hljs-comment"># Also works with batch dictionaries</span>
batch = {
    <span class="hljs-string">&quot;observation.pixels&quot;</span>: image_tensor,
    <span class="hljs-string">&quot;action&quot;</span>: action_tensor,
    <span class="hljs-string">&quot;next.reward&quot;</span>: reward_tensor,
    <span class="hljs-string">&quot;next.done&quot;</span>: done_tensor,
    <span class="hljs-string">&quot;next.truncated&quot;</span>: truncated_tensor,
    <span class="hljs-string">&quot;info&quot;</span>: info_dict
}
processed_batch = processor(batch)  <span class="hljs-comment"># Returns batch dictionary</span>`,wrap:!1}}),tl=new w({props:{title:"Using TransitionIndex",local:"using-transitionindex",headingTag:"h3"}}),Jl=new U({props:{code:"ZnJvbSUyMGxlcm9ib3QucHJvY2Vzc29yLnBpcGVsaW5lJTIwaW1wb3J0JTIwVHJhbnNpdGlvbkluZGV4JTBBJTBBJTIzJTIwQmFkJTIwLSUyMHVzaW5nJTIwbWFnaWMlMjBudW1iZXJzJTBBb2JzJTIwJTNEJTIwdHJhbnNpdGlvbiU1QjAlNUQlMEFhY3Rpb24lMjAlM0QlMjB0cmFuc2l0aW9uJTVCMSU1RCUwQSUwQSUyMyUyMEdvb2QlMjAtJTIwdXNpbmclMjBUcmFuc2l0aW9uSW5kZXglMEFvYnMlMjAlM0QlMjB0cmFuc2l0aW9uJTVCVHJhbnNpdGlvbkluZGV4Lk9CU0VSVkFUSU9OJTVEJTBBYWN0aW9uJTIwJTNEJTIwdHJhbnNpdGlvbiU1QlRyYW5zaXRpb25JbmRleC5BQ1RJT04lNUQlMEFyZXdhcmQlMjAlM0QlMjB0cmFuc2l0aW9uJTVCVHJhbnNpdGlvbkluZGV4LlJFV0FSRCU1RCUwQWRvbmUlMjAlM0QlMjB0cmFuc2l0aW9uJTVCVHJhbnNpdGlvbkluZGV4LkRPTkUlNUQlMEF0cnVuY2F0ZWQlMjAlM0QlMjB0cmFuc2l0aW9uJTVCVHJhbnNpdGlvbkluZGV4LlRSVU5DQVRFRCU1RCUwQWluZm8lMjAlM0QlMjB0cmFuc2l0aW9uJTVCVHJhbnNpdGlvbkluZGV4LklORk8lNUQlMEFjb21wX2RhdGElMjAlM0QlMjB0cmFuc2l0aW9uJTVCVHJhbnNpdGlvbkluZGV4LkNPTVBMRU1FTlRBUllfREFUQSU1RA==",highlighted:`<span class="hljs-keyword">from</span> lerobot.processor.pipeline <span class="hljs-keyword">import</span> TransitionIndex

<span class="hljs-comment"># Bad - using magic numbers</span>
obs = transition[<span class="hljs-number">0</span>]
action = transition[<span class="hljs-number">1</span>]

<span class="hljs-comment"># Good - using TransitionIndex</span>
obs = transition[TransitionIndex.OBSERVATION]
action = transition[TransitionIndex.ACTION]
reward = transition[TransitionIndex.REWARD]
done = transition[TransitionIndex.DONE]
truncated = transition[TransitionIndex.TRUNCATED]
info = transition[TransitionIndex.INFO]
comp_data = transition[TransitionIndex.COMPLEMENTARY_DATA]`,wrap:!1}}),yl=new w({props:{title:"Default Conversion Functions",local:"default-conversion-functions",headingTag:"h3"}}),jl=new U({props:{code:"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",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">_default_batch_to_transition</span>(<span class="hljs-params">batch</span>):
    <span class="hljs-string">&quot;&quot;&quot;Default conversion from batch dict to EnvTransition tuple.&quot;&quot;&quot;</span>
    <span class="hljs-comment"># Extract observation keys (anything starting with &quot;observation.&quot;)</span>
    observation_keys = {k: v <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> batch.items() <span class="hljs-keyword">if</span> k.startswith(<span class="hljs-string">&quot;observation.&quot;</span>)}

    observation = <span class="hljs-literal">None</span>
    <span class="hljs-keyword">if</span> observation_keys:
        observation = {}
        <span class="hljs-comment"># Keep observation.* keys as-is (don&#x27;t remove &quot;observation.&quot; prefix)</span>
        <span class="hljs-keyword">for</span> key, value <span class="hljs-keyword">in</span> observation_keys.items():
            observation[key] = value

    <span class="hljs-keyword">return</span> (
        observation,
        batch.get(<span class="hljs-string">&quot;action&quot;</span>),
        batch.get(<span class="hljs-string">&quot;next.reward&quot;</span>, <span class="hljs-number">0.0</span>),      <span class="hljs-comment"># Note: &quot;next.reward&quot; not &quot;reward&quot;</span>
        batch.get(<span class="hljs-string">&quot;next.done&quot;</span>, <span class="hljs-literal">False</span>),      <span class="hljs-comment"># Note: &quot;next.done&quot; not &quot;done&quot;</span>
        batch.get(<span class="hljs-string">&quot;next.truncated&quot;</span>, <span class="hljs-literal">False</span>), <span class="hljs-comment"># Note: &quot;next.truncated&quot; not &quot;truncated&quot;</span>
        batch.get(<span class="hljs-string">&quot;info&quot;</span>, {}),
        {},  <span class="hljs-comment"># Empty complementary_data</span>
    )

<span class="hljs-keyword">def</span> <span class="hljs-title function_">_default_transition_to_batch</span>(<span class="hljs-params">transition</span>):
    <span class="hljs-string">&quot;&quot;&quot;Default conversion from EnvTransition tuple to batch dict.&quot;&quot;&quot;</span>
    obs, action, reward, done, truncated, info, _ = transition

    batch = {
        <span class="hljs-string">&quot;action&quot;</span>: action,
        <span class="hljs-string">&quot;next.reward&quot;</span>: reward,      <span class="hljs-comment"># Note: &quot;next.reward&quot; not &quot;reward&quot;</span>
        <span class="hljs-string">&quot;next.done&quot;</span>: done,          <span class="hljs-comment"># Note: &quot;next.done&quot; not &quot;done&quot;</span>
        <span class="hljs-string">&quot;next.truncated&quot;</span>: truncated, <span class="hljs-comment"># Note: &quot;next.truncated&quot; not &quot;truncated&quot;</span>
        <span class="hljs-string">&quot;info&quot;</span>: info,
    }

    <span class="hljs-comment"># Flatten observation dict (keep observation.* keys as-is)</span>
    <span class="hljs-keyword">if</span> <span class="hljs-built_in">isinstance</span>(obs, <span class="hljs-built_in">dict</span>):
        <span class="hljs-keyword">for</span> key, value <span class="hljs-keyword">in</span> obs.items():
            batch[key] = value

    <span class="hljs-keyword">return</span> batch`,wrap:!1}}),ol=new w({props:{title:"Custom Conversion Functions",local:"custom-conversion-functions",headingTag:"h3"}}),il=new U({props:{code:"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",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">custom_batch_to_transition</span>(<span class="hljs-params">batch</span>):
    <span class="hljs-string">&quot;&quot;&quot;Custom conversion from batch dict to EnvTransition tuple.&quot;&quot;&quot;</span>
    <span class="hljs-comment"># Extract observation keys (anything starting with &quot;observation.&quot;)</span>
    observation = {k: v <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> batch.items() <span class="hljs-keyword">if</span> k.startswith(<span class="hljs-string">&quot;observation.&quot;</span>)}

    <span class="hljs-keyword">return</span> (
        observation,
        batch.get(<span class="hljs-string">&quot;action&quot;</span>),
        batch.get(<span class="hljs-string">&quot;reward&quot;</span>, <span class="hljs-number">0.0</span>),  <span class="hljs-comment"># Use &quot;reward&quot; instead of &quot;next.reward&quot;</span>
        batch.get(<span class="hljs-string">&quot;done&quot;</span>, <span class="hljs-literal">False</span>),  <span class="hljs-comment"># Use &quot;done&quot; instead of &quot;next.done&quot;</span>
        batch.get(<span class="hljs-string">&quot;truncated&quot;</span>, <span class="hljs-literal">False</span>),
        batch.get(<span class="hljs-string">&quot;info&quot;</span>, {}),
        batch.get(<span class="hljs-string">&quot;complementary_data&quot;</span>, {})
    )

<span class="hljs-keyword">def</span> <span class="hljs-title function_">custom_transition_to_batch</span>(<span class="hljs-params">transition</span>):
    <span class="hljs-string">&quot;&quot;&quot;Custom conversion from EnvTransition tuple to batch dict.&quot;&quot;&quot;</span>
    obs, action, reward, done, truncated, info, comp_data = transition

    batch = {
        <span class="hljs-string">&quot;action&quot;</span>: action,
        <span class="hljs-string">&quot;reward&quot;</span>: reward,        <span class="hljs-comment"># Use &quot;reward&quot; instead of &quot;next.reward&quot;</span>
        <span class="hljs-string">&quot;done&quot;</span>: done,            <span class="hljs-comment"># Use &quot;done&quot; instead of &quot;next.done&quot;</span>
        <span class="hljs-string">&quot;truncated&quot;</span>: truncated,
        <span class="hljs-string">&quot;info&quot;</span>: info,
    }

    <span class="hljs-comment"># Flatten observation dict</span>
    <span class="hljs-keyword">if</span> obs:
        batch.update(obs)

    <span class="hljs-keyword">return</span> batch

<span class="hljs-comment"># Use custom converters</span>
processor = RobotProcessor(
    steps=[ImageProcessor()],
    to_transition=custom_batch_to_transition,
    to_output=custom_transition_to_batch
)`,wrap:!1}}),cl=new w({props:{title:"Advanced: Controlling Output Format with to_output",local:"advanced-controlling-output-format-with-tooutput",headingTag:"h3"}}),Ul=new U({props:{code:"JTIzJTIwSWRlbnRpdHklMjBmdW5jdGlvbiUyMHRvJTIwYWx3YXlzJTIwcmV0dXJuJTIwRW52VHJhbnNpdGlvbiUyMHR1cGxlcyUwQWRlZiUyMGtlZXBfYXNfdHJhbnNpdGlvbih0cmFuc2l0aW9uKSUzQSUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMkFsd2F5cyUyMHJldHVybiUyMEVudlRyYW5zaXRpb24lMjB0dXBsZSUyMHJlZ2FyZGxlc3MlMjBvZiUyMGlucHV0JTIwZm9ybWF0LiUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMHJldHVybiUyMHRyYW5zaXRpb24lMEElMEElMjMlMjBQcm9jZXNzb3IlMjB0aGF0JTIwYWx3YXlzJTIwb3V0cHV0cyUyMEVudlRyYW5zaXRpb24lMjB0dXBsZXMlMEFwcm9jZXNzb3IlMjAlM0QlMjBSb2JvdFByb2Nlc3NvciglMEElMjAlMjAlMjAlMjBzdGVwcyUzRCU1QkltYWdlUHJvY2Vzc29yKCklMkMlMjBTdGF0ZVByb2Nlc3NvcigpJTVEJTJDJTBBJTIwJTIwJTIwJTIwdG9fb3V0cHV0JTNEa2VlcF9hc190cmFuc2l0aW9uJTIwJTIwJTIzJTIwQWx3YXlzJTIwcmV0dXJuJTIwdHVwbGUlMjBmb3JtYXQlMEEpJTBBJTBBJTIzJTIwRXZlbiUyMHdoZW4lMjBjYWxsZWQlMjB3aXRoJTIwYmF0Y2glMjBkaWN0JTJDJTIwcmV0dXJucyUyMEVudlRyYW5zaXRpb24lMjB0dXBsZSUwQWJhdGNoJTIwJTNEJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIyb2JzZXJ2YXRpb24uaW1hZ2UlMjIlM0ElMjBpbWFnZV90ZW5zb3IlMkMlMEElMjAlMjAlMjAlMjAlMjJhY3Rpb24lMjIlM0ElMjBhY3Rpb25fdGVuc29yJTJDJTBBJTIwJTIwJTIwJTIwJTIybmV4dC5yZXdhcmQlMjIlM0ElMjByZXdhcmRfdGVuc29yJTJDJTBBJTIwJTIwJTIwJTIwJTIybmV4dC5kb25lJTIyJTNBJTIwZG9uZV90ZW5zb3IlMkMlMEElMjAlMjAlMjAlMjAlMjJuZXh0LnRydW5jYXRlZCUyMiUzQSUyMHRydW5jYXRlZF90ZW5zb3IlMkMlMEElMjAlMjAlMjAlMjAlMjJpbmZvJTIyJTNBJTIwaW5mb19kaWN0JTBBJTdEJTBBJTBBcmVzdWx0JTIwJTNEJTIwcHJvY2Vzc29yKGJhdGNoKSUyMCUyMCUyMyUyMFJldHVybnMlMjBFbnZUcmFuc2l0aW9uJTIwdHVwbGUlMkMlMjBub3QlMjBiYXRjaCUyMGRpY3QhJTBBcHJpbnQodHlwZShyZXN1bHQpKSUyMCUyMCUyMyUyMCUzQ2NsYXNzJTIwJ3R1cGxlJyUzRQ==",highlighted:`<span class="hljs-comment"># Identity function to always return EnvTransition tuples</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">keep_as_transition</span>(<span class="hljs-params">transition</span>):
    <span class="hljs-string">&quot;&quot;&quot;Always return EnvTransition tuple regardless of input format.&quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> transition

<span class="hljs-comment"># Processor that always outputs EnvTransition tuples</span>
processor = RobotProcessor(
    steps=[ImageProcessor(), StateProcessor()],
    to_output=keep_as_transition  <span class="hljs-comment"># Always return tuple format</span>
)

<span class="hljs-comment"># Even when called with batch dict, returns EnvTransition tuple</span>
batch = {
    <span class="hljs-string">&quot;observation.image&quot;</span>: image_tensor,
    <span class="hljs-string">&quot;action&quot;</span>: action_tensor,
    <span class="hljs-string">&quot;next.reward&quot;</span>: reward_tensor,
    <span class="hljs-string">&quot;next.done&quot;</span>: done_tensor,
    <span class="hljs-string">&quot;next.truncated&quot;</span>: truncated_tensor,
    <span class="hljs-string">&quot;info&quot;</span>: info_dict
}

result = processor(batch)  <span class="hljs-comment"># Returns EnvTransition tuple, not batch dict!</span>
<span class="hljs-built_in">print</span>(<span class="hljs-built_in">type</span>(result))  <span class="hljs-comment"># &lt;class &#x27;tuple&#x27;&gt;</span>`,wrap:!1}}),rl=new w({props:{title:"Real-World Example: Environment Interaction",local:"real-world-example-environment-interaction",headingTag:"h3"}}),ml=new U({props:{code:"ZnJvbSUyMGxlcm9ib3QucHJvY2Vzc29yLm9ic2VydmF0aW9uX3Byb2Nlc3NvciUyMGltcG9ydCUyMFZhbmlsbGFPYnNlcnZhdGlvblByb2Nlc3NvciUwQSUwQSUyMyUyMENyZWF0ZSUyMHByb2Nlc3NvciUyMHRoYXQlMjBhbHdheXMlMjBvdXRwdXRzJTIwRW52VHJhbnNpdGlvbiUyMGZvciUyMGVudmlyb25tZW50JTIwaW50ZXJhY3Rpb24lMEElMjMlMjBUaGlzJTIwYXZvaWRzJTIwZm9ybWF0JTIwY29udmVyc2lvbiUyMG92ZXJoZWFkJTIwZHVyaW5nJTIwcmVhbC10aW1lJTIwY29udHJvbCUwQWVudl9wcm9jZXNzb3IlMjAlM0QlMjBSb2JvdFByb2Nlc3NvciglMEElMjAlMjAlMjAlMjAlNUJWYW5pbGxhT2JzZXJ2YXRpb25Qcm9jZXNzb3IoKSU1RCUyQyUwQSUyMCUyMCUyMCUyMHRvX3RyYW5zaXRpb24lM0RsYW1iZGElMjB4JTNBJTIweCUyQyUyMCUyMCUyMyUyMFBhc3MlMjB0aHJvdWdoJTIwLSUyMG5vJTIwY29udmVyc2lvbiUyMG5lZWRlZCUwQSUyMCUyMCUyMCUyMHRvX291dHB1dCUzRGxhbWJkYSUyMHglM0ElMjB4JTJDJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwQWx3YXlzJTIwcmV0dXJuJTIwRW52VHJhbnNpdGlvbiUyMHR1cGxlJTBBKSUwQSUwQSUyMyUyMEVudmlyb25tZW50JTIwaW50ZXJhY3Rpb24lMjBsb29wJTBBZW52JTIwJTNEJTIwbWFrZV9lbnYoKSUwQW9icyUyQyUyMGluZm8lMjAlM0QlMjBlbnYucmVzZXQoKSUwQSUwQWZvciUyMHN0ZXAlMjBpbiUyMHJhbmdlKDEwMDApJTNBJTBBJTIwJTIwJTIwJTIwJTIzJTIwQ3JlYXRlJTIwdHJhbnNpdGlvbiUyMC0lMjBpbnB1dCUyMGlzJTIwYWxyZWFkeSUyMGluJTIwdHVwbGUlMjBmb3JtYXQlMEElMjAlMjAlMjAlMjB0cmFuc2l0aW9uJTIwJTNEJTIwKG9icyUyQyUyME5vbmUlMkMlMjAwLjAlMkMlMjBGYWxzZSUyQyUyMEZhbHNlJTJDJTIwaW5mbyUyQyUyMCU3QiUyMnN0ZXAlMjIlM0ElMjBzdGVwJTdEKSUwQSUwQSUyMCUyMCUyMCUyMCUyMyUyMFByb2Nlc3MlMjAtJTIwb3V0cHV0JTIwaXMlMjBndWFyYW50ZWVkJTIwdG8lMjBiZSUyMEVudlRyYW5zaXRpb24lMjB0dXBsZSUwQSUyMCUyMCUyMCUyMHByb2Nlc3NlZF90cmFuc2l0aW9uJTIwJTNEJTIwZW52X3Byb2Nlc3Nvcih0cmFuc2l0aW9uKSUwQSUyMCUyMCUyMCUyMHByb2Nlc3NlZF9vYnMlMjAlM0QlMjBwcm9jZXNzZWRfdHJhbnNpdGlvbiU1QlRyYW5zaXRpb25JbmRleC5PQlNFUlZBVElPTiU1RCUwQSUwQSUyMCUyMCUyMCUyMCUyMyUyMFVzZSUyMHdpdGglMjBwb2xpY3klMEElMjAlMjAlMjAlMjBhY3Rpb24lMjAlM0QlMjBwb2xpY3kuc2VsZWN0X2FjdGlvbihwcm9jZXNzZWRfb2JzKSUwQSUyMCUyMCUyMCUyMG9icyUyQyUyMHJld2FyZCUyQyUyMGRvbmUlMkMlMjB0cnVuY2F0ZWQlMkMlMjBpbmZvJTIwJTNEJTIwZW52LnN0ZXAoYWN0aW9uKSUwQSUwQSUyMCUyMCUyMCUyMGlmJTIwZG9uZSUyMG9yJTIwdHJ1bmNhdGVkJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYnJlYWs=",highlighted:`<span class="hljs-keyword">from</span> lerobot.processor.observation_processor <span class="hljs-keyword">import</span> VanillaObservationProcessor

<span class="hljs-comment"># Create processor that always outputs EnvTransition for environment interaction</span>
<span class="hljs-comment"># This avoids format conversion overhead during real-time control</span>
env_processor = RobotProcessor(
    [VanillaObservationProcessor()],
    to_transition=<span class="hljs-keyword">lambda</span> x: x,  <span class="hljs-comment"># Pass through - no conversion needed</span>
    to_output=<span class="hljs-keyword">lambda</span> x: x,      <span class="hljs-comment"># Always return EnvTransition tuple</span>
)

<span class="hljs-comment"># Environment interaction loop</span>
env = make_env()
obs, info = env.reset()

<span class="hljs-keyword">for</span> step <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">1000</span>):
    <span class="hljs-comment"># Create transition - input is already in tuple format</span>
    transition = (obs, <span class="hljs-literal">None</span>, <span class="hljs-number">0.0</span>, <span class="hljs-literal">False</span>, <span class="hljs-literal">False</span>, info, {<span class="hljs-string">&quot;step&quot;</span>: step})

    <span class="hljs-comment"># Process - output is guaranteed to be EnvTransition tuple</span>
    processed_transition = env_processor(transition)
    processed_obs = processed_transition[TransitionIndex.OBSERVATION]

    <span class="hljs-comment"># Use with policy</span>
    action = policy.select_action(processed_obs)
    obs, reward, done, truncated, info = env.step(action)

    <span class="hljs-keyword">if</span> done <span class="hljs-keyword">or</span> truncated:
        <span class="hljs-keyword">break</span>`,wrap:!1}}),dl=new w({props:{title:"When to Use Different Output Formats",local:"when-to-use-different-output-formats",headingTag:"h3"}}),Al=new U({props:{code:"JTIzJTIwRm9yJTIwZW52aXJvbm1lbnQlMjBpbnRlcmFjdGlvbiUyMC0lMjB1c2UlMjB0dXBsZSUyMG91dHB1dCUwQWVudl9wcm9jZXNzb3IlMjAlM0QlMjBSb2JvdFByb2Nlc3NvciglMEElMjAlMjAlMjAlMjBzdGVwcyUzRCU1QkltYWdlUHJvY2Vzc29yKCklMkMlMjBTdGF0ZVByb2Nlc3NvcigpJTVEJTJDJTBBJTIwJTIwJTIwJTIwdG9fb3V0cHV0JTNEbGFtYmRhJTIweCUzQSUyMHglMjAlMjAlMjMlMjBSZXR1cm4lMjBFbnZUcmFuc2l0aW9uJTIwdHVwbGUlMEEpJTBBJTBBJTIzJTIwRm9yJTIwdHJhaW5pbmclMjAtJTIwdXNlJTIwYmF0Y2glMjBvdXRwdXQlMjAoZGVmYXVsdCklMEF0cmFpbl9wcm9jZXNzb3IlMjAlM0QlMjBSb2JvdFByb2Nlc3NvciglMEElMjAlMjAlMjAlMjBzdGVwcyUzRCU1QkltYWdlUHJvY2Vzc29yKCklMkMlMjBTdGF0ZVByb2Nlc3NvcigpJTJDJTIwTm9ybWFsaXplclByb2Nlc3NvciguLi4pJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIzJTIwdG9fb3V0cHV0JTIwZGVmYXVsdHMlMjB0byUyMF9kZWZhdWx0X3RyYW5zaXRpb25fdG9fYmF0Y2glMEEpJTBBJTBBJTIzJTIwVHJhaW5pbmclMjBsb29wJTBBZm9yJTIwYmF0Y2glMjBpbiUyMGRhdGFsb2FkZXIlM0ElMEElMjAlMjAlMjAlMjBwcm9jZXNzZWRfYmF0Y2glMjAlM0QlMjB0cmFpbl9wcm9jZXNzb3IoYmF0Y2gpJTIwJTIwJTIzJTIwUmV0dXJucyUyMGJhdGNoJTIwZGljdCUwQSUyMCUyMCUyMCUyMGxvc3MlMjAlM0QlMjBtb2RlbC5jb21wdXRlX2xvc3MocHJvY2Vzc2VkX2JhdGNoKSUwQSUwQSUyMyUyMEVudmlyb25tZW50JTIwbG9vcCUwQWZvciUyMHN0ZXAlMjBpbiUyMHJhbmdlKDEwMDApJTNBJTBBJTIwJTIwJTIwJTIwdHJhbnNpdGlvbiUyMCUzRCUyMChvYnMlMkMlMjBOb25lJTJDJTIwMC4wJTJDJTIwRmFsc2UlMkMlMjBGYWxzZSUyQyUyMGluZm8lMkMlMjAlN0IlN0QpJTBBJTIwJTIwJTIwJTIwcHJvY2Vzc2VkX3RyYW5zaXRpb24lMjAlM0QlMjBlbnZfcHJvY2Vzc29yKHRyYW5zaXRpb24pJTIwJTIwJTIzJTIwUmV0dXJucyUyMEVudlRyYW5zaXRpb24lMjB0dXBsZSUwQSUyMCUyMCUyMCUyMG9icyUyMCUzRCUyMHByb2Nlc3NlZF90cmFuc2l0aW9uJTVCVHJhbnNpdGlvbkluZGV4Lk9CU0VSVkFUSU9OJTVEJTBBJTIwJTIwJTIwJTIwYWN0aW9uJTIwJTNEJTIwcG9saWN5LnNlbGVjdF9hY3Rpb24ob2JzKQ==",highlighted:`<span class="hljs-comment"># For environment interaction - use tuple output</span>
env_processor = RobotProcessor(
    steps=[ImageProcessor(), StateProcessor()],
    to_output=<span class="hljs-keyword">lambda</span> x: x  <span class="hljs-comment"># Return EnvTransition tuple</span>
)

<span class="hljs-comment"># For training - use batch output (default)</span>
train_processor = RobotProcessor(
    steps=[ImageProcessor(), StateProcessor(), NormalizerProcessor(...)],
    <span class="hljs-comment"># to_output defaults to _default_transition_to_batch</span>
)

<span class="hljs-comment"># Training loop</span>
<span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> dataloader:
    processed_batch = train_processor(batch)  <span class="hljs-comment"># Returns batch dict</span>
    loss = model.compute_loss(processed_batch)

<span class="hljs-comment"># Environment loop</span>
<span class="hljs-keyword">for</span> step <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">1000</span>):
    transition = (obs, <span class="hljs-literal">None</span>, <span class="hljs-number">0.0</span>, <span class="hljs-literal">False</span>, <span class="hljs-literal">False</span>, info, {})
    processed_transition = env_processor(transition)  <span class="hljs-comment"># Returns EnvTransition tuple</span>
    obs = processed_transition[TransitionIndex.OBSERVATION]
    action = policy.select_action(obs)`,wrap:!1}}),Bl=new w({props:{title:"Why “next.reward”, “next.done”, “next.truncated”?",local:"why-nextreward-nextdone-nexttruncated",headingTag:"h3"}}),fl=new U({props:{code:"JTIzJTIwU3RhbmRhcmQlMjBSTCUyMHRyYW5zaXRpb24lMjBmb3JtYXQlMEElMjMlMjAoc190JTJDJTIwYV90JTJDJTIwcl8lN0J0JTJCMSU3RCUyQyUyMGRvbmVfJTdCdCUyQjElN0QlMkMlMjB0cnVuY2F0ZWRfJTdCdCUyQjElN0QpJTBBJTIzJTIwJTIwJTVFJTIwJTIwJTIwJTIwJTIwJTVFJTIwJTIwJTIwJTIwJTIwJTVFJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVFJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVFJTBBJTIzJTIwJTIwJTdDJTIwJTIwJTIwJTIwJTIwJTdDJTIwJTIwJTIwJTIwJTIwJTdDJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdDJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdDJTBBJTIzJTIwJTIwJTdDJTIwJTIwJTIwJTIwJTIwJTdDJTIwJTIwJTIwJTIwJTIwJTdDJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdDJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTJCLS0lMjBSZXN1bHQlMjBvZiUyMGFjdGlvbiUyMGFfdCUwQSUyMyUyMCUyMCU3QyUyMCUyMCUyMCUyMCUyMCU3QyUyMCUyMCUyMCUyMCUyMCU3QyUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyQi0tJTIwUmVzdWx0JTIwb2YlMjBhY3Rpb24lMjBhX3QlMEElMjMlMjAlMjAlN0MlMjAlMjAlMjAlMjAlMjAlN0MlMjAlMjAlMjAlMjAlMjAlMkItLSUyMFJlc3VsdCUyMG9mJTIwYWN0aW9uJTIwYV90JTBBJTIzJTIwJTIwJTdDJTIwJTIwJTIwJTIwJTIwJTJCLS0lMjBBY3Rpb24lMjB0YWtlbiUyMGluJTIwc3RhdGUlMjBzX3QlMEElMjMlMjAlMjAlMkItLSUyMFN0YXRlJTIwYXQlMjB0aW1lJTIwdCUwQSUwQWJhdGNoJTIwJTNEJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIyb2JzZXJ2YXRpb24uc3RhdGUlMjIlM0ElMjBzX3QlMkMlMEElMjAlMjAlMjAlMjAlMjJhY3Rpb24lMjIlM0ElMjBhX3QlMkMlMEElMjAlMjAlMjAlMjAlMjJuZXh0LnJld2FyZCUyMiUzQSUyMHJfJTdCdCUyQjElN0QlMkMlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBSZXdhcmQlMjByZWNlaXZlZCUyMGFmdGVyJTIwdGFraW5nJTIwYWN0aW9uJTBBJTIwJTIwJTIwJTIwJTIybmV4dC5kb25lJTIyJTNBJTIwZG9uZV8lN0J0JTJCMSU3RCUyQyUyMCUyMCUyMCUyMCUyMCUyMyUyMERvbmUlMjBmbGFnJTIwYWZ0ZXIlMjB0YWtpbmclMjBhY3Rpb24lMEElMjAlMjAlMjAlMjAlMjJuZXh0LnRydW5jYXRlZCUyMiUzQSUyMHRydW5jYXRlZF8lN0J0JTJCMSU3RCUyQyUyMCUyMCUyMyUyMFRydW5jYXRlZCUyMGZsYWclMjBhZnRlciUyMHRha2luZyUyMGFjdGlvbiUwQSU3RA==",highlighted:`<span class="hljs-comment"># Standard RL transition format</span>
<span class="hljs-comment"># (s_t, a_t, r_{t+1}, done_{t+1}, truncated_{t+1})</span>
<span class="hljs-comment">#  ^     ^     ^        ^           ^</span>
<span class="hljs-comment">#  |     |     |        |           |</span>
<span class="hljs-comment">#  |     |     |        |           +-- Result of action a_t</span>
<span class="hljs-comment">#  |     |     |        +-- Result of action a_t</span>
<span class="hljs-comment">#  |     |     +-- Result of action a_t</span>
<span class="hljs-comment">#  |     +-- Action taken in state s_t</span>
<span class="hljs-comment">#  +-- State at time t</span>

batch = {
    <span class="hljs-string">&quot;observation.state&quot;</span>: s_t,
    <span class="hljs-string">&quot;action&quot;</span>: a_t,
    <span class="hljs-string">&quot;next.reward&quot;</span>: r_{t+<span class="hljs-number">1</span>},      <span class="hljs-comment"># Reward received after taking action</span>
    <span class="hljs-string">&quot;next.done&quot;</span>: done_{t+<span class="hljs-number">1</span>},     <span class="hljs-comment"># Done flag after taking action</span>
    <span class="hljs-string">&quot;next.truncated&quot;</span>: truncated_{t+<span class="hljs-number">1</span>},  <span class="hljs-comment"># Truncated flag after taking action</span>
}`,wrap:!1}}),vl=new w({props:{title:"Your First RobotProcessor",local:"your-first-robotprocessor",headingTag:"h2"}}),Gl=new U({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> lerobot.processor.pipeline <span class="hljs-keyword">import</span> RobotProcessor, TransitionIndex
<span class="hljs-keyword">from</span> lerobot.processor.observation_processor <span class="hljs-keyword">import</span> ImageProcessor, StateProcessor
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

<span class="hljs-comment"># Create sample data</span>
observation = {
    <span class="hljs-string">&quot;pixels&quot;</span>: {
        <span class="hljs-string">&quot;camera_front&quot;</span>: np.random.randint(<span class="hljs-number">0</span>, <span class="hljs-number">255</span>, (<span class="hljs-number">480</span>, <span class="hljs-number">640</span>, <span class="hljs-number">3</span>), dtype=np.uint8),
        <span class="hljs-string">&quot;camera_side&quot;</span>: np.random.randint(<span class="hljs-number">0</span>, <span class="hljs-number">255</span>, (<span class="hljs-number">480</span>, <span class="hljs-number">640</span>, <span class="hljs-number">3</span>), dtype=np.uint8)
    },
    <span class="hljs-string">&quot;agent_pos&quot;</span>: np.array([<span class="hljs-number">0.1</span>, <span class="hljs-number">0.2</span>, <span class="hljs-number">0.3</span>, <span class="hljs-number">0.4</span>, <span class="hljs-number">0.5</span>, <span class="hljs-number">0.6</span>, <span class="hljs-number">0.7</span>], dtype=np.float32)
}

<span class="hljs-comment"># Create a full transition</span>
transition = (observation, <span class="hljs-literal">None</span>, <span class="hljs-number">0.0</span>, <span class="hljs-literal">False</span>, <span class="hljs-literal">False</span>, {}, {})

<span class="hljs-comment"># Create and use the processor</span>
processor = RobotProcessor([
    ImageProcessor(),  <span class="hljs-comment"># Converts uint8[0,255] to float32[0,1], HWC to CHW, adds batch dim</span>
    StateProcessor(),  <span class="hljs-comment"># Converts numpy arrays to torch tensors, adds batch dim</span>
])

processed_transition = processor(transition)
processed_obs = processed_transition[TransitionIndex.OBSERVATION]

<span class="hljs-comment"># Check the results</span>
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Original keys:&quot;</span>, observation.keys())
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Processed keys:&quot;</span>, processed_obs.keys())
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Image shape:&quot;</span>, processed_obs[<span class="hljs-string">&quot;observation.images.camera_front&quot;</span>].shape)  <span class="hljs-comment"># [1, 3, 480, 640]</span>
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Image dtype:&quot;</span>, processed_obs[<span class="hljs-string">&quot;observation.images.camera_front&quot;</span>].dtype)   <span class="hljs-comment"># torch.float32</span>
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Image range:&quot;</span>, processed_obs[<span class="hljs-string">&quot;observation.images.camera_front&quot;</span>].<span class="hljs-built_in">min</span>().item(),
      <span class="hljs-string">&quot;to&quot;</span>, processed_obs[<span class="hljs-string">&quot;observation.images.camera_front&quot;</span>].<span class="hljs-built_in">max</span>().item())      <span class="hljs-comment"># 0.0 to 1.0</span>`,wrap:!1}}),gl=new w({props:{title:"Working with LeRobot Datasets and Replay Buffers",local:"working-with-lerobot-datasets-and-replay-buffers",headingTag:"h2"}}),El=new U({props:{code:"ZnJvbSUyMGxlcm9ib3QuZGF0YXNldHMubGVyb2JvdF9kYXRhc2V0JTIwaW1wb3J0JTIwTGVSb2JvdERhdGFzZXQlMEFmcm9tJTIwbGVyb2JvdC5wcm9jZXNzb3IucGlwZWxpbmUlMjBpbXBvcnQlMjBSb2JvdFByb2Nlc3NvciUwQWZyb20lMjBsZXJvYm90LnByb2Nlc3Nvci5ub3JtYWxpemVfcHJvY2Vzc29yJTIwaW1wb3J0JTIwTm9ybWFsaXplclByb2Nlc3NvciUwQWZyb20lMjBsZXJvYm90LmNvbmZpZ3MudHlwZXMlMjBpbXBvcnQlMjBGZWF0dXJlVHlwZSUyQyUyME5vcm1hbGl6YXRpb25Nb2RlJTJDJTIwUG9saWN5RmVhdHVyZSUwQSUwQSUyMyUyMExvYWQlMjBhJTIwZGF0YXNldCUwQWRhdGFzZXQlMjAlM0QlMjBMZVJvYm90RGF0YXNldCglMjJsZXJvYm90JTJGcHVzaHQlMjIpJTBBJTBBJTIzJTIwRGVmaW5lJTIwZmVhdHVyZXMlMjBhbmQlMjBub3JtYWxpemF0aW9uJTBBZmVhdHVyZXMlMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjJvYnNlcnZhdGlvbi5pbWFnZSUyMiUzQSUyMFBvbGljeUZlYXR1cmUoRmVhdHVyZVR5cGUuVklTVUFMJTJDJTIwKDMlMkMlMjA5NiUyQyUyMDk2KSklMkMlMEElMjAlMjAlMjAlMjAlMjJvYnNlcnZhdGlvbi5zdGF0ZSUyMiUzQSUyMFBvbGljeUZlYXR1cmUoRmVhdHVyZVR5cGUuU1RBVEUlMkMlMjAoMiUyQykpJTJDJTBBJTIwJTIwJTIwJTIwJTIyYWN0aW9uJTIyJTNBJTIwUG9saWN5RmVhdHVyZShGZWF0dXJlVHlwZS5BQ1RJT04lMkMlMjAoMiUyQykpJTJDJTBBJTdEJTBBJTBBbm9ybV9tYXAlMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjBGZWF0dXJlVHlwZS5WSVNVQUwlM0ElMjBOb3JtYWxpemF0aW9uTW9kZS5NRUFOX1NURCUyQyUwQSUyMCUyMCUyMCUyMEZlYXR1cmVUeXBlLlNUQVRFJTNBJTIwTm9ybWFsaXphdGlvbk1vZGUuTUlOX01BWCUyQyUwQSUyMCUyMCUyMCUyMEZlYXR1cmVUeXBlLkFDVElPTiUzQSUyME5vcm1hbGl6YXRpb25Nb2RlLk1FQU5fU1REJTJDJTBBJTdEJTBBJTBBJTIzJTIwQ3JlYXRlJTIwcHJvY2Vzc29yJTIwd2l0aCUyMG5vcm1hbGl6YXRpb24lMEFwcm9jZXNzb3IlMjAlM0QlMjBSb2JvdFByb2Nlc3NvciglNUIlMEElMjAlMjAlMjAlMjBOb3JtYWxpemVyUHJvY2Vzc29yLmZyb21fbGVyb2JvdF9kYXRhc2V0KGRhdGFzZXQlMkMlMjBmZWF0dXJlcyUyQyUyMG5vcm1fbWFwKSUyQyUwQSU1RCklMEElMEElMjMlMjBQcm9jZXNzJTIwYSUyMGJhdGNoJTIwZnJvbSUyMHRoZSUyMGRhdGFzZXQlMEFiYXRjaCUyMCUzRCUyMGRhdGFzZXQlNUIwJTVEJTIwJTIwJTIzJTIwR2V0JTIwZmlyc3QlMjBiYXRjaCUwQXByaW50KCUyMk9yaWdpbmFsJTIwYmF0Y2glMjBrZXlzJTNBJTIyJTJDJTIwbGlzdChiYXRjaC5rZXlzKCkpKSUwQXByaW50KCUyMk9yaWdpbmFsJTIwaW1hZ2UlMjBzaGFwZSUzQSUyMiUyQyUyMGJhdGNoJTVCJTIyb2JzZXJ2YXRpb24uaW1hZ2UlMjIlNUQuc2hhcGUpJTBBJTBBJTIzJTIwUHJvY2VzcyUyMHRoZSUyMGJhdGNoJTIwLSUyMGF1dG9tYXRpY2FsbHklMjBjb252ZXJ0cyUyMHRvJTJGZnJvbSUyMGJhdGNoJTIwZm9ybWF0JTBBcHJvY2Vzc2VkX2JhdGNoJTIwJTNEJTIwcHJvY2Vzc29yKGJhdGNoKSUwQXByaW50KCUyMlByb2Nlc3NlZCUyMGJhdGNoJTIwa2V5cyUzQSUyMiUyQyUyMGxpc3QocHJvY2Vzc2VkX2JhdGNoLmtleXMoKSkpJTBBcHJpbnQoJTIyUHJvY2Vzc2VkJTIwaW1hZ2UlMjByYW5nZSUzQSUyMiUyQyUyMHByb2Nlc3NlZF9iYXRjaCU1QiUyMm9ic2VydmF0aW9uLmltYWdlJTIyJTVELm1pbigpLml0ZW0oKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMnRvJTIyJTJDJTIwcHJvY2Vzc2VkX2JhdGNoJTVCJTIyb2JzZXJ2YXRpb24uaW1hZ2UlMjIlNUQubWF4KCkuaXRlbSgpKSUwQSUwQSUyMyUyMFVzZSUyMHdpdGglMjBEYXRhTG9hZGVyJTBBZnJvbSUyMHRvcmNoLnV0aWxzLmRhdGElMjBpbXBvcnQlMjBEYXRhTG9hZGVyJTBBJTBBZGF0YWxvYWRlciUyMCUzRCUyMERhdGFMb2FkZXIoZGF0YXNldCUyQyUyMGJhdGNoX3NpemUlM0QzMiUyQyUyMHNodWZmbGUlM0RUcnVlKSUwQSUwQWZvciUyMGJhdGNoJTIwaW4lMjBkYXRhbG9hZGVyJTNBJTBBJTIwJTIwJTIwJTIwJTIzJTIwUHJvY2VzcyUyMGVudGlyZSUyMGJhdGNoJTIwYXQlMjBvbmNlJTBBJTIwJTIwJTIwJTIwcHJvY2Vzc2VkX2JhdGNoJTIwJTNEJTIwcHJvY2Vzc29yKGJhdGNoKSUwQSUwQSUyMCUyMCUyMCUyMCUyMyUyMFVzZSUyMHByb2Nlc3NlZCUyMGJhdGNoJTIwZm9yJTIwdHJhaW5pbmclMEElMjAlMjAlMjAlMjAlMjMlMjBtb2RlbC50cmFpbl9zdGVwKHByb2Nlc3NlZF9iYXRjaCklMEElMjAlMjAlMjAlMjBicmVhaw==",highlighted:`<span class="hljs-keyword">from</span> lerobot.datasets.lerobot_dataset <span class="hljs-keyword">import</span> LeRobotDataset
<span class="hljs-keyword">from</span> lerobot.processor.pipeline <span class="hljs-keyword">import</span> RobotProcessor
<span class="hljs-keyword">from</span> lerobot.processor.normalize_processor <span class="hljs-keyword">import</span> NormalizerProcessor
<span class="hljs-keyword">from</span> lerobot.configs.types <span class="hljs-keyword">import</span> FeatureType, NormalizationMode, PolicyFeature

<span class="hljs-comment"># Load a dataset</span>
dataset = LeRobotDataset(<span class="hljs-string">&quot;lerobot/pusht&quot;</span>)

<span class="hljs-comment"># Define features and normalization</span>
features = {
    <span class="hljs-string">&quot;observation.image&quot;</span>: PolicyFeature(FeatureType.VISUAL, (<span class="hljs-number">3</span>, <span class="hljs-number">96</span>, <span class="hljs-number">96</span>)),
    <span class="hljs-string">&quot;observation.state&quot;</span>: PolicyFeature(FeatureType.STATE, (<span class="hljs-number">2</span>,)),
    <span class="hljs-string">&quot;action&quot;</span>: PolicyFeature(FeatureType.ACTION, (<span class="hljs-number">2</span>,)),
}

norm_map = {
    FeatureType.VISUAL: NormalizationMode.MEAN_STD,
    FeatureType.STATE: NormalizationMode.MIN_MAX,
    FeatureType.ACTION: NormalizationMode.MEAN_STD,
}

<span class="hljs-comment"># Create processor with normalization</span>
processor = RobotProcessor([
    NormalizerProcessor.from_lerobot_dataset(dataset, features, norm_map),
])

<span class="hljs-comment"># Process a batch from the dataset</span>
batch = dataset[<span class="hljs-number">0</span>]  <span class="hljs-comment"># Get first batch</span>
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Original batch keys:&quot;</span>, <span class="hljs-built_in">list</span>(batch.keys()))
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Original image shape:&quot;</span>, batch[<span class="hljs-string">&quot;observation.image&quot;</span>].shape)

<span class="hljs-comment"># Process the batch - automatically converts to/from batch format</span>
processed_batch = processor(batch)
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Processed batch keys:&quot;</span>, <span class="hljs-built_in">list</span>(processed_batch.keys()))
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Processed image range:&quot;</span>, processed_batch[<span class="hljs-string">&quot;observation.image&quot;</span>].<span class="hljs-built_in">min</span>().item(),
      <span class="hljs-string">&quot;to&quot;</span>, processed_batch[<span class="hljs-string">&quot;observation.image&quot;</span>].<span class="hljs-built_in">max</span>().item())

<span class="hljs-comment"># Use with DataLoader</span>
<span class="hljs-keyword">from</span> torch.utils.data <span class="hljs-keyword">import</span> DataLoader

dataloader = DataLoader(dataset, batch_size=<span class="hljs-number">32</span>, shuffle=<span class="hljs-literal">True</span>)

<span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> dataloader:
    <span class="hljs-comment"># Process entire batch at once</span>
    processed_batch = processor(batch)

    <span class="hljs-comment"># Use processed batch for training</span>
    <span class="hljs-comment"># model.train_step(processed_batch)</span>
    <span class="hljs-keyword">break</span>`,wrap:!1}}),Wl=new w({props:{title:"Integration with Replay Buffers",local:"integration-with-replay-buffers",headingTag:"h2"}}),Xl=new U({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> lerobot.common.utils.buffer <span class="hljs-keyword">import</span> ReplayBuffer
<span class="hljs-keyword">from</span> lerobot.processor.pipeline <span class="hljs-keyword">import</span> RobotProcessor
<span class="hljs-keyword">from</span> lerobot.processor.device_processor <span class="hljs-keyword">import</span> DeviceProcessor

<span class="hljs-comment"># Create replay buffer</span>
buffer = ReplayBuffer(capacity=<span class="hljs-number">10000</span>)

<span class="hljs-comment"># Create processor for online data</span>
online_processor = RobotProcessor([
    ImageProcessor(),
    StateProcessor(),
    DeviceProcessor(device=<span class="hljs-string">&quot;cuda&quot;</span>),
])

<span class="hljs-comment"># During environment interaction</span>
env = make_env()
obs, info = env.reset()

<span class="hljs-keyword">for</span> step <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">1000</span>):
    <span class="hljs-comment"># Raw environment observation</span>
    transition = (obs, <span class="hljs-literal">None</span>, <span class="hljs-number">0.0</span>, <span class="hljs-literal">False</span>, <span class="hljs-literal">False</span>, info, {})

    <span class="hljs-comment"># Process for policy input</span>
    processed_transition = online_processor(transition)
    processed_obs = processed_transition[TransitionIndex.OBSERVATION]

    <span class="hljs-comment"># Get action from policy</span>
    action = policy.select_action(processed_obs)

    <span class="hljs-comment"># Execute action</span>
    next_obs, reward, done, truncated, info = env.step(action)

    <span class="hljs-comment"># Store in replay buffer (can store either format)</span>
    buffer.add(obs, action, reward, next_obs, done, truncated, info)

    obs = next_obs
    <span class="hljs-keyword">if</span> done <span class="hljs-keyword">or</span> truncated:
        obs, info = env.reset()

<span class="hljs-comment"># Sample and process batches for training</span>
batch = buffer.sample(batch_size=<span class="hljs-number">32</span>)
processed_batch = online_processor(batch)  <span class="hljs-comment"># Processes entire batch</span>`,wrap:!1}}),Vl=new w({props:{title:"Creating Custom Steps: The ProcessorStep Protocol",local:"creating-custom-steps-the-processorstep-protocol",headingTag:"h2"}}),kl=new U({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> dataclasses <span class="hljs-keyword">import</span> dataclass
<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">Any</span>, <span class="hljs-type">Dict</span>
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> torch.nn.functional <span class="hljs-keyword">as</span> F

<span class="hljs-meta">@dataclass</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">ImagePadder</span>:
    <span class="hljs-string">&quot;&quot;&quot;Pad images to a standard size for batch processing.&quot;&quot;&quot;</span>

    target_height: <span class="hljs-built_in">int</span> = <span class="hljs-number">224</span>
    target_width: <span class="hljs-built_in">int</span> = <span class="hljs-number">224</span>
    pad_value: <span class="hljs-built_in">float</span> = <span class="hljs-number">0.0</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__call__</span>(<span class="hljs-params">self, transition: EnvTransition</span>) -&gt; EnvTransition:
        <span class="hljs-string">&quot;&quot;&quot;Main processing method - required for all steps.&quot;&quot;&quot;</span>
        obs = transition[TransitionIndex.OBSERVATION]

        <span class="hljs-keyword">if</span> obs <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span>:
            <span class="hljs-keyword">return</span> transition

        <span class="hljs-comment"># Process all image observations</span>
        <span class="hljs-keyword">for</span> key <span class="hljs-keyword">in</span> <span class="hljs-built_in">list</span>(obs.keys()):
            <span class="hljs-keyword">if</span> key.startswith(<span class="hljs-string">&quot;observation.images.&quot;</span>):
                img = obs[key]
                <span class="hljs-comment"># Calculate padding</span>
                _, _, h, w = img.shape
                pad_h = <span class="hljs-built_in">max</span>(<span class="hljs-number">0</span>, self.target_height - h)
                pad_w = <span class="hljs-built_in">max</span>(<span class="hljs-number">0</span>, self.target_width - w)

                <span class="hljs-keyword">if</span> pad_h &gt; <span class="hljs-number">0</span> <span class="hljs-keyword">or</span> pad_w &gt; <span class="hljs-number">0</span>:
                    <span class="hljs-comment"># Pad symmetrically</span>
                    pad_left = pad_w // <span class="hljs-number">2</span>
                    pad_right = pad_w - pad_left
                    pad_top = pad_h // <span class="hljs-number">2</span>
                    pad_bottom = pad_h - pad_top

                    img = F.pad(img, (pad_left, pad_right, pad_top, pad_bottom),
                               mode=<span class="hljs-string">&#x27;constant&#x27;</span>, value=self.pad_value)

                obs[key] = img

        <span class="hljs-comment"># Return modified transition</span>
        <span class="hljs-keyword">return</span> (obs, *transition[<span class="hljs-number">1</span>:])

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">get_config</span>(<span class="hljs-params">self</span>) -&gt; <span class="hljs-type">Dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-type">Any</span>]:
        <span class="hljs-string">&quot;&quot;&quot;Return JSON-serializable configuration - required for save/load.&quot;&quot;&quot;</span>
        <span class="hljs-keyword">return</span> {
            <span class="hljs-string">&quot;target_height&quot;</span>: self.target_height,
            <span class="hljs-string">&quot;target_width&quot;</span>: self.target_width,
            <span class="hljs-string">&quot;pad_value&quot;</span>: self.pad_value
        }

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">state_dict</span>(<span class="hljs-params">self</span>) -&gt; <span class="hljs-type">Dict</span>[<span class="hljs-built_in">str</span>, torch.Tensor]:
        <span class="hljs-string">&quot;&quot;&quot;Return tensor state - only include torch.Tensor objects!&quot;&quot;&quot;</span>
        <span class="hljs-comment"># This step has no learnable parameters</span>
        <span class="hljs-keyword">return</span> {}

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">load_state_dict</span>(<span class="hljs-params">self, state: <span class="hljs-type">Dict</span>[<span class="hljs-built_in">str</span>, torch.Tensor]</span>) -&gt; <span class="hljs-literal">None</span>:
        <span class="hljs-string">&quot;&quot;&quot;Load tensor state - required if state_dict returns non-empty dict.&quot;&quot;&quot;</span>
        <span class="hljs-comment"># Nothing to load for this step</span>
        <span class="hljs-keyword">pass</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">reset</span>(<span class="hljs-params">self</span>) -&gt; <span class="hljs-literal">None</span>:
        <span class="hljs-string">&quot;&quot;&quot;Reset internal state at episode boundaries - required for stateful steps.&quot;&quot;&quot;</span>
        <span class="hljs-comment"># This step is stateless, so nothing to reset</span>
        <span class="hljs-keyword">pass</span>`,wrap:!1}}),zl=new w({props:{title:"Important: get_config vs state_dict",local:"important-getconfig-vs-statedict",headingTag:"h3"}}),Fl=new U({props:{code:"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",highlighted:`<span class="hljs-meta">@dataclass</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">AdaptiveNormalizer</span>:
    <span class="hljs-string">&quot;&quot;&quot;Example showing proper use of get_config and state_dict.&quot;&quot;&quot;</span>

    learning_rate: <span class="hljs-built_in">float</span> = <span class="hljs-number">0.01</span>
    epsilon: <span class="hljs-built_in">float</span> = <span class="hljs-number">1e-8</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__post_init__</span>(<span class="hljs-params">self</span>):
        self.running_mean = <span class="hljs-literal">None</span>
        self.running_var = <span class="hljs-literal">None</span>
        self.num_samples = <span class="hljs-number">0</span>  <span class="hljs-comment"># Python int, not tensor</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">get_config</span>(<span class="hljs-params">self</span>) -&gt; <span class="hljs-type">Dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-type">Any</span>]:
        <span class="hljs-string">&quot;&quot;&quot;ONLY Python objects that can be JSON serialized!&quot;&quot;&quot;</span>
        <span class="hljs-keyword">return</span> {
            <span class="hljs-string">&quot;learning_rate&quot;</span>: self.learning_rate,  <span class="hljs-comment"># float ✓</span>
            <span class="hljs-string">&quot;epsilon&quot;</span>: self.epsilon,              <span class="hljs-comment"># float ✓</span>
            <span class="hljs-string">&quot;num_samples&quot;</span>: self.num_samples,      <span class="hljs-comment"># int ✓</span>
            <span class="hljs-comment"># &quot;running_mean&quot;: self.running_mean,  # torch.Tensor ✗ WRONG!</span>
        }

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">state_dict</span>(<span class="hljs-params">self</span>) -&gt; <span class="hljs-type">Dict</span>[<span class="hljs-built_in">str</span>, torch.Tensor]:
        <span class="hljs-string">&quot;&quot;&quot;ONLY torch.Tensor objects!&quot;&quot;&quot;</span>
        <span class="hljs-keyword">if</span> self.running_mean <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span>:
            <span class="hljs-keyword">return</span> {}
        <span class="hljs-keyword">return</span> {
            <span class="hljs-string">&quot;running_mean&quot;</span>: self.running_mean,    <span class="hljs-comment"># torch.Tensor ✓</span>
            <span class="hljs-string">&quot;running_var&quot;</span>: self.running_var,      <span class="hljs-comment"># torch.Tensor ✓</span>
            <span class="hljs-comment"># &quot;num_samples&quot;: self.num_samples,    # int ✗ WRONG!</span>
            <span class="hljs-comment"># Instead, convert to tensor if needed:</span>
            <span class="hljs-string">&quot;num_samples_tensor&quot;</span>: torch.tensor(self.num_samples)
        }

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">load_state_dict</span>(<span class="hljs-params">self, state: <span class="hljs-type">Dict</span>[<span class="hljs-built_in">str</span>, torch.Tensor]</span>) -&gt; <span class="hljs-literal">None</span>:
        <span class="hljs-string">&quot;&quot;&quot;Load tensors and convert back to Python types if needed.&quot;&quot;&quot;</span>
        self.running_mean = state.get(<span class="hljs-string">&quot;running_mean&quot;</span>)
        self.running_var = state.get(<span class="hljs-string">&quot;running_var&quot;</span>)
        <span class="hljs-keyword">if</span> <span class="hljs-string">&quot;num_samples_tensor&quot;</span> <span class="hljs-keyword">in</span> state:
            self.num_samples = <span class="hljs-built_in">int</span>(state[<span class="hljs-string">&quot;num_samples_tensor&quot;</span>].item())`,wrap:!1}}),_l=new w({props:{title:"Using Complementary Data for Inter-Step Communication",local:"using-complementary-data-for-inter-step-communication",headingTag:"h2"}}),Hl=new U({props:{code:"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",highlighted:`<span class="hljs-meta">@dataclass</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">ImageStatisticsCalculator</span>:
    <span class="hljs-string">&quot;&quot;&quot;Calculate image statistics and pass to next steps.&quot;&quot;&quot;</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__call__</span>(<span class="hljs-params">self, transition: EnvTransition</span>) -&gt; EnvTransition:
        obs = transition[TransitionIndex.OBSERVATION]
        comp_data = transition[TransitionIndex.COMPLEMENTARY_DATA] <span class="hljs-keyword">or</span> {}

        <span class="hljs-keyword">if</span> obs <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span>:
            <span class="hljs-keyword">return</span> transition

        <span class="hljs-comment"># Calculate statistics for all images</span>
        image_stats = {}
        <span class="hljs-keyword">for</span> key <span class="hljs-keyword">in</span> obs:
            <span class="hljs-keyword">if</span> key.startswith(<span class="hljs-string">&quot;observation.images.&quot;</span>):
                img = obs[key]
                stats = {
                    <span class="hljs-string">&quot;mean&quot;</span>: img.mean().item(),
                    <span class="hljs-string">&quot;std&quot;</span>: img.std().item(),
                    <span class="hljs-string">&quot;min&quot;</span>: img.<span class="hljs-built_in">min</span>().item(),
                    <span class="hljs-string">&quot;max&quot;</span>: img.<span class="hljs-built_in">max</span>().item(),
                }
                image_stats[key] = stats

        <span class="hljs-comment"># Store in complementary_data for next steps</span>
        comp_data[<span class="hljs-string">&quot;image_statistics&quot;</span>] = image_stats

        <span class="hljs-comment"># Return transition with updated complementary_data</span>
        <span class="hljs-keyword">return</span> (
            obs,
            transition[TransitionIndex.ACTION],
            transition[TransitionIndex.REWARD],
            transition[TransitionIndex.DONE],
            transition[TransitionIndex.TRUNCATED],
            transition[TransitionIndex.INFO],
            comp_data  <span class="hljs-comment"># Updated complementary_data</span>
        )

<span class="hljs-meta">@dataclass</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">AdaptiveBrightnessAdjuster</span>:
    <span class="hljs-string">&quot;&quot;&quot;Adjust brightness based on statistics from previous step.&quot;&quot;&quot;</span>

    target_brightness: <span class="hljs-built_in">float</span> = <span class="hljs-number">0.5</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__call__</span>(<span class="hljs-params">self, transition: EnvTransition</span>) -&gt; EnvTransition:
        obs = transition[TransitionIndex.OBSERVATION]
        comp_data = transition[TransitionIndex.COMPLEMENTARY_DATA] <span class="hljs-keyword">or</span> {}

        <span class="hljs-keyword">if</span> obs <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span> <span class="hljs-keyword">or</span> <span class="hljs-string">&quot;image_statistics&quot;</span> <span class="hljs-keyword">not</span> <span class="hljs-keyword">in</span> comp_data:
            <span class="hljs-keyword">return</span> transition

        <span class="hljs-comment"># Use statistics from previous step</span>
        image_stats = comp_data[<span class="hljs-string">&quot;image_statistics&quot;</span>]

        <span class="hljs-keyword">for</span> key <span class="hljs-keyword">in</span> obs:
            <span class="hljs-keyword">if</span> key.startswith(<span class="hljs-string">&quot;observation.images.&quot;</span>) <span class="hljs-keyword">and</span> key <span class="hljs-keyword">in</span> image_stats:
                current_mean = image_stats[key][<span class="hljs-string">&quot;mean&quot;</span>]
                brightness_adjust = self.target_brightness - current_mean

                <span class="hljs-comment"># Adjust brightness</span>
                obs[key] = torch.clamp(obs[key] + brightness_adjust, <span class="hljs-number">0</span>, <span class="hljs-number">1</span>)

        <span class="hljs-keyword">return</span> (obs, *transition[<span class="hljs-number">1</span>:])

<span class="hljs-comment"># Use them together</span>
processor = RobotProcessor([
    ImageProcessor(),
    ImageStatisticsCalculator(),  <span class="hljs-comment"># Calculates stats</span>
    AdaptiveBrightnessAdjuster(), <span class="hljs-comment"># Uses stats from previous step</span>
])`,wrap:!1}}),$l=new w({props:{title:"Loading Processors with Overrides: Handling Non-Serializable Objects",local:"loading-processors-with-overrides-handling-non-serializable-objects",headingTag:"h2"}}),Dl=new w({props:{title:"The Problem: Non-Serializable Parameters",local:"the-problem-non-serializable-parameters",headingTag:"h3"}}),Pl=new U({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> dataclasses <span class="hljs-keyword">import</span> dataclass
<span class="hljs-keyword">import</span> gym

<span class="hljs-meta">@ProcessorStepRegistry.register(<span class="hljs-params"><span class="hljs-string">&quot;action_repeat_step&quot;</span></span>)</span>
<span class="hljs-meta">@dataclass</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">ActionRepeatStep</span>:
    <span class="hljs-string">&quot;&quot;&quot;Step that repeats actions using environment feedback.&quot;&quot;&quot;</span>

    repeat_count: <span class="hljs-built_in">int</span> = <span class="hljs-number">3</span>
    env: gym.Env = <span class="hljs-literal">None</span>  <span class="hljs-comment"># This can&#x27;t be serialized to JSON!</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__call__</span>(<span class="hljs-params">self, transition: EnvTransition</span>) -&gt; EnvTransition:
        obs, action, reward, done, truncated, info, comp_data = transition

        <span class="hljs-keyword">if</span> self.env <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span> <span class="hljs-keyword">and</span> action <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>:
            <span class="hljs-comment"># Repeat action multiple times in environment</span>
            total_reward = <span class="hljs-number">0</span>
            <span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(self.repeat_count):
                _, r, d, t, _ = self.env.step(action)
                total_reward += r
                <span class="hljs-keyword">if</span> d <span class="hljs-keyword">or</span> t:
                    <span class="hljs-keyword">break</span>
            reward = total_reward

        <span class="hljs-keyword">return</span> (obs, action, reward, done, truncated, info, comp_data)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">get_config</span>(<span class="hljs-params">self</span>) -&gt; <span class="hljs-built_in">dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-type">Any</span>]:
        <span class="hljs-comment"># Note: env is NOT included because it&#x27;s not serializable</span>
        <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;repeat_count&quot;</span>: self.repeat_count}

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">state_dict</span>(<span class="hljs-params">self</span>) -&gt; <span class="hljs-built_in">dict</span>[<span class="hljs-built_in">str</span>, torch.Tensor]:
        <span class="hljs-keyword">return</span> {}

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">load_state_dict</span>(<span class="hljs-params">self, state: <span class="hljs-built_in">dict</span>[<span class="hljs-built_in">str</span>, torch.Tensor]</span>) -&gt; <span class="hljs-literal">None</span>:
        <span class="hljs-keyword">pass</span>`,wrap:!1}}),Ol=new w({props:{title:"The Solution: Override Parameters",local:"the-solution-override-parameters",headingTag:"h3"}}),ss=new U({props:{code:"ZnJvbSUyMGxlcm9ib3QucHJvY2Vzc29yLnBpcGVsaW5lJTIwaW1wb3J0JTIwUm9ib3RQcm9jZXNzb3IlMEElMEElMjMlMjBDcmVhdGUlMjBwcm9jZXNzb3IlMjB3aXRoJTIwZW52aXJvbm1lbnQlMEFlbnYlMjAlM0QlMjBneW0ubWFrZSglMjJDYXJ0UG9sZS12MSUyMiklMEFhY3Rpb25fc3RlcCUyMCUzRCUyMEFjdGlvblJlcGVhdFN0ZXAocmVwZWF0X2NvdW50JTNEMiUyQyUyMGVudiUzRGVudiklMEFwcm9jZXNzb3IlMjAlM0QlMjBSb2JvdFByb2Nlc3NvciglNUJhY3Rpb25fc3RlcCU1RCUyQyUyMG5hbWUlM0QlMjJDYXJ0UG9sZVByb2Nlc3NvciUyMiklMEElMEElMjMlMjBTYXZlJTIwdGhlJTIwcHJvY2Vzc29yJTIwKGVudiUyMHdvbid0JTIwYmUlMjBzYXZlZCklMEFwcm9jZXNzb3Iuc2F2ZV9wcmV0cmFpbmVkKCUyMi4lMkZjYXJ0cG9sZV9wcm9jZXNzb3IlMjIpJTBBJTBBJTIzJTIwTGF0ZXIlMkMlMjBsb2FkJTIwd2l0aCUyMGVudmlyb25tZW50JTIwb3ZlcnJpZGUlMEFuZXdfZW52JTIwJTNEJTIwZ3ltLm1ha2UoJTIyQ2FydFBvbGUtdjElMjIpJTBBbG9hZGVkX3Byb2Nlc3NvciUyMCUzRCUyMFJvYm90UHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjIuJTJGY2FydHBvbGVfcHJvY2Vzc29yJTIyJTJDJTBBJTIwJTIwJTIwJTIwb3ZlcnJpZGVzJTNEJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyYWN0aW9uX3JlcGVhdF9zdGVwJTIyJTNBJTIwJTdCJTIyZW52JTIyJTNBJTIwbmV3X2VudiU3RCUyMCUyMCUyMyUyMFByb3ZpZGUlMjB0aGUlMjBlbnZpcm9ubWVudCUwQSUyMCUyMCUyMCUyMCU3RCUwQSk=",highlighted:`<span class="hljs-keyword">from</span> lerobot.processor.pipeline <span class="hljs-keyword">import</span> RobotProcessor

<span class="hljs-comment"># Create processor with environment</span>
env = gym.make(<span class="hljs-string">&quot;CartPole-v1&quot;</span>)
action_step = ActionRepeatStep(repeat_count=<span class="hljs-number">2</span>, env=env)
processor = RobotProcessor([action_step], name=<span class="hljs-string">&quot;CartPoleProcessor&quot;</span>)

<span class="hljs-comment"># Save the processor (env won&#x27;t be saved)</span>
processor.save_pretrained(<span class="hljs-string">&quot;./cartpole_processor&quot;</span>)

<span class="hljs-comment"># Later, load with environment override</span>
new_env = gym.make(<span class="hljs-string">&quot;CartPole-v1&quot;</span>)
loaded_processor = RobotProcessor.from_pretrained(
    <span class="hljs-string">&quot;./cartpole_processor&quot;</span>,
    overrides={
        <span class="hljs-string">&quot;action_repeat_step&quot;</span>: {<span class="hljs-string">&quot;env&quot;</span>: new_env}  <span class="hljs-comment"># Provide the environment</span>
    }
)`,wrap:!1}}),as=new w({props:{title:"How Overrides Work",local:"how-overrides-work",headingTag:"h3"}}),ts=new U({props:{code:"b3ZlcnJpZGVzJTIwJTNEJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIyU3RlcENsYXNzTmFtZSUyMiUzQSUyMCU3QiUyMnBhcmFtMSUyMiUzQSUyMCUyMm5ld192YWx1ZSUyMiUyQyUyMCUyMnBhcmFtMiUyMiUzQSUyMDQyJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIycmVnaXN0ZXJlZF9zdGVwX25hbWUlMjIlM0ElMjAlN0IlMjJkZXZpY2UlMjIlM0ElMjAlMjJjdWRhJTIyJTJDJTIwJTIybGVhcm5pbmdfcmF0ZSUyMiUzQSUyMDAuMDElN0QlMEElN0Q=",highlighted:`overrides = {
    <span class="hljs-string">&quot;StepClassName&quot;</span>: {<span class="hljs-string">&quot;param1&quot;</span>: <span class="hljs-string">&quot;new_value&quot;</span>, <span class="hljs-string">&quot;param2&quot;</span>: <span class="hljs-number">42</span>},
    <span class="hljs-string">&quot;registered_step_name&quot;</span>: {<span class="hljs-string">&quot;device&quot;</span>: <span class="hljs-string">&quot;cuda&quot;</span>, <span class="hljs-string">&quot;learning_rate&quot;</span>: <span class="hljs-number">0.01</span>}
}`,wrap:!1}}),ys=new w({props:{title:"Real-World Examples",local:"real-world-examples",headingTag:"h3"}}),ps=new w({props:{title:"Example 1: Environment-Dependent Steps",local:"example-1-environment-dependent-steps",headingTag:"h4"}}),js=new U({props:{code:"JTQwUHJvY2Vzc29yU3RlcFJlZ2lzdHJ5LnJlZ2lzdGVyKCUyMmlrX3NvbHZlcl9zdGVwJTIyKSUwQSU0MGRhdGFjbGFzcyUwQWNsYXNzJTIwSW52ZXJzZUtpbmVtYXRpY3NTdGVwJTNBJTBBJTIwJTIwJTIwJTIwJTIyJTIyJTIyQ29udmVydCUyMENhcnRlc2lhbiUyMHBvc2l0aW9ucyUyMHRvJTIwam9pbnQlMjBhbmdsZXMuJTIyJTIyJTIyJTBBJTBBJTIwJTIwJTIwJTIwcm9ib3RfbW9kZWwlM0ElMjBzdHIlMjAlM0QlMjAlMjJ1cjUlMjIlMEElMjAlMjAlMjAlMjBzb2x2ZXJfdGltZW91dCUzQSUyMGZsb2F0JTIwJTNEJTIwMC4xJTBBJTIwJTIwJTIwJTIwa2luZW1hdGljc19zb2x2ZXIlM0ElMjBBbnklMjAlM0QlMjBOb25lJTIwJTIwJTIzJTIwTm9uLXNlcmlhbGl6YWJsZSUyMHNvbHZlciUyMGluc3RhbmNlJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwX19jYWxsX18oc2VsZiUyQyUyMHRyYW5zaXRpb24lM0ElMjBFbnZUcmFuc2l0aW9uKSUyMC0lM0UlMjBFbnZUcmFuc2l0aW9uJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb2JzJTJDJTIwYWN0aW9uJTJDJTIwcmV3YXJkJTJDJTIwZG9uZSUyQyUyMHRydW5jYXRlZCUyQyUyMGluZm8lMkMlMjBjb21wX2RhdGElMjAlM0QlMjB0cmFuc2l0aW9uJTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjBzZWxmLmtpbmVtYXRpY3Nfc29sdmVyJTIwaXMlMjBub3QlMjBOb25lJTIwYW5kJTIwYWN0aW9uJTIwaXMlMjBub3QlMjBOb25lJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwQ29udmVydCUyMENhcnRlc2lhbiUyMGFjdGlvbiUyMHRvJTIwam9pbnQlMjBhbmdsZXMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBqb2ludF9hbmdsZXMlMjAlM0QlMjBzZWxmLmtpbmVtYXRpY3Nfc29sdmVyLnNvbHZlKGFjdGlvbiUyQyUyMHRpbWVvdXQlM0RzZWxmLnNvbHZlcl90aW1lb3V0KSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGFjdGlvbiUyMCUzRCUyMGpvaW50X2FuZ2xlcyUwQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMChvYnMlMkMlMjBhY3Rpb24lMkMlMjByZXdhcmQlMkMlMjBkb25lJTJDJTIwdHJ1bmNhdGVkJTJDJTIwaW5mbyUyQyUyMGNvbXBfZGF0YSklMEElMEElMjAlMjAlMjAlMjBkZWYlMjBnZXRfY29uZmlnKHNlbGYpJTIwLSUzRSUyMGRpY3QlNUJzdHIlMkMlMjBBbnklNUQlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJyb2JvdF9tb2RlbCUyMiUzQSUyMHNlbGYucm9ib3RfbW9kZWwlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJzb2x2ZXJfdGltZW91dCUyMiUzQSUyMHNlbGYuc29sdmVyX3RpbWVvdXQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0QlMEElMEElMjMlMjBTYXZlJTIwcHJvY2Vzc29yJTIwd2l0aG91dCUyMHNvbHZlciUwQXByb2Nlc3NvciUyMCUzRCUyMFJvYm90UHJvY2Vzc29yKCU1QkludmVyc2VLaW5lbWF0aWNzU3RlcChyb2JvdF9tb2RlbCUzRCUyMnVyNSUyMiklNUQpJTBBcHJvY2Vzc29yLnNhdmVfcHJldHJhaW5lZCglMjIuJTJGcm9ib3RfcHJvY2Vzc29yJTIyKSUwQSUwQSUyMyUyMExvYWQlMjB3aXRoJTIwc29sdmVyJTIwaW5zdGFuY2UlMEFmcm9tJTIwcm9ib3RpY3NfdG9vbGJveCUyMGltcG9ydCUyMFVSS2luZW1hdGljcyUwQXNvbHZlciUyMCUzRCUyMFVSS2luZW1hdGljcyglMjJ1cjUlMjIpJTBBJTBBbG9hZGVkX3Byb2Nlc3NvciUyMCUzRCUyMFJvYm90UHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjIuJTJGcm9ib3RfcHJvY2Vzc29yJTIyJTJDJTBBJTIwJTIwJTIwJTIwb3ZlcnJpZGVzJTNEJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyaWtfc29sdmVyX3N0ZXAlMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJraW5lbWF0aWNzX3NvbHZlciUyMiUzQSUyMHNvbHZlciUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnNvbHZlcl90aW1lb3V0JTIyJTNBJTIwMC4wNSUyMCUyMCUyMyUyMEFsc28lMjBvdmVycmlkZSUyMHRpbWVvdXQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlMjAlMjAlN0QlMEEp",highlighted:`<span class="hljs-meta">@ProcessorStepRegistry.register(<span class="hljs-params"><span class="hljs-string">&quot;ik_solver_step&quot;</span></span>)</span>
<span class="hljs-meta">@dataclass</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">InverseKinematicsStep</span>:
    <span class="hljs-string">&quot;&quot;&quot;Convert Cartesian positions to joint angles.&quot;&quot;&quot;</span>

    robot_model: <span class="hljs-built_in">str</span> = <span class="hljs-string">&quot;ur5&quot;</span>
    solver_timeout: <span class="hljs-built_in">float</span> = <span class="hljs-number">0.1</span>
    kinematics_solver: <span class="hljs-type">Any</span> = <span class="hljs-literal">None</span>  <span class="hljs-comment"># Non-serializable solver instance</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__call__</span>(<span class="hljs-params">self, transition: EnvTransition</span>) -&gt; EnvTransition:
        obs, action, reward, done, truncated, info, comp_data = transition

        <span class="hljs-keyword">if</span> self.kinematics_solver <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span> <span class="hljs-keyword">and</span> action <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>:
            <span class="hljs-comment"># Convert Cartesian action to joint angles</span>
            joint_angles = self.kinematics_solver.solve(action, timeout=self.solver_timeout)
            action = joint_angles

        <span class="hljs-keyword">return</span> (obs, action, reward, done, truncated, info, comp_data)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">get_config</span>(<span class="hljs-params">self</span>) -&gt; <span class="hljs-built_in">dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-type">Any</span>]:
        <span class="hljs-keyword">return</span> {
            <span class="hljs-string">&quot;robot_model&quot;</span>: self.robot_model,
            <span class="hljs-string">&quot;solver_timeout&quot;</span>: self.solver_timeout
        }

<span class="hljs-comment"># Save processor without solver</span>
processor = RobotProcessor([InverseKinematicsStep(robot_model=<span class="hljs-string">&quot;ur5&quot;</span>)])
processor.save_pretrained(<span class="hljs-string">&quot;./robot_processor&quot;</span>)

<span class="hljs-comment"># Load with solver instance</span>
<span class="hljs-keyword">from</span> robotics_toolbox <span class="hljs-keyword">import</span> URKinematics
solver = URKinematics(<span class="hljs-string">&quot;ur5&quot;</span>)

loaded_processor = RobotProcessor.from_pretrained(
    <span class="hljs-string">&quot;./robot_processor&quot;</span>,
    overrides={
        <span class="hljs-string">&quot;ik_solver_step&quot;</span>: {
            <span class="hljs-string">&quot;kinematics_solver&quot;</span>: solver,
            <span class="hljs-string">&quot;solver_timeout&quot;</span>: <span class="hljs-number">0.05</span>  <span class="hljs-comment"># Also override timeout</span>
        }
    }
)`,wrap:!1}}),os=new w({props:{title:"Example 2: Device and Hardware Configuration",local:"example-2-device-and-hardware-configuration",headingTag:"h4"}}),Ts=new U({props:{code:"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",highlighted:`<span class="hljs-meta">@ProcessorStepRegistry.register(<span class="hljs-params"><span class="hljs-string">&quot;camera_capture_step&quot;</span></span>)</span>
<span class="hljs-meta">@dataclass</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">CameraCaptureStep</span>:
    <span class="hljs-string">&quot;&quot;&quot;Capture images from physical camera.&quot;&quot;&quot;</span>

    camera_id: <span class="hljs-built_in">int</span> = <span class="hljs-number">0</span>
    resolution: <span class="hljs-built_in">tuple</span> = (<span class="hljs-number">640</span>, <span class="hljs-number">480</span>)
    camera_interface: <span class="hljs-type">Any</span> = <span class="hljs-literal">None</span>  <span class="hljs-comment"># Hardware interface</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">get_config</span>(<span class="hljs-params">self</span>) -&gt; <span class="hljs-built_in">dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-type">Any</span>]:
        <span class="hljs-keyword">return</span> {
            <span class="hljs-string">&quot;camera_id&quot;</span>: self.camera_id,
            <span class="hljs-string">&quot;resolution&quot;</span>: self.resolution
        }

<span class="hljs-comment"># Deploy on different robots with different camera setups</span>
<span class="hljs-comment"># Robot A</span>
camera_a = CameraInterface(<span class="hljs-string">&quot;/dev/video0&quot;</span>)
processor_a = RobotProcessor.from_pretrained(
    <span class="hljs-string">&quot;shared/vision_processor&quot;</span>,
    overrides={
        <span class="hljs-string">&quot;camera_capture_step&quot;</span>: {
            <span class="hljs-string">&quot;camera_interface&quot;</span>: camera_a,
            <span class="hljs-string">&quot;resolution&quot;</span>: (<span class="hljs-number">1920</span>, <span class="hljs-number">1080</span>)  <span class="hljs-comment"># High-res camera</span>
        }
    }
)

<span class="hljs-comment"># Robot B</span>
camera_b = CameraInterface(<span class="hljs-string">&quot;/dev/video1&quot;</span>)
processor_b = RobotProcessor.from_pretrained(
    <span class="hljs-string">&quot;shared/vision_processor&quot;</span>,
    overrides={
        <span class="hljs-string">&quot;camera_capture_step&quot;</span>: {
            <span class="hljs-string">&quot;camera_interface&quot;</span>: camera_b,
            <span class="hljs-string">&quot;resolution&quot;</span>: (<span class="hljs-number">640</span>, <span class="hljs-number">480</span>)  <span class="hljs-comment"># Lower-res camera</span>
        }
    }
)`,wrap:!1}}),is=new w({props:{title:"Example 3: Multiple Environment Deployment",local:"example-3-multiple-environment-deployment",headingTag:"h4"}}),cs=new U({props:{code:"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",highlighted:`<span class="hljs-comment"># Training processor that works with simulation</span>
<span class="hljs-meta">@ProcessorStepRegistry.register(<span class="hljs-params"><span class="hljs-string">&quot;physics_validator&quot;</span></span>)</span>
<span class="hljs-meta">@dataclass</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">PhysicsValidatorStep</span>:
    <span class="hljs-string">&quot;&quot;&quot;Validate actions against physics constraints.&quot;&quot;&quot;</span>

    max_force: <span class="hljs-built_in">float</span> = <span class="hljs-number">100.0</span>
    physics_engine: <span class="hljs-type">Any</span> = <span class="hljs-literal">None</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">get_config</span>(<span class="hljs-params">self</span>) -&gt; <span class="hljs-built_in">dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-type">Any</span>]:
        <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;max_force&quot;</span>: self.max_force}

<span class="hljs-comment"># Different physics engines for different environments</span>
<span class="hljs-keyword">import</span> pybullet <span class="hljs-keyword">as</span> pb
<span class="hljs-keyword">import</span> mujoco

<span class="hljs-comment"># Simulation deployment</span>
sim_engine = pb.connect(pb.DIRECT)
sim_processor = RobotProcessor.from_pretrained(
    <span class="hljs-string">&quot;shared/control_processor&quot;</span>,
    overrides={
        <span class="hljs-string">&quot;physics_validator&quot;</span>: {
            <span class="hljs-string">&quot;physics_engine&quot;</span>: sim_engine,
            <span class="hljs-string">&quot;max_force&quot;</span>: <span class="hljs-number">150.0</span>  <span class="hljs-comment"># Higher limits in sim</span>
        }
    }
)

<span class="hljs-comment"># Real robot deployment</span>
real_engine = RealRobotInterface()
real_processor = RobotProcessor.from_pretrained(
    <span class="hljs-string">&quot;shared/control_processor&quot;</span>,
    overrides={
        <span class="hljs-string">&quot;physics_validator&quot;</span>: {
            <span class="hljs-string">&quot;physics_engine&quot;</span>: real_engine,
            <span class="hljs-string">&quot;max_force&quot;</span>: <span class="hljs-number">50.0</span>  <span class="hljs-comment"># Conservative limits on real robot</span>
        }
    }
)`,wrap:!1}}),ws=new w({props:{title:"Override Key Matching Rules",local:"override-key-matching-rules",headingTag:"h3"}}),rs=new w({props:{title:"For Registered Steps",local:"for-registered-steps",headingTag:"h4"}}),ms=new U({props:{code:"JTQwUHJvY2Vzc29yU3RlcFJlZ2lzdHJ5LnJlZ2lzdGVyKCUyMm15X2N1c3RvbV9zdGVwJTIyKSUwQWNsYXNzJTIwTXlTdGVwJTNBJTBBJTIwJTIwJTIwJTIwcGFzcyUwQSUwQSUyMyUyMFVzZSUyMHJlZ2lzdHJ5JTIwbmFtZSUyMGluJTIwb3ZlcnJpZGVzJTBBb3ZlcnJpZGVzJTIwJTNEJTIwJTdCJTIybXlfY3VzdG9tX3N0ZXAlMjIlM0ElMjAlN0IlMjJwYXJhbSUyMiUzQSUyMCUyMnZhbHVlJTIyJTdEJTdE",highlighted:`<span class="hljs-meta">@ProcessorStepRegistry.register(<span class="hljs-params"><span class="hljs-string">&quot;my_custom_step&quot;</span></span>)</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">MyStep</span>:
    <span class="hljs-keyword">pass</span>

<span class="hljs-comment"># Use registry name in overrides</span>
overrides = {<span class="hljs-string">&quot;my_custom_step&quot;</span>: {<span class="hljs-string">&quot;param&quot;</span>: <span class="hljs-string">&quot;value&quot;</span>}}`,wrap:!1}}),ds=new w({props:{title:"For Unregistered Steps",local:"for-unregistered-steps",headingTag:"h4"}}),bs=new U({props:{code:"Y2xhc3MlMjBNeVVucmVnaXN0ZXJlZFN0ZXAlM0ElMEElMjAlMjAlMjAlMjBwYXNzJTBBJTBBJTIzJTIwVXNlJTIwY2xhc3MlMjBuYW1lJTIwaW4lMjBvdmVycmlkZXMlMEFvdmVycmlkZXMlMjAlM0QlMjAlN0IlMjJNeVVucmVnaXN0ZXJlZFN0ZXAlMjIlM0ElMjAlN0IlMjJwYXJhbSUyMiUzQSUyMCUyMnZhbHVlJTIyJTdEJTdE",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">MyUnregisteredStep</span>:
    <span class="hljs-keyword">pass</span>

<span class="hljs-comment"># Use class name in overrides</span>
overrides = {<span class="hljs-string">&quot;MyUnregisteredStep&quot;</span>: {<span class="hljs-string">&quot;param&quot;</span>: <span class="hljs-string">&quot;value&quot;</span>}}`,wrap:!1}}),hs=new w({props:{title:"Error Handling and Validation",local:"error-handling-and-validation",headingTag:"h3"}}),As=new w({props:{title:"Invalid Override Keys",local:"invalid-override-keys",headingTag:"h4"}}),Bs=new U({props:{code:"JTIzJTIwVGhpcyUyMHdpbGwlMjByYWlzZSUyMEtleUVycm9yJTIwd2l0aCUyMGhlbHBmdWwlMjBtZXNzYWdlJTBBb3ZlcnJpZGVzJTIwJTNEJTIwJTdCJTIyTm9uRXhpc3RlbnRTdGVwJTIyJTNBJTIwJTdCJTIycGFyYW0lMjIlM0ElMjAlMjJ2YWx1ZSUyMiU3RCU3RCUwQSUwQXRyeSUzQSUwQSUyMCUyMCUyMCUyMHByb2Nlc3NvciUyMCUzRCUyMFJvYm90UHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjIuJTJGcHJvY2Vzc29yJTIyJTJDJTIwb3ZlcnJpZGVzJTNEb3ZlcnJpZGVzKSUwQWV4Y2VwdCUyMEtleUVycm9yJTIwYXMlMjBlJTNBJTBBJTIwJTIwJTIwJTIwcHJpbnQoZSklMEElMjAlMjAlMjAlMjAlMjMlMjBPdXRwdXQlM0ElMjBPdmVycmlkZSUyMGtleXMlMjAlNUInTm9uRXhpc3RlbnRTdGVwJyU1RCUyMGRvJTIwbm90JTIwbWF0Y2glMjBhbnklMjBzdGVwJTIwaW4lMjB0aGUlMjBzYXZlZCUyMGNvbmZpZ3VyYXRpb24uJTBBJTIwJTIwJTIwJTIwJTIzJTIwQXZhaWxhYmxlJTIwc3RlcCUyMGtleXMlM0ElMjAlNUInQWN0dWFsU3RlcE5hbWUnJTJDJTIwJ0Fub3RoZXJTdGVwTmFtZSclNUQ=",highlighted:`<span class="hljs-comment"># This will raise KeyError with helpful message</span>
overrides = {<span class="hljs-string">&quot;NonExistentStep&quot;</span>: {<span class="hljs-string">&quot;param&quot;</span>: <span class="hljs-string">&quot;value&quot;</span>}}

<span class="hljs-keyword">try</span>:
    processor = RobotProcessor.from_pretrained(<span class="hljs-string">&quot;./processor&quot;</span>, overrides=overrides)
<span class="hljs-keyword">except</span> KeyError <span class="hljs-keyword">as</span> e:
    <span class="hljs-built_in">print</span>(e)
    <span class="hljs-comment"># Output: Override keys [&#x27;NonExistentStep&#x27;] do not match any step in the saved configuration.</span>
    <span class="hljs-comment"># Available step keys: [&#x27;ActualStepName&#x27;, &#x27;AnotherStepName&#x27;]</span>`,wrap:!1}}),Zs=new w({props:{title:"Instantiation Errors",local:"instantiation-errors",headingTag:"h4"}}),fs=new U({props:{code:"JTIzJTIwSW52YWxpZCUyMHBhcmFtZXRlciUyMHR5cGVzJTIwYXJlJTIwY2F1Z2h0JTBBb3ZlcnJpZGVzJTIwJTNEJTIwJTdCJTIyTXlTdGVwJTIyJTNBJTIwJTdCJTIybnVtZXJpY19wYXJhbSUyMiUzQSUyMCUyMm5vdF9hX251bWJlciUyMiU3RCU3RCUwQSUwQXRyeSUzQSUwQSUyMCUyMCUyMCUyMHByb2Nlc3NvciUyMCUzRCUyMFJvYm90UHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjIuJTJGcHJvY2Vzc29yJTIyJTJDJTIwb3ZlcnJpZGVzJTNEb3ZlcnJpZGVzKSUwQWV4Y2VwdCUyMFZhbHVlRXJyb3IlMjBhcyUyMGUlM0ElMEElMjAlMjAlMjAlMjBwcmludChlKSUwQSUyMCUyMCUyMCUyMCUyMyUyME91dHB1dCUzQSUyMEZhaWxlZCUyMHRvJTIwaW5zdGFudGlhdGUlMjBwcm9jZXNzb3IlMjBzdGVwJTIwJ015U3RlcCclMjB3aXRoJTIwY29uZmlnJTNBJTIwJTdCLi4uJTdE",highlighted:`<span class="hljs-comment"># Invalid parameter types are caught</span>
overrides = {<span class="hljs-string">&quot;MyStep&quot;</span>: {<span class="hljs-string">&quot;numeric_param&quot;</span>: <span class="hljs-string">&quot;not_a_number&quot;</span>}}

<span class="hljs-keyword">try</span>:
    processor = RobotProcessor.from_pretrained(<span class="hljs-string">&quot;./processor&quot;</span>, overrides=overrides)
<span class="hljs-keyword">except</span> ValueError <span class="hljs-keyword">as</span> e:
    <span class="hljs-built_in">print</span>(e)
    <span class="hljs-comment"># Output: Failed to instantiate processor step &#x27;MyStep&#x27; with config: {...}</span>`,wrap:!1}}),vs=new w({props:{title:"Multiple Steps with Same Class Name",local:"multiple-steps-with-same-class-name",headingTag:"h3"}}),Gs=new U({props:{code:"c3RlcDElMjAlM0QlMjBNeVN0ZXAocGFyYW0lM0QxKSUwQXN0ZXAyJTIwJTNEJTIwTXlTdGVwKHBhcmFtJTNEMiklMEFwcm9jZXNzb3IlMjAlM0QlMjBSb2JvdFByb2Nlc3NvciglNUJzdGVwMSUyQyUyMHN0ZXAyJTVEKSUwQSUwQSUyMyUyMEJvdGglMjBzdGVwcyUyMHdpbGwlMjBnZXQlMjB0aGUlMjBvdmVycmlkZSUwQW92ZXJyaWRlcyUyMCUzRCUyMCU3QiUyMk15U3RlcCUyMiUzQSUyMCU3QiUyMnBhcmFtJTIyJTNBJTIwOTk5JTdEJTdEJTBBbG9hZGVkJTIwJTNEJTIwUm9ib3RQcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMi4lMkZwcm9jZXNzb3IlMjIlMkMlMjBvdmVycmlkZXMlM0RvdmVycmlkZXMpJTBBJTIzJTIwQm90aCUyMHN0ZXBzJTIwbm93JTIwaGF2ZSUyMHBhcmFtJTNEOTk5",highlighted:`step1 = MyStep(param=<span class="hljs-number">1</span>)
step2 = MyStep(param=<span class="hljs-number">2</span>)
processor = RobotProcessor([step1, step2])

<span class="hljs-comment"># Both steps will get the override</span>
overrides = {<span class="hljs-string">&quot;MyStep&quot;</span>: {<span class="hljs-string">&quot;param&quot;</span>: <span class="hljs-number">999</span>}}
loaded = RobotProcessor.from_pretrained(<span class="hljs-string">&quot;./processor&quot;</span>, overrides=overrides)
<span class="hljs-comment"># Both steps now have param=999</span>`,wrap:!1}}),Rs=new U({props:{code:"JTQwUHJvY2Vzc29yU3RlcFJlZ2lzdHJ5LnJlZ2lzdGVyKCUyMnN0ZXBfMSUyMiklMEFjbGFzcyUyME15U3RlcCUzQSUwQSUyMCUyMCUyMCUyMHBhc3MlMEElMEElNDBQcm9jZXNzb3JTdGVwUmVnaXN0cnkucmVnaXN0ZXIoJTIyc3RlcF8yJTIyKSUwQWNsYXNzJTIwTXlTdGVwJTNBJTIwJTIwJTIzJTIwU2FtZSUyMGNsYXNzJTJDJTIwZGlmZmVyZW50JTIwcmVnaXN0cnklMjBuYW1lcyUwQSUyMCUyMCUyMCUyMHBhc3MlMEElMEElMjMlMjBOb3clMjB5b3UlMjBjYW4lMjBvdmVycmlkZSUyMHRoZW0lMjBzZXBhcmF0ZWx5JTBBb3ZlcnJpZGVzJTIwJTNEJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIyc3RlcF8xJTIyJTNBJTIwJTdCJTIycGFyYW0lMjIlM0ElMjAxJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIyc3RlcF8yJTIyJTNBJTIwJTdCJTIycGFyYW0lMjIlM0ElMjAyJTdEJTBBJTdE",highlighted:`<span class="hljs-meta">@ProcessorStepRegistry.register(<span class="hljs-params"><span class="hljs-string">&quot;step_1&quot;</span></span>)</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">MyStep</span>:
    <span class="hljs-keyword">pass</span>

<span class="hljs-meta">@ProcessorStepRegistry.register(<span class="hljs-params"><span class="hljs-string">&quot;step_2&quot;</span></span>)</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">MyStep</span>:  <span class="hljs-comment"># Same class, different registry names</span>
    <span class="hljs-keyword">pass</span>

<span class="hljs-comment"># Now you can override them separately</span>
overrides = {
    <span class="hljs-string">&quot;step_1&quot;</span>: {<span class="hljs-string">&quot;param&quot;</span>: <span class="hljs-number">1</span>},
    <span class="hljs-string">&quot;step_2&quot;</span>: {<span class="hljs-string">&quot;param&quot;</span>: <span class="hljs-number">2</span>}
}`,wrap:!1}}),Es=new w({props:{title:"Best Practices for Overrides",local:"best-practices-for-overrides",headingTag:"h3"}}),Ws=new w({props:{title:"1. Design Steps for Overrides",local:"1-design-steps-for-overrides",headingTag:"h4"}}),Xs=new U({props:{code:"JTQwZGF0YWNsYXNzJTBBY2xhc3MlMjBXZWxsRGVzaWduZWRTdGVwJTNBJTBBJTIwJTIwJTIwJTIwJTIzJTIwU2VyaWFsaXphYmxlJTIwY29uZmlndXJhdGlvbiUwQSUyMCUyMCUyMCUyMHRpbWVvdXQlM0ElMjBmbG9hdCUyMCUzRCUyMDEuMCUwQSUyMCUyMCUyMCUyMHJldHJ5X2NvdW50JTNBJTIwaW50JTIwJTNEJTIwMyUwQSUwQSUyMCUyMCUyMCUyMCUyMyUyME5vbi1zZXJpYWxpemFibGUlMjBvYmplY3RzJTIwd2l0aCUyMGRlZmF1bHQlMjBOb25lJTBBJTIwJTIwJTIwJTIwZGF0YWJhc2UlM0ElMjBBbnklMjAlM0QlMjBOb25lJTBBJTIwJTIwJTIwJTIwYXBpX2NsaWVudCUzQSUyMEFueSUyMCUzRCUyME5vbmUlMEElMEElMjAlMjAlMjAlMjBkZWYlMjBfX3Bvc3RfaW5pdF9fKHNlbGYpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwVmFsaWRhdGUlMjB0aGF0JTIwcmVxdWlyZWQlMjBub24tc2VyaWFsaXphYmxlJTIwb2JqZWN0cyUyMGFyZSUyMHByb3ZpZGVkJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjBzZWxmLmRhdGFiYXNlJTIwaXMlMjBOb25lJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmFpc2UlMjBWYWx1ZUVycm9yKCUyMmRhdGFiYXNlJTIwbXVzdCUyMGJlJTIwcHJvdmlkZWQlMjB2aWElMjBvdmVycmlkZXMlMjIpJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwZ2V0X2NvbmZpZyhzZWxmKSUyMC0lM0UlMjBkaWN0JTVCc3RyJTJDJTIwQW55JTVEJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwT25seSUyMGluY2x1ZGUlMjBzZXJpYWxpemFibGUlMjBwYXJhbWV0ZXJzJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydGltZW91dCUyMiUzQSUyMHNlbGYudGltZW91dCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnJldHJ5X2NvdW50JTIyJTNBJTIwc2VsZi5yZXRyeV9jb3VudCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RA==",highlighted:`<span class="hljs-meta">@dataclass</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">WellDesignedStep</span>:
    <span class="hljs-comment"># Serializable configuration</span>
    timeout: <span class="hljs-built_in">float</span> = <span class="hljs-number">1.0</span>
    retry_count: <span class="hljs-built_in">int</span> = <span class="hljs-number">3</span>

    <span class="hljs-comment"># Non-serializable objects with default None</span>
    database: <span class="hljs-type">Any</span> = <span class="hljs-literal">None</span>
    api_client: <span class="hljs-type">Any</span> = <span class="hljs-literal">None</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__post_init__</span>(<span class="hljs-params">self</span>):
        <span class="hljs-comment"># Validate that required non-serializable objects are provided</span>
        <span class="hljs-keyword">if</span> self.database <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span>:
            <span class="hljs-keyword">raise</span> ValueError(<span class="hljs-string">&quot;database must be provided via overrides&quot;</span>)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">get_config</span>(<span class="hljs-params">self</span>) -&gt; <span class="hljs-built_in">dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-type">Any</span>]:
        <span class="hljs-comment"># Only include serializable parameters</span>
        <span class="hljs-keyword">return</span> {
            <span class="hljs-string">&quot;timeout&quot;</span>: self.timeout,
            <span class="hljs-string">&quot;retry_count&quot;</span>: self.retry_count
        }`,wrap:!1}}),Vs=new w({props:{title:"2. Use Registry Names for Clarity",local:"2-use-registry-names-for-clarity",headingTag:"h4"}}),ks=new U({props:{code:"JTQwUHJvY2Vzc29yU3RlcFJlZ2lzdHJ5LnJlZ2lzdGVyKCUyMnJvYm90X2FybV9jb250cm9sbGVyJTIyKSUwQWNsYXNzJTIwQXJtQ29udHJvbFN0ZXAlM0ElMEElMjAlMjAlMjAlMjBwYXNzJTBBJTBBJTQwUHJvY2Vzc29yU3RlcFJlZ2lzdHJ5LnJlZ2lzdGVyKCUyMmdyaXBwZXJfY29udHJvbGxlciUyMiklMEFjbGFzcyUyMEdyaXBwZXJDb250cm9sU3RlcCUzQSUwQSUyMCUyMCUyMCUyMHBhc3MlMEElMEElMjMlMjBDbGVhciUyMG92ZXJyaWRlJTIwa2V5cyUwQW92ZXJyaWRlcyUyMCUzRCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMnJvYm90X2FybV9jb250cm9sbGVyJTIyJTNBJTIwJTdCJTIyam9pbnRfbGltaXRzJTIyJTNBJTIwYXJtX2xpbWl0cyU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMmdyaXBwZXJfY29udHJvbGxlciUyMiUzQSUyMCU3QiUyMmZvcmNlX2xpbWl0JTIyJTNBJTIwZ3JpcHBlcl9mb3JjZSU3RCUwQSU3RA==",highlighted:`<span class="hljs-meta">@ProcessorStepRegistry.register(<span class="hljs-params"><span class="hljs-string">&quot;robot_arm_controller&quot;</span></span>)</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">ArmControlStep</span>:
    <span class="hljs-keyword">pass</span>

<span class="hljs-meta">@ProcessorStepRegistry.register(<span class="hljs-params"><span class="hljs-string">&quot;gripper_controller&quot;</span></span>)</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">GripperControlStep</span>:
    <span class="hljs-keyword">pass</span>

<span class="hljs-comment"># Clear override keys</span>
overrides = {
    <span class="hljs-string">&quot;robot_arm_controller&quot;</span>: {<span class="hljs-string">&quot;joint_limits&quot;</span>: arm_limits},
    <span class="hljs-string">&quot;gripper_controller&quot;</span>: {<span class="hljs-string">&quot;force_limit&quot;</span>: gripper_force}
}`,wrap:!1}}),zs=new w({props:{title:"3. Document Override Requirements",local:"3-document-override-requirements",headingTag:"h4"}}),Fs=new U({props:{code:"JTQwUHJvY2Vzc29yU3RlcFJlZ2lzdHJ5LnJlZ2lzdGVyKCUyMnZpc2lvbl9wcm9jZXNzb3IlMjIpJTBBY2xhc3MlMjBWaXNpb25Qcm9jZXNzb3IlM0ElMEElMjAlMjAlMjAlMjAlMjIlMjIlMjJQcm9jZXNzJTIwY2FtZXJhJTIwaW1hZ2VzJTIwZm9yJTIwcm9ib3QlMjB2aXNpb24uJTBBJTBBJTIwJTIwJTIwJTIwUmVxdWlyZWQlMjBvdmVycmlkZXMlMjB3aGVuJTIwbG9hZGluZyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGNhbWVyYV9pbnRlcmZhY2UlM0ElMjBIYXJkd2FyZSUyMGNhbWVyYSUyMGludGVyZmFjZSUyMG9iamVjdCUwQSUwQSUyMCUyMCUyMCUyME9wdGlvbmFsJTIwb3ZlcnJpZGVzJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmVzb2x1dGlvbiUzQSUyMENhbWVyYSUyMHJlc29sdXRpb24lMjB0dXBsZSUyMChkZWZhdWx0JTNBJTIwKDY0MCUyQyUyMDQ4MCkpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZnBzJTNBJTIwQ2FtZXJhJTIwZnJhbWUlMjByYXRlJTIwKGRlZmF1bHQlM0ElMjAzMCklMEElMjAlMjAlMjAlMjAlMjIlMjIlMjIlMEElMjAlMjAlMjAlMjBjYW1lcmFfaW50ZXJmYWNlJTNBJTIwQW55JTIwJTNEJTIwTm9uZSUwQSUyMCUyMCUyMCUyMHJlc29sdXRpb24lM0ElMjB0dXBsZSUyMCUzRCUyMCg2NDAlMkMlMjA0ODApJTBBJTIwJTIwJTIwJTIwZnBzJTNBJTIwaW50JTIwJTNEJTIwMzA=",highlighted:`<span class="hljs-meta">@ProcessorStepRegistry.register(<span class="hljs-params"><span class="hljs-string">&quot;vision_processor&quot;</span></span>)</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">VisionProcessor</span>:
    <span class="hljs-string">&quot;&quot;&quot;Process camera images for robot vision.

    Required overrides when loading:
        camera_interface: Hardware camera interface object

    Optional overrides:
        resolution: Camera resolution tuple (default: (640, 480))
        fps: Camera frame rate (default: 30)
    &quot;&quot;&quot;</span>
    camera_interface: <span class="hljs-type">Any</span> = <span class="hljs-literal">None</span>
    resolution: <span class="hljs-built_in">tuple</span> = (<span class="hljs-number">640</span>, <span class="hljs-number">480</span>)
    fps: <span class="hljs-built_in">int</span> = <span class="hljs-number">30</span>`,wrap:!1}}),_s=new w({props:{title:"4. Environment-Specific Configuration Files",local:"4-environment-specific-configuration-files",headingTag:"h4"}}),Hs=new U({props:{code:"JTIzJTIwY29uZmlnJTJGc2ltdWxhdGlvbi5weSUwQWRlZiUyMGdldF9zaW11bGF0aW9uX292ZXJyaWRlcygpJTNBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyY2FtZXJhX3N0ZXAlMjIlM0ElMjAlN0IlMjJjYW1lcmFfaW50ZXJmYWNlJTIyJTNBJTIwU2ltQ2FtZXJhKCklN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJwaHlzaWNzX3N0ZXAlMjIlM0ElMjAlN0IlMjJlbmdpbmUlMjIlM0ElMjBTaW1QaHlzaWNzKCklN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJjb250cm9sX3N0ZXAlMjIlM0ElMjAlN0IlMjJzYWZldHlfbGltaXRzJTIyJTNBJTIwRmFsc2UlN0QlMEElMjAlMjAlMjAlMjAlN0QlMEElMEElMjMlMjBjb25maWclMkZwcm9kdWN0aW9uLnB5JTBBZGVmJTIwZ2V0X3Byb2R1Y3Rpb25fb3ZlcnJpZGVzKCklM0ElMEElMjAlMjAlMjAlMjByZXR1cm4lMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJjYW1lcmFfc3RlcCUyMiUzQSUyMCU3QiUyMmNhbWVyYV9pbnRlcmZhY2UlMjIlM0ElMjBSZWFsQ2FtZXJhKCUyMiUyRmRldiUyRnZpZGVvMCUyMiklN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJwaHlzaWNzX3N0ZXAlMjIlM0ElMjAlN0IlMjJlbmdpbmUlMjIlM0ElMjBSZWFsUGh5c2ljcygpJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyY29udHJvbF9zdGVwJTIyJTNBJTIwJTdCJTIyc2FmZXR5X2xpbWl0cyUyMiUzQSUyMFRydWUlN0QlMEElMjAlMjAlMjAlMjAlN0QlMEElMEElMjMlMjBVc2FnZSUwQWZyb20lMjBjb25maWcucHJvZHVjdGlvbiUyMGltcG9ydCUyMGdldF9wcm9kdWN0aW9uX292ZXJyaWRlcyUwQXByb2Nlc3NvciUyMCUzRCUyMFJvYm90UHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJzaGFyZWQlMkZwcm9jZXNzb3IlMjIlMkMlMEElMjAlMjAlMjAlMjBvdmVycmlkZXMlM0RnZXRfcHJvZHVjdGlvbl9vdmVycmlkZXMoKSUwQSk=",highlighted:`<span class="hljs-comment"># config/simulation.py</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_simulation_overrides</span>():
    <span class="hljs-keyword">return</span> {
        <span class="hljs-string">&quot;camera_step&quot;</span>: {<span class="hljs-string">&quot;camera_interface&quot;</span>: SimCamera()},
        <span class="hljs-string">&quot;physics_step&quot;</span>: {<span class="hljs-string">&quot;engine&quot;</span>: SimPhysics()},
        <span class="hljs-string">&quot;control_step&quot;</span>: {<span class="hljs-string">&quot;safety_limits&quot;</span>: <span class="hljs-literal">False</span>}
    }

<span class="hljs-comment"># config/production.py</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_production_overrides</span>():
    <span class="hljs-keyword">return</span> {
        <span class="hljs-string">&quot;camera_step&quot;</span>: {<span class="hljs-string">&quot;camera_interface&quot;</span>: RealCamera(<span class="hljs-string">&quot;/dev/video0&quot;</span>)},
        <span class="hljs-string">&quot;physics_step&quot;</span>: {<span class="hljs-string">&quot;engine&quot;</span>: RealPhysics()},
        <span class="hljs-string">&quot;control_step&quot;</span>: {<span class="hljs-string">&quot;safety_limits&quot;</span>: <span class="hljs-literal">True</span>}
    }

<span class="hljs-comment"># Usage</span>
<span class="hljs-keyword">from</span> config.production <span class="hljs-keyword">import</span> get_production_overrides
processor = RobotProcessor.from_pretrained(
    <span class="hljs-string">&quot;shared/processor&quot;</span>,
    overrides=get_production_overrides()
)`,wrap:!1}}),$s=new w({props:{title:"Integration with Hub Sharing",local:"integration-with-hub-sharing",headingTag:"h3"}}),Ds=new U({props:{code:"JTIzJTIwU2F2ZSUyMHByb2Nlc3NvciUyMHdpdGhvdXQlMjBub24tc2VyaWFsaXphYmxlJTIwb2JqZWN0cyUwQXByb2Nlc3Nvci5wdXNoX3RvX2h1YiglMjJteS1sYWIlMkZyb2JvdC1wcm9jZXNzb3IlMjIpJTBBJTBBJTIzJTIwQW55b25lJTIwY2FuJTIwbG9hZCUyMGFuZCUyMHByb3ZpZGUlMjB0aGVpciUyMG93biUyMGVudmlyb25tZW50JTBBaW1wb3J0JTIwZ3ltJTBBbG9jYWxfZW52JTIwJTNEJTIwZ3ltLm1ha2UoJTIyTXlSb2JvdEVudi12MSUyMiklMEElMEFwcm9jZXNzb3IlMjAlM0QlMjBSb2JvdFByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIybXktbGFiJTJGcm9ib3QtcHJvY2Vzc29yJTIyJTJDJTBBJTIwJTIwJTIwJTIwb3ZlcnJpZGVzJTNEJTdCJTIyZW52X3N0ZXAlMjIlM0ElMjAlN0IlMjJlbnYlMjIlM0ElMjBsb2NhbF9lbnYlN0QlN0QlMEEp",highlighted:`<span class="hljs-comment"># Save processor without non-serializable objects</span>
processor.push_to_hub(<span class="hljs-string">&quot;my-lab/robot-processor&quot;</span>)

<span class="hljs-comment"># Anyone can load and provide their own environment</span>
<span class="hljs-keyword">import</span> gym
local_env = gym.make(<span class="hljs-string">&quot;MyRobotEnv-v1&quot;</span>)

processor = RobotProcessor.from_pretrained(
    <span class="hljs-string">&quot;my-lab/robot-processor&quot;</span>,
    overrides={<span class="hljs-string">&quot;env_step&quot;</span>: {<span class="hljs-string">&quot;env&quot;</span>: local_env}}
)`,wrap:!1}}),Ps=new w({props:{title:"Complete Example: Device-Aware Processing Pipeline",local:"complete-example-device-aware-processing-pipeline",headingTag:"h2"}}),Os=new U({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> lerobot.processor.pipeline <span class="hljs-keyword">import</span> RobotProcessor, ProcessorStepRegistry, TransitionIndex
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> torch.nn.functional <span class="hljs-keyword">as</span> F
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

<span class="hljs-meta">@ProcessorStepRegistry.register(<span class="hljs-params"><span class="hljs-string">&quot;device_mover&quot;</span></span>)</span>
<span class="hljs-meta">@dataclass</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">DeviceMover</span>:
    <span class="hljs-string">&quot;&quot;&quot;Move all tensors to specified device.&quot;&quot;&quot;</span>

    device: <span class="hljs-built_in">str</span> = <span class="hljs-string">&quot;cuda&quot;</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__call__</span>(<span class="hljs-params">self, transition: EnvTransition</span>) -&gt; EnvTransition:
        obs = transition[TransitionIndex.OBSERVATION]

        <span class="hljs-keyword">if</span> obs <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span>:
            <span class="hljs-keyword">return</span> transition

        <span class="hljs-comment"># Move all tensor observations to device</span>
        <span class="hljs-keyword">for</span> key, value <span class="hljs-keyword">in</span> obs.items():
            <span class="hljs-keyword">if</span> <span class="hljs-built_in">isinstance</span>(value, torch.Tensor):
                obs[key] = value.to(self.device)

        <span class="hljs-comment"># Also handle action if present</span>
        action = transition[TransitionIndex.ACTION]
        <span class="hljs-keyword">if</span> action <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span> <span class="hljs-keyword">and</span> <span class="hljs-built_in">isinstance</span>(action, torch.Tensor):
            action = action.to(self.device)
            <span class="hljs-keyword">return</span> (obs, action, *transition[<span class="hljs-number">2</span>:])

        <span class="hljs-keyword">return</span> (obs, *transition[<span class="hljs-number">1</span>:])

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">get_config</span>(<span class="hljs-params">self</span>) -&gt; <span class="hljs-type">Dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-type">Any</span>]:
        <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;device&quot;</span>: <span class="hljs-built_in">str</span>(self.device)}

<span class="hljs-meta">@ProcessorStepRegistry.register(<span class="hljs-params"><span class="hljs-string">&quot;running_normalizer&quot;</span></span>)</span>
<span class="hljs-meta">@dataclass</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">RunningNormalizer</span>:
    <span class="hljs-string">&quot;&quot;&quot;Normalize using running statistics with proper device handling.&quot;&quot;&quot;</span>

    feature_dim: <span class="hljs-built_in">int</span>
    momentum: <span class="hljs-built_in">float</span> = <span class="hljs-number">0.1</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__post_init__</span>(<span class="hljs-params">self</span>):
        <span class="hljs-comment"># Initialize as None - will be created on first call with correct device</span>
        self.running_mean = <span class="hljs-literal">None</span>
        self.running_var = <span class="hljs-literal">None</span>
        self.initialized = <span class="hljs-literal">False</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__call__</span>(<span class="hljs-params">self, transition: EnvTransition</span>) -&gt; EnvTransition:
        obs = transition[TransitionIndex.OBSERVATION]

        <span class="hljs-keyword">if</span> obs <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span> <span class="hljs-keyword">or</span> <span class="hljs-string">&quot;observation.state&quot;</span> <span class="hljs-keyword">not</span> <span class="hljs-keyword">in</span> obs:
            <span class="hljs-keyword">return</span> transition

        state = obs[<span class="hljs-string">&quot;observation.state&quot;</span>]

        <span class="hljs-comment"># Initialize on first call with correct device</span>
        <span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> self.initialized:
            device = state.device
            self.running_mean = torch.zeros(self.feature_dim, device=device)
            self.running_var = torch.ones(self.feature_dim, device=device)
            self.initialized = <span class="hljs-literal">True</span>

        <span class="hljs-comment"># Update statistics</span>
        <span class="hljs-keyword">with</span> torch.no_grad():
            batch_mean = state.mean(dim=<span class="hljs-number">0</span>)
            batch_var = state.var(dim=<span class="hljs-number">0</span>, unbiased=<span class="hljs-literal">False</span>)

            self.running_mean = (<span class="hljs-number">1</span> - self.momentum) * self.running_mean + self.momentum * batch_mean
            self.running_var = (<span class="hljs-number">1</span> - self.momentum) * self.running_var + self.momentum * batch_var

        <span class="hljs-comment"># Normalize</span>
        state_normalized = (state - self.running_mean) / (self.running_var + <span class="hljs-number">1e-8</span>).sqrt()
        obs[<span class="hljs-string">&quot;observation.state&quot;</span>] = state_normalized

        <span class="hljs-keyword">return</span> (obs, *transition[<span class="hljs-number">1</span>:])

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">get_config</span>(<span class="hljs-params">self</span>) -&gt; <span class="hljs-type">Dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-type">Any</span>]:
        <span class="hljs-keyword">return</span> {
            <span class="hljs-string">&quot;feature_dim&quot;</span>: self.feature_dim,
            <span class="hljs-string">&quot;momentum&quot;</span>: self.momentum,
            <span class="hljs-string">&quot;initialized&quot;</span>: self.initialized
        }

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">state_dict</span>(<span class="hljs-params">self</span>) -&gt; <span class="hljs-type">Dict</span>[<span class="hljs-built_in">str</span>, torch.Tensor]:
        <span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> self.initialized:
            <span class="hljs-keyword">return</span> {}
        <span class="hljs-keyword">return</span> {
            <span class="hljs-string">&quot;running_mean&quot;</span>: self.running_mean,
            <span class="hljs-string">&quot;running_var&quot;</span>: self.running_var
        }

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">load_state_dict</span>(<span class="hljs-params">self, state: <span class="hljs-type">Dict</span>[<span class="hljs-built_in">str</span>, torch.Tensor]</span>) -&gt; <span class="hljs-literal">None</span>:
        <span class="hljs-keyword">if</span> state:
            self.running_mean = state[<span class="hljs-string">&quot;running_mean&quot;</span>]
            self.running_var = state[<span class="hljs-string">&quot;running_var&quot;</span>]
            self.initialized = <span class="hljs-literal">True</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">reset</span>(<span class="hljs-params">self</span>) -&gt; <span class="hljs-literal">None</span>:
        <span class="hljs-comment"># Don&#x27;t reset statistics - they persist across episodes</span>
        <span class="hljs-keyword">pass</span>

<span class="hljs-comment"># Create a complete pipeline</span>
processor = RobotProcessor([
    ImageProcessor(),      <span class="hljs-comment"># Convert images to float32 [0,1]</span>
    StateProcessor(),      <span class="hljs-comment"># Convert states to torch tensors</span>
    ImagePadder(<span class="hljs-number">224</span>, <span class="hljs-number">224</span>), <span class="hljs-comment"># Pad images to standard size</span>
    DeviceMover(<span class="hljs-string">&quot;cuda&quot;</span>),   <span class="hljs-comment"># Move everything to GPU</span>
    RunningNormalizer(<span class="hljs-number">7</span>),  <span class="hljs-comment"># Normalize states</span>
], name=<span class="hljs-string">&quot;CompletePreprocessor&quot;</span>)

<span class="hljs-comment"># The processor handles device transfers automatically</span>
processor = processor.to(<span class="hljs-string">&quot;cuda&quot;</span>)  <span class="hljs-comment"># Moves all stateful components to GPU</span>

<span class="hljs-comment"># Use it</span>
obs = {
    <span class="hljs-string">&quot;pixels&quot;</span>: {<span class="hljs-string">&quot;cam&quot;</span>: np.random.randint(<span class="hljs-number">0</span>, <span class="hljs-number">255</span>, (<span class="hljs-number">200</span>, <span class="hljs-number">300</span>, <span class="hljs-number">3</span>), dtype=np.uint8)},
    <span class="hljs-string">&quot;agent_pos&quot;</span>: np.random.randn(<span class="hljs-number">7</span>).astype(np.float32)
}
transition = (obs, <span class="hljs-literal">None</span>, <span class="hljs-number">0.0</span>, <span class="hljs-literal">False</span>, <span class="hljs-literal">False</span>, {}, {})

<span class="hljs-comment"># Everything is processed and on GPU</span>
processed = processor(transition)
<span class="hljs-built_in">print</span>(processed[TransitionIndex.OBSERVATION][<span class="hljs-string">&quot;observation.images.cam&quot;</span>].device)  <span class="hljs-comment"># cuda:0</span>`,wrap:!1}}),la=new w({props:{title:"Solving Real-World Problems with RobotProcessor",local:"solving-real-world-problems-with-robotprocessor",headingTag:"h2"}}),aa=new w({props:{title:"Renaming Observation Keys",local:"renaming-observation-keys",headingTag:"h3"}}),Ma=new U({props:{code:"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",highlighted:`<span class="hljs-meta">@ProcessorStepRegistry.register(<span class="hljs-params"><span class="hljs-string">&quot;key_remapper&quot;</span></span>)</span>
<span class="hljs-meta">@dataclass</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">KeyRemapper</span>:
    <span class="hljs-string">&quot;&quot;&quot;Rename observation keys to match policy expectations.&quot;&quot;&quot;</span>

    key_mapping: <span class="hljs-type">Dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-built_in">str</span>] = field(default_factory=<span class="hljs-keyword">lambda</span>: {
        <span class="hljs-string">&quot;rgb_camera_front&quot;</span>: <span class="hljs-string">&quot;observation.images.wrist&quot;</span>,
        <span class="hljs-string">&quot;joint_positions&quot;</span>: <span class="hljs-string">&quot;observation.state&quot;</span>,
        <span class="hljs-string">&quot;gripper_state&quot;</span>: <span class="hljs-string">&quot;observation.gripper&quot;</span>
    })

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__call__</span>(<span class="hljs-params">self, transition: EnvTransition</span>) -&gt; EnvTransition:
        obs = transition[TransitionIndex.OBSERVATION]
        <span class="hljs-keyword">if</span> obs <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span>:
            <span class="hljs-keyword">return</span> transition

        <span class="hljs-comment"># Create new observation with renamed keys</span>
        renamed_obs = {}
        <span class="hljs-keyword">for</span> old_key, new_key <span class="hljs-keyword">in</span> self.key_mapping.items():
            <span class="hljs-keyword">if</span> old_key <span class="hljs-keyword">in</span> obs:
                renamed_obs[new_key] = obs[old_key]

        <span class="hljs-comment"># Keep any unmapped keys as-is</span>
        <span class="hljs-keyword">for</span> key, value <span class="hljs-keyword">in</span> obs.items():
            <span class="hljs-keyword">if</span> key <span class="hljs-keyword">not</span> <span class="hljs-keyword">in</span> self.key_mapping:
                renamed_obs[key] = value

        <span class="hljs-keyword">return</span> (renamed_obs, *transition[<span class="hljs-number">1</span>:])`,wrap:!1}}),ta=new w({props:{title:"Workspace-Focused Image Processing",local:"workspace-focused-image-processing",headingTag:"h3"}}),Ja=new U({props:{code:"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",highlighted:`<span class="hljs-meta">@ProcessorStepRegistry.register(<span class="hljs-params"><span class="hljs-string">&quot;workspace_cropper&quot;</span></span>)</span>
<span class="hljs-meta">@dataclass</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">WorkspaceCropper</span>:
    <span class="hljs-string">&quot;&quot;&quot;Crop and resize images to focus on robot workspace.&quot;&quot;&quot;</span>

    crop_bbox: <span class="hljs-type">Tuple</span>[<span class="hljs-built_in">int</span>, <span class="hljs-built_in">int</span>, <span class="hljs-built_in">int</span>, <span class="hljs-built_in">int</span>] = (<span class="hljs-number">400</span>, <span class="hljs-number">200</span>, <span class="hljs-number">1200</span>, <span class="hljs-number">800</span>)  <span class="hljs-comment"># (x1, y1, x2, y2)</span>
    output_size: <span class="hljs-type">Tuple</span>[<span class="hljs-built_in">int</span>, <span class="hljs-built_in">int</span>] = (<span class="hljs-number">224</span>, <span class="hljs-number">224</span>)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__call__</span>(<span class="hljs-params">self, transition: EnvTransition</span>) -&gt; EnvTransition:
        obs = transition[TransitionIndex.OBSERVATION]
        <span class="hljs-keyword">if</span> obs <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span>:
            <span class="hljs-keyword">return</span> transition

        <span class="hljs-keyword">for</span> key <span class="hljs-keyword">in</span> <span class="hljs-built_in">list</span>(obs.keys()):
            <span class="hljs-keyword">if</span> key.startswith(<span class="hljs-string">&quot;observation.images.&quot;</span>):
                img = obs[key]
                <span class="hljs-comment"># Crop to workspace</span>
                x1, y1, x2, y2 = self.crop_bbox
                img_cropped = img[:, :, y1:y2, x1:x2]
                <span class="hljs-comment"># Resize to expected dimensions</span>
                img_resized = F.interpolate(
                    img_cropped,
                    size=self.output_size,
                    mode=<span class="hljs-string">&#x27;bilinear&#x27;</span>,
                    align_corners=<span class="hljs-literal">False</span>
                )
                obs[key] = img_resized

        <span class="hljs-keyword">return</span> (obs, *transition[<span class="hljs-number">1</span>:])`,wrap:!1}}),ya=new w({props:{title:"Building Complete Pipelines for Different Robots",local:"building-complete-pipelines-for-different-robots",headingTag:"h3"}}),ja=new U({props:{code:"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",highlighted:`<span class="hljs-comment"># Pipeline for Robot A with wrist camera</span>
robot_a_processor = RobotProcessor([
    <span class="hljs-comment"># Observation preprocessing</span>
    KeyRemapper({
        <span class="hljs-string">&quot;wrist_rgb&quot;</span>: <span class="hljs-string">&quot;observation.images.wrist&quot;</span>,
        <span class="hljs-string">&quot;arm_joints&quot;</span>: <span class="hljs-string">&quot;observation.state&quot;</span>
    }),
    ImageProcessor(),
    WorkspaceCropper(crop_bbox=(<span class="hljs-number">300</span>, <span class="hljs-number">100</span>, <span class="hljs-number">900</span>, <span class="hljs-number">700</span>), output_size=(<span class="hljs-number">224</span>, <span class="hljs-number">224</span>)),
    StateProcessor(),
    VelocityCalculator(state_key=<span class="hljs-string">&quot;observation.state&quot;</span>),
    DeviceMover(<span class="hljs-string">&quot;cuda&quot;</span>),

    <span class="hljs-comment"># Action postprocessing</span>
    ActionSmoother(alpha=<span class="hljs-number">0.2</span>),
], name=<span class="hljs-string">&quot;RobotA_ACT_Processor&quot;</span>)

<span class="hljs-comment"># Pipeline for Robot B with overhead camera</span>
robot_b_processor = RobotProcessor([
    <span class="hljs-comment"># Different key mapping for Robot B</span>
    KeyRemapper({
        <span class="hljs-string">&quot;overhead_cam&quot;</span>: <span class="hljs-string">&quot;observation.images.wrist&quot;</span>,  <span class="hljs-comment"># Reuse same policy!</span>
        <span class="hljs-string">&quot;joint_encoders&quot;</span>: <span class="hljs-string">&quot;observation.state&quot;</span>
    }),
    ImageProcessor(),
    WorkspaceCropper(crop_bbox=(<span class="hljs-number">100</span>, <span class="hljs-number">50</span>, <span class="hljs-number">1100</span>, <span class="hljs-number">950</span>), output_size=(<span class="hljs-number">224</span>, <span class="hljs-number">224</span>)),
    StateProcessor(),
    VelocityCalculator(state_key=<span class="hljs-string">&quot;observation.state&quot;</span>),
    DeviceMover(<span class="hljs-string">&quot;cuda&quot;</span>),

    ActionSmoother(alpha=<span class="hljs-number">0.3</span>),  <span class="hljs-comment"># Different smoothing</span>
], name=<span class="hljs-string">&quot;RobotB_ACT_Processor&quot;</span>)

<span class="hljs-comment"># Share processors with the community</span>
robot_a_processor.push_to_hub(<span class="hljs-string">&quot;my-lab/robot-a-act-processor&quot;</span>)
robot_b_processor.push_to_hub(<span class="hljs-string">&quot;my-lab/robot-b-act-processor&quot;</span>)

<span class="hljs-comment"># Now anyone can use the same preprocessing</span>
processor = RobotProcessor.from_pretrained(<span class="hljs-string">&quot;my-lab/robot-a-act-processor&quot;</span>)`,wrap:!1}}),ia=new w({props:{title:"Best Practices for Processor Steps",local:"best-practices-for-processor-steps",headingTag:"h2"}}),ca=new w({props:{title:"1. Always Check for None",local:"1-always-check-for-none",headingTag:"h3"}}),wa=new U({props:{code:"ZGVmJTIwX19jYWxsX18oc2VsZiUyQyUyMHRyYW5zaXRpb24lM0ElMjBFbnZUcmFuc2l0aW9uKSUyMC0lM0UlMjBFbnZUcmFuc2l0aW9uJTNBJTBBJTIwJTIwJTIwJTIwb2JzJTIwJTNEJTIwdHJhbnNpdGlvbiU1QlRyYW5zaXRpb25JbmRleC5PQlNFUlZBVElPTiU1RCUwQSUwQSUyMCUyMCUyMCUyMCUyMyUyMEFsd2F5cyUyMGNoZWNrJTIwaWYlMjBvYnNlcnZhdGlvbiUyMGV4aXN0cyUwQSUyMCUyMCUyMCUyMGlmJTIwb2JzJTIwaXMlMjBOb25lJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwdHJhbnNpdGlvbiUwQSUwQSUyMCUyMCUyMCUyMCUyMyUyMEFsc28lMjBjaGVjayUyMGZvciUyMHNwZWNpZmljJTIwa2V5cyUwQSUyMCUyMCUyMCUyMGlmJTIwJTIyb2JzZXJ2YXRpb24uc3RhdGUlMjIlMjBub3QlMjBpbiUyMG9icyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMHRyYW5zaXRpb24=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">__call__</span>(<span class="hljs-params">self, transition: EnvTransition</span>) -&gt; EnvTransition:
    obs = transition[TransitionIndex.OBSERVATION]

    <span class="hljs-comment"># Always check if observation exists</span>
    <span class="hljs-keyword">if</span> obs <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span>:
        <span class="hljs-keyword">return</span> transition

    <span class="hljs-comment"># Also check for specific keys</span>
    <span class="hljs-keyword">if</span> <span class="hljs-string">&quot;observation.state&quot;</span> <span class="hljs-keyword">not</span> <span class="hljs-keyword">in</span> obs:
        <span class="hljs-keyword">return</span> transition`,wrap:!1}}),Ua=new w({props:{title:"2. Preserve Transition Structure",local:"2-preserve-transition-structure",headingTag:"h3"}}),ra=new U({props:{code:"JTIzJTIwR29vZCUyMC0lMjBwcmVzZXJ2ZSUyMGFsbCUyMGVsZW1lbnRzJTBBcmV0dXJuJTIwKG1vZGlmaWVkX29icyUyQyUyMCp0cmFuc2l0aW9uJTVCMSUzQSU1RCklMEElMEElMjMlMjBCYWQlMjAtJTIwbG9zaW5nJTIwaW5mb3JtYXRpb24lMEFyZXR1cm4lMjAobW9kaWZpZWRfb2JzJTJDJTIwTm9uZSUyQyUyMDAuMCUyQyUyMEZhbHNlJTJDJTIwRmFsc2UlMkMlMjAlN0IlN0QlMkMlMjAlN0IlN0Qp",highlighted:`<span class="hljs-comment"># Good - preserve all elements</span>
<span class="hljs-keyword">return</span> (modified_obs, *transition[<span class="hljs-number">1</span>:])

<span class="hljs-comment"># Bad - losing information</span>
<span class="hljs-keyword">return</span> (modified_obs, <span class="hljs-literal">None</span>, <span class="hljs-number">0.0</span>, <span class="hljs-literal">False</span>, <span class="hljs-literal">False</span>, {}, {})`,wrap:!1}}),Ia=new w({props:{title:"3. Clone When Storing State",local:"3-clone-when-storing-state",headingTag:"h3"}}),ma=new U({props:{code:"ZGVmJTIwX19jYWxsX18oc2VsZiUyQyUyMHRyYW5zaXRpb24lM0ElMjBFbnZUcmFuc2l0aW9uKSUyMC0lM0UlMjBFbnZUcmFuc2l0aW9uJTNBJTBBJTIwJTIwJTIwJTIwb2JzJTIwJTNEJTIwdHJhbnNpdGlvbiU1QlRyYW5zaXRpb25JbmRleC5PQlNFUlZBVElPTiU1RCUwQSUwQSUyMCUyMCUyMCUyMGlmJTIwc2VsZi5zdG9yZV9wcmV2aW91cyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMEdvb2QlMjAtJTIwY2xvbmUlMjB0byUyMGF2b2lkJTIwcmVmZXJlbmNlJTIwaXNzdWVzJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5wcmV2aW91c19zdGF0ZSUyMCUzRCUyMG9icyU1QiUyMm9ic2VydmF0aW9uLnN0YXRlJTIyJTVELmNsb25lKCklMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBCYWQlMjAtJTIwc3RvcmVzJTIwcmVmZXJlbmNlJTIwdGhhdCUyMG1pZ2h0JTIwYmUlMjBtb2RpZmllZCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMHNlbGYucHJldmlvdXNfc3RhdGUlMjAlM0QlMjBvYnMlNUIlMjJvYnNlcnZhdGlvbi5zdGF0ZSUyMiU1RA==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">__call__</span>(<span class="hljs-params">self, transition: EnvTransition</span>) -&gt; EnvTransition:
    obs = transition[TransitionIndex.OBSERVATION]

    <span class="hljs-keyword">if</span> self.store_previous:
        <span class="hljs-comment"># Good - clone to avoid reference issues</span>
        self.previous_state = obs[<span class="hljs-string">&quot;observation.state&quot;</span>].clone()

        <span class="hljs-comment"># Bad - stores reference that might be modified</span>
        <span class="hljs-comment"># self.previous_state = obs[&quot;observation.state&quot;]</span>`,wrap:!1}}),da=new w({props:{title:"4. Handle Device Transfers in state_dict",local:"4-handle-device-transfers-in-statedict",headingTag:"h3"}}),ua=new U({props:{code:"ZGVmJTIwc3RhdGVfZGljdChzZWxmKSUyMC0lM0UlMjBEaWN0JTVCc3RyJTJDJTIwdG9yY2guVGVuc29yJTVEJTNBJTBBJTIwJTIwJTIwJTIwaWYlMjBzZWxmLmJ1ZmZlciUyMGlzJTIwTm9uZSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMCU3QiU3RCUwQSUwQSUyMCUyMCUyMCUyMCUyMyUyMEdvb2QlMjAtJTIwY2xvbmUlMjB0byUyMGF2b2lkJTIwbWVtb3J5JTIwc2hhcmluZyUyMGlzc3VlcyUwQSUyMCUyMCUyMCUyMHJldHVybiUyMCU3QiUyMmJ1ZmZlciUyMiUzQSUyMHNlbGYuYnVmZmVyLmNsb25lKCklN0Q=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">state_dict</span>(<span class="hljs-params">self</span>) -&gt; <span class="hljs-type">Dict</span>[<span class="hljs-built_in">str</span>, torch.Tensor]:
    <span class="hljs-keyword">if</span> self.buffer <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span>:
        <span class="hljs-keyword">return</span> {}

    <span class="hljs-comment"># Good - clone to avoid memory sharing issues</span>
    <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;buffer&quot;</span>: self.buffer.clone()}`,wrap:!1}}),ba=new w({props:{title:"Complete Policy Example with Pre and Post Processing",local:"complete-policy-example-with-pre-and-post-processing",headingTag:"h2"}}),Ca=new U({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> lerobot.processor.pipeline <span class="hljs-keyword">import</span> RobotProcessor, ProcessorStepRegistry, TransitionIndex
<span class="hljs-keyword">from</span> lerobot.policies.act.modeling_act <span class="hljs-keyword">import</span> ACTPolicy
<span class="hljs-keyword">from</span> pathlib <span class="hljs-keyword">import</span> Path
<span class="hljs-keyword">import</span> time

<span class="hljs-comment"># Create preprocessing pipeline</span>
preprocessor = RobotProcessor([
    ImageProcessor(),
    StateProcessor(),
    ImagePadder(target_height=<span class="hljs-number">224</span>, target_width=<span class="hljs-number">224</span>),
    DeviceMover(<span class="hljs-string">&quot;cuda&quot;</span>),
    RunningNormalizer(feature_dim=<span class="hljs-number">14</span>),  <span class="hljs-comment"># For 14-DOF robot</span>
], name=<span class="hljs-string">&quot;ACTPreprocessor&quot;</span>)

<span class="hljs-comment"># Create postprocessing pipeline for actions</span>
<span class="hljs-meta">@ProcessorStepRegistry.register(<span class="hljs-params"><span class="hljs-string">&quot;action_clipper&quot;</span></span>)</span>
<span class="hljs-meta">@dataclass</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">ActionClipper</span>:
    <span class="hljs-string">&quot;&quot;&quot;Clip actions to safe ranges.&quot;&quot;&quot;</span>
    min_value: <span class="hljs-built_in">float</span> = -<span class="hljs-number">1.0</span>
    max_value: <span class="hljs-built_in">float</span> = <span class="hljs-number">1.0</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__call__</span>(<span class="hljs-params">self, transition: EnvTransition</span>) -&gt; EnvTransition:
        action = transition[TransitionIndex.ACTION]

        <span class="hljs-keyword">if</span> action <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>:
            action = torch.clamp(action, self.min_value, self.max_value)
            <span class="hljs-keyword">return</span> (transition[TransitionIndex.OBSERVATION], action, *transition[<span class="hljs-number">2</span>:])

        <span class="hljs-keyword">return</span> transition

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">get_config</span>(<span class="hljs-params">self</span>) -&gt; <span class="hljs-type">Dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-type">Any</span>]:
        <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;min_value&quot;</span>: self.min_value, <span class="hljs-string">&quot;max_value&quot;</span>: self.max_value}

postprocessor = RobotProcessor([
    ActionClipper(min_value=-<span class="hljs-number">0.5</span>, max_value=<span class="hljs-number">0.5</span>),
    ActionSmoother(alpha=<span class="hljs-number">0.3</span>),
], name=<span class="hljs-string">&quot;ACTPostprocessor&quot;</span>)

<span class="hljs-comment"># Load policy</span>
policy = ACTPolicy.from_pretrained(<span class="hljs-string">&quot;lerobot/act_aloha_sim_transfer_cube_human&quot;</span>)

<span class="hljs-comment"># Move everything to GPU</span>
preprocessor = preprocessor.to(<span class="hljs-string">&quot;cuda&quot;</span>)
postprocessor = postprocessor.to(<span class="hljs-string">&quot;cuda&quot;</span>)
policy = policy.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-comment"># Control loop using EnvTransition format</span>
env = make_robot_env()
obs, info = env.reset()

<span class="hljs-keyword">for</span> episode <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">10</span>):
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Episode <span class="hljs-subst">{episode + <span class="hljs-number">1</span>}</span>&quot;</span>)

    <span class="hljs-keyword">for</span> step <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">1000</span>):
        <span class="hljs-comment"># Create transition with raw observation</span>
        transition = (obs, <span class="hljs-literal">None</span>, <span class="hljs-number">0.0</span>, <span class="hljs-literal">False</span>, <span class="hljs-literal">False</span>, info, {<span class="hljs-string">&quot;step&quot;</span>: step})

        <span class="hljs-comment"># Preprocess - works with tuple format</span>
        processed_transition = preprocessor(transition)
        processed_obs = processed_transition[TransitionIndex.OBSERVATION]

        <span class="hljs-comment"># Get action from policy</span>
        <span class="hljs-keyword">with</span> torch.no_grad():
            action = policy.select_action(processed_obs)

        <span class="hljs-comment"># Postprocess action</span>
        action_transition = (
            processed_obs,
            action,
            <span class="hljs-number">0.0</span>,
            <span class="hljs-literal">False</span>,
            <span class="hljs-literal">False</span>,
            info,
            {<span class="hljs-string">&quot;raw_action&quot;</span>: action.clone()}  <span class="hljs-comment"># Store raw action in complementary_data</span>
        )
        processed_action_transition = postprocessor(action_transition)
        final_action = processed_action_transition[TransitionIndex.ACTION]

        <span class="hljs-comment"># Execute action</span>
        obs, reward, terminated, truncated, info = env.step(final_action.cpu().numpy())

        <span class="hljs-keyword">if</span> terminated <span class="hljs-keyword">or</span> truncated:
            <span class="hljs-comment"># Reset at episode boundary</span>
            preprocessor.reset()
            postprocessor.reset()
            obs, info = env.reset()
            <span class="hljs-keyword">break</span>

    <span class="hljs-comment"># Save preprocessor with learned statistics</span>
    preprocessor.save_pretrained(<span class="hljs-string">f&quot;./checkpoints/preprocessor_ep<span class="hljs-subst">{episode}</span>&quot;</span>)

<span class="hljs-comment"># Alternative: Using batch dictionary format</span>
<span class="hljs-comment"># This is useful when integrating with existing LeRobot training code</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">control_loop_with_batch_format</span>():
    <span class="hljs-string">&quot;&quot;&quot;Example using batch dictionary format.&quot;&quot;&quot;</span>
    obs, info = env.reset()

    <span class="hljs-keyword">for</span> step <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">1000</span>):
        <span class="hljs-comment"># Create batch dictionary</span>
        batch = {
            <span class="hljs-string">&quot;observation.image&quot;</span>: torch.from_numpy(obs[<span class="hljs-string">&quot;pixels&quot;</span>]).unsqueeze(<span class="hljs-number">0</span>),
            <span class="hljs-string">&quot;observation.state&quot;</span>: torch.from_numpy(obs[<span class="hljs-string">&quot;agent_pos&quot;</span>]).unsqueeze(<span class="hljs-number">0</span>),
            <span class="hljs-string">&quot;action&quot;</span>: torch.zeros(<span class="hljs-number">1</span>, <span class="hljs-number">7</span>),  <span class="hljs-comment"># Placeholder</span>
            <span class="hljs-string">&quot;next.reward&quot;</span>: torch.tensor([<span class="hljs-number">0.0</span>]),
            <span class="hljs-string">&quot;next.done&quot;</span>: torch.tensor([<span class="hljs-literal">False</span>]),
            <span class="hljs-string">&quot;next.truncated&quot;</span>: torch.tensor([<span class="hljs-literal">False</span>]),
            <span class="hljs-string">&quot;info&quot;</span>: info,
        }

        <span class="hljs-comment"># Preprocess - works with batch format</span>
        processed_batch = preprocessor(batch)

        <span class="hljs-comment"># Get action from policy</span>
        <span class="hljs-keyword">with</span> torch.no_grad():
            action = policy.select_action({
                k: v <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> processed_batch.items()
                <span class="hljs-keyword">if</span> k.startswith(<span class="hljs-string">&quot;observation.&quot;</span>)
            })

        <span class="hljs-comment"># Add action to batch for postprocessing</span>
        processed_batch[<span class="hljs-string">&quot;action&quot;</span>] = action

        <span class="hljs-comment"># Postprocess</span>
        final_batch = postprocessor(processed_batch)
        final_action = final_batch[<span class="hljs-string">&quot;action&quot;</span>]

        <span class="hljs-comment"># Execute action</span>
        obs, reward, terminated, truncated, info = env.step(final_action.cpu().numpy())

        <span class="hljs-keyword">if</span> terminated <span class="hljs-keyword">or</span> truncated:
            <span class="hljs-keyword">break</span>

<span class="hljs-comment"># Push final version to hub</span>
preprocessor.push_to_hub(<span class="hljs-string">&quot;my-username/act-preprocessor&quot;</span>)
postprocessor.push_to_hub(<span class="hljs-string">&quot;my-username/act-postprocessor&quot;</span>)`,wrap:!1}}),Aa=new w({props:{title:"Debugging and Monitoring",local:"debugging-and-monitoring",headingTag:"h2"}}),Za=new U({props:{code:"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",highlighted:`<span class="hljs-comment"># Enable detailed logging</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">log_observation_shapes</span>(<span class="hljs-params">step_idx: <span class="hljs-built_in">int</span>, transition: EnvTransition</span>):
    obs = transition[TransitionIndex.OBSERVATION]
    <span class="hljs-keyword">if</span> obs:
        <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Step <span class="hljs-subst">{step_idx}</span> observations:&quot;</span>)
        <span class="hljs-keyword">for</span> key, value <span class="hljs-keyword">in</span> obs.items():
            <span class="hljs-keyword">if</span> <span class="hljs-built_in">isinstance</span>(value, torch.Tensor):
                <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;  <span class="hljs-subst">{key}</span>: shape=<span class="hljs-subst">{value.shape}</span>, device=<span class="hljs-subst">{value.device}</span>, dtype=<span class="hljs-subst">{value.dtype}</span>&quot;</span>)
    <span class="hljs-keyword">return</span> <span class="hljs-literal">None</span>

processor.register_after_step_hook(log_observation_shapes)

<span class="hljs-comment"># Monitor complementary data flow</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">monitor_complementary_data</span>(<span class="hljs-params">step_idx: <span class="hljs-built_in">int</span>, transition: EnvTransition</span>):
    comp_data = transition[TransitionIndex.COMPLEMENTARY_DATA]
    <span class="hljs-keyword">if</span> comp_data:
        <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Step <span class="hljs-subst">{step_idx}</span> complementary_data: <span class="hljs-subst">{<span class="hljs-built_in">list</span>(comp_data.keys())}</span>&quot;</span>)
    <span class="hljs-keyword">return</span> <span class="hljs-literal">None</span>

processor.register_before_step_hook(monitor_complementary_data)

<span class="hljs-comment"># Validate data integrity</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">validate_tensors</span>(<span class="hljs-params">step_idx: <span class="hljs-built_in">int</span>, transition: EnvTransition</span>):
    obs = transition[TransitionIndex.OBSERVATION]
    <span class="hljs-keyword">if</span> obs:
        <span class="hljs-keyword">for</span> key, value <span class="hljs-keyword">in</span> obs.items():
            <span class="hljs-keyword">if</span> <span class="hljs-built_in">isinstance</span>(value, torch.Tensor):
                <span class="hljs-keyword">if</span> torch.isnan(value).<span class="hljs-built_in">any</span>():
                    <span class="hljs-keyword">raise</span> ValueError(<span class="hljs-string">f&quot;NaN detected in <span class="hljs-subst">{key}</span> after step <span class="hljs-subst">{step_idx}</span>&quot;</span>)
                <span class="hljs-keyword">if</span> torch.isinf(value).<span class="hljs-built_in">any</span>():
                    <span class="hljs-keyword">raise</span> ValueError(<span class="hljs-string">f&quot;Inf detected in <span class="hljs-subst">{key}</span> after step <span class="hljs-subst">{step_idx}</span>&quot;</span>)
    <span class="hljs-keyword">return</span> <span class="hljs-literal">None</span>

processor.register_after_step_hook(validate_tensors)`,wrap:!1}}),fa=new w({props:{title:"Summary",local:"summary",headingTag:"h2"}}),Wa=new XJ({props:{source:"https://github.com/huggingface/lerobot/blob/main/docs/source/processor_tutorial.mdx"}}),{c(){r=T("meta"),Va=M(),Qa=T("p"),Ya=M(),e(I.$$.fragment),ka=M(),m=T("p"),m.textContent=Je,za=M(),d=T("p"),d.innerHTML=ye,Sa=M(),u=T("ol"),u.innerHTML=pe,Fa=M(),e(b.$$.fragment),_a=M(),h=T("p"),h.textContent=je,qa=M(),e(C.$$.fragment),Ha=M(),A=T("p"),A.innerHTML=oe,$a=M(),e(B.$$.fragment),xa=M(),Z=T("p"),Z.textContent=Te,Da=M(),f=T("ul"),f.innerHTML=ie,La=M(),e(v.$$.fragment),Pa=M(),N=T("p"),N.textContent=ce,Ka=M(),G=T("ul"),G.innerHTML=we,Oa=M(),e(g.$$.fragment),ln=M(),R=T("p"),R.textContent=Ue,sn=M(),E=T("ul"),E.innerHTML=re,an=M(),e(W.$$.fragment),nn=M(),Q=T("p"),Q.textContent=Ie,Mn=M(),X=T("ul"),X.innerHTML=me,tn=M(),e(V.$$.fragment),en=M(),Y=T("p"),Y.textContent=de,Jn=M(),k=T("ul"),k.innerHTML=ue,yn=M(),z=T("p"),z.textContent=be,pn=M(),e(S.$$.fragment),jn=M(),F=T("p"),F.textContent=he,on=M(),e(_.$$.fragment),Tn=M(),q=T("p"),q.textContent=Ce,cn=M(),H=T("ul"),H.innerHTML=Ae,wn=M(),$=T("p"),$.textContent=Be,Un=M(),e(x.$$.fragment),rn=M(),D=T("p"),D.textContent=Ze,In=M(),e(L.$$.fragment),mn=M(),P=T("p"),P.innerHTML=fe,dn=M(),e(K.$$.fragment),un=M(),e(O.$$.fragment),bn=M(),ll=T("p"),ll.textContent=ve,hn=M(),e(sl.$$.fragment),Cn=M(),e(al.$$.fragment),An=M(),nl=T("p"),nl.textContent=Ne,Bn=M(),e(Ml.$$.fragment),Zn=M(),e(tl.$$.fragment),fn=M(),el=T("p"),el.innerHTML=Ge,vn=M(),e(Jl.$$.fragment),Nn=M(),e(yl.$$.fragment),Gn=M(),pl=T("p"),pl.textContent=ge,gn=M(),e(jl.$$.fragment),Rn=M(),e(ol.$$.fragment),En=M(),Tl=T("p"),Tl.textContent=Re,Wn=M(),e(il.$$.fragment),Qn=M(),e(cl.$$.fragment),Xn=M(),wl=T("p"),wl.innerHTML=Ee,Vn=M(),e(Ul.$$.fragment),Yn=M(),e(rl.$$.fragment),kn=M(),Il=T("p"),Il.textContent=We,zn=M(),e(ml.$$.fragment),Sn=M(),e(dl.$$.fragment),Fn=M(),ul=T("p"),ul.innerHTML=Qe,_n=M(),bl=T("ul"),bl.innerHTML=Xe,qn=M(),hl=T("p"),hl.innerHTML=Ve,Hn=M(),Cl=T("ul"),Cl.innerHTML=Ye,$n=M(),e(Al.$$.fragment),xn=M(),e(Bl.$$.fragment),Dn=M(),Zl=T("p"),Zl.textContent=ke,Ln=M(),e(fl.$$.fragment),Pn=M(),e(vl.$$.fragment),Kn=M(),Nl=T("p"),Nl.textContent=ze,On=M(),e(Gl.$$.fragment),lM=M(),e(gl.$$.fragment),sM=M(),Rl=T("p"),Rl.textContent=Se,aM=M(),e(El.$$.fragment),nM=M(),e(Wl.$$.fragment),MM=M(),Ql=T("p"),Ql.textContent=Fe,tM=M(),e(Xl.$$.fragment),eM=M(),e(Vl.$$.fragment),JM=M(),Yl=T("p"),Yl.textContent=_e,yM=M(),e(kl.$$.fragment),pM=M(),e(zl.$$.fragment),jM=M(),Sl=T("p"),Sl.textContent=qe,oM=M(),e(Fl.$$.fragment),TM=M(),e(_l.$$.fragment),iM=M(),ql=T("p"),ql.innerHTML=He,cM=M(),e(Hl.$$.fragment),wM=M(),e($l.$$.fragment),UM=M(),xl=T("p"),xl.textContent=$e,rM=M(),e(Dl.$$.fragment),IM=M(),Ll=T("p"),Ll.textContent=xe,mM=M(),e(Pl.$$.fragment),dM=M(),Kl=T("p"),Kl.innerHTML=De,uM=M(),e(Ol.$$.fragment),bM=M(),ls=T("p"),ls.innerHTML=Le,hM=M(),e(ss.$$.fragment),CM=M(),e(as.$$.fragment),AM=M(),ns=T("p"),ns.innerHTML=Pe,BM=M(),Ms=T("ul"),Ms.innerHTML=Ke,ZM=M(),e(ts.$$.fragment),fM=M(),es=T("p"),es.textContent=Oe,vM=M(),Js=T("ol"),Js.innerHTML=lJ,NM=M(),e(ys.$$.fragment),GM=M(),e(ps.$$.fragment),gM=M(),e(js.$$.fragment),RM=M(),e(os.$$.fragment),EM=M(),e(Ts.$$.fragment),WM=M(),e(is.$$.fragment),QM=M(),e(cs.$$.fragment),XM=M(),e(ws.$$.fragment),VM=M(),Us=T("p"),Us.textContent=sJ,YM=M(),e(rs.$$.fragment),kM=M(),Is=T("p"),Is.innerHTML=aJ,zM=M(),e(ms.$$.fragment),SM=M(),e(ds.$$.fragment),FM=M(),us=T("p"),us.textContent=nJ,_M=M(),e(bs.$$.fragment),qM=M(),e(hs.$$.fragment),HM=M(),Cs=T("p"),Cs.textContent=MJ,$M=M(),e(As.$$.fragment),xM=M(),e(Bs.$$.fragment),DM=M(),e(Zs.$$.fragment),LM=M(),e(fs.$$.fragment),PM=M(),e(vs.$$.fragment),KM=M(),Ns=T("p"),Ns.textContent=tJ,OM=M(),e(Gs.$$.fragment),lt=M(),gs=T("p"),gs.textContent=eJ,st=M(),e(Rs.$$.fragment),at=M(),e(Es.$$.fragment),nt=M(),e(Ws.$$.fragment),Mt=M(),Qs=T("p"),Qs.textContent=JJ,tt=M(),e(Xs.$$.fragment),et=M(),e(Vs.$$.fragment),Jt=M(),Ys=T("p"),Ys.textContent=yJ,yt=M(),e(ks.$$.fragment),pt=M(),e(zs.$$.fragment),jt=M(),Ss=T("p"),Ss.textContent=pJ,ot=M(),e(Fs.$$.fragment),Tt=M(),e(_s.$$.fragment),it=M(),qs=T("p"),qs.textContent=jJ,ct=M(),e(Hs.$$.fragment),wt=M(),e($s.$$.fragment),Ut=M(),xs=T("p"),xs.textContent=oJ,rt=M(),e(Ds.$$.fragment),It=M(),Ls=T("p"),Ls.textContent=TJ,mt=M(),e(Ps.$$.fragment),dt=M(),Ks=T("p"),Ks.textContent=iJ,ut=M(),e(Os.$$.fragment),bt=M(),e(la.$$.fragment),ht=M(),sa=T("p"),sa.textContent=cJ,Ct=M(),e(aa.$$.fragment),At=M(),na=T("p"),na.textContent=wJ,Bt=M(),e(Ma.$$.fragment),Zt=M(),e(ta.$$.fragment),ft=M(),ea=T("p"),ea.textContent=UJ,vt=M(),e(Ja.$$.fragment),Nt=M(),e(ya.$$.fragment),Gt=M(),pa=T("p"),pa.textContent=rJ,gt=M(),e(ja.$$.fragment),Rt=M(),oa=T("p"),oa.textContent=IJ,Et=M(),Ta=T("ol"),Ta.innerHTML=mJ,Wt=M(),e(ia.$$.fragment),Qt=M(),e(ca.$$.fragment),Xt=M(),e(wa.$$.fragment),Vt=M(),e(Ua.$$.fragment),Yt=M(),e(ra.$$.fragment),kt=M(),e(Ia.$$.fragment),zt=M(),e(ma.$$.fragment),St=M(),e(da.$$.fragment),Ft=M(),e(ua.$$.fragment),_t=M(),e(ba.$$.fragment),qt=M(),ha=T("p"),ha.textContent=dJ,Ht=M(),e(Ca.$$.fragment),$t=M(),e(Aa.$$.fragment),xt=M(),Ba=T("p"),Ba.innerHTML=uJ,Dt=M(),e(Za.$$.fragment),Lt=M(),e(fa.$$.fragment),Pt=M(),va=T("p"),va.textContent=bJ,Kt=M(),Na=T("ul"),Na.innerHTML=hJ,Ot=M(),Ga=T("p"),Ga.textContent=CJ,le=M(),ga=T("ul"),ga.innerHTML=AJ,se=M(),Ra=T("p"),Ra.textContent=BJ,ae=M(),Ea=T("p"),Ea.innerHTML=ZJ,ne=M(),e(Wa.$$.fragment),Me=M(),Xa=T("p"),this.h()},l(l){const s=WJ("svelte-u9bgzb",document.head);r=i(s,"META",{name:!0,content:!0}),s.forEach(a),Va=t(l),Qa=i(l,"P",{}),fJ(Qa).forEach(a),Ya=t(l),J(I.$$.fragment,l),ka=t(l),m=i(l,"P",{"data-svelte-h":!0}),c(m)!=="svelte-16ovulj"&&(m.textContent=Je),za=t(l),d=i(l,"P",{"data-svelte-h":!0}),c(d)!=="svelte-xo8ua7"&&(d.innerHTML=ye),Sa=t(l),u=i(l,"OL",{"data-svelte-h":!0}),c(u)!=="svelte-14gsfpg"&&(u.innerHTML=pe),Fa=t(l),J(b.$$.fragment,l),_a=t(l),h=i(l,"P",{"data-svelte-h":!0}),c(h)!=="svelte-kvhb1i"&&(h.textContent=je),qa=t(l),J(C.$$.fragment,l),Ha=t(l),A=i(l,"P",{"data-svelte-h":!0}),c(A)!=="svelte-tezn1r"&&(A.innerHTML=oe),$a=t(l),J(B.$$.fragment,l),xa=t(l),Z=i(l,"P",{"data-svelte-h":!0}),c(Z)!=="svelte-d65w2e"&&(Z.textContent=Te),Da=t(l),f=i(l,"UL",{"data-svelte-h":!0}),c(f)!=="svelte-be9yol"&&(f.innerHTML=ie),La=t(l),J(v.$$.fragment,l),Pa=t(l),N=i(l,"P",{"data-svelte-h":!0}),c(N)!=="svelte-1agogwi"&&(N.textContent=ce),Ka=t(l),G=i(l,"UL",{"data-svelte-h":!0}),c(G)!=="svelte-fcjkyc"&&(G.innerHTML=we),Oa=t(l),J(g.$$.fragment,l),ln=t(l),R=i(l,"P",{"data-svelte-h":!0}),c(R)!=="svelte-1axr7bh"&&(R.textContent=Ue),sn=t(l),E=i(l,"UL",{"data-svelte-h":!0}),c(E)!=="svelte-cvl01e"&&(E.innerHTML=re),an=t(l),J(W.$$.fragment,l),nn=t(l),Q=i(l,"P",{"data-svelte-h":!0}),c(Q)!=="svelte-15htyyt"&&(Q.textContent=Ie),Mn=t(l),X=i(l,"UL",{"data-svelte-h":!0}),c(X)!=="svelte-1nhg0be"&&(X.innerHTML=me),tn=t(l),J(V.$$.fragment,l),en=t(l),Y=i(l,"P",{"data-svelte-h":!0}),c(Y)!=="svelte-ku9g5b"&&(Y.textContent=de),Jn=t(l),k=i(l,"UL",{"data-svelte-h":!0}),c(k)!=="svelte-sglc80"&&(k.innerHTML=ue),yn=t(l),z=i(l,"P",{"data-svelte-h":!0}),c(z)!=="svelte-pldmn"&&(z.textContent=be),pn=t(l),J(S.$$.fragment,l),jn=t(l),F=i(l,"P",{"data-svelte-h":!0}),c(F)!=="svelte-1q7iht5"&&(F.textContent=he),on=t(l),J(_.$$.fragment,l),Tn=t(l),q=i(l,"P",{"data-svelte-h":!0}),c(q)!=="svelte-l0tugm"&&(q.textContent=Ce),cn=t(l),H=i(l,"UL",{"data-svelte-h":!0}),c(H)!=="svelte-1j8spr5"&&(H.innerHTML=Ae),wn=t(l),$=i(l,"P",{"data-svelte-h":!0}),c($)!=="svelte-643t46"&&($.textContent=Be),Un=t(l),J(x.$$.fragment,l),rn=t(l),D=i(l,"P",{"data-svelte-h":!0}),c(D)!=="svelte-il9qki"&&(D.textContent=Ze),In=t(l),J(L.$$.fragment,l),mn=t(l),P=i(l,"P",{"data-svelte-h":!0}),c(P)!=="svelte-hej4ej"&&(P.innerHTML=fe),dn=t(l),J(K.$$.fragment,l),un=t(l),J(O.$$.fragment,l),bn=t(l),ll=i(l,"P",{"data-svelte-h":!0}),c(ll)!=="svelte-12e7en9"&&(ll.textContent=ve),hn=t(l),J(sl.$$.fragment,l),Cn=t(l),J(al.$$.fragment,l),An=t(l),nl=i(l,"P",{"data-svelte-h":!0}),c(nl)!=="svelte-ji1fs7"&&(nl.textContent=Ne),Bn=t(l),J(Ml.$$.fragment,l),Zn=t(l),J(tl.$$.fragment,l),fn=t(l),el=i(l,"P",{"data-svelte-h":!0}),c(el)!=="svelte-1w9zlzf"&&(el.innerHTML=Ge),vn=t(l),J(Jl.$$.fragment,l),Nn=t(l),J(yl.$$.fragment,l),Gn=t(l),pl=i(l,"P",{"data-svelte-h":!0}),c(pl)!=="svelte-bfip3"&&(pl.textContent=ge),gn=t(l),J(jl.$$.fragment,l),Rn=t(l),J(ol.$$.fragment,l),En=t(l),Tl=i(l,"P",{"data-svelte-h":!0}),c(Tl)!=="svelte-7rcxgy"&&(Tl.textContent=Re),Wn=t(l),J(il.$$.fragment,l),Qn=t(l),J(cl.$$.fragment,l),Xn=t(l),wl=i(l,"P",{"data-svelte-h":!0}),c(wl)!=="svelte-a3nhq6"&&(wl.innerHTML=Ee),Vn=t(l),J(Ul.$$.fragment,l),Yn=t(l),J(rl.$$.fragment,l),kn=t(l),Il=i(l,"P",{"data-svelte-h":!0}),c(Il)!=="svelte-1hghjw5"&&(Il.textContent=We),zn=t(l),J(ml.$$.fragment,l),Sn=t(l),J(dl.$$.fragment,l),Fn=t(l),ul=i(l,"P",{"data-svelte-h":!0}),c(ul)!=="svelte-brp5w1"&&(ul.innerHTML=Qe),_n=t(l),bl=i(l,"UL",{"data-svelte-h":!0}),c(bl)!=="svelte-1e1bpw4"&&(bl.innerHTML=Xe),qn=t(l),hl=i(l,"P",{"data-svelte-h":!0}),c(hl)!=="svelte-525nud"&&(hl.innerHTML=Ve),Hn=t(l),Cl=i(l,"UL",{"data-svelte-h":!0}),c(Cl)!=="svelte-1j9pije"&&(Cl.innerHTML=Ye),$n=t(l),J(Al.$$.fragment,l),xn=t(l),J(Bl.$$.fragment,l),Dn=t(l),Zl=i(l,"P",{"data-svelte-h":!0}),c(Zl)!=="svelte-y9nyoq"&&(Zl.textContent=ke),Ln=t(l),J(fl.$$.fragment,l),Pn=t(l),J(vl.$$.fragment,l),Kn=t(l),Nl=i(l,"P",{"data-svelte-h":!0}),c(Nl)!=="svelte-r9z2ng"&&(Nl.textContent=ze),On=t(l),J(Gl.$$.fragment,l),lM=t(l),J(gl.$$.fragment,l),sM=t(l),Rl=i(l,"P",{"data-svelte-h":!0}),c(Rl)!=="svelte-cuz5jq"&&(Rl.textContent=Se),aM=t(l),J(El.$$.fragment,l),nM=t(l),J(Wl.$$.fragment,l),MM=t(l),Ql=i(l,"P",{"data-svelte-h":!0}),c(Ql)!=="svelte-1th7p1r"&&(Ql.textContent=Fe),tM=t(l),J(Xl.$$.fragment,l),eM=t(l),J(Vl.$$.fragment,l),JM=t(l),Yl=i(l,"P",{"data-svelte-h":!0}),c(Yl)!=="svelte-qo4qpu"&&(Yl.textContent=_e),yM=t(l),J(kl.$$.fragment,l),pM=t(l),J(zl.$$.fragment,l),jM=t(l),Sl=i(l,"P",{"data-svelte-h":!0}),c(Sl)!=="svelte-8dvr44"&&(Sl.textContent=qe),oM=t(l),J(Fl.$$.fragment,l),TM=t(l),J(_l.$$.fragment,l),iM=t(l),ql=i(l,"P",{"data-svelte-h":!0}),c(ql)!=="svelte-1jmnnok"&&(ql.innerHTML=He),cM=t(l),J(Hl.$$.fragment,l),wM=t(l),J($l.$$.fragment,l),UM=t(l),xl=i(l,"P",{"data-svelte-h":!0}),c(xl)!=="svelte-10ekozt"&&(xl.textContent=$e),rM=t(l),J(Dl.$$.fragment,l),IM=t(l),Ll=i(l,"P",{"data-svelte-h":!0}),c(Ll)!=="svelte-1301hmt"&&(Ll.textContent=xe),mM=t(l),J(Pl.$$.fragment,l),dM=t(l),Kl=i(l,"P",{"data-svelte-h":!0}),c(Kl)!=="svelte-1bz6q0d"&&(Kl.innerHTML=De),uM=t(l),J(Ol.$$.fragment,l),bM=t(l),ls=i(l,"P",{"data-svelte-h":!0}),c(ls)!=="svelte-1gw56hk"&&(ls.innerHTML=Le),hM=t(l),J(ss.$$.fragment,l),CM=t(l),J(as.$$.fragment,l),AM=t(l),ns=i(l,"P",{"data-svelte-h":!0}),c(ns)!=="svelte-185kvde"&&(ns.innerHTML=Pe),BM=t(l),Ms=i(l,"UL",{"data-svelte-h":!0}),c(Ms)!=="svelte-1ys0gox"&&(Ms.innerHTML=Ke),ZM=t(l),J(ts.$$.fragment,l),fM=t(l),es=i(l,"P",{"data-svelte-h":!0}),c(es)!=="svelte-1yer834"&&(es.textContent=Oe),vM=t(l),Js=i(l,"OL",{"data-svelte-h":!0}),c(Js)!=="svelte-16797s5"&&(Js.innerHTML=lJ),NM=t(l),J(ys.$$.fragment,l),GM=t(l),J(ps.$$.fragment,l),gM=t(l),J(js.$$.fragment,l),RM=t(l),J(os.$$.fragment,l),EM=t(l),J(Ts.$$.fragment,l),WM=t(l),J(is.$$.fragment,l),QM=t(l),J(cs.$$.fragment,l),XM=t(l),J(ws.$$.fragment,l),VM=t(l),Us=i(l,"P",{"data-svelte-h":!0}),c(Us)!=="svelte-smkkj9"&&(Us.textContent=sJ),YM=t(l),J(rs.$$.fragment,l),kM=t(l),Is=i(l,"P",{"data-svelte-h":!0}),c(Is)!=="svelte-mitdng"&&(Is.innerHTML=aJ),zM=t(l),J(ms.$$.fragment,l),SM=t(l),J(ds.$$.fragment,l),FM=t(l),us=i(l,"P",{"data-svelte-h":!0}),c(us)!=="svelte-1ia3674"&&(us.textContent=nJ),_M=t(l),J(bs.$$.fragment,l),qM=t(l),J(hs.$$.fragment,l),HM=t(l),Cs=i(l,"P",{"data-svelte-h":!0}),c(Cs)!=="svelte-1kcnd4q"&&(Cs.textContent=MJ),$M=t(l),J(As.$$.fragment,l),xM=t(l),J(Bs.$$.fragment,l),DM=t(l),J(Zs.$$.fragment,l),LM=t(l),J(fs.$$.fragment,l),PM=t(l),J(vs.$$.fragment,l),KM=t(l),Ns=i(l,"P",{"data-svelte-h":!0}),c(Ns)!=="svelte-1bch8ue"&&(Ns.textContent=tJ),OM=t(l),J(Gs.$$.fragment,l),lt=t(l),gs=i(l,"P",{"data-svelte-h":!0}),c(gs)!=="svelte-15dk5dx"&&(gs.textContent=eJ),st=t(l),J(Rs.$$.fragment,l),at=t(l),J(Es.$$.fragment,l),nt=t(l),J(Ws.$$.fragment,l),Mt=t(l),Qs=i(l,"P",{"data-svelte-h":!0}),c(Qs)!=="svelte-1cv9gnq"&&(Qs.textContent=JJ),tt=t(l),J(Xs.$$.fragment,l),et=t(l),J(Vs.$$.fragment,l),Jt=t(l),Ys=i(l,"P",{"data-svelte-h":!0}),c(Ys)!=="svelte-ts1p6o"&&(Ys.textContent=yJ),yt=t(l),J(ks.$$.fragment,l),pt=t(l),J(zs.$$.fragment,l),jt=t(l),Ss=i(l,"P",{"data-svelte-h":!0}),c(Ss)!=="svelte-6jxcgy"&&(Ss.textContent=pJ),ot=t(l),J(Fs.$$.fragment,l),Tt=t(l),J(_s.$$.fragment,l),it=t(l),qs=i(l,"P",{"data-svelte-h":!0}),c(qs)!=="svelte-hnye80"&&(qs.textContent=jJ),ct=t(l),J(Hs.$$.fragment,l),wt=t(l),J($s.$$.fragment,l),Ut=t(l),xs=i(l,"P",{"data-svelte-h":!0}),c(xs)!=="svelte-c2quxz"&&(xs.textContent=oJ),rt=t(l),J(Ds.$$.fragment,l),It=t(l),Ls=i(l,"P",{"data-svelte-h":!0}),c(Ls)!=="svelte-1e4iate"&&(Ls.textContent=TJ),mt=t(l),J(Ps.$$.fragment,l),dt=t(l),Ks=i(l,"P",{"data-svelte-h":!0}),c(Ks)!=="svelte-zr0qdb"&&(Ks.textContent=iJ),ut=t(l),J(Os.$$.fragment,l),bt=t(l),J(la.$$.fragment,l),ht=t(l),sa=i(l,"P",{"data-svelte-h":!0}),c(sa)!=="svelte-aylawg"&&(sa.textContent=cJ),Ct=t(l),J(aa.$$.fragment,l),At=t(l),na=i(l,"P",{"data-svelte-h":!0}),c(na)!=="svelte-xcmc3w"&&(na.textContent=wJ),Bt=t(l),J(Ma.$$.fragment,l),Zt=t(l),J(ta.$$.fragment,l),ft=t(l),ea=i(l,"P",{"data-svelte-h":!0}),c(ea)!=="svelte-1tfzl84"&&(ea.textContent=UJ),vt=t(l),J(Ja.$$.fragment,l),Nt=t(l),J(ya.$$.fragment,l),Gt=t(l),pa=i(l,"P",{"data-svelte-h":!0}),c(pa)!=="svelte-12z69rp"&&(pa.textContent=rJ),gt=t(l),J(ja.$$.fragment,l),Rt=t(l),oa=i(l,"P",{"data-svelte-h":!0}),c(oa)!=="svelte-whgag1"&&(oa.textContent=IJ),Et=t(l),Ta=i(l,"OL",{"data-svelte-h":!0}),c(Ta)!=="svelte-1uaq31e"&&(Ta.innerHTML=mJ),Wt=t(l),J(ia.$$.fragment,l),Qt=t(l),J(ca.$$.fragment,l),Xt=t(l),J(wa.$$.fragment,l),Vt=t(l),J(Ua.$$.fragment,l),Yt=t(l),J(ra.$$.fragment,l),kt=t(l),J(Ia.$$.fragment,l),zt=t(l),J(ma.$$.fragment,l),St=t(l),J(da.$$.fragment,l),Ft=t(l),J(ua.$$.fragment,l),_t=t(l),J(ba.$$.fragment,l),qt=t(l),ha=i(l,"P",{"data-svelte-h":!0}),c(ha)!=="svelte-17ie6dg"&&(ha.textContent=dJ),Ht=t(l),J(Ca.$$.fragment,l),$t=t(l),J(Aa.$$.fragment,l),xt=t(l),Ba=i(l,"P",{"data-svelte-h":!0}),c(Ba)!=="svelte-1g9mait"&&(Ba.innerHTML=uJ),Dt=t(l),J(Za.$$.fragment,l),Lt=t(l),J(fa.$$.fragment,l),Pt=t(l),va=i(l,"P",{"data-svelte-h":!0}),c(va)!=="svelte-1dunpoe"&&(va.textContent=bJ),Kt=t(l),Na=i(l,"UL",{"data-svelte-h":!0}),c(Na)!=="svelte-9618na"&&(Na.innerHTML=hJ),Ot=t(l),Ga=i(l,"P",{"data-svelte-h":!0}),c(Ga)!=="svelte-14gl1jw"&&(Ga.textContent=CJ),le=t(l),ga=i(l,"UL",{"data-svelte-h":!0}),c(ga)!=="svelte-1v3ez0d"&&(ga.innerHTML=AJ),se=t(l),Ra=i(l,"P",{"data-svelte-h":!0}),c(Ra)!=="svelte-69g816"&&(Ra.textContent=BJ),ae=t(l),Ea=i(l,"P",{"data-svelte-h":!0}),c(Ea)!=="svelte-1t287zt"&&(Ea.innerHTML=ZJ),ne=t(l),J(Wa.$$.fragment,l),Me=t(l),Xa=i(l,"P",{}),fJ(Xa).forEach(a),this.h()},h(){vJ(r,"name","hf:doc:metadata"),vJ(r,"content",YJ)},m(l,s){QJ(document.head,r),n(l,Va,s),n(l,Qa,s),n(l,Ya,s),y(I,l,s),n(l,ka,s),n(l,m,s),n(l,za,s),n(l,d,s),n(l,Sa,s),n(l,u,s),n(l,Fa,s),y(b,l,s),n(l,_a,s),n(l,h,s),n(l,qa,s),y(C,l,s),n(l,Ha,s),n(l,A,s),n(l,$a,s),y(B,l,s),n(l,xa,s),n(l,Z,s),n(l,Da,s),n(l,f,s),n(l,La,s),y(v,l,s),n(l,Pa,s),n(l,N,s),n(l,Ka,s),n(l,G,s),n(l,Oa,s),y(g,l,s),n(l,ln,s),n(l,R,s),n(l,sn,s),n(l,E,s),n(l,an,s),y(W,l,s),n(l,nn,s),n(l,Q,s),n(l,Mn,s),n(l,X,s),n(l,tn,s),y(V,l,s),n(l,en,s),n(l,Y,s),n(l,Jn,s),n(l,k,s),n(l,yn,s),n(l,z,s),n(l,pn,s),y(S,l,s),n(l,jn,s),n(l,F,s),n(l,on,s),y(_,l,s),n(l,Tn,s),n(l,q,s),n(l,cn,s),n(l,H,s),n(l,wn,s),n(l,$,s),n(l,Un,s),y(x,l,s),n(l,rn,s),n(l,D,s),n(l,In,s),y(L,l,s),n(l,mn,s),n(l,P,s),n(l,dn,s),y(K,l,s),n(l,un,s),y(O,l,s),n(l,bn,s),n(l,ll,s),n(l,hn,s),y(sl,l,s),n(l,Cn,s),y(al,l,s),n(l,An,s),n(l,nl,s),n(l,Bn,s),y(Ml,l,s),n(l,Zn,s),y(tl,l,s),n(l,fn,s),n(l,el,s),n(l,vn,s),y(Jl,l,s),n(l,Nn,s),y(yl,l,s),n(l,Gn,s),n(l,pl,s),n(l,gn,s),y(jl,l,s),n(l,Rn,s),y(ol,l,s),n(l,En,s),n(l,Tl,s),n(l,Wn,s),y(il,l,s),n(l,Qn,s),y(cl,l,s),n(l,Xn,s),n(l,wl,s),n(l,Vn,s),y(Ul,l,s),n(l,Yn,s),y(rl,l,s),n(l,kn,s),n(l,Il,s),n(l,zn,s),y(ml,l,s),n(l,Sn,s),y(dl,l,s),n(l,Fn,s),n(l,ul,s),n(l,_n,s),n(l,bl,s),n(l,qn,s),n(l,hl,s),n(l,Hn,s),n(l,Cl,s),n(l,$n,s),y(Al,l,s),n(l,xn,s),y(Bl,l,s),n(l,Dn,s),n(l,Zl,s),n(l,Ln,s),y(fl,l,s),n(l,Pn,s),y(vl,l,s),n(l,Kn,s),n(l,Nl,s),n(l,On,s),y(Gl,l,s),n(l,lM,s),y(gl,l,s),n(l,sM,s),n(l,Rl,s),n(l,aM,s),y(El,l,s),n(l,nM,s),y(Wl,l,s),n(l,MM,s),n(l,Ql,s),n(l,tM,s),y(Xl,l,s),n(l,eM,s),y(Vl,l,s),n(l,JM,s),n(l,Yl,s),n(l,yM,s),y(kl,l,s),n(l,pM,s),y(zl,l,s),n(l,jM,s),n(l,Sl,s),n(l,oM,s),y(Fl,l,s),n(l,TM,s),y(_l,l,s),n(l,iM,s),n(l,ql,s),n(l,cM,s),y(Hl,l,s),n(l,wM,s),y($l,l,s),n(l,UM,s),n(l,xl,s),n(l,rM,s),y(Dl,l,s),n(l,IM,s),n(l,Ll,s),n(l,mM,s),y(Pl,l,s),n(l,dM,s),n(l,Kl,s),n(l,uM,s),y(Ol,l,s),n(l,bM,s),n(l,ls,s),n(l,hM,s),y(ss,l,s),n(l,CM,s),y(as,l,s),n(l,AM,s),n(l,ns,s),n(l,BM,s),n(l,Ms,s),n(l,ZM,s),y(ts,l,s),n(l,fM,s),n(l,es,s),n(l,vM,s),n(l,Js,s),n(l,NM,s),y(ys,l,s),n(l,GM,s),y(ps,l,s),n(l,gM,s),y(js,l,s),n(l,RM,s),y(os,l,s),n(l,EM,s),y(Ts,l,s),n(l,WM,s),y(is,l,s),n(l,QM,s),y(cs,l,s),n(l,XM,s),y(ws,l,s),n(l,VM,s),n(l,Us,s),n(l,YM,s),y(rs,l,s),n(l,kM,s),n(l,Is,s),n(l,zM,s),y(ms,l,s),n(l,SM,s),y(ds,l,s),n(l,FM,s),n(l,us,s),n(l,_M,s),y(bs,l,s),n(l,qM,s),y(hs,l,s),n(l,HM,s),n(l,Cs,s),n(l,$M,s),y(As,l,s),n(l,xM,s),y(Bs,l,s),n(l,DM,s),y(Zs,l,s),n(l,LM,s),y(fs,l,s),n(l,PM,s),y(vs,l,s),n(l,KM,s),n(l,Ns,s),n(l,OM,s),y(Gs,l,s),n(l,lt,s),n(l,gs,s),n(l,st,s),y(Rs,l,s),n(l,at,s),y(Es,l,s),n(l,nt,s),y(Ws,l,s),n(l,Mt,s),n(l,Qs,s),n(l,tt,s),y(Xs,l,s),n(l,et,s),y(Vs,l,s),n(l,Jt,s),n(l,Ys,s),n(l,yt,s),y(ks,l,s),n(l,pt,s),y(zs,l,s),n(l,jt,s),n(l,Ss,s),n(l,ot,s),y(Fs,l,s),n(l,Tt,s),y(_s,l,s),n(l,it,s),n(l,qs,s),n(l,ct,s),y(Hs,l,s),n(l,wt,s),y($s,l,s),n(l,Ut,s),n(l,xs,s),n(l,rt,s),y(Ds,l,s),n(l,It,s),n(l,Ls,s),n(l,mt,s),y(Ps,l,s),n(l,dt,s),n(l,Ks,s),n(l,ut,s),y(Os,l,s),n(l,bt,s),y(la,l,s),n(l,ht,s),n(l,sa,s),n(l,Ct,s),y(aa,l,s),n(l,At,s),n(l,na,s),n(l,Bt,s),y(Ma,l,s),n(l,Zt,s),y(ta,l,s),n(l,ft,s),n(l,ea,s),n(l,vt,s),y(Ja,l,s),n(l,Nt,s),y(ya,l,s),n(l,Gt,s),n(l,pa,s),n(l,gt,s),y(ja,l,s),n(l,Rt,s),n(l,oa,s),n(l,Et,s),n(l,Ta,s),n(l,Wt,s),y(ia,l,s),n(l,Qt,s),y(ca,l,s),n(l,Xt,s),y(wa,l,s),n(l,Vt,s),y(Ua,l,s),n(l,Yt,s),y(ra,l,s),n(l,kt,s),y(Ia,l,s),n(l,zt,s),y(ma,l,s),n(l,St,s),y(da,l,s),n(l,Ft,s),y(ua,l,s),n(l,_t,s),y(ba,l,s),n(l,qt,s),n(l,ha,s),n(l,Ht,s),y(Ca,l,s),n(l,$t,s),y(Aa,l,s),n(l,xt,s),n(l,Ba,s),n(l,Dt,s),y(Za,l,s),n(l,Lt,s),y(fa,l,s),n(l,Pt,s),n(l,va,s),n(l,Kt,s),n(l,Na,s),n(l,Ot,s),n(l,Ga,s),n(l,le,s),n(l,ga,s),n(l,se,s),n(l,Ra,s),n(l,ae,s),n(l,Ea,s),n(l,ne,s),y(Wa,l,s),n(l,Me,s),n(l,Xa,s),te=!0},p:GJ,i(l){te||(p(I.$$.fragment,l),p(b.$$.fragment,l),p(C.$$.fragment,l),p(B.$$.fragment,l),p(v.$$.fragment,l),p(g.$$.fragment,l),p(W.$$.fragment,l),p(V.$$.fragment,l),p(S.$$.fragment,l),p(_.$$.fragment,l),p(x.$$.fragment,l),p(L.$$.fragment,l),p(K.$$.fragment,l),p(O.$$.fragment,l),p(sl.$$.fragment,l),p(al.$$.fragment,l),p(Ml.$$.fragment,l),p(tl.$$.fragment,l),p(Jl.$$.fragment,l),p(yl.$$.fragment,l),p(jl.$$.fragment,l),p(ol.$$.fragment,l),p(il.$$.fragment,l),p(cl.$$.fragment,l),p(Ul.$$.fragment,l),p(rl.$$.fragment,l),p(ml.$$.fragment,l),p(dl.$$.fragment,l),p(Al.$$.fragment,l),p(Bl.$$.fragment,l),p(fl.$$.fragment,l),p(vl.$$.fragment,l),p(Gl.$$.fragment,l),p(gl.$$.fragment,l),p(El.$$.fragment,l),p(Wl.$$.fragment,l),p(Xl.$$.fragment,l),p(Vl.$$.fragment,l),p(kl.$$.fragment,l),p(zl.$$.fragment,l),p(Fl.$$.fragment,l),p(_l.$$.fragment,l),p(Hl.$$.fragment,l),p($l.$$.fragment,l),p(Dl.$$.fragment,l),p(Pl.$$.fragment,l),p(Ol.$$.fragment,l),p(ss.$$.fragment,l),p(as.$$.fragment,l),p(ts.$$.fragment,l),p(ys.$$.fragment,l),p(ps.$$.fragment,l),p(js.$$.fragment,l),p(os.$$.fragment,l),p(Ts.$$.fragment,l),p(is.$$.fragment,l),p(cs.$$.fragment,l),p(ws.$$.fragment,l),p(rs.$$.fragment,l),p(ms.$$.fragment,l),p(ds.$$.fragment,l),p(bs.$$.fragment,l),p(hs.$$.fragment,l),p(As.$$.fragment,l),p(Bs.$$.fragment,l),p(Zs.$$.fragment,l),p(fs.$$.fragment,l),p(vs.$$.fragment,l),p(Gs.$$.fragment,l),p(Rs.$$.fragment,l),p(Es.$$.fragment,l),p(Ws.$$.fragment,l),p(Xs.$$.fragment,l),p(Vs.$$.fragment,l),p(ks.$$.fragment,l),p(zs.$$.fragment,l),p(Fs.$$.fragment,l),p(_s.$$.fragment,l),p(Hs.$$.fragment,l),p($s.$$.fragment,l),p(Ds.$$.fragment,l),p(Ps.$$.fragment,l),p(Os.$$.fragment,l),p(la.$$.fragment,l),p(aa.$$.fragment,l),p(Ma.$$.fragment,l),p(ta.$$.fragment,l),p(Ja.$$.fragment,l),p(ya.$$.fragment,l),p(ja.$$.fragment,l),p(ia.$$.fragment,l),p(ca.$$.fragment,l),p(wa.$$.fragment,l),p(Ua.$$.fragment,l),p(ra.$$.fragment,l),p(Ia.$$.fragment,l),p(ma.$$.fragment,l),p(da.$$.fragment,l),p(ua.$$.fragment,l),p(ba.$$.fragment,l),p(Ca.$$.fragment,l),p(Aa.$$.fragment,l),p(Za.$$.fragment,l),p(fa.$$.fragment,l),p(Wa.$$.fragment,l),te=!0)},o(l){j(I.$$.fragment,l),j(b.$$.fragment,l),j(C.$$.fragment,l),j(B.$$.fragment,l),j(v.$$.fragment,l),j(g.$$.fragment,l),j(W.$$.fragment,l),j(V.$$.fragment,l),j(S.$$.fragment,l),j(_.$$.fragment,l),j(x.$$.fragment,l),j(L.$$.fragment,l),j(K.$$.fragment,l),j(O.$$.fragment,l),j(sl.$$.fragment,l),j(al.$$.fragment,l),j(Ml.$$.fragment,l),j(tl.$$.fragment,l),j(Jl.$$.fragment,l),j(yl.$$.fragment,l),j(jl.$$.fragment,l),j(ol.$$.fragment,l),j(il.$$.fragment,l),j(cl.$$.fragment,l),j(Ul.$$.fragment,l),j(rl.$$.fragment,l),j(ml.$$.fragment,l),j(dl.$$.fragment,l),j(Al.$$.fragment,l),j(Bl.$$.fragment,l),j(fl.$$.fragment,l),j(vl.$$.fragment,l),j(Gl.$$.fragment,l),j(gl.$$.fragment,l),j(El.$$.fragment,l),j(Wl.$$.fragment,l),j(Xl.$$.fragment,l),j(Vl.$$.fragment,l),j(kl.$$.fragment,l),j(zl.$$.fragment,l),j(Fl.$$.fragment,l),j(_l.$$.fragment,l),j(Hl.$$.fragment,l),j($l.$$.fragment,l),j(Dl.$$.fragment,l),j(Pl.$$.fragment,l),j(Ol.$$.fragment,l),j(ss.$$.fragment,l),j(as.$$.fragment,l),j(ts.$$.fragment,l),j(ys.$$.fragment,l),j(ps.$$.fragment,l),j(js.$$.fragment,l),j(os.$$.fragment,l),j(Ts.$$.fragment,l),j(is.$$.fragment,l),j(cs.$$.fragment,l),j(ws.$$.fragment,l),j(rs.$$.fragment,l),j(ms.$$.fragment,l),j(ds.$$.fragment,l),j(bs.$$.fragment,l),j(hs.$$.fragment,l),j(As.$$.fragment,l),j(Bs.$$.fragment,l),j(Zs.$$.fragment,l),j(fs.$$.fragment,l),j(vs.$$.fragment,l),j(Gs.$$.fragment,l),j(Rs.$$.fragment,l),j(Es.$$.fragment,l),j(Ws.$$.fragment,l),j(Xs.$$.fragment,l),j(Vs.$$.fragment,l),j(ks.$$.fragment,l),j(zs.$$.fragment,l),j(Fs.$$.fragment,l),j(_s.$$.fragment,l),j(Hs.$$.fragment,l),j($s.$$.fragment,l),j(Ds.$$.fragment,l),j(Ps.$$.fragment,l),j(Os.$$.fragment,l),j(la.$$.fragment,l),j(aa.$$.fragment,l),j(Ma.$$.fragment,l),j(ta.$$.fragment,l),j(Ja.$$.fragment,l),j(ya.$$.fragment,l),j(ja.$$.fragment,l),j(ia.$$.fragment,l),j(ca.$$.fragment,l),j(wa.$$.fragment,l),j(Ua.$$.fragment,l),j(ra.$$.fragment,l),j(Ia.$$.fragment,l),j(ma.$$.fragment,l),j(da.$$.fragment,l),j(ua.$$.fragment,l),j(ba.$$.fragment,l),j(Ca.$$.fragment,l),j(Aa.$$.fragment,l),j(Za.$$.fragment,l),j(fa.$$.fragment,l),j(Wa.$$.fragment,l),te=!1},d(l){l&&(a(Va),a(Qa),a(Ya),a(ka),a(m),a(za),a(d),a(Sa),a(u),a(Fa),a(_a),a(h),a(qa),a(Ha),a(A),a($a),a(xa),a(Z),a(Da),a(f),a(La),a(Pa),a(N),a(Ka),a(G),a(Oa),a(ln),a(R),a(sn),a(E),a(an),a(nn),a(Q),a(Mn),a(X),a(tn),a(en),a(Y),a(Jn),a(k),a(yn),a(z),a(pn),a(jn),a(F),a(on),a(Tn),a(q),a(cn),a(H),a(wn),a($),a(Un),a(rn),a(D),a(In),a(mn),a(P),a(dn),a(un),a(bn),a(ll),a(hn),a(Cn),a(An),a(nl),a(Bn),a(Zn),a(fn),a(el),a(vn),a(Nn),a(Gn),a(pl),a(gn),a(Rn),a(En),a(Tl),a(Wn),a(Qn),a(Xn),a(wl),a(Vn),a(Yn),a(kn),a(Il),a(zn),a(Sn),a(Fn),a(ul),a(_n),a(bl),a(qn),a(hl),a(Hn),a(Cl),a($n),a(xn),a(Dn),a(Zl),a(Ln),a(Pn),a(Kn),a(Nl),a(On),a(lM),a(sM),a(Rl),a(aM),a(nM),a(MM),a(Ql),a(tM),a(eM),a(JM),a(Yl),a(yM),a(pM),a(jM),a(Sl),a(oM),a(TM),a(iM),a(ql),a(cM),a(wM),a(UM),a(xl),a(rM),a(IM),a(Ll),a(mM),a(dM),a(Kl),a(uM),a(bM),a(ls),a(hM),a(CM),a(AM),a(ns),a(BM),a(Ms),a(ZM),a(fM),a(es),a(vM),a(Js),a(NM),a(GM),a(gM),a(RM),a(EM),a(WM),a(QM),a(XM),a(VM),a(Us),a(YM),a(kM),a(Is),a(zM),a(SM),a(FM),a(us),a(_M),a(qM),a(HM),a(Cs),a($M),a(xM),a(DM),a(LM),a(PM),a(KM),a(Ns),a(OM),a(lt),a(gs),a(st),a(at),a(nt),a(Mt),a(Qs),a(tt),a(et),a(Jt),a(Ys),a(yt),a(pt),a(jt),a(Ss),a(ot),a(Tt),a(it),a(qs),a(ct),a(wt),a(Ut),a(xs),a(rt),a(It),a(Ls),a(mt),a(dt),a(Ks),a(ut),a(bt),a(ht),a(sa),a(Ct),a(At),a(na),a(Bt),a(Zt),a(ft),a(ea),a(vt),a(Nt),a(Gt),a(pa),a(gt),a(Rt),a(oa),a(Et),a(Ta),a(Wt),a(Qt),a(Xt),a(Vt),a(Yt),a(kt),a(zt),a(St),a(Ft),a(_t),a(qt),a(ha),a(Ht),a($t),a(xt),a(Ba),a(Dt),a(Lt),a(Pt),a(va),a(Kt),a(Na),a(Ot),a(Ga),a(le),a(ga),a(se),a(Ra),a(ae),a(Ea),a(ne),a(Me),a(Xa)),a(r),o(I,l),o(b,l),o(C,l),o(B,l),o(v,l),o(g,l),o(W,l),o(V,l),o(S,l),o(_,l),o(x,l),o(L,l),o(K,l),o(O,l),o(sl,l),o(al,l),o(Ml,l),o(tl,l),o(Jl,l),o(yl,l),o(jl,l),o(ol,l),o(il,l),o(cl,l),o(Ul,l),o(rl,l),o(ml,l),o(dl,l),o(Al,l),o(Bl,l),o(fl,l),o(vl,l),o(Gl,l),o(gl,l),o(El,l),o(Wl,l),o(Xl,l),o(Vl,l),o(kl,l),o(zl,l),o(Fl,l),o(_l,l),o(Hl,l),o($l,l),o(Dl,l),o(Pl,l),o(Ol,l),o(ss,l),o(as,l),o(ts,l),o(ys,l),o(ps,l),o(js,l),o(os,l),o(Ts,l),o(is,l),o(cs,l),o(ws,l),o(rs,l),o(ms,l),o(ds,l),o(bs,l),o(hs,l),o(As,l),o(Bs,l),o(Zs,l),o(fs,l),o(vs,l),o(Gs,l),o(Rs,l),o(Es,l),o(Ws,l),o(Xs,l),o(Vs,l),o(ks,l),o(zs,l),o(Fs,l),o(_s,l),o(Hs,l),o($s,l),o(Ds,l),o(Ps,l),o(Os,l),o(la,l),o(aa,l),o(Ma,l),o(ta,l),o(Ja,l),o(ya,l),o(ja,l),o(ia,l),o(ca,l),o(wa,l),o(Ua,l),o(ra,l),o(Ia,l),o(ma,l),o(da,l),o(ua,l),o(ba,l),o(Ca,l),o(Aa,l),o(Za,l),o(fa,l),o(Wa,l)}}}const YJ='{"title":"RobotProcessor: The Art of Processing Robot Data","local":"robotprocessor-the-art-of-processing-robot-data","sections":[{"title":"Real-World Scenarios: When You Need RobotProcessor","local":"real-world-scenarios-when-you-need-robotprocessor","sections":[{"title":"Observation Key Mismatches","local":"observation-key-mismatches","sections":[],"depth":3},{"title":"Image Preprocessing Requirements","local":"image-preprocessing-requirements","sections":[],"depth":3},{"title":"Coordinate System Transformations","local":"coordinate-system-transformations","sections":[],"depth":3},{"title":"State Augmentation","local":"state-augmentation","sections":[],"depth":3},{"title":"Multi-Robot Deployment","local":"multi-robot-deployment","sections":[],"depth":3},{"title":"Data Collection and Training","local":"data-collection-and-training","sections":[],"depth":3}],"depth":2},{"title":"Why RobotProcessor?","local":"why-robotprocessor","sections":[],"depth":2},{"title":"Understanding EnvTransition and Batch Format","local":"understanding-envtransition-and-batch-format","sections":[{"title":"1. EnvTransition Tuple Format","local":"1-envtransition-tuple-format","sections":[],"depth":3},{"title":"2. Batch Dictionary Format","local":"2-batch-dictionary-format","sections":[],"depth":3},{"title":"Automatic Format Conversion","local":"automatic-format-conversion","sections":[],"depth":3},{"title":"Using TransitionIndex","local":"using-transitionindex","sections":[],"depth":3},{"title":"Default Conversion Functions","local":"default-conversion-functions","sections":[],"depth":3},{"title":"Custom Conversion Functions","local":"custom-conversion-functions","sections":[],"depth":3},{"title":"Advanced: Controlling Output Format with to_output","local":"advanced-controlling-output-format-with-tooutput","sections":[],"depth":3},{"title":"Real-World Example: Environment Interaction","local":"real-world-example-environment-interaction","sections":[],"depth":3},{"title":"When to Use Different Output Formats","local":"when-to-use-different-output-formats","sections":[],"depth":3},{"title":"Why “next.reward”, “next.done”, “next.truncated”?","local":"why-nextreward-nextdone-nexttruncated","sections":[],"depth":3}],"depth":2},{"title":"Your First RobotProcessor","local":"your-first-robotprocessor","sections":[],"depth":2},{"title":"Working with LeRobot Datasets and Replay Buffers","local":"working-with-lerobot-datasets-and-replay-buffers","sections":[],"depth":2},{"title":"Integration with Replay Buffers","local":"integration-with-replay-buffers","sections":[],"depth":2},{"title":"Creating Custom Steps: The ProcessorStep Protocol","local":"creating-custom-steps-the-processorstep-protocol","sections":[{"title":"Important: get_config vs state_dict","local":"important-getconfig-vs-statedict","sections":[],"depth":3}],"depth":2},{"title":"Using Complementary Data for Inter-Step Communication","local":"using-complementary-data-for-inter-step-communication","sections":[],"depth":2},{"title":"Loading Processors with Overrides: Handling Non-Serializable Objects","local":"loading-processors-with-overrides-handling-non-serializable-objects","sections":[{"title":"The Problem: Non-Serializable Parameters","local":"the-problem-non-serializable-parameters","sections":[],"depth":3},{"title":"The Solution: Override Parameters","local":"the-solution-override-parameters","sections":[],"depth":3},{"title":"How Overrides Work","local":"how-overrides-work","sections":[],"depth":3},{"title":"Real-World Examples","local":"real-world-examples","sections":[{"title":"Example 1: Environment-Dependent Steps","local":"example-1-environment-dependent-steps","sections":[],"depth":4},{"title":"Example 2: Device and Hardware Configuration","local":"example-2-device-and-hardware-configuration","sections":[],"depth":4},{"title":"Example 3: Multiple Environment Deployment","local":"example-3-multiple-environment-deployment","sections":[],"depth":4}],"depth":3},{"title":"Override Key Matching Rules","local":"override-key-matching-rules","sections":[{"title":"For Registered Steps","local":"for-registered-steps","sections":[],"depth":4},{"title":"For Unregistered Steps","local":"for-unregistered-steps","sections":[],"depth":4}],"depth":3},{"title":"Error Handling and Validation","local":"error-handling-and-validation","sections":[{"title":"Invalid Override Keys","local":"invalid-override-keys","sections":[],"depth":4},{"title":"Instantiation Errors","local":"instantiation-errors","sections":[],"depth":4}],"depth":3},{"title":"Multiple Steps with Same Class Name","local":"multiple-steps-with-same-class-name","sections":[],"depth":3},{"title":"Best Practices for Overrides","local":"best-practices-for-overrides","sections":[{"title":"1. Design Steps for Overrides","local":"1-design-steps-for-overrides","sections":[],"depth":4},{"title":"2. Use Registry Names for Clarity","local":"2-use-registry-names-for-clarity","sections":[],"depth":4},{"title":"3. Document Override Requirements","local":"3-document-override-requirements","sections":[],"depth":4},{"title":"4. Environment-Specific Configuration Files","local":"4-environment-specific-configuration-files","sections":[],"depth":4}],"depth":3},{"title":"Integration with Hub Sharing","local":"integration-with-hub-sharing","sections":[],"depth":3}],"depth":2},{"title":"Complete Example: Device-Aware Processing Pipeline","local":"complete-example-device-aware-processing-pipeline","sections":[],"depth":2},{"title":"Solving Real-World Problems with RobotProcessor","local":"solving-real-world-problems-with-robotprocessor","sections":[{"title":"Renaming Observation Keys","local":"renaming-observation-keys","sections":[],"depth":3},{"title":"Workspace-Focused Image Processing","local":"workspace-focused-image-processing","sections":[],"depth":3},{"title":"Building Complete Pipelines for Different Robots","local":"building-complete-pipelines-for-different-robots","sections":[],"depth":3}],"depth":2},{"title":"Best Practices for Processor Steps","local":"best-practices-for-processor-steps","sections":[{"title":"1. Always Check for None","local":"1-always-check-for-none","sections":[],"depth":3},{"title":"2. Preserve Transition Structure","local":"2-preserve-transition-structure","sections":[],"depth":3},{"title":"3. Clone When Storing State","local":"3-clone-when-storing-state","sections":[],"depth":3},{"title":"4. Handle Device Transfers in state_dict","local":"4-handle-device-transfers-in-statedict","sections":[],"depth":3}],"depth":2},{"title":"Complete Policy Example with Pre and Post Processing","local":"complete-policy-example-with-pre-and-post-processing","sections":[],"depth":2},{"title":"Debugging and Monitoring","local":"debugging-and-monitoring","sections":[],"depth":2},{"title":"Summary","local":"summary","sections":[],"depth":2}],"depth":1}';function kJ(ee){return gJ(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class qJ extends RJ{constructor(r){super(),EJ(this,r,kJ,VJ,NJ,{})}}export{qJ as component};
