import{s as ue,o as we,n as Ce}from"../chunks/scheduler.65852ee5.js";import{S as Ie,i as ge,g as M,s as t,r as o,A as be,h as i,f as e,c as n,j as Je,u as j,x as p,k as Te,y as Ae,a,v as c,d as y,t as r,w as U}from"../chunks/index.aa74147d.js";import{T as fe}from"../chunks/Tip.bb8ccac8.js";import{D as Ee,C as d}from"../chunks/DocNotebookDropdown.479f4286.js";import{H as m,E as Be}from"../chunks/EditOnGithub.4eda6a96.js";function Ze(Zs){let h,u="This notebook has been tested with ES 8.13.x, and 8.14.x";return{c(){h=M("p"),h.textContent=u},l(J){h=i(J,"P",{"data-svelte-h":!0}),p(h)!=="svelte-ractay"&&(h.textContent=u)},m(J,Es){a(J,h,Es)},p:Ce,d(J){J&&e(h)}}}function Ve(Zs){let h,u,J,Es,w,Vs,C,Rs,I,vl='Authored By: <a href="https://huggingface.co/lloydmeta" rel="nofollow">lloydmeta</a>',Gs,g,ql="This notebook walks you through building a Retrieval-Augmented Generation (RAG) powered by Elasticsearch (ES) and Hugging Face models, letting you toggle between ES-vectorising (your ES cluster vectorises for you when ingesting and querying) vs self-vectorising (you vectorise all your data before sending it to ES).",ks,b,Xl="What should you use for your use case? <em>It depends</em> 🤷‍♂️. ES-vectorising means your clients don’t have to implement it, so that’s the default here; however, if you don’t have any ML nodes, or your own embedding setup is better/faster, feel free to set <code>USE_ELASTICSEARCH_VECTORISATION</code> to <code>False</code> in the <code>Choose data and query vectorisation options</code> section below!",Ss,T,Qs,A,Ws,f,Ns,E,_s,B,vs,Z,$l="This allows you to authenticate with Hugging Face to download models and datasets.",qs,V,Xs,R,$s,G,Fl='Let’s make sure that you can access your Elasticsearch deployment. If you don’t have one, create one at <a href="https://www.elastic.co/search-labs/tutorials/install-elasticsearch/elastic-cloud#creating-a-cloud-deployment" rel="nofollow">Elastic Cloud</a>.',Fs,k,xl="Ensure you have <code>CLOUD_ID</code> and <code>ELASTIC_DEPL_API_KEY</code> saved as Colab secrets.",xs,S,Hl='<img src="https://huggingface.co/datasets/huggingface/cookbook-images/resolve/main/colab-secrets.jpeg" alt="Image of how to set up secrets using Google Colab"/>',Hs,Q,Ys,W,Yl="Set up the client and make sure the credentials work.",zs,N,Ls,_,Ds,v,zl=`The data utilised in this tutorial is sourced from Hugging Face datasets, specifically the
<a href="https://huggingface.co/datasets/MongoDB/embedded_movies" rel="nofollow">MongoDB/embedded_movies dataset</a>.`,Ps,q,Os,X,Ll="The operations within the following code snippet below focus on enforcing data integrity and quality.",Ks,$,Dl="<li>The first process ensures that each data point’s <code>fullplot</code> attribute is not empty, as this is the primary data we utilise in the embedding process.</li> <li>The second step also ensures we remove the <code>plot_embedding</code> attribute from all data points as this will be replaced by new embeddings created with a different embedding model, the <code>gte-large</code>.</li>",sl,F,ll,x,el,H,al,Y,Pl="Here, you need to make a decision: do you want Elasticsearch to vectorise your data and queries, or do you want to do it yourself?",tl,z,Ol="Setting <code>USE_ELASTICSEARCH_VECTORISATION</code> to <code>True</code> will make the rest of this notebook set up and use ES-hosted-vectorisation for your data and your querying, but <strong>BE AWARE</strong> that this requires your ES deployment to have at least 1 ML node (I would recommend setting autoscaling to true on your Cloud deployment in case the model you choose is too big).",nl,L,Kl="If <code>USE_ELASTICSEARCH_VECTORISATION</code> is <code>False</code>, this notebook will set up and use the provided model “locally” for data and query vectorisation.",Ml,D,se='Here, I’ve picked the <a href="https://huggingface.co/thenlper/gte-small" rel="nofollow">thenlper/gte-small</a> model for really no other reason than it was used in another cookbook, and it worked well enough for me. Please feel free to try others if you’d like - the only important thing is that you update the <code>EMBEDDING_DIMENSIONS</code> according to the model.',il,P,le="<strong>Note</strong>: if you change these values, you’ll likely need to re-run the notebook from this step.",pl,O,ol,K,jl,ss,ee='This step loads and deploys the Hugging Face model into Elasticsearch using <a href="https://eland.readthedocs.io/en/v8.12.1/" rel="nofollow">Eland</a>, if <code>USE_ELASTICSEARCH_VECTORISATION</code> is <code>True</code>. This allows Elasticsearch to vectorise your queries, and data in later steps.',cl,ls,yl,es,ae="This step adds functions for creating embeddings for text locally, and enriches the dataset with embeddings, so that the data can be ingested into Elasticsearch as vectors. Does not run if <code>USE_ELASTICSEARCH_VECTORISATION</code> is True.",rl,as,Ul,ts,hl,ns,te="At this point, we create an index in Elasticsearch with the right index mappings to handle vector searches.",dl,Ms,ne='Go here to read more about <a href="https://www.elastic.co/what-is/vector-search" rel="nofollow">Elasticsearch vector capabilities</a>.',ml,is,Jl,ps,Me=`Creating index movies
`,Tl,os,ie="Ingesting data into a Elasticsearch is best done in batches. Luckily <code>helpers</code> offers an easy way to do this.",ul,js,wl,cs,pe=`batch: start [0], end [100]
batch: start [100], end [200]
batch: start [200], end [300]
batch: start [300], end [400]
batch: start [400], end [500]
batch: start [500], end [600]
batch: start [600], end [700]
batch: start [700], end [800]
batch: start [800], end [900]
batch: start [900], end [1000]
batch: start [1000], end [1100]
batch: start [1100], end [1200]
batch: start [1200], end [1300]
batch: start [1300], end [1400]
batch: start [1400], end [1452]
Data ingestion into Elasticsearch complete!
`,Cl,ys,Il,rs,oe="The following step implements a function that returns a vector search result.",gl,Us,je=`If <code>USE_ELASTICSEARCH_VECTORISATION</code> is true, the text query is sent directly to
ES where the uploaded model will be used to vectorise it first before doing a vector search. If <code>USE_ELASTICSEARCH_VECTORISATION</code> is false, then we do the
vectorising locally before sending a query with the vectorised form of the query.`,bl,hs,Al,ds,fl,ms,El,Js,ce=`Query: What is the best romantic movie to watch and why?
Continue to answer the query by using these Search Results:
Title: Shut Up and Kiss Me!, Plot: Ryan and Pete are 27-year old best friends in Miami, born on the same day and each searching for the perfect woman. Ryan is a rookie stockbroker living with his psychic Mom. Pete is a slick surfer dude yet to find commitment. Each meets the women of their dreams on the same day. Ryan knocks heads in an elevator with the gorgeous Jessica, passing out before getting her number. Pete falls for the insatiable Tiara, but Tiara's uncle is mob boss Vincent Bublione, charged with her protection. This high-energy romantic comedy asks to what extent will you go for true love?
Title: Titanic, Plot: The plot focuses on the romances of two couples upon the doomed ship's maiden voyage. Isabella Paradine (Catherine Zeta-Jones) is a wealthy woman mourning the loss of her aunt, who reignites a romance with former flame Wynn Park (Peter Gallagher). Meanwhile, a charming ne'er-do-well named Jamie Perse (Mike Doyle) steals a ticket for the ship, and falls for a sweet innocent Irish girl on board. But their romance is threatened by the villainous Simon Doonan (Tim Curry), who has discovered about the ticket and makes Jamie his unwilling accomplice, as well as having sinister plans for the girl.
Title: Dark Blue World, Plot: March 15, 1939: Germany invades Czechoslovakia. Czech and Slovak pilots flee to England, joining the RAF. After the war, back home, they are put in labor camps, suspected of anti-Communist ideas. This film cuts between a post-war camp where Franta is a prisoner and England during the war, where Franta is like a big brother to Karel, a very young pilot. On maneuvers, Karel crash lands by the rural home of Susan, an English woman whose husband is MIA. She spends one night with Karel, and he thinks he's found the love of his life. It's complicated by Susan's attraction to Franta. How will the three handle innocence, Eros, friendship, and the heat of battle? When war ends, what then?
Title: Dark Blue World, Plot: March 15, 1939: Germany invades Czechoslovakia. Czech and Slovak pilots flee to England, joining the RAF. After the war, back home, they are put in labor camps, suspected of anti-Communist ideas. This film cuts between a post-war camp where Franta is a prisoner and England during the war, where Franta is like a big brother to Karel, a very young pilot. On maneuvers, Karel crash lands by the rural home of Susan, an English woman whose husband is MIA. She spends one night with Karel, and he thinks he's found the love of his life. It's complicated by Susan's attraction to Franta. How will the three handle innocence, Eros, friendship, and the heat of battle? When war ends, what then?
Title: No Good Deed, Plot: About a police detective, Jack, who, while doing a friend a favor and searching for a runaway teenager on Turk Street, stumbles upon a bizarre band of criminals about to pull off a bank robbery. Jack finds himself being held hostage while the criminals decide what to do with him, and the leader's beautiful girlfriend, Erin, is left alone to watch Jack. Erin, who we discover is a master manipulator of the men in the gang, reveals another side to Jack - a melancholy romantic who could have been a classical cellist. She finds Jack's captivity an irresistible turn-on and he can't figure out if she's for real, or manipulating him, too. Before the gang returns, Jack and Erin's connection intensifies and who ends up with the money is anyone's guess.
.
`,Bl,Ts,ye='Load our LLM (here we use <a href="https://huggingface.co/google/gemma-2b-it" rel="nofollow">google/gemma-2b-lt</a>)',Zl,us,Vl,ws,re="Define a method that fetches formatted results from a vectorised search in ES, then feed it to the LLM to get our results.",Rl,Cs,Gl,Is,Ue=`Query: What's a romantic movie that I can watch with my wife?
Continue to answer the query by using these Search Results:
Title: King Solomon's Mines, Plot: Guide Allan Quatermain helps a young lady (Beth) find her lost husband somewhere in Africa. It's a spectacular adventure story with romance, because while they fight with wild animals and cannibals, they fall in love. Will they find the lost husband and finish the nice connection?
Title: Shut Up and Kiss Me!, Plot: Ryan and Pete are 27-year old best friends in Miami, born on the same day and each searching for the perfect woman. Ryan is a rookie stockbroker living with his psychic Mom. Pete is a slick surfer dude yet to find commitment. Each meets the women of their dreams on the same day. Ryan knocks heads in an elevator with the gorgeous Jessica, passing out before getting her number. Pete falls for the insatiable Tiara, but Tiara's uncle is mob boss Vincent Bublione, charged with her protection. This high-energy romantic comedy asks to what extent will you go for true love?
Title: Titanic, Plot: The plot focuses on the romances of two couples upon the doomed ship's maiden voyage. Isabella Paradine (Catherine Zeta-Jones) is a wealthy woman mourning the loss of her aunt, who reignites a romance with former flame Wynn Park (Peter Gallagher). Meanwhile, a charming ne'er-do-well named Jamie Perse (Mike Doyle) steals a ticket for the ship, and falls for a sweet innocent Irish girl on board. But their romance is threatened by the villainous Simon Doonan (Tim Curry), who has discovered about the ticket and makes Jamie his unwilling accomplice, as well as having sinister plans for the girl.
Title: Fortress, Plot: A futuristic prison movie. Protagonist and wife are nabbed at a future US emigration point with an illegal baby during population control. The resulting prison experience is the subject of the movie. The prison is a futuristic one run by a private corporation bent on mind control in various ways.
Title: Varalaaru, Plot: Relationships become entangled in an emotional web.
.

Which movie would you recommend for a romantic evening with your wife?

From the provided titles, the movie that would be recommended for a romantic evening with your wife is **King Solomon's Mines**. It's a romantic adventure story with romance, and it's a great choice for a date night.
`,kl,gs,Sl,bs,he="This notebook was adapted from",Ql,As,de='<li><a href="https://huggingface.co/learn/cookbook/rag_with_hugging_face_gemma_mongodb" rel="nofollow">MongoDB’s RAG cookbook</a></li> <li>OpenAI’s <a href="https://github.com/openai/openai-cookbook/blob/main/examples/vector_databases/elasticsearch/elasticsearch-retrieval-augmented-generation.ipynb" rel="nofollow">ES RAG cookbok</a></li> <li>Elasticsearch-labs’ <a href="https://github.com/elastic/elasticsearch-labs/blob/main/notebooks/integrations/hugging-face/loading-model-from-hugging-face.ipynb" rel="nofollow">loading-model-fromhugging-face cookbook</a></li>',Wl,fs,Nl,Bs,_l;return w=new Ee({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/cookbook/blob/enterprise_cookbook_gradio_remove_outputs/notebooks/en/rag_with_hugging_face_gemma_elasticsearch.ipynb"}]}}),C=new m({props:{title:"Building A RAG System with Gemma, Elasticsearch and Hugging Face Models",local:"building-a-rag-system-with-gemma-elasticsearch-and-hugging-face-models",headingTag:"h1"}}),T=new fe({props:{warning:!1,$$slots:{default:[Ze]},$$scope:{ctx:Zs}}}),A=new m({props:{title:"Step 1: Installing Libraries",local:"step-1-installing-libraries",headingTag:"h2"}}),f=new d({props:{code:"IXBpcCUyMGluc3RhbGwlMjBlbGFzdGljc2VhcmNoJTIwc2VudGVuY2VfdHJhbnNmb3JtZXJzJTIwdHJhbnNmb3JtZXJzJTIwZWxhbmQlM0QlM0Q4LjEyLjElMjAlMjMlMjBhY2NlbGVyYXRlJTIwJTIzJTIwdW5jb21tZW50JTIwaWYlMjB1c2luZyUyMEdQVSUwQSFwaXAlMjBpbnN0YWxsJTIwZGF0YXNldHMlM0QlM0QyLjE5LjIlMjAlMjMlMjBSZW1vdmUlMjB2ZXJzaW9uJTIwbG9jayUyMGlmJTIwaHR0cHMlM0ElMkYlMkZnaXRodWIuY29tJTJGaHVnZ2luZ2ZhY2UlMkZkYXRhc2V0cyUyRnB1bGwlMkY2OTc4JTIwaGFzJTIwYmVlbiUyMHJlbGVhc2Vk",highlighted:`!pip install elasticsearch sentence_transformers transformers eland==<span class="hljs-number">8.12</span><span class="hljs-number">.1</span> <span class="hljs-comment"># accelerate # uncomment if using GPU</span>
!pip install datasets==<span class="hljs-number">2.19</span><span class="hljs-number">.2</span> <span class="hljs-comment"># Remove version lock if https://github.com/huggingface/datasets/pull/6978 has been released</span>`,wrap:!1}}),E=new m({props:{title:"Step 2: Set up",local:"step-2-set-up",headingTag:"h2"}}),B=new m({props:{title:"Hugging Face",local:"hugging-face",headingTag:"h3"}}),V=new d({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBJTBBbm90ZWJvb2tfbG9naW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login

notebook_login()`,wrap:!1}}),R=new m({props:{title:"Elasticsearch deployment",local:"elasticsearch-deployment",headingTag:"h4"}}),Q=new d({props:{code:"ZnJvbSUyMGdvb2dsZS5jb2xhYiUyMGltcG9ydCUyMHVzZXJkYXRhJTBBJTBBJTIzJTIwaHR0cHMlM0ElMkYlMkZ3d3cuZWxhc3RpYy5jbyUyRnNlYXJjaC1sYWJzJTJGdHV0b3JpYWxzJTJGaW5zdGFsbC1lbGFzdGljc2VhcmNoJTJGZWxhc3RpYy1jbG91ZCUyM2ZpbmRpbmcteW91ci1jbG91ZC1pZCUwQUNMT1VEX0lEJTIwJTNEJTIwdXNlcmRhdGEuZ2V0KCUyMkNMT1VEX0lEJTIyKSUyMCUyMCUyMyUyMG9yJTIwJTIyJTNDWU9VUiUyMENMT1VEX0lEJTNFJTIyJTBBJTBBJTIzJTIwaHR0cHMlM0ElMkYlMkZ3d3cuZWxhc3RpYy5jbyUyRnNlYXJjaC1sYWJzJTJGdHV0b3JpYWxzJTJGaW5zdGFsbC1lbGFzdGljc2VhcmNoJTJGZWxhc3RpYy1jbG91ZCUyM2NyZWF0aW5nLWFuLWFwaS1rZXklMEFFTEFTVElDX0FQSV9LRVklMjAlM0QlMjB1c2VyZGF0YS5nZXQoJTIyRUxBU1RJQ19ERVBMX0FQSV9LRVklMjIpJTIwJTIwJTIzJTIwb3IlMjAlMjIlM0NZT1VSJTIwQVBJJTIwS0VZJTNFJTIy",highlighted:`<span class="hljs-keyword">from</span> google.colab <span class="hljs-keyword">import</span> userdata

<span class="hljs-comment"># https://www.elastic.co/search-labs/tutorials/install-elasticsearch/elastic-cloud#finding-your-cloud-id</span>
CLOUD_ID = userdata.get(<span class="hljs-string">&quot;CLOUD_ID&quot;</span>)  <span class="hljs-comment"># or &quot;&lt;YOUR CLOUD_ID&gt;&quot;</span>

<span class="hljs-comment"># https://www.elastic.co/search-labs/tutorials/install-elasticsearch/elastic-cloud#creating-an-api-key</span>
ELASTIC_API_KEY = userdata.get(<span class="hljs-string">&quot;ELASTIC_DEPL_API_KEY&quot;</span>)  <span class="hljs-comment"># or &quot;&lt;YOUR API KEY&gt;&quot;</span>`,wrap:!1}}),N=new d({props:{code:"ZnJvbSUyMGVsYXN0aWNzZWFyY2glMjBpbXBvcnQlMjBFbGFzdGljc2VhcmNoJTJDJTIwaGVscGVycyUwQSUwQSUyMyUyMENyZWF0ZSUyMHRoZSUyMGNsaWVudCUyMGluc3RhbmNlJTBBY2xpZW50JTIwJTNEJTIwRWxhc3RpY3NlYXJjaChjbG91ZF9pZCUzRENMT1VEX0lEJTJDJTIwYXBpX2tleSUzREVMQVNUSUNfQVBJX0tFWSklMEElMEElMjMlMjBTdWNjZXNzZnVsJTIwcmVzcG9uc2UhJTBBY2xpZW50LmluZm8oKQ==",highlighted:`<span class="hljs-keyword">from</span> elasticsearch <span class="hljs-keyword">import</span> Elasticsearch, helpers

<span class="hljs-comment"># Create the client instance</span>
client = Elasticsearch(cloud_id=CLOUD_ID, api_key=ELASTIC_API_KEY)

<span class="hljs-comment"># Successful response!</span>
client.info()`,wrap:!1}}),_=new m({props:{title:"Step 3: Data sourcing and preparation",local:"step-3-data-sourcing-and-preparation",headingTag:"h2"}}),q=new d({props:{code:"JTIzJTIwTG9hZCUyMERhdGFzZXQlMEFmcm9tJTIwZGF0YXNldHMlMjBpbXBvcnQlMjBsb2FkX2RhdGFzZXQlMEElMEElMjMlMjBodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZNb25nb0RCJTJGZW1iZWRkZWRfbW92aWVzJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJNb25nb0RCJTJGZW1iZWRkZWRfbW92aWVzJTIyKSUwQSUwQWRhdGFzZXQ=",highlighted:`<span class="hljs-comment"># Load Dataset</span>
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-comment"># https://huggingface.co/datasets/MongoDB/embedded_movies</span>
dataset = load_dataset(<span class="hljs-string">&quot;MongoDB/embedded_movies&quot;</span>)

dataset`,wrap:!1}}),F=new d({props:{code:"JTIzJTIwRGF0YSUyMFByZXBhcmF0aW9uJTBBJTBBJTIzJTIwUmVtb3ZlJTIwZGF0YSUyMHBvaW50JTIwd2hlcmUlMjBwbG90JTIwY29sb3VtbiUyMGlzJTIwbWlzc2luZyUwQWRhdGFzZXQlMjAlM0QlMjBkYXRhc2V0LmZpbHRlcihsYW1iZGElMjB4JTNBJTIweCU1QiUyMmZ1bGxwbG90JTIyJTVEJTIwaXMlMjBub3QlMjBOb25lKSUwQSUwQWlmJTIwJTIycGxvdF9lbWJlZGRpbmclMjIlMjBpbiUyMHN1bShkYXRhc2V0LmNvbHVtbl9uYW1lcy52YWx1ZXMoKSUyQyUyMCU1QiU1RCklM0ElMEElMjAlMjAlMjAlMjAlMjMlMjBSZW1vdmUlMjB0aGUlMjBwbG90X2VtYmVkZGluZyUyMGZyb20lMjBlYWNoJTIwZGF0YSUyMHBvaW50JTIwaW4lMjB0aGUlMjBkYXRhc2V0JTIwYXMlMjB3ZSUyMGFyZSUyMGdvaW5nJTIwdG8lMjBjcmVhdGUlMjBuZXclMjBlbWJlZGRpbmdzJTIwd2l0aCUyMGFuJTIwb3BlbiUyMHNvdXJjZSUyMGVtYmVkZGluZyUyMG1vZGVsJTIwZnJvbSUyMEh1Z2dpbmclMjBGYWNlJTBBJTIwJTIwJTIwJTIwZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQucmVtb3ZlX2NvbHVtbnMoJTIycGxvdF9lbWJlZGRpbmclMjIpJTBBJTBBZGF0YXNldCU1QiUyMnRyYWluJTIyJTVE",highlighted:`<span class="hljs-comment"># Data Preparation</span>

<span class="hljs-comment"># Remove data point where plot coloumn is missing</span>
dataset = dataset.<span class="hljs-built_in">filter</span>(<span class="hljs-keyword">lambda</span> x: x[<span class="hljs-string">&quot;fullplot&quot;</span>] <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>)

<span class="hljs-keyword">if</span> <span class="hljs-string">&quot;plot_embedding&quot;</span> <span class="hljs-keyword">in</span> <span class="hljs-built_in">sum</span>(dataset.column_names.values(), []):
    <span class="hljs-comment"># Remove the plot_embedding from each data point in the dataset as we are going to create new embeddings with an open source embedding model from Hugging Face</span>
    dataset = dataset.remove_columns(<span class="hljs-string">&quot;plot_embedding&quot;</span>)

dataset[<span class="hljs-string">&quot;train&quot;</span>]`,wrap:!1}}),x=new m({props:{title:"Step 4: Load Elasticsearch with vectorised data",local:"step-4-load-elasticsearch-with-vectorised-data",headingTag:"h2"}}),H=new m({props:{title:"Choose data and query vectorisation options",local:"choose-data-and-query-vectorisation-options",headingTag:"h3"}}),O=new d({props:{code:"VVNFX0VMQVNUSUNTRUFSQ0hfVkVDVE9SSVNBVElPTiUyMCUzRCUyMFRydWUlMEElMEFFTUJFRERJTkdfTU9ERUxfSUQlMjAlM0QlMjAlMjJ0aGVubHBlciUyRmd0ZS1zbWFsbCUyMiUwQSUyMyUyMGh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZ0aGVubHBlciUyRmd0ZS1zbWFsbCdzJTIwcGFnZSUyMHNob3dzJTIwdGhlJTIwZGltZW5zaW9ucyUyMG9mJTIwdGhlJTIwbW9kZWwlMEElMjMlMjBJZiUyMHlvdSUyMHVzZSUyMHRoZSUyMCU2MGd0ZS1iYXNlJTYwJTIwb3IlMjAlNjBndGUtbGFyZ2UlNjAlMjBlbWJlZGRpbmclMjBtb2RlbHMlMkMlMjB0aGUlMjBudW1EaW1lbnNpb24lMEElMjMlMjB2YWx1ZSUyMGluJTIwdGhlJTIwdmVjdG9yJTIwc2VhcmNoJTIwaW5kZXglMjBtdXN0JTIwYmUlMjBzZXQlMjB0byUyMDc2OCUyMGFuZCUyMDEwMjQlMkMlMjByZXNwZWN0aXZlbHkuJTBBRU1CRURESU5HX0RJTUVOU0lPTlMlMjAlM0QlMjAzODQ=",highlighted:`USE_ELASTICSEARCH_VECTORISATION = <span class="hljs-literal">True</span>

EMBEDDING_MODEL_ID = <span class="hljs-string">&quot;thenlper/gte-small&quot;</span>
<span class="hljs-comment"># https://huggingface.co/thenlper/gte-small&#x27;s page shows the dimensions of the model</span>
<span class="hljs-comment"># If you use the \`gte-base\` or \`gte-large\` embedding models, the numDimension</span>
<span class="hljs-comment"># value in the vector search index must be set to 768 and 1024, respectively.</span>
EMBEDDING_DIMENSIONS = <span class="hljs-number">384</span>`,wrap:!1}}),K=new m({props:{title:"Load Hugging Face model into Elasticsearch if needed",local:"load-hugging-face-model-into-elasticsearch-if-needed",headingTag:"h3"}}),ls=new d({props:{code:"aW1wb3J0JTIwbG9jYWxlJTBBbG9jYWxlLmdldHByZWZlcnJlZGVuY29kaW5nJTIwJTNEJTIwbGFtYmRhJTNBJTIwJTIyVVRGLTglMjIlMEEhKGlmJTIwJTVCJTIwJTIyVHJ1ZSUyMiUyMCUzRCUzRCUyMCUyNFVTRV9FTEFTVElDU0VBUkNIX1ZFQ1RPUklTQVRJT04lMjAlNUQlM0IlMjB0aGVuJTIwJTVDJTBBJTIwJTIwZWxhbmRfaW1wb3J0X2h1Yl9tb2RlbCUyMC0tY2xvdWQtaWQlMjAlMjRDTE9VRF9JRCUyMC0taHViLW1vZGVsLWlkJTIwJTI0RU1CRURESU5HX01PREVMX0lEJTIwLS10YXNrLXR5cGUlMjB0ZXh0X2VtYmVkZGluZyUyMC0tZXMtYXBpLWtleSUyMCUyNEVMQVNUSUNfQVBJX0tFWSUyMC0tc3RhcnQlMjAtLWNsZWFyLXByZXZpb3VzJTNCJTIwJTVDJTBBZmkp",highlighted:`<span class="hljs-keyword">import</span> locale
locale.getpreferredencoding = <span class="hljs-keyword">lambda</span>: <span class="hljs-string">&quot;UTF-8&quot;</span>
!(<span class="hljs-keyword">if</span> [ <span class="hljs-string">&quot;True&quot;</span> == $USE_ELASTICSEARCH_VECTORISATION ]; then \\
  eland_import_hub_model --cloud-<span class="hljs-built_in">id</span> $CLOUD_ID --hub-model-<span class="hljs-built_in">id</span> $EMBEDDING_MODEL_ID --task-<span class="hljs-built_in">type</span> text_embedding --es-api-key $ELASTIC_API_KEY --start --clear-previous; \\
fi)`,wrap:!1}}),as=new d({props:{code:"ZnJvbSUyMHNlbnRlbmNlX3RyYW5zZm9ybWVycyUyMGltcG9ydCUyMFNlbnRlbmNlVHJhbnNmb3JtZXIlMEElMEFpZiUyMG5vdCUyMFVTRV9FTEFTVElDU0VBUkNIX1ZFQ1RPUklTQVRJT04lM0ElMEElMjAlMjAlMjAlMjBlbWJlZGRpbmdfbW9kZWwlMjAlM0QlMjBTZW50ZW5jZVRyYW5zZm9ybWVyKEVNQkVERElOR19NT0RFTF9JRCklMEElMEElMEFkZWYlMjBnZXRfZW1iZWRkaW5nKHRleHQlM0ElMjBzdHIpJTIwLSUzRSUyMGxpc3QlNUJmbG9hdCU1RCUzQSUwQSUyMCUyMCUyMCUyMGlmJTIwVVNFX0VMQVNUSUNTRUFSQ0hfVkVDVE9SSVNBVElPTiUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJhaXNlJTIwRXhjZXB0aW9uKGYlMjJEaXNhYmxlZCUyMHdoZW4lMjBVU0VfRUxBU1RJQ1NFQVJDSF9WRUNUT1JJU0FUSU9OJTIwaXMlMjAlNUIlN0JVU0VfRUxBU1RJQ1NFQVJDSF9WRUNUT1JJU0FUSU9OJTdEJTVEJTIyKSUwQSUyMCUyMCUyMCUyMGVsc2UlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpZiUyMG5vdCUyMHRleHQuc3RyaXAoKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHByaW50KCUyMkF0dGVtcHRlZCUyMHRvJTIwZ2V0JTIwZW1iZWRkaW5nJTIwZm9yJTIwZW1wdHklMjB0ZXh0LiUyMiklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjAlNUIlNUQlMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBlbWJlZGRpbmclMjAlM0QlMjBlbWJlZGRpbmdfbW9kZWwuZW5jb2RlKHRleHQpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwZW1iZWRkaW5nLnRvbGlzdCgpJTBBJTBBJTBBZGVmJTIwYWRkX2Z1bGxwbG90X2VtYmVkZGluZyh4KSUzQSUwQSUyMCUyMCUyMCUyMGlmJTIwVVNFX0VMQVNUSUNTRUFSQ0hfVkVDVE9SSVNBVElPTiUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJhaXNlJTIwRXhjZXB0aW9uKGYlMjJEaXNhYmxlZCUyMHdoZW4lMjBVU0VfRUxBU1RJQ1NFQVJDSF9WRUNUT1JJU0FUSU9OJTIwaXMlMjAlNUIlN0JVU0VfRUxBU1RJQ1NFQVJDSF9WRUNUT1JJU0FUSU9OJTdEJTVEJTIyKSUwQSUyMCUyMCUyMCUyMGVsc2UlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmdWxsX3Bsb3RzJTIwJTNEJTIweCU1QiUyMmZ1bGxwbG90JTIyJTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTdCJTIyZW1iZWRkaW5nJTIyJTNBJTIwJTVCZ2V0X2VtYmVkZGluZyhmdWxsX3Bsb3QpJTIwZm9yJTIwZnVsbF9wbG90JTIwaW4lMjBmdWxsX3Bsb3RzJTVEJTdEJTBBJTBBJTBBaWYlMjBub3QlMjBVU0VfRUxBU1RJQ1NFQVJDSF9WRUNUT1JJU0FUSU9OJTNBJTBBJTIwJTIwJTIwJTIwZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQubWFwKGFkZF9mdWxscGxvdF9lbWJlZGRpbmclMkMlMjBiYXRjaGVkJTNEVHJ1ZSklMEElMjAlMjAlMjAlMjBkYXRhc2V0JTVCJTIydHJhaW4lMjIlNUQ=",highlighted:`<span class="hljs-keyword">from</span> sentence_transformers <span class="hljs-keyword">import</span> SentenceTransformer

<span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> USE_ELASTICSEARCH_VECTORISATION:
    embedding_model = SentenceTransformer(EMBEDDING_MODEL_ID)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_embedding</span>(<span class="hljs-params">text: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">list</span>[<span class="hljs-built_in">float</span>]:
    <span class="hljs-keyword">if</span> USE_ELASTICSEARCH_VECTORISATION:
        <span class="hljs-keyword">raise</span> Exception(<span class="hljs-string">f&quot;Disabled when USE_ELASTICSEARCH_VECTORISATION is [<span class="hljs-subst">{USE_ELASTICSEARCH_VECTORISATION}</span>]&quot;</span>)
    <span class="hljs-keyword">else</span>:
        <span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> text.strip():
            <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Attempted to get embedding for empty text.&quot;</span>)
            <span class="hljs-keyword">return</span> []

        embedding = embedding_model.encode(text)
        <span class="hljs-keyword">return</span> embedding.tolist()


<span class="hljs-keyword">def</span> <span class="hljs-title function_">add_fullplot_embedding</span>(<span class="hljs-params">x</span>):
    <span class="hljs-keyword">if</span> USE_ELASTICSEARCH_VECTORISATION:
        <span class="hljs-keyword">raise</span> Exception(<span class="hljs-string">f&quot;Disabled when USE_ELASTICSEARCH_VECTORISATION is [<span class="hljs-subst">{USE_ELASTICSEARCH_VECTORISATION}</span>]&quot;</span>)
    <span class="hljs-keyword">else</span>:
        full_plots = x[<span class="hljs-string">&quot;fullplot&quot;</span>]
        <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;embedding&quot;</span>: [get_embedding(full_plot) <span class="hljs-keyword">for</span> full_plot <span class="hljs-keyword">in</span> full_plots]}


<span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> USE_ELASTICSEARCH_VECTORISATION:
    dataset = dataset.<span class="hljs-built_in">map</span>(add_fullplot_embedding, batched=<span class="hljs-literal">True</span>)
    dataset[<span class="hljs-string">&quot;train&quot;</span>]`,wrap:!1}}),ts=new m({props:{title:"Step 5: Create a Search Index with vector search mappings.",local:"step-5-create-a-search-index-with-vector-search-mappings",headingTag:"h2"}}),is=new d({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Needs to match the id returned from Eland</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># in general for Hugging Face models, you just replace the forward slash with</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># double underscore</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model_id = EMBEDDING_MODEL_ID.replace(<span class="hljs-string">&quot;/&quot;</span>, <span class="hljs-string">&quot;__&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>index_name = <span class="hljs-string">&quot;movies&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>index_mapping = {
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;properties&quot;</span>: {
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;fullplot&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>},
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;plot&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>},
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;title&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>},
<span class="hljs-meta">... </span>    }
<span class="hljs-meta">... </span>}
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># define index mapping</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">if</span> USE_ELASTICSEARCH_VECTORISATION:
<span class="hljs-meta">... </span>    index_mapping[<span class="hljs-string">&quot;properties&quot;</span>][<span class="hljs-string">&quot;embedding&quot;</span>] = {
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;properties&quot;</span>: {
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;is_truncated&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;boolean&quot;</span>},
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;model_id&quot;</span>: {
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>,
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;fields&quot;</span>: {<span class="hljs-string">&quot;keyword&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;keyword&quot;</span>, <span class="hljs-string">&quot;ignore_above&quot;</span>: <span class="hljs-number">256</span>}},
<span class="hljs-meta">... </span>            },
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;predicted_value&quot;</span>: {
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;dense_vector&quot;</span>,
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;dims&quot;</span>: EMBEDDING_DIMENSIONS,
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;index&quot;</span>: <span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;similarity&quot;</span>: <span class="hljs-string">&quot;cosine&quot;</span>,
<span class="hljs-meta">... </span>            },
<span class="hljs-meta">... </span>        }
<span class="hljs-meta">... </span>    }
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">else</span>:
<span class="hljs-meta">... </span>    index_mapping[<span class="hljs-string">&quot;properties&quot;</span>][<span class="hljs-string">&quot;embedding&quot;</span>] = {
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;dense_vector&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;dims&quot;</span>: EMBEDDING_DIMENSIONS,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;index&quot;</span>: <span class="hljs-string">&quot;true&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;similarity&quot;</span>: <span class="hljs-string">&quot;cosine&quot;</span>,
<span class="hljs-meta">... </span>    }

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># flag to check if index has to be deleted before creating</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>should_delete_index = <span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># check if we want to delete index before creating the index</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">if</span> should_delete_index:
<span class="hljs-meta">... </span>    <span class="hljs-keyword">if</span> client.indices.exists(index=index_name):
<span class="hljs-meta">... </span>        <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Deleting existing %s&quot;</span> % index_name)
<span class="hljs-meta">... </span>        client.indices.delete(index=index_name, ignore=[<span class="hljs-number">400</span>, <span class="hljs-number">404</span>])

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Creating index %s&quot;</span> % index_name)


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># ingest pipeline definition</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">if</span> USE_ELASTICSEARCH_VECTORISATION:
<span class="hljs-meta">... </span>    pipeline_id = <span class="hljs-string">&quot;vectorize_fullplots&quot;</span>

<span class="hljs-meta">... </span>    client.ingest.put_pipeline(
<span class="hljs-meta">... </span>        <span class="hljs-built_in">id</span>=pipeline_id,
<span class="hljs-meta">... </span>        processors=[
<span class="hljs-meta">... </span>            {
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;inference&quot;</span>: {
<span class="hljs-meta">... </span>                    <span class="hljs-string">&quot;model_id&quot;</span>: model_id,
<span class="hljs-meta">... </span>                    <span class="hljs-string">&quot;target_field&quot;</span>: <span class="hljs-string">&quot;embedding&quot;</span>,
<span class="hljs-meta">... </span>                    <span class="hljs-string">&quot;field_map&quot;</span>: {<span class="hljs-string">&quot;fullplot&quot;</span>: <span class="hljs-string">&quot;text_field&quot;</span>},
<span class="hljs-meta">... </span>                }
<span class="hljs-meta">... </span>            }
<span class="hljs-meta">... </span>        ],
<span class="hljs-meta">... </span>    )

<span class="hljs-meta">... </span>    index_settings = {
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;index&quot;</span>: {
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;default_pipeline&quot;</span>: pipeline_id,
<span class="hljs-meta">... </span>        }
<span class="hljs-meta">... </span>    }
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">else</span>:
<span class="hljs-meta">... </span>    index_settings = {}

<span class="hljs-meta">&gt;&gt;&gt; </span>client.options(ignore_status=[<span class="hljs-number">400</span>, <span class="hljs-number">404</span>]).indices.create(
<span class="hljs-meta">... </span>    index=index_name, mappings=index_mapping, settings=index_settings
<span class="hljs-meta">... </span>)`,wrap:!1}}),js=new d({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> elasticsearch.helpers <span class="hljs-keyword">import</span> BulkIndexError


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">batch_to_bulk_actions</span>(<span class="hljs-params">batch</span>):
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> record <span class="hljs-keyword">in</span> batch:
<span class="hljs-meta">... </span>        action = {
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;_index&quot;</span>: <span class="hljs-string">&quot;movies&quot;</span>,
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;_source&quot;</span>: {
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;title&quot;</span>: record[<span class="hljs-string">&quot;title&quot;</span>],
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;fullplot&quot;</span>: record[<span class="hljs-string">&quot;fullplot&quot;</span>],
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;plot&quot;</span>: record[<span class="hljs-string">&quot;plot&quot;</span>],
<span class="hljs-meta">... </span>            },
<span class="hljs-meta">... </span>        }
<span class="hljs-meta">... </span>        <span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> USE_ELASTICSEARCH_VECTORISATION:
<span class="hljs-meta">... </span>            action[<span class="hljs-string">&quot;_source&quot;</span>][<span class="hljs-string">&quot;embedding&quot;</span>] = record[<span class="hljs-string">&quot;embedding&quot;</span>]
<span class="hljs-meta">... </span>        <span class="hljs-keyword">yield</span> action


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">bulk_index</span>(<span class="hljs-params">ds</span>):
<span class="hljs-meta">... </span>    start = <span class="hljs-number">0</span>
<span class="hljs-meta">... </span>    end = <span class="hljs-built_in">len</span>(ds)
<span class="hljs-meta">... </span>    batch_size = <span class="hljs-number">100</span>
<span class="hljs-meta">... </span>    <span class="hljs-keyword">if</span> USE_ELASTICSEARCH_VECTORISATION:
<span class="hljs-meta">... </span>        <span class="hljs-comment"># If using auto-embedding, bulk requests can take a lot longer,</span>
<span class="hljs-meta">... </span>        <span class="hljs-comment"># so pass a longer request_timeout here (defaults to 10s), otherwise</span>
<span class="hljs-meta">... </span>        <span class="hljs-comment"># we could get Connection timeouts</span>
<span class="hljs-meta">... </span>        batch_client = client.options(request_timeout=<span class="hljs-number">600</span>)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">else</span>:
<span class="hljs-meta">... </span>        batch_client = client
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> batch_start <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(start, end, batch_size):
<span class="hljs-meta">... </span>        batch_end = <span class="hljs-built_in">min</span>(batch_start + batch_size, end)
<span class="hljs-meta">... </span>        <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;batch: start [<span class="hljs-subst">{batch_start}</span>], end [<span class="hljs-subst">{batch_end}</span>]&quot;</span>)
<span class="hljs-meta">... </span>        batch = ds.select(<span class="hljs-built_in">range</span>(batch_start, batch_end))
<span class="hljs-meta">... </span>        actions = batch_to_bulk_actions(batch)
<span class="hljs-meta">... </span>        helpers.bulk(batch_client, actions)


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">try</span>:
<span class="hljs-meta">... </span>    bulk_index(dataset[<span class="hljs-string">&quot;train&quot;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">except</span> BulkIndexError <span class="hljs-keyword">as</span> e:
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;<span class="hljs-subst">{e.errors}</span>&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Data ingestion into Elasticsearch complete!&quot;</span>)`,wrap:!1}}),ys=new m({props:{title:"Step 6: Perform Vector Search on User Queries",local:"step-6-perform-vector-search-on-user-queries",headingTag:"h2"}}),hs=new d({props:{code:"ZGVmJTIwdmVjdG9yX3NlYXJjaChwbG90X3F1ZXJ5KSUzQSUwQSUyMCUyMCUyMCUyMGlmJTIwVVNFX0VMQVNUSUNTRUFSQ0hfVkVDVE9SSVNBVElPTiUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGtubiUyMCUzRCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmZpZWxkJTIyJTNBJTIwJTIyZW1iZWRkaW5nLnByZWRpY3RlZF92YWx1ZSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmslMjIlM0ElMjAxMCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnF1ZXJ5X3ZlY3Rvcl9idWlsZGVyJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydGV4dF9lbWJlZGRpbmclMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJtb2RlbF9pZCUyMiUzQSUyMG1vZGVsX2lkJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIybW9kZWxfdGV4dCUyMiUzQSUyMHBsb3RfcXVlcnklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJudW1fY2FuZGlkYXRlcyUyMiUzQSUyMDE1MCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCUyMCUyMGVsc2UlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBxdWVzdGlvbl9lbWJlZGRpbmclMjAlM0QlMjBnZXRfZW1iZWRkaW5nKHBsb3RfcXVlcnkpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwa25uJTIwJTNEJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyZmllbGQlMjIlM0ElMjAlMjJlbWJlZGRpbmclMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJxdWVyeV92ZWN0b3IlMjIlM0ElMjBxdWVzdGlvbl9lbWJlZGRpbmclMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJrJTIyJTNBJTIwMTAlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJudW1fY2FuZGlkYXRlcyUyMiUzQSUyMDE1MCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUwQSUwQSUyMCUyMCUyMCUyMHJlc3BvbnNlJTIwJTNEJTIwY2xpZW50LnNlYXJjaChpbmRleCUzRCUyMm1vdmllcyUyMiUyQyUyMGtubiUzRGtubiUyQyUyMHNpemUlM0Q1KSUwQSUyMCUyMCUyMCUyMHJlc3VsdHMlMjAlM0QlMjAlNUIlNUQlMEElMjAlMjAlMjAlMjBmb3IlMjBoaXQlMjBpbiUyMHJlc3BvbnNlJTVCJTIyaGl0cyUyMiU1RCU1QiUyMmhpdHMlMjIlNUQlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpZCUyMCUzRCUyMGhpdCU1QiUyMl9pZCUyMiU1RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNjb3JlJTIwJTNEJTIwaGl0JTVCJTIyX3Njb3JlJTIyJTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdGl0bGUlMjAlM0QlMjBoaXQlNUIlMjJfc291cmNlJTIyJTVEJTVCJTIydGl0bGUlMjIlNUQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwbG90JTIwJTNEJTIwaGl0JTVCJTIyX3NvdXJjZSUyMiU1RCU1QiUyMnBsb3QlMjIlNUQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmdWxscGxvdCUyMCUzRCUyMGhpdCU1QiUyMl9zb3VyY2UlMjIlNUQlNUIlMjJmdWxscGxvdCUyMiU1RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJlc3VsdCUyMCUzRCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmlkJTIyJTNBJTIwaWQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJfc2NvcmUlMjIlM0ElMjBzY29yZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnRpdGxlJTIyJTNBJTIwdGl0bGUlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJwbG90JTIyJTNBJTIwcGxvdCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmZ1bGxwbG90JTIyJTNBJTIwZnVsbHBsb3QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXN1bHRzLmFwcGVuZChyZXN1bHQpJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwcmVzdWx0cyUwQSUwQSUwQWRlZiUyMHByZXR0eV9zZWFyY2gocXVlcnkpJTNBJTBBJTBBJTIwJTIwJTIwJTIwZ2V0X2tub3dsZWRnZSUyMCUzRCUyMHZlY3Rvcl9zZWFyY2gocXVlcnkpJTBBJTBBJTIwJTIwJTIwJTIwc2VhcmNoX3Jlc3VsdCUyMCUzRCUyMCUyMiUyMiUwQSUyMCUyMCUyMCUyMGZvciUyMHJlc3VsdCUyMGluJTIwZ2V0X2tub3dsZWRnZSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlYXJjaF9yZXN1bHQlMjAlMkIlM0QlMjBmJTIyVGl0bGUlM0ElMjAlN0JyZXN1bHQuZ2V0KCd0aXRsZSclMkMlMjAnTiUyRkEnKSU3RCUyQyUyMFBsb3QlM0ElMjAlN0JyZXN1bHQuZ2V0KCdmdWxscGxvdCclMkMlMjAnTiUyRkEnKSU3RCU1Q24lMjIlMEElMEElMjAlMjAlMjAlMjByZXR1cm4lMjBzZWFyY2hfcmVzdWx0",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">vector_search</span>(<span class="hljs-params">plot_query</span>):
    <span class="hljs-keyword">if</span> USE_ELASTICSEARCH_VECTORISATION:
        knn = {
            <span class="hljs-string">&quot;field&quot;</span>: <span class="hljs-string">&quot;embedding.predicted_value&quot;</span>,
            <span class="hljs-string">&quot;k&quot;</span>: <span class="hljs-number">10</span>,
            <span class="hljs-string">&quot;query_vector_builder&quot;</span>: {
                <span class="hljs-string">&quot;text_embedding&quot;</span>: {
                    <span class="hljs-string">&quot;model_id&quot;</span>: model_id,
                    <span class="hljs-string">&quot;model_text&quot;</span>: plot_query,
                }
            },
            <span class="hljs-string">&quot;num_candidates&quot;</span>: <span class="hljs-number">150</span>,
        }
    <span class="hljs-keyword">else</span>:
        question_embedding = get_embedding(plot_query)
        knn = {
            <span class="hljs-string">&quot;field&quot;</span>: <span class="hljs-string">&quot;embedding&quot;</span>,
            <span class="hljs-string">&quot;query_vector&quot;</span>: question_embedding,
            <span class="hljs-string">&quot;k&quot;</span>: <span class="hljs-number">10</span>,
            <span class="hljs-string">&quot;num_candidates&quot;</span>: <span class="hljs-number">150</span>,
        }

    response = client.search(index=<span class="hljs-string">&quot;movies&quot;</span>, knn=knn, size=<span class="hljs-number">5</span>)
    results = []
    <span class="hljs-keyword">for</span> hit <span class="hljs-keyword">in</span> response[<span class="hljs-string">&quot;hits&quot;</span>][<span class="hljs-string">&quot;hits&quot;</span>]:
        <span class="hljs-built_in">id</span> = hit[<span class="hljs-string">&quot;_id&quot;</span>]
        score = hit[<span class="hljs-string">&quot;_score&quot;</span>]
        title = hit[<span class="hljs-string">&quot;_source&quot;</span>][<span class="hljs-string">&quot;title&quot;</span>]
        plot = hit[<span class="hljs-string">&quot;_source&quot;</span>][<span class="hljs-string">&quot;plot&quot;</span>]
        fullplot = hit[<span class="hljs-string">&quot;_source&quot;</span>][<span class="hljs-string">&quot;fullplot&quot;</span>]
        result = {
            <span class="hljs-string">&quot;id&quot;</span>: <span class="hljs-built_in">id</span>,
            <span class="hljs-string">&quot;_score&quot;</span>: score,
            <span class="hljs-string">&quot;title&quot;</span>: title,
            <span class="hljs-string">&quot;plot&quot;</span>: plot,
            <span class="hljs-string">&quot;fullplot&quot;</span>: fullplot,
        }
        results.append(result)
    <span class="hljs-keyword">return</span> results


<span class="hljs-keyword">def</span> <span class="hljs-title function_">pretty_search</span>(<span class="hljs-params">query</span>):

    get_knowledge = vector_search(query)

    search_result = <span class="hljs-string">&quot;&quot;</span>
    <span class="hljs-keyword">for</span> result <span class="hljs-keyword">in</span> get_knowledge:
        search_result += <span class="hljs-string">f&quot;Title: <span class="hljs-subst">{result.get(<span class="hljs-string">&#x27;title&#x27;</span>, <span class="hljs-string">&#x27;N/A&#x27;</span>)}</span>, Plot: <span class="hljs-subst">{result.get(<span class="hljs-string">&#x27;fullplot&#x27;</span>, <span class="hljs-string">&#x27;N/A&#x27;</span>)}</span>\\n&quot;</span>

    <span class="hljs-keyword">return</span> search_result`,wrap:!1}}),ds=new m({props:{title:"Step 7: Handling user queries and loading Gemma",local:"step-7-handling-user-queries-and-loading-gemma",headingTag:"h2"}}),ms=new d({props:{code:"JTIzJTIwQ29uZHVjdCUyMHF1ZXJ5JTIwd2l0aCUyMHJldHJpdmFsJTIwb2YlMjBzb3VyY2VzJTJDJTIwY29tYmluaW5nJTIwcmVzdWx0cyUyMGludG8lMjBzb21ldGhpbmclMjB0aGF0JTBBJTIzJTIwd2UlMjBjYW4lMjBmZWVkJTIwdG8lMjBHZW1tYSUwQWRlZiUyMGNvbWJpbmVkX3F1ZXJ5KHF1ZXJ5KSUzQSUwQSUyMCUyMCUyMCUyMHNvdXJjZV9pbmZvcm1hdGlvbiUyMCUzRCUyMHByZXR0eV9zZWFyY2gocXVlcnkpJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwZiUyMlF1ZXJ5JTNBJTIwJTdCcXVlcnklN0QlNUNuQ29udGludWUlMjB0byUyMGFuc3dlciUyMHRoZSUyMHF1ZXJ5JTIwYnklMjB1c2luZyUyMHRoZXNlJTIwU2VhcmNoJTIwUmVzdWx0cyUzQSU1Q24lN0Jzb3VyY2VfaW5mb3JtYXRpb24lN0QuJTIyJTBBJTBBJTBBcXVlcnklMjAlM0QlMjAlMjJXaGF0JTIwaXMlMjB0aGUlMjBiZXN0JTIwcm9tYW50aWMlMjBtb3ZpZSUyMHRvJTIwd2F0Y2glMjBhbmQlMjB3aHklM0YlMjIlMEFjb21iaW5lZF9yZXN1bHRzJTIwJTNEJTIwY29tYmluZWRfcXVlcnkocXVlcnkpJTBBJTBBcHJpbnQoY29tYmluZWRfcmVzdWx0cyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Conduct query with retrival of sources, combining results into something that</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># we can feed to Gemma</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">combined_query</span>(<span class="hljs-params">query</span>):
<span class="hljs-meta">... </span>    source_information = pretty_search(query)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> <span class="hljs-string">f&quot;Query: <span class="hljs-subst">{query}</span>\\nContinue to answer the query by using these Search Results:\\n<span class="hljs-subst">{source_information}</span>.&quot;</span>


<span class="hljs-meta">&gt;&gt;&gt; </span>query = <span class="hljs-string">&quot;What is the best romantic movie to watch and why?&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>combined_results = combined_query(query)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(combined_results)`,wrap:!1}}),us=new d({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRmdlbW1hLTJiLWl0JTIyKSUwQSUyMyUyMENQVSUyMEVuYWJsZWQlMjB1bmNvbW1lbnQlMjBiZWxvdyUyMCVGMCU5RiU5MSU4NyVGMCU5RiU4RiVCRCUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRmdlbW1hLTJiLWl0JTIyKSUwQSUyMyUyMEdQVSUyMEVuYWJsZWQlMjB1c2UlMjBiZWxvdyUyMCVGMCU5RiU5MSU4NyVGMCU5RiU4RiVCRCUwQSUyMyUyMG1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRmdlbW1hLTJiLWl0JTIyJTJDJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;google/gemma-2b-it&quot;</span>)
<span class="hljs-comment"># CPU Enabled uncomment below 👇🏽</span>
model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;google/gemma-2b-it&quot;</span>)
<span class="hljs-comment"># GPU Enabled use below 👇🏽</span>
<span class="hljs-comment"># model = AutoModelForCausalLM.from_pretrained(&quot;google/gemma-2b-it&quot;, device_map=&quot;auto&quot;)</span>`,wrap:!1}}),Cs=new d({props:{code:"ZGVmJTIwcmFnX3F1ZXJ5KHF1ZXJ5KSUzQSUwQSUyMCUyMCUyMCUyMGNvbWJpbmVkX2luZm9ybWF0aW9uJTIwJTNEJTIwY29tYmluZWRfcXVlcnkocXVlcnkpJTBBJTBBJTIwJTIwJTIwJTIwJTIzJTIwTW92aW5nJTIwdGVuc29ycyUyMHRvJTIwR1BVJTBBJTIwJTIwJTIwJTIwaW5wdXRfaWRzJTIwJTNEJTIwdG9rZW5pemVyKGNvbWJpbmVkX2luZm9ybWF0aW9uJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMjAlMjAlMjMlMjAudG8oJTIyY3VkYSUyMiklMjAlMjMlMjBBZGQlMjBpZiUyMHVzaW5nJTIwR1BVJTBBJTIwJTIwJTIwJTIwcmVzcG9uc2UlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0X2lkcyUyQyUyMG1heF9uZXdfdG9rZW5zJTNENzAwKSUwQSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMHRva2VuaXplci5kZWNvZGUocmVzcG9uc2UlNUIwJTVEJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTBBJTBBJTBBcHJpbnQocmFnX3F1ZXJ5KCUyMldoYXQncyUyMGElMjByb21hbnRpYyUyMG1vdmllJTIwdGhhdCUyMEklMjBjYW4lMjB3YXRjaCUyMHdpdGglMjBteSUyMHdpZmUlM0YlMjIpKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">rag_query</span>(<span class="hljs-params">query</span>):
<span class="hljs-meta">... </span>    combined_information = combined_query(query)

<span class="hljs-meta">... </span>    <span class="hljs-comment"># Moving tensors to GPU</span>
<span class="hljs-meta">... </span>    input_ids = tokenizer(combined_information, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)  <span class="hljs-comment"># .to(&quot;cuda&quot;) # Add if using GPU</span>
<span class="hljs-meta">... </span>    response = model.generate(**input_ids, max_new_tokens=<span class="hljs-number">700</span>)

<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> tokenizer.decode(response[<span class="hljs-number">0</span>], skip_special_tokens=<span class="hljs-literal">True</span>)


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(rag_query(<span class="hljs-string">&quot;What&#x27;s a romantic movie that I can watch with my wife?&quot;</span>))`,wrap:!1}}),gs=new m({props:{title:"Credits",local:"credits",headingTag:"h2"}}),fs=new Be({props:{source:"https://github.com/huggingface/cookbook/blob/main/notebooks/en/rag_with_hugging_face_gemma_elasticsearch.md"}}),{c(){h=M("meta"),u=t(),J=M("p"),Es=t(),o(w.$$.fragment),Vs=t(),o(C.$$.fragment),Rs=t(),I=M("p"),I.innerHTML=vl,Gs=t(),g=M("p"),g.textContent=ql,ks=t(),b=M("p"),b.innerHTML=Xl,Ss=t(),o(T.$$.fragment),Qs=t(),o(A.$$.fragment),Ws=t(),o(f.$$.fragment),Ns=t(),o(E.$$.fragment),_s=t(),o(B.$$.fragment),vs=t(),Z=M("p"),Z.textContent=$l,qs=t(),o(V.$$.fragment),Xs=t(),o(R.$$.fragment),$s=t(),G=M("p"),G.innerHTML=Fl,Fs=t(),k=M("p"),k.innerHTML=xl,xs=t(),S=M("p"),S.innerHTML=Hl,Hs=t(),o(Q.$$.fragment),Ys=t(),W=M("p"),W.textContent=Yl,zs=t(),o(N.$$.fragment),Ls=t(),o(_.$$.fragment),Ds=t(),v=M("p"),v.innerHTML=zl,Ps=t(),o(q.$$.fragment),Os=t(),X=M("p"),X.textContent=Ll,Ks=t(),$=M("ol"),$.innerHTML=Dl,sl=t(),o(F.$$.fragment),ll=t(),o(x.$$.fragment),el=t(),o(H.$$.fragment),al=t(),Y=M("p"),Y.textContent=Pl,tl=t(),z=M("p"),z.innerHTML=Ol,nl=t(),L=M("p"),L.innerHTML=Kl,Ml=t(),D=M("p"),D.innerHTML=se,il=t(),P=M("p"),P.innerHTML=le,pl=t(),o(O.$$.fragment),ol=t(),o(K.$$.fragment),jl=t(),ss=M("p"),ss.innerHTML=ee,cl=t(),o(ls.$$.fragment),yl=t(),es=M("p"),es.innerHTML=ae,rl=t(),o(as.$$.fragment),Ul=t(),o(ts.$$.fragment),hl=t(),ns=M("p"),ns.textContent=te,dl=t(),Ms=M("p"),Ms.innerHTML=ne,ml=t(),o(is.$$.fragment),Jl=t(),ps=M("pre"),ps.textContent=Me,Tl=t(),os=M("p"),os.innerHTML=ie,ul=t(),o(js.$$.fragment),wl=t(),cs=M("pre"),cs.textContent=pe,Cl=t(),o(ys.$$.fragment),Il=t(),rs=M("p"),rs.textContent=oe,gl=t(),Us=M("p"),Us.innerHTML=je,bl=t(),o(hs.$$.fragment),Al=t(),o(ds.$$.fragment),fl=t(),o(ms.$$.fragment),El=t(),Js=M("pre"),Js.textContent=ce,Bl=t(),Ts=M("p"),Ts.innerHTML=ye,Zl=t(),o(us.$$.fragment),Vl=t(),ws=M("p"),ws.textContent=re,Rl=t(),o(Cs.$$.fragment),Gl=t(),Is=M("pre"),Is.textContent=Ue,kl=t(),o(gs.$$.fragment),Sl=t(),bs=M("p"),bs.textContent=he,Ql=t(),As=M("ul"),As.innerHTML=de,Wl=t(),o(fs.$$.fragment),Nl=t(),Bs=M("p"),this.h()},l(s){const l=be("svelte-u9bgzb",document.head);h=i(l,"META",{name:!0,content:!0}),l.forEach(e),u=n(s),J=i(s,"P",{}),Je(J).forEach(e),Es=n(s),j(w.$$.fragment,s),Vs=n(s),j(C.$$.fragment,s),Rs=n(s),I=i(s,"P",{"data-svelte-h":!0}),p(I)!=="svelte-u85jis"&&(I.innerHTML=vl),Gs=n(s),g=i(s,"P",{"data-svelte-h":!0}),p(g)!=="svelte-1gzfghe"&&(g.textContent=ql),ks=n(s),b=i(s,"P",{"data-svelte-h":!0}),p(b)!=="svelte-19dgrn4"&&(b.innerHTML=Xl),Ss=n(s),j(T.$$.fragment,s),Qs=n(s),j(A.$$.fragment,s),Ws=n(s),j(f.$$.fragment,s),Ns=n(s),j(E.$$.fragment,s),_s=n(s),j(B.$$.fragment,s),vs=n(s),Z=i(s,"P",{"data-svelte-h":!0}),p(Z)!=="svelte-1oc48ie"&&(Z.textContent=$l),qs=n(s),j(V.$$.fragment,s),Xs=n(s),j(R.$$.fragment,s),$s=n(s),G=i(s,"P",{"data-svelte-h":!0}),p(G)!=="svelte-90yfqq"&&(G.innerHTML=Fl),Fs=n(s),k=i(s,"P",{"data-svelte-h":!0}),p(k)!=="svelte-1wxepjk"&&(k.innerHTML=xl),xs=n(s),S=i(s,"P",{"data-svelte-h":!0}),p(S)!=="svelte-1ixe20f"&&(S.innerHTML=Hl),Hs=n(s),j(Q.$$.fragment,s),Ys=n(s),W=i(s,"P",{"data-svelte-h":!0}),p(W)!=="svelte-1tero47"&&(W.textContent=Yl),zs=n(s),j(N.$$.fragment,s),Ls=n(s),j(_.$$.fragment,s),Ds=n(s),v=i(s,"P",{"data-svelte-h":!0}),p(v)!=="svelte-nhsnwd"&&(v.innerHTML=zl),Ps=n(s),j(q.$$.fragment,s),Os=n(s),X=i(s,"P",{"data-svelte-h":!0}),p(X)!=="svelte-1c0ejge"&&(X.textContent=Ll),Ks=n(s),$=i(s,"OL",{"data-svelte-h":!0}),p($)!=="svelte-zu3w9u"&&($.innerHTML=Dl),sl=n(s),j(F.$$.fragment,s),ll=n(s),j(x.$$.fragment,s),el=n(s),j(H.$$.fragment,s),al=n(s),Y=i(s,"P",{"data-svelte-h":!0}),p(Y)!=="svelte-18mg2q3"&&(Y.textContent=Pl),tl=n(s),z=i(s,"P",{"data-svelte-h":!0}),p(z)!=="svelte-v671s0"&&(z.innerHTML=Ol),nl=n(s),L=i(s,"P",{"data-svelte-h":!0}),p(L)!=="svelte-2l59xo"&&(L.innerHTML=Kl),Ml=n(s),D=i(s,"P",{"data-svelte-h":!0}),p(D)!=="svelte-ukp447"&&(D.innerHTML=se),il=n(s),P=i(s,"P",{"data-svelte-h":!0}),p(P)!=="svelte-cmmakk"&&(P.innerHTML=le),pl=n(s),j(O.$$.fragment,s),ol=n(s),j(K.$$.fragment,s),jl=n(s),ss=i(s,"P",{"data-svelte-h":!0}),p(ss)!=="svelte-ggbryw"&&(ss.innerHTML=ee),cl=n(s),j(ls.$$.fragment,s),yl=n(s),es=i(s,"P",{"data-svelte-h":!0}),p(es)!=="svelte-nj7dnk"&&(es.innerHTML=ae),rl=n(s),j(as.$$.fragment,s),Ul=n(s),j(ts.$$.fragment,s),hl=n(s),ns=i(s,"P",{"data-svelte-h":!0}),p(ns)!=="svelte-1eiizls"&&(ns.textContent=te),dl=n(s),Ms=i(s,"P",{"data-svelte-h":!0}),p(Ms)!=="svelte-x5ec9q"&&(Ms.innerHTML=ne),ml=n(s),j(is.$$.fragment,s),Jl=n(s),ps=i(s,"PRE",{"data-svelte-h":!0}),p(ps)!=="svelte-dtnw1a"&&(ps.textContent=Me),Tl=n(s),os=i(s,"P",{"data-svelte-h":!0}),p(os)!=="svelte-16lq0w1"&&(os.innerHTML=ie),ul=n(s),j(js.$$.fragment,s),wl=n(s),cs=i(s,"PRE",{"data-svelte-h":!0}),p(cs)!=="svelte-rnckh4"&&(cs.textContent=pe),Cl=n(s),j(ys.$$.fragment,s),Il=n(s),rs=i(s,"P",{"data-svelte-h":!0}),p(rs)!=="svelte-mn3hdu"&&(rs.textContent=oe),gl=n(s),Us=i(s,"P",{"data-svelte-h":!0}),p(Us)!=="svelte-1x79kzs"&&(Us.innerHTML=je),bl=n(s),j(hs.$$.fragment,s),Al=n(s),j(ds.$$.fragment,s),fl=n(s),j(ms.$$.fragment,s),El=n(s),Js=i(s,"PRE",{"data-svelte-h":!0}),p(Js)!=="svelte-rtrdii"&&(Js.textContent=ce),Bl=n(s),Ts=i(s,"P",{"data-svelte-h":!0}),p(Ts)!=="svelte-rrls6r"&&(Ts.innerHTML=ye),Zl=n(s),j(us.$$.fragment,s),Vl=n(s),ws=i(s,"P",{"data-svelte-h":!0}),p(ws)!=="svelte-mfigla"&&(ws.textContent=re),Rl=n(s),j(Cs.$$.fragment,s),Gl=n(s),Is=i(s,"PRE",{"data-svelte-h":!0}),p(Is)!=="svelte-1d2dt07"&&(Is.textContent=Ue),kl=n(s),j(gs.$$.fragment,s),Sl=n(s),bs=i(s,"P",{"data-svelte-h":!0}),p(bs)!=="svelte-rwjj8d"&&(bs.textContent=he),Ql=n(s),As=i(s,"UL",{"data-svelte-h":!0}),p(As)!=="svelte-1fh1ozm"&&(As.innerHTML=de),Wl=n(s),j(fs.$$.fragment,s),Nl=n(s),Bs=i(s,"P",{}),Je(Bs).forEach(e),this.h()},h(){Te(h,"name","hf:doc:metadata"),Te(h,"content",Re)},m(s,l){Ae(document.head,h),a(s,u,l),a(s,J,l),a(s,Es,l),c(w,s,l),a(s,Vs,l),c(C,s,l),a(s,Rs,l),a(s,I,l),a(s,Gs,l),a(s,g,l),a(s,ks,l),a(s,b,l),a(s,Ss,l),c(T,s,l),a(s,Qs,l),c(A,s,l),a(s,Ws,l),c(f,s,l),a(s,Ns,l),c(E,s,l),a(s,_s,l),c(B,s,l),a(s,vs,l),a(s,Z,l),a(s,qs,l),c(V,s,l),a(s,Xs,l),c(R,s,l),a(s,$s,l),a(s,G,l),a(s,Fs,l),a(s,k,l),a(s,xs,l),a(s,S,l),a(s,Hs,l),c(Q,s,l),a(s,Ys,l),a(s,W,l),a(s,zs,l),c(N,s,l),a(s,Ls,l),c(_,s,l),a(s,Ds,l),a(s,v,l),a(s,Ps,l),c(q,s,l),a(s,Os,l),a(s,X,l),a(s,Ks,l),a(s,$,l),a(s,sl,l),c(F,s,l),a(s,ll,l),c(x,s,l),a(s,el,l),c(H,s,l),a(s,al,l),a(s,Y,l),a(s,tl,l),a(s,z,l),a(s,nl,l),a(s,L,l),a(s,Ml,l),a(s,D,l),a(s,il,l),a(s,P,l),a(s,pl,l),c(O,s,l),a(s,ol,l),c(K,s,l),a(s,jl,l),a(s,ss,l),a(s,cl,l),c(ls,s,l),a(s,yl,l),a(s,es,l),a(s,rl,l),c(as,s,l),a(s,Ul,l),c(ts,s,l),a(s,hl,l),a(s,ns,l),a(s,dl,l),a(s,Ms,l),a(s,ml,l),c(is,s,l),a(s,Jl,l),a(s,ps,l),a(s,Tl,l),a(s,os,l),a(s,ul,l),c(js,s,l),a(s,wl,l),a(s,cs,l),a(s,Cl,l),c(ys,s,l),a(s,Il,l),a(s,rs,l),a(s,gl,l),a(s,Us,l),a(s,bl,l),c(hs,s,l),a(s,Al,l),c(ds,s,l),a(s,fl,l),c(ms,s,l),a(s,El,l),a(s,Js,l),a(s,Bl,l),a(s,Ts,l),a(s,Zl,l),c(us,s,l),a(s,Vl,l),a(s,ws,l),a(s,Rl,l),c(Cs,s,l),a(s,Gl,l),a(s,Is,l),a(s,kl,l),c(gs,s,l),a(s,Sl,l),a(s,bs,l),a(s,Ql,l),a(s,As,l),a(s,Wl,l),c(fs,s,l),a(s,Nl,l),a(s,Bs,l),_l=!0},p(s,[l]){const me={};l&2&&(me.$$scope={dirty:l,ctx:s}),T.$set(me)},i(s){_l||(y(w.$$.fragment,s),y(C.$$.fragment,s),y(T.$$.fragment,s),y(A.$$.fragment,s),y(f.$$.fragment,s),y(E.$$.fragment,s),y(B.$$.fragment,s),y(V.$$.fragment,s),y(R.$$.fragment,s),y(Q.$$.fragment,s),y(N.$$.fragment,s),y(_.$$.fragment,s),y(q.$$.fragment,s),y(F.$$.fragment,s),y(x.$$.fragment,s),y(H.$$.fragment,s),y(O.$$.fragment,s),y(K.$$.fragment,s),y(ls.$$.fragment,s),y(as.$$.fragment,s),y(ts.$$.fragment,s),y(is.$$.fragment,s),y(js.$$.fragment,s),y(ys.$$.fragment,s),y(hs.$$.fragment,s),y(ds.$$.fragment,s),y(ms.$$.fragment,s),y(us.$$.fragment,s),y(Cs.$$.fragment,s),y(gs.$$.fragment,s),y(fs.$$.fragment,s),_l=!0)},o(s){r(w.$$.fragment,s),r(C.$$.fragment,s),r(T.$$.fragment,s),r(A.$$.fragment,s),r(f.$$.fragment,s),r(E.$$.fragment,s),r(B.$$.fragment,s),r(V.$$.fragment,s),r(R.$$.fragment,s),r(Q.$$.fragment,s),r(N.$$.fragment,s),r(_.$$.fragment,s),r(q.$$.fragment,s),r(F.$$.fragment,s),r(x.$$.fragment,s),r(H.$$.fragment,s),r(O.$$.fragment,s),r(K.$$.fragment,s),r(ls.$$.fragment,s),r(as.$$.fragment,s),r(ts.$$.fragment,s),r(is.$$.fragment,s),r(js.$$.fragment,s),r(ys.$$.fragment,s),r(hs.$$.fragment,s),r(ds.$$.fragment,s),r(ms.$$.fragment,s),r(us.$$.fragment,s),r(Cs.$$.fragment,s),r(gs.$$.fragment,s),r(fs.$$.fragment,s),_l=!1},d(s){s&&(e(u),e(J),e(Es),e(Vs),e(Rs),e(I),e(Gs),e(g),e(ks),e(b),e(Ss),e(Qs),e(Ws),e(Ns),e(_s),e(vs),e(Z),e(qs),e(Xs),e($s),e(G),e(Fs),e(k),e(xs),e(S),e(Hs),e(Ys),e(W),e(zs),e(Ls),e(Ds),e(v),e(Ps),e(Os),e(X),e(Ks),e($),e(sl),e(ll),e(el),e(al),e(Y),e(tl),e(z),e(nl),e(L),e(Ml),e(D),e(il),e(P),e(pl),e(ol),e(jl),e(ss),e(cl),e(yl),e(es),e(rl),e(Ul),e(hl),e(ns),e(dl),e(Ms),e(ml),e(Jl),e(ps),e(Tl),e(os),e(ul),e(wl),e(cs),e(Cl),e(Il),e(rs),e(gl),e(Us),e(bl),e(Al),e(fl),e(El),e(Js),e(Bl),e(Ts),e(Zl),e(Vl),e(ws),e(Rl),e(Gl),e(Is),e(kl),e(Sl),e(bs),e(Ql),e(As),e(Wl),e(Nl),e(Bs)),e(h),U(w,s),U(C,s),U(T,s),U(A,s),U(f,s),U(E,s),U(B,s),U(V,s),U(R,s),U(Q,s),U(N,s),U(_,s),U(q,s),U(F,s),U(x,s),U(H,s),U(O,s),U(K,s),U(ls,s),U(as,s),U(ts,s),U(is,s),U(js,s),U(ys,s),U(hs,s),U(ds,s),U(ms,s),U(us,s),U(Cs,s),U(gs,s),U(fs,s)}}}const Re='{"title":"Building A RAG System with Gemma, Elasticsearch and Hugging Face Models","local":"building-a-rag-system-with-gemma-elasticsearch-and-hugging-face-models","sections":[{"title":"Step 1: Installing Libraries","local":"step-1-installing-libraries","sections":[],"depth":2},{"title":"Step 2: Set up","local":"step-2-set-up","sections":[{"title":"Hugging Face","local":"hugging-face","sections":[{"title":"Elasticsearch deployment","local":"elasticsearch-deployment","sections":[],"depth":4}],"depth":3}],"depth":2},{"title":"Step 3: Data sourcing and preparation","local":"step-3-data-sourcing-and-preparation","sections":[],"depth":2},{"title":"Step 4: Load Elasticsearch with vectorised data","local":"step-4-load-elasticsearch-with-vectorised-data","sections":[{"title":"Choose data and query vectorisation options","local":"choose-data-and-query-vectorisation-options","sections":[],"depth":3},{"title":"Load Hugging Face model into Elasticsearch if needed","local":"load-hugging-face-model-into-elasticsearch-if-needed","sections":[],"depth":3}],"depth":2},{"title":"Step 5: Create a Search Index with vector search mappings.","local":"step-5-create-a-search-index-with-vector-search-mappings","sections":[],"depth":2},{"title":"Step 6: Perform Vector Search on User Queries","local":"step-6-perform-vector-search-on-user-queries","sections":[],"depth":2},{"title":"Step 7: Handling user queries and loading Gemma","local":"step-7-handling-user-queries-and-loading-gemma","sections":[],"depth":2},{"title":"Credits","local":"credits","sections":[],"depth":2}],"depth":1}';function Ge(Zs){return we(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class _e extends Ie{constructor(h){super(),ge(this,h,Ge,Ve,ue,{})}}export{_e as component};
