import{s as Th,n as hh,o as _h}from"../chunks/scheduler.0219f8bd.js";import{S as $h,i as vh,g as i,s,r as a,A as yh,h as r,f as l,c as n,j as h,u as m,x as d,k as u,y as bh,a as o,v as p,d as c,t as f,w as T}from"../chunks/index.f61edf3b.js";import{C as sc}from"../chunks/CodeBlock.38e566ae.js";import{H as _,E as Mh}from"../chunks/EditOnGithub.48fa589f.js";function xh(nc){let $,tn,Zs,ln,v,on,y,sn,b,ic="Helper module for <code>Tensor</code> processing.",nn,M,rc=`These functions and classes are only used internally,
meaning an end-user shouldn’t need to access anything here.`,rn,x,dc='<li><a href="#module_utils/tensor">utils/tensor</a><ul><li><em>static</em><ul><li><a href="#module_utils/tensor.Tensor">.Tensor</a><ul><li><a href="#new_module_utils/tensor.Tensor_new"><code>new Tensor(...args)</code></a></li> <li><a href="#module_utils/tensor.Tensor+dims"><code>.dims</code></a> : <code>Array.&lt;number&gt;</code></li> <li><a href="#module_utils/tensor.Tensor+type"><code>.type</code></a> : <a href="#DataType"><code>DataType</code></a></li> <li><a href="#module_utils/tensor.Tensor+data"><code>.data</code></a> : <code>DataArray</code></li> <li><a href="#module_utils/tensor.Tensor+size"><code>.size</code></a> : <code>number</code></li> <li><a href="#module_utils/tensor.Tensor+location"><code>.location</code></a> : <code>string</code></li> <li><a href="#module_utils/tensor.Tensor+Symbol.iterator"><code>.Symbol.iterator()</code></a> ⇒ <code>Iterator</code></li> <li><a href="#module_utils/tensor.Tensor+_getitem"><code>._getitem(index)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+indexOf"><code>.indexOf(item)</code></a> ⇒ <code>number</code></li> <li><a href="#module_utils/tensor.Tensor+_subarray"><code>._subarray(index, iterSize, iterDims)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+item"><code>.item()</code></a> ⇒ <code>number</code> | <code>bigint</code></li> <li><a href="#module_utils/tensor.Tensor+tolist"><code>.tolist()</code></a> ⇒ <code>Array</code></li> <li><a href="#module_utils/tensor.Tensor+sigmoid"><code>.sigmoid()</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+sigmoid_"><code>.sigmoid_()</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+mul"><code>.mul(val)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+mul_"><code>.mul_(val)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+div"><code>.div(val)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+div_"><code>.div_(val)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+add"><code>.add(val)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+add_"><code>.add_(val)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+permute"><code>.permute(...dims)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+sum"><code>.sum([dim], keepdim)</code></a> ⇒</li> <li><a href="#module_utils/tensor.Tensor+norm"><code>.norm([p], [dim], [keepdim])</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+normalize_"><code>.normalize_([p], [dim])</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+normalize"><code>.normalize([p], [dim])</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+stride"><code>.stride()</code></a> ⇒ <code>Array.&lt;number&gt;</code></li> <li><a href="#module_utils/tensor.Tensor+squeeze"><code>.squeeze([dim])</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+squeeze_"><code>.squeeze_()</code></a></li> <li><a href="#module_utils/tensor.Tensor+unsqueeze"><code>.unsqueeze(dim)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+unsqueeze_"><code>.unsqueeze_()</code></a></li> <li><a href="#module_utils/tensor.Tensor+flatten_"><code>.flatten_()</code></a></li> <li><a href="#module_utils/tensor.Tensor+flatten"><code>.flatten(start_dim, end_dim)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+view"><code>.view(...dims)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+clamp_"><code>.clamp_()</code></a></li> <li><a href="#module_utils/tensor.Tensor+clamp"><code>.clamp(min, max)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+round_"><code>.round_()</code></a></li> <li><a href="#module_utils/tensor.Tensor+round"><code>.round()</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+to"><code>.to(type)</code></a> ⇒ <code>Tensor</code></li></ul></li> <li><a href="#module_utils/tensor.permute"><code>.permute(tensor, axes)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.interpolate"><code>.interpolate(input, size, mode, align_corners)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.interpolate_4d"><code>.interpolate_4d(input, options)</code></a> ⇒ <code>Promise.&lt;Tensor&gt;</code></li> <li><a href="#module_utils/tensor.matmul"><code>.matmul(a, b)</code></a> ⇒ <code>Promise.&lt;Tensor&gt;</code></li> <li><a href="#module_utils/tensor.rfft"><code>.rfft(x, a)</code></a> ⇒ <code>Promise.&lt;Tensor&gt;</code></li> <li><a href="#module_utils/tensor.topk"><code>.topk(x, k)</code></a> ⇒ <code>*</code></li> <li><a href="#module_utils/tensor.mean_pooling"><code>.mean_pooling(last_hidden_state, attention_mask)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.layer_norm"><code>.layer_norm(input, normalized_shape, options)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.cat"><code>.cat(tensors, dim)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.stack"><code>.stack(tensors, dim)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.std_mean"><code>.std_mean(input, dim, correction, keepdim)</code></a> ⇒ <code>Array.&lt;Tensor&gt;</code></li> <li><a href="#module_utils/tensor.mean"><code>.mean(input, dim, keepdim)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.dynamicTimeWarping"><code>.dynamicTimeWarping(matrix)</code></a> ⇒ <code>Array.&lt;Array&lt;number&gt;&gt;</code></li> <li><a href="#module_utils/tensor.full"><code>.full(size, fill_value)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.ones"><code>.ones(size)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.ones_like"><code>.ones_like(tensor)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.zeros"><code>.zeros(size)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.zeros_like"><code>.zeros_like(tensor)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.quantize_embeddings"><code>.quantize_embeddings(tensor, precision)</code></a> ⇒ <code>Tensor</code></li></ul></li> <li><em>inner</em><ul><li><a href="#module_utils/tensor..args%5B0%5D"><code>~args[0]</code></a> : <code>ONNXTensor</code></li> <li><a href="#module_utils/tensor..reshape"><code>~reshape(data, dimensions)</code></a> ⇒ <code>*</code><ul><li><a href="#module_utils/tensor..reshape..reshapedArray"><code>~reshapedArray</code></a> : <code>any</code></li></ul></li> <li><a href="#module_utils/tensor..DataArray"><code>~DataArray</code></a> : <code>*</code></li> <li><a href="#module_utils/tensor..NestArray"><code>~NestArray</code></a> : <code>*</code></li></ul></li></ul></li>',dn,un,an,C,mn,H,pn,L,uc='<strong>Kind</strong>: static class of <a href="#module_utils/tensor"><code>utils/tensor</code></a>',cn,w,ac='<li><a href="#module_utils/tensor.Tensor">.Tensor</a><ul><li><a href="#new_module_utils/tensor.Tensor_new"><code>new Tensor(...args)</code></a></li> <li><a href="#module_utils/tensor.Tensor+dims"><code>.dims</code></a> : <code>Array.&lt;number&gt;</code></li> <li><a href="#module_utils/tensor.Tensor+type"><code>.type</code></a> : <a href="#DataType"><code>DataType</code></a></li> <li><a href="#module_utils/tensor.Tensor+data"><code>.data</code></a> : <code>DataArray</code></li> <li><a href="#module_utils/tensor.Tensor+size"><code>.size</code></a> : <code>number</code></li> <li><a href="#module_utils/tensor.Tensor+location"><code>.location</code></a> : <code>string</code></li> <li><a href="#module_utils/tensor.Tensor+Symbol.iterator"><code>.Symbol.iterator()</code></a> ⇒ <code>Iterator</code></li> <li><a href="#module_utils/tensor.Tensor+_getitem"><code>._getitem(index)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+indexOf"><code>.indexOf(item)</code></a> ⇒ <code>number</code></li> <li><a href="#module_utils/tensor.Tensor+_subarray"><code>._subarray(index, iterSize, iterDims)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+item"><code>.item()</code></a> ⇒ <code>number</code> | <code>bigint</code></li> <li><a href="#module_utils/tensor.Tensor+tolist"><code>.tolist()</code></a> ⇒ <code>Array</code></li> <li><a href="#module_utils/tensor.Tensor+sigmoid"><code>.sigmoid()</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+sigmoid_"><code>.sigmoid_()</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+mul"><code>.mul(val)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+mul_"><code>.mul_(val)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+div"><code>.div(val)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+div_"><code>.div_(val)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+add"><code>.add(val)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+add_"><code>.add_(val)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+permute"><code>.permute(...dims)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+sum"><code>.sum([dim], keepdim)</code></a> ⇒</li> <li><a href="#module_utils/tensor.Tensor+norm"><code>.norm([p], [dim], [keepdim])</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+normalize_"><code>.normalize_([p], [dim])</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+normalize"><code>.normalize([p], [dim])</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+stride"><code>.stride()</code></a> ⇒ <code>Array.&lt;number&gt;</code></li> <li><a href="#module_utils/tensor.Tensor+squeeze"><code>.squeeze([dim])</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+squeeze_"><code>.squeeze_()</code></a></li> <li><a href="#module_utils/tensor.Tensor+unsqueeze"><code>.unsqueeze(dim)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+unsqueeze_"><code>.unsqueeze_()</code></a></li> <li><a href="#module_utils/tensor.Tensor+flatten_"><code>.flatten_()</code></a></li> <li><a href="#module_utils/tensor.Tensor+flatten"><code>.flatten(start_dim, end_dim)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+view"><code>.view(...dims)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+clamp_"><code>.clamp_()</code></a></li> <li><a href="#module_utils/tensor.Tensor+clamp"><code>.clamp(min, max)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+round_"><code>.round_()</code></a></li> <li><a href="#module_utils/tensor.Tensor+round"><code>.round()</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+to"><code>.to(type)</code></a> ⇒ <code>Tensor</code></li></ul></li>',fn,Tn,hn,A,_n,g,$n,z,mc="Create a new Tensor or copy an existing Tensor.",vn,P,pc="<thead><tr><th>Param</th><th>Type</th></tr></thead> <tbody><tr><td>...args</td><td><code>*</code></td></tr></tbody>",yn,bn,Mn,R,xn,U,Cn,E,cc="Dimensions of the tensor.",Hn,k,fc='<strong>Kind</strong>: instance property of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a>',Ln,wn,An,j,gn,J,zn,D,Tc="Type of the tensor.",Pn,q,hc='<strong>Kind</strong>: instance property of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a>',Rn,Un,En,I,kn,K,jn,B,_c="The data stored in the tensor.",Jn,N,$c='<strong>Kind</strong>: instance property of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a>',Dn,qn,In,V,Kn,Q,Bn,S,vc="The number of elements in the tensor.",Nn,O,yc='<strong>Kind</strong>: instance property of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a>',Vn,Qn,Sn,F,On,W,Fn,Y,bc="The location of the tensor data.",Wn,G,Mc='<strong>Kind</strong>: instance property of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a>',Yn,Gn,Xn,X,Zn,Z,ei,ee,xc=`Returns an iterator object for iterating over the tensor data in row-major order.
If the tensor has more than one dimension, the iterator will yield subarrays.`,ti,te,Cc='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Iterator</code> - An iterator object for iterating over the tensor data in row-major order.',li,oi,si,le,ni,oe,ii,se,Hc="Index into a Tensor object.",ri,ne,Lc='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The data at the specified index.',di,ie,wc="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>index</td><td><code>number</code></td><td><p>The index to access.</p></td></tr></tbody>",ui,ai,mi,re,pi,de,ci,ue,Ac='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>number</code> - The index of the first occurrence of item in the tensor data.',fi,ae,gc="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>item</td><td><code>number</code> | <code>bigint</code></td><td><p>The item to search for in the tensor</p></td></tr></tbody>",Ti,hi,_i,me,$i,pe,vi,ce,zc='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a>',yi,fe,Pc="<thead><tr><th>Param</th><th>Type</th></tr></thead> <tbody><tr><td>index</td><td><code>number</code></td> </tr><tr><td>iterSize</td><td><code>number</code></td> </tr><tr><td>iterDims</td><td><code>any</code></td></tr></tbody>",bi,Mi,xi,Te,Ci,he,Hi,_e,Rc=`Returns the value of this tensor as a standard JavaScript Number. This only works
for tensors with one element. For other cases, see <code>Tensor.tolist()</code>.`,Li,$e,Uc='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>number</code> | <code>bigint</code> - The value of this tensor as a standard JavaScript Number.<br/> <strong>Throws</strong>:',wi,ve,Ec="<li><code>Error</code> If the tensor has more than one element.</li>",Ai,gi,zi,ye,Pi,be,Ri,Me,kc="Convert tensor data to a n-dimensional JS list",Ui,xe,jc='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a>',Ei,ki,ji,Ce,Ji,He,Di,Le,Jc="Return a new Tensor with the sigmoid function applied to each element.",qi,we,Dc='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The tensor with the sigmoid function applied.',Ii,Ki,Bi,Ae,Ni,ge,Vi,ze,qc="Applies the sigmoid function to the tensor in place.",Qi,Pe,Ic='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - Returns <code>this</code>.',Si,Oi,Fi,Re,Wi,Ue,Yi,Ee,Kc="Return a new Tensor with every element multiplied by a constant.",Gi,ke,Bc='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The new tensor.',Xi,je,Nc="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>val</td><td><code>number</code></td><td><p>The value to multiply by.</p></td></tr></tbody>",Zi,er,tr,Je,lr,De,or,qe,Vc="Multiply the tensor by a constant in place.",sr,Ie,Qc='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - Returns <code>this</code>.',nr,Ke,Sc="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>val</td><td><code>number</code></td><td><p>The value to multiply by.</p></td></tr></tbody>",ir,rr,dr,Be,ur,Ne,ar,Ve,Oc="Return a new Tensor with every element divided by a constant.",mr,Qe,Fc='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The new tensor.',pr,Se,Wc="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>val</td><td><code>number</code></td><td><p>The value to divide by.</p></td></tr></tbody>",cr,fr,Tr,Oe,hr,Fe,_r,We,Yc="Divide the tensor by a constant in place.",$r,Ye,Gc='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - Returns <code>this</code>.',vr,Ge,Xc="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>val</td><td><code>number</code></td><td><p>The value to divide by.</p></td></tr></tbody>",yr,br,Mr,Xe,xr,Ze,Cr,et,Zc="Return a new Tensor with every element added by a constant.",Hr,tt,ef='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The new tensor.',Lr,lt,tf="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>val</td><td><code>number</code></td><td><p>The value to add by.</p></td></tr></tbody>",wr,Ar,gr,ot,zr,st,Pr,nt,lf="Add the tensor by a constant in place.",Rr,it,of='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - Returns <code>this</code>.',Ur,rt,sf="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>val</td><td><code>number</code></td><td><p>The value to add by.</p></td></tr></tbody>",Er,kr,jr,dt,Jr,ut,Dr,at,nf="Return a permuted version of this Tensor, according to the provided dimensions.",qr,mt,rf='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The permuted tensor.',Ir,pt,df="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>...dims</td><td><code>number</code></td><td><p>Dimensions to permute.</p></td></tr></tbody>",Kr,Br,Nr,ct,Vr,ft,Qr,Tt,uf="Returns the sum of each row of the input tensor in the given dimension dim.",Sr,ht,af='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: The summed tensor',Or,_t,mf="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>[dim]</td><td><code>number</code></td><td><code></code></td><td><p>The dimension or dimensions to reduce. If <code>null</code>, all dimensions are reduced.</p></td> </tr><tr><td>keepdim</td><td><code>boolean</code></td><td><code>false</code></td><td><p>Whether the output tensor has <code>dim</code> retained or not.</p></td></tr></tbody>",Fr,Wr,Yr,$t,Gr,vt,Xr,yt,pf="Returns the matrix norm or vector norm of a given tensor.",Zr,bt,cf='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The norm of the tensor.',ed,Mt,ff=`<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>[p]</td><td><code>number</code> | <code>string</code></td><td><code>&#39;fro&#39;</code></td><td><p>The order of norm</p></td> </tr><tr><td>[dim]</td><td><code>number</code></td><td><code></code></td><td><p>Specifies which dimension of the tensor to calculate the norm across.
If dim is None, the norm will be calculated across all dimensions of input.</p></td> </tr><tr><td>[keepdim]</td><td><code>boolean</code></td><td><code>false</code></td><td><p>Whether the output tensors have dim retained or not.</p></td></tr></tbody>`,td,ld,od,xt,sd,Ct,nd,Ht,Tf="Performs <code>L_p</code> normalization of inputs over specified dimension. Operates in place.",id,Lt,hf='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - <code>this</code> for operation chaining.',rd,wt,_f="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>[p]</td><td><code>number</code></td><td><code>2</code></td><td><p>The exponent value in the norm formulation</p></td> </tr><tr><td>[dim]</td><td><code>number</code></td><td><code>1</code></td><td><p>The dimension to reduce</p></td></tr></tbody>",dd,ud,ad,At,md,gt,pd,zt,$f="Performs <code>L_p</code> normalization of inputs over specified dimension.",cd,Pt,vf='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The normalized tensor.',fd,Rt,yf="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>[p]</td><td><code>number</code></td><td><code>2</code></td><td><p>The exponent value in the norm formulation</p></td> </tr><tr><td>[dim]</td><td><code>number</code></td><td><code>1</code></td><td><p>The dimension to reduce</p></td></tr></tbody>",Td,hd,_d,Ut,$d,Et,vd,kt,bf=`Compute and return the stride of this tensor.
Stride is the jump necessary to go from one element to the next one in the specified dimension dim.`,yd,jt,Mf='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Array.&lt;number&gt;</code> - The stride of this tensor.',bd,Md,xd,Jt,Cd,Dt,Hd,qt,xf="Returns a tensor with all specified dimensions of input of size 1 removed.",Ld,It,Cf=`NOTE: The returned tensor shares the storage with the input tensor, so changing the contents of one will change the contents of the other.
If you would like a copy, use <code>tensor.clone()</code> before squeezing.`,wd,Kt,Hf='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The squeezed tensor',Ad,Bt,Lf="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>[dim]</td><td><code>number</code></td><td><code></code></td><td><p>If given, the input will be squeezed only in the specified dimensions.</p></td></tr></tbody>",gd,zd,Pd,Nt,Rd,Vt,Ud,Qt,wf='In-place version of @see <a href="Tensor.squeeze">Tensor.squeeze</a>',Ed,St,Af='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a>',kd,jd,Jd,Ot,Dd,Ft,qd,Wt,gf="Returns a new tensor with a dimension of size one inserted at the specified position.",Id,Yt,zf="NOTE: The returned tensor shares the same underlying data with this tensor.",Kd,Gt,Pf='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The unsqueezed tensor',Bd,Xt,Rf="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>dim</td><td><code>number</code></td><td><code></code></td><td><p>The index at which to insert the singleton dimension</p></td></tr></tbody>",Nd,Vd,Qd,Zt,Sd,el,Od,tl,Uf='In-place version of @see <a href="Tensor.unsqueeze">Tensor.unsqueeze</a>',Fd,ll,Ef='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a>',Wd,Yd,Gd,ol,Xd,sl,Zd,nl,kf='In-place version of @see <a href="Tensor.flatten">Tensor.flatten</a>',eu,il,jf='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a>',tu,lu,ou,rl,su,dl,nu,ul,Jf=`Flattens input by reshaping it into a one-dimensional tensor.
If <code>start_dim</code> or <code>end_dim</code> are passed, only dimensions starting with <code>start_dim</code>
and ending with <code>end_dim</code> are flattened. The order of elements in input is unchanged.`,iu,al,Df='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The flattened tensor.',ru,ml,qf="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>start_dim</td><td><code>number</code></td><td><code>0</code></td><td><p>the first dim to flatten</p></td> </tr><tr><td>end_dim</td><td><code>number</code></td><td></td><td><p>the last dim to flatten</p></td></tr></tbody>",du,uu,au,pl,mu,cl,pu,fl,If="Returns a new tensor with the same data as the <code>self</code> tensor but of a different <code>shape</code>.",cu,Tl,Kf='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The tensor with the same data but different shape',fu,hl,Bf="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>...dims</td><td><code>number</code></td><td><p>the desired size</p></td></tr></tbody>",Tu,hu,_u,_l,$u,$l,vu,vl,Nf='In-place version of @see <a href="Tensor.clamp">Tensor.clamp</a>',yu,yl,Vf='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a>',bu,Mu,xu,bl,Cu,Ml,Hu,xl,Qf="Clamps all elements in input into the range [ min, max ]",Lu,Cl,Sf='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - the output tensor.',wu,Hl,Of="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>min</td><td><code>number</code></td><td><p>lower-bound of the range to be clamped to</p></td> </tr><tr><td>max</td><td><code>number</code></td><td><p>upper-bound of the range to be clamped to</p></td></tr></tbody>",Au,gu,zu,Ll,Pu,wl,Ru,Al,Ff='In-place version of @see <a href="Tensor.round">Tensor.round</a>',Uu,gl,Wf='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a>',Eu,ku,ju,zl,Ju,Pl,Du,Rl,Yf="Rounds elements of input to the nearest integer.",qu,Ul,Gf='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - the output tensor.',Iu,Ku,Bu,El,Nu,kl,Vu,jl,Xf="Performs Tensor dtype conversion.",Qu,Jl,Zf='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The converted tensor.',Su,Dl,eT='<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>type</td><td><code><a href="#DataType">DataType</a></code></td><td><p>The desired data type.</p></td></tr></tbody>',Ou,Fu,Wu,ql,Yu,Il,Gu,Kl,tT="Permutes a tensor according to the provided axes.",Xu,Bl,lT='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The permuted tensor.',Zu,Nl,oT="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>tensor</td><td><code>any</code></td><td><p>The input tensor to permute.</p></td> </tr><tr><td>axes</td><td><code>Array</code></td><td><p>The axes to permute the tensor along.</p></td></tr></tbody>",ea,ta,la,Vl,oa,Ql,sa,Sl,sT="Interpolates an Tensor to the given size.",na,Ol,nT='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The interpolated tensor.',ia,Fl,iT="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>input</td><td><code>Tensor</code></td><td><p>The input tensor to interpolate. Data must be channel-first (i.e., [c, h, w])</p></td> </tr><tr><td>size</td><td><code>Array.&lt;number&gt;</code></td><td><p>The output size of the image</p></td> </tr><tr><td>mode</td><td><code>string</code></td><td><p>The interpolation mode</p></td> </tr><tr><td>align_corners</td><td><code>boolean</code></td><td><p>Whether to align corners.</p></td></tr></tbody>",ra,da,ua,Wl,aa,Yl,ma,Gl,rT=`Down/up samples the input.
Inspired by <a href="https://pytorch.org/docs/stable/generated/torch.nn.functional.interpolate.html" rel="nofollow">https://pytorch.org/docs/stable/generated/torch.nn.functional.interpolate.html</a>.`,pa,Xl,dT='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;Tensor&gt;</code> - The interpolated tensor.',ca,Zl,uT="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>input</td><td><code>Tensor</code></td><td></td><td><p>the input tensor</p></td> </tr><tr><td>options</td><td><code>Object</code></td><td></td><td><p>the options for the interpolation</p></td> </tr><tr><td>[options.size]</td><td><code>*</code></td><td><code></code></td><td><p>output spatial size.</p></td> </tr><tr><td>[options.mode]</td><td><code>&quot;bilinear&quot;</code> | <code>&quot;bicubic&quot;</code></td><td><code>&#39;bilinear&#39;</code></td><td><p>algorithm used for upsampling</p></td></tr></tbody>",fa,Ta,ha,eo,_a,to,$a,lo,aT=`Matrix product of two tensors.
Inspired by <a href="https://pytorch.org/docs/stable/generated/torch.matmul.html" rel="nofollow">https://pytorch.org/docs/stable/generated/torch.matmul.html</a>`,va,oo,mT='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;Tensor&gt;</code> - The matrix product of the two tensors.',ya,so,pT="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>a</td><td><code>Tensor</code></td><td><p>the first tensor to be multiplied</p></td> </tr><tr><td>b</td><td><code>Tensor</code></td><td><p>the second tensor to be multiplied</p></td></tr></tbody>",ba,Ma,xa,no,Ca,io,Ha,ro,cT=`Computes the one dimensional Fourier transform of real-valued input.
Inspired by <a href="https://pytorch.org/docs/stable/generated/torch.fft.rfft.html" rel="nofollow">https://pytorch.org/docs/stable/generated/torch.fft.rfft.html</a>`,La,uo,fT='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;Tensor&gt;</code> - the output tensor.',wa,ao,TT="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>x</td><td><code>Tensor</code></td><td><p>the real input tensor</p></td> </tr><tr><td>a</td><td><code>Tensor</code></td><td><p>The dimension along which to take the one dimensional real FFT.</p></td></tr></tbody>",Aa,ga,za,mo,Pa,po,Ra,co,hT=`Returns the k largest elements of the given input tensor.
Inspired by <a href="https://pytorch.org/docs/stable/generated/torch.topk.html" rel="nofollow">https://pytorch.org/docs/stable/generated/torch.topk.html</a>`,Ua,fo,_T='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <code>*</code> - the output tuple of (Tensor, LongTensor) of top-k elements and their indices.',Ea,To,$T="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>x</td><td><code>Tensor</code></td><td><p>the input tensor</p></td> </tr><tr><td>k</td><td><code>number</code></td><td><p>the k in &quot;top-k&quot;</p></td></tr></tbody>",ka,ja,Ja,ho,Da,_o,qa,$o,vT="Perform mean pooling of the last hidden state followed by a normalization step.",Ia,vo,yT='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - Returns a new Tensor of shape [batchSize, embedDim].',Ka,yo,bT="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>last_hidden_state</td><td><code>Tensor</code></td><td><p>Tensor of shape [batchSize, seqLength, embedDim]</p></td> </tr><tr><td>attention_mask</td><td><code>Tensor</code></td><td><p>Tensor of shape [batchSize, seqLength]</p></td></tr></tbody>",Ba,Na,Va,bo,Qa,Mo,Sa,xo,MT="Apply Layer Normalization for last certain number of dimensions.",Oa,Co,xT='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The normalized tensor.',Fa,Ho,CT="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>input</td><td><code>Tensor</code></td><td></td><td><p>The input tensor</p></td> </tr><tr><td>normalized_shape</td><td><code>Array.&lt;number&gt;</code></td><td></td><td><p>input shape from an expected input of size</p></td> </tr><tr><td>options</td><td><code>Object</code></td><td></td><td><p>The options for the layer normalization</p></td> </tr><tr><td>[options.eps]</td><td><code>number</code></td><td><code>1e-5</code></td><td><p>A value added to the denominator for numerical stability.</p></td></tr></tbody>",Wa,Ya,Ga,Lo,Xa,wo,Za,Ao,HT="Concatenates an array of tensors along a specified dimension.",em,go,LT='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The concatenated tensor.',tm,zo,wT="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>tensors</td><td><code>Array.&lt;Tensor&gt;</code></td><td><p>The array of tensors to concatenate.</p></td> </tr><tr><td>dim</td><td><code>number</code></td><td><p>The dimension to concatenate along.</p></td></tr></tbody>",lm,om,sm,Po,nm,Ro,im,Uo,AT="Stack an array of tensors along a specified dimension.",rm,Eo,gT='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The stacked tensor.',dm,ko,zT="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>tensors</td><td><code>Array.&lt;Tensor&gt;</code></td><td><p>The array of tensors to stack.</p></td> </tr><tr><td>dim</td><td><code>number</code></td><td><p>The dimension to stack along.</p></td></tr></tbody>",um,am,mm,jo,pm,Jo,cm,Do,PT="Calculates the standard deviation and mean over the dimensions specified by dim. dim can be a single dimension or <code>null</code> to reduce over all dimensions.",fm,qo,RT='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <code>Array.&lt;Tensor&gt;</code> - A tuple of (std, mean) tensors.',Tm,Io,UT="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>input</td><td><code>Tensor</code></td><td><p>the input tenso</p></td> </tr><tr><td>dim</td><td><code>number</code> | <code>null</code></td><td><p>the dimension to reduce. If None, all dimensions are reduced.</p></td> </tr><tr><td>correction</td><td><code>number</code></td><td><p>difference between the sample size and sample degrees of freedom. Defaults to Bessel&#39;s correction, correction=1.</p></td> </tr><tr><td>keepdim</td><td><code>boolean</code></td><td><p>whether the output tensor has dim retained or not.</p></td></tr></tbody>",hm,_m,$m,Ko,vm,Bo,ym,No,ET="Returns the mean value of each row of the input tensor in the given dimension dim.",bm,Vo,kT='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - A new tensor with means taken along the specified dimension.',Mm,Qo,jT="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>input</td><td><code>Tensor</code></td><td><p>the input tensor.</p></td> </tr><tr><td>dim</td><td><code>number</code> | <code>null</code></td><td><p>the dimension to reduce.</p></td> </tr><tr><td>keepdim</td><td><code>boolean</code></td><td><p>whether the output tensor has dim retained or not.</p></td></tr></tbody>",xm,Cm,Hm,So,Lm,Oo,wm,Fo,JT=`Measures similarity between two temporal sequences (e.g., input audio and output tokens
to generate token-level timestamps).`,Am,Wo,DT='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a>',gm,Yo,qT="<thead><tr><th>Param</th><th>Type</th></tr></thead> <tbody><tr><td>matrix</td><td><code>Tensor</code></td></tr></tbody>",zm,Pm,Rm,Go,Um,Xo,Em,Zo,IT="Creates a tensor of size size filled with fill_value. The tensor’s dtype is inferred from fill_value.",km,es,KT='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The filled tensor.',jm,ts,BT="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>size</td><td><code>Array.&lt;number&gt;</code></td><td><p>A sequence of integers defining the shape of the output tensor.</p></td> </tr><tr><td>fill_value</td><td><code>number</code> | <code>bigint</code></td><td><p>The value to fill the output tensor with.</p></td></tr></tbody>",Jm,Dm,qm,ls,Im,os,Km,ss,NT="Returns a tensor filled with the scalar value 1, with the shape defined by the variable argument size.",Bm,ns,VT='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The ones tensor.',Nm,is,QT="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>size</td><td><code>Array.&lt;number&gt;</code></td><td><p>A sequence of integers defining the shape of the output tensor.</p></td></tr></tbody>",Vm,Qm,Sm,rs,Om,ds,Fm,us,ST="Returns a tensor filled with the scalar value 1, with the same size as input.",Wm,as,OT='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The ones tensor.',Ym,ms,FT="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>tensor</td><td><code>Tensor</code></td><td><p>The size of input will determine size of the output tensor.</p></td></tr></tbody>",Gm,Xm,Zm,ps,ep,cs,tp,fs,WT="Returns a tensor filled with the scalar value 0, with the shape defined by the variable argument size.",lp,Ts,YT='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The zeros tensor.',op,hs,GT="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>size</td><td><code>Array.&lt;number&gt;</code></td><td><p>A sequence of integers defining the shape of the output tensor.</p></td></tr></tbody>",sp,np,ip,_s,rp,$s,dp,vs,XT="Returns a tensor filled with the scalar value 0, with the same size as input.",up,ys,ZT='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The zeros tensor.',ap,bs,eh="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>tensor</td><td><code>Tensor</code></td><td><p>The size of input will determine size of the output tensor.</p></td></tr></tbody>",mp,pp,cp,Ms,fp,xs,Tp,Cs,th="Quantizes the embeddings tensor to binary or unsigned binary precision.",hp,Hs,lh='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The quantized tensor.',_p,Ls,oh="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>tensor</td><td><code>Tensor</code></td><td><p>The tensor to quantize.</p></td> </tr><tr><td>precision</td><td><code>&#39;binary&#39;</code> | <code>&#39;ubinary&#39;</code></td><td><p>The precision to use for quantization.</p></td></tr></tbody>",$p,vp,yp,ws,bp,As,Mp,gs,sh='<strong>Kind</strong>: inner property of <a href="#module_utils/tensor"><code>utils/tensor</code></a>',xp,Cp,Hp,zs,Lp,Ps,wp,Rs,nh="Reshapes a 1-dimensional array into an n-dimensional array, according to the provided dimensions.",Ap,Us,ih='<strong>Kind</strong>: inner method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <code>*</code> - The reshaped array.',gp,Es,rh="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>data</td><td><code>Array&lt;T&gt;</code> | <code>DataArray</code></td><td><p>The input array to reshape.</p></td> </tr><tr><td>dimensions</td><td><code>DIM</code></td><td><p>The target shape/dimensions.</p></td></tr></tbody>",zp,ks,dh="<strong>Example</strong>",Pp,js,Rp,Up,Ep,Js,kp,Ds,jp,qs,uh='<strong>Kind</strong>: inner property of <a href="#module_utils/tensor..reshape"><code>reshape</code></a>',Jp,Dp,qp,Is,Ip,Ks,Kp,Bs,ah='<strong>Kind</strong>: inner typedef of <a href="#module_utils/tensor"><code>utils/tensor</code></a>',Bp,Np,Vp,Ns,Qp,Vs,Sp,Qs,mh="This creates a nested array of a given type and depth (see examples).",Op,Ss,ph='<strong>Kind</strong>: inner typedef of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Example</strong>',Fp,Os,Wp,Fs,ch="<strong>Example</strong>",Yp,Ws,Gp,Ys,fh="<strong>Example</strong>",Xp,Gs,Zp,ec,tc,Xs,lc,en,oc;return y=new _({props:{title:"utils/tensor",local:"utilstensor",headingTag:"h1"}}),H=new _({props:{title:"utils/tensor.Tensor",local:"utilstensortensor",headingTag:"h2"}}),g=new _({props:{title:"new Tensor(...args)",local:"new-tensorargs",headingTag:"h3"}}),U=new _({props:{title:"tensor.dims : <code> Array. < number > </code>",local:"tensordims--code-array--number--code",headingTag:"h3"}}),J=new _({props:{title:"tensor.type : <code> DataType </code>",local:"tensortype--code-datatype-code",headingTag:"h3"}}),K=new _({props:{title:"tensor.data : <code> DataArray </code>",local:"tensordata--code-dataarray-code",headingTag:"h3"}}),Q=new _({props:{title:"tensor.size : <code> number </code>",local:"tensorsize--code-number-code",headingTag:"h3"}}),W=new _({props:{title:"tensor.location : <code> string </code>",local:"tensorlocation--code-string-code",headingTag:"h3"}}),Z=new _({props:{title:"tensor.Symbol.iterator() ⇒ <code> Iterator </code>",local:"tensorsymboliterator--code-iterator-code",headingTag:"h3"}}),oe=new _({props:{title:"tensor._getitem(index) ⇒ <code> Tensor </code>",local:"tensorgetitemindex--code-tensor-code",headingTag:"h3"}}),de=new _({props:{title:"tensor.indexOf(item) ⇒ <code> number </code>",local:"tensorindexofitem--code-number-code",headingTag:"h3"}}),pe=new _({props:{title:"tensor._subarray(index, iterSize, iterDims) ⇒ <code> Tensor </code>",local:"tensorsubarrayindex-itersize-iterdims--code-tensor-code",headingTag:"h3"}}),he=new _({props:{title:"tensor.item() ⇒ <code> number </code> | <code> bigint </code>",local:"tensoritem--code-number-code--code-bigint-code",headingTag:"h3"}}),be=new _({props:{title:"tensor.tolist() ⇒ <code> Array </code>",local:"tensortolist--code-array-code",headingTag:"h3"}}),He=new _({props:{title:"tensor.sigmoid() ⇒ <code> Tensor </code>",local:"tensorsigmoid--code-tensor-code",headingTag:"h3"}}),ge=new _({props:{title:"tensor.sigmoid_() ⇒ <code> Tensor </code>",local:"tensorsigmoid--code-tensor-code",headingTag:"h3"}}),Ue=new _({props:{title:"tensor.mul(val) ⇒ <code> Tensor </code>",local:"tensormulval--code-tensor-code",headingTag:"h3"}}),De=new _({props:{title:"tensor.mul_(val) ⇒ <code> Tensor </code>",local:"tensormulval--code-tensor-code",headingTag:"h3"}}),Ne=new _({props:{title:"tensor.div(val) ⇒ <code> Tensor </code>",local:"tensordivval--code-tensor-code",headingTag:"h3"}}),Fe=new _({props:{title:"tensor.div_(val) ⇒ <code> Tensor </code>",local:"tensordivval--code-tensor-code",headingTag:"h3"}}),Ze=new _({props:{title:"tensor.add(val) ⇒ <code> Tensor </code>",local:"tensoraddval--code-tensor-code",headingTag:"h3"}}),st=new _({props:{title:"tensor.add_(val) ⇒ <code> Tensor </code>",local:"tensoraddval--code-tensor-code",headingTag:"h3"}}),ut=new _({props:{title:"tensor.permute(...dims) ⇒ <code> Tensor </code>",local:"tensorpermutedims--code-tensor-code",headingTag:"h3"}}),ft=new _({props:{title:"tensor.sum([dim], keepdim) ⇒",local:"tensorsumdim-keepdim-",headingTag:"h3"}}),vt=new _({props:{title:"tensor.norm([p], [dim], [keepdim]) ⇒ <code> Tensor </code>",local:"tensornormp-dim-keepdim--code-tensor-code",headingTag:"h3"}}),Ct=new _({props:{title:"tensor.normalize_([p], [dim]) ⇒ <code> Tensor </code>",local:"tensornormalizep-dim--code-tensor-code",headingTag:"h3"}}),gt=new _({props:{title:"tensor.normalize([p], [dim]) ⇒ <code> Tensor </code>",local:"tensornormalizep-dim--code-tensor-code",headingTag:"h3"}}),Et=new _({props:{title:"tensor.stride() ⇒ <code> Array. < number > </code>",local:"tensorstride--code-array--number--code",headingTag:"h3"}}),Dt=new _({props:{title:"tensor.squeeze([dim]) ⇒ <code> Tensor </code>",local:"tensorsqueezedim--code-tensor-code",headingTag:"h3"}}),Vt=new _({props:{title:"tensor.squeeze_()",local:"tensorsqueeze",headingTag:"h3"}}),Ft=new _({props:{title:"tensor.unsqueeze(dim) ⇒ <code> Tensor </code>",local:"tensorunsqueezedim--code-tensor-code",headingTag:"h3"}}),el=new _({props:{title:"tensor.unsqueeze_()",local:"tensorunsqueeze",headingTag:"h3"}}),sl=new _({props:{title:"tensor.flatten_()",local:"tensorflatten",headingTag:"h3"}}),dl=new _({props:{title:"tensor.flatten(start_dim, end_dim) ⇒ <code> Tensor </code>",local:"tensorflattenstartdim-enddim--code-tensor-code",headingTag:"h3"}}),cl=new _({props:{title:"tensor.view(...dims) ⇒ <code> Tensor </code>",local:"tensorviewdims--code-tensor-code",headingTag:"h3"}}),$l=new _({props:{title:"tensor.clamp_()",local:"tensorclamp",headingTag:"h3"}}),Ml=new _({props:{title:"tensor.clamp(min, max) ⇒ <code> Tensor </code>",local:"tensorclampmin-max--code-tensor-code",headingTag:"h3"}}),wl=new _({props:{title:"tensor.round_()",local:"tensorround",headingTag:"h3"}}),Pl=new _({props:{title:"tensor.round() ⇒ <code> Tensor </code>",local:"tensorround--code-tensor-code",headingTag:"h3"}}),kl=new _({props:{title:"tensor.to(type) ⇒ <code> Tensor </code>",local:"tensortotype--code-tensor-code",headingTag:"h3"}}),Il=new _({props:{title:"utils/tensor.permute(tensor, axes) ⇒ <code> Tensor </code>",local:"utilstensorpermutetensor-axes--code-tensor-code",headingTag:"h2"}}),Ql=new _({props:{title:"utils/tensor.interpolate(input, size, mode, align_corners) ⇒ <code> Tensor </code>",local:"utilstensorinterpolateinput-size-mode-aligncorners--code-tensor-code",headingTag:"h2"}}),Yl=new _({props:{title:"utils/tensor.interpolate_4d(input, options) ⇒ <code> Promise. < Tensor > </code>",local:"utilstensorinterpolate4dinput-options--code-promise--tensor--code",headingTag:"h2"}}),to=new _({props:{title:"utils/tensor.matmul(a, b) ⇒ <code> Promise. < Tensor > </code>",local:"utilstensormatmula-b--code-promise--tensor--code",headingTag:"h2"}}),io=new _({props:{title:"utils/tensor.rfft(x, a) ⇒ <code> Promise. < Tensor > </code>",local:"utilstensorrfftx-a--code-promise--tensor--code",headingTag:"h2"}}),po=new _({props:{title:"utils/tensor.topk(x, k) ⇒ <code> * </code>",local:"utilstensortopkx-k--code--code",headingTag:"h2"}}),_o=new _({props:{title:"utils/tensor.mean_pooling(last_hidden_state, attention_mask) ⇒ <code> Tensor </code>",local:"utilstensormeanpoolinglasthiddenstate-attentionmask--code-tensor-code",headingTag:"h2"}}),Mo=new _({props:{title:"utils/tensor.layer_norm(input, normalized_shape, options) ⇒ <code> Tensor </code>",local:"utilstensorlayernorminput-normalizedshape-options--code-tensor-code",headingTag:"h2"}}),wo=new _({props:{title:"utils/tensor.cat(tensors, dim) ⇒ <code> Tensor </code>",local:"utilstensorcattensors-dim--code-tensor-code",headingTag:"h2"}}),Ro=new _({props:{title:"utils/tensor.stack(tensors, dim) ⇒ <code> Tensor </code>",local:"utilstensorstacktensors-dim--code-tensor-code",headingTag:"h2"}}),Jo=new _({props:{title:"utils/tensor.std_mean(input, dim, correction, keepdim) ⇒ <code> Array. < Tensor > </code>",local:"utilstensorstdmeaninput-dim-correction-keepdim--code-array--tensor--code",headingTag:"h2"}}),Bo=new _({props:{title:"utils/tensor.mean(input, dim, keepdim) ⇒ <code> Tensor </code>",local:"utilstensormeaninput-dim-keepdim--code-tensor-code",headingTag:"h2"}}),Oo=new _({props:{title:"utils/tensor.dynamicTimeWarping(matrix) ⇒ <code> Array. < Array < number > > </code>",local:"utilstensordynamictimewarpingmatrix--code-array--array--number---code",headingTag:"h2"}}),Xo=new _({props:{title:"utils/tensor.full(size, fill_value) ⇒ <code> Tensor </code>",local:"utilstensorfullsize-fillvalue--code-tensor-code",headingTag:"h2"}}),os=new _({props:{title:"utils/tensor.ones(size) ⇒ <code> Tensor </code>",local:"utilstensoronessize--code-tensor-code",headingTag:"h2"}}),ds=new _({props:{title:"utils/tensor.ones_like(tensor) ⇒ <code> Tensor </code>",local:"utilstensoronesliketensor--code-tensor-code",headingTag:"h2"}}),cs=new _({props:{title:"utils/tensor.zeros(size) ⇒ <code> Tensor </code>",local:"utilstensorzerossize--code-tensor-code",headingTag:"h2"}}),$s=new _({props:{title:"utils/tensor.zeros_like(tensor) ⇒ <code> Tensor </code>",local:"utilstensorzerosliketensor--code-tensor-code",headingTag:"h2"}}),xs=new _({props:{title:"utils/tensor.quantize_embeddings(tensor, precision) ⇒ <code> Tensor </code>",local:"utilstensorquantizeembeddingstensor-precision--code-tensor-code",headingTag:"h2"}}),As=new _({props:{title:"utils/tensor~args[0] : <code> ONNXTensor </code>",local:"utilstensorargs0--code-onnxtensor-code",headingTag:"h2"}}),Ps=new _({props:{title:"utils/tensor~reshape(data, dimensions) ⇒ <code> * </code>",local:"utilstensorreshapedata-dimensions--code--code",headingTag:"h2"}}),js=new sc({props:{code:"cmVzaGFwZSglNUIxMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1RCUyQyUyMCU1QjElMjAlMjAlMjAlMjAlMjAlMjAlNUQpJTNCJTIwJTJGJTJGJTIwVHlwZSUzQSUyMG51bWJlciU1QiU1RCUyMCUyMCUyMCUyMCUyMCUyMFZhbHVlJTNBJTIwJTVCMTAlNUQlMEElMjAlMjByZXNoYXBlKCU1QjElMkMlMjAyJTJDJTIwMyUyQyUyMDQlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUQlMkMlMjAlNUIyJTJDJTIwMiUyMCUyMCUyMCU1RCklM0IlMjAlMkYlMkYlMjBUeXBlJTNBJTIwbnVtYmVyJTVCJTVEJTVCJTVEJTIwJTIwJTIwJTIwVmFsdWUlM0ElMjAlNUIlNUIxJTJDJTIwMiU1RCUyQyUyMCU1QjMlMkMlMjA0JTVEJTVEJTBBJTIwJTIwcmVzaGFwZSglNUIxJTJDJTIwMiUyQyUyMDMlMkMlMjA0JTJDJTIwNSUyQyUyMDYlMkMlMjA3JTJDJTIwOCU1RCUyQyUyMCU1QjIlMkMlMjAyJTJDJTIwMiU1RCklM0IlMjAlMkYlMkYlMjBUeXBlJTNBJTIwbnVtYmVyJTVCJTVEJTVCJTVEJTVCJTVEJTIwJTIwVmFsdWUlM0ElMjAlNUIlNUIlNUIxJTJDJTIwMiU1RCUyQyUyMCU1QjMlMkMlMjA0JTVEJTVEJTJDJTIwJTVCJTVCNSUyQyUyMDYlNUQlMkMlMjAlNUI3JTJDJTIwOCU1RCU1RCU1RCUwQSUyMCUyMHJlc2hhcGUoJTVCMSUyQyUyMDIlMkMlMjAzJTJDJTIwNCUyQyUyMDUlMkMlMjA2JTJDJTIwNyUyQyUyMDglNUQlMkMlMjAlNUI0JTJDJTIwMiUyMCUyMCUyMCU1RCklM0IlMjAlMkYlMkYlMjBUeXBlJTNBJTIwbnVtYmVyJTVCJTVEJTVCJTVEJTIwJTIwJTIwJTIwVmFsdWUlM0ElMjAlNUIlNUIxJTJDJTIwMiU1RCUyQyUyMCU1QjMlMkMlMjA0JTVEJTJDJTIwJTVCNSUyQyUyMDYlNUQlMkMlMjAlNUI3JTJDJTIwOCU1RCU1RA==",highlighted:`<span class="hljs-title function_">reshape</span>([<span class="hljs-number">10</span>                    ], [<span class="hljs-number">1</span>      ]); <span class="hljs-comment">// Type: number[]      Value: [10]</span>
  <span class="hljs-title function_">reshape</span>([<span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">4</span>            ], [<span class="hljs-number">2</span>, <span class="hljs-number">2</span>   ]); <span class="hljs-comment">// Type: number[][]    Value: [[1, 2], [3, 4]]</span>
  <span class="hljs-title function_">reshape</span>([<span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">5</span>, <span class="hljs-number">6</span>, <span class="hljs-number">7</span>, <span class="hljs-number">8</span>], [<span class="hljs-number">2</span>, <span class="hljs-number">2</span>, <span class="hljs-number">2</span>]); <span class="hljs-comment">// Type: number[][][]  Value: [[[1, 2], [3, 4]], [[5, 6], [7, 8]]]</span>
  <span class="hljs-title function_">reshape</span>([<span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">5</span>, <span class="hljs-number">6</span>, <span class="hljs-number">7</span>, <span class="hljs-number">8</span>], [<span class="hljs-number">4</span>, <span class="hljs-number">2</span>   ]); <span class="hljs-comment">// Type: number[][]    Value: [[1, 2], [3, 4], [5, 6], [7, 8]]</span>`,wrap:!1}}),Ds=new _({props:{title:"reshape~reshapedArray : <code> any </code>",local:"reshapereshapedarray--code-any-code",headingTag:"h3"}}),Ks=new _({props:{title:"utils/tensor~DataArray : <code> * </code>",local:"utilstensordataarray--code--code",headingTag:"h2"}}),Vs=new _({props:{title:"utils/tensor~NestArray : <code> * </code>",local:"utilstensornestarray--code--code",headingTag:"h2"}}),Os=new sc({props:{code:"TmVzdEFycmF5JTNDc3RyaW5nJTJDJTIwMSUzRSUzQiUyMCUyRiUyRiUyMHN0cmluZyU1QiU1RA==",highlighted:'<span class="hljs-title class_">NestArray</span>&lt;string, <span class="hljs-number">1</span>&gt;; <span class="hljs-comment">// string[]</span>',wrap:!1}}),Ws=new sc({props:{code:"TmVzdEFycmF5JTNDbnVtYmVyJTJDJTIwMiUzRSUzQiUyMCUyRiUyRiUyMG51bWJlciU1QiU1RCU1QiU1RA==",highlighted:'<span class="hljs-title class_">NestArray</span>&lt;number, <span class="hljs-number">2</span>&gt;; <span class="hljs-comment">// number[][]</span>',wrap:!1}}),Gs=new sc({props:{code:"TmVzdEFycmF5JTNDc3RyaW5nJTJDJTIwMyUzRSUzQiUyMCUyRiUyRiUyMHN0cmluZyU1QiU1RCU1QiU1RCU1QiU1RCUyMGV0Yy4=",highlighted:'<span class="hljs-title class_">NestArray</span>&lt;string, <span class="hljs-number">3</span>&gt;; <span class="hljs-comment">// string[][][] etc.</span>',wrap:!1}}),Xs=new Mh({props:{source:"https://github.com/xenova/transformers.js/blob/main/docs/source/api/utils/tensor.md"}}),{c(){$=i("meta"),tn=s(),Zs=i("p"),ln=s(),v=i("a"),on=s(),a(y.$$.fragment),sn=s(),b=i("p"),b.innerHTML=ic,nn=s(),M=i("p"),M.textContent=rc,rn=s(),x=i("ul"),x.innerHTML=dc,dn=s(),un=i("hr"),an=s(),C=i("a"),mn=s(),a(H.$$.fragment),pn=s(),L=i("p"),L.innerHTML=uc,cn=s(),w=i("ul"),w.innerHTML=ac,fn=s(),Tn=i("hr"),hn=s(),A=i("a"),_n=s(),a(g.$$.fragment),$n=s(),z=i("p"),z.textContent=mc,vn=s(),P=i("table"),P.innerHTML=pc,yn=s(),bn=i("hr"),Mn=s(),R=i("a"),xn=s(),a(U.$$.fragment),Cn=s(),E=i("p"),E.textContent=cc,Hn=s(),k=i("p"),k.innerHTML=fc,Ln=s(),wn=i("hr"),An=s(),j=i("a"),gn=s(),a(J.$$.fragment),zn=s(),D=i("p"),D.textContent=Tc,Pn=s(),q=i("p"),q.innerHTML=hc,Rn=s(),Un=i("hr"),En=s(),I=i("a"),kn=s(),a(K.$$.fragment),jn=s(),B=i("p"),B.textContent=_c,Jn=s(),N=i("p"),N.innerHTML=$c,Dn=s(),qn=i("hr"),In=s(),V=i("a"),Kn=s(),a(Q.$$.fragment),Bn=s(),S=i("p"),S.textContent=vc,Nn=s(),O=i("p"),O.innerHTML=yc,Vn=s(),Qn=i("hr"),Sn=s(),F=i("a"),On=s(),a(W.$$.fragment),Fn=s(),Y=i("p"),Y.textContent=bc,Wn=s(),G=i("p"),G.innerHTML=Mc,Yn=s(),Gn=i("hr"),Xn=s(),X=i("a"),Zn=s(),a(Z.$$.fragment),ei=s(),ee=i("p"),ee.textContent=xc,ti=s(),te=i("p"),te.innerHTML=Cc,li=s(),oi=i("hr"),si=s(),le=i("a"),ni=s(),a(oe.$$.fragment),ii=s(),se=i("p"),se.textContent=Hc,ri=s(),ne=i("p"),ne.innerHTML=Lc,di=s(),ie=i("table"),ie.innerHTML=wc,ui=s(),ai=i("hr"),mi=s(),re=i("a"),pi=s(),a(de.$$.fragment),ci=s(),ue=i("p"),ue.innerHTML=Ac,fi=s(),ae=i("table"),ae.innerHTML=gc,Ti=s(),hi=i("hr"),_i=s(),me=i("a"),$i=s(),a(pe.$$.fragment),vi=s(),ce=i("p"),ce.innerHTML=zc,yi=s(),fe=i("table"),fe.innerHTML=Pc,bi=s(),Mi=i("hr"),xi=s(),Te=i("a"),Ci=s(),a(he.$$.fragment),Hi=s(),_e=i("p"),_e.innerHTML=Rc,Li=s(),$e=i("p"),$e.innerHTML=Uc,wi=s(),ve=i("ul"),ve.innerHTML=Ec,Ai=s(),gi=i("hr"),zi=s(),ye=i("a"),Pi=s(),a(be.$$.fragment),Ri=s(),Me=i("p"),Me.textContent=kc,Ui=s(),xe=i("p"),xe.innerHTML=jc,Ei=s(),ki=i("hr"),ji=s(),Ce=i("a"),Ji=s(),a(He.$$.fragment),Di=s(),Le=i("p"),Le.textContent=Jc,qi=s(),we=i("p"),we.innerHTML=Dc,Ii=s(),Ki=i("hr"),Bi=s(),Ae=i("a"),Ni=s(),a(ge.$$.fragment),Vi=s(),ze=i("p"),ze.textContent=qc,Qi=s(),Pe=i("p"),Pe.innerHTML=Ic,Si=s(),Oi=i("hr"),Fi=s(),Re=i("a"),Wi=s(),a(Ue.$$.fragment),Yi=s(),Ee=i("p"),Ee.textContent=Kc,Gi=s(),ke=i("p"),ke.innerHTML=Bc,Xi=s(),je=i("table"),je.innerHTML=Nc,Zi=s(),er=i("hr"),tr=s(),Je=i("a"),lr=s(),a(De.$$.fragment),or=s(),qe=i("p"),qe.textContent=Vc,sr=s(),Ie=i("p"),Ie.innerHTML=Qc,nr=s(),Ke=i("table"),Ke.innerHTML=Sc,ir=s(),rr=i("hr"),dr=s(),Be=i("a"),ur=s(),a(Ne.$$.fragment),ar=s(),Ve=i("p"),Ve.textContent=Oc,mr=s(),Qe=i("p"),Qe.innerHTML=Fc,pr=s(),Se=i("table"),Se.innerHTML=Wc,cr=s(),fr=i("hr"),Tr=s(),Oe=i("a"),hr=s(),a(Fe.$$.fragment),_r=s(),We=i("p"),We.textContent=Yc,$r=s(),Ye=i("p"),Ye.innerHTML=Gc,vr=s(),Ge=i("table"),Ge.innerHTML=Xc,yr=s(),br=i("hr"),Mr=s(),Xe=i("a"),xr=s(),a(Ze.$$.fragment),Cr=s(),et=i("p"),et.textContent=Zc,Hr=s(),tt=i("p"),tt.innerHTML=ef,Lr=s(),lt=i("table"),lt.innerHTML=tf,wr=s(),Ar=i("hr"),gr=s(),ot=i("a"),zr=s(),a(st.$$.fragment),Pr=s(),nt=i("p"),nt.textContent=lf,Rr=s(),it=i("p"),it.innerHTML=of,Ur=s(),rt=i("table"),rt.innerHTML=sf,Er=s(),kr=i("hr"),jr=s(),dt=i("a"),Jr=s(),a(ut.$$.fragment),Dr=s(),at=i("p"),at.textContent=nf,qr=s(),mt=i("p"),mt.innerHTML=rf,Ir=s(),pt=i("table"),pt.innerHTML=df,Kr=s(),Br=i("hr"),Nr=s(),ct=i("a"),Vr=s(),a(ft.$$.fragment),Qr=s(),Tt=i("p"),Tt.textContent=uf,Sr=s(),ht=i("p"),ht.innerHTML=af,Or=s(),_t=i("table"),_t.innerHTML=mf,Fr=s(),Wr=i("hr"),Yr=s(),$t=i("a"),Gr=s(),a(vt.$$.fragment),Xr=s(),yt=i("p"),yt.textContent=pf,Zr=s(),bt=i("p"),bt.innerHTML=cf,ed=s(),Mt=i("table"),Mt.innerHTML=ff,td=s(),ld=i("hr"),od=s(),xt=i("a"),sd=s(),a(Ct.$$.fragment),nd=s(),Ht=i("p"),Ht.innerHTML=Tf,id=s(),Lt=i("p"),Lt.innerHTML=hf,rd=s(),wt=i("table"),wt.innerHTML=_f,dd=s(),ud=i("hr"),ad=s(),At=i("a"),md=s(),a(gt.$$.fragment),pd=s(),zt=i("p"),zt.innerHTML=$f,cd=s(),Pt=i("p"),Pt.innerHTML=vf,fd=s(),Rt=i("table"),Rt.innerHTML=yf,Td=s(),hd=i("hr"),_d=s(),Ut=i("a"),$d=s(),a(Et.$$.fragment),vd=s(),kt=i("p"),kt.textContent=bf,yd=s(),jt=i("p"),jt.innerHTML=Mf,bd=s(),Md=i("hr"),xd=s(),Jt=i("a"),Cd=s(),a(Dt.$$.fragment),Hd=s(),qt=i("p"),qt.textContent=xf,Ld=s(),It=i("p"),It.innerHTML=Cf,wd=s(),Kt=i("p"),Kt.innerHTML=Hf,Ad=s(),Bt=i("table"),Bt.innerHTML=Lf,gd=s(),zd=i("hr"),Pd=s(),Nt=i("a"),Rd=s(),a(Vt.$$.fragment),Ud=s(),Qt=i("p"),Qt.innerHTML=wf,Ed=s(),St=i("p"),St.innerHTML=Af,kd=s(),jd=i("hr"),Jd=s(),Ot=i("a"),Dd=s(),a(Ft.$$.fragment),qd=s(),Wt=i("p"),Wt.textContent=gf,Id=s(),Yt=i("p"),Yt.textContent=zf,Kd=s(),Gt=i("p"),Gt.innerHTML=Pf,Bd=s(),Xt=i("table"),Xt.innerHTML=Rf,Nd=s(),Vd=i("hr"),Qd=s(),Zt=i("a"),Sd=s(),a(el.$$.fragment),Od=s(),tl=i("p"),tl.innerHTML=Uf,Fd=s(),ll=i("p"),ll.innerHTML=Ef,Wd=s(),Yd=i("hr"),Gd=s(),ol=i("a"),Xd=s(),a(sl.$$.fragment),Zd=s(),nl=i("p"),nl.innerHTML=kf,eu=s(),il=i("p"),il.innerHTML=jf,tu=s(),lu=i("hr"),ou=s(),rl=i("a"),su=s(),a(dl.$$.fragment),nu=s(),ul=i("p"),ul.innerHTML=Jf,iu=s(),al=i("p"),al.innerHTML=Df,ru=s(),ml=i("table"),ml.innerHTML=qf,du=s(),uu=i("hr"),au=s(),pl=i("a"),mu=s(),a(cl.$$.fragment),pu=s(),fl=i("p"),fl.innerHTML=If,cu=s(),Tl=i("p"),Tl.innerHTML=Kf,fu=s(),hl=i("table"),hl.innerHTML=Bf,Tu=s(),hu=i("hr"),_u=s(),_l=i("a"),$u=s(),a($l.$$.fragment),vu=s(),vl=i("p"),vl.innerHTML=Nf,yu=s(),yl=i("p"),yl.innerHTML=Vf,bu=s(),Mu=i("hr"),xu=s(),bl=i("a"),Cu=s(),a(Ml.$$.fragment),Hu=s(),xl=i("p"),xl.textContent=Qf,Lu=s(),Cl=i("p"),Cl.innerHTML=Sf,wu=s(),Hl=i("table"),Hl.innerHTML=Of,Au=s(),gu=i("hr"),zu=s(),Ll=i("a"),Pu=s(),a(wl.$$.fragment),Ru=s(),Al=i("p"),Al.innerHTML=Ff,Uu=s(),gl=i("p"),gl.innerHTML=Wf,Eu=s(),ku=i("hr"),ju=s(),zl=i("a"),Ju=s(),a(Pl.$$.fragment),Du=s(),Rl=i("p"),Rl.textContent=Yf,qu=s(),Ul=i("p"),Ul.innerHTML=Gf,Iu=s(),Ku=i("hr"),Bu=s(),El=i("a"),Nu=s(),a(kl.$$.fragment),Vu=s(),jl=i("p"),jl.textContent=Xf,Qu=s(),Jl=i("p"),Jl.innerHTML=Zf,Su=s(),Dl=i("table"),Dl.innerHTML=eT,Ou=s(),Fu=i("hr"),Wu=s(),ql=i("a"),Yu=s(),a(Il.$$.fragment),Gu=s(),Kl=i("p"),Kl.textContent=tT,Xu=s(),Bl=i("p"),Bl.innerHTML=lT,Zu=s(),Nl=i("table"),Nl.innerHTML=oT,ea=s(),ta=i("hr"),la=s(),Vl=i("a"),oa=s(),a(Ql.$$.fragment),sa=s(),Sl=i("p"),Sl.textContent=sT,na=s(),Ol=i("p"),Ol.innerHTML=nT,ia=s(),Fl=i("table"),Fl.innerHTML=iT,ra=s(),da=i("hr"),ua=s(),Wl=i("a"),aa=s(),a(Yl.$$.fragment),ma=s(),Gl=i("p"),Gl.innerHTML=rT,pa=s(),Xl=i("p"),Xl.innerHTML=dT,ca=s(),Zl=i("table"),Zl.innerHTML=uT,fa=s(),Ta=i("hr"),ha=s(),eo=i("a"),_a=s(),a(to.$$.fragment),$a=s(),lo=i("p"),lo.innerHTML=aT,va=s(),oo=i("p"),oo.innerHTML=mT,ya=s(),so=i("table"),so.innerHTML=pT,ba=s(),Ma=i("hr"),xa=s(),no=i("a"),Ca=s(),a(io.$$.fragment),Ha=s(),ro=i("p"),ro.innerHTML=cT,La=s(),uo=i("p"),uo.innerHTML=fT,wa=s(),ao=i("table"),ao.innerHTML=TT,Aa=s(),ga=i("hr"),za=s(),mo=i("a"),Pa=s(),a(po.$$.fragment),Ra=s(),co=i("p"),co.innerHTML=hT,Ua=s(),fo=i("p"),fo.innerHTML=_T,Ea=s(),To=i("table"),To.innerHTML=$T,ka=s(),ja=i("hr"),Ja=s(),ho=i("a"),Da=s(),a(_o.$$.fragment),qa=s(),$o=i("p"),$o.textContent=vT,Ia=s(),vo=i("p"),vo.innerHTML=yT,Ka=s(),yo=i("table"),yo.innerHTML=bT,Ba=s(),Na=i("hr"),Va=s(),bo=i("a"),Qa=s(),a(Mo.$$.fragment),Sa=s(),xo=i("p"),xo.textContent=MT,Oa=s(),Co=i("p"),Co.innerHTML=xT,Fa=s(),Ho=i("table"),Ho.innerHTML=CT,Wa=s(),Ya=i("hr"),Ga=s(),Lo=i("a"),Xa=s(),a(wo.$$.fragment),Za=s(),Ao=i("p"),Ao.textContent=HT,em=s(),go=i("p"),go.innerHTML=LT,tm=s(),zo=i("table"),zo.innerHTML=wT,lm=s(),om=i("hr"),sm=s(),Po=i("a"),nm=s(),a(Ro.$$.fragment),im=s(),Uo=i("p"),Uo.textContent=AT,rm=s(),Eo=i("p"),Eo.innerHTML=gT,dm=s(),ko=i("table"),ko.innerHTML=zT,um=s(),am=i("hr"),mm=s(),jo=i("a"),pm=s(),a(Jo.$$.fragment),cm=s(),Do=i("p"),Do.innerHTML=PT,fm=s(),qo=i("p"),qo.innerHTML=RT,Tm=s(),Io=i("table"),Io.innerHTML=UT,hm=s(),_m=i("hr"),$m=s(),Ko=i("a"),vm=s(),a(Bo.$$.fragment),ym=s(),No=i("p"),No.textContent=ET,bm=s(),Vo=i("p"),Vo.innerHTML=kT,Mm=s(),Qo=i("table"),Qo.innerHTML=jT,xm=s(),Cm=i("hr"),Hm=s(),So=i("a"),Lm=s(),a(Oo.$$.fragment),wm=s(),Fo=i("p"),Fo.textContent=JT,Am=s(),Wo=i("p"),Wo.innerHTML=DT,gm=s(),Yo=i("table"),Yo.innerHTML=qT,zm=s(),Pm=i("hr"),Rm=s(),Go=i("a"),Um=s(),a(Xo.$$.fragment),Em=s(),Zo=i("p"),Zo.textContent=IT,km=s(),es=i("p"),es.innerHTML=KT,jm=s(),ts=i("table"),ts.innerHTML=BT,Jm=s(),Dm=i("hr"),qm=s(),ls=i("a"),Im=s(),a(os.$$.fragment),Km=s(),ss=i("p"),ss.textContent=NT,Bm=s(),ns=i("p"),ns.innerHTML=VT,Nm=s(),is=i("table"),is.innerHTML=QT,Vm=s(),Qm=i("hr"),Sm=s(),rs=i("a"),Om=s(),a(ds.$$.fragment),Fm=s(),us=i("p"),us.textContent=ST,Wm=s(),as=i("p"),as.innerHTML=OT,Ym=s(),ms=i("table"),ms.innerHTML=FT,Gm=s(),Xm=i("hr"),Zm=s(),ps=i("a"),ep=s(),a(cs.$$.fragment),tp=s(),fs=i("p"),fs.textContent=WT,lp=s(),Ts=i("p"),Ts.innerHTML=YT,op=s(),hs=i("table"),hs.innerHTML=GT,sp=s(),np=i("hr"),ip=s(),_s=i("a"),rp=s(),a($s.$$.fragment),dp=s(),vs=i("p"),vs.textContent=XT,up=s(),ys=i("p"),ys.innerHTML=ZT,ap=s(),bs=i("table"),bs.innerHTML=eh,mp=s(),pp=i("hr"),cp=s(),Ms=i("a"),fp=s(),a(xs.$$.fragment),Tp=s(),Cs=i("p"),Cs.textContent=th,hp=s(),Hs=i("p"),Hs.innerHTML=lh,_p=s(),Ls=i("table"),Ls.innerHTML=oh,$p=s(),vp=i("hr"),yp=s(),ws=i("a"),bp=s(),a(As.$$.fragment),Mp=s(),gs=i("p"),gs.innerHTML=sh,xp=s(),Cp=i("hr"),Hp=s(),zs=i("a"),Lp=s(),a(Ps.$$.fragment),wp=s(),Rs=i("p"),Rs.textContent=nh,Ap=s(),Us=i("p"),Us.innerHTML=ih,gp=s(),Es=i("table"),Es.innerHTML=rh,zp=s(),ks=i("p"),ks.innerHTML=dh,Pp=s(),a(js.$$.fragment),Rp=s(),Up=i("hr"),Ep=s(),Js=i("a"),kp=s(),a(Ds.$$.fragment),jp=s(),qs=i("p"),qs.innerHTML=uh,Jp=s(),Dp=i("hr"),qp=s(),Is=i("a"),Ip=s(),a(Ks.$$.fragment),Kp=s(),Bs=i("p"),Bs.innerHTML=ah,Bp=s(),Np=i("hr"),Vp=s(),Ns=i("a"),Qp=s(),a(Vs.$$.fragment),Sp=s(),Qs=i("p"),Qs.textContent=mh,Op=s(),Ss=i("p"),Ss.innerHTML=ph,Fp=s(),a(Os.$$.fragment),Wp=s(),Fs=i("p"),Fs.innerHTML=ch,Yp=s(),a(Ws.$$.fragment),Gp=s(),Ys=i("p"),Ys.innerHTML=fh,Xp=s(),a(Gs.$$.fragment),Zp=s(),ec=i("hr"),tc=s(),a(Xs.$$.fragment),lc=s(),en=i("p"),this.h()},l(e){const t=yh("svelte-u9bgzb",document.head);$=r(t,"META",{name:!0,content:!0}),t.forEach(l),tn=n(e),Zs=r(e,"P",{}),h(Zs).forEach(l),ln=n(e),v=r(e,"A",{id:!0,class:!0}),h(v).forEach(l),on=n(e),m(y.$$.fragment,e),sn=n(e),b=r(e,"P",{"data-svelte-h":!0}),d(b)!=="svelte-uw4y1m"&&(b.innerHTML=ic),nn=n(e),M=r(e,"P",{"data-svelte-h":!0}),d(M)!=="svelte-il3kl8"&&(M.textContent=rc),rn=n(e),x=r(e,"UL",{"data-svelte-h":!0}),d(x)!=="svelte-hs7fsj"&&(x.innerHTML=dc),dn=n(e),un=r(e,"HR",{}),an=n(e),C=r(e,"A",{id:!0,class:!0}),h(C).forEach(l),mn=n(e),m(H.$$.fragment,e),pn=n(e),L=r(e,"P",{"data-svelte-h":!0}),d(L)!=="svelte-1ugrfrw"&&(L.innerHTML=uc),cn=n(e),w=r(e,"UL",{"data-svelte-h":!0}),d(w)!=="svelte-x6wsf6"&&(w.innerHTML=ac),fn=n(e),Tn=r(e,"HR",{}),hn=n(e),A=r(e,"A",{id:!0,class:!0}),h(A).forEach(l),_n=n(e),m(g.$$.fragment,e),$n=n(e),z=r(e,"P",{"data-svelte-h":!0}),d(z)!=="svelte-55wecd"&&(z.textContent=mc),vn=n(e),P=r(e,"TABLE",{"data-svelte-h":!0}),d(P)!=="svelte-ee7emz"&&(P.innerHTML=pc),yn=n(e),bn=r(e,"HR",{}),Mn=n(e),R=r(e,"A",{id:!0,class:!0}),h(R).forEach(l),xn=n(e),m(U.$$.fragment,e),Cn=n(e),E=r(e,"P",{"data-svelte-h":!0}),d(E)!=="svelte-1gc2rt4"&&(E.textContent=cc),Hn=n(e),k=r(e,"P",{"data-svelte-h":!0}),d(k)!=="svelte-10qzguj"&&(k.innerHTML=fc),Ln=n(e),wn=r(e,"HR",{}),An=n(e),j=r(e,"A",{id:!0,class:!0}),h(j).forEach(l),gn=n(e),m(J.$$.fragment,e),zn=n(e),D=r(e,"P",{"data-svelte-h":!0}),d(D)!=="svelte-81y0bb"&&(D.textContent=Tc),Pn=n(e),q=r(e,"P",{"data-svelte-h":!0}),d(q)!=="svelte-10qzguj"&&(q.innerHTML=hc),Rn=n(e),Un=r(e,"HR",{}),En=n(e),I=r(e,"A",{id:!0,class:!0}),h(I).forEach(l),kn=n(e),m(K.$$.fragment,e),jn=n(e),B=r(e,"P",{"data-svelte-h":!0}),d(B)!=="svelte-1eqabt7"&&(B.textContent=_c),Jn=n(e),N=r(e,"P",{"data-svelte-h":!0}),d(N)!=="svelte-10qzguj"&&(N.innerHTML=$c),Dn=n(e),qn=r(e,"HR",{}),In=n(e),V=r(e,"A",{id:!0,class:!0}),h(V).forEach(l),Kn=n(e),m(Q.$$.fragment,e),Bn=n(e),S=r(e,"P",{"data-svelte-h":!0}),d(S)!=="svelte-krrt97"&&(S.textContent=vc),Nn=n(e),O=r(e,"P",{"data-svelte-h":!0}),d(O)!=="svelte-10qzguj"&&(O.innerHTML=yc),Vn=n(e),Qn=r(e,"HR",{}),Sn=n(e),F=r(e,"A",{id:!0,class:!0}),h(F).forEach(l),On=n(e),m(W.$$.fragment,e),Fn=n(e),Y=r(e,"P",{"data-svelte-h":!0}),d(Y)!=="svelte-1iaptgl"&&(Y.textContent=bc),Wn=n(e),G=r(e,"P",{"data-svelte-h":!0}),d(G)!=="svelte-10qzguj"&&(G.innerHTML=Mc),Yn=n(e),Gn=r(e,"HR",{}),Xn=n(e),X=r(e,"A",{id:!0,class:!0}),h(X).forEach(l),Zn=n(e),m(Z.$$.fragment,e),ei=n(e),ee=r(e,"P",{"data-svelte-h":!0}),d(ee)!=="svelte-1adn56z"&&(ee.textContent=xc),ti=n(e),te=r(e,"P",{"data-svelte-h":!0}),d(te)!=="svelte-1gxgvk6"&&(te.innerHTML=Cc),li=n(e),oi=r(e,"HR",{}),si=n(e),le=r(e,"A",{id:!0,class:!0}),h(le).forEach(l),ni=n(e),m(oe.$$.fragment,e),ii=n(e),se=r(e,"P",{"data-svelte-h":!0}),d(se)!=="svelte-1u97xg1"&&(se.textContent=Hc),ri=n(e),ne=r(e,"P",{"data-svelte-h":!0}),d(ne)!=="svelte-1afa2dz"&&(ne.innerHTML=Lc),di=n(e),ie=r(e,"TABLE",{"data-svelte-h":!0}),d(ie)!=="svelte-1kq04ga"&&(ie.innerHTML=wc),ui=n(e),ai=r(e,"HR",{}),mi=n(e),re=r(e,"A",{id:!0,class:!0}),h(re).forEach(l),pi=n(e),m(de.$$.fragment,e),ci=n(e),ue=r(e,"P",{"data-svelte-h":!0}),d(ue)!=="svelte-1cg22af"&&(ue.innerHTML=Ac),fi=n(e),ae=r(e,"TABLE",{"data-svelte-h":!0}),d(ae)!=="svelte-1hful42"&&(ae.innerHTML=gc),Ti=n(e),hi=r(e,"HR",{}),_i=n(e),me=r(e,"A",{id:!0,class:!0}),h(me).forEach(l),$i=n(e),m(pe.$$.fragment,e),vi=n(e),ce=r(e,"P",{"data-svelte-h":!0}),d(ce)!=="svelte-1mr58c3"&&(ce.innerHTML=zc),yi=n(e),fe=r(e,"TABLE",{"data-svelte-h":!0}),d(fe)!=="svelte-153ftfy"&&(fe.innerHTML=Pc),bi=n(e),Mi=r(e,"HR",{}),xi=n(e),Te=r(e,"A",{id:!0,class:!0}),h(Te).forEach(l),Ci=n(e),m(he.$$.fragment,e),Hi=n(e),_e=r(e,"P",{"data-svelte-h":!0}),d(_e)!=="svelte-13nzfs3"&&(_e.innerHTML=Rc),Li=n(e),$e=r(e,"P",{"data-svelte-h":!0}),d($e)!=="svelte-11rv1mu"&&($e.innerHTML=Uc),wi=n(e),ve=r(e,"UL",{"data-svelte-h":!0}),d(ve)!=="svelte-5t2sg3"&&(ve.innerHTML=Ec),Ai=n(e),gi=r(e,"HR",{}),zi=n(e),ye=r(e,"A",{id:!0,class:!0}),h(ye).forEach(l),Pi=n(e),m(be.$$.fragment,e),Ri=n(e),Me=r(e,"P",{"data-svelte-h":!0}),d(Me)!=="svelte-87xdyr"&&(Me.textContent=kc),Ui=n(e),xe=r(e,"P",{"data-svelte-h":!0}),d(xe)!=="svelte-1mr58c3"&&(xe.innerHTML=jc),Ei=n(e),ki=r(e,"HR",{}),ji=n(e),Ce=r(e,"A",{id:!0,class:!0}),h(Ce).forEach(l),Ji=n(e),m(He.$$.fragment,e),Di=n(e),Le=r(e,"P",{"data-svelte-h":!0}),d(Le)!=="svelte-2wti2w"&&(Le.textContent=Jc),qi=n(e),we=r(e,"P",{"data-svelte-h":!0}),d(we)!=="svelte-kpq7mo"&&(we.innerHTML=Dc),Ii=n(e),Ki=r(e,"HR",{}),Bi=n(e),Ae=r(e,"A",{id:!0,class:!0}),h(Ae).forEach(l),Ni=n(e),m(ge.$$.fragment,e),Vi=n(e),ze=r(e,"P",{"data-svelte-h":!0}),d(ze)!=="svelte-1edu6c8"&&(ze.textContent=qc),Qi=n(e),Pe=r(e,"P",{"data-svelte-h":!0}),d(Pe)!=="svelte-1hc4oxa"&&(Pe.innerHTML=Ic),Si=n(e),Oi=r(e,"HR",{}),Fi=n(e),Re=r(e,"A",{id:!0,class:!0}),h(Re).forEach(l),Wi=n(e),m(Ue.$$.fragment,e),Yi=n(e),Ee=r(e,"P",{"data-svelte-h":!0}),d(Ee)!=="svelte-xg80lg"&&(Ee.textContent=Kc),Gi=n(e),ke=r(e,"P",{"data-svelte-h":!0}),d(ke)!=="svelte-1aygav2"&&(ke.innerHTML=Bc),Xi=n(e),je=r(e,"TABLE",{"data-svelte-h":!0}),d(je)!=="svelte-1tbtmqd"&&(je.innerHTML=Nc),Zi=n(e),er=r(e,"HR",{}),tr=n(e),Je=r(e,"A",{id:!0,class:!0}),h(Je).forEach(l),lr=n(e),m(De.$$.fragment,e),or=n(e),qe=r(e,"P",{"data-svelte-h":!0}),d(qe)!=="svelte-1i12x1s"&&(qe.textContent=Vc),sr=n(e),Ie=r(e,"P",{"data-svelte-h":!0}),d(Ie)!=="svelte-1hc4oxa"&&(Ie.innerHTML=Qc),nr=n(e),Ke=r(e,"TABLE",{"data-svelte-h":!0}),d(Ke)!=="svelte-1tbtmqd"&&(Ke.innerHTML=Sc),ir=n(e),rr=r(e,"HR",{}),dr=n(e),Be=r(e,"A",{id:!0,class:!0}),h(Be).forEach(l),ur=n(e),m(Ne.$$.fragment,e),ar=n(e),Ve=r(e,"P",{"data-svelte-h":!0}),d(Ve)!=="svelte-45kvaw"&&(Ve.textContent=Oc),mr=n(e),Qe=r(e,"P",{"data-svelte-h":!0}),d(Qe)!=="svelte-1aygav2"&&(Qe.innerHTML=Fc),pr=n(e),Se=r(e,"TABLE",{"data-svelte-h":!0}),d(Se)!=="svelte-46t58i"&&(Se.innerHTML=Wc),cr=n(e),fr=r(e,"HR",{}),Tr=n(e),Oe=r(e,"A",{id:!0,class:!0}),h(Oe).forEach(l),hr=n(e),m(Fe.$$.fragment,e),_r=n(e),We=r(e,"P",{"data-svelte-h":!0}),d(We)!=="svelte-6s524n"&&(We.textContent=Yc),$r=n(e),Ye=r(e,"P",{"data-svelte-h":!0}),d(Ye)!=="svelte-1hc4oxa"&&(Ye.innerHTML=Gc),vr=n(e),Ge=r(e,"TABLE",{"data-svelte-h":!0}),d(Ge)!=="svelte-46t58i"&&(Ge.innerHTML=Xc),yr=n(e),br=r(e,"HR",{}),Mr=n(e),Xe=r(e,"A",{id:!0,class:!0}),h(Xe).forEach(l),xr=n(e),m(Ze.$$.fragment,e),Cr=n(e),et=r(e,"P",{"data-svelte-h":!0}),d(et)!=="svelte-1hl64jn"&&(et.textContent=Zc),Hr=n(e),tt=r(e,"P",{"data-svelte-h":!0}),d(tt)!=="svelte-1aygav2"&&(tt.innerHTML=ef),Lr=n(e),lt=r(e,"TABLE",{"data-svelte-h":!0}),d(lt)!=="svelte-1p5444"&&(lt.innerHTML=tf),wr=n(e),Ar=r(e,"HR",{}),gr=n(e),ot=r(e,"A",{id:!0,class:!0}),h(ot).forEach(l),zr=n(e),m(st.$$.fragment,e),Pr=n(e),nt=r(e,"P",{"data-svelte-h":!0}),d(nt)!=="svelte-bbf4x3"&&(nt.textContent=lf),Rr=n(e),it=r(e,"P",{"data-svelte-h":!0}),d(it)!=="svelte-1hc4oxa"&&(it.innerHTML=of),Ur=n(e),rt=r(e,"TABLE",{"data-svelte-h":!0}),d(rt)!=="svelte-1p5444"&&(rt.innerHTML=sf),Er=n(e),kr=r(e,"HR",{}),jr=n(e),dt=r(e,"A",{id:!0,class:!0}),h(dt).forEach(l),Jr=n(e),m(ut.$$.fragment,e),Dr=n(e),at=r(e,"P",{"data-svelte-h":!0}),d(at)!=="svelte-1g8ouql"&&(at.textContent=nf),qr=n(e),mt=r(e,"P",{"data-svelte-h":!0}),d(mt)!=="svelte-1scc4l4"&&(mt.innerHTML=rf),Ir=n(e),pt=r(e,"TABLE",{"data-svelte-h":!0}),d(pt)!=="svelte-1p49qvp"&&(pt.innerHTML=df),Kr=n(e),Br=r(e,"HR",{}),Nr=n(e),ct=r(e,"A",{id:!0,class:!0}),h(ct).forEach(l),Vr=n(e),m(ft.$$.fragment,e),Qr=n(e),Tt=r(e,"P",{"data-svelte-h":!0}),d(Tt)!=="svelte-yjryb1"&&(Tt.textContent=uf),Sr=n(e),ht=r(e,"P",{"data-svelte-h":!0}),d(ht)!=="svelte-xtr8tc"&&(ht.innerHTML=af),Or=n(e),_t=r(e,"TABLE",{"data-svelte-h":!0}),d(_t)!=="svelte-6xvdso"&&(_t.innerHTML=mf),Fr=n(e),Wr=r(e,"HR",{}),Yr=n(e),$t=r(e,"A",{id:!0,class:!0}),h($t).forEach(l),Gr=n(e),m(vt.$$.fragment,e),Xr=n(e),yt=r(e,"P",{"data-svelte-h":!0}),d(yt)!=="svelte-1okfsqx"&&(yt.textContent=pf),Zr=n(e),bt=r(e,"P",{"data-svelte-h":!0}),d(bt)!=="svelte-1t556pk"&&(bt.innerHTML=cf),ed=n(e),Mt=r(e,"TABLE",{"data-svelte-h":!0}),d(Mt)!=="svelte-13m2wni"&&(Mt.innerHTML=ff),td=n(e),ld=r(e,"HR",{}),od=n(e),xt=r(e,"A",{id:!0,class:!0}),h(xt).forEach(l),sd=n(e),m(Ct.$$.fragment,e),nd=n(e),Ht=r(e,"P",{"data-svelte-h":!0}),d(Ht)!=="svelte-1htpbrk"&&(Ht.innerHTML=Tf),id=n(e),Lt=r(e,"P",{"data-svelte-h":!0}),d(Lt)!=="svelte-1t0m8l6"&&(Lt.innerHTML=hf),rd=n(e),wt=r(e,"TABLE",{"data-svelte-h":!0}),d(wt)!=="svelte-1qi99pl"&&(wt.innerHTML=_f),dd=n(e),ud=r(e,"HR",{}),ad=n(e),At=r(e,"A",{id:!0,class:!0}),h(At).forEach(l),md=n(e),m(gt.$$.fragment,e),pd=n(e),zt=r(e,"P",{"data-svelte-h":!0}),d(zt)!=="svelte-1ztgqp"&&(zt.innerHTML=$f),cd=n(e),Pt=r(e,"P",{"data-svelte-h":!0}),d(Pt)!=="svelte-mvb39p"&&(Pt.innerHTML=vf),fd=n(e),Rt=r(e,"TABLE",{"data-svelte-h":!0}),d(Rt)!=="svelte-1qi99pl"&&(Rt.innerHTML=yf),Td=n(e),hd=r(e,"HR",{}),_d=n(e),Ut=r(e,"A",{id:!0,class:!0}),h(Ut).forEach(l),$d=n(e),m(Et.$$.fragment,e),vd=n(e),kt=r(e,"P",{"data-svelte-h":!0}),d(kt)!=="svelte-1a7u185"&&(kt.textContent=bf),yd=n(e),jt=r(e,"P",{"data-svelte-h":!0}),d(jt)!=="svelte-1eu3doh"&&(jt.innerHTML=Mf),bd=n(e),Md=r(e,"HR",{}),xd=n(e),Jt=r(e,"A",{id:!0,class:!0}),h(Jt).forEach(l),Cd=n(e),m(Dt.$$.fragment,e),Hd=n(e),qt=r(e,"P",{"data-svelte-h":!0}),d(qt)!=="svelte-qls17b"&&(qt.textContent=xf),Ld=n(e),It=r(e,"P",{"data-svelte-h":!0}),d(It)!=="svelte-5nabmy"&&(It.innerHTML=Cf),wd=n(e),Kt=r(e,"P",{"data-svelte-h":!0}),d(Kt)!=="svelte-muvb5c"&&(Kt.innerHTML=Hf),Ad=n(e),Bt=r(e,"TABLE",{"data-svelte-h":!0}),d(Bt)!=="svelte-52pnzr"&&(Bt.innerHTML=Lf),gd=n(e),zd=r(e,"HR",{}),Pd=n(e),Nt=r(e,"A",{id:!0,class:!0}),h(Nt).forEach(l),Rd=n(e),m(Vt.$$.fragment,e),Ud=n(e),Qt=r(e,"P",{"data-svelte-h":!0}),d(Qt)!=="svelte-19w0pic"&&(Qt.innerHTML=wf),Ed=n(e),St=r(e,"P",{"data-svelte-h":!0}),d(St)!=="svelte-1mr58c3"&&(St.innerHTML=Af),kd=n(e),jd=r(e,"HR",{}),Jd=n(e),Ot=r(e,"A",{id:!0,class:!0}),h(Ot).forEach(l),Dd=n(e),m(Ft.$$.fragment,e),qd=n(e),Wt=r(e,"P",{"data-svelte-h":!0}),d(Wt)!=="svelte-18ws76n"&&(Wt.textContent=gf),Id=n(e),Yt=r(e,"P",{"data-svelte-h":!0}),d(Yt)!=="svelte-1tnr5gm"&&(Yt.textContent=zf),Kd=n(e),Gt=r(e,"P",{"data-svelte-h":!0}),d(Gt)!=="svelte-1si6y4t"&&(Gt.innerHTML=Pf),Bd=n(e),Xt=r(e,"TABLE",{"data-svelte-h":!0}),d(Xt)!=="svelte-1u9lyxp"&&(Xt.innerHTML=Rf),Nd=n(e),Vd=r(e,"HR",{}),Qd=n(e),Zt=r(e,"A",{id:!0,class:!0}),h(Zt).forEach(l),Sd=n(e),m(el.$$.fragment,e),Od=n(e),tl=r(e,"P",{"data-svelte-h":!0}),d(tl)!=="svelte-1b9ygao"&&(tl.innerHTML=Uf),Fd=n(e),ll=r(e,"P",{"data-svelte-h":!0}),d(ll)!=="svelte-1mr58c3"&&(ll.innerHTML=Ef),Wd=n(e),Yd=r(e,"HR",{}),Gd=n(e),ol=r(e,"A",{id:!0,class:!0}),h(ol).forEach(l),Xd=n(e),m(sl.$$.fragment,e),Zd=n(e),nl=r(e,"P",{"data-svelte-h":!0}),d(nl)!=="svelte-1vkr5xo"&&(nl.innerHTML=kf),eu=n(e),il=r(e,"P",{"data-svelte-h":!0}),d(il)!=="svelte-1mr58c3"&&(il.innerHTML=jf),tu=n(e),lu=r(e,"HR",{}),ou=n(e),rl=r(e,"A",{id:!0,class:!0}),h(rl).forEach(l),su=n(e),m(dl.$$.fragment,e),nu=n(e),ul=r(e,"P",{"data-svelte-h":!0}),d(ul)!=="svelte-1gguudf"&&(ul.innerHTML=Jf),iu=n(e),al=r(e,"P",{"data-svelte-h":!0}),d(al)!=="svelte-6vkfxj"&&(al.innerHTML=Df),ru=n(e),ml=r(e,"TABLE",{"data-svelte-h":!0}),d(ml)!=="svelte-z6whez"&&(ml.innerHTML=qf),du=n(e),uu=r(e,"HR",{}),au=n(e),pl=r(e,"A",{id:!0,class:!0}),h(pl).forEach(l),mu=n(e),m(cl.$$.fragment,e),pu=n(e),fl=r(e,"P",{"data-svelte-h":!0}),d(fl)!=="svelte-d6gvut"&&(fl.innerHTML=If),cu=n(e),Tl=r(e,"P",{"data-svelte-h":!0}),d(Tl)!=="svelte-18n9ux4"&&(Tl.innerHTML=Kf),fu=n(e),hl=r(e,"TABLE",{"data-svelte-h":!0}),d(hl)!=="svelte-jj58dd"&&(hl.innerHTML=Bf),Tu=n(e),hu=r(e,"HR",{}),_u=n(e),_l=r(e,"A",{id:!0,class:!0}),h(_l).forEach(l),$u=n(e),m($l.$$.fragment,e),vu=n(e),vl=r(e,"P",{"data-svelte-h":!0}),d(vl)!=="svelte-1adolpg"&&(vl.innerHTML=Nf),yu=n(e),yl=r(e,"P",{"data-svelte-h":!0}),d(yl)!=="svelte-1mr58c3"&&(yl.innerHTML=Vf),bu=n(e),Mu=r(e,"HR",{}),xu=n(e),bl=r(e,"A",{id:!0,class:!0}),h(bl).forEach(l),Cu=n(e),m(Ml.$$.fragment,e),Hu=n(e),xl=r(e,"P",{"data-svelte-h":!0}),d(xl)!=="svelte-1hm8vtj"&&(xl.textContent=Qf),Lu=n(e),Cl=r(e,"P",{"data-svelte-h":!0}),d(Cl)!=="svelte-1ywpke5"&&(Cl.innerHTML=Sf),wu=n(e),Hl=r(e,"TABLE",{"data-svelte-h":!0}),d(Hl)!=="svelte-9ff0sy"&&(Hl.innerHTML=Of),Au=n(e),gu=r(e,"HR",{}),zu=n(e),Ll=r(e,"A",{id:!0,class:!0}),h(Ll).forEach(l),Pu=n(e),m(wl.$$.fragment,e),Ru=n(e),Al=r(e,"P",{"data-svelte-h":!0}),d(Al)!=="svelte-1e6kzks"&&(Al.innerHTML=Ff),Uu=n(e),gl=r(e,"P",{"data-svelte-h":!0}),d(gl)!=="svelte-1mr58c3"&&(gl.innerHTML=Wf),Eu=n(e),ku=r(e,"HR",{}),ju=n(e),zl=r(e,"A",{id:!0,class:!0}),h(zl).forEach(l),Ju=n(e),m(Pl.$$.fragment,e),Du=n(e),Rl=r(e,"P",{"data-svelte-h":!0}),d(Rl)!=="svelte-t5k6jp"&&(Rl.textContent=Yf),qu=n(e),Ul=r(e,"P",{"data-svelte-h":!0}),d(Ul)!=="svelte-1ywpke5"&&(Ul.innerHTML=Gf),Iu=n(e),Ku=r(e,"HR",{}),Bu=n(e),El=r(e,"A",{id:!0,class:!0}),h(El).forEach(l),Nu=n(e),m(kl.$$.fragment,e),Vu=n(e),jl=r(e,"P",{"data-svelte-h":!0}),d(jl)!=="svelte-avw2a1"&&(jl.textContent=Xf),Qu=n(e),Jl=r(e,"P",{"data-svelte-h":!0}),d(Jl)!=="svelte-16q99cu"&&(Jl.innerHTML=Zf),Su=n(e),Dl=r(e,"TABLE",{"data-svelte-h":!0}),d(Dl)!=="svelte-jj5vaa"&&(Dl.innerHTML=eT),Ou=n(e),Fu=r(e,"HR",{}),Wu=n(e),ql=r(e,"A",{id:!0,class:!0}),h(ql).forEach(l),Yu=n(e),m(Il.$$.fragment,e),Gu=n(e),Kl=r(e,"P",{"data-svelte-h":!0}),d(Kl)!=="svelte-167n5bd"&&(Kl.textContent=tT),Xu=n(e),Bl=r(e,"P",{"data-svelte-h":!0}),d(Bl)!=="svelte-1pz529g"&&(Bl.innerHTML=lT),Zu=n(e),Nl=r(e,"TABLE",{"data-svelte-h":!0}),d(Nl)!=="svelte-1oyadc3"&&(Nl.innerHTML=oT),ea=n(e),ta=r(e,"HR",{}),la=n(e),Vl=r(e,"A",{id:!0,class:!0}),h(Vl).forEach(l),oa=n(e),m(Ql.$$.fragment,e),sa=n(e),Sl=r(e,"P",{"data-svelte-h":!0}),d(Sl)!=="svelte-fju8tm"&&(Sl.textContent=sT),na=n(e),Ol=r(e,"P",{"data-svelte-h":!0}),d(Ol)!=="svelte-13s6o0v"&&(Ol.innerHTML=nT),ia=n(e),Fl=r(e,"TABLE",{"data-svelte-h":!0}),d(Fl)!=="svelte-8i278m"&&(Fl.innerHTML=iT),ra=n(e),da=r(e,"HR",{}),ua=n(e),Wl=r(e,"A",{id:!0,class:!0}),h(Wl).forEach(l),aa=n(e),m(Yl.$$.fragment,e),ma=n(e),Gl=r(e,"P",{"data-svelte-h":!0}),d(Gl)!=="svelte-18v04la"&&(Gl.innerHTML=rT),pa=n(e),Xl=r(e,"P",{"data-svelte-h":!0}),d(Xl)!=="svelte-16ws0dc"&&(Xl.innerHTML=dT),ca=n(e),Zl=r(e,"TABLE",{"data-svelte-h":!0}),d(Zl)!=="svelte-14k2n4x"&&(Zl.innerHTML=uT),fa=n(e),Ta=r(e,"HR",{}),ha=n(e),eo=r(e,"A",{id:!0,class:!0}),h(eo).forEach(l),_a=n(e),m(to.$$.fragment,e),$a=n(e),lo=r(e,"P",{"data-svelte-h":!0}),d(lo)!=="svelte-1yvow13"&&(lo.innerHTML=aT),va=n(e),oo=r(e,"P",{"data-svelte-h":!0}),d(oo)!=="svelte-13n2k7m"&&(oo.innerHTML=mT),ya=n(e),so=r(e,"TABLE",{"data-svelte-h":!0}),d(so)!=="svelte-1ha3siw"&&(so.innerHTML=pT),ba=n(e),Ma=r(e,"HR",{}),xa=n(e),no=r(e,"A",{id:!0,class:!0}),h(no).forEach(l),Ca=n(e),m(io.$$.fragment,e),Ha=n(e),ro=r(e,"P",{"data-svelte-h":!0}),d(ro)!=="svelte-19dtamh"&&(ro.innerHTML=cT),La=n(e),uo=r(e,"P",{"data-svelte-h":!0}),d(uo)!=="svelte-1nr5iz8"&&(uo.innerHTML=fT),wa=n(e),ao=r(e,"TABLE",{"data-svelte-h":!0}),d(ao)!=="svelte-1hw4pq9"&&(ao.innerHTML=TT),Aa=n(e),ga=r(e,"HR",{}),za=n(e),mo=r(e,"A",{id:!0,class:!0}),h(mo).forEach(l),Pa=n(e),m(po.$$.fragment,e),Ra=n(e),co=r(e,"P",{"data-svelte-h":!0}),d(co)!=="svelte-bd7moq"&&(co.innerHTML=hT),Ua=n(e),fo=r(e,"P",{"data-svelte-h":!0}),d(fo)!=="svelte-jyg3bg"&&(fo.innerHTML=_T),Ea=n(e),To=r(e,"TABLE",{"data-svelte-h":!0}),d(To)!=="svelte-1sdadnq"&&(To.innerHTML=$T),ka=n(e),ja=r(e,"HR",{}),Ja=n(e),ho=r(e,"A",{id:!0,class:!0}),h(ho).forEach(l),Da=n(e),m(_o.$$.fragment,e),qa=n(e),$o=r(e,"P",{"data-svelte-h":!0}),d($o)!=="svelte-11ei68w"&&($o.textContent=vT),Ia=n(e),vo=r(e,"P",{"data-svelte-h":!0}),d(vo)!=="svelte-1p3llh"&&(vo.innerHTML=yT),Ka=n(e),yo=r(e,"TABLE",{"data-svelte-h":!0}),d(yo)!=="svelte-1xe0vb8"&&(yo.innerHTML=bT),Ba=n(e),Na=r(e,"HR",{}),Va=n(e),bo=r(e,"A",{id:!0,class:!0}),h(bo).forEach(l),Qa=n(e),m(Mo.$$.fragment,e),Sa=n(e),xo=r(e,"P",{"data-svelte-h":!0}),d(xo)!=="svelte-7ivim4"&&(xo.textContent=MT),Oa=n(e),Co=r(e,"P",{"data-svelte-h":!0}),d(Co)!=="svelte-151n4qz"&&(Co.innerHTML=xT),Fa=n(e),Ho=r(e,"TABLE",{"data-svelte-h":!0}),d(Ho)!=="svelte-iprxta"&&(Ho.innerHTML=CT),Wa=n(e),Ya=r(e,"HR",{}),Ga=n(e),Lo=r(e,"A",{id:!0,class:!0}),h(Lo).forEach(l),Xa=n(e),m(wo.$$.fragment,e),Za=n(e),Ao=r(e,"P",{"data-svelte-h":!0}),d(Ao)!=="svelte-k6p1db"&&(Ao.textContent=HT),em=n(e),go=r(e,"P",{"data-svelte-h":!0}),d(go)!=="svelte-1o30xnd"&&(go.innerHTML=LT),tm=n(e),zo=r(e,"TABLE",{"data-svelte-h":!0}),d(zo)!=="svelte-101obk2"&&(zo.innerHTML=wT),lm=n(e),om=r(e,"HR",{}),sm=n(e),Po=r(e,"A",{id:!0,class:!0}),h(Po).forEach(l),nm=n(e),m(Ro.$$.fragment,e),im=n(e),Uo=r(e,"P",{"data-svelte-h":!0}),d(Uo)!=="svelte-8afo9v"&&(Uo.textContent=AT),rm=n(e),Eo=r(e,"P",{"data-svelte-h":!0}),d(Eo)!=="svelte-1vvmhgz"&&(Eo.innerHTML=gT),dm=n(e),ko=r(e,"TABLE",{"data-svelte-h":!0}),d(ko)!=="svelte-wz2jkw"&&(ko.innerHTML=zT),um=n(e),am=r(e,"HR",{}),mm=n(e),jo=r(e,"A",{id:!0,class:!0}),h(jo).forEach(l),pm=n(e),m(Jo.$$.fragment,e),cm=n(e),Do=r(e,"P",{"data-svelte-h":!0}),d(Do)!=="svelte-11plveb"&&(Do.innerHTML=PT),fm=n(e),qo=r(e,"P",{"data-svelte-h":!0}),d(qo)!=="svelte-1wu8g4g"&&(qo.innerHTML=RT),Tm=n(e),Io=r(e,"TABLE",{"data-svelte-h":!0}),d(Io)!=="svelte-1vsvca3"&&(Io.innerHTML=UT),hm=n(e),_m=r(e,"HR",{}),$m=n(e),Ko=r(e,"A",{id:!0,class:!0}),h(Ko).forEach(l),vm=n(e),m(Bo.$$.fragment,e),ym=n(e),No=r(e,"P",{"data-svelte-h":!0}),d(No)!=="svelte-17f4oxi"&&(No.textContent=ET),bm=n(e),Vo=r(e,"P",{"data-svelte-h":!0}),d(Vo)!=="svelte-2yq8vx"&&(Vo.innerHTML=kT),Mm=n(e),Qo=r(e,"TABLE",{"data-svelte-h":!0}),d(Qo)!=="svelte-m4z8c4"&&(Qo.innerHTML=jT),xm=n(e),Cm=r(e,"HR",{}),Hm=n(e),So=r(e,"A",{id:!0,class:!0}),h(So).forEach(l),Lm=n(e),m(Oo.$$.fragment,e),wm=n(e),Fo=r(e,"P",{"data-svelte-h":!0}),d(Fo)!=="svelte-kcewlk"&&(Fo.textContent=JT),Am=n(e),Wo=r(e,"P",{"data-svelte-h":!0}),d(Wo)!=="svelte-17f480h"&&(Wo.innerHTML=DT),gm=n(e),Yo=r(e,"TABLE",{"data-svelte-h":!0}),d(Yo)!=="svelte-1to7jw8"&&(Yo.innerHTML=qT),zm=n(e),Pm=r(e,"HR",{}),Rm=n(e),Go=r(e,"A",{id:!0,class:!0}),h(Go).forEach(l),Um=n(e),m(Xo.$$.fragment,e),Em=n(e),Zo=r(e,"P",{"data-svelte-h":!0}),d(Zo)!=="svelte-10qu7f7"&&(Zo.textContent=IT),km=n(e),es=r(e,"P",{"data-svelte-h":!0}),d(es)!=="svelte-14iug9a"&&(es.innerHTML=KT),jm=n(e),ts=r(e,"TABLE",{"data-svelte-h":!0}),d(ts)!=="svelte-stphn2"&&(ts.innerHTML=BT),Jm=n(e),Dm=r(e,"HR",{}),qm=n(e),ls=r(e,"A",{id:!0,class:!0}),h(ls).forEach(l),Im=n(e),m(os.$$.fragment,e),Km=n(e),ss=r(e,"P",{"data-svelte-h":!0}),d(ss)!=="svelte-1ayje0f"&&(ss.textContent=NT),Bm=n(e),ns=r(e,"P",{"data-svelte-h":!0}),d(ns)!=="svelte-1ywifoz"&&(ns.innerHTML=VT),Nm=n(e),is=r(e,"TABLE",{"data-svelte-h":!0}),d(is)!=="svelte-gyxne1"&&(is.innerHTML=QT),Vm=n(e),Qm=r(e,"HR",{}),Sm=n(e),rs=r(e,"A",{id:!0,class:!0}),h(rs).forEach(l),Om=n(e),m(ds.$$.fragment,e),Fm=n(e),us=r(e,"P",{"data-svelte-h":!0}),d(us)!=="svelte-1wvb8sq"&&(us.textContent=ST),Wm=n(e),as=r(e,"P",{"data-svelte-h":!0}),d(as)!=="svelte-1ywifoz"&&(as.innerHTML=OT),Ym=n(e),ms=r(e,"TABLE",{"data-svelte-h":!0}),d(ms)!=="svelte-1fk5fng"&&(ms.innerHTML=FT),Gm=n(e),Xm=r(e,"HR",{}),Zm=n(e),ps=r(e,"A",{id:!0,class:!0}),h(ps).forEach(l),ep=n(e),m(cs.$$.fragment,e),tp=n(e),fs=r(e,"P",{"data-svelte-h":!0}),d(fs)!=="svelte-1798kaw"&&(fs.textContent=WT),lp=n(e),Ts=r(e,"P",{"data-svelte-h":!0}),d(Ts)!=="svelte-11aypax"&&(Ts.innerHTML=YT),op=n(e),hs=r(e,"TABLE",{"data-svelte-h":!0}),d(hs)!=="svelte-gyxne1"&&(hs.innerHTML=GT),sp=n(e),np=r(e,"HR",{}),ip=n(e),_s=r(e,"A",{id:!0,class:!0}),h(_s).forEach(l),rp=n(e),m($s.$$.fragment,e),dp=n(e),vs=r(e,"P",{"data-svelte-h":!0}),d(vs)!=="svelte-9nnpip"&&(vs.textContent=XT),up=n(e),ys=r(e,"P",{"data-svelte-h":!0}),d(ys)!=="svelte-11aypax"&&(ys.innerHTML=ZT),ap=n(e),bs=r(e,"TABLE",{"data-svelte-h":!0}),d(bs)!=="svelte-1fk5fng"&&(bs.innerHTML=eh),mp=n(e),pp=r(e,"HR",{}),cp=n(e),Ms=r(e,"A",{id:!0,class:!0}),h(Ms).forEach(l),fp=n(e),m(xs.$$.fragment,e),Tp=n(e),Cs=r(e,"P",{"data-svelte-h":!0}),d(Cs)!=="svelte-185sm1b"&&(Cs.textContent=th),hp=n(e),Hs=r(e,"P",{"data-svelte-h":!0}),d(Hs)!=="svelte-1y8qzzr"&&(Hs.innerHTML=lh),_p=n(e),Ls=r(e,"TABLE",{"data-svelte-h":!0}),d(Ls)!=="svelte-1v01t7k"&&(Ls.innerHTML=oh),$p=n(e),vp=r(e,"HR",{}),yp=n(e),ws=r(e,"A",{id:!0,class:!0}),h(ws).forEach(l),bp=n(e),m(As.$$.fragment,e),Mp=n(e),gs=r(e,"P",{"data-svelte-h":!0}),d(gs)!=="svelte-12loz97"&&(gs.innerHTML=sh),xp=n(e),Cp=r(e,"HR",{}),Hp=n(e),zs=r(e,"A",{id:!0,class:!0}),h(zs).forEach(l),Lp=n(e),m(Ps.$$.fragment,e),wp=n(e),Rs=r(e,"P",{"data-svelte-h":!0}),d(Rs)!=="svelte-40isdg"&&(Rs.textContent=nh),Ap=n(e),Us=r(e,"P",{"data-svelte-h":!0}),d(Us)!=="svelte-tlsa2h"&&(Us.innerHTML=ih),gp=n(e),Es=r(e,"TABLE",{"data-svelte-h":!0}),d(Es)!=="svelte-17343p6"&&(Es.innerHTML=rh),zp=n(e),ks=r(e,"P",{"data-svelte-h":!0}),d(ks)!=="svelte-1aswmub"&&(ks.innerHTML=dh),Pp=n(e),m(js.$$.fragment,e),Rp=n(e),Up=r(e,"HR",{}),Ep=n(e),Js=r(e,"A",{id:!0,class:!0}),h(Js).forEach(l),kp=n(e),m(Ds.$$.fragment,e),jp=n(e),qs=r(e,"P",{"data-svelte-h":!0}),d(qs)!=="svelte-kp31r8"&&(qs.innerHTML=uh),Jp=n(e),Dp=r(e,"HR",{}),qp=n(e),Is=r(e,"A",{id:!0,class:!0}),h(Is).forEach(l),Ip=n(e),m(Ks.$$.fragment,e),Kp=n(e),Bs=r(e,"P",{"data-svelte-h":!0}),d(Bs)!=="svelte-1fs9no9"&&(Bs.innerHTML=ah),Bp=n(e),Np=r(e,"HR",{}),Vp=n(e),Ns=r(e,"A",{id:!0,class:!0}),h(Ns).forEach(l),Qp=n(e),m(Vs.$$.fragment,e),Sp=n(e),Qs=r(e,"P",{"data-svelte-h":!0}),d(Qs)!=="svelte-2mif9c"&&(Qs.textContent=mh),Op=n(e),Ss=r(e,"P",{"data-svelte-h":!0}),d(Ss)!=="svelte-1jas2kw"&&(Ss.innerHTML=ph),Fp=n(e),m(Os.$$.fragment,e),Wp=n(e),Fs=r(e,"P",{"data-svelte-h":!0}),d(Fs)!=="svelte-1aswmub"&&(Fs.innerHTML=ch),Yp=n(e),m(Ws.$$.fragment,e),Gp=n(e),Ys=r(e,"P",{"data-svelte-h":!0}),d(Ys)!=="svelte-1aswmub"&&(Ys.innerHTML=fh),Xp=n(e),m(Gs.$$.fragment,e),Zp=n(e),ec=r(e,"HR",{}),tc=n(e),m(Xs.$$.fragment,e),lc=n(e),en=r(e,"P",{}),h(en).forEach(l),this.h()},h(){u($,"name","hf:doc:metadata"),u($,"content",Ch),u(v,"id","module_utils/tensor"),u(v,"class","group"),u(C,"id","module_utils/tensor.Tensor"),u(C,"class","group"),u(A,"id","new_module_utils/tensor.Tensor_new"),u(A,"class","group"),u(R,"id","module_utils/tensor.Tensor+dims"),u(R,"class","group"),u(j,"id","module_utils/tensor.Tensor+type"),u(j,"class","group"),u(I,"id","module_utils/tensor.Tensor+data"),u(I,"class","group"),u(V,"id","module_utils/tensor.Tensor+size"),u(V,"class","group"),u(F,"id","module_utils/tensor.Tensor+location"),u(F,"class","group"),u(X,"id","module_utils/tensor.Tensor+Symbol.iterator"),u(X,"class","group"),u(le,"id","module_utils/tensor.Tensor+_getitem"),u(le,"class","group"),u(re,"id","module_utils/tensor.Tensor+indexOf"),u(re,"class","group"),u(me,"id","module_utils/tensor.Tensor+_subarray"),u(me,"class","group"),u(Te,"id","module_utils/tensor.Tensor+item"),u(Te,"class","group"),u(ye,"id","module_utils/tensor.Tensor+tolist"),u(ye,"class","group"),u(Ce,"id","module_utils/tensor.Tensor+sigmoid"),u(Ce,"class","group"),u(Ae,"id","module_utils/tensor.Tensor+sigmoid_"),u(Ae,"class","group"),u(Re,"id","module_utils/tensor.Tensor+mul"),u(Re,"class","group"),u(Je,"id","module_utils/tensor.Tensor+mul_"),u(Je,"class","group"),u(Be,"id","module_utils/tensor.Tensor+div"),u(Be,"class","group"),u(Oe,"id","module_utils/tensor.Tensor+div_"),u(Oe,"class","group"),u(Xe,"id","module_utils/tensor.Tensor+add"),u(Xe,"class","group"),u(ot,"id","module_utils/tensor.Tensor+add_"),u(ot,"class","group"),u(dt,"id","module_utils/tensor.Tensor+permute"),u(dt,"class","group"),u(ct,"id","module_utils/tensor.Tensor+sum"),u(ct,"class","group"),u($t,"id","module_utils/tensor.Tensor+norm"),u($t,"class","group"),u(xt,"id","module_utils/tensor.Tensor+normalize_"),u(xt,"class","group"),u(At,"id","module_utils/tensor.Tensor+normalize"),u(At,"class","group"),u(Ut,"id","module_utils/tensor.Tensor+stride"),u(Ut,"class","group"),u(Jt,"id","module_utils/tensor.Tensor+squeeze"),u(Jt,"class","group"),u(Nt,"id","module_utils/tensor.Tensor+squeeze_"),u(Nt,"class","group"),u(Ot,"id","module_utils/tensor.Tensor+unsqueeze"),u(Ot,"class","group"),u(Zt,"id","module_utils/tensor.Tensor+unsqueeze_"),u(Zt,"class","group"),u(ol,"id","module_utils/tensor.Tensor+flatten_"),u(ol,"class","group"),u(rl,"id","module_utils/tensor.Tensor+flatten"),u(rl,"class","group"),u(pl,"id","module_utils/tensor.Tensor+view"),u(pl,"class","group"),u(_l,"id","module_utils/tensor.Tensor+clamp_"),u(_l,"class","group"),u(bl,"id","module_utils/tensor.Tensor+clamp"),u(bl,"class","group"),u(Ll,"id","module_utils/tensor.Tensor+round_"),u(Ll,"class","group"),u(zl,"id","module_utils/tensor.Tensor+round"),u(zl,"class","group"),u(El,"id","module_utils/tensor.Tensor+to"),u(El,"class","group"),u(ql,"id","module_utils/tensor.permute"),u(ql,"class","group"),u(Vl,"id","module_utils/tensor.interpolate"),u(Vl,"class","group"),u(Wl,"id","module_utils/tensor.interpolate_4d"),u(Wl,"class","group"),u(eo,"id","module_utils/tensor.matmul"),u(eo,"class","group"),u(no,"id","module_utils/tensor.rfft"),u(no,"class","group"),u(mo,"id","module_utils/tensor.topk"),u(mo,"class","group"),u(ho,"id","module_utils/tensor.mean_pooling"),u(ho,"class","group"),u(bo,"id","module_utils/tensor.layer_norm"),u(bo,"class","group"),u(Lo,"id","module_utils/tensor.cat"),u(Lo,"class","group"),u(Po,"id","module_utils/tensor.stack"),u(Po,"class","group"),u(jo,"id","module_utils/tensor.std_mean"),u(jo,"class","group"),u(Ko,"id","module_utils/tensor.mean"),u(Ko,"class","group"),u(So,"id","module_utils/tensor.dynamicTimeWarping"),u(So,"class","group"),u(Go,"id","module_utils/tensor.full"),u(Go,"class","group"),u(ls,"id","module_utils/tensor.ones"),u(ls,"class","group"),u(rs,"id","module_utils/tensor.ones_like"),u(rs,"class","group"),u(ps,"id","module_utils/tensor.zeros"),u(ps,"class","group"),u(_s,"id","module_utils/tensor.zeros_like"),u(_s,"class","group"),u(Ms,"id","module_utils/tensor.quantize_embeddings"),u(Ms,"class","group"),u(ws,"id","module_utils/tensor..args[0]"),u(ws,"class","group"),u(zs,"id","module_utils/tensor..reshape"),u(zs,"class","group"),u(Js,"id","module_utils/tensor..reshape..reshapedArray"),u(Js,"class","group"),u(Is,"id","module_utils/tensor..DataArray"),u(Is,"class","group"),u(Ns,"id","module_utils/tensor..NestArray"),u(Ns,"class","group")},m(e,t){bh(document.head,$),o(e,tn,t),o(e,Zs,t),o(e,ln,t),o(e,v,t),o(e,on,t),p(y,e,t),o(e,sn,t),o(e,b,t),o(e,nn,t),o(e,M,t),o(e,rn,t),o(e,x,t),o(e,dn,t),o(e,un,t),o(e,an,t),o(e,C,t),o(e,mn,t),p(H,e,t),o(e,pn,t),o(e,L,t),o(e,cn,t),o(e,w,t),o(e,fn,t),o(e,Tn,t),o(e,hn,t),o(e,A,t),o(e,_n,t),p(g,e,t),o(e,$n,t),o(e,z,t),o(e,vn,t),o(e,P,t),o(e,yn,t),o(e,bn,t),o(e,Mn,t),o(e,R,t),o(e,xn,t),p(U,e,t),o(e,Cn,t),o(e,E,t),o(e,Hn,t),o(e,k,t),o(e,Ln,t),o(e,wn,t),o(e,An,t),o(e,j,t),o(e,gn,t),p(J,e,t),o(e,zn,t),o(e,D,t),o(e,Pn,t),o(e,q,t),o(e,Rn,t),o(e,Un,t),o(e,En,t),o(e,I,t),o(e,kn,t),p(K,e,t),o(e,jn,t),o(e,B,t),o(e,Jn,t),o(e,N,t),o(e,Dn,t),o(e,qn,t),o(e,In,t),o(e,V,t),o(e,Kn,t),p(Q,e,t),o(e,Bn,t),o(e,S,t),o(e,Nn,t),o(e,O,t),o(e,Vn,t),o(e,Qn,t),o(e,Sn,t),o(e,F,t),o(e,On,t),p(W,e,t),o(e,Fn,t),o(e,Y,t),o(e,Wn,t),o(e,G,t),o(e,Yn,t),o(e,Gn,t),o(e,Xn,t),o(e,X,t),o(e,Zn,t),p(Z,e,t),o(e,ei,t),o(e,ee,t),o(e,ti,t),o(e,te,t),o(e,li,t),o(e,oi,t),o(e,si,t),o(e,le,t),o(e,ni,t),p(oe,e,t),o(e,ii,t),o(e,se,t),o(e,ri,t),o(e,ne,t),o(e,di,t),o(e,ie,t),o(e,ui,t),o(e,ai,t),o(e,mi,t),o(e,re,t),o(e,pi,t),p(de,e,t),o(e,ci,t),o(e,ue,t),o(e,fi,t),o(e,ae,t),o(e,Ti,t),o(e,hi,t),o(e,_i,t),o(e,me,t),o(e,$i,t),p(pe,e,t),o(e,vi,t),o(e,ce,t),o(e,yi,t),o(e,fe,t),o(e,bi,t),o(e,Mi,t),o(e,xi,t),o(e,Te,t),o(e,Ci,t),p(he,e,t),o(e,Hi,t),o(e,_e,t),o(e,Li,t),o(e,$e,t),o(e,wi,t),o(e,ve,t),o(e,Ai,t),o(e,gi,t),o(e,zi,t),o(e,ye,t),o(e,Pi,t),p(be,e,t),o(e,Ri,t),o(e,Me,t),o(e,Ui,t),o(e,xe,t),o(e,Ei,t),o(e,ki,t),o(e,ji,t),o(e,Ce,t),o(e,Ji,t),p(He,e,t),o(e,Di,t),o(e,Le,t),o(e,qi,t),o(e,we,t),o(e,Ii,t),o(e,Ki,t),o(e,Bi,t),o(e,Ae,t),o(e,Ni,t),p(ge,e,t),o(e,Vi,t),o(e,ze,t),o(e,Qi,t),o(e,Pe,t),o(e,Si,t),o(e,Oi,t),o(e,Fi,t),o(e,Re,t),o(e,Wi,t),p(Ue,e,t),o(e,Yi,t),o(e,Ee,t),o(e,Gi,t),o(e,ke,t),o(e,Xi,t),o(e,je,t),o(e,Zi,t),o(e,er,t),o(e,tr,t),o(e,Je,t),o(e,lr,t),p(De,e,t),o(e,or,t),o(e,qe,t),o(e,sr,t),o(e,Ie,t),o(e,nr,t),o(e,Ke,t),o(e,ir,t),o(e,rr,t),o(e,dr,t),o(e,Be,t),o(e,ur,t),p(Ne,e,t),o(e,ar,t),o(e,Ve,t),o(e,mr,t),o(e,Qe,t),o(e,pr,t),o(e,Se,t),o(e,cr,t),o(e,fr,t),o(e,Tr,t),o(e,Oe,t),o(e,hr,t),p(Fe,e,t),o(e,_r,t),o(e,We,t),o(e,$r,t),o(e,Ye,t),o(e,vr,t),o(e,Ge,t),o(e,yr,t),o(e,br,t),o(e,Mr,t),o(e,Xe,t),o(e,xr,t),p(Ze,e,t),o(e,Cr,t),o(e,et,t),o(e,Hr,t),o(e,tt,t),o(e,Lr,t),o(e,lt,t),o(e,wr,t),o(e,Ar,t),o(e,gr,t),o(e,ot,t),o(e,zr,t),p(st,e,t),o(e,Pr,t),o(e,nt,t),o(e,Rr,t),o(e,it,t),o(e,Ur,t),o(e,rt,t),o(e,Er,t),o(e,kr,t),o(e,jr,t),o(e,dt,t),o(e,Jr,t),p(ut,e,t),o(e,Dr,t),o(e,at,t),o(e,qr,t),o(e,mt,t),o(e,Ir,t),o(e,pt,t),o(e,Kr,t),o(e,Br,t),o(e,Nr,t),o(e,ct,t),o(e,Vr,t),p(ft,e,t),o(e,Qr,t),o(e,Tt,t),o(e,Sr,t),o(e,ht,t),o(e,Or,t),o(e,_t,t),o(e,Fr,t),o(e,Wr,t),o(e,Yr,t),o(e,$t,t),o(e,Gr,t),p(vt,e,t),o(e,Xr,t),o(e,yt,t),o(e,Zr,t),o(e,bt,t),o(e,ed,t),o(e,Mt,t),o(e,td,t),o(e,ld,t),o(e,od,t),o(e,xt,t),o(e,sd,t),p(Ct,e,t),o(e,nd,t),o(e,Ht,t),o(e,id,t),o(e,Lt,t),o(e,rd,t),o(e,wt,t),o(e,dd,t),o(e,ud,t),o(e,ad,t),o(e,At,t),o(e,md,t),p(gt,e,t),o(e,pd,t),o(e,zt,t),o(e,cd,t),o(e,Pt,t),o(e,fd,t),o(e,Rt,t),o(e,Td,t),o(e,hd,t),o(e,_d,t),o(e,Ut,t),o(e,$d,t),p(Et,e,t),o(e,vd,t),o(e,kt,t),o(e,yd,t),o(e,jt,t),o(e,bd,t),o(e,Md,t),o(e,xd,t),o(e,Jt,t),o(e,Cd,t),p(Dt,e,t),o(e,Hd,t),o(e,qt,t),o(e,Ld,t),o(e,It,t),o(e,wd,t),o(e,Kt,t),o(e,Ad,t),o(e,Bt,t),o(e,gd,t),o(e,zd,t),o(e,Pd,t),o(e,Nt,t),o(e,Rd,t),p(Vt,e,t),o(e,Ud,t),o(e,Qt,t),o(e,Ed,t),o(e,St,t),o(e,kd,t),o(e,jd,t),o(e,Jd,t),o(e,Ot,t),o(e,Dd,t),p(Ft,e,t),o(e,qd,t),o(e,Wt,t),o(e,Id,t),o(e,Yt,t),o(e,Kd,t),o(e,Gt,t),o(e,Bd,t),o(e,Xt,t),o(e,Nd,t),o(e,Vd,t),o(e,Qd,t),o(e,Zt,t),o(e,Sd,t),p(el,e,t),o(e,Od,t),o(e,tl,t),o(e,Fd,t),o(e,ll,t),o(e,Wd,t),o(e,Yd,t),o(e,Gd,t),o(e,ol,t),o(e,Xd,t),p(sl,e,t),o(e,Zd,t),o(e,nl,t),o(e,eu,t),o(e,il,t),o(e,tu,t),o(e,lu,t),o(e,ou,t),o(e,rl,t),o(e,su,t),p(dl,e,t),o(e,nu,t),o(e,ul,t),o(e,iu,t),o(e,al,t),o(e,ru,t),o(e,ml,t),o(e,du,t),o(e,uu,t),o(e,au,t),o(e,pl,t),o(e,mu,t),p(cl,e,t),o(e,pu,t),o(e,fl,t),o(e,cu,t),o(e,Tl,t),o(e,fu,t),o(e,hl,t),o(e,Tu,t),o(e,hu,t),o(e,_u,t),o(e,_l,t),o(e,$u,t),p($l,e,t),o(e,vu,t),o(e,vl,t),o(e,yu,t),o(e,yl,t),o(e,bu,t),o(e,Mu,t),o(e,xu,t),o(e,bl,t),o(e,Cu,t),p(Ml,e,t),o(e,Hu,t),o(e,xl,t),o(e,Lu,t),o(e,Cl,t),o(e,wu,t),o(e,Hl,t),o(e,Au,t),o(e,gu,t),o(e,zu,t),o(e,Ll,t),o(e,Pu,t),p(wl,e,t),o(e,Ru,t),o(e,Al,t),o(e,Uu,t),o(e,gl,t),o(e,Eu,t),o(e,ku,t),o(e,ju,t),o(e,zl,t),o(e,Ju,t),p(Pl,e,t),o(e,Du,t),o(e,Rl,t),o(e,qu,t),o(e,Ul,t),o(e,Iu,t),o(e,Ku,t),o(e,Bu,t),o(e,El,t),o(e,Nu,t),p(kl,e,t),o(e,Vu,t),o(e,jl,t),o(e,Qu,t),o(e,Jl,t),o(e,Su,t),o(e,Dl,t),o(e,Ou,t),o(e,Fu,t),o(e,Wu,t),o(e,ql,t),o(e,Yu,t),p(Il,e,t),o(e,Gu,t),o(e,Kl,t),o(e,Xu,t),o(e,Bl,t),o(e,Zu,t),o(e,Nl,t),o(e,ea,t),o(e,ta,t),o(e,la,t),o(e,Vl,t),o(e,oa,t),p(Ql,e,t),o(e,sa,t),o(e,Sl,t),o(e,na,t),o(e,Ol,t),o(e,ia,t),o(e,Fl,t),o(e,ra,t),o(e,da,t),o(e,ua,t),o(e,Wl,t),o(e,aa,t),p(Yl,e,t),o(e,ma,t),o(e,Gl,t),o(e,pa,t),o(e,Xl,t),o(e,ca,t),o(e,Zl,t),o(e,fa,t),o(e,Ta,t),o(e,ha,t),o(e,eo,t),o(e,_a,t),p(to,e,t),o(e,$a,t),o(e,lo,t),o(e,va,t),o(e,oo,t),o(e,ya,t),o(e,so,t),o(e,ba,t),o(e,Ma,t),o(e,xa,t),o(e,no,t),o(e,Ca,t),p(io,e,t),o(e,Ha,t),o(e,ro,t),o(e,La,t),o(e,uo,t),o(e,wa,t),o(e,ao,t),o(e,Aa,t),o(e,ga,t),o(e,za,t),o(e,mo,t),o(e,Pa,t),p(po,e,t),o(e,Ra,t),o(e,co,t),o(e,Ua,t),o(e,fo,t),o(e,Ea,t),o(e,To,t),o(e,ka,t),o(e,ja,t),o(e,Ja,t),o(e,ho,t),o(e,Da,t),p(_o,e,t),o(e,qa,t),o(e,$o,t),o(e,Ia,t),o(e,vo,t),o(e,Ka,t),o(e,yo,t),o(e,Ba,t),o(e,Na,t),o(e,Va,t),o(e,bo,t),o(e,Qa,t),p(Mo,e,t),o(e,Sa,t),o(e,xo,t),o(e,Oa,t),o(e,Co,t),o(e,Fa,t),o(e,Ho,t),o(e,Wa,t),o(e,Ya,t),o(e,Ga,t),o(e,Lo,t),o(e,Xa,t),p(wo,e,t),o(e,Za,t),o(e,Ao,t),o(e,em,t),o(e,go,t),o(e,tm,t),o(e,zo,t),o(e,lm,t),o(e,om,t),o(e,sm,t),o(e,Po,t),o(e,nm,t),p(Ro,e,t),o(e,im,t),o(e,Uo,t),o(e,rm,t),o(e,Eo,t),o(e,dm,t),o(e,ko,t),o(e,um,t),o(e,am,t),o(e,mm,t),o(e,jo,t),o(e,pm,t),p(Jo,e,t),o(e,cm,t),o(e,Do,t),o(e,fm,t),o(e,qo,t),o(e,Tm,t),o(e,Io,t),o(e,hm,t),o(e,_m,t),o(e,$m,t),o(e,Ko,t),o(e,vm,t),p(Bo,e,t),o(e,ym,t),o(e,No,t),o(e,bm,t),o(e,Vo,t),o(e,Mm,t),o(e,Qo,t),o(e,xm,t),o(e,Cm,t),o(e,Hm,t),o(e,So,t),o(e,Lm,t),p(Oo,e,t),o(e,wm,t),o(e,Fo,t),o(e,Am,t),o(e,Wo,t),o(e,gm,t),o(e,Yo,t),o(e,zm,t),o(e,Pm,t),o(e,Rm,t),o(e,Go,t),o(e,Um,t),p(Xo,e,t),o(e,Em,t),o(e,Zo,t),o(e,km,t),o(e,es,t),o(e,jm,t),o(e,ts,t),o(e,Jm,t),o(e,Dm,t),o(e,qm,t),o(e,ls,t),o(e,Im,t),p(os,e,t),o(e,Km,t),o(e,ss,t),o(e,Bm,t),o(e,ns,t),o(e,Nm,t),o(e,is,t),o(e,Vm,t),o(e,Qm,t),o(e,Sm,t),o(e,rs,t),o(e,Om,t),p(ds,e,t),o(e,Fm,t),o(e,us,t),o(e,Wm,t),o(e,as,t),o(e,Ym,t),o(e,ms,t),o(e,Gm,t),o(e,Xm,t),o(e,Zm,t),o(e,ps,t),o(e,ep,t),p(cs,e,t),o(e,tp,t),o(e,fs,t),o(e,lp,t),o(e,Ts,t),o(e,op,t),o(e,hs,t),o(e,sp,t),o(e,np,t),o(e,ip,t),o(e,_s,t),o(e,rp,t),p($s,e,t),o(e,dp,t),o(e,vs,t),o(e,up,t),o(e,ys,t),o(e,ap,t),o(e,bs,t),o(e,mp,t),o(e,pp,t),o(e,cp,t),o(e,Ms,t),o(e,fp,t),p(xs,e,t),o(e,Tp,t),o(e,Cs,t),o(e,hp,t),o(e,Hs,t),o(e,_p,t),o(e,Ls,t),o(e,$p,t),o(e,vp,t),o(e,yp,t),o(e,ws,t),o(e,bp,t),p(As,e,t),o(e,Mp,t),o(e,gs,t),o(e,xp,t),o(e,Cp,t),o(e,Hp,t),o(e,zs,t),o(e,Lp,t),p(Ps,e,t),o(e,wp,t),o(e,Rs,t),o(e,Ap,t),o(e,Us,t),o(e,gp,t),o(e,Es,t),o(e,zp,t),o(e,ks,t),o(e,Pp,t),p(js,e,t),o(e,Rp,t),o(e,Up,t),o(e,Ep,t),o(e,Js,t),o(e,kp,t),p(Ds,e,t),o(e,jp,t),o(e,qs,t),o(e,Jp,t),o(e,Dp,t),o(e,qp,t),o(e,Is,t),o(e,Ip,t),p(Ks,e,t),o(e,Kp,t),o(e,Bs,t),o(e,Bp,t),o(e,Np,t),o(e,Vp,t),o(e,Ns,t),o(e,Qp,t),p(Vs,e,t),o(e,Sp,t),o(e,Qs,t),o(e,Op,t),o(e,Ss,t),o(e,Fp,t),p(Os,e,t),o(e,Wp,t),o(e,Fs,t),o(e,Yp,t),p(Ws,e,t),o(e,Gp,t),o(e,Ys,t),o(e,Xp,t),p(Gs,e,t),o(e,Zp,t),o(e,ec,t),o(e,tc,t),p(Xs,e,t),o(e,lc,t),o(e,en,t),oc=!0},p:hh,i(e){oc||(c(y.$$.fragment,e),c(H.$$.fragment,e),c(g.$$.fragment,e),c(U.$$.fragment,e),c(J.$$.fragment,e),c(K.$$.fragment,e),c(Q.$$.fragment,e),c(W.$$.fragment,e),c(Z.$$.fragment,e),c(oe.$$.fragment,e),c(de.$$.fragment,e),c(pe.$$.fragment,e),c(he.$$.fragment,e),c(be.$$.fragment,e),c(He.$$.fragment,e),c(ge.$$.fragment,e),c(Ue.$$.fragment,e),c(De.$$.fragment,e),c(Ne.$$.fragment,e),c(Fe.$$.fragment,e),c(Ze.$$.fragment,e),c(st.$$.fragment,e),c(ut.$$.fragment,e),c(ft.$$.fragment,e),c(vt.$$.fragment,e),c(Ct.$$.fragment,e),c(gt.$$.fragment,e),c(Et.$$.fragment,e),c(Dt.$$.fragment,e),c(Vt.$$.fragment,e),c(Ft.$$.fragment,e),c(el.$$.fragment,e),c(sl.$$.fragment,e),c(dl.$$.fragment,e),c(cl.$$.fragment,e),c($l.$$.fragment,e),c(Ml.$$.fragment,e),c(wl.$$.fragment,e),c(Pl.$$.fragment,e),c(kl.$$.fragment,e),c(Il.$$.fragment,e),c(Ql.$$.fragment,e),c(Yl.$$.fragment,e),c(to.$$.fragment,e),c(io.$$.fragment,e),c(po.$$.fragment,e),c(_o.$$.fragment,e),c(Mo.$$.fragment,e),c(wo.$$.fragment,e),c(Ro.$$.fragment,e),c(Jo.$$.fragment,e),c(Bo.$$.fragment,e),c(Oo.$$.fragment,e),c(Xo.$$.fragment,e),c(os.$$.fragment,e),c(ds.$$.fragment,e),c(cs.$$.fragment,e),c($s.$$.fragment,e),c(xs.$$.fragment,e),c(As.$$.fragment,e),c(Ps.$$.fragment,e),c(js.$$.fragment,e),c(Ds.$$.fragment,e),c(Ks.$$.fragment,e),c(Vs.$$.fragment,e),c(Os.$$.fragment,e),c(Ws.$$.fragment,e),c(Gs.$$.fragment,e),c(Xs.$$.fragment,e),oc=!0)},o(e){f(y.$$.fragment,e),f(H.$$.fragment,e),f(g.$$.fragment,e),f(U.$$.fragment,e),f(J.$$.fragment,e),f(K.$$.fragment,e),f(Q.$$.fragment,e),f(W.$$.fragment,e),f(Z.$$.fragment,e),f(oe.$$.fragment,e),f(de.$$.fragment,e),f(pe.$$.fragment,e),f(he.$$.fragment,e),f(be.$$.fragment,e),f(He.$$.fragment,e),f(ge.$$.fragment,e),f(Ue.$$.fragment,e),f(De.$$.fragment,e),f(Ne.$$.fragment,e),f(Fe.$$.fragment,e),f(Ze.$$.fragment,e),f(st.$$.fragment,e),f(ut.$$.fragment,e),f(ft.$$.fragment,e),f(vt.$$.fragment,e),f(Ct.$$.fragment,e),f(gt.$$.fragment,e),f(Et.$$.fragment,e),f(Dt.$$.fragment,e),f(Vt.$$.fragment,e),f(Ft.$$.fragment,e),f(el.$$.fragment,e),f(sl.$$.fragment,e),f(dl.$$.fragment,e),f(cl.$$.fragment,e),f($l.$$.fragment,e),f(Ml.$$.fragment,e),f(wl.$$.fragment,e),f(Pl.$$.fragment,e),f(kl.$$.fragment,e),f(Il.$$.fragment,e),f(Ql.$$.fragment,e),f(Yl.$$.fragment,e),f(to.$$.fragment,e),f(io.$$.fragment,e),f(po.$$.fragment,e),f(_o.$$.fragment,e),f(Mo.$$.fragment,e),f(wo.$$.fragment,e),f(Ro.$$.fragment,e),f(Jo.$$.fragment,e),f(Bo.$$.fragment,e),f(Oo.$$.fragment,e),f(Xo.$$.fragment,e),f(os.$$.fragment,e),f(ds.$$.fragment,e),f(cs.$$.fragment,e),f($s.$$.fragment,e),f(xs.$$.fragment,e),f(As.$$.fragment,e),f(Ps.$$.fragment,e),f(js.$$.fragment,e),f(Ds.$$.fragment,e),f(Ks.$$.fragment,e),f(Vs.$$.fragment,e),f(Os.$$.fragment,e),f(Ws.$$.fragment,e),f(Gs.$$.fragment,e),f(Xs.$$.fragment,e),oc=!1},d(e){e&&(l(tn),l(Zs),l(ln),l(v),l(on),l(sn),l(b),l(nn),l(M),l(rn),l(x),l(dn),l(un),l(an),l(C),l(mn),l(pn),l(L),l(cn),l(w),l(fn),l(Tn),l(hn),l(A),l(_n),l($n),l(z),l(vn),l(P),l(yn),l(bn),l(Mn),l(R),l(xn),l(Cn),l(E),l(Hn),l(k),l(Ln),l(wn),l(An),l(j),l(gn),l(zn),l(D),l(Pn),l(q),l(Rn),l(Un),l(En),l(I),l(kn),l(jn),l(B),l(Jn),l(N),l(Dn),l(qn),l(In),l(V),l(Kn),l(Bn),l(S),l(Nn),l(O),l(Vn),l(Qn),l(Sn),l(F),l(On),l(Fn),l(Y),l(Wn),l(G),l(Yn),l(Gn),l(Xn),l(X),l(Zn),l(ei),l(ee),l(ti),l(te),l(li),l(oi),l(si),l(le),l(ni),l(ii),l(se),l(ri),l(ne),l(di),l(ie),l(ui),l(ai),l(mi),l(re),l(pi),l(ci),l(ue),l(fi),l(ae),l(Ti),l(hi),l(_i),l(me),l($i),l(vi),l(ce),l(yi),l(fe),l(bi),l(Mi),l(xi),l(Te),l(Ci),l(Hi),l(_e),l(Li),l($e),l(wi),l(ve),l(Ai),l(gi),l(zi),l(ye),l(Pi),l(Ri),l(Me),l(Ui),l(xe),l(Ei),l(ki),l(ji),l(Ce),l(Ji),l(Di),l(Le),l(qi),l(we),l(Ii),l(Ki),l(Bi),l(Ae),l(Ni),l(Vi),l(ze),l(Qi),l(Pe),l(Si),l(Oi),l(Fi),l(Re),l(Wi),l(Yi),l(Ee),l(Gi),l(ke),l(Xi),l(je),l(Zi),l(er),l(tr),l(Je),l(lr),l(or),l(qe),l(sr),l(Ie),l(nr),l(Ke),l(ir),l(rr),l(dr),l(Be),l(ur),l(ar),l(Ve),l(mr),l(Qe),l(pr),l(Se),l(cr),l(fr),l(Tr),l(Oe),l(hr),l(_r),l(We),l($r),l(Ye),l(vr),l(Ge),l(yr),l(br),l(Mr),l(Xe),l(xr),l(Cr),l(et),l(Hr),l(tt),l(Lr),l(lt),l(wr),l(Ar),l(gr),l(ot),l(zr),l(Pr),l(nt),l(Rr),l(it),l(Ur),l(rt),l(Er),l(kr),l(jr),l(dt),l(Jr),l(Dr),l(at),l(qr),l(mt),l(Ir),l(pt),l(Kr),l(Br),l(Nr),l(ct),l(Vr),l(Qr),l(Tt),l(Sr),l(ht),l(Or),l(_t),l(Fr),l(Wr),l(Yr),l($t),l(Gr),l(Xr),l(yt),l(Zr),l(bt),l(ed),l(Mt),l(td),l(ld),l(od),l(xt),l(sd),l(nd),l(Ht),l(id),l(Lt),l(rd),l(wt),l(dd),l(ud),l(ad),l(At),l(md),l(pd),l(zt),l(cd),l(Pt),l(fd),l(Rt),l(Td),l(hd),l(_d),l(Ut),l($d),l(vd),l(kt),l(yd),l(jt),l(bd),l(Md),l(xd),l(Jt),l(Cd),l(Hd),l(qt),l(Ld),l(It),l(wd),l(Kt),l(Ad),l(Bt),l(gd),l(zd),l(Pd),l(Nt),l(Rd),l(Ud),l(Qt),l(Ed),l(St),l(kd),l(jd),l(Jd),l(Ot),l(Dd),l(qd),l(Wt),l(Id),l(Yt),l(Kd),l(Gt),l(Bd),l(Xt),l(Nd),l(Vd),l(Qd),l(Zt),l(Sd),l(Od),l(tl),l(Fd),l(ll),l(Wd),l(Yd),l(Gd),l(ol),l(Xd),l(Zd),l(nl),l(eu),l(il),l(tu),l(lu),l(ou),l(rl),l(su),l(nu),l(ul),l(iu),l(al),l(ru),l(ml),l(du),l(uu),l(au),l(pl),l(mu),l(pu),l(fl),l(cu),l(Tl),l(fu),l(hl),l(Tu),l(hu),l(_u),l(_l),l($u),l(vu),l(vl),l(yu),l(yl),l(bu),l(Mu),l(xu),l(bl),l(Cu),l(Hu),l(xl),l(Lu),l(Cl),l(wu),l(Hl),l(Au),l(gu),l(zu),l(Ll),l(Pu),l(Ru),l(Al),l(Uu),l(gl),l(Eu),l(ku),l(ju),l(zl),l(Ju),l(Du),l(Rl),l(qu),l(Ul),l(Iu),l(Ku),l(Bu),l(El),l(Nu),l(Vu),l(jl),l(Qu),l(Jl),l(Su),l(Dl),l(Ou),l(Fu),l(Wu),l(ql),l(Yu),l(Gu),l(Kl),l(Xu),l(Bl),l(Zu),l(Nl),l(ea),l(ta),l(la),l(Vl),l(oa),l(sa),l(Sl),l(na),l(Ol),l(ia),l(Fl),l(ra),l(da),l(ua),l(Wl),l(aa),l(ma),l(Gl),l(pa),l(Xl),l(ca),l(Zl),l(fa),l(Ta),l(ha),l(eo),l(_a),l($a),l(lo),l(va),l(oo),l(ya),l(so),l(ba),l(Ma),l(xa),l(no),l(Ca),l(Ha),l(ro),l(La),l(uo),l(wa),l(ao),l(Aa),l(ga),l(za),l(mo),l(Pa),l(Ra),l(co),l(Ua),l(fo),l(Ea),l(To),l(ka),l(ja),l(Ja),l(ho),l(Da),l(qa),l($o),l(Ia),l(vo),l(Ka),l(yo),l(Ba),l(Na),l(Va),l(bo),l(Qa),l(Sa),l(xo),l(Oa),l(Co),l(Fa),l(Ho),l(Wa),l(Ya),l(Ga),l(Lo),l(Xa),l(Za),l(Ao),l(em),l(go),l(tm),l(zo),l(lm),l(om),l(sm),l(Po),l(nm),l(im),l(Uo),l(rm),l(Eo),l(dm),l(ko),l(um),l(am),l(mm),l(jo),l(pm),l(cm),l(Do),l(fm),l(qo),l(Tm),l(Io),l(hm),l(_m),l($m),l(Ko),l(vm),l(ym),l(No),l(bm),l(Vo),l(Mm),l(Qo),l(xm),l(Cm),l(Hm),l(So),l(Lm),l(wm),l(Fo),l(Am),l(Wo),l(gm),l(Yo),l(zm),l(Pm),l(Rm),l(Go),l(Um),l(Em),l(Zo),l(km),l(es),l(jm),l(ts),l(Jm),l(Dm),l(qm),l(ls),l(Im),l(Km),l(ss),l(Bm),l(ns),l(Nm),l(is),l(Vm),l(Qm),l(Sm),l(rs),l(Om),l(Fm),l(us),l(Wm),l(as),l(Ym),l(ms),l(Gm),l(Xm),l(Zm),l(ps),l(ep),l(tp),l(fs),l(lp),l(Ts),l(op),l(hs),l(sp),l(np),l(ip),l(_s),l(rp),l(dp),l(vs),l(up),l(ys),l(ap),l(bs),l(mp),l(pp),l(cp),l(Ms),l(fp),l(Tp),l(Cs),l(hp),l(Hs),l(_p),l(Ls),l($p),l(vp),l(yp),l(ws),l(bp),l(Mp),l(gs),l(xp),l(Cp),l(Hp),l(zs),l(Lp),l(wp),l(Rs),l(Ap),l(Us),l(gp),l(Es),l(zp),l(ks),l(Pp),l(Rp),l(Up),l(Ep),l(Js),l(kp),l(jp),l(qs),l(Jp),l(Dp),l(qp),l(Is),l(Ip),l(Kp),l(Bs),l(Bp),l(Np),l(Vp),l(Ns),l(Qp),l(Sp),l(Qs),l(Op),l(Ss),l(Fp),l(Wp),l(Fs),l(Yp),l(Gp),l(Ys),l(Xp),l(Zp),l(ec),l(tc),l(lc),l(en)),l($),T(y,e),T(H,e),T(g,e),T(U,e),T(J,e),T(K,e),T(Q,e),T(W,e),T(Z,e),T(oe,e),T(de,e),T(pe,e),T(he,e),T(be,e),T(He,e),T(ge,e),T(Ue,e),T(De,e),T(Ne,e),T(Fe,e),T(Ze,e),T(st,e),T(ut,e),T(ft,e),T(vt,e),T(Ct,e),T(gt,e),T(Et,e),T(Dt,e),T(Vt,e),T(Ft,e),T(el,e),T(sl,e),T(dl,e),T(cl,e),T($l,e),T(Ml,e),T(wl,e),T(Pl,e),T(kl,e),T(Il,e),T(Ql,e),T(Yl,e),T(to,e),T(io,e),T(po,e),T(_o,e),T(Mo,e),T(wo,e),T(Ro,e),T(Jo,e),T(Bo,e),T(Oo,e),T(Xo,e),T(os,e),T(ds,e),T(cs,e),T($s,e),T(xs,e),T(As,e),T(Ps,e),T(js,e),T(Ds,e),T(Ks,e),T(Vs,e),T(Os,e),T(Ws,e),T(Gs,e),T(Xs,e)}}}const Ch='{"title":"utils/tensor","local":"utilstensor","sections":[{"title":"utils/tensor.Tensor","local":"utilstensortensor","sections":[{"title":"new Tensor(...args)","local":"new-tensorargs","sections":[],"depth":3},{"title":"tensor.dims : <code> Array. < number > </code>","local":"tensordims--code-array--number--code","sections":[],"depth":3},{"title":"tensor.type : <code> DataType </code>","local":"tensortype--code-datatype-code","sections":[],"depth":3},{"title":"tensor.data : <code> DataArray </code>","local":"tensordata--code-dataarray-code","sections":[],"depth":3},{"title":"tensor.size : <code> number </code>","local":"tensorsize--code-number-code","sections":[],"depth":3},{"title":"tensor.location : <code> string </code>","local":"tensorlocation--code-string-code","sections":[],"depth":3},{"title":"tensor.Symbol.iterator() ⇒ <code> Iterator </code>","local":"tensorsymboliterator--code-iterator-code","sections":[],"depth":3},{"title":"tensor._getitem(index) ⇒ <code> Tensor </code>","local":"tensorgetitemindex--code-tensor-code","sections":[],"depth":3},{"title":"tensor.indexOf(item) ⇒ <code> number </code>","local":"tensorindexofitem--code-number-code","sections":[],"depth":3},{"title":"tensor._subarray(index, iterSize, iterDims) ⇒ <code> Tensor </code>","local":"tensorsubarrayindex-itersize-iterdims--code-tensor-code","sections":[],"depth":3},{"title":"tensor.item() ⇒ <code> number </code> | <code> bigint </code>","local":"tensoritem--code-number-code--code-bigint-code","sections":[],"depth":3},{"title":"tensor.tolist() ⇒ <code> Array </code>","local":"tensortolist--code-array-code","sections":[],"depth":3},{"title":"tensor.sigmoid() ⇒ <code> Tensor </code>","local":"tensorsigmoid--code-tensor-code","sections":[],"depth":3},{"title":"tensor.sigmoid_() ⇒ <code> Tensor </code>","local":"tensorsigmoid--code-tensor-code","sections":[],"depth":3},{"title":"tensor.mul(val) ⇒ <code> Tensor </code>","local":"tensormulval--code-tensor-code","sections":[],"depth":3},{"title":"tensor.mul_(val) ⇒ <code> Tensor </code>","local":"tensormulval--code-tensor-code","sections":[],"depth":3},{"title":"tensor.div(val) ⇒ <code> Tensor </code>","local":"tensordivval--code-tensor-code","sections":[],"depth":3},{"title":"tensor.div_(val) ⇒ <code> Tensor </code>","local":"tensordivval--code-tensor-code","sections":[],"depth":3},{"title":"tensor.add(val) ⇒ <code> Tensor </code>","local":"tensoraddval--code-tensor-code","sections":[],"depth":3},{"title":"tensor.add_(val) ⇒ <code> Tensor </code>","local":"tensoraddval--code-tensor-code","sections":[],"depth":3},{"title":"tensor.permute(...dims) ⇒ <code> Tensor </code>","local":"tensorpermutedims--code-tensor-code","sections":[],"depth":3},{"title":"tensor.sum([dim], keepdim) ⇒","local":"tensorsumdim-keepdim-","sections":[],"depth":3},{"title":"tensor.norm([p], [dim], [keepdim]) ⇒ <code> Tensor </code>","local":"tensornormp-dim-keepdim--code-tensor-code","sections":[],"depth":3},{"title":"tensor.normalize_([p], [dim]) ⇒ <code> Tensor </code>","local":"tensornormalizep-dim--code-tensor-code","sections":[],"depth":3},{"title":"tensor.normalize([p], [dim]) ⇒ <code> Tensor </code>","local":"tensornormalizep-dim--code-tensor-code","sections":[],"depth":3},{"title":"tensor.stride() ⇒ <code> Array. < number > </code>","local":"tensorstride--code-array--number--code","sections":[],"depth":3},{"title":"tensor.squeeze([dim]) ⇒ <code> Tensor </code>","local":"tensorsqueezedim--code-tensor-code","sections":[],"depth":3},{"title":"tensor.squeeze_()","local":"tensorsqueeze","sections":[],"depth":3},{"title":"tensor.unsqueeze(dim) ⇒ <code> Tensor </code>","local":"tensorunsqueezedim--code-tensor-code","sections":[],"depth":3},{"title":"tensor.unsqueeze_()","local":"tensorunsqueeze","sections":[],"depth":3},{"title":"tensor.flatten_()","local":"tensorflatten","sections":[],"depth":3},{"title":"tensor.flatten(start_dim, end_dim) ⇒ <code> Tensor </code>","local":"tensorflattenstartdim-enddim--code-tensor-code","sections":[],"depth":3},{"title":"tensor.view(...dims) ⇒ <code> Tensor </code>","local":"tensorviewdims--code-tensor-code","sections":[],"depth":3},{"title":"tensor.clamp_()","local":"tensorclamp","sections":[],"depth":3},{"title":"tensor.clamp(min, max) ⇒ <code> Tensor </code>","local":"tensorclampmin-max--code-tensor-code","sections":[],"depth":3},{"title":"tensor.round_()","local":"tensorround","sections":[],"depth":3},{"title":"tensor.round() ⇒ <code> Tensor </code>","local":"tensorround--code-tensor-code","sections":[],"depth":3},{"title":"tensor.to(type) ⇒ <code> Tensor </code>","local":"tensortotype--code-tensor-code","sections":[],"depth":3}],"depth":2},{"title":"utils/tensor.permute(tensor, axes) ⇒ <code> Tensor </code>","local":"utilstensorpermutetensor-axes--code-tensor-code","sections":[],"depth":2},{"title":"utils/tensor.interpolate(input, size, mode, align_corners) ⇒ <code> Tensor </code>","local":"utilstensorinterpolateinput-size-mode-aligncorners--code-tensor-code","sections":[],"depth":2},{"title":"utils/tensor.interpolate_4d(input, options) ⇒ <code> Promise. < Tensor > </code>","local":"utilstensorinterpolate4dinput-options--code-promise--tensor--code","sections":[],"depth":2},{"title":"utils/tensor.matmul(a, b) ⇒ <code> Promise. < Tensor > </code>","local":"utilstensormatmula-b--code-promise--tensor--code","sections":[],"depth":2},{"title":"utils/tensor.rfft(x, a) ⇒ <code> Promise. < Tensor > </code>","local":"utilstensorrfftx-a--code-promise--tensor--code","sections":[],"depth":2},{"title":"utils/tensor.topk(x, k) ⇒ <code> * </code>","local":"utilstensortopkx-k--code--code","sections":[],"depth":2},{"title":"utils/tensor.mean_pooling(last_hidden_state, attention_mask) ⇒ <code> Tensor </code>","local":"utilstensormeanpoolinglasthiddenstate-attentionmask--code-tensor-code","sections":[],"depth":2},{"title":"utils/tensor.layer_norm(input, normalized_shape, options) ⇒ <code> Tensor </code>","local":"utilstensorlayernorminput-normalizedshape-options--code-tensor-code","sections":[],"depth":2},{"title":"utils/tensor.cat(tensors, dim) ⇒ <code> Tensor </code>","local":"utilstensorcattensors-dim--code-tensor-code","sections":[],"depth":2},{"title":"utils/tensor.stack(tensors, dim) ⇒ <code> Tensor </code>","local":"utilstensorstacktensors-dim--code-tensor-code","sections":[],"depth":2},{"title":"utils/tensor.std_mean(input, dim, correction, keepdim) ⇒ <code> Array. < Tensor > </code>","local":"utilstensorstdmeaninput-dim-correction-keepdim--code-array--tensor--code","sections":[],"depth":2},{"title":"utils/tensor.mean(input, dim, keepdim) ⇒ <code> Tensor </code>","local":"utilstensormeaninput-dim-keepdim--code-tensor-code","sections":[],"depth":2},{"title":"utils/tensor.dynamicTimeWarping(matrix) ⇒ <code> Array. < Array < number > > </code>","local":"utilstensordynamictimewarpingmatrix--code-array--array--number---code","sections":[],"depth":2},{"title":"utils/tensor.full(size, fill_value) ⇒ <code> Tensor </code>","local":"utilstensorfullsize-fillvalue--code-tensor-code","sections":[],"depth":2},{"title":"utils/tensor.ones(size) ⇒ <code> Tensor </code>","local":"utilstensoronessize--code-tensor-code","sections":[],"depth":2},{"title":"utils/tensor.ones_like(tensor) ⇒ <code> Tensor </code>","local":"utilstensoronesliketensor--code-tensor-code","sections":[],"depth":2},{"title":"utils/tensor.zeros(size) ⇒ <code> Tensor </code>","local":"utilstensorzerossize--code-tensor-code","sections":[],"depth":2},{"title":"utils/tensor.zeros_like(tensor) ⇒ <code> Tensor </code>","local":"utilstensorzerosliketensor--code-tensor-code","sections":[],"depth":2},{"title":"utils/tensor.quantize_embeddings(tensor, precision) ⇒ <code> Tensor </code>","local":"utilstensorquantizeembeddingstensor-precision--code-tensor-code","sections":[],"depth":2},{"title":"utils/tensor~args[0] : <code> ONNXTensor </code>","local":"utilstensorargs0--code-onnxtensor-code","sections":[],"depth":2},{"title":"utils/tensor~reshape(data, dimensions) ⇒ <code> * </code>","local":"utilstensorreshapedata-dimensions--code--code","sections":[{"title":"reshape~reshapedArray : <code> any </code>","local":"reshapereshapedarray--code-any-code","sections":[],"depth":3}],"depth":2},{"title":"utils/tensor~DataArray : <code> * </code>","local":"utilstensordataarray--code--code","sections":[],"depth":2},{"title":"utils/tensor~NestArray : <code> * </code>","local":"utilstensornestarray--code--code","sections":[],"depth":2}],"depth":1}';function Hh(nc){return _h(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class zh extends $h{constructor($){super(),vh(this,$,Hh,xh,Th,{})}}export{zh as component};
