import{s as kl,n as Vl,o as El}from"../chunks/scheduler.3e37077e.js";import{S as Ql,i as Wl,g as i,s as n,r as c,A as Xl,h as M,f as t,c as a,j as Gl,u as y,x as o,k as Zl,y as ql,a as s,v as p,d as j,t as u,w as d}from"../chunks/index.0b341bf5.js";import{C as Rl}from"../chunks/CodeBlock.6444d2b6.js";import{H as S}from"../chunks/Heading.639933af.js";import{E as Nl}from"../chunks/EditOnGithub.aed3507d.js";function Sl(ul){let r,x,q,z,h,H,m,dl="Agentic RAG (Retrieval-Augmented Generation) extends traditional RAG systems by combining autonomous agents with dynamic knowledge retrieval. While traditional RAG systems use an LLM to answer queries based on retrieved data, agentic RAG enables intelligent control of both retrieval and generation processes, improving efficiency and accuracy.",_,U,hl="Traditional RAG systems face key limitations, such as relying on a single retrieval step and focusing on direct semantic similarity with the user’s query, which may overlook relevant information. Agentic RAG addresses these issues by allowing the agent to autonomously formulate search queries, critique retrieved results, and conduct multiple retrieval steps for a more tailored and comprehensive output.",F,J,$,w,ml="Let’s build a simple agent that can search the web using DuckDuckGo. This agent will retrieve information and synthesize responses to answer queries. With Agentic RAG, Alfred’s agent can:",Y,T,Ul="<li>Search for latest superhero party trends</li> <li>Refine results to include luxury elements</li> <li>Synthesize information into a complete plan</li>",D,b,Jl="Here’s how Alfred’s agent can achieve this:",L,g,P,I,wl="The agent follows this process:",K,B,Tl="<li><strong>Analyzes the Request:</strong> Alfred’s agent identifies the key elements of the query—luxury superhero-themed party planning, with focus on decor, entertainment, and catering.</li> <li><strong>Performs Retrieval:</strong>  The agent leverages DuckDuckGo to search for the most relevant and up-to-date information, ensuring it aligns with Alfred’s refined preferences for a luxurious event.</li> <li><strong>Synthesizes Information:</strong> After gathering the results, the agent processes them into a cohesive, actionable plan for Alfred, covering all aspects of the party.</li> <li><strong>Stores for Future Reference:</strong> The agent stores the retrieved information for easy access when planning future events, optimizing efficiency in subsequent tasks.</li>",O,A,ll,f,bl="For specialized tasks, a custom knowledge base can be invaluable. Let’s create a tool that queries a vector database of technical documentation or specialized knowledge. Using semantic search, the agent can find the most relevant information for Alfred’s needs.",el,C,gl="This approach combines predefined knowledge with semantic search to provide context-aware solutions for event planning. With specialized knowledge access, Alfred can perfect every detail of the party.",tl,v,sl,G,Il="This enhanced agent can:",nl,Z,Bl="<li>First check the documentation for relevant information</li> <li>Combine insights from the knowledge base</li> <li>Maintain conversation context through memory</li>",al,R,il,k,Al="When building agentic RAG systems, the agent can employ sophisticated strategies like:",Ml,V,fl="<li><strong>Query Reformulation:</strong> Instead of using the raw user query, the agent can craft optimized search terms that better match the target documents</li> <li><strong>Multi-Step Retrieval</strong> The agent can perform multiple searches, using initial results to inform subsequent queries</li> <li><strong>Source Integration</strong> Information can be combined from multiple sources like web search and local documentation</li> <li><strong>Result Validation</strong> Retrieved content can be analyzed for relevance and accuracy before being included in responses</li>",ol,E,Cl="Effective agentic RAG systems require careful consideration of several key aspects. The agent should select between available tools based on the query type and context. Memory systems help maintain conversation history and avoid repetitive retrievals. Having fallback strategies ensures the system can still provide value even when primary retrieval methods fail. Additionally, implementing validation steps helps ensure the accuracy and relevance of retrieved information.",rl,Q,cl,W,vl='<li><a href="https://huggingface.co/learn/cookbook/agent_rag" rel="nofollow">Agentic RAG: turbocharge your RAG with query reformulation and self-query! 🚀</a> - Recipe for developing an Agentic RAG system using smolagents.</li>',yl,X,pl,N,jl;return h=new S({props:{title:"Building Agentic RAG Systems",local:"building-agentic-rag-systems",headingTag:"h1"}}),J=new S({props:{title:"Basic Retrieval with DuckDuckGo",local:"basic-retrieval-with-duckduckgo",headingTag:"h2"}}),g=new Rl({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBDb2RlQWdlbnQlMkMlMjBEdWNrRHVja0dvU2VhcmNoVG9vbCUyQyUyMEhmQXBpTW9kZWwlMEElMEElMjMlMjBJbml0aWFsaXplJTIwdGhlJTIwc2VhcmNoJTIwdG9vbCUwQXNlYXJjaF90b29sJTIwJTNEJTIwRHVja0R1Y2tHb1NlYXJjaFRvb2woKSUwQSUwQSUyMyUyMEluaXRpYWxpemUlMjB0aGUlMjBtb2RlbCUwQW1vZGVsJTIwJTNEJTIwSGZBcGlNb2RlbCgpJTBBJTBBYWdlbnQlMjAlM0QlMjBDb2RlQWdlbnQoJTBBJTIwJTIwJTIwJTIwbW9kZWwlMjAlM0QlMjBtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMHRvb2xzJTNEJTVCc2VhcmNoX3Rvb2wlNUQlMEEpJTBBJTBBJTIzJTIwRXhhbXBsZSUyMHVzYWdlJTBBcmVzcG9uc2UlMjAlM0QlMjBhZ2VudC5ydW4oJTBBJTIwJTIwJTIwJTIwJTIyU2VhcmNoJTIwZm9yJTIwbHV4dXJ5JTIwc3VwZXJoZXJvLXRoZW1lZCUyMHBhcnR5JTIwaWRlYXMlMkMlMjBpbmNsdWRpbmclMjBkZWNvcmF0aW9ucyUyQyUyMGVudGVydGFpbm1lbnQlMkMlMjBhbmQlMjBjYXRlcmluZy4lMjIlMEEpJTBBcHJpbnQocmVzcG9uc2Up",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent, DuckDuckGoSearchTool, HfApiModel

<span class="hljs-comment"># Initialize the search tool</span>
search_tool = DuckDuckGoSearchTool()

<span class="hljs-comment"># Initialize the model</span>
model = HfApiModel()

agent = CodeAgent(
    model = model,
    tools=[search_tool]
)

<span class="hljs-comment"># Example usage</span>
response = agent.run(
    <span class="hljs-string">&quot;Search for luxury superhero-themed party ideas, including decorations, entertainment, and catering.&quot;</span>
)
<span class="hljs-built_in">print</span>(response)`,wrap:!1}}),A=new S({props:{title:"Custom Knowledge Base Tool",local:"custom-knowledge-base-tool",headingTag:"h2"}}),v=new Rl({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> langchain.docstore.document <span class="hljs-keyword">import</span> Document
<span class="hljs-keyword">from</span> langchain.text_splitter <span class="hljs-keyword">import</span> RecursiveCharacterTextSplitter
<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> Tool
<span class="hljs-keyword">from</span> langchain_community.retrievers <span class="hljs-keyword">import</span> BM25Retriever
<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent, HfApiModel

<span class="hljs-keyword">class</span> <span class="hljs-title class_">PartyPlanningRetrieverTool</span>(<span class="hljs-title class_ inherited__">Tool</span>):
    name = <span class="hljs-string">&quot;party_planning_retriever&quot;</span>
    description = <span class="hljs-string">&quot;Uses semantic search to retrieve relevant party planning ideas for Alfred’s superhero-themed party at Wayne Manor.&quot;</span>
    inputs = {
        <span class="hljs-string">&quot;query&quot;</span>: {
            <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>,
            <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;The query to perform. This should be a query related to party planning or superhero themes.&quot;</span>,
        }
    }
    output_type = <span class="hljs-string">&quot;string&quot;</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, docs, **kwargs</span>):
        <span class="hljs-built_in">super</span>().__init__(**kwargs)
        self.retriever = BM25Retriever.from_documents(
            docs, k=<span class="hljs-number">5</span>  <span class="hljs-comment"># Retrieve the top 5 documents</span>
        )

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, query: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
        <span class="hljs-keyword">assert</span> <span class="hljs-built_in">isinstance</span>(query, <span class="hljs-built_in">str</span>), <span class="hljs-string">&quot;Your search query must be a string&quot;</span>

        docs = self.retriever.invoke(
            query,
        )
        <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;\\nRetrieved ideas:\\n&quot;</span> + <span class="hljs-string">&quot;&quot;</span>.join(
            [
                <span class="hljs-string">f&quot;\\n\\n===== Idea <span class="hljs-subst">{<span class="hljs-built_in">str</span>(i)}</span> =====\\n&quot;</span> + doc.page_content
                <span class="hljs-keyword">for</span> i, doc <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(docs)
            ]
        )

<span class="hljs-comment"># Simulate a knowledge base about party planning</span>
party_ideas = [
    {<span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;A superhero-themed masquerade ball with luxury decor, including gold accents and velvet curtains.&quot;</span>, <span class="hljs-string">&quot;source&quot;</span>: <span class="hljs-string">&quot;Party Ideas 1&quot;</span>},
    {<span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;Hire a professional DJ who can play themed music for superheroes like Batman and Wonder Woman.&quot;</span>, <span class="hljs-string">&quot;source&quot;</span>: <span class="hljs-string">&quot;Entertainment Ideas&quot;</span>},
    {<span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;For catering, serve dishes named after superheroes, like &#x27;The Hulk&#x27;s Green Smoothie&#x27; and &#x27;Iron Man&#x27;s Power Steak.&#x27;&quot;</span>, <span class="hljs-string">&quot;source&quot;</span>: <span class="hljs-string">&quot;Catering Ideas&quot;</span>},
    {<span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;Decorate with iconic superhero logos and projections of Gotham and other superhero cities around the venue.&quot;</span>, <span class="hljs-string">&quot;source&quot;</span>: <span class="hljs-string">&quot;Decoration Ideas&quot;</span>},
    {<span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;Interactive experiences with VR where guests can engage in superhero simulations or compete in themed games.&quot;</span>, <span class="hljs-string">&quot;source&quot;</span>: <span class="hljs-string">&quot;Entertainment Ideas&quot;</span>}
]

source_docs = [
    Document(page_content=doc[<span class="hljs-string">&quot;text&quot;</span>], metadata={<span class="hljs-string">&quot;source&quot;</span>: doc[<span class="hljs-string">&quot;source&quot;</span>]})
    <span class="hljs-keyword">for</span> doc <span class="hljs-keyword">in</span> party_ideas
]

<span class="hljs-comment"># Split the documents into smaller chunks for more efficient search</span>
text_splitter = RecursiveCharacterTextSplitter(
    chunk_size=<span class="hljs-number">500</span>,
    chunk_overlap=<span class="hljs-number">50</span>,
    add_start_index=<span class="hljs-literal">True</span>,
    strip_whitespace=<span class="hljs-literal">True</span>,
    separators=[<span class="hljs-string">&quot;\\n\\n&quot;</span>, <span class="hljs-string">&quot;\\n&quot;</span>, <span class="hljs-string">&quot;.&quot;</span>, <span class="hljs-string">&quot; &quot;</span>, <span class="hljs-string">&quot;&quot;</span>],
)
docs_processed = text_splitter.split_documents(source_docs)

<span class="hljs-comment"># Create the retriever tool</span>
party_planning_retriever = PartyPlanningRetrieverTool(docs_processed)

<span class="hljs-comment"># Initialize the agent</span>
agent = CodeAgent(tools=[party_planning_retriever], model=HfApiModel())

<span class="hljs-comment"># Example usage</span>
response = agent.run(
    <span class="hljs-string">&quot;Find ideas for a luxury superhero-themed party, including entertainment, catering, and decoration options.&quot;</span>
)

<span class="hljs-built_in">print</span>(response)`,wrap:!1}}),R=new S({props:{title:"Enhanced Retrieval Capabilities",local:"enhanced-retrieval-capabilities",headingTag:"h2"}}),Q=new S({props:{title:"Resources",local:"resources",headingTag:"h2"}}),X=new Nl({props:{source:"https://github.com/huggingface/agents-course/blob/main/units/en/unit2/smolagents/retrieval_agents.mdx"}}),{c(){r=i("meta"),x=n(),q=i("p"),z=n(),c(h.$$.fragment),H=n(),m=i("p"),m.textContent=dl,_=n(),U=i("p"),U.textContent=hl,F=n(),c(J.$$.fragment),$=n(),w=i("p"),w.textContent=ml,Y=n(),T=i("ul"),T.innerHTML=Ul,D=n(),b=i("p"),b.textContent=Jl,L=n(),c(g.$$.fragment),P=n(),I=i("p"),I.textContent=wl,K=n(),B=i("ol"),B.innerHTML=Tl,O=n(),c(A.$$.fragment),ll=n(),f=i("p"),f.textContent=bl,el=n(),C=i("p"),C.textContent=gl,tl=n(),c(v.$$.fragment),sl=n(),G=i("p"),G.textContent=Il,nl=n(),Z=i("ol"),Z.innerHTML=Bl,al=n(),c(R.$$.fragment),il=n(),k=i("p"),k.textContent=Al,Ml=n(),V=i("ol"),V.innerHTML=fl,ol=n(),E=i("p"),E.textContent=Cl,rl=n(),c(Q.$$.fragment),cl=n(),W=i("ul"),W.innerHTML=vl,yl=n(),c(X.$$.fragment),pl=n(),N=i("p"),this.h()},l(l){const e=Xl("svelte-u9bgzb",document.head);r=M(e,"META",{name:!0,content:!0}),e.forEach(t),x=a(l),q=M(l,"P",{}),Gl(q).forEach(t),z=a(l),y(h.$$.fragment,l),H=a(l),m=M(l,"P",{"data-svelte-h":!0}),o(m)!=="svelte-1sadypi"&&(m.textContent=dl),_=a(l),U=M(l,"P",{"data-svelte-h":!0}),o(U)!=="svelte-1vax993"&&(U.textContent=hl),F=a(l),y(J.$$.fragment,l),$=a(l),w=M(l,"P",{"data-svelte-h":!0}),o(w)!=="svelte-1uinlt6"&&(w.textContent=ml),Y=a(l),T=M(l,"UL",{"data-svelte-h":!0}),o(T)!=="svelte-4vqfph"&&(T.innerHTML=Ul),D=a(l),b=M(l,"P",{"data-svelte-h":!0}),o(b)!=="svelte-jm6fh2"&&(b.textContent=Jl),L=a(l),y(g.$$.fragment,l),P=a(l),I=M(l,"P",{"data-svelte-h":!0}),o(I)!=="svelte-21wqo5"&&(I.textContent=wl),K=a(l),B=M(l,"OL",{"data-svelte-h":!0}),o(B)!=="svelte-sf2q8s"&&(B.innerHTML=Tl),O=a(l),y(A.$$.fragment,l),ll=a(l),f=M(l,"P",{"data-svelte-h":!0}),o(f)!=="svelte-1jei959"&&(f.textContent=bl),el=a(l),C=M(l,"P",{"data-svelte-h":!0}),o(C)!=="svelte-10x3i2g"&&(C.textContent=gl),tl=a(l),y(v.$$.fragment,l),sl=a(l),G=M(l,"P",{"data-svelte-h":!0}),o(G)!=="svelte-17lgk8z"&&(G.textContent=Il),nl=a(l),Z=M(l,"OL",{"data-svelte-h":!0}),o(Z)!=="svelte-19rqcrr"&&(Z.innerHTML=Bl),al=a(l),y(R.$$.fragment,l),il=a(l),k=M(l,"P",{"data-svelte-h":!0}),o(k)!=="svelte-gryz7r"&&(k.textContent=Al),Ml=a(l),V=M(l,"OL",{"data-svelte-h":!0}),o(V)!=="svelte-1pxkx51"&&(V.innerHTML=fl),ol=a(l),E=M(l,"P",{"data-svelte-h":!0}),o(E)!=="svelte-1c0e5ah"&&(E.textContent=Cl),rl=a(l),y(Q.$$.fragment,l),cl=a(l),W=M(l,"UL",{"data-svelte-h":!0}),o(W)!=="svelte-1myvltt"&&(W.innerHTML=vl),yl=a(l),y(X.$$.fragment,l),pl=a(l),N=M(l,"P",{}),Gl(N).forEach(t),this.h()},h(){Zl(r,"name","hf:doc:metadata"),Zl(r,"content",xl)},m(l,e){ql(document.head,r),s(l,x,e),s(l,q,e),s(l,z,e),p(h,l,e),s(l,H,e),s(l,m,e),s(l,_,e),s(l,U,e),s(l,F,e),p(J,l,e),s(l,$,e),s(l,w,e),s(l,Y,e),s(l,T,e),s(l,D,e),s(l,b,e),s(l,L,e),p(g,l,e),s(l,P,e),s(l,I,e),s(l,K,e),s(l,B,e),s(l,O,e),p(A,l,e),s(l,ll,e),s(l,f,e),s(l,el,e),s(l,C,e),s(l,tl,e),p(v,l,e),s(l,sl,e),s(l,G,e),s(l,nl,e),s(l,Z,e),s(l,al,e),p(R,l,e),s(l,il,e),s(l,k,e),s(l,Ml,e),s(l,V,e),s(l,ol,e),s(l,E,e),s(l,rl,e),p(Q,l,e),s(l,cl,e),s(l,W,e),s(l,yl,e),p(X,l,e),s(l,pl,e),s(l,N,e),jl=!0},p:Vl,i(l){jl||(j(h.$$.fragment,l),j(J.$$.fragment,l),j(g.$$.fragment,l),j(A.$$.fragment,l),j(v.$$.fragment,l),j(R.$$.fragment,l),j(Q.$$.fragment,l),j(X.$$.fragment,l),jl=!0)},o(l){u(h.$$.fragment,l),u(J.$$.fragment,l),u(g.$$.fragment,l),u(A.$$.fragment,l),u(v.$$.fragment,l),u(R.$$.fragment,l),u(Q.$$.fragment,l),u(X.$$.fragment,l),jl=!1},d(l){l&&(t(x),t(q),t(z),t(H),t(m),t(_),t(U),t(F),t($),t(w),t(Y),t(T),t(D),t(b),t(L),t(P),t(I),t(K),t(B),t(O),t(ll),t(f),t(el),t(C),t(tl),t(sl),t(G),t(nl),t(Z),t(al),t(il),t(k),t(Ml),t(V),t(ol),t(E),t(rl),t(cl),t(W),t(yl),t(pl),t(N)),t(r),d(h,l),d(J,l),d(g,l),d(A,l),d(v,l),d(R,l),d(Q,l),d(X,l)}}}const xl='{"title":"Building Agentic RAG Systems","local":"building-agentic-rag-systems","sections":[{"title":"Basic Retrieval with DuckDuckGo","local":"basic-retrieval-with-duckduckgo","sections":[],"depth":2},{"title":"Custom Knowledge Base Tool","local":"custom-knowledge-base-tool","sections":[],"depth":2},{"title":"Enhanced Retrieval Capabilities","local":"enhanced-retrieval-capabilities","sections":[],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2}],"depth":1}';function zl(ul){return El(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Dl extends Ql{constructor(r){super(),Wl(this,r,zl,Sl,kl,{})}}export{Dl as component};
