import{s as Ys,f as _e,n as ks,o as Xs}from"../chunks/scheduler.37c15a92.js";import{S as qs,i as zs,g as i,s as M,r as a,A as Ps,h as J,f as e,c as n,j as xe,u as p,x as T,k as I,y as He,a as s,v as U,d as w,t as y,w as j}from"../chunks/index.2bf4358c.js";import{C}from"../chunks/CodeBlock.4e987730.js";import{H as kt}from"../chunks/Heading.8ada512a.js";import{E as Ds}from"../chunks/getInferenceSnippets.42ccd5ac.js";function Os(Ge){let u,Pt,qt,Dt,o,Ot,c,Le,Kt,r,$e="AI 智能体的关键能力在于执行<strong>行动</strong>。正如前文所述，这通过<strong>工具</strong>的使用实现。",tl,f,ge="本节将学习工具的定义、有效设计方法，以及如何通过系统消息将其集成到智能体中。",ll,A,Re="通过为智能体配备合适的工具——并清晰描述这些工具的工作原理——可显著提升 AI 的能力边界。让我们深入探讨！",el,d,sl,b,Se="<strong>工具是赋予 LLM 的函数</strong>，该函数应实现<strong>明确的目标</strong>。",Ml,B,We="以下是 AI 智能体中常用的工具示例：",nl,v,Ne="<thead><tr><th>工具类型</th> <th>描述</th></tr></thead> <tbody><tr><td>网络搜索</td> <td>允许智能体从互联网获取最新信息</td></tr> <tr><td>图像生成</td> <td>根据文本描述生成图像</td></tr> <tr><td>信息检索</td> <td>从外部源检索信息</td></tr> <tr><td>API 接口</td> <td>与外部 API 交互（GitHub、YouTube、Spotify 等）</td></tr></tbody>",il,h,Qe="以上仅为示例，实际可为任何用例创建工具！",Jl,_,Ee="优秀工具应能<strong>补充 LLM 的核心能力</strong>。",Tl,V,Ze="例如，若需执行算术运算，为 LLM 提供<strong>计算器工具</strong>将比依赖模型原生能力获得更好结果。",al,x,Fe="此外，<strong>LLM 基于训练数据预测提示的补全</strong>，意味着其内部知识仅包含训练截止前的信息。因此，若智能体需要最新数据，必须通过工具获取。",pl,H,Ye="例如，若直接询问 LLM（无搜索工具）今日天气，LLM 可能会产生随机幻觉。",Ul,G,ke,wl,L,Xe="<li>合格工具应包含：<ul><li><strong>函数功能的文本描述</strong></li> <li><em>可调用对象</em>（执行操作的实体）</li> <li>带类型声明的<em>参数</em></li> <li>（可选）带类型声明的输出</li></ul></li>",yl,$,jl,g,qe="正如前文所述，LLM 只能接收文本输入并生成文本输出。它们无法自行调用工具。当我们谈及<em>为智能体提供工具</em>时，实质是<strong>教导</strong> LLM 认识工具的存在，并要求模型在需要时生成调用工具的文本。例如，若我们提供从互联网获取某地天气的工具，当询问 LLM 巴黎天气时，LLM 将识别该问题适合使用我们教授的”天气”工具，并生成代码形式的文本来调用该工具。<strong>智能体</strong>负责解析 LLM 的输出，识别工具调用需求，并执行工具调用。工具的输出将返回给 LLM，由其生成最终用户响应。",Il,R,ze="工具调用的输出是对话中的另一种消息类型。工具调用步骤通常对用户不可见：智能体检索对话、调用工具、获取输出、将其作为新消息添加，并将更新后的对话再次发送给 LLM。从用户视角看，仿佛 LLM 直接使用了工具，但实际执行的是我们的应用代码（<strong>智能体</strong>）。",ul,S,Pe="后续课程将深入探讨该流程。",Cl,W,ml,N,De="完整答案可能看似复杂，但核心是通过系统提示（system prompt）向模型文本化描述可用工具：",ol,Q,Oe,cl,E,Ke="为确保有效性，必须精准描述：",rl,Z,ts="<li><strong>工具功能</strong></li> <li><strong>预期输入格式</strong></li>",fl,F,ls="因此工具描述通常采用结构化表达方式（如编程语言或 JSON）。虽非强制，但任何精确、连贯的格式均可。",Al,Y,es="若觉抽象，我们通过具体示例理解。",dl,k,ss="我们将实现简化的<strong>计算器</strong>工具，仅执行两整数相乘。Python 实现如下：",bl,X,Bl,q,Ms="因此我们的工具名为<code>calculator</code>，其功能是<strong>将两个整数相乘</strong>，需要以下输入：",vl,z,ns="<li><strong><code>a</code></strong>（<em>int</em>）：整数</li> <li><strong><code>b</code></strong>（<em>int</em>）：整数</li>",hl,P,is="工具输出为另一个整数，描述如下：",_l,D,Js="<li>（<em>int</em>）：<code>a</code>与<code>b</code>的乘积</li>",Vl,O,Ts="所有这些细节都至关重要。让我们将这些信息整合成 LLM 可理解的工具描述文本：",xl,K,Hl,tt,as="<p><strong>重要提示：</strong> 此文本描述是<em>我们希望 LLM 了解的工具体系</em>。</p>",Gl,lt,ps="当我们将上述字符串作为输入的一部分传递给 LLM 时，模型将识别其为工具，并知晓需要传递的输入参数及预期输出。",Ll,et,Us="若需提供更多工具，必须保持格式一致性。此过程可能较为脆弱，容易遗漏某些细节。",$l,st,ws="是否有更好的方法？",gl,Mt,Rl,nt,ys="我们的工具采用 Python 实现，其代码已包含所需全部信息：",Sl,it,js="<li>功能描述性名称：<code>calculator</code></li> <li>详细说明（通过函数文档字符串实现）：<code>将两个整数相乘</code></li> <li>输入参数及类型：函数明确要求两个<code>int</code>类型参数</li> <li>输出类型</li>",Wl,Jt,Is="这正是人们使用编程语言的原因：表达力强、简洁且精确。",Nl,Tt,us="虽然可以将 Python 源代码作为工具规范提供给 LLM，但具体实现方式并不重要。关键在于工具名称、功能描述、输入参数和输出类型。",Ql,at,Cs="我们将利用 Python 的<strong>自省特性</strong>，通过源代码自动构建工具描述。只需确保工具实现满足：",El,pt,ms="<li>使用类型注解（Type Hints）</li> <li>编写文档字符串（Docstrings）</li> <li>采用合理的函数命名</li>",Zl,Ut,os="完成这些之后，我们只需使用一个 Python 装饰器来指示<code>calculator</code>函数是一个工具：",Fl,wt,Yl,yt,cs="注意函数定义前的<code>@tool</code>装饰器。",kl,jt,rs="通过我们即将看到的实现，可以利用装饰器提供的<code>to_string()</code>方法从源代码自动提取以下文本：",Xl,It,ql,ut,fs="正如所见，这与我们之前手动编写的内容完全一致！",zl,Ct,Pl,mt,As="我们创建通用<code>Tool</code>类，可在需要时重复使用：",Dl,ot,ds="<p><strong>说明：</strong> 此示例实现为虚构代码，但高度模拟了主流工具库的实际实现方式。</p>",Ol,ct,Kl,rt,bs="虽然看似复杂，但逐步解析即可理解其工作机制。我们定义的<strong><code>Tool</code></strong>类包含以下核心要素：",te,ft,Bs="<li><strong><code>name</code></strong>（<em>str</em>）：工具名称</li> <li><strong><code>description</code></strong>（<em>str</em>）：工具功能简述</li> <li><strong><code>function</code></strong>（<em>callable</em>）：工具执行的函数</li> <li><strong><code>arguments</code></strong>（<em>list</em>）：预期输入参数列表</li> <li><strong><code>outputs</code></strong>（<em>str</em> 或 <em>list</em>）：工具预期输出</li> <li><strong><code>__call__()</code></strong>：调用工具实例时执行函数</li> <li><strong><code>to_string()</code></strong>：将工具属性转换为文本描述</li>",le,At,vs="可通过如下代码创建工具实例：",ee,dt,se,bt,hs="但我们可以利用 Python 的<code>inspect</code>模块自动提取这些信息！这正是<code>@tool</code>装饰器的实现原理。",Me,Bt,_s="<p>若感兴趣，可展开以下内容查看装饰器具体实现：</p>",ne,m,Xt,Vs="decorator code",Ve,vt,ie,ht,xs="简而言之，在应用此装饰器后，我们可以按如下方式实现工具：",Je,_t,Te,Vt,Hs="我们可以使用<code>Tool</code>类的<code>to_string</code>方法自动生成适合LLM使用的工具描述文本：",ae,xt,pe,Ht,Gs="该描述将被<strong>注入</strong>系统提示。以本节初始示例为例，替换<code>tools_description</code>后的系统提示如下：",Ue,Gt,Ls,we,Lt,$s='在<a href="actions">Actions</a>章节，我们将深入探讨智能体如何<strong>调用</strong>刚创建的这个工具。',ye,$t,je,gt,gs="模型上下文协议（MCP）是一种开放式协议，它规范了应用程序向 LLM 提工具的方式。",Ie,Rt,Rs="MCP 提供",ue,St,Ss="<li>不断增加的预构建集成列表，您的 LLM 可以直接接入这些集成</li> <li>在 LLM 提供商和供应商之间灵活切换的能力</li> <li>在基础设施内保护数据安全的最佳实践</li>",Ce,Wt,Ws="这意味着任何实施 MCP 的框架都可以利用协议中定义的工具，从而无需为每个框架重新实现相同的工具接口。",me,oe,ce,Nt,Ns="工具在增强AI智能体能力方面至关重要。",re,Qt,Qs="总结本节要点：",fe,Et,Es="<li><p><em>工具定义</em>：通过提供清晰的文本描述、输入参数、输出结果及可调用函数</p></li> <li><p><em>工具本质</em>：赋予LLM额外能力的函数（如执行计算或访问外部数据）</p></li> <li><p><em>工具必要性</em>：帮助智能体突破静态模型训练的局限，处理实时任务并执行专业操作</p></li>",Ae,Zt,Zs="现在进入【智能体工作流】(agent-steps-and-structure)章节，您将看到智能体如何观察、思考与行动。这<strong>整合了当前所学全部内容</strong>，为创建功能完备的 AI 智能体奠定基础。",de,Ft,Fs="但在此之前，让我们先完成另一个简短测验！",be,Yt,Be,zt,ve;return o=new kt({props:{title:"什么是工具？",local:"什么是工具",headingTag:"h1"}}),d=new kt({props:{title:"AI 工具的定义",local:"ai-工具的定义",headingTag:"h2"}}),$=new kt({props:{title:"工具如何运作？",local:"工具如何运作",headingTag:"h2"}}),W=new kt({props:{title:"如何为 LLM 提供工具？",local:"如何为-llm-提供工具",headingTag:"h2"}}),X=new C({props:{code:"ZGVmJTIwY2FsY3VsYXRvcihhJTNBJTIwaW50JTJDJTIwYiUzQSUyMGludCklMjAtJTNFJTIwaW50JTNBJTBBJTIwJTIwJTIwJTIwJTIyJTIyJTIyTXVsdGlwbHklMjB0d28lMjBpbnRlZ2Vycy4lMjIlMjIlMjIlMEElMjAlMjAlMjAlMjByZXR1cm4lMjBhJTIwKiUyMGI=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">calculator</span>(<span class="hljs-params">a: <span class="hljs-built_in">int</span>, b: <span class="hljs-built_in">int</span></span>) -&gt; <span class="hljs-built_in">int</span>:
    <span class="hljs-string">&quot;&quot;&quot;Multiply two integers.&quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> a * b`,wrap:!1}}),K=new C({props:{code:"JUU1JUI3JUE1JUU1JTg1JUI3JUU1JTkwJThEJUU3JUE3JUIwJUVGJUJDJTlBJTIwY2FsY3VsYXRvciVFRiVCQyU4QyVFNiU4RiU4RiVFOCVCRiVCMCVFRiVCQyU5QSVFNSVCMCU4NiVFNCVCOCVBNCVFNCVCOCVBQSVFNiU5NSVCNCVFNiU5NSVCMCVFNyU5QiVCOCVFNCVCOSU5OCVFMyU4MCU4MiVFNSU4RiU4MiVFNiU5NSVCMCVFRiVCQyU5QWElM0ElMjBpbnQlMkMlMjBiJTNBJTIwaW50JUVGJUJDJThDJUU4JUJFJTkzJUU1JTg3JUJBJUVGJUJDJTlBaW50",highlighted:"工具名称： calculator，描述：将两个整数相乘。参数：a: int, b: int，输出：int",wrap:!1}}),Mt=new kt({props:{title:"自动化工具描述生成",local:"自动化工具描述生成",headingTag:"h3"}}),wt=new C({props:{code:"JTQwdG9vbCUwQWRlZiUyMGNhbGN1bGF0b3IoYSUzQSUyMGludCUyQyUyMGIlM0ElMjBpbnQpJTIwLSUzRSUyMGludCUzQSUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMk11bHRpcGx5JTIwdHdvJTIwaW50ZWdlcnMuJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwYSUyMColMjBiJTBBJTBBcHJpbnQoY2FsY3VsYXRvci50b19zdHJpbmcoKSk=",highlighted:`<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">calculator</span>(<span class="hljs-params">a: <span class="hljs-built_in">int</span>, b: <span class="hljs-built_in">int</span></span>) -&gt; <span class="hljs-built_in">int</span>:
    <span class="hljs-string">&quot;&quot;&quot;Multiply two integers.&quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> a * b

<span class="hljs-built_in">print</span>(calculator.to_string())`,wrap:!1}}),It=new C({props:{code:"JUU1JUI3JUE1JUU1JTg1JUI3JUU1JTkwJThEJUU3JUE3JUIwJUVGJUJDJTlBJTIwY2FsY3VsYXRvciVFRiVCQyU4QyVFNiU4RiU4RiVFOCVCRiVCMCVFRiVCQyU5QSVFNSVCMCU4NiVFNCVCOCVBNCVFNCVCOCVBQSVFNiU5NSVCNCVFNiU5NSVCMCVFNyU5QiVCOCVFNCVCOSU5OCVFMyU4MCU4MiVFNSU4RiU4MiVFNiU5NSVCMCVFRiVCQyU5QWElM0ElMjBpbnQlMkMlMjBiJTNBJTIwaW50JUVGJUJDJThDJUU4JUJFJTkzJUU1JTg3JUJBJUVGJUJDJTlBaW50",highlighted:"工具名称： calculator，描述：将两个整数相乘。参数：a: int, b: int，输出：int",wrap:!1}}),Ct=new kt({props:{title:"通用工具类实现",local:"通用工具类实现",headingTag:"h3"}}),ct=new C({props:{code:"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",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">Tool</span>:
    <span class="hljs-string">&quot;&quot;&quot;
    A class representing a reusable piece of code (Tool).
    
    Attributes:
        name (str): Name of the tool.
        description (str): A textual description of what the tool does.
        func (callable): The function this tool wraps.
        arguments (list): A list of argument.
        outputs (str or list): The return type(s) of the wrapped function.
    &quot;&quot;&quot;</span>
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, 
                 name: <span class="hljs-built_in">str</span>, 
                 description: <span class="hljs-built_in">str</span>, 
                 func: <span class="hljs-built_in">callable</span>, 
                 arguments: <span class="hljs-built_in">list</span>,
                 outputs: <span class="hljs-built_in">str</span></span>):
        self.name = name
        self.description = description
        self.func = func
        self.arguments = arguments
        self.outputs = outputs

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">to_string</span>(<span class="hljs-params">self</span>) -&gt; <span class="hljs-built_in">str</span>:
        <span class="hljs-string">&quot;&quot;&quot;
        Return a string representation of the tool, 
        including its name, description, arguments, and outputs.
        &quot;&quot;&quot;</span>
        args_str = <span class="hljs-string">&quot;, &quot;</span>.join([
            <span class="hljs-string">f&quot;<span class="hljs-subst">{arg_name}</span>: <span class="hljs-subst">{arg_type}</span>&quot;</span> <span class="hljs-keyword">for</span> arg_name, arg_type <span class="hljs-keyword">in</span> self.arguments
        ])
        
        <span class="hljs-keyword">return</span> (
            <span class="hljs-string">f&quot;Tool Name: <span class="hljs-subst">{self.name}</span>,&quot;</span>
            <span class="hljs-string">f&quot; Description: <span class="hljs-subst">{self.description}</span>,&quot;</span>
            <span class="hljs-string">f&quot; Arguments: <span class="hljs-subst">{args_str}</span>,&quot;</span>
            <span class="hljs-string">f&quot; Outputs: <span class="hljs-subst">{self.outputs}</span>&quot;</span>
        )

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__call__</span>(<span class="hljs-params">self, *args, **kwargs</span>):
        <span class="hljs-string">&quot;&quot;&quot;
        Invoke the underlying function (callable) with provided arguments.
        &quot;&quot;&quot;</span>
        <span class="hljs-keyword">return</span> self.func(*args, **kwargs)`,wrap:!1}}),dt=new C({props:{code:"Y2FsY3VsYXRvcl90b29sJTIwJTNEJTIwVG9vbCglMEElMjAlMjAlMjAlMjAlMjJjYWxjdWxhdG9yJTIyJTJDJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwbmFtZSUwQSUyMCUyMCUyMCUyMCUyMk11bHRpcGx5JTIwdHdvJTIwaW50ZWdlcnMuJTIyJTJDJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwZGVzY3JpcHRpb24lMEElMjAlMjAlMjAlMjBjYWxjdWxhdG9yJTJDJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwZnVuY3Rpb24lMjB0byUyMGNhbGwlMEElMjAlMjAlMjAlMjAlNUIoJTIyYSUyMiUyQyUyMCUyMmludCUyMiklMkMlMjAoJTIyYiUyMiUyQyUyMCUyMmludCUyMiklNUQlMkMlMjAlMjAlMjAlMjMlMjBpbnB1dHMlMjAobmFtZXMlMjBhbmQlMjB0eXBlcyklMEElMjAlMjAlMjAlMjAlMjJpbnQlMjIlMkMlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBvdXRwdXQlMEEp",highlighted:`calculator_tool = Tool(
    <span class="hljs-string">&quot;calculator&quot;</span>,                   <span class="hljs-comment"># name</span>
    <span class="hljs-string">&quot;Multiply two integers.&quot;</span>,       <span class="hljs-comment"># description</span>
    calculator,                     <span class="hljs-comment"># function to call</span>
    [(<span class="hljs-string">&quot;a&quot;</span>, <span class="hljs-string">&quot;int&quot;</span>), (<span class="hljs-string">&quot;b&quot;</span>, <span class="hljs-string">&quot;int&quot;</span>)],   <span class="hljs-comment"># inputs (names and types)</span>
    <span class="hljs-string">&quot;int&quot;</span>,                          <span class="hljs-comment"># output</span>
)`,wrap:!1}}),vt=new C({props:{code:"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",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">tool</span>(<span class="hljs-params">func</span>):
    <span class="hljs-string">&quot;&quot;&quot;
    A decorator that creates a Tool instance from the given function.
    &quot;&quot;&quot;</span>
    <span class="hljs-comment"># Get the function signature</span>
    signature = inspect.signature(func)
    
    <span class="hljs-comment"># Extract (param_name, param_annotation) pairs for inputs</span>
    arguments = []
    <span class="hljs-keyword">for</span> param <span class="hljs-keyword">in</span> signature.parameters.values():
        annotation_name = (
            param.annotation.__name__ 
            <span class="hljs-keyword">if</span> <span class="hljs-built_in">hasattr</span>(param.annotation, <span class="hljs-string">&#x27;__name__&#x27;</span>) 
            <span class="hljs-keyword">else</span> <span class="hljs-built_in">str</span>(param.annotation)
        )
        arguments.append((param.name, annotation_name))
    
    <span class="hljs-comment"># Determine the return annotation</span>
    return_annotation = signature.return_annotation
    <span class="hljs-keyword">if</span> return_annotation <span class="hljs-keyword">is</span> inspect._empty:
        outputs = <span class="hljs-string">&quot;No return annotation&quot;</span>
    <span class="hljs-keyword">else</span>:
        outputs = (
            return_annotation.__name__ 
            <span class="hljs-keyword">if</span> <span class="hljs-built_in">hasattr</span>(return_annotation, <span class="hljs-string">&#x27;__name__&#x27;</span>) 
            <span class="hljs-keyword">else</span> <span class="hljs-built_in">str</span>(return_annotation)
        )
    
    <span class="hljs-comment"># Use the function&#x27;s docstring as the description (default if None)</span>
    description = func.__doc__ <span class="hljs-keyword">or</span> <span class="hljs-string">&quot;No description provided.&quot;</span>
    
    <span class="hljs-comment"># The function name becomes the Tool name</span>
    name = func.__name__
    
    <span class="hljs-comment"># Return a new Tool instance</span>
    <span class="hljs-keyword">return</span> Tool(
        name=name, 
        description=description, 
        func=func, 
        arguments=arguments, 
        outputs=outputs
    )`,wrap:!1}}),_t=new C({props:{code:"JTQwdG9vbCUwQWRlZiUyMGNhbGN1bGF0b3IoYSUzQSUyMGludCUyQyUyMGIlM0ElMjBpbnQpJTIwLSUzRSUyMGludCUzQSUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMk11bHRpcGx5JTIwdHdvJTIwaW50ZWdlcnMuJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwYSUyMColMjBiJTBBJTBBcHJpbnQoY2FsY3VsYXRvci50b19zdHJpbmcoKSk=",highlighted:`<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">calculator</span>(<span class="hljs-params">a: <span class="hljs-built_in">int</span>, b: <span class="hljs-built_in">int</span></span>) -&gt; <span class="hljs-built_in">int</span>:
    <span class="hljs-string">&quot;&quot;&quot;Multiply two integers.&quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> a * b

<span class="hljs-built_in">print</span>(calculator.to_string())`,wrap:!1}}),xt=new C({props:{code:"JUU1JUI3JUE1JUU1JTg1JUI3JUU1JTkwJThEJUU3JUE3JUIwJUVGJUJDJTlBJTIwY2FsY3VsYXRvciVFRiVCQyU4QyVFNiU4RiU4RiVFOCVCRiVCMCVFRiVCQyU5QSVFNSVCMCU4NiVFNCVCOCVBNCVFNCVCOCVBQSVFNiU5NSVCNCVFNiU5NSVCMCVFNyU5QiVCOCVFNCVCOSU5OCVFMyU4MCU4MiVFNSU4RiU4MiVFNiU5NSVCMCVFRiVCQyU5QWElM0ElMjBpbnQlMkMlMjBiJTNBJTIwaW50JUVGJUJDJThDJUU4JUJFJTkzJUU1JTg3JUJBJUVGJUJDJTlBaW50",highlighted:"工具名称： calculator，描述：将两个整数相乘。参数：a: int, b: int，输出：int",wrap:!1}}),$t=new kt({props:{title:"模型上下文协议（MCP）：统一的工具接口",local:"模型上下文协议mcp统一的工具接口",headingTag:"h3"}}),Yt=new Ds({props:{source:"https://github.com/huggingface/agents-course/blob/main/units/zh-CN/unit1/tools.mdx"}}),{c(){u=i("meta"),Pt=M(),qt=i("p"),Dt=M(),a(o.$$.fragment),Ot=M(),c=i("img"),Kt=M(),r=i("p"),r.innerHTML=$e,tl=M(),f=i("p"),f.textContent=ge,ll=M(),A=i("p"),A.textContent=Re,el=M(),a(d.$$.fragment),sl=M(),b=i("p"),b.innerHTML=Se,Ml=M(),B=i("p"),B.textContent=We,nl=M(),v=i("table"),v.innerHTML=Ne,il=M(),h=i("p"),h.textContent=Qe,Jl=M(),_=i("p"),_.innerHTML=Ee,Tl=M(),V=i("p"),V.innerHTML=Ze,al=M(),x=i("p"),x.innerHTML=Fe,pl=M(),H=i("p"),H.textContent=Ye,Ul=M(),G=i("img"),wl=M(),L=i("ul"),L.innerHTML=Xe,yl=M(),a($.$$.fragment),jl=M(),g=i("p"),g.innerHTML=qe,Il=M(),R=i("p"),R.innerHTML=ze,ul=M(),S=i("p"),S.textContent=Pe,Cl=M(),a(W.$$.fragment),ml=M(),N=i("p"),N.textContent=De,ol=M(),Q=i("img"),cl=M(),E=i("p"),E.textContent=Ke,rl=M(),Z=i("ol"),Z.innerHTML=ts,fl=M(),F=i("p"),F.textContent=ls,Al=M(),Y=i("p"),Y.textContent=es,dl=M(),k=i("p"),k.innerHTML=ss,bl=M(),a(X.$$.fragment),Bl=M(),q=i("p"),q.innerHTML=Ms,vl=M(),z=i("ul"),z.innerHTML=ns,hl=M(),P=i("p"),P.textContent=is,_l=M(),D=i("ul"),D.innerHTML=Js,Vl=M(),O=i("p"),O.textContent=Ts,xl=M(),a(K.$$.fragment),Hl=M(),tt=i("blockquote"),tt.innerHTML=as,Gl=M(),lt=i("p"),lt.textContent=ps,Ll=M(),et=i("p"),et.textContent=Us,$l=M(),st=i("p"),st.textContent=ws,gl=M(),a(Mt.$$.fragment),Rl=M(),nt=i("p"),nt.textContent=ys,Sl=M(),it=i("ul"),it.innerHTML=js,Wl=M(),Jt=i("p"),Jt.textContent=Is,Nl=M(),Tt=i("p"),Tt.textContent=us,Ql=M(),at=i("p"),at.innerHTML=Cs,El=M(),pt=i("ol"),pt.innerHTML=ms,Zl=M(),Ut=i("p"),Ut.innerHTML=os,Fl=M(),a(wt.$$.fragment),Yl=M(),yt=i("p"),yt.innerHTML=cs,kl=M(),jt=i("p"),jt.innerHTML=rs,Xl=M(),a(It.$$.fragment),ql=M(),ut=i("p"),ut.textContent=fs,zl=M(),a(Ct.$$.fragment),Pl=M(),mt=i("p"),mt.innerHTML=As,Dl=M(),ot=i("blockquote"),ot.innerHTML=ds,Ol=M(),a(ct.$$.fragment),Kl=M(),rt=i("p"),rt.innerHTML=bs,te=M(),ft=i("ul"),ft.innerHTML=Bs,le=M(),At=i("p"),At.textContent=vs,ee=M(),a(dt.$$.fragment),se=M(),bt=i("p"),bt.innerHTML=hs,Me=M(),Bt=i("blockquote"),Bt.innerHTML=_s,ne=M(),m=i("details"),Xt=i("summary"),Xt.textContent=Vs,Ve=M(),a(vt.$$.fragment),ie=M(),ht=i("p"),ht.textContent=xs,Je=M(),a(_t.$$.fragment),Te=M(),Vt=i("p"),Vt.innerHTML=Hs,ae=M(),a(xt.$$.fragment),pe=M(),Ht=i("p"),Ht.innerHTML=Gs,Ue=M(),Gt=i("img"),we=M(),Lt=i("p"),Lt.innerHTML=$s,ye=M(),a($t.$$.fragment),je=M(),gt=i("p"),gt.textContent=gs,Ie=M(),Rt=i("p"),Rt.textContent=Rs,ue=M(),St=i("ul"),St.innerHTML=Ss,Ce=M(),Wt=i("p"),Wt.textContent=Ws,me=M(),oe=i("hr"),ce=M(),Nt=i("p"),Nt.textContent=Ns,re=M(),Qt=i("p"),Qt.textContent=Qs,fe=M(),Et=i("ul"),Et.innerHTML=Es,Ae=M(),Zt=i("p"),Zt.innerHTML=Zs,de=M(),Ft=i("p"),Ft.textContent=Fs,be=M(),a(Yt.$$.fragment),Be=M(),zt=i("p"),this.h()},l(t){const l=Ps("svelte-u9bgzb",document.head);u=J(l,"META",{name:!0,content:!0}),l.forEach(e),Pt=n(t),qt=J(t,"P",{}),xe(qt).forEach(e),Dt=n(t),p(o.$$.fragment,t),Ot=n(t),c=J(t,"IMG",{src:!0,alt:!0}),Kt=n(t),r=J(t,"P",{"data-svelte-h":!0}),T(r)!=="svelte-17ryze0"&&(r.innerHTML=$e),tl=n(t),f=J(t,"P",{"data-svelte-h":!0}),T(f)!=="svelte-unb833"&&(f.textContent=ge),ll=n(t),A=J(t,"P",{"data-svelte-h":!0}),T(A)!=="svelte-9yhgs8"&&(A.textContent=Re),el=n(t),p(d.$$.fragment,t),sl=n(t),b=J(t,"P",{"data-svelte-h":!0}),T(b)!=="svelte-1aa38wx"&&(b.innerHTML=Se),Ml=n(t),B=J(t,"P",{"data-svelte-h":!0}),T(B)!=="svelte-13jcl91"&&(B.textContent=We),nl=n(t),v=J(t,"TABLE",{"data-svelte-h":!0}),T(v)!=="svelte-1thxl9n"&&(v.innerHTML=Ne),il=n(t),h=J(t,"P",{"data-svelte-h":!0}),T(h)!=="svelte-vjlut0"&&(h.textContent=Qe),Jl=n(t),_=J(t,"P",{"data-svelte-h":!0}),T(_)!=="svelte-qio42u"&&(_.innerHTML=Ee),Tl=n(t),V=J(t,"P",{"data-svelte-h":!0}),T(V)!=="svelte-19t1t38"&&(V.innerHTML=Ze),al=n(t),x=J(t,"P",{"data-svelte-h":!0}),T(x)!=="svelte-16qwbai"&&(x.innerHTML=Fe),pl=n(t),H=J(t,"P",{"data-svelte-h":!0}),T(H)!=="svelte-wej4tn"&&(H.textContent=Ye),Ul=n(t),G=J(t,"IMG",{src:!0,alt:!0}),wl=n(t),L=J(t,"UL",{"data-svelte-h":!0}),T(L)!=="svelte-1gravbu"&&(L.innerHTML=Xe),yl=n(t),p($.$$.fragment,t),jl=n(t),g=J(t,"P",{"data-svelte-h":!0}),T(g)!=="svelte-12jxsim"&&(g.innerHTML=qe),Il=n(t),R=J(t,"P",{"data-svelte-h":!0}),T(R)!=="svelte-snxi96"&&(R.innerHTML=ze),ul=n(t),S=J(t,"P",{"data-svelte-h":!0}),T(S)!=="svelte-1hdjy5n"&&(S.textContent=Pe),Cl=n(t),p(W.$$.fragment,t),ml=n(t),N=J(t,"P",{"data-svelte-h":!0}),T(N)!=="svelte-1ff4lej"&&(N.textContent=De),ol=n(t),Q=J(t,"IMG",{src:!0,alt:!0}),cl=n(t),E=J(t,"P",{"data-svelte-h":!0}),T(E)!=="svelte-16laj74"&&(E.textContent=Ke),rl=n(t),Z=J(t,"OL",{"data-svelte-h":!0}),T(Z)!=="svelte-1tpbip8"&&(Z.innerHTML=ts),fl=n(t),F=J(t,"P",{"data-svelte-h":!0}),T(F)!=="svelte-wb23bw"&&(F.textContent=ls),Al=n(t),Y=J(t,"P",{"data-svelte-h":!0}),T(Y)!=="svelte-1m7zv8m"&&(Y.textContent=es),dl=n(t),k=J(t,"P",{"data-svelte-h":!0}),T(k)!=="svelte-s27nen"&&(k.innerHTML=ss),bl=n(t),p(X.$$.fragment,t),Bl=n(t),q=J(t,"P",{"data-svelte-h":!0}),T(q)!=="svelte-8d5fqg"&&(q.innerHTML=Ms),vl=n(t),z=J(t,"UL",{"data-svelte-h":!0}),T(z)!=="svelte-pa7kfx"&&(z.innerHTML=ns),hl=n(t),P=J(t,"P",{"data-svelte-h":!0}),T(P)!=="svelte-vzbqgj"&&(P.textContent=is),_l=n(t),D=J(t,"UL",{"data-svelte-h":!0}),T(D)!=="svelte-1p3g0zg"&&(D.innerHTML=Js),Vl=n(t),O=J(t,"P",{"data-svelte-h":!0}),T(O)!=="svelte-1qch2ob"&&(O.textContent=Ts),xl=n(t),p(K.$$.fragment,t),Hl=n(t),tt=J(t,"BLOCKQUOTE",{"data-svelte-h":!0}),T(tt)!=="svelte-k3aac4"&&(tt.innerHTML=as),Gl=n(t),lt=J(t,"P",{"data-svelte-h":!0}),T(lt)!=="svelte-1orspwp"&&(lt.textContent=ps),Ll=n(t),et=J(t,"P",{"data-svelte-h":!0}),T(et)!=="svelte-pttslf"&&(et.textContent=Us),$l=n(t),st=J(t,"P",{"data-svelte-h":!0}),T(st)!=="svelte-yltmqc"&&(st.textContent=ws),gl=n(t),p(Mt.$$.fragment,t),Rl=n(t),nt=J(t,"P",{"data-svelte-h":!0}),T(nt)!=="svelte-10ggoum"&&(nt.textContent=ys),Sl=n(t),it=J(t,"UL",{"data-svelte-h":!0}),T(it)!=="svelte-xxzfgo"&&(it.innerHTML=js),Wl=n(t),Jt=J(t,"P",{"data-svelte-h":!0}),T(Jt)!=="svelte-tdx0u8"&&(Jt.textContent=Is),Nl=n(t),Tt=J(t,"P",{"data-svelte-h":!0}),T(Tt)!=="svelte-1dectdc"&&(Tt.textContent=us),Ql=n(t),at=J(t,"P",{"data-svelte-h":!0}),T(at)!=="svelte-lyk2wx"&&(at.innerHTML=Cs),El=n(t),pt=J(t,"OL",{"data-svelte-h":!0}),T(pt)!=="svelte-1i1hppp"&&(pt.innerHTML=ms),Zl=n(t),Ut=J(t,"P",{"data-svelte-h":!0}),T(Ut)!=="svelte-18nv8t5"&&(Ut.innerHTML=os),Fl=n(t),p(wt.$$.fragment,t),Yl=n(t),yt=J(t,"P",{"data-svelte-h":!0}),T(yt)!=="svelte-7pokpm"&&(yt.innerHTML=cs),kl=n(t),jt=J(t,"P",{"data-svelte-h":!0}),T(jt)!=="svelte-1or1mhh"&&(jt.innerHTML=rs),Xl=n(t),p(It.$$.fragment,t),ql=n(t),ut=J(t,"P",{"data-svelte-h":!0}),T(ut)!=="svelte-dtmcvr"&&(ut.textContent=fs),zl=n(t),p(Ct.$$.fragment,t),Pl=n(t),mt=J(t,"P",{"data-svelte-h":!0}),T(mt)!=="svelte-1gz5xbd"&&(mt.innerHTML=As),Dl=n(t),ot=J(t,"BLOCKQUOTE",{"data-svelte-h":!0}),T(ot)!=="svelte-7gg5tl"&&(ot.innerHTML=ds),Ol=n(t),p(ct.$$.fragment,t),Kl=n(t),rt=J(t,"P",{"data-svelte-h":!0}),T(rt)!=="svelte-4s5wki"&&(rt.innerHTML=bs),te=n(t),ft=J(t,"UL",{"data-svelte-h":!0}),T(ft)!=="svelte-1bokmjn"&&(ft.innerHTML=Bs),le=n(t),At=J(t,"P",{"data-svelte-h":!0}),T(At)!=="svelte-tmzeq9"&&(At.textContent=vs),ee=n(t),p(dt.$$.fragment,t),se=n(t),bt=J(t,"P",{"data-svelte-h":!0}),T(bt)!=="svelte-11opruq"&&(bt.innerHTML=hs),Me=n(t),Bt=J(t,"BLOCKQUOTE",{"data-svelte-h":!0}),T(Bt)!=="svelte-te8k4v"&&(Bt.innerHTML=_s),ne=n(t),m=J(t,"DETAILS",{});var he=xe(m);Xt=J(he,"SUMMARY",{"data-svelte-h":!0}),T(Xt)!=="svelte-14wmf42"&&(Xt.textContent=Vs),Ve=n(he),p(vt.$$.fragment,he),he.forEach(e),ie=n(t),ht=J(t,"P",{"data-svelte-h":!0}),T(ht)!=="svelte-zbmf03"&&(ht.textContent=xs),Je=n(t),p(_t.$$.fragment,t),Te=n(t),Vt=J(t,"P",{"data-svelte-h":!0}),T(Vt)!=="svelte-1nsae9n"&&(Vt.innerHTML=Hs),ae=n(t),p(xt.$$.fragment,t),pe=n(t),Ht=J(t,"P",{"data-svelte-h":!0}),T(Ht)!=="svelte-ckbp6d"&&(Ht.innerHTML=Gs),Ue=n(t),Gt=J(t,"IMG",{src:!0,alt:!0}),we=n(t),Lt=J(t,"P",{"data-svelte-h":!0}),T(Lt)!=="svelte-1cy6lvj"&&(Lt.innerHTML=$s),ye=n(t),p($t.$$.fragment,t),je=n(t),gt=J(t,"P",{"data-svelte-h":!0}),T(gt)!=="svelte-vgfvei"&&(gt.textContent=gs),Ie=n(t),Rt=J(t,"P",{"data-svelte-h":!0}),T(Rt)!=="svelte-r37a03"&&(Rt.textContent=Rs),ue=n(t),St=J(t,"UL",{"data-svelte-h":!0}),T(St)!=="svelte-1b1y741"&&(St.innerHTML=Ss),Ce=n(t),Wt=J(t,"P",{"data-svelte-h":!0}),T(Wt)!=="svelte-tzo7yn"&&(Wt.textContent=Ws),me=n(t),oe=J(t,"HR",{}),ce=n(t),Nt=J(t,"P",{"data-svelte-h":!0}),T(Nt)!=="svelte-191owyf"&&(Nt.textContent=Ns),re=n(t),Qt=J(t,"P",{"data-svelte-h":!0}),T(Qt)!=="svelte-chux5s"&&(Qt.textContent=Qs),fe=n(t),Et=J(t,"UL",{"data-svelte-h":!0}),T(Et)!=="svelte-1mmpgb3"&&(Et.innerHTML=Es),Ae=n(t),Zt=J(t,"P",{"data-svelte-h":!0}),T(Zt)!=="svelte-1ozmm13"&&(Zt.innerHTML=Zs),de=n(t),Ft=J(t,"P",{"data-svelte-h":!0}),T(Ft)!=="svelte-1h7368d"&&(Ft.textContent=Fs),be=n(t),p(Yt.$$.fragment,t),Be=n(t),zt=J(t,"P",{}),xe(zt).forEach(e),this.h()},h(){I(u,"name","hf:doc:metadata"),I(u,"content",Ks),_e(c.src,Le="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit1/whiteboard-check-2.jpg")||I(c,"src",Le),I(c,"alt","Unit 1 planning"),_e(G.src,ke="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit1/weather.jpg")||I(G,"src",ke),I(G,"alt","Weather"),_e(Q.src,Oe="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit1/Agent_system_prompt.png")||I(Q,"src",Oe),I(Q,"alt","System prompt for tools"),_e(Gt.src,Ls="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit1/Agent_system_prompt_tools.png")||I(Gt,"src",Ls),I(Gt,"alt","System prompt for tools")},m(t,l){He(document.head,u),s(t,Pt,l),s(t,qt,l),s(t,Dt,l),U(o,t,l),s(t,Ot,l),s(t,c,l),s(t,Kt,l),s(t,r,l),s(t,tl,l),s(t,f,l),s(t,ll,l),s(t,A,l),s(t,el,l),U(d,t,l),s(t,sl,l),s(t,b,l),s(t,Ml,l),s(t,B,l),s(t,nl,l),s(t,v,l),s(t,il,l),s(t,h,l),s(t,Jl,l),s(t,_,l),s(t,Tl,l),s(t,V,l),s(t,al,l),s(t,x,l),s(t,pl,l),s(t,H,l),s(t,Ul,l),s(t,G,l),s(t,wl,l),s(t,L,l),s(t,yl,l),U($,t,l),s(t,jl,l),s(t,g,l),s(t,Il,l),s(t,R,l),s(t,ul,l),s(t,S,l),s(t,Cl,l),U(W,t,l),s(t,ml,l),s(t,N,l),s(t,ol,l),s(t,Q,l),s(t,cl,l),s(t,E,l),s(t,rl,l),s(t,Z,l),s(t,fl,l),s(t,F,l),s(t,Al,l),s(t,Y,l),s(t,dl,l),s(t,k,l),s(t,bl,l),U(X,t,l),s(t,Bl,l),s(t,q,l),s(t,vl,l),s(t,z,l),s(t,hl,l),s(t,P,l),s(t,_l,l),s(t,D,l),s(t,Vl,l),s(t,O,l),s(t,xl,l),U(K,t,l),s(t,Hl,l),s(t,tt,l),s(t,Gl,l),s(t,lt,l),s(t,Ll,l),s(t,et,l),s(t,$l,l),s(t,st,l),s(t,gl,l),U(Mt,t,l),s(t,Rl,l),s(t,nt,l),s(t,Sl,l),s(t,it,l),s(t,Wl,l),s(t,Jt,l),s(t,Nl,l),s(t,Tt,l),s(t,Ql,l),s(t,at,l),s(t,El,l),s(t,pt,l),s(t,Zl,l),s(t,Ut,l),s(t,Fl,l),U(wt,t,l),s(t,Yl,l),s(t,yt,l),s(t,kl,l),s(t,jt,l),s(t,Xl,l),U(It,t,l),s(t,ql,l),s(t,ut,l),s(t,zl,l),U(Ct,t,l),s(t,Pl,l),s(t,mt,l),s(t,Dl,l),s(t,ot,l),s(t,Ol,l),U(ct,t,l),s(t,Kl,l),s(t,rt,l),s(t,te,l),s(t,ft,l),s(t,le,l),s(t,At,l),s(t,ee,l),U(dt,t,l),s(t,se,l),s(t,bt,l),s(t,Me,l),s(t,Bt,l),s(t,ne,l),s(t,m,l),He(m,Xt),He(m,Ve),U(vt,m,null),s(t,ie,l),s(t,ht,l),s(t,Je,l),U(_t,t,l),s(t,Te,l),s(t,Vt,l),s(t,ae,l),U(xt,t,l),s(t,pe,l),s(t,Ht,l),s(t,Ue,l),s(t,Gt,l),s(t,we,l),s(t,Lt,l),s(t,ye,l),U($t,t,l),s(t,je,l),s(t,gt,l),s(t,Ie,l),s(t,Rt,l),s(t,ue,l),s(t,St,l),s(t,Ce,l),s(t,Wt,l),s(t,me,l),s(t,oe,l),s(t,ce,l),s(t,Nt,l),s(t,re,l),s(t,Qt,l),s(t,fe,l),s(t,Et,l),s(t,Ae,l),s(t,Zt,l),s(t,de,l),s(t,Ft,l),s(t,be,l),U(Yt,t,l),s(t,Be,l),s(t,zt,l),ve=!0},p:ks,i(t){ve||(w(o.$$.fragment,t),w(d.$$.fragment,t),w($.$$.fragment,t),w(W.$$.fragment,t),w(X.$$.fragment,t),w(K.$$.fragment,t),w(Mt.$$.fragment,t),w(wt.$$.fragment,t),w(It.$$.fragment,t),w(Ct.$$.fragment,t),w(ct.$$.fragment,t),w(dt.$$.fragment,t),w(vt.$$.fragment,t),w(_t.$$.fragment,t),w(xt.$$.fragment,t),w($t.$$.fragment,t),w(Yt.$$.fragment,t),ve=!0)},o(t){y(o.$$.fragment,t),y(d.$$.fragment,t),y($.$$.fragment,t),y(W.$$.fragment,t),y(X.$$.fragment,t),y(K.$$.fragment,t),y(Mt.$$.fragment,t),y(wt.$$.fragment,t),y(It.$$.fragment,t),y(Ct.$$.fragment,t),y(ct.$$.fragment,t),y(dt.$$.fragment,t),y(vt.$$.fragment,t),y(_t.$$.fragment,t),y(xt.$$.fragment,t),y($t.$$.fragment,t),y(Yt.$$.fragment,t),ve=!1},d(t){t&&(e(Pt),e(qt),e(Dt),e(Ot),e(c),e(Kt),e(r),e(tl),e(f),e(ll),e(A),e(el),e(sl),e(b),e(Ml),e(B),e(nl),e(v),e(il),e(h),e(Jl),e(_),e(Tl),e(V),e(al),e(x),e(pl),e(H),e(Ul),e(G),e(wl),e(L),e(yl),e(jl),e(g),e(Il),e(R),e(ul),e(S),e(Cl),e(ml),e(N),e(ol),e(Q),e(cl),e(E),e(rl),e(Z),e(fl),e(F),e(Al),e(Y),e(dl),e(k),e(bl),e(Bl),e(q),e(vl),e(z),e(hl),e(P),e(_l),e(D),e(Vl),e(O),e(xl),e(Hl),e(tt),e(Gl),e(lt),e(Ll),e(et),e($l),e(st),e(gl),e(Rl),e(nt),e(Sl),e(it),e(Wl),e(Jt),e(Nl),e(Tt),e(Ql),e(at),e(El),e(pt),e(Zl),e(Ut),e(Fl),e(Yl),e(yt),e(kl),e(jt),e(Xl),e(ql),e(ut),e(zl),e(Pl),e(mt),e(Dl),e(ot),e(Ol),e(Kl),e(rt),e(te),e(ft),e(le),e(At),e(ee),e(se),e(bt),e(Me),e(Bt),e(ne),e(m),e(ie),e(ht),e(Je),e(Te),e(Vt),e(ae),e(pe),e(Ht),e(Ue),e(Gt),e(we),e(Lt),e(ye),e(je),e(gt),e(Ie),e(Rt),e(ue),e(St),e(Ce),e(Wt),e(me),e(oe),e(ce),e(Nt),e(re),e(Qt),e(fe),e(Et),e(Ae),e(Zt),e(de),e(Ft),e(be),e(Be),e(zt)),e(u),j(o,t),j(d,t),j($,t),j(W,t),j(X,t),j(K,t),j(Mt,t),j(wt,t),j(It,t),j(Ct,t),j(ct,t),j(dt,t),j(vt),j(_t,t),j(xt,t),j($t,t),j(Yt,t)}}}const Ks='{"title":"什么是工具？","local":"什么是工具","sections":[{"title":"AI 工具的定义","local":"ai-工具的定义","sections":[],"depth":2},{"title":"工具如何运作？","local":"工具如何运作","sections":[],"depth":2},{"title":"如何为 LLM 提供工具？","local":"如何为-llm-提供工具","sections":[{"title":"自动化工具描述生成","local":"自动化工具描述生成","sections":[],"depth":3},{"title":"通用工具类实现","local":"通用工具类实现","sections":[],"depth":3},{"title":"模型上下文协议（MCP）：统一的工具接口","local":"模型上下文协议mcp统一的工具接口","sections":[],"depth":3}],"depth":2}],"depth":1}';function tM(Ge){return Xs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class iM extends qs{constructor(u){super(),zs(this,u,tM,Os,Ys,{})}}export{iM as component};
