import{s as jn,o as Un,n as fn}from"../chunks/scheduler.37c15a92.js";import{S as In,i as gn,g as i,s as n,r as p,A as Cn,h as o,f as l,c as a,j as dn,u as M,x as r,k as is,y as vn,a as s,v as u,d as c,t as m,w as T,m as hn,n as bn}from"../chunks/index.2bf4358c.js";import{T as Bn}from"../chunks/Tip.363c041f.js";import{C as h}from"../chunks/CodeBlock.4e987730.js";import{C as Zn}from"../chunks/CourseFloatingBanner.6add7356.js";import{H as J}from"../chunks/Heading.8ada512a.js";import{E as kn}from"../chunks/getInferenceSnippets.42ccd5ac.js";function Rn(Tt){let y,d,j="this notebook",b;return{c(){y=hn("You can follow the code in "),d=i("a"),d.textContent=j,b=hn(" that you can run using Google Colab."),this.h()},l(w){y=bn(w,"You can follow the code in "),d=o(w,"A",{href:!0,target:!0,"data-svelte-h":!0}),r(d)!=="svelte-1y53sk7"&&(d.textContent=j),b=bn(w," that you can run using Google Colab."),this.h()},h(){is(d,"href","https://colab.research.google.com/#fileId=https%3A//huggingface.co/agents-course/notebooks/blob/main/bonus-unit2/monitoring-and-evaluating-agents.ipynb"),is(d,"target","_blank")},m(w,U){s(w,y,U),s(w,d,U),s(w,b,U)},p:fn,d(w){w&&(l(y),l(d),l(b))}}}function Vn(Tt){let y,d,j,b,w,U,I,Jt,f,wt,g,os="In this notebook, we will learn how to <strong>monitor the internal steps (traces) of our AI agent</strong> and <strong>evaluate its performance</strong> using open-source observability tools.",yt,C,rs="The ability to observe and evaluate an agent’s behavior is essential for:",dt,v,ps="<li>Debugging issues when tasks fail or produce suboptimal results</li> <li>Monitoring costs and performance in real-time</li> <li>Improving reliability and safety through continuous feedback</li>",ht,B,bt,Z,Ms="Before running this notebook, please be sure you have:",jt,k,us='🔲 📚  <strong>Studied</strong> <a href="https://huggingface.co/learn/agents-course/unit1/introduction" rel="nofollow">Introduction to Agents</a>',Ut,R,cs='🔲 📚  <strong>Studied</strong> <a href="https://huggingface.co/learn/agents-course/unit2/smolagents/introduction" rel="nofollow">The smolagents framework</a>',ft,V,It,W,ms="We will need a few libraries that allow us to run, monitor, and evaluate our agents:",gt,G,Ct,$,vt,x,Ts='In this notebook, we will use <a href="https://langfuse.com/" rel="nofollow">Langfuse</a> as our observability tool, but you can use <strong>any other OpenTelemetry-compatible service</strong>. The code below shows how to set environment variables for Langfuse (or any OTel endpoint) and how to instrument your smolagent.',Bt,E,Js='<strong>Note:</strong> If you are using LlamaIndex or LangGraph, you can find documentation on instrumenting them <a href="https://langfuse.com/docs/integrations/llama-index/workflows" rel="nofollow">here</a> and <a href="https://langfuse.com/docs/integrations/langchain/example-python-langgraph" rel="nofollow">here</a>.',Zt,X,ws="First, let’s configure the right environment variable for setting up the connection to the Langfuse OpenTelemetry endpoint.",kt,N,Rt,_,ys="We also need to configure our Hugging Face token for inference calls.",Vt,Y,Wt,A,ds="Next, we can set up the a tracer-provider for our configured OpenTelemetry.",Gt,H,$t,Q,xt,L,hs="Here is a simple CodeAgent from smolagents that calculates <code>1+1</code>. We run it to confirm that the instrumentation is working correctly. If everything is set up correctly, you will see logs/spans in your observability dashboard.",Et,F,Xt,S,bs='Check your <a href="https://cloud.langfuse.com" rel="nofollow">Langfuse Traces Dashboard</a> (or your chosen observability tool) to confirm that the spans and logs have been recorded.',Nt,z,js="Example screenshot from Langfuse:",_t,q,Us='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/bonus-unit2/first-example-trace.png" alt="Example trace in Langfuse"/>',Yt,P,fs='<em><a href="https://cloud.langfuse.com/project/cloramnkj0002jz088vzn1ja4/traces/1b94d6888258e0998329cdb72a371155?timestamp=2025-03-10T11%3A59%3A41.743Z" rel="nofollow">Link to the trace</a></em>',At,D,Ht,K,Is="Now that you have confirmed your instrumentation works, let’s try a more complex query so we can see how advanced metrics (token usage, latency, costs, etc.) are tracked.",Qt,O,Lt,ee,Ft,te,gs="Most observability tools record a <strong>trace</strong> that contains <strong>spans</strong>, which represent each step of your agent’s logic. Here, the trace contains the overall agent run and sub-spans for:",St,le,Cs="<li>The tool calls (DuckDuckGoSearchTool)</li> <li>The LLM calls (InferenceClientModel)</li>",zt,se,vs="You can inspect these to see precisely where time is spent, how many tokens are used, and so on:",qt,ne,Bs='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/bonus-unit2/trace-tree.png" alt="Trace tree in Langfuse"/>',Pt,ae,Zs='<em><a href="https://cloud.langfuse.com/project/cloramnkj0002jz088vzn1ja4/traces/1ac33b89ffd5e75d4265b62900c348ed?timestamp=2025-03-07T13%3A45%3A09.149Z&amp;display=preview" rel="nofollow">Link to the trace</a></em>',Dt,ie,Kt,oe,ks="In the previous section, we learned about the difference between online and offline evaluation. Now, we will see how to monitor your agent in production and evaluate it live.",Ot,re,el,pe,Rs="<li><strong>Costs</strong> — The smolagents instrumentation captures token usage, which you can transform into approximate costs by assigning a price per token.</li> <li><strong>Latency</strong> — Observe the time it takes to complete each step, or the entire run.</li> <li><strong>User Feedback</strong> — Users can provide direct feedback (thumbs up/down) to help refine or correct the agent.</li> <li><strong>LLM-as-a-Judge</strong> — Use a separate LLM to evaluate your agent’s output in near real-time (e.g., checking for toxicity or correctness).</li>",tl,Me,Vs="Below, we show examples of these metrics.",ll,ue,sl,ce,Ws="Below is a screenshot showing usage for <code>Qwen2.5-Coder-32B-Instruct</code> calls. This is useful to see costly steps and optimize your agent.",nl,me,Gs='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/bonus-unit2/smolagents-costs.png" alt="Costs"/>',al,Te,$s='<em><a href="https://cloud.langfuse.com/project/cloramnkj0002jz088vzn1ja4/traces/1ac33b89ffd5e75d4265b62900c348ed?timestamp=2025-03-07T13%3A45%3A09.149Z&amp;display=preview" rel="nofollow">Link to the trace</a></em>',il,Je,ol,we,xs="We can also see how long it took to complete each step. In the example below, the entire conversation took 32 seconds, which you can break down by step. This helps you identify bottlenecks and optimize your agent.",rl,ye,Es='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/bonus-unit2/smolagents-latency.png" alt="Latency"/>',pl,de,Xs='<em><a href="https://cloud.langfuse.com/project/cloramnkj0002jz088vzn1ja4/traces/1ac33b89ffd5e75d4265b62900c348ed?timestamp=2025-03-07T13%3A45%3A09.149Z&amp;display=preview" rel="nofollow">Link to the trace</a></em>',Ml,he,ul,be,Ns="You may also pass additional attributes—such as user IDs, session IDs, or tags—by setting them on the spans. For example, smolagents instrumentation uses OpenTelemetry to attach attributes like <code>langfuse.user.id</code> or custom tags.",cl,je,ml,Ue,_s='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/bonus-unit2/smolagents-attributes.png" alt="Enhancing agent runs with additional metrics"/>',Tl,fe,Jl,Ie,Ys='If your agent is embedded into a user interface, you can record direct user feedback (like a thumbs-up/down in a chat UI). Below is an example using <a href="https://gradio.app/" rel="nofollow">Gradio</a> to embed a chat with a simple feedback mechanism.',wl,ge,As="In the code snippet below, when a user sends a chat message, we capture the OpenTelemetry trace ID. If the user likes/dislikes the last answer, we attach a score to the trace.",yl,Ce,dl,ve,Hs="User feedback is then captured in your observability tool:",hl,Be,Qs='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/bonus-unit2/user-feedback-gradio.png" alt="User feedback is being captured in Langfuse"/>',bl,Ze,jl,ke,Ls="LLM-as-a-Judge is another way to automatically evaluate your agent’s output. You can set up a separate LLM call to gauge the output’s correctness, toxicity, style, or any other criteria you care about.",Ul,Re,Fs="<strong>Workflow</strong>:",fl,Ve,Ss="<li>You define an <strong>Evaluation Template</strong>, e.g., “Check if the text is toxic.”</li> <li>Each time your agent generates output, you pass that output to your “judge” LLM with the template.</li> <li>The judge LLM responds with a rating or label that you log to your observability tool.</li>",Il,We,zs="Example from Langfuse:",gl,Ge,qs='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/bonus-unit2/evaluator-template.png" alt="LLM-as-a-Judge Evaluation Template"/> <img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/bonus-unit2/evaluator.png" alt="LLM-as-a-Judge Evaluator"/>',Cl,$e,vl,xe,Ps="You can see that the answer of this example is judged as “not toxic”.",Bl,Ee,Ds='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/bonus-unit2/llm-as-a-judge-score.png" alt="LLM-as-a-Judge Evaluation Score"/>',Zl,Xe,kl,Ne,Ks="All of these metrics can be visualized together in dashboards. This enables you to quickly see how your agent performs across many sessions and helps you to track quality metrics over time.",Rl,_e,Os='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/bonus-unit2/langfuse-dashboard.png" alt="Observability metrics overview"/>',Vl,Ye,Wl,Ae,en="Online evaluation is essential for live feedback, but you also need <strong>offline evaluation</strong>—systematic checks before or during development. This helps maintain quality and reliability before rolling changes into production.",Gl,He,$l,Qe,tn="In offline evaluation, you typically:",xl,Le,ln="<li>Have a benchmark dataset (with prompt and expected output pairs)</li> <li>Run your agent on that dataset</li> <li>Compare outputs to the expected results or use an additional scoring mechanism</li>",El,Fe,sn='Below, we demonstrate this approach with the <a href="https://huggingface.co/datasets/gsm8k" rel="nofollow">GSM8K dataset</a>, which contains math questions and solutions.',Xl,Se,Nl,ze,nn="Next, we create a dataset entity in Langfuse to track the runs. Then, we add each item from the dataset to the system. (If you’re not using Langfuse, you might simply store these in your own database or local file for analysis.)",_l,qe,Yl,Pe,Al,De,an='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/bonus-unit2/example-dataset.png" alt="Dataset items in Langfuse"/>',Hl,Ke,Ql,Oe,on="We define a helper function <code>run_smolagent()</code> that:",Ll,et,rn="<li>Starts an OpenTelemetry span</li> <li>Runs our agent on the prompt</li> <li>Records the trace ID in Langfuse</li>",Fl,tt,pn="Then, we loop over each dataset item, run the agent, and link the trace to the dataset item. We can also attach a quick evaluation score if desired.",Sl,lt,zl,st,ql,nt,Mn="You can repeat this process with different:",Pl,at,un="<li>Models (OpenAI GPT, local LLM, etc.)</li> <li>Tools (search vs. no search)</li> <li>Prompts (different system messages)</li>",Dl,it,cn="Then compare them side-by-side in your observability tool:",Kl,ot,mn='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/bonus-unit2/dataset_runs.png" alt="Dataset run overview"/> <img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/bonus-unit2/dataset-run-comparison.png" alt="Dataset run comparison"/>',Ol,rt,es,pt,Tn="In this notebook, we covered how to:",ts,Mt,Jn="<li><strong>Set up Observability</strong> using smolagents + OpenTelemetry exporters</li> <li><strong>Check Instrumentation</strong> by running a simple agent</li> <li><strong>Capture Detailed Metrics</strong> (cost, latency, etc.) through an observability tools</li> <li><strong>Collect User Feedback</strong> via a Gradio interface</li> <li><strong>Use LLM-as-a-Judge</strong> to automatically evaluate outputs</li> <li><strong>Perform Offline Evaluation</strong> with a benchmark dataset</li>",ls,ut,wn="🤗 Happy coding!",ss,ct,ns,mt,as;return w=new Zn({props:{chapter:2,classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"Google Colab",value:"https://colab.research.google.com/#fileId=https%3A//huggingface.co/agents-course/notebooks/blob/main/bonus-unit2/monitoring-and-evaluating-agents.ipynb"}]}}),I=new J({props:{title:"Bonus Unit 2: Observability and Evaluation of Agents",local:"bonus-unit-2-observability-and-evaluation-of-agents",headingTag:"h1"}}),f=new Bn({props:{$$slots:{default:[Rn]},$$scope:{ctx:Tt}}}),B=new J({props:{title:"Exercise Prerequisites 🏗️",local:"exercise-prerequisites-",headingTag:"h2"}}),V=new J({props:{title:"Step 0: Install the Required Libraries",local:"step-0-install-the-required-libraries",headingTag:"h2"}}),G=new h({props:{code:"JTI1cGlwJTIwaW5zdGFsbCUyMCdzbW9sYWdlbnRzJTVCdGVsZW1ldHJ5JTVEJyUwQSUyNXBpcCUyMGluc3RhbGwlMjBvcGVudGVsZW1ldHJ5LXNkayUyMG9wZW50ZWxlbWV0cnktZXhwb3J0ZXItb3RscCUyMG9wZW5pbmZlcmVuY2UtaW5zdHJ1bWVudGF0aW9uLXNtb2xhZ2VudHMlMEElMjVwaXAlMjBpbnN0YWxsJTIwbGFuZ2Z1c2UlMjBkYXRhc2V0cyUyMCdzbW9sYWdlbnRzJTVCZ3JhZGlvJTVEJw==",highlighted:`%pip install <span class="hljs-string">&#x27;smolagents[telemetry]&#x27;</span>
%pip install opentelemetry-sdk opentelemetry-exporter-otlp openinference-instrumentation-smolagents
%pip install langfuse datasets <span class="hljs-string">&#x27;smolagents[gradio]&#x27;</span>`,wrap:!1}}),$=new J({props:{title:"Step 1: Instrument Your Agent",local:"step-1-instrument-your-agent",headingTag:"h2"}}),N=new h({props:{code:"aW1wb3J0JTIwb3MlMEFpbXBvcnQlMjBiYXNlNjQlMEElMEElMjMlMjBHZXQlMjB5b3VyJTIwb3duJTIwa2V5cyUyMGZyb20lMjBodHRwcyUzQSUyRiUyRmNsb3VkLmxhbmdmdXNlLmNvbSUwQUxBTkdGVVNFX1BVQkxJQ19LRVklMjAlM0QlMjAlMjJway1sZi0uLi4lMjIlMjAlMEFMQU5HRlVTRV9TRUNSRVRfS0VZJTIwJTNEJTIwJTIyc2stbGYtLi4uJTIyJTIwJTBBb3MuZW52aXJvbiU1QiUyMkxBTkdGVVNFX1BVQkxJQ19LRVklMjIlNUQlMjAlM0QlMjBMQU5HRlVTRV9QVUJMSUNfS0VZJTBBb3MuZW52aXJvbiU1QiUyMkxBTkdGVVNFX1NFQ1JFVF9LRVklMjIlNUQlMjAlM0QlMjBMQU5HRlVTRV9TRUNSRVRfS0VZJTBBb3MuZW52aXJvbiU1QiUyMkxBTkdGVVNFX0hPU1QlMjIlNUQlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRmNsb3VkLmxhbmdmdXNlLmNvbSUyMiUyMCUyMCUyMyUyMCVGMCU5RiU4NyVBQSVGMCU5RiU4NyVCQSUyMEVVJTIwcmVnaW9uJTIwZXhhbXBsZSUwQSUyMyUyMG9zLmVudmlyb24lNUIlMjJMQU5HRlVTRV9IT1NUJTIyJTVEJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZ1cy5jbG91ZC5sYW5nZnVzZS5jb20lMjIlMjAlMjAlMjMlMjAlRjAlOUYlODclQkElRjAlOUYlODclQjglMjBVUyUyMHJlZ2lvbiUyMGV4YW1wbGUlMEElMEFMQU5HRlVTRV9BVVRIJTIwJTNEJTIwYmFzZTY0LmI2NGVuY29kZSglMEElMjAlMjAlMjAlMjBmJTIyJTdCTEFOR0ZVU0VfUFVCTElDX0tFWSU3RCUzQSU3QkxBTkdGVVNFX1NFQ1JFVF9LRVklN0QlMjIuZW5jb2RlKCklMEEpLmRlY29kZSgpJTBBJTBBb3MuZW52aXJvbiU1QiUyMk9URUxfRVhQT1JURVJfT1RMUF9FTkRQT0lOVCUyMiU1RCUyMCUzRCUyMG9zLmVudmlyb24uZ2V0KCUyMkxBTkdGVVNFX0hPU1QlMjIpJTIwJTJCJTIwJTIyJTJGYXBpJTJGcHVibGljJTJGb3RlbCUyMiUwQW9zLmVudmlyb24lNUIlMjJPVEVMX0VYUE9SVEVSX09UTFBfSEVBREVSUyUyMiU1RCUyMCUzRCUyMGYlMjJBdXRob3JpemF0aW9uJTNEQmFzaWMlMjAlN0JMQU5HRlVTRV9BVVRIJTdEJTIy",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">import</span> base64

<span class="hljs-comment"># Get your own keys from https://cloud.langfuse.com</span>
LANGFUSE_PUBLIC_KEY = <span class="hljs-string">&quot;pk-lf-...&quot;</span> 
LANGFUSE_SECRET_KEY = <span class="hljs-string">&quot;sk-lf-...&quot;</span> 
os.environ[<span class="hljs-string">&quot;LANGFUSE_PUBLIC_KEY&quot;</span>] = LANGFUSE_PUBLIC_KEY
os.environ[<span class="hljs-string">&quot;LANGFUSE_SECRET_KEY&quot;</span>] = LANGFUSE_SECRET_KEY
os.environ[<span class="hljs-string">&quot;LANGFUSE_HOST&quot;</span>] = <span class="hljs-string">&quot;https://cloud.langfuse.com&quot;</span>  <span class="hljs-comment"># 🇪🇺 EU region example</span>
<span class="hljs-comment"># os.environ[&quot;LANGFUSE_HOST&quot;] = &quot;https://us.cloud.langfuse.com&quot;  # 🇺🇸 US region example</span>

LANGFUSE_AUTH = base64.b64encode(
    <span class="hljs-string">f&quot;<span class="hljs-subst">{LANGFUSE_PUBLIC_KEY}</span>:<span class="hljs-subst">{LANGFUSE_SECRET_KEY}</span>&quot;</span>.encode()
).decode()

os.environ[<span class="hljs-string">&quot;OTEL_EXPORTER_OTLP_ENDPOINT&quot;</span>] = os.environ.get(<span class="hljs-string">&quot;LANGFUSE_HOST&quot;</span>) + <span class="hljs-string">&quot;/api/public/otel&quot;</span>
os.environ[<span class="hljs-string">&quot;OTEL_EXPORTER_OTLP_HEADERS&quot;</span>] = <span class="hljs-string">f&quot;Authorization=Basic <span class="hljs-subst">{LANGFUSE_AUTH}</span>&quot;</span>`,wrap:!1}}),Y=new h({props:{code:"JTIzJTIwU2V0JTIweW91ciUyMEh1Z2dpbmclMjBGYWNlJTIwYW5kJTIwb3RoZXIlMjB0b2tlbnMlMkZzZWNyZXRzJTIwYXMlMjBlbnZpcm9ubWVudCUyMHZhcmlhYmxlJTBBb3MuZW52aXJvbiU1QiUyMkhGX1RPS0VOJTIyJTVEJTIwJTNEJTIwJTIyaGZfLi4uJTIyJTIw",highlighted:`<span class="hljs-comment"># Set your Hugging Face and other tokens/secrets as environment variable</span>
os.environ[<span class="hljs-string">&quot;HF_TOKEN&quot;</span>] = <span class="hljs-string">&quot;hf_...&quot;</span> `,wrap:!1}}),H=new h({props:{code:"ZnJvbSUyMG9wZW50ZWxlbWV0cnkuc2RrLnRyYWNlJTIwaW1wb3J0JTIwVHJhY2VyUHJvdmlkZXIlMEFmcm9tJTIwb3BlbmluZmVyZW5jZS5pbnN0cnVtZW50YXRpb24uc21vbGFnZW50cyUyMGltcG9ydCUyMFNtb2xhZ2VudHNJbnN0cnVtZW50b3IlMEFmcm9tJTIwb3BlbnRlbGVtZXRyeS5leHBvcnRlci5vdGxwLnByb3RvLmh0dHAudHJhY2VfZXhwb3J0ZXIlMjBpbXBvcnQlMjBPVExQU3BhbkV4cG9ydGVyJTBBZnJvbSUyMG9wZW50ZWxlbWV0cnkuc2RrLnRyYWNlLmV4cG9ydCUyMGltcG9ydCUyMFNpbXBsZVNwYW5Qcm9jZXNzb3IlMEElMjAlMEElMjMlMjBDcmVhdGUlMjBhJTIwVHJhY2VyUHJvdmlkZXIlMjBmb3IlMjBPcGVuVGVsZW1ldHJ5JTBBdHJhY2VfcHJvdmlkZXIlMjAlM0QlMjBUcmFjZXJQcm92aWRlcigpJTBBJTBBJTIzJTIwQWRkJTIwYSUyMFNpbXBsZVNwYW5Qcm9jZXNzb3IlMjB3aXRoJTIwdGhlJTIwT1RMUFNwYW5FeHBvcnRlciUyMHRvJTIwc2VuZCUyMHRyYWNlcyUwQXRyYWNlX3Byb3ZpZGVyLmFkZF9zcGFuX3Byb2Nlc3NvcihTaW1wbGVTcGFuUHJvY2Vzc29yKE9UTFBTcGFuRXhwb3J0ZXIoKSkpJTBBJTBBJTIzJTIwU2V0JTIwdGhlJTIwZ2xvYmFsJTIwZGVmYXVsdCUyMHRyYWNlciUyMHByb3ZpZGVyJTBBZnJvbSUyMG9wZW50ZWxlbWV0cnklMjBpbXBvcnQlMjB0cmFjZSUwQXRyYWNlLnNldF90cmFjZXJfcHJvdmlkZXIodHJhY2VfcHJvdmlkZXIpJTBBdHJhY2VyJTIwJTNEJTIwdHJhY2UuZ2V0X3RyYWNlcihfX25hbWVfXyklMEElMEElMjMlMjBJbnN0cnVtZW50JTIwc21vbGFnZW50cyUyMHdpdGglMjB0aGUlMjBjb25maWd1cmVkJTIwcHJvdmlkZXIlMEFTbW9sYWdlbnRzSW5zdHJ1bWVudG9yKCkuaW5zdHJ1bWVudCh0cmFjZXJfcHJvdmlkZXIlM0R0cmFjZV9wcm92aWRlcik=",highlighted:`<span class="hljs-keyword">from</span> opentelemetry.sdk.trace <span class="hljs-keyword">import</span> TracerProvider
<span class="hljs-keyword">from</span> openinference.instrumentation.smolagents <span class="hljs-keyword">import</span> SmolagentsInstrumentor
<span class="hljs-keyword">from</span> opentelemetry.exporter.otlp.proto.http.trace_exporter <span class="hljs-keyword">import</span> OTLPSpanExporter
<span class="hljs-keyword">from</span> opentelemetry.sdk.trace.export <span class="hljs-keyword">import</span> SimpleSpanProcessor
 
<span class="hljs-comment"># Create a TracerProvider for OpenTelemetry</span>
trace_provider = TracerProvider()

<span class="hljs-comment"># Add a SimpleSpanProcessor with the OTLPSpanExporter to send traces</span>
trace_provider.add_span_processor(SimpleSpanProcessor(OTLPSpanExporter()))

<span class="hljs-comment"># Set the global default tracer provider</span>
<span class="hljs-keyword">from</span> opentelemetry <span class="hljs-keyword">import</span> trace
trace.set_tracer_provider(trace_provider)
tracer = trace.get_tracer(__name__)

<span class="hljs-comment"># Instrument smolagents with the configured provider</span>
SmolagentsInstrumentor().instrument(tracer_provider=trace_provider)`,wrap:!1}}),Q=new J({props:{title:"Step 2: Test Your Instrumentation",local:"step-2-test-your-instrumentation",headingTag:"h2"}}),F=new h({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCUyQyUyMENvZGVBZ2VudCUwQSUwQSUyMyUyMENyZWF0ZSUyMGElMjBzaW1wbGUlMjBhZ2VudCUyMHRvJTIwdGVzdCUyMGluc3RydW1lbnRhdGlvbiUwQWFnZW50JTIwJTNEJTIwQ29kZUFnZW50KCUwQSUyMCUyMCUyMCUyMHRvb2xzJTNEJTVCJTVEJTJDJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0RJbmZlcmVuY2VDbGllbnRNb2RlbCgpJTBBKSUwQSUwQWFnZW50LnJ1biglMjIxJTJCMSUzRCUyMik=",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> InferenceClientModel, CodeAgent

<span class="hljs-comment"># Create a simple agent to test instrumentation</span>
agent = CodeAgent(
    tools=[],
    model=InferenceClientModel()
)

agent.run(<span class="hljs-string">&quot;1+1=&quot;</span>)`,wrap:!1}}),D=new J({props:{title:"Step 3: Observe and Evaluate a More Complex Agent",local:"step-3-observe-and-evaluate-a-more-complex-agent",headingTag:"h2"}}),O=new h({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjAoQ29kZUFnZW50JTJDJTIwRHVja0R1Y2tHb1NlYXJjaFRvb2wlMkMlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCklMEElMEFzZWFyY2hfdG9vbCUyMCUzRCUyMER1Y2tEdWNrR29TZWFyY2hUb29sKCklMEFhZ2VudCUyMCUzRCUyMENvZGVBZ2VudCh0b29scyUzRCU1QnNlYXJjaF90b29sJTVEJTJDJTIwbW9kZWwlM0RJbmZlcmVuY2VDbGllbnRNb2RlbCgpKSUwQSUwQWFnZW50LnJ1biglMjJIb3clMjBtYW55JTIwUnViaWsncyUyMEN1YmVzJTIwY291bGQlMjB5b3UlMjBmaXQlMjBpbnNpZGUlMjB0aGUlMjBOb3RyZSUyMERhbWUlMjBDYXRoZWRyYWwlM0YlMjIp",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> (CodeAgent, DuckDuckGoSearchTool, InferenceClientModel)

search_tool = DuckDuckGoSearchTool()
agent = CodeAgent(tools=[search_tool], model=InferenceClientModel())

agent.run(<span class="hljs-string">&quot;How many Rubik&#x27;s Cubes could you fit inside the Notre Dame Cathedral?&quot;</span>)`,wrap:!1}}),ee=new J({props:{title:"Trace Structure",local:"trace-structure",headingTag:"h3"}}),ie=new J({props:{title:"Online Evaluation",local:"online-evaluation",headingTag:"h2"}}),re=new J({props:{title:"Common Metrics to Track in Production",local:"common-metrics-to-track-in-production",headingTag:"h3"}}),ue=new J({props:{title:"1. Costs",local:"1-costs",headingTag:"h4"}}),Je=new J({props:{title:"2. Latency",local:"2-latency",headingTag:"h4"}}),he=new J({props:{title:"3. Additional Attributes",local:"3-additional-attributes",headingTag:"h4"}}),je=new h({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjAoQ29kZUFnZW50JTJDJTIwRHVja0R1Y2tHb1NlYXJjaFRvb2wlMkMlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCklMEFmcm9tJTIwb3BlbnRlbGVtZXRyeSUyMGltcG9ydCUyMHRyYWNlJTBBJTBBc2VhcmNoX3Rvb2wlMjAlM0QlMjBEdWNrRHVja0dvU2VhcmNoVG9vbCgpJTBBYWdlbnQlMjAlM0QlMjBDb2RlQWdlbnQoJTBBJTIwJTIwJTIwJTIwdG9vbHMlM0QlNUJzZWFyY2hfdG9vbCU1RCUyQyUwQSUyMCUyMCUyMCUyMG1vZGVsJTNESW5mZXJlbmNlQ2xpZW50TW9kZWwoKSUwQSklMEElMEF3aXRoJTIwdHJhY2VyLnN0YXJ0X2FzX2N1cnJlbnRfc3BhbiglMjJTbW9sYWdlbnQtVHJhY2UlMjIpJTIwYXMlMjBzcGFuJTNBJTBBJTIwJTIwJTIwJTIwc3Bhbi5zZXRfYXR0cmlidXRlKCUyMmxhbmdmdXNlLnVzZXIuaWQlMjIlMkMlMjAlMjJzbW9sYWdlbnQtdXNlci0xMjMlMjIpJTBBJTIwJTIwJTIwJTIwc3Bhbi5zZXRfYXR0cmlidXRlKCUyMmxhbmdmdXNlLnNlc3Npb24uaWQlMjIlMkMlMjAlMjJzbW9sYWdlbnQtc2Vzc2lvbi0xMjM0NTY3ODklMjIpJTBBJTIwJTIwJTIwJTIwc3Bhbi5zZXRfYXR0cmlidXRlKCUyMmxhbmdmdXNlLnRhZ3MlMjIlMkMlMjAlNUIlMjJjaXR5LXF1ZXN0aW9uJTIyJTJDJTIwJTIydGVzdGluZy1hZ2VudHMlMjIlNUQpJTBBJTBBJTIwJTIwJTIwJTIwYWdlbnQucnVuKCUyMldoYXQlMjBpcyUyMHRoZSUyMGNhcGl0YWwlMjBvZiUyMEdlcm1hbnklM0YlMjIp",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> (CodeAgent, DuckDuckGoSearchTool, InferenceClientModel)
<span class="hljs-keyword">from</span> opentelemetry <span class="hljs-keyword">import</span> trace

search_tool = DuckDuckGoSearchTool()
agent = CodeAgent(
    tools=[search_tool],
    model=InferenceClientModel()
)

<span class="hljs-keyword">with</span> tracer.start_as_current_span(<span class="hljs-string">&quot;Smolagent-Trace&quot;</span>) <span class="hljs-keyword">as</span> span:
    span.set_attribute(<span class="hljs-string">&quot;langfuse.user.id&quot;</span>, <span class="hljs-string">&quot;smolagent-user-123&quot;</span>)
    span.set_attribute(<span class="hljs-string">&quot;langfuse.session.id&quot;</span>, <span class="hljs-string">&quot;smolagent-session-123456789&quot;</span>)
    span.set_attribute(<span class="hljs-string">&quot;langfuse.tags&quot;</span>, [<span class="hljs-string">&quot;city-question&quot;</span>, <span class="hljs-string">&quot;testing-agents&quot;</span>])

    agent.run(<span class="hljs-string">&quot;What is the capital of Germany?&quot;</span>)`,wrap:!1}}),fe=new J({props:{title:"4. User Feedback",local:"4-user-feedback",headingTag:"h4"}}),Ce=new h({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr
<span class="hljs-keyword">from</span> opentelemetry.trace <span class="hljs-keyword">import</span> format_trace_id
<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> (CodeAgent, InferenceClientModel)
<span class="hljs-keyword">from</span> langfuse <span class="hljs-keyword">import</span> Langfuse

langfuse = Langfuse()
model = InferenceClientModel()
agent = CodeAgent(tools=[], model=model, add_base_tools=<span class="hljs-literal">True</span>)

formatted_trace_id = <span class="hljs-literal">None</span>  <span class="hljs-comment"># We&#x27;ll store the current trace_id globally for demonstration</span>

<span class="hljs-keyword">def</span> <span class="hljs-title function_">respond</span>(<span class="hljs-params">prompt, history</span>):
    <span class="hljs-keyword">with</span> trace.get_tracer(__name__).start_as_current_span(<span class="hljs-string">&quot;Smolagent-Trace&quot;</span>) <span class="hljs-keyword">as</span> span:
        output = agent.run(prompt)

        current_span = trace.get_current_span()
        span_context = current_span.get_span_context()
        trace_id = span_context.trace_id
        <span class="hljs-keyword">global</span> formatted_trace_id
        formatted_trace_id = <span class="hljs-built_in">str</span>(format_trace_id(trace_id))
        langfuse.trace(<span class="hljs-built_in">id</span>=formatted_trace_id, <span class="hljs-built_in">input</span>=prompt, output=output)

    history.append({<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-built_in">str</span>(output)})
    <span class="hljs-keyword">return</span> history

<span class="hljs-keyword">def</span> <span class="hljs-title function_">handle_like</span>(<span class="hljs-params">data: gr.LikeData</span>):
    <span class="hljs-comment"># For demonstration, we map user feedback to a 1 (like) or 0 (dislike)</span>
    <span class="hljs-keyword">if</span> data.liked:
        langfuse.score(
            value=<span class="hljs-number">1</span>,
            name=<span class="hljs-string">&quot;user-feedback&quot;</span>,
            trace_id=formatted_trace_id
        )
    <span class="hljs-keyword">else</span>:
        langfuse.score(
            value=<span class="hljs-number">0</span>,
            name=<span class="hljs-string">&quot;user-feedback&quot;</span>,
            trace_id=formatted_trace_id
        )

<span class="hljs-keyword">with</span> gr.Blocks() <span class="hljs-keyword">as</span> demo:
    chatbot = gr.Chatbot(label=<span class="hljs-string">&quot;Chat&quot;</span>, <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;messages&quot;</span>)
    prompt_box = gr.Textbox(placeholder=<span class="hljs-string">&quot;Type your message...&quot;</span>, label=<span class="hljs-string">&quot;Your message&quot;</span>)

    <span class="hljs-comment"># When the user presses &#x27;Enter&#x27; on the prompt, we run &#x27;respond&#x27;</span>
    prompt_box.submit(
        fn=respond,
        inputs=[prompt_box, chatbot],
        outputs=chatbot
    )

    <span class="hljs-comment"># When the user clicks a &#x27;like&#x27; button on a message, we run &#x27;handle_like&#x27;</span>
    chatbot.like(handle_like, <span class="hljs-literal">None</span>, <span class="hljs-literal">None</span>)

demo.launch()
`,wrap:!1}}),Ze=new J({props:{title:"5. LLM-as-a-Judge",local:"5-llm-as-a-judge",headingTag:"h4"}}),$e=new h({props:{code:"JTIzJTIwRXhhbXBsZSUzQSUyMENoZWNraW5nJTIwaWYlMjB0aGUlMjBhZ2VudCVFMiU4MCU5OXMlMjBvdXRwdXQlMjBpcyUyMHRveGljJTIwb3IlMjBub3QuJTBBZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjAoQ29kZUFnZW50JTJDJTIwRHVja0R1Y2tHb1NlYXJjaFRvb2wlMkMlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCklMEElMEFzZWFyY2hfdG9vbCUyMCUzRCUyMER1Y2tEdWNrR29TZWFyY2hUb29sKCklMEFhZ2VudCUyMCUzRCUyMENvZGVBZ2VudCh0b29scyUzRCU1QnNlYXJjaF90b29sJTVEJTJDJTIwbW9kZWwlM0RJbmZlcmVuY2VDbGllbnRNb2RlbCgpKSUwQSUwQWFnZW50LnJ1biglMjJDYW4lMjBlYXRpbmclMjBjYXJyb3RzJTIwaW1wcm92ZSUyMHlvdXIlMjB2aXNpb24lM0YlMjIp",highlighted:`<span class="hljs-comment"># Example: Checking if the agent’s output is toxic or not.</span>
<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> (CodeAgent, DuckDuckGoSearchTool, InferenceClientModel)

search_tool = DuckDuckGoSearchTool()
agent = CodeAgent(tools=[search_tool], model=InferenceClientModel())

agent.run(<span class="hljs-string">&quot;Can eating carrots improve your vision?&quot;</span>)`,wrap:!1}}),Xe=new J({props:{title:"6. Observability Metrics Overview",local:"6-observability-metrics-overview",headingTag:"h4"}}),Ye=new J({props:{title:"Offline Evaluation",local:"offline-evaluation",headingTag:"h2"}}),He=new J({props:{title:"Dataset Evaluation",local:"dataset-evaluation",headingTag:"h3"}}),Se=new h({props:{code:"aW1wb3J0JTIwcGFuZGFzJTIwYXMlMjBwZCUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMGxvYWRfZGF0YXNldCUwQSUwQSUyMyUyMEZldGNoJTIwR1NNOEslMjBmcm9tJTIwSHVnZ2luZyUyMEZhY2UlMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMm9wZW5haSUyRmdzbThrJTIyJTJDJTIwJ21haW4nJTJDJTIwc3BsaXQlM0QndHJhaW4nKSUwQWRmJTIwJTNEJTIwcGQuRGF0YUZyYW1lKGRhdGFzZXQpJTBBcHJpbnQoJTIyRmlyc3QlMjBmZXclMjByb3dzJTIwb2YlMjBHU004SyUyMGRhdGFzZXQlM0ElMjIpJTBBcHJpbnQoZGYuaGVhZCgpKQ==",highlighted:`<span class="hljs-keyword">import</span> pandas <span class="hljs-keyword">as</span> pd
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-comment"># Fetch GSM8K from Hugging Face</span>
dataset = load_dataset(<span class="hljs-string">&quot;openai/gsm8k&quot;</span>, <span class="hljs-string">&#x27;main&#x27;</span>, split=<span class="hljs-string">&#x27;train&#x27;</span>)
df = pd.DataFrame(dataset)
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;First few rows of GSM8K dataset:&quot;</span>)
<span class="hljs-built_in">print</span>(df.head())`,wrap:!1}}),qe=new h({props:{code:"ZnJvbSUyMGxhbmdmdXNlJTIwaW1wb3J0JTIwTGFuZ2Z1c2UlMEFsYW5nZnVzZSUyMCUzRCUyMExhbmdmdXNlKCklMEElMEFsYW5nZnVzZV9kYXRhc2V0X25hbWUlMjAlM0QlMjAlMjJnc204a19kYXRhc2V0X2h1Z2dpbmdmYWNlJTIyJTBBJTBBJTIzJTIwQ3JlYXRlJTIwYSUyMGRhdGFzZXQlMjBpbiUyMExhbmdmdXNlJTBBbGFuZ2Z1c2UuY3JlYXRlX2RhdGFzZXQoJTBBJTIwJTIwJTIwJTIwbmFtZSUzRGxhbmdmdXNlX2RhdGFzZXRfbmFtZSUyQyUwQSUyMCUyMCUyMCUyMGRlc2NyaXB0aW9uJTNEJTIyR1NNOEslMjBiZW5jaG1hcmslMjBkYXRhc2V0JTIwdXBsb2FkZWQlMjBmcm9tJTIwSHVnZ2luZ2ZhY2UlMjIlMkMlMEElMjAlMjAlMjAlMjBtZXRhZGF0YSUzRCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmRhdGUlMjIlM0ElMjAlMjIyMDI1LTAzLTEwJTIyJTJDJTIwJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydHlwZSUyMiUzQSUyMCUyMmJlbmNobWFyayUyMiUwQSUyMCUyMCUyMCUyMCU3RCUwQSk=",highlighted:`<span class="hljs-keyword">from</span> langfuse <span class="hljs-keyword">import</span> Langfuse
langfuse = Langfuse()

langfuse_dataset_name = <span class="hljs-string">&quot;gsm8k_dataset_huggingface&quot;</span>

<span class="hljs-comment"># Create a dataset in Langfuse</span>
langfuse.create_dataset(
    name=langfuse_dataset_name,
    description=<span class="hljs-string">&quot;GSM8K benchmark dataset uploaded from Huggingface&quot;</span>,
    metadata={
        <span class="hljs-string">&quot;date&quot;</span>: <span class="hljs-string">&quot;2025-03-10&quot;</span>, 
        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;benchmark&quot;</span>
    }
)`,wrap:!1}}),Pe=new h({props:{code:"Zm9yJTIwaWR4JTJDJTIwcm93JTIwaW4lMjBkZi5pdGVycm93cygpJTNBJTBBJTIwJTIwJTIwJTIwbGFuZ2Z1c2UuY3JlYXRlX2RhdGFzZXRfaXRlbSglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBkYXRhc2V0X25hbWUlM0RsYW5nZnVzZV9kYXRhc2V0X25hbWUlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpbnB1dCUzRCU3QiUyMnRleHQlMjIlM0ElMjByb3clNUIlMjJxdWVzdGlvbiUyMiU1RCU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGV4cGVjdGVkX291dHB1dCUzRCU3QiUyMnRleHQlMjIlM0ElMjByb3clNUIlMjJhbnN3ZXIlMjIlNUQlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtZXRhZGF0YSUzRCU3QiUyMnNvdXJjZV9pbmRleCUyMiUzQSUyMGlkeCU3RCUwQSUyMCUyMCUyMCUyMCklMEElMjAlMjAlMjAlMjBpZiUyMGlkeCUyMCUzRSUzRCUyMDklM0ElMjAlMjMlMjBVcGxvYWQlMjBvbmx5JTIwdGhlJTIwZmlyc3QlMjAxMCUyMGl0ZW1zJTIwZm9yJTIwZGVtb25zdHJhdGlvbiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGJyZWFr",highlighted:`<span class="hljs-keyword">for</span> idx, row <span class="hljs-keyword">in</span> df.iterrows():
    langfuse.create_dataset_item(
        dataset_name=langfuse_dataset_name,
        <span class="hljs-built_in">input</span>={<span class="hljs-string">&quot;text&quot;</span>: row[<span class="hljs-string">&quot;question&quot;</span>]},
        expected_output={<span class="hljs-string">&quot;text&quot;</span>: row[<span class="hljs-string">&quot;answer&quot;</span>]},
        metadata={<span class="hljs-string">&quot;source_index&quot;</span>: idx}
    )
    <span class="hljs-keyword">if</span> idx &gt;= <span class="hljs-number">9</span>: <span class="hljs-comment"># Upload only the first 10 items for demonstration</span>
        <span class="hljs-keyword">break</span>`,wrap:!1}}),Ke=new J({props:{title:"Running the Agent on the Dataset",local:"running-the-agent-on-the-dataset",headingTag:"h4"}}),lt=new h({props:{code:"ZnJvbSUyMG9wZW50ZWxlbWV0cnkudHJhY2UlMjBpbXBvcnQlMjBmb3JtYXRfdHJhY2VfaWQlMEFmcm9tJTIwc21vbGFnZW50cyUyMGltcG9ydCUyMChDb2RlQWdlbnQlMkMlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCUyQyUyMExpdGVMTE1Nb2RlbCklMEElMEElMjMlMjBFeGFtcGxlJTNBJTIwdXNpbmclMjBJbmZlcmVuY2VDbGllbnRNb2RlbCUyMG9yJTIwTGl0ZUxMTU1vZGVsJTIwdG8lMjBhY2Nlc3MlMjBvcGVuYWklMkMlMjBhbnRocm9waWMlMkMlMjBnZW1pbmklMkMlMjBldGMuJTIwbW9kZWxzJTNBJTBBbW9kZWwlMjAlM0QlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCgpJTBBJTBBYWdlbnQlMjAlM0QlMjBDb2RlQWdlbnQoJTBBJTIwJTIwJTIwJTIwdG9vbHMlM0QlNUIlNUQlMkMlMEElMjAlMjAlMjAlMjBtb2RlbCUzRG1vZGVsJTJDJTBBJTIwJTIwJTIwJTIwYWRkX2Jhc2VfdG9vbHMlM0RUcnVlJTBBKSUwQSUwQWRlZiUyMHJ1bl9zbW9sYWdlbnQocXVlc3Rpb24pJTNBJTBBJTIwJTIwJTIwJTIwd2l0aCUyMHRyYWNlci5zdGFydF9hc19jdXJyZW50X3NwYW4oJTIyU21vbGFnZW50LVRyYWNlJTIyKSUyMGFzJTIwc3BhbiUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNwYW4uc2V0X2F0dHJpYnV0ZSglMjJsYW5nZnVzZS50YWclMjIlMkMlMjAlMjJkYXRhc2V0LXJ1biUyMiklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvdXRwdXQlMjAlM0QlMjBhZ2VudC5ydW4ocXVlc3Rpb24pJTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwY3VycmVudF9zcGFuJTIwJTNEJTIwdHJhY2UuZ2V0X2N1cnJlbnRfc3BhbigpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3Bhbl9jb250ZXh0JTIwJTNEJTIwY3VycmVudF9zcGFuLmdldF9zcGFuX2NvbnRleHQoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRyYWNlX2lkJTIwJTNEJTIwc3Bhbl9jb250ZXh0LnRyYWNlX2lkJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZm9ybWF0dGVkX3RyYWNlX2lkJTIwJTNEJTIwZm9ybWF0X3RyYWNlX2lkKHRyYWNlX2lkKSUwQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxhbmdmdXNlX3RyYWNlJTIwJTNEJTIwbGFuZ2Z1c2UudHJhY2UoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWQlM0Rmb3JtYXR0ZWRfdHJhY2VfaWQlMkMlMjAlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpbnB1dCUzRHF1ZXN0aW9uJTJDJTIwJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3V0cHV0JTNEb3V0cHV0JTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMGxhbmdmdXNlX3RyYWNlJTJDJTIwb3V0cHV0",highlighted:`<span class="hljs-keyword">from</span> opentelemetry.trace <span class="hljs-keyword">import</span> format_trace_id
<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> (CodeAgent, InferenceClientModel, LiteLLMModel)

<span class="hljs-comment"># Example: using InferenceClientModel or LiteLLMModel to access openai, anthropic, gemini, etc. models:</span>
model = InferenceClientModel()

agent = CodeAgent(
    tools=[],
    model=model,
    add_base_tools=<span class="hljs-literal">True</span>
)

<span class="hljs-keyword">def</span> <span class="hljs-title function_">run_smolagent</span>(<span class="hljs-params">question</span>):
    <span class="hljs-keyword">with</span> tracer.start_as_current_span(<span class="hljs-string">&quot;Smolagent-Trace&quot;</span>) <span class="hljs-keyword">as</span> span:
        span.set_attribute(<span class="hljs-string">&quot;langfuse.tag&quot;</span>, <span class="hljs-string">&quot;dataset-run&quot;</span>)
        output = agent.run(question)

        current_span = trace.get_current_span()
        span_context = current_span.get_span_context()
        trace_id = span_context.trace_id
        formatted_trace_id = format_trace_id(trace_id)

        langfuse_trace = langfuse.trace(
            <span class="hljs-built_in">id</span>=formatted_trace_id, 
            <span class="hljs-built_in">input</span>=question, 
            output=output
        )
    <span class="hljs-keyword">return</span> langfuse_trace, output`,wrap:!1}}),st=new h({props:{code:"ZGF0YXNldCUyMCUzRCUyMGxhbmdmdXNlLmdldF9kYXRhc2V0KGxhbmdmdXNlX2RhdGFzZXRfbmFtZSklMEElMEElMjMlMjBSdW4lMjBvdXIlMjBhZ2VudCUyMGFnYWluc3QlMjBlYWNoJTIwZGF0YXNldCUyMGl0ZW0lMjAobGltaXRlZCUyMHRvJTIwZmlyc3QlMjAxMCUyMGFib3ZlKSUwQWZvciUyMGl0ZW0lMjBpbiUyMGRhdGFzZXQuaXRlbXMlM0ElMEElMjAlMjAlMjAlMjBsYW5nZnVzZV90cmFjZSUyQyUyMG91dHB1dCUyMCUzRCUyMHJ1bl9zbW9sYWdlbnQoaXRlbS5pbnB1dCU1QiUyMnRleHQlMjIlNUQpJTBBJTBBJTIwJTIwJTIwJTIwJTIzJTIwTGluayUyMHRoZSUyMHRyYWNlJTIwdG8lMjB0aGUlMjBkYXRhc2V0JTIwaXRlbSUyMGZvciUyMGFuYWx5c2lzJTBBJTIwJTIwJTIwJTIwaXRlbS5saW5rKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxhbmdmdXNlX3RyYWNlJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcnVuX25hbWUlM0QlMjJzbW9sYWdlbnQtbm90ZWJvb2stcnVuLTAxJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcnVuX21ldGFkYXRhJTNEJTdCJTIwJTIybW9kZWwlMjIlM0ElMjBtb2RlbC5tb2RlbF9pZCUyMCU3RCUwQSUyMCUyMCUyMCUyMCklMEElMEElMjAlMjAlMjAlMjAlMjMlMjBPcHRpb25hbGx5JTJDJTIwc3RvcmUlMjBhJTIwcXVpY2slMjBldmFsdWF0aW9uJTIwc2NvcmUlMjBmb3IlMjBkZW1vbnN0cmF0aW9uJTBBJTIwJTIwJTIwJTIwbGFuZ2Z1c2VfdHJhY2Uuc2NvcmUoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbmFtZSUzRCUyMiUzQ2V4YW1wbGVfZXZhbCUzRSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHZhbHVlJTNEMSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGNvbW1lbnQlM0QlMjJUaGlzJTIwaXMlMjBhJTIwY29tbWVudCUyMiUwQSUyMCUyMCUyMCUyMCklMEElMEElMjMlMjBGbHVzaCUyMGRhdGElMjB0byUyMGVuc3VyZSUyMGFsbCUyMHRlbGVtZXRyeSUyMGlzJTIwc2VudCUwQWxhbmdmdXNlLmZsdXNoKCk=",highlighted:`dataset = langfuse.get_dataset(langfuse_dataset_name)

<span class="hljs-comment"># Run our agent against each dataset item (limited to first 10 above)</span>
<span class="hljs-keyword">for</span> item <span class="hljs-keyword">in</span> dataset.items:
    langfuse_trace, output = run_smolagent(item.<span class="hljs-built_in">input</span>[<span class="hljs-string">&quot;text&quot;</span>])

    <span class="hljs-comment"># Link the trace to the dataset item for analysis</span>
    item.link(
        langfuse_trace,
        run_name=<span class="hljs-string">&quot;smolagent-notebook-run-01&quot;</span>,
        run_metadata={ <span class="hljs-string">&quot;model&quot;</span>: model.model_id }
    )

    <span class="hljs-comment"># Optionally, store a quick evaluation score for demonstration</span>
    langfuse_trace.score(
        name=<span class="hljs-string">&quot;&lt;example_eval&gt;&quot;</span>,
        value=<span class="hljs-number">1</span>,
        comment=<span class="hljs-string">&quot;This is a comment&quot;</span>
    )

<span class="hljs-comment"># Flush data to ensure all telemetry is sent</span>
langfuse.flush()`,wrap:!1}}),rt=new J({props:{title:"Final Thoughts",local:"final-thoughts",headingTag:"h2"}}),ct=new kn({props:{source:"https://github.com/huggingface/agents-course/blob/main/units/en/bonus-unit2/monitoring-and-evaluating-agents-notebook.mdx"}}),{c(){y=i("meta"),d=n(),j=i("p"),b=n(),p(w.$$.fragment),U=n(),p(I.$$.fragment),Jt=n(),p(f.$$.fragment),wt=n(),g=i("p"),g.innerHTML=os,yt=n(),C=i("p"),C.textContent=rs,dt=n(),v=i("ul"),v.innerHTML=ps,ht=n(),p(B.$$.fragment),bt=n(),Z=i("p"),Z.textContent=Ms,jt=n(),k=i("p"),k.innerHTML=us,Ut=n(),R=i("p"),R.innerHTML=cs,ft=n(),p(V.$$.fragment),It=n(),W=i("p"),W.textContent=ms,gt=n(),p(G.$$.fragment),Ct=n(),p($.$$.fragment),vt=n(),x=i("p"),x.innerHTML=Ts,Bt=n(),E=i("p"),E.innerHTML=Js,Zt=n(),X=i("p"),X.textContent=ws,kt=n(),p(N.$$.fragment),Rt=n(),_=i("p"),_.textContent=ys,Vt=n(),p(Y.$$.fragment),Wt=n(),A=i("p"),A.textContent=ds,Gt=n(),p(H.$$.fragment),$t=n(),p(Q.$$.fragment),xt=n(),L=i("p"),L.innerHTML=hs,Et=n(),p(F.$$.fragment),Xt=n(),S=i("p"),S.innerHTML=bs,Nt=n(),z=i("p"),z.textContent=js,_t=n(),q=i("p"),q.innerHTML=Us,Yt=n(),P=i("p"),P.innerHTML=fs,At=n(),p(D.$$.fragment),Ht=n(),K=i("p"),K.textContent=Is,Qt=n(),p(O.$$.fragment),Lt=n(),p(ee.$$.fragment),Ft=n(),te=i("p"),te.innerHTML=gs,St=n(),le=i("ul"),le.innerHTML=Cs,zt=n(),se=i("p"),se.textContent=vs,qt=n(),ne=i("p"),ne.innerHTML=Bs,Pt=n(),ae=i("p"),ae.innerHTML=Zs,Dt=n(),p(ie.$$.fragment),Kt=n(),oe=i("p"),oe.textContent=ks,Ot=n(),p(re.$$.fragment),el=n(),pe=i("ol"),pe.innerHTML=Rs,tl=n(),Me=i("p"),Me.textContent=Vs,ll=n(),p(ue.$$.fragment),sl=n(),ce=i("p"),ce.innerHTML=Ws,nl=n(),me=i("p"),me.innerHTML=Gs,al=n(),Te=i("p"),Te.innerHTML=$s,il=n(),p(Je.$$.fragment),ol=n(),we=i("p"),we.textContent=xs,rl=n(),ye=i("p"),ye.innerHTML=Es,pl=n(),de=i("p"),de.innerHTML=Xs,Ml=n(),p(he.$$.fragment),ul=n(),be=i("p"),be.innerHTML=Ns,cl=n(),p(je.$$.fragment),ml=n(),Ue=i("p"),Ue.innerHTML=_s,Tl=n(),p(fe.$$.fragment),Jl=n(),Ie=i("p"),Ie.innerHTML=Ys,wl=n(),ge=i("p"),ge.textContent=As,yl=n(),p(Ce.$$.fragment),dl=n(),ve=i("p"),ve.textContent=Hs,hl=n(),Be=i("p"),Be.innerHTML=Qs,bl=n(),p(Ze.$$.fragment),jl=n(),ke=i("p"),ke.textContent=Ls,Ul=n(),Re=i("p"),Re.innerHTML=Fs,fl=n(),Ve=i("ol"),Ve.innerHTML=Ss,Il=n(),We=i("p"),We.textContent=zs,gl=n(),Ge=i("p"),Ge.innerHTML=qs,Cl=n(),p($e.$$.fragment),vl=n(),xe=i("p"),xe.textContent=Ps,Bl=n(),Ee=i("p"),Ee.innerHTML=Ds,Zl=n(),p(Xe.$$.fragment),kl=n(),Ne=i("p"),Ne.textContent=Ks,Rl=n(),_e=i("p"),_e.innerHTML=Os,Vl=n(),p(Ye.$$.fragment),Wl=n(),Ae=i("p"),Ae.innerHTML=en,Gl=n(),p(He.$$.fragment),$l=n(),Qe=i("p"),Qe.textContent=tn,xl=n(),Le=i("ol"),Le.innerHTML=ln,El=n(),Fe=i("p"),Fe.innerHTML=sn,Xl=n(),p(Se.$$.fragment),Nl=n(),ze=i("p"),ze.textContent=nn,_l=n(),p(qe.$$.fragment),Yl=n(),p(Pe.$$.fragment),Al=n(),De=i("p"),De.innerHTML=an,Hl=n(),p(Ke.$$.fragment),Ql=n(),Oe=i("p"),Oe.innerHTML=on,Ll=n(),et=i("ol"),et.innerHTML=rn,Fl=n(),tt=i("p"),tt.textContent=pn,Sl=n(),p(lt.$$.fragment),zl=n(),p(st.$$.fragment),ql=n(),nt=i("p"),nt.textContent=Mn,Pl=n(),at=i("ul"),at.innerHTML=un,Dl=n(),it=i("p"),it.textContent=cn,Kl=n(),ot=i("p"),ot.innerHTML=mn,Ol=n(),p(rt.$$.fragment),es=n(),pt=i("p"),pt.textContent=Tn,ts=n(),Mt=i("ol"),Mt.innerHTML=Jn,ls=n(),ut=i("p"),ut.textContent=wn,ss=n(),p(ct.$$.fragment),ns=n(),mt=i("p"),this.h()},l(e){const t=Cn("svelte-u9bgzb",document.head);y=o(t,"META",{name:!0,content:!0}),t.forEach(l),d=a(e),j=o(e,"P",{}),dn(j).forEach(l),b=a(e),M(w.$$.fragment,e),U=a(e),M(I.$$.fragment,e),Jt=a(e),M(f.$$.fragment,e),wt=a(e),g=o(e,"P",{"data-svelte-h":!0}),r(g)!=="svelte-1hjcrzt"&&(g.innerHTML=os),yt=a(e),C=o(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-foopw1"&&(C.textContent=rs),dt=a(e),v=o(e,"UL",{"data-svelte-h":!0}),r(v)!=="svelte-owrpod"&&(v.innerHTML=ps),ht=a(e),M(B.$$.fragment,e),bt=a(e),Z=o(e,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-5cu48y"&&(Z.textContent=Ms),jt=a(e),k=o(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-tid2rn"&&(k.innerHTML=us),Ut=a(e),R=o(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-11ima5v"&&(R.innerHTML=cs),ft=a(e),M(V.$$.fragment,e),It=a(e),W=o(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-13k1zsa"&&(W.textContent=ms),gt=a(e),M(G.$$.fragment,e),Ct=a(e),M($.$$.fragment,e),vt=a(e),x=o(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-1om0xhg"&&(x.innerHTML=Ts),Bt=a(e),E=o(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-10zlua1"&&(E.innerHTML=Js),Zt=a(e),X=o(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-xs952x"&&(X.textContent=ws),kt=a(e),M(N.$$.fragment,e),Rt=a(e),_=o(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-188d5j6"&&(_.textContent=ys),Vt=a(e),M(Y.$$.fragment,e),Wt=a(e),A=o(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-fyh0fv"&&(A.textContent=ds),Gt=a(e),M(H.$$.fragment,e),$t=a(e),M(Q.$$.fragment,e),xt=a(e),L=o(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-18gebex"&&(L.innerHTML=hs),Et=a(e),M(F.$$.fragment,e),Xt=a(e),S=o(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-vzfgml"&&(S.innerHTML=bs),Nt=a(e),z=o(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-17kovw7"&&(z.textContent=js),_t=a(e),q=o(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-1cb993n"&&(q.innerHTML=Us),Yt=a(e),P=o(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-3d3s8c"&&(P.innerHTML=fs),At=a(e),M(D.$$.fragment,e),Ht=a(e),K=o(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-vj8duz"&&(K.textContent=Is),Qt=a(e),M(O.$$.fragment,e),Lt=a(e),M(ee.$$.fragment,e),Ft=a(e),te=o(e,"P",{"data-svelte-h":!0}),r(te)!=="svelte-11qm5kf"&&(te.innerHTML=gs),St=a(e),le=o(e,"UL",{"data-svelte-h":!0}),r(le)!=="svelte-1pzu7di"&&(le.innerHTML=Cs),zt=a(e),se=o(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-5g8r1i"&&(se.textContent=vs),qt=a(e),ne=o(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-yhkq5w"&&(ne.innerHTML=Bs),Pt=a(e),ae=o(e,"P",{"data-svelte-h":!0}),r(ae)!=="svelte-19v4344"&&(ae.innerHTML=Zs),Dt=a(e),M(ie.$$.fragment,e),Kt=a(e),oe=o(e,"P",{"data-svelte-h":!0}),r(oe)!=="svelte-1m3q9s4"&&(oe.textContent=ks),Ot=a(e),M(re.$$.fragment,e),el=a(e),pe=o(e,"OL",{"data-svelte-h":!0}),r(pe)!=="svelte-it9cbz"&&(pe.innerHTML=Rs),tl=a(e),Me=o(e,"P",{"data-svelte-h":!0}),r(Me)!=="svelte-1gkbldi"&&(Me.textContent=Vs),ll=a(e),M(ue.$$.fragment,e),sl=a(e),ce=o(e,"P",{"data-svelte-h":!0}),r(ce)!=="svelte-zy3zhh"&&(ce.innerHTML=Ws),nl=a(e),me=o(e,"P",{"data-svelte-h":!0}),r(me)!=="svelte-dard47"&&(me.innerHTML=Gs),al=a(e),Te=o(e,"P",{"data-svelte-h":!0}),r(Te)!=="svelte-19v4344"&&(Te.innerHTML=$s),il=a(e),M(Je.$$.fragment,e),ol=a(e),we=o(e,"P",{"data-svelte-h":!0}),r(we)!=="svelte-v1au4h"&&(we.textContent=xs),rl=a(e),ye=o(e,"P",{"data-svelte-h":!0}),r(ye)!=="svelte-1org4pj"&&(ye.innerHTML=Es),pl=a(e),de=o(e,"P",{"data-svelte-h":!0}),r(de)!=="svelte-19v4344"&&(de.innerHTML=Xs),Ml=a(e),M(he.$$.fragment,e),ul=a(e),be=o(e,"P",{"data-svelte-h":!0}),r(be)!=="svelte-17m5rhs"&&(be.innerHTML=Ns),cl=a(e),M(je.$$.fragment,e),ml=a(e),Ue=o(e,"P",{"data-svelte-h":!0}),r(Ue)!=="svelte-1gx91hu"&&(Ue.innerHTML=_s),Tl=a(e),M(fe.$$.fragment,e),Jl=a(e),Ie=o(e,"P",{"data-svelte-h":!0}),r(Ie)!=="svelte-1t6vqwk"&&(Ie.innerHTML=Ys),wl=a(e),ge=o(e,"P",{"data-svelte-h":!0}),r(ge)!=="svelte-1y4hb4w"&&(ge.textContent=As),yl=a(e),M(Ce.$$.fragment,e),dl=a(e),ve=o(e,"P",{"data-svelte-h":!0}),r(ve)!=="svelte-qczj9m"&&(ve.textContent=Hs),hl=a(e),Be=o(e,"P",{"data-svelte-h":!0}),r(Be)!=="svelte-e6ive4"&&(Be.innerHTML=Qs),bl=a(e),M(Ze.$$.fragment,e),jl=a(e),ke=o(e,"P",{"data-svelte-h":!0}),r(ke)!=="svelte-1guzmu1"&&(ke.textContent=Ls),Ul=a(e),Re=o(e,"P",{"data-svelte-h":!0}),r(Re)!=="svelte-13jor3c"&&(Re.innerHTML=Fs),fl=a(e),Ve=o(e,"OL",{"data-svelte-h":!0}),r(Ve)!=="svelte-8y9f4i"&&(Ve.innerHTML=Ss),Il=a(e),We=o(e,"P",{"data-svelte-h":!0}),r(We)!=="svelte-6rieqh"&&(We.textContent=zs),gl=a(e),Ge=o(e,"P",{"data-svelte-h":!0}),r(Ge)!=="svelte-1uar592"&&(Ge.innerHTML=qs),Cl=a(e),M($e.$$.fragment,e),vl=a(e),xe=o(e,"P",{"data-svelte-h":!0}),r(xe)!=="svelte-3xsjjj"&&(xe.textContent=Ps),Bl=a(e),Ee=o(e,"P",{"data-svelte-h":!0}),r(Ee)!=="svelte-zj9pt2"&&(Ee.innerHTML=Ds),Zl=a(e),M(Xe.$$.fragment,e),kl=a(e),Ne=o(e,"P",{"data-svelte-h":!0}),r(Ne)!=="svelte-1053it2"&&(Ne.textContent=Ks),Rl=a(e),_e=o(e,"P",{"data-svelte-h":!0}),r(_e)!=="svelte-1jemoxg"&&(_e.innerHTML=Os),Vl=a(e),M(Ye.$$.fragment,e),Wl=a(e),Ae=o(e,"P",{"data-svelte-h":!0}),r(Ae)!=="svelte-12emzh2"&&(Ae.innerHTML=en),Gl=a(e),M(He.$$.fragment,e),$l=a(e),Qe=o(e,"P",{"data-svelte-h":!0}),r(Qe)!=="svelte-nxef74"&&(Qe.textContent=tn),xl=a(e),Le=o(e,"OL",{"data-svelte-h":!0}),r(Le)!=="svelte-1ys56q5"&&(Le.innerHTML=ln),El=a(e),Fe=o(e,"P",{"data-svelte-h":!0}),r(Fe)!=="svelte-o23tl"&&(Fe.innerHTML=sn),Xl=a(e),M(Se.$$.fragment,e),Nl=a(e),ze=o(e,"P",{"data-svelte-h":!0}),r(ze)!=="svelte-14neeab"&&(ze.textContent=nn),_l=a(e),M(qe.$$.fragment,e),Yl=a(e),M(Pe.$$.fragment,e),Al=a(e),De=o(e,"P",{"data-svelte-h":!0}),r(De)!=="svelte-giwu4e"&&(De.innerHTML=an),Hl=a(e),M(Ke.$$.fragment,e),Ql=a(e),Oe=o(e,"P",{"data-svelte-h":!0}),r(Oe)!=="svelte-y12uij"&&(Oe.innerHTML=on),Ll=a(e),et=o(e,"OL",{"data-svelte-h":!0}),r(et)!=="svelte-m65a60"&&(et.innerHTML=rn),Fl=a(e),tt=o(e,"P",{"data-svelte-h":!0}),r(tt)!=="svelte-1ew78oh"&&(tt.textContent=pn),Sl=a(e),M(lt.$$.fragment,e),zl=a(e),M(st.$$.fragment,e),ql=a(e),nt=o(e,"P",{"data-svelte-h":!0}),r(nt)!=="svelte-1ebq4ig"&&(nt.textContent=Mn),Pl=a(e),at=o(e,"UL",{"data-svelte-h":!0}),r(at)!=="svelte-1lunl6l"&&(at.innerHTML=un),Dl=a(e),it=o(e,"P",{"data-svelte-h":!0}),r(it)!=="svelte-gt2dc"&&(it.textContent=cn),Kl=a(e),ot=o(e,"P",{"data-svelte-h":!0}),r(ot)!=="svelte-ukc2vx"&&(ot.innerHTML=mn),Ol=a(e),M(rt.$$.fragment,e),es=a(e),pt=o(e,"P",{"data-svelte-h":!0}),r(pt)!=="svelte-1xbvrw5"&&(pt.textContent=Tn),ts=a(e),Mt=o(e,"OL",{"data-svelte-h":!0}),r(Mt)!=="svelte-1u9pd9c"&&(Mt.innerHTML=Jn),ls=a(e),ut=o(e,"P",{"data-svelte-h":!0}),r(ut)!=="svelte-3bxv5s"&&(ut.textContent=wn),ss=a(e),M(ct.$$.fragment,e),ns=a(e),mt=o(e,"P",{}),dn(mt).forEach(l),this.h()},h(){is(y,"name","hf:doc:metadata"),is(y,"content",Wn)},m(e,t){vn(document.head,y),s(e,d,t),s(e,j,t),s(e,b,t),u(w,e,t),s(e,U,t),u(I,e,t),s(e,Jt,t),u(f,e,t),s(e,wt,t),s(e,g,t),s(e,yt,t),s(e,C,t),s(e,dt,t),s(e,v,t),s(e,ht,t),u(B,e,t),s(e,bt,t),s(e,Z,t),s(e,jt,t),s(e,k,t),s(e,Ut,t),s(e,R,t),s(e,ft,t),u(V,e,t),s(e,It,t),s(e,W,t),s(e,gt,t),u(G,e,t),s(e,Ct,t),u($,e,t),s(e,vt,t),s(e,x,t),s(e,Bt,t),s(e,E,t),s(e,Zt,t),s(e,X,t),s(e,kt,t),u(N,e,t),s(e,Rt,t),s(e,_,t),s(e,Vt,t),u(Y,e,t),s(e,Wt,t),s(e,A,t),s(e,Gt,t),u(H,e,t),s(e,$t,t),u(Q,e,t),s(e,xt,t),s(e,L,t),s(e,Et,t),u(F,e,t),s(e,Xt,t),s(e,S,t),s(e,Nt,t),s(e,z,t),s(e,_t,t),s(e,q,t),s(e,Yt,t),s(e,P,t),s(e,At,t),u(D,e,t),s(e,Ht,t),s(e,K,t),s(e,Qt,t),u(O,e,t),s(e,Lt,t),u(ee,e,t),s(e,Ft,t),s(e,te,t),s(e,St,t),s(e,le,t),s(e,zt,t),s(e,se,t),s(e,qt,t),s(e,ne,t),s(e,Pt,t),s(e,ae,t),s(e,Dt,t),u(ie,e,t),s(e,Kt,t),s(e,oe,t),s(e,Ot,t),u(re,e,t),s(e,el,t),s(e,pe,t),s(e,tl,t),s(e,Me,t),s(e,ll,t),u(ue,e,t),s(e,sl,t),s(e,ce,t),s(e,nl,t),s(e,me,t),s(e,al,t),s(e,Te,t),s(e,il,t),u(Je,e,t),s(e,ol,t),s(e,we,t),s(e,rl,t),s(e,ye,t),s(e,pl,t),s(e,de,t),s(e,Ml,t),u(he,e,t),s(e,ul,t),s(e,be,t),s(e,cl,t),u(je,e,t),s(e,ml,t),s(e,Ue,t),s(e,Tl,t),u(fe,e,t),s(e,Jl,t),s(e,Ie,t),s(e,wl,t),s(e,ge,t),s(e,yl,t),u(Ce,e,t),s(e,dl,t),s(e,ve,t),s(e,hl,t),s(e,Be,t),s(e,bl,t),u(Ze,e,t),s(e,jl,t),s(e,ke,t),s(e,Ul,t),s(e,Re,t),s(e,fl,t),s(e,Ve,t),s(e,Il,t),s(e,We,t),s(e,gl,t),s(e,Ge,t),s(e,Cl,t),u($e,e,t),s(e,vl,t),s(e,xe,t),s(e,Bl,t),s(e,Ee,t),s(e,Zl,t),u(Xe,e,t),s(e,kl,t),s(e,Ne,t),s(e,Rl,t),s(e,_e,t),s(e,Vl,t),u(Ye,e,t),s(e,Wl,t),s(e,Ae,t),s(e,Gl,t),u(He,e,t),s(e,$l,t),s(e,Qe,t),s(e,xl,t),s(e,Le,t),s(e,El,t),s(e,Fe,t),s(e,Xl,t),u(Se,e,t),s(e,Nl,t),s(e,ze,t),s(e,_l,t),u(qe,e,t),s(e,Yl,t),u(Pe,e,t),s(e,Al,t),s(e,De,t),s(e,Hl,t),u(Ke,e,t),s(e,Ql,t),s(e,Oe,t),s(e,Ll,t),s(e,et,t),s(e,Fl,t),s(e,tt,t),s(e,Sl,t),u(lt,e,t),s(e,zl,t),u(st,e,t),s(e,ql,t),s(e,nt,t),s(e,Pl,t),s(e,at,t),s(e,Dl,t),s(e,it,t),s(e,Kl,t),s(e,ot,t),s(e,Ol,t),u(rt,e,t),s(e,es,t),s(e,pt,t),s(e,ts,t),s(e,Mt,t),s(e,ls,t),s(e,ut,t),s(e,ss,t),u(ct,e,t),s(e,ns,t),s(e,mt,t),as=!0},p(e,[t]){const yn={};t&2&&(yn.$$scope={dirty:t,ctx:e}),f.$set(yn)},i(e){as||(c(w.$$.fragment,e),c(I.$$.fragment,e),c(f.$$.fragment,e),c(B.$$.fragment,e),c(V.$$.fragment,e),c(G.$$.fragment,e),c($.$$.fragment,e),c(N.$$.fragment,e),c(Y.$$.fragment,e),c(H.$$.fragment,e),c(Q.$$.fragment,e),c(F.$$.fragment,e),c(D.$$.fragment,e),c(O.$$.fragment,e),c(ee.$$.fragment,e),c(ie.$$.fragment,e),c(re.$$.fragment,e),c(ue.$$.fragment,e),c(Je.$$.fragment,e),c(he.$$.fragment,e),c(je.$$.fragment,e),c(fe.$$.fragment,e),c(Ce.$$.fragment,e),c(Ze.$$.fragment,e),c($e.$$.fragment,e),c(Xe.$$.fragment,e),c(Ye.$$.fragment,e),c(He.$$.fragment,e),c(Se.$$.fragment,e),c(qe.$$.fragment,e),c(Pe.$$.fragment,e),c(Ke.$$.fragment,e),c(lt.$$.fragment,e),c(st.$$.fragment,e),c(rt.$$.fragment,e),c(ct.$$.fragment,e),as=!0)},o(e){m(w.$$.fragment,e),m(I.$$.fragment,e),m(f.$$.fragment,e),m(B.$$.fragment,e),m(V.$$.fragment,e),m(G.$$.fragment,e),m($.$$.fragment,e),m(N.$$.fragment,e),m(Y.$$.fragment,e),m(H.$$.fragment,e),m(Q.$$.fragment,e),m(F.$$.fragment,e),m(D.$$.fragment,e),m(O.$$.fragment,e),m(ee.$$.fragment,e),m(ie.$$.fragment,e),m(re.$$.fragment,e),m(ue.$$.fragment,e),m(Je.$$.fragment,e),m(he.$$.fragment,e),m(je.$$.fragment,e),m(fe.$$.fragment,e),m(Ce.$$.fragment,e),m(Ze.$$.fragment,e),m($e.$$.fragment,e),m(Xe.$$.fragment,e),m(Ye.$$.fragment,e),m(He.$$.fragment,e),m(Se.$$.fragment,e),m(qe.$$.fragment,e),m(Pe.$$.fragment,e),m(Ke.$$.fragment,e),m(lt.$$.fragment,e),m(st.$$.fragment,e),m(rt.$$.fragment,e),m(ct.$$.fragment,e),as=!1},d(e){e&&(l(d),l(j),l(b),l(U),l(Jt),l(wt),l(g),l(yt),l(C),l(dt),l(v),l(ht),l(bt),l(Z),l(jt),l(k),l(Ut),l(R),l(ft),l(It),l(W),l(gt),l(Ct),l(vt),l(x),l(Bt),l(E),l(Zt),l(X),l(kt),l(Rt),l(_),l(Vt),l(Wt),l(A),l(Gt),l($t),l(xt),l(L),l(Et),l(Xt),l(S),l(Nt),l(z),l(_t),l(q),l(Yt),l(P),l(At),l(Ht),l(K),l(Qt),l(Lt),l(Ft),l(te),l(St),l(le),l(zt),l(se),l(qt),l(ne),l(Pt),l(ae),l(Dt),l(Kt),l(oe),l(Ot),l(el),l(pe),l(tl),l(Me),l(ll),l(sl),l(ce),l(nl),l(me),l(al),l(Te),l(il),l(ol),l(we),l(rl),l(ye),l(pl),l(de),l(Ml),l(ul),l(be),l(cl),l(ml),l(Ue),l(Tl),l(Jl),l(Ie),l(wl),l(ge),l(yl),l(dl),l(ve),l(hl),l(Be),l(bl),l(jl),l(ke),l(Ul),l(Re),l(fl),l(Ve),l(Il),l(We),l(gl),l(Ge),l(Cl),l(vl),l(xe),l(Bl),l(Ee),l(Zl),l(kl),l(Ne),l(Rl),l(_e),l(Vl),l(Wl),l(Ae),l(Gl),l($l),l(Qe),l(xl),l(Le),l(El),l(Fe),l(Xl),l(Nl),l(ze),l(_l),l(Yl),l(Al),l(De),l(Hl),l(Ql),l(Oe),l(Ll),l(et),l(Fl),l(tt),l(Sl),l(zl),l(ql),l(nt),l(Pl),l(at),l(Dl),l(it),l(Kl),l(ot),l(Ol),l(es),l(pt),l(ts),l(Mt),l(ls),l(ut),l(ss),l(ns),l(mt)),l(y),T(w,e),T(I,e),T(f,e),T(B,e),T(V,e),T(G,e),T($,e),T(N,e),T(Y,e),T(H,e),T(Q,e),T(F,e),T(D,e),T(O,e),T(ee,e),T(ie,e),T(re,e),T(ue,e),T(Je,e),T(he,e),T(je,e),T(fe,e),T(Ce,e),T(Ze,e),T($e,e),T(Xe,e),T(Ye,e),T(He,e),T(Se,e),T(qe,e),T(Pe,e),T(Ke,e),T(lt,e),T(st,e),T(rt,e),T(ct,e)}}}const Wn='{"title":"Bonus Unit 2: Observability and Evaluation of Agents","local":"bonus-unit-2-observability-and-evaluation-of-agents","sections":[{"title":"Exercise Prerequisites 🏗️","local":"exercise-prerequisites-","sections":[],"depth":2},{"title":"Step 0: Install the Required Libraries","local":"step-0-install-the-required-libraries","sections":[],"depth":2},{"title":"Step 1: Instrument Your Agent","local":"step-1-instrument-your-agent","sections":[],"depth":2},{"title":"Step 2: Test Your Instrumentation","local":"step-2-test-your-instrumentation","sections":[],"depth":2},{"title":"Step 3: Observe and Evaluate a More Complex Agent","local":"step-3-observe-and-evaluate-a-more-complex-agent","sections":[{"title":"Trace Structure","local":"trace-structure","sections":[],"depth":3}],"depth":2},{"title":"Online Evaluation","local":"online-evaluation","sections":[{"title":"Common Metrics to Track in Production","local":"common-metrics-to-track-in-production","sections":[{"title":"1. Costs","local":"1-costs","sections":[],"depth":4},{"title":"2. Latency","local":"2-latency","sections":[],"depth":4},{"title":"3. Additional Attributes","local":"3-additional-attributes","sections":[],"depth":4},{"title":"4. User Feedback","local":"4-user-feedback","sections":[],"depth":4},{"title":"5. LLM-as-a-Judge","local":"5-llm-as-a-judge","sections":[],"depth":4},{"title":"6. Observability Metrics Overview","local":"6-observability-metrics-overview","sections":[],"depth":4}],"depth":3}],"depth":2},{"title":"Offline Evaluation","local":"offline-evaluation","sections":[{"title":"Dataset Evaluation","local":"dataset-evaluation","sections":[{"title":"Running the Agent on the Dataset","local":"running-the-agent-on-the-dataset","sections":[],"depth":4}],"depth":3}],"depth":2},{"title":"Final Thoughts","local":"final-thoughts","sections":[],"depth":2}],"depth":1}';function Gn(Tt){return Un(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class An extends In{constructor(y){super(),gn(this,y,Gn,Vn,jn,{})}}export{An as component};
