import{s as Vs,f as Gs,o as Rs,n as Al}from"../chunks/scheduler.f6319a2a.js";import{S as _s,i as Ss,g as i,s as n,r,A as Ns,h as o,f as l,c as a,j as Es,u,x as p,k as st,y as Qs,a as s,v as c,d as y,t as w,w as d}from"../chunks/index.85aa684c.js";import{T as Wl}from"../chunks/Tip.3d397a88.js";import{C}from"../chunks/CodeBlock.3400fc53.js";import{D as Hs}from"../chunks/DocNotebookDropdown.3fc3604b.js";import{H as T,E as Ys}from"../chunks/getInferenceSnippets.bcbc4a43.js";function Xs(j){let M,h='If you’re new to building agents, make sure to first read the <a href="../conceptual_guides/intro_agents">intro to agents</a> and the <a href="../guided_tour">guided tour of smolagents</a>.';return{c(){M=i("p"),M.innerHTML=h},l(J){M=o(J,"P",{"data-svelte-h":!0}),p(M)!=="svelte-1p1d9vw"&&(M.innerHTML=h)},m(J,U){s(J,M,U)},p:Al,d(J){J&&l(M)}}}function qs(j){let M,h="It’s important to understand that no local python sandbox can ever be completely secure. While our interpreter provides significant safety improvements over the standard Python interpreter, it is still possible for a determined attacker or a fine-tuned malicious LLM to find vulnerabilities and potentially harm your environment.",J,U,I="For example, if you’ve allowed packages like <code>Pillow</code> to process images, the LLM could generate code that creates thousands of large image files to fill your hard drive. Other advanced escape techniques might exploit deeper vulnerabilities in authorized packages.",f,b,k="Running LLM-generated code in your local environment always carries some inherent risk. The only way to run LLM-generated code with truly robust security isolation is to use remote execution options like E2B or Docker, as detailed below.";return{c(){M=i("p"),M.textContent=h,J=n(),U=i("p"),U.innerHTML=I,f=n(),b=i("p"),b.textContent=k},l(m){M=o(m,"P",{"data-svelte-h":!0}),p(M)!=="svelte-13ohzr"&&(M.textContent=h),J=a(m),U=o(m,"P",{"data-svelte-h":!0}),p(U)!=="svelte-1wfid17"&&(U.innerHTML=I),f=a(m),b=o(m,"P",{"data-svelte-h":!0}),p(b)!=="svelte-1zo76k"&&(b.textContent=k)},m(m,g){s(m,M,g),s(m,J,g),s(m,U,g),s(m,f,g),s(m,b,g)},p:Al,d(m){m&&(l(M),l(J),l(U),l(f),l(b))}}}function zs(j){let M,h=`Using the agent as a context manager (with the <code>with</code> statement) ensures that the E2B sandbox is cleaned up immediately after the agent completes its task.
Alternatively, you can manually call the agent’s <code>cleanup()</code> method.`;return{c(){M=i("p"),M.innerHTML=h},l(J){M=o(J,"P",{"data-svelte-h":!0}),p(M)!=="svelte-h2lp0n"&&(M.innerHTML=h)},m(J,U){s(J,M,U)},p:Al,d(J){J&&l(M)}}}function Fs(j){let M,h=`Using the agent as a context manager (with the <code>with</code> statement) ensures that the Docker container is cleaned immediately after the agent completes its task.
Alternatively, you can manually call the agent’s <code>cleanup()</code> method.`;return{c(){M=i("p"),M.innerHTML=h},l(J){M=o(J,"P",{"data-svelte-h":!0}),p(M)!=="svelte-hvigp3"&&(M.innerHTML=h)},m(J,U){s(J,M,U)},p:Al,d(J){J&&l(M)}}}function Ls(j){let M,h,J,U,I,f,b,k,m,g,$,nt,W,Gl='<a href="https://huggingface.co/papers/2402.01030" rel="nofollow">Multiple</a> <a href="https://huggingface.co/papers/2411.01747" rel="nofollow">research</a> <a href="https://huggingface.co/papers/2401.00812" rel="nofollow">papers</a> have shown that having the LLM write its actions (the tool calls) in code is much better than the current standard format for tool calling, which is across the industry different shades of “writing actions as a JSON of tools names and arguments to use”.',at,A,El="Why is code better? Well, because we crafted our code languages specifically to be great at expressing actions performed by a computer. If JSON snippets were a better way, this package would have been written in JSON snippets and the devil would be laughing at us.",it,G,Vl="Code is just a better way to express actions on a computer. It has better:",ot,E,Rl="<li><strong>Composability:</strong> could you nest JSON actions within each other, or define a set of JSON actions to re-use later, the same way you could just define a python function?</li> <li><strong>Object management:</strong> how do you store the output of an action like <code>generate_image</code> in JSON?</li> <li><strong>Generality:</strong> code is built to express simply anything you can have a computer do.</li> <li><strong>Representation in LLM training corpus:</strong> why not leverage this benediction of the sky that plenty of quality actions have already been included in LLM training corpus?</li>",pt,V,_l='This is illustrated on the figure below, taken from <a href="https://huggingface.co/papers/2402.01030" rel="nofollow">Executable Code Actions Elicit Better LLM Agents</a>.',Mt,et,Sl,rt,R,Nl="This is why we put emphasis on proposing code agents, in this case python agents, which meant putting higher effort on building secure python interpreters.",ut,_,ct,S,Ql="By default, the <code>CodeAgent</code> runs LLM-generated code in your environment.",yt,N,Hl="This is inherently risky, LLM-generated code could be harmful to your environment.",wt,Q,Yl="Malicious code execution can occur in several ways:",dt,H,Xl=`<li><strong>Plain LLM error:</strong> LLMs are still far from perfect and may unintentionally generate harmful commands while attempting to be helpful. While this risk is low, instances have been observed where an LLM attempted to execute potentially dangerous code.</li> <li><strong>Supply chain attack:</strong> Running an untrusted or compromised LLM could expose a system to harmful code generation. While this risk is extremely low when using well-known models on secure inference infrastructure, it remains a theoretical possibility.</li> <li><strong>Prompt injection:</strong> an agent browsing the web could arrive on a malicious website that contains harmful instructions, thus injecting an attack into the agent’s memory</li> <li><strong>Exploitation of publicly accessible agents:</strong> Agents exposed to the public can be misused by malicious actors to execute harmful code. Attackers may craft adversarial inputs to exploit the agent’s execution capabilities, leading to unintended consequences.
Once malicious code is executed, whether accidentally or intentionally, it can damage the file system, exploit local or cloud-based resources, abuse API services, and even compromise network security.</li>`,Jt,Y,ql='One could argue that on the <a href="../conceptual_guides/intro_agents">spectrum of agency</a>, code agents give much higher agency to the LLM on your system than other less agentic setups: this goes hand-in-hand with higher risk.',mt,X,zl="So you need to be very mindful of security.",Tt,q,Fl="To improve safety, we propose a range of measures that propose elevated levels of security, at a higher setup cost.",Ut,z,Ll="We advise you to keep in mind that no solution will be 100% safe.",ht,tt,Dl,bt,F,jt,L,Pl=`To add a first layer of security, code execution in <code>smolagents</code> is not performed by the vanilla Python interpreter.
We have re-built a more secure <code>LocalPythonExecutor</code> from the ground up.`,It,D,Kl="To be precise, this interpreter works by loading the Abstract Syntax Tree (AST) from your Code and executes it operation by operation, making sure to always follow certain rules:",gt,P,Ol="<li>By default, imports are disallowed unless they have been explicitly added to an authorization list by the user.</li> <li>Furthermore, access to submodules is disabled by default, and each must be explicitly authorized in the import list as well, or you can pass for instance <code>numpy.*</code> to allow both <code>numpy</code> and all its subpackags, like <code>numpy.random</code> or <code>numpy.a.b</code>.<ul><li>Note that some seemingly innocuous packages like <code>random</code> can give access to potentially harmful submodules, as in <code>random._os</code>.</li></ul></li> <li>The total count of elementary operations processed is capped to prevent infinite loops and resource bloating.</li> <li>Any operation that has not been explicitly defined in our custom interpreter will raise an error.</li>",ft,K,es="You could try these safeguards as follows:",Ct,O,xt,ee,ts=`These safeguards make out interpreter is safer.
We have used it on a diversity of use cases, without ever observing any damage to the environment.`,vt,x,Bt,te,ls=`The risk of a malicious attack is low when using well-known LLMs from trusted inference providers, but it is not zero.
For high-security applications or when using less trusted models, you should consider using a remote execution sandbox.`,Zt,le,kt,se,ss="When working with AI agents that execute code, security is paramount. There are two main approaches to sandboxing code execution in smolagents, each with different security properties and capabilities:",$t,ne,ns='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/smolagents/remote_execution.png" alt="Sandbox approaches comparison"/>',Wt,ae,as="<li><p><strong>Running individual code snippets in a sandbox</strong>: This approach (left side of diagram) only executes the agent-generated Python code snippets in a sandbox while keeping the rest of the agentic system in your local environment. It’s simpler to set up using <code>executor_type=&quot;e2b&quot;</code> or <code>executor_type=&quot;docker&quot;</code>, but it doesn’t support multi-agents and still requires passing state data between your environment and the sandbox.</p></li> <li><p><strong>Running the entire agentic system in a sandbox</strong>: This approach (right side of diagram) runs the entire agentic system, including the agent, model, and tools, within a sandbox environment. This provides better isolation but requires more manual setup and may require passing sensitive credentials (like API keys) to the sandbox environment.</p></li>",At,ie,is="This guide describes how to set up and use both types of sandbox approaches for your agent applications.",Gt,oe,Et,pe,Vt,Me,os='<li>Create an E2B account at <a href="https://e2b.dev" rel="nofollow">e2b.dev</a></li> <li>Install the required packages:</li>',Rt,re,_t,ue,St,ce,ps="We provide a simple way to use an E2B Sandbox: simply add <code>executor_type=&quot;e2b&quot;</code> to the agent initialization, as follows:",Nt,ye,Qt,v,Ht,we,Ms=`This solution send the agent state to the server at the start of each <code>agent.run()</code>.
Then the models are called from the local environment, but the generated code will be sent to the sandbox for execution, and only the output will be returned.`,Yt,de,rs="This is illustrated in the figure below.",Xt,B,us='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/smolagents/sandboxed_execution.png" alt="sandboxed code execution" width="60%" max-width="500px"/>',qt,Je,cs=`However, since any call to a <a href="../examples/multiagents">managed agent</a> would require model calls, since we do not transfer secrets to the remote sandbox, the model call would lack credentials.
Hence this solution does not work (yet) with more complicated multi-agent setups.`,zt,me,Ft,Te,ys="To use multi-agents in an E2B sandbox, you need to run your agents completely from within E2B.",Lt,Ue,ws="Here is how to do it:",Dt,he,Pt,be,Kt,je,Ot,Ie,ds='<li><a href="https://docs.docker.com/get-started/get-docker/" rel="nofollow">Install Docker on your system</a></li> <li>Install the required packages:</li>',el,ge,tl,fe,ll,Ce,Js="Similar to the E2B Sandbox above, to quickly get started with Docker, simply add <code>executor_type=&quot;docker&quot;</code> to the agent initialization, like:",sl,xe,nl,Z,al,ve,il,Be,ms="If you want to run multi-agent systems in Docker, you’ll need to setup a custom interpreter in a sandbox.",ol,Ze,Ts="Here is how to setup the a Dockerfile:",pl,ke,Ml,$e,Us="Create a sandbox manager to run code:",rl,We,ul,Ae,cl,Ge,hs=`WebAssembly (Wasm) is a binary instruction format that allows code to be run in a safe, sandboxed environment.
It is designed to be fast, efficient, and secure, making it an excellent choice for executing potentially untrusted code.`,yl,Ee,bs='The <code>WasmExecutor</code> uses <a href="https://pyodide.org/" rel="nofollow">Pyodide</a> and <a href="https://docs.deno.com/" rel="nofollow">Deno</a>.',wl,Ve,dl,Re,js='<li><a href="https://docs.deno.com/runtime/getting_started/installation/" rel="nofollow">Install Deno on your system</a></li>',Jl,_e,ml,Se,Is="Simply pass <code>executor_type=&quot;wasm&quot;</code> to the agent initialization, like:",Tl,Ne,Ul,Qe,hl,He,gs="These key practices apply to both E2B and Docker sandboxes:",bl,Ye,fs="<li><p>Resource management</p> <ul><li>Set memory and CPU limits</li> <li>Implement execution timeouts</li> <li>Monitor resource usage</li></ul></li> <li><p>Security</p> <ul><li>Run with minimal privileges</li> <li>Disable unnecessary network access</li> <li>Use environment variables for secrets</li></ul></li> <li><p>Environment</p> <ul><li>Keep dependencies minimal</li> <li>Use fixed package versions</li> <li>If you use base images, update them regularly</li></ul></li> <li><p>Cleanup</p> <ul><li>Always ensure proper cleanup of resources, especially for Docker containers, to avoid having dangling containers eating up resources.</li></ul></li>",jl,Xe,Cs="✨ By following these practices and implementing proper cleanup procedures, you can ensure your agent runs safely and efficiently in a sandboxed environment.",Il,qe,gl,ze,xs="As illustrated in the diagram earlier, both sandboxing approaches have different security implications:",fl,Fe,Cl,Le,vs="<li><strong>Pros</strong>: <ul><li>Easier to set up with a simple parameter (<code>executor_type=&quot;e2b&quot;</code> or <code>executor_type=&quot;docker&quot;</code>)</li> <li>No need to transfer API keys to the sandbox</li> <li>Better protection for your local environment</li></ul></li> <li><strong>Cons</strong>:<ul><li>Doesn’t support multi-agents (managed agents)</li> <li>Still requires transferring state between your environment and the sandbox</li> <li>Limited to specific code execution</li></ul></li>",xl,De,vl,Pe,Bs="<li><strong>Pros</strong>:<ul><li>Supports multi-agents</li> <li>Complete isolation of the entire agent system</li> <li>More flexible for complex agent architectures</li></ul></li> <li><strong>Cons</strong>:<ul><li>Requires more manual setup</li> <li>May require transferring sensitive API keys to the sandbox</li> <li>Potentially higher latency due to more complex operations</li></ul></li>",Bl,Ke,Zs="Choose the approach that best balances your security needs with your application’s requirements. For most applications with simpler agent architectures, Approach 1 provides a good balance of security and ease of use. For more complex multi-agent systems where you need full isolation, Approach 2, while more involved to set up, offers better security guarantees.",Zl,Oe,kl,lt,$l;return I=new T({props:{title:"Secure code execution",local:"secure-code-execution",headingTag:"h1"}}),b=new Hs({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/secure_code_execution.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/pytorch/secure_code_execution.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/tensorflow/secure_code_execution.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/secure_code_execution.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/pytorch/secure_code_execution.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/tensorflow/secure_code_execution.ipynb"}]}}),m=new Wl({props:{warning:!1,$$slots:{default:[Xs]},$$scope:{ctx:j}}}),$=new T({props:{title:"Code agents",local:"code-agents",headingTag:"h3"}}),_=new T({props:{title:"Local code execution??",local:"local-code-execution",headingTag:"h3"}}),F=new T({props:{title:"Our local Python executor",local:"our-local-python-executor",headingTag:"h3"}}),O=new C({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> smolagents.local_python_executor <span class="hljs-keyword">import</span> LocalPythonExecutor

<span class="hljs-comment"># Set up custom executor, authorize package &quot;numpy&quot;</span>
custom_executor = LocalPythonExecutor([<span class="hljs-string">&quot;numpy&quot;</span>])

<span class="hljs-comment"># Utilisty for pretty printing errors</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">run_capture_exception</span>(<span class="hljs-params">command: <span class="hljs-built_in">str</span></span>):
    <span class="hljs-keyword">try</span>:
        custom_executor(harmful_command)
    <span class="hljs-keyword">except</span> Exception <span class="hljs-keyword">as</span> e:
        <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;ERROR:\\n&quot;</span>, e)

<span class="hljs-comment"># Undefined command just do not work</span>
harmful_command=<span class="hljs-string">&quot;!echo Bad command&quot;</span>
run_capture_exception(harmful_command)
<span class="hljs-comment"># &gt;&gt;&gt; ERROR: invalid syntax (&lt;unknown&gt;, line 1)</span>


<span class="hljs-comment"># Imports like os will not be performed unless explicitly added to \`additional_authorized_imports\`</span>
harmful_command=<span class="hljs-string">&quot;import os; exit_code = os.system(&quot;</span>echo Bad command<span class="hljs-string">&quot;)&quot;</span>
run_capture_exception(harmful_command)
<span class="hljs-comment"># &gt;&gt;&gt; ERROR: Code execution failed at line &#x27;import os&#x27; due to: InterpreterError: Import of os is not allowed. Authorized imports are: [&#x27;statistics&#x27;, &#x27;numpy&#x27;, &#x27;itertools&#x27;, &#x27;time&#x27;, &#x27;queue&#x27;, &#x27;collections&#x27;, &#x27;math&#x27;, &#x27;random&#x27;, &#x27;re&#x27;, &#x27;datetime&#x27;, &#x27;stat&#x27;, &#x27;unicodedata&#x27;]</span>

<span class="hljs-comment"># Even in authorized imports, potentially harmful packages will not be imported</span>
harmful_command=<span class="hljs-string">&quot;import random; random._os.system(&#x27;echo Bad command&#x27;)&quot;</span>
run_capture_exception(harmful_command)
<span class="hljs-comment"># &gt;&gt;&gt; ERROR: Code execution failed at line &#x27;random._os.system(&#x27;echo Bad command&#x27;)&#x27; due to: InterpreterError: Forbidden access to module: os</span>

<span class="hljs-comment"># Infinite loop are interrupted after N operations</span>
harmful_command=<span class="hljs-string">&quot;&quot;&quot;
while True:
    pass
&quot;&quot;&quot;</span>
run_capture_exception(harmful_command)
<span class="hljs-comment"># &gt;&gt;&gt; ERROR: Code execution failed at line &#x27;while True: pass&#x27; due to: InterpreterError: Maximum number of 1000000 iterations in While loop exceeded</span>`,wrap:!1}}),x=new Wl({props:{warning:!0,$$slots:{default:[qs]},$$scope:{ctx:j}}}),le=new T({props:{title:"Sandbox approaches for secure code execution",local:"sandbox-approaches-for-secure-code-execution",headingTag:"h2"}}),oe=new T({props:{title:"E2B setup",local:"e2b-setup",headingTag:"h3"}}),pe=new T({props:{title:"Installation",local:"installation",headingTag:"h4"}}),re=new C({props:{code:"cGlwJTIwaW5zdGFsbCUyMCdzbW9sYWdlbnRzJTVCZTJiJTVEJw==",highlighted:'pip install <span class="hljs-string">&#x27;smolagents[e2b]&#x27;</span>',wrap:!1}}),ue=new T({props:{title:"Running your agent in E2B: quick start",local:"running-your-agent-in-e2b-quick-start",headingTag:"h4"}}),ye=new C({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCUyQyUyMENvZGVBZ2VudCUwQSUwQXdpdGglMjBDb2RlQWdlbnQobW9kZWwlM0RJbmZlcmVuY2VDbGllbnRNb2RlbCgpJTJDJTIwdG9vbHMlM0QlNUIlNUQlMkMlMjBleGVjdXRvcl90eXBlJTNEJTIyZTJiJTIyKSUyMGFzJTIwYWdlbnQlM0ElMEElMjAlMjAlMjAlMjBhZ2VudC5ydW4oJTIyQ2FuJTIweW91JTIwZ2l2ZSUyMG1lJTIwdGhlJTIwMTAwdGglMjBGaWJvbmFjY2klMjBudW1iZXIlM0YlMjIp",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> InferenceClientModel, CodeAgent

<span class="hljs-keyword">with</span> CodeAgent(model=InferenceClientModel(), tools=[], executor_type=<span class="hljs-string">&quot;e2b&quot;</span>) <span class="hljs-keyword">as</span> agent:
    agent.run(<span class="hljs-string">&quot;Can you give me the 100th Fibonacci number?&quot;</span>)`,wrap:!1}}),v=new Wl({props:{warning:!1,$$slots:{default:[zs]},$$scope:{ctx:j}}}),me=new T({props:{title:"Running your agent in E2B: multi-agents",local:"running-your-agent-in-e2b-multi-agents",headingTag:"h4"}}),he=new C({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> e2b_code_interpreter <span class="hljs-keyword">import</span> Sandbox
<span class="hljs-keyword">import</span> os

<span class="hljs-comment"># Create the sandbox</span>
sandbox = Sandbox()

<span class="hljs-comment"># Install required packages</span>
sandbox.commands.run(<span class="hljs-string">&quot;pip install smolagents&quot;</span>)

<span class="hljs-keyword">def</span> <span class="hljs-title function_">run_code_raise_errors</span>(<span class="hljs-params">sandbox, code: <span class="hljs-built_in">str</span>, verbose: <span class="hljs-built_in">bool</span> = <span class="hljs-literal">False</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    execution = sandbox.run_code(
        code,
        envs={<span class="hljs-string">&#x27;HF_TOKEN&#x27;</span>: os.getenv(<span class="hljs-string">&#x27;HF_TOKEN&#x27;</span>)}
    )
    <span class="hljs-keyword">if</span> execution.error:
        execution_logs = <span class="hljs-string">&quot;\\n&quot;</span>.join([<span class="hljs-built_in">str</span>(log) <span class="hljs-keyword">for</span> log <span class="hljs-keyword">in</span> execution.logs.stdout])
        logs = execution_logs
        logs += execution.error.traceback
        <span class="hljs-keyword">raise</span> ValueError(logs)
    <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;\\n&quot;</span>.join([<span class="hljs-built_in">str</span>(log) <span class="hljs-keyword">for</span> log <span class="hljs-keyword">in</span> execution.logs.stdout])

<span class="hljs-comment"># Define your agent application</span>
agent_code = <span class="hljs-string">&quot;&quot;&quot;
import os
from smolagents import CodeAgent, InferenceClientModel

# Initialize the agents
agent = CodeAgent(
    model=InferenceClientModel(token=os.getenv(&quot;HF_TOKEN&quot;), provider=&quot;together&quot;),
    tools=[],
    name=&quot;coder_agent&quot;,
    description=&quot;This agent takes care of your difficult algorithmic problems using code.&quot;
)

manager_agent = CodeAgent(
    model=InferenceClientModel(token=os.getenv(&quot;HF_TOKEN&quot;), provider=&quot;together&quot;),
    tools=[],
    managed_agents=[agent],
)

# Run the agent
response = manager_agent.run(&quot;What&#x27;s the 20th Fibonacci number?&quot;)
print(response)
&quot;&quot;&quot;</span>

<span class="hljs-comment"># Run the agent code in the sandbox</span>
execution_logs = run_code_raise_errors(sandbox, agent_code)
<span class="hljs-built_in">print</span>(execution_logs)`,wrap:!1}}),be=new T({props:{title:"Docker setup",local:"docker-setup",headingTag:"h3"}}),je=new T({props:{title:"Installation",local:"installation",headingTag:"h4"}}),ge=new C({props:{code:"cGlwJTIwaW5zdGFsbCUyMCdzbW9sYWdlbnRzJTVCZG9ja2VyJTVEJw==",highlighted:'pip install <span class="hljs-string">&#x27;smolagents[docker]&#x27;</span>',wrap:!1}}),fe=new T({props:{title:"Running your agent in Docker: quick start",local:"running-your-agent-in-docker-quick-start",headingTag:"h4"}}),xe=new C({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCUyQyUyMENvZGVBZ2VudCUwQSUwQXdpdGglMjBDb2RlQWdlbnQobW9kZWwlM0RJbmZlcmVuY2VDbGllbnRNb2RlbCgpJTJDJTIwdG9vbHMlM0QlNUIlNUQlMkMlMjBleGVjdXRvcl90eXBlJTNEJTIyZG9ja2VyJTIyKSUyMGFzJTIwYWdlbnQlM0ElMEElMjAlMjAlMjAlMjBhZ2VudC5ydW4oJTIyQ2FuJTIweW91JTIwZ2l2ZSUyMG1lJTIwdGhlJTIwMTAwdGglMjBGaWJvbmFjY2klMjBudW1iZXIlM0YlMjIp",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> InferenceClientModel, CodeAgent

<span class="hljs-keyword">with</span> CodeAgent(model=InferenceClientModel(), tools=[], executor_type=<span class="hljs-string">&quot;docker&quot;</span>) <span class="hljs-keyword">as</span> agent:
    agent.run(<span class="hljs-string">&quot;Can you give me the 100th Fibonacci number?&quot;</span>)`,wrap:!1}}),Z=new Wl({props:{warning:!1,$$slots:{default:[Fs]},$$scope:{ctx:j}}}),ve=new T({props:{title:"Advanced docker usage",local:"advanced-docker-usage",headingTag:"h4"}}),ke=new C({props:{code:"RlJPTSUyMHB5dGhvbiUzQTMuMTAtYnVsbHNleWUlMEElMEElMjMlMjBJbnN0YWxsJTIwYnVpbGQlMjBkZXBlbmRlbmNpZXMlMEFSVU4lMjBhcHQtZ2V0JTIwdXBkYXRlJTIwJTI2JTI2JTIwJTVDJTBBJTIwJTIwJTIwJTIwYXB0LWdldCUyMGluc3RhbGwlMjAteSUyMC0tbm8taW5zdGFsbC1yZWNvbW1lbmRzJTIwJTVDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYnVpbGQtZXNzZW50aWFsJTIwJTVDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHl0aG9uMy1kZXYlMjAlMjYlMjYlMjAlNUMlMEElMjAlMjAlMjAlMjBwaXAlMjBpbnN0YWxsJTIwLS1uby1jYWNoZS1kaXIlMjAtLXVwZ3JhZGUlMjBwaXAlMjAlMjYlMjYlMjAlNUMlMEElMjAlMjAlMjAlMjBwaXAlMjBpbnN0YWxsJTIwLS1uby1jYWNoZS1kaXIlMjBzbW9sYWdlbnRzJTIwJTI2JTI2JTIwJTVDJTBBJTIwJTIwJTIwJTIwYXB0LWdldCUyMGNsZWFuJTIwJTI2JTI2JTIwJTVDJTBBJTIwJTIwJTIwJTIwcm0lMjAtcmYlMjAlMkZ2YXIlMkZsaWIlMkZhcHQlMkZsaXN0cyUyRiolMEElMEElMjMlMjBTZXQlMjB3b3JraW5nJTIwZGlyZWN0b3J5JTBBV09SS0RJUiUyMCUyRmFwcCUwQSUwQSUyMyUyMFJ1biUyMHdpdGglMjBsaW1pdGVkJTIwcHJpdmlsZWdlcyUwQVVTRVIlMjBub2JvZHklMEElMEElMjMlMjBEZWZhdWx0JTIwY29tbWFuZCUwQUNNRCUyMCU1QiUyMnB5dGhvbiUyMiUyQyUyMCUyMi1jJTIyJTJDJTIwJTIycHJpbnQoJ0NvbnRhaW5lciUyMHJlYWR5JyklMjIlNUQ=",highlighted:`<span class="hljs-keyword">FROM</span> python:<span class="hljs-number">3.10</span>-bullseye

<span class="hljs-comment"># Install build dependencies</span>
<span class="hljs-keyword">RUN</span><span class="language-bash"> apt-get update &amp;&amp; \\
    apt-get install -y --no-install-recommends \\
        build-essential \\
        python3-dev &amp;&amp; \\
    pip install --no-cache-dir --upgrade pip &amp;&amp; \\
    pip install --no-cache-dir smolagents &amp;&amp; \\
    apt-get clean &amp;&amp; \\
    <span class="hljs-built_in">rm</span> -rf /var/lib/apt/lists/*</span>

<span class="hljs-comment"># Set working directory</span>
<span class="hljs-keyword">WORKDIR</span><span class="language-bash"> /app</span>

<span class="hljs-comment"># Run with limited privileges</span>
<span class="hljs-keyword">USER</span> nobody

<span class="hljs-comment"># Default command</span>
<span class="hljs-keyword">CMD</span><span class="language-bash"> [<span class="hljs-string">&quot;python&quot;</span>, <span class="hljs-string">&quot;-c&quot;</span>, <span class="hljs-string">&quot;print(&#x27;Container ready&#x27;)&quot;</span>]</span>`,wrap:!1}}),We=new C({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> docker
<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">Optional</span>

<span class="hljs-keyword">class</span> <span class="hljs-title class_">DockerSandbox</span>:
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self</span>):
        self.client = docker.from_env()
        self.container = <span class="hljs-literal">None</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">create_container</span>(<span class="hljs-params">self</span>):
        <span class="hljs-keyword">try</span>:
            image, build_logs = self.client.images.build(
                path=<span class="hljs-string">&quot;.&quot;</span>,
                tag=<span class="hljs-string">&quot;agent-sandbox&quot;</span>,
                rm=<span class="hljs-literal">True</span>,
                forcerm=<span class="hljs-literal">True</span>,
                buildargs={},
                <span class="hljs-comment"># decode=True</span>
            )
        <span class="hljs-keyword">except</span> docker.errors.BuildError <span class="hljs-keyword">as</span> e:
            <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Build error logs:&quot;</span>)
            <span class="hljs-keyword">for</span> log <span class="hljs-keyword">in</span> e.build_log:
                <span class="hljs-keyword">if</span> <span class="hljs-string">&#x27;stream&#x27;</span> <span class="hljs-keyword">in</span> log:
                    <span class="hljs-built_in">print</span>(log[<span class="hljs-string">&#x27;stream&#x27;</span>].strip())
            <span class="hljs-keyword">raise</span>

        <span class="hljs-comment"># Create container with security constraints and proper logging</span>
        self.container = self.client.containers.run(
            <span class="hljs-string">&quot;agent-sandbox&quot;</span>,
            command=<span class="hljs-string">&quot;tail -f /dev/null&quot;</span>,  <span class="hljs-comment"># Keep container running</span>
            detach=<span class="hljs-literal">True</span>,
            tty=<span class="hljs-literal">True</span>,
            mem_limit=<span class="hljs-string">&quot;512m&quot;</span>,
            cpu_quota=<span class="hljs-number">50000</span>,
            pids_limit=<span class="hljs-number">100</span>,
            security_opt=[<span class="hljs-string">&quot;no-new-privileges&quot;</span>],
            cap_drop=[<span class="hljs-string">&quot;ALL&quot;</span>],
            environment={
                <span class="hljs-string">&quot;HF_TOKEN&quot;</span>: os.getenv(<span class="hljs-string">&quot;HF_TOKEN&quot;</span>)
            },
        )

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">run_code</span>(<span class="hljs-params">self, code: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-type">Optional</span>[<span class="hljs-built_in">str</span>]:
        <span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> self.container:
            self.create_container()

        <span class="hljs-comment"># Execute code in container</span>
        exec_result = self.container.exec_run(
            cmd=[<span class="hljs-string">&quot;python&quot;</span>, <span class="hljs-string">&quot;-c&quot;</span>, code],
            user=<span class="hljs-string">&quot;nobody&quot;</span>
        )

        <span class="hljs-comment"># Collect all output</span>
        <span class="hljs-keyword">return</span> exec_result.output.decode() <span class="hljs-keyword">if</span> exec_result.output <span class="hljs-keyword">else</span> <span class="hljs-literal">None</span>


    <span class="hljs-keyword">def</span> <span class="hljs-title function_">cleanup</span>(<span class="hljs-params">self</span>):
        <span class="hljs-keyword">if</span> self.container:
            <span class="hljs-keyword">try</span>:
                self.container.stop()
            <span class="hljs-keyword">except</span> docker.errors.NotFound:
                <span class="hljs-comment"># Container already removed, this is expected</span>
                <span class="hljs-keyword">pass</span>
            <span class="hljs-keyword">except</span> Exception <span class="hljs-keyword">as</span> e:
                <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Error during cleanup: <span class="hljs-subst">{e}</span>&quot;</span>)
            <span class="hljs-keyword">finally</span>:
                self.container = <span class="hljs-literal">None</span>  <span class="hljs-comment"># Clear the reference</span>

<span class="hljs-comment"># Example usage:</span>
sandbox = DockerSandbox()

<span class="hljs-keyword">try</span>:
    <span class="hljs-comment"># Define your agent code</span>
    agent_code = <span class="hljs-string">&quot;&quot;&quot;
import os
from smolagents import CodeAgent, InferenceClientModel

# Initialize the agent
agent = CodeAgent(
    model=InferenceClientModel(token=os.getenv(&quot;HF_TOKEN&quot;), provider=&quot;together&quot;),
    tools=[]
)

# Run the agent
response = agent.run(&quot;What&#x27;s the 20th Fibonacci number?&quot;)
print(response)
&quot;&quot;&quot;</span>

    <span class="hljs-comment"># Run the code in the sandbox</span>
    output = sandbox.run_code(agent_code)
    <span class="hljs-built_in">print</span>(output)

<span class="hljs-keyword">finally</span>:
    sandbox.cleanup()`,wrap:!1}}),Ae=new T({props:{title:"WebAssembly setup",local:"webassembly-setup",headingTag:"h3"}}),Ve=new T({props:{title:"Installation",local:"installation",headingTag:"h4"}}),_e=new T({props:{title:"Running your agent in WebAssembly: quick start",local:"running-your-agent-in-webassembly-quick-start",headingTag:"h4"}}),Ne=new C({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCUyQyUyMENvZGVBZ2VudCUwQSUwQWFnZW50JTIwJTNEJTIwQ29kZUFnZW50KG1vZGVsJTNESW5mZXJlbmNlQ2xpZW50TW9kZWwoKSUyQyUyMHRvb2xzJTNEJTVCJTVEJTJDJTIwZXhlY3V0b3JfdHlwZSUzRCUyMndhc20lMjIpJTBBJTBBYWdlbnQucnVuKCUyMkNhbiUyMHlvdSUyMGdpdmUlMjBtZSUyMHRoZSUyMDEwMHRoJTIwRmlib25hY2NpJTIwbnVtYmVyJTNGJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> InferenceClientModel, CodeAgent

agent = CodeAgent(model=InferenceClientModel(), tools=[], executor_type=<span class="hljs-string">&quot;wasm&quot;</span>)

agent.run(<span class="hljs-string">&quot;Can you give me the 100th Fibonacci number?&quot;</span>)`,wrap:!1}}),Qe=new T({props:{title:"Best practices for sandboxes",local:"best-practices-for-sandboxes",headingTag:"h3"}}),qe=new T({props:{title:"Comparing security approaches",local:"comparing-security-approaches",headingTag:"h2"}}),Fe=new T({props:{title:"Approach 1: Running just the code snippets in a sandbox",local:"approach-1-running-just-the-code-snippets-in-a-sandbox",headingTag:"h3"}}),De=new T({props:{title:"Approach 2: Running the entire agentic system in a sandbox",local:"approach-2-running-the-entire-agentic-system-in-a-sandbox",headingTag:"h3"}}),Oe=new Ys({props:{source:"https://github.com/huggingface/smolagents/blob/main/docs/source/en/tutorials/secure_code_execution.md"}}),{c(){M=i("meta"),h=n(),J=i("p"),U=n(),r(I.$$.fragment),f=n(),r(b.$$.fragment),k=n(),r(m.$$.fragment),g=n(),r($.$$.fragment),nt=n(),W=i("p"),W.innerHTML=Gl,at=n(),A=i("p"),A.textContent=El,it=n(),G=i("p"),G.textContent=Vl,ot=n(),E=i("ul"),E.innerHTML=Rl,pt=n(),V=i("p"),V.innerHTML=_l,Mt=n(),et=i("img"),rt=n(),R=i("p"),R.textContent=Nl,ut=n(),r(_.$$.fragment),ct=n(),S=i("p"),S.innerHTML=Ql,yt=n(),N=i("p"),N.textContent=Hl,wt=n(),Q=i("p"),Q.textContent=Yl,dt=n(),H=i("ul"),H.innerHTML=Xl,Jt=n(),Y=i("p"),Y.innerHTML=ql,mt=n(),X=i("p"),X.textContent=zl,Tt=n(),q=i("p"),q.textContent=Fl,Ut=n(),z=i("p"),z.textContent=Ll,ht=n(),tt=i("img"),bt=n(),r(F.$$.fragment),jt=n(),L=i("p"),L.innerHTML=Pl,It=n(),D=i("p"),D.textContent=Kl,gt=n(),P=i("ul"),P.innerHTML=Ol,ft=n(),K=i("p"),K.textContent=es,Ct=n(),r(O.$$.fragment),xt=n(),ee=i("p"),ee.textContent=ts,vt=n(),r(x.$$.fragment),Bt=n(),te=i("p"),te.textContent=ls,Zt=n(),r(le.$$.fragment),kt=n(),se=i("p"),se.textContent=ss,$t=n(),ne=i("p"),ne.innerHTML=ns,Wt=n(),ae=i("ol"),ae.innerHTML=as,At=n(),ie=i("p"),ie.textContent=is,Gt=n(),r(oe.$$.fragment),Et=n(),r(pe.$$.fragment),Vt=n(),Me=i("ol"),Me.innerHTML=os,Rt=n(),r(re.$$.fragment),_t=n(),r(ue.$$.fragment),St=n(),ce=i("p"),ce.innerHTML=ps,Nt=n(),r(ye.$$.fragment),Qt=n(),r(v.$$.fragment),Ht=n(),we=i("p"),we.innerHTML=Ms,Yt=n(),de=i("p"),de.textContent=rs,Xt=n(),B=i("p"),B.innerHTML=us,qt=n(),Je=i("p"),Je.innerHTML=cs,zt=n(),r(me.$$.fragment),Ft=n(),Te=i("p"),Te.textContent=ys,Lt=n(),Ue=i("p"),Ue.textContent=ws,Dt=n(),r(he.$$.fragment),Pt=n(),r(be.$$.fragment),Kt=n(),r(je.$$.fragment),Ot=n(),Ie=i("ol"),Ie.innerHTML=ds,el=n(),r(ge.$$.fragment),tl=n(),r(fe.$$.fragment),ll=n(),Ce=i("p"),Ce.innerHTML=Js,sl=n(),r(xe.$$.fragment),nl=n(),r(Z.$$.fragment),al=n(),r(ve.$$.fragment),il=n(),Be=i("p"),Be.textContent=ms,ol=n(),Ze=i("p"),Ze.textContent=Ts,pl=n(),r(ke.$$.fragment),Ml=n(),$e=i("p"),$e.textContent=Us,rl=n(),r(We.$$.fragment),ul=n(),r(Ae.$$.fragment),cl=n(),Ge=i("p"),Ge.textContent=hs,yl=n(),Ee=i("p"),Ee.innerHTML=bs,wl=n(),r(Ve.$$.fragment),dl=n(),Re=i("ol"),Re.innerHTML=js,Jl=n(),r(_e.$$.fragment),ml=n(),Se=i("p"),Se.innerHTML=Is,Tl=n(),r(Ne.$$.fragment),Ul=n(),r(Qe.$$.fragment),hl=n(),He=i("p"),He.textContent=gs,bl=n(),Ye=i("ul"),Ye.innerHTML=fs,jl=n(),Xe=i("p"),Xe.textContent=Cs,Il=n(),r(qe.$$.fragment),gl=n(),ze=i("p"),ze.textContent=xs,fl=n(),r(Fe.$$.fragment),Cl=n(),Le=i("ul"),Le.innerHTML=vs,xl=n(),r(De.$$.fragment),vl=n(),Pe=i("ul"),Pe.innerHTML=Bs,Bl=n(),Ke=i("p"),Ke.textContent=Zs,Zl=n(),r(Oe.$$.fragment),kl=n(),lt=i("p"),this.h()},l(e){const t=Ns("svelte-u9bgzb",document.head);M=o(t,"META",{name:!0,content:!0}),t.forEach(l),h=a(e),J=o(e,"P",{}),Es(J).forEach(l),U=a(e),u(I.$$.fragment,e),f=a(e),u(b.$$.fragment,e),k=a(e),u(m.$$.fragment,e),g=a(e),u($.$$.fragment,e),nt=a(e),W=o(e,"P",{"data-svelte-h":!0}),p(W)!=="svelte-1nor5c0"&&(W.innerHTML=Gl),at=a(e),A=o(e,"P",{"data-svelte-h":!0}),p(A)!=="svelte-1b2f48c"&&(A.textContent=El),it=a(e),G=o(e,"P",{"data-svelte-h":!0}),p(G)!=="svelte-1jp5kiv"&&(G.textContent=Vl),ot=a(e),E=o(e,"UL",{"data-svelte-h":!0}),p(E)!=="svelte-a7ou7n"&&(E.innerHTML=Rl),pt=a(e),V=o(e,"P",{"data-svelte-h":!0}),p(V)!=="svelte-1ugtxvn"&&(V.innerHTML=_l),Mt=a(e),et=o(e,"IMG",{src:!0}),rt=a(e),R=o(e,"P",{"data-svelte-h":!0}),p(R)!=="svelte-1lbgv3o"&&(R.textContent=Nl),ut=a(e),u(_.$$.fragment,e),ct=a(e),S=o(e,"P",{"data-svelte-h":!0}),p(S)!=="svelte-19p3p3d"&&(S.innerHTML=Ql),yt=a(e),N=o(e,"P",{"data-svelte-h":!0}),p(N)!=="svelte-y55i8i"&&(N.textContent=Hl),wt=a(e),Q=o(e,"P",{"data-svelte-h":!0}),p(Q)!=="svelte-y4kupg"&&(Q.textContent=Yl),dt=a(e),H=o(e,"UL",{"data-svelte-h":!0}),p(H)!=="svelte-1b6z7ic"&&(H.innerHTML=Xl),Jt=a(e),Y=o(e,"P",{"data-svelte-h":!0}),p(Y)!=="svelte-uopq3c"&&(Y.innerHTML=ql),mt=a(e),X=o(e,"P",{"data-svelte-h":!0}),p(X)!=="svelte-gfolx1"&&(X.textContent=zl),Tt=a(e),q=o(e,"P",{"data-svelte-h":!0}),p(q)!=="svelte-1j1i1cv"&&(q.textContent=Fl),Ut=a(e),z=o(e,"P",{"data-svelte-h":!0}),p(z)!=="svelte-1ghwkh9"&&(z.textContent=Ll),ht=a(e),tt=o(e,"IMG",{src:!0}),bt=a(e),u(F.$$.fragment,e),jt=a(e),L=o(e,"P",{"data-svelte-h":!0}),p(L)!=="svelte-845rka"&&(L.innerHTML=Pl),It=a(e),D=o(e,"P",{"data-svelte-h":!0}),p(D)!=="svelte-180snho"&&(D.textContent=Kl),gt=a(e),P=o(e,"UL",{"data-svelte-h":!0}),p(P)!=="svelte-19qb8ke"&&(P.innerHTML=Ol),ft=a(e),K=o(e,"P",{"data-svelte-h":!0}),p(K)!=="svelte-1wz8jbt"&&(K.textContent=es),Ct=a(e),u(O.$$.fragment,e),xt=a(e),ee=o(e,"P",{"data-svelte-h":!0}),p(ee)!=="svelte-1gk7uki"&&(ee.textContent=ts),vt=a(e),u(x.$$.fragment,e),Bt=a(e),te=o(e,"P",{"data-svelte-h":!0}),p(te)!=="svelte-whkli4"&&(te.textContent=ls),Zt=a(e),u(le.$$.fragment,e),kt=a(e),se=o(e,"P",{"data-svelte-h":!0}),p(se)!=="svelte-grnb59"&&(se.textContent=ss),$t=a(e),ne=o(e,"P",{"data-svelte-h":!0}),p(ne)!=="svelte-ahtq0i"&&(ne.innerHTML=ns),Wt=a(e),ae=o(e,"OL",{"data-svelte-h":!0}),p(ae)!=="svelte-1vlvy45"&&(ae.innerHTML=as),At=a(e),ie=o(e,"P",{"data-svelte-h":!0}),p(ie)!=="svelte-1h3g1zs"&&(ie.textContent=is),Gt=a(e),u(oe.$$.fragment,e),Et=a(e),u(pe.$$.fragment,e),Vt=a(e),Me=o(e,"OL",{"data-svelte-h":!0}),p(Me)!=="svelte-uvtwg2"&&(Me.innerHTML=os),Rt=a(e),u(re.$$.fragment,e),_t=a(e),u(ue.$$.fragment,e),St=a(e),ce=o(e,"P",{"data-svelte-h":!0}),p(ce)!=="svelte-r3242t"&&(ce.innerHTML=ps),Nt=a(e),u(ye.$$.fragment,e),Qt=a(e),u(v.$$.fragment,e),Ht=a(e),we=o(e,"P",{"data-svelte-h":!0}),p(we)!=="svelte-jrgx8f"&&(we.innerHTML=Ms),Yt=a(e),de=o(e,"P",{"data-svelte-h":!0}),p(de)!=="svelte-8sir7q"&&(de.textContent=rs),Xt=a(e),B=o(e,"P",{align:!0,"data-svelte-h":!0}),p(B)!=="svelte-11rtdvt"&&(B.innerHTML=us),qt=a(e),Je=o(e,"P",{"data-svelte-h":!0}),p(Je)!=="svelte-ofpo9r"&&(Je.innerHTML=cs),zt=a(e),u(me.$$.fragment,e),Ft=a(e),Te=o(e,"P",{"data-svelte-h":!0}),p(Te)!=="svelte-geglm0"&&(Te.textContent=ys),Lt=a(e),Ue=o(e,"P",{"data-svelte-h":!0}),p(Ue)!=="svelte-1iycphr"&&(Ue.textContent=ws),Dt=a(e),u(he.$$.fragment,e),Pt=a(e),u(be.$$.fragment,e),Kt=a(e),u(je.$$.fragment,e),Ot=a(e),Ie=o(e,"OL",{"data-svelte-h":!0}),p(Ie)!=="svelte-19h0avy"&&(Ie.innerHTML=ds),el=a(e),u(ge.$$.fragment,e),tl=a(e),u(fe.$$.fragment,e),ll=a(e),Ce=o(e,"P",{"data-svelte-h":!0}),p(Ce)!=="svelte-1j9zoi1"&&(Ce.innerHTML=Js),sl=a(e),u(xe.$$.fragment,e),nl=a(e),u(Z.$$.fragment,e),al=a(e),u(ve.$$.fragment,e),il=a(e),Be=o(e,"P",{"data-svelte-h":!0}),p(Be)!=="svelte-t1it0d"&&(Be.textContent=ms),ol=a(e),Ze=o(e,"P",{"data-svelte-h":!0}),p(Ze)!=="svelte-1lygj8"&&(Ze.textContent=Ts),pl=a(e),u(ke.$$.fragment,e),Ml=a(e),$e=o(e,"P",{"data-svelte-h":!0}),p($e)!=="svelte-8mtm8c"&&($e.textContent=Us),rl=a(e),u(We.$$.fragment,e),ul=a(e),u(Ae.$$.fragment,e),cl=a(e),Ge=o(e,"P",{"data-svelte-h":!0}),p(Ge)!=="svelte-ozg6k5"&&(Ge.textContent=hs),yl=a(e),Ee=o(e,"P",{"data-svelte-h":!0}),p(Ee)!=="svelte-1f0518g"&&(Ee.innerHTML=bs),wl=a(e),u(Ve.$$.fragment,e),dl=a(e),Re=o(e,"OL",{"data-svelte-h":!0}),p(Re)!=="svelte-18eum27"&&(Re.innerHTML=js),Jl=a(e),u(_e.$$.fragment,e),ml=a(e),Se=o(e,"P",{"data-svelte-h":!0}),p(Se)!=="svelte-zmyq9d"&&(Se.innerHTML=Is),Tl=a(e),u(Ne.$$.fragment,e),Ul=a(e),u(Qe.$$.fragment,e),hl=a(e),He=o(e,"P",{"data-svelte-h":!0}),p(He)!=="svelte-5fyo5r"&&(He.textContent=gs),bl=a(e),Ye=o(e,"UL",{"data-svelte-h":!0}),p(Ye)!=="svelte-162p62u"&&(Ye.innerHTML=fs),jl=a(e),Xe=o(e,"P",{"data-svelte-h":!0}),p(Xe)!=="svelte-1hbg2e4"&&(Xe.textContent=Cs),Il=a(e),u(qe.$$.fragment,e),gl=a(e),ze=o(e,"P",{"data-svelte-h":!0}),p(ze)!=="svelte-i4top7"&&(ze.textContent=xs),fl=a(e),u(Fe.$$.fragment,e),Cl=a(e),Le=o(e,"UL",{"data-svelte-h":!0}),p(Le)!=="svelte-8oe7h4"&&(Le.innerHTML=vs),xl=a(e),u(De.$$.fragment,e),vl=a(e),Pe=o(e,"UL",{"data-svelte-h":!0}),p(Pe)!=="svelte-1nt0hab"&&(Pe.innerHTML=Bs),Bl=a(e),Ke=o(e,"P",{"data-svelte-h":!0}),p(Ke)!=="svelte-l1ns7z"&&(Ke.textContent=Zs),Zl=a(e),u(Oe.$$.fragment,e),kl=a(e),lt=o(e,"P",{}),Es(lt).forEach(l),this.h()},h(){st(M,"name","hf:doc:metadata"),st(M,"content",Ds),Gs(et.src,Sl="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/code_vs_json_actions.png")||st(et,"src",Sl),Gs(tt.src,Dl="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/smolagents/code_execution_safety_diagram.png")||st(tt,"src",Dl),st(B,"align","center")},m(e,t){Qs(document.head,M),s(e,h,t),s(e,J,t),s(e,U,t),c(I,e,t),s(e,f,t),c(b,e,t),s(e,k,t),c(m,e,t),s(e,g,t),c($,e,t),s(e,nt,t),s(e,W,t),s(e,at,t),s(e,A,t),s(e,it,t),s(e,G,t),s(e,ot,t),s(e,E,t),s(e,pt,t),s(e,V,t),s(e,Mt,t),s(e,et,t),s(e,rt,t),s(e,R,t),s(e,ut,t),c(_,e,t),s(e,ct,t),s(e,S,t),s(e,yt,t),s(e,N,t),s(e,wt,t),s(e,Q,t),s(e,dt,t),s(e,H,t),s(e,Jt,t),s(e,Y,t),s(e,mt,t),s(e,X,t),s(e,Tt,t),s(e,q,t),s(e,Ut,t),s(e,z,t),s(e,ht,t),s(e,tt,t),s(e,bt,t),c(F,e,t),s(e,jt,t),s(e,L,t),s(e,It,t),s(e,D,t),s(e,gt,t),s(e,P,t),s(e,ft,t),s(e,K,t),s(e,Ct,t),c(O,e,t),s(e,xt,t),s(e,ee,t),s(e,vt,t),c(x,e,t),s(e,Bt,t),s(e,te,t),s(e,Zt,t),c(le,e,t),s(e,kt,t),s(e,se,t),s(e,$t,t),s(e,ne,t),s(e,Wt,t),s(e,ae,t),s(e,At,t),s(e,ie,t),s(e,Gt,t),c(oe,e,t),s(e,Et,t),c(pe,e,t),s(e,Vt,t),s(e,Me,t),s(e,Rt,t),c(re,e,t),s(e,_t,t),c(ue,e,t),s(e,St,t),s(e,ce,t),s(e,Nt,t),c(ye,e,t),s(e,Qt,t),c(v,e,t),s(e,Ht,t),s(e,we,t),s(e,Yt,t),s(e,de,t),s(e,Xt,t),s(e,B,t),s(e,qt,t),s(e,Je,t),s(e,zt,t),c(me,e,t),s(e,Ft,t),s(e,Te,t),s(e,Lt,t),s(e,Ue,t),s(e,Dt,t),c(he,e,t),s(e,Pt,t),c(be,e,t),s(e,Kt,t),c(je,e,t),s(e,Ot,t),s(e,Ie,t),s(e,el,t),c(ge,e,t),s(e,tl,t),c(fe,e,t),s(e,ll,t),s(e,Ce,t),s(e,sl,t),c(xe,e,t),s(e,nl,t),c(Z,e,t),s(e,al,t),c(ve,e,t),s(e,il,t),s(e,Be,t),s(e,ol,t),s(e,Ze,t),s(e,pl,t),c(ke,e,t),s(e,Ml,t),s(e,$e,t),s(e,rl,t),c(We,e,t),s(e,ul,t),c(Ae,e,t),s(e,cl,t),s(e,Ge,t),s(e,yl,t),s(e,Ee,t),s(e,wl,t),c(Ve,e,t),s(e,dl,t),s(e,Re,t),s(e,Jl,t),c(_e,e,t),s(e,ml,t),s(e,Se,t),s(e,Tl,t),c(Ne,e,t),s(e,Ul,t),c(Qe,e,t),s(e,hl,t),s(e,He,t),s(e,bl,t),s(e,Ye,t),s(e,jl,t),s(e,Xe,t),s(e,Il,t),c(qe,e,t),s(e,gl,t),s(e,ze,t),s(e,fl,t),c(Fe,e,t),s(e,Cl,t),s(e,Le,t),s(e,xl,t),c(De,e,t),s(e,vl,t),s(e,Pe,t),s(e,Bl,t),s(e,Ke,t),s(e,Zl,t),c(Oe,e,t),s(e,kl,t),s(e,lt,t),$l=!0},p(e,[t]){const ks={};t&2&&(ks.$$scope={dirty:t,ctx:e}),m.$set(ks);const $s={};t&2&&($s.$$scope={dirty:t,ctx:e}),x.$set($s);const Ws={};t&2&&(Ws.$$scope={dirty:t,ctx:e}),v.$set(Ws);const As={};t&2&&(As.$$scope={dirty:t,ctx:e}),Z.$set(As)},i(e){$l||(y(I.$$.fragment,e),y(b.$$.fragment,e),y(m.$$.fragment,e),y($.$$.fragment,e),y(_.$$.fragment,e),y(F.$$.fragment,e),y(O.$$.fragment,e),y(x.$$.fragment,e),y(le.$$.fragment,e),y(oe.$$.fragment,e),y(pe.$$.fragment,e),y(re.$$.fragment,e),y(ue.$$.fragment,e),y(ye.$$.fragment,e),y(v.$$.fragment,e),y(me.$$.fragment,e),y(he.$$.fragment,e),y(be.$$.fragment,e),y(je.$$.fragment,e),y(ge.$$.fragment,e),y(fe.$$.fragment,e),y(xe.$$.fragment,e),y(Z.$$.fragment,e),y(ve.$$.fragment,e),y(ke.$$.fragment,e),y(We.$$.fragment,e),y(Ae.$$.fragment,e),y(Ve.$$.fragment,e),y(_e.$$.fragment,e),y(Ne.$$.fragment,e),y(Qe.$$.fragment,e),y(qe.$$.fragment,e),y(Fe.$$.fragment,e),y(De.$$.fragment,e),y(Oe.$$.fragment,e),$l=!0)},o(e){w(I.$$.fragment,e),w(b.$$.fragment,e),w(m.$$.fragment,e),w($.$$.fragment,e),w(_.$$.fragment,e),w(F.$$.fragment,e),w(O.$$.fragment,e),w(x.$$.fragment,e),w(le.$$.fragment,e),w(oe.$$.fragment,e),w(pe.$$.fragment,e),w(re.$$.fragment,e),w(ue.$$.fragment,e),w(ye.$$.fragment,e),w(v.$$.fragment,e),w(me.$$.fragment,e),w(he.$$.fragment,e),w(be.$$.fragment,e),w(je.$$.fragment,e),w(ge.$$.fragment,e),w(fe.$$.fragment,e),w(xe.$$.fragment,e),w(Z.$$.fragment,e),w(ve.$$.fragment,e),w(ke.$$.fragment,e),w(We.$$.fragment,e),w(Ae.$$.fragment,e),w(Ve.$$.fragment,e),w(_e.$$.fragment,e),w(Ne.$$.fragment,e),w(Qe.$$.fragment,e),w(qe.$$.fragment,e),w(Fe.$$.fragment,e),w(De.$$.fragment,e),w(Oe.$$.fragment,e),$l=!1},d(e){e&&(l(h),l(J),l(U),l(f),l(k),l(g),l(nt),l(W),l(at),l(A),l(it),l(G),l(ot),l(E),l(pt),l(V),l(Mt),l(et),l(rt),l(R),l(ut),l(ct),l(S),l(yt),l(N),l(wt),l(Q),l(dt),l(H),l(Jt),l(Y),l(mt),l(X),l(Tt),l(q),l(Ut),l(z),l(ht),l(tt),l(bt),l(jt),l(L),l(It),l(D),l(gt),l(P),l(ft),l(K),l(Ct),l(xt),l(ee),l(vt),l(Bt),l(te),l(Zt),l(kt),l(se),l($t),l(ne),l(Wt),l(ae),l(At),l(ie),l(Gt),l(Et),l(Vt),l(Me),l(Rt),l(_t),l(St),l(ce),l(Nt),l(Qt),l(Ht),l(we),l(Yt),l(de),l(Xt),l(B),l(qt),l(Je),l(zt),l(Ft),l(Te),l(Lt),l(Ue),l(Dt),l(Pt),l(Kt),l(Ot),l(Ie),l(el),l(tl),l(ll),l(Ce),l(sl),l(nl),l(al),l(il),l(Be),l(ol),l(Ze),l(pl),l(Ml),l($e),l(rl),l(ul),l(cl),l(Ge),l(yl),l(Ee),l(wl),l(dl),l(Re),l(Jl),l(ml),l(Se),l(Tl),l(Ul),l(hl),l(He),l(bl),l(Ye),l(jl),l(Xe),l(Il),l(gl),l(ze),l(fl),l(Cl),l(Le),l(xl),l(vl),l(Pe),l(Bl),l(Ke),l(Zl),l(kl),l(lt)),l(M),d(I,e),d(b,e),d(m,e),d($,e),d(_,e),d(F,e),d(O,e),d(x,e),d(le,e),d(oe,e),d(pe,e),d(re,e),d(ue,e),d(ye,e),d(v,e),d(me,e),d(he,e),d(be,e),d(je,e),d(ge,e),d(fe,e),d(xe,e),d(Z,e),d(ve,e),d(ke,e),d(We,e),d(Ae,e),d(Ve,e),d(_e,e),d(Ne,e),d(Qe,e),d(qe,e),d(Fe,e),d(De,e),d(Oe,e)}}}const Ds='{"title":"Secure code execution","local":"secure-code-execution","sections":[{"title":"Code agents","local":"code-agents","sections":[],"depth":3},{"title":"Local code execution??","local":"local-code-execution","sections":[],"depth":3},{"title":"Our local Python executor","local":"our-local-python-executor","sections":[],"depth":3},{"title":"Sandbox approaches for secure code execution","local":"sandbox-approaches-for-secure-code-execution","sections":[{"title":"E2B setup","local":"e2b-setup","sections":[{"title":"Installation","local":"installation","sections":[],"depth":4},{"title":"Running your agent in E2B: quick start","local":"running-your-agent-in-e2b-quick-start","sections":[],"depth":4},{"title":"Running your agent in E2B: multi-agents","local":"running-your-agent-in-e2b-multi-agents","sections":[],"depth":4}],"depth":3},{"title":"Docker setup","local":"docker-setup","sections":[{"title":"Installation","local":"installation","sections":[],"depth":4},{"title":"Running your agent in Docker: quick start","local":"running-your-agent-in-docker-quick-start","sections":[],"depth":4},{"title":"Advanced docker usage","local":"advanced-docker-usage","sections":[],"depth":4}],"depth":3},{"title":"WebAssembly setup","local":"webassembly-setup","sections":[{"title":"Installation","local":"installation","sections":[],"depth":4},{"title":"Running your agent in WebAssembly: quick start","local":"running-your-agent-in-webassembly-quick-start","sections":[],"depth":4}],"depth":3},{"title":"Best practices for sandboxes","local":"best-practices-for-sandboxes","sections":[],"depth":3}],"depth":2},{"title":"Comparing security approaches","local":"comparing-security-approaches","sections":[{"title":"Approach 1: Running just the code snippets in a sandbox","local":"approach-1-running-just-the-code-snippets-in-a-sandbox","sections":[],"depth":3},{"title":"Approach 2: Running the entire agentic system in a sandbox","local":"approach-2-running-the-entire-agentic-system-in-a-sandbox","sections":[],"depth":3}],"depth":2}],"depth":1}';function Ps(j){return Rs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class nn extends _s{constructor(M){super(),Ss(this,M,Ps,Ls,Vs,{})}}export{nn as component};
