import{s as Ee,n as ze,o as Se}from"../chunks/scheduler.f6319a2a.js";import{S as Fe,i as He,g as p,s as n,r as i,A as xe,h as o,f as t,c as a,j as Qe,u as y,x as m,k as Ae,y as Ye,a as l,v as M,d as c,t as r,w as b}from"../chunks/index.85aa684c.js";import{C as S}from"../chunks/CodeBlock.3400fc53.js";import{D as Le}from"../chunks/DocNotebookDropdown.3fc3604b.js";import{H as je,E as qe}from"../chunks/getInferenceSnippets.bcbc4a43.js";function Pe(ge){let w,x,F,Y,u,L,h,q,J,fe=`In the end, an agent can be defined by simple components: it has tools, prompts.
And most importantly, it has a memory of past steps, drawing a history of planning, execution, and errors.`,P,T,D,d,Ie="We propose several features to inspect a past agent run.",K,U,Ce='You can instrument the agent’s run to display it in a great UI that lets you zoom in/out on specific steps, as highlighted in the <a href="./inspect_runs">instrumentation guide</a>.',O,j,Ze="You can also use <code>agent.replay()</code>, as follows:",ee,g,ve="After the agent has run:",se,f,te,I,Be="If you want to replay this last run, just use:",le,C,ne,Z,ae,v,_e="Many advanced use cases require dynamic modification of the agent’s memory.",pe,B,Ve="You can access the agent’s memory using:",oe,_,me,V,We="Use <code>agent.memory.get_full_steps()</code> to get full steps as dictionaries.",ie,W,ke="You can also use step callbacks to dynamically change the agent’s memory.",ye,k,Xe="Step callbacks can access the <code>agent</code> itself in their arguments, so they can access any memory step as highlighted above, and change it if needed. For instance, let’s say you are observing screenshots of each step performed by a web browser agent. You want to log the newest screenshot, and remove the images from ancient steps to save on token costs.",Me,X,Ge=`You could run something like the following.
<em>Note: this code is incomplete, some imports and object definitions have been removed for the sake of concision, visit <a href="https://github.com/huggingface/smolagents/blob/main/src/smolagents/vision_web_browser.py" rel="nofollow">the original script</a> to get the full working code.</em>`,ce,G,re,N,Ne="Then you should pass this function in the <code>step_callbacks</code> argument upon initialization of your agent:",be,$,we,R,$e='Head to our <a href="https://github.com/huggingface/smolagents/blob/main/src/smolagents/vision_web_browser.py" rel="nofollow">vision web browser code</a> to see the full working example.',ue,Q,he,A,Re=`This can be useful in case you have tool calls that take days: you can just run your agents step by step.
This will also let you update the memory on each step.`,Je,E,Te,z,de,H,Ue;return u=new je({props:{title:"📚 Manage your agent’s memory",local:"-manage-your-agents-memory",headingTag:"h1"}}),h=new Le({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/memory.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/pytorch/memory.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/tensorflow/memory.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/memory.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/pytorch/memory.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/tensorflow/memory.ipynb"}]}}),T=new je({props:{title:"Replay your agent’s memory",local:"replay-your-agents-memory",headingTag:"h3"}}),f=new S({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCUyQyUyMENvZGVBZ2VudCUwQSUwQWFnZW50JTIwJTNEJTIwQ29kZUFnZW50KHRvb2xzJTNEJTVCJTVEJTJDJTIwbW9kZWwlM0RJbmZlcmVuY2VDbGllbnRNb2RlbCgpJTJDJTIwdmVyYm9zaXR5X2xldmVsJTNEMCklMEElMEFyZXN1bHQlMjAlM0QlMjBhZ2VudC5ydW4oJTIyV2hhdCdzJTIwdGhlJTIwMjB0aCUyMEZpYm9uYWNjaSUyMG51bWJlciUzRiUyMik=",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> InferenceClientModel, CodeAgent

agent = CodeAgent(tools=[], model=InferenceClientModel(), verbosity_level=<span class="hljs-number">0</span>)

result = agent.run(<span class="hljs-string">&quot;What&#x27;s the 20th Fibonacci number?&quot;</span>)`,wrap:!1}}),C=new S({props:{code:"YWdlbnQucmVwbGF5KCk=",highlighted:"agent.replay()",wrap:!1}}),Z=new je({props:{title:"Dynamically change the agent’s memory",local:"dynamically-change-the-agents-memory",headingTag:"h3"}}),_=new S({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBBY3Rpb25TdGVwJTBBJTBBc3lzdGVtX3Byb21wdF9zdGVwJTIwJTNEJTIwYWdlbnQubWVtb3J5LnN5c3RlbV9wcm9tcHQlMEFwcmludCglMjJUaGUlMjBzeXN0ZW0lMjBwcm9tcHQlMjBnaXZlbiUyMHRvJTIwdGhlJTIwYWdlbnQlMjB3YXMlM0ElMjIpJTBBcHJpbnQoc3lzdGVtX3Byb21wdF9zdGVwLnN5c3RlbV9wcm9tcHQpJTBBJTBBdGFza19zdGVwJTIwJTNEJTIwYWdlbnQubWVtb3J5LnN0ZXBzJTVCMCU1RCUwQXByaW50KCUyMiU1Q24lNUNuVGhlJTIwZmlyc3QlMjB0YXNrJTIwc3RlcCUyMHdhcyUzQSUyMiklMEFwcmludCh0YXNrX3N0ZXAudGFzayklMEElMEFmb3IlMjBzdGVwJTIwaW4lMjBhZ2VudC5tZW1vcnkuc3RlcHMlM0ElMEElMjAlMjAlMjAlMjBpZiUyMGlzaW5zdGFuY2Uoc3RlcCUyQyUyMEFjdGlvblN0ZXApJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjBzdGVwLmVycm9yJTIwaXMlMjBub3QlMjBOb25lJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJpbnQoZiUyMiU1Q25TdGVwJTIwJTdCc3RlcC5zdGVwX251bWJlciU3RCUyMGdvdCUyMHRoaXMlMjBlcnJvciUzQSU1Q24lN0JzdGVwLmVycm9yJTdEJTVDbiUyMiklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBlbHNlJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJpbnQoZiUyMiU1Q25TdGVwJTIwJTdCc3RlcC5zdGVwX251bWJlciU3RCUyMGdvdCUyMHRoZXNlJTIwb2JzZXJ2YXRpb25zJTNBJTVDbiU3QnN0ZXAub2JzZXJ2YXRpb25zJTdEJTVDbiUyMik=",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> ActionStep

system_prompt_step = agent.memory.system_prompt
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;The system prompt given to the agent was:&quot;</span>)
<span class="hljs-built_in">print</span>(system_prompt_step.system_prompt)

task_step = agent.memory.steps[<span class="hljs-number">0</span>]
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;\\n\\nThe first task step was:&quot;</span>)
<span class="hljs-built_in">print</span>(task_step.task)

<span class="hljs-keyword">for</span> step <span class="hljs-keyword">in</span> agent.memory.steps:
    <span class="hljs-keyword">if</span> <span class="hljs-built_in">isinstance</span>(step, ActionStep):
        <span class="hljs-keyword">if</span> step.error <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>:
            <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;\\nStep <span class="hljs-subst">{step.step_number}</span> got this error:\\n<span class="hljs-subst">{step.error}</span>\\n&quot;</span>)
        <span class="hljs-keyword">else</span>:
            <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;\\nStep <span class="hljs-subst">{step.step_number}</span> got these observations:\\n<span class="hljs-subst">{step.observations}</span>\\n&quot;</span>)`,wrap:!1}}),G=new S({props:{code:"aW1wb3J0JTIwaGVsaXVtJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMGlvJTIwaW1wb3J0JTIwQnl0ZXNJTyUwQWZyb20lMjB0aW1lJTIwaW1wb3J0JTIwc2xlZXAlMEElMEFkZWYlMjB1cGRhdGVfc2NyZWVuc2hvdChtZW1vcnlfc3RlcCUzQSUyMEFjdGlvblN0ZXAlMkMlMjBhZ2VudCUzQSUyMENvZGVBZ2VudCklMjAtJTNFJTIwTm9uZSUzQSUwQSUyMCUyMCUyMCUyMHNsZWVwKDEuMCklMjAlMjAlMjMlMjBMZXQlMjBKYXZhU2NyaXB0JTIwYW5pbWF0aW9ucyUyMGhhcHBlbiUyMGJlZm9yZSUyMHRha2luZyUyMHRoZSUyMHNjcmVlbnNob3QlMEElMjAlMjAlMjAlMjBkcml2ZXIlMjAlM0QlMjBoZWxpdW0uZ2V0X2RyaXZlcigpJTBBJTIwJTIwJTIwJTIwbGF0ZXN0X3N0ZXAlMjAlM0QlMjBtZW1vcnlfc3RlcC5zdGVwX251bWJlciUwQSUyMCUyMCUyMCUyMGZvciUyMHByZXZpb3VzX21lbW9yeV9zdGVwJTIwaW4lMjBhZ2VudC5tZW1vcnkuc3RlcHMlM0ElMjAlMjAlMjMlMjBSZW1vdmUlMjBwcmV2aW91cyUyMHNjcmVlbnNob3RzJTIwZnJvbSUyMGxvZ3MlMjBmb3IlMjBsZWFuJTIwcHJvY2Vzc2luZyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlmJTIwaXNpbnN0YW5jZShwcmV2aW91c19tZW1vcnlfc3RlcCUyQyUyMEFjdGlvblN0ZXApJTIwYW5kJTIwcHJldmlvdXNfbWVtb3J5X3N0ZXAuc3RlcF9udW1iZXIlMjAlM0MlM0QlMjBsYXRlc3Rfc3RlcCUyMC0lMjAyJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJldmlvdXNfbWVtb3J5X3N0ZXAub2JzZXJ2YXRpb25zX2ltYWdlcyUyMCUzRCUyME5vbmUlMEElMjAlMjAlMjAlMjBwbmdfYnl0ZXMlMjAlM0QlMjBkcml2ZXIuZ2V0X3NjcmVlbnNob3RfYXNfcG5nKCklMEElMjAlMjAlMjAlMjBpbWFnZSUyMCUzRCUyMEltYWdlLm9wZW4oQnl0ZXNJTyhwbmdfYnl0ZXMpKSUwQSUyMCUyMCUyMCUyMG1lbW9yeV9zdGVwLm9ic2VydmF0aW9uc19pbWFnZXMlMjAlM0QlMjAlNUJpbWFnZS5jb3B5KCklNUQ=",highlighted:`<span class="hljs-keyword">import</span> helium
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">from</span> io <span class="hljs-keyword">import</span> BytesIO
<span class="hljs-keyword">from</span> time <span class="hljs-keyword">import</span> sleep

<span class="hljs-keyword">def</span> <span class="hljs-title function_">update_screenshot</span>(<span class="hljs-params">memory_step: ActionStep, agent: CodeAgent</span>) -&gt; <span class="hljs-literal">None</span>:
    sleep(<span class="hljs-number">1.0</span>)  <span class="hljs-comment"># Let JavaScript animations happen before taking the screenshot</span>
    driver = helium.get_driver()
    latest_step = memory_step.step_number
    <span class="hljs-keyword">for</span> previous_memory_step <span class="hljs-keyword">in</span> agent.memory.steps:  <span class="hljs-comment"># Remove previous screenshots from logs for lean processing</span>
        <span class="hljs-keyword">if</span> <span class="hljs-built_in">isinstance</span>(previous_memory_step, ActionStep) <span class="hljs-keyword">and</span> previous_memory_step.step_number &lt;= latest_step - <span class="hljs-number">2</span>:
            previous_memory_step.observations_images = <span class="hljs-literal">None</span>
    png_bytes = driver.get_screenshot_as_png()
    image = Image.<span class="hljs-built_in">open</span>(BytesIO(png_bytes))
    memory_step.observations_images = [image.copy()]`,wrap:!1}}),$=new S({props:{code:"Q29kZUFnZW50KCUwQSUyMCUyMCUyMCUyMHRvb2xzJTNEJTVCV2ViU2VhcmNoVG9vbCgpJTJDJTIwZ29fYmFjayUyQyUyMGNsb3NlX3BvcHVwcyUyQyUyMHNlYXJjaF9pdGVtX2N0cmxfZiU1RCUyQyUwQSUyMCUyMCUyMCUyMG1vZGVsJTNEbW9kZWwlMkMlMEElMjAlMjAlMjAlMjBhZGRpdGlvbmFsX2F1dGhvcml6ZWRfaW1wb3J0cyUzRCU1QiUyMmhlbGl1bSUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMHN0ZXBfY2FsbGJhY2tzJTNEJTVCdXBkYXRlX3NjcmVlbnNob3QlNUQlMkMlMEElMjAlMjAlMjAlMjBtYXhfc3RlcHMlM0QyMCUyQyUwQSUyMCUyMCUyMCUyMHZlcmJvc2l0eV9sZXZlbCUzRDIlMkMlMEEp",highlighted:`CodeAgent(
    tools=[WebSearchTool(), go_back, close_popups, search_item_ctrl_f],
    model=model,
    additional_authorized_imports=[<span class="hljs-string">&quot;helium&quot;</span>],
    step_callbacks=[update_screenshot],
    max_steps=<span class="hljs-number">20</span>,
    verbosity_level=<span class="hljs-number">2</span>,
)`,wrap:!1}}),Q=new je({props:{title:"Run agents one step at a time",local:"run-agents-one-step-at-a-time",headingTag:"h3"}}),E=new S({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCUyQyUyMENvZGVBZ2VudCUyQyUyMEFjdGlvblN0ZXAlMkMlMjBUYXNrU3RlcCUwQSUwQWFnZW50JTIwJTNEJTIwQ29kZUFnZW50KHRvb2xzJTNEJTVCJTVEJTJDJTIwbW9kZWwlM0RJbmZlcmVuY2VDbGllbnRNb2RlbCgpJTJDJTIwdmVyYm9zaXR5X2xldmVsJTNEMSklMEFhZ2VudC5weXRob25fZXhlY3V0b3Iuc2VuZF90b29scyglN0IqKmFnZW50LnRvb2xzJTdEKSUwQXByaW50KGFnZW50Lm1lbW9yeS5zeXN0ZW1fcHJvbXB0KSUwQSUwQXRhc2slMjAlM0QlMjAlMjJXaGF0JTIwaXMlMjB0aGUlMjAyMHRoJTIwRmlib25hY2NpJTIwbnVtYmVyJTNGJTIyJTBBJTBBJTIzJTIwWW91JTIwY291bGQlMjBtb2RpZnklMjB0aGUlMjBtZW1vcnklMjBhcyUyMG5lZWRlZCUyMGhlcmUlMjBieSUyMGlucHV0dGluZyUyMHRoZSUyMG1lbW9yeSUyMG9mJTIwYW5vdGhlciUyMGFnZW50LiUwQSUyMyUyMGFnZW50Lm1lbW9yeS5zdGVwcyUyMCUzRCUyMHByZXZpb3VzX2FnZW50Lm1lbW9yeS5zdGVwcyUwQSUwQSUyMyUyMExldCdzJTIwc3RhcnQlMjBhJTIwbmV3JTIwdGFzayElMEFhZ2VudC5tZW1vcnkuc3RlcHMuYXBwZW5kKFRhc2tTdGVwKHRhc2slM0R0YXNrJTJDJTIwdGFza19pbWFnZXMlM0QlNUIlNUQpKSUwQSUwQWZpbmFsX2Fuc3dlciUyMCUzRCUyME5vbmUlMEFzdGVwX251bWJlciUyMCUzRCUyMDElMEF3aGlsZSUyMGZpbmFsX2Fuc3dlciUyMGlzJTIwTm9uZSUyMGFuZCUyMHN0ZXBfbnVtYmVyJTIwJTNDJTNEJTIwMTAlM0ElMEElMjAlMjAlMjAlMjBtZW1vcnlfc3RlcCUyMCUzRCUyMEFjdGlvblN0ZXAoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3RlcF9udW1iZXIlM0RzdGVwX251bWJlciUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG9ic2VydmF0aW9uc19pbWFnZXMlM0QlNUIlNUQlMkMlMEElMjAlMjAlMjAlMjApJTBBJTIwJTIwJTIwJTIwJTIzJTIwUnVuJTIwb25lJTIwc3RlcC4lMEElMjAlMjAlMjAlMjBmaW5hbF9hbnN3ZXIlMjAlM0QlMjBhZ2VudC5zdGVwKG1lbW9yeV9zdGVwKSUwQSUyMCUyMCUyMCUyMGFnZW50Lm1lbW9yeS5zdGVwcy5hcHBlbmQobWVtb3J5X3N0ZXApJTBBJTIwJTIwJTIwJTIwc3RlcF9udW1iZXIlMjAlMkIlM0QlMjAxJTBBJTBBJTIwJTIwJTIwJTIwJTIzJTIwQ2hhbmdlJTIwdGhlJTIwbWVtb3J5JTIwYXMlMjB5b3UlMjBwbGVhc2UhJTBBJTIwJTIwJTIwJTIwJTIzJTIwRm9yJTIwaW5zdGFuY2UlMjB0byUyMHVwZGF0ZSUyMHRoZSUyMGxhdGVzdCUyMHN0ZXAlM0ElMEElMjAlMjAlMjAlMjAlMjMlMjBhZ2VudC5tZW1vcnkuc3RlcHMlNUItMSU1RCUyMCUzRCUyMC4uLiUwQSUwQXByaW50KCUyMlRoZSUyMGZpbmFsJTIwYW5zd2VyJTIwaXMlM0ElMjIlMkMlMjBmaW5hbF9hbnN3ZXIp",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> InferenceClientModel, CodeAgent, ActionStep, TaskStep

agent = CodeAgent(tools=[], model=InferenceClientModel(), verbosity_level=<span class="hljs-number">1</span>)
agent.python_executor.send_tools({**agent.tools})
<span class="hljs-built_in">print</span>(agent.memory.system_prompt)

task = <span class="hljs-string">&quot;What is the 20th Fibonacci number?&quot;</span>

<span class="hljs-comment"># You could modify the memory as needed here by inputting the memory of another agent.</span>
<span class="hljs-comment"># agent.memory.steps = previous_agent.memory.steps</span>

<span class="hljs-comment"># Let&#x27;s start a new task!</span>
agent.memory.steps.append(TaskStep(task=task, task_images=[]))

final_answer = <span class="hljs-literal">None</span>
step_number = <span class="hljs-number">1</span>
<span class="hljs-keyword">while</span> final_answer <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span> <span class="hljs-keyword">and</span> step_number &lt;= <span class="hljs-number">10</span>:
    memory_step = ActionStep(
        step_number=step_number,
        observations_images=[],
    )
    <span class="hljs-comment"># Run one step.</span>
    final_answer = agent.step(memory_step)
    agent.memory.steps.append(memory_step)
    step_number += <span class="hljs-number">1</span>

    <span class="hljs-comment"># Change the memory as you please!</span>
    <span class="hljs-comment"># For instance to update the latest step:</span>
    <span class="hljs-comment"># agent.memory.steps[-1] = ...</span>

<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;The final answer is:&quot;</span>, final_answer)`,wrap:!1}}),z=new qe({props:{source:"https://github.com/huggingface/smolagents/blob/main/docs/source/en/tutorials/memory.md"}}),{c(){w=p("meta"),x=n(),F=p("p"),Y=n(),i(u.$$.fragment),L=n(),i(h.$$.fragment),q=n(),J=p("p"),J.textContent=fe,P=n(),i(T.$$.fragment),D=n(),d=p("p"),d.textContent=Ie,K=n(),U=p("p"),U.innerHTML=Ce,O=n(),j=p("p"),j.innerHTML=Ze,ee=n(),g=p("p"),g.textContent=ve,se=n(),i(f.$$.fragment),te=n(),I=p("p"),I.textContent=Be,le=n(),i(C.$$.fragment),ne=n(),i(Z.$$.fragment),ae=n(),v=p("p"),v.textContent=_e,pe=n(),B=p("p"),B.textContent=Ve,oe=n(),i(_.$$.fragment),me=n(),V=p("p"),V.innerHTML=We,ie=n(),W=p("p"),W.textContent=ke,ye=n(),k=p("p"),k.innerHTML=Xe,Me=n(),X=p("p"),X.innerHTML=Ge,ce=n(),i(G.$$.fragment),re=n(),N=p("p"),N.innerHTML=Ne,be=n(),i($.$$.fragment),we=n(),R=p("p"),R.innerHTML=$e,ue=n(),i(Q.$$.fragment),he=n(),A=p("p"),A.textContent=Re,Je=n(),i(E.$$.fragment),Te=n(),i(z.$$.fragment),de=n(),H=p("p"),this.h()},l(e){const s=xe("svelte-u9bgzb",document.head);w=o(s,"META",{name:!0,content:!0}),s.forEach(t),x=a(e),F=o(e,"P",{}),Qe(F).forEach(t),Y=a(e),y(u.$$.fragment,e),L=a(e),y(h.$$.fragment,e),q=a(e),J=o(e,"P",{"data-svelte-h":!0}),m(J)!=="svelte-102p4os"&&(J.textContent=fe),P=a(e),y(T.$$.fragment,e),D=a(e),d=o(e,"P",{"data-svelte-h":!0}),m(d)!=="svelte-p9bsvd"&&(d.textContent=Ie),K=a(e),U=o(e,"P",{"data-svelte-h":!0}),m(U)!=="svelte-cyladv"&&(U.innerHTML=Ce),O=a(e),j=o(e,"P",{"data-svelte-h":!0}),m(j)!=="svelte-1j5hyq7"&&(j.innerHTML=Ze),ee=a(e),g=o(e,"P",{"data-svelte-h":!0}),m(g)!=="svelte-kdqcx3"&&(g.textContent=ve),se=a(e),y(f.$$.fragment,e),te=a(e),I=o(e,"P",{"data-svelte-h":!0}),m(I)!=="svelte-16cln5c"&&(I.textContent=Be),le=a(e),y(C.$$.fragment,e),ne=a(e),y(Z.$$.fragment,e),ae=a(e),v=o(e,"P",{"data-svelte-h":!0}),m(v)!=="svelte-8gbd4j"&&(v.textContent=_e),pe=a(e),B=o(e,"P",{"data-svelte-h":!0}),m(B)!=="svelte-dw95g"&&(B.textContent=Ve),oe=a(e),y(_.$$.fragment,e),me=a(e),V=o(e,"P",{"data-svelte-h":!0}),m(V)!=="svelte-oqerv4"&&(V.innerHTML=We),ie=a(e),W=o(e,"P",{"data-svelte-h":!0}),m(W)!=="svelte-2c0lec"&&(W.textContent=ke),ye=a(e),k=o(e,"P",{"data-svelte-h":!0}),m(k)!=="svelte-1g68dq6"&&(k.innerHTML=Xe),Me=a(e),X=o(e,"P",{"data-svelte-h":!0}),m(X)!=="svelte-1g8132p"&&(X.innerHTML=Ge),ce=a(e),y(G.$$.fragment,e),re=a(e),N=o(e,"P",{"data-svelte-h":!0}),m(N)!=="svelte-1s6pldm"&&(N.innerHTML=Ne),be=a(e),y($.$$.fragment,e),we=a(e),R=o(e,"P",{"data-svelte-h":!0}),m(R)!=="svelte-1c9b7q3"&&(R.innerHTML=$e),ue=a(e),y(Q.$$.fragment,e),he=a(e),A=o(e,"P",{"data-svelte-h":!0}),m(A)!=="svelte-1jw480t"&&(A.textContent=Re),Je=a(e),y(E.$$.fragment,e),Te=a(e),y(z.$$.fragment,e),de=a(e),H=o(e,"P",{}),Qe(H).forEach(t),this.h()},h(){Ae(w,"name","hf:doc:metadata"),Ae(w,"content",De)},m(e,s){Ye(document.head,w),l(e,x,s),l(e,F,s),l(e,Y,s),M(u,e,s),l(e,L,s),M(h,e,s),l(e,q,s),l(e,J,s),l(e,P,s),M(T,e,s),l(e,D,s),l(e,d,s),l(e,K,s),l(e,U,s),l(e,O,s),l(e,j,s),l(e,ee,s),l(e,g,s),l(e,se,s),M(f,e,s),l(e,te,s),l(e,I,s),l(e,le,s),M(C,e,s),l(e,ne,s),M(Z,e,s),l(e,ae,s),l(e,v,s),l(e,pe,s),l(e,B,s),l(e,oe,s),M(_,e,s),l(e,me,s),l(e,V,s),l(e,ie,s),l(e,W,s),l(e,ye,s),l(e,k,s),l(e,Me,s),l(e,X,s),l(e,ce,s),M(G,e,s),l(e,re,s),l(e,N,s),l(e,be,s),M($,e,s),l(e,we,s),l(e,R,s),l(e,ue,s),M(Q,e,s),l(e,he,s),l(e,A,s),l(e,Je,s),M(E,e,s),l(e,Te,s),M(z,e,s),l(e,de,s),l(e,H,s),Ue=!0},p:ze,i(e){Ue||(c(u.$$.fragment,e),c(h.$$.fragment,e),c(T.$$.fragment,e),c(f.$$.fragment,e),c(C.$$.fragment,e),c(Z.$$.fragment,e),c(_.$$.fragment,e),c(G.$$.fragment,e),c($.$$.fragment,e),c(Q.$$.fragment,e),c(E.$$.fragment,e),c(z.$$.fragment,e),Ue=!0)},o(e){r(u.$$.fragment,e),r(h.$$.fragment,e),r(T.$$.fragment,e),r(f.$$.fragment,e),r(C.$$.fragment,e),r(Z.$$.fragment,e),r(_.$$.fragment,e),r(G.$$.fragment,e),r($.$$.fragment,e),r(Q.$$.fragment,e),r(E.$$.fragment,e),r(z.$$.fragment,e),Ue=!1},d(e){e&&(t(x),t(F),t(Y),t(L),t(q),t(J),t(P),t(D),t(d),t(K),t(U),t(O),t(j),t(ee),t(g),t(se),t(te),t(I),t(le),t(ne),t(ae),t(v),t(pe),t(B),t(oe),t(me),t(V),t(ie),t(W),t(ye),t(k),t(Me),t(X),t(ce),t(re),t(N),t(be),t(we),t(R),t(ue),t(he),t(A),t(Je),t(Te),t(de),t(H)),t(w),b(u,e),b(h,e),b(T,e),b(f,e),b(C,e),b(Z,e),b(_,e),b(G,e),b($,e),b(Q,e),b(E,e),b(z,e)}}}const De='{"title":"📚 Manage your agent’s memory","local":"-manage-your-agents-memory","sections":[{"title":"Replay your agent’s memory","local":"replay-your-agents-memory","sections":[],"depth":3},{"title":"Dynamically change the agent’s memory","local":"dynamically-change-the-agents-memory","sections":[],"depth":3},{"title":"Run agents one step at a time","local":"run-agents-one-step-at-a-time","sections":[],"depth":3}],"depth":1}';function Ke(ge){return Se(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ns extends Fe{constructor(w){super(),He(this,w,Ke,Pe,Ee,{})}}export{ns as component};
