import{s as Pl,n as Yl,o as Ol}from"../chunks/scheduler.7da89386.js";import{S as Kl,i as Dl,g as M,s as n,r as o,A as et,h as a,f as t,c as s,j as Fl,u as y,x as r,k as ql,y as lt,a as i,v as p,d,t as T,w as U}from"../chunks/index.0b7befd3.js";import{C as c}from"../chunks/CodeBlock.c5b6371f.js";import{H as m,E as tt}from"../chunks/getInferenceSnippets.6ead4bda.js";function it(Jl){let w,Ce,me,Je,C,ue,J,ul=`A kernel can provide layers in addition to kernel functions. A layer from
the Hub can replace the <code>forward</code> method of an existing layer for a certain
device type. This makes it possible to provide more performant kernels for
existing layers.`,Ie,u,Il=`See <a href="kernel-requirements.md">Kernel requirements</a> for more information the
requirements of Hub layers.`,fe,I,he,f,je,h,fl=`A layer can be made extensible with the <code>use_kernel_forward_from_hub</code>
decorator. For example:`,be,j,ke,b,hl=`The decorator does not change the behavior of the class — it annotates
the class with the given name (here <code>SiluAndMul</code>). The <code>kernelize</code> function
described below uses this name to look up kernels for the layer.`,Ae,k,ge,A,jl=`An existing layer that does not (yet) have the <code>use_kernel_forward_from_hub</code>
decorator can be made extensible using the <code>replace_kernel_forward_from_hub</code>
function:`,$e,g,Ee,$,bl=`<strong>Warning:</strong> we strongly recommend using layers with a decorator, since
it signifies that the maintainer intends to keep the <code>forward</code> signature
compatible with layers from the hub.`,Re,E,ve,R,kl=`A model will not use Hub kernels by default, even if it contains extensible
layers. To enable the use of Hub kernels in the model, it needs to be
‘kernelized’ using the <code>kernelize</code> function. This function traverses the
model graph and replaces the <code>forward</code> methods of extensible layers for which
Hub kernels are registered. <code>kernelize</code> can be used as follows:`,Ne,v,_e,N,Al=`The <code>kernelize</code> function modifies the model in-place, the model itself is
returned as a convenience. The <code>mode</code> specifies that the model will be used
in inference. Similarly, you can ask <code>kernelize</code> to prepare the model for
training:`,Be,_,Ge,B,gl=`A model that is kernelized for training can also be used for inference, but
not the other way around. If you want to change the mode of the kernelized
model, you can just run <code>kernelize</code> on the model again with the new mode.`,He,G,$l=`If you want to compile a model with <code>torch.compile</code>, this should be indicated
in the mode as well. You can do this by combining <code>Mode.INFERENCE</code> or
<code>Mode.TRAINING</code> with <code>Mode.TORCH_COMPILE</code> using the set union (<code>|</code>) operator:`,Le,H,We,L,El=`When the <code>mode</code> argument is not specified,
<code>Mode.TRAINING | Mode.TORCH_COMPILE</code> is used as the default. This mode
aligns most closely with pure PyTorch layers which also support training
and <code>torch.compile</code>. However, to select the most performant kernels, it
is often good to make the mode specific as possible.`,xe,W,Se,x,Rl=`Kernels can be registered per device type. For instance, separate <code>cuda</code> and
<code>metal</code> kernels could be registered for the name <code>SiluAndMul</code>. By default,
<code>kernelize</code> will try to infer the device type from the model’s parameters.
You can pass the device type to <code>kernelize</code> if the device type cannot be
inferred (e.g. because the model has no parameters):`,Ze,S,Ve,Z,Qe,V,vl=`If the <code>TRAINING</code> and/or <code>TORCH_COMPILE</code> modes are used, but a registered
kernel does not support backward passes or <code>torch.compile</code> respectively,
<code>kernelize</code> will fall back to the original, non-kernelized, layer. You
can let <code>kernelize</code> raise an exception instead by using <code>use_fallback=False</code>:`,Xe,Q,ze,X,Nl="This can be useful if you want to guarantee that Hub kernels are used.",Fe,z,qe,F,_l=`The kernels that are used are logged at the <code>INFO</code> level by <code>kernelize</code>.
See the <a href="https://docs.python.org/3/library/logging.html" rel="nofollow">Python logging</a>
documentation for information on how to configure logging.`,Pe,q,Ye,P,Bl=`<code>kernelize</code> relies on kernel mappings to find Hub kernels for layers.
Kernel mappings map a kernel name such as <code>SiluAndMul</code> to a kernel on
the Hub. For example:`,Oe,Y,Ke,O,Gl="You can register such a mapping using <code>register_kernel_mapping</code>:",De,K,el,D,Hl=`This will register the kernel mapping in the current context, which is
normally global. It is recommended to scope the mapping to where it is
used with the <code>use_kernel_mapping</code> context manager:`,ll,ee,tl,le,Ll=`This ensures that the mapping is not active anymore outside the
<code>with</code>-scope.`,il,te,nl,ie,Wl=`You might want to register two different kernels for a particular layer,
where one kernel is optimized for a specific mode. You can do so by
registering layer repositories for specific modes. For example:`,sl,ne,Ml,se,xl=`The <code>kernelize</code> function will attempt to use the following registered
kernels for a given mode:`,al,Me,Sl=`<li><code>INFERENCE</code>: <code>INFERENCE</code> → <code>INFERENCE | TORCH_COMPILE</code> → <code>TRAINING</code> →
<code>TRAINING | TORCH_COMPILE</code> → <code>FALLBACK</code></li> <li><code>INFERENCE | TORCH_COMPILE</code>: <code>INFERENCE | TORCH_COMPILE</code> →
<code>TRAINING | TORCH_COMPILE</code> → <code>FALLBACK</code></li> <li><code>TRAINING</code>: <code>TRAINING</code> → <code>TRAINING | TORCH_COMPILE</code> → <code>FALLBACK</code></li> <li><code>TRAINING | TORCH_COMPILE</code>: <code>TRAINING | TORCH_COMPILE</code> → <code>FALLBACK</code></li>`,rl,ae,Zl=`<code>Mode.FALLBACK</code> is a special mode that is used when no other mode matches. It
is also used when a kernel is registered without a mode, as described in the
previous section.`,ol,re,yl,oe,Vl=`In this case, both <code>Mode.INFERENCE | Mode.TORCH_COMPILE</code> and
<code>Mode.TRAINING | Mode.TORCH_COMPILE</code> will use the <code>Mode.FALLBACK</code> kernel,
since the other kernels do not support <code>torch.compile</code>.`,pl,ye,dl,pe,Ql=`Some kernels only work with newer CUDA architectures. For instance, some
kernels require capability 9.0 for the TMA unit on Hopper GPUs. <code>kernels</code>
supports registering layers for a range of CUDA capabilities. To do so,
you need to register the layer for a <code>Device</code> with type <code>cuda</code> and
set the supported range of CUDA capabilities with using <code>CUDAProperties</code>:`,Tl,de,Ul,Te,Xl="Capabilities behave as follows:",cl,Ue,zl=`<li><p>The minimum and maximum capabilities are inclusive.</p></li> <li><p>When a new kernel is registered with the same min/max capabilities as
an existing kernel, the new kernel will replace the old kernel.</p></li> <li><p>When there are multiple kernels that support a capability, the kernel
with the smaller capability interval will be used. E.g. given:</p> <ul><li><code>KernelA</code> with <code>min_capability=80</code> and <code>max_capability=89</code>;</li> <li><code>KernelB</code> with <code>min_capability=75</code> and <code>max_capability=89</code>;</li> <li><code>kernelize</code> runs on a system with capability 8.6.</li></ul> <p>Then <code>KernelA</code> will be used because the interval 80..89 is smaller
than 75..89. The motivation is that kernels with smaller ranges
tend to be more optimized for a specific set of GPUs. <strong>This behavior
might still change in the future.</strong></p></li>`,ml,ce,wl,we,Cl;return C=new m({props:{title:"Layers",local:"layers",headingTag:"h1"}}),I=new m({props:{title:"Making a layer extensible with kernels from the hub",local:"making-a-layer-extensible-with-kernels-from-the-hub",headingTag:"h2"}}),f=new m({props:{title:"Using a decorator",local:"using-a-decorator",headingTag:"h3"}}),j=new c({props:{code:"JTQwdXNlX2tlcm5lbF9mb3J3YXJkX2Zyb21faHViKCUyMlNpbHVBbmRNdWwlMjIpJTBBY2xhc3MlMjBTaWx1QW5kTXVsKG5uLk1vZHVsZSklM0ElMEElMjAlMjAlMjAlMjBkZWYlMjBmb3J3YXJkKHNlbGYlMkMlMjBpbnB1dCUzQSUyMHRvcmNoLlRlbnNvciklMjAtJTNFJTIwdG9yY2guVGVuc29yJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZCUyMCUzRCUyMGlucHV0LnNoYXBlJTVCLTElNUQlMjAlMkYlMkYlMjAyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwRi5zaWx1KGlucHV0JTVCLi4uJTJDJTIwJTNBZCU1RCklMjAqJTIwaW5wdXQlNUIuLi4lMkMlMjBkJTNBJTVE",highlighted:`<span class="hljs-meta">@use_kernel_forward_from_hub(<span class="hljs-params"><span class="hljs-string">&quot;SiluAndMul&quot;</span></span>)</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">SiluAndMul</span>(nn.Module):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, <span class="hljs-built_in">input</span>: torch.Tensor</span>) -&gt; torch.Tensor:
        d = <span class="hljs-built_in">input</span>.shape[-<span class="hljs-number">1</span>] // <span class="hljs-number">2</span>
        <span class="hljs-keyword">return</span> F.silu(<span class="hljs-built_in">input</span>[..., :d]) * <span class="hljs-built_in">input</span>[..., d:]`,wrap:!1}}),k=new m({props:{title:"External layers",local:"external-layers",headingTag:"h3"}}),g=new c({props:{code:"ZnJvbSUyMHNvbWVsaWJyYXJ5JTIwaW1wb3J0JTIwU2lsdUFuZE11bCUwQSUwQXJlcGxhY2Vfa2VybmVsX2ZvcndhcmRfZnJvbV9odWIoU2lsdUFuZE11bCUyQyUyMCUyMlNpbHVBbmRNdWwlMjIp",highlighted:`<span class="hljs-keyword">from</span> somelibrary <span class="hljs-keyword">import</span> SiluAndMul

replace_kernel_forward_from_hub(SiluAndMul, <span class="hljs-string">&quot;SiluAndMul&quot;</span>)`,wrap:!1}}),E=new m({props:{title:"Kernelizing a model",local:"kernelizing-a-model",headingTag:"h2"}}),v=new c({props:{code:"bW9kZWwlMjAlM0QlMjBNeU1vZGVsKC4uLiklMEFtb2RlbCUyMCUzRCUyMGtlcm5lbGl6ZShtb2RlbCUyQyUyMG1vZGUlM0RNb2RlLklORkVSRU5DRSk=",highlighted:`model = MyModel(...)
model = kernelize(model, mode=Mode.INFERENCE)`,wrap:!1}}),_=new c({props:{code:"bW9kZWwlMjAlM0QlMjBNeU1vZGVsKC4uLiklMEFtb2RlbCUyMCUzRCUyMGtlcm5lbGl6ZShtb2RlbCUyQyUyMG1vZGUlM0RNb2RlLlRSQUlOSU5HKQ==",highlighted:`model = MyModel(...)
model = kernelize(model, mode=Mode.TRAINING)`,wrap:!1}}),H=new c({props:{code:"bW9kZWwlMjAlM0QlMjBNeU1vZGVsKC4uLiklMEElMEElMjMlMjBJbmZlcmVuY2UlMEFtb2RlbCUyMCUzRCUyMGtlcm5lbGl6ZShtb2RlbCUyQyUyMG1vZGUlM0RNb2RlLklORkVSRU5DRSUyMCU3QyUyME1vZGUuVE9SQ0hfQ09NUElMRSklMEElMEElMjMlMjBUcmFpbmluZyUwQW1vZGVsJTIwJTNEJTIwa2VybmVsaXplKG1vZGVsJTJDJTIwbW9kZSUzRE1vZGUuVFJBSU5JTkclMjAlN0MlMjBNb2RlLlRPUkNIX0NPTVBJTEUp",highlighted:`model = MyModel(...)

<span class="hljs-comment"># Inference</span>
model = kernelize(model, mode=Mode.INFERENCE | Mode.TORCH_COMPILE)

<span class="hljs-comment"># Training</span>
model = kernelize(model, mode=Mode.TRAINING | Mode.TORCH_COMPILE)`,wrap:!1}}),W=new m({props:{title:"Kernel device",local:"kernel-device",headingTag:"h3"}}),S=new c({props:{code:"bW9kZWwlMjAlM0QlMjBNeU1vZGVsKC4uLiklMEFtb2RlbCUyMCUzRCUyMGtlcm5lbGl6ZShtb2RlbCUyQyUyMGRldmljZSUzRCUyMmN1ZGElMjIlMkMlMjBtb2RlJTNETW9kZS5JTkZFUkVOQ0Up",highlighted:`model = MyModel(...)
model = kernelize(model, device=<span class="hljs-string">&quot;cuda&quot;</span>, mode=Mode.INFERENCE)`,wrap:!1}}),Z=new m({props:{title:"Fallback forward",local:"fallback-forward",headingTag:"h3"}}),Q=new c({props:{code:"bW9kZWwlMjAlM0QlMjBNeU1vZGVsKC4uLiklMEFtb2RlbCUyMCUzRCUyMGtlcm5lbGl6ZShtb2RlbCUyQyUyMG1vZGUlM0RNb2RlLklORkVSRU5DRSUyMCU3QyUyME1vZGUuVE9SQ0hfQ09NUElMRSUyQyUyMHVzZV9mYWxsYmFjayUzREZhbHNlKQ==",highlighted:`model = MyModel(...)
model = kernelize(model, mode=Mode.INFERENCE | Mode.TORCH_COMPILE, use_fallback=<span class="hljs-literal">False</span>)`,wrap:!1}}),z=new m({props:{title:"Inspecting kernels which kernels are used",local:"inspecting-kernels-which-kernels-are-used",headingTag:"h3"}}),q=new m({props:{title:"Registering a hub kernel for a layer",local:"registering-a-hub-kernel-for-a-layer",headingTag:"h2"}}),Y=new c({props:{code:"a2VybmVsX2xheWVyX21hcHBpbmclMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjJTaWx1QW5kTXVsJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyY3VkYSUyMiUzQSUyMExheWVyUmVwb3NpdG9yeSglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXBvX2lkJTNEJTIya2VybmVscy1jb21tdW5pdHklMkZhY3RpdmF0aW9uJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbGF5ZXJfbmFtZSUzRCUyMlNpbHVBbmRNdWwlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTBBJTIwJTIwJTIwJTIwJTdEJTBBJTdE",highlighted:`kernel_layer_mapping = {
    <span class="hljs-string">&quot;SiluAndMul&quot;</span>: {
        <span class="hljs-string">&quot;cuda&quot;</span>: LayerRepository(
            repo_id=<span class="hljs-string">&quot;kernels-community/activation&quot;</span>,
            layer_name=<span class="hljs-string">&quot;SiluAndMul&quot;</span>,
        )
    }
}`,wrap:!1}}),K=new c({props:{code:"cmVnaXN0ZXJfa2VybmVsX21hcHBpbmcoa2VybmVsX2xheWVyX21hcHBpbmcp",highlighted:"register_kernel_mapping(kernel_layer_mapping)",wrap:!1}}),ee=new c({props:{code:"d2l0aCUyMHVzZV9rZXJuZWxfbWFwcGluZyhrZXJuZWxfbGF5ZXJfbWFwcGluZyklM0ElMEElMjAlMjAlMjAlMjAlMjMlMjBVc2UlMjB0aGUlMjBsYXllciUyMGZvciUyMHdoaWNoJTIwdGhlJTIwbWFwcGluZyUyMGlzJTIwYXBwbGllZC4lMEElMjAlMjAlMjAlMjBtb2RlbCUyMCUzRCUyMGtlcm5lbGl6ZShtb2RlbCk=",highlighted:`<span class="hljs-keyword">with</span> use_kernel_mapping(kernel_layer_mapping):
    <span class="hljs-comment"># Use the layer for which the mapping is applied.</span>
    model = kernelize(model)`,wrap:!1}}),te=new m({props:{title:"Registering kernels for specific modes",local:"registering-kernels-for-specific-modes",headingTag:"h3"}}),ne=new c({props:{code:"a2VybmVsX2xheWVyX21hcHBpbmclMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjJTaWx1QW5kTXVsJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyY3VkYSUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyME1vZGUuSU5GRVJFTkNFJTNBJTIwTGF5ZXJSZXBvc2l0b3J5KCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJlcG9faWQlM0QlMjJrZXJuZWxzLWNvbW11bml0eSUyRmFjdGl2YXRpb24taW5mZXJlbmNlLW9wdGltaXplZCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxheWVyX25hbWUlM0QlMjJTaWx1QW5kTXVsJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyME1vZGUuVFJBSU5JTkclMjAlN0MlMjBNb2RlLlRPUkNIX0NPTVBJTEUlM0ElMjBMYXllclJlcG9zaXRvcnkoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmVwb19pZCUzRCUyMmtlcm5lbHMtY29tbXVuaXR5JTJGYWN0aXZhdGlvbi10cmFpbmluZy1vcHRpbWl6ZWQlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsYXllcl9uYW1lJTNEJTIyU2lsdUFuZE11bCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlMjAlMjAlN0QlMEElN0Q=",highlighted:`kernel_layer_mapping = {
    <span class="hljs-string">&quot;SiluAndMul&quot;</span>: {
        <span class="hljs-string">&quot;cuda&quot;</span>: {
          Mode.INFERENCE: LayerRepository(
              repo_id=<span class="hljs-string">&quot;kernels-community/activation-inference-optimized&quot;</span>,
              layer_name=<span class="hljs-string">&quot;SiluAndMul&quot;</span>,
          ),
          Mode.TRAINING | Mode.TORCH_COMPILE: LayerRepository(
              repo_id=<span class="hljs-string">&quot;kernels-community/activation-training-optimized&quot;</span>,
              layer_name=<span class="hljs-string">&quot;SiluAndMul&quot;</span>,
          ),
      }
    }
}`,wrap:!1}}),re=new c({props:{code:"a2VybmVsX2xheWVyX21hcHBpbmclMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjJTaWx1QW5kTXVsJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyY3VkYSUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyME1vZGUuRkFMTEJBQ0slM0ElMjBMYXllclJlcG9zaXRvcnkoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmVwb19pZCUzRCUyMmtlcm5lbHMtY29tbXVuaXR5JTJGYWN0aXZhdGlvbiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxheWVyX25hbWUlM0QlMjJTaWx1QW5kTXVsJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyME1vZGUuSU5GRVJFTkNFJTNBJTIwTGF5ZXJSZXBvc2l0b3J5KCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJlcG9faWQlM0QlMjJrZXJuZWxzLWNvbW11bml0eSUyRmFjdGl2YXRpb24taW5mZXJlbmNlLW9wdGltaXplZCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxheWVyX25hbWUlM0QlMjJTaWx1QW5kTXVsJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyME1vZGUuVFJBSU5JTkclM0ElMjBMYXllclJlcG9zaXRvcnkoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmVwb19pZCUzRCUyMmtlcm5lbHMtY29tbXVuaXR5JTJGYWN0aXZhdGlvbi10cmFpbmluZy1vcHRpbWl6ZWQlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsYXllcl9uYW1lJTNEJTIyU2lsdUFuZE11bCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlMjAlMjAlN0QlMEElN0Q=",highlighted:`kernel_layer_mapping = {
    <span class="hljs-string">&quot;SiluAndMul&quot;</span>: {
        <span class="hljs-string">&quot;cuda&quot;</span>: {
            Mode.FALLBACK: LayerRepository(
                repo_id=<span class="hljs-string">&quot;kernels-community/activation&quot;</span>,
                layer_name=<span class="hljs-string">&quot;SiluAndMul&quot;</span>,
            ),
            Mode.INFERENCE: LayerRepository(
                repo_id=<span class="hljs-string">&quot;kernels-community/activation-inference-optimized&quot;</span>,
                layer_name=<span class="hljs-string">&quot;SiluAndMul&quot;</span>,
            ),
            Mode.TRAINING: LayerRepository(
                repo_id=<span class="hljs-string">&quot;kernels-community/activation-training-optimized&quot;</span>,
                layer_name=<span class="hljs-string">&quot;SiluAndMul&quot;</span>,
            ),
        }
    }
}`,wrap:!1}}),ye=new m({props:{title:"Registering kernels for specific CUDA capabilities",local:"registering-kernels-for-specific-cuda-capabilities",headingTag:"h3"}}),de=new c({props:{code:"a2VybmVsX2xheWVyX21hcHBpbmclMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjJTaWx1QW5kTXVsJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwRGV2aWNlKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHR5cGUlM0QlMjJjdWRhJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJvcGVydGllcyUzRENVREFQcm9wZXJ0aWVzKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG1pbl9jYXBhYmlsaXR5JTNENzUlMkMlMjBtYXhfY2FwYWJpbGl0eSUzRDg5JTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCklM0ElMjBMYXllclJlcG9zaXRvcnkoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmVwb19pZCUzRCUyMmtlcm5lbHMtY29tbXVuaXR5JTJGYWN0aXZhdGlvbiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxheWVyX25hbWUlM0QlMjJTaWx1QW5kTXVsJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMERldmljZSglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB0eXBlJTNEJTIyY3VkYSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHByb3BlcnRpZXMlM0RDVURBUHJvcGVydGllcyglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtaW5fY2FwYWJpbGl0eSUzRDkwJTJDJTIwbWF4X2NhcGFiaWxpdHklM0RzeXMubWF4c2l6ZSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTNBJTIwTGF5ZXJSZXBvc2l0b3J5KCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJlcG9faWQlM0QlMjJrZXJuZWxzLWNvbW11bml0eSUyRmFjdGl2YXRpb24taG9wcGVyJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbGF5ZXJfbmFtZSUzRCUyMlNpbHVBbmRNdWwlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTJDJTBBJTIwJTIwJTIwJTIwJTdEJTBBJTdE",highlighted:`kernel_layer_mapping = {
    <span class="hljs-string">&quot;SiluAndMul&quot;</span>: {
        Device(
            <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;cuda&quot;</span>,
            properties=CUDAProperties(
                min_capability=<span class="hljs-number">75</span>, max_capability=<span class="hljs-number">89</span>
            ),
        ): LayerRepository(
            repo_id=<span class="hljs-string">&quot;kernels-community/activation&quot;</span>,
            layer_name=<span class="hljs-string">&quot;SiluAndMul&quot;</span>,
        ),
        Device(
            <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;cuda&quot;</span>,
            properties=CUDAProperties(
                min_capability=<span class="hljs-number">90</span>, max_capability=sys.maxsize
            ),
        ): LayerRepository(
            repo_id=<span class="hljs-string">&quot;kernels-community/activation-hopper&quot;</span>,
            layer_name=<span class="hljs-string">&quot;SiluAndMul&quot;</span>,
        ),
    }
}`,wrap:!1}}),ce=new tt({props:{source:"https://github.com/huggingface/kernels/blob/main/docs/source/layers.md"}}),{c(){w=M("meta"),Ce=n(),me=M("p"),Je=n(),o(C.$$.fragment),ue=n(),J=M("p"),J.innerHTML=ul,Ie=n(),u=M("p"),u.innerHTML=Il,fe=n(),o(I.$$.fragment),he=n(),o(f.$$.fragment),je=n(),h=M("p"),h.innerHTML=fl,be=n(),o(j.$$.fragment),ke=n(),b=M("p"),b.innerHTML=hl,Ae=n(),o(k.$$.fragment),ge=n(),A=M("p"),A.innerHTML=jl,$e=n(),o(g.$$.fragment),Ee=n(),$=M("p"),$.innerHTML=bl,Re=n(),o(E.$$.fragment),ve=n(),R=M("p"),R.innerHTML=kl,Ne=n(),o(v.$$.fragment),_e=n(),N=M("p"),N.innerHTML=Al,Be=n(),o(_.$$.fragment),Ge=n(),B=M("p"),B.innerHTML=gl,He=n(),G=M("p"),G.innerHTML=$l,Le=n(),o(H.$$.fragment),We=n(),L=M("p"),L.innerHTML=El,xe=n(),o(W.$$.fragment),Se=n(),x=M("p"),x.innerHTML=Rl,Ze=n(),o(S.$$.fragment),Ve=n(),o(Z.$$.fragment),Qe=n(),V=M("p"),V.innerHTML=vl,Xe=n(),o(Q.$$.fragment),ze=n(),X=M("p"),X.textContent=Nl,Fe=n(),o(z.$$.fragment),qe=n(),F=M("p"),F.innerHTML=_l,Pe=n(),o(q.$$.fragment),Ye=n(),P=M("p"),P.innerHTML=Bl,Oe=n(),o(Y.$$.fragment),Ke=n(),O=M("p"),O.innerHTML=Gl,De=n(),o(K.$$.fragment),el=n(),D=M("p"),D.innerHTML=Hl,ll=n(),o(ee.$$.fragment),tl=n(),le=M("p"),le.innerHTML=Ll,il=n(),o(te.$$.fragment),nl=n(),ie=M("p"),ie.textContent=Wl,sl=n(),o(ne.$$.fragment),Ml=n(),se=M("p"),se.innerHTML=xl,al=n(),Me=M("ul"),Me.innerHTML=Sl,rl=n(),ae=M("p"),ae.innerHTML=Zl,ol=n(),o(re.$$.fragment),yl=n(),oe=M("p"),oe.innerHTML=Vl,pl=n(),o(ye.$$.fragment),dl=n(),pe=M("p"),pe.innerHTML=Ql,Tl=n(),o(de.$$.fragment),Ul=n(),Te=M("p"),Te.textContent=Xl,cl=n(),Ue=M("ul"),Ue.innerHTML=zl,ml=n(),o(ce.$$.fragment),wl=n(),we=M("p"),this.h()},l(e){const l=et("svelte-u9bgzb",document.head);w=a(l,"META",{name:!0,content:!0}),l.forEach(t),Ce=s(e),me=a(e,"P",{}),Fl(me).forEach(t),Je=s(e),y(C.$$.fragment,e),ue=s(e),J=a(e,"P",{"data-svelte-h":!0}),r(J)!=="svelte-178x673"&&(J.innerHTML=ul),Ie=s(e),u=a(e,"P",{"data-svelte-h":!0}),r(u)!=="svelte-v68zn9"&&(u.innerHTML=Il),fe=s(e),y(I.$$.fragment,e),he=s(e),y(f.$$.fragment,e),je=s(e),h=a(e,"P",{"data-svelte-h":!0}),r(h)!=="svelte-1jd41lf"&&(h.innerHTML=fl),be=s(e),y(j.$$.fragment,e),ke=s(e),b=a(e,"P",{"data-svelte-h":!0}),r(b)!=="svelte-tily1x"&&(b.innerHTML=hl),Ae=s(e),y(k.$$.fragment,e),ge=s(e),A=a(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-1hj9ahw"&&(A.innerHTML=jl),$e=s(e),y(g.$$.fragment,e),Ee=s(e),$=a(e,"P",{"data-svelte-h":!0}),r($)!=="svelte-13coke1"&&($.innerHTML=bl),Re=s(e),y(E.$$.fragment,e),ve=s(e),R=a(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-stkx9y"&&(R.innerHTML=kl),Ne=s(e),y(v.$$.fragment,e),_e=s(e),N=a(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-1mdicvi"&&(N.innerHTML=Al),Be=s(e),y(_.$$.fragment,e),Ge=s(e),B=a(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-xhc5xj"&&(B.innerHTML=gl),He=s(e),G=a(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-195gdzl"&&(G.innerHTML=$l),Le=s(e),y(H.$$.fragment,e),We=s(e),L=a(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-1pcqrau"&&(L.innerHTML=El),xe=s(e),y(W.$$.fragment,e),Se=s(e),x=a(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-808tau"&&(x.innerHTML=Rl),Ze=s(e),y(S.$$.fragment,e),Ve=s(e),y(Z.$$.fragment,e),Qe=s(e),V=a(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-yu926d"&&(V.innerHTML=vl),Xe=s(e),y(Q.$$.fragment,e),ze=s(e),X=a(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-1lkusth"&&(X.textContent=Nl),Fe=s(e),y(z.$$.fragment,e),qe=s(e),F=a(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-161p6z8"&&(F.innerHTML=_l),Pe=s(e),y(q.$$.fragment,e),Ye=s(e),P=a(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-1r5il31"&&(P.innerHTML=Bl),Oe=s(e),y(Y.$$.fragment,e),Ke=s(e),O=a(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-1mzc83p"&&(O.innerHTML=Gl),De=s(e),y(K.$$.fragment,e),el=s(e),D=a(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-p5ro9n"&&(D.innerHTML=Hl),ll=s(e),y(ee.$$.fragment,e),tl=s(e),le=a(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-z3xuuf"&&(le.innerHTML=Ll),il=s(e),y(te.$$.fragment,e),nl=s(e),ie=a(e,"P",{"data-svelte-h":!0}),r(ie)!=="svelte-1ed3b6y"&&(ie.textContent=Wl),sl=s(e),y(ne.$$.fragment,e),Ml=s(e),se=a(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-sek2d8"&&(se.innerHTML=xl),al=s(e),Me=a(e,"UL",{"data-svelte-h":!0}),r(Me)!=="svelte-ewhtf4"&&(Me.innerHTML=Sl),rl=s(e),ae=a(e,"P",{"data-svelte-h":!0}),r(ae)!=="svelte-m4furw"&&(ae.innerHTML=Zl),ol=s(e),y(re.$$.fragment,e),yl=s(e),oe=a(e,"P",{"data-svelte-h":!0}),r(oe)!=="svelte-1oi4pcx"&&(oe.innerHTML=Vl),pl=s(e),y(ye.$$.fragment,e),dl=s(e),pe=a(e,"P",{"data-svelte-h":!0}),r(pe)!=="svelte-1wl92tu"&&(pe.innerHTML=Ql),Tl=s(e),y(de.$$.fragment,e),Ul=s(e),Te=a(e,"P",{"data-svelte-h":!0}),r(Te)!=="svelte-1k7nbkd"&&(Te.textContent=Xl),cl=s(e),Ue=a(e,"UL",{"data-svelte-h":!0}),r(Ue)!=="svelte-xyngc6"&&(Ue.innerHTML=zl),ml=s(e),y(ce.$$.fragment,e),wl=s(e),we=a(e,"P",{}),Fl(we).forEach(t),this.h()},h(){ql(w,"name","hf:doc:metadata"),ql(w,"content",nt)},m(e,l){lt(document.head,w),i(e,Ce,l),i(e,me,l),i(e,Je,l),p(C,e,l),i(e,ue,l),i(e,J,l),i(e,Ie,l),i(e,u,l),i(e,fe,l),p(I,e,l),i(e,he,l),p(f,e,l),i(e,je,l),i(e,h,l),i(e,be,l),p(j,e,l),i(e,ke,l),i(e,b,l),i(e,Ae,l),p(k,e,l),i(e,ge,l),i(e,A,l),i(e,$e,l),p(g,e,l),i(e,Ee,l),i(e,$,l),i(e,Re,l),p(E,e,l),i(e,ve,l),i(e,R,l),i(e,Ne,l),p(v,e,l),i(e,_e,l),i(e,N,l),i(e,Be,l),p(_,e,l),i(e,Ge,l),i(e,B,l),i(e,He,l),i(e,G,l),i(e,Le,l),p(H,e,l),i(e,We,l),i(e,L,l),i(e,xe,l),p(W,e,l),i(e,Se,l),i(e,x,l),i(e,Ze,l),p(S,e,l),i(e,Ve,l),p(Z,e,l),i(e,Qe,l),i(e,V,l),i(e,Xe,l),p(Q,e,l),i(e,ze,l),i(e,X,l),i(e,Fe,l),p(z,e,l),i(e,qe,l),i(e,F,l),i(e,Pe,l),p(q,e,l),i(e,Ye,l),i(e,P,l),i(e,Oe,l),p(Y,e,l),i(e,Ke,l),i(e,O,l),i(e,De,l),p(K,e,l),i(e,el,l),i(e,D,l),i(e,ll,l),p(ee,e,l),i(e,tl,l),i(e,le,l),i(e,il,l),p(te,e,l),i(e,nl,l),i(e,ie,l),i(e,sl,l),p(ne,e,l),i(e,Ml,l),i(e,se,l),i(e,al,l),i(e,Me,l),i(e,rl,l),i(e,ae,l),i(e,ol,l),p(re,e,l),i(e,yl,l),i(e,oe,l),i(e,pl,l),p(ye,e,l),i(e,dl,l),i(e,pe,l),i(e,Tl,l),p(de,e,l),i(e,Ul,l),i(e,Te,l),i(e,cl,l),i(e,Ue,l),i(e,ml,l),p(ce,e,l),i(e,wl,l),i(e,we,l),Cl=!0},p:Yl,i(e){Cl||(d(C.$$.fragment,e),d(I.$$.fragment,e),d(f.$$.fragment,e),d(j.$$.fragment,e),d(k.$$.fragment,e),d(g.$$.fragment,e),d(E.$$.fragment,e),d(v.$$.fragment,e),d(_.$$.fragment,e),d(H.$$.fragment,e),d(W.$$.fragment,e),d(S.$$.fragment,e),d(Z.$$.fragment,e),d(Q.$$.fragment,e),d(z.$$.fragment,e),d(q.$$.fragment,e),d(Y.$$.fragment,e),d(K.$$.fragment,e),d(ee.$$.fragment,e),d(te.$$.fragment,e),d(ne.$$.fragment,e),d(re.$$.fragment,e),d(ye.$$.fragment,e),d(de.$$.fragment,e),d(ce.$$.fragment,e),Cl=!0)},o(e){T(C.$$.fragment,e),T(I.$$.fragment,e),T(f.$$.fragment,e),T(j.$$.fragment,e),T(k.$$.fragment,e),T(g.$$.fragment,e),T(E.$$.fragment,e),T(v.$$.fragment,e),T(_.$$.fragment,e),T(H.$$.fragment,e),T(W.$$.fragment,e),T(S.$$.fragment,e),T(Z.$$.fragment,e),T(Q.$$.fragment,e),T(z.$$.fragment,e),T(q.$$.fragment,e),T(Y.$$.fragment,e),T(K.$$.fragment,e),T(ee.$$.fragment,e),T(te.$$.fragment,e),T(ne.$$.fragment,e),T(re.$$.fragment,e),T(ye.$$.fragment,e),T(de.$$.fragment,e),T(ce.$$.fragment,e),Cl=!1},d(e){e&&(t(Ce),t(me),t(Je),t(ue),t(J),t(Ie),t(u),t(fe),t(he),t(je),t(h),t(be),t(ke),t(b),t(Ae),t(ge),t(A),t($e),t(Ee),t($),t(Re),t(ve),t(R),t(Ne),t(_e),t(N),t(Be),t(Ge),t(B),t(He),t(G),t(Le),t(We),t(L),t(xe),t(Se),t(x),t(Ze),t(Ve),t(Qe),t(V),t(Xe),t(ze),t(X),t(Fe),t(qe),t(F),t(Pe),t(Ye),t(P),t(Oe),t(Ke),t(O),t(De),t(el),t(D),t(ll),t(tl),t(le),t(il),t(nl),t(ie),t(sl),t(Ml),t(se),t(al),t(Me),t(rl),t(ae),t(ol),t(yl),t(oe),t(pl),t(dl),t(pe),t(Tl),t(Ul),t(Te),t(cl),t(Ue),t(ml),t(wl),t(we)),t(w),U(C,e),U(I,e),U(f,e),U(j,e),U(k,e),U(g,e),U(E,e),U(v,e),U(_,e),U(H,e),U(W,e),U(S,e),U(Z,e),U(Q,e),U(z,e),U(q,e),U(Y,e),U(K,e),U(ee,e),U(te,e),U(ne,e),U(re,e),U(ye,e),U(de,e),U(ce,e)}}}const nt='{"title":"Layers","local":"layers","sections":[{"title":"Making a layer extensible with kernels from the hub","local":"making-a-layer-extensible-with-kernels-from-the-hub","sections":[{"title":"Using a decorator","local":"using-a-decorator","sections":[],"depth":3},{"title":"External layers","local":"external-layers","sections":[],"depth":3}],"depth":2},{"title":"Kernelizing a model","local":"kernelizing-a-model","sections":[{"title":"Kernel device","local":"kernel-device","sections":[],"depth":3},{"title":"Fallback forward","local":"fallback-forward","sections":[],"depth":3},{"title":"Inspecting kernels which kernels are used","local":"inspecting-kernels-which-kernels-are-used","sections":[],"depth":3}],"depth":2},{"title":"Registering a hub kernel for a layer","local":"registering-a-hub-kernel-for-a-layer","sections":[{"title":"Registering kernels for specific modes","local":"registering-kernels-for-specific-modes","sections":[],"depth":3},{"title":"Registering kernels for specific CUDA capabilities","local":"registering-kernels-for-specific-cuda-capabilities","sections":[],"depth":3}],"depth":2}],"depth":1}';function st(Jl){return Ol(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class yt extends Kl{constructor(w){super(),Dl(this,w,st,it,Pl,{})}}export{yt as component};
