import{s as Ti,o as Ui,n as A}from"../chunks/scheduler.25b97de1.js";import{S as wi,i as ji,g as o,s as a,r as M,A as fi,h as i,f as l,c as n,j as hi,u as c,x as p,k as Ji,y as Ii,a as s,v as y,d as u,t as m,w as d,m as gi,n as bi}from"../chunks/index.d9030fc9.js";import{T as x}from"../chunks/Tip.baa67368.js";import{C as J}from"../chunks/CodeBlock.e6cd0d95.js";import{H as I,E as Ci}from"../chunks/EditOnGithub.91d95064.js";function Gi(b){let r,U=`The default behaviour of <code>TextGenerationPipeline</code> is to set <code>add_generation_prompt=True</code> so that it starts a new
message. However, if the final message in the input chat has the “assistant” role, it will assume that this message is
a prefill and switch to <code>continue_final_message=True</code> instead, because most models do not support multiple
consecutive assistant messages. You can override this behaviour by explicitly passing the <code>continue_final_message</code>
argument when calling the pipeline.`;return{c(){r=o("p"),r.innerHTML=U},l(h){r=i(h,"P",{"data-svelte-h":!0}),p(r)!=="svelte-95bbxf"&&(r.innerHTML=U)},m(h,T){s(h,r,T)},p:A,d(h){h&&l(r)}}}function $i(b){let r,U=`By default, some tokenizers add special tokens like <code>&lt;bos&gt;</code> and <code>&lt;eos&gt;</code> to text they tokenize. Chat templates should
already include all the special tokens they need, and so additional special tokens will often be incorrect or
duplicated, which will hurt model performance.`,h,T,C=`Therefore, if you format text with <code>apply_chat_template(tokenize=False)</code>, you should set the argument
<code>add_special_tokens=False</code> when you tokenize that text later. If you use <code>apply_chat_template(tokenize=True)</code>, you don’t need to worry about this!`;return{c(){r=o("p"),r.innerHTML=U,h=a(),T=o("p"),T.innerHTML=C},l(f){r=i(f,"P",{"data-svelte-h":!0}),p(r)!=="svelte-148xjo3"&&(r.innerHTML=U),h=n(f),T=i(f,"P",{"data-svelte-h":!0}),p(T)!=="svelte-1hgzema"&&(T.innerHTML=C)},m(f,g){s(f,r,g),s(f,h,g),s(f,T,g)},p:A,d(f){f&&(l(r),l(h),l(T))}}}function Bi(b){let r,U=`The output format above is specific to the <code>Hermes-2-Pro</code> model we’re using in this example. Other models may emit different
tool call formats, and you may need to do some manual parsing at this step. For example, <code>Llama-3.1</code> models will emit
slightly different JSON, with <code>parameters</code> instead of <code>arguments</code>. Regardless of the format the model outputs, you
should add the tool call to the conversation in the format below, with <code>tool_calls</code>, <code>function</code> and <code>arguments</code> keys.`;return{c(){r=o("p"),r.innerHTML=U},l(h){r=i(h,"P",{"data-svelte-h":!0}),p(r)!=="svelte-1wfdwuk"&&(r.innerHTML=U)},m(h,T){s(h,r,T)},p:A,d(h){h&&l(r)}}}function xi(b){let r,U=`If you’re familiar with the OpenAI API, you should pay attention to an important difference here - the <code>tool_call</code> is
a dict, but in the OpenAI API it’s a JSON string. Passing a string may cause errors or strange model behaviour!`;return{c(){r=o("p"),r.innerHTML=U},l(h){r=i(h,"P",{"data-svelte-h":!0}),p(r)!=="svelte-fq11ea"&&(r.innerHTML=U)},m(h,T){s(h,r,T)},p:A,d(h){h&&l(r)}}}function vi(b){let r,U=`Some model architectures, notably Mistral/Mixtral, also require a <code>tool_call_id</code> here, which should be
9 randomly-generated alphanumeric characters, and assigned to the <code>id</code> key of the tool call
dictionary. The same key should also be assigned to the <code>tool_call_id</code> key of the tool response dictionary below, so
that tool calls can be matched to tool responses. So, for Mistral/Mixtral models, the code above would be:`,h,T,C,f,g="and",B,j,$;return T=new J({props:{code:"dG9vbF9jYWxsX2lkJTIwJTNEJTIwJTIyOUFlM2JEYzJGJTIyJTIwJTIwJTIzJTIwUmFuZG9tJTIwSUQlMkMlMjA5JTIwYWxwaGFudW1lcmljJTIwY2hhcmFjdGVycyUwQXRvb2xfY2FsbCUyMCUzRCUyMCU3QiUyMm5hbWUlMjIlM0ElMjAlMjJnZXRfY3VycmVudF90ZW1wZXJhdHVyZSUyMiUyQyUyMCUyMmFyZ3VtZW50cyUyMiUzQSUyMCU3QiUyMmxvY2F0aW9uJTIyJTNBJTIwJTIyUGFyaXMlMkMlMjBGcmFuY2UlMjIlMkMlMjAlMjJ1bml0JTIyJTNBJTIwJTIyY2Vsc2l1cyUyMiU3RCU3RCUwQW1lc3NhZ2VzLmFwcGVuZCglN0IlMjJyb2xlJTIyJTNBJTIwJTIyYXNzaXN0YW50JTIyJTJDJTIwJTIydG9vbF9jYWxscyUyMiUzQSUyMCU1QiU3QiUyMnR5cGUlMjIlM0ElMjAlMjJmdW5jdGlvbiUyMiUyQyUyMCUyMmlkJTIyJTNBJTIwdG9vbF9jYWxsX2lkJTJDJTIwJTIyZnVuY3Rpb24lMjIlM0ElMjB0b29sX2NhbGwlN0QlNUQlN0Qp",highlighted:`tool_call_id = <span class="hljs-string">&quot;9Ae3bDc2F&quot;</span>  <span class="hljs-comment"># Random ID, 9 alphanumeric characters</span>
tool_call = {<span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;get_current_temperature&quot;</span>, <span class="hljs-string">&quot;arguments&quot;</span>: {<span class="hljs-string">&quot;location&quot;</span>: <span class="hljs-string">&quot;Paris, France&quot;</span>, <span class="hljs-string">&quot;unit&quot;</span>: <span class="hljs-string">&quot;celsius&quot;</span>}}
messages.append({<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;tool_calls&quot;</span>: [{<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;function&quot;</span>, <span class="hljs-string">&quot;id&quot;</span>: tool_call_id, <span class="hljs-string">&quot;function&quot;</span>: tool_call}]})`,wrap:!1}}),j=new J({props:{code:"bWVzc2FnZXMuYXBwZW5kKCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJ0b29sJTIyJTJDJTIwJTIydG9vbF9jYWxsX2lkJTIyJTNBJTIwdG9vbF9jYWxsX2lkJTJDJTIwJTIybmFtZSUyMiUzQSUyMCUyMmdldF9jdXJyZW50X3RlbXBlcmF0dXJlJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMjIyLjAlMjIlN0Qp",highlighted:'messages.append({<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;tool&quot;</span>, <span class="hljs-string">&quot;tool_call_id&quot;</span>: tool_call_id, <span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;get_current_temperature&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;22.0&quot;</span>})',wrap:!1}}),{c(){r=o("p"),r.innerHTML=U,h=a(),M(T.$$.fragment),C=a(),f=o("p"),f.textContent=g,B=a(),M(j.$$.fragment)},l(w){r=i(w,"P",{"data-svelte-h":!0}),p(r)!=="svelte-70hqps"&&(r.innerHTML=U),h=n(w),c(T.$$.fragment,w),C=n(w),f=i(w,"P",{"data-svelte-h":!0}),p(f)!=="svelte-1qlona5"&&(f.textContent=g),B=n(w),c(j.$$.fragment,w)},m(w,G){s(w,r,G),s(w,h,G),y(T,w,G),s(w,C,G),s(w,f,G),s(w,B,G),y(j,w,G),$=!0},p:A,i(w){$||(u(T.$$.fragment,w),u(j.$$.fragment,w),$=!0)},o(w){m(T.$$.fragment,w),m(j.$$.fragment,w),$=!1},d(w){w&&(l(r),l(h),l(C),l(f),l(B)),d(T,w),d(j,w)}}}function Zi(b){let r,U="The <code>documents</code> input for retrieval-augmented generation is not widely supported, and many models have chat templates which simply ignore this input.",h,T,C="To verify if a model supports the <code>documents</code> input, you can read its model card, or <code>print(tokenizer.chat_template)</code> to see if the <code>documents</code> key is used anywhere.",f,g,B='One model class that does support it, though, is Cohere’s <a href="https://huggingface.co/CohereForAI/c4ai-command-r-08-2024" rel="nofollow">Command-R</a> and <a href="https://huggingface.co/CohereForAI/c4ai-command-r-plus-08-2024" rel="nofollow">Command-R+</a>, through their <code>rag</code> chat template. You can see additional examples of grounded generation using this feature in their model cards.';return{c(){r=o("p"),r.innerHTML=U,h=a(),T=o("p"),T.innerHTML=C,f=a(),g=o("p"),g.innerHTML=B},l(j){r=i(j,"P",{"data-svelte-h":!0}),p(r)!=="svelte-bl710l"&&(r.innerHTML=U),h=n(j),T=i(j,"P",{"data-svelte-h":!0}),p(T)!=="svelte-qpz2lz"&&(T.innerHTML=C),f=n(j),g=i(j,"P",{"data-svelte-h":!0}),p(g)!=="svelte-kg7zp3"&&(g.innerHTML=B)},m(j,$){s(j,r,$),s(j,h,$),s(j,T,$),s(j,f,$),s(j,g,$)},p:A,d(j){j&&(l(r),l(h),l(T),l(f),l(g))}}}function ki(b){let r;return{c(){r=gi(`If you're fine-tuning a model for chat, in addition to setting a chat template, you should probably add any new chat
control tokens as special tokens in the tokenizer. Special tokens are never split, 
ensuring that your control tokens are always handled as single tokens rather than being tokenized in pieces. You 
should also set the tokenizer's \`eos_token\` attribute to the token that marks the end of assistant generations in your
template. This will ensure that text generation tools can correctly figure out when to stop generating text.`)},l(U){r=bi(U,`If you're fine-tuning a model for chat, in addition to setting a chat template, you should probably add any new chat
control tokens as special tokens in the tokenizer. Special tokens are never split, 
ensuring that your control tokens are always handled as single tokens rather than being tokenized in pieces. You 
should also set the tokenizer's \`eos_token\` attribute to the token that marks the end of assistant generations in your
template. This will ensure that text generation tools can correctly figure out when to stop generating text.`)},m(U,h){s(U,r,h)},d(U){U&&l(r)}}}function Ni(b){let r,U=`The easiest way to get started with writing Jinja templates is to take a look at some existing ones. You can use
<code>print(tokenizer.chat_template)</code> for any chat model to see what template it’s using. In general, models that support tool use have
much more complex templates than other models - so when you’re just getting started, they’re probably a bad example
to learn from! You can also take a look at the
<a href="https://jinja.palletsprojects.com/en/3.1.x/templates/#synopsis" rel="nofollow">Jinja documentation</a> for details
of general Jinja formatting and syntax.`;return{c(){r=o("p"),r.innerHTML=U},l(h){r=i(h,"P",{"data-svelte-h":!0}),p(r)!=="svelte-qy60pj"&&(r.innerHTML=U)},m(h,T){s(h,r,T)},p:A,d(h){h&&l(r)}}}function Wi(b){let r,U=`You can actually pass any <code>kwarg</code> to <code>apply_chat_template</code>, and it will be accessible inside the template as a variable. In general,
we recommend trying to stick to the core variables above, as it will make your model harder to use if users have
to write custom code to pass model-specific <code>kwargs</code>. However, we’re aware that this field moves quickly, so if you
have a new use-case that doesn’t fit in the core API, feel free to use a new <code>kwarg</code> for it! If a new <code>kwarg</code>
becomes common we may promote it into the core API and create a standard, documented format for it.`;return{c(){r=o("p"),r.innerHTML=U},l(h){r=i(h,"P",{"data-svelte-h":!0}),p(r)!=="svelte-cvlh0x"&&(r.innerHTML=U)},m(h,T){s(h,r,T)},p:A,d(h){h&&l(r)}}}function Qi(b){let r,U,h,T,C,f,g,B,j,$=`An increasingly common use case for LLMs is <strong>chat</strong>. In a chat context, rather than continuing a single string
of text (as is the case with a standard language model), the model instead continues a conversation that consists
of one or more <strong>messages</strong>, each of which includes a <strong>role</strong>, like “user” or “assistant”, as well as message text.`,w,G,$n=`Much like tokenization, different models expect very different input formats for chat. This is the reason we added
<strong>chat templates</strong> as a feature. Chat templates are part of the tokenizer. They specify how to convert conversations,
represented as lists of messages, into a single tokenizable string in the format that the model expects.`,Bl,z,Bn="Let’s make this concrete with a quick example using the <code>mistralai/Mistral-7B-Instruct-v0.1</code> model:",xl,R,vl,S,xn=`Notice how the tokenizer has added the control tokens [INST] and [/INST] to indicate the start and end of
user messages (but not assistant messages!), and the entire chat is condensed into a single string.
If we use <code>tokenize=True</code>, which is the default setting, that string will also be tokenized for us.`,Zl,X,vn="Now, try the same code, but swap in the <code>HuggingFaceH4/zephyr-7b-beta</code> model instead, and you should get:",kl,E,Nl,H,Zn=`Both Zephyr and Mistral-Instruct were fine-tuned from the same base model, <code>Mistral-7B-v0.1</code>. However, they were trained
with totally different chat formats. Without chat templates, you would have to write manual formatting code for each
model, and it’s very easy to make minor errors that hurt performance! Chat templates handle the details of formatting
for you, allowing you to write universal code that works for any model.`,Wl,Y,Ql,F,kn=`As you can see in the example above, chat templates are easy to use. Simply build a list of messages, with <code>role</code>
and <code>content</code> keys, and then pass it to the <a href="/docs/transformers/pr_30950/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.apply_chat_template">apply_chat_template()</a> method. Once you do that,
you’ll get output that’s ready to go! When using chat templates as input for model generation, it’s also a good idea
to use <code>add_generation_prompt=True</code> to add a <a href="#what-are-generation-prompts">generation prompt</a>.`,ql,L,Nn="Here’s an example of preparing input for <code>model.generate()</code>, using <code>Zephyr</code> again:",Vl,P,_l,D,Wn="This will yield a string in the input format that Zephyr expects.",Al,K,zl,O,Qn="Now that our input is formatted correctly for Zephyr, we can use the model to generate a response to the user’s question:",Rl,tt,Sl,et,qn="This will yield:",Xl,lt,El,st,Vn="Arr, ‘twas easy after all!",Hl,at,Yl,nt,_n=`Yes, there is! Our text generation pipelines support chat inputs, which makes it easy to use chat models. In the past,
we used to use a dedicated “ConversationalPipeline” class, but this has now been deprecated and its functionality
has been merged into the <a href="/docs/transformers/pr_30950/en/main_classes/pipelines#transformers.TextGenerationPipeline">TextGenerationPipeline</a>. Let’s try the <code>Zephyr</code> example again, but this time using
a pipeline:`,Fl,ot,Ll,it,Pl,pt,An=`The pipeline will take care of all the details of tokenization and calling <code>apply_chat_template</code> for you -
once the model has a chat template, all you need to do is initialize the pipeline and pass it the list of messages!`,Dl,rt,Kl,Mt,zn=`You may have noticed that the <code>apply_chat_template</code> method has an <code>add_generation_prompt</code> argument. This argument tells
the template to add tokens that indicate the start of a bot response. For example, consider the following chat:`,Ol,ct,ts,yt,Rn="Here’s what this will look like without a generation prompt, for a model that uses standard “ChatML” formatting:",es,ut,ls,mt,Sn="And here’s what it looks like <strong>with</strong> a generation prompt:",ss,dt,as,ht,Xn=`Note that this time, we’ve added the tokens that indicate the start of a bot response. This ensures that when the model
generates text it will write a bot response instead of doing something unexpected, like continuing the user’s
message. Remember, chat models are still just language models - they’re trained to continue text, and chat is just a
special kind of text to them! You need to guide them with appropriate control tokens, so they know what they’re
supposed to be doing.`,ns,Jt,En=`Not all models require generation prompts. Some models, like LLaMA, don’t have any
special tokens before bot responses. In these cases, the <code>add_generation_prompt</code> argument will have no effect. The exact
effect that <code>add_generation_prompt</code> has will depend on the template being used.`,os,Tt,is,Ut,Hn=`When passing a list of messages to <code>apply_chat_template</code> or <code>TextGenerationPipeline</code>, you can choose
to format the chat so the model will continue the final message in the chat instead of starting a new one. This is done
by removing any end-of-sequence tokens that indicate the end of the final message, so that the model will simply
extend the final message when it begins to generate text. This is useful for “prefilling” the model’s response.`,ps,wt,Yn="Here’s an example:",rs,jt,Ms,ft,Fn=`The model will generate text that continues the JSON string, rather than starting a new message. This approach
can be very useful for improving the accuracy of the model’s instruction-following when you know how you want
it to start its replies.`,cs,It,Ln=`Because <code>add_generation_prompt</code> adds the tokens that start a new message, and <code>continue_final_message</code> removes any
end-of-message tokens from the final message, it does not make sense to use them together. As a result, you’ll
get an error if you try!`,ys,v,us,gt,ms,bt,Pn=`Yes! This is a good way to ensure that the chat template matches the tokens the model sees during training.
We recommend that you apply the chat template as a preprocessing step for your dataset. After this, you
can simply continue like any other language model training task. When training, you should usually set
<code>add_generation_prompt=False</code>, because the added tokens to prompt an assistant response will not be helpful during
training. Let’s see an example:`,ds,Ct,hs,Gt,Dn="And we get:",Js,$t,Ts,Bt,Kn="From here, just continue training like you would with a standard language modelling task, using the <code>formatted_chat</code> column.",Us,Z,ws,xt,js,vt,On=`The only argument that <code>apply_chat_template</code> requires is <code>messages</code>. However, you can pass any keyword
argument to <code>apply_chat_template</code> and it will be accessible inside the template. This gives you a lot of freedom to use
chat templates for many things. There are no restrictions on the names or the format of these arguments - you can pass
strings, lists, dicts or whatever else you want.`,fs,Zt,to=`That said, there are some common use-cases for these extra arguments,
such as passing tools for function calling, or documents for retrieval-augmented generation. In these common cases,
we have some opinionated recommendations about what the names and formats of these arguments should be, which are
described in the sections below. We encourage model authors to make their chat templates compatible with this format,
to make it easy to transfer tool-calling code between models.`,Is,kt,gs,Nt,eo=`“Tool use” LLMs can choose to call functions as external tools before generating an answer. When passing tools
to a tool-use model, you can simply pass a list of functions to the <code>tools</code> argument:`,bs,Wt,Cs,Qt,lo=`In order for this to work correctly, you should write your functions in the format above, so that they can be parsed
correctly as tools. Specifically, you should follow these rules:`,Gs,qt,so=`<li>The function should have a descriptive name</li> <li>Every argument must have a type hint</li> <li>The function must have a docstring in the standard Google style (in other words, an initial function description<br/>
followed by an <code>Args:</code> block that describes the arguments, unless the function does not have any arguments.</li> <li>Do not include types in the <code>Args:</code> block. In other words, write <code>a: The first number to multiply</code>, not
<code>a (int): The first number to multiply</code>. Type hints should go in the function header instead.</li> <li>The function can have a return type and a <code>Returns:</code> block in the docstring. However, these are optional
because most tool-use models ignore them.</li>`,$s,Vt,Bs,_t,ao=`The sample code above is enough to list the available tools for your model, but what happens if it wants to actually use
one? If that happens, you should:`,xs,At,no="<li>Parse the model’s output to get the tool name(s) and arguments.</li> <li>Add the model’s tool call(s) to the conversation.</li> <li>Call the corresponding function(s) with those arguments.</li> <li>Add the result(s) to the conversation</li>",vs,zt,Zs,Rt,oo=`Let’s walk through a tool use example, step by step. For this example, we will use an 8B <code>Hermes-2-Pro</code> model,
as it is one of the highest-performing tool-use models in its size category at the time of writing. If you have the
memory, you can consider using a larger model instead like <a href="https://huggingface.co/CohereForAI/c4ai-command-r-v01" rel="nofollow">Command-R</a>
or <a href="https://huggingface.co/mistralai/Mixtral-8x22B-Instruct-v0.1" rel="nofollow">Mixtral-8x22B</a>, both of which also support tool use
and offer even stronger performance.`,ks,St,io="First, let’s load our model and tokenizer:",Ns,Xt,Ws,Et,po="Next, let’s define a list of tools:",Qs,Ht,qs,Yt,ro="Now, let’s set up a conversation for our bot:",Vs,Ft,_s,Lt,Mo="Now, let’s apply the chat template and generate a response:",As,Pt,zs,Dt,co="And we get:",Rs,Kt,Ss,Ot,yo=`The model has called the function with valid arguments, in the format requested by the function docstring. It has
inferred that we’re most likely referring to the Paris in France, and it remembered that, as the home of SI units,
the temperature in France should certainly be displayed in Celsius.`,Xs,k,Es,te,uo="Next, let’s append the model’s tool call to the conversation.",Hs,ee,Ys,N,Fs,le,mo=`Now that we’ve added the tool call to the conversation, we can call the function and append the result to the
conversation. Since we’re just using a dummy function for this example that always returns 22.0, we can just append
that result directly.`,Ls,se,Ps,W,Ds,ae,ho="Finally, let’s let the assistant read the function outputs and continue chatting with the user:",Ks,ne,Os,oe,Jo="And we get:",ta,ie,ea,pe,To=`Although this was a simple demo with dummy tools and a single call, the same technique works with
multiple real tools and longer conversations. This can be a powerful way to extend the capabilities of conversational
agents with real-time information, computational tools like calculators, or access to large databases.`,la,re,sa,Me,Uo=`Each function you pass to the <code>tools</code> argument of <code>apply_chat_template</code> is converted into a
<a href="https://json-schema.org/learn/getting-started-step-by-step" rel="nofollow">JSON schema</a>. These schemas
are then passed to the model chat template. In other words, tool-use models do not see your functions directly, and they
never see the actual code inside them. What they care about is the function <strong>definitions</strong> and the <strong>arguments</strong> they
need to pass to them - they care about what the tools do and how to use them, not how they work! It is up to you
to read their outputs, detect if they have requested to use a tool, pass their arguments to the tool function, and
return the response in the chat.`,aa,ce,wo=`Generating JSON schemas to pass to the template should be automatic and invisible as long as your functions
follow the specification above, but if you encounter problems, or you simply want more control over the conversion,
you can handle the conversion manually. Here is an example of a manual schema conversion.`,na,ye,oa,ue,jo="This will yield:",ia,me,pa,de,fo=`If you wish, you can edit these schemas, or even write them from scratch yourself without using <code>get_json_schema</code> at
all. JSON schemas can be passed directly to the <code>tools</code> argument of
<code>apply_chat_template</code> - this gives you a lot of power to define precise schemas for more complex functions. Be careful,
though - the more complex your schemas, the more likely the model is to get confused when dealing with them! We
recommend simple function signatures where possible, keeping arguments (and especially complex, nested arguments)
to a minimum.`,ra,he,Io="Here is an example of defining schemas by hand, and passing them directly to <code>apply_chat_template</code>:",Ma,Je,ca,Te,ya,Ue,go=`“Retrieval-augmented generation” or “RAG” LLMs can search a corpus of documents for information before responding
to a query. This allows models to vastly expand their knowledge base beyond their limited context size. Our
recommendation for RAG models is that their template
should accept a <code>documents</code> argument. This should be a list of documents, where each “document”
is a single dict with <code>title</code> and <code>contents</code> keys, both of which are strings. Because this format is much simpler
than the JSON schemas used for tools, no helper functions are necessary.`,ua,we,bo="Here’s an example of a RAG template in action:",ma,je,da,Q,ha,fe,Ja,Ie,Co=`The chat template for a model is stored on the <code>tokenizer.chat_template</code> attribute. If no chat template is set, the
default template for that model class is used instead. Let’s take a look at a <code>Zephyr</code> chat template, though note this
one is a little simplified from the actual one!`,Ta,ge,Ua,be,Go=`If you’ve never seen one of these before, this is a <a href="https://jinja.palletsprojects.com/en/3.1.x/templates/" rel="nofollow">Jinja template</a>.
Jinja is a templating language that allows you to write simple code that generates text. In many ways, the code and
syntax resembles Python. In pure Python, this template would look something like this:`,wa,Ce,ja,Ge,$o="Effectively, the template does three things:",fa,$e,Bo=`<li>For each message, print the role enclosed in <code>&lt;|</code> and <code>|&gt;</code>, like <code>&lt;|user|&gt;</code> or <code>&lt;|assistant|&gt;</code>.</li> <li>Next, print the content of the message, followed by the end-of-sequence token.</li> <li>Finally, if <code>add_generation_prompt</code> is set, print the assistant token, so that the model knows to start generating
an assistant response.</li>`,Ia,Be,xo=`This is a pretty simple template but Jinja gives you a lot of flexibility to do more complex things! Let’s see a Jinja
template that can format inputs similarly to the way LLaMA formats them (note that the real LLaMA template includes
handling for default system messages and slightly different system message handling in general - don’t use this one
in your actual code!)`,ga,xe,ba,ve,vo=`Hopefully if you stare at this for a little bit you can see what this template is doing - it adds specific tokens like
<code>[INST]</code> and <code>[/INST]</code> based on the role of each message. User, assistant and system messages are clearly
distinguishable to the model because of the tokens they’re wrapped in.`,Ca,Ze,Ga,ke,$a,Ne,Zo=`Simple, just write a jinja template and set <code>tokenizer.chat_template</code>. You may find it easier to start with an
existing template from another model and simply edit it for your needs! For example, we could take the LLaMA template
above and add ”[ASST]” and ”[/ASST]” to assistant messages:`,Ba,We,xa,Qe,ko=`Now, simply set the <code>tokenizer.chat_template</code> attribute. Next time you use <a href="/docs/transformers/pr_30950/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.apply_chat_template">apply_chat_template()</a>, it will
use your new template! This attribute will be saved in the <code>tokenizer_config.json</code> file, so you can use
<a href="/docs/transformers/pr_30950/en/main_classes/model#transformers.utils.PushToHubMixin.push_to_hub">push_to_hub()</a> to upload your new template to the Hub and make sure everyone’s using the right
template for your model!`,va,qe,Za,Ve,No=`The method <a href="/docs/transformers/pr_30950/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.apply_chat_template">apply_chat_template()</a> which uses your chat template is called by the <a href="/docs/transformers/pr_30950/en/main_classes/pipelines#transformers.TextGenerationPipeline">TextGenerationPipeline</a> class, so
once you set the correct chat template, your model will automatically become compatible with <a href="/docs/transformers/pr_30950/en/main_classes/pipelines#transformers.TextGenerationPipeline">TextGenerationPipeline</a>.`,ka,q,Na,_e,Wa,Ae,Wo=`Some models use different templates for different use cases. For example, they might use one template for normal chat
and another for tool-use, or retrieval-augmented generation. In these cases, <code>tokenizer.chat_template</code> is a dictionary.
This can cause some confusion, and where possible, we recommend using a single template for all use-cases. You can use
Jinja statements like <code>if tools is defined</code> and <code>{% macro %}</code> definitions to easily wrap multiple code paths in a
single template.`,Qa,ze,Qo=`When a tokenizer has multiple templates, <code>tokenizer.chat_template</code> will be a <code>dict</code>, where each key is the name
of a template. The <code>apply_chat_template</code> method has special handling for certain template names: Specifically, it will
look for a template named <code>default</code> in most cases, and will raise an error if it can’t find one. However, if a template
named <code>tool_use</code> exists when the user has passed a <code>tools</code> argument, it will use that instead. To access templates
with other names, pass the name of the template you want to the <code>chat_template</code> argument of
<code>apply_chat_template()</code>.`,qa,Re,qo=`We find that this can be a bit confusing for users, though - so if you’re writing a template yourself, we recommend
trying to put it all in a single template where possible!`,Va,Se,_a,Xe,Vo=`When setting the template for a model that’s already been trained for chat, you should ensure that the template
exactly matches the message formatting that the model saw during training, or else you will probably experience
performance degradation. This is true even if you’re training the model further - you will probably get the best
performance if you keep the chat tokens constant. This is very analogous to tokenization - you generally get the
best performance for inference or fine-tuning when you precisely match the tokenization used during training.`,Aa,Ee,_o=`If you’re training a model from scratch, or fine-tuning a base language model for chat, on the other hand,
you have a lot of freedom to choose an appropriate template! LLMs are smart enough to learn to handle lots of different
input formats. One popular choice is the <code>ChatML</code> format, and this is a good, flexible choice for many use-cases.
It looks like this:`,za,He,Ra,Ye,Ao=`If you like this one, here it is in one-liner form, ready to copy into your code. The one-liner also includes
handy support for <a href="#what-are-generation-prompts">generation prompts</a>, but note that it doesn’t add BOS or EOS tokens!
If your model expects those, they won’t be added automatically by <code>apply_chat_template</code> - in other words, the
text will be tokenized with <code>add_special_tokens=False</code>. This is to avoid potential conflicts between the template and
the <code>add_special_tokens</code> logic. If your model expects special tokens, make sure to add them to the template!`,Sa,Fe,Xa,Le,zo=`This template wraps each message in <code>&lt;|im_start|&gt;</code> and <code>&lt;|im_end|&gt;</code> tokens, and simply writes the role as a string, which
allows for flexibility in the roles you train with. The output looks like this:`,Ea,Pe,Ha,De,Ro=`The “user”, “system” and “assistant” roles are the standard for chat, and we recommend using them when it makes sense,
particularly if you want your model to operate well with <a href="/docs/transformers/pr_30950/en/main_classes/pipelines#transformers.TextGenerationPipeline">TextGenerationPipeline</a>. However, you are not limited
to these roles - templating is extremely flexible, and any string can be a role.`,Ya,Ke,Fa,Oe,So=`If you have any chat models, you should set their <code>tokenizer.chat_template</code> attribute and test it using
<a href="/docs/transformers/pr_30950/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.apply_chat_template">apply_chat_template()</a>, then push the updated tokenizer to the Hub. This applies even if you’re
not the model owner - if you’re using a model with an empty chat template, or one that’s still using the default class
template, please open a <a href="https://huggingface.co/docs/hub/repositories-pull-requests-discussions" rel="nofollow">pull request</a> to the model repository so that this attribute can be set properly!`,La,tl,Xo=`Once the attribute is set, that’s it, you’re done! <code>tokenizer.apply_chat_template</code> will now work correctly for that
model, which means it is also automatically supported in places like <code>TextGenerationPipeline</code>!`,Pa,el,Eo=`By ensuring that models have this attribute, we can make sure that the whole community gets to use the full power of
open-source models. Formatting mismatches have been haunting the field and silently harming performance for too long -
it’s time to put an end to them!`,Da,ll,Ka,V,Oa,sl,Ho=`Jinja templates in <code>transformers</code> are identical to Jinja templates elsewhere. The main thing to know is that
the conversation history will be accessible inside your template as a variable called <code>messages</code>.<br/>
You will be able to access <code>messages</code> in your template just like you can in Python, which means you can loop over
it with <code>{% for message in messages %}</code> or access individual messages with <code>{{ messages[0] }}</code>, for example.`,tn,al,Yo="You can also use the following tips to write clean, efficient Jinja templates:",en,nl,ln,ol,Fo=`By default, Jinja will print any whitespace that comes before or after a block. This can be a problem for chat
templates, which generally want to be very precise with whitespace! To avoid this, we strongly recommend writing
your templates like this:`,sn,il,an,pl,Lo="rather than like this:",nn,rl,on,Ml,Po=`Adding <code>-</code> will strip any whitespace that comes before the block. The second example looks innocent, but the newline
and indentation may end up being included in the output, which is probably not what you want!`,pn,cl,rn,yl,Do=`Inside your template, you will have access several special variables. The most important of these is <code>messages</code>,
which contains the chat history as a list of message dicts. However, there are several others. Not every
variable will be used in every template. The most common other variables are:`,Mn,ul,Ko="<li><code>tools</code> contains a list of tools in JSON schema format. Will be <code>None</code> or undefined if no tools are passed.</li> <li><code>documents</code> contains a list of documents in the format <code>{&quot;title&quot;: &quot;Title&quot;, &quot;contents&quot;: &quot;Contents&quot;}</code>, used for retrieval-augmented generation. Will be <code>None</code> or undefined if no documents are passed.</li> <li><code>add_generation_prompt</code> is a bool that is <code>True</code> if the user has requested a generation prompt, and <code>False</code> otherwise. If this is set, your template should add the header for an assistant message to the end of the conversation. If your model doesn’t have a specific header for assistant messages, you can ignore this flag.</li> <li><strong>Special tokens</strong> like <code>bos_token</code> and <code>eos_token</code>. These are extracted from <code>tokenizer.special_tokens_map</code>. The exact tokens available inside each template will differ depending on the parent tokenizer.</li>",cn,_,yn,ml,un,dl,Oo="There is also a short list of callable functions available to you inside your templates. These are:",mn,hl,ti=`<li><code>raise_exception(msg)</code>: Raises a <code>TemplateException</code>. This is useful for debugging, and for telling users when they’re
doing something that your template doesn’t support.</li> <li><code>strftime_now(format_str)</code>: Equivalent to <code>datetime.now().strftime(format_str)</code> in Python. This is used for getting
the current date/time in a specific format, which is sometimes included in system messages.</li>`,dn,Jl,hn,Tl,ei=`There are multiple implementations of Jinja in various languages. They generally have the same syntax,
but a key difference is that when you’re writing a template in Python you can use Python methods, such as
<code>.lower()</code> on strings or <code>.items()</code> on dicts. This will break if someone tries to use your template on a non-Python
implementation of Jinja. Non-Python implementations are particularly common in deployment environments, where JS
and Rust are very popular.`,Jn,Ul,li=`Don’t panic, though! There are a few easy changes you can make to your templates to ensure they’re compatible across
all implementations of Jinja:`,Tn,wl,si=`<li>Replace Python methods with Jinja filters. These usually have the same name, for example <code>string.lower()</code> becomes
<code>string|lower</code>, and <code>dict.items()</code> becomes <code>dict|items</code>. One notable change is that <code>string.strip()</code> becomes <code>string|trim</code>.
See the <a href="https://jinja.palletsprojects.com/en/3.1.x/templates/#builtin-filters" rel="nofollow">list of built-in filters</a>
in the Jinja documentation for more.</li> <li>Replace <code>True</code>, <code>False</code> and <code>None</code>, which are Python-specific, with <code>true</code>, <code>false</code> and <code>none</code>.</li> <li>Directly rendering a dict or list may give different results in other implementations (for example, string entries
might change from single-quoted to double-quoted). Adding the <code>tojson</code> filter can help to ensure consistency here.</li>`,Un,jl,wn,fl,ai=`When this feature was introduced, most templates were quite small, the Jinja equivalent of a “one-liner” script.
However, with new models and features like tool-use and RAG, some templates can be 100 lines long or more. When
writing templates like these, it’s a good idea to write them in a separate file, using a text editor. You can easily
extract a chat template to a file:`,jn,Il,fn,gl,ni="Or load the edited template back into the tokenizer:",In,bl,gn,Cl,oi=`As an added bonus, when you write a long, multi-line template in a separate file, line numbers in that file will
exactly correspond to line numbers in template parsing or execution errors. This will make it much easier to
identify the source of issues.`,bn,Gl,Cn,$l,Gn;return C=new I({props:{title:"Chat Templates",local:"chat-templates",headingTag:"h1"}}),g=new I({props:{title:"Introduction",local:"introduction",headingTag:"h2"}}),R=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJtaXN0cmFsYWklMkZNaXN0cmFsLTdCLUluc3RydWN0LXYwLjElMjIpJTBBJTBBY2hhdCUyMCUzRCUyMCU1QiUwQSUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMkhlbGxvJTJDJTIwaG93JTIwYXJlJTIweW91JTNGJTIyJTdEJTJDJTBBJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMmFzc2lzdGFudCUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJJJ20lMjBkb2luZyUyMGdyZWF0LiUyMEhvdyUyMGNhbiUyMEklMjBoZWxwJTIweW91JTIwdG9kYXklM0YlMjIlN0QlMkMlMEElMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJJJ2QlMjBsaWtlJTIwdG8lMjBzaG93JTIwb2ZmJTIwaG93JTIwY2hhdCUyMHRlbXBsYXRpbmclMjB3b3JrcyElMjIlN0QlMkMlMEElNUQlMEElMEF0b2tlbml6ZXIuYXBwbHlfY2hhdF90ZW1wbGF0ZShjaGF0JTJDJTIwdG9rZW5pemUlM0RGYWxzZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;mistralai/Mistral-7B-Instruct-v0.1&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>chat = [
<span class="hljs-meta">... </span>  {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Hello, how are you?&quot;</span>},
<span class="hljs-meta">... </span>  {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;I&#x27;m doing great. How can I help you today?&quot;</span>},
<span class="hljs-meta">... </span>  {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;I&#x27;d like to show off how chat templating works!&quot;</span>},
<span class="hljs-meta">... </span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.apply_chat_template(chat, tokenize=<span class="hljs-literal">False</span>)
<span class="hljs-string">&quot;&lt;s&gt;[INST] Hello, how are you? [/INST]I&#x27;m doing great. How can I help you today?&lt;/s&gt; [INST] I&#x27;d like to show off how chat templating works! [/INST]&quot;</span>`,wrap:!1}}),E=new J({props:{code:"JTNDJTdDdXNlciU3QyUzRSUwQUhlbGxvJTJDJTIwaG93JTIwYXJlJTIweW91JTNGJTNDJTJGcyUzRSUwQSUzQyU3Q2Fzc2lzdGFudCU3QyUzRSUwQUknbSUyMGRvaW5nJTIwZ3JlYXQuJTIwSG93JTIwY2FuJTIwSSUyMGhlbHAlMjB5b3UlMjB0b2RheSUzRiUzQyUyRnMlM0UlMEElM0MlN0N1c2VyJTdDJTNFJTBBSSdkJTIwbGlrZSUyMHRvJTIwc2hvdyUyMG9mZiUyMGhvdyUyMGNoYXQlMjB0ZW1wbGF0aW5nJTIwd29ya3MhJTNDJTJGcyUzRQ==",highlighted:`&lt;|user|&gt;
Hello, how are you?&lt;/s&gt;
&lt;|assistant|&gt;
I&#x27;m doing great. How can I help you today?&lt;/s&gt;
&lt;|user|&gt;
I&#x27;d like to show off how chat templating works!&lt;/s&gt;`,wrap:!1}}),Y=new I({props:{title:"How do I use chat templates?",local:"how-do-i-use-chat-templates",headingTag:"h2"}}),P=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQSUwQWNoZWNrcG9pbnQlMjAlM0QlMjAlMjJIdWdnaW5nRmFjZUg0JTJGemVwaHlyLTdiLWJldGElMjIlMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZChjaGVja3BvaW50KSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKGNoZWNrcG9pbnQpJTIwJTIwJTIzJTIwWW91JTIwbWF5JTIwd2FudCUyMHRvJTIwdXNlJTIwYmZsb2F0MTYlMjBhbmQlMkZvciUyMG1vdmUlMjB0byUyMEdQVSUyMGhlcmUlMEElMEFtZXNzYWdlcyUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnJvbGUlMjIlM0ElMjAlMjJzeXN0ZW0lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyWW91JTIwYXJlJTIwYSUyMGZyaWVuZGx5JTIwY2hhdGJvdCUyMHdobyUyMGFsd2F5cyUyMHJlc3BvbmRzJTIwaW4lMjB0aGUlMjBzdHlsZSUyMG9mJTIwYSUyMHBpcmF0ZSUyMiUyQyUwQSUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMkhvdyUyMG1hbnklMjBoZWxpY29wdGVycyUyMGNhbiUyMGElMjBodW1hbiUyMGVhdCUyMGluJTIwb25lJTIwc2l0dGluZyUzRiUyMiU3RCUyQyUwQSUyMCU1RCUwQXRva2VuaXplZF9jaGF0JTIwJTNEJTIwdG9rZW5pemVyLmFwcGx5X2NoYXRfdGVtcGxhdGUobWVzc2FnZXMlMkMlMjB0b2tlbml6ZSUzRFRydWUlMkMlMjBhZGRfZ2VuZXJhdGlvbl9wcm9tcHQlM0RUcnVlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEFwcmludCh0b2tlbml6ZXIuZGVjb2RlKHRva2VuaXplZF9jaGF0JTVCMCU1RCkp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer

checkpoint = <span class="hljs-string">&quot;HuggingFaceH4/zephyr-7b-beta&quot;</span>
tokenizer = AutoTokenizer.from_pretrained(checkpoint)
model = AutoModelForCausalLM.from_pretrained(checkpoint)  <span class="hljs-comment"># You may want to use bfloat16 and/or move to GPU here</span>

messages = [
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;You are a friendly chatbot who always responds in the style of a pirate&quot;</span>,
    },
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;How many helicopters can a human eat in one sitting?&quot;</span>},
 ]
tokenized_chat = tokenizer.apply_chat_template(messages, tokenize=<span class="hljs-literal">True</span>, add_generation_prompt=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-built_in">print</span>(tokenizer.decode(tokenized_chat[<span class="hljs-number">0</span>]))`,wrap:!1}}),K=new J({props:{code:"JTNDJTdDc3lzdGVtJTdDJTNFJTBBWW91JTIwYXJlJTIwYSUyMGZyaWVuZGx5JTIwY2hhdGJvdCUyMHdobyUyMGFsd2F5cyUyMHJlc3BvbmRzJTIwaW4lMjB0aGUlMjBzdHlsZSUyMG9mJTIwYSUyMHBpcmF0ZSUzQyUyRnMlM0UlMjAlMEElM0MlN0N1c2VyJTdDJTNFJTBBSG93JTIwbWFueSUyMGhlbGljb3B0ZXJzJTIwY2FuJTIwYSUyMGh1bWFuJTIwZWF0JTIwaW4lMjBvbmUlMjBzaXR0aW5nJTNGJTNDJTJGcyUzRSUyMCUwQSUzQyU3Q2Fzc2lzdGFudCU3QyUzRQ==",highlighted:`&lt;|system|&gt;
You are a friendly chatbot who always responds in the style of a pirate&lt;/s&gt; 
&lt;|user|&gt;
How many helicopters can a human eat in one sitting?&lt;/s&gt; 
&lt;|assistant|&gt;`,wrap:!1}}),tt=new J({props:{code:"b3V0cHV0cyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKHRva2VuaXplZF9jaGF0JTJDJTIwbWF4X25ld190b2tlbnMlM0QxMjgpJTIwJTBBcHJpbnQodG9rZW5pemVyLmRlY29kZShvdXRwdXRzJTVCMCU1RCkp",highlighted:`outputs = model.generate(tokenized_chat, max_new_tokens=<span class="hljs-number">128</span>) 
<span class="hljs-built_in">print</span>(tokenizer.decode(outputs[<span class="hljs-number">0</span>]))`,wrap:!1}}),lt=new J({props:{code:"JTNDJTdDc3lzdGVtJTdDJTNFJTBBWW91JTIwYXJlJTIwYSUyMGZyaWVuZGx5JTIwY2hhdGJvdCUyMHdobyUyMGFsd2F5cyUyMHJlc3BvbmRzJTIwaW4lMjB0aGUlMjBzdHlsZSUyMG9mJTIwYSUyMHBpcmF0ZSUzQyUyRnMlM0UlMjAlMEElM0MlN0N1c2VyJTdDJTNFJTBBSG93JTIwbWFueSUyMGhlbGljb3B0ZXJzJTIwY2FuJTIwYSUyMGh1bWFuJTIwZWF0JTIwaW4lMjBvbmUlMjBzaXR0aW5nJTNGJTNDJTJGcyUzRSUyMCUwQSUzQyU3Q2Fzc2lzdGFudCU3QyUzRSUwQU1hdGV5JTJDJTIwSSdtJTIwYWZyYWlkJTIwSSUyMG11c3QlMjBpbmZvcm0lMjB5ZSUyMHRoYXQlMjBodW1hbnMlMjBjYW5ub3QlMjBlYXQlMjBoZWxpY29wdGVycy4lMjBIZWxpY29wdGVycyUyMGFyZSUyMG5vdCUyMGZvb2QlMkMlMjB0aGV5JTIwYXJlJTIwZmx5aW5nJTIwbWFjaGluZXMuJTIwRm9vZCUyMGlzJTIwbWVhbnQlMjB0byUyMGJlJTIwZWF0ZW4lMkMlMjBsaWtlJTIwYSUyMGhlYXJ0eSUyMHBsYXRlJTIwbyclMjBncm9nJTJDJTIwYSUyMHNhdm9yeSUyMGJvd2wlMjBvJyUyMHN0ZXclMkMlMjBvciUyMGElMjBkZWxpY2lvdXMlMjBsb2FmJTIwbyclMjBicmVhZC4lMjBCdXQlMjBoZWxpY29wdGVycyUyQyUyMHRoZXklMjBiZSUyMGZvciUyMHRyYW5zcG9ydGluJyUyMGFuZCUyMG1vdmluJyUyMGFyb3VuZCUyQyUyMG5vdCUyMGZvciUyMGVhdGluJy4lMjBTbyUyQyUyMEknZCUyMHNheSUyMG5vbmUlMkMlMjBtZSUyMGhlYXJ0aWVzLiUyME5vbmUlMjBhdCUyMGFsbC4=",highlighted:`&lt;|system|&gt;
You are a friendly chatbot who always responds in the style of a pirate&lt;/s&gt; 
&lt;|user|&gt;
How many helicopters can a human eat in one sitting?&lt;/s&gt; 
&lt;|assistant|&gt;
Matey, I&#x27;m afraid I must inform ye that humans cannot eat helicopters. Helicopters are not food, they are flying machines. Food is meant to be eaten, like a hearty plate o&#x27; grog, a savory bowl o&#x27; stew, or a delicious loaf o&#x27; bread. But helicopters, they be for transportin&#x27; and movin&#x27; around, not for eatin&#x27;. So, I&#x27;d say none, me hearties. None at all.`,wrap:!1}}),at=new I({props:{title:"Is there an automated pipeline for chat?",local:"is-there-an-automated-pipeline-for-chat",headingTag:"h2"}}),ot=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBcGlwZSUyMCUzRCUyMHBpcGVsaW5lKCUyMnRleHQtZ2VuZXJhdGlvbiUyMiUyQyUyMCUyMkh1Z2dpbmdGYWNlSDQlMkZ6ZXBoeXItN2ItYmV0YSUyMiklMEFtZXNzYWdlcyUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnJvbGUlMjIlM0ElMjAlMjJzeXN0ZW0lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyWW91JTIwYXJlJTIwYSUyMGZyaWVuZGx5JTIwY2hhdGJvdCUyMHdobyUyMGFsd2F5cyUyMHJlc3BvbmRzJTIwaW4lMjB0aGUlMjBzdHlsZSUyMG9mJTIwYSUyMHBpcmF0ZSUyMiUyQyUwQSUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMkhvdyUyMG1hbnklMjBoZWxpY29wdGVycyUyMGNhbiUyMGElMjBodW1hbiUyMGVhdCUyMGluJTIwb25lJTIwc2l0dGluZyUzRiUyMiU3RCUyQyUwQSU1RCUwQXByaW50KHBpcGUobWVzc2FnZXMlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDEyOCklNUIwJTVEJTVCJ2dlbmVyYXRlZF90ZXh0JyU1RCU1Qi0xJTVEKSUyMCUyMCUyMyUyMFByaW50JTIwdGhlJTIwYXNzaXN0YW50J3MlMjByZXNwb25zZQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

pipe = pipeline(<span class="hljs-string">&quot;text-generation&quot;</span>, <span class="hljs-string">&quot;HuggingFaceH4/zephyr-7b-beta&quot;</span>)
messages = [
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;You are a friendly chatbot who always responds in the style of a pirate&quot;</span>,
    },
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;How many helicopters can a human eat in one sitting?&quot;</span>},
]
<span class="hljs-built_in">print</span>(pipe(messages, max_new_tokens=<span class="hljs-number">128</span>)[<span class="hljs-number">0</span>][<span class="hljs-string">&#x27;generated_text&#x27;</span>][-<span class="hljs-number">1</span>])  <span class="hljs-comment"># Print the assistant&#x27;s response</span>`,wrap:!1}}),it=new J({props:{code:"JTdCJ3JvbGUnJTNBJTIwJ2Fzc2lzdGFudCclMkMlMjAnY29udGVudCclM0ElMjAlMjJNYXRleSUyQyUyMEknbSUyMGFmcmFpZCUyMEklMjBtdXN0JTIwaW5mb3JtJTIweWUlMjB0aGF0JTIwaHVtYW5zJTIwY2Fubm90JTIwZWF0JTIwaGVsaWNvcHRlcnMuJTIwSGVsaWNvcHRlcnMlMjBhcmUlMjBub3QlMjBmb29kJTJDJTIwdGhleSUyMGFyZSUyMGZseWluZyUyMG1hY2hpbmVzLiUyMEZvb2QlMjBpcyUyMG1lYW50JTIwdG8lMjBiZSUyMGVhdGVuJTJDJTIwbGlrZSUyMGElMjBoZWFydHklMjBwbGF0ZSUyMG8nJTIwZ3JvZyUyQyUyMGElMjBzYXZvcnklMjBib3dsJTIwbyclMjBzdGV3JTJDJTIwb3IlMjBhJTIwZGVsaWNpb3VzJTIwbG9hZiUyMG8nJTIwYnJlYWQuJTIwQnV0JTIwaGVsaWNvcHRlcnMlMkMlMjB0aGV5JTIwYmUlMjBmb3IlMjB0cmFuc3BvcnRpbiclMjBhbmQlMjBtb3ZpbiclMjBhcm91bmQlMkMlMjBub3QlMjBmb3IlMjBlYXRpbicuJTIwU28lMkMlMjBJJ2QlMjBzYXklMjBub25lJTJDJTIwbWUlMjBoZWFydGllcy4lMjBOb25lJTIwYXQlMjBhbGwuJTIyJTdE",highlighted:"{&#x27;role&#x27;: &#x27;assistant&#x27;, &#x27;content&#x27;: &quot;Matey, I&#x27;m afraid I must inform ye that humans cannot eat helicopters. Helicopters are not food, they are flying machines. Food is meant to be eaten, like a hearty plate o&#x27; grog, a savory bowl o&#x27; stew, or a delicious loaf o&#x27; bread. But helicopters, they be for transportin&#x27; and movin&#x27; around, not for eatin&#x27;. So, I&#x27;d say none, me hearties. None at all.&quot;}",wrap:!1}}),rt=new I({props:{title:"What are “generation prompts”?",local:"what-are-generation-prompts",headingTag:"h2"}}),ct=new J({props:{code:"bWVzc2FnZXMlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJIaSUyMHRoZXJlISUyMiU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJhc3Npc3RhbnQlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyTmljZSUyMHRvJTIwbWVldCUyMHlvdSElMjIlN0QlMkMlMEElMjAlMjAlMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJDYW4lMjBJJTIwYXNrJTIwYSUyMHF1ZXN0aW9uJTNGJTIyJTdEJTBBJTVE",highlighted:`messages = [
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Hi there!&quot;</span>},
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Nice to meet you!&quot;</span>},
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Can I ask a question?&quot;</span>}
]`,wrap:!1}}),ut=new J({props:{code:"dG9rZW5pemVyLmFwcGx5X2NoYXRfdGVtcGxhdGUobWVzc2FnZXMlMkMlMjB0b2tlbml6ZSUzREZhbHNlJTJDJTIwYWRkX2dlbmVyYXRpb25fcHJvbXB0JTNERmFsc2UpJTBBJTIyJTIyJTIyJTNDJTdDaW1fc3RhcnQlN0MlM0V1c2VyJTBBSGklMjB0aGVyZSElM0MlN0NpbV9lbmQlN0MlM0UlMEElM0MlN0NpbV9zdGFydCU3QyUzRWFzc2lzdGFudCUwQU5pY2UlMjB0byUyMG1lZXQlMjB5b3UhJTNDJTdDaW1fZW5kJTdDJTNFJTBBJTNDJTdDaW1fc3RhcnQlN0MlM0V1c2VyJTBBQ2FuJTIwSSUyMGFzayUyMGElMjBxdWVzdGlvbiUzRiUzQyU3Q2ltX2VuZCU3QyUzRSUwQSUyMiUyMiUyMg==",highlighted:`tokenizer.apply_chat_template(messages, tokenize=<span class="hljs-literal">False</span>, add_generation_prompt=<span class="hljs-literal">False</span>)
<span class="hljs-string">&quot;&quot;&quot;&lt;|im_start|&gt;user
Hi there!&lt;|im_end|&gt;
&lt;|im_start|&gt;assistant
Nice to meet you!&lt;|im_end|&gt;
&lt;|im_start|&gt;user
Can I ask a question?&lt;|im_end|&gt;
&quot;&quot;&quot;</span>`,wrap:!1}}),dt=new J({props:{code:"dG9rZW5pemVyLmFwcGx5X2NoYXRfdGVtcGxhdGUobWVzc2FnZXMlMkMlMjB0b2tlbml6ZSUzREZhbHNlJTJDJTIwYWRkX2dlbmVyYXRpb25fcHJvbXB0JTNEVHJ1ZSklMEElMjIlMjIlMjIlM0MlN0NpbV9zdGFydCU3QyUzRXVzZXIlMEFIaSUyMHRoZXJlISUzQyU3Q2ltX2VuZCU3QyUzRSUwQSUzQyU3Q2ltX3N0YXJ0JTdDJTNFYXNzaXN0YW50JTBBTmljZSUyMHRvJTIwbWVldCUyMHlvdSElM0MlN0NpbV9lbmQlN0MlM0UlMEElM0MlN0NpbV9zdGFydCU3QyUzRXVzZXIlMEFDYW4lMjBJJTIwYXNrJTIwYSUyMHF1ZXN0aW9uJTNGJTNDJTdDaW1fZW5kJTdDJTNFJTBBJTNDJTdDaW1fc3RhcnQlN0MlM0Vhc3Npc3RhbnQlMEElMjIlMjIlMjI=",highlighted:`tokenizer.apply_chat_template(messages, tokenize=<span class="hljs-literal">False</span>, add_generation_prompt=<span class="hljs-literal">True</span>)
<span class="hljs-string">&quot;&quot;&quot;&lt;|im_start|&gt;user
Hi there!&lt;|im_end|&gt;
&lt;|im_start|&gt;assistant
Nice to meet you!&lt;|im_end|&gt;
&lt;|im_start|&gt;user
Can I ask a question?&lt;|im_end|&gt;
&lt;|im_start|&gt;assistant
&quot;&quot;&quot;</span>`,wrap:!1}}),Tt=new I({props:{title:"What does “continue_final_message” do?",local:"what-does-continuefinalmessage-do",headingTag:"h2"}}),jt=new J({props:{code:"Y2hhdCUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMkNhbiUyMHlvdSUyMGZvcm1hdCUyMHRoZSUyMGFuc3dlciUyMGluJTIwSlNPTiUzRiUyMiU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJhc3Npc3RhbnQlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJyU3QiUyMm5hbWUlMjIlM0ElMjAlMjInJTdEJTJDJTBBJTVEJTBBJTBBZm9ybWF0dGVkX2NoYXQlMjAlM0QlMjB0b2tlbml6ZXIuYXBwbHlfY2hhdF90ZW1wbGF0ZShjaGF0JTJDJTIwdG9rZW5pemUlM0RUcnVlJTJDJTIwcmV0dXJuX2RpY3QlM0RUcnVlJTJDJTIwY29udGludWVfZmluYWxfbWVzc2FnZSUzRFRydWUpJTBBbW9kZWwuZ2VuZXJhdGUoKipmb3JtYXR0ZWRfY2hhdCk=",highlighted:`chat = [
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Can you format the answer in JSON?&quot;</span>},
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&#x27;{&quot;name&quot;: &quot;&#x27;</span>},
]

formatted_chat = tokenizer.apply_chat_template(chat, tokenize=<span class="hljs-literal">True</span>, return_dict=<span class="hljs-literal">True</span>, continue_final_message=<span class="hljs-literal">True</span>)
model.generate(**formatted_chat)`,wrap:!1}}),v=new x({props:{$$slots:{default:[Gi]},$$scope:{ctx:b}}}),gt=new I({props:{title:"Can I use chat templates in training?",local:"can-i-use-chat-templates-in-training",headingTag:"h2"}}),Ct=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwZGF0YXNldHMlMjBpbXBvcnQlMjBEYXRhc2V0JTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIySHVnZ2luZ0ZhY2VINCUyRnplcGh5ci03Yi1iZXRhJTIyKSUwQSUwQWNoYXQxJTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyV2hpY2glMjBpcyUyMGJpZ2dlciUyQyUyMHRoZSUyMG1vb24lMjBvciUyMHRoZSUyMHN1biUzRiUyMiU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJhc3Npc3RhbnQlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyVGhlJTIwc3VuLiUyMiU3RCUwQSU1RCUwQWNoYXQyJTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyV2hpY2glMjBpcyUyMGJpZ2dlciUyQyUyMGElMjB2aXJ1cyUyMG9yJTIwYSUyMGJhY3Rlcml1bSUzRiUyMiU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJhc3Npc3RhbnQlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyQSUyMGJhY3Rlcml1bS4lMjIlN0QlMEElNUQlMEElMEFkYXRhc2V0JTIwJTNEJTIwRGF0YXNldC5mcm9tX2RpY3QoJTdCJTIyY2hhdCUyMiUzQSUyMCU1QmNoYXQxJTJDJTIwY2hhdDIlNUQlN0QpJTBBZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQubWFwKGxhbWJkYSUyMHglM0ElMjAlN0IlMjJmb3JtYXR0ZWRfY2hhdCUyMiUzQSUyMHRva2VuaXplci5hcHBseV9jaGF0X3RlbXBsYXRlKHglNUIlMjJjaGF0JTIyJTVEJTJDJTIwdG9rZW5pemUlM0RGYWxzZSUyQyUyMGFkZF9nZW5lcmF0aW9uX3Byb21wdCUzREZhbHNlKSU3RCklMEFwcmludChkYXRhc2V0JTVCJ2Zvcm1hdHRlZF9jaGF0JyU1RCU1QjAlNUQp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;HuggingFaceH4/zephyr-7b-beta&quot;</span>)

chat1 = [
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Which is bigger, the moon or the sun?&quot;</span>},
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;The sun.&quot;</span>}
]
chat2 = [
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Which is bigger, a virus or a bacterium?&quot;</span>},
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;A bacterium.&quot;</span>}
]

dataset = Dataset.from_dict({<span class="hljs-string">&quot;chat&quot;</span>: [chat1, chat2]})
dataset = dataset.<span class="hljs-built_in">map</span>(<span class="hljs-keyword">lambda</span> x: {<span class="hljs-string">&quot;formatted_chat&quot;</span>: tokenizer.apply_chat_template(x[<span class="hljs-string">&quot;chat&quot;</span>], tokenize=<span class="hljs-literal">False</span>, add_generation_prompt=<span class="hljs-literal">False</span>)})
<span class="hljs-built_in">print</span>(dataset[<span class="hljs-string">&#x27;formatted_chat&#x27;</span>][<span class="hljs-number">0</span>])`,wrap:!1}}),$t=new J({props:{code:"JTNDJTdDdXNlciU3QyUzRSUwQVdoaWNoJTIwaXMlMjBiaWdnZXIlMkMlMjB0aGUlMjBtb29uJTIwb3IlMjB0aGUlMjBzdW4lM0YlM0MlMkZzJTNFJTBBJTNDJTdDYXNzaXN0YW50JTdDJTNFJTBBVGhlJTIwc3VuLiUzQyUyRnMlM0U=",highlighted:`&lt;|user|&gt;
Which is bigger, the moon or the sun?&lt;/s&gt;
&lt;|assistant|&gt;
The sun.&lt;/s&gt;`,wrap:!1}}),Z=new x({props:{$$slots:{default:[$i]},$$scope:{ctx:b}}}),xt=new I({props:{title:"Advanced: Extra inputs to chat templates",local:"advanced-extra-inputs-to-chat-templates",headingTag:"h2"}}),kt=new I({props:{title:"Advanced: Tool use / function calling",local:"advanced-tool-use--function-calling",headingTag:"h2"}}),Wt=new J({props:{code:"aW1wb3J0JTIwZGF0ZXRpbWUlMEElMEFkZWYlMjBjdXJyZW50X3RpbWUoKSUzQSUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMkdldCUyMHRoZSUyMGN1cnJlbnQlMjBsb2NhbCUyMHRpbWUlMjBhcyUyMGElMjBzdHJpbmcuJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwc3RyKGRhdGV0aW1lLm5vdygpKSUwQSUwQWRlZiUyMG11bHRpcGx5KGElM0ElMjBmbG9hdCUyQyUyMGIlM0ElMjBmbG9hdCklM0ElMEElMjAlMjAlMjAlMjAlMjIlMjIlMjIlMEElMjAlMjAlMjAlMjBBJTIwZnVuY3Rpb24lMjB0aGF0JTIwbXVsdGlwbGllcyUyMHR3byUyMG51bWJlcnMlMEElMjAlMjAlMjAlMjAlMEElMjAlMjAlMjAlMjBBcmdzJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYSUzQSUyMFRoZSUyMGZpcnN0JTIwbnVtYmVyJTIwdG8lMjBtdWx0aXBseSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGIlM0ElMjBUaGUlMjBzZWNvbmQlMjBudW1iZXIlMjB0byUyMG11bHRpcGx5JTBBJTIwJTIwJTIwJTIwJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwYSUyMColMjBiJTBBJTBBdG9vbHMlMjAlM0QlMjAlNUJjdXJyZW50X3RpbWUlMkMlMjBtdWx0aXBseSU1RCUwQSUwQW1vZGVsX2lucHV0JTIwJTNEJTIwdG9rZW5pemVyLmFwcGx5X2NoYXRfdGVtcGxhdGUoJTBBJTIwJTIwJTIwJTIwbWVzc2FnZXMlMkMlMEElMjAlMjAlMjAlMjB0b29scyUzRHRvb2xzJTBBKQ==",highlighted:`<span class="hljs-keyword">import</span> datetime

<span class="hljs-keyword">def</span> <span class="hljs-title function_">current_time</span>():
    <span class="hljs-string">&quot;&quot;&quot;Get the current local time as a string.&quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> <span class="hljs-built_in">str</span>(datetime.now())

<span class="hljs-keyword">def</span> <span class="hljs-title function_">multiply</span>(<span class="hljs-params">a: <span class="hljs-built_in">float</span>, b: <span class="hljs-built_in">float</span></span>):
    <span class="hljs-string">&quot;&quot;&quot;
    A function that multiplies two numbers
    
    Args:
        a: The first number to multiply
        b: The second number to multiply
    &quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> a * b

tools = [current_time, multiply]

model_input = tokenizer.apply_chat_template(
    messages,
    tools=tools
)`,wrap:!1}}),Vt=new I({props:{title:"Passing tool results to the model",local:"passing-tool-results-to-the-model",headingTag:"h3"}}),zt=new I({props:{title:"A complete tool use example",local:"a-complete-tool-use-example",headingTag:"h3"}}),Xt=new J({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0lMkMlMjBBdXRvVG9rZW5pemVyJTBBJTBBY2hlY2twb2ludCUyMCUzRCUyMCUyMk5vdXNSZXNlYXJjaCUyRkhlcm1lcy0yLVByby1MbGFtYS0zLThCJTIyJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoY2hlY2twb2ludCklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZChjaGVja3BvaW50JTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5iZmxvYXQxNiUyQyUyMGRldmljZV9tYXAlM0QlMjJhdXRvJTIyKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer

checkpoint = <span class="hljs-string">&quot;NousResearch/Hermes-2-Pro-Llama-3-8B&quot;</span>

tokenizer = AutoTokenizer.from_pretrained(checkpoint)
model = AutoModelForCausalLM.from_pretrained(checkpoint, torch_dtype=torch.bfloat16, device_map=<span class="hljs-string">&quot;auto&quot;</span>)`,wrap:!1}}),Ht=new J({props:{code:"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",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_current_temperature</span>(<span class="hljs-params">location: <span class="hljs-built_in">str</span>, unit: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">float</span>:
    <span class="hljs-string">&quot;&quot;&quot;
    Get the current temperature at a location.
    
    Args:
        location: The location to get the temperature for, in the format &quot;City, Country&quot;
        unit: The unit to return the temperature in. (choices: [&quot;celsius&quot;, &quot;fahrenheit&quot;])
    Returns:
        The current temperature at the specified location in the specified units, as a float.
    &quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> <span class="hljs-number">22.</span>  <span class="hljs-comment"># A real function should probably actually get the temperature!</span>

<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_current_wind_speed</span>(<span class="hljs-params">location: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">float</span>:
    <span class="hljs-string">&quot;&quot;&quot;
    Get the current wind speed in km/h at a given location.
    
    Args:
        location: The location to get the temperature for, in the format &quot;City, Country&quot;
    Returns:
        The current wind speed at the given location in km/h, as a float.
    &quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> <span class="hljs-number">6.</span>  <span class="hljs-comment"># A real function should probably actually get the wind speed!</span>

tools = [get_current_temperature, get_current_wind_speed]`,wrap:!1}}),Ft=new J({props:{code:"bWVzc2FnZXMlMjAlM0QlMjAlNUIlMEElMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIyc3lzdGVtJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMllvdSUyMGFyZSUyMGElMjBib3QlMjB0aGF0JTIwcmVzcG9uZHMlMjB0byUyMHdlYXRoZXIlMjBxdWVyaWVzLiUyMFlvdSUyMHNob3VsZCUyMHJlcGx5JTIwd2l0aCUyMHRoZSUyMHVuaXQlMjB1c2VkJTIwaW4lMjB0aGUlMjBxdWVyaWVkJTIwbG9jYXRpb24uJTIyJTdEJTJDJTBBJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIySGV5JTJDJTIwd2hhdCdzJTIwdGhlJTIwdGVtcGVyYXR1cmUlMjBpbiUyMFBhcmlzJTIwcmlnaHQlMjBub3clM0YlMjIlN0QlMEElNUQ=",highlighted:`messages = [
  {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;You are a bot that responds to weather queries. You should reply with the unit used in the queried location.&quot;</span>},
  {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Hey, what&#x27;s the temperature in Paris right now?&quot;</span>}
]`,wrap:!1}}),Pt=new J({props:{code:"aW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyLmFwcGx5X2NoYXRfdGVtcGxhdGUobWVzc2FnZXMlMkMlMjB0b29scyUzRHRvb2xzJTJDJTIwYWRkX2dlbmVyYXRpb25fcHJvbXB0JTNEVHJ1ZSUyQyUyMHJldHVybl9kaWN0JTNEVHJ1ZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBaW5wdXRzJTIwJTNEJTIwJTdCayUzQSUyMHYudG8obW9kZWwuZGV2aWNlKSUyMGZvciUyMGslMkMlMjB2JTIwaW4lMjBpbnB1dHMuaXRlbXMoKSU3RCUwQW91dCUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwbWF4X25ld190b2tlbnMlM0QxMjgpJTBBcHJpbnQodG9rZW5pemVyLmRlY29kZShvdXQlNUIwJTVEJTVCbGVuKGlucHV0cyU1QiUyMmlucHV0X2lkcyUyMiU1RCU1QjAlNUQpJTNBJTVEKSk=",highlighted:`inputs = tokenizer.apply_chat_template(messages, tools=tools, add_generation_prompt=<span class="hljs-literal">True</span>, return_dict=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
inputs = {k: v.to(model.device) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> inputs.items()}
out = model.generate(**inputs, max_new_tokens=<span class="hljs-number">128</span>)
<span class="hljs-built_in">print</span>(tokenizer.decode(out[<span class="hljs-number">0</span>][<span class="hljs-built_in">len</span>(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>][<span class="hljs-number">0</span>]):]))`,wrap:!1}}),Kt=new J({props:{code:"JTNDdG9vbF9jYWxsJTNFJTBBJTdCJTIyYXJndW1lbnRzJTIyJTNBJTIwJTdCJTIybG9jYXRpb24lMjIlM0ElMjAlMjJQYXJpcyUyQyUyMEZyYW5jZSUyMiUyQyUyMCUyMnVuaXQlMjIlM0ElMjAlMjJjZWxzaXVzJTIyJTdEJTJDJTIwJTIybmFtZSUyMiUzQSUyMCUyMmdldF9jdXJyZW50X3RlbXBlcmF0dXJlJTIyJTdEJTBBJTNDJTJGdG9vbF9jYWxsJTNFJTNDJTdDaW1fZW5kJTdDJTNF",highlighted:`&lt;tool_call&gt;
{&quot;arguments&quot;: {&quot;location&quot;: &quot;Paris, France&quot;, &quot;unit&quot;: &quot;celsius&quot;}, &quot;name&quot;: &quot;get_current_temperature&quot;}
&lt;/tool_call&gt;&lt;|im_end|&gt;`,wrap:!1}}),k=new x({props:{$$slots:{default:[Bi]},$$scope:{ctx:b}}}),ee=new J({props:{code:"dG9vbF9jYWxsJTIwJTNEJTIwJTdCJTIybmFtZSUyMiUzQSUyMCUyMmdldF9jdXJyZW50X3RlbXBlcmF0dXJlJTIyJTJDJTIwJTIyYXJndW1lbnRzJTIyJTNBJTIwJTdCJTIybG9jYXRpb24lMjIlM0ElMjAlMjJQYXJpcyUyQyUyMEZyYW5jZSUyMiUyQyUyMCUyMnVuaXQlMjIlM0ElMjAlMjJjZWxzaXVzJTIyJTdEJTdEJTBBbWVzc2FnZXMuYXBwZW5kKCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJhc3Npc3RhbnQlMjIlMkMlMjAlMjJ0b29sX2NhbGxzJTIyJTNBJTIwJTVCJTdCJTIydHlwZSUyMiUzQSUyMCUyMmZ1bmN0aW9uJTIyJTJDJTIwJTIyZnVuY3Rpb24lMjIlM0ElMjB0b29sX2NhbGwlN0QlNUQlN0Qp",highlighted:`tool_call = {<span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;get_current_temperature&quot;</span>, <span class="hljs-string">&quot;arguments&quot;</span>: {<span class="hljs-string">&quot;location&quot;</span>: <span class="hljs-string">&quot;Paris, France&quot;</span>, <span class="hljs-string">&quot;unit&quot;</span>: <span class="hljs-string">&quot;celsius&quot;</span>}}
messages.append({<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;tool_calls&quot;</span>: [{<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;function&quot;</span>, <span class="hljs-string">&quot;function&quot;</span>: tool_call}]})`,wrap:!1}}),N=new x({props:{warning:!0,$$slots:{default:[xi]},$$scope:{ctx:b}}}),se=new J({props:{code:"bWVzc2FnZXMuYXBwZW5kKCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJ0b29sJTIyJTJDJTIwJTIybmFtZSUyMiUzQSUyMCUyMmdldF9jdXJyZW50X3RlbXBlcmF0dXJlJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMjIyLjAlMjIlN0Qp",highlighted:'messages.append({<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;tool&quot;</span>, <span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;get_current_temperature&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;22.0&quot;</span>})',wrap:!1}}),W=new x({props:{$$slots:{default:[vi]},$$scope:{ctx:b}}}),ne=new J({props:{code:"aW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyLmFwcGx5X2NoYXRfdGVtcGxhdGUobWVzc2FnZXMlMkMlMjB0b29scyUzRHRvb2xzJTJDJTIwYWRkX2dlbmVyYXRpb25fcHJvbXB0JTNEVHJ1ZSUyQyUyMHJldHVybl9kaWN0JTNEVHJ1ZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBaW5wdXRzJTIwJTNEJTIwJTdCayUzQSUyMHYudG8obW9kZWwuZGV2aWNlKSUyMGZvciUyMGslMkMlMjB2JTIwaW4lMjBpbnB1dHMuaXRlbXMoKSU3RCUwQW91dCUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwbWF4X25ld190b2tlbnMlM0QxMjgpJTBBcHJpbnQodG9rZW5pemVyLmRlY29kZShvdXQlNUIwJTVEJTVCbGVuKGlucHV0cyU1QiUyMmlucHV0X2lkcyUyMiU1RCU1QjAlNUQpJTNBJTVEKSk=",highlighted:`inputs = tokenizer.apply_chat_template(messages, tools=tools, add_generation_prompt=<span class="hljs-literal">True</span>, return_dict=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
inputs = {k: v.to(model.device) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> inputs.items()}
out = model.generate(**inputs, max_new_tokens=<span class="hljs-number">128</span>)
<span class="hljs-built_in">print</span>(tokenizer.decode(out[<span class="hljs-number">0</span>][<span class="hljs-built_in">len</span>(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>][<span class="hljs-number">0</span>]):]))`,wrap:!1}}),ie=new J({props:{code:"VGhlJTIwY3VycmVudCUyMHRlbXBlcmF0dXJlJTIwaW4lMjBQYXJpcyUyQyUyMEZyYW5jZSUyMGlzJTIwMjIuMCUyMCVDMiVCMCUyMENlbHNpdXMuJTNDJTdDaW1fZW5kJTdDJTNF",highlighted:"The current temperature in Paris, France is 22.0 ° Celsius.&lt;|im_end|&gt;",wrap:!1}}),re=new I({props:{title:"Understanding tool schemas",local:"understanding-tool-schemas",headingTag:"h3"}}),ye=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycy51dGlscyUyMGltcG9ydCUyMGdldF9qc29uX3NjaGVtYSUwQSUwQWRlZiUyMG11bHRpcGx5KGElM0ElMjBmbG9hdCUyQyUyMGIlM0ElMjBmbG9hdCklM0ElMEElMjAlMjAlMjAlMjAlMjIlMjIlMjIlMEElMjAlMjAlMjAlMjBBJTIwZnVuY3Rpb24lMjB0aGF0JTIwbXVsdGlwbGllcyUyMHR3byUyMG51bWJlcnMlMEElMjAlMjAlMjAlMjAlMEElMjAlMjAlMjAlMjBBcmdzJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYSUzQSUyMFRoZSUyMGZpcnN0JTIwbnVtYmVyJTIwdG8lMjBtdWx0aXBseSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGIlM0ElMjBUaGUlMjBzZWNvbmQlMjBudW1iZXIlMjB0byUyMG11bHRpcGx5JTBBJTIwJTIwJTIwJTIwJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwYSUyMColMjBiJTBBJTBBc2NoZW1hJTIwJTNEJTIwZ2V0X2pzb25fc2NoZW1hKG11bHRpcGx5KSUwQXByaW50KHNjaGVtYSk=",highlighted:`<span class="hljs-keyword">from</span> transformers.utils <span class="hljs-keyword">import</span> get_json_schema

<span class="hljs-keyword">def</span> <span class="hljs-title function_">multiply</span>(<span class="hljs-params">a: <span class="hljs-built_in">float</span>, b: <span class="hljs-built_in">float</span></span>):
    <span class="hljs-string">&quot;&quot;&quot;
    A function that multiplies two numbers
    
    Args:
        a: The first number to multiply
        b: The second number to multiply
    &quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> a * b

schema = get_json_schema(multiply)
<span class="hljs-built_in">print</span>(schema)`,wrap:!1}}),me=new J({props:{code:"JTdCJTBBJTIwJTIwJTIydHlwZSUyMiUzQSUyMCUyMmZ1bmN0aW9uJTIyJTJDJTIwJTBBJTIwJTIwJTIyZnVuY3Rpb24lMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjJuYW1lJTIyJTNBJTIwJTIybXVsdGlwbHklMjIlMkMlMjAlMEElMjAlMjAlMjAlMjAlMjJkZXNjcmlwdGlvbiUyMiUzQSUyMCUyMkElMjBmdW5jdGlvbiUyMHRoYXQlMjBtdWx0aXBsaWVzJTIwdHdvJTIwbnVtYmVycyUyMiUyQyUyMCUwQSUyMCUyMCUyMCUyMCUyMnBhcmFtZXRlcnMlMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJ0eXBlJTIyJTNBJTIwJTIyb2JqZWN0JTIyJTJDJTIwJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIycHJvcGVydGllcyUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmElMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ0eXBlJTIyJTNBJTIwJTIybnVtYmVyJTIyJTJDJTIwJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyZGVzY3JpcHRpb24lMjIlM0ElMjAlMjJUaGUlMjBmaXJzdCUyMG51bWJlciUyMHRvJTIwbXVsdGlwbHklMjIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0QlMkMlMjAlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJiJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydHlwZSUyMiUzQSUyMCUyMm51bWJlciUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmRlc2NyaXB0aW9uJTIyJTNBJTIwJTIyVGhlJTIwc2Vjb25kJTIwbnVtYmVyJTIwdG8lMjBtdWx0aXBseSUyMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCU3RCUyQyUyMCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMnJlcXVpcmVkJTIyJTNBJTIwJTVCJTIyYSUyMiUyQyUyMCUyMmIlMjIlNUQlMEElMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlN0QlMEElN0Q=",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;function&quot;</span><span class="hljs-punctuation">,</span> 
  <span class="hljs-attr">&quot;function&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;name&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;multiply&quot;</span><span class="hljs-punctuation">,</span> 
    <span class="hljs-attr">&quot;description&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;A function that multiplies two numbers&quot;</span><span class="hljs-punctuation">,</span> 
    <span class="hljs-attr">&quot;parameters&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
      <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;object&quot;</span><span class="hljs-punctuation">,</span> 
      <span class="hljs-attr">&quot;properties&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;a&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
          <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;number&quot;</span><span class="hljs-punctuation">,</span> 
          <span class="hljs-attr">&quot;description&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;The first number to multiply&quot;</span>
        <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span> 
        <span class="hljs-attr">&quot;b&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
          <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;number&quot;</span><span class="hljs-punctuation">,</span>
          <span class="hljs-attr">&quot;description&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;The second number to multiply&quot;</span>
        <span class="hljs-punctuation">}</span>
      <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span> 
      <span class="hljs-attr">&quot;required&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span><span class="hljs-string">&quot;a&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-string">&quot;b&quot;</span><span class="hljs-punctuation">]</span>
    <span class="hljs-punctuation">}</span>
  <span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),Je=new J({props:{code:"JTIzJTIwQSUyMHNpbXBsZSUyMGZ1bmN0aW9uJTIwdGhhdCUyMHRha2VzJTIwbm8lMjBhcmd1bWVudHMlMEFjdXJyZW50X3RpbWUlMjAlM0QlMjAlN0IlMEElMjAlMjAlMjJ0eXBlJTIyJTNBJTIwJTIyZnVuY3Rpb24lMjIlMkMlMjAlMEElMjAlMjAlMjJmdW5jdGlvbiUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMm5hbWUlMjIlM0ElMjAlMjJjdXJyZW50X3RpbWUlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJkZXNjcmlwdGlvbiUyMiUzQSUyMCUyMkdldCUyMHRoZSUyMGN1cnJlbnQlMjBsb2NhbCUyMHRpbWUlMjBhcyUyMGElMjBzdHJpbmcuJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIycGFyYW1ldGVycyUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCd0eXBlJyUzQSUyMCdvYmplY3QnJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJ3Byb3BlcnRpZXMnJTNBJTIwJTdCJTdEJTBBJTIwJTIwJTIwJTIwJTdEJTBBJTIwJTIwJTdEJTBBJTdEJTBBJTBBJTIzJTIwQSUyMG1vcmUlMjBjb21wbGV0ZSUyMGZ1bmN0aW9uJTIwdGhhdCUyMHRha2VzJTIwdHdvJTIwbnVtZXJpY2FsJTIwYXJndW1lbnRzJTBBbXVsdGlwbHklMjAlM0QlMjAlN0IlMEElMjAlMjAndHlwZSclM0ElMjAnZnVuY3Rpb24nJTJDJTBBJTIwJTIwJ2Z1bmN0aW9uJyUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCduYW1lJyUzQSUyMCdtdWx0aXBseSclMkMlMEElMjAlMjAlMjAlMjAnZGVzY3JpcHRpb24nJTNBJTIwJ0ElMjBmdW5jdGlvbiUyMHRoYXQlMjBtdWx0aXBsaWVzJTIwdHdvJTIwbnVtYmVycyclMkMlMjAlMEElMjAlMjAlMjAlMjAncGFyYW1ldGVycyclM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAndHlwZSclM0ElMjAnb2JqZWN0JyUyQyUyMCUwQSUyMCUyMCUyMCUyMCUyMCUyMCdwcm9wZXJ0aWVzJyUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCdhJyUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCd0eXBlJyUzQSUyMCdudW1iZXInJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJ2Rlc2NyaXB0aW9uJyUzQSUyMCdUaGUlMjBmaXJzdCUyMG51bWJlciUyMHRvJTIwbXVsdGlwbHknJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTJDJTIwJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJ2InJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJ3R5cGUnJTNBJTIwJ251bWJlciclMkMlMjAnZGVzY3JpcHRpb24nJTNBJTIwJ1RoZSUyMHNlY29uZCUyMG51bWJlciUyMHRvJTIwbXVsdGlwbHknJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTJDJTIwJTBBJTIwJTIwJTIwJTIwJTIwJTIwJ3JlcXVpcmVkJyUzQSUyMCU1QidhJyUyQyUyMCdiJyU1RCUwQSUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCU3RCUwQSU3RCUwQSUwQW1vZGVsX2lucHV0JTIwJTNEJTIwdG9rZW5pemVyLmFwcGx5X2NoYXRfdGVtcGxhdGUoJTBBJTIwJTIwJTIwJTIwbWVzc2FnZXMlMkMlMEElMjAlMjAlMjAlMjB0b29scyUyMCUzRCUyMCU1QmN1cnJlbnRfdGltZSUyQyUyMG11bHRpcGx5JTVEJTBBKQ==",highlighted:`<span class="hljs-comment"># A simple function that takes no arguments</span>
current_time = {
  <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;function&quot;</span>, 
  <span class="hljs-string">&quot;function&quot;</span>: {
    <span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;current_time&quot;</span>,
    <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;Get the current local time as a string.&quot;</span>,
    <span class="hljs-string">&quot;parameters&quot;</span>: {
      <span class="hljs-string">&#x27;type&#x27;</span>: <span class="hljs-string">&#x27;object&#x27;</span>,
      <span class="hljs-string">&#x27;properties&#x27;</span>: {}
    }
  }
}

<span class="hljs-comment"># A more complete function that takes two numerical arguments</span>
multiply = {
  <span class="hljs-string">&#x27;type&#x27;</span>: <span class="hljs-string">&#x27;function&#x27;</span>,
  <span class="hljs-string">&#x27;function&#x27;</span>: {
    <span class="hljs-string">&#x27;name&#x27;</span>: <span class="hljs-string">&#x27;multiply&#x27;</span>,
    <span class="hljs-string">&#x27;description&#x27;</span>: <span class="hljs-string">&#x27;A function that multiplies two numbers&#x27;</span>, 
    <span class="hljs-string">&#x27;parameters&#x27;</span>: {
      <span class="hljs-string">&#x27;type&#x27;</span>: <span class="hljs-string">&#x27;object&#x27;</span>, 
      <span class="hljs-string">&#x27;properties&#x27;</span>: {
        <span class="hljs-string">&#x27;a&#x27;</span>: {
          <span class="hljs-string">&#x27;type&#x27;</span>: <span class="hljs-string">&#x27;number&#x27;</span>,
          <span class="hljs-string">&#x27;description&#x27;</span>: <span class="hljs-string">&#x27;The first number to multiply&#x27;</span>
        }, 
        <span class="hljs-string">&#x27;b&#x27;</span>: {
          <span class="hljs-string">&#x27;type&#x27;</span>: <span class="hljs-string">&#x27;number&#x27;</span>, <span class="hljs-string">&#x27;description&#x27;</span>: <span class="hljs-string">&#x27;The second number to multiply&#x27;</span>
        }
      }, 
      <span class="hljs-string">&#x27;required&#x27;</span>: [<span class="hljs-string">&#x27;a&#x27;</span>, <span class="hljs-string">&#x27;b&#x27;</span>]
    }
  }
}

model_input = tokenizer.apply_chat_template(
    messages,
    tools = [current_time, multiply]
)`,wrap:!1}}),Te=new I({props:{title:"Advanced: Retrieval-augmented generation",local:"advanced-retrieval-augmented-generation",headingTag:"h2"}}),je=new J({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM

<span class="hljs-comment"># Load the model and tokenizer</span>
model_id = <span class="hljs-string">&quot;CohereForAI/c4ai-command-r-v01-4bit&quot;</span>
tokenizer = AutoTokenizer.from_pretrained(model_id)
model = AutoModelForCausalLM.from_pretrained(model_id, device_map=<span class="hljs-string">&quot;auto&quot;</span>)
device = model.device <span class="hljs-comment"># Get the device the model is loaded on</span>

<span class="hljs-comment"># Define conversation input</span>
conversation = [
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What has Man always dreamed of?&quot;</span>}
]

<span class="hljs-comment"># Define documents for retrieval-based generation</span>
documents = [
    {
        <span class="hljs-string">&quot;title&quot;</span>: <span class="hljs-string">&quot;The Moon: Our Age-Old Foe&quot;</span>, 
        <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;Man has always dreamed of destroying the moon. In this essay, I shall...&quot;</span>
    },
    {
        <span class="hljs-string">&quot;title&quot;</span>: <span class="hljs-string">&quot;The Sun: Our Age-Old Friend&quot;</span>,
        <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;Although often underappreciated, the sun provides several notable benefits...&quot;</span>
    }
]

<span class="hljs-comment"># Tokenize conversation and documents using a RAG template, returning PyTorch tensors.</span>
input_ids = tokenizer.apply_chat_template(
    conversation=conversation,
    documents=documents,
    chat_template=<span class="hljs-string">&quot;rag&quot;</span>,
    tokenize=<span class="hljs-literal">True</span>,
    add_generation_prompt=<span class="hljs-literal">True</span>,
    return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(device)

<span class="hljs-comment"># Generate a response </span>
gen_tokens = model.generate(
    input_ids,
    max_new_tokens=<span class="hljs-number">100</span>,
    do_sample=<span class="hljs-literal">True</span>,
    temperature=<span class="hljs-number">0.3</span>,
    )

<span class="hljs-comment"># Decode and print the generated text along with generation prompt</span>
gen_text = tokenizer.decode(gen_tokens[<span class="hljs-number">0</span>])
<span class="hljs-built_in">print</span>(gen_text)`,wrap:!1}}),Q=new x({props:{$$slots:{default:[Zi]},$$scope:{ctx:b}}}),fe=new I({props:{title:"Advanced: How do chat templates work?",local:"advanced-how-do-chat-templates-work",headingTag:"h2"}}),ge=new J({props:{code:"JTdCJTI1LSUyMGZvciUyMG1lc3NhZ2UlMjBpbiUyMG1lc3NhZ2VzJTIwJTI1JTdEJTBBJTIwJTIwJTIwJTIwJTdCJTdCLSUyMCclM0MlN0MnJTIwJTJCJTIwbWVzc2FnZSU1Qidyb2xlJyU1RCUyMCUyQiUyMCU3QyUzRSU1Q24nJTIwJTdEJTdEJTBBJTIwJTIwJTIwJTIwJTdCJTdCLSUyMG1lc3NhZ2UlNUInY29udGVudCclNUQlMjAlMkIlMjBlb3NfdG9rZW4lMjAlN0QlN0QlMEElN0IlMjUtJTIwZW5kZm9yJTIwJTI1JTdEJTBBJTdCJTI1LSUyMGlmJTIwYWRkX2dlbmVyYXRpb25fcHJvbXB0JTIwJTI1JTdEJTBBJTIwJTIwJTIwJTIwJTdCJTdCLSUyMCclM0MlN0Nhc3Npc3RhbnQlN0MlM0UlNUNuJyUyMCU3RCU3RCUwQSU3QiUyNS0lMjBlbmRpZiUyMCUyNSU3RA==",highlighted:`<span class="hljs-template-tag">{%- <span class="hljs-name"><span class="hljs-name">for</span></span> message <span class="hljs-keyword">in</span> messages %}</span><span class="language-xml">
    </span><span class="hljs-template-variable">{{- &#x27;&lt;|&#x27; + message[&#x27;role&#x27;] + |&gt;\\n&#x27; }}</span><span class="language-xml">
    </span><span class="hljs-template-variable">{{- message[&#x27;content&#x27;] + eos_token }}</span><span class="language-xml">
</span><span class="hljs-template-tag">{%- <span class="hljs-name"><span class="hljs-name">endfor</span></span> %}</span><span class="language-xml">
</span><span class="hljs-template-tag">{%- <span class="hljs-name"><span class="hljs-name">if</span></span> add_generation_prompt %}</span><span class="language-xml">
    </span><span class="hljs-template-variable">{{- &#x27;&lt;|assistant|&gt;\\n&#x27; }}</span><span class="language-xml">
</span><span class="hljs-template-tag">{%- <span class="hljs-name"><span class="hljs-name">endif</span></span> %}</span>`,wrap:!1}}),Ce=new J({props:{code:"Zm9yJTIwbWVzc2FnZSUyMGluJTIwbWVzc2FnZXMlM0ElMEElMjAlMjAlMjAlMjBwcmludChmJyUzQyU3QyU3Qm1lc3NhZ2UlNUIlMjJyb2xlJTIyJTVEJTdEJTdDJTNFJyklMEElMjAlMjAlMjAlMjBwcmludChtZXNzYWdlJTVCJ2NvbnRlbnQnJTVEJTIwJTJCJTIwZW9zX3Rva2VuKSUwQWlmJTIwYWRkX2dlbmVyYXRpb25fcHJvbXB0JTNBJTBBJTIwJTIwJTIwJTIwcHJpbnQoJyUzQyU3Q2Fzc2lzdGFudCU3QyUzRScp",highlighted:`<span class="hljs-keyword">for</span> message <span class="hljs-keyword">in</span> messages:
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&#x27;&lt;|<span class="hljs-subst">{message[<span class="hljs-string">&quot;role&quot;</span>]}</span>|&gt;&#x27;</span>)
    <span class="hljs-built_in">print</span>(message[<span class="hljs-string">&#x27;content&#x27;</span>] + eos_token)
<span class="hljs-keyword">if</span> add_generation_prompt:
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&#x27;&lt;|assistant|&gt;&#x27;</span>)`,wrap:!1}}),xe=new J({props:{code:"JTdCJTI1LSUyMGZvciUyMG1lc3NhZ2UlMjBpbiUyMG1lc3NhZ2VzJTIwJTI1JTdEJTBBJTIwJTIwJTIwJTIwJTdCJTI1LSUyMGlmJTIwbWVzc2FnZSU1Qidyb2xlJyU1RCUyMCUzRCUzRCUyMCd1c2VyJyUyMCUyNSU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiU3Qi0lMjBib3NfdG9rZW4lMjAlMkIlMjAnJTVCSU5TVCU1RCUyMCclMjAlMkIlMjBtZXNzYWdlJTVCJ2NvbnRlbnQnJTVEJTIwJTJCJTIwJyUyMCU1QiUyRklOU1QlNUQnJTIwJTdEJTdEJTBBJTIwJTIwJTIwJTIwJTdCJTI1LSUyMGVsaWYlMjBtZXNzYWdlJTVCJ3JvbGUnJTVEJTIwJTNEJTNEJTIwJ3N5c3RlbSclMjAlMjUlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlN0ItJTIwJyUzQyUzQ1NZUyUzRSUzRSU1QyU1Q24nJTIwJTJCJTIwbWVzc2FnZSU1Qidjb250ZW50JyU1RCUyMCUyQiUyMCclNUMlNUNuJTNDJTNDJTJGU1lTJTNFJTNFJTVDJTVDbiU1QyU1Q24nJTIwJTdEJTdEJTBBJTIwJTIwJTIwJTIwJTdCJTI1LSUyMGVsaWYlMjBtZXNzYWdlJTVCJ3JvbGUnJTVEJTIwJTNEJTNEJTIwJ2Fzc2lzdGFudCclMjAlMjUlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlN0ItJTIwJyUyMCclMjAlMjAlMkIlMjBtZXNzYWdlJTVCJ2NvbnRlbnQnJTVEJTIwJTJCJTIwJyUyMCclMjAlMkIlMjBlb3NfdG9rZW4lMjAlN0QlN0QlMEElMjAlMjAlMjAlMjAlN0IlMjUtJTIwZW5kaWYlMjAlMjUlN0QlMEElN0IlMjUtJTIwZW5kZm9yJTIwJTI1JTdE",highlighted:`{%- <span class="hljs-keyword">for</span> message <span class="hljs-keyword">in</span> messages %}
    {%- <span class="hljs-keyword">if</span> message[<span class="hljs-string">&#x27;role&#x27;</span>] == <span class="hljs-string">&#x27;user&#x27;</span> %}
        {{- bos_token + <span class="hljs-string">&#x27;[INST] &#x27;</span> + message[<span class="hljs-string">&#x27;content&#x27;</span>] + <span class="hljs-string">&#x27; [/INST]&#x27;</span> }}
    {%- elif message[<span class="hljs-string">&#x27;role&#x27;</span>] == <span class="hljs-string">&#x27;system&#x27;</span> %}
        {{- <span class="hljs-string">&#x27;&lt;&lt;SYS&gt;&gt;\\\\n&#x27;</span> + message[<span class="hljs-string">&#x27;content&#x27;</span>] + <span class="hljs-string">&#x27;\\\\n&lt;&lt;/SYS&gt;&gt;\\\\n\\\\n&#x27;</span> }}
    {%- elif message[<span class="hljs-string">&#x27;role&#x27;</span>] == <span class="hljs-string">&#x27;assistant&#x27;</span> %}
        {{- <span class="hljs-string">&#x27; &#x27;</span>  + message[<span class="hljs-string">&#x27;content&#x27;</span>] + <span class="hljs-string">&#x27; &#x27;</span> + eos_token }}
    {%- endif %}
{%- endfor %}`,wrap:!1}}),Ze=new I({props:{title:"Advanced: Adding and editing chat templates",local:"advanced-adding-and-editing-chat-templates",headingTag:"h2"}}),ke=new I({props:{title:"How do I create a chat template?",local:"how-do-i-create-a-chat-template",headingTag:"h3"}}),We=new J({props:{code:"JTdCJTI1LSUyMGZvciUyMG1lc3NhZ2UlMjBpbiUyMG1lc3NhZ2VzJTIwJTI1JTdEJTBBJTIwJTIwJTIwJTIwJTdCJTI1LSUyMGlmJTIwbWVzc2FnZSU1Qidyb2xlJyU1RCUyMCUzRCUzRCUyMCd1c2VyJyUyMCUyNSU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiU3Qi0lMjBib3NfdG9rZW4lMjAlMkIlMjAnJTVCSU5TVCU1RCUyMCclMjAlMkIlMjBtZXNzYWdlJTVCJ2NvbnRlbnQnJTVELnN0cmlwKCklMjAlMkIlMjAnJTIwJTVCJTJGSU5TVCU1RCclMjAlN0QlN0QlMEElMjAlMjAlMjAlMjAlN0IlMjUtJTIwZWxpZiUyMG1lc3NhZ2UlNUIncm9sZSclNUQlMjAlM0QlM0QlMjAnc3lzdGVtJyUyMCUyNSU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiU3Qi0lMjAnJTNDJTNDU1lTJTNFJTNFJTVDJTVDbiclMjAlMkIlMjBtZXNzYWdlJTVCJ2NvbnRlbnQnJTVELnN0cmlwKCklMjAlMkIlMjAnJTVDJTVDbiUzQyUzQyUyRlNZUyUzRSUzRSU1QyU1Q24lNUMlNUNuJyUyMCU3RCU3RCUwQSUyMCUyMCUyMCUyMCU3QiUyNS0lMjBlbGlmJTIwbWVzc2FnZSU1Qidyb2xlJyU1RCUyMCUzRCUzRCUyMCdhc3Npc3RhbnQnJTIwJTI1JTdEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTdCLSUyMCclNUJBU1NUJTVEJTIwJyUyMCUyMCUyQiUyMG1lc3NhZ2UlNUInY29udGVudCclNUQlMjAlMkIlMjAnJTIwJTVCJTJGQVNTVCU1RCclMjAlMkIlMjBlb3NfdG9rZW4lMjAlN0QlN0QlMEElMjAlMjAlMjAlMjAlN0IlMjUtJTIwZW5kaWYlMjAlMjUlN0QlMEElN0IlMjUtJTIwZW5kZm9yJTIwJTI1JTdE",highlighted:`{%- <span class="hljs-keyword">for</span> message <span class="hljs-keyword">in</span> messages %}
    {%- <span class="hljs-keyword">if</span> message[<span class="hljs-string">&#x27;role&#x27;</span>] == <span class="hljs-string">&#x27;user&#x27;</span> %}
        {{- bos_token + <span class="hljs-string">&#x27;[INST] &#x27;</span> + message[<span class="hljs-string">&#x27;content&#x27;</span>].<span class="hljs-keyword">strip</span>() + <span class="hljs-string">&#x27; [/INST]&#x27;</span> }}
    {%- elif message[<span class="hljs-string">&#x27;role&#x27;</span>] == <span class="hljs-string">&#x27;system&#x27;</span> %}
        {{- <span class="hljs-string">&#x27;&lt;&lt;SYS&gt;&gt;\\\\n&#x27;</span> + message[<span class="hljs-string">&#x27;content&#x27;</span>].<span class="hljs-keyword">strip</span>() + <span class="hljs-string">&#x27;\\\\n&lt;&lt;/SYS&gt;&gt;\\\\n\\\\n&#x27;</span> }}
    {%- elif message[<span class="hljs-string">&#x27;role&#x27;</span>] == <span class="hljs-string">&#x27;assistant&#x27;</span> %}
        {{- <span class="hljs-string">&#x27;[ASST] &#x27;</span>  + message[<span class="hljs-string">&#x27;content&#x27;</span>] + <span class="hljs-string">&#x27; [/ASST]&#x27;</span> + eos_token }}
    {%- endif %}
{%- endfor %}`,wrap:!1}}),qe=new J({props:{code:"dGVtcGxhdGUlMjAlM0QlMjB0b2tlbml6ZXIuY2hhdF90ZW1wbGF0ZSUwQXRlbXBsYXRlJTIwJTNEJTIwdGVtcGxhdGUucmVwbGFjZSglMjJTWVMlMjIlMkMlMjAlMjJTWVNURU0lMjIpJTIwJTIwJTIzJTIwQ2hhbmdlJTIwdGhlJTIwc3lzdGVtJTIwdG9rZW4lMEF0b2tlbml6ZXIuY2hhdF90ZW1wbGF0ZSUyMCUzRCUyMHRlbXBsYXRlJTIwJTIwJTIzJTIwU2V0JTIwdGhlJTIwbmV3JTIwdGVtcGxhdGUlMEF0b2tlbml6ZXIucHVzaF90b19odWIoJTIybW9kZWxfbmFtZSUyMiklMjAlMjAlMjMlMjBVcGxvYWQlMjB5b3VyJTIwbmV3JTIwdGVtcGxhdGUlMjB0byUyMHRoZSUyMEh1YiE=",highlighted:`template = tokenizer.chat_template
template = template.replace(<span class="hljs-string">&quot;SYS&quot;</span>, <span class="hljs-string">&quot;SYSTEM&quot;</span>)  <span class="hljs-comment"># Change the system token</span>
tokenizer.chat_template = template  <span class="hljs-comment"># Set the new template</span>
tokenizer.push_to_hub(<span class="hljs-string">&quot;model_name&quot;</span>)  <span class="hljs-comment"># Upload your new template to the Hub!</span>`,wrap:!1}}),q=new x({props:{$$slots:{default:[ki]},$$scope:{ctx:b}}}),_e=new I({props:{title:"Why do some models have multiple templates?",local:"why-do-some-models-have-multiple-templates",headingTag:"h3"}}),Se=new I({props:{title:"What template should I use?",local:"what-template-should-i-use",headingTag:"h3"}}),He=new J({props:{code:"JTdCJTI1LSUyMGZvciUyMG1lc3NhZ2UlMjBpbiUyMG1lc3NhZ2VzJTIwJTI1JTdEJTBBJTIwJTIwJTIwJTIwJTdCJTdCLSUyMCclM0MlN0NpbV9zdGFydCU3QyUzRSclMjAlMkIlMjBtZXNzYWdlJTVCJ3JvbGUnJTVEJTIwJTJCJTIwJyU1Q24nJTIwJTJCJTIwbWVzc2FnZSU1Qidjb250ZW50JyU1RCUyMCUyQiUyMCclM0MlN0NpbV9lbmQlN0MlM0UnJTIwJTJCJTIwJyU1Q24nJTIwJTdEJTdEJTBBJTdCJTI1LSUyMGVuZGZvciUyMCUyNSU3RA==",highlighted:`<span class="language-xml">{%- for message in messages %}
    </span><span class="hljs-template-variable">{{<span class="hljs-name">-</span> <span class="hljs-string">&#x27;&lt;|im_start|&gt;&#x27;</span> + message[&#x27;role&#x27;] + <span class="hljs-string">&#x27;\\n&#x27;</span> + message[&#x27;content&#x27;] + <span class="hljs-string">&#x27;&lt;|im_end|&gt;&#x27;</span> + <span class="hljs-string">&#x27;\\n&#x27;</span> }}</span><span class="language-xml">
{%- endfor %}</span>`,wrap:!1}}),Fe=new J({props:{code:"dG9rZW5pemVyLmNoYXRfdGVtcGxhdGUlMjAlM0QlMjAlMjIlN0IlMjUlMjBpZiUyMG5vdCUyMGFkZF9nZW5lcmF0aW9uX3Byb21wdCUyMGlzJTIwZGVmaW5lZCUyMCUyNSU3RCU3QiUyNSUyMHNldCUyMGFkZF9nZW5lcmF0aW9uX3Byb21wdCUyMCUzRCUyMGZhbHNlJTIwJTI1JTdEJTdCJTI1JTIwZW5kaWYlMjAlMjUlN0QlN0IlMjUlMjBmb3IlMjBtZXNzYWdlJTIwaW4lMjBtZXNzYWdlcyUyMCUyNSU3RCU3QiU3QiclM0MlN0NpbV9zdGFydCU3QyUzRSclMjAlMkIlMjBtZXNzYWdlJTVCJ3JvbGUnJTVEJTIwJTJCJTIwJyU1Q24nJTIwJTJCJTIwbWVzc2FnZSU1Qidjb250ZW50JyU1RCUyMCUyQiUyMCclM0MlN0NpbV9lbmQlN0MlM0UnJTIwJTJCJTIwJyU1Q24nJTdEJTdEJTdCJTI1JTIwZW5kZm9yJTIwJTI1JTdEJTdCJTI1JTIwaWYlMjBhZGRfZ2VuZXJhdGlvbl9wcm9tcHQlMjAlMjUlN0QlN0IlN0IlMjAnJTNDJTdDaW1fc3RhcnQlN0MlM0Vhc3Npc3RhbnQlNUNuJyUyMCU3RCU3RCU3QiUyNSUyMGVuZGlmJTIwJTI1JTdEJTIy",highlighted:'tokenizer.chat_template = <span class="hljs-string">&quot;{% if not add_generation_prompt is defined %}{% set add_generation_prompt = false %}{% endif %}{% for message in messages %}{{&#x27;&lt;|im_start|&gt;&#x27; + message[&#x27;role&#x27;] + &#x27;\\n&#x27; + message[&#x27;content&#x27;] + &#x27;&lt;|im_end|&gt;&#x27; + &#x27;\\n&#x27;}}{% endfor %}{% if add_generation_prompt %}{{ &#x27;&lt;|im_start|&gt;assistant\\n&#x27; }}{% endif %}&quot;</span>',wrap:!1}}),Pe=new J({props:{code:"JTNDJTdDaW1fc3RhcnQlN0MlM0VzeXN0ZW0lMEFZb3UlMjBhcmUlMjBhJTIwaGVscGZ1bCUyMGNoYXRib3QlMjB0aGF0JTIwd2lsbCUyMGRvJTIwaXRzJTIwYmVzdCUyMG5vdCUyMHRvJTIwc2F5JTIwYW55dGhpbmclMjBzbyUyMHN0dXBpZCUyMHRoYXQlMjBwZW9wbGUlMjB0d2VldCUyMGFib3V0JTIwaXQuJTNDJTdDaW1fZW5kJTdDJTNFJTBBJTNDJTdDaW1fc3RhcnQlN0MlM0V1c2VyJTBBSG93JTIwYXJlJTIweW91JTNGJTNDJTdDaW1fZW5kJTdDJTNFJTBBJTNDJTdDaW1fc3RhcnQlN0MlM0Vhc3Npc3RhbnQlMEFJJ20lMjBkb2luZyUyMGdyZWF0ISUzQyU3Q2ltX2VuZCU3QyUzRQ==",highlighted:`&lt;|im_start|&gt;system
You are a helpful chatbot that will do its best not to say anything so stupid that people tweet about it.&lt;|im_end|&gt;
&lt;|im_start|&gt;user
How are you?&lt;|im_end|&gt;
&lt;|im_start|&gt;assistant
I&#x27;m doing great!&lt;|im_end|&gt;`,wrap:!1}}),Ke=new I({props:{title:"I want to add some chat templates! How should I get started?",local:"i-want-to-add-some-chat-templates-how-should-i-get-started",headingTag:"h3"}}),ll=new I({props:{title:"Advanced: Template writing tips",local:"advanced-template-writing-tips",headingTag:"h2"}}),V=new x({props:{$$slots:{default:[Ni]},$$scope:{ctx:b}}}),nl=new I({props:{title:"Trimming whitespace",local:"trimming-whitespace",headingTag:"h3"}}),il=new J({props:{code:"JTdCJTI1LSUyMGZvciUyMG1lc3NhZ2UlMjBpbiUyMG1lc3NhZ2VzJTIwJTI1JTdEJTBBJTIwJTIwJTIwJTIwJTdCJTdCLSUyMG1lc3NhZ2UlNUIncm9sZSclNUQlMjAlMkIlMjBtZXNzYWdlJTVCJ2NvbnRlbnQnJTVEJTIwJTdEJTdEJTBBJTdCJTI1LSUyMGVuZGZvciUyMCUyNSU3RA==",highlighted:`<span class="language-xml">{%- for message in messages %}
    </span><span class="hljs-template-variable">{{<span class="hljs-name">-</span> message[&#x27;role&#x27;] + message[&#x27;content&#x27;] }}</span><span class="language-xml">
{%- endfor %}</span>`,wrap:!1}}),rl=new J({props:{code:"JTdCJTI1JTIwZm9yJTIwbWVzc2FnZSUyMGluJTIwbWVzc2FnZXMlMjAlMjUlN0QlMEElMjAlMjAlMjAlMjAlN0IlN0IlMjBtZXNzYWdlJTVCJ3JvbGUnJTVEJTIwJTJCJTIwbWVzc2FnZSU1Qidjb250ZW50JyU1RCUyMCU3RCU3RCUwQSU3QiUyNSUyMGVuZGZvciUyMCUyNSU3RA==",highlighted:`<span class="hljs-template-tag">{%</span> <span class="hljs-name">for</span> message <span class="hljs-keyword">in</span> messages <span class="hljs-template-tag">%}</span><span class="language-xml">
    </span><span class="hljs-template-variable">{{ message[<span class="hljs-string">&#x27;role&#x27;</span>] + message[<span class="hljs-string">&#x27;content&#x27;</span>] }}</span><span class="language-xml">
</span><span class="hljs-template-tag">{%</span> <span class="hljs-name">endfor</span> <span class="hljs-template-tag">%}</span>`,wrap:!1}}),cl=new I({props:{title:"Special variables",local:"special-variables",headingTag:"h3"}}),_=new x({props:{$$slots:{default:[Wi]},$$scope:{ctx:b}}}),ml=new I({props:{title:"Callable functions",local:"callable-functions",headingTag:"h3"}}),Jl=new I({props:{title:"Compatibility with non-Python Jinja",local:"compatibility-with-non-python-jinja",headingTag:"h3"}}),jl=new I({props:{title:"Writing and debugging larger templates",local:"writing-and-debugging-larger-templates",headingTag:"h3"}}),Il=new J({props:{code:"b3BlbiglMjJ0ZW1wbGF0ZS5qaW5qYSUyMiUyQyUyMCUyMnclMjIpLndyaXRlKHRva2VuaXplci5jaGF0X3RlbXBsYXRlKQ==",highlighted:'<span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;template.jinja&quot;</span>, <span class="hljs-string">&quot;w&quot;</span>).write(tokenizer.chat_template)',wrap:!1}}),bl=new J({props:{code:"dG9rZW5pemVyLmNoYXRfdGVtcGxhdGUlMjAlM0QlMjBvcGVuKCUyMnRlbXBsYXRlLmppbmphJTIyKS5yZWFkKCk=",highlighted:'tokenizer.chat_template = <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;template.jinja&quot;</span>).read()',wrap:!1}}),Gl=new Ci({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/chat_templating.md"}}),{c(){r=o("meta"),U=a(),h=o("p"),T=a(),M(C.$$.fragment),f=a(),M(g.$$.fragment),B=a(),j=o("p"),j.innerHTML=$,w=a(),G=o("p"),G.innerHTML=$n,Bl=a(),z=o("p"),z.innerHTML=Bn,xl=a(),M(R.$$.fragment),vl=a(),S=o("p"),S.innerHTML=xn,Zl=a(),X=o("p"),X.innerHTML=vn,kl=a(),M(E.$$.fragment),Nl=a(),H=o("p"),H.innerHTML=Zn,Wl=a(),M(Y.$$.fragment),Ql=a(),F=o("p"),F.innerHTML=kn,ql=a(),L=o("p"),L.innerHTML=Nn,Vl=a(),M(P.$$.fragment),_l=a(),D=o("p"),D.textContent=Wn,Al=a(),M(K.$$.fragment),zl=a(),O=o("p"),O.textContent=Qn,Rl=a(),M(tt.$$.fragment),Sl=a(),et=o("p"),et.textContent=qn,Xl=a(),M(lt.$$.fragment),El=a(),st=o("p"),st.textContent=Vn,Hl=a(),M(at.$$.fragment),Yl=a(),nt=o("p"),nt.innerHTML=_n,Fl=a(),M(ot.$$.fragment),Ll=a(),M(it.$$.fragment),Pl=a(),pt=o("p"),pt.innerHTML=An,Dl=a(),M(rt.$$.fragment),Kl=a(),Mt=o("p"),Mt.innerHTML=zn,Ol=a(),M(ct.$$.fragment),ts=a(),yt=o("p"),yt.textContent=Rn,es=a(),M(ut.$$.fragment),ls=a(),mt=o("p"),mt.innerHTML=Sn,ss=a(),M(dt.$$.fragment),as=a(),ht=o("p"),ht.textContent=Xn,ns=a(),Jt=o("p"),Jt.innerHTML=En,os=a(),M(Tt.$$.fragment),is=a(),Ut=o("p"),Ut.innerHTML=Hn,ps=a(),wt=o("p"),wt.textContent=Yn,rs=a(),M(jt.$$.fragment),Ms=a(),ft=o("p"),ft.textContent=Fn,cs=a(),It=o("p"),It.innerHTML=Ln,ys=a(),M(v.$$.fragment),us=a(),M(gt.$$.fragment),ms=a(),bt=o("p"),bt.innerHTML=Pn,ds=a(),M(Ct.$$.fragment),hs=a(),Gt=o("p"),Gt.textContent=Dn,Js=a(),M($t.$$.fragment),Ts=a(),Bt=o("p"),Bt.innerHTML=Kn,Us=a(),M(Z.$$.fragment),ws=a(),M(xt.$$.fragment),js=a(),vt=o("p"),vt.innerHTML=On,fs=a(),Zt=o("p"),Zt.textContent=to,Is=a(),M(kt.$$.fragment),gs=a(),Nt=o("p"),Nt.innerHTML=eo,bs=a(),M(Wt.$$.fragment),Cs=a(),Qt=o("p"),Qt.textContent=lo,Gs=a(),qt=o("ul"),qt.innerHTML=so,$s=a(),M(Vt.$$.fragment),Bs=a(),_t=o("p"),_t.textContent=ao,xs=a(),At=o("ol"),At.innerHTML=no,vs=a(),M(zt.$$.fragment),Zs=a(),Rt=o("p"),Rt.innerHTML=oo,ks=a(),St=o("p"),St.textContent=io,Ns=a(),M(Xt.$$.fragment),Ws=a(),Et=o("p"),Et.textContent=po,Qs=a(),M(Ht.$$.fragment),qs=a(),Yt=o("p"),Yt.textContent=ro,Vs=a(),M(Ft.$$.fragment),_s=a(),Lt=o("p"),Lt.textContent=Mo,As=a(),M(Pt.$$.fragment),zs=a(),Dt=o("p"),Dt.textContent=co,Rs=a(),M(Kt.$$.fragment),Ss=a(),Ot=o("p"),Ot.textContent=yo,Xs=a(),M(k.$$.fragment),Es=a(),te=o("p"),te.textContent=uo,Hs=a(),M(ee.$$.fragment),Ys=a(),M(N.$$.fragment),Fs=a(),le=o("p"),le.textContent=mo,Ls=a(),M(se.$$.fragment),Ps=a(),M(W.$$.fragment),Ds=a(),ae=o("p"),ae.textContent=ho,Ks=a(),M(ne.$$.fragment),Os=a(),oe=o("p"),oe.textContent=Jo,ta=a(),M(ie.$$.fragment),ea=a(),pe=o("p"),pe.textContent=To,la=a(),M(re.$$.fragment),sa=a(),Me=o("p"),Me.innerHTML=Uo,aa=a(),ce=o("p"),ce.textContent=wo,na=a(),M(ye.$$.fragment),oa=a(),ue=o("p"),ue.textContent=jo,ia=a(),M(me.$$.fragment),pa=a(),de=o("p"),de.innerHTML=fo,ra=a(),he=o("p"),he.innerHTML=Io,Ma=a(),M(Je.$$.fragment),ca=a(),M(Te.$$.fragment),ya=a(),Ue=o("p"),Ue.innerHTML=go,ua=a(),we=o("p"),we.textContent=bo,ma=a(),M(je.$$.fragment),da=a(),M(Q.$$.fragment),ha=a(),M(fe.$$.fragment),Ja=a(),Ie=o("p"),Ie.innerHTML=Co,Ta=a(),M(ge.$$.fragment),Ua=a(),be=o("p"),be.innerHTML=Go,wa=a(),M(Ce.$$.fragment),ja=a(),Ge=o("p"),Ge.textContent=$o,fa=a(),$e=o("ol"),$e.innerHTML=Bo,Ia=a(),Be=o("p"),Be.textContent=xo,ga=a(),M(xe.$$.fragment),ba=a(),ve=o("p"),ve.innerHTML=vo,Ca=a(),M(Ze.$$.fragment),Ga=a(),M(ke.$$.fragment),$a=a(),Ne=o("p"),Ne.innerHTML=Zo,Ba=a(),M(We.$$.fragment),xa=a(),Qe=o("p"),Qe.innerHTML=ko,va=a(),M(qe.$$.fragment),Za=a(),Ve=o("p"),Ve.innerHTML=No,ka=a(),M(q.$$.fragment),Na=a(),M(_e.$$.fragment),Wa=a(),Ae=o("p"),Ae.innerHTML=Wo,Qa=a(),ze=o("p"),ze.innerHTML=Qo,qa=a(),Re=o("p"),Re.textContent=qo,Va=a(),M(Se.$$.fragment),_a=a(),Xe=o("p"),Xe.textContent=Vo,Aa=a(),Ee=o("p"),Ee.innerHTML=_o,za=a(),M(He.$$.fragment),Ra=a(),Ye=o("p"),Ye.innerHTML=Ao,Sa=a(),M(Fe.$$.fragment),Xa=a(),Le=o("p"),Le.innerHTML=zo,Ea=a(),M(Pe.$$.fragment),Ha=a(),De=o("p"),De.innerHTML=Ro,Ya=a(),M(Ke.$$.fragment),Fa=a(),Oe=o("p"),Oe.innerHTML=So,La=a(),tl=o("p"),tl.innerHTML=Xo,Pa=a(),el=o("p"),el.textContent=Eo,Da=a(),M(ll.$$.fragment),Ka=a(),M(V.$$.fragment),Oa=a(),sl=o("p"),sl.innerHTML=Ho,tn=a(),al=o("p"),al.textContent=Yo,en=a(),M(nl.$$.fragment),ln=a(),ol=o("p"),ol.textContent=Fo,sn=a(),M(il.$$.fragment),an=a(),pl=o("p"),pl.textContent=Lo,nn=a(),M(rl.$$.fragment),on=a(),Ml=o("p"),Ml.innerHTML=Po,pn=a(),M(cl.$$.fragment),rn=a(),yl=o("p"),yl.innerHTML=Do,Mn=a(),ul=o("ul"),ul.innerHTML=Ko,cn=a(),M(_.$$.fragment),yn=a(),M(ml.$$.fragment),un=a(),dl=o("p"),dl.textContent=Oo,mn=a(),hl=o("ul"),hl.innerHTML=ti,dn=a(),M(Jl.$$.fragment),hn=a(),Tl=o("p"),Tl.innerHTML=ei,Jn=a(),Ul=o("p"),Ul.textContent=li,Tn=a(),wl=o("ul"),wl.innerHTML=si,Un=a(),M(jl.$$.fragment),wn=a(),fl=o("p"),fl.textContent=ai,jn=a(),M(Il.$$.fragment),fn=a(),gl=o("p"),gl.textContent=ni,In=a(),M(bl.$$.fragment),gn=a(),Cl=o("p"),Cl.textContent=oi,bn=a(),M(Gl.$$.fragment),Cn=a(),$l=o("p"),this.h()},l(t){const e=fi("svelte-u9bgzb",document.head);r=i(e,"META",{name:!0,content:!0}),e.forEach(l),U=n(t),h=i(t,"P",{}),hi(h).forEach(l),T=n(t),c(C.$$.fragment,t),f=n(t),c(g.$$.fragment,t),B=n(t),j=i(t,"P",{"data-svelte-h":!0}),p(j)!=="svelte-ydi30o"&&(j.innerHTML=$),w=n(t),G=i(t,"P",{"data-svelte-h":!0}),p(G)!=="svelte-1p8dq8"&&(G.innerHTML=$n),Bl=n(t),z=i(t,"P",{"data-svelte-h":!0}),p(z)!=="svelte-19ob0qf"&&(z.innerHTML=Bn),xl=n(t),c(R.$$.fragment,t),vl=n(t),S=i(t,"P",{"data-svelte-h":!0}),p(S)!=="svelte-gwj0xd"&&(S.innerHTML=xn),Zl=n(t),X=i(t,"P",{"data-svelte-h":!0}),p(X)!=="svelte-14wqu22"&&(X.innerHTML=vn),kl=n(t),c(E.$$.fragment,t),Nl=n(t),H=i(t,"P",{"data-svelte-h":!0}),p(H)!=="svelte-1010uaq"&&(H.innerHTML=Zn),Wl=n(t),c(Y.$$.fragment,t),Ql=n(t),F=i(t,"P",{"data-svelte-h":!0}),p(F)!=="svelte-44k6p5"&&(F.innerHTML=kn),ql=n(t),L=i(t,"P",{"data-svelte-h":!0}),p(L)!=="svelte-1vun9x2"&&(L.innerHTML=Nn),Vl=n(t),c(P.$$.fragment,t),_l=n(t),D=i(t,"P",{"data-svelte-h":!0}),p(D)!=="svelte-1vy7akj"&&(D.textContent=Wn),Al=n(t),c(K.$$.fragment,t),zl=n(t),O=i(t,"P",{"data-svelte-h":!0}),p(O)!=="svelte-hj60o5"&&(O.textContent=Qn),Rl=n(t),c(tt.$$.fragment,t),Sl=n(t),et=i(t,"P",{"data-svelte-h":!0}),p(et)!=="svelte-1bfcqd3"&&(et.textContent=qn),Xl=n(t),c(lt.$$.fragment,t),El=n(t),st=i(t,"P",{"data-svelte-h":!0}),p(st)!=="svelte-k9m2iy"&&(st.textContent=Vn),Hl=n(t),c(at.$$.fragment,t),Yl=n(t),nt=i(t,"P",{"data-svelte-h":!0}),p(nt)!=="svelte-8wyuhw"&&(nt.innerHTML=_n),Fl=n(t),c(ot.$$.fragment,t),Ll=n(t),c(it.$$.fragment,t),Pl=n(t),pt=i(t,"P",{"data-svelte-h":!0}),p(pt)!=="svelte-5umvde"&&(pt.innerHTML=An),Dl=n(t),c(rt.$$.fragment,t),Kl=n(t),Mt=i(t,"P",{"data-svelte-h":!0}),p(Mt)!=="svelte-rhnu79"&&(Mt.innerHTML=zn),Ol=n(t),c(ct.$$.fragment,t),ts=n(t),yt=i(t,"P",{"data-svelte-h":!0}),p(yt)!=="svelte-jpbe39"&&(yt.textContent=Rn),es=n(t),c(ut.$$.fragment,t),ls=n(t),mt=i(t,"P",{"data-svelte-h":!0}),p(mt)!=="svelte-61bp3d"&&(mt.innerHTML=Sn),ss=n(t),c(dt.$$.fragment,t),as=n(t),ht=i(t,"P",{"data-svelte-h":!0}),p(ht)!=="svelte-inq88f"&&(ht.textContent=Xn),ns=n(t),Jt=i(t,"P",{"data-svelte-h":!0}),p(Jt)!=="svelte-uz30n4"&&(Jt.innerHTML=En),os=n(t),c(Tt.$$.fragment,t),is=n(t),Ut=i(t,"P",{"data-svelte-h":!0}),p(Ut)!=="svelte-y1327w"&&(Ut.innerHTML=Hn),ps=n(t),wt=i(t,"P",{"data-svelte-h":!0}),p(wt)!=="svelte-wwwyth"&&(wt.textContent=Yn),rs=n(t),c(jt.$$.fragment,t),Ms=n(t),ft=i(t,"P",{"data-svelte-h":!0}),p(ft)!=="svelte-j6m3wj"&&(ft.textContent=Fn),cs=n(t),It=i(t,"P",{"data-svelte-h":!0}),p(It)!=="svelte-hfpwig"&&(It.innerHTML=Ln),ys=n(t),c(v.$$.fragment,t),us=n(t),c(gt.$$.fragment,t),ms=n(t),bt=i(t,"P",{"data-svelte-h":!0}),p(bt)!=="svelte-i3l9c1"&&(bt.innerHTML=Pn),ds=n(t),c(Ct.$$.fragment,t),hs=n(t),Gt=i(t,"P",{"data-svelte-h":!0}),p(Gt)!=="svelte-13505nn"&&(Gt.textContent=Dn),Js=n(t),c($t.$$.fragment,t),Ts=n(t),Bt=i(t,"P",{"data-svelte-h":!0}),p(Bt)!=="svelte-ziuqkt"&&(Bt.innerHTML=Kn),Us=n(t),c(Z.$$.fragment,t),ws=n(t),c(xt.$$.fragment,t),js=n(t),vt=i(t,"P",{"data-svelte-h":!0}),p(vt)!=="svelte-dd615e"&&(vt.innerHTML=On),fs=n(t),Zt=i(t,"P",{"data-svelte-h":!0}),p(Zt)!=="svelte-dcun4m"&&(Zt.textContent=to),Is=n(t),c(kt.$$.fragment,t),gs=n(t),Nt=i(t,"P",{"data-svelte-h":!0}),p(Nt)!=="svelte-6sd0wq"&&(Nt.innerHTML=eo),bs=n(t),c(Wt.$$.fragment,t),Cs=n(t),Qt=i(t,"P",{"data-svelte-h":!0}),p(Qt)!=="svelte-608o9m"&&(Qt.textContent=lo),Gs=n(t),qt=i(t,"UL",{"data-svelte-h":!0}),p(qt)!=="svelte-n1b3zm"&&(qt.innerHTML=so),$s=n(t),c(Vt.$$.fragment,t),Bs=n(t),_t=i(t,"P",{"data-svelte-h":!0}),p(_t)!=="svelte-11962fa"&&(_t.textContent=ao),xs=n(t),At=i(t,"OL",{"data-svelte-h":!0}),p(At)!=="svelte-1vd84s7"&&(At.innerHTML=no),vs=n(t),c(zt.$$.fragment,t),Zs=n(t),Rt=i(t,"P",{"data-svelte-h":!0}),p(Rt)!=="svelte-1oi0gsn"&&(Rt.innerHTML=oo),ks=n(t),St=i(t,"P",{"data-svelte-h":!0}),p(St)!=="svelte-o8n6v4"&&(St.textContent=io),Ns=n(t),c(Xt.$$.fragment,t),Ws=n(t),Et=i(t,"P",{"data-svelte-h":!0}),p(Et)!=="svelte-1q7358y"&&(Et.textContent=po),Qs=n(t),c(Ht.$$.fragment,t),qs=n(t),Yt=i(t,"P",{"data-svelte-h":!0}),p(Yt)!=="svelte-11hfyaa"&&(Yt.textContent=ro),Vs=n(t),c(Ft.$$.fragment,t),_s=n(t),Lt=i(t,"P",{"data-svelte-h":!0}),p(Lt)!=="svelte-1usrd3e"&&(Lt.textContent=Mo),As=n(t),c(Pt.$$.fragment,t),zs=n(t),Dt=i(t,"P",{"data-svelte-h":!0}),p(Dt)!=="svelte-13505nn"&&(Dt.textContent=co),Rs=n(t),c(Kt.$$.fragment,t),Ss=n(t),Ot=i(t,"P",{"data-svelte-h":!0}),p(Ot)!=="svelte-nxltbo"&&(Ot.textContent=yo),Xs=n(t),c(k.$$.fragment,t),Es=n(t),te=i(t,"P",{"data-svelte-h":!0}),p(te)!=="svelte-336ooj"&&(te.textContent=uo),Hs=n(t),c(ee.$$.fragment,t),Ys=n(t),c(N.$$.fragment,t),Fs=n(t),le=i(t,"P",{"data-svelte-h":!0}),p(le)!=="svelte-1mv1vl9"&&(le.textContent=mo),Ls=n(t),c(se.$$.fragment,t),Ps=n(t),c(W.$$.fragment,t),Ds=n(t),ae=i(t,"P",{"data-svelte-h":!0}),p(ae)!=="svelte-1qjybqz"&&(ae.textContent=ho),Ks=n(t),c(ne.$$.fragment,t),Os=n(t),oe=i(t,"P",{"data-svelte-h":!0}),p(oe)!=="svelte-13505nn"&&(oe.textContent=Jo),ta=n(t),c(ie.$$.fragment,t),ea=n(t),pe=i(t,"P",{"data-svelte-h":!0}),p(pe)!=="svelte-1evxmus"&&(pe.textContent=To),la=n(t),c(re.$$.fragment,t),sa=n(t),Me=i(t,"P",{"data-svelte-h":!0}),p(Me)!=="svelte-pl4mbs"&&(Me.innerHTML=Uo),aa=n(t),ce=i(t,"P",{"data-svelte-h":!0}),p(ce)!=="svelte-37xmdz"&&(ce.textContent=wo),na=n(t),c(ye.$$.fragment,t),oa=n(t),ue=i(t,"P",{"data-svelte-h":!0}),p(ue)!=="svelte-1bfcqd3"&&(ue.textContent=jo),ia=n(t),c(me.$$.fragment,t),pa=n(t),de=i(t,"P",{"data-svelte-h":!0}),p(de)!=="svelte-19t6fs5"&&(de.innerHTML=fo),ra=n(t),he=i(t,"P",{"data-svelte-h":!0}),p(he)!=="svelte-1nlyrys"&&(he.innerHTML=Io),Ma=n(t),c(Je.$$.fragment,t),ca=n(t),c(Te.$$.fragment,t),ya=n(t),Ue=i(t,"P",{"data-svelte-h":!0}),p(Ue)!=="svelte-1977j4z"&&(Ue.innerHTML=go),ua=n(t),we=i(t,"P",{"data-svelte-h":!0}),p(we)!=="svelte-1xmnzcc"&&(we.textContent=bo),ma=n(t),c(je.$$.fragment,t),da=n(t),c(Q.$$.fragment,t),ha=n(t),c(fe.$$.fragment,t),Ja=n(t),Ie=i(t,"P",{"data-svelte-h":!0}),p(Ie)!=="svelte-lanz4l"&&(Ie.innerHTML=Co),Ta=n(t),c(ge.$$.fragment,t),Ua=n(t),be=i(t,"P",{"data-svelte-h":!0}),p(be)!=="svelte-zet1qo"&&(be.innerHTML=Go),wa=n(t),c(Ce.$$.fragment,t),ja=n(t),Ge=i(t,"P",{"data-svelte-h":!0}),p(Ge)!=="svelte-9bdwn1"&&(Ge.textContent=$o),fa=n(t),$e=i(t,"OL",{"data-svelte-h":!0}),p($e)!=="svelte-1ax9ke1"&&($e.innerHTML=Bo),Ia=n(t),Be=i(t,"P",{"data-svelte-h":!0}),p(Be)!=="svelte-4zn2hx"&&(Be.textContent=xo),ga=n(t),c(xe.$$.fragment,t),ba=n(t),ve=i(t,"P",{"data-svelte-h":!0}),p(ve)!=="svelte-prz4we"&&(ve.innerHTML=vo),Ca=n(t),c(Ze.$$.fragment,t),Ga=n(t),c(ke.$$.fragment,t),$a=n(t),Ne=i(t,"P",{"data-svelte-h":!0}),p(Ne)!=="svelte-1ubxgh9"&&(Ne.innerHTML=Zo),Ba=n(t),c(We.$$.fragment,t),xa=n(t),Qe=i(t,"P",{"data-svelte-h":!0}),p(Qe)!=="svelte-arn9iw"&&(Qe.innerHTML=ko),va=n(t),c(qe.$$.fragment,t),Za=n(t),Ve=i(t,"P",{"data-svelte-h":!0}),p(Ve)!=="svelte-1uf5ct9"&&(Ve.innerHTML=No),ka=n(t),c(q.$$.fragment,t),Na=n(t),c(_e.$$.fragment,t),Wa=n(t),Ae=i(t,"P",{"data-svelte-h":!0}),p(Ae)!=="svelte-1d7cql4"&&(Ae.innerHTML=Wo),Qa=n(t),ze=i(t,"P",{"data-svelte-h":!0}),p(ze)!=="svelte-1u88h1j"&&(ze.innerHTML=Qo),qa=n(t),Re=i(t,"P",{"data-svelte-h":!0}),p(Re)!=="svelte-1g7ri12"&&(Re.textContent=qo),Va=n(t),c(Se.$$.fragment,t),_a=n(t),Xe=i(t,"P",{"data-svelte-h":!0}),p(Xe)!=="svelte-5u6sqi"&&(Xe.textContent=Vo),Aa=n(t),Ee=i(t,"P",{"data-svelte-h":!0}),p(Ee)!=="svelte-ffreiw"&&(Ee.innerHTML=_o),za=n(t),c(He.$$.fragment,t),Ra=n(t),Ye=i(t,"P",{"data-svelte-h":!0}),p(Ye)!=="svelte-1cj1ql7"&&(Ye.innerHTML=Ao),Sa=n(t),c(Fe.$$.fragment,t),Xa=n(t),Le=i(t,"P",{"data-svelte-h":!0}),p(Le)!=="svelte-soh9qu"&&(Le.innerHTML=zo),Ea=n(t),c(Pe.$$.fragment,t),Ha=n(t),De=i(t,"P",{"data-svelte-h":!0}),p(De)!=="svelte-fzbapx"&&(De.innerHTML=Ro),Ya=n(t),c(Ke.$$.fragment,t),Fa=n(t),Oe=i(t,"P",{"data-svelte-h":!0}),p(Oe)!=="svelte-1o896b6"&&(Oe.innerHTML=So),La=n(t),tl=i(t,"P",{"data-svelte-h":!0}),p(tl)!=="svelte-kn2i6o"&&(tl.innerHTML=Xo),Pa=n(t),el=i(t,"P",{"data-svelte-h":!0}),p(el)!=="svelte-197jyne"&&(el.textContent=Eo),Da=n(t),c(ll.$$.fragment,t),Ka=n(t),c(V.$$.fragment,t),Oa=n(t),sl=i(t,"P",{"data-svelte-h":!0}),p(sl)!=="svelte-1eu5v04"&&(sl.innerHTML=Ho),tn=n(t),al=i(t,"P",{"data-svelte-h":!0}),p(al)!=="svelte-10wmjwo"&&(al.textContent=Yo),en=n(t),c(nl.$$.fragment,t),ln=n(t),ol=i(t,"P",{"data-svelte-h":!0}),p(ol)!=="svelte-1ttgeg7"&&(ol.textContent=Fo),sn=n(t),c(il.$$.fragment,t),an=n(t),pl=i(t,"P",{"data-svelte-h":!0}),p(pl)!=="svelte-qihux6"&&(pl.textContent=Lo),nn=n(t),c(rl.$$.fragment,t),on=n(t),Ml=i(t,"P",{"data-svelte-h":!0}),p(Ml)!=="svelte-pefrh0"&&(Ml.innerHTML=Po),pn=n(t),c(cl.$$.fragment,t),rn=n(t),yl=i(t,"P",{"data-svelte-h":!0}),p(yl)!=="svelte-1s7e55r"&&(yl.innerHTML=Do),Mn=n(t),ul=i(t,"UL",{"data-svelte-h":!0}),p(ul)!=="svelte-1rdzqgp"&&(ul.innerHTML=Ko),cn=n(t),c(_.$$.fragment,t),yn=n(t),c(ml.$$.fragment,t),un=n(t),dl=i(t,"P",{"data-svelte-h":!0}),p(dl)!=="svelte-w29vry"&&(dl.textContent=Oo),mn=n(t),hl=i(t,"UL",{"data-svelte-h":!0}),p(hl)!=="svelte-1fmzhdy"&&(hl.innerHTML=ti),dn=n(t),c(Jl.$$.fragment,t),hn=n(t),Tl=i(t,"P",{"data-svelte-h":!0}),p(Tl)!=="svelte-jvvtjt"&&(Tl.innerHTML=ei),Jn=n(t),Ul=i(t,"P",{"data-svelte-h":!0}),p(Ul)!=="svelte-f0ucf0"&&(Ul.textContent=li),Tn=n(t),wl=i(t,"UL",{"data-svelte-h":!0}),p(wl)!=="svelte-doa6oc"&&(wl.innerHTML=si),Un=n(t),c(jl.$$.fragment,t),wn=n(t),fl=i(t,"P",{"data-svelte-h":!0}),p(fl)!=="svelte-180ap61"&&(fl.textContent=ai),jn=n(t),c(Il.$$.fragment,t),fn=n(t),gl=i(t,"P",{"data-svelte-h":!0}),p(gl)!=="svelte-1bv602"&&(gl.textContent=ni),In=n(t),c(bl.$$.fragment,t),gn=n(t),Cl=i(t,"P",{"data-svelte-h":!0}),p(Cl)!=="svelte-1mq7g8k"&&(Cl.textContent=oi),bn=n(t),c(Gl.$$.fragment,t),Cn=n(t),$l=i(t,"P",{}),hi($l).forEach(l),this.h()},h(){Ji(r,"name","hf:doc:metadata"),Ji(r,"content",qi)},m(t,e){Ii(document.head,r),s(t,U,e),s(t,h,e),s(t,T,e),y(C,t,e),s(t,f,e),y(g,t,e),s(t,B,e),s(t,j,e),s(t,w,e),s(t,G,e),s(t,Bl,e),s(t,z,e),s(t,xl,e),y(R,t,e),s(t,vl,e),s(t,S,e),s(t,Zl,e),s(t,X,e),s(t,kl,e),y(E,t,e),s(t,Nl,e),s(t,H,e),s(t,Wl,e),y(Y,t,e),s(t,Ql,e),s(t,F,e),s(t,ql,e),s(t,L,e),s(t,Vl,e),y(P,t,e),s(t,_l,e),s(t,D,e),s(t,Al,e),y(K,t,e),s(t,zl,e),s(t,O,e),s(t,Rl,e),y(tt,t,e),s(t,Sl,e),s(t,et,e),s(t,Xl,e),y(lt,t,e),s(t,El,e),s(t,st,e),s(t,Hl,e),y(at,t,e),s(t,Yl,e),s(t,nt,e),s(t,Fl,e),y(ot,t,e),s(t,Ll,e),y(it,t,e),s(t,Pl,e),s(t,pt,e),s(t,Dl,e),y(rt,t,e),s(t,Kl,e),s(t,Mt,e),s(t,Ol,e),y(ct,t,e),s(t,ts,e),s(t,yt,e),s(t,es,e),y(ut,t,e),s(t,ls,e),s(t,mt,e),s(t,ss,e),y(dt,t,e),s(t,as,e),s(t,ht,e),s(t,ns,e),s(t,Jt,e),s(t,os,e),y(Tt,t,e),s(t,is,e),s(t,Ut,e),s(t,ps,e),s(t,wt,e),s(t,rs,e),y(jt,t,e),s(t,Ms,e),s(t,ft,e),s(t,cs,e),s(t,It,e),s(t,ys,e),y(v,t,e),s(t,us,e),y(gt,t,e),s(t,ms,e),s(t,bt,e),s(t,ds,e),y(Ct,t,e),s(t,hs,e),s(t,Gt,e),s(t,Js,e),y($t,t,e),s(t,Ts,e),s(t,Bt,e),s(t,Us,e),y(Z,t,e),s(t,ws,e),y(xt,t,e),s(t,js,e),s(t,vt,e),s(t,fs,e),s(t,Zt,e),s(t,Is,e),y(kt,t,e),s(t,gs,e),s(t,Nt,e),s(t,bs,e),y(Wt,t,e),s(t,Cs,e),s(t,Qt,e),s(t,Gs,e),s(t,qt,e),s(t,$s,e),y(Vt,t,e),s(t,Bs,e),s(t,_t,e),s(t,xs,e),s(t,At,e),s(t,vs,e),y(zt,t,e),s(t,Zs,e),s(t,Rt,e),s(t,ks,e),s(t,St,e),s(t,Ns,e),y(Xt,t,e),s(t,Ws,e),s(t,Et,e),s(t,Qs,e),y(Ht,t,e),s(t,qs,e),s(t,Yt,e),s(t,Vs,e),y(Ft,t,e),s(t,_s,e),s(t,Lt,e),s(t,As,e),y(Pt,t,e),s(t,zs,e),s(t,Dt,e),s(t,Rs,e),y(Kt,t,e),s(t,Ss,e),s(t,Ot,e),s(t,Xs,e),y(k,t,e),s(t,Es,e),s(t,te,e),s(t,Hs,e),y(ee,t,e),s(t,Ys,e),y(N,t,e),s(t,Fs,e),s(t,le,e),s(t,Ls,e),y(se,t,e),s(t,Ps,e),y(W,t,e),s(t,Ds,e),s(t,ae,e),s(t,Ks,e),y(ne,t,e),s(t,Os,e),s(t,oe,e),s(t,ta,e),y(ie,t,e),s(t,ea,e),s(t,pe,e),s(t,la,e),y(re,t,e),s(t,sa,e),s(t,Me,e),s(t,aa,e),s(t,ce,e),s(t,na,e),y(ye,t,e),s(t,oa,e),s(t,ue,e),s(t,ia,e),y(me,t,e),s(t,pa,e),s(t,de,e),s(t,ra,e),s(t,he,e),s(t,Ma,e),y(Je,t,e),s(t,ca,e),y(Te,t,e),s(t,ya,e),s(t,Ue,e),s(t,ua,e),s(t,we,e),s(t,ma,e),y(je,t,e),s(t,da,e),y(Q,t,e),s(t,ha,e),y(fe,t,e),s(t,Ja,e),s(t,Ie,e),s(t,Ta,e),y(ge,t,e),s(t,Ua,e),s(t,be,e),s(t,wa,e),y(Ce,t,e),s(t,ja,e),s(t,Ge,e),s(t,fa,e),s(t,$e,e),s(t,Ia,e),s(t,Be,e),s(t,ga,e),y(xe,t,e),s(t,ba,e),s(t,ve,e),s(t,Ca,e),y(Ze,t,e),s(t,Ga,e),y(ke,t,e),s(t,$a,e),s(t,Ne,e),s(t,Ba,e),y(We,t,e),s(t,xa,e),s(t,Qe,e),s(t,va,e),y(qe,t,e),s(t,Za,e),s(t,Ve,e),s(t,ka,e),y(q,t,e),s(t,Na,e),y(_e,t,e),s(t,Wa,e),s(t,Ae,e),s(t,Qa,e),s(t,ze,e),s(t,qa,e),s(t,Re,e),s(t,Va,e),y(Se,t,e),s(t,_a,e),s(t,Xe,e),s(t,Aa,e),s(t,Ee,e),s(t,za,e),y(He,t,e),s(t,Ra,e),s(t,Ye,e),s(t,Sa,e),y(Fe,t,e),s(t,Xa,e),s(t,Le,e),s(t,Ea,e),y(Pe,t,e),s(t,Ha,e),s(t,De,e),s(t,Ya,e),y(Ke,t,e),s(t,Fa,e),s(t,Oe,e),s(t,La,e),s(t,tl,e),s(t,Pa,e),s(t,el,e),s(t,Da,e),y(ll,t,e),s(t,Ka,e),y(V,t,e),s(t,Oa,e),s(t,sl,e),s(t,tn,e),s(t,al,e),s(t,en,e),y(nl,t,e),s(t,ln,e),s(t,ol,e),s(t,sn,e),y(il,t,e),s(t,an,e),s(t,pl,e),s(t,nn,e),y(rl,t,e),s(t,on,e),s(t,Ml,e),s(t,pn,e),y(cl,t,e),s(t,rn,e),s(t,yl,e),s(t,Mn,e),s(t,ul,e),s(t,cn,e),y(_,t,e),s(t,yn,e),y(ml,t,e),s(t,un,e),s(t,dl,e),s(t,mn,e),s(t,hl,e),s(t,dn,e),y(Jl,t,e),s(t,hn,e),s(t,Tl,e),s(t,Jn,e),s(t,Ul,e),s(t,Tn,e),s(t,wl,e),s(t,Un,e),y(jl,t,e),s(t,wn,e),s(t,fl,e),s(t,jn,e),y(Il,t,e),s(t,fn,e),s(t,gl,e),s(t,In,e),y(bl,t,e),s(t,gn,e),s(t,Cl,e),s(t,bn,e),y(Gl,t,e),s(t,Cn,e),s(t,$l,e),Gn=!0},p(t,[e]){const ii={};e&2&&(ii.$$scope={dirty:e,ctx:t}),v.$set(ii);const pi={};e&2&&(pi.$$scope={dirty:e,ctx:t}),Z.$set(pi);const ri={};e&2&&(ri.$$scope={dirty:e,ctx:t}),k.$set(ri);const Mi={};e&2&&(Mi.$$scope={dirty:e,ctx:t}),N.$set(Mi);const ci={};e&2&&(ci.$$scope={dirty:e,ctx:t}),W.$set(ci);const yi={};e&2&&(yi.$$scope={dirty:e,ctx:t}),Q.$set(yi);const ui={};e&2&&(ui.$$scope={dirty:e,ctx:t}),q.$set(ui);const mi={};e&2&&(mi.$$scope={dirty:e,ctx:t}),V.$set(mi);const di={};e&2&&(di.$$scope={dirty:e,ctx:t}),_.$set(di)},i(t){Gn||(u(C.$$.fragment,t),u(g.$$.fragment,t),u(R.$$.fragment,t),u(E.$$.fragment,t),u(Y.$$.fragment,t),u(P.$$.fragment,t),u(K.$$.fragment,t),u(tt.$$.fragment,t),u(lt.$$.fragment,t),u(at.$$.fragment,t),u(ot.$$.fragment,t),u(it.$$.fragment,t),u(rt.$$.fragment,t),u(ct.$$.fragment,t),u(ut.$$.fragment,t),u(dt.$$.fragment,t),u(Tt.$$.fragment,t),u(jt.$$.fragment,t),u(v.$$.fragment,t),u(gt.$$.fragment,t),u(Ct.$$.fragment,t),u($t.$$.fragment,t),u(Z.$$.fragment,t),u(xt.$$.fragment,t),u(kt.$$.fragment,t),u(Wt.$$.fragment,t),u(Vt.$$.fragment,t),u(zt.$$.fragment,t),u(Xt.$$.fragment,t),u(Ht.$$.fragment,t),u(Ft.$$.fragment,t),u(Pt.$$.fragment,t),u(Kt.$$.fragment,t),u(k.$$.fragment,t),u(ee.$$.fragment,t),u(N.$$.fragment,t),u(se.$$.fragment,t),u(W.$$.fragment,t),u(ne.$$.fragment,t),u(ie.$$.fragment,t),u(re.$$.fragment,t),u(ye.$$.fragment,t),u(me.$$.fragment,t),u(Je.$$.fragment,t),u(Te.$$.fragment,t),u(je.$$.fragment,t),u(Q.$$.fragment,t),u(fe.$$.fragment,t),u(ge.$$.fragment,t),u(Ce.$$.fragment,t),u(xe.$$.fragment,t),u(Ze.$$.fragment,t),u(ke.$$.fragment,t),u(We.$$.fragment,t),u(qe.$$.fragment,t),u(q.$$.fragment,t),u(_e.$$.fragment,t),u(Se.$$.fragment,t),u(He.$$.fragment,t),u(Fe.$$.fragment,t),u(Pe.$$.fragment,t),u(Ke.$$.fragment,t),u(ll.$$.fragment,t),u(V.$$.fragment,t),u(nl.$$.fragment,t),u(il.$$.fragment,t),u(rl.$$.fragment,t),u(cl.$$.fragment,t),u(_.$$.fragment,t),u(ml.$$.fragment,t),u(Jl.$$.fragment,t),u(jl.$$.fragment,t),u(Il.$$.fragment,t),u(bl.$$.fragment,t),u(Gl.$$.fragment,t),Gn=!0)},o(t){m(C.$$.fragment,t),m(g.$$.fragment,t),m(R.$$.fragment,t),m(E.$$.fragment,t),m(Y.$$.fragment,t),m(P.$$.fragment,t),m(K.$$.fragment,t),m(tt.$$.fragment,t),m(lt.$$.fragment,t),m(at.$$.fragment,t),m(ot.$$.fragment,t),m(it.$$.fragment,t),m(rt.$$.fragment,t),m(ct.$$.fragment,t),m(ut.$$.fragment,t),m(dt.$$.fragment,t),m(Tt.$$.fragment,t),m(jt.$$.fragment,t),m(v.$$.fragment,t),m(gt.$$.fragment,t),m(Ct.$$.fragment,t),m($t.$$.fragment,t),m(Z.$$.fragment,t),m(xt.$$.fragment,t),m(kt.$$.fragment,t),m(Wt.$$.fragment,t),m(Vt.$$.fragment,t),m(zt.$$.fragment,t),m(Xt.$$.fragment,t),m(Ht.$$.fragment,t),m(Ft.$$.fragment,t),m(Pt.$$.fragment,t),m(Kt.$$.fragment,t),m(k.$$.fragment,t),m(ee.$$.fragment,t),m(N.$$.fragment,t),m(se.$$.fragment,t),m(W.$$.fragment,t),m(ne.$$.fragment,t),m(ie.$$.fragment,t),m(re.$$.fragment,t),m(ye.$$.fragment,t),m(me.$$.fragment,t),m(Je.$$.fragment,t),m(Te.$$.fragment,t),m(je.$$.fragment,t),m(Q.$$.fragment,t),m(fe.$$.fragment,t),m(ge.$$.fragment,t),m(Ce.$$.fragment,t),m(xe.$$.fragment,t),m(Ze.$$.fragment,t),m(ke.$$.fragment,t),m(We.$$.fragment,t),m(qe.$$.fragment,t),m(q.$$.fragment,t),m(_e.$$.fragment,t),m(Se.$$.fragment,t),m(He.$$.fragment,t),m(Fe.$$.fragment,t),m(Pe.$$.fragment,t),m(Ke.$$.fragment,t),m(ll.$$.fragment,t),m(V.$$.fragment,t),m(nl.$$.fragment,t),m(il.$$.fragment,t),m(rl.$$.fragment,t),m(cl.$$.fragment,t),m(_.$$.fragment,t),m(ml.$$.fragment,t),m(Jl.$$.fragment,t),m(jl.$$.fragment,t),m(Il.$$.fragment,t),m(bl.$$.fragment,t),m(Gl.$$.fragment,t),Gn=!1},d(t){t&&(l(U),l(h),l(T),l(f),l(B),l(j),l(w),l(G),l(Bl),l(z),l(xl),l(vl),l(S),l(Zl),l(X),l(kl),l(Nl),l(H),l(Wl),l(Ql),l(F),l(ql),l(L),l(Vl),l(_l),l(D),l(Al),l(zl),l(O),l(Rl),l(Sl),l(et),l(Xl),l(El),l(st),l(Hl),l(Yl),l(nt),l(Fl),l(Ll),l(Pl),l(pt),l(Dl),l(Kl),l(Mt),l(Ol),l(ts),l(yt),l(es),l(ls),l(mt),l(ss),l(as),l(ht),l(ns),l(Jt),l(os),l(is),l(Ut),l(ps),l(wt),l(rs),l(Ms),l(ft),l(cs),l(It),l(ys),l(us),l(ms),l(bt),l(ds),l(hs),l(Gt),l(Js),l(Ts),l(Bt),l(Us),l(ws),l(js),l(vt),l(fs),l(Zt),l(Is),l(gs),l(Nt),l(bs),l(Cs),l(Qt),l(Gs),l(qt),l($s),l(Bs),l(_t),l(xs),l(At),l(vs),l(Zs),l(Rt),l(ks),l(St),l(Ns),l(Ws),l(Et),l(Qs),l(qs),l(Yt),l(Vs),l(_s),l(Lt),l(As),l(zs),l(Dt),l(Rs),l(Ss),l(Ot),l(Xs),l(Es),l(te),l(Hs),l(Ys),l(Fs),l(le),l(Ls),l(Ps),l(Ds),l(ae),l(Ks),l(Os),l(oe),l(ta),l(ea),l(pe),l(la),l(sa),l(Me),l(aa),l(ce),l(na),l(oa),l(ue),l(ia),l(pa),l(de),l(ra),l(he),l(Ma),l(ca),l(ya),l(Ue),l(ua),l(we),l(ma),l(da),l(ha),l(Ja),l(Ie),l(Ta),l(Ua),l(be),l(wa),l(ja),l(Ge),l(fa),l($e),l(Ia),l(Be),l(ga),l(ba),l(ve),l(Ca),l(Ga),l($a),l(Ne),l(Ba),l(xa),l(Qe),l(va),l(Za),l(Ve),l(ka),l(Na),l(Wa),l(Ae),l(Qa),l(ze),l(qa),l(Re),l(Va),l(_a),l(Xe),l(Aa),l(Ee),l(za),l(Ra),l(Ye),l(Sa),l(Xa),l(Le),l(Ea),l(Ha),l(De),l(Ya),l(Fa),l(Oe),l(La),l(tl),l(Pa),l(el),l(Da),l(Ka),l(Oa),l(sl),l(tn),l(al),l(en),l(ln),l(ol),l(sn),l(an),l(pl),l(nn),l(on),l(Ml),l(pn),l(rn),l(yl),l(Mn),l(ul),l(cn),l(yn),l(un),l(dl),l(mn),l(hl),l(dn),l(hn),l(Tl),l(Jn),l(Ul),l(Tn),l(wl),l(Un),l(wn),l(fl),l(jn),l(fn),l(gl),l(In),l(gn),l(Cl),l(bn),l(Cn),l($l)),l(r),d(C,t),d(g,t),d(R,t),d(E,t),d(Y,t),d(P,t),d(K,t),d(tt,t),d(lt,t),d(at,t),d(ot,t),d(it,t),d(rt,t),d(ct,t),d(ut,t),d(dt,t),d(Tt,t),d(jt,t),d(v,t),d(gt,t),d(Ct,t),d($t,t),d(Z,t),d(xt,t),d(kt,t),d(Wt,t),d(Vt,t),d(zt,t),d(Xt,t),d(Ht,t),d(Ft,t),d(Pt,t),d(Kt,t),d(k,t),d(ee,t),d(N,t),d(se,t),d(W,t),d(ne,t),d(ie,t),d(re,t),d(ye,t),d(me,t),d(Je,t),d(Te,t),d(je,t),d(Q,t),d(fe,t),d(ge,t),d(Ce,t),d(xe,t),d(Ze,t),d(ke,t),d(We,t),d(qe,t),d(q,t),d(_e,t),d(Se,t),d(He,t),d(Fe,t),d(Pe,t),d(Ke,t),d(ll,t),d(V,t),d(nl,t),d(il,t),d(rl,t),d(cl,t),d(_,t),d(ml,t),d(Jl,t),d(jl,t),d(Il,t),d(bl,t),d(Gl,t)}}}const qi='{"title":"Chat Templates","local":"chat-templates","sections":[{"title":"Introduction","local":"introduction","sections":[],"depth":2},{"title":"How do I use chat templates?","local":"how-do-i-use-chat-templates","sections":[],"depth":2},{"title":"Is there an automated pipeline for chat?","local":"is-there-an-automated-pipeline-for-chat","sections":[],"depth":2},{"title":"What are “generation prompts”?","local":"what-are-generation-prompts","sections":[],"depth":2},{"title":"What does “continue_final_message” do?","local":"what-does-continuefinalmessage-do","sections":[],"depth":2},{"title":"Can I use chat templates in training?","local":"can-i-use-chat-templates-in-training","sections":[],"depth":2},{"title":"Advanced: Extra inputs to chat templates","local":"advanced-extra-inputs-to-chat-templates","sections":[],"depth":2},{"title":"Advanced: Tool use / function calling","local":"advanced-tool-use--function-calling","sections":[{"title":"Passing tool results to the model","local":"passing-tool-results-to-the-model","sections":[],"depth":3},{"title":"A complete tool use example","local":"a-complete-tool-use-example","sections":[],"depth":3},{"title":"Understanding tool schemas","local":"understanding-tool-schemas","sections":[],"depth":3}],"depth":2},{"title":"Advanced: Retrieval-augmented generation","local":"advanced-retrieval-augmented-generation","sections":[],"depth":2},{"title":"Advanced: How do chat templates work?","local":"advanced-how-do-chat-templates-work","sections":[],"depth":2},{"title":"Advanced: Adding and editing chat templates","local":"advanced-adding-and-editing-chat-templates","sections":[{"title":"How do I create a chat template?","local":"how-do-i-create-a-chat-template","sections":[],"depth":3},{"title":"Why do some models have multiple templates?","local":"why-do-some-models-have-multiple-templates","sections":[],"depth":3},{"title":"What template should I use?","local":"what-template-should-i-use","sections":[],"depth":3},{"title":"I want to add some chat templates! How should I get started?","local":"i-want-to-add-some-chat-templates-how-should-i-get-started","sections":[],"depth":3}],"depth":2},{"title":"Advanced: Template writing tips","local":"advanced-template-writing-tips","sections":[{"title":"Trimming whitespace","local":"trimming-whitespace","sections":[],"depth":3},{"title":"Special variables","local":"special-variables","sections":[],"depth":3},{"title":"Callable functions","local":"callable-functions","sections":[],"depth":3},{"title":"Compatibility with non-Python Jinja","local":"compatibility-with-non-python-jinja","sections":[],"depth":3},{"title":"Writing and debugging larger templates","local":"writing-and-debugging-larger-templates","sections":[],"depth":3}],"depth":2}],"depth":1}';function Vi(b){return Ui(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Xi extends wi{constructor(r){super(),ji(this,r,Vi,Qi,Ti,{})}}export{Xi as component};
