import{s as Do,o as Oo,n as yt}from"../chunks/scheduler.25b97de1.js";import{S as Ko,i as es,g as r,s,r as u,A as ts,h as i,f as n,c as a,j as q,u as m,x as d,k as B,l as ns,y as c,a as o,v as h,d as f,t as g,w as _}from"../chunks/index.d9030fc9.js";import{T as wn}from"../chunks/Tip.baa67368.js";import{D as X}from"../chunks/Docstring.e257edda.js";import{C as Ke}from"../chunks/CodeBlock.e6cd0d95.js";import{E as Yo}from"../chunks/ExampleCodeBlock.20db4b6e.js";import{P as os}from"../chunks/PipelineTag.5f100392.js";import{H as F,E as ss}from"../chunks/EditOnGithub.91d95064.js";function as(J){let l,M;return l=new Ke({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyME1peHRyYWxNb2RlbCUyQyUyME1peHRyYWxDb25maWclMEElMEElMjMlMjBJbml0aWFsaXppbmclMjBhJTIwTWl4dHJhbCUyMDdCJTIwc3R5bGUlMjBjb25maWd1cmF0aW9uJTBBY29uZmlndXJhdGlvbiUyMCUzRCUyME1peHRyYWxDb25maWcoKSUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBtb2RlbCUyMGZyb20lMjB0aGUlMjBNaXh0cmFsJTIwN0IlMjBzdHlsZSUyMGNvbmZpZ3VyYXRpb24lMEFtb2RlbCUyMCUzRCUyME1peHRyYWxNb2RlbChjb25maWd1cmF0aW9uKSUwQSUwQSUyMyUyMEFjY2Vzc2luZyUyMHRoZSUyMG1vZGVsJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBtb2RlbC5jb25maWc=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> MixtralModel, MixtralConfig

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a Mixtral 7B style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = MixtralConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model from the Mixtral 7B style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MixtralModel(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){u(l.$$.fragment)},l(p){m(l.$$.fragment,p)},m(p,b){h(l,p,b),M=!0},p:yt,i(p){M||(f(l.$$.fragment,p),M=!0)},o(p){g(l.$$.fragment,p),M=!1},d(p){_(l,p)}}}function rs(J){let l,M=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){l=r("p"),l.innerHTML=M},l(p){l=i(p,"P",{"data-svelte-h":!0}),d(l)!=="svelte-fincs2"&&(l.innerHTML=M)},m(p,b){o(p,l,b)},p:yt,d(p){p&&n(l)}}}function is(J){let l,M=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){l=r("p"),l.innerHTML=M},l(p){l=i(p,"P",{"data-svelte-h":!0}),d(l)!=="svelte-fincs2"&&(l.innerHTML=M)},m(p,b){o(p,l,b)},p:yt,d(p){p&&n(l)}}}function ls(J){let l,M="Example:",p,b,$;return b=new Ke({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBNaXh0cmFsRm9yQ2F1c2FsTE0lMEElMEFtb2RlbCUyMCUzRCUyME1peHRyYWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIybWlzdHJhbGFpJTJGTWl4dHJhbC04eDdCLXYwLjElMjIpJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIybWlzdHJhbGFpJTJGTWl4dHJhbC04eDdCLXYwLjElMjIpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIySGV5JTJDJTIwYXJlJTIweW91JTIwY29uc2Npb3VzJTNGJTIwQ2FuJTIweW91JTIwdGFsayUyMHRvJTIwbWUlM0YlMjIlMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIocHJvbXB0JTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEElMjMlMjBHZW5lcmF0ZSUwQWdlbmVyYXRlX2lkcyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKGlucHV0cy5pbnB1dF9pZHMlMkMlMjBtYXhfbGVuZ3RoJTNEMzApJTBBdG9rZW5pemVyLmJhdGNoX2RlY29kZShnZW5lcmF0ZV9pZHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSUyQyUyMGNsZWFuX3VwX3Rva2VuaXphdGlvbl9zcGFjZXMlM0RGYWxzZSklNUIwJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, MixtralForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>model = MixtralForCausalLM.from_pretrained(<span class="hljs-string">&quot;mistralai/Mixtral-8x7B-v0.1&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;mistralai/Mixtral-8x7B-v0.1&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;Hey, are you conscious? Can you talk to me?&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Generate</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generate_ids = model.generate(inputs.input_ids, max_length=<span class="hljs-number">30</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(generate_ids, skip_special_tokens=<span class="hljs-literal">True</span>, clean_up_tokenization_spaces=<span class="hljs-literal">False</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&quot;Hey, are you conscious? Can you talk to me?\\nI&#x27;m not conscious, but I can talk to you.&quot;</span>`,wrap:!1}}),{c(){l=r("p"),l.textContent=M,p=s(),u(b.$$.fragment)},l(y){l=i(y,"P",{"data-svelte-h":!0}),d(l)!=="svelte-11lpom8"&&(l.textContent=M),p=a(y),m(b.$$.fragment,y)},m(y,I){o(y,l,I),o(y,p,I),h(b,y,I),$=!0},p:yt,i(y){$||(f(b.$$.fragment,y),$=!0)},o(y){g(b.$$.fragment,y),$=!1},d(y){y&&(n(l),n(p)),_(b,y)}}}function ds(J){let l,M=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){l=r("p"),l.innerHTML=M},l(p){l=i(p,"P",{"data-svelte-h":!0}),d(l)!=="svelte-fincs2"&&(l.innerHTML=M)},m(p,b){o(p,l,b)},p:yt,d(p){p&&n(l)}}}function cs(J){let l,M=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){l=r("p"),l.innerHTML=M},l(p){l=i(p,"P",{"data-svelte-h":!0}),d(l)!=="svelte-fincs2"&&(l.innerHTML=M)},m(p,b){o(p,l,b)},p:yt,d(p){p&&n(l)}}}function ps(J){let l,M,p,b,$,y,I,xt,Y,Kn='Mixtral-8x7B was introduced in the <a href="https://mistral.ai/news/mixtral-of-experts/" rel="nofollow">Mixtral of Experts blogpost</a> by Albert Jiang, Alexandre Sablayrolles, Arthur Mensch, Chris Bamford, Devendra Singh Chaplot, Diego de las Casas, Florian Bressand, Gianna Lengyel, Guillaume Lample, Lélio Renard Lavaud, Lucile Saulnier, Marie-Anne Lachaux, Pierre Stock, Teven Le Scao, Thibaut Lavril, Thomas Wang, Timothée Lacroix, William El Sayed.',vt,D,eo="The introduction of the blog post says:",wt,O,to="<em>Today, the team is proud to release Mixtral 8x7B, a high-quality sparse mixture of experts models (SMoE) with open weights. Licensed under Apache 2.0. Mixtral outperforms Llama 2 70B on most benchmarks with 6x faster inference. It is the strongest open-weight model with a permissive license and the best model overall regarding cost/performance trade-offs. In particular, it matches or outperforms GPT3.5 on most standard benchmarks.</em>",kt,K,no='Mixtral-8x7B is the second large language model (LLM) released by <a href="https://mistral.ai/" rel="nofollow">mistral.ai</a>, after <a href="mistral">Mistral-7B</a>.',Jt,ee,Ct,te,oo="Mixtral-8x7B is a decoder-only Transformer with the following architectural choices:",jt,ne,so='<li>Mixtral is a Mixture of Experts (MoE) model with 8 experts per MLP, with a total of 45 billion parameters. To learn more about mixture-of-experts, refer to the <a href="https://huggingface.co/blog/moe" rel="nofollow">blog post</a>.</li> <li>Despite the model having 45 billion parameters,, the compute required for a single forward pass is the same as that of a 14 billion parameter model. This is because even though each of the experts have to be loaded in RAM (70B like ram requirement) each token from the hidden states are dispatched twice (top 2 routing) and thus the compute (the operation required at each forward computation) is just 2 X sequence_length.</li>',$t,oe,ao='The following implementation details are shared with Mistral AI’s first model <a href="mistral">Mistral-7B</a>:',zt,se,ro="<li>Sliding Window Attention - Trained with 8k context length and fixed cache size, with a theoretical attention span of 128K tokens</li> <li>GQA (Grouped Query Attention) - allowing faster inference and lower cache size.</li> <li>Byte-fallback BPE tokenizer - ensures that characters are never mapped to out of vocabulary tokens.</li>",It,ae,io='For more details refer to the <a href="https://mistral.ai/news/mixtral-of-experts/" rel="nofollow">release blog post</a>.',Ut,re,qt,ie,lo="<code>Mixtral-8x7B</code> is released under the Apache 2.0 license.",Bt,le,Ft,de,co="The Mistral team has released 2 checkpoints:",Wt,ce,po='<li>a base model, <a href="https://huggingface.co/mistralai/Mixtral-8x7B-v0.1" rel="nofollow">Mixtral-8x7B-v0.1</a>, which has been pre-trained to predict the next token on internet-scale data.</li> <li>an instruction tuned model, <a href="https://huggingface.co/mistralai/Mixtral-8x7B-Instruct-v0.1" rel="nofollow">Mixtral-8x7B-Instruct-v0.1</a>, which is the base model optimized for chat purposes using supervised fine-tuning (SFT) and direct preference optimization (DPO).</li>',Zt,pe,uo="The base model can be used as follows:",Lt,ue,Gt,me,mo="The instruction tuned model can be used as follows:",Ht,he,Rt,fe,ho='As can be seen, the instruction-tuned model requires a <a href="../chat_templating">chat template</a> to be applied to make sure the inputs are prepared in the right format.',Xt,ge,Nt,_e,fo='The code snippets above showcase inference without any optimization tricks. However, one can drastically speed up the model by leveraging <a href="../perf_train_gpu_one.md#flash-attention-2">Flash Attention</a>, which is a faster implementation of the attention mechanism used inside the model.',St,Me,go="First, make sure to install the latest version of Flash Attention 2 to include the sliding window attention feature.",Vt,be,Et,ye,_o='Make also sure that you have a hardware that is compatible with Flash-Attention 2. Read more about it in the official documentation of the <a href="https://github.com/Dao-AILab/flash-attention" rel="nofollow">flash attention repository</a>. Make also sure to load your model in half-precision (e.g. <code>torch.float16</code>)',Pt,Te,Mo="To load and run a model using Flash Attention-2, refer to the snippet below:",At,xe,Qt,ve,Yt,we,bo="Below is a expected speedup diagram that compares pure inference time between the native implementation in transformers using <code>mistralai/Mixtral-8x7B-v0.1</code> checkpoint and the Flash Attention 2 version of the model.",Dt,N,yo='<img src="https://huggingface.co/datasets/ybelkada/documentation-images/resolve/main/mixtral-7b-inference-large-seqlen.png"/>',Ot,ke,Kt,Je,To=`The current implementation supports the sliding window attention mechanism and memory efficient cache management.
To enable sliding window attention, just make sure to have a <code>flash-attn</code> version that is compatible with sliding window attention (<code>&gt;=2.3.0</code>).`,en,Ce,xo="The Flash Attention-2 model uses also a more memory efficient cache slicing mechanism - as recommended per the official implementation of Mistral model that use rolling cache mechanism we keep the cache size fixed (<code>self.config.sliding_window</code>), support batched generation only for <code>padding_side=&quot;left&quot;</code> and use the absolute position of the current token to compute the positional embedding.",tn,je,nn,$e,vo='As the Mixtral model has 45 billion parameters, that would require about 90GB of GPU RAM in half precision (float16), since each parameter is stored in 2 bytes. However, one can shrink down the size of the model using <a href="../quantization.md">quantization</a>. If the model is quantized to 4 bits (or half a byte per parameter), a single A100 with 40GB of RAM is enough to fit the entire model, as in that case only about 27 GB of RAM is required.',on,ze,wo='Quantizing a model is as simple as passing a <code>quantization_config</code> to the model. Below, we’ll leverage the BitsAndyBytes quantization (but refer to <a href="../quantization.md">this page</a> for other quantization methods):',sn,Ie,an,Ue,ko=`This model was contributed by <a href="https://huggingface.co/ybelkada" rel="nofollow">Younes Belkada</a> and <a href="https://huggingface.co/ArthurZ" rel="nofollow">Arthur Zucker</a> .
The original code can be found <a href="https://github.com/mistralai/mistral-src" rel="nofollow">here</a>.`,rn,qe,ln,Be,Jo="A list of official Hugging Face and community (indicated by 🌎) resources to help you get started with Mixtral. If you’re interested in submitting a resource to be included here, please feel free to open a Pull Request and we’ll review it! The resource should ideally demonstrate something new instead of duplicating an existing resource.",dn,Fe,cn,We,Co='<li>A demo notebook to perform supervised fine-tuning (SFT) of Mixtral-8x7B can be found <a href="https://github.com/NielsRogge/Transformers-Tutorials/blob/master/Mistral/Supervised_fine_tuning_(SFT)_of_an_LLM_using_Hugging_Face_tooling.ipynb" rel="nofollow">here</a>. 🌎</li> <li>A <a href="https://medium.com/@prakharsaxena11111/finetuning-mixtral-7bx8-6071b0ebf114" rel="nofollow">blog post</a> on fine-tuning Mixtral-8x7B using PEFT. 🌎</li> <li>The <a href="https://github.com/huggingface/alignment-handbook" rel="nofollow">Alignment Handbook</a> by Hugging Face includes scripts and recipes to perform supervised fine-tuning (SFT) and direct preference optimization with Mistral-7B. This includes scripts for full fine-tuning, QLoRa on a single GPU as well as multi-GPU fine-tuning.</li> <li><a href="../tasks/language_modeling">Causal language modeling task guide</a></li>',pn,Ze,un,v,Le,kn,et,jo=`This is the configuration class to store the configuration of a <a href="/docs/transformers/pr_30511/en/model_doc/mixtral#transformers.MixtralModel">MixtralModel</a>. It is used to instantiate an
Mixtral model according to the specified arguments, defining the model architecture. Instantiating a configuration
with the defaults will yield a similar configuration to that of the Mixtral-7B-v0.1 or Mixtral-7B-Instruct-v0.1.`,Jn,tt,$o='<a href="https://huggingface.co/mixtralai/Mixtral-8x7B" rel="nofollow">mixtralai/Mixtral-8x7B</a> <a href="https://huggingface.co/mixtralai/Mixtral-7B-Instruct-v0.1" rel="nofollow">mixtralai/Mixtral-7B-Instruct-v0.1</a>',Cn,nt,zo=`Configuration objects inherit from <a href="/docs/transformers/pr_30511/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/pr_30511/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,jn,S,mn,Ge,Io="## MixtralModel[[transformers.MixtralModel]]",hn,w,He,$n,ot,Uo=`The bare Mixtral Model outputting raw hidden-states without any specific head on top.
This model inherits from <a href="/docs/transformers/pr_30511/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,zn,st,qo=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,In,at,Bo="Transformer decoder consisting of <em>config.num_hidden_layers</em> layers. Each layer is a <code>MixtralDecoderLayer</code>",Un,W,Re,qn,rt,Fo='The <a href="/docs/transformers/pr_30511/en/model_doc/mixtral#transformers.MixtralModel">MixtralModel</a> forward method, overrides the <code>__call__</code> special method.',Bn,V,fn,Xe,Wo="## MixtralForCausalLM[[transformers.MixtralForCausalLM]]",gn,H,Ne,Fn,z,Se,Wn,it,Zo='The <a href="/docs/transformers/pr_30511/en/model_doc/mixtral#transformers.MixtralForCausalLM">MixtralForCausalLM</a> forward method, overrides the <code>__call__</code> special method.',Zn,E,Ln,P,_n,Ve,Lo="## MixtralForSequenceClassification[[transformers.MixtralForSequenceClassification]]",Mn,T,Ee,Gn,lt,Go="The Mixtral Model transformer with a sequence classification head on top (linear layer).",Hn,dt,Ho=`<a href="/docs/transformers/pr_30511/en/model_doc/mixtral#transformers.MixtralForSequenceClassification">MixtralForSequenceClassification</a> uses the last token in order to do the classification, as other causal models
(e.g. GPT-2) do.`,Rn,ct,Ro=`Since it does classification on the last token, it requires to know the position of the last token. If a
<code>pad_token_id</code> is defined in the configuration, it finds the last token that is not a padding token in each row. If
no <code>pad_token_id</code> is defined, it simply takes the last value in each row of the batch. Since it cannot guess the
padding tokens when <code>inputs_embeds</code> are passed instead of <code>input_ids</code>, it does the same (take the last value in
each row of the batch).`,Xn,pt,Xo=`This model inherits from <a href="/docs/transformers/pr_30511/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Nn,ut,No=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Sn,Z,Pe,Vn,mt,So='The <a href="/docs/transformers/pr_30511/en/model_doc/mixtral#transformers.MixtralForSequenceClassification">MixtralForSequenceClassification</a> forward method, overrides the <code>__call__</code> special method.',En,A,bn,Ae,Vo="## MixtralForTokenClassification[[transformers.MixtralForTokenClassification]]",yn,k,Qe,Pn,ht,Eo=`The Mixtral Model transformer with a token classification head on top (a linear layer on top of the hidden-states
output) e.g. for Named-Entity-Recognition (NER) tasks.`,An,ft,Po=`This model inherits from <a href="/docs/transformers/pr_30511/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Qn,gt,Ao=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Yn,L,Ye,Dn,_t,Qo='The <a href="/docs/transformers/pr_30511/en/model_doc/mixtral#transformers.MixtralForTokenClassification">MixtralForTokenClassification</a> forward method, overrides the <code>__call__</code> special method.',On,Q,Tn,De,xn,Tt,vn;return $=new F({props:{title:"Mixtral",local:"mixtral",headingTag:"h1"}}),I=new F({props:{title:"Overview",local:"overview",headingTag:"h2"}}),ee=new F({props:{title:"Architectural details",local:"architectural-details",headingTag:"h3"}}),re=new F({props:{title:"License",local:"license",headingTag:"h3"}}),le=new F({props:{title:"Usage tips",local:"usage-tips",headingTag:"h2"}}),ue=new Ke({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm1pc3RyYWxhaSUyRk1peHRyYWwtOHg3Qi12MC4xJTIyJTJDJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIpJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIybWlzdHJhbGFpJTJGTWl4dHJhbC04eDdCLXYwLjElMjIpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyTXklMjBmYXZvdXJpdGUlMjBjb25kaW1lbnQlMjBpcyUyMiUwQSUwQW1vZGVsX2lucHV0cyUyMCUzRCUyMHRva2VuaXplciglNUJwcm9tcHQlNUQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKS50byglMjJjdWRhJTIyKSUwQW1vZGVsLnRvKGRldmljZSklMEElMEFnZW5lcmF0ZWRfaWRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKiptb2RlbF9pbnB1dHMlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDEwMCUyQyUyMGRvX3NhbXBsZSUzRFRydWUpJTBBdG9rZW5pemVyLmJhdGNoX2RlY29kZShnZW5lcmF0ZWRfaWRzKSU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;mistralai/Mixtral-8x7B-v0.1&quot;</span>, device_map=<span class="hljs-string">&quot;auto&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;mistralai/Mixtral-8x7B-v0.1&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;My favourite condiment is&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>model_inputs = tokenizer([prompt], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.to(device)

<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(**model_inputs, max_new_tokens=<span class="hljs-number">100</span>, do_sample=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(generated_ids)[<span class="hljs-number">0</span>]
<span class="hljs-string">&quot;My favourite condiment is to ...&quot;</span>`,wrap:!1}}),he=new Ke({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm1pc3RyYWxhaSUyRk1peHRyYWwtOHg3Qi1JbnN0cnVjdC12MC4xJTIyJTJDJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIpJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIybWlzdHJhbGFpJTJGTWl4dHJhbC04eDdCLUluc3RydWN0LXYwLjElMjIpJTBBJTBBbWVzc2FnZXMlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJXaGF0JTIwaXMlMjB5b3VyJTIwZmF2b3VyaXRlJTIwY29uZGltZW50JTNGJTIyJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMmFzc2lzdGFudCUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJXZWxsJTJDJTIwSSdtJTIwcXVpdGUlMjBwYXJ0aWFsJTIwdG8lMjBhJTIwZ29vZCUyMHNxdWVlemUlMjBvZiUyMGZyZXNoJTIwbGVtb24lMjBqdWljZS4lMjBJdCUyMGFkZHMlMjBqdXN0JTIwdGhlJTIwcmlnaHQlMjBhbW91bnQlMjBvZiUyMHplc3R5JTIwZmxhdm91ciUyMHRvJTIwd2hhdGV2ZXIlMjBJJ20lMjBjb29raW5nJTIwdXAlMjBpbiUyMHRoZSUyMGtpdGNoZW4hJTIyJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyRG8lMjB5b3UlMjBoYXZlJTIwbWF5b25uYWlzZSUyMHJlY2lwZXMlM0YlMjIlN0QlMEElNUQlMEElMEFtb2RlbF9pbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIuYXBwbHlfY2hhdF90ZW1wbGF0ZShtZXNzYWdlcyUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpLnRvKCUyMmN1ZGElMjIpJTBBJTBBZ2VuZXJhdGVkX2lkcyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKG1vZGVsX2lucHV0cyUyQyUyMG1heF9uZXdfdG9rZW5zJTNEMTAwJTJDJTIwZG9fc2FtcGxlJTNEVHJ1ZSklMEF0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKGdlbmVyYXRlZF9pZHMpJTVCMCU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;mistralai/Mixtral-8x7B-Instruct-v0.1&quot;</span>, device_map=<span class="hljs-string">&quot;auto&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;mistralai/Mixtral-8x7B-Instruct-v0.1&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>messages = [
<span class="hljs-meta">... </span>    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What is your favourite condiment?&quot;</span>},
<span class="hljs-meta">... </span>    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Well, I&#x27;m quite partial to a good squeeze of fresh lemon juice. It adds just the right amount of zesty flavour to whatever I&#x27;m cooking up in the kitchen!&quot;</span>},
<span class="hljs-meta">... </span>    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Do you have mayonnaise recipes?&quot;</span>}
<span class="hljs-meta">... </span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>model_inputs = tokenizer.apply_chat_template(messages, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(model_inputs, max_new_tokens=<span class="hljs-number">100</span>, do_sample=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(generated_ids)[<span class="hljs-number">0</span>]
<span class="hljs-string">&quot;Mayonnaise can be made as follows: (...)&quot;</span>`,wrap:!1}}),ge=new F({props:{title:"Speeding up Mixtral by using Flash Attention",local:"speeding-up-mixtral-by-using-flash-attention",headingTag:"h2"}}),be=new Ke({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1VJTIwZmxhc2gtYXR0biUyMC0tbm8tYnVpbGQtaXNvbGF0aW9u",highlighted:"pip install -U flash-attn --no-build-isolation",wrap:!1}}),xe=new Ke({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0lMkMlMjBBdXRvVG9rZW5pemVyJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIybWlzdHJhbGFpJTJGTWl4dHJhbC04eDdCLXYwLjElMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMjBhdHRuX2ltcGxlbWVudGF0aW9uJTNEJTIyZmxhc2hfYXR0ZW50aW9uXzIlMjIlMkMlMjBkZXZpY2VfbWFwJTNEJTIyYXV0byUyMiklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJtaXN0cmFsYWklMkZNaXh0cmFsLTh4N0ItdjAuMSUyMiklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJNeSUyMGZhdm91cml0ZSUyMGNvbmRpbWVudCUyMGlzJTIyJTBBJTBBbW9kZWxfaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCU1QnByb21wdCU1RCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpLnRvKCUyMmN1ZGElMjIpJTBBbW9kZWwudG8oZGV2aWNlKSUwQSUwQWdlbmVyYXRlZF9pZHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKm1vZGVsX2lucHV0cyUyQyUyMG1heF9uZXdfdG9rZW5zJTNEMTAwJTJDJTIwZG9fc2FtcGxlJTNEVHJ1ZSklMEF0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKGdlbmVyYXRlZF9pZHMpJTVCMCU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;mistralai/Mixtral-8x7B-v0.1&quot;</span>, torch_dtype=torch.float16, attn_implementation=<span class="hljs-string">&quot;flash_attention_2&quot;</span>, device_map=<span class="hljs-string">&quot;auto&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;mistralai/Mixtral-8x7B-v0.1&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;My favourite condiment is&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>model_inputs = tokenizer([prompt], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.to(device)

<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(**model_inputs, max_new_tokens=<span class="hljs-number">100</span>, do_sample=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(generated_ids)[<span class="hljs-number">0</span>]
<span class="hljs-string">&quot;The expected output&quot;</span>`,wrap:!1}}),ve=new F({props:{title:"Expected speedups",local:"expected-speedups",headingTag:"h3"}}),ke=new F({props:{title:"Sliding window Attention",local:"sliding-window-attention",headingTag:"h3"}}),je=new F({props:{title:"Shrinking down Mixtral using quantization",local:"shrinking-down-mixtral-using-quantization",headingTag:"h2"}}),Ie=new Ke({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer, BitsAndBytesConfig

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># specify how to quantize the model</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>quantization_config = BitsAndBytesConfig(
<span class="hljs-meta">... </span>        load_in_4bit=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>        bnb_4bit_quant_type=<span class="hljs-string">&quot;nf4&quot;</span>,
<span class="hljs-meta">... </span>        bnb_4bit_compute_dtype=<span class="hljs-string">&quot;torch.float16&quot;</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;mistralai/Mixtral-8x7B-Instruct-v0.1&quot;</span>, quantization_config=<span class="hljs-literal">True</span>, device_map=<span class="hljs-string">&quot;auto&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;mistralai/Mixtral-8x7B-Instruct-v0.1&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;My favourite condiment is&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>messages = [
<span class="hljs-meta">... </span>    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What is your favourite condiment?&quot;</span>},
<span class="hljs-meta">... </span>    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Well, I&#x27;m quite partial to a good squeeze of fresh lemon juice. It adds just the right amount of zesty flavour to whatever I&#x27;m cooking up in the kitchen!&quot;</span>},
<span class="hljs-meta">... </span>    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Do you have mayonnaise recipes?&quot;</span>}
<span class="hljs-meta">... </span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>model_inputs = tokenizer.apply_chat_template(messages, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(model_inputs, max_new_tokens=<span class="hljs-number">100</span>, do_sample=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(generated_ids)[<span class="hljs-number">0</span>]
<span class="hljs-string">&quot;The expected output&quot;</span>`,wrap:!1}}),qe=new F({props:{title:"Resources",local:"resources",headingTag:"h2"}}),Fe=new os({props:{pipeline:"text-generation"}}),Ze=new F({props:{title:"MixtralConfig",local:"transformers.MixtralConfig",headingTag:"h2"}}),Le=new X({props:{name:"class transformers.MixtralConfig",anchor:"transformers.MixtralConfig",parameters:[{name:"vocab_size",val:" = 32000"},{name:"hidden_size",val:" = 4096"},{name:"intermediate_size",val:" = 14336"},{name:"num_hidden_layers",val:" = 32"},{name:"num_attention_heads",val:" = 32"},{name:"num_key_value_heads",val:" = 8"},{name:"hidden_act",val:" = 'silu'"},{name:"max_position_embeddings",val:" = 131072"},{name:"initializer_range",val:" = 0.02"},{name:"rms_norm_eps",val:" = 1e-05"},{name:"use_cache",val:" = True"},{name:"pad_token_id",val:" = None"},{name:"bos_token_id",val:" = 1"},{name:"eos_token_id",val:" = 2"},{name:"tie_word_embeddings",val:" = False"},{name:"rope_theta",val:" = 1000000.0"},{name:"sliding_window",val:" = None"},{name:"attention_dropout",val:" = 0.0"},{name:"num_experts_per_tok",val:" = 2"},{name:"num_local_experts",val:" = 8"},{name:"output_router_logits",val:" = False"},{name:"router_aux_loss_coef",val:" = 0.001"},{name:"router_jitter_noise",val:" = 0.0"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.MixtralConfig.vocab_size",description:`<strong>vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 32000) &#x2014;
Vocabulary size of the Mixtral model. Defines the number of different tokens that can be represented by the
<code>inputs_ids</code> passed when calling <a href="/docs/transformers/pr_30511/en/model_doc/mixtral#transformers.MixtralModel">MixtralModel</a>`,name:"vocab_size"},{anchor:"transformers.MixtralConfig.hidden_size",description:`<strong>hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 4096) &#x2014;
Dimension of the hidden representations.`,name:"hidden_size"},{anchor:"transformers.MixtralConfig.intermediate_size",description:`<strong>intermediate_size</strong> (<code>int</code>, <em>optional</em>, defaults to 14336) &#x2014;
Dimension of the MLP representations.`,name:"intermediate_size"},{anchor:"transformers.MixtralConfig.num_hidden_layers",description:`<strong>num_hidden_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 32) &#x2014;
Number of hidden layers in the Transformer encoder.`,name:"num_hidden_layers"},{anchor:"transformers.MixtralConfig.num_attention_heads",description:`<strong>num_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 32) &#x2014;
Number of attention heads for each attention layer in the Transformer encoder.`,name:"num_attention_heads"},{anchor:"transformers.MixtralConfig.num_key_value_heads",description:`<strong>num_key_value_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 8) &#x2014;
This is the number of key_value heads that should be used to implement Grouped Query Attention. If
<code>num_key_value_heads=num_attention_heads</code>, the model will use Multi Head Attention (MHA), if
<code>num_key_value_heads=1 the model will use Multi Query Attention (MQA) otherwise GQA is used. When converting a multi-head checkpoint to a GQA checkpoint, each group key and value head should be constructed by meanpooling all the original heads within that group. For more details checkout [this paper](https://arxiv.org/pdf/2305.13245.pdf). If it is not specified, will default to </code>8\`.`,name:"num_key_value_heads"},{anchor:"transformers.MixtralConfig.hidden_act",description:`<strong>hidden_act</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to <code>&quot;silu&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the decoder.`,name:"hidden_act"},{anchor:"transformers.MixtralConfig.max_position_embeddings",description:`<strong>max_position_embeddings</strong> (<code>int</code>, <em>optional</em>, defaults to <code>4096*32</code>) &#x2014;
The maximum sequence length that this model might ever be used with. Mixtral&#x2019;s sliding window attention
allows sequence of up to 4096*32 tokens.`,name:"max_position_embeddings"},{anchor:"transformers.MixtralConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.MixtralConfig.rms_norm_eps",description:`<strong>rms_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-05) &#x2014;
The epsilon used by the rms normalization layers.`,name:"rms_norm_eps"},{anchor:"transformers.MixtralConfig.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not the model should return the last key/values attentions (not used by all models). Only
relevant if <code>config.is_decoder=True</code>.`,name:"use_cache"},{anchor:"transformers.MixtralConfig.pad_token_id",description:`<strong>pad_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The id of the padding token.`,name:"pad_token_id"},{anchor:"transformers.MixtralConfig.bos_token_id",description:`<strong>bos_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The id of the &#x201C;beginning-of-sequence&#x201D; token.`,name:"bos_token_id"},{anchor:"transformers.MixtralConfig.eos_token_id",description:`<strong>eos_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to 2) &#x2014;
The id of the &#x201C;end-of-sequence&#x201D; token.`,name:"eos_token_id"},{anchor:"transformers.MixtralConfig.tie_word_embeddings",description:`<strong>tie_word_embeddings</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether the model&#x2019;s input and output word embeddings should be tied.`,name:"tie_word_embeddings"},{anchor:"transformers.MixtralConfig.rope_theta",description:`<strong>rope_theta</strong> (<code>float</code>, <em>optional</em>, defaults to 1000000.0) &#x2014;
The base period of the RoPE embeddings.`,name:"rope_theta"},{anchor:"transformers.MixtralConfig.sliding_window",description:`<strong>sliding_window</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Sliding window attention window size. If not specified, will default to <code>4096</code>.`,name:"sliding_window"},{anchor:"transformers.MixtralConfig.attention_dropout",description:`<strong>attention_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout ratio for the attention probabilities.`,name:"attention_dropout"},{anchor:"transformers.MixtralConfig.num_experts_per_tok",description:`<strong>num_experts_per_tok</strong> (<code>int</code>, <em>optional</em>, defaults to 2) &#x2014;
The number of experts to route per-token, can be also interpreted as the <code>top-k</code> routing
parameter`,name:"num_experts_per_tok"},{anchor:"transformers.MixtralConfig.num_local_experts",description:`<strong>num_local_experts</strong> (<code>int</code>, <em>optional</em>, defaults to 8) &#x2014;
Number of experts per Sparse MLP layer.`,name:"num_local_experts"},{anchor:"transformers.MixtralConfig.output_router_logits",description:`<strong>output_router_logits</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not the router logits should be returned by the model. Enabeling this will also
allow the model to output the auxiliary loss. See <a href>here</a> for more details`,name:"output_router_logits"},{anchor:"transformers.MixtralConfig.router_aux_loss_coef",description:`<strong>router_aux_loss_coef</strong> (<code>float</code>, <em>optional</em>, defaults to 0.001) &#x2014;
The aux loss factor for the total loss.`,name:"router_aux_loss_coef"},{anchor:"transformers.MixtralConfig.router_jitter_noise",description:`<strong>router_jitter_noise</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Amount of noise to add to the router.`,name:"router_jitter_noise"}],source:"https://github.com/huggingface/transformers/blob/vr_30511/src/transformers/models/mixtral/configuration_mixtral.py#L24"}}),S=new Yo({props:{anchor:"transformers.MixtralConfig.example",$$slots:{default:[as]},$$scope:{ctx:J}}}),He=new X({props:{name:"class transformers.MixtralModel",anchor:"transformers.MixtralModel",parameters:[{name:"config",val:": MixtralConfig"}],parametersDescription:[{anchor:"transformers.MixtralModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/pr_30511/en/model_doc/mixtral#transformers.MixtralConfig">MixtralConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/pr_30511/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.
config &#x2014; MixtralConfig`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/vr_30511/src/transformers/models/mixtral/modeling_mixtral.py#L1057"}}),Re=new X({props:{name:"forward",anchor:"transformers.MixtralModel.forward",parameters:[{name:"input_ids",val:": LongTensor = None"},{name:"attention_mask",val:": Optional = None"},{name:"position_ids",val:": Optional = None"},{name:"past_key_values",val:": Optional = None"},{name:"inputs_embeds",val:": Optional = None"},{name:"use_cache",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"output_router_logits",val:": Optional = None"},{name:"return_dict",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.MixtralModel.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default should you provide
it.</p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_30511/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/pr_30511/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_30511/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.MixtralModel.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a></p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_30511/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/pr_30511/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_30511/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p>If <code>past_key_values</code> is used, optionally only the last <code>decoder_input_ids</code> have to be input (see
<code>past_key_values</code>).</p>
<p>If you want to change padding behavior, you should read <code>modeling_opt._prepare_decoder_attention_mask</code>
and modify to your needs. See diagram 1 in <a href="https://arxiv.org/abs/1910.13461" rel="nofollow">the paper</a> for more
information on the default strategy.</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"attention_mask"},{anchor:"transformers.MixtralModel.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.MixtralModel.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and 2 additional tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used (see <code>past_key_values</code> input) to speed up sequential decoding.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>decoder_input_ids</code> (those that
don&#x2019;t have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all
<code>decoder_input_ids</code> of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.MixtralModel.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.MixtralModel.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.MixtralModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.MixtralModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.MixtralModel.forward.output_router_logits",description:`<strong>output_router_logits</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the logits of all the routers. They are useful for computing the router loss, and
should not be returned during inference.`,name:"output_router_logits"},{anchor:"transformers.MixtralModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/pr_30511/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/vr_30511/src/transformers/models/mixtral/modeling_mixtral.py#L1094"}}),V=new wn({props:{$$slots:{default:[rs]},$$scope:{ctx:J}}}),Ne=new X({props:{name:"class transformers.MixtralForCausalLM",anchor:"transformers.MixtralForCausalLM",parameters:[{name:"config",val:""}],source:"https://github.com/huggingface/transformers/blob/vr_30511/src/transformers/models/mixtral/modeling_mixtral.py#L1258"}}),Se=new X({props:{name:"forward",anchor:"transformers.MixtralForCausalLM.forward",parameters:[{name:"input_ids",val:": LongTensor = None"},{name:"attention_mask",val:": Optional = None"},{name:"position_ids",val:": Optional = None"},{name:"past_key_values",val:": Optional = None"},{name:"inputs_embeds",val:": Optional = None"},{name:"labels",val:": Optional = None"},{name:"use_cache",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"output_router_logits",val:": Optional = None"},{name:"return_dict",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.MixtralForCausalLM.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default should you provide
it.</p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_30511/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/pr_30511/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_30511/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.MixtralForCausalLM.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a></p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_30511/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/pr_30511/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_30511/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p>If <code>past_key_values</code> is used, optionally only the last <code>decoder_input_ids</code> have to be input (see
<code>past_key_values</code>).</p>
<p>If you want to change padding behavior, you should read <code>modeling_opt._prepare_decoder_attention_mask</code>
and modify to your needs. See diagram 1 in <a href="https://arxiv.org/abs/1910.13461" rel="nofollow">the paper</a> for more
information on the default strategy.</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"attention_mask"},{anchor:"transformers.MixtralForCausalLM.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.MixtralForCausalLM.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and 2 additional tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used (see <code>past_key_values</code> input) to speed up sequential decoding.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>decoder_input_ids</code> (those that
don&#x2019;t have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all
<code>decoder_input_ids</code> of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.MixtralForCausalLM.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.MixtralForCausalLM.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.MixtralForCausalLM.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.MixtralForCausalLM.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.MixtralForCausalLM.forward.output_router_logits",description:`<strong>output_router_logits</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the logits of all the routers. They are useful for computing the router loss, and
should not be returned during inference.`,name:"output_router_logits"},{anchor:"transformers.MixtralForCausalLM.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/pr_30511/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.</p>
<p>Args &#x2014;
labels (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>):
Labels for computing the masked language modeling loss. Indices should either be in <code>[0, ..., config.vocab_size]</code> or -100 (see <code>input_ids</code> docstring). Tokens with indices set to <code>-100</code> are ignored
(masked), the loss is only computed for the tokens with labels in <code>[0, ..., config.vocab_size]</code>.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/vr_30511/src/transformers/models/mixtral/modeling_mixtral.py#L1290",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.modeling_outputs.MoeCausalLMOutputWithPast</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/pr_30511/en/model_doc/mixtral#transformers.MixtralConfig"
>MixtralConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Language modeling loss (for next-token prediction).</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>aux_loss</strong> (<code>torch.FloatTensor</code>, <em>optional</em>, returned when <code>labels</code> is provided) — aux_loss for the sparse modules.</p>
</li>
<li>
<p><strong>router_logits</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_router_probs=True</code> and <code>config.add_router_probs=True</code> is passed or when <code>config.output_router_probs=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, sequence_length, num_experts)</code>.</p>
<p>Raw router logtis (post-softmax) that are computed by MoE routers, these terms are used to compute the auxiliary
loss for Mixture of Experts models.</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>)</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks) that can be used (see
<code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.modeling_outputs.MoeCausalLMOutputWithPast</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),E=new wn({props:{$$slots:{default:[is]},$$scope:{ctx:J}}}),P=new Yo({props:{anchor:"transformers.MixtralForCausalLM.forward.example",$$slots:{default:[ls]},$$scope:{ctx:J}}}),Ee=new X({props:{name:"class transformers.MixtralForSequenceClassification",anchor:"transformers.MixtralForSequenceClassification",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.MixtralForSequenceClassification.config",description:`<strong>config</strong> (<a href="/docs/transformers/pr_30511/en/model_doc/mixtral#transformers.MixtralConfig">MixtralConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/pr_30511/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/vr_30511/src/transformers/models/mixtral/modeling_mixtral.py#L1473"}}),Pe=new X({props:{name:"forward",anchor:"transformers.MixtralForSequenceClassification.forward",parameters:[{name:"input_ids",val:": LongTensor = None"},{name:"attention_mask",val:": Optional = None"},{name:"position_ids",val:": Optional = None"},{name:"past_key_values",val:": Union = None"},{name:"inputs_embeds",val:": Optional = None"},{name:"labels",val:": Optional = None"},{name:"use_cache",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"return_dict",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.MixtralForSequenceClassification.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default should you provide
it.</p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_30511/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/pr_30511/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_30511/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.MixtralForSequenceClassification.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a></p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_30511/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/pr_30511/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_30511/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p>If <code>past_key_values</code> is used, optionally only the last <code>decoder_input_ids</code> have to be input (see
<code>past_key_values</code>).</p>
<p>If you want to change padding behavior, you should read <code>modeling_opt._prepare_decoder_attention_mask</code>
and modify to your needs. See diagram 1 in <a href="https://arxiv.org/abs/1910.13461" rel="nofollow">the paper</a> for more
information on the default strategy.</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"attention_mask"},{anchor:"transformers.MixtralForSequenceClassification.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.MixtralForSequenceClassification.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and 2 additional tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used (see <code>past_key_values</code> input) to speed up sequential decoding.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>decoder_input_ids</code> (those that
don&#x2019;t have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all
<code>decoder_input_ids</code> of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.MixtralForSequenceClassification.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.MixtralForSequenceClassification.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.MixtralForSequenceClassification.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.MixtralForSequenceClassification.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.MixtralForSequenceClassification.forward.output_router_logits",description:`<strong>output_router_logits</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the logits of all the routers. They are useful for computing the router loss, and
should not be returned during inference.`,name:"output_router_logits"},{anchor:"transformers.MixtralForSequenceClassification.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/pr_30511/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.MixtralForSequenceClassification.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the sequence classification/regression loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>. If <code>config.num_labels == 1</code> a regression loss is computed (Mean-Square loss), If
<code>config.num_labels &gt; 1</code> a classification loss is computed (Cross-Entropy).`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/vr_30511/src/transformers/models/mixtral/modeling_mixtral.py#L1505"}}),A=new wn({props:{$$slots:{default:[ds]},$$scope:{ctx:J}}}),Qe=new X({props:{name:"class transformers.MixtralForTokenClassification",anchor:"transformers.MixtralForTokenClassification",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.MixtralForTokenClassification.config",description:`<strong>config</strong> (<a href="/docs/transformers/pr_30511/en/model_doc/mixtral#transformers.MixtralConfig">MixtralConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/pr_30511/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/vr_30511/src/transformers/models/mixtral/modeling_mixtral.py#L1597"}}),Ye=new X({props:{name:"forward",anchor:"transformers.MixtralForTokenClassification.forward",parameters:[{name:"input_ids",val:": LongTensor = None"},{name:"attention_mask",val:": Optional = None"},{name:"position_ids",val:": Optional = None"},{name:"past_key_values",val:": Optional = None"},{name:"inputs_embeds",val:": Optional = None"},{name:"labels",val:": Optional = None"},{name:"use_cache",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"return_dict",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.MixtralForTokenClassification.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default should you provide
it.</p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_30511/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/pr_30511/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_30511/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.MixtralForTokenClassification.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a></p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_30511/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/pr_30511/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_30511/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p>If <code>past_key_values</code> is used, optionally only the last <code>decoder_input_ids</code> have to be input (see
<code>past_key_values</code>).</p>
<p>If you want to change padding behavior, you should read <code>modeling_opt._prepare_decoder_attention_mask</code>
and modify to your needs. See diagram 1 in <a href="https://arxiv.org/abs/1910.13461" rel="nofollow">the paper</a> for more
information on the default strategy.</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"attention_mask"},{anchor:"transformers.MixtralForTokenClassification.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.MixtralForTokenClassification.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and 2 additional tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used (see <code>past_key_values</code> input) to speed up sequential decoding.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>decoder_input_ids</code> (those that
don&#x2019;t have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all
<code>decoder_input_ids</code> of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.MixtralForTokenClassification.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.MixtralForTokenClassification.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.MixtralForTokenClassification.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.MixtralForTokenClassification.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.MixtralForTokenClassification.forward.output_router_logits",description:`<strong>output_router_logits</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the logits of all the routers. They are useful for computing the router loss, and
should not be returned during inference.`,name:"output_router_logits"},{anchor:"transformers.MixtralForTokenClassification.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/pr_30511/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.MixtralForTokenClassification.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the sequence classification/regression loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>. If <code>config.num_labels == 1</code> a regression loss is computed (Mean-Square loss), If
<code>config.num_labels &gt; 1</code> a classification loss is computed (Cross-Entropy).`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/vr_30511/src/transformers/models/mixtral/modeling_mixtral.py#L1628"}}),Q=new wn({props:{$$slots:{default:[cs]},$$scope:{ctx:J}}}),De=new ss({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/mixtral.md"}}),{c(){l=r("meta"),M=s(),p=r("p"),b=s(),u($.$$.fragment),y=s(),u(I.$$.fragment),xt=s(),Y=r("p"),Y.innerHTML=Kn,vt=s(),D=r("p"),D.textContent=eo,wt=s(),O=r("p"),O.innerHTML=to,kt=s(),K=r("p"),K.innerHTML=no,Jt=s(),u(ee.$$.fragment),Ct=s(),te=r("p"),te.textContent=oo,jt=s(),ne=r("ul"),ne.innerHTML=so,$t=s(),oe=r("p"),oe.innerHTML=ao,zt=s(),se=r("ul"),se.innerHTML=ro,It=s(),ae=r("p"),ae.innerHTML=io,Ut=s(),u(re.$$.fragment),qt=s(),ie=r("p"),ie.innerHTML=lo,Bt=s(),u(le.$$.fragment),Ft=s(),de=r("p"),de.textContent=co,Wt=s(),ce=r("ul"),ce.innerHTML=po,Zt=s(),pe=r("p"),pe.textContent=uo,Lt=s(),u(ue.$$.fragment),Gt=s(),me=r("p"),me.textContent=mo,Ht=s(),u(he.$$.fragment),Rt=s(),fe=r("p"),fe.innerHTML=ho,Xt=s(),u(ge.$$.fragment),Nt=s(),_e=r("p"),_e.innerHTML=fo,St=s(),Me=r("p"),Me.textContent=go,Vt=s(),u(be.$$.fragment),Et=s(),ye=r("p"),ye.innerHTML=_o,Pt=s(),Te=r("p"),Te.textContent=Mo,At=s(),u(xe.$$.fragment),Qt=s(),u(ve.$$.fragment),Yt=s(),we=r("p"),we.innerHTML=bo,Dt=s(),N=r("div"),N.innerHTML=yo,Ot=s(),u(ke.$$.fragment),Kt=s(),Je=r("p"),Je.innerHTML=To,en=s(),Ce=r("p"),Ce.innerHTML=xo,tn=s(),u(je.$$.fragment),nn=s(),$e=r("p"),$e.innerHTML=vo,on=s(),ze=r("p"),ze.innerHTML=wo,sn=s(),u(Ie.$$.fragment),an=s(),Ue=r("p"),Ue.innerHTML=ko,rn=s(),u(qe.$$.fragment),ln=s(),Be=r("p"),Be.textContent=Jo,dn=s(),u(Fe.$$.fragment),cn=s(),We=r("ul"),We.innerHTML=Co,pn=s(),u(Ze.$$.fragment),un=s(),v=r("div"),u(Le.$$.fragment),kn=s(),et=r("p"),et.innerHTML=jo,Jn=s(),tt=r("p"),tt.innerHTML=$o,Cn=s(),nt=r("p"),nt.innerHTML=zo,jn=s(),u(S.$$.fragment),mn=s(),Ge=r("p"),Ge.textContent=Io,hn=s(),w=r("div"),u(He.$$.fragment),$n=s(),ot=r("p"),ot.innerHTML=Uo,zn=s(),st=r("p"),st.innerHTML=qo,In=s(),at=r("p"),at.innerHTML=Bo,Un=s(),W=r("div"),u(Re.$$.fragment),qn=s(),rt=r("p"),rt.innerHTML=Fo,Bn=s(),u(V.$$.fragment),fn=s(),Xe=r("p"),Xe.textContent=Wo,gn=s(),H=r("div"),u(Ne.$$.fragment),Fn=s(),z=r("div"),u(Se.$$.fragment),Wn=s(),it=r("p"),it.innerHTML=Zo,Zn=s(),u(E.$$.fragment),Ln=s(),u(P.$$.fragment),_n=s(),Ve=r("p"),Ve.textContent=Lo,Mn=s(),T=r("div"),u(Ee.$$.fragment),Gn=s(),lt=r("p"),lt.textContent=Go,Hn=s(),dt=r("p"),dt.innerHTML=Ho,Rn=s(),ct=r("p"),ct.innerHTML=Ro,Xn=s(),pt=r("p"),pt.innerHTML=Xo,Nn=s(),ut=r("p"),ut.innerHTML=No,Sn=s(),Z=r("div"),u(Pe.$$.fragment),Vn=s(),mt=r("p"),mt.innerHTML=So,En=s(),u(A.$$.fragment),bn=s(),Ae=r("p"),Ae.textContent=Vo,yn=s(),k=r("div"),u(Qe.$$.fragment),Pn=s(),ht=r("p"),ht.textContent=Eo,An=s(),ft=r("p"),ft.innerHTML=Po,Qn=s(),gt=r("p"),gt.innerHTML=Ao,Yn=s(),L=r("div"),u(Ye.$$.fragment),Dn=s(),_t=r("p"),_t.innerHTML=Qo,On=s(),u(Q.$$.fragment),Tn=s(),u(De.$$.fragment),xn=s(),Tt=r("p"),this.h()},l(e){const t=ts("svelte-u9bgzb",document.head);l=i(t,"META",{name:!0,content:!0}),t.forEach(n),M=a(e),p=i(e,"P",{}),q(p).forEach(n),b=a(e),m($.$$.fragment,e),y=a(e),m(I.$$.fragment,e),xt=a(e),Y=i(e,"P",{"data-svelte-h":!0}),d(Y)!=="svelte-q6r0tx"&&(Y.innerHTML=Kn),vt=a(e),D=i(e,"P",{"data-svelte-h":!0}),d(D)!=="svelte-mxegxd"&&(D.textContent=eo),wt=a(e),O=i(e,"P",{"data-svelte-h":!0}),d(O)!=="svelte-1xjcuti"&&(O.innerHTML=to),kt=a(e),K=i(e,"P",{"data-svelte-h":!0}),d(K)!=="svelte-1421v88"&&(K.innerHTML=no),Jt=a(e),m(ee.$$.fragment,e),Ct=a(e),te=i(e,"P",{"data-svelte-h":!0}),d(te)!=="svelte-3oc3cl"&&(te.textContent=oo),jt=a(e),ne=i(e,"UL",{"data-svelte-h":!0}),d(ne)!=="svelte-nqni26"&&(ne.innerHTML=so),$t=a(e),oe=i(e,"P",{"data-svelte-h":!0}),d(oe)!=="svelte-13twqsf"&&(oe.innerHTML=ao),zt=a(e),se=i(e,"UL",{"data-svelte-h":!0}),d(se)!=="svelte-hqpplt"&&(se.innerHTML=ro),It=a(e),ae=i(e,"P",{"data-svelte-h":!0}),d(ae)!=="svelte-diqoxa"&&(ae.innerHTML=io),Ut=a(e),m(re.$$.fragment,e),qt=a(e),ie=i(e,"P",{"data-svelte-h":!0}),d(ie)!=="svelte-ne80pp"&&(ie.innerHTML=lo),Bt=a(e),m(le.$$.fragment,e),Ft=a(e),de=i(e,"P",{"data-svelte-h":!0}),d(de)!=="svelte-1yo8vts"&&(de.textContent=co),Wt=a(e),ce=i(e,"UL",{"data-svelte-h":!0}),d(ce)!=="svelte-pt1rre"&&(ce.innerHTML=po),Zt=a(e),pe=i(e,"P",{"data-svelte-h":!0}),d(pe)!=="svelte-18cq7lr"&&(pe.textContent=uo),Lt=a(e),m(ue.$$.fragment,e),Gt=a(e),me=i(e,"P",{"data-svelte-h":!0}),d(me)!=="svelte-14idvxg"&&(me.textContent=mo),Ht=a(e),m(he.$$.fragment,e),Rt=a(e),fe=i(e,"P",{"data-svelte-h":!0}),d(fe)!=="svelte-11xhi4l"&&(fe.innerHTML=ho),Xt=a(e),m(ge.$$.fragment,e),Nt=a(e),_e=i(e,"P",{"data-svelte-h":!0}),d(_e)!=="svelte-1sb6n2y"&&(_e.innerHTML=fo),St=a(e),Me=i(e,"P",{"data-svelte-h":!0}),d(Me)!=="svelte-o3pzzu"&&(Me.textContent=go),Vt=a(e),m(be.$$.fragment,e),Et=a(e),ye=i(e,"P",{"data-svelte-h":!0}),d(ye)!=="svelte-1ehkek3"&&(ye.innerHTML=_o),Pt=a(e),Te=i(e,"P",{"data-svelte-h":!0}),d(Te)!=="svelte-15f76ro"&&(Te.textContent=Mo),At=a(e),m(xe.$$.fragment,e),Qt=a(e),m(ve.$$.fragment,e),Yt=a(e),we=i(e,"P",{"data-svelte-h":!0}),d(we)!=="svelte-1jfvy1t"&&(we.innerHTML=bo),Dt=a(e),N=i(e,"DIV",{style:!0,"data-svelte-h":!0}),d(N)!=="svelte-lcfs6y"&&(N.innerHTML=yo),Ot=a(e),m(ke.$$.fragment,e),Kt=a(e),Je=i(e,"P",{"data-svelte-h":!0}),d(Je)!=="svelte-10i6fhp"&&(Je.innerHTML=To),en=a(e),Ce=i(e,"P",{"data-svelte-h":!0}),d(Ce)!=="svelte-1bvsrfr"&&(Ce.innerHTML=xo),tn=a(e),m(je.$$.fragment,e),nn=a(e),$e=i(e,"P",{"data-svelte-h":!0}),d($e)!=="svelte-1jyk46e"&&($e.innerHTML=vo),on=a(e),ze=i(e,"P",{"data-svelte-h":!0}),d(ze)!=="svelte-10qhmcu"&&(ze.innerHTML=wo),sn=a(e),m(Ie.$$.fragment,e),an=a(e),Ue=i(e,"P",{"data-svelte-h":!0}),d(Ue)!=="svelte-1wxpeky"&&(Ue.innerHTML=ko),rn=a(e),m(qe.$$.fragment,e),ln=a(e),Be=i(e,"P",{"data-svelte-h":!0}),d(Be)!=="svelte-1ci19ty"&&(Be.textContent=Jo),dn=a(e),m(Fe.$$.fragment,e),cn=a(e),We=i(e,"UL",{"data-svelte-h":!0}),d(We)!=="svelte-gyea27"&&(We.innerHTML=Co),pn=a(e),m(Ze.$$.fragment,e),un=a(e),v=i(e,"DIV",{class:!0});var C=q(v);m(Le.$$.fragment,C),kn=a(C),et=i(C,"P",{"data-svelte-h":!0}),d(et)!=="svelte-azplbb"&&(et.innerHTML=jo),Jn=a(C),tt=i(C,"P",{"data-svelte-h":!0}),d(tt)!=="svelte-1nulibo"&&(tt.innerHTML=$o),Cn=a(C),nt=i(C,"P",{"data-svelte-h":!0}),d(nt)!=="svelte-b62xan"&&(nt.innerHTML=zo),jn=a(C),m(S.$$.fragment,C),C.forEach(n),mn=a(e),Ge=i(e,"P",{"data-svelte-h":!0}),d(Ge)!=="svelte-v2rg98"&&(Ge.textContent=Io),hn=a(e),w=i(e,"DIV",{class:!0});var j=q(w);m(He.$$.fragment,j),$n=a(j),ot=i(j,"P",{"data-svelte-h":!0}),d(ot)!=="svelte-kwrdd1"&&(ot.innerHTML=Uo),zn=a(j),st=i(j,"P",{"data-svelte-h":!0}),d(st)!=="svelte-1ydu1el"&&(st.innerHTML=qo),In=a(j),at=i(j,"P",{"data-svelte-h":!0}),d(at)!=="svelte-1g9es5k"&&(at.innerHTML=Bo),Un=a(j),W=i(j,"DIV",{class:!0});var R=q(W);m(Re.$$.fragment,R),qn=a(R),rt=i(R,"P",{"data-svelte-h":!0}),d(rt)!=="svelte-1gs2njw"&&(rt.innerHTML=Fo),Bn=a(R),m(V.$$.fragment,R),R.forEach(n),j.forEach(n),fn=a(e),Xe=i(e,"P",{"data-svelte-h":!0}),d(Xe)!=="svelte-3z5218"&&(Xe.textContent=Wo),gn=a(e),H=i(e,"DIV",{class:!0});var Oe=q(H);m(Ne.$$.fragment,Oe),Fn=a(Oe),z=i(Oe,"DIV",{class:!0});var U=q(z);m(Se.$$.fragment,U),Wn=a(U),it=i(U,"P",{"data-svelte-h":!0}),d(it)!=="svelte-1nq8twc"&&(it.innerHTML=Zo),Zn=a(U),m(E.$$.fragment,U),Ln=a(U),m(P.$$.fragment,U),U.forEach(n),Oe.forEach(n),_n=a(e),Ve=i(e,"P",{"data-svelte-h":!0}),d(Ve)!=="svelte-9e2n9y"&&(Ve.textContent=Lo),Mn=a(e),T=i(e,"DIV",{class:!0});var x=q(T);m(Ee.$$.fragment,x),Gn=a(x),lt=i(x,"P",{"data-svelte-h":!0}),d(lt)!=="svelte-1ttin8p"&&(lt.textContent=Go),Hn=a(x),dt=i(x,"P",{"data-svelte-h":!0}),d(dt)!=="svelte-1t9v0ir"&&(dt.innerHTML=Ho),Rn=a(x),ct=i(x,"P",{"data-svelte-h":!0}),d(ct)!=="svelte-10ugs3m"&&(ct.innerHTML=Ro),Xn=a(x),pt=i(x,"P",{"data-svelte-h":!0}),d(pt)!=="svelte-10mr00e"&&(pt.innerHTML=Xo),Nn=a(x),ut=i(x,"P",{"data-svelte-h":!0}),d(ut)!=="svelte-1ydu1el"&&(ut.innerHTML=No),Sn=a(x),Z=i(x,"DIV",{class:!0});var Mt=q(Z);m(Pe.$$.fragment,Mt),Vn=a(Mt),mt=i(Mt,"P",{"data-svelte-h":!0}),d(mt)!=="svelte-179orqq"&&(mt.innerHTML=So),En=a(Mt),m(A.$$.fragment,Mt),Mt.forEach(n),x.forEach(n),bn=a(e),Ae=i(e,"P",{"data-svelte-h":!0}),d(Ae)!=="svelte-dz0q4c"&&(Ae.textContent=Vo),yn=a(e),k=i(e,"DIV",{class:!0});var G=q(k);m(Qe.$$.fragment,G),Pn=a(G),ht=i(G,"P",{"data-svelte-h":!0}),d(ht)!=="svelte-11xh6fy"&&(ht.textContent=Eo),An=a(G),ft=i(G,"P",{"data-svelte-h":!0}),d(ft)!=="svelte-10mr00e"&&(ft.innerHTML=Po),Qn=a(G),gt=i(G,"P",{"data-svelte-h":!0}),d(gt)!=="svelte-1ydu1el"&&(gt.innerHTML=Ao),Yn=a(G),L=i(G,"DIV",{class:!0});var bt=q(L);m(Ye.$$.fragment,bt),Dn=a(bt),_t=i(bt,"P",{"data-svelte-h":!0}),d(_t)!=="svelte-jhyss4"&&(_t.innerHTML=Qo),On=a(bt),m(Q.$$.fragment,bt),bt.forEach(n),G.forEach(n),Tn=a(e),m(De.$$.fragment,e),xn=a(e),Tt=i(e,"P",{}),q(Tt).forEach(n),this.h()},h(){B(l,"name","hf:doc:metadata"),B(l,"content",us),ns(N,"text-align","center"),B(v,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),B(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),B(w,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),B(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),B(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),B(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),B(T,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),B(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),B(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){c(document.head,l),o(e,M,t),o(e,p,t),o(e,b,t),h($,e,t),o(e,y,t),h(I,e,t),o(e,xt,t),o(e,Y,t),o(e,vt,t),o(e,D,t),o(e,wt,t),o(e,O,t),o(e,kt,t),o(e,K,t),o(e,Jt,t),h(ee,e,t),o(e,Ct,t),o(e,te,t),o(e,jt,t),o(e,ne,t),o(e,$t,t),o(e,oe,t),o(e,zt,t),o(e,se,t),o(e,It,t),o(e,ae,t),o(e,Ut,t),h(re,e,t),o(e,qt,t),o(e,ie,t),o(e,Bt,t),h(le,e,t),o(e,Ft,t),o(e,de,t),o(e,Wt,t),o(e,ce,t),o(e,Zt,t),o(e,pe,t),o(e,Lt,t),h(ue,e,t),o(e,Gt,t),o(e,me,t),o(e,Ht,t),h(he,e,t),o(e,Rt,t),o(e,fe,t),o(e,Xt,t),h(ge,e,t),o(e,Nt,t),o(e,_e,t),o(e,St,t),o(e,Me,t),o(e,Vt,t),h(be,e,t),o(e,Et,t),o(e,ye,t),o(e,Pt,t),o(e,Te,t),o(e,At,t),h(xe,e,t),o(e,Qt,t),h(ve,e,t),o(e,Yt,t),o(e,we,t),o(e,Dt,t),o(e,N,t),o(e,Ot,t),h(ke,e,t),o(e,Kt,t),o(e,Je,t),o(e,en,t),o(e,Ce,t),o(e,tn,t),h(je,e,t),o(e,nn,t),o(e,$e,t),o(e,on,t),o(e,ze,t),o(e,sn,t),h(Ie,e,t),o(e,an,t),o(e,Ue,t),o(e,rn,t),h(qe,e,t),o(e,ln,t),o(e,Be,t),o(e,dn,t),h(Fe,e,t),o(e,cn,t),o(e,We,t),o(e,pn,t),h(Ze,e,t),o(e,un,t),o(e,v,t),h(Le,v,null),c(v,kn),c(v,et),c(v,Jn),c(v,tt),c(v,Cn),c(v,nt),c(v,jn),h(S,v,null),o(e,mn,t),o(e,Ge,t),o(e,hn,t),o(e,w,t),h(He,w,null),c(w,$n),c(w,ot),c(w,zn),c(w,st),c(w,In),c(w,at),c(w,Un),c(w,W),h(Re,W,null),c(W,qn),c(W,rt),c(W,Bn),h(V,W,null),o(e,fn,t),o(e,Xe,t),o(e,gn,t),o(e,H,t),h(Ne,H,null),c(H,Fn),c(H,z),h(Se,z,null),c(z,Wn),c(z,it),c(z,Zn),h(E,z,null),c(z,Ln),h(P,z,null),o(e,_n,t),o(e,Ve,t),o(e,Mn,t),o(e,T,t),h(Ee,T,null),c(T,Gn),c(T,lt),c(T,Hn),c(T,dt),c(T,Rn),c(T,ct),c(T,Xn),c(T,pt),c(T,Nn),c(T,ut),c(T,Sn),c(T,Z),h(Pe,Z,null),c(Z,Vn),c(Z,mt),c(Z,En),h(A,Z,null),o(e,bn,t),o(e,Ae,t),o(e,yn,t),o(e,k,t),h(Qe,k,null),c(k,Pn),c(k,ht),c(k,An),c(k,ft),c(k,Qn),c(k,gt),c(k,Yn),c(k,L),h(Ye,L,null),c(L,Dn),c(L,_t),c(L,On),h(Q,L,null),o(e,Tn,t),h(De,e,t),o(e,xn,t),o(e,Tt,t),vn=!0},p(e,[t]){const C={};t&2&&(C.$$scope={dirty:t,ctx:e}),S.$set(C);const j={};t&2&&(j.$$scope={dirty:t,ctx:e}),V.$set(j);const R={};t&2&&(R.$$scope={dirty:t,ctx:e}),E.$set(R);const Oe={};t&2&&(Oe.$$scope={dirty:t,ctx:e}),P.$set(Oe);const U={};t&2&&(U.$$scope={dirty:t,ctx:e}),A.$set(U);const x={};t&2&&(x.$$scope={dirty:t,ctx:e}),Q.$set(x)},i(e){vn||(f($.$$.fragment,e),f(I.$$.fragment,e),f(ee.$$.fragment,e),f(re.$$.fragment,e),f(le.$$.fragment,e),f(ue.$$.fragment,e),f(he.$$.fragment,e),f(ge.$$.fragment,e),f(be.$$.fragment,e),f(xe.$$.fragment,e),f(ve.$$.fragment,e),f(ke.$$.fragment,e),f(je.$$.fragment,e),f(Ie.$$.fragment,e),f(qe.$$.fragment,e),f(Fe.$$.fragment,e),f(Ze.$$.fragment,e),f(Le.$$.fragment,e),f(S.$$.fragment,e),f(He.$$.fragment,e),f(Re.$$.fragment,e),f(V.$$.fragment,e),f(Ne.$$.fragment,e),f(Se.$$.fragment,e),f(E.$$.fragment,e),f(P.$$.fragment,e),f(Ee.$$.fragment,e),f(Pe.$$.fragment,e),f(A.$$.fragment,e),f(Qe.$$.fragment,e),f(Ye.$$.fragment,e),f(Q.$$.fragment,e),f(De.$$.fragment,e),vn=!0)},o(e){g($.$$.fragment,e),g(I.$$.fragment,e),g(ee.$$.fragment,e),g(re.$$.fragment,e),g(le.$$.fragment,e),g(ue.$$.fragment,e),g(he.$$.fragment,e),g(ge.$$.fragment,e),g(be.$$.fragment,e),g(xe.$$.fragment,e),g(ve.$$.fragment,e),g(ke.$$.fragment,e),g(je.$$.fragment,e),g(Ie.$$.fragment,e),g(qe.$$.fragment,e),g(Fe.$$.fragment,e),g(Ze.$$.fragment,e),g(Le.$$.fragment,e),g(S.$$.fragment,e),g(He.$$.fragment,e),g(Re.$$.fragment,e),g(V.$$.fragment,e),g(Ne.$$.fragment,e),g(Se.$$.fragment,e),g(E.$$.fragment,e),g(P.$$.fragment,e),g(Ee.$$.fragment,e),g(Pe.$$.fragment,e),g(A.$$.fragment,e),g(Qe.$$.fragment,e),g(Ye.$$.fragment,e),g(Q.$$.fragment,e),g(De.$$.fragment,e),vn=!1},d(e){e&&(n(M),n(p),n(b),n(y),n(xt),n(Y),n(vt),n(D),n(wt),n(O),n(kt),n(K),n(Jt),n(Ct),n(te),n(jt),n(ne),n($t),n(oe),n(zt),n(se),n(It),n(ae),n(Ut),n(qt),n(ie),n(Bt),n(Ft),n(de),n(Wt),n(ce),n(Zt),n(pe),n(Lt),n(Gt),n(me),n(Ht),n(Rt),n(fe),n(Xt),n(Nt),n(_e),n(St),n(Me),n(Vt),n(Et),n(ye),n(Pt),n(Te),n(At),n(Qt),n(Yt),n(we),n(Dt),n(N),n(Ot),n(Kt),n(Je),n(en),n(Ce),n(tn),n(nn),n($e),n(on),n(ze),n(sn),n(an),n(Ue),n(rn),n(ln),n(Be),n(dn),n(cn),n(We),n(pn),n(un),n(v),n(mn),n(Ge),n(hn),n(w),n(fn),n(Xe),n(gn),n(H),n(_n),n(Ve),n(Mn),n(T),n(bn),n(Ae),n(yn),n(k),n(Tn),n(xn),n(Tt)),n(l),_($,e),_(I,e),_(ee,e),_(re,e),_(le,e),_(ue,e),_(he,e),_(ge,e),_(be,e),_(xe,e),_(ve,e),_(ke,e),_(je,e),_(Ie,e),_(qe,e),_(Fe,e),_(Ze,e),_(Le),_(S),_(He),_(Re),_(V),_(Ne),_(Se),_(E),_(P),_(Ee),_(Pe),_(A),_(Qe),_(Ye),_(Q),_(De,e)}}}const us='{"title":"Mixtral","local":"mixtral","sections":[{"title":"Overview","local":"overview","sections":[{"title":"Architectural details","local":"architectural-details","sections":[],"depth":3},{"title":"License","local":"license","sections":[],"depth":3}],"depth":2},{"title":"Usage tips","local":"usage-tips","sections":[],"depth":2},{"title":"Speeding up Mixtral by using Flash Attention","local":"speeding-up-mixtral-by-using-flash-attention","sections":[{"title":"Expected speedups","local":"expected-speedups","sections":[],"depth":3},{"title":"Sliding window Attention","local":"sliding-window-attention","sections":[],"depth":3}],"depth":2},{"title":"Shrinking down Mixtral using quantization","local":"shrinking-down-mixtral-using-quantization","sections":[],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2},{"title":"MixtralConfig","local":"transformers.MixtralConfig","sections":[],"depth":2}],"depth":1}';function ms(J){return Oo(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class xs extends Ko{constructor(l){super(),es(this,l,ms,ps,Do,{})}}export{xs as component};
