import{s as Ja,o as Ua,n as ht}from"../chunks/scheduler.2427eaa0.js";import{S as ja,i as ma,g as p,s as a,r as u,B as Ta,h as o,f as s,c as n,j as da,u as c,x as M,k as ol,y as wa,a as l,v as y,d as h,t as d,w as J}from"../chunks/index.0f2ff8a3.js";import{T as yt}from"../chunks/Tip.4e204c61.js";import{C as w}from"../chunks/CodeBlock.1bc84186.js";import{H as j,E as fa}from"../chunks/index.61bead48.js";function Ia(T){let i,U='Want to be listed as an Inference Provider on the Hugging Face Hub? Please reach out to us on social networks or <a href="https://huggingface.co/spaces/huggingface/HuggingDiscussions/discussions/49" rel="nofollow">here on the Hub</a>.';return{c(){i=p("p"),i.innerHTML=U},l(r){i=o(r,"P",{"data-svelte-h":!0}),M(i)!=="svelte-3qkokv"&&(i.innerHTML=U)},m(r,m){l(r,i,m)},p:ht,d(r){r&&s(i)}}}function ga(T){let i,U='If your implementation strictly follows the OpenAI API for LLMs and VLMs, you may be able to skip most of this section. In that case, simply open a PR on <a href="https://github.com/huggingface/huggingface.js/tree/main/packages/inference" rel="nofollow">huggingface.js</a> to register.';return{c(){i=p("p"),i.innerHTML=U},l(r){i=o(r,"P",{"data-svelte-h":!0}),M(i)!=="svelte-90vl22"&&(i.innerHTML=U)},m(r,m){l(r,i,m)},p:ht,d(r){r&&s(i)}}}function Ca(T){let i,U=`Note that <code>chatCompletion</code> is an exception as it is not a pipeline_tag, per se. Instead, it
includes models with either <code>pipeline_tag=&quot;text-generation&quot;</code> or <code>pipeline_tag=&quot;image-text-to-text&quot;</code>
which are tagged as “conversational”.`;return{c(){i=p("p"),i.innerHTML=U},l(r){i=o(r,"P",{"data-svelte-h":!0}),M(i)!=="svelte-19q0jcc"&&(i.innerHTML=U)},m(r,m){l(r,i,m)},p:ht,d(r){r&&s(i)}}}function ba(T){let i,U="To proceed with this step, we have to enable your account server-side. Make sure you have an organization on the Hub for your enterprise.";return{c(){i=p("p"),i.textContent=U},l(r){i=o(r,"P",{"data-svelte-h":!0}),M(i)!=="svelte-1letj1o"&&(i.textContent=U)},m(r,m){l(r,i,m)},p:ht,d(r){r&&s(i)}}}function va(T){let i,U='Important: Make sure that the JS client library can handle LoRA weights for your provider. Check out <a href="https://github.com/huggingface/huggingface.js/blob/904964c9f8cd10ed67114ccb88b9028e89fd6cad/packages/inference/src/providers/fal-ai.ts#L78-L124" rel="nofollow">fal’s implementation</a> for more details.';return{c(){i=p("p"),i.innerHTML=U},l(r){i=o(r,"P",{"data-svelte-h":!0}),M(i)!=="svelte-1c6mi2m"&&(i.innerHTML=U)},m(r,m){l(r,i,m)},p:ht,d(r){r&&s(i)}}}function $a(T){let i,U="This is publicly accessible. It’s useful to be transparent by default and it helps debug client SDKs, etc.";return{c(){i=p("p"),i.textContent=U},l(r){i=o(r,"P",{"data-svelte-h":!0}),M(i)!=="svelte-94fcay"&&(i.textContent=U)},m(r,m){l(r,i,m)},p:ht,d(r){r&&s(i)}}}function xa(T){let i,U="Before adding a new provider to the <code>huggingface_hub</code> Python library, make sure that all the previous steps have been completed and everything is working on the Hub. Support in the Python library comes as a second step.";return{c(){i=p("p"),i.innerHTML=U},l(r){i=o(r,"P",{"data-svelte-h":!0}),M(i)!=="svelte-33g0sl"&&(i.innerHTML=U)},m(r,m){l(r,i,m)},p:ht,d(r){r&&s(i)}}}function Aa(T){let i,U,r,m,q,Jt,f,Ut,k,Ml="This guide details the steps for registering as an inference provider on the Hub and provides implementation guidance.",jt,B,rl='<li><strong>Implement standard task APIs</strong> - Follow our task API schemas for compatibility (see <a href="#1-prerequisites">Prerequisites</a>).</li> <li><strong>Submit a PR for JS client integration</strong> - Add your provider to <a href="https://github.com/huggingface/huggingface.js/tree/main/packages/inference" rel="nofollow">huggingface.js</a> (see <a href="#2-js-client-integration">JS Client Integration</a>).</li> <li><strong>Register model mappings</strong> - Use our Model Mapping API to link your models to Hub models (see <a href="#3-model-mapping-api">Model Mapping API</a>).</li> <li><strong>Implement a billing endpoint</strong> - Provide an API for billing (see <a href="#4-billing">Billing</a>).</li> <li><strong>Submit a PR for Python client integration</strong> - Add your provider to <a href="https://github.com/huggingface/huggingface_hub" rel="nofollow">huggingface_hub</a> (see <a href="#5-python-client-integration">Python client integration</a>).</li> <li><strong>Register your provider server-side and provide an icon</strong> - Reach out to us to add your provider server-side and provide your SVG icon.</li> <li><strong>Create documentation on your side</strong> - Add documentation and do a lot of communication on your side.</li> <li><strong>Add a documentation page</strong> - Open a Pull Request in this repo (huggingface/hub-docs) to add a provider-specific page in the documentation.</li> <li><strong>Share share share</strong> do a lot of comms so that your integration is as successful as possible!</li>',mt,G,Tt,I,wt,Z,ul=`The first step to understand the integration is to take a look at the JS inference client that lives
inside the <a href="https://github.com/huggingface/huggingface.js/tree/main/packages/inference" rel="nofollow">huggingface.js</a> repo.`,ft,H,cl=`This is the client that powers our Inference widgets on model pages, and is the blueprint
implementation downstream (for Python SDK, to generate code snippets, etc.).`,It,_,gt,R,yl=`You will see that inference methods (<code>textToImage</code>, <code>chatCompletion</code>, etc.) have names that closely
mirror the task names. A task, also known as <code>pipeline_tag</code> in the HF ecosystem, is the type of
model (basically which types of inputs and outputs the model has), for instance “text-generation”
or “text-to-image”. It is indicated prominently on model pages, here:`,Ct,g,hl='<picture><img class="block dark:hidden" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/inference-providers/pipeline-tag-on-model-page-light.png"/> <img class="hidden dark:block" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/inference-providers/pipeline-tag-on-model-page-dark.png"/></picture>',bt,S,dl='The list of all possible tasks can be found at <a href="https://huggingface.co/tasks" rel="nofollow">https://huggingface.co/tasks</a> and the list of JS method names is documented in the README at <a href="https://github.com/huggingface/huggingface.js/tree/main/packages/inference" rel="nofollow">https://github.com/huggingface/huggingface.js/tree/main/packages/inference</a>.',vt,C,$t,W,xt,V,Jl=`For each task type, we enforce an API schema to make it easier for end users to use different
models interchangeably. To be compatible, your third-party API must adhere to a “standard” shape API we expect on HF model pages for each pipeline task type.`,At,X,Ul=`This is not an issue for LLMs as everyone converged on the OpenAI API anyways, but can be
more tricky for other tasks like “text-to-image” or “automatic-speech-recognition” where there
exists no standard API.`,qt,Q,jl='For example, you can find the expected schema for Text to Speech here: <a href="https://github.com/huggingface/huggingface.js/blob/0a690a14d52041a872dc103846225603599f4a33/packages/tasks/src/tasks/text-to-speech/spec/input.json#L4" rel="nofollow">https://github.com/huggingface/huggingface.js/packages/src/tasks/text-to-speech/spec/input.json#L4</a>, and similarly for other supported tasks. If your API for a given task is different from HF’s, it is not an issue: you can tweak the code in <code>huggingface.js</code> to be able to call your models, i.e., provide some kind of “translation” of parameter names and output names. However, API specs should not be model-specific, only task-specific. Run the JS code and add some <a href="https://github.com/huggingface/huggingface.js/blob/main/packages/inference/test/HfInference.spec.ts" rel="nofollow">tests</a> to make sure it works well. We can help with this step!',kt,Y,Bt,E,ml="Before proceeding with the next steps, ensure you’ve implemented the necessary code to integrate with the JS client and thoroughly tested your implementation. Here are the steps to follow:",Gt,N,Zt,F,Tl="Create a new file under <code>packages/inference/src/providers/{provider_name}.ts</code> and copy-paste the following snippet.",Ht,z,_t,P,wl="Implement the methods that require custom handling. Check out the base implementation to check default behavior. If you don’t need to override a method, just remove it. You have to define at least <code>makeRoute</code>, <code>preparePayload</code> and <code>getResponse</code>.",Rt,L,fl='If the provider supports multiple tasks that require different implementations, create dedicated subclasses for each task, following the pattern used in the existing providers implementation, e.g. <a href="https://github.com/huggingface/huggingface.js/blob/main/packages/inference/src/providers/together.ts" rel="nofollow">Together AI provider implementation</a>.',St,D,Il='For text-generation and conversational tasks, you can just inherit from <code>BaseTextGenerationTask</code> and <code>BaseConversationalTask</code> respectively (defined in <a href="(https://github.com/huggingface/huggingface.js/blob/main/packages/inference/src/providers/providerHelper.ts)">providerHelper.ts</a>) and override the methods if needed. Examples can be found in <a href="https://github.com/huggingface/huggingface.js/blob/main/packages/inference/src/providers/cerebras.ts" rel="nofollow">Cerebras</a> or <a href="https://github.com/huggingface/huggingface.js/blob/main/packages/inference/src/providers/fireworks.ts" rel="nofollow">Fireworks</a> provider implementations.',Wt,O,Vt,K,gl='Go to <a href="https://github.com/huggingface/huggingface.js//blob/main/packages/inference/src/lib/getProviderHelper.ts" rel="nofollow">packages/inference/src/lib/getProviderHelper.ts</a> and add your provider to <code>PROVIDERS</code>. You will need to add your provider to the <code>INFERENCE_PROVIDERS</code> list as well in <a href="https://github.com/huggingface/huggingface.js//blob/main/packages/inference/src/types.ts" rel="nofollow">packages/inference/src/types.ts</a>. Please try to respect alphabetical order.',Xt,ee,Cl='Update the <a href="https://github.com/huggingface/huggingface.js/blob/main/packages/inference/README.md" rel="nofollow">README.md</a> in the <code>packages/inference</code> directory to include your provider in the list of supported providers and the list of supported models links.',Qt,te,Yt,se,bl="Congratulations! You now have a JS implementation to successfully make inference calls on your infra! Time to integrate with the Hub!",Et,le,vl="First step is to use the Model Mapping API to register which HF models are supported.",Nt,b,Ft,ae,zt,ne,Pt,ie,$l="Create a new mapping item, with the following body (JSON-encoded):",Lt,pe,Dt,oe,xl=`<li><code>task</code>, also known as <code>pipeline_tag</code> in the HF ecosystem, is the type of model / type of API
(examples: “text-to-image”, “text-generation”, but you should use “conversational” for chat models)</li> <li><code>hfModel</code> is the model id on the Hub’s side.</li> <li><code>providerModel</code> is the model id on your side (can be the same or different).</li>`,Ot,Me,Al="The output of this route is a mapping ID that you can later use to update the mapping’s status or delete it.",Kt,re,es,ue,ql=`We also support mapping HF models based on their <code>tags</code>. Using tag filters, you can automatically map multiple HF models to a single inference endpoint on your side.
For example, any model tagged with both <code>lora</code> and <code>base_model:adapter:black-forest-labs/FLUX.1-dev</code> can be mapped to your Flux-dev LoRA inference endpoint.`,ts,v,ss,ce,kl="The API is as follows:",ls,ye,as,he,Bl="Create a new mapping item, with the following body (JSON-encoded):",ns,de,is,Je,Gl=`<li><code>task</code>, also known as <code>pipeline_tag</code> in the HF ecosystem, is the type of model / type of API
(examples: “text-to-image”, “text-generation”, but you should use “conversational” for chat models)</li> <li><code>tags</code> is the set of model tags to match. For example, to match all LoRAs of Flux, you can use: <code>[&quot;lora&quot;, &quot;base_model:adapter:black-forest-labs/FLUX.1-dev&quot;]</code></li> <li><code>providerModel</code> is the model ID on your side (can be the same or different from the HF model ID).</li> <li><code>adapterType</code> is a literal value that helps client libraries interpret how to call your API. The only supported value at the moment is <code>&quot;lora&quot;</code>.</li>`,ps,Ue,Zl="The output of this route is a mapping ID that you can later use to update the mapping’s status or delete it.",os,je,Ms,me,Hl=`You need to be in the <em>provider</em> Hub organization (e.g. <a href="https://huggingface.co/togethercomputer" rel="nofollow">https://huggingface.co/togethercomputer</a>
for TogetherAI) with <strong>Write</strong> permissions to be able to access this endpoint.`,rs,Te,us,we,_l="The endpoint validates that:",cs,fe,Rl=`<li><code>hfModel</code> is indeed of <code>pipeline_tag == task</code> OR <code>task</code> is “conversational” and the model is
compatible (i.e. the <code>pipeline_tag</code> is either “text-generation” or “image-text-to-text” AND the model is tagged as “conversational”).</li> <li>(in the future) we auto-test that the Partner’s API successfully responds to a
huggingface.js/inference call of the corresponding task i.e. the API specs are valid.</li>`,ys,Ie,hs,ge,ds,Ce,Sl=`Where <code>mapping ID</code> is the mapping’s id obtained upon creation.
You can also retrieve it from the <a href="#list-the-whole-mapping">list API endpoint</a>.`,Js,be,Us,ve,Wl="Call this HTTP PUT endpoint:",js,$e,ms,xe,Vl="With the following body (JSON-encoded):",Ts,Ae,ws,qe,Xl=`Where <code>mapping ID</code> is the mapping’s id obtained upon creation.
You can also retrieve it from the <a href="#list-the-whole-mapping">list API endpoint</a>.`,fs,ke,Is,Be,gs,Ge,Ql="This gets all mapping items from the DB. For clarity, the output is grouped by task.",Cs,$,bs,Ze,Yl="Here is an example of response:",vs,He,$s,_e,xs,Re,El=`For routed requests (see figure below), i.e. when users authenticate via HF, our intent is that
our users only pay the standard provider API rates. There’s no additional markup from us, we
just pass through the provider costs directly.
More details about the pricing structure can be found on the <a href="./pricing.md">pricing page</a>.`,As,x,Nl='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/inference-providers/types_of_billing.png"/>',qs,Se,Fl=`We propose an easier way to figure out this cost and charge it to our users, by asking you to
provide the cost for each request via an HTTP API you host on your end.`,ks,We,Bs,Ve,zl=`We ask that you expose an API that supports a HTTP POST request.
The body of the request is a JSON-encoded object containing a list of request IDs for which we
request the cost.
The authentication system should be the same as your Inference service; for example, a bearer token.`,Gs,Xe,Zs,Qe,Pl=`The response is also JSON-encoded. The response contains an array of objects specifying the
request’s ID and its cost in nano-USD (10^-9 USD).`,Hs,Ye,_s,Ee,Rs,Ne,Ll="We require the price to be a <strong>non-negative integer</strong> number of <strong>nano-USDs</strong> (10^-9 USD).",Ss,Fe,Ws,ze,Dl=`For each request/generation you serve, you should define a unique request (or response) ID,
and provide it as a response Header. We will use this ID as the request ID for the billing API
above.`,Vs,Pe,Ol="As part of those requirements, please let us know your Header name. If you don’t already have one, we suggest the <code>Inference-Id</code> name for instance, and it should contain a UUID character string.",Xs,Le,Kl="<strong>Example</strong>: Defining an <code>Inference-Id</code> header in your inference response.",Qs,De,Ys,Oe,Es,A,Ns,Ke,Fs,et,ea="Create a new file under <code>src/huggingface_hub/inference/_providers/{provider_name}.py</code> and copy-paste the following snippet.",zs,tt,ta="Implement the methods that require custom handling. Check out the base implementation to check default behavior. If you don’t need to override a method, just remove it. At least one of <code>_prepare_payload_as_dict</code> or <code>_prepare_payload_as_bytes</code> must be overwritten.",Ps,st,sa="If the provider supports multiple tasks that require different implementations, create dedicated subclasses for each task, following the pattern shown in fal_ai.py.",Ls,lt,la="For text-generation and conversational tasks, one can just inherit from BaseTextGenerationTask and BaseConversationalTask respectively (defined in _common.py) and override the methods if needed. Examples can be found in fireworks_ai.py and together.py.",Ds,at,Os,nt,Ks,it,aa='<li>Go to <a href="https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_providers/__init__.py" rel="nofollow">src/huggingface_hub/inference/_providers/<strong>init</strong>.py</a> and add your provider to <code>PROVIDER_T</code> and <code>PROVIDERS</code>. Please try to respect alphabetical order.</li> <li>Go to <a href="https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_client.py" rel="nofollow">src/huggingface_hub/inference/_client.py</a> and update docstring in <code>InferenceClient.__init__</code> to document your provider.</li>',el,pt,tl,ot,na='<li>Go to <a href="https://github.com/huggingface/huggingface_hub/blob/main/tests/test_inference_providers.py" rel="nofollow">tests/test_inference_providers.py</a> and add static tests for overridden methods.</li>',sl,Mt,ll,rt,ia="<strong>Question:</strong> By default, in which order do we list providers in the settings page?",al,ut,pa="<strong>Answer:</strong> The default sort is by total number of requests routed by HF over the last 7 days. This order defines which provider will be used in priority by the widget on the model page (but the user’s order takes precedence).",nl,ct,il,dt,pl;return q=new j({props:{title:"How to be registered as an inference provider on the Hub?",local:"how-to-be-registered-as-an-inference-provider-on-the-hub",headingTag:"h1"}}),f=new yt({props:{$$slots:{default:[Ia]},$$scope:{ctx:T}}}),G=new j({props:{title:"1. Prerequisites",local:"1-prerequisites",headingTag:"h2"}}),I=new yt({props:{$$slots:{default:[ga]},$$scope:{ctx:T}}}),_=new j({props:{title:"What is a Task",local:"what-is-a-task",headingTag:"h3"}}),C=new yt({props:{$$slots:{default:[Ca]},$$scope:{ctx:T}}}),W=new j({props:{title:"Task API schema",local:"task-api-schema",headingTag:"h3"}}),Y=new j({props:{title:"2. JS Client Integration",local:"2-js-client-integration",headingTag:"h2"}}),N=new j({props:{title:"Implement the provider helper (JS)",local:"implement-the-provider-helper-js",headingTag:"h3"}}),z=new w({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> { <span class="hljs-title class_">TaskProviderHelper</span> } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;./providerHelper&quot;</span>;

<span class="hljs-keyword">export</span> <span class="hljs-keyword">class</span> <span class="hljs-title class_">MyNewProviderTask</span> <span class="hljs-keyword">extends</span> <span class="hljs-title class_ inherited__">TaskProviderHelper</span> {

	<span class="hljs-title function_">constructor</span>(<span class="hljs-params"></span>) {
		<span class="hljs-variable language_">super</span>(<span class="hljs-string">&quot;your-provider-name&quot;</span>, <span class="hljs-string">&quot;your-api-base-url&quot;</span>, <span class="hljs-string">&quot;task-name&quot;</span>);
	}

    <span class="hljs-keyword">override</span> <span class="hljs-title function_">prepareHeaders</span>(<span class="hljs-attr">params</span>: <span class="hljs-title class_">HeaderParams</span>, <span class="hljs-attr">binary</span>: <span class="hljs-built_in">boolean</span>): <span class="hljs-title class_">Record</span>&lt;<span class="hljs-built_in">string</span>, <span class="hljs-built_in">string</span>&gt; {
        <span class="hljs-comment">// Override the headers to use for the request.</span>
        <span class="hljs-keyword">return</span> <span class="hljs-variable language_">super</span>.<span class="hljs-title function_">prepareHeaders</span>(params, binary);
    }

	<span class="hljs-title function_">makeRoute</span>(<span class="hljs-attr">params</span>: <span class="hljs-title class_">UrlParams</span>): <span class="hljs-built_in">string</span> {
        <span class="hljs-comment">// Return the route to use for the request. e.g. /v1/chat/completions route is commonly use for chat completion.</span>
		<span class="hljs-keyword">throw</span> <span class="hljs-keyword">new</span> <span class="hljs-title class_">Error</span>(<span class="hljs-string">&quot;Needs to be implemented&quot;</span>);
	}

	<span class="hljs-title function_">preparePayload</span>(<span class="hljs-attr">params</span>: <span class="hljs-title class_">BodyParams</span>): <span class="hljs-title class_">Record</span>&lt;<span class="hljs-built_in">string</span>, <span class="hljs-built_in">unknown</span>&gt; {
        <span class="hljs-comment">// Return the payload to use for the request, as a dict.</span>
		<span class="hljs-keyword">throw</span> <span class="hljs-keyword">new</span> <span class="hljs-title class_">Error</span>(<span class="hljs-string">&quot;Needs to be implemented&quot;</span>);
	}

	<span class="hljs-title function_">getResponse</span>(<span class="hljs-attr">response</span>: <span class="hljs-built_in">unknown</span>, outputType?: <span class="hljs-string">&quot;url&quot;</span> | <span class="hljs-string">&quot;blob&quot;</span>): <span class="hljs-built_in">string</span> | <span class="hljs-title class_">Promise</span>&lt;<span class="hljs-title class_">Blob</span>&gt;{
		<span class="hljs-comment">// Return the response in the expected format.</span>
        <span class="hljs-keyword">throw</span> <span class="hljs-keyword">new</span> <span class="hljs-title class_">Error</span>(<span class="hljs-string">&quot;Needs to be implemented&quot;</span>);
    }
}`,wrap:!1}}),O=new j({props:{title:"Register the provider",local:"register-the-provider",headingTag:"h3"}}),te=new j({props:{title:"3. Model Mapping API",local:"3-model-mapping-api",headingTag:"h2"}}),b=new yt({props:{$$slots:{default:[ba]},$$scope:{ctx:T}}}),ae=new j({props:{title:"Register a mapping item",local:"register-a-mapping-item",headingTag:"h3"}}),ne=new w({props:{code:"UE9TVCUyMCUyRmFwaSUyRnBhcnRuZXJzJTJGJTdCcHJvdmlkZXIlN0QlMkZtb2RlbHM=",highlighted:"POST /api/partners/{provider}/models",wrap:!1}}),pe=new w({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIwJTIydGFzayUyMiUzQSUyMCUyMldpZGdldFR5cGUlMjIlMkMlMjAlMkYlMkYlMjByZXF1aXJlZCUwQSUyMCUyMCUyMCUyMCUyMmhmTW9kZWwlMjIlM0ElMjAlMjJzdHJpbmclMjIlMkMlMjAlMkYlMkYlMjByZXF1aXJlZCUzQSUyMHRoZSUyMG5hbWUlMjBvZiUyMHRoZSUyMG1vZGVsJTIwb24lMjBIRiUzQSUyMG5hbWVzcGFjZSUyRm1vZGVsLW5hbWUlMEElMjAlMjAlMjAlMjAlMjJwcm92aWRlck1vZGVsJTIyJTNBJTIwJTIyc3RyaW5nJTIyJTJDJTIwJTJGJTJGJTIwcmVxdWlyZWQlM0ElMjB0aGUlMjBwYXJ0bmVyJ3MlMjAlMjJtb2RlbCUyMGlkJTIyJTIwaS5lLiUyMGlkJTIwb24lMjB5b3VyJTIwc2lkZSUwQSUyMCUyMCUyMCUyMCUyMnN0YXR1cyUyMiUzQSUyMCUyMmxpdmUlMjIlMjAlN0MlMjAlMjJzdGFnaW5nJTIyJTIwJTJGJTJGJTIwT3B0aW9uYWwlM0ElMjBkZWZhdWx0cyUyMHRvJTIwJTIyc3RhZ2luZyUyMi4lMjAlMjJzdGFnaW5nJTIyJTIwbW9kZWxzJTIwYXJlJTIwb25seSUyMGF2YWlsYWJsZSUyMHRvJTIwbWVtYmVycyUyMG9mJTIwdGhlJTIwcGFydG5lcidzJTIwb3JnJTJDJTIwdGhlbiUyMHlvdSUyMHN3aXRjaCUyMHRoZW0lMjB0byUyMCUyMmxpdmUlMjIlMjB3aGVuJTIwdGhleSdyZSUyMHJlYWR5JTIwdG8lMjBnbyUyMGxpdmUlMEElN0Q=",highlighted:`<span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;task&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;WidgetType&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-comment">// required</span>
    <span class="hljs-attr">&quot;hfModel&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;string&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-comment">// required: the name of the model on HF: namespace/model-name</span>
    <span class="hljs-attr">&quot;providerModel&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;string&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-comment">// required: the partner&#x27;s &quot;model id&quot; i.e. id on your side</span>
    <span class="hljs-attr">&quot;status&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;live&quot;</span> | <span class="hljs-string">&quot;staging&quot;</span> <span class="hljs-comment">// Optional: defaults to &quot;staging&quot;. &quot;staging&quot; models are only available to members of the partner&#x27;s org, then you switch them to &quot;live&quot; when they&#x27;re ready to go live</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),re=new j({props:{title:"Using a tag-filter to map several HF models to a single inference endpoint",local:"using-a-tag-filter-to-map-several-hf-models-to-a-single-inference-endpoint",headingTag:"h3"}}),v=new yt({props:{$$slots:{default:[va]},$$scope:{ctx:T}}}),ye=new w({props:{code:"UE9TVCUyMCUyRmFwaSUyRnBhcnRuZXJzJTJGJTdCcHJvdmlkZXIlN0QlMkZtb2RlbHM=",highlighted:"POST /api/partners/{provider}/models",wrap:!1}}),de=new w({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIwJTIydHlwZSUyMiUzQSUyMCUyMnRhZy1maWx0ZXIlMjIlMkMlMjAlMkYlMkYlMjByZXF1aXJlZCUwQSUyMCUyMCUyMCUyMCUyMnRhc2slMjIlM0ElMjAlMjJXaWRnZXRUeXBlJTIyJTJDJTIwJTJGJTJGJTIwcmVxdWlyZWQlMEElMjAlMjAlMjAlMjAlMjJ0YWdzJTIyJTNBJTIwJTVCJTIyc3RyaW5nJTIyJTVEJTJDJTIwJTJGJTJGJTIwcmVxdWlyZWQlM0ElMjBhbnklMjBIRiUyMG1vZGVsJTIwd2l0aCUyMGFsbCUyMG9mJTIwdGhvc2UlMjB0YWdzJTIwd2lsbCUyMGJlJTIwbWFwcGVkJTIwdG8lMjBwcm92aWRlck1vZGVsJTBBJTIwJTIwJTIwJTIwJTIycHJvdmlkZXJNb2RlbCUyMiUzQSUyMCUyMnN0cmluZyUyMiUyQyUyMCUyRiUyRiUyMHJlcXVpcmVkJTNBJTIwdGhlJTIwcGFydG5lcidzJTIwJTIybW9kZWwlMjBpZCUyMiUyMGkuZS4lMjBpZCUyMG9uJTIweW91ciUyMHNpZGUlMEElMjAlMjAlMjAlMjAlMjJhZGFwdGVyVHlwZSUyMiUzQSUyMCUyMmxvcmElMjIlMkMlMjAlMkYlMkYlMjByZXF1aXJlZCUzQSUyMG9ubHklMjAlMjJsb3JhJTIyJTIwaXMlMjBzdXBwb3J0ZWQlMjBhdCUyMHRoZSUyMG1vbWVudCUwQSUyMCUyMCUyMCUyMCUyMnN0YXR1cyUyMiUzQSUyMCUyMmxpdmUlMjIlMjAlN0MlMjAlMjJzdGFnaW5nJTIyJTIwJTJGJTJGJTIwT3B0aW9uYWwlM0ElMjBkZWZhdWx0cyUyMHRvJTIwJTIyc3RhZ2luZyUyMi4lMjAlMjJzdGFnaW5nJTIyJTIwbW9kZWxzJTIwYXJlJTIwb25seSUyMGF2YWlsYWJsZSUyMHRvJTIwbWVtYmVycyUyMG9mJTIwdGhlJTIwcGFydG5lcidzJTIwb3JnJTJDJTIwdGhlbiUyMHlvdSUyMHN3aXRjaCUyMHRoZW0lMjB0byUyMCUyMmxpdmUlMjIlMjB3aGVuJTIwdGhleSdyZSUyMHJlYWR5JTIwdG8lMjBnbyUyMGxpdmUlMEElN0Q=",highlighted:`<span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;tag-filter&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-comment">// required</span>
    <span class="hljs-attr">&quot;task&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;WidgetType&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-comment">// required</span>
    <span class="hljs-attr">&quot;tags&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span><span class="hljs-string">&quot;string&quot;</span><span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span> <span class="hljs-comment">// required: any HF model with all of those tags will be mapped to providerModel</span>
    <span class="hljs-attr">&quot;providerModel&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;string&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-comment">// required: the partner&#x27;s &quot;model id&quot; i.e. id on your side</span>
    <span class="hljs-attr">&quot;adapterType&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;lora&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-comment">// required: only &quot;lora&quot; is supported at the moment</span>
    <span class="hljs-attr">&quot;status&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;live&quot;</span> | <span class="hljs-string">&quot;staging&quot;</span> <span class="hljs-comment">// Optional: defaults to &quot;staging&quot;. &quot;staging&quot; models are only available to members of the partner&#x27;s org, then you switch them to &quot;live&quot; when they&#x27;re ready to go live</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),je=new j({props:{title:"Authentication",local:"authentication",headingTag:"h4"}}),Te=new j({props:{title:"Validation",local:"validation",headingTag:"h4"}}),Ie=new j({props:{title:"Delete a mapping item",local:"delete-a-mapping-item",headingTag:"h3"}}),ge=new w({props:{code:"REVMRVRFJTIwJTJGYXBpJTJGcGFydG5lcnMlMkYlN0Jwcm92aWRlciU3RCUyRm1vZGVscyUyRiU3Qm1hcHBpbmclMjBJRCU3RA==",highlighted:"DELETE /api/partners/{provider}/models/{mapping ID}",wrap:!1}}),be=new j({props:{title:"Update a mapping item’s status",local:"update-a-mapping-items-status",headingTag:"h3"}}),$e=new w({props:{code:"UFVUJTIwJTJGYXBpJTJGcGFydG5lcnMlMkYlN0Jwcm92aWRlciU3RCUyRm1vZGVscyUyRiU3Qm1hcHBpbmclMjBJRCU3RCUyRnN0YXR1cw==",highlighted:"PUT /api/partners/{provider}/models/{mapping ID}/status",wrap:!1}}),Ae=new w({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIwJTIyc3RhdHVzJTIyJTNBJTIwJTIybGl2ZSUyMiUyMCU3QyUyMCUyMnN0YWdpbmclMjIlMjAlMkYlMkYlMjBUaGUlMjBuZXclMjBzdGF0dXMlMkMlMjBvbmUlMjBvZiUyMCUyMnN0YWdpbmclMjIlMjBvciUyMCUyMmxpdmUlMjIlMEElN0QlMjAlMjAlMjA=",highlighted:`<span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;status&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;live&quot;</span> | <span class="hljs-string">&quot;staging&quot;</span> <span class="hljs-comment">// The new status, one of &quot;staging&quot; or &quot;live&quot;</span>
<span class="hljs-punctuation">}</span>   `,wrap:!1}}),ke=new j({props:{title:"List the whole mapping",local:"list-the-whole-mapping",headingTag:"h3"}}),Be=new w({props:{code:"R0VUJTIwJTJGYXBpJTJGcGFydG5lcnMlMkYlN0Jwcm92aWRlciU3RCUyRm1vZGVscyUzRnN0YXR1cyUzRHN0YWdpbmclN0NsaXZl",highlighted:"GET /api/partners/{provider}/models?status=staging|live",wrap:!1}}),$=new yt({props:{warning:!0,$$slots:{default:[$a]},$$scope:{ctx:T}}}),He=new w({props:{code:"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",highlighted:`<span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;text-to-image&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;black-forest-labs/FLUX.1-Canny-dev&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
            <span class="hljs-attr">&quot;_id&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;xxxxxxxxxxxxxxxxxxxxxxxx&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;providerId&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;black-forest-labs/FLUX.1-canny&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;status&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;live&quot;</span>
        <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;black-forest-labs/FLUX.1-Depth-dev&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
            <span class="hljs-attr">&quot;_id&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;xxxxxxxxxxxxxxxxxxxxxxxx&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;providerId&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;black-forest-labs/FLUX.1-depth&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;status&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;live&quot;</span>
        <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;tag-filter=base_model:adapter:stabilityai/stable-diffusion-xl-base-1.0,lora&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
            <span class="hljs-attr">&quot;_id&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;xxxxxxxxxxxxxxxxxxxxxxxx&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;status&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;live&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;providerId&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;sdxl-lora-mutualized&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;adapterType&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;lora&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;tags&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
                <span class="hljs-string">&quot;base_model:adapter:stabilityai/stable-diffusion-xl-base-1.0&quot;</span><span class="hljs-punctuation">,</span>
                <span class="hljs-string">&quot;lora&quot;</span>
            <span class="hljs-punctuation">]</span>
        <span class="hljs-punctuation">}</span>
    <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;conversational&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;deepseek-ai/DeepSeek-R1&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
            <span class="hljs-attr">&quot;_id&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;xxxxxxxxxxxxxxxxxxxxxxxx&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;providerId&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;deepseek-ai/DeepSeek-R1&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;status&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;live&quot;</span>
        <span class="hljs-punctuation">}</span>
    <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;text-generation&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;meta-llama/Llama-2-70b-hf&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
            <span class="hljs-attr">&quot;_id&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;xxxxxxxxxxxxxxxxxxxxxxxx&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;providerId&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;meta-llama/Llama-2-70b-hf&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;status&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;live&quot;</span>
        <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;mistralai/Mixtral-8x7B-v0.1&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
            <span class="hljs-attr">&quot;_id&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;xxxxxxxxxxxxxxxxxxxxxxxx&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;providerId&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;mistralai/Mixtral-8x7B-v0.1&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;status&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;live&quot;</span>
        <span class="hljs-punctuation">}</span>
    <span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),_e=new j({props:{title:"4. Billing",local:"4-billing",headingTag:"h2"}}),We=new j({props:{title:"HTTP API Specs",local:"http-api-specs",headingTag:"h3"}}),Xe=new w({props:{code:"UE9TVCUyMCU3QnlvdXIlMjBVUkwlMjBoZXJlJTdEJTBBQXV0aG9yaXphdGlvbiUzQSUyMCU3QmF1dGhlbnRpY2F0aW9uJTIwaW5mbyUyMC0lMjBlZyUyMCUyMkJlYXJlciUyMHRva2VuJTIyJTdEJTBBQ29udGVudC1UeXBlJTNBJTIwYXBwbGljYXRpb24lMkZqc29uJTBBJTBBJTdCJTBBJTIwJTIwJTIwJTIwJTIycmVxdWVzdElkcyUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmRlYWRiZWVmMCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmRlYWRiZWVmMSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmRlYWRiZWVmMiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmRlYWRiZWVmMyUyMiUwQSUyMCUyMCUyMCUyMCU1RCUwQSU3RA==",highlighted:`POST {your URL here}
<span class="hljs-attribute">Authorization</span><span class="hljs-punctuation">: </span>{authentication info - eg &quot;Bearer token&quot;}
<span class="hljs-attribute">Content-Type</span><span class="hljs-punctuation">: </span>application/json

{
    &quot;requestIds&quot;: [
        &quot;deadbeef0&quot;,
        &quot;deadbeef1&quot;,
        &quot;deadbeef2&quot;,
        &quot;deadbeef3&quot;
    ]
}`,wrap:!1}}),Ye=new w({props:{code:"SFRUUCUyRjEuMSUyMDIwMCUyME9LJTBBQ29udGVudC1UeXBlJTNBJTIwYXBwbGljYXRpb24lMkZqc29uJTBBJTBBJTdCJTBBJTIwJTIwJTIwJTIwJTIycmVxdWVzdHMlMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMjAlMjJyZXF1ZXN0SWQlMjIlM0ElMjAlMjJkZWFkYmVlZjAlMjIlMkMlMjAlMjJjb3N0TmFub1VzZCUyMiUzQSUyMDEwMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUyMCUyMnJlcXVlc3RJZCUyMiUzQSUyMCUyMmRlYWRiZWVmMSUyMiUyQyUyMCUyMmNvc3ROYW5vVXNkJTIyJTNBJTIwMTAwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTIwJTIycmVxdWVzdElkJTIyJTNBJTIwJTIyZGVhZGJlZWYyJTIyJTJDJTIwJTIyY29zdE5hbm9Vc2QlMjIlM0ElMjAxMDAlMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMjAlMjJyZXF1ZXN0SWQlMjIlM0ElMjAlMjJkZWFkYmVlZjMlMjIlMkMlMjAlMjJjb3N0TmFub1VzZCUyMiUzQSUyMDEwMCUyMCU3RCUwQSUyMCUyMCUyMCUyMCU1RCUwQSU3RA==",highlighted:`<span class="hljs-meta">HTTP/1.1</span> <span class="hljs-number">200</span> OK
<span class="hljs-attribute">Content-Type</span><span class="hljs-punctuation">: </span>application/json

<span class="language-prolog">{
    <span class="hljs-string">&quot;requests&quot;</span>: [
        { <span class="hljs-string">&quot;requestId&quot;</span>: <span class="hljs-string">&quot;deadbeef0&quot;</span>, <span class="hljs-string">&quot;costNanoUsd&quot;</span>: <span class="hljs-number">100</span> },
        { <span class="hljs-string">&quot;requestId&quot;</span>: <span class="hljs-string">&quot;deadbeef1&quot;</span>, <span class="hljs-string">&quot;costNanoUsd&quot;</span>: <span class="hljs-number">100</span> },
        { <span class="hljs-string">&quot;requestId&quot;</span>: <span class="hljs-string">&quot;deadbeef2&quot;</span>, <span class="hljs-string">&quot;costNanoUsd&quot;</span>: <span class="hljs-number">100</span> },
        { <span class="hljs-string">&quot;requestId&quot;</span>: <span class="hljs-string">&quot;deadbeef3&quot;</span>, <span class="hljs-string">&quot;costNanoUsd&quot;</span>: <span class="hljs-number">100</span> }
    ]
}</span>`,wrap:!1}}),Ee=new j({props:{title:"Price Unit",local:"price-unit",headingTag:"h3"}}),Fe=new j({props:{title:"How to define the request ID",local:"how-to-define-the-request-id",headingTag:"h3"}}),De=new w({props:{code:"UE9TVCUyMCUyRnYxJTJGY2hhdCUyRmNvbXBsZXRpb25zJTBBQ29udGVudC1UeXBlJTNBJTIwYXBwbGljYXRpb24lMkZqc29uJTBBJTVCcmVxdWVzdCUyMGhlYWRlcnMlNUQlMEElNUJyZXF1ZXN0JTIwYm9keSU1RCUwQS0tLS0tLSUwQUhUVFAlMkYxLjElMjAyMDAlMjBPSyUwQUNvbnRlbnQtVHlwZSUzQSUyMGFwcGxpY2F0aW9uJTJGanNvbiUwQSU1Qm90aGVyJTIwcmVxdWVzdCUyMGhlYWRlcnMlNUQlMEFJbmZlcmVuY2UtSWQlM0ElMjB1bmlxdWUtaWQtMDAxMzElMEElNUJyZXNwb25zZSUyMGJvZHklNUQ=",highlighted:`POST /v1/chat/completions
<span class="hljs-attribute">Content-Type</span><span class="hljs-punctuation">: </span>application/json
[request headers]
[request body]
------
<span class="hljs-meta">HTTP/1.1</span> <span class="hljs-number">200</span> OK
<span class="hljs-attribute">Content-Type</span><span class="hljs-punctuation">: </span>application/json
[other request headers]
<span class="hljs-attribute">Inference-Id</span><span class="hljs-punctuation">: </span>unique-id-00131
[response body]`,wrap:!1}}),Oe=new j({props:{title:"5. Python client integration",local:"5-python-client-integration",headingTag:"h2"}}),A=new yt({props:{$$slots:{default:[xa]},$$scope:{ctx:T}}}),Ke=new j({props:{title:"Implement the provider helper (Python)",local:"implement-the-provider-helper-python",headingTag:"h3"}}),at=new w({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">Any</span>, <span class="hljs-type">Dict</span>, <span class="hljs-type">Optional</span>, <span class="hljs-type">Union</span>

<span class="hljs-keyword">from</span> ._common <span class="hljs-keyword">import</span> TaskProviderHelper


<span class="hljs-keyword">class</span> <span class="hljs-title class_">MyNewProviderTaskProviderHelper</span>(<span class="hljs-title class_ inherited__">TaskProviderHelper</span>):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self</span>):
        <span class="hljs-string">&quot;&quot;&quot;Define high-level parameters.&quot;&quot;&quot;</span>
        <span class="hljs-built_in">super</span>().__init__(provider=..., base_url=..., task=...)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">get_response</span>(<span class="hljs-params">
        self,
        response: <span class="hljs-type">Union</span>[<span class="hljs-built_in">bytes</span>, <span class="hljs-type">Dict</span>],
        request_params: <span class="hljs-type">Optional</span>[RequestParameters] = <span class="hljs-literal">None</span>,
    </span>) -&gt; <span class="hljs-type">Any</span>:
        <span class="hljs-string">&quot;&quot;&quot;
        Return the response in the expected format.

        Override this method in subclasses for customized response handling.&quot;&quot;&quot;</span>
        <span class="hljs-keyword">return</span> <span class="hljs-built_in">super</span>().get_response(response)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">_prepare_headers</span>(<span class="hljs-params">self, headers: <span class="hljs-type">Dict</span>, api_key: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-type">Dict</span>:
        <span class="hljs-string">&quot;&quot;&quot;Return the headers to use for the request.

        Override this method in subclasses for customized headers.
        &quot;&quot;&quot;</span>
        <span class="hljs-keyword">return</span> <span class="hljs-built_in">super</span>()._prepare_headers(headers, api_key)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">_prepare_route</span>(<span class="hljs-params">self, mapped_model: <span class="hljs-built_in">str</span>, api_key: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
        <span class="hljs-string">&quot;&quot;&quot;Return the route to use for the request.

        Override this method in subclasses for customized routes.
        &quot;&quot;&quot;</span>
        <span class="hljs-keyword">return</span> <span class="hljs-built_in">super</span>()._prepare_route(mapped_model)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">_prepare_payload_as_dict</span>(<span class="hljs-params">self, inputs: <span class="hljs-type">Any</span>, parameters: <span class="hljs-type">Dict</span>, mapped_model: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-type">Optional</span>[<span class="hljs-type">Dict</span>]:
        <span class="hljs-string">&quot;&quot;&quot;Return the payload to use for the request, as a dict.

        Override this method in subclasses for customized payloads.
        Only one of \`_prepare_payload_as_dict\` and \`_prepare_payload_as_bytes\` should return a value.
        &quot;&quot;&quot;</span>
        <span class="hljs-keyword">return</span> <span class="hljs-built_in">super</span>()._prepare_payload_as_dict(inputs, parameters, mapped_model)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">_prepare_payload_as_bytes</span>(<span class="hljs-params">
        self, inputs: <span class="hljs-type">Any</span>, parameters: <span class="hljs-type">Dict</span>, mapped_model: <span class="hljs-built_in">str</span>, extra_payload: <span class="hljs-type">Optional</span>[<span class="hljs-type">Dict</span>]
    </span>) -&gt; <span class="hljs-type">Optional</span>[<span class="hljs-built_in">bytes</span>]:
        <span class="hljs-string">&quot;&quot;&quot;Return the body to use for the request, as bytes.

        Override this method in subclasses for customized body data.
        Only one of \`_prepare_payload_as_dict\` and \`_prepare_payload_as_bytes\` should return a value.
        &quot;&quot;&quot;</span>
        <span class="hljs-keyword">return</span> <span class="hljs-built_in">super</span>()._prepare_payload_as_bytes(inputs, parameters, mapped_model, extra_payload)`,wrap:!1}}),nt=new j({props:{title:"Register the Provider",local:"register-the-provider",headingTag:"h3"}}),pt=new j({props:{title:"Add tests",local:"add-tests",headingTag:"h3"}}),Mt=new j({props:{title:"FAQ",local:"faq",headingTag:"h2"}}),ct=new fa({props:{source:"https://github.com/huggingface/hub-docs/blob/main/docs/inference-providers/register-as-a-provider.md"}}),{c(){i=p("meta"),U=a(),r=p("p"),m=a(),u(q.$$.fragment),Jt=a(),u(f.$$.fragment),Ut=a(),k=p("p"),k.textContent=Ml,jt=a(),B=p("ol"),B.innerHTML=rl,mt=a(),u(G.$$.fragment),Tt=a(),u(I.$$.fragment),wt=a(),Z=p("p"),Z.innerHTML=ul,ft=a(),H=p("p"),H.textContent=cl,It=a(),u(_.$$.fragment),gt=a(),R=p("p"),R.innerHTML=yl,Ct=a(),g=p("div"),g.innerHTML=hl,bt=a(),S=p("p"),S.innerHTML=dl,vt=a(),u(C.$$.fragment),$t=a(),u(W.$$.fragment),xt=a(),V=p("p"),V.textContent=Jl,At=a(),X=p("p"),X.textContent=Ul,qt=a(),Q=p("p"),Q.innerHTML=jl,kt=a(),u(Y.$$.fragment),Bt=a(),E=p("p"),E.textContent=ml,Gt=a(),u(N.$$.fragment),Zt=a(),F=p("p"),F.innerHTML=Tl,Ht=a(),u(z.$$.fragment),_t=a(),P=p("p"),P.innerHTML=wl,Rt=a(),L=p("p"),L.innerHTML=fl,St=a(),D=p("p"),D.innerHTML=Il,Wt=a(),u(O.$$.fragment),Vt=a(),K=p("p"),K.innerHTML=gl,Xt=a(),ee=p("p"),ee.innerHTML=Cl,Qt=a(),u(te.$$.fragment),Yt=a(),se=p("p"),se.textContent=bl,Et=a(),le=p("p"),le.textContent=vl,Nt=a(),u(b.$$.fragment),Ft=a(),u(ae.$$.fragment),zt=a(),u(ne.$$.fragment),Pt=a(),ie=p("p"),ie.textContent=$l,Lt=a(),u(pe.$$.fragment),Dt=a(),oe=p("ul"),oe.innerHTML=xl,Ot=a(),Me=p("p"),Me.textContent=Al,Kt=a(),u(re.$$.fragment),es=a(),ue=p("p"),ue.innerHTML=ql,ts=a(),u(v.$$.fragment),ss=a(),ce=p("p"),ce.textContent=kl,ls=a(),u(ye.$$.fragment),as=a(),he=p("p"),he.textContent=Bl,ns=a(),u(de.$$.fragment),is=a(),Je=p("ul"),Je.innerHTML=Gl,ps=a(),Ue=p("p"),Ue.textContent=Zl,os=a(),u(je.$$.fragment),Ms=a(),me=p("p"),me.innerHTML=Hl,rs=a(),u(Te.$$.fragment),us=a(),we=p("p"),we.textContent=_l,cs=a(),fe=p("ul"),fe.innerHTML=Rl,ys=a(),u(Ie.$$.fragment),hs=a(),u(ge.$$.fragment),ds=a(),Ce=p("p"),Ce.innerHTML=Sl,Js=a(),u(be.$$.fragment),Us=a(),ve=p("p"),ve.textContent=Wl,js=a(),u($e.$$.fragment),ms=a(),xe=p("p"),xe.textContent=Vl,Ts=a(),u(Ae.$$.fragment),ws=a(),qe=p("p"),qe.innerHTML=Xl,fs=a(),u(ke.$$.fragment),Is=a(),u(Be.$$.fragment),gs=a(),Ge=p("p"),Ge.textContent=Ql,Cs=a(),u($.$$.fragment),bs=a(),Ze=p("p"),Ze.textContent=Yl,vs=a(),u(He.$$.fragment),$s=a(),u(_e.$$.fragment),xs=a(),Re=p("p"),Re.innerHTML=El,As=a(),x=p("div"),x.innerHTML=Nl,qs=a(),Se=p("p"),Se.textContent=Fl,ks=a(),u(We.$$.fragment),Bs=a(),Ve=p("p"),Ve.textContent=zl,Gs=a(),u(Xe.$$.fragment),Zs=a(),Qe=p("p"),Qe.textContent=Pl,Hs=a(),u(Ye.$$.fragment),_s=a(),u(Ee.$$.fragment),Rs=a(),Ne=p("p"),Ne.innerHTML=Ll,Ss=a(),u(Fe.$$.fragment),Ws=a(),ze=p("p"),ze.textContent=Dl,Vs=a(),Pe=p("p"),Pe.innerHTML=Ol,Xs=a(),Le=p("p"),Le.innerHTML=Kl,Qs=a(),u(De.$$.fragment),Ys=a(),u(Oe.$$.fragment),Es=a(),u(A.$$.fragment),Ns=a(),u(Ke.$$.fragment),Fs=a(),et=p("p"),et.innerHTML=ea,zs=a(),tt=p("p"),tt.innerHTML=ta,Ps=a(),st=p("p"),st.textContent=sa,Ls=a(),lt=p("p"),lt.textContent=la,Ds=a(),u(at.$$.fragment),Os=a(),u(nt.$$.fragment),Ks=a(),it=p("ul"),it.innerHTML=aa,el=a(),u(pt.$$.fragment),tl=a(),ot=p("ul"),ot.innerHTML=na,sl=a(),u(Mt.$$.fragment),ll=a(),rt=p("p"),rt.innerHTML=ia,al=a(),ut=p("p"),ut.innerHTML=pa,nl=a(),u(ct.$$.fragment),il=a(),dt=p("p"),this.h()},l(e){const t=Ta("svelte-u9bgzb",document.head);i=o(t,"META",{name:!0,content:!0}),t.forEach(s),U=n(e),r=o(e,"P",{}),da(r).forEach(s),m=n(e),c(q.$$.fragment,e),Jt=n(e),c(f.$$.fragment,e),Ut=n(e),k=o(e,"P",{"data-svelte-h":!0}),M(k)!=="svelte-eo2v07"&&(k.textContent=Ml),jt=n(e),B=o(e,"OL",{"data-svelte-h":!0}),M(B)!=="svelte-8emskd"&&(B.innerHTML=rl),mt=n(e),c(G.$$.fragment,e),Tt=n(e),c(I.$$.fragment,e),wt=n(e),Z=o(e,"P",{"data-svelte-h":!0}),M(Z)!=="svelte-iwney4"&&(Z.innerHTML=ul),ft=n(e),H=o(e,"P",{"data-svelte-h":!0}),M(H)!=="svelte-1xoupob"&&(H.textContent=cl),It=n(e),c(_.$$.fragment,e),gt=n(e),R=o(e,"P",{"data-svelte-h":!0}),M(R)!=="svelte-hjt0h1"&&(R.innerHTML=yl),Ct=n(e),g=o(e,"DIV",{class:!0,"data-svelte-h":!0}),M(g)!=="svelte-1cxy3tx"&&(g.innerHTML=hl),bt=n(e),S=o(e,"P",{"data-svelte-h":!0}),M(S)!=="svelte-vmhaok"&&(S.innerHTML=dl),vt=n(e),c(C.$$.fragment,e),$t=n(e),c(W.$$.fragment,e),xt=n(e),V=o(e,"P",{"data-svelte-h":!0}),M(V)!=="svelte-epfhsj"&&(V.textContent=Jl),At=n(e),X=o(e,"P",{"data-svelte-h":!0}),M(X)!=="svelte-n5dyw"&&(X.textContent=Ul),qt=n(e),Q=o(e,"P",{"data-svelte-h":!0}),M(Q)!=="svelte-qm2nt8"&&(Q.innerHTML=jl),kt=n(e),c(Y.$$.fragment,e),Bt=n(e),E=o(e,"P",{"data-svelte-h":!0}),M(E)!=="svelte-aqaw0f"&&(E.textContent=ml),Gt=n(e),c(N.$$.fragment,e),Zt=n(e),F=o(e,"P",{"data-svelte-h":!0}),M(F)!=="svelte-1ccsiy1"&&(F.innerHTML=Tl),Ht=n(e),c(z.$$.fragment,e),_t=n(e),P=o(e,"P",{"data-svelte-h":!0}),M(P)!=="svelte-qutua8"&&(P.innerHTML=wl),Rt=n(e),L=o(e,"P",{"data-svelte-h":!0}),M(L)!=="svelte-uj5o95"&&(L.innerHTML=fl),St=n(e),D=o(e,"P",{"data-svelte-h":!0}),M(D)!=="svelte-1ozzcb1"&&(D.innerHTML=Il),Wt=n(e),c(O.$$.fragment,e),Vt=n(e),K=o(e,"P",{"data-svelte-h":!0}),M(K)!=="svelte-dq2kwm"&&(K.innerHTML=gl),Xt=n(e),ee=o(e,"P",{"data-svelte-h":!0}),M(ee)!=="svelte-kajnqt"&&(ee.innerHTML=Cl),Qt=n(e),c(te.$$.fragment,e),Yt=n(e),se=o(e,"P",{"data-svelte-h":!0}),M(se)!=="svelte-1vjzmk"&&(se.textContent=bl),Et=n(e),le=o(e,"P",{"data-svelte-h":!0}),M(le)!=="svelte-1147onl"&&(le.textContent=vl),Nt=n(e),c(b.$$.fragment,e),Ft=n(e),c(ae.$$.fragment,e),zt=n(e),c(ne.$$.fragment,e),Pt=n(e),ie=o(e,"P",{"data-svelte-h":!0}),M(ie)!=="svelte-f1hll8"&&(ie.textContent=$l),Lt=n(e),c(pe.$$.fragment,e),Dt=n(e),oe=o(e,"UL",{"data-svelte-h":!0}),M(oe)!=="svelte-u6m976"&&(oe.innerHTML=xl),Ot=n(e),Me=o(e,"P",{"data-svelte-h":!0}),M(Me)!=="svelte-khk897"&&(Me.textContent=Al),Kt=n(e),c(re.$$.fragment,e),es=n(e),ue=o(e,"P",{"data-svelte-h":!0}),M(ue)!=="svelte-1s9oaze"&&(ue.innerHTML=ql),ts=n(e),c(v.$$.fragment,e),ss=n(e),ce=o(e,"P",{"data-svelte-h":!0}),M(ce)!=="svelte-m8oll3"&&(ce.textContent=kl),ls=n(e),c(ye.$$.fragment,e),as=n(e),he=o(e,"P",{"data-svelte-h":!0}),M(he)!=="svelte-f1hll8"&&(he.textContent=Bl),ns=n(e),c(de.$$.fragment,e),is=n(e),Je=o(e,"UL",{"data-svelte-h":!0}),M(Je)!=="svelte-amxywc"&&(Je.innerHTML=Gl),ps=n(e),Ue=o(e,"P",{"data-svelte-h":!0}),M(Ue)!=="svelte-khk897"&&(Ue.textContent=Zl),os=n(e),c(je.$$.fragment,e),Ms=n(e),me=o(e,"P",{"data-svelte-h":!0}),M(me)!=="svelte-1avk6lq"&&(me.innerHTML=Hl),rs=n(e),c(Te.$$.fragment,e),us=n(e),we=o(e,"P",{"data-svelte-h":!0}),M(we)!=="svelte-pwj71q"&&(we.textContent=_l),cs=n(e),fe=o(e,"UL",{"data-svelte-h":!0}),M(fe)!=="svelte-1i002r6"&&(fe.innerHTML=Rl),ys=n(e),c(Ie.$$.fragment,e),hs=n(e),c(ge.$$.fragment,e),ds=n(e),Ce=o(e,"P",{"data-svelte-h":!0}),M(Ce)!=="svelte-ojjbo0"&&(Ce.innerHTML=Sl),Js=n(e),c(be.$$.fragment,e),Us=n(e),ve=o(e,"P",{"data-svelte-h":!0}),M(ve)!=="svelte-18yjufw"&&(ve.textContent=Wl),js=n(e),c($e.$$.fragment,e),ms=n(e),xe=o(e,"P",{"data-svelte-h":!0}),M(xe)!=="svelte-1ar1qn2"&&(xe.textContent=Vl),Ts=n(e),c(Ae.$$.fragment,e),ws=n(e),qe=o(e,"P",{"data-svelte-h":!0}),M(qe)!=="svelte-ojjbo0"&&(qe.innerHTML=Xl),fs=n(e),c(ke.$$.fragment,e),Is=n(e),c(Be.$$.fragment,e),gs=n(e),Ge=o(e,"P",{"data-svelte-h":!0}),M(Ge)!=="svelte-16sv3hm"&&(Ge.textContent=Ql),Cs=n(e),c($.$$.fragment,e),bs=n(e),Ze=o(e,"P",{"data-svelte-h":!0}),M(Ze)!=="svelte-1ovcz13"&&(Ze.textContent=Yl),vs=n(e),c(He.$$.fragment,e),$s=n(e),c(_e.$$.fragment,e),xs=n(e),Re=o(e,"P",{"data-svelte-h":!0}),M(Re)!=="svelte-1vo10n6"&&(Re.innerHTML=El),As=n(e),x=o(e,"DIV",{class:!0,"data-svelte-h":!0}),M(x)!=="svelte-1roilif"&&(x.innerHTML=Nl),qs=n(e),Se=o(e,"P",{"data-svelte-h":!0}),M(Se)!=="svelte-1072wo1"&&(Se.textContent=Fl),ks=n(e),c(We.$$.fragment,e),Bs=n(e),Ve=o(e,"P",{"data-svelte-h":!0}),M(Ve)!=="svelte-ogq2gt"&&(Ve.textContent=zl),Gs=n(e),c(Xe.$$.fragment,e),Zs=n(e),Qe=o(e,"P",{"data-svelte-h":!0}),M(Qe)!=="svelte-krncuc"&&(Qe.textContent=Pl),Hs=n(e),c(Ye.$$.fragment,e),_s=n(e),c(Ee.$$.fragment,e),Rs=n(e),Ne=o(e,"P",{"data-svelte-h":!0}),M(Ne)!=="svelte-bpbibl"&&(Ne.innerHTML=Ll),Ss=n(e),c(Fe.$$.fragment,e),Ws=n(e),ze=o(e,"P",{"data-svelte-h":!0}),M(ze)!=="svelte-speu7d"&&(ze.textContent=Dl),Vs=n(e),Pe=o(e,"P",{"data-svelte-h":!0}),M(Pe)!=="svelte-13ler1d"&&(Pe.innerHTML=Ol),Xs=n(e),Le=o(e,"P",{"data-svelte-h":!0}),M(Le)!=="svelte-ub059v"&&(Le.innerHTML=Kl),Qs=n(e),c(De.$$.fragment,e),Ys=n(e),c(Oe.$$.fragment,e),Es=n(e),c(A.$$.fragment,e),Ns=n(e),c(Ke.$$.fragment,e),Fs=n(e),et=o(e,"P",{"data-svelte-h":!0}),M(et)!=="svelte-102eqn3"&&(et.innerHTML=ea),zs=n(e),tt=o(e,"P",{"data-svelte-h":!0}),M(tt)!=="svelte-lavds"&&(tt.innerHTML=ta),Ps=n(e),st=o(e,"P",{"data-svelte-h":!0}),M(st)!=="svelte-f0qt8k"&&(st.textContent=sa),Ls=n(e),lt=o(e,"P",{"data-svelte-h":!0}),M(lt)!=="svelte-w9ft7n"&&(lt.textContent=la),Ds=n(e),c(at.$$.fragment,e),Os=n(e),c(nt.$$.fragment,e),Ks=n(e),it=o(e,"UL",{"data-svelte-h":!0}),M(it)!=="svelte-117ozzs"&&(it.innerHTML=aa),el=n(e),c(pt.$$.fragment,e),tl=n(e),ot=o(e,"UL",{"data-svelte-h":!0}),M(ot)!=="svelte-vl7c7p"&&(ot.innerHTML=na),sl=n(e),c(Mt.$$.fragment,e),ll=n(e),rt=o(e,"P",{"data-svelte-h":!0}),M(rt)!=="svelte-1yfr1yr"&&(rt.innerHTML=ia),al=n(e),ut=o(e,"P",{"data-svelte-h":!0}),M(ut)!=="svelte-1duzsqa"&&(ut.innerHTML=pa),nl=n(e),c(ct.$$.fragment,e),il=n(e),dt=o(e,"P",{}),da(dt).forEach(s),this.h()},h(){ol(i,"name","hf:doc:metadata"),ol(i,"content",qa),ol(g,"class","flex justify-center"),ol(x,"class","flex justify-center")},m(e,t){wa(document.head,i),l(e,U,t),l(e,r,t),l(e,m,t),y(q,e,t),l(e,Jt,t),y(f,e,t),l(e,Ut,t),l(e,k,t),l(e,jt,t),l(e,B,t),l(e,mt,t),y(G,e,t),l(e,Tt,t),y(I,e,t),l(e,wt,t),l(e,Z,t),l(e,ft,t),l(e,H,t),l(e,It,t),y(_,e,t),l(e,gt,t),l(e,R,t),l(e,Ct,t),l(e,g,t),l(e,bt,t),l(e,S,t),l(e,vt,t),y(C,e,t),l(e,$t,t),y(W,e,t),l(e,xt,t),l(e,V,t),l(e,At,t),l(e,X,t),l(e,qt,t),l(e,Q,t),l(e,kt,t),y(Y,e,t),l(e,Bt,t),l(e,E,t),l(e,Gt,t),y(N,e,t),l(e,Zt,t),l(e,F,t),l(e,Ht,t),y(z,e,t),l(e,_t,t),l(e,P,t),l(e,Rt,t),l(e,L,t),l(e,St,t),l(e,D,t),l(e,Wt,t),y(O,e,t),l(e,Vt,t),l(e,K,t),l(e,Xt,t),l(e,ee,t),l(e,Qt,t),y(te,e,t),l(e,Yt,t),l(e,se,t),l(e,Et,t),l(e,le,t),l(e,Nt,t),y(b,e,t),l(e,Ft,t),y(ae,e,t),l(e,zt,t),y(ne,e,t),l(e,Pt,t),l(e,ie,t),l(e,Lt,t),y(pe,e,t),l(e,Dt,t),l(e,oe,t),l(e,Ot,t),l(e,Me,t),l(e,Kt,t),y(re,e,t),l(e,es,t),l(e,ue,t),l(e,ts,t),y(v,e,t),l(e,ss,t),l(e,ce,t),l(e,ls,t),y(ye,e,t),l(e,as,t),l(e,he,t),l(e,ns,t),y(de,e,t),l(e,is,t),l(e,Je,t),l(e,ps,t),l(e,Ue,t),l(e,os,t),y(je,e,t),l(e,Ms,t),l(e,me,t),l(e,rs,t),y(Te,e,t),l(e,us,t),l(e,we,t),l(e,cs,t),l(e,fe,t),l(e,ys,t),y(Ie,e,t),l(e,hs,t),y(ge,e,t),l(e,ds,t),l(e,Ce,t),l(e,Js,t),y(be,e,t),l(e,Us,t),l(e,ve,t),l(e,js,t),y($e,e,t),l(e,ms,t),l(e,xe,t),l(e,Ts,t),y(Ae,e,t),l(e,ws,t),l(e,qe,t),l(e,fs,t),y(ke,e,t),l(e,Is,t),y(Be,e,t),l(e,gs,t),l(e,Ge,t),l(e,Cs,t),y($,e,t),l(e,bs,t),l(e,Ze,t),l(e,vs,t),y(He,e,t),l(e,$s,t),y(_e,e,t),l(e,xs,t),l(e,Re,t),l(e,As,t),l(e,x,t),l(e,qs,t),l(e,Se,t),l(e,ks,t),y(We,e,t),l(e,Bs,t),l(e,Ve,t),l(e,Gs,t),y(Xe,e,t),l(e,Zs,t),l(e,Qe,t),l(e,Hs,t),y(Ye,e,t),l(e,_s,t),y(Ee,e,t),l(e,Rs,t),l(e,Ne,t),l(e,Ss,t),y(Fe,e,t),l(e,Ws,t),l(e,ze,t),l(e,Vs,t),l(e,Pe,t),l(e,Xs,t),l(e,Le,t),l(e,Qs,t),y(De,e,t),l(e,Ys,t),y(Oe,e,t),l(e,Es,t),y(A,e,t),l(e,Ns,t),y(Ke,e,t),l(e,Fs,t),l(e,et,t),l(e,zs,t),l(e,tt,t),l(e,Ps,t),l(e,st,t),l(e,Ls,t),l(e,lt,t),l(e,Ds,t),y(at,e,t),l(e,Os,t),y(nt,e,t),l(e,Ks,t),l(e,it,t),l(e,el,t),y(pt,e,t),l(e,tl,t),l(e,ot,t),l(e,sl,t),y(Mt,e,t),l(e,ll,t),l(e,rt,t),l(e,al,t),l(e,ut,t),l(e,nl,t),y(ct,e,t),l(e,il,t),l(e,dt,t),pl=!0},p(e,[t]){const oa={};t&2&&(oa.$$scope={dirty:t,ctx:e}),f.$set(oa);const Ma={};t&2&&(Ma.$$scope={dirty:t,ctx:e}),I.$set(Ma);const ra={};t&2&&(ra.$$scope={dirty:t,ctx:e}),C.$set(ra);const ua={};t&2&&(ua.$$scope={dirty:t,ctx:e}),b.$set(ua);const ca={};t&2&&(ca.$$scope={dirty:t,ctx:e}),v.$set(ca);const ya={};t&2&&(ya.$$scope={dirty:t,ctx:e}),$.$set(ya);const ha={};t&2&&(ha.$$scope={dirty:t,ctx:e}),A.$set(ha)},i(e){pl||(h(q.$$.fragment,e),h(f.$$.fragment,e),h(G.$$.fragment,e),h(I.$$.fragment,e),h(_.$$.fragment,e),h(C.$$.fragment,e),h(W.$$.fragment,e),h(Y.$$.fragment,e),h(N.$$.fragment,e),h(z.$$.fragment,e),h(O.$$.fragment,e),h(te.$$.fragment,e),h(b.$$.fragment,e),h(ae.$$.fragment,e),h(ne.$$.fragment,e),h(pe.$$.fragment,e),h(re.$$.fragment,e),h(v.$$.fragment,e),h(ye.$$.fragment,e),h(de.$$.fragment,e),h(je.$$.fragment,e),h(Te.$$.fragment,e),h(Ie.$$.fragment,e),h(ge.$$.fragment,e),h(be.$$.fragment,e),h($e.$$.fragment,e),h(Ae.$$.fragment,e),h(ke.$$.fragment,e),h(Be.$$.fragment,e),h($.$$.fragment,e),h(He.$$.fragment,e),h(_e.$$.fragment,e),h(We.$$.fragment,e),h(Xe.$$.fragment,e),h(Ye.$$.fragment,e),h(Ee.$$.fragment,e),h(Fe.$$.fragment,e),h(De.$$.fragment,e),h(Oe.$$.fragment,e),h(A.$$.fragment,e),h(Ke.$$.fragment,e),h(at.$$.fragment,e),h(nt.$$.fragment,e),h(pt.$$.fragment,e),h(Mt.$$.fragment,e),h(ct.$$.fragment,e),pl=!0)},o(e){d(q.$$.fragment,e),d(f.$$.fragment,e),d(G.$$.fragment,e),d(I.$$.fragment,e),d(_.$$.fragment,e),d(C.$$.fragment,e),d(W.$$.fragment,e),d(Y.$$.fragment,e),d(N.$$.fragment,e),d(z.$$.fragment,e),d(O.$$.fragment,e),d(te.$$.fragment,e),d(b.$$.fragment,e),d(ae.$$.fragment,e),d(ne.$$.fragment,e),d(pe.$$.fragment,e),d(re.$$.fragment,e),d(v.$$.fragment,e),d(ye.$$.fragment,e),d(de.$$.fragment,e),d(je.$$.fragment,e),d(Te.$$.fragment,e),d(Ie.$$.fragment,e),d(ge.$$.fragment,e),d(be.$$.fragment,e),d($e.$$.fragment,e),d(Ae.$$.fragment,e),d(ke.$$.fragment,e),d(Be.$$.fragment,e),d($.$$.fragment,e),d(He.$$.fragment,e),d(_e.$$.fragment,e),d(We.$$.fragment,e),d(Xe.$$.fragment,e),d(Ye.$$.fragment,e),d(Ee.$$.fragment,e),d(Fe.$$.fragment,e),d(De.$$.fragment,e),d(Oe.$$.fragment,e),d(A.$$.fragment,e),d(Ke.$$.fragment,e),d(at.$$.fragment,e),d(nt.$$.fragment,e),d(pt.$$.fragment,e),d(Mt.$$.fragment,e),d(ct.$$.fragment,e),pl=!1},d(e){e&&(s(U),s(r),s(m),s(Jt),s(Ut),s(k),s(jt),s(B),s(mt),s(Tt),s(wt),s(Z),s(ft),s(H),s(It),s(gt),s(R),s(Ct),s(g),s(bt),s(S),s(vt),s($t),s(xt),s(V),s(At),s(X),s(qt),s(Q),s(kt),s(Bt),s(E),s(Gt),s(Zt),s(F),s(Ht),s(_t),s(P),s(Rt),s(L),s(St),s(D),s(Wt),s(Vt),s(K),s(Xt),s(ee),s(Qt),s(Yt),s(se),s(Et),s(le),s(Nt),s(Ft),s(zt),s(Pt),s(ie),s(Lt),s(Dt),s(oe),s(Ot),s(Me),s(Kt),s(es),s(ue),s(ts),s(ss),s(ce),s(ls),s(as),s(he),s(ns),s(is),s(Je),s(ps),s(Ue),s(os),s(Ms),s(me),s(rs),s(us),s(we),s(cs),s(fe),s(ys),s(hs),s(ds),s(Ce),s(Js),s(Us),s(ve),s(js),s(ms),s(xe),s(Ts),s(ws),s(qe),s(fs),s(Is),s(gs),s(Ge),s(Cs),s(bs),s(Ze),s(vs),s($s),s(xs),s(Re),s(As),s(x),s(qs),s(Se),s(ks),s(Bs),s(Ve),s(Gs),s(Zs),s(Qe),s(Hs),s(_s),s(Rs),s(Ne),s(Ss),s(Ws),s(ze),s(Vs),s(Pe),s(Xs),s(Le),s(Qs),s(Ys),s(Es),s(Ns),s(Fs),s(et),s(zs),s(tt),s(Ps),s(st),s(Ls),s(lt),s(Ds),s(Os),s(Ks),s(it),s(el),s(tl),s(ot),s(sl),s(ll),s(rt),s(al),s(ut),s(nl),s(il),s(dt)),s(i),J(q,e),J(f,e),J(G,e),J(I,e),J(_,e),J(C,e),J(W,e),J(Y,e),J(N,e),J(z,e),J(O,e),J(te,e),J(b,e),J(ae,e),J(ne,e),J(pe,e),J(re,e),J(v,e),J(ye,e),J(de,e),J(je,e),J(Te,e),J(Ie,e),J(ge,e),J(be,e),J($e,e),J(Ae,e),J(ke,e),J(Be,e),J($,e),J(He,e),J(_e,e),J(We,e),J(Xe,e),J(Ye,e),J(Ee,e),J(Fe,e),J(De,e),J(Oe,e),J(A,e),J(Ke,e),J(at,e),J(nt,e),J(pt,e),J(Mt,e),J(ct,e)}}}const qa='{"title":"How to be registered as an inference provider on the Hub?","local":"how-to-be-registered-as-an-inference-provider-on-the-hub","sections":[{"title":"1. Prerequisites","local":"1-prerequisites","sections":[{"title":"What is a Task","local":"what-is-a-task","sections":[],"depth":3},{"title":"Task API schema","local":"task-api-schema","sections":[],"depth":3}],"depth":2},{"title":"2. JS Client Integration","local":"2-js-client-integration","sections":[{"title":"Implement the provider helper (JS)","local":"implement-the-provider-helper-js","sections":[],"depth":3},{"title":"Register the provider","local":"register-the-provider","sections":[],"depth":3}],"depth":2},{"title":"3. Model Mapping API","local":"3-model-mapping-api","sections":[{"title":"Register a mapping item","local":"register-a-mapping-item","sections":[],"depth":3},{"title":"Using a tag-filter to map several HF models to a single inference endpoint","local":"using-a-tag-filter-to-map-several-hf-models-to-a-single-inference-endpoint","sections":[{"title":"Authentication","local":"authentication","sections":[],"depth":4},{"title":"Validation","local":"validation","sections":[],"depth":4}],"depth":3},{"title":"Delete a mapping item","local":"delete-a-mapping-item","sections":[],"depth":3},{"title":"Update a mapping item’s status","local":"update-a-mapping-items-status","sections":[],"depth":3},{"title":"List the whole mapping","local":"list-the-whole-mapping","sections":[],"depth":3}],"depth":2},{"title":"4. Billing","local":"4-billing","sections":[{"title":"HTTP API Specs","local":"http-api-specs","sections":[],"depth":3},{"title":"Price Unit","local":"price-unit","sections":[],"depth":3},{"title":"How to define the request ID","local":"how-to-define-the-request-id","sections":[],"depth":3}],"depth":2},{"title":"5. Python client integration","local":"5-python-client-integration","sections":[{"title":"Implement the provider helper (Python)","local":"implement-the-provider-helper-python","sections":[],"depth":3},{"title":"Register the Provider","local":"register-the-provider","sections":[],"depth":3},{"title":"Add tests","local":"add-tests","sections":[],"depth":3}],"depth":2},{"title":"FAQ","local":"faq","sections":[],"depth":2}],"depth":1}';function ka(T){return Ua(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ra extends ja{constructor(i){super(),ma(this,i,ka,Aa,Ja,{})}}export{Ra as component};
