import{s as je,f as ht,n as Je,o as Te}from"../chunks/scheduler.37c15a92.js";import{S as we,i as ce,g as M,s as n,r as m,A as Ue,h as p,f as e,c as a,j as It,u as r,x as i,k as y,y as ue,a as s,v as j,d as J,t as T,w}from"../chunks/index.2bf4358c.js";import{C as dt}from"../chunks/CodeBlock.4e987730.js";import{H as cl}from"../chunks/Heading.8ada512a.js";import{E as be}from"../chunks/getInferenceSnippets.acd17970.js";function de(Ct){let c,Ul,Tl,ul,U,bl,u,Bt="在上一节中，我们学习了如何使用 Python 代码从头开始创建智能体，并且我们<strong>看到了这个过程是多么繁琐</strong>。幸运的是，许多智能体库通过<strong>为你处理大量繁重的工作</strong>来简化这项工作。",dl,b,ft="在本教程中，<strong>你将创建你的第一个智能体</strong>，它能够执行图像生成、网络搜索、时区检查等更多操作！",hl,d,gt="你还将把你的智能体<strong>发布到 Hugging Face Space 上，以便与朋友和同事分享</strong>。",Il,h,Zt="让我们开始吧！",Cl,I,Bl,C,vt,fl,B,Gt="为了创建这个智能体，我们将使用 <code>smolagents</code>，这是一个<strong>提供轻松开发智能体框架的库</strong>。",gl,f,At="这个轻量级库设计简洁，但它抽象了构建智能体的许多复杂性，使你能够专注于设计智能体的行为。",Zl,g,Wt='我们将在下一个单元中深入了解 smolagents。同时，你也可以查看这篇<a href="https://huggingface.co/blog/smolagents" target="_blank">博客文章</a>或该库的<a href="https://github.com/huggingface/smolagents" target="_blank">GitHub 仓库</a>。',vl,Z,_t="简而言之，<code>smolagents</code> 是一个专注于 <strong>codeAgent</strong> 的库，codeAgent 是一种通过代码块执行<strong>“操作”</strong>，然后通过执行代码<strong>“观察”</strong>结果的智能体。",Gl,v,Ht="以下是我们将构建的一个示例！",Al,G,Et="我们为我们的智能体提供了一个<strong>图像生成工具</strong>，并要求它生成一张猫的图片。",Wl,A,Vt="<code>smolagents</code> 中的智能体将具有<strong>与我们之前构建的自定义智能体相同的行为</strong>：它将<strong>以循环的方式思考、行动和观察</strong>，直到得出最终答案：",_l,o,xt,Hl,W,Rt="很令人兴奋，对吧？",El,_,Vl,H,Qt='首先，复制这个 Space：<a href="https://huggingface.co/spaces/agents-course/First_agent_template" target="_blank">https://huggingface.co/spaces/agents-course/First_agent_template</a>',xl,E,kt='<p>感谢 <a href="https://huggingface.co/m-ric" target="_blank">Aymeric</a> 提供的这个模板！🙌</p>',Rl,V,St="复制这个 Space 意味着<strong>在你的个人资料中创建一个本地副本</strong>：",Ql,x,zt,kl,R,Nt="复制这个 Space 之后，<strong>你需要添加你的 Hugging Face API 令牌</strong>，以便你的<strong>智能体</strong>可以调用模型 API。",Sl,Q,Xt='<li>首先，从<a href="https://hf.co/settings/tokens" rel="nofollow">https://hf.co/settings/tokens </a>获取一个具有<strong>推理权限</strong>的令牌，第4步需要用到。如果你已经有了，可以跳过此步。</li> <li>进入你的主页，找到刚才复制的空间，点击<strong>设置</strong>按钮。</li> <li>向下滚动到<strong>变量和密钥</strong>部分，点击<strong>新建密钥</strong>。</li> <li>创建一个名为<strong>HF_TOKEN</strong>的密钥，值为第一步获取到的令牌。</li> <li>点击<strong>保存</strong>。</li>',zl,k,Ft='在整个课程中，你唯一需要修改的文件是当前不完整的<strong>“app.py”</strong>。你可以在这里查看<a href="https://huggingface.co/spaces/agents-course/First_agent_template/blob/main/app.py" rel="nofollow">模板中的原始文件</a>。要找到你的文件，请进入你复制的 Space，然后点击 <code>Files</code> 选项卡，再在目录列表中点击 <code>app.py</code>。',Nl,S,$t="让我们一起分解代码：",Xl,z,Lt="<li>文件开头是一些简单但必要的库导入</li>",Fl,N,$l,X,Yt="正如之前所述，我们将直接使用 <strong>smolagents</strong> 中的 <strong>CodeAgent</strong> 类。",Ll,F,Yl,$,qt='现在让我们来了解一下工具！如果你需要回顾一下工具的相关内容，请随时回到课程的<a href="tools">工具</a>部分。',ql,L,Pl,Y,Pt="这些工具是我们在这个部分鼓励你构建的东西！我们给你两个例子：",Dl,q,Dt="<li>一个<strong>不工作的虚拟工具</strong>，你可以修改它来制作一些有用的东西。</li> <li>一个<strong>实际工作的工具</strong>，它可以获取世界某地的当前时间。</li>",Kl,P,Kt="要定义你的工具，重要的是：",Ol,D,Ot="<li>为你的函数提供输入和输出类型，例如 <code>get_current_time_in_timezone(timezone: str) -&gt; str:</code></li> <li><strong>格式良好的文档字符串</strong>。<code>smolagents</code> 期望所有参数在文档字符串中都有<strong>文字描述</strong>。</li>",lt,K,tt,O,le='它使用 <a href="https://huggingface.co/Qwen/Qwen2.5-Coder-32B-Instruct" rel="nofollow"><code>Qwen/Qwen2.5-Coder-32B-Instruct</code></a> 作为 LLM 引擎。这是一个非常强大的模型，我们将通过无服务器 API 访问它。',et,ll,st,tl,te="这个智能体仍在使用我们在前面部分中看到的<code>InferenceClient</code>，它位于<strong>InferenceClientModel</strong>类的背后！",nt,el,ee="当我们介绍 Unit 2 中的框架时，我们会给出更深入的例子。目前，你需要专注于通过智能体的<code>tools</code>参数<strong>向工具列表中添加新工具</strong>。",at,sl,se="例如，你可以使用代码第一行导入的<code>DuckDuckGoSearchTool</code>，或者你可以检查稍后从 Hub 加载的<code>image_generation_tool</code>。",Mt,nl,ne="<strong>添加工具将赋予你的智能体新的能力</strong>，在这里尝试发挥创意吧！",pt,al,ae="完整的”app.py”：",it,Ml,ot,pl,Me="你的<strong>目标</strong>是熟悉 Space 和智能体。",yt,il,pe="目前，模板中的智能体<strong>没有使用任何工具，所以尝试为它提供一些预制的工具，甚至自己动手制作一些新工具！</strong>",mt,ol,ie="我们非常期待在 Discord 频道 <strong>#agents-course-showcase</strong> 中看到你的精彩智能体成果！",rt,jt,Jt,yl,oe="恭喜你，你已经构建了你的第一个智能体！不要犹豫，与你的朋友和同事分享吧。",Tt,ml,ye="由于这是你的第一次尝试，如果有点小问题或速度有点慢，这是完全正常的。在未来的单元中，我们将学习如何构建更好的智能体。",wt,rl,me="最好的学习方法是尝试，所以不要犹豫，去更新它，添加更多工具，尝试使用另一个模型，等等。",ct,jl,re="在下一节中，你将完成最后的测验并获得证书！",Ut,Jl,ut,wl,bt;return U=new cl({props:{title:"使用 smolagents 创建我们的第一个智能体",local:"使用-smolagents-创建我们的第一个智能体",headingTag:"h1"}}),I=new cl({props:{title:"什么是 smolagents？",local:"什么是-smolagents",headingTag:"h2"}}),_=new cl({props:{title:"让我们来构建我们的智能体！",local:"让我们来构建我们的智能体",headingTag:"h2"}}),N=new dt({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBDb2RlQWdlbnQlMkMlMjBEdWNrRHVja0dvU2VhcmNoVG9vbCUyQyUyMEluZmVyZW5jZUNsaWVudE1vZGVsJTJDJTIwbG9hZF90b29sJTJDJTIwdG9vbCUwQWltcG9ydCUyMGRhdGV0aW1lJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEFpbXBvcnQlMjBweXR6JTBBaW1wb3J0JTIweWFtbCUwQWZyb20lMjB0b29scy5maW5hbF9hbnN3ZXIlMjBpbXBvcnQlMjBGaW5hbEFuc3dlclRvb2w=",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent, DuckDuckGoSearchTool, InferenceClientModel, load_tool, tool
<span class="hljs-keyword">import</span> datetime
<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">import</span> pytz
<span class="hljs-keyword">import</span> yaml
<span class="hljs-keyword">from</span> tools.final_answer <span class="hljs-keyword">import</span> FinalAnswerTool`,wrap:!1}}),F=new cl({props:{title:"Tool（工具）",local:"tool工具",headingTag:"h3"}}),L=new dt({props:{code:"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",highlighted:`<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">my_custom_tool</span>(<span class="hljs-params">arg1:<span class="hljs-built_in">str</span>, arg2:<span class="hljs-built_in">int</span></span>)-&gt; <span class="hljs-built_in">str</span>: <span class="hljs-comment"># it&#x27;s important to specify the return type</span>
    <span class="hljs-comment"># Keep this format for the tool description / args description but feel free to modify the tool</span>
    <span class="hljs-string">&quot;&quot;&quot;A tool that does nothing yet 
    Args:
        arg1: the first argument
        arg2: the second argument
    &quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;What magic will you build ?&quot;</span>

<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_current_time_in_timezone</span>(<span class="hljs-params">timezone: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-string">&quot;&quot;&quot;A tool that fetches the current local time in a specified timezone.
    Args:
        timezone: A string representing a valid timezone (e.g., &#x27;America/New_York&#x27;).
    &quot;&quot;&quot;</span>
    <span class="hljs-keyword">try</span>:
        <span class="hljs-comment"># Create timezone object</span>
        tz = pytz.timezone(timezone)
        <span class="hljs-comment"># Get current time in that timezone</span>
        local_time = datetime.datetime.now(tz).strftime(<span class="hljs-string">&quot;%Y-%m-%d %H:%M:%S&quot;</span>)
        <span class="hljs-keyword">return</span> <span class="hljs-string">f&quot;The current local time in <span class="hljs-subst">{timezone}</span> is: <span class="hljs-subst">{local_time}</span>&quot;</span>
    <span class="hljs-keyword">except</span> Exception <span class="hljs-keyword">as</span> e:
        <span class="hljs-keyword">return</span> <span class="hljs-string">f&quot;Error fetching time for timezone &#x27;<span class="hljs-subst">{timezone}</span>&#x27;: <span class="hljs-subst">{<span class="hljs-built_in">str</span>(e)}</span>&quot;</span>`,wrap:!1}}),K=new cl({props:{title:"The Agent（智能体）",local:"the-agent智能体",headingTag:"h3"}}),ll=new dt({props:{code:"ZmluYWxfYW5zd2VyJTIwJTNEJTIwRmluYWxBbnN3ZXJUb29sKCklMEFtb2RlbCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudE1vZGVsKCUwQSUyMCUyMCUyMCUyMG1heF90b2tlbnMlM0QyMDk2JTJDJTBBJTIwJTIwJTIwJTIwdGVtcGVyYXR1cmUlM0QwLjUlMkMlMEElMjAlMjAlMjAlMjBtb2RlbF9pZCUzRCdRd2VuJTJGUXdlbjIuNS1Db2Rlci0zMkItSW5zdHJ1Y3QnJTJDJTBBJTIwJTIwJTIwJTIwY3VzdG9tX3JvbGVfY29udmVyc2lvbnMlM0ROb25lJTJDJTBBKSUwQSUwQXdpdGglMjBvcGVuKCUyMnByb21wdHMueWFtbCUyMiUyQyUyMCdyJyklMjBhcyUyMHN0cmVhbSUzQSUwQSUyMCUyMCUyMCUyMHByb21wdF90ZW1wbGF0ZXMlMjAlM0QlMjB5YW1sLnNhZmVfbG9hZChzdHJlYW0pJTBBJTIwJTIwJTIwJTIwJTBBJTIzJTIwV2UncmUlMjBjcmVhdGluZyUyMG91ciUyMENvZGVBZ2VudCUwQWFnZW50JTIwJTNEJTIwQ29kZUFnZW50KCUwQSUyMCUyMCUyMCUyMG1vZGVsJTNEbW9kZWwlMkMlMEElMjAlMjAlMjAlMjB0b29scyUzRCU1QmZpbmFsX2Fuc3dlciU1RCUyQyUyMCUyMyUyMGFkZCUyMHlvdXIlMjB0b29scyUyMGhlcmUlMjAoZG9uJ3QlMjByZW1vdmUlMjBmaW5hbF9hbnN3ZXIpJTBBJTIwJTIwJTIwJTIwbWF4X3N0ZXBzJTNENiUyQyUwQSUyMCUyMCUyMCUyMHZlcmJvc2l0eV9sZXZlbCUzRDElMkMlMEElMjAlMjAlMjAlMjBncmFtbWFyJTNETm9uZSUyQyUwQSUyMCUyMCUyMCUyMHBsYW5uaW5nX2ludGVydmFsJTNETm9uZSUyQyUwQSUyMCUyMCUyMCUyMG5hbWUlM0ROb25lJTJDJTBBJTIwJTIwJTIwJTIwZGVzY3JpcHRpb24lM0ROb25lJTJDJTBBJTIwJTIwJTIwJTIwcHJvbXB0X3RlbXBsYXRlcyUzRHByb21wdF90ZW1wbGF0ZXMlMEEpJTBBJTBBR3JhZGlvVUkoYWdlbnQpLmxhdW5jaCgp",highlighted:`final_answer = FinalAnswerTool()
model = InferenceClientModel(
    max_tokens=<span class="hljs-number">2096</span>,
    temperature=<span class="hljs-number">0.5</span>,
    model_id=<span class="hljs-string">&#x27;Qwen/Qwen2.5-Coder-32B-Instruct&#x27;</span>,
    custom_role_conversions=<span class="hljs-literal">None</span>,
)

<span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;prompts.yaml&quot;</span>, <span class="hljs-string">&#x27;r&#x27;</span>) <span class="hljs-keyword">as</span> stream:
    prompt_templates = yaml.safe_load(stream)
    
<span class="hljs-comment"># We&#x27;re creating our CodeAgent</span>
agent = CodeAgent(
    model=model,
    tools=[final_answer], <span class="hljs-comment"># add your tools here (don&#x27;t remove final_answer)</span>
    max_steps=<span class="hljs-number">6</span>,
    verbosity_level=<span class="hljs-number">1</span>,
    grammar=<span class="hljs-literal">None</span>,
    planning_interval=<span class="hljs-literal">None</span>,
    name=<span class="hljs-literal">None</span>,
    description=<span class="hljs-literal">None</span>,
    prompt_templates=prompt_templates
)

GradioUI(agent).launch()`,wrap:!1}}),Ml=new dt({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent, DuckDuckGoSearchTool, InferenceClientModel, load_tool, tool
<span class="hljs-keyword">import</span> datetime
<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">import</span> pytz
<span class="hljs-keyword">import</span> yaml
<span class="hljs-keyword">from</span> tools.final_answer <span class="hljs-keyword">import</span> FinalAnswerTool

<span class="hljs-keyword">from</span> Gradio_UI <span class="hljs-keyword">import</span> GradioUI

<span class="hljs-comment"># Below is an example of a tool that does nothing. Amaze us with your creativity!</span>
<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">my_custom_tool</span>(<span class="hljs-params">arg1:<span class="hljs-built_in">str</span>, arg2:<span class="hljs-built_in">int</span></span>)-&gt; <span class="hljs-built_in">str</span>: <span class="hljs-comment"># it&#x27;s important to specify the return type</span>
    <span class="hljs-comment"># Keep this format for the tool description / args description but feel free to modify the tool</span>
    <span class="hljs-string">&quot;&quot;&quot;A tool that does nothing yet 
    Args:
        arg1: the first argument
        arg2: the second argument
    &quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;What magic will you build ?&quot;</span>

<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_current_time_in_timezone</span>(<span class="hljs-params">timezone: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-string">&quot;&quot;&quot;A tool that fetches the current local time in a specified timezone.
    Args:
        timezone: A string representing a valid timezone (e.g., &#x27;America/New_York&#x27;).
    &quot;&quot;&quot;</span>
    <span class="hljs-keyword">try</span>:
        <span class="hljs-comment"># Create timezone object</span>
        tz = pytz.timezone(timezone)
        <span class="hljs-comment"># Get current time in that timezone</span>
        local_time = datetime.datetime.now(tz).strftime(<span class="hljs-string">&quot;%Y-%m-%d %H:%M:%S&quot;</span>)
        <span class="hljs-keyword">return</span> <span class="hljs-string">f&quot;The current local time in <span class="hljs-subst">{timezone}</span> is: <span class="hljs-subst">{local_time}</span>&quot;</span>
    <span class="hljs-keyword">except</span> Exception <span class="hljs-keyword">as</span> e:
        <span class="hljs-keyword">return</span> <span class="hljs-string">f&quot;Error fetching time for timezone &#x27;<span class="hljs-subst">{timezone}</span>&#x27;: <span class="hljs-subst">{<span class="hljs-built_in">str</span>(e)}</span>&quot;</span>


final_answer = FinalAnswerTool()
model = InferenceClientModel(
    max_tokens=<span class="hljs-number">2096</span>,
    temperature=<span class="hljs-number">0.5</span>,
    model_id=<span class="hljs-string">&#x27;Qwen/Qwen2.5-Coder-32B-Instruct&#x27;</span>,
    custom_role_conversions=<span class="hljs-literal">None</span>,
)


<span class="hljs-comment"># Import tool from Hub</span>
image_generation_tool = load_tool(<span class="hljs-string">&quot;agents-course/text-to-image&quot;</span>, trust_remote_code=<span class="hljs-literal">True</span>)

<span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;prompts.yaml&quot;</span>, <span class="hljs-string">&#x27;r&#x27;</span>) <span class="hljs-keyword">as</span> stream:
    prompt_templates = yaml.safe_load(stream)
    
agent = CodeAgent(
    model=model,
    tools=[final_answer], <span class="hljs-comment"># add your tools here (don&#x27;t remove final_answer)</span>
    max_steps=<span class="hljs-number">6</span>,
    verbosity_level=<span class="hljs-number">1</span>,
    grammar=<span class="hljs-literal">None</span>,
    planning_interval=<span class="hljs-literal">None</span>,
    name=<span class="hljs-literal">None</span>,
    description=<span class="hljs-literal">None</span>,
    prompt_templates=prompt_templates
)


GradioUI(agent).launch()`,wrap:!1}}),Jl=new be({props:{source:"https://github.com/huggingface/agents-course/blob/main/units/zh-CN/unit1/tutorial.mdx"}}),{c(){c=M("meta"),Ul=n(),Tl=M("p"),ul=n(),m(U.$$.fragment),bl=n(),u=M("p"),u.innerHTML=Bt,dl=n(),b=M("p"),b.innerHTML=ft,hl=n(),d=M("p"),d.innerHTML=gt,Il=n(),h=M("p"),h.textContent=Zt,Cl=n(),m(I.$$.fragment),Bl=n(),C=M("img"),fl=n(),B=M("p"),B.innerHTML=Gt,gl=n(),f=M("p"),f.textContent=At,Zl=n(),g=M("p"),g.innerHTML=Wt,vl=n(),Z=M("p"),Z.innerHTML=_t,Gl=n(),v=M("p"),v.textContent=Ht,Al=n(),G=M("p"),G.innerHTML=Et,Wl=n(),A=M("p"),A.innerHTML=Vt,_l=n(),o=M("iframe"),Hl=n(),W=M("p"),W.textContent=Rt,El=n(),m(_.$$.fragment),Vl=n(),H=M("p"),H.innerHTML=Qt,xl=n(),E=M("blockquote"),E.innerHTML=kt,Rl=n(),V=M("p"),V.innerHTML=St,Ql=n(),x=M("img"),kl=n(),R=M("p"),R.innerHTML=Nt,Sl=n(),Q=M("ol"),Q.innerHTML=Xt,zl=n(),k=M("p"),k.innerHTML=Ft,Nl=n(),S=M("p"),S.textContent=$t,Xl=n(),z=M("ul"),z.innerHTML=Lt,Fl=n(),m(N.$$.fragment),$l=n(),X=M("p"),X.innerHTML=Yt,Ll=n(),m(F.$$.fragment),Yl=n(),$=M("p"),$.innerHTML=qt,ql=n(),m(L.$$.fragment),Pl=n(),Y=M("p"),Y.textContent=Pt,Dl=n(),q=M("ol"),q.innerHTML=Dt,Kl=n(),P=M("p"),P.textContent=Kt,Ol=n(),D=M("ol"),D.innerHTML=Ot,lt=n(),m(K.$$.fragment),tt=n(),O=M("p"),O.innerHTML=le,et=n(),m(ll.$$.fragment),st=n(),tl=M("p"),tl.innerHTML=te,nt=n(),el=M("p"),el.innerHTML=ee,at=n(),sl=M("p"),sl.innerHTML=se,Mt=n(),nl=M("p"),nl.innerHTML=ne,pt=n(),al=M("p"),al.textContent=ae,it=n(),m(Ml.$$.fragment),ot=n(),pl=M("p"),pl.innerHTML=Me,yt=n(),il=M("p"),il.innerHTML=pe,mt=n(),ol=M("p"),ol.innerHTML=ie,rt=n(),jt=M("hr"),Jt=n(),yl=M("p"),yl.textContent=oe,Tt=n(),ml=M("p"),ml.textContent=ye,wt=n(),rl=M("p"),rl.textContent=me,ct=n(),jl=M("p"),jl.textContent=re,Ut=n(),m(Jl.$$.fragment),ut=n(),wl=M("p"),this.h()},l(l){const t=Ue("svelte-u9bgzb",document.head);c=p(t,"META",{name:!0,content:!0}),t.forEach(e),Ul=a(l),Tl=p(l,"P",{}),It(Tl).forEach(e),ul=a(l),r(U.$$.fragment,l),bl=a(l),u=p(l,"P",{"data-svelte-h":!0}),i(u)!=="svelte-1ujhsd9"&&(u.innerHTML=Bt),dl=a(l),b=p(l,"P",{"data-svelte-h":!0}),i(b)!=="svelte-1fz25zu"&&(b.innerHTML=ft),hl=a(l),d=p(l,"P",{"data-svelte-h":!0}),i(d)!=="svelte-vbbf2l"&&(d.innerHTML=gt),Il=a(l),h=p(l,"P",{"data-svelte-h":!0}),i(h)!=="svelte-izpy37"&&(h.textContent=Zt),Cl=a(l),r(I.$$.fragment,l),Bl=a(l),C=p(l,"IMG",{src:!0,alt:!0}),fl=a(l),B=p(l,"P",{"data-svelte-h":!0}),i(B)!=="svelte-1p4ogmz"&&(B.innerHTML=Gt),gl=a(l),f=p(l,"P",{"data-svelte-h":!0}),i(f)!=="svelte-1rnyukb"&&(f.textContent=At),Zl=a(l),g=p(l,"P",{"data-svelte-h":!0}),i(g)!=="svelte-eka5kk"&&(g.innerHTML=Wt),vl=a(l),Z=p(l,"P",{"data-svelte-h":!0}),i(Z)!=="svelte-1terpmt"&&(Z.innerHTML=_t),Gl=a(l),v=p(l,"P",{"data-svelte-h":!0}),i(v)!=="svelte-teea68"&&(v.textContent=Ht),Al=a(l),G=p(l,"P",{"data-svelte-h":!0}),i(G)!=="svelte-1rvw3dn"&&(G.innerHTML=Et),Wl=a(l),A=p(l,"P",{"data-svelte-h":!0}),i(A)!=="svelte-k9hzof"&&(A.innerHTML=Vt),_l=a(l),o=p(l,"IFRAME",{width:!0,height:!0,src:!0,title:!0,frameborder:!0,allow:!0,referrerpolicy:!0}),It(o).forEach(e),Hl=a(l),W=p(l,"P",{"data-svelte-h":!0}),i(W)!=="svelte-zp6tm6"&&(W.textContent=Rt),El=a(l),r(_.$$.fragment,l),Vl=a(l),H=p(l,"P",{"data-svelte-h":!0}),i(H)!=="svelte-1ga3nhy"&&(H.innerHTML=Qt),xl=a(l),E=p(l,"BLOCKQUOTE",{"data-svelte-h":!0}),i(E)!=="svelte-1szeww4"&&(E.innerHTML=kt),Rl=a(l),V=p(l,"P",{"data-svelte-h":!0}),i(V)!=="svelte-1lf9he9"&&(V.innerHTML=St),Ql=a(l),x=p(l,"IMG",{src:!0,alt:!0}),kl=a(l),R=p(l,"P",{"data-svelte-h":!0}),i(R)!=="svelte-cqt9ni"&&(R.innerHTML=Nt),Sl=a(l),Q=p(l,"OL",{"data-svelte-h":!0}),i(Q)!=="svelte-sng7af"&&(Q.innerHTML=Xt),zl=a(l),k=p(l,"P",{"data-svelte-h":!0}),i(k)!=="svelte-1rvndzh"&&(k.innerHTML=Ft),Nl=a(l),S=p(l,"P",{"data-svelte-h":!0}),i(S)!=="svelte-qzw9ae"&&(S.textContent=$t),Xl=a(l),z=p(l,"UL",{"data-svelte-h":!0}),i(z)!=="svelte-7zqdyp"&&(z.innerHTML=Lt),Fl=a(l),r(N.$$.fragment,l),$l=a(l),X=p(l,"P",{"data-svelte-h":!0}),i(X)!=="svelte-193ax9h"&&(X.innerHTML=Yt),Ll=a(l),r(F.$$.fragment,l),Yl=a(l),$=p(l,"P",{"data-svelte-h":!0}),i($)!=="svelte-1y6flx0"&&($.innerHTML=qt),ql=a(l),r(L.$$.fragment,l),Pl=a(l),Y=p(l,"P",{"data-svelte-h":!0}),i(Y)!=="svelte-txzape"&&(Y.textContent=Pt),Dl=a(l),q=p(l,"OL",{"data-svelte-h":!0}),i(q)!=="svelte-1nki85t"&&(q.innerHTML=Dt),Kl=a(l),P=p(l,"P",{"data-svelte-h":!0}),i(P)!=="svelte-e5waqh"&&(P.textContent=Kt),Ol=a(l),D=p(l,"OL",{"data-svelte-h":!0}),i(D)!=="svelte-3glxb2"&&(D.innerHTML=Ot),lt=a(l),r(K.$$.fragment,l),tt=a(l),O=p(l,"P",{"data-svelte-h":!0}),i(O)!=="svelte-15wg5ed"&&(O.innerHTML=le),et=a(l),r(ll.$$.fragment,l),st=a(l),tl=p(l,"P",{"data-svelte-h":!0}),i(tl)!=="svelte-o63072"&&(tl.innerHTML=te),nt=a(l),el=p(l,"P",{"data-svelte-h":!0}),i(el)!=="svelte-1trmkgr"&&(el.innerHTML=ee),at=a(l),sl=p(l,"P",{"data-svelte-h":!0}),i(sl)!=="svelte-1r29o7"&&(sl.innerHTML=se),Mt=a(l),nl=p(l,"P",{"data-svelte-h":!0}),i(nl)!=="svelte-1ex3pg"&&(nl.innerHTML=ne),pt=a(l),al=p(l,"P",{"data-svelte-h":!0}),i(al)!=="svelte-1islpf0"&&(al.textContent=ae),it=a(l),r(Ml.$$.fragment,l),ot=a(l),pl=p(l,"P",{"data-svelte-h":!0}),i(pl)!=="svelte-1mbhzkl"&&(pl.innerHTML=Me),yt=a(l),il=p(l,"P",{"data-svelte-h":!0}),i(il)!=="svelte-1scg4wp"&&(il.innerHTML=pe),mt=a(l),ol=p(l,"P",{"data-svelte-h":!0}),i(ol)!=="svelte-o093cv"&&(ol.innerHTML=ie),rt=a(l),jt=p(l,"HR",{}),Jt=a(l),yl=p(l,"P",{"data-svelte-h":!0}),i(yl)!=="svelte-r2adc4"&&(yl.textContent=oe),Tt=a(l),ml=p(l,"P",{"data-svelte-h":!0}),i(ml)!=="svelte-1eae468"&&(ml.textContent=ye),wt=a(l),rl=p(l,"P",{"data-svelte-h":!0}),i(rl)!=="svelte-1vfq4lx"&&(rl.textContent=me),ct=a(l),jl=p(l,"P",{"data-svelte-h":!0}),i(jl)!=="svelte-o18u8f"&&(jl.textContent=re),Ut=a(l),r(Jl.$$.fragment,l),ut=a(l),wl=p(l,"P",{}),It(wl).forEach(e),this.h()},h(){y(c,"name","hf:doc:metadata"),y(c,"content",he),ht(C.src,vt="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit1/smolagents.png")||y(C,"src",vt),y(C,"alt","smolagents"),y(o,"width","560"),y(o,"height","315"),ht(o.src,xt="https://www.youtube.com/embed/PQDKcWiuln4?si=ysSTDZoi8y55FVvA")||y(o,"src",xt),y(o,"title","YouTube video player"),y(o,"frameborder","0"),y(o,"allow","accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share"),y(o,"referrerpolicy","strict-origin-when-cross-origin"),o.allowFullscreen="",ht(x.src,zt="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit1/duplicate-space.gif")||y(x,"src",zt),y(x,"alt","复制")},m(l,t){ue(document.head,c),s(l,Ul,t),s(l,Tl,t),s(l,ul,t),j(U,l,t),s(l,bl,t),s(l,u,t),s(l,dl,t),s(l,b,t),s(l,hl,t),s(l,d,t),s(l,Il,t),s(l,h,t),s(l,Cl,t),j(I,l,t),s(l,Bl,t),s(l,C,t),s(l,fl,t),s(l,B,t),s(l,gl,t),s(l,f,t),s(l,Zl,t),s(l,g,t),s(l,vl,t),s(l,Z,t),s(l,Gl,t),s(l,v,t),s(l,Al,t),s(l,G,t),s(l,Wl,t),s(l,A,t),s(l,_l,t),s(l,o,t),s(l,Hl,t),s(l,W,t),s(l,El,t),j(_,l,t),s(l,Vl,t),s(l,H,t),s(l,xl,t),s(l,E,t),s(l,Rl,t),s(l,V,t),s(l,Ql,t),s(l,x,t),s(l,kl,t),s(l,R,t),s(l,Sl,t),s(l,Q,t),s(l,zl,t),s(l,k,t),s(l,Nl,t),s(l,S,t),s(l,Xl,t),s(l,z,t),s(l,Fl,t),j(N,l,t),s(l,$l,t),s(l,X,t),s(l,Ll,t),j(F,l,t),s(l,Yl,t),s(l,$,t),s(l,ql,t),j(L,l,t),s(l,Pl,t),s(l,Y,t),s(l,Dl,t),s(l,q,t),s(l,Kl,t),s(l,P,t),s(l,Ol,t),s(l,D,t),s(l,lt,t),j(K,l,t),s(l,tt,t),s(l,O,t),s(l,et,t),j(ll,l,t),s(l,st,t),s(l,tl,t),s(l,nt,t),s(l,el,t),s(l,at,t),s(l,sl,t),s(l,Mt,t),s(l,nl,t),s(l,pt,t),s(l,al,t),s(l,it,t),j(Ml,l,t),s(l,ot,t),s(l,pl,t),s(l,yt,t),s(l,il,t),s(l,mt,t),s(l,ol,t),s(l,rt,t),s(l,jt,t),s(l,Jt,t),s(l,yl,t),s(l,Tt,t),s(l,ml,t),s(l,wt,t),s(l,rl,t),s(l,ct,t),s(l,jl,t),s(l,Ut,t),j(Jl,l,t),s(l,ut,t),s(l,wl,t),bt=!0},p:Je,i(l){bt||(J(U.$$.fragment,l),J(I.$$.fragment,l),J(_.$$.fragment,l),J(N.$$.fragment,l),J(F.$$.fragment,l),J(L.$$.fragment,l),J(K.$$.fragment,l),J(ll.$$.fragment,l),J(Ml.$$.fragment,l),J(Jl.$$.fragment,l),bt=!0)},o(l){T(U.$$.fragment,l),T(I.$$.fragment,l),T(_.$$.fragment,l),T(N.$$.fragment,l),T(F.$$.fragment,l),T(L.$$.fragment,l),T(K.$$.fragment,l),T(ll.$$.fragment,l),T(Ml.$$.fragment,l),T(Jl.$$.fragment,l),bt=!1},d(l){l&&(e(Ul),e(Tl),e(ul),e(bl),e(u),e(dl),e(b),e(hl),e(d),e(Il),e(h),e(Cl),e(Bl),e(C),e(fl),e(B),e(gl),e(f),e(Zl),e(g),e(vl),e(Z),e(Gl),e(v),e(Al),e(G),e(Wl),e(A),e(_l),e(o),e(Hl),e(W),e(El),e(Vl),e(H),e(xl),e(E),e(Rl),e(V),e(Ql),e(x),e(kl),e(R),e(Sl),e(Q),e(zl),e(k),e(Nl),e(S),e(Xl),e(z),e(Fl),e($l),e(X),e(Ll),e(Yl),e($),e(ql),e(Pl),e(Y),e(Dl),e(q),e(Kl),e(P),e(Ol),e(D),e(lt),e(tt),e(O),e(et),e(st),e(tl),e(nt),e(el),e(at),e(sl),e(Mt),e(nl),e(pt),e(al),e(it),e(ot),e(pl),e(yt),e(il),e(mt),e(ol),e(rt),e(jt),e(Jt),e(yl),e(Tt),e(ml),e(wt),e(rl),e(ct),e(jl),e(Ut),e(ut),e(wl)),e(c),w(U,l),w(I,l),w(_,l),w(N,l),w(F,l),w(L,l),w(K,l),w(ll,l),w(Ml,l),w(Jl,l)}}}const he='{"title":"使用 smolagents 创建我们的第一个智能体","local":"使用-smolagents-创建我们的第一个智能体","sections":[{"title":"什么是 smolagents？","local":"什么是-smolagents","sections":[],"depth":2},{"title":"让我们来构建我们的智能体！","local":"让我们来构建我们的智能体","sections":[{"title":"Tool（工具）","local":"tool工具","sections":[],"depth":3},{"title":"The Agent（智能体）","local":"the-agent智能体","sections":[],"depth":3}],"depth":2}],"depth":1}';function Ie(Ct){return Te(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ve extends we{constructor(c){super(),ce(this,c,Ie,de,je,{})}}export{ve as component};
