import{s as Vs,o as Hs,n as zs}from"../chunks/scheduler.37c15a92.js";import{S as qs,i as Ls,g as M,s as a,r as y,A as Ps,h as i,f as t,c as n,j as Xs,u as o,x as p,k as Ts,y as Ds,a as e,v as w,d as j,t as U,w as T,m as _s,n as Qs}from"../chunks/index.2bf4358c.js";import{T as Ks}from"../chunks/Tip.363c041f.js";import{C as h}from"../chunks/CodeBlock.4e987730.js";import{H as r}from"../chunks/Heading.8ada512a.js";import{E as Os}from"../chunks/getInferenceSnippets.acd17970.js";function lt(rl){let m,c,u="this notebook",d;return{c(){m=_s("You can follow the code in "),c=M("a"),c.textContent=u,d=_s(" that you can run using Google Colab."),this.h()},l(J){m=Qs(J,"You can follow the code in "),c=i(J,"A",{href:!0,target:!0,"data-svelte-h":!0}),p(c)!=="svelte-12bw6nz"&&(c.textContent=u),d=Qs(J," that you can run using Google Colab."),this.h()},h(){Ts(c,"href","https://huggingface.co/agents-course/notebooks/blob/main/unit2/langgraph/agent.ipynb"),Ts(c,"target","_blank")},m(J,I){e(J,m,I),e(J,c,I),e(J,d,I)},p:zs,d(J){J&&(t(m),t(c),t(d))}}}function st(rl){let m,c,u,d,J,I,b,Js="Alfred at your service. As Mr. Wayne’s trusted butler, I’ve taken the liberty of documenting how I assist Mr Wayne with his various documentary needs. While he’s out attending to his… nighttime activities, I ensure all his paperwork, training schedules, and nutritional plans are properly analyzed and organized.",hl,g,ms="Before leaving, he left a note with his week’s training program. I then took the responsibility to come up with a <strong>menu</strong> for tomorrow’s meals.",dl,A,cs="For future such events, let’s create a document analysis system using LangGraph to serve Mr. Wayne’s needs. This system can:",ul,f,rs="<li>Process images document</li> <li>Extract text using vision models (Vision Language Model)</li> <li>Perform calculations when needed (to demonstrate normal tools)</li> <li>Analyze content and provide concise summaries</li> <li>Execute specific instructions related to documents</li>",Il,G,Cl,B,hs="The workflow we’ll build follows this structured schema:",bl,Z,ds='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit2/LangGraph/alfred_flow.png" alt="Butler&#39;s Document Analysis Workflow"/>',gl,C,Al,W,fl,$,Gl,k,us="and imports :",Bl,v,Zl,E,Wl,x,Is=`This state is a little more complex than the previous ones we have seen.
<code>AnyMessage</code> is a class from Langchain that defines messages, and <code>add_messages</code> is an operator that adds the latest message rather than overwriting it with the latest state.`,$l,S,Cs="This is a new concept in LangGraph, where you can add operators in your state to define the way they should interact together.",kl,R,vl,N,El,Y,xl,F,Sl,X,Rl,_,Nl,Q,bs="Allow me to explain the approach in this agent. The agent follows what’s known as the ReAct pattern (Reason-Act-Observe)",Yl,V,gs="<li><strong>Reason</strong> about his documents and requests</li> <li><strong>Act</strong> by using appropriate tools</li> <li><strong>Observe</strong> the results</li> <li><strong>Repeat</strong> as necessary until I’ve fully addressed his needs</li>",Fl,H,As="This is a simple implementation of an agent using LangGraph.",Xl,z,_l,q,fs=`We define a <code>tools</code> node with our list of tools. The <code>assistant</code> node is just our model with bound tools.
We create a graph with <code>assistant</code> and <code>tools</code> nodes.`,Ql,L,Gs="We add a <code>tools_condition</code> edge, which routes to <code>End</code> or to <code>tools</code> based on whether the <code>assistant</code> calls a tool.",Vl,P,Bs="Now, we add one new step:",Hl,D,Zs="We connect the <code>tools</code> node back to the <code>assistant</code>, forming a loop.",zl,K,Ws="<li>After the <code>assistant</code> node executes, <code>tools_condition</code> checks if the model’s output is a tool call.</li> <li>If it is a tool call, the flow is directed to the <code>tools</code> node.</li> <li>The <code>tools</code> node connects back to <code>assistant</code>.</li> <li>This loop continues as long as the model decides to call tools.</li> <li>If the model response is not a tool call, the flow is directed to END, terminating the process.</li>",ql,O,$s='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit2/LangGraph/Agent.png" alt="ReAct Pattern"/>',Ll,ll,Pl,sl,Dl,tl,ks="Here is an example to show a simple use case of an agent using a tool in LangGraph.",Kl,el,Ol,al,vs="The conversation would proceed:",ls,nl,ss,Ml,ts,il,Es="When Master Wayne leaves his training and meal notes:",es,pl,as,yl,xs="The interaction would proceed:",ns,ol,Ms,wl,is,jl,Ss="Should you wish to create your own document analysis butler, here are key considerations:",ps,Ul,Rs="<li><strong>Define clear tools</strong> for specific document-related tasks</li> <li><strong>Create a robust state tracker</strong> to maintain context between tool calls</li> <li><strong>Consider error handling</strong> for tool failures</li> <li><strong>Maintain contextual awareness</strong> of previous interactions (ensured by the operator <code>add_messages</code>)</li>",ys,Tl,Ns="With these principles, you too can provide exemplary document analysis service worthy of Wayne Manor.",os,Jl,Ys="<em>I trust this explanation has been satisfactory. Now, if you’ll excuse me, Master Wayne’s cape requires pressing before tonight’s activities.</em>",ws,ml,js,cl,Us;return J=new r({props:{title:"Document Analysis Graph",local:"document-analysis-graph",headingTag:"h1"}}),G=new r({props:{title:"The Butler’s Workflow",local:"the-butlers-workflow",headingTag:"h2"}}),C=new Ks({props:{$$slots:{default:[lt]},$$scope:{ctx:rl}}}),W=new r({props:{title:"Setting Up the environment",local:"setting-up-the-environment",headingTag:"h2"}}),$=new h({props:{code:"JTI1cGlwJTIwaW5zdGFsbCUyMGxhbmdncmFwaCUyMGxhbmdjaGFpbl9vcGVuYWklMjBsYW5nY2hhaW5fY29yZQ==",highlighted:"%pip install langgraph langchain_openai langchain_core",wrap:!1}}),v=new h({props:{code:"aW1wb3J0JTIwYmFzZTY0JTBBZnJvbSUyMHR5cGluZyUyMGltcG9ydCUyMExpc3QlMkMlMjBUeXBlZERpY3QlMkMlMjBBbm5vdGF0ZWQlMkMlMjBPcHRpb25hbCUwQWZyb20lMjBsYW5nY2hhaW5fb3BlbmFpJTIwaW1wb3J0JTIwQ2hhdE9wZW5BSSUwQWZyb20lMjBsYW5nY2hhaW5fY29yZS5tZXNzYWdlcyUyMGltcG9ydCUyMEFueU1lc3NhZ2UlMkMlMjBTeXN0ZW1NZXNzYWdlJTJDJTIwSHVtYW5NZXNzYWdlJTBBZnJvbSUyMGxhbmdncmFwaC5ncmFwaC5tZXNzYWdlJTIwaW1wb3J0JTIwYWRkX21lc3NhZ2VzJTBBZnJvbSUyMGxhbmdncmFwaC5ncmFwaCUyMGltcG9ydCUyMFNUQVJUJTJDJTIwU3RhdGVHcmFwaCUwQWZyb20lMjBsYW5nZ3JhcGgucHJlYnVpbHQlMjBpbXBvcnQlMjBUb29sTm9kZSUyQyUyMHRvb2xzX2NvbmRpdGlvbiUwQWZyb20lMjBJUHl0aG9uLmRpc3BsYXklMjBpbXBvcnQlMjBJbWFnZSUyQyUyMGRpc3BsYXk=",highlighted:`<span class="hljs-keyword">import</span> base64
<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">List</span>, TypedDict, Annotated, <span class="hljs-type">Optional</span>
<span class="hljs-keyword">from</span> langchain_openai <span class="hljs-keyword">import</span> ChatOpenAI
<span class="hljs-keyword">from</span> langchain_core.messages <span class="hljs-keyword">import</span> AnyMessage, SystemMessage, HumanMessage
<span class="hljs-keyword">from</span> langgraph.graph.message <span class="hljs-keyword">import</span> add_messages
<span class="hljs-keyword">from</span> langgraph.graph <span class="hljs-keyword">import</span> START, StateGraph
<span class="hljs-keyword">from</span> langgraph.prebuilt <span class="hljs-keyword">import</span> ToolNode, tools_condition
<span class="hljs-keyword">from</span> IPython.display <span class="hljs-keyword">import</span> Image, display`,wrap:!1}}),E=new r({props:{title:"Defining Agent’s State",local:"defining-agents-state",headingTag:"h2"}}),R=new h({props:{code:"Y2xhc3MlMjBBZ2VudFN0YXRlKFR5cGVkRGljdCklM0ElMEElMjAlMjAlMjAlMjAlMjMlMjBUaGUlMjBkb2N1bWVudCUyMHByb3ZpZGVkJTBBJTIwJTIwJTIwJTIwaW5wdXRfZmlsZSUzQSUyME9wdGlvbmFsJTVCc3RyJTVEJTIwJTIwJTIzJTIwQ29udGFpbnMlMjBmaWxlJTIwcGF0aCUyMChQREYlMkZQTkcpJTBBJTIwJTIwJTIwJTIwbWVzc2FnZXMlM0ElMjBBbm5vdGF0ZWQlNUJsaXN0JTVCQW55TWVzc2FnZSU1RCUyQyUyMGFkZF9tZXNzYWdlcyU1RA==",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">AgentState</span>(<span class="hljs-title class_ inherited__">TypedDict</span>):
    <span class="hljs-comment"># The document provided</span>
    input_file: <span class="hljs-type">Optional</span>[<span class="hljs-built_in">str</span>]  <span class="hljs-comment"># Contains file path (PDF/PNG)</span>
    messages: Annotated[<span class="hljs-built_in">list</span>[AnyMessage], add_messages]`,wrap:!1}}),N=new r({props:{title:"Preparing Tools",local:"preparing-tools",headingTag:"h2"}}),Y=new h({props:{code:"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",highlighted:`vision_llm = ChatOpenAI(model=<span class="hljs-string">&quot;gpt-4o&quot;</span>)

<span class="hljs-keyword">def</span> <span class="hljs-title function_">extract_text</span>(<span class="hljs-params">img_path: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-string">&quot;&quot;&quot;
    Extract text from an image file using a multimodal model.
    
    Master Wayne often leaves notes with his training regimen or meal plans.
    This allows me to properly analyze the contents.
    &quot;&quot;&quot;</span>
    all_text = <span class="hljs-string">&quot;&quot;</span>
    <span class="hljs-keyword">try</span>:
        <span class="hljs-comment"># Read image and encode as base64</span>
        <span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(img_path, <span class="hljs-string">&quot;rb&quot;</span>) <span class="hljs-keyword">as</span> image_file:
            image_bytes = image_file.read()

        image_base64 = base64.b64encode(image_bytes).decode(<span class="hljs-string">&quot;utf-8&quot;</span>)

        <span class="hljs-comment"># Prepare the prompt including the base64 image data</span>
        message = [
            HumanMessage(
                content=[
                    {
                        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>,
                        <span class="hljs-string">&quot;text&quot;</span>: (
                            <span class="hljs-string">&quot;Extract all the text from this image. &quot;</span>
                            <span class="hljs-string">&quot;Return only the extracted text, no explanations.&quot;</span>
                        ),
                    },
                    {
                        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;image_url&quot;</span>,
                        <span class="hljs-string">&quot;image_url&quot;</span>: {
                            <span class="hljs-string">&quot;url&quot;</span>: <span class="hljs-string">f&quot;data:image/png;base64,<span class="hljs-subst">{image_base64}</span>&quot;</span>
                        },
                    },
                ]
            )
        ]

        <span class="hljs-comment"># Call the vision-capable model</span>
        response = vision_llm.invoke(message)

        <span class="hljs-comment"># Append extracted text</span>
        all_text += response.content + <span class="hljs-string">&quot;\\n\\n&quot;</span>

        <span class="hljs-keyword">return</span> all_text.strip()
    <span class="hljs-keyword">except</span> Exception <span class="hljs-keyword">as</span> e:
        <span class="hljs-comment"># A butler should handle errors gracefully</span>
        error_msg = <span class="hljs-string">f&quot;Error extracting text: <span class="hljs-subst">{<span class="hljs-built_in">str</span>(e)}</span>&quot;</span>
        <span class="hljs-built_in">print</span>(error_msg)
        <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;&quot;</span>

<span class="hljs-keyword">def</span> <span class="hljs-title function_">divide</span>(<span class="hljs-params">a: <span class="hljs-built_in">int</span>, b: <span class="hljs-built_in">int</span></span>) -&gt; <span class="hljs-built_in">float</span>:
    <span class="hljs-string">&quot;&quot;&quot;Divide a and b - for Master Wayne&#x27;s occasional calculations.&quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> a / b

<span class="hljs-comment"># Equip the butler with tools</span>
tools = [
    divide,
    extract_text
]

llm = ChatOpenAI(model=<span class="hljs-string">&quot;gpt-4o&quot;</span>)
llm_with_tools = llm.bind_tools(tools, parallel_tool_calls=<span class="hljs-literal">False</span>)`,wrap:!1}}),F=new r({props:{title:"The nodes",local:"the-nodes",headingTag:"h2"}}),X=new h({props:{code:"ZGVmJTIwYXNzaXN0YW50KHN0YXRlJTNBJTIwQWdlbnRTdGF0ZSklM0ElMEElMjAlMjAlMjAlMjAlMjMlMjBTeXN0ZW0lMjBtZXNzYWdlJTBBJTIwJTIwJTIwJTIwdGV4dHVhbF9kZXNjcmlwdGlvbl9vZl90b29sJTNEJTIyJTIyJTIyJTBBZXh0cmFjdF90ZXh0KGltZ19wYXRoJTNBJTIwc3RyKSUyMC0lM0UlMjBzdHIlM0ElMEElMjAlMjAlMjAlMjBFeHRyYWN0JTIwdGV4dCUyMGZyb20lMjBhbiUyMGltYWdlJTIwZmlsZSUyMHVzaW5nJTIwYSUyMG11bHRpbW9kYWwlMjBtb2RlbC4lMEElMEElMjAlMjAlMjAlMjBBcmdzJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaW1nX3BhdGglM0ElMjBBJTIwbG9jYWwlMjBpbWFnZSUyMGZpbGUlMjBwYXRoJTIwKHN0cmluZ3MpLiUwQSUwQSUyMCUyMCUyMCUyMFJldHVybnMlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBBJTIwc2luZ2xlJTIwc3RyaW5nJTIwY29udGFpbmluZyUyMHRoZSUyMGNvbmNhdGVuYXRlZCUyMHRleHQlMjBleHRyYWN0ZWQlMjBmcm9tJTIwZWFjaCUyMGltYWdlLiUwQWRpdmlkZShhJTNBJTIwaW50JTJDJTIwYiUzQSUyMGludCklMjAtJTNFJTIwZmxvYXQlM0ElMEElMjAlMjAlMjAlMjBEaXZpZGUlMjBhJTIwYW5kJTIwYiUwQSUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMGltYWdlJTNEc3RhdGUlNUIlMjJpbnB1dF9maWxlJTIyJTVEJTBBJTIwJTIwJTIwJTIwc3lzX21zZyUyMCUzRCUyMFN5c3RlbU1lc3NhZ2UoY29udGVudCUzRGYlMjJZb3UlMjBhcmUlMjBhJTIwaGVscGZ1bCUyMGJ1dGxlciUyMG5hbWVkJTIwQWxmcmVkJTIwdGhhdCUyMHNlcnZlcyUyME1yLiUyMFdheW5lJTIwYW5kJTIwQmF0bWFuLiUyMFlvdSUyMGNhbiUyMGFuYWx5c2UlMjBkb2N1bWVudHMlMjBhbmQlMjBydW4lMjBjb21wdXRhdGlvbnMlMjB3aXRoJTIwcHJvdmlkZWQlMjB0b29scyUzQSU1Q24lN0J0ZXh0dWFsX2Rlc2NyaXB0aW9uX29mX3Rvb2wlN0QlMjAlNUNuJTIwWW91JTIwaGF2ZSUyMGFjY2VzcyUyMHRvJTIwc29tZSUyMG9wdGlvbmFsJTIwaW1hZ2VzLiUyMEN1cnJlbnRseSUyMHRoZSUyMGxvYWRlZCUyMGltYWdlJTIwaXMlM0ElMjAlN0JpbWFnZSU3RCUyMiklMEElMEElMjAlMjAlMjAlMjByZXR1cm4lMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJtZXNzYWdlcyUyMiUzQSUyMCU1QmxsbV93aXRoX3Rvb2xzLmludm9rZSglNUJzeXNfbXNnJTVEJTIwJTJCJTIwc3RhdGUlNUIlMjJtZXNzYWdlcyUyMiU1RCklNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJpbnB1dF9maWxlJTIyJTNBJTIwc3RhdGUlNUIlMjJpbnB1dF9maWxlJTIyJTVEJTBBJTIwJTIwJTIwJTIwJTdE",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">assistant</span>(<span class="hljs-params">state: AgentState</span>):
    <span class="hljs-comment"># System message</span>
    textual_description_of_tool=<span class="hljs-string">&quot;&quot;&quot;
extract_text(img_path: str) -&gt; str:
    Extract text from an image file using a multimodal model.

    Args:
        img_path: A local image file path (strings).

    Returns:
        A single string containing the concatenated text extracted from each image.
divide(a: int, b: int) -&gt; float:
    Divide a and b
&quot;&quot;&quot;</span>
    image=state[<span class="hljs-string">&quot;input_file&quot;</span>]
    sys_msg = SystemMessage(content=<span class="hljs-string">f&quot;You are a helpful butler named Alfred that serves Mr. Wayne and Batman. You can analyse documents and run computations with provided tools:\\n<span class="hljs-subst">{textual_description_of_tool}</span> \\n You have access to some optional images. Currently the loaded image is: <span class="hljs-subst">{image}</span>&quot;</span>)

    <span class="hljs-keyword">return</span> {
        <span class="hljs-string">&quot;messages&quot;</span>: [llm_with_tools.invoke([sys_msg] + state[<span class="hljs-string">&quot;messages&quot;</span>])],
        <span class="hljs-string">&quot;input_file&quot;</span>: state[<span class="hljs-string">&quot;input_file&quot;</span>]
    }`,wrap:!1}}),_=new r({props:{title:"The ReAct Pattern: How I Assist Mr. Wayne",local:"the-react-pattern-how-i-assist-mr-wayne",headingTag:"h2"}}),z=new h({props:{code:"JTIzJTIwVGhlJTIwZ3JhcGglMEFidWlsZGVyJTIwJTNEJTIwU3RhdGVHcmFwaChBZ2VudFN0YXRlKSUwQSUwQSUyMyUyMERlZmluZSUyMG5vZGVzJTNBJTIwdGhlc2UlMjBkbyUyMHRoZSUyMHdvcmslMEFidWlsZGVyLmFkZF9ub2RlKCUyMmFzc2lzdGFudCUyMiUyQyUyMGFzc2lzdGFudCklMEFidWlsZGVyLmFkZF9ub2RlKCUyMnRvb2xzJTIyJTJDJTIwVG9vbE5vZGUodG9vbHMpKSUwQSUwQSUyMyUyMERlZmluZSUyMGVkZ2VzJTNBJTIwdGhlc2UlMjBkZXRlcm1pbmUlMjBob3clMjB0aGUlMjBjb250cm9sJTIwZmxvdyUyMG1vdmVzJTBBYnVpbGRlci5hZGRfZWRnZShTVEFSVCUyQyUyMCUyMmFzc2lzdGFudCUyMiklMEFidWlsZGVyLmFkZF9jb25kaXRpb25hbF9lZGdlcyglMEElMjAlMjAlMjAlMjAlMjJhc3Npc3RhbnQlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjMlMjBJZiUyMHRoZSUyMGxhdGVzdCUyMG1lc3NhZ2UlMjByZXF1aXJlcyUyMGElMjB0b29sJTJDJTIwcm91dGUlMjB0byUyMHRvb2xzJTBBJTIwJTIwJTIwJTIwJTIzJTIwT3RoZXJ3aXNlJTJDJTIwcHJvdmlkZSUyMGElMjBkaXJlY3QlMjByZXNwb25zZSUwQSUyMCUyMCUyMCUyMHRvb2xzX2NvbmRpdGlvbiUyQyUwQSklMEFidWlsZGVyLmFkZF9lZGdlKCUyMnRvb2xzJTIyJTJDJTIwJTIyYXNzaXN0YW50JTIyKSUwQXJlYWN0X2dyYXBoJTIwJTNEJTIwYnVpbGRlci5jb21waWxlKCklMEElMEElMjMlMjBTaG93JTIwdGhlJTIwYnV0bGVyJ3MlMjB0aG91Z2h0JTIwcHJvY2VzcyUwQWRpc3BsYXkoSW1hZ2UocmVhY3RfZ3JhcGguZ2V0X2dyYXBoKHhyYXklM0RUcnVlKS5kcmF3X21lcm1haWRfcG5nKCkpKQ==",highlighted:`<span class="hljs-comment"># The graph</span>
builder = StateGraph(AgentState)

<span class="hljs-comment"># Define nodes: these do the work</span>
builder.add_node(<span class="hljs-string">&quot;assistant&quot;</span>, assistant)
builder.add_node(<span class="hljs-string">&quot;tools&quot;</span>, ToolNode(tools))

<span class="hljs-comment"># Define edges: these determine how the control flow moves</span>
builder.add_edge(START, <span class="hljs-string">&quot;assistant&quot;</span>)
builder.add_conditional_edges(
    <span class="hljs-string">&quot;assistant&quot;</span>,
    <span class="hljs-comment"># If the latest message requires a tool, route to tools</span>
    <span class="hljs-comment"># Otherwise, provide a direct response</span>
    tools_condition,
)
builder.add_edge(<span class="hljs-string">&quot;tools&quot;</span>, <span class="hljs-string">&quot;assistant&quot;</span>)
react_graph = builder.<span class="hljs-built_in">compile</span>()

<span class="hljs-comment"># Show the butler&#x27;s thought process</span>
display(Image(react_graph.get_graph(xray=<span class="hljs-literal">True</span>).draw_mermaid_png()))`,wrap:!1}}),ll=new r({props:{title:"The Butler in Action",local:"the-butler-in-action",headingTag:"h2"}}),sl=new r({props:{title:"Example 1: Simple Calculations",local:"example-1-simple-calculations",headingTag:"h3"}}),el=new h({props:{code:"bWVzc2FnZXMlMjAlM0QlMjAlNUJIdW1hbk1lc3NhZ2UoY29udGVudCUzRCUyMkRpdmlkZSUyMDY3OTAlMjBieSUyMDUlMjIpJTVEJTBBbWVzc2FnZXMlMjAlM0QlMjByZWFjdF9ncmFwaC5pbnZva2UoJTdCJTIybWVzc2FnZXMlMjIlM0ElMjBtZXNzYWdlcyUyQyUyMCUyMmlucHV0X2ZpbGUlMjIlM0ElMjBOb25lJTdEKSUwQSUwQSUyMyUyMFNob3clMjB0aGUlMjBtZXNzYWdlcyUwQWZvciUyMG0lMjBpbiUyMG1lc3NhZ2VzJTVCJ21lc3NhZ2VzJyU1RCUzQSUwQSUyMCUyMCUyMCUyMG0ucHJldHR5X3ByaW50KCk=",highlighted:`messages = [HumanMessage(content=<span class="hljs-string">&quot;Divide 6790 by 5&quot;</span>)]
messages = react_graph.invoke({<span class="hljs-string">&quot;messages&quot;</span>: messages, <span class="hljs-string">&quot;input_file&quot;</span>: <span class="hljs-literal">None</span>})

<span class="hljs-comment"># Show the messages</span>
<span class="hljs-keyword">for</span> m <span class="hljs-keyword">in</span> messages[<span class="hljs-string">&#x27;messages&#x27;</span>]:
    m.pretty_print()`,wrap:!1}}),nl=new h({props:{code:"SHVtYW4lM0ElMjBEaXZpZGUlMjA2NzkwJTIwYnklMjA1JTBBJTBBQUklMjBUb29sJTIwQ2FsbCUzQSUyMGRpdmlkZShhJTNENjc5MCUyQyUyMGIlM0Q1KSUwQSUwQVRvb2wlMjBSZXNwb25zZSUzQSUyMDEzNTguMCUwQSUwQUFsZnJlZCUzQSUyMFRoZSUyMHJlc3VsdCUyMG9mJTIwZGl2aWRpbmclMjA2NzkwJTIwYnklMjA1JTIwaXMlMjAxMzU4LjAu",highlighted:`<span class="hljs-attribute">Human</span>: Divide <span class="hljs-number">6790</span> by <span class="hljs-number">5</span>

<span class="hljs-attribute">AI</span> Tool Call: divide(a=<span class="hljs-number">6790</span>, b=<span class="hljs-number">5</span>)

<span class="hljs-attribute">Tool</span> Response: <span class="hljs-number">1358</span>.<span class="hljs-number">0</span>

<span class="hljs-attribute">Alfred</span>: The result of dividing <span class="hljs-number">6790</span> by <span class="hljs-number">5</span> is <span class="hljs-number">1358</span>.<span class="hljs-number">0</span>.`,wrap:!1}}),Ml=new r({props:{title:"Example 2: Analyzing Master Wayne’s Training Documents",local:"example-2-analyzing-master-waynes-training-documents",headingTag:"h3"}}),pl=new h({props:{code:"bWVzc2FnZXMlMjAlM0QlMjAlNUJIdW1hbk1lc3NhZ2UoY29udGVudCUzRCUyMkFjY29yZGluZyUyMHRvJTIwdGhlJTIwbm90ZSUyMHByb3ZpZGVkJTIwYnklMjBNci4lMjBXYXluZSUyMGluJTIwdGhlJTIwcHJvdmlkZWQlMjBpbWFnZXMuJTIwV2hhdCdzJTIwdGhlJTIwbGlzdCUyMG9mJTIwaXRlbXMlMjBJJTIwc2hvdWxkJTIwYnV5JTIwZm9yJTIwdGhlJTIwZGlubmVyJTIwbWVudSUzRiUyMiklNUQlMEFtZXNzYWdlcyUyMCUzRCUyMHJlYWN0X2dyYXBoLmludm9rZSglN0IlMjJtZXNzYWdlcyUyMiUzQSUyMG1lc3NhZ2VzJTJDJTIwJTIyaW5wdXRfZmlsZSUyMiUzQSUyMCUyMkJhdG1hbl90cmFpbmluZ19hbmRfbWVhbHMucG5nJTIyJTdEKQ==",highlighted:`messages = [HumanMessage(content=<span class="hljs-string">&quot;According to the note provided by Mr. Wayne in the provided images. What&#x27;s the list of items I should buy for the dinner menu?&quot;</span>)]
messages = react_graph.invoke({<span class="hljs-string">&quot;messages&quot;</span>: messages, <span class="hljs-string">&quot;input_file&quot;</span>: <span class="hljs-string">&quot;Batman_training_and_meals.png&quot;</span>})`,wrap:!1}}),ol=new h({props:{code:"SHVtYW4lM0ElMjBBY2NvcmRpbmclMjB0byUyMHRoZSUyMG5vdGUlMjBwcm92aWRlZCUyMGJ5JTIwTXIuJTIwV2F5bmUlMjBpbiUyMHRoZSUyMHByb3ZpZGVkJTIwaW1hZ2VzLiUyMFdoYXQncyUyMHRoZSUyMGxpc3QlMjBvZiUyMGl0ZW1zJTIwSSUyMHNob3VsZCUyMGJ1eSUyMGZvciUyMHRoZSUyMGRpbm5lciUyMG1lbnUlM0YlMEElMEFBSSUyMFRvb2wlMjBDYWxsJTNBJTIwZXh0cmFjdF90ZXh0KGltZ19wYXRoJTNEJTIyQmF0bWFuX3RyYWluaW5nX2FuZF9tZWFscy5wbmclMjIpJTBBJTBBVG9vbCUyMFJlc3BvbnNlJTNBJTIwJTVCRXh0cmFjdGVkJTIwdGV4dCUyMHdpdGglMjB0cmFpbmluZyUyMHNjaGVkdWxlJTIwYW5kJTIwbWVudSUyMGRldGFpbHMlNUQlMEElMEFBbGZyZWQlM0ElMjBGb3IlMjB0aGUlMjBkaW5uZXIlMjBtZW51JTJDJTIweW91JTIwc2hvdWxkJTIwYnV5JTIwdGhlJTIwZm9sbG93aW5nJTIwaXRlbXMlM0ElMEElMEExLiUyMEdyYXNzLWZlZCUyMGxvY2FsJTIwc2lybG9pbiUyMHN0ZWFrJTBBMi4lMjBPcmdhbmljJTIwc3BpbmFjaCUwQTMuJTIwUGlxdWlsbG8lMjBwZXBwZXJzJTBBNC4lMjBQb3RhdG9lcyUyMChmb3IlMjBvdmVuLWJha2VkJTIwZ29sZGVuJTIwaGVyYiUyMHBvdGF0byklMEE1LiUyMEZpc2glMjBvaWwlMjAoMiUyMGdyYW1zKSUwQSUwQUVuc3VyZSUyMHRoZSUyMHN0ZWFrJTIwaXMlMjBncmFzcy1mZWQlMjBhbmQlMjB0aGUlMjBzcGluYWNoJTIwYW5kJTIwcGVwcGVycyUyMGFyZSUyMG9yZ2FuaWMlMjBmb3IlMjB0aGUlMjBiZXN0JTIwcXVhbGl0eSUyMG1lYWwu",highlighted:`<span class="hljs-symbol">Human:</span> According <span class="hljs-keyword">to</span> the note provided <span class="hljs-keyword">by</span> Mr. Wayne <span class="hljs-keyword">in</span> the provided images. What<span class="hljs-comment">&#x27;s the list of items I should buy for the dinner menu?</span>

AI Tool <span class="hljs-keyword">Call</span>: extract_text(img_path=<span class="hljs-string">&quot;Batman_training_and_meals.png&quot;</span>)

Tool Response: [Extracted <span class="hljs-keyword">text</span> <span class="hljs-keyword">with</span> training schedule <span class="hljs-built_in">and</span> menu details]

<span class="hljs-symbol">Alfred:</span> <span class="hljs-keyword">For</span> the dinner menu, you should buy the following items:

<span class="hljs-number">1</span>. Grass-fed local sirloin steak
<span class="hljs-number">2</span>. Organic spinach
<span class="hljs-number">3</span>. Piquillo peppers
<span class="hljs-number">4</span>. Potatoes (<span class="hljs-keyword">for</span> oven-baked golden herb potato)
<span class="hljs-number">5</span>. Fish oil (<span class="hljs-number">2</span> grams)

Ensure the steak <span class="hljs-built_in">is</span> grass-fed <span class="hljs-built_in">and</span> the spinach <span class="hljs-built_in">and</span> peppers are organic <span class="hljs-keyword">for</span> the best quality meal.`,wrap:!1}}),wl=new r({props:{title:"Key Takeaways",local:"key-takeaways",headingTag:"h2"}}),ml=new Os({props:{source:"https://github.com/huggingface/agents-course/blob/main/units/en/unit2/langgraph/document_analysis_agent.mdx"}}),{c(){m=M("meta"),c=a(),u=M("p"),d=a(),y(J.$$.fragment),I=a(),b=M("p"),b.textContent=Js,hl=a(),g=M("p"),g.innerHTML=ms,dl=a(),A=M("p"),A.textContent=cs,ul=a(),f=M("ol"),f.innerHTML=rs,Il=a(),y(G.$$.fragment),Cl=a(),B=M("p"),B.textContent=hs,bl=a(),Z=M("p"),Z.innerHTML=ds,gl=a(),y(C.$$.fragment),Al=a(),y(W.$$.fragment),fl=a(),y($.$$.fragment),Gl=a(),k=M("p"),k.textContent=us,Bl=a(),y(v.$$.fragment),Zl=a(),y(E.$$.fragment),Wl=a(),x=M("p"),x.innerHTML=Is,$l=a(),S=M("p"),S.textContent=Cs,kl=a(),y(R.$$.fragment),vl=a(),y(N.$$.fragment),El=a(),y(Y.$$.fragment),xl=a(),y(F.$$.fragment),Sl=a(),y(X.$$.fragment),Rl=a(),y(_.$$.fragment),Nl=a(),Q=M("p"),Q.textContent=bs,Yl=a(),V=M("ol"),V.innerHTML=gs,Fl=a(),H=M("p"),H.textContent=As,Xl=a(),y(z.$$.fragment),_l=a(),q=M("p"),q.innerHTML=fs,Ql=a(),L=M("p"),L.innerHTML=Gs,Vl=a(),P=M("p"),P.textContent=Bs,Hl=a(),D=M("p"),D.innerHTML=Zs,zl=a(),K=M("ul"),K.innerHTML=Ws,ql=a(),O=M("p"),O.innerHTML=$s,Ll=a(),y(ll.$$.fragment),Pl=a(),y(sl.$$.fragment),Dl=a(),tl=M("p"),tl.textContent=ks,Kl=a(),y(el.$$.fragment),Ol=a(),al=M("p"),al.textContent=vs,ls=a(),y(nl.$$.fragment),ss=a(),y(Ml.$$.fragment),ts=a(),il=M("p"),il.textContent=Es,es=a(),y(pl.$$.fragment),as=a(),yl=M("p"),yl.textContent=xs,ns=a(),y(ol.$$.fragment),Ms=a(),y(wl.$$.fragment),is=a(),jl=M("p"),jl.textContent=Ss,ps=a(),Ul=M("ol"),Ul.innerHTML=Rs,ys=a(),Tl=M("p"),Tl.textContent=Ns,os=a(),Jl=M("p"),Jl.innerHTML=Ys,ws=a(),y(ml.$$.fragment),js=a(),cl=M("p"),this.h()},l(l){const s=Ps("svelte-u9bgzb",document.head);m=i(s,"META",{name:!0,content:!0}),s.forEach(t),c=n(l),u=i(l,"P",{}),Xs(u).forEach(t),d=n(l),o(J.$$.fragment,l),I=n(l),b=i(l,"P",{"data-svelte-h":!0}),p(b)!=="svelte-11xka8s"&&(b.textContent=Js),hl=n(l),g=i(l,"P",{"data-svelte-h":!0}),p(g)!=="svelte-130n2j9"&&(g.innerHTML=ms),dl=n(l),A=i(l,"P",{"data-svelte-h":!0}),p(A)!=="svelte-fz9q9p"&&(A.textContent=cs),ul=n(l),f=i(l,"OL",{"data-svelte-h":!0}),p(f)!=="svelte-gyca7w"&&(f.innerHTML=rs),Il=n(l),o(G.$$.fragment,l),Cl=n(l),B=i(l,"P",{"data-svelte-h":!0}),p(B)!=="svelte-zxoaj3"&&(B.textContent=hs),bl=n(l),Z=i(l,"P",{"data-svelte-h":!0}),p(Z)!=="svelte-g7cpwr"&&(Z.innerHTML=ds),gl=n(l),o(C.$$.fragment,l),Al=n(l),o(W.$$.fragment,l),fl=n(l),o($.$$.fragment,l),Gl=n(l),k=i(l,"P",{"data-svelte-h":!0}),p(k)!=="svelte-1ey17wx"&&(k.textContent=us),Bl=n(l),o(v.$$.fragment,l),Zl=n(l),o(E.$$.fragment,l),Wl=n(l),x=i(l,"P",{"data-svelte-h":!0}),p(x)!=="svelte-h15r15"&&(x.innerHTML=Is),$l=n(l),S=i(l,"P",{"data-svelte-h":!0}),p(S)!=="svelte-s7exkc"&&(S.textContent=Cs),kl=n(l),o(R.$$.fragment,l),vl=n(l),o(N.$$.fragment,l),El=n(l),o(Y.$$.fragment,l),xl=n(l),o(F.$$.fragment,l),Sl=n(l),o(X.$$.fragment,l),Rl=n(l),o(_.$$.fragment,l),Nl=n(l),Q=i(l,"P",{"data-svelte-h":!0}),p(Q)!=="svelte-18vru10"&&(Q.textContent=bs),Yl=n(l),V=i(l,"OL",{"data-svelte-h":!0}),p(V)!=="svelte-1lieze1"&&(V.innerHTML=gs),Fl=n(l),H=i(l,"P",{"data-svelte-h":!0}),p(H)!=="svelte-139l5j8"&&(H.textContent=As),Xl=n(l),o(z.$$.fragment,l),_l=n(l),q=i(l,"P",{"data-svelte-h":!0}),p(q)!=="svelte-1d0auck"&&(q.innerHTML=fs),Ql=n(l),L=i(l,"P",{"data-svelte-h":!0}),p(L)!=="svelte-1svgz16"&&(L.innerHTML=Gs),Vl=n(l),P=i(l,"P",{"data-svelte-h":!0}),p(P)!=="svelte-1f0m6x1"&&(P.textContent=Bs),Hl=n(l),D=i(l,"P",{"data-svelte-h":!0}),p(D)!=="svelte-echfi8"&&(D.innerHTML=Zs),zl=n(l),K=i(l,"UL",{"data-svelte-h":!0}),p(K)!=="svelte-bdsar0"&&(K.innerHTML=Ws),ql=n(l),O=i(l,"P",{"data-svelte-h":!0}),p(O)!=="svelte-1nhlurw"&&(O.innerHTML=$s),Ll=n(l),o(ll.$$.fragment,l),Pl=n(l),o(sl.$$.fragment,l),Dl=n(l),tl=i(l,"P",{"data-svelte-h":!0}),p(tl)!=="svelte-1rxi6tg"&&(tl.textContent=ks),Kl=n(l),o(el.$$.fragment,l),Ol=n(l),al=i(l,"P",{"data-svelte-h":!0}),p(al)!=="svelte-eegy09"&&(al.textContent=vs),ls=n(l),o(nl.$$.fragment,l),ss=n(l),o(Ml.$$.fragment,l),ts=n(l),il=i(l,"P",{"data-svelte-h":!0}),p(il)!=="svelte-k6gec7"&&(il.textContent=Es),es=n(l),o(pl.$$.fragment,l),as=n(l),yl=i(l,"P",{"data-svelte-h":!0}),p(yl)!=="svelte-gpwkjm"&&(yl.textContent=xs),ns=n(l),o(ol.$$.fragment,l),Ms=n(l),o(wl.$$.fragment,l),is=n(l),jl=i(l,"P",{"data-svelte-h":!0}),p(jl)!=="svelte-17u0oai"&&(jl.textContent=Ss),ps=n(l),Ul=i(l,"OL",{"data-svelte-h":!0}),p(Ul)!=="svelte-1caujcm"&&(Ul.innerHTML=Rs),ys=n(l),Tl=i(l,"P",{"data-svelte-h":!0}),p(Tl)!=="svelte-1tc3qgy"&&(Tl.textContent=Ns),os=n(l),Jl=i(l,"P",{"data-svelte-h":!0}),p(Jl)!=="svelte-1ik86s0"&&(Jl.innerHTML=Ys),ws=n(l),o(ml.$$.fragment,l),js=n(l),cl=i(l,"P",{}),Xs(cl).forEach(t),this.h()},h(){Ts(m,"name","hf:doc:metadata"),Ts(m,"content",tt)},m(l,s){Ds(document.head,m),e(l,c,s),e(l,u,s),e(l,d,s),w(J,l,s),e(l,I,s),e(l,b,s),e(l,hl,s),e(l,g,s),e(l,dl,s),e(l,A,s),e(l,ul,s),e(l,f,s),e(l,Il,s),w(G,l,s),e(l,Cl,s),e(l,B,s),e(l,bl,s),e(l,Z,s),e(l,gl,s),w(C,l,s),e(l,Al,s),w(W,l,s),e(l,fl,s),w($,l,s),e(l,Gl,s),e(l,k,s),e(l,Bl,s),w(v,l,s),e(l,Zl,s),w(E,l,s),e(l,Wl,s),e(l,x,s),e(l,$l,s),e(l,S,s),e(l,kl,s),w(R,l,s),e(l,vl,s),w(N,l,s),e(l,El,s),w(Y,l,s),e(l,xl,s),w(F,l,s),e(l,Sl,s),w(X,l,s),e(l,Rl,s),w(_,l,s),e(l,Nl,s),e(l,Q,s),e(l,Yl,s),e(l,V,s),e(l,Fl,s),e(l,H,s),e(l,Xl,s),w(z,l,s),e(l,_l,s),e(l,q,s),e(l,Ql,s),e(l,L,s),e(l,Vl,s),e(l,P,s),e(l,Hl,s),e(l,D,s),e(l,zl,s),e(l,K,s),e(l,ql,s),e(l,O,s),e(l,Ll,s),w(ll,l,s),e(l,Pl,s),w(sl,l,s),e(l,Dl,s),e(l,tl,s),e(l,Kl,s),w(el,l,s),e(l,Ol,s),e(l,al,s),e(l,ls,s),w(nl,l,s),e(l,ss,s),w(Ml,l,s),e(l,ts,s),e(l,il,s),e(l,es,s),w(pl,l,s),e(l,as,s),e(l,yl,s),e(l,ns,s),w(ol,l,s),e(l,Ms,s),w(wl,l,s),e(l,is,s),e(l,jl,s),e(l,ps,s),e(l,Ul,s),e(l,ys,s),e(l,Tl,s),e(l,os,s),e(l,Jl,s),e(l,ws,s),w(ml,l,s),e(l,js,s),e(l,cl,s),Us=!0},p(l,[s]){const Fs={};s&2&&(Fs.$$scope={dirty:s,ctx:l}),C.$set(Fs)},i(l){Us||(j(J.$$.fragment,l),j(G.$$.fragment,l),j(C.$$.fragment,l),j(W.$$.fragment,l),j($.$$.fragment,l),j(v.$$.fragment,l),j(E.$$.fragment,l),j(R.$$.fragment,l),j(N.$$.fragment,l),j(Y.$$.fragment,l),j(F.$$.fragment,l),j(X.$$.fragment,l),j(_.$$.fragment,l),j(z.$$.fragment,l),j(ll.$$.fragment,l),j(sl.$$.fragment,l),j(el.$$.fragment,l),j(nl.$$.fragment,l),j(Ml.$$.fragment,l),j(pl.$$.fragment,l),j(ol.$$.fragment,l),j(wl.$$.fragment,l),j(ml.$$.fragment,l),Us=!0)},o(l){U(J.$$.fragment,l),U(G.$$.fragment,l),U(C.$$.fragment,l),U(W.$$.fragment,l),U($.$$.fragment,l),U(v.$$.fragment,l),U(E.$$.fragment,l),U(R.$$.fragment,l),U(N.$$.fragment,l),U(Y.$$.fragment,l),U(F.$$.fragment,l),U(X.$$.fragment,l),U(_.$$.fragment,l),U(z.$$.fragment,l),U(ll.$$.fragment,l),U(sl.$$.fragment,l),U(el.$$.fragment,l),U(nl.$$.fragment,l),U(Ml.$$.fragment,l),U(pl.$$.fragment,l),U(ol.$$.fragment,l),U(wl.$$.fragment,l),U(ml.$$.fragment,l),Us=!1},d(l){l&&(t(c),t(u),t(d),t(I),t(b),t(hl),t(g),t(dl),t(A),t(ul),t(f),t(Il),t(Cl),t(B),t(bl),t(Z),t(gl),t(Al),t(fl),t(Gl),t(k),t(Bl),t(Zl),t(Wl),t(x),t($l),t(S),t(kl),t(vl),t(El),t(xl),t(Sl),t(Rl),t(Nl),t(Q),t(Yl),t(V),t(Fl),t(H),t(Xl),t(_l),t(q),t(Ql),t(L),t(Vl),t(P),t(Hl),t(D),t(zl),t(K),t(ql),t(O),t(Ll),t(Pl),t(Dl),t(tl),t(Kl),t(Ol),t(al),t(ls),t(ss),t(ts),t(il),t(es),t(as),t(yl),t(ns),t(Ms),t(is),t(jl),t(ps),t(Ul),t(ys),t(Tl),t(os),t(Jl),t(ws),t(js),t(cl)),t(m),T(J,l),T(G,l),T(C,l),T(W,l),T($,l),T(v,l),T(E,l),T(R,l),T(N,l),T(Y,l),T(F,l),T(X,l),T(_,l),T(z,l),T(ll,l),T(sl,l),T(el,l),T(nl,l),T(Ml,l),T(pl,l),T(ol,l),T(wl,l),T(ml,l)}}}const tt='{"title":"Document Analysis Graph","local":"document-analysis-graph","sections":[{"title":"The Butler’s Workflow","local":"the-butlers-workflow","sections":[],"depth":2},{"title":"Setting Up the environment","local":"setting-up-the-environment","sections":[],"depth":2},{"title":"Defining Agent’s State","local":"defining-agents-state","sections":[],"depth":2},{"title":"Preparing Tools","local":"preparing-tools","sections":[],"depth":2},{"title":"The nodes","local":"the-nodes","sections":[],"depth":2},{"title":"The ReAct Pattern: How I Assist Mr. Wayne","local":"the-react-pattern-how-i-assist-mr-wayne","sections":[],"depth":2},{"title":"The Butler in Action","local":"the-butler-in-action","sections":[{"title":"Example 1: Simple Calculations","local":"example-1-simple-calculations","sections":[],"depth":3},{"title":"Example 2: Analyzing Master Wayne’s Training Documents","local":"example-2-analyzing-master-waynes-training-documents","sections":[],"depth":3}],"depth":2},{"title":"Key Takeaways","local":"key-takeaways","sections":[],"depth":2}],"depth":1}';function et(rl){return Hs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ot extends qs{constructor(m){super(),Ls(this,m,et,st,Vs,{})}}export{ot as component};
