import{s as Al,o as Bl,n as ze}from"../chunks/scheduler.37c15a92.js";import{S as ql,i as Ll,g as M,s,r as p,A as Nl,h as u,f as l,c as a,j as Yl,u as o,x as d,k as Fl,y as Pl,a as n,v as c,d as m,t as f,w as $}from"../chunks/index.2bf4358c.js";import{T as Xe}from"../chunks/Tip.363c041f.js";import{Y as Sl}from"../chunks/Youtube.1e50a667.js";import{C as y}from"../chunks/CodeBlock.4e987730.js";import{C as Dl}from"../chunks/CourseFloatingBanner.9ff4c771.js";import{Q as Ye}from"../chunks/Question.668688bc.js";import{F as Kl}from"../chunks/FrameworkSwitchCourse.8d4d4ab6.js";import{H as h,E as Ol}from"../chunks/getInferenceSnippets.648f38f6.js";function en(J){let r,T='📚 <strong>훈련 리소스</strong>: 훈련을 시작하기 전에 포괄적인 <a href="https://huggingface.co/docs/transformers/main/en/training" rel="nofollow">🤗 Transformers 훈련 가이드</a>를 숙지하고 <a href="https://huggingface.co/learn/cookbook/en/fine_tuning_code_llm_on_single_gpu" rel="nofollow">미세 조정 쿡북</a>의 실용적인 예제를 살펴보세요.';return{c(){r=M("p"),r.innerHTML=T},l(i){r=u(i,"P",{"data-svelte-h":!0}),d(r)!=="svelte-1d8z8sh"&&(r.innerHTML=T)},m(i,g){n(i,r,g)},p:ze,d(i){i&&l(r)}}}function tn(J){let r,T='🚀 <strong>고급 설정</strong>: 사용 가능한 모든 훈련 인수와 최적화 전략에 대한 자세한 정보는 <a href="https://huggingface.co/docs/transformers/main/en/main_classes/trainer#transformers.TrainingArguments" rel="nofollow">TrainingArguments 문서</a>와 <a href="https://huggingface.co/learn/cookbook/en/fine_tuning_code_llm_on_single_gpu" rel="nofollow">훈련 구성 쿡북</a>을 참고하세요.';return{c(){r=M("p"),r.innerHTML=T},l(i){r=u(i,"P",{"data-svelte-h":!0}),d(r)!=="svelte-oywe3r"&&(r.innerHTML=T)},m(i,g){n(i,r,g)},p:ze,d(i){i&&l(r)}}}function ln(J){let r,T='📖 <strong>더 자세히 알아보기</strong>: Trainer 클래스와 그 매개변수에 대한 자세한 내용은 <a href="https://huggingface.co/docs/transformers/main/en/main_classes/trainer" rel="nofollow">Trainer API 문서</a>를 방문하고 <a href="https://huggingface.co/learn/cookbook/en/fine_tuning_code_llm_on_single_gpu" rel="nofollow">훈련 쿡북 레시피</a>에서 고급 사용 패턴을 살펴보세요.';return{c(){r=M("p"),r.innerHTML=T},l(i){r=u(i,"P",{"data-svelte-h":!0}),d(r)!=="svelte-1vnjsqm"&&(r.innerHTML=T)},m(i,g){n(i,r,g)},p:ze,d(i){i&&l(r)}}}function nn(J){let r,T='다양한 평가 메트릭과 전략에 대해 알아보려면 <a href="https://huggingface.co/docs/evaluate/" rel="nofollow">🤗 Evaluate 문서</a>를 참고하세요.';return{c(){r=M("p"),r.innerHTML=T},l(i){r=u(i,"P",{"data-svelte-h":!0}),d(r)!=="svelte-3mjkop"&&(r.innerHTML=T)},m(i,g){n(i,r,g)},p:ze,d(i){i&&l(r)}}}function sn(J){let r,T='🎯 <strong>성능 최적화</strong>: 분산 훈련, 메모리 최적화, 하드웨어별 최적화를 포함한 고급 훈련 기술에 대해서는 <a href="https://huggingface.co/docs/transformers/main/en/performance" rel="nofollow">🤗 Transformers 성능 가이드</a>를 살펴보세요.';return{c(){r=M("p"),r.innerHTML=T},l(i){r=u(i,"P",{"data-svelte-h":!0}),d(r)!=="svelte-1avfr8p"&&(r.innerHTML=T)},m(i,g){n(i,r,g)},p:ze,d(i){i&&l(r)}}}function an(J){let r,T='📝 <strong>더 많은 예제</strong>: <a href="https://huggingface.co/docs/transformers/main/en/notebooks" rel="nofollow">🤗 Transformers 노트북</a>에 있는 방대한 자료를 확인해 보세요.';return{c(){r=M("p"),r.innerHTML=T},l(i){r=u(i,"P",{"data-svelte-h":!0}),d(r)!=="svelte-1j34o6j"&&(r.innerHTML=T)},m(i,g){n(i,r,g)},p:ze,d(i){i&&l(r)}}}function rn(J){let r,T="💡 <strong>핵심 요점:</strong>",i,g,w="<li><code>Trainer</code> API는 대부분의 훈련 복잡성을 처리하는 높은 수준의 인터페이스를 제공합니다.</li> <li><code>processing_class</code>는 적절한 데이터 처리를 위해 토크나이저를 저장하는 데 사용됩니다.</li> <li><code>TrainingArguments</code>는 학습률, 배치 크기, 평가 전략, 최적화 등 훈련의 모든 측면을 제어합니다.</li> <li><code>compute_metrics</code>를 사용하면 훈련 손실 외에 사용자 정의 평가 메트릭을 활용할 수 있습니다.</li> <li>혼합 정밀도(<code>fp16=True</code>)와 그레이디언트 누적과 같은 최신 기능은 훈련 효율성을 크게 향상시킬 수 있습니다.</li>";return{c(){r=M("p"),r.innerHTML=T,i=s(),g=M("ul"),g.innerHTML=w},l(U){r=u(U,"P",{"data-svelte-h":!0}),d(r)!=="svelte-3aouuq"&&(r.innerHTML=T),i=a(U),g=u(U,"UL",{"data-svelte-h":!0}),d(g)!=="svelte-56lnro"&&(g.innerHTML=w)},m(U,b){n(U,r,b),n(U,i,b),n(U,g,b)},p:ze,d(U){U&&(l(r),l(i),l(g))}}}function pn(J){let r,T,i,g,w,U,b,Ae,H,Be,W,qe,G,il='🤗 Transformers는 <code>Trainer</code> 클래스를 제공합니다. 이 클래스를 사용하면 사전 학습된 모델을 여러분의 데이터셋에 맞춰 최신 기법으로 쉽게 미세 조정할 수 있습니다. 이전 섹션에서 데이터 전처리 작업을 모두 마쳤다면 이제 몇 단계만 거치면 <code>Trainer</code>를 정의할 수 있습니다. 가장 어려운 부분은 <code>Trainer.train()</code>을 실행할 환경을 준비하는 과정일 수 있습니다. 이 작업은 CPU에서 매우 느리게 실행되기 때문입니다. 만약 GPU가 없다면 <a href="https://colab.research.google.com/" rel="nofollow">Google Colab</a>에서 무료로 제공하는 GPU나 TPU를 이용할 수 있습니다.',Le,_,Ne,I,pl="아래 코드 예시는 이전 섹션의 코드를 모두 실행했다는 가정하에 작동합니다. 즉, 다음 사항들이 필요합니다.",Pe,Z,Se,E,De,Q,ol="<code>Trainer</code>를 정의하기 전 첫 번째 단계는 <code>Trainer</code>가 훈련 및 평가에 사용할 모든 하이퍼파라미터를 담을<code>TrainingArguments</code> 클래스를 정의하는 것입니다. 필수로 제공해야 하는 유일한 인수는 훈련된 모델과 중간 체크포인트가 저장될 디렉토리입니다. 나머지는 기본값으로 둘 수 있으며, 기본적인 미세 조정 작업에는 충분한 설정입니다.",Ke,V,Oe,X,cl='훈련 중에 모델을 Hub에 자동으로 업로드하려면 <code>TrainingArguments</code>에서 <code>push_to_hub=True</code>를 전달하세요. 이 기능에 대해서는 <a href="/course/chapter4/3">Chapter 4</a>에서 자세히 알아보겠습니다.',et,j,tt,z,ml='두 번째 단계는 모델을 정의하는 것입니다. <a href="/course/chapter2">이전 챕터</a>에서와 같이 두 개의 라벨과 함께 <code>AutoModelForSequenceClassification</code> 클래스를 사용하겠습니다.',lt,Y,nt,F,fl='<a href="/course/chapter2">Chapter 2</a>와 달리 이 사전 훈련된 모델을 인스턴스화하면  경고 메시지가 나타나는 것을 확인할 수 있습니다. 이는 BERT가 문장 쌍 분류를 위해 사전 훈련되지 않았기 때문에, 사전 훈련된 모델의 헤드가 제거되고 시퀀스 분류에 적합한 새로운 헤드가 추가되었기 때문입니다. 경고는 일부 가중치(제거된 사전 훈련 헤드에 해당하는 가중치)가 사용되지 않았고, 일부 다른 가중치(새로운 헤드용)가 무작위로 초기화되었다는 것을 나타냅니다. 마지막으로 모델을 훈련시키라는 메시지가 나오는데, 바로 지금부터 그 작업을 시작하겠습니다.',st,A,$l="모델이 준비되면, 지금까지 구성한 모든 객체(<code>model</code>, <code>training_args</code>, 훈련 및 검증 데이터셋, <code>data_collator</code>, <code>processing_class</code>)를 전달하여 <code>Trainer</code>를 정의할 수 있습니다. <code>processing_class</code> 매개변수는 비교적 최근에 추가된 기능으로, <code>Trainer</code>에게 어떤 토크나이저를 사용해 데이터를 처리할지 알려줍니다.",at,B,rt,q,Ml="<code>processing_class</code>에 토크나이저를 전달하면, <code>Trainer</code>가 기본적으로 <code>DataCollatorWithPadding</code>을 <code>data_collator</code>로 사용합니다. 따라서 이 경우에는 <code>data_collator=data_collator</code> 줄을 생략할 수 있지만, 데이터 처리 파이프라인의 중요한 부분을 보여드리기 위해 코드에 포함했습니다.",it,C,pt,L,ul="데이터셋에서 모델을 미세 조정하려면 <code>Trainer</code>의 <code>train()</code> 메소드를 호출하기만 하면 됩니다.",ot,N,ct,P,dl="이렇게 하면 미세 조정이 시작됩니다(GPU에서는 몇 분 정도 소요됩니다). 500단계마다 훈련 손실이 출력되지만, 모델의 성능이 얼마나 좋은지(또는 나쁜지)는 알려주지 않습니다. 그 이유는 다음과 같습니다.",mt,S,Tl="<li><code>TrainingArguments</code>에서 <code>eval_strategy</code>를 <code>&quot;steps&quot;</code> (매 <code>eval_steps</code>마다 평가) 또는 <code>&quot;epoch&quot;</code> (각 에포크 종료 시 평가)로 설정하지 않았습니다.</li> <li>평가 중에 메트릭을 계산하기 위한 <code>compute_metrics()</code> 함수를 <code>Trainer</code>에 제공하지 않았습니다. 이 함수가 없으면 평가에서 손실 값만 출력되는데, 이 값만으로는 성능을 파악하기 어렵습니다.</li>",ft,D,$t,K,gl="이제 유용한 <code>compute_metrics()</code> 함수를 어떻게 만들고 다음 훈련 시 사용할 수 있는지 알아보겠습니다. 이 함수는 <code>EvalPrediction</code> 객체(<code>predictions</code> 필드와 <code>label_ids</code> 필드를 갖는 명명된 튜플)를 입력받습니다. 그리고 각 메트릭의 이름을 키(문자열)로, 성능을 값(부동소수점)으로 갖는 딕셔너리를 반환해야 합니다. 모델의 예측값을 얻기 위해 <code>Trainer.predict()</code>를 사용할 수 있습니다.",Mt,O,ut,ee,dt,te,Jl="<code>predict()</code> 메소드의 출력은 <code>predictions</code>, <code>label_ids</code>, <code>metrics</code> 세 개의 필드가 있는 또 다른 명명된 튜플입니다. <code>metrics</code> 필드에는 전달된 데이터셋에 대한 손실 값과 시간 관련 메트릭(총 예측 시간, 평균 예측 시간)만 포함됩니다. 하지만 <code>compute_metrics()</code> 함수를 완성하여 <code>Trainer</code>에 전달하면, 이 필드에 <code>compute_metrics()</code>가 반환하는 메트릭들도 함께 포함됩니다.",Tt,le,yl='보시다시피, <code>predictions</code>는 408 x 2 모양의 2차원 배열입니다 (408은 predict()에 전달한 데이터셋의 샘플 개수입니다). 이 값들은 <code>predict()</code>에 전달한 데이터셋의 각 샘플에 대한 로짓입니다 (<a href="/course/chapter2">이전 챕터</a>에서 보았듯이 모든 Transformer 모델은 로짓을 반환합니다). 이 로짓을 우리가 가진 레이블과 비교할 수 있는 예측값으로 변환하려면, 두 번째 축에서 최댓값을 가진 인덱스를 구해야 합니다.',gt,ne,Jt,se,Ul='이제 이 <code>preds</code>를 라벨과 비교할 수 있습니다. <code>compute_metric()</code> 함수를 빌드하기 위해 🤗 <a href="https://github.com/huggingface/evaluate/" rel="nofollow">Evaluate</a> 라이브러리의 메트릭을 활용하겠습니다. 데이터셋을 로드했던 것처럼, MRPC 데이터셋과 관련된 메트릭도 <code>evaluate.load()</code> 함수로 쉽게 로드할 수 있습니다. 반환된 객체의 <code>compute()</code> 메서드를 사용해 메트릭을 계산할 수 있습니다.',yt,ae,Ut,re,wt,v,bt,ie,wl='모델 헤드의 가중치가 무작위로 초기화되기 때문에 얻게 되는 결과는 조금씩 다를 수 있습니다. 결과를 보면 우리 모델이 검증 세트에서 85.78%의 정확도와 89.97%의 F1 점수를 달성했음을 볼 수 있습니다. 이 두 가지는 GLUE 벤치마크의 MRPC 데이터셋에서 결과를 평가하는 데 사용되는 메트릭입니다. <a href="https://arxiv.org/pdf/1810.04805.pdf" rel="nofollow">BERT 논문</a>에서는 기본 모델의 F1 점수를 88.9로 보고하였습니다. 당시에는 <code>uncased</code> 모델을 사용했지만, 우리는 현재 <code>cased</code> 모델을 사용하고 있기 때문에 더 나은 결과가 나온 것입니다.',ht,pe,bl="이 모든 것을 종합하면, 다음처럼 <code>compute_metrics()</code> 함수를 다음과 같이 정의할 수 있습니다.",_t,oe,jt,ce,hl="각 에폭이 끝날 때마다 메트릭이 출력되도록, 이 <code>compute_metrics()</code> 함수가 포함하여 <code>Trainer</code>를 새로 정의해 보겠습니다.",Ct,me,vt,fe,_l="참고로, 우리는 <code>eval_strategy</code>를 <code>&quot;epoch&quot;</code>으로 설정한 새로운 <code>TrainingArguments</code>와 새로운 모델을 생성합니다. 이렇게 하지 않으면 이미 훈련된 모델의 훈련을 계속하게 될 겁니다. 새로운 훈련을 시작하려면 다음을 실행하세요.",kt,$e,Rt,Me,jl="이번에는 훈련 손실 외에도 각 에폭이 끝날 때마다 검증 손실과 메트릭이 함께 출력될 겁니다. 앞서 말했듯이 모델 헤드의 무작위 초기화 때문에 여러분이 얻는 정확도/F1 점수는 우리가 얻은 결과와 약간 다를 수 있지만, 비슷한 범위에 있을 겁니다.",xt,ue,Ht,de,Cl="<code>Trainer</code>는 현대 딥러닝의 모범 사례들을 쉽게 활용할 수 있도록 다양한 내장 기능을 제공합니다.",Wt,Te,vl="<strong>혼합 정밀도 훈련</strong>: 더 빠른 훈련과 메모리 사용량 감소를 위해 훈련 인수에서 <code>fp16=True</code>를 설정하세요.",Gt,ge,It,Je,kl="<strong>그레이디언트 누적</strong>: GPU 메모리가 부족할 때 더 큰 배치 크기로 학습하는 효과를 낼 수 있습니다.",Zt,ye,Et,Ue,Rl="<strong>학습률 스케줄링</strong>: Trainer는 기본적으로 선형 감소 방식을 사용하지만, 사용자 맞춤 설정이 가능합니다.",Qt,we,Vt,k,Xt,be,xl="<code>Trainer</code>는 여러 GPU 또는 TPU에서 즉시 작동하며 분산 훈련을 위한 많은 옵션을 제공합니다. 이와 관련된 모든 내용은 Chapter 10에서 다루겠습니다.",zt,he,Hl='이것으로 <code>Trainer</code> API를 사용한 미세 조정 소개를 마칩니다. 대부분의 일반적인 NLP 작업에 대한 예제는 <a href="/course/chapter7">Chapter 7</a>에서 다룰 예정이며, 다음으로는 순수 PyTorch 코드로 동일한 작업을 수행하는 방법을 살펴보겠습니다.',Yt,R,Ft,_e,At,je,Wl="Trainer API와 미세 조정 개념에 대한 이해를 테스트해보세요.",Bt,Ce,qt,ve,Lt,ke,Nt,Re,Pt,xe,St,He,Dt,We,Kt,Ge,Ot,Ie,el,Ze,tl,Ee,ll,Qe,nl,x,sl,Ve,al,Fe,rl;return w=new Kl({props:{fw:J[0]}}),b=new h({props:{title:"Trainer API로 모델 미세 조정하기",local:"fine-tuning-a-model-with-the-trainer-api",headingTag:"h1"}}),H=new Dl({props:{chapter:3,classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/en/chapter3/section3.ipynb"},{label:"Aws Studio",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/en/chapter3/section3.ipynb"}]}}),W=new Sl({props:{id:"nvBXf7s7vTI"}}),_=new Xe({props:{$$slots:{default:[en]},$$scope:{ctx:J}}}),Z=new y({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBEYXRhQ29sbGF0b3JXaXRoUGFkZGluZyUwQSUwQXJhd19kYXRhc2V0cyUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJnbHVlJTIyJTJDJTIwJTIybXJwYyUyMiklMEFjaGVja3BvaW50JTIwJTNEJTIwJTIyYmVydC1iYXNlLXVuY2FzZWQlMjIlMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZChjaGVja3BvaW50KSUwQSUwQSUwQWRlZiUyMHRva2VuaXplX2Z1bmN0aW9uKGV4YW1wbGUpJTNBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwdG9rZW5pemVyKGV4YW1wbGUlNUIlMjJzZW50ZW5jZTElMjIlNUQlMkMlMjBleGFtcGxlJTVCJTIyc2VudGVuY2UyJTIyJTVEJTJDJTIwdHJ1bmNhdGlvbiUzRFRydWUpJTBBJTBBJTBBdG9rZW5pemVkX2RhdGFzZXRzJTIwJTNEJTIwcmF3X2RhdGFzZXRzLm1hcCh0b2tlbml6ZV9mdW5jdGlvbiUyQyUyMGJhdGNoZWQlM0RUcnVlKSUwQWRhdGFfY29sbGF0b3IlMjAlM0QlMjBEYXRhQ29sbGF0b3JXaXRoUGFkZGluZyh0b2tlbml6ZXIlM0R0b2tlbml6ZXIp",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, DataCollatorWithPadding

raw_datasets = load_dataset(<span class="hljs-string">&quot;glue&quot;</span>, <span class="hljs-string">&quot;mrpc&quot;</span>)
checkpoint = <span class="hljs-string">&quot;bert-base-uncased&quot;</span>
tokenizer = AutoTokenizer.from_pretrained(checkpoint)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">tokenize_function</span>(<span class="hljs-params">example</span>):
    <span class="hljs-keyword">return</span> tokenizer(example[<span class="hljs-string">&quot;sentence1&quot;</span>], example[<span class="hljs-string">&quot;sentence2&quot;</span>], truncation=<span class="hljs-literal">True</span>)


tokenized_datasets = raw_datasets.<span class="hljs-built_in">map</span>(tokenize_function, batched=<span class="hljs-literal">True</span>)
data_collator = DataCollatorWithPadding(tokenizer=tokenizer)`,wrap:!1}}),E=new h({props:{title:"훈련",local:"training",headingTag:"h3"}}),V=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRyYWluaW5nQXJndW1lbnRzJTBBJTBBdHJhaW5pbmdfYXJncyUyMCUzRCUyMFRyYWluaW5nQXJndW1lbnRzKCUyMnRlc3QtdHJhaW5lciUyMik=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TrainingArguments

training_args = TrainingArguments(<span class="hljs-string">&quot;test-trainer&quot;</span>)`,wrap:!1}}),j=new Xe({props:{$$slots:{default:[tn]},$$scope:{ctx:J}}}),Y=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKGNoZWNrcG9pbnQlMkMlMjBudW1fbGFiZWxzJTNEMik=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForSequenceClassification

model = AutoModelForSequenceClassification.from_pretrained(checkpoint, num_labels=<span class="hljs-number">2</span>)`,wrap:!1}}),B=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRyYWluZXIlMEElMEF0cmFpbmVyJTIwJTNEJTIwVHJhaW5lciglMEElMjAlMjAlMjAlMjBtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMHRyYWluaW5nX2FyZ3MlMkMlMEElMjAlMjAlMjAlMjB0cmFpbl9kYXRhc2V0JTNEdG9rZW5pemVkX2RhdGFzZXRzJTVCJTIydHJhaW4lMjIlNUQlMkMlMEElMjAlMjAlMjAlMjBldmFsX2RhdGFzZXQlM0R0b2tlbml6ZWRfZGF0YXNldHMlNUIlMjJ2YWxpZGF0aW9uJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwZGF0YV9jb2xsYXRvciUzRGRhdGFfY29sbGF0b3IlMkMlMEElMjAlMjAlMjAlMjBwcm9jZXNzaW5nX2NsYXNzJTNEdG9rZW5pemVyJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Trainer

trainer = Trainer(
    model,
    training_args,
    train_dataset=tokenized_datasets[<span class="hljs-string">&quot;train&quot;</span>],
    eval_dataset=tokenized_datasets[<span class="hljs-string">&quot;validation&quot;</span>],
    data_collator=data_collator,
    processing_class=tokenizer,
)`,wrap:!1}}),C=new Xe({props:{$$slots:{default:[ln]},$$scope:{ctx:J}}}),N=new y({props:{code:"dHJhaW5lci50cmFpbigp",highlighted:"trainer.train()",wrap:!1}}),D=new h({props:{title:"평가",local:"evaluation",headingTag:"h3"}}),O=new y({props:{code:"cHJlZGljdGlvbnMlMjAlM0QlMjB0cmFpbmVyLnByZWRpY3QodG9rZW5pemVkX2RhdGFzZXRzJTVCJTIydmFsaWRhdGlvbiUyMiU1RCklMEFwcmludChwcmVkaWN0aW9ucy5wcmVkaWN0aW9ucy5zaGFwZSUyQyUyMHByZWRpY3Rpb25zLmxhYmVsX2lkcy5zaGFwZSk=",highlighted:`predictions = trainer.predict(tokenized_datasets[<span class="hljs-string">&quot;validation&quot;</span>])
<span class="hljs-built_in">print</span>(predictions.predictions.shape, predictions.label_ids.shape)`,wrap:!1}}),ee=new y({props:{code:"KDQwOCUyQyUyMDIpJTIwKDQwOCUyQyk=",highlighted:'(<span class="hljs-number">408</span>, <span class="hljs-number">2</span>) (<span class="hljs-number">408</span>,)',wrap:!1}}),ne=new y({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBJTBBcHJlZHMlMjAlM0QlMjBucC5hcmdtYXgocHJlZGljdGlvbnMucHJlZGljdGlvbnMlMkMlMjBheGlzJTNELTEp",highlighted:`<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

preds = np.argmax(predictions.predictions, axis=-<span class="hljs-number">1</span>)`,wrap:!1}}),ae=new y({props:{code:"aW1wb3J0JTIwZXZhbHVhdGUlMEElMEFtZXRyaWMlMjAlM0QlMjBldmFsdWF0ZS5sb2FkKCUyMmdsdWUlMjIlMkMlMjAlMjJtcnBjJTIyKSUwQW1ldHJpYy5jb21wdXRlKHByZWRpY3Rpb25zJTNEcHJlZHMlMkMlMjByZWZlcmVuY2VzJTNEcHJlZGljdGlvbnMubGFiZWxfaWRzKQ==",highlighted:`<span class="hljs-keyword">import</span> evaluate

metric = evaluate.load(<span class="hljs-string">&quot;glue&quot;</span>, <span class="hljs-string">&quot;mrpc&quot;</span>)
metric.compute(predictions=preds, references=predictions.label_ids)`,wrap:!1}}),re=new y({props:{code:"JTdCJ2FjY3VyYWN5JyUzQSUyMDAuODU3ODQzMTM3MjU0OTAxOSUyQyUyMCdmMSclM0ElMjAwLjg5OTY1Mzk3OTIzODc1NDIlN0Q=",highlighted:'{<span class="hljs-string">&#x27;accuracy&#x27;</span>: <span class="hljs-number">0.8578431372549019</span>, <span class="hljs-string">&#x27;f1&#x27;</span>: <span class="hljs-number">0.8996539792387542</span>}',wrap:!1}}),v=new Xe({props:{$$slots:{default:[nn]},$$scope:{ctx:J}}}),oe=new y({props:{code:"ZGVmJTIwY29tcHV0ZV9tZXRyaWNzKGV2YWxfcHJlZHMpJTNBJTBBJTIwJTIwJTIwJTIwbWV0cmljJTIwJTNEJTIwZXZhbHVhdGUubG9hZCglMjJnbHVlJTIyJTJDJTIwJTIybXJwYyUyMiklMEElMjAlMjAlMjAlMjBsb2dpdHMlMkMlMjBsYWJlbHMlMjAlM0QlMjBldmFsX3ByZWRzJTBBJTIwJTIwJTIwJTIwcHJlZGljdGlvbnMlMjAlM0QlMjBucC5hcmdtYXgobG9naXRzJTJDJTIwYXhpcyUzRC0xKSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMG1ldHJpYy5jb21wdXRlKHByZWRpY3Rpb25zJTNEcHJlZGljdGlvbnMlMkMlMjByZWZlcmVuY2VzJTNEbGFiZWxzKQ==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">compute_metrics</span>(<span class="hljs-params">eval_preds</span>):
    metric = evaluate.load(<span class="hljs-string">&quot;glue&quot;</span>, <span class="hljs-string">&quot;mrpc&quot;</span>)
    logits, labels = eval_preds
    predictions = np.argmax(logits, axis=-<span class="hljs-number">1</span>)
    <span class="hljs-keyword">return</span> metric.compute(predictions=predictions, references=labels)`,wrap:!1}}),me=new y({props:{code:"dHJhaW5pbmdfYXJncyUyMCUzRCUyMFRyYWluaW5nQXJndW1lbnRzKCUyMnRlc3QtdHJhaW5lciUyMiUyQyUyMGV2YWxfc3RyYXRlZ3klM0QlMjJlcG9jaCUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKGNoZWNrcG9pbnQlMkMlMjBudW1fbGFiZWxzJTNEMiklMEElMEF0cmFpbmVyJTIwJTNEJTIwVHJhaW5lciglMEElMjAlMjAlMjAlMjBtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMHRyYWluaW5nX2FyZ3MlMkMlMEElMjAlMjAlMjAlMjB0cmFpbl9kYXRhc2V0JTNEdG9rZW5pemVkX2RhdGFzZXRzJTVCJTIydHJhaW4lMjIlNUQlMkMlMEElMjAlMjAlMjAlMjBldmFsX2RhdGFzZXQlM0R0b2tlbml6ZWRfZGF0YXNldHMlNUIlMjJ2YWxpZGF0aW9uJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwZGF0YV9jb2xsYXRvciUzRGRhdGFfY29sbGF0b3IlMkMlMEElMjAlMjAlMjAlMjBwcm9jZXNzaW5nX2NsYXNzJTNEdG9rZW5pemVyJTJDJTBBJTIwJTIwJTIwJTIwY29tcHV0ZV9tZXRyaWNzJTNEY29tcHV0ZV9tZXRyaWNzJTJDJTBBKQ==",highlighted:`training_args = TrainingArguments(<span class="hljs-string">&quot;test-trainer&quot;</span>, eval_strategy=<span class="hljs-string">&quot;epoch&quot;</span>)
model = AutoModelForSequenceClassification.from_pretrained(checkpoint, num_labels=<span class="hljs-number">2</span>)

trainer = Trainer(
    model,
    training_args,
    train_dataset=tokenized_datasets[<span class="hljs-string">&quot;train&quot;</span>],
    eval_dataset=tokenized_datasets[<span class="hljs-string">&quot;validation&quot;</span>],
    data_collator=data_collator,
    processing_class=tokenizer,
    compute_metrics=compute_metrics,
)`,wrap:!1}}),$e=new y({props:{code:"dHJhaW5lci50cmFpbigp",highlighted:"trainer.train()",wrap:!1}}),ue=new h({props:{title:"고급 훈련 기능",local:"advanced-training-features",headingTag:"h3"}}),ge=new y({props:{code:"dHJhaW5pbmdfYXJncyUyMCUzRCUyMFRyYWluaW5nQXJndW1lbnRzKCUwQSUyMCUyMCUyMCUyMCUyMnRlc3QtdHJhaW5lciUyMiUyQyUwQSUyMCUyMCUyMCUyMGV2YWxfc3RyYXRlZ3klM0QlMjJlcG9jaCUyMiUyQyUwQSUyMCUyMCUyMCUyMGZwMTYlM0RUcnVlJTJDJTIwJTIwJTIzJTIwJUVEJTk4JUJDJUVEJTk1JUE5JTIwJUVDJUEwJTk1JUVCJUIwJTgwJUVCJThGJTg0JTIwJUVEJTk5JTlDJUVDJTg0JUIxJUVEJTk5JTk0JTBBKQ==",highlighted:`training_args = TrainingArguments(
    <span class="hljs-string">&quot;test-trainer&quot;</span>,
    eval_strategy=<span class="hljs-string">&quot;epoch&quot;</span>,
    fp16=<span class="hljs-literal">True</span>,  <span class="hljs-comment"># 혼합 정밀도 활성화</span>
)`,wrap:!1}}),ye=new y({props:{code:"dHJhaW5pbmdfYXJncyUyMCUzRCUyMFRyYWluaW5nQXJndW1lbnRzKCUwQSUyMCUyMCUyMCUyMCUyMnRlc3QtdHJhaW5lciUyMiUyQyUwQSUyMCUyMCUyMCUyMGV2YWxfc3RyYXRlZ3klM0QlMjJlcG9jaCUyMiUyQyUwQSUyMCUyMCUyMCUyMHBlcl9kZXZpY2VfdHJhaW5fYmF0Y2hfc2l6ZSUzRDQlMkMlMEElMjAlMjAlMjAlMjBncmFkaWVudF9hY2N1bXVsYXRpb25fc3RlcHMlM0Q0JTJDJTIwJTIwJTIzJTIwJUVDJTlDJUEwJUVEJTlBJUE4JTIwJUVCJUIwJUIwJUVDJUI5JTk4JTIwJUVEJTgxJUFDJUVBJUI4JUIwJTIwJTNEJTIwNCUyMColMjA0JTIwJTNEJTIwMTYlMEEp",highlighted:`training_args = TrainingArguments(
    <span class="hljs-string">&quot;test-trainer&quot;</span>,
    eval_strategy=<span class="hljs-string">&quot;epoch&quot;</span>,
    per_device_train_batch_size=<span class="hljs-number">4</span>,
    gradient_accumulation_steps=<span class="hljs-number">4</span>,  <span class="hljs-comment"># 유효 배치 크기 = 4 * 4 = 16</span>
)`,wrap:!1}}),we=new y({props:{code:"dHJhaW5pbmdfYXJncyUyMCUzRCUyMFRyYWluaW5nQXJndW1lbnRzKCUwQSUyMCUyMCUyMCUyMCUyMnRlc3QtdHJhaW5lciUyMiUyQyUwQSUyMCUyMCUyMCUyMGV2YWxfc3RyYXRlZ3klM0QlMjJlcG9jaCUyMiUyQyUwQSUyMCUyMCUyMCUyMGxlYXJuaW5nX3JhdGUlM0QyZS01JTJDJTBBJTIwJTIwJTIwJTIwbHJfc2NoZWR1bGVyX3R5cGUlM0QlMjJjb3NpbmUlMjIlMkMlMjAlMjAlMjMlMjAlRUIlOEIlQTQlRUIlQTUlQjglMjAlRUMlOEElQTQlRUMlQkMlODAlRUMlQTQlODQlRUIlOUYlQUMlMjAlRUMlOEIlOUMlRUIlOEYlODQlMEEp",highlighted:`training_args = TrainingArguments(
    <span class="hljs-string">&quot;test-trainer&quot;</span>,
    eval_strategy=<span class="hljs-string">&quot;epoch&quot;</span>,
    learning_rate=<span class="hljs-number">2e-5</span>,
    lr_scheduler_type=<span class="hljs-string">&quot;cosine&quot;</span>,  <span class="hljs-comment"># 다른 스케줄러 시도</span>
)`,wrap:!1}}),k=new Xe({props:{$$slots:{default:[sn]},$$scope:{ctx:J}}}),R=new Xe({props:{$$slots:{default:[an]},$$scope:{ctx:J}}}),_e=new h({props:{title:"섹션 퀴즈",local:"section-quiz",headingTag:"h2"}}),Ce=new h({props:{title:"1. Trainer 에서 <code> processing_class </code> 매개변수의 목적은 무엇인가요?",local:"1-trainer-에서-code-processingclass-code-매개변수의-목적은-무엇인가요",headingTag:"h3"}}),ve=new Ye({props:{choices:[{text:"사용할 모델 아키텍처를 지정합니다.",explain:"모델 아키텍처는 모델을 로드할 때 지정되며, Trainer에서 지정하지 않습니다."},{text:"데이터 처리에 사용할 토크나이저를 Trainer에 알려줍니다.",explain:"processing_class 매개변수는 사용할 토크나이저를 Trainer가 알 수 있도록 도와주는 최신 추가 사항입니다.",correct:!0},{text:"훈련을 위한 배치 크기를 결정합니다.",explain:"배치 크기는 processing_class가 아닌 TrainingArguments에서 설정됩니다."},{text:"평가 빈도를 제어합니다.",explain:"평가 빈도는 TrainingArguments의 eval_strategy로 제어됩니다."}]}}),ke=new h({props:{title:"2. 훈련 중 평가가 얼마나 자주 발생하는지를 제어하는 TrainingArguments 매개변수는 무엇인가요?",local:"2-훈련-중-평가가-얼마나-자주-발생하는지를-제어하는-trainingarguments-매개변수는-무엇인가요",headingTag:"h3"}}),Re=new Ye({props:{choices:[{text:"eval_frequency",explain:"TrainingArguments에는 eval_frequency 매개변수가 없습니다."},{text:"eval_strategy",explain:"eval_strategy는 평가 타이밍을 제어하기 위해 'epoch', 'steps', 또는 'no'로 설정할 수 있습니다.",correct:!0},{text:"evaluation_steps",explain:"eval_steps는 평가 사이의 단계 수를 설정하지만, eval_strategy가 평가 발생 여부/시기를 결정합니다."},{text:"do_eval",explain:"최신 TrainingArguments에는 do_eval 매개변수가 없습니다."}]}}),xe=new h({props:{title:"3. TrainingArguments에서 <code> fp16=True </code> 는 무엇을 활성화하나요?",local:"3-trainingarguments에서-code-fp16true-code-는-무엇을-활성화하나요",headingTag:"h3"}}),He=new Ye({props:{choices:[{text:"더 빠른 훈련을 위한 16비트 정수 정밀도",explain:"fp16은 정수 정밀도가 아닌 부동소수점 정밀도를 의미합니다."},{text:"더 빠른 훈련과 메모리 사용량 감소를 위한 16비트 부동소수점 수를 사용한 혼합 정밀도 훈련",explain:"혼합 정밀도 훈련은 순전파에는 16비트 플로트를, 그레이디언트에는 32비트를 사용하여 속도를 향상시키고 메모리 사용량을 줄입니다.",correct:!0},{text:"정확히 16 에포크 동안 훈련",explain:"fp16은 에포크 수와 관련이 없습니다."},{text:"분산 훈련을 위한 16개 GPU 사용",explain:"GPU 수는 fp16 매개변수로 제어되지 않습니다."}]}}),We=new h({props:{title:"4. Trainer에서 <code> compute_metrics </code> 함수의 역할은 무엇인가요?",local:"4-trainer에서-code-computemetrics-code-함수의-역할은-무엇인가요",headingTag:"h3"}}),Ge=new Ye({props:{choices:[{text:"훈련 중 손실을 계산합니다.",explain:"손실 계산은 compute_metrics가 아닌 모델에서 자동으로 처리됩니다."},{text:"로짓을 예측으로 변환하고 정확도 및 F1과 같은 평가 메트릭을 계산합니다.",explain:"compute_metrics는 예측과 라벨을 받아서 평가를 위한 메트릭을 반환합니다.",correct:!0},{text:"사용할 옵티마이저를 결정합니다.",explain:"옵티마이저 선택은 compute_metrics로 처리되지 않습니다."},{text:"훈련 데이터를 전처리합니다.",explain:"데이터 전처리는 훈련 전에 수행되며, 평가 중 compute_metrics로 수행되지 않습니다."}]}}),Ie=new h({props:{title:"5. Trainer에 <code> eval_dataset </code> 을 제공하지 않으면 어떻게 되나요?",local:"5-trainer에-code-evaldataset-code-을-제공하지-않으면-어떻게-되나요",headingTag:"h3"}}),Ze=new Ye({props:{choices:[{text:"훈련이 오류와 함께 실패합니다.",explain:"eval_dataset 없이도 훈련을 진행할 수 있지만, 평가 메트릭은 얻을 수 없습니다."},{text:"Trainer가 자동으로 훈련 데이터를 평가용으로 분할합니다.",explain:"Trainer는 자동으로 검증 분할을 생성하지 않습니다."},{text:"훈련 중 평가 메트릭을 얻을 수 없지만 훈련은 여전히 작동합니다.",explain:"평가는 선택사항입니다 - 평가 없이도 훈련할 수 있지만 검증 메트릭은 볼 수 없습니다.",correct:!0},{text:"모델이 평가를 위해 훈련 데이터를 사용합니다.",explain:"Trainer는 자동으로 평가를 위해 훈련 데이터를 사용하지 않습니다 - 단순히 평가하지 않습니다."}]}}),Ee=new h({props:{title:"6. 그레이디언트 누적이란 무엇이며 어떻게 활성화하나요?",local:"6-그레이디언트-누적이란-무엇이며-어떻게-활성화하나요",headingTag:"h3"}}),Qe=new Ye({props:{choices:[{text:"그레이디언트를 디스크에 저장하는 것으로, save_gradients=True로 활성화됩니다.",explain:"그레이디언트 누적은 그레이디언트를 디스크에 저장하는 것과 관련이 없습니다."},{text:"업데이트 전에 여러 배치에 걸쳐 그레이디언트를 누적하는 것으로, gradient_accumulation_steps로 활성화됩니다.",explain:"이를 통해 여러 순전파에 걸쳐 그레이디언트를 누적하여 더 큰 배치 크기를 시뮬레이션할 수 있습니다.",correct:!0},{text:"그레이디언트 계산을 가속화하는 것으로, fp16과 함께 자동으로 활성화됩니다.",explain:"fp16이 훈련을 가속화할 수 있지만, 그레이디언트 누적은 별도의 기술입니다."},{text:"그레이디언트 오버플로우를 방지하는 것으로, gradient_clipping=True로 활성화됩니다.",explain:"이는 그레이디언트 누적이 아닌 그레이디언트 클리핑을 설명합니다."}]}}),x=new Xe({props:{$$slots:{default:[rn]},$$scope:{ctx:J}}}),Ve=new Ol({props:{source:"https://github.com/huggingface/course/blob/main/chapters/ko/chapter3/3.mdx"}}),{c(){r=M("meta"),T=s(),i=M("p"),g=s(),p(w.$$.fragment),U=s(),p(b.$$.fragment),Ae=s(),p(H.$$.fragment),Be=s(),p(W.$$.fragment),qe=s(),G=M("p"),G.innerHTML=il,Le=s(),p(_.$$.fragment),Ne=s(),I=M("p"),I.textContent=pl,Pe=s(),p(Z.$$.fragment),Se=s(),p(E.$$.fragment),De=s(),Q=M("p"),Q.innerHTML=ol,Ke=s(),p(V.$$.fragment),Oe=s(),X=M("p"),X.innerHTML=cl,et=s(),p(j.$$.fragment),tt=s(),z=M("p"),z.innerHTML=ml,lt=s(),p(Y.$$.fragment),nt=s(),F=M("p"),F.innerHTML=fl,st=s(),A=M("p"),A.innerHTML=$l,at=s(),p(B.$$.fragment),rt=s(),q=M("p"),q.innerHTML=Ml,it=s(),p(C.$$.fragment),pt=s(),L=M("p"),L.innerHTML=ul,ot=s(),p(N.$$.fragment),ct=s(),P=M("p"),P.textContent=dl,mt=s(),S=M("ol"),S.innerHTML=Tl,ft=s(),p(D.$$.fragment),$t=s(),K=M("p"),K.innerHTML=gl,Mt=s(),p(O.$$.fragment),ut=s(),p(ee.$$.fragment),dt=s(),te=M("p"),te.innerHTML=Jl,Tt=s(),le=M("p"),le.innerHTML=yl,gt=s(),p(ne.$$.fragment),Jt=s(),se=M("p"),se.innerHTML=Ul,yt=s(),p(ae.$$.fragment),Ut=s(),p(re.$$.fragment),wt=s(),p(v.$$.fragment),bt=s(),ie=M("p"),ie.innerHTML=wl,ht=s(),pe=M("p"),pe.innerHTML=bl,_t=s(),p(oe.$$.fragment),jt=s(),ce=M("p"),ce.innerHTML=hl,Ct=s(),p(me.$$.fragment),vt=s(),fe=M("p"),fe.innerHTML=_l,kt=s(),p($e.$$.fragment),Rt=s(),Me=M("p"),Me.textContent=jl,xt=s(),p(ue.$$.fragment),Ht=s(),de=M("p"),de.innerHTML=Cl,Wt=s(),Te=M("p"),Te.innerHTML=vl,Gt=s(),p(ge.$$.fragment),It=s(),Je=M("p"),Je.innerHTML=kl,Zt=s(),p(ye.$$.fragment),Et=s(),Ue=M("p"),Ue.innerHTML=Rl,Qt=s(),p(we.$$.fragment),Vt=s(),p(k.$$.fragment),Xt=s(),be=M("p"),be.innerHTML=xl,zt=s(),he=M("p"),he.innerHTML=Hl,Yt=s(),p(R.$$.fragment),Ft=s(),p(_e.$$.fragment),At=s(),je=M("p"),je.textContent=Wl,Bt=s(),p(Ce.$$.fragment),qt=s(),p(ve.$$.fragment),Lt=s(),p(ke.$$.fragment),Nt=s(),p(Re.$$.fragment),Pt=s(),p(xe.$$.fragment),St=s(),p(He.$$.fragment),Dt=s(),p(We.$$.fragment),Kt=s(),p(Ge.$$.fragment),Ot=s(),p(Ie.$$.fragment),el=s(),p(Ze.$$.fragment),tl=s(),p(Ee.$$.fragment),ll=s(),p(Qe.$$.fragment),nl=s(),p(x.$$.fragment),sl=s(),p(Ve.$$.fragment),al=s(),Fe=M("p"),this.h()},l(e){const t=Nl("svelte-u9bgzb",document.head);r=u(t,"META",{name:!0,content:!0}),t.forEach(l),T=a(e),i=u(e,"P",{}),Yl(i).forEach(l),g=a(e),o(w.$$.fragment,e),U=a(e),o(b.$$.fragment,e),Ae=a(e),o(H.$$.fragment,e),Be=a(e),o(W.$$.fragment,e),qe=a(e),G=u(e,"P",{"data-svelte-h":!0}),d(G)!=="svelte-knkc89"&&(G.innerHTML=il),Le=a(e),o(_.$$.fragment,e),Ne=a(e),I=u(e,"P",{"data-svelte-h":!0}),d(I)!=="svelte-hs8a7l"&&(I.textContent=pl),Pe=a(e),o(Z.$$.fragment,e),Se=a(e),o(E.$$.fragment,e),De=a(e),Q=u(e,"P",{"data-svelte-h":!0}),d(Q)!=="svelte-1enyha7"&&(Q.innerHTML=ol),Ke=a(e),o(V.$$.fragment,e),Oe=a(e),X=u(e,"P",{"data-svelte-h":!0}),d(X)!=="svelte-18au6nv"&&(X.innerHTML=cl),et=a(e),o(j.$$.fragment,e),tt=a(e),z=u(e,"P",{"data-svelte-h":!0}),d(z)!=="svelte-nt9c4b"&&(z.innerHTML=ml),lt=a(e),o(Y.$$.fragment,e),nt=a(e),F=u(e,"P",{"data-svelte-h":!0}),d(F)!=="svelte-s3sck9"&&(F.innerHTML=fl),st=a(e),A=u(e,"P",{"data-svelte-h":!0}),d(A)!=="svelte-4ai6qh"&&(A.innerHTML=$l),at=a(e),o(B.$$.fragment,e),rt=a(e),q=u(e,"P",{"data-svelte-h":!0}),d(q)!=="svelte-1m2yas3"&&(q.innerHTML=Ml),it=a(e),o(C.$$.fragment,e),pt=a(e),L=u(e,"P",{"data-svelte-h":!0}),d(L)!=="svelte-13y4n8x"&&(L.innerHTML=ul),ot=a(e),o(N.$$.fragment,e),ct=a(e),P=u(e,"P",{"data-svelte-h":!0}),d(P)!=="svelte-1vb1ztl"&&(P.textContent=dl),mt=a(e),S=u(e,"OL",{"data-svelte-h":!0}),d(S)!=="svelte-1kijd9m"&&(S.innerHTML=Tl),ft=a(e),o(D.$$.fragment,e),$t=a(e),K=u(e,"P",{"data-svelte-h":!0}),d(K)!=="svelte-1kov8l9"&&(K.innerHTML=gl),Mt=a(e),o(O.$$.fragment,e),ut=a(e),o(ee.$$.fragment,e),dt=a(e),te=u(e,"P",{"data-svelte-h":!0}),d(te)!=="svelte-44hwg3"&&(te.innerHTML=Jl),Tt=a(e),le=u(e,"P",{"data-svelte-h":!0}),d(le)!=="svelte-1f3lia8"&&(le.innerHTML=yl),gt=a(e),o(ne.$$.fragment,e),Jt=a(e),se=u(e,"P",{"data-svelte-h":!0}),d(se)!=="svelte-4of9x9"&&(se.innerHTML=Ul),yt=a(e),o(ae.$$.fragment,e),Ut=a(e),o(re.$$.fragment,e),wt=a(e),o(v.$$.fragment,e),bt=a(e),ie=u(e,"P",{"data-svelte-h":!0}),d(ie)!=="svelte-1ylr8sj"&&(ie.innerHTML=wl),ht=a(e),pe=u(e,"P",{"data-svelte-h":!0}),d(pe)!=="svelte-2jb62l"&&(pe.innerHTML=bl),_t=a(e),o(oe.$$.fragment,e),jt=a(e),ce=u(e,"P",{"data-svelte-h":!0}),d(ce)!=="svelte-vtoh1f"&&(ce.innerHTML=hl),Ct=a(e),o(me.$$.fragment,e),vt=a(e),fe=u(e,"P",{"data-svelte-h":!0}),d(fe)!=="svelte-14c26ht"&&(fe.innerHTML=_l),kt=a(e),o($e.$$.fragment,e),Rt=a(e),Me=u(e,"P",{"data-svelte-h":!0}),d(Me)!=="svelte-1yytiyu"&&(Me.textContent=jl),xt=a(e),o(ue.$$.fragment,e),Ht=a(e),de=u(e,"P",{"data-svelte-h":!0}),d(de)!=="svelte-1lmwzzc"&&(de.innerHTML=Cl),Wt=a(e),Te=u(e,"P",{"data-svelte-h":!0}),d(Te)!=="svelte-1h0qf0f"&&(Te.innerHTML=vl),Gt=a(e),o(ge.$$.fragment,e),It=a(e),Je=u(e,"P",{"data-svelte-h":!0}),d(Je)!=="svelte-pmu9yq"&&(Je.innerHTML=kl),Zt=a(e),o(ye.$$.fragment,e),Et=a(e),Ue=u(e,"P",{"data-svelte-h":!0}),d(Ue)!=="svelte-umpq8u"&&(Ue.innerHTML=Rl),Qt=a(e),o(we.$$.fragment,e),Vt=a(e),o(k.$$.fragment,e),Xt=a(e),be=u(e,"P",{"data-svelte-h":!0}),d(be)!=="svelte-kboajh"&&(be.innerHTML=xl),zt=a(e),he=u(e,"P",{"data-svelte-h":!0}),d(he)!=="svelte-1p27re0"&&(he.innerHTML=Hl),Yt=a(e),o(R.$$.fragment,e),Ft=a(e),o(_e.$$.fragment,e),At=a(e),je=u(e,"P",{"data-svelte-h":!0}),d(je)!=="svelte-1f5akmu"&&(je.textContent=Wl),Bt=a(e),o(Ce.$$.fragment,e),qt=a(e),o(ve.$$.fragment,e),Lt=a(e),o(ke.$$.fragment,e),Nt=a(e),o(Re.$$.fragment,e),Pt=a(e),o(xe.$$.fragment,e),St=a(e),o(He.$$.fragment,e),Dt=a(e),o(We.$$.fragment,e),Kt=a(e),o(Ge.$$.fragment,e),Ot=a(e),o(Ie.$$.fragment,e),el=a(e),o(Ze.$$.fragment,e),tl=a(e),o(Ee.$$.fragment,e),ll=a(e),o(Qe.$$.fragment,e),nl=a(e),o(x.$$.fragment,e),sl=a(e),o(Ve.$$.fragment,e),al=a(e),Fe=u(e,"P",{}),Yl(Fe).forEach(l),this.h()},h(){Fl(r,"name","hf:doc:metadata"),Fl(r,"content",on)},m(e,t){Pl(document.head,r),n(e,T,t),n(e,i,t),n(e,g,t),c(w,e,t),n(e,U,t),c(b,e,t),n(e,Ae,t),c(H,e,t),n(e,Be,t),c(W,e,t),n(e,qe,t),n(e,G,t),n(e,Le,t),c(_,e,t),n(e,Ne,t),n(e,I,t),n(e,Pe,t),c(Z,e,t),n(e,Se,t),c(E,e,t),n(e,De,t),n(e,Q,t),n(e,Ke,t),c(V,e,t),n(e,Oe,t),n(e,X,t),n(e,et,t),c(j,e,t),n(e,tt,t),n(e,z,t),n(e,lt,t),c(Y,e,t),n(e,nt,t),n(e,F,t),n(e,st,t),n(e,A,t),n(e,at,t),c(B,e,t),n(e,rt,t),n(e,q,t),n(e,it,t),c(C,e,t),n(e,pt,t),n(e,L,t),n(e,ot,t),c(N,e,t),n(e,ct,t),n(e,P,t),n(e,mt,t),n(e,S,t),n(e,ft,t),c(D,e,t),n(e,$t,t),n(e,K,t),n(e,Mt,t),c(O,e,t),n(e,ut,t),c(ee,e,t),n(e,dt,t),n(e,te,t),n(e,Tt,t),n(e,le,t),n(e,gt,t),c(ne,e,t),n(e,Jt,t),n(e,se,t),n(e,yt,t),c(ae,e,t),n(e,Ut,t),c(re,e,t),n(e,wt,t),c(v,e,t),n(e,bt,t),n(e,ie,t),n(e,ht,t),n(e,pe,t),n(e,_t,t),c(oe,e,t),n(e,jt,t),n(e,ce,t),n(e,Ct,t),c(me,e,t),n(e,vt,t),n(e,fe,t),n(e,kt,t),c($e,e,t),n(e,Rt,t),n(e,Me,t),n(e,xt,t),c(ue,e,t),n(e,Ht,t),n(e,de,t),n(e,Wt,t),n(e,Te,t),n(e,Gt,t),c(ge,e,t),n(e,It,t),n(e,Je,t),n(e,Zt,t),c(ye,e,t),n(e,Et,t),n(e,Ue,t),n(e,Qt,t),c(we,e,t),n(e,Vt,t),c(k,e,t),n(e,Xt,t),n(e,be,t),n(e,zt,t),n(e,he,t),n(e,Yt,t),c(R,e,t),n(e,Ft,t),c(_e,e,t),n(e,At,t),n(e,je,t),n(e,Bt,t),c(Ce,e,t),n(e,qt,t),c(ve,e,t),n(e,Lt,t),c(ke,e,t),n(e,Nt,t),c(Re,e,t),n(e,Pt,t),c(xe,e,t),n(e,St,t),c(He,e,t),n(e,Dt,t),c(We,e,t),n(e,Kt,t),c(Ge,e,t),n(e,Ot,t),c(Ie,e,t),n(e,el,t),c(Ze,e,t),n(e,tl,t),c(Ee,e,t),n(e,ll,t),c(Qe,e,t),n(e,nl,t),c(x,e,t),n(e,sl,t),c(Ve,e,t),n(e,al,t),n(e,Fe,t),rl=!0},p(e,[t]){const Gl={};t&1&&(Gl.fw=e[0]),w.$set(Gl);const Il={};t&2&&(Il.$$scope={dirty:t,ctx:e}),_.$set(Il);const Zl={};t&2&&(Zl.$$scope={dirty:t,ctx:e}),j.$set(Zl);const El={};t&2&&(El.$$scope={dirty:t,ctx:e}),C.$set(El);const Ql={};t&2&&(Ql.$$scope={dirty:t,ctx:e}),v.$set(Ql);const Vl={};t&2&&(Vl.$$scope={dirty:t,ctx:e}),k.$set(Vl);const Xl={};t&2&&(Xl.$$scope={dirty:t,ctx:e}),R.$set(Xl);const zl={};t&2&&(zl.$$scope={dirty:t,ctx:e}),x.$set(zl)},i(e){rl||(m(w.$$.fragment,e),m(b.$$.fragment,e),m(H.$$.fragment,e),m(W.$$.fragment,e),m(_.$$.fragment,e),m(Z.$$.fragment,e),m(E.$$.fragment,e),m(V.$$.fragment,e),m(j.$$.fragment,e),m(Y.$$.fragment,e),m(B.$$.fragment,e),m(C.$$.fragment,e),m(N.$$.fragment,e),m(D.$$.fragment,e),m(O.$$.fragment,e),m(ee.$$.fragment,e),m(ne.$$.fragment,e),m(ae.$$.fragment,e),m(re.$$.fragment,e),m(v.$$.fragment,e),m(oe.$$.fragment,e),m(me.$$.fragment,e),m($e.$$.fragment,e),m(ue.$$.fragment,e),m(ge.$$.fragment,e),m(ye.$$.fragment,e),m(we.$$.fragment,e),m(k.$$.fragment,e),m(R.$$.fragment,e),m(_e.$$.fragment,e),m(Ce.$$.fragment,e),m(ve.$$.fragment,e),m(ke.$$.fragment,e),m(Re.$$.fragment,e),m(xe.$$.fragment,e),m(He.$$.fragment,e),m(We.$$.fragment,e),m(Ge.$$.fragment,e),m(Ie.$$.fragment,e),m(Ze.$$.fragment,e),m(Ee.$$.fragment,e),m(Qe.$$.fragment,e),m(x.$$.fragment,e),m(Ve.$$.fragment,e),rl=!0)},o(e){f(w.$$.fragment,e),f(b.$$.fragment,e),f(H.$$.fragment,e),f(W.$$.fragment,e),f(_.$$.fragment,e),f(Z.$$.fragment,e),f(E.$$.fragment,e),f(V.$$.fragment,e),f(j.$$.fragment,e),f(Y.$$.fragment,e),f(B.$$.fragment,e),f(C.$$.fragment,e),f(N.$$.fragment,e),f(D.$$.fragment,e),f(O.$$.fragment,e),f(ee.$$.fragment,e),f(ne.$$.fragment,e),f(ae.$$.fragment,e),f(re.$$.fragment,e),f(v.$$.fragment,e),f(oe.$$.fragment,e),f(me.$$.fragment,e),f($e.$$.fragment,e),f(ue.$$.fragment,e),f(ge.$$.fragment,e),f(ye.$$.fragment,e),f(we.$$.fragment,e),f(k.$$.fragment,e),f(R.$$.fragment,e),f(_e.$$.fragment,e),f(Ce.$$.fragment,e),f(ve.$$.fragment,e),f(ke.$$.fragment,e),f(Re.$$.fragment,e),f(xe.$$.fragment,e),f(He.$$.fragment,e),f(We.$$.fragment,e),f(Ge.$$.fragment,e),f(Ie.$$.fragment,e),f(Ze.$$.fragment,e),f(Ee.$$.fragment,e),f(Qe.$$.fragment,e),f(x.$$.fragment,e),f(Ve.$$.fragment,e),rl=!1},d(e){e&&(l(T),l(i),l(g),l(U),l(Ae),l(Be),l(qe),l(G),l(Le),l(Ne),l(I),l(Pe),l(Se),l(De),l(Q),l(Ke),l(Oe),l(X),l(et),l(tt),l(z),l(lt),l(nt),l(F),l(st),l(A),l(at),l(rt),l(q),l(it),l(pt),l(L),l(ot),l(ct),l(P),l(mt),l(S),l(ft),l($t),l(K),l(Mt),l(ut),l(dt),l(te),l(Tt),l(le),l(gt),l(Jt),l(se),l(yt),l(Ut),l(wt),l(bt),l(ie),l(ht),l(pe),l(_t),l(jt),l(ce),l(Ct),l(vt),l(fe),l(kt),l(Rt),l(Me),l(xt),l(Ht),l(de),l(Wt),l(Te),l(Gt),l(It),l(Je),l(Zt),l(Et),l(Ue),l(Qt),l(Vt),l(Xt),l(be),l(zt),l(he),l(Yt),l(Ft),l(At),l(je),l(Bt),l(qt),l(Lt),l(Nt),l(Pt),l(St),l(Dt),l(Kt),l(Ot),l(el),l(tl),l(ll),l(nl),l(sl),l(al),l(Fe)),l(r),$(w,e),$(b,e),$(H,e),$(W,e),$(_,e),$(Z,e),$(E,e),$(V,e),$(j,e),$(Y,e),$(B,e),$(C,e),$(N,e),$(D,e),$(O,e),$(ee,e),$(ne,e),$(ae,e),$(re,e),$(v,e),$(oe,e),$(me,e),$($e,e),$(ue,e),$(ge,e),$(ye,e),$(we,e),$(k,e),$(R,e),$(_e,e),$(Ce,e),$(ve,e),$(ke,e),$(Re,e),$(xe,e),$(He,e),$(We,e),$(Ge,e),$(Ie,e),$(Ze,e),$(Ee,e),$(Qe,e),$(x,e),$(Ve,e)}}}const on='{"title":"Trainer API로 모델 미세 조정하기","local":"fine-tuning-a-model-with-the-trainer-api","sections":[{"title":"훈련","local":"training","sections":[],"depth":3},{"title":"평가","local":"evaluation","sections":[],"depth":3},{"title":"고급 훈련 기능","local":"advanced-training-features","sections":[],"depth":3},{"title":"섹션 퀴즈","local":"section-quiz","sections":[{"title":"1. Trainer 에서 <code> processing_class </code> 매개변수의 목적은 무엇인가요?","local":"1-trainer-에서-code-processingclass-code-매개변수의-목적은-무엇인가요","sections":[],"depth":3},{"title":"2. 훈련 중 평가가 얼마나 자주 발생하는지를 제어하는 TrainingArguments 매개변수는 무엇인가요?","local":"2-훈련-중-평가가-얼마나-자주-발생하는지를-제어하는-trainingarguments-매개변수는-무엇인가요","sections":[],"depth":3},{"title":"3. TrainingArguments에서 <code> fp16=True </code> 는 무엇을 활성화하나요?","local":"3-trainingarguments에서-code-fp16true-code-는-무엇을-활성화하나요","sections":[],"depth":3},{"title":"4. Trainer에서 <code> compute_metrics </code> 함수의 역할은 무엇인가요?","local":"4-trainer에서-code-computemetrics-code-함수의-역할은-무엇인가요","sections":[],"depth":3},{"title":"5. Trainer에 <code> eval_dataset </code> 을 제공하지 않으면 어떻게 되나요?","local":"5-trainer에-code-evaldataset-code-을-제공하지-않으면-어떻게-되나요","sections":[],"depth":3},{"title":"6. 그레이디언트 누적이란 무엇이며 어떻게 활성화하나요?","local":"6-그레이디언트-누적이란-무엇이며-어떻게-활성화하나요","sections":[],"depth":3}],"depth":2}],"depth":1}';function cn(J,r,T){let i="pt";return Bl(()=>{const g=new URLSearchParams(window.location.search);T(0,i=g.get("fw")||"pt")}),[i]}class yn extends ql{constructor(r){super(),Ll(this,r,cn,pn,Al,{})}}export{yn as component};
