import{s as hn,o as wn,n as Ct}from"../chunks/scheduler.f6b352c8.js";import{S as yn,i as Tn,g as o,s,r as u,A as fn,h as p,f as n,c as a,j as kt,u as r,x as d,k as Mn,y as Bt,a as l,v as c,d as M,t as h,w}from"../chunks/index.b90df637.js";import{T as Zt}from"../chunks/Tip.366d2e6e.js";import{C as Ie}from"../chunks/CodeBlock.e5718f9d.js";import{H as b,E as gn}from"../chunks/getInferenceSnippets.028474af.js";function bn(J){let i,T="This tutorial focuses on creating a production-ready script that can process any dataset and add embeddings using the <strong>Text Embeddings Inference (TEI)</strong> engine for optimized performance.";return{c(){i=o("p"),i.innerHTML=T},l(m){i=p(m,"P",{"data-svelte-h":!0}),d(i)!=="svelte-1s3ow1a"&&(i.innerHTML=T)},m(m,y){l(m,i,y)},p:Ct,d(m){m&&n(i)}}}function Jn(J){let i,T='If you’re looking for a model with less compute requirements, you can use the <a href="https://huggingface.co/sentence-transformers/all-MiniLM-L6-v2" rel="nofollow">sentence-transformers/all-MiniLM-L6-v2</a> model.';return{c(){i=o("p"),i.innerHTML=T},l(m){i=p(m,"P",{"data-svelte-h":!0}),d(i)!=="svelte-1a40r0f"&&(i.innerHTML=T)},m(m,y){l(m,i,y)},p:Ct,d(m){m&&n(i)}}}function jn(J){let i,T="The <code>datasets</code> library will pass our function a batch of examples from the dataset, as a dictionary of batch values. The key will be the name of the column we want to embed, and the value will be a list of values from that column.";return{c(){i=o("p"),i.innerHTML=T},l(m){i=p(m,"P",{"data-svelte-h":!0}),d(i)!=="svelte-ybk8oj"&&(i.innerHTML=T)},m(m,y){l(m,i,y)},p:Ct,d(m){m&&n(i)}}}function In(J){let i,T="The <code>datasets</code> library’s <code>map</code> function is optimized for performance and will automatically batch the rows for us. Inference Endpoints can also scale to meet the demand of the batch size, so to get the best performance, you should calibrate the batch size with your Inference Endpoints’s configuration.",m,y,j="For example, select the highest possible batch size for you model and synchronize the batch size with your Inference Endpoint’s configuration in <code>max_concurrent_requests</code>.";return{c(){i=o("p"),i.innerHTML=T,m=s(),y=o("p"),y.innerHTML=j},l(f){i=p(f,"P",{"data-svelte-h":!0}),d(i)!=="svelte-1sfo5v4"&&(i.innerHTML=T),m=a(f),y=p(f,"P",{"data-svelte-h":!0}),d(y)!=="svelte-1u02m5o"&&(y.innerHTML=j)},m(f,g){l(f,i,g),l(f,m,g),l(f,y,g)},p:Ct,d(f){f&&(n(i),n(m),n(y))}}}function Un(J){let i,T,m,y,j,f,g,vt='This tutorial will guide you through deploying an embedding endpoint and building a Python script to efficiently process datasets with embeddings. We’ll use the powerful <a href="https://huggingface.co/Qwen/Qwen3-Embedding-4B" rel="nofollow">Qwen/Qwen3-Embedding-4B</a> model to create high-quality embeddings for your data.',Ze,I,Ce,G,Ge,k,Wt="First, we need to create an Inference Endpoint optimized for embeddings.",ke,B,Et=`Start by navigating to the Inference Endpoints UI, and once you have logged in you should see a button for creating a new Inference
Endpoint. Click the “New” button.`,Be,v,Rt='<img src="https://raw.githubusercontent.com/huggingface/hf-endpoints-documentation/update/large-rewrite/assets/quick_start/1-new-button.png" alt="new-button"/>',ve,W,xt=`From there you’ll be directed to the catalog. The Model Catalog consists of popular models which have tuned configurations to work as one-click
deploys. You can search for embedding models or create a custom endpoint.`,We,E,_t='<img src="https://raw.githubusercontent.com/huggingface/hf-endpoints-documentation/update/large-rewrite/assets/quick_start/2-catalog.png" alt="catalog"/>',Ee,R,Vt="For this tutorial, we’ll use the Qwen3-Embedding-4B model. If it’s not in the catalog, you can create a custom endpoint by entering the model repository ID <code>Qwen/Qwen3-Embedding-4B</code>.",Re,x,Ft="For embedding models, we recommend:",xe,_,Xt="<li><strong>GPU</strong>: NVIDIA L4 or A10G for good performance</li> <li><strong>Instance Size</strong>: x1 (sufficient for most embedding workloads)</li> <li><strong>Auto-scaling</strong>: Enable scale-to-zero to save costs by switching the endpoint to a paused state when it’s not in use.</li> <li><strong>Timeout</strong>: Set a timeout of 10 minutes to avoid long-running requests. You should define a timeout based on how you expect your endpoint to be used.</li>",_e,U,Ve,V,zt="The Qwen3-Embedding-4B model will automatically use the <strong>Text Embeddings Inference (TEI)</strong> engine, which provides optimized inference and automatic batching.",Fe,F,Yt="Click “Create Endpoint” to deploy your embedding service.",Xe,X,Ht='<img src="https://raw.githubusercontent.com/huggingface/hf-endpoints-documentation/update/large-rewrite/assets/quick_start/4-config.png" alt="config"/>',ze,z,Qt="Your endpoint will take about 5 minutes to initialize.",Ye,Y,He,H,qt="Once your endpoint is running, you can test it directly in the playground. The embedding endpoint accepts text input and returns high-dimensional vectors.",Qe,Q,At='<img src="https://raw.githubusercontent.com/huggingface/hf-endpoints-documentation/embedding-tutorial/assets/tutorials/embedding/playground.png" alt="playground"/>',qe,q,St="Try entering some sample text like “Machine learning is transforming how we process data” and see the embedding output.",Ae,A,Se,S,Nt='To use your endpoint programmatically, you’ll need these details from your <a href="https://endpoints.huggingface.co/" rel="nofollow">endpoints page</a>:',Ne,N,Lt='<li><strong>Base URL</strong>: <code>https://&lt;endpoint-name&gt;.endpoints.huggingface.cloud/v1/</code></li> <li><strong>Model name</strong>: The name of your endpoint</li> <li><strong>Token</strong>: Your HF token from <a href="https://huggingface.co/settings/tokens" rel="nofollow">settings</a></li>',Le,L,Pt='<img src="https://raw.githubusercontent.com/huggingface/hf-endpoints-documentation/embedding-tutorial/assets/tutorials/chatbot/endpoint-page.png" alt="endpoint-details"/>',Pe,P,Oe,O,Ot="Now let’s build a script step by step to process datasets with embeddings. We’ll break it down into logical blocks.",Ke,K,De,D,Kt="We’ll use the OpenAI client to connect to the endpoint and the datasets library to load and process the dataset. So let’s install the required packages:",et,ee,tt,te,Dt="Then, set up your imports in a new Python file:",nt,ne,lt,le,st,se,en="Set up the configuration to connect to your Inference Endpoint based on the details you collected in the previous step.",at,ae,it,ie,tn='Your OpenAI client is now configured to connect to your Inference Endpoint. For further reading you can check out the client documentation on text embeddings <a href="https://platform.openai.com/docs/api-reference/embeddings" target="_blank" rel="noopener noreferrer">here</a>.',ot,oe,pt,pe,nn="Next, we’ll create a function to process batches of text and return embeddings.",dt,de,mt,$,ut,me,rt,ue,ln="Load your dataset and apply the embedding function:",ct,re,Mt,Z,ht,ce,wt,Me,sn="Finally, let’s save our embedded dataset locally or push it to the Hugging Face Hub:",yt,he,Tt,we,ft,ye,an="Nice work! You’ve now built an embedding pipeline that can process any dataset. Here’s the complete script:",gt,C,Ue,on="Click to view the complete script",Gt,Te,bt,fe,pn="Here are some ways to extend your script:",Jt,ge,dn="<li><strong>Process multiple datasets</strong>: Modify the script to handle different dataset sources</li> <li><strong>Add error handling</strong>: Implement retry logic for failed API calls</li> <li><strong>Optimize batch sizes</strong>: Experiment with different batch sizes for better performance</li> <li><strong>Add validation</strong>: Check embedding quality and dimensions</li> <li><strong>Custom preprocessing</strong>: Add text cleaning or normalization steps</li> <li><strong>Build a Semantic Search Application</strong>: Use the embeddings to build a semantic search application.</li>",jt,be,mn="Your embedded datasets are now ready for downstream tasks like semantic search, recommendation systems, or RAG applications!",It,Je,Ut,$e,$t;return j=new b({props:{title:"Build an embedding pipeline with datasets",local:"build-an-embedding-pipeline-with-datasets",headingTag:"h1"}}),I=new Zt({props:{$$slots:{default:[bn]},$$scope:{ctx:J}}}),G=new b({props:{title:"Create your embedding endpoint",local:"create-your-embedding-endpoint",headingTag:"h2"}}),U=new Zt({props:{$$slots:{default:[Jn]},$$scope:{ctx:J}}}),Y=new b({props:{title:"Test your endpoint",local:"test-your-endpoint",headingTag:"h2"}}),A=new b({props:{title:"Get your endpoint details",local:"get-your-endpoint-details",headingTag:"h2"}}),P=new b({props:{title:"Building the embedding script",local:"building-the-embedding-script",headingTag:"h2"}}),K=new b({props:{title:"Step 1: Set up dependencies and imports",local:"step-1-set-up-dependencies-and-imports",headingTag:"h3"}}),ee=new Ie({props:{code:"cGlwJTIwaW5zdGFsbCUyMGRhdGFzZXRzJTIwb3BlbmFp",highlighted:"pip install datasets openai",wrap:!1}}),ne=new Ie({props:{code:"aW1wb3J0JTIwb3MlMEFmcm9tJTIwZGF0YXNldHMlMjBpbXBvcnQlMjBsb2FkX2RhdGFzZXQlMEFmcm9tJTIwb3BlbmFpJTIwaW1wb3J0JTIwT3BlbkFJ",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> openai <span class="hljs-keyword">import</span> OpenAI`,wrap:!1}}),le=new b({props:{title:"Step 2: Configure the connection",local:"step-2-configure-the-connection",headingTag:"h3"}}),ae=new Ie({props:{code:"JTIzJTIwQ29uZmlndXJhdGlvbiUwQUVORFBPSU5UX1VSTCUyMCUzRCUyMCUyMmh0dHBzJTNBJTJGJTJGeW91ci1lbmRwb2ludC1uYW1lLmVuZHBvaW50cy5odWdnaW5nZmFjZS5jbG91ZCUyRnYxJTJGJTIyJTIwJTIzJTIwRW5kcG9pbnQlMjBVUkwlMjAlMkIlMjB2ZXJzaW9uJTBBSEZfVE9LRU4lMjAlM0QlMjBvcy5nZXRlbnYoJTIySEZfVE9LRU4lMjIpJTIwJTIzJTIwWW91ciUyMEh1Z2dpbmclMjBGYWNlJTIwSHViJTIwdG9rZW4lMjBmcm9tJTIwaGYuY28lMkZzZXR0aW5ncyUyRnRva2VucyUwQSUwQSUyMyUyMEluaXRpYWxpemUlMjBPcGVuQUklMjBjbGllbnQlMjBmb3IlMjB5b3VyJTIwZW5kcG9pbnQlMEFjbGllbnQlMjAlM0QlMjBPcGVuQUkoJTBBJTIwJTIwJTIwJTIwYmFzZV91cmwlM0RFTkRQT0lOVF9VUkwlMkMlMEElMjAlMjAlMjAlMjBhcGlfa2V5JTNESEZfVE9LRU4lMkMlMEEp",highlighted:`<span class="hljs-comment"># Configuration</span>
ENDPOINT_URL = <span class="hljs-string">&quot;https://your-endpoint-name.endpoints.huggingface.cloud/v1/&quot;</span> <span class="hljs-comment"># Endpoint URL + version</span>
HF_TOKEN = os.getenv(<span class="hljs-string">&quot;HF_TOKEN&quot;</span>) <span class="hljs-comment"># Your Hugging Face Hub token from hf.co/settings/tokens</span>

<span class="hljs-comment"># Initialize OpenAI client for your endpoint</span>
client = OpenAI(
    base_url=ENDPOINT_URL,
    api_key=HF_TOKEN,
)`,wrap:!1}}),oe=new b({props:{title:"Step 3: Create the embedding function",local:"step-3-create-the-embedding-function",headingTag:"h3"}}),de=new Ie({props:{code:"ZGVmJTIwZ2V0X2VtYmVkZGluZ3MoZXhhbXBsZXMpJTNBJTBBJTIwJTIwJTIwJTIwJTIyJTIyJTIyR2V0JTIwZW1iZWRkaW5ncyUyMGZvciUyMGElMjBiYXRjaCUyMG9mJTIwdGV4dHMuJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwcmVzcG9uc2UlMjAlM0QlMjBjbGllbnQuZW1iZWRkaW5ncy5jcmVhdGUoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbW9kZWwlM0QlMjJ5b3VyLWVuZHBvaW50LW5hbWUlMjIlMkMlMjAlMjAlMjMlMjBSZXBsYWNlJTIwd2l0aCUyMHlvdXIlMjBhY3R1YWwlMjBlbmRwb2ludCUyMG5hbWUlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpbnB1dCUzRGV4YW1wbGVzJTVCJTIyY29udGV4dCUyMiU1RCUyQyUyMCUyMyUyMEluJTIwdGhlJTIwc3F1YWQlMjBkYXRhc2V0JTJDJTIwdGhlJTIwdGV4dCUyMGlzJTIwaW4lMjB0aGUlMjAlMjJjb250ZXh0JTIyJTIwY29sdW1uJTBBJTIwJTIwJTIwJTIwKSUwQSUyMCUyMCUyMCUyMCUwQSUyMCUyMCUyMCUyMCUyMyUyMEV4dHJhY3QlMjBlbWJlZGRpbmdzJTIwZnJvbSUyMHJlc3BvbnNlJTIwb2JqZWN0cyUwQSUyMCUyMCUyMCUyMGVtYmVkZGluZ3MlMjAlM0QlMjAlNUJzYW1wbGUuZW1iZWRkaW5nJTIwZm9yJTIwc2FtcGxlJTIwaW4lMjByZXNwb25zZS5kYXRhJTVEJTBBJTIwJTIwJTIwJTIwJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTdCJTIyZW1iZWRkaW5ncyUyMiUzQSUyMGVtYmVkZGluZ3MlN0QlMjAlMjMlMjBkYXRhc2V0cyUyMGV4cGVjdHMlMjBhJTIwZGljdGlvbmFyeSUyMHdpdGglMjBhJTIwa2V5JTIwJTIyZW1iZWRkaW5ncyUyMiUyMGFuZCUyMGElMjB2YWx1ZSUyMG9mJTIwYSUyMGxpc3QlMjBvZiUyMGVtYmVkZGluZ3M=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_embeddings</span>(<span class="hljs-params">examples</span>):
    <span class="hljs-string">&quot;&quot;&quot;Get embeddings for a batch of texts.&quot;&quot;&quot;</span>
    response = client.embeddings.create(
        model=<span class="hljs-string">&quot;your-endpoint-name&quot;</span>,  <span class="hljs-comment"># Replace with your actual endpoint name</span>
        <span class="hljs-built_in">input</span>=examples[<span class="hljs-string">&quot;context&quot;</span>], <span class="hljs-comment"># In the squad dataset, the text is in the &quot;context&quot; column</span>
    )
    
    <span class="hljs-comment"># Extract embeddings from response objects</span>
    embeddings = [sample.embedding <span class="hljs-keyword">for</span> sample <span class="hljs-keyword">in</span> response.data]
    
    <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;embeddings&quot;</span>: embeddings} <span class="hljs-comment"># datasets expects a dictionary with a key &quot;embeddings&quot; and a value of a list of embeddings</span>`,wrap:!1}}),$=new Zt({props:{$$slots:{default:[jn]},$$scope:{ctx:J}}}),me=new b({props:{title:"Step 4: Load and process your dataset",local:"step-4-load-and-process-your-dataset",headingTag:"h3"}}),re=new Ie({props:{code:"JTIzJTIwTG9hZCUyMGElMjBzYW1wbGUlMjBkYXRhc2V0JTIwKHlvdSUyMGNhbiUyMHJlcGxhY2UlMjB0aGlzJTIwd2l0aCUyMHlvdXIlMjBvd24pJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJzcXVhZCUyMiUyQyUyMHNwbGl0JTNEJTIydHJhaW4lNUIlM0ExMDAlNUQlMjIpJTIwJTIwJTIzJTIwVXNpbmclMjBmaXJzdCUyMDEwMCUyMGV4YW1wbGVzJTIwZm9yJTIwZGVtbyUwQSUwQSUyMyUyMFByb2Nlc3MlMjB0aGUlMjBkYXRhc2V0JTIwd2l0aCUyMGVtYmVkZGluZ3MlMEFkYXRhc2V0X3dpdGhfZW1iZWRkaW5ncyUyMCUzRCUyMGRhdGFzZXQubWFwKCUwQSUyMCUyMCUyMCUyMGdldF9lbWJlZGRpbmdzJTJDJTBBJTIwJTIwJTIwJTIwYmF0Y2hlZCUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBiYXRjaF9zaXplJTNEMTAlMkMlMjAlMjAlMjMlMjBQcm9jZXNzJTIwaW4lMjBzbWFsbCUyMGJhdGNoZXMlMjB0byUyMGF2b2lkJTIwdGltZW91dHMlMEElMjAlMjAlMjAlMjBkZXNjJTNEJTIyQWRkaW5nJTIwZW1iZWRkaW5ncyUyMiUyQyUwQSk=",highlighted:`<span class="hljs-comment"># Load a sample dataset (you can replace this with your own)</span>
dataset = load_dataset(<span class="hljs-string">&quot;squad&quot;</span>, split=<span class="hljs-string">&quot;train[:100]&quot;</span>)  <span class="hljs-comment"># Using first 100 examples for demo</span>

<span class="hljs-comment"># Process the dataset with embeddings</span>
dataset_with_embeddings = dataset.<span class="hljs-built_in">map</span>(
    get_embeddings,
    batched=<span class="hljs-literal">True</span>,
    batch_size=<span class="hljs-number">10</span>,  <span class="hljs-comment"># Process in small batches to avoid timeouts</span>
    desc=<span class="hljs-string">&quot;Adding embeddings&quot;</span>,
)`,wrap:!1}}),Z=new Zt({props:{$$slots:{default:[In]},$$scope:{ctx:J}}}),ce=new b({props:{title:"Step 5: Save and Share your results",local:"step-5-save-and-share-your-results",headingTag:"h3"}}),he=new Ie({props:{code:"JTIzJTIwU2F2ZSUyMHRoZSUyMHByb2Nlc3NlZCUyMGRhdGFzZXQlMjBsb2NhbGx5JTBBZGF0YXNldF93aXRoX2VtYmVkZGluZ3Muc2F2ZV90b19kaXNrKCUyMi4lMkZlbWJlZGRlZF9kYXRhc2V0JTIyKSUwQSUwQSUyMyUyME9yJTIwcHVzaCUyMGRpcmVjdGx5JTIwdG8lMjBIdWdnaW5nJTIwRmFjZSUyMEh1YiUwQWRhdGFzZXRfd2l0aF9lbWJlZGRpbmdzLnB1c2hfdG9faHViKCUyMnlvdXItdXNlcm5hbWUlMkZzcXVhZC1lbWJlZGRpbmdzJTIyKQ==",highlighted:`<span class="hljs-comment"># Save the processed dataset locally</span>
dataset_with_embeddings.save_to_disk(<span class="hljs-string">&quot;./embedded_dataset&quot;</span>)

<span class="hljs-comment"># Or push directly to Hugging Face Hub</span>
dataset_with_embeddings.push_to_hub(<span class="hljs-string">&quot;your-username/squad-embeddings&quot;</span>)`,wrap:!1}}),we=new b({props:{title:"Next steps",local:"next-steps",headingTag:"h2"}}),Te=new Ie({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> dotenv <span class="hljs-keyword">import</span> load_dotenv
<span class="hljs-keyword">from</span> openai <span class="hljs-keyword">import</span> OpenAI

load_dotenv()

<span class="hljs-comment"># Configuration</span>
ENDPOINT_URL = <span class="hljs-string">&quot;https://your-endpoint-name.endpoints.huggingface.cloud/v1/&quot;</span>
HF_TOKEN = os.getenv(<span class="hljs-string">&quot;HF_TOKEN&quot;</span>)

<span class="hljs-comment"># Initialize OpenAI client for your endpoint</span>
client = OpenAI(
    base_url=ENDPOINT_URL,
    api_key=HF_TOKEN,
)

<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_embeddings</span>(<span class="hljs-params">examples</span>):
    <span class="hljs-string">&quot;&quot;&quot;Get embeddings for a batch of texts.&quot;&quot;&quot;</span>
    response = client.embeddings.create(
        model=<span class="hljs-string">&quot;your-endpoint-name&quot;</span>,  <span class="hljs-comment"># Replace with your actual endpoint name</span>
        <span class="hljs-built_in">input</span>=examples[<span class="hljs-string">&quot;context&quot;</span>],
    )
    
    <span class="hljs-comment"># Extract embeddings from response</span>
    embeddings = [sample.embedding <span class="hljs-keyword">for</span> sample <span class="hljs-keyword">in</span> response.data]
    
    <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;embeddings&quot;</span>: embeddings}

<span class="hljs-comment"># Load a sample dataset (you can replace this with your own)</span>
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Loading dataset...&quot;</span>)
dataset = load_dataset(<span class="hljs-string">&quot;squad&quot;</span>, split=<span class="hljs-string">&quot;train[:1000]&quot;</span>)  <span class="hljs-comment"># Using first 1000 examples for demo</span>

<span class="hljs-comment"># Process the dataset with embeddings</span>
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Processing dataset with embeddings...&quot;</span>)
dataset_with_embeddings = dataset.<span class="hljs-built_in">map</span>(
    get_embeddings,
    batched=<span class="hljs-literal">True</span>,
    batch_size=<span class="hljs-number">10</span>,  <span class="hljs-comment"># Process in small batches to avoid timeouts</span>
    desc=<span class="hljs-string">&quot;Adding embeddings&quot;</span>,
)

<span class="hljs-comment"># Save the processed dataset locally</span>
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Saving processed dataset...&quot;</span>)
dataset_with_embeddings.save_to_disk(<span class="hljs-string">&quot;./embedded_dataset&quot;</span>)

<span class="hljs-comment"># Or push directly to Hugging Face Hub</span>
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Pushing to Hugging Face Hub...&quot;</span>)
dataset_with_embeddings.push_to_hub(<span class="hljs-string">&quot;your-username/squad-embeddings&quot;</span>)

<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Dataset processing complete!&quot;</span>)`,wrap:!1}}),Je=new gn({props:{source:"https://github.com/huggingface/hf-endpoints-documentation/blob/main/docs/source/tutorials/embedding.mdx"}}),{c(){i=o("meta"),T=s(),m=o("p"),y=s(),u(j.$$.fragment),f=s(),g=o("p"),g.innerHTML=vt,Ze=s(),u(I.$$.fragment),Ce=s(),u(G.$$.fragment),Ge=s(),k=o("p"),k.textContent=Wt,ke=s(),B=o("p"),B.textContent=Et,Be=s(),v=o("p"),v.innerHTML=Rt,ve=s(),W=o("p"),W.textContent=xt,We=s(),E=o("p"),E.innerHTML=_t,Ee=s(),R=o("p"),R.innerHTML=Vt,Re=s(),x=o("p"),x.textContent=Ft,xe=s(),_=o("ul"),_.innerHTML=Xt,_e=s(),u(U.$$.fragment),Ve=s(),V=o("p"),V.innerHTML=zt,Fe=s(),F=o("p"),F.textContent=Yt,Xe=s(),X=o("p"),X.innerHTML=Ht,ze=s(),z=o("p"),z.textContent=Qt,Ye=s(),u(Y.$$.fragment),He=s(),H=o("p"),H.textContent=qt,Qe=s(),Q=o("p"),Q.innerHTML=At,qe=s(),q=o("p"),q.textContent=St,Ae=s(),u(A.$$.fragment),Se=s(),S=o("p"),S.innerHTML=Nt,Ne=s(),N=o("ul"),N.innerHTML=Lt,Le=s(),L=o("p"),L.innerHTML=Pt,Pe=s(),u(P.$$.fragment),Oe=s(),O=o("p"),O.textContent=Ot,Ke=s(),u(K.$$.fragment),De=s(),D=o("p"),D.textContent=Kt,et=s(),u(ee.$$.fragment),tt=s(),te=o("p"),te.textContent=Dt,nt=s(),u(ne.$$.fragment),lt=s(),u(le.$$.fragment),st=s(),se=o("p"),se.textContent=en,at=s(),u(ae.$$.fragment),it=s(),ie=o("p"),ie.innerHTML=tn,ot=s(),u(oe.$$.fragment),pt=s(),pe=o("p"),pe.textContent=nn,dt=s(),u(de.$$.fragment),mt=s(),u($.$$.fragment),ut=s(),u(me.$$.fragment),rt=s(),ue=o("p"),ue.textContent=ln,ct=s(),u(re.$$.fragment),Mt=s(),u(Z.$$.fragment),ht=s(),u(ce.$$.fragment),wt=s(),Me=o("p"),Me.textContent=sn,yt=s(),u(he.$$.fragment),Tt=s(),u(we.$$.fragment),ft=s(),ye=o("p"),ye.textContent=an,gt=s(),C=o("details"),Ue=o("summary"),Ue.textContent=on,Gt=s(),u(Te.$$.fragment),bt=s(),fe=o("p"),fe.textContent=pn,Jt=s(),ge=o("ul"),ge.innerHTML=dn,jt=s(),be=o("p"),be.textContent=mn,It=s(),u(Je.$$.fragment),Ut=s(),$e=o("p"),this.h()},l(e){const t=fn("svelte-u9bgzb",document.head);i=p(t,"META",{name:!0,content:!0}),t.forEach(n),T=a(e),m=p(e,"P",{}),kt(m).forEach(n),y=a(e),r(j.$$.fragment,e),f=a(e),g=p(e,"P",{"data-svelte-h":!0}),d(g)!=="svelte-y0ssck"&&(g.innerHTML=vt),Ze=a(e),r(I.$$.fragment,e),Ce=a(e),r(G.$$.fragment,e),Ge=a(e),k=p(e,"P",{"data-svelte-h":!0}),d(k)!=="svelte-qqd7zu"&&(k.textContent=Wt),ke=a(e),B=p(e,"P",{"data-svelte-h":!0}),d(B)!=="svelte-147h3qd"&&(B.textContent=Et),Be=a(e),v=p(e,"P",{"data-svelte-h":!0}),d(v)!=="svelte-rr08y1"&&(v.innerHTML=Rt),ve=a(e),W=p(e,"P",{"data-svelte-h":!0}),d(W)!=="svelte-161g95l"&&(W.textContent=xt),We=a(e),E=p(e,"P",{"data-svelte-h":!0}),d(E)!=="svelte-1fpb2w2"&&(E.innerHTML=_t),Ee=a(e),R=p(e,"P",{"data-svelte-h":!0}),d(R)!=="svelte-1hz2ysi"&&(R.innerHTML=Vt),Re=a(e),x=p(e,"P",{"data-svelte-h":!0}),d(x)!=="svelte-47pfzw"&&(x.textContent=Ft),xe=a(e),_=p(e,"UL",{"data-svelte-h":!0}),d(_)!=="svelte-plob23"&&(_.innerHTML=Xt),_e=a(e),r(U.$$.fragment,e),Ve=a(e),V=p(e,"P",{"data-svelte-h":!0}),d(V)!=="svelte-qj37e3"&&(V.innerHTML=zt),Fe=a(e),F=p(e,"P",{"data-svelte-h":!0}),d(F)!=="svelte-g3g7p9"&&(F.textContent=Yt),Xe=a(e),X=p(e,"P",{"data-svelte-h":!0}),d(X)!=="svelte-l3aysm"&&(X.innerHTML=Ht),ze=a(e),z=p(e,"P",{"data-svelte-h":!0}),d(z)!=="svelte-kjfty7"&&(z.textContent=Qt),Ye=a(e),r(Y.$$.fragment,e),He=a(e),H=p(e,"P",{"data-svelte-h":!0}),d(H)!=="svelte-232tmi"&&(H.textContent=qt),Qe=a(e),Q=p(e,"P",{"data-svelte-h":!0}),d(Q)!=="svelte-meccj2"&&(Q.innerHTML=At),qe=a(e),q=p(e,"P",{"data-svelte-h":!0}),d(q)!=="svelte-eb5krh"&&(q.textContent=St),Ae=a(e),r(A.$$.fragment,e),Se=a(e),S=p(e,"P",{"data-svelte-h":!0}),d(S)!=="svelte-edwdpu"&&(S.innerHTML=Nt),Ne=a(e),N=p(e,"UL",{"data-svelte-h":!0}),d(N)!=="svelte-1mxq0ya"&&(N.innerHTML=Lt),Le=a(e),L=p(e,"P",{"data-svelte-h":!0}),d(L)!=="svelte-gk51gv"&&(L.innerHTML=Pt),Pe=a(e),r(P.$$.fragment,e),Oe=a(e),O=p(e,"P",{"data-svelte-h":!0}),d(O)!=="svelte-1jb2qdd"&&(O.textContent=Ot),Ke=a(e),r(K.$$.fragment,e),De=a(e),D=p(e,"P",{"data-svelte-h":!0}),d(D)!=="svelte-1uq3z6b"&&(D.textContent=Kt),et=a(e),r(ee.$$.fragment,e),tt=a(e),te=p(e,"P",{"data-svelte-h":!0}),d(te)!=="svelte-16rd7fj"&&(te.textContent=Dt),nt=a(e),r(ne.$$.fragment,e),lt=a(e),r(le.$$.fragment,e),st=a(e),se=p(e,"P",{"data-svelte-h":!0}),d(se)!=="svelte-1rvx9zz"&&(se.textContent=en),at=a(e),r(ae.$$.fragment,e),it=a(e),ie=p(e,"P",{"data-svelte-h":!0}),d(ie)!=="svelte-6mzhuo"&&(ie.innerHTML=tn),ot=a(e),r(oe.$$.fragment,e),pt=a(e),pe=p(e,"P",{"data-svelte-h":!0}),d(pe)!=="svelte-103gfbk"&&(pe.textContent=nn),dt=a(e),r(de.$$.fragment,e),mt=a(e),r($.$$.fragment,e),ut=a(e),r(me.$$.fragment,e),rt=a(e),ue=p(e,"P",{"data-svelte-h":!0}),d(ue)!=="svelte-75q4le"&&(ue.textContent=ln),ct=a(e),r(re.$$.fragment,e),Mt=a(e),r(Z.$$.fragment,e),ht=a(e),r(ce.$$.fragment,e),wt=a(e),Me=p(e,"P",{"data-svelte-h":!0}),d(Me)!=="svelte-1aql2k2"&&(Me.textContent=sn),yt=a(e),r(he.$$.fragment,e),Tt=a(e),r(we.$$.fragment,e),ft=a(e),ye=p(e,"P",{"data-svelte-h":!0}),d(ye)!=="svelte-vzfm8t"&&(ye.textContent=an),gt=a(e),C=p(e,"DETAILS",{});var je=kt(C);Ue=p(je,"SUMMARY",{"data-svelte-h":!0}),d(Ue)!=="svelte-1ri4alz"&&(Ue.textContent=on),Gt=a(je),r(Te.$$.fragment,je),je.forEach(n),bt=a(e),fe=p(e,"P",{"data-svelte-h":!0}),d(fe)!=="svelte-1kuxjv9"&&(fe.textContent=pn),Jt=a(e),ge=p(e,"UL",{"data-svelte-h":!0}),d(ge)!=="svelte-1sd2to"&&(ge.innerHTML=dn),jt=a(e),be=p(e,"P",{"data-svelte-h":!0}),d(be)!=="svelte-vw83lh"&&(be.textContent=mn),It=a(e),r(Je.$$.fragment,e),Ut=a(e),$e=p(e,"P",{}),kt($e).forEach(n),this.h()},h(){Mn(i,"name","hf:doc:metadata"),Mn(i,"content",$n)},m(e,t){Bt(document.head,i),l(e,T,t),l(e,m,t),l(e,y,t),c(j,e,t),l(e,f,t),l(e,g,t),l(e,Ze,t),c(I,e,t),l(e,Ce,t),c(G,e,t),l(e,Ge,t),l(e,k,t),l(e,ke,t),l(e,B,t),l(e,Be,t),l(e,v,t),l(e,ve,t),l(e,W,t),l(e,We,t),l(e,E,t),l(e,Ee,t),l(e,R,t),l(e,Re,t),l(e,x,t),l(e,xe,t),l(e,_,t),l(e,_e,t),c(U,e,t),l(e,Ve,t),l(e,V,t),l(e,Fe,t),l(e,F,t),l(e,Xe,t),l(e,X,t),l(e,ze,t),l(e,z,t),l(e,Ye,t),c(Y,e,t),l(e,He,t),l(e,H,t),l(e,Qe,t),l(e,Q,t),l(e,qe,t),l(e,q,t),l(e,Ae,t),c(A,e,t),l(e,Se,t),l(e,S,t),l(e,Ne,t),l(e,N,t),l(e,Le,t),l(e,L,t),l(e,Pe,t),c(P,e,t),l(e,Oe,t),l(e,O,t),l(e,Ke,t),c(K,e,t),l(e,De,t),l(e,D,t),l(e,et,t),c(ee,e,t),l(e,tt,t),l(e,te,t),l(e,nt,t),c(ne,e,t),l(e,lt,t),c(le,e,t),l(e,st,t),l(e,se,t),l(e,at,t),c(ae,e,t),l(e,it,t),l(e,ie,t),l(e,ot,t),c(oe,e,t),l(e,pt,t),l(e,pe,t),l(e,dt,t),c(de,e,t),l(e,mt,t),c($,e,t),l(e,ut,t),c(me,e,t),l(e,rt,t),l(e,ue,t),l(e,ct,t),c(re,e,t),l(e,Mt,t),c(Z,e,t),l(e,ht,t),c(ce,e,t),l(e,wt,t),l(e,Me,t),l(e,yt,t),c(he,e,t),l(e,Tt,t),c(we,e,t),l(e,ft,t),l(e,ye,t),l(e,gt,t),l(e,C,t),Bt(C,Ue),Bt(C,Gt),c(Te,C,null),l(e,bt,t),l(e,fe,t),l(e,Jt,t),l(e,ge,t),l(e,jt,t),l(e,be,t),l(e,It,t),c(Je,e,t),l(e,Ut,t),l(e,$e,t),$t=!0},p(e,[t]){const je={};t&2&&(je.$$scope={dirty:t,ctx:e}),I.$set(je);const un={};t&2&&(un.$$scope={dirty:t,ctx:e}),U.$set(un);const rn={};t&2&&(rn.$$scope={dirty:t,ctx:e}),$.$set(rn);const cn={};t&2&&(cn.$$scope={dirty:t,ctx:e}),Z.$set(cn)},i(e){$t||(M(j.$$.fragment,e),M(I.$$.fragment,e),M(G.$$.fragment,e),M(U.$$.fragment,e),M(Y.$$.fragment,e),M(A.$$.fragment,e),M(P.$$.fragment,e),M(K.$$.fragment,e),M(ee.$$.fragment,e),M(ne.$$.fragment,e),M(le.$$.fragment,e),M(ae.$$.fragment,e),M(oe.$$.fragment,e),M(de.$$.fragment,e),M($.$$.fragment,e),M(me.$$.fragment,e),M(re.$$.fragment,e),M(Z.$$.fragment,e),M(ce.$$.fragment,e),M(he.$$.fragment,e),M(we.$$.fragment,e),M(Te.$$.fragment,e),M(Je.$$.fragment,e),$t=!0)},o(e){h(j.$$.fragment,e),h(I.$$.fragment,e),h(G.$$.fragment,e),h(U.$$.fragment,e),h(Y.$$.fragment,e),h(A.$$.fragment,e),h(P.$$.fragment,e),h(K.$$.fragment,e),h(ee.$$.fragment,e),h(ne.$$.fragment,e),h(le.$$.fragment,e),h(ae.$$.fragment,e),h(oe.$$.fragment,e),h(de.$$.fragment,e),h($.$$.fragment,e),h(me.$$.fragment,e),h(re.$$.fragment,e),h(Z.$$.fragment,e),h(ce.$$.fragment,e),h(he.$$.fragment,e),h(we.$$.fragment,e),h(Te.$$.fragment,e),h(Je.$$.fragment,e),$t=!1},d(e){e&&(n(T),n(m),n(y),n(f),n(g),n(Ze),n(Ce),n(Ge),n(k),n(ke),n(B),n(Be),n(v),n(ve),n(W),n(We),n(E),n(Ee),n(R),n(Re),n(x),n(xe),n(_),n(_e),n(Ve),n(V),n(Fe),n(F),n(Xe),n(X),n(ze),n(z),n(Ye),n(He),n(H),n(Qe),n(Q),n(qe),n(q),n(Ae),n(Se),n(S),n(Ne),n(N),n(Le),n(L),n(Pe),n(Oe),n(O),n(Ke),n(De),n(D),n(et),n(tt),n(te),n(nt),n(lt),n(st),n(se),n(at),n(it),n(ie),n(ot),n(pt),n(pe),n(dt),n(mt),n(ut),n(rt),n(ue),n(ct),n(Mt),n(ht),n(wt),n(Me),n(yt),n(Tt),n(ft),n(ye),n(gt),n(C),n(bt),n(fe),n(Jt),n(ge),n(jt),n(be),n(It),n(Ut),n($e)),n(i),w(j,e),w(I,e),w(G,e),w(U,e),w(Y,e),w(A,e),w(P,e),w(K,e),w(ee,e),w(ne,e),w(le,e),w(ae,e),w(oe,e),w(de,e),w($,e),w(me,e),w(re,e),w(Z,e),w(ce,e),w(he,e),w(we,e),w(Te),w(Je,e)}}}const $n='{"title":"Build an embedding pipeline with datasets","local":"build-an-embedding-pipeline-with-datasets","sections":[{"title":"Create your embedding endpoint","local":"create-your-embedding-endpoint","sections":[],"depth":2},{"title":"Test your endpoint","local":"test-your-endpoint","sections":[],"depth":2},{"title":"Get your endpoint details","local":"get-your-endpoint-details","sections":[],"depth":2},{"title":"Building the embedding script","local":"building-the-embedding-script","sections":[{"title":"Step 1: Set up dependencies and imports","local":"step-1-set-up-dependencies-and-imports","sections":[],"depth":3},{"title":"Step 2: Configure the connection","local":"step-2-configure-the-connection","sections":[],"depth":3},{"title":"Step 3: Create the embedding function","local":"step-3-create-the-embedding-function","sections":[],"depth":3},{"title":"Step 4: Load and process your dataset","local":"step-4-load-and-process-your-dataset","sections":[],"depth":3},{"title":"Step 5: Save and Share your results","local":"step-5-save-and-share-your-results","sections":[],"depth":3}],"depth":2},{"title":"Next steps","local":"next-steps","sections":[],"depth":2}],"depth":1}';function Zn(J){return wn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Wn extends yn{constructor(i){super(),Tn(this,i,Zn,Un,hn,{})}}export{Wn as component};
