import{s as Vt,n as Ft,o as St}from"../chunks/scheduler.9039eef2.js";import{S as Wt,i as At,g as n,s as l,r as m,A as Kt,h as o,f as r,c as a,j as f,u,x as d,k as z,y as t,a as s,v as c,d as _,t as h,w as g}from"../chunks/index.cdcc3d35.js";import{D as y}from"../chunks/Docstring.7c2ff2cb.js";import{H as xe}from"../chunks/Heading.96ce3702.js";function jt(gt){let w,Te,ye,we,I,Ce,q,bt="The <code>optimum.neuron.distributed</code> module provides a set of tools to perform distributed training and inference.",ke,U,Me,O,ft="The main task in distributed training / inference is being able to shard things such as the model weights, the gradient, and/or the optimizer state. We built <code>Parallelizer</code> classes to handle the sharding.",Le,N,De,V,zt="The <code>Parallelizer</code> class is the base abstract class being derived for every model supporting model parallelism. It provides methods to parallelize the model and save and load sharded checkpoints.",Ee,p,F,Re,le,vt="Base abstract class that handles model parallelism.",Xe,k,S,Ge,ae,$t=`Parallelizes the model by transforming regular layer into their parallel counterparts.
Each concrete class must implement it.`,Je,P,W,Qe,ie,xt=`Parallelizes the model by transforming regular layer into their parallel counterparts using
<code>cls._parallelize()</code>.`,Ye,ne,yt=`It also makes sure that each parameter has loaded its weights or has been initialized if there is no pre-trained
weights associated to it.`,Ze,x,A,et,oe,Pt="Creates an optimizer ready for a parallelized model from an existing optimizer.",tt,se,Tt="There are two cases:",rt,de,wt=`<li>The optimizer has been created via a lazy constructor from
<code>optimum.neuron.distributed.utils.make_optimizer_constructor_lazy</code>, it which case the exactly intended optimizer is
created for tensor parallelism.</li> <li>The optimizer was created with a regular constructor. In this case the optimizer for tensor parallelism
is created as close as possible to what was intended but that is not guaranteed.</li>`,lt,pe,K,at,me,j,He,B,Ie,R,Ct="Each model that supports parallelization in <code>optimum-neuron</code> has its own derived <code>Parallelizer</code> class. The factory class <code>ParallelizersManager</code> allows you to retrieve such model-specific <code>Parallelizer</code>s easily.",qe,v,X,it,M,G,nt,ue,kt="Provides the list of supported model types for parallelization.",ot,T,J,st,ce,Mt="Returns a tuple of 3 booleans where:",dt,_e,Lt="<li>The first element indicates if tensor parallelism can be used for this model,</li> <li>The second element indicates if sequence parallelism can be used on top of tensor parallelism for this model,</li> <li>The third element indicates if pipeline parallelism can be used for this model.</li>",pt,L,Q,mt,he,Dt="Returns the parallelizer class associated to the model.",Ue,Y,Oe,Z,Ne,ee,Et="Distributed training / inference is usually needed when the model is too big to fit in one device. Tools that allow for lazy loading of model weights and optimizer states are thus needed to avoid going out-of-memory before parallelization.",Ve,$,te,ut,ge,Ht="Context manager that makes the loading of a model lazy for model parallelism:",ct,be,It=`<li>Every <code>torch.nn.Linear</code> is put on the <code>torch.device(&quot;meta&quot;)</code> device, meaning that it takes no memory to
instantiate.</li> <li>Every <code>torch.nn.Embedding</code> is also put on the <code>torch.device(&quot;meta&quot;)</code> device.</li> <li>No state dict is actually loaded, instead a weight map is created and attached to the model. For more
information, read the <code>optimum.neuron.distributed.utils.from_pretrained_for_mp</code> docstring.</li>`,_t,fe,qt="If both <code>tensor_parallel_size</code> and <code>pipeline_parallel_size</code> are set to 1, no lazy loading is performed.",Fe,C,re,ht,ze,Ut=`Transforms an optimizer constructor (optimizer class) to make it lazy by not initializing the parameters.
This makes the optimizer lightweight and usable to create a “real” optimizer once the model has been
parallelized.`,Se,Pe,We;return I=new xe({props:{title:"Optimum Neuron Distributed",local:"optimum-neuron-distributed",headingTag:"h1"}}),U=new xe({props:{title:"Parallelization",local:"parallelization",headingTag:"h2"}}),N=new xe({props:{title:"Base Parallelizer",local:"optimum.neuron.distributed.Parallelizer",headingTag:"h3"}}),F=new y({props:{name:"class optimum.neuron.distributed.Parallelizer",anchor:"optimum.neuron.distributed.Parallelizer",parameters:[],source:"https://github.com/huggingface/optimum-neuron/blob/vr_670/optimum/neuron/distributed/base.py#L136"}}),S=new y({props:{name:"_parallelize",anchor:"optimum.neuron.distributed.Parallelizer._parallelize",parameters:[{name:"model",val:": PreTrainedModel"},{name:"device",val:": Optional = None"},{name:"parallelize_embeddings",val:": bool = True"},{name:"sequence_parallel_enabled",val:": bool = False"},{name:"should_parallelize_layer_predicate_func",val:": Optional = None"},{name:"**parallel_layer_specific_kwargs",val:""}],parametersDescription:[{anchor:"optimum.neuron.distributed.Parallelizer._parallelize.model",description:`<strong>model</strong> (<code>PreTrainedModel</code>) &#x2014;
The model to parallelize.`,name:"model"},{anchor:"optimum.neuron.distributed.Parallelizer._parallelize.device",description:`<strong>device</strong> (<code>Optional[torch.device]</code>, defaults to <code>None</code>) &#x2014;
The device where the new parallel layers should be put.`,name:"device"},{anchor:"optimum.neuron.distributed.Parallelizer._parallelize.parallelize_embeddings",description:`<strong>parallelize_embeddings</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether or not the embeddings should be parallelized.
This can be disabled in the case when the TP size does not divide the vocabulary size.`,name:"parallelize_embeddings"},{anchor:"optimum.neuron.distributed.Parallelizer._parallelize.sequence_parallel_enabled",description:`<strong>sequence_parallel_enabled</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether or not sequence parallelism is enabled.`,name:"sequence_parallel_enabled"},{anchor:"optimum.neuron.distributed.Parallelizer._parallelize.should_parallelize_layer_predicate_func",description:`<strong>should_parallelize_layer_predicate_func</strong> (Optional[Callable[[torch.nn.Module], bool]], defaults to <code>None</code>) &#x2014;
A function that takes a layer as input and returns a boolean specifying if the input layer should be
parallelized. This is useful to skip unnecessary parallelization, for pipeline parallelism for instance.`,name:"should_parallelize_layer_predicate_func"},{anchor:"optimum.neuron.distributed.Parallelizer._parallelize.*parallel_layer_specific_kwargs",description:`*<strong>*parallel_layer_specific_kwargs</strong> (<code>Dict[str, Any]</code>) &#x2014;
Keyword arguments specific to some parallel layers, they will be ignored by the other parallel layers.`,name:"*parallel_layer_specific_kwargs"}],source:"https://github.com/huggingface/optimum-neuron/blob/vr_670/optimum/neuron/distributed/base.py#L239",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The parallelized model.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>PreTrainedModel</code></p>
`}}),W=new y({props:{name:"parallelize",anchor:"optimum.neuron.distributed.Parallelizer.parallelize",parameters:[{name:"model",val:": Union"},{name:"device",val:": Optional = None"},{name:"parallelize_embeddings",val:": bool = True"},{name:"sequence_parallel_enabled",val:": bool = False"},{name:"kv_size_multiplier",val:": Optional = None"},{name:"pipeline_parallel_input_names",val:": Union = None"},{name:"pipeline_parallel_num_microbatches",val:": int = 1"},{name:"pipeline_parallel_use_zero1_optimizer",val:": bool = False"},{name:"pipeline_parallel_gradient_checkpointing_enabled",val:": bool = False"},{name:"checkpoint_dir",val:": Union = None"},{name:"num_local_ranks_per_step",val:": int = 8"}],parametersDescription:[{anchor:"optimum.neuron.distributed.Parallelizer.parallelize.model",description:`<strong>model</strong> (<code>Union[PreTrainedModel, NeuronPeftModel]</code>) &#x2014;
The model to parallelize.`,name:"model"},{anchor:"optimum.neuron.distributed.Parallelizer.parallelize.device",description:`<strong>device</strong> (<code>Optional[torch.device]</code>, defaults to <code>None</code>) &#x2014;
The device where the new parallel layers should be put.`,name:"device"},{anchor:"optimum.neuron.distributed.Parallelizer.parallelize.parallelize_embeddings",description:`<strong>parallelize_embeddings</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether or not the embeddings should be parallelized.
This can be disabled in the case when the TP size does not divide the vocabulary size.`,name:"parallelize_embeddings"},{anchor:"optimum.neuron.distributed.Parallelizer.parallelize.sequence_parallel_enabled",description:`<strong>sequence_parallel_enabled</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether or not sequence parallelism is enabled.`,name:"sequence_parallel_enabled"},{anchor:"optimum.neuron.distributed.Parallelizer.parallelize.kv_size_multiplier",description:`<strong>kv_size_multiplier</strong> (<code>Optional[int], defaults to </code>None\`) &#x2014;
The number of times to replicate the KV heads when the TP size is bigger than the number of KV heads.
If left unspecified, the smallest multiplier that makes the number of KV heads divisible by the TP size
will be used.`,name:"kv_size_multiplier"},{anchor:"optimum.neuron.distributed.Parallelizer.parallelize.pipeline_parallel_num_microbatches",description:`<strong>pipeline_parallel_num_microbatches</strong> (<code>int</code>, defaults to 1) &#x2014;
The number of microbatches used for pipeline execution.`,name:"pipeline_parallel_num_microbatches"},{anchor:"optimum.neuron.distributed.Parallelizer.parallelize.pipeline_parallel_use_zero1_optimizer",description:`<strong>pipeline_parallel_use_zero1_optimizer</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
When zero-1 optimizer is used, set this to True, so the PP model will understand that zero-1 optimizer
will handle data parallel gradient averaging.`,name:"pipeline_parallel_use_zero1_optimizer"},{anchor:"optimum.neuron.distributed.Parallelizer.parallelize.pipeline_parallel_gradient_checkpointing_enabled",description:`<strong>pipeline_parallel_gradient_checkpointing_enabled</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether or not gradient checkpointing should be enabled when doing pipeline parallelism.`,name:"pipeline_parallel_gradient_checkpointing_enabled"},{anchor:"optimum.neuron.distributed.Parallelizer.parallelize.checkpoint_dir",description:`<strong>checkpoint_dir</strong> (<code>Optional[Union[str, Path]]</code>) &#x2014;
Path to a sharded checkpoint. If specified, the checkpoint weights will be loaded to the parallelized
model.`,name:"checkpoint_dir"},{anchor:"optimum.neuron.distributed.Parallelizer.parallelize.num_local_ranks_per_step",description:`<strong>num_local_ranks_per_step</strong> (<code>int</code>, defaults to <code>8</code>) &#x2014;
Corresponds to the number of local ranks that can initialize and load the model weights at the same
time. If the value is inferior to 0, the maximum number of ranks will be used.`,name:"num_local_ranks_per_step"}],source:"https://github.com/huggingface/optimum-neuron/blob/vr_670/optimum/neuron/distributed/base.py#L500",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The parallelized model.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>PreTrainedModel</code></p>
`}}),A=new y({props:{name:"optimizer_for_mp",anchor:"optimum.neuron.distributed.Parallelizer.optimizer_for_mp",parameters:[{name:"optimizer",val:": torch.optim.Optimizer"},{name:"orig_param_to_parallel_param_on_xla",val:": Mapping"}],parametersDescription:[{anchor:"optimum.neuron.distributed.Parallelizer.optimizer_for_mp.optimizer",description:`<strong>optimizer</strong> (<code>torch.optim.Optimizer</code>) &#x2014;
The original optimizer.`,name:"optimizer"},{anchor:"optimum.neuron.distributed.Parallelizer.optimizer_for_mp.orig_param_to_parallel_param_on_xla",description:`<strong>orig_param_to_parallel_param_on_xla</strong> (<code>Mapping[int, torch.nn.Parameter]</code>) &#x2014;
A mapping (e.g. dict-like) that maps the id of a parameter in <code>optimizer</code> to the id of its
parallelized counterpart on an XLA device.`,name:"orig_param_to_parallel_param_on_xla"}],source:"https://github.com/huggingface/optimum-neuron/blob/vr_670/optimum/neuron/distributed/base.py#L911",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The tensor parallelism ready optimizer.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.optim.Optimizer</code></p>
`}}),K=new y({props:{name:"save_model_sharded_checkpoint",anchor:"optimum.neuron.distributed.Parallelizer.save_model_sharded_checkpoint",parameters:[{name:"model",val:": Union"},{name:"output_dir",val:": Union"},{name:"optimizer",val:": Optional = None"},{name:"use_xser",val:": bool = True"},{name:"async_save",val:": bool = False"},{name:"num_local_ranks_per_step",val:": int = 8"}],source:"https://github.com/huggingface/optimum-neuron/blob/vr_670/optimum/neuron/distributed/base.py#L951"}}),j=new y({props:{name:"load_model_sharded_checkpoint",anchor:"optimum.neuron.distributed.Parallelizer.load_model_sharded_checkpoint",parameters:[{name:"model",val:": PreTrainedModel"},{name:"load_dir",val:": Union"}],source:"https://github.com/huggingface/optimum-neuron/blob/vr_670/optimum/neuron/distributed/base.py#L1032"}}),B=new xe({props:{title:"Selecting Model-Specific Parallelizer Classes",local:"optimum.neuron.distributed.ParallelizersManager",headingTag:"h3"}}),X=new y({props:{name:"class optimum.neuron.distributed.ParallelizersManager",anchor:"optimum.neuron.distributed.ParallelizersManager",parameters:[],source:"https://github.com/huggingface/optimum-neuron/blob/vr_670/optimum/neuron/distributed/parallelizers_manager.py#L53"}}),G=new y({props:{name:"get_supported_model_types",anchor:"optimum.neuron.distributed.ParallelizersManager.get_supported_model_types",parameters:[],source:"https://github.com/huggingface/optimum-neuron/blob/vr_670/optimum/neuron/distributed/parallelizers_manager.py#L66"}}),J=new y({props:{name:"is_model_supported",anchor:"optimum.neuron.distributed.ParallelizersManager.is_model_supported",parameters:[{name:"model_type_or_model",val:": Union"}],parametersDescription:[{anchor:"optimum.neuron.distributed.ParallelizersManager.is_model_supported.model_type_or_model",description:`<strong>model_type_or_model</strong> (<code>Union[str, PreTrainedModel]</code>) &#x2014;
Either the model type or an instance of the model.`,name:"model_type_or_model"}],source:"https://github.com/huggingface/optimum-neuron/blob/vr_670/optimum/neuron/distributed/parallelizers_manager.py#L89"}}),Q=new y({props:{name:"parallelizer_for_model",anchor:"optimum.neuron.distributed.ParallelizersManager.parallelizer_for_model",parameters:[{name:"model_type_or_model",val:": Union"}],parametersDescription:[{anchor:"optimum.neuron.distributed.ParallelizersManager.parallelizer_for_model.model_type_or_model",description:`<strong>model_type_or_model</strong> (<code>Union[str, PreTrainedModel]</code>) &#x2014;
Either the model type or an instance of the model.`,name:"model_type_or_model"}],source:"https://github.com/huggingface/optimum-neuron/blob/vr_670/optimum/neuron/distributed/parallelizers_manager.py#L114"}}),Y=new xe({props:{title:"Utils",local:"utils",headingTag:"h2"}}),Z=new xe({props:{title:"Lazy Loading",local:"optimum.neuron.distributed.lazy_load_for_parallelism",headingTag:"h3"}}),te=new y({props:{name:"optimum.neuron.distributed.lazy_load_for_parallelism",anchor:"optimum.neuron.distributed.lazy_load_for_parallelism",parameters:[{name:"tensor_parallel_size",val:": int = 1"},{name:"pipeline_parallel_size",val:": int = 1"}],parametersDescription:[{anchor:"optimum.neuron.distributed.lazy_load_for_parallelism.tensor_parallel_size",description:`<strong>tensor_parallel_size</strong> (<code>int</code>, defaults to 1) &#x2014;
The tensor parallel size considered.`,name:"tensor_parallel_size"},{anchor:"optimum.neuron.distributed.lazy_load_for_parallelism.pipeline_parallel_size",description:`<strong>pipeline_parallel_size</strong> (<code>int</code>, defaults to 1) &#x2014;
The pipeline parallel size considered.`,name:"pipeline_parallel_size"}],source:"https://github.com/huggingface/optimum-neuron/blob/vr_670/optimum/neuron/distributed/utils.py#L1622"}}),re=new y({props:{name:"optimum.neuron.distributed.make_optimizer_constructor_lazy",anchor:"optimum.neuron.distributed.make_optimizer_constructor_lazy",parameters:[{name:"optimizer_cls",val:": Type"}],source:"https://github.com/huggingface/optimum-neuron/blob/vr_670/optimum/neuron/distributed/utils.py#L1669"}}),{c(){w=n("meta"),Te=l(),ye=n("p"),we=l(),m(I.$$.fragment),Ce=l(),q=n("p"),q.innerHTML=bt,ke=l(),m(U.$$.fragment),Me=l(),O=n("p"),O.innerHTML=ft,Le=l(),m(N.$$.fragment),De=l(),V=n("p"),V.innerHTML=zt,Ee=l(),p=n("div"),m(F.$$.fragment),Re=l(),le=n("p"),le.textContent=vt,Xe=l(),k=n("div"),m(S.$$.fragment),Ge=l(),ae=n("p"),ae.textContent=$t,Je=l(),P=n("div"),m(W.$$.fragment),Qe=l(),ie=n("p"),ie.innerHTML=xt,Ye=l(),ne=n("p"),ne.textContent=yt,Ze=l(),x=n("div"),m(A.$$.fragment),et=l(),oe=n("p"),oe.textContent=Pt,tt=l(),se=n("p"),se.textContent=Tt,rt=l(),de=n("ol"),de.innerHTML=wt,lt=l(),pe=n("div"),m(K.$$.fragment),at=l(),me=n("div"),m(j.$$.fragment),He=l(),m(B.$$.fragment),Ie=l(),R=n("p"),R.innerHTML=Ct,qe=l(),v=n("div"),m(X.$$.fragment),it=l(),M=n("div"),m(G.$$.fragment),nt=l(),ue=n("p"),ue.textContent=kt,ot=l(),T=n("div"),m(J.$$.fragment),st=l(),ce=n("p"),ce.textContent=Mt,dt=l(),_e=n("ul"),_e.innerHTML=Lt,pt=l(),L=n("div"),m(Q.$$.fragment),mt=l(),he=n("p"),he.textContent=Dt,Ue=l(),m(Y.$$.fragment),Oe=l(),m(Z.$$.fragment),Ne=l(),ee=n("p"),ee.textContent=Et,Ve=l(),$=n("div"),m(te.$$.fragment),ut=l(),ge=n("p"),ge.textContent=Ht,ct=l(),be=n("ul"),be.innerHTML=It,_t=l(),fe=n("p"),fe.innerHTML=qt,Fe=l(),C=n("div"),m(re.$$.fragment),ht=l(),ze=n("p"),ze.textContent=Ut,Se=l(),Pe=n("p"),this.h()},l(e){const i=Kt("svelte-u9bgzb",document.head);w=o(i,"META",{name:!0,content:!0}),i.forEach(r),Te=a(e),ye=o(e,"P",{}),f(ye).forEach(r),we=a(e),u(I.$$.fragment,e),Ce=a(e),q=o(e,"P",{"data-svelte-h":!0}),d(q)!=="svelte-it0u39"&&(q.innerHTML=bt),ke=a(e),u(U.$$.fragment,e),Me=a(e),O=o(e,"P",{"data-svelte-h":!0}),d(O)!=="svelte-5ss4zj"&&(O.innerHTML=ft),Le=a(e),u(N.$$.fragment,e),De=a(e),V=o(e,"P",{"data-svelte-h":!0}),d(V)!=="svelte-1bsvcro"&&(V.innerHTML=zt),Ee=a(e),p=o(e,"DIV",{class:!0});var b=f(p);u(F.$$.fragment,b),Re=a(b),le=o(b,"P",{"data-svelte-h":!0}),d(le)!=="svelte-h4ipsc"&&(le.textContent=vt),Xe=a(b),k=o(b,"DIV",{class:!0});var Ae=f(k);u(S.$$.fragment,Ae),Ge=a(Ae),ae=o(Ae,"P",{"data-svelte-h":!0}),d(ae)!=="svelte-1e0iews"&&(ae.textContent=$t),Ae.forEach(r),Je=a(b),P=o(b,"DIV",{class:!0});var ve=f(P);u(W.$$.fragment,ve),Qe=a(ve),ie=o(ve,"P",{"data-svelte-h":!0}),d(ie)!=="svelte-1ytdrar"&&(ie.innerHTML=xt),Ye=a(ve),ne=o(ve,"P",{"data-svelte-h":!0}),d(ne)!=="svelte-3oskg6"&&(ne.textContent=yt),ve.forEach(r),Ze=a(b),x=o(b,"DIV",{class:!0});var D=f(x);u(A.$$.fragment,D),et=a(D),oe=o(D,"P",{"data-svelte-h":!0}),d(oe)!=="svelte-gytsrb"&&(oe.textContent=Pt),tt=a(D),se=o(D,"P",{"data-svelte-h":!0}),d(se)!=="svelte-k6ubrx"&&(se.textContent=Tt),rt=a(D),de=o(D,"OL",{"data-svelte-h":!0}),d(de)!=="svelte-ogaf4b"&&(de.innerHTML=wt),D.forEach(r),lt=a(b),pe=o(b,"DIV",{class:!0});var Ot=f(pe);u(K.$$.fragment,Ot),Ot.forEach(r),at=a(b),me=o(b,"DIV",{class:!0});var Nt=f(me);u(j.$$.fragment,Nt),Nt.forEach(r),b.forEach(r),He=a(e),u(B.$$.fragment,e),Ie=a(e),R=o(e,"P",{"data-svelte-h":!0}),d(R)!=="svelte-1x1mrd0"&&(R.innerHTML=Ct),qe=a(e),v=o(e,"DIV",{class:!0});var E=f(v);u(X.$$.fragment,E),it=a(E),M=o(E,"DIV",{class:!0});var Ke=f(M);u(G.$$.fragment,Ke),nt=a(Ke),ue=o(Ke,"P",{"data-svelte-h":!0}),d(ue)!=="svelte-esrxt2"&&(ue.textContent=kt),Ke.forEach(r),ot=a(E),T=o(E,"DIV",{class:!0});var $e=f(T);u(J.$$.fragment,$e),st=a($e),ce=o($e,"P",{"data-svelte-h":!0}),d(ce)!=="svelte-1pefsnq"&&(ce.textContent=Mt),dt=a($e),_e=o($e,"UL",{"data-svelte-h":!0}),d(_e)!=="svelte-1dpu6ok"&&(_e.innerHTML=Lt),$e.forEach(r),pt=a(E),L=o(E,"DIV",{class:!0});var je=f(L);u(Q.$$.fragment,je),mt=a(je),he=o(je,"P",{"data-svelte-h":!0}),d(he)!=="svelte-3qe9b8"&&(he.textContent=Dt),je.forEach(r),E.forEach(r),Ue=a(e),u(Y.$$.fragment,e),Oe=a(e),u(Z.$$.fragment,e),Ne=a(e),ee=o(e,"P",{"data-svelte-h":!0}),d(ee)!=="svelte-4ddlue"&&(ee.textContent=Et),Ve=a(e),$=o(e,"DIV",{class:!0});var H=f($);u(te.$$.fragment,H),ut=a(H),ge=o(H,"P",{"data-svelte-h":!0}),d(ge)!=="svelte-bh7x4"&&(ge.textContent=Ht),ct=a(H),be=o(H,"UL",{"data-svelte-h":!0}),d(be)!=="svelte-1j7gypf"&&(be.innerHTML=It),_t=a(H),fe=o(H,"P",{"data-svelte-h":!0}),d(fe)!=="svelte-oha5tr"&&(fe.innerHTML=qt),H.forEach(r),Fe=a(e),C=o(e,"DIV",{class:!0});var Be=f(C);u(re.$$.fragment,Be),ht=a(Be),ze=o(Be,"P",{"data-svelte-h":!0}),d(ze)!=="svelte-1agud9l"&&(ze.textContent=Ut),Be.forEach(r),Se=a(e),Pe=o(e,"P",{}),f(Pe).forEach(r),this.h()},h(){z(w,"name","hf:doc:metadata"),z(w,"content",Bt),z(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),z(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),z(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),z(pe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),z(me,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),z(p,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),z(M,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),z(T,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),z(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),z(v,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),z($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),z(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,i){t(document.head,w),s(e,Te,i),s(e,ye,i),s(e,we,i),c(I,e,i),s(e,Ce,i),s(e,q,i),s(e,ke,i),c(U,e,i),s(e,Me,i),s(e,O,i),s(e,Le,i),c(N,e,i),s(e,De,i),s(e,V,i),s(e,Ee,i),s(e,p,i),c(F,p,null),t(p,Re),t(p,le),t(p,Xe),t(p,k),c(S,k,null),t(k,Ge),t(k,ae),t(p,Je),t(p,P),c(W,P,null),t(P,Qe),t(P,ie),t(P,Ye),t(P,ne),t(p,Ze),t(p,x),c(A,x,null),t(x,et),t(x,oe),t(x,tt),t(x,se),t(x,rt),t(x,de),t(p,lt),t(p,pe),c(K,pe,null),t(p,at),t(p,me),c(j,me,null),s(e,He,i),c(B,e,i),s(e,Ie,i),s(e,R,i),s(e,qe,i),s(e,v,i),c(X,v,null),t(v,it),t(v,M),c(G,M,null),t(M,nt),t(M,ue),t(v,ot),t(v,T),c(J,T,null),t(T,st),t(T,ce),t(T,dt),t(T,_e),t(v,pt),t(v,L),c(Q,L,null),t(L,mt),t(L,he),s(e,Ue,i),c(Y,e,i),s(e,Oe,i),c(Z,e,i),s(e,Ne,i),s(e,ee,i),s(e,Ve,i),s(e,$,i),c(te,$,null),t($,ut),t($,ge),t($,ct),t($,be),t($,_t),t($,fe),s(e,Fe,i),s(e,C,i),c(re,C,null),t(C,ht),t(C,ze),s(e,Se,i),s(e,Pe,i),We=!0},p:Ft,i(e){We||(_(I.$$.fragment,e),_(U.$$.fragment,e),_(N.$$.fragment,e),_(F.$$.fragment,e),_(S.$$.fragment,e),_(W.$$.fragment,e),_(A.$$.fragment,e),_(K.$$.fragment,e),_(j.$$.fragment,e),_(B.$$.fragment,e),_(X.$$.fragment,e),_(G.$$.fragment,e),_(J.$$.fragment,e),_(Q.$$.fragment,e),_(Y.$$.fragment,e),_(Z.$$.fragment,e),_(te.$$.fragment,e),_(re.$$.fragment,e),We=!0)},o(e){h(I.$$.fragment,e),h(U.$$.fragment,e),h(N.$$.fragment,e),h(F.$$.fragment,e),h(S.$$.fragment,e),h(W.$$.fragment,e),h(A.$$.fragment,e),h(K.$$.fragment,e),h(j.$$.fragment,e),h(B.$$.fragment,e),h(X.$$.fragment,e),h(G.$$.fragment,e),h(J.$$.fragment,e),h(Q.$$.fragment,e),h(Y.$$.fragment,e),h(Z.$$.fragment,e),h(te.$$.fragment,e),h(re.$$.fragment,e),We=!1},d(e){e&&(r(Te),r(ye),r(we),r(Ce),r(q),r(ke),r(Me),r(O),r(Le),r(De),r(V),r(Ee),r(p),r(He),r(Ie),r(R),r(qe),r(v),r(Ue),r(Oe),r(Ne),r(ee),r(Ve),r($),r(Fe),r(C),r(Se),r(Pe)),r(w),g(I,e),g(U,e),g(N,e),g(F),g(S),g(W),g(A),g(K),g(j),g(B,e),g(X),g(G),g(J),g(Q),g(Y,e),g(Z,e),g(te),g(re)}}}const Bt='{"title":"Optimum Neuron Distributed","local":"optimum-neuron-distributed","sections":[{"title":"Parallelization","local":"parallelization","sections":[{"title":"Base Parallelizer","local":"optimum.neuron.distributed.Parallelizer","sections":[],"depth":3},{"title":"Selecting Model-Specific Parallelizer Classes","local":"optimum.neuron.distributed.ParallelizersManager","sections":[],"depth":3}],"depth":2},{"title":"Utils","local":"utils","sections":[{"title":"Lazy Loading","local":"optimum.neuron.distributed.lazy_load_for_parallelism","sections":[],"depth":3}],"depth":2}],"depth":1}';function Rt(gt){return St(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Yt extends Wt{constructor(w){super(),At(this,w,Rt,jt,Vt,{})}}export{Yt as component};
