import{s as Tt,n as Jt,o as Ut}from"../chunks/scheduler.362310b7.js";import{S as mt,i as wt,g as o,s as n,r as p,A as ht,h as i,f as l,c as a,j as yt,u as r,x as M,k as ct,y as gt,a as s,v as u,d as y,t as c,w as T}from"../chunks/index.57dfc70d.js";import{C as te}from"../chunks/CodeBlock.d3c47f83.js";import{H as J,E as It}from"../chunks/EditOnGithub.9633c464.js";function jt(ze){let U,ne,le,ae,m,oe,w,ie,h,_e='<li><a href="#text-generation-inference-custom-api">Text Generation Inference custom API</a></li> <li><a href="#openai-messages-api">OpenAI Messages API</a><ul><li><a href="#making-a-request">Making a Request</a></li> <li><a href="#streaming">Streaming</a></li> <li><a href="#synchronous">Synchronous</a></li> <li><a href="#hugging-face-inference-endpoints">Hugging Face Inference Endpoints</a></li> <li><a href="#cloud-providers">Cloud Providers</a><ul><li><a href="#amazon-sagemaker">Amazon SageMaker</a></li> <li><a href="#google-cloud">Google Cloud</a></li></ul></li></ul></li>',Me,g,He="The HTTP API is a RESTful API that allows you to interact with the text-generation-inference component. Two endpoints are available:",pe,I,Le='<li>Text Generation Inference <a href="https://huggingface.github.io/text-generation-inference/" rel="nofollow">custom API</a></li> <li>OpenAI’s <a href="#openai-messages-api">Messages API</a></li>',re,j,ue,d,Fe='Check the <a href="https://huggingface.github.io/text-generation-inference/" rel="nofollow">API documentation</a> for more information on how to interact with the Text Generation Inference API.',ye,f,ce,C,Pe="Text Generation Inference (TGI) now supports the Messages API, which is fully compatible with the OpenAI Chat Completion API. This feature is available starting from version 1.4.0. You can use OpenAI’s client libraries or third-party libraries expecting OpenAI schema to interact with TGI’s Messages API. Below are some examples of how to utilize this compatibility.",Te,b,De="<p><strong>Note:</strong> The Messages API is supported from TGI version 1.4.0 and above. Ensure you are using a compatible version to access this feature.</p>",Je,G,Ue,B,Oe="You can make a request to TGI’s Messages API using <code>curl</code>. Here’s an example:",me,Z,we,A,he,$,Ke="You can also use OpenAI’s Python client library to make a streaming request. Here’s how:",ge,Q,Ie,q,je,S,et="If you prefer to make a synchronous request, you can do so like this:",de,x,fe,E,Ce,v,tt=`The Messages API is integrated with <a href="https://huggingface.co/inference-endpoints/dedicated" rel="nofollow">Inference Endpoints</a>.
Every endpoint that uses “Text Generation Inference” with an LLM, which has a chat template can now be used. Below is an example of how to use IE with TGI using OpenAI’s Python client library:`,be,W,lt="<p><strong>Note:</strong> Make sure to replace <code>base_url</code> with your endpoint URL and to include <code>v1/</code> at the end of the URL. The <code>api_key</code> should be replaced with your Hugging Face API key.</p>",Ge,k,Be,V,Ze,Y,st="TGI can be deployed on various cloud providers for scalable and robust text generation. Among those cloud providers, both Amazon Sagemaker and Google Cloud have TGI integrations within their cloud offering.",Ae,N,$e,X,nt="To enable the Messages API in Amazon SageMaker you need to set the environment variable <code>MESSAGES_API_ENABLED=true</code>.",Qe,R,at="This will modify the <code>/invocations</code> route to accept Messages dictionaries consisting out of role and content. See the example below on how to deploy Llama with the new Messages API.",qe,z,Se,_,xe,H,ot="A collection of publicly available Deep Learning Containers (DLCs) are available for TGI on Google Cloud for services such as Google Kubernetes Engine (GKE), Vertex AI or Cloud Run.",Ee,L,it="The TGI DLCs are built with the <code>--features google</code> flag as well as including the Google SDK installation, in order to better coexist within the Google Cloud environment, whilst being seamlessly integrated with Vertex AI supporting the custom I/O formatting.",ve,F,Mt='The DLCs are publicly available on the <a href="https://cloud.google.com/deep-learning-containers/docs/choosing-container#text-generation-inference" rel="nofollow">Google Cloud Deep Learning Containers Documentation for TGI</a>, the <a href="https://console.cloud.google.com/artifacts/docker/deeplearning-platform-release/us/gcr.io" rel="nofollow">Google Cloud Artifact Registry</a> or use the <code>gcloud</code> command to list the available containers with the tag <code>huggingface-text-generation-inference</code> as follows:',We,P,ke,D,pt="The containers can be used within any Google Cloud service, you can find some examples below:",Ve,O,rt='<li><a href="https://github.com/huggingface/Google-Cloud-Containers/tree/main/examples/gke/tgi-deployment" rel="nofollow">Deploy Meta Llama 3 8B with TGI DLC on GKE</a></li> <li><a href="https://github.com/huggingface/Google-Cloud-Containers/blob/main/examples/vertex-ai/notebooks/deploy-gemma-on-vertex-ai/vertex-notebook.ipynb" rel="nofollow">Deploy Gemma 7B with TGI DLC on Vertex AI</a></li> <li><a href="https://github.com/huggingface/Google-Cloud-Containers/tree/main/examples/cloud-run/tgi-deployment" rel="nofollow">Deploy Meta Llama 3.1 8B with TGI DLC on Cloud Run</a></li>',Ye,K,ut='More information and examples available in <a href="https://github.com/huggingface/Google-Cloud-Containers" rel="nofollow">the Google-Cloud-Containers repository</a>.',Ne,ee,Xe,se,Re;return m=new J({props:{title:"HTTP API Reference",local:"http-api-reference",headingTag:"h1"}}),w=new J({props:{title:"Table of Contents",local:"table-of-contents",headingTag:"h4"}}),j=new J({props:{title:"Text Generation Inference custom API",local:"text-generation-inference-custom-api",headingTag:"h2"}}),f=new J({props:{title:"OpenAI Messages API",local:"openai-messages-api",headingTag:"h2"}}),G=new J({props:{title:"Making a Request",local:"making-a-request",headingTag:"h2"}}),Z=new te({props:{code:"Y3VybCUyMGxvY2FsaG9zdCUzQTMwMDAlMkZ2MSUyRmNoYXQlMkZjb21wbGV0aW9ucyUyMCU1QyUwQSUyMCUyMCUyMCUyMC1YJTIwUE9TVCUyMCU1QyUwQSUyMCUyMCUyMCUyMC1kJTIwJyU3QiUwQSUyMCUyMCUyMm1vZGVsJTIyJTNBJTIwJTIydGdpJTIyJTJDJTBBJTIwJTIwJTIybWVzc2FnZXMlMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJyb2xlJTIyJTNBJTIwJTIyc3lzdGVtJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMllvdSUyMGFyZSUyMGElMjBoZWxwZnVsJTIwYXNzaXN0YW50LiUyMiUwQSUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMldoYXQlMjBpcyUyMGRlZXAlMjBsZWFybmluZyUzRiUyMiUwQSUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCU1RCUyQyUwQSUyMCUyMCUyMnN0cmVhbSUyMiUzQSUyMHRydWUlMkMlMEElMjAlMjAlMjJtYXhfdG9rZW5zJTIyJTNBJTIwMjAlMEElN0QnJTIwJTVDJTBBJTIwJTIwJTIwJTIwLUglMjAnQ29udGVudC1UeXBlJTNBJTIwYXBwbGljYXRpb24lMkZqc29uJw==",highlighted:`curl localhost:3000/v1/chat/completions \\
    -X POST \\
    -d <span class="hljs-string">&#x27;{
  &quot;model&quot;: &quot;tgi&quot;,
  &quot;messages&quot;: [
    {
      &quot;role&quot;: &quot;system&quot;,
      &quot;content&quot;: &quot;You are a helpful assistant.&quot;
    },
    {
      &quot;role&quot;: &quot;user&quot;,
      &quot;content&quot;: &quot;What is deep learning?&quot;
    }
  ],
  &quot;stream&quot;: true,
  &quot;max_tokens&quot;: 20
}&#x27;</span> \\
    -H <span class="hljs-string">&#x27;Content-Type: application/json&#x27;</span>`,wrap:!1}}),A=new J({props:{title:"Streaming",local:"streaming",headingTag:"h2"}}),Q=new te({props:{code:"ZnJvbSUyMG9wZW5haSUyMGltcG9ydCUyME9wZW5BSSUwQSUwQSUyMyUyMGluaXQlMjB0aGUlMjBjbGllbnQlMjBidXQlMjBwb2ludCUyMGl0JTIwdG8lMjBUR0klMEFjbGllbnQlMjAlM0QlMjBPcGVuQUkoJTBBJTIwJTIwJTIwJTIwYmFzZV91cmwlM0QlMjJodHRwJTNBJTJGJTJGbG9jYWxob3N0JTNBMzAwMCUyRnYxJTIyJTJDJTBBJTIwJTIwJTIwJTIwYXBpX2tleSUzRCUyMi0lMjIlMEEpJTBBJTBBY2hhdF9jb21wbGV0aW9uJTIwJTNEJTIwY2xpZW50LmNoYXQuY29tcGxldGlvbnMuY3JlYXRlKCUwQSUyMCUyMCUyMCUyMG1vZGVsJTNEJTIydGdpJTIyJTJDJTBBJTIwJTIwJTIwJTIwbWVzc2FnZXMlM0QlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIyc3lzdGVtJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMllvdSUyMGFyZSUyMGElMjBoZWxwZnVsJTIwYXNzaXN0YW50LiUyMiUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMldoYXQlMjBpcyUyMGRlZXAlMjBsZWFybmluZyUzRiUyMiU3RCUwQSUyMCUyMCUyMCUyMCU1RCUyQyUwQSUyMCUyMCUyMCUyMHN0cmVhbSUzRFRydWUlMEEpJTBBJTBBJTIzJTIwaXRlcmF0ZSUyMGFuZCUyMHByaW50JTIwc3RyZWFtJTBBZm9yJTIwbWVzc2FnZSUyMGluJTIwY2hhdF9jb21wbGV0aW9uJTNBJTBBJTIwJTIwJTIwJTIwcHJpbnQobWVzc2FnZSk=",highlighted:`<span class="hljs-keyword">from</span> openai <span class="hljs-keyword">import</span> OpenAI

<span class="hljs-comment"># init the client but point it to TGI</span>
client = OpenAI(
    base_url=<span class="hljs-string">&quot;http://localhost:3000/v1&quot;</span>,
    api_key=<span class="hljs-string">&quot;-&quot;</span>
)

chat_completion = client.chat.completions.create(
    model=<span class="hljs-string">&quot;tgi&quot;</span>,
    messages=[
        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;You are a helpful assistant.&quot;</span> },
        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What is deep learning?&quot;</span>}
    ],
    stream=<span class="hljs-literal">True</span>
)

<span class="hljs-comment"># iterate and print stream</span>
<span class="hljs-keyword">for</span> message <span class="hljs-keyword">in</span> chat_completion:
    <span class="hljs-built_in">print</span>(message)`,wrap:!1}}),q=new J({props:{title:"Synchronous",local:"synchronous",headingTag:"h2"}}),x=new te({props:{code:"ZnJvbSUyMG9wZW5haSUyMGltcG9ydCUyME9wZW5BSSUwQSUwQSUyMyUyMGluaXQlMjB0aGUlMjBjbGllbnQlMjBidXQlMjBwb2ludCUyMGl0JTIwdG8lMjBUR0klMEFjbGllbnQlMjAlM0QlMjBPcGVuQUkoJTBBJTIwJTIwJTIwJTIwYmFzZV91cmwlM0QlMjJodHRwJTNBJTJGJTJGbG9jYWxob3N0JTNBMzAwMCUyRnYxJTIyJTJDJTBBJTIwJTIwJTIwJTIwYXBpX2tleSUzRCUyMi0lMjIlMEEpJTBBJTBBY2hhdF9jb21wbGV0aW9uJTIwJTNEJTIwY2xpZW50LmNoYXQuY29tcGxldGlvbnMuY3JlYXRlKCUwQSUyMCUyMCUyMCUyMG1vZGVsJTNEJTIydGdpJTIyJTJDJTBBJTIwJTIwJTIwJTIwbWVzc2FnZXMlM0QlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIyc3lzdGVtJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMllvdSUyMGFyZSUyMGElMjBoZWxwZnVsJTIwYXNzaXN0YW50LiUyMiUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMldoYXQlMjBpcyUyMGRlZXAlMjBsZWFybmluZyUzRiUyMiU3RCUwQSUyMCUyMCUyMCUyMCU1RCUyQyUwQSUyMCUyMCUyMCUyMHN0cmVhbSUzREZhbHNlJTBBKSUwQSUwQXByaW50KGNoYXRfY29tcGxldGlvbik=",highlighted:`<span class="hljs-keyword">from</span> openai <span class="hljs-keyword">import</span> OpenAI

<span class="hljs-comment"># init the client but point it to TGI</span>
client = OpenAI(
    base_url=<span class="hljs-string">&quot;http://localhost:3000/v1&quot;</span>,
    api_key=<span class="hljs-string">&quot;-&quot;</span>
)

chat_completion = client.chat.completions.create(
    model=<span class="hljs-string">&quot;tgi&quot;</span>,
    messages=[
        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;You are a helpful assistant.&quot;</span> },
        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What is deep learning?&quot;</span>}
    ],
    stream=<span class="hljs-literal">False</span>
)

<span class="hljs-built_in">print</span>(chat_completion)`,wrap:!1}}),E=new J({props:{title:"Hugging Face Inference Endpoints",local:"hugging-face-inference-endpoints",headingTag:"h2"}}),k=new te({props:{code:"ZnJvbSUyMG9wZW5haSUyMGltcG9ydCUyME9wZW5BSSUwQSUwQSUyMyUyMGluaXQlMjB0aGUlMjBjbGllbnQlMjBidXQlMjBwb2ludCUyMGl0JTIwdG8lMjBUR0klMEFjbGllbnQlMjAlM0QlMjBPcGVuQUkoJTBBJTIwJTIwJTIwJTIwJTIzJTIwcmVwbGFjZSUyMHdpdGglMjB5b3VyJTIwZW5kcG9pbnQlMjB1cmwlMkMlMjBtYWtlJTIwc3VyZSUyMHRvJTIwaW5jbHVkZSUyMCUyMnYxJTJGJTIyJTIwYXQlMjB0aGUlMjBlbmQlMEElMjAlMjAlMjAlMjBiYXNlX3VybCUzRCUyMmh0dHBzJTNBJTJGJTJGdmx6ejEwZXEzZm9sMzQyOS51cy1lYXN0LTEuYXdzLmVuZHBvaW50cy5odWdnaW5nZmFjZS5jbG91ZCUyRnYxJTJGJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIzJTIwcmVwbGFjZSUyMHdpdGglMjB5b3VyJTIwQVBJJTIwa2V5JTBBJTIwJTIwJTIwJTIwYXBpX2tleSUzRCUyMmhmX1hYWCUyMiUwQSklMEElMEFjaGF0X2NvbXBsZXRpb24lMjAlM0QlMjBjbGllbnQuY2hhdC5jb21wbGV0aW9ucy5jcmVhdGUoJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0QlMjJ0Z2klMjIlMkMlMEElMjAlMjAlMjAlMjBtZXNzYWdlcyUzRCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJzeXN0ZW0lMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyWW91JTIwYXJlJTIwYSUyMGhlbHBmdWwlMjBhc3Npc3RhbnQuJTIyJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyV2hhdCUyMGlzJTIwZGVlcCUyMGxlYXJuaW5nJTNGJTIyJTdEJTBBJTIwJTIwJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIwJTIwc3RyZWFtJTNEVHJ1ZSUwQSklMEElMEElMjMlMjBpdGVyYXRlJTIwYW5kJTIwcHJpbnQlMjBzdHJlYW0lMEFmb3IlMjBtZXNzYWdlJTIwaW4lMjBjaGF0X2NvbXBsZXRpb24lM0ElMEElMjAlMjAlMjAlMjBwcmludChtZXNzYWdlLmNob2ljZXMlNUIwJTVELmRlbHRhLmNvbnRlbnQlMkMlMjBlbmQlM0QlMjIlMjIp",highlighted:`<span class="hljs-keyword">from</span> openai <span class="hljs-keyword">import</span> OpenAI

<span class="hljs-comment"># init the client but point it to TGI</span>
client = OpenAI(
    <span class="hljs-comment"># replace with your endpoint url, make sure to include &quot;v1/&quot; at the end</span>
    base_url=<span class="hljs-string">&quot;https://vlzz10eq3fol3429.us-east-1.aws.endpoints.huggingface.cloud/v1/&quot;</span>,
    <span class="hljs-comment"># replace with your API key</span>
    api_key=<span class="hljs-string">&quot;hf_XXX&quot;</span>
)

chat_completion = client.chat.completions.create(
    model=<span class="hljs-string">&quot;tgi&quot;</span>,
    messages=[
        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;You are a helpful assistant.&quot;</span> },
        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What is deep learning?&quot;</span>}
    ],
    stream=<span class="hljs-literal">True</span>
)

<span class="hljs-comment"># iterate and print stream</span>
<span class="hljs-keyword">for</span> message <span class="hljs-keyword">in</span> chat_completion:
    <span class="hljs-built_in">print</span>(message.choices[<span class="hljs-number">0</span>].delta.content, end=<span class="hljs-string">&quot;&quot;</span>)`,wrap:!1}}),V=new J({props:{title:"Cloud Providers",local:"cloud-providers",headingTag:"h2"}}),N=new J({props:{title:"Amazon SageMaker",local:"amazon-sagemaker",headingTag:"h3"}}),z=new te({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> json
<span class="hljs-keyword">import</span> sagemaker
<span class="hljs-keyword">import</span> boto3
<span class="hljs-keyword">from</span> sagemaker.huggingface <span class="hljs-keyword">import</span> HuggingFaceModel, get_huggingface_llm_image_uri

<span class="hljs-keyword">try</span>:
    role = sagemaker.get_execution_role()
<span class="hljs-keyword">except</span> ValueError:
    iam = boto3.client(<span class="hljs-string">&#x27;iam&#x27;</span>)
    role = iam.get_role(RoleName=<span class="hljs-string">&#x27;sagemaker_execution_role&#x27;</span>)[<span class="hljs-string">&#x27;Role&#x27;</span>][<span class="hljs-string">&#x27;Arn&#x27;</span>]

<span class="hljs-comment"># Hub Model configuration. https://huggingface.co/models</span>
hub = {
    <span class="hljs-string">&#x27;HF_MODEL_ID&#x27;</span>:<span class="hljs-string">&#x27;HuggingFaceH4/zephyr-7b-beta&#x27;</span>,
    <span class="hljs-string">&#x27;SM_NUM_GPUS&#x27;</span>: json.dumps(<span class="hljs-number">1</span>),
    <span class="hljs-string">&#x27;MESSAGES_API_ENABLED&#x27;</span>: <span class="hljs-literal">True</span>
}

<span class="hljs-comment"># create Hugging Face Model Class</span>
huggingface_model = HuggingFaceModel(
    image_uri=get_huggingface_llm_image_uri(<span class="hljs-string">&quot;huggingface&quot;</span>,version=<span class="hljs-string">&quot;1.4.0&quot;</span>),
    env=hub,
    role=role,
)

<span class="hljs-comment"># deploy model to SageMaker Inference</span>
predictor = huggingface_model.deploy(
    initial_instance_count=<span class="hljs-number">1</span>,
    instance_type=<span class="hljs-string">&quot;ml.g5.2xlarge&quot;</span>,
    container_startup_health_check_timeout=<span class="hljs-number">300</span>,
)

<span class="hljs-comment"># send request</span>
predictor.predict({
    <span class="hljs-string">&quot;messages&quot;</span>: [
        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;You are a helpful assistant.&quot;</span> },
        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What is deep learning?&quot;</span>}
    ]
})`,wrap:!1}}),_=new J({props:{title:"Google Cloud",local:"google-cloud",headingTag:"h3"}}),P=new te({props:{code:"Z2Nsb3VkJTIwY29udGFpbmVyJTIwaW1hZ2VzJTIwbGlzdCUyMC0tcmVwb3NpdG9yeSUzRCUyMnVzLWRvY2tlci5wa2cuZGV2JTJGZGVlcGxlYXJuaW5nLXBsYXRmb3JtLXJlbGVhc2UlMkZnY3IuaW8lMjIlMjAlN0MlMjBncmVwJTIwJTIyaHVnZ2luZ2ZhY2UtdGV4dC1nZW5lcmF0aW9uLWluZmVyZW5jZSUyMg==",highlighted:'gcloud container images list --repository=<span class="hljs-string">&quot;us-docker.pkg.dev/deeplearning-platform-release/gcr.io&quot;</span> | grep <span class="hljs-string">&quot;huggingface-text-generation-inference&quot;</span>',wrap:!1}}),ee=new It({props:{source:"https://github.com/huggingface/text-generation-inference/blob/main/docs/source/reference/api_reference.md"}}),{c(){U=o("meta"),ne=n(),le=o("p"),ae=n(),p(m.$$.fragment),oe=n(),p(w.$$.fragment),ie=n(),h=o("ul"),h.innerHTML=_e,Me=n(),g=o("p"),g.textContent=He,pe=n(),I=o("ul"),I.innerHTML=Le,re=n(),p(j.$$.fragment),ue=n(),d=o("p"),d.innerHTML=Fe,ye=n(),p(f.$$.fragment),ce=n(),C=o("p"),C.textContent=Pe,Te=n(),b=o("blockquote"),b.innerHTML=De,Je=n(),p(G.$$.fragment),Ue=n(),B=o("p"),B.innerHTML=Oe,me=n(),p(Z.$$.fragment),we=n(),p(A.$$.fragment),he=n(),$=o("p"),$.textContent=Ke,ge=n(),p(Q.$$.fragment),Ie=n(),p(q.$$.fragment),je=n(),S=o("p"),S.textContent=et,de=n(),p(x.$$.fragment),fe=n(),p(E.$$.fragment),Ce=n(),v=o("p"),v.innerHTML=tt,be=n(),W=o("blockquote"),W.innerHTML=lt,Ge=n(),p(k.$$.fragment),Be=n(),p(V.$$.fragment),Ze=n(),Y=o("p"),Y.textContent=st,Ae=n(),p(N.$$.fragment),$e=n(),X=o("p"),X.innerHTML=nt,Qe=n(),R=o("p"),R.innerHTML=at,qe=n(),p(z.$$.fragment),Se=n(),p(_.$$.fragment),xe=n(),H=o("p"),H.textContent=ot,Ee=n(),L=o("p"),L.innerHTML=it,ve=n(),F=o("p"),F.innerHTML=Mt,We=n(),p(P.$$.fragment),ke=n(),D=o("p"),D.textContent=pt,Ve=n(),O=o("ul"),O.innerHTML=rt,Ye=n(),K=o("p"),K.innerHTML=ut,Ne=n(),p(ee.$$.fragment),Xe=n(),se=o("p"),this.h()},l(e){const t=ht("svelte-u9bgzb",document.head);U=i(t,"META",{name:!0,content:!0}),t.forEach(l),ne=a(e),le=i(e,"P",{}),yt(le).forEach(l),ae=a(e),r(m.$$.fragment,e),oe=a(e),r(w.$$.fragment,e),ie=a(e),h=i(e,"UL",{"data-svelte-h":!0}),M(h)!=="svelte-17gxrtn"&&(h.innerHTML=_e),Me=a(e),g=i(e,"P",{"data-svelte-h":!0}),M(g)!=="svelte-342cv9"&&(g.textContent=He),pe=a(e),I=i(e,"UL",{"data-svelte-h":!0}),M(I)!=="svelte-z81dww"&&(I.innerHTML=Le),re=a(e),r(j.$$.fragment,e),ue=a(e),d=i(e,"P",{"data-svelte-h":!0}),M(d)!=="svelte-hezjaf"&&(d.innerHTML=Fe),ye=a(e),r(f.$$.fragment,e),ce=a(e),C=i(e,"P",{"data-svelte-h":!0}),M(C)!=="svelte-1npf6uj"&&(C.textContent=Pe),Te=a(e),b=i(e,"BLOCKQUOTE",{"data-svelte-h":!0}),M(b)!=="svelte-d3rfkz"&&(b.innerHTML=De),Je=a(e),r(G.$$.fragment,e),Ue=a(e),B=i(e,"P",{"data-svelte-h":!0}),M(B)!=="svelte-1w70cim"&&(B.innerHTML=Oe),me=a(e),r(Z.$$.fragment,e),we=a(e),r(A.$$.fragment,e),he=a(e),$=i(e,"P",{"data-svelte-h":!0}),M($)!=="svelte-1g3ypvi"&&($.textContent=Ke),ge=a(e),r(Q.$$.fragment,e),Ie=a(e),r(q.$$.fragment,e),je=a(e),S=i(e,"P",{"data-svelte-h":!0}),M(S)!=="svelte-1xyk36t"&&(S.textContent=et),de=a(e),r(x.$$.fragment,e),fe=a(e),r(E.$$.fragment,e),Ce=a(e),v=i(e,"P",{"data-svelte-h":!0}),M(v)!=="svelte-1xit2od"&&(v.innerHTML=tt),be=a(e),W=i(e,"BLOCKQUOTE",{"data-svelte-h":!0}),M(W)!=="svelte-1ga4y2y"&&(W.innerHTML=lt),Ge=a(e),r(k.$$.fragment,e),Be=a(e),r(V.$$.fragment,e),Ze=a(e),Y=i(e,"P",{"data-svelte-h":!0}),M(Y)!=="svelte-uioute"&&(Y.textContent=st),Ae=a(e),r(N.$$.fragment,e),$e=a(e),X=i(e,"P",{"data-svelte-h":!0}),M(X)!=="svelte-zm7msf"&&(X.innerHTML=nt),Qe=a(e),R=i(e,"P",{"data-svelte-h":!0}),M(R)!=="svelte-16ty57w"&&(R.innerHTML=at),qe=a(e),r(z.$$.fragment,e),Se=a(e),r(_.$$.fragment,e),xe=a(e),H=i(e,"P",{"data-svelte-h":!0}),M(H)!=="svelte-jr5iwd"&&(H.textContent=ot),Ee=a(e),L=i(e,"P",{"data-svelte-h":!0}),M(L)!=="svelte-ecnwiy"&&(L.innerHTML=it),ve=a(e),F=i(e,"P",{"data-svelte-h":!0}),M(F)!=="svelte-1qoh84o"&&(F.innerHTML=Mt),We=a(e),r(P.$$.fragment,e),ke=a(e),D=i(e,"P",{"data-svelte-h":!0}),M(D)!=="svelte-pd96y9"&&(D.textContent=pt),Ve=a(e),O=i(e,"UL",{"data-svelte-h":!0}),M(O)!=="svelte-1ankw9g"&&(O.innerHTML=rt),Ye=a(e),K=i(e,"P",{"data-svelte-h":!0}),M(K)!=="svelte-192ousg"&&(K.innerHTML=ut),Ne=a(e),r(ee.$$.fragment,e),Xe=a(e),se=i(e,"P",{}),yt(se).forEach(l),this.h()},h(){ct(U,"name","hf:doc:metadata"),ct(U,"content",dt)},m(e,t){gt(document.head,U),s(e,ne,t),s(e,le,t),s(e,ae,t),u(m,e,t),s(e,oe,t),u(w,e,t),s(e,ie,t),s(e,h,t),s(e,Me,t),s(e,g,t),s(e,pe,t),s(e,I,t),s(e,re,t),u(j,e,t),s(e,ue,t),s(e,d,t),s(e,ye,t),u(f,e,t),s(e,ce,t),s(e,C,t),s(e,Te,t),s(e,b,t),s(e,Je,t),u(G,e,t),s(e,Ue,t),s(e,B,t),s(e,me,t),u(Z,e,t),s(e,we,t),u(A,e,t),s(e,he,t),s(e,$,t),s(e,ge,t),u(Q,e,t),s(e,Ie,t),u(q,e,t),s(e,je,t),s(e,S,t),s(e,de,t),u(x,e,t),s(e,fe,t),u(E,e,t),s(e,Ce,t),s(e,v,t),s(e,be,t),s(e,W,t),s(e,Ge,t),u(k,e,t),s(e,Be,t),u(V,e,t),s(e,Ze,t),s(e,Y,t),s(e,Ae,t),u(N,e,t),s(e,$e,t),s(e,X,t),s(e,Qe,t),s(e,R,t),s(e,qe,t),u(z,e,t),s(e,Se,t),u(_,e,t),s(e,xe,t),s(e,H,t),s(e,Ee,t),s(e,L,t),s(e,ve,t),s(e,F,t),s(e,We,t),u(P,e,t),s(e,ke,t),s(e,D,t),s(e,Ve,t),s(e,O,t),s(e,Ye,t),s(e,K,t),s(e,Ne,t),u(ee,e,t),s(e,Xe,t),s(e,se,t),Re=!0},p:Jt,i(e){Re||(y(m.$$.fragment,e),y(w.$$.fragment,e),y(j.$$.fragment,e),y(f.$$.fragment,e),y(G.$$.fragment,e),y(Z.$$.fragment,e),y(A.$$.fragment,e),y(Q.$$.fragment,e),y(q.$$.fragment,e),y(x.$$.fragment,e),y(E.$$.fragment,e),y(k.$$.fragment,e),y(V.$$.fragment,e),y(N.$$.fragment,e),y(z.$$.fragment,e),y(_.$$.fragment,e),y(P.$$.fragment,e),y(ee.$$.fragment,e),Re=!0)},o(e){c(m.$$.fragment,e),c(w.$$.fragment,e),c(j.$$.fragment,e),c(f.$$.fragment,e),c(G.$$.fragment,e),c(Z.$$.fragment,e),c(A.$$.fragment,e),c(Q.$$.fragment,e),c(q.$$.fragment,e),c(x.$$.fragment,e),c(E.$$.fragment,e),c(k.$$.fragment,e),c(V.$$.fragment,e),c(N.$$.fragment,e),c(z.$$.fragment,e),c(_.$$.fragment,e),c(P.$$.fragment,e),c(ee.$$.fragment,e),Re=!1},d(e){e&&(l(ne),l(le),l(ae),l(oe),l(ie),l(h),l(Me),l(g),l(pe),l(I),l(re),l(ue),l(d),l(ye),l(ce),l(C),l(Te),l(b),l(Je),l(Ue),l(B),l(me),l(we),l(he),l($),l(ge),l(Ie),l(je),l(S),l(de),l(fe),l(Ce),l(v),l(be),l(W),l(Ge),l(Be),l(Ze),l(Y),l(Ae),l($e),l(X),l(Qe),l(R),l(qe),l(Se),l(xe),l(H),l(Ee),l(L),l(ve),l(F),l(We),l(ke),l(D),l(Ve),l(O),l(Ye),l(K),l(Ne),l(Xe),l(se)),l(U),T(m,e),T(w,e),T(j,e),T(f,e),T(G,e),T(Z,e),T(A,e),T(Q,e),T(q,e),T(x,e),T(E,e),T(k,e),T(V,e),T(N,e),T(z,e),T(_,e),T(P,e),T(ee,e)}}}const dt='{"title":"HTTP API Reference","local":"http-api-reference","sections":[{"title":"Table of Contents","local":"table-of-contents","sections":[],"depth":4},{"title":"Text Generation Inference custom API","local":"text-generation-inference-custom-api","sections":[],"depth":2},{"title":"OpenAI Messages API","local":"openai-messages-api","sections":[],"depth":2},{"title":"Making a Request","local":"making-a-request","sections":[],"depth":2},{"title":"Streaming","local":"streaming","sections":[],"depth":2},{"title":"Synchronous","local":"synchronous","sections":[],"depth":2},{"title":"Hugging Face Inference Endpoints","local":"hugging-face-inference-endpoints","sections":[],"depth":2},{"title":"Cloud Providers","local":"cloud-providers","sections":[{"title":"Amazon SageMaker","local":"amazon-sagemaker","sections":[],"depth":3},{"title":"Google Cloud","local":"google-cloud","sections":[],"depth":3}],"depth":2}],"depth":1}';function ft(ze){return Ut(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Zt extends mt{constructor(U){super(),wt(this,U,ft,jt,Tt,{})}}export{Zt as component};
