import{s as aa,n as ta,o as oa}from"../chunks/scheduler.71ff668b.js";import{S as sa,i as la,g as n,s,r as i,A as na,h as m,f as t,c as l,j as Ke,u as p,x as r,k as ea,y as ma,a as o,v as d,d as c,t as f,w as u}from"../chunks/index.e0973da1.js";import{C as Ge}from"../chunks/CodeBlock.0c9622a3.js";import{C as ra}from"../chunks/CourseFloatingBanner.69eb4e28.js";import{H as T,E as ia}from"../chunks/getInferenceSnippets.25cce923.js";function pa(Ae){let M,O,Y,K,J,ee,b,ae,w,Ee="LoRA tornou-se o método PEFT mais amplamente adotado. Ele funciona adicionando pequenas matrizes de decomposição de classificação aos pesos de atenção, reduzindo tipicamente os parâmetros treináveis em cerca de 90%.",te,y,oe,g,Le='LoRA (Adaptação de Baixa Classificação) é uma técnica de ajuste fino eficiente em termos de parâmetros que congela os pesos do modelo pré-treinado e injeta matrizes treináveis de decomposição de classificação nas camadas do modelo. Em vez de treinar todos os parâmetros do modelo durante o ajuste fino, o LoRA decompõe as atualizações de peso em matrizes menores por meio da decomposição de baixa classificação, reduzindo significativamente o número de parâmetros treináveis enquanto mantém o desempenho do modelo. Por exemplo, quando aplicado ao GPT-3 175B, o LoRA reduziu os parâmetros treináveis em 10.000x e os requisitos de memória GPU em 3x em comparação ao ajuste fino completo. Você pode saber mais sobre o LoRA no <a href="https://arxiv.org/pdf/2106.09685" rel="nofollow">Artigo sobre LoRA</a>.',se,h,We="O LoRA funciona adicionando pares de matrizes de decomposição de classificação às camadas do transformer, geralmente focando nos pesos de atenção. Durante a inferência, esses pesos adaptadores podem ser mesclados com o modelo base, resultando em nenhuma sobrecarga adicional de latência. LoRA é particularmente útil para adaptar modelos de linguagem de grande porte a tarefas ou domínios específicos, mantendo os requisitos de recursos gerenciáveis.",le,v,ne,$,xe="Os adaptadores podem ser carregados em um modelo pré-treinado com load_adapter(), o que é útil para experimentar diferentes adaptadores cujos pesos não estão mesclados. Defina os pesos do adaptador ativo com a função set_adapter(). Para retornar ao modelo base, você pode usar unload() para descarregar todos os módulos LoRA. Isso facilita a alternância entre pesos específicos de tarefas.",me,j,re,Z,Ve='<img src="./images/lora_adapter.png" alt="lora_load_adapter"/>',ie,I,pe,U,Fe="Após o treinamento com LoRA, você pode querer mesclar os pesos do adaptador de volta ao modelo base para facilitar a implantação. Isso cria um único modelo com os pesos combinados, eliminando a necessidade de carregar adaptadores separadamente durante a inferência.",de,C,qe="processo de mesclagem requer atenção ao gerenciamento de memória e precisão. Como será necessário carregar o modelo base e os pesos do adaptador simultaneamente, garanta memória suficiente na GPU/CPU. Usar <code>device_map=&quot;auto&quot;</code> no <code>transformers</code> ajudará no gerenciamento automático de memória. Mantenha uma precisão consistente (por exemplo, float16) durante todo o processo, correspondendo à precisão usada durante o treinamento e salvando o modelo mesclado no mesmo formato para implantação. Antes de implantar, sempre valide o modelo mesclado comparando suas saídas e métricas de desempenho com a versão baseada em adaptadores.",ce,_,Xe="Os adaptadores também são convenientes para alternar entre diferentes tarefas ou domínios. Você pode carregar o modelo base e os pesos do adaptador separadamente, permitindo alternâncias rápidas entre pesos específicos de tarefas.",fe,B,ue,R,ze="O diretório <code>notebooks/</code> contém tutoriais práticos e exercícios para implementar diferentes métodos PEFT. Comece com <code>load_lora_adapter_example.ipynb</code> para uma introdução básica e depois veja <code>lora_finetuning.ipynb</code> para um estudo mais detalhado sobre como ajustar um modelo com LoRA e SFT.",Te,k,Pe="Ao implementar métodos PEFT, comece com valores baixos de classificação (4-8) para LoRA e monitore a perda de treinamento. Use conjuntos de validação para evitar overfitting e compare os resultados com as linhas de base de ajuste fino completo sempre que possível. A eficácia de diferentes métodos pode variar conforme a tarefa, então a experimentação é essencial.",Me,G,Je,A,He='<a href="https://arxiv.org/abs/2406.01775" rel="nofollow">OLoRA</a> utiliza decomposição QR para inicializar os adaptadores LoRA. OLoRA traduz os pesos base do modelo por um fator de suas decomposições QR, ou seja, altera os pesos antes de realizar qualquer treinamento sobre eles. Essa abordagem melhora significativamente a estabilidade, acelera a velocidade de convergência e, por fim, alcança um desempenho superior.',be,E,we,L,Ne="Os métodos PEFT podem ser combinados com TRL (Reinforcement Learning com Transformers) para ajuste fino eficiente. Essa integração é particularmente útil para RLHF (Reinforcement Learning from Human Feedback), pois reduz os requisitos de memória.",ye,W,ge,x,Qe="No exemplo acima, usamos <code>device_map=&quot;auto&quot;</code> para atribuir automaticamente o modelo ao dispositivo correto. Você também pode atribuir manualmente o modelo a um dispositivo específico usando <code>device_map={&quot;&quot;: device_index}</code>. Também é possível escalar o treinamento em várias GPUs enquanto mantém o uso de memória eficiente.",he,V,ve,F,Se="Após treinar um adaptador LoRA, você pode mesclar os pesos do adaptador de volta ao modelo base. Veja como fazer isso:",$e,q,je,X,Ye="Se você encontrar discrepâncias de tamanho no modelo salvo, garanta que está salvando também o tokenizador:",Ze,z,Ie,P,Ue,H,De=`⏩ Prossiga para o guia de <a href="prompt_tuning.md">Ajuste de Prompts</a> para aprender como ajustar um modelo com ajuste de prompts.
⏩ Veja o <a href="../../../notebooks/pt-br/3_parameter_efficient_finetuning/load_lora_adapter.ipynb">Tutorial de Carregamento de Adaptadores LoRA</a> para aprender como carregar adaptadores LoRA.`,Ce,N,_e,Q,Oe='<li><a href="https://arxiv.org/pdf/2106.09685" rel="nofollow">LORA: LOW-RANK ADAPTATION OF LARGE LANGUAGE MODELS</a></li> <li><a href="https://huggingface.co/docs/peft" rel="nofollow">Documentação PEFT</a></li> <li><a href="https://huggingface.co/blog/peft" rel="nofollow">Blog do Hugging Face sobre PEFT</a></li>',Be,S,Re,D,ke;return J=new T({props:{title:"LoRA (Low-Rank Adaptation - Adaptação de Baixa Classificação)",local:"lora-low-rank-adaptation---adaptação-de-baixa-classificação",headingTag:"h1"}}),b=new ra({props:{chapter:10,classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/smol-course/blob/main/notebooks/pt-br/3_parameter_efficient_finetuning/finetune_sft_peft.ipynb"}]}}),y=new T({props:{title:"Entendendo o LoRA",local:"entendendo-o-lora",headingTag:"h2"}}),v=new T({props:{title:"Carregando Adaptadores LoRA",local:"carregando-adaptadores-lora",headingTag:"h2"}}),j=new Ge({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBQZWZ0TW9kZWwlMEElMEFiYXNlX21vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMiUzQ2Jhc2VfbW9kZWxfbmFtZSUzRSUyMiklMEFwZWZ0X21vZGVsX2lkJTIwJTNEJTIwJTIyJTNDcGVmdF9hZGFwdGVyX2lkJTNFJTIyJTBBbW9kZWwlMjAlM0QlMjBQZWZ0TW9kZWwuZnJvbV9wcmV0cmFpbmVkKGJhc2VfbW9kZWwlMkMlMjBwZWZ0X21vZGVsX2lkKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftModel

base_model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;&lt;base_model_name&gt;&quot;</span>)
peft_model_id = <span class="hljs-string">&quot;&lt;peft_adapter_id&gt;&quot;</span>
model = PeftModel.from_pretrained(base_model, peft_model_id)`,wrap:!1}}),I=new T({props:{title:"Mesclando Adaptadores LoRA",local:"mesclando-adaptadores-lora",headingTag:"h2"}}),B=new T({props:{title:"Guia de Implementação",local:"guia-de-implementação",headingTag:"h2"}}),G=new T({props:{title:"OLoRA",local:"olora",headingTag:"h2"}}),E=new T({props:{title:"Usando TRL com PEFT",local:"usando-trl-com-peft",headingTag:"h2"}}),W=new Ge({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBJTBBJTIzJTIwTG9hZCUyMG1vZGVsJTIwd2l0aCUyMFBFRlQlMjBjb25maWclMEFsb3JhX2NvbmZpZyUyMCUzRCUyMExvcmFDb25maWcoJTBBJTIwJTIwJTIwJTIwciUzRDE2JTJDJTBBJTIwJTIwJTIwJTIwbG9yYV9hbHBoYSUzRDMyJTJDJTBBJTIwJTIwJTIwJTIwbG9yYV9kcm9wb3V0JTNEMC4wNSUyQyUwQSUyMCUyMCUyMCUyMGJpYXMlM0QlMjJub25lJTIyJTJDJTBBJTIwJTIwJTIwJTIwdGFza190eXBlJTNEJTIyQ0FVU0FMX0xNJTIyJTBBKSUwQSUwQSUyMyUyMExvYWQlMjBtb2RlbCUyMG9uJTIwc3BlY2lmaWMlMjBkZXZpY2UlMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJ5b3VyLW1vZGVsLW5hbWUlMjIlMkMlMEElMjAlMjAlMjAlMjBsb2FkX2luXzhiaXQlM0RUcnVlJTJDJTIwJTIwJTIzJTIwT3B0aW9uYWwlM0ElMjB1c2UlMjA4LWJpdCUyMHByZWNpc2lvbiUwQSUyMCUyMCUyMCUyMGRldmljZV9tYXAlM0QlMjJhdXRvJTIyJTJDJTBBJTIwJTIwJTIwJTIwcGVmdF9jb25maWclM0Rsb3JhX2NvbmZpZyUwQSk=",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM

<span class="hljs-comment"># Load model with PEFT config</span>
lora_config = LoraConfig(
    r=<span class="hljs-number">16</span>,
    lora_alpha=<span class="hljs-number">32</span>,
    lora_dropout=<span class="hljs-number">0.05</span>,
    bias=<span class="hljs-string">&quot;none&quot;</span>,
    task_type=<span class="hljs-string">&quot;CAUSAL_LM&quot;</span>
)

<span class="hljs-comment"># Load model on specific device</span>
model = AutoModelForCausalLM.from_pretrained(
    <span class="hljs-string">&quot;your-model-name&quot;</span>,
    load_in_8bit=<span class="hljs-literal">True</span>,  <span class="hljs-comment"># Optional: use 8-bit precision</span>
    device_map=<span class="hljs-string">&quot;auto&quot;</span>,
    peft_config=lora_config
)`,wrap:!1}}),V=new T({props:{title:"Implementação Básica de Mesclagem",local:"implementação-básica-de-mesclagem",headingTag:"h2"}}),q=new Ge({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0lMEFmcm9tJTIwcGVmdCUyMGltcG9ydCUyMFBlZnRNb2RlbCUwQSUwQSUyMyUyMDEuJTIwTG9hZCUyMHRoZSUyMGJhc2UlMjBtb2RlbCUwQWJhc2VfbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyYmFzZV9tb2RlbF9uYW1lJTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBJTIwJTIwJTIwJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIlMEEpJTBBJTBBJTIzJTIwMi4lMjBMb2FkJTIwdGhlJTIwUEVGVCUyMG1vZGVsJTIwd2l0aCUyMGFkYXB0ZXIlMEFwZWZ0X21vZGVsJTIwJTNEJTIwUGVmdE1vZGVsLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjBiYXNlX21vZGVsJTJDJTBBJTIwJTIwJTIwJTIwJTIycGF0aCUyRnRvJTJGYWRhcHRlciUyMiUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUwQSklMEElMEElMjMlMjAzLiUyME1lcmdlJTIwYWRhcHRlciUyMHdlaWdodHMlMjB3aXRoJTIwYmFzZSUyMG1vZGVsJTBBdHJ5JTNBJTBBJTIwJTIwJTIwJTIwbWVyZ2VkX21vZGVsJTIwJTNEJTIwcGVmdF9tb2RlbC5tZXJnZV9hbmRfdW5sb2FkKCklMEFleGNlcHQlMjBSdW50aW1lRXJyb3IlMjBhcyUyMGUlM0ElMEElMjAlMjAlMjAlMjBwcmludChmJTIyTWVyZ2luZyUyMGZhaWxlZCUzQSUyMCU3QmUlN0QlMjIpJTBBJTIwJTIwJTIwJTIwJTIzJTIwSW1wbGVtZW50JTIwZmFsbGJhY2slMjBzdHJhdGVneSUyMG9yJTIwbWVtb3J5JTIwb3B0aW1pemF0aW9uJTBBJTBBJTIzJTIwNC4lMjBTYXZlJTIwdGhlJTIwbWVyZ2VkJTIwbW9kZWwlMEFtZXJnZWRfbW9kZWwuc2F2ZV9wcmV0cmFpbmVkKCUyMnBhdGglMkZ0byUyRnNhdmUlMkZtZXJnZWRfbW9kZWwlMjIp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftModel

<span class="hljs-comment"># 1. Load the base model</span>
base_model = AutoModelForCausalLM.from_pretrained(
    <span class="hljs-string">&quot;base_model_name&quot;</span>,
    torch_dtype=torch.float16,
    device_map=<span class="hljs-string">&quot;auto&quot;</span>
)

<span class="hljs-comment"># 2. Load the PEFT model with adapter</span>
peft_model = PeftModel.from_pretrained(
    base_model,
    <span class="hljs-string">&quot;path/to/adapter&quot;</span>,
    torch_dtype=torch.float16
)

<span class="hljs-comment"># 3. Merge adapter weights with base model</span>
<span class="hljs-keyword">try</span>:
    merged_model = peft_model.merge_and_unload()
<span class="hljs-keyword">except</span> RuntimeError <span class="hljs-keyword">as</span> e:
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Merging failed: <span class="hljs-subst">{e}</span>&quot;</span>)
    <span class="hljs-comment"># Implement fallback strategy or memory optimization</span>

<span class="hljs-comment"># 4. Save the merged model</span>
merged_model.save_pretrained(<span class="hljs-string">&quot;path/to/save/merged_model&quot;</span>)`,wrap:!1}}),z=new Ge({props:{code:"JTIzJTIwU2F2ZSUyMGJvdGglMjBtb2RlbCUyMGFuZCUyMHRva2VuaXplciUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmJhc2VfbW9kZWxfbmFtZSUyMiklMEFtZXJnZWRfbW9kZWwuc2F2ZV9wcmV0cmFpbmVkKCUyMnBhdGglMkZ0byUyRnNhdmUlMkZtZXJnZWRfbW9kZWwlMjIpJTBBdG9rZW5pemVyLnNhdmVfcHJldHJhaW5lZCglMjJwYXRoJTJGdG8lMkZzYXZlJTJGbWVyZ2VkX21vZGVsJTIyKQ==",highlighted:`<span class="hljs-comment"># Save both model and tokenizer</span>
tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;base_model_name&quot;</span>)
merged_model.save_pretrained(<span class="hljs-string">&quot;path/to/save/merged_model&quot;</span>)
tokenizer.save_pretrained(<span class="hljs-string">&quot;path/to/save/merged_model&quot;</span>)`,wrap:!1}}),P=new T({props:{title:"Próximos Passos",local:"próximos-passos",headingTag:"h2"}}),N=new T({props:{title:"Referências",local:"referências",headingTag:"h1"}}),S=new ia({props:{source:"https://github.com/huggingface/smol-course/blob/main/units/pt-br/unit3/2.md"}}),{c(){M=n("meta"),O=s(),Y=n("p"),K=s(),i(J.$$.fragment),ee=s(),i(b.$$.fragment),ae=s(),w=n("p"),w.textContent=Ee,te=s(),i(y.$$.fragment),oe=s(),g=n("p"),g.innerHTML=Le,se=s(),h=n("p"),h.textContent=We,le=s(),i(v.$$.fragment),ne=s(),$=n("p"),$.textContent=xe,me=s(),i(j.$$.fragment),re=s(),Z=n("p"),Z.innerHTML=Ve,ie=s(),i(I.$$.fragment),pe=s(),U=n("p"),U.textContent=Fe,de=s(),C=n("p"),C.innerHTML=qe,ce=s(),_=n("p"),_.textContent=Xe,fe=s(),i(B.$$.fragment),ue=s(),R=n("p"),R.innerHTML=ze,Te=s(),k=n("p"),k.textContent=Pe,Me=s(),i(G.$$.fragment),Je=s(),A=n("p"),A.innerHTML=He,be=s(),i(E.$$.fragment),we=s(),L=n("p"),L.textContent=Ne,ye=s(),i(W.$$.fragment),ge=s(),x=n("p"),x.innerHTML=Qe,he=s(),i(V.$$.fragment),ve=s(),F=n("p"),F.textContent=Se,$e=s(),i(q.$$.fragment),je=s(),X=n("p"),X.textContent=Ye,Ze=s(),i(z.$$.fragment),Ie=s(),i(P.$$.fragment),Ue=s(),H=n("p"),H.innerHTML=De,Ce=s(),i(N.$$.fragment),_e=s(),Q=n("ul"),Q.innerHTML=Oe,Be=s(),i(S.$$.fragment),Re=s(),D=n("p"),this.h()},l(e){const a=na("svelte-u9bgzb",document.head);M=m(a,"META",{name:!0,content:!0}),a.forEach(t),O=l(e),Y=m(e,"P",{}),Ke(Y).forEach(t),K=l(e),p(J.$$.fragment,e),ee=l(e),p(b.$$.fragment,e),ae=l(e),w=m(e,"P",{"data-svelte-h":!0}),r(w)!=="svelte-1j0cls"&&(w.textContent=Ee),te=l(e),p(y.$$.fragment,e),oe=l(e),g=m(e,"P",{"data-svelte-h":!0}),r(g)!=="svelte-1wm7von"&&(g.innerHTML=Le),se=l(e),h=m(e,"P",{"data-svelte-h":!0}),r(h)!=="svelte-cc348a"&&(h.textContent=We),le=l(e),p(v.$$.fragment,e),ne=l(e),$=m(e,"P",{"data-svelte-h":!0}),r($)!=="svelte-npzgp"&&($.textContent=xe),me=l(e),p(j.$$.fragment,e),re=l(e),Z=m(e,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-1ljdidi"&&(Z.innerHTML=Ve),ie=l(e),p(I.$$.fragment,e),pe=l(e),U=m(e,"P",{"data-svelte-h":!0}),r(U)!=="svelte-1ncmddm"&&(U.textContent=Fe),de=l(e),C=m(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-in0vn5"&&(C.innerHTML=qe),ce=l(e),_=m(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-1qul9p0"&&(_.textContent=Xe),fe=l(e),p(B.$$.fragment,e),ue=l(e),R=m(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-k1gf2d"&&(R.innerHTML=ze),Te=l(e),k=m(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-181rkz4"&&(k.textContent=Pe),Me=l(e),p(G.$$.fragment,e),Je=l(e),A=m(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-1afvuqu"&&(A.innerHTML=He),be=l(e),p(E.$$.fragment,e),we=l(e),L=m(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-lm98ej"&&(L.textContent=Ne),ye=l(e),p(W.$$.fragment,e),ge=l(e),x=m(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-nzqjes"&&(x.innerHTML=Qe),he=l(e),p(V.$$.fragment,e),ve=l(e),F=m(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-1frqq8g"&&(F.textContent=Se),$e=l(e),p(q.$$.fragment,e),je=l(e),X=m(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-16ts8b0"&&(X.textContent=Ye),Ze=l(e),p(z.$$.fragment,e),Ie=l(e),p(P.$$.fragment,e),Ue=l(e),H=m(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-dxnq4n"&&(H.innerHTML=De),Ce=l(e),p(N.$$.fragment,e),_e=l(e),Q=m(e,"UL",{"data-svelte-h":!0}),r(Q)!=="svelte-1ve2fpe"&&(Q.innerHTML=Oe),Be=l(e),p(S.$$.fragment,e),Re=l(e),D=m(e,"P",{}),Ke(D).forEach(t),this.h()},h(){ea(M,"name","hf:doc:metadata"),ea(M,"content",da)},m(e,a){ma(document.head,M),o(e,O,a),o(e,Y,a),o(e,K,a),d(J,e,a),o(e,ee,a),d(b,e,a),o(e,ae,a),o(e,w,a),o(e,te,a),d(y,e,a),o(e,oe,a),o(e,g,a),o(e,se,a),o(e,h,a),o(e,le,a),d(v,e,a),o(e,ne,a),o(e,$,a),o(e,me,a),d(j,e,a),o(e,re,a),o(e,Z,a),o(e,ie,a),d(I,e,a),o(e,pe,a),o(e,U,a),o(e,de,a),o(e,C,a),o(e,ce,a),o(e,_,a),o(e,fe,a),d(B,e,a),o(e,ue,a),o(e,R,a),o(e,Te,a),o(e,k,a),o(e,Me,a),d(G,e,a),o(e,Je,a),o(e,A,a),o(e,be,a),d(E,e,a),o(e,we,a),o(e,L,a),o(e,ye,a),d(W,e,a),o(e,ge,a),o(e,x,a),o(e,he,a),d(V,e,a),o(e,ve,a),o(e,F,a),o(e,$e,a),d(q,e,a),o(e,je,a),o(e,X,a),o(e,Ze,a),d(z,e,a),o(e,Ie,a),d(P,e,a),o(e,Ue,a),o(e,H,a),o(e,Ce,a),d(N,e,a),o(e,_e,a),o(e,Q,a),o(e,Be,a),d(S,e,a),o(e,Re,a),o(e,D,a),ke=!0},p:ta,i(e){ke||(c(J.$$.fragment,e),c(b.$$.fragment,e),c(y.$$.fragment,e),c(v.$$.fragment,e),c(j.$$.fragment,e),c(I.$$.fragment,e),c(B.$$.fragment,e),c(G.$$.fragment,e),c(E.$$.fragment,e),c(W.$$.fragment,e),c(V.$$.fragment,e),c(q.$$.fragment,e),c(z.$$.fragment,e),c(P.$$.fragment,e),c(N.$$.fragment,e),c(S.$$.fragment,e),ke=!0)},o(e){f(J.$$.fragment,e),f(b.$$.fragment,e),f(y.$$.fragment,e),f(v.$$.fragment,e),f(j.$$.fragment,e),f(I.$$.fragment,e),f(B.$$.fragment,e),f(G.$$.fragment,e),f(E.$$.fragment,e),f(W.$$.fragment,e),f(V.$$.fragment,e),f(q.$$.fragment,e),f(z.$$.fragment,e),f(P.$$.fragment,e),f(N.$$.fragment,e),f(S.$$.fragment,e),ke=!1},d(e){e&&(t(O),t(Y),t(K),t(ee),t(ae),t(w),t(te),t(oe),t(g),t(se),t(h),t(le),t(ne),t($),t(me),t(re),t(Z),t(ie),t(pe),t(U),t(de),t(C),t(ce),t(_),t(fe),t(ue),t(R),t(Te),t(k),t(Me),t(Je),t(A),t(be),t(we),t(L),t(ye),t(ge),t(x),t(he),t(ve),t(F),t($e),t(je),t(X),t(Ze),t(Ie),t(Ue),t(H),t(Ce),t(_e),t(Q),t(Be),t(Re),t(D)),t(M),u(J,e),u(b,e),u(y,e),u(v,e),u(j,e),u(I,e),u(B,e),u(G,e),u(E,e),u(W,e),u(V,e),u(q,e),u(z,e),u(P,e),u(N,e),u(S,e)}}}const da='{"title":"LoRA (Low-Rank Adaptation - Adaptação de Baixa Classificação)","local":"lora-low-rank-adaptation---adaptação-de-baixa-classificação","sections":[{"title":"Entendendo o LoRA","local":"entendendo-o-lora","sections":[],"depth":2},{"title":"Carregando Adaptadores LoRA","local":"carregando-adaptadores-lora","sections":[],"depth":2},{"title":"Mesclando Adaptadores LoRA","local":"mesclando-adaptadores-lora","sections":[],"depth":2},{"title":"Guia de Implementação","local":"guia-de-implementação","sections":[],"depth":2},{"title":"OLoRA","local":"olora","sections":[],"depth":2},{"title":"Usando TRL com PEFT","local":"usando-trl-com-peft","sections":[],"depth":2},{"title":"Implementação Básica de Mesclagem","local":"implementação-básica-de-mesclagem","sections":[],"depth":2},{"title":"Próximos Passos","local":"próximos-passos","sections":[],"depth":2}],"depth":1}';function ca(Ae){return oa(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ba extends sa{constructor(M){super(),la(this,M,ca,pa,aa,{})}}export{ba as component};
