import{s as zl,o as Hl}from"../chunks/scheduler.b8dd6794.js";import{S as Vl,i as Nl,g as M,s as a,r as m,A as Yl,h as p,f as e,c as n,j as Xl,u as r,x as i,k as il,y as El,a as s,v as j,d as y,t as u,w as c,m as Ql,n as ql}from"../chunks/index.0a3e3d78.js";import{T as Fl}from"../chunks/Tip.defab0c2.js";import{C as J}from"../chunks/CodeBlock.822b8cc6.js";import{H as pl,E as Sl}from"../chunks/EditOnGithub.065de0ac.js";function Ll(yt){let o;return{c(){o=Ql("💡 리샘플링에 대한 배경 정보: 만약 오디오 신호가 8 kHz로 샘플링 되었다면(즉, 초당 8000개의 샘플이 있다면) 4 kHz보다 높은 주파수는 없음을 알 수 있습니다. 나이퀴스트 샘플링 정리(Nyquist sampling theorem)에 의해서 말이죠. 이 덕분에 우린 샘플링 지점들간의 원래의 연속적인 신호는 항상 부드러운 커브임을 확신할 수 있는 것입니다. 더 높은 샘플링 속도로의 업샘플링은 이 커브를 근사하여 기존 점들 사이의 값을 찾아내면 됩니다. 그러나 다운샘플링 같은 경우, 새로운 샘플을 결정하기전에 새로운 나이퀴스트 한계보다 높은 주파수를 먼저 걸러내는 작업이 필요할 겁니다. 다시 말해, 2배의 다운샘플링 같은 경우 이에 맞춰 단순히 샘플들을 버리는 것으로는 왜곡이 생길 수 있습니다. 이 왜곡을 alias라고 합니다. 이렇듯 리샘플링을 올바르게 하기란 꽤 까다로우므로 librosa나 🤗 Datasets같은 잘 테스트된 라이브러리를 쓰는편이 낫습니다.")},l(T){o=ql(T,"💡 리샘플링에 대한 배경 정보: 만약 오디오 신호가 8 kHz로 샘플링 되었다면(즉, 초당 8000개의 샘플이 있다면) 4 kHz보다 높은 주파수는 없음을 알 수 있습니다. 나이퀴스트 샘플링 정리(Nyquist sampling theorem)에 의해서 말이죠. 이 덕분에 우린 샘플링 지점들간의 원래의 연속적인 신호는 항상 부드러운 커브임을 확신할 수 있는 것입니다. 더 높은 샘플링 속도로의 업샘플링은 이 커브를 근사하여 기존 점들 사이의 값을 찾아내면 됩니다. 그러나 다운샘플링 같은 경우, 새로운 샘플을 결정하기전에 새로운 나이퀴스트 한계보다 높은 주파수를 먼저 걸러내는 작업이 필요할 겁니다. 다시 말해, 2배의 다운샘플링 같은 경우 이에 맞춰 단순히 샘플들을 버리는 것으로는 왜곡이 생길 수 있습니다. 이 왜곡을 alias라고 합니다. 이렇듯 리샘플링을 올바르게 하기란 꽤 까다로우므로 librosa나 🤗 Datasets같은 잘 테스트된 라이브러리를 쓰는편이 낫습니다.")},m(T,d){s(T,o,d)},d(T){T&&e(o)}}}function Dl(yt){let o,T,d,ut,w,ct,h,ml="🤗 Datasets을 이용하여 데이터셋을 불러오는건 재미의 반에 불과합니다. 모델을 학습시키거나 추론(inference)을 실행하기 위해선 먼저 데이터를 전처리해야할 것입니다. 일반적으로 이는 다음의 단계를 거칩니다:",ot,C,rl="<li>오디오 데이터 리샘플링</li> <li>데이터셋 필터링</li> <li>오디오 데이터를 모델의 입력에 맞게 변환</li>",Jt,I,Tt,A,jl="<code>load_dataset</code> 함수는 오디오 데이터를 게시된(published) 샘플링 속도에 맞춰 다운로드합니다. 이 샘플링 속도는 여러분이 계획한 학습 혹은 추론을 위한 샘플링 속도가 아닐 수 있습니다. 이렇게 샘플링 속도간 불일치가 있다면, 모델이 기대하는 샘플링 속도에 맞춰 리샘플링을 할 수 있습니다.",Ut,b,yl=`대부분의 사전 학습된 모델들은 16 kHz의 샘플링 속도를 가진 오디오 데이터셋에 대하여 사전학습이 이뤄져있습니다.
여러분이 MINDS-14 데이터셋을 살펴보신다면 8 kHz로 샘플링된것을 알 수 있을겁니다. 업샘플링이 필요하다는 뜻이죠.`,ft,$,ul="이를 위해, 🤗 Datasets의 <code>cast_column</code> 메소드를 써봅시다. 이 연산은 오디오를 in-place로 변경하는 것이 아니라 오디오 데이터들이 불러와질때 즉석에서 리샘플링되도록 데이터셋에 신호를 보냅니다. 다음의 코드는 샘플링 속도를 16 kHz로 설정합니다:",dt,x,wt,_,cl="MINDS-14 데이터셋의 첫번째 오디오 예제를 다시 불러와 원하는 <code>sampling_rate</code>으로 리샘플링 되었는지 확인해 보겠습니다:",ht,B,Ct,k,ol="<strong>Output:</strong>",It,g,At,Z,Jl="여러분은 아마 배열의 값들 역시 달라졌음을 눈치채셨을 겁니다. 이는 기존에 비해 진폭값들의 갯수가 전부 두배로 늘어났기 때문입니다.",bt,U,$t,v,xt,R,Tl="여러분은 데이터를 어떤 기준에 맞춰 필터링해야할 때도 있을겁니다. 흔한 경우로는 오디오 데이터를 특정 길이에 맞춰 제한하는 경우가 있을 수 있습니다. 예를 들어, 모델 학습시 out-of-memory 에러를 피하기 위해 20초 보다 긴 모든 데이터를 필터링하길 원할 수도 있습니다.",_t,G,Ul="🤗 Datasets의 <code>filter</code> 메소드에 필터링 로직을 짠 함수를 집어넣어 쓴다면 이를 수행할 수 있습니다. 한번 어떤 데이터를 쓸지 또는 버릴지를 알려주는 함수를 작성해 이를 써봅시다. 함수 <code>is_audio_length_in_range</code>는 만약 샘플이 20초보다 짧다면 <code>True</code>를 그렇지 않다면 <code>False</code>를 반환합니다.",Bt,W,kt,X,fl="필터링 함수는 데이터셋의 컬럼에 적용될 수 있지만 이 데이터셋엔 오디오 트랙 길이가 없습니다. 그러나 우린 새로 이런 컬럼을 만들 수 있으니 새로 만든 후 이 컬럼의 값에 필터를 적용하고 최종적으로는 다시 지워봅시다.",gt,z,Zt,H,dl="<strong>Output:</strong>",vt,V,Rt,N,wl="데이터셋의 숫자가 654개에서 624개로 감소한것을 확인하실 수 있습니다.",Gt,Y,Wt,E,hl="오디오 데이터셋을 준비할 때 가장 어려운점 중 하나는 모델 학습에 맞는 형식을 갖추는 것입니다. 여러분이 앞서 보셧듯, 원시 오디오 데이터는 샘플값들의 배열로 제공됩니다. 그러나, 사전 학습된 모델같은 경우(이를 추론을 위해 쓰든 파인튜닝을 위해 쓰든) 이런 원시 데이터를 입력 feature에 맞춰야합니다. 이런 입력 feature의 요구사항은 모델마다 다를 수 있습니다. 이는 모델의 구조와 어떤 데이터로 사전학습이 이뤄졌는지에 달려있습니다. 좋은 소식은 🤗 Transformers는 지원하는 모든 모델에 대해 원시 데이터를 모델이 원하는 입력 feature로 바꿔주는 feature extractor 클래스를 제공한다는 것입니다.",Xt,Q,Cl='이 feature extractor는 그럼 원시 데이터로 무엇을 하는 걸까요? 일반적인 feature extraction 변환을 이해하기 위해 <a href="https://cdn.openai.com/papers/whisper.pdf" rel="nofollow">Whisper</a>의 feature extractor를 살펴보겠습니다. Whisper는 자동 음성 인식(ASR)을 위해 사전 학습된 모델로 2022년 9월에 OpenAI의 Alec Radford와 공동 연구자들이 발표했습니다.',zt,q,Il=`첫번째로, Whisper의 feature extractor는 모든 데이터가 30초의 길이를 갖도록 덧붙이거나(pad) 자릅니다(truncate). 30초 보다 짧은 데이터는 시퀀스의 끝에 0을 붙여 길이를 늘립니다(오디오 신호에서 0은 신호 없음 혹은 무음과 같습니다). 30초 보다 긴 데이터는 30초가 되도록 자릅니다.
배치의 모든 요소가 input space의 최대 길이에 맞춰 덧붙여지거나 잘렸으므로 별도의 attention mask는 필요 없습니다. 이런 점에서 Whisper는 특별한데, 대부분의 다른 오디오 모델들은 self-attention 메커니즘에서 어느 부분을 무시해야하는지를 알려주기 위해 시퀀스의 어디가 덧붙여졌는지 알려주는 attention mask가 필요하기 때문입니다. Whisper는 attention mask 없이 작동하도록 훈련되어 음성 신호에서 직접 입력의 어느 부분을 무시해야 하는지를 추론합니다.`,Ht,F,Al="Whisper feature extractor가 수행하는 두번째 작업은 덧붙여진 오디오 배열들을 로그-멜 스펙트로그램으로 바꾸는 것입니다. 아시다시피, 이 스펙트로그램은 신호의 주파수가 시간에 따라 어떻게 변하는지를 멜 스케일에 맞춰 데시벨(로그 부분)로 측정하여 주파수와 진폭이 사람의 청각 시스템을 더 잘 표현하도록 합니다.",Vt,S,bl="이 모든 변환은 몇 줄의 코드로 여러분의 원시 데이터에 적용될 수 있습니다. 사전 학습된 Whisper의 체크포인트에서 feature extractor를 불러와 오디오 데이터에 사용할 준비를 해봅시다:",Nt,L,Yt,D,$l="다음으로, <code>feature_extractor</code>를 통해 각각의 오디오 데이터를 전처리할 함수를 작성할 수 있습니다.",Et,P,Qt,O,xl="🤗 Datasets의 <code>map</code> 메소드를 이용하여 모든 학습 데이터에 적용시킬 수 있습니다:",qt,K,Ft,tt,_l="<strong>Output:</strong>",St,lt,Lt,et,Bl="이렇게 간단히, 로그-멜 스펙트로그램을 데이터셋의 <code>input_features</code>에 저장할 수 있습니다.",Dt,st,kl="<code>minds</code> 데이터셋 중 하나를 시각화해봅시다:",Pt,at,Ot,f,gl='<img src="https://huggingface.co/datasets/huggingface-course/audio-course-images/resolve/main/log_mel_whisper.png" alt="Log mel spectrogram plot"/>',Kt,nt,Zl="이제 전처리 후 Whisper 모델에 대한 오디오 입력이 어떻게 보이는지 확인하실 수 있습니다.",tl,Mt,vl='모델의 feature extractor 클래스는 원시 데이터를 모델이 원하는 포맷으로 변경하는 작업을 처리합니다. 그러나, 대개의 오디오 작업은(예를 들어, 음성 인식) multimodal입니다. 이런 경우 🤗 Transformers는 텍스트 입력을 처리하기 위해 모델별 토크나이저(tokenizer)를 제공합니다. 토크나이저에 대해 더 자세히 알고 싶으시다면 <a href="https://huggingface.co/course/chapter2/4" rel="nofollow">NLP 코스</a>를 참고하세요.',ll,pt,Rl="Whisper와 다른 multimodal 모델에 대해 각각의 feature extractor와 토크나이저를 별도로 불러오거나, 이른바 processor를 통해 한번에 불러올 수도 있습니다. 더 간단히 다음의 코드처럼 <code>AutoProcessor</code>로 체크포인트에서 모델의 feature extractor와 processor를 불러올 수도 있습니다:",el,it,sl,mt,Gl=`여기에서는 기본적인 데이터 준비 단계를 설명했습니다. 물론 커스텀 데이터는 더 복잡한 전처리가 필요할 수도 있습니다.
이 경우, 여러분은 어떤 종류의 커스텀 데이터도 변환이 가능하도록 <code>prepare_dataset</code> 함수를 확장할 수 있습니다. 🤗 Datasets과 함께라면, 여러분은 파이썬 함수로 작성 할 수만 있다면 여러분의 데이터에 이를 적용시킬 수 있을겁니다!`,al,rt,nl,jt,Ml;return w=new pl({props:{title:"오디오 데이터셋 전처리하기",local:"preprocessing-an-audio-dataset",headingTag:"h1"}}),I=new pl({props:{title:"오디오 데이터 리샘플링하기",local:"resampling-the-audio-data",headingTag:"h2"}}),x=new J({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwQXVkaW8lMEElMEFtaW5kcyUyMCUzRCUyMG1pbmRzLmNhc3RfY29sdW1uKCUyMmF1ZGlvJTIyJTJDJTIwQXVkaW8oc2FtcGxpbmdfcmF0ZSUzRDE2XzAwMCkp",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Audio

minds = minds.cast_column(<span class="hljs-string">&quot;audio&quot;</span>, Audio(sampling_rate=<span class="hljs-number">16_000</span>))`,wrap:!1}}),B=new J({props:{code:"bWluZHMlNUIwJTVE",highlighted:'minds[<span class="hljs-number">0</span>]',wrap:!1}}),g=new J({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIwJTIycGF0aCUyMiUzQSUyMCUyMiUyRnJvb3QlMkYuY2FjaGUlMkZodWdnaW5nZmFjZSUyRmRhdGFzZXRzJTJGZG93bmxvYWRzJTJGZXh0cmFjdGVkJTJGZjE0OTQ4ZTBlODRiZTYzOGRkNzk0M2FjMzY1MThhNGNmMzMyNGU4YjdhYTMzMWM1YWIxMTU0MTUxOGU5MzY4YyUyRmVuLUFVflBBWV9CSUxMJTJGcmVzcG9uc2VfNC53YXYlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJhdWRpbyUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnBhdGglMjIlM0ElMjAlMjIlMkZyb290JTJGLmNhY2hlJTJGaHVnZ2luZ2ZhY2UlMkZkYXRhc2V0cyUyRmRvd25sb2FkcyUyRmV4dHJhY3RlZCUyRmYxNDk0OGUwZTg0YmU2MzhkZDc5NDNhYzM2NTE4YTRjZjMzMjRlOGI3YWEzMzFjNWFiMTE1NDE1MThlOTM2OGMlMkZlbi1BVX5QQVlfQklMTCUyRnJlc3BvbnNlXzQud2F2JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyYXJyYXklMjIlM0ElMjBhcnJheSglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAyLjA2MzQyNDNlLTA1JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwMS45NDM3ODM3ZS0wNCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMDIuMjQxOTM0MGUtMDQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAuLi4lMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjA5LjM4NTI4NjJlLTA0JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwMS4xMzAyNDUyZS0wMyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMDcuMTUzMTQyOWUtMDQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBkdHlwZSUzRGZsb2F0MzIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyc2FtcGxpbmdfcmF0ZSUyMiUzQSUyMDE2MDAwJTJDJTBBJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIydHJhbnNjcmlwdGlvbiUyMiUzQSUyMCUyMkklMjB3b3VsZCUyMGxpa2UlMjB0byUyMHBheSUyMG15JTIwZWxlY3RyaWNpdHklMjBiaWxsJTIwdXNpbmclMjBteSUyMGNhcmQlMjBjYW4lMjB5b3UlMjBwbGVhc2UlMjBhc3Npc3QlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJpbnRlbnRfY2xhc3MlMjIlM0ElMjAxMyUyQyUwQSU3RA==",highlighted:`{
    <span class="hljs-comment">&quot;path&quot;</span>: <span class="hljs-comment">&quot;/root/.cache/huggingface/datasets/downloads/extracted/f14948e0e84be638dd7943ac36518a4cf3324e8b7aa331c5ab11541518e9368c/en-AU~PAY_BILL/response_4.wav&quot;</span>,
    <span class="hljs-comment">&quot;audio&quot;</span>: {
        <span class="hljs-comment">&quot;path&quot;</span>: <span class="hljs-comment">&quot;/root/.cache/huggingface/datasets/downloads/extracted/f14948e0e84be638dd7943ac36518a4cf3324e8b7aa331c5ab11541518e9368c/en-AU~PAY_BILL/response_4.wav&quot;</span>,
        <span class="hljs-comment">&quot;array&quot;</span>: array(
            [
                <span class="hljs-number">2.0634243e-05</span>,
                <span class="hljs-number">1.9437837e-04</span>,
                <span class="hljs-number">2.2419340e-04</span>,
                ...,
                <span class="hljs-number">9.3852862e-04</span>,
                <span class="hljs-number">1.1302452e-03</span>,
                <span class="hljs-number">7.1531429e-04</span>,
            ],
            dtype=float32,
        ),
        <span class="hljs-comment">&quot;sampling_rate&quot;</span>: <span class="hljs-number">16000</span>,
    },
    <span class="hljs-comment">&quot;transcription&quot;</span>: <span class="hljs-comment">&quot;I would like to pay my electricity bill using my card can you please assist&quot;</span>,
    <span class="hljs-comment">&quot;intent_class&quot;</span>: <span class="hljs-number">13</span>,
}`,wrap:!1}}),U=new Fl({props:{$$slots:{default:[Ll]},$$scope:{ctx:yt}}}),v=new pl({props:{title:"데이터셋 필터링하기",local:"filtering-the-dataset",headingTag:"h2"}}),W=new J({props:{code:"TUFYX0RVUkFUSU9OX0lOX1NFQ09ORFMlMjAlM0QlMjAyMC4wJTBBJTBBJTBBZGVmJTIwaXNfYXVkaW9fbGVuZ3RoX2luX3JhbmdlKGlucHV0X2xlbmd0aCklM0ElMEElMjAlMjAlMjAlMjByZXR1cm4lMjBpbnB1dF9sZW5ndGglMjAlM0MlMjBNQVhfRFVSQVRJT05fSU5fU0VDT05EUw==",highlighted:`MAX_DURATION_IN_SECONDS = <span class="hljs-number">20.0</span>


<span class="hljs-keyword">def</span> <span class="hljs-title function_">is_audio_length_in_range</span>(<span class="hljs-params">input_length</span>):
    <span class="hljs-keyword">return</span> input_length &lt; MAX_DURATION_IN_SECONDS`,wrap:!1}}),z=new J({props:{code:"JTIzJTIwdXNlJTIwbGlicm9zYSUyMHRvJTIwZ2V0JTIwZXhhbXBsZSdzJTIwZHVyYXRpb24lMjBmcm9tJTIwdGhlJTIwYXVkaW8lMjBmaWxlJTBBbmV3X2NvbHVtbiUyMCUzRCUyMCU1QmxpYnJvc2EuZ2V0X2R1cmF0aW9uKGZpbGVuYW1lJTNEeCklMjBmb3IlMjB4JTIwaW4lMjBtaW5kcyU1QiUyMnBhdGglMjIlNUQlNUQlMEFtaW5kcyUyMCUzRCUyMG1pbmRzLmFkZF9jb2x1bW4oJTIyZHVyYXRpb24lMjIlMkMlMjBuZXdfY29sdW1uKSUwQSUwQSUyMyUyMHVzZSUyMCVGMCU5RiVBNCU5NyUyMERhdGFzZXRzJyUyMCU2MGZpbHRlciU2MCUyMG1ldGhvZCUyMHRvJTIwYXBwbHklMjB0aGUlMjBmaWx0ZXJpbmclMjBmdW5jdGlvbiUwQW1pbmRzJTIwJTNEJTIwbWluZHMuZmlsdGVyKGlzX2F1ZGlvX2xlbmd0aF9pbl9yYW5nZSUyQyUyMGlucHV0X2NvbHVtbnMlM0QlNUIlMjJkdXJhdGlvbiUyMiU1RCklMEElMEElMjMlMjByZW1vdmUlMjB0aGUlMjB0ZW1wb3JhcnklMjBoZWxwZXIlMjBjb2x1bW4lMEFtaW5kcyUyMCUzRCUyMG1pbmRzLnJlbW92ZV9jb2x1bW5zKCU1QiUyMmR1cmF0aW9uJTIyJTVEKSUwQW1pbmRz",highlighted:`<span class="hljs-comment"># use librosa to get example&#x27;s duration from the audio file</span>
new_column = [librosa.get_duration(filename=x) <span class="hljs-keyword">for</span> x <span class="hljs-keyword">in</span> minds[<span class="hljs-string">&quot;path&quot;</span>]]
minds = minds.add_column(<span class="hljs-string">&quot;duration&quot;</span>, new_column)

<span class="hljs-comment"># use 🤗 Datasets&#x27; \`filter\` method to apply the filtering function</span>
minds = minds.<span class="hljs-built_in">filter</span>(is_audio_length_in_range, input_columns=[<span class="hljs-string">&quot;duration&quot;</span>])

<span class="hljs-comment"># remove the temporary helper column</span>
minds = minds.remove_columns([<span class="hljs-string">&quot;duration&quot;</span>])
minds`,wrap:!1}}),V=new J({props:{code:"RGF0YXNldCglN0JmZWF0dXJlcyUzQSUyMCU1QiUyMnBhdGglMjIlMkMlMjAlMjJhdWRpbyUyMiUyQyUyMCUyMnRyYW5zY3JpcHRpb24lMjIlMkMlMjAlMjJpbnRlbnRfY2xhc3MlMjIlNUQlMkMlMjBudW1fcm93cyUzQSUyMDYyNCU3RCk=",highlighted:'<span class="hljs-constructor">Dataset({<span class="hljs-params">features</span>: [<span class="hljs-string">&quot;path&quot;</span>, <span class="hljs-string">&quot;audio&quot;</span>, <span class="hljs-string">&quot;transcription&quot;</span>, <span class="hljs-string">&quot;intent_class&quot;</span>], <span class="hljs-params">num_rows</span>: 624})</span>',wrap:!1}}),Y=new pl({props:{title:"오디오 데이터 전처리하기",local:"pre-processing-audio-data",headingTag:"h2"}}),L=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFdoaXNwZXJGZWF0dXJlRXh0cmFjdG9yJTBBJTBBZmVhdHVyZV9leHRyYWN0b3IlMjAlM0QlMjBXaGlzcGVyRmVhdHVyZUV4dHJhY3Rvci5mcm9tX3ByZXRyYWluZWQoJTIyb3BlbmFpJTJGd2hpc3Blci1zbWFsbCUyMik=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> WhisperFeatureExtractor

feature_extractor = WhisperFeatureExtractor.from_pretrained(<span class="hljs-string">&quot;openai/whisper-small&quot;</span>)`,wrap:!1}}),P=new J({props:{code:"ZGVmJTIwcHJlcGFyZV9kYXRhc2V0KGV4YW1wbGUpJTNBJTBBJTIwJTIwJTIwJTIwYXVkaW8lMjAlM0QlMjBleGFtcGxlJTVCJTIyYXVkaW8lMjIlNUQlMEElMjAlMjAlMjAlMjBmZWF0dXJlcyUyMCUzRCUyMGZlYXR1cmVfZXh0cmFjdG9yKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGF1ZGlvJTVCJTIyYXJyYXklMjIlNUQlMkMlMjBzYW1wbGluZ19yYXRlJTNEYXVkaW8lNUIlMjJzYW1wbGluZ19yYXRlJTIyJTVEJTJDJTIwcGFkZGluZyUzRFRydWUlMEElMjAlMjAlMjAlMjApJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwZmVhdHVyZXM=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">prepare_dataset</span>(<span class="hljs-params">example</span>):
    audio = example[<span class="hljs-string">&quot;audio&quot;</span>]
    features = feature_extractor(
        audio[<span class="hljs-string">&quot;array&quot;</span>], sampling_rate=audio[<span class="hljs-string">&quot;sampling_rate&quot;</span>], padding=<span class="hljs-literal">True</span>
    )
    <span class="hljs-keyword">return</span> features`,wrap:!1}}),K=new J({props:{code:"bWluZHMlMjAlM0QlMjBtaW5kcy5tYXAocHJlcGFyZV9kYXRhc2V0KSUwQW1pbmRz",highlighted:`minds = minds.<span class="hljs-built_in">map</span>(prepare_dataset)
minds`,wrap:!1}}),lt=new J({props:{code:"RGF0YXNldCglMEElMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmZWF0dXJlcyUzQSUyMCU1QiUyMnBhdGglMjIlMkMlMjAlMjJhdWRpbyUyMiUyQyUyMCUyMnRyYW5zY3JpcHRpb24lMjIlMkMlMjAlMjJpbnRlbnRfY2xhc3MlMjIlMkMlMjAlMjJpbnB1dF9mZWF0dXJlcyUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG51bV9yb3dzJTNBJTIwNjI0JTJDJTBBJTIwJTIwJTIwJTIwJTdEJTBBKQ==",highlighted:`Dataset(
    <span class="hljs-punctuation">{</span>
<span class="hljs-symbol">        features:</span> [<span class="hljs-string">&quot;path&quot;</span>, <span class="hljs-string">&quot;audio&quot;</span>, <span class="hljs-string">&quot;transcription&quot;</span>, <span class="hljs-string">&quot;intent_class&quot;</span>, <span class="hljs-string">&quot;input_features&quot;</span>],
<span class="hljs-symbol">        num_rows:</span> <span class="hljs-number">624</span>,
    <span class="hljs-punctuation">}</span>
)`,wrap:!1}}),at=new J({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBJTBBZXhhbXBsZSUyMCUzRCUyMG1pbmRzJTVCMCU1RCUwQWlucHV0X2ZlYXR1cmVzJTIwJTNEJTIwZXhhbXBsZSU1QiUyMmlucHV0X2ZlYXR1cmVzJTIyJTVEJTBBJTBBcGx0LmZpZ3VyZSgpLnNldF9maWd3aWR0aCgxMiklMEFsaWJyb3NhLmRpc3BsYXkuc3BlY3Nob3coJTBBJTIwJTIwJTIwJTIwbnAuYXNhcnJheShpbnB1dF9mZWF0dXJlcyU1QjAlNUQpJTJDJTBBJTIwJTIwJTIwJTIweF9heGlzJTNEJTIydGltZSUyMiUyQyUwQSUyMCUyMCUyMCUyMHlfYXhpcyUzRCUyMm1lbCUyMiUyQyUwQSUyMCUyMCUyMCUyMHNyJTNEZmVhdHVyZV9leHRyYWN0b3Iuc2FtcGxpbmdfcmF0ZSUyQyUwQSUyMCUyMCUyMCUyMGhvcF9sZW5ndGglM0RmZWF0dXJlX2V4dHJhY3Rvci5ob3BfbGVuZ3RoJTJDJTBBKSUwQXBsdC5jb2xvcmJhcigp",highlighted:`<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

example = minds[<span class="hljs-number">0</span>]
input_features = example[<span class="hljs-string">&quot;input_features&quot;</span>]

plt.figure().set_figwidth(<span class="hljs-number">12</span>)
librosa.display.specshow(
    np.asarray(input_features[<span class="hljs-number">0</span>]),
    x_axis=<span class="hljs-string">&quot;time&quot;</span>,
    y_axis=<span class="hljs-string">&quot;mel&quot;</span>,
    sr=feature_extractor.sampling_rate,
    hop_length=feature_extractor.hop_length,
)
plt.colorbar()`,wrap:!1}}),it=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMEElMEFwcm9jZXNzb3IlMjAlM0QlMjBBdXRvUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJvcGVuYWklMkZ3aGlzcGVyLXNtYWxsJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor

processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;openai/whisper-small&quot;</span>)`,wrap:!1}}),rt=new Sl({props:{source:"https://github.com/huggingface/audio-transformers-course/blob/main/chapters/ko/chapter1/preprocessing.mdx"}}),{c(){o=M("meta"),T=a(),d=M("p"),ut=a(),m(w.$$.fragment),ct=a(),h=M("p"),h.textContent=ml,ot=a(),C=M("ul"),C.innerHTML=rl,Jt=a(),m(I.$$.fragment),Tt=a(),A=M("p"),A.innerHTML=jl,Ut=a(),b=M("p"),b.textContent=yl,ft=a(),$=M("p"),$.innerHTML=ul,dt=a(),m(x.$$.fragment),wt=a(),_=M("p"),_.innerHTML=cl,ht=a(),m(B.$$.fragment),Ct=a(),k=M("p"),k.innerHTML=ol,It=a(),m(g.$$.fragment),At=a(),Z=M("p"),Z.textContent=Jl,bt=a(),m(U.$$.fragment),$t=a(),m(v.$$.fragment),xt=a(),R=M("p"),R.textContent=Tl,_t=a(),G=M("p"),G.innerHTML=Ul,Bt=a(),m(W.$$.fragment),kt=a(),X=M("p"),X.textContent=fl,gt=a(),m(z.$$.fragment),Zt=a(),H=M("p"),H.innerHTML=dl,vt=a(),m(V.$$.fragment),Rt=a(),N=M("p"),N.textContent=wl,Gt=a(),m(Y.$$.fragment),Wt=a(),E=M("p"),E.textContent=hl,Xt=a(),Q=M("p"),Q.innerHTML=Cl,zt=a(),q=M("p"),q.textContent=Il,Ht=a(),F=M("p"),F.textContent=Al,Vt=a(),S=M("p"),S.textContent=bl,Nt=a(),m(L.$$.fragment),Yt=a(),D=M("p"),D.innerHTML=$l,Et=a(),m(P.$$.fragment),Qt=a(),O=M("p"),O.innerHTML=xl,qt=a(),m(K.$$.fragment),Ft=a(),tt=M("p"),tt.innerHTML=_l,St=a(),m(lt.$$.fragment),Lt=a(),et=M("p"),et.innerHTML=Bl,Dt=a(),st=M("p"),st.innerHTML=kl,Pt=a(),m(at.$$.fragment),Ot=a(),f=M("div"),f.innerHTML=gl,Kt=a(),nt=M("p"),nt.textContent=Zl,tl=a(),Mt=M("p"),Mt.innerHTML=vl,ll=a(),pt=M("p"),pt.innerHTML=Rl,el=a(),m(it.$$.fragment),sl=a(),mt=M("p"),mt.innerHTML=Gl,al=a(),m(rt.$$.fragment),nl=a(),jt=M("p"),this.h()},l(t){const l=Yl("svelte-u9bgzb",document.head);o=p(l,"META",{name:!0,content:!0}),l.forEach(e),T=n(t),d=p(t,"P",{}),Xl(d).forEach(e),ut=n(t),r(w.$$.fragment,t),ct=n(t),h=p(t,"P",{"data-svelte-h":!0}),i(h)!=="svelte-ya88xm"&&(h.textContent=ml),ot=n(t),C=p(t,"UL",{"data-svelte-h":!0}),i(C)!=="svelte-olz9v0"&&(C.innerHTML=rl),Jt=n(t),r(I.$$.fragment,t),Tt=n(t),A=p(t,"P",{"data-svelte-h":!0}),i(A)!=="svelte-zodz6y"&&(A.innerHTML=jl),Ut=n(t),b=p(t,"P",{"data-svelte-h":!0}),i(b)!=="svelte-11vzx2x"&&(b.textContent=yl),ft=n(t),$=p(t,"P",{"data-svelte-h":!0}),i($)!=="svelte-10xsk1v"&&($.innerHTML=ul),dt=n(t),r(x.$$.fragment,t),wt=n(t),_=p(t,"P",{"data-svelte-h":!0}),i(_)!=="svelte-g9ssah"&&(_.innerHTML=cl),ht=n(t),r(B.$$.fragment,t),Ct=n(t),k=p(t,"P",{"data-svelte-h":!0}),i(k)!=="svelte-1mvdyro"&&(k.innerHTML=ol),It=n(t),r(g.$$.fragment,t),At=n(t),Z=p(t,"P",{"data-svelte-h":!0}),i(Z)!=="svelte-d80rar"&&(Z.textContent=Jl),bt=n(t),r(U.$$.fragment,t),$t=n(t),r(v.$$.fragment,t),xt=n(t),R=p(t,"P",{"data-svelte-h":!0}),i(R)!=="svelte-13lalkv"&&(R.textContent=Tl),_t=n(t),G=p(t,"P",{"data-svelte-h":!0}),i(G)!=="svelte-1b59bty"&&(G.innerHTML=Ul),Bt=n(t),r(W.$$.fragment,t),kt=n(t),X=p(t,"P",{"data-svelte-h":!0}),i(X)!=="svelte-1sl3hyy"&&(X.textContent=fl),gt=n(t),r(z.$$.fragment,t),Zt=n(t),H=p(t,"P",{"data-svelte-h":!0}),i(H)!=="svelte-1mvdyro"&&(H.innerHTML=dl),vt=n(t),r(V.$$.fragment,t),Rt=n(t),N=p(t,"P",{"data-svelte-h":!0}),i(N)!=="svelte-1h3nix2"&&(N.textContent=wl),Gt=n(t),r(Y.$$.fragment,t),Wt=n(t),E=p(t,"P",{"data-svelte-h":!0}),i(E)!=="svelte-1n8hncz"&&(E.textContent=hl),Xt=n(t),Q=p(t,"P",{"data-svelte-h":!0}),i(Q)!=="svelte-1eslxg3"&&(Q.innerHTML=Cl),zt=n(t),q=p(t,"P",{"data-svelte-h":!0}),i(q)!=="svelte-19412bd"&&(q.textContent=Il),Ht=n(t),F=p(t,"P",{"data-svelte-h":!0}),i(F)!=="svelte-1lpqin1"&&(F.textContent=Al),Vt=n(t),S=p(t,"P",{"data-svelte-h":!0}),i(S)!=="svelte-1pdcnlk"&&(S.textContent=bl),Nt=n(t),r(L.$$.fragment,t),Yt=n(t),D=p(t,"P",{"data-svelte-h":!0}),i(D)!=="svelte-snr1i6"&&(D.innerHTML=$l),Et=n(t),r(P.$$.fragment,t),Qt=n(t),O=p(t,"P",{"data-svelte-h":!0}),i(O)!=="svelte-1y4bo99"&&(O.innerHTML=xl),qt=n(t),r(K.$$.fragment,t),Ft=n(t),tt=p(t,"P",{"data-svelte-h":!0}),i(tt)!=="svelte-1mvdyro"&&(tt.innerHTML=_l),St=n(t),r(lt.$$.fragment,t),Lt=n(t),et=p(t,"P",{"data-svelte-h":!0}),i(et)!=="svelte-1qmv2tx"&&(et.innerHTML=Bl),Dt=n(t),st=p(t,"P",{"data-svelte-h":!0}),i(st)!=="svelte-d4dgla"&&(st.innerHTML=kl),Pt=n(t),r(at.$$.fragment,t),Ot=n(t),f=p(t,"DIV",{class:!0,"data-svelte-h":!0}),i(f)!=="svelte-csckl"&&(f.innerHTML=gl),Kt=n(t),nt=p(t,"P",{"data-svelte-h":!0}),i(nt)!=="svelte-538kx9"&&(nt.textContent=Zl),tl=n(t),Mt=p(t,"P",{"data-svelte-h":!0}),i(Mt)!=="svelte-15c8axx"&&(Mt.innerHTML=vl),ll=n(t),pt=p(t,"P",{"data-svelte-h":!0}),i(pt)!=="svelte-15pli7h"&&(pt.innerHTML=Rl),el=n(t),r(it.$$.fragment,t),sl=n(t),mt=p(t,"P",{"data-svelte-h":!0}),i(mt)!=="svelte-1t0u2ng"&&(mt.innerHTML=Gl),al=n(t),r(rt.$$.fragment,t),nl=n(t),jt=p(t,"P",{}),Xl(jt).forEach(e),this.h()},h(){il(o,"name","hf:doc:metadata"),il(o,"content",Pl),il(f,"class","flex justify-center")},m(t,l){El(document.head,o),s(t,T,l),s(t,d,l),s(t,ut,l),j(w,t,l),s(t,ct,l),s(t,h,l),s(t,ot,l),s(t,C,l),s(t,Jt,l),j(I,t,l),s(t,Tt,l),s(t,A,l),s(t,Ut,l),s(t,b,l),s(t,ft,l),s(t,$,l),s(t,dt,l),j(x,t,l),s(t,wt,l),s(t,_,l),s(t,ht,l),j(B,t,l),s(t,Ct,l),s(t,k,l),s(t,It,l),j(g,t,l),s(t,At,l),s(t,Z,l),s(t,bt,l),j(U,t,l),s(t,$t,l),j(v,t,l),s(t,xt,l),s(t,R,l),s(t,_t,l),s(t,G,l),s(t,Bt,l),j(W,t,l),s(t,kt,l),s(t,X,l),s(t,gt,l),j(z,t,l),s(t,Zt,l),s(t,H,l),s(t,vt,l),j(V,t,l),s(t,Rt,l),s(t,N,l),s(t,Gt,l),j(Y,t,l),s(t,Wt,l),s(t,E,l),s(t,Xt,l),s(t,Q,l),s(t,zt,l),s(t,q,l),s(t,Ht,l),s(t,F,l),s(t,Vt,l),s(t,S,l),s(t,Nt,l),j(L,t,l),s(t,Yt,l),s(t,D,l),s(t,Et,l),j(P,t,l),s(t,Qt,l),s(t,O,l),s(t,qt,l),j(K,t,l),s(t,Ft,l),s(t,tt,l),s(t,St,l),j(lt,t,l),s(t,Lt,l),s(t,et,l),s(t,Dt,l),s(t,st,l),s(t,Pt,l),j(at,t,l),s(t,Ot,l),s(t,f,l),s(t,Kt,l),s(t,nt,l),s(t,tl,l),s(t,Mt,l),s(t,ll,l),s(t,pt,l),s(t,el,l),j(it,t,l),s(t,sl,l),s(t,mt,l),s(t,al,l),j(rt,t,l),s(t,nl,l),s(t,jt,l),Ml=!0},p(t,[l]){const Wl={};l&2&&(Wl.$$scope={dirty:l,ctx:t}),U.$set(Wl)},i(t){Ml||(y(w.$$.fragment,t),y(I.$$.fragment,t),y(x.$$.fragment,t),y(B.$$.fragment,t),y(g.$$.fragment,t),y(U.$$.fragment,t),y(v.$$.fragment,t),y(W.$$.fragment,t),y(z.$$.fragment,t),y(V.$$.fragment,t),y(Y.$$.fragment,t),y(L.$$.fragment,t),y(P.$$.fragment,t),y(K.$$.fragment,t),y(lt.$$.fragment,t),y(at.$$.fragment,t),y(it.$$.fragment,t),y(rt.$$.fragment,t),Ml=!0)},o(t){u(w.$$.fragment,t),u(I.$$.fragment,t),u(x.$$.fragment,t),u(B.$$.fragment,t),u(g.$$.fragment,t),u(U.$$.fragment,t),u(v.$$.fragment,t),u(W.$$.fragment,t),u(z.$$.fragment,t),u(V.$$.fragment,t),u(Y.$$.fragment,t),u(L.$$.fragment,t),u(P.$$.fragment,t),u(K.$$.fragment,t),u(lt.$$.fragment,t),u(at.$$.fragment,t),u(it.$$.fragment,t),u(rt.$$.fragment,t),Ml=!1},d(t){t&&(e(T),e(d),e(ut),e(ct),e(h),e(ot),e(C),e(Jt),e(Tt),e(A),e(Ut),e(b),e(ft),e($),e(dt),e(wt),e(_),e(ht),e(Ct),e(k),e(It),e(At),e(Z),e(bt),e($t),e(xt),e(R),e(_t),e(G),e(Bt),e(kt),e(X),e(gt),e(Zt),e(H),e(vt),e(Rt),e(N),e(Gt),e(Wt),e(E),e(Xt),e(Q),e(zt),e(q),e(Ht),e(F),e(Vt),e(S),e(Nt),e(Yt),e(D),e(Et),e(Qt),e(O),e(qt),e(Ft),e(tt),e(St),e(Lt),e(et),e(Dt),e(st),e(Pt),e(Ot),e(f),e(Kt),e(nt),e(tl),e(Mt),e(ll),e(pt),e(el),e(sl),e(mt),e(al),e(nl),e(jt)),e(o),c(w,t),c(I,t),c(x,t),c(B,t),c(g,t),c(U,t),c(v,t),c(W,t),c(z,t),c(V,t),c(Y,t),c(L,t),c(P,t),c(K,t),c(lt,t),c(at,t),c(it,t),c(rt,t)}}}const Pl='{"title":"오디오 데이터셋 전처리하기","local":"preprocessing-an-audio-dataset","sections":[{"title":"오디오 데이터 리샘플링하기","local":"resampling-the-audio-data","sections":[],"depth":2},{"title":"데이터셋 필터링하기","local":"filtering-the-dataset","sections":[],"depth":2},{"title":"오디오 데이터 전처리하기","local":"pre-processing-audio-data","sections":[],"depth":2}],"depth":1}';function Ol(yt){return Hl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ae extends Vl{constructor(o){super(),Nl(this,o,Ol,Dl,zl,{})}}export{ae as component};
