import{s as _e,f as Ie,o as ke,n as Ee}from"../chunks/scheduler.f6b352c8.js";import{S as He,i as Pe,g as i,s as l,r as M,A as Ze,h as o,f as n,c as a,j as Je,u as y,x as r,k as lt,y as Be,a as s,v as w,d as C,t as v,w as x,m as Se,n as Le}from"../chunks/index.7f38e934.js";import{T as Ge}from"../chunks/Tip.ae532637.js";import{C as Ae}from"../chunks/CodeBlock.2a338b68.js";import{H as Qt}from"../chunks/Heading.333929c4.js";import{E as qe}from"../chunks/EditOnGithub.c3245a01.js";function We(it){let p,u,d="We’ll cover how actions are represented (using JSON or code), the importance of the stop and parse approach, and introduce different types of agents.";return{c(){p=Se(`In this section, we explore the concrete steps an AI agent takes to interact with its environment. 
`),u=i("p"),u.textContent=d},l(c){p=Le(c,`In this section, we explore the concrete steps an AI agent takes to interact with its environment. 
`),u=o(c,"P",{"data-svelte-h":!0}),r(u)!=="svelte-1st7yzx"&&(u.textContent=d)},m(c,h){s(c,p,h),s(c,u,h)},p:Ee,d(c){c&&(n(p),n(u))}}}function Fe(it){let p,u,d,c,h,ot,m,rt,T,Yt="Actions are the concrete steps an <strong>AI agent takes to interact with its environment</strong>.",pt,j,Ot="Whether it’s browsing the web for information or controlling a physical device, each action is a deliberate operation executed by the agent.",ut,U,Dt="For example, an agent assisting with customer service might retrieve customer data, offer support articles, or transfer issues to a human representative.",ct,b,ht,$,Kt="There are multiple types of Agents that take actions differently:",dt,J,te="<thead><tr><th>Type of Agent</th> <th>Description</th></tr></thead> <tbody><tr><td>JSON Agent</td> <td>The Action to take is specified in JSON format.</td></tr> <tr><td>Code Agent</td> <td>The Agent writes a code block that is interpreted externally.</td></tr> <tr><td>Function-calling Agent</td> <td>It is a subcategory of the JSON Agent which has been fine-tuned to generate a new message for each action.</td></tr></tbody>",mt,A,ee="Actions themselves can serve many purposes:",ft,_,ne="<thead><tr><th>Type of Action</th> <th>Description</th></tr></thead> <tbody><tr><td>Information Gathering</td> <td>Performing web searches, querying databases, or retrieving documents.</td></tr> <tr><td>Tool Usage</td> <td>Making API calls, running calculations, and executing code.</td></tr> <tr><td>Environment Interaction</td> <td>Manipulating digital interfaces or controlling physical devices.</td></tr> <tr><td>Communication</td> <td>Engaging with users via chat or collaborating with other agents.</td></tr></tbody>",gt,I,se="One crucial part of an agent is the <strong>ability to STOP generating new tokens when an action is complete</strong>, and that is true for all formats of Agent: JSON, code, or function-calling. This prevents unintended output and ensures that the agent’s response is clear and precise.",Mt,k,le="The LLM only handles text and uses it to describe the action it wants to take and the parameters to supply to the tool.",yt,E,wt,H,ae="One key method for implementing actions is the <strong>stop and parse approach</strong>. This method ensures that the agent’s output is structured and predictable:",Ct,P,ie="<li><strong>Generation in a Structured Format</strong>:</li>",vt,Z,oe="The agent outputs its intended action in a clear, predetermined format (JSON or code).",xt,f,re="<li><strong>Halting Further Generation</strong>:</li>",Tt,B,pe="Once the action is complete, <strong>the agent stops generating additional tokens</strong>. This prevents extra or erroneous output.",jt,g,ue="<li><strong>Parsing the Output</strong>:</li>",Ut,S,ce="An external parser reads the formatted action, determines which Tool to call, and extracts the required parameters.",bt,L,he="For example, an agent needing to check the weather might output:",$t,G,Jt,q,de="The framework can then easily parse the name of the function to call and the arguments to apply.",At,W,me="This clear, machine-readable format minimizes errors and enables external tools to accurately process the agent’s command.",_t,F,fe=`Note: Function-calling agents operate similarly by structuring each action so that a designated function is invoked with the correct arguments.
We’ll dive deeper into those types of Agents in a future Unit.`,It,N,kt,R,ge=`An alternative approach is using <em>Code Agents</em>.
The idea is: <strong>instead of outputting a simple JSON object</strong>, a Code Agent generates an <strong>executable code block—typically in a high-level language like Python</strong>.`,Et,V,Me,Ht,X,ye="This approach offers several advantages:",Pt,z,we="<li><strong>Expressiveness:</strong> Code can naturally represent complex logic, including loops, conditionals, and nested functions, providing greater flexibility than JSON.</li> <li><strong>Modularity and Reusability:</strong> Generated code can include functions and modules that are reusable across different actions or tasks.</li> <li><strong>Enhanced Debuggability:</strong> With a well-defined programming syntax, code errors are often easier to detect and correct.</li> <li><strong>Direct Integration:</strong> Code Agents can integrate directly with external libraries and APIs, enabling more complex operations such as data processing or real-time decision making.</li>",Zt,Q,Ce="For example, a Code Agent tasked with fetching the weather might generate the following Python snippet:",Bt,Y,St,O,ve="In this example, the Code Agent:",Lt,D,xe="<li>Retrieves weather data <strong>via an API call</strong>,</li> <li>Processes the response,</li> <li>And uses the print() function to output a final answer.</li>",Gt,K,Te="This method <strong>also follows the stop and parse approach</strong> by clearly delimiting the code block and signaling when execution is complete (here, by printing the final_answer).",qt,Wt,Ft,tt,je="We learned that Actions bridge an agent’s internal reasoning and its real-world interactions by executing clear, structured tasks—whether through JSON, code, or function calls.",Nt,et,Ue="This deliberate execution ensures that each action is precise and ready for external processing via the stop and parse approach. In the next section, we will explore Observations to see how agents capture and integrate feedback from their environment.",Rt,nt,be="After this, we will <strong>finally be ready to build our first Agent!</strong>",Vt,st,Xt,at,zt;return h=new Qt({props:{title:"Actions:  Enabling the Agent to Engage with Its Environment",local:"actions-enabling-the-agent-to-engage-with-its-environment",headingTag:"h1"}}),m=new Ge({props:{$$slots:{default:[We]},$$scope:{ctx:it}}}),b=new Qt({props:{title:"Types of Agent Actions",local:"types-of-agent-actions",headingTag:"h2"}}),E=new Qt({props:{title:"The Stop and Parse Approach",local:"the-stop-and-parse-approach",headingTag:"h2"}}),G=new Ae({props:{code:"VGhvdWdodCUzQSUyMEklMjBuZWVkJTIwdG8lMjBjaGVjayUyMHRoZSUyMGN1cnJlbnQlMjB3ZWF0aGVyJTIwZm9yJTIwTmV3JTIwWW9yay4lMEFBY3Rpb24lMjAlM0ElMEElN0IlMEElMjAlMjAlMjJhY3Rpb24lMjIlM0ElMjAlMjJnZXRfd2VhdGhlciUyMiUyQyUwQSUyMCUyMCUyMmFjdGlvbl9pbnB1dCUyMiUzQSUyMCU3QiUyMmxvY2F0aW9uJTIyJTNBJTIwJTIyTmV3JTIwWW9yayUyMiU3RCUwQSU3RA==",highlighted:`Thought<span class="hljs-punctuation">:</span> I need to check the current weather for New York.
Action <span class="hljs-punctuation">:</span>
<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;action&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;get_weather&quot;</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;action_input&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;location&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;New York&quot;</span><span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),N=new Qt({props:{title:"Code Agents",local:"code-agents",headingTag:"h2"}}),Y=new Ae({props:{code:"JTIzJTIwQ29kZSUyMEFnZW50JTIwRXhhbXBsZSUzQSUyMFJldHJpZXZlJTIwV2VhdGhlciUyMEluZm9ybWF0aW9uJTBBZGVmJTIwZ2V0X3dlYXRoZXIoY2l0eSklM0ElMEElMjAlMjAlMjAlMjBpbXBvcnQlMjByZXF1ZXN0cyUwQSUyMCUyMCUyMCUyMGFwaV91cmwlMjAlM0QlMjBmJTIyaHR0cHMlM0ElMkYlMkZhcGkud2VhdGhlci5jb20lMkZ2MSUyRmxvY2F0aW9uJTJGJTdCY2l0eSU3RCUzRmFwaUtleSUzRFlPVVJfQVBJX0tFWSUyMiUwQSUyMCUyMCUyMCUyMHJlc3BvbnNlJTIwJTNEJTIwcmVxdWVzdHMuZ2V0KGFwaV91cmwpJTBBJTIwJTIwJTIwJTIwaWYlMjByZXNwb25zZS5zdGF0dXNfY29kZSUyMCUzRCUzRCUyMDIwMCUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGRhdGElMjAlM0QlMjByZXNwb25zZS5qc29uKCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjBkYXRhLmdldCglMjJ3ZWF0aGVyJTIyJTJDJTIwJTIyTm8lMjB3ZWF0aGVyJTIwaW5mb3JtYXRpb24lMjBhdmFpbGFibGUlMjIpJTBBJTIwJTIwJTIwJTIwZWxzZSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMCUyMkVycm9yJTNBJTIwVW5hYmxlJTIwdG8lMjBmZXRjaCUyMHdlYXRoZXIlMjBkYXRhLiUyMiUwQSUwQSUyMyUyMEV4ZWN1dGUlMjB0aGUlMjBmdW5jdGlvbiUyMGFuZCUyMHByZXBhcmUlMjB0aGUlMjBmaW5hbCUyMGFuc3dlciUwQXJlc3VsdCUyMCUzRCUyMGdldF93ZWF0aGVyKCUyMk5ldyUyMFlvcmslMjIpJTBBZmluYWxfYW5zd2VyJTIwJTNEJTIwZiUyMlRoZSUyMGN1cnJlbnQlMjB3ZWF0aGVyJTIwaW4lMjBOZXclMjBZb3JrJTIwaXMlM0ElMjAlN0JyZXN1bHQlN0QlMjIlMEFwcmludChmaW5hbF9hbnN3ZXIp",highlighted:`<span class="hljs-comment"># Code Agent Example: Retrieve Weather Information</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_weather</span>(<span class="hljs-params">city</span>):
    <span class="hljs-keyword">import</span> requests
    api_url = <span class="hljs-string">f&quot;https://api.weather.com/v1/location/<span class="hljs-subst">{city}</span>?apiKey=YOUR_API_KEY&quot;</span>
    response = requests.get(api_url)
    <span class="hljs-keyword">if</span> response.status_code == <span class="hljs-number">200</span>:
        data = response.json()
        <span class="hljs-keyword">return</span> data.get(<span class="hljs-string">&quot;weather&quot;</span>, <span class="hljs-string">&quot;No weather information available&quot;</span>)
    <span class="hljs-keyword">else</span>:
        <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;Error: Unable to fetch weather data.&quot;</span>

<span class="hljs-comment"># Execute the function and prepare the final answer</span>
result = get_weather(<span class="hljs-string">&quot;New York&quot;</span>)
final_answer = <span class="hljs-string">f&quot;The current weather in New York is: <span class="hljs-subst">{result}</span>&quot;</span>
<span class="hljs-built_in">print</span>(final_answer)`,wrap:!1}}),st=new qe({props:{source:"https://github.com/huggingface/agents-course/blob/main/units/en/unit1/actions.mdx"}}),{c(){p=i("meta"),u=l(),d=i("p"),c=l(),M(h.$$.fragment),ot=l(),M(m.$$.fragment),rt=l(),T=i("p"),T.innerHTML=Yt,pt=l(),j=i("p"),j.textContent=Ot,ut=l(),U=i("p"),U.textContent=Dt,ct=l(),M(b.$$.fragment),ht=l(),$=i("p"),$.textContent=Kt,dt=l(),J=i("table"),J.innerHTML=te,mt=l(),A=i("p"),A.textContent=ee,ft=l(),_=i("table"),_.innerHTML=ne,gt=l(),I=i("p"),I.innerHTML=se,Mt=l(),k=i("p"),k.textContent=le,yt=l(),M(E.$$.fragment),wt=l(),H=i("p"),H.innerHTML=ae,Ct=l(),P=i("ol"),P.innerHTML=ie,vt=l(),Z=i("p"),Z.textContent=oe,xt=l(),f=i("ol"),f.innerHTML=re,Tt=l(),B=i("p"),B.innerHTML=pe,jt=l(),g=i("ol"),g.innerHTML=ue,Ut=l(),S=i("p"),S.textContent=ce,bt=l(),L=i("p"),L.textContent=he,$t=l(),M(G.$$.fragment),Jt=l(),q=i("p"),q.textContent=de,At=l(),W=i("p"),W.textContent=me,_t=l(),F=i("p"),F.textContent=fe,It=l(),M(N.$$.fragment),kt=l(),R=i("p"),R.innerHTML=ge,Et=l(),V=i("img"),Ht=l(),X=i("p"),X.textContent=ye,Pt=l(),z=i("ul"),z.innerHTML=we,Zt=l(),Q=i("p"),Q.textContent=Ce,Bt=l(),M(Y.$$.fragment),St=l(),O=i("p"),O.textContent=ve,Lt=l(),D=i("ul"),D.innerHTML=xe,Gt=l(),K=i("p"),K.innerHTML=Te,qt=l(),Wt=i("hr"),Ft=l(),tt=i("p"),tt.textContent=je,Nt=l(),et=i("p"),et.textContent=Ue,Rt=l(),nt=i("p"),nt.innerHTML=be,Vt=l(),M(st.$$.fragment),Xt=l(),at=i("p"),this.h()},l(t){const e=Ze("svelte-u9bgzb",document.head);p=o(e,"META",{name:!0,content:!0}),e.forEach(n),u=a(t),d=o(t,"P",{}),Je(d).forEach(n),c=a(t),y(h.$$.fragment,t),ot=a(t),y(m.$$.fragment,t),rt=a(t),T=o(t,"P",{"data-svelte-h":!0}),r(T)!=="svelte-1d9hktj"&&(T.innerHTML=Yt),pt=a(t),j=o(t,"P",{"data-svelte-h":!0}),r(j)!=="svelte-1tl5mip"&&(j.textContent=Ot),ut=a(t),U=o(t,"P",{"data-svelte-h":!0}),r(U)!=="svelte-1ubetp8"&&(U.textContent=Dt),ct=a(t),y(b.$$.fragment,t),ht=a(t),$=o(t,"P",{"data-svelte-h":!0}),r($)!=="svelte-1wlcwgd"&&($.textContent=Kt),dt=a(t),J=o(t,"TABLE",{"data-svelte-h":!0}),r(J)!=="svelte-3ls1cj"&&(J.innerHTML=te),mt=a(t),A=o(t,"P",{"data-svelte-h":!0}),r(A)!=="svelte-1xp7kgk"&&(A.textContent=ee),ft=a(t),_=o(t,"TABLE",{"data-svelte-h":!0}),r(_)!=="svelte-4604oy"&&(_.innerHTML=ne),gt=a(t),I=o(t,"P",{"data-svelte-h":!0}),r(I)!=="svelte-1gc976e"&&(I.innerHTML=se),Mt=a(t),k=o(t,"P",{"data-svelte-h":!0}),r(k)!=="svelte-xqjszd"&&(k.textContent=le),yt=a(t),y(E.$$.fragment,t),wt=a(t),H=o(t,"P",{"data-svelte-h":!0}),r(H)!=="svelte-a9as0m"&&(H.innerHTML=ae),Ct=a(t),P=o(t,"OL",{"data-svelte-h":!0}),r(P)!=="svelte-1nmidra"&&(P.innerHTML=ie),vt=a(t),Z=o(t,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-l3tk2o"&&(Z.textContent=oe),xt=a(t),f=o(t,"OL",{start:!0,"data-svelte-h":!0}),r(f)!=="svelte-j1mwkc"&&(f.innerHTML=re),Tt=a(t),B=o(t,"P",{"data-svelte-h":!0}),r(B)!=="svelte-1n64x39"&&(B.innerHTML=pe),jt=a(t),g=o(t,"OL",{start:!0,"data-svelte-h":!0}),r(g)!=="svelte-w7r926"&&(g.innerHTML=ue),Ut=a(t),S=o(t,"P",{"data-svelte-h":!0}),r(S)!=="svelte-191aaii"&&(S.textContent=ce),bt=a(t),L=o(t,"P",{"data-svelte-h":!0}),r(L)!=="svelte-1exbnez"&&(L.textContent=he),$t=a(t),y(G.$$.fragment,t),Jt=a(t),q=o(t,"P",{"data-svelte-h":!0}),r(q)!=="svelte-1j4o5aq"&&(q.textContent=de),At=a(t),W=o(t,"P",{"data-svelte-h":!0}),r(W)!=="svelte-1so9m39"&&(W.textContent=me),_t=a(t),F=o(t,"P",{"data-svelte-h":!0}),r(F)!=="svelte-1k8g2zy"&&(F.textContent=fe),It=a(t),y(N.$$.fragment,t),kt=a(t),R=o(t,"P",{"data-svelte-h":!0}),r(R)!=="svelte-19f0lzf"&&(R.innerHTML=ge),Et=a(t),V=o(t,"IMG",{src:!0,alt:!0}),Ht=a(t),X=o(t,"P",{"data-svelte-h":!0}),r(X)!=="svelte-rsd8hl"&&(X.textContent=ye),Pt=a(t),z=o(t,"UL",{"data-svelte-h":!0}),r(z)!=="svelte-1t80mrq"&&(z.innerHTML=we),Zt=a(t),Q=o(t,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-qjq0mw"&&(Q.textContent=Ce),Bt=a(t),y(Y.$$.fragment,t),St=a(t),O=o(t,"P",{"data-svelte-h":!0}),r(O)!=="svelte-pfpi4"&&(O.textContent=ve),Lt=a(t),D=o(t,"UL",{"data-svelte-h":!0}),r(D)!=="svelte-b7upo8"&&(D.innerHTML=xe),Gt=a(t),K=o(t,"P",{"data-svelte-h":!0}),r(K)!=="svelte-1v0y8k3"&&(K.innerHTML=Te),qt=a(t),Wt=o(t,"HR",{}),Ft=a(t),tt=o(t,"P",{"data-svelte-h":!0}),r(tt)!=="svelte-b7m3f6"&&(tt.textContent=je),Nt=a(t),et=o(t,"P",{"data-svelte-h":!0}),r(et)!=="svelte-h8bvqv"&&(et.textContent=Ue),Rt=a(t),nt=o(t,"P",{"data-svelte-h":!0}),r(nt)!=="svelte-14ocnmz"&&(nt.innerHTML=be),Vt=a(t),y(st.$$.fragment,t),Xt=a(t),at=o(t,"P",{}),Je(at).forEach(n),this.h()},h(){lt(p,"name","hf:doc:metadata"),lt(p,"content",Ne),lt(f,"start","2"),lt(g,"start","3"),Ie(V.src,Me="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit1/code-vs-json-actions.png")||lt(V,"src",Me),lt(V,"alt","Code Agents")},m(t,e){Be(document.head,p),s(t,u,e),s(t,d,e),s(t,c,e),w(h,t,e),s(t,ot,e),w(m,t,e),s(t,rt,e),s(t,T,e),s(t,pt,e),s(t,j,e),s(t,ut,e),s(t,U,e),s(t,ct,e),w(b,t,e),s(t,ht,e),s(t,$,e),s(t,dt,e),s(t,J,e),s(t,mt,e),s(t,A,e),s(t,ft,e),s(t,_,e),s(t,gt,e),s(t,I,e),s(t,Mt,e),s(t,k,e),s(t,yt,e),w(E,t,e),s(t,wt,e),s(t,H,e),s(t,Ct,e),s(t,P,e),s(t,vt,e),s(t,Z,e),s(t,xt,e),s(t,f,e),s(t,Tt,e),s(t,B,e),s(t,jt,e),s(t,g,e),s(t,Ut,e),s(t,S,e),s(t,bt,e),s(t,L,e),s(t,$t,e),w(G,t,e),s(t,Jt,e),s(t,q,e),s(t,At,e),s(t,W,e),s(t,_t,e),s(t,F,e),s(t,It,e),w(N,t,e),s(t,kt,e),s(t,R,e),s(t,Et,e),s(t,V,e),s(t,Ht,e),s(t,X,e),s(t,Pt,e),s(t,z,e),s(t,Zt,e),s(t,Q,e),s(t,Bt,e),w(Y,t,e),s(t,St,e),s(t,O,e),s(t,Lt,e),s(t,D,e),s(t,Gt,e),s(t,K,e),s(t,qt,e),s(t,Wt,e),s(t,Ft,e),s(t,tt,e),s(t,Nt,e),s(t,et,e),s(t,Rt,e),s(t,nt,e),s(t,Vt,e),w(st,t,e),s(t,Xt,e),s(t,at,e),zt=!0},p(t,[e]){const $e={};e&2&&($e.$$scope={dirty:e,ctx:t}),m.$set($e)},i(t){zt||(C(h.$$.fragment,t),C(m.$$.fragment,t),C(b.$$.fragment,t),C(E.$$.fragment,t),C(G.$$.fragment,t),C(N.$$.fragment,t),C(Y.$$.fragment,t),C(st.$$.fragment,t),zt=!0)},o(t){v(h.$$.fragment,t),v(m.$$.fragment,t),v(b.$$.fragment,t),v(E.$$.fragment,t),v(G.$$.fragment,t),v(N.$$.fragment,t),v(Y.$$.fragment,t),v(st.$$.fragment,t),zt=!1},d(t){t&&(n(u),n(d),n(c),n(ot),n(rt),n(T),n(pt),n(j),n(ut),n(U),n(ct),n(ht),n($),n(dt),n(J),n(mt),n(A),n(ft),n(_),n(gt),n(I),n(Mt),n(k),n(yt),n(wt),n(H),n(Ct),n(P),n(vt),n(Z),n(xt),n(f),n(Tt),n(B),n(jt),n(g),n(Ut),n(S),n(bt),n(L),n($t),n(Jt),n(q),n(At),n(W),n(_t),n(F),n(It),n(kt),n(R),n(Et),n(V),n(Ht),n(X),n(Pt),n(z),n(Zt),n(Q),n(Bt),n(St),n(O),n(Lt),n(D),n(Gt),n(K),n(qt),n(Wt),n(Ft),n(tt),n(Nt),n(et),n(Rt),n(nt),n(Vt),n(Xt),n(at)),n(p),x(h,t),x(m,t),x(b,t),x(E,t),x(G,t),x(N,t),x(Y,t),x(st,t)}}}const Ne='{"title":"Actions:  Enabling the Agent to Engage with Its Environment","local":"actions-enabling-the-agent-to-engage-with-its-environment","sections":[{"title":"Types of Agent Actions","local":"types-of-agent-actions","sections":[],"depth":2},{"title":"The Stop and Parse Approach","local":"the-stop-and-parse-approach","sections":[],"depth":2},{"title":"Code Agents","local":"code-agents","sections":[],"depth":2}],"depth":1}';function Re(it){return ke(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class De extends He{constructor(p){super(),Pe(this,p,Re,Fe,_e,{})}}export{De as component};
