import{s as pe,o as ie,n as ne}from"../chunks/scheduler.6062bdaf.js";import{S as oe,i as me,g as i,s as a,r as c,A as ce,h as o,f as s,c as n,j as le,u as r,x as m,k as $t,y as re,a as l,v as u,d,t as h,w as g}from"../chunks/index.4bca734e.js";import{T as ae}from"../chunks/Tip.b9ac1f03.js";import{C as Z}from"../chunks/CodeBlock.fa01571c.js";import{H as et,E as ue}from"../chunks/EditOnGithub.74ab2baa.js";function de(st){let p,w=`You can also use the
<a href="https://huggingface.co/docs/transformers/main/en/main_classes/pipelines#pipelines" rel="nofollow">pipeline()</a> function from
Transformers and provide your Optimum model class.`;return{c(){p=i("p"),p.innerHTML=w},l(y){p=o(y,"P",{"data-svelte-h":!0}),m(p)!=="svelte-1n3dg1e"&&(p.innerHTML=w)},m(y,M){l(y,p,M)},p:ne,d(y){y&&s(p)}}}function he(st){let p,w="To be able to load the model with the ONNX Runtime backend, the export to ONNX needs to be supported for the considered architecture.",y,M,b='You can check the list of supported architectures <a href="https://huggingface.co/docs/optimum/exporters/onnx/overview#overview" rel="nofollow">here</a>.';return{c(){p=i("p"),p.textContent=w,y=a(),M=i("p"),M.innerHTML=b},l(T){p=o(T,"P",{"data-svelte-h":!0}),m(p)!=="svelte-1mw84js"&&(p.textContent=w),y=n(T),M=o(T,"P",{"data-svelte-h":!0}),m(M)!=="svelte-e7f34u"&&(M.innerHTML=b)},m(T,J){l(T,p,J),l(T,y,J),l(T,M,J)},p:ne,d(T){T&&(s(p),s(y),s(M))}}}function ge(st){let p,w,y,M,b,T,J,qt=`The <code>pipeline()</code> function makes it simple to use models from the <a href="https://huggingface.co/models" rel="nofollow">Model Hub</a>
for accelerated inference on a variety of tasks such as text classification, question answering and image classification.`,at,j,nt,W,_t="Currently the supported tasks are:",pt,X,Ft="<li><code>feature-extraction</code></li> <li><code>text-classification</code></li> <li><code>token-classification</code></li> <li><code>question-answering</code></li> <li><code>zero-shot-classification</code></li> <li><code>text-generation</code></li> <li><code>text2text-generation</code></li> <li><code>summarization</code></li> <li><code>translation</code></li> <li><code>image-classification</code></li> <li><code>automatic-speech-recognition</code></li> <li><code>image-to-text</code></li>",it,I,ot,G,Nt=`While each task has an associated pipeline class, it is simpler to use the general <code>pipeline()</code> function which wraps all the task-specific pipelines in one object.
The <code>pipeline()</code> function automatically loads a default model and tokenizer/feature-extractor capable of performing inference for your task.`,mt,R,Qt="<li>Start by creating a pipeline by specifying an inference task:</li>",ct,B,rt,U,Et="<li>Pass your input text/image to the <code>pipeline()</code> function:</li>",ut,v,dt,x,Ht="<em>Note: The default models used in the <code>pipeline()</code> function are not optimized for inference or quantized, so there won’t be a performance improvement compared to their PyTorch counterparts.</em>",ht,k,gt,z,St=`The <code>pipeline()</code> function accepts any supported model from the <a href="https://huggingface.co/models" rel="nofollow">Hugging Face Hub</a>.
There are tags on the Model Hub that allow you to filter for a model you’d like to use for your task.`,yt,f,Mt,V,Yt="Once you have picked an appropriate model, you can create the <code>pipeline()</code> by specifying the model repo:",Tt,C,Jt,$,Ot=`It is also possible to load it with the <code>from_pretrained(model_name_or_path, export=True)</code>
method associated with the <code>ORTModelForXXX</code> class.`,wt,q,Lt='For example, here is how you can load the <a href="/docs/optimum/pr_1932/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModelForQuestionAnswering">ORTModelForQuestionAnswering</a> class for question answering:',bt,_,jt,F,Ut,N,At='The <code>pipeline()</code> function is tightly integrated with the <a href="https://huggingface.co/models" rel="nofollow">Hugging Face Hub</a> and can load ONNX models directly.',ft,Q,Zt,E,Pt=`It is also possible to load it with the <code>from_pretrained(model_name_or_path)</code>
method associated with the <code>ORTModelForXXX</code> class.`,Wt,H,Kt='For example, here is how you can load the <a href="/docs/optimum/pr_1932/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModelForQuestionAnswering">ORTModelForQuestionAnswering</a> class for question answering:',Xt,S,It,Y,Gt,O,Dt=`The <code>pipeline()</code> function can not only run inference on vanilla ONNX Runtime checkpoints - you can also use
checkpoints optimized with the <a href="/docs/optimum/pr_1932/en/onnxruntime/package_reference/quantization#optimum.onnxruntime.ORTQuantizer">ORTQuantizer</a> and the <a href="/docs/optimum/pr_1932/en/onnxruntime/package_reference/optimization#optimum.onnxruntime.ORTOptimizer">ORTOptimizer</a>.`,Rt,L,te=`Below you can find two examples of how you could use the <a href="/docs/optimum/pr_1932/en/onnxruntime/package_reference/optimization#optimum.onnxruntime.ORTOptimizer">ORTOptimizer</a> and the
<a href="/docs/optimum/pr_1932/en/onnxruntime/package_reference/quantization#optimum.onnxruntime.ORTQuantizer">ORTQuantizer</a> to optimize/quantize your model and use it for inference afterwards.`,Bt,A,vt,P,xt,K,kt,D,zt,tt,Vt,lt,Ct;return b=new et({props:{title:"Inference pipelines with the ONNX Runtime accelerator",local:"inference-pipelines-with-the-onnx-runtime-accelerator",headingTag:"h1"}}),j=new ae({props:{$$slots:{default:[de]},$$scope:{ctx:st}}}),I=new et({props:{title:"Optimum pipeline usage",local:"optimum-pipeline-usage",headingTag:"h2"}}),B=new Z({props:{code:"ZnJvbSUyMG9wdGltdW0ucGlwZWxpbmVzJTIwaW1wb3J0JTIwcGlwZWxpbmUlMEElMEFjbGFzc2lmaWVyJTIwJTNEJTIwcGlwZWxpbmUodGFzayUzRCUyMnRleHQtY2xhc3NpZmljYXRpb24lMjIlMkMlMjBhY2NlbGVyYXRvciUzRCUyMm9ydCUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.pipelines <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>classifier = pipeline(task=<span class="hljs-string">&quot;text-classification&quot;</span>, accelerator=<span class="hljs-string">&quot;ort&quot;</span>)`,wrap:!1}}),v=new Z({props:{code:"Y2xhc3NpZmllciglMjJJJTIwbGlrZSUyMHlvdS4lMjBJJTIwbG92ZSUyMHlvdS4lMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>classifier(<span class="hljs-string">&quot;I like you. I love you.&quot;</span>)
[{<span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;POSITIVE&#x27;</span>, <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.9998838901519775</span>}]`,wrap:!1}}),k=new et({props:{title:"Using vanilla Transformers model and converting to ONNX",local:"using-vanilla-transformers-model-and-converting-to-onnx",headingTag:"h3"}}),f=new ae({props:{$$slots:{default:[he]},$$scope:{ctx:st}}}),C=new Z({props:{code:"ZnJvbSUyMG9wdGltdW0ucGlwZWxpbmVzJTIwaW1wb3J0JTIwcGlwZWxpbmUlMEElMEFvbm54X3FhJTIwJTNEJTIwcGlwZWxpbmUoJTIycXVlc3Rpb24tYW5zd2VyaW5nJTIyJTJDJTIwbW9kZWwlM0QlMjJkZWVwc2V0JTJGcm9iZXJ0YS1iYXNlLXNxdWFkMiUyMiUyQyUyMGFjY2VsZXJhdG9yJTNEJTIyb3J0JTIyKSUwQXF1ZXN0aW9uJTIwJTNEJTIwJTIyV2hhdCdzJTIwbXklMjBuYW1lJTNGJTIyJTBBY29udGV4dCUyMCUzRCUyMCUyMk15JTIwbmFtZSUyMGlzJTIwUGhpbGlwcCUyMGFuZCUyMEklMjBsaXZlJTIwaW4lMjBOdXJlbWJlcmcuJTIyJTBBJTBBcHJlZCUyMCUzRCUyMG9ubnhfcWEocXVlc3Rpb24lM0RxdWVzdGlvbiUyQyUyMGNvbnRleHQlM0Rjb250ZXh0KQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.pipelines <span class="hljs-keyword">import</span> pipeline

<span class="hljs-comment"># The model will be loaded to an ORTModelForQuestionAnswering.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>onnx_qa = pipeline(<span class="hljs-string">&quot;question-answering&quot;</span>, model=<span class="hljs-string">&quot;deepset/roberta-base-squad2&quot;</span>, accelerator=<span class="hljs-string">&quot;ort&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>question = <span class="hljs-string">&quot;What&#x27;s my name?&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>context = <span class="hljs-string">&quot;My name is Philipp and I live in Nuremberg.&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>pred = onnx_qa(question=question, context=context)`,wrap:!1}}),_=new Z({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVE1vZGVsRm9yUXVlc3Rpb25BbnN3ZXJpbmclMEFmcm9tJTIwb3B0aW11bS5waXBlbGluZXMlMjBpbXBvcnQlMjBwaXBlbGluZSUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmRlZXBzZXQlMkZyb2JlcnRhLWJhc2Utc3F1YWQyJTIyKSUwQSUwQSUyMyUyMExvYWRpbmclMjB0aGUlMjBQeVRvcmNoJTIwY2hlY2twb2ludCUyMGFuZCUyMGNvbnZlcnRpbmclMjB0byUyMHRoZSUyME9OTlglMjBmb3JtYXQlMjBieSUyMHByb3ZpZGluZyUwQSUyMyUyMGV4cG9ydCUzRFRydWUlMEFtb2RlbCUyMCUzRCUyME9SVE1vZGVsRm9yUXVlc3Rpb25BbnN3ZXJpbmcuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMmRlZXBzZXQlMkZyb2JlcnRhLWJhc2Utc3F1YWQyJTIyJTJDJTBBJTIwJTIwJTIwJTIwZXhwb3J0JTNEVHJ1ZSUwQSklMEElMEFvbm54X3FhJTIwJTNEJTIwcGlwZWxpbmUoJTIycXVlc3Rpb24tYW5zd2VyaW5nJTIyJTJDJTIwbW9kZWwlM0Rtb2RlbCUyQyUyMHRva2VuaXplciUzRHRva2VuaXplciUyQyUyMGFjY2VsZXJhdG9yJTNEJTIyb3J0JTIyKSUwQXF1ZXN0aW9uJTIwJTNEJTIwJTIyV2hhdCdzJTIwbXklMjBuYW1lJTNGJTIyJTBBY29udGV4dCUyMCUzRCUyMCUyMk15JTIwbmFtZSUyMGlzJTIwUGhpbGlwcCUyMGFuZCUyMEklMjBsaXZlJTIwaW4lMjBOdXJlbWJlcmcuJTIyJTBBJTBBcHJlZCUyMCUzRCUyMG9ubnhfcWEocXVlc3Rpb24lM0RxdWVzdGlvbiUyQyUyMGNvbnRleHQlM0Rjb250ZXh0KQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForQuestionAnswering
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.pipelines <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;deepset/roberta-base-squad2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading the PyTorch checkpoint and converting to the ONNX format by providing</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># export=True</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForQuestionAnswering.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;deepset/roberta-base-squad2&quot;</span>,
<span class="hljs-meta">... </span>    export=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>onnx_qa = pipeline(<span class="hljs-string">&quot;question-answering&quot;</span>, model=model, tokenizer=tokenizer, accelerator=<span class="hljs-string">&quot;ort&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>question = <span class="hljs-string">&quot;What&#x27;s my name?&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>context = <span class="hljs-string">&quot;My name is Philipp and I live in Nuremberg.&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>pred = onnx_qa(question=question, context=context)`,wrap:!1}}),F=new et({props:{title:"Using Optimum models",local:"using-optimum-models",headingTag:"h3"}}),Q=new Z({props:{code:"ZnJvbSUyMG9wdGltdW0ucGlwZWxpbmVzJTIwaW1wb3J0JTIwcGlwZWxpbmUlMEElMEFvbm54X3FhJTIwJTNEJTIwcGlwZWxpbmUoJTIycXVlc3Rpb24tYW5zd2VyaW5nJTIyJTJDJTIwbW9kZWwlM0QlMjJvcHRpbXVtJTJGcm9iZXJ0YS1iYXNlLXNxdWFkMiUyMiUyQyUyMGFjY2VsZXJhdG9yJTNEJTIyb3J0JTIyKSUwQXF1ZXN0aW9uJTIwJTNEJTIwJTIyV2hhdCdzJTIwbXklMjBuYW1lJTNGJTIyJTBBY29udGV4dCUyMCUzRCUyMCUyMk15JTIwbmFtZSUyMGlzJTIwUGhpbGlwcCUyMGFuZCUyMEklMjBsaXZlJTIwaW4lMjBOdXJlbWJlcmcuJTIyJTBBJTBBcHJlZCUyMCUzRCUyMG9ubnhfcWEocXVlc3Rpb24lM0RxdWVzdGlvbiUyQyUyMGNvbnRleHQlM0Rjb250ZXh0KQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.pipelines <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>onnx_qa = pipeline(<span class="hljs-string">&quot;question-answering&quot;</span>, model=<span class="hljs-string">&quot;optimum/roberta-base-squad2&quot;</span>, accelerator=<span class="hljs-string">&quot;ort&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>question = <span class="hljs-string">&quot;What&#x27;s my name?&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>context = <span class="hljs-string">&quot;My name is Philipp and I live in Nuremberg.&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>pred = onnx_qa(question=question, context=context)`,wrap:!1}}),S=new Z({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVE1vZGVsRm9yUXVlc3Rpb25BbnN3ZXJpbmclMEFmcm9tJTIwb3B0aW11bS5waXBlbGluZXMlMjBpbXBvcnQlMjBwaXBlbGluZSUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZyb2JlcnRhLWJhc2Utc3F1YWQyJTIyKSUwQSUwQSUyMyUyMExvYWRpbmclMjBkaXJlY3RseSUyMGFuJTIwT05OWCUyMG1vZGVsJTIwZnJvbSUyMGElMjBtb2RlbCUyMHJlcG8uJTBBbW9kZWwlMjAlM0QlMjBPUlRNb2RlbEZvclF1ZXN0aW9uQW5zd2VyaW5nLmZyb21fcHJldHJhaW5lZCglMjJvcHRpbXVtJTJGcm9iZXJ0YS1iYXNlLXNxdWFkMiUyMiklMEElMEFvbm54X3FhJTIwJTNEJTIwcGlwZWxpbmUoJTIycXVlc3Rpb24tYW5zd2VyaW5nJTIyJTJDJTIwbW9kZWwlM0Rtb2RlbCUyQyUyMHRva2VuaXplciUzRHRva2VuaXplciUyQyUyMGFjY2VsZXJhdG9yJTNEJTIyb3J0JTIyKSUwQXF1ZXN0aW9uJTIwJTNEJTIwJTIyV2hhdCdzJTIwbXklMjBuYW1lJTNGJTIyJTBBY29udGV4dCUyMCUzRCUyMCUyMk15JTIwbmFtZSUyMGlzJTIwUGhpbGlwcCUyMGFuZCUyMEklMjBsaXZlJTIwaW4lMjBOdXJlbWJlcmcuJTIyJTBBJTBBcHJlZCUyMCUzRCUyMG9ubnhfcWEocXVlc3Rpb24lM0RxdWVzdGlvbiUyQyUyMGNvbnRleHQlM0Rjb250ZXh0KQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForQuestionAnswering
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.pipelines <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/roberta-base-squad2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading directly an ONNX model from a model repo.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForQuestionAnswering.from_pretrained(<span class="hljs-string">&quot;optimum/roberta-base-squad2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>onnx_qa = pipeline(<span class="hljs-string">&quot;question-answering&quot;</span>, model=model, tokenizer=tokenizer, accelerator=<span class="hljs-string">&quot;ort&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>question = <span class="hljs-string">&quot;What&#x27;s my name?&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>context = <span class="hljs-string">&quot;My name is Philipp and I live in Nuremberg.&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>pred = onnx_qa(question=question, context=context)`,wrap:!1}}),Y=new et({props:{title:"Optimizing and quantizing in pipelines",local:"optimizing-and-quantizing-in-pipelines",headingTag:"h2"}}),A=new et({props:{title:"Quantizing with the ORTQuantizer",local:"quantizing-with-the-ortquantizer",headingTag:"h3"}}),P=new Z({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> (
<span class="hljs-meta">... </span>    AutoQuantizationConfig,
<span class="hljs-meta">... </span>    ORTModelForSequenceClassification,
<span class="hljs-meta">... </span>    ORTQuantizer
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.pipelines <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Load the tokenizer and export the model to the ONNX format</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model_id = <span class="hljs-string">&quot;distilbert-base-uncased-finetuned-sst-2-english&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>save_dir = <span class="hljs-string">&quot;distilbert_quantized&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForSequenceClassification.from_pretrained(model_id, export=<span class="hljs-literal">True</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Load the quantization configuration detailing the quantization we wish to apply</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>qconfig = AutoQuantizationConfig.avx512_vnni(is_static=<span class="hljs-literal">False</span>, per_channel=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>quantizer = ORTQuantizer.from_pretrained(model)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Apply dynamic quantization and save the resulting model</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>quantizer.quantize(save_dir=save_dir, quantization_config=qconfig)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Load the quantized model from a local repository</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForSequenceClassification.from_pretrained(save_dir)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Create the transformers pipeline</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>onnx_clx = pipeline(<span class="hljs-string">&quot;text-classification&quot;</span>, model=model, accelerator=<span class="hljs-string">&quot;ort&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>text = <span class="hljs-string">&quot;I like the new ORT pipeline&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pred = onnx_clx(text)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(pred)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [{&#x27;label&#x27;: &#x27;POSITIVE&#x27;, &#x27;score&#x27;: 0.9974810481071472}]</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Save and push the model to the hub (in practice save_dir could be used here instead)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model.save_pretrained(<span class="hljs-string">&quot;new_path_for_directory&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.push_to_hub(<span class="hljs-string">&quot;new_path_for_directory&quot;</span>, repository_id=<span class="hljs-string">&quot;my-onnx-repo&quot;</span>, use_auth_token=<span class="hljs-literal">True</span>)`,wrap:!1}}),K=new et({props:{title:"Optimizing with ORTOptimizer",local:"optimizing-with-ortoptimizer",headingTag:"h3"}}),D=new Z({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> (
<span class="hljs-meta">... </span>    AutoOptimizationConfig,
<span class="hljs-meta">... </span>    ORTModelForSequenceClassification,
<span class="hljs-meta">... </span>    ORTOptimizer
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime.configuration <span class="hljs-keyword">import</span> OptimizationConfig
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.pipelines <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Load the tokenizer and export the model to the ONNX format</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model_id = <span class="hljs-string">&quot;distilbert-base-uncased-finetuned-sst-2-english&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>save_dir = <span class="hljs-string">&quot;distilbert_optimized&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(model_id)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForSequenceClassification.from_pretrained(model_id, export=<span class="hljs-literal">True</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Load the optimization configuration detailing the optimization we wish to apply</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>optimization_config = AutoOptimizationConfig.O3()
<span class="hljs-meta">&gt;&gt;&gt; </span>optimizer = ORTOptimizer.from_pretrained(model)

<span class="hljs-meta">&gt;&gt;&gt; </span>optimizer.optimize(save_dir=save_dir, optimization_config=optimization_config)
<span class="hljs-comment"># Load the optimized model from a local repository</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForSequenceClassification.from_pretrained(save_dir)

<span class="hljs-comment"># Create the transformers pipeline</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>onnx_clx = pipeline(<span class="hljs-string">&quot;text-classification&quot;</span>, model=model, accelerator=<span class="hljs-string">&quot;ort&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>text = <span class="hljs-string">&quot;I like the new ORT pipeline&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pred = onnx_clx(text)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(pred)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [{&#x27;label&#x27;: &#x27;POSITIVE&#x27;, &#x27;score&#x27;: 0.9973127245903015}]</span>

<span class="hljs-comment"># Save and push the model to the hub</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.save_pretrained(<span class="hljs-string">&quot;new_path_for_directory&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.save_pretrained(<span class="hljs-string">&quot;new_path_for_directory&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.push_to_hub(<span class="hljs-string">&quot;new_path_for_directory&quot;</span>, repository_id=<span class="hljs-string">&quot;my-onnx-repo&quot;</span>, use_auth_token=<span class="hljs-literal">True</span>)`,wrap:!1}}),tt=new ue({props:{source:"https://github.com/huggingface/optimum/blob/main/docs/source/onnxruntime/usage_guides/pipelines.mdx"}}),{c(){p=i("meta"),w=a(),y=i("p"),M=a(),c(b.$$.fragment),T=a(),J=i("p"),J.innerHTML=qt,at=a(),c(j.$$.fragment),nt=a(),W=i("p"),W.textContent=_t,pt=a(),X=i("ul"),X.innerHTML=Ft,it=a(),c(I.$$.fragment),ot=a(),G=i("p"),G.innerHTML=Nt,mt=a(),R=i("ol"),R.innerHTML=Qt,ct=a(),c(B.$$.fragment),rt=a(),U=i("ol"),U.innerHTML=Et,ut=a(),c(v.$$.fragment),dt=a(),x=i("p"),x.innerHTML=Ht,ht=a(),c(k.$$.fragment),gt=a(),z=i("p"),z.innerHTML=St,yt=a(),c(f.$$.fragment),Mt=a(),V=i("p"),V.innerHTML=Yt,Tt=a(),c(C.$$.fragment),Jt=a(),$=i("p"),$.innerHTML=Ot,wt=a(),q=i("p"),q.innerHTML=Lt,bt=a(),c(_.$$.fragment),jt=a(),c(F.$$.fragment),Ut=a(),N=i("p"),N.innerHTML=At,ft=a(),c(Q.$$.fragment),Zt=a(),E=i("p"),E.innerHTML=Pt,Wt=a(),H=i("p"),H.innerHTML=Kt,Xt=a(),c(S.$$.fragment),It=a(),c(Y.$$.fragment),Gt=a(),O=i("p"),O.innerHTML=Dt,Rt=a(),L=i("p"),L.innerHTML=te,Bt=a(),c(A.$$.fragment),vt=a(),c(P.$$.fragment),xt=a(),c(K.$$.fragment),kt=a(),c(D.$$.fragment),zt=a(),c(tt.$$.fragment),Vt=a(),lt=i("p"),this.h()},l(t){const e=ce("svelte-u9bgzb",document.head);p=o(e,"META",{name:!0,content:!0}),e.forEach(s),w=n(t),y=o(t,"P",{}),le(y).forEach(s),M=n(t),r(b.$$.fragment,t),T=n(t),J=o(t,"P",{"data-svelte-h":!0}),m(J)!=="svelte-grle1x"&&(J.innerHTML=qt),at=n(t),r(j.$$.fragment,t),nt=n(t),W=o(t,"P",{"data-svelte-h":!0}),m(W)!=="svelte-1rl24tl"&&(W.textContent=_t),pt=n(t),X=o(t,"UL",{"data-svelte-h":!0}),m(X)!=="svelte-izhwi1"&&(X.innerHTML=Ft),it=n(t),r(I.$$.fragment,t),ot=n(t),G=o(t,"P",{"data-svelte-h":!0}),m(G)!=="svelte-j14w9v"&&(G.innerHTML=Nt),mt=n(t),R=o(t,"OL",{"data-svelte-h":!0}),m(R)!=="svelte-khfcvb"&&(R.innerHTML=Qt),ct=n(t),r(B.$$.fragment,t),rt=n(t),U=o(t,"OL",{start:!0,"data-svelte-h":!0}),m(U)!=="svelte-8j6vxl"&&(U.innerHTML=Et),ut=n(t),r(v.$$.fragment,t),dt=n(t),x=o(t,"P",{"data-svelte-h":!0}),m(x)!=="svelte-1o2tkpw"&&(x.innerHTML=Ht),ht=n(t),r(k.$$.fragment,t),gt=n(t),z=o(t,"P",{"data-svelte-h":!0}),m(z)!=="svelte-ddng3e"&&(z.innerHTML=St),yt=n(t),r(f.$$.fragment,t),Mt=n(t),V=o(t,"P",{"data-svelte-h":!0}),m(V)!=="svelte-1ig4n3p"&&(V.innerHTML=Yt),Tt=n(t),r(C.$$.fragment,t),Jt=n(t),$=o(t,"P",{"data-svelte-h":!0}),m($)!=="svelte-5dusol"&&($.innerHTML=Ot),wt=n(t),q=o(t,"P",{"data-svelte-h":!0}),m(q)!=="svelte-exy20s"&&(q.innerHTML=Lt),bt=n(t),r(_.$$.fragment,t),jt=n(t),r(F.$$.fragment,t),Ut=n(t),N=o(t,"P",{"data-svelte-h":!0}),m(N)!=="svelte-1m41zua"&&(N.innerHTML=At),ft=n(t),r(Q.$$.fragment,t),Zt=n(t),E=o(t,"P",{"data-svelte-h":!0}),m(E)!=="svelte-uqjek2"&&(E.innerHTML=Pt),Wt=n(t),H=o(t,"P",{"data-svelte-h":!0}),m(H)!=="svelte-exy20s"&&(H.innerHTML=Kt),Xt=n(t),r(S.$$.fragment,t),It=n(t),r(Y.$$.fragment,t),Gt=n(t),O=o(t,"P",{"data-svelte-h":!0}),m(O)!=="svelte-ztts0r"&&(O.innerHTML=Dt),Rt=n(t),L=o(t,"P",{"data-svelte-h":!0}),m(L)!=="svelte-evmgrx"&&(L.innerHTML=te),Bt=n(t),r(A.$$.fragment,t),vt=n(t),r(P.$$.fragment,t),xt=n(t),r(K.$$.fragment,t),kt=n(t),r(D.$$.fragment,t),zt=n(t),r(tt.$$.fragment,t),Vt=n(t),lt=o(t,"P",{}),le(lt).forEach(s),this.h()},h(){$t(p,"name","hf:doc:metadata"),$t(p,"content",ye),$t(U,"start","2")},m(t,e){re(document.head,p),l(t,w,e),l(t,y,e),l(t,M,e),u(b,t,e),l(t,T,e),l(t,J,e),l(t,at,e),u(j,t,e),l(t,nt,e),l(t,W,e),l(t,pt,e),l(t,X,e),l(t,it,e),u(I,t,e),l(t,ot,e),l(t,G,e),l(t,mt,e),l(t,R,e),l(t,ct,e),u(B,t,e),l(t,rt,e),l(t,U,e),l(t,ut,e),u(v,t,e),l(t,dt,e),l(t,x,e),l(t,ht,e),u(k,t,e),l(t,gt,e),l(t,z,e),l(t,yt,e),u(f,t,e),l(t,Mt,e),l(t,V,e),l(t,Tt,e),u(C,t,e),l(t,Jt,e),l(t,$,e),l(t,wt,e),l(t,q,e),l(t,bt,e),u(_,t,e),l(t,jt,e),u(F,t,e),l(t,Ut,e),l(t,N,e),l(t,ft,e),u(Q,t,e),l(t,Zt,e),l(t,E,e),l(t,Wt,e),l(t,H,e),l(t,Xt,e),u(S,t,e),l(t,It,e),u(Y,t,e),l(t,Gt,e),l(t,O,e),l(t,Rt,e),l(t,L,e),l(t,Bt,e),u(A,t,e),l(t,vt,e),u(P,t,e),l(t,xt,e),u(K,t,e),l(t,kt,e),u(D,t,e),l(t,zt,e),u(tt,t,e),l(t,Vt,e),l(t,lt,e),Ct=!0},p(t,[e]){const ee={};e&2&&(ee.$$scope={dirty:e,ctx:t}),j.$set(ee);const se={};e&2&&(se.$$scope={dirty:e,ctx:t}),f.$set(se)},i(t){Ct||(d(b.$$.fragment,t),d(j.$$.fragment,t),d(I.$$.fragment,t),d(B.$$.fragment,t),d(v.$$.fragment,t),d(k.$$.fragment,t),d(f.$$.fragment,t),d(C.$$.fragment,t),d(_.$$.fragment,t),d(F.$$.fragment,t),d(Q.$$.fragment,t),d(S.$$.fragment,t),d(Y.$$.fragment,t),d(A.$$.fragment,t),d(P.$$.fragment,t),d(K.$$.fragment,t),d(D.$$.fragment,t),d(tt.$$.fragment,t),Ct=!0)},o(t){h(b.$$.fragment,t),h(j.$$.fragment,t),h(I.$$.fragment,t),h(B.$$.fragment,t),h(v.$$.fragment,t),h(k.$$.fragment,t),h(f.$$.fragment,t),h(C.$$.fragment,t),h(_.$$.fragment,t),h(F.$$.fragment,t),h(Q.$$.fragment,t),h(S.$$.fragment,t),h(Y.$$.fragment,t),h(A.$$.fragment,t),h(P.$$.fragment,t),h(K.$$.fragment,t),h(D.$$.fragment,t),h(tt.$$.fragment,t),Ct=!1},d(t){t&&(s(w),s(y),s(M),s(T),s(J),s(at),s(nt),s(W),s(pt),s(X),s(it),s(ot),s(G),s(mt),s(R),s(ct),s(rt),s(U),s(ut),s(dt),s(x),s(ht),s(gt),s(z),s(yt),s(Mt),s(V),s(Tt),s(Jt),s($),s(wt),s(q),s(bt),s(jt),s(Ut),s(N),s(ft),s(Zt),s(E),s(Wt),s(H),s(Xt),s(It),s(Gt),s(O),s(Rt),s(L),s(Bt),s(vt),s(xt),s(kt),s(zt),s(Vt),s(lt)),s(p),g(b,t),g(j,t),g(I,t),g(B,t),g(v,t),g(k,t),g(f,t),g(C,t),g(_,t),g(F,t),g(Q,t),g(S,t),g(Y,t),g(A,t),g(P,t),g(K,t),g(D,t),g(tt,t)}}}const ye='{"title":"Inference pipelines with the ONNX Runtime accelerator","local":"inference-pipelines-with-the-onnx-runtime-accelerator","sections":[{"title":"Optimum pipeline usage","local":"optimum-pipeline-usage","sections":[{"title":"Using vanilla Transformers model and converting to ONNX","local":"using-vanilla-transformers-model-and-converting-to-onnx","sections":[],"depth":3},{"title":"Using Optimum models","local":"using-optimum-models","sections":[],"depth":3}],"depth":2},{"title":"Optimizing and quantizing in pipelines","local":"optimizing-and-quantizing-in-pipelines","sections":[{"title":"Quantizing with the ORTQuantizer","local":"quantizing-with-the-ortquantizer","sections":[],"depth":3},{"title":"Optimizing with ORTOptimizer","local":"optimizing-with-ortoptimizer","sections":[],"depth":3}],"depth":2}],"depth":1}';function Me(st){return ie(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ue extends oe{constructor(p){super(),me(this,p,Me,ge,pe,{})}}export{Ue as component};
