import{s as fn,o as un,n as Ge}from"../chunks/scheduler.8c3d61f6.js";import{S as _n,i as hn,g as l,s as i,r as f,A as bn,h as p,f as n,c as s,j,u,x as g,k as P,y as t,a as d,v as _,d as h,t as b,w as y}from"../chunks/index.da70eac4.js";import{T as gn}from"../chunks/Tip.1d9b8c37.js";import{D as k}from"../chunks/Docstring.6b390b9a.js";import{C as zt}from"../chunks/CodeBlock.00a903b3.js";import{E as Wt}from"../chunks/ExampleCodeBlock.db12be95.js";import{H as ze,E as yn}from"../chunks/EditOnGithub.1e64e623.js";function vn(J){let a,I='🧪 Many of the SDXL ControlNet checkpoints are experimental, and there is a lot of room for improvement. Feel free to open an <a href="https://github.com/huggingface/diffusers/issues/new/choose" rel="nofollow">Issue</a> and leave us feedback on how we can improve!';return{c(){a=l("p"),a.innerHTML=I},l(c){a=p(c,"P",{"data-svelte-h":!0}),g(a)!=="svelte-1q1xjpk"&&(a.innerHTML=I)},m(c,m){d(c,a,m)},p:Ge,d(c){c&&n(a)}}}function wn(J){let a,I='Make sure to check out the Schedulers <a href="../../using-diffusers/schedulers">guide</a> to learn how to explore the tradeoff between scheduler speed and quality, and see the <a href="../../using-diffusers/loading#reuse-components-across-pipelines">reuse components across pipelines</a> section to learn how to efficiently load the same components into multiple pipelines.';return{c(){a=l("p"),a.innerHTML=I},l(c){a=p(c,"P",{"data-svelte-h":!0}),g(a)!=="svelte-1wmc0l4"&&(a.innerHTML=I)},m(c,m){d(c,a,m)},p:Ge,d(c){c&&n(a)}}}function In(J){let a,I="Examples:",c,m,v;return m=new zt({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># !pip install opencv-python transformers accelerate</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionXLControlNetPipeline, ControlNetModel, AutoencoderKL
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> cv2
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;aerial view, a futuristic research complex in a bright foggy jungle, hard lighting&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>negative_prompt = <span class="hljs-string">&quot;low quality, bad quality, sketches&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># download an image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = load_image(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://hf.co/datasets/hf-internal-testing/diffusers-images/resolve/main/sd_controlnet/hf-logo.png&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># initialize the models and pipeline</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>controlnet_conditioning_scale = <span class="hljs-number">0.5</span>  <span class="hljs-comment"># recommended for good generalization</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>controlnet = ControlNetModel.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;diffusers/controlnet-canny-sdxl-1.0&quot;</span>, torch_dtype=torch.float16
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>vae = AutoencoderKL.from_pretrained(<span class="hljs-string">&quot;madebyollin/sdxl-vae-fp16-fix&quot;</span>, torch_dtype=torch.float16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = StableDiffusionXLControlNetPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>, controlnet=controlnet, vae=vae, torch_dtype=torch.float16
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.enable_model_cpu_offload()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># get canny image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = np.array(image)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = cv2.Canny(image, <span class="hljs-number">100</span>, <span class="hljs-number">200</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = image[:, :, <span class="hljs-literal">None</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>image = np.concatenate([image, image, image], axis=<span class="hljs-number">2</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>canny_image = Image.fromarray(image)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># generate image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(
<span class="hljs-meta">... </span>    prompt, controlnet_conditioning_scale=controlnet_conditioning_scale, image=canny_image
<span class="hljs-meta">... </span>).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){a=l("p"),a.textContent=I,c=i(),f(m.$$.fragment)},l(r){a=p(r,"P",{"data-svelte-h":!0}),g(a)!=="svelte-kvfsh7"&&(a.textContent=I),c=s(r),u(m.$$.fragment,r)},m(r,M){d(r,a,M),d(r,c,M),_(m,r,M),v=!0},p:Ge,i(r){v||(h(m.$$.fragment,r),v=!0)},o(r){b(m.$$.fragment,r),v=!1},d(r){r&&(n(a),n(c)),y(m,r)}}}function Mn(J){let a,I="Examples:",c,m,v;return m=new zt({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># pip install accelerate transformers safetensors diffusers</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> DPTImageProcessor, DPTForDepthEstimation
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> ControlNetModel, StableDiffusionXLControlNetImg2ImgPipeline, AutoencoderKL
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image


<span class="hljs-meta">&gt;&gt;&gt; </span>depth_estimator = DPTForDepthEstimation.from_pretrained(<span class="hljs-string">&quot;Intel/dpt-hybrid-midas&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>feature_extractor = DPTImageProcessor.from_pretrained(<span class="hljs-string">&quot;Intel/dpt-hybrid-midas&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>controlnet = ControlNetModel.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;diffusers/controlnet-depth-sdxl-1.0-small&quot;</span>,
<span class="hljs-meta">... </span>    variant=<span class="hljs-string">&quot;fp16&quot;</span>,
<span class="hljs-meta">... </span>    use_safetensors=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    torch_dtype=torch.float16,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>vae = AutoencoderKL.from_pretrained(<span class="hljs-string">&quot;madebyollin/sdxl-vae-fp16-fix&quot;</span>, torch_dtype=torch.float16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = StableDiffusionXLControlNetImg2ImgPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>,
<span class="hljs-meta">... </span>    controlnet=controlnet,
<span class="hljs-meta">... </span>    vae=vae,
<span class="hljs-meta">... </span>    variant=<span class="hljs-string">&quot;fp16&quot;</span>,
<span class="hljs-meta">... </span>    use_safetensors=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    torch_dtype=torch.float16,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.enable_model_cpu_offload()


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">get_depth_map</span>(<span class="hljs-params">image</span>):
<span class="hljs-meta">... </span>    image = feature_extractor(images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).pixel_values.to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">with</span> torch.no_grad(), torch.autocast(<span class="hljs-string">&quot;cuda&quot;</span>):
<span class="hljs-meta">... </span>        depth_map = depth_estimator(image).predicted_depth

<span class="hljs-meta">... </span>    depth_map = torch.nn.functional.interpolate(
<span class="hljs-meta">... </span>        depth_map.unsqueeze(<span class="hljs-number">1</span>),
<span class="hljs-meta">... </span>        size=(<span class="hljs-number">1024</span>, <span class="hljs-number">1024</span>),
<span class="hljs-meta">... </span>        mode=<span class="hljs-string">&quot;bicubic&quot;</span>,
<span class="hljs-meta">... </span>        align_corners=<span class="hljs-literal">False</span>,
<span class="hljs-meta">... </span>    )
<span class="hljs-meta">... </span>    depth_min = torch.amin(depth_map, dim=[<span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>], keepdim=<span class="hljs-literal">True</span>)
<span class="hljs-meta">... </span>    depth_max = torch.amax(depth_map, dim=[<span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>], keepdim=<span class="hljs-literal">True</span>)
<span class="hljs-meta">... </span>    depth_map = (depth_map - depth_min) / (depth_max - depth_min)
<span class="hljs-meta">... </span>    image = torch.cat([depth_map] * <span class="hljs-number">3</span>, dim=<span class="hljs-number">1</span>)
<span class="hljs-meta">... </span>    image = image.permute(<span class="hljs-number">0</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">1</span>).cpu().numpy()[<span class="hljs-number">0</span>]
<span class="hljs-meta">... </span>    image = Image.fromarray((image * <span class="hljs-number">255.0</span>).clip(<span class="hljs-number">0</span>, <span class="hljs-number">255</span>).astype(np.uint8))
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> image


<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;A robot, 4k photo&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = load_image(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/datasets/hf-internal-testing/diffusers-images/resolve/main&quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;/kandinsky/cat.png&quot;</span>
<span class="hljs-meta">... </span>).resize((<span class="hljs-number">1024</span>, <span class="hljs-number">1024</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span>controlnet_conditioning_scale = <span class="hljs-number">0.5</span>  <span class="hljs-comment"># recommended for good generalization</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>depth_image = get_depth_map(image)

<span class="hljs-meta">&gt;&gt;&gt; </span>images = pipe(
<span class="hljs-meta">... </span>    prompt,
<span class="hljs-meta">... </span>    image=image,
<span class="hljs-meta">... </span>    control_image=depth_image,
<span class="hljs-meta">... </span>    strength=<span class="hljs-number">0.99</span>,
<span class="hljs-meta">... </span>    num_inference_steps=<span class="hljs-number">50</span>,
<span class="hljs-meta">... </span>    controlnet_conditioning_scale=controlnet_conditioning_scale,
<span class="hljs-meta">... </span>).images
<span class="hljs-meta">&gt;&gt;&gt; </span>images[<span class="hljs-number">0</span>].save(<span class="hljs-string">f&quot;robot_cat.png&quot;</span>)`,wrap:!1}}),{c(){a=l("p"),a.textContent=I,c=i(),f(m.$$.fragment)},l(r){a=p(r,"P",{"data-svelte-h":!0}),g(a)!=="svelte-kvfsh7"&&(a.textContent=I),c=s(r),u(m.$$.fragment,r)},m(r,M){d(r,a,M),d(r,c,M),_(m,r,M),v=!0},p:Ge,i(r){v||(h(m.$$.fragment,r),v=!0)},o(r){b(m.$$.fragment,r),v=!1},d(r){r&&(n(a),n(c)),y(m,r)}}}function Tn(J){let a,I="Examples:",c,m,v;return m=new zt({props:{code:"JTIzJTIwIXBpcCUyMGluc3RhbGwlMjB0cmFuc2Zvcm1lcnMlMjBhY2NlbGVyYXRlJTBBZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblhMQ29udHJvbE5ldElucGFpbnRQaXBlbGluZSUyQyUyMENvbnRyb2xOZXRNb2RlbCUyQyUyMERESU1TY2hlZHVsZXIlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbG9hZF9pbWFnZSUwQWZyb20lMjBQSUwlMjBpbXBvcnQlMjBJbWFnZSUwQWltcG9ydCUyMG51bXB5JTIwYXMlMjBucCUwQWltcG9ydCUyMHRvcmNoJTBBJTBBaW5pdF9pbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UoJTBBJTIwJTIwJTIwJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGZGlmZnVzZXJzJTJGdGVzdC1hcnJheXMlMkZyZXNvbHZlJTJGbWFpbiUyRnN0YWJsZV9kaWZmdXNpb25faW5wYWludCUyRmJveS5wbmclMjIlMEEpJTBBaW5pdF9pbWFnZSUyMCUzRCUyMGluaXRfaW1hZ2UucmVzaXplKCgxMDI0JTJDJTIwMTAyNCkpJTBBJTBBZ2VuZXJhdG9yJTIwJTNEJTIwdG9yY2guR2VuZXJhdG9yKGRldmljZSUzRCUyMmNwdSUyMikubWFudWFsX3NlZWQoMSklMEElMEFtYXNrX2ltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZSglMEElMjAlMjAlMjAlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZkaWZmdXNlcnMlMkZ0ZXN0LWFycmF5cyUyRnJlc29sdmUlMkZtYWluJTJGc3RhYmxlX2RpZmZ1c2lvbl9pbnBhaW50JTJGYm95X21hc2sucG5nJTIyJTBBKSUwQW1hc2tfaW1hZ2UlMjAlM0QlMjBtYXNrX2ltYWdlLnJlc2l6ZSgoMTAyNCUyQyUyMDEwMjQpKSUwQSUwQSUwQWRlZiUyMG1ha2VfY2FubnlfY29uZGl0aW9uKGltYWdlKSUzQSUwQSUyMCUyMCUyMCUyMGltYWdlJTIwJTNEJTIwbnAuYXJyYXkoaW1hZ2UpJTBBJTIwJTIwJTIwJTIwaW1hZ2UlMjAlM0QlMjBjdjIuQ2FubnkoaW1hZ2UlMkMlMjAxMDAlMkMlMjAyMDApJTBBJTIwJTIwJTIwJTIwaW1hZ2UlMjAlM0QlMjBpbWFnZSU1QiUzQSUyQyUyMCUzQSUyQyUyME5vbmUlNUQlMEElMjAlMjAlMjAlMjBpbWFnZSUyMCUzRCUyMG5wLmNvbmNhdGVuYXRlKCU1QmltYWdlJTJDJTIwaW1hZ2UlMkMlMjBpbWFnZSU1RCUyQyUyMGF4aXMlM0QyKSUwQSUyMCUyMCUyMCUyMGltYWdlJTIwJTNEJTIwSW1hZ2UuZnJvbWFycmF5KGltYWdlKSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMGltYWdlJTBBJTBBJTBBY29udHJvbF9pbWFnZSUyMCUzRCUyMG1ha2VfY2FubnlfY29uZGl0aW9uKGluaXRfaW1hZ2UpJTBBJTBBY29udHJvbG5ldCUyMCUzRCUyMENvbnRyb2xOZXRNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyZGlmZnVzZXJzJTJGY29udHJvbG5ldC1jYW5ueS1zZHhsLTEuMCUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUwQSklMEFwaXBlJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uWExDb250cm9sTmV0SW5wYWludFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24teGwtYmFzZS0xLjAlMjIlMkMlMjBjb250cm9sbmV0JTNEY29udHJvbG5ldCUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUwQSklMEElMEFwaXBlLmVuYWJsZV9tb2RlbF9jcHVfb2ZmbG9hZCgpJTBBJTBBJTIzJTIwZ2VuZXJhdGUlMjBpbWFnZSUwQWltYWdlJTIwJTNEJTIwcGlwZSglMEElMjAlMjAlMjAlMjAlMjJhJTIwaGFuZHNvbWUlMjBtYW4lMjB3aXRoJTIwcmF5LWJhbiUyMHN1bmdsYXNzZXMlMjIlMkMlMEElMjAlMjAlMjAlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNEMjAlMkMlMEElMjAlMjAlMjAlMjBnZW5lcmF0b3IlM0RnZW5lcmF0b3IlMkMlMEElMjAlMjAlMjAlMjBldGElM0QxLjAlMkMlMEElMjAlMjAlMjAlMjBpbWFnZSUzRGluaXRfaW1hZ2UlMkMlMEElMjAlMjAlMjAlMjBtYXNrX2ltYWdlJTNEbWFza19pbWFnZSUyQyUwQSUyMCUyMCUyMCUyMGNvbnRyb2xfaW1hZ2UlM0Rjb250cm9sX2ltYWdlJTJDJTBBKS5pbWFnZXMlNUIwJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># !pip install transformers accelerate</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionXLControlNetInpaintPipeline, ControlNetModel, DDIMScheduler
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>init_image = load_image(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/datasets/diffusers/test-arrays/resolve/main/stable_diffusion_inpaint/boy.png&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>init_image = init_image.resize((<span class="hljs-number">1024</span>, <span class="hljs-number">1024</span>))

<span class="hljs-meta">&gt;&gt;&gt; </span>generator = torch.Generator(device=<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">1</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>mask_image = load_image(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/datasets/diffusers/test-arrays/resolve/main/stable_diffusion_inpaint/boy_mask.png&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>mask_image = mask_image.resize((<span class="hljs-number">1024</span>, <span class="hljs-number">1024</span>))


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">make_canny_condition</span>(<span class="hljs-params">image</span>):
<span class="hljs-meta">... </span>    image = np.array(image)
<span class="hljs-meta">... </span>    image = cv2.Canny(image, <span class="hljs-number">100</span>, <span class="hljs-number">200</span>)
<span class="hljs-meta">... </span>    image = image[:, :, <span class="hljs-literal">None</span>]
<span class="hljs-meta">... </span>    image = np.concatenate([image, image, image], axis=<span class="hljs-number">2</span>)
<span class="hljs-meta">... </span>    image = Image.fromarray(image)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> image


<span class="hljs-meta">&gt;&gt;&gt; </span>control_image = make_canny_condition(init_image)

<span class="hljs-meta">&gt;&gt;&gt; </span>controlnet = ControlNetModel.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;diffusers/controlnet-canny-sdxl-1.0&quot;</span>, torch_dtype=torch.float16
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = StableDiffusionXLControlNetInpaintPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>, controlnet=controlnet, torch_dtype=torch.float16
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.enable_model_cpu_offload()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># generate image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;a handsome man with ray-ban sunglasses&quot;</span>,
<span class="hljs-meta">... </span>    num_inference_steps=<span class="hljs-number">20</span>,
<span class="hljs-meta">... </span>    generator=generator,
<span class="hljs-meta">... </span>    eta=<span class="hljs-number">1.0</span>,
<span class="hljs-meta">... </span>    image=init_image,
<span class="hljs-meta">... </span>    mask_image=mask_image,
<span class="hljs-meta">... </span>    control_image=control_image,
<span class="hljs-meta">... </span>).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){a=l("p"),a.textContent=I,c=i(),f(m.$$.fragment)},l(r){a=p(r,"P",{"data-svelte-h":!0}),g(a)!=="svelte-kvfsh7"&&(a.textContent=I),c=s(r),u(m.$$.fragment,r)},m(r,M){d(r,a,M),d(r,c,M),_(m,r,M),v=!0},p:Ge,i(r){v||(h(m.$$.fragment,r),v=!0)},o(r){b(m.$$.fragment,r),v=!1},d(r){r&&(n(a),n(c)),y(m,r)}}}function Cn(J){let a,I,c,m,v,r,M,Gt='ControlNet was introduced in <a href="https://huggingface.co/papers/2302.05543" rel="nofollow">Adding Conditional Control to Text-to-Image Diffusion Models</a> by Lvmin Zhang, Anyi Rao, and Maneesh Agrawala.',Be,Y,Bt="With a ControlNet model, you can provide an additional control image to condition and control Stable Diffusion generation. For example, if you provide a depth map, the ControlNet model generates an image that’ll preserve the spatial information from the depth map. It is a more flexible and accurate way to control the image generation process.",$e,V,$t="The abstract from the paper is:",Re,Q,Rt="<em>We present ControlNet, a neural network architecture to add spatial conditioning controls to large, pretrained text-to-image diffusion models. ControlNet locks the production-ready large diffusion models, and reuses their deep and robust encoding layers pretrained with billions of images as a strong backbone to learn a diverse set of conditional controls. The neural architecture is connected with “zero convolutions” (zero-initialized convolution layers) that progressively grow the parameters from zero and ensure that no harmful noise could affect the finetuning. We test various conditioning controls, eg, edges, depth, segmentation, human pose, etc, with Stable Diffusion, using single or multiple conditions, with or without prompts. We show that the training of ControlNets is robust with small (&lt;50k) and large (&gt;1m) datasets. Extensive results show that ControlNet may facilitate wider applications to control image diffusion models.</em>",Ae,O,At='You can find additional smaller Stable Diffusion XL (SDXL) ControlNet checkpoints from the 🤗 <a href="https://huggingface.co/diffusers" rel="nofollow">Diffusers</a> Hub organization, and browse <a href="https://huggingface.co/models?other=stable-diffusion-xl&amp;other=controlnet" rel="nofollow">community-trained</a> checkpoints on the Hub.',Ee,W,Fe,H,Et='If you don’t see a checkpoint you’re interested in, you can train your own SDXL ControlNet with our <a href="../../../../../examples/controlnet/README_sdxl">training script</a>.',Ye,z,Ve,q,Qe,w,K,lt,_e,Ft="Pipeline for text-to-image generation using Stable Diffusion XL with ControlNet guidance.",pt,he,Yt=`This model inherits from <a href="/docs/diffusers/pr_10058/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods
implemented for all pipelines (downloading, saving, running on a particular device, etc.).`,dt,be,Vt="The pipeline also inherits the following loading methods:",ct,ye,Qt='<li><a href="/docs/diffusers/pr_10058/en/api/loaders/textual_inversion#diffusers.loaders.TextualInversionLoaderMixin.load_textual_inversion">load_textual_inversion()</a> for loading textual inversion embeddings</li> <li><a href="/docs/diffusers/pr_10058/en/api/loaders/lora#diffusers.loaders.StableDiffusionXLLoraLoaderMixin.load_lora_weights">load_lora_weights()</a> for loading LoRA weights</li> <li><a href="/docs/diffusers/pr_10058/en/api/loaders/lora#diffusers.loaders.StableDiffusionXLLoraLoaderMixin.save_lora_weights">save_lora_weights()</a> for saving LoRA weights</li> <li><a href="/docs/diffusers/pr_10058/en/api/loaders/single_file#diffusers.loaders.FromSingleFileMixin.from_single_file">from_single_file()</a> for loading <code>.ckpt</code> files</li> <li><a href="/docs/diffusers/pr_10058/en/api/loaders/ip_adapter#diffusers.loaders.IPAdapterMixin.load_ip_adapter">load_ip_adapter()</a> for loading IP Adapters</li>',mt,S,ee,gt,ve,Ot="The call function to the pipeline for generation.",ft,G,ut,B,te,_t,we,Ht="Encodes the prompt into text encoder hidden states.",ht,$,ne,bt,Ie,qt='See <a href="https://github.com/google-research/vdm/blob/dc27b98a554f65cdc654b800da5aa1846545d41b/model_vdm.py#L298" rel="nofollow">https://github.com/google-research/vdm/blob/dc27b98a554f65cdc654b800da5aa1846545d41b/model_vdm.py#L298</a>',Oe,oe,He,T,ie,yt,Me,Kt="Pipeline for image-to-image generation using Stable Diffusion XL with ControlNet guidance.",vt,Te,en=`This model inherits from <a href="/docs/diffusers/pr_10058/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods the
library implements for all the pipelines (such as downloading or saving, running on a particular device, etc.)`,wt,Ce,tn="The pipeline also inherits the following loading methods:",It,xe,nn='<li><a href="/docs/diffusers/pr_10058/en/api/loaders/textual_inversion#diffusers.loaders.TextualInversionLoaderMixin.load_textual_inversion">load_textual_inversion()</a> for loading textual inversion embeddings</li> <li><a href="/docs/diffusers/pr_10058/en/api/loaders/lora#diffusers.loaders.StableDiffusionXLLoraLoaderMixin.load_lora_weights">load_lora_weights()</a> for loading LoRA weights</li> <li><a href="/docs/diffusers/pr_10058/en/api/loaders/lora#diffusers.loaders.StableDiffusionXLLoraLoaderMixin.save_lora_weights">save_lora_weights()</a> for saving LoRA weights</li> <li><a href="/docs/diffusers/pr_10058/en/api/loaders/ip_adapter#diffusers.loaders.IPAdapterMixin.load_ip_adapter">load_ip_adapter()</a> for loading IP Adapters</li>',Mt,D,se,Tt,Le,on="Function invoked when calling the pipeline for generation.",Ct,R,xt,A,ae,Lt,Ne,sn="Encodes the prompt into text encoder hidden states.",qe,re,Ke,C,le,Nt,je,an="Pipeline for text-to-image generation using Stable Diffusion XL.",jt,Pe,rn=`This model inherits from <a href="/docs/diffusers/pr_10058/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods the
library implements for all the pipelines (such as downloading or saving, running on a particular device, etc.)`,Pt,Je,ln="The pipeline also inherits the following loading methods:",Jt,ke,pn='<li><a href="/docs/diffusers/pr_10058/en/api/loaders/textual_inversion#diffusers.loaders.TextualInversionLoaderMixin.load_textual_inversion">load_textual_inversion()</a> for loading textual inversion embeddings</li> <li><a href="/docs/diffusers/pr_10058/en/api/loaders/lora#diffusers.loaders.StableDiffusionXLLoraLoaderMixin.load_lora_weights">load_lora_weights()</a> for loading LoRA weights</li> <li><a href="/docs/diffusers/pr_10058/en/api/loaders/lora#diffusers.loaders.StableDiffusionXLLoraLoaderMixin.save_lora_weights">save_lora_weights()</a> for saving LoRA weights</li> <li><a href="/docs/diffusers/pr_10058/en/api/loaders/single_file#diffusers.loaders.FromSingleFileMixin.from_single_file">from_single_file()</a> for loading <code>.ckpt</code> files</li> <li><a href="/docs/diffusers/pr_10058/en/api/loaders/ip_adapter#diffusers.loaders.IPAdapterMixin.load_ip_adapter">load_ip_adapter()</a> for loading IP Adapters</li>',kt,U,pe,St,Se,dn="Function invoked when calling the pipeline for generation.",Dt,E,Ut,F,de,Xt,De,cn="Encodes the prompt into text encoder hidden states.",et,ce,tt,X,me,Zt,Ue,mn="Output class for Stable Diffusion pipelines.",nt,ge,ot,We,it;return v=new ze({props:{title:"ControlNet with Stable Diffusion XL",local:"controlnet-with-stable-diffusion-xl",headingTag:"h1"}}),W=new gn({props:{warning:!0,$$slots:{default:[vn]},$$scope:{ctx:J}}}),z=new gn({props:{$$slots:{default:[wn]},$$scope:{ctx:J}}}),q=new ze({props:{title:"StableDiffusionXLControlNetPipeline",local:"diffusers.StableDiffusionXLControlNetPipeline",headingTag:"h2"}}),K=new k({props:{name:"class diffusers.StableDiffusionXLControlNetPipeline",anchor:"diffusers.StableDiffusionXLControlNetPipeline",parameters:[{name:"vae",val:": AutoencoderKL"},{name:"text_encoder",val:": CLIPTextModel"},{name:"text_encoder_2",val:": CLIPTextModelWithProjection"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"tokenizer_2",val:": CLIPTokenizer"},{name:"unet",val:": UNet2DConditionModel"},{name:"controlnet",val:": typing.Union[diffusers.models.controlnets.controlnet.ControlNetModel, typing.List[diffusers.models.controlnets.controlnet.ControlNetModel], typing.Tuple[diffusers.models.controlnets.controlnet.ControlNetModel], diffusers.models.controlnets.multicontrolnet.MultiControlNetModel]"},{name:"scheduler",val:": KarrasDiffusionSchedulers"},{name:"force_zeros_for_empty_prompt",val:": bool = True"},{name:"add_watermarker",val:": typing.Optional[bool] = None"},{name:"feature_extractor",val:": CLIPImageProcessor = None"},{name:"image_encoder",val:": CLIPVisionModelWithProjection = None"}],parametersDescription:[{anchor:"diffusers.StableDiffusionXLControlNetPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/pr_10058/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.StableDiffusionXLControlNetPipeline.text_encoder",description:`<strong>text_encoder</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTextModel" rel="nofollow">CLIPTextModel</a>) &#x2014;
Frozen text-encoder (<a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a>).`,name:"text_encoder"},{anchor:"diffusers.StableDiffusionXLControlNetPipeline.text_encoder_2",description:`<strong>text_encoder_2</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTextModelWithProjection" rel="nofollow">CLIPTextModelWithProjection</a>) &#x2014;
Second frozen text-encoder
(<a href="https://huggingface.co/laion/CLIP-ViT-bigG-14-laion2B-39B-b160k" rel="nofollow">laion/CLIP-ViT-bigG-14-laion2B-39B-b160k</a>).`,name:"text_encoder_2"},{anchor:"diffusers.StableDiffusionXLControlNetPipeline.tokenizer",description:`<strong>tokenizer</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>) &#x2014;
A <code>CLIPTokenizer</code> to tokenize text.`,name:"tokenizer"},{anchor:"diffusers.StableDiffusionXLControlNetPipeline.tokenizer_2",description:`<strong>tokenizer_2</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>) &#x2014;
A <code>CLIPTokenizer</code> to tokenize text.`,name:"tokenizer_2"},{anchor:"diffusers.StableDiffusionXLControlNetPipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/pr_10058/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014;
A <code>UNet2DConditionModel</code> to denoise the encoded image latents.`,name:"unet"},{anchor:"diffusers.StableDiffusionXLControlNetPipeline.controlnet",description:`<strong>controlnet</strong> (<a href="/docs/diffusers/pr_10058/en/api/models/controlnet#diffusers.ControlNetModel">ControlNetModel</a> or <code>List[ControlNetModel]</code>) &#x2014;
Provides additional conditioning to the <code>unet</code> during the denoising process. If you set multiple
ControlNets as a list, the outputs from each ControlNet are added together to create one combined
additional conditioning.`,name:"controlnet"},{anchor:"diffusers.StableDiffusionXLControlNetPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/pr_10058/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to denoise the encoded image latents. Can be one of
<a href="/docs/diffusers/pr_10058/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, <a href="/docs/diffusers/pr_10058/en/api/schedulers/lms_discrete#diffusers.LMSDiscreteScheduler">LMSDiscreteScheduler</a>, or <a href="/docs/diffusers/pr_10058/en/api/schedulers/pndm#diffusers.PNDMScheduler">PNDMScheduler</a>.`,name:"scheduler"},{anchor:"diffusers.StableDiffusionXLControlNetPipeline.force_zeros_for_empty_prompt",description:`<strong>force_zeros_for_empty_prompt</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>&quot;True&quot;</code>) &#x2014;
Whether the negative prompt embeddings should always be set to 0. Also see the config of
<code>stabilityai/stable-diffusion-xl-base-1-0</code>.`,name:"force_zeros_for_empty_prompt"},{anchor:"diffusers.StableDiffusionXLControlNetPipeline.add_watermarker",description:`<strong>add_watermarker</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to use the <a href="https://github.com/ShieldMnt/invisible-watermark/" rel="nofollow">invisible_watermark</a> library to
watermark output images. If not defined, it defaults to <code>True</code> if the package is installed; otherwise no
watermarker is used.`,name:"add_watermarker"}],source:"https://github.com/huggingface/diffusers/blob/vr_10058/src/diffusers/pipelines/controlnet/pipeline_controlnet_sd_xl.py#L174"}}),ee=new k({props:{name:"__call__",anchor:"diffusers.StableDiffusionXLControlNetPipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"prompt_2",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor]] = None"},{name:"height",val:": typing.Optional[int] = None"},{name:"width",val:": typing.Optional[int] = None"},{name:"num_inference_steps",val:": int = 50"},{name:"timesteps",val:": typing.List[int] = None"},{name:"sigmas",val:": typing.List[float] = None"},{name:"denoising_end",val:": typing.Optional[float] = None"},{name:"guidance_scale",val:": float = 5.0"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"negative_prompt_2",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"num_images_per_prompt",val:": typing.Optional[int] = 1"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"pooled_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_pooled_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"ip_adapter_image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor], NoneType] = None"},{name:"ip_adapter_image_embeds",val:": typing.Optional[typing.List[torch.Tensor]] = None"},{name:"output_type",val:": typing.Optional[str] = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"cross_attention_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"},{name:"controlnet_conditioning_scale",val:": typing.Union[float, typing.List[float]] = 1.0"},{name:"guess_mode",val:": bool = False"},{name:"control_guidance_start",val:": typing.Union[float, typing.List[float]] = 0.0"},{name:"control_guidance_end",val:": typing.Union[float, typing.List[float]] = 1.0"},{name:"original_size",val:": typing.Tuple[int, int] = None"},{name:"crops_coords_top_left",val:": typing.Tuple[int, int] = (0, 0)"},{name:"target_size",val:": typing.Tuple[int, int] = None"},{name:"negative_original_size",val:": typing.Optional[typing.Tuple[int, int]] = None"},{name:"negative_crops_coords_top_left",val:": typing.Tuple[int, int] = (0, 0)"},{name:"negative_target_size",val:": typing.Optional[typing.Tuple[int, int]] = None"},{name:"clip_skip",val:": typing.Optional[int] = None"},{name:"callback_on_step_end",val:": typing.Union[typing.Callable[[int, int, typing.Dict], NoneType], diffusers.callbacks.PipelineCallback, diffusers.callbacks.MultiPipelineCallbacks, NoneType] = None"},{name:"callback_on_step_end_tensor_inputs",val:": typing.List[str] = ['latents']"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.StableDiffusionXLControlNetPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide image generation. If not defined, you need to pass <code>prompt_embeds</code>.`,name:"prompt"},{anchor:"diffusers.StableDiffusionXLControlNetPipeline.__call__.prompt_2",description:`<strong>prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to be sent to <code>tokenizer_2</code> and <code>text_encoder_2</code>. If not defined, <code>prompt</code> is
used in both text-encoders.`,name:"prompt_2"},{anchor:"diffusers.StableDiffusionXLControlNetPipeline.__call__.image",description:`<strong>image</strong> (<code>torch.Tensor</code>, <code>PIL.Image.Image</code>, <code>np.ndarray</code>, <code>List[torch.Tensor]</code>, <code>List[PIL.Image.Image]</code>, <code>List[np.ndarray]</code>, &#x2014;
<code>List[List[torch.Tensor]]</code>, <code>List[List[np.ndarray]]</code> or <code>List[List[PIL.Image.Image]]</code>):
The ControlNet input condition to provide guidance to the <code>unet</code> for generation. If the type is
specified as <code>torch.Tensor</code>, it is passed to ControlNet as is. <code>PIL.Image.Image</code> can also be accepted
as an image. The dimensions of the output image defaults to <code>image</code>&#x2019;s dimensions. If height and/or
width are passed, <code>image</code> is resized accordingly. If multiple ControlNets are specified in <code>init</code>,
images must be passed as a list such that each element of the list can be correctly batched for input
to a single ControlNet.`,name:"image"},{anchor:"diffusers.StableDiffusionXLControlNetPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The height in pixels of the generated image. Anything below 512 pixels won&#x2019;t work well for
<a href="https://huggingface.co/stabilityai/stable-diffusion-xl-base-1.0" rel="nofollow">stabilityai/stable-diffusion-xl-base-1.0</a>
and checkpoints that are not specifically fine-tuned on low resolutions.`,name:"height"},{anchor:"diffusers.StableDiffusionXLControlNetPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The width in pixels of the generated image. Anything below 512 pixels won&#x2019;t work well for
<a href="https://huggingface.co/stabilityai/stable-diffusion-xl-base-1.0" rel="nofollow">stabilityai/stable-diffusion-xl-base-1.0</a>
and checkpoints that are not specifically fine-tuned on low resolutions.`,name:"width"},{anchor:"diffusers.StableDiffusionXLControlNetPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.StableDiffusionXLControlNetPipeline.__call__.timesteps",description:`<strong>timesteps</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Custom timesteps to use for the denoising process with schedulers which support a <code>timesteps</code> argument
in their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is
passed will be used. Must be in descending order.`,name:"timesteps"},{anchor:"diffusers.StableDiffusionXLControlNetPipeline.__call__.sigmas",description:`<strong>sigmas</strong> (<code>List[float]</code>, <em>optional</em>) &#x2014;
Custom sigmas to use for the denoising process with schedulers which support a <code>sigmas</code> argument in
their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is passed
will be used.`,name:"sigmas"},{anchor:"diffusers.StableDiffusionXLControlNetPipeline.__call__.denoising_end",description:`<strong>denoising_end</strong> (<code>float</code>, <em>optional</em>) &#x2014;
When specified, determines the fraction (between 0.0 and 1.0) of the total denoising process to be
completed before it is intentionally prematurely terminated. As a result, the returned sample will
still retain a substantial amount of noise as determined by the discrete timesteps selected by the
scheduler. The denoising_end parameter should ideally be utilized when this pipeline forms a part of a
&#x201C;Mixture of Denoisers&#x201D; multi-pipeline setup, as elaborated in <a href="https://huggingface.co/docs/diffusers/api/pipelines/stable_diffusion/stable_diffusion_xl#refining-the-image-output" rel="nofollow"><strong>Refining the Image
Output</strong></a>`,name:"denoising_end"},{anchor:"diffusers.StableDiffusionXLControlNetPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 5.0) &#x2014;
A higher guidance scale value encourages the model to generate images closely linked to the text
<code>prompt</code> at the expense of lower image quality. Guidance scale is enabled when <code>guidance_scale &gt; 1</code>.`,name:"guidance_scale"},{anchor:"diffusers.StableDiffusionXLControlNetPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide what to not include in image generation. If not defined, you need to
pass <code>negative_prompt_embeds</code> instead. Ignored when not using guidance (<code>guidance_scale &lt; 1</code>).`,name:"negative_prompt"},{anchor:"diffusers.StableDiffusionXLControlNetPipeline.__call__.negative_prompt_2",description:`<strong>negative_prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide what to not include in image generation. This is sent to <code>tokenizer_2</code>
and <code>text_encoder_2</code>. If not defined, <code>negative_prompt</code> is used in both text-encoders.`,name:"negative_prompt_2"},{anchor:"diffusers.StableDiffusionXLControlNetPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.StableDiffusionXLControlNetPipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) from the <a href="https://arxiv.org/abs/2010.02502" rel="nofollow">DDIM</a> paper. Only applies
to the <a href="/docs/diffusers/pr_10058/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, and is ignored in other schedulers.`,name:"eta"},{anchor:"diffusers.StableDiffusionXLControlNetPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
generation deterministic.`,name:"generator"},{anchor:"diffusers.StableDiffusionXLControlNetPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor is generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.StableDiffusionXLControlNetPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs (prompt weighting). If not
provided, text embeddings are generated from the <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.StableDiffusionXLControlNetPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs (prompt weighting). If
not provided, <code>negative_prompt_embeds</code> are generated from the <code>negative_prompt</code> input argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.StableDiffusionXLControlNetPipeline.__call__.pooled_prompt_embeds",description:`<strong>pooled_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated pooled text embeddings. Can be used to easily tweak text inputs (prompt weighting). If
not provided, pooled text embeddings are generated from <code>prompt</code> input argument.`,name:"pooled_prompt_embeds"},{anchor:"diffusers.StableDiffusionXLControlNetPipeline.__call__.negative_pooled_prompt_embeds",description:`<strong>negative_pooled_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative pooled text embeddings. Can be used to easily tweak text inputs (prompt
weighting). If not provided, pooled <code>negative_prompt_embeds</code> are generated from <code>negative_prompt</code> input
argument.`,name:"negative_pooled_prompt_embeds"},{anchor:"diffusers.StableDiffusionXLControlNetPipeline.__call__.ip_adapter_image",description:"<strong>ip_adapter_image</strong> &#x2014; (<code>PipelineImageInput</code>, <em>optional</em>): Optional image input to work with IP Adapters.",name:"ip_adapter_image"},{anchor:"diffusers.StableDiffusionXLControlNetPipeline.__call__.ip_adapter_image_embeds",description:`<strong>ip_adapter_image_embeds</strong> (<code>List[torch.Tensor]</code>, <em>optional</em>) &#x2014;
Pre-generated image embeddings for IP-Adapter. It should be a list of length same as number of
IP-adapters. Each element should be a tensor of shape <code>(batch_size, num_images, emb_dim)</code>. It should
contain the negative image embedding if <code>do_classifier_free_guidance</code> is set to <code>True</code>. If not
provided, embeddings are computed from the <code>ip_adapter_image</code> input argument.`,name:"ip_adapter_image_embeds"},{anchor:"diffusers.StableDiffusionXLControlNetPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generated image. Choose between <code>PIL.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.StableDiffusionXLControlNetPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/pr_10058/en/api/pipelines/stable_diffusion/inpaint#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput">StableDiffusionPipelineOutput</a> instead of a
plain tuple.`,name:"return_dict"},{anchor:"diffusers.StableDiffusionXLControlNetPipeline.__call__.cross_attention_kwargs",description:`<strong>cross_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow"><code>self.processor</code></a>.`,name:"cross_attention_kwargs"},{anchor:"diffusers.StableDiffusionXLControlNetPipeline.__call__.controlnet_conditioning_scale",description:`<strong>controlnet_conditioning_scale</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to 1.0) &#x2014;
The outputs of the ControlNet are multiplied by <code>controlnet_conditioning_scale</code> before they are added
to the residual in the original <code>unet</code>. If multiple ControlNets are specified in <code>init</code>, you can set
the corresponding scale as a list.`,name:"controlnet_conditioning_scale"},{anchor:"diffusers.StableDiffusionXLControlNetPipeline.__call__.guess_mode",description:`<strong>guess_mode</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
The ControlNet encoder tries to recognize the content of the input image even if you remove all
prompts. A <code>guidance_scale</code> value between 3.0 and 5.0 is recommended.`,name:"guess_mode"},{anchor:"diffusers.StableDiffusionXLControlNetPipeline.__call__.control_guidance_start",description:`<strong>control_guidance_start</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The percentage of total steps at which the ControlNet starts applying.`,name:"control_guidance_start"},{anchor:"diffusers.StableDiffusionXLControlNetPipeline.__call__.control_guidance_end",description:`<strong>control_guidance_end</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to 1.0) &#x2014;
The percentage of total steps at which the ControlNet stops applying.`,name:"control_guidance_end"},{anchor:"diffusers.StableDiffusionXLControlNetPipeline.__call__.original_size",description:`<strong>original_size</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to (1024, 1024)) &#x2014;
If <code>original_size</code> is not the same as <code>target_size</code> the image will appear to be down- or upsampled.
<code>original_size</code> defaults to <code>(height, width)</code> if not specified. Part of SDXL&#x2019;s micro-conditioning as
explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>.`,name:"original_size"},{anchor:"diffusers.StableDiffusionXLControlNetPipeline.__call__.crops_coords_top_left",description:`<strong>crops_coords_top_left</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to (0, 0)) &#x2014;
<code>crops_coords_top_left</code> can be used to generate an image that appears to be &#x201C;cropped&#x201D; from the position
<code>crops_coords_top_left</code> downwards. Favorable, well-centered images are usually achieved by setting
<code>crops_coords_top_left</code> to (0, 0). Part of SDXL&#x2019;s micro-conditioning as explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>.`,name:"crops_coords_top_left"},{anchor:"diffusers.StableDiffusionXLControlNetPipeline.__call__.target_size",description:`<strong>target_size</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to (1024, 1024)) &#x2014;
For most cases, <code>target_size</code> should be set to the desired height and width of the generated image. If
not specified it will default to <code>(height, width)</code>. Part of SDXL&#x2019;s micro-conditioning as explained in
section 2.2 of <a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>.`,name:"target_size"},{anchor:"diffusers.StableDiffusionXLControlNetPipeline.__call__.negative_original_size",description:`<strong>negative_original_size</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to (1024, 1024)) &#x2014;
To negatively condition the generation process based on a specific image resolution. Part of SDXL&#x2019;s
micro-conditioning as explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>. For more
information, refer to this issue thread: <a href="https://github.com/huggingface/diffusers/issues/4208" rel="nofollow">https://github.com/huggingface/diffusers/issues/4208</a>.`,name:"negative_original_size"},{anchor:"diffusers.StableDiffusionXLControlNetPipeline.__call__.negative_crops_coords_top_left",description:`<strong>negative_crops_coords_top_left</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to (0, 0)) &#x2014;
To negatively condition the generation process based on a specific crop coordinates. Part of SDXL&#x2019;s
micro-conditioning as explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>. For more
information, refer to this issue thread: <a href="https://github.com/huggingface/diffusers/issues/4208" rel="nofollow">https://github.com/huggingface/diffusers/issues/4208</a>.`,name:"negative_crops_coords_top_left"},{anchor:"diffusers.StableDiffusionXLControlNetPipeline.__call__.negative_target_size",description:`<strong>negative_target_size</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to (1024, 1024)) &#x2014;
To negatively condition the generation process based on a target image resolution. It should be as same
as the <code>target_size</code> for most cases. Part of SDXL&#x2019;s micro-conditioning as explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>. For more
information, refer to this issue thread: <a href="https://github.com/huggingface/diffusers/issues/4208" rel="nofollow">https://github.com/huggingface/diffusers/issues/4208</a>.`,name:"negative_target_size"},{anchor:"diffusers.StableDiffusionXLControlNetPipeline.__call__.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"},{anchor:"diffusers.StableDiffusionXLControlNetPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <code>PipelineCallback</code>, <code>MultiPipelineCallbacks</code>, <em>optional</em>) &#x2014;
A function or a subclass of <code>PipelineCallback</code> or <code>MultiPipelineCallbacks</code> that is called at the end of
each denoising step during the inference. with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a
list of all tensors as specified by <code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.StableDiffusionXLControlNetPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"}],source:"https://github.com/huggingface/diffusers/blob/vr_10058/src/diffusers/pipelines/controlnet/pipeline_controlnet_sd_xl.py#L996",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <a
  href="/docs/diffusers/pr_10058/en/api/pipelines/stable_diffusion/inpaint#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput"
>StableDiffusionPipelineOutput</a> is returned,
otherwise a <code>tuple</code> is returned containing the output images.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/pr_10058/en/api/pipelines/stable_diffusion/inpaint#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput"
>StableDiffusionPipelineOutput</a> or <code>tuple</code></p>
`}}),G=new Wt({props:{anchor:"diffusers.StableDiffusionXLControlNetPipeline.__call__.example",$$slots:{default:[In]},$$scope:{ctx:J}}}),te=new k({props:{name:"encode_prompt",anchor:"diffusers.StableDiffusionXLControlNetPipeline.encode_prompt",parameters:[{name:"prompt",val:": str"},{name:"prompt_2",val:": typing.Optional[str] = None"},{name:"device",val:": typing.Optional[torch.device] = None"},{name:"num_images_per_prompt",val:": int = 1"},{name:"do_classifier_free_guidance",val:": bool = True"},{name:"negative_prompt",val:": typing.Optional[str] = None"},{name:"negative_prompt_2",val:": typing.Optional[str] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"pooled_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_pooled_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"lora_scale",val:": typing.Optional[float] = None"},{name:"clip_skip",val:": typing.Optional[int] = None"}],parametersDescription:[{anchor:"diffusers.StableDiffusionXLControlNetPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded`,name:"prompt"},{anchor:"diffusers.StableDiffusionXLControlNetPipeline.encode_prompt.prompt_2",description:`<strong>prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to be sent to the <code>tokenizer_2</code> and <code>text_encoder_2</code>. If not defined, <code>prompt</code> is
used in both text-encoders`,name:"prompt_2"},{anchor:"diffusers.StableDiffusionXLControlNetPipeline.encode_prompt.device",description:`<strong>device</strong> &#x2014; (<code>torch.device</code>):
torch device`,name:"device"},{anchor:"diffusers.StableDiffusionXLControlNetPipeline.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>) &#x2014;
number of images that should be generated per prompt`,name:"num_images_per_prompt"},{anchor:"diffusers.StableDiffusionXLControlNetPipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>) &#x2014;
whether to use classifier free guidance or not`,name:"do_classifier_free_guidance"},{anchor:"diffusers.StableDiffusionXLControlNetPipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.StableDiffusionXLControlNetPipeline.encode_prompt.negative_prompt_2",description:`<strong>negative_prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation to be sent to <code>tokenizer_2</code> and
<code>text_encoder_2</code>. If not defined, <code>negative_prompt</code> is used in both text-encoders`,name:"negative_prompt_2"},{anchor:"diffusers.StableDiffusionXLControlNetPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.StableDiffusionXLControlNetPipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.StableDiffusionXLControlNetPipeline.encode_prompt.pooled_prompt_embeds",description:`<strong>pooled_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting.
If not provided, pooled text embeddings will be generated from <code>prompt</code> input argument.`,name:"pooled_prompt_embeds"},{anchor:"diffusers.StableDiffusionXLControlNetPipeline.encode_prompt.negative_pooled_prompt_embeds",description:`<strong>negative_pooled_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, pooled negative_prompt_embeds will be generated from <code>negative_prompt</code>
input argument.`,name:"negative_pooled_prompt_embeds"},{anchor:"diffusers.StableDiffusionXLControlNetPipeline.encode_prompt.lora_scale",description:`<strong>lora_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
A lora scale that will be applied to all LoRA layers of the text encoder if LoRA layers are loaded.`,name:"lora_scale"},{anchor:"diffusers.StableDiffusionXLControlNetPipeline.encode_prompt.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"}],source:"https://github.com/huggingface/diffusers/blob/vr_10058/src/diffusers/pipelines/controlnet/pipeline_controlnet_sd_xl.py#L293"}}),ne=new k({props:{name:"get_guidance_scale_embedding",anchor:"diffusers.StableDiffusionXLControlNetPipeline.get_guidance_scale_embedding",parameters:[{name:"w",val:": Tensor"},{name:"embedding_dim",val:": int = 512"},{name:"dtype",val:": dtype = torch.float32"}],parametersDescription:[{anchor:"diffusers.StableDiffusionXLControlNetPipeline.get_guidance_scale_embedding.w",description:`<strong>w</strong> (<code>torch.Tensor</code>) &#x2014;
Generate embedding vectors with a specified guidance scale to subsequently enrich timestep embeddings.`,name:"w"},{anchor:"diffusers.StableDiffusionXLControlNetPipeline.get_guidance_scale_embedding.embedding_dim",description:`<strong>embedding_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
Dimension of the embeddings to generate.`,name:"embedding_dim"},{anchor:"diffusers.StableDiffusionXLControlNetPipeline.get_guidance_scale_embedding.dtype",description:`<strong>dtype</strong> (<code>torch.dtype</code>, <em>optional</em>, defaults to <code>torch.float32</code>) &#x2014;
Data type of the generated embeddings.`,name:"dtype"}],source:"https://github.com/huggingface/diffusers/blob/vr_10058/src/diffusers/pipelines/controlnet/pipeline_controlnet_sd_xl.py#L935",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Embedding vectors with shape <code>(len(w), embedding_dim)</code>.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.Tensor</code></p>
`}}),oe=new ze({props:{title:"StableDiffusionXLControlNetImg2ImgPipeline",local:"diffusers.StableDiffusionXLControlNetImg2ImgPipeline",headingTag:"h2"}}),ie=new k({props:{name:"class diffusers.StableDiffusionXLControlNetImg2ImgPipeline",anchor:"diffusers.StableDiffusionXLControlNetImg2ImgPipeline",parameters:[{name:"vae",val:": AutoencoderKL"},{name:"text_encoder",val:": CLIPTextModel"},{name:"text_encoder_2",val:": CLIPTextModelWithProjection"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"tokenizer_2",val:": CLIPTokenizer"},{name:"unet",val:": UNet2DConditionModel"},{name:"controlnet",val:": typing.Union[diffusers.models.controlnets.controlnet.ControlNetModel, typing.List[diffusers.models.controlnets.controlnet.ControlNetModel], typing.Tuple[diffusers.models.controlnets.controlnet.ControlNetModel], diffusers.models.controlnets.multicontrolnet.MultiControlNetModel]"},{name:"scheduler",val:": KarrasDiffusionSchedulers"},{name:"requires_aesthetics_score",val:": bool = False"},{name:"force_zeros_for_empty_prompt",val:": bool = True"},{name:"add_watermarker",val:": typing.Optional[bool] = None"},{name:"feature_extractor",val:": CLIPImageProcessor = None"},{name:"image_encoder",val:": CLIPVisionModelWithProjection = None"}],parametersDescription:[{anchor:"diffusers.StableDiffusionXLControlNetImg2ImgPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/pr_10058/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.StableDiffusionXLControlNetImg2ImgPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>CLIPTextModel</code>) &#x2014;
Frozen text-encoder. Stable Diffusion uses the text portion of
<a href="https://huggingface.co/docs/transformers/model_doc/clip#transformers.CLIPTextModel" rel="nofollow">CLIP</a>, specifically
the <a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a> variant.`,name:"text_encoder"},{anchor:"diffusers.StableDiffusionXLControlNetImg2ImgPipeline.text_encoder_2",description:`<strong>text_encoder_2</strong> (<code> CLIPTextModelWithProjection</code>) &#x2014;
Second frozen text-encoder. Stable Diffusion XL uses the text and pool portion of
<a href="https://huggingface.co/docs/transformers/model_doc/clip#transformers.CLIPTextModelWithProjection" rel="nofollow">CLIP</a>,
specifically the
<a href="https://huggingface.co/laion/CLIP-ViT-bigG-14-laion2B-39B-b160k" rel="nofollow">laion/CLIP-ViT-bigG-14-laion2B-39B-b160k</a>
variant.`,name:"text_encoder_2"},{anchor:"diffusers.StableDiffusionXLControlNetImg2ImgPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>CLIPTokenizer</code>) &#x2014;
Tokenizer of class
<a href="https://huggingface.co/docs/transformers/v4.21.0/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>.`,name:"tokenizer"},{anchor:"diffusers.StableDiffusionXLControlNetImg2ImgPipeline.tokenizer_2",description:`<strong>tokenizer_2</strong> (<code>CLIPTokenizer</code>) &#x2014;
Second Tokenizer of class
<a href="https://huggingface.co/docs/transformers/v4.21.0/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>.`,name:"tokenizer_2"},{anchor:"diffusers.StableDiffusionXLControlNetImg2ImgPipeline.unet",description:'<strong>unet</strong> (<a href="/docs/diffusers/pr_10058/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014; Conditional U-Net architecture to denoise the encoded image latents.',name:"unet"},{anchor:"diffusers.StableDiffusionXLControlNetImg2ImgPipeline.controlnet",description:`<strong>controlnet</strong> (<a href="/docs/diffusers/pr_10058/en/api/models/controlnet#diffusers.ControlNetModel">ControlNetModel</a> or <code>List[ControlNetModel]</code>) &#x2014;
Provides additional conditioning to the unet during the denoising process. If you set multiple ControlNets
as a list, the outputs from each ControlNet are added together to create one combined additional
conditioning.`,name:"controlnet"},{anchor:"diffusers.StableDiffusionXLControlNetImg2ImgPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/pr_10058/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to denoise the encoded image latents. Can be one of
<a href="/docs/diffusers/pr_10058/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, <a href="/docs/diffusers/pr_10058/en/api/schedulers/lms_discrete#diffusers.LMSDiscreteScheduler">LMSDiscreteScheduler</a>, or <a href="/docs/diffusers/pr_10058/en/api/schedulers/pndm#diffusers.PNDMScheduler">PNDMScheduler</a>.`,name:"scheduler"},{anchor:"diffusers.StableDiffusionXLControlNetImg2ImgPipeline.requires_aesthetics_score",description:`<strong>requires_aesthetics_score</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>&quot;False&quot;</code>) &#x2014;
Whether the <code>unet</code> requires an <code>aesthetic_score</code> condition to be passed during inference. Also see the
config of <code>stabilityai/stable-diffusion-xl-refiner-1-0</code>.`,name:"requires_aesthetics_score"},{anchor:"diffusers.StableDiffusionXLControlNetImg2ImgPipeline.force_zeros_for_empty_prompt",description:`<strong>force_zeros_for_empty_prompt</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>&quot;True&quot;</code>) &#x2014;
Whether the negative prompt embeddings shall be forced to always be set to 0. Also see the config of
<code>stabilityai/stable-diffusion-xl-base-1-0</code>.`,name:"force_zeros_for_empty_prompt"},{anchor:"diffusers.StableDiffusionXLControlNetImg2ImgPipeline.add_watermarker",description:`<strong>add_watermarker</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to use the <a href="https://github.com/ShieldMnt/invisible-watermark/" rel="nofollow">invisible_watermark library</a> to
watermark output images. If not defined, it will default to True if the package is installed, otherwise no
watermarker will be used.`,name:"add_watermarker"},{anchor:"diffusers.StableDiffusionXLControlNetImg2ImgPipeline.feature_extractor",description:`<strong>feature_extractor</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPImageProcessor" rel="nofollow">CLIPImageProcessor</a>) &#x2014;
A <code>CLIPImageProcessor</code> to extract features from generated images; used as inputs to the <code>safety_checker</code>.`,name:"feature_extractor"}],source:"https://github.com/huggingface/diffusers/blob/vr_10058/src/diffusers/pipelines/controlnet/pipeline_controlnet_sd_xl_img2img.py#L157"}}),se=new k({props:{name:"__call__",anchor:"diffusers.StableDiffusionXLControlNetImg2ImgPipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"prompt_2",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor]] = None"},{name:"control_image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor]] = None"},{name:"height",val:": typing.Optional[int] = None"},{name:"width",val:": typing.Optional[int] = None"},{name:"strength",val:": float = 0.8"},{name:"num_inference_steps",val:": int = 50"},{name:"guidance_scale",val:": float = 5.0"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"negative_prompt_2",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"num_images_per_prompt",val:": typing.Optional[int] = 1"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"pooled_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_pooled_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"ip_adapter_image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor], NoneType] = None"},{name:"ip_adapter_image_embeds",val:": typing.Optional[typing.List[torch.Tensor]] = None"},{name:"output_type",val:": typing.Optional[str] = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"cross_attention_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"},{name:"controlnet_conditioning_scale",val:": typing.Union[float, typing.List[float]] = 0.8"},{name:"guess_mode",val:": bool = False"},{name:"control_guidance_start",val:": typing.Union[float, typing.List[float]] = 0.0"},{name:"control_guidance_end",val:": typing.Union[float, typing.List[float]] = 1.0"},{name:"original_size",val:": typing.Tuple[int, int] = None"},{name:"crops_coords_top_left",val:": typing.Tuple[int, int] = (0, 0)"},{name:"target_size",val:": typing.Tuple[int, int] = None"},{name:"negative_original_size",val:": typing.Optional[typing.Tuple[int, int]] = None"},{name:"negative_crops_coords_top_left",val:": typing.Tuple[int, int] = (0, 0)"},{name:"negative_target_size",val:": typing.Optional[typing.Tuple[int, int]] = None"},{name:"aesthetic_score",val:": float = 6.0"},{name:"negative_aesthetic_score",val:": float = 2.5"},{name:"clip_skip",val:": typing.Optional[int] = None"},{name:"callback_on_step_end",val:": typing.Union[typing.Callable[[int, int, typing.Dict], NoneType], diffusers.callbacks.PipelineCallback, diffusers.callbacks.MultiPipelineCallbacks, NoneType] = None"},{name:"callback_on_step_end_tensor_inputs",val:": typing.List[str] = ['latents']"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.StableDiffusionXLControlNetImg2ImgPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide the image generation. If not defined, one has to pass <code>prompt_embeds</code>.
instead.`,name:"prompt"},{anchor:"diffusers.StableDiffusionXLControlNetImg2ImgPipeline.__call__.prompt_2",description:`<strong>prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to be sent to the <code>tokenizer_2</code> and <code>text_encoder_2</code>. If not defined, <code>prompt</code> is
used in both text-encoders`,name:"prompt_2"},{anchor:"diffusers.StableDiffusionXLControlNetImg2ImgPipeline.__call__.image",description:`<strong>image</strong> (<code>torch.Tensor</code>, <code>PIL.Image.Image</code>, <code>np.ndarray</code>, <code>List[torch.Tensor]</code>, <code>List[PIL.Image.Image]</code>, <code>List[np.ndarray]</code>, &#x2014;
<code>List[List[torch.Tensor]]</code>, <code>List[List[np.ndarray]]</code> or <code>List[List[PIL.Image.Image]]</code>):
The initial image will be used as the starting point for the image generation process. Can also accept
image latents as <code>image</code>, if passing latents directly, it will not be encoded again.`,name:"image"},{anchor:"diffusers.StableDiffusionXLControlNetImg2ImgPipeline.__call__.control_image",description:`<strong>control_image</strong> (<code>torch.Tensor</code>, <code>PIL.Image.Image</code>, <code>np.ndarray</code>, <code>List[torch.Tensor]</code>, <code>List[PIL.Image.Image]</code>, <code>List[np.ndarray]</code>, &#x2014;
<code>List[List[torch.Tensor]]</code>, <code>List[List[np.ndarray]]</code> or <code>List[List[PIL.Image.Image]]</code>):
The ControlNet input condition. ControlNet uses this input condition to generate guidance to Unet. If
the type is specified as <code>torch.Tensor</code>, it is passed to ControlNet as is. <code>PIL.Image.Image</code> can also
be accepted as an image. The dimensions of the output image defaults to <code>image</code>&#x2019;s dimensions. If height
and/or width are passed, <code>image</code> is resized according to them. If multiple ControlNets are specified in
init, images must be passed as a list such that each element of the list can be correctly batched for
input to a single controlnet.`,name:"control_image"},{anchor:"diffusers.StableDiffusionXLControlNetImg2ImgPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to the size of control_image) &#x2014;
The height in pixels of the generated image. Anything below 512 pixels won&#x2019;t work well for
<a href="https://huggingface.co/stabilityai/stable-diffusion-xl-base-1.0" rel="nofollow">stabilityai/stable-diffusion-xl-base-1.0</a>
and checkpoints that are not specifically fine-tuned on low resolutions.`,name:"height"},{anchor:"diffusers.StableDiffusionXLControlNetImg2ImgPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to the size of control_image) &#x2014;
The width in pixels of the generated image. Anything below 512 pixels won&#x2019;t work well for
<a href="https://huggingface.co/stabilityai/stable-diffusion-xl-base-1.0" rel="nofollow">stabilityai/stable-diffusion-xl-base-1.0</a>
and checkpoints that are not specifically fine-tuned on low resolutions.`,name:"width"},{anchor:"diffusers.StableDiffusionXLControlNetImg2ImgPipeline.__call__.strength",description:`<strong>strength</strong> (<code>float</code>, <em>optional</em>, defaults to 0.8) &#x2014;
Indicates extent to transform the reference <code>image</code>. Must be between 0 and 1. <code>image</code> is used as a
starting point and more noise is added the higher the <code>strength</code>. The number of denoising steps depends
on the amount of noise initially added. When <code>strength</code> is 1, added noise is maximum and the denoising
process runs for the full number of iterations specified in <code>num_inference_steps</code>. A value of 1
essentially ignores <code>image</code>.`,name:"strength"},{anchor:"diffusers.StableDiffusionXLControlNetImg2ImgPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.StableDiffusionXLControlNetImg2ImgPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 7.5) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.StableDiffusionXLControlNetImg2ImgPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.StableDiffusionXLControlNetImg2ImgPipeline.__call__.negative_prompt_2",description:`<strong>negative_prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation to be sent to <code>tokenizer_2</code> and
<code>text_encoder_2</code>. If not defined, <code>negative_prompt</code> is used in both text-encoders`,name:"negative_prompt_2"},{anchor:"diffusers.StableDiffusionXLControlNetImg2ImgPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.StableDiffusionXLControlNetImg2ImgPipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) in the DDIM paper: <a href="https://arxiv.org/abs/2010.02502" rel="nofollow">https://arxiv.org/abs/2010.02502</a>. Only applies to
<a href="/docs/diffusers/pr_10058/en/api/schedulers/ddim#diffusers.DDIMScheduler">schedulers.DDIMScheduler</a>, will be ignored for others.`,name:"eta"},{anchor:"diffusers.StableDiffusionXLControlNetImg2ImgPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.StableDiffusionXLControlNetImg2ImgPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.StableDiffusionXLControlNetImg2ImgPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.StableDiffusionXLControlNetImg2ImgPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.StableDiffusionXLControlNetImg2ImgPipeline.__call__.pooled_prompt_embeds",description:`<strong>pooled_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting.
If not provided, pooled text embeddings will be generated from <code>prompt</code> input argument.`,name:"pooled_prompt_embeds"},{anchor:"diffusers.StableDiffusionXLControlNetImg2ImgPipeline.__call__.negative_pooled_prompt_embeds",description:`<strong>negative_pooled_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, pooled negative_prompt_embeds will be generated from <code>negative_prompt</code>
input argument.`,name:"negative_pooled_prompt_embeds"},{anchor:"diffusers.StableDiffusionXLControlNetImg2ImgPipeline.__call__.ip_adapter_image",description:"<strong>ip_adapter_image</strong> &#x2014; (<code>PipelineImageInput</code>, <em>optional</em>): Optional image input to work with IP Adapters.",name:"ip_adapter_image"},{anchor:"diffusers.StableDiffusionXLControlNetImg2ImgPipeline.__call__.ip_adapter_image_embeds",description:`<strong>ip_adapter_image_embeds</strong> (<code>List[torch.Tensor]</code>, <em>optional</em>) &#x2014;
Pre-generated image embeddings for IP-Adapter. It should be a list of length same as number of
IP-adapters. Each element should be a tensor of shape <code>(batch_size, num_images, emb_dim)</code>. It should
contain the negative image embedding if <code>do_classifier_free_guidance</code> is set to <code>True</code>. If not
provided, embeddings are computed from the <code>ip_adapter_image</code> input argument.`,name:"ip_adapter_image_embeds"},{anchor:"diffusers.StableDiffusionXLControlNetImg2ImgPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between
<a href="https://pillow.readthedocs.io/en/stable/" rel="nofollow">PIL</a>: <code>PIL.Image.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.StableDiffusionXLControlNetImg2ImgPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/pr_10058/en/api/pipelines/stable_diffusion/inpaint#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput">StableDiffusionPipelineOutput</a> instead of a
plain tuple.`,name:"return_dict"},{anchor:"diffusers.StableDiffusionXLControlNetImg2ImgPipeline.__call__.cross_attention_kwargs",description:`<strong>cross_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined under
<code>self.processor</code> in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow">diffusers.models.attention_processor</a>.`,name:"cross_attention_kwargs"},{anchor:"diffusers.StableDiffusionXLControlNetImg2ImgPipeline.__call__.controlnet_conditioning_scale",description:`<strong>controlnet_conditioning_scale</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to 1.0) &#x2014;
The outputs of the controlnet are multiplied by <code>controlnet_conditioning_scale</code> before they are added
to the residual in the original unet. If multiple ControlNets are specified in init, you can set the
corresponding scale as a list.`,name:"controlnet_conditioning_scale"},{anchor:"diffusers.StableDiffusionXLControlNetImg2ImgPipeline.__call__.guess_mode",description:`<strong>guess_mode</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
In this mode, the ControlNet encoder will try best to recognize the content of the input image even if
you remove all prompts. The <code>guidance_scale</code> between 3.0 and 5.0 is recommended.`,name:"guess_mode"},{anchor:"diffusers.StableDiffusionXLControlNetImg2ImgPipeline.__call__.control_guidance_start",description:`<strong>control_guidance_start</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The percentage of total steps at which the controlnet starts applying.`,name:"control_guidance_start"},{anchor:"diffusers.StableDiffusionXLControlNetImg2ImgPipeline.__call__.control_guidance_end",description:`<strong>control_guidance_end</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to 1.0) &#x2014;
The percentage of total steps at which the controlnet stops applying.`,name:"control_guidance_end"},{anchor:"diffusers.StableDiffusionXLControlNetImg2ImgPipeline.__call__.original_size",description:`<strong>original_size</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to (1024, 1024)) &#x2014;
If <code>original_size</code> is not the same as <code>target_size</code> the image will appear to be down- or upsampled.
<code>original_size</code> defaults to <code>(height, width)</code> if not specified. Part of SDXL&#x2019;s micro-conditioning as
explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>.`,name:"original_size"},{anchor:"diffusers.StableDiffusionXLControlNetImg2ImgPipeline.__call__.crops_coords_top_left",description:`<strong>crops_coords_top_left</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to (0, 0)) &#x2014;
<code>crops_coords_top_left</code> can be used to generate an image that appears to be &#x201C;cropped&#x201D; from the position
<code>crops_coords_top_left</code> downwards. Favorable, well-centered images are usually achieved by setting
<code>crops_coords_top_left</code> to (0, 0). Part of SDXL&#x2019;s micro-conditioning as explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>.`,name:"crops_coords_top_left"},{anchor:"diffusers.StableDiffusionXLControlNetImg2ImgPipeline.__call__.target_size",description:`<strong>target_size</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to (1024, 1024)) &#x2014;
For most cases, <code>target_size</code> should be set to the desired height and width of the generated image. If
not specified it will default to <code>(height, width)</code>. Part of SDXL&#x2019;s micro-conditioning as explained in
section 2.2 of <a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>.`,name:"target_size"},{anchor:"diffusers.StableDiffusionXLControlNetImg2ImgPipeline.__call__.negative_original_size",description:`<strong>negative_original_size</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to (1024, 1024)) &#x2014;
To negatively condition the generation process based on a specific image resolution. Part of SDXL&#x2019;s
micro-conditioning as explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>. For more
information, refer to this issue thread: <a href="https://github.com/huggingface/diffusers/issues/4208" rel="nofollow">https://github.com/huggingface/diffusers/issues/4208</a>.`,name:"negative_original_size"},{anchor:"diffusers.StableDiffusionXLControlNetImg2ImgPipeline.__call__.negative_crops_coords_top_left",description:`<strong>negative_crops_coords_top_left</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to (0, 0)) &#x2014;
To negatively condition the generation process based on a specific crop coordinates. Part of SDXL&#x2019;s
micro-conditioning as explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>. For more
information, refer to this issue thread: <a href="https://github.com/huggingface/diffusers/issues/4208" rel="nofollow">https://github.com/huggingface/diffusers/issues/4208</a>.`,name:"negative_crops_coords_top_left"},{anchor:"diffusers.StableDiffusionXLControlNetImg2ImgPipeline.__call__.negative_target_size",description:`<strong>negative_target_size</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to (1024, 1024)) &#x2014;
To negatively condition the generation process based on a target image resolution. It should be as same
as the <code>target_size</code> for most cases. Part of SDXL&#x2019;s micro-conditioning as explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>. For more
information, refer to this issue thread: <a href="https://github.com/huggingface/diffusers/issues/4208" rel="nofollow">https://github.com/huggingface/diffusers/issues/4208</a>.`,name:"negative_target_size"},{anchor:"diffusers.StableDiffusionXLControlNetImg2ImgPipeline.__call__.aesthetic_score",description:`<strong>aesthetic_score</strong> (<code>float</code>, <em>optional</em>, defaults to 6.0) &#x2014;
Used to simulate an aesthetic score of the generated image by influencing the positive text condition.
Part of SDXL&#x2019;s micro-conditioning as explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>.`,name:"aesthetic_score"},{anchor:"diffusers.StableDiffusionXLControlNetImg2ImgPipeline.__call__.negative_aesthetic_score",description:`<strong>negative_aesthetic_score</strong> (<code>float</code>, <em>optional</em>, defaults to 2.5) &#x2014;
Part of SDXL&#x2019;s micro-conditioning as explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>. Can be used to
simulate an aesthetic score of the generated image by influencing the negative text condition.`,name:"negative_aesthetic_score"},{anchor:"diffusers.StableDiffusionXLControlNetImg2ImgPipeline.__call__.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"},{anchor:"diffusers.StableDiffusionXLControlNetImg2ImgPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <code>PipelineCallback</code>, <code>MultiPipelineCallbacks</code>, <em>optional</em>) &#x2014;
A function or a subclass of <code>PipelineCallback</code> or <code>MultiPipelineCallbacks</code> that is called at the end of
each denoising step during the inference. with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a
list of all tensors as specified by <code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.StableDiffusionXLControlNetImg2ImgPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"}],source:"https://github.com/huggingface/diffusers/blob/vr_10058/src/diffusers/pipelines/controlnet/pipeline_controlnet_sd_xl_img2img.py#L1075",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/pr_10058/en/api/pipelines/stable_diffusion/inpaint#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput"
>StableDiffusionPipelineOutput</a> if <code>return_dict</code> is True, otherwise a <code>tuple</code>
containing the output images.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/pr_10058/en/api/pipelines/stable_diffusion/inpaint#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput"
>StableDiffusionPipelineOutput</a> or <code>tuple</code></p>
`}}),R=new Wt({props:{anchor:"diffusers.StableDiffusionXLControlNetImg2ImgPipeline.__call__.example",$$slots:{default:[Mn]},$$scope:{ctx:J}}}),ae=new k({props:{name:"encode_prompt",anchor:"diffusers.StableDiffusionXLControlNetImg2ImgPipeline.encode_prompt",parameters:[{name:"prompt",val:": str"},{name:"prompt_2",val:": typing.Optional[str] = None"},{name:"device",val:": typing.Optional[torch.device] = None"},{name:"num_images_per_prompt",val:": int = 1"},{name:"do_classifier_free_guidance",val:": bool = True"},{name:"negative_prompt",val:": typing.Optional[str] = None"},{name:"negative_prompt_2",val:": typing.Optional[str] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"pooled_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_pooled_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"lora_scale",val:": typing.Optional[float] = None"},{name:"clip_skip",val:": typing.Optional[int] = None"}],parametersDescription:[{anchor:"diffusers.StableDiffusionXLControlNetImg2ImgPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded`,name:"prompt"},{anchor:"diffusers.StableDiffusionXLControlNetImg2ImgPipeline.encode_prompt.prompt_2",description:`<strong>prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to be sent to the <code>tokenizer_2</code> and <code>text_encoder_2</code>. If not defined, <code>prompt</code> is
used in both text-encoders`,name:"prompt_2"},{anchor:"diffusers.StableDiffusionXLControlNetImg2ImgPipeline.encode_prompt.device",description:`<strong>device</strong> &#x2014; (<code>torch.device</code>):
torch device`,name:"device"},{anchor:"diffusers.StableDiffusionXLControlNetImg2ImgPipeline.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>) &#x2014;
number of images that should be generated per prompt`,name:"num_images_per_prompt"},{anchor:"diffusers.StableDiffusionXLControlNetImg2ImgPipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>) &#x2014;
whether to use classifier free guidance or not`,name:"do_classifier_free_guidance"},{anchor:"diffusers.StableDiffusionXLControlNetImg2ImgPipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.StableDiffusionXLControlNetImg2ImgPipeline.encode_prompt.negative_prompt_2",description:`<strong>negative_prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation to be sent to <code>tokenizer_2</code> and
<code>text_encoder_2</code>. If not defined, <code>negative_prompt</code> is used in both text-encoders`,name:"negative_prompt_2"},{anchor:"diffusers.StableDiffusionXLControlNetImg2ImgPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.StableDiffusionXLControlNetImg2ImgPipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.StableDiffusionXLControlNetImg2ImgPipeline.encode_prompt.pooled_prompt_embeds",description:`<strong>pooled_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting.
If not provided, pooled text embeddings will be generated from <code>prompt</code> input argument.`,name:"pooled_prompt_embeds"},{anchor:"diffusers.StableDiffusionXLControlNetImg2ImgPipeline.encode_prompt.negative_pooled_prompt_embeds",description:`<strong>negative_pooled_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, pooled negative_prompt_embeds will be generated from <code>negative_prompt</code>
input argument.`,name:"negative_pooled_prompt_embeds"},{anchor:"diffusers.StableDiffusionXLControlNetImg2ImgPipeline.encode_prompt.lora_scale",description:`<strong>lora_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
A lora scale that will be applied to all LoRA layers of the text encoder if LoRA layers are loaded.`,name:"lora_scale"},{anchor:"diffusers.StableDiffusionXLControlNetImg2ImgPipeline.encode_prompt.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"}],source:"https://github.com/huggingface/diffusers/blob/vr_10058/src/diffusers/pipelines/controlnet/pipeline_controlnet_sd_xl_img2img.py#L286"}}),re=new ze({props:{title:"StableDiffusionXLControlNetInpaintPipeline",local:"diffusers.StableDiffusionXLControlNetInpaintPipeline",headingTag:"h2"}}),le=new k({props:{name:"class diffusers.StableDiffusionXLControlNetInpaintPipeline",anchor:"diffusers.StableDiffusionXLControlNetInpaintPipeline",parameters:[{name:"vae",val:": AutoencoderKL"},{name:"text_encoder",val:": CLIPTextModel"},{name:"text_encoder_2",val:": CLIPTextModelWithProjection"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"tokenizer_2",val:": CLIPTokenizer"},{name:"unet",val:": UNet2DConditionModel"},{name:"controlnet",val:": typing.Union[diffusers.models.controlnets.controlnet.ControlNetModel, typing.List[diffusers.models.controlnets.controlnet.ControlNetModel], typing.Tuple[diffusers.models.controlnets.controlnet.ControlNetModel], diffusers.models.controlnets.multicontrolnet.MultiControlNetModel]"},{name:"scheduler",val:": KarrasDiffusionSchedulers"},{name:"requires_aesthetics_score",val:": bool = False"},{name:"force_zeros_for_empty_prompt",val:": bool = True"},{name:"add_watermarker",val:": typing.Optional[bool] = None"},{name:"feature_extractor",val:": typing.Optional[transformers.models.clip.image_processing_clip.CLIPImageProcessor] = None"},{name:"image_encoder",val:": typing.Optional[transformers.models.clip.modeling_clip.CLIPVisionModelWithProjection] = None"}],parametersDescription:[{anchor:"diffusers.StableDiffusionXLControlNetInpaintPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/pr_10058/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.StableDiffusionXLControlNetInpaintPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>CLIPTextModel</code>) &#x2014;
Frozen text-encoder. Stable Diffusion XL uses the text portion of
<a href="https://huggingface.co/docs/transformers/model_doc/clip#transformers.CLIPTextModel" rel="nofollow">CLIP</a>, specifically
the <a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a> variant.`,name:"text_encoder"},{anchor:"diffusers.StableDiffusionXLControlNetInpaintPipeline.text_encoder_2",description:`<strong>text_encoder_2</strong> (<code> CLIPTextModelWithProjection</code>) &#x2014;
Second frozen text-encoder. Stable Diffusion XL uses the text and pool portion of
<a href="https://huggingface.co/docs/transformers/model_doc/clip#transformers.CLIPTextModelWithProjection" rel="nofollow">CLIP</a>,
specifically the
<a href="https://huggingface.co/laion/CLIP-ViT-bigG-14-laion2B-39B-b160k" rel="nofollow">laion/CLIP-ViT-bigG-14-laion2B-39B-b160k</a>
variant.`,name:"text_encoder_2"},{anchor:"diffusers.StableDiffusionXLControlNetInpaintPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>CLIPTokenizer</code>) &#x2014;
Tokenizer of class
<a href="https://huggingface.co/docs/transformers/v4.21.0/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>.`,name:"tokenizer"},{anchor:"diffusers.StableDiffusionXLControlNetInpaintPipeline.tokenizer_2",description:`<strong>tokenizer_2</strong> (<code>CLIPTokenizer</code>) &#x2014;
Second Tokenizer of class
<a href="https://huggingface.co/docs/transformers/v4.21.0/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>.`,name:"tokenizer_2"},{anchor:"diffusers.StableDiffusionXLControlNetInpaintPipeline.unet",description:'<strong>unet</strong> (<a href="/docs/diffusers/pr_10058/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014; Conditional U-Net architecture to denoise the encoded image latents.',name:"unet"},{anchor:"diffusers.StableDiffusionXLControlNetInpaintPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/pr_10058/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to denoise the encoded image latents. Can be one of
<a href="/docs/diffusers/pr_10058/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, <a href="/docs/diffusers/pr_10058/en/api/schedulers/lms_discrete#diffusers.LMSDiscreteScheduler">LMSDiscreteScheduler</a>, or <a href="/docs/diffusers/pr_10058/en/api/schedulers/pndm#diffusers.PNDMScheduler">PNDMScheduler</a>.`,name:"scheduler"}],source:"https://github.com/huggingface/diffusers/blob/vr_10058/src/diffusers/pipelines/controlnet/pipeline_controlnet_inpaint_sd_xl.py#L164"}}),pe=new k({props:{name:"__call__",anchor:"diffusers.StableDiffusionXLControlNetInpaintPipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"prompt_2",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor]] = None"},{name:"mask_image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor]] = None"},{name:"control_image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor], typing.List[typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor]]]] = None"},{name:"height",val:": typing.Optional[int] = None"},{name:"width",val:": typing.Optional[int] = None"},{name:"padding_mask_crop",val:": typing.Optional[int] = None"},{name:"strength",val:": float = 0.9999"},{name:"num_inference_steps",val:": int = 50"},{name:"denoising_start",val:": typing.Optional[float] = None"},{name:"denoising_end",val:": typing.Optional[float] = None"},{name:"guidance_scale",val:": float = 5.0"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"negative_prompt_2",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"num_images_per_prompt",val:": typing.Optional[int] = 1"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"ip_adapter_image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor], NoneType] = None"},{name:"ip_adapter_image_embeds",val:": typing.Optional[typing.List[torch.Tensor]] = None"},{name:"pooled_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_pooled_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"output_type",val:": typing.Optional[str] = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"cross_attention_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"},{name:"controlnet_conditioning_scale",val:": typing.Union[float, typing.List[float]] = 1.0"},{name:"guess_mode",val:": bool = False"},{name:"control_guidance_start",val:": typing.Union[float, typing.List[float]] = 0.0"},{name:"control_guidance_end",val:": typing.Union[float, typing.List[float]] = 1.0"},{name:"guidance_rescale",val:": float = 0.0"},{name:"original_size",val:": typing.Tuple[int, int] = None"},{name:"crops_coords_top_left",val:": typing.Tuple[int, int] = (0, 0)"},{name:"target_size",val:": typing.Tuple[int, int] = None"},{name:"aesthetic_score",val:": float = 6.0"},{name:"negative_aesthetic_score",val:": float = 2.5"},{name:"clip_skip",val:": typing.Optional[int] = None"},{name:"callback_on_step_end",val:": typing.Union[typing.Callable[[int, int, typing.Dict], NoneType], diffusers.callbacks.PipelineCallback, diffusers.callbacks.MultiPipelineCallbacks, NoneType] = None"},{name:"callback_on_step_end_tensor_inputs",val:": typing.List[str] = ['latents']"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.StableDiffusionXLControlNetInpaintPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide the image generation. If not defined, one has to pass <code>prompt_embeds</code>.
instead.`,name:"prompt"},{anchor:"diffusers.StableDiffusionXLControlNetInpaintPipeline.__call__.prompt_2",description:`<strong>prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to be sent to the <code>tokenizer_2</code> and <code>text_encoder_2</code>. If not defined, <code>prompt</code> is
used in both text-encoders`,name:"prompt_2"},{anchor:"diffusers.StableDiffusionXLControlNetInpaintPipeline.__call__.image",description:`<strong>image</strong> (<code>PIL.Image.Image</code>) &#x2014;
<code>Image</code>, or tensor representing an image batch which will be inpainted, <em>i.e.</em> parts of the image will
be masked out with <code>mask_image</code> and repainted according to <code>prompt</code>.`,name:"image"},{anchor:"diffusers.StableDiffusionXLControlNetInpaintPipeline.__call__.mask_image",description:`<strong>mask_image</strong> (<code>PIL.Image.Image</code>) &#x2014;
<code>Image</code>, or tensor representing an image batch, to mask <code>image</code>. White pixels in the mask will be
repainted, while black pixels will be preserved. If <code>mask_image</code> is a PIL image, it will be converted
to a single channel (luminance) before use. If it&#x2019;s a tensor, it should contain one color channel (L)
instead of 3, so the expected shape would be <code>(B, H, W, 1)</code>.`,name:"mask_image"},{anchor:"diffusers.StableDiffusionXLControlNetInpaintPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to self.unet.config.sample_size * self.vae_scale_factor) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.StableDiffusionXLControlNetInpaintPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to self.unet.config.sample_size * self.vae_scale_factor) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"diffusers.StableDiffusionXLControlNetInpaintPipeline.__call__.padding_mask_crop",description:`<strong>padding_mask_crop</strong> (<code>int</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
The size of margin in the crop to be applied to the image and masking. If <code>None</code>, no crop is applied to
image and mask_image. If <code>padding_mask_crop</code> is not <code>None</code>, it will first find a rectangular region
with the same aspect ration of the image and contains all masked area, and then expand that area based
on <code>padding_mask_crop</code>. The image and mask_image will then be cropped based on the expanded area before
resizing to the original image size for inpainting. This is useful when the masked area is small while
the image is large and contain information irrelevant for inpainting, such as background.`,name:"padding_mask_crop"},{anchor:"diffusers.StableDiffusionXLControlNetInpaintPipeline.__call__.strength",description:`<strong>strength</strong> (<code>float</code>, <em>optional</em>, defaults to 0.9999) &#x2014;
Conceptually, indicates how much to transform the masked portion of the reference <code>image</code>. Must be
between 0 and 1. <code>image</code> will be used as a starting point, adding more noise to it the larger the
<code>strength</code>. The number of denoising steps depends on the amount of noise initially added. When
<code>strength</code> is 1, added noise will be maximum and the denoising process will run for the full number of
iterations specified in <code>num_inference_steps</code>. A value of 1, therefore, essentially ignores the masked
portion of the reference <code>image</code>. Note that in the case of <code>denoising_start</code> being declared as an
integer, the value of <code>strength</code> will be ignored.`,name:"strength"},{anchor:"diffusers.StableDiffusionXLControlNetInpaintPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.StableDiffusionXLControlNetInpaintPipeline.__call__.denoising_start",description:`<strong>denoising_start</strong> (<code>float</code>, <em>optional</em>) &#x2014;
When specified, indicates the fraction (between 0.0 and 1.0) of the total denoising process to be
bypassed before it is initiated. Consequently, the initial part of the denoising process is skipped and
it is assumed that the passed <code>image</code> is a partly denoised image. Note that when this is specified,
strength will be ignored. The <code>denoising_start</code> parameter is particularly beneficial when this pipeline
is integrated into a &#x201C;Mixture of Denoisers&#x201D; multi-pipeline setup, as detailed in <a href="https://huggingface.co/docs/diffusers/api/pipelines/stable_diffusion/stable_diffusion_xl#refining-the-image-output" rel="nofollow"><strong>Refining the Image
Output</strong></a>.`,name:"denoising_start"},{anchor:"diffusers.StableDiffusionXLControlNetInpaintPipeline.__call__.denoising_end",description:`<strong>denoising_end</strong> (<code>float</code>, <em>optional</em>) &#x2014;
When specified, determines the fraction (between 0.0 and 1.0) of the total denoising process to be
completed before it is intentionally prematurely terminated. As a result, the returned sample will
still retain a substantial amount of noise (ca. final 20% of timesteps still needed) and should be
denoised by a successor pipeline that has <code>denoising_start</code> set to 0.8 so that it only denoises the
final 20% of the scheduler. The denoising_end parameter should ideally be utilized when this pipeline
forms a part of a &#x201C;Mixture of Denoisers&#x201D; multi-pipeline setup, as elaborated in <a href="https://huggingface.co/docs/diffusers/api/pipelines/stable_diffusion/stable_diffusion_xl#refining-the-image-output" rel="nofollow"><strong>Refining the Image
Output</strong></a>.`,name:"denoising_end"},{anchor:"diffusers.StableDiffusionXLControlNetInpaintPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 7.5) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.StableDiffusionXLControlNetInpaintPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.StableDiffusionXLControlNetInpaintPipeline.__call__.negative_prompt_2",description:`<strong>negative_prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation to be sent to <code>tokenizer_2</code> and
<code>text_encoder_2</code>. If not defined, <code>negative_prompt</code> is used in both text-encoders`,name:"negative_prompt_2"},{anchor:"diffusers.StableDiffusionXLControlNetInpaintPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.StableDiffusionXLControlNetInpaintPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.StableDiffusionXLControlNetInpaintPipeline.__call__.ip_adapter_image",description:"<strong>ip_adapter_image</strong> &#x2014; (<code>PipelineImageInput</code>, <em>optional</em>): Optional image input to work with IP Adapters.",name:"ip_adapter_image"},{anchor:"diffusers.StableDiffusionXLControlNetInpaintPipeline.__call__.ip_adapter_image_embeds",description:`<strong>ip_adapter_image_embeds</strong> (<code>List[torch.Tensor]</code>, <em>optional</em>) &#x2014;
Pre-generated image embeddings for IP-Adapter. It should be a list of length same as number of
IP-adapters. Each element should be a tensor of shape <code>(batch_size, num_images, emb_dim)</code>. It should
contain the negative image embedding if <code>do_classifier_free_guidance</code> is set to <code>True</code>. If not
provided, embeddings are computed from the <code>ip_adapter_image</code> input argument.`,name:"ip_adapter_image_embeds"},{anchor:"diffusers.StableDiffusionXLControlNetInpaintPipeline.__call__.pooled_prompt_embeds",description:`<strong>pooled_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting.
If not provided, pooled text embeddings will be generated from <code>prompt</code> input argument.`,name:"pooled_prompt_embeds"},{anchor:"diffusers.StableDiffusionXLControlNetInpaintPipeline.__call__.negative_pooled_prompt_embeds",description:`<strong>negative_pooled_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, pooled negative_prompt_embeds will be generated from <code>negative_prompt</code>
input argument.`,name:"negative_pooled_prompt_embeds"},{anchor:"diffusers.StableDiffusionXLControlNetInpaintPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.StableDiffusionXLControlNetInpaintPipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) in the DDIM paper: <a href="https://arxiv.org/abs/2010.02502" rel="nofollow">https://arxiv.org/abs/2010.02502</a>. Only applies to
<a href="/docs/diffusers/pr_10058/en/api/schedulers/ddim#diffusers.DDIMScheduler">schedulers.DDIMScheduler</a>, will be ignored for others.`,name:"eta"},{anchor:"diffusers.StableDiffusionXLControlNetInpaintPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.StableDiffusionXLControlNetInpaintPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.StableDiffusionXLControlNetInpaintPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between
<a href="https://pillow.readthedocs.io/en/stable/" rel="nofollow">PIL</a>: <code>PIL.Image.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.StableDiffusionXLControlNetInpaintPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/pr_10058/en/api/pipelines/stable_diffusion/inpaint#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput">StableDiffusionPipelineOutput</a> instead of a
plain tuple.`,name:"return_dict"},{anchor:"diffusers.StableDiffusionXLControlNetInpaintPipeline.__call__.cross_attention_kwargs",description:`<strong>cross_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined under
<code>self.processor</code> in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow">diffusers.models.attention_processor</a>.`,name:"cross_attention_kwargs"},{anchor:"diffusers.StableDiffusionXLControlNetInpaintPipeline.__call__.original_size",description:`<strong>original_size</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to (1024, 1024)) &#x2014;
If <code>original_size</code> is not the same as <code>target_size</code> the image will appear to be down- or upsampled.
<code>original_size</code> defaults to <code>(width, height)</code> if not specified. Part of SDXL&#x2019;s micro-conditioning as
explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>.`,name:"original_size"},{anchor:"diffusers.StableDiffusionXLControlNetInpaintPipeline.__call__.crops_coords_top_left",description:`<strong>crops_coords_top_left</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to (0, 0)) &#x2014;
<code>crops_coords_top_left</code> can be used to generate an image that appears to be &#x201C;cropped&#x201D; from the position
<code>crops_coords_top_left</code> downwards. Favorable, well-centered images are usually achieved by setting
<code>crops_coords_top_left</code> to (0, 0). Part of SDXL&#x2019;s micro-conditioning as explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>.`,name:"crops_coords_top_left"},{anchor:"diffusers.StableDiffusionXLControlNetInpaintPipeline.__call__.target_size",description:`<strong>target_size</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to (1024, 1024)) &#x2014;
For most cases, <code>target_size</code> should be set to the desired height and width of the generated image. If
not specified it will default to <code>(width, height)</code>. Part of SDXL&#x2019;s micro-conditioning as explained in
section 2.2 of <a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>.`,name:"target_size"},{anchor:"diffusers.StableDiffusionXLControlNetInpaintPipeline.__call__.aesthetic_score",description:`<strong>aesthetic_score</strong> (<code>float</code>, <em>optional</em>, defaults to 6.0) &#x2014;
Used to simulate an aesthetic score of the generated image by influencing the positive text condition.
Part of SDXL&#x2019;s micro-conditioning as explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>.`,name:"aesthetic_score"},{anchor:"diffusers.StableDiffusionXLControlNetInpaintPipeline.__call__.negative_aesthetic_score",description:`<strong>negative_aesthetic_score</strong> (<code>float</code>, <em>optional</em>, defaults to 2.5) &#x2014;
Part of SDXL&#x2019;s micro-conditioning as explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>. Can be used to
simulate an aesthetic score of the generated image by influencing the negative text condition.`,name:"negative_aesthetic_score"},{anchor:"diffusers.StableDiffusionXLControlNetInpaintPipeline.__call__.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"},{anchor:"diffusers.StableDiffusionXLControlNetInpaintPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <code>PipelineCallback</code>, <code>MultiPipelineCallbacks</code>, <em>optional</em>) &#x2014;
A function or a subclass of <code>PipelineCallback</code> or <code>MultiPipelineCallbacks</code> that is called at the end of
each denoising step during the inference. with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a
list of all tensors as specified by <code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.StableDiffusionXLControlNetInpaintPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"}],source:"https://github.com/huggingface/diffusers/blob/vr_10058/src/diffusers/pipelines/controlnet/pipeline_controlnet_inpaint_sd_xl.py#L1163",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.stable_diffusion.StableDiffusionXLPipelineOutput</code> if <code>return_dict</code> is True, otherwise a
<code>tuple. </code>tuple. When returning a tuple, the first element is a list with the generated images.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.stable_diffusion.StableDiffusionXLPipelineOutput</code> or <code>tuple</code></p>
`}}),E=new Wt({props:{anchor:"diffusers.StableDiffusionXLControlNetInpaintPipeline.__call__.example",$$slots:{default:[Tn]},$$scope:{ctx:J}}}),de=new k({props:{name:"encode_prompt",anchor:"diffusers.StableDiffusionXLControlNetInpaintPipeline.encode_prompt",parameters:[{name:"prompt",val:": str"},{name:"prompt_2",val:": typing.Optional[str] = None"},{name:"device",val:": typing.Optional[torch.device] = None"},{name:"num_images_per_prompt",val:": int = 1"},{name:"do_classifier_free_guidance",val:": bool = True"},{name:"negative_prompt",val:": typing.Optional[str] = None"},{name:"negative_prompt_2",val:": typing.Optional[str] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"pooled_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_pooled_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"lora_scale",val:": typing.Optional[float] = None"},{name:"clip_skip",val:": typing.Optional[int] = None"}],parametersDescription:[{anchor:"diffusers.StableDiffusionXLControlNetInpaintPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded`,name:"prompt"},{anchor:"diffusers.StableDiffusionXLControlNetInpaintPipeline.encode_prompt.prompt_2",description:`<strong>prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to be sent to the <code>tokenizer_2</code> and <code>text_encoder_2</code>. If not defined, <code>prompt</code> is
used in both text-encoders`,name:"prompt_2"},{anchor:"diffusers.StableDiffusionXLControlNetInpaintPipeline.encode_prompt.device",description:`<strong>device</strong> &#x2014; (<code>torch.device</code>):
torch device`,name:"device"},{anchor:"diffusers.StableDiffusionXLControlNetInpaintPipeline.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>) &#x2014;
number of images that should be generated per prompt`,name:"num_images_per_prompt"},{anchor:"diffusers.StableDiffusionXLControlNetInpaintPipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>) &#x2014;
whether to use classifier free guidance or not`,name:"do_classifier_free_guidance"},{anchor:"diffusers.StableDiffusionXLControlNetInpaintPipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.StableDiffusionXLControlNetInpaintPipeline.encode_prompt.negative_prompt_2",description:`<strong>negative_prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation to be sent to <code>tokenizer_2</code> and
<code>text_encoder_2</code>. If not defined, <code>negative_prompt</code> is used in both text-encoders`,name:"negative_prompt_2"},{anchor:"diffusers.StableDiffusionXLControlNetInpaintPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.StableDiffusionXLControlNetInpaintPipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.StableDiffusionXLControlNetInpaintPipeline.encode_prompt.pooled_prompt_embeds",description:`<strong>pooled_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting.
If not provided, pooled text embeddings will be generated from <code>prompt</code> input argument.`,name:"pooled_prompt_embeds"},{anchor:"diffusers.StableDiffusionXLControlNetInpaintPipeline.encode_prompt.negative_pooled_prompt_embeds",description:`<strong>negative_pooled_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, pooled negative_prompt_embeds will be generated from <code>negative_prompt</code>
input argument.`,name:"negative_pooled_prompt_embeds"},{anchor:"diffusers.StableDiffusionXLControlNetInpaintPipeline.encode_prompt.lora_scale",description:`<strong>lora_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
A lora scale that will be applied to all LoRA layers of the text encoder if LoRA layers are loaded.`,name:"lora_scale"},{anchor:"diffusers.StableDiffusionXLControlNetInpaintPipeline.encode_prompt.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"}],source:"https://github.com/huggingface/diffusers/blob/vr_10058/src/diffusers/pipelines/controlnet/pipeline_controlnet_inpaint_sd_xl.py#L284"}}),ce=new ze({props:{title:"StableDiffusionPipelineOutput",local:"diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput",headingTag:"h2"}}),me=new k({props:{name:"class diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput",anchor:"diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput",parameters:[{name:"images",val:": typing.Union[typing.List[PIL.Image.Image], numpy.ndarray]"},{name:"nsfw_content_detected",val:": typing.Optional[typing.List[bool]]"}],parametersDescription:[{anchor:"diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput.images",description:`<strong>images</strong> (<code>List[PIL.Image.Image]</code> or <code>np.ndarray</code>) &#x2014;
List of denoised PIL images of length <code>batch_size</code> or NumPy array of shape <code>(batch_size, height, width, num_channels)</code>.`,name:"images"},{anchor:"diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput.nsfw_content_detected",description:`<strong>nsfw_content_detected</strong> (<code>List[bool]</code>) &#x2014;
List indicating whether the corresponding generated image contains &#x201C;not-safe-for-work&#x201D; (nsfw) content or
<code>None</code> if safety checking could not be performed.`,name:"nsfw_content_detected"}],source:"https://github.com/huggingface/diffusers/blob/vr_10058/src/diffusers/pipelines/stable_diffusion/pipeline_output.py#L10"}}),ge=new yn({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/api/pipelines/controlnet_sdxl.md"}}),{c(){a=l("meta"),I=i(),c=l("p"),m=i(),f(v.$$.fragment),r=i(),M=l("p"),M.innerHTML=Gt,Be=i(),Y=l("p"),Y.textContent=Bt,$e=i(),V=l("p"),V.textContent=$t,Re=i(),Q=l("p"),Q.innerHTML=Rt,Ae=i(),O=l("p"),O.innerHTML=At,Ee=i(),f(W.$$.fragment),Fe=i(),H=l("p"),H.innerHTML=Et,Ye=i(),f(z.$$.fragment),Ve=i(),f(q.$$.fragment),Qe=i(),w=l("div"),f(K.$$.fragment),lt=i(),_e=l("p"),_e.textContent=Ft,pt=i(),he=l("p"),he.innerHTML=Yt,dt=i(),be=l("p"),be.textContent=Vt,ct=i(),ye=l("ul"),ye.innerHTML=Qt,mt=i(),S=l("div"),f(ee.$$.fragment),gt=i(),ve=l("p"),ve.textContent=Ot,ft=i(),f(G.$$.fragment),ut=i(),B=l("div"),f(te.$$.fragment),_t=i(),we=l("p"),we.textContent=Ht,ht=i(),$=l("div"),f(ne.$$.fragment),bt=i(),Ie=l("p"),Ie.innerHTML=qt,Oe=i(),f(oe.$$.fragment),He=i(),T=l("div"),f(ie.$$.fragment),yt=i(),Me=l("p"),Me.textContent=Kt,vt=i(),Te=l("p"),Te.innerHTML=en,wt=i(),Ce=l("p"),Ce.textContent=tn,It=i(),xe=l("ul"),xe.innerHTML=nn,Mt=i(),D=l("div"),f(se.$$.fragment),Tt=i(),Le=l("p"),Le.textContent=on,Ct=i(),f(R.$$.fragment),xt=i(),A=l("div"),f(ae.$$.fragment),Lt=i(),Ne=l("p"),Ne.textContent=sn,qe=i(),f(re.$$.fragment),Ke=i(),C=l("div"),f(le.$$.fragment),Nt=i(),je=l("p"),je.textContent=an,jt=i(),Pe=l("p"),Pe.innerHTML=rn,Pt=i(),Je=l("p"),Je.textContent=ln,Jt=i(),ke=l("ul"),ke.innerHTML=pn,kt=i(),U=l("div"),f(pe.$$.fragment),St=i(),Se=l("p"),Se.textContent=dn,Dt=i(),f(E.$$.fragment),Ut=i(),F=l("div"),f(de.$$.fragment),Xt=i(),De=l("p"),De.textContent=cn,et=i(),f(ce.$$.fragment),tt=i(),X=l("div"),f(me.$$.fragment),Zt=i(),Ue=l("p"),Ue.textContent=mn,nt=i(),f(ge.$$.fragment),ot=i(),We=l("p"),this.h()},l(e){const o=bn("svelte-u9bgzb",document.head);a=p(o,"META",{name:!0,content:!0}),o.forEach(n),I=s(e),c=p(e,"P",{}),j(c).forEach(n),m=s(e),u(v.$$.fragment,e),r=s(e),M=p(e,"P",{"data-svelte-h":!0}),g(M)!=="svelte-1v2xz23"&&(M.innerHTML=Gt),Be=s(e),Y=p(e,"P",{"data-svelte-h":!0}),g(Y)!=="svelte-1dn0wji"&&(Y.textContent=Bt),$e=s(e),V=p(e,"P",{"data-svelte-h":!0}),g(V)!=="svelte-1cwsb16"&&(V.textContent=$t),Re=s(e),Q=p(e,"P",{"data-svelte-h":!0}),g(Q)!=="svelte-fbiw6t"&&(Q.innerHTML=Rt),Ae=s(e),O=p(e,"P",{"data-svelte-h":!0}),g(O)!=="svelte-qc26k5"&&(O.innerHTML=At),Ee=s(e),u(W.$$.fragment,e),Fe=s(e),H=p(e,"P",{"data-svelte-h":!0}),g(H)!=="svelte-1gi3meg"&&(H.innerHTML=Et),Ye=s(e),u(z.$$.fragment,e),Ve=s(e),u(q.$$.fragment,e),Qe=s(e),w=p(e,"DIV",{class:!0});var x=j(w);u(K.$$.fragment,x),lt=s(x),_e=p(x,"P",{"data-svelte-h":!0}),g(_e)!=="svelte-ehlo5w"&&(_e.textContent=Ft),pt=s(x),he=p(x,"P",{"data-svelte-h":!0}),g(he)!=="svelte-h5288q"&&(he.innerHTML=Yt),dt=s(x),be=p(x,"P",{"data-svelte-h":!0}),g(be)!=="svelte-14s6m4u"&&(be.textContent=Vt),ct=s(x),ye=p(x,"UL",{"data-svelte-h":!0}),g(ye)!=="svelte-nj2ywp"&&(ye.innerHTML=Qt),mt=s(x),S=p(x,"DIV",{class:!0});var Z=j(S);u(ee.$$.fragment,Z),gt=s(Z),ve=p(Z,"P",{"data-svelte-h":!0}),g(ve)!=="svelte-50j04k"&&(ve.textContent=Ot),ft=s(Z),u(G.$$.fragment,Z),Z.forEach(n),ut=s(x),B=p(x,"DIV",{class:!0});var fe=j(B);u(te.$$.fragment,fe),_t=s(fe),we=p(fe,"P",{"data-svelte-h":!0}),g(we)!=="svelte-16q0ax1"&&(we.textContent=Ht),fe.forEach(n),ht=s(x),$=p(x,"DIV",{class:!0});var ue=j($);u(ne.$$.fragment,ue),bt=s(ue),Ie=p(ue,"P",{"data-svelte-h":!0}),g(Ie)!=="svelte-vo59ec"&&(Ie.innerHTML=qt),ue.forEach(n),x.forEach(n),Oe=s(e),u(oe.$$.fragment,e),He=s(e),T=p(e,"DIV",{class:!0});var L=j(T);u(ie.$$.fragment,L),yt=s(L),Me=p(L,"P",{"data-svelte-h":!0}),g(Me)!=="svelte-1q9vn04"&&(Me.textContent=Kt),vt=s(L),Te=p(L,"P",{"data-svelte-h":!0}),g(Te)!=="svelte-d1wgcf"&&(Te.innerHTML=en),wt=s(L),Ce=p(L,"P",{"data-svelte-h":!0}),g(Ce)!=="svelte-14s6m4u"&&(Ce.textContent=tn),It=s(L),xe=p(L,"UL",{"data-svelte-h":!0}),g(xe)!=="svelte-wa1ung"&&(xe.innerHTML=nn),Mt=s(L),D=p(L,"DIV",{class:!0});var Xe=j(D);u(se.$$.fragment,Xe),Tt=s(Xe),Le=p(Xe,"P",{"data-svelte-h":!0}),g(Le)!=="svelte-v78lg8"&&(Le.textContent=on),Ct=s(Xe),u(R.$$.fragment,Xe),Xe.forEach(n),xt=s(L),A=p(L,"DIV",{class:!0});var st=j(A);u(ae.$$.fragment,st),Lt=s(st),Ne=p(st,"P",{"data-svelte-h":!0}),g(Ne)!=="svelte-16q0ax1"&&(Ne.textContent=sn),st.forEach(n),L.forEach(n),qe=s(e),u(re.$$.fragment,e),Ke=s(e),C=p(e,"DIV",{class:!0});var N=j(C);u(le.$$.fragment,N),Nt=s(N),je=p(N,"P",{"data-svelte-h":!0}),g(je)!=="svelte-1q4yve"&&(je.textContent=an),jt=s(N),Pe=p(N,"P",{"data-svelte-h":!0}),g(Pe)!=="svelte-d1wgcf"&&(Pe.innerHTML=rn),Pt=s(N),Je=p(N,"P",{"data-svelte-h":!0}),g(Je)!=="svelte-14s6m4u"&&(Je.textContent=ln),Jt=s(N),ke=p(N,"UL",{"data-svelte-h":!0}),g(ke)!=="svelte-nj2ywp"&&(ke.innerHTML=pn),kt=s(N),U=p(N,"DIV",{class:!0});var Ze=j(U);u(pe.$$.fragment,Ze),St=s(Ze),Se=p(Ze,"P",{"data-svelte-h":!0}),g(Se)!=="svelte-v78lg8"&&(Se.textContent=dn),Dt=s(Ze),u(E.$$.fragment,Ze),Ze.forEach(n),Ut=s(N),F=p(N,"DIV",{class:!0});var at=j(F);u(de.$$.fragment,at),Xt=s(at),De=p(at,"P",{"data-svelte-h":!0}),g(De)!=="svelte-16q0ax1"&&(De.textContent=cn),at.forEach(n),N.forEach(n),et=s(e),u(ce.$$.fragment,e),tt=s(e),X=p(e,"DIV",{class:!0});var rt=j(X);u(me.$$.fragment,rt),Zt=s(rt),Ue=p(rt,"P",{"data-svelte-h":!0}),g(Ue)!=="svelte-1qpjiuf"&&(Ue.textContent=mn),rt.forEach(n),nt=s(e),u(ge.$$.fragment,e),ot=s(e),We=p(e,"P",{}),j(We).forEach(n),this.h()},h(){P(a,"name","hf:doc:metadata"),P(a,"content",xn),P(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),P(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),P($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),P(w,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),P(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),P(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),P(T,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),P(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),P(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),P(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),P(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,o){t(document.head,a),d(e,I,o),d(e,c,o),d(e,m,o),_(v,e,o),d(e,r,o),d(e,M,o),d(e,Be,o),d(e,Y,o),d(e,$e,o),d(e,V,o),d(e,Re,o),d(e,Q,o),d(e,Ae,o),d(e,O,o),d(e,Ee,o),_(W,e,o),d(e,Fe,o),d(e,H,o),d(e,Ye,o),_(z,e,o),d(e,Ve,o),_(q,e,o),d(e,Qe,o),d(e,w,o),_(K,w,null),t(w,lt),t(w,_e),t(w,pt),t(w,he),t(w,dt),t(w,be),t(w,ct),t(w,ye),t(w,mt),t(w,S),_(ee,S,null),t(S,gt),t(S,ve),t(S,ft),_(G,S,null),t(w,ut),t(w,B),_(te,B,null),t(B,_t),t(B,we),t(w,ht),t(w,$),_(ne,$,null),t($,bt),t($,Ie),d(e,Oe,o),_(oe,e,o),d(e,He,o),d(e,T,o),_(ie,T,null),t(T,yt),t(T,Me),t(T,vt),t(T,Te),t(T,wt),t(T,Ce),t(T,It),t(T,xe),t(T,Mt),t(T,D),_(se,D,null),t(D,Tt),t(D,Le),t(D,Ct),_(R,D,null),t(T,xt),t(T,A),_(ae,A,null),t(A,Lt),t(A,Ne),d(e,qe,o),_(re,e,o),d(e,Ke,o),d(e,C,o),_(le,C,null),t(C,Nt),t(C,je),t(C,jt),t(C,Pe),t(C,Pt),t(C,Je),t(C,Jt),t(C,ke),t(C,kt),t(C,U),_(pe,U,null),t(U,St),t(U,Se),t(U,Dt),_(E,U,null),t(C,Ut),t(C,F),_(de,F,null),t(F,Xt),t(F,De),d(e,et,o),_(ce,e,o),d(e,tt,o),d(e,X,o),_(me,X,null),t(X,Zt),t(X,Ue),d(e,nt,o),_(ge,e,o),d(e,ot,o),d(e,We,o),it=!0},p(e,[o]){const x={};o&2&&(x.$$scope={dirty:o,ctx:e}),W.$set(x);const Z={};o&2&&(Z.$$scope={dirty:o,ctx:e}),z.$set(Z);const fe={};o&2&&(fe.$$scope={dirty:o,ctx:e}),G.$set(fe);const ue={};o&2&&(ue.$$scope={dirty:o,ctx:e}),R.$set(ue);const L={};o&2&&(L.$$scope={dirty:o,ctx:e}),E.$set(L)},i(e){it||(h(v.$$.fragment,e),h(W.$$.fragment,e),h(z.$$.fragment,e),h(q.$$.fragment,e),h(K.$$.fragment,e),h(ee.$$.fragment,e),h(G.$$.fragment,e),h(te.$$.fragment,e),h(ne.$$.fragment,e),h(oe.$$.fragment,e),h(ie.$$.fragment,e),h(se.$$.fragment,e),h(R.$$.fragment,e),h(ae.$$.fragment,e),h(re.$$.fragment,e),h(le.$$.fragment,e),h(pe.$$.fragment,e),h(E.$$.fragment,e),h(de.$$.fragment,e),h(ce.$$.fragment,e),h(me.$$.fragment,e),h(ge.$$.fragment,e),it=!0)},o(e){b(v.$$.fragment,e),b(W.$$.fragment,e),b(z.$$.fragment,e),b(q.$$.fragment,e),b(K.$$.fragment,e),b(ee.$$.fragment,e),b(G.$$.fragment,e),b(te.$$.fragment,e),b(ne.$$.fragment,e),b(oe.$$.fragment,e),b(ie.$$.fragment,e),b(se.$$.fragment,e),b(R.$$.fragment,e),b(ae.$$.fragment,e),b(re.$$.fragment,e),b(le.$$.fragment,e),b(pe.$$.fragment,e),b(E.$$.fragment,e),b(de.$$.fragment,e),b(ce.$$.fragment,e),b(me.$$.fragment,e),b(ge.$$.fragment,e),it=!1},d(e){e&&(n(I),n(c),n(m),n(r),n(M),n(Be),n(Y),n($e),n(V),n(Re),n(Q),n(Ae),n(O),n(Ee),n(Fe),n(H),n(Ye),n(Ve),n(Qe),n(w),n(Oe),n(He),n(T),n(qe),n(Ke),n(C),n(et),n(tt),n(X),n(nt),n(ot),n(We)),n(a),y(v,e),y(W,e),y(z,e),y(q,e),y(K),y(ee),y(G),y(te),y(ne),y(oe,e),y(ie),y(se),y(R),y(ae),y(re,e),y(le),y(pe),y(E),y(de),y(ce,e),y(me),y(ge,e)}}}const xn='{"title":"ControlNet with Stable Diffusion XL","local":"controlnet-with-stable-diffusion-xl","sections":[{"title":"StableDiffusionXLControlNetPipeline","local":"diffusers.StableDiffusionXLControlNetPipeline","sections":[],"depth":2},{"title":"StableDiffusionXLControlNetImg2ImgPipeline","local":"diffusers.StableDiffusionXLControlNetImg2ImgPipeline","sections":[],"depth":2},{"title":"StableDiffusionXLControlNetInpaintPipeline","local":"diffusers.StableDiffusionXLControlNetInpaintPipeline","sections":[],"depth":2},{"title":"StableDiffusionPipelineOutput","local":"diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput","sections":[],"depth":2}],"depth":1}';function Ln(J){return un(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Un extends _n{constructor(a){super(),hn(this,a,Ln,Cn,fn,{})}}export{Un as component};
