import{s as Is,o as Ws,n as lt}from"../chunks/scheduler.defa9a21.js";import{S as Bs,i as qs,g as o,s as a,r as m,A as Ps,h as p,f as l,c as n,j as xs,u as c,x as r,k as Zs,y as Rs,a as s,v as h,d as f,t as u,w as y}from"../chunks/index.fe795e71.js";import{T as tt}from"../chunks/Tip.179eb360.js";import{Y as zs}from"../chunks/Youtube.73056ec3.js";import{C as $}from"../chunks/CodeBlock.42404125.js";import{H as _,E as Qs}from"../chunks/EditOnGithub.0f575778.js";function As(b){let i,M="This API is quite new and still in its experimental stage. While we strive to provide a stable API, it’s possible some small parts of the public API will change in the future.";return{c(){i=o("p"),i.textContent=M},l(d){i=p(d,"P",{"data-svelte-h":!0}),r(i)!=="svelte-1yc3yd7"&&(i.textContent=M)},m(d,w){s(d,i,w)},p:lt,d(d){d&&l(i)}}}function Xs(b){let i,M="You can’t move a model initialized like this on CPU or another device directly, since it doesn’t have any data. It’s also very likely that a forward pass with that empty model will fail, as not all operations are supported on the meta device.";return{c(){i=o("p"),i.textContent=M},l(d){i=p(d,"P",{"data-svelte-h":!0}),r(i)!=="svelte-vdgsa6"&&(i.textContent=M)},m(d,w){s(d,i,w)},p:lt,d(d){d&&l(i)}}}function Es(b){let i,M="This only supports the inference of your model, not training. Most of the computation happens behind <code>torch.no_grad()</code> context managers to avoid spending some GPU memory with intermediate activations.";return{c(){i=o("p"),i.innerHTML=M},l(d){i=p(d,"P",{"data-svelte-h":!0}),r(i)!=="svelte-1a0gshx"&&(i.innerHTML=M)},m(d,w){s(d,i,w)},p:lt,d(d){d&&l(i)}}}function Hs(b){let i,M="You can derive all sizes of the model (and thus compute a <code>device_map</code>) on a model that is on the meta device.";return{c(){i=o("p"),i.innerHTML=M},l(d){i=p(d,"P",{"data-svelte-h":!0}),r(i)!=="svelte-1r7jnyr"&&(i.innerHTML=M)},m(d,w){s(d,i,w)},p:lt,d(d){d&&l(i)}}}function Ls(b){let i,M="The options <code>&quot;auto&quot;</code> and <code>&quot;balanced&quot;</code> produce the same results for now, but the behavior of <code>&quot;auto&quot;</code> might change in the future if we find a strategy that makes more sense, while <code>&quot;balanced&quot;</code> will stay stable.";return{c(){i=o("p"),i.innerHTML=M},l(d){i=p(d,"P",{"data-svelte-h":!0}),r(i)!=="svelte-vyehzb"&&(i.innerHTML=M)},m(d,w){s(d,i,w)},p:lt,d(d){d&&l(i)}}}function Ns(b){let i,M="When a first allocation happens in PyTorch, it loads CUDA kernels which take about 1-2GB of memory depending on the GPU. Therefore you always have less usable memory than the actual size of the GPU. To see how much memory is actually used do <code>torch.ones(1).cuda()</code> and look at the memory usage.",d,w,j="Therefore when you create memory maps with <code>max_memory</code> make sure to adjust the available memory accordingly to avoid out-of-memory errors.";return{c(){i=o("p"),i.innerHTML=M,d=a(),w=o("p"),w.innerHTML=j},l(g){i=p(g,"P",{"data-svelte-h":!0}),r(i)!=="svelte-1l1ovnr"&&(i.innerHTML=M),d=n(g),w=p(g,"P",{"data-svelte-h":!0}),r(w)!=="svelte-1sybea"&&(w.innerHTML=j)},m(g,v){s(g,i,v),s(g,d,v),s(g,w,v)},p:lt,d(g){g&&(l(i),l(d),l(w))}}}function Ys(b){let i,M="To be the most efficient, make sure your device map puts the parameters on the GPUs in a sequential manner (e.g. don’t put one of the first weights on GPU 0, then weights on GPU 1 and the last weight back to GPU 0) to avoid making many transfers of data between the GPUs.";return{c(){i=o("p"),i.textContent=M},l(d){i=p(d,"P",{"data-svelte-h":!0}),r(i)!=="svelte-1j5mha8"&&(i.textContent=M)},m(d,w){s(d,i,w)},p:lt,d(d){d&&l(i)}}}function Ss(b){let i,M,d,w,j,g,v,ql="When loading a pre-trained model in PyTorch, the usual workflow looks like this:",at,Z,nt,I,Pl="In plain English, those steps are:",it,W,Rl="<li>Create the model with randomly initialized weights</li> <li>Load the model weights (in a dictionary usually called a state dict) from the disk</li> <li>Load those weights inside the model</li>",ot,B,zl="While this works very well for regularly sized models, this workflow has some clear limitations when we deal with a huge model: in step 1, we load a full version of the model in RAM, and spend some time randomly initializing the weights (which will be discarded in step 3). In step 2, we load another full version of the model in RAM, with the pre-trained weights. If you’re loading a model with 6 billion parameters, this means you will need 24GB of RAM for each copy of the model, so 48GB in total (half of it to load the model in FP16).",pt,U,rt,q,dt,P,mt,R,ct,z,ht,Q,Ql='The first tool 🤗 Accelerate introduces to help with big models is a context manager <a href="/docs/accelerate/pr_2878/en/package_reference/big_modeling#accelerate.init_empty_weights">init_empty_weights()</a> that helps you initialize a model without using any RAM so that step 1 can be done on models of any size. Here is how it works:',ft,A,ut,X,Al="For instance:",yt,E,Mt,H,Xl="initializes an empty model with a bit more than 100B parameters. Behind the scenes, this relies on the meta device introduced in PyTorch 1.9. During the initialization under the context manager, each time a parameter is created, it is instantly moved to that device.",wt,k,$t,L,bt,N,El="It’s possible your model is so big that even a single copy won’t fit in RAM. That doesn’t mean it can’t be loaded: if you have one or several GPUs, this is more memory available to store your model. In this case, it’s better if your checkpoint is split into several smaller files that we call checkpoint shards.",gt,Y,Hl='🤗 Accelerate will handle sharded checkpoints as long as you follow the following format: your checkpoint should be in a folder, with several files containing the partial state dicts, and there should be an index in the JSON format that contains a dictionary mapping parameter names to the file containing their weights. You can easily shard your model with <a href="/docs/accelerate/pr_2878/en/package_reference/accelerator#accelerate.Accelerator.save_model">save_model()</a>. For instance, we could have a folder containing:',_t,S,vt,V,Ll="with index.json being the following file:",jt,F,Ut,D,Nl="and <code>first_state_dict.bin</code> containing the weights for <code>&quot;linear1.weight&quot;</code> and <code>&quot;linear1.bias&quot;</code>, <code>second_state_dict.bin</code> the ones for <code>&quot;linear2.weight&quot;</code> and <code>&quot;linear2.bias&quot;</code>",kt,K,Tt,O,Yl='The second tool 🤗 Accelerate introduces is a function <a href="/docs/accelerate/pr_2878/en/package_reference/big_modeling#accelerate.load_checkpoint_and_dispatch">load_checkpoint_and_dispatch()</a>, that will allow you to load a checkpoint inside your empty model. This supports full checkpoints (a single file containing the whole state dict) as well as sharded checkpoints. It will also automatically dispatch those weights across the devices you have available (GPUs, CPU RAM), so if you are loading a sharded checkpoint, the maximum RAM usage will be the size of the biggest shard.',Jt,ee,Sl='If you want to use big model inference with 🤗 Transformers models, check out this <a href="https://huggingface.co/docs/transformers/main/en/main_classes/model#large-model-loading" rel="nofollow">documentation</a>.',Ct,te,Vl='Here is how we can use this to load the <a href="https://huggingface.co/marcsun13/gpt2-xl-linear-sharded" rel="nofollow">GPT2-1.5B</a> model.',Gt,le,Fl="Let’s download the sharded version of this model.",xt,se,Zt,ae,It,ne,Dl="In order to initialize the model, we will use the library minGPT.",Wt,ie,Bt,oe,qt,pe,Kl="Then, load the checkpoint we just downloaded with:",Pt,re,Rt,de,Ol="By passing <code>device_map=&quot;auto&quot;</code>, we tell 🤗 Accelerate to determine automatically where to put each layer of the model depending on the available resources:",zt,me,es="<li>first, we use the maximum space available on the GPU(s)</li> <li>if we still need space, we store the remaining weights on the CPU</li> <li>if there is not enough RAM, we store the remaining weights on the hard drive as memory-mapped tensors</li>",Qt,ce,At,he,ts=`This parameter will indicate that some of the modules with the name <code>&quot;Block&quot;</code> should not be split across different devices. You should set here all blocks that
include a residual connection of some kind.`,Xt,fe,Et,ue,ls="You can see the <code>device_map</code> that 🤗 Accelerate picked by accessing the <code>hf_device_map</code> attribute of your model:",Ht,ye,Lt,Me,Nt,we,ss="It’s fully possible to create your own device map for the layers to use as well, specifying the GPU device to use (a number), <code>&quot;cpu&quot;</code>, or <code>&quot;disk&quot;</code> and pass this in:",Yt,$e,St,be,Vt,ge,as="Now that we have done this, our model lies across several devices, and maybe the hard drive. But it can still be used as a regular PyTorch model:",Ft,_e,Dt,ve,ns="Behind the scenes, 🤗 Accelerate added hooks to the model, so that:",Kt,je,is="<li>at each layer, the inputs are put on the right device (so even if your model is spread across several GPUs, it works)</li> <li>for the weights offloaded on the CPU, they are put on a GPU just before the forward pass and cleaned up just after</li> <li>for the weights offloaded on the hard drive, they are loaded in RAM then put on a GPU just before the forward pass and cleaned up just after</li>",Ot,Ue,os="This way, your model can run for inference even if it doesn’t fit on one of the GPUs or the CPU RAM!",el,T,tl,ke,ll,Te,ps="You can let 🤗 Accelerate handle the device map computation by setting <code>device_map</code> to one of the supported options (<code>&quot;auto&quot;</code>, <code>&quot;balanced&quot;</code>, <code>&quot;balanced_low_0&quot;</code>, <code>&quot;sequential&quot;</code>) or create one yourself if you want more control over where each layer should go.",sl,J,al,Je,rs="All the options will produce the same result when you don’t have enough GPU memory to accommodate the whole model (which is to fit everything that can on the GPU, then offload weights on the CPU or even on the disk if there is not enough RAM).",nl,Ce,ds="When you have more GPU memory available than the model size, here is the difference between each option:",il,Ge,ms="<li><code>&quot;auto&quot;</code> and <code>&quot;balanced&quot;</code> evenly split the model on all available GPUs, making it possible for you to use a batch size greater than 1.</li> <li><code>&quot;balanced_low_0&quot;</code> evenly splits the model on all GPUs except the first one, and only puts on GPU 0 what does not fit on the others. This option is great when you need to use GPU 0 for some processing of the outputs, like when using the <code>generate</code> function for Transformers models</li> <li><code>&quot;sequential&quot;</code> will fit what it can on GPU 0, then move on GPU 1 and so forth (so won’t use the last GPUs if it doesn’t need to).</li>",ol,C,pl,xe,cs='First note that you can limit the memory used on each GPU by using the <code>max_memory</code> argument (available in <a href="/docs/accelerate/pr_2878/en/package_reference/utilities#accelerate.infer_auto_device_map">infer_auto_device_map()</a> and in all functions using it). When setting <code>max_memory</code>, you should pass along a dictionary containing the GPU identifiers (for instance <code>0</code>, <code>1</code> etc.) and the <code>&quot;cpu&quot;</code> key for the maximum RAM you want to use for CPU offload. The values can either be an integer (in bytes) or a string representing a number with its unit, such as <code>&quot;10GiB&quot;</code> or <code>&quot;10GB&quot;</code>.',rl,Ze,hs="Here is an example where we don’t want to use more than 10GiB on each of the two GPUs and no more than 30GiB of CPU RAM for the model weights:",dl,Ie,ml,G,cl,We,fs="Additionally, if you do some additional operations with your outputs without placing them back on the CPU (for instance inside the <code>generate</code> method of Transformers) and if you placed your inputs on a GPU, that GPU will consume more memory than the others (Accelerate always place the output back to the device of the input). Therefore if you would like to optimize the maximum batch size and you have many GPUs, give the first GPU less memory. For example, with BLOOM-176B on 8x80 A100 setup, the close-to-ideal map is:",hl,Be,fl,qe,us="as you can see we gave the remaining 7 GPUs ~50% more memory than GPU 0.",ul,Pe,ys="If you opt to fully design the <code>device_map</code> yourself, it should be a dictionary with keys being module names of your model and values being a valid device identifier (for instance an integer for the GPUs) or <code>&quot;cpu&quot;</code> for CPU offload, <code>&quot;disk&quot;</code> for disk offload. The keys need to cover the whole model, you can then define your device map as you wish: for instance, if your model has two blocks (let’s say <code>block1</code> and <code>block2</code>) which each contain three linear layers (let’s say <code>linear1</code>, <code>linear2</code> and <code>linear3</code>), a valid device map can be:",yl,Re,Ml,ze,Ms="another one that is valid could be:",wl,Qe,$l,Ae,ws="On the other hand, this one is not valid as it does not cover every parameter of the model:",bl,Xe,gl,x,_l,Ee,vl,He,$s='If you want to offload your model on CPU, you can use <a href="/docs/accelerate/pr_2878/en/package_reference/big_modeling#accelerate.cpu_offload">cpu_offload()</a>. As a result, all parameters of the model will be offloaded and only one copy of the state dict of the model will be kept. During the forward pass, parameters will be extracted from that state dict and put on the execution device and passed as they are needed, then offloaded again.',jl,Le,Ul,Ne,bs='You can also use <a href="/docs/accelerate/pr_2878/en/package_reference/big_modeling#accelerate.cpu_offload_with_hook">cpu_offload_with_hook()</a>. This function will offloads a model on the CPU and puts it back to an execution device when executed. The difference with <a href="/docs/accelerate/pr_2878/en/package_reference/big_modeling#accelerate.cpu_offload">cpu_offload()</a> is that the model stays on the execution device after the forward and is only offloaded again when the <code>offload</code> method of the returned <code>hook</code> is called. Furthermore, <a href="/docs/accelerate/pr_2878/en/package_reference/big_modeling#accelerate.cpu_offload_with_hook">cpu_offload_with_hook()</a> is more performant but less memory saving. It is useful for pipelines running a model in a loop:',kl,Ye,Tl,Se,Jl,Ve,gs='To perform disk offload, you can use <a href="/docs/accelerate/pr_2878/en/package_reference/big_modeling#accelerate.disk_offload">disk_offload()</a>. As a result, all parameters of the model will be offloaded as memory-mapped array in a given folder. During the forward pass, parameters will be accessed from that folder and put on the execution device passed as they are needed, then offloaded again.',Cl,Fe,Gl,De,xl,Ke,_s="We are aware of the current limitations in the API:",Zl,Oe,vs='<li><a href="/docs/accelerate/pr_2878/en/package_reference/utilities#accelerate.infer_auto_device_map">infer_auto_device_map()</a> (or <code>device_map=&quot;auto&quot;</code> in <a href="/docs/accelerate/pr_2878/en/package_reference/big_modeling#accelerate.load_checkpoint_and_dispatch">load_checkpoint_and_dispatch()</a>) tries to maximize GPU and CPU RAM it sees available when you execute it. While PyTorch is very good at managing GPU RAM efficiently (and giving it back when not needed), it’s not entirely true with Python and CPU RAM. Therefore, an automatically computed device map might be too intense on the CPU. Move a few modules to the disk device if you get crashes due to a lack of RAM.</li> <li><a href="/docs/accelerate/pr_2878/en/package_reference/utilities#accelerate.infer_auto_device_map">infer_auto_device_map()</a> (or <code>device_map=&quot;auto&quot;</code> in <a href="/docs/accelerate/pr_2878/en/package_reference/big_modeling#accelerate.load_checkpoint_and_dispatch">load_checkpoint_and_dispatch()</a>) attributes devices sequentially (to avoid moving things back and forth) so if your first layer is bigger than the size of the GPU you have, it will end up with everything on the CPU/Disk.</li> <li><a href="/docs/accelerate/pr_2878/en/package_reference/big_modeling#accelerate.load_checkpoint_and_dispatch">load_checkpoint_and_dispatch()</a> and <a href="/docs/accelerate/pr_2878/en/package_reference/utilities#accelerate.load_checkpoint_in_model">load_checkpoint_in_model()</a> do not perform any check on the correctness of your state dict compared to your model at the moment (this will be fixed in a future version), so you may get some weird errors if trying to load a checkpoint with mismatched or missing keys.</li> <li>The model parallelism used when your model is split on several GPUs is naive and not optimized, meaning that only one GPU works at a given time and the other sits idle.</li> <li>When weights are offloaded on the CPU/hard drive, there is no pre-fetching (yet, we will work on this for future versions) which means the weights are put on the GPU when they are needed and not before.</li> <li>Hard-drive offloading might be very slow if the hardware you run on does not have fast communication between disk and CPU (like NVMes).</li>',Il,et,Wl,st,Bl;return j=new _({props:{title:"Handling big models for inference",local:"handling-big-models-for-inference",headingTag:"h1"}}),Z=new $({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEFteV9tb2RlbCUyMCUzRCUyME1vZGVsQ2xhc3MoLi4uKSUwQXN0YXRlX2RpY3QlMjAlM0QlMjB0b3JjaC5sb2FkKGNoZWNrcG9pbnRfZmlsZSklMEFteV9tb2RlbC5sb2FkX3N0YXRlX2RpY3Qoc3RhdGVfZGljdCk=",highlighted:`<span class="hljs-keyword">import</span> torch

my_model = ModelClass(...)
state_dict = torch.load(checkpoint_file)
my_model.load_state_dict(state_dict)`,wrap:!1}}),U=new tt({props:{warning:!0,$$slots:{default:[As]},$$scope:{ctx:b}}}),q=new _({props:{title:"How the Process Works: A Quick Overview",local:"how-the-process-works-a-quick-overview",headingTag:"h2"}}),P=new zs({props:{id:"MWCSGj9jEAo"}}),R=new _({props:{title:"How the Process Works: Working with Code",local:"how-the-process-works-working-with-code",headingTag:"h2"}}),z=new _({props:{title:"Instantiating an empty model",local:"instantiating-an-empty-model",headingTag:"h3"}}),A=new $({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBpbml0X2VtcHR5X3dlaWdodHMlMEElMEF3aXRoJTIwaW5pdF9lbXB0eV93ZWlnaHRzKCklM0ElMEElMjAlMjAlMjAlMjBteV9tb2RlbCUyMCUzRCUyME1vZGVsQ2xhc3MoLi4uKQ==",highlighted:`<span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> init_empty_weights

<span class="hljs-keyword">with</span> init_empty_weights():
    my_model = ModelClass(...)`,wrap:!1}}),E=new $({props:{code:"d2l0aCUyMGluaXRfZW1wdHlfd2VpZ2h0cygpJTNBJTBBJTIwJTIwJTIwJTIwbW9kZWwlMjAlM0QlMjBubi5TZXF1ZW50aWFsKColNUJubi5MaW5lYXIoMTAwMDAlMkMlMjAxMDAwMCklMjBmb3IlMjBfJTIwaW4lMjByYW5nZSgxMDAwKSU1RCk=",highlighted:`<span class="hljs-keyword">with</span> init_empty_weights():
    model = nn.Sequential(*[nn.Linear(<span class="hljs-number">10000</span>, <span class="hljs-number">10000</span>) <span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">1000</span>)])`,wrap:!1}}),k=new tt({props:{warning:!0,$$slots:{default:[Xs]},$$scope:{ctx:b}}}),L=new _({props:{title:"Sharded checkpoints",local:"sharded-checkpoints",headingTag:"h3"}}),S=new $({props:{code:"Zmlyc3Rfc3RhdGVfZGljdC5iaW4lMEFpbmRleC5qc29uJTBBc2Vjb25kX3N0YXRlX2RpY3QuYmlu",highlighted:`first_state_dict.bin
index.json
second_state_dict.bin`,wrap:!1}}),F=new $({props:{code:"JTdCJTBBJTIwJTIwJTIybGluZWFyMS53ZWlnaHQlMjIlM0ElMjAlMjJmaXJzdF9zdGF0ZV9kaWN0LmJpbiUyMiUyQyUwQSUyMCUyMCUyMmxpbmVhcjEuYmlhcyUyMiUzQSUyMCUyMmZpcnN0X3N0YXRlX2RpY3QuYmluJTIyJTJDJTBBJTIwJTIwJTIybGluZWFyMi53ZWlnaHQlMjIlM0ElMjAlMjJzZWNvbmRfc3RhdGVfZGljdC5iaW4lMjIlMkMlMEElMjAlMjAlMjJsaW5lYXIyLmJpYXMlMjIlM0ElMjAlMjJzZWNvbmRfc3RhdGVfZGljdC5iaW4lMjIlMEElN0Q=",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;linear1.weight&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;first_state_dict.bin&quot;</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;linear1.bias&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;first_state_dict.bin&quot;</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;linear2.weight&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;second_state_dict.bin&quot;</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;linear2.bias&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;second_state_dict.bin&quot;</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),K=new _({props:{title:"Loading weights",local:"loading-weights",headingTag:"h3"}}),se=new $({props:{code:"cGlwJTIwaW5zdGFsbCUyMGh1Z2dpbmdmYWNlX2h1Yg==",highlighted:"pip install huggingface_hub",wrap:!1}}),ae=new $({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHNuYXBzaG90X2Rvd25sb2FkJTBBY2hlY2twb2ludCUyMCUzRCUyMCUyMm1hcmNzdW4xMyUyRmdwdDIteGwtbGluZWFyLXNoYXJkZWQlMjIlMEF3ZWlnaHRzX2xvY2F0aW9uJTIwJTNEJTIwc25hcHNob3RfZG93bmxvYWQocmVwb19pZCUzRGNoZWNrcG9pbnQp",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> snapshot_download
checkpoint = <span class="hljs-string">&quot;marcsun13/gpt2-xl-linear-sharded&quot;</span>
weights_location = snapshot_download(repo_id=checkpoint)`,wrap:!1}}),ie=new $({props:{code:"Z2l0JTIwY2xvbmUlMjBodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZrYXJwYXRoeSUyRm1pbkdQVC5naXQlMEFwaXAlMjBpbnN0YWxsJTIwbWluR1BUJTJG",highlighted:`git <span class="hljs-built_in">clone</span> https://github.com/karpathy/minGPT.git
pip install minGPT/`,wrap:!1}}),oe=new $({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBpbml0X2VtcHR5X3dlaWdodHMlMEFmcm9tJTIwbWluZ3B0Lm1vZGVsJTIwaW1wb3J0JTIwR1BUJTBBJTBBbW9kZWxfY29uZmlnJTIwJTNEJTIwR1BULmdldF9kZWZhdWx0X2NvbmZpZygpJTBBbW9kZWxfY29uZmlnLm1vZGVsX3R5cGUlMjAlM0QlMjAnZ3B0Mi14bCclMEFtb2RlbF9jb25maWcudm9jYWJfc2l6ZSUyMCUzRCUyMDUwMjU3JTBBbW9kZWxfY29uZmlnLmJsb2NrX3NpemUlMjAlM0QlMjAxMDI0JTBBJTBBd2l0aCUyMGluaXRfZW1wdHlfd2VpZ2h0cygpJTNBJTBBJTIwJTIwJTIwJTIwbW9kZWwlMjAlM0QlMjBHUFQobW9kZWxfY29uZmlnKQ==",highlighted:`<span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> init_empty_weights
<span class="hljs-keyword">from</span> mingpt.model <span class="hljs-keyword">import</span> GPT

model_config = GPT.get_default_config()
model_config.model_type = <span class="hljs-string">&#x27;gpt2-xl&#x27;</span>
model_config.vocab_size = <span class="hljs-number">50257</span>
model_config.block_size = <span class="hljs-number">1024</span>

<span class="hljs-keyword">with</span> init_empty_weights():
    model = GPT(model_config)`,wrap:!1}}),re=new $({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBsb2FkX2NoZWNrcG9pbnRfYW5kX2Rpc3BhdGNoJTBBJTBBbW9kZWwlMjAlM0QlMjBsb2FkX2NoZWNrcG9pbnRfYW5kX2Rpc3BhdGNoKCUwQSUyMCUyMCUyMCUyMG1vZGVsJTJDJTIwY2hlY2twb2ludCUzRHdlaWdodHNfbG9jYXRpb24lMkMlMjBkZXZpY2VfbWFwJTNEJTIyYXV0byUyMiUyQyUyMG5vX3NwbGl0X21vZHVsZV9jbGFzc2VzJTNEJTVCJ0Jsb2NrJyU1RCUwQSk=",highlighted:`<span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> load_checkpoint_and_dispatch

model = load_checkpoint_and_dispatch(
    model, checkpoint=weights_location, device_map=<span class="hljs-string">&quot;auto&quot;</span>, no_split_module_classes=[<span class="hljs-string">&#x27;Block&#x27;</span>]
)`,wrap:!1}}),ce=new _({props:{title:"no_split_module_classes",local:"nosplitmoduleclasses",headingTag:"h4"}}),fe=new _({props:{title:"The device_map",local:"the-devicemap",headingTag:"h4"}}),ye=new $({props:{code:"bW9kZWwuaGZfZGV2aWNlX21hcA==",highlighted:"model.hf_device_map",wrap:!1}}),Me=new $({props:{code:"JTdCJ3RyYW5zZm9ybWVyLnd0ZSclM0ElMjAwJTJDJTBBJTIwJ3RyYW5zZm9ybWVyLndwZSclM0ElMjAwJTJDJTBBJTIwJ3RyYW5zZm9ybWVyLmRyb3AnJTNBJTIwMCUyQyUwQSUyMCd0cmFuc2Zvcm1lci5oLjAnJTNBJTIwMCUyQyUwQSUyMC4uLiUwQSUyMCd0cmFuc2Zvcm1lci5oLjIxJyUzQSUyMDAlMkMlMjAlMEElMjAndHJhbnNmb3JtZXIuaC4yMiclM0ElMjAxJTJDJTIwJTBBJTIwJ3RyYW5zZm9ybWVyLmguMjMnJTNBJTIwMSUyQyUyMCUwQSUyMCd0cmFuc2Zvcm1lci5oLjI0JyUzQSUyMDElMkMlMEElMjAuLi4lMEElMjAndHJhbnNmb3JtZXIuaC40NyclM0ElMjAxJTJDJTIwJTBBJTIwJ3RyYW5zZm9ybWVyLmxuX2YnJTNBJTIwMSUyQyUyMCUwQSUyMCdsbV9oZWFkJyUzQSUyMDElN0Q=",highlighted:`{<span class="hljs-string">&#x27;transformer.wte&#x27;</span>: <span class="hljs-number">0</span>,
 <span class="hljs-string">&#x27;transformer.wpe&#x27;</span>: <span class="hljs-number">0</span>,
 <span class="hljs-string">&#x27;transformer.drop&#x27;</span>: <span class="hljs-number">0</span>,
 <span class="hljs-string">&#x27;transformer.h.0&#x27;</span>: <span class="hljs-number">0</span>,
 ...
 <span class="hljs-string">&#x27;transformer.h.21&#x27;</span>: <span class="hljs-number">0</span>, 
 <span class="hljs-string">&#x27;transformer.h.22&#x27;</span>: <span class="hljs-number">1</span>, 
 <span class="hljs-string">&#x27;transformer.h.23&#x27;</span>: <span class="hljs-number">1</span>, 
 <span class="hljs-string">&#x27;transformer.h.24&#x27;</span>: <span class="hljs-number">1</span>,
 ...
 <span class="hljs-string">&#x27;transformer.h.47&#x27;</span>: <span class="hljs-number">1</span>, 
 <span class="hljs-string">&#x27;transformer.ln_f&#x27;</span>: <span class="hljs-number">1</span>, 
 <span class="hljs-string">&#x27;lm_head&#x27;</span>: <span class="hljs-number">1</span>}`,wrap:!1}}),$e=new $({props:{code:"ZGV2aWNlX21hcCUyMCUzRCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMnRyYW5zZm9ybWVyLnd0ZSUyMiUzQSUyMCUyMmNwdSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMnRyYW5zZm9ybWVyLndwZSUyMiUzQSUyMDAlMkMlMEElMjAlMjAlMjAlMjAlMjJ0cmFuc2Zvcm1lci5kcm9wJTIyJTNBJTIwJTIyY3B1JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIydHJhbnNmb3JtZXIuaC4wJTIyJTNBJTIwJTIyZGlzayUyMiUwQSU3RCUwQSUwQW1vZGVsJTIwJTNEJTIwbG9hZF9jaGVja3BvaW50X2FuZF9kaXNwYXRjaCglMEElMjAlMjAlMjAlMjBtb2RlbCUyQyUyMGNoZWNrcG9pbnQlM0R3ZWlnaHRzX2xvY2F0aW9uJTJDJTIwZGV2aWNlX21hcCUzRGRldmljZV9tYXAlMEEpJTBB",highlighted:`device_map = {
    <span class="hljs-string">&quot;transformer.wte&quot;</span>: <span class="hljs-string">&quot;cpu&quot;</span>,
    <span class="hljs-string">&quot;transformer.wpe&quot;</span>: <span class="hljs-number">0</span>,
    <span class="hljs-string">&quot;transformer.drop&quot;</span>: <span class="hljs-string">&quot;cpu&quot;</span>,
    <span class="hljs-string">&quot;transformer.h.0&quot;</span>: <span class="hljs-string">&quot;disk&quot;</span>
}

model = load_checkpoint_and_dispatch(
    model, checkpoint=weights_location, device_map=device_map
)
`,wrap:!1}}),be=new _({props:{title:"Run the model",local:"run-the-model",headingTag:"h3"}}),_e=new $({props:{code:"ZnJvbSUyMG1pbmdwdC5icGUlMjBpbXBvcnQlMjBCUEVUb2tlbml6ZXIlMEF0b2tlbml6ZXIlMjAlM0QlMjBCUEVUb2tlbml6ZXIoKSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglMjJIZWxsbyUyQyUyMG15JTIwbmFtZSUyMGlzJTIyKS50bygwKSUwQSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSh4MSUyQyUyMG1heF9uZXdfdG9rZW5zJTNEMTAlMkMlMjBkb19zYW1wbGUlM0RGYWxzZSklNUIwJTVEJTBBdG9rZW5pemVyLmRlY29kZShvdXRwdXRzLmNwdSgpLnNxdWVlemUoKSk=",highlighted:`<span class="hljs-keyword">from</span> mingpt.bpe <span class="hljs-keyword">import</span> BPETokenizer
tokenizer = BPETokenizer()
inputs = tokenizer(<span class="hljs-string">&quot;Hello, my name is&quot;</span>).to(<span class="hljs-number">0</span>)

outputs = model.generate(x1, max_new_tokens=<span class="hljs-number">10</span>, do_sample=<span class="hljs-literal">False</span>)[<span class="hljs-number">0</span>]
tokenizer.decode(outputs.cpu().squeeze())`,wrap:!1}}),T=new tt({props:{warning:!0,$$slots:{default:[Es]},$$scope:{ctx:b}}}),ke=new _({props:{title:"Designing a device map",local:"designing-a-device-map",headingTag:"h3"}}),J=new tt({props:{$$slots:{default:[Hs]},$$scope:{ctx:b}}}),C=new tt({props:{$$slots:{default:[Ls]},$$scope:{ctx:b}}}),Ie=new $({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBpbmZlcl9hdXRvX2RldmljZV9tYXAlMEElMEFkZXZpY2VfbWFwJTIwJTNEJTIwaW5mZXJfYXV0b19kZXZpY2VfbWFwKG15X21vZGVsJTJDJTIwbWF4X21lbW9yeSUzRCU3QjAlM0ElMjAlMjIxMEdpQiUyMiUyQyUyMDElM0ElMjAlMjIxMEdpQiUyMiUyQyUyMCUyMmNwdSUyMiUzQSUyMCUyMjMwR2lCJTIyJTdEKQ==",highlighted:`<span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> infer_auto_device_map

device_map = infer_auto_device_map(my_model, max_memory={<span class="hljs-number">0</span>: <span class="hljs-string">&quot;10GiB&quot;</span>, <span class="hljs-number">1</span>: <span class="hljs-string">&quot;10GiB&quot;</span>, <span class="hljs-string">&quot;cpu&quot;</span>: <span class="hljs-string">&quot;30GiB&quot;</span>})`,wrap:!1}}),G=new tt({props:{warning:!0,$$slots:{default:[Ns]},$$scope:{ctx:b}}}),Be=new $({props:{code:"bWF4X21lbW9yeSUyMCUzRCUyMCU3QjAlM0ElMjAlMjIzMEdJQiUyMiUyQyUyMDElM0ElMjAlMjI0NkdJQiUyMiUyQyUyMDIlM0ElMjAlMjI0NkdJQiUyMiUyQyUyMDMlM0ElMjAlMjI0NkdJQiUyMiUyQyUyMDQlM0ElMjAlMjI0NkdJQiUyMiUyQyUyMDUlM0ElMjAlMjI0NkdJQiUyMiUyQyUyMDYlM0ElMjAlMjI0NkdJQiUyMiUyQyUyMDclM0ElMjAlMjI0NkdJQiUyMiU3RA==",highlighted:'max_memory = {<span class="hljs-number">0</span>: <span class="hljs-string">&quot;30GIB&quot;</span>, <span class="hljs-number">1</span>: <span class="hljs-string">&quot;46GIB&quot;</span>, <span class="hljs-number">2</span>: <span class="hljs-string">&quot;46GIB&quot;</span>, <span class="hljs-number">3</span>: <span class="hljs-string">&quot;46GIB&quot;</span>, <span class="hljs-number">4</span>: <span class="hljs-string">&quot;46GIB&quot;</span>, <span class="hljs-number">5</span>: <span class="hljs-string">&quot;46GIB&quot;</span>, <span class="hljs-number">6</span>: <span class="hljs-string">&quot;46GIB&quot;</span>, <span class="hljs-number">7</span>: <span class="hljs-string">&quot;46GIB&quot;</span>}',wrap:!1}}),Re=new $({props:{code:"ZGV2aWNlX21hcCUyMCUzRCUyMCU3QiUyMmJsb2NrMSUyMiUzQSUyMDAlMkMlMjAlMjJibG9jazIlMjIlM0ElMjAxJTdE",highlighted:'device_map = {<span class="hljs-string">&quot;block1&quot;</span>: <span class="hljs-number">0</span>, <span class="hljs-string">&quot;block2&quot;</span>: <span class="hljs-number">1</span>}',wrap:!1}}),Qe=new $({props:{code:"ZGV2aWNlX21hcCUyMCUzRCUyMCU3QiUyMmJsb2NrMSUyMiUzQSUyMDAlMkMlMjAlMjJibG9jazIubGluZWFyMSUyMiUzQSUyMDAlMkMlMjAlMjJibG9jazIubGluZWFyMiUyMiUzQSUyMDElMkMlMjAlMjJibG9jazIubGluZWFyMyUyMiUzQSUyMDElN0Q=",highlighted:'device_map = {<span class="hljs-string">&quot;block1&quot;</span>: <span class="hljs-number">0</span>, <span class="hljs-string">&quot;block2.linear1&quot;</span>: <span class="hljs-number">0</span>, <span class="hljs-string">&quot;block2.linear2&quot;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&quot;block2.linear3&quot;</span>: <span class="hljs-number">1</span>}',wrap:!1}}),Xe=new $({props:{code:"ZGV2aWNlX21hcCUyMCUzRCUyMCU3QiUyMmJsb2NrMSUyMiUzQSUyMDAlMkMlMjAlMjJibG9jazIubGluZWFyMSUyMiUzQSUyMDElMkMlMjAlMjJibG9jazIubGluZWFyMiUyMiUzQSUyMDElN0Q=",highlighted:'device_map = {<span class="hljs-string">&quot;block1&quot;</span>: <span class="hljs-number">0</span>, <span class="hljs-string">&quot;block2.linear1&quot;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&quot;block2.linear2&quot;</span>: <span class="hljs-number">1</span>}',wrap:!1}}),x=new tt({props:{$$slots:{default:[Ys]},$$scope:{ctx:b}}}),Ee=new _({props:{title:"CPU offload only",local:"cpu-offload-only",headingTag:"h2"}}),Le=new $({props:{code:"Y3B1X29mZmxvYWQobW9kZWwlMkMlMjBleGVjdXRpb25fZGV2aWNlKQ==",highlighted:"cpu_offload(model, execution_device)",wrap:!1}}),Ye=new $({props:{code:"bW9kZWxfMSUyQyUyMGhvb2tfMSUyMCUzRCUyMGNwdV9vZmZsb2FkX3dpdGhfaG9vayhtb2RlbF8xJTJDJTIwZXhlY3V0aW9uX2RldmljZSklMEFtb2RlbF8yJTJDJTIwaG9va18yJTIwJTNEJTIwY3B1X29mZmxvYWRfd2l0aF9ob29rKG1vZGVsXzIlMkMlMjBleGVjdXRpb25fZGV2aWNlJTJDJTIwcHJldl9tb2R1bGVfaG9vayUzRGhvb2tfMSklMEFtb2RlbF8zJTJDJTIwaG9va18zJTIwJTNEJTIwY3B1X29mZmxvYWRfd2l0aF9ob29rKG1vZGVsXzMlMkMlMjBleGVjdXRpb25fZGV2aWNlJTJDJTIwcHJldl9tb2R1bGVfaG9vayUzRGhvb2tfMiklMEElMEFoaWRfMSUyMCUzRCUyMG1vZGVsXzEoaW5wdXQpJTBBZm9yJTIwaSUyMGluJTIwcmFuZ2UoNTApJTNBJTBBJTIwJTIwJTIwJTIwJTIzJTIwbW9kZWwxJTIwaXMlMjBvZmZsb2FkZWQlMjBvbiUyMHRoZSUyMENQVSUyMGF0JTIwdGhlJTIwZmlyc3QlMjBpdGVyYXRpb24lMkMlMjBtb2RlbCUyMDIlMjBzdGF5cyUyMG9uJTIwdGhlJTIwR1BVJTIwZm9yJTIwdGhpcyUyMHdob2xlJTIwbG9vcC4lMEElMjAlMjAlMjAlMjBoaWRfMiUyMCUzRCUyMG1vZGVsXzIoaGlkXzEpJTBBJTIzJTIwbW9kZWwyJTIwaXMlMjBvZmZsb2FkZWQlMjB0byUyMHRoZSUyMENQVSUyMGp1c3QlMjBiZWZvcmUlMjB0aGlzJTIwZm9yd2FyZC4lMEFoaWRfMyUyMCUzRCUyMG1vZGVsXzMoaGlkXzMpJTBBJTBBJTIzJTIwRm9yJTIwbW9kZWwzJTJDJTIweW91JTIwbmVlZCUyMHRvJTIwbWFudWFsbHklMjBjYWxsJTIwdGhlJTIwaG9vayUyMG9mZmxvYWQlMjBtZXRob2QuJTBBaG9va18zLm9mZmxvYWQoKQ==",highlighted:`model_1, hook_1 = cpu_offload_with_hook(model_1, execution_device)
model_2, hook_2 = cpu_offload_with_hook(model_2, execution_device, prev_module_hook=hook_1)
model_3, hook_3 = cpu_offload_with_hook(model_3, execution_device, prev_module_hook=hook_2)

hid_1 = model_1(<span class="hljs-built_in">input</span>)
<span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">50</span>):
    <span class="hljs-comment"># model1 is offloaded on the CPU at the first iteration, model 2 stays on the GPU for this whole loop.</span>
    hid_2 = model_2(hid_1)
<span class="hljs-comment"># model2 is offloaded to the CPU just before this forward.</span>
hid_3 = model_3(hid_3)

<span class="hljs-comment"># For model3, you need to manually call the hook offload method.</span>
hook_3.offload()`,wrap:!1}}),Se=new _({props:{title:"Disk offload only",local:"disk-offload-only",headingTag:"h2"}}),Fe=new $({props:{code:"ZGlza19vZmZsb2FkKG1vZGVsJTJDJTIwb2ZmbG9hZF9kaXIlMkMlMjBleGVjdXRpb25fZGV2aWNlKQ==",highlighted:"disk_offload(model, offload_dir, execution_device)",wrap:!1}}),De=new _({props:{title:"Limits and further development",local:"limits-and-further-development",headingTag:"h2"}}),et=new Qs({props:{source:"https://github.com/huggingface/accelerate/blob/main/docs/source/concept_guides/big_model_inference.md"}}),{c(){i=o("meta"),M=a(),d=o("p"),w=a(),m(j.$$.fragment),g=a(),v=o("p"),v.textContent=ql,at=a(),m(Z.$$.fragment),nt=a(),I=o("p"),I.textContent=Pl,it=a(),W=o("ol"),W.innerHTML=Rl,ot=a(),B=o("p"),B.textContent=zl,pt=a(),m(U.$$.fragment),rt=a(),m(q.$$.fragment),dt=a(),m(P.$$.fragment),mt=a(),m(R.$$.fragment),ct=a(),m(z.$$.fragment),ht=a(),Q=o("p"),Q.innerHTML=Ql,ft=a(),m(A.$$.fragment),ut=a(),X=o("p"),X.textContent=Al,yt=a(),m(E.$$.fragment),Mt=a(),H=o("p"),H.textContent=Xl,wt=a(),m(k.$$.fragment),$t=a(),m(L.$$.fragment),bt=a(),N=o("p"),N.textContent=El,gt=a(),Y=o("p"),Y.innerHTML=Hl,_t=a(),m(S.$$.fragment),vt=a(),V=o("p"),V.textContent=Ll,jt=a(),m(F.$$.fragment),Ut=a(),D=o("p"),D.innerHTML=Nl,kt=a(),m(K.$$.fragment),Tt=a(),O=o("p"),O.innerHTML=Yl,Jt=a(),ee=o("p"),ee.innerHTML=Sl,Ct=a(),te=o("p"),te.innerHTML=Vl,Gt=a(),le=o("p"),le.textContent=Fl,xt=a(),m(se.$$.fragment),Zt=a(),m(ae.$$.fragment),It=a(),ne=o("p"),ne.textContent=Dl,Wt=a(),m(ie.$$.fragment),Bt=a(),m(oe.$$.fragment),qt=a(),pe=o("p"),pe.textContent=Kl,Pt=a(),m(re.$$.fragment),Rt=a(),de=o("p"),de.innerHTML=Ol,zt=a(),me=o("ul"),me.innerHTML=es,Qt=a(),m(ce.$$.fragment),At=a(),he=o("p"),he.innerHTML=ts,Xt=a(),m(fe.$$.fragment),Et=a(),ue=o("p"),ue.innerHTML=ls,Ht=a(),m(ye.$$.fragment),Lt=a(),m(Me.$$.fragment),Nt=a(),we=o("p"),we.innerHTML=ss,Yt=a(),m($e.$$.fragment),St=a(),m(be.$$.fragment),Vt=a(),ge=o("p"),ge.textContent=as,Ft=a(),m(_e.$$.fragment),Dt=a(),ve=o("p"),ve.textContent=ns,Kt=a(),je=o("ul"),je.innerHTML=is,Ot=a(),Ue=o("p"),Ue.textContent=os,el=a(),m(T.$$.fragment),tl=a(),m(ke.$$.fragment),ll=a(),Te=o("p"),Te.innerHTML=ps,sl=a(),m(J.$$.fragment),al=a(),Je=o("p"),Je.textContent=rs,nl=a(),Ce=o("p"),Ce.textContent=ds,il=a(),Ge=o("ul"),Ge.innerHTML=ms,ol=a(),m(C.$$.fragment),pl=a(),xe=o("p"),xe.innerHTML=cs,rl=a(),Ze=o("p"),Ze.textContent=hs,dl=a(),m(Ie.$$.fragment),ml=a(),m(G.$$.fragment),cl=a(),We=o("p"),We.innerHTML=fs,hl=a(),m(Be.$$.fragment),fl=a(),qe=o("p"),qe.textContent=us,ul=a(),Pe=o("p"),Pe.innerHTML=ys,yl=a(),m(Re.$$.fragment),Ml=a(),ze=o("p"),ze.textContent=Ms,wl=a(),m(Qe.$$.fragment),$l=a(),Ae=o("p"),Ae.textContent=ws,bl=a(),m(Xe.$$.fragment),gl=a(),m(x.$$.fragment),_l=a(),m(Ee.$$.fragment),vl=a(),He=o("p"),He.innerHTML=$s,jl=a(),m(Le.$$.fragment),Ul=a(),Ne=o("p"),Ne.innerHTML=bs,kl=a(),m(Ye.$$.fragment),Tl=a(),m(Se.$$.fragment),Jl=a(),Ve=o("p"),Ve.innerHTML=gs,Cl=a(),m(Fe.$$.fragment),Gl=a(),m(De.$$.fragment),xl=a(),Ke=o("p"),Ke.textContent=_s,Zl=a(),Oe=o("ul"),Oe.innerHTML=vs,Il=a(),m(et.$$.fragment),Wl=a(),st=o("p"),this.h()},l(e){const t=Ps("svelte-u9bgzb",document.head);i=p(t,"META",{name:!0,content:!0}),t.forEach(l),M=n(e),d=p(e,"P",{}),xs(d).forEach(l),w=n(e),c(j.$$.fragment,e),g=n(e),v=p(e,"P",{"data-svelte-h":!0}),r(v)!=="svelte-1yyj096"&&(v.textContent=ql),at=n(e),c(Z.$$.fragment,e),nt=n(e),I=p(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-jnckpv"&&(I.textContent=Pl),it=n(e),W=p(e,"OL",{"data-svelte-h":!0}),r(W)!=="svelte-11v868"&&(W.innerHTML=Rl),ot=n(e),B=p(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-1mmkmja"&&(B.textContent=zl),pt=n(e),c(U.$$.fragment,e),rt=n(e),c(q.$$.fragment,e),dt=n(e),c(P.$$.fragment,e),mt=n(e),c(R.$$.fragment,e),ct=n(e),c(z.$$.fragment,e),ht=n(e),Q=p(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-jbw7jm"&&(Q.innerHTML=Ql),ft=n(e),c(A.$$.fragment,e),ut=n(e),X=p(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-4vay6o"&&(X.textContent=Al),yt=n(e),c(E.$$.fragment,e),Mt=n(e),H=p(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-1mwzmvc"&&(H.textContent=Xl),wt=n(e),c(k.$$.fragment,e),$t=n(e),c(L.$$.fragment,e),bt=n(e),N=p(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-13afm5q"&&(N.textContent=El),gt=n(e),Y=p(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-11jrh1c"&&(Y.innerHTML=Hl),_t=n(e),c(S.$$.fragment,e),vt=n(e),V=p(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-1resniz"&&(V.textContent=Ll),jt=n(e),c(F.$$.fragment,e),Ut=n(e),D=p(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-1wl1rhb"&&(D.innerHTML=Nl),kt=n(e),c(K.$$.fragment,e),Tt=n(e),O=p(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-1ugp0tw"&&(O.innerHTML=Yl),Jt=n(e),ee=p(e,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-gg1omy"&&(ee.innerHTML=Sl),Ct=n(e),te=p(e,"P",{"data-svelte-h":!0}),r(te)!=="svelte-de38z1"&&(te.innerHTML=Vl),Gt=n(e),le=p(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-q7q9oj"&&(le.textContent=Fl),xt=n(e),c(se.$$.fragment,e),Zt=n(e),c(ae.$$.fragment,e),It=n(e),ne=p(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-9hv0ru"&&(ne.textContent=Dl),Wt=n(e),c(ie.$$.fragment,e),Bt=n(e),c(oe.$$.fragment,e),qt=n(e),pe=p(e,"P",{"data-svelte-h":!0}),r(pe)!=="svelte-l7qwnt"&&(pe.textContent=Kl),Pt=n(e),c(re.$$.fragment,e),Rt=n(e),de=p(e,"P",{"data-svelte-h":!0}),r(de)!=="svelte-o7kc16"&&(de.innerHTML=Ol),zt=n(e),me=p(e,"UL",{"data-svelte-h":!0}),r(me)!=="svelte-11opk3r"&&(me.innerHTML=es),Qt=n(e),c(ce.$$.fragment,e),At=n(e),he=p(e,"P",{"data-svelte-h":!0}),r(he)!=="svelte-1xo69nf"&&(he.innerHTML=ts),Xt=n(e),c(fe.$$.fragment,e),Et=n(e),ue=p(e,"P",{"data-svelte-h":!0}),r(ue)!=="svelte-uy2xoa"&&(ue.innerHTML=ls),Ht=n(e),c(ye.$$.fragment,e),Lt=n(e),c(Me.$$.fragment,e),Nt=n(e),we=p(e,"P",{"data-svelte-h":!0}),r(we)!=="svelte-11gz870"&&(we.innerHTML=ss),Yt=n(e),c($e.$$.fragment,e),St=n(e),c(be.$$.fragment,e),Vt=n(e),ge=p(e,"P",{"data-svelte-h":!0}),r(ge)!=="svelte-1d1z3sn"&&(ge.textContent=as),Ft=n(e),c(_e.$$.fragment,e),Dt=n(e),ve=p(e,"P",{"data-svelte-h":!0}),r(ve)!=="svelte-lh30ey"&&(ve.textContent=ns),Kt=n(e),je=p(e,"UL",{"data-svelte-h":!0}),r(je)!=="svelte-1macllt"&&(je.innerHTML=is),Ot=n(e),Ue=p(e,"P",{"data-svelte-h":!0}),r(Ue)!=="svelte-2f3qjg"&&(Ue.textContent=os),el=n(e),c(T.$$.fragment,e),tl=n(e),c(ke.$$.fragment,e),ll=n(e),Te=p(e,"P",{"data-svelte-h":!0}),r(Te)!=="svelte-q28p5z"&&(Te.innerHTML=ps),sl=n(e),c(J.$$.fragment,e),al=n(e),Je=p(e,"P",{"data-svelte-h":!0}),r(Je)!=="svelte-185xrjm"&&(Je.textContent=rs),nl=n(e),Ce=p(e,"P",{"data-svelte-h":!0}),r(Ce)!=="svelte-isobvw"&&(Ce.textContent=ds),il=n(e),Ge=p(e,"UL",{"data-svelte-h":!0}),r(Ge)!=="svelte-gk7g7m"&&(Ge.innerHTML=ms),ol=n(e),c(C.$$.fragment,e),pl=n(e),xe=p(e,"P",{"data-svelte-h":!0}),r(xe)!=="svelte-1l4xlqe"&&(xe.innerHTML=cs),rl=n(e),Ze=p(e,"P",{"data-svelte-h":!0}),r(Ze)!=="svelte-1btz7o0"&&(Ze.textContent=hs),dl=n(e),c(Ie.$$.fragment,e),ml=n(e),c(G.$$.fragment,e),cl=n(e),We=p(e,"P",{"data-svelte-h":!0}),r(We)!=="svelte-1wm631f"&&(We.innerHTML=fs),hl=n(e),c(Be.$$.fragment,e),fl=n(e),qe=p(e,"P",{"data-svelte-h":!0}),r(qe)!=="svelte-1epndkt"&&(qe.textContent=us),ul=n(e),Pe=p(e,"P",{"data-svelte-h":!0}),r(Pe)!=="svelte-6j84en"&&(Pe.innerHTML=ys),yl=n(e),c(Re.$$.fragment,e),Ml=n(e),ze=p(e,"P",{"data-svelte-h":!0}),r(ze)!=="svelte-1niaejq"&&(ze.textContent=Ms),wl=n(e),c(Qe.$$.fragment,e),$l=n(e),Ae=p(e,"P",{"data-svelte-h":!0}),r(Ae)!=="svelte-u50du7"&&(Ae.textContent=ws),bl=n(e),c(Xe.$$.fragment,e),gl=n(e),c(x.$$.fragment,e),_l=n(e),c(Ee.$$.fragment,e),vl=n(e),He=p(e,"P",{"data-svelte-h":!0}),r(He)!=="svelte-1nxtm4y"&&(He.innerHTML=$s),jl=n(e),c(Le.$$.fragment,e),Ul=n(e),Ne=p(e,"P",{"data-svelte-h":!0}),r(Ne)!=="svelte-1wsv6th"&&(Ne.innerHTML=bs),kl=n(e),c(Ye.$$.fragment,e),Tl=n(e),c(Se.$$.fragment,e),Jl=n(e),Ve=p(e,"P",{"data-svelte-h":!0}),r(Ve)!=="svelte-dpg4p6"&&(Ve.innerHTML=gs),Cl=n(e),c(Fe.$$.fragment,e),Gl=n(e),c(De.$$.fragment,e),xl=n(e),Ke=p(e,"P",{"data-svelte-h":!0}),r(Ke)!=="svelte-1rkjfcc"&&(Ke.textContent=_s),Zl=n(e),Oe=p(e,"UL",{"data-svelte-h":!0}),r(Oe)!=="svelte-vvzype"&&(Oe.innerHTML=vs),Il=n(e),c(et.$$.fragment,e),Wl=n(e),st=p(e,"P",{}),xs(st).forEach(l),this.h()},h(){Zs(i,"name","hf:doc:metadata"),Zs(i,"content",Vs)},m(e,t){Rs(document.head,i),s(e,M,t),s(e,d,t),s(e,w,t),h(j,e,t),s(e,g,t),s(e,v,t),s(e,at,t),h(Z,e,t),s(e,nt,t),s(e,I,t),s(e,it,t),s(e,W,t),s(e,ot,t),s(e,B,t),s(e,pt,t),h(U,e,t),s(e,rt,t),h(q,e,t),s(e,dt,t),h(P,e,t),s(e,mt,t),h(R,e,t),s(e,ct,t),h(z,e,t),s(e,ht,t),s(e,Q,t),s(e,ft,t),h(A,e,t),s(e,ut,t),s(e,X,t),s(e,yt,t),h(E,e,t),s(e,Mt,t),s(e,H,t),s(e,wt,t),h(k,e,t),s(e,$t,t),h(L,e,t),s(e,bt,t),s(e,N,t),s(e,gt,t),s(e,Y,t),s(e,_t,t),h(S,e,t),s(e,vt,t),s(e,V,t),s(e,jt,t),h(F,e,t),s(e,Ut,t),s(e,D,t),s(e,kt,t),h(K,e,t),s(e,Tt,t),s(e,O,t),s(e,Jt,t),s(e,ee,t),s(e,Ct,t),s(e,te,t),s(e,Gt,t),s(e,le,t),s(e,xt,t),h(se,e,t),s(e,Zt,t),h(ae,e,t),s(e,It,t),s(e,ne,t),s(e,Wt,t),h(ie,e,t),s(e,Bt,t),h(oe,e,t),s(e,qt,t),s(e,pe,t),s(e,Pt,t),h(re,e,t),s(e,Rt,t),s(e,de,t),s(e,zt,t),s(e,me,t),s(e,Qt,t),h(ce,e,t),s(e,At,t),s(e,he,t),s(e,Xt,t),h(fe,e,t),s(e,Et,t),s(e,ue,t),s(e,Ht,t),h(ye,e,t),s(e,Lt,t),h(Me,e,t),s(e,Nt,t),s(e,we,t),s(e,Yt,t),h($e,e,t),s(e,St,t),h(be,e,t),s(e,Vt,t),s(e,ge,t),s(e,Ft,t),h(_e,e,t),s(e,Dt,t),s(e,ve,t),s(e,Kt,t),s(e,je,t),s(e,Ot,t),s(e,Ue,t),s(e,el,t),h(T,e,t),s(e,tl,t),h(ke,e,t),s(e,ll,t),s(e,Te,t),s(e,sl,t),h(J,e,t),s(e,al,t),s(e,Je,t),s(e,nl,t),s(e,Ce,t),s(e,il,t),s(e,Ge,t),s(e,ol,t),h(C,e,t),s(e,pl,t),s(e,xe,t),s(e,rl,t),s(e,Ze,t),s(e,dl,t),h(Ie,e,t),s(e,ml,t),h(G,e,t),s(e,cl,t),s(e,We,t),s(e,hl,t),h(Be,e,t),s(e,fl,t),s(e,qe,t),s(e,ul,t),s(e,Pe,t),s(e,yl,t),h(Re,e,t),s(e,Ml,t),s(e,ze,t),s(e,wl,t),h(Qe,e,t),s(e,$l,t),s(e,Ae,t),s(e,bl,t),h(Xe,e,t),s(e,gl,t),h(x,e,t),s(e,_l,t),h(Ee,e,t),s(e,vl,t),s(e,He,t),s(e,jl,t),h(Le,e,t),s(e,Ul,t),s(e,Ne,t),s(e,kl,t),h(Ye,e,t),s(e,Tl,t),h(Se,e,t),s(e,Jl,t),s(e,Ve,t),s(e,Cl,t),h(Fe,e,t),s(e,Gl,t),h(De,e,t),s(e,xl,t),s(e,Ke,t),s(e,Zl,t),s(e,Oe,t),s(e,Il,t),h(et,e,t),s(e,Wl,t),s(e,st,t),Bl=!0},p(e,[t]){const js={};t&2&&(js.$$scope={dirty:t,ctx:e}),U.$set(js);const Us={};t&2&&(Us.$$scope={dirty:t,ctx:e}),k.$set(Us);const ks={};t&2&&(ks.$$scope={dirty:t,ctx:e}),T.$set(ks);const Ts={};t&2&&(Ts.$$scope={dirty:t,ctx:e}),J.$set(Ts);const Js={};t&2&&(Js.$$scope={dirty:t,ctx:e}),C.$set(Js);const Cs={};t&2&&(Cs.$$scope={dirty:t,ctx:e}),G.$set(Cs);const Gs={};t&2&&(Gs.$$scope={dirty:t,ctx:e}),x.$set(Gs)},i(e){Bl||(f(j.$$.fragment,e),f(Z.$$.fragment,e),f(U.$$.fragment,e),f(q.$$.fragment,e),f(P.$$.fragment,e),f(R.$$.fragment,e),f(z.$$.fragment,e),f(A.$$.fragment,e),f(E.$$.fragment,e),f(k.$$.fragment,e),f(L.$$.fragment,e),f(S.$$.fragment,e),f(F.$$.fragment,e),f(K.$$.fragment,e),f(se.$$.fragment,e),f(ae.$$.fragment,e),f(ie.$$.fragment,e),f(oe.$$.fragment,e),f(re.$$.fragment,e),f(ce.$$.fragment,e),f(fe.$$.fragment,e),f(ye.$$.fragment,e),f(Me.$$.fragment,e),f($e.$$.fragment,e),f(be.$$.fragment,e),f(_e.$$.fragment,e),f(T.$$.fragment,e),f(ke.$$.fragment,e),f(J.$$.fragment,e),f(C.$$.fragment,e),f(Ie.$$.fragment,e),f(G.$$.fragment,e),f(Be.$$.fragment,e),f(Re.$$.fragment,e),f(Qe.$$.fragment,e),f(Xe.$$.fragment,e),f(x.$$.fragment,e),f(Ee.$$.fragment,e),f(Le.$$.fragment,e),f(Ye.$$.fragment,e),f(Se.$$.fragment,e),f(Fe.$$.fragment,e),f(De.$$.fragment,e),f(et.$$.fragment,e),Bl=!0)},o(e){u(j.$$.fragment,e),u(Z.$$.fragment,e),u(U.$$.fragment,e),u(q.$$.fragment,e),u(P.$$.fragment,e),u(R.$$.fragment,e),u(z.$$.fragment,e),u(A.$$.fragment,e),u(E.$$.fragment,e),u(k.$$.fragment,e),u(L.$$.fragment,e),u(S.$$.fragment,e),u(F.$$.fragment,e),u(K.$$.fragment,e),u(se.$$.fragment,e),u(ae.$$.fragment,e),u(ie.$$.fragment,e),u(oe.$$.fragment,e),u(re.$$.fragment,e),u(ce.$$.fragment,e),u(fe.$$.fragment,e),u(ye.$$.fragment,e),u(Me.$$.fragment,e),u($e.$$.fragment,e),u(be.$$.fragment,e),u(_e.$$.fragment,e),u(T.$$.fragment,e),u(ke.$$.fragment,e),u(J.$$.fragment,e),u(C.$$.fragment,e),u(Ie.$$.fragment,e),u(G.$$.fragment,e),u(Be.$$.fragment,e),u(Re.$$.fragment,e),u(Qe.$$.fragment,e),u(Xe.$$.fragment,e),u(x.$$.fragment,e),u(Ee.$$.fragment,e),u(Le.$$.fragment,e),u(Ye.$$.fragment,e),u(Se.$$.fragment,e),u(Fe.$$.fragment,e),u(De.$$.fragment,e),u(et.$$.fragment,e),Bl=!1},d(e){e&&(l(M),l(d),l(w),l(g),l(v),l(at),l(nt),l(I),l(it),l(W),l(ot),l(B),l(pt),l(rt),l(dt),l(mt),l(ct),l(ht),l(Q),l(ft),l(ut),l(X),l(yt),l(Mt),l(H),l(wt),l($t),l(bt),l(N),l(gt),l(Y),l(_t),l(vt),l(V),l(jt),l(Ut),l(D),l(kt),l(Tt),l(O),l(Jt),l(ee),l(Ct),l(te),l(Gt),l(le),l(xt),l(Zt),l(It),l(ne),l(Wt),l(Bt),l(qt),l(pe),l(Pt),l(Rt),l(de),l(zt),l(me),l(Qt),l(At),l(he),l(Xt),l(Et),l(ue),l(Ht),l(Lt),l(Nt),l(we),l(Yt),l(St),l(Vt),l(ge),l(Ft),l(Dt),l(ve),l(Kt),l(je),l(Ot),l(Ue),l(el),l(tl),l(ll),l(Te),l(sl),l(al),l(Je),l(nl),l(Ce),l(il),l(Ge),l(ol),l(pl),l(xe),l(rl),l(Ze),l(dl),l(ml),l(cl),l(We),l(hl),l(fl),l(qe),l(ul),l(Pe),l(yl),l(Ml),l(ze),l(wl),l($l),l(Ae),l(bl),l(gl),l(_l),l(vl),l(He),l(jl),l(Ul),l(Ne),l(kl),l(Tl),l(Jl),l(Ve),l(Cl),l(Gl),l(xl),l(Ke),l(Zl),l(Oe),l(Il),l(Wl),l(st)),l(i),y(j,e),y(Z,e),y(U,e),y(q,e),y(P,e),y(R,e),y(z,e),y(A,e),y(E,e),y(k,e),y(L,e),y(S,e),y(F,e),y(K,e),y(se,e),y(ae,e),y(ie,e),y(oe,e),y(re,e),y(ce,e),y(fe,e),y(ye,e),y(Me,e),y($e,e),y(be,e),y(_e,e),y(T,e),y(ke,e),y(J,e),y(C,e),y(Ie,e),y(G,e),y(Be,e),y(Re,e),y(Qe,e),y(Xe,e),y(x,e),y(Ee,e),y(Le,e),y(Ye,e),y(Se,e),y(Fe,e),y(De,e),y(et,e)}}}const Vs='{"title":"Handling big models for inference","local":"handling-big-models-for-inference","sections":[{"title":"How the Process Works: A Quick Overview","local":"how-the-process-works-a-quick-overview","sections":[],"depth":2},{"title":"How the Process Works: Working with Code","local":"how-the-process-works-working-with-code","sections":[{"title":"Instantiating an empty model","local":"instantiating-an-empty-model","sections":[],"depth":3},{"title":"Sharded checkpoints","local":"sharded-checkpoints","sections":[],"depth":3},{"title":"Loading weights","local":"loading-weights","sections":[{"title":"no_split_module_classes","local":"nosplitmoduleclasses","sections":[],"depth":4},{"title":"The device_map","local":"the-devicemap","sections":[],"depth":4}],"depth":3},{"title":"Run the model","local":"run-the-model","sections":[],"depth":3},{"title":"Designing a device map","local":"designing-a-device-map","sections":[],"depth":3}],"depth":2},{"title":"CPU offload only","local":"cpu-offload-only","sections":[],"depth":2},{"title":"Disk offload only","local":"disk-offload-only","sections":[],"depth":2},{"title":"Limits and further development","local":"limits-and-further-development","sections":[],"depth":2}],"depth":1}';function Fs(b){return Ws(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class sa extends Bs{constructor(i){super(),qs(this,i,Fs,Ss,Is,{})}}export{sa as component};
