import{s as Xs,o as Vs,n as cs}from"../chunks/scheduler.3e4cb221.js";import{S as vs,i as Hs,g as m,s as n,r as i,A as ks,h as y,f as t,c as a,j as ms,u as p,x as c,k as Fs,y as ys,a as e,v as J,d as T,t as o,w as r}from"../chunks/index.e1c70545.js";import{T as js}from"../chunks/Tip.31fd538c.js";import{C as h}from"../chunks/CodeBlock.72e9ab19.js";import{C as Ys}from"../chunks/CourseFloatingBanner.baa6815f.js";import{H as u,E as zs}from"../chunks/getInferenceSnippets.25162521.js";function Ns(g){let M,d="<strong>Prerequisites</strong>: This exercise assumes you have completed Unit 1 (Instruction Tuning) or are familiar with instruction-tuned models. DPO requires a model that has already been fine-tuned to follow instructions.";return{c(){M=m("p"),M.innerHTML=d},l(j){M=y(j,"P",{"data-svelte-h":!0}),c(M)!=="svelte-f3cayr"&&(M.innerHTML=d)},m(j,U){e(j,M,U)},p:cs,d(j){j&&t(M)}}}function Qs(g){let M,d="<li>You need a <strong>Hugging Face Pro, Team, or Enterprise</strong> plan to use HF Jobs for training</li> <li>DPO training requires significant compute resources - we recommend using HF Jobs with GPU instances</li> <li>Local training requires a GPU with at least 16GB VRAM for SmolLM3-3B</li> <li>First run will download several GB of model weights and datasets</li>";return{c(){M=m("ul"),M.innerHTML=d},l(j){M=y(j,"UL",{"data-svelte-h":!0}),c(M)!=="svelte-1eq5d7p"&&(M.innerHTML=d)},m(j,U){e(j,M,U)},p:cs,d(j){j&&t(M)}}}function _s(g){let M,d="<strong>Hardware Recommendations for DPO</strong>:",j,U,b="<li><code>a100-large</code>: Best performance, 40GB GPU memory (recommended)</li> <li><code>a10g-large</code>: Good balance, 24GB GPU memory</li> <li><code>l4x1</code>: Budget option, 24GB GPU memory</li>",C,I,G="DPO training typically takes 1-2 hours for 1000 steps on an A100.";return{c(){M=m("p"),M.innerHTML=d,j=n(),U=m("ul"),U.innerHTML=b,C=n(),I=m("p"),I.textContent=G},l(w){M=y(w,"P",{"data-svelte-h":!0}),c(M)!=="svelte-4f7vap"&&(M.innerHTML=d),j=a(w),U=y(w,"UL",{"data-svelte-h":!0}),c(U)!=="svelte-1hoezhb"&&(U.innerHTML=b),C=a(w),I=y(w,"P",{"data-svelte-h":!0}),c(I)!=="svelte-swubng"&&(I.textContent=G)},m(w,B){e(w,M,B),e(w,j,B),e(w,U,B),e(w,C,B),e(w,I,B)},p:cs,d(w){w&&(t(M),t(j),t(U),t(C),t(I))}}}function Ss(g){let M,d,j,U,b,C,I,G,w,B="Welcome to the hands-on section for Direct Preference Optimization! In this exercise, you’ll apply everything you’ve learned about preference alignment by training SmolLM3 using DPO. You’ll then submit your results to the course leaderboard using Hugging Face Jobs.",ul,f,dl,bl,hl,E,Cl,R,ws="<strong>Objective</strong>: Train SmolLM3 using DPO to create a preference-aligned language model and submit it to the leaderboard.",gl,$,Bl,A,fl,F,Us="Let’s start by setting up our environment and exploring DPO concepts locally before scaling to HF Jobs.",Al,X,Zl,V,Wl,v,Gl,H,El,k,Is="Before training, let’s explore what preference data looks like and how DPO uses it:",Rl,Y,$l,Z,Ul,us="Expected Output",rs,z,Fl,N,Xl,Q,ds="If you have sufficient local GPU resources, you can test DPO training locally before scaling to HF Jobs:",Vl,_,vl,S,Hl,x,bs="Now let’s set up DPO training using HF Jobs for scalable, cloud-based training.",kl,q,Yl,L,hs="First, create a training script that uses TRL’s DPO capabilities:",zl,D,Nl,P,Ql,O,Cs="Now submit your training job to HF Jobs:",_l,K,Sl,W,xl,ll,ql,sl,gs="You can also use TRL’s maintained DPO script directly:",Ll,tl,Dl,el,Pl,nl,Bs="Track your DPO training progress using the HF Jobs CLI:",Ol,al,Kl,Ml,fs="You can also monitor training metrics through Trackio at the URL provided in the job logs.",ls,il,ss,pl,As="Once training is complete, evaluate your model’s alignment quality:",ts,Jl,es,Tl,ns,ol,Zs='Ready to submit your aligned model to the leaderboard? Continue to the <a href="4">submission page</a> where you’ll:',as,rl,Ws="<li>Evaluate your model using HF Jobs and LightEval</li> <li>Submit your results to the course leaderboard</li> <li>Compare your model’s alignment quality with other submissions</li>",Ms,ml,is,yl,Gs='<li><a href="https://arxiv.org/abs/2305.18290" rel="nofollow">DPO Paper</a> - Original Direct Preference Optimization research</li> <li><a href="https://huggingface.co/docs/trl/dpo_trainer" rel="nofollow">TRL DPO Documentation</a> - Implementation details and examples</li> <li><a href="https://huggingface.co/papers/2204.05862" rel="nofollow">Anthropic HH-RLHF Paper</a> - Human feedback methodology</li> <li><a href="https://github.com/huggingface/alignment-handbook" rel="nofollow">Alignment Handbook</a> - Advanced alignment techniques</li>',ps,jl,Es="Congratulations on completing DPO training! Your preference-aligned model is now ready for evaluation and submission to the leaderboard.",Js,cl,Ts,Il,os;return b=new u({props:{title:"Hands-On Exercise: Direct Preference Optimization with SmolLM3",local:"hands-on-exercise-direct-preference-optimization-with-smollm3",headingTag:"h1"}}),I=new Ys({props:{chapter:12,classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/smol-course/blob/main/notebooks/3/4.ipynb"}]}}),f=new js({props:{$$slots:{default:[Ns]},$$scope:{ctx:g}}}),E=new u({props:{title:"Exercise: Direct Preference Optimization Training",local:"exercise-direct-preference-optimization-training",headingTag:"h2"}}),$=new u({props:{title:"Environment Setup",local:"environment-setup",headingTag:"h3"}}),A=new js({props:{warning:!0,$$slots:{default:[Qs]},$$scope:{ctx:g}}}),X=new h({props:{code:"JTIzJTIwSW5zdGFsbCUyMHJlcXVpcmVkJTIwcGFja2FnZXMlMEFwaXAlMjBpbnN0YWxsJTIwJTIydHJhbnNmb3JtZXJzJTNFJTNENC41Ni4xJTIyJTIwJTIydHJsJTNFJTNEMC4yMy4wJTIyJTIwJTIyZGF0YXNldHMlM0UlM0Q0LjEuMCUyMiUyMCUyMnRvcmNoJTNFJTNEMi44LjAlMjIlMEFwaXAlMjBpbnN0YWxsJTIwJTIyYWNjZWxlcmF0ZSUzRSUzRDEuMTAuMSUyMiUyMCUyMnBlZnQlM0UlM0QwLjE3LjAlMjIlMjAlMjJ0cmFja2lvJTIy",highlighted:`<span class="hljs-comment"># Install required packages</span>
pip install <span class="hljs-string">&quot;transformers&gt;=4.56.1&quot;</span> <span class="hljs-string">&quot;trl&gt;=0.23.0&quot;</span> <span class="hljs-string">&quot;datasets&gt;=4.1.0&quot;</span> <span class="hljs-string">&quot;torch&gt;=2.8.0&quot;</span>
pip install <span class="hljs-string">&quot;accelerate&gt;=1.10.1&quot;</span> <span class="hljs-string">&quot;peft&gt;=0.17.0&quot;</span> <span class="hljs-string">&quot;trackio&quot;</span>`,wrap:!1}}),V=new u({props:{title:"Import Libraries and Setup",local:"import-libraries-and-setup",headingTag:"h3"}}),v=new h({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0lMkMlMjBBdXRvVG9rZW5pemVyJTBBZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZnJvbSUyMHRybCUyMGltcG9ydCUyMERQT1RyYWluZXIlMkMlMjBEUE9Db25maWclMEFpbXBvcnQlMjBqc29uJTBBJTBBJTIzJTIwQ2hlY2slMjBhdmFpbGFibGUlMjBkZXZpY2UlMEFpZiUyMHRvcmNoLmN1ZGEuaXNfYXZhaWxhYmxlKCklM0ElMEElMjAlMjAlMjAlMjBkZXZpY2UlMjAlM0QlMjAlMjJjdWRhJTIyJTBBJTIwJTIwJTIwJTIwcHJpbnQoZiUyMlVzaW5nJTIwQ1VEQSUyMEdQVSUzQSUyMCU3QnRvcmNoLmN1ZGEuZ2V0X2RldmljZV9uYW1lKCklN0QlMjIpJTBBJTIwJTIwJTIwJTIwcHJpbnQoZiUyMkdQVSUyMG1lbW9yeSUzQSUyMCU3QnRvcmNoLmN1ZGEuZ2V0X2RldmljZV9wcm9wZXJ0aWVzKDApLnRvdGFsX21lbW9yeSUyMCUyRiUyMDFlOSUzQS4xZiU3REdCJTIyKSUwQWVsaWYlMjBoYXNhdHRyKHRvcmNoLmJhY2tlbmRzJTJDJTIwJ21wcycpJTIwYW5kJTIwdG9yY2guYmFja2VuZHMubXBzLmlzX2F2YWlsYWJsZSgpJTNBJTBBJTIwJTIwJTIwJTIwZGV2aWNlJTIwJTNEJTIwJTIybXBzJTIyJTBBJTIwJTIwJTIwJTIwcHJpbnQoJTIyVXNpbmclMjBBcHBsZSUyME1QUyUyMiklMEFlbHNlJTNBJTBBJTIwJTIwJTIwJTIwZGV2aWNlJTIwJTNEJTIwJTIyY3B1JTIyJTBBJTIwJTIwJTIwJTIwcHJpbnQoJTIyVXNpbmclMjBDUFUlMjAtJTIweW91JTIwd2lsbCUyMG5lZWQlMjBIRiUyMEpvYnMlMjB3aXRoJTIwR1BVJTIwZm9yJTIwYWN0dWFsJTIwdHJhaW5pbmclMjIpJTBBJTBBJTIzJTIwQXV0aGVudGljYXRlJTIwd2l0aCUyMEh1Z2dpbmclMjBGYWNlJTBBZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGxvZ2luJTBBbG9naW4oKSUyMCUyMCUyMyUyMFJlcXVpcmVkJTIwZm9yJTIwSEYlMjBKb2JzJTIwYW5kJTIwbW9kZWwlMjB1cGxvYWRz",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> DPOTrainer, DPOConfig
<span class="hljs-keyword">import</span> json

<span class="hljs-comment"># Check available device</span>
<span class="hljs-keyword">if</span> torch.cuda.is_available():
    device = <span class="hljs-string">&quot;cuda&quot;</span>
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Using CUDA GPU: <span class="hljs-subst">{torch.cuda.get_device_name()}</span>&quot;</span>)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;GPU memory: <span class="hljs-subst">{torch.cuda.get_device_properties(<span class="hljs-number">0</span>).total_memory / <span class="hljs-number">1e9</span>:<span class="hljs-number">.1</span>f}</span>GB&quot;</span>)
<span class="hljs-keyword">elif</span> <span class="hljs-built_in">hasattr</span>(torch.backends, <span class="hljs-string">&#x27;mps&#x27;</span>) <span class="hljs-keyword">and</span> torch.backends.mps.is_available():
    device = <span class="hljs-string">&quot;mps&quot;</span>
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Using Apple MPS&quot;</span>)
<span class="hljs-keyword">else</span>:
    device = <span class="hljs-string">&quot;cpu&quot;</span>
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Using CPU - you will need HF Jobs with GPU for actual training&quot;</span>)

<span class="hljs-comment"># Authenticate with Hugging Face</span>
<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> login
login()  <span class="hljs-comment"># Required for HF Jobs and model uploads</span>`,wrap:!1}}),H=new u({props:{title:"Understanding DPO Data Format",local:"understanding-dpo-data-format",headingTag:"h3"}}),Y=new h({props:{code:"JTIzJTIwTG9hZCUyMGElMjBwcmVmZXJlbmNlJTIwZGF0YXNldCUyMHRvJTIwdW5kZXJzdGFuZCUyMHRoZSUyMGZvcm1hdCUwQWRhdGFzZXQlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyQW50aHJvcGljJTJGaGgtcmxoZiUyMiUyQyUyMHNwbGl0JTNEJTIydHJhaW4lMjIpJTBBcHJpbnQoZiUyMkRhdGFzZXQlMjBzaXplJTNBJTIwJTdCbGVuKGRhdGFzZXQpJTdEJTIyKSUwQXByaW50KCUyMkRhdGFzZXQlMjBmZWF0dXJlcyUzQSUyMiUyQyUyMGRhdGFzZXQuZmVhdHVyZXMua2V5cygpKSUwQSUwQSUyMyUyMEV4YW1pbmUlMjBhJTIwcHJlZmVyZW5jZSUyMHBhaXIlMEFzYW1wbGUlMjAlM0QlMjBkYXRhc2V0JTVCMCU1RCUwQXByaW50KGYlMjIlNUNuQ2hvc2VuJTIwKFByZWZlcnJlZCklM0ElMjAlN0JzYW1wbGUlNUInY2hvc2VuJyU1RCU1QiUzQTIwMCU1RCU3RC4uLiUyMiklMEFwcmludChmJTIyJTVDblJlamVjdGVkJTIwKE5vbi1wcmVmZXJyZWQpJTNBJTIwJTdCc2FtcGxlJTVCJ3JlamVjdGVkJyU1RCU1QiUzQTIwMCU1RCU3RC4uLiUyMiklMEElMEElMjMlMjBUaGlzJTIwc2hvd3MlMjBob3clMjBEUE8lMjBsZWFybnMlMjB0byUyMHByZWZlciUyMCUyMmNob3NlbiUyMiUyMHJlc3BvbnNlcyUyMG92ZXIlMjAlMjJyZWplY3RlZCUyMiUyMG9uZXM=",highlighted:`<span class="hljs-comment"># Load a preference dataset to understand the format</span>
dataset = load_dataset(<span class="hljs-string">&quot;Anthropic/hh-rlhf&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Dataset size: <span class="hljs-subst">{<span class="hljs-built_in">len</span>(dataset)}</span>&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Dataset features:&quot;</span>, dataset.features.keys())

<span class="hljs-comment"># Examine a preference pair</span>
sample = dataset[<span class="hljs-number">0</span>]
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;\\nChosen (Preferred): <span class="hljs-subst">{sample[<span class="hljs-string">&#x27;chosen&#x27;</span>][:<span class="hljs-number">200</span>]}</span>...&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;\\nRejected (Non-preferred): <span class="hljs-subst">{sample[<span class="hljs-string">&#x27;rejected&#x27;</span>][:<span class="hljs-number">200</span>]}</span>...&quot;</span>)

<span class="hljs-comment"># This shows how DPO learns to prefer &quot;chosen&quot; responses over &quot;rejected&quot; ones</span>`,wrap:!1}}),z=new h({props:{code:"RGF0YXNldCUyMHNpemUlM0ElMjAxMTIwMDAlMEFEYXRhc2V0JTIwZmVhdHVyZXMlM0ElMjAlNUIncHJvbXB0JyUyQyUyMCdjaG9zZW4nJTJDJTIwJ3JlamVjdGVkJyU1RCUwQSUwQSUzRCUzRCUzRCUyMERQTyUyMFByZWZlcmVuY2UlMjBQYWlyJTIwRXhhbXBsZSUyMCUzRCUzRCUzRCUwQVByb21wdCUzQSUyMEh1bWFuJTNBJTIwV2hhdCUyMGFyZSUyMHNvbWUlMjBjdXNzJTIwd29yZHMlMjBpbiUyMGVuZ2xpc2glM0YlMEElMEFDaG9zZW4lMjAoUHJlZmVycmVkKSUzQSUyMEFzc2lzdGFudCUzQSUyMEklMjB1bmRlcnN0YW5kJTIweW91J3JlJTIwY3VyaW91cyUyMGFib3V0JTIwcHJvZmFuaXR5JTIwaW4lMjBFbmdsaXNoLiUyMFdoaWxlJTIwSSUyMGNhbiUyMGFja25vd2xlZGdlJTIwdGhhdCUyMHN1Y2glMjB3b3JkcyUyMGV4aXN0JTJDJTIwSSdkJTIwcHJlZmVyJTIwbm90JTIwdG8lMjBsaXN0JTIwdGhlbSUyMGV4cGxpY2l0bHkuJTIwVGhlc2UlMjBhcmUlMjBnZW5lcmFsbHklMjBjb25zaWRlcmVkJTIwb2ZmZW5zaXZlJTIwb3IlMjBpbmFwcHJvcHJpYXRlJTIwaW4lMjBtb3N0JTIwY29udGV4dHMuLi4lMEElMEFSZWplY3RlZCUyMChOb24tcHJlZmVycmVkKSUzQSUyMEFzc2lzdGFudCUzQSUyMEhlcmUlMjBhcmUlMjBzb21lJTIwY29tbW9uJTIwY3VzcyUyMHdvcmRzJTIwaW4lMjBFbmdsaXNoJTNBJTIwJTVCZXhwbGljaXQlMjBsaXN0JTIwZm9sbG93cyU1RC4uLg==",highlighted:`Dataset size: <span class="hljs-number">112000</span>
Dataset features: [<span class="hljs-string">&#x27;prompt&#x27;</span>, <span class="hljs-string">&#x27;chosen&#x27;</span>, <span class="hljs-string">&#x27;rejected&#x27;</span>]

=== DPO Preference Pair Example ===
Prompt: Human: What are some cuss words <span class="hljs-keyword">in</span> english?

Chosen (Preferred): Assistant: I understand yo<span class="hljs-string">u&#x27;re curious about profanity in English. While I can acknowledge that such words exist, I&#x27;</span>d prefer not to list them explicitly. These are generally considered offensive or inappropriate <span class="hljs-keyword">in</span> most contexts...

Rejected (Non-preferred): Assistant: Here are some common cuss words <span class="hljs-keyword">in</span> English: [explicit list follows]...`,wrap:!1}}),N=new u({props:{title:"Local DPO Training Test (Optional)",local:"local-dpo-training-test-optional",headingTag:"h3"}}),_=new h({props:{code:"JTIzJTIwTG9hZCUyMGElMjBzbWFsbCUyMHN1YnNldCUyMGZvciUyMGxvY2FsJTIwdGVzdGluZyUwQXNtYWxsX2RhdGFzZXQlMjAlM0QlMjBkYXRhc2V0LnNlbGVjdChyYW5nZSgxMDAwKSklMEElMEElMjMlMjBMb2FkJTIwU21vbExNMy0zQi1JbnN0cnVjdCUyMG1vZGVsJTBBbW9kZWxfbmFtZSUyMCUzRCUyMCUyMkh1Z2dpbmdGYWNlVEIlMkZTbW9sTE0zLTNCLUluc3RydWN0JTIyJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwbW9kZWxfbmFtZSUyQyUwQSUyMCUyMCUyMCUyMGR0eXBlJTNEdG9yY2guYmZsb2F0MTYlMkMlMEElMjAlMjAlMjAlMjBkZXZpY2VfbWFwJTNEJTIyYXV0byUyMiUwQSklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZChtb2RlbF9uYW1lKSUwQXRva2VuaXplci5wYWRfdG9rZW4lMjAlM0QlMjB0b2tlbml6ZXIuZW9zX3Rva2VuJTBBJTBBJTIzJTIwQ29uZmlndXJlJTIwRFBPJTIwdHJhaW5pbmclMjBmb3IlMjBsb2NhbCUyMHRlc3RpbmclMEF0cmFpbmluZ19hcmdzJTIwJTNEJTIwRFBPQ29uZmlnKCUwQSUyMCUyMCUyMCUyMGJldGElM0QwLjElMkMlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBQcmVmZXJlbmNlJTIwb3B0aW1pemF0aW9uJTIwc3RyZW5ndGglMEElMjAlMjAlMjAlMjBsZWFybmluZ19yYXRlJTNENWUtNyUyQyUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMExvd2VyJTIwdGhhbiUyMFNGVCUwQSUyMCUyMCUyMCUyMHBlcl9kZXZpY2VfdHJhaW5fYmF0Y2hfc2l6ZSUzRDElMkMlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBTbWFsbCUyMGJhdGNoJTIwZm9yJTIwbG9jYWwlMjB0ZXN0aW5nJTBBJTIwJTIwJTIwJTIwZ3JhZGllbnRfYWNjdW11bGF0aW9uX3N0ZXBzJTNENCUyQyUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMEVmZmVjdGl2ZSUyMGJhdGNoJTIwc2l6ZSUyMCUzRCUyMDQlMEElMjAlMjAlMjAlMjBtYXhfc3RlcHMlM0Q1MCUyQyUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMFZlcnklMjBzaG9ydCUyMGZvciUyMHRlc3RpbmclMEElMjAlMjAlMjAlMjBsb2dnaW5nX3N0ZXBzJTNEMTAlMkMlMEElMjAlMjAlMjAlMjBvdXRwdXRfZGlyJTNEJTIyLiUyRmxvY2FsX2Rwb190ZXN0JTIyJTJDJTBBJTIwJTIwJTIwJTIwcmVwb3J0X3RvJTNEJTIydHJhY2tpbyUyMiUyQyUwQSklMEElMEElMjMlMjBDcmVhdGUlMjB0cmFpbmVyJTIwKGJ1dCUyMGRvbid0JTIwdHJhaW4lMjB5ZXQlMjAtJTIwc2F2ZSUyMHJlc291cmNlcyUyMGZvciUyMEhGJTIwSm9icyklMEF0cmFpbmVyJTIwJTNEJTIwRFBPVHJhaW5lciglMEElMjAlMjAlMjAlMjBtb2RlbCUzRG1vZGVsJTJDJTBBJTIwJTIwJTIwJTIwYXJncyUzRHRyYWluaW5nX2FyZ3MlMkMlMEElMjAlMjAlMjAlMjB0cmFpbl9kYXRhc2V0JTNEc21hbGxfZGF0YXNldCUyQyUwQSUyMCUyMCUyMCUyMHByb2Nlc3NpbmdfY2xhc3MlM0R0b2tlbml6ZXIlMkMlMEEpJTBBJTBBcHJpbnQoJTIyTG9jYWwlMjBEUE8lMjB0cmFpbmVyJTIwY29uZmlndXJlZCUyMHN1Y2Nlc3NmdWxseSElMjIpJTBBcHJpbnQoJTIyUmVhZHklMjB0byUyMHNjYWxlJTIwdG8lMjBIRiUyMEpvYnMlMjBmb3IlMjBmdWxsJTIwdHJhaW5pbmcuLi4lMjIp",highlighted:`<span class="hljs-comment"># Load a small subset for local testing</span>
small_dataset = dataset.select(<span class="hljs-built_in">range</span>(<span class="hljs-number">1000</span>))

<span class="hljs-comment"># Load SmolLM3-3B-Instruct model</span>
model_name = <span class="hljs-string">&quot;HuggingFaceTB/SmolLM3-3B-Instruct&quot;</span>
model = AutoModelForCausalLM.from_pretrained(
    model_name,
    dtype=torch.bfloat16,
    device_map=<span class="hljs-string">&quot;auto&quot;</span>
)
tokenizer = AutoTokenizer.from_pretrained(model_name)
tokenizer.pad_token = tokenizer.eos_token

<span class="hljs-comment"># Configure DPO training for local testing</span>
training_args = DPOConfig(
    beta=<span class="hljs-number">0.1</span>,                           <span class="hljs-comment"># Preference optimization strength</span>
    learning_rate=<span class="hljs-number">5e-7</span>,                 <span class="hljs-comment"># Lower than SFT</span>
    per_device_train_batch_size=<span class="hljs-number">1</span>,      <span class="hljs-comment"># Small batch for local testing</span>
    gradient_accumulation_steps=<span class="hljs-number">4</span>,      <span class="hljs-comment"># Effective batch size = 4</span>
    max_steps=<span class="hljs-number">50</span>,                       <span class="hljs-comment"># Very short for testing</span>
    logging_steps=<span class="hljs-number">10</span>,
    output_dir=<span class="hljs-string">&quot;./local_dpo_test&quot;</span>,
    report_to=<span class="hljs-string">&quot;trackio&quot;</span>,
)

<span class="hljs-comment"># Create trainer (but don&#x27;t train yet - save resources for HF Jobs)</span>
trainer = DPOTrainer(
    model=model,
    args=training_args,
    train_dataset=small_dataset,
    processing_class=tokenizer,
)

<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Local DPO trainer configured successfully!&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Ready to scale to HF Jobs for full training...&quot;</span>)`,wrap:!1}}),S=new u({props:{title:"Training with Hugging Face Jobs",local:"training-with-hugging-face-jobs",headingTag:"h2"}}),q=new u({props:{title:"Create DPO Training Script",local:"create-dpo-training-script",headingTag:"h3"}}),D=new h({props:{code:"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",highlighted:`<span class="hljs-comment"># dpo_training.py</span>
<span class="hljs-comment"># /// script</span>
<span class="hljs-comment"># dependencies = [</span>
<span class="hljs-comment">#     &quot;trl[dpo]&gt;=0.7.0&quot;,</span>
<span class="hljs-comment">#     &quot;transformers&gt;=4.36.0&quot;, </span>
<span class="hljs-comment">#     &quot;datasets&gt;=2.14.0&quot;,</span>
<span class="hljs-comment">#     &quot;accelerate&gt;=0.24.0&quot;,</span>
<span class="hljs-comment">#     &quot;torch&gt;=2.0.0&quot;</span>
<span class="hljs-comment"># ]</span>
<span class="hljs-comment"># ///</span>

<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> DPOTrainer, DPOConfig
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-keyword">def</span> <span class="hljs-title function_">main</span>():
    <span class="hljs-comment"># Load preference dataset</span>
    dataset = load_dataset(<span class="hljs-string">&quot;Anthropic/hh-rlhf&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)
    
    <span class="hljs-comment"># Take a reasonable subset for training</span>
    train_dataset = dataset.select(<span class="hljs-built_in">range</span>(<span class="hljs-number">10000</span>))
    
    <span class="hljs-comment"># Load SmolLM3-3B model (pre-trained with SFT)</span>
    model_name = <span class="hljs-string">&quot;HuggingFaceTB/SmolLM3-3B&quot;</span>
    model = AutoModelForCausalLM.from_pretrained(model_name)
    tokenizer = AutoTokenizer.from_pretrained(model_name)
    tokenizer.pad_token = tokenizer.eos_token
    
    <span class="hljs-comment"># Configure DPO training</span>
    training_args = DPOConfig(
        <span class="hljs-comment"># Core DPO parameters</span>
        beta=<span class="hljs-number">0.1</span>,                           <span class="hljs-comment"># Preference optimization strength</span>
        max_prompt_length=<span class="hljs-number">512</span>,              <span class="hljs-comment"># Maximum prompt length</span>
        max_length=<span class="hljs-number">1024</span>,                    <span class="hljs-comment"># Maximum total sequence length</span>
        
        <span class="hljs-comment"># Training configuration</span>
        learning_rate=<span class="hljs-number">5e-7</span>,                 <span class="hljs-comment"># Lower than SFT for stability</span>
        per_device_train_batch_size=<span class="hljs-number">2</span>,      <span class="hljs-comment"># Adjust for GPU memory</span>
        gradient_accumulation_steps=<span class="hljs-number">8</span>,      <span class="hljs-comment"># Effective batch size = 16</span>
        max_steps=<span class="hljs-number">1000</span>,                     <span class="hljs-comment"># Sufficient for good alignment</span>
        
        <span class="hljs-comment"># Optimization</span>
        warmup_steps=<span class="hljs-number">100</span>,
        lr_scheduler_type=<span class="hljs-string">&quot;cosine&quot;</span>,
        gradient_checkpointing=<span class="hljs-literal">True</span>,        <span class="hljs-comment"># Memory efficiency</span>
        bf16=<span class="hljs-literal">True</span>,                          <span class="hljs-comment"># Mixed precision</span>
        
        <span class="hljs-comment"># Logging and saving</span>
        logging_steps=<span class="hljs-number">50</span>,
        save_steps=<span class="hljs-number">250</span>,
        output_dir=<span class="hljs-string">&quot;./smollm3-dpo-aligned&quot;</span>,
        
        <span class="hljs-comment"># Hub integration</span>
        push_to_hub=<span class="hljs-literal">True</span>,
        hub_model_id=<span class="hljs-string">&quot;your-username/smollm3-dpo-aligned&quot;</span>,  <span class="hljs-comment"># Change this!</span>
        report_to=<span class="hljs-string">&quot;trackio&quot;</span>,
        
        <span class="hljs-comment"># Remove unused columns for cleaner training</span>
        remove_unused_columns=<span class="hljs-literal">False</span>,
    )
    
    <span class="hljs-comment"># Initialize DPO trainer</span>
    trainer = DPOTrainer(
        model=model,
        args=training_args,
        train_dataset=train_dataset,
        processing_class=tokenizer,
    )
    
    <span class="hljs-comment"># Start training</span>
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Starting DPO training...&quot;</span>)
    trainer.train()
    
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Training completed! Model saved and pushed to Hub.&quot;</span>)

<span class="hljs-keyword">if</span> __name__ == <span class="hljs-string">&quot;__main__&quot;</span>:
    main()`,wrap:!1}}),P=new u({props:{title:"Submit DPO Training Job",local:"submit-dpo-training-job",headingTag:"h3"}}),K=new h({props:{code:"JTIzJTIwU3VibWl0JTIwRFBPJTIwdHJhaW5pbmclMjBqb2IlMjB0byUyMEhGJTIwSm9icyUwQWhmJTIwam9icyUyMHV2JTIwcnVuJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1mbGF2b3IlMjBhMTAwLWxhcmdlJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS10aW1lb3V0JTIwM2glMjAlNUMlMEElMjAlMjAlMjAlMjAtLXNlY3JldHMlMjBIRl9UT0tFTiUyMCU1QyUwQSUyMCUyMCUyMCUyMGRwb190cmFpbmluZy5weQ==",highlighted:`<span class="hljs-comment"># Submit DPO training job to HF Jobs</span>
hf <span class="hljs-built_in">jobs</span> uv run \\
    --flavor a100-large \\
    --<span class="hljs-built_in">timeout</span> 3h \\
    --secrets HF_TOKEN \\
    dpo_training.py`,wrap:!1}}),W=new js({props:{$$slots:{default:[_s]},$$scope:{ctx:g}}}),ll=new u({props:{title:"Alternative: Using TRL’s Built-in DPO Script",local:"alternative-using-trls-built-in-dpo-script",headingTag:"h3"}}),tl=new h({props:{code:"JTIzJTIwVXNlJTIwVFJMJ3MlMjBEUE8lMjBzY3JpcHQlMjB3aXRoJTIwSEYlMjBKb2JzJTBBaGYlMjBqb2JzJTIwdXYlMjBydW4lMjAlNUMlMEElMjAlMjAlMjAlMjAtLWZsYXZvciUyMGExMDAtbGFyZ2UlMjAlNUMlMEElMjAlMjAlMjAlMjAtLXRpbWVvdXQlMjAzaCUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tc2VjcmV0cyUyMEhGX1RPS0VOJTIwJTVDJTBBJTIwJTIwJTIwJTIwJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGaHVnZ2luZ2ZhY2UlMkZ0cmwlMkZtYWluJTJGdHJsJTJGc2NyaXB0cyUyRmRwby5weSUyMiUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tbW9kZWxfbmFtZV9vcl9wYXRoJTIwSHVnZ2luZ0ZhY2VUQiUyRlNtb2xMTTMtM0IlMjAlNUMlMEElMjAlMjAlMjAlMjAtLWRhdGFzZXRfbmFtZSUyMEFudGhyb3BpYyUyRmhoLXJsaGYlMjAlNUMlMEElMjAlMjAlMjAlMjAtLWxlYXJuaW5nX3JhdGUlMjA1ZS03JTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1wZXJfZGV2aWNlX3RyYWluX2JhdGNoX3NpemUlMjAyJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1ncmFkaWVudF9hY2N1bXVsYXRpb25fc3RlcHMlMjA4JTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1tYXhfc3RlcHMlMjAxMDAwJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1iZXRhJTIwMC4xJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1tYXhfcHJvbXB0X2xlbmd0aCUyMDUxMiUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tbWF4X2xlbmd0aCUyMDEwMjQlMjAlNUMlMEElMjAlMjAlMjAlMjAtLW91dHB1dF9kaXIlMjBzbW9sbG0zLWRwby1hbGlnbmVkJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1wdXNoX3RvX2h1YiUyMCU1QyUwQSUyMCUyMCUyMCUyMC0taHViX21vZGVsX2lkJTIweW91ci11c2VybmFtZSUyRnNtb2xsbTMtZHBvLWFsaWduZWQlMjAlNUMlMEElMjAlMjAlMjAlMjAtLXJlcG9ydF90byUyMHRyYWNraW8=",highlighted:`<span class="hljs-comment"># Use TRL&#x27;s DPO script with HF Jobs</span>
hf <span class="hljs-built_in">jobs</span> uv run \\
    --flavor a100-large \\
    --<span class="hljs-built_in">timeout</span> 3h \\
    --secrets HF_TOKEN \\
    <span class="hljs-string">&quot;https://raw.githubusercontent.com/huggingface/trl/main/trl/scripts/dpo.py&quot;</span> \\
    --model_name_or_path HuggingFaceTB/SmolLM3-3B \\
    --dataset_name Anthropic/hh-rlhf \\
    --learning_rate 5e-7 \\
    --per_device_train_batch_size 2 \\
    --gradient_accumulation_steps 8 \\
    --max_steps 1000 \\
    --beta 0.1 \\
    --max_prompt_length 512 \\
    --max_length 1024 \\
    --output_dir smollm3-dpo-aligned \\
    --push_to_hub \\
    --hub_model_id your-username/smollm3-dpo-aligned \\
    --report_to trackio`,wrap:!1}}),el=new u({props:{title:"Monitor Your Training Job",local:"monitor-your-training-job",headingTag:"h2"}}),al=new h({props:{code:"JTIzJTIwTGlzdCUyMGFsbCUyMHlvdXIlMjBqb2JzJTBBaGYlMjBqb2JzJTIwcHMlMjAtYSUwQSUwQSUyMyUyME1vbml0b3IlMjBqb2IlMjBsb2dzJTIwaW4lMjByZWFsLXRpbWUlMEFoZiUyMGpvYnMlMjBsb2dzJTIwJTNDam9iX2lkJTNFJTIwLS1mb2xsb3clMEElMEElMjMlMjBDaGVjayUyMGpvYiUyMGRldGFpbHMlMEFoZiUyMGpvYnMlMjBpbnNwZWN0JTIwJTNDam9iX2lkJTNF",highlighted:`<span class="hljs-comment"># List all your jobs</span>
hf <span class="hljs-built_in">jobs</span> ps -a

<span class="hljs-comment"># Monitor job logs in real-time</span>
hf <span class="hljs-built_in">jobs</span> logs &lt;job_id&gt; --follow

<span class="hljs-comment"># Check job details</span>
hf <span class="hljs-built_in">jobs</span> inspect &lt;job_id&gt;`,wrap:!1}}),il=new u({props:{title:"Evaluate Your DPO-Aligned Model",local:"evaluate-your-dpo-aligned-model",headingTag:"h2"}}),Jl=new h({props:{code:"JTIzJTIwTG9jYWwlMjBldmFsdWF0aW9uJTIwb2YlMjB5b3VyJTIwdHJhaW5lZCUyMG1vZGVsJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBJTIzJTIwTG9hZCUyMHlvdXIlMjB0cmFpbmVkJTIwbW9kZWwlMEFtb2RlbF9uYW1lJTIwJTNEJTIwJTIyeW91ci11c2VybmFtZSUyRnNtb2xsbTMtZHBvLWFsaWduZWQlMjIlMEFnZW5lcmF0b3IlMjAlM0QlMjBwaXBlbGluZSglMjJ0ZXh0LWdlbmVyYXRpb24lMjIlMkMlMjBtb2RlbCUzRG1vZGVsX25hbWUlMkMlMjB0b2tlbml6ZXIlM0Rtb2RlbF9uYW1lKSUwQSUwQSUyMyUyMFRlc3QlMjBhbGlnbm1lbnQlMjBvbiUyMHZhcmlvdXMlMjBwcm9tcHRzJTBBdGVzdF9wcm9tcHRzJTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIySG93JTIwc2hvdWxkJTIwSSUyMGhhbmRsZSUyMGElMjBkaXNhZ3JlZW1lbnQlMjB3aXRoJTIwbXklMjBmcmllbmQlM0YlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJXaGF0J3MlMjB0aGUlMjBiZXN0JTIwd2F5JTIwdG8lMjBsZWFybiUyMHByb2dyYW1taW5nJTNGJTIyJTJDJTIwJTBBJTIwJTIwJTIwJTIwJTIySG93JTIwY2FuJTIwSSUyMGJlJTIwbW9yZSUyMHByb2R1Y3RpdmUlMjBhdCUyMHdvcmslM0YlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJXaGF0JTIwc2hvdWxkJTIwSSUyMGRvJTIwaWYlMjBJJTIwc2VlJTIwc29tZW9uZSUyMGJlaW5nJTIwYnVsbGllZCUzRiUyMiUwQSU1RCUwQSUwQXByaW50KCUyMiUzRCUzRCUzRCUyMERQTyUyME1vZGVsJTIwQWxpZ25tZW50JTIwVGVzdCUyMCUzRCUzRCUzRCUyMiklMEFmb3IlMjBwcm9tcHQlMjBpbiUyMHRlc3RfcHJvbXB0cyUzQSUwQSUyMCUyMCUyMCUyMHJlc3BvbnNlJTIwJTNEJTIwZ2VuZXJhdG9yKHByb21wdCUyQyUyMG1heF9sZW5ndGglM0QyMDAlMkMlMjBkb19zYW1wbGUlM0RUcnVlJTJDJTIwdGVtcGVyYXR1cmUlM0QwLjcpJTBBJTIwJTIwJTIwJTIwcHJpbnQoZiUyMiU1Q25Qcm9tcHQlM0ElMjAlN0Jwcm9tcHQlN0QlMjIpJTBBJTIwJTIwJTIwJTIwcHJpbnQoZiUyMlJlc3BvbnNlJTNBJTIwJTdCcmVzcG9uc2UlNUIwJTVEJTVCJ2dlbmVyYXRlZF90ZXh0JyU1RCU1Qmxlbihwcm9tcHQpJTNBJTVELnN0cmlwKCklN0QlMjIp",highlighted:`<span class="hljs-comment"># Local evaluation of your trained model</span>
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-comment"># Load your trained model</span>
model_name = <span class="hljs-string">&quot;your-username/smollm3-dpo-aligned&quot;</span>
generator = pipeline(<span class="hljs-string">&quot;text-generation&quot;</span>, model=model_name, tokenizer=model_name)

<span class="hljs-comment"># Test alignment on various prompts</span>
test_prompts = [
    <span class="hljs-string">&quot;How should I handle a disagreement with my friend?&quot;</span>,
    <span class="hljs-string">&quot;What&#x27;s the best way to learn programming?&quot;</span>, 
    <span class="hljs-string">&quot;How can I be more productive at work?&quot;</span>,
    <span class="hljs-string">&quot;What should I do if I see someone being bullied?&quot;</span>
]

<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;=== DPO Model Alignment Test ===&quot;</span>)
<span class="hljs-keyword">for</span> prompt <span class="hljs-keyword">in</span> test_prompts:
    response = generator(prompt, max_length=<span class="hljs-number">200</span>, do_sample=<span class="hljs-literal">True</span>, temperature=<span class="hljs-number">0.7</span>)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;\\nPrompt: <span class="hljs-subst">{prompt}</span>&quot;</span>)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Response: <span class="hljs-subst">{response[<span class="hljs-number">0</span>][<span class="hljs-string">&#x27;generated_text&#x27;</span>][<span class="hljs-built_in">len</span>(prompt):].strip()}</span>&quot;</span>)`,wrap:!1}}),Tl=new u({props:{title:"Submit to Course Leaderboard",local:"submit-to-course-leaderboard",headingTag:"h2"}}),ml=new u({props:{title:"Resources and Further Reading",local:"resources-and-further-reading",headingTag:"h2"}}),cl=new zs({props:{source:"https://github.com/huggingface/smol-course/blob/main/units/en/unit2/3.md"}}),{c(){M=m("meta"),d=n(),j=m("p"),U=n(),i(b.$$.fragment),C=n(),i(I.$$.fragment),G=n(),w=m("p"),w.textContent=B,ul=n(),i(f.$$.fragment),dl=n(),bl=m("hr"),hl=n(),i(E.$$.fragment),Cl=n(),R=m("p"),R.innerHTML=ws,gl=n(),i($.$$.fragment),Bl=n(),i(A.$$.fragment),fl=n(),F=m("p"),F.textContent=Us,Al=n(),i(X.$$.fragment),Zl=n(),i(V.$$.fragment),Wl=n(),i(v.$$.fragment),Gl=n(),i(H.$$.fragment),El=n(),k=m("p"),k.textContent=Is,Rl=n(),i(Y.$$.fragment),$l=n(),Z=m("details"),Ul=m("summary"),Ul.textContent=us,rs=n(),i(z.$$.fragment),Fl=n(),i(N.$$.fragment),Xl=n(),Q=m("p"),Q.textContent=ds,Vl=n(),i(_.$$.fragment),vl=n(),i(S.$$.fragment),Hl=n(),x=m("p"),x.textContent=bs,kl=n(),i(q.$$.fragment),Yl=n(),L=m("p"),L.textContent=hs,zl=n(),i(D.$$.fragment),Nl=n(),i(P.$$.fragment),Ql=n(),O=m("p"),O.textContent=Cs,_l=n(),i(K.$$.fragment),Sl=n(),i(W.$$.fragment),xl=n(),i(ll.$$.fragment),ql=n(),sl=m("p"),sl.textContent=gs,Ll=n(),i(tl.$$.fragment),Dl=n(),i(el.$$.fragment),Pl=n(),nl=m("p"),nl.textContent=Bs,Ol=n(),i(al.$$.fragment),Kl=n(),Ml=m("p"),Ml.textContent=fs,ls=n(),i(il.$$.fragment),ss=n(),pl=m("p"),pl.textContent=As,ts=n(),i(Jl.$$.fragment),es=n(),i(Tl.$$.fragment),ns=n(),ol=m("p"),ol.innerHTML=Zs,as=n(),rl=m("ol"),rl.innerHTML=Ws,Ms=n(),i(ml.$$.fragment),is=n(),yl=m("ul"),yl.innerHTML=Gs,ps=n(),jl=m("p"),jl.textContent=Es,Js=n(),i(cl.$$.fragment),Ts=n(),Il=m("p"),this.h()},l(l){const s=ks("svelte-u9bgzb",document.head);M=y(s,"META",{name:!0,content:!0}),s.forEach(t),d=a(l),j=y(l,"P",{}),ms(j).forEach(t),U=a(l),p(b.$$.fragment,l),C=a(l),p(I.$$.fragment,l),G=a(l),w=y(l,"P",{"data-svelte-h":!0}),c(w)!=="svelte-1rxfcqi"&&(w.textContent=B),ul=a(l),p(f.$$.fragment,l),dl=a(l),bl=y(l,"HR",{}),hl=a(l),p(E.$$.fragment,l),Cl=a(l),R=y(l,"P",{"data-svelte-h":!0}),c(R)!=="svelte-1d17tik"&&(R.innerHTML=ws),gl=a(l),p($.$$.fragment,l),Bl=a(l),p(A.$$.fragment,l),fl=a(l),F=y(l,"P",{"data-svelte-h":!0}),c(F)!=="svelte-d8uuwu"&&(F.textContent=Us),Al=a(l),p(X.$$.fragment,l),Zl=a(l),p(V.$$.fragment,l),Wl=a(l),p(v.$$.fragment,l),Gl=a(l),p(H.$$.fragment,l),El=a(l),k=y(l,"P",{"data-svelte-h":!0}),c(k)!=="svelte-5m8jly"&&(k.textContent=Is),Rl=a(l),p(Y.$$.fragment,l),$l=a(l),Z=y(l,"DETAILS",{});var wl=ms(Z);Ul=y(wl,"SUMMARY",{"data-svelte-h":!0}),c(Ul)!=="svelte-b0es8p"&&(Ul.textContent=us),rs=a(wl),p(z.$$.fragment,wl),wl.forEach(t),Fl=a(l),p(N.$$.fragment,l),Xl=a(l),Q=y(l,"P",{"data-svelte-h":!0}),c(Q)!=="svelte-1120l5l"&&(Q.textContent=ds),Vl=a(l),p(_.$$.fragment,l),vl=a(l),p(S.$$.fragment,l),Hl=a(l),x=y(l,"P",{"data-svelte-h":!0}),c(x)!=="svelte-f6er3w"&&(x.textContent=bs),kl=a(l),p(q.$$.fragment,l),Yl=a(l),L=y(l,"P",{"data-svelte-h":!0}),c(L)!=="svelte-1wztmpw"&&(L.textContent=hs),zl=a(l),p(D.$$.fragment,l),Nl=a(l),p(P.$$.fragment,l),Ql=a(l),O=y(l,"P",{"data-svelte-h":!0}),c(O)!=="svelte-1j921q5"&&(O.textContent=Cs),_l=a(l),p(K.$$.fragment,l),Sl=a(l),p(W.$$.fragment,l),xl=a(l),p(ll.$$.fragment,l),ql=a(l),sl=y(l,"P",{"data-svelte-h":!0}),c(sl)!=="svelte-1gdhsgv"&&(sl.textContent=gs),Ll=a(l),p(tl.$$.fragment,l),Dl=a(l),p(el.$$.fragment,l),Pl=a(l),nl=y(l,"P",{"data-svelte-h":!0}),c(nl)!=="svelte-1fcp9yh"&&(nl.textContent=Bs),Ol=a(l),p(al.$$.fragment,l),Kl=a(l),Ml=y(l,"P",{"data-svelte-h":!0}),c(Ml)!=="svelte-8er7ep"&&(Ml.textContent=fs),ls=a(l),p(il.$$.fragment,l),ss=a(l),pl=y(l,"P",{"data-svelte-h":!0}),c(pl)!=="svelte-ew4vmd"&&(pl.textContent=As),ts=a(l),p(Jl.$$.fragment,l),es=a(l),p(Tl.$$.fragment,l),ns=a(l),ol=y(l,"P",{"data-svelte-h":!0}),c(ol)!=="svelte-fzi3kg"&&(ol.innerHTML=Zs),as=a(l),rl=y(l,"OL",{"data-svelte-h":!0}),c(rl)!=="svelte-7li7ao"&&(rl.innerHTML=Ws),Ms=a(l),p(ml.$$.fragment,l),is=a(l),yl=y(l,"UL",{"data-svelte-h":!0}),c(yl)!=="svelte-qy5ibh"&&(yl.innerHTML=Gs),ps=a(l),jl=y(l,"P",{"data-svelte-h":!0}),c(jl)!=="svelte-1jkjs6s"&&(jl.textContent=Es),Js=a(l),p(cl.$$.fragment,l),Ts=a(l),Il=y(l,"P",{}),ms(Il).forEach(t),this.h()},h(){Fs(M,"name","hf:doc:metadata"),Fs(M,"content",xs)},m(l,s){ys(document.head,M),e(l,d,s),e(l,j,s),e(l,U,s),J(b,l,s),e(l,C,s),J(I,l,s),e(l,G,s),e(l,w,s),e(l,ul,s),J(f,l,s),e(l,dl,s),e(l,bl,s),e(l,hl,s),J(E,l,s),e(l,Cl,s),e(l,R,s),e(l,gl,s),J($,l,s),e(l,Bl,s),J(A,l,s),e(l,fl,s),e(l,F,s),e(l,Al,s),J(X,l,s),e(l,Zl,s),J(V,l,s),e(l,Wl,s),J(v,l,s),e(l,Gl,s),J(H,l,s),e(l,El,s),e(l,k,s),e(l,Rl,s),J(Y,l,s),e(l,$l,s),e(l,Z,s),ys(Z,Ul),ys(Z,rs),J(z,Z,null),e(l,Fl,s),J(N,l,s),e(l,Xl,s),e(l,Q,s),e(l,Vl,s),J(_,l,s),e(l,vl,s),J(S,l,s),e(l,Hl,s),e(l,x,s),e(l,kl,s),J(q,l,s),e(l,Yl,s),e(l,L,s),e(l,zl,s),J(D,l,s),e(l,Nl,s),J(P,l,s),e(l,Ql,s),e(l,O,s),e(l,_l,s),J(K,l,s),e(l,Sl,s),J(W,l,s),e(l,xl,s),J(ll,l,s),e(l,ql,s),e(l,sl,s),e(l,Ll,s),J(tl,l,s),e(l,Dl,s),J(el,l,s),e(l,Pl,s),e(l,nl,s),e(l,Ol,s),J(al,l,s),e(l,Kl,s),e(l,Ml,s),e(l,ls,s),J(il,l,s),e(l,ss,s),e(l,pl,s),e(l,ts,s),J(Jl,l,s),e(l,es,s),J(Tl,l,s),e(l,ns,s),e(l,ol,s),e(l,as,s),e(l,rl,s),e(l,Ms,s),J(ml,l,s),e(l,is,s),e(l,yl,s),e(l,ps,s),e(l,jl,s),e(l,Js,s),J(cl,l,s),e(l,Ts,s),e(l,Il,s),os=!0},p(l,[s]){const wl={};s&2&&(wl.$$scope={dirty:s,ctx:l}),f.$set(wl);const Rs={};s&2&&(Rs.$$scope={dirty:s,ctx:l}),A.$set(Rs);const $s={};s&2&&($s.$$scope={dirty:s,ctx:l}),W.$set($s)},i(l){os||(T(b.$$.fragment,l),T(I.$$.fragment,l),T(f.$$.fragment,l),T(E.$$.fragment,l),T($.$$.fragment,l),T(A.$$.fragment,l),T(X.$$.fragment,l),T(V.$$.fragment,l),T(v.$$.fragment,l),T(H.$$.fragment,l),T(Y.$$.fragment,l),T(z.$$.fragment,l),T(N.$$.fragment,l),T(_.$$.fragment,l),T(S.$$.fragment,l),T(q.$$.fragment,l),T(D.$$.fragment,l),T(P.$$.fragment,l),T(K.$$.fragment,l),T(W.$$.fragment,l),T(ll.$$.fragment,l),T(tl.$$.fragment,l),T(el.$$.fragment,l),T(al.$$.fragment,l),T(il.$$.fragment,l),T(Jl.$$.fragment,l),T(Tl.$$.fragment,l),T(ml.$$.fragment,l),T(cl.$$.fragment,l),os=!0)},o(l){o(b.$$.fragment,l),o(I.$$.fragment,l),o(f.$$.fragment,l),o(E.$$.fragment,l),o($.$$.fragment,l),o(A.$$.fragment,l),o(X.$$.fragment,l),o(V.$$.fragment,l),o(v.$$.fragment,l),o(H.$$.fragment,l),o(Y.$$.fragment,l),o(z.$$.fragment,l),o(N.$$.fragment,l),o(_.$$.fragment,l),o(S.$$.fragment,l),o(q.$$.fragment,l),o(D.$$.fragment,l),o(P.$$.fragment,l),o(K.$$.fragment,l),o(W.$$.fragment,l),o(ll.$$.fragment,l),o(tl.$$.fragment,l),o(el.$$.fragment,l),o(al.$$.fragment,l),o(il.$$.fragment,l),o(Jl.$$.fragment,l),o(Tl.$$.fragment,l),o(ml.$$.fragment,l),o(cl.$$.fragment,l),os=!1},d(l){l&&(t(d),t(j),t(U),t(C),t(G),t(w),t(ul),t(dl),t(bl),t(hl),t(Cl),t(R),t(gl),t(Bl),t(fl),t(F),t(Al),t(Zl),t(Wl),t(Gl),t(El),t(k),t(Rl),t($l),t(Z),t(Fl),t(Xl),t(Q),t(Vl),t(vl),t(Hl),t(x),t(kl),t(Yl),t(L),t(zl),t(Nl),t(Ql),t(O),t(_l),t(Sl),t(xl),t(ql),t(sl),t(Ll),t(Dl),t(Pl),t(nl),t(Ol),t(Kl),t(Ml),t(ls),t(ss),t(pl),t(ts),t(es),t(ns),t(ol),t(as),t(rl),t(Ms),t(is),t(yl),t(ps),t(jl),t(Js),t(Ts),t(Il)),t(M),r(b,l),r(I,l),r(f,l),r(E,l),r($,l),r(A,l),r(X,l),r(V,l),r(v,l),r(H,l),r(Y,l),r(z),r(N,l),r(_,l),r(S,l),r(q,l),r(D,l),r(P,l),r(K,l),r(W,l),r(ll,l),r(tl,l),r(el,l),r(al,l),r(il,l),r(Jl,l),r(Tl,l),r(ml,l),r(cl,l)}}}const xs='{"title":"Hands-On Exercise: Direct Preference Optimization with SmolLM3","local":"hands-on-exercise-direct-preference-optimization-with-smollm3","sections":[{"title":"Exercise: Direct Preference Optimization Training","local":"exercise-direct-preference-optimization-training","sections":[{"title":"Environment Setup","local":"environment-setup","sections":[],"depth":3},{"title":"Import Libraries and Setup","local":"import-libraries-and-setup","sections":[],"depth":3},{"title":"Understanding DPO Data Format","local":"understanding-dpo-data-format","sections":[],"depth":3},{"title":"Local DPO Training Test (Optional)","local":"local-dpo-training-test-optional","sections":[],"depth":3}],"depth":2},{"title":"Training with Hugging Face Jobs","local":"training-with-hugging-face-jobs","sections":[{"title":"Create DPO Training Script","local":"create-dpo-training-script","sections":[],"depth":3},{"title":"Submit DPO Training Job","local":"submit-dpo-training-job","sections":[],"depth":3},{"title":"Alternative: Using TRL’s Built-in DPO Script","local":"alternative-using-trls-built-in-dpo-script","sections":[],"depth":3}],"depth":2},{"title":"Monitor Your Training Job","local":"monitor-your-training-job","sections":[],"depth":2},{"title":"Evaluate Your DPO-Aligned Model","local":"evaluate-your-dpo-aligned-model","sections":[],"depth":2},{"title":"Submit to Course Leaderboard","local":"submit-to-course-leaderboard","sections":[],"depth":2},{"title":"Resources and Further Reading","local":"resources-and-further-reading","sections":[],"depth":2}],"depth":1}';function qs(g){return Vs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class st extends vs{constructor(M){super(),Hs(this,M,qs,Ss,Xs,{})}}export{st as component};
