import{s as aa,n as sa,o as na}from"../chunks/scheduler.6062bdaf.js";import{S as ia,i as oa,g as i,s,r,A as Ma,h as o,f as t,c as n,j as ta,u as p,x as M,k as ot,y as ra,a,v as c,d,t as h,w as m}from"../chunks/index.4bca734e.js";import{C as y}from"../chunks/CodeBlock.fa01571c.js";import{H as u,E as pa}from"../chunks/EditOnGithub.74ab2baa.js";function ca(Mt){let w,Qe,Ee,Ve,J,Xe,b,rt=`The Hugging Face Hub makes hosting and sharing models with the community easy. It supports
<a href="https://huggingface.co/docs/hub/models-libraries" rel="nofollow">dozens of libraries</a> in the Open Source ecosystem. We are always
working on expanding this support to push collaborative Machine Learning forward. The <code>huggingface_hub</code> library plays a
key role in this process, allowing any Python script to easily push and load files.`,$e,f,pt="There are four main ways to integrate a library with the Hub:",Re,U,ct=`<li><strong>Push to Hub:</strong> implement a method to upload a model to the Hub. This includes the model weights, as well as
<a href="https://huggingface.co/docs/huggingface_hub/how-to-model-cards" rel="nofollow">the model card</a> and any other relevant information
or data necessary to run the model (for example, training logs). This method is often called <code>push_to_hub()</code>.</li> <li><strong>Download from Hub:</strong> implement a method to load a model from the Hub. The method should download the model
configuration/weights and load the model. This method is often called <code>from_pretrained</code> or <code>load_from_hub()</code>.</li> <li><strong>Inference API:</strong> use our servers to run inference on models supported by your library for free.</li> <li><strong>Widgets:</strong> display a widget on the landing page of your models on the Hub. It allows users to quickly try a model
from the browser.</li>`,Ne,g,dt=`In this guide, we will focus on the first two topics. We will present the two main approaches you can use to integrate
a library, with their advantages and drawbacks. Everything is summarized at the end of the guide to help you choose
between the two. Please keep in mind that these are only guidelines that you are free to adapt to you requirements.`,Se,I,ht=`If you are interested in Inference and Widgets, you can follow <a href="https://huggingface.co/docs/hub/models-adding-libraries#set-up-the-inference-api" rel="nofollow">this guide</a>.
In both cases, you can reach out to us if you are integrating a library with the Hub and want to be listed
<a href="https://huggingface.co/docs/hub/models-libraries" rel="nofollow">in our docs</a>.`,Fe,_,Le,C,mt=`The first approach to integrate a library to the Hub is to actually implement the <code>push_to_hub</code> and <code>from_pretrained</code>
methods by yourself. This gives you full flexibility on which files you need to upload/download and how to handle inputs
specific to your framework. You can refer to the two <a href="./upload">upload files</a> and <a href="./download">download files</a> guides
to learn more about how to do that. This is, for example how the FastAI integration is implemented (see <a href="/docs/huggingface_hub/pr_2344/en/package_reference/mixins#huggingface_hub.push_to_hub_fastai">push_to_hub_fastai()</a>
and <a href="/docs/huggingface_hub/pr_2344/en/package_reference/mixins#huggingface_hub.from_pretrained_fastai">from_pretrained_fastai()</a>).`,ze,Z,ut="Implementation can differ between libraries, but the workflow is often similar.",qe,B,Pe,v,yt="This is how a <code>from_pretrained</code> method usually look like:",De,k,Ke,A,Oe,x,wt=`The <code>push_to_hub</code> method often requires a bit more complexity to handle repo creation, generate the model card and save weights.
A common approach is to save all of these files in a temporary folder, upload it and then delete it.`,el,G,ll,H,Tt=`This is of course only an example. If you are interested in more complex manipulations (delete remote files, upload
weights on the fly, persist weights locally, etc.) please refer to the <a href="./upload">upload files</a> guide.`,tl,W,al,E,jt=`While being flexible, this approach has some drawbacks, especially in terms of maintenance. Hugging Face users are often
used to additional features when working with <code>huggingface_hub</code>. For example, when loading files from the Hub, it is
common to offer parameters like:`,sl,Y,Jt="<li><code>token</code>: to download from a private repo</li> <li><code>revision</code>: to download from a specific branch</li> <li><code>cache_dir</code>: to cache files in a specific directory</li> <li><code>force_download</code>/<code>local_files_only</code>: to reuse the cache or not</li> <li><code>proxies</code>: configure HTTP session</li>",nl,Q,bt="When pushing models, similar parameters are supported:",il,V,ft="<li><code>commit_message</code>: custom commit message</li> <li><code>private</code>: create a private repo if missing</li> <li><code>create_pr</code>: create a PR instead of pushing to <code>main</code></li> <li><code>branch</code>: push to a branch instead of the <code>main</code> branch</li> <li><code>allow_patterns</code>/<code>ignore_patterns</code>: filter which files to upload</li> <li><code>token</code></li> <li>…</li>",ol,X,Ut=`All of these parameters can be added to the implementations we saw above and passed to the <code>huggingface_hub</code> methods.
However, if a parameter changes or a new feature is added, you will need to update your package. Supporting those
parameters also means more documentation to maintain on your side. To see how to mitigate these limitations, let’s jump
to our next section <strong>class inheritance</strong>.`,Ml,$,rl,R,gt=`As we saw above, there are two main methods to include in your library to integrate it with the Hub: upload files
(<code>push_to_hub</code>) and download files (<code>from_pretrained</code>). You can implement those methods by yourself but it comes with
caveats. To tackle this, <code>huggingface_hub</code> provides a tool that uses class inheritance. Let’s see how it works!`,pl,N,It=`In a lot of cases, a library already implements its model using a Python class. The class contains the properties of
the model and methods to load, run, train, and evaluate it. Our approach is to extend this class to include upload and
download features using mixins. A <a href="https://stackoverflow.com/a/547714" rel="nofollow">Mixin</a> is a class that is meant to extend an
existing class with a set of specific features using multiple inheritance. <code>huggingface_hub</code> provides its own mixin,
the <a href="/docs/huggingface_hub/pr_2344/en/package_reference/mixins#huggingface_hub.ModelHubMixin">ModelHubMixin</a>. The key here is to understand its behavior and how to customize it.`,cl,S,_t=`The <a href="/docs/huggingface_hub/pr_2344/en/package_reference/mixins#huggingface_hub.ModelHubMixin">ModelHubMixin</a> class implements 3 <em>public</em> methods (<code>push_to_hub</code>, <code>save_pretrained</code> and <code>from_pretrained</code>). Those
are the methods that your users will call to load/save models with your library. <a href="/docs/huggingface_hub/pr_2344/en/package_reference/mixins#huggingface_hub.ModelHubMixin">ModelHubMixin</a> also defines 2
<em>private</em> methods (<code>_save_pretrained</code> and <code>_from_pretrained</code>). Those are the ones you must implement. So to integrate
your library, you should:`,dl,F,Ct=`<li>Make your Model class inherit from <a href="/docs/huggingface_hub/pr_2344/en/package_reference/mixins#huggingface_hub.ModelHubMixin">ModelHubMixin</a>.</li> <li>Implement the private methods:<ul><li><a href="/docs/huggingface_hub/pr_2344/en/package_reference/mixins#huggingface_hub.ModelHubMixin._save_pretrained">_save_pretrained()</a>: method taking as input a path to a directory and saving the model to it.
You must write all the logic to dump your model in this method: model card, model weights, configuration files,
training logs, and figures. Any relevant information for this model must be handled by this method.
<a href="https://huggingface.co/docs/hub/model-cards" rel="nofollow">Model Cards</a> are particularly important to describe your model. Check
out <a href="./model-cards">our implementation guide</a> for more details.</li> <li><a href="/docs/huggingface_hub/pr_2344/en/package_reference/mixins#huggingface_hub.ModelHubMixin._from_pretrained">_from_pretrained()</a>: <strong>class method</strong> taking as input a <code>model_id</code> and returning an instantiated
model. The method must download the relevant files and load them.</li></ul></li> <li>You are done!</li>`,hl,L,Zt='The advantage of using <a href="/docs/huggingface_hub/pr_2344/en/package_reference/mixins#huggingface_hub.ModelHubMixin">ModelHubMixin</a> is that once you take care of the serialization/loading of the files, you are ready to go. You don’t need to worry about stuff like repo creation, commits, PRs, or revisions. The <a href="/docs/huggingface_hub/pr_2344/en/package_reference/mixins#huggingface_hub.ModelHubMixin">ModelHubMixin</a> also ensures public methods are documented and type annotated, and you’ll be able to view your model’s download count on the Hub. All of this is handled by the <a href="/docs/huggingface_hub/pr_2344/en/package_reference/mixins#huggingface_hub.ModelHubMixin">ModelHubMixin</a> and available to your users.',ml,z,ul,q,Bt='A good example of what we saw above is <a href="/docs/huggingface_hub/pr_2344/en/package_reference/mixins#huggingface_hub.PyTorchModelHubMixin">PyTorchModelHubMixin</a>, our integration for the PyTorch framework. This is a ready-to-use integration.',yl,P,wl,D,vt="Here is how any user can load/save a PyTorch model from/to the Hub:",Tl,K,jl,O,Jl,ee,kt='The implementation is actually very straightforward, and the full implementation can be found <a href="https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hub_mixin.py" rel="nofollow">here</a>.',bl,le,At="<li>First, inherit your class from <code>ModelHubMixin</code>:</li>",fl,te,Ul,T,xt="<li>Implement the <code>_save_pretrained</code> method:</li>",gl,ae,Il,j,Gt="<li>Implement the <code>_from_pretrained</code> method:</li>",_l,se,Cl,ne,Ht="And that’s it! Your library now enables users to upload and download files to and from the Hub.",Zl,ie,Bl,oe,Wt='In the section above, we quickly discussed how the <a href="/docs/huggingface_hub/pr_2344/en/package_reference/mixins#huggingface_hub.ModelHubMixin">ModelHubMixin</a> works. In this section, we will see some of its more advanced features to improve your library integration with the Hugging Face Hub.',vl,Me,kl,re,Et='<a href="/docs/huggingface_hub/pr_2344/en/package_reference/mixins#huggingface_hub.ModelHubMixin">ModelHubMixin</a> generates the model card for you. Model cards are files that accompany the models and provide important information about them. Under the hood, model cards are simple Markdown files with additional metadata. Model cards are essential for discoverability, reproducibility, and sharing! Check out the <a href="https://huggingface.co/docs/hub/model-cards" rel="nofollow">Model Cards guide</a> for more details.',Al,pe,Yt='Generating model cards semi-automatically is a good way to ensure that all models pushed with your library will share common metadata: <code>library_name</code>, <code>tags</code>, <code>license</code>, <code>pipeline_tag</code>, etc. This makes all models backed by your library easily searchable on the Hub and provides some resource links for users landing on the Hub. You can define the metadata directly when inheriting from <a href="/docs/huggingface_hub/pr_2344/en/package_reference/mixins#huggingface_hub.ModelHubMixin">ModelHubMixin</a>:',xl,ce,Gl,de,Qt='By default, a generic model card will be generated with the info you’ve provided (example: <a href="https://huggingface.co/pyp1/VoiceCraft_giga830M" rel="nofollow">pyp1/VoiceCraft_giga830M</a>). But you can define your own model card template as well!',Hl,he,Vt='In this example, all models pushed with the <code>VoiceCraft</code> class will automatically include a citation section and license details. For more details on how to define a model card template, please check the <a href="./model-cards">Model Cards guide</a>.',Wl,me,El,ue,Xt="Finally, if you want to extend the model card generation process with dynamic values, you can override the <code>generate_model_card()</code> method:",Yl,ye,Ql,we,Vl,Te,$t='<a href="/docs/huggingface_hub/pr_2344/en/package_reference/mixins#huggingface_hub.ModelHubMixin">ModelHubMixin</a> handles the model configuration for you. It automatically checks the input values when you instantiate the model and serializes them in a <code>config.json</code> file. This provides 2 benefits:',Xl,je,Rt="<li>Users will be able to reload the model with the exact same parameters as you.</li> <li>Having a <code>config.json</code> file automatically enables analytics on the Hub (i.e. the “downloads” count).</li>",$l,Je,Nt="But how does it work in practice? Several rules make the process as smooth as possible from a user perspective:",Rl,be,St="<li>if your <code>__init__</code> method expects a <code>config</code> input, it will be automatically saved in the repo as <code>config.json</code>.</li> <li>if the <code>config</code> input parameter is annotated with a dataclass type (e.g. <code>config: Optional[MyConfigClass] = None</code>), then the <code>config</code> value will be correctly deserialized for you.</li> <li>all values passed at initialization will also be stored in the config file. This means you don’t necessarily have to expect a <code>config</code> input to benefit from it.</li>",Nl,fe,Ft="Example:",Sl,Ue,Fl,ge,Lt='But what if a value cannot be serialized as JSON? By default, the value will be ignored when saving the config file. However, in some cases your library already expects a custom object as input that cannot be serialized, and you don’t want to update your internal logic to update its type. No worries! You can pass custom encoders/decoders for any type when inheriting from <a href="/docs/huggingface_hub/pr_2344/en/package_reference/mixins#huggingface_hub.ModelHubMixin">ModelHubMixin</a>. This is a bit more work but ensures your internal logic is untouched when integrating your library with the Hub.',Ll,Ie,zt="Here is a concrete example where a class expects a <code>argparse.Namespace</code> config as input:",zl,_e,ql,Ce,qt="One solution can be to update the <code>__init__</code> signature to <code>def __init__(self, pattern: str, hidden_size: int)</code> and update all snippets that instantiates your class. This is a perfectly valid way to fix it but it might break downstream applications using your library.",Pl,Ze,Pt="Another solution is to provide a simple encoder/decoder to convert <code>argparse.Namespace</code> to a dictionary.",Dl,Be,Kl,ve,Dt="In the snippet above, both the internal logic and the <code>__init__</code> signature of the class did not change. This means all existing code snippets for your library will continue to work. To achieve this, we had to:",Ol,ke,Kt="<li>Inherit from the mixin (<code>PytorchModelHubMixin</code> in this case).</li> <li>Pass a <code>coders</code> parameter in the inheritance. This is a dictionary where keys are custom types you want to process. Values are a tuple <code>(encoder, decoder)</code>.<ul><li>The encoder expects an object of the specified type as input and returns a jsonable value. This will be used when saving a model with <code>save_pretrained</code>.</li> <li>The decoder expects raw data (typically a dictionary) as input and reconstructs the initial object. This will be used when loading the model with <code>from_pretrained</code>.</li></ul></li> <li>Add a type annotation to the <code>__init__</code> signature. This is important to let the mixin know which type is expected by the class and, therefore, which decoder to use.</li>",et,Ae,Ot="For the sake of simplicity, the encoder/decoder functions in the example above are not robust. For a concrete implementation, you would most likely have to handle corner cases properly.",lt,xe,tt,Ge,ea=`Let’s quickly sum up the two approaches we saw with their advantages and drawbacks. The table below is only indicative.
Your framework might have some specificities that you need to address. This guide is only here to give guidelines and
ideas on how to handle integration. In any case, feel free to contact us if you have any questions!`,at,He,la='<thead><tr><th align="center">Integration</th> <th align="center">Using helpers</th> <th align="center">Using <a href="/docs/huggingface_hub/pr_2344/en/package_reference/mixins#huggingface_hub.ModelHubMixin">ModelHubMixin</a></th></tr></thead> <tbody><tr><td align="center">User experience</td> <td align="center"><code>model = load_from_hub(...)</code><br/><code>push_to_hub(model, ...)</code></td> <td align="center"><code>model = MyModel.from_pretrained(...)</code><br/><code>model.push_to_hub(...)</code></td></tr> <tr><td align="center">Flexibility</td> <td align="center">Very flexible.<br/>You fully control the implementation.</td> <td align="center">Less flexible.<br/>Your framework must have a model class.</td></tr> <tr><td align="center">Maintenance</td> <td align="center">More maintenance to add support for configuration, and new features. Might also require fixing issues reported by users.</td> <td align="center">Less maintenance as most of the interactions with the Hub are implemented in <code>huggingface_hub</code>.</td></tr> <tr><td align="center">Documentation / Type annotation</td> <td align="center">To be written manually.</td> <td align="center">Partially handled by <code>huggingface_hub</code>.</td></tr> <tr><td align="center">Download counter</td> <td align="center">To be handled manually.</td> <td align="center">Enabled by default if class has a <code>config</code> attribute.</td></tr> <tr><td align="center">Model card</td> <td align="center">To be handled manually</td> <td align="center">Generated by default with library_name, tags, etc.</td></tr></tbody>',st,We,nt,Ye,it;return J=new u({props:{title:"Integrate any ML framework with the Hub",local:"integrate-any-ml-framework-with-the-hub",headingTag:"h1"}}),_=new u({props:{title:"A flexible approach: helpers",local:"a-flexible-approach-helpers",headingTag:"h2"}}),B=new u({props:{title:"from_pretrained",local:"frompretrained",headingTag:"h3"}}),k=new y({props:{code:"ZGVmJTIwZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2lkJTNBJTIwc3RyKSUyMC0lM0UlMjBNeU1vZGVsQ2xhc3MlM0ElMEElMjAlMjAlMjAlMjMlMjBEb3dubG9hZCUyMG1vZGVsJTIwZnJvbSUyMEh1YiUwQSUyMCUyMCUyMGNhY2hlZF9tb2RlbCUyMCUzRCUyMGhmX2h1Yl9kb3dubG9hZCglMEElMjAlMjAlMjAlMjAlMjAlMjByZXBvX2lkJTNEcmVwb19pZCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMGZpbGVuYW1lJTNEJTIybW9kZWwucGtsJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwbGlicmFyeV9uYW1lJTNEJTIyZmFzdGFpJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwbGlicmFyeV92ZXJzaW9uJTNEZ2V0X2Zhc3RhaV92ZXJzaW9uKCklMkMlMEElMjAlMjAlMjApJTBBJTBBJTIwJTIwJTIwJTIzJTIwTG9hZCUyMG1vZGVsJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwbG9hZF9tb2RlbChjYWNoZWRfbW9kZWwp",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">from_pretrained</span>(<span class="hljs-params">model_id: <span class="hljs-built_in">str</span></span>) -&gt; MyModelClass:
   <span class="hljs-comment"># Download model from Hub</span>
   cached_model = hf_hub_download(
      repo_id=repo_id,
      filename=<span class="hljs-string">&quot;model.pkl&quot;</span>,
      library_name=<span class="hljs-string">&quot;fastai&quot;</span>,
      library_version=get_fastai_version(),
   )

   <span class="hljs-comment"># Load model</span>
    <span class="hljs-keyword">return</span> load_model(cached_model)`,wrap:!1}}),A=new u({props:{title:"push_to_hub",local:"pushtohub",headingTag:"h3"}}),G=new y({props:{code:"ZGVmJTIwcHVzaF90b19odWIobW9kZWwlM0ElMjBNeU1vZGVsQ2xhc3MlMkMlMjByZXBvX25hbWUlM0ElMjBzdHIpJTIwLSUzRSUyME5vbmUlM0ElMEElMjAlMjAlMjBhcGklMjAlM0QlMjBIZkFwaSgpJTBBJTBBJTIwJTIwJTIwJTIzJTIwQ3JlYXRlJTIwcmVwbyUyMGlmJTIwbm90JTIwZXhpc3RpbmclMjB5ZXQlMjBhbmQlMjBnZXQlMjB0aGUlMjBhc3NvY2lhdGVkJTIwcmVwb19pZCUwQSUyMCUyMCUyMHJlcG9faWQlMjAlM0QlMjBhcGkuY3JlYXRlX3JlcG8ocmVwb19uYW1lJTJDJTIwZXhpc3Rfb2slM0RUcnVlKSUwQSUwQSUyMCUyMCUyMCUyMyUyMFNhdmUlMjBhbGwlMjBmaWxlcyUyMGluJTIwYSUyMHRlbXBvcmFyeSUyMGRpcmVjdG9yeSUyMGFuZCUyMHB1c2glMjB0aGVtJTIwaW4lMjBhJTIwc2luZ2xlJTIwY29tbWl0JTBBJTIwJTIwJTIwd2l0aCUyMFRlbXBvcmFyeURpcmVjdG9yeSgpJTIwYXMlMjB0bXBkaXIlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjB0bXBkaXIlMjAlM0QlMjBQYXRoKHRtcGRpciklMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBTYXZlJTIwd2VpZ2h0cyUwQSUyMCUyMCUyMCUyMCUyMCUyMHNhdmVfbW9kZWwobW9kZWwlMkMlMjB0bXBkaXIlMjAlMkYlMjAlMjJtb2RlbC5zYWZldGVuc29ycyUyMiklMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBHZW5lcmF0ZSUyMG1vZGVsJTIwY2FyZCUwQSUyMCUyMCUyMCUyMCUyMCUyMGNhcmQlMjAlM0QlMjBnZW5lcmF0ZV9tb2RlbF9jYXJkKG1vZGVsKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCh0bXBkaXIlMjAlMkYlMjAlMjJSRUFETUUubWQlMjIpLndyaXRlX3RleHQoY2FyZCklMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBTYXZlJTIwbG9ncyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMFNhdmUlMjBmaWd1cmVzJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwU2F2ZSUyMGV2YWx1YXRpb24lMjBtZXRyaWNzJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwLi4uJTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwUHVzaCUyMHRvJTIwaHViJTBBJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwYXBpLnVwbG9hZF9mb2xkZXIocmVwb19pZCUzRHJlcG9faWQlMkMlMjBmb2xkZXJfcGF0aCUzRHRtcGRpcik=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">push_to_hub</span>(<span class="hljs-params">model: MyModelClass, repo_name: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-literal">None</span>:
   api = HfApi()

   <span class="hljs-comment"># Create repo if not existing yet and get the associated repo_id</span>
   repo_id = api.create_repo(repo_name, exist_ok=<span class="hljs-literal">True</span>)

   <span class="hljs-comment"># Save all files in a temporary directory and push them in a single commit</span>
   <span class="hljs-keyword">with</span> TemporaryDirectory() <span class="hljs-keyword">as</span> tmpdir:
      tmpdir = Path(tmpdir)

      <span class="hljs-comment"># Save weights</span>
      save_model(model, tmpdir / <span class="hljs-string">&quot;model.safetensors&quot;</span>)

      <span class="hljs-comment"># Generate model card</span>
      card = generate_model_card(model)
      (tmpdir / <span class="hljs-string">&quot;README.md&quot;</span>).write_text(card)

      <span class="hljs-comment"># Save logs</span>
      <span class="hljs-comment"># Save figures</span>
      <span class="hljs-comment"># Save evaluation metrics</span>
      <span class="hljs-comment"># ...</span>

      <span class="hljs-comment"># Push to hub</span>
      <span class="hljs-keyword">return</span> api.upload_folder(repo_id=repo_id, folder_path=tmpdir)`,wrap:!1}}),W=new u({props:{title:"Limitations",local:"limitations",headingTag:"h3"}}),$=new u({props:{title:"A more complex approach: class inheritance",local:"a-more-complex-approach-class-inheritance",headingTag:"h2"}}),z=new u({props:{title:"A concrete example: PyTorch",local:"a-concrete-example-pytorch",headingTag:"h3"}}),P=new u({props:{title:"How to use it?",local:"how-to-use-it",headingTag:"h4"}}),K=new y({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch.nn <span class="hljs-keyword">as</span> nn
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> PyTorchModelHubMixin


<span class="hljs-comment"># Define your Pytorch model exactly the same way you are used to</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">class</span> <span class="hljs-title class_">MyModel</span>(
<span class="hljs-meta">... </span>        nn.Module,
<span class="hljs-meta">... </span>        PyTorchModelHubMixin, <span class="hljs-comment"># multiple inheritance</span>
<span class="hljs-meta">... </span>        library_name=<span class="hljs-string">&quot;keras-nlp&quot;</span>,
<span class="hljs-meta">... </span>        tags=[<span class="hljs-string">&quot;keras&quot;</span>],
<span class="hljs-meta">... </span>        repo_url=<span class="hljs-string">&quot;https://github.com/keras-team/keras-nlp&quot;</span>,
<span class="hljs-meta">... </span>        docs_url=<span class="hljs-string">&quot;https://keras.io/keras_nlp/&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-comment"># ^ optional metadata to generate model card</span>
<span class="hljs-meta">... </span>    ):
<span class="hljs-meta">... </span>    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, hidden_size: <span class="hljs-built_in">int</span> = <span class="hljs-number">512</span>, vocab_size: <span class="hljs-built_in">int</span> = <span class="hljs-number">30000</span>, output_size: <span class="hljs-built_in">int</span> = <span class="hljs-number">4</span></span>):
<span class="hljs-meta">... </span>        <span class="hljs-built_in">super</span>().__init__()
<span class="hljs-meta">... </span>        self.param = nn.Parameter(torch.rand(hidden_size, vocab_size))
<span class="hljs-meta">... </span>        self.linear = nn.Linear(output_size, vocab_size)

<span class="hljs-meta">... </span>    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, x</span>):
<span class="hljs-meta">... </span>        <span class="hljs-keyword">return</span> self.linear(x + self.param)

<span class="hljs-comment"># 1. Create model</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MyModel(hidden_size=<span class="hljs-number">128</span>)

<span class="hljs-comment"># Config is automatically created based on input + default values</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model.param.shape[<span class="hljs-number">0</span>]
<span class="hljs-number">128</span>

<span class="hljs-comment"># 2. (optional) Save model to local directory</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model.save_pretrained(<span class="hljs-string">&quot;path/to/my-awesome-model&quot;</span>)

<span class="hljs-comment"># 3. Push model weights to the Hub</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model.push_to_hub(<span class="hljs-string">&quot;my-awesome-model&quot;</span>)

<span class="hljs-comment"># 4. Initialize model from the Hub =&gt; config has been preserved</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MyModel.from_pretrained(<span class="hljs-string">&quot;username/my-awesome-model&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.param.shape[<span class="hljs-number">0</span>]
<span class="hljs-number">128</span>

<span class="hljs-comment"># Model card has been correctly populated</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> ModelCard
<span class="hljs-meta">&gt;&gt;&gt; </span>card = ModelCard.load(<span class="hljs-string">&quot;username/my-awesome-model&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>card.data.tags
[<span class="hljs-string">&quot;keras&quot;</span>, <span class="hljs-string">&quot;pytorch_model_hub_mixin&quot;</span>, <span class="hljs-string">&quot;model_hub_mixin&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>card.data.library_name
<span class="hljs-string">&quot;keras-nlp&quot;</span>`,wrap:!1}}),O=new u({props:{title:"Implementation",local:"implementation",headingTag:"h4"}}),te=new y({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyME1vZGVsSHViTWl4aW4lMEElMEFjbGFzcyUyMFB5VG9yY2hNb2RlbEh1Yk1peGluKE1vZGVsSHViTWl4aW4pJTNBJTBBJTIwJTIwJTIwKC4uLik=",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> ModelHubMixin

<span class="hljs-keyword">class</span> <span class="hljs-title class_">PyTorchModelHubMixin</span>(<span class="hljs-title class_ inherited__">ModelHubMixin</span>):
   (...)`,wrap:!1}}),ae=new y({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyME1vZGVsSHViTWl4aW4lMEElMEFjbGFzcyUyMFB5VG9yY2hNb2RlbEh1Yk1peGluKE1vZGVsSHViTWl4aW4pJTNBJTBBJTIwJTIwJTIwKC4uLiklMEElMEElMjAlMjAlMjAlMjBkZWYlMjBfc2F2ZV9wcmV0cmFpbmVkKHNlbGYlMkMlMjBzYXZlX2RpcmVjdG9yeSUzQSUyMFBhdGgpJTIwLSUzRSUyME5vbmUlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjIlMjIlMjJTYXZlJTIwd2VpZ2h0cyUyMGZyb20lMjBhJTIwUHl0b3JjaCUyMG1vZGVsJTIwdG8lMjBhJTIwbG9jYWwlMjBkaXJlY3RvcnkuJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2F2ZV9tb2RlbF9hc19zYWZldGVuc29yKHNlbGYubW9kdWxlJTJDJTIwc3RyKHNhdmVfZGlyZWN0b3J5JTIwJTJGJTIwU0FGRVRFTlNPUlNfU0lOR0xFX0ZJTEUpKSUwQQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> ModelHubMixin

<span class="hljs-keyword">class</span> <span class="hljs-title class_">PyTorchModelHubMixin</span>(<span class="hljs-title class_ inherited__">ModelHubMixin</span>):
   (...)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">_save_pretrained</span>(<span class="hljs-params">self, save_directory: Path</span>) -&gt; <span class="hljs-literal">None</span>:
        <span class="hljs-string">&quot;&quot;&quot;Save weights from a Pytorch model to a local directory.&quot;&quot;&quot;</span>
        save_model_as_safetensor(self.module, <span class="hljs-built_in">str</span>(save_directory / SAFETENSORS_SINGLE_FILE))
`,wrap:!1}}),se=new y({props:{code:"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",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">PyTorchModelHubMixin</span>(<span class="hljs-title class_ inherited__">ModelHubMixin</span>):
   (...)

<span class="hljs-meta">   @classmethod </span><span class="hljs-comment"># Must be a classmethod!</span>
   <span class="hljs-keyword">def</span> <span class="hljs-title function_">_from_pretrained</span>(<span class="hljs-params">
      cls,
      *,
      model_id: <span class="hljs-built_in">str</span>,
      revision: <span class="hljs-built_in">str</span>,
      cache_dir: <span class="hljs-built_in">str</span>,
      force_download: <span class="hljs-built_in">bool</span>,
      proxies: <span class="hljs-type">Optional</span>[<span class="hljs-type">Dict</span>],
      resume_download: <span class="hljs-built_in">bool</span>,
      local_files_only: <span class="hljs-built_in">bool</span>,
      token: <span class="hljs-type">Union</span>[<span class="hljs-built_in">str</span>, <span class="hljs-built_in">bool</span>, <span class="hljs-literal">None</span>],
      map_location: <span class="hljs-built_in">str</span> = <span class="hljs-string">&quot;cpu&quot;</span>, <span class="hljs-comment"># additional argument</span>
      strict: <span class="hljs-built_in">bool</span> = <span class="hljs-literal">False</span>, <span class="hljs-comment"># additional argument</span>
      **model_kwargs,
   </span>):
      <span class="hljs-string">&quot;&quot;&quot;Load Pytorch pretrained weights and return the loaded model.&quot;&quot;&quot;</span>
        model = cls(**model_kwargs)
        <span class="hljs-keyword">if</span> os.path.isdir(model_id):
            <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Loading weights from local directory&quot;</span>)
            model_file = os.path.join(model_id, SAFETENSORS_SINGLE_FILE)
            <span class="hljs-keyword">return</span> cls._load_as_safetensor(model, model_file, map_location, strict)

         model_file = hf_hub_download(
            repo_id=model_id,
            filename=SAFETENSORS_SINGLE_FILE,
            revision=revision,
            cache_dir=cache_dir,
            force_download=force_download,
            proxies=proxies,
            resume_download=resume_download,
            token=token,
            local_files_only=local_files_only,
            )
         <span class="hljs-keyword">return</span> cls._load_as_safetensor(model, model_file, map_location, strict)`,wrap:!1}}),ie=new u({props:{title:"Advanced usage",local:"advanced-usage",headingTag:"h3"}}),Me=new u({props:{title:"Model card",local:"model-card",headingTag:"h4"}}),ce=new y({props:{code:"Y2xhc3MlMjBVbmlEZXB0aFYxKCUwQSUyMCUyMCUyMG5uLk1vZHVsZSUyQyUwQSUyMCUyMCUyMFB5VG9yY2hNb2RlbEh1Yk1peGluJTJDJTBBJTIwJTIwJTIwbGlicmFyeV9uYW1lJTNEJTIydW5pZGVwdGglMjIlMkMlMEElMjAlMjAlMjByZXBvX3VybCUzRCUyMmh0dHBzJTNBJTJGJTJGZ2l0aHViLmNvbSUyRmxwaWNjaW5lbGxpLWV0aCUyRlVuaURlcHRoJTIyJTJDJTBBJTIwJTIwJTIwZG9jc191cmwlM0QuLi4lMkMlMEElMjAlMjAlMjBwaXBlbGluZV90YWclM0QlMjJkZXB0aC1lc3RpbWF0aW9uJTIyJTJDJTBBJTIwJTIwJTIwbGljZW5zZSUzRCUyMmNjLWJ5LW5jLTQuMCUyMiUyQyUwQSUyMCUyMCUyMHRhZ3MlM0QlNUIlMjJtb25vY3VsYXItbWV0cmljLWRlcHRoLWVzdGltYXRpb24lMjIlMkMlMjAlMjJhcnhpdiUzQTEyMzQuNTY3ODklMjIlNUQlMEEpJTNBJTBBJTIwJTIwJTIwLi4u",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">UniDepthV1</span>(
   nn.Module,
   PyTorchModelHubMixin,
   library_name=<span class="hljs-string">&quot;unidepth&quot;</span>,
   repo_url=<span class="hljs-string">&quot;https://github.com/lpiccinelli-eth/UniDepth&quot;</span>,
   docs_url=...,
   pipeline_tag=<span class="hljs-string">&quot;depth-estimation&quot;</span>,
   license=<span class="hljs-string">&quot;cc-by-nc-4.0&quot;</span>,
   tags=[<span class="hljs-string">&quot;monocular-metric-depth-estimation&quot;</span>, <span class="hljs-string">&quot;arxiv:1234.56789&quot;</span>]
):
   ...`,wrap:!1}}),me=new y({props:{code:"TU9ERUxfQ0FSRF9URU1QTEFURSUyMCUzRCUyMCUyMiUyMiUyMiUwQS0tLSUwQSUyMyUyMEZvciUyMHJlZmVyZW5jZSUyMG9uJTIwbW9kZWwlMjBjYXJkJTIwbWV0YWRhdGElMkMlMjBzZWUlMjB0aGUlMjBzcGVjJTNBJTIwaHR0cHMlM0ElMkYlMkZnaXRodWIuY29tJTJGaHVnZ2luZ2ZhY2UlMkZodWItZG9jcyUyRmJsb2IlMkZtYWluJTJGbW9kZWxjYXJkLm1kJTNGcGxhaW4lM0QxJTBBJTIzJTIwRG9jJTIwJTJGJTIwZ3VpZGUlM0ElMjBodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZG9jcyUyRmh1YiUyRm1vZGVsLWNhcmRzJTBBJTdCJTdCJTIwY2FyZF9kYXRhJTIwJTdEJTdEJTBBLS0tJTBBJTBBVGhpcyUyMGlzJTIwYSUyMFZvaWNlQ3JhZnQlMjBtb2RlbC4lMjBGb3IlMjBtb3JlJTIwZGV0YWlscyUyQyUyMHBsZWFzZSUyMGNoZWNrJTIwb3V0JTIwdGhlJTIwb2ZmaWNpYWwlMjBHaXRodWIlMjByZXBvJTNBJTIwaHR0cHMlM0ElMkYlMkZnaXRodWIuY29tJTJGamFzb25wcHklMkZWb2ljZUNyYWZ0LiUyMFRoaXMlMjBtb2RlbCUyMGlzJTIwc2hhcmVkJTIwdW5kZXIlMjBhJTIwQXR0cmlidXRpb24tTm9uQ29tbWVyY2lhbC1TaGFyZUFsaWtlJTIwNC4wJTIwSW50ZXJuYXRpb25hbCUyMGxpY2Vuc2UuJTBBJTBBJTIzJTIzJTIwQ2l0YXRpb24lMEElMEElNDBhcnRpY2xlJTdCcGVuZzIwMjR2b2ljZWNyYWZ0JTJDJTBBJTIwJTIwYXV0aG9yJTIwJTIwJTIwJTIwJTNEJTIwJTdCUGVuZyUyQyUyMFB1eXVhbiUyMGFuZCUyMEh1YW5nJTJDJTIwUG8tWWFvJTIwYW5kJTIwTGklMkMlMjBEYW5pZWwlMjBhbmQlMjBNb2hhbWVkJTJDJTIwQWJkZWxyYWhtYW4lMjBhbmQlMjBIYXJ3YXRoJTJDJTIwRGF2aWQlN0QlMkMlMEElMjAlMjB0aXRsZSUyMCUyMCUyMCUyMCUyMCUzRCUyMCU3QlZvaWNlQ3JhZnQlM0ElMjBaZXJvLVNob3QlMjBTcGVlY2glMjBFZGl0aW5nJTIwYW5kJTIwVGV4dC10by1TcGVlY2glMjBpbiUyMHRoZSUyMFdpbGQlN0QlMkMlMEElMjAlMjBqb3VybmFsJTIwJTIwJTIwJTNEJTIwJTdCYXJYaXYlN0QlMkMlMEElMjAlMjB5ZWFyJTIwJTIwJTIwJTIwJTIwJTIwJTNEJTIwJTdCMjAyNCU3RCUyQyUwQSU3RCUwQSUyMiUyMiUyMiUwQSUwQWNsYXNzJTIwVm9pY2VDcmFmdCglMEElMjAlMjAlMjBubi5Nb2R1bGUlMkMlMEElMjAlMjAlMjBQeVRvcmNoTW9kZWxIdWJNaXhpbiUyQyUwQSUyMCUyMCUyMGxpYnJhcnlfbmFtZSUzRCUyMnZvaWNlY3JhZnQlMjIlMkMlMEElMjAlMjAlMjBtb2RlbF9jYXJkX3RlbXBsYXRlJTNETU9ERUxfQ0FSRF9URU1QTEFURSUyQyUwQSUyMCUyMCUyMC4uLiUwQSklM0ElMEElMjAlMjAlMjAuLi4=",highlighted:`MODEL_CARD_TEMPLATE = <span class="hljs-string">&quot;&quot;&quot;
---
# For reference on model card metadata, see the spec: https://github.com/huggingface/hub-docs/blob/main/modelcard.md?plain=1
# Doc / guide: https://huggingface.co/docs/hub/model-cards
{{ card_data }}
---

This is a VoiceCraft model. For more details, please check out the official Github repo: https://github.com/jasonppy/VoiceCraft. This model is shared under a Attribution-NonCommercial-ShareAlike 4.0 International license.

## Citation

@article{peng2024voicecraft,
  author    = {Peng, Puyuan and Huang, Po-Yao and Li, Daniel and Mohamed, Abdelrahman and Harwath, David},
  title     = {VoiceCraft: Zero-Shot Speech Editing and Text-to-Speech in the Wild},
  journal   = {arXiv},
  year      = {2024},
}
&quot;&quot;&quot;</span>

<span class="hljs-keyword">class</span> <span class="hljs-title class_">VoiceCraft</span>(
   nn.Module,
   PyTorchModelHubMixin,
   library_name=<span class="hljs-string">&quot;voicecraft&quot;</span>,
   model_card_template=MODEL_CARD_TEMPLATE,
   ...
):
   ...`,wrap:!1}}),ye=new y({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyME1vZGVsQ2FyZCUyQyUyMFB5VG9yY2hNb2RlbEh1Yk1peGluJTBBJTBBY2xhc3MlMjBVbmlEZXB0aFYxKG5uLk1vZHVsZSUyQyUyMFB5VG9yY2hNb2RlbEh1Yk1peGluJTJDJTIwLi4uKSUzQSUwQSUyMCUyMCUyMCguLi4pJTBBJTBBJTIwJTIwJTIwZGVmJTIwZ2VuZXJhdGVfbW9kZWxfY2FyZChzZWxmJTJDJTIwKmFyZ3MlMkMlMjAqKmt3YXJncyklMjAtJTNFJTIwTW9kZWxDYXJkJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwY2FyZCUyMCUzRCUyMHN1cGVyKCkuZ2VuZXJhdGVfbW9kZWxfY2FyZCgqYXJncyUyQyUyMCoqa3dhcmdzKSUwQSUyMCUyMCUyMCUyMCUyMCUyMGNhcmQuZGF0YS5tZXRyaWNzJTIwJTNEJTIwLi4uJTIwJTIwJTIzJTIwYWRkJTIwbWV0cmljcyUyMHRvJTIwdGhlJTIwbWV0YWRhdGElMEElMjAlMjAlMjAlMjAlMjAlMjBjYXJkLnRleHQlMjAlMkIlM0QlMjAuLi4lMjAlMjMlMjBhcHBlbmQlMjBzZWN0aW9uJTIwdG8lMjB0aGUlMjBtb2RlbGNhcmQlMEElMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjBjYXJk",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> ModelCard, PyTorchModelHubMixin

<span class="hljs-keyword">class</span> <span class="hljs-title class_">UniDepthV1</span>(nn.Module, PyTorchModelHubMixin, ...):
   (...)

   <span class="hljs-keyword">def</span> <span class="hljs-title function_">generate_model_card</span>(<span class="hljs-params">self, *args, **kwargs</span>) -&gt; ModelCard:
      card = <span class="hljs-built_in">super</span>().generate_model_card(*args, **kwargs)
      card.data.metrics = ...  <span class="hljs-comment"># add metrics to the metadata</span>
      card.text += ... <span class="hljs-comment"># append section to the modelcard</span>
      <span class="hljs-keyword">return</span> card`,wrap:!1}}),we=new u({props:{title:"Config",local:"config",headingTag:"h4"}}),Ue=new y({props:{code:"Y2xhc3MlMjBNeU1vZGVsKE1vZGVsSHViTWl4aW4pJTNBJTBBJTIwJTIwJTIwZGVmJTIwX19pbml0X18odmFsdWUlM0ElMjBzdHIlMkMlMjBzaXplJTNBJTIwaW50JTIwJTNEJTIwMyklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjBzZWxmLnZhbHVlJTIwJTNEJTIwdmFsdWUlMEElMjAlMjAlMjAlMjAlMjAlMjBzZWxmLnNpemUlMjAlM0QlMjBzaXplJTBBJTBBJTIwJTIwJTIwKC4uLiklMjAlMjMlMjBpbXBsZW1lbnQlMjBfc2F2ZV9wcmV0cmFpbmVkJTIwJTJGJTIwX2Zyb21fcHJldHJhaW5lZCUwQSUwQW1vZGVsJTIwJTNEJTIwTXlNb2RlbCh2YWx1ZSUzRCUyMm15X3ZhbHVlJTIyKSUwQW1vZGVsLnNhdmVfcHJldHJhaW5lZCguLi4pJTBBJTBBJTIzJTIwY29uZmlnLmpzb24lMjBjb250YWlucyUyMHBhc3NlZCUyMGFuZCUyMGRlZmF1bHQlMjB2YWx1ZXMlMEElN0IlMjJ2YWx1ZSUyMiUzQSUyMCUyMm15X3ZhbHVlJTIyJTJDJTIwJTIyc2l6ZSUyMiUzQSUyMDMlN0Q=",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">MyModel</span>(<span class="hljs-title class_ inherited__">ModelHubMixin</span>):
   <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">value: <span class="hljs-built_in">str</span>, size: <span class="hljs-built_in">int</span> = <span class="hljs-number">3</span></span>):
      self.value = value
      self.size = size

   (...) <span class="hljs-comment"># implement _save_pretrained / _from_pretrained</span>

model = MyModel(value=<span class="hljs-string">&quot;my_value&quot;</span>)
model.save_pretrained(...)

<span class="hljs-comment"># config.json contains passed and default values</span>
{<span class="hljs-string">&quot;value&quot;</span>: <span class="hljs-string">&quot;my_value&quot;</span>, <span class="hljs-string">&quot;size&quot;</span>: <span class="hljs-number">3</span>}`,wrap:!1}}),_e=new y({props:{code:"Y2xhc3MlMjBWb2ljZUNyYWZ0KG5uLk1vZHVsZSklM0ElMEElMjAlMjAlMjAlMjBkZWYlMjBfX2luaXRfXyhzZWxmJTJDJTIwYXJncyklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjBzZWxmLnBhdHRlcm4lMjAlM0QlMjBzZWxmLmFyZ3MucGF0dGVybiUwQSUyMCUyMCUyMCUyMCUyMCUyMHNlbGYuaGlkZGVuX3NpemUlMjAlM0QlMjBzZWxmLmFyZ3MuaGlkZGVuX3NpemUlMEElMjAlMjAlMjAlMjAlMjAlMjAuLi4=",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">VoiceCraft</span>(nn.Module):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, args</span>):
      self.pattern = self.args.pattern
      self.hidden_size = self.args.hidden_size
      ...`,wrap:!1}}),Be=new y({props:{code:"ZnJvbSUyMGFyZ3BhcnNlJTIwaW1wb3J0JTIwTmFtZXNwYWNlJTBBJTBBY2xhc3MlMjBWb2ljZUNyYWZ0KCUwQSUyMCUyMCUyMG5uLk1vZHVsZSUyQyUwQSUyMCUyMCUyMFB5VG9yY2hNb2RlbEh1Yk1peGluJTJDJTIwJTIwJTIzJTIwaW5oZXJpdCUyMGZyb20lMjBtaXhpbiUwQSUyMCUyMCUyMGNvZGVycyUzRCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyME5hbWVzcGFjZSUyMCUzQSUyMCglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsYW1iZGElMjB4JTNBJTIwdmFycyh4KSUyQyUyMCUyMCUyMyUyMEVuY29kZXIlM0ElMjBob3clMjB0byUyMGNvbnZlcnQlMjBhJTIwJTYwTmFtZXNwYWNlJTYwJTIwdG8lMjBhJTIwdmFsaWQlMjBqc29uYWJsZSUyMHZhbHVlJTNGJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbGFtYmRhJTIwZGF0YSUzQSUyME5hbWVzcGFjZSgqKmRhdGEpJTJDJTIwJTIwJTIzJTIwRGVjb2RlciUzQSUyMGhvdyUyMHRvJTIwcmVjb25zdHJ1Y3QlMjBhJTIwJTYwTmFtZXNwYWNlJTYwJTIwZnJvbSUyMGElMjBkaWN0aW9uYXJ5JTNGJTBBJTIwJTIwJTIwJTIwJTIwJTIwKSUwQSUyMCUyMCUyMCU3RCUwQSklM0ElMEElMjAlMjAlMjAlMjBkZWYlMjBfX2luaXRfXyhzZWxmJTJDJTIwYXJncyUzQSUyME5hbWVzcGFjZSklM0ElMjAlMjMlMjBhbm5vdGF0ZSUyMCU2MGFyZ3MlNjAlMEElMjAlMjAlMjAlMjAlMjAlMjBzZWxmLnBhdHRlcm4lMjAlM0QlMjBzZWxmLmFyZ3MucGF0dGVybiUwQSUyMCUyMCUyMCUyMCUyMCUyMHNlbGYuaGlkZGVuX3NpemUlMjAlM0QlMjBzZWxmLmFyZ3MuaGlkZGVuX3NpemUlMEElMjAlMjAlMjAlMjAlMjAlMjAuLi4=",highlighted:`<span class="hljs-keyword">from</span> argparse <span class="hljs-keyword">import</span> Namespace

<span class="hljs-keyword">class</span> <span class="hljs-title class_">VoiceCraft</span>(
   nn.Module,
   PyTorchModelHubMixin,  <span class="hljs-comment"># inherit from mixin</span>
   coders={
      Namespace : (
         <span class="hljs-keyword">lambda</span> x: <span class="hljs-built_in">vars</span>(x),  <span class="hljs-comment"># Encoder: how to convert a \`Namespace\` to a valid jsonable value?</span>
         <span class="hljs-keyword">lambda</span> data: Namespace(**data),  <span class="hljs-comment"># Decoder: how to reconstruct a \`Namespace\` from a dictionary?</span>
      )
   }
):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, args: Namespace</span>): <span class="hljs-comment"># annotate \`args\`</span>
      self.pattern = self.args.pattern
      self.hidden_size = self.args.hidden_size
      ...`,wrap:!1}}),xe=new u({props:{title:"Quick comparison",local:"quick-comparison",headingTag:"h2"}}),We=new pa({props:{source:"https://github.com/huggingface/huggingface_hub/blob/main/docs/source/en/guides/integrations.md"}}),{c(){w=i("meta"),Qe=s(),Ee=i("p"),Ve=s(),r(J.$$.fragment),Xe=s(),b=i("p"),b.innerHTML=rt,$e=s(),f=i("p"),f.textContent=pt,Re=s(),U=i("ol"),U.innerHTML=ct,Ne=s(),g=i("p"),g.textContent=dt,Se=s(),I=i("p"),I.innerHTML=ht,Fe=s(),r(_.$$.fragment),Le=s(),C=i("p"),C.innerHTML=mt,ze=s(),Z=i("p"),Z.textContent=ut,qe=s(),r(B.$$.fragment),Pe=s(),v=i("p"),v.innerHTML=yt,De=s(),r(k.$$.fragment),Ke=s(),r(A.$$.fragment),Oe=s(),x=i("p"),x.innerHTML=wt,el=s(),r(G.$$.fragment),ll=s(),H=i("p"),H.innerHTML=Tt,tl=s(),r(W.$$.fragment),al=s(),E=i("p"),E.innerHTML=jt,sl=s(),Y=i("ul"),Y.innerHTML=Jt,nl=s(),Q=i("p"),Q.textContent=bt,il=s(),V=i("ul"),V.innerHTML=ft,ol=s(),X=i("p"),X.innerHTML=Ut,Ml=s(),r($.$$.fragment),rl=s(),R=i("p"),R.innerHTML=gt,pl=s(),N=i("p"),N.innerHTML=It,cl=s(),S=i("p"),S.innerHTML=_t,dl=s(),F=i("ol"),F.innerHTML=Ct,hl=s(),L=i("p"),L.innerHTML=Zt,ml=s(),r(z.$$.fragment),ul=s(),q=i("p"),q.innerHTML=Bt,yl=s(),r(P.$$.fragment),wl=s(),D=i("p"),D.textContent=vt,Tl=s(),r(K.$$.fragment),jl=s(),r(O.$$.fragment),Jl=s(),ee=i("p"),ee.innerHTML=kt,bl=s(),le=i("ol"),le.innerHTML=At,fl=s(),r(te.$$.fragment),Ul=s(),T=i("ol"),T.innerHTML=xt,gl=s(),r(ae.$$.fragment),Il=s(),j=i("ol"),j.innerHTML=Gt,_l=s(),r(se.$$.fragment),Cl=s(),ne=i("p"),ne.textContent=Ht,Zl=s(),r(ie.$$.fragment),Bl=s(),oe=i("p"),oe.innerHTML=Wt,vl=s(),r(Me.$$.fragment),kl=s(),re=i("p"),re.innerHTML=Et,Al=s(),pe=i("p"),pe.innerHTML=Yt,xl=s(),r(ce.$$.fragment),Gl=s(),de=i("p"),de.innerHTML=Qt,Hl=s(),he=i("p"),he.innerHTML=Vt,Wl=s(),r(me.$$.fragment),El=s(),ue=i("p"),ue.innerHTML=Xt,Yl=s(),r(ye.$$.fragment),Ql=s(),r(we.$$.fragment),Vl=s(),Te=i("p"),Te.innerHTML=$t,Xl=s(),je=i("ol"),je.innerHTML=Rt,$l=s(),Je=i("p"),Je.textContent=Nt,Rl=s(),be=i("ul"),be.innerHTML=St,Nl=s(),fe=i("p"),fe.textContent=Ft,Sl=s(),r(Ue.$$.fragment),Fl=s(),ge=i("p"),ge.innerHTML=Lt,Ll=s(),Ie=i("p"),Ie.innerHTML=zt,zl=s(),r(_e.$$.fragment),ql=s(),Ce=i("p"),Ce.innerHTML=qt,Pl=s(),Ze=i("p"),Ze.innerHTML=Pt,Dl=s(),r(Be.$$.fragment),Kl=s(),ve=i("p"),ve.innerHTML=Dt,Ol=s(),ke=i("ol"),ke.innerHTML=Kt,et=s(),Ae=i("p"),Ae.textContent=Ot,lt=s(),r(xe.$$.fragment),tt=s(),Ge=i("p"),Ge.textContent=ea,at=s(),He=i("table"),He.innerHTML=la,st=s(),r(We.$$.fragment),nt=s(),Ye=i("p"),this.h()},l(e){const l=Ma("svelte-u9bgzb",document.head);w=o(l,"META",{name:!0,content:!0}),l.forEach(t),Qe=n(e),Ee=o(e,"P",{}),ta(Ee).forEach(t),Ve=n(e),p(J.$$.fragment,e),Xe=n(e),b=o(e,"P",{"data-svelte-h":!0}),M(b)!=="svelte-uvt37o"&&(b.innerHTML=rt),$e=n(e),f=o(e,"P",{"data-svelte-h":!0}),M(f)!=="svelte-14vdlq5"&&(f.textContent=pt),Re=n(e),U=o(e,"OL",{"data-svelte-h":!0}),M(U)!=="svelte-14btp4x"&&(U.innerHTML=ct),Ne=n(e),g=o(e,"P",{"data-svelte-h":!0}),M(g)!=="svelte-1tx4sul"&&(g.textContent=dt),Se=n(e),I=o(e,"P",{"data-svelte-h":!0}),M(I)!=="svelte-10f3yyh"&&(I.innerHTML=ht),Fe=n(e),p(_.$$.fragment,e),Le=n(e),C=o(e,"P",{"data-svelte-h":!0}),M(C)!=="svelte-1li5ftr"&&(C.innerHTML=mt),ze=n(e),Z=o(e,"P",{"data-svelte-h":!0}),M(Z)!=="svelte-1g2giur"&&(Z.textContent=ut),qe=n(e),p(B.$$.fragment,e),Pe=n(e),v=o(e,"P",{"data-svelte-h":!0}),M(v)!=="svelte-bozc1x"&&(v.innerHTML=yt),De=n(e),p(k.$$.fragment,e),Ke=n(e),p(A.$$.fragment,e),Oe=n(e),x=o(e,"P",{"data-svelte-h":!0}),M(x)!=="svelte-7bmo7d"&&(x.innerHTML=wt),el=n(e),p(G.$$.fragment,e),ll=n(e),H=o(e,"P",{"data-svelte-h":!0}),M(H)!=="svelte-15vgu12"&&(H.innerHTML=Tt),tl=n(e),p(W.$$.fragment,e),al=n(e),E=o(e,"P",{"data-svelte-h":!0}),M(E)!=="svelte-tzwehq"&&(E.innerHTML=jt),sl=n(e),Y=o(e,"UL",{"data-svelte-h":!0}),M(Y)!=="svelte-1e4on1q"&&(Y.innerHTML=Jt),nl=n(e),Q=o(e,"P",{"data-svelte-h":!0}),M(Q)!=="svelte-3m9y73"&&(Q.textContent=bt),il=n(e),V=o(e,"UL",{"data-svelte-h":!0}),M(V)!=="svelte-30swpt"&&(V.innerHTML=ft),ol=n(e),X=o(e,"P",{"data-svelte-h":!0}),M(X)!=="svelte-p8rs76"&&(X.innerHTML=Ut),Ml=n(e),p($.$$.fragment,e),rl=n(e),R=o(e,"P",{"data-svelte-h":!0}),M(R)!=="svelte-1uvlinw"&&(R.innerHTML=gt),pl=n(e),N=o(e,"P",{"data-svelte-h":!0}),M(N)!=="svelte-m1n8vc"&&(N.innerHTML=It),cl=n(e),S=o(e,"P",{"data-svelte-h":!0}),M(S)!=="svelte-t33i5b"&&(S.innerHTML=_t),dl=n(e),F=o(e,"OL",{"data-svelte-h":!0}),M(F)!=="svelte-7wmrrz"&&(F.innerHTML=Ct),hl=n(e),L=o(e,"P",{"data-svelte-h":!0}),M(L)!=="svelte-f3y8qu"&&(L.innerHTML=Zt),ml=n(e),p(z.$$.fragment,e),ul=n(e),q=o(e,"P",{"data-svelte-h":!0}),M(q)!=="svelte-kkf5f0"&&(q.innerHTML=Bt),yl=n(e),p(P.$$.fragment,e),wl=n(e),D=o(e,"P",{"data-svelte-h":!0}),M(D)!=="svelte-l2ktl8"&&(D.textContent=vt),Tl=n(e),p(K.$$.fragment,e),jl=n(e),p(O.$$.fragment,e),Jl=n(e),ee=o(e,"P",{"data-svelte-h":!0}),M(ee)!=="svelte-l2iz9k"&&(ee.innerHTML=kt),bl=n(e),le=o(e,"OL",{"data-svelte-h":!0}),M(le)!=="svelte-1a9vqht"&&(le.innerHTML=At),fl=n(e),p(te.$$.fragment,e),Ul=n(e),T=o(e,"OL",{start:!0,"data-svelte-h":!0}),M(T)!=="svelte-mclxy5"&&(T.innerHTML=xt),gl=n(e),p(ae.$$.fragment,e),Il=n(e),j=o(e,"OL",{start:!0,"data-svelte-h":!0}),M(j)!=="svelte-1vfuaub"&&(j.innerHTML=Gt),_l=n(e),p(se.$$.fragment,e),Cl=n(e),ne=o(e,"P",{"data-svelte-h":!0}),M(ne)!=="svelte-zuw9zy"&&(ne.textContent=Ht),Zl=n(e),p(ie.$$.fragment,e),Bl=n(e),oe=o(e,"P",{"data-svelte-h":!0}),M(oe)!=="svelte-ixt3kj"&&(oe.innerHTML=Wt),vl=n(e),p(Me.$$.fragment,e),kl=n(e),re=o(e,"P",{"data-svelte-h":!0}),M(re)!=="svelte-etvdvf"&&(re.innerHTML=Et),Al=n(e),pe=o(e,"P",{"data-svelte-h":!0}),M(pe)!=="svelte-1gh166n"&&(pe.innerHTML=Yt),xl=n(e),p(ce.$$.fragment,e),Gl=n(e),de=o(e,"P",{"data-svelte-h":!0}),M(de)!=="svelte-70iys4"&&(de.innerHTML=Qt),Hl=n(e),he=o(e,"P",{"data-svelte-h":!0}),M(he)!=="svelte-zhkaso"&&(he.innerHTML=Vt),Wl=n(e),p(me.$$.fragment,e),El=n(e),ue=o(e,"P",{"data-svelte-h":!0}),M(ue)!=="svelte-1xgyqxt"&&(ue.innerHTML=Xt),Yl=n(e),p(ye.$$.fragment,e),Ql=n(e),p(we.$$.fragment,e),Vl=n(e),Te=o(e,"P",{"data-svelte-h":!0}),M(Te)!=="svelte-1cj9y8d"&&(Te.innerHTML=$t),Xl=n(e),je=o(e,"OL",{"data-svelte-h":!0}),M(je)!=="svelte-uqe2yy"&&(je.innerHTML=Rt),$l=n(e),Je=o(e,"P",{"data-svelte-h":!0}),M(Je)!=="svelte-gl8lj"&&(Je.textContent=Nt),Rl=n(e),be=o(e,"UL",{"data-svelte-h":!0}),M(be)!=="svelte-10x9zjy"&&(be.innerHTML=St),Nl=n(e),fe=o(e,"P",{"data-svelte-h":!0}),M(fe)!=="svelte-11lpom8"&&(fe.textContent=Ft),Sl=n(e),p(Ue.$$.fragment,e),Fl=n(e),ge=o(e,"P",{"data-svelte-h":!0}),M(ge)!=="svelte-1ebn16h"&&(ge.innerHTML=Lt),Ll=n(e),Ie=o(e,"P",{"data-svelte-h":!0}),M(Ie)!=="svelte-15vpqms"&&(Ie.innerHTML=zt),zl=n(e),p(_e.$$.fragment,e),ql=n(e),Ce=o(e,"P",{"data-svelte-h":!0}),M(Ce)!=="svelte-we37tw"&&(Ce.innerHTML=qt),Pl=n(e),Ze=o(e,"P",{"data-svelte-h":!0}),M(Ze)!=="svelte-1fs7jtp"&&(Ze.innerHTML=Pt),Dl=n(e),p(Be.$$.fragment,e),Kl=n(e),ve=o(e,"P",{"data-svelte-h":!0}),M(ve)!=="svelte-unlgl7"&&(ve.innerHTML=Dt),Ol=n(e),ke=o(e,"OL",{"data-svelte-h":!0}),M(ke)!=="svelte-10un21c"&&(ke.innerHTML=Kt),et=n(e),Ae=o(e,"P",{"data-svelte-h":!0}),M(Ae)!=="svelte-103pztm"&&(Ae.textContent=Ot),lt=n(e),p(xe.$$.fragment,e),tt=n(e),Ge=o(e,"P",{"data-svelte-h":!0}),M(Ge)!=="svelte-1qi11kl"&&(Ge.textContent=ea),at=n(e),He=o(e,"TABLE",{"data-svelte-h":!0}),M(He)!=="svelte-wec8b6"&&(He.innerHTML=la),st=n(e),p(We.$$.fragment,e),nt=n(e),Ye=o(e,"P",{}),ta(Ye).forEach(t),this.h()},h(){ot(w,"name","hf:doc:metadata"),ot(w,"content",da),ot(T,"start","2"),ot(j,"start","3")},m(e,l){ra(document.head,w),a(e,Qe,l),a(e,Ee,l),a(e,Ve,l),c(J,e,l),a(e,Xe,l),a(e,b,l),a(e,$e,l),a(e,f,l),a(e,Re,l),a(e,U,l),a(e,Ne,l),a(e,g,l),a(e,Se,l),a(e,I,l),a(e,Fe,l),c(_,e,l),a(e,Le,l),a(e,C,l),a(e,ze,l),a(e,Z,l),a(e,qe,l),c(B,e,l),a(e,Pe,l),a(e,v,l),a(e,De,l),c(k,e,l),a(e,Ke,l),c(A,e,l),a(e,Oe,l),a(e,x,l),a(e,el,l),c(G,e,l),a(e,ll,l),a(e,H,l),a(e,tl,l),c(W,e,l),a(e,al,l),a(e,E,l),a(e,sl,l),a(e,Y,l),a(e,nl,l),a(e,Q,l),a(e,il,l),a(e,V,l),a(e,ol,l),a(e,X,l),a(e,Ml,l),c($,e,l),a(e,rl,l),a(e,R,l),a(e,pl,l),a(e,N,l),a(e,cl,l),a(e,S,l),a(e,dl,l),a(e,F,l),a(e,hl,l),a(e,L,l),a(e,ml,l),c(z,e,l),a(e,ul,l),a(e,q,l),a(e,yl,l),c(P,e,l),a(e,wl,l),a(e,D,l),a(e,Tl,l),c(K,e,l),a(e,jl,l),c(O,e,l),a(e,Jl,l),a(e,ee,l),a(e,bl,l),a(e,le,l),a(e,fl,l),c(te,e,l),a(e,Ul,l),a(e,T,l),a(e,gl,l),c(ae,e,l),a(e,Il,l),a(e,j,l),a(e,_l,l),c(se,e,l),a(e,Cl,l),a(e,ne,l),a(e,Zl,l),c(ie,e,l),a(e,Bl,l),a(e,oe,l),a(e,vl,l),c(Me,e,l),a(e,kl,l),a(e,re,l),a(e,Al,l),a(e,pe,l),a(e,xl,l),c(ce,e,l),a(e,Gl,l),a(e,de,l),a(e,Hl,l),a(e,he,l),a(e,Wl,l),c(me,e,l),a(e,El,l),a(e,ue,l),a(e,Yl,l),c(ye,e,l),a(e,Ql,l),c(we,e,l),a(e,Vl,l),a(e,Te,l),a(e,Xl,l),a(e,je,l),a(e,$l,l),a(e,Je,l),a(e,Rl,l),a(e,be,l),a(e,Nl,l),a(e,fe,l),a(e,Sl,l),c(Ue,e,l),a(e,Fl,l),a(e,ge,l),a(e,Ll,l),a(e,Ie,l),a(e,zl,l),c(_e,e,l),a(e,ql,l),a(e,Ce,l),a(e,Pl,l),a(e,Ze,l),a(e,Dl,l),c(Be,e,l),a(e,Kl,l),a(e,ve,l),a(e,Ol,l),a(e,ke,l),a(e,et,l),a(e,Ae,l),a(e,lt,l),c(xe,e,l),a(e,tt,l),a(e,Ge,l),a(e,at,l),a(e,He,l),a(e,st,l),c(We,e,l),a(e,nt,l),a(e,Ye,l),it=!0},p:sa,i(e){it||(d(J.$$.fragment,e),d(_.$$.fragment,e),d(B.$$.fragment,e),d(k.$$.fragment,e),d(A.$$.fragment,e),d(G.$$.fragment,e),d(W.$$.fragment,e),d($.$$.fragment,e),d(z.$$.fragment,e),d(P.$$.fragment,e),d(K.$$.fragment,e),d(O.$$.fragment,e),d(te.$$.fragment,e),d(ae.$$.fragment,e),d(se.$$.fragment,e),d(ie.$$.fragment,e),d(Me.$$.fragment,e),d(ce.$$.fragment,e),d(me.$$.fragment,e),d(ye.$$.fragment,e),d(we.$$.fragment,e),d(Ue.$$.fragment,e),d(_e.$$.fragment,e),d(Be.$$.fragment,e),d(xe.$$.fragment,e),d(We.$$.fragment,e),it=!0)},o(e){h(J.$$.fragment,e),h(_.$$.fragment,e),h(B.$$.fragment,e),h(k.$$.fragment,e),h(A.$$.fragment,e),h(G.$$.fragment,e),h(W.$$.fragment,e),h($.$$.fragment,e),h(z.$$.fragment,e),h(P.$$.fragment,e),h(K.$$.fragment,e),h(O.$$.fragment,e),h(te.$$.fragment,e),h(ae.$$.fragment,e),h(se.$$.fragment,e),h(ie.$$.fragment,e),h(Me.$$.fragment,e),h(ce.$$.fragment,e),h(me.$$.fragment,e),h(ye.$$.fragment,e),h(we.$$.fragment,e),h(Ue.$$.fragment,e),h(_e.$$.fragment,e),h(Be.$$.fragment,e),h(xe.$$.fragment,e),h(We.$$.fragment,e),it=!1},d(e){e&&(t(Qe),t(Ee),t(Ve),t(Xe),t(b),t($e),t(f),t(Re),t(U),t(Ne),t(g),t(Se),t(I),t(Fe),t(Le),t(C),t(ze),t(Z),t(qe),t(Pe),t(v),t(De),t(Ke),t(Oe),t(x),t(el),t(ll),t(H),t(tl),t(al),t(E),t(sl),t(Y),t(nl),t(Q),t(il),t(V),t(ol),t(X),t(Ml),t(rl),t(R),t(pl),t(N),t(cl),t(S),t(dl),t(F),t(hl),t(L),t(ml),t(ul),t(q),t(yl),t(wl),t(D),t(Tl),t(jl),t(Jl),t(ee),t(bl),t(le),t(fl),t(Ul),t(T),t(gl),t(Il),t(j),t(_l),t(Cl),t(ne),t(Zl),t(Bl),t(oe),t(vl),t(kl),t(re),t(Al),t(pe),t(xl),t(Gl),t(de),t(Hl),t(he),t(Wl),t(El),t(ue),t(Yl),t(Ql),t(Vl),t(Te),t(Xl),t(je),t($l),t(Je),t(Rl),t(be),t(Nl),t(fe),t(Sl),t(Fl),t(ge),t(Ll),t(Ie),t(zl),t(ql),t(Ce),t(Pl),t(Ze),t(Dl),t(Kl),t(ve),t(Ol),t(ke),t(et),t(Ae),t(lt),t(tt),t(Ge),t(at),t(He),t(st),t(nt),t(Ye)),t(w),m(J,e),m(_,e),m(B,e),m(k,e),m(A,e),m(G,e),m(W,e),m($,e),m(z,e),m(P,e),m(K,e),m(O,e),m(te,e),m(ae,e),m(se,e),m(ie,e),m(Me,e),m(ce,e),m(me,e),m(ye,e),m(we,e),m(Ue,e),m(_e,e),m(Be,e),m(xe,e),m(We,e)}}}const da='{"title":"Integrate any ML framework with the Hub","local":"integrate-any-ml-framework-with-the-hub","sections":[{"title":"A flexible approach: helpers","local":"a-flexible-approach-helpers","sections":[{"title":"from_pretrained","local":"frompretrained","sections":[],"depth":3},{"title":"push_to_hub","local":"pushtohub","sections":[],"depth":3},{"title":"Limitations","local":"limitations","sections":[],"depth":3}],"depth":2},{"title":"A more complex approach: class inheritance","local":"a-more-complex-approach-class-inheritance","sections":[{"title":"A concrete example: PyTorch","local":"a-concrete-example-pytorch","sections":[{"title":"How to use it?","local":"how-to-use-it","sections":[],"depth":4},{"title":"Implementation","local":"implementation","sections":[],"depth":4}],"depth":3},{"title":"Advanced usage","local":"advanced-usage","sections":[{"title":"Model card","local":"model-card","sections":[],"depth":4},{"title":"Config","local":"config","sections":[],"depth":4}],"depth":3}],"depth":2},{"title":"Quick comparison","local":"quick-comparison","sections":[],"depth":2}],"depth":1}';function ha(Mt){return na(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ta extends ia{constructor(w){super(),oa(this,w,ha,ca,aa,{})}}export{Ta as component};
