import{s as dt,o as pt,n as rt}from"../chunks/scheduler.8c3d61f6.js";import{S as ct,i as mt,g as l,s as i,r as c,A as ut,h as r,f as n,c as s,j as ae,u as m,x as p,k as le,y as b,a as o,v as u,d as f,t as g,w as h}from"../chunks/index.da70eac4.js";import{T as ft}from"../chunks/Tip.1d9b8c37.js";import{D as We}from"../chunks/Docstring.ee4b6913.js";import{C as pe}from"../chunks/CodeBlock.00a903b3.js";import{E as gt}from"../chunks/ExampleCodeBlock.f7bd2c1f.js";import{H as de,E as ht}from"../chunks/EditOnGithub.1e64e623.js";function _t(ee){let a,J='Make sure to check out the Schedulers <a href="../../using-diffusers/schedulers.md">guide</a> to learn how to explore the tradeoff between scheduler speed and quality, and see the <a href="../../using-diffusers/loading.md#reuse-a-pipeline">reuse components across pipelines</a> section to learn how to efficiently load the same components into multiple pipelines.';return{c(){a=l("p"),a.innerHTML=J},l(_){a=r(_,"P",{"data-svelte-h":!0}),p(a)!=="svelte-w7r39y"&&(a.innerHTML=J)},m(_,w){o(_,a,w)},p:rt,d(_){_&&n(a)}}}function bt(ee){let a,J="Examples:",_,w,M;return w=new pe({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQ29nVmlkZW9YUGlwZWxpbmUlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwZXhwb3J0X3RvX3ZpZGVvJTBBJTBBcGlwZSUyMCUzRCUyMENvZ1ZpZGVvWFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJUSFVETSUyRkNvZ1ZpZGVvWC0yYiUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNikudG8oJTIyY3VkYSUyMiklMEFwcm9tcHQlMjAlM0QlMjAoJTBBJTIwJTIwJTIwJTIwJTIyQSUyMHBhbmRhJTJDJTIwZHJlc3NlZCUyMGluJTIwYSUyMHNtYWxsJTJDJTIwcmVkJTIwamFja2V0JTIwYW5kJTIwYSUyMHRpbnklMjBoYXQlMkMlMjBzaXRzJTIwb24lMjBhJTIwd29vZGVuJTIwc3Rvb2wlMjBpbiUyMGElMjBzZXJlbmUlMjBiYW1ib28lMjBmb3Jlc3QuJTIwJTIyJTBBJTIwJTIwJTIwJTIwJTIyVGhlJTIwcGFuZGEncyUyMGZsdWZmeSUyMHBhd3MlMjBzdHJ1bSUyMGElMjBtaW5pYXR1cmUlMjBhY291c3RpYyUyMGd1aXRhciUyQyUyMHByb2R1Y2luZyUyMHNvZnQlMkMlMjBtZWxvZGljJTIwdHVuZXMuJTIwTmVhcmJ5JTJDJTIwYSUyMGZldyUyMG90aGVyJTIwJTIyJTBBJTIwJTIwJTIwJTIwJTIycGFuZGFzJTIwZ2F0aGVyJTJDJTIwd2F0Y2hpbmclMjBjdXJpb3VzbHklMjBhbmQlMjBzb21lJTIwY2xhcHBpbmclMjBpbiUyMHJoeXRobS4lMjBTdW5saWdodCUyMGZpbHRlcnMlMjB0aHJvdWdoJTIwdGhlJTIwdGFsbCUyMGJhbWJvbyUyQyUyMCUyMiUwQSUyMCUyMCUyMCUyMCUyMmNhc3RpbmclMjBhJTIwZ2VudGxlJTIwZ2xvdyUyMG9uJTIwdGhlJTIwc2NlbmUuJTIwVGhlJTIwcGFuZGEncyUyMGZhY2UlMjBpcyUyMGV4cHJlc3NpdmUlMkMlMjBzaG93aW5nJTIwY29uY2VudHJhdGlvbiUyMGFuZCUyMGpveSUyMGFzJTIwaXQlMjBwbGF5cy4lMjAlMjIlMEElMjAlMjAlMjAlMjAlMjJUaGUlMjBiYWNrZ3JvdW5kJTIwaW5jbHVkZXMlMjBhJTIwc21hbGwlMkMlMjBmbG93aW5nJTIwc3RyZWFtJTIwYW5kJTIwdmlicmFudCUyMGdyZWVuJTIwZm9saWFnZSUyQyUyMGVuaGFuY2luZyUyMHRoZSUyMHBlYWNlZnVsJTIwYW5kJTIwbWFnaWNhbCUyMCUyMiUwQSUyMCUyMCUyMCUyMCUyMmF0bW9zcGhlcmUlMjBvZiUyMHRoaXMlMjB1bmlxdWUlMjBtdXNpY2FsJTIwcGVyZm9ybWFuY2UuJTIyJTBBKSUwQXZpZGVvJTIwJTNEJTIwcGlwZShwcm9tcHQlM0Rwcm9tcHQlMkMlMjBndWlkYW5jZV9zY2FsZSUzRDYlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENTApLmZyYW1lcyU1QjAlNUQlMEFleHBvcnRfdG9fdmlkZW8odmlkZW8lMkMlMjAlMjJvdXRwdXQubXA0JTIyJTJDJTIwZnBzJTNEOCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> CogVideoXPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_video

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = CogVideoXPipeline.from_pretrained(<span class="hljs-string">&quot;THUDM/CogVideoX-2b&quot;</span>, torch_dtype=torch.float16).to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = (
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;A panda, dressed in a small, red jacket and a tiny hat, sits on a wooden stool in a serene bamboo forest. &quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;The panda&#x27;s fluffy paws strum a miniature acoustic guitar, producing soft, melodic tunes. Nearby, a few other &quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;pandas gather, watching curiously and some clapping in rhythm. Sunlight filters through the tall bamboo, &quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;casting a gentle glow on the scene. The panda&#x27;s face is expressive, showing concentration and joy as it plays. &quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;The background includes a small, flowing stream and vibrant green foliage, enhancing the peaceful and magical &quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;atmosphere of this unique musical performance.&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>video = pipe(prompt=prompt, guidance_scale=<span class="hljs-number">6</span>, num_inference_steps=<span class="hljs-number">50</span>).frames[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>export_to_video(video, <span class="hljs-string">&quot;output.mp4&quot;</span>, fps=<span class="hljs-number">8</span>)`,wrap:!1}}),{c(){a=l("p"),a.textContent=J,_=i(),c(w.$$.fragment)},l(d){a=r(d,"P",{"data-svelte-h":!0}),p(a)!=="svelte-kvfsh7"&&(a.textContent=J),_=s(d),m(w.$$.fragment,d)},m(d,T){o(d,a,T),o(d,_,T),u(w,d,T),M=!0},p:rt,i(d){M||(f(w.$$.fragment,d),M=!0)},o(d){g(w.$$.fragment,d),M=!1},d(d){d&&(n(a),n(_)),h(w,d)}}}function yt(ee){let a,J,_,w,M,d,T,Ee='<a href="https://arxiv.org/abs/2408.06072" rel="nofollow">CogVideoX: Text-to-Video Diffusion Models with An Expert Transformer</a> from Tsinghua University &amp; ZhipuAI, by Zhuoyi Yang, Jiayan Teng, Wendi Zheng, Ming Ding, Shiyu Huang, Jiazheng Xu, Yuanming Yang, Wenyi Hong, Xiaohan Zhang, Guanyu Feng, Da Yin, Xiaotao Gu, Yuxuan Zhang, Weihan Wang, Yean Cheng, Ting Liu, Bin Xu, Yuxiao Dong, Jie Tang.',ce,V,Se="The abstract from the paper is:",me,I,qe='<em>We introduce CogVideoX, a large-scale diffusion transformer model designed for generating videos based on text prompts. To efficently model video data, we propose to levearge a 3D Variational Autoencoder (VAE) to compresses videos along both spatial and temporal dimensions. To improve the text-video alignment, we propose an expert transformer with the expert adaptive LayerNorm to facilitate the deep fusion between the two modalities. By employing a progressive training technique, CogVideoX is adept at producing coherent, long-duration videos characterized by significant motion. In addition, we develop an effectively text-video data processing pipeline that includes various data preprocessing strategies and a video captioning method. It significantly helps enhance the performance of CogVideoX, improving both generation quality and semantic alignment. Results show that CogVideoX demonstrates state-of-the-art performance across both multiple machine metrics and human evaluations. The model weight of CogVideoX-2B is publicly available at <a href="https://github.com/THUDM/CogVideo" rel="nofollow">https://github.com/THUDM/CogVideo</a>.</em>',ue,j,fe,X,De='This pipeline was contributed by <a href="https://github.com/zRzRzRzRzRzRzR" rel="nofollow">zRzRzRzRzRzRzR</a>. The original codebase can be found <a href="https://huggingface.co/THUDM" rel="nofollow">here</a>. The original weights can be found under <a href="https://huggingface.co/THUDM" rel="nofollow">hf.co/THUDM</a>.',ge,G,he,B,Qe='Use <a href="https://huggingface.co/docs/diffusers/main/en/tutorials/fast_diffusion#torchcompile" rel="nofollow"><code>torch.compile</code></a> to reduce the inference latency.',_e,k,Ae="First, load the pipeline:",be,W,ye,P,Oe="Then change the memory layout of the pipelines <code>transformer</code> component to <code>torch.channels_last</code>:",we,H,ve,Y,Ke="Finally, compile the components and run inference:",Me,z,Te,N,et='The <a href="https://gist.github.com/a-r-r-o-w/5183d75e452a368fd17448fcc810bd3f" rel="nofollow">benchmark</a> results on an 80GB A100 machine are:',Je,R,xe,F,Ce,L,tt='CogVideoX requires about 19 GB of GPU memory to decode 49 frames (6 seconds of video at 8 FPS) with output resolution 720x480 (W x H), which makes it not possible to run on consumer GPUs or free-tier T4 Colab. The following memory optimizations could be used to reduce the memory footprint. For replication, you can refer to <a href="https://gist.github.com/a-r-r-o-w/3959a03f15be5c9bd1fe545b09dfcc93" rel="nofollow">this</a> script.',Ue,E,nt="<li><code>pipe.enable_model_cpu_offload()</code>:<ul><li>Without enabling cpu offloading, memory usage is <code>33 GB</code></li> <li>With enabling cpu offloading, memory usage is <code>19 GB</code></li></ul></li> <li><code>pipe.vae.enable_tiling()</code>:<ul><li>With enabling cpu offloading and tiling, memory usage is <code>11 GB</code></li></ul></li> <li><code>pipe.vae.enable_slicing()</code></li>",je,S,Ze,y,q,Pe,te,ot="Pipeline for text-to-video generation using CogVideoX.",He,ne,it=`This model inherits from <a href="/docs/diffusers/pr_7873/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods the
library implements for all the pipelines (such as downloading or saving, running on a particular device, etc.)`,Ye,x,D,ze,oe,st="Function invoked when calling the pipeline for generation.",Ne,Z,Re,$,Q,Fe,ie,at="Encodes the prompt into text encoder hidden states.",$e,A,Ve,C,O,Le,se,lt="Output class for CogVideo pipelines.",Ie,K,Xe,re,Ge;return M=new de({props:{title:"CogVideoX",local:"cogvideox",headingTag:"h1"}}),j=new ft({props:{$$slots:{default:[_t]},$$scope:{ctx:ee}}}),G=new de({props:{title:"Inference",local:"inference",headingTag:"h2"}}),W=new pe({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQ29nVmlkZW9YUGlwZWxpbmUlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwZXhwb3J0X3RvX3ZpZGVvJTBBJTBBcGlwZSUyMCUzRCUyMENvZ1ZpZGVvWFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJUSFVETSUyRkNvZ1ZpZGVvWC0yYiUyMikudG8oJTIyY3VkYSUyMik=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> CogVideoXPipeline
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_video

pipe = CogVideoXPipeline.from_pretrained(<span class="hljs-string">&quot;THUDM/CogVideoX-2b&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)`,wrap:!1}}),H=new pe({props:{code:"cGlwZS50cmFuc2Zvcm1lci50byhtZW1vcnlfZm9ybWF0JTNEdG9yY2guY2hhbm5lbHNfbGFzdCk=",highlighted:"pipe.transformer.to(memory_format=torch.channels_last)",wrap:!1}}),z=new pe({props:{code:"cGlwZS50cmFuc2Zvcm1lciUyMCUzRCUyMHRvcmNoLmNvbXBpbGUocGlwZWxpbmUudHJhbnNmb3JtZXIlMkMlMjBtb2RlJTNEJTIybWF4LWF1dG90dW5lJTIyJTJDJTIwZnVsbGdyYXBoJTNEVHJ1ZSklMEElMEElMjMlMjBDb2dWaWRlb1glMjB3b3JrcyUyMHdlbGwlMjB3aXRoJTIwbG9uZyUyMGFuZCUyMHdlbGwtZGVzY3JpYmVkJTIwcHJvbXB0cyUwQXByb21wdCUyMCUzRCUyMCUyMkElMjBwYW5kYSUyQyUyMGRyZXNzZWQlMjBpbiUyMGElMjBzbWFsbCUyQyUyMHJlZCUyMGphY2tldCUyMGFuZCUyMGElMjB0aW55JTIwaGF0JTJDJTIwc2l0cyUyMG9uJTIwYSUyMHdvb2RlbiUyMHN0b29sJTIwaW4lMjBhJTIwc2VyZW5lJTIwYmFtYm9vJTIwZm9yZXN0LiUyMFRoZSUyMHBhbmRhJ3MlMjBmbHVmZnklMjBwYXdzJTIwc3RydW0lMjBhJTIwbWluaWF0dXJlJTIwYWNvdXN0aWMlMjBndWl0YXIlMkMlMjBwcm9kdWNpbmclMjBzb2Z0JTJDJTIwbWVsb2RpYyUyMHR1bmVzLiUyME5lYXJieSUyQyUyMGElMjBmZXclMjBvdGhlciUyMHBhbmRhcyUyMGdhdGhlciUyQyUyMHdhdGNoaW5nJTIwY3VyaW91c2x5JTIwYW5kJTIwc29tZSUyMGNsYXBwaW5nJTIwaW4lMjByaHl0aG0uJTIwU3VubGlnaHQlMjBmaWx0ZXJzJTIwdGhyb3VnaCUyMHRoZSUyMHRhbGwlMjBiYW1ib28lMkMlMjBjYXN0aW5nJTIwYSUyMGdlbnRsZSUyMGdsb3clMjBvbiUyMHRoZSUyMHNjZW5lLiUyMFRoZSUyMHBhbmRhJ3MlMjBmYWNlJTIwaXMlMjBleHByZXNzaXZlJTJDJTIwc2hvd2luZyUyMGNvbmNlbnRyYXRpb24lMjBhbmQlMjBqb3klMjBhcyUyMGl0JTIwcGxheXMuJTIwVGhlJTIwYmFja2dyb3VuZCUyMGluY2x1ZGVzJTIwYSUyMHNtYWxsJTJDJTIwZmxvd2luZyUyMHN0cmVhbSUyMGFuZCUyMHZpYnJhbnQlMjBncmVlbiUyMGZvbGlhZ2UlMkMlMjBlbmhhbmNpbmclMjB0aGUlMjBwZWFjZWZ1bCUyMGFuZCUyMG1hZ2ljYWwlMjBhdG1vc3BoZXJlJTIwb2YlMjB0aGlzJTIwdW5pcXVlJTIwbXVzaWNhbCUyMHBlcmZvcm1hbmNlLiUyMiUwQXZpZGVvJTIwJTNEJTIwcGlwZShwcm9tcHQlM0Rwcm9tcHQlMkMlMjBndWlkYW5jZV9zY2FsZSUzRDYlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENTApLmZyYW1lcyU1QjAlNUQ=",highlighted:`pipe.transformer = torch.<span class="hljs-built_in">compile</span>(pipeline.transformer, mode=<span class="hljs-string">&quot;max-autotune&quot;</span>, fullgraph=<span class="hljs-literal">True</span>)

<span class="hljs-comment"># CogVideoX works well with long and well-described prompts</span>
prompt = <span class="hljs-string">&quot;A panda, dressed in a small, red jacket and a tiny hat, sits on a wooden stool in a serene bamboo forest. The panda&#x27;s fluffy paws strum a miniature acoustic guitar, producing soft, melodic tunes. Nearby, a few other pandas gather, watching curiously and some clapping in rhythm. Sunlight filters through the tall bamboo, casting a gentle glow on the scene. The panda&#x27;s face is expressive, showing concentration and joy as it plays. The background includes a small, flowing stream and vibrant green foliage, enhancing the peaceful and magical atmosphere of this unique musical performance.&quot;</span>
video = pipe(prompt=prompt, guidance_scale=<span class="hljs-number">6</span>, num_inference_steps=<span class="hljs-number">50</span>).frames[<span class="hljs-number">0</span>]`,wrap:!1}}),R=new pe({props:{code:"V2l0aG91dCUyMHRvcmNoLmNvbXBpbGUoKSUzQSUyMEF2ZXJhZ2UlMjBpbmZlcmVuY2UlMjB0aW1lJTNBJTIwOTYuODklMjBzZWNvbmRzLiUwQVdpdGglMjB0b3JjaC5jb21waWxlKCklM0ElMjBBdmVyYWdlJTIwaW5mZXJlbmNlJTIwdGltZSUzQSUyMDc2LjI3JTIwc2Vjb25kcy4=",highlighted:`<span class="hljs-attribute">Without</span> torch.compile(): Average inference time: <span class="hljs-number">96</span>.<span class="hljs-number">89</span> seconds.
<span class="hljs-attribute">With</span> torch.compile(): Average inference time: <span class="hljs-number">76</span>.<span class="hljs-number">27</span> seconds.`,wrap:!1}}),F=new de({props:{title:"Memory optimization",local:"memory-optimization",headingTag:"h3"}}),S=new de({props:{title:"CogVideoXPipeline",local:"diffusers.CogVideoXPipeline",headingTag:"h2"}}),q=new We({props:{name:"class diffusers.CogVideoXPipeline",anchor:"diffusers.CogVideoXPipeline",parameters:[{name:"tokenizer",val:": T5Tokenizer"},{name:"text_encoder",val:": T5EncoderModel"},{name:"vae",val:": AutoencoderKLCogVideoX"},{name:"transformer",val:": CogVideoXTransformer3DModel"},{name:"scheduler",val:": Union"}],parametersDescription:[{anchor:"diffusers.CogVideoXPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/pr_7873/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode videos to and from latent representations.`,name:"vae"},{anchor:"diffusers.CogVideoXPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>T5EncoderModel</code>) &#x2014;
Frozen text-encoder. CogVideoX uses
<a href="https://huggingface.co/docs/transformers/model_doc/t5#transformers.T5EncoderModel" rel="nofollow">T5</a>; specifically the
<a href="https://huggingface.co/PixArt-alpha/PixArt-alpha/tree/main/t5-v1_1-xxl" rel="nofollow">t5-v1_1-xxl</a> variant.`,name:"text_encoder"},{anchor:"diffusers.CogVideoXPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>T5Tokenizer</code>) &#x2014;
Tokenizer of class
<a href="https://huggingface.co/docs/transformers/model_doc/t5#transformers.T5Tokenizer" rel="nofollow">T5Tokenizer</a>.`,name:"tokenizer"},{anchor:"diffusers.CogVideoXPipeline.transformer",description:`<strong>transformer</strong> (<a href="/docs/diffusers/pr_7873/en/api/models/cogvideox_transformer3d#diffusers.CogVideoXTransformer3DModel">CogVideoXTransformer3DModel</a>) &#x2014;
A text conditioned <code>CogVideoXTransformer3DModel</code> to denoise the encoded video latents.`,name:"transformer"},{anchor:"diffusers.CogVideoXPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/pr_7873/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a>) &#x2014;
A scheduler to be used in combination with <code>transformer</code> to denoise the encoded video latents.`,name:"scheduler"}],source:"https://github.com/huggingface/diffusers/blob/vr_7873/src/diffusers/pipelines/cogvideo/pipeline_cogvideox.py#L133"}}),D=new We({props:{name:"__call__",anchor:"diffusers.CogVideoXPipeline.__call__",parameters:[{name:"prompt",val:": Union = None"},{name:"negative_prompt",val:": Union = None"},{name:"height",val:": int = 480"},{name:"width",val:": int = 720"},{name:"num_frames",val:": int = 49"},{name:"num_inference_steps",val:": int = 50"},{name:"timesteps",val:": Optional = None"},{name:"guidance_scale",val:": float = 6"},{name:"use_dynamic_cfg",val:": bool = False"},{name:"num_videos_per_prompt",val:": int = 1"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": Union = None"},{name:"latents",val:": Optional = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"output_type",val:": str = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"callback_on_step_end",val:": Union = None"},{name:"callback_on_step_end_tensor_inputs",val:": List = ['latents']"},{name:"max_sequence_length",val:": int = 226"}],parametersDescription:[{anchor:"diffusers.CogVideoXPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide the image generation. If not defined, one has to pass <code>prompt_embeds</code>.
instead.`,name:"prompt"},{anchor:"diffusers.CogVideoXPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.CogVideoXPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to self.unet.config.sample_size * self.vae_scale_factor) &#x2014;
The height in pixels of the generated image. This is set to 1024 by default for the best results.`,name:"height"},{anchor:"diffusers.CogVideoXPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to self.unet.config.sample_size * self.vae_scale_factor) &#x2014;
The width in pixels of the generated image. This is set to 1024 by default for the best results.`,name:"width"},{anchor:"diffusers.CogVideoXPipeline.__call__.num_frames",description:`<strong>num_frames</strong> (<code>int</code>, defaults to <code>48</code>) &#x2014;
Number of frames to generate. Must be divisible by self.vae_scale_factor_temporal. Generated video will
contain 1 extra frame because CogVideoX is conditioned with (num_seconds * fps + 1) frames where
num_seconds is 6 and fps is 4. However, since videos can be saved at any fps, the only condition that
needs to be satisfied is that of divisibility mentioned above.`,name:"num_frames"},{anchor:"diffusers.CogVideoXPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.CogVideoXPipeline.__call__.timesteps",description:`<strong>timesteps</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Custom timesteps to use for the denoising process with schedulers which support a <code>timesteps</code> argument
in their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is
passed will be used. Must be in descending order.`,name:"timesteps"},{anchor:"diffusers.CogVideoXPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 7.0) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.CogVideoXPipeline.__call__.num_videos_per_prompt",description:`<strong>num_videos_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of videos to generate per prompt.`,name:"num_videos_per_prompt"},{anchor:"diffusers.CogVideoXPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.CogVideoXPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.CogVideoXPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.CogVideoXPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.CogVideoXPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between
<a href="https://pillow.readthedocs.io/en/stable/" rel="nofollow">PIL</a>: <code>PIL.Image.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.CogVideoXPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>~pipelines.stable_diffusion_xl.StableDiffusionXLPipelineOutput</code> instead
of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.CogVideoXPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a list of all tensors as specified by
<code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.CogVideoXPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"},{anchor:"diffusers.CogVideoXPipeline.__call__.max_sequence_length",description:`<strong>max_sequence_length</strong> (<code>int</code>, defaults to <code>226</code>) &#x2014;
Maximum sequence length in encoded prompt. Must be consistent with
<code>self.transformer.config.max_text_seq_length</code> otherwise may lead to poor results.`,name:"max_sequence_length"}],source:"https://github.com/huggingface/diffusers/blob/vr_7873/src/diffusers/pipelines/cogvideo/pipeline_cogvideox.py#L424",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/pr_7873/en/api/pipelines/cogvideox#diffusers.pipelines.cogvideo.pipeline_cogvideox.CogVideoXPipelineOutput"
>CogVideoXPipelineOutput</a> if <code>return_dict</code> is True, otherwise a
<code>tuple</code>. When returning a tuple, the first element is a list with the generated images.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/pr_7873/en/api/pipelines/cogvideox#diffusers.pipelines.cogvideo.pipeline_cogvideox.CogVideoXPipelineOutput"
>CogVideoXPipelineOutput</a> or <code>tuple</code></p>
`}}),Z=new gt({props:{anchor:"diffusers.CogVideoXPipeline.__call__.example",$$slots:{default:[bt]},$$scope:{ctx:ee}}}),Q=new We({props:{name:"encode_prompt",anchor:"diffusers.CogVideoXPipeline.encode_prompt",parameters:[{name:"prompt",val:": Union"},{name:"negative_prompt",val:": Union = None"},{name:"do_classifier_free_guidance",val:": bool = True"},{name:"num_videos_per_prompt",val:": int = 1"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"max_sequence_length",val:": int = 226"},{name:"device",val:": Optional = None"},{name:"dtype",val:": Optional = None"}],parametersDescription:[{anchor:"diffusers.CogVideoXPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded`,name:"prompt"},{anchor:"diffusers.CogVideoXPipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.CogVideoXPipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to use classifier free guidance or not.`,name:"do_classifier_free_guidance"},{anchor:"diffusers.CogVideoXPipeline.encode_prompt.num_videos_per_prompt",description:`<strong>num_videos_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Number of videos that should be generated per prompt. torch device to place the resulting embeddings on`,name:"num_videos_per_prompt"},{anchor:"diffusers.CogVideoXPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.CogVideoXPipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.
device &#x2014; (<code>torch.device</code>, <em>optional</em>):
torch device
dtype &#x2014; (<code>torch.dtype</code>, <em>optional</em>):
torch dtype`,name:"negative_prompt_embeds"}],source:"https://github.com/huggingface/diffusers/blob/vr_7873/src/diffusers/pipelines/cogvideo/pipeline_cogvideox.py#L229"}}),A=new de({props:{title:"CogVideoXPipelineOutput",local:"diffusers.pipelines.cogvideo.pipeline_cogvideox.CogVideoXPipelineOutput",headingTag:"h2"}}),O=new We({props:{name:"class diffusers.pipelines.cogvideo.pipeline_cogvideox.CogVideoXPipelineOutput",anchor:"diffusers.pipelines.cogvideo.pipeline_cogvideox.CogVideoXPipelineOutput",parameters:[{name:"frames",val:": Tensor"}],parametersDescription:[{anchor:"diffusers.pipelines.cogvideo.pipeline_cogvideox.CogVideoXPipelineOutput.frames",description:`<strong>frames</strong> (<code>torch.Tensor</code>, <code>np.ndarray</code>, or List[List[PIL.Image.Image]]) &#x2014;
List of video outputs - It can be a nested list of length <code>batch_size,</code> with each sub-list containing
denoised PIL image sequences of length <code>num_frames.</code> It can also be a NumPy array or Torch tensor of shape
<code>(batch_size, num_frames, channels, height, width)</code>.`,name:"frames"}],source:"https://github.com/huggingface/diffusers/blob/vr_7873/src/diffusers/pipelines/cogvideo/pipeline_cogvideox.py#L118"}}),K=new ht({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/api/pipelines/cogvideox.md"}}),{c(){a=l("meta"),J=i(),_=l("p"),w=i(),c(M.$$.fragment),d=i(),T=l("p"),T.innerHTML=Ee,ce=i(),V=l("p"),V.textContent=Se,me=i(),I=l("p"),I.innerHTML=qe,ue=i(),c(j.$$.fragment),fe=i(),X=l("p"),X.innerHTML=De,ge=i(),c(G.$$.fragment),he=i(),B=l("p"),B.innerHTML=Qe,_e=i(),k=l("p"),k.textContent=Ae,be=i(),c(W.$$.fragment),ye=i(),P=l("p"),P.innerHTML=Oe,we=i(),c(H.$$.fragment),ve=i(),Y=l("p"),Y.textContent=Ke,Me=i(),c(z.$$.fragment),Te=i(),N=l("p"),N.innerHTML=et,Je=i(),c(R.$$.fragment),xe=i(),c(F.$$.fragment),Ce=i(),L=l("p"),L.innerHTML=tt,Ue=i(),E=l("ul"),E.innerHTML=nt,je=i(),c(S.$$.fragment),Ze=i(),y=l("div"),c(q.$$.fragment),Pe=i(),te=l("p"),te.textContent=ot,He=i(),ne=l("p"),ne.innerHTML=it,Ye=i(),x=l("div"),c(D.$$.fragment),ze=i(),oe=l("p"),oe.textContent=st,Ne=i(),c(Z.$$.fragment),Re=i(),$=l("div"),c(Q.$$.fragment),Fe=i(),ie=l("p"),ie.textContent=at,$e=i(),c(A.$$.fragment),Ve=i(),C=l("div"),c(O.$$.fragment),Le=i(),se=l("p"),se.textContent=lt,Ie=i(),c(K.$$.fragment),Xe=i(),re=l("p"),this.h()},l(e){const t=ut("svelte-u9bgzb",document.head);a=r(t,"META",{name:!0,content:!0}),t.forEach(n),J=s(e),_=r(e,"P",{}),ae(_).forEach(n),w=s(e),m(M.$$.fragment,e),d=s(e),T=r(e,"P",{"data-svelte-h":!0}),p(T)!=="svelte-1jx3rme"&&(T.innerHTML=Ee),ce=s(e),V=r(e,"P",{"data-svelte-h":!0}),p(V)!=="svelte-1cwsb16"&&(V.textContent=Se),me=s(e),I=r(e,"P",{"data-svelte-h":!0}),p(I)!=="svelte-19oae4l"&&(I.innerHTML=qe),ue=s(e),m(j.$$.fragment,e),fe=s(e),X=r(e,"P",{"data-svelte-h":!0}),p(X)!=="svelte-14a2tju"&&(X.innerHTML=De),ge=s(e),m(G.$$.fragment,e),he=s(e),B=r(e,"P",{"data-svelte-h":!0}),p(B)!=="svelte-iekg51"&&(B.innerHTML=Qe),_e=s(e),k=r(e,"P",{"data-svelte-h":!0}),p(k)!=="svelte-jub7f1"&&(k.textContent=Ae),be=s(e),m(W.$$.fragment,e),ye=s(e),P=r(e,"P",{"data-svelte-h":!0}),p(P)!=="svelte-1p91erm"&&(P.innerHTML=Oe),we=s(e),m(H.$$.fragment,e),ve=s(e),Y=r(e,"P",{"data-svelte-h":!0}),p(Y)!=="svelte-9i4prs"&&(Y.textContent=Ke),Me=s(e),m(z.$$.fragment,e),Te=s(e),N=r(e,"P",{"data-svelte-h":!0}),p(N)!=="svelte-1brnakn"&&(N.innerHTML=et),Je=s(e),m(R.$$.fragment,e),xe=s(e),m(F.$$.fragment,e),Ce=s(e),L=r(e,"P",{"data-svelte-h":!0}),p(L)!=="svelte-1yu2ff3"&&(L.innerHTML=tt),Ue=s(e),E=r(e,"UL",{"data-svelte-h":!0}),p(E)!=="svelte-v5wcbj"&&(E.innerHTML=nt),je=s(e),m(S.$$.fragment,e),Ze=s(e),y=r(e,"DIV",{class:!0});var v=ae(y);m(q.$$.fragment,v),Pe=s(v),te=r(v,"P",{"data-svelte-h":!0}),p(te)!=="svelte-gmblkq"&&(te.textContent=ot),He=s(v),ne=r(v,"P",{"data-svelte-h":!0}),p(ne)!=="svelte-1y910lq"&&(ne.innerHTML=it),Ye=s(v),x=r(v,"DIV",{class:!0});var U=ae(x);m(D.$$.fragment,U),ze=s(U),oe=r(U,"P",{"data-svelte-h":!0}),p(oe)!=="svelte-v78lg8"&&(oe.textContent=st),Ne=s(U),m(Z.$$.fragment,U),U.forEach(n),Re=s(v),$=r(v,"DIV",{class:!0});var Be=ae($);m(Q.$$.fragment,Be),Fe=s(Be),ie=r(Be,"P",{"data-svelte-h":!0}),p(ie)!=="svelte-16q0ax1"&&(ie.textContent=at),Be.forEach(n),v.forEach(n),$e=s(e),m(A.$$.fragment,e),Ve=s(e),C=r(e,"DIV",{class:!0});var ke=ae(C);m(O.$$.fragment,ke),Le=s(ke),se=r(ke,"P",{"data-svelte-h":!0}),p(se)!=="svelte-1qnvsrt"&&(se.textContent=lt),ke.forEach(n),Ie=s(e),m(K.$$.fragment,e),Xe=s(e),re=r(e,"P",{}),ae(re).forEach(n),this.h()},h(){le(a,"name","hf:doc:metadata"),le(a,"content",wt),le(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),le($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),le(y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),le(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){b(document.head,a),o(e,J,t),o(e,_,t),o(e,w,t),u(M,e,t),o(e,d,t),o(e,T,t),o(e,ce,t),o(e,V,t),o(e,me,t),o(e,I,t),o(e,ue,t),u(j,e,t),o(e,fe,t),o(e,X,t),o(e,ge,t),u(G,e,t),o(e,he,t),o(e,B,t),o(e,_e,t),o(e,k,t),o(e,be,t),u(W,e,t),o(e,ye,t),o(e,P,t),o(e,we,t),u(H,e,t),o(e,ve,t),o(e,Y,t),o(e,Me,t),u(z,e,t),o(e,Te,t),o(e,N,t),o(e,Je,t),u(R,e,t),o(e,xe,t),u(F,e,t),o(e,Ce,t),o(e,L,t),o(e,Ue,t),o(e,E,t),o(e,je,t),u(S,e,t),o(e,Ze,t),o(e,y,t),u(q,y,null),b(y,Pe),b(y,te),b(y,He),b(y,ne),b(y,Ye),b(y,x),u(D,x,null),b(x,ze),b(x,oe),b(x,Ne),u(Z,x,null),b(y,Re),b(y,$),u(Q,$,null),b($,Fe),b($,ie),o(e,$e,t),u(A,e,t),o(e,Ve,t),o(e,C,t),u(O,C,null),b(C,Le),b(C,se),o(e,Ie,t),u(K,e,t),o(e,Xe,t),o(e,re,t),Ge=!0},p(e,[t]){const v={};t&2&&(v.$$scope={dirty:t,ctx:e}),j.$set(v);const U={};t&2&&(U.$$scope={dirty:t,ctx:e}),Z.$set(U)},i(e){Ge||(f(M.$$.fragment,e),f(j.$$.fragment,e),f(G.$$.fragment,e),f(W.$$.fragment,e),f(H.$$.fragment,e),f(z.$$.fragment,e),f(R.$$.fragment,e),f(F.$$.fragment,e),f(S.$$.fragment,e),f(q.$$.fragment,e),f(D.$$.fragment,e),f(Z.$$.fragment,e),f(Q.$$.fragment,e),f(A.$$.fragment,e),f(O.$$.fragment,e),f(K.$$.fragment,e),Ge=!0)},o(e){g(M.$$.fragment,e),g(j.$$.fragment,e),g(G.$$.fragment,e),g(W.$$.fragment,e),g(H.$$.fragment,e),g(z.$$.fragment,e),g(R.$$.fragment,e),g(F.$$.fragment,e),g(S.$$.fragment,e),g(q.$$.fragment,e),g(D.$$.fragment,e),g(Z.$$.fragment,e),g(Q.$$.fragment,e),g(A.$$.fragment,e),g(O.$$.fragment,e),g(K.$$.fragment,e),Ge=!1},d(e){e&&(n(J),n(_),n(w),n(d),n(T),n(ce),n(V),n(me),n(I),n(ue),n(fe),n(X),n(ge),n(he),n(B),n(_e),n(k),n(be),n(ye),n(P),n(we),n(ve),n(Y),n(Me),n(Te),n(N),n(Je),n(xe),n(Ce),n(L),n(Ue),n(E),n(je),n(Ze),n(y),n($e),n(Ve),n(C),n(Ie),n(Xe),n(re)),n(a),h(M,e),h(j,e),h(G,e),h(W,e),h(H,e),h(z,e),h(R,e),h(F,e),h(S,e),h(q),h(D),h(Z),h(Q),h(A,e),h(O),h(K,e)}}}const wt='{"title":"CogVideoX","local":"cogvideox","sections":[{"title":"Inference","local":"inference","sections":[{"title":"Memory optimization","local":"memory-optimization","sections":[],"depth":3}],"depth":2},{"title":"CogVideoXPipeline","local":"diffusers.CogVideoXPipeline","sections":[],"depth":2},{"title":"CogVideoXPipelineOutput","local":"diffusers.pipelines.cogvideo.pipeline_cogvideox.CogVideoXPipelineOutput","sections":[],"depth":2}],"depth":1}';function vt(ee){return pt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Zt extends ct{constructor(a){super(),mt(this,a,vt,yt,dt,{})}}export{Zt as component};
