import{s as rh,o as ih,n as x}from"../chunks/scheduler.6062bdaf.js";import{S as ch,i as ph,g,s as r,r as h,A as uh,h as m,f as p,c as i,j as $,u as d,x as T,k as v,y as l,a as _,v as f,d as y,t as b,w as M}from"../chunks/index.4bca734e.js";import{T as A}from"../chunks/Tip.b9ac1f03.js";import{D as k}from"../chunks/Docstring.d7918b6d.js";import{C as q}from"../chunks/CodeBlock.fa01571c.js";import{E}from"../chunks/ExampleCodeBlock.d27cbfa4.js";import{H as mr,E as gh}from"../chunks/EditOnGithub.74ab2baa.js";function mh(I){let n,u="Example:",a,t,o;return t=new q({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBY2xpZW50LmF1ZGlvX2NsYXNzaWZpY2F0aW9uKCUyMmF1ZGlvLmZsYWMlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.audio_classification(<span class="hljs-string">&quot;audio.flac&quot;</span>)
[
    AudioClassificationOutputElement(score=<span class="hljs-number">0.4976358711719513</span>, label=<span class="hljs-string">&#x27;hap&#x27;</span>),
    AudioClassificationOutputElement(score=<span class="hljs-number">0.3677836060523987</span>, label=<span class="hljs-string">&#x27;neu&#x27;</span>),
    ...
]`,wrap:!1}}),{c(){n=g("p"),n.textContent=u,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=u),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:x,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),M(t,e)}}}function hh(I){let n,u="Example:",a,t,o;return t=new q({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBYXVkaW9fb3V0cHV0JTIwJTNEJTIwY2xpZW50LmF1ZGlvX3RvX2F1ZGlvKCUyMmF1ZGlvLmZsYWMlMjIpJTBBZm9yJTIwaSUyQyUyMGl0ZW0lMjBpbiUyMGVudW1lcmF0ZShhdWRpb19vdXRwdXQpJTNBJTBBJTIwJTIwJTIwJTIwd2l0aCUyMG9wZW4oZiUyMm91dHB1dF8lN0JpJTdELmZsYWMlMjIlMkMlMjAlMjJ3YiUyMiklMjBhcyUyMGYlM0E=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>audio_output = client.audio_to_audio(<span class="hljs-string">&quot;audio.flac&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i, item <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(audio_output):
<span class="hljs-meta">&gt;&gt;&gt; </span>    <span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">f&quot;output_<span class="hljs-subst">{i}</span>.flac&quot;</span>, <span class="hljs-string">&quot;wb&quot;</span>) <span class="hljs-keyword">as</span> f:
            f.write(item.blob)`,wrap:!1}}),{c(){n=g("p"),n.textContent=u,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=u),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:x,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),M(t,e)}}}function dh(I){let n,u="Example:",a,t,o;return t=new q({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBY2xpZW50LmF1dG9tYXRpY19zcGVlY2hfcmVjb2duaXRpb24oJTIyaGVsbG9fd29ybGQuZmxhYyUyMikudGV4dA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.automatic_speech_recognition(<span class="hljs-string">&quot;hello_world.flac&quot;</span>).text
<span class="hljs-string">&quot;hello world&quot;</span>`,wrap:!1}}),{c(){n=g("p"),n.textContent=u,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=u),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:x,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),M(t,e)}}}function fh(I){let n,u="Example:",a,t,o;return t=new q({props:{code:"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",highlighted:`<span class="hljs-comment"># Chat example</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>messages = [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What is the capital of France?&quot;</span>}]
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-8B-Instruct&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>client.chat_completion(messages, max_tokens=<span class="hljs-number">100</span>)
ChatCompletionOutput(
    choices=[
        ChatCompletionOutputComplete(
            finish_reason=<span class="hljs-string">&#x27;eos_token&#x27;</span>,
            index=<span class="hljs-number">0</span>,
            message=ChatCompletionOutputMessage(
                role=<span class="hljs-string">&#x27;assistant&#x27;</span>,
                content=<span class="hljs-string">&#x27;The capital of France is Paris.&#x27;</span>,
                name=<span class="hljs-literal">None</span>,
                tool_calls=<span class="hljs-literal">None</span>
            ),
            logprobs=<span class="hljs-literal">None</span>
        )
    ],
    created=<span class="hljs-number">1719907176</span>,
    <span class="hljs-built_in">id</span>=<span class="hljs-string">&#x27;&#x27;</span>,
    model=<span class="hljs-string">&#x27;meta-llama/Meta-Llama-3-8B-Instruct&#x27;</span>,
    <span class="hljs-built_in">object</span>=<span class="hljs-string">&#x27;text_completion&#x27;</span>,
    system_fingerprint=<span class="hljs-string">&#x27;2.0.4-sha-f426a33&#x27;</span>,
    usage=ChatCompletionOutputUsage(
        completion_tokens=<span class="hljs-number">8</span>,
        prompt_tokens=<span class="hljs-number">17</span>,
        total_tokens=<span class="hljs-number">25</span>
    )
)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> token <span class="hljs-keyword">in</span> client.chat_completion(messages, max_tokens=<span class="hljs-number">10</span>, stream=<span class="hljs-literal">True</span>):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(token)
ChatCompletionStreamOutput(choices=[ChatCompletionStreamOutputChoice(delta=ChatCompletionStreamOutputDelta(content=<span class="hljs-string">&#x27;The&#x27;</span>, role=<span class="hljs-string">&#x27;assistant&#x27;</span>), index=<span class="hljs-number">0</span>, finish_reason=<span class="hljs-literal">None</span>)], created=<span class="hljs-number">1710498504</span>)
ChatCompletionStreamOutput(choices=[ChatCompletionStreamOutputChoice(delta=ChatCompletionStreamOutputDelta(content=<span class="hljs-string">&#x27; capital&#x27;</span>, role=<span class="hljs-string">&#x27;assistant&#x27;</span>), index=<span class="hljs-number">0</span>, finish_reason=<span class="hljs-literal">None</span>)], created=<span class="hljs-number">1710498504</span>)
(...)
ChatCompletionStreamOutput(choices=[ChatCompletionStreamOutputChoice(delta=ChatCompletionStreamOutputDelta(content=<span class="hljs-string">&#x27; may&#x27;</span>, role=<span class="hljs-string">&#x27;assistant&#x27;</span>), index=<span class="hljs-number">0</span>, finish_reason=<span class="hljs-literal">None</span>)], created=<span class="hljs-number">1710498504</span>)

<span class="hljs-comment"># Chat example with tools</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-70B-Instruct&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>messages = [
<span class="hljs-meta">... </span>    {
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Don&#x27;t make assumptions about what values to plug into functions. Ask for clarification if a user request is ambiguous.&quot;</span>,
<span class="hljs-meta">... </span>    },
<span class="hljs-meta">... </span>    {
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What&#x27;s the weather like the next 3 days in San Francisco, CA?&quot;</span>,
<span class="hljs-meta">... </span>    },
<span class="hljs-meta">... </span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>tools = [
<span class="hljs-meta">... </span>    {
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;function&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;function&quot;</span>: {
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;get_current_weather&quot;</span>,
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;Get the current weather&quot;</span>,
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;parameters&quot;</span>: {
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;object&quot;</span>,
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;properties&quot;</span>: {
<span class="hljs-meta">... </span>                    <span class="hljs-string">&quot;location&quot;</span>: {
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>,
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;The city and state, e.g. San Francisco, CA&quot;</span>,
<span class="hljs-meta">... </span>                    },
<span class="hljs-meta">... </span>                    <span class="hljs-string">&quot;format&quot;</span>: {
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>,
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;enum&quot;</span>: [<span class="hljs-string">&quot;celsius&quot;</span>, <span class="hljs-string">&quot;fahrenheit&quot;</span>],
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;The temperature unit to use. Infer this from the users location.&quot;</span>,
<span class="hljs-meta">... </span>                    },
<span class="hljs-meta">... </span>                },
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;required&quot;</span>: [<span class="hljs-string">&quot;location&quot;</span>, <span class="hljs-string">&quot;format&quot;</span>],
<span class="hljs-meta">... </span>            },
<span class="hljs-meta">... </span>        },
<span class="hljs-meta">... </span>    },
<span class="hljs-meta">... </span>    {
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;function&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;function&quot;</span>: {
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;get_n_day_weather_forecast&quot;</span>,
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;Get an N-day weather forecast&quot;</span>,
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;parameters&quot;</span>: {
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;object&quot;</span>,
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;properties&quot;</span>: {
<span class="hljs-meta">... </span>                    <span class="hljs-string">&quot;location&quot;</span>: {
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>,
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;The city and state, e.g. San Francisco, CA&quot;</span>,
<span class="hljs-meta">... </span>                    },
<span class="hljs-meta">... </span>                    <span class="hljs-string">&quot;format&quot;</span>: {
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>,
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;enum&quot;</span>: [<span class="hljs-string">&quot;celsius&quot;</span>, <span class="hljs-string">&quot;fahrenheit&quot;</span>],
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;The temperature unit to use. Infer this from the users location.&quot;</span>,
<span class="hljs-meta">... </span>                    },
<span class="hljs-meta">... </span>                    <span class="hljs-string">&quot;num_days&quot;</span>: {
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;integer&quot;</span>,
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;The number of days to forecast&quot;</span>,
<span class="hljs-meta">... </span>                    },
<span class="hljs-meta">... </span>                },
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;required&quot;</span>: [<span class="hljs-string">&quot;location&quot;</span>, <span class="hljs-string">&quot;format&quot;</span>, <span class="hljs-string">&quot;num_days&quot;</span>],
<span class="hljs-meta">... </span>            },
<span class="hljs-meta">... </span>        },
<span class="hljs-meta">... </span>    },
<span class="hljs-meta">... </span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>response = client.chat_completion(
<span class="hljs-meta">... </span>    model=<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-70B-Instruct&quot;</span>,
<span class="hljs-meta">... </span>    messages=messages,
<span class="hljs-meta">... </span>    tools=tools,
<span class="hljs-meta">... </span>    tool_choice=<span class="hljs-string">&quot;auto&quot;</span>,
<span class="hljs-meta">... </span>    max_tokens=<span class="hljs-number">500</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>response.choices[<span class="hljs-number">0</span>].message.tool_calls[<span class="hljs-number">0</span>].function
ChatCompletionOutputFunctionDefinition(
    arguments={
        <span class="hljs-string">&#x27;location&#x27;</span>: <span class="hljs-string">&#x27;San Francisco, CA&#x27;</span>,
        <span class="hljs-string">&#x27;format&#x27;</span>: <span class="hljs-string">&#x27;fahrenheit&#x27;</span>,
        <span class="hljs-string">&#x27;num_days&#x27;</span>: <span class="hljs-number">3</span>
    },
    name=<span class="hljs-string">&#x27;get_n_day_weather_forecast&#x27;</span>,
    description=<span class="hljs-literal">None</span>
)`,wrap:!1}}),{c(){n=g("p"),n.textContent=u,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=u),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:x,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),M(t,e)}}}function yh(I){let n,u=`<a href="/docs/huggingface_hub/pr_2368/en/package_reference/inference_client#huggingface_hub.InferenceClient.conversational">InferenceClient.conversational()</a> API is deprecated and will be removed in a future release. Please use
<a href="/docs/huggingface_hub/pr_2368/en/package_reference/inference_client#huggingface_hub.InferenceClient.chat_completion">InferenceClient.chat_completion()</a> instead.`;return{c(){n=g("p"),n.innerHTML=u},l(a){n=m(a,"P",{"data-svelte-h":!0}),T(n)!=="svelte-167gp02"&&(n.innerHTML=u)},m(a,t){_(a,n,t)},p:x,d(a){a&&p(n)}}}function bh(I){let n,u="Example:",a,t,o;return t=new q({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBb3V0cHV0JTIwJTNEJTIwY2xpZW50LmNvbnZlcnNhdGlvbmFsKCUyMkhpJTJDJTIwd2hvJTIwYXJlJTIweW91JTNGJTIyKSUwQW91dHB1dCUwQWNsaWVudC5jb252ZXJzYXRpb25hbCglMEElMjAlMjAlMjAlMjAlMjJXb3clMkMlMjB0aGF0J3MlMjBzY2FyeSElMjIlMkMlMEElMjAlMjAlMjAlMjBnZW5lcmF0ZWRfcmVzcG9uc2VzJTNEb3V0cHV0JTVCJTIyY29udmVyc2F0aW9uJTIyJTVEJTVCJTIyZ2VuZXJhdGVkX3Jlc3BvbnNlcyUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMHBhc3RfdXNlcl9pbnB1dHMlM0RvdXRwdXQlNUIlMjJjb252ZXJzYXRpb24lMjIlNUQlNUIlMjJwYXN0X3VzZXJfaW5wdXRzJTIyJTVEJTJDJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>output = client.conversational(<span class="hljs-string">&quot;Hi, who are you?&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>output
{<span class="hljs-string">&#x27;generated_text&#x27;</span>: <span class="hljs-string">&#x27;I am the one who knocks.&#x27;</span>, <span class="hljs-string">&#x27;conversation&#x27;</span>: {<span class="hljs-string">&#x27;generated_responses&#x27;</span>: [<span class="hljs-string">&#x27;I am the one who knocks.&#x27;</span>], <span class="hljs-string">&#x27;past_user_inputs&#x27;</span>: [<span class="hljs-string">&#x27;Hi, who are you?&#x27;</span>]}, <span class="hljs-string">&#x27;warnings&#x27;</span>: [<span class="hljs-string">&#x27;Setting \`pad_token_id\` to \`eos_token_id\`:50256 for open-end generation.&#x27;</span>]}
<span class="hljs-meta">&gt;&gt;&gt; </span>client.conversational(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Wow, that&#x27;s scary!&quot;</span>,
<span class="hljs-meta">... </span>    generated_responses=output[<span class="hljs-string">&quot;conversation&quot;</span>][<span class="hljs-string">&quot;generated_responses&quot;</span>],
<span class="hljs-meta">... </span>    past_user_inputs=output[<span class="hljs-string">&quot;conversation&quot;</span>][<span class="hljs-string">&quot;past_user_inputs&quot;</span>],
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){n=g("p"),n.textContent=u,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=u),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:x,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),M(t,e)}}}function Mh(I){let n,u="Example:",a,t,o;return t=new q({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBY2xpZW50LmRvY3VtZW50X3F1ZXN0aW9uX2Fuc3dlcmluZyhpbWFnZSUzRCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZzcGFjZXMlMkZpbXBpcmElMkZkb2NxdWVyeSUyRnJlc29sdmUlMkYyMzU5MjIzYzE4MzdhNzU4NzQwMmJkYTBmMjY0MzM4MmE2ZWVmZWFiJTJGaW52b2ljZS5wbmclMjIlMkMlMjBxdWVzdGlvbiUzRCUyMldoYXQlMjBpcyUyMHRoZSUyMGludm9pY2UlMjBudW1iZXIlM0YlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.document_question_answering(image=<span class="hljs-string">&quot;https://huggingface.co/spaces/impira/docquery/resolve/2359223c1837a7587402bda0f2643382a6eefeab/invoice.png&quot;</span>, question=<span class="hljs-string">&quot;What is the invoice number?&quot;</span>)
[DocumentQuestionAnsweringOutputElement(score=<span class="hljs-number">0.42515629529953003</span>, answer=<span class="hljs-string">&#x27;us-001&#x27;</span>, start=<span class="hljs-number">16</span>, end=<span class="hljs-number">16</span>)]`,wrap:!1}}),{c(){n=g("p"),n.textContent=u,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=u),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:x,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),M(t,e)}}}function jh(I){let n,u="Example:",a,t,o;return t=new q({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBY2xpZW50LmZlYXR1cmVfZXh0cmFjdGlvbiglMjJIaSUyQyUyMHdobyUyMGFyZSUyMHlvdSUzRiUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.feature_extraction(<span class="hljs-string">&quot;Hi, who are you?&quot;</span>)
array([[ <span class="hljs-number">2.424802</span>  ,  <span class="hljs-number">2.93384</span>   ,  <span class="hljs-number">1.1750331</span> , ...,  <span class="hljs-number">1.240499</span>, -<span class="hljs-number">0.13776633</span>, -<span class="hljs-number">0.7889173</span> ],
[-<span class="hljs-number">0.42943227</span>, -<span class="hljs-number">0.6364878</span> , -<span class="hljs-number">1.693462</span>  , ...,  <span class="hljs-number">0.41978157</span>, -<span class="hljs-number">2.4336355</span> ,  <span class="hljs-number">0.6162071</span> ],
...,
[ <span class="hljs-number">0.28552425</span>, -<span class="hljs-number">0.928395</span>  , -<span class="hljs-number">1.2077185</span> , ...,  <span class="hljs-number">0.76810825</span>, -<span class="hljs-number">2.1069427</span> ,  <span class="hljs-number">0.6236161</span> ]], dtype=float32)`,wrap:!1}}),{c(){n=g("p"),n.textContent=u,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=u),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:x,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),M(t,e)}}}function _h(I){let n,u="Example:",a,t,o;return t=new q({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBY2xpZW50LmZpbGxfbWFzayglMjJUaGUlMjBnb2FsJTIwb2YlMjBsaWZlJTIwaXMlMjAlM0NtYXNrJTNFLiUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.fill_mask(<span class="hljs-string">&quot;The goal of life is &lt;mask&gt;.&quot;</span>)
[
    FillMaskOutputElement(score=<span class="hljs-number">0.06897063553333282</span>, token=<span class="hljs-number">11098</span>, token_str=<span class="hljs-string">&#x27; happiness&#x27;</span>, sequence=<span class="hljs-string">&#x27;The goal of life is happiness.&#x27;</span>),
    FillMaskOutputElement(score=<span class="hljs-number">0.06554922461509705</span>, token=<span class="hljs-number">45075</span>, token_str=<span class="hljs-string">&#x27; immortality&#x27;</span>, sequence=<span class="hljs-string">&#x27;The goal of life is immortality.&#x27;</span>)
]`,wrap:!1}}),{c(){n=g("p"),n.textContent=u,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=u),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:x,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),M(t,e)}}}function Th(I){let n,u="Example:",a,t,o;return t=new q({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCglMjJtZXRhLWxsYW1hJTJGTWV0YS1MbGFtYS0zLTcwQi1JbnN0cnVjdCUyMiklMEFjbGllbnQuZ2V0X2VuZHBvaW50X2luZm8oKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-70B-Instruct&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>client.get_endpoint_info()
{
    <span class="hljs-string">&#x27;model_id&#x27;</span>: <span class="hljs-string">&#x27;meta-llama/Meta-Llama-3-70B-Instruct&#x27;</span>,
    <span class="hljs-string">&#x27;model_sha&#x27;</span>: <span class="hljs-literal">None</span>,
    <span class="hljs-string">&#x27;model_dtype&#x27;</span>: <span class="hljs-string">&#x27;torch.float16&#x27;</span>,
    <span class="hljs-string">&#x27;model_device_type&#x27;</span>: <span class="hljs-string">&#x27;cuda&#x27;</span>,
    <span class="hljs-string">&#x27;model_pipeline_tag&#x27;</span>: <span class="hljs-literal">None</span>,
    <span class="hljs-string">&#x27;max_concurrent_requests&#x27;</span>: <span class="hljs-number">128</span>,
    <span class="hljs-string">&#x27;max_best_of&#x27;</span>: <span class="hljs-number">2</span>,
    <span class="hljs-string">&#x27;max_stop_sequences&#x27;</span>: <span class="hljs-number">4</span>,
    <span class="hljs-string">&#x27;max_input_length&#x27;</span>: <span class="hljs-number">8191</span>,
    <span class="hljs-string">&#x27;max_total_tokens&#x27;</span>: <span class="hljs-number">8192</span>,
    <span class="hljs-string">&#x27;waiting_served_ratio&#x27;</span>: <span class="hljs-number">0.3</span>,
    <span class="hljs-string">&#x27;max_batch_total_tokens&#x27;</span>: <span class="hljs-number">1259392</span>,
    <span class="hljs-string">&#x27;max_waiting_tokens&#x27;</span>: <span class="hljs-number">20</span>,
    <span class="hljs-string">&#x27;max_batch_size&#x27;</span>: <span class="hljs-literal">None</span>,
    <span class="hljs-string">&#x27;validation_workers&#x27;</span>: <span class="hljs-number">32</span>,
    <span class="hljs-string">&#x27;max_client_batch_size&#x27;</span>: <span class="hljs-number">4</span>,
    <span class="hljs-string">&#x27;version&#x27;</span>: <span class="hljs-string">&#x27;2.0.2&#x27;</span>,
    <span class="hljs-string">&#x27;sha&#x27;</span>: <span class="hljs-string">&#x27;dccab72549635c7eb5ddb17f43f0b7cdff07c214&#x27;</span>,
    <span class="hljs-string">&#x27;docker_label&#x27;</span>: <span class="hljs-string">&#x27;sha-dccab72&#x27;</span>
}`,wrap:!1}}),{c(){n=g("p"),n.textContent=u,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=u),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:x,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),M(t,e)}}}function Ih(I){let n,u=`This endpoint is mostly useful when you already know which model you want to use and want to check its
availability. If you want to discover already deployed models, you should rather use <a href="/docs/huggingface_hub/pr_2368/en/package_reference/inference_client#huggingface_hub.InferenceClient.list_deployed_models">list_deployed_models()</a>.`;return{c(){n=g("p"),n.innerHTML=u},l(a){n=m(a,"P",{"data-svelte-h":!0}),T(n)!=="svelte-1rb7cag"&&(n.innerHTML=u)},m(a,t){_(a,n,t)},p:x,d(a){a&&p(n)}}}function xh(I){let n,u="Example:",a,t,o;return t=new q({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBY2xpZW50LmdldF9tb2RlbF9zdGF0dXMoJTIyYmlnY29kZSUyRnN0YXJjb2RlciUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.get_model_status(<span class="hljs-string">&quot;bigcode/starcoder&quot;</span>)
ModelStatus(loaded=<span class="hljs-literal">True</span>, state=<span class="hljs-string">&#x27;Loaded&#x27;</span>, compute_type=<span class="hljs-string">&#x27;gpu&#x27;</span>, framework=<span class="hljs-string">&#x27;text-generation-inference&#x27;</span>)`,wrap:!1}}),{c(){n=g("p"),n.textContent=u,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=u),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:x,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),M(t,e)}}}function Jh(I){let n,u="Example:",a,t,o;return t=new q({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCglMjJodHRwcyUzQSUyRiUyRmp6Z3UwYnVlaTUudXMtZWFzdC0xLmF3cy5lbmRwb2ludHMuaHVnZ2luZ2ZhY2UuY2xvdWQlMjIpJTBBY2xpZW50LmhlYWx0aF9jaGVjaygp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(<span class="hljs-string">&quot;https://jzgu0buei5.us-east-1.aws.endpoints.huggingface.cloud&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>client.health_check()
<span class="hljs-literal">True</span>`,wrap:!1}}),{c(){n=g("p"),n.textContent=u,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=u),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:x,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),M(t,e)}}}function wh(I){let n,u="Example:",a,t,o;return t=new q({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBY2xpZW50LmltYWdlX2NsYXNzaWZpY2F0aW9uKCUyMmh0dHBzJTNBJTJGJTJGdXBsb2FkLndpa2ltZWRpYS5vcmclMkZ3aWtpcGVkaWElMkZjb21tb25zJTJGdGh1bWIlMkY0JTJGNDMlMkZDdXRlX2RvZy5qcGclMkYzMjBweC1DdXRlX2RvZy5qcGclMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.image_classification(<span class="hljs-string">&quot;https://upload.wikimedia.org/wikipedia/commons/thumb/4/43/Cute_dog.jpg/320px-Cute_dog.jpg&quot;</span>)
[ImageClassificationOutputElement(score=<span class="hljs-number">0.9779096841812134</span>, label=<span class="hljs-string">&#x27;Blenheim spaniel&#x27;</span>), ...]`,wrap:!1}}),{c(){n=g("p"),n.textContent=u,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=u),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:x,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),M(t,e)}}}function Ch(I){let n,u="You must have <code>PIL</code> installed if you want to work with images (<code>pip install Pillow</code>).";return{c(){n=g("p"),n.innerHTML=u},l(a){n=m(a,"P",{"data-svelte-h":!0}),T(n)!=="svelte-s2e3n9"&&(n.innerHTML=u)},m(a,t){_(a,n,t)},p:x,d(a){a&&p(n)}}}function Uh(I){let n,u="Example:",a,t,o;return t=new q({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBY2xpZW50LmltYWdlX3NlZ21lbnRhdGlvbiglMjJjYXQuanBnJTIyKSUzQQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.image_segmentation(<span class="hljs-string">&quot;cat.jpg&quot;</span>):
[ImageSegmentationOutputElement(score=<span class="hljs-number">0.989008</span>, label=<span class="hljs-string">&#x27;LABEL_184&#x27;</span>, mask=&lt;PIL.PngImagePlugin.PngImageFile image mode=L size=400x300 at <span class="hljs-number">0x7FDD2B129CC0</span>&gt;), ...]`,wrap:!1}}),{c(){n=g("p"),n.textContent=u,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=u),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:x,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),M(t,e)}}}function $h(I){let n,u="You must have <code>PIL</code> installed if you want to work with images (<code>pip install Pillow</code>).";return{c(){n=g("p"),n.innerHTML=u},l(a){n=m(a,"P",{"data-svelte-h":!0}),T(n)!=="svelte-s2e3n9"&&(n.innerHTML=u)},m(a,t){_(a,n,t)},p:x,d(a){a&&p(n)}}}function vh(I){let n,u="Example:",a,t,o;return t=new q({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBaW1hZ2UlMjAlM0QlMjBjbGllbnQuaW1hZ2VfdG9faW1hZ2UoJTIyY2F0LmpwZyUyMiUyQyUyMHByb21wdCUzRCUyMnR1cm4lMjB0aGUlMjBjYXQlMjBpbnRvJTIwYSUyMHRpZ2VyJTIyKSUwQWltYWdlLnNhdmUoJTIydGlnZXIuanBnJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>image = client.image_to_image(<span class="hljs-string">&quot;cat.jpg&quot;</span>, prompt=<span class="hljs-string">&quot;turn the cat into a tiger&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image.save(<span class="hljs-string">&quot;tiger.jpg&quot;</span>)`,wrap:!1}}),{c(){n=g("p"),n.textContent=u,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=u),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:x,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),M(t,e)}}}function kh(I){let n,u="Example:",a,t,o;return t=new q({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBY2xpZW50LmltYWdlX3RvX3RleHQoJTIyY2F0LmpwZyUyMiklMEFjbGllbnQuaW1hZ2VfdG9fdGV4dCglMjJodHRwcyUzQSUyRiUyRnVwbG9hZC53aWtpbWVkaWEub3JnJTJGd2lraXBlZGlhJTJGY29tbW9ucyUyRnRodW1iJTJGNCUyRjQzJTJGQ3V0ZV9kb2cuanBnJTJGMzIwcHgtQ3V0ZV9kb2cuanBnJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.image_to_text(<span class="hljs-string">&quot;cat.jpg&quot;</span>)
<span class="hljs-string">&#x27;a cat standing in a grassy field &#x27;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>client.image_to_text(<span class="hljs-string">&quot;https://upload.wikimedia.org/wikipedia/commons/thumb/4/43/Cute_dog.jpg/320px-Cute_dog.jpg&quot;</span>)
<span class="hljs-string">&#x27;a dog laying on the grass next to a flower pot &#x27;</span>`,wrap:!1}}),{c(){n=g("p"),n.textContent=u,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=u),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:x,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),M(t,e)}}}function qh(I){let n,u=`This endpoint method does not return a live list of all models available for the Serverless Inference API service.
It searches over a cached list of models that were recently available and the list may not be up to date.
If you want to know the live status of a specific model, use <a href="/docs/huggingface_hub/pr_2368/en/package_reference/inference_client#huggingface_hub.InferenceClient.get_model_status">get_model_status()</a>.`;return{c(){n=g("p"),n.innerHTML=u},l(a){n=m(a,"P",{"data-svelte-h":!0}),T(n)!=="svelte-1wsu01a"&&(n.innerHTML=u)},m(a,t){_(a,n,t)},p:x,d(a){a&&p(n)}}}function Eh(I){let n,u=`This endpoint method is mostly useful for discoverability. If you already know which model you want to use and want to
check its availability, you can directly use <a href="/docs/huggingface_hub/pr_2368/en/package_reference/inference_client#huggingface_hub.InferenceClient.get_model_status">get_model_status()</a>.`;return{c(){n=g("p"),n.innerHTML=u},l(a){n=m(a,"P",{"data-svelte-h":!0}),T(n)!=="svelte-2f6fs5"&&(n.innerHTML=u)},m(a,t){_(a,n,t)},p:x,d(a){a&&p(n)}}}function Ah(I){let n,u="Example:",a,t,o;return t=new q({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBJTBBbW9kZWxzJTIwJTNEJTIwY2xpZW50Lmxpc3RfZGVwbG95ZWRfbW9kZWxzKCklMEFtb2RlbHMlNUIlMjJ6ZXJvLXNob3QtY2xhc3NpZmljYXRpb24lMjIlNUQlMEElMEFjbGllbnQubGlzdF9kZXBsb3llZF9tb2RlbHMoJTIydGV4dC1nZW5lcmF0aW9uLWluZmVyZW5jZSUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()

<span class="hljs-comment"># Discover zero-shot-classification models currently deployed</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>models = client.list_deployed_models()
<span class="hljs-meta">&gt;&gt;&gt; </span>models[<span class="hljs-string">&quot;zero-shot-classification&quot;</span>]
[<span class="hljs-string">&#x27;Narsil/deberta-large-mnli-zero-cls&#x27;</span>, <span class="hljs-string">&#x27;facebook/bart-large-mnli&#x27;</span>, ...]

<span class="hljs-comment"># List from only 1 framework</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>client.list_deployed_models(<span class="hljs-string">&quot;text-generation-inference&quot;</span>)
{<span class="hljs-string">&#x27;text-generation&#x27;</span>: [<span class="hljs-string">&#x27;bigcode/starcoder&#x27;</span>, <span class="hljs-string">&#x27;meta-llama/Llama-2-70b-chat-hf&#x27;</span>, ...], ...}`,wrap:!1}}),{c(){n=g("p"),n.textContent=u,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=u),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:x,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),M(t,e)}}}function Zh(I){let n,u="You must have <code>PIL</code> installed if you want to work with images (<code>pip install Pillow</code>).";return{c(){n=g("p"),n.innerHTML=u},l(a){n=m(a,"P",{"data-svelte-h":!0}),T(n)!=="svelte-s2e3n9"&&(n.innerHTML=u)},m(a,t){_(a,n,t)},p:x,d(a){a&&p(n)}}}function Wh(I){let n,u="Example:",a,t,o;return t=new q({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBY2xpZW50Lm9iamVjdF9kZXRlY3Rpb24oJTIycGVvcGxlLmpwZyUyMiklM0E=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.object_detection(<span class="hljs-string">&quot;people.jpg&quot;</span>):
[ObjectDetectionOutputElement(score=<span class="hljs-number">0.9486683011054993</span>, label=<span class="hljs-string">&#x27;person&#x27;</span>, box=ObjectDetectionBoundingBox(xmin=<span class="hljs-number">59</span>, ymin=<span class="hljs-number">39</span>, xmax=<span class="hljs-number">420</span>, ymax=<span class="hljs-number">510</span>)), ...]`,wrap:!1}}),{c(){n=g("p"),n.textContent=u,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=u),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:x,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),M(t,e)}}}function Nh(I){let n,u="Example:",a,t,o;return t=new q({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBY2xpZW50LnF1ZXN0aW9uX2Fuc3dlcmluZyhxdWVzdGlvbiUzRCUyMldoYXQncyUyMG15JTIwbmFtZSUzRiUyMiUyQyUyMGNvbnRleHQlM0QlMjJNeSUyMG5hbWUlMjBpcyUyMENsYXJhJTIwYW5kJTIwSSUyMGxpdmUlMjBpbiUyMEJlcmtlbGV5LiUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.question_answering(question=<span class="hljs-string">&quot;What&#x27;s my name?&quot;</span>, context=<span class="hljs-string">&quot;My name is Clara and I live in Berkeley.&quot;</span>)
QuestionAnsweringOutputElement(score=<span class="hljs-number">0.9326562285423279</span>, start=<span class="hljs-number">11</span>, end=<span class="hljs-number">16</span>, answer=<span class="hljs-string">&#x27;Clara&#x27;</span>)`,wrap:!1}}),{c(){n=g("p"),n.textContent=u,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=u),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:x,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),M(t,e)}}}function Gh(I){let n,u="Example:",a,t,o;return t=new q({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBY2xpZW50LnNlbnRlbmNlX3NpbWlsYXJpdHkoJTBBJTIwJTIwJTIwJTIwJTIyTWFjaGluZSUyMGxlYXJuaW5nJTIwaXMlMjBzbyUyMGVhc3kuJTIyJTJDJTBBJTIwJTIwJTIwJTIwb3RoZXJfc2VudGVuY2VzJTNEJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyRGVlcCUyMGxlYXJuaW5nJTIwaXMlMjBzbyUyMHN0cmFpZ2h0Zm9yd2FyZC4lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJUaGlzJTIwaXMlMjBzbyUyMGRpZmZpY3VsdCUyQyUyMGxpa2UlMjByb2NrZXQlMjBzY2llbmNlLiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMkklMjBjYW4ndCUyMGJlbGlldmUlMjBob3clMjBtdWNoJTIwSSUyMHN0cnVnZ2xlZCUyMHdpdGglMjB0aGlzLiUyMiUyQyUwQSUyMCUyMCUyMCUyMCU1RCUyQyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.sentence_similarity(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Machine learning is so easy.&quot;</span>,
<span class="hljs-meta">... </span>    other_sentences=[
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;Deep learning is so straightforward.&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;This is so difficult, like rocket science.&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;I can&#x27;t believe how much I struggled with this.&quot;</span>,
<span class="hljs-meta">... </span>    ],
<span class="hljs-meta">... </span>)
[<span class="hljs-number">0.7785726189613342</span>, <span class="hljs-number">0.45876261591911316</span>, <span class="hljs-number">0.2906220555305481</span>]`,wrap:!1}}),{c(){n=g("p"),n.textContent=u,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=u),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:x,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),M(t,e)}}}function Bh(I){let n,u="Example:",a,t,o;return t=new q({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBY2xpZW50LnN1bW1hcml6YXRpb24oJTIyVGhlJTIwRWlmZmVsJTIwdG93ZXIuLi4lMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.summarization(<span class="hljs-string">&quot;The Eiffel tower...&quot;</span>)
SummarizationOutput(generated_text=<span class="hljs-string">&quot;The Eiffel tower is one of the most famous landmarks in the world....&quot;</span>)`,wrap:!1}}),{c(){n=g("p"),n.textContent=u,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=u),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:x,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),M(t,e)}}}function Vh(I){let n,u="Example:",a,t,o;return t=new q({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBcXVlcnklMjAlM0QlMjAlMjJIb3clMjBtYW55JTIwc3RhcnMlMjBkb2VzJTIwdGhlJTIwdHJhbnNmb3JtZXJzJTIwcmVwb3NpdG9yeSUyMGhhdmUlM0YlMjIlMEF0YWJsZSUyMCUzRCUyMCU3QiUyMlJlcG9zaXRvcnklMjIlM0ElMjAlNUIlMjJUcmFuc2Zvcm1lcnMlMjIlMkMlMjAlMjJEYXRhc2V0cyUyMiUyQyUyMCUyMlRva2VuaXplcnMlMjIlNUQlMkMlMjAlMjJTdGFycyUyMiUzQSUyMCU1QiUyMjM2NTQyJTIyJTJDJTIwJTIyNDUxMiUyMiUyQyUyMCUyMjM5MzQlMjIlNUQlN0QlMEFjbGllbnQudGFibGVfcXVlc3Rpb25fYW5zd2VyaW5nKHRhYmxlJTJDJTIwcXVlcnklMkMlMjBtb2RlbCUzRCUyMmdvb2dsZSUyRnRhcGFzLWJhc2UtZmluZXR1bmVkLXd0cSUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>query = <span class="hljs-string">&quot;How many stars does the transformers repository have?&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>table = {<span class="hljs-string">&quot;Repository&quot;</span>: [<span class="hljs-string">&quot;Transformers&quot;</span>, <span class="hljs-string">&quot;Datasets&quot;</span>, <span class="hljs-string">&quot;Tokenizers&quot;</span>], <span class="hljs-string">&quot;Stars&quot;</span>: [<span class="hljs-string">&quot;36542&quot;</span>, <span class="hljs-string">&quot;4512&quot;</span>, <span class="hljs-string">&quot;3934&quot;</span>]}
<span class="hljs-meta">&gt;&gt;&gt; </span>client.table_question_answering(table, query, model=<span class="hljs-string">&quot;google/tapas-base-finetuned-wtq&quot;</span>)
TableQuestionAnsweringOutputElement(answer=<span class="hljs-string">&#x27;36542&#x27;</span>, coordinates=[[<span class="hljs-number">0</span>, <span class="hljs-number">1</span>]], cells=[<span class="hljs-string">&#x27;36542&#x27;</span>], aggregator=<span class="hljs-string">&#x27;AVERAGE&#x27;</span>)`,wrap:!1}}),{c(){n=g("p"),n.textContent=u,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=u),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:x,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),M(t,e)}}}function Qh(I){let n,u="Example:",a,t,o;return t=new q({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBdGFibGUlMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjJmaXhlZF9hY2lkaXR5JTIyJTNBJTIwJTVCJTIyNy40JTIyJTJDJTIwJTIyNy44JTIyJTJDJTIwJTIyMTAuMyUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMnZvbGF0aWxlX2FjaWRpdHklMjIlM0ElMjAlNUIlMjIwLjclMjIlMkMlMjAlMjIwLjg4JTIyJTJDJTIwJTIyMC4zMiUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMmNpdHJpY19hY2lkJTIyJTNBJTIwJTVCJTIyMCUyMiUyQyUyMCUyMjAlMjIlMkMlMjAlMjIwLjQ1JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIycmVzaWR1YWxfc3VnYXIlMjIlM0ElMjAlNUIlMjIxLjklMjIlMkMlMjAlMjIyLjYlMjIlMkMlMjAlMjI2LjQlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjJjaGxvcmlkZXMlMjIlM0ElMjAlNUIlMjIwLjA3NiUyMiUyQyUyMCUyMjAuMDk4JTIyJTJDJTIwJTIyMC4wNzMlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjJmcmVlX3N1bGZ1cl9kaW94aWRlJTIyJTNBJTIwJTVCJTIyMTElMjIlMkMlMjAlMjIyNSUyMiUyQyUyMCUyMjUlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjJ0b3RhbF9zdWxmdXJfZGlveGlkZSUyMiUzQSUyMCU1QiUyMjM0JTIyJTJDJTIwJTIyNjclMjIlMkMlMjAlMjIxMyUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMmRlbnNpdHklMjIlM0ElMjAlNUIlMjIwLjk5NzglMjIlMkMlMjAlMjIwLjk5NjglMjIlMkMlMjAlMjIwLjk5NzYlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjJwSCUyMiUzQSUyMCU1QiUyMjMuNTElMjIlMkMlMjAlMjIzLjIlMjIlMkMlMjAlMjIzLjIzJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIyc3VscGhhdGVzJTIyJTNBJTIwJTVCJTIyMC41NiUyMiUyQyUyMCUyMjAuNjglMjIlMkMlMjAlMjIwLjgyJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIyYWxjb2hvbCUyMiUzQSUyMCU1QiUyMjkuNCUyMiUyQyUyMCUyMjkuOCUyMiUyQyUyMCUyMjEyLjYlMjIlNUQlMkMlMEElN0QlMEFjbGllbnQudGFidWxhcl9jbGFzc2lmaWNhdGlvbih0YWJsZSUzRHRhYmxlJTJDJTIwbW9kZWwlM0QlMjJqdWxpZW4tYyUyRndpbmUtcXVhbGl0eSUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>table = {
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;fixed_acidity&quot;</span>: [<span class="hljs-string">&quot;7.4&quot;</span>, <span class="hljs-string">&quot;7.8&quot;</span>, <span class="hljs-string">&quot;10.3&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;volatile_acidity&quot;</span>: [<span class="hljs-string">&quot;0.7&quot;</span>, <span class="hljs-string">&quot;0.88&quot;</span>, <span class="hljs-string">&quot;0.32&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;citric_acid&quot;</span>: [<span class="hljs-string">&quot;0&quot;</span>, <span class="hljs-string">&quot;0&quot;</span>, <span class="hljs-string">&quot;0.45&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;residual_sugar&quot;</span>: [<span class="hljs-string">&quot;1.9&quot;</span>, <span class="hljs-string">&quot;2.6&quot;</span>, <span class="hljs-string">&quot;6.4&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;chlorides&quot;</span>: [<span class="hljs-string">&quot;0.076&quot;</span>, <span class="hljs-string">&quot;0.098&quot;</span>, <span class="hljs-string">&quot;0.073&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;free_sulfur_dioxide&quot;</span>: [<span class="hljs-string">&quot;11&quot;</span>, <span class="hljs-string">&quot;25&quot;</span>, <span class="hljs-string">&quot;5&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;total_sulfur_dioxide&quot;</span>: [<span class="hljs-string">&quot;34&quot;</span>, <span class="hljs-string">&quot;67&quot;</span>, <span class="hljs-string">&quot;13&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;density&quot;</span>: [<span class="hljs-string">&quot;0.9978&quot;</span>, <span class="hljs-string">&quot;0.9968&quot;</span>, <span class="hljs-string">&quot;0.9976&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;pH&quot;</span>: [<span class="hljs-string">&quot;3.51&quot;</span>, <span class="hljs-string">&quot;3.2&quot;</span>, <span class="hljs-string">&quot;3.23&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;sulphates&quot;</span>: [<span class="hljs-string">&quot;0.56&quot;</span>, <span class="hljs-string">&quot;0.68&quot;</span>, <span class="hljs-string">&quot;0.82&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;alcohol&quot;</span>: [<span class="hljs-string">&quot;9.4&quot;</span>, <span class="hljs-string">&quot;9.8&quot;</span>, <span class="hljs-string">&quot;12.6&quot;</span>],
<span class="hljs-meta">... </span>}
<span class="hljs-meta">&gt;&gt;&gt; </span>client.tabular_classification(table=table, model=<span class="hljs-string">&quot;julien-c/wine-quality&quot;</span>)
[<span class="hljs-string">&quot;5&quot;</span>, <span class="hljs-string">&quot;5&quot;</span>, <span class="hljs-string">&quot;5&quot;</span>]`,wrap:!1}}),{c(){n=g("p"),n.textContent=u,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=u),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:x,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),M(t,e)}}}function Yh(I){let n,u="Example:",a,t,o;return t=new q({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBdGFibGUlMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjJIZWlnaHQlMjIlM0ElMjAlNUIlMjIxMS41MiUyMiUyQyUyMCUyMjEyLjQ4JTIyJTJDJTIwJTIyMTIuMzc3OCUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMkxlbmd0aDElMjIlM0ElMjAlNUIlMjIyMy4yJTIyJTJDJTIwJTIyMjQlMjIlMkMlMjAlMjIyMy45JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIyTGVuZ3RoMiUyMiUzQSUyMCU1QiUyMjI1LjQlMjIlMkMlMjAlMjIyNi4zJTIyJTJDJTIwJTIyMjYuNSUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMkxlbmd0aDMlMjIlM0ElMjAlNUIlMjIzMCUyMiUyQyUyMCUyMjMxLjIlMjIlMkMlMjAlMjIzMS4xJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIyU3BlY2llcyUyMiUzQSUyMCU1QiUyMkJyZWFtJTIyJTJDJTIwJTIyQnJlYW0lMjIlMkMlMjAlMjJCcmVhbSUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMldpZHRoJTIyJTNBJTIwJTVCJTIyNC4wMiUyMiUyQyUyMCUyMjQuMzA1NiUyMiUyQyUyMCUyMjQuNjk2MSUyMiU1RCUyQyUwQSU3RCUwQWNsaWVudC50YWJ1bGFyX3JlZ3Jlc3Npb24odGFibGUlMkMlMjBtb2RlbCUzRCUyMnNjaWtpdC1sZWFybiUyRkZpc2gtV2VpZ2h0JTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>table = {
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Height&quot;</span>: [<span class="hljs-string">&quot;11.52&quot;</span>, <span class="hljs-string">&quot;12.48&quot;</span>, <span class="hljs-string">&quot;12.3778&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Length1&quot;</span>: [<span class="hljs-string">&quot;23.2&quot;</span>, <span class="hljs-string">&quot;24&quot;</span>, <span class="hljs-string">&quot;23.9&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Length2&quot;</span>: [<span class="hljs-string">&quot;25.4&quot;</span>, <span class="hljs-string">&quot;26.3&quot;</span>, <span class="hljs-string">&quot;26.5&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Length3&quot;</span>: [<span class="hljs-string">&quot;30&quot;</span>, <span class="hljs-string">&quot;31.2&quot;</span>, <span class="hljs-string">&quot;31.1&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Species&quot;</span>: [<span class="hljs-string">&quot;Bream&quot;</span>, <span class="hljs-string">&quot;Bream&quot;</span>, <span class="hljs-string">&quot;Bream&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Width&quot;</span>: [<span class="hljs-string">&quot;4.02&quot;</span>, <span class="hljs-string">&quot;4.3056&quot;</span>, <span class="hljs-string">&quot;4.6961&quot;</span>],
<span class="hljs-meta">... </span>}
<span class="hljs-meta">&gt;&gt;&gt; </span>client.tabular_regression(table, model=<span class="hljs-string">&quot;scikit-learn/Fish-Weight&quot;</span>)
[<span class="hljs-number">110</span>, <span class="hljs-number">120</span>, <span class="hljs-number">130</span>]`,wrap:!1}}),{c(){n=g("p"),n.textContent=u,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=u),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:x,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),M(t,e)}}}function Sh(I){let n,u="Example:",a,t,o;return t=new q({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBY2xpZW50LnRleHRfY2xhc3NpZmljYXRpb24oJTIySSUyMGxpa2UlMjB5b3UlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.text_classification(<span class="hljs-string">&quot;I like you&quot;</span>)
[
    TextClassificationOutputElement(label=<span class="hljs-string">&#x27;POSITIVE&#x27;</span>, score=<span class="hljs-number">0.9998695850372314</span>),
    TextClassificationOutputElement(label=<span class="hljs-string">&#x27;NEGATIVE&#x27;</span>, score=<span class="hljs-number">0.0001304351753788069</span>),
]`,wrap:!1}}),{c(){n=g("p"),n.textContent=u,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=u),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:x,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),M(t,e)}}}function Dh(I){let n,u=`If you want to generate a response from chat messages, you should use the <a href="/docs/huggingface_hub/pr_2368/en/package_reference/inference_client#huggingface_hub.InferenceClient.chat_completion">InferenceClient.chat_completion()</a> method.
It accepts a list of messages instead of a single text prompt and handles the chat templating for you.`;return{c(){n=g("p"),n.innerHTML=u},l(a){n=m(a,"P",{"data-svelte-h":!0}),T(n)!=="svelte-1ynsxk"&&(n.innerHTML=u)},m(a,t){_(a,n,t)},p:x,d(a){a&&p(n)}}}function Rh(I){let n,u="Example:",a,t,o;return t=new q({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()

<span class="hljs-comment"># Case 1: generate text</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>client.text_generation(<span class="hljs-string">&quot;The huggingface_hub library is &quot;</span>, max_new_tokens=<span class="hljs-number">12</span>)
<span class="hljs-string">&#x27;100% open source and built to be easy to use.&#x27;</span>

<span class="hljs-comment"># Case 2: iterate over the generated tokens. Useful for large generation.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> token <span class="hljs-keyword">in</span> client.text_generation(<span class="hljs-string">&quot;The huggingface_hub library is &quot;</span>, max_new_tokens=<span class="hljs-number">12</span>, stream=<span class="hljs-literal">True</span>):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(token)
<span class="hljs-number">100</span>
%
<span class="hljs-built_in">open</span>
source
<span class="hljs-keyword">and</span>
built
to
be
easy
to
use
.

<span class="hljs-comment"># Case 3: get more details about the generation process.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>client.text_generation(<span class="hljs-string">&quot;The huggingface_hub library is &quot;</span>, max_new_tokens=<span class="hljs-number">12</span>, details=<span class="hljs-literal">True</span>)
TextGenerationOutput(
    generated_text=<span class="hljs-string">&#x27;100% open source and built to be easy to use.&#x27;</span>,
    details=TextGenerationDetails(
        finish_reason=<span class="hljs-string">&#x27;length&#x27;</span>,
        generated_tokens=<span class="hljs-number">12</span>,
        seed=<span class="hljs-literal">None</span>,
        prefill=[
            TextGenerationPrefillOutputToken(<span class="hljs-built_in">id</span>=<span class="hljs-number">487</span>, text=<span class="hljs-string">&#x27;The&#x27;</span>, logprob=<span class="hljs-literal">None</span>),
            TextGenerationPrefillOutputToken(<span class="hljs-built_in">id</span>=<span class="hljs-number">53789</span>, text=<span class="hljs-string">&#x27; hugging&#x27;</span>, logprob=-<span class="hljs-number">13.171875</span>),
            (...)
            TextGenerationPrefillOutputToken(<span class="hljs-built_in">id</span>=<span class="hljs-number">204</span>, text=<span class="hljs-string">&#x27; &#x27;</span>, logprob=-<span class="hljs-number">7.0390625</span>)
        ],
        tokens=[
            TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">1425</span>, text=<span class="hljs-string">&#x27;100&#x27;</span>, logprob=-<span class="hljs-number">1.0175781</span>, special=<span class="hljs-literal">False</span>),
            TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">16</span>, text=<span class="hljs-string">&#x27;%&#x27;</span>, logprob=-<span class="hljs-number">0.0463562</span>, special=<span class="hljs-literal">False</span>),
            (...)
            TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">25</span>, text=<span class="hljs-string">&#x27;.&#x27;</span>, logprob=-<span class="hljs-number">0.5703125</span>, special=<span class="hljs-literal">False</span>)
        ],
        best_of_sequences=<span class="hljs-literal">None</span>
    )
)

<span class="hljs-comment"># Case 4: iterate over the generated tokens with more details.</span>
<span class="hljs-comment"># Last object is more complete, containing the full generated text and the finish reason.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> details <span class="hljs-keyword">in</span> client.text_generation(<span class="hljs-string">&quot;The huggingface_hub library is &quot;</span>, max_new_tokens=<span class="hljs-number">12</span>, details=<span class="hljs-literal">True</span>, stream=<span class="hljs-literal">True</span>):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(details)
...
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">1425</span>, text=<span class="hljs-string">&#x27;100&#x27;</span>, logprob=-<span class="hljs-number">1.0175781</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">16</span>, text=<span class="hljs-string">&#x27;%&#x27;</span>, logprob=-<span class="hljs-number">0.0463562</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">1314</span>, text=<span class="hljs-string">&#x27; open&#x27;</span>, logprob=-<span class="hljs-number">1.3359375</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">3178</span>, text=<span class="hljs-string">&#x27; source&#x27;</span>, logprob=-<span class="hljs-number">0.28100586</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">273</span>, text=<span class="hljs-string">&#x27; and&#x27;</span>, logprob=-<span class="hljs-number">0.5961914</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">3426</span>, text=<span class="hljs-string">&#x27; built&#x27;</span>, logprob=-<span class="hljs-number">1.9423828</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">271</span>, text=<span class="hljs-string">&#x27; to&#x27;</span>, logprob=-<span class="hljs-number">1.4121094</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">314</span>, text=<span class="hljs-string">&#x27; be&#x27;</span>, logprob=-<span class="hljs-number">1.5224609</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">1833</span>, text=<span class="hljs-string">&#x27; easy&#x27;</span>, logprob=-<span class="hljs-number">2.1132812</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">271</span>, text=<span class="hljs-string">&#x27; to&#x27;</span>, logprob=-<span class="hljs-number">0.08520508</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">745</span>, text=<span class="hljs-string">&#x27; use&#x27;</span>, logprob=-<span class="hljs-number">0.39453125</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(
    <span class="hljs-built_in">id</span>=<span class="hljs-number">25</span>,
    text=<span class="hljs-string">&#x27;.&#x27;</span>,
    logprob=-<span class="hljs-number">0.5703125</span>,
    special=<span class="hljs-literal">False</span>),
    generated_text=<span class="hljs-string">&#x27;100% open source and built to be easy to use.&#x27;</span>,
    details=TextGenerationStreamOutputStreamDetails(finish_reason=<span class="hljs-string">&#x27;length&#x27;</span>, generated_tokens=<span class="hljs-number">12</span>, seed=<span class="hljs-literal">None</span>)
)

<span class="hljs-comment"># Case 5: generate constrained output using grammar</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>response = client.text_generation(
<span class="hljs-meta">... </span>    prompt=<span class="hljs-string">&quot;I saw a puppy a cat and a raccoon during my bike ride in the park&quot;</span>,
<span class="hljs-meta">... </span>    model=<span class="hljs-string">&quot;HuggingFaceH4/zephyr-orpo-141b-A35b-v0.1&quot;</span>,
<span class="hljs-meta">... </span>    max_new_tokens=<span class="hljs-number">100</span>,
<span class="hljs-meta">... </span>    repetition_penalty=<span class="hljs-number">1.3</span>,
<span class="hljs-meta">... </span>    grammar={
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;json&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;value&quot;</span>: {
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;properties&quot;</span>: {
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;location&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>},
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;activity&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>},
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;animals_seen&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;integer&quot;</span>, <span class="hljs-string">&quot;minimum&quot;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&quot;maximum&quot;</span>: <span class="hljs-number">5</span>},
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;animals&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;array&quot;</span>, <span class="hljs-string">&quot;items&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>}},
<span class="hljs-meta">... </span>            },
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;required&quot;</span>: [<span class="hljs-string">&quot;location&quot;</span>, <span class="hljs-string">&quot;activity&quot;</span>, <span class="hljs-string">&quot;animals_seen&quot;</span>, <span class="hljs-string">&quot;animals&quot;</span>],
<span class="hljs-meta">... </span>        },
<span class="hljs-meta">... </span>    },
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>json.loads(response)
{
    <span class="hljs-string">&quot;activity&quot;</span>: <span class="hljs-string">&quot;bike riding&quot;</span>,
    <span class="hljs-string">&quot;animals&quot;</span>: [<span class="hljs-string">&quot;puppy&quot;</span>, <span class="hljs-string">&quot;cat&quot;</span>, <span class="hljs-string">&quot;raccoon&quot;</span>],
    <span class="hljs-string">&quot;animals_seen&quot;</span>: <span class="hljs-number">3</span>,
    <span class="hljs-string">&quot;location&quot;</span>: <span class="hljs-string">&quot;park&quot;</span>
}`,wrap:!1}}),{c(){n=g("p"),n.textContent=u,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=u),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:x,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),M(t,e)}}}function Xh(I){let n,u="You must have <code>PIL</code> installed if you want to work with images (<code>pip install Pillow</code>).";return{c(){n=g("p"),n.innerHTML=u},l(a){n=m(a,"P",{"data-svelte-h":!0}),T(n)!=="svelte-s2e3n9"&&(n.innerHTML=u)},m(a,t){_(a,n,t)},p:x,d(a){a&&p(n)}}}function Hh(I){let n,u="Example:",a,t,o;return t=new q({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBJTBBaW1hZ2UlMjAlM0QlMjBjbGllbnQudGV4dF90b19pbWFnZSglMjJBbiUyMGFzdHJvbmF1dCUyMHJpZGluZyUyMGElMjBob3JzZSUyMG9uJTIwdGhlJTIwbW9vbi4lMjIpJTBBaW1hZ2Uuc2F2ZSglMjJhc3Ryb25hdXQucG5nJTIyKSUwQSUwQWltYWdlJTIwJTNEJTIwY2xpZW50LnRleHRfdG9faW1hZ2UoJTBBJTIwJTIwJTIwJTIwJTIyQW4lMjBhc3Ryb25hdXQlMjByaWRpbmclMjBhJTIwaG9yc2UlMjBvbiUyMHRoZSUyMG1vb24uJTIyJTJDJTBBJTIwJTIwJTIwJTIwbmVnYXRpdmVfcHJvbXB0JTNEJTIybG93JTIwcmVzb2x1dGlvbiUyQyUyMGJsdXJyeSUyMiUyQyUwQSUyMCUyMCUyMCUyMG1vZGVsJTNEJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLTItMSUyMiUyQyUwQSklMEFpbWFnZS5zYXZlKCUyMmJldHRlcl9hc3Ryb25hdXQucG5nJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()

<span class="hljs-meta">&gt;&gt;&gt; </span>image = client.text_to_image(<span class="hljs-string">&quot;An astronaut riding a horse on the moon.&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image.save(<span class="hljs-string">&quot;astronaut.png&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>image = client.text_to_image(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;An astronaut riding a horse on the moon.&quot;</span>,
<span class="hljs-meta">... </span>    negative_prompt=<span class="hljs-string">&quot;low resolution, blurry&quot;</span>,
<span class="hljs-meta">... </span>    model=<span class="hljs-string">&quot;stabilityai/stable-diffusion-2-1&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image.save(<span class="hljs-string">&quot;better_astronaut.png&quot;</span>)`,wrap:!1}}),{c(){n=g("p"),n.textContent=u,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=u),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:x,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),M(t,e)}}}function Fh(I){let n,u="Example:",a,t,o;return t=new q({props:{code:"ZnJvbSUyMHBhdGhsaWIlMjBpbXBvcnQlMjBQYXRoJTBBZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBJTBBYXVkaW8lMjAlM0QlMjBjbGllbnQudGV4dF90b19zcGVlY2goJTIySGVsbG8lMjB3b3JsZCUyMiklMEFQYXRoKCUyMmhlbGxvX3dvcmxkLmZsYWMlMjIpLndyaXRlX2J5dGVzKGF1ZGlvKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> pathlib <span class="hljs-keyword">import</span> Path
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()

<span class="hljs-meta">&gt;&gt;&gt; </span>audio = client.text_to_speech(<span class="hljs-string">&quot;Hello world&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>Path(<span class="hljs-string">&quot;hello_world.flac&quot;</span>).write_bytes(audio)`,wrap:!1}}),{c(){n=g("p"),n.textContent=u,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=u),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:x,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),M(t,e)}}}function zh(I){let n,u="Example:",a,t,o;return t=new q({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBY2xpZW50LnRva2VuX2NsYXNzaWZpY2F0aW9uKCUyMk15JTIwbmFtZSUyMGlzJTIwU2FyYWglMjBKZXNzaWNhJTIwUGFya2VyJTIwYnV0JTIweW91JTIwY2FuJTIwY2FsbCUyMG1lJTIwSmVzc2ljYSUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.token_classification(<span class="hljs-string">&quot;My name is Sarah Jessica Parker but you can call me Jessica&quot;</span>)
[
    TokenClassificationOutputElement(
        entity_group=<span class="hljs-string">&#x27;PER&#x27;</span>,
        score=<span class="hljs-number">0.9971321225166321</span>,
        word=<span class="hljs-string">&#x27;Sarah Jessica Parker&#x27;</span>,
        start=<span class="hljs-number">11</span>,
        end=<span class="hljs-number">31</span>,
    ),
    TokenClassificationOutputElement(
        entity_group=<span class="hljs-string">&#x27;PER&#x27;</span>,
        score=<span class="hljs-number">0.9773476123809814</span>,
        word=<span class="hljs-string">&#x27;Jessica&#x27;</span>,
        start=<span class="hljs-number">52</span>,
        end=<span class="hljs-number">59</span>,
    )
]`,wrap:!1}}),{c(){n=g("p"),n.textContent=u,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=u),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:x,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),M(t,e)}}}function Lh(I){let n,u="Example:",a,t,o;return t=new q({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBY2xpZW50LnRyYW5zbGF0aW9uKCUyMk15JTIwbmFtZSUyMGlzJTIwV29sZmdhbmclMjBhbmQlMjBJJTIwbGl2ZSUyMGluJTIwQmVybGluJTIyKSUwQWNsaWVudC50cmFuc2xhdGlvbiglMjJNeSUyMG5hbWUlMjBpcyUyMFdvbGZnYW5nJTIwYW5kJTIwSSUyMGxpdmUlMjBpbiUyMEJlcmxpbiUyMiUyQyUyMG1vZGVsJTNEJTIySGVsc2lua2ktTkxQJTJGb3B1cy1tdC1lbi1mciUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.translation(<span class="hljs-string">&quot;My name is Wolfgang and I live in Berlin&quot;</span>)
<span class="hljs-string">&#x27;Mein Name ist Wolfgang und ich lebe in Berlin.&#x27;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>client.translation(<span class="hljs-string">&quot;My name is Wolfgang and I live in Berlin&quot;</span>, model=<span class="hljs-string">&quot;Helsinki-NLP/opus-mt-en-fr&quot;</span>)
TranslationOutput(translation_text=<span class="hljs-string">&#x27;Je m&#x27;</span>appelle Wolfgang et je vis à Berlin.<span class="hljs-string">&#x27;)</span>`,wrap:!1}}),{c(){n=g("p"),n.textContent=u,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=u),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:x,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),M(t,e)}}}function Ph(I){let n,u="Specifying languages:",a,t,o;return t=new q({props:{code:"Y2xpZW50LnRyYW5zbGF0aW9uKCUyMk15JTIwbmFtZSUyMGlzJTIwU2FyYWglMjBKZXNzaWNhJTIwUGFya2VyJTIwYnV0JTIweW91JTIwY2FuJTIwY2FsbCUyMG1lJTIwSmVzc2ljYSUyMiUyQyUyMG1vZGVsJTNEJTIyZmFjZWJvb2slMkZtYmFydC1sYXJnZS01MC1tYW55LXRvLW1hbnktbW10JTIyJTJDJTIwc3JjX2xhbmclM0QlMjJlbl9YWCUyMiUyQyUyMHRndF9sYW5nJTNEJTIyZnJfWFglMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>client.translation(<span class="hljs-string">&quot;My name is Sarah Jessica Parker but you can call me Jessica&quot;</span>, model=<span class="hljs-string">&quot;facebook/mbart-large-50-many-to-many-mmt&quot;</span>, src_lang=<span class="hljs-string">&quot;en_XX&quot;</span>, tgt_lang=<span class="hljs-string">&quot;fr_XX&quot;</span>)
<span class="hljs-string">&quot;Mon nom est Sarah Jessica Parker mais vous pouvez m&#x27;appeler Jessica&quot;</span>`,wrap:!1}}),{c(){n=g("p"),n.textContent=u,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-mhcj6c"&&(n.textContent=u),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:x,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),M(t,e)}}}function Oh(I){let n,u="Example:",a,t,o;return t=new q({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBY2xpZW50LnZpc3VhbF9xdWVzdGlvbl9hbnN3ZXJpbmcoJTBBJTIwJTIwJTIwJTIwaW1hZ2UlM0QlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZtaXNoaWclMkZzYW1wbGVfaW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZ0aWdlci5qcGclMjIlMkMlMEElMjAlMjAlMjAlMjBxdWVzdGlvbiUzRCUyMldoYXQlMjBpcyUyMHRoZSUyMGFuaW1hbCUyMGRvaW5nJTNGJTIyJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.visual_question_answering(
<span class="hljs-meta">... </span>    image=<span class="hljs-string">&quot;https://huggingface.co/datasets/mishig/sample_images/resolve/main/tiger.jpg&quot;</span>,
<span class="hljs-meta">... </span>    question=<span class="hljs-string">&quot;What is the animal doing?&quot;</span>
<span class="hljs-meta">... </span>)
[
    VisualQuestionAnsweringOutputElement(score=<span class="hljs-number">0.778609573841095</span>, answer=<span class="hljs-string">&#x27;laying down&#x27;</span>),
    VisualQuestionAnsweringOutputElement(score=<span class="hljs-number">0.6957435607910156</span>, answer=<span class="hljs-string">&#x27;sitting&#x27;</span>),
]`,wrap:!1}}),{c(){n=g("p"),n.textContent=u,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=u),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:x,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),M(t,e)}}}function Kh(I){let n,u="Example:",a,t,o;return t=new q({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBdGV4dCUyMCUzRCUyMCglMEElMjAlMjAlMjAlMjAlMjJBJTIwbmV3JTIwbW9kZWwlMjBvZmZlcnMlMjBhbiUyMGV4cGxhbmF0aW9uJTIwZm9yJTIwaG93JTIwdGhlJTIwR2FsaWxlYW4lMjBzYXRlbGxpdGVzJTIwZm9ybWVkJTIwYXJvdW5kJTIwdGhlJTIwc29sYXIlMjBzeXN0ZW0ncyUyMiUwQSUyMCUyMCUyMCUyMCUyMmxhcmdlc3QlMjB3b3JsZC4lMjBLb25zdGFudGluJTIwQmF0eWdpbiUyMGRpZCUyMG5vdCUyMHNldCUyMG91dCUyMHRvJTIwc29sdmUlMjBvbmUlMjBvZiUyMHRoZSUyMHNvbGFyJTIwc3lzdGVtJ3MlMjBtb3N0JTIwcHV6emxpbmclMjIlMEElMjAlMjAlMjAlMjAlMjIlMjBteXN0ZXJpZXMlMjB3aGVuJTIwaGUlMjB3ZW50JTIwZm9yJTIwYSUyMHJ1biUyMHVwJTIwYSUyMGhpbGwlMjBpbiUyME5pY2UlMkMlMjBGcmFuY2UuJTIyJTBBKSUwQWxhYmVscyUyMCUzRCUyMCU1QiUyMnNwYWNlJTIwJTI2JTIwY29zbW9zJTIyJTJDJTIwJTIyc2NpZW50aWZpYyUyMGRpc2NvdmVyeSUyMiUyQyUyMCUyMm1pY3JvYmlvbG9neSUyMiUyQyUyMCUyMnJvYm90cyUyMiUyQyUyMCUyMmFyY2hlb2xvZ3klMjIlNUQlMEFjbGllbnQuemVyb19zaG90X2NsYXNzaWZpY2F0aW9uKHRleHQlMkMlMjBsYWJlbHMpJTBBY2xpZW50Lnplcm9fc2hvdF9jbGFzc2lmaWNhdGlvbih0ZXh0JTJDJTIwbGFiZWxzJTJDJTIwbXVsdGlfbGFiZWwlM0RUcnVlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>text = (
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;A new model offers an explanation for how the Galilean satellites formed around the solar system&#x27;s&quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;largest world. Konstantin Batygin did not set out to solve one of the solar system&#x27;s most puzzling&quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot; mysteries when he went for a run up a hill in Nice, France.&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>labels = [<span class="hljs-string">&quot;space &amp; cosmos&quot;</span>, <span class="hljs-string">&quot;scientific discovery&quot;</span>, <span class="hljs-string">&quot;microbiology&quot;</span>, <span class="hljs-string">&quot;robots&quot;</span>, <span class="hljs-string">&quot;archeology&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>client.zero_shot_classification(text, labels)
[
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;scientific discovery&#x27;</span>, score=<span class="hljs-number">0.7961668968200684</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;space &amp; cosmos&#x27;</span>, score=<span class="hljs-number">0.18570658564567566</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;microbiology&#x27;</span>, score=<span class="hljs-number">0.00730885099619627</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;archeology&#x27;</span>, score=<span class="hljs-number">0.006258360575884581</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;robots&#x27;</span>, score=<span class="hljs-number">0.004559356719255447</span>),
]
<span class="hljs-meta">&gt;&gt;&gt; </span>client.zero_shot_classification(text, labels, multi_label=<span class="hljs-literal">True</span>)
[
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;scientific discovery&#x27;</span>, score=<span class="hljs-number">0.9829297661781311</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;space &amp; cosmos&#x27;</span>, score=<span class="hljs-number">0.755190908908844</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;microbiology&#x27;</span>, score=<span class="hljs-number">0.0005462635890580714</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;archeology&#x27;</span>, score=<span class="hljs-number">0.00047131875180639327</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;robots&#x27;</span>, score=<span class="hljs-number">0.00030448526376858354</span>),
]`,wrap:!1}}),{c(){n=g("p"),n.textContent=u,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=u),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:x,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),M(t,e)}}}function ed(I){let n,u="Example:",a,t,o;return t=new q({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBJTBBY2xpZW50Lnplcm9fc2hvdF9pbWFnZV9jbGFzc2lmaWNhdGlvbiglMEElMjAlMjAlMjAlMjAlMjJodHRwcyUzQSUyRiUyRnVwbG9hZC53aWtpbWVkaWEub3JnJTJGd2lraXBlZGlhJTJGY29tbW9ucyUyRnRodW1iJTJGNCUyRjQzJTJGQ3V0ZV9kb2cuanBnJTJGMzIwcHgtQ3V0ZV9kb2cuanBnJTIyJTJDJTBBJTIwJTIwJTIwJTIwbGFiZWxzJTNEJTVCJTIyZG9nJTIyJTJDJTIwJTIyY2F0JTIyJTJDJTIwJTIyaG9yc2UlMjIlNUQlMkMlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()

<span class="hljs-meta">&gt;&gt;&gt; </span>client.zero_shot_image_classification(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://upload.wikimedia.org/wikipedia/commons/thumb/4/43/Cute_dog.jpg/320px-Cute_dog.jpg&quot;</span>,
<span class="hljs-meta">... </span>    labels=[<span class="hljs-string">&quot;dog&quot;</span>, <span class="hljs-string">&quot;cat&quot;</span>, <span class="hljs-string">&quot;horse&quot;</span>],
<span class="hljs-meta">... </span>)
[ZeroShotImageClassificationOutputElement(label=<span class="hljs-string">&#x27;dog&#x27;</span>, score=<span class="hljs-number">0.956</span>),...]`,wrap:!1}}),{c(){n=g("p"),n.textContent=u,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=u),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:x,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),M(t,e)}}}function nd(I){let n,u="Example:",a,t,o;return t=new q({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQWF3YWl0JTIwY2xpZW50LmF1ZGlvX2NsYXNzaWZpY2F0aW9uKCUyMmF1ZGlvLmZsYWMlMjIp",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.audio_classification(<span class="hljs-string">&quot;audio.flac&quot;</span>)
[
    AudioClassificationOutputElement(score=<span class="hljs-number">0.4976358711719513</span>, label=<span class="hljs-string">&#x27;hap&#x27;</span>),
    AudioClassificationOutputElement(score=<span class="hljs-number">0.3677836060523987</span>, label=<span class="hljs-string">&#x27;neu&#x27;</span>),
    ...
]`,wrap:!1}}),{c(){n=g("p"),n.textContent=u,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=u),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:x,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),M(t,e)}}}function td(I){let n,u="Example:",a,t,o;return t=new q({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQWF1ZGlvX291dHB1dCUyMCUzRCUyMGF3YWl0JTIwY2xpZW50LmF1ZGlvX3RvX2F1ZGlvKCUyMmF1ZGlvLmZsYWMlMjIpJTBBYXN5bmMlMjBmb3IlMjBpJTJDJTIwaXRlbSUyMGluJTIwZW51bWVyYXRlKGF1ZGlvX291dHB1dCklM0ElMEElMjAlMjAlMjAlMjB3aXRoJTIwb3BlbihmJTIyb3V0cHV0XyU3QmklN0QuZmxhYyUyMiUyQyUyMCUyMndiJTIyKSUyMGFzJTIwZiUzQQ==",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>audio_output = <span class="hljs-keyword">await</span> client.audio_to_audio(<span class="hljs-string">&quot;audio.flac&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">async</span> <span class="hljs-keyword">for</span> i, item <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(audio_output):
<span class="hljs-meta">&gt;&gt;&gt; </span>    <span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">f&quot;output_<span class="hljs-subst">{i}</span>.flac&quot;</span>, <span class="hljs-string">&quot;wb&quot;</span>) <span class="hljs-keyword">as</span> f:
            f.write(item.blob)`,wrap:!1}}),{c(){n=g("p"),n.textContent=u,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=u),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:x,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),M(t,e)}}}function sd(I){let n,u="Example:",a,t,o;return t=new q({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQWF3YWl0JTIwY2xpZW50LmF1dG9tYXRpY19zcGVlY2hfcmVjb2duaXRpb24oJTIyaGVsbG9fd29ybGQuZmxhYyUyMikudGV4dA==",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.automatic_speech_recognition(<span class="hljs-string">&quot;hello_world.flac&quot;</span>).text
<span class="hljs-string">&quot;hello world&quot;</span>`,wrap:!1}}),{c(){n=g("p"),n.textContent=u,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=u),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:x,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),M(t,e)}}}function ad(I){let n,u="Example:",a,t,o;return t=new q({props:{code:"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",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-comment"># Chat example</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>messages = [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What is the capital of France?&quot;</span>}]
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient(<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-8B-Instruct&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.chat_completion(messages, max_tokens=<span class="hljs-number">100</span>)
ChatCompletionOutput(
    choices=[
        ChatCompletionOutputComplete(
            finish_reason=<span class="hljs-string">&#x27;eos_token&#x27;</span>,
            index=<span class="hljs-number">0</span>,
            message=ChatCompletionOutputMessage(
                role=<span class="hljs-string">&#x27;assistant&#x27;</span>,
                content=<span class="hljs-string">&#x27;The capital of France is Paris.&#x27;</span>,
                name=<span class="hljs-literal">None</span>,
                tool_calls=<span class="hljs-literal">None</span>
            ),
            logprobs=<span class="hljs-literal">None</span>
        )
    ],
    created=<span class="hljs-number">1719907176</span>,
    <span class="hljs-built_in">id</span>=<span class="hljs-string">&#x27;&#x27;</span>,
    model=<span class="hljs-string">&#x27;meta-llama/Meta-Llama-3-8B-Instruct&#x27;</span>,
    <span class="hljs-built_in">object</span>=<span class="hljs-string">&#x27;text_completion&#x27;</span>,
    system_fingerprint=<span class="hljs-string">&#x27;2.0.4-sha-f426a33&#x27;</span>,
    usage=ChatCompletionOutputUsage(
        completion_tokens=<span class="hljs-number">8</span>,
        prompt_tokens=<span class="hljs-number">17</span>,
        total_tokens=<span class="hljs-number">25</span>
    )
)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">async</span> <span class="hljs-keyword">for</span> token <span class="hljs-keyword">in</span> <span class="hljs-keyword">await</span> client.chat_completion(messages, max_tokens=<span class="hljs-number">10</span>, stream=<span class="hljs-literal">True</span>):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(token)
ChatCompletionStreamOutput(choices=[ChatCompletionStreamOutputChoice(delta=ChatCompletionStreamOutputDelta(content=<span class="hljs-string">&#x27;The&#x27;</span>, role=<span class="hljs-string">&#x27;assistant&#x27;</span>), index=<span class="hljs-number">0</span>, finish_reason=<span class="hljs-literal">None</span>)], created=<span class="hljs-number">1710498504</span>)
ChatCompletionStreamOutput(choices=[ChatCompletionStreamOutputChoice(delta=ChatCompletionStreamOutputDelta(content=<span class="hljs-string">&#x27; capital&#x27;</span>, role=<span class="hljs-string">&#x27;assistant&#x27;</span>), index=<span class="hljs-number">0</span>, finish_reason=<span class="hljs-literal">None</span>)], created=<span class="hljs-number">1710498504</span>)
(...)
ChatCompletionStreamOutput(choices=[ChatCompletionStreamOutputChoice(delta=ChatCompletionStreamOutputDelta(content=<span class="hljs-string">&#x27; may&#x27;</span>, role=<span class="hljs-string">&#x27;assistant&#x27;</span>), index=<span class="hljs-number">0</span>, finish_reason=<span class="hljs-literal">None</span>)], created=<span class="hljs-number">1710498504</span>)

<span class="hljs-comment"># Chat example with tools</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient(<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-70B-Instruct&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>messages = [
<span class="hljs-meta">... </span>    {
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Don&#x27;t make assumptions about what values to plug into functions. Ask async for clarification if a user request is ambiguous.&quot;</span>,
<span class="hljs-meta">... </span>    },
<span class="hljs-meta">... </span>    {
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What&#x27;s the weather like the next 3 days in San Francisco, CA?&quot;</span>,
<span class="hljs-meta">... </span>    },
<span class="hljs-meta">... </span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>tools = [
<span class="hljs-meta">... </span>    {
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;function&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;function&quot;</span>: {
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;get_current_weather&quot;</span>,
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;Get the current weather&quot;</span>,
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;parameters&quot;</span>: {
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;object&quot;</span>,
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;properties&quot;</span>: {
<span class="hljs-meta">... </span>                    <span class="hljs-string">&quot;location&quot;</span>: {
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>,
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;The city and state, e.g. San Francisco, CA&quot;</span>,
<span class="hljs-meta">... </span>                    },
<span class="hljs-meta">... </span>                    <span class="hljs-string">&quot;format&quot;</span>: {
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>,
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;enum&quot;</span>: [<span class="hljs-string">&quot;celsius&quot;</span>, <span class="hljs-string">&quot;fahrenheit&quot;</span>],
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;The temperature unit to use. Infer this from the users location.&quot;</span>,
<span class="hljs-meta">... </span>                    },
<span class="hljs-meta">... </span>                },
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;required&quot;</span>: [<span class="hljs-string">&quot;location&quot;</span>, <span class="hljs-string">&quot;format&quot;</span>],
<span class="hljs-meta">... </span>            },
<span class="hljs-meta">... </span>        },
<span class="hljs-meta">... </span>    },
<span class="hljs-meta">... </span>    {
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;function&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;function&quot;</span>: {
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;get_n_day_weather_forecast&quot;</span>,
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;Get an N-day weather forecast&quot;</span>,
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;parameters&quot;</span>: {
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;object&quot;</span>,
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;properties&quot;</span>: {
<span class="hljs-meta">... </span>                    <span class="hljs-string">&quot;location&quot;</span>: {
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>,
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;The city and state, e.g. San Francisco, CA&quot;</span>,
<span class="hljs-meta">... </span>                    },
<span class="hljs-meta">... </span>                    <span class="hljs-string">&quot;format&quot;</span>: {
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>,
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;enum&quot;</span>: [<span class="hljs-string">&quot;celsius&quot;</span>, <span class="hljs-string">&quot;fahrenheit&quot;</span>],
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;The temperature unit to use. Infer this from the users location.&quot;</span>,
<span class="hljs-meta">... </span>                    },
<span class="hljs-meta">... </span>                    <span class="hljs-string">&quot;num_days&quot;</span>: {
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;integer&quot;</span>,
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;The number of days to forecast&quot;</span>,
<span class="hljs-meta">... </span>                    },
<span class="hljs-meta">... </span>                },
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;required&quot;</span>: [<span class="hljs-string">&quot;location&quot;</span>, <span class="hljs-string">&quot;format&quot;</span>, <span class="hljs-string">&quot;num_days&quot;</span>],
<span class="hljs-meta">... </span>            },
<span class="hljs-meta">... </span>        },
<span class="hljs-meta">... </span>    },
<span class="hljs-meta">... </span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>response = <span class="hljs-keyword">await</span> client.chat_completion(
<span class="hljs-meta">... </span>    model=<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-70B-Instruct&quot;</span>,
<span class="hljs-meta">... </span>    messages=messages,
<span class="hljs-meta">... </span>    tools=tools,
<span class="hljs-meta">... </span>    tool_choice=<span class="hljs-string">&quot;auto&quot;</span>,
<span class="hljs-meta">... </span>    max_tokens=<span class="hljs-number">500</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>response.choices[<span class="hljs-number">0</span>].message.tool_calls[<span class="hljs-number">0</span>].function
ChatCompletionOutputFunctionDefinition(
    arguments={
        <span class="hljs-string">&#x27;location&#x27;</span>: <span class="hljs-string">&#x27;San Francisco, CA&#x27;</span>,
        <span class="hljs-string">&#x27;format&#x27;</span>: <span class="hljs-string">&#x27;fahrenheit&#x27;</span>,
        <span class="hljs-string">&#x27;num_days&#x27;</span>: <span class="hljs-number">3</span>
    },
    name=<span class="hljs-string">&#x27;get_n_day_weather_forecast&#x27;</span>,
    description=<span class="hljs-literal">None</span>
)`,wrap:!1}}),{c(){n=g("p"),n.textContent=u,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=u),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:x,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),M(t,e)}}}function ld(I){let n,u=`<a href="/docs/huggingface_hub/pr_2368/en/package_reference/inference_client#huggingface_hub.InferenceClient.conversational">InferenceClient.conversational()</a> API is deprecated and will be removed in a future release. Please use
<a href="/docs/huggingface_hub/pr_2368/en/package_reference/inference_client#huggingface_hub.InferenceClient.chat_completion">InferenceClient.chat_completion()</a> instead.`;return{c(){n=g("p"),n.innerHTML=u},l(a){n=m(a,"P",{"data-svelte-h":!0}),T(n)!=="svelte-167gp02"&&(n.innerHTML=u)},m(a,t){_(a,n,t)},p:x,d(a){a&&p(n)}}}function od(I){let n,u="Example:",a,t,o;return t=new q({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQW91dHB1dCUyMCUzRCUyMGF3YWl0JTIwY2xpZW50LmNvbnZlcnNhdGlvbmFsKCUyMkhpJTJDJTIwd2hvJTIwYXJlJTIweW91JTNGJTIyKSUwQW91dHB1dCUwQWF3YWl0JTIwY2xpZW50LmNvbnZlcnNhdGlvbmFsKCUwQSUyMCUyMCUyMCUyMCUyMldvdyUyQyUyMHRoYXQncyUyMHNjYXJ5ISUyMiUyQyUwQSUyMCUyMCUyMCUyMGdlbmVyYXRlZF9yZXNwb25zZXMlM0RvdXRwdXQlNUIlMjJjb252ZXJzYXRpb24lMjIlNUQlNUIlMjJnZW5lcmF0ZWRfcmVzcG9uc2VzJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwcGFzdF91c2VyX2lucHV0cyUzRG91dHB1dCU1QiUyMmNvbnZlcnNhdGlvbiUyMiU1RCU1QiUyMnBhc3RfdXNlcl9pbnB1dHMlMjIlNUQlMkMlMEEp",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>output = <span class="hljs-keyword">await</span> client.conversational(<span class="hljs-string">&quot;Hi, who are you?&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>output
{<span class="hljs-string">&#x27;generated_text&#x27;</span>: <span class="hljs-string">&#x27;I am the one who knocks.&#x27;</span>, <span class="hljs-string">&#x27;conversation&#x27;</span>: {<span class="hljs-string">&#x27;generated_responses&#x27;</span>: [<span class="hljs-string">&#x27;I am the one who knocks.&#x27;</span>], <span class="hljs-string">&#x27;past_user_inputs&#x27;</span>: [<span class="hljs-string">&#x27;Hi, who are you?&#x27;</span>]}, <span class="hljs-string">&#x27;warnings&#x27;</span>: [<span class="hljs-string">&#x27;Setting \`pad_token_id\` to \`eos_token_id\`:50256 async for open-end generation.&#x27;</span>]}
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.conversational(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Wow, that&#x27;s scary!&quot;</span>,
<span class="hljs-meta">... </span>    generated_responses=output[<span class="hljs-string">&quot;conversation&quot;</span>][<span class="hljs-string">&quot;generated_responses&quot;</span>],
<span class="hljs-meta">... </span>    past_user_inputs=output[<span class="hljs-string">&quot;conversation&quot;</span>][<span class="hljs-string">&quot;past_user_inputs&quot;</span>],
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){n=g("p"),n.textContent=u,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=u),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:x,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),M(t,e)}}}function rd(I){let n,u="Example:",a,t,o;return t=new q({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQWF3YWl0JTIwY2xpZW50LmRvY3VtZW50X3F1ZXN0aW9uX2Fuc3dlcmluZyhpbWFnZSUzRCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZzcGFjZXMlMkZpbXBpcmElMkZkb2NxdWVyeSUyRnJlc29sdmUlMkYyMzU5MjIzYzE4MzdhNzU4NzQwMmJkYTBmMjY0MzM4MmE2ZWVmZWFiJTJGaW52b2ljZS5wbmclMjIlMkMlMjBxdWVzdGlvbiUzRCUyMldoYXQlMjBpcyUyMHRoZSUyMGludm9pY2UlMjBudW1iZXIlM0YlMjIp",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.document_question_answering(image=<span class="hljs-string">&quot;https://huggingface.co/spaces/impira/docquery/resolve/2359223c1837a7587402bda0f2643382a6eefeab/invoice.png&quot;</span>, question=<span class="hljs-string">&quot;What is the invoice number?&quot;</span>)
[DocumentQuestionAnsweringOutputElement(score=<span class="hljs-number">0.42515629529953003</span>, answer=<span class="hljs-string">&#x27;us-001&#x27;</span>, start=<span class="hljs-number">16</span>, end=<span class="hljs-number">16</span>)]`,wrap:!1}}),{c(){n=g("p"),n.textContent=u,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=u),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:x,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),M(t,e)}}}function id(I){let n,u="Example:",a,t,o;return t=new q({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQWF3YWl0JTIwY2xpZW50LmZlYXR1cmVfZXh0cmFjdGlvbiglMjJIaSUyQyUyMHdobyUyMGFyZSUyMHlvdSUzRiUyMik=",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.feature_extraction(<span class="hljs-string">&quot;Hi, who are you?&quot;</span>)
array([[ <span class="hljs-number">2.424802</span>  ,  <span class="hljs-number">2.93384</span>   ,  <span class="hljs-number">1.1750331</span> , ...,  <span class="hljs-number">1.240499</span>, -<span class="hljs-number">0.13776633</span>, -<span class="hljs-number">0.7889173</span> ],
[-<span class="hljs-number">0.42943227</span>, -<span class="hljs-number">0.6364878</span> , -<span class="hljs-number">1.693462</span>  , ...,  <span class="hljs-number">0.41978157</span>, -<span class="hljs-number">2.4336355</span> ,  <span class="hljs-number">0.6162071</span> ],
...,
[ <span class="hljs-number">0.28552425</span>, -<span class="hljs-number">0.928395</span>  , -<span class="hljs-number">1.2077185</span> , ...,  <span class="hljs-number">0.76810825</span>, -<span class="hljs-number">2.1069427</span> ,  <span class="hljs-number">0.6236161</span> ]], dtype=float32)`,wrap:!1}}),{c(){n=g("p"),n.textContent=u,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=u),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:x,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),M(t,e)}}}function cd(I){let n,u="Example:",a,t,o;return t=new q({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQWF3YWl0JTIwY2xpZW50LmZpbGxfbWFzayglMjJUaGUlMjBnb2FsJTIwb2YlMjBsaWZlJTIwaXMlMjAlM0NtYXNrJTNFLiUyMik=",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.fill_mask(<span class="hljs-string">&quot;The goal of life is &lt;mask&gt;.&quot;</span>)
[
    FillMaskOutputElement(score=<span class="hljs-number">0.06897063553333282</span>, token=<span class="hljs-number">11098</span>, token_str=<span class="hljs-string">&#x27; happiness&#x27;</span>, sequence=<span class="hljs-string">&#x27;The goal of life is happiness.&#x27;</span>),
    FillMaskOutputElement(score=<span class="hljs-number">0.06554922461509705</span>, token=<span class="hljs-number">45075</span>, token_str=<span class="hljs-string">&#x27; immortality&#x27;</span>, sequence=<span class="hljs-string">&#x27;The goal of life is immortality.&#x27;</span>)
]`,wrap:!1}}),{c(){n=g("p"),n.textContent=u,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=u),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:x,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),M(t,e)}}}function pd(I){let n,u="Example:",a,t,o;return t=new q({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoJTIybWV0YS1sbGFtYSUyRk1ldGEtTGxhbWEtMy03MEItSW5zdHJ1Y3QlMjIpJTBBYXdhaXQlMjBjbGllbnQuZ2V0X2VuZHBvaW50X2luZm8oKQ==",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient(<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-70B-Instruct&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.get_endpoint_info()
{
    <span class="hljs-string">&#x27;model_id&#x27;</span>: <span class="hljs-string">&#x27;meta-llama/Meta-Llama-3-70B-Instruct&#x27;</span>,
    <span class="hljs-string">&#x27;model_sha&#x27;</span>: <span class="hljs-literal">None</span>,
    <span class="hljs-string">&#x27;model_dtype&#x27;</span>: <span class="hljs-string">&#x27;torch.float16&#x27;</span>,
    <span class="hljs-string">&#x27;model_device_type&#x27;</span>: <span class="hljs-string">&#x27;cuda&#x27;</span>,
    <span class="hljs-string">&#x27;model_pipeline_tag&#x27;</span>: <span class="hljs-literal">None</span>,
    <span class="hljs-string">&#x27;max_concurrent_requests&#x27;</span>: <span class="hljs-number">128</span>,
    <span class="hljs-string">&#x27;max_best_of&#x27;</span>: <span class="hljs-number">2</span>,
    <span class="hljs-string">&#x27;max_stop_sequences&#x27;</span>: <span class="hljs-number">4</span>,
    <span class="hljs-string">&#x27;max_input_length&#x27;</span>: <span class="hljs-number">8191</span>,
    <span class="hljs-string">&#x27;max_total_tokens&#x27;</span>: <span class="hljs-number">8192</span>,
    <span class="hljs-string">&#x27;waiting_served_ratio&#x27;</span>: <span class="hljs-number">0.3</span>,
    <span class="hljs-string">&#x27;max_batch_total_tokens&#x27;</span>: <span class="hljs-number">1259392</span>,
    <span class="hljs-string">&#x27;max_waiting_tokens&#x27;</span>: <span class="hljs-number">20</span>,
    <span class="hljs-string">&#x27;max_batch_size&#x27;</span>: <span class="hljs-literal">None</span>,
    <span class="hljs-string">&#x27;validation_workers&#x27;</span>: <span class="hljs-number">32</span>,
    <span class="hljs-string">&#x27;max_client_batch_size&#x27;</span>: <span class="hljs-number">4</span>,
    <span class="hljs-string">&#x27;version&#x27;</span>: <span class="hljs-string">&#x27;2.0.2&#x27;</span>,
    <span class="hljs-string">&#x27;sha&#x27;</span>: <span class="hljs-string">&#x27;dccab72549635c7eb5ddb17f43f0b7cdff07c214&#x27;</span>,
    <span class="hljs-string">&#x27;docker_label&#x27;</span>: <span class="hljs-string">&#x27;sha-dccab72&#x27;</span>
}`,wrap:!1}}),{c(){n=g("p"),n.textContent=u,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=u),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:x,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),M(t,e)}}}function ud(I){let n,u=`This endpoint is mostly useful when you already know which model you want to use and want to check its
availability. If you want to discover already deployed models, you should rather use <a href="/docs/huggingface_hub/pr_2368/en/package_reference/inference_client#huggingface_hub.InferenceClient.list_deployed_models">list_deployed_models()</a>.`;return{c(){n=g("p"),n.innerHTML=u},l(a){n=m(a,"P",{"data-svelte-h":!0}),T(n)!=="svelte-1rb7cag"&&(n.innerHTML=u)},m(a,t){_(a,n,t)},p:x,d(a){a&&p(n)}}}function gd(I){let n,u="Example:",a,t,o;return t=new q({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQWF3YWl0JTIwY2xpZW50LmdldF9tb2RlbF9zdGF0dXMoJTIyYmlnY29kZSUyRnN0YXJjb2RlciUyMik=",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.get_model_status(<span class="hljs-string">&quot;bigcode/starcoder&quot;</span>)
ModelStatus(loaded=<span class="hljs-literal">True</span>, state=<span class="hljs-string">&#x27;Loaded&#x27;</span>, compute_type=<span class="hljs-string">&#x27;gpu&#x27;</span>, framework=<span class="hljs-string">&#x27;text-generation-inference&#x27;</span>)`,wrap:!1}}),{c(){n=g("p"),n.textContent=u,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=u),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:x,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),M(t,e)}}}function md(I){let n,u="Example:",a,t,o;return t=new q({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoJTIyaHR0cHMlM0ElMkYlMkZqemd1MGJ1ZWk1LnVzLWVhc3QtMS5hd3MuZW5kcG9pbnRzLmh1Z2dpbmdmYWNlLmNsb3VkJTIyKSUwQWF3YWl0JTIwY2xpZW50LmhlYWx0aF9jaGVjaygp",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient(<span class="hljs-string">&quot;https://jzgu0buei5.us-east-1.aws.endpoints.huggingface.cloud&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.health_check()
<span class="hljs-literal">True</span>`,wrap:!1}}),{c(){n=g("p"),n.textContent=u,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=u),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:x,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),M(t,e)}}}function hd(I){let n,u="Example:",a,t,o;return t=new q({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQWF3YWl0JTIwY2xpZW50LmltYWdlX2NsYXNzaWZpY2F0aW9uKCUyMmh0dHBzJTNBJTJGJTJGdXBsb2FkLndpa2ltZWRpYS5vcmclMkZ3aWtpcGVkaWElMkZjb21tb25zJTJGdGh1bWIlMkY0JTJGNDMlMkZDdXRlX2RvZy5qcGclMkYzMjBweC1DdXRlX2RvZy5qcGclMjIp",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.image_classification(<span class="hljs-string">&quot;https://upload.wikimedia.org/wikipedia/commons/thumb/4/43/Cute_dog.jpg/320px-Cute_dog.jpg&quot;</span>)
[ImageClassificationOutputElement(score=<span class="hljs-number">0.9779096841812134</span>, label=<span class="hljs-string">&#x27;Blenheim spaniel&#x27;</span>), ...]`,wrap:!1}}),{c(){n=g("p"),n.textContent=u,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=u),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:x,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),M(t,e)}}}function dd(I){let n,u="You must have <code>PIL</code> installed if you want to work with images (<code>pip install Pillow</code>).";return{c(){n=g("p"),n.innerHTML=u},l(a){n=m(a,"P",{"data-svelte-h":!0}),T(n)!=="svelte-s2e3n9"&&(n.innerHTML=u)},m(a,t){_(a,n,t)},p:x,d(a){a&&p(n)}}}function fd(I){let n,u="Example:",a,t,o;return t=new q({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQWF3YWl0JTIwY2xpZW50LmltYWdlX3NlZ21lbnRhdGlvbiglMjJjYXQuanBnJTIyKSUzQQ==",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.image_segmentation(<span class="hljs-string">&quot;cat.jpg&quot;</span>):
[ImageSegmentationOutputElement(score=<span class="hljs-number">0.989008</span>, label=<span class="hljs-string">&#x27;LABEL_184&#x27;</span>, mask=&lt;PIL.PngImagePlugin.PngImageFile image mode=L size=400x300 at <span class="hljs-number">0x7FDD2B129CC0</span>&gt;), ...]`,wrap:!1}}),{c(){n=g("p"),n.textContent=u,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=u),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:x,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),M(t,e)}}}function yd(I){let n,u="You must have <code>PIL</code> installed if you want to work with images (<code>pip install Pillow</code>).";return{c(){n=g("p"),n.innerHTML=u},l(a){n=m(a,"P",{"data-svelte-h":!0}),T(n)!=="svelte-s2e3n9"&&(n.innerHTML=u)},m(a,t){_(a,n,t)},p:x,d(a){a&&p(n)}}}function bd(I){let n,u="Example:",a,t,o;return t=new q({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQWltYWdlJTIwJTNEJTIwYXdhaXQlMjBjbGllbnQuaW1hZ2VfdG9faW1hZ2UoJTIyY2F0LmpwZyUyMiUyQyUyMHByb21wdCUzRCUyMnR1cm4lMjB0aGUlMjBjYXQlMjBpbnRvJTIwYSUyMHRpZ2VyJTIyKSUwQWltYWdlLnNhdmUoJTIydGlnZXIuanBnJTIyKQ==",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>image = <span class="hljs-keyword">await</span> client.image_to_image(<span class="hljs-string">&quot;cat.jpg&quot;</span>, prompt=<span class="hljs-string">&quot;turn the cat into a tiger&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image.save(<span class="hljs-string">&quot;tiger.jpg&quot;</span>)`,wrap:!1}}),{c(){n=g("p"),n.textContent=u,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=u),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:x,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),M(t,e)}}}function Md(I){let n,u="Example:",a,t,o;return t=new q({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQWF3YWl0JTIwY2xpZW50LmltYWdlX3RvX3RleHQoJTIyY2F0LmpwZyUyMiklMEFhd2FpdCUyMGNsaWVudC5pbWFnZV90b190ZXh0KCUyMmh0dHBzJTNBJTJGJTJGdXBsb2FkLndpa2ltZWRpYS5vcmclMkZ3aWtpcGVkaWElMkZjb21tb25zJTJGdGh1bWIlMkY0JTJGNDMlMkZDdXRlX2RvZy5qcGclMkYzMjBweC1DdXRlX2RvZy5qcGclMjIp",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.image_to_text(<span class="hljs-string">&quot;cat.jpg&quot;</span>)
<span class="hljs-string">&#x27;a cat standing in a grassy field &#x27;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.image_to_text(<span class="hljs-string">&quot;https://upload.wikimedia.org/wikipedia/commons/thumb/4/43/Cute_dog.jpg/320px-Cute_dog.jpg&quot;</span>)
<span class="hljs-string">&#x27;a dog laying on the grass next to a flower pot &#x27;</span>`,wrap:!1}}),{c(){n=g("p"),n.textContent=u,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=u),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:x,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),M(t,e)}}}function jd(I){let n,u=`This endpoint method does not return a live list of all models available for the Serverless Inference API service.
It searches over a cached list of models that were recently available and the list may not be up to date.
If you want to know the live status of a specific model, use <a href="/docs/huggingface_hub/pr_2368/en/package_reference/inference_client#huggingface_hub.InferenceClient.get_model_status">get_model_status()</a>.`;return{c(){n=g("p"),n.innerHTML=u},l(a){n=m(a,"P",{"data-svelte-h":!0}),T(n)!=="svelte-1wsu01a"&&(n.innerHTML=u)},m(a,t){_(a,n,t)},p:x,d(a){a&&p(n)}}}function _d(I){let n,u=`This endpoint method is mostly useful for discoverability. If you already know which model you want to use and want to
check its availability, you can directly use <a href="/docs/huggingface_hub/pr_2368/en/package_reference/inference_client#huggingface_hub.InferenceClient.get_model_status">get_model_status()</a>.`;return{c(){n=g("p"),n.innerHTML=u},l(a){n=m(a,"P",{"data-svelte-h":!0}),T(n)!=="svelte-2f6fs5"&&(n.innerHTML=u)},m(a,t){_(a,n,t)},p:x,d(a){a&&p(n)}}}function Td(I){let n,u="Example:",a,t,o;return t=new q({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQSUwQW1vZGVscyUyMCUzRCUyMGF3YWl0JTIwY2xpZW50Lmxpc3RfZGVwbG95ZWRfbW9kZWxzKCklMEFtb2RlbHMlNUIlMjJ6ZXJvLXNob3QtY2xhc3NpZmljYXRpb24lMjIlNUQlMEElMEFhd2FpdCUyMGNsaWVudC5saXN0X2RlcGxveWVkX21vZGVscyglMjJ0ZXh0LWdlbmVyYXRpb24taW5mZXJlbmNlJTIyKQ==",highlighted:`<span class="hljs-comment"># Must be run in an async contextthon</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()

<span class="hljs-comment"># Discover zero-shot-classification models currently deployed</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>models = <span class="hljs-keyword">await</span> client.list_deployed_models()
<span class="hljs-meta">&gt;&gt;&gt; </span>models[<span class="hljs-string">&quot;zero-shot-classification&quot;</span>]
[<span class="hljs-string">&#x27;Narsil/deberta-large-mnli-zero-cls&#x27;</span>, <span class="hljs-string">&#x27;facebook/bart-large-mnli&#x27;</span>, ...]

<span class="hljs-comment"># List from only 1 framework</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.list_deployed_models(<span class="hljs-string">&quot;text-generation-inference&quot;</span>)
{<span class="hljs-string">&#x27;text-generation&#x27;</span>: [<span class="hljs-string">&#x27;bigcode/starcoder&#x27;</span>, <span class="hljs-string">&#x27;meta-llama/Llama-2-70b-chat-hf&#x27;</span>, ...], ...}`,wrap:!1}}),{c(){n=g("p"),n.textContent=u,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=u),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:x,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),M(t,e)}}}function Id(I){let n,u="You must have <code>PIL</code> installed if you want to work with images (<code>pip install Pillow</code>).";return{c(){n=g("p"),n.innerHTML=u},l(a){n=m(a,"P",{"data-svelte-h":!0}),T(n)!=="svelte-s2e3n9"&&(n.innerHTML=u)},m(a,t){_(a,n,t)},p:x,d(a){a&&p(n)}}}function xd(I){let n,u="Example:",a,t,o;return t=new q({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQWF3YWl0JTIwY2xpZW50Lm9iamVjdF9kZXRlY3Rpb24oJTIycGVvcGxlLmpwZyUyMiklM0E=",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.object_detection(<span class="hljs-string">&quot;people.jpg&quot;</span>):
[ObjectDetectionOutputElement(score=<span class="hljs-number">0.9486683011054993</span>, label=<span class="hljs-string">&#x27;person&#x27;</span>, box=ObjectDetectionBoundingBox(xmin=<span class="hljs-number">59</span>, ymin=<span class="hljs-number">39</span>, xmax=<span class="hljs-number">420</span>, ymax=<span class="hljs-number">510</span>)), ...]`,wrap:!1}}),{c(){n=g("p"),n.textContent=u,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=u),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:x,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),M(t,e)}}}function Jd(I){let n,u="Example:",a,t,o;return t=new q({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQWF3YWl0JTIwY2xpZW50LnF1ZXN0aW9uX2Fuc3dlcmluZyhxdWVzdGlvbiUzRCUyMldoYXQncyUyMG15JTIwbmFtZSUzRiUyMiUyQyUyMGNvbnRleHQlM0QlMjJNeSUyMG5hbWUlMjBpcyUyMENsYXJhJTIwYW5kJTIwSSUyMGxpdmUlMjBpbiUyMEJlcmtlbGV5LiUyMik=",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.question_answering(question=<span class="hljs-string">&quot;What&#x27;s my name?&quot;</span>, context=<span class="hljs-string">&quot;My name is Clara and I live in Berkeley.&quot;</span>)
QuestionAnsweringOutputElement(score=<span class="hljs-number">0.9326562285423279</span>, start=<span class="hljs-number">11</span>, end=<span class="hljs-number">16</span>, answer=<span class="hljs-string">&#x27;Clara&#x27;</span>)`,wrap:!1}}),{c(){n=g("p"),n.textContent=u,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=u),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:x,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),M(t,e)}}}function wd(I){let n,u="Example:",a,t,o;return t=new q({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQWF3YWl0JTIwY2xpZW50LnNlbnRlbmNlX3NpbWlsYXJpdHkoJTBBJTIwJTIwJTIwJTIwJTIyTWFjaGluZSUyMGxlYXJuaW5nJTIwaXMlMjBzbyUyMGVhc3kuJTIyJTJDJTBBJTIwJTIwJTIwJTIwb3RoZXJfc2VudGVuY2VzJTNEJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyRGVlcCUyMGxlYXJuaW5nJTIwaXMlMjBzbyUyMHN0cmFpZ2h0Zm9yd2FyZC4lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJUaGlzJTIwaXMlMjBzbyUyMGRpZmZpY3VsdCUyQyUyMGxpa2UlMjByb2NrZXQlMjBzY2llbmNlLiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMkklMjBjYW4ndCUyMGJlbGlldmUlMjBob3clMjBtdWNoJTIwSSUyMHN0cnVnZ2xlZCUyMHdpdGglMjB0aGlzLiUyMiUyQyUwQSUyMCUyMCUyMCUyMCU1RCUyQyUwQSk=",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.sentence_similarity(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Machine learning is so easy.&quot;</span>,
<span class="hljs-meta">... </span>    other_sentences=[
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;Deep learning is so straightforward.&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;This is so difficult, like rocket science.&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;I can&#x27;t believe how much I struggled with this.&quot;</span>,
<span class="hljs-meta">... </span>    ],
<span class="hljs-meta">... </span>)
[<span class="hljs-number">0.7785726189613342</span>, <span class="hljs-number">0.45876261591911316</span>, <span class="hljs-number">0.2906220555305481</span>]`,wrap:!1}}),{c(){n=g("p"),n.textContent=u,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=u),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:x,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),M(t,e)}}}function Cd(I){let n,u="Example:",a,t,o;return t=new q({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQWF3YWl0JTIwY2xpZW50LnN1bW1hcml6YXRpb24oJTIyVGhlJTIwRWlmZmVsJTIwdG93ZXIuLi4lMjIp",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.summarization(<span class="hljs-string">&quot;The Eiffel tower...&quot;</span>)
SummarizationOutput(generated_text=<span class="hljs-string">&quot;The Eiffel tower is one of the most famous landmarks in the world....&quot;</span>)`,wrap:!1}}),{c(){n=g("p"),n.textContent=u,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=u),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:x,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),M(t,e)}}}function Ud(I){let n,u="Example:",a,t,o;return t=new q({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQXF1ZXJ5JTIwJTNEJTIwJTIySG93JTIwbWFueSUyMHN0YXJzJTIwZG9lcyUyMHRoZSUyMHRyYW5zZm9ybWVycyUyMHJlcG9zaXRvcnklMjBoYXZlJTNGJTIyJTBBdGFibGUlMjAlM0QlMjAlN0IlMjJSZXBvc2l0b3J5JTIyJTNBJTIwJTVCJTIyVHJhbnNmb3JtZXJzJTIyJTJDJTIwJTIyRGF0YXNldHMlMjIlMkMlMjAlMjJUb2tlbml6ZXJzJTIyJTVEJTJDJTIwJTIyU3RhcnMlMjIlM0ElMjAlNUIlMjIzNjU0MiUyMiUyQyUyMCUyMjQ1MTIlMjIlMkMlMjAlMjIzOTM0JTIyJTVEJTdEJTBBYXdhaXQlMjBjbGllbnQudGFibGVfcXVlc3Rpb25fYW5zd2VyaW5nKHRhYmxlJTJDJTIwcXVlcnklMkMlMjBtb2RlbCUzRCUyMmdvb2dsZSUyRnRhcGFzLWJhc2UtZmluZXR1bmVkLXd0cSUyMik=",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>query = <span class="hljs-string">&quot;How many stars does the transformers repository have?&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>table = {<span class="hljs-string">&quot;Repository&quot;</span>: [<span class="hljs-string">&quot;Transformers&quot;</span>, <span class="hljs-string">&quot;Datasets&quot;</span>, <span class="hljs-string">&quot;Tokenizers&quot;</span>], <span class="hljs-string">&quot;Stars&quot;</span>: [<span class="hljs-string">&quot;36542&quot;</span>, <span class="hljs-string">&quot;4512&quot;</span>, <span class="hljs-string">&quot;3934&quot;</span>]}
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.table_question_answering(table, query, model=<span class="hljs-string">&quot;google/tapas-base-finetuned-wtq&quot;</span>)
TableQuestionAnsweringOutputElement(answer=<span class="hljs-string">&#x27;36542&#x27;</span>, coordinates=[[<span class="hljs-number">0</span>, <span class="hljs-number">1</span>]], cells=[<span class="hljs-string">&#x27;36542&#x27;</span>], aggregator=<span class="hljs-string">&#x27;AVERAGE&#x27;</span>)`,wrap:!1}}),{c(){n=g("p"),n.textContent=u,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=u),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:x,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),M(t,e)}}}function $d(I){let n,u="Example:",a,t,o;return t=new q({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQXRhYmxlJTIwJTNEJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIyZml4ZWRfYWNpZGl0eSUyMiUzQSUyMCU1QiUyMjcuNCUyMiUyQyUyMCUyMjcuOCUyMiUyQyUyMCUyMjEwLjMlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjJ2b2xhdGlsZV9hY2lkaXR5JTIyJTNBJTIwJTVCJTIyMC43JTIyJTJDJTIwJTIyMC44OCUyMiUyQyUyMCUyMjAuMzIlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjJjaXRyaWNfYWNpZCUyMiUzQSUyMCU1QiUyMjAlMjIlMkMlMjAlMjIwJTIyJTJDJTIwJTIyMC40NSUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMnJlc2lkdWFsX3N1Z2FyJTIyJTNBJTIwJTVCJTIyMS45JTIyJTJDJTIwJTIyMi42JTIyJTJDJTIwJTIyNi40JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIyY2hsb3JpZGVzJTIyJTNBJTIwJTVCJTIyMC4wNzYlMjIlMkMlMjAlMjIwLjA5OCUyMiUyQyUyMCUyMjAuMDczJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIyZnJlZV9zdWxmdXJfZGlveGlkZSUyMiUzQSUyMCU1QiUyMjExJTIyJTJDJTIwJTIyMjUlMjIlMkMlMjAlMjI1JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIydG90YWxfc3VsZnVyX2Rpb3hpZGUlMjIlM0ElMjAlNUIlMjIzNCUyMiUyQyUyMCUyMjY3JTIyJTJDJTIwJTIyMTMlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjJkZW5zaXR5JTIyJTNBJTIwJTVCJTIyMC45OTc4JTIyJTJDJTIwJTIyMC45OTY4JTIyJTJDJTIwJTIyMC45OTc2JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIycEglMjIlM0ElMjAlNUIlMjIzLjUxJTIyJTJDJTIwJTIyMy4yJTIyJTJDJTIwJTIyMy4yMyUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMnN1bHBoYXRlcyUyMiUzQSUyMCU1QiUyMjAuNTYlMjIlMkMlMjAlMjIwLjY4JTIyJTJDJTIwJTIyMC44MiUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMmFsY29ob2wlMjIlM0ElMjAlNUIlMjI5LjQlMjIlMkMlMjAlMjI5LjglMjIlMkMlMjAlMjIxMi42JTIyJTVEJTJDJTBBJTdEJTBBYXdhaXQlMjBjbGllbnQudGFidWxhcl9jbGFzc2lmaWNhdGlvbih0YWJsZSUzRHRhYmxlJTJDJTIwbW9kZWwlM0QlMjJqdWxpZW4tYyUyRndpbmUtcXVhbGl0eSUyMik=",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>table = {
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;fixed_acidity&quot;</span>: [<span class="hljs-string">&quot;7.4&quot;</span>, <span class="hljs-string">&quot;7.8&quot;</span>, <span class="hljs-string">&quot;10.3&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;volatile_acidity&quot;</span>: [<span class="hljs-string">&quot;0.7&quot;</span>, <span class="hljs-string">&quot;0.88&quot;</span>, <span class="hljs-string">&quot;0.32&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;citric_acid&quot;</span>: [<span class="hljs-string">&quot;0&quot;</span>, <span class="hljs-string">&quot;0&quot;</span>, <span class="hljs-string">&quot;0.45&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;residual_sugar&quot;</span>: [<span class="hljs-string">&quot;1.9&quot;</span>, <span class="hljs-string">&quot;2.6&quot;</span>, <span class="hljs-string">&quot;6.4&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;chlorides&quot;</span>: [<span class="hljs-string">&quot;0.076&quot;</span>, <span class="hljs-string">&quot;0.098&quot;</span>, <span class="hljs-string">&quot;0.073&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;free_sulfur_dioxide&quot;</span>: [<span class="hljs-string">&quot;11&quot;</span>, <span class="hljs-string">&quot;25&quot;</span>, <span class="hljs-string">&quot;5&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;total_sulfur_dioxide&quot;</span>: [<span class="hljs-string">&quot;34&quot;</span>, <span class="hljs-string">&quot;67&quot;</span>, <span class="hljs-string">&quot;13&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;density&quot;</span>: [<span class="hljs-string">&quot;0.9978&quot;</span>, <span class="hljs-string">&quot;0.9968&quot;</span>, <span class="hljs-string">&quot;0.9976&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;pH&quot;</span>: [<span class="hljs-string">&quot;3.51&quot;</span>, <span class="hljs-string">&quot;3.2&quot;</span>, <span class="hljs-string">&quot;3.23&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;sulphates&quot;</span>: [<span class="hljs-string">&quot;0.56&quot;</span>, <span class="hljs-string">&quot;0.68&quot;</span>, <span class="hljs-string">&quot;0.82&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;alcohol&quot;</span>: [<span class="hljs-string">&quot;9.4&quot;</span>, <span class="hljs-string">&quot;9.8&quot;</span>, <span class="hljs-string">&quot;12.6&quot;</span>],
<span class="hljs-meta">... </span>}
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.tabular_classification(table=table, model=<span class="hljs-string">&quot;julien-c/wine-quality&quot;</span>)
[<span class="hljs-string">&quot;5&quot;</span>, <span class="hljs-string">&quot;5&quot;</span>, <span class="hljs-string">&quot;5&quot;</span>]`,wrap:!1}}),{c(){n=g("p"),n.textContent=u,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=u),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:x,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),M(t,e)}}}function vd(I){let n,u="Example:",a,t,o;return t=new q({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQXRhYmxlJTIwJTNEJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIySGVpZ2h0JTIyJTNBJTIwJTVCJTIyMTEuNTIlMjIlMkMlMjAlMjIxMi40OCUyMiUyQyUyMCUyMjEyLjM3NzglMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjJMZW5ndGgxJTIyJTNBJTIwJTVCJTIyMjMuMiUyMiUyQyUyMCUyMjI0JTIyJTJDJTIwJTIyMjMuOSUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMkxlbmd0aDIlMjIlM0ElMjAlNUIlMjIyNS40JTIyJTJDJTIwJTIyMjYuMyUyMiUyQyUyMCUyMjI2LjUlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjJMZW5ndGgzJTIyJTNBJTIwJTVCJTIyMzAlMjIlMkMlMjAlMjIzMS4yJTIyJTJDJTIwJTIyMzEuMSUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMlNwZWNpZXMlMjIlM0ElMjAlNUIlMjJCcmVhbSUyMiUyQyUyMCUyMkJyZWFtJTIyJTJDJTIwJTIyQnJlYW0lMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjJXaWR0aCUyMiUzQSUyMCU1QiUyMjQuMDIlMjIlMkMlMjAlMjI0LjMwNTYlMjIlMkMlMjAlMjI0LjY5NjElMjIlNUQlMkMlMEElN0QlMEFhd2FpdCUyMGNsaWVudC50YWJ1bGFyX3JlZ3Jlc3Npb24odGFibGUlMkMlMjBtb2RlbCUzRCUyMnNjaWtpdC1sZWFybiUyRkZpc2gtV2VpZ2h0JTIyKQ==",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>table = {
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Height&quot;</span>: [<span class="hljs-string">&quot;11.52&quot;</span>, <span class="hljs-string">&quot;12.48&quot;</span>, <span class="hljs-string">&quot;12.3778&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Length1&quot;</span>: [<span class="hljs-string">&quot;23.2&quot;</span>, <span class="hljs-string">&quot;24&quot;</span>, <span class="hljs-string">&quot;23.9&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Length2&quot;</span>: [<span class="hljs-string">&quot;25.4&quot;</span>, <span class="hljs-string">&quot;26.3&quot;</span>, <span class="hljs-string">&quot;26.5&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Length3&quot;</span>: [<span class="hljs-string">&quot;30&quot;</span>, <span class="hljs-string">&quot;31.2&quot;</span>, <span class="hljs-string">&quot;31.1&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Species&quot;</span>: [<span class="hljs-string">&quot;Bream&quot;</span>, <span class="hljs-string">&quot;Bream&quot;</span>, <span class="hljs-string">&quot;Bream&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Width&quot;</span>: [<span class="hljs-string">&quot;4.02&quot;</span>, <span class="hljs-string">&quot;4.3056&quot;</span>, <span class="hljs-string">&quot;4.6961&quot;</span>],
<span class="hljs-meta">... </span>}
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.tabular_regression(table, model=<span class="hljs-string">&quot;scikit-learn/Fish-Weight&quot;</span>)
[<span class="hljs-number">110</span>, <span class="hljs-number">120</span>, <span class="hljs-number">130</span>]`,wrap:!1}}),{c(){n=g("p"),n.textContent=u,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=u),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:x,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),M(t,e)}}}function kd(I){let n,u="Example:",a,t,o;return t=new q({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQWF3YWl0JTIwY2xpZW50LnRleHRfY2xhc3NpZmljYXRpb24oJTIySSUyMGxpa2UlMjB5b3UlMjIp",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.text_classification(<span class="hljs-string">&quot;I like you&quot;</span>)
[
    TextClassificationOutputElement(label=<span class="hljs-string">&#x27;POSITIVE&#x27;</span>, score=<span class="hljs-number">0.9998695850372314</span>),
    TextClassificationOutputElement(label=<span class="hljs-string">&#x27;NEGATIVE&#x27;</span>, score=<span class="hljs-number">0.0001304351753788069</span>),
]`,wrap:!1}}),{c(){n=g("p"),n.textContent=u,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=u),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:x,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),M(t,e)}}}function qd(I){let n,u=`If you want to generate a response from chat messages, you should use the <a href="/docs/huggingface_hub/pr_2368/en/package_reference/inference_client#huggingface_hub.InferenceClient.chat_completion">InferenceClient.chat_completion()</a> method.
It accepts a list of messages instead of a single text prompt and handles the chat templating for you.`;return{c(){n=g("p"),n.innerHTML=u},l(a){n=m(a,"P",{"data-svelte-h":!0}),T(n)!=="svelte-1ynsxk"&&(n.innerHTML=u)},m(a,t){_(a,n,t)},p:x,d(a){a&&p(n)}}}function Ed(I){let n,u="Example:",a,t,o;return t=new q({props:{code:"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",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()

<span class="hljs-comment"># Case 1: generate text</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.text_generation(<span class="hljs-string">&quot;The huggingface_hub library is &quot;</span>, max_new_tokens=<span class="hljs-number">12</span>)
<span class="hljs-string">&#x27;100% open source and built to be easy to use.&#x27;</span>

<span class="hljs-comment"># Case 2: iterate over the generated tokens. Useful async for large generation.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">async</span> <span class="hljs-keyword">for</span> token <span class="hljs-keyword">in</span> <span class="hljs-keyword">await</span> client.text_generation(<span class="hljs-string">&quot;The huggingface_hub library is &quot;</span>, max_new_tokens=<span class="hljs-number">12</span>, stream=<span class="hljs-literal">True</span>):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(token)
<span class="hljs-number">100</span>
%
<span class="hljs-built_in">open</span>
source
<span class="hljs-keyword">and</span>
built
to
be
easy
to
use
.

<span class="hljs-comment"># Case 3: get more details about the generation process.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.text_generation(<span class="hljs-string">&quot;The huggingface_hub library is &quot;</span>, max_new_tokens=<span class="hljs-number">12</span>, details=<span class="hljs-literal">True</span>)
TextGenerationOutput(
    generated_text=<span class="hljs-string">&#x27;100% open source and built to be easy to use.&#x27;</span>,
    details=TextGenerationDetails(
        finish_reason=<span class="hljs-string">&#x27;length&#x27;</span>,
        generated_tokens=<span class="hljs-number">12</span>,
        seed=<span class="hljs-literal">None</span>,
        prefill=[
            TextGenerationPrefillOutputToken(<span class="hljs-built_in">id</span>=<span class="hljs-number">487</span>, text=<span class="hljs-string">&#x27;The&#x27;</span>, logprob=<span class="hljs-literal">None</span>),
            TextGenerationPrefillOutputToken(<span class="hljs-built_in">id</span>=<span class="hljs-number">53789</span>, text=<span class="hljs-string">&#x27; hugging&#x27;</span>, logprob=-<span class="hljs-number">13.171875</span>),
            (...)
            TextGenerationPrefillOutputToken(<span class="hljs-built_in">id</span>=<span class="hljs-number">204</span>, text=<span class="hljs-string">&#x27; &#x27;</span>, logprob=-<span class="hljs-number">7.0390625</span>)
        ],
        tokens=[
            TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">1425</span>, text=<span class="hljs-string">&#x27;100&#x27;</span>, logprob=-<span class="hljs-number">1.0175781</span>, special=<span class="hljs-literal">False</span>),
            TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">16</span>, text=<span class="hljs-string">&#x27;%&#x27;</span>, logprob=-<span class="hljs-number">0.0463562</span>, special=<span class="hljs-literal">False</span>),
            (...)
            TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">25</span>, text=<span class="hljs-string">&#x27;.&#x27;</span>, logprob=-<span class="hljs-number">0.5703125</span>, special=<span class="hljs-literal">False</span>)
        ],
        best_of_sequences=<span class="hljs-literal">None</span>
    )
)

<span class="hljs-comment"># Case 4: iterate over the generated tokens with more details.</span>
<span class="hljs-comment"># Last object is more complete, containing the full generated text and the finish reason.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">async</span> <span class="hljs-keyword">for</span> details <span class="hljs-keyword">in</span> <span class="hljs-keyword">await</span> client.text_generation(<span class="hljs-string">&quot;The huggingface_hub library is &quot;</span>, max_new_tokens=<span class="hljs-number">12</span>, details=<span class="hljs-literal">True</span>, stream=<span class="hljs-literal">True</span>):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(details)
...
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">1425</span>, text=<span class="hljs-string">&#x27;100&#x27;</span>, logprob=-<span class="hljs-number">1.0175781</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">16</span>, text=<span class="hljs-string">&#x27;%&#x27;</span>, logprob=-<span class="hljs-number">0.0463562</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">1314</span>, text=<span class="hljs-string">&#x27; open&#x27;</span>, logprob=-<span class="hljs-number">1.3359375</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">3178</span>, text=<span class="hljs-string">&#x27; source&#x27;</span>, logprob=-<span class="hljs-number">0.28100586</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">273</span>, text=<span class="hljs-string">&#x27; and&#x27;</span>, logprob=-<span class="hljs-number">0.5961914</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">3426</span>, text=<span class="hljs-string">&#x27; built&#x27;</span>, logprob=-<span class="hljs-number">1.9423828</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">271</span>, text=<span class="hljs-string">&#x27; to&#x27;</span>, logprob=-<span class="hljs-number">1.4121094</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">314</span>, text=<span class="hljs-string">&#x27; be&#x27;</span>, logprob=-<span class="hljs-number">1.5224609</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">1833</span>, text=<span class="hljs-string">&#x27; easy&#x27;</span>, logprob=-<span class="hljs-number">2.1132812</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">271</span>, text=<span class="hljs-string">&#x27; to&#x27;</span>, logprob=-<span class="hljs-number">0.08520508</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">745</span>, text=<span class="hljs-string">&#x27; use&#x27;</span>, logprob=-<span class="hljs-number">0.39453125</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(
    <span class="hljs-built_in">id</span>=<span class="hljs-number">25</span>,
    text=<span class="hljs-string">&#x27;.&#x27;</span>,
    logprob=-<span class="hljs-number">0.5703125</span>,
    special=<span class="hljs-literal">False</span>),
    generated_text=<span class="hljs-string">&#x27;100% open source and built to be easy to use.&#x27;</span>,
    details=TextGenerationStreamOutputStreamDetails(finish_reason=<span class="hljs-string">&#x27;length&#x27;</span>, generated_tokens=<span class="hljs-number">12</span>, seed=<span class="hljs-literal">None</span>)
)

<span class="hljs-comment"># Case 5: generate constrained output using grammar</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>response = <span class="hljs-keyword">await</span> client.text_generation(
<span class="hljs-meta">... </span>    prompt=<span class="hljs-string">&quot;I saw a puppy a cat and a raccoon during my bike ride in the park&quot;</span>,
<span class="hljs-meta">... </span>    model=<span class="hljs-string">&quot;HuggingFaceH4/zephyr-orpo-141b-A35b-v0.1&quot;</span>,
<span class="hljs-meta">... </span>    max_new_tokens=<span class="hljs-number">100</span>,
<span class="hljs-meta">... </span>    repetition_penalty=<span class="hljs-number">1.3</span>,
<span class="hljs-meta">... </span>    grammar={
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;json&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;value&quot;</span>: {
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;properties&quot;</span>: {
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;location&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>},
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;activity&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>},
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;animals_seen&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;integer&quot;</span>, <span class="hljs-string">&quot;minimum&quot;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&quot;maximum&quot;</span>: <span class="hljs-number">5</span>},
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;animals&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;array&quot;</span>, <span class="hljs-string">&quot;items&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>}},
<span class="hljs-meta">... </span>            },
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;required&quot;</span>: [<span class="hljs-string">&quot;location&quot;</span>, <span class="hljs-string">&quot;activity&quot;</span>, <span class="hljs-string">&quot;animals_seen&quot;</span>, <span class="hljs-string">&quot;animals&quot;</span>],
<span class="hljs-meta">... </span>        },
<span class="hljs-meta">... </span>    },
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>json.loads(response)
{
    <span class="hljs-string">&quot;activity&quot;</span>: <span class="hljs-string">&quot;bike riding&quot;</span>,
    <span class="hljs-string">&quot;animals&quot;</span>: [<span class="hljs-string">&quot;puppy&quot;</span>, <span class="hljs-string">&quot;cat&quot;</span>, <span class="hljs-string">&quot;raccoon&quot;</span>],
    <span class="hljs-string">&quot;animals_seen&quot;</span>: <span class="hljs-number">3</span>,
    <span class="hljs-string">&quot;location&quot;</span>: <span class="hljs-string">&quot;park&quot;</span>
}`,wrap:!1}}),{c(){n=g("p"),n.textContent=u,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=u),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:x,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),M(t,e)}}}function Ad(I){let n,u="You must have <code>PIL</code> installed if you want to work with images (<code>pip install Pillow</code>).";return{c(){n=g("p"),n.innerHTML=u},l(a){n=m(a,"P",{"data-svelte-h":!0}),T(n)!=="svelte-s2e3n9"&&(n.innerHTML=u)},m(a,t){_(a,n,t)},p:x,d(a){a&&p(n)}}}function Zd(I){let n,u="Example:",a,t,o;return t=new q({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQSUwQWltYWdlJTIwJTNEJTIwYXdhaXQlMjBjbGllbnQudGV4dF90b19pbWFnZSglMjJBbiUyMGFzdHJvbmF1dCUyMHJpZGluZyUyMGElMjBob3JzZSUyMG9uJTIwdGhlJTIwbW9vbi4lMjIpJTBBaW1hZ2Uuc2F2ZSglMjJhc3Ryb25hdXQucG5nJTIyKSUwQSUwQWltYWdlJTIwJTNEJTIwYXdhaXQlMjBjbGllbnQudGV4dF90b19pbWFnZSglMEElMjAlMjAlMjAlMjAlMjJBbiUyMGFzdHJvbmF1dCUyMHJpZGluZyUyMGElMjBob3JzZSUyMG9uJTIwdGhlJTIwbW9vbi4lMjIlMkMlMEElMjAlMjAlMjAlMjBuZWdhdGl2ZV9wcm9tcHQlM0QlMjJsb3clMjByZXNvbHV0aW9uJTJDJTIwYmx1cnJ5JTIyJTJDJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0QlMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24tMi0xJTIyJTJDJTBBKSUwQWltYWdlLnNhdmUoJTIyYmV0dGVyX2FzdHJvbmF1dC5wbmclMjIp",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()

<span class="hljs-meta">&gt;&gt;&gt; </span>image = <span class="hljs-keyword">await</span> client.text_to_image(<span class="hljs-string">&quot;An astronaut riding a horse on the moon.&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image.save(<span class="hljs-string">&quot;astronaut.png&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>image = <span class="hljs-keyword">await</span> client.text_to_image(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;An astronaut riding a horse on the moon.&quot;</span>,
<span class="hljs-meta">... </span>    negative_prompt=<span class="hljs-string">&quot;low resolution, blurry&quot;</span>,
<span class="hljs-meta">... </span>    model=<span class="hljs-string">&quot;stabilityai/stable-diffusion-2-1&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image.save(<span class="hljs-string">&quot;better_astronaut.png&quot;</span>)`,wrap:!1}}),{c(){n=g("p"),n.textContent=u,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=u),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:x,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),M(t,e)}}}function Wd(I){let n,u="Example:",a,t,o;return t=new q({props:{code:"ZnJvbSUyMHBhdGhsaWIlMjBpbXBvcnQlMjBQYXRoJTBBZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQSUwQWF1ZGlvJTIwJTNEJTIwYXdhaXQlMjBjbGllbnQudGV4dF90b19zcGVlY2goJTIySGVsbG8lMjB3b3JsZCUyMiklMEFQYXRoKCUyMmhlbGxvX3dvcmxkLmZsYWMlMjIpLndyaXRlX2J5dGVzKGF1ZGlvKQ==",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> pathlib <span class="hljs-keyword">import</span> Path
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()

<span class="hljs-meta">&gt;&gt;&gt; </span>audio = <span class="hljs-keyword">await</span> client.text_to_speech(<span class="hljs-string">&quot;Hello world&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>Path(<span class="hljs-string">&quot;hello_world.flac&quot;</span>).write_bytes(audio)`,wrap:!1}}),{c(){n=g("p"),n.textContent=u,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=u),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:x,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),M(t,e)}}}function Nd(I){let n,u="Example:",a,t,o;return t=new q({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQWF3YWl0JTIwY2xpZW50LnRva2VuX2NsYXNzaWZpY2F0aW9uKCUyMk15JTIwbmFtZSUyMGlzJTIwU2FyYWglMjBKZXNzaWNhJTIwUGFya2VyJTIwYnV0JTIweW91JTIwY2FuJTIwY2FsbCUyMG1lJTIwSmVzc2ljYSUyMik=",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.token_classification(<span class="hljs-string">&quot;My name is Sarah Jessica Parker but you can call me Jessica&quot;</span>)
[
    TokenClassificationOutputElement(
        entity_group=<span class="hljs-string">&#x27;PER&#x27;</span>,
        score=<span class="hljs-number">0.9971321225166321</span>,
        word=<span class="hljs-string">&#x27;Sarah Jessica Parker&#x27;</span>,
        start=<span class="hljs-number">11</span>,
        end=<span class="hljs-number">31</span>,
    ),
    TokenClassificationOutputElement(
        entity_group=<span class="hljs-string">&#x27;PER&#x27;</span>,
        score=<span class="hljs-number">0.9773476123809814</span>,
        word=<span class="hljs-string">&#x27;Jessica&#x27;</span>,
        start=<span class="hljs-number">52</span>,
        end=<span class="hljs-number">59</span>,
    )
]`,wrap:!1}}),{c(){n=g("p"),n.textContent=u,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=u),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:x,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),M(t,e)}}}function Gd(I){let n,u="Example:",a,t,o;return t=new q({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQWF3YWl0JTIwY2xpZW50LnRyYW5zbGF0aW9uKCUyMk15JTIwbmFtZSUyMGlzJTIwV29sZmdhbmclMjBhbmQlMjBJJTIwbGl2ZSUyMGluJTIwQmVybGluJTIyKSUwQWF3YWl0JTIwY2xpZW50LnRyYW5zbGF0aW9uKCUyMk15JTIwbmFtZSUyMGlzJTIwV29sZmdhbmclMjBhbmQlMjBJJTIwbGl2ZSUyMGluJTIwQmVybGluJTIyJTJDJTIwbW9kZWwlM0QlMjJIZWxzaW5raS1OTFAlMkZvcHVzLW10LWVuLWZyJTIyKQ==",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.translation(<span class="hljs-string">&quot;My name is Wolfgang and I live in Berlin&quot;</span>)
<span class="hljs-string">&#x27;Mein Name ist Wolfgang und ich lebe in Berlin.&#x27;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.translation(<span class="hljs-string">&quot;My name is Wolfgang and I live in Berlin&quot;</span>, model=<span class="hljs-string">&quot;Helsinki-NLP/opus-mt-en-fr&quot;</span>)
TranslationOutput(translation_text=<span class="hljs-string">&#x27;Je m&#x27;</span>appelle Wolfgang et je vis à Berlin.<span class="hljs-string">&#x27;)</span>`,wrap:!1}}),{c(){n=g("p"),n.textContent=u,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=u),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:x,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),M(t,e)}}}function Bd(I){let n,u="Specifying languages:",a,t,o;return t=new q({props:{code:"Y2xpZW50LnRyYW5zbGF0aW9uKCUyMk15JTIwbmFtZSUyMGlzJTIwU2FyYWglMjBKZXNzaWNhJTIwUGFya2VyJTIwYnV0JTIweW91JTIwY2FuJTIwY2FsbCUyMG1lJTIwSmVzc2ljYSUyMiUyQyUyMG1vZGVsJTNEJTIyZmFjZWJvb2slMkZtYmFydC1sYXJnZS01MC1tYW55LXRvLW1hbnktbW10JTIyJTJDJTIwc3JjX2xhbmclM0QlMjJlbl9YWCUyMiUyQyUyMHRndF9sYW5nJTNEJTIyZnJfWFglMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>client.translation(<span class="hljs-string">&quot;My name is Sarah Jessica Parker but you can call me Jessica&quot;</span>, model=<span class="hljs-string">&quot;facebook/mbart-large-50-many-to-many-mmt&quot;</span>, src_lang=<span class="hljs-string">&quot;en_XX&quot;</span>, tgt_lang=<span class="hljs-string">&quot;fr_XX&quot;</span>)
<span class="hljs-string">&quot;Mon nom est Sarah Jessica Parker mais vous pouvez m&#x27;appeler Jessica&quot;</span>`,wrap:!1}}),{c(){n=g("p"),n.textContent=u,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-mhcj6c"&&(n.textContent=u),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:x,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),M(t,e)}}}function Vd(I){let n,u="Example:",a,t,o;return t=new q({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQWF3YWl0JTIwY2xpZW50LnZpc3VhbF9xdWVzdGlvbl9hbnN3ZXJpbmcoJTBBJTIwJTIwJTIwJTIwaW1hZ2UlM0QlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZtaXNoaWclMkZzYW1wbGVfaW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZ0aWdlci5qcGclMjIlMkMlMEElMjAlMjAlMjAlMjBxdWVzdGlvbiUzRCUyMldoYXQlMjBpcyUyMHRoZSUyMGFuaW1hbCUyMGRvaW5nJTNGJTIyJTBBKQ==",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.visual_question_answering(
<span class="hljs-meta">... </span>    image=<span class="hljs-string">&quot;https://huggingface.co/datasets/mishig/sample_images/resolve/main/tiger.jpg&quot;</span>,
<span class="hljs-meta">... </span>    question=<span class="hljs-string">&quot;What is the animal doing?&quot;</span>
<span class="hljs-meta">... </span>)
[
    VisualQuestionAnsweringOutputElement(score=<span class="hljs-number">0.778609573841095</span>, answer=<span class="hljs-string">&#x27;laying down&#x27;</span>),
    VisualQuestionAnsweringOutputElement(score=<span class="hljs-number">0.6957435607910156</span>, answer=<span class="hljs-string">&#x27;sitting&#x27;</span>),
]`,wrap:!1}}),{c(){n=g("p"),n.textContent=u,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=u),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:x,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),M(t,e)}}}function Qd(I){let n,u="Example:",a,t,o;return t=new q({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQXRleHQlMjAlM0QlMjAoJTBBJTIwJTIwJTIwJTIwJTIyQSUyMG5ldyUyMG1vZGVsJTIwb2ZmZXJzJTIwYW4lMjBleHBsYW5hdGlvbiUyMGFzeW5jJTIwZm9yJTIwaG93JTIwdGhlJTIwR2FsaWxlYW4lMjBzYXRlbGxpdGVzJTIwZm9ybWVkJTIwYXJvdW5kJTIwdGhlJTIwc29sYXIlMjBzeXN0ZW0ncyUyMiUwQSUyMCUyMCUyMCUyMCUyMmxhcmdlc3QlMjB3b3JsZC4lMjBLb25zdGFudGluJTIwQmF0eWdpbiUyMGRpZCUyMG5vdCUyMHNldCUyMG91dCUyMHRvJTIwc29sdmUlMjBvbmUlMjBvZiUyMHRoZSUyMHNvbGFyJTIwc3lzdGVtJ3MlMjBtb3N0JTIwcHV6emxpbmclMjIlMEElMjAlMjAlMjAlMjAlMjIlMjBteXN0ZXJpZXMlMjB3aGVuJTIwaGUlMjB3ZW50JTIwYXN5bmMlMjBmb3IlMjBhJTIwcnVuJTIwdXAlMjBhJTIwaGlsbCUyMGluJTIwTmljZSUyQyUyMEZyYW5jZS4lMjIlMEEpJTBBbGFiZWxzJTIwJTNEJTIwJTVCJTIyc3BhY2UlMjAlMjYlMjBjb3Ntb3MlMjIlMkMlMjAlMjJzY2llbnRpZmljJTIwZGlzY292ZXJ5JTIyJTJDJTIwJTIybWljcm9iaW9sb2d5JTIyJTJDJTIwJTIycm9ib3RzJTIyJTJDJTIwJTIyYXJjaGVvbG9neSUyMiU1RCUwQWF3YWl0JTIwY2xpZW50Lnplcm9fc2hvdF9jbGFzc2lmaWNhdGlvbih0ZXh0JTJDJTIwbGFiZWxzKSUwQWF3YWl0JTIwY2xpZW50Lnplcm9fc2hvdF9jbGFzc2lmaWNhdGlvbih0ZXh0JTJDJTIwbGFiZWxzJTJDJTIwbXVsdGlfbGFiZWwlM0RUcnVlKQ==",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>text = (
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;A new model offers an explanation async for how the Galilean satellites formed around the solar system&#x27;s&quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;largest world. Konstantin Batygin did not set out to solve one of the solar system&#x27;s most puzzling&quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot; mysteries when he went async for a run up a hill in Nice, France.&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>labels = [<span class="hljs-string">&quot;space &amp; cosmos&quot;</span>, <span class="hljs-string">&quot;scientific discovery&quot;</span>, <span class="hljs-string">&quot;microbiology&quot;</span>, <span class="hljs-string">&quot;robots&quot;</span>, <span class="hljs-string">&quot;archeology&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.zero_shot_classification(text, labels)
[
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;scientific discovery&#x27;</span>, score=<span class="hljs-number">0.7961668968200684</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;space &amp; cosmos&#x27;</span>, score=<span class="hljs-number">0.18570658564567566</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;microbiology&#x27;</span>, score=<span class="hljs-number">0.00730885099619627</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;archeology&#x27;</span>, score=<span class="hljs-number">0.006258360575884581</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;robots&#x27;</span>, score=<span class="hljs-number">0.004559356719255447</span>),
]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.zero_shot_classification(text, labels, multi_label=<span class="hljs-literal">True</span>)
[
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;scientific discovery&#x27;</span>, score=<span class="hljs-number">0.9829297661781311</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;space &amp; cosmos&#x27;</span>, score=<span class="hljs-number">0.755190908908844</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;microbiology&#x27;</span>, score=<span class="hljs-number">0.0005462635890580714</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;archeology&#x27;</span>, score=<span class="hljs-number">0.00047131875180639327</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;robots&#x27;</span>, score=<span class="hljs-number">0.00030448526376858354</span>),
]`,wrap:!1}}),{c(){n=g("p"),n.textContent=u,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=u),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:x,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),M(t,e)}}}function Yd(I){let n,u="Example:",a,t,o;return t=new q({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQSUwQWF3YWl0JTIwY2xpZW50Lnplcm9fc2hvdF9pbWFnZV9jbGFzc2lmaWNhdGlvbiglMEElMjAlMjAlMjAlMjAlMjJodHRwcyUzQSUyRiUyRnVwbG9hZC53aWtpbWVkaWEub3JnJTJGd2lraXBlZGlhJTJGY29tbW9ucyUyRnRodW1iJTJGNCUyRjQzJTJGQ3V0ZV9kb2cuanBnJTJGMzIwcHgtQ3V0ZV9kb2cuanBnJTIyJTJDJTBBJTIwJTIwJTIwJTIwbGFiZWxzJTNEJTVCJTIyZG9nJTIyJTJDJTIwJTIyY2F0JTIyJTJDJTIwJTIyaG9yc2UlMjIlNUQlMkMlMEEp",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.zero_shot_image_classification(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://upload.wikimedia.org/wikipedia/commons/thumb/4/43/Cute_dog.jpg/320px-Cute_dog.jpg&quot;</span>,
<span class="hljs-meta">... </span>    labels=[<span class="hljs-string">&quot;dog&quot;</span>, <span class="hljs-string">&quot;cat&quot;</span>, <span class="hljs-string">&quot;horse&quot;</span>],
<span class="hljs-meta">... </span>)
[ZeroShotImageClassificationOutputElement(label=<span class="hljs-string">&#x27;dog&#x27;</span>, score=<span class="hljs-number">0.956</span>),...]`,wrap:!1}}),{c(){n=g("p"),n.textContent=u,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=u),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:x,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),M(t,e)}}}function Sd(I){let n,u="Example:",a,t,o;return t=new q({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1Yi5pbmZlcmVuY2VfYXBpJTIwaW1wb3J0JTIwSW5mZXJlbmNlQXBpJTBBJTBBJTIzJTIwTWFzay1maWxsJTIwZXhhbXBsZSUwQWluZmVyZW5jZSUyMCUzRCUyMEluZmVyZW5jZUFwaSglMjJiZXJ0LWJhc2UtdW5jYXNlZCUyMiklMEFpbmZlcmVuY2UoaW5wdXRzJTNEJTIyVGhlJTIwZ29hbCUyMG9mJTIwbGlmZSUyMGlzJTIwJTVCTUFTSyU1RC4lMjIpJTBBJTBBJTIzJTIwUXVlc3Rpb24lMjBBbnN3ZXJpbmclMjBleGFtcGxlJTBBaW5mZXJlbmNlJTIwJTNEJTIwSW5mZXJlbmNlQXBpKCUyMmRlZXBzZXQlMkZyb2JlcnRhLWJhc2Utc3F1YWQyJTIyKSUwQWlucHV0cyUyMCUzRCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMnF1ZXN0aW9uJTIyJTNBJTIwJTIyV2hhdCdzJTIwbXklMjBuYW1lJTNGJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyY29udGV4dCUyMiUzQSUyMCUyMk15JTIwbmFtZSUyMGlzJTIwQ2xhcmElMjBhbmQlMjBJJTIwbGl2ZSUyMGluJTIwQmVya2VsZXkuJTIyJTJDJTBBJTdEJTBBaW5mZXJlbmNlKGlucHV0cyklMEElMEElMjMlMjBaZXJvLXNob3QlMjBleGFtcGxlJTBBaW5mZXJlbmNlJTIwJTNEJTIwSW5mZXJlbmNlQXBpKCUyMnR5cGVmb3JtJTJGZGlzdGlsYmVydC1iYXNlLXVuY2FzZWQtbW5saSUyMiklMEFpbnB1dHMlMjAlM0QlMjAlMjJIaSUyQyUyMEklMjByZWNlbnRseSUyMGJvdWdodCUyMGElMjBkZXZpY2UlMjBmcm9tJTIweW91ciUyMGNvbXBhbnklMjBidXQlMjBpdCUyMGlzJTIwbm90JTIwd29ya2luZyUyMGFzJTIwYWR2ZXJ0aXNlZCUyMGFuZCUyMEklMjB3b3VsZCUyMGxpa2UlMjB0byUyMGdldCUyMHJlaW1idXJzZWQhJTIyJTBBcGFyYW1zJTIwJTNEJTIwJTdCJTIyY2FuZGlkYXRlX2xhYmVscyUyMiUzQSUyMCU1QiUyMnJlZnVuZCUyMiUyQyUyMCUyMmxlZ2FsJTIyJTJDJTIwJTIyZmFxJTIyJTVEJTdEJTBBaW5mZXJlbmNlKGlucHV0cyUyQyUyMHBhcmFtcyklMEElMEElMjMlMjBPdmVycmlkaW5nJTIwY29uZmlndXJlZCUyMHRhc2slMEFpbmZlcmVuY2UlMjAlM0QlMjBJbmZlcmVuY2VBcGkoJTIyYmVydC1iYXNlLXVuY2FzZWQlMjIlMkMlMjB0YXNrJTNEJTIyZmVhdHVyZS1leHRyYWN0aW9uJTIyKSUwQSUwQSUyMyUyMFRleHQtdG8taW1hZ2UlMEFpbmZlcmVuY2UlMjAlM0QlMjBJbmZlcmVuY2VBcGkoJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLTItMSUyMiklMEFpbmZlcmVuY2UoJTIyY2F0JTIyKSUwQSUwQSUyMyUyMFJldHVybiUyMGFzJTIwcmF3JTIwcmVzcG9uc2UlMjB0byUyMHBhcnNlJTIwdGhlJTIwb3V0cHV0JTIweW91cnNlbGYlMEFpbmZlcmVuY2UlMjAlM0QlMjBJbmZlcmVuY2VBcGkoJTIybWlvJTJGYW1hZGV1cyUyMiklMEFyZXNwb25zZSUyMCUzRCUyMGluZmVyZW5jZSglMjJoZWxsbyUyMHdvcmxkJTIyJTJDJTIwcmF3X3Jlc3BvbnNlJTNEVHJ1ZSklMEFyZXNwb25zZS5oZWFkZXJzJTBBcmVzcG9uc2UuY29udGVudCUyMCUyMyUyMHJhdyUyMGJ5dGVzJTIwZnJvbSUyMHNlcnZlcg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub.inference_api <span class="hljs-keyword">import</span> InferenceApi

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Mask-fill example</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inference = InferenceApi(<span class="hljs-string">&quot;bert-base-uncased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inference(inputs=<span class="hljs-string">&quot;The goal of life is [MASK].&quot;</span>)
[{<span class="hljs-string">&#x27;sequence&#x27;</span>: <span class="hljs-string">&#x27;the goal of life is life.&#x27;</span>, <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.10933292657136917</span>, <span class="hljs-string">&#x27;token&#x27;</span>: <span class="hljs-number">2166</span>, <span class="hljs-string">&#x27;token_str&#x27;</span>: <span class="hljs-string">&#x27;life&#x27;</span>}]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Question Answering example</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inference = InferenceApi(<span class="hljs-string">&quot;deepset/roberta-base-squad2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = {
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;question&quot;</span>: <span class="hljs-string">&quot;What&#x27;s my name?&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;context&quot;</span>: <span class="hljs-string">&quot;My name is Clara and I live in Berkeley.&quot;</span>,
<span class="hljs-meta">... </span>}
<span class="hljs-meta">&gt;&gt;&gt; </span>inference(inputs)
{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.9326569437980652</span>, <span class="hljs-string">&#x27;start&#x27;</span>: <span class="hljs-number">11</span>, <span class="hljs-string">&#x27;end&#x27;</span>: <span class="hljs-number">16</span>, <span class="hljs-string">&#x27;answer&#x27;</span>: <span class="hljs-string">&#x27;Clara&#x27;</span>}

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Zero-shot example</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inference = InferenceApi(<span class="hljs-string">&quot;typeform/distilbert-base-uncased-mnli&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = <span class="hljs-string">&quot;Hi, I recently bought a device from your company but it is not working as advertised and I would like to get reimbursed!&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>params = {<span class="hljs-string">&quot;candidate_labels&quot;</span>: [<span class="hljs-string">&quot;refund&quot;</span>, <span class="hljs-string">&quot;legal&quot;</span>, <span class="hljs-string">&quot;faq&quot;</span>]}
<span class="hljs-meta">&gt;&gt;&gt; </span>inference(inputs, params)
{<span class="hljs-string">&#x27;sequence&#x27;</span>: <span class="hljs-string">&#x27;Hi, I recently bought a device from your company but it is not working as advertised and I would like to get reimbursed!&#x27;</span>, <span class="hljs-string">&#x27;labels&#x27;</span>: [<span class="hljs-string">&#x27;refund&#x27;</span>, <span class="hljs-string">&#x27;faq&#x27;</span>, <span class="hljs-string">&#x27;legal&#x27;</span>], <span class="hljs-string">&#x27;scores&#x27;</span>: [<span class="hljs-number">0.9378499388694763</span>, <span class="hljs-number">0.04914155602455139</span>, <span class="hljs-number">0.013008488342165947</span>]}

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Overriding configured task</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inference = InferenceApi(<span class="hljs-string">&quot;bert-base-uncased&quot;</span>, task=<span class="hljs-string">&quot;feature-extraction&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Text-to-image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inference = InferenceApi(<span class="hljs-string">&quot;stabilityai/stable-diffusion-2-1&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inference(<span class="hljs-string">&quot;cat&quot;</span>)
&lt;PIL.PngImagePlugin.PngImageFile image (...)&gt;

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Return as raw response to parse the output yourself</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inference = InferenceApi(<span class="hljs-string">&quot;mio/amadeus&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>response = inference(<span class="hljs-string">&quot;hello world&quot;</span>, raw_response=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>response.headers
{<span class="hljs-string">&quot;Content-Type&quot;</span>: <span class="hljs-string">&quot;audio/flac&quot;</span>, ...}
<span class="hljs-meta">&gt;&gt;&gt; </span>response.content <span class="hljs-comment"># raw bytes from server</span>
<span class="hljs-string">b&#x27;(...)&#x27;</span>`,wrap:!1}}),{c(){n=g("p"),n.textContent=u,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=u),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:x,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),M(t,e)}}}function Dd(I){let n,u,a,t,o,e,c,cg=`Inference is the process of using a trained model to make predictions on new data. As this process can be compute-intensive,
running on a dedicated server can be an interesting option. The <code>huggingface_hub</code> library provides an easy way to call a
service that runs inference for hosted models. There are several services you can connect to:`,dr,Ss,pg=`<li><a href="https://huggingface.co/docs/api-inference/index" rel="nofollow">Inference API</a>: a service that allows you to run accelerated inference
on Hugging Face’s infrastructure for free. This service is a fast way to get started, test different models, and
prototype AI products.</li> <li><a href="https://huggingface.co/inference-endpoints" rel="nofollow">Inference Endpoints</a>: a product to easily deploy models to production.
Inference is run by Hugging Face in a dedicated, fully managed infrastructure on a cloud provider of your choice.</li>`,fr,Ds,ug=`These services can be called with the <a href="/docs/huggingface_hub/pr_2368/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a> object. Please refer to <a href="../guides/inference">this guide</a>
for more information on how to use it.`,yr,Rs,br,J,Xs,Er,$l,gg="Initialize a new Inference Client.",Ar,vl,mg=`<a href="/docs/huggingface_hub/pr_2368/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a> aims to provide a unified experience to perform inference. The client can be used
seamlessly with either the (free) Inference API or self-hosted Inference Endpoints.`,Zr,ke,Hs,Wr,kl,hg="Perform audio classification on the provided audio content.",Nr,ot,Gr,qe,Fs,Br,ql,dg="Performs multiple tasks related to audio-to-audio depending on the model (eg: speech enhancement, source separation).",Vr,rt,Qr,Ee,zs,Yr,El,fg="Perform automatic speech recognition (ASR or audio-to-text) on the given audio content.",Sr,it,Dr,Ae,Ls,Rr,Al,yg="A method for completing conversations using a specified language model.",Xr,ct,Hr,z,Ps,Fr,Zl,bg="Generate conversational responses based on the given input text (i.e. chat with the API).",zr,pt,Lr,ut,Pr,Ze,Os,Or,Wl,Mg="Answer questions on document images.",Kr,gt,ei,We,Ks,ni,Nl,jg="Generate embeddings for a given text.",ti,mt,si,Ne,ea,ai,Gl,_g="Fill in a hole with a missing word (token to be precise).",li,ht,oi,L,na,ri,Bl,Tg="Get information about the deployed endpoint.",ii,Vl,Ig=`This endpoint is only available on endpoints powered by Text-Generation-Inference (TGI) or Text-Embedding-Inference (TEI).
Endpoints powered by <code>transformers</code> return an empty payload.`,ci,dt,pi,P,ta,ui,Ql,xg="Get the status of a model hosted on the Inference API.",gi,ft,mi,yt,hi,bt,sa,di,Yl,Jg="Get the model Hugging Face recommends for the input task.",fi,O,aa,yi,Sl,wg="Check the health of the deployed endpoint.",bi,Dl,Cg=`Health check is only available with Inference Endpoints powered by Text-Generation-Inference (TGI) or Text-Embedding-Inference (TEI).
For Inference API, please use <a href="/docs/huggingface_hub/pr_2368/en/package_reference/inference_client#huggingface_hub.InferenceClient.get_model_status">InferenceClient.get_model_status()</a> instead.`,Mi,Mt,ji,Ge,la,_i,Rl,Ug="Perform image classification on the given image using the specified model.",Ti,jt,Ii,K,oa,xi,Xl,$g="Perform image segmentation on the given image using the specified model.",Ji,_t,wi,Tt,Ci,ee,ra,Ui,Hl,vg="Perform image-to-image translation using a specified model.",$i,It,vi,xt,ki,ne,ia,qi,Fl,kg="Takes an input image and return text.",Ei,zl,qg=`Models can have very different outputs depending on your use case (image captioning, optical character recognition
(OCR), Pix2Struct, etc). Please have a look to the model card to learn more about a model’s specificities.`,Ai,Jt,Zi,Z,ca,Wi,Ll,Eg="List models deployed on the Serverless Inference API service.",Ni,Pl,Ag=`This helper checks deployed models framework by framework. By default, it will check the 4 main frameworks that
are supported and account for 95% of the hosted models. However, if you want a complete list of models you can
specify <code>frameworks=&quot;all&quot;</code> as input. Alternatively, if you know before-hand which framework you are interested
in, you can also restrict to search to this one (e.g. <code>frameworks=&quot;text-generation-inference&quot;</code>). The more
frameworks are checked, the more time it will take.`,Gi,wt,Bi,Ct,Vi,Ut,Qi,te,pa,Yi,Ol,Zg="Perform object detection on the given image using the specified model.",Si,$t,Di,vt,Ri,kt,ua,Xi,Kl,Wg="Make a POST request to the inference server.",Hi,Be,ga,Fi,eo,Ng="Retrieve the answer to a question from a given text.",zi,qt,Li,Ve,ma,Pi,no,Gg="Compute the semantic similarity between a sentence and a list of other sentences by comparing their embeddings.",Oi,Et,Ki,Qe,ha,ec,to,Bg="Generate a summary of a given text using a specified model.",nc,At,tc,Ye,da,sc,so,Vg="Retrieve the answer to a question from information given in a table.",ac,Zt,lc,Se,fa,oc,ao,Qg="Classifying a target category (a group) based on a set of attributes.",rc,Wt,ic,De,ya,cc,lo,Yg="Predicting a numerical target value given a set of attributes/features in a table.",pc,Nt,uc,Re,ba,gc,oo,Sg="Perform text classification (e.g. sentiment-analysis) on the given text.",mc,Gt,hc,W,Ma,dc,ro,Dg="Given a prompt, generate the following text.",fc,io,Rg=`API endpoint is supposed to run with the <code>text-generation-inference</code> backend (TGI). This backend is the
go-to solution to run large language models at scale. However, for some smaller models (e.g. “gpt2”) the
default <code>transformers</code> + <code>api-inference</code> solution is still in use. Both approaches have very similar APIs, but
not exactly the same. This method is compatible with both approaches but some parameters are only available for
<code>text-generation-inference</code>. If some parameters are ignored, a warning message is triggered but the process
continues correctly.`,yc,co,Xg='To learn more about the TGI project, please refer to <a href="https://github.com/huggingface/text-generation-inference" rel="nofollow">https://github.com/huggingface/text-generation-inference</a>.',bc,Bt,Mc,Vt,jc,se,ja,_c,po,Hg="Generate an image based on a given text using a specified model.",Tc,Qt,Ic,Yt,xc,Xe,_a,Jc,uo,Fg="Synthesize an audio of a voice pronouncing a given text.",wc,St,Cc,He,Ta,Uc,go,zg=`Perform token classification on the given text.
Usually used for sentence parsing, either grammatical, or Named Entity Recognition (NER) to understand keywords contained within text.`,$c,Dt,vc,D,Ia,kc,mo,Lg="Convert text from one language to another.",qc,ho,Pg=`Check out <a href="https://huggingface.co/tasks/translation" rel="nofollow">https://huggingface.co/tasks/translation</a> for more information on how to choose the best model for
your specific use case. Source and target languages usually depend on the model.
However, it is possible to specify source and target languages for certain models. If you are working with one of these models,
you can use <code>src_lang</code> and <code>tgt_lang</code> arguments to pass the relevant information.
You can find this information in the model card.`,Ec,Rt,Ac,Xt,Zc,Fe,xa,Wc,fo,Og="Answering open-ended questions based on an image.",Nc,Ht,Gc,ze,Ja,Bc,yo,Kg="Provide as input a text and a set of candidate labels to classify the input text.",Vc,Ft,Qc,Le,wa,Yc,bo,em="Provide input image and text labels to predict text labels for the image.",Sc,zt,Mr,Ca,jr,Ua,nm=`An async version of the client is also provided, based on <code>asyncio</code> and <code>aiohttp</code>.
To use it, you can either install <code>aiohttp</code> directly or use the <code>[inference]</code> extra:`,_r,$a,Tr,w,va,Dc,Mo,tm="Initialize a new Inference Client.",Rc,jo,sm=`<a href="/docs/huggingface_hub/pr_2368/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a> aims to provide a unified experience to perform inference. The client can be used
seamlessly with either the (free) Inference API or self-hosted Inference Endpoints.`,Xc,Pe,ka,Hc,_o,am="Perform audio classification on the provided audio content.",Fc,Lt,zc,Oe,qa,Lc,To,lm="Performs multiple tasks related to audio-to-audio depending on the model (eg: speech enhancement, source separation).",Pc,Pt,Oc,Ke,Ea,Kc,Io,om="Perform automatic speech recognition (ASR or audio-to-text) on the given audio content.",ep,Ot,np,en,Aa,tp,xo,rm="A method for completing conversations using a specified language model.",sp,Kt,ap,ae,Za,lp,Jo,im="Generate conversational responses based on the given input text (i.e. chat with the API).",op,es,rp,ns,ip,nn,Wa,cp,wo,cm="Answer questions on document images.",pp,ts,up,tn,Na,gp,Co,pm="Generate embeddings for a given text.",mp,ss,hp,sn,Ga,dp,Uo,um="Fill in a hole with a missing word (token to be precise).",fp,as,yp,le,Ba,bp,$o,gm="Get information about the deployed endpoint.",Mp,vo,mm=`This endpoint is only available on endpoints powered by Text-Generation-Inference (TGI) or Text-Embedding-Inference (TEI).
Endpoints powered by <code>transformers</code> return an empty payload.`,jp,ls,_p,oe,Va,Tp,ko,hm="Get the status of a model hosted on the Inference API.",Ip,os,xp,rs,Jp,is,Qa,wp,qo,dm="Get the model Hugging Face recommends for the input task.",Cp,re,Ya,Up,Eo,fm="Check the health of the deployed endpoint.",$p,Ao,ym=`Health check is only available with Inference Endpoints powered by Text-Generation-Inference (TGI) or Text-Embedding-Inference (TEI).
For Inference API, please use <a href="/docs/huggingface_hub/pr_2368/en/package_reference/inference_client#huggingface_hub.InferenceClient.get_model_status">InferenceClient.get_model_status()</a> instead.`,vp,cs,kp,an,Sa,qp,Zo,bm="Perform image classification on the given image using the specified model.",Ep,ps,Ap,ie,Da,Zp,Wo,Mm="Perform image segmentation on the given image using the specified model.",Wp,us,Np,gs,Gp,ce,Ra,Bp,No,jm="Perform image-to-image translation using a specified model.",Vp,ms,Qp,hs,Yp,pe,Xa,Sp,Go,_m="Takes an input image and return text.",Dp,Bo,Tm=`Models can have very different outputs depending on your use case (image captioning, optical character recognition
(OCR), Pix2Struct, etc). Please have a look to the model card to learn more about a model’s specificities.`,Rp,ds,Xp,N,Ha,Hp,Vo,Im="List models deployed on the Serverless Inference API service.",Fp,Qo,xm=`This helper checks deployed models framework by framework. By default, it will check the 4 main frameworks that
are supported and account for 95% of the hosted models. However, if you want a complete list of models you can
specify <code>frameworks=&quot;all&quot;</code> as input. Alternatively, if you know before-hand which framework you are interested
in, you can also restrict to search to this one (e.g. <code>frameworks=&quot;text-generation-inference&quot;</code>). The more
frameworks are checked, the more time it will take.`,zp,fs,Lp,ys,Pp,bs,Op,ue,Fa,Kp,Yo,Jm="Perform object detection on the given image using the specified model.",eu,Ms,nu,js,tu,_s,za,su,So,wm="Make a POST request to the inference server.",au,ln,La,lu,Do,Cm="Retrieve the answer to a question from a given text.",ou,Ts,ru,on,Pa,iu,Ro,Um="Compute the semantic similarity between a sentence and a list of other sentences by comparing their embeddings.",cu,Is,pu,rn,Oa,uu,Xo,$m="Generate a summary of a given text using a specified model.",gu,xs,mu,cn,Ka,hu,Ho,vm="Retrieve the answer to a question from information given in a table.",du,Js,fu,pn,el,yu,Fo,km="Classifying a target category (a group) based on a set of attributes.",bu,ws,Mu,un,nl,ju,zo,qm="Predicting a numerical target value given a set of attributes/features in a table.",_u,Cs,Tu,gn,tl,Iu,Lo,Em="Perform text classification (e.g. sentiment-analysis) on the given text.",xu,Us,Ju,G,sl,wu,Po,Am="Given a prompt, generate the following text.",Cu,Oo,Zm=`API endpoint is supposed to run with the <code>text-generation-inference</code> backend (TGI). This backend is the
go-to solution to run large language models at scale. However, for some smaller models (e.g. “gpt2”) the
default <code>transformers</code> + <code>api-inference</code> solution is still in use. Both approaches have very similar APIs, but
not exactly the same. This method is compatible with both approaches but some parameters are only available for
<code>text-generation-inference</code>. If some parameters are ignored, a warning message is triggered but the process
continues correctly.`,Uu,Ko,Wm='To learn more about the TGI project, please refer to <a href="https://github.com/huggingface/text-generation-inference" rel="nofollow">https://github.com/huggingface/text-generation-inference</a>.',$u,$s,vu,vs,ku,ge,al,qu,er,Nm="Generate an image based on a given text using a specified model.",Eu,ks,Au,qs,Zu,mn,ll,Wu,nr,Gm="Synthesize an audio of a voice pronouncing a given text.",Nu,Es,Gu,hn,ol,Bu,tr,Bm=`Perform token classification on the given text.
Usually used for sentence parsing, either grammatical, or Named Entity Recognition (NER) to understand keywords contained within text.`,Vu,As,Qu,R,rl,Yu,sr,Vm="Convert text from one language to another.",Su,ar,Qm=`Check out <a href="https://huggingface.co/tasks/translation" rel="nofollow">https://huggingface.co/tasks/translation</a> for more information on how to choose the best model for
your specific use case. Source and target languages usually depend on the model.
However, it is possible to specify source and target languages for certain models. If you are working with one of these models,
you can use <code>src_lang</code> and <code>tgt_lang</code> arguments to pass the relevant information.
You can find this information in the model card.`,Du,Zs,Ru,Ws,Xu,dn,il,Hu,lr,Ym="Answering open-ended questions based on an image.",Fu,Ns,zu,fn,cl,Lu,or,Sm="Provide as input a text and a set of candidate labels to classify the input text.",Pu,Gs,Ou,yn,pl,Ku,rr,Dm="Provide input image and text labels to predict text labels for the image.",eg,Bs,Ir,ul,xr,bn,gl,ng,ir,Rm="Error raised when a model is unavailable or the request times out.",Jr,ml,wr,Mn,hl,tg,cr,Xm="This Dataclass represents the the model status in the Hugging Face Inference API.",Cr,dl,Ur,fl,Hm=`<code>InferenceAPI</code> is the legacy way to call the Inference API. The interface is more simplistic and requires knowing
the input parameters and output format for each task. It also lacks the ability to connect to other services like
Inference Endpoints or AWS SageMaker. <code>InferenceAPI</code> will soon be deprecated so we recommend using <a href="/docs/huggingface_hub/pr_2368/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a>
whenever possible. Check out <a href="../guides/inference#legacy-inferenceapi-client">this guide</a> to learn how to switch from
<code>InferenceAPI</code> to <a href="/docs/huggingface_hub/pr_2368/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a> in your scripts.`,$r,B,yl,sg,pr,Fm="Client to configure requests and make calls to the HuggingFace Inference API.",ag,Vs,lg,Qs,bl,og,ur,zm="Inits headers and API call information.",rg,Ys,Ml,ig,gr,Lm="Make a call to the Inference API.",vr,jl,kr,hr,qr;return o=new mr({props:{title:"Inference",local:"inference",headingTag:"h1"}}),Rs=new mr({props:{title:"Inference Client",local:"huggingface_hub.InferenceClient",headingTag:"h2"}}),Xs=new k({props:{name:"class huggingface_hub.InferenceClient",anchor:"huggingface_hub.InferenceClient",parameters:[{name:"model",val:": Optional = None"},{name:"token",val:": Union = None"},{name:"timeout",val:": Optional = None"},{name:"headers",val:": Optional = None"},{name:"cookies",val:": Optional = None"},{name:"proxies",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.model",description:`<strong>model</strong> (<code>str</code>, <code>optional</code>) &#x2014;
The model to run inference with. Can be a model id hosted on the Hugging Face Hub, e.g. <code>bigcode/starcoder</code>
or a URL to a deployed Inference Endpoint. Defaults to None, in which case a recommended model is
automatically selected for the task.`,name:"model"},{anchor:"huggingface_hub.InferenceClient.token",description:`<strong>token</strong> (<code>str</code> or <code>bool</code>, <em>optional</em>) &#x2014;
Hugging Face token. Will default to the locally saved token if not provided.
Pass <code>token=False</code> if you don&#x2019;t want to send your token to the server.`,name:"token"},{anchor:"huggingface_hub.InferenceClient.timeout",description:`<strong>timeout</strong> (<code>float</code>, <code>optional</code>) &#x2014;
The maximum number of seconds to wait for a response from the server. Loading a new model in Inference
API can take up to several minutes. Defaults to None, meaning it will loop until the server is available.`,name:"timeout"},{anchor:"huggingface_hub.InferenceClient.headers",description:`<strong>headers</strong> (<code>Dict[str, str]</code>, <code>optional</code>) &#x2014;
Additional headers to send to the server. By default only the authorization and user-agent headers are sent.
Values in this dictionary will override the default values.`,name:"headers"},{anchor:"huggingface_hub.InferenceClient.cookies",description:`<strong>cookies</strong> (<code>Dict[str, str]</code>, <code>optional</code>) &#x2014;
Additional cookies to send to the server.`,name:"cookies"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2368/src/huggingface_hub/inference/_client.py#L128"}}),Hs=new k({props:{name:"audio_classification",anchor:"huggingface_hub.InferenceClient.audio_classification",parameters:[{name:"audio",val:": Union"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.audio_classification.audio",description:`<strong>audio</strong> (Union[str, Path, bytes, BinaryIO]) &#x2014;
The audio content to classify. It can be raw audio bytes, a local audio file, or a URL pointing to an
audio file.`,name:"audio"},{anchor:"huggingface_hub.InferenceClient.audio_classification.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for audio classification. Can be a model ID hosted on the Hugging Face Hub
or a URL to a deployed Inference Endpoint. If not provided, the default recommended model for
audio classification will be used.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2368/src/huggingface_hub/inference/_client.py#L302",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List of <a
  href="/docs/huggingface_hub/pr_2368/en/package_reference/inference_types#huggingface_hub.AudioClassificationOutputElement"
>AudioClassificationOutputElement</a> items containing the predicted labels and their confidence.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[AudioClassificationOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/pr_2368/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2368/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),ot=new E({props:{anchor:"huggingface_hub.InferenceClient.audio_classification.example",$$slots:{default:[mh]},$$scope:{ctx:I}}}),Fs=new k({props:{name:"audio_to_audio",anchor:"huggingface_hub.InferenceClient.audio_to_audio",parameters:[{name:"audio",val:": Union"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.audio_to_audio.audio",description:`<strong>audio</strong> (Union[str, Path, bytes, BinaryIO]) &#x2014;
The audio content for the model. It can be raw audio bytes, a local audio file, or a URL pointing to an
audio file.`,name:"audio"},{anchor:"huggingface_hub.InferenceClient.audio_to_audio.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model can be any model which takes an audio file and returns another audio file. Can be a model ID hosted on the Hugging Face Hub
or a URL to a deployed Inference Endpoint. If not provided, the default recommended model for
audio_to_audio will be used.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2368/src/huggingface_hub/inference/_client.py#L344",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of <a
  href="/docs/huggingface_hub/pr_2368/en/package_reference/inference_types#huggingface_hub.AudioToAudioOutputElement"
>AudioToAudioOutputElement</a> items containing audios label, content-type, and audio content in blob.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[AudioToAudioOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><code>InferenceTimeoutError</code> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>InferenceTimeoutError</code> or <code>HTTPError</code></p>
`}}),rt=new E({props:{anchor:"huggingface_hub.InferenceClient.audio_to_audio.example",$$slots:{default:[hh]},$$scope:{ctx:I}}}),zs=new k({props:{name:"automatic_speech_recognition",anchor:"huggingface_hub.InferenceClient.automatic_speech_recognition",parameters:[{name:"audio",val:": Union"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.automatic_speech_recognition.audio",description:`<strong>audio</strong> (Union[str, Path, bytes, BinaryIO]) &#x2014;
The content to transcribe. It can be raw audio bytes, local audio file, or a URL to an audio file.`,name:"audio"},{anchor:"huggingface_hub.InferenceClient.automatic_speech_recognition.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for ASR. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. If not provided, the default recommended model for ASR will be used.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2368/src/huggingface_hub/inference/_client.py#L387",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>An item containing the transcribed text and optionally the timestamp chunks.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2368/en/package_reference/inference_types#huggingface_hub.AutomaticSpeechRecognitionOutput"
>AutomaticSpeechRecognitionOutput</a></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/pr_2368/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2368/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),it=new E({props:{anchor:"huggingface_hub.InferenceClient.automatic_speech_recognition.example",$$slots:{default:[dh]},$$scope:{ctx:I}}}),Ls=new k({props:{name:"chat_completion",anchor:"huggingface_hub.InferenceClient.chat_completion",parameters:[{name:"messages",val:": List"},{name:"model",val:": Optional = None"},{name:"stream",val:": bool = False"},{name:"frequency_penalty",val:": Optional = None"},{name:"logit_bias",val:": Optional = None"},{name:"logprobs",val:": Optional = None"},{name:"max_tokens",val:": Optional = None"},{name:"n",val:": Optional = None"},{name:"presence_penalty",val:": Optional = None"},{name:"seed",val:": Optional = None"},{name:"stop",val:": Optional = None"},{name:"temperature",val:": Optional = None"},{name:"tool_choice",val:": Union = None"},{name:"tool_prompt",val:": Optional = None"},{name:"tools",val:": Optional = None"},{name:"top_logprobs",val:": Optional = None"},{name:"top_p",val:": Optional = None"},{name:"model_id",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.chat_completion.messages",description:`<strong>messages</strong> (List[Union[<code>SystemMessage</code>, <code>UserMessage</code>, <code>AssistantMessage</code>]]) &#x2014;
Conversation history consisting of roles and content pairs.`,name:"messages"},{anchor:"huggingface_hub.InferenceClient.chat_completion.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for chat-completion. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. If not provided, the default recommended model for chat-based text-generation will be used.
See <a href="https://huggingface.co/tasks/text-generation" rel="nofollow">https://huggingface.co/tasks/text-generation</a> for more details.`,name:"model"},{anchor:"huggingface_hub.InferenceClient.chat_completion.frequency_penalty",description:`<strong>frequency_penalty</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Penalizes new tokens based on their existing frequency
in the text so far. Range: [-2.0, 2.0]. Defaults to 0.0.`,name:"frequency_penalty"},{anchor:"huggingface_hub.InferenceClient.chat_completion.logit_bias",description:`<strong>logit_bias</strong> (<code>List[float]</code>, <em>optional</em>) &#x2014;
Modify the likelihood of specified tokens appearing in the completion. Accepts a JSON object that maps tokens
(specified by their token ID in the tokenizer) to an associated bias value from -100 to 100. Mathematically,
the bias is added to the logits generated by the model prior to sampling. The exact effect will vary per model,
but values between -1 and 1 should decrease or increase likelihood of selection; values like -100 or 100 should
result in a ban or exclusive selection of the relevant token. Defaults to None.`,name:"logit_bias"},{anchor:"huggingface_hub.InferenceClient.chat_completion.logprobs",description:`<strong>logprobs</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to return log probabilities of the output tokens or not. If true, returns the log
probabilities of each output token returned in the content of message.`,name:"logprobs"},{anchor:"huggingface_hub.InferenceClient.chat_completion.max_tokens",description:`<strong>max_tokens</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Maximum number of tokens allowed in the response. Defaults to 20.`,name:"max_tokens"},{anchor:"huggingface_hub.InferenceClient.chat_completion.n",description:`<strong>n</strong> (<code>int</code>, <em>optional</em>) &#x2014;
UNUSED.`,name:"n"},{anchor:"huggingface_hub.InferenceClient.chat_completion.presence_penalty",description:`<strong>presence_penalty</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Number between -2.0 and 2.0. Positive values penalize new tokens based on whether they appear in the
text so far, increasing the model&#x2019;s likelihood to talk about new topics.`,name:"presence_penalty"},{anchor:"huggingface_hub.InferenceClient.chat_completion.seed",description:`<strong>seed</strong> (Optional<code>int</code>, <em>optional</em>) &#x2014;
Seed for reproducible control flow. Defaults to None.`,name:"seed"},{anchor:"huggingface_hub.InferenceClient.chat_completion.stop",description:`<strong>stop</strong> (Optional<code>str</code>, <em>optional</em>) &#x2014;
Up to four strings which trigger the end of the response.
Defaults to None.`,name:"stop"},{anchor:"huggingface_hub.InferenceClient.chat_completion.stream",description:`<strong>stream</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Enable realtime streaming of responses. Defaults to False.`,name:"stream"},{anchor:"huggingface_hub.InferenceClient.chat_completion.temperature",description:`<strong>temperature</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Controls randomness of the generations. Lower values ensure
less random completions. Range: [0, 2]. Defaults to 1.0.`,name:"temperature"},{anchor:"huggingface_hub.InferenceClient.chat_completion.top_logprobs",description:`<strong>top_logprobs</strong> (<code>int</code>, <em>optional</em>) &#x2014;
An integer between 0 and 5 specifying the number of most likely tokens to return at each token
position, each with an associated log probability. logprobs must be set to true if this parameter is
used.`,name:"top_logprobs"},{anchor:"huggingface_hub.InferenceClient.chat_completion.top_p",description:`<strong>top_p</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Fraction of the most likely next words to sample from.
Must be between 0 and 1. Defaults to 1.0.`,name:"top_p"},{anchor:"huggingface_hub.InferenceClient.chat_completion.tool_choice",description:`<strong>tool_choice</strong> (<a href="/docs/huggingface_hub/pr_2368/en/package_reference/inference_types#huggingface_hub.ChatCompletionInputToolTypeClass">ChatCompletionInputToolTypeClass</a> or <code>ChatCompletionInputToolTypeEnum</code>, <em>optional</em>) &#x2014;
The tool to use for the completion. Defaults to &#x201C;auto&#x201D;.`,name:"tool_choice"},{anchor:"huggingface_hub.InferenceClient.chat_completion.tool_prompt",description:`<strong>tool_prompt</strong> (<code>str</code>, <em>optional</em>) &#x2014;
A prompt to be appended before the tools.`,name:"tool_prompt"},{anchor:"huggingface_hub.InferenceClient.chat_completion.tools",description:`<strong>tools</strong> (List of <a href="/docs/huggingface_hub/pr_2368/en/package_reference/inference_types#huggingface_hub.ChatCompletionInputTool">ChatCompletionInputTool</a>, <em>optional</em>) &#x2014;
A list of tools the model may call. Currently, only functions are supported as a tool. Use this to
provide a list of functions the model may generate JSON inputs for.`,name:"tools"},{anchor:"huggingface_hub.InferenceClient.chat_completion.model_id",description:`<strong>model_id</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model ID to use for chat-completion. Only used when <code>model</code> is a URL to a deployed Text Generation Inference server.
It is passed to the server as the <code>model</code> parameter. This parameter has no impact on the URL that will be used to
send the request.`,name:"model_id"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2368/src/huggingface_hub/inference/_client.py#L495",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Generated text returned from the server:</p>
<ul>
<li>if <code>stream=False</code>, the generated text is returned as a <a
  href="/docs/huggingface_hub/pr_2368/en/package_reference/inference_types#huggingface_hub.ChatCompletionOutput"
>ChatCompletionOutput</a> (default).</li>
<li>if <code>stream=True</code>, the generated text is returned token by token as a sequence of <a
  href="/docs/huggingface_hub/pr_2368/en/package_reference/inference_types#huggingface_hub.ChatCompletionStreamOutput"
>ChatCompletionStreamOutput</a>.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2368/en/package_reference/inference_types#huggingface_hub.ChatCompletionOutput"
>ChatCompletionOutput</a> or Iterable of <a
  href="/docs/huggingface_hub/pr_2368/en/package_reference/inference_types#huggingface_hub.ChatCompletionStreamOutput"
>ChatCompletionStreamOutput</a></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/pr_2368/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2368/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),ct=new E({props:{anchor:"huggingface_hub.InferenceClient.chat_completion.example",$$slots:{default:[fh]},$$scope:{ctx:I}}}),Ps=new k({props:{name:"conversational",anchor:"huggingface_hub.InferenceClient.conversational",parameters:[{name:"text",val:": str"},{name:"generated_responses",val:": Optional = None"},{name:"past_user_inputs",val:": Optional = None"},{name:"parameters",val:": Optional = None"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.conversational.text",description:`<strong>text</strong> (<code>str</code>) &#x2014;
The last input from the user in the conversation.`,name:"text"},{anchor:"huggingface_hub.InferenceClient.conversational.generated_responses",description:`<strong>generated_responses</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
A list of strings corresponding to the earlier replies from the model. Defaults to None.`,name:"generated_responses"},{anchor:"huggingface_hub.InferenceClient.conversational.past_user_inputs",description:`<strong>past_user_inputs</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
A list of strings corresponding to the earlier replies from the user. Should be the same length as
<code>generated_responses</code>. Defaults to None.`,name:"past_user_inputs"},{anchor:"huggingface_hub.InferenceClient.conversational.parameters",description:`<strong>parameters</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional parameters for the conversational task. Defaults to None. For more details about the available
parameters, please refer to <a href="https://huggingface.co/docs/api-inference/detailed_parameters#conversational-task" rel="nofollow">this page</a>`,name:"parameters"},{anchor:"huggingface_hub.InferenceClient.conversational.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for the conversational task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended conversational model will be used.
Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2368/src/huggingface_hub/inference/_client.py#L827",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The generated conversational output.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Dict</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/pr_2368/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2368/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),pt=new A({props:{warning:!0,$$slots:{default:[yh]},$$scope:{ctx:I}}}),ut=new E({props:{anchor:"huggingface_hub.InferenceClient.conversational.example",$$slots:{default:[bh]},$$scope:{ctx:I}}}),Os=new k({props:{name:"document_question_answering",anchor:"huggingface_hub.InferenceClient.document_question_answering",parameters:[{name:"image",val:": Union"},{name:"question",val:": str"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.document_question_answering.image",description:`<strong>image</strong> (<code>Union[str, Path, bytes, BinaryIO]</code>) &#x2014;
The input image for the context. It can be raw bytes, an image file, or a URL to an online image.`,name:"image"},{anchor:"huggingface_hub.InferenceClient.document_question_answering.question",description:`<strong>question</strong> (<code>str</code>) &#x2014;
Question to be answered.`,name:"question"},{anchor:"huggingface_hub.InferenceClient.document_question_answering.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for the document question answering task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended document question answering model will be used.
Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2368/src/huggingface_hub/inference/_client.py#L900",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>a list of <a
  href="/docs/huggingface_hub/pr_2368/en/package_reference/inference_types#huggingface_hub.DocumentQuestionAnsweringOutputElement"
>DocumentQuestionAnsweringOutputElement</a> items containing the predicted label, associated probability, word ids, and page number.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[DocumentQuestionAnsweringOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/pr_2368/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2368/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),gt=new E({props:{anchor:"huggingface_hub.InferenceClient.document_question_answering.example",$$slots:{default:[Mh]},$$scope:{ctx:I}}}),Ks=new k({props:{name:"feature_extraction",anchor:"huggingface_hub.InferenceClient.feature_extraction",parameters:[{name:"text",val:": str"},{name:"normalize",val:": Optional = None"},{name:"prompt_name",val:": Optional = None"},{name:"truncate",val:": Optional = None"},{name:"truncation_direction",val:": Optional = None"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.feature_extraction.text",description:`<strong>text</strong> (<em>str</em>) &#x2014;
The text to embed.`,name:"text"},{anchor:"huggingface_hub.InferenceClient.feature_extraction.model",description:`<strong>model</strong> (<em>str</em>, <em>optional</em>) &#x2014;
The model to use for the conversational task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended conversational model will be used.
Defaults to None.`,name:"model"},{anchor:"huggingface_hub.InferenceClient.feature_extraction.normalize",description:`<strong>normalize</strong> (<em>bool</em>, <em>optional</em>) &#x2014;
Whether to normalize the embeddings or not. Defaults to None.
Only available on server powered by Text-Embedding-Inference.`,name:"normalize"},{anchor:"huggingface_hub.InferenceClient.feature_extraction.prompt_name",description:`<strong>prompt_name</strong> (<em>str</em>, <em>optional</em>) &#x2014;
The name of the prompt that should be used by for encoding. If not set, no prompt will be applied.
Must be a key in the <em>Sentence Transformers</em> configuration <em>prompts</em> dictionary.
For example if <code>prompt_name</code> is &#x201C;query&#x201D; and the <code>prompts</code> is {&#x201C;query&#x201D;: &#x201C;query: &#x201D;,&#x2026;},
then the sentence &#x201C;What is the capital of France?&#x201D; will be encoded as &#x201C;query: What is the capital of France?&#x201D;
because the prompt text will be prepended before any text to encode.`,name:"prompt_name"},{anchor:"huggingface_hub.InferenceClient.feature_extraction.truncate",description:`<strong>truncate</strong> (<em>bool</em>, <em>optional</em>) &#x2014;
Whether to truncate the embeddings or not. Defaults to None.
Only available on server powered by Text-Embedding-Inference.`,name:"truncate"},{anchor:"huggingface_hub.InferenceClient.feature_extraction.truncation_direction",description:`<strong>truncation_direction</strong> (<em>Literal[&#x201C;Left&#x201D;, &#x201C;Right&#x201D;]</em>, <em>optional</em>) &#x2014;
Which side of the input should be truncated when <em>truncate=True</em> is passed.`,name:"truncation_direction"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2368/src/huggingface_hub/inference/_client.py#L941",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The embedding representing the input text as a float32 numpy array.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><em>np.ndarray</em></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li>[<em>InferenceTimeoutError</em>] —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>[<em>InferenceTimeoutError</em>] or <code>HTTPError</code></p>
`}}),mt=new E({props:{anchor:"huggingface_hub.InferenceClient.feature_extraction.example",$$slots:{default:[jh]},$$scope:{ctx:I}}}),ea=new k({props:{name:"fill_mask",anchor:"huggingface_hub.InferenceClient.fill_mask",parameters:[{name:"text",val:": str"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.fill_mask.text",description:`<strong>text</strong> (<code>str</code>) &#x2014;
a string to be filled from, must contain the [MASK] token (check model card for exact name of the mask).`,name:"text"},{anchor:"huggingface_hub.InferenceClient.fill_mask.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for the fill mask task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended fill mask model will be used.
Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2368/src/huggingface_hub/inference/_client.py#L1009",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>a list of <a
  href="/docs/huggingface_hub/pr_2368/en/package_reference/inference_types#huggingface_hub.FillMaskOutputElement"
>FillMaskOutputElement</a> items containing the predicted label, associated
probability, token reference, and completed text.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[FillMaskOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/pr_2368/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2368/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),ht=new E({props:{anchor:"huggingface_hub.InferenceClient.fill_mask.example",$$slots:{default:[_h]},$$scope:{ctx:I}}}),na=new k({props:{name:"get_endpoint_info",anchor:"huggingface_hub.InferenceClient.get_endpoint_info",parameters:[{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.get_endpoint_info.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for inference. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. This parameter overrides the model defined at the instance level. Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2368/src/huggingface_hub/inference/_client.py#L2590",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Information about the endpoint.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Dict[str, Any]</code></p>
`}}),dt=new E({props:{anchor:"huggingface_hub.InferenceClient.get_endpoint_info.example",$$slots:{default:[Th]},$$scope:{ctx:I}}}),ta=new k({props:{name:"get_model_status",anchor:"huggingface_hub.InferenceClient.get_model_status",parameters:[{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.get_model_status.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Identifier of the model for witch the status gonna be checked. If model is not provided,
the model associated with this instance of <a href="/docs/huggingface_hub/pr_2368/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a> will be used. Only InferenceAPI service can be checked so the
identifier cannot be a URL.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2368/src/huggingface_hub/inference/_client.py#L2679",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>An instance of ModelStatus dataclass, containing information,
about the state of the model: load, state, compute type and framework.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>ModelStatus</code></p>
`}}),ft=new A({props:{$$slots:{default:[Ih]},$$scope:{ctx:I}}}),yt=new E({props:{anchor:"huggingface_hub.InferenceClient.get_model_status.example",$$slots:{default:[xh]},$$scope:{ctx:I}}}),sa=new k({props:{name:"get_recommended_model",anchor:"huggingface_hub.InferenceClient.get_recommended_model",parameters:[{name:"task",val:": str"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.get_recommended_model.task",description:`<strong>task</strong> (<code>str</code>) &#x2014;
The Hugging Face task to get which model Hugging Face recommends.
All available tasks can be found <a href="https://huggingface.co/tasks" rel="nofollow">here</a>.`,name:"task"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2368/src/huggingface_hub/inference/_client.py#L2566",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Name of the model recommended for the input task.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>str</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><code>ValueError</code> — If Hugging Face has no recommendation for the input task.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>ValueError</code></p>
`}}),aa=new k({props:{name:"health_check",anchor:"huggingface_hub.InferenceClient.health_check",parameters:[{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.health_check.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
URL of the Inference Endpoint. This parameter overrides the model defined at the instance level. Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2368/src/huggingface_hub/inference/_client.py#L2645",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>True if everything is working fine.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>bool</code></p>
`}}),Mt=new E({props:{anchor:"huggingface_hub.InferenceClient.health_check.example",$$slots:{default:[Jh]},$$scope:{ctx:I}}}),la=new k({props:{name:"image_classification",anchor:"huggingface_hub.InferenceClient.image_classification",parameters:[{name:"image",val:": Union"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.image_classification.image",description:`<strong>image</strong> (<code>Union[str, Path, bytes, BinaryIO]</code>) &#x2014;
The image to classify. It can be raw bytes, an image file, or a URL to an online image.`,name:"image"},{anchor:"huggingface_hub.InferenceClient.image_classification.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for image classification. Can be a model ID hosted on the Hugging Face Hub or a URL to a
deployed Inference Endpoint. If not provided, the default recommended model for image classification will be used.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2368/src/huggingface_hub/inference/_client.py#L1045",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>a list of <a
  href="/docs/huggingface_hub/pr_2368/en/package_reference/inference_types#huggingface_hub.ImageClassificationOutputElement"
>ImageClassificationOutputElement</a> items containing the predicted label and associated probability.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[ImageClassificationOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/pr_2368/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2368/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),jt=new E({props:{anchor:"huggingface_hub.InferenceClient.image_classification.example",$$slots:{default:[wh]},$$scope:{ctx:I}}}),oa=new k({props:{name:"image_segmentation",anchor:"huggingface_hub.InferenceClient.image_segmentation",parameters:[{name:"image",val:": Union"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.image_segmentation.image",description:`<strong>image</strong> (<code>Union[str, Path, bytes, BinaryIO]</code>) &#x2014;
The image to segment. It can be raw bytes, an image file, or a URL to an online image.`,name:"image"},{anchor:"huggingface_hub.InferenceClient.image_segmentation.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for image segmentation. Can be a model ID hosted on the Hugging Face Hub or a URL to a
deployed Inference Endpoint. If not provided, the default recommended model for image segmentation will be used.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2368/src/huggingface_hub/inference/_client.py#L1081",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of <a
  href="/docs/huggingface_hub/pr_2368/en/package_reference/inference_types#huggingface_hub.ImageSegmentationOutputElement"
>ImageSegmentationOutputElement</a> items containing the segmented masks and associated attributes.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[ImageSegmentationOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/pr_2368/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2368/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),_t=new A({props:{warning:!0,$$slots:{default:[Ch]},$$scope:{ctx:I}}}),Tt=new E({props:{anchor:"huggingface_hub.InferenceClient.image_segmentation.example",$$slots:{default:[Uh]},$$scope:{ctx:I}}}),ra=new k({props:{name:"image_to_image",anchor:"huggingface_hub.InferenceClient.image_to_image",parameters:[{name:"image",val:": Union"},{name:"prompt",val:": Optional = None"},{name:"negative_prompt",val:": Optional = None"},{name:"height",val:": Optional = None"},{name:"width",val:": Optional = None"},{name:"num_inference_steps",val:": Optional = None"},{name:"guidance_scale",val:": Optional = None"},{name:"model",val:": Optional = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.image_to_image.image",description:`<strong>image</strong> (<code>Union[str, Path, bytes, BinaryIO]</code>) &#x2014;
The input image for translation. It can be raw bytes, an image file, or a URL to an online image.`,name:"image"},{anchor:"huggingface_hub.InferenceClient.image_to_image.prompt",description:`<strong>prompt</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The text prompt to guide the image generation.`,name:"prompt"},{anchor:"huggingface_hub.InferenceClient.image_to_image.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code>, <em>optional</em>) &#x2014;
A negative prompt to guide the translation process.`,name:"negative_prompt"},{anchor:"huggingface_hub.InferenceClient.image_to_image.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"huggingface_hub.InferenceClient.image_to_image.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"huggingface_hub.InferenceClient.image_to_image.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"huggingface_hub.InferenceClient.image_to_image.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"huggingface_hub.InferenceClient.image_to_image.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for inference. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. This parameter overrides the model defined at the instance level. Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2368/src/huggingface_hub/inference/_client.py#L1126",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The translated image.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Image</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/pr_2368/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2368/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),It=new A({props:{warning:!0,$$slots:{default:[$h]},$$scope:{ctx:I}}}),xt=new E({props:{anchor:"huggingface_hub.InferenceClient.image_to_image.example",$$slots:{default:[vh]},$$scope:{ctx:I}}}),ia=new k({props:{name:"image_to_text",anchor:"huggingface_hub.InferenceClient.image_to_text",parameters:[{name:"image",val:": Union"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.image_to_text.image",description:`<strong>image</strong> (<code>Union[str, Path, bytes, BinaryIO]</code>) &#x2014;
The input image to caption. It can be raw bytes, an image file, or a URL to an online image..`,name:"image"},{anchor:"huggingface_hub.InferenceClient.image_to_text.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for inference. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. This parameter overrides the model defined at the instance level. Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2368/src/huggingface_hub/inference/_client.py#L1210",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The generated text.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2368/en/package_reference/inference_types#huggingface_hub.ImageToTextOutput"
>ImageToTextOutput</a></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/pr_2368/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2368/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),Jt=new E({props:{anchor:"huggingface_hub.InferenceClient.image_to_text.example",$$slots:{default:[kh]},$$scope:{ctx:I}}}),ca=new k({props:{name:"list_deployed_models",anchor:"huggingface_hub.InferenceClient.list_deployed_models",parameters:[{name:"frameworks",val:": Union = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.list_deployed_models.frameworks",description:`<strong>frameworks</strong> (<code>Literal[&quot;all&quot;]</code> or <code>List[str]</code> or <code>str</code>, <em>optional</em>) &#x2014;
The frameworks to filter on. By default only a subset of the available frameworks are tested. If set to
&#x201C;all&#x201D;, all available frameworks will be tested. It is also possible to provide a single framework or a
custom set of frameworks to check.`,name:"frameworks"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2368/src/huggingface_hub/inference/_client.py#L1247",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A dictionary mapping task names to a sorted list of model IDs.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Dict[str, List[str]]</code></p>
`}}),wt=new A({props:{warning:!0,$$slots:{default:[qh]},$$scope:{ctx:I}}}),Ct=new A({props:{$$slots:{default:[Eh]},$$scope:{ctx:I}}}),Ut=new E({props:{anchor:"huggingface_hub.InferenceClient.list_deployed_models.example",$$slots:{default:[Ah]},$$scope:{ctx:I}}}),pa=new k({props:{name:"object_detection",anchor:"huggingface_hub.InferenceClient.object_detection",parameters:[{name:"image",val:": Union"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.object_detection.image",description:`<strong>image</strong> (<code>Union[str, Path, bytes, BinaryIO]</code>) &#x2014;
The image to detect objects on. It can be raw bytes, an image file, or a URL to an online image.`,name:"image"},{anchor:"huggingface_hub.InferenceClient.object_detection.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for object detection. Can be a model ID hosted on the Hugging Face Hub or a URL to a
deployed Inference Endpoint. If not provided, the default recommended model for object detection (DETR) will be used.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2368/src/huggingface_hub/inference/_client.py#L1330",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of <a
  href="/docs/huggingface_hub/pr_2368/en/package_reference/inference_types#huggingface_hub.ObjectDetectionOutputElement"
>ObjectDetectionOutputElement</a> items containing the bounding boxes and associated attributes.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[ObjectDetectionOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/pr_2368/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
<li><code>ValueError</code> —
If the request output is not a List.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2368/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code> or <code>ValueError</code></p>
`}}),$t=new A({props:{warning:!0,$$slots:{default:[Zh]},$$scope:{ctx:I}}}),vt=new E({props:{anchor:"huggingface_hub.InferenceClient.object_detection.example",$$slots:{default:[Wh]},$$scope:{ctx:I}}}),ua=new k({props:{name:"post",anchor:"huggingface_hub.InferenceClient.post",parameters:[{name:"json",val:": Union = None"},{name:"data",val:": Union = None"},{name:"model",val:": Optional = None"},{name:"task",val:": Optional = None"},{name:"stream",val:": bool = False"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.post.json",description:`<strong>json</strong> (<code>Union[str, Dict, List]</code>, <em>optional</em>) &#x2014;
The JSON data to send in the request body, specific to each task. Defaults to None.`,name:"json"},{anchor:"huggingface_hub.InferenceClient.post.data",description:`<strong>data</strong> (<code>Union[str, Path, bytes, BinaryIO]</code>, <em>optional</em>) &#x2014;
The content to send in the request body, specific to each task.
It can be raw bytes, a pointer to an opened file, a local file path,
or a URL to an online resource (image, audio file,&#x2026;). If both <code>json</code> and <code>data</code> are passed,
<code>data</code> will take precedence. At least <code>json</code> or <code>data</code> must be provided. Defaults to None.`,name:"data"},{anchor:"huggingface_hub.InferenceClient.post.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for inference. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. Will override the model defined at the instance level. Defaults to None.`,name:"model"},{anchor:"huggingface_hub.InferenceClient.post.task",description:`<strong>task</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The task to perform on the inference. All available tasks can be found
<a href="https://huggingface.co/tasks" rel="nofollow">here</a>. Used only to default to a recommended model if <code>model</code> is not
provided. At least <code>model</code> or <code>task</code> must be provided. Defaults to None.`,name:"task"},{anchor:"huggingface_hub.InferenceClient.post.stream",description:`<strong>stream</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to iterate over streaming APIs.`,name:"stream"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2368/src/huggingface_hub/inference/_client.py#L207",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The raw bytes returned by the server.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>bytes</p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/pr_2368/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2368/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),ga=new k({props:{name:"question_answering",anchor:"huggingface_hub.InferenceClient.question_answering",parameters:[{name:"question",val:": str"},{name:"context",val:": str"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.question_answering.question",description:`<strong>question</strong> (<code>str</code>) &#x2014;
Question to be answered.`,name:"question"},{anchor:"huggingface_hub.InferenceClient.question_answering.context",description:`<strong>context</strong> (<code>str</code>) &#x2014;
The context of the question.`,name:"context"},{anchor:"huggingface_hub.InferenceClient.question_answering.model",description:`<strong>model</strong> (<code>str</code>) &#x2014;
The model to use for the question answering task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2368/src/huggingface_hub/inference/_client.py#L1375",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>an question answering output containing the score, start index, end index, and answer.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2368/en/package_reference/inference_types#huggingface_hub.QuestionAnsweringOutputElement"
>QuestionAnsweringOutputElement</a></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/pr_2368/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2368/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),qt=new E({props:{anchor:"huggingface_hub.InferenceClient.question_answering.example",$$slots:{default:[Nh]},$$scope:{ctx:I}}}),ma=new k({props:{name:"sentence_similarity",anchor:"huggingface_hub.InferenceClient.sentence_similarity",parameters:[{name:"sentence",val:": str"},{name:"other_sentences",val:": List"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.sentence_similarity.sentence",description:`<strong>sentence</strong> (<code>str</code>) &#x2014;
The main sentence to compare to others.`,name:"sentence"},{anchor:"huggingface_hub.InferenceClient.sentence_similarity.other_sentences",description:`<strong>other_sentences</strong> (<code>List[str]</code>) &#x2014;
The list of sentences to compare to.`,name:"other_sentences"},{anchor:"huggingface_hub.InferenceClient.sentence_similarity.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for the conversational task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended conversational model will be used.
Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2368/src/huggingface_hub/inference/_client.py#L1416",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The embedding representing the input text.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[float]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/pr_2368/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2368/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),Et=new E({props:{anchor:"huggingface_hub.InferenceClient.sentence_similarity.example",$$slots:{default:[Gh]},$$scope:{ctx:I}}}),ha=new k({props:{name:"summarization",anchor:"huggingface_hub.InferenceClient.summarization",parameters:[{name:"text",val:": str"},{name:"parameters",val:": Optional = None"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.summarization.text",description:`<strong>text</strong> (<code>str</code>) &#x2014;
The input text to summarize.`,name:"text"},{anchor:"huggingface_hub.InferenceClient.summarization.parameters",description:`<strong>parameters</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional parameters for summarization. Check out this <a href="https://huggingface.co/docs/api-inference/detailed_parameters#summarization-task" rel="nofollow">page</a>
for more details.`,name:"parameters"},{anchor:"huggingface_hub.InferenceClient.summarization.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for inference. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. This parameter overrides the model defined at the instance level. Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2368/src/huggingface_hub/inference/_client.py#L1463",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The generated summary text.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2368/en/package_reference/inference_types#huggingface_hub.SummarizationOutput"
>SummarizationOutput</a></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/pr_2368/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2368/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),At=new E({props:{anchor:"huggingface_hub.InferenceClient.summarization.example",$$slots:{default:[Bh]},$$scope:{ctx:I}}}),da=new k({props:{name:"table_question_answering",anchor:"huggingface_hub.InferenceClient.table_question_answering",parameters:[{name:"table",val:": Dict"},{name:"query",val:": str"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.table_question_answering.table",description:`<strong>table</strong> (<code>str</code>) &#x2014;
A table of data represented as a dict of lists where entries are headers and the lists are all the
values, all lists must have the same size.`,name:"table"},{anchor:"huggingface_hub.InferenceClient.table_question_answering.query",description:`<strong>query</strong> (<code>str</code>) &#x2014;
The query in plain text that you want to ask the table.`,name:"query"},{anchor:"huggingface_hub.InferenceClient.table_question_answering.model",description:`<strong>model</strong> (<code>str</code>) &#x2014;
The model to use for the table-question-answering task. Can be a model ID hosted on the Hugging Face
Hub or a URL to a deployed Inference Endpoint.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2368/src/huggingface_hub/inference/_client.py#L1506",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>a table question answering output containing the answer, coordinates, cells and the aggregator used.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2368/en/package_reference/inference_types#huggingface_hub.TableQuestionAnsweringOutputElement"
>TableQuestionAnsweringOutputElement</a></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/pr_2368/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2368/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),Zt=new E({props:{anchor:"huggingface_hub.InferenceClient.table_question_answering.example",$$slots:{default:[Vh]},$$scope:{ctx:I}}}),fa=new k({props:{name:"tabular_classification",anchor:"huggingface_hub.InferenceClient.tabular_classification",parameters:[{name:"table",val:": Dict"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.tabular_classification.table",description:`<strong>table</strong> (<code>Dict[str, Any]</code>) &#x2014;
Set of attributes to classify.`,name:"table"},{anchor:"huggingface_hub.InferenceClient.tabular_classification.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for the tabular classification task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended tabular classification model will be used.
Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2368/src/huggingface_hub/inference/_client.py#L1551",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>a list of labels, one per row in the initial table.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/pr_2368/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2368/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),Wt=new E({props:{anchor:"huggingface_hub.InferenceClient.tabular_classification.example",$$slots:{default:[Qh]},$$scope:{ctx:I}}}),ya=new k({props:{name:"tabular_regression",anchor:"huggingface_hub.InferenceClient.tabular_regression",parameters:[{name:"table",val:": Dict"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.tabular_regression.table",description:`<strong>table</strong> (<code>Dict[str, Any]</code>) &#x2014;
Set of attributes stored in a table. The attributes used to predict the target can be both numerical and categorical.`,name:"table"},{anchor:"huggingface_hub.InferenceClient.tabular_regression.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for the tabular regression task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended tabular regression model will be used.
Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2368/src/huggingface_hub/inference/_client.py#L1596",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>a list of predicted numerical target values.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/pr_2368/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2368/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),Nt=new E({props:{anchor:"huggingface_hub.InferenceClient.tabular_regression.example",$$slots:{default:[Yh]},$$scope:{ctx:I}}}),ba=new k({props:{name:"text_classification",anchor:"huggingface_hub.InferenceClient.text_classification",parameters:[{name:"text",val:": str"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.text_classification.text",description:`<strong>text</strong> (<code>str</code>) &#x2014;
A string to be classified.`,name:"text"},{anchor:"huggingface_hub.InferenceClient.text_classification.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for the text classification task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended text classification model will be used.
Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2368/src/huggingface_hub/inference/_client.py#L1636",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>a list of <a
  href="/docs/huggingface_hub/pr_2368/en/package_reference/inference_types#huggingface_hub.TextClassificationOutputElement"
>TextClassificationOutputElement</a> items containing the predicted label and associated probability.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[TextClassificationOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/pr_2368/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2368/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),Gt=new E({props:{anchor:"huggingface_hub.InferenceClient.text_classification.example",$$slots:{default:[Sh]},$$scope:{ctx:I}}}),Ma=new k({props:{name:"text_generation",anchor:"huggingface_hub.InferenceClient.text_generation",parameters:[{name:"prompt",val:": str"},{name:"details",val:": bool = False"},{name:"stream",val:": bool = False"},{name:"model",val:": Optional = None"},{name:"best_of",val:": Optional = None"},{name:"decoder_input_details",val:": Optional = None"},{name:"do_sample",val:": Optional = False"},{name:"frequency_penalty",val:": Optional = None"},{name:"grammar",val:": Optional = None"},{name:"max_new_tokens",val:": Optional = None"},{name:"repetition_penalty",val:": Optional = None"},{name:"return_full_text",val:": Optional = False"},{name:"seed",val:": Optional = None"},{name:"stop_sequences",val:": Optional = None"},{name:"temperature",val:": Optional = None"},{name:"top_k",val:": Optional = None"},{name:"top_n_tokens",val:": Optional = None"},{name:"top_p",val:": Optional = None"},{name:"truncate",val:": Optional = None"},{name:"typical_p",val:": Optional = None"},{name:"watermark",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.text_generation.prompt",description:`<strong>prompt</strong> (<code>str</code>) &#x2014;
Input text.`,name:"prompt"},{anchor:"huggingface_hub.InferenceClient.text_generation.details",description:`<strong>details</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
By default, text_generation returns a string. Pass <code>details=True</code> if you want a detailed output (tokens,
probabilities, seed, finish reason, etc.). Only available for models running on with the
<code>text-generation-inference</code> backend.`,name:"details"},{anchor:"huggingface_hub.InferenceClient.text_generation.stream",description:`<strong>stream</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
By default, text_generation returns the full generated text. Pass <code>stream=True</code> if you want a stream of
tokens to be returned. Only available for models running on with the <code>text-generation-inference</code>
backend.`,name:"stream"},{anchor:"huggingface_hub.InferenceClient.text_generation.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for inference. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. This parameter overrides the model defined at the instance level. Defaults to None.`,name:"model"},{anchor:"huggingface_hub.InferenceClient.text_generation.best_of",description:`<strong>best_of</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Generate best_of sequences and return the one if the highest token logprobs.`,name:"best_of"},{anchor:"huggingface_hub.InferenceClient.text_generation.decoder_input_details",description:`<strong>decoder_input_details</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Return the decoder input token logprobs and ids. You must set <code>details=True</code> as well for it to be taken
into account. Defaults to <code>False</code>.`,name:"decoder_input_details"},{anchor:"huggingface_hub.InferenceClient.text_generation.do_sample",description:`<strong>do_sample</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Activate logits sampling`,name:"do_sample"},{anchor:"huggingface_hub.InferenceClient.text_generation.frequency_penalty",description:`<strong>frequency_penalty</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Number between -2.0 and 2.0. Positive values penalize new tokens based on their existing frequency in
the text so far, decreasing the model&#x2019;s likelihood to repeat the same line verbatim.`,name:"frequency_penalty"},{anchor:"huggingface_hub.InferenceClient.text_generation.grammar",description:`<strong>grammar</strong> (<a href="/docs/huggingface_hub/pr_2368/en/package_reference/inference_types#huggingface_hub.TextGenerationInputGrammarType">TextGenerationInputGrammarType</a>, <em>optional</em>) &#x2014;
Grammar constraints. Can be either a JSONSchema or a regex.`,name:"grammar"},{anchor:"huggingface_hub.InferenceClient.text_generation.max_new_tokens",description:`<strong>max_new_tokens</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Maximum number of generated tokens`,name:"max_new_tokens"},{anchor:"huggingface_hub.InferenceClient.text_generation.repetition_penalty",description:`<strong>repetition_penalty</strong> (<code>float</code>, <em>optional</em>) &#x2014;
The parameter for repetition penalty. 1.0 means no penalty. See <a href="https://arxiv.org/pdf/1909.05858.pdf" rel="nofollow">this
paper</a> for more details.`,name:"repetition_penalty"},{anchor:"huggingface_hub.InferenceClient.text_generation.return_full_text",description:`<strong>return_full_text</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to prepend the prompt to the generated text`,name:"return_full_text"},{anchor:"huggingface_hub.InferenceClient.text_generation.seed",description:`<strong>seed</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Random sampling seed`,name:"seed"},{anchor:"huggingface_hub.InferenceClient.text_generation.stop_sequences",description:`<strong>stop_sequences</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
Stop generating tokens if a member of <code>stop_sequences</code> is generated`,name:"stop_sequences"},{anchor:"huggingface_hub.InferenceClient.text_generation.temperature",description:`<strong>temperature</strong> (<code>float</code>, <em>optional</em>) &#x2014;
The value used to module the logits distribution.`,name:"temperature"},{anchor:"huggingface_hub.InferenceClient.text_generation.top_n_tokens",description:`<strong>top_n_tokens</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Return information about the <code>top_n_tokens</code> most likely tokens at each generation step, instead of
just the sampled token.`,name:"top_n_tokens"},{anchor:"huggingface_hub.InferenceClient.text_generation.top_k",description:"<strong>top_k</strong> (<code>int</code>, *optional`) &#x2014;\nThe number of highest probability vocabulary tokens to keep for top-k-filtering.",name:"top_k"},{anchor:"huggingface_hub.InferenceClient.text_generation.top_p",description:"<strong>top_p</strong> (<code>float</code>, *optional<code>) -- If set to &lt; 1, only the smallest set of most probable tokens with probabilities that add up to </code>top_p` or\nhigher are kept for generation.",name:"top_p"},{anchor:"huggingface_hub.InferenceClient.text_generation.truncate",description:"<strong>truncate</strong> (<code>int</code>, *optional`) &#x2014;\nTruncate inputs tokens to the given size.",name:"truncate"},{anchor:"huggingface_hub.InferenceClient.text_generation.typical_p",description:`<strong>typical_p</strong> (<code>float</code>, *optional\`) &#x2014;
Typical Decoding mass
See <a href="https://arxiv.org/abs/2202.00666" rel="nofollow">Typical Decoding for Natural Language Generation</a> for more information`,name:"typical_p"},{anchor:"huggingface_hub.InferenceClient.text_generation.watermark",description:'<strong>watermark</strong> (<code>bool</code>, *optional`) &#x2014;\nWatermarking with <a href="https://arxiv.org/abs/2301.10226" rel="nofollow">A Watermark for Large Language Models</a>',name:"watermark"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2368/src/huggingface_hub/inference/_client.py#L1811",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Generated text returned from the server:</p>
<ul>
<li>if <code>stream=False</code> and <code>details=False</code>, the generated text is returned as a <code>str</code> (default)</li>
<li>if <code>stream=True</code> and <code>details=False</code>, the generated text is returned token by token as a <code>Iterable[str]</code></li>
<li>if <code>stream=False</code> and <code>details=True</code>, the generated text is returned with more details as a <a
  href="/docs/huggingface_hub/pr_2368/en/package_reference/inference_types#huggingface_hub.TextGenerationOutput"
>TextGenerationOutput</a></li>
<li>if <code>details=True</code> and <code>stream=True</code>, the generated text is returned token by token as a iterable of <a
  href="/docs/huggingface_hub/pr_2368/en/package_reference/inference_types#huggingface_hub.TextGenerationStreamOutput"
>TextGenerationStreamOutput</a></li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Union[str, TextGenerationOutput, Iterable[str], Iterable[TextGenerationStreamOutput]]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><code>ValidationError</code> —
If input values are not valid. No HTTP call is made to the server.</li>
<li><a
  href="/docs/huggingface_hub/pr_2368/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>ValidationError</code> or <a
  href="/docs/huggingface_hub/pr_2368/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),Bt=new A({props:{$$slots:{default:[Dh]},$$scope:{ctx:I}}}),Vt=new E({props:{anchor:"huggingface_hub.InferenceClient.text_generation.example",$$slots:{default:[Rh]},$$scope:{ctx:I}}}),ja=new k({props:{name:"text_to_image",anchor:"huggingface_hub.InferenceClient.text_to_image",parameters:[{name:"prompt",val:": str"},{name:"negative_prompt",val:": Optional = None"},{name:"height",val:": Optional = None"},{name:"width",val:": Optional = None"},{name:"num_inference_steps",val:": Optional = None"},{name:"guidance_scale",val:": Optional = None"},{name:"model",val:": Optional = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.text_to_image.prompt",description:`<strong>prompt</strong> (<code>str</code>) &#x2014;
The prompt to generate an image from.`,name:"prompt"},{anchor:"huggingface_hub.InferenceClient.text_to_image.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code>, <em>optional</em>) &#x2014;
An optional negative prompt for the image generation.`,name:"negative_prompt"},{anchor:"huggingface_hub.InferenceClient.text_to_image.height",description:`<strong>height</strong> (<code>float</code>, <em>optional</em>) &#x2014;
The height in pixels of the image to generate.`,name:"height"},{anchor:"huggingface_hub.InferenceClient.text_to_image.width",description:`<strong>width</strong> (<code>float</code>, <em>optional</em>) &#x2014;
The width in pixels of the image to generate.`,name:"width"},{anchor:"huggingface_hub.InferenceClient.text_to_image.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"huggingface_hub.InferenceClient.text_to_image.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"huggingface_hub.InferenceClient.text_to_image.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for inference. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. This parameter overrides the model defined at the instance level. Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2368/src/huggingface_hub/inference/_client.py#L2135",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The generated image.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Image</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/pr_2368/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2368/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),Qt=new A({props:{warning:!0,$$slots:{default:[Xh]},$$scope:{ctx:I}}}),Yt=new E({props:{anchor:"huggingface_hub.InferenceClient.text_to_image.example",$$slots:{default:[Hh]},$$scope:{ctx:I}}}),_a=new k({props:{name:"text_to_speech",anchor:"huggingface_hub.InferenceClient.text_to_speech",parameters:[{name:"text",val:": str"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.text_to_speech.text",description:`<strong>text</strong> (<code>str</code>) &#x2014;
The text to synthesize.`,name:"text"},{anchor:"huggingface_hub.InferenceClient.text_to_speech.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for inference. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. This parameter overrides the model defined at the instance level. Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2368/src/huggingface_hub/inference/_client.py#L2215",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The generated audio.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>bytes</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/pr_2368/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2368/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),St=new E({props:{anchor:"huggingface_hub.InferenceClient.text_to_speech.example",$$slots:{default:[Fh]},$$scope:{ctx:I}}}),Ta=new k({props:{name:"token_classification",anchor:"huggingface_hub.InferenceClient.token_classification",parameters:[{name:"text",val:": str"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.token_classification.text",description:`<strong>text</strong> (<code>str</code>) &#x2014;
A string to be classified.`,name:"text"},{anchor:"huggingface_hub.InferenceClient.token_classification.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for the token classification task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended token classification model will be used.
Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2368/src/huggingface_hub/inference/_client.py#L2247",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List of <a
  href="/docs/huggingface_hub/pr_2368/en/package_reference/inference_types#huggingface_hub.TokenClassificationOutputElement"
>TokenClassificationOutputElement</a> items containing the entity group, confidence score, word, start and end index.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[TokenClassificationOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/pr_2368/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2368/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),Dt=new E({props:{anchor:"huggingface_hub.InferenceClient.token_classification.example",$$slots:{default:[zh]},$$scope:{ctx:I}}}),Ia=new k({props:{name:"translation",anchor:"huggingface_hub.InferenceClient.translation",parameters:[{name:"text",val:": str"},{name:"model",val:": Optional = None"},{name:"src_lang",val:": Optional = None"},{name:"tgt_lang",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.translation.text",description:`<strong>text</strong> (<code>str</code>) &#x2014;
A string to be translated.`,name:"text"},{anchor:"huggingface_hub.InferenceClient.translation.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for the translation task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended translation model will be used.
Defaults to None.`,name:"model"},{anchor:"huggingface_hub.InferenceClient.translation.src_lang",description:`<strong>src_lang</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Source language of the translation task, i.e. input language. Cannot be passed without <code>tgt_lang</code>.`,name:"src_lang"},{anchor:"huggingface_hub.InferenceClient.translation.tgt_lang",description:`<strong>tgt_lang</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Target language of the translation task, i.e. output language. Cannot be passed without <code>src_lang</code>.`,name:"tgt_lang"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2368/src/huggingface_hub/inference/_client.py#L2302",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The generated translated text.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2368/en/package_reference/inference_types#huggingface_hub.TranslationOutput"
>TranslationOutput</a></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/pr_2368/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
<li><code>ValueError</code> —
If only one of the <code>src_lang</code> and <code>tgt_lang</code> arguments are provided.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2368/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code> or <code>ValueError</code></p>
`}}),Rt=new E({props:{anchor:"huggingface_hub.InferenceClient.translation.example",$$slots:{default:[Lh]},$$scope:{ctx:I}}}),Xt=new E({props:{anchor:"huggingface_hub.InferenceClient.translation.example-2",$$slots:{default:[Ph]},$$scope:{ctx:I}}}),xa=new k({props:{name:"visual_question_answering",anchor:"huggingface_hub.InferenceClient.visual_question_answering",parameters:[{name:"image",val:": Union"},{name:"question",val:": str"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.visual_question_answering.image",description:`<strong>image</strong> (<code>Union[str, Path, bytes, BinaryIO]</code>) &#x2014;
The input image for the context. It can be raw bytes, an image file, or a URL to an online image.`,name:"image"},{anchor:"huggingface_hub.InferenceClient.visual_question_answering.question",description:`<strong>question</strong> (<code>str</code>) &#x2014;
Question to be answered.`,name:"question"},{anchor:"huggingface_hub.InferenceClient.visual_question_answering.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for the visual question answering task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended visual question answering model will be used.
Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2368/src/huggingface_hub/inference/_client.py#L2367",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>a list of <a
  href="/docs/huggingface_hub/pr_2368/en/package_reference/inference_types#huggingface_hub.VisualQuestionAnsweringOutputElement"
>VisualQuestionAnsweringOutputElement</a> items containing the predicted label and associated probability.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[VisualQuestionAnsweringOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><code>InferenceTimeoutError</code> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>InferenceTimeoutError</code> or <code>HTTPError</code></p>
`}}),Ht=new E({props:{anchor:"huggingface_hub.InferenceClient.visual_question_answering.example",$$slots:{default:[Oh]},$$scope:{ctx:I}}}),Ja=new k({props:{name:"zero_shot_classification",anchor:"huggingface_hub.InferenceClient.zero_shot_classification",parameters:[{name:"text",val:": str"},{name:"labels",val:": List"},{name:"multi_label",val:": bool = False"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.zero_shot_classification.text",description:`<strong>text</strong> (<code>str</code>) &#x2014;
The input text to classify.`,name:"text"},{anchor:"huggingface_hub.InferenceClient.zero_shot_classification.labels",description:`<strong>labels</strong> (<code>List[str]</code>) &#x2014;
List of string possible labels. There must be at least 2 labels.`,name:"labels"},{anchor:"huggingface_hub.InferenceClient.zero_shot_classification.multi_label",description:`<strong>multi_label</strong> (<code>bool</code>) &#x2014;
Boolean that is set to True if classes can overlap.`,name:"multi_label"},{anchor:"huggingface_hub.InferenceClient.zero_shot_classification.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for inference. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. This parameter overrides the model defined at the instance level. Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2368/src/huggingface_hub/inference/_client.py#L2414",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List of <a
  href="/docs/huggingface_hub/pr_2368/en/package_reference/inference_types#huggingface_hub.ZeroShotClassificationOutputElement"
>ZeroShotClassificationOutputElement</a> items containing the predicted labels and their confidence.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[ZeroShotClassificationOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/pr_2368/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2368/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),Ft=new E({props:{anchor:"huggingface_hub.InferenceClient.zero_shot_classification.example",$$slots:{default:[Kh]},$$scope:{ctx:I}}}),wa=new k({props:{name:"zero_shot_image_classification",anchor:"huggingface_hub.InferenceClient.zero_shot_image_classification",parameters:[{name:"image",val:": Union"},{name:"labels",val:": List"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.zero_shot_image_classification.image",description:`<strong>image</strong> (<code>Union[str, Path, bytes, BinaryIO]</code>) &#x2014;
The input image to caption. It can be raw bytes, an image file, or a URL to an online image.`,name:"image"},{anchor:"huggingface_hub.InferenceClient.zero_shot_image_classification.labels",description:`<strong>labels</strong> (<code>List[str]</code>) &#x2014;
List of string possible labels. There must be at least 2 labels.`,name:"labels"},{anchor:"huggingface_hub.InferenceClient.zero_shot_image_classification.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for inference. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. This parameter overrides the model defined at the instance level. Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2368/src/huggingface_hub/inference/_client.py#L2489",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List of <a
  href="/docs/huggingface_hub/pr_2368/en/package_reference/inference_types#huggingface_hub.ZeroShotImageClassificationOutputElement"
>ZeroShotImageClassificationOutputElement</a> items containing the predicted labels and their confidence.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[ZeroShotImageClassificationOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/pr_2368/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2368/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),zt=new E({props:{anchor:"huggingface_hub.InferenceClient.zero_shot_image_classification.example",$$slots:{default:[ed]},$$scope:{ctx:I}}}),Ca=new mr({props:{title:"Async Inference Client",local:"huggingface_hub.AsyncInferenceClient",headingTag:"h2"}}),$a=new q({props:{code:"cGlwJTIwaW5zdGFsbCUyMC0tdXBncmFkZSUyMGh1Z2dpbmdmYWNlX2h1YiU1QmluZmVyZW5jZSU1RCUwQSUyMyUyMG9yJTBBJTIzJTIwcGlwJTIwaW5zdGFsbCUyMGFpb2h0dHA=",highlighted:`pip install --upgrade huggingface_hub[inference]
<span class="hljs-comment"># or</span>
<span class="hljs-comment"># pip install aiohttp</span>`,wrap:!1}}),va=new k({props:{name:"class huggingface_hub.AsyncInferenceClient",anchor:"huggingface_hub.AsyncInferenceClient",parameters:[{name:"model",val:": Optional = None"},{name:"token",val:": Union = None"},{name:"timeout",val:": Optional = None"},{name:"headers",val:": Optional = None"},{name:"cookies",val:": Optional = None"},{name:"proxies",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.model",description:`<strong>model</strong> (<code>str</code>, <code>optional</code>) &#x2014;
The model to run inference with. Can be a model id hosted on the Hugging Face Hub, e.g. <code>bigcode/starcoder</code>
or a URL to a deployed Inference Endpoint. Defaults to None, in which case a recommended model is
automatically selected for the task.`,name:"model"},{anchor:"huggingface_hub.AsyncInferenceClient.token",description:`<strong>token</strong> (<code>str</code> or <code>bool</code>, <em>optional</em>) &#x2014;
Hugging Face token. Will default to the locally saved token if not provided.
Pass <code>token=False</code> if you don&#x2019;t want to send your token to the server.`,name:"token"},{anchor:"huggingface_hub.AsyncInferenceClient.timeout",description:`<strong>timeout</strong> (<code>float</code>, <code>optional</code>) &#x2014;
The maximum number of seconds to wait for a response from the server. Loading a new model in Inference
API can take up to several minutes. Defaults to None, meaning it will loop until the server is available.`,name:"timeout"},{anchor:"huggingface_hub.AsyncInferenceClient.headers",description:`<strong>headers</strong> (<code>Dict[str, str]</code>, <code>optional</code>) &#x2014;
Additional headers to send to the server. By default only the authorization and user-agent headers are sent.
Values in this dictionary will override the default values.`,name:"headers"},{anchor:"huggingface_hub.AsyncInferenceClient.cookies",description:`<strong>cookies</strong> (<code>Dict[str, str]</code>, <code>optional</code>) &#x2014;
Additional cookies to send to the server.`,name:"cookies"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2368/src/huggingface_hub/inference/_generated/_async_client.py#L113"}}),ka=new k({props:{name:"audio_classification",anchor:"huggingface_hub.AsyncInferenceClient.audio_classification",parameters:[{name:"audio",val:": Union"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.audio_classification.audio",description:`<strong>audio</strong> (Union[str, Path, bytes, BinaryIO]) &#x2014;
The audio content to classify. It can be raw audio bytes, a local audio file, or a URL pointing to an
audio file.`,name:"audio"},{anchor:"huggingface_hub.AsyncInferenceClient.audio_classification.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for audio classification. Can be a model ID hosted on the Hugging Face Hub
or a URL to a deployed Inference Endpoint. If not provided, the default recommended model for
audio classification will be used.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2368/src/huggingface_hub/inference/_generated/_async_client.py#L300",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List of <a
  href="/docs/huggingface_hub/pr_2368/en/package_reference/inference_types#huggingface_hub.AudioClassificationOutputElement"
>AudioClassificationOutputElement</a> items containing the predicted labels and their confidence.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[AudioClassificationOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/pr_2368/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2368/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),Lt=new E({props:{anchor:"huggingface_hub.AsyncInferenceClient.audio_classification.example",$$slots:{default:[nd]},$$scope:{ctx:I}}}),qa=new k({props:{name:"audio_to_audio",anchor:"huggingface_hub.AsyncInferenceClient.audio_to_audio",parameters:[{name:"audio",val:": Union"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.audio_to_audio.audio",description:`<strong>audio</strong> (Union[str, Path, bytes, BinaryIO]) &#x2014;
The audio content for the model. It can be raw audio bytes, a local audio file, or a URL pointing to an
audio file.`,name:"audio"},{anchor:"huggingface_hub.AsyncInferenceClient.audio_to_audio.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model can be any model which takes an audio file and returns another audio file. Can be a model ID hosted on the Hugging Face Hub
or a URL to a deployed Inference Endpoint. If not provided, the default recommended model for
audio_to_audio will be used.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2368/src/huggingface_hub/inference/_generated/_async_client.py#L343",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of <a
  href="/docs/huggingface_hub/pr_2368/en/package_reference/inference_types#huggingface_hub.AudioToAudioOutputElement"
>AudioToAudioOutputElement</a> items containing audios label, content-type, and audio content in blob.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[AudioToAudioOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><code>InferenceTimeoutError</code> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>InferenceTimeoutError</code> or <code>aiohttp.ClientResponseError</code></p>
`}}),Pt=new E({props:{anchor:"huggingface_hub.AsyncInferenceClient.audio_to_audio.example",$$slots:{default:[td]},$$scope:{ctx:I}}}),Ea=new k({props:{name:"automatic_speech_recognition",anchor:"huggingface_hub.AsyncInferenceClient.automatic_speech_recognition",parameters:[{name:"audio",val:": Union"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.automatic_speech_recognition.audio",description:`<strong>audio</strong> (Union[str, Path, bytes, BinaryIO]) &#x2014;
The content to transcribe. It can be raw audio bytes, local audio file, or a URL to an audio file.`,name:"audio"},{anchor:"huggingface_hub.AsyncInferenceClient.automatic_speech_recognition.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for ASR. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. If not provided, the default recommended model for ASR will be used.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2368/src/huggingface_hub/inference/_generated/_async_client.py#L387",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>An item containing the transcribed text and optionally the timestamp chunks.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2368/en/package_reference/inference_types#huggingface_hub.AutomaticSpeechRecognitionOutput"
>AutomaticSpeechRecognitionOutput</a></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/pr_2368/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2368/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),Ot=new E({props:{anchor:"huggingface_hub.AsyncInferenceClient.automatic_speech_recognition.example",$$slots:{default:[sd]},$$scope:{ctx:I}}}),Aa=new k({props:{name:"chat_completion",anchor:"huggingface_hub.AsyncInferenceClient.chat_completion",parameters:[{name:"messages",val:": List"},{name:"model",val:": Optional = None"},{name:"stream",val:": bool = False"},{name:"frequency_penalty",val:": Optional = None"},{name:"logit_bias",val:": Optional = None"},{name:"logprobs",val:": Optional = None"},{name:"max_tokens",val:": Optional = None"},{name:"n",val:": Optional = None"},{name:"presence_penalty",val:": Optional = None"},{name:"seed",val:": Optional = None"},{name:"stop",val:": Optional = None"},{name:"temperature",val:": Optional = None"},{name:"tool_choice",val:": Union = None"},{name:"tool_prompt",val:": Optional = None"},{name:"tools",val:": Optional = None"},{name:"top_logprobs",val:": Optional = None"},{name:"top_p",val:": Optional = None"},{name:"model_id",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.messages",description:`<strong>messages</strong> (List[Union[<code>SystemMessage</code>, <code>UserMessage</code>, <code>AssistantMessage</code>]]) &#x2014;
Conversation history consisting of roles and content pairs.`,name:"messages"},{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for chat-completion. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. If not provided, the default recommended model for chat-based text-generation will be used.
See <a href="https://huggingface.co/tasks/text-generation" rel="nofollow">https://huggingface.co/tasks/text-generation</a> for more details.`,name:"model"},{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.frequency_penalty",description:`<strong>frequency_penalty</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Penalizes new tokens based on their existing frequency
in the text so far. Range: [-2.0, 2.0]. Defaults to 0.0.`,name:"frequency_penalty"},{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.logit_bias",description:`<strong>logit_bias</strong> (<code>List[float]</code>, <em>optional</em>) &#x2014;
Modify the likelihood of specified tokens appearing in the completion. Accepts a JSON object that maps tokens
(specified by their token ID in the tokenizer) to an associated bias value from -100 to 100. Mathematically,
the bias is added to the logits generated by the model prior to sampling. The exact effect will vary per model,
but values between -1 and 1 should decrease or increase likelihood of selection; values like -100 or 100 should
result in a ban or exclusive selection of the relevant token. Defaults to None.`,name:"logit_bias"},{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.logprobs",description:`<strong>logprobs</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to return log probabilities of the output tokens or not. If true, returns the log
probabilities of each output token returned in the content of message.`,name:"logprobs"},{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.max_tokens",description:`<strong>max_tokens</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Maximum number of tokens allowed in the response. Defaults to 20.`,name:"max_tokens"},{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.n",description:`<strong>n</strong> (<code>int</code>, <em>optional</em>) &#x2014;
UNUSED.`,name:"n"},{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.presence_penalty",description:`<strong>presence_penalty</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Number between -2.0 and 2.0. Positive values penalize new tokens based on whether they appear in the
text so far, increasing the model&#x2019;s likelihood to talk about new topics.`,name:"presence_penalty"},{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.seed",description:`<strong>seed</strong> (Optional<code>int</code>, <em>optional</em>) &#x2014;
Seed for reproducible control flow. Defaults to None.`,name:"seed"},{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.stop",description:`<strong>stop</strong> (Optional<code>str</code>, <em>optional</em>) &#x2014;
Up to four strings which trigger the end of the response.
Defaults to None.`,name:"stop"},{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.stream",description:`<strong>stream</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Enable realtime streaming of responses. Defaults to False.`,name:"stream"},{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.temperature",description:`<strong>temperature</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Controls randomness of the generations. Lower values ensure
less random completions. Range: [0, 2]. Defaults to 1.0.`,name:"temperature"},{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.top_logprobs",description:`<strong>top_logprobs</strong> (<code>int</code>, <em>optional</em>) &#x2014;
An integer between 0 and 5 specifying the number of most likely tokens to return at each token
position, each with an associated log probability. logprobs must be set to true if this parameter is
used.`,name:"top_logprobs"},{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.top_p",description:`<strong>top_p</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Fraction of the most likely next words to sample from.
Must be between 0 and 1. Defaults to 1.0.`,name:"top_p"},{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.tool_choice",description:`<strong>tool_choice</strong> (<a href="/docs/huggingface_hub/pr_2368/en/package_reference/inference_types#huggingface_hub.ChatCompletionInputToolTypeClass">ChatCompletionInputToolTypeClass</a> or <code>ChatCompletionInputToolTypeEnum</code>, <em>optional</em>) &#x2014;
The tool to use for the completion. Defaults to &#x201C;auto&#x201D;.`,name:"tool_choice"},{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.tool_prompt",description:`<strong>tool_prompt</strong> (<code>str</code>, <em>optional</em>) &#x2014;
A prompt to be appended before the tools.`,name:"tool_prompt"},{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.tools",description:`<strong>tools</strong> (List of <a href="/docs/huggingface_hub/pr_2368/en/package_reference/inference_types#huggingface_hub.ChatCompletionInputTool">ChatCompletionInputTool</a>, <em>optional</em>) &#x2014;
A list of tools the model may call. Currently, only functions are supported as a tool. Use this to
provide a list of functions the model may generate JSON inputs for.`,name:"tools"},{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.model_id",description:`<strong>model_id</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model ID to use for chat-completion. Only used when <code>model</code> is a URL to a deployed Text Generation Inference server.
It is passed to the server as the <code>model</code> parameter. This parameter has no impact on the URL that will be used to
send the request.`,name:"model_id"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2368/src/huggingface_hub/inference/_generated/_async_client.py#L496",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Generated text returned from the server:</p>
<ul>
<li>if <code>stream=False</code>, the generated text is returned as a <a
  href="/docs/huggingface_hub/pr_2368/en/package_reference/inference_types#huggingface_hub.ChatCompletionOutput"
>ChatCompletionOutput</a> (default).</li>
<li>if <code>stream=True</code>, the generated text is returned token by token as a sequence of <a
  href="/docs/huggingface_hub/pr_2368/en/package_reference/inference_types#huggingface_hub.ChatCompletionStreamOutput"
>ChatCompletionStreamOutput</a>.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2368/en/package_reference/inference_types#huggingface_hub.ChatCompletionOutput"
>ChatCompletionOutput</a> or Iterable of <a
  href="/docs/huggingface_hub/pr_2368/en/package_reference/inference_types#huggingface_hub.ChatCompletionStreamOutput"
>ChatCompletionStreamOutput</a></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/pr_2368/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2368/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),Kt=new E({props:{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.example",$$slots:{default:[ad]},$$scope:{ctx:I}}}),Za=new k({props:{name:"conversational",anchor:"huggingface_hub.AsyncInferenceClient.conversational",parameters:[{name:"text",val:": str"},{name:"generated_responses",val:": Optional = None"},{name:"past_user_inputs",val:": Optional = None"},{name:"parameters",val:": Optional = None"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.conversational.text",description:`<strong>text</strong> (<code>str</code>) &#x2014;
The last input from the user in the conversation.`,name:"text"},{anchor:"huggingface_hub.AsyncInferenceClient.conversational.generated_responses",description:`<strong>generated_responses</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
A list of strings corresponding to the earlier replies from the model. Defaults to None.`,name:"generated_responses"},{anchor:"huggingface_hub.AsyncInferenceClient.conversational.past_user_inputs",description:`<strong>past_user_inputs</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
A list of strings corresponding to the earlier replies from the user. Should be the same length as
<code>generated_responses</code>. Defaults to None.`,name:"past_user_inputs"},{anchor:"huggingface_hub.AsyncInferenceClient.conversational.parameters",description:`<strong>parameters</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional parameters for the conversational task. Defaults to None. For more details about the available
parameters, please refer to <a href="https://huggingface.co/docs/api-inference/detailed_parameters#conversational-task" rel="nofollow">this page</a>`,name:"parameters"},{anchor:"huggingface_hub.AsyncInferenceClient.conversational.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for the conversational task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended conversational model will be used.
Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2368/src/huggingface_hub/inference/_generated/_async_client.py#L829",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The generated conversational output.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Dict</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/pr_2368/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2368/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),es=new A({props:{warning:!0,$$slots:{default:[ld]},$$scope:{ctx:I}}}),ns=new E({props:{anchor:"huggingface_hub.AsyncInferenceClient.conversational.example",$$slots:{default:[od]},$$scope:{ctx:I}}}),Wa=new k({props:{name:"document_question_answering",anchor:"huggingface_hub.AsyncInferenceClient.document_question_answering",parameters:[{name:"image",val:": Union"},{name:"question",val:": str"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.document_question_answering.image",description:`<strong>image</strong> (<code>Union[str, Path, bytes, BinaryIO]</code>) &#x2014;
The input image for the context. It can be raw bytes, an image file, or a URL to an online image.`,name:"image"},{anchor:"huggingface_hub.AsyncInferenceClient.document_question_answering.question",description:`<strong>question</strong> (<code>str</code>) &#x2014;
Question to be answered.`,name:"question"},{anchor:"huggingface_hub.AsyncInferenceClient.document_question_answering.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for the document question answering task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended document question answering model will be used.
Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2368/src/huggingface_hub/inference/_generated/_async_client.py#L903",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>a list of <a
  href="/docs/huggingface_hub/pr_2368/en/package_reference/inference_types#huggingface_hub.DocumentQuestionAnsweringOutputElement"
>DocumentQuestionAnsweringOutputElement</a> items containing the predicted label, associated probability, word ids, and page number.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[DocumentQuestionAnsweringOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/pr_2368/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2368/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),ts=new E({props:{anchor:"huggingface_hub.AsyncInferenceClient.document_question_answering.example",$$slots:{default:[rd]},$$scope:{ctx:I}}}),Na=new k({props:{name:"feature_extraction",anchor:"huggingface_hub.AsyncInferenceClient.feature_extraction",parameters:[{name:"text",val:": str"},{name:"normalize",val:": Optional = None"},{name:"prompt_name",val:": Optional = None"},{name:"truncate",val:": Optional = None"},{name:"truncation_direction",val:": Optional = None"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.feature_extraction.text",description:`<strong>text</strong> (<em>str</em>) &#x2014;
The text to embed.`,name:"text"},{anchor:"huggingface_hub.AsyncInferenceClient.feature_extraction.model",description:`<strong>model</strong> (<em>str</em>, <em>optional</em>) &#x2014;
The model to use for the conversational task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended conversational model will be used.
Defaults to None.`,name:"model"},{anchor:"huggingface_hub.AsyncInferenceClient.feature_extraction.normalize",description:`<strong>normalize</strong> (<em>bool</em>, <em>optional</em>) &#x2014;
Whether to normalize the embeddings or not. Defaults to None.
Only available on server powered by Text-Embedding-Inference.`,name:"normalize"},{anchor:"huggingface_hub.AsyncInferenceClient.feature_extraction.prompt_name",description:`<strong>prompt_name</strong> (<em>str</em>, <em>optional</em>) &#x2014;
The name of the prompt that should be used by for encoding. If not set, no prompt will be applied.
Must be a key in the <em>Sentence Transformers</em> configuration <em>prompts</em> dictionary.
For example if <code>prompt_name</code> is &#x201C;query&#x201D; and the <code>prompts</code> is {&#x201C;query&#x201D;: &#x201C;query: &#x201D;,&#x2026;},
then the sentence &#x201C;What is the capital of France?&#x201D; will be encoded as &#x201C;query: What is the capital of France?&#x201D;
because the prompt text will be prepended before any text to encode.`,name:"prompt_name"},{anchor:"huggingface_hub.AsyncInferenceClient.feature_extraction.truncate",description:`<strong>truncate</strong> (<em>bool</em>, <em>optional</em>) &#x2014;
Whether to truncate the embeddings or not. Defaults to None.
Only available on server powered by Text-Embedding-Inference.`,name:"truncate"},{anchor:"huggingface_hub.AsyncInferenceClient.feature_extraction.truncation_direction",description:`<strong>truncation_direction</strong> (<em>Literal[&#x201C;Left&#x201D;, &#x201C;Right&#x201D;]</em>, <em>optional</em>) &#x2014;
Which side of the input should be truncated when <em>truncate=True</em> is passed.`,name:"truncation_direction"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2368/src/huggingface_hub/inference/_generated/_async_client.py#L945",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The embedding representing the input text as a float32 numpy array.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><em>np.ndarray</em></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li>[<em>InferenceTimeoutError</em>] —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>[<em>InferenceTimeoutError</em>] or <code>aiohttp.ClientResponseError</code></p>
`}}),ss=new E({props:{anchor:"huggingface_hub.AsyncInferenceClient.feature_extraction.example",$$slots:{default:[id]},$$scope:{ctx:I}}}),Ga=new k({props:{name:"fill_mask",anchor:"huggingface_hub.AsyncInferenceClient.fill_mask",parameters:[{name:"text",val:": str"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.fill_mask.text",description:`<strong>text</strong> (<code>str</code>) &#x2014;
a string to be filled from, must contain the [MASK] token (check model card for exact name of the mask).`,name:"text"},{anchor:"huggingface_hub.AsyncInferenceClient.fill_mask.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for the fill mask task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended fill mask model will be used.
Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2368/src/huggingface_hub/inference/_generated/_async_client.py#L1014",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>a list of <a
  href="/docs/huggingface_hub/pr_2368/en/package_reference/inference_types#huggingface_hub.FillMaskOutputElement"
>FillMaskOutputElement</a> items containing the predicted label, associated
probability, token reference, and completed text.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[FillMaskOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/pr_2368/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2368/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),as=new E({props:{anchor:"huggingface_hub.AsyncInferenceClient.fill_mask.example",$$slots:{default:[cd]},$$scope:{ctx:I}}}),Ba=new k({props:{name:"get_endpoint_info",anchor:"huggingface_hub.AsyncInferenceClient.get_endpoint_info",parameters:[{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.get_endpoint_info.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for inference. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. This parameter overrides the model defined at the instance level. Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2368/src/huggingface_hub/inference/_generated/_async_client.py#L2624",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Information about the endpoint.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Dict[str, Any]</code></p>
`}}),ls=new E({props:{anchor:"huggingface_hub.AsyncInferenceClient.get_endpoint_info.example",$$slots:{default:[pd]},$$scope:{ctx:I}}}),Va=new k({props:{name:"get_model_status",anchor:"huggingface_hub.AsyncInferenceClient.get_model_status",parameters:[{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.get_model_status.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Identifier of the model for witch the status gonna be checked. If model is not provided,
the model associated with this instance of <a href="/docs/huggingface_hub/pr_2368/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a> will be used. Only InferenceAPI service can be checked so the
identifier cannot be a URL.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2368/src/huggingface_hub/inference/_generated/_async_client.py#L2717",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>An instance of ModelStatus dataclass, containing information,
about the state of the model: load, state, compute type and framework.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>ModelStatus</code></p>
`}}),os=new A({props:{$$slots:{default:[ud]},$$scope:{ctx:I}}}),rs=new E({props:{anchor:"huggingface_hub.AsyncInferenceClient.get_model_status.example",$$slots:{default:[gd]},$$scope:{ctx:I}}}),Qa=new k({props:{name:"get_recommended_model",anchor:"huggingface_hub.AsyncInferenceClient.get_recommended_model",parameters:[{name:"task",val:": str"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.get_recommended_model.task",description:`<strong>task</strong> (<code>str</code>) &#x2014;
The Hugging Face task to get which model Hugging Face recommends.
All available tasks can be found <a href="https://huggingface.co/tasks" rel="nofollow">here</a>.`,name:"task"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2368/src/huggingface_hub/inference/_generated/_async_client.py#L2600",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Name of the model recommended for the input task.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>str</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><code>ValueError</code> — If Hugging Face has no recommendation for the input task.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>ValueError</code></p>
`}}),Ya=new k({props:{name:"health_check",anchor:"huggingface_hub.AsyncInferenceClient.health_check",parameters:[{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.health_check.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
URL of the Inference Endpoint. This parameter overrides the model defined at the instance level. Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2368/src/huggingface_hub/inference/_generated/_async_client.py#L2681",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>True if everything is working fine.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>bool</code></p>
`}}),cs=new E({props:{anchor:"huggingface_hub.AsyncInferenceClient.health_check.example",$$slots:{default:[md]},$$scope:{ctx:I}}}),Sa=new k({props:{name:"image_classification",anchor:"huggingface_hub.AsyncInferenceClient.image_classification",parameters:[{name:"image",val:": Union"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.image_classification.image",description:`<strong>image</strong> (<code>Union[str, Path, bytes, BinaryIO]</code>) &#x2014;
The image to classify. It can be raw bytes, an image file, or a URL to an online image.`,name:"image"},{anchor:"huggingface_hub.AsyncInferenceClient.image_classification.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for image classification. Can be a model ID hosted on the Hugging Face Hub or a URL to a
deployed Inference Endpoint. If not provided, the default recommended model for image classification will be used.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2368/src/huggingface_hub/inference/_generated/_async_client.py#L1051",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>a list of <a
  href="/docs/huggingface_hub/pr_2368/en/package_reference/inference_types#huggingface_hub.ImageClassificationOutputElement"
>ImageClassificationOutputElement</a> items containing the predicted label and associated probability.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[ImageClassificationOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/pr_2368/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2368/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),ps=new E({props:{anchor:"huggingface_hub.AsyncInferenceClient.image_classification.example",$$slots:{default:[hd]},$$scope:{ctx:I}}}),Da=new k({props:{name:"image_segmentation",anchor:"huggingface_hub.AsyncInferenceClient.image_segmentation",parameters:[{name:"image",val:": Union"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.image_segmentation.image",description:`<strong>image</strong> (<code>Union[str, Path, bytes, BinaryIO]</code>) &#x2014;
The image to segment. It can be raw bytes, an image file, or a URL to an online image.`,name:"image"},{anchor:"huggingface_hub.AsyncInferenceClient.image_segmentation.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for image segmentation. Can be a model ID hosted on the Hugging Face Hub or a URL to a
deployed Inference Endpoint. If not provided, the default recommended model for image segmentation will be used.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2368/src/huggingface_hub/inference/_generated/_async_client.py#L1088",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of <a
  href="/docs/huggingface_hub/pr_2368/en/package_reference/inference_types#huggingface_hub.ImageSegmentationOutputElement"
>ImageSegmentationOutputElement</a> items containing the segmented masks and associated attributes.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[ImageSegmentationOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/pr_2368/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2368/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),us=new A({props:{warning:!0,$$slots:{default:[dd]},$$scope:{ctx:I}}}),gs=new E({props:{anchor:"huggingface_hub.AsyncInferenceClient.image_segmentation.example",$$slots:{default:[fd]},$$scope:{ctx:I}}}),Ra=new k({props:{name:"image_to_image",anchor:"huggingface_hub.AsyncInferenceClient.image_to_image",parameters:[{name:"image",val:": Union"},{name:"prompt",val:": Optional = None"},{name:"negative_prompt",val:": Optional = None"},{name:"height",val:": Optional = None"},{name:"width",val:": Optional = None"},{name:"num_inference_steps",val:": Optional = None"},{name:"guidance_scale",val:": Optional = None"},{name:"model",val:": Optional = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.image_to_image.image",description:`<strong>image</strong> (<code>Union[str, Path, bytes, BinaryIO]</code>) &#x2014;
The input image for translation. It can be raw bytes, an image file, or a URL to an online image.`,name:"image"},{anchor:"huggingface_hub.AsyncInferenceClient.image_to_image.prompt",description:`<strong>prompt</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The text prompt to guide the image generation.`,name:"prompt"},{anchor:"huggingface_hub.AsyncInferenceClient.image_to_image.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code>, <em>optional</em>) &#x2014;
A negative prompt to guide the translation process.`,name:"negative_prompt"},{anchor:"huggingface_hub.AsyncInferenceClient.image_to_image.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"huggingface_hub.AsyncInferenceClient.image_to_image.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"huggingface_hub.AsyncInferenceClient.image_to_image.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"huggingface_hub.AsyncInferenceClient.image_to_image.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"huggingface_hub.AsyncInferenceClient.image_to_image.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for inference. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. This parameter overrides the model defined at the instance level. Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2368/src/huggingface_hub/inference/_generated/_async_client.py#L1134",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The translated image.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Image</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/pr_2368/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2368/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),ms=new A({props:{warning:!0,$$slots:{default:[yd]},$$scope:{ctx:I}}}),hs=new E({props:{anchor:"huggingface_hub.AsyncInferenceClient.image_to_image.example",$$slots:{default:[bd]},$$scope:{ctx:I}}}),Xa=new k({props:{name:"image_to_text",anchor:"huggingface_hub.AsyncInferenceClient.image_to_text",parameters:[{name:"image",val:": Union"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.image_to_text.image",description:`<strong>image</strong> (<code>Union[str, Path, bytes, BinaryIO]</code>) &#x2014;
The input image to caption. It can be raw bytes, an image file, or a URL to an online image..`,name:"image"},{anchor:"huggingface_hub.AsyncInferenceClient.image_to_text.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for inference. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. This parameter overrides the model defined at the instance level. Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2368/src/huggingface_hub/inference/_generated/_async_client.py#L1219",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The generated text.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2368/en/package_reference/inference_types#huggingface_hub.ImageToTextOutput"
>ImageToTextOutput</a></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/pr_2368/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2368/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),ds=new E({props:{anchor:"huggingface_hub.AsyncInferenceClient.image_to_text.example",$$slots:{default:[Md]},$$scope:{ctx:I}}}),Ha=new k({props:{name:"list_deployed_models",anchor:"huggingface_hub.AsyncInferenceClient.list_deployed_models",parameters:[{name:"frameworks",val:": Union = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.list_deployed_models.frameworks",description:`<strong>frameworks</strong> (<code>Literal[&quot;all&quot;]</code> or <code>List[str]</code> or <code>str</code>, <em>optional</em>) &#x2014;
The frameworks to filter on. By default only a subset of the available frameworks are tested. If set to
&#x201C;all&#x201D;, all available frameworks will be tested. It is also possible to provide a single framework or a
custom set of frameworks to check.`,name:"frameworks"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2368/src/huggingface_hub/inference/_generated/_async_client.py#L1257",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A dictionary mapping task names to a sorted list of model IDs.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Dict[str, List[str]]</code></p>
`}}),fs=new A({props:{warning:!0,$$slots:{default:[jd]},$$scope:{ctx:I}}}),ys=new A({props:{$$slots:{default:[_d]},$$scope:{ctx:I}}}),bs=new E({props:{anchor:"huggingface_hub.AsyncInferenceClient.list_deployed_models.example",$$slots:{default:[Td]},$$scope:{ctx:I}}}),Fa=new k({props:{name:"object_detection",anchor:"huggingface_hub.AsyncInferenceClient.object_detection",parameters:[{name:"image",val:": Union"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.object_detection.image",description:`<strong>image</strong> (<code>Union[str, Path, bytes, BinaryIO]</code>) &#x2014;
The image to detect objects on. It can be raw bytes, an image file, or a URL to an online image.`,name:"image"},{anchor:"huggingface_hub.AsyncInferenceClient.object_detection.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for object detection. Can be a model ID hosted on the Hugging Face Hub or a URL to a
deployed Inference Endpoint. If not provided, the default recommended model for object detection (DETR) will be used.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2368/src/huggingface_hub/inference/_generated/_async_client.py#L1346",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of <a
  href="/docs/huggingface_hub/pr_2368/en/package_reference/inference_types#huggingface_hub.ObjectDetectionOutputElement"
>ObjectDetectionOutputElement</a> items containing the bounding boxes and associated attributes.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[ObjectDetectionOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/pr_2368/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
<li><code>ValueError</code> —
If the request output is not a List.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2368/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code> or <code>ValueError</code></p>
`}}),Ms=new A({props:{warning:!0,$$slots:{default:[Id]},$$scope:{ctx:I}}}),js=new E({props:{anchor:"huggingface_hub.AsyncInferenceClient.object_detection.example",$$slots:{default:[xd]},$$scope:{ctx:I}}}),za=new k({props:{name:"post",anchor:"huggingface_hub.AsyncInferenceClient.post",parameters:[{name:"json",val:": Union = None"},{name:"data",val:": Union = None"},{name:"model",val:": Optional = None"},{name:"task",val:": Optional = None"},{name:"stream",val:": bool = False"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.post.json",description:`<strong>json</strong> (<code>Union[str, Dict, List]</code>, <em>optional</em>) &#x2014;
The JSON data to send in the request body, specific to each task. Defaults to None.`,name:"json"},{anchor:"huggingface_hub.AsyncInferenceClient.post.data",description:`<strong>data</strong> (<code>Union[str, Path, bytes, BinaryIO]</code>, <em>optional</em>) &#x2014;
The content to send in the request body, specific to each task.
It can be raw bytes, a pointer to an opened file, a local file path,
or a URL to an online resource (image, audio file,&#x2026;). If both <code>json</code> and <code>data</code> are passed,
<code>data</code> will take precedence. At least <code>json</code> or <code>data</code> must be provided. Defaults to None.`,name:"data"},{anchor:"huggingface_hub.AsyncInferenceClient.post.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for inference. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. Will override the model defined at the instance level. Defaults to None.`,name:"model"},{anchor:"huggingface_hub.AsyncInferenceClient.post.task",description:`<strong>task</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The task to perform on the inference. All available tasks can be found
<a href="https://huggingface.co/tasks" rel="nofollow">here</a>. Used only to default to a recommended model if <code>model</code> is not
provided. At least <code>model</code> or <code>task</code> must be provided. Defaults to None.`,name:"task"},{anchor:"huggingface_hub.AsyncInferenceClient.post.stream",description:`<strong>stream</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to iterate over streaming APIs.`,name:"stream"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2368/src/huggingface_hub/inference/_generated/_async_client.py#L192",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The raw bytes returned by the server.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>bytes</p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/pr_2368/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2368/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),La=new k({props:{name:"question_answering",anchor:"huggingface_hub.AsyncInferenceClient.question_answering",parameters:[{name:"question",val:": str"},{name:"context",val:": str"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.question_answering.question",description:`<strong>question</strong> (<code>str</code>) &#x2014;
Question to be answered.`,name:"question"},{anchor:"huggingface_hub.AsyncInferenceClient.question_answering.context",description:`<strong>context</strong> (<code>str</code>) &#x2014;
The context of the question.`,name:"context"},{anchor:"huggingface_hub.AsyncInferenceClient.question_answering.model",description:`<strong>model</strong> (<code>str</code>) &#x2014;
The model to use for the question answering task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2368/src/huggingface_hub/inference/_generated/_async_client.py#L1392",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>an question answering output containing the score, start index, end index, and answer.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2368/en/package_reference/inference_types#huggingface_hub.QuestionAnsweringOutputElement"
>QuestionAnsweringOutputElement</a></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/pr_2368/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2368/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),Ts=new E({props:{anchor:"huggingface_hub.AsyncInferenceClient.question_answering.example",$$slots:{default:[Jd]},$$scope:{ctx:I}}}),Pa=new k({props:{name:"sentence_similarity",anchor:"huggingface_hub.AsyncInferenceClient.sentence_similarity",parameters:[{name:"sentence",val:": str"},{name:"other_sentences",val:": List"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.sentence_similarity.sentence",description:`<strong>sentence</strong> (<code>str</code>) &#x2014;
The main sentence to compare to others.`,name:"sentence"},{anchor:"huggingface_hub.AsyncInferenceClient.sentence_similarity.other_sentences",description:`<strong>other_sentences</strong> (<code>List[str]</code>) &#x2014;
The list of sentences to compare to.`,name:"other_sentences"},{anchor:"huggingface_hub.AsyncInferenceClient.sentence_similarity.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for the conversational task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended conversational model will be used.
Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2368/src/huggingface_hub/inference/_generated/_async_client.py#L1434",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The embedding representing the input text.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[float]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/pr_2368/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2368/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),Is=new E({props:{anchor:"huggingface_hub.AsyncInferenceClient.sentence_similarity.example",$$slots:{default:[wd]},$$scope:{ctx:I}}}),Oa=new k({props:{name:"summarization",anchor:"huggingface_hub.AsyncInferenceClient.summarization",parameters:[{name:"text",val:": str"},{name:"parameters",val:": Optional = None"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.summarization.text",description:`<strong>text</strong> (<code>str</code>) &#x2014;
The input text to summarize.`,name:"text"},{anchor:"huggingface_hub.AsyncInferenceClient.summarization.parameters",description:`<strong>parameters</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional parameters for summarization. Check out this <a href="https://huggingface.co/docs/api-inference/detailed_parameters#summarization-task" rel="nofollow">page</a>
for more details.`,name:"parameters"},{anchor:"huggingface_hub.AsyncInferenceClient.summarization.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for inference. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. This parameter overrides the model defined at the instance level. Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2368/src/huggingface_hub/inference/_generated/_async_client.py#L1482",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The generated summary text.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2368/en/package_reference/inference_types#huggingface_hub.SummarizationOutput"
>SummarizationOutput</a></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/pr_2368/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2368/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),xs=new E({props:{anchor:"huggingface_hub.AsyncInferenceClient.summarization.example",$$slots:{default:[Cd]},$$scope:{ctx:I}}}),Ka=new k({props:{name:"table_question_answering",anchor:"huggingface_hub.AsyncInferenceClient.table_question_answering",parameters:[{name:"table",val:": Dict"},{name:"query",val:": str"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.table_question_answering.table",description:`<strong>table</strong> (<code>str</code>) &#x2014;
A table of data represented as a dict of lists where entries are headers and the lists are all the
values, all lists must have the same size.`,name:"table"},{anchor:"huggingface_hub.AsyncInferenceClient.table_question_answering.query",description:`<strong>query</strong> (<code>str</code>) &#x2014;
The query in plain text that you want to ask the table.`,name:"query"},{anchor:"huggingface_hub.AsyncInferenceClient.table_question_answering.model",description:`<strong>model</strong> (<code>str</code>) &#x2014;
The model to use for the table-question-answering task. Can be a model ID hosted on the Hugging Face
Hub or a URL to a deployed Inference Endpoint.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2368/src/huggingface_hub/inference/_generated/_async_client.py#L1526",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>a table question answering output containing the answer, coordinates, cells and the aggregator used.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2368/en/package_reference/inference_types#huggingface_hub.TableQuestionAnsweringOutputElement"
>TableQuestionAnsweringOutputElement</a></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/pr_2368/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2368/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),Js=new E({props:{anchor:"huggingface_hub.AsyncInferenceClient.table_question_answering.example",$$slots:{default:[Ud]},$$scope:{ctx:I}}}),el=new k({props:{name:"tabular_classification",anchor:"huggingface_hub.AsyncInferenceClient.tabular_classification",parameters:[{name:"table",val:": Dict"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.tabular_classification.table",description:`<strong>table</strong> (<code>Dict[str, Any]</code>) &#x2014;
Set of attributes to classify.`,name:"table"},{anchor:"huggingface_hub.AsyncInferenceClient.tabular_classification.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for the tabular classification task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended tabular classification model will be used.
Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2368/src/huggingface_hub/inference/_generated/_async_client.py#L1572",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>a list of labels, one per row in the initial table.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/pr_2368/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2368/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),ws=new E({props:{anchor:"huggingface_hub.AsyncInferenceClient.tabular_classification.example",$$slots:{default:[$d]},$$scope:{ctx:I}}}),nl=new k({props:{name:"tabular_regression",anchor:"huggingface_hub.AsyncInferenceClient.tabular_regression",parameters:[{name:"table",val:": Dict"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.tabular_regression.table",description:`<strong>table</strong> (<code>Dict[str, Any]</code>) &#x2014;
Set of attributes stored in a table. The attributes used to predict the target can be both numerical and categorical.`,name:"table"},{anchor:"huggingface_hub.AsyncInferenceClient.tabular_regression.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for the tabular regression task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended tabular regression model will be used.
Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2368/src/huggingface_hub/inference/_generated/_async_client.py#L1618",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>a list of predicted numerical target values.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/pr_2368/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2368/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),Cs=new E({props:{anchor:"huggingface_hub.AsyncInferenceClient.tabular_regression.example",$$slots:{default:[vd]},$$scope:{ctx:I}}}),tl=new k({props:{name:"text_classification",anchor:"huggingface_hub.AsyncInferenceClient.text_classification",parameters:[{name:"text",val:": str"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.text_classification.text",description:`<strong>text</strong> (<code>str</code>) &#x2014;
A string to be classified.`,name:"text"},{anchor:"huggingface_hub.AsyncInferenceClient.text_classification.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for the text classification task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended text classification model will be used.
Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2368/src/huggingface_hub/inference/_generated/_async_client.py#L1659",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>a list of <a
  href="/docs/huggingface_hub/pr_2368/en/package_reference/inference_types#huggingface_hub.TextClassificationOutputElement"
>TextClassificationOutputElement</a> items containing the predicted label and associated probability.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[TextClassificationOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/pr_2368/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2368/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),Us=new E({props:{anchor:"huggingface_hub.AsyncInferenceClient.text_classification.example",$$slots:{default:[kd]},$$scope:{ctx:I}}}),sl=new k({props:{name:"text_generation",anchor:"huggingface_hub.AsyncInferenceClient.text_generation",parameters:[{name:"prompt",val:": str"},{name:"details",val:": bool = False"},{name:"stream",val:": bool = False"},{name:"model",val:": Optional = None"},{name:"best_of",val:": Optional = None"},{name:"decoder_input_details",val:": Optional = None"},{name:"do_sample",val:": Optional = False"},{name:"frequency_penalty",val:": Optional = None"},{name:"grammar",val:": Optional = None"},{name:"max_new_tokens",val:": Optional = None"},{name:"repetition_penalty",val:": Optional = None"},{name:"return_full_text",val:": Optional = False"},{name:"seed",val:": Optional = None"},{name:"stop_sequences",val:": Optional = None"},{name:"temperature",val:": Optional = None"},{name:"top_k",val:": Optional = None"},{name:"top_n_tokens",val:": Optional = None"},{name:"top_p",val:": Optional = None"},{name:"truncate",val:": Optional = None"},{name:"typical_p",val:": Optional = None"},{name:"watermark",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.prompt",description:`<strong>prompt</strong> (<code>str</code>) &#x2014;
Input text.`,name:"prompt"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.details",description:`<strong>details</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
By default, text_generation returns a string. Pass <code>details=True</code> if you want a detailed output (tokens,
probabilities, seed, finish reason, etc.). Only available for models running on with the
<code>text-generation-inference</code> backend.`,name:"details"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.stream",description:`<strong>stream</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
By default, text_generation returns the full generated text. Pass <code>stream=True</code> if you want a stream of
tokens to be returned. Only available for models running on with the <code>text-generation-inference</code>
backend.`,name:"stream"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for inference. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. This parameter overrides the model defined at the instance level. Defaults to None.`,name:"model"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.best_of",description:`<strong>best_of</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Generate best_of sequences and return the one if the highest token logprobs.`,name:"best_of"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.decoder_input_details",description:`<strong>decoder_input_details</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Return the decoder input token logprobs and ids. You must set <code>details=True</code> as well for it to be taken
into account. Defaults to <code>False</code>.`,name:"decoder_input_details"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.do_sample",description:`<strong>do_sample</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Activate logits sampling`,name:"do_sample"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.frequency_penalty",description:`<strong>frequency_penalty</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Number between -2.0 and 2.0. Positive values penalize new tokens based on their existing frequency in
the text so far, decreasing the model&#x2019;s likelihood to repeat the same line verbatim.`,name:"frequency_penalty"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.grammar",description:`<strong>grammar</strong> (<a href="/docs/huggingface_hub/pr_2368/en/package_reference/inference_types#huggingface_hub.TextGenerationInputGrammarType">TextGenerationInputGrammarType</a>, <em>optional</em>) &#x2014;
Grammar constraints. Can be either a JSONSchema or a regex.`,name:"grammar"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.max_new_tokens",description:`<strong>max_new_tokens</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Maximum number of generated tokens`,name:"max_new_tokens"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.repetition_penalty",description:`<strong>repetition_penalty</strong> (<code>float</code>, <em>optional</em>) &#x2014;
The parameter for repetition penalty. 1.0 means no penalty. See <a href="https://arxiv.org/pdf/1909.05858.pdf" rel="nofollow">this
paper</a> for more details.`,name:"repetition_penalty"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.return_full_text",description:`<strong>return_full_text</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to prepend the prompt to the generated text`,name:"return_full_text"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.seed",description:`<strong>seed</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Random sampling seed`,name:"seed"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.stop_sequences",description:`<strong>stop_sequences</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
Stop generating tokens if a member of <code>stop_sequences</code> is generated`,name:"stop_sequences"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.temperature",description:`<strong>temperature</strong> (<code>float</code>, <em>optional</em>) &#x2014;
The value used to module the logits distribution.`,name:"temperature"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.top_n_tokens",description:`<strong>top_n_tokens</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Return information about the <code>top_n_tokens</code> most likely tokens at each generation step, instead of
just the sampled token.`,name:"top_n_tokens"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.top_k",description:"<strong>top_k</strong> (<code>int</code>, *optional`) &#x2014;\nThe number of highest probability vocabulary tokens to keep for top-k-filtering.",name:"top_k"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.top_p",description:"<strong>top_p</strong> (<code>float</code>, *optional<code>) -- If set to &lt; 1, only the smallest set of most probable tokens with probabilities that add up to </code>top_p` or\nhigher are kept for generation.",name:"top_p"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.truncate",description:"<strong>truncate</strong> (<code>int</code>, *optional`) &#x2014;\nTruncate inputs tokens to the given size.",name:"truncate"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.typical_p",description:`<strong>typical_p</strong> (<code>float</code>, *optional\`) &#x2014;
Typical Decoding mass
See <a href="https://arxiv.org/abs/2202.00666" rel="nofollow">Typical Decoding for Natural Language Generation</a> for more information`,name:"typical_p"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.watermark",description:'<strong>watermark</strong> (<code>bool</code>, *optional`) &#x2014;\nWatermarking with <a href="https://arxiv.org/abs/2301.10226" rel="nofollow">A Watermark for Large Language Models</a>',name:"watermark"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2368/src/huggingface_hub/inference/_generated/_async_client.py#L1837",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Generated text returned from the server:</p>
<ul>
<li>if <code>stream=False</code> and <code>details=False</code>, the generated text is returned as a <code>str</code> (default)</li>
<li>if <code>stream=True</code> and <code>details=False</code>, the generated text is returned token by token as a <code>Iterable[str]</code></li>
<li>if <code>stream=False</code> and <code>details=True</code>, the generated text is returned with more details as a <a
  href="/docs/huggingface_hub/pr_2368/en/package_reference/inference_types#huggingface_hub.TextGenerationOutput"
>TextGenerationOutput</a></li>
<li>if <code>details=True</code> and <code>stream=True</code>, the generated text is returned token by token as a iterable of <a
  href="/docs/huggingface_hub/pr_2368/en/package_reference/inference_types#huggingface_hub.TextGenerationStreamOutput"
>TextGenerationStreamOutput</a></li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Union[str, TextGenerationOutput, Iterable[str], Iterable[TextGenerationStreamOutput]]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><code>ValidationError</code> —
If input values are not valid. No HTTP call is made to the server.</li>
<li><a
  href="/docs/huggingface_hub/pr_2368/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>ValidationError</code> or <a
  href="/docs/huggingface_hub/pr_2368/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),$s=new A({props:{$$slots:{default:[qd]},$$scope:{ctx:I}}}),vs=new E({props:{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.example",$$slots:{default:[Ed]},$$scope:{ctx:I}}}),al=new k({props:{name:"text_to_image",anchor:"huggingface_hub.AsyncInferenceClient.text_to_image",parameters:[{name:"prompt",val:": str"},{name:"negative_prompt",val:": Optional = None"},{name:"height",val:": Optional = None"},{name:"width",val:": Optional = None"},{name:"num_inference_steps",val:": Optional = None"},{name:"guidance_scale",val:": Optional = None"},{name:"model",val:": Optional = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.text_to_image.prompt",description:`<strong>prompt</strong> (<code>str</code>) &#x2014;
The prompt to generate an image from.`,name:"prompt"},{anchor:"huggingface_hub.AsyncInferenceClient.text_to_image.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code>, <em>optional</em>) &#x2014;
An optional negative prompt for the image generation.`,name:"negative_prompt"},{anchor:"huggingface_hub.AsyncInferenceClient.text_to_image.height",description:`<strong>height</strong> (<code>float</code>, <em>optional</em>) &#x2014;
The height in pixels of the image to generate.`,name:"height"},{anchor:"huggingface_hub.AsyncInferenceClient.text_to_image.width",description:`<strong>width</strong> (<code>float</code>, <em>optional</em>) &#x2014;
The width in pixels of the image to generate.`,name:"width"},{anchor:"huggingface_hub.AsyncInferenceClient.text_to_image.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"huggingface_hub.AsyncInferenceClient.text_to_image.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"huggingface_hub.AsyncInferenceClient.text_to_image.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for inference. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. This parameter overrides the model defined at the instance level. Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2368/src/huggingface_hub/inference/_generated/_async_client.py#L2162",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The generated image.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Image</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/pr_2368/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2368/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),ks=new A({props:{warning:!0,$$slots:{default:[Ad]},$$scope:{ctx:I}}}),qs=new E({props:{anchor:"huggingface_hub.AsyncInferenceClient.text_to_image.example",$$slots:{default:[Zd]},$$scope:{ctx:I}}}),ll=new k({props:{name:"text_to_speech",anchor:"huggingface_hub.AsyncInferenceClient.text_to_speech",parameters:[{name:"text",val:": str"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.text_to_speech.text",description:`<strong>text</strong> (<code>str</code>) &#x2014;
The text to synthesize.`,name:"text"},{anchor:"huggingface_hub.AsyncInferenceClient.text_to_speech.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for inference. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. This parameter overrides the model defined at the instance level. Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2368/src/huggingface_hub/inference/_generated/_async_client.py#L2243",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The generated audio.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>bytes</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/pr_2368/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2368/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),Es=new E({props:{anchor:"huggingface_hub.AsyncInferenceClient.text_to_speech.example",$$slots:{default:[Wd]},$$scope:{ctx:I}}}),ol=new k({props:{name:"token_classification",anchor:"huggingface_hub.AsyncInferenceClient.token_classification",parameters:[{name:"text",val:": str"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.token_classification.text",description:`<strong>text</strong> (<code>str</code>) &#x2014;
A string to be classified.`,name:"text"},{anchor:"huggingface_hub.AsyncInferenceClient.token_classification.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for the token classification task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended token classification model will be used.
Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2368/src/huggingface_hub/inference/_generated/_async_client.py#L2276",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List of <a
  href="/docs/huggingface_hub/pr_2368/en/package_reference/inference_types#huggingface_hub.TokenClassificationOutputElement"
>TokenClassificationOutputElement</a> items containing the entity group, confidence score, word, start and end index.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[TokenClassificationOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/pr_2368/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2368/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),As=new E({props:{anchor:"huggingface_hub.AsyncInferenceClient.token_classification.example",$$slots:{default:[Nd]},$$scope:{ctx:I}}}),rl=new k({props:{name:"translation",anchor:"huggingface_hub.AsyncInferenceClient.translation",parameters:[{name:"text",val:": str"},{name:"model",val:": Optional = None"},{name:"src_lang",val:": Optional = None"},{name:"tgt_lang",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.translation.text",description:`<strong>text</strong> (<code>str</code>) &#x2014;
A string to be translated.`,name:"text"},{anchor:"huggingface_hub.AsyncInferenceClient.translation.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for the translation task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended translation model will be used.
Defaults to None.`,name:"model"},{anchor:"huggingface_hub.AsyncInferenceClient.translation.src_lang",description:`<strong>src_lang</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Source language of the translation task, i.e. input language. Cannot be passed without <code>tgt_lang</code>.`,name:"src_lang"},{anchor:"huggingface_hub.AsyncInferenceClient.translation.tgt_lang",description:`<strong>tgt_lang</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Target language of the translation task, i.e. output language. Cannot be passed without <code>src_lang</code>.`,name:"tgt_lang"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2368/src/huggingface_hub/inference/_generated/_async_client.py#L2332",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The generated translated text.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2368/en/package_reference/inference_types#huggingface_hub.TranslationOutput"
>TranslationOutput</a></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/pr_2368/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
<li><code>ValueError</code> —
If only one of the <code>src_lang</code> and <code>tgt_lang</code> arguments are provided.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2368/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code> or <code>ValueError</code></p>
`}}),Zs=new E({props:{anchor:"huggingface_hub.AsyncInferenceClient.translation.example",$$slots:{default:[Gd]},$$scope:{ctx:I}}}),Ws=new E({props:{anchor:"huggingface_hub.AsyncInferenceClient.translation.example-2",$$slots:{default:[Bd]},$$scope:{ctx:I}}}),il=new k({props:{name:"visual_question_answering",anchor:"huggingface_hub.AsyncInferenceClient.visual_question_answering",parameters:[{name:"image",val:": Union"},{name:"question",val:": str"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.visual_question_answering.image",description:`<strong>image</strong> (<code>Union[str, Path, bytes, BinaryIO]</code>) &#x2014;
The input image for the context. It can be raw bytes, an image file, or a URL to an online image.`,name:"image"},{anchor:"huggingface_hub.AsyncInferenceClient.visual_question_answering.question",description:`<strong>question</strong> (<code>str</code>) &#x2014;
Question to be answered.`,name:"question"},{anchor:"huggingface_hub.AsyncInferenceClient.visual_question_answering.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for the visual question answering task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended visual question answering model will be used.
Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2368/src/huggingface_hub/inference/_generated/_async_client.py#L2398",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>a list of <a
  href="/docs/huggingface_hub/pr_2368/en/package_reference/inference_types#huggingface_hub.VisualQuestionAnsweringOutputElement"
>VisualQuestionAnsweringOutputElement</a> items containing the predicted label and associated probability.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[VisualQuestionAnsweringOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><code>InferenceTimeoutError</code> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>InferenceTimeoutError</code> or <code>aiohttp.ClientResponseError</code></p>
`}}),Ns=new E({props:{anchor:"huggingface_hub.AsyncInferenceClient.visual_question_answering.example",$$slots:{default:[Vd]},$$scope:{ctx:I}}}),cl=new k({props:{name:"zero_shot_classification",anchor:"huggingface_hub.AsyncInferenceClient.zero_shot_classification",parameters:[{name:"text",val:": str"},{name:"labels",val:": List"},{name:"multi_label",val:": bool = False"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.zero_shot_classification.text",description:`<strong>text</strong> (<code>str</code>) &#x2014;
The input text to classify.`,name:"text"},{anchor:"huggingface_hub.AsyncInferenceClient.zero_shot_classification.labels",description:`<strong>labels</strong> (<code>List[str]</code>) &#x2014;
List of string possible labels. There must be at least 2 labels.`,name:"labels"},{anchor:"huggingface_hub.AsyncInferenceClient.zero_shot_classification.multi_label",description:`<strong>multi_label</strong> (<code>bool</code>) &#x2014;
Boolean that is set to True if classes can overlap.`,name:"multi_label"},{anchor:"huggingface_hub.AsyncInferenceClient.zero_shot_classification.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for inference. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. This parameter overrides the model defined at the instance level. Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2368/src/huggingface_hub/inference/_generated/_async_client.py#L2446",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List of <a
  href="/docs/huggingface_hub/pr_2368/en/package_reference/inference_types#huggingface_hub.ZeroShotClassificationOutputElement"
>ZeroShotClassificationOutputElement</a> items containing the predicted labels and their confidence.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[ZeroShotClassificationOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/pr_2368/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2368/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),Gs=new E({props:{anchor:"huggingface_hub.AsyncInferenceClient.zero_shot_classification.example",$$slots:{default:[Qd]},$$scope:{ctx:I}}}),pl=new k({props:{name:"zero_shot_image_classification",anchor:"huggingface_hub.AsyncInferenceClient.zero_shot_image_classification",parameters:[{name:"image",val:": Union"},{name:"labels",val:": List"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.zero_shot_image_classification.image",description:`<strong>image</strong> (<code>Union[str, Path, bytes, BinaryIO]</code>) &#x2014;
The input image to caption. It can be raw bytes, an image file, or a URL to an online image.`,name:"image"},{anchor:"huggingface_hub.AsyncInferenceClient.zero_shot_image_classification.labels",description:`<strong>labels</strong> (<code>List[str]</code>) &#x2014;
List of string possible labels. There must be at least 2 labels.`,name:"labels"},{anchor:"huggingface_hub.AsyncInferenceClient.zero_shot_image_classification.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for inference. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. This parameter overrides the model defined at the instance level. Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2368/src/huggingface_hub/inference/_generated/_async_client.py#L2522",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List of <a
  href="/docs/huggingface_hub/pr_2368/en/package_reference/inference_types#huggingface_hub.ZeroShotImageClassificationOutputElement"
>ZeroShotImageClassificationOutputElement</a> items containing the predicted labels and their confidence.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[ZeroShotImageClassificationOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/pr_2368/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2368/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),Bs=new E({props:{anchor:"huggingface_hub.AsyncInferenceClient.zero_shot_image_classification.example",$$slots:{default:[Yd]},$$scope:{ctx:I}}}),ul=new mr({props:{title:"InferenceTimeoutError",local:"huggingface_hub.InferenceTimeoutError",headingTag:"h2"}}),gl=new k({props:{name:"class huggingface_hub.InferenceTimeoutError",anchor:"huggingface_hub.InferenceTimeoutError",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2368/src/huggingface_hub/errors.py#L23"}}),ml=new mr({props:{title:"ModelStatus",local:"huggingface_hub.inference._common.ModelStatus",headingTag:"h3"}}),hl=new k({props:{name:"class huggingface_hub.inference._common.ModelStatus",anchor:"huggingface_hub.inference._common.ModelStatus",parameters:[{name:"loaded",val:": bool"},{name:"state",val:": str"},{name:"compute_type",val:": Dict"},{name:"framework",val:": str"}],parametersDescription:[{anchor:"huggingface_hub.inference._common.ModelStatus.loaded",description:`<strong>loaded</strong> (<code>bool</code>) &#x2014;
If the model is currently loaded into Hugging Face&#x2019;s InferenceAPI. Models
are loaded on-demand, leading to the user&#x2019;s first request taking longer.
If a model is loaded, you can be assured that it is in a healthy state.`,name:"loaded"},{anchor:"huggingface_hub.inference._common.ModelStatus.state",description:`<strong>state</strong> (<code>str</code>) &#x2014;
The current state of the model. This can be &#x2018;Loaded&#x2019;, &#x2018;Loadable&#x2019;, &#x2018;TooBig&#x2019;.
If a model&#x2019;s state is &#x2018;Loadable&#x2019;, it&#x2019;s not too big and has a supported
backend. Loadable models are automatically loaded when the user first
requests inference on the endpoint. This means it is transparent for the
user to load a model, except that the first call takes longer to complete.`,name:"state"},{anchor:"huggingface_hub.inference._common.ModelStatus.compute_type",description:`<strong>compute_type</strong> (<code>Dict</code>) &#x2014;
Information about the compute resource the model is using or will use, such as &#x2018;gpu&#x2019; type and number of
replicas.`,name:"compute_type"},{anchor:"huggingface_hub.inference._common.ModelStatus.framework",description:`<strong>framework</strong> (<code>str</code>) &#x2014;
The name of the framework that the model was built with, such as &#x2018;transformers&#x2019;
or &#x2018;text-generation-inference&#x2019;.`,name:"framework"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2368/src/huggingface_hub/inference/_common.py#L87"}}),dl=new mr({props:{title:"InferenceAPI",local:"huggingface_hub.InferenceApi",headingTag:"h2"}}),yl=new k({props:{name:"class huggingface_hub.InferenceApi",anchor:"huggingface_hub.InferenceApi",parameters:[{name:"repo_id",val:": str"},{name:"task",val:": Optional = None"},{name:"token",val:": Optional = None"},{name:"gpu",val:": bool = False"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2368/src/huggingface_hub/inference_api.py#L46"}}),Vs=new E({props:{anchor:"huggingface_hub.InferenceApi.example",$$slots:{default:[Sd]},$$scope:{ctx:I}}}),bl=new k({props:{name:"__init__",anchor:"huggingface_hub.InferenceApi.__init__",parameters:[{name:"repo_id",val:": str"},{name:"task",val:": Optional = None"},{name:"token",val:": Optional = None"},{name:"gpu",val:": bool = False"}],parametersDescription:[{anchor:"huggingface_hub.InferenceApi.__init__.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
Id of repository (e.g. <em>user/bert-base-uncased</em>).`,name:"repo_id"},{anchor:"huggingface_hub.InferenceApi.__init__.task",description:`<strong>task</strong> (<code>str</code>, <em>optional</em>, defaults <code>None</code>) &#x2014;
Whether to force a task instead of using task specified in the
repository.`,name:"task"},{anchor:"huggingface_hub.InferenceApi.__init__.token",description:`<strong>token</strong> (<em>str</em>, <em>optional</em>) &#x2014;
The API token to use as HTTP bearer authorization. This is not
the authentication token. You can find the token in
<a href="https://huggingface.co/settings/token" rel="nofollow">https://huggingface.co/settings/token</a>. Alternatively, you can
find both your organizations and personal API tokens using
<em>HfApi().whoami(token)</em>.`,name:"token"},{anchor:"huggingface_hub.InferenceApi.__init__.gpu",description:`<strong>gpu</strong> (<em>bool</em>, <em>optional</em>, defaults <em>False</em>) &#x2014;
Whether to use GPU instead of CPU for inference(requires Startup
plan at least).`,name:"gpu"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2368/src/huggingface_hub/inference_api.py#L93"}}),Ml=new k({props:{name:"__call__",anchor:"huggingface_hub.InferenceApi.__call__",parameters:[{name:"inputs",val:": Union = None"},{name:"params",val:": Optional = None"},{name:"data",val:": Optional = None"},{name:"raw_response",val:": bool = False"}],parametersDescription:[{anchor:"huggingface_hub.InferenceApi.__call__.inputs",description:`<strong>inputs</strong> (<code>str</code> or <code>Dict</code> or <code>List[str]</code> or <code>List[List[str]]</code>, <em>optional</em>) &#x2014;
Inputs for the prediction.`,name:"inputs"},{anchor:"huggingface_hub.InferenceApi.__call__.params",description:`<strong>params</strong> (<code>Dict</code>, <em>optional</em>) &#x2014;
Additional parameters for the models. Will be sent as <code>parameters</code> in the
payload.`,name:"params"},{anchor:"huggingface_hub.InferenceApi.__call__.data",description:`<strong>data</strong> (<code>bytes</code>, <em>optional</em>) &#x2014;
Bytes content of the request. In this case, leave <code>inputs</code> and <code>params</code> empty.`,name:"data"},{anchor:"huggingface_hub.InferenceApi.__call__.raw_response",description:`<strong>raw_response</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
If <code>True</code>, the raw <code>Response</code> object is returned. You can parse its content
as preferred. By default, the content is parsed into a more practical format
(json dictionary or PIL Image for example).`,name:"raw_response"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2368/src/huggingface_hub/inference_api.py#L158"}}),jl=new gh({props:{source:"https://github.com/huggingface/huggingface_hub/blob/main/docs/source/en/package_reference/inference_client.md"}}),{c(){n=g("meta"),u=r(),a=g("p"),t=r(),h(o.$$.fragment),e=r(),c=g("p"),c.innerHTML=cg,dr=r(),Ss=g("ul"),Ss.innerHTML=pg,fr=r(),Ds=g("p"),Ds.innerHTML=ug,yr=r(),h(Rs.$$.fragment),br=r(),J=g("div"),h(Xs.$$.fragment),Er=r(),$l=g("p"),$l.textContent=gg,Ar=r(),vl=g("p"),vl.innerHTML=mg,Zr=r(),ke=g("div"),h(Hs.$$.fragment),Wr=r(),kl=g("p"),kl.textContent=hg,Nr=r(),h(ot.$$.fragment),Gr=r(),qe=g("div"),h(Fs.$$.fragment),Br=r(),ql=g("p"),ql.textContent=dg,Vr=r(),h(rt.$$.fragment),Qr=r(),Ee=g("div"),h(zs.$$.fragment),Yr=r(),El=g("p"),El.textContent=fg,Sr=r(),h(it.$$.fragment),Dr=r(),Ae=g("div"),h(Ls.$$.fragment),Rr=r(),Al=g("p"),Al.textContent=yg,Xr=r(),h(ct.$$.fragment),Hr=r(),z=g("div"),h(Ps.$$.fragment),Fr=r(),Zl=g("p"),Zl.textContent=bg,zr=r(),h(pt.$$.fragment),Lr=r(),h(ut.$$.fragment),Pr=r(),Ze=g("div"),h(Os.$$.fragment),Or=r(),Wl=g("p"),Wl.textContent=Mg,Kr=r(),h(gt.$$.fragment),ei=r(),We=g("div"),h(Ks.$$.fragment),ni=r(),Nl=g("p"),Nl.textContent=jg,ti=r(),h(mt.$$.fragment),si=r(),Ne=g("div"),h(ea.$$.fragment),ai=r(),Gl=g("p"),Gl.textContent=_g,li=r(),h(ht.$$.fragment),oi=r(),L=g("div"),h(na.$$.fragment),ri=r(),Bl=g("p"),Bl.textContent=Tg,ii=r(),Vl=g("p"),Vl.innerHTML=Ig,ci=r(),h(dt.$$.fragment),pi=r(),P=g("div"),h(ta.$$.fragment),ui=r(),Ql=g("p"),Ql.textContent=xg,gi=r(),h(ft.$$.fragment),mi=r(),h(yt.$$.fragment),hi=r(),bt=g("div"),h(sa.$$.fragment),di=r(),Yl=g("p"),Yl.textContent=Jg,fi=r(),O=g("div"),h(aa.$$.fragment),yi=r(),Sl=g("p"),Sl.textContent=wg,bi=r(),Dl=g("p"),Dl.innerHTML=Cg,Mi=r(),h(Mt.$$.fragment),ji=r(),Ge=g("div"),h(la.$$.fragment),_i=r(),Rl=g("p"),Rl.textContent=Ug,Ti=r(),h(jt.$$.fragment),Ii=r(),K=g("div"),h(oa.$$.fragment),xi=r(),Xl=g("p"),Xl.textContent=$g,Ji=r(),h(_t.$$.fragment),wi=r(),h(Tt.$$.fragment),Ci=r(),ee=g("div"),h(ra.$$.fragment),Ui=r(),Hl=g("p"),Hl.textContent=vg,$i=r(),h(It.$$.fragment),vi=r(),h(xt.$$.fragment),ki=r(),ne=g("div"),h(ia.$$.fragment),qi=r(),Fl=g("p"),Fl.textContent=kg,Ei=r(),zl=g("p"),zl.textContent=qg,Ai=r(),h(Jt.$$.fragment),Zi=r(),Z=g("div"),h(ca.$$.fragment),Wi=r(),Ll=g("p"),Ll.textContent=Eg,Ni=r(),Pl=g("p"),Pl.innerHTML=Ag,Gi=r(),h(wt.$$.fragment),Bi=r(),h(Ct.$$.fragment),Vi=r(),h(Ut.$$.fragment),Qi=r(),te=g("div"),h(pa.$$.fragment),Yi=r(),Ol=g("p"),Ol.textContent=Zg,Si=r(),h($t.$$.fragment),Di=r(),h(vt.$$.fragment),Ri=r(),kt=g("div"),h(ua.$$.fragment),Xi=r(),Kl=g("p"),Kl.textContent=Wg,Hi=r(),Be=g("div"),h(ga.$$.fragment),Fi=r(),eo=g("p"),eo.textContent=Ng,zi=r(),h(qt.$$.fragment),Li=r(),Ve=g("div"),h(ma.$$.fragment),Pi=r(),no=g("p"),no.textContent=Gg,Oi=r(),h(Et.$$.fragment),Ki=r(),Qe=g("div"),h(ha.$$.fragment),ec=r(),to=g("p"),to.textContent=Bg,nc=r(),h(At.$$.fragment),tc=r(),Ye=g("div"),h(da.$$.fragment),sc=r(),so=g("p"),so.textContent=Vg,ac=r(),h(Zt.$$.fragment),lc=r(),Se=g("div"),h(fa.$$.fragment),oc=r(),ao=g("p"),ao.textContent=Qg,rc=r(),h(Wt.$$.fragment),ic=r(),De=g("div"),h(ya.$$.fragment),cc=r(),lo=g("p"),lo.textContent=Yg,pc=r(),h(Nt.$$.fragment),uc=r(),Re=g("div"),h(ba.$$.fragment),gc=r(),oo=g("p"),oo.textContent=Sg,mc=r(),h(Gt.$$.fragment),hc=r(),W=g("div"),h(Ma.$$.fragment),dc=r(),ro=g("p"),ro.textContent=Dg,fc=r(),io=g("p"),io.innerHTML=Rg,yc=r(),co=g("p"),co.innerHTML=Xg,bc=r(),h(Bt.$$.fragment),Mc=r(),h(Vt.$$.fragment),jc=r(),se=g("div"),h(ja.$$.fragment),_c=r(),po=g("p"),po.textContent=Hg,Tc=r(),h(Qt.$$.fragment),Ic=r(),h(Yt.$$.fragment),xc=r(),Xe=g("div"),h(_a.$$.fragment),Jc=r(),uo=g("p"),uo.textContent=Fg,wc=r(),h(St.$$.fragment),Cc=r(),He=g("div"),h(Ta.$$.fragment),Uc=r(),go=g("p"),go.textContent=zg,$c=r(),h(Dt.$$.fragment),vc=r(),D=g("div"),h(Ia.$$.fragment),kc=r(),mo=g("p"),mo.textContent=Lg,qc=r(),ho=g("p"),ho.innerHTML=Pg,Ec=r(),h(Rt.$$.fragment),Ac=r(),h(Xt.$$.fragment),Zc=r(),Fe=g("div"),h(xa.$$.fragment),Wc=r(),fo=g("p"),fo.textContent=Og,Nc=r(),h(Ht.$$.fragment),Gc=r(),ze=g("div"),h(Ja.$$.fragment),Bc=r(),yo=g("p"),yo.textContent=Kg,Vc=r(),h(Ft.$$.fragment),Qc=r(),Le=g("div"),h(wa.$$.fragment),Yc=r(),bo=g("p"),bo.textContent=em,Sc=r(),h(zt.$$.fragment),Mr=r(),h(Ca.$$.fragment),jr=r(),Ua=g("p"),Ua.innerHTML=nm,_r=r(),h($a.$$.fragment),Tr=r(),w=g("div"),h(va.$$.fragment),Dc=r(),Mo=g("p"),Mo.textContent=tm,Rc=r(),jo=g("p"),jo.innerHTML=sm,Xc=r(),Pe=g("div"),h(ka.$$.fragment),Hc=r(),_o=g("p"),_o.textContent=am,Fc=r(),h(Lt.$$.fragment),zc=r(),Oe=g("div"),h(qa.$$.fragment),Lc=r(),To=g("p"),To.textContent=lm,Pc=r(),h(Pt.$$.fragment),Oc=r(),Ke=g("div"),h(Ea.$$.fragment),Kc=r(),Io=g("p"),Io.textContent=om,ep=r(),h(Ot.$$.fragment),np=r(),en=g("div"),h(Aa.$$.fragment),tp=r(),xo=g("p"),xo.textContent=rm,sp=r(),h(Kt.$$.fragment),ap=r(),ae=g("div"),h(Za.$$.fragment),lp=r(),Jo=g("p"),Jo.textContent=im,op=r(),h(es.$$.fragment),rp=r(),h(ns.$$.fragment),ip=r(),nn=g("div"),h(Wa.$$.fragment),cp=r(),wo=g("p"),wo.textContent=cm,pp=r(),h(ts.$$.fragment),up=r(),tn=g("div"),h(Na.$$.fragment),gp=r(),Co=g("p"),Co.textContent=pm,mp=r(),h(ss.$$.fragment),hp=r(),sn=g("div"),h(Ga.$$.fragment),dp=r(),Uo=g("p"),Uo.textContent=um,fp=r(),h(as.$$.fragment),yp=r(),le=g("div"),h(Ba.$$.fragment),bp=r(),$o=g("p"),$o.textContent=gm,Mp=r(),vo=g("p"),vo.innerHTML=mm,jp=r(),h(ls.$$.fragment),_p=r(),oe=g("div"),h(Va.$$.fragment),Tp=r(),ko=g("p"),ko.textContent=hm,Ip=r(),h(os.$$.fragment),xp=r(),h(rs.$$.fragment),Jp=r(),is=g("div"),h(Qa.$$.fragment),wp=r(),qo=g("p"),qo.textContent=dm,Cp=r(),re=g("div"),h(Ya.$$.fragment),Up=r(),Eo=g("p"),Eo.textContent=fm,$p=r(),Ao=g("p"),Ao.innerHTML=ym,vp=r(),h(cs.$$.fragment),kp=r(),an=g("div"),h(Sa.$$.fragment),qp=r(),Zo=g("p"),Zo.textContent=bm,Ep=r(),h(ps.$$.fragment),Ap=r(),ie=g("div"),h(Da.$$.fragment),Zp=r(),Wo=g("p"),Wo.textContent=Mm,Wp=r(),h(us.$$.fragment),Np=r(),h(gs.$$.fragment),Gp=r(),ce=g("div"),h(Ra.$$.fragment),Bp=r(),No=g("p"),No.textContent=jm,Vp=r(),h(ms.$$.fragment),Qp=r(),h(hs.$$.fragment),Yp=r(),pe=g("div"),h(Xa.$$.fragment),Sp=r(),Go=g("p"),Go.textContent=_m,Dp=r(),Bo=g("p"),Bo.textContent=Tm,Rp=r(),h(ds.$$.fragment),Xp=r(),N=g("div"),h(Ha.$$.fragment),Hp=r(),Vo=g("p"),Vo.textContent=Im,Fp=r(),Qo=g("p"),Qo.innerHTML=xm,zp=r(),h(fs.$$.fragment),Lp=r(),h(ys.$$.fragment),Pp=r(),h(bs.$$.fragment),Op=r(),ue=g("div"),h(Fa.$$.fragment),Kp=r(),Yo=g("p"),Yo.textContent=Jm,eu=r(),h(Ms.$$.fragment),nu=r(),h(js.$$.fragment),tu=r(),_s=g("div"),h(za.$$.fragment),su=r(),So=g("p"),So.textContent=wm,au=r(),ln=g("div"),h(La.$$.fragment),lu=r(),Do=g("p"),Do.textContent=Cm,ou=r(),h(Ts.$$.fragment),ru=r(),on=g("div"),h(Pa.$$.fragment),iu=r(),Ro=g("p"),Ro.textContent=Um,cu=r(),h(Is.$$.fragment),pu=r(),rn=g("div"),h(Oa.$$.fragment),uu=r(),Xo=g("p"),Xo.textContent=$m,gu=r(),h(xs.$$.fragment),mu=r(),cn=g("div"),h(Ka.$$.fragment),hu=r(),Ho=g("p"),Ho.textContent=vm,du=r(),h(Js.$$.fragment),fu=r(),pn=g("div"),h(el.$$.fragment),yu=r(),Fo=g("p"),Fo.textContent=km,bu=r(),h(ws.$$.fragment),Mu=r(),un=g("div"),h(nl.$$.fragment),ju=r(),zo=g("p"),zo.textContent=qm,_u=r(),h(Cs.$$.fragment),Tu=r(),gn=g("div"),h(tl.$$.fragment),Iu=r(),Lo=g("p"),Lo.textContent=Em,xu=r(),h(Us.$$.fragment),Ju=r(),G=g("div"),h(sl.$$.fragment),wu=r(),Po=g("p"),Po.textContent=Am,Cu=r(),Oo=g("p"),Oo.innerHTML=Zm,Uu=r(),Ko=g("p"),Ko.innerHTML=Wm,$u=r(),h($s.$$.fragment),vu=r(),h(vs.$$.fragment),ku=r(),ge=g("div"),h(al.$$.fragment),qu=r(),er=g("p"),er.textContent=Nm,Eu=r(),h(ks.$$.fragment),Au=r(),h(qs.$$.fragment),Zu=r(),mn=g("div"),h(ll.$$.fragment),Wu=r(),nr=g("p"),nr.textContent=Gm,Nu=r(),h(Es.$$.fragment),Gu=r(),hn=g("div"),h(ol.$$.fragment),Bu=r(),tr=g("p"),tr.textContent=Bm,Vu=r(),h(As.$$.fragment),Qu=r(),R=g("div"),h(rl.$$.fragment),Yu=r(),sr=g("p"),sr.textContent=Vm,Su=r(),ar=g("p"),ar.innerHTML=Qm,Du=r(),h(Zs.$$.fragment),Ru=r(),h(Ws.$$.fragment),Xu=r(),dn=g("div"),h(il.$$.fragment),Hu=r(),lr=g("p"),lr.textContent=Ym,Fu=r(),h(Ns.$$.fragment),zu=r(),fn=g("div"),h(cl.$$.fragment),Lu=r(),or=g("p"),or.textContent=Sm,Pu=r(),h(Gs.$$.fragment),Ou=r(),yn=g("div"),h(pl.$$.fragment),Ku=r(),rr=g("p"),rr.textContent=Dm,eg=r(),h(Bs.$$.fragment),Ir=r(),h(ul.$$.fragment),xr=r(),bn=g("div"),h(gl.$$.fragment),ng=r(),ir=g("p"),ir.textContent=Rm,Jr=r(),h(ml.$$.fragment),wr=r(),Mn=g("div"),h(hl.$$.fragment),tg=r(),cr=g("p"),cr.textContent=Xm,Cr=r(),h(dl.$$.fragment),Ur=r(),fl=g("p"),fl.innerHTML=Hm,$r=r(),B=g("div"),h(yl.$$.fragment),sg=r(),pr=g("p"),pr.textContent=Fm,ag=r(),h(Vs.$$.fragment),lg=r(),Qs=g("div"),h(bl.$$.fragment),og=r(),ur=g("p"),ur.textContent=zm,rg=r(),Ys=g("div"),h(Ml.$$.fragment),ig=r(),gr=g("p"),gr.textContent=Lm,vr=r(),h(jl.$$.fragment),kr=r(),hr=g("p"),this.h()},l(s){const j=uh("svelte-u9bgzb",document.head);n=m(j,"META",{name:!0,content:!0}),j.forEach(p),u=i(s),a=m(s,"P",{}),$(a).forEach(p),t=i(s),d(o.$$.fragment,s),e=i(s),c=m(s,"P",{"data-svelte-h":!0}),T(c)!=="svelte-411gzg"&&(c.innerHTML=cg),dr=i(s),Ss=m(s,"UL",{"data-svelte-h":!0}),T(Ss)!=="svelte-1qqordt"&&(Ss.innerHTML=pg),fr=i(s),Ds=m(s,"P",{"data-svelte-h":!0}),T(Ds)!=="svelte-6emn9o"&&(Ds.innerHTML=ug),yr=i(s),d(Rs.$$.fragment,s),br=i(s),J=m(s,"DIV",{class:!0});var C=$(J);d(Xs.$$.fragment,C),Er=i(C),$l=m(C,"P",{"data-svelte-h":!0}),T($l)!=="svelte-1p4u01l"&&($l.textContent=gg),Ar=i(C),vl=m(C,"P",{"data-svelte-h":!0}),T(vl)!=="svelte-1xwrrwx"&&(vl.innerHTML=mg),Zr=i(C),ke=m(C,"DIV",{class:!0});var jn=$(ke);d(Hs.$$.fragment,jn),Wr=i(jn),kl=m(jn,"P",{"data-svelte-h":!0}),T(kl)!=="svelte-1hs5qib"&&(kl.textContent=hg),Nr=i(jn),d(ot.$$.fragment,jn),jn.forEach(p),Gr=i(C),qe=m(C,"DIV",{class:!0});var _n=$(qe);d(Fs.$$.fragment,_n),Br=i(_n),ql=m(_n,"P",{"data-svelte-h":!0}),T(ql)!=="svelte-z9e742"&&(ql.textContent=dg),Vr=i(_n),d(rt.$$.fragment,_n),_n.forEach(p),Qr=i(C),Ee=m(C,"DIV",{class:!0});var Tn=$(Ee);d(zs.$$.fragment,Tn),Yr=i(Tn),El=m(Tn,"P",{"data-svelte-h":!0}),T(El)!=="svelte-lahnll"&&(El.textContent=fg),Sr=i(Tn),d(it.$$.fragment,Tn),Tn.forEach(p),Dr=i(C),Ae=m(C,"DIV",{class:!0});var In=$(Ae);d(Ls.$$.fragment,In),Rr=i(In),Al=m(In,"P",{"data-svelte-h":!0}),T(Al)!=="svelte-5o70yf"&&(Al.textContent=yg),Xr=i(In),d(ct.$$.fragment,In),In.forEach(p),Hr=i(C),z=m(C,"DIV",{class:!0});var me=$(z);d(Ps.$$.fragment,me),Fr=i(me),Zl=m(me,"P",{"data-svelte-h":!0}),T(Zl)!=="svelte-2dk21c"&&(Zl.textContent=bg),zr=i(me),d(pt.$$.fragment,me),Lr=i(me),d(ut.$$.fragment,me),me.forEach(p),Pr=i(C),Ze=m(C,"DIV",{class:!0});var xn=$(Ze);d(Os.$$.fragment,xn),Or=i(xn),Wl=m(xn,"P",{"data-svelte-h":!0}),T(Wl)!=="svelte-qs8cmr"&&(Wl.textContent=Mg),Kr=i(xn),d(gt.$$.fragment,xn),xn.forEach(p),ei=i(C),We=m(C,"DIV",{class:!0});var Jn=$(We);d(Ks.$$.fragment,Jn),ni=i(Jn),Nl=m(Jn,"P",{"data-svelte-h":!0}),T(Nl)!=="svelte-1axtrg9"&&(Nl.textContent=jg),ti=i(Jn),d(mt.$$.fragment,Jn),Jn.forEach(p),si=i(C),Ne=m(C,"DIV",{class:!0});var wn=$(Ne);d(ea.$$.fragment,wn),ai=i(wn),Gl=m(wn,"P",{"data-svelte-h":!0}),T(Gl)!=="svelte-1lnjtsz"&&(Gl.textContent=_g),li=i(wn),d(ht.$$.fragment,wn),wn.forEach(p),oi=i(C),L=m(C,"DIV",{class:!0});var he=$(L);d(na.$$.fragment,he),ri=i(he),Bl=m(he,"P",{"data-svelte-h":!0}),T(Bl)!=="svelte-s2la9t"&&(Bl.textContent=Tg),ii=i(he),Vl=m(he,"P",{"data-svelte-h":!0}),T(Vl)!=="svelte-1xhka28"&&(Vl.innerHTML=Ig),ci=i(he),d(dt.$$.fragment,he),he.forEach(p),pi=i(C),P=m(C,"DIV",{class:!0});var de=$(P);d(ta.$$.fragment,de),ui=i(de),Ql=m(de,"P",{"data-svelte-h":!0}),T(Ql)!=="svelte-1htupoc"&&(Ql.textContent=xg),gi=i(de),d(ft.$$.fragment,de),mi=i(de),d(yt.$$.fragment,de),de.forEach(p),hi=i(C),bt=m(C,"DIV",{class:!0});var _l=$(bt);d(sa.$$.fragment,_l),di=i(_l),Yl=m(_l,"P",{"data-svelte-h":!0}),T(Yl)!=="svelte-1qi4mtg"&&(Yl.textContent=Jg),_l.forEach(p),fi=i(C),O=m(C,"DIV",{class:!0});var fe=$(O);d(aa.$$.fragment,fe),yi=i(fe),Sl=m(fe,"P",{"data-svelte-h":!0}),T(Sl)!=="svelte-1m9sgvu"&&(Sl.textContent=wg),bi=i(fe),Dl=m(fe,"P",{"data-svelte-h":!0}),T(Dl)!=="svelte-wsu1bg"&&(Dl.innerHTML=Cg),Mi=i(fe),d(Mt.$$.fragment,fe),fe.forEach(p),ji=i(C),Ge=m(C,"DIV",{class:!0});var Cn=$(Ge);d(la.$$.fragment,Cn),_i=i(Cn),Rl=m(Cn,"P",{"data-svelte-h":!0}),T(Rl)!=="svelte-u63854"&&(Rl.textContent=Ug),Ti=i(Cn),d(jt.$$.fragment,Cn),Cn.forEach(p),Ii=i(C),K=m(C,"DIV",{class:!0});var ye=$(K);d(oa.$$.fragment,ye),xi=i(ye),Xl=m(ye,"P",{"data-svelte-h":!0}),T(Xl)!=="svelte-k6f11e"&&(Xl.textContent=$g),Ji=i(ye),d(_t.$$.fragment,ye),wi=i(ye),d(Tt.$$.fragment,ye),ye.forEach(p),Ci=i(C),ee=m(C,"DIV",{class:!0});var be=$(ee);d(ra.$$.fragment,be),Ui=i(be),Hl=m(be,"P",{"data-svelte-h":!0}),T(Hl)!=="svelte-7cx5l1"&&(Hl.textContent=vg),$i=i(be),d(It.$$.fragment,be),vi=i(be),d(xt.$$.fragment,be),be.forEach(p),ki=i(C),ne=m(C,"DIV",{class:!0});var Me=$(ne);d(ia.$$.fragment,Me),qi=i(Me),Fl=m(Me,"P",{"data-svelte-h":!0}),T(Fl)!=="svelte-1tnfouk"&&(Fl.textContent=kg),Ei=i(Me),zl=m(Me,"P",{"data-svelte-h":!0}),T(zl)!=="svelte-qrqo93"&&(zl.textContent=qg),Ai=i(Me),d(Jt.$$.fragment,Me),Me.forEach(p),Zi=i(C),Z=m(C,"DIV",{class:!0});var V=$(Z);d(ca.$$.fragment,V),Wi=i(V),Ll=m(V,"P",{"data-svelte-h":!0}),T(Ll)!=="svelte-71vo6e"&&(Ll.textContent=Eg),Ni=i(V),Pl=m(V,"P",{"data-svelte-h":!0}),T(Pl)!=="svelte-1k36r1q"&&(Pl.innerHTML=Ag),Gi=i(V),d(wt.$$.fragment,V),Bi=i(V),d(Ct.$$.fragment,V),Vi=i(V),d(Ut.$$.fragment,V),V.forEach(p),Qi=i(C),te=m(C,"DIV",{class:!0});var je=$(te);d(pa.$$.fragment,je),Yi=i(je),Ol=m(je,"P",{"data-svelte-h":!0}),T(Ol)!=="svelte-fzfwfh"&&(Ol.textContent=Zg),Si=i(je),d($t.$$.fragment,je),Di=i(je),d(vt.$$.fragment,je),je.forEach(p),Ri=i(C),kt=m(C,"DIV",{class:!0});var Tl=$(kt);d(ua.$$.fragment,Tl),Xi=i(Tl),Kl=m(Tl,"P",{"data-svelte-h":!0}),T(Kl)!=="svelte-14tnsya"&&(Kl.textContent=Wg),Tl.forEach(p),Hi=i(C),Be=m(C,"DIV",{class:!0});var Un=$(Be);d(ga.$$.fragment,Un),Fi=i(Un),eo=m(Un,"P",{"data-svelte-h":!0}),T(eo)!=="svelte-1mibg86"&&(eo.textContent=Ng),zi=i(Un),d(qt.$$.fragment,Un),Un.forEach(p),Li=i(C),Ve=m(C,"DIV",{class:!0});var $n=$(Ve);d(ma.$$.fragment,$n),Pi=i($n),no=m($n,"P",{"data-svelte-h":!0}),T(no)!=="svelte-1nuhgbh"&&(no.textContent=Gg),Oi=i($n),d(Et.$$.fragment,$n),$n.forEach(p),Ki=i(C),Qe=m(C,"DIV",{class:!0});var vn=$(Qe);d(ha.$$.fragment,vn),ec=i(vn),to=m(vn,"P",{"data-svelte-h":!0}),T(to)!=="svelte-1uepm2o"&&(to.textContent=Bg),nc=i(vn),d(At.$$.fragment,vn),vn.forEach(p),tc=i(C),Ye=m(C,"DIV",{class:!0});var kn=$(Ye);d(da.$$.fragment,kn),sc=i(kn),so=m(kn,"P",{"data-svelte-h":!0}),T(so)!=="svelte-77a94i"&&(so.textContent=Vg),ac=i(kn),d(Zt.$$.fragment,kn),kn.forEach(p),lc=i(C),Se=m(C,"DIV",{class:!0});var qn=$(Se);d(fa.$$.fragment,qn),oc=i(qn),ao=m(qn,"P",{"data-svelte-h":!0}),T(ao)!=="svelte-61sxmo"&&(ao.textContent=Qg),rc=i(qn),d(Wt.$$.fragment,qn),qn.forEach(p),ic=i(C),De=m(C,"DIV",{class:!0});var En=$(De);d(ya.$$.fragment,En),cc=i(En),lo=m(En,"P",{"data-svelte-h":!0}),T(lo)!=="svelte-hzldyu"&&(lo.textContent=Yg),pc=i(En),d(Nt.$$.fragment,En),En.forEach(p),uc=i(C),Re=m(C,"DIV",{class:!0});var An=$(Re);d(ba.$$.fragment,An),gc=i(An),oo=m(An,"P",{"data-svelte-h":!0}),T(oo)!=="svelte-b4yzyj"&&(oo.textContent=Sg),mc=i(An),d(Gt.$$.fragment,An),An.forEach(p),hc=i(C),W=m(C,"DIV",{class:!0});var Q=$(W);d(Ma.$$.fragment,Q),dc=i(Q),ro=m(Q,"P",{"data-svelte-h":!0}),T(ro)!=="svelte-qakvx8"&&(ro.textContent=Dg),fc=i(Q),io=m(Q,"P",{"data-svelte-h":!0}),T(io)!=="svelte-1irx2op"&&(io.innerHTML=Rg),yc=i(Q),co=m(Q,"P",{"data-svelte-h":!0}),T(co)!=="svelte-140zl9b"&&(co.innerHTML=Xg),bc=i(Q),d(Bt.$$.fragment,Q),Mc=i(Q),d(Vt.$$.fragment,Q),Q.forEach(p),jc=i(C),se=m(C,"DIV",{class:!0});var _e=$(se);d(ja.$$.fragment,_e),_c=i(_e),po=m(_e,"P",{"data-svelte-h":!0}),T(po)!=="svelte-9lmcnw"&&(po.textContent=Hg),Tc=i(_e),d(Qt.$$.fragment,_e),Ic=i(_e),d(Yt.$$.fragment,_e),_e.forEach(p),xc=i(C),Xe=m(C,"DIV",{class:!0});var Zn=$(Xe);d(_a.$$.fragment,Zn),Jc=i(Zn),uo=m(Zn,"P",{"data-svelte-h":!0}),T(uo)!=="svelte-12mjzdy"&&(uo.textContent=Fg),wc=i(Zn),d(St.$$.fragment,Zn),Zn.forEach(p),Cc=i(C),He=m(C,"DIV",{class:!0});var Wn=$(He);d(Ta.$$.fragment,Wn),Uc=i(Wn),go=m(Wn,"P",{"data-svelte-h":!0}),T(go)!=="svelte-1araal"&&(go.textContent=zg),$c=i(Wn),d(Dt.$$.fragment,Wn),Wn.forEach(p),vc=i(C),D=m(C,"DIV",{class:!0});var X=$(D);d(Ia.$$.fragment,X),kc=i(X),mo=m(X,"P",{"data-svelte-h":!0}),T(mo)!=="svelte-1v3lqck"&&(mo.textContent=Lg),qc=i(X),ho=m(X,"P",{"data-svelte-h":!0}),T(ho)!=="svelte-19inetw"&&(ho.innerHTML=Pg),Ec=i(X),d(Rt.$$.fragment,X),Ac=i(X),d(Xt.$$.fragment,X),X.forEach(p),Zc=i(C),Fe=m(C,"DIV",{class:!0});var Nn=$(Fe);d(xa.$$.fragment,Nn),Wc=i(Nn),fo=m(Nn,"P",{"data-svelte-h":!0}),T(fo)!=="svelte-1jbp6ey"&&(fo.textContent=Og),Nc=i(Nn),d(Ht.$$.fragment,Nn),Nn.forEach(p),Gc=i(C),ze=m(C,"DIV",{class:!0});var Gn=$(ze);d(Ja.$$.fragment,Gn),Bc=i(Gn),yo=m(Gn,"P",{"data-svelte-h":!0}),T(yo)!=="svelte-1c9xuqj"&&(yo.textContent=Kg),Vc=i(Gn),d(Ft.$$.fragment,Gn),Gn.forEach(p),Qc=i(C),Le=m(C,"DIV",{class:!0});var Bn=$(Le);d(wa.$$.fragment,Bn),Yc=i(Bn),bo=m(Bn,"P",{"data-svelte-h":!0}),T(bo)!=="svelte-108ipf8"&&(bo.textContent=em),Sc=i(Bn),d(zt.$$.fragment,Bn),Bn.forEach(p),C.forEach(p),Mr=i(s),d(Ca.$$.fragment,s),jr=i(s),Ua=m(s,"P",{"data-svelte-h":!0}),T(Ua)!=="svelte-nn0rvx"&&(Ua.innerHTML=nm),_r=i(s),d($a.$$.fragment,s),Tr=i(s),w=m(s,"DIV",{class:!0});var U=$(w);d(va.$$.fragment,U),Dc=i(U),Mo=m(U,"P",{"data-svelte-h":!0}),T(Mo)!=="svelte-1p4u01l"&&(Mo.textContent=tm),Rc=i(U),jo=m(U,"P",{"data-svelte-h":!0}),T(jo)!=="svelte-1xwrrwx"&&(jo.innerHTML=sm),Xc=i(U),Pe=m(U,"DIV",{class:!0});var Vn=$(Pe);d(ka.$$.fragment,Vn),Hc=i(Vn),_o=m(Vn,"P",{"data-svelte-h":!0}),T(_o)!=="svelte-1hs5qib"&&(_o.textContent=am),Fc=i(Vn),d(Lt.$$.fragment,Vn),Vn.forEach(p),zc=i(U),Oe=m(U,"DIV",{class:!0});var Qn=$(Oe);d(qa.$$.fragment,Qn),Lc=i(Qn),To=m(Qn,"P",{"data-svelte-h":!0}),T(To)!=="svelte-z9e742"&&(To.textContent=lm),Pc=i(Qn),d(Pt.$$.fragment,Qn),Qn.forEach(p),Oc=i(U),Ke=m(U,"DIV",{class:!0});var Yn=$(Ke);d(Ea.$$.fragment,Yn),Kc=i(Yn),Io=m(Yn,"P",{"data-svelte-h":!0}),T(Io)!=="svelte-lahnll"&&(Io.textContent=om),ep=i(Yn),d(Ot.$$.fragment,Yn),Yn.forEach(p),np=i(U),en=m(U,"DIV",{class:!0});var Sn=$(en);d(Aa.$$.fragment,Sn),tp=i(Sn),xo=m(Sn,"P",{"data-svelte-h":!0}),T(xo)!=="svelte-5o70yf"&&(xo.textContent=rm),sp=i(Sn),d(Kt.$$.fragment,Sn),Sn.forEach(p),ap=i(U),ae=m(U,"DIV",{class:!0});var Te=$(ae);d(Za.$$.fragment,Te),lp=i(Te),Jo=m(Te,"P",{"data-svelte-h":!0}),T(Jo)!=="svelte-2dk21c"&&(Jo.textContent=im),op=i(Te),d(es.$$.fragment,Te),rp=i(Te),d(ns.$$.fragment,Te),Te.forEach(p),ip=i(U),nn=m(U,"DIV",{class:!0});var Dn=$(nn);d(Wa.$$.fragment,Dn),cp=i(Dn),wo=m(Dn,"P",{"data-svelte-h":!0}),T(wo)!=="svelte-qs8cmr"&&(wo.textContent=cm),pp=i(Dn),d(ts.$$.fragment,Dn),Dn.forEach(p),up=i(U),tn=m(U,"DIV",{class:!0});var Rn=$(tn);d(Na.$$.fragment,Rn),gp=i(Rn),Co=m(Rn,"P",{"data-svelte-h":!0}),T(Co)!=="svelte-1axtrg9"&&(Co.textContent=pm),mp=i(Rn),d(ss.$$.fragment,Rn),Rn.forEach(p),hp=i(U),sn=m(U,"DIV",{class:!0});var Xn=$(sn);d(Ga.$$.fragment,Xn),dp=i(Xn),Uo=m(Xn,"P",{"data-svelte-h":!0}),T(Uo)!=="svelte-1lnjtsz"&&(Uo.textContent=um),fp=i(Xn),d(as.$$.fragment,Xn),Xn.forEach(p),yp=i(U),le=m(U,"DIV",{class:!0});var Ie=$(le);d(Ba.$$.fragment,Ie),bp=i(Ie),$o=m(Ie,"P",{"data-svelte-h":!0}),T($o)!=="svelte-s2la9t"&&($o.textContent=gm),Mp=i(Ie),vo=m(Ie,"P",{"data-svelte-h":!0}),T(vo)!=="svelte-1xhka28"&&(vo.innerHTML=mm),jp=i(Ie),d(ls.$$.fragment,Ie),Ie.forEach(p),_p=i(U),oe=m(U,"DIV",{class:!0});var xe=$(oe);d(Va.$$.fragment,xe),Tp=i(xe),ko=m(xe,"P",{"data-svelte-h":!0}),T(ko)!=="svelte-1htupoc"&&(ko.textContent=hm),Ip=i(xe),d(os.$$.fragment,xe),xp=i(xe),d(rs.$$.fragment,xe),xe.forEach(p),Jp=i(U),is=m(U,"DIV",{class:!0});var Il=$(is);d(Qa.$$.fragment,Il),wp=i(Il),qo=m(Il,"P",{"data-svelte-h":!0}),T(qo)!=="svelte-1qi4mtg"&&(qo.textContent=dm),Il.forEach(p),Cp=i(U),re=m(U,"DIV",{class:!0});var Je=$(re);d(Ya.$$.fragment,Je),Up=i(Je),Eo=m(Je,"P",{"data-svelte-h":!0}),T(Eo)!=="svelte-1m9sgvu"&&(Eo.textContent=fm),$p=i(Je),Ao=m(Je,"P",{"data-svelte-h":!0}),T(Ao)!=="svelte-wsu1bg"&&(Ao.innerHTML=ym),vp=i(Je),d(cs.$$.fragment,Je),Je.forEach(p),kp=i(U),an=m(U,"DIV",{class:!0});var Hn=$(an);d(Sa.$$.fragment,Hn),qp=i(Hn),Zo=m(Hn,"P",{"data-svelte-h":!0}),T(Zo)!=="svelte-u63854"&&(Zo.textContent=bm),Ep=i(Hn),d(ps.$$.fragment,Hn),Hn.forEach(p),Ap=i(U),ie=m(U,"DIV",{class:!0});var we=$(ie);d(Da.$$.fragment,we),Zp=i(we),Wo=m(we,"P",{"data-svelte-h":!0}),T(Wo)!=="svelte-k6f11e"&&(Wo.textContent=Mm),Wp=i(we),d(us.$$.fragment,we),Np=i(we),d(gs.$$.fragment,we),we.forEach(p),Gp=i(U),ce=m(U,"DIV",{class:!0});var Ce=$(ce);d(Ra.$$.fragment,Ce),Bp=i(Ce),No=m(Ce,"P",{"data-svelte-h":!0}),T(No)!=="svelte-7cx5l1"&&(No.textContent=jm),Vp=i(Ce),d(ms.$$.fragment,Ce),Qp=i(Ce),d(hs.$$.fragment,Ce),Ce.forEach(p),Yp=i(U),pe=m(U,"DIV",{class:!0});var Ue=$(pe);d(Xa.$$.fragment,Ue),Sp=i(Ue),Go=m(Ue,"P",{"data-svelte-h":!0}),T(Go)!=="svelte-1tnfouk"&&(Go.textContent=_m),Dp=i(Ue),Bo=m(Ue,"P",{"data-svelte-h":!0}),T(Bo)!=="svelte-qrqo93"&&(Bo.textContent=Tm),Rp=i(Ue),d(ds.$$.fragment,Ue),Ue.forEach(p),Xp=i(U),N=m(U,"DIV",{class:!0});var Y=$(N);d(Ha.$$.fragment,Y),Hp=i(Y),Vo=m(Y,"P",{"data-svelte-h":!0}),T(Vo)!=="svelte-71vo6e"&&(Vo.textContent=Im),Fp=i(Y),Qo=m(Y,"P",{"data-svelte-h":!0}),T(Qo)!=="svelte-1k36r1q"&&(Qo.innerHTML=xm),zp=i(Y),d(fs.$$.fragment,Y),Lp=i(Y),d(ys.$$.fragment,Y),Pp=i(Y),d(bs.$$.fragment,Y),Y.forEach(p),Op=i(U),ue=m(U,"DIV",{class:!0});var $e=$(ue);d(Fa.$$.fragment,$e),Kp=i($e),Yo=m($e,"P",{"data-svelte-h":!0}),T(Yo)!=="svelte-fzfwfh"&&(Yo.textContent=Jm),eu=i($e),d(Ms.$$.fragment,$e),nu=i($e),d(js.$$.fragment,$e),$e.forEach(p),tu=i(U),_s=m(U,"DIV",{class:!0});var xl=$(_s);d(za.$$.fragment,xl),su=i(xl),So=m(xl,"P",{"data-svelte-h":!0}),T(So)!=="svelte-14tnsya"&&(So.textContent=wm),xl.forEach(p),au=i(U),ln=m(U,"DIV",{class:!0});var Fn=$(ln);d(La.$$.fragment,Fn),lu=i(Fn),Do=m(Fn,"P",{"data-svelte-h":!0}),T(Do)!=="svelte-1mibg86"&&(Do.textContent=Cm),ou=i(Fn),d(Ts.$$.fragment,Fn),Fn.forEach(p),ru=i(U),on=m(U,"DIV",{class:!0});var zn=$(on);d(Pa.$$.fragment,zn),iu=i(zn),Ro=m(zn,"P",{"data-svelte-h":!0}),T(Ro)!=="svelte-1nuhgbh"&&(Ro.textContent=Um),cu=i(zn),d(Is.$$.fragment,zn),zn.forEach(p),pu=i(U),rn=m(U,"DIV",{class:!0});var Ln=$(rn);d(Oa.$$.fragment,Ln),uu=i(Ln),Xo=m(Ln,"P",{"data-svelte-h":!0}),T(Xo)!=="svelte-1uepm2o"&&(Xo.textContent=$m),gu=i(Ln),d(xs.$$.fragment,Ln),Ln.forEach(p),mu=i(U),cn=m(U,"DIV",{class:!0});var Pn=$(cn);d(Ka.$$.fragment,Pn),hu=i(Pn),Ho=m(Pn,"P",{"data-svelte-h":!0}),T(Ho)!=="svelte-77a94i"&&(Ho.textContent=vm),du=i(Pn),d(Js.$$.fragment,Pn),Pn.forEach(p),fu=i(U),pn=m(U,"DIV",{class:!0});var On=$(pn);d(el.$$.fragment,On),yu=i(On),Fo=m(On,"P",{"data-svelte-h":!0}),T(Fo)!=="svelte-61sxmo"&&(Fo.textContent=km),bu=i(On),d(ws.$$.fragment,On),On.forEach(p),Mu=i(U),un=m(U,"DIV",{class:!0});var Kn=$(un);d(nl.$$.fragment,Kn),ju=i(Kn),zo=m(Kn,"P",{"data-svelte-h":!0}),T(zo)!=="svelte-hzldyu"&&(zo.textContent=qm),_u=i(Kn),d(Cs.$$.fragment,Kn),Kn.forEach(p),Tu=i(U),gn=m(U,"DIV",{class:!0});var et=$(gn);d(tl.$$.fragment,et),Iu=i(et),Lo=m(et,"P",{"data-svelte-h":!0}),T(Lo)!=="svelte-b4yzyj"&&(Lo.textContent=Em),xu=i(et),d(Us.$$.fragment,et),et.forEach(p),Ju=i(U),G=m(U,"DIV",{class:!0});var S=$(G);d(sl.$$.fragment,S),wu=i(S),Po=m(S,"P",{"data-svelte-h":!0}),T(Po)!=="svelte-qakvx8"&&(Po.textContent=Am),Cu=i(S),Oo=m(S,"P",{"data-svelte-h":!0}),T(Oo)!=="svelte-1irx2op"&&(Oo.innerHTML=Zm),Uu=i(S),Ko=m(S,"P",{"data-svelte-h":!0}),T(Ko)!=="svelte-140zl9b"&&(Ko.innerHTML=Wm),$u=i(S),d($s.$$.fragment,S),vu=i(S),d(vs.$$.fragment,S),S.forEach(p),ku=i(U),ge=m(U,"DIV",{class:!0});var ve=$(ge);d(al.$$.fragment,ve),qu=i(ve),er=m(ve,"P",{"data-svelte-h":!0}),T(er)!=="svelte-9lmcnw"&&(er.textContent=Nm),Eu=i(ve),d(ks.$$.fragment,ve),Au=i(ve),d(qs.$$.fragment,ve),ve.forEach(p),Zu=i(U),mn=m(U,"DIV",{class:!0});var nt=$(mn);d(ll.$$.fragment,nt),Wu=i(nt),nr=m(nt,"P",{"data-svelte-h":!0}),T(nr)!=="svelte-12mjzdy"&&(nr.textContent=Gm),Nu=i(nt),d(Es.$$.fragment,nt),nt.forEach(p),Gu=i(U),hn=m(U,"DIV",{class:!0});var tt=$(hn);d(ol.$$.fragment,tt),Bu=i(tt),tr=m(tt,"P",{"data-svelte-h":!0}),T(tr)!=="svelte-1araal"&&(tr.textContent=Bm),Vu=i(tt),d(As.$$.fragment,tt),tt.forEach(p),Qu=i(U),R=m(U,"DIV",{class:!0});var H=$(R);d(rl.$$.fragment,H),Yu=i(H),sr=m(H,"P",{"data-svelte-h":!0}),T(sr)!=="svelte-1v3lqck"&&(sr.textContent=Vm),Su=i(H),ar=m(H,"P",{"data-svelte-h":!0}),T(ar)!=="svelte-19inetw"&&(ar.innerHTML=Qm),Du=i(H),d(Zs.$$.fragment,H),Ru=i(H),d(Ws.$$.fragment,H),H.forEach(p),Xu=i(U),dn=m(U,"DIV",{class:!0});var st=$(dn);d(il.$$.fragment,st),Hu=i(st),lr=m(st,"P",{"data-svelte-h":!0}),T(lr)!=="svelte-1jbp6ey"&&(lr.textContent=Ym),Fu=i(st),d(Ns.$$.fragment,st),st.forEach(p),zu=i(U),fn=m(U,"DIV",{class:!0});var at=$(fn);d(cl.$$.fragment,at),Lu=i(at),or=m(at,"P",{"data-svelte-h":!0}),T(or)!=="svelte-1c9xuqj"&&(or.textContent=Sm),Pu=i(at),d(Gs.$$.fragment,at),at.forEach(p),Ou=i(U),yn=m(U,"DIV",{class:!0});var lt=$(yn);d(pl.$$.fragment,lt),Ku=i(lt),rr=m(lt,"P",{"data-svelte-h":!0}),T(rr)!=="svelte-108ipf8"&&(rr.textContent=Dm),eg=i(lt),d(Bs.$$.fragment,lt),lt.forEach(p),U.forEach(p),Ir=i(s),d(ul.$$.fragment,s),xr=i(s),bn=m(s,"DIV",{class:!0});var Jl=$(bn);d(gl.$$.fragment,Jl),ng=i(Jl),ir=m(Jl,"P",{"data-svelte-h":!0}),T(ir)!=="svelte-2793d9"&&(ir.textContent=Rm),Jl.forEach(p),Jr=i(s),d(ml.$$.fragment,s),wr=i(s),Mn=m(s,"DIV",{class:!0});var wl=$(Mn);d(hl.$$.fragment,wl),tg=i(wl),cr=m(wl,"P",{"data-svelte-h":!0}),T(cr)!=="svelte-18ffdgx"&&(cr.textContent=Xm),wl.forEach(p),Cr=i(s),d(dl.$$.fragment,s),Ur=i(s),fl=m(s,"P",{"data-svelte-h":!0}),T(fl)!=="svelte-1sljuta"&&(fl.innerHTML=Hm),$r=i(s),B=m(s,"DIV",{class:!0});var F=$(B);d(yl.$$.fragment,F),sg=i(F),pr=m(F,"P",{"data-svelte-h":!0}),T(pr)!=="svelte-xkrgz1"&&(pr.textContent=Fm),ag=i(F),d(Vs.$$.fragment,F),lg=i(F),Qs=m(F,"DIV",{class:!0});var Cl=$(Qs);d(bl.$$.fragment,Cl),og=i(Cl),ur=m(Cl,"P",{"data-svelte-h":!0}),T(ur)!=="svelte-1ruvvxs"&&(ur.textContent=zm),Cl.forEach(p),rg=i(F),Ys=m(F,"DIV",{class:!0});var Ul=$(Ys);d(Ml.$$.fragment,Ul),ig=i(Ul),gr=m(Ul,"P",{"data-svelte-h":!0}),T(gr)!=="svelte-ss15d2"&&(gr.textContent=Lm),Ul.forEach(p),F.forEach(p),vr=i(s),d(jl.$$.fragment,s),kr=i(s),hr=m(s,"P",{}),$(hr).forEach(p),this.h()},h(){v(n,"name","hf:doc:metadata"),v(n,"content",Rd),v(ke,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(qe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Ae,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Ze,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(We,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(bt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Ge,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(K,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(te,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(kt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Be,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Ve,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Qe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Ye,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(De,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Re,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Xe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(He,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Fe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ze,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Pe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Ke,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(en,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ae,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(nn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(tn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(sn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(is,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(re,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(an,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ce,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(pe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ue,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(_s,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ln,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(on,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(rn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(cn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(pn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(un,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(gn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ge,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(mn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(hn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(dn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(fn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(yn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(w,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(bn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Mn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Qs,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Ys,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(s,j){l(document.head,n),_(s,u,j),_(s,a,j),_(s,t,j),f(o,s,j),_(s,e,j),_(s,c,j),_(s,dr,j),_(s,Ss,j),_(s,fr,j),_(s,Ds,j),_(s,yr,j),f(Rs,s,j),_(s,br,j),_(s,J,j),f(Xs,J,null),l(J,Er),l(J,$l),l(J,Ar),l(J,vl),l(J,Zr),l(J,ke),f(Hs,ke,null),l(ke,Wr),l(ke,kl),l(ke,Nr),f(ot,ke,null),l(J,Gr),l(J,qe),f(Fs,qe,null),l(qe,Br),l(qe,ql),l(qe,Vr),f(rt,qe,null),l(J,Qr),l(J,Ee),f(zs,Ee,null),l(Ee,Yr),l(Ee,El),l(Ee,Sr),f(it,Ee,null),l(J,Dr),l(J,Ae),f(Ls,Ae,null),l(Ae,Rr),l(Ae,Al),l(Ae,Xr),f(ct,Ae,null),l(J,Hr),l(J,z),f(Ps,z,null),l(z,Fr),l(z,Zl),l(z,zr),f(pt,z,null),l(z,Lr),f(ut,z,null),l(J,Pr),l(J,Ze),f(Os,Ze,null),l(Ze,Or),l(Ze,Wl),l(Ze,Kr),f(gt,Ze,null),l(J,ei),l(J,We),f(Ks,We,null),l(We,ni),l(We,Nl),l(We,ti),f(mt,We,null),l(J,si),l(J,Ne),f(ea,Ne,null),l(Ne,ai),l(Ne,Gl),l(Ne,li),f(ht,Ne,null),l(J,oi),l(J,L),f(na,L,null),l(L,ri),l(L,Bl),l(L,ii),l(L,Vl),l(L,ci),f(dt,L,null),l(J,pi),l(J,P),f(ta,P,null),l(P,ui),l(P,Ql),l(P,gi),f(ft,P,null),l(P,mi),f(yt,P,null),l(J,hi),l(J,bt),f(sa,bt,null),l(bt,di),l(bt,Yl),l(J,fi),l(J,O),f(aa,O,null),l(O,yi),l(O,Sl),l(O,bi),l(O,Dl),l(O,Mi),f(Mt,O,null),l(J,ji),l(J,Ge),f(la,Ge,null),l(Ge,_i),l(Ge,Rl),l(Ge,Ti),f(jt,Ge,null),l(J,Ii),l(J,K),f(oa,K,null),l(K,xi),l(K,Xl),l(K,Ji),f(_t,K,null),l(K,wi),f(Tt,K,null),l(J,Ci),l(J,ee),f(ra,ee,null),l(ee,Ui),l(ee,Hl),l(ee,$i),f(It,ee,null),l(ee,vi),f(xt,ee,null),l(J,ki),l(J,ne),f(ia,ne,null),l(ne,qi),l(ne,Fl),l(ne,Ei),l(ne,zl),l(ne,Ai),f(Jt,ne,null),l(J,Zi),l(J,Z),f(ca,Z,null),l(Z,Wi),l(Z,Ll),l(Z,Ni),l(Z,Pl),l(Z,Gi),f(wt,Z,null),l(Z,Bi),f(Ct,Z,null),l(Z,Vi),f(Ut,Z,null),l(J,Qi),l(J,te),f(pa,te,null),l(te,Yi),l(te,Ol),l(te,Si),f($t,te,null),l(te,Di),f(vt,te,null),l(J,Ri),l(J,kt),f(ua,kt,null),l(kt,Xi),l(kt,Kl),l(J,Hi),l(J,Be),f(ga,Be,null),l(Be,Fi),l(Be,eo),l(Be,zi),f(qt,Be,null),l(J,Li),l(J,Ve),f(ma,Ve,null),l(Ve,Pi),l(Ve,no),l(Ve,Oi),f(Et,Ve,null),l(J,Ki),l(J,Qe),f(ha,Qe,null),l(Qe,ec),l(Qe,to),l(Qe,nc),f(At,Qe,null),l(J,tc),l(J,Ye),f(da,Ye,null),l(Ye,sc),l(Ye,so),l(Ye,ac),f(Zt,Ye,null),l(J,lc),l(J,Se),f(fa,Se,null),l(Se,oc),l(Se,ao),l(Se,rc),f(Wt,Se,null),l(J,ic),l(J,De),f(ya,De,null),l(De,cc),l(De,lo),l(De,pc),f(Nt,De,null),l(J,uc),l(J,Re),f(ba,Re,null),l(Re,gc),l(Re,oo),l(Re,mc),f(Gt,Re,null),l(J,hc),l(J,W),f(Ma,W,null),l(W,dc),l(W,ro),l(W,fc),l(W,io),l(W,yc),l(W,co),l(W,bc),f(Bt,W,null),l(W,Mc),f(Vt,W,null),l(J,jc),l(J,se),f(ja,se,null),l(se,_c),l(se,po),l(se,Tc),f(Qt,se,null),l(se,Ic),f(Yt,se,null),l(J,xc),l(J,Xe),f(_a,Xe,null),l(Xe,Jc),l(Xe,uo),l(Xe,wc),f(St,Xe,null),l(J,Cc),l(J,He),f(Ta,He,null),l(He,Uc),l(He,go),l(He,$c),f(Dt,He,null),l(J,vc),l(J,D),f(Ia,D,null),l(D,kc),l(D,mo),l(D,qc),l(D,ho),l(D,Ec),f(Rt,D,null),l(D,Ac),f(Xt,D,null),l(J,Zc),l(J,Fe),f(xa,Fe,null),l(Fe,Wc),l(Fe,fo),l(Fe,Nc),f(Ht,Fe,null),l(J,Gc),l(J,ze),f(Ja,ze,null),l(ze,Bc),l(ze,yo),l(ze,Vc),f(Ft,ze,null),l(J,Qc),l(J,Le),f(wa,Le,null),l(Le,Yc),l(Le,bo),l(Le,Sc),f(zt,Le,null),_(s,Mr,j),f(Ca,s,j),_(s,jr,j),_(s,Ua,j),_(s,_r,j),f($a,s,j),_(s,Tr,j),_(s,w,j),f(va,w,null),l(w,Dc),l(w,Mo),l(w,Rc),l(w,jo),l(w,Xc),l(w,Pe),f(ka,Pe,null),l(Pe,Hc),l(Pe,_o),l(Pe,Fc),f(Lt,Pe,null),l(w,zc),l(w,Oe),f(qa,Oe,null),l(Oe,Lc),l(Oe,To),l(Oe,Pc),f(Pt,Oe,null),l(w,Oc),l(w,Ke),f(Ea,Ke,null),l(Ke,Kc),l(Ke,Io),l(Ke,ep),f(Ot,Ke,null),l(w,np),l(w,en),f(Aa,en,null),l(en,tp),l(en,xo),l(en,sp),f(Kt,en,null),l(w,ap),l(w,ae),f(Za,ae,null),l(ae,lp),l(ae,Jo),l(ae,op),f(es,ae,null),l(ae,rp),f(ns,ae,null),l(w,ip),l(w,nn),f(Wa,nn,null),l(nn,cp),l(nn,wo),l(nn,pp),f(ts,nn,null),l(w,up),l(w,tn),f(Na,tn,null),l(tn,gp),l(tn,Co),l(tn,mp),f(ss,tn,null),l(w,hp),l(w,sn),f(Ga,sn,null),l(sn,dp),l(sn,Uo),l(sn,fp),f(as,sn,null),l(w,yp),l(w,le),f(Ba,le,null),l(le,bp),l(le,$o),l(le,Mp),l(le,vo),l(le,jp),f(ls,le,null),l(w,_p),l(w,oe),f(Va,oe,null),l(oe,Tp),l(oe,ko),l(oe,Ip),f(os,oe,null),l(oe,xp),f(rs,oe,null),l(w,Jp),l(w,is),f(Qa,is,null),l(is,wp),l(is,qo),l(w,Cp),l(w,re),f(Ya,re,null),l(re,Up),l(re,Eo),l(re,$p),l(re,Ao),l(re,vp),f(cs,re,null),l(w,kp),l(w,an),f(Sa,an,null),l(an,qp),l(an,Zo),l(an,Ep),f(ps,an,null),l(w,Ap),l(w,ie),f(Da,ie,null),l(ie,Zp),l(ie,Wo),l(ie,Wp),f(us,ie,null),l(ie,Np),f(gs,ie,null),l(w,Gp),l(w,ce),f(Ra,ce,null),l(ce,Bp),l(ce,No),l(ce,Vp),f(ms,ce,null),l(ce,Qp),f(hs,ce,null),l(w,Yp),l(w,pe),f(Xa,pe,null),l(pe,Sp),l(pe,Go),l(pe,Dp),l(pe,Bo),l(pe,Rp),f(ds,pe,null),l(w,Xp),l(w,N),f(Ha,N,null),l(N,Hp),l(N,Vo),l(N,Fp),l(N,Qo),l(N,zp),f(fs,N,null),l(N,Lp),f(ys,N,null),l(N,Pp),f(bs,N,null),l(w,Op),l(w,ue),f(Fa,ue,null),l(ue,Kp),l(ue,Yo),l(ue,eu),f(Ms,ue,null),l(ue,nu),f(js,ue,null),l(w,tu),l(w,_s),f(za,_s,null),l(_s,su),l(_s,So),l(w,au),l(w,ln),f(La,ln,null),l(ln,lu),l(ln,Do),l(ln,ou),f(Ts,ln,null),l(w,ru),l(w,on),f(Pa,on,null),l(on,iu),l(on,Ro),l(on,cu),f(Is,on,null),l(w,pu),l(w,rn),f(Oa,rn,null),l(rn,uu),l(rn,Xo),l(rn,gu),f(xs,rn,null),l(w,mu),l(w,cn),f(Ka,cn,null),l(cn,hu),l(cn,Ho),l(cn,du),f(Js,cn,null),l(w,fu),l(w,pn),f(el,pn,null),l(pn,yu),l(pn,Fo),l(pn,bu),f(ws,pn,null),l(w,Mu),l(w,un),f(nl,un,null),l(un,ju),l(un,zo),l(un,_u),f(Cs,un,null),l(w,Tu),l(w,gn),f(tl,gn,null),l(gn,Iu),l(gn,Lo),l(gn,xu),f(Us,gn,null),l(w,Ju),l(w,G),f(sl,G,null),l(G,wu),l(G,Po),l(G,Cu),l(G,Oo),l(G,Uu),l(G,Ko),l(G,$u),f($s,G,null),l(G,vu),f(vs,G,null),l(w,ku),l(w,ge),f(al,ge,null),l(ge,qu),l(ge,er),l(ge,Eu),f(ks,ge,null),l(ge,Au),f(qs,ge,null),l(w,Zu),l(w,mn),f(ll,mn,null),l(mn,Wu),l(mn,nr),l(mn,Nu),f(Es,mn,null),l(w,Gu),l(w,hn),f(ol,hn,null),l(hn,Bu),l(hn,tr),l(hn,Vu),f(As,hn,null),l(w,Qu),l(w,R),f(rl,R,null),l(R,Yu),l(R,sr),l(R,Su),l(R,ar),l(R,Du),f(Zs,R,null),l(R,Ru),f(Ws,R,null),l(w,Xu),l(w,dn),f(il,dn,null),l(dn,Hu),l(dn,lr),l(dn,Fu),f(Ns,dn,null),l(w,zu),l(w,fn),f(cl,fn,null),l(fn,Lu),l(fn,or),l(fn,Pu),f(Gs,fn,null),l(w,Ou),l(w,yn),f(pl,yn,null),l(yn,Ku),l(yn,rr),l(yn,eg),f(Bs,yn,null),_(s,Ir,j),f(ul,s,j),_(s,xr,j),_(s,bn,j),f(gl,bn,null),l(bn,ng),l(bn,ir),_(s,Jr,j),f(ml,s,j),_(s,wr,j),_(s,Mn,j),f(hl,Mn,null),l(Mn,tg),l(Mn,cr),_(s,Cr,j),f(dl,s,j),_(s,Ur,j),_(s,fl,j),_(s,$r,j),_(s,B,j),f(yl,B,null),l(B,sg),l(B,pr),l(B,ag),f(Vs,B,null),l(B,lg),l(B,Qs),f(bl,Qs,null),l(Qs,og),l(Qs,ur),l(B,rg),l(B,Ys),f(Ml,Ys,null),l(Ys,ig),l(Ys,gr),_(s,vr,j),f(jl,s,j),_(s,kr,j),_(s,hr,j),qr=!0},p(s,[j]){const C={};j&2&&(C.$$scope={dirty:j,ctx:s}),ot.$set(C);const jn={};j&2&&(jn.$$scope={dirty:j,ctx:s}),rt.$set(jn);const _n={};j&2&&(_n.$$scope={dirty:j,ctx:s}),it.$set(_n);const Tn={};j&2&&(Tn.$$scope={dirty:j,ctx:s}),ct.$set(Tn);const In={};j&2&&(In.$$scope={dirty:j,ctx:s}),pt.$set(In);const me={};j&2&&(me.$$scope={dirty:j,ctx:s}),ut.$set(me);const xn={};j&2&&(xn.$$scope={dirty:j,ctx:s}),gt.$set(xn);const Jn={};j&2&&(Jn.$$scope={dirty:j,ctx:s}),mt.$set(Jn);const wn={};j&2&&(wn.$$scope={dirty:j,ctx:s}),ht.$set(wn);const he={};j&2&&(he.$$scope={dirty:j,ctx:s}),dt.$set(he);const de={};j&2&&(de.$$scope={dirty:j,ctx:s}),ft.$set(de);const _l={};j&2&&(_l.$$scope={dirty:j,ctx:s}),yt.$set(_l);const fe={};j&2&&(fe.$$scope={dirty:j,ctx:s}),Mt.$set(fe);const Cn={};j&2&&(Cn.$$scope={dirty:j,ctx:s}),jt.$set(Cn);const ye={};j&2&&(ye.$$scope={dirty:j,ctx:s}),_t.$set(ye);const be={};j&2&&(be.$$scope={dirty:j,ctx:s}),Tt.$set(be);const Me={};j&2&&(Me.$$scope={dirty:j,ctx:s}),It.$set(Me);const V={};j&2&&(V.$$scope={dirty:j,ctx:s}),xt.$set(V);const je={};j&2&&(je.$$scope={dirty:j,ctx:s}),Jt.$set(je);const Tl={};j&2&&(Tl.$$scope={dirty:j,ctx:s}),wt.$set(Tl);const Un={};j&2&&(Un.$$scope={dirty:j,ctx:s}),Ct.$set(Un);const $n={};j&2&&($n.$$scope={dirty:j,ctx:s}),Ut.$set($n);const vn={};j&2&&(vn.$$scope={dirty:j,ctx:s}),$t.$set(vn);const kn={};j&2&&(kn.$$scope={dirty:j,ctx:s}),vt.$set(kn);const qn={};j&2&&(qn.$$scope={dirty:j,ctx:s}),qt.$set(qn);const En={};j&2&&(En.$$scope={dirty:j,ctx:s}),Et.$set(En);const An={};j&2&&(An.$$scope={dirty:j,ctx:s}),At.$set(An);const Q={};j&2&&(Q.$$scope={dirty:j,ctx:s}),Zt.$set(Q);const _e={};j&2&&(_e.$$scope={dirty:j,ctx:s}),Wt.$set(_e);const Zn={};j&2&&(Zn.$$scope={dirty:j,ctx:s}),Nt.$set(Zn);const Wn={};j&2&&(Wn.$$scope={dirty:j,ctx:s}),Gt.$set(Wn);const X={};j&2&&(X.$$scope={dirty:j,ctx:s}),Bt.$set(X);const Nn={};j&2&&(Nn.$$scope={dirty:j,ctx:s}),Vt.$set(Nn);const Gn={};j&2&&(Gn.$$scope={dirty:j,ctx:s}),Qt.$set(Gn);const Bn={};j&2&&(Bn.$$scope={dirty:j,ctx:s}),Yt.$set(Bn);const U={};j&2&&(U.$$scope={dirty:j,ctx:s}),St.$set(U);const Vn={};j&2&&(Vn.$$scope={dirty:j,ctx:s}),Dt.$set(Vn);const Qn={};j&2&&(Qn.$$scope={dirty:j,ctx:s}),Rt.$set(Qn);const Yn={};j&2&&(Yn.$$scope={dirty:j,ctx:s}),Xt.$set(Yn);const Sn={};j&2&&(Sn.$$scope={dirty:j,ctx:s}),Ht.$set(Sn);const Te={};j&2&&(Te.$$scope={dirty:j,ctx:s}),Ft.$set(Te);const Dn={};j&2&&(Dn.$$scope={dirty:j,ctx:s}),zt.$set(Dn);const Rn={};j&2&&(Rn.$$scope={dirty:j,ctx:s}),Lt.$set(Rn);const Xn={};j&2&&(Xn.$$scope={dirty:j,ctx:s}),Pt.$set(Xn);const Ie={};j&2&&(Ie.$$scope={dirty:j,ctx:s}),Ot.$set(Ie);const xe={};j&2&&(xe.$$scope={dirty:j,ctx:s}),Kt.$set(xe);const Il={};j&2&&(Il.$$scope={dirty:j,ctx:s}),es.$set(Il);const Je={};j&2&&(Je.$$scope={dirty:j,ctx:s}),ns.$set(Je);const Hn={};j&2&&(Hn.$$scope={dirty:j,ctx:s}),ts.$set(Hn);const we={};j&2&&(we.$$scope={dirty:j,ctx:s}),ss.$set(we);const Ce={};j&2&&(Ce.$$scope={dirty:j,ctx:s}),as.$set(Ce);const Ue={};j&2&&(Ue.$$scope={dirty:j,ctx:s}),ls.$set(Ue);const Y={};j&2&&(Y.$$scope={dirty:j,ctx:s}),os.$set(Y);const $e={};j&2&&($e.$$scope={dirty:j,ctx:s}),rs.$set($e);const xl={};j&2&&(xl.$$scope={dirty:j,ctx:s}),cs.$set(xl);const Fn={};j&2&&(Fn.$$scope={dirty:j,ctx:s}),ps.$set(Fn);const zn={};j&2&&(zn.$$scope={dirty:j,ctx:s}),us.$set(zn);const Ln={};j&2&&(Ln.$$scope={dirty:j,ctx:s}),gs.$set(Ln);const Pn={};j&2&&(Pn.$$scope={dirty:j,ctx:s}),ms.$set(Pn);const On={};j&2&&(On.$$scope={dirty:j,ctx:s}),hs.$set(On);const Kn={};j&2&&(Kn.$$scope={dirty:j,ctx:s}),ds.$set(Kn);const et={};j&2&&(et.$$scope={dirty:j,ctx:s}),fs.$set(et);const S={};j&2&&(S.$$scope={dirty:j,ctx:s}),ys.$set(S);const ve={};j&2&&(ve.$$scope={dirty:j,ctx:s}),bs.$set(ve);const nt={};j&2&&(nt.$$scope={dirty:j,ctx:s}),Ms.$set(nt);const tt={};j&2&&(tt.$$scope={dirty:j,ctx:s}),js.$set(tt);const H={};j&2&&(H.$$scope={dirty:j,ctx:s}),Ts.$set(H);const st={};j&2&&(st.$$scope={dirty:j,ctx:s}),Is.$set(st);const at={};j&2&&(at.$$scope={dirty:j,ctx:s}),xs.$set(at);const lt={};j&2&&(lt.$$scope={dirty:j,ctx:s}),Js.$set(lt);const Jl={};j&2&&(Jl.$$scope={dirty:j,ctx:s}),ws.$set(Jl);const wl={};j&2&&(wl.$$scope={dirty:j,ctx:s}),Cs.$set(wl);const F={};j&2&&(F.$$scope={dirty:j,ctx:s}),Us.$set(F);const Cl={};j&2&&(Cl.$$scope={dirty:j,ctx:s}),$s.$set(Cl);const Ul={};j&2&&(Ul.$$scope={dirty:j,ctx:s}),vs.$set(Ul);const Pm={};j&2&&(Pm.$$scope={dirty:j,ctx:s}),ks.$set(Pm);const Om={};j&2&&(Om.$$scope={dirty:j,ctx:s}),qs.$set(Om);const Km={};j&2&&(Km.$$scope={dirty:j,ctx:s}),Es.$set(Km);const eh={};j&2&&(eh.$$scope={dirty:j,ctx:s}),As.$set(eh);const nh={};j&2&&(nh.$$scope={dirty:j,ctx:s}),Zs.$set(nh);const th={};j&2&&(th.$$scope={dirty:j,ctx:s}),Ws.$set(th);const sh={};j&2&&(sh.$$scope={dirty:j,ctx:s}),Ns.$set(sh);const ah={};j&2&&(ah.$$scope={dirty:j,ctx:s}),Gs.$set(ah);const lh={};j&2&&(lh.$$scope={dirty:j,ctx:s}),Bs.$set(lh);const oh={};j&2&&(oh.$$scope={dirty:j,ctx:s}),Vs.$set(oh)},i(s){qr||(y(o.$$.fragment,s),y(Rs.$$.fragment,s),y(Xs.$$.fragment,s),y(Hs.$$.fragment,s),y(ot.$$.fragment,s),y(Fs.$$.fragment,s),y(rt.$$.fragment,s),y(zs.$$.fragment,s),y(it.$$.fragment,s),y(Ls.$$.fragment,s),y(ct.$$.fragment,s),y(Ps.$$.fragment,s),y(pt.$$.fragment,s),y(ut.$$.fragment,s),y(Os.$$.fragment,s),y(gt.$$.fragment,s),y(Ks.$$.fragment,s),y(mt.$$.fragment,s),y(ea.$$.fragment,s),y(ht.$$.fragment,s),y(na.$$.fragment,s),y(dt.$$.fragment,s),y(ta.$$.fragment,s),y(ft.$$.fragment,s),y(yt.$$.fragment,s),y(sa.$$.fragment,s),y(aa.$$.fragment,s),y(Mt.$$.fragment,s),y(la.$$.fragment,s),y(jt.$$.fragment,s),y(oa.$$.fragment,s),y(_t.$$.fragment,s),y(Tt.$$.fragment,s),y(ra.$$.fragment,s),y(It.$$.fragment,s),y(xt.$$.fragment,s),y(ia.$$.fragment,s),y(Jt.$$.fragment,s),y(ca.$$.fragment,s),y(wt.$$.fragment,s),y(Ct.$$.fragment,s),y(Ut.$$.fragment,s),y(pa.$$.fragment,s),y($t.$$.fragment,s),y(vt.$$.fragment,s),y(ua.$$.fragment,s),y(ga.$$.fragment,s),y(qt.$$.fragment,s),y(ma.$$.fragment,s),y(Et.$$.fragment,s),y(ha.$$.fragment,s),y(At.$$.fragment,s),y(da.$$.fragment,s),y(Zt.$$.fragment,s),y(fa.$$.fragment,s),y(Wt.$$.fragment,s),y(ya.$$.fragment,s),y(Nt.$$.fragment,s),y(ba.$$.fragment,s),y(Gt.$$.fragment,s),y(Ma.$$.fragment,s),y(Bt.$$.fragment,s),y(Vt.$$.fragment,s),y(ja.$$.fragment,s),y(Qt.$$.fragment,s),y(Yt.$$.fragment,s),y(_a.$$.fragment,s),y(St.$$.fragment,s),y(Ta.$$.fragment,s),y(Dt.$$.fragment,s),y(Ia.$$.fragment,s),y(Rt.$$.fragment,s),y(Xt.$$.fragment,s),y(xa.$$.fragment,s),y(Ht.$$.fragment,s),y(Ja.$$.fragment,s),y(Ft.$$.fragment,s),y(wa.$$.fragment,s),y(zt.$$.fragment,s),y(Ca.$$.fragment,s),y($a.$$.fragment,s),y(va.$$.fragment,s),y(ka.$$.fragment,s),y(Lt.$$.fragment,s),y(qa.$$.fragment,s),y(Pt.$$.fragment,s),y(Ea.$$.fragment,s),y(Ot.$$.fragment,s),y(Aa.$$.fragment,s),y(Kt.$$.fragment,s),y(Za.$$.fragment,s),y(es.$$.fragment,s),y(ns.$$.fragment,s),y(Wa.$$.fragment,s),y(ts.$$.fragment,s),y(Na.$$.fragment,s),y(ss.$$.fragment,s),y(Ga.$$.fragment,s),y(as.$$.fragment,s),y(Ba.$$.fragment,s),y(ls.$$.fragment,s),y(Va.$$.fragment,s),y(os.$$.fragment,s),y(rs.$$.fragment,s),y(Qa.$$.fragment,s),y(Ya.$$.fragment,s),y(cs.$$.fragment,s),y(Sa.$$.fragment,s),y(ps.$$.fragment,s),y(Da.$$.fragment,s),y(us.$$.fragment,s),y(gs.$$.fragment,s),y(Ra.$$.fragment,s),y(ms.$$.fragment,s),y(hs.$$.fragment,s),y(Xa.$$.fragment,s),y(ds.$$.fragment,s),y(Ha.$$.fragment,s),y(fs.$$.fragment,s),y(ys.$$.fragment,s),y(bs.$$.fragment,s),y(Fa.$$.fragment,s),y(Ms.$$.fragment,s),y(js.$$.fragment,s),y(za.$$.fragment,s),y(La.$$.fragment,s),y(Ts.$$.fragment,s),y(Pa.$$.fragment,s),y(Is.$$.fragment,s),y(Oa.$$.fragment,s),y(xs.$$.fragment,s),y(Ka.$$.fragment,s),y(Js.$$.fragment,s),y(el.$$.fragment,s),y(ws.$$.fragment,s),y(nl.$$.fragment,s),y(Cs.$$.fragment,s),y(tl.$$.fragment,s),y(Us.$$.fragment,s),y(sl.$$.fragment,s),y($s.$$.fragment,s),y(vs.$$.fragment,s),y(al.$$.fragment,s),y(ks.$$.fragment,s),y(qs.$$.fragment,s),y(ll.$$.fragment,s),y(Es.$$.fragment,s),y(ol.$$.fragment,s),y(As.$$.fragment,s),y(rl.$$.fragment,s),y(Zs.$$.fragment,s),y(Ws.$$.fragment,s),y(il.$$.fragment,s),y(Ns.$$.fragment,s),y(cl.$$.fragment,s),y(Gs.$$.fragment,s),y(pl.$$.fragment,s),y(Bs.$$.fragment,s),y(ul.$$.fragment,s),y(gl.$$.fragment,s),y(ml.$$.fragment,s),y(hl.$$.fragment,s),y(dl.$$.fragment,s),y(yl.$$.fragment,s),y(Vs.$$.fragment,s),y(bl.$$.fragment,s),y(Ml.$$.fragment,s),y(jl.$$.fragment,s),qr=!0)},o(s){b(o.$$.fragment,s),b(Rs.$$.fragment,s),b(Xs.$$.fragment,s),b(Hs.$$.fragment,s),b(ot.$$.fragment,s),b(Fs.$$.fragment,s),b(rt.$$.fragment,s),b(zs.$$.fragment,s),b(it.$$.fragment,s),b(Ls.$$.fragment,s),b(ct.$$.fragment,s),b(Ps.$$.fragment,s),b(pt.$$.fragment,s),b(ut.$$.fragment,s),b(Os.$$.fragment,s),b(gt.$$.fragment,s),b(Ks.$$.fragment,s),b(mt.$$.fragment,s),b(ea.$$.fragment,s),b(ht.$$.fragment,s),b(na.$$.fragment,s),b(dt.$$.fragment,s),b(ta.$$.fragment,s),b(ft.$$.fragment,s),b(yt.$$.fragment,s),b(sa.$$.fragment,s),b(aa.$$.fragment,s),b(Mt.$$.fragment,s),b(la.$$.fragment,s),b(jt.$$.fragment,s),b(oa.$$.fragment,s),b(_t.$$.fragment,s),b(Tt.$$.fragment,s),b(ra.$$.fragment,s),b(It.$$.fragment,s),b(xt.$$.fragment,s),b(ia.$$.fragment,s),b(Jt.$$.fragment,s),b(ca.$$.fragment,s),b(wt.$$.fragment,s),b(Ct.$$.fragment,s),b(Ut.$$.fragment,s),b(pa.$$.fragment,s),b($t.$$.fragment,s),b(vt.$$.fragment,s),b(ua.$$.fragment,s),b(ga.$$.fragment,s),b(qt.$$.fragment,s),b(ma.$$.fragment,s),b(Et.$$.fragment,s),b(ha.$$.fragment,s),b(At.$$.fragment,s),b(da.$$.fragment,s),b(Zt.$$.fragment,s),b(fa.$$.fragment,s),b(Wt.$$.fragment,s),b(ya.$$.fragment,s),b(Nt.$$.fragment,s),b(ba.$$.fragment,s),b(Gt.$$.fragment,s),b(Ma.$$.fragment,s),b(Bt.$$.fragment,s),b(Vt.$$.fragment,s),b(ja.$$.fragment,s),b(Qt.$$.fragment,s),b(Yt.$$.fragment,s),b(_a.$$.fragment,s),b(St.$$.fragment,s),b(Ta.$$.fragment,s),b(Dt.$$.fragment,s),b(Ia.$$.fragment,s),b(Rt.$$.fragment,s),b(Xt.$$.fragment,s),b(xa.$$.fragment,s),b(Ht.$$.fragment,s),b(Ja.$$.fragment,s),b(Ft.$$.fragment,s),b(wa.$$.fragment,s),b(zt.$$.fragment,s),b(Ca.$$.fragment,s),b($a.$$.fragment,s),b(va.$$.fragment,s),b(ka.$$.fragment,s),b(Lt.$$.fragment,s),b(qa.$$.fragment,s),b(Pt.$$.fragment,s),b(Ea.$$.fragment,s),b(Ot.$$.fragment,s),b(Aa.$$.fragment,s),b(Kt.$$.fragment,s),b(Za.$$.fragment,s),b(es.$$.fragment,s),b(ns.$$.fragment,s),b(Wa.$$.fragment,s),b(ts.$$.fragment,s),b(Na.$$.fragment,s),b(ss.$$.fragment,s),b(Ga.$$.fragment,s),b(as.$$.fragment,s),b(Ba.$$.fragment,s),b(ls.$$.fragment,s),b(Va.$$.fragment,s),b(os.$$.fragment,s),b(rs.$$.fragment,s),b(Qa.$$.fragment,s),b(Ya.$$.fragment,s),b(cs.$$.fragment,s),b(Sa.$$.fragment,s),b(ps.$$.fragment,s),b(Da.$$.fragment,s),b(us.$$.fragment,s),b(gs.$$.fragment,s),b(Ra.$$.fragment,s),b(ms.$$.fragment,s),b(hs.$$.fragment,s),b(Xa.$$.fragment,s),b(ds.$$.fragment,s),b(Ha.$$.fragment,s),b(fs.$$.fragment,s),b(ys.$$.fragment,s),b(bs.$$.fragment,s),b(Fa.$$.fragment,s),b(Ms.$$.fragment,s),b(js.$$.fragment,s),b(za.$$.fragment,s),b(La.$$.fragment,s),b(Ts.$$.fragment,s),b(Pa.$$.fragment,s),b(Is.$$.fragment,s),b(Oa.$$.fragment,s),b(xs.$$.fragment,s),b(Ka.$$.fragment,s),b(Js.$$.fragment,s),b(el.$$.fragment,s),b(ws.$$.fragment,s),b(nl.$$.fragment,s),b(Cs.$$.fragment,s),b(tl.$$.fragment,s),b(Us.$$.fragment,s),b(sl.$$.fragment,s),b($s.$$.fragment,s),b(vs.$$.fragment,s),b(al.$$.fragment,s),b(ks.$$.fragment,s),b(qs.$$.fragment,s),b(ll.$$.fragment,s),b(Es.$$.fragment,s),b(ol.$$.fragment,s),b(As.$$.fragment,s),b(rl.$$.fragment,s),b(Zs.$$.fragment,s),b(Ws.$$.fragment,s),b(il.$$.fragment,s),b(Ns.$$.fragment,s),b(cl.$$.fragment,s),b(Gs.$$.fragment,s),b(pl.$$.fragment,s),b(Bs.$$.fragment,s),b(ul.$$.fragment,s),b(gl.$$.fragment,s),b(ml.$$.fragment,s),b(hl.$$.fragment,s),b(dl.$$.fragment,s),b(yl.$$.fragment,s),b(Vs.$$.fragment,s),b(bl.$$.fragment,s),b(Ml.$$.fragment,s),b(jl.$$.fragment,s),qr=!1},d(s){s&&(p(u),p(a),p(t),p(e),p(c),p(dr),p(Ss),p(fr),p(Ds),p(yr),p(br),p(J),p(Mr),p(jr),p(Ua),p(_r),p(Tr),p(w),p(Ir),p(xr),p(bn),p(Jr),p(wr),p(Mn),p(Cr),p(Ur),p(fl),p($r),p(B),p(vr),p(kr),p(hr)),p(n),M(o,s),M(Rs,s),M(Xs),M(Hs),M(ot),M(Fs),M(rt),M(zs),M(it),M(Ls),M(ct),M(Ps),M(pt),M(ut),M(Os),M(gt),M(Ks),M(mt),M(ea),M(ht),M(na),M(dt),M(ta),M(ft),M(yt),M(sa),M(aa),M(Mt),M(la),M(jt),M(oa),M(_t),M(Tt),M(ra),M(It),M(xt),M(ia),M(Jt),M(ca),M(wt),M(Ct),M(Ut),M(pa),M($t),M(vt),M(ua),M(ga),M(qt),M(ma),M(Et),M(ha),M(At),M(da),M(Zt),M(fa),M(Wt),M(ya),M(Nt),M(ba),M(Gt),M(Ma),M(Bt),M(Vt),M(ja),M(Qt),M(Yt),M(_a),M(St),M(Ta),M(Dt),M(Ia),M(Rt),M(Xt),M(xa),M(Ht),M(Ja),M(Ft),M(wa),M(zt),M(Ca,s),M($a,s),M(va),M(ka),M(Lt),M(qa),M(Pt),M(Ea),M(Ot),M(Aa),M(Kt),M(Za),M(es),M(ns),M(Wa),M(ts),M(Na),M(ss),M(Ga),M(as),M(Ba),M(ls),M(Va),M(os),M(rs),M(Qa),M(Ya),M(cs),M(Sa),M(ps),M(Da),M(us),M(gs),M(Ra),M(ms),M(hs),M(Xa),M(ds),M(Ha),M(fs),M(ys),M(bs),M(Fa),M(Ms),M(js),M(za),M(La),M(Ts),M(Pa),M(Is),M(Oa),M(xs),M(Ka),M(Js),M(el),M(ws),M(nl),M(Cs),M(tl),M(Us),M(sl),M($s),M(vs),M(al),M(ks),M(qs),M(ll),M(Es),M(ol),M(As),M(rl),M(Zs),M(Ws),M(il),M(Ns),M(cl),M(Gs),M(pl),M(Bs),M(ul,s),M(gl),M(ml,s),M(hl),M(dl,s),M(yl),M(Vs),M(bl),M(Ml),M(jl,s)}}}const Rd='{"title":"Inference","local":"inference","sections":[{"title":"Inference Client","local":"huggingface_hub.InferenceClient","sections":[],"depth":2},{"title":"Async Inference Client","local":"huggingface_hub.AsyncInferenceClient","sections":[],"depth":2},{"title":"InferenceTimeoutError","local":"huggingface_hub.InferenceTimeoutError","sections":[{"title":"ModelStatus","local":"huggingface_hub.inference._common.ModelStatus","sections":[],"depth":3}],"depth":2},{"title":"InferenceAPI","local":"huggingface_hub.InferenceApi","sections":[],"depth":2}],"depth":1}';function Xd(I){return ih(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ef extends ch{constructor(n){super(),ph(this,n,Xd,Dd,rh,{})}}export{ef as component};
