import{s as Is,f as Ds,o as xs,n as cs}from"../chunks/scheduler.25b97de1.js";import{S as zs,i as Os,g as c,s as o,r as p,A as $s,h as i,f as t,c as a,j as de,u,x as T,k as D,y as d,a as n,v as h,d as b,t as f,w as g}from"../chunks/index.d9030fc9.js";import{T as Ns}from"../chunks/Tip.baa67368.js";import{D as je}from"../chunks/Docstring.ffac8efa.js";import{C as Xe}from"../chunks/CodeBlock.e6cd0d95.js";import{E as ks}from"../chunks/ExampleCodeBlock.22dfe688.js";import{H as x,E as Vs}from"../chunks/EditOnGithub.91d95064.js";function Rs(z){let l,w="Examples:",_,m,y;return m=new Xe({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyME9tRGV0VHVyYm9Db25maWclMkMlMjBPbURldFR1cmJvRm9yT2JqZWN0RGV0ZWN0aW9uJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyME9tRGV0LVR1cmJvJTIwb21sYWIlMkZvbWRldC10dXJiby1zd2luLXRpbnktaGYlMjBzdHlsZSUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwT21EZXRUdXJib0NvbmZpZygpJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyMG1vZGVsJTIwKHdpdGglMjByYW5kb20lMjB3ZWlnaHRzKSUyMGZyb20lMjB0aGUlMjBvbWxhYiUyRm9tZGV0LXR1cmJvLXN3aW4tdGlueS1oZiUyMHN0eWxlJTIwY29uZmlndXJhdGlvbiUwQW1vZGVsJTIwJTNEJTIwT21EZXRUdXJib0Zvck9iamVjdERldGVjdGlvbihjb25maWd1cmF0aW9uKSUwQSUwQSUyMyUyMEFjY2Vzc2luZyUyMHRoZSUyMG1vZGVsJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBtb2RlbC5jb25maWc=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> OmDetTurboConfig, OmDetTurboForObjectDetection

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a OmDet-Turbo omlab/omdet-turbo-swin-tiny-hf style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = OmDetTurboConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model (with random weights) from the omlab/omdet-turbo-swin-tiny-hf style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = OmDetTurboForObjectDetection(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){l=c("p"),l.textContent=w,_=o(),p(m.$$.fragment)},l(r){l=i(r,"P",{"data-svelte-h":!0}),T(l)!=="svelte-kvfsh7"&&(l.textContent=w),_=a(r),u(m.$$.fragment,r)},m(r,j){n(r,l,j),n(r,_,j),h(m,r,j),y=!0},p:cs,i(r){y||(b(m.$$.fragment,r),y=!0)},o(r){f(m.$$.fragment,r),y=!1},d(r){r&&(t(l),t(_)),g(m,r)}}}function Zs(z){let l,w=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){l=c("p"),l.innerHTML=w},l(_){l=i(_,"P",{"data-svelte-h":!0}),T(l)!=="svelte-fincs2"&&(l.innerHTML=w)},m(_,m){n(_,l,m)},p:cs,d(_){_&&t(l)}}}function Bs(z){let l,w="Examples:",_,m,y;return m=new Xe({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, OmDetTurboForObjectDetection

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;omlab/omdet-turbo-swin-tiny-hf&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = OmDetTurboForObjectDetection.from_pretrained(<span class="hljs-string">&quot;omlab/omdet-turbo-swin-tiny-hf&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)
<span class="hljs-meta">&gt;&gt;&gt; </span>classes = [<span class="hljs-string">&quot;cat&quot;</span>, <span class="hljs-string">&quot;remote&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>task = <span class="hljs-string">&quot;Detect {}.&quot;</span>.<span class="hljs-built_in">format</span>(<span class="hljs-string">&quot;, &quot;</span>.join(classes))
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(image, text=classes, task=task, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># convert outputs (bounding boxes and class logits)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>results = processor.post_process_grounded_object_detection(
<span class="hljs-meta">... </span>    outputs,
<span class="hljs-meta">... </span>    classes=classes,
<span class="hljs-meta">... </span>    target_sizes=[image.size[::-<span class="hljs-number">1</span>]],
<span class="hljs-meta">... </span>    score_threshold=<span class="hljs-number">0.3</span>,
<span class="hljs-meta">... </span>    nms_threshold=<span class="hljs-number">0.3</span>,
<span class="hljs-meta">&gt;&gt;&gt; </span>)[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> score, class_name, box <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(results[<span class="hljs-string">&quot;scores&quot;</span>], results[<span class="hljs-string">&quot;classes&quot;</span>], results[<span class="hljs-string">&quot;boxes&quot;</span>]):
<span class="hljs-meta">... </span>    box = [<span class="hljs-built_in">round</span>(i, <span class="hljs-number">1</span>) <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> box.tolist()]
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(
<span class="hljs-meta">... </span>        <span class="hljs-string">f&quot;Detected <span class="hljs-subst">{class_name}</span> with confidence &quot;</span>
<span class="hljs-meta">... </span>        <span class="hljs-string">f&quot;<span class="hljs-subst">{<span class="hljs-built_in">round</span>(score.item(), <span class="hljs-number">2</span>)}</span> at location <span class="hljs-subst">{box}</span>&quot;</span>
<span class="hljs-meta">... </span>    )
Detected remote <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.76</span> at location [<span class="hljs-number">39.9</span>, <span class="hljs-number">71.3</span>, <span class="hljs-number">176.5</span>, <span class="hljs-number">117.9</span>]
Detected cat <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.72</span> at location [<span class="hljs-number">345.1</span>, <span class="hljs-number">22.5</span>, <span class="hljs-number">639.7</span>, <span class="hljs-number">371.9</span>]
Detected cat <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.65</span> at location [<span class="hljs-number">12.7</span>, <span class="hljs-number">53.8</span>, <span class="hljs-number">315.5</span>, <span class="hljs-number">475.3</span>]
Detected remote <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.57</span> at location [<span class="hljs-number">333.4</span>, <span class="hljs-number">75.6</span>, <span class="hljs-number">370.7</span>, <span class="hljs-number">187.0</span>]`,wrap:!1}}),{c(){l=c("p"),l.textContent=w,_=o(),p(m.$$.fragment)},l(r){l=i(r,"P",{"data-svelte-h":!0}),T(l)!=="svelte-kvfsh7"&&(l.textContent=w),_=a(r),u(m.$$.fragment,r)},m(r,j){n(r,l,j),n(r,_,j),h(m,r,j),y=!0},p:cs,i(r){y||(b(m.$$.fragment,r),y=!0)},o(r){f(m.$$.fragment,r),y=!1},d(r){r&&(t(l),t(_)),g(m,r)}}}function Es(z){let l,w,_,m,y,r,j,Me,B,is='The OmDet-Turbo model was proposed in <a href="https://arxiv.org/abs/2403.06892" rel="nofollow">Real-time Transformer-based Open-Vocabulary Detection with Efficient Fusion Head</a> by Tiancheng Zhao, Peng Liu, Xuan He, Lu Zhang, Kyusong Lee. OmDet-Turbo incorporates components from RT-DETR and introduces a swift multimodal fusion module to achieve real-time open-vocabulary object detection capabilities while maintaining high accuracy. The base model achieves performance of up to 100.2 FPS and 53.4 AP on COCO zero-shot.',we,E,ds="The abstract from the paper is the following:",Je,q,ms="<em>End-to-end transformer-based detectors (DETRs) have shown exceptional performance in both closed-set and open-vocabulary object detection (OVD) tasks through the integration of language modalities. However, their demanding computational requirements have hindered their practical application in real-time object detection (OD) scenarios. In this paper, we scrutinize the limitations of two leading models in the OVDEval benchmark, OmDet and Grounding-DINO, and introduce OmDet-Turbo. This novel transformer-based real-time OVD model features an innovative Efficient Fusion Head (EFH) module designed to alleviate the bottlenecks observed in OmDet and Grounding-DINO. Notably, OmDet-Turbo-Base achieves a 100.2 frames per second (FPS) with TensorRT and language cache techniques applied. Notably, in zero-shot scenarios on COCO and LVIS datasets, OmDet-Turbo achieves performance levels nearly on par with current state-of-the-art supervised models. Furthermore, it establishes new state-of-the-art benchmarks on ODinW and OVDEval, boasting an AP of 30.1 and an NMS-AP of 26.86, respectively. The practicality of OmDet-Turbo in industrial applications is underscored by its exceptional performance on benchmark datasets and superior inference speed, positioning it as a compelling choice for real-time object detection tasks.</em>",Ue,O,ps,ve,G,us='OmDet-Turbo architecture overview. Taken from the <a href="https://arxiv.org/abs/2403.06892">original paper</a>.',Ce,W,hs=`This model was contributed by <a href="https://huggingface.co/yonigozlan" rel="nofollow">yonigozlan</a>.
The original code can be found <a href="https://github.com/om-ai-lab/OmDet" rel="nofollow">here</a>.`,ke,F,Ie,H,bs='One unique property of OmDet-Turbo compared to other zero-shot object detection models, such as <a href="grounding-dino">Grounding DINO</a>, is the decoupled classes and prompt embedding structure that allows caching of text embeddings. This means that the model needs both classes and task as inputs, where classes is a list of objects we want to detect and task is the grounded text used to guide open-vocabulary detection. This approach limits the scope of the open-vocabulary detection and makes the decoding process faster.',De,Q,fs='<a href="/docs/transformers/pr_22105/en/model_doc/omdet-turbo#transformers.OmDetTurboProcessor">OmDetTurboProcessor</a> is used to prepare the classes, task and image triplet. The task input is optional, and when not provided, it will default to <code>&quot;Detect [class1], [class2], [class3], ...&quot;</code>. To process the results from the model, one can use <code>post_process_grounded_object_detection</code> from <a href="/docs/transformers/pr_22105/en/model_doc/omdet-turbo#transformers.OmDetTurboProcessor">OmDetTurboProcessor</a>. Notably, this function takes in the input classes, as unlike other zero-shot object detection models, the decoupling of classes and task embeddings means that no decoding of the predicted class embeddings is needed in the post-processing step, and the predicted classes can be matched to the inputted ones directly.',xe,X,ze,Y,Oe,S,gs="Here’s how to load the model and prepare the inputs to perform zero-shot object detection on a single image:",$e,A,Ne,P,Ve,L,_s="OmDet-Turbo can perform batched multi-image inference, with support for different text prompts and classes in the same batch:",Re,K,Ze,ee,Be,J,se,Ye,me,Ts=`This is the configuration class to store the configuration of a <a href="/docs/transformers/pr_22105/en/model_doc/omdet-turbo#transformers.OmDetTurboForObjectDetection">OmDetTurboForObjectDetection</a>.
It is used to instantiate a OmDet-Turbo model according to the specified arguments, defining the model architecture
Instantiating a configuration with the defaults will yield a similar configuration to that of the OmDet-Turbo
<a href="https://huggingface.co/omlab/omdet-turbo-swin-tiny-hf" rel="nofollow">omlab/omdet-turbo-swin-tiny-hf</a> architecture.`,Se,pe,ys=`Configuration objects inherit from <a href="/docs/transformers/pr_22105/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/pr_22105/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,Ae,$,Ee,te,qe,U,ne,Pe,ue,js=`Constructs a OmDet-Turbo processor which wraps a Deformable DETR image processor and an AutoTokenizer into a
single processor.`,Le,he,Ms=`<a href="/docs/transformers/pr_22105/en/model_doc/omdet-turbo#transformers.OmDetTurboProcessor">OmDetTurboProcessor</a> offers all the functionalities of <a href="/docs/transformers/pr_22105/en/model_doc/detr#transformers.DetrImageProcessor">DetrImageProcessor</a> and
<a href="/docs/transformers/pr_22105/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See the docstring of <code>__call__()</code> and <code>decode()</code>
for more information.`,Ke,N,oe,es,be,ws=`Converts the raw output of <a href="/docs/transformers/pr_22105/en/model_doc/omdet-turbo#transformers.OmDetTurboForObjectDetection">OmDetTurboForObjectDetection</a> into final bounding boxes in (top_left_x, top_left_y,
bottom_right_x, bottom_right_y) format and get the associated text class.`,Ge,ae,We,M,re,ss,fe,Js=`OmDetTurbo Model (consisting of a vision and a text backbone, and encoder-decoder architecture) outputting
bounding boxes and classes scores for tasks such as COCO detection.`,ts,ge,Us=`This model inherits from <a href="/docs/transformers/pr_22105/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,ns,_e,vs=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,os,v,le,as,Te,Cs='The <a href="/docs/transformers/pr_22105/en/model_doc/omdet-turbo#transformers.OmDetTurboForObjectDetection">OmDetTurboForObjectDetection</a> forward method, overrides the <code>__call__</code> special method.',rs,V,ls,R,Fe,ce,He,ye,Qe;return y=new x({props:{title:"OmDet-Turbo",local:"omdet-turbo",headingTag:"h1"}}),j=new x({props:{title:"Overview",local:"overview",headingTag:"h2"}}),F=new x({props:{title:"Usage tips",local:"usage-tips",headingTag:"h2"}}),X=new x({props:{title:"Usage example",local:"usage-example",headingTag:"h2"}}),Y=new x({props:{title:"Single image inference",local:"single-image-inference",headingTag:"h3"}}),A=new Xe({props:{code:"aW1wb3J0JTIwcmVxdWVzdHMlMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEElMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Byb2Nlc3NvciUyQyUyME9tRGV0VHVyYm9Gb3JPYmplY3REZXRlY3Rpb24lMEElMEFwcm9jZXNzb3IlMjAlM0QlMjBBdXRvUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJvbWxhYiUyRm9tZGV0LXR1cmJvLXN3aW4tdGlueS1oZiUyMiklMEFtb2RlbCUyMCUzRCUyME9tRGV0VHVyYm9Gb3JPYmplY3REZXRlY3Rpb24uZnJvbV9wcmV0cmFpbmVkKCUyMm9tbGFiJTJGb21kZXQtdHVyYm8tc3dpbi10aW55LWhmJTIyKSUwQSUwQXVybCUyMCUzRCUyMCUyMmh0dHAlM0ElMkYlMkZpbWFnZXMuY29jb2RhdGFzZXQub3JnJTJGdmFsMjAxNyUyRjAwMDAwMDAzOTc2OS5qcGclMjIlMEFpbWFnZSUyMCUzRCUyMEltYWdlLm9wZW4ocmVxdWVzdHMuZ2V0KHVybCUyQyUyMHN0cmVhbSUzRFRydWUpLnJhdyklMEFjbGFzc2VzJTIwJTNEJTIwJTVCJTIyY2F0JTIyJTJDJTIwJTIycmVtb3RlJTIyJTVEJTBBaW5wdXRzJTIwJTNEJTIwcHJvY2Vzc29yKGltYWdlJTJDJTIwdGV4dCUzRGNsYXNzZXMlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyklMEElMEElMjMlMjBjb252ZXJ0JTIwb3V0cHV0cyUyMChib3VuZGluZyUyMGJveGVzJTIwYW5kJTIwY2xhc3MlMjBsb2dpdHMpJTBBcmVzdWx0cyUyMCUzRCUyMHByb2Nlc3Nvci5wb3N0X3Byb2Nlc3NfZ3JvdW5kZWRfb2JqZWN0X2RldGVjdGlvbiglMEElMjAlMjAlMjAlMjBvdXRwdXRzJTJDJTBBJTIwJTIwJTIwJTIwY2xhc3NlcyUzRGNsYXNzZXMlMkMlMEElMjAlMjAlMjAlMjB0YXJnZXRfc2l6ZXMlM0QlNUJpbWFnZS5zaXplJTVCJTNBJTNBLTElNUQlNUQlMkMlMEElMjAlMjAlMjAlMjBzY29yZV90aHJlc2hvbGQlM0QwLjMlMkMlMEElMjAlMjAlMjAlMjBubXNfdGhyZXNob2xkJTNEMC4zJTJDJTBBKSU1QjAlNUQlMEFmb3IlMjBzY29yZSUyQyUyMGNsYXNzX25hbWUlMkMlMjBib3glMjBpbiUyMHppcCglMEElMjAlMjAlMjAlMjByZXN1bHRzJTVCJTIyc2NvcmVzJTIyJTVEJTJDJTIwcmVzdWx0cyU1QiUyMmNsYXNzZXMlMjIlNUQlMkMlMjByZXN1bHRzJTVCJTIyYm94ZXMlMjIlNUQlMEEpJTNBJTBBJTIwJTIwJTIwJTIwYm94JTIwJTNEJTIwJTVCcm91bmQoaSUyQyUyMDEpJTIwZm9yJTIwaSUyMGluJTIwYm94LnRvbGlzdCgpJTVEJTBBJTIwJTIwJTIwJTIwcHJpbnQoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZiUyMkRldGVjdGVkJTIwJTdCY2xhc3NfbmFtZSU3RCUyMHdpdGglMjBjb25maWRlbmNlJTIwJTIyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZiUyMiU3QnJvdW5kKHNjb3JlLml0ZW0oKSUyQyUyMDIpJTdEJTIwYXQlMjBsb2NhdGlvbiUyMCU3QmJveCU3RCUyMiUwQSUyMCUyMCUyMCUyMCk=",highlighted:`<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image

<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, OmDetTurboForObjectDetection

processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;omlab/omdet-turbo-swin-tiny-hf&quot;</span>)
model = OmDetTurboForObjectDetection.from_pretrained(<span class="hljs-string">&quot;omlab/omdet-turbo-swin-tiny-hf&quot;</span>)

url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)
classes = [<span class="hljs-string">&quot;cat&quot;</span>, <span class="hljs-string">&quot;remote&quot;</span>]
inputs = processor(image, text=classes, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

outputs = model(**inputs)

<span class="hljs-comment"># convert outputs (bounding boxes and class logits)</span>
results = processor.post_process_grounded_object_detection(
    outputs,
    classes=classes,
    target_sizes=[image.size[::-<span class="hljs-number">1</span>]],
    score_threshold=<span class="hljs-number">0.3</span>,
    nms_threshold=<span class="hljs-number">0.3</span>,
)[<span class="hljs-number">0</span>]
<span class="hljs-keyword">for</span> score, class_name, box <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(
    results[<span class="hljs-string">&quot;scores&quot;</span>], results[<span class="hljs-string">&quot;classes&quot;</span>], results[<span class="hljs-string">&quot;boxes&quot;</span>]
):
    box = [<span class="hljs-built_in">round</span>(i, <span class="hljs-number">1</span>) <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> box.tolist()]
    <span class="hljs-built_in">print</span>(
        <span class="hljs-string">f&quot;Detected <span class="hljs-subst">{class_name}</span> with confidence &quot;</span>
        <span class="hljs-string">f&quot;<span class="hljs-subst">{<span class="hljs-built_in">round</span>(score.item(), <span class="hljs-number">2</span>)}</span> at location <span class="hljs-subst">{box}</span>&quot;</span>
    )`,wrap:!1}}),P=new x({props:{title:"Multi image inference",local:"multi-image-inference",headingTag:"h3"}}),K=new Xe({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> io <span class="hljs-keyword">import</span> BytesIO
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, OmDetTurboForObjectDetection

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;omlab/omdet-turbo-swin-tiny-hf&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = OmDetTurboForObjectDetection.from_pretrained(<span class="hljs-string">&quot;omlab/omdet-turbo-swin-tiny-hf&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>url1 = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image1 = Image.<span class="hljs-built_in">open</span>(BytesIO(requests.get(url1).content)).convert(<span class="hljs-string">&quot;RGB&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>classes1 = [<span class="hljs-string">&quot;cat&quot;</span>, <span class="hljs-string">&quot;remote&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>task1 = <span class="hljs-string">&quot;Detect {}.&quot;</span>.<span class="hljs-built_in">format</span>(<span class="hljs-string">&quot;, &quot;</span>.join(classes1))

<span class="hljs-meta">&gt;&gt;&gt; </span>url2 = <span class="hljs-string">&quot;http://images.cocodataset.org/train2017/000000257813.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image2 = Image.<span class="hljs-built_in">open</span>(BytesIO(requests.get(url2).content)).convert(<span class="hljs-string">&quot;RGB&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>classes2 = [<span class="hljs-string">&quot;boat&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>task2 = <span class="hljs-string">&quot;Detect everything that looks like a boat.&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>url3 = <span class="hljs-string">&quot;https://cdn.britannica.com/61/93061-050-99147DCE/Statue-of-Liberty-Island-New-York-Bay.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image3 = Image.<span class="hljs-built_in">open</span>(BytesIO(requests.get(url3).content)).convert(<span class="hljs-string">&quot;RGB&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>classes3 = [<span class="hljs-string">&quot;statue&quot;</span>, <span class="hljs-string">&quot;trees&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>task3 = <span class="hljs-string">&quot;Focus on the foreground, detect statue and trees.&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(
<span class="hljs-meta">... </span>    images=[image1, image2, image3],
<span class="hljs-meta">... </span>    text=[classes1, classes2, classes3],
<span class="hljs-meta">... </span>    task=[task1, task2, task3],
<span class="hljs-meta">... </span>    return_tensors=<span class="hljs-string">&quot;pt&quot;</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># convert outputs (bounding boxes and class logits)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>results = processor.post_process_grounded_object_detection(
<span class="hljs-meta">... </span>    outputs,
<span class="hljs-meta">... </span>    classes=[classes1, classes2, classes3],
<span class="hljs-meta">... </span>    target_sizes=[image1.size[::-<span class="hljs-number">1</span>], image2.size[::-<span class="hljs-number">1</span>], image3.size[::-<span class="hljs-number">1</span>]],
<span class="hljs-meta">... </span>    score_threshold=<span class="hljs-number">0.2</span>,
<span class="hljs-meta">... </span>    nms_threshold=<span class="hljs-number">0.3</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i, result <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(results):
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> score, class_name, box <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(
<span class="hljs-meta">... </span>        result[<span class="hljs-string">&quot;scores&quot;</span>], result[<span class="hljs-string">&quot;classes&quot;</span>], result[<span class="hljs-string">&quot;boxes&quot;</span>]
<span class="hljs-meta">... </span>    ):
<span class="hljs-meta">... </span>        box = [<span class="hljs-built_in">round</span>(i, <span class="hljs-number">1</span>) <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> box.tolist()]
<span class="hljs-meta">... </span>        <span class="hljs-built_in">print</span>(
<span class="hljs-meta">... </span>            <span class="hljs-string">f&quot;Detected <span class="hljs-subst">{class_name}</span> with confidence &quot;</span>
<span class="hljs-meta">... </span>            <span class="hljs-string">f&quot;<span class="hljs-subst">{<span class="hljs-built_in">round</span>(score.item(), <span class="hljs-number">2</span>)}</span> at location <span class="hljs-subst">{box}</span> in image <span class="hljs-subst">{i}</span>&quot;</span>
<span class="hljs-meta">... </span>        )
Detected remote <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.77</span> at location [<span class="hljs-number">39.9</span>, <span class="hljs-number">70.4</span>, <span class="hljs-number">176.7</span>, <span class="hljs-number">118.0</span>] <span class="hljs-keyword">in</span> image <span class="hljs-number">0</span>
Detected cat <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.72</span> at location [<span class="hljs-number">11.6</span>, <span class="hljs-number">54.2</span>, <span class="hljs-number">314.8</span>, <span class="hljs-number">474.0</span>] <span class="hljs-keyword">in</span> image <span class="hljs-number">0</span>
Detected remote <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.56</span> at location [<span class="hljs-number">333.4</span>, <span class="hljs-number">75.8</span>, <span class="hljs-number">370.7</span>, <span class="hljs-number">187.0</span>] <span class="hljs-keyword">in</span> image <span class="hljs-number">0</span>
Detected cat <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.55</span> at location [<span class="hljs-number">345.2</span>, <span class="hljs-number">24.0</span>, <span class="hljs-number">639.8</span>, <span class="hljs-number">371.7</span>] <span class="hljs-keyword">in</span> image <span class="hljs-number">0</span>
Detected boat <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.32</span> at location [<span class="hljs-number">146.9</span>, <span class="hljs-number">219.8</span>, <span class="hljs-number">209.6</span>, <span class="hljs-number">250.7</span>] <span class="hljs-keyword">in</span> image <span class="hljs-number">1</span>
Detected boat <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.3</span> at location [<span class="hljs-number">319.1</span>, <span class="hljs-number">223.2</span>, <span class="hljs-number">403.2</span>, <span class="hljs-number">238.4</span>] <span class="hljs-keyword">in</span> image <span class="hljs-number">1</span>
Detected boat <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.27</span> at location [<span class="hljs-number">37.7</span>, <span class="hljs-number">220.3</span>, <span class="hljs-number">84.0</span>, <span class="hljs-number">235.9</span>] <span class="hljs-keyword">in</span> image <span class="hljs-number">1</span>
Detected boat <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.22</span> at location [<span class="hljs-number">407.9</span>, <span class="hljs-number">207.0</span>, <span class="hljs-number">441.7</span>, <span class="hljs-number">220.2</span>] <span class="hljs-keyword">in</span> image <span class="hljs-number">1</span>
Detected statue <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.73</span> at location [<span class="hljs-number">544.7</span>, <span class="hljs-number">210.2</span>, <span class="hljs-number">651.9</span>, <span class="hljs-number">502.8</span>] <span class="hljs-keyword">in</span> image <span class="hljs-number">2</span>
Detected trees <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.25</span> at location [<span class="hljs-number">3.9</span>, <span class="hljs-number">584.3</span>, <span class="hljs-number">391.4</span>, <span class="hljs-number">785.6</span>] <span class="hljs-keyword">in</span> image <span class="hljs-number">2</span>
Detected trees <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.25</span> at location [<span class="hljs-number">1.4</span>, <span class="hljs-number">621.2</span>, <span class="hljs-number">118.2</span>, <span class="hljs-number">787.8</span>] <span class="hljs-keyword">in</span> image <span class="hljs-number">2</span>
Detected statue <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.2</span> at location [<span class="hljs-number">428.1</span>, <span class="hljs-number">205.5</span>, <span class="hljs-number">767.3</span>, <span class="hljs-number">759.5</span>] <span class="hljs-keyword">in</span> image <span class="hljs-number">2</span>
`,wrap:!1}}),ee=new x({props:{title:"OmDetTurboConfig",local:"transformers.OmDetTurboConfig",headingTag:"h2"}}),se=new je({props:{name:"class transformers.OmDetTurboConfig",anchor:"transformers.OmDetTurboConfig",parameters:[{name:"text_config",val:" = None"},{name:"backbone_config",val:" = None"},{name:"use_timm_backbone",val:" = True"},{name:"backbone",val:" = 'swin_tiny_patch4_window7_224'"},{name:"backbone_kwargs",val:" = None"},{name:"use_pretrained_backbone",val:" = False"},{name:"apply_layernorm_after_vision_backbone",val:" = True"},{name:"image_size",val:" = 640"},{name:"disable_custom_kernels",val:" = False"},{name:"layer_norm_eps",val:" = 1e-05"},{name:"batch_norm_eps",val:" = 1e-05"},{name:"init_std",val:" = 0.02"},{name:"text_projection_in_dim",val:" = 512"},{name:"text_projection_out_dim",val:" = 512"},{name:"task_encoder_hidden_dim",val:" = 1024"},{name:"class_embed_dim",val:" = 512"},{name:"class_distance_type",val:" = 'cosine'"},{name:"num_queries",val:" = 900"},{name:"csp_activation",val:" = 'silu'"},{name:"conv_norm_activation",val:" = 'gelu'"},{name:"encoder_feedforward_activation",val:" = 'relu'"},{name:"encoder_feedforward_dropout",val:" = 0.0"},{name:"encoder_dropout",val:" = 0.0"},{name:"hidden_expansion",val:" = 1"},{name:"vision_features_channels",val:" = [256, 256, 256]"},{name:"encoder_hidden_dim",val:" = 256"},{name:"encoder_in_channels",val:" = [192, 384, 768]"},{name:"encoder_projection_indices",val:" = [2]"},{name:"encoder_attention_heads",val:" = 8"},{name:"encoder_dim_feedforward",val:" = 2048"},{name:"encoder_layers",val:" = 1"},{name:"positional_encoding_temperature",val:" = 10000"},{name:"num_feature_levels",val:" = 3"},{name:"decoder_hidden_dim",val:" = 256"},{name:"decoder_num_heads",val:" = 8"},{name:"decoder_num_layers",val:" = 6"},{name:"decoder_activation",val:" = 'relu'"},{name:"decoder_dim_feedforward",val:" = 2048"},{name:"decoder_num_points",val:" = 4"},{name:"decoder_dropout",val:" = 0.0"},{name:"eval_size",val:" = None"},{name:"learn_initial_query",val:" = False"},{name:"cache_size",val:" = 100"},{name:"is_encoder_decoder",val:" = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.OmDetTurboConfig.text_config",description:`<strong>text_config</strong> (<code>PretrainedConfig</code>, <em>optional</em>) &#x2014;
The configuration of the text backbone.`,name:"text_config"},{anchor:"transformers.OmDetTurboConfig.backbone_config",description:`<strong>backbone_config</strong> (<code>PretrainedConfig</code>, <em>optional</em>) &#x2014;
The configuration of the vision backbone.`,name:"backbone_config"},{anchor:"transformers.OmDetTurboConfig.use_timm_backbone",description:`<strong>use_timm_backbone</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to use the timm for the vision backbone.`,name:"use_timm_backbone"},{anchor:"transformers.OmDetTurboConfig.backbone",description:`<strong>backbone</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;swin_tiny_patch4_window7_224&quot;</code>) &#x2014;
The name of the pretrained vision backbone to use. If <code>use_pretrained_backbone=False</code> a randomly initialized
backbone with the same architecture <code>backbone</code> is used.`,name:"backbone"},{anchor:"transformers.OmDetTurboConfig.backbone_kwargs",description:`<strong>backbone_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
Additional kwargs for the vision backbone.`,name:"backbone_kwargs"},{anchor:"transformers.OmDetTurboConfig.use_pretrained_backbone",description:`<strong>use_pretrained_backbone</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use a pretrained vision backbone.`,name:"use_pretrained_backbone"},{anchor:"transformers.OmDetTurboConfig.apply_layernorm_after_vision_backbone",description:`<strong>apply_layernorm_after_vision_backbone</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to apply layer normalization on the feature maps of the vision backbone output.`,name:"apply_layernorm_after_vision_backbone"},{anchor:"transformers.OmDetTurboConfig.image_size",description:`<strong>image_size</strong> (<code>int</code>, <em>optional</em>, defaults to 640) &#x2014;
The size (resolution) of each image.`,name:"image_size"},{anchor:"transformers.OmDetTurboConfig.disable_custom_kernels",description:`<strong>disable_custom_kernels</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to disable custom kernels.`,name:"disable_custom_kernels"},{anchor:"transformers.OmDetTurboConfig.layer_norm_eps",description:`<strong>layer_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-05) &#x2014;
The epsilon value for layer normalization.`,name:"layer_norm_eps"},{anchor:"transformers.OmDetTurboConfig.batch_norm_eps",description:`<strong>batch_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-05) &#x2014;
The epsilon value for batch normalization.`,name:"batch_norm_eps"},{anchor:"transformers.OmDetTurboConfig.init_std",description:`<strong>init_std</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"init_std"},{anchor:"transformers.OmDetTurboConfig.text_projection_in_dim",description:`<strong>text_projection_in_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
The input dimension for the text projection.`,name:"text_projection_in_dim"},{anchor:"transformers.OmDetTurboConfig.text_projection_out_dim",description:`<strong>text_projection_out_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
The output dimension for the text projection.`,name:"text_projection_out_dim"},{anchor:"transformers.OmDetTurboConfig.task_encoder_hidden_dim",description:`<strong>task_encoder_hidden_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 1024) &#x2014;
The feedforward dimension for the task encoder.`,name:"task_encoder_hidden_dim"},{anchor:"transformers.OmDetTurboConfig.class_embed_dim",description:`<strong>class_embed_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
The dimension of the classes embeddings.`,name:"class_embed_dim"},{anchor:"transformers.OmDetTurboConfig.class_distance_type",description:`<strong>class_distance_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;cosine&quot;</code>) &#x2014;
The type of of distance to compare predicted classes to projected classes embeddings.
Can be <code>&quot;cosine&quot;</code> or <code>&quot;dot&quot;</code>.`,name:"class_distance_type"},{anchor:"transformers.OmDetTurboConfig.num_queries",description:`<strong>num_queries</strong> (<code>int</code>, <em>optional</em>, defaults to 900) &#x2014;
The number of queries.`,name:"num_queries"},{anchor:"transformers.OmDetTurboConfig.csp_activation",description:`<strong>csp_activation</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;silu&quot;</code>) &#x2014;
The activation function of the Cross Stage Partial (CSP) networks of the encoder.`,name:"csp_activation"},{anchor:"transformers.OmDetTurboConfig.conv_norm_activation",description:`<strong>conv_norm_activation</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;gelu&quot;</code>) &#x2014;
The activation function of the ConvNormLayer layers of the encoder.`,name:"conv_norm_activation"},{anchor:"transformers.OmDetTurboConfig.encoder_feedforward_activation",description:`<strong>encoder_feedforward_activation</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;relu&quot;</code>) &#x2014;
The activation function for the feedforward network of the encoder.`,name:"encoder_feedforward_activation"},{anchor:"transformers.OmDetTurboConfig.encoder_feedforward_dropout",description:`<strong>encoder_feedforward_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout rate following the activation of the encoder feedforward network.`,name:"encoder_feedforward_dropout"},{anchor:"transformers.OmDetTurboConfig.encoder_dropout",description:`<strong>encoder_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout rate of the encoder multi-head attention module.`,name:"encoder_dropout"},{anchor:"transformers.OmDetTurboConfig.hidden_expansion",description:`<strong>hidden_expansion</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The hidden expansion of the CSP networks in the encoder.`,name:"hidden_expansion"},{anchor:"transformers.OmDetTurboConfig.vision_features_channels",description:`<strong>vision_features_channels</strong> (<code>tuple(int)</code>, <em>optional</em>, defaults to <code>[256, 256, 256]</code>) &#x2014;
The projected vision features channels used as inputs for the decoder.`,name:"vision_features_channels"},{anchor:"transformers.OmDetTurboConfig.encoder_hidden_dim",description:`<strong>encoder_hidden_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 256) &#x2014;
The hidden dimension of the encoder.`,name:"encoder_hidden_dim"},{anchor:"transformers.OmDetTurboConfig.encoder_in_channels",description:`<strong>encoder_in_channels</strong> (<code>List(int)</code>, <em>optional</em>, defaults to <code>[192, 384, 768]</code>) &#x2014;
The input channels for the encoder.`,name:"encoder_in_channels"},{anchor:"transformers.OmDetTurboConfig.encoder_projection_indices",description:`<strong>encoder_projection_indices</strong> (<code>List(int)</code>, <em>optional</em>, defaults to <code>[2]</code>) &#x2014;
The indices of the input features projected by each layers.`,name:"encoder_projection_indices"},{anchor:"transformers.OmDetTurboConfig.encoder_attention_heads",description:`<strong>encoder_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 8) &#x2014;
The number of attention heads for the encoder.`,name:"encoder_attention_heads"},{anchor:"transformers.OmDetTurboConfig.encoder_dim_feedforward",description:`<strong>encoder_dim_feedforward</strong> (<code>int</code>, <em>optional</em>, defaults to 2048) &#x2014;
The feedforward dimension for the encoder.`,name:"encoder_dim_feedforward"},{anchor:"transformers.OmDetTurboConfig.encoder_layers",description:`<strong>encoder_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of layers in the encoder.`,name:"encoder_layers"},{anchor:"transformers.OmDetTurboConfig.positional_encoding_temperature",description:`<strong>positional_encoding_temperature</strong> (<code>int</code>, <em>optional</em>, defaults to 10000) &#x2014;
The positional encoding temperature in the encoder.`,name:"positional_encoding_temperature"},{anchor:"transformers.OmDetTurboConfig.num_feature_levels",description:`<strong>num_feature_levels</strong> (<code>int</code>, <em>optional</em>, defaults to 3) &#x2014;
The number of feature levels for the multi-scale deformable attention module of the decoder.`,name:"num_feature_levels"},{anchor:"transformers.OmDetTurboConfig.decoder_hidden_dim",description:`<strong>decoder_hidden_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 256) &#x2014;
The hidden dimension of the decoder.`,name:"decoder_hidden_dim"},{anchor:"transformers.OmDetTurboConfig.decoder_num_heads",description:`<strong>decoder_num_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 8) &#x2014;
The number of heads for the decoder.`,name:"decoder_num_heads"},{anchor:"transformers.OmDetTurboConfig.decoder_num_layers",description:`<strong>decoder_num_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 6) &#x2014;
The number of layers for the decoder.`,name:"decoder_num_layers"},{anchor:"transformers.OmDetTurboConfig.decoder_activation",description:`<strong>decoder_activation</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;relu&quot;</code>) &#x2014;
The activation function for the decoder.`,name:"decoder_activation"},{anchor:"transformers.OmDetTurboConfig.decoder_dim_feedforward",description:`<strong>decoder_dim_feedforward</strong> (<code>int</code>, <em>optional</em>, defaults to 2048) &#x2014;
The feedforward dimension for the decoder.`,name:"decoder_dim_feedforward"},{anchor:"transformers.OmDetTurboConfig.decoder_num_points",description:`<strong>decoder_num_points</strong> (<code>int</code>, <em>optional</em>, defaults to 4) &#x2014;
The number of points sampled in the decoder multi-scale deformable attention module.`,name:"decoder_num_points"},{anchor:"transformers.OmDetTurboConfig.decoder_dropout",description:`<strong>decoder_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout rate for the decoder.`,name:"decoder_dropout"},{anchor:"transformers.OmDetTurboConfig.eval_size",description:`<strong>eval_size</strong> (<code>Tuple[int, int]</code>, <em>optional</em>) &#x2014;
Height and width used to computes the effective height and width of the position embeddings after taking
into account the stride (see RTDetr).`,name:"eval_size"},{anchor:"transformers.OmDetTurboConfig.learn_initial_query",description:`<strong>learn_initial_query</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to learn the initial query.`,name:"learn_initial_query"},{anchor:"transformers.OmDetTurboConfig.cache_size",description:`<strong>cache_size</strong> (<code>int</code>, <em>optional</em>, defaults to 100) &#x2014;
The cache size for the classes and prompts caches.`,name:"cache_size"},{anchor:"transformers.OmDetTurboConfig.is_encoder_decoder",description:`<strong>is_encoder_decoder</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether the model is used as an encoder-decoder model or not.`,name:"is_encoder_decoder"},{anchor:"transformers.OmDetTurboConfig.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional parameters from the architecture. The values in kwargs will be saved as part of the configuration
and can be used to control the model outputs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/vr_22105/src/transformers/models/omdet_turbo/configuration_omdet_turbo.py#L26"}}),$=new ks({props:{anchor:"transformers.OmDetTurboConfig.example",$$slots:{default:[Rs]},$$scope:{ctx:z}}}),te=new x({props:{title:"OmDetTurboProcessor",local:"transformers.OmDetTurboProcessor",headingTag:"h2"}}),ne=new je({props:{name:"class transformers.OmDetTurboProcessor",anchor:"transformers.OmDetTurboProcessor",parameters:[{name:"image_processor",val:""},{name:"tokenizer",val:""}],parametersDescription:[{anchor:"transformers.OmDetTurboProcessor.image_processor",description:`<strong>image_processor</strong> (<code>DetrImageProcessor</code>) &#x2014;
An instance of <a href="/docs/transformers/pr_22105/en/model_doc/detr#transformers.DetrImageProcessor">DetrImageProcessor</a>. The image processor is a required input.`,name:"image_processor"},{anchor:"transformers.OmDetTurboProcessor.tokenizer",description:"<strong>tokenizer</strong> (<code>AutoTokenizer</code>) &#x2014;\nAn instance of [&#x2018;PreTrainedTokenizer`]. The tokenizer is a required input.",name:"tokenizer"}],source:"https://github.com/huggingface/transformers/blob/vr_22105/src/transformers/models/omdet_turbo/processing_omdet_turbo.py#L172"}}),oe=new je({props:{name:"post_process_grounded_object_detection",anchor:"transformers.OmDetTurboProcessor.post_process_grounded_object_detection",parameters:[{name:"outputs",val:""},{name:"classes",val:": typing.Union[typing.List[str], typing.List[typing.List[str]]]"},{name:"score_threshold",val:": float = 0.3"},{name:"nms_threshold",val:": float = 0.5"},{name:"target_sizes",val:": typing.Union[transformers.utils.generic.TensorType, typing.List[typing.Tuple], NoneType] = None"},{name:"max_num_det",val:": typing.Optional[int] = None"}],parametersDescription:[{anchor:"transformers.OmDetTurboProcessor.post_process_grounded_object_detection.outputs",description:`<strong>outputs</strong> (<code>OmDetTurboObjectDetectionOutput</code>) &#x2014;
Raw outputs of the model.`,name:"outputs"},{anchor:"transformers.OmDetTurboProcessor.post_process_grounded_object_detection.classes",description:"<strong>classes</strong> (Union[List[str], List[List[str]]]) &#x2014; The input classes names.",name:"classes"},{anchor:"transformers.OmDetTurboProcessor.post_process_grounded_object_detection.score_threshold",description:`<strong>score_threshold</strong> (float, defaults to 0.3) &#x2014; Only return detections with a confidence score exceeding this
threshold.`,name:"score_threshold"},{anchor:"transformers.OmDetTurboProcessor.post_process_grounded_object_detection.nms_threshold",description:"<strong>nms_threshold</strong> (float, defaults to 0.5) &#x2014;  The threshold to use for box non-maximum suppression. Value in [0, 1].",name:"nms_threshold"},{anchor:"transformers.OmDetTurboProcessor.post_process_grounded_object_detection.target_sizes",description:`<strong>target_sizes</strong> (<code>torch.Tensor</code> or <code>List[Tuple[int, int]]</code>, <em>optional</em>, defaults to None) &#x2014;
Tensor of shape <code>(batch_size, 2)</code> or list of tuples (<code>Tuple[int, int]</code>) containing the target size
<code>(height, width)</code> of each image in the batch. If unset, predictions will not be resized.`,name:"target_sizes"},{anchor:"transformers.OmDetTurboProcessor.post_process_grounded_object_detection.max_num_det",description:"<strong>max_num_det</strong> (int, <em>optional</em>, defaults to None) &#x2014; The maximum number of detections to return.",name:"max_num_det"}],source:"https://github.com/huggingface/transformers/blob/vr_22105/src/transformers/models/omdet_turbo/processing_omdet_turbo.py#L277",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of dictionaries, each dictionary containing the scores, classes and boxes for an image
in the batch as predicted by the model.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[Dict]</code></p>
`}}),ae=new x({props:{title:"OmDetTurboForObjectDetection",local:"transformers.OmDetTurboForObjectDetection",headingTag:"h2"}}),re=new je({props:{name:"class transformers.OmDetTurboForObjectDetection",anchor:"transformers.OmDetTurboForObjectDetection",parameters:[{name:"config",val:": OmDetTurboConfig"}],parametersDescription:[{anchor:"transformers.OmDetTurboForObjectDetection.config",description:`<strong>config</strong> (<a href="/docs/transformers/pr_22105/en/model_doc/omdet-turbo#transformers.OmDetTurboConfig">OmDetTurboConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/pr_22105/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/vr_22105/src/transformers/models/omdet_turbo/modeling_omdet_turbo.py#L1631"}}),le=new je({props:{name:"forward",anchor:"transformers.OmDetTurboForObjectDetection.forward",parameters:[{name:"pixel_values",val:": Tensor"},{name:"classes_input_ids",val:": Tensor"},{name:"classes_attention_mask",val:": Tensor"},{name:"tasks_input_ids",val:": Tensor"},{name:"tasks_attention_mask",val:": Tensor"},{name:"classes_structure",val:": Tensor"},{name:"labels",val:": typing.Optional[torch.Tensor] = None"},{name:"output_attentions",val:" = None"},{name:"output_hidden_states",val:" = None"},{name:"return_dict",val:" = None"}],parametersDescription:[{anchor:"transformers.OmDetTurboForObjectDetection.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Padding will be ignored by default should you provide it.</p>
<p>Pixel values can be obtained using <a href="/docs/transformers/pr_22105/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See <a href="/docs/transformers/pr_22105/en/model_doc/imagegpt#transformers.ImageGPTFeatureExtractor.__call__">DetrImageProcessor.<strong>call</strong>()</a> for
details.`,name:"pixel_values"},{anchor:"transformers.OmDetTurboForObjectDetection.forward.classes_input_ids",description:`<strong>classes_input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(total_classes (&gt;= batch_size), sequence_length)</code>) &#x2014;
Indices of input classes sequence tokens in the vocabulary of the language model.
Several classes can be provided for each tasks, thus the tokenized classes are flattened
and the structure of the classes is provided in the <code>classes_structure</code> argument.</p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_22105/en/model_doc/omdet-turbo#transformers.OmDetTurboProcessor">OmDetTurboProcessor</a>. See <code>OmDetTurboProcessor.__call__()</code> for
details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"classes_input_ids"},{anchor:"transformers.OmDetTurboForObjectDetection.forward.classes_attention_mask",description:`<strong>classes_attention_mask</strong> (<code>torch.BoolTensor</code> of shape <code>(total_classes (&gt;= batch_size), num_classes, sequence_length)</code>) &#x2014;
Attention mask for the classes. This is a binary mask that indicates which tokens should be attended to,
and which should not.`,name:"classes_attention_mask"},{anchor:"transformers.OmDetTurboForObjectDetection.forward.tasks_input_ids",description:`<strong>tasks_input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input tasks sequence tokens in the vocabulary of the language model.</p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_22105/en/model_doc/omdet-turbo#transformers.OmDetTurboProcessor">OmDetTurboProcessor</a>. See <code>OmDetTurboProcessor.__call__()</code> for
details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"tasks_input_ids"},{anchor:"transformers.OmDetTurboForObjectDetection.forward.tasks_attention_mask",description:`<strong>tasks_attention_mask</strong> (<code>torch.BoolTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Attention mask for the tasks. This is a binary mask that indicates which tokens should be attended to,
and which should not.`,name:"tasks_attention_mask"},{anchor:"transformers.OmDetTurboForObjectDetection.forward.classes_structure",description:`<strong>classes_structure</strong> (torch.LongTensor of shape <code>(batch_size)</code>) &#x2014;
Structure of the classes. This tensor indicates the number of classes for each task.`,name:"classes_structure"},{anchor:"transformers.OmDetTurboForObjectDetection.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.OmDetTurboForObjectDetection.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.OmDetTurboForObjectDetection.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/pr_22105/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/vr_22105/src/transformers/models/omdet_turbo/modeling_omdet_turbo.py#L1666",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.models.omdet_turbo.modeling_omdet_turbo.OmDetTurboObjectDetectionOutput</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/pr_22105/en/model_doc/omdet-turbo#transformers.OmDetTurboConfig"
>OmDetTurboConfig</a>) and inputs.</p>
<ul>
<li><strong>loss</strong> (<code>torch.FloatTensor</code>) — The loss value.</li>
<li><strong>decoder_coord_logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, 4)</code>) — The predicted coordinates logits of the objects.</li>
<li><strong>decoder_class_logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, num_classes)</code>) — The predicted class of the objects.</li>
<li><strong>init_reference_points</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, 4)</code>) — The initial reference points.</li>
<li><strong>intermediate_reference_points</strong> (<code>Tuple[Tuple[torch.FloatTensor]]</code>) — The intermediate reference points.</li>
<li><strong>encoder_coord_logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, 4)</code>) — The predicted coordinates of the objects from the encoder.</li>
<li><strong>encoder_class_logits</strong> (<code>Tuple[torch.FloatTensor]</code>) — The predicted class of the objects from the encoder.</li>
<li><strong>encoder_extracted_states</strong> (<code>torch.FloatTensor</code>) — The extracted states from the Feature Pyramid Network (FPN) and Path Aggregation Network (PAN) of the encoder.</li>
<li><strong>decoder_hidden_states</strong> (<code>Optional[Tuple[torch.FloatTensor]]</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the model at the output of each layer
plus the initial embedding outputs.</li>
<li><strong>decoder_attentions</strong> (<code>Optional[Tuple[Tuple[torch.FloatTensor]]]</code>) — Tuple of tuples of <code>torch.FloatTensor</code> (one for attention for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights after the attention softmax, used to compute the
weighted average in the self-attention, cross-attention and multi-scale deformable attention heads.</li>
<li><strong>encoder_hidden_states</strong> (<code>Optional[Tuple[torch.FloatTensor]]</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the model at the output of each layer
plus the initial embedding outputs.</li>
<li><strong>encoder_attentions</strong> (<code>Optional[Tuple[Tuple[torch.FloatTensor]]]</code>) — Tuple of tuples of <code>torch.FloatTensor</code> (one for attention for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights after the attention softmax, used to compute the
weighted average in the self-attention, cross-attention and multi-scale deformable attention heads.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.models.omdet_turbo.modeling_omdet_turbo.OmDetTurboObjectDetectionOutput</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),V=new Ns({props:{$$slots:{default:[Zs]},$$scope:{ctx:z}}}),R=new ks({props:{anchor:"transformers.OmDetTurboForObjectDetection.forward.example",$$slots:{default:[Bs]},$$scope:{ctx:z}}}),ce=new Vs({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/omdet-turbo.md"}}),{c(){l=c("meta"),w=o(),_=c("p"),m=o(),p(y.$$.fragment),r=o(),p(j.$$.fragment),Me=o(),B=c("p"),B.innerHTML=is,we=o(),E=c("p"),E.textContent=ds,Je=o(),q=c("p"),q.innerHTML=ms,Ue=o(),O=c("img"),ve=o(),G=c("small"),G.innerHTML=us,Ce=o(),W=c("p"),W.innerHTML=hs,ke=o(),p(F.$$.fragment),Ie=o(),H=c("p"),H.innerHTML=bs,De=o(),Q=c("p"),Q.innerHTML=fs,xe=o(),p(X.$$.fragment),ze=o(),p(Y.$$.fragment),Oe=o(),S=c("p"),S.textContent=gs,$e=o(),p(A.$$.fragment),Ne=o(),p(P.$$.fragment),Ve=o(),L=c("p"),L.textContent=_s,Re=o(),p(K.$$.fragment),Ze=o(),p(ee.$$.fragment),Be=o(),J=c("div"),p(se.$$.fragment),Ye=o(),me=c("p"),me.innerHTML=Ts,Se=o(),pe=c("p"),pe.innerHTML=ys,Ae=o(),p($.$$.fragment),Ee=o(),p(te.$$.fragment),qe=o(),U=c("div"),p(ne.$$.fragment),Pe=o(),ue=c("p"),ue.textContent=js,Le=o(),he=c("p"),he.innerHTML=Ms,Ke=o(),N=c("div"),p(oe.$$.fragment),es=o(),be=c("p"),be.innerHTML=ws,Ge=o(),p(ae.$$.fragment),We=o(),M=c("div"),p(re.$$.fragment),ss=o(),fe=c("p"),fe.textContent=Js,ts=o(),ge=c("p"),ge.innerHTML=Us,ns=o(),_e=c("p"),_e.innerHTML=vs,os=o(),v=c("div"),p(le.$$.fragment),as=o(),Te=c("p"),Te.innerHTML=Cs,rs=o(),p(V.$$.fragment),ls=o(),p(R.$$.fragment),Fe=o(),p(ce.$$.fragment),He=o(),ye=c("p"),this.h()},l(e){const s=$s("svelte-u9bgzb",document.head);l=i(s,"META",{name:!0,content:!0}),s.forEach(t),w=a(e),_=i(e,"P",{}),de(_).forEach(t),m=a(e),u(y.$$.fragment,e),r=a(e),u(j.$$.fragment,e),Me=a(e),B=i(e,"P",{"data-svelte-h":!0}),T(B)!=="svelte-o5s894"&&(B.innerHTML=is),we=a(e),E=i(e,"P",{"data-svelte-h":!0}),T(E)!=="svelte-vfdo9a"&&(E.textContent=ds),Je=a(e),q=i(e,"P",{"data-svelte-h":!0}),T(q)!=="svelte-1plfyau"&&(q.innerHTML=ms),Ue=a(e),O=i(e,"IMG",{src:!0,alt:!0,width:!0}),ve=a(e),G=i(e,"SMALL",{"data-svelte-h":!0}),T(G)!=="svelte-1lprvf"&&(G.innerHTML=us),Ce=a(e),W=i(e,"P",{"data-svelte-h":!0}),T(W)!=="svelte-1anbey3"&&(W.innerHTML=hs),ke=a(e),u(F.$$.fragment,e),Ie=a(e),H=i(e,"P",{"data-svelte-h":!0}),T(H)!=="svelte-6qxnhs"&&(H.innerHTML=bs),De=a(e),Q=i(e,"P",{"data-svelte-h":!0}),T(Q)!=="svelte-vifd5g"&&(Q.innerHTML=fs),xe=a(e),u(X.$$.fragment,e),ze=a(e),u(Y.$$.fragment,e),Oe=a(e),S=i(e,"P",{"data-svelte-h":!0}),T(S)!=="svelte-7rgq3f"&&(S.textContent=gs),$e=a(e),u(A.$$.fragment,e),Ne=a(e),u(P.$$.fragment,e),Ve=a(e),L=i(e,"P",{"data-svelte-h":!0}),T(L)!=="svelte-s1nkyi"&&(L.textContent=_s),Re=a(e),u(K.$$.fragment,e),Ze=a(e),u(ee.$$.fragment,e),Be=a(e),J=i(e,"DIV",{class:!0});var C=de(J);u(se.$$.fragment,C),Ye=a(C),me=i(C,"P",{"data-svelte-h":!0}),T(me)!=="svelte-1eeyc3d"&&(me.innerHTML=Ts),Se=a(C),pe=i(C,"P",{"data-svelte-h":!0}),T(pe)!=="svelte-1pjt8ff"&&(pe.innerHTML=ys),Ae=a(C),u($.$$.fragment,C),C.forEach(t),Ee=a(e),u(te.$$.fragment,e),qe=a(e),U=i(e,"DIV",{class:!0});var k=de(U);u(ne.$$.fragment,k),Pe=a(k),ue=i(k,"P",{"data-svelte-h":!0}),T(ue)!=="svelte-sqqjjc"&&(ue.textContent=js),Le=a(k),he=i(k,"P",{"data-svelte-h":!0}),T(he)!=="svelte-1iu95j0"&&(he.innerHTML=Ms),Ke=a(k),N=i(k,"DIV",{class:!0});var ie=de(N);u(oe.$$.fragment,ie),es=a(ie),be=i(ie,"P",{"data-svelte-h":!0}),T(be)!=="svelte-13br9n7"&&(be.innerHTML=ws),ie.forEach(t),k.forEach(t),Ge=a(e),u(ae.$$.fragment,e),We=a(e),M=i(e,"DIV",{class:!0});var I=de(M);u(re.$$.fragment,I),ss=a(I),fe=i(I,"P",{"data-svelte-h":!0}),T(fe)!=="svelte-1cqamoa"&&(fe.textContent=Js),ts=a(I),ge=i(I,"P",{"data-svelte-h":!0}),T(ge)!=="svelte-tjhbck"&&(ge.innerHTML=Us),ns=a(I),_e=i(I,"P",{"data-svelte-h":!0}),T(_e)!=="svelte-hswkmf"&&(_e.innerHTML=vs),os=a(I),v=i(I,"DIV",{class:!0});var Z=de(v);u(le.$$.fragment,Z),as=a(Z),Te=i(Z,"P",{"data-svelte-h":!0}),T(Te)!=="svelte-iiay9b"&&(Te.innerHTML=Cs),rs=a(Z),u(V.$$.fragment,Z),ls=a(Z),u(R.$$.fragment,Z),Z.forEach(t),I.forEach(t),Fe=a(e),u(ce.$$.fragment,e),He=a(e),ye=i(e,"P",{}),de(ye).forEach(t),this.h()},h(){D(l,"name","hf:doc:metadata"),D(l,"content",qs),Ds(O.src,ps="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/model_doc/omdet_turbo_architecture.jpeg")||D(O,"src",ps),D(O,"alt","drawing"),D(O,"width","600"),D(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(v,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(M,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,s){d(document.head,l),n(e,w,s),n(e,_,s),n(e,m,s),h(y,e,s),n(e,r,s),h(j,e,s),n(e,Me,s),n(e,B,s),n(e,we,s),n(e,E,s),n(e,Je,s),n(e,q,s),n(e,Ue,s),n(e,O,s),n(e,ve,s),n(e,G,s),n(e,Ce,s),n(e,W,s),n(e,ke,s),h(F,e,s),n(e,Ie,s),n(e,H,s),n(e,De,s),n(e,Q,s),n(e,xe,s),h(X,e,s),n(e,ze,s),h(Y,e,s),n(e,Oe,s),n(e,S,s),n(e,$e,s),h(A,e,s),n(e,Ne,s),h(P,e,s),n(e,Ve,s),n(e,L,s),n(e,Re,s),h(K,e,s),n(e,Ze,s),h(ee,e,s),n(e,Be,s),n(e,J,s),h(se,J,null),d(J,Ye),d(J,me),d(J,Se),d(J,pe),d(J,Ae),h($,J,null),n(e,Ee,s),h(te,e,s),n(e,qe,s),n(e,U,s),h(ne,U,null),d(U,Pe),d(U,ue),d(U,Le),d(U,he),d(U,Ke),d(U,N),h(oe,N,null),d(N,es),d(N,be),n(e,Ge,s),h(ae,e,s),n(e,We,s),n(e,M,s),h(re,M,null),d(M,ss),d(M,fe),d(M,ts),d(M,ge),d(M,ns),d(M,_e),d(M,os),d(M,v),h(le,v,null),d(v,as),d(v,Te),d(v,rs),h(V,v,null),d(v,ls),h(R,v,null),n(e,Fe,s),h(ce,e,s),n(e,He,s),n(e,ye,s),Qe=!0},p(e,[s]){const C={};s&2&&(C.$$scope={dirty:s,ctx:e}),$.$set(C);const k={};s&2&&(k.$$scope={dirty:s,ctx:e}),V.$set(k);const ie={};s&2&&(ie.$$scope={dirty:s,ctx:e}),R.$set(ie)},i(e){Qe||(b(y.$$.fragment,e),b(j.$$.fragment,e),b(F.$$.fragment,e),b(X.$$.fragment,e),b(Y.$$.fragment,e),b(A.$$.fragment,e),b(P.$$.fragment,e),b(K.$$.fragment,e),b(ee.$$.fragment,e),b(se.$$.fragment,e),b($.$$.fragment,e),b(te.$$.fragment,e),b(ne.$$.fragment,e),b(oe.$$.fragment,e),b(ae.$$.fragment,e),b(re.$$.fragment,e),b(le.$$.fragment,e),b(V.$$.fragment,e),b(R.$$.fragment,e),b(ce.$$.fragment,e),Qe=!0)},o(e){f(y.$$.fragment,e),f(j.$$.fragment,e),f(F.$$.fragment,e),f(X.$$.fragment,e),f(Y.$$.fragment,e),f(A.$$.fragment,e),f(P.$$.fragment,e),f(K.$$.fragment,e),f(ee.$$.fragment,e),f(se.$$.fragment,e),f($.$$.fragment,e),f(te.$$.fragment,e),f(ne.$$.fragment,e),f(oe.$$.fragment,e),f(ae.$$.fragment,e),f(re.$$.fragment,e),f(le.$$.fragment,e),f(V.$$.fragment,e),f(R.$$.fragment,e),f(ce.$$.fragment,e),Qe=!1},d(e){e&&(t(w),t(_),t(m),t(r),t(Me),t(B),t(we),t(E),t(Je),t(q),t(Ue),t(O),t(ve),t(G),t(Ce),t(W),t(ke),t(Ie),t(H),t(De),t(Q),t(xe),t(ze),t(Oe),t(S),t($e),t(Ne),t(Ve),t(L),t(Re),t(Ze),t(Be),t(J),t(Ee),t(qe),t(U),t(Ge),t(We),t(M),t(Fe),t(He),t(ye)),t(l),g(y,e),g(j,e),g(F,e),g(X,e),g(Y,e),g(A,e),g(P,e),g(K,e),g(ee,e),g(se),g($),g(te,e),g(ne),g(oe),g(ae,e),g(re),g(le),g(V),g(R),g(ce,e)}}}const qs='{"title":"OmDet-Turbo","local":"omdet-turbo","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Usage tips","local":"usage-tips","sections":[],"depth":2},{"title":"Usage example","local":"usage-example","sections":[{"title":"Single image inference","local":"single-image-inference","sections":[],"depth":3},{"title":"Multi image inference","local":"multi-image-inference","sections":[],"depth":3}],"depth":2},{"title":"OmDetTurboConfig","local":"transformers.OmDetTurboConfig","sections":[],"depth":2},{"title":"OmDetTurboProcessor","local":"transformers.OmDetTurboProcessor","sections":[],"depth":2},{"title":"OmDetTurboForObjectDetection","local":"transformers.OmDetTurboForObjectDetection","sections":[],"depth":2}],"depth":1}';function Gs(z){return xs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class As extends zs{constructor(l){super(),Os(this,l,Gs,Es,Is,{})}}export{As as component};
