# AI 101 by AI and Games (Dr. Tommy Thompson)

To better understand the theory behind classical AI in Games, the best resources to watch are the excellent **series of videos by Dr. Tommy Thompson on AI in Games called AI 101**.

[Dr Tommy Thompson](https://twitter.com/AIandGames) works as an AI developer, researcher and consultant in the video game industry. In his [YouTube channel, AI and Games](https://www.youtube.com/@AIandGames), he studies what AI algorithms are used in games and how.

We would like to thank Dr. Tommy Thompson for providing detailed introductions for each video in this section.


## Chapter 1: How AI is Actually Used in the Video Games Industry (2024) 🤖

When we talk about 'AI in video games' nowadays, **what do we really mean?** Game AI? Deep Learning? Generative AI?  All of these are valid, **but understanding how and where they're adopted is super important**. In this episode we provide a high-level overview of how artificial intelligence is adopted across the industry.

<iframe width="560" height="315" src="https://www.youtube.com/embed/j3LW5no-5Ao?si=D34_eCOL8QlW-TTB" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" allowfullscreen></iframe>

## Chapter 2: Why is It Difficult to Make Good AI for Games? 🤔

If you've build AI for your games (or simply played a lot of them too), **you'll notice how difficult it is to make AI really shine in your game**. In this episode we dig into some of the fundamental challenges faced by developers.

<iframe width="560" height="315" src="https://www.youtube.com/embed/qCkqpRnk1oU?si=HVC3Got61oztHhqJ" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" allowfullscreen></iframe>


## Chapter 3: Navigation Meshes 🗺️

As games moved into 3D, one of the biggest challenges was how to ensure a non-player character (NPC) could successfully move from one place to another.  The solution is what is typically referred to as a 'navigation mesh': a data structure that **tessellates a surface with a collection of polygons indicate of navigable space**. This concept, popularised by *Quake III Arena* in 1999 has since become a **standard tool in all 3D commercial game engines**. Despite this, **successful navigation is still a challenge for modern games** to this day given the myriad of design challenges it presents.

<iframe width="560" height="315" src="https://www.youtube.com/embed/U5MTIh_KyBc?si=S26zVmHvbLwC4Lty" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" allowfullscreen></iframe>

📚 Additional Readings:

- Theory and Overview of Navigation Meshes
	- https://en.wikipedia.org/wiki/Navigation_mesh
	- https://www.gamedev.net/articles/programming/artificial-intelligence/navigation-meshes-and-pathfinding-r4880/

- Nav Meshes in Unity
	- https://www.youtube.com/watch?v=CHV1ymlw-P8&ab_channel=Brackeys
  
- Nav Meshes in Unreal Engine 5
	- https://docs.unrealengine.com/5.3/en-US/basic-navigation-in-unreal-engine/


## Chapter 4: Behavior Trees 🌳

While there are a myriad of approaches for controlling NPCs in games - many of which earn their own episodes in this series - **the standard is Behaviour Trees**. These relatively straightforward data structures were originally popularised by the *Halo* franchise and have since become the norm for many large-scale big budget productions **and are the default AI tool in Unreal Engine**.

<iframe width="560" height="315" src="https://www.youtube.com/embed/6VBCXvfNlCM?si=Vc35IYS10A2vF4eX" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" allowfullscreen></iframe>


📚 Additional Readings:

- Behavior Trees in Unreal: https://docs.unrealengine.com/5.3/en-US/behavior-trees-in-unreal-engine/


## Chapter 5: Finite State Machines 🤖

*Finite State Machines* (FSMs) have existed since the very beginning not just of AI for video games, but the field of artificial intelligence as a whole. 

A simple system of connected 'states' that allows for designers **to encapsulate how a character should operate in specific contexts**. Many of your favourite games from the 1980s and 1990s adopted FSMs, from the arcade days of *Pac-Man* to the birth of first-person shooters with *DOOM*.  

While they're still used today in popular franchises like *Marvel's Spider-Man* and *The Last of Us*, this is largely thanks to the implementation in Valve's *Half-Life* which **set a new standard for their adoption in games**.    

<iframe width="560" height="315" src="https://www.youtube.com/embed/JyF0oyarz4U?si=G-uM3ImtlK3Fr0Oe" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" allowfullscreen></iframe>


📚 Additional Readings:

- Finite-State Machines: Theory and Implementation: https://code.tutsplus.com/finite-state-machines-theory-and-implementation--gamedev-11867t


## Chapter 6: Goal Oriented Action Planning 📝

*Goal Oriented Action Planning* was one of the **most important innovations in AI for games in the mid 2000s** and is arguably what led to Monolith's first-person shooter *F.E.A.R*. still being considered to have the best AI in video games.  But it's really quite simple: **the combination of finite state machines with AI planning technology that dates back as far as the 1970s.** 

<iframe width="560" height="315" src="https://www.youtube.com/embed/PaOLBOuyswI?si=ELDIk11nEy8MpqTe&amp;start=1" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" allowfullscreen></iframe>

📚 Additional Readings:

- Holistic 3D's video on GOAP: https://www.youtube.com/watch?v=jUSrVF8mve4&ab_channel=Holistic3D


## Chapter 7: Director AI for Balancing In-Game Experiences 📣

So far the topics have focused on AI that is built **to control non-player characters**, but what if we want to use AI not just for individual behaviours **but also designing the player experience**.

This has led to a collection of approaches collectively known as *Director AI*, with the term adopted for this design philosophy derived from its use in Valve's *Left 4 Dead*.

<iframe width="560" height="315" src="https://www.youtube.com/embed/Mnt5zxb8W0Y?si=Yqa7tnFx5d75LCVg" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" allowfullscreen></iframe>


## Chapter 8: Utility AI Helps NPCs Decide What To Do Next 📈

Sometimes an AI system could have a collection of valid options to select from, **but it can't tell which is the best for this context**.  

While we could now train a model using deep learning to determine contextual validity, **we have long since used utility AI as a means to embed designer knowledge to determine the validity of an action or goal**.

<iframe width="560" height="315" src="https://www.youtube.com/embed/p3Jbp2cZg3Q?si=5kqN3FqnFW277BTc" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" allowfullscreen></iframe>


📚 Additional Readings:


- [How the AI of The Sims Works](https://youtu.be/9gf2MT-IOsg?si=omZdMpayS5-qQJkE)
- ["An Introduction to Utility AI Theory" - Game AI Pro v2](https://www.gameaipro.com/GameAIPro/GameAIPro_Chapter09_An_Introduction_to_Utility_Theory.pdf)
- [Behavior Decision System: Dragon Age Inquisition’s Utility Scoring Architecture" - Game AI Pro v3](https://www.gameaipro.com/GameAIPro3/GameAIPro3_Chapter31_Behavior_Decision_System_Dragon_Age_Inquisition%E2%80%99s_Utility_Scoring_Architecture.pdf)


## Chapter 9: How Barks Make Videogame NPCs Look Smarter 🗣️

While building AI for games is difficult, communicating the inner workings of these systems to players is just as demanding.  One of the simplest solutions to this problem is the use of *barks*: **pre-built text and/or audio that helps communicate the state of an AI agent in ways that make sense in the context of play**.

That might sound pretty simple, **but you'd be surprised how effective it is in practice**.

<iframe width="560" height="315" src="https://www.youtube.com/embed/u9VkW18IMzc?si=-5yovJKq2OCeOkf-&amp;start=2" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" allowfullscreen></iframe>

📚 Additional Readings:

- [Interview with Supergiant on the dialogue of Hades](https://www.youtube.com/watch?v=bwdYL0KFA_U&t=0s)
- [Elan Ruskin on Fuzzy Pattern Matching for Dialogue](https://www.youtube.com/watch?v=tAbBID3N64A&t=0s)
- [Darren Korb and Greg Kasavin on the dialogue systems of Hades](https://www.youtube.com/watch?v=m5KJSAj4afg&t=0s)
- [Jason Gregory on context-aware dialogue in The Last of Us](https://www.gdcvault.com/play/1020386/A-Context-Aware-Character-Dialog)

Now that we studed the theory behind these classical AI in Games algorithms. Let's **learn how to implement some of them in Unity and Unreal**.


## Chapter 10: How Machine Learning is Transforming the Video Games Industry 🤖

As you will have gathered watching these videos, machine learning has not been as prominent in the adoption of AI for non-player characters when compared to symbolic methods. 

In this episode we dig into not just how it has been used in player facing systems, but also the interesting problem spaces it has been applied to in video games production.

<iframe width="560" height="315" src="https://www.youtube.com/embed/dm_yY-hddvE?si=ChqK_aCtOrV1qXq9" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" allowfullscreen></iframe>







<EditOnGithub source="https://github.com/huggingface/making-games-with-ai-course/blob/main/units/en/unitbonus1/ai-and-games.mdx" />