# Welcome to the 🤗 Machine Learning for Games Course [[introduction]]

<img src="https://huggingface.co/datasets/huggingface-ml-4-games-course/course-images/resolve/main/en/unit0/thumbnail.jpg" alt="Thumbnail" width="100%"/>

Welcome to the course that will teach you the most fascinating topic in game development: **how to use powerful AI tools and models to create unique game experiences**.


New AI models are revolutionizing the Game Industry in two impactful ways:

- On **how we make games**:
    - Generate textures using AI
    - Using AI voice actors for the voices. 

- How we **create gameplay**:
    - Crafting smart Non-Playable Characters (NPCs) using large language models.


This course will **teach you**:

- How to **integrate AI models for innovative gameplay**, featuring intelligent NPCs.
- How to use AI tools to help your game development pipeline.


In this introduction unit, you'll:

- Learn more about the **course content and the syllabus**.
- Learn the **course requirements**.
- Create your Hugging Face Account (it's free)
- Sign up to our Discord server to chat with your classmates and us (the Hugging Face team).

Let's get started!

## What to expect?

In this course, you will:

- 🤖 Learn to use **powerful chat models to build intelligent NPC**.
- 🪄 Run **these powerful AI models locally or with cloud APIs.**
- 🎨 Use AI tools **to accelerate your game development**: generate voices with text-to-speech models using image generation tools...
- 🎮 Work on **exciting game demos**.
- 👩‍🎨 **Build Your Own Game Demo**.

And more!

At the end of this course, you'll get a **solid foundation on using AI models in your games and AI tools in your game development**.

Remember to [sign up for the course](http://eepurl.com/iCWDQw) (we are collecting your email to be able to send you the links when each Unit is published and give you information about the challenges and updates).

Sign up 👉 [here](http://eepurl.com/iCWDQw)


For now, all our content uses the [Unity Game Engine](https://www.unity.com). In the future, we will add content about Unreal Engine, Godot, and more.

Naturally, for the demo, you can use any Game Engine you want (or no game engine), **but we advise you to use Unity**.

## But... I don't know how to make games!

This course **is not an introduction to game development**. You should have some skills in Unity to follow this course.

If it's not the case. Don't worry, that's the perfect time to start! To start making games with Unity, check out this fantastic course: [Create with Code](https://learn.unity.com/course/create-with-code), where you'll learn to make five different games.

With this create with code free course, **you'll get everything you need to be able to follow the Machine Learning for Games Course**.

Create with code course 👉 https://learn.unity.com/course/create-with-code

<img src="https://huggingface.co/datasets/huggingface-ml-4-games-course/course-images/resolve/main/en/unit0/create_with_code.png" alt="Thumbnail" width="100%"/>


In addition, you can watch this excellent introduction to Unity by [GMTK (Game Maker's Toolkit)](https://www.youtube.com/@GMTK)

<iframe width="560" height="315" src="https://www.youtube.com/embed/XtQMytORBmM?si=D6Q-8kGZsJIRm7Pe" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" allowfullscreen></iframe>



## Are we going to learn to train/fine-tune Transformer models and other AI models?

We don't plan to have a unit on this for now. **But the course will be improved with your feedback**.

We already have a lot of free courses if you want to go deeper into:

- Learning [Natural Language Processing with Transformers](https://huggingface.co/learn/nlp-course)
- Learning [Audio Processing with Transformers (Speech-To-Text, Text-To-Speech...)](https://huggingface.co/learn/audio-course/chapter0/introduction)
- Learn to [build Generative AI Applications with Gradio](https://www.deeplearning.ai/short-courses/building-generative-ai-applications-with-gradio/)


## Your Goal during this course 🏆: Making Your Own Game Demo

> [!TIP]
> The course is now **self-paced and will not have new future units**. We **don't provide a Certificate of Completion for this course**.
> But we continue to write tutorials on how to use AI in Games here 👉 https://thomassimonini.substack.com/

During this course, you will work on some demos we've made. But the most exciting part is that during the whole course **you will also work on your demo**. 

You'll build a game demo using either:

- **AI tools to help you build the game** (for instance, texture generation, AI voice actors...).

- And or using an **AI in the game as gameplay or for the NPC**.

## Don't forget to follow AI Playbook for Game Developers 🎮

<img src="https://substackcdn.com/image/fetch/w_1456,c_limit,f_webp,q_auto:good,fl_progressive:steep/https%3A%2F%2Fsubstack-post-media.s3.amazonaws.com%2Fpublic%2Fimages%2F486ef2ec-4965-4b25-bf3b-65dfefec2445_1500x500.jpeg"/>

In addition to this course, I'm writing a weekly blog with tutorials, articles.

From creating smarter NPCs to unleashing the power of Generative AI, I’m here to demystify the process with easy-to-follow tutorials and demos.

👉 https://thomassimonini.substack.com/



<EditOnGithub source="https://github.com/huggingface/making-games-with-ai-course/blob/main/units/en/unit0/introduction.mdx" />