# Your Game Demo

<img src="https://huggingface.co/datasets/huggingface-ml-4-games-course/course-images/resolve/main/en/unit0/game-demo.jpg" alt="Game Dev" width="100%"/>

> [!TIP]
> The course is now **self-paced and will not have new future units**. We **don't provide a Certificate of Completion for this course**.
> But we continue to write tutorials on how to use AI in Games here 👉 https://thomassimonini.substack.com/

The main goal of this course is to **learn how to use these new powerful AI models** for game development, either during game creation or as part of the gameplay to unlock innovative experiences!

And the best way to learn is **by doing**. That's why we think **it's a good idea to follow this course with a demo idea.**

If you don't have ideas yet, **don't worry**; we wrote some "Demo Units" that will help you define your game demo and avoid common pitfalls (scope too big, etc.).

## How do I choose which Game Engine to use?

It's up to you. For now, **we advise you to use Unity** since we produced most of the content for this v1 of the course with their tools. 

We strongly advise you to choose a game engine and not develop a game from scratch with only code. The goal of building a demo in one month is already a big step, and adding complexity is not a good idea.

## But... I don't know how to make games!

Don't worry, that's the perfect time to start! If you want to start making games with Unity, check their amazing [Create with Code course](https://learn.unity.com/course/create-with-code), where you'll learn how to make five different games. This free introduction **will teach you everything you need to know** to be able to follow our ML for Games Course.

Create with code course 👉 https://learn.unity.com/course/create-with-code

In addition, you can watch this excellent introduction to Unity by [GMTK (Game Maker's Toolkit)](https://www.youtube.com/@GMTK)

<iframe width="560" height="315" src="https://www.youtube.com/embed/XtQMytORBmM?si=D6Q-8kGZsJIRm7Pe" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" allowfullscreen></iframe>

## What tools do I need?

<img src="https://huggingface.co/datasets/huggingface-ml-4-games-course/course-images/resolve/main/en/unit0/tools.jpg" alt="Tools needed for the course" width="100%"/>

The minimum tools you need are:

- *A computer* with an internet connection.
- A *Hugging Face Account*: (it's free) to use AI models and publish your game demos.
- A *Game Engine License*. A free version is enough in most cases. Naturally, you could create your game from scratch, but we strongly advise using a Game Engine. We generally recommend Unity, as the first iteration of this course uses Unity tools. You can also use Unreal if **you're prepared to translate the concepts to their environment**.


<EditOnGithub source="https://github.com/huggingface/making-games-with-ai-course/blob/main/units/en/unit0/game-demo.mdx" />