import{s as Wl,f as xl,o as Rl,n as Xt}from"../chunks/scheduler.f6319a2a.js";import{S as Vl,i as Ql,g as a,s,r as u,A as El,h as i,f as l,c as n,j as Bl,u as d,x as r,k as Ft,y as Nl,a as o,v as c,d as m,t as h,w as M}from"../chunks/index.85aa684c.js";import{T as qt}from"../chunks/Tip.3d397a88.js";import{C as T}from"../chunks/CodeBlock.3400fc53.js";import{D as Sl}from"../chunks/DocNotebookDropdown.3fc3604b.js";import{H as v,E as Al}from"../chunks/index.9e1e6fd7.js";function Ll(j){let p,g='If you’re new to building agents, make sure to first read the <a href="../conceptual_guides/intro_agents">intro to agents</a> and the <a href="../guided_tour">guided tour of smolagents</a>.';return{c(){p=a("p"),p.innerHTML=g},l(y){p=i(y,"P",{"data-svelte-h":!0}),r(p)!=="svelte-1p1d9vw"&&(p.innerHTML=g)},m(y,f){o(y,p,f)},p:Xt,d(y){y&&l(p)}}}function Fl(j){let p,g="Beware of not adding too many tools to an agent: this can overwhelm weaker LLM engines.";return{c(){p=a("p"),p.textContent=g},l(y){p=i(y,"P",{"data-svelte-h":!0}),r(p)!=="svelte-h9mzfm"&&(p.textContent=g)},m(y,f){o(y,p,f)},p:Xt,d(y){y&&l(p)}}}function ql(j){let p,g="<strong>Security Warning:</strong> Using MCP servers comes with security risks:",y,f,U="<li><strong>Trust is essential:</strong> Only use MCP servers from trusted sources. Malicious servers can execute harmful code on your machine.</li> <li><strong>Stdio-based MCP servers</strong> will always execute code on your machine (that’s their intended functionality).</li> <li><strong>SSE-based MCP servers</strong> in the current implementation may be vulnerable to remote code execution attacks. A fix is being developed, but caution is still advised.</li>",J,w,Z="Always verify the source and integrity of any MCP server before connecting to it, especially for production environments.";return{c(){p=a("p"),p.innerHTML=g,y=s(),f=a("ul"),f.innerHTML=U,J=s(),w=a("p"),w.textContent=Z},l(b){p=i(b,"P",{"data-svelte-h":!0}),r(p)!=="svelte-936g9o"&&(p.innerHTML=g),y=n(b),f=i(b,"UL",{"data-svelte-h":!0}),r(f)!=="svelte-1o37kqj"&&(f.innerHTML=U),J=n(b),w=i(b,"P",{"data-svelte-h":!0}),r(w)!=="svelte-57pqg4"&&(w.textContent=Z)},m(b,C){o(b,p,C),o(b,y,C),o(b,f,C),o(b,J,C),o(b,w,C)},p:Xt,d(b){b&&(l(p),l(y),l(f),l(J),l(w))}}}function Xl(j){let p,g,y,f,U,J,w,Z,b,C="Here, we’re going to see advanced tool usage.",We,$,Re,H,Yt='<li><a href="#tools">Tools</a><ul><li><a href="#what-is-a-tool-and-how-to-build-one">What is a tool, and how to build one?</a></li> <li><a href="#share-your-tool-to-the-hub">Share your tool to the Hub</a></li> <li><a href="#import-a-space-as-a-tool">Import a Space as a tool</a></li> <li><a href="#use-langchain-tools">Use LangChain tools</a></li> <li><a href="#manage-your-agents-toolbox">Manage your agent’s toolbox</a></li> <li><a href="#use-a-collection-of-tools">Use a collection of tools</a></li></ul></li>',Ve,k,Qe,G,zt="A tool is mostly a function that an LLM can use in an agentic system.",Ee,x,Pt="But to use it, the LLM will need to be given an API: name, tool description, input types and descriptions, output type.",Ne,B,Dt="So it cannot be only a function. It should be a class.",Se,W,Kt="So at core, the tool is a class that wraps a function with metadata that helps the LLM understand how to use it.",Ae,R,Ot="Here’s how it looks:",Le,V,Fe,Q,el='The custom tool subclasses <a href="/docs/smolagents/pr_1175/en/reference/tools#smolagents.Tool">Tool</a> to inherit useful methods. The child class also defines:',qe,E,tl='<li>An attribute <code>name</code>, which corresponds to the name of the tool itself. The name usually describes what the tool does. Since the code returns the model with the most downloads for a task, let’s name it <code>model_download_counter</code>.</li> <li>An attribute <code>description</code> is used to populate the agent’s system prompt.</li> <li>An <code>inputs</code> attribute, which is a dictionary with keys <code>&quot;type&quot;</code> and <code>&quot;description&quot;</code>. It contains information that helps the Python interpreter make educated choices about the input.</li> <li>An <code>output_type</code> attribute, which specifies the output type. The types for both <code>inputs</code> and <code>output_type</code> should be <a href="https://docs.pydantic.dev/latest/concepts/json_schema/#generating-json-schema" rel="nofollow">Pydantic formats</a>, they can be either of these: <code>~AUTHORIZED_TYPES()</code>.</li> <li>A <code>forward</code> method which contains the inference code to be executed.</li>',Xe,N,ll="And that’s all it needs to be used in an agent!",Ye,S,ol='There’s another way to build a tool. In the <a href="../guided_tour">guided_tour</a>, we implemented a tool using the <code>@tool</code> decorator. The <a href="/docs/smolagents/pr_1175/en/reference/tools#smolagents.tool">tool()</a> decorator is the recommended way to define simple tools, but sometimes you need more than this: using several methods in a class for more clarity, or using additional class attributes.',ze,A,sl='In this case, you can build your tool by subclassing <a href="/docs/smolagents/pr_1175/en/reference/tools#smolagents.Tool">Tool</a> as described above.',Pe,L,De,F,nl='You can share your custom tool to the Hub by calling <a href="/docs/smolagents/pr_1175/en/reference/tools#smolagents.Tool.push_to_hub">push_to_hub()</a> on the tool. Make sure you’ve created a repository for it on the Hub and are using a token with read access.',Ke,q,Oe,X,al="For the push to Hub to work, your tool will need to respect some rules:",et,Y,il='<li>All methods are self-contained, e.g. use variables that come either from their args.</li> <li>As per the above point, <strong>all imports should be defined directly within the tool’s functions</strong>, else you will get an error when trying to call <a href="/docs/smolagents/pr_1175/en/reference/tools#smolagents.Tool.save">save()</a> or <a href="/docs/smolagents/pr_1175/en/reference/tools#smolagents.Tool.push_to_hub">push_to_hub()</a> with your custom tool.</li> <li>If you subclass the <code>__init__</code> method, you can give it no other argument than <code>self</code>. This is because arguments set during a specific tool instance’s initialization are hard to track, which prevents from sharing them properly to the hub. And anyway, the idea of making a specific class is that you can already set class attributes for anything you need to hard-code (just set <code>your_variable=(...)</code> directly under the <code>class YourTool(Tool):</code> line). And of course you can still create a class attribute anywhere in your code by assigning stuff to <code>self.your_variable</code>.</li>',tt,z,rl='Once your tool is pushed to Hub, you can visualize it. <a href="https://huggingface.co/spaces/m-ric/hf-model-downloads" rel="nofollow">Here</a> is the <code>model_downloads_tool</code> that I’ve pushed. It has a nice gradio interface.',lt,P,pl='When diving into the tool files, you can find that all the tool’s logic is under <a href="https://huggingface.co/spaces/m-ric/hf-model-downloads/blob/main/tool.py" rel="nofollow">tool.py</a>. That is where you can inspect a tool shared by someone else.',ot,D,ul=`Then you can load the tool with <a href="/docs/smolagents/pr_1175/en/reference/tools#smolagents.load_tool">load_tool()</a> or create it with <a href="/docs/smolagents/pr_1175/en/reference/tools#smolagents.Tool.from_hub">from_hub()</a> and pass it to the <code>tools</code> parameter in your agent.
Since running tools means running custom code, you need to make sure you trust the repository, thus we require to pass <code>trust_remote_code=True</code> to load a tool from the Hub.`,st,K,nt,O,at,ee,dl='You can directly import a Space from the Hub as a tool using the <a href="/docs/smolagents/pr_1175/en/reference/tools#smolagents.Tool.from_space">Tool.from_space()</a> method!',it,te,cl='You only need to provide the id of the Space on the Hub, its name, and a description that will help you agent understand what the tool does. Under the hood, this will use <a href="https://pypi.org/project/gradio-client/" rel="nofollow"><code>gradio-client</code></a> library to call the Space.',rt,le,ml='For instance, let’s import the <a href="https://huggingface.co/black-forest-labs/FLUX.1-dev" rel="nofollow">FLUX.1-dev</a> Space from the Hub and use it to generate an image.',pt,oe,ut,se,hl="And voilà, here’s your image! 🏖️",dt,Ge,Ml,ct,ne,yl="Then you can use this tool just like any other tool.  For example, let’s improve the prompt  <code>a rabbit wearing a space suit</code> and generate an image of it. This example also shows how you can pass additional arguments to the agent.",mt,ae,ht,ie,Mt,xe,bl,yt,re,fl="How cool is this? 🤩",bt,pe,ft,ue,wl=`We love Langchain and think it has a very compelling suite of tools.
To import a tool from LangChain, use the <code>from_langchain()</code> method.`,wt,de,gl=`Here is how you can use it to recreate the intro’s search result using a LangChain web search tool.
This tool will need <code>pip install langchain google-search-results -q</code> to work properly.`,gt,ce,Tt,me,Ut,he,Tl="You can manage an agent’s toolbox by adding or replacing a tool in attribute <code>agent.tools</code>, since it is a standard dictionary.",Jt,Me,Ul="Let’s add the <code>model_download_tool</code> to an existing agent initialized with only the default toolbox.",vt,ye,jt,be,Jl="Now we can leverage the new tool:",Ct,fe,$t,_,_t,we,It,ge,vl='You can leverage tool collections by using <a href="/docs/smolagents/pr_1175/en/reference/tools#smolagents.ToolCollection">ToolCollection</a>. It supports loading either a collection from the Hub or an MCP server tools.',Zt,Te,Ht,Ue,jl=`You can leverage it with the slug of the collection you want to use.
Then pass them as a list to initialize your agent, and start using them!`,kt,Je,Gt,ve,Cl="To speed up the start, tools are loaded only if called by the agent.",xt,je,Bt,Ce,$l='Leverage tools from the hundreds of MCP servers available on <a href="https://glama.ai/mcp/servers" rel="nofollow">glama.ai</a> or <a href="https://smithery.ai/" rel="nofollow">smithery.ai</a>.',Wt,I,Rt,$e,_l='The MCP servers tools can be loaded with <a href="/docs/smolagents/pr_1175/en/reference/tools#smolagents.ToolCollection.from_mcp">ToolCollection.from_mcp()</a>.',Vt,_e,Il="For stdio-based MCP servers, pass the server parameters as an instance of <code>mcp.StdioServerParameters</code>:",Qt,Ie,Et,Ze,Zl="For SSE-based MCP servers, simply pass a dict with parameters to <code>mcp.client.sse.sse_client</code>:",Nt,He,St,ke,At,Be,Lt;return U=new v({props:{title:"Tools",local:"tools",headingTag:"h1"}}),w=new Sl({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/tools.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/pytorch/tools.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/tensorflow/tools.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/tools.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/pytorch/tools.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/tensorflow/tools.ipynb"}]}}),$=new qt({props:{warning:!1,$$slots:{default:[Ll]},$$scope:{ctx:j}}}),k=new v({props:{title:"What is a tool, and how to build one?",local:"what-is-a-tool-and-how-to-build-one",headingTag:"h3"}}),V=new T({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBUb29sJTBBJTBBY2xhc3MlMjBIRk1vZGVsRG93bmxvYWRzVG9vbChUb29sKSUzQSUwQSUyMCUyMCUyMCUyMG5hbWUlMjAlM0QlMjAlMjJtb2RlbF9kb3dubG9hZF9jb3VudGVyJTIyJTBBJTIwJTIwJTIwJTIwZGVzY3JpcHRpb24lMjAlM0QlMjAlMjIlMjIlMjIlMEElMjAlMjAlMjAlMjBUaGlzJTIwaXMlMjBhJTIwdG9vbCUyMHRoYXQlMjByZXR1cm5zJTIwdGhlJTIwbW9zdCUyMGRvd25sb2FkZWQlMjBtb2RlbCUyMG9mJTIwYSUyMGdpdmVuJTIwdGFzayUyMG9uJTIwdGhlJTIwSHVnZ2luZyUyMEZhY2UlMjBIdWIuJTBBJTIwJTIwJTIwJTIwSXQlMjByZXR1cm5zJTIwdGhlJTIwbmFtZSUyMG9mJTIwdGhlJTIwY2hlY2twb2ludC4lMjIlMjIlMjIlMEElMjAlMjAlMjAlMjBpbnB1dHMlMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ0YXNrJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydHlwZSUyMiUzQSUyMCUyMnN0cmluZyUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmRlc2NyaXB0aW9uJTIyJTNBJTIwJTIydGhlJTIwdGFzayUyMGNhdGVnb3J5JTIwKHN1Y2glMjBhcyUyMHRleHQtY2xhc3NpZmljYXRpb24lMkMlMjBkZXB0aC1lc3RpbWF0aW9uJTJDJTIwZXRjKSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCUyMCUyMG91dHB1dF90eXBlJTIwJTNEJTIwJTIyc3RyaW5nJTIyJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwZm9yd2FyZChzZWxmJTJDJTIwdGFzayUzQSUyMHN0ciklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmcm9tJTIwaHVnZ2luZ2ZhY2VfaHViJTIwaW1wb3J0JTIwbGlzdF9tb2RlbHMlMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtb2RlbCUyMCUzRCUyMG5leHQoaXRlcihsaXN0X21vZGVscyhmaWx0ZXIlM0R0YXNrJTJDJTIwc29ydCUzRCUyMmRvd25sb2FkcyUyMiUyQyUyMGRpcmVjdGlvbiUzRC0xKSkpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwbW9kZWwuaWQlMEElMEFtb2RlbF9kb3dubG9hZHNfdG9vbCUyMCUzRCUyMEhGTW9kZWxEb3dubG9hZHNUb29sKCk=",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> Tool

<span class="hljs-keyword">class</span> <span class="hljs-title class_">HFModelDownloadsTool</span>(<span class="hljs-title class_ inherited__">Tool</span>):
    name = <span class="hljs-string">&quot;model_download_counter&quot;</span>
    description = <span class="hljs-string">&quot;&quot;&quot;
    This is a tool that returns the most downloaded model of a given task on the Hugging Face Hub.
    It returns the name of the checkpoint.&quot;&quot;&quot;</span>
    inputs = {
        <span class="hljs-string">&quot;task&quot;</span>: {
            <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>,
            <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;the task category (such as text-classification, depth-estimation, etc)&quot;</span>,
        }
    }
    output_type = <span class="hljs-string">&quot;string&quot;</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, task: <span class="hljs-built_in">str</span></span>):
        <span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> list_models

        model = <span class="hljs-built_in">next</span>(<span class="hljs-built_in">iter</span>(list_models(<span class="hljs-built_in">filter</span>=task, sort=<span class="hljs-string">&quot;downloads&quot;</span>, direction=-<span class="hljs-number">1</span>)))
        <span class="hljs-keyword">return</span> model.<span class="hljs-built_in">id</span>

model_downloads_tool = HFModelDownloadsTool()`,wrap:!1}}),L=new v({props:{title:"Share your tool to the Hub",local:"share-your-tool-to-the-hub",headingTag:"h3"}}),q=new T({props:{code:"bW9kZWxfZG93bmxvYWRzX3Rvb2wucHVzaF90b19odWIoJTIyJTdCeW91cl91c2VybmFtZSU3RCUyRmhmLW1vZGVsLWRvd25sb2FkcyUyMiUyQyUyMHRva2VuJTNEJTIyJTNDWU9VUl9IVUdHSU5HRkFDRUhVQl9BUElfVE9LRU4lM0UlMjIp",highlighted:'model_downloads_tool.push_to_hub(<span class="hljs-string">&quot;{your_username}/hf-model-downloads&quot;</span>, token=<span class="hljs-string">&quot;&lt;YOUR_HUGGINGFACEHUB_API_TOKEN&gt;&quot;</span>)',wrap:!1}}),K=new T({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBsb2FkX3Rvb2wlMkMlMjBDb2RlQWdlbnQlMEElMEFtb2RlbF9kb3dubG9hZF90b29sJTIwJTNEJTIwbG9hZF90b29sKCUwQSUyMCUyMCUyMCUyMCUyMiU3QnlvdXJfdXNlcm5hbWUlN0QlMkZoZi1tb2RlbC1kb3dubG9hZHMlMjIlMkMlMEElMjAlMjAlMjAlMjB0cnVzdF9yZW1vdGVfY29kZSUzRFRydWUlMEEp",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> load_tool, CodeAgent

model_download_tool = load_tool(
    <span class="hljs-string">&quot;{your_username}/hf-model-downloads&quot;</span>,
    trust_remote_code=<span class="hljs-literal">True</span>
)`,wrap:!1}}),O=new v({props:{title:"Import a Space as a tool",local:"import-a-space-as-a-tool",headingTag:"h3"}}),oe=new T({props:{code:"aW1hZ2VfZ2VuZXJhdGlvbl90b29sJTIwJTNEJTIwVG9vbC5mcm9tX3NwYWNlKCUwQSUyMCUyMCUyMCUyMCUyMmJsYWNrLWZvcmVzdC1sYWJzJTJGRkxVWC4xLXNjaG5lbGwlMjIlMkMlMEElMjAlMjAlMjAlMjBuYW1lJTNEJTIyaW1hZ2VfZ2VuZXJhdG9yJTIyJTJDJTBBJTIwJTIwJTIwJTIwZGVzY3JpcHRpb24lM0QlMjJHZW5lcmF0ZSUyMGFuJTIwaW1hZ2UlMjBmcm9tJTIwYSUyMHByb21wdCUyMiUwQSklMEElMEFpbWFnZV9nZW5lcmF0aW9uX3Rvb2woJTIyQSUyMHN1bm55JTIwYmVhY2glMjIp",highlighted:`image_generation_tool = Tool.from_space(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-schnell&quot;</span>,
    name=<span class="hljs-string">&quot;image_generator&quot;</span>,
    description=<span class="hljs-string">&quot;Generate an image from a prompt&quot;</span>
)

image_generation_tool(<span class="hljs-string">&quot;A sunny beach&quot;</span>)`,wrap:!1}}),ae=new T({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBDb2RlQWdlbnQlMkMlMjBIZkFwaU1vZGVsJTBBJTBBbW9kZWwlMjAlM0QlMjBIZkFwaU1vZGVsKG1vZGVsX2lkJTNEJTIyUXdlbiUyRlF3ZW4yLjUtQ29kZXItMzJCLUluc3RydWN0JTIyKSUwQWFnZW50JTIwJTNEJTIwQ29kZUFnZW50KHRvb2xzJTNEJTVCaW1hZ2VfZ2VuZXJhdGlvbl90b29sJTVEJTJDJTIwbW9kZWwlM0Rtb2RlbCklMEElMEFhZ2VudC5ydW4oJTBBJTIwJTIwJTIwJTIwJTIySW1wcm92ZSUyMHRoaXMlMjBwcm9tcHQlMkMlMjB0aGVuJTIwZ2VuZXJhdGUlMjBhbiUyMGltYWdlJTIwb2YlMjBpdC4lMjIlMkMlMjBhZGRpdGlvbmFsX2FyZ3MlM0QlN0IndXNlcl9wcm9tcHQnJTNBJTIwJ0ElMjByYWJiaXQlMjB3ZWFyaW5nJTIwYSUyMHNwYWNlJTIwc3VpdCclN0QlMEEp",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent, HfApiModel

model = HfApiModel(model_id=<span class="hljs-string">&quot;Qwen/Qwen2.5-Coder-32B-Instruct&quot;</span>)
agent = CodeAgent(tools=[image_generation_tool], model=model)

agent.run(
    <span class="hljs-string">&quot;Improve this prompt, then generate an image of it.&quot;</span>, additional_args={<span class="hljs-string">&#x27;user_prompt&#x27;</span>: <span class="hljs-string">&#x27;A rabbit wearing a space suit&#x27;</span>}
)`,wrap:!1}}),ie=new T({props:{code:"JTBBQWdlbnQlMjBpcyUyMGV4ZWN1dGluZyUyMHRoZSUyMGNvZGUlMjBiZWxvdyUzQQ==",highlighted:`=== Agent thoughts:
improved_prompt could be &quot;A bright blue space suit wearing rabbit, on the surface of the moon, under a bright orange sunset, with the Earth visible in the background&quot;

Now that I have improved the prompt, I can use the image generator tool to generate an image based on this prompt.
&gt;&gt;&gt; Agent is executing the code below:
image = image_generator(prompt=&quot;A bright blue space suit wearing rabbit, on the surface of the moon, under a bright orange sunset, with the Earth visible in the background&quot;)
final_answer(image)`,wrap:!1}}),pe=new v({props:{title:"Use LangChain tools",local:"use-langchain-tools",headingTag:"h3"}}),ce=new T({props:{code:"ZnJvbSUyMGxhbmdjaGFpbi5hZ2VudHMlMjBpbXBvcnQlMjBsb2FkX3Rvb2xzJTBBJTBBc2VhcmNoX3Rvb2wlMjAlM0QlMjBUb29sLmZyb21fbGFuZ2NoYWluKGxvYWRfdG9vbHMoJTVCJTIyc2VycGFwaSUyMiU1RCklNUIwJTVEKSUwQSUwQWFnZW50JTIwJTNEJTIwQ29kZUFnZW50KHRvb2xzJTNEJTVCc2VhcmNoX3Rvb2wlNUQlMkMlMjBtb2RlbCUzRG1vZGVsKSUwQSUwQWFnZW50LnJ1biglMjJIb3clMjBtYW55JTIwbW9yZSUyMGJsb2NrcyUyMChhbHNvJTIwZGVub3RlZCUyMGFzJTIwbGF5ZXJzKSUyMGFyZSUyMGluJTIwQkVSVCUyMGJhc2UlMjBlbmNvZGVyJTIwY29tcGFyZWQlMjB0byUyMHRoZSUyMGVuY29kZXIlMjBmcm9tJTIwdGhlJTIwYXJjaGl0ZWN0dXJlJTIwcHJvcG9zZWQlMjBpbiUyMEF0dGVudGlvbiUyMGlzJTIwQWxsJTIwWW91JTIwTmVlZCUzRiUyMik=",highlighted:`<span class="hljs-keyword">from</span> langchain.agents <span class="hljs-keyword">import</span> load_tools

search_tool = Tool.from_langchain(load_tools([<span class="hljs-string">&quot;serpapi&quot;</span>])[<span class="hljs-number">0</span>])

agent = CodeAgent(tools=[search_tool], model=model)

agent.run(<span class="hljs-string">&quot;How many more blocks (also denoted as layers) are in BERT base encoder compared to the encoder from the architecture proposed in Attention is All You Need?&quot;</span>)`,wrap:!1}}),me=new v({props:{title:"Manage your agent’s toolbox",local:"manage-your-agents-toolbox",headingTag:"h3"}}),ye=new T({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBIZkFwaU1vZGVsJTBBJTBBbW9kZWwlMjAlM0QlMjBIZkFwaU1vZGVsKG1vZGVsX2lkJTNEJTIyUXdlbiUyRlF3ZW4yLjUtQ29kZXItMzJCLUluc3RydWN0JTIyKSUwQSUwQWFnZW50JTIwJTNEJTIwQ29kZUFnZW50KHRvb2xzJTNEJTVCJTVEJTJDJTIwbW9kZWwlM0Rtb2RlbCUyQyUyMGFkZF9iYXNlX3Rvb2xzJTNEVHJ1ZSklMEFhZ2VudC50b29scyU1Qm1vZGVsX2Rvd25sb2FkX3Rvb2wubmFtZSU1RCUyMCUzRCUyMG1vZGVsX2Rvd25sb2FkX3Rvb2w=",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> HfApiModel

model = HfApiModel(model_id=<span class="hljs-string">&quot;Qwen/Qwen2.5-Coder-32B-Instruct&quot;</span>)

agent = CodeAgent(tools=[], model=model, add_base_tools=<span class="hljs-literal">True</span>)
agent.tools[model_download_tool.name] = model_download_tool`,wrap:!1}}),fe=new T({props:{code:"YWdlbnQucnVuKCUwQSUyMCUyMCUyMCUyMCUyMkNhbiUyMHlvdSUyMGdpdmUlMjBtZSUyMHRoZSUyMG5hbWUlMjBvZiUyMHRoZSUyMG1vZGVsJTIwdGhhdCUyMGhhcyUyMHRoZSUyMG1vc3QlMjBkb3dubG9hZHMlMjBpbiUyMHRoZSUyMCd0ZXh0LXRvLXZpZGVvJyUyMHRhc2slMjBvbiUyMHRoZSUyMEh1Z2dpbmclMjBGYWNlJTIwSHViJTIwYnV0JTIwcmV2ZXJzZSUyMHRoZSUyMGxldHRlcnMlM0YlMjIlMEEp",highlighted:`agent.run(
    <span class="hljs-string">&quot;Can you give me the name of the model that has the most downloads in the &#x27;text-to-video&#x27; task on the Hugging Face Hub but reverse the letters?&quot;</span>
)`,wrap:!1}}),_=new qt({props:{warning:!1,$$slots:{default:[Fl]},$$scope:{ctx:j}}}),we=new v({props:{title:"Use a collection of tools",local:"use-a-collection-of-tools",headingTag:"h3"}}),Te=new v({props:{title:"Tool Collection from a collection in the Hub",local:"tool-collection-from-a-collection-in-the-hub",headingTag:"h4"}}),Je=new T({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBUb29sQ29sbGVjdGlvbiUyQyUyMENvZGVBZ2VudCUwQSUwQWltYWdlX3Rvb2xfY29sbGVjdGlvbiUyMCUzRCUyMFRvb2xDb2xsZWN0aW9uLmZyb21faHViKCUwQSUyMCUyMCUyMCUyMGNvbGxlY3Rpb25fc2x1ZyUzRCUyMmh1Z2dpbmdmYWNlLXRvb2xzJTJGZGlmZnVzaW9uLXRvb2xzLTY2MzBiYjE5YTk0MmMyMzA2YTJjZGI2ZiUyMiUyQyUwQSUyMCUyMCUyMCUyMHRva2VuJTNEJTIyJTNDWU9VUl9IVUdHSU5HRkFDRUhVQl9BUElfVE9LRU4lM0UlMjIlMEEpJTBBYWdlbnQlMjAlM0QlMjBDb2RlQWdlbnQodG9vbHMlM0QlNUIqaW1hZ2VfdG9vbF9jb2xsZWN0aW9uLnRvb2xzJTVEJTJDJTIwbW9kZWwlM0Rtb2RlbCUyQyUyMGFkZF9iYXNlX3Rvb2xzJTNEVHJ1ZSklMEElMEFhZ2VudC5ydW4oJTIyUGxlYXNlJTIwZHJhdyUyMG1lJTIwYSUyMHBpY3R1cmUlMjBvZiUyMHJpdmVycyUyMGFuZCUyMGxha2VzLiUyMik=",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> ToolCollection, CodeAgent

image_tool_collection = ToolCollection.from_hub(
    collection_slug=<span class="hljs-string">&quot;huggingface-tools/diffusion-tools-6630bb19a942c2306a2cdb6f&quot;</span>,
    token=<span class="hljs-string">&quot;&lt;YOUR_HUGGINGFACEHUB_API_TOKEN&gt;&quot;</span>
)
agent = CodeAgent(tools=[*image_tool_collection.tools], model=model, add_base_tools=<span class="hljs-literal">True</span>)

agent.run(<span class="hljs-string">&quot;Please draw me a picture of rivers and lakes.&quot;</span>)`,wrap:!1}}),je=new v({props:{title:"Tool Collection from any MCP server",local:"tool-collection-from-any-mcp-server",headingTag:"h4"}}),I=new qt({props:{warning:!0,$$slots:{default:[ql]},$$scope:{ctx:j}}}),Ie=new T({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBUb29sQ29sbGVjdGlvbiUyQyUyMENvZGVBZ2VudCUwQWZyb20lMjBtY3AlMjBpbXBvcnQlMjBTdGRpb1NlcnZlclBhcmFtZXRlcnMlMEElMEFzZXJ2ZXJfcGFyYW1ldGVycyUyMCUzRCUyMFN0ZGlvU2VydmVyUGFyYW1ldGVycyglMEElMjAlMjAlMjAlMjBjb21tYW5kJTNEJTIydXZ4JTIyJTJDJTBBJTIwJTIwJTIwJTIwYXJncyUzRCU1QiUyMi0tcXVpZXQlMjIlMkMlMjAlMjJwdWJtZWRtY3AlNDAwLjEuMyUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMGVudiUzRCU3QiUyMlVWX1BZVEhPTiUyMiUzQSUyMCUyMjMuMTIlMjIlMkMlMjAqKm9zLmVudmlyb24lN0QlMkMlMEEpJTBBJTBBd2l0aCUyMFRvb2xDb2xsZWN0aW9uLmZyb21fbWNwKHNlcnZlcl9wYXJhbWV0ZXJzJTJDJTIwdHJ1c3RfcmVtb3RlX2NvZGUlM0RUcnVlKSUyMGFzJTIwdG9vbF9jb2xsZWN0aW9uJTNBJTBBJTIwJTIwJTIwJTIwYWdlbnQlMjAlM0QlMjBDb2RlQWdlbnQodG9vbHMlM0QlNUIqdG9vbF9jb2xsZWN0aW9uLnRvb2xzJTVEJTJDJTIwbW9kZWwlM0Rtb2RlbCUyQyUyMGFkZF9iYXNlX3Rvb2xzJTNEVHJ1ZSklMEElMjAlMjAlMjAlMjBhZ2VudC5ydW4oJTIyUGxlYXNlJTIwZmluZCUyMGElMjByZW1lZHklMjBmb3IlMjBoYW5nb3Zlci4lMjIp",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> ToolCollection, CodeAgent
<span class="hljs-keyword">from</span> mcp <span class="hljs-keyword">import</span> StdioServerParameters

server_parameters = StdioServerParameters(
    command=<span class="hljs-string">&quot;uvx&quot;</span>,
    args=[<span class="hljs-string">&quot;--quiet&quot;</span>, <span class="hljs-string">&quot;pubmedmcp@0.1.3&quot;</span>],
    env={<span class="hljs-string">&quot;UV_PYTHON&quot;</span>: <span class="hljs-string">&quot;3.12&quot;</span>, **os.environ},
)

<span class="hljs-keyword">with</span> ToolCollection.from_mcp(server_parameters, trust_remote_code=<span class="hljs-literal">True</span>) <span class="hljs-keyword">as</span> tool_collection:
    agent = CodeAgent(tools=[*tool_collection.tools], model=model, add_base_tools=<span class="hljs-literal">True</span>)
    agent.run(<span class="hljs-string">&quot;Please find a remedy for hangover.&quot;</span>)`,wrap:!1}}),He=new T({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBUb29sQ29sbGVjdGlvbiUyQyUyMENvZGVBZ2VudCUwQSUwQXdpdGglMjBUb29sQ29sbGVjdGlvbi5mcm9tX21jcCglN0IlMjJ1cmwlMjIlM0ElMjAlMjJodHRwJTNBJTJGJTJGMTI3LjAuMC4xJTNBODAwMCUyRnNzZSUyMiU3RCUyQyUyMHRydXN0X3JlbW90ZV9jb2RlJTNEVHJ1ZSklMjBhcyUyMHRvb2xfY29sbGVjdGlvbiUzQSUwQSUyMCUyMCUyMCUyMGFnZW50JTIwJTNEJTIwQ29kZUFnZW50KHRvb2xzJTNEJTVCKnRvb2xfY29sbGVjdGlvbi50b29scyU1RCUyQyUyMGFkZF9iYXNlX3Rvb2xzJTNEVHJ1ZSklMEElMjAlMjAlMjAlMjBhZ2VudC5ydW4oJTIyUGxlYXNlJTIwZmluZCUyMGElMjByZW1lZHklMjBmb3IlMjBoYW5nb3Zlci4lMjIp",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> ToolCollection, CodeAgent

<span class="hljs-keyword">with</span> ToolCollection.from_mcp({<span class="hljs-string">&quot;url&quot;</span>: <span class="hljs-string">&quot;http://127.0.0.1:8000/sse&quot;</span>}, trust_remote_code=<span class="hljs-literal">True</span>) <span class="hljs-keyword">as</span> tool_collection:
    agent = CodeAgent(tools=[*tool_collection.tools], add_base_tools=<span class="hljs-literal">True</span>)
    agent.run(<span class="hljs-string">&quot;Please find a remedy for hangover.&quot;</span>)`,wrap:!1}}),ke=new Al({props:{source:"https://github.com/huggingface/smolagents/blob/main/docs/source/en/tutorials/tools.mdx"}}),{c(){p=a("meta"),g=s(),y=a("p"),f=s(),u(U.$$.fragment),J=s(),u(w.$$.fragment),Z=s(),b=a("p"),b.textContent=C,We=s(),u($.$$.fragment),Re=s(),H=a("ul"),H.innerHTML=Yt,Ve=s(),u(k.$$.fragment),Qe=s(),G=a("p"),G.textContent=zt,Ee=s(),x=a("p"),x.textContent=Pt,Ne=s(),B=a("p"),B.textContent=Dt,Se=s(),W=a("p"),W.textContent=Kt,Ae=s(),R=a("p"),R.textContent=Ot,Le=s(),u(V.$$.fragment),Fe=s(),Q=a("p"),Q.innerHTML=el,qe=s(),E=a("ul"),E.innerHTML=tl,Xe=s(),N=a("p"),N.textContent=ll,Ye=s(),S=a("p"),S.innerHTML=ol,ze=s(),A=a("p"),A.innerHTML=sl,Pe=s(),u(L.$$.fragment),De=s(),F=a("p"),F.innerHTML=nl,Ke=s(),u(q.$$.fragment),Oe=s(),X=a("p"),X.textContent=al,et=s(),Y=a("ul"),Y.innerHTML=il,tt=s(),z=a("p"),z.innerHTML=rl,lt=s(),P=a("p"),P.innerHTML=pl,ot=s(),D=a("p"),D.innerHTML=ul,st=s(),u(K.$$.fragment),nt=s(),u(O.$$.fragment),at=s(),ee=a("p"),ee.innerHTML=dl,it=s(),te=a("p"),te.innerHTML=cl,rt=s(),le=a("p"),le.innerHTML=ml,pt=s(),u(oe.$$.fragment),ut=s(),se=a("p"),se.textContent=hl,dt=s(),Ge=a("img"),ct=s(),ne=a("p"),ne.innerHTML=yl,mt=s(),u(ae.$$.fragment),ht=s(),u(ie.$$.fragment),Mt=s(),xe=a("img"),yt=s(),re=a("p"),re.textContent=fl,bt=s(),u(pe.$$.fragment),ft=s(),ue=a("p"),ue.innerHTML=wl,wt=s(),de=a("p"),de.innerHTML=gl,gt=s(),u(ce.$$.fragment),Tt=s(),u(me.$$.fragment),Ut=s(),he=a("p"),he.innerHTML=Tl,Jt=s(),Me=a("p"),Me.innerHTML=Ul,vt=s(),u(ye.$$.fragment),jt=s(),be=a("p"),be.textContent=Jl,Ct=s(),u(fe.$$.fragment),$t=s(),u(_.$$.fragment),_t=s(),u(we.$$.fragment),It=s(),ge=a("p"),ge.innerHTML=vl,Zt=s(),u(Te.$$.fragment),Ht=s(),Ue=a("p"),Ue.textContent=jl,kt=s(),u(Je.$$.fragment),Gt=s(),ve=a("p"),ve.textContent=Cl,xt=s(),u(je.$$.fragment),Bt=s(),Ce=a("p"),Ce.innerHTML=$l,Wt=s(),u(I.$$.fragment),Rt=s(),$e=a("p"),$e.innerHTML=_l,Vt=s(),_e=a("p"),_e.innerHTML=Il,Qt=s(),u(Ie.$$.fragment),Et=s(),Ze=a("p"),Ze.innerHTML=Zl,Nt=s(),u(He.$$.fragment),St=s(),u(ke.$$.fragment),At=s(),Be=a("p"),this.h()},l(e){const t=El("svelte-u9bgzb",document.head);p=i(t,"META",{name:!0,content:!0}),t.forEach(l),g=n(e),y=i(e,"P",{}),Bl(y).forEach(l),f=n(e),d(U.$$.fragment,e),J=n(e),d(w.$$.fragment,e),Z=n(e),b=i(e,"P",{"data-svelte-h":!0}),r(b)!=="svelte-8951oz"&&(b.textContent=C),We=n(e),d($.$$.fragment,e),Re=n(e),H=i(e,"UL",{"data-svelte-h":!0}),r(H)!=="svelte-gdosxb"&&(H.innerHTML=Yt),Ve=n(e),d(k.$$.fragment,e),Qe=n(e),G=i(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-50z9h0"&&(G.textContent=zt),Ee=n(e),x=i(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-1llqfcr"&&(x.textContent=Pt),Ne=n(e),B=i(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-eilpgu"&&(B.textContent=Dt),Se=n(e),W=i(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-suz7fy"&&(W.textContent=Kt),Ae=n(e),R=i(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-x18ywb"&&(R.textContent=Ot),Le=n(e),d(V.$$.fragment,e),Fe=n(e),Q=i(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-ejy829"&&(Q.innerHTML=el),qe=n(e),E=i(e,"UL",{"data-svelte-h":!0}),r(E)!=="svelte-xqgwuf"&&(E.innerHTML=tl),Xe=n(e),N=i(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-220ayw"&&(N.textContent=ll),Ye=n(e),S=i(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-1rcx9j7"&&(S.innerHTML=ol),ze=n(e),A=i(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-13yqhn"&&(A.innerHTML=sl),Pe=n(e),d(L.$$.fragment,e),De=n(e),F=i(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-1bamkn1"&&(F.innerHTML=nl),Ke=n(e),d(q.$$.fragment,e),Oe=n(e),X=i(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-hoocvd"&&(X.textContent=al),et=n(e),Y=i(e,"UL",{"data-svelte-h":!0}),r(Y)!=="svelte-lsf3kp"&&(Y.innerHTML=il),tt=n(e),z=i(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-4n5s3c"&&(z.innerHTML=rl),lt=n(e),P=i(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-1knl8v8"&&(P.innerHTML=pl),ot=n(e),D=i(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-cjkufs"&&(D.innerHTML=ul),st=n(e),d(K.$$.fragment,e),nt=n(e),d(O.$$.fragment,e),at=n(e),ee=i(e,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-10sg3cj"&&(ee.innerHTML=dl),it=n(e),te=i(e,"P",{"data-svelte-h":!0}),r(te)!=="svelte-1xkj0c9"&&(te.innerHTML=cl),rt=n(e),le=i(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-1gucs20"&&(le.innerHTML=ml),pt=n(e),d(oe.$$.fragment,e),ut=n(e),se=i(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-sgspwr"&&(se.textContent=hl),dt=n(e),Ge=i(e,"IMG",{src:!0}),ct=n(e),ne=i(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-1qp1ya7"&&(ne.innerHTML=yl),mt=n(e),d(ae.$$.fragment,e),ht=n(e),d(ie.$$.fragment,e),Mt=n(e),xe=i(e,"IMG",{src:!0}),yt=n(e),re=i(e,"P",{"data-svelte-h":!0}),r(re)!=="svelte-i5dtbz"&&(re.textContent=fl),bt=n(e),d(pe.$$.fragment,e),ft=n(e),ue=i(e,"P",{"data-svelte-h":!0}),r(ue)!=="svelte-1rq40pf"&&(ue.innerHTML=wl),wt=n(e),de=i(e,"P",{"data-svelte-h":!0}),r(de)!=="svelte-1g7jkvd"&&(de.innerHTML=gl),gt=n(e),d(ce.$$.fragment,e),Tt=n(e),d(me.$$.fragment,e),Ut=n(e),he=i(e,"P",{"data-svelte-h":!0}),r(he)!=="svelte-69p3x"&&(he.innerHTML=Tl),Jt=n(e),Me=i(e,"P",{"data-svelte-h":!0}),r(Me)!=="svelte-ocb8u2"&&(Me.innerHTML=Ul),vt=n(e),d(ye.$$.fragment,e),jt=n(e),be=i(e,"P",{"data-svelte-h":!0}),r(be)!=="svelte-o3ledg"&&(be.textContent=Jl),Ct=n(e),d(fe.$$.fragment,e),$t=n(e),d(_.$$.fragment,e),_t=n(e),d(we.$$.fragment,e),It=n(e),ge=i(e,"P",{"data-svelte-h":!0}),r(ge)!=="svelte-1vkif70"&&(ge.innerHTML=vl),Zt=n(e),d(Te.$$.fragment,e),Ht=n(e),Ue=i(e,"P",{"data-svelte-h":!0}),r(Ue)!=="svelte-qubpc6"&&(Ue.textContent=jl),kt=n(e),d(Je.$$.fragment,e),Gt=n(e),ve=i(e,"P",{"data-svelte-h":!0}),r(ve)!=="svelte-6r1jgt"&&(ve.textContent=Cl),xt=n(e),d(je.$$.fragment,e),Bt=n(e),Ce=i(e,"P",{"data-svelte-h":!0}),r(Ce)!=="svelte-1q39vf"&&(Ce.innerHTML=$l),Wt=n(e),d(I.$$.fragment,e),Rt=n(e),$e=i(e,"P",{"data-svelte-h":!0}),r($e)!=="svelte-83frba"&&($e.innerHTML=_l),Vt=n(e),_e=i(e,"P",{"data-svelte-h":!0}),r(_e)!=="svelte-s0gh2b"&&(_e.innerHTML=Il),Qt=n(e),d(Ie.$$.fragment,e),Et=n(e),Ze=i(e,"P",{"data-svelte-h":!0}),r(Ze)!=="svelte-1skatdh"&&(Ze.innerHTML=Zl),Nt=n(e),d(He.$$.fragment,e),St=n(e),d(ke.$$.fragment,e),At=n(e),Be=i(e,"P",{}),Bl(Be).forEach(l),this.h()},h(){Ft(p,"name","hf:doc:metadata"),Ft(p,"content",Yl),xl(Ge.src,Ml="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/sunny_beach.webp")||Ft(Ge,"src",Ml),xl(xe.src,bl="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/rabbit_spacesuit_flux.webp")||Ft(xe,"src",bl)},m(e,t){Nl(document.head,p),o(e,g,t),o(e,y,t),o(e,f,t),c(U,e,t),o(e,J,t),c(w,e,t),o(e,Z,t),o(e,b,t),o(e,We,t),c($,e,t),o(e,Re,t),o(e,H,t),o(e,Ve,t),c(k,e,t),o(e,Qe,t),o(e,G,t),o(e,Ee,t),o(e,x,t),o(e,Ne,t),o(e,B,t),o(e,Se,t),o(e,W,t),o(e,Ae,t),o(e,R,t),o(e,Le,t),c(V,e,t),o(e,Fe,t),o(e,Q,t),o(e,qe,t),o(e,E,t),o(e,Xe,t),o(e,N,t),o(e,Ye,t),o(e,S,t),o(e,ze,t),o(e,A,t),o(e,Pe,t),c(L,e,t),o(e,De,t),o(e,F,t),o(e,Ke,t),c(q,e,t),o(e,Oe,t),o(e,X,t),o(e,et,t),o(e,Y,t),o(e,tt,t),o(e,z,t),o(e,lt,t),o(e,P,t),o(e,ot,t),o(e,D,t),o(e,st,t),c(K,e,t),o(e,nt,t),c(O,e,t),o(e,at,t),o(e,ee,t),o(e,it,t),o(e,te,t),o(e,rt,t),o(e,le,t),o(e,pt,t),c(oe,e,t),o(e,ut,t),o(e,se,t),o(e,dt,t),o(e,Ge,t),o(e,ct,t),o(e,ne,t),o(e,mt,t),c(ae,e,t),o(e,ht,t),c(ie,e,t),o(e,Mt,t),o(e,xe,t),o(e,yt,t),o(e,re,t),o(e,bt,t),c(pe,e,t),o(e,ft,t),o(e,ue,t),o(e,wt,t),o(e,de,t),o(e,gt,t),c(ce,e,t),o(e,Tt,t),c(me,e,t),o(e,Ut,t),o(e,he,t),o(e,Jt,t),o(e,Me,t),o(e,vt,t),c(ye,e,t),o(e,jt,t),o(e,be,t),o(e,Ct,t),c(fe,e,t),o(e,$t,t),c(_,e,t),o(e,_t,t),c(we,e,t),o(e,It,t),o(e,ge,t),o(e,Zt,t),c(Te,e,t),o(e,Ht,t),o(e,Ue,t),o(e,kt,t),c(Je,e,t),o(e,Gt,t),o(e,ve,t),o(e,xt,t),c(je,e,t),o(e,Bt,t),o(e,Ce,t),o(e,Wt,t),c(I,e,t),o(e,Rt,t),o(e,$e,t),o(e,Vt,t),o(e,_e,t),o(e,Qt,t),c(Ie,e,t),o(e,Et,t),o(e,Ze,t),o(e,Nt,t),c(He,e,t),o(e,St,t),c(ke,e,t),o(e,At,t),o(e,Be,t),Lt=!0},p(e,[t]){const Hl={};t&2&&(Hl.$$scope={dirty:t,ctx:e}),$.$set(Hl);const kl={};t&2&&(kl.$$scope={dirty:t,ctx:e}),_.$set(kl);const Gl={};t&2&&(Gl.$$scope={dirty:t,ctx:e}),I.$set(Gl)},i(e){Lt||(m(U.$$.fragment,e),m(w.$$.fragment,e),m($.$$.fragment,e),m(k.$$.fragment,e),m(V.$$.fragment,e),m(L.$$.fragment,e),m(q.$$.fragment,e),m(K.$$.fragment,e),m(O.$$.fragment,e),m(oe.$$.fragment,e),m(ae.$$.fragment,e),m(ie.$$.fragment,e),m(pe.$$.fragment,e),m(ce.$$.fragment,e),m(me.$$.fragment,e),m(ye.$$.fragment,e),m(fe.$$.fragment,e),m(_.$$.fragment,e),m(we.$$.fragment,e),m(Te.$$.fragment,e),m(Je.$$.fragment,e),m(je.$$.fragment,e),m(I.$$.fragment,e),m(Ie.$$.fragment,e),m(He.$$.fragment,e),m(ke.$$.fragment,e),Lt=!0)},o(e){h(U.$$.fragment,e),h(w.$$.fragment,e),h($.$$.fragment,e),h(k.$$.fragment,e),h(V.$$.fragment,e),h(L.$$.fragment,e),h(q.$$.fragment,e),h(K.$$.fragment,e),h(O.$$.fragment,e),h(oe.$$.fragment,e),h(ae.$$.fragment,e),h(ie.$$.fragment,e),h(pe.$$.fragment,e),h(ce.$$.fragment,e),h(me.$$.fragment,e),h(ye.$$.fragment,e),h(fe.$$.fragment,e),h(_.$$.fragment,e),h(we.$$.fragment,e),h(Te.$$.fragment,e),h(Je.$$.fragment,e),h(je.$$.fragment,e),h(I.$$.fragment,e),h(Ie.$$.fragment,e),h(He.$$.fragment,e),h(ke.$$.fragment,e),Lt=!1},d(e){e&&(l(g),l(y),l(f),l(J),l(Z),l(b),l(We),l(Re),l(H),l(Ve),l(Qe),l(G),l(Ee),l(x),l(Ne),l(B),l(Se),l(W),l(Ae),l(R),l(Le),l(Fe),l(Q),l(qe),l(E),l(Xe),l(N),l(Ye),l(S),l(ze),l(A),l(Pe),l(De),l(F),l(Ke),l(Oe),l(X),l(et),l(Y),l(tt),l(z),l(lt),l(P),l(ot),l(D),l(st),l(nt),l(at),l(ee),l(it),l(te),l(rt),l(le),l(pt),l(ut),l(se),l(dt),l(Ge),l(ct),l(ne),l(mt),l(ht),l(Mt),l(xe),l(yt),l(re),l(bt),l(ft),l(ue),l(wt),l(de),l(gt),l(Tt),l(Ut),l(he),l(Jt),l(Me),l(vt),l(jt),l(be),l(Ct),l($t),l(_t),l(It),l(ge),l(Zt),l(Ht),l(Ue),l(kt),l(Gt),l(ve),l(xt),l(Bt),l(Ce),l(Wt),l(Rt),l($e),l(Vt),l(_e),l(Qt),l(Et),l(Ze),l(Nt),l(St),l(At),l(Be)),l(p),M(U,e),M(w,e),M($,e),M(k,e),M(V,e),M(L,e),M(q,e),M(K,e),M(O,e),M(oe,e),M(ae,e),M(ie,e),M(pe,e),M(ce,e),M(me,e),M(ye,e),M(fe,e),M(_,e),M(we,e),M(Te,e),M(Je,e),M(je,e),M(I,e),M(Ie,e),M(He,e),M(ke,e)}}}const Yl='{"title":"Tools","local":"tools","sections":[{"title":"What is a tool, and how to build one?","local":"what-is-a-tool-and-how-to-build-one","sections":[],"depth":3},{"title":"Share your tool to the Hub","local":"share-your-tool-to-the-hub","sections":[],"depth":3},{"title":"Import a Space as a tool","local":"import-a-space-as-a-tool","sections":[],"depth":3},{"title":"Use LangChain tools","local":"use-langchain-tools","sections":[],"depth":3},{"title":"Manage your agent’s toolbox","local":"manage-your-agents-toolbox","sections":[],"depth":3},{"title":"Use a collection of tools","local":"use-a-collection-of-tools","sections":[{"title":"Tool Collection from a collection in the Hub","local":"tool-collection-from-a-collection-in-the-hub","sections":[],"depth":4},{"title":"Tool Collection from any MCP server","local":"tool-collection-from-any-mcp-server","sections":[],"depth":4}],"depth":3}],"depth":1}';function zl(j){return Rl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class lo extends Vl{constructor(p){super(),Ql(this,p,zl,Xl,Wl,{})}}export{lo as component};
