import{s as en,o as tn,n as L}from"../chunks/scheduler.25b97de1.js";import{S as on,i as nn,g as p,s as l,r as f,A as sn,h as m,f as s,c as i,j as v,u as g,x as y,k as $,y as c,a as d,v as u,d as h,t as _,w as M}from"../chunks/index.d9030fc9.js";import{T as ht}from"../chunks/Tip.baa67368.js";import{D as P}from"../chunks/Docstring.e257edda.js";import{C as Y}from"../chunks/CodeBlock.e6cd0d95.js";import{E as ue}from"../chunks/ExampleCodeBlock.20db4b6e.js";import{H as q,E as an}from"../chunks/EditOnGithub.91d95064.js";function rn(I){let o,C='This model is based on <code>CLIPModel</code>, use it like you would use the original <a href="clip">CLIP</a>.';return{c(){o=p("p"),o.innerHTML=C},l(a){o=m(a,"P",{"data-svelte-h":!0}),y(o)!=="svelte-r1r37q"&&(o.innerHTML=C)},m(a,r){d(a,o,r)},p:L,d(a){a&&s(o)}}}function ln(I){let o,C="Example:",a,r,b;return r=new Y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEFsdENMSVBDb25maWclMkMlMjBBbHRDTElQTW9kZWwlMEElMEElMjMlMjBJbml0aWFsaXppbmclMjBhJTIwQWx0Q0xJUENvbmZpZyUyMHdpdGglMjBCQUFJJTJGQWx0Q0xJUCUyMHN0eWxlJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBBbHRDTElQQ29uZmlnKCklMEElMEElMjMlMjBJbml0aWFsaXppbmclMjBhJTIwQWx0Q0xJUE1vZGVsJTIwKHdpdGglMjByYW5kb20lMjB3ZWlnaHRzKSUyMGZyb20lMjB0aGUlMjBCQUFJJTJGQWx0Q0xJUCUyMHN0eWxlJTIwY29uZmlndXJhdGlvbiUwQW1vZGVsJTIwJTNEJTIwQWx0Q0xJUE1vZGVsKGNvbmZpZ3VyYXRpb24pJTBBJTBBJTIzJTIwQWNjZXNzaW5nJTIwdGhlJTIwbW9kZWwlMjBjb25maWd1cmF0aW9uJTBBY29uZmlndXJhdGlvbiUyMCUzRCUyMG1vZGVsLmNvbmZpZyUwQSUwQSUyMyUyMFdlJTIwY2FuJTIwYWxzbyUyMGluaXRpYWxpemUlMjBhJTIwQWx0Q0xJUENvbmZpZyUyMGZyb20lMjBhJTIwQWx0Q0xJUFRleHRDb25maWclMjBhbmQlMjBhJTIwQWx0Q0xJUFZpc2lvbkNvbmZpZyUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBBbHRDTElQVGV4dCUyMGFuZCUyMEFsdENMSVBWaXNpb24lMjBjb25maWd1cmF0aW9uJTBBY29uZmlnX3RleHQlMjAlM0QlMjBBbHRDTElQVGV4dENvbmZpZygpJTBBY29uZmlnX3Zpc2lvbiUyMCUzRCUyMEFsdENMSVBWaXNpb25Db25maWcoKSUwQSUwQWNvbmZpZyUyMCUzRCUyMEFsdENMSVBDb25maWcuZnJvbV90ZXh0X3Zpc2lvbl9jb25maWdzKGNvbmZpZ190ZXh0JTJDJTIwY29uZmlnX3Zpc2lvbik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AltCLIPConfig, AltCLIPModel

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a AltCLIPConfig with BAAI/AltCLIP style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = AltCLIPConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a AltCLIPModel (with random weights) from the BAAI/AltCLIP style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AltCLIPModel(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># We can also initialize a AltCLIPConfig from a AltCLIPTextConfig and a AltCLIPVisionConfig</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a AltCLIPText and AltCLIPVision configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config_text = AltCLIPTextConfig()
<span class="hljs-meta">&gt;&gt;&gt; </span>config_vision = AltCLIPVisionConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span>config = AltCLIPConfig.from_text_vision_configs(config_text, config_vision)`,wrap:!1}}),{c(){o=p("p"),o.textContent=C,a=l(),f(r.$$.fragment)},l(t){o=m(t,"P",{"data-svelte-h":!0}),y(o)!=="svelte-11lpom8"&&(o.textContent=C),a=i(t),g(r.$$.fragment,t)},m(t,T){d(t,o,T),d(t,a,T),u(r,t,T),b=!0},p:L,i(t){b||(h(r.$$.fragment,t),b=!0)},o(t){_(r.$$.fragment,t),b=!1},d(t){t&&(s(o),s(a)),M(r,t)}}}function dn(I){let o,C="Examples:",a,r,b;return r=new Y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEFsdENMSVBUZXh0TW9kZWwlMkMlMjBBbHRDTElQVGV4dENvbmZpZyUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBBbHRDTElQVGV4dENvbmZpZyUyMHdpdGglMjBCQUFJJTJGQWx0Q0xJUCUyMHN0eWxlJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBBbHRDTElQVGV4dENvbmZpZygpJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyMEFsdENMSVBUZXh0TW9kZWwlMjAod2l0aCUyMHJhbmRvbSUyMHdlaWdodHMpJTIwZnJvbSUyMHRoZSUyMEJBQUklMkZBbHRDTElQJTIwc3R5bGUlMjBjb25maWd1cmF0aW9uJTBBbW9kZWwlMjAlM0QlMjBBbHRDTElQVGV4dE1vZGVsKGNvbmZpZ3VyYXRpb24pJTBBJTBBJTIzJTIwQWNjZXNzaW5nJTIwdGhlJTIwbW9kZWwlMjBjb25maWd1cmF0aW9uJTBBY29uZmlndXJhdGlvbiUyMCUzRCUyMG1vZGVsLmNvbmZpZw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AltCLIPTextModel, AltCLIPTextConfig

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a AltCLIPTextConfig with BAAI/AltCLIP style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = AltCLIPTextConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a AltCLIPTextModel (with random weights) from the BAAI/AltCLIP style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AltCLIPTextModel(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){o=p("p"),o.textContent=C,a=l(),f(r.$$.fragment)},l(t){o=m(t,"P",{"data-svelte-h":!0}),y(o)!=="svelte-kvfsh7"&&(o.textContent=C),a=i(t),g(r.$$.fragment,t)},m(t,T){d(t,o,T),d(t,a,T),u(r,t,T),b=!0},p:L,i(t){b||(h(r.$$.fragment,t),b=!0)},o(t){_(r.$$.fragment,t),b=!1},d(t){t&&(s(o),s(a)),M(r,t)}}}function cn(I){let o,C="Example:",a,r,b;return r=new Y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEFsdENMSVBWaXNpb25Db25maWclMkMlMjBBbHRDTElQVmlzaW9uTW9kZWwlMEElMEElMjMlMjBJbml0aWFsaXppbmclMjBhJTIwQWx0Q0xJUFZpc2lvbkNvbmZpZyUyMHdpdGglMjBCQUFJJTJGQWx0Q0xJUCUyMHN0eWxlJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBBbHRDTElQVmlzaW9uQ29uZmlnKCklMEElMEElMjMlMjBJbml0aWFsaXppbmclMjBhJTIwQWx0Q0xJUFZpc2lvbk1vZGVsJTIwKHdpdGglMjByYW5kb20lMjB3ZWlnaHRzKSUyMGZyb20lMjB0aGUlMjBCQUFJJTJGQWx0Q0xJUCUyMHN0eWxlJTIwY29uZmlndXJhdGlvbiUwQW1vZGVsJTIwJTNEJTIwQWx0Q0xJUFZpc2lvbk1vZGVsKGNvbmZpZ3VyYXRpb24pJTBBJTBBJTIzJTIwQWNjZXNzaW5nJTIwdGhlJTIwbW9kZWwlMjBjb25maWd1cmF0aW9uJTBBY29uZmlndXJhdGlvbiUyMCUzRCUyMG1vZGVsLmNvbmZpZw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AltCLIPVisionConfig, AltCLIPVisionModel

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a AltCLIPVisionConfig with BAAI/AltCLIP style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = AltCLIPVisionConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a AltCLIPVisionModel (with random weights) from the BAAI/AltCLIP style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AltCLIPVisionModel(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){o=p("p"),o.textContent=C,a=l(),f(r.$$.fragment)},l(t){o=m(t,"P",{"data-svelte-h":!0}),y(o)!=="svelte-11lpom8"&&(o.textContent=C),a=i(t),g(r.$$.fragment,t)},m(t,T){d(t,o,T),d(t,a,T),u(r,t,T),b=!0},p:L,i(t){b||(h(r.$$.fragment,t),b=!0)},o(t){_(r.$$.fragment,t),b=!1},d(t){t&&(s(o),s(a)),M(r,t)}}}function pn(I){let o,C=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){o=p("p"),o.innerHTML=C},l(a){o=m(a,"P",{"data-svelte-h":!0}),y(o)!=="svelte-fincs2"&&(o.innerHTML=C)},m(a,r){d(a,o,r)},p:L,d(a){a&&s(o)}}}function mn(I){let o,C="Examples:",a,r,b;return r=new Y({props:{code:"ZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Byb2Nlc3NvciUyQyUyMEFsdENMSVBNb2RlbCUwQSUwQW1vZGVsJTIwJTNEJTIwQWx0Q0xJUE1vZGVsLmZyb21fcHJldHJhaW5lZCglMjJCQUFJJTJGQWx0Q0xJUCUyMiklMEFwcm9jZXNzb3IlMjAlM0QlMjBBdXRvUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJCQUFJJTJGQWx0Q0xJUCUyMiklMEF1cmwlMjAlM0QlMjAlMjJodHRwJTNBJTJGJTJGaW1hZ2VzLmNvY29kYXRhc2V0Lm9yZyUyRnZhbDIwMTclMkYwMDAwMDAwMzk3NjkuanBnJTIyJTBBaW1hZ2UlMjAlM0QlMjBJbWFnZS5vcGVuKHJlcXVlc3RzLmdldCh1cmwlMkMlMjBzdHJlYW0lM0RUcnVlKS5yYXcpJTBBaW5wdXRzJTIwJTNEJTIwcHJvY2Vzc29yKCUwQSUyMCUyMCUyMCUyMHRleHQlM0QlNUIlMjJhJTIwcGhvdG8lMjBvZiUyMGElMjBjYXQlMjIlMkMlMjAlMjJhJTIwcGhvdG8lMjBvZiUyMGElMjBkb2clMjIlNUQlMkMlMjBpbWFnZXMlM0RpbWFnZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIlMkMlMjBwYWRkaW5nJTNEVHJ1ZSUwQSklMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpJTBBbG9naXRzX3Blcl9pbWFnZSUyMCUzRCUyMG91dHB1dHMubG9naXRzX3Blcl9pbWFnZSUyMCUyMCUyMyUyMHRoaXMlMjBpcyUyMHRoZSUyMGltYWdlLXRleHQlMjBzaW1pbGFyaXR5JTIwc2NvcmUlMEFwcm9icyUyMCUzRCUyMGxvZ2l0c19wZXJfaW1hZ2Uuc29mdG1heChkaW0lM0QxKSUyMCUyMCUyMyUyMHdlJTIwY2FuJTIwdGFrZSUyMHRoZSUyMHNvZnRtYXglMjB0byUyMGdldCUyMHRoZSUyMGxhYmVsJTIwcHJvYmFiaWxpdGllcw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, AltCLIPModel

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AltCLIPModel.from_pretrained(<span class="hljs-string">&quot;BAAI/AltCLIP&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;BAAI/AltCLIP&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(
<span class="hljs-meta">... </span>    text=[<span class="hljs-string">&quot;a photo of a cat&quot;</span>, <span class="hljs-string">&quot;a photo of a dog&quot;</span>], images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>, padding=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits_per_image = outputs.logits_per_image  <span class="hljs-comment"># this is the image-text similarity score</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>probs = logits_per_image.softmax(dim=<span class="hljs-number">1</span>)  <span class="hljs-comment"># we can take the softmax to get the label probabilities</span>`,wrap:!1}}),{c(){o=p("p"),o.textContent=C,a=l(),f(r.$$.fragment)},l(t){o=m(t,"P",{"data-svelte-h":!0}),y(o)!=="svelte-kvfsh7"&&(o.textContent=C),a=i(t),g(r.$$.fragment,t)},m(t,T){d(t,o,T),d(t,a,T),u(r,t,T),b=!0},p:L,i(t){b||(h(r.$$.fragment,t),b=!0)},o(t){_(r.$$.fragment,t),b=!1},d(t){t&&(s(o),s(a)),M(r,t)}}}function fn(I){let o,C=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){o=p("p"),o.innerHTML=C},l(a){o=m(a,"P",{"data-svelte-h":!0}),y(o)!=="svelte-fincs2"&&(o.innerHTML=C)},m(a,r){d(a,o,r)},p:L,d(a){a&&s(o)}}}function gn(I){let o,C="Examples:",a,r,b;return r=new Y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBBbHRDTElQTW9kZWwlMEElMEFtb2RlbCUyMCUzRCUyMEFsdENMSVBNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIyQkFBSSUyRkFsdENMSVAlMjIpJTBBcHJvY2Vzc29yJTIwJTNEJTIwQXV0b1Byb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyQkFBSSUyRkFsdENMSVAlMjIpJTBBaW5wdXRzJTIwJTNEJTIwcHJvY2Vzc29yKHRleHQlM0QlNUIlMjJhJTIwcGhvdG8lMjBvZiUyMGElMjBjYXQlMjIlMkMlMjAlMjJhJTIwcGhvdG8lMjBvZiUyMGElMjBkb2clMjIlNUQlMkMlMjBwYWRkaW5nJTNEVHJ1ZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBdGV4dF9mZWF0dXJlcyUyMCUzRCUyMG1vZGVsLmdldF90ZXh0X2ZlYXR1cmVzKCoqaW5wdXRzKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, AltCLIPModel

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AltCLIPModel.from_pretrained(<span class="hljs-string">&quot;BAAI/AltCLIP&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;BAAI/AltCLIP&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(text=[<span class="hljs-string">&quot;a photo of a cat&quot;</span>, <span class="hljs-string">&quot;a photo of a dog&quot;</span>], padding=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>text_features = model.get_text_features(**inputs)`,wrap:!1}}),{c(){o=p("p"),o.textContent=C,a=l(),f(r.$$.fragment)},l(t){o=m(t,"P",{"data-svelte-h":!0}),y(o)!=="svelte-kvfsh7"&&(o.textContent=C),a=i(t),g(r.$$.fragment,t)},m(t,T){d(t,o,T),d(t,a,T),u(r,t,T),b=!0},p:L,i(t){b||(h(r.$$.fragment,t),b=!0)},o(t){_(r.$$.fragment,t),b=!1},d(t){t&&(s(o),s(a)),M(r,t)}}}function un(I){let o,C=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){o=p("p"),o.innerHTML=C},l(a){o=m(a,"P",{"data-svelte-h":!0}),y(o)!=="svelte-fincs2"&&(o.innerHTML=C)},m(a,r){d(a,o,r)},p:L,d(a){a&&s(o)}}}function hn(I){let o,C="Examples:",a,r,b;return r=new Y({props:{code:"ZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Byb2Nlc3NvciUyQyUyMEFsdENMSVBNb2RlbCUwQSUwQW1vZGVsJTIwJTNEJTIwQWx0Q0xJUE1vZGVsLmZyb21fcHJldHJhaW5lZCglMjJCQUFJJTJGQWx0Q0xJUCUyMiklMEFwcm9jZXNzb3IlMjAlM0QlMjBBdXRvUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJCQUFJJTJGQWx0Q0xJUCUyMiklMEF1cmwlMjAlM0QlMjAlMjJodHRwJTNBJTJGJTJGaW1hZ2VzLmNvY29kYXRhc2V0Lm9yZyUyRnZhbDIwMTclMkYwMDAwMDAwMzk3NjkuanBnJTIyJTBBaW1hZ2UlMjAlM0QlMjBJbWFnZS5vcGVuKHJlcXVlc3RzLmdldCh1cmwlMkMlMjBzdHJlYW0lM0RUcnVlKS5yYXcpJTBBaW5wdXRzJTIwJTNEJTIwcHJvY2Vzc29yKGltYWdlcyUzRGltYWdlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEFpbWFnZV9mZWF0dXJlcyUyMCUzRCUyMG1vZGVsLmdldF9pbWFnZV9mZWF0dXJlcygqKmlucHV0cyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, AltCLIPModel

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AltCLIPModel.from_pretrained(<span class="hljs-string">&quot;BAAI/AltCLIP&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;BAAI/AltCLIP&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image_features = model.get_image_features(**inputs)`,wrap:!1}}),{c(){o=p("p"),o.textContent=C,a=l(),f(r.$$.fragment)},l(t){o=m(t,"P",{"data-svelte-h":!0}),y(o)!=="svelte-kvfsh7"&&(o.textContent=C),a=i(t),g(r.$$.fragment,t)},m(t,T){d(t,o,T),d(t,a,T),u(r,t,T),b=!0},p:L,i(t){b||(h(r.$$.fragment,t),b=!0)},o(t){_(r.$$.fragment,t),b=!1},d(t){t&&(s(o),s(a)),M(r,t)}}}function _n(I){let o,C=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){o=p("p"),o.innerHTML=C},l(a){o=m(a,"P",{"data-svelte-h":!0}),y(o)!=="svelte-fincs2"&&(o.innerHTML=C)},m(a,r){d(a,o,r)},p:L,d(a){a&&s(o)}}}function Mn(I){let o,C="Examples:",a,r,b;return r=new Y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBBbHRDTElQVGV4dE1vZGVsJTBBJTBBbW9kZWwlMjAlM0QlMjBBbHRDTElQVGV4dE1vZGVsLmZyb21fcHJldHJhaW5lZCglMjJCQUFJJTJGQWx0Q0xJUCUyMiklMEFwcm9jZXNzb3IlMjAlM0QlMjBBdXRvUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJCQUFJJTJGQWx0Q0xJUCUyMiklMEElMEF0ZXh0cyUyMCUzRCUyMCU1QiUyMml0J3MlMjBhJTIwY2F0JTIyJTJDJTIwJTIyaXQncyUyMGElMjBkb2clMjIlNUQlMEElMEFpbnB1dHMlMjAlM0QlMjBwcm9jZXNzb3IodGV4dCUzRHRleHRzJTJDJTIwcGFkZGluZyUzRFRydWUlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyklMEFsYXN0X2hpZGRlbl9zdGF0ZSUyMCUzRCUyMG91dHB1dHMubGFzdF9oaWRkZW5fc3RhdGUlMEFwb29sZWRfb3V0cHV0JTIwJTNEJTIwb3V0cHV0cy5wb29sZXJfb3V0cHV0JTIwJTIwJTIzJTIwcG9vbGVkJTIwQ0xTJTIwc3RhdGVz",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, AltCLIPTextModel

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AltCLIPTextModel.from_pretrained(<span class="hljs-string">&quot;BAAI/AltCLIP&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;BAAI/AltCLIP&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>texts = [<span class="hljs-string">&quot;it&#x27;s a cat&quot;</span>, <span class="hljs-string">&quot;it&#x27;s a dog&quot;</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(text=texts, padding=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_state = outputs.last_hidden_state
<span class="hljs-meta">&gt;&gt;&gt; </span>pooled_output = outputs.pooler_output  <span class="hljs-comment"># pooled CLS states</span>`,wrap:!1}}),{c(){o=p("p"),o.textContent=C,a=l(),f(r.$$.fragment)},l(t){o=m(t,"P",{"data-svelte-h":!0}),y(o)!=="svelte-kvfsh7"&&(o.textContent=C),a=i(t),g(r.$$.fragment,t)},m(t,T){d(t,o,T),d(t,a,T),u(r,t,T),b=!0},p:L,i(t){b||(h(r.$$.fragment,t),b=!0)},o(t){_(r.$$.fragment,t),b=!1},d(t){t&&(s(o),s(a)),M(r,t)}}}function bn(I){let o,C=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){o=p("p"),o.innerHTML=C},l(a){o=m(a,"P",{"data-svelte-h":!0}),y(o)!=="svelte-fincs2"&&(o.innerHTML=C)},m(a,r){d(a,o,r)},p:L,d(a){a&&s(o)}}}function Cn(I){let o,C="Examples:",a,r,b;return r=new Y({props:{code:"ZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Byb2Nlc3NvciUyQyUyMEFsdENMSVBWaXNpb25Nb2RlbCUwQSUwQW1vZGVsJTIwJTNEJTIwQWx0Q0xJUFZpc2lvbk1vZGVsLmZyb21fcHJldHJhaW5lZCglMjJCQUFJJTJGQWx0Q0xJUCUyMiklMEFwcm9jZXNzb3IlMjAlM0QlMjBBdXRvUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJCQUFJJTJGQWx0Q0xJUCUyMiklMEElMEF1cmwlMjAlM0QlMjAlMjJodHRwJTNBJTJGJTJGaW1hZ2VzLmNvY29kYXRhc2V0Lm9yZyUyRnZhbDIwMTclMkYwMDAwMDAwMzk3NjkuanBnJTIyJTBBaW1hZ2UlMjAlM0QlMjBJbWFnZS5vcGVuKHJlcXVlc3RzLmdldCh1cmwlMkMlMjBzdHJlYW0lM0RUcnVlKS5yYXcpJTBBJTBBaW5wdXRzJTIwJTNEJTIwcHJvY2Vzc29yKGltYWdlcyUzRGltYWdlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpJTBBbGFzdF9oaWRkZW5fc3RhdGUlMjAlM0QlMjBvdXRwdXRzLmxhc3RfaGlkZGVuX3N0YXRlJTBBcG9vbGVkX291dHB1dCUyMCUzRCUyMG91dHB1dHMucG9vbGVyX291dHB1dCUyMCUyMCUyMyUyMHBvb2xlZCUyMENMUyUyMHN0YXRlcw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, AltCLIPVisionModel

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AltCLIPVisionModel.from_pretrained(<span class="hljs-string">&quot;BAAI/AltCLIP&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;BAAI/AltCLIP&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_state = outputs.last_hidden_state
<span class="hljs-meta">&gt;&gt;&gt; </span>pooled_output = outputs.pooler_output  <span class="hljs-comment"># pooled CLS states</span>`,wrap:!1}}),{c(){o=p("p"),o.textContent=C,a=l(),f(r.$$.fragment)},l(t){o=m(t,"P",{"data-svelte-h":!0}),y(o)!=="svelte-kvfsh7"&&(o.textContent=C),a=i(t),g(r.$$.fragment,t)},m(t,T){d(t,o,T),d(t,a,T),u(r,t,T),b=!0},p:L,i(t){b||(h(r.$$.fragment,t),b=!0)},o(t){_(r.$$.fragment,t),b=!1},d(t){t&&(s(o),s(a)),M(r,t)}}}function Tn(I){let o,C,a,r,b,t,T,Mt,he,Jo=`The AltCLIP model was proposed in <a href="https://arxiv.org/abs/2211.06679v2" rel="nofollow">AltCLIP: Altering the Language Encoder in CLIP for Extended Language Capabilities</a> by Zhongzhi Chen, Guang Liu, Bo-Wen Zhang, Fulong Ye, Qinghong Yang, Ledell Wu. AltCLIP
(Altering the Language Encoder in CLIP) is a neural network trained on a variety of image-text and text-text pairs. By switching CLIP’s
text encoder with a pretrained multilingual text encoder XLM-R, we could obtain very close performances with CLIP on almost all tasks, and extended original CLIP’s capabilities such as multilingual understanding.`,bt,_e,Ao="The abstract from the paper is the following:",Ct,Me,jo=`<em>In this work, we present a conceptually simple and effective method to train a strong bilingual multimodal representation model.
Starting from the pretrained multimodal representation model CLIP released by OpenAI, we switched its text encoder with a pretrained
multilingual text encoder XLM-R, and aligned both languages and image representations by a two-stage training schema consisting of
teacher learning and contrastive learning. We validate our method through evaluations of a wide range of tasks. We set new state-of-the-art
performances on a bunch of tasks including ImageNet-CN, Flicker30k- CN, and COCO-CN. Further, we obtain very close performances with
CLIP on almost all tasks, suggesting that one can simply alter the text encoder in CLIP for extended capabilities such as multilingual understanding.</em>`,Tt,be,ko='This model was contributed by <a href="https://huggingface.co/jongjyh" rel="nofollow">jongjyh</a>.',yt,Ce,It,Te,Uo=`The usage of AltCLIP is very similar to the CLIP. the difference between CLIP is the text encoder. Note that we use bidirectional attention instead of casual attention
and we take the [CLS] token in XLM-R to represent text embedding.`,vt,ye,Bo=`AltCLIP is a multi-modal vision and language model. It can be used for image-text similarity and for zero-shot image
classification. AltCLIP uses a ViT like transformer to get visual features and a bidirectional language model to get the text
features. Both the text and visual features are then projected to a latent space with identical dimension. The dot
product between the projected image and text features is then used as a similar score.`,$t,Ie,zo=`To feed images to the Transformer encoder, each image is split into a sequence of fixed-size non-overlapping patches,
which are then linearly embedded. A [CLS] token is added to serve as representation of an entire image. The authors
also add absolute position embeddings, and feed the resulting sequence of vectors to a standard Transformer encoder.
The <a href="/docs/transformers/pr_30530/en/model_doc/clip#transformers.CLIPImageProcessor">CLIPImageProcessor</a> can be used to resize (or rescale) and normalize images for the model.`,wt,ve,Wo=`The <a href="/docs/transformers/pr_30530/en/model_doc/altclip#transformers.AltCLIPProcessor">AltCLIPProcessor</a> wraps a <a href="/docs/transformers/pr_30530/en/model_doc/clip#transformers.CLIPImageProcessor">CLIPImageProcessor</a> and a <a href="/docs/transformers/pr_30530/en/model_doc/xlm-roberta#transformers.XLMRobertaTokenizer">XLMRobertaTokenizer</a> into a single instance to both
encode the text and prepare the images. The following example shows how to get the image-text similarity scores using
<a href="/docs/transformers/pr_30530/en/model_doc/altclip#transformers.AltCLIPProcessor">AltCLIPProcessor</a> and <a href="/docs/transformers/pr_30530/en/model_doc/altclip#transformers.AltCLIPModel">AltCLIPModel</a>.`,xt,$e,Pt,D,Lt,we,Jt,w,xe,Ft,et,Zo=`This is the configuration class to store the configuration of a <a href="/docs/transformers/pr_30530/en/model_doc/altclip#transformers.AltCLIPModel">AltCLIPModel</a>. It is used to instantiate an
AltCLIP model according to the specified arguments, defining the model architecture. Instantiating a configuration
with the defaults will yield a similar configuration to that of the AltCLIP
<a href="https://huggingface.co/BAAI/AltCLIP" rel="nofollow">BAAI/AltCLIP</a> architecture.`,qt,tt,Vo=`Configuration objects inherit from <a href="/docs/transformers/pr_30530/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/pr_30530/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,Xt,O,St,K,Pe,Yt,ot,Ho=`Instantiate a <a href="/docs/transformers/pr_30530/en/model_doc/altclip#transformers.AltCLIPConfig">AltCLIPConfig</a> (or a derived class) from altclip text model configuration and altclip vision
model configuration.`,At,Le,jt,J,Je,Dt,nt,Eo=`This is the configuration class to store the configuration of a <a href="/docs/transformers/pr_30530/en/model_doc/altclip#transformers.AltCLIPTextModel">AltCLIPTextModel</a>. It is used to instantiate a
AltCLIP text model according to the specified arguments, defining the model architecture. Instantiating a
configuration with the defaults will yield a similar configuration to that of the AltCLIP
<a href="https://huggingface.co/BAAI/AltCLIP" rel="nofollow">BAAI/AltCLIP</a> architecture.`,Ot,st,Qo=`Configuration objects inherit from <a href="/docs/transformers/pr_30530/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/pr_30530/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,Kt,ee,kt,Ae,Ut,A,je,eo,at,Go=`This is the configuration class to store the configuration of a <a href="/docs/transformers/pr_30530/en/model_doc/altclip#transformers.AltCLIPModel">AltCLIPModel</a>. It is used to instantiate an
AltCLIP model according to the specified arguments, defining the model architecture. Instantiating a configuration
with the defaults will yield a similar configuration to that of the AltCLIP
<a href="https://huggingface.co/BAAI/AltCLIP" rel="nofollow">BAAI/AltCLIP</a> architecture.`,to,rt,No=`Configuration objects inherit from <a href="/docs/transformers/pr_30530/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/pr_30530/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,oo,te,Bt,ke,zt,x,Ue,no,lt,Ro=`Constructs a AltCLIP processor which wraps a CLIP image processor and a XLM-Roberta tokenizer into a single
processor.`,so,it,Fo=`<a href="/docs/transformers/pr_30530/en/model_doc/altclip#transformers.AltCLIPProcessor">AltCLIPProcessor</a> offers all the functionalities of <a href="/docs/transformers/pr_30530/en/model_doc/clip#transformers.CLIPImageProcessor">CLIPImageProcessor</a> and <a href="/docs/transformers/pr_30530/en/model_doc/xlm-roberta#transformers.XLMRobertaTokenizerFast">XLMRobertaTokenizerFast</a>. See
the <code>__call__()</code> and <a href="/docs/transformers/pr_30530/en/model_doc/altclip#transformers.AltCLIPProcessor.decode">decode()</a> for more information.`,ao,oe,Be,ro,dt,qo=`This method forwards all its arguments to XLMRobertaTokenizerFast’s <a href="/docs/transformers/pr_30530/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.batch_decode">batch_decode()</a>.
Please refer to the docstring of this method for more information.`,lo,ne,ze,io,ct,Xo=`This method forwards all its arguments to XLMRobertaTokenizerFast’s <a href="/docs/transformers/pr_30530/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.decode">decode()</a>. Please
refer to the docstring of this method for more information.`,Wt,We,Zt,j,Ze,co,B,Ve,po,pt,So='The <a href="/docs/transformers/pr_30530/en/model_doc/altclip#transformers.AltCLIPModel">AltCLIPModel</a> forward method, overrides the <code>__call__</code> special method.',mo,se,fo,ae,go,z,He,uo,mt,Yo='The <a href="/docs/transformers/pr_30530/en/model_doc/altclip#transformers.AltCLIPModel">AltCLIPModel</a> forward method, overrides the <code>__call__</code> special method.',ho,re,_o,le,Mo,W,Ee,bo,ft,Do='The <a href="/docs/transformers/pr_30530/en/model_doc/altclip#transformers.AltCLIPModel">AltCLIPModel</a> forward method, overrides the <code>__call__</code> special method.',Co,ie,To,de,Vt,Qe,Ht,X,Ge,yo,Z,Ne,Io,gt,Oo='The <a href="/docs/transformers/pr_30530/en/model_doc/altclip#transformers.AltCLIPTextModel">AltCLIPTextModel</a> forward method, overrides the <code>__call__</code> special method.',vo,ce,$o,pe,Et,Re,Qt,S,Fe,wo,V,qe,xo,ut,Ko='The <a href="/docs/transformers/pr_30530/en/model_doc/altclip#transformers.AltCLIPVisionModel">AltCLIPVisionModel</a> forward method, overrides the <code>__call__</code> special method.',Po,me,Lo,fe,Gt,Xe,Nt,_t,Rt;return b=new q({props:{title:"AltCLIP",local:"altclip",headingTag:"h1"}}),T=new q({props:{title:"Overview",local:"overview",headingTag:"h2"}}),Ce=new q({props:{title:"Usage tips and example",local:"usage-tips-and-example",headingTag:"h2"}}),$e=new Y({props:{code:"ZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEElMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQWx0Q0xJUE1vZGVsJTJDJTIwQWx0Q0xJUFByb2Nlc3NvciUwQSUwQW1vZGVsJTIwJTNEJTIwQWx0Q0xJUE1vZGVsLmZyb21fcHJldHJhaW5lZCglMjJCQUFJJTJGQWx0Q0xJUCUyMiklMEFwcm9jZXNzb3IlMjAlM0QlMjBBbHRDTElQUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJCQUFJJTJGQWx0Q0xJUCUyMiklMEElMEF1cmwlMjAlM0QlMjAlMjJodHRwJTNBJTJGJTJGaW1hZ2VzLmNvY29kYXRhc2V0Lm9yZyUyRnZhbDIwMTclMkYwMDAwMDAwMzk3NjkuanBnJTIyJTBBaW1hZ2UlMjAlM0QlMjBJbWFnZS5vcGVuKHJlcXVlc3RzLmdldCh1cmwlMkMlMjBzdHJlYW0lM0RUcnVlKS5yYXcpJTBBJTBBaW5wdXRzJTIwJTNEJTIwcHJvY2Vzc29yKHRleHQlM0QlNUIlMjJhJTIwcGhvdG8lMjBvZiUyMGElMjBjYXQlMjIlMkMlMjAlMjJhJTIwcGhvdG8lMjBvZiUyMGElMjBkb2clMjIlNUQlMkMlMjBpbWFnZXMlM0RpbWFnZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIlMkMlMjBwYWRkaW5nJTNEVHJ1ZSklMEElMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpJTBBbG9naXRzX3Blcl9pbWFnZSUyMCUzRCUyMG91dHB1dHMubG9naXRzX3Blcl9pbWFnZSUyMCUyMCUyMyUyMHRoaXMlMjBpcyUyMHRoZSUyMGltYWdlLXRleHQlMjBzaW1pbGFyaXR5JTIwc2NvcmUlMEFwcm9icyUyMCUzRCUyMGxvZ2l0c19wZXJfaW1hZ2Uuc29mdG1heChkaW0lM0QxKSUyMCUyMCUyMyUyMHdlJTIwY2FuJTIwdGFrZSUyMHRoZSUyMHNvZnRtYXglMjB0byUyMGdldCUyMHRoZSUyMGxhYmVsJTIwcHJvYmFiaWxpdGllcw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AltCLIPModel, AltCLIPProcessor

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AltCLIPModel.from_pretrained(<span class="hljs-string">&quot;BAAI/AltCLIP&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AltCLIPProcessor.from_pretrained(<span class="hljs-string">&quot;BAAI/AltCLIP&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(text=[<span class="hljs-string">&quot;a photo of a cat&quot;</span>, <span class="hljs-string">&quot;a photo of a dog&quot;</span>], images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>, padding=<span class="hljs-literal">True</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits_per_image = outputs.logits_per_image  <span class="hljs-comment"># this is the image-text similarity score</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>probs = logits_per_image.softmax(dim=<span class="hljs-number">1</span>)  <span class="hljs-comment"># we can take the softmax to get the label probabilities</span>`,wrap:!1}}),D=new ht({props:{$$slots:{default:[rn]},$$scope:{ctx:I}}}),we=new q({props:{title:"AltCLIPConfig",local:"transformers.AltCLIPConfig",headingTag:"h2"}}),xe=new P({props:{name:"class transformers.AltCLIPConfig",anchor:"transformers.AltCLIPConfig",parameters:[{name:"text_config",val:" = None"},{name:"vision_config",val:" = None"},{name:"projection_dim",val:" = 768"},{name:"logit_scale_init_value",val:" = 2.6592"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.AltCLIPConfig.text_config",description:`<strong>text_config</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
Dictionary of configuration options used to initialize <a href="/docs/transformers/pr_30530/en/model_doc/altclip#transformers.AltCLIPTextConfig">AltCLIPTextConfig</a>.`,name:"text_config"},{anchor:"transformers.AltCLIPConfig.vision_config",description:`<strong>vision_config</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
Dictionary of configuration options used to initialize <a href="/docs/transformers/pr_30530/en/model_doc/altclip#transformers.AltCLIPVisionConfig">AltCLIPVisionConfig</a>.`,name:"vision_config"},{anchor:"transformers.AltCLIPConfig.projection_dim",description:`<strong>projection_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 768) &#x2014;
Dimensionality of text and vision projection layers.`,name:"projection_dim"},{anchor:"transformers.AltCLIPConfig.logit_scale_init_value",description:`<strong>logit_scale_init_value</strong> (<code>float</code>, <em>optional</em>, defaults to 2.6592) &#x2014;
The initial value of the <em>logit_scale</em> parameter. Default is used as per the original CLIP implementation.`,name:"logit_scale_init_value"},{anchor:"transformers.AltCLIPConfig.kwargs",description:`<strong>kwargs</strong> (<em>optional</em>) &#x2014;
Dictionary of keyword arguments.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/models/altclip/configuration_altclip.py#L255"}}),O=new ue({props:{anchor:"transformers.AltCLIPConfig.example",$$slots:{default:[ln]},$$scope:{ctx:I}}}),Pe=new P({props:{name:"from_text_vision_configs",anchor:"transformers.AltCLIPConfig.from_text_vision_configs",parameters:[{name:"text_config",val:": AltCLIPTextConfig"},{name:"vision_config",val:": AltCLIPVisionConfig"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/models/altclip/configuration_altclip.py#L390",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>An instance of a configuration object</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/pr_30530/en/model_doc/altclip#transformers.AltCLIPConfig"
>AltCLIPConfig</a></p>
`}}),Le=new q({props:{title:"AltCLIPTextConfig",local:"transformers.AltCLIPTextConfig",headingTag:"h2"}}),Je=new P({props:{name:"class transformers.AltCLIPTextConfig",anchor:"transformers.AltCLIPTextConfig",parameters:[{name:"vocab_size",val:" = 250002"},{name:"hidden_size",val:" = 1024"},{name:"num_hidden_layers",val:" = 24"},{name:"num_attention_heads",val:" = 16"},{name:"intermediate_size",val:" = 4096"},{name:"hidden_act",val:" = 'gelu'"},{name:"hidden_dropout_prob",val:" = 0.1"},{name:"attention_probs_dropout_prob",val:" = 0.1"},{name:"max_position_embeddings",val:" = 514"},{name:"type_vocab_size",val:" = 1"},{name:"initializer_range",val:" = 0.02"},{name:"initializer_factor",val:" = 0.02"},{name:"layer_norm_eps",val:" = 1e-05"},{name:"pad_token_id",val:" = 1"},{name:"bos_token_id",val:" = 0"},{name:"eos_token_id",val:" = 2"},{name:"position_embedding_type",val:" = 'absolute'"},{name:"use_cache",val:" = True"},{name:"project_dim",val:" = 768"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.AltCLIPTextConfig.vocab_size",description:`<strong>vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 250002) &#x2014;
Vocabulary size of the AltCLIP model. Defines the number of different tokens that can be represented by the
<code>inputs_ids</code> passed when calling <a href="/docs/transformers/pr_30530/en/model_doc/altclip#transformers.AltCLIPTextModel">AltCLIPTextModel</a>.`,name:"vocab_size"},{anchor:"transformers.AltCLIPTextConfig.hidden_size",description:`<strong>hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 1024) &#x2014;
Dimensionality of the encoder layers and the pooler layer.`,name:"hidden_size"},{anchor:"transformers.AltCLIPTextConfig.num_hidden_layers",description:`<strong>num_hidden_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 24) &#x2014;
Number of hidden layers in the Transformer encoder.`,name:"num_hidden_layers"},{anchor:"transformers.AltCLIPTextConfig.num_attention_heads",description:`<strong>num_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 16) &#x2014;
Number of attention heads for each attention layer in the Transformer encoder.`,name:"num_attention_heads"},{anchor:"transformers.AltCLIPTextConfig.intermediate_size",description:`<strong>intermediate_size</strong> (<code>int</code>, <em>optional</em>, defaults to 4096) &#x2014;
Dimensionality of the &#x201C;intermediate&#x201D; (often named feed-forward) layer in the Transformer encoder.`,name:"intermediate_size"},{anchor:"transformers.AltCLIPTextConfig.hidden_act",description:`<strong>hidden_act</strong> (<code>str</code> or <code>Callable</code>, <em>optional</em>, defaults to <code>&quot;gelu&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the encoder and pooler. If string, <code>&quot;gelu&quot;</code>,
<code>&quot;relu&quot;</code>, <code>&quot;silu&quot;</code> and <code>&quot;gelu_new&quot;</code> are supported.`,name:"hidden_act"},{anchor:"transformers.AltCLIPTextConfig.hidden_dropout_prob",description:`<strong>hidden_dropout_prob</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The dropout probability for all fully connected layers in the embeddings, encoder, and pooler.`,name:"hidden_dropout_prob"},{anchor:"transformers.AltCLIPTextConfig.attention_probs_dropout_prob",description:`<strong>attention_probs_dropout_prob</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The dropout ratio for the attention probabilities.`,name:"attention_probs_dropout_prob"},{anchor:"transformers.AltCLIPTextConfig.max_position_embeddings",description:`<strong>max_position_embeddings</strong> (<code>int</code>, <em>optional</em>, defaults to 514) &#x2014;
The maximum sequence length that this model might ever be used with. Typically set this to something large
just in case (e.g., 512 or 1024 or 2048).`,name:"max_position_embeddings"},{anchor:"transformers.AltCLIPTextConfig.type_vocab_size",description:`<strong>type_vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The vocabulary size of the <code>token_type_ids</code> passed when calling <a href="/docs/transformers/pr_30530/en/model_doc/altclip#transformers.AltCLIPTextModel">AltCLIPTextModel</a>`,name:"type_vocab_size"},{anchor:"transformers.AltCLIPTextConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.AltCLIPTextConfig.initializer_factor",description:`<strong>initializer_factor</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
A factor for initializing all weight matrices (should be kept to 1, used internally for initialization
testing).`,name:"initializer_factor"},{anchor:"transformers.AltCLIPTextConfig.layer_norm_eps",description:`<strong>layer_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-05) &#x2014;
The epsilon used by the layer normalization layers.`,name:"layer_norm_eps"},{anchor:"transformers.AltCLIPTextConfig.pad_token_id",description:"<strong>pad_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014; The id of the <em>padding</em> token.",name:"pad_token_id"},{anchor:"transformers.AltCLIPTextConfig.bos_token_id",description:"<strong>bos_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014; The id of the <em>beginning-of-sequence</em> token.",name:"bos_token_id"},{anchor:"transformers.AltCLIPTextConfig.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int]]</code>, <em>optional</em>, defaults to 2) &#x2014;
The id of the <em>end-of-sequence</em> token. Optionally, use a list to set multiple <em>end-of-sequence</em> tokens.`,name:"eos_token_id"},{anchor:"transformers.AltCLIPTextConfig.position_embedding_type",description:`<strong>position_embedding_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;absolute&quot;</code>) &#x2014;
Type of position embedding. Choose one of <code>&quot;absolute&quot;</code>, <code>&quot;relative_key&quot;</code>, <code>&quot;relative_key_query&quot;</code>. For
positional embeddings use <code>&quot;absolute&quot;</code>. For more information on <code>&quot;relative_key&quot;</code>, please refer to
<a href="https://arxiv.org/abs/1803.02155" rel="nofollow">Self-Attention with Relative Position Representations (Shaw et al.)</a>.
For more information on <code>&quot;relative_key_query&quot;</code>, please refer to <em>Method 4</em> in <a href="https://arxiv.org/abs/2009.13658" rel="nofollow">Improve Transformer Models
with Better Relative Position Embeddings (Huang et al.)</a>.`,name:"position_embedding_type"},{anchor:"transformers.AltCLIPTextConfig.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not the model should return the last key/values attentions (not used by all models). Only
relevant if <code>config.is_decoder=True</code>.`,name:"use_cache"},{anchor:"transformers.AltCLIPTextConfig.project_dim",description:`<strong>project_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 768) &#x2014;
The dimensions of the teacher model before the mapping layer.`,name:"project_dim"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/models/altclip/configuration_altclip.py#L27"}}),ee=new ue({props:{anchor:"transformers.AltCLIPTextConfig.example",$$slots:{default:[dn]},$$scope:{ctx:I}}}),Ae=new q({props:{title:"AltCLIPVisionConfig",local:"transformers.AltCLIPVisionConfig",headingTag:"h2"}}),je=new P({props:{name:"class transformers.AltCLIPVisionConfig",anchor:"transformers.AltCLIPVisionConfig",parameters:[{name:"hidden_size",val:" = 768"},{name:"intermediate_size",val:" = 3072"},{name:"projection_dim",val:" = 512"},{name:"num_hidden_layers",val:" = 12"},{name:"num_attention_heads",val:" = 12"},{name:"num_channels",val:" = 3"},{name:"image_size",val:" = 224"},{name:"patch_size",val:" = 32"},{name:"hidden_act",val:" = 'quick_gelu'"},{name:"layer_norm_eps",val:" = 1e-05"},{name:"attention_dropout",val:" = 0.0"},{name:"initializer_range",val:" = 0.02"},{name:"initializer_factor",val:" = 1.0"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.AltCLIPVisionConfig.hidden_size",description:`<strong>hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 768) &#x2014;
Dimensionality of the encoder layers and the pooler layer.`,name:"hidden_size"},{anchor:"transformers.AltCLIPVisionConfig.intermediate_size",description:`<strong>intermediate_size</strong> (<code>int</code>, <em>optional</em>, defaults to 3072) &#x2014;
Dimensionality of the &#x201C;intermediate&#x201D; (i.e., feed-forward) layer in the Transformer encoder.`,name:"intermediate_size"},{anchor:"transformers.AltCLIPVisionConfig.projection_dim",description:`<strong>projection_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
Dimensionality of text and vision projection layers.`,name:"projection_dim"},{anchor:"transformers.AltCLIPVisionConfig.num_hidden_layers",description:`<strong>num_hidden_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014;
Number of hidden layers in the Transformer encoder.`,name:"num_hidden_layers"},{anchor:"transformers.AltCLIPVisionConfig.num_attention_heads",description:`<strong>num_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014;
Number of attention heads for each attention layer in the Transformer encoder.`,name:"num_attention_heads"},{anchor:"transformers.AltCLIPVisionConfig.num_channels",description:`<strong>num_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 3) &#x2014;
The number of input channels.`,name:"num_channels"},{anchor:"transformers.AltCLIPVisionConfig.image_size",description:`<strong>image_size</strong> (<code>int</code>, <em>optional</em>, defaults to 224) &#x2014;
The size (resolution) of each image.`,name:"image_size"},{anchor:"transformers.AltCLIPVisionConfig.patch_size",description:`<strong>patch_size</strong> (<code>int</code>, <em>optional</em>, defaults to 32) &#x2014;
The size (resolution) of each patch.`,name:"patch_size"},{anchor:"transformers.AltCLIPVisionConfig.hidden_act",description:`<strong>hidden_act</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to <code>&quot;quick_gelu&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the encoder and pooler. If string, <code>&quot;gelu&quot;</code>,
<code>&quot;relu&quot;</code>, <code>&quot;selu&quot;</code> and <code>&quot;gelu_new&quot;</code> <code>&quot;quick_gelu&quot;</code> are supported.`,name:"hidden_act"},{anchor:"transformers.AltCLIPVisionConfig.layer_norm_eps",description:`<strong>layer_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-05) &#x2014;
The epsilon used by the layer normalization layers.`,name:"layer_norm_eps"},{anchor:"transformers.AltCLIPVisionConfig.attention_dropout",description:`<strong>attention_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout ratio for the attention probabilities.`,name:"attention_dropout"},{anchor:"transformers.AltCLIPVisionConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.AltCLIPVisionConfig.initializer_factor",description:`<strong>initializer_factor</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
A factor for initializing all weight matrices (should be kept to 1, used internally for initialization
testing).`,name:"initializer_factor"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/models/altclip/configuration_altclip.py#L145"}}),te=new ue({props:{anchor:"transformers.AltCLIPVisionConfig.example",$$slots:{default:[cn]},$$scope:{ctx:I}}}),ke=new q({props:{title:"AltCLIPProcessor",local:"transformers.AltCLIPProcessor",headingTag:"h2"}}),Ue=new P({props:{name:"class transformers.AltCLIPProcessor",anchor:"transformers.AltCLIPProcessor",parameters:[{name:"image_processor",val:" = None"},{name:"tokenizer",val:" = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.AltCLIPProcessor.image_processor",description:`<strong>image_processor</strong> (<a href="/docs/transformers/pr_30530/en/model_doc/clip#transformers.CLIPImageProcessor">CLIPImageProcessor</a>, <em>optional</em>) &#x2014;
The image processor is a required input.`,name:"image_processor"},{anchor:"transformers.AltCLIPProcessor.tokenizer",description:`<strong>tokenizer</strong> (<a href="/docs/transformers/pr_30530/en/model_doc/xlm-roberta#transformers.XLMRobertaTokenizerFast">XLMRobertaTokenizerFast</a>, <em>optional</em>) &#x2014;
The tokenizer is a required input.`,name:"tokenizer"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/models/altclip/processing_altclip.py#L25"}}),Be=new P({props:{name:"batch_decode",anchor:"transformers.AltCLIPProcessor.batch_decode",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/models/altclip/processing_altclip.py#L114"}}),ze=new P({props:{name:"decode",anchor:"transformers.AltCLIPProcessor.decode",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/models/altclip/processing_altclip.py#L121"}}),We=new q({props:{title:"AltCLIPModel",local:"transformers.AltCLIPModel",headingTag:"h2"}}),Ze=new P({props:{name:"class transformers.AltCLIPModel",anchor:"transformers.AltCLIPModel",parameters:[{name:"config",val:": AltCLIPConfig"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/models/altclip/modeling_altclip.py#L1462"}}),Ve=new P({props:{name:"forward",anchor:"transformers.AltCLIPModel.forward",parameters:[{name:"input_ids",val:": Optional = None"},{name:"pixel_values",val:": Optional = None"},{name:"attention_mask",val:": Optional = None"},{name:"position_ids",val:": Optional = None"},{name:"token_type_ids",val:": Optional = None"},{name:"return_loss",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"return_dict",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.AltCLIPModel.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default should you provide
it.</p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_30530/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/pr_30530/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_30530/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.AltCLIPModel.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.AltCLIPModel.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.AltCLIPModel.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Padding will be ignored by default should you provide it. Pixel values can be obtained using
<a href="/docs/transformers/pr_30530/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See <a href="/docs/transformers/pr_30530/en/model_doc/levit#transformers.LevitFeatureExtractor.__call__">CLIPImageProcessor.<strong>call</strong>()</a> for details.`,name:"pixel_values"},{anchor:"transformers.AltCLIPModel.forward.return_loss",description:`<strong>return_loss</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the contrastive loss.`,name:"return_loss"},{anchor:"transformers.AltCLIPModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.AltCLIPModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.AltCLIPModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/pr_30530/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/models/altclip/modeling_altclip.py#L1589",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.models.altclip.modeling_altclip.AltCLIPOutput</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<code>&lt;class 'transformers.models.altclip.configuration_altclip.AltCLIPConfig'&gt;</code>) and inputs.</p>
<ul>
<li><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>return_loss</code> is <code>True</code>) — Contrastive loss for image-text similarity.</li>
<li><strong>logits_per_image:(<code>torch.FloatTensor</code></strong> of shape <code>(image_batch_size, text_batch_size)</code>) — The scaled dot product scores between <code>image_embeds</code> and <code>text_embeds</code>. This represents the image-text
similarity scores.</li>
<li><strong>logits_per_text:(<code>torch.FloatTensor</code></strong> of shape <code>(text_batch_size, image_batch_size)</code>) — The scaled dot product scores between <code>text_embeds</code> and <code>image_embeds</code>. This represents the text-image
similarity scores.</li>
<li><strong>text_embeds(<code>torch.FloatTensor</code></strong> of shape <code>(batch_size, output_dim</code>) — The text embeddings obtained by applying the projection layer to the pooled output of <a
  href="/docs/transformers/pr_30530/en/model_doc/altclip#transformers.AltCLIPTextModel"
>AltCLIPTextModel</a>.</li>
<li><strong>image_embeds(<code>torch.FloatTensor</code></strong> of shape <code>(batch_size, output_dim</code>) — The image embeddings obtained by applying the projection layer to the pooled output of <a
  href="/docs/transformers/pr_30530/en/model_doc/altclip#transformers.AltCLIPVisionModel"
>AltCLIPVisionModel</a>.</li>
<li><strong>text_model_output(<code>BaseModelOutputWithPooling</code>):</strong>
The output of the <a
  href="/docs/transformers/pr_30530/en/model_doc/altclip#transformers.AltCLIPTextModel"
>AltCLIPTextModel</a>.</li>
<li><strong>vision_model_output(<code>BaseModelOutputWithPooling</code>):</strong>
The output of the <a
  href="/docs/transformers/pr_30530/en/model_doc/altclip#transformers.AltCLIPVisionModel"
>AltCLIPVisionModel</a>.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.models.altclip.modeling_altclip.AltCLIPOutput</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),se=new ht({props:{$$slots:{default:[pn]},$$scope:{ctx:I}}}),ae=new ue({props:{anchor:"transformers.AltCLIPModel.forward.example",$$slots:{default:[mn]},$$scope:{ctx:I}}}),He=new P({props:{name:"get_text_features",anchor:"transformers.AltCLIPModel.get_text_features",parameters:[{name:"input_ids",val:": Optional = None"},{name:"attention_mask",val:": Optional = None"},{name:"position_ids",val:": Optional = None"},{name:"token_type_ids",val:" = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"return_dict",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.AltCLIPModel.get_text_features.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default should you provide
it.</p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_30530/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/pr_30530/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_30530/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.AltCLIPModel.get_text_features.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.AltCLIPModel.get_text_features.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.AltCLIPModel.get_text_features.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.AltCLIPModel.get_text_features.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.AltCLIPModel.get_text_features.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/pr_30530/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/models/altclip/modeling_altclip.py#L1496",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The text embeddings obtained by
applying the projection layer to the pooled output of <a
  href="/docs/transformers/pr_30530/en/model_doc/altclip#transformers.AltCLIPTextModel"
>AltCLIPTextModel</a>.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>text_features (<code>torch.FloatTensor</code> of shape <code>(batch_size, output_dim</code>)</p>
`}}),re=new ht({props:{$$slots:{default:[fn]},$$scope:{ctx:I}}}),le=new ue({props:{anchor:"transformers.AltCLIPModel.get_text_features.example",$$slots:{default:[gn]},$$scope:{ctx:I}}}),Ee=new P({props:{name:"get_image_features",anchor:"transformers.AltCLIPModel.get_image_features",parameters:[{name:"pixel_values",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"return_dict",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.AltCLIPModel.get_image_features.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Padding will be ignored by default should you provide it. Pixel values can be obtained using
<a href="/docs/transformers/pr_30530/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See <a href="/docs/transformers/pr_30530/en/model_doc/levit#transformers.LevitFeatureExtractor.__call__">CLIPImageProcessor.<strong>call</strong>()</a> for details.`,name:"pixel_values"},{anchor:"transformers.AltCLIPModel.get_image_features.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.AltCLIPModel.get_image_features.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.AltCLIPModel.get_image_features.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/pr_30530/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/models/altclip/modeling_altclip.py#L1543",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The image embeddings obtained by
applying the projection layer to the pooled output of <a
  href="/docs/transformers/pr_30530/en/model_doc/altclip#transformers.AltCLIPVisionModel"
>AltCLIPVisionModel</a>.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>image_features (<code>torch.FloatTensor</code> of shape <code>(batch_size, output_dim</code>)</p>
`}}),ie=new ht({props:{$$slots:{default:[un]},$$scope:{ctx:I}}}),de=new ue({props:{anchor:"transformers.AltCLIPModel.get_image_features.example",$$slots:{default:[hn]},$$scope:{ctx:I}}}),Qe=new q({props:{title:"AltCLIPTextModel",local:"transformers.AltCLIPTextModel",headingTag:"h2"}}),Ge=new P({props:{name:"class transformers.AltCLIPTextModel",anchor:"transformers.AltCLIPTextModel",parameters:[{name:"config",val:""}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/models/altclip/modeling_altclip.py#L1370"}}),Ne=new P({props:{name:"forward",anchor:"transformers.AltCLIPTextModel.forward",parameters:[{name:"input_ids",val:": Optional = None"},{name:"attention_mask",val:": Optional = None"},{name:"token_type_ids",val:": Optional = None"},{name:"position_ids",val:": Optional = None"},{name:"head_mask",val:": Optional = None"},{name:"inputs_embeds",val:": Optional = None"},{name:"encoder_hidden_states",val:": Optional = None"},{name:"encoder_attention_mask",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"return_dict",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.AltCLIPTextModel.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default should you provide
it.</p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_30530/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/pr_30530/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_30530/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.AltCLIPTextModel.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.AltCLIPTextModel.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.AltCLIPTextModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.AltCLIPTextModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.AltCLIPTextModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/pr_30530/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/models/altclip/modeling_altclip.py#L1389",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.modeling_outputs.BaseModelOutputWithPoolingAndProjection</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<code>&lt;class 'transformers.models.altclip.configuration_altclip.AltCLIPTextConfig'&gt;</code>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the model.</p>
</li>
<li>
<p><strong>pooler_output</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, hidden_size)</code>) — Last layer hidden-state of the first token of the sequence (classification token) after further processing
through the layers used for the auxiliary pretraining task. E.g. for BERT-family of models, this returns
the classification token after processing through a linear layer and a tanh activation function. The linear
layer weights are trained from the next sentence prediction (classification) objective during pretraining.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
<li>
<p><strong>projection_state</strong> (<code>tuple(torch.FloatTensor)</code>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> of shape <code>(batch_size,config.project_dim)</code>.</p>
<p>Text embeddings before the projection layer, used to mimic the last hidden state of the teacher encoder.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.modeling_outputs.BaseModelOutputWithPoolingAndProjection</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),ce=new ht({props:{$$slots:{default:[_n]},$$scope:{ctx:I}}}),pe=new ue({props:{anchor:"transformers.AltCLIPTextModel.forward.example",$$slots:{default:[Mn]},$$scope:{ctx:I}}}),Re=new q({props:{title:"AltCLIPVisionModel",local:"transformers.AltCLIPVisionModel",headingTag:"h2"}}),Fe=new P({props:{name:"class transformers.AltCLIPVisionModel",anchor:"transformers.AltCLIPVisionModel",parameters:[{name:"config",val:": AltCLIPVisionConfig"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/models/altclip/modeling_altclip.py#L1139"}}),qe=new P({props:{name:"forward",anchor:"transformers.AltCLIPVisionModel.forward",parameters:[{name:"pixel_values",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"return_dict",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.AltCLIPVisionModel.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Padding will be ignored by default should you provide it. Pixel values can be obtained using
<a href="/docs/transformers/pr_30530/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See <a href="/docs/transformers/pr_30530/en/model_doc/levit#transformers.LevitFeatureExtractor.__call__">CLIPImageProcessor.<strong>call</strong>()</a> for details.`,name:"pixel_values"},{anchor:"transformers.AltCLIPVisionModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.AltCLIPVisionModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.AltCLIPVisionModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/pr_30530/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/models/altclip/modeling_altclip.py#L1152",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/pr_30530/en/main_classes/output#transformers.modeling_outputs.BaseModelOutputWithPooling"
>transformers.modeling_outputs.BaseModelOutputWithPooling</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<code>&lt;class 'transformers.models.altclip.configuration_altclip.AltCLIPVisionConfig'&gt;</code>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the model.</p>
</li>
<li>
<p><strong>pooler_output</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, hidden_size)</code>) — Last layer hidden-state of the first token of the sequence (classification token) after further processing
through the layers used for the auxiliary pretraining task. E.g. for BERT-family of models, this returns
the classification token after processing through a linear layer and a tanh activation function. The linear
layer weights are trained from the next sentence prediction (classification) objective during pretraining.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/pr_30530/en/main_classes/output#transformers.modeling_outputs.BaseModelOutputWithPooling"
>transformers.modeling_outputs.BaseModelOutputWithPooling</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),me=new ht({props:{$$slots:{default:[bn]},$$scope:{ctx:I}}}),fe=new ue({props:{anchor:"transformers.AltCLIPVisionModel.forward.example",$$slots:{default:[Cn]},$$scope:{ctx:I}}}),Xe=new an({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/altclip.md"}}),{c(){o=p("meta"),C=l(),a=p("p"),r=l(),f(b.$$.fragment),t=l(),f(T.$$.fragment),Mt=l(),he=p("p"),he.innerHTML=Jo,bt=l(),_e=p("p"),_e.textContent=Ao,Ct=l(),Me=p("p"),Me.innerHTML=jo,Tt=l(),be=p("p"),be.innerHTML=ko,yt=l(),f(Ce.$$.fragment),It=l(),Te=p("p"),Te.textContent=Uo,vt=l(),ye=p("p"),ye.textContent=Bo,$t=l(),Ie=p("p"),Ie.innerHTML=zo,wt=l(),ve=p("p"),ve.innerHTML=Wo,xt=l(),f($e.$$.fragment),Pt=l(),f(D.$$.fragment),Lt=l(),f(we.$$.fragment),Jt=l(),w=p("div"),f(xe.$$.fragment),Ft=l(),et=p("p"),et.innerHTML=Zo,qt=l(),tt=p("p"),tt.innerHTML=Vo,Xt=l(),f(O.$$.fragment),St=l(),K=p("div"),f(Pe.$$.fragment),Yt=l(),ot=p("p"),ot.innerHTML=Ho,At=l(),f(Le.$$.fragment),jt=l(),J=p("div"),f(Je.$$.fragment),Dt=l(),nt=p("p"),nt.innerHTML=Eo,Ot=l(),st=p("p"),st.innerHTML=Qo,Kt=l(),f(ee.$$.fragment),kt=l(),f(Ae.$$.fragment),Ut=l(),A=p("div"),f(je.$$.fragment),eo=l(),at=p("p"),at.innerHTML=Go,to=l(),rt=p("p"),rt.innerHTML=No,oo=l(),f(te.$$.fragment),Bt=l(),f(ke.$$.fragment),zt=l(),x=p("div"),f(Ue.$$.fragment),no=l(),lt=p("p"),lt.textContent=Ro,so=l(),it=p("p"),it.innerHTML=Fo,ao=l(),oe=p("div"),f(Be.$$.fragment),ro=l(),dt=p("p"),dt.innerHTML=qo,lo=l(),ne=p("div"),f(ze.$$.fragment),io=l(),ct=p("p"),ct.innerHTML=Xo,Wt=l(),f(We.$$.fragment),Zt=l(),j=p("div"),f(Ze.$$.fragment),co=l(),B=p("div"),f(Ve.$$.fragment),po=l(),pt=p("p"),pt.innerHTML=So,mo=l(),f(se.$$.fragment),fo=l(),f(ae.$$.fragment),go=l(),z=p("div"),f(He.$$.fragment),uo=l(),mt=p("p"),mt.innerHTML=Yo,ho=l(),f(re.$$.fragment),_o=l(),f(le.$$.fragment),Mo=l(),W=p("div"),f(Ee.$$.fragment),bo=l(),ft=p("p"),ft.innerHTML=Do,Co=l(),f(ie.$$.fragment),To=l(),f(de.$$.fragment),Vt=l(),f(Qe.$$.fragment),Ht=l(),X=p("div"),f(Ge.$$.fragment),yo=l(),Z=p("div"),f(Ne.$$.fragment),Io=l(),gt=p("p"),gt.innerHTML=Oo,vo=l(),f(ce.$$.fragment),$o=l(),f(pe.$$.fragment),Et=l(),f(Re.$$.fragment),Qt=l(),S=p("div"),f(Fe.$$.fragment),wo=l(),V=p("div"),f(qe.$$.fragment),xo=l(),ut=p("p"),ut.innerHTML=Ko,Po=l(),f(me.$$.fragment),Lo=l(),f(fe.$$.fragment),Gt=l(),f(Xe.$$.fragment),Nt=l(),_t=p("p"),this.h()},l(e){const n=sn("svelte-u9bgzb",document.head);o=m(n,"META",{name:!0,content:!0}),n.forEach(s),C=i(e),a=m(e,"P",{}),v(a).forEach(s),r=i(e),g(b.$$.fragment,e),t=i(e),g(T.$$.fragment,e),Mt=i(e),he=m(e,"P",{"data-svelte-h":!0}),y(he)!=="svelte-u3ci1i"&&(he.innerHTML=Jo),bt=i(e),_e=m(e,"P",{"data-svelte-h":!0}),y(_e)!=="svelte-vfdo9a"&&(_e.textContent=Ao),Ct=i(e),Me=m(e,"P",{"data-svelte-h":!0}),y(Me)!=="svelte-fr1ot4"&&(Me.innerHTML=jo),Tt=i(e),be=m(e,"P",{"data-svelte-h":!0}),y(be)!=="svelte-zmfqz"&&(be.innerHTML=ko),yt=i(e),g(Ce.$$.fragment,e),It=i(e),Te=m(e,"P",{"data-svelte-h":!0}),y(Te)!=="svelte-1kvq7kq"&&(Te.textContent=Uo),vt=i(e),ye=m(e,"P",{"data-svelte-h":!0}),y(ye)!=="svelte-zjm5tb"&&(ye.textContent=Bo),$t=i(e),Ie=m(e,"P",{"data-svelte-h":!0}),y(Ie)!=="svelte-e9gs3j"&&(Ie.innerHTML=zo),wt=i(e),ve=m(e,"P",{"data-svelte-h":!0}),y(ve)!=="svelte-nx3kk6"&&(ve.innerHTML=Wo),xt=i(e),g($e.$$.fragment,e),Pt=i(e),g(D.$$.fragment,e),Lt=i(e),g(we.$$.fragment,e),Jt=i(e),w=m(e,"DIV",{class:!0});var k=v(w);g(xe.$$.fragment,k),Ft=i(k),et=m(k,"P",{"data-svelte-h":!0}),y(et)!=="svelte-1uzzr1t"&&(et.innerHTML=Zo),qt=i(k),tt=m(k,"P",{"data-svelte-h":!0}),y(tt)!=="svelte-l1blo3"&&(tt.innerHTML=Vo),Xt=i(k),g(O.$$.fragment,k),St=i(k),K=m(k,"DIV",{class:!0});var Se=v(K);g(Pe.$$.fragment,Se),Yt=i(Se),ot=m(Se,"P",{"data-svelte-h":!0}),y(ot)!=="svelte-1mm9rgg"&&(ot.innerHTML=Ho),Se.forEach(s),k.forEach(s),At=i(e),g(Le.$$.fragment,e),jt=i(e),J=m(e,"DIV",{class:!0});var H=v(J);g(Je.$$.fragment,H),Dt=i(H),nt=m(H,"P",{"data-svelte-h":!0}),y(nt)!=="svelte-179ioue"&&(nt.innerHTML=Eo),Ot=i(H),st=m(H,"P",{"data-svelte-h":!0}),y(st)!=="svelte-l1blo3"&&(st.innerHTML=Qo),Kt=i(H),g(ee.$$.fragment,H),H.forEach(s),kt=i(e),g(Ae.$$.fragment,e),Ut=i(e),A=m(e,"DIV",{class:!0});var E=v(A);g(je.$$.fragment,E),eo=i(E),at=m(E,"P",{"data-svelte-h":!0}),y(at)!=="svelte-1uzzr1t"&&(at.innerHTML=Go),to=i(E),rt=m(E,"P",{"data-svelte-h":!0}),y(rt)!=="svelte-l1blo3"&&(rt.innerHTML=No),oo=i(E),g(te.$$.fragment,E),E.forEach(s),Bt=i(e),g(ke.$$.fragment,e),zt=i(e),x=m(e,"DIV",{class:!0});var U=v(x);g(Ue.$$.fragment,U),no=i(U),lt=m(U,"P",{"data-svelte-h":!0}),y(lt)!=="svelte-1rdismf"&&(lt.textContent=Ro),so=i(U),it=m(U,"P",{"data-svelte-h":!0}),y(it)!=="svelte-ahdwow"&&(it.innerHTML=Fo),ao=i(U),oe=m(U,"DIV",{class:!0});var Ye=v(oe);g(Be.$$.fragment,Ye),ro=i(Ye),dt=m(Ye,"P",{"data-svelte-h":!0}),y(dt)!=="svelte-lq5gay"&&(dt.innerHTML=qo),Ye.forEach(s),lo=i(U),ne=m(U,"DIV",{class:!0});var De=v(ne);g(ze.$$.fragment,De),io=i(De),ct=m(De,"P",{"data-svelte-h":!0}),y(ct)!=="svelte-1vgq5rc"&&(ct.innerHTML=Xo),De.forEach(s),U.forEach(s),Wt=i(e),g(We.$$.fragment,e),Zt=i(e),j=m(e,"DIV",{class:!0});var Q=v(j);g(Ze.$$.fragment,Q),co=i(Q),B=m(Q,"DIV",{class:!0});var G=v(B);g(Ve.$$.fragment,G),po=i(G),pt=m(G,"P",{"data-svelte-h":!0}),y(pt)!=="svelte-1d00qo5"&&(pt.innerHTML=So),mo=i(G),g(se.$$.fragment,G),fo=i(G),g(ae.$$.fragment,G),G.forEach(s),go=i(Q),z=m(Q,"DIV",{class:!0});var N=v(z);g(He.$$.fragment,N),uo=i(N),mt=m(N,"P",{"data-svelte-h":!0}),y(mt)!=="svelte-1d00qo5"&&(mt.innerHTML=Yo),ho=i(N),g(re.$$.fragment,N),_o=i(N),g(le.$$.fragment,N),N.forEach(s),Mo=i(Q),W=m(Q,"DIV",{class:!0});var R=v(W);g(Ee.$$.fragment,R),bo=i(R),ft=m(R,"P",{"data-svelte-h":!0}),y(ft)!=="svelte-1d00qo5"&&(ft.innerHTML=Do),Co=i(R),g(ie.$$.fragment,R),To=i(R),g(de.$$.fragment,R),R.forEach(s),Q.forEach(s),Vt=i(e),g(Qe.$$.fragment,e),Ht=i(e),X=m(e,"DIV",{class:!0});var Oe=v(X);g(Ge.$$.fragment,Oe),yo=i(Oe),Z=m(Oe,"DIV",{class:!0});var F=v(Z);g(Ne.$$.fragment,F),Io=i(F),gt=m(F,"P",{"data-svelte-h":!0}),y(gt)!=="svelte-nrb0h3"&&(gt.innerHTML=Oo),vo=i(F),g(ce.$$.fragment,F),$o=i(F),g(pe.$$.fragment,F),F.forEach(s),Oe.forEach(s),Et=i(e),g(Re.$$.fragment,e),Qt=i(e),S=m(e,"DIV",{class:!0});var Ke=v(S);g(Fe.$$.fragment,Ke),wo=i(Ke),V=m(Ke,"DIV",{class:!0});var ge=v(V);g(qe.$$.fragment,ge),xo=i(ge),ut=m(ge,"P",{"data-svelte-h":!0}),y(ut)!=="svelte-ub2tth"&&(ut.innerHTML=Ko),Po=i(ge),g(me.$$.fragment,ge),Lo=i(ge),g(fe.$$.fragment,ge),ge.forEach(s),Ke.forEach(s),Gt=i(e),g(Xe.$$.fragment,e),Nt=i(e),_t=m(e,"P",{}),v(_t).forEach(s),this.h()},h(){$(o,"name","hf:doc:metadata"),$(o,"content",yn),$(K,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(w,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,n){c(document.head,o),d(e,C,n),d(e,a,n),d(e,r,n),u(b,e,n),d(e,t,n),u(T,e,n),d(e,Mt,n),d(e,he,n),d(e,bt,n),d(e,_e,n),d(e,Ct,n),d(e,Me,n),d(e,Tt,n),d(e,be,n),d(e,yt,n),u(Ce,e,n),d(e,It,n),d(e,Te,n),d(e,vt,n),d(e,ye,n),d(e,$t,n),d(e,Ie,n),d(e,wt,n),d(e,ve,n),d(e,xt,n),u($e,e,n),d(e,Pt,n),u(D,e,n),d(e,Lt,n),u(we,e,n),d(e,Jt,n),d(e,w,n),u(xe,w,null),c(w,Ft),c(w,et),c(w,qt),c(w,tt),c(w,Xt),u(O,w,null),c(w,St),c(w,K),u(Pe,K,null),c(K,Yt),c(K,ot),d(e,At,n),u(Le,e,n),d(e,jt,n),d(e,J,n),u(Je,J,null),c(J,Dt),c(J,nt),c(J,Ot),c(J,st),c(J,Kt),u(ee,J,null),d(e,kt,n),u(Ae,e,n),d(e,Ut,n),d(e,A,n),u(je,A,null),c(A,eo),c(A,at),c(A,to),c(A,rt),c(A,oo),u(te,A,null),d(e,Bt,n),u(ke,e,n),d(e,zt,n),d(e,x,n),u(Ue,x,null),c(x,no),c(x,lt),c(x,so),c(x,it),c(x,ao),c(x,oe),u(Be,oe,null),c(oe,ro),c(oe,dt),c(x,lo),c(x,ne),u(ze,ne,null),c(ne,io),c(ne,ct),d(e,Wt,n),u(We,e,n),d(e,Zt,n),d(e,j,n),u(Ze,j,null),c(j,co),c(j,B),u(Ve,B,null),c(B,po),c(B,pt),c(B,mo),u(se,B,null),c(B,fo),u(ae,B,null),c(j,go),c(j,z),u(He,z,null),c(z,uo),c(z,mt),c(z,ho),u(re,z,null),c(z,_o),u(le,z,null),c(j,Mo),c(j,W),u(Ee,W,null),c(W,bo),c(W,ft),c(W,Co),u(ie,W,null),c(W,To),u(de,W,null),d(e,Vt,n),u(Qe,e,n),d(e,Ht,n),d(e,X,n),u(Ge,X,null),c(X,yo),c(X,Z),u(Ne,Z,null),c(Z,Io),c(Z,gt),c(Z,vo),u(ce,Z,null),c(Z,$o),u(pe,Z,null),d(e,Et,n),u(Re,e,n),d(e,Qt,n),d(e,S,n),u(Fe,S,null),c(S,wo),c(S,V),u(qe,V,null),c(V,xo),c(V,ut),c(V,Po),u(me,V,null),c(V,Lo),u(fe,V,null),d(e,Gt,n),u(Xe,e,n),d(e,Nt,n),d(e,_t,n),Rt=!0},p(e,[n]){const k={};n&2&&(k.$$scope={dirty:n,ctx:e}),D.$set(k);const Se={};n&2&&(Se.$$scope={dirty:n,ctx:e}),O.$set(Se);const H={};n&2&&(H.$$scope={dirty:n,ctx:e}),ee.$set(H);const E={};n&2&&(E.$$scope={dirty:n,ctx:e}),te.$set(E);const U={};n&2&&(U.$$scope={dirty:n,ctx:e}),se.$set(U);const Ye={};n&2&&(Ye.$$scope={dirty:n,ctx:e}),ae.$set(Ye);const De={};n&2&&(De.$$scope={dirty:n,ctx:e}),re.$set(De);const Q={};n&2&&(Q.$$scope={dirty:n,ctx:e}),le.$set(Q);const G={};n&2&&(G.$$scope={dirty:n,ctx:e}),ie.$set(G);const N={};n&2&&(N.$$scope={dirty:n,ctx:e}),de.$set(N);const R={};n&2&&(R.$$scope={dirty:n,ctx:e}),ce.$set(R);const Oe={};n&2&&(Oe.$$scope={dirty:n,ctx:e}),pe.$set(Oe);const F={};n&2&&(F.$$scope={dirty:n,ctx:e}),me.$set(F);const Ke={};n&2&&(Ke.$$scope={dirty:n,ctx:e}),fe.$set(Ke)},i(e){Rt||(h(b.$$.fragment,e),h(T.$$.fragment,e),h(Ce.$$.fragment,e),h($e.$$.fragment,e),h(D.$$.fragment,e),h(we.$$.fragment,e),h(xe.$$.fragment,e),h(O.$$.fragment,e),h(Pe.$$.fragment,e),h(Le.$$.fragment,e),h(Je.$$.fragment,e),h(ee.$$.fragment,e),h(Ae.$$.fragment,e),h(je.$$.fragment,e),h(te.$$.fragment,e),h(ke.$$.fragment,e),h(Ue.$$.fragment,e),h(Be.$$.fragment,e),h(ze.$$.fragment,e),h(We.$$.fragment,e),h(Ze.$$.fragment,e),h(Ve.$$.fragment,e),h(se.$$.fragment,e),h(ae.$$.fragment,e),h(He.$$.fragment,e),h(re.$$.fragment,e),h(le.$$.fragment,e),h(Ee.$$.fragment,e),h(ie.$$.fragment,e),h(de.$$.fragment,e),h(Qe.$$.fragment,e),h(Ge.$$.fragment,e),h(Ne.$$.fragment,e),h(ce.$$.fragment,e),h(pe.$$.fragment,e),h(Re.$$.fragment,e),h(Fe.$$.fragment,e),h(qe.$$.fragment,e),h(me.$$.fragment,e),h(fe.$$.fragment,e),h(Xe.$$.fragment,e),Rt=!0)},o(e){_(b.$$.fragment,e),_(T.$$.fragment,e),_(Ce.$$.fragment,e),_($e.$$.fragment,e),_(D.$$.fragment,e),_(we.$$.fragment,e),_(xe.$$.fragment,e),_(O.$$.fragment,e),_(Pe.$$.fragment,e),_(Le.$$.fragment,e),_(Je.$$.fragment,e),_(ee.$$.fragment,e),_(Ae.$$.fragment,e),_(je.$$.fragment,e),_(te.$$.fragment,e),_(ke.$$.fragment,e),_(Ue.$$.fragment,e),_(Be.$$.fragment,e),_(ze.$$.fragment,e),_(We.$$.fragment,e),_(Ze.$$.fragment,e),_(Ve.$$.fragment,e),_(se.$$.fragment,e),_(ae.$$.fragment,e),_(He.$$.fragment,e),_(re.$$.fragment,e),_(le.$$.fragment,e),_(Ee.$$.fragment,e),_(ie.$$.fragment,e),_(de.$$.fragment,e),_(Qe.$$.fragment,e),_(Ge.$$.fragment,e),_(Ne.$$.fragment,e),_(ce.$$.fragment,e),_(pe.$$.fragment,e),_(Re.$$.fragment,e),_(Fe.$$.fragment,e),_(qe.$$.fragment,e),_(me.$$.fragment,e),_(fe.$$.fragment,e),_(Xe.$$.fragment,e),Rt=!1},d(e){e&&(s(C),s(a),s(r),s(t),s(Mt),s(he),s(bt),s(_e),s(Ct),s(Me),s(Tt),s(be),s(yt),s(It),s(Te),s(vt),s(ye),s($t),s(Ie),s(wt),s(ve),s(xt),s(Pt),s(Lt),s(Jt),s(w),s(At),s(jt),s(J),s(kt),s(Ut),s(A),s(Bt),s(zt),s(x),s(Wt),s(Zt),s(j),s(Vt),s(Ht),s(X),s(Et),s(Qt),s(S),s(Gt),s(Nt),s(_t)),s(o),M(b,e),M(T,e),M(Ce,e),M($e,e),M(D,e),M(we,e),M(xe),M(O),M(Pe),M(Le,e),M(Je),M(ee),M(Ae,e),M(je),M(te),M(ke,e),M(Ue),M(Be),M(ze),M(We,e),M(Ze),M(Ve),M(se),M(ae),M(He),M(re),M(le),M(Ee),M(ie),M(de),M(Qe,e),M(Ge),M(Ne),M(ce),M(pe),M(Re,e),M(Fe),M(qe),M(me),M(fe),M(Xe,e)}}}const yn='{"title":"AltCLIP","local":"altclip","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Usage tips and example","local":"usage-tips-and-example","sections":[],"depth":2},{"title":"AltCLIPConfig","local":"transformers.AltCLIPConfig","sections":[],"depth":2},{"title":"AltCLIPTextConfig","local":"transformers.AltCLIPTextConfig","sections":[],"depth":2},{"title":"AltCLIPVisionConfig","local":"transformers.AltCLIPVisionConfig","sections":[],"depth":2},{"title":"AltCLIPProcessor","local":"transformers.AltCLIPProcessor","sections":[],"depth":2},{"title":"AltCLIPModel","local":"transformers.AltCLIPModel","sections":[],"depth":2},{"title":"AltCLIPTextModel","local":"transformers.AltCLIPTextModel","sections":[],"depth":2},{"title":"AltCLIPVisionModel","local":"transformers.AltCLIPVisionModel","sections":[],"depth":2}],"depth":1}';function In(I){return tn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class An extends on{constructor(o){super(),nn(this,o,In,Tn,en,{})}}export{An as component};
