import{s as Ea,o as qa,n as Fs}from"../chunks/scheduler.25b97de1.js";import{S as Sa,i as La,g as o,s as n,r as p,A as Aa,h as i,f as s,c as l,j as Ya,u as c,x as r,k as zs,y as Da,a,v as d,d as m,t as h,w as u}from"../chunks/index.d9030fc9.js";import{T as Ns}from"../chunks/Tip.baa67368.js";import{C as b}from"../chunks/CodeBlock.e6cd0d95.js";import{H as M,E as Ka}from"../chunks/EditOnGithub.91d95064.js";function Pa(j){let g,f="The API for the streamer classes is still under development and may change in the future.";return{c(){g=o("p"),g.textContent=f},l(y){g=i(y,"P",{"data-svelte-h":!0}),r(g)!=="svelte-gv2g1g"&&(g.textContent=f)},m(y,T){a(y,g,T)},p:Fs,d(y){y&&s(g)}}}function Oa(j){let g,f="Cache quantization can be detrimental if the context length is short and there is enough GPU VRAM available to run without cache quantization.";return{c(){g=o("p"),g.textContent=f},l(y){g=i(y,"P",{"data-svelte-h":!0}),r(g)!=="svelte-1xmzb13"&&(g.textContent=f)},m(y,T){a(y,g,T)},p:Fs,d(y){y&&s(g)}}}function en(j){let g,f=`The WatermarkDetector internally relies on the proportion of “green” tokens, and whether generated text follows the coloring pattern.
That is why it is recommended to strip off the prompt text, if it is much longer than the generated text.
This also can have an effect when one sequence in the batch is a lot longer causing other rows to be padded.
Additionally, the detector <strong>must</strong> be initiated with identical watermark configuration arguments used when generating.`;return{c(){g=o("p"),g.innerHTML=f},l(y){g=i(y,"P",{"data-svelte-h":!0}),r(g)!=="svelte-ge8sma"&&(g.innerHTML=f)},m(y,T){a(y,g,T)},p:Fs,d(y){y&&s(g)}}}function tn(j){let g,f,y,T,Z,nt,v,Qs=`Text generation is essential to many NLP tasks, such as open-ended text generation, summarization, translation, and
more. It also plays a role in a variety of mixed-modality applications that have text as an output like speech-to-text
and vision-to-text. Some of the models that can generate text include
GPT2, XLNet, OpenAI GPT, CTRL, TransformerXL, XLM, Bart, T5, GIT, Whisper.`,lt,W,Ys=`Check out a few examples that use <a href="/docs/transformers/pr_30530/en/main_classes/text_generation#transformers.GenerationMixin.generate">generate()</a> method to produce
text outputs for different tasks:`,ot,G,Es='<li><a href="./tasks/summarization#inference">Text summarization</a></li> <li><a href="./model_doc/git#transformers.GitForCausalLM.forward.example">Image captioning</a></li> <li><a href="./model_doc/whisper#transformers.WhisperForConditionalGeneration.forward.example">Audio transcription</a></li>',it,B,qs=`Note that the inputs to the generate method depend on the model’s modality. They are returned by the model’s preprocessor
class, such as AutoTokenizer or AutoProcessor. If a model’s preprocessor creates more than one kind of input, pass all
the inputs to generate(). You can learn more about the individual model’s preprocessor in the corresponding model’s documentation.`,rt,V,Ss=`The process of selecting output tokens to generate text is known as decoding, and you can customize the decoding strategy
that the <code>generate()</code> method will use. Modifying a decoding strategy does not change the values of any trainable parameters.
However, it can have a noticeable impact on the quality of the generated output. It can help reduce repetition in the text
and make it more coherent.`,pt,C,Ls="This guide describes:",ct,X,As="<li>default generation configuration</li> <li>common decoding strategies and their main parameters</li> <li>saving and sharing custom generation configurations with your fine-tuned model on 🤗 Hub</li>",dt,_,mt,R,Ds=`A decoding strategy for a model is defined in its generation configuration. When using pre-trained models for inference
within a <a href="/docs/transformers/pr_30530/en/main_classes/pipelines#transformers.pipeline">pipeline()</a>, the models call the <code>PreTrainedModel.generate()</code> method that applies a default generation
configuration under the hood. The default configuration is also used when no custom configuration has been saved with
the model.`,ht,I,Ks=`When you load a model explicitly, you can inspect the generation configuration that comes with it through
<code>model.generation_config</code>:`,ut,H,gt,x,Ps=`Printing out the <code>model.generation_config</code> reveals only the values that are different from the default generation
configuration, and does not list any of the default values.`,yt,$,Os=`The default generation configuration limits the size of the output combined with the input prompt to a maximum of 20
tokens to avoid running into resource limitations. The default decoding strategy is greedy search, which is the simplest decoding strategy that picks a token with the highest probability as the next token. For many tasks
and small output sizes this works well. However, when used to generate longer outputs, greedy search can start
producing highly repetitive results.`,Mt,z,bt,N,ea="You can override any <code>generation_config</code> by passing the parameters and their values directly to the <code>generate</code> method:",ft,F,Tt,Q,ta=`Even if the default decoding strategy mostly works for your task, you can still tweak a few things. Some of the
commonly adjusted parameters include:`,wt,Y,sa=`<li><code>max_new_tokens</code>: the maximum number of tokens to generate. In other words, the size of the output sequence, not
including the tokens in the prompt. As an alternative to using the output’s length as a stopping criteria, you can choose
to stop generation whenever the full generation exceeds some amount of time. To learn more, check <a href="/docs/transformers/pr_30530/en/internal/generation_utils#transformers.StoppingCriteria">StoppingCriteria</a>.</li> <li><code>num_beams</code>: by specifying a number of beams higher than 1, you are effectively switching from greedy search to
beam search. This strategy evaluates several hypotheses at each time step and eventually chooses the hypothesis that
has the overall highest probability for the entire sequence. This has the advantage of identifying high-probability
sequences that start with a lower probability initial tokens and would’ve been ignored by the greedy search. Visualize how it works <a href="https://huggingface.co/spaces/m-ric/beam_search_visualizer" rel="nofollow">here</a>.</li> <li><code>do_sample</code>: if set to <code>True</code>, this parameter enables decoding strategies such as multinomial sampling, beam-search
multinomial sampling, Top-K sampling and Top-p sampling. All these strategies select the next token from the probability
distribution over the entire vocabulary with various strategy-specific adjustments.</li> <li><code>num_return_sequences</code>: the number of sequence candidates to return for each input. This option is only available for
the decoding strategies that support multiple sequence candidates, e.g. variations of beam search and sampling. Decoding
strategies like greedy search and contrastive search return a single output sequence.</li>`,jt,E,Jt,q,aa="If you would like to share your fine-tuned model with a specific generation configuration, you can:",Ut,S,na='<li>Create a <a href="/docs/transformers/pr_30530/en/main_classes/text_generation#transformers.GenerationConfig">GenerationConfig</a> class instance</li> <li>Specify the decoding strategy parameters</li> <li>Save your generation configuration with <a href="/docs/transformers/pr_30530/en/main_classes/text_generation#transformers.GenerationConfig.save_pretrained">GenerationConfig.save_pretrained()</a>, making sure to leave its <code>config_file_name</code> argument empty</li> <li>Set <code>push_to_hub</code> to <code>True</code> to upload your config to the model’s repo</li>',kt,L,Zt,A,la=`You can also store several generation configurations in a single directory, making use of the <code>config_file_name</code>
argument in <a href="/docs/transformers/pr_30530/en/main_classes/text_generation#transformers.GenerationConfig.save_pretrained">GenerationConfig.save_pretrained()</a>. You can later instantiate them with <a href="/docs/transformers/pr_30530/en/main_classes/text_generation#transformers.GenerationConfig.from_pretrained">GenerationConfig.from_pretrained()</a>. This is useful if you want to
store several generation configurations for a single model (e.g. one for creative text generation with sampling, and
one for summarization with beam search). You must have the right Hub permissions to add configuration files to a model.`,vt,D,Wt,K,Gt,P,oa=`The <code>generate()</code> supports streaming, through its <code>streamer</code> input. The <code>streamer</code> input is compatible with any instance
from a class that has the following methods: <code>put()</code> and <code>end()</code>. Internally, <code>put()</code> is used to push new tokens and
<code>end()</code> is used to flag the end of text generation.`,Bt,J,Vt,O,ia=`In practice, you can craft your own streaming class for all sorts of purposes! We also have basic streaming classes
ready for you to use. For example, you can use the <a href="/docs/transformers/pr_30530/en/internal/generation_utils#transformers.TextStreamer">TextStreamer</a> class to stream the output of <code>generate()</code> into
your screen, one word at a time:`,Ct,ee,Xt,te,_t,se,ra=`The <code>generate()</code> method supports caching keys and values to enhance efficiency and avoid re-computations. However the key and value
cache can occupy a large portion of memory, becoming a bottleneck for long-context generation, especially for Large Language Models.
Quantizing the cache when using <code>generate()</code> can significantly reduce memory requirements at the cost of speed.`,Rt,ae,pa=`KV Cache quantization in <code>transformers</code> is largely inspired by the paper [KIVI: A Tuning-Free Asymmetric 2bit Quantization for KV Cache]
(<a href="https://arxiv.org/abs/2402.02750" rel="nofollow">https://arxiv.org/abs/2402.02750</a>) and currently supports <code>quanto</code> and <code>HQQ</code> as backends. For more information on the inner workings see the paper.`,It,ne,ca=`To enable quantization of the key-value cache, one needs to indicate <code>cache_implementation=&quot;quantized&quot;</code> in the <code>generation_config</code>.
Quantization related arguments should be passed to the <code>generation_config</code> either as a <code>dict</code> or an instance of a <a href="/docs/transformers/pr_30530/en/internal/generation_utils#transformers.QuantizedCacheConfig">QuantizedCacheConfig</a> class.
One has to indicate which quantization backend to use in the <a href="/docs/transformers/pr_30530/en/internal/generation_utils#transformers.QuantizedCacheConfig">QuantizedCacheConfig</a>, the default is <code>quanto</code>.`,Ht,U,xt,le,$t,oe,zt,ie,da=`The <code>generate()</code> supports watermarking the generated text by randomly marking a portion of tokens as “green”.
When generating the “green” will have a small ‘bias’ value added to their logits, thus having a higher chance to be generated.
The watermarked text can be detected by calculating the proportion of “green” tokens in the text and estimating how likely it is
statistically to obtain that amount of “green” tokens for human-generated text. This watermarking strategy was proposed in the paper
<a href="https://arxiv.org/abs/2306.04634" rel="nofollow">“On the Reliability of Watermarks for Large Language Models”</a>. For more information on
the inner functioning of watermarking, it is recommended to refer to the paper.`,Nt,re,ma=`The watermarking can be used with any generative model in <code>tranformers</code> and does not require an extra classification model
to detect watermarked text. To trigger watermarking, pass in a <a href="/docs/transformers/pr_30530/en/main_classes/text_generation#transformers.WatermarkingConfig">WatermarkingConfig</a> with needed arguments directly to the
<code>.generate()</code> method or add it to the <a href="/docs/transformers/pr_30530/en/main_classes/text_generation#transformers.GenerationConfig">GenerationConfig</a>. Watermarked text can be later detected with a <a href="/docs/transformers/pr_30530/en/internal/generation_utils#transformers.WatermarkDetector">WatermarkDetector</a>.`,Ft,k,Qt,pe,ha=`Let’s generate some text with watermarking. In the below code snippet, we set the bias to 2.5 which is a value that
will be added to “green” tokens’ logits. After generating watermarked text, we can pass it directly to the <code>WatermarkDetector</code>
to check if the text is machine-generated (outputs <code>True</code> for machine-generated and <code>False</code> otherwise).`,Yt,ce,Et,de,qt,me,ua=`Certain combinations of the <code>generate()</code> parameters, and ultimately <code>generation_config</code>, can be used to enable specific
decoding strategies. If you are new to this concept, we recommend reading <a href="https://huggingface.co/blog/how-to-generate" rel="nofollow">this blog post that illustrates how common decoding strategies work</a>.`,St,he,ga="Here, we’ll show some of the parameters that control the decoding strategies and illustrate how you can use them.",Lt,ue,At,ge,ya="<code>generate</code> uses greedy search decoding by default so you don’t have to pass any parameters to enable it. This means the parameters <code>num_beams</code> is set to 1 and <code>do_sample=False</code>.",Dt,ye,Kt,Me,Pt,be,Ma=`The contrastive search decoding strategy was proposed in the 2022 paper <a href="https://arxiv.org/abs/2202.06417" rel="nofollow">A Contrastive Framework for Neural Text Generation</a>.
It demonstrates superior results for generating non-repetitive yet coherent long outputs. To learn how contrastive search
works, check out <a href="https://huggingface.co/blog/introducing-csearch" rel="nofollow">this blog post</a>.
The two main parameters that enable and control the behavior of contrastive search are <code>penalty_alpha</code> and <code>top_k</code>:`,Ot,fe,es,Te,ts,we,ba=`As opposed to greedy search that always chooses a token with the highest probability as the
next token, multinomial sampling (also called ancestral sampling) randomly selects the next token based on the probability distribution over the entire
vocabulary given by the model. Every token with a non-zero probability has a chance of being selected, thus reducing the
risk of repetition.`,ss,je,fa="To enable multinomial sampling set <code>do_sample=True</code> and <code>num_beams=1</code>.",as,Je,ns,Ue,ls,ke,Ta=`Unlike greedy search, beam-search decoding keeps several hypotheses at each time step and eventually chooses
the hypothesis that has the overall highest probability for the entire sequence. This has the advantage of identifying high-probability
sequences that start with lower probability initial tokens and would’ve been ignored by the greedy search.`,os,w,wa='<img style="max-width: 90%; margin: auto;" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/beam_search.png"/>',is,Ze,ja='You can visualize how beam-search decoding works in <a href="https://huggingface.co/spaces/m-ric/beam_search_visualizer" rel="nofollow">this interactive demo</a>: type your input sentence, and play with the parameters to see how the decoding beams change.',rs,ve,Ja="To enable this decoding strategy, specify the <code>num_beams</code> (aka number of hypotheses to keep track of) that is greater than 1.",ps,We,cs,Ge,ds,Be,Ua=`As the name implies, this decoding strategy combines beam search with multinomial sampling. You need to specify
the <code>num_beams</code> greater than 1, and set <code>do_sample=True</code> to use this decoding strategy.`,ms,Ve,hs,Ce,us,Xe,ka=`The diverse beam search decoding strategy is an extension of the beam search strategy that allows for generating a more diverse
set of beam sequences to choose from. To learn how it works, refer to <a href="https://arxiv.org/pdf/1610.02424.pdf" rel="nofollow">Diverse Beam Search: Decoding Diverse Solutions from Neural Sequence Models</a>.
This approach has three main parameters: <code>num_beams</code>, <code>num_beam_groups</code>, and <code>diversity_penalty</code>.
The diversity penalty ensures the outputs are distinct across groups, and beam search is used within each group.`,gs,_e,ys,Re,Za=`This guide illustrates the main parameters that enable various decoding strategies. More advanced parameters exist for the
<code>generate</code> method, which gives you even further control over the <code>generate</code> method’s behavior.
For the complete list of the available parameters, refer to the <a href="./main_classes/text_generation.md">API documentation</a>.`,Ms,Ie,bs,He,va=`Speculative decoding (also known as assisted decoding) is a modification of the decoding strategies above, that uses an
assistant model (ideally a much smaller one) with the same tokenizer, to generate a few candidate tokens. The main
model then validates the candidate tokens in a single forward pass, which speeds up the decoding process. If
<code>do_sample=True</code>, then the token validation with resampling introduced in the
<a href="https://arxiv.org/pdf/2211.17192.pdf" rel="nofollow">speculative decoding paper</a> is used.`,fs,xe,Wa=`Currently, only greedy search and sampling are supported with assisted decoding, and assisted decoding doesn’t support batched inputs.
To learn more about assisted decoding, check <a href="https://huggingface.co/blog/assisted-generation" rel="nofollow">this blog post</a>.`,Ts,$e,Ga="To enable assisted decoding, set the <code>assistant_model</code> argument with a model.",ws,ze,js,Ne,Ba=`When using assisted decoding with sampling methods, you can use the <code>temperature</code> argument to control the randomness,
just like in multinomial sampling. However, in assisted decoding, reducing the temperature may help improve the latency.`,Js,Fe,Us,Qe,Va=`Alternativelly, you can also set the <code>prompt_lookup_num_tokens</code> to trigger n-gram based assisted decoding, as opposed
to model based assisted decoding. You can read more about it <a href="https://twitter.com/joao_gante/status/1747322413006643259" rel="nofollow">here</a>.`,ks,Ye,Zs,Ee,Ca=`<strong>D</strong>ecoding by C<strong>o</strong>ntrasting <strong>La</strong>yers (DoLa) is a contrastive decoding strategy to improve the factuality and reduce the
hallucinations of LLMs, as described in this paper of ICLR 2024 <a href="https://arxiv.org/abs/2309.03883" rel="nofollow">DoLa: Decoding by Contrasting Layers Improves Factuality in Large Language Models</a>.`,vs,qe,Xa=`DoLa is achieved by contrasting the differences in logits obtained from final
layers versus earlier layers, thus amplify the factual knowledge localized to particular part of transformer layers.`,Ws,Se,_a="Do the following two steps to activate DoLa decoding when calling the <code>model.generate</code> function:",Gs,Le,Ra="<li>Set the <code>dola_layers</code> argument, which can be either a string or a list of integers.<ul><li>If set to a string, it can be one of <code>low</code>, <code>high</code>.</li> <li>If set to a list of integers, it should be a list of layer indices between 0 and the total number of layers in the model. The 0-th layer is word embedding, and the 1st layer is the first transformer layer, and so on.</li></ul></li> <li>Set <code>repetition_penalty = 1.2</code> is suggested to reduce repetition in DoLa decoding.</li>",Bs,Ae,Ia="See the following examples for DoLa decoding with the 32-layer LLaMA-7B model.",Vs,De,Cs,Ke,Xs,Pe,Ha="<code>dola_layers</code> stands for the candidate layers in premature layer selection, as described in the DoLa paper. The selected premature layer will be contrasted with the final layer.",_s,Oe,xa="Setting <code>dola_layers</code> to <code>&#39;low&#39;</code> or <code>&#39;high&#39;</code> will select the lower or higher part of the layers to contrast, respectively.",Rs,et,$a="<li>For <code>N</code>-layer models with <code>N &lt;= 40</code> layers, the layers of <code>range(0, N // 2, 2)</code> and <code>range(N // 2, N, 2)</code> are used for <code>&#39;low&#39;</code> and <code>&#39;high&#39;</code> layers, respectively.</li> <li>For models with <code>N &gt; 40</code> layers, the layers of <code>range(0, 20, 2)</code> and <code>range(N - 20, N, 2)</code> are used for <code>&#39;low&#39;</code> and <code>&#39;high&#39;</code> layers, respectively.</li> <li>If the model has tied word embeddings, we skip the word embeddings (0-th) layer and start from the 2nd layer, as the early exit from word embeddings will become identity function.</li> <li>Set the <code>dola_layers</code> to a list of integers for layer indices to contrast manually specified layers. For example, setting <code>dola_layers=[28,30]</code> will contrast the final layer (32-th layer) with the 28-th and 30-th layers.</li>",Is,tt,za="The paper suggested that contrasting <code>&#39;high&#39;</code> layers to improve short-answer tasks like TruthfulQA, and contrasting <code>&#39;low&#39;</code> layers to improve all the other long-answer reasoning tasks, such as GSM8K, StrategyQA, FACTOR, and VicunaQA. Applying DoLa to smaller models like GPT-2 is not recommended, as the results shown in the Appendix N of the paper.",Hs,st,xs,at,$s;return Z=new M({props:{title:"Text generation strategies",local:"text-generation-strategies",headingTag:"h1"}}),_=new M({props:{title:"Default text generation configuration",local:"default-text-generation-configuration",headingTag:"h2"}}),H=new b({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyZGlzdGlsYmVydCUyRmRpc3RpbGdwdDIlMjIpJTBBbW9kZWwuZ2VuZXJhdGlvbl9jb25maWc=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.generation_config
GenerationConfig {
  <span class="hljs-string">&quot;bos_token_id&quot;</span>: <span class="hljs-number">50256</span>,
  <span class="hljs-string">&quot;eos_token_id&quot;</span>: <span class="hljs-number">50256</span>
}
&lt;BLANKLINE&gt;`,wrap:!1}}),z=new M({props:{title:"Customize text generation",local:"customize-text-generation",headingTag:"h2"}}),F=new b({props:{code:"bXlfbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBudW1fYmVhbXMlM0Q0JTJDJTIwZG9fc2FtcGxlJTNEVHJ1ZSk=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>my_model.generate(**inputs, num_beams=<span class="hljs-number">4</span>, do_sample=<span class="hljs-literal">True</span>)',wrap:!1}}),E=new M({props:{title:"Save a custom decoding strategy with your model",local:"save-a-custom-decoding-strategy-with-your-model",headingTag:"h2"}}),L=new b({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwR2VuZXJhdGlvbkNvbmZpZyUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm15X2FjY291bnQlMkZteV9tb2RlbCUyMiklMEFnZW5lcmF0aW9uX2NvbmZpZyUyMCUzRCUyMEdlbmVyYXRpb25Db25maWcoJTBBJTIwJTIwJTIwJTIwbWF4X25ld190b2tlbnMlM0Q1MCUyQyUyMGRvX3NhbXBsZSUzRFRydWUlMkMlMjB0b3BfayUzRDUwJTJDJTIwZW9zX3Rva2VuX2lkJTNEbW9kZWwuY29uZmlnLmVvc190b2tlbl9pZCUwQSklMEFnZW5lcmF0aW9uX2NvbmZpZy5zYXZlX3ByZXRyYWluZWQoJTIybXlfYWNjb3VudCUyRm15X21vZGVsJTIyJTJDJTIwcHVzaF90b19odWIlM0RUcnVlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, GenerationConfig

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;my_account/my_model&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>generation_config = GenerationConfig(
<span class="hljs-meta">... </span>    max_new_tokens=<span class="hljs-number">50</span>, do_sample=<span class="hljs-literal">True</span>, top_k=<span class="hljs-number">50</span>, eos_token_id=model.config.eos_token_id
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>generation_config.save_pretrained(<span class="hljs-string">&quot;my_account/my_model&quot;</span>, push_to_hub=<span class="hljs-literal">True</span>)`,wrap:!1}}),D=new b({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvclNlcTJTZXFMTSUyQyUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBHZW5lcmF0aW9uQ29uZmlnJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlLXQ1JTJGdDUtc21hbGwlMjIpJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JTZXEyU2VxTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZS10NSUyRnQ1LXNtYWxsJTIyKSUwQSUwQXRyYW5zbGF0aW9uX2dlbmVyYXRpb25fY29uZmlnJTIwJTNEJTIwR2VuZXJhdGlvbkNvbmZpZyglMEElMjAlMjAlMjAlMjBudW1fYmVhbXMlM0Q0JTJDJTBBJTIwJTIwJTIwJTIwZWFybHlfc3RvcHBpbmclM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwZGVjb2Rlcl9zdGFydF90b2tlbl9pZCUzRDAlMkMlMEElMjAlMjAlMjAlMjBlb3NfdG9rZW5faWQlM0Rtb2RlbC5jb25maWcuZW9zX3Rva2VuX2lkJTJDJTBBJTIwJTIwJTIwJTIwcGFkX3Rva2VuJTNEbW9kZWwuY29uZmlnLnBhZF90b2tlbl9pZCUyQyUwQSklMEElMEElMjMlMjBUaXAlM0ElMjBhZGQlMjAlNjBwdXNoX3RvX2h1YiUzRFRydWUlNjAlMjB0byUyMHB1c2glMjB0byUyMHRoZSUyMEh1YiUwQXRyYW5zbGF0aW9uX2dlbmVyYXRpb25fY29uZmlnLnNhdmVfcHJldHJhaW5lZCglMjIlMkZ0bXAlMjIlMkMlMjAlMjJ0cmFuc2xhdGlvbl9nZW5lcmF0aW9uX2NvbmZpZy5qc29uJTIyKSUwQSUwQSUyMyUyMFlvdSUyMGNvdWxkJTIwdGhlbiUyMHVzZSUyMHRoZSUyMG5hbWVkJTIwZ2VuZXJhdGlvbiUyMGNvbmZpZyUyMGZpbGUlMjB0byUyMHBhcmFtZXRlcml6ZSUyMGdlbmVyYXRpb24lMEFnZW5lcmF0aW9uX2NvbmZpZyUyMCUzRCUyMEdlbmVyYXRpb25Db25maWcuZnJvbV9wcmV0cmFpbmVkKCUyMiUyRnRtcCUyMiUyQyUyMCUyMnRyYW5zbGF0aW9uX2dlbmVyYXRpb25fY29uZmlnLmpzb24lMjIpJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMnRyYW5zbGF0ZSUyMEVuZ2xpc2glMjB0byUyMEZyZW5jaCUzQSUyMENvbmZpZ3VyYXRpb24lMjBmaWxlcyUyMGFyZSUyMGVhc3klMjB0byUyMHVzZSElMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMGdlbmVyYXRpb25fY29uZmlnJTNEZ2VuZXJhdGlvbl9jb25maWcpJTBBcHJpbnQodG9rZW5pemVyLmJhdGNoX2RlY29kZShvdXRwdXRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForSeq2SeqLM, AutoTokenizer, GenerationConfig

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;google-t5/t5-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSeq2SeqLM.from_pretrained(<span class="hljs-string">&quot;google-t5/t5-small&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>translation_generation_config = GenerationConfig(
<span class="hljs-meta">... </span>    num_beams=<span class="hljs-number">4</span>,
<span class="hljs-meta">... </span>    early_stopping=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    decoder_start_token_id=<span class="hljs-number">0</span>,
<span class="hljs-meta">... </span>    eos_token_id=model.config.eos_token_id,
<span class="hljs-meta">... </span>    pad_token=model.config.pad_token_id,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Tip: add \`push_to_hub=True\` to push to the Hub</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>translation_generation_config.save_pretrained(<span class="hljs-string">&quot;/tmp&quot;</span>, <span class="hljs-string">&quot;translation_generation_config.json&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># You could then use the named generation config file to parameterize generation</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generation_config = GenerationConfig.from_pretrained(<span class="hljs-string">&quot;/tmp&quot;</span>, <span class="hljs-string">&quot;translation_generation_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;translate English to French: Configuration files are easy to use!&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, generation_config=generation_config)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>))
[<span class="hljs-string">&#x27;Les fichiers de configuration sont faciles à utiliser!&#x27;</span>]`,wrap:!1}}),K=new M({props:{title:"Streaming",local:"streaming",headingTag:"h2"}}),J=new Ns({props:{warning:!0,$$slots:{default:[Pa]},$$scope:{ctx:j}}}),ee=new b({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUyQyUyMFRleHRTdHJlYW1lciUwQSUwQXRvayUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5haS1jb21tdW5pdHklMkZncHQyJTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5haS1jb21tdW5pdHklMkZncHQyJTIyKSUwQWlucHV0cyUyMCUzRCUyMHRvayglNUIlMjJBbiUyMGluY3JlYXNpbmclMjBzZXF1ZW5jZSUzQSUyMG9uZSUyQyUyMiU1RCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBc3RyZWFtZXIlMjAlM0QlMjBUZXh0U3RyZWFtZXIodG9rKSUwQSUwQSUyMyUyMERlc3BpdGUlMjByZXR1cm5pbmclMjB0aGUlMjB1c3VhbCUyMG91dHB1dCUyQyUyMHRoZSUyMHN0cmVhbWVyJTIwd2lsbCUyMGFsc28lMjBwcmludCUyMHRoZSUyMGdlbmVyYXRlZCUyMHRleHQlMjB0byUyMHN0ZG91dC4lMEFfJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBzdHJlYW1lciUzRHN0cmVhbWVyJTJDJTIwbWF4X25ld190b2tlbnMlM0QyMCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer, TextStreamer

<span class="hljs-meta">&gt;&gt;&gt; </span>tok = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tok([<span class="hljs-string">&quot;An increasing sequence: one,&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>streamer = TextStreamer(tok)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Despite returning the usual output, the streamer will also print the generated text to stdout.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>_ = model.generate(**inputs, streamer=streamer, max_new_tokens=<span class="hljs-number">20</span>)
An increasing sequence: one, two, three, four, five, six, seven, eight, nine, ten, eleven,`,wrap:!1}}),te=new M({props:{title:"KV Cache Quantization",local:"kv-cache-quantization",headingTag:"h2"}}),U=new Ns({props:{warning:!0,$$slots:{default:[Oa]},$$scope:{ctx:j}}}),le=new b({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIybWV0YS1sbGFtYSUyRkxsYW1hLTItN2ItY2hhdC1oZiUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJtZXRhLWxsYW1hJTJGTGxhbWEtMi03Yi1jaGF0LWhmJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2KS50byglMjJjdWRhJTNBMCUyMiklMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTIySSUyMGxpa2UlMjByb2NrJTIwbXVzaWMlMjBiZWNhdXNlJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMikudG8obW9kZWwuZGV2aWNlKSUwQSUwQW91dCUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwZG9fc2FtcGxlJTNERmFsc2UlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDIwJTJDJTIwY2FjaGVfaW1wbGVtZW50YXRpb24lM0QlMjJxdWFudGl6ZWQlMjIlMkMlMjBjYWNoZV9jb25maWclM0QlN0IlMjJuYml0cyUyMiUzQSUyMDQlMkMlMjAlMjJiYWNrZW5kJTIyJTNBJTIwJTIycXVhbnRvJTIyJTdEKSUwQXByaW50KHRva2VuaXplci5iYXRjaF9kZWNvZGUob3V0JTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RCklMEElMEFvdXQlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMGRvX3NhbXBsZSUzREZhbHNlJTJDJTIwbWF4X25ld190b2tlbnMlM0QyMCklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKG91dCUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSU1QjAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;meta-llama/Llama-2-7b-chat-hf&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;meta-llama/Llama-2-7b-chat-hf&quot;</span>, torch_dtype=torch.float16).to(<span class="hljs-string">&quot;cuda:0&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;I like rock music because&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(model.device)

<span class="hljs-meta">&gt;&gt;&gt; </span>out = model.generate(**inputs, do_sample=<span class="hljs-literal">False</span>, max_new_tokens=<span class="hljs-number">20</span>, cache_implementation=<span class="hljs-string">&quot;quantized&quot;</span>, cache_config={<span class="hljs-string">&quot;nbits&quot;</span>: <span class="hljs-number">4</span>, <span class="hljs-string">&quot;backend&quot;</span>: <span class="hljs-string">&quot;quanto&quot;</span>})
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
I like rock music because it<span class="hljs-string">&#x27;s loud and energetic. It&#x27;</span>s a great way to express myself <span class="hljs-keyword">and</span> rel

<span class="hljs-meta">&gt;&gt;&gt; </span>out = model.generate(**inputs, do_sample=<span class="hljs-literal">False</span>, max_new_tokens=<span class="hljs-number">20</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
I like rock music because it<span class="hljs-string">&#x27;s loud and energetic. I like to listen to it when I&#x27;</span>m feeling`,wrap:!1}}),oe=new M({props:{title:"Watermarking",local:"watermarking",headingTag:"h2"}}),k=new Ns({props:{warning:!0,$$slots:{default:[en]},$$scope:{ctx:j}}}),ce=new b({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUyQyUyMFdhdGVybWFya0RldGVjdG9yJTJDJTIwV2F0ZXJtYXJraW5nQ29uZmlnJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyb3BlbmFpLWNvbW11bml0eSUyRmdwdDIlMjIpJTBBdG9rJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyb3BlbmFpLWNvbW11bml0eSUyRmdwdDIlMjIpJTBBdG9rLnBhZF90b2tlbl9pZCUyMCUzRCUyMHRvay5lb3NfdG9rZW5faWQlMEF0b2sucGFkZGluZ19zaWRlJTIwJTNEJTIwJTIybGVmdCUyMiUwQSUwQWlucHV0cyUyMCUzRCUyMHRvayglNUIlMjJUaGlzJTIwaXMlMjB0aGUlMjBiZWdpbm5pbmclMjBvZiUyMGElMjBsb25nJTIwc3RvcnklMjIlMkMlMjAlMjJBbGljZSUyMGFuZCUyMEJvYiUyMGFyZSUyMiU1RCUyQyUyMHBhZGRpbmclM0RUcnVlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEFpbnB1dF9sZW4lMjAlM0QlMjBpbnB1dHMlNUIlMjJpbnB1dF9pZHMlMjIlNUQuc2hhcGUlNUItMSU1RCUwQSUwQXdhdGVybWFya2luZ19jb25maWclMjAlM0QlMjBXYXRlcm1hcmtpbmdDb25maWcoYmlhcyUzRDIuNSUyQyUyMHNlZWRpbmdfc2NoZW1lJTNEJTIyc2VsZmhhc2glMjIpJTBBb3V0JTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjB3YXRlcm1hcmtpbmdfY29uZmlnJTNEd2F0ZXJtYXJraW5nX2NvbmZpZyUyQyUyMGRvX3NhbXBsZSUzREZhbHNlJTJDJTIwbWF4X2xlbmd0aCUzRDIwKSUwQSUwQWRldGVjdG9yJTIwJTNEJTIwV2F0ZXJtYXJrRGV0ZWN0b3IobW9kZWxfY29uZmlnJTNEbW9kZWwuY29uZmlnJTJDJTIwZGV2aWNlJTNEJTIyY3B1JTIyJTJDJTIwd2F0ZXJtYXJraW5nX2NvbmZpZyUzRHdhdGVybWFya2luZ19jb25maWcpJTBBZGV0ZWN0aW9uX291dCUyMCUzRCUyMGRldGVjdG9yKG91dCUyQyUyMHJldHVybl9kaWN0JTNEVHJ1ZSklMEFkZXRlY3Rpb25fb3V0LnByZWRpY3Rpb24=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, WatermarkDetector, WatermarkingConfig

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tok = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tok.pad_token_id = tok.eos_token_id
<span class="hljs-meta">&gt;&gt;&gt; </span>tok.padding_side = <span class="hljs-string">&quot;left&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tok([<span class="hljs-string">&quot;This is the beginning of a long story&quot;</span>, <span class="hljs-string">&quot;Alice and Bob are&quot;</span>], padding=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>input_len = inputs[<span class="hljs-string">&quot;input_ids&quot;</span>].shape[-<span class="hljs-number">1</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>watermarking_config = WatermarkingConfig(bias=<span class="hljs-number">2.5</span>, seeding_scheme=<span class="hljs-string">&quot;selfhash&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>out = model.generate(**inputs, watermarking_config=watermarking_config, do_sample=<span class="hljs-literal">False</span>, max_length=<span class="hljs-number">20</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>detector = WatermarkDetector(model_config=model.config, device=<span class="hljs-string">&quot;cpu&quot;</span>, watermarking_config=watermarking_config)
<span class="hljs-meta">&gt;&gt;&gt; </span>detection_out = detector(out, return_dict=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>detection_out.prediction
array([<span class="hljs-literal">True</span>, <span class="hljs-literal">True</span>])`,wrap:!1}}),de=new M({props:{title:"Decoding strategies",local:"decoding-strategies",headingTag:"h2"}}),ue=new M({props:{title:"Greedy Search",local:"greedy-search",headingTag:"h3"}}),ye=new b({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQSUwQXByb21wdCUyMCUzRCUyMCUyMkklMjBsb29rJTIwZm9yd2FyZCUyMHRvJTIyJTBBY2hlY2twb2ludCUyMCUzRCUyMCUyMmRpc3RpbGJlcnQlMkZkaXN0aWxncHQyJTIyJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoY2hlY2twb2ludCklMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIocHJvbXB0JTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZChjaGVja3BvaW50KSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyklMEF0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKG91dHB1dHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;I look forward to&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>checkpoint = <span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(checkpoint)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(checkpoint)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)
[<span class="hljs-string">&#x27;I look forward to seeing you all again!\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n&#x27;</span>]`,wrap:!1}}),Me=new M({props:{title:"Contrastive search",local:"contrastive-search",headingTag:"h3"}}),fe=new b({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQSUwQWNoZWNrcG9pbnQlMjAlM0QlMjAlMjJvcGVuYWktY29tbXVuaXR5JTJGZ3B0Mi1sYXJnZSUyMiUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKGNoZWNrcG9pbnQpJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoY2hlY2twb2ludCklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJIdWdnaW5nJTIwRmFjZSUyMENvbXBhbnklMjBpcyUyMiUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplcihwcm9tcHQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMHBlbmFsdHlfYWxwaGElM0QwLjYlMkMlMjB0b3BfayUzRDQlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDEwMCklMEF0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKG91dHB1dHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>checkpoint = <span class="hljs-string">&quot;openai-community/gpt2-large&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(checkpoint)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(checkpoint)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;Hugging Face Company is&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, penalty_alpha=<span class="hljs-number">0.6</span>, top_k=<span class="hljs-number">4</span>, max_new_tokens=<span class="hljs-number">100</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)
[<span class="hljs-string">&#x27;Hugging Face Company is a family owned and operated business. We pride ourselves on being the best
in the business and our customer service is second to none.\\n\\nIf you have any questions about our
products or services, feel free to contact us at any time. We look forward to hearing from you!&#x27;</span>]`,wrap:!1}}),Te=new M({props:{title:"Multinomial sampling",local:"multinomial-sampling",headingTag:"h3"}}),Je=new b({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUyQyUyMHNldF9zZWVkJTBBc2V0X3NlZWQoMCklMjAlMjAlMjMlMjBGb3IlMjByZXByb2R1Y2liaWxpdHklMEElMEFjaGVja3BvaW50JTIwJTNEJTIwJTIyb3BlbmFpLWNvbW11bml0eSUyRmdwdDItbGFyZ2UlMjIlMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZChjaGVja3BvaW50KSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKGNoZWNrcG9pbnQpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyVG9kYXklMjB3YXMlMjBhbiUyMGFtYXppbmclMjBkYXklMjBiZWNhdXNlJTIyJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKHByb21wdCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwZG9fc2FtcGxlJTNEVHJ1ZSUyQyUyMG51bV9iZWFtcyUzRDElMkMlMjBtYXhfbmV3X3Rva2VucyUzRDEwMCklMEF0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKG91dHB1dHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, set_seed
<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">0</span>)  <span class="hljs-comment"># For reproducibility</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>checkpoint = <span class="hljs-string">&quot;openai-community/gpt2-large&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(checkpoint)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(checkpoint)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;Today was an amazing day because&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>, num_beams=<span class="hljs-number">1</span>, max_new_tokens=<span class="hljs-number">100</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)
[<span class="hljs-string">&quot;Today was an amazing day because we received these wonderful items by the way of a gift shop. The box arrived on a Thursday and I opened it on Monday afternoon to receive the gifts. Both bags featured pieces from all the previous years!\\n\\nThe box had lots of surprises in it, including some sweet little mini chocolate chips! I don&#x27;t think I&#x27;d eat all of these. This was definitely one of the most expensive presents I have ever got, I actually got most of them for free!\\n\\nThe first package came&quot;</span>]`,wrap:!1}}),Ue=new M({props:{title:"Beam-search decoding",local:"beam-search-decoding",headingTag:"h3"}}),We=new b({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQSUwQXByb21wdCUyMCUzRCUyMCUyMkl0JTIwaXMlMjBhc3RvbmlzaGluZyUyMGhvdyUyMG9uZSUyMGNhbiUyMiUwQWNoZWNrcG9pbnQlMjAlM0QlMjAlMjJvcGVuYWktY29tbXVuaXR5JTJGZ3B0Mi1tZWRpdW0lMjIlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZChjaGVja3BvaW50KSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplcihwcm9tcHQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKGNoZWNrcG9pbnQpJTBBJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwbnVtX2JlYW1zJTNENSUyQyUyMG1heF9uZXdfdG9rZW5zJTNENTApJTBBdG9rZW5pemVyLmJhdGNoX2RlY29kZShvdXRwdXRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;It is astonishing how one can&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>checkpoint = <span class="hljs-string">&quot;openai-community/gpt2-medium&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(checkpoint)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(checkpoint)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, num_beams=<span class="hljs-number">5</span>, max_new_tokens=<span class="hljs-number">50</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)
[<span class="hljs-string">&#x27;It is astonishing how one can have such a profound impact on the lives of so many people in such a short period of
time.&quot;\\n\\nHe added: &quot;I am very proud of the work I have been able to do in the last few years.\\n\\n&quot;I have&#x27;</span>]`,wrap:!1}}),Ge=new M({props:{title:"Beam-search multinomial sampling",local:"beam-search-multinomial-sampling",headingTag:"h3"}}),Ve=new b({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JTZXEyU2VxTE0lMkMlMjBzZXRfc2VlZCUwQXNldF9zZWVkKDApJTIwJTIwJTIzJTIwRm9yJTIwcmVwcm9kdWNpYmlsaXR5JTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIydHJhbnNsYXRlJTIwRW5nbGlzaCUyMHRvJTIwR2VybWFuJTNBJTIwVGhlJTIwaG91c2UlMjBpcyUyMHdvbmRlcmZ1bC4lMjIlMEFjaGVja3BvaW50JTIwJTNEJTIwJTIyZ29vZ2xlLXQ1JTJGdDUtc21hbGwlMjIlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZChjaGVja3BvaW50KSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplcihwcm9tcHQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yU2VxMlNlcUxNLmZyb21fcHJldHJhaW5lZChjaGVja3BvaW50KSUwQSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMG51bV9iZWFtcyUzRDUlMkMlMjBkb19zYW1wbGUlM0RUcnVlKSUwQXRva2VuaXplci5kZWNvZGUob3V0cHV0cyU1QjAlNUQlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForSeq2SeqLM, set_seed
<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">0</span>)  <span class="hljs-comment"># For reproducibility</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;translate English to German: The house is wonderful.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>checkpoint = <span class="hljs-string">&quot;google-t5/t5-small&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(checkpoint)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSeq2SeqLM.from_pretrained(checkpoint)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, num_beams=<span class="hljs-number">5</span>, do_sample=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.decode(outputs[<span class="hljs-number">0</span>], skip_special_tokens=<span class="hljs-literal">True</span>)
<span class="hljs-string">&#x27;Das Haus ist wunderbar.&#x27;</span>`,wrap:!1}}),Ce=new M({props:{title:"Diverse beam search decoding",local:"diverse-beam-search-decoding",headingTag:"h3"}}),_e=new b({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForSeq2SeqLM

<span class="hljs-meta">&gt;&gt;&gt; </span>checkpoint = <span class="hljs-string">&quot;google/pegasus-xsum&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = (
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;The Permaculture Design Principles are a set of universal design principles &quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;that can be applied to any location, climate and culture, and they allow us to design &quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;the most efficient and sustainable human habitation and food production systems. &quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Permaculture is a design system that encompasses a wide variety of disciplines, such &quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;as ecology, landscape design, environmental science and energy conservation, and the &quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Permaculture design principles are drawn from these various disciplines. Each individual &quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;design principle itself embodies a complete conceptual framework based on sound &quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;scientific principles. When we bring all these separate  principles together, we can &quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;create a design system that both looks at whole systems, the parts that these systems &quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;consist of, and how those parts interact with each other to create a complex, dynamic, &quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;living system. Each design principle serves as a tool that allows us to integrate all &quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;the separate parts of a design, referred to as elements, into a functional, synergistic, &quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;whole system, where the elements harmoniously interact and work together in the most &quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;efficient way possible.&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(checkpoint)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSeq2SeqLM.from_pretrained(checkpoint)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, num_beams=<span class="hljs-number">5</span>, num_beam_groups=<span class="hljs-number">5</span>, max_new_tokens=<span class="hljs-number">30</span>, diversity_penalty=<span class="hljs-number">1.0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.decode(outputs[<span class="hljs-number">0</span>], skip_special_tokens=<span class="hljs-literal">True</span>)
<span class="hljs-string">&#x27;The Design Principles are a set of universal design principles that can be applied to any location, climate and
culture, and they allow us to design the&#x27;</span>`,wrap:!1}}),Ie=new M({props:{title:"Speculative Decoding",local:"speculative-decoding",headingTag:"h3"}}),ze=new b({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQSUwQXByb21wdCUyMCUzRCUyMCUyMkFsaWNlJTIwYW5kJTIwQm9iJTIyJTBBY2hlY2twb2ludCUyMCUzRCUyMCUyMkVsZXV0aGVyQUklMkZweXRoaWEtMS40Yi1kZWR1cGVkJTIyJTBBYXNzaXN0YW50X2NoZWNrcG9pbnQlMjAlM0QlMjAlMjJFbGV1dGhlckFJJTJGcHl0aGlhLTE2MG0tZGVkdXBlZCUyMiUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKGNoZWNrcG9pbnQpJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKHByb21wdCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoY2hlY2twb2ludCklMEFhc3Npc3RhbnRfbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoYXNzaXN0YW50X2NoZWNrcG9pbnQpJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwYXNzaXN0YW50X21vZGVsJTNEYXNzaXN0YW50X21vZGVsKSUwQXRva2VuaXplci5iYXRjaF9kZWNvZGUob3V0cHV0cyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;Alice and Bob&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>checkpoint = <span class="hljs-string">&quot;EleutherAI/pythia-1.4b-deduped&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>assistant_checkpoint = <span class="hljs-string">&quot;EleutherAI/pythia-160m-deduped&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(checkpoint)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(checkpoint)
<span class="hljs-meta">&gt;&gt;&gt; </span>assistant_model = AutoModelForCausalLM.from_pretrained(assistant_checkpoint)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, assistant_model=assistant_model)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)
[<span class="hljs-string">&#x27;Alice and Bob are sitting in a bar. Alice is drinking a beer and Bob is drinking a&#x27;</span>]`,wrap:!1}}),Fe=new b({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUyQyUyMHNldF9zZWVkJTBBc2V0X3NlZWQoNDIpJTIwJTIwJTIzJTIwRm9yJTIwcmVwcm9kdWNpYmlsaXR5JTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyQWxpY2UlMjBhbmQlMjBCb2IlMjIlMEFjaGVja3BvaW50JTIwJTNEJTIwJTIyRWxldXRoZXJBSSUyRnB5dGhpYS0xLjRiLWRlZHVwZWQlMjIlMEFhc3Npc3RhbnRfY2hlY2twb2ludCUyMCUzRCUyMCUyMkVsZXV0aGVyQUklMkZweXRoaWEtMTYwbS1kZWR1cGVkJTIyJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoY2hlY2twb2ludCklMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIocHJvbXB0JTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZChjaGVja3BvaW50KSUwQWFzc2lzdGFudF9tb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZChhc3Npc3RhbnRfY2hlY2twb2ludCklMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBhc3Npc3RhbnRfbW9kZWwlM0Rhc3Npc3RhbnRfbW9kZWwlMkMlMjBkb19zYW1wbGUlM0RUcnVlJTJDJTIwdGVtcGVyYXR1cmUlM0QwLjUpJTBBdG9rZW5pemVyLmJhdGNoX2RlY29kZShvdXRwdXRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer, set_seed
<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">42</span>)  <span class="hljs-comment"># For reproducibility</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;Alice and Bob&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>checkpoint = <span class="hljs-string">&quot;EleutherAI/pythia-1.4b-deduped&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>assistant_checkpoint = <span class="hljs-string">&quot;EleutherAI/pythia-160m-deduped&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(checkpoint)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(checkpoint)
<span class="hljs-meta">&gt;&gt;&gt; </span>assistant_model = AutoModelForCausalLM.from_pretrained(assistant_checkpoint)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, assistant_model=assistant_model, do_sample=<span class="hljs-literal">True</span>, temperature=<span class="hljs-number">0.5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)
[<span class="hljs-string">&#x27;Alice and Bob, a couple of friends of mine, who are both in the same office as&#x27;</span>]`,wrap:!1}}),Ye=new M({props:{title:"DoLa Decoding",local:"dola-decoding",headingTag:"h3"}}),De=new b({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUyQyUyMHNldF9zZWVkJTBBaW1wb3J0JTIwdG9yY2glMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJodWdneWxsYW1hJTJGbGxhbWEtN2IlMjIpJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyaHVnZ3lsbGFtYSUyRmxsYW1hLTdiJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2KSUwQWRldmljZSUyMCUzRCUyMCdjdWRhJyUyMGlmJTIwdG9yY2guY3VkYS5pc19hdmFpbGFibGUoKSUyMGVsc2UlMjAnY3B1JyUwQW1vZGVsLnRvKGRldmljZSklMEFzZXRfc2VlZCg0MiklMEElMEF0ZXh0JTIwJTNEJTIwJTIyT24lMjB3aGF0JTIwZGF0ZSUyMHdhcyUyMHRoZSUyMERlY2xhcmF0aW9uJTIwb2YlMjBJbmRlcGVuZGVuY2UlMjBvZmZpY2lhbGx5JTIwc2lnbmVkJTNGJTIyJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKHRleHQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKS50byhkZXZpY2UpJTBBJTBBdmFuaWxsYV9vdXRwdXQlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMGRvX3NhbXBsZSUzREZhbHNlJTJDJTIwbWF4X25ld190b2tlbnMlM0Q1MCklMEF0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKHZhbmlsbGFfb3V0cHV0JTVCJTNBJTJDJTIwaW5wdXRzLmlucHV0X2lkcy5zaGFwZSU1Qi0xJTVEJTNBJTVEJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTBBJTBBZG9sYV9oaWdoX291dHB1dCUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwZG9fc2FtcGxlJTNERmFsc2UlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDUwJTJDJTIwZG9sYV9sYXllcnMlM0QnaGlnaCcpJTBBdG9rZW5pemVyLmJhdGNoX2RlY29kZShkb2xhX2hpZ2hfb3V0cHV0JTVCJTNBJTJDJTIwaW5wdXRzLmlucHV0X2lkcy5zaGFwZSU1Qi0xJTVEJTNBJTVEJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTBBJTBBZG9sYV9jdXN0b21fb3V0cHV0JTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBkb19zYW1wbGUlM0RGYWxzZSUyQyUyMG1heF9uZXdfdG9rZW5zJTNENTAlMkMlMjBkb2xhX2xheWVycyUzRCU1QjI4JTJDMzAlNUQlMkMlMjByZXBldGl0aW9uX3BlbmFsdHklM0QxLjIpJTBBdG9rZW5pemVyLmJhdGNoX2RlY29kZShkb2xhX2N1c3RvbV9vdXRwdXQlNUIlM0ElMkMlMjBpbnB1dHMuaW5wdXRfaWRzLnNoYXBlJTVCLTElNUQlM0ElNUQlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, set_seed
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;huggyllama/llama-7b&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;huggyllama/llama-7b&quot;</span>, torch_dtype=torch.float16)
<span class="hljs-meta">&gt;&gt;&gt; </span>device = <span class="hljs-string">&#x27;cuda&#x27;</span> <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&#x27;cpu&#x27;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model.to(device)
<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">42</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>text = <span class="hljs-string">&quot;On what date was the Declaration of Independence officially signed?&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(device)

<span class="hljs-comment"># Vanilla greddy decoding</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>vanilla_output = model.generate(**inputs, do_sample=<span class="hljs-literal">False</span>, max_new_tokens=<span class="hljs-number">50</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(vanilla_output[:, inputs.input_ids.shape[-<span class="hljs-number">1</span>]:], skip_special_tokens=<span class="hljs-literal">True</span>)
[<span class="hljs-string">&#x27;\\nThe Declaration of Independence was signed on July 4, 1776.\\nWhat was the date of the signing of the Declaration of Independence?\\nThe Declaration of Independence was signed on July 4,&#x27;</span>]

<span class="hljs-comment"># DoLa decoding with contrasting higher part of layers (layers 16,18,...,30)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>dola_high_output = model.generate(**inputs, do_sample=<span class="hljs-literal">False</span>, max_new_tokens=<span class="hljs-number">50</span>, dola_layers=<span class="hljs-string">&#x27;high&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(dola_high_output[:, inputs.input_ids.shape[-<span class="hljs-number">1</span>]:], skip_special_tokens=<span class="hljs-literal">True</span>)
[<span class="hljs-string">&#x27;\\nJuly 4, 1776, when the Continental Congress voted to separate from Great Britain. The 56 delegates to the Continental Congress signed the Declaration on August 2, 1776.&#x27;</span>]

<span class="hljs-comment"># DoLa decoding with contrasting specific layers (layers 28 and 30)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>dola_custom_output = model.generate(**inputs, do_sample=<span class="hljs-literal">False</span>, max_new_tokens=<span class="hljs-number">50</span>, dola_layers=[<span class="hljs-number">28</span>,<span class="hljs-number">30</span>], repetition_penalty=<span class="hljs-number">1.2</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(dola_custom_output[:, inputs.input_ids.shape[-<span class="hljs-number">1</span>]:], skip_special_tokens=<span class="hljs-literal">True</span>)
[<span class="hljs-string">&#x27;\\nIt was officially signed on 2 August 1776, when 56 members of the Second Continental Congress, representing the original 13 American colonies, voted unanimously for the resolution for independence. The 2&#x27;</span>]`,wrap:!1}}),Ke=new M({props:{title:"Understanding the dola_layers argument",local:"understanding-the-dolalayers-argument",headingTag:"h4"}}),st=new Ka({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/generation_strategies.md"}}),{c(){g=o("meta"),f=n(),y=o("p"),T=n(),p(Z.$$.fragment),nt=n(),v=o("p"),v.textContent=Qs,lt=n(),W=o("p"),W.innerHTML=Ys,ot=n(),G=o("ul"),G.innerHTML=Es,it=n(),B=o("p"),B.textContent=qs,rt=n(),V=o("p"),V.innerHTML=Ss,pt=n(),C=o("p"),C.textContent=Ls,ct=n(),X=o("ul"),X.innerHTML=As,dt=n(),p(_.$$.fragment),mt=n(),R=o("p"),R.innerHTML=Ds,ht=n(),I=o("p"),I.innerHTML=Ks,ut=n(),p(H.$$.fragment),gt=n(),x=o("p"),x.innerHTML=Ps,yt=n(),$=o("p"),$.textContent=Os,Mt=n(),p(z.$$.fragment),bt=n(),N=o("p"),N.innerHTML=ea,ft=n(),p(F.$$.fragment),Tt=n(),Q=o("p"),Q.textContent=ta,wt=n(),Y=o("ul"),Y.innerHTML=sa,jt=n(),p(E.$$.fragment),Jt=n(),q=o("p"),q.textContent=aa,Ut=n(),S=o("ul"),S.innerHTML=na,kt=n(),p(L.$$.fragment),Zt=n(),A=o("p"),A.innerHTML=la,vt=n(),p(D.$$.fragment),Wt=n(),p(K.$$.fragment),Gt=n(),P=o("p"),P.innerHTML=oa,Bt=n(),p(J.$$.fragment),Vt=n(),O=o("p"),O.innerHTML=ia,Ct=n(),p(ee.$$.fragment),Xt=n(),p(te.$$.fragment),_t=n(),se=o("p"),se.innerHTML=ra,Rt=n(),ae=o("p"),ae.innerHTML=pa,It=n(),ne=o("p"),ne.innerHTML=ca,Ht=n(),p(U.$$.fragment),xt=n(),p(le.$$.fragment),$t=n(),p(oe.$$.fragment),zt=n(),ie=o("p"),ie.innerHTML=da,Nt=n(),re=o("p"),re.innerHTML=ma,Ft=n(),p(k.$$.fragment),Qt=n(),pe=o("p"),pe.innerHTML=ha,Yt=n(),p(ce.$$.fragment),Et=n(),p(de.$$.fragment),qt=n(),me=o("p"),me.innerHTML=ua,St=n(),he=o("p"),he.textContent=ga,Lt=n(),p(ue.$$.fragment),At=n(),ge=o("p"),ge.innerHTML=ya,Dt=n(),p(ye.$$.fragment),Kt=n(),p(Me.$$.fragment),Pt=n(),be=o("p"),be.innerHTML=Ma,Ot=n(),p(fe.$$.fragment),es=n(),p(Te.$$.fragment),ts=n(),we=o("p"),we.textContent=ba,ss=n(),je=o("p"),je.innerHTML=fa,as=n(),p(Je.$$.fragment),ns=n(),p(Ue.$$.fragment),ls=n(),ke=o("p"),ke.textContent=Ta,os=n(),w=o("a"),w.innerHTML=wa,is=n(),Ze=o("p"),Ze.innerHTML=ja,rs=n(),ve=o("p"),ve.innerHTML=Ja,ps=n(),p(We.$$.fragment),cs=n(),p(Ge.$$.fragment),ds=n(),Be=o("p"),Be.innerHTML=Ua,ms=n(),p(Ve.$$.fragment),hs=n(),p(Ce.$$.fragment),us=n(),Xe=o("p"),Xe.innerHTML=ka,gs=n(),p(_e.$$.fragment),ys=n(),Re=o("p"),Re.innerHTML=Za,Ms=n(),p(Ie.$$.fragment),bs=n(),He=o("p"),He.innerHTML=va,fs=n(),xe=o("p"),xe.innerHTML=Wa,Ts=n(),$e=o("p"),$e.innerHTML=Ga,ws=n(),p(ze.$$.fragment),js=n(),Ne=o("p"),Ne.innerHTML=Ba,Js=n(),p(Fe.$$.fragment),Us=n(),Qe=o("p"),Qe.innerHTML=Va,ks=n(),p(Ye.$$.fragment),Zs=n(),Ee=o("p"),Ee.innerHTML=Ca,vs=n(),qe=o("p"),qe.textContent=Xa,Ws=n(),Se=o("p"),Se.innerHTML=_a,Gs=n(),Le=o("ol"),Le.innerHTML=Ra,Bs=n(),Ae=o("p"),Ae.textContent=Ia,Vs=n(),p(De.$$.fragment),Cs=n(),p(Ke.$$.fragment),Xs=n(),Pe=o("p"),Pe.innerHTML=Ha,_s=n(),Oe=o("p"),Oe.innerHTML=xa,Rs=n(),et=o("ul"),et.innerHTML=$a,Is=n(),tt=o("p"),tt.innerHTML=za,Hs=n(),p(st.$$.fragment),xs=n(),at=o("p"),this.h()},l(e){const t=Aa("svelte-u9bgzb",document.head);g=i(t,"META",{name:!0,content:!0}),t.forEach(s),f=l(e),y=i(e,"P",{}),Ya(y).forEach(s),T=l(e),c(Z.$$.fragment,e),nt=l(e),v=i(e,"P",{"data-svelte-h":!0}),r(v)!=="svelte-1pq6r4w"&&(v.textContent=Qs),lt=l(e),W=i(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-1dqk32t"&&(W.innerHTML=Ys),ot=l(e),G=i(e,"UL",{"data-svelte-h":!0}),r(G)!=="svelte-18jzu0"&&(G.innerHTML=Es),it=l(e),B=i(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-5iqkcx"&&(B.textContent=qs),rt=l(e),V=i(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-agd87v"&&(V.innerHTML=Ss),pt=l(e),C=i(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-1gun7m8"&&(C.textContent=Ls),ct=l(e),X=i(e,"UL",{"data-svelte-h":!0}),r(X)!=="svelte-l1azua"&&(X.innerHTML=As),dt=l(e),c(_.$$.fragment,e),mt=l(e),R=i(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-eehu19"&&(R.innerHTML=Ds),ht=l(e),I=i(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-2o7gdz"&&(I.innerHTML=Ks),ut=l(e),c(H.$$.fragment,e),gt=l(e),x=i(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-18srzjs"&&(x.innerHTML=Ps),yt=l(e),$=i(e,"P",{"data-svelte-h":!0}),r($)!=="svelte-32rftl"&&($.textContent=Os),Mt=l(e),c(z.$$.fragment,e),bt=l(e),N=i(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-qprijs"&&(N.innerHTML=ea),ft=l(e),c(F.$$.fragment,e),Tt=l(e),Q=i(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-t9z639"&&(Q.textContent=ta),wt=l(e),Y=i(e,"UL",{"data-svelte-h":!0}),r(Y)!=="svelte-17ejddt"&&(Y.innerHTML=sa),jt=l(e),c(E.$$.fragment,e),Jt=l(e),q=i(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-1l1ri2h"&&(q.textContent=aa),Ut=l(e),S=i(e,"UL",{"data-svelte-h":!0}),r(S)!=="svelte-hk9wim"&&(S.innerHTML=na),kt=l(e),c(L.$$.fragment,e),Zt=l(e),A=i(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-1fsi3zv"&&(A.innerHTML=la),vt=l(e),c(D.$$.fragment,e),Wt=l(e),c(K.$$.fragment,e),Gt=l(e),P=i(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-12rh7l9"&&(P.innerHTML=oa),Bt=l(e),c(J.$$.fragment,e),Vt=l(e),O=i(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-1luhkpq"&&(O.innerHTML=ia),Ct=l(e),c(ee.$$.fragment,e),Xt=l(e),c(te.$$.fragment,e),_t=l(e),se=i(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-tuq1k1"&&(se.innerHTML=ra),Rt=l(e),ae=i(e,"P",{"data-svelte-h":!0}),r(ae)!=="svelte-7yu0k1"&&(ae.innerHTML=pa),It=l(e),ne=i(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-124trm2"&&(ne.innerHTML=ca),Ht=l(e),c(U.$$.fragment,e),xt=l(e),c(le.$$.fragment,e),$t=l(e),c(oe.$$.fragment,e),zt=l(e),ie=i(e,"P",{"data-svelte-h":!0}),r(ie)!=="svelte-10ws557"&&(ie.innerHTML=da),Nt=l(e),re=i(e,"P",{"data-svelte-h":!0}),r(re)!=="svelte-8j6fzm"&&(re.innerHTML=ma),Ft=l(e),c(k.$$.fragment,e),Qt=l(e),pe=i(e,"P",{"data-svelte-h":!0}),r(pe)!=="svelte-ba6d9u"&&(pe.innerHTML=ha),Yt=l(e),c(ce.$$.fragment,e),Et=l(e),c(de.$$.fragment,e),qt=l(e),me=i(e,"P",{"data-svelte-h":!0}),r(me)!=="svelte-ip87dk"&&(me.innerHTML=ua),St=l(e),he=i(e,"P",{"data-svelte-h":!0}),r(he)!=="svelte-nugt5b"&&(he.textContent=ga),Lt=l(e),c(ue.$$.fragment,e),At=l(e),ge=i(e,"P",{"data-svelte-h":!0}),r(ge)!=="svelte-1m7rj88"&&(ge.innerHTML=ya),Dt=l(e),c(ye.$$.fragment,e),Kt=l(e),c(Me.$$.fragment,e),Pt=l(e),be=i(e,"P",{"data-svelte-h":!0}),r(be)!=="svelte-m0y9j6"&&(be.innerHTML=Ma),Ot=l(e),c(fe.$$.fragment,e),es=l(e),c(Te.$$.fragment,e),ts=l(e),we=i(e,"P",{"data-svelte-h":!0}),r(we)!=="svelte-vsvvis"&&(we.textContent=ba),ss=l(e),je=i(e,"P",{"data-svelte-h":!0}),r(je)!=="svelte-ldtxsn"&&(je.innerHTML=fa),as=l(e),c(Je.$$.fragment,e),ns=l(e),c(Ue.$$.fragment,e),ls=l(e),ke=i(e,"P",{"data-svelte-h":!0}),r(ke)!=="svelte-149ek3p"&&(ke.textContent=Ta),os=l(e),w=i(e,"A",{href:!0,class:!0,"data-svelte-h":!0}),r(w)!=="svelte-1ck2qcm"&&(w.innerHTML=wa),is=l(e),Ze=i(e,"P",{"data-svelte-h":!0}),r(Ze)!=="svelte-1ymxnsd"&&(Ze.innerHTML=ja),rs=l(e),ve=i(e,"P",{"data-svelte-h":!0}),r(ve)!=="svelte-krswod"&&(ve.innerHTML=Ja),ps=l(e),c(We.$$.fragment,e),cs=l(e),c(Ge.$$.fragment,e),ds=l(e),Be=i(e,"P",{"data-svelte-h":!0}),r(Be)!=="svelte-zgjlvh"&&(Be.innerHTML=Ua),ms=l(e),c(Ve.$$.fragment,e),hs=l(e),c(Ce.$$.fragment,e),us=l(e),Xe=i(e,"P",{"data-svelte-h":!0}),r(Xe)!=="svelte-zdhf65"&&(Xe.innerHTML=ka),gs=l(e),c(_e.$$.fragment,e),ys=l(e),Re=i(e,"P",{"data-svelte-h":!0}),r(Re)!=="svelte-1e7mt8t"&&(Re.innerHTML=Za),Ms=l(e),c(Ie.$$.fragment,e),bs=l(e),He=i(e,"P",{"data-svelte-h":!0}),r(He)!=="svelte-13d2q9j"&&(He.innerHTML=va),fs=l(e),xe=i(e,"P",{"data-svelte-h":!0}),r(xe)!=="svelte-xy91hv"&&(xe.innerHTML=Wa),Ts=l(e),$e=i(e,"P",{"data-svelte-h":!0}),r($e)!=="svelte-ebd3ly"&&($e.innerHTML=Ga),ws=l(e),c(ze.$$.fragment,e),js=l(e),Ne=i(e,"P",{"data-svelte-h":!0}),r(Ne)!=="svelte-nm0fxt"&&(Ne.innerHTML=Ba),Js=l(e),c(Fe.$$.fragment,e),Us=l(e),Qe=i(e,"P",{"data-svelte-h":!0}),r(Qe)!=="svelte-lf7edt"&&(Qe.innerHTML=Va),ks=l(e),c(Ye.$$.fragment,e),Zs=l(e),Ee=i(e,"P",{"data-svelte-h":!0}),r(Ee)!=="svelte-c1qhny"&&(Ee.innerHTML=Ca),vs=l(e),qe=i(e,"P",{"data-svelte-h":!0}),r(qe)!=="svelte-1fok5rt"&&(qe.textContent=Xa),Ws=l(e),Se=i(e,"P",{"data-svelte-h":!0}),r(Se)!=="svelte-1xb5ka9"&&(Se.innerHTML=_a),Gs=l(e),Le=i(e,"OL",{"data-svelte-h":!0}),r(Le)!=="svelte-1rdm431"&&(Le.innerHTML=Ra),Bs=l(e),Ae=i(e,"P",{"data-svelte-h":!0}),r(Ae)!=="svelte-17tp6io"&&(Ae.textContent=Ia),Vs=l(e),c(De.$$.fragment,e),Cs=l(e),c(Ke.$$.fragment,e),Xs=l(e),Pe=i(e,"P",{"data-svelte-h":!0}),r(Pe)!=="svelte-qgkuwa"&&(Pe.innerHTML=Ha),_s=l(e),Oe=i(e,"P",{"data-svelte-h":!0}),r(Oe)!=="svelte-13a3h6h"&&(Oe.innerHTML=xa),Rs=l(e),et=i(e,"UL",{"data-svelte-h":!0}),r(et)!=="svelte-bhw0w6"&&(et.innerHTML=$a),Is=l(e),tt=i(e,"P",{"data-svelte-h":!0}),r(tt)!=="svelte-1v5aa4g"&&(tt.innerHTML=za),Hs=l(e),c(st.$$.fragment,e),xs=l(e),at=i(e,"P",{}),Ya(at).forEach(s),this.h()},h(){zs(g,"name","hf:doc:metadata"),zs(g,"content",sn),zs(w,"href","https://huggingface.co/spaces/m-ric/beam_search_visualizer"),zs(w,"class","flex flex-col justify-center")},m(e,t){Da(document.head,g),a(e,f,t),a(e,y,t),a(e,T,t),d(Z,e,t),a(e,nt,t),a(e,v,t),a(e,lt,t),a(e,W,t),a(e,ot,t),a(e,G,t),a(e,it,t),a(e,B,t),a(e,rt,t),a(e,V,t),a(e,pt,t),a(e,C,t),a(e,ct,t),a(e,X,t),a(e,dt,t),d(_,e,t),a(e,mt,t),a(e,R,t),a(e,ht,t),a(e,I,t),a(e,ut,t),d(H,e,t),a(e,gt,t),a(e,x,t),a(e,yt,t),a(e,$,t),a(e,Mt,t),d(z,e,t),a(e,bt,t),a(e,N,t),a(e,ft,t),d(F,e,t),a(e,Tt,t),a(e,Q,t),a(e,wt,t),a(e,Y,t),a(e,jt,t),d(E,e,t),a(e,Jt,t),a(e,q,t),a(e,Ut,t),a(e,S,t),a(e,kt,t),d(L,e,t),a(e,Zt,t),a(e,A,t),a(e,vt,t),d(D,e,t),a(e,Wt,t),d(K,e,t),a(e,Gt,t),a(e,P,t),a(e,Bt,t),d(J,e,t),a(e,Vt,t),a(e,O,t),a(e,Ct,t),d(ee,e,t),a(e,Xt,t),d(te,e,t),a(e,_t,t),a(e,se,t),a(e,Rt,t),a(e,ae,t),a(e,It,t),a(e,ne,t),a(e,Ht,t),d(U,e,t),a(e,xt,t),d(le,e,t),a(e,$t,t),d(oe,e,t),a(e,zt,t),a(e,ie,t),a(e,Nt,t),a(e,re,t),a(e,Ft,t),d(k,e,t),a(e,Qt,t),a(e,pe,t),a(e,Yt,t),d(ce,e,t),a(e,Et,t),d(de,e,t),a(e,qt,t),a(e,me,t),a(e,St,t),a(e,he,t),a(e,Lt,t),d(ue,e,t),a(e,At,t),a(e,ge,t),a(e,Dt,t),d(ye,e,t),a(e,Kt,t),d(Me,e,t),a(e,Pt,t),a(e,be,t),a(e,Ot,t),d(fe,e,t),a(e,es,t),d(Te,e,t),a(e,ts,t),a(e,we,t),a(e,ss,t),a(e,je,t),a(e,as,t),d(Je,e,t),a(e,ns,t),d(Ue,e,t),a(e,ls,t),a(e,ke,t),a(e,os,t),a(e,w,t),a(e,is,t),a(e,Ze,t),a(e,rs,t),a(e,ve,t),a(e,ps,t),d(We,e,t),a(e,cs,t),d(Ge,e,t),a(e,ds,t),a(e,Be,t),a(e,ms,t),d(Ve,e,t),a(e,hs,t),d(Ce,e,t),a(e,us,t),a(e,Xe,t),a(e,gs,t),d(_e,e,t),a(e,ys,t),a(e,Re,t),a(e,Ms,t),d(Ie,e,t),a(e,bs,t),a(e,He,t),a(e,fs,t),a(e,xe,t),a(e,Ts,t),a(e,$e,t),a(e,ws,t),d(ze,e,t),a(e,js,t),a(e,Ne,t),a(e,Js,t),d(Fe,e,t),a(e,Us,t),a(e,Qe,t),a(e,ks,t),d(Ye,e,t),a(e,Zs,t),a(e,Ee,t),a(e,vs,t),a(e,qe,t),a(e,Ws,t),a(e,Se,t),a(e,Gs,t),a(e,Le,t),a(e,Bs,t),a(e,Ae,t),a(e,Vs,t),d(De,e,t),a(e,Cs,t),d(Ke,e,t),a(e,Xs,t),a(e,Pe,t),a(e,_s,t),a(e,Oe,t),a(e,Rs,t),a(e,et,t),a(e,Is,t),a(e,tt,t),a(e,Hs,t),d(st,e,t),a(e,xs,t),a(e,at,t),$s=!0},p(e,[t]){const Na={};t&2&&(Na.$$scope={dirty:t,ctx:e}),J.$set(Na);const Fa={};t&2&&(Fa.$$scope={dirty:t,ctx:e}),U.$set(Fa);const Qa={};t&2&&(Qa.$$scope={dirty:t,ctx:e}),k.$set(Qa)},i(e){$s||(m(Z.$$.fragment,e),m(_.$$.fragment,e),m(H.$$.fragment,e),m(z.$$.fragment,e),m(F.$$.fragment,e),m(E.$$.fragment,e),m(L.$$.fragment,e),m(D.$$.fragment,e),m(K.$$.fragment,e),m(J.$$.fragment,e),m(ee.$$.fragment,e),m(te.$$.fragment,e),m(U.$$.fragment,e),m(le.$$.fragment,e),m(oe.$$.fragment,e),m(k.$$.fragment,e),m(ce.$$.fragment,e),m(de.$$.fragment,e),m(ue.$$.fragment,e),m(ye.$$.fragment,e),m(Me.$$.fragment,e),m(fe.$$.fragment,e),m(Te.$$.fragment,e),m(Je.$$.fragment,e),m(Ue.$$.fragment,e),m(We.$$.fragment,e),m(Ge.$$.fragment,e),m(Ve.$$.fragment,e),m(Ce.$$.fragment,e),m(_e.$$.fragment,e),m(Ie.$$.fragment,e),m(ze.$$.fragment,e),m(Fe.$$.fragment,e),m(Ye.$$.fragment,e),m(De.$$.fragment,e),m(Ke.$$.fragment,e),m(st.$$.fragment,e),$s=!0)},o(e){h(Z.$$.fragment,e),h(_.$$.fragment,e),h(H.$$.fragment,e),h(z.$$.fragment,e),h(F.$$.fragment,e),h(E.$$.fragment,e),h(L.$$.fragment,e),h(D.$$.fragment,e),h(K.$$.fragment,e),h(J.$$.fragment,e),h(ee.$$.fragment,e),h(te.$$.fragment,e),h(U.$$.fragment,e),h(le.$$.fragment,e),h(oe.$$.fragment,e),h(k.$$.fragment,e),h(ce.$$.fragment,e),h(de.$$.fragment,e),h(ue.$$.fragment,e),h(ye.$$.fragment,e),h(Me.$$.fragment,e),h(fe.$$.fragment,e),h(Te.$$.fragment,e),h(Je.$$.fragment,e),h(Ue.$$.fragment,e),h(We.$$.fragment,e),h(Ge.$$.fragment,e),h(Ve.$$.fragment,e),h(Ce.$$.fragment,e),h(_e.$$.fragment,e),h(Ie.$$.fragment,e),h(ze.$$.fragment,e),h(Fe.$$.fragment,e),h(Ye.$$.fragment,e),h(De.$$.fragment,e),h(Ke.$$.fragment,e),h(st.$$.fragment,e),$s=!1},d(e){e&&(s(f),s(y),s(T),s(nt),s(v),s(lt),s(W),s(ot),s(G),s(it),s(B),s(rt),s(V),s(pt),s(C),s(ct),s(X),s(dt),s(mt),s(R),s(ht),s(I),s(ut),s(gt),s(x),s(yt),s($),s(Mt),s(bt),s(N),s(ft),s(Tt),s(Q),s(wt),s(Y),s(jt),s(Jt),s(q),s(Ut),s(S),s(kt),s(Zt),s(A),s(vt),s(Wt),s(Gt),s(P),s(Bt),s(Vt),s(O),s(Ct),s(Xt),s(_t),s(se),s(Rt),s(ae),s(It),s(ne),s(Ht),s(xt),s($t),s(zt),s(ie),s(Nt),s(re),s(Ft),s(Qt),s(pe),s(Yt),s(Et),s(qt),s(me),s(St),s(he),s(Lt),s(At),s(ge),s(Dt),s(Kt),s(Pt),s(be),s(Ot),s(es),s(ts),s(we),s(ss),s(je),s(as),s(ns),s(ls),s(ke),s(os),s(w),s(is),s(Ze),s(rs),s(ve),s(ps),s(cs),s(ds),s(Be),s(ms),s(hs),s(us),s(Xe),s(gs),s(ys),s(Re),s(Ms),s(bs),s(He),s(fs),s(xe),s(Ts),s($e),s(ws),s(js),s(Ne),s(Js),s(Us),s(Qe),s(ks),s(Zs),s(Ee),s(vs),s(qe),s(Ws),s(Se),s(Gs),s(Le),s(Bs),s(Ae),s(Vs),s(Cs),s(Xs),s(Pe),s(_s),s(Oe),s(Rs),s(et),s(Is),s(tt),s(Hs),s(xs),s(at)),s(g),u(Z,e),u(_,e),u(H,e),u(z,e),u(F,e),u(E,e),u(L,e),u(D,e),u(K,e),u(J,e),u(ee,e),u(te,e),u(U,e),u(le,e),u(oe,e),u(k,e),u(ce,e),u(de,e),u(ue,e),u(ye,e),u(Me,e),u(fe,e),u(Te,e),u(Je,e),u(Ue,e),u(We,e),u(Ge,e),u(Ve,e),u(Ce,e),u(_e,e),u(Ie,e),u(ze,e),u(Fe,e),u(Ye,e),u(De,e),u(Ke,e),u(st,e)}}}const sn='{"title":"Text generation strategies","local":"text-generation-strategies","sections":[{"title":"Default text generation configuration","local":"default-text-generation-configuration","sections":[],"depth":2},{"title":"Customize text generation","local":"customize-text-generation","sections":[],"depth":2},{"title":"Save a custom decoding strategy with your model","local":"save-a-custom-decoding-strategy-with-your-model","sections":[],"depth":2},{"title":"Streaming","local":"streaming","sections":[],"depth":2},{"title":"KV Cache Quantization","local":"kv-cache-quantization","sections":[],"depth":2},{"title":"Watermarking","local":"watermarking","sections":[],"depth":2},{"title":"Decoding strategies","local":"decoding-strategies","sections":[{"title":"Greedy Search","local":"greedy-search","sections":[],"depth":3},{"title":"Contrastive search","local":"contrastive-search","sections":[],"depth":3},{"title":"Multinomial sampling","local":"multinomial-sampling","sections":[],"depth":3},{"title":"Beam-search decoding","local":"beam-search-decoding","sections":[],"depth":3},{"title":"Beam-search multinomial sampling","local":"beam-search-multinomial-sampling","sections":[],"depth":3},{"title":"Diverse beam search decoding","local":"diverse-beam-search-decoding","sections":[],"depth":3},{"title":"Speculative Decoding","local":"speculative-decoding","sections":[],"depth":3},{"title":"DoLa Decoding","local":"dola-decoding","sections":[{"title":"Understanding the dola_layers argument","local":"understanding-the-dolalayers-argument","sections":[],"depth":4}],"depth":3}],"depth":2}],"depth":1}';function an(j){return qa(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class cn extends Sa{constructor(g){super(),La(this,g,an,tn,Ea,{})}}export{cn as component};
