import{s as Na,o as Ea,n as Eo}from"../chunks/scheduler.25b97de1.js";import{S as Sa,i as Ya,g as r,s as n,r as m,A as Xa,h as l,f as a,c as s,j as Z,u as p,x as _,k as L,y as c,a as t,v as h,d as g,t as f,w as u}from"../chunks/index.d9030fc9.js";import{T as Ra}from"../chunks/Tip.baa67368.js";import{D as G}from"../chunks/Docstring.ffac8efa.js";import{C as A}from"../chunks/CodeBlock.e6cd0d95.js";import{E as Fa}from"../chunks/ExampleCodeBlock.22dfe688.js";import{H as I,E as Aa}from"../chunks/EditOnGithub.91d95064.js";function Qa(B){let d,T='bitsandbytes is being refactored to support multiple backends beyond CUDA. Currently, ROCm (AMD GPU) and Intel CPU implementations are mature, with Intel XPU in progress and Apple Silicon support expected by Q4/Q1. For installation instructions and the latest backend updates, visit <a href="https://huggingface.co/docs/bitsandbytes/main/en/installation#multi-backend" rel="nofollow">this link</a>.',y,M,v='We value your feedback to help identify bugs before the full release! Check out <a href="https://huggingface.co/docs/bitsandbytes/main/en/non_cuda_backends" rel="nofollow">these docs</a> for more details and feedback links.';return{c(){d=r("p"),d.innerHTML=T,y=n(),M=r("p"),M.innerHTML=v},l(i){d=l(i,"P",{"data-svelte-h":!0}),_(d)!=="svelte-nz63kd"&&(d.innerHTML=T),y=s(i),M=l(i,"P",{"data-svelte-h":!0}),_(M)!=="svelte-aze40l"&&(M.innerHTML=v)},m(i,b){t(i,d,b),t(i,y,b),t(i,M,b)},p:Eo,d(i){i&&(a(d),a(y),a(M))}}}function Pa(B){let d,T="Example:",y,M,v;return M=new A({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFZpZGVvTGxhdmFGb3JDb25kaXRpb25hbEdlbmVyYXRpb24lMkMlMjBWaWRlb0xsYXZhQ29uZmlnJTJDJTIwQ0xJUFZpc2lvbkNvbmZpZyUyQyUyMExsYW1hQ29uZmlnJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyMENMSVAtdmlzaW9uJTIwY29uZmlnJTBBdmlzaW9uX2NvbmZpZyUyMCUzRCUyMENMSVBWaXNpb25Db25maWcoKSUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBMbGFtYSUyMGNvbmZpZyUwQXRleHRfY29uZmlnJTIwJTNEJTIwTGxhbWFDb25maWcoKSUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBWaWRlb0xsYXZhJTIwdmlkZW9fbGxhdmEtMS41LTdiJTIwc3R5bGUlMjBjb25maWd1cmF0aW9uJTBBY29uZmlndXJhdGlvbiUyMCUzRCUyMFZpZGVvTGxhdmFDb25maWcodmlzaW9uX2NvbmZpZyUyQyUyMHRleHRfY29uZmlnKSUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBtb2RlbCUyMGZyb20lMjB0aGUlMjB2aWRlb19sbGF2YS0xLjUtN2IlMjBzdHlsZSUyMGNvbmZpZ3VyYXRpb24lMEFtb2RlbCUyMCUzRCUyMFZpZGVvTGxhdmFGb3JDb25kaXRpb25hbEdlbmVyYXRpb24oY29uZmlndXJhdGlvbiklMEElMEElMjMlMjBBY2Nlc3NpbmclMjB0aGUlMjBtb2RlbCUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwbW9kZWwuY29uZmln",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> VideoLlavaForConditionalGeneration, VideoLlavaConfig, CLIPVisionConfig, LlamaConfig

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a CLIP-vision config</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>vision_config = CLIPVisionConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a Llama config</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>text_config = LlamaConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a VideoLlava video_llava-1.5-7b style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = VideoLlavaConfig(vision_config, text_config)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model from the video_llava-1.5-7b style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = VideoLlavaForConditionalGeneration(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){d=r("p"),d.textContent=T,y=n(),m(M.$$.fragment)},l(i){d=l(i,"P",{"data-svelte-h":!0}),_(d)!=="svelte-11lpom8"&&(d.textContent=T),y=s(i),p(M.$$.fragment,i)},m(i,b){t(i,d,b),t(i,y,b),h(M,i,b),v=!0},p:Eo,i(i){v||(g(M.$$.fragment,i),v=!0)},o(i){f(M.$$.fragment,i),v=!1},d(i){i&&(a(d),a(y)),u(M,i)}}}function Ha(B){let d,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){d=r("p"),d.innerHTML=T},l(y){d=l(y,"P",{"data-svelte-h":!0}),_(d)!=="svelte-fincs2"&&(d.innerHTML=T)},m(y,M){t(y,d,M)},p:Eo,d(y){y&&a(d)}}}function qa(B){let d,T="Example:",y,M,v;return M=new A({props:{code:"ZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEFpbXBvcnQlMjBudW1weSUyMGFzJTIwbnAlMEFpbXBvcnQlMjBhdiUwQWZyb20lMjBodWdnaW5nZmFjZV9odWIlMjBpbXBvcnQlMjBoZl9odWJfZG93bmxvYWQlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwVmlkZW9MbGF2YVByb2Nlc3NvciUyQyUyMFZpZGVvTGxhdmFGb3JDb25kaXRpb25hbEdlbmVyYXRpb24lMEElMEElMEFkZWYlMjByZWFkX3ZpZGVvX3B5YXYoY29udGFpbmVyJTJDJTIwaW5kaWNlcyklM0ElMEElMjAlMjAlMjAlMjAnJyclMEElMjAlMjAlMjAlMjBEZWNvZGUlMjB0aGUlMjB2aWRlbyUyMHdpdGglMjBQeUFWJTIwZGVjb2Rlci4lMEElMjAlMjAlMjAlMjBBcmdzJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwY29udGFpbmVyJTIwKCU2MGF2LmNvbnRhaW5lci5pbnB1dC5JbnB1dENvbnRhaW5lciU2MCklM0ElMjBQeUFWJTIwY29udGFpbmVyLiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGluZGljZXMlMjAoJTYwTGlzdCU1QmludCU1RCU2MCklM0ElMjBMaXN0JTIwb2YlMjBmcmFtZSUyMGluZGljZXMlMjB0byUyMGRlY29kZS4lMEElMjAlMjAlMjAlMjBSZXR1cm5zJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmVzdWx0JTIwKG5wLm5kYXJyYXkpJTNBJTIwbnAlMjBhcnJheSUyMG9mJTIwZGVjb2RlZCUyMGZyYW1lcyUyMG9mJTIwc2hhcGUlMjAobnVtX2ZyYW1lcyUyQyUyMGhlaWdodCUyQyUyMHdpZHRoJTJDJTIwMykuJTBBJTIwJTIwJTIwJTIwJycnJTBBJTIwJTIwJTIwJTIwZnJhbWVzJTIwJTNEJTIwJTVCJTVEJTBBJTIwJTIwJTIwJTIwY29udGFpbmVyLnNlZWsoMCklMEElMjAlMjAlMjAlMjBzdGFydF9pbmRleCUyMCUzRCUyMGluZGljZXMlNUIwJTVEJTBBJTIwJTIwJTIwJTIwZW5kX2luZGV4JTIwJTNEJTIwaW5kaWNlcyU1Qi0xJTVEJTBBJTIwJTIwJTIwJTIwZm9yJTIwaSUyQyUyMGZyYW1lJTIwaW4lMjBlbnVtZXJhdGUoY29udGFpbmVyLmRlY29kZSh2aWRlbyUzRDApKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlmJTIwaSUyMCUzRSUyMGVuZF9pbmRleCUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGJyZWFrJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjBpJTIwJTNFJTNEJTIwc3RhcnRfaW5kZXglMjBhbmQlMjBpJTIwaW4lMjBpbmRpY2VzJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZnJhbWVzLmFwcGVuZChmcmFtZSklMEElMjAlMjAlMjAlMjByZXR1cm4lMjBucC5zdGFjayglNUJ4LnRvX25kYXJyYXkoZm9ybWF0JTNEJTIycmdiMjQlMjIpJTIwZm9yJTIweCUyMGluJTIwZnJhbWVzJTVEKSUwQSUwQW1vZGVsJTIwJTNEJTIwVmlkZW9MbGF2YUZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyTGFuZ3VhZ2VCaW5kJTJGVmlkZW8tTExhVkEtN0ItaGYlMjIpJTBBcHJvY2Vzc29yJTIwJTNEJTIwVmlkZW9MbGF2YVByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyTGFuZ3VhZ2VCaW5kJTJGVmlkZW8tTExhVkEtN0ItaGYlMjIpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyVVNFUiUzQSUyMCUzQ3ZpZGVvJTNFJTVDbldoeSUyMGlzJTIwdGhpcyUyMHZpZGVvJTIwZnVubnklM0YlMjBBU1NJU1RBTlQlM0ElMjIlMEF2aWRlb19wYXRoJTIwJTNEJTIwaGZfaHViX2Rvd25sb2FkKHJlcG9faWQlM0QlMjJyYXVzaGFuLXRlc3RpbmctaGYlMkZ2aWRlb3MtdGVzdCUyMiUyQyUyMGZpbGVuYW1lJTNEJTIyc2FtcGxlX2RlbW9fMS5tcDQlMjIlMkMlMjByZXBvX3R5cGUlM0QlMjJkYXRhc2V0JTIyKSUwQWNvbnRhaW5lciUyMCUzRCUyMGF2Lm9wZW4odmlkZW9fcGF0aCklMEElMEElMjMlMjBzYW1wbGUlMjB1bmlmb3JtbHklMjA4JTIwZnJhbWVzJTIwZnJvbSUyMHRoZSUyMHZpZGVvJTBBdG90YWxfZnJhbWVzJTIwJTNEJTIwY29udGFpbmVyLnN0cmVhbXMudmlkZW8lNUIwJTVELmZyYW1lcyUwQWluZGljZXMlMjAlM0QlMjBucC5hcmFuZ2UoMCUyQyUyMHRvdGFsX2ZyYW1lcyUyQyUyMHRvdGFsX2ZyYW1lcyUyMCUyRiUyMDgpLmFzdHlwZShpbnQpJTBBY2xpcCUyMCUzRCUyMHJlYWRfdmlkZW9fcHlhdihjb250YWluZXIlMkMlMjBpbmRpY2VzKSUwQSUwQWlucHV0cyUyMCUzRCUyMHByb2Nlc3Nvcih0ZXh0JTNEcHJvbXB0JTJDJTIwdmlkZW9zJTNEY2xpcCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBJTIzJTIwR2VuZXJhdGUlMEFnZW5lcmF0ZV9pZHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMG1heF9sZW5ndGglM0Q4MCklMEFwcm9jZXNzb3IuYmF0Y2hfZGVjb2RlKGdlbmVyYXRlX2lkcyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlJTJDJTIwY2xlYW5fdXBfdG9rZW5pemF0aW9uX3NwYWNlcyUzREZhbHNlKSU1QjAlNUQlMEElMEElMjMlMjB0byUyMGdlbmVyYXRlJTIwZnJvbSUyMGltYWdlJTIwYW5kJTIwdmlkZW8lMjBtaXglMEF1cmwlMjAlM0QlMjAlMjJodHRwJTNBJTJGJTJGaW1hZ2VzLmNvY29kYXRhc2V0Lm9yZyUyRnZhbDIwMTclMkYwMDAwMDAwMzk3NjkuanBnJTIyJTBBaW1hZ2UlMjAlM0QlMjBJbWFnZS5vcGVuKHJlcXVlc3RzLmdldCh1cmwlMkMlMjBzdHJlYW0lM0RUcnVlKS5yYXcpJTBBcHJvbXB0JTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIyVVNFUiUzQSUyMCUzQ2ltYWdlJTNFJTVDbkhvdyUyMG1hbnklMjBjYXRzJTIwZG8lMjB5b3UlMjBzZWUlM0YlMjBBU1NJU1RBTlQlM0ElMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJVU0VSJTNBJTIwJTNDdmlkZW8lM0UlNUNuV2h5JTIwaXMlMjB0aGlzJTIwdmlkZW8lMjBmdW5ueSUzRiUyMEFTU0lTVEFOVCUzQSUyMiUwQSU1RCUwQWlucHV0cyUyMCUzRCUyMHByb2Nlc3Nvcih0ZXh0JTNEcHJvbXB0JTJDJTIwaW1hZ2VzJTNEaW1hZ2UlMkMlMjB2aWRlb3MlM0RjbGlwJTJDJTIwcGFkZGluZyUzRFRydWUlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQSUyMyUyMEdlbmVyYXRlJTBBZ2VuZXJhdGVfaWRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBtYXhfbGVuZ3RoJTNENTApJTBBcHJvY2Vzc29yLmJhdGNoX2RlY29kZShnZW5lcmF0ZV9pZHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSUyQyUyMGNsZWFuX3VwX3Rva2VuaXphdGlvbl9zcGFjZXMlM0RUcnVlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> av
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> hf_hub_download
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> VideoLlavaProcessor, VideoLlavaForConditionalGeneration


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">read_video_pyav</span>(<span class="hljs-params">container, indices</span>):
<span class="hljs-meta">... </span>    <span class="hljs-string">&#x27;&#x27;&#x27;
<span class="hljs-meta">... </span>    Decode the video with PyAV decoder.
<span class="hljs-meta">... </span>    Args:
<span class="hljs-meta">... </span>        container (\`av.container.input.InputContainer\`): PyAV container.
<span class="hljs-meta">... </span>        indices (\`List[int]\`): List of frame indices to decode.
<span class="hljs-meta">... </span>    Returns:
<span class="hljs-meta">... </span>        result (np.ndarray): np array of decoded frames of shape (num_frames, height, width, 3).
<span class="hljs-meta">... </span>    &#x27;&#x27;&#x27;</span>
<span class="hljs-meta">... </span>    frames = []
<span class="hljs-meta">... </span>    container.seek(<span class="hljs-number">0</span>)
<span class="hljs-meta">... </span>    start_index = indices[<span class="hljs-number">0</span>]
<span class="hljs-meta">... </span>    end_index = indices[-<span class="hljs-number">1</span>]
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> i, frame <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(container.decode(video=<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>        <span class="hljs-keyword">if</span> i &gt; end_index:
<span class="hljs-meta">... </span>            <span class="hljs-keyword">break</span>
<span class="hljs-meta">... </span>        <span class="hljs-keyword">if</span> i &gt;= start_index <span class="hljs-keyword">and</span> i <span class="hljs-keyword">in</span> indices:
<span class="hljs-meta">... </span>            frames.append(frame)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> np.stack([x.to_ndarray(<span class="hljs-built_in">format</span>=<span class="hljs-string">&quot;rgb24&quot;</span>) <span class="hljs-keyword">for</span> x <span class="hljs-keyword">in</span> frames])

<span class="hljs-meta">&gt;&gt;&gt; </span>model = VideoLlavaForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;LanguageBind/Video-LLaVA-7B-hf&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor = VideoLlavaProcessor.from_pretrained(<span class="hljs-string">&quot;LanguageBind/Video-LLaVA-7B-hf&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;USER: &lt;video&gt;\\nWhy is this video funny? ASSISTANT:&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>video_path = hf_hub_download(repo_id=<span class="hljs-string">&quot;raushan-testing-hf/videos-test&quot;</span>, filename=<span class="hljs-string">&quot;sample_demo_1.mp4&quot;</span>, repo_type=<span class="hljs-string">&quot;dataset&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>container = av.<span class="hljs-built_in">open</span>(video_path)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># sample uniformly 8 frames from the video</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>total_frames = container.streams.video[<span class="hljs-number">0</span>].frames
<span class="hljs-meta">&gt;&gt;&gt; </span>indices = np.arange(<span class="hljs-number">0</span>, total_frames, total_frames / <span class="hljs-number">8</span>).astype(<span class="hljs-built_in">int</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>clip = read_video_pyav(container, indices)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(text=prompt, videos=clip, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Generate</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generate_ids = model.generate(**inputs, max_length=<span class="hljs-number">80</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor.batch_decode(generate_ids, skip_special_tokens=<span class="hljs-literal">True</span>, clean_up_tokenization_spaces=<span class="hljs-literal">False</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&quot;USER:  Why is this video funny? ASSISTANT: The video is funny because the baby is playing with a Wii remote while sitting on the floor, and the baby is wearing glasses.Ъ. The baby&#x27;s actions are amusing because it is a young child trying to interact with a video game, which is not a typical activity for a&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># to generate from image and video mix</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = [
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;USER: &lt;image&gt;\\nHow many cats do you see? ASSISTANT:&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;USER: &lt;video&gt;\\nWhy is this video funny? ASSISTANT:&quot;</span>
<span class="hljs-meta">... </span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(text=prompt, images=image, videos=clip, padding=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Generate</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generate_ids = model.generate(**inputs, max_length=<span class="hljs-number">50</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor.batch_decode(generate_ids, skip_special_tokens=<span class="hljs-literal">True</span>, clean_up_tokenization_spaces=<span class="hljs-literal">True</span>)
[<span class="hljs-string">&#x27;USER:   How many cats do you see? ASSISTANT: There are two cats visible in the image. (or three, if you count the one in the background).&#x27;</span>, <span class="hljs-string">&#x27;USER:  Why is this video funny? ASSISTANT: The video is funny because it shows a baby sitting on a bed and playing with a Wii remote.Ъ. The baby is holding the remote&#x27;</span>]`,wrap:!1}}),{c(){d=r("p"),d.textContent=T,y=n(),m(M.$$.fragment)},l(i){d=l(i,"P",{"data-svelte-h":!0}),_(d)!=="svelte-11lpom8"&&(d.textContent=T),y=s(i),p(M.$$.fragment,i)},m(i,b){t(i,d,b),t(i,y,b),h(M,i,b),v=!0},p:Eo,i(i){v||(g(M.$$.fragment,i),v=!0)},o(i){f(M.$$.fragment,i),v=!1},d(i){i&&(a(d),a(y)),u(M,i)}}}function Da(B){let d,T,y,M,v,i,b,Ke,Q,ca="Video-LLaVa is an open-source multimodal LLM trained by fine-tuning LlamA/Vicuna on multimodal instruction-following data generated by Llava1.5 and VideChat. It is an auto-regressive language model, based on the transformer architecture. Video-LLaVa unifies visual representations to the language feature space, and enables an LLM to perform visual reasoning capabilities on both images and videos simultaneously.",Oe,P,ma='The Video-LLaVA model was proposed in <a href="https://arxiv.org/abs/2311.10122" rel="nofollow">Video-LLaVA: Learning United Visual Representation by Alignment Before Projection</a> by Bin Lin, Yang Ye, Bin Zhu, Jiaxi Cui, Munang Ning, Peng Jin, Li Yuan.',eo,H,pa="The abstract from the paper is the following:",oo,q,ha=`<em>The Large Vision-Language Model (LVLM) has enhanced the performance of various downstream tasks in
visual-language understanding. Most existing approaches
encode images and videos into separate feature spaces,
which are then fed as inputs to large language models.
However, due to the lack of unified tokenization for images and videos, namely misalignment before projection, it
becomes challenging for a Large Language Model (LLM)
to learn multi-modal interactions from several poor projection layers. In this work, we unify visual representation into the language feature space to advance the foundational LLM towards a unified LVLM. As a result, we establish a simple but robust LVLM baseline, Video-LLaVA,
which learns from a mixed dataset of images and videos,
mutually enhancing each other. Video-LLaVA achieves superior performances on a broad range of 9 image benchmarks across 5 image question-answering datasets and 4
image benchmark toolkits. Additionally, our Video-LLaVA
also outperforms Video-ChatGPT by 5.8%, 9.9%, 18.6%,
and 10.1% on MSRVTT, MSVD, TGIF, and ActivityNet, respectively. Notably, extensive experiments demonstrate that
Video-LLaVA mutually benefits images and videos within
a unified visual representation, outperforming models designed specifically for images or videos. We aim for this
work to provide modest insights into the multi-modal inputs
for the LLM</em>`,ao,D,to,K,ga="<li><p>We advise users to use padding_side=“left” when computing batched generation as it leads to more accurate results. Simply make sure to call processor.tokenizer.padding_side = “left” before generating.</p></li> <li><p>Note the model has not been explicitly trained to process multiple images/videos in the same prompt, although this is technically possible, you may experience inaccurate results.</p></li> <li><p>Note that the video inputs should have exactly 8 frames at the input, since the models were trained in that setting.</p></li>",no,O,fa=`This model was contributed by <a href="https://huggingface.co/RaushanTurganbay" rel="nofollow">RaushanTurganbay</a>.
The original code can be found <a href="https://github.com/PKU-YuanGroup/Video-LLaVA" rel="nofollow">here</a>.`,so,ee,ro,oe,lo,ae,ua="The model can accept both images and videos as input. Here’s an example code for inference in half-precision (<code>torch.float16</code>):",io,te,co,ne,_a="For multiple turns conversation change the prompt format to:",mo,se,po,re,ho,le,Ma="The model can also generate from an interleaved image-video inputs. However note, that it was not trained in interleaved image-video setting which might affect the performance. Below is an example usage for mixed media input, add the following lines to the above code snippet:",go,ie,fo,de,uo,ce,_o,me,ya="The model can be loaded in lower bits, significantly reducing memory burden while maintaining the performance of the original model. his allows for efficient deployment on resource-constrained cases.",Mo,pe,va="First make sure to install bitsandbytes by running <code>pip install bitsandbytes</code> and to have access to a GPU/accelerator that is supported by the library.",yo,W,vo,he,ba='Load the quantized model by simply adding <a href="../main_classes/quantization#transformers.BitsAndBytesConfig"><code>BitsAndBytesConfig</code></a> as shown below:',bo,ge,To,fe,wo,ue,Ta='Additionally, we can greatly speed-up model inference by using <a href="../perf_train_gpu_one.md#flash-attention-2">Flash Attention</a>, which is a faster implementation of the attention mechanism used inside the model.',Jo,_e,wa="First, make sure to install the latest version of Flash Attention 2:",jo,Me,Uo,ye,Ja='Also, you should have a hardware that is compatible with Flash-Attention 2. Read more about it in the official documentation of the <a href="https://github.com/Dao-AILab/flash-attention" rel="nofollow">flash attention repository</a>. FlashAttention-2 can only be used when a model is loaded in <code>torch.float16</code> or <code>torch.bfloat16</code>.',Vo,ve,ja="To load and run a model using Flash Attention-2, simply add <code>attn_implementation=&quot;flash_attention_2&quot;</code> when loading the model as follows:",Io,be,Co,Te,ko,w,we,So,$e,Ua=`This is the configuration class to store the configuration of a <a href="/docs/transformers/pr_30950/en/model_doc/video_llava#transformers.VideoLlavaForConditionalGeneration">VideoLlavaForConditionalGeneration</a>. It is used to instantiate an
VideoLlava model according to the specified arguments, defining the model architecture. Instantiating a configuration
with the defaults will yield a similar configuration to that of the like LanguageBind/Video-LLaVA-7B-hf.`,Yo,Re,Va='e.g. <a href="https://huggingface.co/LanguageBind/Video-LLaVA-7B-hf" rel="nofollow">LanguageBind/Video-LLaVA-7B-hf</a>',Xo,Fe,Ia=`Configuration objects inherit from <a href="/docs/transformers/pr_30950/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/pr_30950/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,Ao,x,Zo,Je,Lo,j,je,Qo,Ne,Ca="Constructs a CLIP image processor.",Po,$,Ue,Ho,Ee,ka="Preprocess an image or batch of images.",qo,R,Ve,Do,Se,Za=`Resize an image. The shortest edge of the image is resized to size[“shortest_edge”], with the longest edge
resized to keep the input aspect ratio.`,Bo,Ie,zo,J,Ce,Ko,Ye,La="Constructs a VideoLlava processor which wraps a VideoLlava image processor and a Llava tokenizer into a single processor.",Oo,Xe,Ba=`<a href="/docs/transformers/pr_30950/en/model_doc/video_llava#transformers.VideoLlavaProcessor">VideoLlavaProcessor</a> offers all the functionalities of <a href="/docs/transformers/pr_30950/en/model_doc/video_llava#transformers.VideoLlavaImageProcessor">VideoLlavaImageProcessor</a> and <a href="/docs/transformers/pr_30950/en/model_doc/llama2#transformers.LlamaTokenizerFast">LlamaTokenizerFast</a>. See the
<code>__call__()</code> and <a href="/docs/transformers/pr_30950/en/model_doc/video_llava#transformers.VideoLlavaProcessor.decode">decode()</a> for more information.`,ea,F,ke,oa,Ae,za=`This method forwards all its arguments to LlamaTokenizerFast’s <a href="/docs/transformers/pr_30950/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.batch_decode">batch_decode()</a>. Please
refer to the docstring of this method for more information.`,aa,N,Ze,ta,Qe,Ga=`This method forwards all its arguments to LlamaTokenizerFast’s <a href="/docs/transformers/pr_30950/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.decode">decode()</a>. Please refer to
the docstring of this method for more information.`,Go,Le,Wo,U,Be,na,Pe,Wa=`The VideoLlava model which consists of a vision backbone and a language model.
This model inherits from <a href="/docs/transformers/pr_30950/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,sa,He,xa=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,ra,C,ze,la,qe,$a='The <a href="/docs/transformers/pr_30950/en/model_doc/video_llava#transformers.VideoLlavaForConditionalGeneration">VideoLlavaForConditionalGeneration</a> forward method, overrides the <code>__call__</code> special method.',ia,E,da,S,xo,Ge,$o,De,Ro;return v=new I({props:{title:"Video-LLaVA",local:"video-llava",headingTag:"h1"}}),b=new I({props:{title:"Overview",local:"overview",headingTag:"h2"}}),D=new I({props:{title:"Usage tips:",local:"usage-tips",headingTag:"h2"}}),ee=new I({props:{title:"Usage example",local:"usage-example",headingTag:"h2"}}),oe=new I({props:{title:"Single Media Mode",local:"single-media-mode",headingTag:"h3"}}),te=new A({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> av
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> VideoLlavaForConditionalGeneration, VideoLlavaProcessor

<span class="hljs-keyword">def</span> <span class="hljs-title function_">read_video_pyav</span>(<span class="hljs-params">container, indices</span>):
    <span class="hljs-string">&#x27;&#x27;&#x27;
    Decode the video with PyAV decoder.
    Args:
        container (\`av.container.input.InputContainer\`): PyAV container.
        indices (\`List[int]\`): List of frame indices to decode.
    Returns:
        result (np.ndarray): np array of decoded frames of shape (num_frames, height, width, 3).
    &#x27;&#x27;&#x27;</span>
    frames = []
    container.seek(<span class="hljs-number">0</span>)
    start_index = indices[<span class="hljs-number">0</span>]
    end_index = indices[-<span class="hljs-number">1</span>]
    <span class="hljs-keyword">for</span> i, frame <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(container.decode(video=<span class="hljs-number">0</span>)):
        <span class="hljs-keyword">if</span> i &gt; end_index:
            <span class="hljs-keyword">break</span>
        <span class="hljs-keyword">if</span> i &gt;= start_index <span class="hljs-keyword">and</span> i <span class="hljs-keyword">in</span> indices:
            frames.append(frame)
    <span class="hljs-keyword">return</span> np.stack([x.to_ndarray(<span class="hljs-built_in">format</span>=<span class="hljs-string">&quot;rgb24&quot;</span>) <span class="hljs-keyword">for</span> x <span class="hljs-keyword">in</span> frames])

<span class="hljs-comment"># Load the model in half-precision</span>
model = VideoLlavaForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;LanguageBind/Video-LLaVA-7B-hf&quot;</span>, torch_dtype=torch.float16, device_map=<span class="hljs-string">&quot;auto&quot;</span>)
processor = VideoLlavaProcessor.from_pretrained(<span class="hljs-string">&quot;LanguageBind/Video-LLaVA-7B-hf&quot;</span>)

<span class="hljs-comment"># Load the video as an np.arrau, sampling uniformly 8 frames</span>
video_path = hf_hub_download(repo_id=<span class="hljs-string">&quot;raushan-testing-hf/videos-test&quot;</span>, filename=<span class="hljs-string">&quot;sample_demo_1.mp4&quot;</span>, repo_type=<span class="hljs-string">&quot;dataset&quot;</span>)
container = av.<span class="hljs-built_in">open</span>(video_path)
total_frames = container.streams.video[<span class="hljs-number">0</span>].frames
indices = np.arange(<span class="hljs-number">0</span>, total_frames, total_frames / <span class="hljs-number">8</span>).astype(<span class="hljs-built_in">int</span>)
video = read_video_pyav(container, indices)

<span class="hljs-comment"># For better results, we recommend to prompt the model in the following format</span>
prompt = <span class="hljs-string">&quot;USER: &lt;video&gt;\\nWhy is this funny? ASSISTANT:&quot;</span>
inputs = processor(text=prompt, videos=video, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

out = model.generate(**inputs, max_new_tokens=<span class="hljs-number">60</span>)
processor.batch_decode(out, skip_special_tokens=<span class="hljs-literal">True</span>, clean_up_tokenization_spaces=<span class="hljs-literal">True</span>)`,wrap:!1}}),se=new A({props:{code:"JTIyVVNFUiUzQSUyMCUzQ3ZpZGVvJTNFJTVDbldoYXQlMjBkbyUyMHlvdSUyMHNlZSUyMGluJTIwdGhpcyUyMHZpZGVvJTNGJTIwQVNTSVNUQU5UJTNBJTIwQSUyMGJhYnklMjByZWFkaW5nJTIwYSUyMGJvb2suJTIwVVNFUiUzQSUyMFdoeSUyMGlzJTIwdGhlJTIwaXQlMjBmdW5ueSUzRiUyMEFTU0lTVEFOVCUzQSUyMg==",highlighted:'<span class="hljs-string">&quot;USER: &lt;video&gt;\\nWhat do you see in this video? ASSISTANT: A baby reading a book. USER: Why is the it funny? ASSISTANT:&quot;</span>',wrap:!1}}),re=new I({props:{title:"Mixed Media Mode",local:"mixed-media-mode",headingTag:"h3"}}),ie=new A({props:{code:"ZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEElMEElMjMlMjBHZW5lcmF0ZSUyMGZyb20lMjBpbWFnZSUyMGFuZCUyMHZpZGVvJTIwbWl4ZWQlMjBpbnB1dHMlMEElMjMlMjBMb2FkJTIwYW5kJTIwaW1hZ2UlMjBhbmQlMjB3cml0ZSUyMGElMjBuZXclMjBwcm9tcHQlMEF1cmwlMjAlM0QlMjAlMjJodHRwJTNBJTJGJTJGaW1hZ2VzLmNvY29kYXRhc2V0Lm9yZyUyRnZhbDIwMTclMkYwMDAwMDAwMzk3NjkuanBnJTIyJTBBaW1hZ2UlMjAlM0QlMjBJbWFnZS5vcGVuKHJlcXVlc3RzLmdldCh1cmwlMkMlMjBzdHJlYW0lM0RUcnVlKS5yYXcpJTBBcHJvbXB0JTIwJTNEJTIwJTIyVVNFUiUzQSUyMCUzQ2ltYWdlJTNFJTVDbkhvdyUyMG1hbnklMjBjYXRzJTIwYXJlJTIwdGhlcmUlMjBpbiUyMHRoZSUyMGltYWdlJTNGJTIwQVNTSVNUQU5UJTNBJTIwVGhlcmUlMjBhcmUlMjB0d28lMjBjYXRzLiUyMFVTRVIlM0ElMjAlM0N2aWRlbyUzRSU1Q25XaHklMjBpcyUyMHRoaXMlMjB2aWRlbyUyMGZ1bm55JTNGJTIwQVNTSVNUQU5UJTNBJTIyJTBBJTBBaW5wdXRzJTIwJTNEJTIwcHJvY2Vzc29yKHRleHQlM0Rwcm9tcHQlMkMlMjBpbWFnZXMlM0RpbWFnZSUyQyUyMHZpZGVvcyUzRGNsaXAlMkMlMjBwYWRkaW5nJTNEVHJ1ZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBJTIzJTIwR2VuZXJhdGUlMEFnZW5lcmF0ZV9pZHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMG1heF9sZW5ndGglM0Q1MCklMEFwcm9jZXNzb3IuYmF0Y2hfZGVjb2RlKGdlbmVyYXRlX2lkcyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlJTJDJTIwY2xlYW5fdXBfdG9rZW5pemF0aW9uX3NwYWNlcyUzRFRydWUpJTBB",highlighted:`<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">import</span> requests

<span class="hljs-comment"># Generate from image and video mixed inputs</span>
<span class="hljs-comment"># Load and image and write a new prompt</span>
url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)
prompt = <span class="hljs-string">&quot;USER: &lt;image&gt;\\nHow many cats are there in the image? ASSISTANT: There are two cats. USER: &lt;video&gt;\\nWhy is this video funny? ASSISTANT:&quot;</span>

inputs = processor(text=prompt, images=image, videos=clip, padding=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-comment"># Generate</span>
generate_ids = model.generate(**inputs, max_length=<span class="hljs-number">50</span>)
processor.batch_decode(generate_ids, skip_special_tokens=<span class="hljs-literal">True</span>, clean_up_tokenization_spaces=<span class="hljs-literal">True</span>)
`,wrap:!1}}),de=new I({props:{title:"Model optimization",local:"model-optimization",headingTag:"h2"}}),ce=new I({props:{title:"Quantization using Bitsandbytes for memory efficiency",local:"quantization-using-bitsandbytes-for-memory-efficiency",headingTag:"h3"}}),W=new Ra({props:{$$slots:{default:[Qa]},$$scope:{ctx:B}}}),ge=new A({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFZpZGVvTGxhdmFGb3JDb25kaXRpb25hbEdlbmVyYXRpb24lMkMlMjBCaXRzQW5kQnl0ZXNDb25maWclMEElMEElMjMlMjBzcGVjaWZ5JTIwaG93JTIwdG8lMjBxdWFudGl6ZSUyMHRoZSUyMG1vZGVsJTBBcXVhbnRpemF0aW9uX2NvbmZpZyUyMCUzRCUyMEJpdHNBbmRCeXRlc0NvbmZpZyglMEElMjAlMjAlMjAlMjBsb2FkX2luXzRiaXQlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwYm5iXzRiaXRfcXVhbnRfdHlwZSUzRCUyMm5mNCUyMiUyQyUwQSUyMCUyMCUyMCUyMGJuYl80Yml0X2NvbXB1dGVfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBKSUwQSUwQW1vZGVsJTIwJTNEJTIwVmlkZW9MbGF2YUZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyTGFuZ3VhZ2VCaW5kJTJGVmlkZW8tTExhVkEtN0ItaGYlMjIlMkMlMjBxdWFudGl6YXRpb25fY29uZmlnJTNEcXVhbnRpemF0aW9uX2NvbmZpZyUyQyUyMGRldmljZV9tYXAlM0QlMjJhdXRvJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> VideoLlavaForConditionalGeneration, BitsAndBytesConfig

<span class="hljs-comment"># specify how to quantize the model</span>
quantization_config = BitsAndBytesConfig(
    load_in_4bit=<span class="hljs-literal">True</span>,
    bnb_4bit_quant_type=<span class="hljs-string">&quot;nf4&quot;</span>,
    bnb_4bit_compute_dtype=torch.float16,
)

model = VideoLlavaForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;LanguageBind/Video-LLaVA-7B-hf&quot;</span>, quantization_config=quantization_config, device_map=<span class="hljs-string">&quot;auto&quot;</span>)`,wrap:!1}}),fe=new I({props:{title:"Flash-Attention 2 to speed-up generation",local:"flash-attention-2-to-speed-up-generation",headingTag:"h3"}}),Me=new A({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1VJTIwZmxhc2gtYXR0biUyMC0tbm8tYnVpbGQtaXNvbGF0aW9u",highlighted:"pip install -U flash-attn --no-build-isolation",wrap:!1}}),be=new A({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFZpZGVvTGxhdmFGb3JDb25kaXRpb25hbEdlbmVyYXRpb24lMEElMEFtb2RlbCUyMCUzRCUyMFZpZGVvTGxhdmFGb3JDb25kaXRpb25hbEdlbmVyYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMkxhbmd1YWdlQmluZCUyRlZpZGVvLUxMYVZBLTdCLWhmJTIyJTJDJTIwJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTIwJTBBJTIwJTIwJTIwJTIwYXR0bl9pbXBsZW1lbnRhdGlvbiUzRCUyMmZsYXNoX2F0dGVudGlvbl8yJTIyJTJDJTBBKS50bygwKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> VideoLlavaForConditionalGeneration

model = VideoLlavaForConditionalGeneration.from_pretrained(
    <span class="hljs-string">&quot;LanguageBind/Video-LLaVA-7B-hf&quot;</span>, 
    torch_dtype=torch.float16, 
    attn_implementation=<span class="hljs-string">&quot;flash_attention_2&quot;</span>,
).to(<span class="hljs-number">0</span>)`,wrap:!1}}),Te=new I({props:{title:"VideoLlavaConfig",local:"transformers.VideoLlavaConfig",headingTag:"h2"}}),we=new G({props:{name:"class transformers.VideoLlavaConfig",anchor:"transformers.VideoLlavaConfig",parameters:[{name:"vision_config",val:" = None"},{name:"text_config",val:" = None"},{name:"ignore_index",val:" = -100"},{name:"image_token_index",val:" = 32000"},{name:"video_token_index",val:" = 32001"},{name:"projector_hidden_act",val:" = 'gelu'"},{name:"vision_feature_select_strategy",val:" = 'default'"},{name:"vision_feature_layer",val:" = -2"},{name:"image_seq_length",val:" = 256"},{name:"video_seq_length",val:" = 2056"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.VideoLlavaConfig.vision_config",description:`<strong>vision_config</strong> (<code>VideoLlavaVisionConfig</code>, <em>optional</em>) &#x2014;
Custom vision config or dict. Defaults to <code>CLIPVisionConfig</code> if not indicated.`,name:"vision_config"},{anchor:"transformers.VideoLlavaConfig.text_config",description:`<strong>text_config</strong> (<code>Union[AutoConfig, dict]</code>, <em>optional</em>) &#x2014;
The config object of the text backbone. Can be any of <code>LlamaConfig</code> or <code>MistralConfig</code>.
Defaults to <code>LlamaConfig</code> if not indicated.`,name:"text_config"},{anchor:"transformers.VideoLlavaConfig.ignore_index",description:`<strong>ignore_index</strong> (<code>int</code>, <em>optional</em>, defaults to -100) &#x2014;
The ignore index for the loss function.`,name:"ignore_index"},{anchor:"transformers.VideoLlavaConfig.image_token_index",description:`<strong>image_token_index</strong> (<code>int</code>, <em>optional</em>, defaults to 32000) &#x2014;
The image token index to encode the image prompt.`,name:"image_token_index"},{anchor:"transformers.VideoLlavaConfig.video_token_index",description:`<strong>video_token_index</strong> (<code>int</code>, <em>optional</em>, defaults to 32001) &#x2014;
The video token index to encode the image prompt.`,name:"video_token_index"},{anchor:"transformers.VideoLlavaConfig.projector_hidden_act",description:`<strong>projector_hidden_act</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;gelu&quot;</code>) &#x2014;
The activation function used by the multimodal projector.`,name:"projector_hidden_act"},{anchor:"transformers.VideoLlavaConfig.vision_feature_select_strategy",description:`<strong>vision_feature_select_strategy</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;default&quot;</code>) &#x2014;
The feature selection strategy used to select the vision feature from the CLIP backbone.
Can be either &#x201C;full&#x201D; to select all features or &#x201C;default&#x201D; to select features without <code>CLS</code>.`,name:"vision_feature_select_strategy"},{anchor:"transformers.VideoLlavaConfig.vision_feature_layer",description:`<strong>vision_feature_layer</strong> (<code>int</code>, <em>optional</em>, defaults to -2) &#x2014;
The index of the layer to select the vision feature.`,name:"vision_feature_layer"},{anchor:"transformers.VideoLlavaConfig.image_seq_length",description:`<strong>image_seq_length</strong> (<code>int</code>, <em>optional</em>, defaults to 256) &#x2014;
Sequence length of one image embedding.`,name:"image_seq_length"},{anchor:"transformers.VideoLlavaConfig.video_seq_length",description:`<strong>video_seq_length</strong> (<code>int</code>, <em>optional</em>, defaults to 2056) &#x2014;
Sequence length of one video embedding.`,name:"video_seq_length"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/models/video_llava/configuration_video_llava.py#L24"}}),x=new Fa({props:{anchor:"transformers.VideoLlavaConfig.example",$$slots:{default:[Pa]},$$scope:{ctx:B}}}),Je=new I({props:{title:"VideoLlavaImageProcessor",local:"transformers.VideoLlavaImageProcessor",headingTag:"h2"}}),je=new G({props:{name:"class transformers.VideoLlavaImageProcessor",anchor:"transformers.VideoLlavaImageProcessor",parameters:[{name:"do_resize",val:": bool = True"},{name:"size",val:": Dict = None"},{name:"resample",val:": Resampling = <Resampling.BICUBIC: 3>"},{name:"do_center_crop",val:": bool = True"},{name:"crop_size",val:": Dict = None"},{name:"do_rescale",val:": bool = True"},{name:"rescale_factor",val:": Union = 0.00392156862745098"},{name:"do_normalize",val:": bool = True"},{name:"image_mean",val:": Union = None"},{name:"image_std",val:": Union = None"},{name:"do_convert_rgb",val:": bool = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.VideoLlavaImageProcessor.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to resize the image&#x2019;s (height, width) dimensions to the specified <code>size</code>. Can be overridden by
<code>do_resize</code> in the <code>preprocess</code> method.`,name:"do_resize"},{anchor:"transformers.VideoLlavaImageProcessor.size",description:`<strong>size</strong> (<code>Dict[str, int]</code> <em>optional</em>, defaults to <code>{&quot;shortest_edge&quot; -- 224}</code>):
Size of the image after resizing. The shortest edge of the image is resized to size[&#x201C;shortest_edge&#x201D;], with
the longest edge resized to keep the input aspect ratio. Can be overridden by <code>size</code> in the <code>preprocess</code>
method.`,name:"size"},{anchor:"transformers.VideoLlavaImageProcessor.resample",description:`<strong>resample</strong> (<code>PILImageResampling</code>, <em>optional</em>, defaults to <code>Resampling.BICUBIC</code>) &#x2014;
Resampling filter to use if resizing the image. Can be overridden by <code>resample</code> in the <code>preprocess</code> method.`,name:"resample"},{anchor:"transformers.VideoLlavaImageProcessor.do_center_crop",description:`<strong>do_center_crop</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to center crop the image to the specified <code>crop_size</code>. Can be overridden by <code>do_center_crop</code> in the
<code>preprocess</code> method.`,name:"do_center_crop"},{anchor:"transformers.VideoLlavaImageProcessor.crop_size",description:`<strong>crop_size</strong> (<code>Dict[str, int]</code> <em>optional</em>, defaults to 224) &#x2014;
Size of the output image after applying <code>center_crop</code>. Can be overridden by <code>crop_size</code> in the <code>preprocess</code>
method.`,name:"crop_size"},{anchor:"transformers.VideoLlavaImageProcessor.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to rescale the image by the specified scale <code>rescale_factor</code>. Can be overridden by <code>do_rescale</code> in
the <code>preprocess</code> method.`,name:"do_rescale"},{anchor:"transformers.VideoLlavaImageProcessor.rescale_factor",description:`<strong>rescale_factor</strong> (<code>int</code> or <code>float</code>, <em>optional</em>, defaults to <code>1/255</code>) &#x2014;
Scale factor to use if rescaling the image. Can be overridden by <code>rescale_factor</code> in the <code>preprocess</code>
method.`,name:"rescale_factor"},{anchor:"transformers.VideoLlavaImageProcessor.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to normalize the image. Can be overridden by <code>do_normalize</code> in the <code>preprocess</code> method.`,name:"do_normalize"},{anchor:"transformers.VideoLlavaImageProcessor.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>[0.48145466, 0.4578275, 0.40821073]</code>) &#x2014;
Mean to use if normalizing the image. This is a float or list of floats the length of the number of
channels in the image. Can be overridden by the <code>image_mean</code> parameter in the <code>preprocess</code> method.`,name:"image_mean"},{anchor:"transformers.VideoLlavaImageProcessor.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>[0.26862954, 0.26130258, 0.27577711]</code>) &#x2014;
Standard deviation to use if normalizing the image. This is a float or list of floats the length of the
number of channels in the image. Can be overridden by the <code>image_std</code> parameter in the <code>preprocess</code> method.
Can be overridden by the <code>image_std</code> parameter in the <code>preprocess</code> method.`,name:"image_std"},{anchor:"transformers.VideoLlavaImageProcessor.do_convert_rgb",description:`<strong>do_convert_rgb</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to convert the image to RGB.`,name:"do_convert_rgb"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/models/video_llava/image_processing_video_llava.py#L69"}}),Ue=new G({props:{name:"preprocess",anchor:"transformers.VideoLlavaImageProcessor.preprocess",parameters:[{name:"images",val:": List = None"},{name:"videos",val:": List = None"},{name:"do_resize",val:": bool = None"},{name:"size",val:": Dict = None"},{name:"resample",val:": Resampling = None"},{name:"do_center_crop",val:": bool = None"},{name:"crop_size",val:": int = None"},{name:"do_rescale",val:": bool = None"},{name:"rescale_factor",val:": float = None"},{name:"do_normalize",val:": bool = None"},{name:"image_mean",val:": Union = None"},{name:"image_std",val:": Union = None"},{name:"do_convert_rgb",val:": bool = None"},{name:"return_tensors",val:": Union = None"},{name:"data_format",val:": Optional = <ChannelDimension.FIRST: 'channels_first'>"},{name:"input_data_format",val:": Union = None"}],parametersDescription:[{anchor:"transformers.VideoLlavaImageProcessor.preprocess.images",description:`<strong>images</strong> (<code>ImageInput</code>, <em>optional</em>) &#x2014;
List of images to preprocess. Expects a single or batch of images with pixel values ranging from 0 to 255. If
passing in images with pixel values between 0 and 1, set <code>do_rescale=False</code>.`,name:"images"},{anchor:"transformers.VideoLlavaImageProcessor.preprocess.videos",description:`<strong>videos</strong> (<code>VideoInput</code>, <em>optional</em>) &#x2014;
List of videos to preprocess. Expects a single or batch of videos with pixel values ranging from 0 to 255. If
passing in videos with pixel values between 0 and 1, set <code>do_rescale=False</code>.`,name:"videos"},{anchor:"transformers.VideoLlavaImageProcessor.preprocess.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_resize</code>) &#x2014;
Whether to resize the image.`,name:"do_resize"},{anchor:"transformers.VideoLlavaImageProcessor.preprocess.size",description:`<strong>size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to <code>self.size</code>) &#x2014;
Size of the image after resizing. Shortest edge of the image is resized to size[&#x201C;shortest_edge&#x201D;], with
the longest edge resized to keep the input aspect ratio.`,name:"size"},{anchor:"transformers.VideoLlavaImageProcessor.preprocess.resample",description:`<strong>resample</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.resample</code>) &#x2014;
Resampling filter to use if resizing the image. This can be one of the enum <code>PILImageResampling</code>. Only
has an effect if <code>do_resize</code> is set to <code>True</code>.`,name:"resample"},{anchor:"transformers.VideoLlavaImageProcessor.preprocess.do_center_crop",description:`<strong>do_center_crop</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_center_crop</code>) &#x2014;
Whether to center crop the image.`,name:"do_center_crop"},{anchor:"transformers.VideoLlavaImageProcessor.preprocess.crop_size",description:`<strong>crop_size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to <code>self.crop_size</code>) &#x2014;
Size of the center crop. Only has an effect if <code>do_center_crop</code> is set to <code>True</code>.`,name:"crop_size"},{anchor:"transformers.VideoLlavaImageProcessor.preprocess.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_rescale</code>) &#x2014;
Whether to rescale the image.`,name:"do_rescale"},{anchor:"transformers.VideoLlavaImageProcessor.preprocess.rescale_factor",description:`<strong>rescale_factor</strong> (<code>float</code>, <em>optional</em>, defaults to <code>self.rescale_factor</code>) &#x2014;
Rescale factor to rescale the image by if <code>do_rescale</code> is set to <code>True</code>.`,name:"rescale_factor"},{anchor:"transformers.VideoLlavaImageProcessor.preprocess.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_normalize</code>) &#x2014;
Whether to normalize the image.`,name:"do_normalize"},{anchor:"transformers.VideoLlavaImageProcessor.preprocess.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_mean</code>) &#x2014;
Image mean to use for normalization. Only has an effect if <code>do_normalize</code> is set to <code>True</code>.`,name:"image_mean"},{anchor:"transformers.VideoLlavaImageProcessor.preprocess.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_std</code>) &#x2014;
Image standard deviation to use for normalization. Only has an effect if <code>do_normalize</code> is set to
<code>True</code>.`,name:"image_std"},{anchor:"transformers.VideoLlavaImageProcessor.preprocess.do_convert_rgb",description:`<strong>do_convert_rgb</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_convert_rgb</code>) &#x2014;
Whether to convert the image to RGB.`,name:"do_convert_rgb"},{anchor:"transformers.VideoLlavaImageProcessor.preprocess.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <code>TensorType</code>, <em>optional</em>) &#x2014;
The type of tensors to return. Can be one of:<ul>
<li>Unset: Return a list of <code>np.ndarray</code>.</li>
<li><code>TensorType.TENSORFLOW</code> or <code>&apos;tf&apos;</code>: Return a batch of type <code>tf.Tensor</code>.</li>
<li><code>TensorType.PYTORCH</code> or <code>&apos;pt&apos;</code>: Return a batch of type <code>torch.Tensor</code>.</li>
<li><code>TensorType.NUMPY</code> or <code>&apos;np&apos;</code>: Return a batch of type <code>np.ndarray</code>.</li>
<li><code>TensorType.JAX</code> or <code>&apos;jax&apos;</code>: Return a batch of type <code>jax.numpy.ndarray</code>.</li>
</ul>`,name:"return_tensors"},{anchor:"transformers.VideoLlavaImageProcessor.preprocess.data_format",description:`<strong>data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>, defaults to <code>ChannelDimension.FIRST</code>) &#x2014;
The channel dimension format for the output image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li>Unset: Use the channel dimension format of the input image.</li>
</ul>`,name:"data_format"},{anchor:"transformers.VideoLlavaImageProcessor.preprocess.input_data_format",description:`<strong>input_data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>) &#x2014;
The channel dimension format for the input image. If unset, the channel dimension format is inferred
from the input image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li><code>&quot;none&quot;</code> or <code>ChannelDimension.NONE</code>: image in (height, width) format.</li>
</ul>`,name:"input_data_format"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/models/video_llava/image_processing_video_llava.py#L192"}}),Ve=new G({props:{name:"resize",anchor:"transformers.VideoLlavaImageProcessor.resize",parameters:[{name:"image",val:": ndarray"},{name:"size",val:": Dict"},{name:"resample",val:": Resampling = <Resampling.BICUBIC: 3>"},{name:"data_format",val:": Union = None"},{name:"input_data_format",val:": Union = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.VideoLlavaImageProcessor.resize.image",description:`<strong>image</strong> (<code>np.ndarray</code>) &#x2014;
Image to resize.`,name:"image"},{anchor:"transformers.VideoLlavaImageProcessor.resize.size",description:`<strong>size</strong> (<code>Dict[str, int]</code>) &#x2014;
Size of the output image.`,name:"size"},{anchor:"transformers.VideoLlavaImageProcessor.resize.resample",description:`<strong>resample</strong> (<code>PILImageResampling</code>, <em>optional</em>, defaults to <code>PILImageResampling.BICUBIC</code>) &#x2014;
Resampling filter to use when resiizing the image.`,name:"resample"},{anchor:"transformers.VideoLlavaImageProcessor.resize.data_format",description:`<strong>data_format</strong> (<code>str</code> or <code>ChannelDimension</code>, <em>optional</em>) &#x2014;
The channel dimension format of the image. If not provided, it will be the same as the input image.`,name:"data_format"},{anchor:"transformers.VideoLlavaImageProcessor.resize.input_data_format",description:`<strong>input_data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>) &#x2014;
The channel dimension format of the input image. If not provided, it will be inferred.`,name:"input_data_format"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/models/video_llava/image_processing_video_llava.py#L143"}}),Ie=new I({props:{title:"VideoLlavaProcessor",local:"transformers.VideoLlavaProcessor",headingTag:"h2"}}),Ce=new G({props:{name:"class transformers.VideoLlavaProcessor",anchor:"transformers.VideoLlavaProcessor",parameters:[{name:"image_processor",val:" = None"},{name:"tokenizer",val:" = None"},{name:"patch_size",val:" = None"},{name:"vision_feature_select_strategy",val:" = None"},{name:"image_token",val:" = '<image>'"},{name:"video_token",val:" = '<video>'"},{name:"chat_template",val:" = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.VideoLlavaProcessor.image_processor",description:`<strong>image_processor</strong> (<a href="/docs/transformers/pr_30950/en/model_doc/video_llava#transformers.VideoLlavaImageProcessor">VideoLlavaImageProcessor</a>, <em>optional</em>) &#x2014;
The image processor is a required input.`,name:"image_processor"},{anchor:"transformers.VideoLlavaProcessor.tokenizer",description:`<strong>tokenizer</strong> (<a href="/docs/transformers/pr_30950/en/model_doc/llama2#transformers.LlamaTokenizerFast">LlamaTokenizerFast</a>, <em>optional</em>) &#x2014;
The tokenizer is a required input.`,name:"tokenizer"},{anchor:"transformers.VideoLlavaProcessor.patch_size",description:`<strong>patch_size</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Patch size from the vision tower.`,name:"patch_size"},{anchor:"transformers.VideoLlavaProcessor.vision_feature_select_strategy",description:`<strong>vision_feature_select_strategy</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The feature selection strategy used to select the vision feature from the vision backbone.
Shoudl be same as in model&#x2019;s config`,name:"vision_feature_select_strategy"},{anchor:"transformers.VideoLlavaProcessor.image_token",description:`<strong>image_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;image&gt;&quot;</code>) &#x2014;
Special token used to denote image location.`,name:"image_token"},{anchor:"transformers.VideoLlavaProcessor.video_token",description:`<strong>video_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;video&gt;&quot;</code>) &#x2014;
Special token used to denote video location.`,name:"video_token"},{anchor:"transformers.VideoLlavaProcessor.chat_template",description:`<strong>chat_template</strong> (<code>str</code>, <em>optional</em>) &#x2014; A Jinja template which will be used to convert lists of messages
in a chat into a tokenizable string.`,name:"chat_template"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/models/video_llava/processing_video_llava.py#L31"}}),ke=new G({props:{name:"batch_decode",anchor:"transformers.VideoLlavaProcessor.batch_decode",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/models/video_llava/processing_video_llava.py#L193"}}),Ze=new G({props:{name:"decode",anchor:"transformers.VideoLlavaProcessor.decode",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/models/video_llava/processing_video_llava.py#L201"}}),Le=new I({props:{title:"VideoLlavaForConditionalGeneration",local:"transformers.VideoLlavaForConditionalGeneration",headingTag:"h2"}}),Be=new G({props:{name:"class transformers.VideoLlavaForConditionalGeneration",anchor:"transformers.VideoLlavaForConditionalGeneration",parameters:[{name:"config",val:": VideoLlavaConfig"}],parametersDescription:[{anchor:"transformers.VideoLlavaForConditionalGeneration.config",description:`<strong>config</strong> (<a href="/docs/transformers/pr_30950/en/model_doc/video_llava#transformers.VideoLlavaConfig">VideoLlavaConfig</a> or <code>VideoLlavaVisionConfig</code>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/pr_30950/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/models/video_llava/modeling_video_llava.py#L239"}}),ze=new G({props:{name:"forward",anchor:"transformers.VideoLlavaForConditionalGeneration.forward",parameters:[{name:"input_ids",val:": LongTensor = None"},{name:"pixel_values_images",val:": FloatTensor = None"},{name:"pixel_values_videos",val:": FloatTensor = None"},{name:"attention_mask",val:": Optional = None"},{name:"position_ids",val:": Optional = None"},{name:"past_key_values",val:": Optional = None"},{name:"inputs_embeds",val:": Optional = None"},{name:"vision_feature_layer",val:": Optional = None"},{name:"vision_feature_select_strategy",val:": Optional = None"},{name:"labels",val:": Optional = None"},{name:"use_cache",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"return_dict",val:": Optional = None"},{name:"cache_position",val:": Optional = None"},{name:"num_logits_to_keep",val:": int = 0"}],parametersDescription:[{anchor:"transformers.VideoLlavaForConditionalGeneration.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default should you provide
it.</p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_30950/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/pr_30950/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_30950/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.VideoLlavaForConditionalGeneration.forward.pixel_values_images",description:'<strong>pixel_values_images</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, image_size, image_size)) -- The tensors corresponding to the input images. Pixel values can be obtained using [AutoImageProcessor](/docs/transformers/pr_30950/en/model_doc/auto#transformers.AutoImageProcessor). See [VideoLlavaImageProcessor.__call__()](/docs/transformers/pr_30950/en/model_doc/videomae#transformers.VideoMAEFeatureExtractor.__call__) for details ([]</code>LlavaProcessor`] uses\n<a href="/docs/transformers/pr_30950/en/model_doc/video_llava#transformers.VideoLlavaImageProcessor">VideoLlavaImageProcessor</a> for processing images).',name:"pixel_values_images"},{anchor:"transformers.VideoLlavaForConditionalGeneration.forward.pixel_values_videos",description:'<strong>pixel_values_videos</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_frames, num_channels, image_size, image_size)) -- The tensors corresponding to the input video. Pixel values can be obtained using [AutoImageProcessor](/docs/transformers/pr_30950/en/model_doc/auto#transformers.AutoImageProcessor). See [VideoLlavaImageProcessor.__call__()](/docs/transformers/pr_30950/en/model_doc/videomae#transformers.VideoMAEFeatureExtractor.__call__) for details ([]</code>LlavaProcessor`] uses\n<a href="/docs/transformers/pr_30950/en/model_doc/video_llava#transformers.VideoLlavaImageProcessor">VideoLlavaImageProcessor</a> for processing videos).',name:"pixel_values_videos"},{anchor:"transformers.VideoLlavaForConditionalGeneration.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a></p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_30950/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/pr_30950/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_30950/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p>If <code>past_key_values</code> is used, optionally only the last <code>decoder_input_ids</code> have to be input (see
<code>past_key_values</code>).</p>
<p>If you want to change padding behavior, you should read <code>modeling_opt._prepare_decoder_attention_mask</code>
and modify to your needs. See diagram 1 in <a href="https://arxiv.org/abs/1910.13461" rel="nofollow">the paper</a> for more
information on the default strategy.</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"attention_mask"},{anchor:"transformers.VideoLlavaForConditionalGeneration.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>. <a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.VideoLlavaForConditionalGeneration.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and 2 additional tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used (see <code>past_key_values</code> input) to speed up sequential decoding.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>decoder_input_ids</code> (those that
don&#x2019;t have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all
<code>decoder_input_ids</code> of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.VideoLlavaForConditionalGeneration.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.VideoLlavaForConditionalGeneration.forward.vision_feature_layer",description:`<strong>vision_feature_layer</strong> (<code>int</code>, <em>optional</em>, defaults to -2) &#x2014;
The index of the layer to select the vision feature.`,name:"vision_feature_layer"},{anchor:"transformers.VideoLlavaForConditionalGeneration.forward.vision_feature_select_strategy",description:`<strong>vision_feature_select_strategy</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;default&quot;</code>) &#x2014;
The feature selection strategy used to select the vision feature from the vision backbone.
Can be one of <code>&quot;default&quot;</code> or <code>&quot;full&quot;</code>`,name:"vision_feature_select_strategy"},{anchor:"transformers.VideoLlavaForConditionalGeneration.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.VideoLlavaForConditionalGeneration.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.VideoLlavaForConditionalGeneration.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.VideoLlavaForConditionalGeneration.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/pr_30950/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.VideoLlavaForConditionalGeneration.forward.cache_position",description:`<strong>cache_position</strong> (<code>torch.LongTensor</code> of shape <code>(sequence_length)</code>, <em>optional</em>) &#x2014;
Indices depicting the position of the input sequence tokens in the sequence. Contrarily to <code>position_ids</code>,
this tensor is not affected by padding. It is used to update the cache in the correct position and to infer
the complete sequence length.</p>
<p>Args &#x2014;
labels (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>):
Labels for computing the masked language modeling loss. Indices should either be in <code>[0, ..., config.vocab_size]</code> or -100 (see <code>input_ids</code> docstring). Tokens with indices set to <code>-100</code> are ignored
(masked), the loss is only computed for the tokens with labels in <code>[0, ..., config.vocab_size]</code>.</p>
<p>num_logits_to_keep (<code>int</code>, <em>optional</em>):
Calculate logits for the last <code>num_logits_to_keep</code> tokens. If <code>0</code>, calculate logits for all
<code>input_ids</code> (special case). Only last token logits are needed for generation, and calculating them only for that
token can save memory, which becomes pretty significant for long sequences or large vocabulary size.`,name:"cache_position"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/models/video_llava/modeling_video_llava.py#L403",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.models.video_llava.modeling_video_llava.VideoLlavaCausalLMOutputWithPast</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/pr_30950/en/model_doc/video_llava#transformers.VideoLlavaConfig"
>VideoLlavaConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Language modeling loss (for next-token prediction).</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>)</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks) that can be used (see
<code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
<li>
<p><strong>image_hidden_states</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) — A <code>torch.FloatTensor</code> of size (batch_size, num_images, sequence_length, hidden_size)\`.
image_hidden_states of the model produced by the vision encoder and after projecting the last hidden state.</p>
</li>
<li>
<p><strong>video_hidden_states</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) — A <code>torch.FloatTensor</code>  of size <code>(batch_size * num_frames, num_videos, sequence_length, hidden_size)</code>.
video_hidden_states of the model produced by the vision encoder and after projecting the last hidden state.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.models.video_llava.modeling_video_llava.VideoLlavaCausalLMOutputWithPast</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),E=new Ra({props:{$$slots:{default:[Ha]},$$scope:{ctx:B}}}),S=new Fa({props:{anchor:"transformers.VideoLlavaForConditionalGeneration.forward.example",$$slots:{default:[qa]},$$scope:{ctx:B}}}),Ge=new Aa({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/video_llava.md"}}),{c(){d=r("meta"),T=n(),y=r("p"),M=n(),m(v.$$.fragment),i=n(),m(b.$$.fragment),Ke=n(),Q=r("p"),Q.textContent=ca,Oe=n(),P=r("p"),P.innerHTML=ma,eo=n(),H=r("p"),H.textContent=pa,oo=n(),q=r("p"),q.innerHTML=ha,ao=n(),m(D.$$.fragment),to=n(),K=r("ul"),K.innerHTML=ga,no=n(),O=r("p"),O.innerHTML=fa,so=n(),m(ee.$$.fragment),ro=n(),m(oe.$$.fragment),lo=n(),ae=r("p"),ae.innerHTML=ua,io=n(),m(te.$$.fragment),co=n(),ne=r("p"),ne.textContent=_a,mo=n(),m(se.$$.fragment),po=n(),m(re.$$.fragment),ho=n(),le=r("p"),le.textContent=Ma,go=n(),m(ie.$$.fragment),fo=n(),m(de.$$.fragment),uo=n(),m(ce.$$.fragment),_o=n(),me=r("p"),me.textContent=ya,Mo=n(),pe=r("p"),pe.innerHTML=va,yo=n(),m(W.$$.fragment),vo=n(),he=r("p"),he.innerHTML=ba,bo=n(),m(ge.$$.fragment),To=n(),m(fe.$$.fragment),wo=n(),ue=r("p"),ue.innerHTML=Ta,Jo=n(),_e=r("p"),_e.textContent=wa,jo=n(),m(Me.$$.fragment),Uo=n(),ye=r("p"),ye.innerHTML=Ja,Vo=n(),ve=r("p"),ve.innerHTML=ja,Io=n(),m(be.$$.fragment),Co=n(),m(Te.$$.fragment),ko=n(),w=r("div"),m(we.$$.fragment),So=n(),$e=r("p"),$e.innerHTML=Ua,Yo=n(),Re=r("p"),Re.innerHTML=Va,Xo=n(),Fe=r("p"),Fe.innerHTML=Ia,Ao=n(),m(x.$$.fragment),Zo=n(),m(Je.$$.fragment),Lo=n(),j=r("div"),m(je.$$.fragment),Qo=n(),Ne=r("p"),Ne.textContent=Ca,Po=n(),$=r("div"),m(Ue.$$.fragment),Ho=n(),Ee=r("p"),Ee.textContent=ka,qo=n(),R=r("div"),m(Ve.$$.fragment),Do=n(),Se=r("p"),Se.textContent=Za,Bo=n(),m(Ie.$$.fragment),zo=n(),J=r("div"),m(Ce.$$.fragment),Ko=n(),Ye=r("p"),Ye.textContent=La,Oo=n(),Xe=r("p"),Xe.innerHTML=Ba,ea=n(),F=r("div"),m(ke.$$.fragment),oa=n(),Ae=r("p"),Ae.innerHTML=za,aa=n(),N=r("div"),m(Ze.$$.fragment),ta=n(),Qe=r("p"),Qe.innerHTML=Ga,Go=n(),m(Le.$$.fragment),Wo=n(),U=r("div"),m(Be.$$.fragment),na=n(),Pe=r("p"),Pe.innerHTML=Wa,sa=n(),He=r("p"),He.innerHTML=xa,ra=n(),C=r("div"),m(ze.$$.fragment),la=n(),qe=r("p"),qe.innerHTML=$a,ia=n(),m(E.$$.fragment),da=n(),m(S.$$.fragment),xo=n(),m(Ge.$$.fragment),$o=n(),De=r("p"),this.h()},l(e){const o=Xa("svelte-u9bgzb",document.head);d=l(o,"META",{name:!0,content:!0}),o.forEach(a),T=s(e),y=l(e,"P",{}),Z(y).forEach(a),M=s(e),p(v.$$.fragment,e),i=s(e),p(b.$$.fragment,e),Ke=s(e),Q=l(e,"P",{"data-svelte-h":!0}),_(Q)!=="svelte-81xura"&&(Q.textContent=ca),Oe=s(e),P=l(e,"P",{"data-svelte-h":!0}),_(P)!=="svelte-v87k6c"&&(P.innerHTML=ma),eo=s(e),H=l(e,"P",{"data-svelte-h":!0}),_(H)!=="svelte-vfdo9a"&&(H.textContent=pa),oo=s(e),q=l(e,"P",{"data-svelte-h":!0}),_(q)!=="svelte-sk56aa"&&(q.innerHTML=ha),ao=s(e),p(D.$$.fragment,e),to=s(e),K=l(e,"UL",{"data-svelte-h":!0}),_(K)!=="svelte-s3c9rf"&&(K.innerHTML=ga),no=s(e),O=l(e,"P",{"data-svelte-h":!0}),_(O)!=="svelte-1lvcrum"&&(O.innerHTML=fa),so=s(e),p(ee.$$.fragment,e),ro=s(e),p(oe.$$.fragment,e),lo=s(e),ae=l(e,"P",{"data-svelte-h":!0}),_(ae)!=="svelte-1pauxcy"&&(ae.innerHTML=ua),io=s(e),p(te.$$.fragment,e),co=s(e),ne=l(e,"P",{"data-svelte-h":!0}),_(ne)!=="svelte-1hi3kkd"&&(ne.textContent=_a),mo=s(e),p(se.$$.fragment,e),po=s(e),p(re.$$.fragment,e),ho=s(e),le=l(e,"P",{"data-svelte-h":!0}),_(le)!=="svelte-1ngvr6w"&&(le.textContent=Ma),go=s(e),p(ie.$$.fragment,e),fo=s(e),p(de.$$.fragment,e),uo=s(e),p(ce.$$.fragment,e),_o=s(e),me=l(e,"P",{"data-svelte-h":!0}),_(me)!=="svelte-uomo89"&&(me.textContent=ya),Mo=s(e),pe=l(e,"P",{"data-svelte-h":!0}),_(pe)!=="svelte-mhaycu"&&(pe.innerHTML=va),yo=s(e),p(W.$$.fragment,e),vo=s(e),he=l(e,"P",{"data-svelte-h":!0}),_(he)!=="svelte-1niphgd"&&(he.innerHTML=ba),bo=s(e),p(ge.$$.fragment,e),To=s(e),p(fe.$$.fragment,e),wo=s(e),ue=l(e,"P",{"data-svelte-h":!0}),_(ue)!=="svelte-1bm9h4d"&&(ue.innerHTML=Ta),Jo=s(e),_e=l(e,"P",{"data-svelte-h":!0}),_(_e)!=="svelte-13kjllm"&&(_e.textContent=wa),jo=s(e),p(Me.$$.fragment,e),Uo=s(e),ye=l(e,"P",{"data-svelte-h":!0}),_(ye)!=="svelte-dzzatn"&&(ye.innerHTML=Ja),Vo=s(e),ve=l(e,"P",{"data-svelte-h":!0}),_(ve)!=="svelte-z3ioid"&&(ve.innerHTML=ja),Io=s(e),p(be.$$.fragment,e),Co=s(e),p(Te.$$.fragment,e),ko=s(e),w=l(e,"DIV",{class:!0});var V=Z(w);p(we.$$.fragment,V),So=s(V),$e=l(V,"P",{"data-svelte-h":!0}),_($e)!=="svelte-1rgrzdd"&&($e.innerHTML=Ua),Yo=s(V),Re=l(V,"P",{"data-svelte-h":!0}),_(Re)!=="svelte-q9hjjl"&&(Re.innerHTML=Va),Xo=s(V),Fe=l(V,"P",{"data-svelte-h":!0}),_(Fe)!=="svelte-o0v7bn"&&(Fe.innerHTML=Ia),Ao=s(V),p(x.$$.fragment,V),V.forEach(a),Zo=s(e),p(Je.$$.fragment,e),Lo=s(e),j=l(e,"DIV",{class:!0});var k=Z(j);p(je.$$.fragment,k),Qo=s(k),Ne=l(k,"P",{"data-svelte-h":!0}),_(Ne)!=="svelte-x48p92"&&(Ne.textContent=Ca),Po=s(k),$=l(k,"DIV",{class:!0});var We=Z($);p(Ue.$$.fragment,We),Ho=s(We),Ee=l(We,"P",{"data-svelte-h":!0}),_(Ee)!=="svelte-1x3yxsa"&&(Ee.textContent=ka),We.forEach(a),qo=s(k),R=l(k,"DIV",{class:!0});var xe=Z(R);p(Ve.$$.fragment,xe),Do=s(xe),Se=l(xe,"P",{"data-svelte-h":!0}),_(Se)!=="svelte-1qmgo6y"&&(Se.textContent=Za),xe.forEach(a),k.forEach(a),Bo=s(e),p(Ie.$$.fragment,e),zo=s(e),J=l(e,"DIV",{class:!0});var z=Z(J);p(Ce.$$.fragment,z),Ko=s(z),Ye=l(z,"P",{"data-svelte-h":!0}),_(Ye)!=="svelte-15aq8e1"&&(Ye.textContent=La),Oo=s(z),Xe=l(z,"P",{"data-svelte-h":!0}),_(Xe)!=="svelte-619u96"&&(Xe.innerHTML=Ba),ea=s(z),F=l(z,"DIV",{class:!0});var Fo=Z(F);p(ke.$$.fragment,Fo),oa=s(Fo),Ae=l(Fo,"P",{"data-svelte-h":!0}),_(Ae)!=="svelte-12t737h"&&(Ae.innerHTML=za),Fo.forEach(a),aa=s(z),N=l(z,"DIV",{class:!0});var No=Z(N);p(Ze.$$.fragment,No),ta=s(No),Qe=l(No,"P",{"data-svelte-h":!0}),_(Qe)!=="svelte-l5gitz"&&(Qe.innerHTML=Ga),No.forEach(a),z.forEach(a),Go=s(e),p(Le.$$.fragment,e),Wo=s(e),U=l(e,"DIV",{class:!0});var Y=Z(U);p(Be.$$.fragment,Y),na=s(Y),Pe=l(Y,"P",{"data-svelte-h":!0}),_(Pe)!=="svelte-1fshd6z"&&(Pe.innerHTML=Wa),sa=s(Y),He=l(Y,"P",{"data-svelte-h":!0}),_(He)!=="svelte-hswkmf"&&(He.innerHTML=xa),ra=s(Y),C=l(Y,"DIV",{class:!0});var X=Z(C);p(ze.$$.fragment,X),la=s(X),qe=l(X,"P",{"data-svelte-h":!0}),_(qe)!=="svelte-1y3ymuw"&&(qe.innerHTML=$a),ia=s(X),p(E.$$.fragment,X),da=s(X),p(S.$$.fragment,X),X.forEach(a),Y.forEach(a),xo=s(e),p(Ge.$$.fragment,e),$o=s(e),De=l(e,"P",{}),Z(De).forEach(a),this.h()},h(){L(d,"name","hf:doc:metadata"),L(d,"content",Ka),L(w,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),L($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),L(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),L(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),L(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),L(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),L(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),L(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),L(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,o){c(document.head,d),t(e,T,o),t(e,y,o),t(e,M,o),h(v,e,o),t(e,i,o),h(b,e,o),t(e,Ke,o),t(e,Q,o),t(e,Oe,o),t(e,P,o),t(e,eo,o),t(e,H,o),t(e,oo,o),t(e,q,o),t(e,ao,o),h(D,e,o),t(e,to,o),t(e,K,o),t(e,no,o),t(e,O,o),t(e,so,o),h(ee,e,o),t(e,ro,o),h(oe,e,o),t(e,lo,o),t(e,ae,o),t(e,io,o),h(te,e,o),t(e,co,o),t(e,ne,o),t(e,mo,o),h(se,e,o),t(e,po,o),h(re,e,o),t(e,ho,o),t(e,le,o),t(e,go,o),h(ie,e,o),t(e,fo,o),h(de,e,o),t(e,uo,o),h(ce,e,o),t(e,_o,o),t(e,me,o),t(e,Mo,o),t(e,pe,o),t(e,yo,o),h(W,e,o),t(e,vo,o),t(e,he,o),t(e,bo,o),h(ge,e,o),t(e,To,o),h(fe,e,o),t(e,wo,o),t(e,ue,o),t(e,Jo,o),t(e,_e,o),t(e,jo,o),h(Me,e,o),t(e,Uo,o),t(e,ye,o),t(e,Vo,o),t(e,ve,o),t(e,Io,o),h(be,e,o),t(e,Co,o),h(Te,e,o),t(e,ko,o),t(e,w,o),h(we,w,null),c(w,So),c(w,$e),c(w,Yo),c(w,Re),c(w,Xo),c(w,Fe),c(w,Ao),h(x,w,null),t(e,Zo,o),h(Je,e,o),t(e,Lo,o),t(e,j,o),h(je,j,null),c(j,Qo),c(j,Ne),c(j,Po),c(j,$),h(Ue,$,null),c($,Ho),c($,Ee),c(j,qo),c(j,R),h(Ve,R,null),c(R,Do),c(R,Se),t(e,Bo,o),h(Ie,e,o),t(e,zo,o),t(e,J,o),h(Ce,J,null),c(J,Ko),c(J,Ye),c(J,Oo),c(J,Xe),c(J,ea),c(J,F),h(ke,F,null),c(F,oa),c(F,Ae),c(J,aa),c(J,N),h(Ze,N,null),c(N,ta),c(N,Qe),t(e,Go,o),h(Le,e,o),t(e,Wo,o),t(e,U,o),h(Be,U,null),c(U,na),c(U,Pe),c(U,sa),c(U,He),c(U,ra),c(U,C),h(ze,C,null),c(C,la),c(C,qe),c(C,ia),h(E,C,null),c(C,da),h(S,C,null),t(e,xo,o),h(Ge,e,o),t(e,$o,o),t(e,De,o),Ro=!0},p(e,[o]){const V={};o&2&&(V.$$scope={dirty:o,ctx:e}),W.$set(V);const k={};o&2&&(k.$$scope={dirty:o,ctx:e}),x.$set(k);const We={};o&2&&(We.$$scope={dirty:o,ctx:e}),E.$set(We);const xe={};o&2&&(xe.$$scope={dirty:o,ctx:e}),S.$set(xe)},i(e){Ro||(g(v.$$.fragment,e),g(b.$$.fragment,e),g(D.$$.fragment,e),g(ee.$$.fragment,e),g(oe.$$.fragment,e),g(te.$$.fragment,e),g(se.$$.fragment,e),g(re.$$.fragment,e),g(ie.$$.fragment,e),g(de.$$.fragment,e),g(ce.$$.fragment,e),g(W.$$.fragment,e),g(ge.$$.fragment,e),g(fe.$$.fragment,e),g(Me.$$.fragment,e),g(be.$$.fragment,e),g(Te.$$.fragment,e),g(we.$$.fragment,e),g(x.$$.fragment,e),g(Je.$$.fragment,e),g(je.$$.fragment,e),g(Ue.$$.fragment,e),g(Ve.$$.fragment,e),g(Ie.$$.fragment,e),g(Ce.$$.fragment,e),g(ke.$$.fragment,e),g(Ze.$$.fragment,e),g(Le.$$.fragment,e),g(Be.$$.fragment,e),g(ze.$$.fragment,e),g(E.$$.fragment,e),g(S.$$.fragment,e),g(Ge.$$.fragment,e),Ro=!0)},o(e){f(v.$$.fragment,e),f(b.$$.fragment,e),f(D.$$.fragment,e),f(ee.$$.fragment,e),f(oe.$$.fragment,e),f(te.$$.fragment,e),f(se.$$.fragment,e),f(re.$$.fragment,e),f(ie.$$.fragment,e),f(de.$$.fragment,e),f(ce.$$.fragment,e),f(W.$$.fragment,e),f(ge.$$.fragment,e),f(fe.$$.fragment,e),f(Me.$$.fragment,e),f(be.$$.fragment,e),f(Te.$$.fragment,e),f(we.$$.fragment,e),f(x.$$.fragment,e),f(Je.$$.fragment,e),f(je.$$.fragment,e),f(Ue.$$.fragment,e),f(Ve.$$.fragment,e),f(Ie.$$.fragment,e),f(Ce.$$.fragment,e),f(ke.$$.fragment,e),f(Ze.$$.fragment,e),f(Le.$$.fragment,e),f(Be.$$.fragment,e),f(ze.$$.fragment,e),f(E.$$.fragment,e),f(S.$$.fragment,e),f(Ge.$$.fragment,e),Ro=!1},d(e){e&&(a(T),a(y),a(M),a(i),a(Ke),a(Q),a(Oe),a(P),a(eo),a(H),a(oo),a(q),a(ao),a(to),a(K),a(no),a(O),a(so),a(ro),a(lo),a(ae),a(io),a(co),a(ne),a(mo),a(po),a(ho),a(le),a(go),a(fo),a(uo),a(_o),a(me),a(Mo),a(pe),a(yo),a(vo),a(he),a(bo),a(To),a(wo),a(ue),a(Jo),a(_e),a(jo),a(Uo),a(ye),a(Vo),a(ve),a(Io),a(Co),a(ko),a(w),a(Zo),a(Lo),a(j),a(Bo),a(zo),a(J),a(Go),a(Wo),a(U),a(xo),a($o),a(De)),a(d),u(v,e),u(b,e),u(D,e),u(ee,e),u(oe,e),u(te,e),u(se,e),u(re,e),u(ie,e),u(de,e),u(ce,e),u(W,e),u(ge,e),u(fe,e),u(Me,e),u(be,e),u(Te,e),u(we),u(x),u(Je,e),u(je),u(Ue),u(Ve),u(Ie,e),u(Ce),u(ke),u(Ze),u(Le,e),u(Be),u(ze),u(E),u(S),u(Ge,e)}}}const Ka='{"title":"Video-LLaVA","local":"video-llava","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Usage tips:","local":"usage-tips","sections":[],"depth":2},{"title":"Usage example","local":"usage-example","sections":[{"title":"Single Media Mode","local":"single-media-mode","sections":[],"depth":3},{"title":"Mixed Media Mode","local":"mixed-media-mode","sections":[],"depth":3}],"depth":2},{"title":"Model optimization","local":"model-optimization","sections":[{"title":"Quantization using Bitsandbytes for memory efficiency","local":"quantization-using-bitsandbytes-for-memory-efficiency","sections":[],"depth":3},{"title":"Flash-Attention 2 to speed-up generation","local":"flash-attention-2-to-speed-up-generation","sections":[],"depth":3}],"depth":2},{"title":"VideoLlavaConfig","local":"transformers.VideoLlavaConfig","sections":[],"depth":2},{"title":"VideoLlavaImageProcessor","local":"transformers.VideoLlavaImageProcessor","sections":[],"depth":2},{"title":"VideoLlavaProcessor","local":"transformers.VideoLlavaProcessor","sections":[],"depth":2},{"title":"VideoLlavaForConditionalGeneration","local":"transformers.VideoLlavaForConditionalGeneration","sections":[],"depth":2}],"depth":1}';function Oa(B){return Ea(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class lt extends Sa{constructor(d){super(),Ya(this,d,Oa,Da,Na,{})}}export{lt as component};
