import{s as cs,f as os,o as us,n as rs}from"../chunks/scheduler.f6319a2a.js";import{S as ys,i as Js,g as i,s as n,r as p,A as ws,h as o,f as l,c as a,j as Ms,u as r,x as M,k as ze,y as Ts,a as s,v as c,d as u,t as y,w as J}from"../chunks/index.85aa684c.js";import{T as ps}from"../chunks/Tip.3d397a88.js";import{C as x}from"../chunks/CodeBlock.3400fc53.js";import{D as ds}from"../chunks/DocNotebookDropdown.3fc3604b.js";import{H as d,E as ms}from"../chunks/index.9e1e6fd7.js";function Us(He){let w,j='If you’re new to building agents, make sure to first read the <a href="../conceptual_guides/intro_agents">intro to agents</a> and the <a href="../guided_tour">guided tour of smolagents</a>.';return{c(){w=i("p"),w.innerHTML=j},l(m){w=o(m,"P",{"data-svelte-h":!0}),M(w)!=="svelte-1p1d9vw"&&(w.innerHTML=j)},m(m,h){s(m,w,h)},p:rs,d(m){m&&l(w)}}}function hs(He){let w,j="It’s important to understand that no local python sandbox can ever be completely secure. While our interpreter provides significant safety improvements over the standard Python interpreter, it is still possible for a determined attacker or a fine-tuned malicious LLM to find vulnerabilities and potentially harm your environment.",m,h,I="For example, if you’ve allowed packages like <code>Pillow</code> to process images, the LLM could generate code that creates thousands of large image files to fill your hard drive. Other advanced escape techniques might exploit deeper vulnerabilities in authorized packages.",g,U,B="Running LLM-generated code in your local environment always carries some inherent risk. The only way to run LLM-generated code with truly robust security isolation is to use remote execution options like E2B or Docker, as detailed below.";return{c(){w=i("p"),w.textContent=j,m=n(),h=i("p"),h.innerHTML=I,g=n(),U=i("p"),U.textContent=B},l(T){w=o(T,"P",{"data-svelte-h":!0}),M(w)!=="svelte-13ohzr"&&(w.textContent=j),m=a(T),h=o(T,"P",{"data-svelte-h":!0}),M(h)!=="svelte-1wfid17"&&(h.innerHTML=I),g=a(T),U=o(T,"P",{"data-svelte-h":!0}),M(U)!=="svelte-1zo76k"&&(U.textContent=B)},m(T,b){s(T,w,b),s(T,m,b),s(T,h,b),s(T,g,b),s(T,U,b)},p:rs,d(T){T&&(l(w),l(m),l(h),l(g),l(U))}}}function js(He){let w,j,m,h,I,g,U,B,T,b,v,qe,Z,yl='<a href="https://huggingface.co/papers/2402.01030" rel="nofollow">Multiple</a> <a href="https://huggingface.co/papers/2411.01747" rel="nofollow">research</a> <a href="https://huggingface.co/papers/2401.00812" rel="nofollow">papers</a> have shown that having the LLM write its actions (the tool calls) in code is much better than the current standard format for tool calling, which is across the industry different shades of “writing actions as a JSON of tools names and arguments to use”.',Le,k,Jl="Why is code better? Well, because we crafted our code languages specifically to be great at expressing actions performed by a computer. If JSON snippets were a better way, this package would have been written in JSON snippets and the devil would be laughing at us.",Pe,A,wl="Code is just a better way to express actions on a computer. It has better:",De,W,Tl="<li><strong>Composability:</strong> could you nest JSON actions within each other, or define a set of JSON actions to re-use later, the same way you could just define a python function?</li> <li><strong>Object management:</strong> how do you store the output of an action like <code>generate_image</code> in JSON?</li> <li><strong>Generality:</strong> code is built to express simply anything you can have a computer do.</li> <li><strong>Representation in LLM training corpus:</strong> why not leverage this benediction of the sky that plenty of quality actions have already been included in LLM training corpus?</li>",Ke,G,dl='This is illustrated on the figure below, taken from <a href="https://huggingface.co/papers/2402.01030" rel="nofollow">Executable Code Actions Elicit Better LLM Agents</a>.',Oe,Ye,ml,et,E,Ul="This is why we put emphasis on proposing code agents, in this case python agents, which meant putting higher effort on building secure python interpreters.",tt,$,lt,R,hl="By default, the <code>CodeAgent</code> runs LLM-generated code in your environment.",st,V,jl="This is inherently risky, LLM-generated code could be harmful to your environment.",nt,S,Il="Malicious code execution can occur in several ways:",at,_,bl=`<li><strong>Plain LLM error:</strong> LLMs are still far from perfect and may unintentionally generate harmful commands while attempting to be helpful. While this risk is low, instances have been observed where an LLM attempted to execute potentially dangerous code.</li> <li><strong>Supply chain attack:</strong> Running an untrusted or compromised LLM could expose a system to harmful code generation. While this risk is extremely low when using well-known models on secure inference infrastructure, it remains a theoretical possibility.</li> <li><strong>Prompt injection:</strong> an agent browsing the web could arrive on a malicious website that contains harmful instructions, thus injecting an attack into the agent’s memory</li> <li><strong>Exploitation of publicly accessible agents:</strong> Agents exposed to the public can be misused by malicious actors to execute harmful code. Attackers may craft adversarial inputs to exploit the agent’s execution capabilities, leading to unintended consequences.
Once malicious code is executed, whether accidentally or intentionally, it can damage the file system, exploit local or cloud-based resources, abuse API services, and even compromise network security.</li>`,it,N,gl='One could argue that on the <a href="../conceptual_guides/intro_agents">spectrum of agency</a>, code agents give much higher agency to the LLM on your system than other less agentic setups: this goes hand-in-hand with higher risk.',ot,Q,Cl="So you need to be very mindful of security.",Mt,H,fl="To improve safety, we propose a range of measures that propose elevated levels of security, at a higher setup cost.",pt,Y,xl="We advise you to keep in mind that no solution will be 100% safe.",rt,Xe,Bl,ct,X,ut,F,vl=`To add a first layer of security, code execution in <code>smolagents</code> is not performed by the vanilla Python interpreter.
We have re-built a more secure <code>LocalPythonExecutor</code> from the ground up.`,yt,z,Zl="To be precise, this interpreter works by loading the Abstract Syntax Tree (AST) from your Code and executes it operation by operation, making sure to always follow certain rules:",Jt,q,kl="<li>By default, imports are disallowed unless they have been explicitly added to an authorization list by the user.</li> <li>Furthermore, access to submodules is disabled by default, and each must be explicitly authorized in the import list as well, or you can pass for instance <code>numpy.*</code> to allow both <code>numpy</code> and all its subpackags, like <code>numpy.random</code> or <code>numpy.a.b</code>.<ul><li>Note that some seemingly innocuous packages like <code>random</code> can give access to potentially harmful submodules, as in <code>random._os</code>.</li></ul></li> <li>The total count of elementary operations processed is capped to prevent infinite loops and resource bloating.</li> <li>Any operation that has not been explicitly defined in our custom interpreter will raise an error.</li>",wt,L,Al="You could try these safeguards as follows:",Tt,P,dt,D,Wl=`These safeguards make out interpreter is safer.
We have used it on a diversity of use cases, without ever observing any damage to the environment.`,mt,C,Ut,K,Gl=`The risk of a malicious attack is low when using well-known LLMs from trusted inference providers, but it is not zero.
For high-security applications or when using less trusted models, you should consider using a remote execution sandbox.`,ht,O,jt,ee,El="When working with AI agents that execute code, security is paramount. There are two main approaches to sandboxing code execution in smolagents, each with different security properties and capabilities:",It,te,$l='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/smolagents/remote_execution.png" alt="Sandbox approaches comparison"/>',bt,le,Rl="<li><p><strong>Running individual code snippets in a sandbox</strong>: This approach (left side of diagram) only executes the agent-generated Python code snippets in a sandbox while keeping the rest of the agentic system in your local environment. It’s simpler to set up using <code>executor_type=&quot;e2b&quot;</code> or <code>executor_type=&quot;docker&quot;</code>, but it doesn’t support multi-agents and still requires passing state data between your environment and the sandbox.</p></li> <li><p><strong>Running the entire agentic system in a sandbox</strong>: This approach (right side of diagram) runs the entire agentic system, including the agent, model, and tools, within a sandbox environment. This provides better isolation but requires more manual setup and may require passing sensitive credentials (like API keys) to the sandbox environment.</p></li>",gt,se,Vl="This guide describes how to set up and use both types of sandbox approaches for your agent applications.",Ct,ne,ft,ae,xt,ie,Sl='<li>Create an E2B account at <a href="https://e2b.dev" rel="nofollow">e2b.dev</a></li> <li>Install the required packages:</li>',Bt,oe,vt,Me,Zt,pe,_l="We provide a simple way to use an E2B Sandbox: simply add <code>executor_type=&quot;e2b&quot;</code> to the agent initialization, as follows:",kt,re,At,ce,Nl=`This solution send the agent state to the server at the start of each <code>agent.run()</code>.
Then the models are called from the local environment, but the generated code will be sent to the sandbox for execution, and only the output will be returned.`,Wt,ue,Ql="This is illustrated in the figure below.",Gt,f,Hl='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/smolagents/sandboxed_execution.png" alt="sandboxed code execution" width="60%" max-width="500px"/>',Et,ye,Yl=`However, since any call to a <a href="../examples/multiagents">managed agent</a> would require model calls, since we do not transfer secrets to the remote sandbox, the model call would lack credentials.
Hence this solution does not work (yet) with more complicated multi-agent setups.`,$t,Je,Rt,we,Xl="To use multi-agents in an E2B sandbox, you need to run your agents completely from within E2B.",Vt,Te,Fl="Here is how to do it:",St,de,_t,me,Nt,Ue,Qt,he,zl='<li><a href="https://docs.docker.com/get-started/get-docker/" rel="nofollow">Install Docker on your system</a></li> <li>Install the required packages:</li>',Ht,je,Yt,Ie,Xt,be,ql="Similar to the E2B Sandbox above, to quickly get started with Docker, simply add <code>executor_type=&quot;docker&quot;</code> to the agent initialization, like:",Ft,ge,zt,Ce,qt,fe,Ll="If you want to run multi-agent systems in Docker, you’ll need to setup a custom interpreter in a sandbox.",Lt,xe,Pl="Here is how to setup the a Dockerfile:",Pt,Be,Dt,ve,Dl="Create a sandbox manager to run code:",Kt,Ze,Ot,ke,el,Ae,Kl="These key practices apply to both E2B and Docker sandboxes:",tl,We,Ol="<li><p>Resource management</p> <ul><li>Set memory and CPU limits</li> <li>Implement execution timeouts</li> <li>Monitor resource usage</li></ul></li> <li><p>Security</p> <ul><li>Run with minimal privileges</li> <li>Disable unnecessary network access</li> <li>Use environment variables for secrets</li></ul></li> <li><p>Environment</p> <ul><li>Keep dependencies minimal</li> <li>Use fixed package versions</li> <li>If you use base images, update them regularly</li></ul></li> <li><p>Cleanup</p> <ul><li>Always ensure proper cleanup of resources, especially for Docker containers, to avoid having dangling containers eating up resources.</li></ul></li>",ll,Ge,es="✨ By following these practices and implementing proper cleanup procedures, you can ensure your agent runs safely and efficiently in a sandboxed environment.",sl,Ee,nl,$e,ts="As illustrated in the diagram earlier, both sandboxing approaches have different security implications:",al,Re,il,Ve,ls="<li><strong>Pros</strong>: <ul><li>Easier to set up with a simple parameter (<code>executor_type=&quot;e2b&quot;</code> or <code>executor_type=&quot;docker&quot;</code>)</li> <li>No need to transfer API keys to the sandbox</li> <li>Better protection for your local environment</li></ul></li> <li><strong>Cons</strong>:<ul><li>Doesn’t support multi-agents (managed agents)</li> <li>Still requires transferring state between your environment and the sandbox</li> <li>Limited to specific code execution</li></ul></li>",ol,Se,Ml,_e,ss="<li><strong>Pros</strong>:<ul><li>Supports multi-agents</li> <li>Complete isolation of the entire agent system</li> <li>More flexible for complex agent architectures</li></ul></li> <li><strong>Cons</strong>:<ul><li>Requires more manual setup</li> <li>May require transferring sensitive API keys to the sandbox</li> <li>Potentially higher latency due to more complex operations</li></ul></li>",pl,Ne,ns="Choose the approach that best balances your security needs with your application’s requirements. For most applications with simpler agent architectures, Approach 1 provides a good balance of security and ease of use. For more complex multi-agent systems where you need full isolation, Approach 2, while more involved to set up, offers better security guarantees.",rl,Qe,cl,Fe,ul;return I=new d({props:{title:"Secure code execution",local:"secure-code-execution",headingTag:"h1"}}),U=new ds({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/secure_code_execution.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/pytorch/secure_code_execution.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/tensorflow/secure_code_execution.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/secure_code_execution.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/pytorch/secure_code_execution.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/tensorflow/secure_code_execution.ipynb"}]}}),T=new ps({props:{warning:!1,$$slots:{default:[Us]},$$scope:{ctx:He}}}),v=new d({props:{title:"Code agents",local:"code-agents",headingTag:"h3"}}),$=new d({props:{title:"Local code execution??",local:"local-code-execution",headingTag:"h3"}}),X=new d({props:{title:"Our local Python executor",local:"our-local-python-executor",headingTag:"h3"}}),P=new x({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> smolagents.local_python_executor <span class="hljs-keyword">import</span> LocalPythonExecutor

<span class="hljs-comment"># Set up custom executor, authorize package &quot;numpy&quot;</span>
custom_executor = LocalPythonExecutor([<span class="hljs-string">&quot;numpy&quot;</span>])

<span class="hljs-comment"># Utilisty for pretty printing errors</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">run_capture_exception</span>(<span class="hljs-params">command: <span class="hljs-built_in">str</span></span>):
    <span class="hljs-keyword">try</span>:
        custom_executor(harmful_command)
    <span class="hljs-keyword">except</span> Exception <span class="hljs-keyword">as</span> e:
        <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;ERROR:\\n&quot;</span>, e)

<span class="hljs-comment"># Undefined command just do not work</span>
harmful_command=<span class="hljs-string">&quot;!echo Bad command&quot;</span>
run_capture_exception(harmful_command)
<span class="hljs-comment"># &gt;&gt;&gt; ERROR: invalid syntax (&lt;unknown&gt;, line 1)</span>


<span class="hljs-comment"># Imports like os will not be performed unless explicitly added to \`additional_authorized_imports\`</span>
harmful_command=<span class="hljs-string">&quot;import os; exit_code = os.system(&quot;</span>echo Bad command<span class="hljs-string">&quot;)&quot;</span>
run_capture_exception(harmful_command)
<span class="hljs-comment"># &gt;&gt;&gt; ERROR: Code execution failed at line &#x27;import os&#x27; due to: InterpreterError: Import of os is not allowed. Authorized imports are: [&#x27;statistics&#x27;, &#x27;numpy&#x27;, &#x27;itertools&#x27;, &#x27;time&#x27;, &#x27;queue&#x27;, &#x27;collections&#x27;, &#x27;math&#x27;, &#x27;random&#x27;, &#x27;re&#x27;, &#x27;datetime&#x27;, &#x27;stat&#x27;, &#x27;unicodedata&#x27;]</span>

<span class="hljs-comment"># Even in authorized imports, potentially harmful packages will not be imported</span>
harmful_command=<span class="hljs-string">&quot;import random; random._os.system(&#x27;echo Bad command&#x27;)&quot;</span>
run_capture_exception(harmful_command)
<span class="hljs-comment"># &gt;&gt;&gt; ERROR: Code execution failed at line &#x27;random._os.system(&#x27;echo Bad command&#x27;)&#x27; due to: InterpreterError: Forbidden access to module: os</span>

<span class="hljs-comment"># Infinite loop are interrupted after N operations</span>
harmful_command=<span class="hljs-string">&quot;&quot;&quot;
while True:
    pass
&quot;&quot;&quot;</span>
run_capture_exception(harmful_command)
<span class="hljs-comment"># &gt;&gt;&gt; ERROR: Code execution failed at line &#x27;while True: pass&#x27; due to: InterpreterError: Maximum number of 1000000 iterations in While loop exceeded</span>`,wrap:!1}}),C=new ps({props:{warning:!0,$$slots:{default:[hs]},$$scope:{ctx:He}}}),O=new d({props:{title:"Sandbox approaches for secure code execution",local:"sandbox-approaches-for-secure-code-execution",headingTag:"h2"}}),ne=new d({props:{title:"E2B setup",local:"e2b-setup",headingTag:"h3"}}),ae=new d({props:{title:"Installation",local:"installation",headingTag:"h4"}}),oe=new x({props:{code:"cGlwJTIwaW5zdGFsbCUyMCdzbW9sYWdlbnRzJTVCZTJiJTVEJw==",highlighted:'pip install <span class="hljs-string">&#x27;smolagents[e2b]&#x27;</span>',wrap:!1}}),Me=new d({props:{title:"Running your agent in E2B: quick start",local:"running-your-agent-in-e2b-quick-start",headingTag:"h4"}}),re=new x({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBIZkFwaU1vZGVsJTJDJTIwQ29kZUFnZW50JTBBJTBBYWdlbnQlMjAlM0QlMjBDb2RlQWdlbnQobW9kZWwlM0RIZkFwaU1vZGVsKCklMkMlMjB0b29scyUzRCU1QiU1RCUyQyUyMGV4ZWN1dG9yX3R5cGUlM0QlMjJlMmIlMjIpJTBBJTBBYWdlbnQucnVuKCUyMkNhbiUyMHlvdSUyMGdpdmUlMjBtZSUyMHRoZSUyMDEwMHRoJTIwRmlib25hY2NpJTIwbnVtYmVyJTNGJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> HfApiModel, CodeAgent

agent = CodeAgent(model=HfApiModel(), tools=[], executor_type=<span class="hljs-string">&quot;e2b&quot;</span>)

agent.run(<span class="hljs-string">&quot;Can you give me the 100th Fibonacci number?&quot;</span>)`,wrap:!1}}),Je=new d({props:{title:"Running your agent in E2B: multi-agents",local:"running-your-agent-in-e2b-multi-agents",headingTag:"h4"}}),de=new x({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> e2b_code_interpreter <span class="hljs-keyword">import</span> Sandbox
<span class="hljs-keyword">import</span> os

<span class="hljs-comment"># Create the sandbox</span>
sandbox = Sandbox()

<span class="hljs-comment"># Install required packages</span>
sandbox.commands.run(<span class="hljs-string">&quot;pip install smolagents&quot;</span>)

<span class="hljs-keyword">def</span> <span class="hljs-title function_">run_code_raise_errors</span>(<span class="hljs-params">sandbox, code: <span class="hljs-built_in">str</span>, verbose: <span class="hljs-built_in">bool</span> = <span class="hljs-literal">False</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    execution = sandbox.run_code(
        code,
        envs={<span class="hljs-string">&#x27;HF_TOKEN&#x27;</span>: os.getenv(<span class="hljs-string">&#x27;HF_TOKEN&#x27;</span>)}
    )
    <span class="hljs-keyword">if</span> execution.error:
        execution_logs = <span class="hljs-string">&quot;\\n&quot;</span>.join([<span class="hljs-built_in">str</span>(log) <span class="hljs-keyword">for</span> log <span class="hljs-keyword">in</span> execution.logs.stdout])
        logs = execution_logs
        logs += execution.error.traceback
        <span class="hljs-keyword">raise</span> ValueError(logs)
    <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;\\n&quot;</span>.join([<span class="hljs-built_in">str</span>(log) <span class="hljs-keyword">for</span> log <span class="hljs-keyword">in</span> execution.logs.stdout])

<span class="hljs-comment"># Define your agent application</span>
agent_code = <span class="hljs-string">&quot;&quot;&quot;
import os
from smolagents import CodeAgent, HfApiModel

# Initialize the agents
agent = CodeAgent(
    model=HfApiModel(token=os.getenv(&quot;HF_TOKEN&quot;), provider=&quot;together&quot;),
    tools=[],
    name=&quot;coder_agent&quot;,
    description=&quot;This agent takes care of your difficult algorithmic problems using code.&quot;
)

manager_agent = CodeAgent(
    model=HfApiModel(token=os.getenv(&quot;HF_TOKEN&quot;), provider=&quot;together&quot;),
    tools=[],
    managed_agents=[agent],
)

# Run the agent
response = manager_agent.run(&quot;What&#x27;s the 20th Fibonacci number?&quot;)
print(response)
&quot;&quot;&quot;</span>

<span class="hljs-comment"># Run the agent code in the sandbox</span>
execution_logs = run_code_raise_errors(sandbox, agent_code)
<span class="hljs-built_in">print</span>(execution_logs)`,wrap:!1}}),me=new d({props:{title:"Docker setup",local:"docker-setup",headingTag:"h3"}}),Ue=new d({props:{title:"Installation",local:"installation",headingTag:"h4"}}),je=new x({props:{code:"cGlwJTIwaW5zdGFsbCUyMCdzbW9sYWdlbnRzJTVCZG9ja2VyJTVEJw==",highlighted:'pip install <span class="hljs-string">&#x27;smolagents[docker]&#x27;</span>',wrap:!1}}),Ie=new d({props:{title:"Running your agent in E2B: quick start",local:"running-your-agent-in-e2b-quick-start",headingTag:"h4"}}),ge=new x({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBIZkFwaU1vZGVsJTJDJTIwQ29kZUFnZW50JTBBJTBBYWdlbnQlMjAlM0QlMjBDb2RlQWdlbnQobW9kZWwlM0RIZkFwaU1vZGVsKCklMkMlMjB0b29scyUzRCU1QiU1RCUyQyUyMGV4ZWN1dG9yX3R5cGUlM0QlMjJkb2NrZXIlMjIpJTBBJTBBYWdlbnQucnVuKCUyMkNhbiUyMHlvdSUyMGdpdmUlMjBtZSUyMHRoZSUyMDEwMHRoJTIwRmlib25hY2NpJTIwbnVtYmVyJTNGJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> HfApiModel, CodeAgent

agent = CodeAgent(model=HfApiModel(), tools=[], executor_type=<span class="hljs-string">&quot;docker&quot;</span>)

agent.run(<span class="hljs-string">&quot;Can you give me the 100th Fibonacci number?&quot;</span>)`,wrap:!1}}),Ce=new d({props:{title:"Advanced docker usage",local:"advanced-docker-usage",headingTag:"h4"}}),Be=new x({props:{code:"RlJPTSUyMHB5dGhvbiUzQTMuMTAtYnVsbHNleWUlMEElMEElMjMlMjBJbnN0YWxsJTIwYnVpbGQlMjBkZXBlbmRlbmNpZXMlMEFSVU4lMjBhcHQtZ2V0JTIwdXBkYXRlJTIwJTI2JTI2JTIwJTVDJTBBJTIwJTIwJTIwJTIwYXB0LWdldCUyMGluc3RhbGwlMjAteSUyMC0tbm8taW5zdGFsbC1yZWNvbW1lbmRzJTIwJTVDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYnVpbGQtZXNzZW50aWFsJTIwJTVDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHl0aG9uMy1kZXYlMjAlMjYlMjYlMjAlNUMlMEElMjAlMjAlMjAlMjBwaXAlMjBpbnN0YWxsJTIwLS1uby1jYWNoZS1kaXIlMjAtLXVwZ3JhZGUlMjBwaXAlMjAlMjYlMjYlMjAlNUMlMEElMjAlMjAlMjAlMjBwaXAlMjBpbnN0YWxsJTIwLS1uby1jYWNoZS1kaXIlMjBzbW9sYWdlbnRzJTIwJTI2JTI2JTIwJTVDJTBBJTIwJTIwJTIwJTIwYXB0LWdldCUyMGNsZWFuJTIwJTI2JTI2JTIwJTVDJTBBJTIwJTIwJTIwJTIwcm0lMjAtcmYlMjAlMkZ2YXIlMkZsaWIlMkZhcHQlMkZsaXN0cyUyRiolMEElMEElMjMlMjBTZXQlMjB3b3JraW5nJTIwZGlyZWN0b3J5JTBBV09SS0RJUiUyMCUyRmFwcCUwQSUwQSUyMyUyMFJ1biUyMHdpdGglMjBsaW1pdGVkJTIwcHJpdmlsZWdlcyUwQVVTRVIlMjBub2JvZHklMEElMEElMjMlMjBEZWZhdWx0JTIwY29tbWFuZCUwQUNNRCUyMCU1QiUyMnB5dGhvbiUyMiUyQyUyMCUyMi1jJTIyJTJDJTIwJTIycHJpbnQoJ0NvbnRhaW5lciUyMHJlYWR5JyklMjIlNUQ=",highlighted:`<span class="hljs-keyword">FROM</span> python:<span class="hljs-number">3.10</span>-bullseye

<span class="hljs-comment"># Install build dependencies</span>
<span class="hljs-keyword">RUN</span><span class="language-bash"> apt-get update &amp;&amp; \\
    apt-get install -y --no-install-recommends \\
        build-essential \\
        python3-dev &amp;&amp; \\
    pip install --no-cache-dir --upgrade pip &amp;&amp; \\
    pip install --no-cache-dir smolagents &amp;&amp; \\
    apt-get clean &amp;&amp; \\
    <span class="hljs-built_in">rm</span> -rf /var/lib/apt/lists/*</span>

<span class="hljs-comment"># Set working directory</span>
<span class="hljs-keyword">WORKDIR</span><span class="language-bash"> /app</span>

<span class="hljs-comment"># Run with limited privileges</span>
<span class="hljs-keyword">USER</span> nobody

<span class="hljs-comment"># Default command</span>
<span class="hljs-keyword">CMD</span><span class="language-bash"> [<span class="hljs-string">&quot;python&quot;</span>, <span class="hljs-string">&quot;-c&quot;</span>, <span class="hljs-string">&quot;print(&#x27;Container ready&#x27;)&quot;</span>]</span>`,wrap:!1}}),Ze=new x({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> docker
<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">Optional</span>

<span class="hljs-keyword">class</span> <span class="hljs-title class_">DockerSandbox</span>:
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self</span>):
        self.client = docker.from_env()
        self.container = <span class="hljs-literal">None</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">create_container</span>(<span class="hljs-params">self</span>):
        <span class="hljs-keyword">try</span>:
            image, build_logs = self.client.images.build(
                path=<span class="hljs-string">&quot;.&quot;</span>,
                tag=<span class="hljs-string">&quot;agent-sandbox&quot;</span>,
                rm=<span class="hljs-literal">True</span>,
                forcerm=<span class="hljs-literal">True</span>,
                buildargs={},
                <span class="hljs-comment"># decode=True</span>
            )
        <span class="hljs-keyword">except</span> docker.errors.BuildError <span class="hljs-keyword">as</span> e:
            <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Build error logs:&quot;</span>)
            <span class="hljs-keyword">for</span> log <span class="hljs-keyword">in</span> e.build_log:
                <span class="hljs-keyword">if</span> <span class="hljs-string">&#x27;stream&#x27;</span> <span class="hljs-keyword">in</span> log:
                    <span class="hljs-built_in">print</span>(log[<span class="hljs-string">&#x27;stream&#x27;</span>].strip())
            <span class="hljs-keyword">raise</span>

        <span class="hljs-comment"># Create container with security constraints and proper logging</span>
        self.container = self.client.containers.run(
            <span class="hljs-string">&quot;agent-sandbox&quot;</span>,
            command=<span class="hljs-string">&quot;tail -f /dev/null&quot;</span>,  <span class="hljs-comment"># Keep container running</span>
            detach=<span class="hljs-literal">True</span>,
            tty=<span class="hljs-literal">True</span>,
            mem_limit=<span class="hljs-string">&quot;512m&quot;</span>,
            cpu_quota=<span class="hljs-number">50000</span>,
            pids_limit=<span class="hljs-number">100</span>,
            security_opt=[<span class="hljs-string">&quot;no-new-privileges&quot;</span>],
            cap_drop=[<span class="hljs-string">&quot;ALL&quot;</span>],
            environment={
                <span class="hljs-string">&quot;HF_TOKEN&quot;</span>: os.getenv(<span class="hljs-string">&quot;HF_TOKEN&quot;</span>)
            },
        )

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">run_code</span>(<span class="hljs-params">self, code: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-type">Optional</span>[<span class="hljs-built_in">str</span>]:
        <span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> self.container:
            self.create_container()

        <span class="hljs-comment"># Execute code in container</span>
        exec_result = self.container.exec_run(
            cmd=[<span class="hljs-string">&quot;python&quot;</span>, <span class="hljs-string">&quot;-c&quot;</span>, code],
            user=<span class="hljs-string">&quot;nobody&quot;</span>
        )

        <span class="hljs-comment"># Collect all output</span>
        <span class="hljs-keyword">return</span> exec_result.output.decode() <span class="hljs-keyword">if</span> exec_result.output <span class="hljs-keyword">else</span> <span class="hljs-literal">None</span>


    <span class="hljs-keyword">def</span> <span class="hljs-title function_">cleanup</span>(<span class="hljs-params">self</span>):
        <span class="hljs-keyword">if</span> self.container:
            <span class="hljs-keyword">try</span>:
                self.container.stop()
            <span class="hljs-keyword">except</span> docker.errors.NotFound:
                <span class="hljs-comment"># Container already removed, this is expected</span>
                <span class="hljs-keyword">pass</span>
            <span class="hljs-keyword">except</span> Exception <span class="hljs-keyword">as</span> e:
                <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Error during cleanup: <span class="hljs-subst">{e}</span>&quot;</span>)
            <span class="hljs-keyword">finally</span>:
                self.container = <span class="hljs-literal">None</span>  <span class="hljs-comment"># Clear the reference</span>

<span class="hljs-comment"># Example usage:</span>
sandbox = DockerSandbox()

<span class="hljs-keyword">try</span>:
    <span class="hljs-comment"># Define your agent code</span>
    agent_code = <span class="hljs-string">&quot;&quot;&quot;
import os
from smolagents import CodeAgent, HfApiModel

# Initialize the agent
agent = CodeAgent(
    model=HfApiModel(token=os.getenv(&quot;HF_TOKEN&quot;), provider=&quot;together&quot;),
    tools=[]
)

# Run the agent
response = agent.run(&quot;What&#x27;s the 20th Fibonacci number?&quot;)
print(response)
&quot;&quot;&quot;</span>

    <span class="hljs-comment"># Run the code in the sandbox</span>
    output = sandbox.run_code(agent_code)
    <span class="hljs-built_in">print</span>(output)

<span class="hljs-keyword">finally</span>:
    sandbox.cleanup()`,wrap:!1}}),ke=new d({props:{title:"Best practices for sandboxes",local:"best-practices-for-sandboxes",headingTag:"h3"}}),Ee=new d({props:{title:"Comparing security approaches",local:"comparing-security-approaches",headingTag:"h2"}}),Re=new d({props:{title:"Approach 1: Running just the code snippets in a sandbox",local:"approach-1-running-just-the-code-snippets-in-a-sandbox",headingTag:"h3"}}),Se=new d({props:{title:"Approach 2: Running the entire agentic system in a sandbox",local:"approach-2-running-the-entire-agentic-system-in-a-sandbox",headingTag:"h3"}}),Qe=new ms({props:{source:"https://github.com/huggingface/smolagents/blob/main/docs/source/en/tutorials/secure_code_execution.mdx"}}),{c(){w=i("meta"),j=n(),m=i("p"),h=n(),p(I.$$.fragment),g=n(),p(U.$$.fragment),B=n(),p(T.$$.fragment),b=n(),p(v.$$.fragment),qe=n(),Z=i("p"),Z.innerHTML=yl,Le=n(),k=i("p"),k.textContent=Jl,Pe=n(),A=i("p"),A.textContent=wl,De=n(),W=i("ul"),W.innerHTML=Tl,Ke=n(),G=i("p"),G.innerHTML=dl,Oe=n(),Ye=i("img"),et=n(),E=i("p"),E.textContent=Ul,tt=n(),p($.$$.fragment),lt=n(),R=i("p"),R.innerHTML=hl,st=n(),V=i("p"),V.textContent=jl,nt=n(),S=i("p"),S.textContent=Il,at=n(),_=i("ul"),_.innerHTML=bl,it=n(),N=i("p"),N.innerHTML=gl,ot=n(),Q=i("p"),Q.textContent=Cl,Mt=n(),H=i("p"),H.textContent=fl,pt=n(),Y=i("p"),Y.textContent=xl,rt=n(),Xe=i("img"),ct=n(),p(X.$$.fragment),ut=n(),F=i("p"),F.innerHTML=vl,yt=n(),z=i("p"),z.textContent=Zl,Jt=n(),q=i("ul"),q.innerHTML=kl,wt=n(),L=i("p"),L.textContent=Al,Tt=n(),p(P.$$.fragment),dt=n(),D=i("p"),D.textContent=Wl,mt=n(),p(C.$$.fragment),Ut=n(),K=i("p"),K.textContent=Gl,ht=n(),p(O.$$.fragment),jt=n(),ee=i("p"),ee.textContent=El,It=n(),te=i("p"),te.innerHTML=$l,bt=n(),le=i("ol"),le.innerHTML=Rl,gt=n(),se=i("p"),se.textContent=Vl,Ct=n(),p(ne.$$.fragment),ft=n(),p(ae.$$.fragment),xt=n(),ie=i("ol"),ie.innerHTML=Sl,Bt=n(),p(oe.$$.fragment),vt=n(),p(Me.$$.fragment),Zt=n(),pe=i("p"),pe.innerHTML=_l,kt=n(),p(re.$$.fragment),At=n(),ce=i("p"),ce.innerHTML=Nl,Wt=n(),ue=i("p"),ue.textContent=Ql,Gt=n(),f=i("p"),f.innerHTML=Hl,Et=n(),ye=i("p"),ye.innerHTML=Yl,$t=n(),p(Je.$$.fragment),Rt=n(),we=i("p"),we.textContent=Xl,Vt=n(),Te=i("p"),Te.textContent=Fl,St=n(),p(de.$$.fragment),_t=n(),p(me.$$.fragment),Nt=n(),p(Ue.$$.fragment),Qt=n(),he=i("ol"),he.innerHTML=zl,Ht=n(),p(je.$$.fragment),Yt=n(),p(Ie.$$.fragment),Xt=n(),be=i("p"),be.innerHTML=ql,Ft=n(),p(ge.$$.fragment),zt=n(),p(Ce.$$.fragment),qt=n(),fe=i("p"),fe.textContent=Ll,Lt=n(),xe=i("p"),xe.textContent=Pl,Pt=n(),p(Be.$$.fragment),Dt=n(),ve=i("p"),ve.textContent=Dl,Kt=n(),p(Ze.$$.fragment),Ot=n(),p(ke.$$.fragment),el=n(),Ae=i("p"),Ae.textContent=Kl,tl=n(),We=i("ul"),We.innerHTML=Ol,ll=n(),Ge=i("p"),Ge.textContent=es,sl=n(),p(Ee.$$.fragment),nl=n(),$e=i("p"),$e.textContent=ts,al=n(),p(Re.$$.fragment),il=n(),Ve=i("ul"),Ve.innerHTML=ls,ol=n(),p(Se.$$.fragment),Ml=n(),_e=i("ul"),_e.innerHTML=ss,pl=n(),Ne=i("p"),Ne.textContent=ns,rl=n(),p(Qe.$$.fragment),cl=n(),Fe=i("p"),this.h()},l(e){const t=ws("svelte-u9bgzb",document.head);w=o(t,"META",{name:!0,content:!0}),t.forEach(l),j=a(e),m=o(e,"P",{}),Ms(m).forEach(l),h=a(e),r(I.$$.fragment,e),g=a(e),r(U.$$.fragment,e),B=a(e),r(T.$$.fragment,e),b=a(e),r(v.$$.fragment,e),qe=a(e),Z=o(e,"P",{"data-svelte-h":!0}),M(Z)!=="svelte-1nor5c0"&&(Z.innerHTML=yl),Le=a(e),k=o(e,"P",{"data-svelte-h":!0}),M(k)!=="svelte-1b2f48c"&&(k.textContent=Jl),Pe=a(e),A=o(e,"P",{"data-svelte-h":!0}),M(A)!=="svelte-1jp5kiv"&&(A.textContent=wl),De=a(e),W=o(e,"UL",{"data-svelte-h":!0}),M(W)!=="svelte-a7ou7n"&&(W.innerHTML=Tl),Ke=a(e),G=o(e,"P",{"data-svelte-h":!0}),M(G)!=="svelte-1ugtxvn"&&(G.innerHTML=dl),Oe=a(e),Ye=o(e,"IMG",{src:!0}),et=a(e),E=o(e,"P",{"data-svelte-h":!0}),M(E)!=="svelte-1lbgv3o"&&(E.textContent=Ul),tt=a(e),r($.$$.fragment,e),lt=a(e),R=o(e,"P",{"data-svelte-h":!0}),M(R)!=="svelte-19p3p3d"&&(R.innerHTML=hl),st=a(e),V=o(e,"P",{"data-svelte-h":!0}),M(V)!=="svelte-y55i8i"&&(V.textContent=jl),nt=a(e),S=o(e,"P",{"data-svelte-h":!0}),M(S)!=="svelte-y4kupg"&&(S.textContent=Il),at=a(e),_=o(e,"UL",{"data-svelte-h":!0}),M(_)!=="svelte-1b6z7ic"&&(_.innerHTML=bl),it=a(e),N=o(e,"P",{"data-svelte-h":!0}),M(N)!=="svelte-uopq3c"&&(N.innerHTML=gl),ot=a(e),Q=o(e,"P",{"data-svelte-h":!0}),M(Q)!=="svelte-gfolx1"&&(Q.textContent=Cl),Mt=a(e),H=o(e,"P",{"data-svelte-h":!0}),M(H)!=="svelte-1j1i1cv"&&(H.textContent=fl),pt=a(e),Y=o(e,"P",{"data-svelte-h":!0}),M(Y)!=="svelte-1ghwkh9"&&(Y.textContent=xl),rt=a(e),Xe=o(e,"IMG",{src:!0}),ct=a(e),r(X.$$.fragment,e),ut=a(e),F=o(e,"P",{"data-svelte-h":!0}),M(F)!=="svelte-845rka"&&(F.innerHTML=vl),yt=a(e),z=o(e,"P",{"data-svelte-h":!0}),M(z)!=="svelte-180snho"&&(z.textContent=Zl),Jt=a(e),q=o(e,"UL",{"data-svelte-h":!0}),M(q)!=="svelte-19qb8ke"&&(q.innerHTML=kl),wt=a(e),L=o(e,"P",{"data-svelte-h":!0}),M(L)!=="svelte-1wz8jbt"&&(L.textContent=Al),Tt=a(e),r(P.$$.fragment,e),dt=a(e),D=o(e,"P",{"data-svelte-h":!0}),M(D)!=="svelte-1gk7uki"&&(D.textContent=Wl),mt=a(e),r(C.$$.fragment,e),Ut=a(e),K=o(e,"P",{"data-svelte-h":!0}),M(K)!=="svelte-whkli4"&&(K.textContent=Gl),ht=a(e),r(O.$$.fragment,e),jt=a(e),ee=o(e,"P",{"data-svelte-h":!0}),M(ee)!=="svelte-grnb59"&&(ee.textContent=El),It=a(e),te=o(e,"P",{"data-svelte-h":!0}),M(te)!=="svelte-ahtq0i"&&(te.innerHTML=$l),bt=a(e),le=o(e,"OL",{"data-svelte-h":!0}),M(le)!=="svelte-1vlvy45"&&(le.innerHTML=Rl),gt=a(e),se=o(e,"P",{"data-svelte-h":!0}),M(se)!=="svelte-1h3g1zs"&&(se.textContent=Vl),Ct=a(e),r(ne.$$.fragment,e),ft=a(e),r(ae.$$.fragment,e),xt=a(e),ie=o(e,"OL",{"data-svelte-h":!0}),M(ie)!=="svelte-uvtwg2"&&(ie.innerHTML=Sl),Bt=a(e),r(oe.$$.fragment,e),vt=a(e),r(Me.$$.fragment,e),Zt=a(e),pe=o(e,"P",{"data-svelte-h":!0}),M(pe)!=="svelte-r3242t"&&(pe.innerHTML=_l),kt=a(e),r(re.$$.fragment,e),At=a(e),ce=o(e,"P",{"data-svelte-h":!0}),M(ce)!=="svelte-jrgx8f"&&(ce.innerHTML=Nl),Wt=a(e),ue=o(e,"P",{"data-svelte-h":!0}),M(ue)!=="svelte-8sir7q"&&(ue.textContent=Ql),Gt=a(e),f=o(e,"P",{align:!0,"data-svelte-h":!0}),M(f)!=="svelte-11rtdvt"&&(f.innerHTML=Hl),Et=a(e),ye=o(e,"P",{"data-svelte-h":!0}),M(ye)!=="svelte-ofpo9r"&&(ye.innerHTML=Yl),$t=a(e),r(Je.$$.fragment,e),Rt=a(e),we=o(e,"P",{"data-svelte-h":!0}),M(we)!=="svelte-geglm0"&&(we.textContent=Xl),Vt=a(e),Te=o(e,"P",{"data-svelte-h":!0}),M(Te)!=="svelte-1iycphr"&&(Te.textContent=Fl),St=a(e),r(de.$$.fragment,e),_t=a(e),r(me.$$.fragment,e),Nt=a(e),r(Ue.$$.fragment,e),Qt=a(e),he=o(e,"OL",{"data-svelte-h":!0}),M(he)!=="svelte-19h0avy"&&(he.innerHTML=zl),Ht=a(e),r(je.$$.fragment,e),Yt=a(e),r(Ie.$$.fragment,e),Xt=a(e),be=o(e,"P",{"data-svelte-h":!0}),M(be)!=="svelte-1j9zoi1"&&(be.innerHTML=ql),Ft=a(e),r(ge.$$.fragment,e),zt=a(e),r(Ce.$$.fragment,e),qt=a(e),fe=o(e,"P",{"data-svelte-h":!0}),M(fe)!=="svelte-t1it0d"&&(fe.textContent=Ll),Lt=a(e),xe=o(e,"P",{"data-svelte-h":!0}),M(xe)!=="svelte-1lygj8"&&(xe.textContent=Pl),Pt=a(e),r(Be.$$.fragment,e),Dt=a(e),ve=o(e,"P",{"data-svelte-h":!0}),M(ve)!=="svelte-8mtm8c"&&(ve.textContent=Dl),Kt=a(e),r(Ze.$$.fragment,e),Ot=a(e),r(ke.$$.fragment,e),el=a(e),Ae=o(e,"P",{"data-svelte-h":!0}),M(Ae)!=="svelte-5fyo5r"&&(Ae.textContent=Kl),tl=a(e),We=o(e,"UL",{"data-svelte-h":!0}),M(We)!=="svelte-162p62u"&&(We.innerHTML=Ol),ll=a(e),Ge=o(e,"P",{"data-svelte-h":!0}),M(Ge)!=="svelte-1hbg2e4"&&(Ge.textContent=es),sl=a(e),r(Ee.$$.fragment,e),nl=a(e),$e=o(e,"P",{"data-svelte-h":!0}),M($e)!=="svelte-i4top7"&&($e.textContent=ts),al=a(e),r(Re.$$.fragment,e),il=a(e),Ve=o(e,"UL",{"data-svelte-h":!0}),M(Ve)!=="svelte-8oe7h4"&&(Ve.innerHTML=ls),ol=a(e),r(Se.$$.fragment,e),Ml=a(e),_e=o(e,"UL",{"data-svelte-h":!0}),M(_e)!=="svelte-1nt0hab"&&(_e.innerHTML=ss),pl=a(e),Ne=o(e,"P",{"data-svelte-h":!0}),M(Ne)!=="svelte-l1ns7z"&&(Ne.textContent=ns),rl=a(e),r(Qe.$$.fragment,e),cl=a(e),Fe=o(e,"P",{}),Ms(Fe).forEach(l),this.h()},h(){ze(w,"name","hf:doc:metadata"),ze(w,"content",Is),os(Ye.src,ml="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/code_vs_json_actions.png")||ze(Ye,"src",ml),os(Xe.src,Bl="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/smolagents/code_execution_safety_diagram.png")||ze(Xe,"src",Bl),ze(f,"align","center")},m(e,t){Ts(document.head,w),s(e,j,t),s(e,m,t),s(e,h,t),c(I,e,t),s(e,g,t),c(U,e,t),s(e,B,t),c(T,e,t),s(e,b,t),c(v,e,t),s(e,qe,t),s(e,Z,t),s(e,Le,t),s(e,k,t),s(e,Pe,t),s(e,A,t),s(e,De,t),s(e,W,t),s(e,Ke,t),s(e,G,t),s(e,Oe,t),s(e,Ye,t),s(e,et,t),s(e,E,t),s(e,tt,t),c($,e,t),s(e,lt,t),s(e,R,t),s(e,st,t),s(e,V,t),s(e,nt,t),s(e,S,t),s(e,at,t),s(e,_,t),s(e,it,t),s(e,N,t),s(e,ot,t),s(e,Q,t),s(e,Mt,t),s(e,H,t),s(e,pt,t),s(e,Y,t),s(e,rt,t),s(e,Xe,t),s(e,ct,t),c(X,e,t),s(e,ut,t),s(e,F,t),s(e,yt,t),s(e,z,t),s(e,Jt,t),s(e,q,t),s(e,wt,t),s(e,L,t),s(e,Tt,t),c(P,e,t),s(e,dt,t),s(e,D,t),s(e,mt,t),c(C,e,t),s(e,Ut,t),s(e,K,t),s(e,ht,t),c(O,e,t),s(e,jt,t),s(e,ee,t),s(e,It,t),s(e,te,t),s(e,bt,t),s(e,le,t),s(e,gt,t),s(e,se,t),s(e,Ct,t),c(ne,e,t),s(e,ft,t),c(ae,e,t),s(e,xt,t),s(e,ie,t),s(e,Bt,t),c(oe,e,t),s(e,vt,t),c(Me,e,t),s(e,Zt,t),s(e,pe,t),s(e,kt,t),c(re,e,t),s(e,At,t),s(e,ce,t),s(e,Wt,t),s(e,ue,t),s(e,Gt,t),s(e,f,t),s(e,Et,t),s(e,ye,t),s(e,$t,t),c(Je,e,t),s(e,Rt,t),s(e,we,t),s(e,Vt,t),s(e,Te,t),s(e,St,t),c(de,e,t),s(e,_t,t),c(me,e,t),s(e,Nt,t),c(Ue,e,t),s(e,Qt,t),s(e,he,t),s(e,Ht,t),c(je,e,t),s(e,Yt,t),c(Ie,e,t),s(e,Xt,t),s(e,be,t),s(e,Ft,t),c(ge,e,t),s(e,zt,t),c(Ce,e,t),s(e,qt,t),s(e,fe,t),s(e,Lt,t),s(e,xe,t),s(e,Pt,t),c(Be,e,t),s(e,Dt,t),s(e,ve,t),s(e,Kt,t),c(Ze,e,t),s(e,Ot,t),c(ke,e,t),s(e,el,t),s(e,Ae,t),s(e,tl,t),s(e,We,t),s(e,ll,t),s(e,Ge,t),s(e,sl,t),c(Ee,e,t),s(e,nl,t),s(e,$e,t),s(e,al,t),c(Re,e,t),s(e,il,t),s(e,Ve,t),s(e,ol,t),c(Se,e,t),s(e,Ml,t),s(e,_e,t),s(e,pl,t),s(e,Ne,t),s(e,rl,t),c(Qe,e,t),s(e,cl,t),s(e,Fe,t),ul=!0},p(e,[t]){const as={};t&2&&(as.$$scope={dirty:t,ctx:e}),T.$set(as);const is={};t&2&&(is.$$scope={dirty:t,ctx:e}),C.$set(is)},i(e){ul||(u(I.$$.fragment,e),u(U.$$.fragment,e),u(T.$$.fragment,e),u(v.$$.fragment,e),u($.$$.fragment,e),u(X.$$.fragment,e),u(P.$$.fragment,e),u(C.$$.fragment,e),u(O.$$.fragment,e),u(ne.$$.fragment,e),u(ae.$$.fragment,e),u(oe.$$.fragment,e),u(Me.$$.fragment,e),u(re.$$.fragment,e),u(Je.$$.fragment,e),u(de.$$.fragment,e),u(me.$$.fragment,e),u(Ue.$$.fragment,e),u(je.$$.fragment,e),u(Ie.$$.fragment,e),u(ge.$$.fragment,e),u(Ce.$$.fragment,e),u(Be.$$.fragment,e),u(Ze.$$.fragment,e),u(ke.$$.fragment,e),u(Ee.$$.fragment,e),u(Re.$$.fragment,e),u(Se.$$.fragment,e),u(Qe.$$.fragment,e),ul=!0)},o(e){y(I.$$.fragment,e),y(U.$$.fragment,e),y(T.$$.fragment,e),y(v.$$.fragment,e),y($.$$.fragment,e),y(X.$$.fragment,e),y(P.$$.fragment,e),y(C.$$.fragment,e),y(O.$$.fragment,e),y(ne.$$.fragment,e),y(ae.$$.fragment,e),y(oe.$$.fragment,e),y(Me.$$.fragment,e),y(re.$$.fragment,e),y(Je.$$.fragment,e),y(de.$$.fragment,e),y(me.$$.fragment,e),y(Ue.$$.fragment,e),y(je.$$.fragment,e),y(Ie.$$.fragment,e),y(ge.$$.fragment,e),y(Ce.$$.fragment,e),y(Be.$$.fragment,e),y(Ze.$$.fragment,e),y(ke.$$.fragment,e),y(Ee.$$.fragment,e),y(Re.$$.fragment,e),y(Se.$$.fragment,e),y(Qe.$$.fragment,e),ul=!1},d(e){e&&(l(j),l(m),l(h),l(g),l(B),l(b),l(qe),l(Z),l(Le),l(k),l(Pe),l(A),l(De),l(W),l(Ke),l(G),l(Oe),l(Ye),l(et),l(E),l(tt),l(lt),l(R),l(st),l(V),l(nt),l(S),l(at),l(_),l(it),l(N),l(ot),l(Q),l(Mt),l(H),l(pt),l(Y),l(rt),l(Xe),l(ct),l(ut),l(F),l(yt),l(z),l(Jt),l(q),l(wt),l(L),l(Tt),l(dt),l(D),l(mt),l(Ut),l(K),l(ht),l(jt),l(ee),l(It),l(te),l(bt),l(le),l(gt),l(se),l(Ct),l(ft),l(xt),l(ie),l(Bt),l(vt),l(Zt),l(pe),l(kt),l(At),l(ce),l(Wt),l(ue),l(Gt),l(f),l(Et),l(ye),l($t),l(Rt),l(we),l(Vt),l(Te),l(St),l(_t),l(Nt),l(Qt),l(he),l(Ht),l(Yt),l(Xt),l(be),l(Ft),l(zt),l(qt),l(fe),l(Lt),l(xe),l(Pt),l(Dt),l(ve),l(Kt),l(Ot),l(el),l(Ae),l(tl),l(We),l(ll),l(Ge),l(sl),l(nl),l($e),l(al),l(il),l(Ve),l(ol),l(Ml),l(_e),l(pl),l(Ne),l(rl),l(cl),l(Fe)),l(w),J(I,e),J(U,e),J(T,e),J(v,e),J($,e),J(X,e),J(P,e),J(C,e),J(O,e),J(ne,e),J(ae,e),J(oe,e),J(Me,e),J(re,e),J(Je,e),J(de,e),J(me,e),J(Ue,e),J(je,e),J(Ie,e),J(ge,e),J(Ce,e),J(Be,e),J(Ze,e),J(ke,e),J(Ee,e),J(Re,e),J(Se,e),J(Qe,e)}}}const Is='{"title":"Secure code execution","local":"secure-code-execution","sections":[{"title":"Code agents","local":"code-agents","sections":[],"depth":3},{"title":"Local code execution??","local":"local-code-execution","sections":[],"depth":3},{"title":"Our local Python executor","local":"our-local-python-executor","sections":[],"depth":3},{"title":"Sandbox approaches for secure code execution","local":"sandbox-approaches-for-secure-code-execution","sections":[{"title":"E2B setup","local":"e2b-setup","sections":[{"title":"Installation","local":"installation","sections":[],"depth":4},{"title":"Running your agent in E2B: quick start","local":"running-your-agent-in-e2b-quick-start","sections":[],"depth":4},{"title":"Running your agent in E2B: multi-agents","local":"running-your-agent-in-e2b-multi-agents","sections":[],"depth":4}],"depth":3},{"title":"Docker setup","local":"docker-setup","sections":[{"title":"Installation","local":"installation","sections":[],"depth":4},{"title":"Running your agent in E2B: quick start","local":"running-your-agent-in-e2b-quick-start","sections":[],"depth":4},{"title":"Advanced docker usage","local":"advanced-docker-usage","sections":[],"depth":4}],"depth":3},{"title":"Best practices for sandboxes","local":"best-practices-for-sandboxes","sections":[],"depth":3}],"depth":2},{"title":"Comparing security approaches","local":"comparing-security-approaches","sections":[{"title":"Approach 1: Running just the code snippets in a sandbox","local":"approach-1-running-just-the-code-snippets-in-a-sandbox","sections":[],"depth":3},{"title":"Approach 2: Running the entire agentic system in a sandbox","local":"approach-2-running-the-entire-agentic-system-in-a-sandbox","sections":[],"depth":3}],"depth":2}],"depth":1}';function bs(He){return us(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Zs extends ys{constructor(w){super(),Js(this,w,bs,js,cs,{})}}export{Zs as component};
