import{s as Ln,o as Nn,n as S}from"../chunks/scheduler.f6319a2a.js";import{S as En,i as Zn,g as r,s as o,r as g,A as Bn,h as i,f as s,c as l,j as A,u,x as p,k as q,y as c,a as n,v as M,d as f,t as h,w as y}from"../chunks/index.85aa684c.js";import{T as vt}from"../chunks/Tip.3d397a88.js";import{D as E,E as Fs}from"../chunks/ExampleCodeBlock.1ef72b4f.js";import{C as j}from"../chunks/CodeBlock.3400fc53.js";import{H as Z,E as Wn}from"../chunks/index.9e1e6fd7.js";function Qn($){let a,_=`Smolagents is an experimental API which is subject to change at any time. Results returned by the agents
can vary as the APIs or underlying models are prone to change.`;return{c(){a=r("p"),a.textContent=_},l(d){a=i(d,"P",{"data-svelte-h":!0}),p(a)!=="svelte-19v5hvw"&&(a.textContent=_)},m(d,v){n(d,a,v)},p:S,d(d){d&&s(a)}}}function zn($){let a,_="You must have <code>transformers</code> and <code>torch</code> installed on your machine. Please run <code>pip install smolagents[transformers]</code> if it’s not the case.";return{c(){a=r("p"),a.innerHTML=_},l(d){a=i(d,"P",{"data-svelte-h":!0}),p(a)!=="svelte-1tclttn"&&(a.innerHTML=_)},m(d,v){n(d,a,v)},p:S,d(d){d&&s(a)}}}function Sn($){let a,_="You must have <code>transformers</code> and <code>torch</code> installed on your machine. Please run <code>pip install smolagents[transformers]</code> if it’s not the case.";return{c(){a=r("p"),a.innerHTML=_},l(d){a=i(d,"P",{"data-svelte-h":!0}),p(a)!=="svelte-1tclttn"&&(a.innerHTML=_)},m(d,v){n(d,a,v)},p:S,d(d){d&&s(a)}}}function Hn($){let a,_="Example:",d,v,b;return v=new j({props:{code:"ZW5naW5lJTIwJTNEJTIwVHJhbnNmb3JtZXJzTW9kZWwoJTBBJTIwJTIwJTIwJTIwbW9kZWxfaWQlM0QlMjJRd2VuJTJGUXdlbjIuNS1Db2Rlci0zMkItSW5zdHJ1Y3QlMjIlMkMlMEElMjAlMjAlMjAlMjBkZXZpY2UlM0QlMjJjdWRhJTIyJTJDJTBBJTIwJTIwJTIwJTIwbWF4X25ld190b2tlbnMlM0Q1MDAwJTJDJTBBKSUwQW1lc3NhZ2VzJTIwJTNEJTIwJTVCJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyRXhwbGFpbiUyMHF1YW50dW0lMjBtZWNoYW5pY3MlMjBpbiUyMHNpbXBsZSUyMHRlcm1zLiUyMiU3RCU1RCUwQXJlc3BvbnNlJTIwJTNEJTIwZW5naW5lKG1lc3NhZ2VzJTJDJTIwc3RvcF9zZXF1ZW5jZXMlM0QlNUIlMjJFTkQlMjIlNUQpJTBBcHJpbnQocmVzcG9uc2Up",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>engine = TransformersModel(
<span class="hljs-meta">... </span>    model_id=<span class="hljs-string">&quot;Qwen/Qwen2.5-Coder-32B-Instruct&quot;</span>,
<span class="hljs-meta">... </span>    device=<span class="hljs-string">&quot;cuda&quot;</span>,
<span class="hljs-meta">... </span>    max_new_tokens=<span class="hljs-number">5000</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>messages = [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Explain quantum mechanics in simple terms.&quot;</span>}]
<span class="hljs-meta">&gt;&gt;&gt; </span>response = engine(messages, stop_sequences=[<span class="hljs-string">&quot;END&quot;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(response)
<span class="hljs-string">&quot;Quantum mechanics is the branch of physics that studies...&quot;</span>`,wrap:!1}}),{c(){a=r("p"),a.textContent=_,d=o(),g(v.$$.fragment)},l(m){a=i(m,"P",{"data-svelte-h":!0}),p(a)!=="svelte-11lpom8"&&(a.textContent=_),d=l(m),u(v.$$.fragment,m)},m(m,J){n(m,a,J),n(m,d,J),M(v,m,J),b=!0},p:S,i(m){b||(f(v.$$.fragment,m),b=!0)},o(m){h(v.$$.fragment,m),b=!1},d(m){m&&(s(a),s(d)),y(v,m)}}}function Vn($){let a,_="Example:",d,v,b;return v=new j({props:{code:"ZW5naW5lJTIwJTNEJTIwSGZBcGlNb2RlbCglMEElMjAlMjAlMjAlMjBtb2RlbF9pZCUzRCUyMlF3ZW4lMkZRd2VuMi41LUNvZGVyLTMyQi1JbnN0cnVjdCUyMiUyQyUwQSUyMCUyMCUyMCUyMHByb3ZpZGVyJTNEJTIydG9nZXRoZXIlMjIlMkMlMEElMjAlMjAlMjAlMjB0b2tlbiUzRCUyMnlvdXJfaGZfdG9rZW5faGVyZSUyMiUyQyUwQSUyMCUyMCUyMCUyMG1heF90b2tlbnMlM0Q1MDAwJTJDJTBBKSUwQW1lc3NhZ2VzJTIwJTNEJTIwJTVCJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyRXhwbGFpbiUyMHF1YW50dW0lMjBtZWNoYW5pY3MlMjBpbiUyMHNpbXBsZSUyMHRlcm1zLiUyMiU3RCU1RCUwQXJlc3BvbnNlJTIwJTNEJTIwZW5naW5lKG1lc3NhZ2VzJTJDJTIwc3RvcF9zZXF1ZW5jZXMlM0QlNUIlMjJFTkQlMjIlNUQpJTBBcHJpbnQocmVzcG9uc2Up",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>engine = HfApiModel(
<span class="hljs-meta">... </span>    model_id=<span class="hljs-string">&quot;Qwen/Qwen2.5-Coder-32B-Instruct&quot;</span>,
<span class="hljs-meta">... </span>    provider=<span class="hljs-string">&quot;together&quot;</span>,
<span class="hljs-meta">... </span>    token=<span class="hljs-string">&quot;your_hf_token_here&quot;</span>,
<span class="hljs-meta">... </span>    max_tokens=<span class="hljs-number">5000</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>messages = [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Explain quantum mechanics in simple terms.&quot;</span>}]
<span class="hljs-meta">&gt;&gt;&gt; </span>response = engine(messages, stop_sequences=[<span class="hljs-string">&quot;END&quot;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(response)
<span class="hljs-string">&quot;Quantum mechanics is the branch of physics that studies...&quot;</span>`,wrap:!1}}),{c(){a=r("p"),a.textContent=_,d=o(),g(v.$$.fragment)},l(m){a=i(m,"P",{"data-svelte-h":!0}),p(a)!=="svelte-11lpom8"&&(a.textContent=_),d=l(m),u(v.$$.fragment,m)},m(m,J){n(m,a,J),n(m,d,J),M(v,m,J),b=!0},p:S,i(m){b||(f(v.$$.fragment,m),b=!0)},o(m){h(v.$$.fragment,m),b=!1},d(m){m&&(s(a),s(d)),y(v,m)}}}function Rn($){let a,_="You must have <code>mlx-lm</code> installed on your machine. Please run <code>pip install smolagents[mlx-lm]</code> if it’s not the case.";return{c(){a=r("p"),a.innerHTML=_},l(d){a=i(d,"P",{"data-svelte-h":!0}),p(a)!=="svelte-g382or"&&(a.innerHTML=_)},m(d,v){n(d,a,v)},p:S,d(d){d&&s(a)}}}function Xn($){let a,_="You must have <code>mlx-lm</code> installed on your machine. Please run <code>pip install smolagents[mlx-lm]</code> if it’s not the case.";return{c(){a=r("p"),a.innerHTML=_},l(d){a=i(d,"P",{"data-svelte-h":!0}),p(a)!=="svelte-g382or"&&(a.innerHTML=_)},m(d,v){n(d,a,v)},p:S,d(d){d&&s(a)}}}function Pn($){let a,_="Example:",d,v,b;return v=new j({props:{code:"ZW5naW5lJTIwJTNEJTIwTUxYTW9kZWwoJTBBJTIwJTIwJTIwJTIwbW9kZWxfaWQlM0QlMjJtbHgtY29tbXVuaXR5JTJGUXdlbjIuNS1Db2Rlci0zMkItSW5zdHJ1Y3QtNGJpdCUyMiUyQyUwQSUyMCUyMCUyMCUyMG1heF90b2tlbnMlM0QxMDAwMCUyQyUwQSklMEFtZXNzYWdlcyUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyY29udGVudCUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUyMnR5cGUlMjIlM0ElMjAlMjJ0ZXh0JTIyJTJDJTIwJTIydGV4dCUyMiUzQSUyMCUyMkV4cGxhaW4lMjBxdWFudHVtJTIwbWVjaGFuaWNzJTIwaW4lMjBzaW1wbGUlMjB0ZXJtcy4lMjIlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUQlMEElMjAlMjAlMjAlMjAlN0QlMEElNUQlMEFyZXNwb25zZSUyMCUzRCUyMGVuZ2luZShtZXNzYWdlcyUyQyUyMHN0b3Bfc2VxdWVuY2VzJTNEJTVCJTIyRU5EJTIyJTVEKSUwQXByaW50KHJlc3BvbnNlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>engine = MLXModel(
<span class="hljs-meta">... </span>    model_id=<span class="hljs-string">&quot;mlx-community/Qwen2.5-Coder-32B-Instruct-4bit&quot;</span>,
<span class="hljs-meta">... </span>    max_tokens=<span class="hljs-number">10000</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>messages = [
<span class="hljs-meta">... </span>    {
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;content&quot;</span>: [
<span class="hljs-meta">... </span>            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;Explain quantum mechanics in simple terms.&quot;</span>}
<span class="hljs-meta">... </span>        ]
<span class="hljs-meta">... </span>    }
<span class="hljs-meta">... </span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>response = engine(messages, stop_sequences=[<span class="hljs-string">&quot;END&quot;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(response)
<span class="hljs-string">&quot;Quantum mechanics is the branch of physics that studies...&quot;</span>`,wrap:!1}}),{c(){a=r("p"),a.textContent=_,d=o(),g(v.$$.fragment)},l(m){a=i(m,"P",{"data-svelte-h":!0}),p(a)!=="svelte-11lpom8"&&(a.textContent=_),d=l(m),u(v.$$.fragment,m)},m(m,J){n(m,a,J),n(m,d,J),M(v,m,J),b=!0},p:S,i(m){b||(f(v.$$.fragment,m),b=!0)},o(m){h(v.$$.fragment,m),b=!1},d(m){m&&(s(a),s(d)),y(v,m)}}}function Fn($){let a,_="You must have <code>vllm</code> installed on your machine. Please run <code>pip install smolagents[vllm]</code> if it’s not the case.";return{c(){a=r("p"),a.innerHTML=_},l(d){a=i(d,"P",{"data-svelte-h":!0}),p(a)!=="svelte-1r5rtu3"&&(a.innerHTML=_)},m(d,v){n(d,a,v)},p:S,d(d){d&&s(a)}}}function On($){let a,_,d,v,b,m,J,Tt,K,Os=`To learn more about agents and tools make sure to read the <a href="../index">introductory guide</a>. This page
contains the API docs for the underlying classes.`,wt,ee,bt,te,Gs="You’re free to create and use your own models to power your agent.",$t,se,Ds="You could use any <code>model</code> callable for your agent, as long as:",Jt,ne,Ys='<li>It follows the <a href="./chat_templating">messages format</a> (<code>List[Dict[str, str]]</code>) for its input <code>messages</code>, and it returns a <code>str</code>.</li> <li>It stops generating outputs <em>before</em> the sequences passed in the argument <code>stop_sequences</code></li>',Ut,oe,Ks='For defining your LLM, you can make a <code>custom_model</code> method which accepts a list of <a href="./chat_templating">messages</a> and returns an object with a .content attribute containing the text. This callable also needs to accept a <code>stop_sequences</code> argument that indicates when to stop generating.',It,le,kt,ae,en='Additionally, <code>custom_model</code> can also take a <code>grammar</code> argument. In the case where you specify a <code>grammar</code> upon agent initialization, this argument will be passed to the calls to model, with the <code>grammar</code> that you defined upon initialization, to allow <a href="https://huggingface.co/docs/text-generation-inference/conceptual/guidance" rel="nofollow">constrained generation</a> in order to force properly-formatted agent outputs.',jt,re,Ct,ie,tn="For convenience, we have added a <code>TransformersModel</code> that implements the points above by building a local <code>transformers</code> pipeline for the model_id given at initialization.",xt,de,At,ce,qt,H,Lt,I,me,vs,De,sn="A class that uses Hugging Face’s Transformers library for language model interaction.",_s,Ye,nn="This model allows you to load and use Hugging Face’s models locally using the Transformers library. It supports features like stop sequences and grammar customization.",Ts,V,ws,R,Nt,pe,Et,ge,on='The <code>HfApiModel</code> wraps huggingface_hub’s <a href="https://huggingface.co/docs/huggingface_hub/main/en/guides/inference" rel="nofollow">InferenceClient</a> for the execution of the LLM. It supports all <a href="https://huggingface.co/docs/inference-providers/index" rel="nofollow">Inference Providers</a> available on the Hub: Cerebras, Cohere, Fal, Fireworks, HF-Inference, Hyperbolic, Nebius, Novita, Replicate, SambaNova, Together, and more.',Zt,ue,Bt,Me,Wt,U,fe,bs,Ke,ln="A class to interact with Hugging Face’s Inference Providers for language model interaction.",$s,et,an="This model allows you to communicate with Hugging Face’s models using Inference Providers. It can be used in both serverless mode or with a dedicated endpoint, supporting features like stop sequences and grammar customization.",Js,tt,rn="Providers include Cerebras, Cohere, Fal, Fireworks, HF-Inference, Hyperbolic, Nebius, Novita, Replicate, SambaNova, Together, and more.",Us,X,Is,P,he,ks,st,dn="Create the Hugging Face client.",Qt,ye,zt,ve,cn=`The <code>LiteLLMModel</code> leverages <a href="https://www.litellm.ai/" rel="nofollow">LiteLLM</a> to support 100+ LLMs from various providers.
You can pass kwargs upon model initialization that will then be used whenever using the model, for instance below we pass <code>temperature</code>.`,St,_e,Ht,L,Te,js,nt,mn='Model to use <a href="https://docs.litellm.ai/docs/#litellm-python-sdk" rel="nofollow">LiteLLM Python SDK</a> to access hundreds of LLMs.',Cs,F,we,xs,ot,pn="Create the LiteLLM client.",Vt,be,Rt,$e,gn=`This class lets you call any OpenAIServer compatible model.
Here’s how you can set it (you can customise the <code>api_base</code> url to point to another server):`,Xt,Je,Pt,B,Ue,As,lt,un="This model connects to an OpenAI-compatible API server.",Ft,Ie,Ot,ke,Mn="<code>AzureOpenAIServerModel</code> allows you to connect to any Azure OpenAI deployment.",Gt,je,fn="Below you can find an example of how to set it up, note that you can omit the <code>azure_endpoint</code>, <code>api_key</code>, and <code>api_version</code> arguments, provided you’ve set the corresponding environment variables — <code>AZURE_OPENAI_ENDPOINT</code>, <code>AZURE_OPENAI_API_KEY</code>, and <code>OPENAI_API_VERSION</code>.",Dt,Ce,hn='Pay attention to the lack of an <code>AZURE_</code> prefix for <code>OPENAI_API_VERSION</code>, this is due to the way the underlying <a href="https://github.com/openai/openai-python" rel="nofollow">openai</a> package is designed.',Yt,xe,Kt,W,Ae,qs,at,yn="This model connects to an Azure OpenAI deployment.",es,qe,ts,Le,vn="<code>AmazonBedrockServerModel</code> helps you connect to Amazon Bedrock and run your agent with any available models.",ss,Ne,_n="Below is an example setup. This class also offers additional options for customization.",ns,Ee,os,T,Ze,Ls,rt,Tn="A model class for interacting with Amazon Bedrock Server models through the Bedrock API.",Ns,it,wn=`This class provides an interface to interact with various Bedrock language models,
allowing for customized model inference, guardrail configuration, message handling,
and other parameters allowed by boto3 API.`,Es,dt,bn=`Example:
Creating a model instance with default settings:`,Zs,ct,$n=`<blockquote><blockquote><p>bedrock_model = AmazonBedrockServerModel(
…     model_id=‘us.amazon.nova-pro-v1:0’
… )</p></blockquote></blockquote>`,Bs,mt,Jn="Creating a model instance with a custom boto3 client:",Ws,pt,Un=`<blockquote><blockquote><p>import boto3
client = boto3.client(‘bedrock-runtime’, region_name=‘us-west-2’)
bedrock_model = AmazonBedrockServerModel(
…     model_id=‘us.amazon.nova-pro-v1:0’,
…     client=client
… )</p></blockquote></blockquote>`,Qs,gt,In="Creating a model instance with client_kwargs for internal client creation:",zs,ut,kn=`<blockquote><blockquote><p>bedrock_model = AmazonBedrockServerModel(
…     model_id=‘us.amazon.nova-pro-v1:0’,
…     client_kwargs={‘region_name’: ‘us-west-2’, ‘endpoint_url’: ’<a href="https://custom-endpoint.com&#39;}" rel="nofollow">https://custom-endpoint.com’}</a>
… )</p></blockquote></blockquote>`,Ss,Mt,jn="Creating a model instance with inference and guardrail configurations:",Hs,ft,Cn=`<blockquote><blockquote><p>additional_api_config = {
…     “inferenceConfig”: {
…         “maxTokens”: 3000
…     },
…     “guardrailConfig”: {
…         “guardrailIdentifier”: “identify1”,
…         “guardrailVersion”: ‘v1’
…     },
… }
bedrock_model = AmazonBedrockServerModel(
…     model_id=‘anthropic.claude-3-haiku-20240307-v1:0’,
…     **additional_api_config
… )</p></blockquote></blockquote>`,ls,Be,as,We,rs,Qe,is,O,ds,C,ze,Vs,ht,xn="A class to interact with models loaded using MLX on Apple silicon.",Rs,G,Xs,D,cs,Se,ms,He,An='Model to use <a href="https://docs.vllm.ai/" rel="nofollow">vLLM</a> for fast LLM inference and serving.',ps,Ve,gs,Y,us,Q,Re,Ps,yt,qn='Model to use <a href="https://docs.vllm.ai/" rel="nofollow">vLLM</a> for fast LLM inference and serving.',Ms,Xe,fs,_t,hs;return b=new Z({props:{title:"Models",local:"models",headingTag:"h1"}}),J=new vt({props:{warning:!0,$$slots:{default:[Qn]},$$scope:{ctx:$}}}),ee=new Z({props:{title:"Models",local:"models",headingTag:"h2"}}),le=new j({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGxvZ2luJTJDJTIwSW5mZXJlbmNlQ2xpZW50JTBBJTBBbG9naW4oJTIyJTNDWU9VUl9IVUdHSU5HRkFDRUhVQl9BUElfVE9LRU4lM0UlMjIpJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJtZXRhLWxsYW1hJTJGTGxhbWEtMy4zLTcwQi1JbnN0cnVjdCUyMiUwQSUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudChtb2RlbCUzRG1vZGVsX2lkKSUwQSUwQWRlZiUyMGN1c3RvbV9tb2RlbChtZXNzYWdlcyUyQyUyMHN0b3Bfc2VxdWVuY2VzJTNEJTVCJTIyVGFzayUyMiU1RCklM0ElMEElMjAlMjAlMjAlMjByZXNwb25zZSUyMCUzRCUyMGNsaWVudC5jaGF0X2NvbXBsZXRpb24obWVzc2FnZXMlMkMlMjBzdG9wJTNEc3RvcF9zZXF1ZW5jZXMlMkMlMjBtYXhfdG9rZW5zJTNEMTAyNCklMEElMjAlMjAlMjAlMjBhbnN3ZXIlMjAlM0QlMjByZXNwb25zZS5jaG9pY2VzJTVCMCU1RC5tZXNzYWdlJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwYW5zd2Vy",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> login, InferenceClient

login(<span class="hljs-string">&quot;&lt;YOUR_HUGGINGFACEHUB_API_TOKEN&gt;&quot;</span>)

model_id = <span class="hljs-string">&quot;meta-llama/Llama-3.3-70B-Instruct&quot;</span>

client = InferenceClient(model=model_id)

<span class="hljs-keyword">def</span> <span class="hljs-title function_">custom_model</span>(<span class="hljs-params">messages, stop_sequences=[<span class="hljs-string">&quot;Task&quot;</span>]</span>):
    response = client.chat_completion(messages, stop=stop_sequences, max_tokens=<span class="hljs-number">1024</span>)
    answer = response.choices[<span class="hljs-number">0</span>].message
    <span class="hljs-keyword">return</span> answer`,wrap:!1}}),re=new Z({props:{title:"TransformersModel",local:"smolagents.TransformersModel",headingTag:"h3"}}),de=new j({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBUcmFuc2Zvcm1lcnNNb2RlbCUwQSUwQW1vZGVsJTIwJTNEJTIwVHJhbnNmb3JtZXJzTW9kZWwobW9kZWxfaWQlM0QlMjJIdWdnaW5nRmFjZVRCJTJGU21vbExNLTEzNU0tSW5zdHJ1Y3QlMjIpJTBBJTBBcHJpbnQobW9kZWwoJTVCJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTVCJTdCJTIydHlwZSUyMiUzQSUyMCUyMnRleHQlMjIlMkMlMjAlMjJ0ZXh0JTIyJTNBJTIwJTIyT2shJTIyJTdEJTVEJTdEJTVEJTJDJTIwc3RvcF9zZXF1ZW5jZXMlM0QlNUIlMjJncmVhdCUyMiU1RCkp",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> TransformersModel

model = TransformersModel(model_id=<span class="hljs-string">&quot;HuggingFaceTB/SmolLM-135M-Instruct&quot;</span>)

<span class="hljs-built_in">print</span>(model([{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: [{<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;Ok!&quot;</span>}]}], stop_sequences=[<span class="hljs-string">&quot;great&quot;</span>]))`,wrap:!1}}),ce=new j({props:{code:"V2hhdCUyMGE=",highlighted:"&gt;&gt;&gt; What a",wrap:!1}}),H=new vt({props:{warning:!1,$$slots:{default:[zn]},$$scope:{ctx:$}}}),me=new E({props:{name:"class smolagents.TransformersModel",anchor:"smolagents.TransformersModel",parameters:[{name:"model_id",val:": typing.Optional[str] = None"},{name:"device_map",val:": typing.Optional[str] = None"},{name:"torch_dtype",val:": typing.Optional[str] = None"},{name:"trust_remote_code",val:": bool = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"smolagents.TransformersModel.model_id",description:`<strong>model_id</strong> (<code>str</code>) &#x2014;
The Hugging Face model ID to be used for inference. This can be a path or model identifier from the Hugging Face model hub.
For example, <code>&quot;Qwen/Qwen2.5-Coder-32B-Instruct&quot;</code>.`,name:"model_id"},{anchor:"smolagents.TransformersModel.device_map",description:`<strong>device_map</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The device_map to initialize your model with.`,name:"device_map"},{anchor:"smolagents.TransformersModel.torch_dtype",description:`<strong>torch_dtype</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The torch_dtype to initialize your model with.`,name:"torch_dtype"},{anchor:"smolagents.TransformersModel.trust_remote_code",description:`<strong>trust_remote_code</strong> (bool, default <code>False</code>) &#x2014;
Some models on the Hub require running remote code: for this model, you would have to set this flag to True.`,name:"trust_remote_code"},{anchor:"smolagents.TransformersModel.kwargs",description:`<strong>kwargs</strong> (dict, <em>optional</em>) &#x2014;
Any additional keyword arguments that you want to use in model.generate(), for instance <code>max_new_tokens</code> or <code>device</code>.`,name:"kwargs"},{anchor:"smolagents.TransformersModel.*kwargs",description:`*<strong>*kwargs</strong> &#x2014;
Additional keyword arguments to pass to <code>model.generate()</code>, for instance <code>max_new_tokens</code> or <code>device</code>.`,name:"*kwargs"}],source:"https://github.com/huggingface/smolagents/blob/vr_1197/src/smolagents/models.py#L623",raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><code>ValueError</code> —
If the model name is not provided.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>ValueError</code></p>
`}}),V=new vt({props:{warning:!1,$$slots:{default:[Sn]},$$scope:{ctx:$}}}),R=new Fs({props:{anchor:"smolagents.TransformersModel.example",$$slots:{default:[Hn]},$$scope:{ctx:$}}}),pe=new Z({props:{title:"HfApiModel",local:"smolagents.HfApiModel",headingTag:"h3"}}),ue=new j({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBIZkFwaU1vZGVsJTBBJTBBbWVzc2FnZXMlMjAlM0QlMjAlNUIlMEElMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlNUIlN0IlMjJ0eXBlJTIyJTNBJTIwJTIydGV4dCUyMiUyQyUyMCUyMnRleHQlMjIlM0ElMjAlMjJIZWxsbyUyQyUyMGhvdyUyMGFyZSUyMHlvdSUzRiUyMiU3RCU1RCU3RCUwQSU1RCUwQSUwQW1vZGVsJTIwJTNEJTIwSGZBcGlNb2RlbChwcm92aWRlciUzRCUyMm5vdml0YSUyMiklMEFwcmludChtb2RlbChtZXNzYWdlcykp",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> HfApiModel

messages = [
  {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: [{<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;Hello, how are you?&quot;</span>}]}
]

model = HfApiModel(provider=<span class="hljs-string">&quot;novita&quot;</span>)
<span class="hljs-built_in">print</span>(model(messages))`,wrap:!1}}),Me=new j({props:{code:"T2YlMjBjb3Vyc2UhJTIwSWYlMjB5b3UlMjBjaGFuZ2UlMjB5b3VyJTIwbWluZCUyQyUyMGZlZWwlMjBmcmVlJTIwdG8lMjByZWFjaCUyMG91dC4lMjBUYWtlJTIwY2FyZSE=",highlighted:"&gt;&gt;&gt; Of course! If you change your mind, feel free to reach out. Take care!",wrap:!1}}),fe=new E({props:{name:"class smolagents.HfApiModel",anchor:"smolagents.HfApiModel",parameters:[{name:"model_id",val:": str = 'Qwen/Qwen2.5-Coder-32B-Instruct'"},{name:"provider",val:": typing.Optional[str] = None"},{name:"token",val:": typing.Optional[str] = None"},{name:"timeout",val:": typing.Optional[int] = 120"},{name:"client_kwargs",val:": dict[str, typing.Any] | None = None"},{name:"custom_role_conversions",val:": dict[str, str] | None = None"},{name:"api_key",val:": typing.Optional[str] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"smolagents.HfApiModel.model_id",description:`<strong>model_id</strong> (<code>str</code>, <em>optional</em>, default <code>&quot;Qwen/Qwen2.5-Coder-32B-Instruct&quot;</code>) &#x2014;
The Hugging Face model ID to be used for inference.
This can be a model identifier from the Hugging Face model hub or a URL to a deployed Inference Endpoint.
Currently, it defaults to <code>&quot;Qwen/Qwen2.5-Coder-32B-Instruct&quot;</code>, but this may change in the future.`,name:"model_id"},{anchor:"smolagents.HfApiModel.provider",description:`<strong>provider</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Name of the provider to use for inference. Can be <code>&quot;black-forest-labs&quot;</code>, <code>&quot;cerebras&quot;</code>, <code>&quot;cohere&quot;</code>, <code>&quot;fal-ai&quot;</code>, <code>&quot;fireworks-ai&quot;</code>, <code>&quot;hf-inference&quot;</code>, <code>&quot;hyperbolic&quot;</code>, <code>&quot;nebius&quot;</code>, <code>&quot;novita&quot;</code>, <code>&quot;openai&quot;</code>, <code>&quot;replicate&quot;</code>, &#x201C;sambanova&#x201D;<code>, </code>&#x201C;together&#x201D;\`, etc.
Currently, it defaults to hf-inference (HF Inference API).`,name:"provider"},{anchor:"smolagents.HfApiModel.token",description:`<strong>token</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Token used by the Hugging Face API for authentication. This token need to be authorized &#x2018;Make calls to the serverless Inference Providers&#x2019;.
If the model is gated (like Llama-3 models), the token also needs &#x2018;Read access to contents of all public gated repos you can access&#x2019;.
If not provided, the class will try to use environment variable &#x2018;HF_TOKEN&#x2019;, else use the token stored in the Hugging Face CLI configuration.`,name:"token"},{anchor:"smolagents.HfApiModel.timeout",description:`<strong>timeout</strong> (<code>int</code>, <em>optional</em>, defaults to 120) &#x2014;
Timeout for the API request, in seconds.`,name:"timeout"},{anchor:"smolagents.HfApiModel.client_kwargs",description:`<strong>client_kwargs</strong> (<code>dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional keyword arguments to pass to the Hugging Face InferenceClient.`,name:"client_kwargs"},{anchor:"smolagents.HfApiModel.custom_role_conversions",description:`<strong>custom_role_conversions</strong> (<code>dict[str, str]</code>, <em>optional</em>) &#x2014;
Custom role conversion mapping to convert message roles in others.
Useful for specific models that do not support specific message roles like &#x201C;system&#x201D;.`,name:"custom_role_conversions"},{anchor:"smolagents.HfApiModel.api_key",description:`<strong>api_key</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Token to use for authentication. This is a duplicated argument from <code>token</code> to make <a href="/docs/smolagents/pr_1197/en/reference/models#smolagents.HfApiModel">HfApiModel</a>
follow the same pattern as <code>openai.OpenAI</code> client. Cannot be used if <code>token</code> is set. Defaults to None.`,name:"api_key"},{anchor:"smolagents.HfApiModel.*kwargs",description:`*<strong>*kwargs</strong> &#x2014;
Additional keyword arguments to pass to the Hugging Face API.`,name:"*kwargs"}],source:"https://github.com/huggingface/smolagents/blob/vr_1197/src/smolagents/models.py#L966",raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><code>ValueError</code> —
If the model name is not provided.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>ValueError</code></p>
`}}),X=new Fs({props:{anchor:"smolagents.HfApiModel.example",$$slots:{default:[Vn]},$$scope:{ctx:$}}}),he=new E({props:{name:"create_client",anchor:"smolagents.HfApiModel.create_client",parameters:[],source:"https://github.com/huggingface/smolagents/blob/vr_1197/src/smolagents/models.py#L1046"}}),ye=new Z({props:{title:"LiteLLMModel",local:"smolagents.LiteLLMModel",headingTag:"h3"}}),_e=new j({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBMaXRlTExNTW9kZWwlMEElMEFtZXNzYWdlcyUyMCUzRCUyMCU1QiUwQSUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCU1QiU3QiUyMnR5cGUlMjIlM0ElMjAlMjJ0ZXh0JTIyJTJDJTIwJTIydGV4dCUyMiUzQSUyMCUyMkhlbGxvJTJDJTIwaG93JTIwYXJlJTIweW91JTNGJTIyJTdEJTVEJTdEJTBBJTVEJTBBJTBBbW9kZWwlMjAlM0QlMjBMaXRlTExNTW9kZWwobW9kZWxfaWQlM0QlMjJhbnRocm9waWMlMkZjbGF1ZGUtMy01LXNvbm5ldC1sYXRlc3QlMjIlMkMlMjB0ZW1wZXJhdHVyZSUzRDAuMiUyQyUyMG1heF90b2tlbnMlM0QxMCklMEFwcmludChtb2RlbChtZXNzYWdlcykp",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> LiteLLMModel

messages = [
  {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: [{<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;Hello, how are you?&quot;</span>}]}
]

model = LiteLLMModel(model_id=<span class="hljs-string">&quot;anthropic/claude-3-5-sonnet-latest&quot;</span>, temperature=<span class="hljs-number">0.2</span>, max_tokens=<span class="hljs-number">10</span>)
<span class="hljs-built_in">print</span>(model(messages))`,wrap:!1}}),Te=new E({props:{name:"class smolagents.LiteLLMModel",anchor:"smolagents.LiteLLMModel",parameters:[{name:"model_id",val:": typing.Optional[str] = None"},{name:"api_base",val:" = None"},{name:"api_key",val:" = None"},{name:"custom_role_conversions",val:": dict[str, str] | None = None"},{name:"flatten_messages_as_text",val:": bool | None = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"smolagents.LiteLLMModel.model_id",description:`<strong>model_id</strong> (<code>str</code>) &#x2014;
The model identifier to use on the server (e.g. &#x201C;gpt-3.5-turbo&#x201D;).`,name:"model_id"},{anchor:"smolagents.LiteLLMModel.api_base",description:`<strong>api_base</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The base URL of the provider API to call the model.`,name:"api_base"},{anchor:"smolagents.LiteLLMModel.api_key",description:`<strong>api_key</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The API key to use for authentication.`,name:"api_key"},{anchor:"smolagents.LiteLLMModel.custom_role_conversions",description:`<strong>custom_role_conversions</strong> (<code>dict[str, str]</code>, <em>optional</em>) &#x2014;
Custom role conversion mapping to convert message roles in others.
Useful for specific models that do not support specific message roles like &#x201C;system&#x201D;.`,name:"custom_role_conversions"},{anchor:"smolagents.LiteLLMModel.flatten_messages_as_text",description:`<strong>flatten_messages_as_text</strong> (<code>bool</code>, <em>optional</em>) &#x2014; Whether to flatten messages as text.
Defaults to <code>True</code> for models that start with &#x201C;ollama&#x201D;, &#x201C;groq&#x201D;, &#x201C;cerebras&#x201D;.`,name:"flatten_messages_as_text"},{anchor:"smolagents.LiteLLMModel.*kwargs",description:`*<strong>*kwargs</strong> &#x2014;
Additional keyword arguments to pass to the OpenAI API.`,name:"*kwargs"}],source:"https://github.com/huggingface/smolagents/blob/vr_1197/src/smolagents/models.py#L873"}}),we=new E({props:{name:"create_client",anchor:"smolagents.LiteLLMModel.create_client",parameters:[],source:"https://github.com/huggingface/smolagents/blob/vr_1197/src/smolagents/models.py#L923"}}),be=new Z({props:{title:"OpenAIServerModel",local:"smolagents.OpenAIServerModel",headingTag:"h3"}}),Je=new j({props:{code:"aW1wb3J0JTIwb3MlMEFmcm9tJTIwc21vbGFnZW50cyUyMGltcG9ydCUyME9wZW5BSVNlcnZlck1vZGVsJTBBJTBBbW9kZWwlMjAlM0QlMjBPcGVuQUlTZXJ2ZXJNb2RlbCglMEElMjAlMjAlMjAlMjBtb2RlbF9pZCUzRCUyMmdwdC00byUyMiUyQyUwQSUyMCUyMCUyMCUyMGFwaV9iYXNlJTNEJTIyaHR0cHMlM0ElMkYlMkZhcGkub3BlbmFpLmNvbSUyRnYxJTIyJTJDJTBBJTIwJTIwJTIwJTIwYXBpX2tleSUzRG9zLmVudmlyb24lNUIlMjJPUEVOQUlfQVBJX0tFWSUyMiU1RCUyQyUwQSk=",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> OpenAIServerModel

model = OpenAIServerModel(
    model_id=<span class="hljs-string">&quot;gpt-4o&quot;</span>,
    api_base=<span class="hljs-string">&quot;https://api.openai.com/v1&quot;</span>,
    api_key=os.environ[<span class="hljs-string">&quot;OPENAI_API_KEY&quot;</span>],
)`,wrap:!1}}),Ue=new E({props:{name:"class smolagents.OpenAIServerModel",anchor:"smolagents.OpenAIServerModel",parameters:[{name:"model_id",val:": str"},{name:"api_base",val:": typing.Optional[str] = None"},{name:"api_key",val:": typing.Optional[str] = None"},{name:"organization",val:": typing.Optional[str] = None"},{name:"project",val:": typing.Optional[str] = None"},{name:"client_kwargs",val:": dict[str, typing.Any] | None = None"},{name:"custom_role_conversions",val:": dict[str, str] | None = None"},{name:"flatten_messages_as_text",val:": bool = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"smolagents.OpenAIServerModel.model_id",description:`<strong>model_id</strong> (<code>str</code>) &#x2014;
The model identifier to use on the server (e.g. &#x201C;gpt-3.5-turbo&#x201D;).`,name:"model_id"},{anchor:"smolagents.OpenAIServerModel.api_base",description:`<strong>api_base</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The base URL of the OpenAI-compatible API server.`,name:"api_base"},{anchor:"smolagents.OpenAIServerModel.api_key",description:`<strong>api_key</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The API key to use for authentication.`,name:"api_key"},{anchor:"smolagents.OpenAIServerModel.organization",description:`<strong>organization</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The organization to use for the API request.`,name:"organization"},{anchor:"smolagents.OpenAIServerModel.project",description:`<strong>project</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The project to use for the API request.`,name:"project"},{anchor:"smolagents.OpenAIServerModel.client_kwargs",description:`<strong>client_kwargs</strong> (<code>dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional keyword arguments to pass to the OpenAI client (like organization, project, max_retries etc.).`,name:"client_kwargs"},{anchor:"smolagents.OpenAIServerModel.custom_role_conversions",description:`<strong>custom_role_conversions</strong> (<code>dict[str, str]</code>, <em>optional</em>) &#x2014;
Custom role conversion mapping to convert message roles in others.
Useful for specific models that do not support specific message roles like &#x201C;system&#x201D;.`,name:"custom_role_conversions"},{anchor:"smolagents.OpenAIServerModel.flatten_messages_as_text",description:`<strong>flatten_messages_as_text</strong> (<code>bool</code>, default <code>False</code>) &#x2014;
Whether to flatten messages as text.`,name:"flatten_messages_as_text"},{anchor:"smolagents.OpenAIServerModel.*kwargs",description:`*<strong>*kwargs</strong> &#x2014;
Additional keyword arguments to pass to the OpenAI API.`,name:"*kwargs"}],source:"https://github.com/huggingface/smolagents/blob/vr_1197/src/smolagents/models.py#L1077"}}),Ie=new Z({props:{title:"AzureOpenAIServerModel",local:"smolagents.AzureOpenAIServerModel",headingTag:"h3"}}),xe=new j({props:{code:"aW1wb3J0JTIwb3MlMEElMEFmcm9tJTIwc21vbGFnZW50cyUyMGltcG9ydCUyMEF6dXJlT3BlbkFJU2VydmVyTW9kZWwlMEElMEFtb2RlbCUyMCUzRCUyMEF6dXJlT3BlbkFJU2VydmVyTW9kZWwoJTBBJTIwJTIwJTIwJTIwbW9kZWxfaWQlMjAlM0QlMjBvcy5lbnZpcm9uLmdldCglMjJBWlVSRV9PUEVOQUlfTU9ERUwlMjIpJTJDJTBBJTIwJTIwJTIwJTIwYXp1cmVfZW5kcG9pbnQlM0Rvcy5lbnZpcm9uLmdldCglMjJBWlVSRV9PUEVOQUlfRU5EUE9JTlQlMjIpJTJDJTBBJTIwJTIwJTIwJTIwYXBpX2tleSUzRG9zLmVudmlyb24uZ2V0KCUyMkFaVVJFX09QRU5BSV9BUElfS0VZJTIyKSUyQyUwQSUyMCUyMCUyMCUyMGFwaV92ZXJzaW9uJTNEb3MuZW52aXJvbi5nZXQoJTIyT1BFTkFJX0FQSV9WRVJTSU9OJTIyKSUyMCUyMCUyMCUyMCUwQSk=",highlighted:`<span class="hljs-keyword">import</span> os

<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> AzureOpenAIServerModel

model = AzureOpenAIServerModel(
    model_id = os.environ.get(<span class="hljs-string">&quot;AZURE_OPENAI_MODEL&quot;</span>),
    azure_endpoint=os.environ.get(<span class="hljs-string">&quot;AZURE_OPENAI_ENDPOINT&quot;</span>),
    api_key=os.environ.get(<span class="hljs-string">&quot;AZURE_OPENAI_API_KEY&quot;</span>),
    api_version=os.environ.get(<span class="hljs-string">&quot;OPENAI_API_VERSION&quot;</span>)    
)`,wrap:!1}}),Ae=new E({props:{name:"class smolagents.AzureOpenAIServerModel",anchor:"smolagents.AzureOpenAIServerModel",parameters:[{name:"model_id",val:": str"},{name:"azure_endpoint",val:": typing.Optional[str] = None"},{name:"api_key",val:": typing.Optional[str] = None"},{name:"api_version",val:": typing.Optional[str] = None"},{name:"client_kwargs",val:": dict[str, typing.Any] | None = None"},{name:"custom_role_conversions",val:": dict[str, str] | None = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"smolagents.AzureOpenAIServerModel.model_id",description:`<strong>model_id</strong> (<code>str</code>) &#x2014;
The model deployment name to use when connecting (e.g. &#x201C;gpt-4o-mini&#x201D;).`,name:"model_id"},{anchor:"smolagents.AzureOpenAIServerModel.azure_endpoint",description:`<strong>azure_endpoint</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The Azure endpoint, including the resource, e.g. <code>https://example-resource.azure.openai.com/</code>. If not provided, it will be inferred from the <code>AZURE_OPENAI_ENDPOINT</code> environment variable.`,name:"azure_endpoint"},{anchor:"smolagents.AzureOpenAIServerModel.api_key",description:`<strong>api_key</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The API key to use for authentication. If not provided, it will be inferred from the <code>AZURE_OPENAI_API_KEY</code> environment variable.`,name:"api_key"},{anchor:"smolagents.AzureOpenAIServerModel.api_version",description:`<strong>api_version</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The API version to use. If not provided, it will be inferred from the <code>OPENAI_API_VERSION</code> environment variable.`,name:"api_version"},{anchor:"smolagents.AzureOpenAIServerModel.client_kwargs",description:`<strong>client_kwargs</strong> (<code>dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional keyword arguments to pass to the AzureOpenAI client (like organization, project, max_retries etc.).`,name:"client_kwargs"},{anchor:"smolagents.AzureOpenAIServerModel.custom_role_conversions",description:`<strong>custom_role_conversions</strong> (<code>dict[str, str]</code>, <em>optional</em>) &#x2014;
Custom role conversion mapping to convert message roles in others.
Useful for specific models that do not support specific message roles like &#x201C;system&#x201D;.`,name:"custom_role_conversions"},{anchor:"smolagents.AzureOpenAIServerModel.*kwargs",description:`*<strong>*kwargs</strong> &#x2014;
Additional keyword arguments to pass to the Azure OpenAI API.`,name:"*kwargs"}],source:"https://github.com/huggingface/smolagents/blob/vr_1197/src/smolagents/models.py#L1167"}}),qe=new Z({props:{title:"AmazonBedrockServerModel",local:"smolagents.AmazonBedrockServerModel",headingTag:"h3"}}),Ee=new j({props:{code:"aW1wb3J0JTIwb3MlMEElMEFmcm9tJTIwc21vbGFnZW50cyUyMGltcG9ydCUyMEFtYXpvbkJlZHJvY2tTZXJ2ZXJNb2RlbCUwQSUwQW1vZGVsJTIwJTNEJTIwQW1hem9uQmVkcm9ja1NlcnZlck1vZGVsKCUwQSUyMCUyMCUyMCUyMG1vZGVsX2lkJTIwJTNEJTIwb3MuZW52aXJvbi5nZXQoJTIyQU1BWk9OX0JFRFJPQ0tfTU9ERUxfSUQlMjIpJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">import</span> os

<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> AmazonBedrockServerModel

model = AmazonBedrockServerModel(
    model_id = os.environ.get(<span class="hljs-string">&quot;AMAZON_BEDROCK_MODEL_ID&quot;</span>),
)`,wrap:!1}}),Ze=new E({props:{name:"class smolagents.AmazonBedrockServerModel",anchor:"smolagents.AmazonBedrockServerModel",parameters:[{name:"model_id",val:": str"},{name:"client",val:" = None"},{name:"client_kwargs",val:": dict[str, typing.Any] | None = None"},{name:"custom_role_conversions",val:": dict[str, str] | None = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"smolagents.AmazonBedrockServerModel.model_id",description:`<strong>model_id</strong> (<code>str</code>) &#x2014;
The model identifier to use on Bedrock (e.g. &#x201C;us.amazon.nova-pro-v1:0&#x201D;).`,name:"model_id"},{anchor:"smolagents.AmazonBedrockServerModel.client",description:`<strong>client</strong> (<code>boto3.client</code>, <em>optional</em>) &#x2014;
A custom boto3 client for AWS interactions. If not provided, a default client will be created.`,name:"client"},{anchor:"smolagents.AmazonBedrockServerModel.client_kwargs",description:`<strong>client_kwargs</strong> (dict[str, Any], <em>optional</em>) &#x2014;
Keyword arguments used to configure the boto3 client if it needs to be created internally.
Examples include <code>region_name</code>, <code>config</code>, or <code>endpoint_url</code>.`,name:"client_kwargs"},{anchor:"smolagents.AmazonBedrockServerModel.custom_role_conversions",description:`<strong>custom_role_conversions</strong> (<code>dict[str, str]</code>, <em>optional</em>) &#x2014;
Custom role conversion mapping to convert message roles in others.
Useful for specific models that do not support specific message roles like &#x201C;system&#x201D;.
Defaults to converting all roles to &#x201C;user&#x201D; role to enable using all the Bedrock models.`,name:"custom_role_conversions"},{anchor:"smolagents.AmazonBedrockServerModel.flatten_messages_as_text",description:`<strong>flatten_messages_as_text</strong> (<code>bool</code>, default <code>False</code>) &#x2014;
Whether to flatten messages as text.`,name:"flatten_messages_as_text"},{anchor:"smolagents.AmazonBedrockServerModel.*kwargs",description:`*<strong>*kwargs</strong> &#x2014;
Additional keyword arguments passed directly to the underlying API calls.`,name:"*kwargs"}],source:"https://github.com/huggingface/smolagents/blob/vr_1197/src/smolagents/models.py#L1224"}}),Be=new Z({props:{title:"MLXModel",local:"smolagents.MLXModel",headingTag:"h3"}}),We=new j({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBNTFhNb2RlbCUwQSUwQW1vZGVsJTIwJTNEJTIwTUxYTW9kZWwobW9kZWxfaWQlM0QlMjJIdWdnaW5nRmFjZVRCJTJGU21vbExNLTEzNU0tSW5zdHJ1Y3QlMjIpJTBBJTBBcHJpbnQobW9kZWwoJTVCJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyT2shJTIyJTdEJTVEJTJDJTIwc3RvcF9zZXF1ZW5jZXMlM0QlNUIlMjJncmVhdCUyMiU1RCkp",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> MLXModel

model = MLXModel(model_id=<span class="hljs-string">&quot;HuggingFaceTB/SmolLM-135M-Instruct&quot;</span>)

<span class="hljs-built_in">print</span>(model([{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Ok!&quot;</span>}], stop_sequences=[<span class="hljs-string">&quot;great&quot;</span>]))`,wrap:!1}}),Qe=new j({props:{code:"V2hhdCUyMGE=",highlighted:"&gt;&gt;&gt; What a",wrap:!1}}),O=new vt({props:{warning:!1,$$slots:{default:[Rn]},$$scope:{ctx:$}}}),ze=new E({props:{name:"class smolagents.MLXModel",anchor:"smolagents.MLXModel",parameters:[{name:"model_id",val:": str"},{name:"tool_name_key",val:": str = 'name'"},{name:"tool_arguments_key",val:": str = 'arguments'"},{name:"trust_remote_code",val:": bool = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"smolagents.MLXModel.model_id",description:`<strong>model_id</strong> (str) &#x2014;
The Hugging Face model ID to be used for inference. This can be a path or model identifier from the Hugging Face model hub.`,name:"model_id"},{anchor:"smolagents.MLXModel.tool_name_key",description:`<strong>tool_name_key</strong> (str) &#x2014;
The key, which can usually be found in the model&#x2019;s chat template, for retrieving a tool name.`,name:"tool_name_key"},{anchor:"smolagents.MLXModel.tool_arguments_key",description:`<strong>tool_arguments_key</strong> (str) &#x2014;
The key, which can usually be found in the model&#x2019;s chat template, for retrieving tool arguments.`,name:"tool_arguments_key"},{anchor:"smolagents.MLXModel.trust_remote_code",description:`<strong>trust_remote_code</strong> (bool) &#x2014;
Some models on the Hub require running remote code: for this model, you would have to set this flag to True.`,name:"trust_remote_code"},{anchor:"smolagents.MLXModel.kwargs",description:`<strong>kwargs</strong> (dict, <em>optional</em>) &#x2014;
Any additional keyword arguments that you want to use in model.generate(), for instance <code>max_tokens</code>.`,name:"kwargs"}],source:"https://github.com/huggingface/smolagents/blob/vr_1197/src/smolagents/models.py#L519"}}),G=new vt({props:{warning:!1,$$slots:{default:[Xn]},$$scope:{ctx:$}}}),D=new Fs({props:{anchor:"smolagents.MLXModel.example",$$slots:{default:[Pn]},$$scope:{ctx:$}}}),Se=new Z({props:{title:"VLLMModel",local:"smolagents.VLLMModel",headingTag:"h3"}}),Ve=new j({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBWTExNTW9kZWwlMEElMEFtb2RlbCUyMCUzRCUyMFZMTE1Nb2RlbChtb2RlbF9pZCUzRCUyMkh1Z2dpbmdGYWNlVEIlMkZTbW9sTE0tMTM1TS1JbnN0cnVjdCUyMiklMEElMEFwcmludChtb2RlbCglNUIlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJPayElMjIlN0QlNUQlMkMlMjBzdG9wX3NlcXVlbmNlcyUzRCU1QiUyMmdyZWF0JTIyJTVEKSk=",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> VLLMModel

model = VLLMModel(model_id=<span class="hljs-string">&quot;HuggingFaceTB/SmolLM-135M-Instruct&quot;</span>)

<span class="hljs-built_in">print</span>(model([{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Ok!&quot;</span>}], stop_sequences=[<span class="hljs-string">&quot;great&quot;</span>]))`,wrap:!1}}),Y=new vt({props:{warning:!1,$$slots:{default:[Fn]},$$scope:{ctx:$}}}),Re=new E({props:{name:"class smolagents.VLLMModel",anchor:"smolagents.VLLMModel",parameters:[{name:"model_id",val:""},{name:"model_kwargs",val:": dict[str, typing.Any] | None = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"smolagents.VLLMModel.model_id",description:`<strong>model_id</strong> (<code>str</code>) &#x2014;
The Hugging Face model ID to be used for inference.
This can be a path or model identifier from the Hugging Face model hub.`,name:"model_id"},{anchor:"smolagents.VLLMModel.model_kwargs",description:`<strong>model_kwargs</strong> (<code>dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional keyword arguments to pass to the vLLM model (like revision, max_model_len, etc.).`,name:"model_kwargs"}],source:"https://github.com/huggingface/smolagents/blob/vr_1197/src/smolagents/models.py#L409"}}),Xe=new Wn({props:{source:"https://github.com/huggingface/smolagents/blob/main/docs/source/en/reference/models.mdx"}}),{c(){a=r("meta"),_=o(),d=r("p"),v=o(),g(b.$$.fragment),m=o(),g(J.$$.fragment),Tt=o(),K=r("p"),K.innerHTML=Os,wt=o(),g(ee.$$.fragment),bt=o(),te=r("p"),te.textContent=Gs,$t=o(),se=r("p"),se.innerHTML=Ds,Jt=o(),ne=r("ol"),ne.innerHTML=Ys,Ut=o(),oe=r("p"),oe.innerHTML=Ks,It=o(),g(le.$$.fragment),kt=o(),ae=r("p"),ae.innerHTML=en,jt=o(),g(re.$$.fragment),Ct=o(),ie=r("p"),ie.innerHTML=tn,xt=o(),g(de.$$.fragment),At=o(),g(ce.$$.fragment),qt=o(),g(H.$$.fragment),Lt=o(),I=r("div"),g(me.$$.fragment),vs=o(),De=r("p"),De.textContent=sn,_s=o(),Ye=r("p"),Ye.textContent=nn,Ts=o(),g(V.$$.fragment),ws=o(),g(R.$$.fragment),Nt=o(),g(pe.$$.fragment),Et=o(),ge=r("p"),ge.innerHTML=on,Zt=o(),g(ue.$$.fragment),Bt=o(),g(Me.$$.fragment),Wt=o(),U=r("div"),g(fe.$$.fragment),bs=o(),Ke=r("p"),Ke.textContent=ln,$s=o(),et=r("p"),et.textContent=an,Js=o(),tt=r("p"),tt.textContent=rn,Us=o(),g(X.$$.fragment),Is=o(),P=r("div"),g(he.$$.fragment),ks=o(),st=r("p"),st.textContent=dn,Qt=o(),g(ye.$$.fragment),zt=o(),ve=r("p"),ve.innerHTML=cn,St=o(),g(_e.$$.fragment),Ht=o(),L=r("div"),g(Te.$$.fragment),js=o(),nt=r("p"),nt.innerHTML=mn,Cs=o(),F=r("div"),g(we.$$.fragment),xs=o(),ot=r("p"),ot.textContent=pn,Vt=o(),g(be.$$.fragment),Rt=o(),$e=r("p"),$e.innerHTML=gn,Xt=o(),g(Je.$$.fragment),Pt=o(),B=r("div"),g(Ue.$$.fragment),As=o(),lt=r("p"),lt.textContent=un,Ft=o(),g(Ie.$$.fragment),Ot=o(),ke=r("p"),ke.innerHTML=Mn,Gt=o(),je=r("p"),je.innerHTML=fn,Dt=o(),Ce=r("p"),Ce.innerHTML=hn,Yt=o(),g(xe.$$.fragment),Kt=o(),W=r("div"),g(Ae.$$.fragment),qs=o(),at=r("p"),at.textContent=yn,es=o(),g(qe.$$.fragment),ts=o(),Le=r("p"),Le.innerHTML=vn,ss=o(),Ne=r("p"),Ne.textContent=_n,ns=o(),g(Ee.$$.fragment),os=o(),T=r("div"),g(Ze.$$.fragment),Ls=o(),rt=r("p"),rt.textContent=Tn,Ns=o(),it=r("p"),it.textContent=wn,Es=o(),dt=r("p"),dt.textContent=bn,Zs=o(),ct=r("blockquote"),ct.innerHTML=$n,Bs=o(),mt=r("p"),mt.textContent=Jn,Ws=o(),pt=r("blockquote"),pt.innerHTML=Un,Qs=o(),gt=r("p"),gt.textContent=In,zs=o(),ut=r("blockquote"),ut.innerHTML=kn,Ss=o(),Mt=r("p"),Mt.textContent=jn,Hs=o(),ft=r("blockquote"),ft.innerHTML=Cn,ls=o(),g(Be.$$.fragment),as=o(),g(We.$$.fragment),rs=o(),g(Qe.$$.fragment),is=o(),g(O.$$.fragment),ds=o(),C=r("div"),g(ze.$$.fragment),Vs=o(),ht=r("p"),ht.textContent=xn,Rs=o(),g(G.$$.fragment),Xs=o(),g(D.$$.fragment),cs=o(),g(Se.$$.fragment),ms=o(),He=r("p"),He.innerHTML=An,ps=o(),g(Ve.$$.fragment),gs=o(),g(Y.$$.fragment),us=o(),Q=r("div"),g(Re.$$.fragment),Ps=o(),yt=r("p"),yt.innerHTML=qn,Ms=o(),g(Xe.$$.fragment),fs=o(),_t=r("p"),this.h()},l(e){const t=Bn("svelte-u9bgzb",document.head);a=i(t,"META",{name:!0,content:!0}),t.forEach(s),_=l(e),d=i(e,"P",{}),A(d).forEach(s),v=l(e),u(b.$$.fragment,e),m=l(e),u(J.$$.fragment,e),Tt=l(e),K=i(e,"P",{"data-svelte-h":!0}),p(K)!=="svelte-17nnzxz"&&(K.innerHTML=Os),wt=l(e),u(ee.$$.fragment,e),bt=l(e),te=i(e,"P",{"data-svelte-h":!0}),p(te)!=="svelte-nwgagp"&&(te.textContent=Gs),$t=l(e),se=i(e,"P",{"data-svelte-h":!0}),p(se)!=="svelte-yyby1q"&&(se.innerHTML=Ds),Jt=l(e),ne=i(e,"OL",{"data-svelte-h":!0}),p(ne)!=="svelte-1rxiwyn"&&(ne.innerHTML=Ys),Ut=l(e),oe=i(e,"P",{"data-svelte-h":!0}),p(oe)!=="svelte-1xka7lb"&&(oe.innerHTML=Ks),It=l(e),u(le.$$.fragment,e),kt=l(e),ae=i(e,"P",{"data-svelte-h":!0}),p(ae)!=="svelte-q98spx"&&(ae.innerHTML=en),jt=l(e),u(re.$$.fragment,e),Ct=l(e),ie=i(e,"P",{"data-svelte-h":!0}),p(ie)!=="svelte-ulv590"&&(ie.innerHTML=tn),xt=l(e),u(de.$$.fragment,e),At=l(e),u(ce.$$.fragment,e),qt=l(e),u(H.$$.fragment,e),Lt=l(e),I=i(e,"DIV",{class:!0});var x=A(I);u(me.$$.fragment,x),vs=l(x),De=i(x,"P",{"data-svelte-h":!0}),p(De)!=="svelte-1ex1ahr"&&(De.textContent=sn),_s=l(x),Ye=i(x,"P",{"data-svelte-h":!0}),p(Ye)!=="svelte-1140acn"&&(Ye.textContent=nn),Ts=l(x),u(V.$$.fragment,x),ws=l(x),u(R.$$.fragment,x),x.forEach(s),Nt=l(e),u(pe.$$.fragment,e),Et=l(e),ge=i(e,"P",{"data-svelte-h":!0}),p(ge)!=="svelte-1jm6m22"&&(ge.innerHTML=on),Zt=l(e),u(ue.$$.fragment,e),Bt=l(e),u(Me.$$.fragment,e),Wt=l(e),U=i(e,"DIV",{class:!0});var k=A(U);u(fe.$$.fragment,k),bs=l(k),Ke=i(k,"P",{"data-svelte-h":!0}),p(Ke)!=="svelte-axkcn3"&&(Ke.textContent=ln),$s=l(k),et=i(k,"P",{"data-svelte-h":!0}),p(et)!=="svelte-fi9dcf"&&(et.textContent=an),Js=l(k),tt=i(k,"P",{"data-svelte-h":!0}),p(tt)!=="svelte-12eu297"&&(tt.textContent=rn),Us=l(k),u(X.$$.fragment,k),Is=l(k),P=i(k,"DIV",{class:!0});var Pe=A(P);u(he.$$.fragment,Pe),ks=l(Pe),st=i(Pe,"P",{"data-svelte-h":!0}),p(st)!=="svelte-ym2f5u"&&(st.textContent=dn),Pe.forEach(s),k.forEach(s),Qt=l(e),u(ye.$$.fragment,e),zt=l(e),ve=i(e,"P",{"data-svelte-h":!0}),p(ve)!=="svelte-y3d4cs"&&(ve.innerHTML=cn),St=l(e),u(_e.$$.fragment,e),Ht=l(e),L=i(e,"DIV",{class:!0});var z=A(L);u(Te.$$.fragment,z),js=l(z),nt=i(z,"P",{"data-svelte-h":!0}),p(nt)!=="svelte-5g97zk"&&(nt.innerHTML=mn),Cs=l(z),F=i(z,"DIV",{class:!0});var Fe=A(F);u(we.$$.fragment,Fe),xs=l(Fe),ot=i(Fe,"P",{"data-svelte-h":!0}),p(ot)!=="svelte-12r14rd"&&(ot.textContent=pn),Fe.forEach(s),z.forEach(s),Vt=l(e),u(be.$$.fragment,e),Rt=l(e),$e=i(e,"P",{"data-svelte-h":!0}),p($e)!=="svelte-juyrd0"&&($e.innerHTML=gn),Xt=l(e),u(Je.$$.fragment,e),Pt=l(e),B=i(e,"DIV",{class:!0});var Oe=A(B);u(Ue.$$.fragment,Oe),As=l(Oe),lt=i(Oe,"P",{"data-svelte-h":!0}),p(lt)!=="svelte-1bc1pfc"&&(lt.textContent=un),Oe.forEach(s),Ft=l(e),u(Ie.$$.fragment,e),Ot=l(e),ke=i(e,"P",{"data-svelte-h":!0}),p(ke)!=="svelte-1946uqd"&&(ke.innerHTML=Mn),Gt=l(e),je=i(e,"P",{"data-svelte-h":!0}),p(je)!=="svelte-1tbo5q5"&&(je.innerHTML=fn),Dt=l(e),Ce=i(e,"P",{"data-svelte-h":!0}),p(Ce)!=="svelte-16r94fh"&&(Ce.innerHTML=hn),Yt=l(e),u(xe.$$.fragment,e),Kt=l(e),W=i(e,"DIV",{class:!0});var Ge=A(W);u(Ae.$$.fragment,Ge),qs=l(Ge),at=i(Ge,"P",{"data-svelte-h":!0}),p(at)!=="svelte-1fspdqk"&&(at.textContent=yn),Ge.forEach(s),es=l(e),u(qe.$$.fragment,e),ts=l(e),Le=i(e,"P",{"data-svelte-h":!0}),p(Le)!=="svelte-72042c"&&(Le.innerHTML=vn),ss=l(e),Ne=i(e,"P",{"data-svelte-h":!0}),p(Ne)!=="svelte-l4p418"&&(Ne.textContent=_n),ns=l(e),u(Ee.$$.fragment,e),os=l(e),T=i(e,"DIV",{class:!0});var w=A(T);u(Ze.$$.fragment,w),Ls=l(w),rt=i(w,"P",{"data-svelte-h":!0}),p(rt)!=="svelte-nngfd4"&&(rt.textContent=Tn),Ns=l(w),it=i(w,"P",{"data-svelte-h":!0}),p(it)!=="svelte-1milklp"&&(it.textContent=wn),Es=l(w),dt=i(w,"P",{"data-svelte-h":!0}),p(dt)!=="svelte-1up0lfq"&&(dt.textContent=bn),Zs=l(w),ct=i(w,"BLOCKQUOTE",{"data-svelte-h":!0}),p(ct)!=="svelte-iqy4hw"&&(ct.innerHTML=$n),Bs=l(w),mt=i(w,"P",{"data-svelte-h":!0}),p(mt)!=="svelte-11isg5i"&&(mt.textContent=Jn),Ws=l(w),pt=i(w,"BLOCKQUOTE",{"data-svelte-h":!0}),p(pt)!=="svelte-cleom1"&&(pt.innerHTML=Un),Qs=l(w),gt=i(w,"P",{"data-svelte-h":!0}),p(gt)!=="svelte-1s85quz"&&(gt.textContent=In),zs=l(w),ut=i(w,"BLOCKQUOTE",{"data-svelte-h":!0}),p(ut)!=="svelte-1dcoje5"&&(ut.innerHTML=kn),Ss=l(w),Mt=i(w,"P",{"data-svelte-h":!0}),p(Mt)!=="svelte-4kd7m4"&&(Mt.textContent=jn),Hs=l(w),ft=i(w,"BLOCKQUOTE",{"data-svelte-h":!0}),p(ft)!=="svelte-ka8999"&&(ft.innerHTML=Cn),w.forEach(s),ls=l(e),u(Be.$$.fragment,e),as=l(e),u(We.$$.fragment,e),rs=l(e),u(Qe.$$.fragment,e),is=l(e),u(O.$$.fragment,e),ds=l(e),C=i(e,"DIV",{class:!0});var N=A(C);u(ze.$$.fragment,N),Vs=l(N),ht=i(N,"P",{"data-svelte-h":!0}),p(ht)!=="svelte-t9ku5w"&&(ht.textContent=xn),Rs=l(N),u(G.$$.fragment,N),Xs=l(N),u(D.$$.fragment,N),N.forEach(s),cs=l(e),u(Se.$$.fragment,e),ms=l(e),He=i(e,"P",{"data-svelte-h":!0}),p(He)!=="svelte-1vi10v1"&&(He.innerHTML=An),ps=l(e),u(Ve.$$.fragment,e),gs=l(e),u(Y.$$.fragment,e),us=l(e),Q=i(e,"DIV",{class:!0});var ys=A(Q);u(Re.$$.fragment,ys),Ps=l(ys),yt=i(ys,"P",{"data-svelte-h":!0}),p(yt)!=="svelte-1vi10v1"&&(yt.innerHTML=qn),ys.forEach(s),Ms=l(e),u(Xe.$$.fragment,e),fs=l(e),_t=i(e,"P",{}),A(_t).forEach(s),this.h()},h(){q(a,"name","hf:doc:metadata"),q(a,"content",Gn),q(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(T,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){c(document.head,a),n(e,_,t),n(e,d,t),n(e,v,t),M(b,e,t),n(e,m,t),M(J,e,t),n(e,Tt,t),n(e,K,t),n(e,wt,t),M(ee,e,t),n(e,bt,t),n(e,te,t),n(e,$t,t),n(e,se,t),n(e,Jt,t),n(e,ne,t),n(e,Ut,t),n(e,oe,t),n(e,It,t),M(le,e,t),n(e,kt,t),n(e,ae,t),n(e,jt,t),M(re,e,t),n(e,Ct,t),n(e,ie,t),n(e,xt,t),M(de,e,t),n(e,At,t),M(ce,e,t),n(e,qt,t),M(H,e,t),n(e,Lt,t),n(e,I,t),M(me,I,null),c(I,vs),c(I,De),c(I,_s),c(I,Ye),c(I,Ts),M(V,I,null),c(I,ws),M(R,I,null),n(e,Nt,t),M(pe,e,t),n(e,Et,t),n(e,ge,t),n(e,Zt,t),M(ue,e,t),n(e,Bt,t),M(Me,e,t),n(e,Wt,t),n(e,U,t),M(fe,U,null),c(U,bs),c(U,Ke),c(U,$s),c(U,et),c(U,Js),c(U,tt),c(U,Us),M(X,U,null),c(U,Is),c(U,P),M(he,P,null),c(P,ks),c(P,st),n(e,Qt,t),M(ye,e,t),n(e,zt,t),n(e,ve,t),n(e,St,t),M(_e,e,t),n(e,Ht,t),n(e,L,t),M(Te,L,null),c(L,js),c(L,nt),c(L,Cs),c(L,F),M(we,F,null),c(F,xs),c(F,ot),n(e,Vt,t),M(be,e,t),n(e,Rt,t),n(e,$e,t),n(e,Xt,t),M(Je,e,t),n(e,Pt,t),n(e,B,t),M(Ue,B,null),c(B,As),c(B,lt),n(e,Ft,t),M(Ie,e,t),n(e,Ot,t),n(e,ke,t),n(e,Gt,t),n(e,je,t),n(e,Dt,t),n(e,Ce,t),n(e,Yt,t),M(xe,e,t),n(e,Kt,t),n(e,W,t),M(Ae,W,null),c(W,qs),c(W,at),n(e,es,t),M(qe,e,t),n(e,ts,t),n(e,Le,t),n(e,ss,t),n(e,Ne,t),n(e,ns,t),M(Ee,e,t),n(e,os,t),n(e,T,t),M(Ze,T,null),c(T,Ls),c(T,rt),c(T,Ns),c(T,it),c(T,Es),c(T,dt),c(T,Zs),c(T,ct),c(T,Bs),c(T,mt),c(T,Ws),c(T,pt),c(T,Qs),c(T,gt),c(T,zs),c(T,ut),c(T,Ss),c(T,Mt),c(T,Hs),c(T,ft),n(e,ls,t),M(Be,e,t),n(e,as,t),M(We,e,t),n(e,rs,t),M(Qe,e,t),n(e,is,t),M(O,e,t),n(e,ds,t),n(e,C,t),M(ze,C,null),c(C,Vs),c(C,ht),c(C,Rs),M(G,C,null),c(C,Xs),M(D,C,null),n(e,cs,t),M(Se,e,t),n(e,ms,t),n(e,He,t),n(e,ps,t),M(Ve,e,t),n(e,gs,t),M(Y,e,t),n(e,us,t),n(e,Q,t),M(Re,Q,null),c(Q,Ps),c(Q,yt),n(e,Ms,t),M(Xe,e,t),n(e,fs,t),n(e,_t,t),hs=!0},p(e,[t]){const x={};t&2&&(x.$$scope={dirty:t,ctx:e}),J.$set(x);const k={};t&2&&(k.$$scope={dirty:t,ctx:e}),H.$set(k);const Pe={};t&2&&(Pe.$$scope={dirty:t,ctx:e}),V.$set(Pe);const z={};t&2&&(z.$$scope={dirty:t,ctx:e}),R.$set(z);const Fe={};t&2&&(Fe.$$scope={dirty:t,ctx:e}),X.$set(Fe);const Oe={};t&2&&(Oe.$$scope={dirty:t,ctx:e}),O.$set(Oe);const Ge={};t&2&&(Ge.$$scope={dirty:t,ctx:e}),G.$set(Ge);const w={};t&2&&(w.$$scope={dirty:t,ctx:e}),D.$set(w);const N={};t&2&&(N.$$scope={dirty:t,ctx:e}),Y.$set(N)},i(e){hs||(f(b.$$.fragment,e),f(J.$$.fragment,e),f(ee.$$.fragment,e),f(le.$$.fragment,e),f(re.$$.fragment,e),f(de.$$.fragment,e),f(ce.$$.fragment,e),f(H.$$.fragment,e),f(me.$$.fragment,e),f(V.$$.fragment,e),f(R.$$.fragment,e),f(pe.$$.fragment,e),f(ue.$$.fragment,e),f(Me.$$.fragment,e),f(fe.$$.fragment,e),f(X.$$.fragment,e),f(he.$$.fragment,e),f(ye.$$.fragment,e),f(_e.$$.fragment,e),f(Te.$$.fragment,e),f(we.$$.fragment,e),f(be.$$.fragment,e),f(Je.$$.fragment,e),f(Ue.$$.fragment,e),f(Ie.$$.fragment,e),f(xe.$$.fragment,e),f(Ae.$$.fragment,e),f(qe.$$.fragment,e),f(Ee.$$.fragment,e),f(Ze.$$.fragment,e),f(Be.$$.fragment,e),f(We.$$.fragment,e),f(Qe.$$.fragment,e),f(O.$$.fragment,e),f(ze.$$.fragment,e),f(G.$$.fragment,e),f(D.$$.fragment,e),f(Se.$$.fragment,e),f(Ve.$$.fragment,e),f(Y.$$.fragment,e),f(Re.$$.fragment,e),f(Xe.$$.fragment,e),hs=!0)},o(e){h(b.$$.fragment,e),h(J.$$.fragment,e),h(ee.$$.fragment,e),h(le.$$.fragment,e),h(re.$$.fragment,e),h(de.$$.fragment,e),h(ce.$$.fragment,e),h(H.$$.fragment,e),h(me.$$.fragment,e),h(V.$$.fragment,e),h(R.$$.fragment,e),h(pe.$$.fragment,e),h(ue.$$.fragment,e),h(Me.$$.fragment,e),h(fe.$$.fragment,e),h(X.$$.fragment,e),h(he.$$.fragment,e),h(ye.$$.fragment,e),h(_e.$$.fragment,e),h(Te.$$.fragment,e),h(we.$$.fragment,e),h(be.$$.fragment,e),h(Je.$$.fragment,e),h(Ue.$$.fragment,e),h(Ie.$$.fragment,e),h(xe.$$.fragment,e),h(Ae.$$.fragment,e),h(qe.$$.fragment,e),h(Ee.$$.fragment,e),h(Ze.$$.fragment,e),h(Be.$$.fragment,e),h(We.$$.fragment,e),h(Qe.$$.fragment,e),h(O.$$.fragment,e),h(ze.$$.fragment,e),h(G.$$.fragment,e),h(D.$$.fragment,e),h(Se.$$.fragment,e),h(Ve.$$.fragment,e),h(Y.$$.fragment,e),h(Re.$$.fragment,e),h(Xe.$$.fragment,e),hs=!1},d(e){e&&(s(_),s(d),s(v),s(m),s(Tt),s(K),s(wt),s(bt),s(te),s($t),s(se),s(Jt),s(ne),s(Ut),s(oe),s(It),s(kt),s(ae),s(jt),s(Ct),s(ie),s(xt),s(At),s(qt),s(Lt),s(I),s(Nt),s(Et),s(ge),s(Zt),s(Bt),s(Wt),s(U),s(Qt),s(zt),s(ve),s(St),s(Ht),s(L),s(Vt),s(Rt),s($e),s(Xt),s(Pt),s(B),s(Ft),s(Ot),s(ke),s(Gt),s(je),s(Dt),s(Ce),s(Yt),s(Kt),s(W),s(es),s(ts),s(Le),s(ss),s(Ne),s(ns),s(os),s(T),s(ls),s(as),s(rs),s(is),s(ds),s(C),s(cs),s(ms),s(He),s(ps),s(gs),s(us),s(Q),s(Ms),s(fs),s(_t)),s(a),y(b,e),y(J,e),y(ee,e),y(le,e),y(re,e),y(de,e),y(ce,e),y(H,e),y(me),y(V),y(R),y(pe,e),y(ue,e),y(Me,e),y(fe),y(X),y(he),y(ye,e),y(_e,e),y(Te),y(we),y(be,e),y(Je,e),y(Ue),y(Ie,e),y(xe,e),y(Ae),y(qe,e),y(Ee,e),y(Ze),y(Be,e),y(We,e),y(Qe,e),y(O,e),y(ze),y(G),y(D),y(Se,e),y(Ve,e),y(Y,e),y(Re),y(Xe,e)}}}const Gn='{"title":"Models","local":"models","sections":[{"title":"Models","local":"models","sections":[{"title":"TransformersModel","local":"smolagents.TransformersModel","sections":[],"depth":3},{"title":"HfApiModel","local":"smolagents.HfApiModel","sections":[],"depth":3},{"title":"LiteLLMModel","local":"smolagents.LiteLLMModel","sections":[],"depth":3},{"title":"OpenAIServerModel","local":"smolagents.OpenAIServerModel","sections":[],"depth":3},{"title":"AzureOpenAIServerModel","local":"smolagents.AzureOpenAIServerModel","sections":[],"depth":3},{"title":"AmazonBedrockServerModel","local":"smolagents.AmazonBedrockServerModel","sections":[],"depth":3},{"title":"MLXModel","local":"smolagents.MLXModel","sections":[],"depth":3},{"title":"VLLMModel","local":"smolagents.VLLMModel","sections":[],"depth":3}],"depth":2}],"depth":1}';function Dn($){return Nn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class oo extends En{constructor(a){super(),Zn(this,a,Dn,On,Ln,{})}}export{oo as component};
